# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from logicmonitor_sdk.models.collector_attribute import CollectorAttribute  # noqa: F401,E501


class AwsDynamodbCollectorAttribute(CollectorAttribute):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'aws_range_value': 'str',
        'aws_query_range_value': 'str',
        'aws_dynamodb_attr_type': 'str',
        'aws_query_range_op': 'str',
        'aws_key_value': 'str',
        'aws_attribute_name': 'str',
        'aws_query_index_type': 'str',
        'aws_query_index_name': 'str',
        'aws_query_key_value': 'str'
    }

    attribute_map = {
        'name': 'name',
        'aws_range_value': 'awsRangeValue',
        'aws_query_range_value': 'awsQueryRangeValue',
        'aws_dynamodb_attr_type': 'awsDynamodbAttrType',
        'aws_query_range_op': 'awsQueryRangeOp',
        'aws_key_value': 'awsKeyValue',
        'aws_attribute_name': 'awsAttributeName',
        'aws_query_index_type': 'awsQueryIndexType',
        'aws_query_index_name': 'awsQueryIndexName',
        'aws_query_key_value': 'awsQueryKeyValue'
    }

    def __init__(self, name=None, aws_range_value=None, aws_query_range_value=None, aws_dynamodb_attr_type=None, aws_query_range_op=None, aws_key_value=None, aws_attribute_name=None, aws_query_index_type=None, aws_query_index_name=None, aws_query_key_value=None):  # noqa: E501
        """AwsDynamodbCollectorAttribute - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._aws_range_value = None
        self._aws_query_range_value = None
        self._aws_dynamodb_attr_type = None
        self._aws_query_range_op = None
        self._aws_key_value = None
        self._aws_attribute_name = None
        self._aws_query_index_type = None
        self._aws_query_index_name = None
        self._aws_query_key_value = None
        self.discriminator = None

        self.name = name
        if aws_range_value is not None:
            self.aws_range_value = aws_range_value
        if aws_query_range_value is not None:
            self.aws_query_range_value = aws_query_range_value
        if aws_dynamodb_attr_type is not None:
            self.aws_dynamodb_attr_type = aws_dynamodb_attr_type
        if aws_query_range_op is not None:
            self.aws_query_range_op = aws_query_range_op
        if aws_key_value is not None:
            self.aws_key_value = aws_key_value
        if aws_attribute_name is not None:
            self.aws_attribute_name = aws_attribute_name
        if aws_query_index_type is not None:
            self.aws_query_index_type = aws_query_index_type
        if aws_query_index_name is not None:
            self.aws_query_index_name = aws_query_index_name
        if aws_query_key_value is not None:
            self.aws_query_key_value = aws_query_key_value

    @property
    def name(self):
        """Gets the name of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The name of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AwsDynamodbCollectorAttribute.


        :param name: The name of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def aws_range_value(self):
        """Gets the aws_range_value of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_range_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_range_value

    @aws_range_value.setter
    def aws_range_value(self, aws_range_value):
        """Sets the aws_range_value of this AwsDynamodbCollectorAttribute.


        :param aws_range_value: The aws_range_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_range_value = aws_range_value

    @property
    def aws_query_range_value(self):
        """Gets the aws_query_range_value of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_query_range_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_query_range_value

    @aws_query_range_value.setter
    def aws_query_range_value(self, aws_query_range_value):
        """Sets the aws_query_range_value of this AwsDynamodbCollectorAttribute.


        :param aws_query_range_value: The aws_query_range_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_query_range_value = aws_query_range_value

    @property
    def aws_dynamodb_attr_type(self):
        """Gets the aws_dynamodb_attr_type of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_dynamodb_attr_type of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_dynamodb_attr_type

    @aws_dynamodb_attr_type.setter
    def aws_dynamodb_attr_type(self, aws_dynamodb_attr_type):
        """Sets the aws_dynamodb_attr_type of this AwsDynamodbCollectorAttribute.


        :param aws_dynamodb_attr_type: The aws_dynamodb_attr_type of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_dynamodb_attr_type = aws_dynamodb_attr_type

    @property
    def aws_query_range_op(self):
        """Gets the aws_query_range_op of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_query_range_op of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_query_range_op

    @aws_query_range_op.setter
    def aws_query_range_op(self, aws_query_range_op):
        """Sets the aws_query_range_op of this AwsDynamodbCollectorAttribute.


        :param aws_query_range_op: The aws_query_range_op of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_query_range_op = aws_query_range_op

    @property
    def aws_key_value(self):
        """Gets the aws_key_value of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_key_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_key_value

    @aws_key_value.setter
    def aws_key_value(self, aws_key_value):
        """Sets the aws_key_value of this AwsDynamodbCollectorAttribute.


        :param aws_key_value: The aws_key_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_key_value = aws_key_value

    @property
    def aws_attribute_name(self):
        """Gets the aws_attribute_name of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_attribute_name of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_attribute_name

    @aws_attribute_name.setter
    def aws_attribute_name(self, aws_attribute_name):
        """Sets the aws_attribute_name of this AwsDynamodbCollectorAttribute.


        :param aws_attribute_name: The aws_attribute_name of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_attribute_name = aws_attribute_name

    @property
    def aws_query_index_type(self):
        """Gets the aws_query_index_type of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_query_index_type of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_query_index_type

    @aws_query_index_type.setter
    def aws_query_index_type(self, aws_query_index_type):
        """Sets the aws_query_index_type of this AwsDynamodbCollectorAttribute.


        :param aws_query_index_type: The aws_query_index_type of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_query_index_type = aws_query_index_type

    @property
    def aws_query_index_name(self):
        """Gets the aws_query_index_name of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_query_index_name of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_query_index_name

    @aws_query_index_name.setter
    def aws_query_index_name(self, aws_query_index_name):
        """Sets the aws_query_index_name of this AwsDynamodbCollectorAttribute.


        :param aws_query_index_name: The aws_query_index_name of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_query_index_name = aws_query_index_name

    @property
    def aws_query_key_value(self):
        """Gets the aws_query_key_value of this AwsDynamodbCollectorAttribute.  # noqa: E501


        :return: The aws_query_key_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :rtype: str
        """
        return self._aws_query_key_value

    @aws_query_key_value.setter
    def aws_query_key_value(self, aws_query_key_value):
        """Sets the aws_query_key_value of this AwsDynamodbCollectorAttribute.


        :param aws_query_key_value: The aws_query_key_value of this AwsDynamodbCollectorAttribute.  # noqa: E501
        :type: str
        """

        self._aws_query_key_value = aws_query_key_value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AwsDynamodbCollectorAttribute, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AwsDynamodbCollectorAttribute):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
