# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Assignment(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'group_name': 'str',
        'tag_value': 'str',
        'action': 'str',
        'disable_alerting': 'bool',
        'tag_key': 'str',
        'group': 'int'
    }

    attribute_map = {
        'group_name': 'groupName',
        'tag_value': 'tagValue',
        'action': 'action',
        'disable_alerting': 'disableAlerting',
        'tag_key': 'tagKey',
        'group': 'group'
    }

    def __init__(self, group_name=None, tag_value=None, action=None, disable_alerting=None, tag_key=None, group=None):  # noqa: E501
        """Assignment - a model defined in Swagger"""  # noqa: E501

        self._group_name = None
        self._tag_value = None
        self._action = None
        self._disable_alerting = None
        self._tag_key = None
        self._group = None
        self.discriminator = None

        if group_name is not None:
            self.group_name = group_name
        if tag_value is not None:
            self.tag_value = tag_value
        if action is not None:
            self.action = action
        if disable_alerting is not None:
            self.disable_alerting = disable_alerting
        if tag_key is not None:
            self.tag_key = tag_key
        if group is not None:
            self.group = group

    @property
    def group_name(self):
        """Gets the group_name of this Assignment.  # noqa: E501

        The name of the group that discovered devices should be added into  # noqa: E501

        :return: The group_name of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """Sets the group_name of this Assignment.

        The name of the group that discovered devices should be added into  # noqa: E501

        :param group_name: The group_name of this Assignment.  # noqa: E501
        :type: str
        """

        self._group_name = group_name

    @property
    def tag_value(self):
        """Gets the tag_value of this Assignment.  # noqa: E501


        :return: The tag_value of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._tag_value

    @tag_value.setter
    def tag_value(self, tag_value):
        """Sets the tag_value of this Assignment.


        :param tag_value: The tag_value of this Assignment.  # noqa: E501
        :type: str
        """

        self._tag_value = tag_value

    @property
    def action(self):
        """Gets the action of this Assignment.  # noqa: E501

        Whether or not specified devices should be included or excluded  # noqa: E501

        :return: The action of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this Assignment.

        Whether or not specified devices should be included or excluded  # noqa: E501

        :param action: The action of this Assignment.  # noqa: E501
        :type: str
        """

        self._action = action

    @property
    def disable_alerting(self):
        """Gets the disable_alerting of this Assignment.  # noqa: E501

        Whether or not alerting should be disabled for discovered devices  # noqa: E501

        :return: The disable_alerting of this Assignment.  # noqa: E501
        :rtype: bool
        """
        return self._disable_alerting

    @disable_alerting.setter
    def disable_alerting(self, disable_alerting):
        """Sets the disable_alerting of this Assignment.

        Whether or not alerting should be disabled for discovered devices  # noqa: E501

        :param disable_alerting: The disable_alerting of this Assignment.  # noqa: E501
        :type: bool
        """

        self._disable_alerting = disable_alerting

    @property
    def tag_key(self):
        """Gets the tag_key of this Assignment.  # noqa: E501


        :return: The tag_key of this Assignment.  # noqa: E501
        :rtype: str
        """
        return self._tag_key

    @tag_key.setter
    def tag_key(self, tag_key):
        """Sets the tag_key of this Assignment.


        :param tag_key: The tag_key of this Assignment.  # noqa: E501
        :type: str
        """

        self._tag_key = tag_key

    @property
    def group(self):
        """Gets the group of this Assignment.  # noqa: E501

        The ID of the group that discovered devices should be added into  # noqa: E501

        :return: The group of this Assignment.  # noqa: E501
        :rtype: int
        """
        return self._group

    @group.setter
    def group(self, group):
        """Sets the group of this Assignment.

        The ID of the group that discovered devices should be added into  # noqa: E501

        :param group: The group of this Assignment.  # noqa: E501
        :type: int
        """

        self._group = group

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Assignment, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Assignment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
