# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ApiPerfMetrics(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'summary': 'str',
        'total_waiting_requests': 'int',
        'tot_nano_time': 'int',
        'total_processed_requests': 'int',
        'total_requests': 'int',
        'api': 'str',
        'max_nano_time': 'int',
        'tags': 'list[str]'
    }

    attribute_map = {
        'summary': 'summary',
        'total_waiting_requests': 'totalWaitingRequests',
        'tot_nano_time': 'totNanoTime',
        'total_processed_requests': 'totalProcessedRequests',
        'total_requests': 'totalRequests',
        'api': 'api',
        'max_nano_time': 'maxNanoTime',
        'tags': 'tags'
    }

    def __init__(self, summary=None, total_waiting_requests=None, tot_nano_time=None, total_processed_requests=None, total_requests=None, api=None, max_nano_time=None, tags=None):  # noqa: E501
        """ApiPerfMetrics - a model defined in Swagger"""  # noqa: E501

        self._summary = None
        self._total_waiting_requests = None
        self._tot_nano_time = None
        self._total_processed_requests = None
        self._total_requests = None
        self._api = None
        self._max_nano_time = None
        self._tags = None
        self.discriminator = None

        if summary is not None:
            self.summary = summary
        if total_waiting_requests is not None:
            self.total_waiting_requests = total_waiting_requests
        if tot_nano_time is not None:
            self.tot_nano_time = tot_nano_time
        if total_processed_requests is not None:
            self.total_processed_requests = total_processed_requests
        if total_requests is not None:
            self.total_requests = total_requests
        if api is not None:
            self.api = api
        if max_nano_time is not None:
            self.max_nano_time = max_nano_time
        if tags is not None:
            self.tags = tags

    @property
    def summary(self):
        """Gets the summary of this ApiPerfMetrics.  # noqa: E501

        api's summary defined in swagger.json  # noqa: E501

        :return: The summary of this ApiPerfMetrics.  # noqa: E501
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """Sets the summary of this ApiPerfMetrics.

        api's summary defined in swagger.json  # noqa: E501

        :param summary: The summary of this ApiPerfMetrics.  # noqa: E501
        :type: str
        """

        self._summary = summary

    @property
    def total_waiting_requests(self):
        """Gets the total_waiting_requests of this ApiPerfMetrics.  # noqa: E501

        total waiting requests  # noqa: E501

        :return: The total_waiting_requests of this ApiPerfMetrics.  # noqa: E501
        :rtype: int
        """
        return self._total_waiting_requests

    @total_waiting_requests.setter
    def total_waiting_requests(self, total_waiting_requests):
        """Sets the total_waiting_requests of this ApiPerfMetrics.

        total waiting requests  # noqa: E501

        :param total_waiting_requests: The total_waiting_requests of this ApiPerfMetrics.  # noqa: E501
        :type: int
        """

        self._total_waiting_requests = total_waiting_requests

    @property
    def tot_nano_time(self):
        """Gets the tot_nano_time of this ApiPerfMetrics.  # noqa: E501

        total time taken to process requests  # noqa: E501

        :return: The tot_nano_time of this ApiPerfMetrics.  # noqa: E501
        :rtype: int
        """
        return self._tot_nano_time

    @tot_nano_time.setter
    def tot_nano_time(self, tot_nano_time):
        """Sets the tot_nano_time of this ApiPerfMetrics.

        total time taken to process requests  # noqa: E501

        :param tot_nano_time: The tot_nano_time of this ApiPerfMetrics.  # noqa: E501
        :type: int
        """

        self._tot_nano_time = tot_nano_time

    @property
    def total_processed_requests(self):
        """Gets the total_processed_requests of this ApiPerfMetrics.  # noqa: E501

        total processed requests  # noqa: E501

        :return: The total_processed_requests of this ApiPerfMetrics.  # noqa: E501
        :rtype: int
        """
        return self._total_processed_requests

    @total_processed_requests.setter
    def total_processed_requests(self, total_processed_requests):
        """Sets the total_processed_requests of this ApiPerfMetrics.

        total processed requests  # noqa: E501

        :param total_processed_requests: The total_processed_requests of this ApiPerfMetrics.  # noqa: E501
        :type: int
        """

        self._total_processed_requests = total_processed_requests

    @property
    def total_requests(self):
        """Gets the total_requests of this ApiPerfMetrics.  # noqa: E501

        total requests  # noqa: E501

        :return: The total_requests of this ApiPerfMetrics.  # noqa: E501
        :rtype: int
        """
        return self._total_requests

    @total_requests.setter
    def total_requests(self, total_requests):
        """Sets the total_requests of this ApiPerfMetrics.

        total requests  # noqa: E501

        :param total_requests: The total_requests of this ApiPerfMetrics.  # noqa: E501
        :type: int
        """

        self._total_requests = total_requests

    @property
    def api(self):
        """Gets the api of this ApiPerfMetrics.  # noqa: E501

        api name  # noqa: E501

        :return: The api of this ApiPerfMetrics.  # noqa: E501
        :rtype: str
        """
        return self._api

    @api.setter
    def api(self, api):
        """Sets the api of this ApiPerfMetrics.

        api name  # noqa: E501

        :param api: The api of this ApiPerfMetrics.  # noqa: E501
        :type: str
        """

        self._api = api

    @property
    def max_nano_time(self):
        """Gets the max_nano_time of this ApiPerfMetrics.  # noqa: E501

        Max time taken to process a request  # noqa: E501

        :return: The max_nano_time of this ApiPerfMetrics.  # noqa: E501
        :rtype: int
        """
        return self._max_nano_time

    @max_nano_time.setter
    def max_nano_time(self, max_nano_time):
        """Sets the max_nano_time of this ApiPerfMetrics.

        Max time taken to process a request  # noqa: E501

        :param max_nano_time: The max_nano_time of this ApiPerfMetrics.  # noqa: E501
        :type: int
        """

        self._max_nano_time = max_nano_time

    @property
    def tags(self):
        """Gets the tags of this ApiPerfMetrics.  # noqa: E501

        api tags  # noqa: E501

        :return: The tags of this ApiPerfMetrics.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this ApiPerfMetrics.

        api tags  # noqa: E501

        :param tags: The tags of this ApiPerfMetrics.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ApiPerfMetrics, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApiPerfMetrics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
