# coding: utf-8

"""
    LogicMonitor REST API

    LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.  # noqa: E501

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from logicmonitor_sdk.api_client import ApiClient


class LMApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def ack_alert_by_id(self, body, id, **kwargs):  # noqa: E501
        """ack alert by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ack_alert_by_id(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertAck body: (required)
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ack_alert_by_id_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.ack_alert_by_id_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def ack_alert_by_id_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """ack alert by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ack_alert_by_id_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertAck body: (required)
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ack_alert_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `ack_alert_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `ack_alert_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/alert/alerts/{id}/ack', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ack_collector_down_alert_by_id(self, id, body, **kwargs):  # noqa: E501
        """ack collector down alert  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ack_collector_down_alert_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param AckCollectorDown body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ack_collector_down_alert_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.ack_collector_down_alert_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def ack_collector_down_alert_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """ack collector down alert  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ack_collector_down_alert_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param AckCollectorDown body: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ack_collector_down_alert_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `ack_collector_down_alert_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `ack_collector_down_alert_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `ack_collector_down_alert_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors/{id}/ackdown', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_admin(self, body, **kwargs):  # noqa: E501
        """add user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_admin(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Admin body: (required)
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_admin_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_admin_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_admin_with_http_info(self, body, **kwargs):  # noqa: E501
        """add user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_admin_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Admin body: (required)
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_admin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_admin`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Admin'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_alert_note_by_id(self, body, id, **kwargs):  # noqa: E501
        """add alert note  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_alert_note_by_id(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertAck body: (required)
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_alert_note_by_id_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_alert_note_by_id_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def add_alert_note_by_id_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """add alert note  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_alert_note_by_id_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertAck body: (required)
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_alert_note_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_alert_note_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `add_alert_note_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/alert/alerts/{id}/note', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_alert_rule(self, body, **kwargs):  # noqa: E501
        """add alert rule  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_alert_rule(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertRule body: (required)
        :return: AlertRule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_alert_rule_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_alert_rule_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_alert_rule_with_http_info(self, body, **kwargs):  # noqa: E501
        """add alert rule  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_alert_rule_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlertRule body: (required)
        :return: AlertRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_alert_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_alert_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertRule'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_api_token_by_admin_id(self, admin_id, body, **kwargs):  # noqa: E501
        """add api tokens for a user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_api_token_by_admin_id(admin_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param APIToken body: (required)
        :param str type:
        :return: APIToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_api_token_by_admin_id_with_http_info(admin_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_api_token_by_admin_id_with_http_info(admin_id, body, **kwargs)  # noqa: E501
            return data

    def add_api_token_by_admin_id_with_http_info(self, admin_id, body, **kwargs):  # noqa: E501
        """add api tokens for a user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_api_token_by_admin_id_with_http_info(admin_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param APIToken body: (required)
        :param str type:
        :return: APIToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['admin_id', 'body', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_api_token_by_admin_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_id' is set
        if ('admin_id' not in params or
                params['admin_id'] is None):
            raise ValueError("Missing the required parameter `admin_id` when calling `add_api_token_by_admin_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_api_token_by_admin_id`")  # noqa: E501

        if 'admin_id' in params and not re.search('\d+', params['admin_id'] if type(params['admin_id']) is str else str(params['admin_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `admin_id` when calling `add_api_token_by_admin_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'admin_id' in params:
            path_params['adminId'] = params['admin_id']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'APIToken'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{adminId}/apitokens', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_applies_to_function(self, **kwargs):  # noqa: E501
        """add applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_applies_to_function(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AppliesToFunction body:
        :return: AppliesToFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_applies_to_function_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_applies_to_function_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_applies_to_function_with_http_info(self, **kwargs):  # noqa: E501
        """add applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_applies_to_function_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AppliesToFunction body:
        :return: AppliesToFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_applies_to_function" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AppliesToFunction'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/functions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_collector(self, body, **kwargs):  # noqa: E501
        """add collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_collector(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Collector body: (required)
        :return: Collector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_collector_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_collector_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_collector_with_http_info(self, body, **kwargs):  # noqa: E501
        """add collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_collector_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Collector body: (required)
        :return: Collector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_collector" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_collector`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Collector'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_collector_group(self, body, **kwargs):  # noqa: E501
        """add collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_collector_group(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CollectorGroup body: (required)
        :return: CollectorGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_collector_group_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_collector_group_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_collector_group_with_http_info(self, body, **kwargs):  # noqa: E501
        """add collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_collector_group_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CollectorGroup body: (required)
        :return: CollectorGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_collector_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_collector_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'CollectorGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_dashboard(self, body, **kwargs):  # noqa: E501
        """add dashboard  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_dashboard(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Dashboard body: (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_dashboard_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_dashboard_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_dashboard_with_http_info(self, body, **kwargs):  # noqa: E501
        """add dashboard  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_dashboard_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Dashboard body: (required)
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_dashboard" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_dashboard`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Dashboard'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/dashboards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_dashboard_group(self, body, **kwargs):  # noqa: E501
        """add dashboard group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_dashboard_group(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DashboardGroup body: (required)
        :return: DashboardGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_dashboard_group_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_dashboard_group_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_dashboard_group_with_http_info(self, body, **kwargs):  # noqa: E501
        """add dashboard group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_dashboard_group_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DashboardGroup body: (required)
        :return: DashboardGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_dashboard_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_dashboard_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DashboardGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device(self, body, **kwargs):  # noqa: E501
        """add a new device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Device body: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param bool add_from_wizard:
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_device_with_http_info(self, body, **kwargs):  # noqa: E501
        """add a new device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Device body: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param bool add_from_wizard:
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'start', 'end', 'netflow_filter', 'add_from_wizard']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'add_from_wizard' in params:
            query_params.append(('addFromWizard', params['add_from_wizard']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Device'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device_datasource_instance(self, device_id, hds_id, body, **kwargs):  # noqa: E501
        """add device instance   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_datasource_instance(device_id, hds_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param DeviceDataSourceInstance body: (required)
        :return: DeviceDataSourceInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_datasource_instance_with_http_info(device_id, hds_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_datasource_instance_with_http_info(device_id, hds_id, body, **kwargs)  # noqa: E501
            return data

    def add_device_datasource_instance_with_http_info(self, device_id, hds_id, body, **kwargs):  # noqa: E501
        """add device instance   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_datasource_instance_with_http_info(device_id, hds_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param DeviceDataSourceInstance body: (required)
        :return: DeviceDataSourceInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device_datasource_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `add_device_datasource_instance`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `add_device_datasource_instance`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device_datasource_instance`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `add_device_datasource_instance`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `add_device_datasource_instance`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstance'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device_datasource_instance_group(self, device_id, device_ds_id, body, **kwargs):  # noqa: E501
        """add device datasource instance group   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_datasource_instance_group(device_id, device_ds_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param DeviceDataSourceInstanceGroup body: (required)
        :return: DeviceDataSourceInstanceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_datasource_instance_group_with_http_info(device_id, device_ds_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_datasource_instance_group_with_http_info(device_id, device_ds_id, body, **kwargs)  # noqa: E501
            return data

    def add_device_datasource_instance_group_with_http_info(self, device_id, device_ds_id, body, **kwargs):  # noqa: E501
        """add device datasource instance group   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_datasource_instance_group_with_http_info(device_id, device_ds_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param DeviceDataSourceInstanceGroup body: (required)
        :return: DeviceDataSourceInstanceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'device_ds_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device_datasource_instance_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `add_device_datasource_instance_group`")  # noqa: E501
        # verify the required parameter 'device_ds_id' is set
        if ('device_ds_id' not in params or
                params['device_ds_id'] is None):
            raise ValueError("Missing the required parameter `device_ds_id` when calling `add_device_datasource_instance_group`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device_datasource_instance_group`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `add_device_datasource_instance_group`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'device_ds_id' in params and not re.search('\d+', params['device_ds_id'] if type(params['device_ds_id']) is str else str(params['device_ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_ds_id` when calling `add_device_datasource_instance_group`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'device_ds_id' in params:
            path_params['deviceDsId'] = params['device_ds_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device_group(self, body, **kwargs):  # noqa: E501
        """add device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_group(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceGroup body: (required)
        :return: DeviceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_group_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_group_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_device_group_with_http_info(self, body, **kwargs):  # noqa: E501
        """add device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_group_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceGroup body: (required)
        :return: DeviceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device_group_cluster_alert_conf(self, device_group_id, body, **kwargs):  # noqa: E501
        """Add cluster alert configuration  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_group_cluster_alert_conf(device_group_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param DeviceClusterAlertConfig body: (required)
        :return: DeviceClusterAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_group_cluster_alert_conf_with_http_info(device_group_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_group_cluster_alert_conf_with_http_info(device_group_id, body, **kwargs)  # noqa: E501
            return data

    def add_device_group_cluster_alert_conf_with_http_info(self, device_group_id, body, **kwargs):  # noqa: E501
        """Add cluster alert configuration  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_group_cluster_alert_conf_with_http_info(device_group_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param DeviceClusterAlertConfig body: (required)
        :return: DeviceClusterAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device_group_cluster_alert_conf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `add_device_group_cluster_alert_conf`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device_group_cluster_alert_conf`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `add_device_group_cluster_alert_conf`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceClusterAlertConfig'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/clusterAlertConf', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device_group_property(self, gid, body, **kwargs):  # noqa: E501
        """add device group property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_group_property(gid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_group_property_with_http_info(gid, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_group_property_with_http_info(gid, body, **kwargs)  # noqa: E501
            return data

    def add_device_group_property_with_http_info(self, gid, body, **kwargs):  # noqa: E501
        """add device group property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_group_property_with_http_info(gid, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device_group_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `add_device_group_property`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device_group_property`")  # noqa: E501

        if 'gid' in params and not re.search('\d+', params['gid'] if type(params['gid']) is str else str(params['gid'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gid` when calling `add_device_group_property`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EntityProperty'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{gid}/properties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_device_property(self, device_id, body, **kwargs):  # noqa: E501
        """add device property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_property(device_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_device_property_with_http_info(device_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_device_property_with_http_info(device_id, body, **kwargs)  # noqa: E501
            return data

    def add_device_property_with_http_info(self, device_id, body, **kwargs):  # noqa: E501
        """add device property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_device_property_with_http_info(device_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_device_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `add_device_property`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_device_property`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `add_device_property`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EntityProperty'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/properties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_escalation_chain(self, body, **kwargs):  # noqa: E501
        """add escalation chain  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_escalation_chain(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EscalatingChain body: (required)
        :return: EscalatingChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_escalation_chain_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_escalation_chain_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_escalation_chain_with_http_info(self, body, **kwargs):  # noqa: E501
        """add escalation chain  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_escalation_chain_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EscalatingChain body: (required)
        :return: EscalatingChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_escalation_chain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_escalation_chain`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EscalatingChain'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/chains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_netscan(self, **kwargs):  # noqa: E501
        """add a new netscan  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_netscan(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Netscan body:
        :return: Netscan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_netscan_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_netscan_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_netscan_with_http_info(self, **kwargs):  # noqa: E501
        """add a new netscan  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_netscan_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Netscan body:
        :return: Netscan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_netscan" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Netscan'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/netscans', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_ops_note(self, body, **kwargs):  # noqa: E501
        """add opsnote  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_ops_note(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpsNote body: (required)
        :return: OpsNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_ops_note_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_ops_note_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_ops_note_with_http_info(self, body, **kwargs):  # noqa: E501
        """add opsnote  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_ops_note_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpsNote body: (required)
        :return: OpsNote
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ops_note" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_ops_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'OpsNote'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/opsnotes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_recipient_group(self, body, **kwargs):  # noqa: E501
        """add recipient group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_recipient_group(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipientGroup body: (required)
        :return: RecipientGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_recipient_group_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_recipient_group_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_recipient_group_with_http_info(self, body, **kwargs):  # noqa: E501
        """add recipient group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_recipient_group_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RecipientGroup body: (required)
        :return: RecipientGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_recipient_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_recipient_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'RecipientGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/recipientgroups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_report(self, body, **kwargs):  # noqa: E501
        """add report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_report(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportBase body: (required)
        :return: ReportBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_report_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_report_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_report_with_http_info(self, body, **kwargs):  # noqa: E501
        """add report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_report_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportBase body: (required)
        :return: ReportBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportBase'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/reports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_report_group(self, body, **kwargs):  # noqa: E501
        """add report group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_report_group(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportGroup body: (required)
        :return: ReportGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_report_group_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_report_group_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_report_group_with_http_info(self, body, **kwargs):  # noqa: E501
        """add report group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_report_group_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ReportGroup body: (required)
        :return: ReportGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_report_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_report_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_role(self, body, **kwargs):  # noqa: E501
        """add role  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Role body: (required)
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_role_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_role_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_role_with_http_info(self, body, **kwargs):  # noqa: E501
        """add role  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Role body: (required)
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Role'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_sdt(self, body, **kwargs):  # noqa: E501
        """add SDT  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_sdt(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SDT body: (required)
        :return: SDT
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_sdt_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_sdt_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_sdt_with_http_info(self, body, **kwargs):  # noqa: E501
        """add SDT  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_sdt_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SDT body: (required)
        :return: SDT
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_sdt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_sdt`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDT'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/sdt/sdts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_website(self, body, **kwargs):  # noqa: E501
        """add website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_website(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Website body: (required)
        :return: Website
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_website_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_website_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_website_with_http_info(self, body, **kwargs):  # noqa: E501
        """add website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_website_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Website body: (required)
        :return: Website
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_website" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_website`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Website'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_website_group(self, body, **kwargs):  # noqa: E501
        """add website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_website_group(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebsiteGroup body: (required)
        :return: WebsiteGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_website_group_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_website_group_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_website_group_with_http_info(self, body, **kwargs):  # noqa: E501
        """add website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_website_group_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param WebsiteGroup body: (required)
        :return: WebsiteGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_website_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_website_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_widget(self, body, **kwargs):  # noqa: E501
        """add widget  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_widget(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Widget body: (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_widget_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_widget_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_widget_with_http_info(self, body, **kwargs):  # noqa: E501
        """add widget  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_widget_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Widget body: (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_widget" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_widget`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Widget'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/widgets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def collect_device_config_source_config(self, device_id, hds_id, instance_id, **kwargs):  # noqa: E501
        """collect a config for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_device_config_source_config(device_id, hds_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: (required)
        :param int instance_id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.collect_device_config_source_config_with_http_info(device_id, hds_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.collect_device_config_source_config_with_http_info(device_id, hds_id, instance_id, **kwargs)  # noqa: E501
            return data

    def collect_device_config_source_config_with_http_info(self, device_id, hds_id, instance_id, **kwargs):  # noqa: E501
        """collect a config for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.collect_device_config_source_config_with_http_info(device_id, hds_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: (required)
        :param int instance_id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_device_config_source_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `collect_device_config_source_config`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `collect_device_config_source_config`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `collect_device_config_source_config`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `collect_device_config_source_config`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `collect_device_config_source_config`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `collect_device_config_source_config`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/config/collectNow', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_admin_by_id(self, id, **kwargs):  # noqa: E501
        """delete user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_admin_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_admin_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_admin_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_admin_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_admin_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_admin_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_admin_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_admin_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_alert_rule_by_id(self, id, **kwargs):  # noqa: E501
        """delete alert rule  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_rule_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_alert_rule_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_alert_rule_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_alert_rule_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete alert rule  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_alert_rule_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alert_rule_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_alert_rule_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_alert_rule_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/rules/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_api_token_by_id(self, admin_id, apitoken_id, **kwargs):  # noqa: E501
        """delete apiToken  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_token_by_id(admin_id, apitoken_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param int apitoken_id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_api_token_by_id_with_http_info(admin_id, apitoken_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_api_token_by_id_with_http_info(admin_id, apitoken_id, **kwargs)  # noqa: E501
            return data

    def delete_api_token_by_id_with_http_info(self, admin_id, apitoken_id, **kwargs):  # noqa: E501
        """delete apiToken  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_token_by_id_with_http_info(admin_id, apitoken_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param int apitoken_id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['admin_id', 'apitoken_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_token_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_id' is set
        if ('admin_id' not in params or
                params['admin_id'] is None):
            raise ValueError("Missing the required parameter `admin_id` when calling `delete_api_token_by_id`")  # noqa: E501
        # verify the required parameter 'apitoken_id' is set
        if ('apitoken_id' not in params or
                params['apitoken_id'] is None):
            raise ValueError("Missing the required parameter `apitoken_id` when calling `delete_api_token_by_id`")  # noqa: E501

        if 'admin_id' in params and not re.search('\d+', params['admin_id'] if type(params['admin_id']) is str else str(params['admin_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `admin_id` when calling `delete_api_token_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'apitoken_id' in params and not re.search('\d+', params['apitoken_id'] if type(params['apitoken_id']) is str else str(params['apitoken_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `apitoken_id` when calling `delete_api_token_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'admin_id' in params:
            path_params['adminId'] = params['admin_id']  # noqa: E501
        if 'apitoken_id' in params:
            path_params['apitokenId'] = params['apitoken_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{adminId}/apitokens/{apitokenId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_applies_to_function_by_id(self, id, **kwargs):  # noqa: E501
        """delete applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_applies_to_function_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool ignore_reference:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_applies_to_function_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_applies_to_function_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_applies_to_function_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_applies_to_function_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool ignore_reference:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'ignore_reference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_applies_to_function_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_applies_to_function_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_applies_to_function_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'ignore_reference' in params:
            query_params.append(('ignoreReference', params['ignore_reference']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/functions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_collector_by_id(self, id, **kwargs):  # noqa: E501
        """delete collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collector_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_collector_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_collector_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_collector_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collector_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collector_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_collector_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_collector_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_collector_group_by_id(self, id, **kwargs):  # noqa: E501
        """delete collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collector_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_collector_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_collector_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_collector_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_collector_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collector_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_collector_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_collector_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/groups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dashboard_by_id(self, id, **kwargs):  # noqa: E501
        """delete dashboard  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboard_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboard_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_dashboard_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete dashboard  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dashboard_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_dashboard_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_dashboard_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/dashboards/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dashboard_group_by_id(self, id, **kwargs):  # noqa: E501
        """delete dashboard group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool allow_non_empty_group:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dashboard_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dashboard_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_dashboard_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete dashboard group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dashboard_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool allow_non_empty_group:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'allow_non_empty_group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dashboard_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_dashboard_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_dashboard_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'allow_non_empty_group' in params:
            query_params.append(('allowNonEmptyGroup', params['allow_non_empty_group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/groups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_datasource_by_id(self, id, **kwargs):  # noqa: E501
        """delete datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datasource_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_datasource_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_datasource_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_datasource_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datasource_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_datasource_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_datasource_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_by_id(self, id, **kwargs):  # noqa: E501
        """delete a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param bool delete_hard:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_device_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param bool delete_hard:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'delete_hard']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_device_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_device_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'delete_hard' in params:
            query_params.append(('deleteHard', params['delete_hard']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_datasource_instance_by_id(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """delete a device instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_datasource_instance_by_id(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
            return data

    def delete_device_datasource_instance_by_id_with_http_info(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """delete a device instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_datasource_instance_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `delete_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `delete_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_device_datasource_instance_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `delete_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `delete_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_group_by_id(self, id, **kwargs):  # noqa: E501
        """delete device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool delete_children:
        :param bool delete_hard:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_device_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool delete_children:
        :param bool delete_hard:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'delete_children', 'delete_hard']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_device_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_device_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'delete_children' in params:
            query_params.append(('deleteChildren', params['delete_children']))  # noqa: E501
        if 'delete_hard' in params:
            query_params.append(('deleteHard', params['delete_hard']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_group_cluster_alert_conf_by_id(self, device_group_id, id, **kwargs):  # noqa: E501
        """Delete cluster alert configuration  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_cluster_alert_conf_by_id(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
            return data

    def delete_device_group_cluster_alert_conf_by_id_with_http_info(self, device_group_id, id, **kwargs):  # noqa: E501
        """Delete cluster alert configuration  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_group_cluster_alert_conf_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `delete_device_group_cluster_alert_conf_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_device_group_cluster_alert_conf_by_id`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `delete_device_group_cluster_alert_conf_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_device_group_cluster_alert_conf_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/clusterAlertConf/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_group_property_by_name(self, gid, name, **kwargs):  # noqa: E501
        """delete device group property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_property_by_name(gid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str name: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_group_property_by_name_with_http_info(gid, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_group_property_by_name_with_http_info(gid, name, **kwargs)  # noqa: E501
            return data

    def delete_device_group_property_by_name_with_http_info(self, gid, name, **kwargs):  # noqa: E501
        """delete device group property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_group_property_by_name_with_http_info(gid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str name: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_group_property_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `delete_device_group_property_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_device_group_property_by_name`")  # noqa: E501

        if 'gid' in params and not re.search('\d+', params['gid'] if type(params['gid']) is str else str(params['gid'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gid` when calling `delete_device_group_property_by_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'name' in params and not re.search('[^\/]+', params['name'] if type(params['name']) is str else str(params['name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `name` when calling `delete_device_group_property_by_name`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{gid}/properties/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_device_property_by_name(self, device_id, name, **kwargs):  # noqa: E501
        """delete device property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_property_by_name(device_id, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str name: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_device_property_by_name_with_http_info(device_id, name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_device_property_by_name_with_http_info(device_id, name, **kwargs)  # noqa: E501
            return data

    def delete_device_property_by_name_with_http_info(self, device_id, name, **kwargs):  # noqa: E501
        """delete device property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_device_property_by_name_with_http_info(device_id, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str name: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_device_property_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `delete_device_property_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_device_property_by_name`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `delete_device_property_by_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'name' in params and not re.search('[^\/]+', params['name'] if type(params['name']) is str else str(params['name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `name` when calling `delete_device_property_by_name`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/properties/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_escalation_chain_by_id(self, id, **kwargs):  # noqa: E501
        """delete escalation chain  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_escalation_chain_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_escalation_chain_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_escalation_chain_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_escalation_chain_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete escalation chain  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_escalation_chain_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_escalation_chain_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_escalation_chain_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_escalation_chain_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/chains/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_netscan_by_id(self, id, **kwargs):  # noqa: E501
        """delete a netscan  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_netscan_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_netscan_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_netscan_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_netscan_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete a netscan  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_netscan_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_netscan_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_netscan_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_netscan_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/netscans/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ops_note_by_id(self, id, **kwargs):  # noqa: E501
        """delete opsnote  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ops_note_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_ops_note_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ops_note_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_ops_note_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete opsnote  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ops_note_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ops_note_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_ops_note_by_id`")  # noqa: E501

        if 'id' in params and not re.search('[^\/]+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_ops_note_by_id`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/opsnotes/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_recipient_group_by_id(self, id, **kwargs):  # noqa: E501
        """delete recipient group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_recipient_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_recipient_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_recipient_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_recipient_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete recipient group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_recipient_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipient_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_recipient_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_recipient_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/recipientgroups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_report_by_id(self, id, **kwargs):  # noqa: E501
        """delete report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_report_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_report_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_report_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_report_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_report_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_report_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/reports/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_report_group_by_id(self, id, **kwargs):  # noqa: E501
        """delete report group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_report_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_report_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_report_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_report_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete report group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_report_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_report_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_report_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_report_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/groups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_by_id(self, id, **kwargs):  # noqa: E501
        """delete role  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_role_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete role  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_role_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_role_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/roles/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sdt_by_id(self, id, **kwargs):  # noqa: E501
        """delete SDT  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sdt_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sdt_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sdt_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_sdt_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete SDT  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sdt_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sdt_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_sdt_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/sdt/sdts/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_website_by_id(self, id, **kwargs):  # noqa: E501
        """delete website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_website_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_website_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_website_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_website_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_website_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_website_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_website_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_website_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_website_group_by_id(self, id, **kwargs):  # noqa: E501
        """delete website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_website_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int delete_children:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_website_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_website_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_website_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_website_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int delete_children:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'delete_children']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_website_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_website_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_website_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'delete_children' in params:
            query_params.append(('deleteChildren', params['delete_children']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_widget_by_id(self, id, **kwargs):  # noqa: E501
        """delete widget  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_widget_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_widget_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_widget_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_widget_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """delete widget  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_widget_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_widget_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_widget_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `delete_widget_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/widgets/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def execute_debug_command(self, **kwargs):  # noqa: E501
        """Execute a Collector debug command  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execute_debug_command(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Debug body:
        :param int collector_id:
        :return: Debug
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.execute_debug_command_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.execute_debug_command_with_http_info(**kwargs)  # noqa: E501
            return data

    def execute_debug_command_with_http_info(self, **kwargs):  # noqa: E501
        """Execute a Collector debug command  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execute_debug_command_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Debug body:
        :param int collector_id:
        :return: Debug
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collector_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execute_debug_command" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'collector_id' in params:
            query_params.append(('collectorId', params['collector_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Debug'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/debug', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fetch_device_instances_data(self, body, **kwargs):  # noqa: E501
        """fetch device instances data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_device_instances_data(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceInstances body: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str aggregate: the aggregate option
        :return: DeviceInstanceDataPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.fetch_device_instances_data_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.fetch_device_instances_data_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def fetch_device_instances_data_with_http_info(self, body, **kwargs):  # noqa: E501
        """fetch device instances data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fetch_device_instances_data_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeviceInstances body: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str aggregate: the aggregate option
        :return: DeviceInstanceDataPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'period', 'start', 'end', 'aggregate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fetch_device_instances_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `fetch_device_instances_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceInstanceDataPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/instances/datafetch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_report_by_id(self, id, **kwargs):  # noqa: E501
        """run a report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_report_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param GenerateReportRequest body:
        :return: GenerateReportResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def generate_report_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """run a report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_report_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param GenerateReportRequest body:
        :return: GenerateReportResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_report_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `generate_report_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `generate_report_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GenerateReportResult'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/reports/{id}/executions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_admin_by_id(self, id, **kwargs):  # noqa: E501
        """get user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_admin_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_admin_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_admin_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_admin_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_admin_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_admin_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_admin_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_admin_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Admin'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_admin_list(self, **kwargs):  # noqa: E501
        """get user list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_admin_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AdminPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_admin_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_admin_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_admin_list_with_http_info(self, **kwargs):  # noqa: E501
        """get user list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_admin_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AdminPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_admin_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AdminPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_by_id(self, id, **kwargs):  # noqa: E501
        """get alert  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param bool need_message:
        :param str custom_columns:
        :param str fields:
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_alert_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get alert  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param bool need_message:
        :param str custom_columns:
        :param str fields:
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'need_message', 'custom_columns', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_alert_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'need_message' in params:
            query_params.append(('needMessage', params['need_message']))  # noqa: E501
        if 'custom_columns' in params:
            query_params.append(('customColumns', params['custom_columns']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Alert'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/alert/alerts/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_list(self, **kwargs):  # noqa: E501
        """get alert list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_alert_list_with_http_info(self, **kwargs):  # noqa: E501
        """get alert list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/alert/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_list_by_device_group_id(self, id, **kwargs):  # noqa: E501
        """get device group alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_list_by_device_group_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool need_message:
        :param str custom_columns:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_list_by_device_group_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_list_by_device_group_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_alert_list_by_device_group_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get device group alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_list_by_device_group_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool need_message:
        :param str custom_columns:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'need_message', 'custom_columns', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_list_by_device_group_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_alert_list_by_device_group_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_alert_list_by_device_group_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'need_message' in params:
            query_params.append(('needMessage', params['need_message']))  # noqa: E501
        if 'custom_columns' in params:
            query_params.append(('customColumns', params['custom_columns']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_list_by_device_id(self, id, **kwargs):  # noqa: E501
        """get alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_list_by_device_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param bool need_message:
        :param str custom_columns:
        :param str bound:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_list_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_list_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_alert_list_by_device_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get alerts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_list_by_device_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param bool need_message:
        :param str custom_columns:
        :param str bound:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'need_message', 'custom_columns', 'bound', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_list_by_device_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_alert_list_by_device_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_alert_list_by_device_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'need_message' in params:
            query_params.append(('needMessage', params['need_message']))  # noqa: E501
        if 'custom_columns' in params:
            query_params.append(('customColumns', params['custom_columns']))  # noqa: E501
        if 'bound' in params:
            query_params.append(('bound', params['bound']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_rule_by_id(self, id, **kwargs):  # noqa: E501
        """get alert rule by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_rule_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: AlertRule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_rule_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_rule_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_alert_rule_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get alert rule by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_rule_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: AlertRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_rule_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_alert_rule_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_alert_rule_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertRule'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/rules/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_alert_rule_list(self, **kwargs):  # noqa: E501
        """get alert rule list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_rule_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertRulePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_alert_rule_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_alert_rule_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_alert_rule_list_with_http_info(self, **kwargs):  # noqa: E501
        """get alert rule list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_alert_rule_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertRulePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alert_rule_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertRulePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_sdt_list_by_device_id(self, id, **kwargs):  # noqa: E501
        """get SDTs for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_sdt_list_by_device_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_sdt_list_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_sdt_list_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_all_sdt_list_by_device_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get SDTs for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_sdt_list_by_device_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_sdt_list_by_device_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_all_sdt_list_by_device_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_all_sdt_list_by_device_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDTPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/sdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_sdt_list_by_website_group_id(self, id, **kwargs):  # noqa: E501
        """get a list of SDTs for a website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_sdt_list_by_website_group_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_sdt_list_by_website_group_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_sdt_list_by_website_group_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_all_sdt_list_by_website_group_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get a list of SDTs for a website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_sdt_list_by_website_group_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_sdt_list_by_website_group_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_all_sdt_list_by_website_group_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_all_sdt_list_by_website_group_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDTPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups/{id}/sdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_token_list(self, **kwargs):  # noqa: E501
        """get a list of api tokens across users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_token_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ApiTokenPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_token_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_api_token_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_api_token_list_with_http_info(self, **kwargs):  # noqa: E501
        """get a list of api tokens across users  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_token_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ApiTokenPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_token_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ApiTokenPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/apitokens', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_token_list_by_admin_id(self, admin_id, **kwargs):  # noqa: E501
        """get api tokens for a user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_token_list_by_admin_id(admin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ApiTokenPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_token_list_by_admin_id_with_http_info(admin_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_token_list_by_admin_id_with_http_info(admin_id, **kwargs)  # noqa: E501
            return data

    def get_api_token_list_by_admin_id_with_http_info(self, admin_id, **kwargs):  # noqa: E501
        """get api tokens for a user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_token_list_by_admin_id_with_http_info(admin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ApiTokenPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['admin_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_token_list_by_admin_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_id' is set
        if ('admin_id' not in params or
                params['admin_id'] is None):
            raise ValueError("Missing the required parameter `admin_id` when calling `get_api_token_list_by_admin_id`")  # noqa: E501

        if 'admin_id' in params and not re.search('\d+', params['admin_id'] if type(params['admin_id']) is str else str(params['admin_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `admin_id` when calling `get_api_token_list_by_admin_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'admin_id' in params:
            path_params['adminId'] = params['admin_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ApiTokenPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{adminId}/apitokens', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_applies_to_function_by_id(self, id, **kwargs):  # noqa: E501
        """get applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_applies_to_function_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: AppliesToFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_applies_to_function_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_applies_to_function_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_applies_to_function_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_applies_to_function_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: AppliesToFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_applies_to_function_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_applies_to_function_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_applies_to_function_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AppliesToFunction'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/functions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_applies_to_function_list(self, **kwargs):  # noqa: E501
        """get applies to function list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_applies_to_function_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: RestAppliesToFunctionPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_applies_to_function_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_applies_to_function_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_applies_to_function_list_with_http_info(self, **kwargs):  # noqa: E501
        """get applies to function list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_applies_to_function_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: RestAppliesToFunctionPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_applies_to_function_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'RestAppliesToFunctionPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/functions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_associated_device_list_by_data_source_id(self, id, **kwargs):  # noqa: E501
        """get devices associated with a datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_associated_device_list_by_data_source_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDataSourceAssociatedPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_associated_device_list_by_data_source_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_associated_device_list_by_data_source_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_associated_device_list_by_data_source_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get devices associated with a datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_associated_device_list_by_data_source_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDataSourceAssociatedPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_associated_device_list_by_data_source_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_associated_device_list_by_data_source_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_associated_device_list_by_data_source_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceAssociatedPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/{id}/devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_log_by_id(self, id, **kwargs):  # noqa: E501
        """Get audit log by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: AuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_log_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_log_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_audit_log_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get audit log by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: AuditLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_log_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_audit_log_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AuditLog'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/accesslogs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_log_list(self, **kwargs):  # noqa: E501
        """Get audit logs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AccessLogPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_log_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_log_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_audit_log_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get audit logs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AccessLogPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['format', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_log_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AccessLogPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/accesslogs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_aws_external_id(self, **kwargs):  # noqa: E501
        """Get AWS external id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aws_external_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AwsExternalId
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_aws_external_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_aws_external_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_aws_external_id_with_http_info(self, **kwargs):  # noqa: E501
        """Get AWS external id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_aws_external_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AwsExternalId
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_aws_external_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AwsExternalId'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/aws/externalId', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collector_by_id(self, id, **kwargs):  # noqa: E501
        """get collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Collector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collector_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collector_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_collector_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Collector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collector_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_collector_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_collector_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Collector'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collector_group_by_id(self, id, **kwargs):  # noqa: E501
        """get collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: CollectorGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collector_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collector_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_collector_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: CollectorGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collector_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_collector_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_collector_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'CollectorGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collector_group_list(self, **kwargs):  # noqa: E501
        """get collector group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_group_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: CollectorGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collector_group_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_collector_group_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_collector_group_list_with_http_info(self, **kwargs):  # noqa: E501
        """get collector group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_group_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: CollectorGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collector_group_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'CollectorGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collector_installer(self, collector_id, os_and_arch, **kwargs):  # noqa: E501
        """get collector installer  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_installer(collector_id, os_and_arch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int collector_id: (required)
        :param str os_and_arch: (required)
        :param int collector_version: The version of the installer you'd like to download. This defaults to the latest GD Collector, unless useEA is true
        :param str token:
        :param bool monitor_others:
        :param str collector_size: The size of the Collector you'd like to install. Options are nano, small (requires 2GB memory), medium (requires 4GB memory), large (requires 8GB memory), extra large (requires 16GB memory), double extra large (requires 32GB memory). Requires collector version 22.180 or higher. Defaults to small
        :param bool use_ea: If true, the latest EA Collector version will be used. Defaults to false
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collector_installer_with_http_info(collector_id, os_and_arch, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collector_installer_with_http_info(collector_id, os_and_arch, **kwargs)  # noqa: E501
            return data

    def get_collector_installer_with_http_info(self, collector_id, os_and_arch, **kwargs):  # noqa: E501
        """get collector installer  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_installer_with_http_info(collector_id, os_and_arch, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int collector_id: (required)
        :param str os_and_arch: (required)
        :param int collector_version: The version of the installer you'd like to download. This defaults to the latest GD Collector, unless useEA is true
        :param str token:
        :param bool monitor_others:
        :param str collector_size: The size of the Collector you'd like to install. Options are nano, small (requires 2GB memory), medium (requires 4GB memory), large (requires 8GB memory), extra large (requires 16GB memory), double extra large (requires 32GB memory). Requires collector version 22.180 or higher. Defaults to small
        :param bool use_ea: If true, the latest EA Collector version will be used. Defaults to false
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collector_id', 'os_and_arch', 'collector_version', 'token', 'monitor_others', 'collector_size', 'use_ea']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collector_installer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collector_id' is set
        if ('collector_id' not in params or
                params['collector_id'] is None):
            raise ValueError("Missing the required parameter `collector_id` when calling `get_collector_installer`")  # noqa: E501
        # verify the required parameter 'os_and_arch' is set
        if ('os_and_arch' not in params or
                params['os_and_arch'] is None):
            raise ValueError("Missing the required parameter `os_and_arch` when calling `get_collector_installer`")  # noqa: E501

        if 'collector_id' in params and not re.search('\d+', params['collector_id'] if type(params['collector_id']) is str else str(params['collector_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `collector_id` when calling `get_collector_installer`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'os_and_arch' in params and not re.search('.+', params['os_and_arch'] if type(params['os_and_arch']) is str else str(params['os_and_arch'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `os_and_arch` when calling `get_collector_installer`, must conform to the pattern `/.+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'collector_id' in params:
            path_params['collectorId'] = params['collector_id']  # noqa: E501
        if 'os_and_arch' in params:
            path_params['osAndArch'] = params['os_and_arch']  # noqa: E501

        query_params = []
        if 'collector_version' in params:
            query_params.append(('collectorVersion', params['collector_version']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'monitor_others' in params:
            query_params.append(('monitorOthers', params['monitor_others']))  # noqa: E501
        if 'collector_size' in params:
            query_params.append(('collectorSize', params['collector_size']))  # noqa: E501
        if 'use_ea' in params:
            query_params.append(('useEA', params['use_ea']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'file'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors/{collectorId}/installers/{osAndArch}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collector_list(self, **kwargs):  # noqa: E501
        """get collector list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: CollectorPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collector_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_collector_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_collector_list_with_http_info(self, **kwargs):  # noqa: E501
        """get collector list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: CollectorPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collector_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'CollectorPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collector_version_list(self, **kwargs):  # noqa: E501
        """get collector version list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_version_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: CollectorVersionPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collector_version_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_collector_version_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_collector_version_list_with_http_info(self, **kwargs):  # noqa: E501
        """get collector version list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collector_version_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: CollectorVersionPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collector_version_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'CollectorVersionPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_by_id(self, id, **kwargs):  # noqa: E501
        """get dashboard  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool template:
        :param str format:
        :param str fields:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_dashboard_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get dashboard  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool template:
        :param str format:
        :param str fields:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'template', 'format', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_dashboard_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_dashboard_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'template' in params:
            query_params.append(('template', params['template']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Dashboard'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/dashboards/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_group_by_id(self, id, **kwargs):  # noqa: E501
        """get dashboard group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool template:
        :param str format:
        :param str fields:
        :return: DashboardGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_dashboard_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get dashboard group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool template:
        :param str format:
        :param str fields:
        :return: DashboardGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'template', 'format', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_dashboard_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_dashboard_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'template' in params:
            query_params.append(('template', params['template']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DashboardGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_group_list(self, **kwargs):  # noqa: E501
        """get dashboard group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_group_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DashboardGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_group_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_group_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dashboard_group_list_with_http_info(self, **kwargs):  # noqa: E501
        """get dashboard group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_group_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DashboardGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_group_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DashboardGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dashboard_list(self, **kwargs):  # noqa: E501
        """get dashboard list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DashboardPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dashboard_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dashboard_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dashboard_list_with_http_info(self, **kwargs):  # noqa: E501
        """get dashboard list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dashboard_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DashboardPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dashboard_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DashboardPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/dashboards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_source_overview_graph_by_id(self, ds_id, id, **kwargs):  # noqa: E501
        """get datasource overview graph by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_source_overview_graph_by_id(ds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ds_id: (required)
        :param int id: (required)
        :return: DataSourceOverviewGraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_source_overview_graph_by_id_with_http_info(ds_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_source_overview_graph_by_id_with_http_info(ds_id, id, **kwargs)  # noqa: E501
            return data

    def get_data_source_overview_graph_by_id_with_http_info(self, ds_id, id, **kwargs):  # noqa: E501
        """get datasource overview graph by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_source_overview_graph_by_id_with_http_info(ds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ds_id: (required)
        :param int id: (required)
        :return: DataSourceOverviewGraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ds_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_source_overview_graph_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ds_id' is set
        if ('ds_id' not in params or
                params['ds_id'] is None):
            raise ValueError("Missing the required parameter `ds_id` when calling `get_data_source_overview_graph_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_data_source_overview_graph_by_id`")  # noqa: E501

        if 'ds_id' in params and not re.search('\d+', params['ds_id'] if type(params['ds_id']) is str else str(params['ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ds_id` when calling `get_data_source_overview_graph_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_data_source_overview_graph_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ds_id' in params:
            path_params['dsId'] = params['ds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DataSourceOverviewGraph'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/{dsId}/ographs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_data_source_overview_graph_list(self, ds_id, **kwargs):  # noqa: E501
        """get datasource overview graph list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_source_overview_graph_list(ds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ds_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DatasourceOverviewGraphPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_data_source_overview_graph_list_with_http_info(ds_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_data_source_overview_graph_list_with_http_info(ds_id, **kwargs)  # noqa: E501
            return data

    def get_data_source_overview_graph_list_with_http_info(self, ds_id, **kwargs):  # noqa: E501
        """get datasource overview graph list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_data_source_overview_graph_list_with_http_info(ds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int ds_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DatasourceOverviewGraphPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ds_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_source_overview_graph_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ds_id' is set
        if ('ds_id' not in params or
                params['ds_id'] is None):
            raise ValueError("Missing the required parameter `ds_id` when calling `get_data_source_overview_graph_list`")  # noqa: E501

        if 'ds_id' in params and not re.search('\d+', params['ds_id'] if type(params['ds_id']) is str else str(params['ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ds_id` when calling `get_data_source_overview_graph_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'ds_id' in params:
            path_params['dsId'] = params['ds_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DatasourceOverviewGraphPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/{dsId}/ographs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datasource_by_id(self, id, **kwargs):  # noqa: E501
        """get datasource by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datasource_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str format:
        :param str fields:
        :return: DataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datasource_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_datasource_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_datasource_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get datasource by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datasource_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str format:
        :param str fields:
        :return: DataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'format', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datasource_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_datasource_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DataSource'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datasource_list(self, **kwargs):  # noqa: E501
        """get datasource list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datasource_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DatasourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datasource_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_datasource_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_datasource_list_with_http_info(self, **kwargs):  # noqa: E501
        """get datasource list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datasource_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DatasourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['format', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datasource_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DatasourcePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_debug_command_result(self, id, **kwargs):  # noqa: E501
        """Get the result of a Collector debug command  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debug_command_result(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param int collector_id:
        :return: Debug
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_debug_command_result_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_debug_command_result_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_debug_command_result_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get the result of a Collector debug command  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debug_command_result_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param int collector_id:
        :return: Debug
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'collector_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_debug_command_result" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_debug_command_result`")  # noqa: E501

        if 'id' in params and not re.search('.*', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_debug_command_result`, must conform to the pattern `/.*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'collector_id' in params:
            query_params.append(('collectorId', params['collector_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Debug'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/debug/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_by_id(self, id, **kwargs):  # noqa: E501
        """get device by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_device_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get device by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Device'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_config_source_config_by_id(self, device_id, hds_id, instance_id, id, **kwargs):  # noqa: E501
        """get a config for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_config_source_config_by_id(device_id, hds_id, instance_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: (required)
        :param int instance_id: (required)
        :param str id: (required)
        :param str format:
        :param int start_epoch:
        :param str fields:
        :return: DeviceDataSourceInstanceConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_config_source_config_by_id_with_http_info(device_id, hds_id, instance_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_config_source_config_by_id_with_http_info(device_id, hds_id, instance_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_config_source_config_by_id_with_http_info(self, device_id, hds_id, instance_id, id, **kwargs):  # noqa: E501
        """get a config for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_config_source_config_by_id_with_http_info(device_id, hds_id, instance_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: (required)
        :param int instance_id: (required)
        :param str id: (required)
        :param str format:
        :param int start_epoch:
        :param str fields:
        :return: DeviceDataSourceInstanceConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'instance_id', 'id', 'format', 'start_epoch', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_config_source_config_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_config_source_config_by_id`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_config_source_config_by_id`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_device_config_source_config_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_config_source_config_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_config_source_config_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_config_source_config_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `get_device_config_source_config_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('[-_a-zA-Z0-9]+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_config_source_config_by_id`, must conform to the pattern `/[-_a-zA-Z0-9]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'start_epoch' in params:
            query_params.append(('startEpoch', params['start_epoch']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceConfig'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/config/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_config_source_config_list(self, device_id, hds_id, instance_id, **kwargs):  # noqa: E501
        """get detailed config information for the instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_config_source_config_list(device_id, hds_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: (required)
        :param int instance_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstanceConfigPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_config_source_config_list_with_http_info(device_id, hds_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_config_source_config_list_with_http_info(device_id, hds_id, instance_id, **kwargs)  # noqa: E501
            return data

    def get_device_config_source_config_list_with_http_info(self, device_id, hds_id, instance_id, **kwargs):  # noqa: E501
        """get detailed config information for the instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_config_source_config_list_with_http_info(device_id, hds_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: (required)
        :param int instance_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstanceConfigPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'instance_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_config_source_config_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_config_source_config_list`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_config_source_config_list`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_device_config_source_config_list`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_config_source_config_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_config_source_config_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `get_device_config_source_config_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDatasourceInstanceConfigPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_by_id(self, device_id, id, **kwargs):  # noqa: E501
        """get device datasource   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_by_id(device_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_by_id_with_http_info(device_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_by_id_with_http_info(device_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_by_id_with_http_info(self, device_id, id, **kwargs):  # noqa: E501
        """get device datasource   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_by_id_with_http_info(device_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSource'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_data_by_id(self, device_id, id, **kwargs):  # noqa: E501
        """get device datasource data   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_data_by_id(device_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int id: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str datapoints:
        :param str format:
        :param str aggregate: the aggregate option
        :return: DeviceDataSourceData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_data_by_id_with_http_info(device_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_data_by_id_with_http_info(device_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_data_by_id_with_http_info(self, device_id, id, **kwargs):  # noqa: E501
        """get device datasource data   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_data_by_id_with_http_info(device_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int id: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str datapoints:
        :param str format:
        :param str aggregate: the aggregate option
        :return: DeviceDataSourceData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'id', 'period', 'start', 'end', 'datapoints', 'format', 'aggregate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_data_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_data_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_data_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_data_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_data_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'datapoints' in params:
            query_params.append(('datapoints', params['datapoints']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceData'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_alert_setting_by_id(self, device_id, hds_id, instance_id, id, **kwargs):  # noqa: E501
        """get device instance alert setting  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_alert_setting_by_id(device_id, hds_id, instance_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: Device-DataSource ID (required)
        :param int instance_id: (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSourceInstanceAlertSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_alert_setting_by_id_with_http_info(device_id, hds_id, instance_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_alert_setting_by_id_with_http_info(device_id, hds_id, instance_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_alert_setting_by_id_with_http_info(self, device_id, hds_id, instance_id, id, **kwargs):  # noqa: E501
        """get device instance alert setting  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_alert_setting_by_id_with_http_info(device_id, hds_id, instance_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: Device-DataSource ID (required)
        :param int instance_id: (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSourceInstanceAlertSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'instance_id', 'id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_alert_setting_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_instance_alert_setting_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `get_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceAlertSetting'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_alert_setting_list_of_device(self, device_id, **kwargs):  # noqa: E501
        """get a list of alert settings for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_alert_setting_list_of_device(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param int size:
        :param int offset:
        :return: DeviceDataSourceInstanceAlertSettingPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_alert_setting_list_of_device_with_http_info(device_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_alert_setting_list_of_device_with_http_info(device_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_alert_setting_list_of_device_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """get a list of alert settings for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_alert_setting_list_of_device_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param int size:
        :param int offset:
        :return: DeviceDataSourceInstanceAlertSettingPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'start', 'end', 'netflow_filter', 'size', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_alert_setting_list_of_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_alert_setting_list_of_device`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_alert_setting_list_of_device`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceAlertSettingPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/alertsettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_alert_setting_list_of_dsi(self, device_id, hds_id, instance_id, **kwargs):  # noqa: E501
        """get a list of alert settings for a device datasource instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_alert_setting_list_of_dsi(device_id, hds_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: Device-DataSource ID (required)
        :param int instance_id: (required)
        :param int size:
        :param int offset:
        :return: DeviceDataSourceInstanceAlertSettingPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_alert_setting_list_of_dsi_with_http_info(device_id, hds_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_alert_setting_list_of_dsi_with_http_info(device_id, hds_id, instance_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_alert_setting_list_of_dsi_with_http_info(self, device_id, hds_id, instance_id, **kwargs):  # noqa: E501
        """get a list of alert settings for a device datasource instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_alert_setting_list_of_dsi_with_http_info(device_id, hds_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: Device-DataSource ID (required)
        :param int instance_id: (required)
        :param int size:
        :param int offset:
        :return: DeviceDataSourceInstanceAlertSettingPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'instance_id', 'size', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_alert_setting_list_of_dsi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_alert_setting_list_of_dsi`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_alert_setting_list_of_dsi`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_device_datasource_instance_alert_setting_list_of_dsi`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_alert_setting_list_of_dsi`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_alert_setting_list_of_dsi`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `get_device_datasource_instance_alert_setting_list_of_dsi`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceAlertSettingPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_by_id(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """get device instance   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_by_id(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSourceInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_by_id_with_http_info(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """get device instance   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSourceInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_instance_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstance'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_data(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """get device instance data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_data(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str datapoints:
        :param str format:
        :return: DeviceDataSourceInstanceData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_data_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_data_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_data_with_http_info(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """get device instance data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_data_with_http_info(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str datapoints:
        :param str format:
        :return: DeviceDataSourceInstanceData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'id', 'period', 'start', 'end', 'datapoints', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_data`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_data`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_instance_data`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_instance_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'datapoints' in params:
            query_params.append(('datapoints', params['datapoints']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceData'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_graph_data(self, device_id, hds_id, id, graph_id, **kwargs):  # noqa: E501
        """get device instance graph data   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_graph_data(device_id, hds_id, id, graph_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param int graph_id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_graph_data_with_http_info(device_id, hds_id, id, graph_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_graph_data_with_http_info(device_id, hds_id, id, graph_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_graph_data_with_http_info(self, device_id, hds_id, id, graph_id, **kwargs):  # noqa: E501
        """get device instance graph data   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_graph_data_with_http_info(device_id, hds_id, id, graph_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param int graph_id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'id', 'graph_id', 'start', 'end', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_graph_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_graph_data`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_graph_data`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_instance_graph_data`")  # noqa: E501
        # verify the required parameter 'graph_id' is set
        if ('graph_id' not in params or
                params['graph_id'] is None):
            raise ValueError("Missing the required parameter `graph_id` when calling `get_device_datasource_instance_graph_data`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_instance_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'graph_id' in params and not re.search('-?\d+', params['graph_id'] if type(params['graph_id']) is str else str(params['graph_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `graph_id` when calling `get_device_datasource_instance_graph_data`, must conform to the pattern `/-?\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'graph_id' in params:
            path_params['graphId'] = params['graph_id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GraphPlot'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}/graphs/{graphId}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_group_by_id(self, device_id, device_ds_id, id, **kwargs):  # noqa: E501
        """get device datasource instance group   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_group_by_id(device_id, device_ds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSourceInstanceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_group_by_id_with_http_info(device_id, device_ds_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_group_by_id_with_http_info(device_id, device_ds_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_group_by_id_with_http_info(self, device_id, device_ds_id, id, **kwargs):  # noqa: E501
        """get device datasource instance group   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_group_by_id_with_http_info(device_id, device_ds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceDataSourceInstanceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'device_ds_id', 'id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_group_by_id`")  # noqa: E501
        # verify the required parameter 'device_ds_id' is set
        if ('device_ds_id' not in params or
                params['device_ds_id'] is None):
            raise ValueError("Missing the required parameter `device_ds_id` when calling `get_device_datasource_instance_group_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_instance_group_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'device_ds_id' in params and not re.search('\d+', params['device_ds_id'] if type(params['device_ds_id']) is str else str(params['device_ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_ds_id` when calling `get_device_datasource_instance_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_instance_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'device_ds_id' in params:
            path_params['deviceDsId'] = params['device_ds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_group_list(self, device_id, device_ds_id, **kwargs):  # noqa: E501
        """get device datasource instance group list   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_group_list(device_id, device_ds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstanceGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_group_list_with_http_info(device_id, device_ds_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_group_list_with_http_info(device_id, device_ds_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_group_list_with_http_info(self, device_id, device_ds_id, **kwargs):  # noqa: E501
        """get device datasource instance group list   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_group_list_with_http_info(device_id, device_ds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstanceGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'device_ds_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_group_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_group_list`")  # noqa: E501
        # verify the required parameter 'device_ds_id' is set
        if ('device_ds_id' not in params or
                params['device_ds_id'] is None):
            raise ValueError("Missing the required parameter `device_ds_id` when calling `get_device_datasource_instance_group_list`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_group_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'device_ds_id' in params and not re.search('\d+', params['device_ds_id'] if type(params['device_ds_id']) is str else str(params['device_ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_ds_id` when calling `get_device_datasource_instance_group_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'device_ds_id' in params:
            path_params['deviceDsId'] = params['device_ds_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDatasourceInstanceGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_group_overview_graph_data(self, device_id, device_ds_id, dsig_id, ograph_id, **kwargs):  # noqa: E501
        """get device instance group overview graph data   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_group_overview_graph_data(device_id, device_ds_id, dsig_id, ograph_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param int dsig_id: (required)
        :param int ograph_id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_group_overview_graph_data_with_http_info(device_id, device_ds_id, dsig_id, ograph_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_group_overview_graph_data_with_http_info(device_id, device_ds_id, dsig_id, ograph_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_group_overview_graph_data_with_http_info(self, device_id, device_ds_id, dsig_id, ograph_id, **kwargs):  # noqa: E501
        """get device instance group overview graph data   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_group_overview_graph_data_with_http_info(device_id, device_ds_id, dsig_id, ograph_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param int dsig_id: (required)
        :param int ograph_id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'device_ds_id', 'dsig_id', 'ograph_id', 'start', 'end', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_group_overview_graph_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_group_overview_graph_data`")  # noqa: E501
        # verify the required parameter 'device_ds_id' is set
        if ('device_ds_id' not in params or
                params['device_ds_id'] is None):
            raise ValueError("Missing the required parameter `device_ds_id` when calling `get_device_datasource_instance_group_overview_graph_data`")  # noqa: E501
        # verify the required parameter 'dsig_id' is set
        if ('dsig_id' not in params or
                params['dsig_id'] is None):
            raise ValueError("Missing the required parameter `dsig_id` when calling `get_device_datasource_instance_group_overview_graph_data`")  # noqa: E501
        # verify the required parameter 'ograph_id' is set
        if ('ograph_id' not in params or
                params['ograph_id'] is None):
            raise ValueError("Missing the required parameter `ograph_id` when calling `get_device_datasource_instance_group_overview_graph_data`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_group_overview_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'device_ds_id' in params and not re.search('\d+', params['device_ds_id'] if type(params['device_ds_id']) is str else str(params['device_ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_ds_id` when calling `get_device_datasource_instance_group_overview_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'dsig_id' in params and not re.search('\d+', params['dsig_id'] if type(params['dsig_id']) is str else str(params['dsig_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `dsig_id` when calling `get_device_datasource_instance_group_overview_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'ograph_id' in params and not re.search('\d+', params['ograph_id'] if type(params['ograph_id']) is str else str(params['ograph_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ograph_id` when calling `get_device_datasource_instance_group_overview_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'device_ds_id' in params:
            path_params['deviceDsId'] = params['device_ds_id']  # noqa: E501
        if 'dsig_id' in params:
            path_params['dsigId'] = params['dsig_id']  # noqa: E501
        if 'ograph_id' in params:
            path_params['ographId'] = params['ograph_id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GraphPlot'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{dsigId}/graphs/{ographId}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_list(self, device_id, hds_id, **kwargs):  # noqa: E501
        """get device instance list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_list(device_id, hds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstancePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_list_with_http_info(device_id, hds_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_list_with_http_info(device_id, hds_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_list_with_http_info(self, device_id, hds_id, **kwargs):  # noqa: E501
        """get device instance list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_list_with_http_info(device_id, hds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstancePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_list`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_list`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDatasourceInstancePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_instance_sdt_history(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """get device instance SDT history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_sdt_history(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_instance_sdt_history_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_instance_sdt_history_with_http_info(device_id, hds_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_instance_sdt_history_with_http_info(self, device_id, hds_id, id, **kwargs):  # noqa: E501
        """get device instance SDT history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_instance_sdt_history_with_http_info(device_id, hds_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_instance_sdt_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_instance_sdt_history`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `get_device_datasource_instance_sdt_history`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_datasource_instance_sdt_history`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_instance_sdt_history`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `get_device_datasource_instance_sdt_history`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_datasource_instance_sdt_history`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupSDTHistoryPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}/historysdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_datasource_list(self, device_id, **kwargs):  # noqa: E501
        """get device datasource list   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_list(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_datasource_list_with_http_info(device_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_datasource_list_with_http_info(device_id, **kwargs)  # noqa: E501
            return data

    def get_device_datasource_list_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """get device datasource list   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_datasource_list_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_datasource_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_datasource_list`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_datasource_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDatasourcePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_by_id(self, id, **kwargs):  # noqa: E501
        """get device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: DeviceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_device_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: DeviceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_cluster_alert_conf_by_id(self, device_group_id, id, **kwargs):  # noqa: E501
        """Get cluster alert configuration by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_cluster_alert_conf_by_id(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :return: DeviceClusterAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_group_cluster_alert_conf_by_id_with_http_info(self, device_group_id, id, **kwargs):  # noqa: E501
        """Get cluster alert configuration by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :return: DeviceClusterAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_cluster_alert_conf_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `get_device_group_cluster_alert_conf_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_group_cluster_alert_conf_by_id`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `get_device_group_cluster_alert_conf_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_group_cluster_alert_conf_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceClusterAlertConfig'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/clusterAlertConf/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_cluster_alert_conf_list(self, device_group_id, **kwargs):  # noqa: E501
        """get a list of cluster alert configurations for a device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_cluster_alert_conf_list(device_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceClusterAlertConfigPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_cluster_alert_conf_list_with_http_info(device_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_cluster_alert_conf_list_with_http_info(device_group_id, **kwargs)  # noqa: E501
            return data

    def get_device_group_cluster_alert_conf_list_with_http_info(self, device_group_id, **kwargs):  # noqa: E501
        """get a list of cluster alert configurations for a device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_cluster_alert_conf_list_with_http_info(device_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceClusterAlertConfigPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_cluster_alert_conf_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `get_device_group_cluster_alert_conf_list`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `get_device_group_cluster_alert_conf_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceClusterAlertConfigPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/clusterAlertConf', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_datasource_alert_setting(self, device_group_id, ds_id, **kwargs):  # noqa: E501
        """get device group datasource alert setting   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_datasource_alert_setting(device_group_id, ds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int ds_id: (required)
        :param str fields:
        :return: DeviceGroupDataSourceAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_datasource_alert_setting_with_http_info(device_group_id, ds_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_datasource_alert_setting_with_http_info(device_group_id, ds_id, **kwargs)  # noqa: E501
            return data

    def get_device_group_datasource_alert_setting_with_http_info(self, device_group_id, ds_id, **kwargs):  # noqa: E501
        """get device group datasource alert setting   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_datasource_alert_setting_with_http_info(device_group_id, ds_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int ds_id: (required)
        :param str fields:
        :return: DeviceGroupDataSourceAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'ds_id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_datasource_alert_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `get_device_group_datasource_alert_setting`")  # noqa: E501
        # verify the required parameter 'ds_id' is set
        if ('ds_id' not in params or
                params['ds_id'] is None):
            raise ValueError("Missing the required parameter `ds_id` when calling `get_device_group_datasource_alert_setting`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `get_device_group_datasource_alert_setting`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'ds_id' in params and not re.search('\d+', params['ds_id'] if type(params['ds_id']) is str else str(params['ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ds_id` when calling `get_device_group_datasource_alert_setting`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'ds_id' in params:
            path_params['dsId'] = params['ds_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupDataSourceAlertConfig'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/datasources/{dsId}/alertsettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_datasource_by_id(self, device_group_id, id, **kwargs):  # noqa: E501
        """get device group datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_datasource_by_id(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceGroupDataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_datasource_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_datasource_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
            return data

    def get_device_group_datasource_by_id_with_http_info(self, device_group_id, id, **kwargs):  # noqa: E501
        """get device group datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_datasource_by_id_with_http_info(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :param str fields:
        :return: DeviceGroupDataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_datasource_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `get_device_group_datasource_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_group_datasource_by_id`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `get_device_group_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_group_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupDataSource'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/datasources/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_datasource_list(self, device_group_id, **kwargs):  # noqa: E501
        """get device group datasource list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_datasource_list(device_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param bool include_disabled_data_source_without_instance:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupDatasourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_datasource_list_with_http_info(device_group_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_datasource_list_with_http_info(device_group_id, **kwargs)  # noqa: E501
            return data

    def get_device_group_datasource_list_with_http_info(self, device_group_id, **kwargs):  # noqa: E501
        """get device group datasource list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_datasource_list_with_http_info(device_group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param bool include_disabled_data_source_without_instance:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupDatasourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'include_disabled_data_source_without_instance', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_datasource_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `get_device_group_datasource_list`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `get_device_group_datasource_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501

        query_params = []
        if 'include_disabled_data_source_without_instance' in params:
            query_params.append(('includeDisabledDataSourceWithoutInstance', params['include_disabled_data_source_without_instance']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupDatasourcePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/datasources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_list(self, **kwargs):  # noqa: E501
        """get device group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_device_group_list_with_http_info(self, **kwargs):  # noqa: E501
        """get device group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_property_by_name(self, gid, name, **kwargs):  # noqa: E501
        """get device group property by name  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_property_by_name(gid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str name: (required)
        :param str fields:
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_property_by_name_with_http_info(gid, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_property_by_name_with_http_info(gid, name, **kwargs)  # noqa: E501
            return data

    def get_device_group_property_by_name_with_http_info(self, gid, name, **kwargs):  # noqa: E501
        """get device group property by name  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_property_by_name_with_http_info(gid, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str name: (required)
        :param str fields:
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid', 'name', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_property_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `get_device_group_property_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_device_group_property_by_name`")  # noqa: E501

        if 'gid' in params and not re.search('\d+', params['gid'] if type(params['gid']) is str else str(params['gid'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gid` when calling `get_device_group_property_by_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'name' in params and not re.search('[^\/]+', params['name'] if type(params['name']) is str else str(params['name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `name` when calling `get_device_group_property_by_name`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EntityProperty'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{gid}/properties/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_property_list(self, gid, **kwargs):  # noqa: E501
        """get device group properties  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_property_list(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PropertyPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_property_list_with_http_info(gid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_property_list_with_http_info(gid, **kwargs)  # noqa: E501
            return data

    def get_device_group_property_list_with_http_info(self, gid, **kwargs):  # noqa: E501
        """get device group properties  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_property_list_with_http_info(gid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PropertyPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_property_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `get_device_group_property_list`")  # noqa: E501

        if 'gid' in params and not re.search('\d+', params['gid'] if type(params['gid']) is str else str(params['gid'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gid` when calling `get_device_group_property_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'PropertyPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{gid}/properties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_group_sdt_list(self, id, **kwargs):  # noqa: E501
        """get device group SDTs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_sdt_list(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_group_sdt_list_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_group_sdt_list_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_device_group_sdt_list_with_http_info(self, id, **kwargs):  # noqa: E501
        """get device group SDTs  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_group_sdt_list_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_group_sdt_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_group_sdt_list`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_group_sdt_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDTPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}/sdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_instance_graph_data_only_by_instance_id(self, instance_id, graph_id, **kwargs):  # noqa: E501
        """get device instance data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_instance_graph_data_only_by_instance_id(instance_id, graph_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instance_id: (required)
        :param int graph_id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_instance_graph_data_only_by_instance_id_with_http_info(instance_id, graph_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_instance_graph_data_only_by_instance_id_with_http_info(instance_id, graph_id, **kwargs)  # noqa: E501
            return data

    def get_device_instance_graph_data_only_by_instance_id_with_http_info(self, instance_id, graph_id, **kwargs):  # noqa: E501
        """get device instance data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_instance_graph_data_only_by_instance_id_with_http_info(instance_id, graph_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instance_id: (required)
        :param int graph_id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance_id', 'graph_id', 'start', 'end', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_instance_graph_data_only_by_instance_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_device_instance_graph_data_only_by_instance_id`")  # noqa: E501
        # verify the required parameter 'graph_id' is set
        if ('graph_id' not in params or
                params['graph_id'] is None):
            raise ValueError("Missing the required parameter `graph_id` when calling `get_device_instance_graph_data_only_by_instance_id`")  # noqa: E501

        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `get_device_instance_graph_data_only_by_instance_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'graph_id' in params and not re.search('-?\d+', params['graph_id'] if type(params['graph_id']) is str else str(params['graph_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `graph_id` when calling `get_device_instance_graph_data_only_by_instance_id`, must conform to the pattern `/-?\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'graph_id' in params:
            path_params['graphId'] = params['graph_id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GraphPlot'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devicedatasourceinstances/{instanceId}/graphs/{graphId}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_instance_list(self, id, **kwargs):  # noqa: E501
        """get device instance list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_instance_list(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstancePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_instance_list_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_instance_list_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_device_instance_list_with_http_info(self, id, **kwargs):  # noqa: E501
        """get device instance list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_instance_list_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDatasourceInstancePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_instance_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_device_instance_list`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_device_instance_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDatasourceInstancePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/instances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_list(self, **kwargs):  # noqa: E501
        """get device list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DevicePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_device_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_device_list_with_http_info(self, **kwargs):  # noqa: E501
        """get device list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DevicePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['start', 'end', 'netflow_filter', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DevicePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_property_by_name(self, device_id, name, **kwargs):  # noqa: E501
        """get device property by name  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_property_by_name(device_id, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str name: (required)
        :param str fields:
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_property_by_name_with_http_info(device_id, name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_property_by_name_with_http_info(device_id, name, **kwargs)  # noqa: E501
            return data

    def get_device_property_by_name_with_http_info(self, device_id, name, **kwargs):  # noqa: E501
        """get device property by name  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_property_by_name_with_http_info(device_id, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str name: (required)
        :param str fields:
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'name', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_property_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_property_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_device_property_by_name`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_property_by_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'name' in params and not re.search('[^\/]+', params['name'] if type(params['name']) is str else str(params['name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `name` when calling `get_device_property_by_name`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EntityProperty'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/properties/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_device_property_list(self, device_id, **kwargs):  # noqa: E501
        """get device properties  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_property_list(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PropertyPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_device_property_list_with_http_info(device_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_device_property_list_with_http_info(device_id, **kwargs)  # noqa: E501
            return data

    def get_device_property_list_with_http_info(self, device_id, **kwargs):  # noqa: E501
        """get device properties  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_device_property_list_with_http_info(device_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PropertyPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_device_property_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_device_property_list`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_device_property_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'PropertyPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/properties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_escalation_chain_by_id(self, id, **kwargs):  # noqa: E501
        """get escalation chain by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_escalation_chain_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: EscalatingChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_escalation_chain_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_escalation_chain_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_escalation_chain_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get escalation chain by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_escalation_chain_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: EscalatingChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_escalation_chain_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_escalation_chain_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_escalation_chain_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EscalatingChain'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/chains/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_escalation_chain_list(self, **kwargs):  # noqa: E501
        """get escalation chain list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_escalation_chain_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: EscalationChainPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_escalation_chain_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_escalation_chain_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_escalation_chain_list_with_http_info(self, **kwargs):  # noqa: E501
        """get escalation chain list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_escalation_chain_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: EscalationChainPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_escalation_chain_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EscalationChainPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/chains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_source_list(self, **kwargs):  # noqa: E501
        """get eventSource list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_source_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: EventSourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_source_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_source_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_source_list_with_http_info(self, **kwargs):  # noqa: E501
        """get eventSource list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_source_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: EventSourcePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['format', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_source_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EventSourcePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/eventsources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_api_stats(self, **kwargs):  # noqa: E501
        """get external api stats info  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_api_stats(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiPerfMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_external_api_stats_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_external_api_stats_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_external_api_stats_with_http_info(self, **kwargs):  # noqa: E501
        """get external api stats info  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_api_stats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiPerfMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_api_stats" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ApiPerfMetrics'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/apiStats/externalApis', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_immediate_device_list_by_device_group_id(self, id, **kwargs):  # noqa: E501
        """get immediate devices under group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_immediate_device_list_by_device_group_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DevicePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_immediate_device_list_by_device_group_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_immediate_device_list_by_device_group_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_immediate_device_list_by_device_group_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get immediate devices under group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_immediate_device_list_by_device_group_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DevicePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_immediate_device_list_by_device_group_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_immediate_device_list_by_device_group_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_immediate_device_list_by_device_group_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DevicePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}/devices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_immediate_website_list_by_website_group_id(self, id, **kwargs):  # noqa: E501
        """get a list of websites for a group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_immediate_website_list_by_website_group_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsitePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_immediate_website_list_by_website_group_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_immediate_website_list_by_website_group_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_immediate_website_list_by_website_group_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get a list of websites for a group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_immediate_website_list_by_website_group_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsitePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_immediate_website_list_by_website_group_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_immediate_website_list_by_website_group_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_immediate_website_list_by_website_group_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsitePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups/{id}/websites', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metrics_usage(self, **kwargs):  # noqa: E501
        """get metrics usage  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_usage(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Usage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metrics_usage_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_metrics_usage_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_metrics_usage_with_http_info(self, **kwargs):  # noqa: E501
        """get metrics usage  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_usage_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Usage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics_usage" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Usage'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/metrics/usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_netflow_endpoint_list(self, id, **kwargs):  # noqa: E501
        """get netflow endpoint list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netflow_endpoint_list(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str port:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: EndpointPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_netflow_endpoint_list_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_netflow_endpoint_list_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_netflow_endpoint_list_with_http_info(self, id, **kwargs):  # noqa: E501
        """get netflow endpoint list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netflow_endpoint_list_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str port:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: EndpointPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'port', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_netflow_endpoint_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_netflow_endpoint_list`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_netflow_endpoint_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'port' in params:
            query_params.append(('port', params['port']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EndpointPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_netflow_flow_list(self, id, **kwargs):  # noqa: E501
        """get netflow flow list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netflow_flow_list(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: FlowRecordPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_netflow_flow_list_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_netflow_flow_list_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_netflow_flow_list_with_http_info(self, id, **kwargs):  # noqa: E501
        """get netflow flow list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netflow_flow_list_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: FlowRecordPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_netflow_flow_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_netflow_flow_list`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_netflow_flow_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'FlowRecordPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/flows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_netflow_port_list(self, id, **kwargs):  # noqa: E501
        """get netflow port list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netflow_port_list(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str ip:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PortPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_netflow_port_list_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_netflow_port_list_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_netflow_port_list_with_http_info(self, id, **kwargs):  # noqa: E501
        """get netflow port list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netflow_port_list_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str ip:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PortPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'ip', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_netflow_port_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_netflow_port_list`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_netflow_port_list`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'ip' in params:
            query_params.append(('ip', params['ip']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'PortPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/ports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_netscan_by_id(self, id, **kwargs):  # noqa: E501
        """get netscan by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netscan_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: Netscan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_netscan_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_netscan_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_netscan_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get netscan by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netscan_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: Netscan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_netscan_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_netscan_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_netscan_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Netscan'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/netscans/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_netscan_list(self, **kwargs):  # noqa: E501
        """get netscan list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netscan_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: NetscanPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_netscan_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_netscan_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_netscan_list_with_http_info(self, **kwargs):  # noqa: E501
        """get netscan list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_netscan_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: NetscanPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_netscan_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'NetscanPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/netscans', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ops_note_by_id(self, id, **kwargs):  # noqa: E501
        """get opsnote by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ops_note_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str fields:
        :return: OpsNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ops_note_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ops_note_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_ops_note_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get opsnote by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ops_note_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str fields:
        :return: OpsNote
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ops_note_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_ops_note_by_id`")  # noqa: E501

        if 'id' in params and not re.search('[^\/]+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_ops_note_by_id`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'OpsNote'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/opsnotes/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ops_note_list(self, **kwargs):  # noqa: E501
        """get opsnote list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ops_note_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter: Filter the response based on tags, createdBy, happenedOn, monitorObjectGroups, monitorObjectNames, or _all field values
        :return: OpsNotePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ops_note_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_ops_note_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_ops_note_list_with_http_info(self, **kwargs):  # noqa: E501
        """get opsnote list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ops_note_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter: Filter the response based on tags, createdBy, happenedOn, monitorObjectGroups, monitorObjectNames, or _all field values
        :return: OpsNotePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ops_note_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'OpsNotePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/opsnotes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_recipient_group_by_id(self, id, **kwargs):  # noqa: E501
        """get recipient group by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipient_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: RecipientGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_recipient_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_recipient_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_recipient_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get recipient group by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipient_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: RecipientGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipient_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_recipient_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_recipient_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'RecipientGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/recipientgroups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_recipient_group_list(self, **kwargs):  # noqa: E501
        """get recipient group List  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipient_group_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: RecipientGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_recipient_group_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_recipient_group_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_recipient_group_list_with_http_info(self, **kwargs):  # noqa: E501
        """get recipient group List  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipient_group_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: RecipientGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipient_group_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'RecipientGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/recipientgroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_by_id(self, id, **kwargs):  # noqa: E501
        """get report by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: ReportBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_report_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get report by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: ReportBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_report_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_report_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportBase'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/reports/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_group_by_id(self, id, **kwargs):  # noqa: E501
        """get report group by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: ReportGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_report_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get report group by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: ReportGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_report_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_report_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_group_list(self, **kwargs):  # noqa: E501
        """get report group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_group_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ReportGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_group_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_report_group_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_report_group_list_with_http_info(self, **kwargs):  # noqa: E501
        """get report group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_group_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ReportGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_group_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_list(self, **kwargs):  # noqa: E501
        """get report list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ReportPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_report_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_report_list_with_http_info(self, **kwargs):  # noqa: E501
        """get report list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: ReportPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role_by_id(self, id, **kwargs):  # noqa: E501
        """get role by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_role_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get role by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_role_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_role_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Role'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/roles/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role_list(self, **kwargs):  # noqa: E501
        """get role list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: RolePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_role_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_role_list_with_http_info(self, **kwargs):  # noqa: E501
        """get role list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: RolePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'RolePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_by_id(self, id, **kwargs):  # noqa: E501
        """get SDT by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str fields:
        :return: SDT
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_sdt_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get SDT by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str fields:
        :return: SDT
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sdt_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDT'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/sdt/sdts/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_history_by_device_data_source_id(self, device_id, id, **kwargs):  # noqa: E501
        """get SDT history for the device dataSource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_device_data_source_id(device_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDataSourceSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_history_by_device_data_source_id_with_http_info(device_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_history_by_device_data_source_id_with_http_info(device_id, id, **kwargs)  # noqa: E501
            return data

    def get_sdt_history_by_device_data_source_id_with_http_info(self, device_id, id, **kwargs):  # noqa: E501
        """get SDT history for the device dataSource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_device_data_source_id_with_http_info(device_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceDataSourceSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_history_by_device_data_source_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `get_sdt_history_by_device_data_source_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sdt_history_by_device_data_source_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `get_sdt_history_by_device_data_source_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_sdt_history_by_device_data_source_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceSDTHistoryPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{id}/historysdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_history_by_device_group_id(self, id, **kwargs):  # noqa: E501
        """get SDT history for the group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_device_group_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_history_by_device_group_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_history_by_device_group_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_sdt_history_by_device_group_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get SDT history for the group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_device_group_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceGroupSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_history_by_device_group_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sdt_history_by_device_group_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_sdt_history_by_device_group_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupSDTHistoryPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}/historysdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_history_by_device_id(self, id, **kwargs):  # noqa: E501
        """get SDT history for the device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_device_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_history_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_history_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_sdt_history_by_device_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get SDT history for the device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_device_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DeviceSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_history_by_device_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sdt_history_by_device_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_sdt_history_by_device_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceSDTHistoryPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/historysdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_history_by_website_group_id(self, id, **kwargs):  # noqa: E501
        """get SDT history for the website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_website_group_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsiteGroupSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_history_by_website_group_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_history_by_website_group_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_sdt_history_by_website_group_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get SDT history for the website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_website_group_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsiteGroupSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_history_by_website_group_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sdt_history_by_website_group_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_sdt_history_by_website_group_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteGroupSDTHistoryPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups/{id}/historysdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_history_by_website_id(self, id, **kwargs):  # noqa: E501
        """get SDT history for the website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_website_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsiteSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_history_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_history_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_sdt_history_by_website_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get SDT history for the website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_history_by_website_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsiteSDTHistoryPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_history_by_website_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_sdt_history_by_website_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_sdt_history_by_website_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteSDTHistoryPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}/historysdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sdt_list(self, **kwargs):  # noqa: E501
        """get SDT list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sdt_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sdt_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sdt_list_with_http_info(self, **kwargs):  # noqa: E501
        """get SDT list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sdt_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sdt_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDTPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/sdt/sdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_site_monitor_check_point_list(self, **kwargs):  # noqa: E501
        """get website checkpoint list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_site_monitor_check_point_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SiteMonitorCheckPointPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_site_monitor_check_point_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_site_monitor_check_point_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_site_monitor_check_point_list_with_http_info(self, **kwargs):  # noqa: E501
        """get website checkpoint list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_site_monitor_check_point_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SiteMonitorCheckPointPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_monitor_check_point_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SiteMonitorCheckPointPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/smcheckpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_top_talkers_graph(self, id, **kwargs):  # noqa: E501
        """get top talkers graph  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_top_talkers_graph(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str format:
        :param str keyword:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_top_talkers_graph_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_top_talkers_graph_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_top_talkers_graph_with_http_info(self, id, **kwargs):  # noqa: E501
        """get top talkers graph  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_top_talkers_graph_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str format:
        :param str keyword:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter', 'format', 'keyword']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_top_talkers_graph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_top_talkers_graph`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_top_talkers_graph`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'keyword' in params:
            query_params.append(('keyword', params['keyword']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GraphPlot'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/topTalkersGraph', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_unmonitored_device_list(self, **kwargs):  # noqa: E501
        """get unmonitored device list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unmonitored_device_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: UnmonitoredDevicePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_unmonitored_device_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_unmonitored_device_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_unmonitored_device_list_with_http_info(self, **kwargs):  # noqa: E501
        """get unmonitored device list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_unmonitored_device_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: UnmonitoredDevicePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_unmonitored_device_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'UnmonitoredDevicePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/unmonitoreddevices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_update_reason_list_by_data_source_id(self, id, **kwargs):  # noqa: E501
        """get update history for a datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_update_reason_list_by_data_source_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DataSourceUpdateReasonsPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_update_reason_list_by_data_source_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_update_reason_list_by_data_source_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_update_reason_list_by_data_source_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get update history for a datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_update_reason_list_by_data_source_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: DataSourceUpdateReasonsPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_update_reason_list_by_data_source_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_update_reason_list_by_data_source_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_update_reason_list_by_data_source_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DataSourceUpdateReasonsPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/{id}/updatereasons', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_alert_list_by_website_id(self, id, **kwargs):  # noqa: E501
        """get alerts for a website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_alert_list_by_website_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool need_message:
        :param str custom_columns:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_alert_list_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_alert_list_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_website_alert_list_by_website_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get alerts for a website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_alert_list_by_website_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param bool need_message:
        :param str custom_columns:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: AlertPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'need_message', 'custom_columns', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_alert_list_by_website_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_website_alert_list_by_website_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_website_alert_list_by_website_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'need_message' in params:
            query_params.append(('needMessage', params['need_message']))  # noqa: E501
        if 'custom_columns' in params:
            query_params.append(('customColumns', params['custom_columns']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_by_id(self, id, **kwargs):  # noqa: E501
        """get website by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str format:
        :return: Website
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_website_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get website by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str format:
        :return: Website
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_website_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_website_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Website'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_checkpoint_data_by_id(self, srv_id, check_id, **kwargs):  # noqa: E501
        """get data for a website checkpoint  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_checkpoint_data_by_id(srv_id, check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int srv_id: (required)
        :param int check_id: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str datapoints:
        :param str format:
        :param str aggregate: the aggregate option
        :return: WebsiteCheckpointRawData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_checkpoint_data_by_id_with_http_info(srv_id, check_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_checkpoint_data_by_id_with_http_info(srv_id, check_id, **kwargs)  # noqa: E501
            return data

    def get_website_checkpoint_data_by_id_with_http_info(self, srv_id, check_id, **kwargs):  # noqa: E501
        """get data for a website checkpoint  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_checkpoint_data_by_id_with_http_info(srv_id, check_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int srv_id: (required)
        :param int check_id: (required)
        :param float period:
        :param int start:
        :param int end:
        :param str datapoints:
        :param str format:
        :param str aggregate: the aggregate option
        :return: WebsiteCheckpointRawData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['srv_id', 'check_id', 'period', 'start', 'end', 'datapoints', 'format', 'aggregate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_checkpoint_data_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'srv_id' is set
        if ('srv_id' not in params or
                params['srv_id'] is None):
            raise ValueError("Missing the required parameter `srv_id` when calling `get_website_checkpoint_data_by_id`")  # noqa: E501
        # verify the required parameter 'check_id' is set
        if ('check_id' not in params or
                params['check_id'] is None):
            raise ValueError("Missing the required parameter `check_id` when calling `get_website_checkpoint_data_by_id`")  # noqa: E501

        if 'srv_id' in params and not re.search('\d+', params['srv_id'] if type(params['srv_id']) is str else str(params['srv_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `srv_id` when calling `get_website_checkpoint_data_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'check_id' in params and not re.search('\d+', params['check_id'] if type(params['check_id']) is str else str(params['check_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `check_id` when calling `get_website_checkpoint_data_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'srv_id' in params:
            path_params['srvId'] = params['srv_id']  # noqa: E501
        if 'check_id' in params:
            path_params['checkId'] = params['check_id']  # noqa: E501

        query_params = []
        if 'period' in params:
            query_params.append(('period', params['period']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'datapoints' in params:
            query_params.append(('datapoints', params['datapoints']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'aggregate' in params:
            query_params.append(('aggregate', params['aggregate']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteCheckpointRawData'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{srvId}/checkpoints/{checkId}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_data_by_graph_name(self, id, graph_name, **kwargs):  # noqa: E501
        """get website data by graph name  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_data_by_graph_name(id, graph_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str graph_name: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_data_by_graph_name_with_http_info(id, graph_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_data_by_graph_name_with_http_info(id, graph_name, **kwargs)  # noqa: E501
            return data

    def get_website_data_by_graph_name_with_http_info(self, id, graph_name, **kwargs):  # noqa: E501
        """get website data by graph name  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_data_by_graph_name_with_http_info(id, graph_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str graph_name: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'graph_name', 'start', 'end', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_data_by_graph_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_website_data_by_graph_name`")  # noqa: E501
        # verify the required parameter 'graph_name' is set
        if ('graph_name' not in params or
                params['graph_name'] is None):
            raise ValueError("Missing the required parameter `graph_name` when calling `get_website_data_by_graph_name`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_website_data_by_graph_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'graph_name' in params and not re.search('.+', params['graph_name'] if type(params['graph_name']) is str else str(params['graph_name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `graph_name` when calling `get_website_data_by_graph_name`, must conform to the pattern `/.+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'graph_name' in params:
            path_params['graphName'] = params['graph_name']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GraphPlot'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}/graphs/{graphName}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_graph_data(self, website_id, checkpoint_id, graph_name, **kwargs):  # noqa: E501
        """get website graph data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_graph_data(website_id, checkpoint_id, graph_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int website_id: (required)
        :param int checkpoint_id: (required)
        :param str graph_name: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_graph_data_with_http_info(website_id, checkpoint_id, graph_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_graph_data_with_http_info(website_id, checkpoint_id, graph_name, **kwargs)  # noqa: E501
            return data

    def get_website_graph_data_with_http_info(self, website_id, checkpoint_id, graph_name, **kwargs):  # noqa: E501
        """get website graph data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_graph_data_with_http_info(website_id, checkpoint_id, graph_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int website_id: (required)
        :param int checkpoint_id: (required)
        :param str graph_name: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: GraphPlot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['website_id', 'checkpoint_id', 'graph_name', 'start', 'end', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_graph_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'website_id' is set
        if ('website_id' not in params or
                params['website_id'] is None):
            raise ValueError("Missing the required parameter `website_id` when calling `get_website_graph_data`")  # noqa: E501
        # verify the required parameter 'checkpoint_id' is set
        if ('checkpoint_id' not in params or
                params['checkpoint_id'] is None):
            raise ValueError("Missing the required parameter `checkpoint_id` when calling `get_website_graph_data`")  # noqa: E501
        # verify the required parameter 'graph_name' is set
        if ('graph_name' not in params or
                params['graph_name'] is None):
            raise ValueError("Missing the required parameter `graph_name` when calling `get_website_graph_data`")  # noqa: E501

        if 'website_id' in params and not re.search('\d+', params['website_id'] if type(params['website_id']) is str else str(params['website_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `website_id` when calling `get_website_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'checkpoint_id' in params and not re.search('\d+', params['checkpoint_id'] if type(params['checkpoint_id']) is str else str(params['checkpoint_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `checkpoint_id` when calling `get_website_graph_data`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'graph_name' in params and not re.search('.+', params['graph_name'] if type(params['graph_name']) is str else str(params['graph_name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `graph_name` when calling `get_website_graph_data`, must conform to the pattern `/.+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'website_id' in params:
            path_params['websiteId'] = params['website_id']  # noqa: E501
        if 'checkpoint_id' in params:
            path_params['checkpointId'] = params['checkpoint_id']  # noqa: E501
        if 'graph_name' in params:
            path_params['graphName'] = params['graph_name']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'GraphPlot'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{websiteId}/checkpoints/{checkpointId}/graphs/{graphName}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_group_by_id(self, id, **kwargs):  # noqa: E501
        """get website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_group_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: WebsiteGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_group_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_website_group_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_group_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :return: WebsiteGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_website_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_website_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_group_list(self, **kwargs):  # noqa: E501
        """get website group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_group_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsiteGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_group_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_website_group_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_website_group_list_with_http_info(self, **kwargs):  # noqa: E501
        """get website group list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_group_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsiteGroupPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_group_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteGroupPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_list(self, **kwargs):  # noqa: E501
        """get website list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collector_ids:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsitePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_website_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_website_list_with_http_info(self, **kwargs):  # noqa: E501
        """get website list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collector_ids:
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WebsitePaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collector_ids', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'collector_ids' in params:
            query_params.append(('collectorIds', params['collector_ids']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsitePaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_property_list_by_website_id(self, id, **kwargs):  # noqa: E501
        """get a list of properties for a website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_property_list_by_website_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PropertyPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_property_list_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_property_list_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_website_property_list_by_website_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get a list of properties for a website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_property_list_by_website_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: PropertyPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_property_list_by_website_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_website_property_list_by_website_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_website_property_list_by_website_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'PropertyPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}/properties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_website_sdt_list_by_website_id(self, id, **kwargs):  # noqa: E501
        """get a list of SDTs for a website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_sdt_list_by_website_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_website_sdt_list_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_website_sdt_list_by_website_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_website_sdt_list_by_website_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get a list of SDTs for a website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_website_sdt_list_by_website_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: SDTPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_website_sdt_list_by_website_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_website_sdt_list_by_website_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_website_sdt_list_by_website_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDTPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}/sdts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_widget_by_id(self, id, **kwargs):  # noqa: E501
        """get widget by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_widget_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_widget_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_widget_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get widget by id  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_widget_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_widget_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_widget_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Widget'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/widgets/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_widget_data_by_id(self, id, **kwargs):  # noqa: E501
        """get widget data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_data_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: WidgetData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_widget_data_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_widget_data_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_widget_data_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get widget data  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_data_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str format:
        :return: WidgetData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'format']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_widget_data_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_widget_data_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_widget_data_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WidgetData'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/widgets/{id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_widget_list(self, **kwargs):  # noqa: E501
        """get widget list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WidgetPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_widget_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_widget_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_widget_list_with_http_info(self, **kwargs):  # noqa: E501
        """get widget list  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WidgetPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_widget_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WidgetPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/widgets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_widget_list_by_dashboard_id(self, id, **kwargs):  # noqa: E501
        """get widget list by DashboardId  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_list_by_dashboard_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WidgetPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_widget_list_by_dashboard_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_widget_list_by_dashboard_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_widget_list_by_dashboard_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """get widget list by DashboardId  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_widget_list_by_dashboard_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields:
        :param int size:
        :param int offset:
        :param str filter:
        :return: WidgetPaginationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'size', 'offset', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_widget_list_by_dashboard_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_widget_list_by_dashboard_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `get_widget_list_by_dashboard_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'size' in params:
            query_params.append(('size', params['size']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WidgetPaginationResponse'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/dashboards/{id}/widgets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_batch_job(self, file, **kwargs):  # noqa: E501
        """import batch job via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_batch_job(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_batch_job_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_batch_job_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_batch_job_with_http_info(self, file, **kwargs):  # noqa: E501
        """import batch job via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_batch_job_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_batch_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_batch_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/batchjobs/importxml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_config_source(self, file, **kwargs):  # noqa: E501
        """import config source via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_config_source(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_config_source_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_config_source_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_config_source_with_http_info(self, file, **kwargs):  # noqa: E501
        """import config source via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_config_source_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_config_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_config_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/configsources/importxml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_data_source(self, file, **kwargs):  # noqa: E501
        """import datasource via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_data_source(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_data_source_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_data_source_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_data_source_with_http_info(self, file, **kwargs):  # noqa: E501
        """import datasource via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_data_source_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_data_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_data_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/datasources/importxml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_dns_mapping(self, file, **kwargs):  # noqa: E501
        """import DNS mapping via CSV  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_dns_mapping(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: the csv mapping to be uploaded (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_dns_mapping_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_dns_mapping_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_dns_mapping_with_http_info(self, file, **kwargs):  # noqa: E501
        """import DNS mapping via CSV  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_dns_mapping_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: the csv mapping to be uploaded (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_dns_mapping" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_dns_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/dnsmappings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_event_source(self, file, **kwargs):  # noqa: E501
        """import eventsource via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_event_source(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_event_source_with_http_info(file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_event_source_with_http_info(file, **kwargs)  # noqa: E501
            return data

    def import_event_source_with_http_info(self, file, **kwargs):  # noqa: E501
        """import eventsource via xml  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_event_source_with_http_info(file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_event_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `import_event_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/eventsources/importxml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_admin_by_id(self, id, body, **kwargs):  # noqa: E501
        """update user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_admin_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Admin body: (required)
        :param bool change_password:
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_admin_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_admin_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_admin_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_admin_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Admin body: (required)
        :param bool change_password:
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'change_password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_admin_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_admin_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_admin_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_admin_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'change_password' in params:
            query_params.append(('changePassword', params['change_password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Admin'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_alert_rule_by_id(self, id, body, **kwargs):  # noqa: E501
        """update alert rule  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alert_rule_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param AlertRule body: (required)
        :return: AlertRule
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_alert_rule_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_alert_rule_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_alert_rule_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update alert rule  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_alert_rule_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param AlertRule body: (required)
        :return: AlertRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alert_rule_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_alert_rule_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_alert_rule_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_alert_rule_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AlertRule'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/rules/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_api_token_by_admin_id(self, admin_id, apitoken_id, body, **kwargs):  # noqa: E501
        """update api tokens for a user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_api_token_by_admin_id(admin_id, apitoken_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param int apitoken_id: (required)
        :param APIToken body: (required)
        :return: APIToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_api_token_by_admin_id_with_http_info(admin_id, apitoken_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_api_token_by_admin_id_with_http_info(admin_id, apitoken_id, body, **kwargs)  # noqa: E501
            return data

    def patch_api_token_by_admin_id_with_http_info(self, admin_id, apitoken_id, body, **kwargs):  # noqa: E501
        """update api tokens for a user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_api_token_by_admin_id_with_http_info(admin_id, apitoken_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int admin_id: (required)
        :param int apitoken_id: (required)
        :param APIToken body: (required)
        :return: APIToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['admin_id', 'apitoken_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_api_token_by_admin_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'admin_id' is set
        if ('admin_id' not in params or
                params['admin_id'] is None):
            raise ValueError("Missing the required parameter `admin_id` when calling `patch_api_token_by_admin_id`")  # noqa: E501
        # verify the required parameter 'apitoken_id' is set
        if ('apitoken_id' not in params or
                params['apitoken_id'] is None):
            raise ValueError("Missing the required parameter `apitoken_id` when calling `patch_api_token_by_admin_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_api_token_by_admin_id`")  # noqa: E501

        if 'admin_id' in params and not re.search('\d+', params['admin_id'] if type(params['admin_id']) is str else str(params['admin_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `admin_id` when calling `patch_api_token_by_admin_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'apitoken_id' in params and not re.search('\d+', params['apitoken_id'] if type(params['apitoken_id']) is str else str(params['apitoken_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `apitoken_id` when calling `patch_api_token_by_admin_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'admin_id' in params:
            path_params['adminId'] = params['admin_id']  # noqa: E501
        if 'apitoken_id' in params:
            path_params['apitokenId'] = params['apitoken_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'APIToken'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{adminId}/apitokens/{apitokenId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_applies_to_function(self, id, **kwargs):  # noqa: E501
        """update applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_applies_to_function(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param AppliesToFunction body:
        :param str reason:
        :param bool ignore_reference:
        :return: AppliesToFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_applies_to_function_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_applies_to_function_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def patch_applies_to_function_with_http_info(self, id, **kwargs):  # noqa: E501
        """update applies to function  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_applies_to_function_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param AppliesToFunction body:
        :param str reason:
        :param bool ignore_reference:
        :return: AppliesToFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'reason', 'ignore_reference']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_applies_to_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_applies_to_function`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_applies_to_function`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'reason' in params:
            query_params.append(('reason', params['reason']))  # noqa: E501
        if 'ignore_reference' in params:
            query_params.append(('ignoreReference', params['ignore_reference']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'AppliesToFunction'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/functions/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_collector_by_id(self, id, body, **kwargs):  # noqa: E501
        """update collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_collector_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Collector body: (required)
        :param bool force_update_failed_over_devices:
        :return: Collector
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_collector_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_collector_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_collector_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update collector  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_collector_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Collector body: (required)
        :param bool force_update_failed_over_devices:
        :return: Collector
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'force_update_failed_over_devices']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_collector_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_collector_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_collector_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_collector_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'force_update_failed_over_devices' in params:
            query_params.append(('forceUpdateFailedOverDevices', params['force_update_failed_over_devices']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Collector'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/collectors/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_collector_group_by_id(self, id, body, **kwargs):  # noqa: E501
        """update collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_collector_group_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param CollectorGroup body: (required)
        :param bool force_update_failed_over_devices:
        :return: CollectorGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_collector_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_collector_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_collector_group_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update collector group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_collector_group_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param CollectorGroup body: (required)
        :param bool force_update_failed_over_devices:
        :return: CollectorGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'force_update_failed_over_devices']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_collector_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_collector_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_collector_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_collector_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'force_update_failed_over_devices' in params:
            query_params.append(('forceUpdateFailedOverDevices', params['force_update_failed_over_devices']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'CollectorGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/collector/groups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_dashboard_by_id(self, id, body, **kwargs):  # noqa: E501
        """update dashboard  # noqa: E501

        The template field works only for the POST API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboard_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Dashboard body: (required)
        :param bool overwrite_group_fields:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dashboard_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dashboard_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_dashboard_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update dashboard  # noqa: E501

        The template field works only for the POST API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboard_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Dashboard body: (required)
        :param bool overwrite_group_fields:
        :return: Dashboard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'overwrite_group_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_dashboard_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_dashboard_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_dashboard_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_dashboard_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'overwrite_group_fields' in params:
            query_params.append(('overwriteGroupFields', params['overwrite_group_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Dashboard'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/dashboards/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_dashboard_group_by_id(self, id, body, **kwargs):  # noqa: E501
        """update dashboard group  # noqa: E501

        The template field works only for the POST API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboard_group_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param DashboardGroup body: (required)
        :return: DashboardGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dashboard_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dashboard_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_dashboard_group_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update dashboard group  # noqa: E501

        The template field works only for the POST API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dashboard_group_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param DashboardGroup body: (required)
        :return: DashboardGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_dashboard_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_dashboard_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_dashboard_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_dashboard_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DashboardGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/groups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device(self, id, body, **kwargs):  # noqa: E501
        """update a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Device body: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str op_type:
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Device body: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :param str op_type:
        :return: Device
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'start', 'end', 'netflow_filter', 'op_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501
        if 'op_type' in params:
            query_params.append(('opType', params['op_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Device'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_datasource_instance_alert_setting_by_id(self, device_id, hds_id, instance_id, id, body, **kwargs):  # noqa: E501
        """update device instance alert setting  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_datasource_instance_alert_setting_by_id(device_id, hds_id, instance_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: Device-DataSource ID (required)
        :param int instance_id: (required)
        :param int id: (required)
        :param DeviceDataSourceInstanceAlertSetting body: (required)
        :return: DeviceDataSourceInstanceAlertSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_datasource_instance_alert_setting_by_id_with_http_info(device_id, hds_id, instance_id, id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_datasource_instance_alert_setting_by_id_with_http_info(device_id, hds_id, instance_id, id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_datasource_instance_alert_setting_by_id_with_http_info(self, device_id, hds_id, instance_id, id, body, **kwargs):  # noqa: E501
        """update device instance alert setting  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_datasource_instance_alert_setting_by_id_with_http_info(device_id, hds_id, instance_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: Device-DataSource ID (required)
        :param int instance_id: (required)
        :param int id: (required)
        :param DeviceDataSourceInstanceAlertSetting body: (required)
        :return: DeviceDataSourceInstanceAlertSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'instance_id', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_datasource_instance_alert_setting_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `patch_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `patch_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `patch_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device_datasource_instance_alert_setting_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_datasource_instance_alert_setting_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `patch_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `patch_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'instance_id' in params and not re.search('\d+', params['instance_id'] if type(params['instance_id']) is str else str(params['instance_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `instance_id` when calling `patch_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device_datasource_instance_alert_setting_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceAlertSetting'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_datasource_instance_by_id(self, device_id, hds_id, id, body, **kwargs):  # noqa: E501
        """update device instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_datasource_instance_by_id(device_id, hds_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param DeviceDataSourceInstance body: (required)
        :param str op_type:
        :return: DeviceDataSourceInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_datasource_instance_by_id_with_http_info(self, device_id, hds_id, id, body, **kwargs):  # noqa: E501
        """update device instance  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_datasource_instance_by_id_with_http_info(device_id, hds_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int hds_id: The device-datasource ID (required)
        :param int id: (required)
        :param DeviceDataSourceInstance body: (required)
        :param str op_type:
        :return: DeviceDataSourceInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'hds_id', 'id', 'body', 'op_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_datasource_instance_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `patch_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'hds_id' is set
        if ('hds_id' not in params or
                params['hds_id'] is None):
            raise ValueError("Missing the required parameter `hds_id` when calling `patch_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device_datasource_instance_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_datasource_instance_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `patch_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'hds_id' in params and not re.search('\d+', params['hds_id'] if type(params['hds_id']) is str else str(params['hds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `hds_id` when calling `patch_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device_datasource_instance_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'hds_id' in params:
            path_params['hdsId'] = params['hds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'op_type' in params:
            query_params.append(('opType', params['op_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstance'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_datasource_instance_group_by_id(self, device_id, device_ds_id, id, body, **kwargs):  # noqa: E501
        """update device datasource instance group   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_datasource_instance_group_by_id(device_id, device_ds_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param int id: (required)
        :param DeviceDataSourceInstanceGroup body: (required)
        :return: DeviceDataSourceInstanceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_datasource_instance_group_by_id_with_http_info(device_id, device_ds_id, id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_datasource_instance_group_by_id_with_http_info(device_id, device_ds_id, id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_datasource_instance_group_by_id_with_http_info(self, device_id, device_ds_id, id, body, **kwargs):  # noqa: E501
        """update device datasource instance group   # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_datasource_instance_group_by_id_with_http_info(device_id, device_ds_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param int device_ds_id: The device-datasource ID you'd like to add an instance group for (required)
        :param int id: (required)
        :param DeviceDataSourceInstanceGroup body: (required)
        :return: DeviceDataSourceInstanceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'device_ds_id', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_datasource_instance_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `patch_device_datasource_instance_group_by_id`")  # noqa: E501
        # verify the required parameter 'device_ds_id' is set
        if ('device_ds_id' not in params or
                params['device_ds_id'] is None):
            raise ValueError("Missing the required parameter `device_ds_id` when calling `patch_device_datasource_instance_group_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device_datasource_instance_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_datasource_instance_group_by_id`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `patch_device_datasource_instance_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'device_ds_id' in params and not re.search('\d+', params['device_ds_id'] if type(params['device_ds_id']) is str else str(params['device_ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_ds_id` when calling `patch_device_datasource_instance_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device_datasource_instance_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'device_ds_id' in params:
            path_params['deviceDsId'] = params['device_ds_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceDataSourceInstanceGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_group_by_id(self, id, body, **kwargs):  # noqa: E501
        """update device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param DeviceGroup body: (required)
        :param str op_type:
        :return: DeviceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_group_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update device group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param DeviceGroup body: (required)
        :param str op_type:
        :return: DeviceGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'op_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'op_type' in params:
            query_params.append(('opType', params['op_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_group_cluster_alert_conf_by_id(self, device_group_id, id, body, **kwargs):  # noqa: E501
        """Update cluster alert configuration  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_cluster_alert_conf_by_id(device_group_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :param DeviceClusterAlertConfig body: (required)
        :return: DeviceClusterAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_group_cluster_alert_conf_by_id_with_http_info(self, device_group_id, id, body, **kwargs):  # noqa: E501
        """Update cluster alert configuration  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_cluster_alert_conf_by_id_with_http_info(device_group_id, id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :param DeviceClusterAlertConfig body: (required)
        :return: DeviceClusterAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_group_cluster_alert_conf_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `patch_device_group_cluster_alert_conf_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device_group_cluster_alert_conf_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_group_cluster_alert_conf_by_id`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `patch_device_group_cluster_alert_conf_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device_group_cluster_alert_conf_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceClusterAlertConfig'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/clusterAlertConf/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_group_datasource_alert_setting(self, device_group_id, ds_id, body, **kwargs):  # noqa: E501
        """update device group datasource alert setting  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_datasource_alert_setting(device_group_id, ds_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int ds_id: (required)
        :param DeviceGroupDataSourceAlertConfig body: (required)
        :return: DeviceGroupDataSourceAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_group_datasource_alert_setting_with_http_info(device_group_id, ds_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_group_datasource_alert_setting_with_http_info(device_group_id, ds_id, body, **kwargs)  # noqa: E501
            return data

    def patch_device_group_datasource_alert_setting_with_http_info(self, device_group_id, ds_id, body, **kwargs):  # noqa: E501
        """update device group datasource alert setting  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_datasource_alert_setting_with_http_info(device_group_id, ds_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int ds_id: (required)
        :param DeviceGroupDataSourceAlertConfig body: (required)
        :return: DeviceGroupDataSourceAlertConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'ds_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_group_datasource_alert_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `patch_device_group_datasource_alert_setting`")  # noqa: E501
        # verify the required parameter 'ds_id' is set
        if ('ds_id' not in params or
                params['ds_id'] is None):
            raise ValueError("Missing the required parameter `ds_id` when calling `patch_device_group_datasource_alert_setting`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_group_datasource_alert_setting`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `patch_device_group_datasource_alert_setting`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'ds_id' in params and not re.search('\d+', params['ds_id'] if type(params['ds_id']) is str else str(params['ds_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `ds_id` when calling `patch_device_group_datasource_alert_setting`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'ds_id' in params:
            path_params['dsId'] = params['ds_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupDataSourceAlertConfig'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/datasources/{dsId}/alertsettings', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_group_datasource_by_id(self, device_group_id, id, **kwargs):  # noqa: E501
        """update device group datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_datasource_by_id(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :param DeviceGroupDataSource body:
        :return: DeviceGroupDataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_group_datasource_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_group_datasource_by_id_with_http_info(device_group_id, id, **kwargs)  # noqa: E501
            return data

    def patch_device_group_datasource_by_id_with_http_info(self, device_group_id, id, **kwargs):  # noqa: E501
        """update device group datasource  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_datasource_by_id_with_http_info(device_group_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_group_id: (required)
        :param int id: (required)
        :param DeviceGroupDataSource body:
        :return: DeviceGroupDataSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_group_id', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_group_datasource_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_group_id' is set
        if ('device_group_id' not in params or
                params['device_group_id'] is None):
            raise ValueError("Missing the required parameter `device_group_id` when calling `patch_device_group_datasource_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_device_group_datasource_by_id`")  # noqa: E501

        if 'device_group_id' in params and not re.search('\d+', params['device_group_id'] if type(params['device_group_id']) is str else str(params['device_group_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_group_id` when calling `patch_device_group_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_device_group_datasource_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_group_id' in params:
            path_params['deviceGroupId'] = params['device_group_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'DeviceGroupDataSource'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{deviceGroupId}/datasources/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_group_property_by_name(self, gid, name, body, **kwargs):  # noqa: E501
        """update device group property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_property_by_name(gid, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str name: (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_group_property_by_name_with_http_info(gid, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_group_property_by_name_with_http_info(gid, name, body, **kwargs)  # noqa: E501
            return data

    def patch_device_group_property_by_name_with_http_info(self, gid, name, body, **kwargs):  # noqa: E501
        """update device group property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_group_property_by_name_with_http_info(gid, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int gid: group ID (required)
        :param str name: (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['gid', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_group_property_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'gid' is set
        if ('gid' not in params or
                params['gid'] is None):
            raise ValueError("Missing the required parameter `gid` when calling `patch_device_group_property_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_device_group_property_by_name`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_group_property_by_name`")  # noqa: E501

        if 'gid' in params and not re.search('\d+', params['gid'] if type(params['gid']) is str else str(params['gid'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `gid` when calling `patch_device_group_property_by_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'name' in params and not re.search('[^\/]+', params['name'] if type(params['name']) is str else str(params['name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `name` when calling `patch_device_group_property_by_name`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'gid' in params:
            path_params['gid'] = params['gid']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EntityProperty'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/groups/{gid}/properties/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_device_property_by_name(self, device_id, name, body, **kwargs):  # noqa: E501
        """update device property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_property_by_name(device_id, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str name: (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_device_property_by_name_with_http_info(device_id, name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_device_property_by_name_with_http_info(device_id, name, body, **kwargs)  # noqa: E501
            return data

    def patch_device_property_by_name_with_http_info(self, device_id, name, body, **kwargs):  # noqa: E501
        """update device property  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_device_property_by_name_with_http_info(device_id, name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int device_id: (required)
        :param str name: (required)
        :param EntityProperty body: (required)
        :return: EntityProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['device_id', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_device_property_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'device_id' is set
        if ('device_id' not in params or
                params['device_id'] is None):
            raise ValueError("Missing the required parameter `device_id` when calling `patch_device_property_by_name`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_device_property_by_name`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_device_property_by_name`")  # noqa: E501

        if 'device_id' in params and not re.search('\d+', params['device_id'] if type(params['device_id']) is str else str(params['device_id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `device_id` when calling `patch_device_property_by_name`, must conform to the pattern `/\d+/`")  # noqa: E501
        if 'name' in params and not re.search('[^\/]+', params['name'] if type(params['name']) is str else str(params['name'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `name` when calling `patch_device_property_by_name`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'device_id' in params:
            path_params['deviceId'] = params['device_id']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EntityProperty'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{deviceId}/properties/{name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_escalation_chain_by_id(self, id, body, **kwargs):  # noqa: E501
        """update escalation chain  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_escalation_chain_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param EscalatingChain body: (required)
        :return: EscalatingChain
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_escalation_chain_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_escalation_chain_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_escalation_chain_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update escalation chain  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_escalation_chain_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param EscalatingChain body: (required)
        :return: EscalatingChain
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_escalation_chain_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_escalation_chain_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_escalation_chain_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_escalation_chain_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'EscalatingChain'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/alert/chains/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_netscan(self, id, **kwargs):  # noqa: E501
        """update a netscan  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_netscan(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Netscan body:
        :param str reason:
        :return: Netscan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_netscan_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_netscan_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def patch_netscan_with_http_info(self, id, **kwargs):  # noqa: E501
        """update a netscan  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_netscan_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Netscan body:
        :param str reason:
        :return: Netscan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'reason']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_netscan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_netscan`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_netscan`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'reason' in params:
            query_params.append(('reason', params['reason']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Netscan'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/netscans/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_ops_note_by_id(self, id, body, **kwargs):  # noqa: E501
        """update opsnote  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_ops_note_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param OpsNote body: (required)
        :return: OpsNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_ops_note_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_ops_note_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_ops_note_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update opsnote  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_ops_note_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param OpsNote body: (required)
        :return: OpsNote
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_ops_note_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_ops_note_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_ops_note_by_id`")  # noqa: E501

        if 'id' in params and not re.search('[^\/]+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_ops_note_by_id`, must conform to the pattern `/[^\/]+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'OpsNote'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/opsnotes/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_recipient_group_by_id(self, id, body, **kwargs):  # noqa: E501
        """update recipient group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_recipient_group_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param RecipientGroup body: (required)
        :return: RecipientGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_recipient_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_recipient_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_recipient_group_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update recipient group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_recipient_group_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param RecipientGroup body: (required)
        :return: RecipientGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_recipient_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_recipient_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_recipient_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_recipient_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'RecipientGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/recipientgroups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_report_by_id(self, id, body, **kwargs):  # noqa: E501
        """update report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_report_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param ReportBase body: (required)
        :return: ReportBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_report_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_report_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_report_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update report  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_report_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param ReportBase body: (required)
        :return: ReportBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_report_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_report_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_report_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_report_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportBase'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/reports/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_report_group_by_id(self, id, body, **kwargs):  # noqa: E501
        """update report group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_report_group_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param ReportGroup body: (required)
        :return: ReportGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_report_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_report_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_report_group_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update report group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_report_group_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param ReportGroup body: (required)
        :return: ReportGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_report_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_report_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_report_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_report_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'ReportGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/report/groups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_role_by_id(self, id, body, **kwargs):  # noqa: E501
        """update role  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_role_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Role body: (required)
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_role_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_role_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_role_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update role  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_role_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Role body: (required)
        :return: Role
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_role_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_role_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_role_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_role_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Role'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/roles/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_sdt_by_id(self, id, body, **kwargs):  # noqa: E501
        """update SDT  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_sdt_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param SDT body: (required)
        :return: SDT
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_sdt_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_sdt_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_sdt_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update SDT  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_sdt_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param SDT body: (required)
        :return: SDT
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_sdt_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_sdt_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_sdt_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'SDT'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/sdt/sdts/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_website_by_id(self, id, body, **kwargs):  # noqa: E501
        """update website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_website_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Website body: (required)
        :param str op_type:
        :return: Website
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_website_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_website_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_website_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update website  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_website_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Website body: (required)
        :param str op_type:
        :return: Website
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'op_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_website_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_website_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_website_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_website_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'op_type' in params:
            query_params.append(('opType', params['op_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Website'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/websites/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_website_group_by_id(self, id, body, **kwargs):  # noqa: E501
        """update website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_website_group_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param WebsiteGroup body: (required)
        :param str op_type:
        :return: WebsiteGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_website_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_website_group_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_website_group_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update website group  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_website_group_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param WebsiteGroup body: (required)
        :param str op_type:
        :return: WebsiteGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'op_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_website_group_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_website_group_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_website_group_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_website_group_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'op_type' in params:
            query_params.append(('opType', params['op_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'WebsiteGroup'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/website/groups/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def patch_widget_by_id(self, id, body, **kwargs):  # noqa: E501
        """update widget  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_widget_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Widget body: (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_widget_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_widget_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def patch_widget_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update widget  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_widget_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Widget body: (required)
        :return: Widget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_widget_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `patch_widget_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_widget_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `patch_widget_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Widget'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/dashboard/widgets/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedule_auto_discovery_by_device_id(self, id, **kwargs):  # noqa: E501
        """schedule active discovery for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedule_auto_discovery_by_device_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.schedule_auto_discovery_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.schedule_auto_discovery_by_device_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def schedule_auto_discovery_by_device_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """schedule active discovery for a device  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedule_auto_discovery_by_device_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param int start:
        :param int end:
        :param str netflow_filter:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'start', 'end', 'netflow_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method schedule_auto_discovery_by_device_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `schedule_auto_discovery_by_device_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `schedule_auto_discovery_by_device_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'netflow_filter' in params:
            query_params.append(('netflowFilter', params['netflow_filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'object'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/device/devices/{id}/scheduleAutoDiscovery', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=_response_type,
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', _preload_content_value),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_admin_by_id(self, id, body, **kwargs):  # noqa: E501
        """update user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_admin_by_id(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Admin body: (required)
        :param bool change_password:
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_admin_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_admin_by_id_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def update_admin_by_id_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """update user  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_admin_by_id_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Admin body: (required)
        :param bool change_password:
        :return: Admin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body', 'change_password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_admin_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_admin_by_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_admin_by_id`")  # noqa: E501

        if 'id' in params and not re.search('\d+', params['id'] if type(params['id']) is str else str(params['id'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `id` when calling `update_admin_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'change_password' in params:
            query_params.append(('changePassword', params['change_password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['LMv1']  # noqa: E501
        # if the response type is a file, set _preload_content_value=false.
        # Because python 3.0+ 'utf-8' codec can't decode the binary string
        _response_type = 'Admin'
        _preload_content_value = True
        if _response_type == 'file':
          _preload_content_value = False


        return self.api_client.call_api(
            '/setting/admins/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
           