# logicmonitor-sdk
LogicMonitor is a SaaS-based performance monitoring platform that provides full visibility into complex, hybrid infrastructures, offering granular performance monitoring and actionable data and insights. logicmonitor_sdk enables you to manage your LogicMonitor account programmatically. Note: For Python SDKs, the REQUEST parameters can contain camelCase or an underscore. However, the RESPONSE parameters will always contain an underscore. For example, the REQUEST parameter can be testLocation or test_location. The RESPONSE parameter will be test_location.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 2.0.0
- Package version: 2.0.163
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import logicmonitor_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import logicmonitor_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import logicmonitor_sdk
from logicmonitor_sdk.rest import ApiException
from pprint import pprint

# Configure API key authorization: LMv1
configuration = logicmonitor_sdk.Configuration()
configuration.company = 'YOUR_COMPANY'
configuration.access_id = 'YOUR_ACCESS_ID'
configuration.access_key = 'YOUR_ACCESS_KEY'

# create an instance of the API class
api_instance = logicmonitor_sdk.LMApi(logicmonitor_sdk.ApiClient(configuration))
body = logicmonitor_sdk.AlertAck() # AlertAck | 
id = 'id_example' # str | 

try:
    # ack alert by id
    api_response = api_instance.ack_alert_by_id(body, id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling LMApi->ack_alert_by_id: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/santaba/rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LMApi* | [**ack_alert_by_id**](docs/LMApi.md#ack_alert_by_id) | **POST** /alert/alerts/{id}/ack | ack alert by id
*LMApi* | [**ack_collector_down_alert_by_id**](docs/LMApi.md#ack_collector_down_alert_by_id) | **POST** /setting/collector/collectors/{id}/ackdown | ack collector down alert
*LMApi* | [**add_admin**](docs/LMApi.md#add_admin) | **POST** /setting/admins | add user
*LMApi* | [**add_alert_note_by_id**](docs/LMApi.md#add_alert_note_by_id) | **POST** /alert/alerts/{id}/note | add alert note
*LMApi* | [**add_alert_rule**](docs/LMApi.md#add_alert_rule) | **POST** /setting/alert/rules | add alert rule
*LMApi* | [**add_api_token_by_admin_id**](docs/LMApi.md#add_api_token_by_admin_id) | **POST** /setting/admins/{adminId}/apitokens | add api tokens for a user
*LMApi* | [**add_applies_to_function**](docs/LMApi.md#add_applies_to_function) | **POST** /setting/functions | add applies to function
*LMApi* | [**add_collector**](docs/LMApi.md#add_collector) | **POST** /setting/collector/collectors | add collector
*LMApi* | [**add_collector_group**](docs/LMApi.md#add_collector_group) | **POST** /setting/collector/groups | add collector group
*LMApi* | [**add_dashboard**](docs/LMApi.md#add_dashboard) | **POST** /dashboard/dashboards | add dashboard
*LMApi* | [**add_dashboard_group**](docs/LMApi.md#add_dashboard_group) | **POST** /dashboard/groups | add dashboard group
*LMApi* | [**add_device**](docs/LMApi.md#add_device) | **POST** /device/devices | add a new device
*LMApi* | [**add_device_datasource_instance**](docs/LMApi.md#add_device_datasource_instance) | **POST** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances | add device instance 
*LMApi* | [**add_device_datasource_instance_group**](docs/LMApi.md#add_device_datasource_instance_group) | **POST** /device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups | add device datasource instance group 
*LMApi* | [**add_device_group**](docs/LMApi.md#add_device_group) | **POST** /device/groups | add device group
*LMApi* | [**add_device_group_cluster_alert_conf**](docs/LMApi.md#add_device_group_cluster_alert_conf) | **POST** /device/groups/{deviceGroupId}/clusterAlertConf | Add cluster alert configuration
*LMApi* | [**add_device_group_property**](docs/LMApi.md#add_device_group_property) | **POST** /device/groups/{gid}/properties | add device group property
*LMApi* | [**add_device_property**](docs/LMApi.md#add_device_property) | **POST** /device/devices/{deviceId}/properties | add device property
*LMApi* | [**add_escalation_chain**](docs/LMApi.md#add_escalation_chain) | **POST** /setting/alert/chains | add escalation chain
*LMApi* | [**add_netscan**](docs/LMApi.md#add_netscan) | **POST** /setting/netscans | add a new netscan
*LMApi* | [**add_ops_note**](docs/LMApi.md#add_ops_note) | **POST** /setting/opsnotes | add opsnote
*LMApi* | [**add_recipient_group**](docs/LMApi.md#add_recipient_group) | **POST** /setting/recipientgroups | add recipient group
*LMApi* | [**add_report**](docs/LMApi.md#add_report) | **POST** /report/reports | add report
*LMApi* | [**add_report_group**](docs/LMApi.md#add_report_group) | **POST** /report/groups | add report group
*LMApi* | [**add_role**](docs/LMApi.md#add_role) | **POST** /setting/roles | add role
*LMApi* | [**add_sdt**](docs/LMApi.md#add_sdt) | **POST** /sdt/sdts | add SDT
*LMApi* | [**add_website**](docs/LMApi.md#add_website) | **POST** /website/websites | add website
*LMApi* | [**add_website_group**](docs/LMApi.md#add_website_group) | **POST** /website/groups | add website group
*LMApi* | [**add_widget**](docs/LMApi.md#add_widget) | **POST** /dashboard/widgets | add widget
*LMApi* | [**collect_device_config_source_config**](docs/LMApi.md#collect_device_config_source_config) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/config/collectNow | collect a config for a device
*LMApi* | [**delete_admin_by_id**](docs/LMApi.md#delete_admin_by_id) | **DELETE** /setting/admins/{id} | delete user
*LMApi* | [**delete_alert_rule_by_id**](docs/LMApi.md#delete_alert_rule_by_id) | **DELETE** /setting/alert/rules/{id} | delete alert rule
*LMApi* | [**delete_api_token_by_id**](docs/LMApi.md#delete_api_token_by_id) | **DELETE** /setting/admins/{adminId}/apitokens/{apitokenId} | delete apiToken
*LMApi* | [**delete_applies_to_function_by_id**](docs/LMApi.md#delete_applies_to_function_by_id) | **DELETE** /setting/functions/{id} | delete applies to function
*LMApi* | [**delete_collector_by_id**](docs/LMApi.md#delete_collector_by_id) | **DELETE** /setting/collector/collectors/{id} | delete collector
*LMApi* | [**delete_collector_group_by_id**](docs/LMApi.md#delete_collector_group_by_id) | **DELETE** /setting/collector/groups/{id} | delete collector group
*LMApi* | [**delete_dashboard_by_id**](docs/LMApi.md#delete_dashboard_by_id) | **DELETE** /dashboard/dashboards/{id} | delete dashboard
*LMApi* | [**delete_dashboard_group_by_id**](docs/LMApi.md#delete_dashboard_group_by_id) | **DELETE** /dashboard/groups/{id} | delete dashboard group
*LMApi* | [**delete_datasource_by_id**](docs/LMApi.md#delete_datasource_by_id) | **DELETE** /setting/datasources/{id} | delete datasource
*LMApi* | [**delete_device_by_id**](docs/LMApi.md#delete_device_by_id) | **DELETE** /device/devices/{id} | delete a device
*LMApi* | [**delete_device_datasource_instance_by_id**](docs/LMApi.md#delete_device_datasource_instance_by_id) | **DELETE** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id} | delete a device instance
*LMApi* | [**delete_device_group_by_id**](docs/LMApi.md#delete_device_group_by_id) | **DELETE** /device/groups/{id} | delete device group
*LMApi* | [**delete_device_group_cluster_alert_conf_by_id**](docs/LMApi.md#delete_device_group_cluster_alert_conf_by_id) | **DELETE** /device/groups/{deviceGroupId}/clusterAlertConf/{id} | Delete cluster alert configuration
*LMApi* | [**delete_device_group_property_by_name**](docs/LMApi.md#delete_device_group_property_by_name) | **DELETE** /device/groups/{gid}/properties/{name} | delete device group property
*LMApi* | [**delete_device_property_by_name**](docs/LMApi.md#delete_device_property_by_name) | **DELETE** /device/devices/{deviceId}/properties/{name} | delete device property
*LMApi* | [**delete_escalation_chain_by_id**](docs/LMApi.md#delete_escalation_chain_by_id) | **DELETE** /setting/alert/chains/{id} | delete escalation chain
*LMApi* | [**delete_netscan_by_id**](docs/LMApi.md#delete_netscan_by_id) | **DELETE** /setting/netscans/{id} | delete a netscan
*LMApi* | [**delete_ops_note_by_id**](docs/LMApi.md#delete_ops_note_by_id) | **DELETE** /setting/opsnotes/{id} | delete opsnote
*LMApi* | [**delete_recipient_group_by_id**](docs/LMApi.md#delete_recipient_group_by_id) | **DELETE** /setting/recipientgroups/{id} | delete recipient group
*LMApi* | [**delete_report_by_id**](docs/LMApi.md#delete_report_by_id) | **DELETE** /report/reports/{id} | delete report
*LMApi* | [**delete_report_group_by_id**](docs/LMApi.md#delete_report_group_by_id) | **DELETE** /report/groups/{id} | delete report group
*LMApi* | [**delete_role_by_id**](docs/LMApi.md#delete_role_by_id) | **DELETE** /setting/roles/{id} | delete role
*LMApi* | [**delete_sdt_by_id**](docs/LMApi.md#delete_sdt_by_id) | **DELETE** /sdt/sdts/{id} | delete SDT
*LMApi* | [**delete_website_by_id**](docs/LMApi.md#delete_website_by_id) | **DELETE** /website/websites/{id} | delete website
*LMApi* | [**delete_website_group_by_id**](docs/LMApi.md#delete_website_group_by_id) | **DELETE** /website/groups/{id} | delete website group
*LMApi* | [**delete_widget_by_id**](docs/LMApi.md#delete_widget_by_id) | **DELETE** /dashboard/widgets/{id} | delete widget
*LMApi* | [**execute_debug_command**](docs/LMApi.md#execute_debug_command) | **POST** /debug | Execute a Collector debug command
*LMApi* | [**fetch_device_instances_data**](docs/LMApi.md#fetch_device_instances_data) | **POST** /device/instances/datafetch | fetch device instances data
*LMApi* | [**generate_report_by_id**](docs/LMApi.md#generate_report_by_id) | **POST** /report/reports/{id}/executions | run a report
*LMApi* | [**get_admin_by_id**](docs/LMApi.md#get_admin_by_id) | **GET** /setting/admins/{id} | get user
*LMApi* | [**get_admin_list**](docs/LMApi.md#get_admin_list) | **GET** /setting/admins | get user list
*LMApi* | [**get_alert_by_id**](docs/LMApi.md#get_alert_by_id) | **GET** /alert/alerts/{id} | get alert
*LMApi* | [**get_alert_list**](docs/LMApi.md#get_alert_list) | **GET** /alert/alerts | get alert list
*LMApi* | [**get_alert_list_by_device_group_id**](docs/LMApi.md#get_alert_list_by_device_group_id) | **GET** /device/groups/{id}/alerts | get device group alerts
*LMApi* | [**get_alert_list_by_device_id**](docs/LMApi.md#get_alert_list_by_device_id) | **GET** /device/devices/{id}/alerts | get alerts
*LMApi* | [**get_alert_rule_by_id**](docs/LMApi.md#get_alert_rule_by_id) | **GET** /setting/alert/rules/{id} | get alert rule by id
*LMApi* | [**get_alert_rule_list**](docs/LMApi.md#get_alert_rule_list) | **GET** /setting/alert/rules | get alert rule list
*LMApi* | [**get_all_sdt_list_by_device_id**](docs/LMApi.md#get_all_sdt_list_by_device_id) | **GET** /device/devices/{id}/sdts | get SDTs for a device
*LMApi* | [**get_all_sdt_list_by_website_group_id**](docs/LMApi.md#get_all_sdt_list_by_website_group_id) | **GET** /website/groups/{id}/sdts | get a list of SDTs for a website group
*LMApi* | [**get_api_token_list**](docs/LMApi.md#get_api_token_list) | **GET** /setting/admins/apitokens | get a list of api tokens across users
*LMApi* | [**get_api_token_list_by_admin_id**](docs/LMApi.md#get_api_token_list_by_admin_id) | **GET** /setting/admins/{adminId}/apitokens | get api tokens for a user
*LMApi* | [**get_applies_to_function_by_id**](docs/LMApi.md#get_applies_to_function_by_id) | **GET** /setting/functions/{id} | get applies to function
*LMApi* | [**get_applies_to_function_list**](docs/LMApi.md#get_applies_to_function_list) | **GET** /setting/functions | get applies to function list
*LMApi* | [**get_associated_device_list_by_data_source_id**](docs/LMApi.md#get_associated_device_list_by_data_source_id) | **GET** /setting/datasources/{id}/devices | get devices associated with a datasource
*LMApi* | [**get_audit_log_by_id**](docs/LMApi.md#get_audit_log_by_id) | **GET** /setting/accesslogs/{id} | Get audit log by id
*LMApi* | [**get_audit_log_list**](docs/LMApi.md#get_audit_log_list) | **GET** /setting/accesslogs | Get audit logs
*LMApi* | [**get_aws_external_id**](docs/LMApi.md#get_aws_external_id) | **GET** /aws/externalId | Get AWS external id
*LMApi* | [**get_collector_by_id**](docs/LMApi.md#get_collector_by_id) | **GET** /setting/collector/collectors/{id} | get collector
*LMApi* | [**get_collector_group_by_id**](docs/LMApi.md#get_collector_group_by_id) | **GET** /setting/collector/groups/{id} | get collector group
*LMApi* | [**get_collector_group_list**](docs/LMApi.md#get_collector_group_list) | **GET** /setting/collector/groups | get collector group list
*LMApi* | [**get_collector_installer**](docs/LMApi.md#get_collector_installer) | **GET** /setting/collector/collectors/{collectorId}/installers/{osAndArch} | get collector installer
*LMApi* | [**get_collector_list**](docs/LMApi.md#get_collector_list) | **GET** /setting/collector/collectors | get collector list
*LMApi* | [**get_collector_version_list**](docs/LMApi.md#get_collector_version_list) | **GET** /setting/collector/collectors/versions | get collector version list
*LMApi* | [**get_dashboard_by_id**](docs/LMApi.md#get_dashboard_by_id) | **GET** /dashboard/dashboards/{id} | get dashboard
*LMApi* | [**get_dashboard_group_by_id**](docs/LMApi.md#get_dashboard_group_by_id) | **GET** /dashboard/groups/{id} | get dashboard group
*LMApi* | [**get_dashboard_group_list**](docs/LMApi.md#get_dashboard_group_list) | **GET** /dashboard/groups | get dashboard group list
*LMApi* | [**get_dashboard_list**](docs/LMApi.md#get_dashboard_list) | **GET** /dashboard/dashboards | get dashboard list
*LMApi* | [**get_data_source_overview_graph_by_id**](docs/LMApi.md#get_data_source_overview_graph_by_id) | **GET** /setting/datasources/{dsId}/ographs/{id} | get datasource overview graph by id
*LMApi* | [**get_data_source_overview_graph_list**](docs/LMApi.md#get_data_source_overview_graph_list) | **GET** /setting/datasources/{dsId}/ographs | get datasource overview graph list
*LMApi* | [**get_datasource_by_id**](docs/LMApi.md#get_datasource_by_id) | **GET** /setting/datasources/{id} | get datasource by id
*LMApi* | [**get_datasource_list**](docs/LMApi.md#get_datasource_list) | **GET** /setting/datasources | get datasource list
*LMApi* | [**get_debug_command_result**](docs/LMApi.md#get_debug_command_result) | **GET** /debug/{id} | Get the result of a Collector debug command
*LMApi* | [**get_device_by_id**](docs/LMApi.md#get_device_by_id) | **GET** /device/devices/{id} | get device by id
*LMApi* | [**get_device_config_source_config_by_id**](docs/LMApi.md#get_device_config_source_config_by_id) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/config/{id} | get a config for a device
*LMApi* | [**get_device_config_source_config_list**](docs/LMApi.md#get_device_config_source_config_list) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/config | get detailed config information for the instance
*LMApi* | [**get_device_datasource_by_id**](docs/LMApi.md#get_device_datasource_by_id) | **GET** /device/devices/{deviceId}/devicedatasources/{id} | get device datasource 
*LMApi* | [**get_device_datasource_data_by_id**](docs/LMApi.md#get_device_datasource_data_by_id) | **GET** /device/devices/{deviceId}/devicedatasources/{id}/data | get device datasource data 
*LMApi* | [**get_device_datasource_instance_alert_setting_by_id**](docs/LMApi.md#get_device_datasource_instance_alert_setting_by_id) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings/{id} | get device instance alert setting
*LMApi* | [**get_device_datasource_instance_alert_setting_list_of_device**](docs/LMApi.md#get_device_datasource_instance_alert_setting_list_of_device) | **GET** /device/devices/{deviceId}/alertsettings | get a list of alert settings for a device
*LMApi* | [**get_device_datasource_instance_alert_setting_list_of_dsi**](docs/LMApi.md#get_device_datasource_instance_alert_setting_list_of_dsi) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings | get a list of alert settings for a device datasource instance
*LMApi* | [**get_device_datasource_instance_by_id**](docs/LMApi.md#get_device_datasource_instance_by_id) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id} | get device instance 
*LMApi* | [**get_device_datasource_instance_data**](docs/LMApi.md#get_device_datasource_instance_data) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}/data | get device instance data
*LMApi* | [**get_device_datasource_instance_graph_data**](docs/LMApi.md#get_device_datasource_instance_graph_data) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}/graphs/{graphId}/data | get device instance graph data 
*LMApi* | [**get_device_datasource_instance_group_by_id**](docs/LMApi.md#get_device_datasource_instance_group_by_id) | **GET** /device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{id} | get device datasource instance group 
*LMApi* | [**get_device_datasource_instance_group_list**](docs/LMApi.md#get_device_datasource_instance_group_list) | **GET** /device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups | get device datasource instance group list 
*LMApi* | [**get_device_datasource_instance_group_overview_graph_data**](docs/LMApi.md#get_device_datasource_instance_group_overview_graph_data) | **GET** /device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{dsigId}/graphs/{ographId}/data | get device instance group overview graph data 
*LMApi* | [**get_device_datasource_instance_list**](docs/LMApi.md#get_device_datasource_instance_list) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances | get device instance list
*LMApi* | [**get_device_datasource_instance_sdt_history**](docs/LMApi.md#get_device_datasource_instance_sdt_history) | **GET** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id}/historysdts | get device instance SDT history
*LMApi* | [**get_device_datasource_list**](docs/LMApi.md#get_device_datasource_list) | **GET** /device/devices/{deviceId}/devicedatasources | get device datasource list 
*LMApi* | [**get_device_group_by_id**](docs/LMApi.md#get_device_group_by_id) | **GET** /device/groups/{id} | get device group
*LMApi* | [**get_device_group_cluster_alert_conf_by_id**](docs/LMApi.md#get_device_group_cluster_alert_conf_by_id) | **GET** /device/groups/{deviceGroupId}/clusterAlertConf/{id} | Get cluster alert configuration by id
*LMApi* | [**get_device_group_cluster_alert_conf_list**](docs/LMApi.md#get_device_group_cluster_alert_conf_list) | **GET** /device/groups/{deviceGroupId}/clusterAlertConf | get a list of cluster alert configurations for a device group
*LMApi* | [**get_device_group_datasource_alert_setting**](docs/LMApi.md#get_device_group_datasource_alert_setting) | **GET** /device/groups/{deviceGroupId}/datasources/{dsId}/alertsettings | get device group datasource alert setting 
*LMApi* | [**get_device_group_datasource_by_id**](docs/LMApi.md#get_device_group_datasource_by_id) | **GET** /device/groups/{deviceGroupId}/datasources/{id} | get device group datasource
*LMApi* | [**get_device_group_datasource_list**](docs/LMApi.md#get_device_group_datasource_list) | **GET** /device/groups/{deviceGroupId}/datasources | get device group datasource list
*LMApi* | [**get_device_group_list**](docs/LMApi.md#get_device_group_list) | **GET** /device/groups | get device group list
*LMApi* | [**get_device_group_property_by_name**](docs/LMApi.md#get_device_group_property_by_name) | **GET** /device/groups/{gid}/properties/{name} | get device group property by name
*LMApi* | [**get_device_group_property_list**](docs/LMApi.md#get_device_group_property_list) | **GET** /device/groups/{gid}/properties | get device group properties
*LMApi* | [**get_device_group_sdt_list**](docs/LMApi.md#get_device_group_sdt_list) | **GET** /device/groups/{id}/sdts | get device group SDTs
*LMApi* | [**get_device_instance_graph_data_only_by_instance_id**](docs/LMApi.md#get_device_instance_graph_data_only_by_instance_id) | **GET** /device/devicedatasourceinstances/{instanceId}/graphs/{graphId}/data | get device instance data
*LMApi* | [**get_device_instance_list**](docs/LMApi.md#get_device_instance_list) | **GET** /device/devices/{id}/instances | get device instance list
*LMApi* | [**get_device_list**](docs/LMApi.md#get_device_list) | **GET** /device/devices | get device list
*LMApi* | [**get_device_property_by_name**](docs/LMApi.md#get_device_property_by_name) | **GET** /device/devices/{deviceId}/properties/{name} | get device property by name
*LMApi* | [**get_device_property_list**](docs/LMApi.md#get_device_property_list) | **GET** /device/devices/{deviceId}/properties | get device properties
*LMApi* | [**get_escalation_chain_by_id**](docs/LMApi.md#get_escalation_chain_by_id) | **GET** /setting/alert/chains/{id} | get escalation chain by id
*LMApi* | [**get_escalation_chain_list**](docs/LMApi.md#get_escalation_chain_list) | **GET** /setting/alert/chains | get escalation chain list
*LMApi* | [**get_event_source_list**](docs/LMApi.md#get_event_source_list) | **GET** /setting/eventsources | get eventSource list
*LMApi* | [**get_external_api_stats**](docs/LMApi.md#get_external_api_stats) | **GET** /apiStats/externalApis | get external api stats info
*LMApi* | [**get_immediate_device_list_by_device_group_id**](docs/LMApi.md#get_immediate_device_list_by_device_group_id) | **GET** /device/groups/{id}/devices | get immediate devices under group
*LMApi* | [**get_immediate_website_list_by_website_group_id**](docs/LMApi.md#get_immediate_website_list_by_website_group_id) | **GET** /website/groups/{id}/websites | get a list of websites for a group
*LMApi* | [**get_metrics_usage**](docs/LMApi.md#get_metrics_usage) | **GET** /metrics/usage | get metrics usage
*LMApi* | [**get_netflow_endpoint_list**](docs/LMApi.md#get_netflow_endpoint_list) | **GET** /device/devices/{id}/endpoints | get netflow endpoint list
*LMApi* | [**get_netflow_flow_list**](docs/LMApi.md#get_netflow_flow_list) | **GET** /device/devices/{id}/flows | get netflow flow list
*LMApi* | [**get_netflow_port_list**](docs/LMApi.md#get_netflow_port_list) | **GET** /device/devices/{id}/ports | get netflow port list
*LMApi* | [**get_netscan_by_id**](docs/LMApi.md#get_netscan_by_id) | **GET** /setting/netscans/{id} | get netscan by id
*LMApi* | [**get_netscan_list**](docs/LMApi.md#get_netscan_list) | **GET** /setting/netscans | get netscan list
*LMApi* | [**get_ops_note_by_id**](docs/LMApi.md#get_ops_note_by_id) | **GET** /setting/opsnotes/{id} | get opsnote by id
*LMApi* | [**get_ops_note_list**](docs/LMApi.md#get_ops_note_list) | **GET** /setting/opsnotes | get opsnote list
*LMApi* | [**get_recipient_group_by_id**](docs/LMApi.md#get_recipient_group_by_id) | **GET** /setting/recipientgroups/{id} | get recipient group by id
*LMApi* | [**get_recipient_group_list**](docs/LMApi.md#get_recipient_group_list) | **GET** /setting/recipientgroups | get recipient group List
*LMApi* | [**get_report_by_id**](docs/LMApi.md#get_report_by_id) | **GET** /report/reports/{id} | get report by id
*LMApi* | [**get_report_group_by_id**](docs/LMApi.md#get_report_group_by_id) | **GET** /report/groups/{id} | get report group by id
*LMApi* | [**get_report_group_list**](docs/LMApi.md#get_report_group_list) | **GET** /report/groups | get report group list
*LMApi* | [**get_report_list**](docs/LMApi.md#get_report_list) | **GET** /report/reports | get report list
*LMApi* | [**get_role_by_id**](docs/LMApi.md#get_role_by_id) | **GET** /setting/roles/{id} | get role by id
*LMApi* | [**get_role_list**](docs/LMApi.md#get_role_list) | **GET** /setting/roles | get role list
*LMApi* | [**get_sdt_by_id**](docs/LMApi.md#get_sdt_by_id) | **GET** /sdt/sdts/{id} | get SDT by id
*LMApi* | [**get_sdt_history_by_device_data_source_id**](docs/LMApi.md#get_sdt_history_by_device_data_source_id) | **GET** /device/devices/{deviceId}/devicedatasources/{id}/historysdts | get SDT history for the device dataSource
*LMApi* | [**get_sdt_history_by_device_group_id**](docs/LMApi.md#get_sdt_history_by_device_group_id) | **GET** /device/groups/{id}/historysdts | get SDT history for the group
*LMApi* | [**get_sdt_history_by_device_id**](docs/LMApi.md#get_sdt_history_by_device_id) | **GET** /device/devices/{id}/historysdts | get SDT history for the device
*LMApi* | [**get_sdt_history_by_website_group_id**](docs/LMApi.md#get_sdt_history_by_website_group_id) | **GET** /website/groups/{id}/historysdts | get SDT history for the website group
*LMApi* | [**get_sdt_history_by_website_id**](docs/LMApi.md#get_sdt_history_by_website_id) | **GET** /website/websites/{id}/historysdts | get SDT history for the website
*LMApi* | [**get_sdt_list**](docs/LMApi.md#get_sdt_list) | **GET** /sdt/sdts | get SDT list
*LMApi* | [**get_site_monitor_check_point_list**](docs/LMApi.md#get_site_monitor_check_point_list) | **GET** /website/smcheckpoints | get website checkpoint list
*LMApi* | [**get_top_talkers_graph**](docs/LMApi.md#get_top_talkers_graph) | **GET** /device/devices/{id}/topTalkersGraph | get top talkers graph
*LMApi* | [**get_unmonitored_device_list**](docs/LMApi.md#get_unmonitored_device_list) | **GET** /device/unmonitoreddevices | get unmonitored device list
*LMApi* | [**get_update_reason_list_by_data_source_id**](docs/LMApi.md#get_update_reason_list_by_data_source_id) | **GET** /setting/datasources/{id}/updatereasons | get update history for a datasource
*LMApi* | [**get_website_alert_list_by_website_id**](docs/LMApi.md#get_website_alert_list_by_website_id) | **GET** /website/websites/{id}/alerts | get alerts for a website
*LMApi* | [**get_website_by_id**](docs/LMApi.md#get_website_by_id) | **GET** /website/websites/{id} | get website by id
*LMApi* | [**get_website_checkpoint_data_by_id**](docs/LMApi.md#get_website_checkpoint_data_by_id) | **GET** /website/websites/{srvId}/checkpoints/{checkId}/data | get data for a website checkpoint
*LMApi* | [**get_website_data_by_graph_name**](docs/LMApi.md#get_website_data_by_graph_name) | **GET** /website/websites/{id}/graphs/{graphName}/data | get website data by graph name
*LMApi* | [**get_website_graph_data**](docs/LMApi.md#get_website_graph_data) | **GET** /website/websites/{websiteId}/checkpoints/{checkpointId}/graphs/{graphName}/data | get website graph data
*LMApi* | [**get_website_group_by_id**](docs/LMApi.md#get_website_group_by_id) | **GET** /website/groups/{id} | get website group
*LMApi* | [**get_website_group_list**](docs/LMApi.md#get_website_group_list) | **GET** /website/groups | get website group list
*LMApi* | [**get_website_list**](docs/LMApi.md#get_website_list) | **GET** /website/websites | get website list
*LMApi* | [**get_website_property_list_by_website_id**](docs/LMApi.md#get_website_property_list_by_website_id) | **GET** /website/websites/{id}/properties | get a list of properties for a website
*LMApi* | [**get_website_sdt_list_by_website_id**](docs/LMApi.md#get_website_sdt_list_by_website_id) | **GET** /website/websites/{id}/sdts | get a list of SDTs for a website
*LMApi* | [**get_widget_by_id**](docs/LMApi.md#get_widget_by_id) | **GET** /dashboard/widgets/{id} | get widget by id
*LMApi* | [**get_widget_data_by_id**](docs/LMApi.md#get_widget_data_by_id) | **GET** /dashboard/widgets/{id}/data | get widget data
*LMApi* | [**get_widget_list**](docs/LMApi.md#get_widget_list) | **GET** /dashboard/widgets | get widget list
*LMApi* | [**get_widget_list_by_dashboard_id**](docs/LMApi.md#get_widget_list_by_dashboard_id) | **GET** /dashboard/dashboards/{id}/widgets | get widget list by DashboardId
*LMApi* | [**import_batch_job**](docs/LMApi.md#import_batch_job) | **POST** /setting/batchjobs/importxml | import batch job via xml
*LMApi* | [**import_config_source**](docs/LMApi.md#import_config_source) | **POST** /setting/configsources/importxml | import config source via xml
*LMApi* | [**import_data_source**](docs/LMApi.md#import_data_source) | **POST** /setting/datasources/importxml | import datasource via xml
*LMApi* | [**import_dns_mapping**](docs/LMApi.md#import_dns_mapping) | **POST** /setting/dnsmappings | import DNS mapping via CSV
*LMApi* | [**import_event_source**](docs/LMApi.md#import_event_source) | **POST** /setting/eventsources/importxml | import eventsource via xml
*LMApi* | [**patch_admin_by_id**](docs/LMApi.md#patch_admin_by_id) | **PATCH** /setting/admins/{id} | update user
*LMApi* | [**patch_alert_rule_by_id**](docs/LMApi.md#patch_alert_rule_by_id) | **PATCH** /setting/alert/rules/{id} | update alert rule
*LMApi* | [**patch_api_token_by_admin_id**](docs/LMApi.md#patch_api_token_by_admin_id) | **PATCH** /setting/admins/{adminId}/apitokens/{apitokenId} | update api tokens for a user
*LMApi* | [**patch_applies_to_function**](docs/LMApi.md#patch_applies_to_function) | **PATCH** /setting/functions/{id} | update applies to function
*LMApi* | [**patch_collector_by_id**](docs/LMApi.md#patch_collector_by_id) | **PATCH** /setting/collector/collectors/{id} | update collector
*LMApi* | [**patch_collector_group_by_id**](docs/LMApi.md#patch_collector_group_by_id) | **PATCH** /setting/collector/groups/{id} | update collector group
*LMApi* | [**patch_dashboard_by_id**](docs/LMApi.md#patch_dashboard_by_id) | **PATCH** /dashboard/dashboards/{id} | update dashboard
*LMApi* | [**patch_dashboard_group_by_id**](docs/LMApi.md#patch_dashboard_group_by_id) | **PATCH** /dashboard/groups/{id} | update dashboard group
*LMApi* | [**patch_device**](docs/LMApi.md#patch_device) | **PATCH** /device/devices/{id} | update a device
*LMApi* | [**patch_device_datasource_instance_alert_setting_by_id**](docs/LMApi.md#patch_device_datasource_instance_alert_setting_by_id) | **PATCH** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings/{id} | update device instance alert setting
*LMApi* | [**patch_device_datasource_instance_by_id**](docs/LMApi.md#patch_device_datasource_instance_by_id) | **PATCH** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id} | update device instance
*LMApi* | [**patch_device_datasource_instance_group_by_id**](docs/LMApi.md#patch_device_datasource_instance_group_by_id) | **PATCH** /device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{id} | update device datasource instance group 
*LMApi* | [**patch_device_group_by_id**](docs/LMApi.md#patch_device_group_by_id) | **PATCH** /device/groups/{id} | update device group
*LMApi* | [**patch_device_group_cluster_alert_conf_by_id**](docs/LMApi.md#patch_device_group_cluster_alert_conf_by_id) | **PATCH** /device/groups/{deviceGroupId}/clusterAlertConf/{id} | Update cluster alert configuration
*LMApi* | [**patch_device_group_datasource_alert_setting**](docs/LMApi.md#patch_device_group_datasource_alert_setting) | **PATCH** /device/groups/{deviceGroupId}/datasources/{dsId}/alertsettings | update device group datasource alert setting
*LMApi* | [**patch_device_group_datasource_by_id**](docs/LMApi.md#patch_device_group_datasource_by_id) | **PATCH** /device/groups/{deviceGroupId}/datasources/{id} | update device group datasource
*LMApi* | [**patch_device_group_property_by_name**](docs/LMApi.md#patch_device_group_property_by_name) | **PATCH** /device/groups/{gid}/properties/{name} | update device group property
*LMApi* | [**patch_device_property_by_name**](docs/LMApi.md#patch_device_property_by_name) | **PATCH** /device/devices/{deviceId}/properties/{name} | update device property
*LMApi* | [**patch_escalation_chain_by_id**](docs/LMApi.md#patch_escalation_chain_by_id) | **PATCH** /setting/alert/chains/{id} | update escalation chain
*LMApi* | [**patch_netscan**](docs/LMApi.md#patch_netscan) | **PATCH** /setting/netscans/{id} | update a netscan
*LMApi* | [**patch_ops_note_by_id**](docs/LMApi.md#patch_ops_note_by_id) | **PATCH** /setting/opsnotes/{id} | update opsnote
*LMApi* | [**patch_recipient_group_by_id**](docs/LMApi.md#patch_recipient_group_by_id) | **PATCH** /setting/recipientgroups/{id} | update recipient group
*LMApi* | [**patch_report_by_id**](docs/LMApi.md#patch_report_by_id) | **PATCH** /report/reports/{id} | update report
*LMApi* | [**patch_report_group_by_id**](docs/LMApi.md#patch_report_group_by_id) | **PATCH** /report/groups/{id} | update report group
*LMApi* | [**patch_role_by_id**](docs/LMApi.md#patch_role_by_id) | **PATCH** /setting/roles/{id} | update role
*LMApi* | [**patch_sdt_by_id**](docs/LMApi.md#patch_sdt_by_id) | **PATCH** /sdt/sdts/{id} | update SDT
*LMApi* | [**patch_website_by_id**](docs/LMApi.md#patch_website_by_id) | **PATCH** /website/websites/{id} | update website
*LMApi* | [**patch_website_group_by_id**](docs/LMApi.md#patch_website_group_by_id) | **PATCH** /website/groups/{id} | update website group
*LMApi* | [**patch_widget_by_id**](docs/LMApi.md#patch_widget_by_id) | **PATCH** /dashboard/widgets/{id} | update widget
*LMApi* | [**schedule_auto_discovery_by_device_id**](docs/LMApi.md#schedule_auto_discovery_by_device_id) | **POST** /device/devices/{id}/scheduleAutoDiscovery | schedule active discovery for a device
*LMApi* | [**update_admin_by_id**](docs/LMApi.md#update_admin_by_id) | **PUT** /setting/admins/{id} | update user
*LMApi* | [**update_alert_rule_by_id**](docs/LMApi.md#update_alert_rule_by_id) | **PUT** /setting/alert/rules/{id} | update alert rule
*LMApi* | [**update_api_token_by_admin_id**](docs/LMApi.md#update_api_token_by_admin_id) | **PUT** /setting/admins/{adminId}/apitokens/{apitokenId} | update api tokens for a user
*LMApi* | [**update_applies_to_function**](docs/LMApi.md#update_applies_to_function) | **PUT** /setting/functions/{id} | update applies to function
*LMApi* | [**update_collector_by_id**](docs/LMApi.md#update_collector_by_id) | **PUT** /setting/collector/collectors/{id} | update collector
*LMApi* | [**update_collector_group_by_id**](docs/LMApi.md#update_collector_group_by_id) | **PUT** /setting/collector/groups/{id} | update collector group
*LMApi* | [**update_dashboard_by_id**](docs/LMApi.md#update_dashboard_by_id) | **PUT** /dashboard/dashboards/{id} | update dashboard
*LMApi* | [**update_dashboard_group_by_id**](docs/LMApi.md#update_dashboard_group_by_id) | **PUT** /dashboard/groups/{id} | update dashboard group
*LMApi* | [**update_device**](docs/LMApi.md#update_device) | **PUT** /device/devices/{id} | update a device
*LMApi* | [**update_device_datasource_instance_alert_setting_by_id**](docs/LMApi.md#update_device_datasource_instance_alert_setting_by_id) | **PUT** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{instanceId}/alertsettings/{id} | update device instance alert setting
*LMApi* | [**update_device_datasource_instance_by_id**](docs/LMApi.md#update_device_datasource_instance_by_id) | **PUT** /device/devices/{deviceId}/devicedatasources/{hdsId}/instances/{id} | update device instance
*LMApi* | [**update_device_datasource_instance_group_by_id**](docs/LMApi.md#update_device_datasource_instance_group_by_id) | **PUT** /device/devices/{deviceId}/devicedatasources/{deviceDsId}/groups/{id} | update device datasource instance group 
*LMApi* | [**update_device_group_by_id**](docs/LMApi.md#update_device_group_by_id) | **PUT** /device/groups/{id} | update device group
*LMApi* | [**update_device_group_cluster_alert_conf_by_id**](docs/LMApi.md#update_device_group_cluster_alert_conf_by_id) | **PUT** /device/groups/{deviceGroupId}/clusterAlertConf/{id} | Update cluster alert configuration
*LMApi* | [**update_device_group_datasource_alert_setting**](docs/LMApi.md#update_device_group_datasource_alert_setting) | **PUT** /device/groups/{deviceGroupId}/datasources/{dsId}/alertsettings | update device group datasource alert setting
*LMApi* | [**update_device_group_datasource_by_id**](docs/LMApi.md#update_device_group_datasource_by_id) | **PUT** /device/groups/{deviceGroupId}/datasources/{id} | update device group datasource
*LMApi* | [**update_device_group_property_by_name**](docs/LMApi.md#update_device_group_property_by_name) | **PUT** /device/groups/{gid}/properties/{name} | update device group property
*LMApi* | [**update_device_property_by_name**](docs/LMApi.md#update_device_property_by_name) | **PUT** /device/devices/{deviceId}/properties/{name} | update device property
*LMApi* | [**update_escalation_chain_by_id**](docs/LMApi.md#update_escalation_chain_by_id) | **PUT** /setting/alert/chains/{id} | update escalation chain
*LMApi* | [**update_netscan**](docs/LMApi.md#update_netscan) | **PUT** /setting/netscans/{id} | update a netscan
*LMApi* | [**update_ops_note_by_id**](docs/LMApi.md#update_ops_note_by_id) | **PUT** /setting/opsnotes/{id} | update opsnote
*LMApi* | [**update_recipient_group_by_id**](docs/LMApi.md#update_recipient_group_by_id) | **PUT** /setting/recipientgroups/{id} | update recipient group
*LMApi* | [**update_report_by_id**](docs/LMApi.md#update_report_by_id) | **PUT** /report/reports/{id} | update report
*LMApi* | [**update_report_group_by_id**](docs/LMApi.md#update_report_group_by_id) | **PUT** /report/groups/{id} | update report group
*LMApi* | [**update_role_by_id**](docs/LMApi.md#update_role_by_id) | **PUT** /setting/roles/{id} | update role
*LMApi* | [**update_sdt_by_id**](docs/LMApi.md#update_sdt_by_id) | **PUT** /sdt/sdts/{id} | update SDT
*LMApi* | [**update_website_by_id**](docs/LMApi.md#update_website_by_id) | **PUT** /website/websites/{id} | update website
*LMApi* | [**update_website_group_by_id**](docs/LMApi.md#update_website_group_by_id) | **PUT** /website/groups/{id} | update website group
*LMApi* | [**update_widget_by_id**](docs/LMApi.md#update_widget_by_id) | **PUT** /dashboard/widgets/{id} | update widget


## Documentation For Models

 - [APIToken](docs/APIToken.md)
 - [AccessLogPaginationResponse](docs/AccessLogPaginationResponse.md)
 - [AckCollectorDown](docs/AckCollectorDown.md)
 - [Admin](docs/Admin.md)
 - [AdminPaginationResponse](docs/AdminPaginationResponse.md)
 - [Alert](docs/Alert.md)
 - [AlertAck](docs/AlertAck.md)
 - [AlertFilters](docs/AlertFilters.md)
 - [AlertPaginationResponse](docs/AlertPaginationResponse.md)
 - [AlertRule](docs/AlertRule.md)
 - [AlertRulePaginationResponse](docs/AlertRulePaginationResponse.md)
 - [AlertTrendsMetric](docs/AlertTrendsMetric.md)
 - [ApiPerfMetrics](docs/ApiPerfMetrics.md)
 - [ApiTokenPaginationResponse](docs/ApiTokenPaginationResponse.md)
 - [AppliesToFunction](docs/AppliesToFunction.md)
 - [Assignment](docs/Assignment.md)
 - [AuditLog](docs/AuditLog.md)
 - [Authentication](docs/Authentication.md)
 - [AutoDiscoveryConfiguration](docs/AutoDiscoveryConfiguration.md)
 - [AutoDiscoveryFilter](docs/AutoDiscoveryFilter.md)
 - [AutoDiscoveryMethod](docs/AutoDiscoveryMethod.md)
 - [AutomaticUpgradeInfo](docs/AutomaticUpgradeInfo.md)
 - [AwsAccountTestResult](docs/AwsAccountTestResult.md)
 - [AwsExternalId](docs/AwsExternalId.md)
 - [AzureAccountTestResult](docs/AzureAccountTestResult.md)
 - [BatchJobExecutionItem](docs/BatchJobExecutionItem.md)
 - [BigNumberData](docs/BigNumberData.md)
 - [BigNumberDataPoint](docs/BigNumberDataPoint.md)
 - [BigNumberInfo](docs/BigNumberInfo.md)
 - [BigNumberItem](docs/BigNumberItem.md)
 - [CellData](docs/CellData.md)
 - [Chain](docs/Chain.md)
 - [Collector](docs/Collector.md)
 - [CollectorAttribute](docs/CollectorAttribute.md)
 - [CollectorBase](docs/CollectorBase.md)
 - [CollectorGroup](docs/CollectorGroup.md)
 - [CollectorGroupPaginationResponse](docs/CollectorGroupPaginationResponse.md)
 - [CollectorPaginationResponse](docs/CollectorPaginationResponse.md)
 - [CollectorVersion](docs/CollectorVersion.md)
 - [CollectorVersionPaginationResponse](docs/CollectorVersionPaginationResponse.md)
 - [ColorThreshold](docs/ColorThreshold.md)
 - [ColumnHeader](docs/ColumnHeader.md)
 - [ConversationFilter](docs/ConversationFilter.md)
 - [Counter](docs/Counter.md)
 - [CustomFlexibleVirtualDataSourceEx](docs/CustomFlexibleVirtualDataSourceEx.md)
 - [CustomGraph](docs/CustomGraph.md)
 - [CustomVirtualDataPoint](docs/CustomVirtualDataPoint.md)
 - [Dashboard](docs/Dashboard.md)
 - [DashboardData](docs/DashboardData.md)
 - [DashboardGroup](docs/DashboardGroup.md)
 - [DashboardGroupPaginationResponse](docs/DashboardGroupPaginationResponse.md)
 - [DashboardPaginationResponse](docs/DashboardPaginationResponse.md)
 - [DataPoint](docs/DataPoint.md)
 - [DataSource](docs/DataSource.md)
 - [DataSourceAttribute](docs/DataSourceAttribute.md)
 - [DataSourceOverviewGraph](docs/DataSourceOverviewGraph.md)
 - [DataSourceUpdateReasonsPaginationResponse](docs/DataSourceUpdateReasonsPaginationResponse.md)
 - [DatasourceOverviewGraphPaginationResponse](docs/DatasourceOverviewGraphPaginationResponse.md)
 - [DatasourcePaginationResponse](docs/DatasourcePaginationResponse.md)
 - [DaysUntilAlert](docs/DaysUntilAlert.md)
 - [Debug](docs/Debug.md)
 - [Device](docs/Device.md)
 - [DeviceClusterAlertConfig](docs/DeviceClusterAlertConfig.md)
 - [DeviceClusterAlertConfigPaginationResponse](docs/DeviceClusterAlertConfigPaginationResponse.md)
 - [DeviceDataSource](docs/DeviceDataSource.md)
 - [DeviceDataSourceAssociated](docs/DeviceDataSourceAssociated.md)
 - [DeviceDataSourceAssociatedInstance](docs/DeviceDataSourceAssociatedInstance.md)
 - [DeviceDataSourceAssociatedPaginationResponse](docs/DeviceDataSourceAssociatedPaginationResponse.md)
 - [DeviceDataSourceData](docs/DeviceDataSourceData.md)
 - [DeviceDataSourceInstance](docs/DeviceDataSourceInstance.md)
 - [DeviceDataSourceInstanceAlertSetting](docs/DeviceDataSourceInstanceAlertSetting.md)
 - [DeviceDataSourceInstanceAlertSettingPaginationResponse](docs/DeviceDataSourceInstanceAlertSettingPaginationResponse.md)
 - [DeviceDataSourceInstanceConfig](docs/DeviceDataSourceInstanceConfig.md)
 - [DeviceDataSourceInstanceConfigAlert](docs/DeviceDataSourceInstanceConfigAlert.md)
 - [DeviceDataSourceInstanceConfigDiff](docs/DeviceDataSourceInstanceConfigDiff.md)
 - [DeviceDataSourceInstanceData](docs/DeviceDataSourceInstanceData.md)
 - [DeviceDataSourceInstanceGroup](docs/DeviceDataSourceInstanceGroup.md)
 - [DeviceDataSourceSDTHistoryPaginationResponse](docs/DeviceDataSourceSDTHistoryPaginationResponse.md)
 - [DeviceDatasourceGraph](docs/DeviceDatasourceGraph.md)
 - [DeviceDatasourceInstanceConfigPaginationResponse](docs/DeviceDatasourceInstanceConfigPaginationResponse.md)
 - [DeviceDatasourceInstanceGroupPaginationResponse](docs/DeviceDatasourceInstanceGroupPaginationResponse.md)
 - [DeviceDatasourceInstancePaginationResponse](docs/DeviceDatasourceInstancePaginationResponse.md)
 - [DeviceDatasourcePaginationResponse](docs/DeviceDatasourcePaginationResponse.md)
 - [DeviceGroup](docs/DeviceGroup.md)
 - [DeviceGroupAlertThresholdInfo](docs/DeviceGroupAlertThresholdInfo.md)
 - [DeviceGroupData](docs/DeviceGroupData.md)
 - [DeviceGroupDataSource](docs/DeviceGroupDataSource.md)
 - [DeviceGroupDataSourceAlertConfig](docs/DeviceGroupDataSourceAlertConfig.md)
 - [DeviceGroupDataSourceDataPointConfig](docs/DeviceGroupDataSourceDataPointConfig.md)
 - [DeviceGroupDatasourcePaginationResponse](docs/DeviceGroupDatasourcePaginationResponse.md)
 - [DeviceGroupPaginationResponse](docs/DeviceGroupPaginationResponse.md)
 - [DeviceGroupSDTHistoryPaginationResponse](docs/DeviceGroupSDTHistoryPaginationResponse.md)
 - [DeviceInstanceData](docs/DeviceInstanceData.md)
 - [DeviceInstanceDataPaginationResponse](docs/DeviceInstanceDataPaginationResponse.md)
 - [DeviceInstances](docs/DeviceInstances.md)
 - [DevicePaginationResponse](docs/DevicePaginationResponse.md)
 - [DeviceSDTHistoryPaginationResponse](docs/DeviceSDTHistoryPaginationResponse.md)
 - [DynamicColumn](docs/DynamicColumn.md)
 - [DynamicTableWidgetColumn](docs/DynamicTableWidgetColumn.md)
 - [DynamicTableWidgetRow](docs/DynamicTableWidgetRow.md)
 - [EC2NetscanPolicyCredential](docs/EC2NetscanPolicyCredential.md)
 - [Ec2DDR](docs/Ec2DDR.md)
 - [EndpointPaginationResponse](docs/EndpointPaginationResponse.md)
 - [EntityProperty](docs/EntityProperty.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [EscalatingChain](docs/EscalatingChain.md)
 - [EscalationChainPaginationResponse](docs/EscalationChainPaginationResponse.md)
 - [EventSource](docs/EventSource.md)
 - [EventSourcePaginationResponse](docs/EventSourcePaginationResponse.md)
 - [ExcludeDuplicateIps](docs/ExcludeDuplicateIps.md)
 - [FlowRecordPaginationResponse](docs/FlowRecordPaginationResponse.md)
 - [GaugeDataPoint](docs/GaugeDataPoint.md)
 - [GcpAccountTestResult](docs/GcpAccountTestResult.md)
 - [GenerateReportRequest](docs/GenerateReportRequest.md)
 - [GenerateReportResult](docs/GenerateReportResult.md)
 - [GlobMatchToggle](docs/GlobMatchToggle.md)
 - [GraphDisplay](docs/GraphDisplay.md)
 - [GraphLine](docs/GraphLine.md)
 - [GraphOpsNoteScope](docs/GraphOpsNoteScope.md)
 - [GraphPlotLine](docs/GraphPlotLine.md)
 - [GraphVirtualDataPoint](docs/GraphVirtualDataPoint.md)
 - [HostInventoryMetric](docs/HostInventoryMetric.md)
 - [ILP](docs/ILP.md)
 - [InheritanceProp](docs/InheritanceProp.md)
 - [ItemData](docs/ItemData.md)
 - [LinkedWmiClass](docs/LinkedWmiClass.md)
 - [LocationData](docs/LocationData.md)
 - [LogFile](docs/LogFile.md)
 - [Macro](docs/Macro.md)
 - [MapItemInfo](docs/MapItemInfo.md)
 - [MatchPattern](docs/MatchPattern.md)
 - [Metric](docs/Metric.md)
 - [NMapDDR](docs/NMapDDR.md)
 - [NMapNetscanPolicyCredential](docs/NMapNetscanPolicyCredential.md)
 - [NOCItemBase](docs/NOCItemBase.md)
 - [NameAndValue](docs/NameAndValue.md)
 - [NetFlowRecord](docs/NetFlowRecord.md)
 - [NetflowDataBase](docs/NetflowDataBase.md)
 - [NetflowEndpoint](docs/NetflowEndpoint.md)
 - [NetflowFilters](docs/NetflowFilters.md)
 - [NetflowPort](docs/NetflowPort.md)
 - [Netscan](docs/Netscan.md)
 - [NetscanPaginationResponse](docs/NetscanPaginationResponse.md)
 - [NetscanPorts](docs/NetscanPorts.md)
 - [NextUpgradeInfo](docs/NextUpgradeInfo.md)
 - [OnetimeUpgradeInfo](docs/OnetimeUpgradeInfo.md)
 - [OpsNote](docs/OpsNote.md)
 - [OpsNotePaginationResponse](docs/OpsNotePaginationResponse.md)
 - [OpsNoteScope](docs/OpsNoteScope.md)
 - [OpsNoteTagBase](docs/OpsNoteTagBase.md)
 - [OverviewGraphDataPoint](docs/OverviewGraphDataPoint.md)
 - [PerfmonCounter](docs/PerfmonCounter.md)
 - [Period](docs/Period.md)
 - [PieChartData](docs/PieChartData.md)
 - [PieChartDataPoint](docs/PieChartDataPoint.md)
 - [PieChartInfo](docs/PieChartInfo.md)
 - [PieChartItem](docs/PieChartItem.md)
 - [PointSource](docs/PointSource.md)
 - [PortPaginationResponse](docs/PortPaginationResponse.md)
 - [Privilege](docs/Privilege.md)
 - [PropertyMatchRule](docs/PropertyMatchRule.md)
 - [PropertyPaginationResponse](docs/PropertyPaginationResponse.md)
 - [RawDataValues](docs/RawDataValues.md)
 - [Recipient](docs/Recipient.md)
 - [RecipientGroup](docs/RecipientGroup.md)
 - [RecipientGroupPaginationResponse](docs/RecipientGroupPaginationResponse.md)
 - [ReportBase](docs/ReportBase.md)
 - [ReportGroup](docs/ReportGroup.md)
 - [ReportGroupPaginationResponse](docs/ReportGroupPaginationResponse.md)
 - [ReportPaginationResponse](docs/ReportPaginationResponse.md)
 - [ReportRecipient](docs/ReportRecipient.md)
 - [RestAppliesToFunctionPaginationResponse](docs/RestAppliesToFunctionPaginationResponse.md)
 - [RestEventSourceFilter](docs/RestEventSourceFilter.md)
 - [RestSchedule](docs/RestSchedule.md)
 - [ResultItem](docs/ResultItem.md)
 - [Role](docs/Role.md)
 - [RolePaginationResponse](docs/RolePaginationResponse.md)
 - [RowData](docs/RowData.md)
 - [SDT](docs/SDT.md)
 - [SDTHistory](docs/SDTHistory.md)
 - [SDTPaginationResponse](docs/SDTPaginationResponse.md)
 - [SNMPILP](docs/SNMPILP.md)
 - [ScriptERIDiscoveryAttributeV2](docs/ScriptERIDiscoveryAttributeV2.md)
 - [SiteMonitorCheckPointPaginationResponse](docs/SiteMonitorCheckPointPaginationResponse.md)
 - [SiteMonitorCheckpoint](docs/SiteMonitorCheckpoint.md)
 - [SlaMetric](docs/SlaMetric.md)
 - [StatsDGraph](docs/StatsDGraph.md)
 - [StatsDGraphDisplay](docs/StatsDGraphDisplay.md)
 - [StatsDMetricDefinition](docs/StatsDMetricDefinition.md)
 - [TableWidgetColumn](docs/TableWidgetColumn.md)
 - [TableWidgetDataPoint](docs/TableWidgetDataPoint.md)
 - [TableWidgetForecastConfiguration](docs/TableWidgetForecastConfiguration.md)
 - [TableWidgetInstanceCell](docs/TableWidgetInstanceCell.md)
 - [TableWidgetRow](docs/TableWidgetRow.md)
 - [TreeNode](docs/TreeNode.md)
 - [UnmonitoredDevicePaginationResponse](docs/UnmonitoredDevicePaginationResponse.md)
 - [UnmonitoredDevices](docs/UnmonitoredDevices.md)
 - [UpdateReason](docs/UpdateReason.md)
 - [Usage](docs/Usage.md)
 - [UserFilter](docs/UserFilter.md)
 - [VirtualDataPoint](docs/VirtualDataPoint.md)
 - [WebCheckStep](docs/WebCheckStep.md)
 - [WebResource](docs/WebResource.md)
 - [Website](docs/Website.md)
 - [WebsiteCheckPoint](docs/WebsiteCheckPoint.md)
 - [WebsiteCheckpointRawData](docs/WebsiteCheckpointRawData.md)
 - [WebsiteCollectorInfo](docs/WebsiteCollectorInfo.md)
 - [WebsiteGroup](docs/WebsiteGroup.md)
 - [WebsiteGroupData](docs/WebsiteGroupData.md)
 - [WebsiteGroupPaginationResponse](docs/WebsiteGroupPaginationResponse.md)
 - [WebsiteGroupSDTHistoryPaginationResponse](docs/WebsiteGroupSDTHistoryPaginationResponse.md)
 - [WebsiteItemConfig](docs/WebsiteItemConfig.md)
 - [WebsiteLocation](docs/WebsiteLocation.md)
 - [WebsitePaginationResponse](docs/WebsitePaginationResponse.md)
 - [WebsiteSDTHistoryPaginationResponse](docs/WebsiteSDTHistoryPaginationResponse.md)
 - [Widget](docs/Widget.md)
 - [WidgetData](docs/WidgetData.md)
 - [WidgetPaginationResponse](docs/WidgetPaginationResponse.md)
 - [WidgetToken](docs/WidgetToken.md)
 - [WidgetTokenInheritance](docs/WidgetTokenInheritance.md)
 - [AWSNetscan](docs/AWSNetscan.md)
 - [AggregateCollectorAttribute](docs/AggregateCollectorAttribute.md)
 - [AlertForecastingReport](docs/AlertForecastingReport.md)
 - [AlertReport](docs/AlertReport.md)
 - [AlertSlaReport](docs/AlertSlaReport.md)
 - [AlertThresholdReport](docs/AlertThresholdReport.md)
 - [AlertTrendsReport](docs/AlertTrendsReport.md)
 - [AlertWidget](docs/AlertWidget.md)
 - [AlertWidgetData](docs/AlertWidgetData.md)
 - [AuditLogReport](docs/AuditLogReport.md)
 - [AwsAutoScalingServiceLimitsCollectorAttribute](docs/AwsAutoScalingServiceLimitsCollectorAttribute.md)
 - [AwsBillingCollectorAttribute](docs/AwsBillingCollectorAttribute.md)
 - [AwsBillingReportCollectorAttribute](docs/AwsBillingReportCollectorAttribute.md)
 - [AwsBillingReportDiscoveryMethod](docs/AwsBillingReportDiscoveryMethod.md)
 - [AwsClassicElbServiceLimitsCollectorAttribute](docs/AwsClassicElbServiceLimitsCollectorAttribute.md)
 - [AwsCloudWatchCollectorAttribute](docs/AwsCloudWatchCollectorAttribute.md)
 - [AwsDynamodbCollectorAttribute](docs/AwsDynamodbCollectorAttribute.md)
 - [AwsEC2ReservedInstanceCollectorAttribute](docs/AwsEC2ReservedInstanceCollectorAttribute.md)
 - [AwsEC2ReservedInstanceCoverageCollectorAttribute](docs/AwsEC2ReservedInstanceCoverageCollectorAttribute.md)
 - [AwsEC2ReservedInstanceCoverageDiscoveryMethod](docs/AwsEC2ReservedInstanceCoverageDiscoveryMethod.md)
 - [AwsEC2ReservedInstanceDiscoveryMethod](docs/AwsEC2ReservedInstanceDiscoveryMethod.md)
 - [AwsEC2ScheduledEventsCollectorAttribute](docs/AwsEC2ScheduledEventsCollectorAttribute.md)
 - [AwsEc2ServiceLimitsCollectorAttribute](docs/AwsEc2ServiceLimitsCollectorAttribute.md)
 - [AwsEcsServiceDetailsCollectorAttribute](docs/AwsEcsServiceDetailsCollectorAttribute.md)
 - [AwsEcsServiceDiscoveryMethod](docs/AwsEcsServiceDiscoveryMethod.md)
 - [AwsElastiCacheDiscoveryMethod](docs/AwsElastiCacheDiscoveryMethod.md)
 - [AwsLBTargetGroupDiscoveryMethod](docs/AwsLBTargetGroupDiscoveryMethod.md)
 - [AwsRedShiftDiscoveryMethod](docs/AwsRedShiftDiscoveryMethod.md)
 - [AwsRssEventSource](docs/AwsRssEventSource.md)
 - [AwsS3CollectorAttribute](docs/AwsS3CollectorAttribute.md)
 - [AwsServiceLimitsFromTrustedAdvisorCollectorAttribute](docs/AwsServiceLimitsFromTrustedAdvisorCollectorAttribute.md)
 - [AwsServiceRegionDiscoveryMethod](docs/AwsServiceRegionDiscoveryMethod.md)
 - [AwsSesServiceLimitsCollectorAttribute](docs/AwsSesServiceLimitsCollectorAttribute.md)
 - [AwsSqsCollectorAttribute](docs/AwsSqsCollectorAttribute.md)
 - [AzureBillingCollectorAttribute](docs/AzureBillingCollectorAttribute.md)
 - [AzureBillingDiscoveryMethod](docs/AzureBillingDiscoveryMethod.md)
 - [AzureInsightsCollectorAttribute](docs/AzureInsightsCollectorAttribute.md)
 - [AzureNetscan](docs/AzureNetscan.md)
 - [AzureNetworkServiceLimitsCollectorAttribute](docs/AzureNetworkServiceLimitsCollectorAttribute.md)
 - [AzureRedisCacheDiscoveryMethod](docs/AzureRedisCacheDiscoveryMethod.md)
 - [AzureResourceHealthCollectorAttribute](docs/AzureResourceHealthCollectorAttribute.md)
 - [AzureRssEventSource](docs/AzureRssEventSource.md)
 - [AzureServiceRegionDiscoveryMethod](docs/AzureServiceRegionDiscoveryMethod.md)
 - [AzureStorageServiceLimitsCollectorAttribute](docs/AzureStorageServiceLimitsCollectorAttribute.md)
 - [AzureSubscriptionDiscoveryMethod](docs/AzureSubscriptionDiscoveryMethod.md)
 - [AzureVMServiceLimitsCollectorAttribute](docs/AzureVMServiceLimitsCollectorAttribute.md)
 - [BasicAuthentication](docs/BasicAuthentication.md)
 - [BatchJobWidget](docs/BatchJobWidget.md)
 - [BatchJobWidgetData](docs/BatchJobWidgetData.md)
 - [BatchScriptCollectorAttribute](docs/BatchScriptCollectorAttribute.md)
 - [BigNumberWidget](docs/BigNumberWidget.md)
 - [BigNumberWidgetData](docs/BigNumberWidgetData.md)
 - [CIMAutoDiscoveryMethod](docs/CIMAutoDiscoveryMethod.md)
 - [CIMCollectorAttribute](docs/CIMCollectorAttribute.md)
 - [CloudWatchAutoDiscoveryMethod](docs/CloudWatchAutoDiscoveryMethod.md)
 - [CollectorAutoDiscoveryMethod](docs/CollectorAutoDiscoveryMethod.md)
 - [CollectorSDT](docs/CollectorSDT.md)
 - [CustomGraphWidget](docs/CustomGraphWidget.md)
 - [CustomReport](docs/CustomReport.md)
 - [DNSCollectorAttribute](docs/DNSCollectorAttribute.md)
 - [DashboardReport](docs/DashboardReport.md)
 - [DataPumpCollectorAttribute](docs/DataPumpCollectorAttribute.md)
 - [DeviceBatchJobSDT](docs/DeviceBatchJobSDT.md)
 - [DeviceClusterAlertDefSDT](docs/DeviceClusterAlertDefSDT.md)
 - [DeviceDataSourceInstanceGroupSDT](docs/DeviceDataSourceInstanceGroupSDT.md)
 - [DeviceDataSourceInstanceSDT](docs/DeviceDataSourceInstanceSDT.md)
 - [DeviceDataSourceSDT](docs/DeviceDataSourceSDT.md)
 - [DeviceEventSourceSDT](docs/DeviceEventSourceSDT.md)
 - [DeviceGroupSDT](docs/DeviceGroupSDT.md)
 - [DeviceNOCItem](docs/DeviceNOCItem.md)
 - [DeviceSDT](docs/DeviceSDT.md)
 - [DeviceSLAWidget](docs/DeviceSLAWidget.md)
 - [DeviceSLAWidgetData](docs/DeviceSLAWidgetData.md)
 - [DeviceStatus](docs/DeviceStatus.md)
 - [DummyAutoDiscoveryMethod](docs/DummyAutoDiscoveryMethod.md)
 - [DynamicTableWidget](docs/DynamicTableWidget.md)
 - [DynamicTableWidgetData](docs/DynamicTableWidgetData.md)
 - [EC2AutoDiscoveryMethod](docs/EC2AutoDiscoveryMethod.md)
 - [EC2ScheduledEventAutoDiscoveryMethod](docs/EC2ScheduledEventAutoDiscoveryMethod.md)
 - [ESXAutoDiscoveryMethod](docs/ESXAutoDiscoveryMethod.md)
 - [ESXCollectorAttribute](docs/ESXCollectorAttribute.md)
 - [Ec2Netscan](docs/Ec2Netscan.md)
 - [EchoEventSource](docs/EchoEventSource.md)
 - [FlashWidget](docs/FlashWidget.md)
 - [GCPNetscan](docs/GCPNetscan.md)
 - [GaugeWidget](docs/GaugeWidget.md)
 - [GaugeWidgetData](docs/GaugeWidgetData.md)
 - [GcpAppEngineDiscoveryMethod](docs/GcpAppEngineDiscoveryMethod.md)
 - [GcpAtomEventSource](docs/GcpAtomEventSource.md)
 - [GcpBillingCollectorAttributeV2](docs/GcpBillingCollectorAttributeV2.md)
 - [GcpBillingDiscoveryMethod](docs/GcpBillingDiscoveryMethod.md)
 - [GcpComputeServiceLimitsCollectorAttributeV2](docs/GcpComputeServiceLimitsCollectorAttributeV2.md)
 - [GcpStackDriverCollectorAttributeV2](docs/GcpStackDriverCollectorAttributeV2.md)
 - [GoogleMapWidget](docs/GoogleMapWidget.md)
 - [GoogleMapWidgetData](docs/GoogleMapWidgetData.md)
 - [GraphPlot](docs/GraphPlot.md)
 - [GroupNetFlowRecord](docs/GroupNetFlowRecord.md)
 - [HostCpuReport](docs/HostCpuReport.md)
 - [HostGroupInventoryReport](docs/HostGroupInventoryReport.md)
 - [HostInventoryReport](docs/HostInventoryReport.md)
 - [HostMetricsReport](docs/HostMetricsReport.md)
 - [HtmlWidget](docs/HtmlWidget.md)
 - [HttpAutoDiscoveryMethod](docs/HttpAutoDiscoveryMethod.md)
 - [IPMIAutoDiscoveryMethod](docs/IPMIAutoDiscoveryMethod.md)
 - [IPMICollectorAttribute](docs/IPMICollectorAttribute.md)
 - [InterfBandwidthReport](docs/InterfBandwidthReport.md)
 - [InternalCollectorAttribute](docs/InternalCollectorAttribute.md)
 - [JDBCAutoDiscoveryMethod](docs/JDBCAutoDiscoveryMethod.md)
 - [JDBCCollectorAttribute](docs/JDBCCollectorAttribute.md)
 - [JMXAutoDiscoveryMethod](docs/JMXAutoDiscoveryMethod.md)
 - [JMXCollectorAttribute](docs/JMXCollectorAttribute.md)
 - [LogFileEventSource](docs/LogFileEventSource.md)
 - [MemcachedCollectorAttribute](docs/MemcachedCollectorAttribute.md)
 - [MongoAutoDiscoveryMethod](docs/MongoAutoDiscoveryMethod.md)
 - [MongoCollectorAttribute](docs/MongoCollectorAttribute.md)
 - [NMapNetscan](docs/NMapNetscan.md)
 - [NOCWidget](docs/NOCWidget.md)
 - [NOCWidgetData](docs/NOCWidgetData.md)
 - [NTLMAuthentication](docs/NTLMAuthentication.md)
 - [NetAppAutoDiscoveryMethod](docs/NetAppAutoDiscoveryMethod.md)
 - [NetAppCollectorAttribute](docs/NetAppCollectorAttribute.md)
 - [NetflowApplication](docs/NetflowApplication.md)
 - [NetflowBandwidth](docs/NetflowBandwidth.md)
 - [NetflowGraphWidget](docs/NetflowGraphWidget.md)
 - [NetflowGroupGraphWidget](docs/NetflowGroupGraphWidget.md)
 - [NetflowGroupWidget](docs/NetflowGroupWidget.md)
 - [NetflowGroupWidgetData](docs/NetflowGroupWidgetData.md)
 - [NetflowQoSReportTableRow](docs/NetflowQoSReportTableRow.md)
 - [NetflowReport](docs/NetflowReport.md)
 - [NetflowWidget](docs/NetflowWidget.md)
 - [NetflowWidgetData](docs/NetflowWidgetData.md)
 - [NormalGraphWidget](docs/NormalGraphWidget.md)
 - [OpenMetricCollectorAttributeV2](docs/OpenMetricCollectorAttributeV2.md)
 - [OpenMetricDiscoveryMethod](docs/OpenMetricDiscoveryMethod.md)
 - [OpsNoteDeviceGroupScope](docs/OpsNoteDeviceGroupScope.md)
 - [OpsNoteDeviceScope](docs/OpsNoteDeviceScope.md)
 - [OpsNoteGroupAllScope](docs/OpsNoteGroupAllScope.md)
 - [OpsNoteWebsiteGroupScope](docs/OpsNoteWebsiteGroupScope.md)
 - [OpsNoteWebsiteScope](docs/OpsNoteWebsiteScope.md)
 - [OverviewGraphWidget](docs/OverviewGraphWidget.md)
 - [PDHAutoDiscoveryMethod](docs/PDHAutoDiscoveryMethod.md)
 - [PerfmonCollectorAttribute](docs/PerfmonCollectorAttribute.md)
 - [PieChartWidget](docs/PieChartWidget.md)
 - [PieChartWidgetData](docs/PieChartWidgetData.md)
 - [PingCheck](docs/PingCheck.md)
 - [PingCollectorAttribute](docs/PingCollectorAttribute.md)
 - [PortAutoDiscoveryMethod](docs/PortAutoDiscoveryMethod.md)
 - [RestIPMIEventSource](docs/RestIPMIEventSource.md)
 - [RoleReport](docs/RoleReport.md)
 - [SDKScriptCollectorAttribute](docs/SDKScriptCollectorAttribute.md)
 - [SDKScriptDiscoveryMethod](docs/SDKScriptDiscoveryMethod.md)
 - [SLAReport](docs/SLAReport.md)
 - [SNMPAutoDiscoveryMethod](docs/SNMPAutoDiscoveryMethod.md)
 - [SNMPCollectorAttribute](docs/SNMPCollectorAttribute.md)
 - [SaasNetScan](docs/SaasNetScan.md)
 - [ScriptAutoDiscoveryMethod](docs/ScriptAutoDiscoveryMethod.md)
 - [ScriptCollectorAttribute](docs/ScriptCollectorAttribute.md)
 - [ScriptEventSource](docs/ScriptEventSource.md)
 - [ScriptNetscan](docs/ScriptNetscan.md)
 - [ServiceAlert](docs/ServiceAlert.md)
 - [ServiceSDT](docs/ServiceSDT.md)
 - [SnmpTrapEventSource](docs/SnmpTrapEventSource.md)
 - [StatsDWidget](docs/StatsDWidget.md)
 - [SysLogEventSource](docs/SysLogEventSource.md)
 - [TCPCollectorAttribute](docs/TCPCollectorAttribute.md)
 - [TableWidget](docs/TableWidget.md)
 - [TableWidgetData](docs/TableWidgetData.md)
 - [TextWidget](docs/TextWidget.md)
 - [UDPCollectorAttribute](docs/UDPCollectorAttribute.md)
 - [UserReport](docs/UserReport.md)
 - [WMIAutoDiscoveryMethod](docs/WMIAutoDiscoveryMethod.md)
 - [WMICollectorAttribute](docs/WMICollectorAttribute.md)
 - [WebCheck](docs/WebCheck.md)
 - [WebPageCollectorAttribute](docs/WebPageCollectorAttribute.md)
 - [WebsiteCheckpointSDT](docs/WebsiteCheckpointSDT.md)
 - [WebsiteGraphWidget](docs/WebsiteGraphWidget.md)
 - [WebsiteGroupSDT](docs/WebsiteGroupSDT.md)
 - [WebsiteIndividualsStatusWidget](docs/WebsiteIndividualsStatusWidget.md)
 - [WebsiteNOCItem](docs/WebsiteNOCItem.md)
 - [WebsiteOverallStatusWidget](docs/WebsiteOverallStatusWidget.md)
 - [WebsiteOverviewReport](docs/WebsiteOverviewReport.md)
 - [WebsiteOverviewWidget](docs/WebsiteOverviewWidget.md)
 - [WebsiteSDT](docs/WebsiteSDT.md)
 - [WebsiteSLAReport](docs/WebsiteSLAReport.md)
 - [WebsiteSLAWidget](docs/WebsiteSLAWidget.md)
 - [WebsiteSLAWidgetData](docs/WebsiteSLAWidgetData.md)
 - [WindowsEventLogEventSource](docs/WindowsEventLogEventSource.md)
 - [XENAutoDiscoveryMethod](docs/XENAutoDiscoveryMethod.md)
 - [XENCollectorAttribute](docs/XENCollectorAttribute.md)


## Documentation For Authorization


## LMv1

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author



