"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Channel(google.protobuf.message.Message):
    """Channel is a logical grouping of channels, subchannels, and sockets."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REF_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    CHANNEL_REF_FIELD_NUMBER: builtins.int
    SUBCHANNEL_REF_FIELD_NUMBER: builtins.int
    SOCKET_REF_FIELD_NUMBER: builtins.int
    @property
    def ref(self) -> global___ChannelRef:
        """The identifier for this channel. This should be set."""
        pass
    @property
    def data(self) -> global___ChannelData:
        """Data specific to this channel.
        At most one of 'channel_ref+subchannel_ref' and 'socket' is set.
        """
        pass
    @property
    def channel_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelRef]:
        """There are no ordering guarantees on the order of channel refs.
        There may not be cycles in the ref graph.
        A channel ref may be present in more than one channel or subchannel.
        """
        pass
    @property
    def subchannel_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SubchannelRef]:
        """At most one of 'channel_ref+subchannel_ref' and 'socket' is set.
        There are no ordering guarantees on the order of subchannel refs.
        There may not be cycles in the ref graph.
        A sub channel ref may be present in more than one channel or subchannel.
        """
        pass
    @property
    def socket_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SocketRef]:
        """There are no ordering guarantees on the order of sockets."""
        pass
    def __init__(self,
        *,
        ref: typing.Optional[global___ChannelRef] = ...,
        data: typing.Optional[global___ChannelData] = ...,
        channel_ref: typing.Optional[typing.Iterable[global___ChannelRef]] = ...,
        subchannel_ref: typing.Optional[typing.Iterable[global___SubchannelRef]] = ...,
        socket_ref: typing.Optional[typing.Iterable[global___SocketRef]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data",b"data","ref",b"ref"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_ref",b"channel_ref","data",b"data","ref",b"ref","socket_ref",b"socket_ref","subchannel_ref",b"subchannel_ref"]) -> None: ...
global___Channel = Channel

class Subchannel(google.protobuf.message.Message):
    """Subchannel is a logical grouping of channels, subchannels, and sockets.
    A subchannel is load balanced over by it's ancestor
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REF_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    CHANNEL_REF_FIELD_NUMBER: builtins.int
    SUBCHANNEL_REF_FIELD_NUMBER: builtins.int
    SOCKET_REF_FIELD_NUMBER: builtins.int
    @property
    def ref(self) -> global___SubchannelRef:
        """The identifier for this channel."""
        pass
    @property
    def data(self) -> global___ChannelData:
        """Data specific to this channel.
        At most one of 'channel_ref+subchannel_ref' and 'socket' is set.
        """
        pass
    @property
    def channel_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelRef]:
        """There are no ordering guarantees on the order of channel refs.
        There may not be cycles in the ref graph.
        A channel ref may be present in more than one channel or subchannel.
        """
        pass
    @property
    def subchannel_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SubchannelRef]:
        """At most one of 'channel_ref+subchannel_ref' and 'socket' is set.
        There are no ordering guarantees on the order of subchannel refs.
        There may not be cycles in the ref graph.
        A sub channel ref may be present in more than one channel or subchannel.
        """
        pass
    @property
    def socket_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SocketRef]:
        """There are no ordering guarantees on the order of sockets."""
        pass
    def __init__(self,
        *,
        ref: typing.Optional[global___SubchannelRef] = ...,
        data: typing.Optional[global___ChannelData] = ...,
        channel_ref: typing.Optional[typing.Iterable[global___ChannelRef]] = ...,
        subchannel_ref: typing.Optional[typing.Iterable[global___SubchannelRef]] = ...,
        socket_ref: typing.Optional[typing.Iterable[global___SocketRef]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data",b"data","ref",b"ref"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_ref",b"channel_ref","data",b"data","ref",b"ref","socket_ref",b"socket_ref","subchannel_ref",b"subchannel_ref"]) -> None: ...
global___Subchannel = Subchannel

class ChannelConnectivityState(google.protobuf.message.Message):
    """These come from the specified states in this document:
    https://github.com/grpc/grpc/blob/master/doc/connectivity-semantics-and-api.md
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _State:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ChannelConnectivityState._State.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: ChannelConnectivityState._State.ValueType  # 0
        IDLE: ChannelConnectivityState._State.ValueType  # 1
        CONNECTING: ChannelConnectivityState._State.ValueType  # 2
        READY: ChannelConnectivityState._State.ValueType  # 3
        TRANSIENT_FAILURE: ChannelConnectivityState._State.ValueType  # 4
        SHUTDOWN: ChannelConnectivityState._State.ValueType  # 5
    class State(_State, metaclass=_StateEnumTypeWrapper):
        pass

    UNKNOWN: ChannelConnectivityState.State.ValueType  # 0
    IDLE: ChannelConnectivityState.State.ValueType  # 1
    CONNECTING: ChannelConnectivityState.State.ValueType  # 2
    READY: ChannelConnectivityState.State.ValueType  # 3
    TRANSIENT_FAILURE: ChannelConnectivityState.State.ValueType  # 4
    SHUTDOWN: ChannelConnectivityState.State.ValueType  # 5

    STATE_FIELD_NUMBER: builtins.int
    state: global___ChannelConnectivityState.State.ValueType
    def __init__(self,
        *,
        state: global___ChannelConnectivityState.State.ValueType = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["state",b"state"]) -> None: ...
global___ChannelConnectivityState = ChannelConnectivityState

class ChannelData(google.protobuf.message.Message):
    """Channel data is data related to a specific Channel or Subchannel."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATE_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    TRACE_FIELD_NUMBER: builtins.int
    CALLS_STARTED_FIELD_NUMBER: builtins.int
    CALLS_SUCCEEDED_FIELD_NUMBER: builtins.int
    CALLS_FAILED_FIELD_NUMBER: builtins.int
    LAST_CALL_STARTED_TIMESTAMP_FIELD_NUMBER: builtins.int
    @property
    def state(self) -> global___ChannelConnectivityState:
        """The connectivity state of the channel or subchannel.  Implementations
        should always set this.
        """
        pass
    target: typing.Text
    """The target this channel originally tried to connect to.  May be absent"""

    @property
    def trace(self) -> global___ChannelTrace:
        """A trace of recent events on the channel.  May be absent."""
        pass
    calls_started: builtins.int
    """The number of calls started on the channel"""

    calls_succeeded: builtins.int
    """The number of calls that have completed with an OK status"""

    calls_failed: builtins.int
    """The number of calls that have completed with a non-OK status"""

    @property
    def last_call_started_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time a call was started on the channel."""
        pass
    def __init__(self,
        *,
        state: typing.Optional[global___ChannelConnectivityState] = ...,
        target: typing.Text = ...,
        trace: typing.Optional[global___ChannelTrace] = ...,
        calls_started: builtins.int = ...,
        calls_succeeded: builtins.int = ...,
        calls_failed: builtins.int = ...,
        last_call_started_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["last_call_started_timestamp",b"last_call_started_timestamp","state",b"state","trace",b"trace"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["calls_failed",b"calls_failed","calls_started",b"calls_started","calls_succeeded",b"calls_succeeded","last_call_started_timestamp",b"last_call_started_timestamp","state",b"state","target",b"target","trace",b"trace"]) -> None: ...
global___ChannelData = ChannelData

class ChannelTraceEvent(google.protobuf.message.Message):
    """A trace event is an interesting thing that happened to a channel or
    subchannel, such as creation, address resolution, subchannel creation, etc.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Severity:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _SeverityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ChannelTraceEvent._Severity.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CT_UNKNOWN: ChannelTraceEvent._Severity.ValueType  # 0
        CT_INFO: ChannelTraceEvent._Severity.ValueType  # 1
        CT_WARNING: ChannelTraceEvent._Severity.ValueType  # 2
        CT_ERROR: ChannelTraceEvent._Severity.ValueType  # 3
    class Severity(_Severity, metaclass=_SeverityEnumTypeWrapper):
        """The supported severity levels of trace events."""
        pass

    CT_UNKNOWN: ChannelTraceEvent.Severity.ValueType  # 0
    CT_INFO: ChannelTraceEvent.Severity.ValueType  # 1
    CT_WARNING: ChannelTraceEvent.Severity.ValueType  # 2
    CT_ERROR: ChannelTraceEvent.Severity.ValueType  # 3

    DESCRIPTION_FIELD_NUMBER: builtins.int
    SEVERITY_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    CHANNEL_REF_FIELD_NUMBER: builtins.int
    SUBCHANNEL_REF_FIELD_NUMBER: builtins.int
    description: typing.Text
    """High level description of the event."""

    severity: global___ChannelTraceEvent.Severity.ValueType
    """the severity of the trace event"""

    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When this event occurred."""
        pass
    @property
    def channel_ref(self) -> global___ChannelRef: ...
    @property
    def subchannel_ref(self) -> global___SubchannelRef: ...
    def __init__(self,
        *,
        description: typing.Text = ...,
        severity: global___ChannelTraceEvent.Severity.ValueType = ...,
        timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        channel_ref: typing.Optional[global___ChannelRef] = ...,
        subchannel_ref: typing.Optional[global___SubchannelRef] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["channel_ref",b"channel_ref","child_ref",b"child_ref","subchannel_ref",b"subchannel_ref","timestamp",b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_ref",b"channel_ref","child_ref",b"child_ref","description",b"description","severity",b"severity","subchannel_ref",b"subchannel_ref","timestamp",b"timestamp"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["child_ref",b"child_ref"]) -> typing.Optional[typing_extensions.Literal["channel_ref","subchannel_ref"]]: ...
global___ChannelTraceEvent = ChannelTraceEvent

class ChannelTrace(google.protobuf.message.Message):
    """ChannelTrace represents the recent events that have occurred on the channel."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NUM_EVENTS_LOGGED_FIELD_NUMBER: builtins.int
    CREATION_TIMESTAMP_FIELD_NUMBER: builtins.int
    EVENTS_FIELD_NUMBER: builtins.int
    num_events_logged: builtins.int
    """Number of events ever logged in this tracing object. This can differ from
    events.size() because events can be overwritten or garbage collected by
    implementations.
    """

    @property
    def creation_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time that this channel was created."""
        pass
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ChannelTraceEvent]:
        """List of events that have occurred on this channel."""
        pass
    def __init__(self,
        *,
        num_events_logged: builtins.int = ...,
        creation_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        events: typing.Optional[typing.Iterable[global___ChannelTraceEvent]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["creation_timestamp",b"creation_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["creation_timestamp",b"creation_timestamp","events",b"events","num_events_logged",b"num_events_logged"]) -> None: ...
global___ChannelTrace = ChannelTrace

class ChannelRef(google.protobuf.message.Message):
    """ChannelRef is a reference to a Channel."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    channel_id: builtins.int
    """The globally unique id for this channel.  Must be a positive number."""

    name: typing.Text
    """An optional name associated with the channel."""

    def __init__(self,
        *,
        channel_id: builtins.int = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_id",b"channel_id","name",b"name"]) -> None: ...
global___ChannelRef = ChannelRef

class SubchannelRef(google.protobuf.message.Message):
    """SubchannelRef is a reference to a Subchannel."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SUBCHANNEL_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    subchannel_id: builtins.int
    """The globally unique id for this subchannel.  Must be a positive number."""

    name: typing.Text
    """An optional name associated with the subchannel."""

    def __init__(self,
        *,
        subchannel_id: builtins.int = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name","subchannel_id",b"subchannel_id"]) -> None: ...
global___SubchannelRef = SubchannelRef

class SocketRef(google.protobuf.message.Message):
    """SocketRef is a reference to a Socket."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOCKET_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    socket_id: builtins.int
    """The globally unique id for this socket.  Must be a positive number."""

    name: typing.Text
    """An optional name associated with the socket."""

    def __init__(self,
        *,
        socket_id: builtins.int = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name","socket_id",b"socket_id"]) -> None: ...
global___SocketRef = SocketRef

class ServerRef(google.protobuf.message.Message):
    """ServerRef is a reference to a Server."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    server_id: builtins.int
    """A globally unique identifier for this server.  Must be a positive number."""

    name: typing.Text
    """An optional name associated with the server."""

    def __init__(self,
        *,
        server_id: builtins.int = ...,
        name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name",b"name","server_id",b"server_id"]) -> None: ...
global___ServerRef = ServerRef

class Server(google.protobuf.message.Message):
    """Server represents a single server.  There may be multiple servers in a single
    program.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REF_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    LISTEN_SOCKET_FIELD_NUMBER: builtins.int
    @property
    def ref(self) -> global___ServerRef:
        """The identifier for a Server.  This should be set."""
        pass
    @property
    def data(self) -> global___ServerData:
        """The associated data of the Server."""
        pass
    @property
    def listen_socket(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SocketRef]:
        """The sockets that the server is listening on.  There are no ordering
        guarantees.  This may be absent.
        """
        pass
    def __init__(self,
        *,
        ref: typing.Optional[global___ServerRef] = ...,
        data: typing.Optional[global___ServerData] = ...,
        listen_socket: typing.Optional[typing.Iterable[global___SocketRef]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data",b"data","ref",b"ref"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data",b"data","listen_socket",b"listen_socket","ref",b"ref"]) -> None: ...
global___Server = Server

class ServerData(google.protobuf.message.Message):
    """ServerData is data for a specific Server."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TRACE_FIELD_NUMBER: builtins.int
    CALLS_STARTED_FIELD_NUMBER: builtins.int
    CALLS_SUCCEEDED_FIELD_NUMBER: builtins.int
    CALLS_FAILED_FIELD_NUMBER: builtins.int
    LAST_CALL_STARTED_TIMESTAMP_FIELD_NUMBER: builtins.int
    @property
    def trace(self) -> global___ChannelTrace:
        """A trace of recent events on the server.  May be absent."""
        pass
    calls_started: builtins.int
    """The number of incoming calls started on the server"""

    calls_succeeded: builtins.int
    """The number of incoming calls that have completed with an OK status"""

    calls_failed: builtins.int
    """The number of incoming calls that have a completed with a non-OK status"""

    @property
    def last_call_started_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time a call was started on the server."""
        pass
    def __init__(self,
        *,
        trace: typing.Optional[global___ChannelTrace] = ...,
        calls_started: builtins.int = ...,
        calls_succeeded: builtins.int = ...,
        calls_failed: builtins.int = ...,
        last_call_started_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["last_call_started_timestamp",b"last_call_started_timestamp","trace",b"trace"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["calls_failed",b"calls_failed","calls_started",b"calls_started","calls_succeeded",b"calls_succeeded","last_call_started_timestamp",b"last_call_started_timestamp","trace",b"trace"]) -> None: ...
global___ServerData = ServerData

class Socket(google.protobuf.message.Message):
    """Information about an actual connection.  Pronounced "sock-ay"."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    REF_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    LOCAL_FIELD_NUMBER: builtins.int
    REMOTE_FIELD_NUMBER: builtins.int
    SECURITY_FIELD_NUMBER: builtins.int
    REMOTE_NAME_FIELD_NUMBER: builtins.int
    @property
    def ref(self) -> global___SocketRef:
        """The identifier for the Socket."""
        pass
    @property
    def data(self) -> global___SocketData:
        """Data specific to this Socket."""
        pass
    @property
    def local(self) -> global___Address:
        """The locally bound address."""
        pass
    @property
    def remote(self) -> global___Address:
        """The remote bound address.  May be absent."""
        pass
    @property
    def security(self) -> global___Security:
        """Security details for this socket.  May be absent if not available, or
        there is no security on the socket.
        """
        pass
    remote_name: typing.Text
    """Optional, represents the name of the remote endpoint, if different than
    the original target name.
    """

    def __init__(self,
        *,
        ref: typing.Optional[global___SocketRef] = ...,
        data: typing.Optional[global___SocketData] = ...,
        local: typing.Optional[global___Address] = ...,
        remote: typing.Optional[global___Address] = ...,
        security: typing.Optional[global___Security] = ...,
        remote_name: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data",b"data","local",b"local","ref",b"ref","remote",b"remote","security",b"security"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data",b"data","local",b"local","ref",b"ref","remote",b"remote","remote_name",b"remote_name","security",b"security"]) -> None: ...
global___Socket = Socket

class SocketData(google.protobuf.message.Message):
    """SocketData is data associated for a specific Socket.  The fields present
    are specific to the implementation, so there may be minor differences in
    the semantics.  (e.g. flow control windows)
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STREAMS_STARTED_FIELD_NUMBER: builtins.int
    STREAMS_SUCCEEDED_FIELD_NUMBER: builtins.int
    STREAMS_FAILED_FIELD_NUMBER: builtins.int
    MESSAGES_SENT_FIELD_NUMBER: builtins.int
    MESSAGES_RECEIVED_FIELD_NUMBER: builtins.int
    KEEP_ALIVES_SENT_FIELD_NUMBER: builtins.int
    LAST_LOCAL_STREAM_CREATED_TIMESTAMP_FIELD_NUMBER: builtins.int
    LAST_REMOTE_STREAM_CREATED_TIMESTAMP_FIELD_NUMBER: builtins.int
    LAST_MESSAGE_SENT_TIMESTAMP_FIELD_NUMBER: builtins.int
    LAST_MESSAGE_RECEIVED_TIMESTAMP_FIELD_NUMBER: builtins.int
    LOCAL_FLOW_CONTROL_WINDOW_FIELD_NUMBER: builtins.int
    REMOTE_FLOW_CONTROL_WINDOW_FIELD_NUMBER: builtins.int
    OPTION_FIELD_NUMBER: builtins.int
    streams_started: builtins.int
    """The number of streams that have been started."""

    streams_succeeded: builtins.int
    """The number of streams that have ended successfully:
    On client side, received frame with eos bit set;
    On server side, sent frame with eos bit set.
    """

    streams_failed: builtins.int
    """The number of streams that have ended unsuccessfully:
    On client side, ended without receiving frame with eos bit set;
    On server side, ended without sending frame with eos bit set.
    """

    messages_sent: builtins.int
    """The number of grpc messages successfully sent on this socket."""

    messages_received: builtins.int
    """The number of grpc messages received on this socket."""

    keep_alives_sent: builtins.int
    """The number of keep alives sent.  This is typically implemented with HTTP/2
    ping messages.
    """

    @property
    def last_local_stream_created_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time a stream was created by this endpoint.  Usually unset for
        servers.
        """
        pass
    @property
    def last_remote_stream_created_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time a stream was created by the remote endpoint.  Usually unset
        for clients.
        """
        pass
    @property
    def last_message_sent_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time a message was sent by this endpoint."""
        pass
    @property
    def last_message_received_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time a message was received by this endpoint."""
        pass
    @property
    def local_flow_control_window(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The amount of window, granted to the local endpoint by the remote endpoint.
        This may be slightly out of date due to network latency.  This does NOT
        include stream level or TCP level flow control info.
        """
        pass
    @property
    def remote_flow_control_window(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The amount of window, granted to the remote endpoint by the local endpoint.
        This may be slightly out of date due to network latency.  This does NOT
        include stream level or TCP level flow control info.
        """
        pass
    @property
    def option(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SocketOption]:
        """Socket options set on this socket.  May be absent if 'summary' is set
        on GetSocketRequest.
        """
        pass
    def __init__(self,
        *,
        streams_started: builtins.int = ...,
        streams_succeeded: builtins.int = ...,
        streams_failed: builtins.int = ...,
        messages_sent: builtins.int = ...,
        messages_received: builtins.int = ...,
        keep_alives_sent: builtins.int = ...,
        last_local_stream_created_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        last_remote_stream_created_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        last_message_sent_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        last_message_received_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        local_flow_control_window: typing.Optional[google.protobuf.wrappers_pb2.Int64Value] = ...,
        remote_flow_control_window: typing.Optional[google.protobuf.wrappers_pb2.Int64Value] = ...,
        option: typing.Optional[typing.Iterable[global___SocketOption]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["last_local_stream_created_timestamp",b"last_local_stream_created_timestamp","last_message_received_timestamp",b"last_message_received_timestamp","last_message_sent_timestamp",b"last_message_sent_timestamp","last_remote_stream_created_timestamp",b"last_remote_stream_created_timestamp","local_flow_control_window",b"local_flow_control_window","remote_flow_control_window",b"remote_flow_control_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["keep_alives_sent",b"keep_alives_sent","last_local_stream_created_timestamp",b"last_local_stream_created_timestamp","last_message_received_timestamp",b"last_message_received_timestamp","last_message_sent_timestamp",b"last_message_sent_timestamp","last_remote_stream_created_timestamp",b"last_remote_stream_created_timestamp","local_flow_control_window",b"local_flow_control_window","messages_received",b"messages_received","messages_sent",b"messages_sent","option",b"option","remote_flow_control_window",b"remote_flow_control_window","streams_failed",b"streams_failed","streams_started",b"streams_started","streams_succeeded",b"streams_succeeded"]) -> None: ...
global___SocketData = SocketData

class Address(google.protobuf.message.Message):
    """Address represents the address used to create the socket."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class TcpIpAddress(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        IP_ADDRESS_FIELD_NUMBER: builtins.int
        PORT_FIELD_NUMBER: builtins.int
        ip_address: builtins.bytes
        """Either the IPv4 or IPv6 address in bytes.  Will be either 4 bytes or 16
        bytes in length.
        """

        port: builtins.int
        """0-64k, or -1 if not appropriate."""

        def __init__(self,
            *,
            ip_address: builtins.bytes = ...,
            port: builtins.int = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["ip_address",b"ip_address","port",b"port"]) -> None: ...

    class UdsAddress(google.protobuf.message.Message):
        """A Unix Domain Socket address."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        FILENAME_FIELD_NUMBER: builtins.int
        filename: typing.Text
        def __init__(self,
            *,
            filename: typing.Text = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["filename",b"filename"]) -> None: ...

    class OtherAddress(google.protobuf.message.Message):
        """An address type not included above."""
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: typing.Text
        """The human readable version of the value.  This value should be set."""

        @property
        def value(self) -> google.protobuf.any_pb2.Any:
            """The actual address message."""
            pass
        def __init__(self,
            *,
            name: typing.Text = ...,
            value: typing.Optional[google.protobuf.any_pb2.Any] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name",b"name","value",b"value"]) -> None: ...

    TCPIP_ADDRESS_FIELD_NUMBER: builtins.int
    UDS_ADDRESS_FIELD_NUMBER: builtins.int
    OTHER_ADDRESS_FIELD_NUMBER: builtins.int
    @property
    def tcpip_address(self) -> global___Address.TcpIpAddress: ...
    @property
    def uds_address(self) -> global___Address.UdsAddress: ...
    @property
    def other_address(self) -> global___Address.OtherAddress: ...
    def __init__(self,
        *,
        tcpip_address: typing.Optional[global___Address.TcpIpAddress] = ...,
        uds_address: typing.Optional[global___Address.UdsAddress] = ...,
        other_address: typing.Optional[global___Address.OtherAddress] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["address",b"address","other_address",b"other_address","tcpip_address",b"tcpip_address","uds_address",b"uds_address"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["address",b"address","other_address",b"other_address","tcpip_address",b"tcpip_address","uds_address",b"uds_address"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["address",b"address"]) -> typing.Optional[typing_extensions.Literal["tcpip_address","uds_address","other_address"]]: ...
global___Address = Address

class Security(google.protobuf.message.Message):
    """Security represents details about how secure the socket is."""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class Tls(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        STANDARD_NAME_FIELD_NUMBER: builtins.int
        OTHER_NAME_FIELD_NUMBER: builtins.int
        LOCAL_CERTIFICATE_FIELD_NUMBER: builtins.int
        REMOTE_CERTIFICATE_FIELD_NUMBER: builtins.int
        standard_name: typing.Text
        """The cipher suite name in the RFC 4346 format:
        https://tools.ietf.org/html/rfc4346#appendix-C
        """

        other_name: typing.Text
        """Some other way to describe the cipher suite if
        the RFC 4346 name is not available.
        """

        local_certificate: builtins.bytes
        """the certificate used by this endpoint."""

        remote_certificate: builtins.bytes
        """the certificate used by the remote endpoint."""

        def __init__(self,
            *,
            standard_name: typing.Text = ...,
            other_name: typing.Text = ...,
            local_certificate: builtins.bytes = ...,
            remote_certificate: builtins.bytes = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["cipher_suite",b"cipher_suite","other_name",b"other_name","standard_name",b"standard_name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["cipher_suite",b"cipher_suite","local_certificate",b"local_certificate","other_name",b"other_name","remote_certificate",b"remote_certificate","standard_name",b"standard_name"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["cipher_suite",b"cipher_suite"]) -> typing.Optional[typing_extensions.Literal["standard_name","other_name"]]: ...

    class OtherSecurity(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor
        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: typing.Text
        """The human readable version of the value."""

        @property
        def value(self) -> google.protobuf.any_pb2.Any:
            """The actual security details message."""
            pass
        def __init__(self,
            *,
            name: typing.Text = ...,
            value: typing.Optional[google.protobuf.any_pb2.Any] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name",b"name","value",b"value"]) -> None: ...

    TLS_FIELD_NUMBER: builtins.int
    OTHER_FIELD_NUMBER: builtins.int
    @property
    def tls(self) -> global___Security.Tls: ...
    @property
    def other(self) -> global___Security.OtherSecurity: ...
    def __init__(self,
        *,
        tls: typing.Optional[global___Security.Tls] = ...,
        other: typing.Optional[global___Security.OtherSecurity] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model",b"model","other",b"other","tls",b"tls"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model",b"model","other",b"other","tls",b"tls"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["model",b"model"]) -> typing.Optional[typing_extensions.Literal["tls","other"]]: ...
global___Security = Security

class SocketOption(google.protobuf.message.Message):
    """SocketOption represents socket options for a socket.  Specifically, these
    are the options returned by getsockopt().
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    ADDITIONAL_FIELD_NUMBER: builtins.int
    name: typing.Text
    """The full name of the socket option.  Typically this will be the upper case
    name, such as "SO_REUSEPORT".
    """

    value: typing.Text
    """The human readable value of this socket option.  At least one of value or
    additional will be set.
    """

    @property
    def additional(self) -> google.protobuf.any_pb2.Any:
        """Additional data associated with the socket option.  At least one of value
        or additional will be set.
        """
        pass
    def __init__(self,
        *,
        name: typing.Text = ...,
        value: typing.Text = ...,
        additional: typing.Optional[google.protobuf.any_pb2.Any] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["additional",b"additional"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["additional",b"additional","name",b"name","value",b"value"]) -> None: ...
global___SocketOption = SocketOption

class SocketOptionTimeout(google.protobuf.message.Message):
    """For use with SocketOption's additional field.  This is primarily used for
    SO_RCVTIMEO and SO_SNDTIMEO
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    DURATION_FIELD_NUMBER: builtins.int
    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration: ...
    def __init__(self,
        *,
        duration: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["duration",b"duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["duration",b"duration"]) -> None: ...
global___SocketOptionTimeout = SocketOptionTimeout

class SocketOptionLinger(google.protobuf.message.Message):
    """For use with SocketOption's additional field.  This is primarily used for
    SO_LINGER.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ACTIVE_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    active: builtins.bool
    """active maps to `struct linger.l_onoff`"""

    @property
    def duration(self) -> google.protobuf.duration_pb2.Duration:
        """duration maps to `struct linger.l_linger`"""
        pass
    def __init__(self,
        *,
        active: builtins.bool = ...,
        duration: typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["duration",b"duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["active",b"active","duration",b"duration"]) -> None: ...
global___SocketOptionLinger = SocketOptionLinger

class SocketOptionTcpInfo(google.protobuf.message.Message):
    """For use with SocketOption's additional field.  Tcp info for
    SOL_TCP and TCP_INFO.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TCPI_STATE_FIELD_NUMBER: builtins.int
    TCPI_CA_STATE_FIELD_NUMBER: builtins.int
    TCPI_RETRANSMITS_FIELD_NUMBER: builtins.int
    TCPI_PROBES_FIELD_NUMBER: builtins.int
    TCPI_BACKOFF_FIELD_NUMBER: builtins.int
    TCPI_OPTIONS_FIELD_NUMBER: builtins.int
    TCPI_SND_WSCALE_FIELD_NUMBER: builtins.int
    TCPI_RCV_WSCALE_FIELD_NUMBER: builtins.int
    TCPI_RTO_FIELD_NUMBER: builtins.int
    TCPI_ATO_FIELD_NUMBER: builtins.int
    TCPI_SND_MSS_FIELD_NUMBER: builtins.int
    TCPI_RCV_MSS_FIELD_NUMBER: builtins.int
    TCPI_UNACKED_FIELD_NUMBER: builtins.int
    TCPI_SACKED_FIELD_NUMBER: builtins.int
    TCPI_LOST_FIELD_NUMBER: builtins.int
    TCPI_RETRANS_FIELD_NUMBER: builtins.int
    TCPI_FACKETS_FIELD_NUMBER: builtins.int
    TCPI_LAST_DATA_SENT_FIELD_NUMBER: builtins.int
    TCPI_LAST_ACK_SENT_FIELD_NUMBER: builtins.int
    TCPI_LAST_DATA_RECV_FIELD_NUMBER: builtins.int
    TCPI_LAST_ACK_RECV_FIELD_NUMBER: builtins.int
    TCPI_PMTU_FIELD_NUMBER: builtins.int
    TCPI_RCV_SSTHRESH_FIELD_NUMBER: builtins.int
    TCPI_RTT_FIELD_NUMBER: builtins.int
    TCPI_RTTVAR_FIELD_NUMBER: builtins.int
    TCPI_SND_SSTHRESH_FIELD_NUMBER: builtins.int
    TCPI_SND_CWND_FIELD_NUMBER: builtins.int
    TCPI_ADVMSS_FIELD_NUMBER: builtins.int
    TCPI_REORDERING_FIELD_NUMBER: builtins.int
    tcpi_state: builtins.int
    tcpi_ca_state: builtins.int
    tcpi_retransmits: builtins.int
    tcpi_probes: builtins.int
    tcpi_backoff: builtins.int
    tcpi_options: builtins.int
    tcpi_snd_wscale: builtins.int
    tcpi_rcv_wscale: builtins.int
    tcpi_rto: builtins.int
    tcpi_ato: builtins.int
    tcpi_snd_mss: builtins.int
    tcpi_rcv_mss: builtins.int
    tcpi_unacked: builtins.int
    tcpi_sacked: builtins.int
    tcpi_lost: builtins.int
    tcpi_retrans: builtins.int
    tcpi_fackets: builtins.int
    tcpi_last_data_sent: builtins.int
    tcpi_last_ack_sent: builtins.int
    tcpi_last_data_recv: builtins.int
    tcpi_last_ack_recv: builtins.int
    tcpi_pmtu: builtins.int
    tcpi_rcv_ssthresh: builtins.int
    tcpi_rtt: builtins.int
    tcpi_rttvar: builtins.int
    tcpi_snd_ssthresh: builtins.int
    tcpi_snd_cwnd: builtins.int
    tcpi_advmss: builtins.int
    tcpi_reordering: builtins.int
    def __init__(self,
        *,
        tcpi_state: builtins.int = ...,
        tcpi_ca_state: builtins.int = ...,
        tcpi_retransmits: builtins.int = ...,
        tcpi_probes: builtins.int = ...,
        tcpi_backoff: builtins.int = ...,
        tcpi_options: builtins.int = ...,
        tcpi_snd_wscale: builtins.int = ...,
        tcpi_rcv_wscale: builtins.int = ...,
        tcpi_rto: builtins.int = ...,
        tcpi_ato: builtins.int = ...,
        tcpi_snd_mss: builtins.int = ...,
        tcpi_rcv_mss: builtins.int = ...,
        tcpi_unacked: builtins.int = ...,
        tcpi_sacked: builtins.int = ...,
        tcpi_lost: builtins.int = ...,
        tcpi_retrans: builtins.int = ...,
        tcpi_fackets: builtins.int = ...,
        tcpi_last_data_sent: builtins.int = ...,
        tcpi_last_ack_sent: builtins.int = ...,
        tcpi_last_data_recv: builtins.int = ...,
        tcpi_last_ack_recv: builtins.int = ...,
        tcpi_pmtu: builtins.int = ...,
        tcpi_rcv_ssthresh: builtins.int = ...,
        tcpi_rtt: builtins.int = ...,
        tcpi_rttvar: builtins.int = ...,
        tcpi_snd_ssthresh: builtins.int = ...,
        tcpi_snd_cwnd: builtins.int = ...,
        tcpi_advmss: builtins.int = ...,
        tcpi_reordering: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tcpi_advmss",b"tcpi_advmss","tcpi_ato",b"tcpi_ato","tcpi_backoff",b"tcpi_backoff","tcpi_ca_state",b"tcpi_ca_state","tcpi_fackets",b"tcpi_fackets","tcpi_last_ack_recv",b"tcpi_last_ack_recv","tcpi_last_ack_sent",b"tcpi_last_ack_sent","tcpi_last_data_recv",b"tcpi_last_data_recv","tcpi_last_data_sent",b"tcpi_last_data_sent","tcpi_lost",b"tcpi_lost","tcpi_options",b"tcpi_options","tcpi_pmtu",b"tcpi_pmtu","tcpi_probes",b"tcpi_probes","tcpi_rcv_mss",b"tcpi_rcv_mss","tcpi_rcv_ssthresh",b"tcpi_rcv_ssthresh","tcpi_rcv_wscale",b"tcpi_rcv_wscale","tcpi_reordering",b"tcpi_reordering","tcpi_retrans",b"tcpi_retrans","tcpi_retransmits",b"tcpi_retransmits","tcpi_rto",b"tcpi_rto","tcpi_rtt",b"tcpi_rtt","tcpi_rttvar",b"tcpi_rttvar","tcpi_sacked",b"tcpi_sacked","tcpi_snd_cwnd",b"tcpi_snd_cwnd","tcpi_snd_mss",b"tcpi_snd_mss","tcpi_snd_ssthresh",b"tcpi_snd_ssthresh","tcpi_snd_wscale",b"tcpi_snd_wscale","tcpi_state",b"tcpi_state","tcpi_unacked",b"tcpi_unacked"]) -> None: ...
global___SocketOptionTcpInfo = SocketOptionTcpInfo

class GetTopChannelsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_CHANNEL_ID_FIELD_NUMBER: builtins.int
    MAX_RESULTS_FIELD_NUMBER: builtins.int
    start_channel_id: builtins.int
    """start_channel_id indicates that only channels at or above this id should be
    included in the results.
    To request the first page, this should be set to 0. To request
    subsequent pages, the client generates this value by adding 1 to
    the highest seen result ID.
    """

    max_results: builtins.int
    """If non-zero, the server will return a page of results containing
    at most this many items. If zero, the server will choose a
    reasonable page size.  Must never be negative.
    """

    def __init__(self,
        *,
        start_channel_id: builtins.int = ...,
        max_results: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_results",b"max_results","start_channel_id",b"start_channel_id"]) -> None: ...
global___GetTopChannelsRequest = GetTopChannelsRequest

class GetTopChannelsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CHANNEL_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    @property
    def channel(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Channel]:
        """list of channels that the connection detail service knows about.  Sorted in
        ascending channel_id order.
        Must contain at least 1 result, otherwise 'end' must be true.
        """
        pass
    end: builtins.bool
    """If set, indicates that the list of channels is the final list.  Requesting
    more channels can only return more if they are created after this RPC
    completes.
    """

    def __init__(self,
        *,
        channel: typing.Optional[typing.Iterable[global___Channel]] = ...,
        end: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel",b"channel","end",b"end"]) -> None: ...
global___GetTopChannelsResponse = GetTopChannelsResponse

class GetServersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_SERVER_ID_FIELD_NUMBER: builtins.int
    MAX_RESULTS_FIELD_NUMBER: builtins.int
    start_server_id: builtins.int
    """start_server_id indicates that only servers at or above this id should be
    included in the results.
    To request the first page, this must be set to 0. To request
    subsequent pages, the client generates this value by adding 1 to
    the highest seen result ID.
    """

    max_results: builtins.int
    """If non-zero, the server will return a page of results containing
    at most this many items. If zero, the server will choose a
    reasonable page size.  Must never be negative.
    """

    def __init__(self,
        *,
        start_server_id: builtins.int = ...,
        max_results: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_results",b"max_results","start_server_id",b"start_server_id"]) -> None: ...
global___GetServersRequest = GetServersRequest

class GetServersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVER_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    @property
    def server(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Server]:
        """list of servers that the connection detail service knows about.  Sorted in
        ascending server_id order.
        Must contain at least 1 result, otherwise 'end' must be true.
        """
        pass
    end: builtins.bool
    """If set, indicates that the list of servers is the final list.  Requesting
    more servers will only return more if they are created after this RPC
    completes.
    """

    def __init__(self,
        *,
        server: typing.Optional[typing.Iterable[global___Server]] = ...,
        end: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["end",b"end","server",b"server"]) -> None: ...
global___GetServersResponse = GetServersResponse

class GetServerRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVER_ID_FIELD_NUMBER: builtins.int
    server_id: builtins.int
    """server_id is the identifier of the specific server to get."""

    def __init__(self,
        *,
        server_id: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["server_id",b"server_id"]) -> None: ...
global___GetServerRequest = GetServerRequest

class GetServerResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVER_FIELD_NUMBER: builtins.int
    @property
    def server(self) -> global___Server:
        """The Server that corresponds to the requested server_id.  This field
        should be set.
        """
        pass
    def __init__(self,
        *,
        server: typing.Optional[global___Server] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["server",b"server"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["server",b"server"]) -> None: ...
global___GetServerResponse = GetServerResponse

class GetServerSocketsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SERVER_ID_FIELD_NUMBER: builtins.int
    START_SOCKET_ID_FIELD_NUMBER: builtins.int
    MAX_RESULTS_FIELD_NUMBER: builtins.int
    server_id: builtins.int
    start_socket_id: builtins.int
    """start_socket_id indicates that only sockets at or above this id should be
    included in the results.
    To request the first page, this must be set to 0. To request
    subsequent pages, the client generates this value by adding 1 to
    the highest seen result ID.
    """

    max_results: builtins.int
    """If non-zero, the server will return a page of results containing
    at most this many items. If zero, the server will choose a
    reasonable page size.  Must never be negative.
    """

    def __init__(self,
        *,
        server_id: builtins.int = ...,
        start_socket_id: builtins.int = ...,
        max_results: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_results",b"max_results","server_id",b"server_id","start_socket_id",b"start_socket_id"]) -> None: ...
global___GetServerSocketsRequest = GetServerSocketsRequest

class GetServerSocketsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOCKET_REF_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    @property
    def socket_ref(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SocketRef]:
        """list of socket refs that the connection detail service knows about.  Sorted in
        ascending socket_id order.
        Must contain at least 1 result, otherwise 'end' must be true.
        """
        pass
    end: builtins.bool
    """If set, indicates that the list of sockets is the final list.  Requesting
    more sockets will only return more if they are created after this RPC
    completes.
    """

    def __init__(self,
        *,
        socket_ref: typing.Optional[typing.Iterable[global___SocketRef]] = ...,
        end: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["end",b"end","socket_ref",b"socket_ref"]) -> None: ...
global___GetServerSocketsResponse = GetServerSocketsResponse

class GetChannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    channel_id: builtins.int
    """channel_id is the identifier of the specific channel to get."""

    def __init__(self,
        *,
        channel_id: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_id",b"channel_id"]) -> None: ...
global___GetChannelRequest = GetChannelRequest

class GetChannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CHANNEL_FIELD_NUMBER: builtins.int
    @property
    def channel(self) -> global___Channel:
        """The Channel that corresponds to the requested channel_id.  This field
        should be set.
        """
        pass
    def __init__(self,
        *,
        channel: typing.Optional[global___Channel] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["channel",b"channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel",b"channel"]) -> None: ...
global___GetChannelResponse = GetChannelResponse

class GetSubchannelRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SUBCHANNEL_ID_FIELD_NUMBER: builtins.int
    subchannel_id: builtins.int
    """subchannel_id is the identifier of the specific subchannel to get."""

    def __init__(self,
        *,
        subchannel_id: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["subchannel_id",b"subchannel_id"]) -> None: ...
global___GetSubchannelRequest = GetSubchannelRequest

class GetSubchannelResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SUBCHANNEL_FIELD_NUMBER: builtins.int
    @property
    def subchannel(self) -> global___Subchannel:
        """The Subchannel that corresponds to the requested subchannel_id.  This
        field should be set.
        """
        pass
    def __init__(self,
        *,
        subchannel: typing.Optional[global___Subchannel] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["subchannel",b"subchannel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["subchannel",b"subchannel"]) -> None: ...
global___GetSubchannelResponse = GetSubchannelResponse

class GetSocketRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOCKET_ID_FIELD_NUMBER: builtins.int
    SUMMARY_FIELD_NUMBER: builtins.int
    socket_id: builtins.int
    """socket_id is the identifier of the specific socket to get."""

    summary: builtins.bool
    """If true, the response will contain only high level information
    that is inexpensive to obtain. Fields thay may be omitted are
    documented.
    """

    def __init__(self,
        *,
        socket_id: builtins.int = ...,
        summary: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["socket_id",b"socket_id","summary",b"summary"]) -> None: ...
global___GetSocketRequest = GetSocketRequest

class GetSocketResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SOCKET_FIELD_NUMBER: builtins.int
    @property
    def socket(self) -> global___Socket:
        """The Socket that corresponds to the requested socket_id.  This field
        should be set.
        """
        pass
    def __init__(self,
        *,
        socket: typing.Optional[global___Socket] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["socket",b"socket"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["socket",b"socket"]) -> None: ...
global___GetSocketResponse = GetSocketResponse
