# AUTOGENERATED! DO NOT EDIT! File to edit: ../03_annotation.ipynb.

# %% auto 0
__all__ = ['Annotation', 'Keypoint', 'BoundingBox']

# %% ../03_annotation.ipynb 4
from abc import ABC, abstractmethod, abstractproperty

class Annotation(ABC):
    "Abstract class that represents a Box21 Annotation"
    def __init__(self, 
                 asset_id: int, # related asset id in Box21
                 id: int, # unique id in Box21
                 certainty: float, # certainty of annotation
                 label_id: int, # related label id in Box21
                 label_name: str, # label name
                 project_id: int, # related project id in Box21
                 validated: bool # whether the annotation is validated
                ): 
        self.asset_id = asset_id
        self.id = id
        self.certainty = certainty
        self.label_id = label_id
        self.label_name = label_name
        self.project_id = project_id
        self.validated = validated

# %% ../03_annotation.ipynb 7
class Keypoint(Annotation):
    "Represents a Box21 Keypoint Annotation"
    def __init__(self,
                 asset_id: int, 
                 id: int,
                 certainty: float,
                 label_id: int,
                 label_name: str,
                 project_id: int,
                 validated: bool,
                 x: float,
                 y: float
                ):
        super().__init__(asset_id, id, certainty, label_id, label_name, project_id, validated)
        self.x = x
        self.y = y
        
    def __repr__(self):
        return f"Keypoint({self.label_name}, {self.x, self.y})"
        

# %% ../03_annotation.ipynb 9
class BoundingBox(Annotation):
    "Represents a Box21 BoundingBox Annotation"
    def __init__(self,
                 asset_id: int, 
                 id: int,
                 certainty: float,
                 label_id: int,
                 label_name: str,
                 project_id: int,
                 validated: bool,
                 x: float,
                 y: float,
                 width: float,
                 height: float
                ):
        super().__init__(asset_id, id, certainty, label_id, label_name, project_id, validated)
        self.x = x
        self.y = y
        self.height = height
        self.width = width
        
    def __repr__(self):
        return f"BoundingBox({self.label_name}, {self.x, self.y, self.width, self.height})"
