box21_api
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

A python package for interacting with your Box21 via the api

## Install

``` sh
pip install box21_api
```

## How to use

``` python
from box21_api.box21_api import Box21Api
```

``` python
box21_api = Box21Api(API_USERNAME, API_PASSWORD, 'https://box21.ai', 443, API_PROJECT_ID)
```

``` python
labels = box21_api.get_labels()
print('Number of labels retrieved', len(labels))
print('First label', labels[0])
```

    Number of labels retrieved 2
    First label Label(('Bounding box', 'Chital', 1))

``` python
annotations = box21_api.get_label_annotations(labels[0])
print('Number of annotations retrieved', len(annotations))
print('First annotation', annotations[0])
```

    Number of annotations retrieved 2
    First annotation BoundingBox(Chital, (0.1641, 0.5291, 0.2766, 0.3381))

``` python
first_annotation = annotations[0]
pil_image = box21_api.download_asset(first_annotation.asset_id)
pil_image
```

![](index_files/figure-gfm/cell-6-output-1.png)

See more examples on: https://ramonhollands.github.io/box21_api/
