/*
 *  Trip.js - A jQuery plugin that can help you customize your tutorial trip easily
 *  Version: 1.3.0
 *
 *  Author: EragonJ <eragonj@eragonj.me>
 *  Blog: http://eragonj.me
 */(function(e,t){function i(t,n){var r,i,s=n;this.pause=function(){e.clearTimeout(r),s-=new Date-i},this.resume=function(){return i=new Date,r=e.setTimeout(t,s),s},this.stop=function(){e.clearTimeout(r)},this.resume()}var n=["flash","bounce","shake","tada","fadeIn","fadeInUp","fadeInDown","fadeInLeft","fadeInRight","fadeInUpBig","fadeInDownBig","fadeInLeftBig","fadeInRightBig","bounceIn","bounceInDown","bounceInUp","bounceInLeft","bounceInRight","rotateIn","rotateInDownLeft","rotateInDownRight","rotateInUpLeft","rotateInUpRight"],r=function(n,r){this.settings=t.extend({tripIndex:0,tripTheme:"black",backToTopWhenEnded:!1,overlayZindex:99999,delay:1e3,enableKeyBinding:!0,enableAnimation:!0,showCloseBox:!1,skipUndefinedTrip:!1,showNavigation:!1,canGoNext:!0,canGoPrev:!0,nextLabel:"Next",prevLabel:"Back",finishLabel:"Dismiss",closeBoxLabel:"&#215;",onTripStart:t.noop,onTripEnd:t.noop,onTripStop:t.noop,onTripChange:t.noop,onTripClose:t.noop,animation:"tada",tripBlockHTML:['<div class="trip-block">','<a href="#" class="trip-close"></a>','<div class="trip-content"></div>','<div class="trip-progress-wrapper">','<div class="trip-progress-bar"></div>','<a href="#" class="trip-prev"></a>','<a href="#" class="trip-next"></a>',"</div>","</div>"]},r),this.tripData=n,this.$tripBlock=null,this.$overlay=null,this.$bar=null,this.$root=t("body, html"),this.tripIndex=this.settings.tripIndex,this.tripDirection="next",this.timer=null,this.progressing=!1,this.hasExpose=!1,this.CONSTANTS={LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,ESC:27,SPACE:32,TRIP_BLOCK_OFFSET_VERTICAL:10,TRIP_BLOCK_OFFSET_HORIZONTAL:10},this.console=e.console||{}};r.prototype={preInit:function(){if(typeof this.console=="undefined"){var e=this,n=["log","warn","debug","info","error"];t.each(n,function(n,r){e.console[r]=t.noop})}},showExpose:function(e){this.hasExpose=!0;var t,n;t={position:e.css("position"),zIndex:e.css("z-Index")},n={position:"relative",zIndex:this.settings.overlayZindex+1},e.data("trip-old-css",t).css(n).addClass("trip-exposed"),this.$overlay.show()},hideExpose:function(){this.hasExpose=!1;var e=t(".trip-exposed"),n=e.data("trip-old-css");e.css(n).removeClass("trip-exposed"),this.$overlay.hide()},bindResizeEvents:function(){var n=this;t(e).on("resize.Trip",function(){n.run()})},unbindResizeEvents:function(){t(e).off("resize.Trip")},bindKeyEvents:function(){var e=this;t(document).on({"keydown.Trip":function(t){e.keyEvent.call(e,t)}})},unbindKeyEvents:function(){t(document).off("keydown.Trip")},keyEvent:function(e){switch(e.which){case this.CONSTANTS.ESC:this.stop();break;case this.CONSTANTS.SPACE:e.preventDefault(),this.pause();break;case this.CONSTANTS.LEFT_ARROW:case this.CONSTANTS.UP_ARROW:this.prev();break;case this.CONSTANTS.RIGHT_ARROW:case this.CONSTANTS.DOWN_ARROW:this.next()}},stop:function(){this.timer&&this.timer.stop(),this.hasExpose&&this.hideExpose(),this.tripIndex=this.settings.tripIndex,this.hideTripBlock(),this.unbindKeyEvents(),this.unbindResizeEvents(),this.settings.onTripStop()},pauseAndResume:function(){if(this.progressing)this.timer.pause(),this.pauseProgressBar();else{var e=this.timer.resume();this.resumeProgressBar(e)}this.progressing=!this.progressing},pause:function(){this.pauseAndResume()},resume:function(){this.pauseAndResume()},next:function(){this.tripDirection="next";if(!this.canGoNext())return this.run();this.hasCallback()&&this.callCallback(),this.isLast()?this.doLastOperation():(this.increaseIndex(),this.run())},prev:function(){this.tripDirection="prev",!this.isFirst()&&this.canGoPrev()&&this.decreaseIndex(),this.run()},showCurrentTrip:function(e){typeof e.sel=="string"&&(e.sel=t(e.sel)),this.settings.enableAnimation&&this.removeAnimation(),this.timer&&this.timer.stop(),this.hasExpose&&this.hideExpose(),this.progressing&&(this.hideProgressBar(),this.progressing=!1),this.setTripBlock(e),this.showTripBlock(e),this.settings.enableAnimation&&this.addAnimation(e),e.expose&&this.showExpose(e.sel)},doLastOperation:function(){return this.timer&&this.timer.stop(),this.settings.enableKeyBinding&&this.unbindKeyEvents(),this.hideTripBlock(),this.unbindResizeEvents(),this.hasExpose&&this.hideExpose(),this.settings.backToTopWhenEnded&&this.$root.animate({scrollTop:0},"slow"),this.tripIndex=this.settings.tripIndex,this.settings.onTripEnd(),!1},showProgressBar:function(e){var t=this;this.$bar.animate({width:"100%"},e,"linear",function(){t.$bar.width(0)})},hideProgressBar:function(){this.$bar.width(0),this.$bar.stop(!0)},pauseProgressBar:function(){this.$bar.stop(!0)},resumeProgressBar:function(e){this.showProgressBar(e)},run:function(){var e=this,t=this.getCurrentTripObject(),n=t.delay||this.settings.delay;if(!this.isTripDataValid(t))return this.settings.skipUndefinedTrip===!1?(this.console.error("Your tripData is not valid at index: "+this.tripIndex),this.stop(),!1):this[this.tripDirection]();this.showCurrentTrip(t),this.showProgressBar(n),this.progressing=!0,n>=0&&(this.timer=new i(e.next.bind(e),n)),this.settings.onTripChange(this.tripIndex,t)},isFirst:function(){return this.tripIndex===0?!0:!1},isLast:function(){return this.tripIndex===this.tripData.length-1?!0:!1},isTripDataValid:function(e){var n=["screen-ne","screen-se","screen-sw","screen-nw","screen-center"];return t.inArray(e.position,n)>=0?!0:typeof e.content=="undefined"||typeof e.sel=="undefined"||e.sel===null||e.sel.length===0||t(e.sel).length===0?!1:!0},hasCallback:function(){return typeof this.tripData[this.tripIndex].callback!="undefined"},callCallback:function(){this.tripData[this.tripIndex].callback(this.tripIndex)},canGoPrev:function(){var e=this.tripData[this.tripIndex],t=e.canGoPrev||this.settings.canGoPrev;return typeof t=="function"&&(t=t.call(e)),t},canGoNext:function(){var e=this.tripData[this.tripIndex],t=e.canGoNext||this.settings.canGoNext;return typeof t=="function"&&(t=t.call(e)),t},increaseIndex:function(){this.tripIndex>=this.tripData.length-1||(this.tripIndex+=1)},decreaseIndex:function(){this.tripIndex<=0||(this.tripIndex-=1)},getCurrentTripObject:function(){return this.tripData[this.tripIndex]},setTripBlock:function(e){var t=this.$tripBlock,n=e.showCloseBox||this.settings.showCloseBox,r=e.showNavigation||this.settings.showNavigation,i=e.closeBoxLabel||this.settings.closeBoxLabel,s=e.prevLabel||this.settings.prevLabel,o=e.nextLabel||this.settings.nextLabel,u=e.finishLabel||this.settings.finishLabel;t.find(".trip-content").html(e.content),t.find(".trip-prev").html(s).toggle(r&&!this.isFirst()),t.find(".trip-next").html(this.isLast()?u:o).toggle(r),t.find(".trip-close").html(i).toggle(n),t.removeClass("e s w n screen-ne screen-se screen-sw screen-nw screen-center"),t.addClass(e.position),this.setTripBlockPosition(e,"horizontal"),this.setTripBlockPosition(e,"vertical")},setTripBlockPosition:function(e,t){var n=this.$tripBlock,r=e.sel,i=r&&r.outerWidth(),s=r&&r.outerHeight(),o=n.outerWidth(),u=n.outerHeight(),a=10,f=10,l,c;switch(e.position){case"screen-center":l="50%",c="50%";break;case"screen-ne":case"screen-se":case"screen-nw":case"screen-sw":l=this.CONSTANTS.TRIP_BLOCK_OFFSET_HORIZONTAL,c=this.CONSTANTS.TRIP_BLOCK_OFFSET_VERTICAL;break;case"e":l=r.offset().left+i+f,c=r.offset().top-(u-s)/2;break;case"s":l=r.offset().left+(i-o)/2,c=r.offset().top+s+a;break;case"w":l=r.offset().left-(f+o),c=r.offset().top-(u-s)/2;break;case"n":default:l=r.offset().left+(i-o)/2,c=r.offset().top-a-u}if(t==="horizontal"){n.css({left:"",right:"",marginLeft:""});switch(e.position){case"screen-center":n.css({left:l,marginLeft:-0.5*o});break;case"screen-se":case"screen-ne":n.css({right:l});break;case"screen-sw":case"screen-nw":case"e":case"s":case"w":case"n":default:n.css({left:l})}}else if(t==="vertical"){n.css({top:"",bottom:"",marginTop:""});switch(e.position){case"screen-center":n.css({top:c,marginTop:-0.5*u});break;case"screen-sw":case"screen-se":n.css({bottom:c});break;case"screen-nw":case"screen-ne":case"e":case"s":case"w":case"n":default:n.css({top:c})}}},addAnimation:function(e){var r=e.animation||this.settings.animation;t.inArray(r,n)>=0&&(this.$tripBlock.addClass("animated"),this.$tripBlock.addClass(r))},removeAnimation:function(){this.$tripBlock.removeClass(n.join(" ")),this.$tripBlock.removeClass("animated")},showTripBlock:function(n){this.$tripBlock.css({display:"inline-block",zIndex:this.settings.overlayZindex+1});var r=t(e).height(),i=t(e).scrollTop(),s=this.$tripBlock.offset().top,o=100;s<i+r&&s>=i||this.$root.animate({scrollTop:s-o},"slow")},hideTripBlock:function(){this.$tripBlock.fadeOut("slow")},create:function(){this.createTripBlock(),this.createOverlay()},createTripBlock:function(){if(typeof t(".trip-block").get(0)=="undefined"){var e=this,n=this.settings.tripBlockHTML.join(""),r=t(n).addClass(this.settings.tripTheme);t("body").append(r),r.find(".trip-close").on("click",function(t){t.preventDefault(),e.settings.onTripClose(e.tripIndex),e.stop()}),r.find(".trip-prev").on("click",function(t){t.preventDefault(),e.prev()}),r.find(".trip-next").on("click",function(t){t.preventDefault(),e.next()})}},createOverlay:function(){if(typeof t(".trip-overlay").get(0)=="undefined"){var n=['<div class="trip-overlay">',"</div>"].join(""),r=t(n);r.height(t(e).height()).css({zIndex:this.settings.overlayZindex}),t("body").append(r)}},cleanup:function(){t(".trip-overlay, .trip-block").remove()},init:function(){this.preInit(),this.settings.enableKeyBinding&&this.bindKeyEvents(),this.bindResizeEvents(),this.$tripBlock=t(".trip-block"),this.$bar=t(".trip-progress-bar"),this.$overlay=t(".trip-overlay")},start:function(){this.cleanup(),this.settings.onTripStart(),this.create(),this.init(),this.run()}},e.Trip=r})(window,jQuery);