/*!
 * Copyright (c) 2012 - 2022, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"4e90918c0a": function _(e,s,t,o,i){o();const n=(0,e("tslib").__importStar)(e("eed113197d"));t.Panel=n;(0,e("@bokehjs/base").register_models)(n)},
"eed113197d": function _(e,a,t,o,c){o();const d=e("tslib");c("AcePlot",e("2e12ebdb23").AcePlot),c("Audio",e("33955cfa6f").Audio),c("Card",e("0972f6e77b").Card),c("CommManager",e("754fbb1f55").CommManager),c("CustomSelect",e("e258e515be").CustomSelect),c("DataTabulator",e("6ab332f75c").DataTabulator),c("DatetimePicker",e("297274885a").DatetimePicker),c("DeckGLPlot",e("0155f7af4d").DeckGLPlot),c("ECharts",e("9d046c4720").ECharts),c("HTML",e("3d7593ca5a").HTML),c("IDOM",e("7d45bd3bc4").IDOM),c("IPyWidget",e("0eae77d68f").IPyWidget),c("JSON",e("0d30bea0c8").JSON),c("JSONEditor",e("be9f51fc39").JSONEditor),c("FileDownload",e("1767172ffa").FileDownload),c("KaTeX",e("7b859fb3cf").KaTeX),c("Location",e("0c52a301f3").Location),c("MathJax",e("0c21036737").MathJax),c("Perspective",e("4ae96bd77b").Perspective),c("Player",e("588a5ae70d").Player),c("PlotlyPlot",e("42de27e56c").PlotlyPlot),c("Progress",e("979633320f").Progress),c("QuillInput",e("d51a79a0a3").QuillInput),c("ReactiveHTML",e("ad426de39c").ReactiveHTML),c("SingleSelect",e("ab54efe08a").SingleSelect),c("SpeechToText",e("a96be0bcc9").SpeechToText),c("State",e("bfa46a5f19").State),c("Tabs",e("f693d9aa84").Tabs),c("Terminal",e("3ea011fa55").Terminal),c("TextToSpeech",e("33cd2c254e").TextToSpeech),c("TrendIndicator",e("effe070807").TrendIndicator),c("VegaPlot",e("fea356270f").VegaPlot),c("Video",e("1b46fd56a8").Video),c("VideoStream",e("e3e9b8e495").VideoStream),(0,d.__exportStar)(e("c51f25e2a7"),t)},
"2e12ebdb23": function _(e,t,i,o,n){o();const s=e("@bokehjs/models/layouts/html_box"),a=e("@bokehjs/core/dom"),d=e("80a6464b1f");class h extends d.PanelHTMLBoxView{initialize(){super.initialize(),this._container=(0,a.div)({id:"_"+Math.random().toString(36).substr(2,9),style:{width:"100%",height:"100%",zIndex:0}})}connect_signals(){super.connect_signals(),this.connect(this.model.properties.code.change,(()=>this._update_code_from_model())),this.connect(this.model.properties.theme.change,(()=>this._update_theme())),this.connect(this.model.properties.language.change,(()=>this._update_language())),this.connect(this.model.properties.filename.change,(()=>this._update_filename())),this.connect(this.model.properties.print_margin.change,(()=>this._update_print_margin())),this.connect(this.model.properties.annotations.change,(()=>this._add_annotations())),this.connect(this.model.properties.readonly.change,(()=>{this._editor.setReadOnly(this.model.readonly)}))}render(){super.render(),this._container!==this.el.childNodes[0]&&this.el.appendChild(this._container),this._container.textContent=this.model.code,this._editor=window.ace.edit(this._container.id),this._langTools=window.ace.require("ace/ext/language_tools"),this._modelist=window.ace.require("ace/ext/modelist"),this._editor.setOptions({enableBasicAutocompletion:!0,enableSnippets:!0,fontFamily:"monospace"}),this._update_theme(),this._update_filename(),this._update_language(),this._editor.setReadOnly(this.model.readonly),this._editor.setShowPrintMargin(this.model.print_margin),this._editor.on("change",(()=>this._update_code_from_editor()))}_update_code_from_model(){this._editor&&this._editor.getValue()!=this.model.code&&this._editor.setValue(this.model.code)}_update_print_margin(){this._editor.setShowPrintMargin(this.model.print_margin)}_update_code_from_editor(){this._editor.getValue()!=this.model.code&&(this.model.code=this._editor.getValue())}_update_theme(){this._editor.setTheme(`ace/theme/${this.model.theme}`)}_update_filename(){if(this.model.filename){const e=this._modelist.getModeForPath(this.model.filename).mode;this.model.language=e.slice(9)}}_update_language(){null!=this.model.language&&this._editor.session.setMode(`ace/mode/${this.model.language}`)}_add_annotations(){this._editor.session.setAnnotations(this.model.annotations)}after_layout(){super.after_layout(),this._editor.resize()}}i.AcePlotView=h,h.__name__="AcePlotView";class _ extends s.HTMLBox{constructor(e){super(e)}static init_AcePlot(){this.prototype.default_view=h,this.define((({Any:e,Array:t,Boolean:i,String:o})=>({code:[o,""],filename:[o],language:[o],theme:[o,"chrome"],annotations:[t(e),[]],readonly:[i,!1],print_margin:[i,!1]}))),this.override({height:300,width:300})}}i.AcePlot=_,_.__name__="AcePlot",_.__module__="panel.models.ace",_.init_AcePlot()},
"80a6464b1f": function _(e,s,i,t,h){t();const n=e("@bokehjs/core/dom"),o=e("@bokehjs/core/util/color"),l=e("@bokehjs/core/layout/html"),a=e("@bokehjs/core/layout/types"),_=e("@bokehjs/models/widgets/markup"),c=e("@bokehjs/models/layouts/html_box");function d(e,s){let i=null!=s.width?"fixed":"fit",t=null!=s.height?"fixed":"fit";const{sizing_mode:h}=s;if(null!=h)if("fixed"==h)i=t="fixed";else if("stretch_both"==h)i=t="max";else if("stretch_width"==h)i="max";else if("stretch_height"==h)t="max";else switch(h){case"scale_width":i="max",t="min";break;case"scale_height":i="min",t="max";break;case"scale_both":i="max",t="max";break;default:throw new Error("unreachable")}"fixed"==i&&s.width?e.style.width=s.width+"px":"max"==i&&(e.style.width="100%"),null!=s.min_width&&(e.style.minWidth=s.min_width+"px"),null!=s.max_width&&(e.style.maxWidth=s.max_width+"px"),"fixed"==t&&s.height?e.style.height=s.height+"px":"max"==t&&(e.style.height="100%"),null!=s.min_height&&(e.style.minHeight=s.min_height+"px"),null!=s.max_width&&(e.style.maxHeight=s.max_height+"px")}i.set_size=d;class r extends l.VariadicBox{constructor(e,s,i){super(e),this.el=e,this.sizing_mode=s,this.changed=i,this._cache=new Map,this._cache_count=new Map}_measure(e){const s=[e.width,e.height,this.sizing_mode].toString(),i=this.changed&&"fixed"!=this.sizing_mode&&null!=this.sizing_mode?1:0,t=this._cache.get(s),h=this._cache_count.get(s);if(null!=t&&null!=h&&h>=i)return this._cache_count.set(s,h+1),t;const o=new a.Sizeable(e).bounded_to(this.sizing.size),l=(0,n.sized)(this.el,o,(()=>{const e=new a.Sizeable((0,n.content_size)(this.el)),{border:s,padding:i}=(0,n.extents)(this.el);return e.grow_by(s).grow_by(i).map(Math.ceil)}));return this._cache.set(s,l),this._cache_count.set(s,0),l}invalidate_cache(){}}i.CachedVariadicBox=r,r.__name__="CachedVariadicBox";class m extends _.MarkupView{_update_layout(){let e=void 0!==this._prev_sizing_mode&&this._prev_sizing_mode!==this.model.sizing_mode;this._prev_sizing_mode=this.model.sizing_mode,this.layout=new r(this.el,this.model.sizing_mode,e),this.layout.set_sizing(this.box_sizing())}render(){super.render(),d(this.markup_el,this.model)}}i.PanelMarkupView=m,m.__name__="PanelMarkupView";class g extends c.HTMLBoxView{connect_signals(){super.connect_signals();const{css_classes:e,background:s}=this.model.properties;this._prev_css_classes=this.model.css_classes,this.on_change([e,s],(()=>{const e=[];let s=!1;for(const i of this.model.css_classes)"pn-loading"===i?s=!0:s?s=!1:e.push(i);const i=this._prev_css_classes;if(JSON.stringify(e)===JSON.stringify(i)){const{background:e}=this.model;this.el.style.backgroundColor=null!=e?(0,o.color2css)(e):"",(0,n.classes)(this.el).clear().add(...this.css_classes())}else this.invalidate_render();this._prev_css_classes=e}))}on_change(e,s){const i=this.model.properties;2===e.length&&e[0]===i.background&&e[1]===i.css_classes||super.on_change(e,s)}_update_layout(){let e=void 0!==this._prev_sizing_mode&&this._prev_sizing_mode!==this.model.sizing_mode;this._prev_sizing_mode=this.model.sizing_mode,this.layout=new r(this.el,this.model.sizing_mode,e),this.layout.set_sizing(this.box_sizing())}render(){super.render(),d(this.el,this.model)}}i.PanelHTMLBoxView=g,g.__name__="PanelHTMLBoxView"},
"33955cfa6f": function _(e,t,i,o,s){o();const l=e("@bokehjs/models/layouts/html_box"),d=e("80a6464b1f");class u extends d.PanelHTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.loop.change,(()=>this.set_loop())),this.connect(this.model.properties.paused.change,(()=>this.set_paused())),this.connect(this.model.properties.time.change,(()=>this.set_time())),this.connect(this.model.properties.value.change,(()=>this.set_value())),this.connect(this.model.properties.volume.change,(()=>this.set_volume())),this.connect(this.model.properties.muted.change,(()=>this.set_muted())),this.connect(this.model.properties.autoplay.change,(()=>this.set_autoplay()))}render(){super.render(),this.audioEl=document.createElement("audio"),this.audioEl.controls=!0,this.audioEl.src=this.model.value,this.audioEl.currentTime=this.model.time,this.audioEl.loop=this.model.loop,this.audioEl.muted=this.model.muted,this.audioEl.autoplay=this.model.autoplay,null!=this.model.volume?this.audioEl.volume=this.model.volume/100:this.model.volume=100*this.audioEl.volume,this.audioEl.onpause=()=>this.model.paused=!0,this.audioEl.onplay=()=>this.model.paused=!1,this.audioEl.ontimeupdate=()=>this.update_time(this),this.audioEl.onvolumechange=()=>this.update_volume(this),this.el.appendChild(this.audioEl),this.model.paused||this.audioEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.audioEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.audioEl.volume)}set_loop(){this.audioEl.loop=this.model.loop}set_muted(){this.audioEl.muted=this.model.muted}set_autoplay(){this.audioEl.autoplay=this.model.autoplay}set_paused(){!this.audioEl.paused&&this.model.paused&&this.audioEl.pause(),this.audioEl.paused&&!this.model.paused&&this.audioEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.audioEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.audioEl.currentTime=this.model.time)}set_value(){this.audioEl.src=this.model.value}}i.AudioView=u,u.__name__="AudioView";class a extends l.HTMLBox{constructor(e){super(e)}static init_Audio(){this.prototype.default_view=u,this.define((({Any:e,Boolean:t,Int:i,Number:o})=>({loop:[t,!1],paused:[t,!0],muted:[t,!1],autoplay:[t,!1],time:[o,0],throttle:[o,250],value:[e,""],volume:[i]})))}}i.Audio=a,a.__name__="Audio",a.__module__="panel.models.widgets",a.init_Audio()},
"0972f6e77b": function _(e,l,s,t,o){t();const i=e("tslib"),a=e("@bokehjs/models/layouts/column"),d=e("@bokehjs/core/util/bbox"),c=(0,i.__importStar)(e("@bokehjs/core/dom")),n=e("@bokehjs/core/dom"),h=e("@bokehjs/core/layout/grid"),r=e("@bokehjs/core/util/color");class _ extends a.ColumnView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.collapsed.change,(()=>this._collapse()));const{active_header_background:e,header_background:l,header_color:s,hide_header:t}=this.model.properties;this.on_change([e,l,s,t],(()=>this.render()))}_update_layout(){let e;e=this.model.hide_header?this.child_views.slice(1):this.model.collapsed?this.child_views.slice(0,1):this.child_views;const l=e.map((e=>e.layout));this.layout=new h.Column(l),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}update_position(){if(this.model.collapsible&&!this.model.hide_header){const e=this.child_views[0],l=e.layout.bbox,s=e.layout.inner_bbox;if(0!=l.x1){let t;if(this.model.collapsible){const e=getComputedStyle(this.button_el.children[0]);t=parseFloat(e.width)+parseFloat(e.marginLeft)||0}else t=0;const o=new d.BBox({x0:l.x0,x1:l.x1-t,y0:l.y0,y1:l.y1}),i=new d.BBox({x0:s.x0,x1:s.x1-t,y0:s.y0,y1:s.y1});e.layout.set_geometry(o,i)}}super.update_position()}render(){(0,n.empty)(this.el);const{background:e,button_css_classes:l,header_color:s,header_tag:t,header_css_classes:o}=this.model;this.el.style.backgroundColor=null!=e?(0,r.color2css)(e):"",(0,n.classes)(this.el).clear().add(...this.css_classes());let i=this.model.header_background;!this.model.collapsed&&this.model.active_header_background&&(i=this.model.active_header_background);const a=this.child_views[0];let d;if(this.model.collapsible){this.button_el=c.createElement("button",{type:"button",class:o});const e=c.createElement("div",{class:l});e.innerHTML=this.model.collapsed?"\u25ba":"\u25bc",this.button_el.appendChild(e),this.button_el.style.backgroundColor=null!=i?i:"",a.el.style.backgroundColor=null!=i?i:"",this.button_el.appendChild(a.el),this.button_el.onclick=()=>this._toggle_button(),d=this.button_el}else d=c.createElement(t,{class:o}),d.style.backgroundColor=null!=i?i:"",d.appendChild(a.el);this.model.hide_header||(d.style.color=null!=s?s:"",this.el.appendChild(d),a.render());for(const e of this.child_views.slice(1))this.model.collapsed||this.el.appendChild(e.el),e.render()}_toggle_button(){this.model.collapsed=!this.model.collapsed}_collapse(){this.invalidate_render()}_createElement(){return c.createElement(this.model.tag,{class:this.css_classes()})}}s.CardView=_,_.__name__="CardView";class u extends a.Column{constructor(e){super(e)}static init_Card(){this.prototype.default_view=_,this.define((({Array:e,Boolean:l,Nullable:s,String:t})=>({active_header_background:[s(t),null],button_css_classes:[e(t),[]],collapsed:[l,!0],collapsible:[l,!0],header_background:[s(t),null],header_color:[s(t),null],header_css_classes:[e(t),[]],header_tag:[t,"div"],hide_header:[l,!1],tag:[t,"div"]})))}}s.Card=u,u.__name__="Card",u.__module__="panel.models.layout",u.init_Card()},
"754fbb1f55": function _(e,t,s,n,i){n();const o=e("@bokehjs/document"),_=e("@bokehjs/core/view"),c=e("@bokehjs/model"),h=e("@bokehjs/protocol/message"),l=e("@bokehjs/protocol/receiver");s.comm_settings={debounce:!0};class a extends _.View{renderTo(){}}s.CommManagerView=a,a.__name__="CommManagerView";class d extends c.Model{constructor(e){super(e),this._document_listener=e=>this._document_changed(e),this._receiver=new l.Receiver,this._event_buffer=[],this._blocked=!1,this._timeout=Date.now(),null!=window.PyViz&&window.PyViz.comm_manager?(this.ns=window.PyViz,this.ns.comm_manager.register_target(this.plot_id,this.comm_id,(e=>{for(const t of this.ns.shared_views.get(this.plot_id))t!==this&&t.msg_handler(e);this.msg_handler(e)})),this._client_comm=this.ns.comm_manager.get_client_comm(this.plot_id,this.client_comm_id,(e=>this.on_ack(e))),null==this.ns.shared_views&&(this.ns.shared_views=new Map),this.ns.shared_views.has(this.plot_id)?this.ns.shared_views.get(this.plot_id).push(this):this.ns.shared_views.set(this.plot_id,[this])):console.log("Could not find comm manager on window.PyViz, ensure the extension is loaded.")}_doc_attached(){super._doc_attached(),null!=this.document&&this.document.on_change(this._document_listener)}_document_changed(e){e.setter_id!==this.id&&(e instanceof o.ModelChangedEvent&&!(e.attr in e.model.serializable_attributes())||(this._event_buffer.push(e),s.comm_settings.debounce?(!this._blocked||Date.now()>this._timeout)&&(setTimeout((()=>this.process_events()),this.debounce),this._blocked=!0,this._timeout=Date.now()+this.timeout):this.process_events()))}process_events(){if(null==this.document||null==this._client_comm)return;const e=this.document.create_json_patch(this._event_buffer);this._event_buffer=[];const t=h.Message.create("PATCH-DOC",{},e);this._client_comm.send(t);for(const t of this.ns.shared_views.get(this.plot_id))t!==this&&null!=t.document&&t.document.apply_json_patch(e,[],this.id)}disconnect_signals(){super.disconnect_signals(),this.ns.shared_views.shared_views.delete(this.plot_id)}on_ack(e){const t=e.metadata;this._event_buffer.length?(this._blocked=!0,this._timeout=Date.now()+this.timeout,this.process_events()):this._blocked=!1,"Ready"==t.msg_type&&t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.log("Python failed with the following traceback:",t.traceback)}msg_handler(e){const t=e.metadata,s=e.buffers,n=e.content.data,i=this.plot_id;if("Ready"==t.msg_type)t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.log("Python failed with the following traceback:",t.traceback);else if(null!=i){let e=null;if(i in this.ns.plot_index&&null!=this.ns.plot_index[i]?e=this.ns.plot_index[i]:void 0!==window.Bokeh&&i in window.Bokeh.index&&(e=window.Bokeh.index[i]),null==e)return;null!=s&&s.length>0?this._receiver.consume(s[0].buffer):this._receiver.consume(n);const t=this._receiver.message;null!=t&&Object.keys(t.content).length>0&&null!=this.document&&this.document.apply_json_patch(t.content,t.buffers,this.id)}}static init_CommManager(){this.prototype.default_view=a,this.define((({Int:e,String:t})=>({plot_id:[t],comm_id:[t],client_comm_id:[t],timeout:[e,5e3],debounce:[e,50]})))}}s.CommManager=d,d.__name__="CommManager",d.__module__="panel.models.comm_manager",d.init_CommManager()},
"e258e515be": function _(e,t,s,o,i){var l;o();const d=e("@bokehjs/models/widgets/selectbox");class n extends d.SelectView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled_options.change,(()=>this._update_disabled_options()))}options_el(){let e=super.options_el();return e.forEach((e=>{this.model.disabled_options.includes(e.value)&&e.setAttribute("disabled","true")})),e}_update_disabled_options(){for(const e of this.input_el.options)this.model.disabled_options.includes(e.value)?e.setAttribute("disabled","true"):e.removeAttribute("disabled")}}s.CustomSelectView=n,n.__name__="CustomSelectView";class _ extends d.Select{constructor(e){super(e)}}s.CustomSelect=_,l=_,_.__name__="CustomSelect",_.__module__="panel.models.widgets",l.prototype.default_view=n,l.define((({Array:e,String:t})=>({disabled_options:[e(t),[]]})))},
"6ab332f75c": function _(t,e,i,o,s){o();const l=t("@bokehjs/core/dom"),n=t("@bokehjs/core/util/types"),a=t("@bokehjs/models/layouts/html_box"),r=t("@bokehjs/core/build_views"),d=t("@bokehjs/core/bokeh_events"),h=t("@bokehjs/core/dom"),u=t("@bokehjs/core/kinds"),c=t("@bokehjs/models/sources/column_data_source"),m=t("@bokehjs/models/widgets/tables"),g=t("99a25e6992"),f=t("754fbb1f55"),_=t("7f7d9e0c6b"),p=t("80a6464b1f");class b extends d.ModelEvent{constructor(t,e){super(),this.column=t,this.row=e,this.event_name="table-edit"}_to_json(){return{model:this.origin,column:this.column,row:this.row}}}i.TableEditEvent=b,b.__name__="TableEditEvent";class y extends d.ModelEvent{constructor(t,e){super(),this.column=t,this.row=e,this.event_name="cell-click"}_to_json(){return{model:this.origin,column:this.column,row:this.row}}}function w(t,e,i){for(const o of i)if(o[t]==e)return o;return null}function x(t,e,i,o=0){const s={};if(0==t.length)return s;const l=i[o];for(const a of t){const t=x(a._children,e,i,o+1);for(const e in t)(0,n.isArray)(t[e])?a[e]=t[e].reduce(((t,e)=>t+e),0)/t[e].length:a[e]=t[e];for(const t of e.slice(1)){const e=a[t.field];if(t.field in s){const i=s[t.field];"min"===l?s[t.field]=Math.min(e,i):"max"===l?s[t.field]=Math.max(e,i):"sum"===l?s[t.field]=e+i:"mean"===l&&((0,n.isArray)(s[t.field])?s[t.field].push(e):s[t.field]=[i,e])}else s[t.field]=e}}return s}function v(t,e,i,o){const s=[],l=e[0].field;for(const o of t){const t=o[i[0]];let n=w(l,t,s);null==n&&(n={_children:[]},n[l]=t,s.push(n));let a=n;const r={};for(const t of i.slice(1)){a=w(l,o[t],a._children),null==a&&(a={_children:[]},a[l]=o[t],n._children.push(a)),r[t]=n;for(const t of e.slice(1))a[t.field]=o[t];n=a}for(const t of e.slice(1))a[t.field]=o[t.field]}const n=[];for(const t of i)n.push(t in o?o[t]:"sum");return x(s,e,n),s}i.CellClickEvent=y,y.__name__="CellClickEvent";const T=function(t,e,i,o,s,l,n){let a;a=0;const r={zone:new window.luxon.IANAZone("UTC")};if(t="-9223372036854776"==String(t)?window.luxon.DateTime.fromISO("invalid"):window.luxon.DateTime.fromMillis(t,r),e="-9223372036854776"==String(e)?window.luxon.DateTime.fromISO("invalid"):window.luxon.DateTime.fromMillis(e,r),t.isValid){if(e.isValid)return t-e;a=1}else a=e.isValid?-1:0;return a*=-1,a},C=function(t,e,i,o){const s=t.getValue(),l={zone:new window.luxon.IANAZone("UTC")};let n;n="NaN"===s||null===s?null:window.luxon.DateTime.fromMillis(s,l).toFormat("yyyy-MM-dd");const a=document.createElement("input");function r(){const t=window.luxon.DateTime.fromFormat(a.value,"yyyy-MM-dd",l).toMillis();t!=n?i(t):o()}return a.setAttribute("type","date"),a.style.padding="4px",a.style.width="100%",a.style.boxSizing="border-box",a.value=n,e((()=>{a.focus(),a.style.height="100%"})),a.addEventListener("blur",r),a.addEventListener("keydown",(function(t){13==t.keyCode&&r(),27==t.keyCode&&o()})),a},S=function(t,e,i,o){const s=t.getValue(),l={zone:new window.luxon.IANAZone("UTC")};let n;n="NaN"===s||null===s?null:window.luxon.DateTime.fromMillis(s,l).toFormat("yyyy-MM-dd'T'T");const a=document.createElement("input");function r(){const t=window.luxon.DateTime.fromFormat(a.value,"yyyy-MM-dd'T'T",l).toMillis();t!=n?i(t):o()}return a.setAttribute("type","datetime-local"),a.style.padding="4px",a.style.width="100%",a.style.boxSizing="border-box",a.value=n,e((()=>{a.focus(),a.style.height="100%"})),a.addEventListener("blur",r),a.addEventListener("keydown",(function(t){13==t.keyCode&&r(),27==t.keyCode&&o()})),a};class k extends p.PanelHTMLBoxView{constructor(){super(...arguments),this._tabulator_cell_updating=!1,this._updating_page=!0,this._updating_sort=!1,this._relayouting=!1,this._selection_updating=!1,this._lastVerticalScrollbarTopPosition=0,this._applied_styles=!1,this._building=!1}connect_signals(){super.connect_signals();const t=this.model.properties,{configuration:e,layout:i,columns:o,theme:s,groupby:l}=t;this.on_change([e,i,o,l],(0,g.debounce)((()=>this.invalidate_render()),20,!1)),this.on_change([s],(()=>this.setCSS())),this.connect(t.download.change,(()=>{const t=this.model.filename.endsWith(".json")?"json":"csv";this.tabulator.download(t,this.model.filename)})),this.connect(t.children.change,(()=>this.renderChildren())),this.connect(t.expanded.change,(()=>{for(const t of this.tabulator.rowManager.getRows())t.cells.length>0&&t.cells[0].layoutElement();for(const t of this.tabulator.rowManager.getRows())if(t.cells.length>0){const e=t.data._index,i=this.model.expanded.indexOf(e)<0?"\u25ba":"\u25bc";t.cells[1].element.innerText=i}})),this.connect(t.styles.change,(()=>{this._applied_styles&&this.tabulator.redraw(!0),this.setStyles()})),this.connect(t.hidden_columns.change,(()=>this.setHidden())),this.connect(t.page_size.change,(()=>this.setPageSize())),this.connect(t.page.change,(()=>{this._updating_page||this.setPage()})),this.connect(t.max_page.change,(()=>this.setMaxPage())),this.connect(t.frozen_rows.change,(()=>this.setFrozen())),this.connect(t.sorters.change,(()=>this.setSorters())),this.connect(this.model.source.properties.data.change,(()=>this.setData())),this.connect(this.model.source.streaming,(()=>this.addData())),this.connect(this.model.source.patching,(()=>{const t=this.model.source.selected.indices;this.updateOrAddData(),this.tabulator.rowManager.element.scrollTop=this._lastVerticalScrollbarTopPosition,this.model.source.selected.indices=t})),this.connect(this.model.source.selected.change,(()=>this.setSelection())),this.connect(this.model.source.selected.properties.indices.change,(()=>this.setSelection()))}get sorters(){const t=[];this.model.sorters.length&&t.push({column:"_index",dir:"asc"});for(const e of this.model.sorters.reverse())void 0===e.column&&(e.column=e.field),t.push(e);return t}invalidate_render(){this.tabulator.destroy(),this.tabulator=null,this.render(),this.relayout()}redraw(){this._building||(null!=this.tabulator.columnManager.element&&this.tabulator.columnManager.redraw(!0),null!=this.tabulator.rowManager.renderer&&(this.tabulator.rowManager.redraw(!0),this.setStyles()))}after_layout(){super.after_layout(),null==this.tabulator||this._relayouting&&!this._initializing||this.redraw()}render(){super.render();if(this.setCSS())return;this._initializing=!0;const t=(0,h.div)({class:"pnx-tabulator"});(0,p.set_size)(t,this.model);let e=this.getConfiguration();this.tabulator=new Tabulator(t,e),this.init_callbacks(),this.renderChildren(!0),this.setHidden(),this.el.appendChild(t)}tableInit(){this._building=!0;this.tabulator.modules.ajax.sendRequest=(t,e,i)=>this.requestPage(e.page,e.sort),this.tabulator.modules.page._parseRemoteData=()=>!1}init_callbacks(){this.tabulator.on("tableBuilding",(()=>this.tableInit())),this.tabulator.on("tableBuilt",(()=>this.tableBuilt())),this.tabulator.on("dataLoading",(()=>{this.tabulator.modules.frozenColumns.active=!1})),this.tabulator.on("selectableCheck",(t=>{const e=this.model.selectable_rows;return null==e||e.indexOf(t._row.data._index)>=0})),this.tabulator.on("tooltips",(t=>t.getColumn().getField()+": "+t.getValue())),this.tabulator.on("scrollVertical",(0,g.debounce)((()=>{this.setStyles()}),50,!1)),this.tabulator.on("rowFormatter",(t=>this._render_row(t))),this.tabulator.on("rowSelectionChanged",((t,e)=>this.rowSelectionChanged(t,e))),this.tabulator.on("rowClick",((t,e)=>this.rowClicked(t,e))),this.tabulator.on("cellEdited",(t=>this.cellEdited(t))),this.tabulator.on("dataFiltering",(t=>{this.model.filters=t})),this.tabulator.on("dataFiltered",((t,e)=>{this._initializing||(0===e.length&&this.tabulator.rowManager.renderEmptyScroll(),this.updatePage(this.tabulator.getPage()))})),this.tabulator.on("pageLoaded",(t=>{this.updatePage(t)})),this.tabulator.on("dataSorting",(t=>{const e=[];for(const i of t)"_index"!==i.field&&e.push({field:i.field,dir:i.dir});"remote"!==this.model.pagination&&(this._updating_sort=!0,this.model.sorters=e,this._updating_sort=!1)}))}tableBuilt(){this._building=!1,this.setHidden(),this.setSelection(),this.setMaxPage(),this.tabulator.setPage(this.model.page),this.setStyles(),this.renderChildren(),this.setGroupBy(),this.setFrozen(),this.tabulator.modules.frozenColumns.active=!0,this.tabulator.modules.frozenColumns.layout(),this._initializing=!1}relayout(){if(!this._relayouting){if(this._relayouting=!0,this.tabulator.rowManager.renderer&&this.tabulator.rowManager.adjustTableSize(),this.update_layout(),this.compute_layout(),this.root!==this){this.invalidate_layout();const t=this.root._parent;null!=t&&null!=t.relayout&&t.relayout()}else null!=this._parent&&(null!=this._parent.relayout?this._parent.relayout():this._parent.invalidate_layout());this._relayouting=!1}}requestPage(t,e){return new Promise(((i,o)=>{try{if(null!=t&&null!=e){this._updating_sort=!0;const i=[];for(const t of e)"_index"!==t.field&&i.push({field:t.field,dir:t.dir});this.model.sorters=i,this._updating_sort=!1,this._updating_page=!0;try{this.model.page=t||1}finally{this._updating_page=!1}}i([])}catch(t){o(t)}}))}getLayout(){switch(this.model.layout){case"fit_data":return"fitData";case"fit_data_fill":return"fitDataFill";case"fit_data_stretch":return"fitDataStretch";case"fit_data_table":return"fitDataTable";case"fit_columns":return"fitColumns"}}getConfiguration(){let t="toggle"===this.model.select_mode||NaN,e=Object.assign(Object.assign({},this.model.configuration),{index:"_index",nestedFieldSeparator:!1,movableColumns:!1,selectable:t,columns:this.getColumns(),initialSort:this.sorters,layout:this.getLayout(),pagination:null!=this.model.pagination,paginationMode:this.model.pagination,paginationSize:this.model.page_size,paginationInitialPage:1});"remote"===this.model.pagination&&(e.ajaxURL="http://panel.pyviz.org",e.sortMode="remote");const i=this.model.source;let o;return o=null===i||0===i.columns().length?[]:(0,_.transform_cds_to_records)(i,!0),e.dataTree&&(o=v(o,this.model.columns,this.model.indexes,this.model.aggregators)),Object.assign(Object.assign({},e),{data:o})}renderChildren(t=!1){new Promise((async t=>{const e=[];for(const t of this.model.expanded)t in this.model.children&&e.push(this.model.children[t]);await(0,r.build_views)(this._child_views,e,{parent:null}),t(null)})).then((()=>{for(const t of this.model.expanded){const e=this.tabulator.getRow(t);this._render_row(e)}this.model.expanded.length||t||setTimeout((()=>this.relayout()),20)}))}_render_row(t){const e=t._row.data._index;if(this.model.expanded.indexOf(e)<0||!(e in this.model.children))return;const i=this.model.children[e],o=this._child_views.get(i);if(null==o)return;o._parent=this;const s=t.getElement();let l=s.children[s.children.length-1];if("bk"===l.className){if(l.children.length)return}else l=null;if(null==l){const t=getComputedStyle(this.tabulator.element.children[1].children[0]).backgroundColor,e="-"+s.style.paddingLeft;l=(0,h.div)({style:"background-color: "+t+"; margin-left:"+e})}t.getElement().appendChild(l),o.renderTo(l)}_expand_render(t){const e=t._cell.row.data._index;return"<i>"+(this.model.expanded.indexOf(e)<0?"\u25ba":"\u25bc")+"</i>"}_update_expand(t){const e=t._cell.row.data._index,i=[...this.model.expanded],o=i.indexOf(e);if(o<0)i.push(e);else{const t=i.splice(o,1)[0];if(t in this.model.children){const e=this.model.children[t],i=this._child_views.get(e);void 0!==i&&null!=i.el&&(0,l.undisplay)(i.el)}}if(this.model.expanded=i,i.indexOf(e)<0)return;let s=!0;for(const t of this.model.expanded)if(!(t in this.model.children)){s=!1;break}s&&this.renderChildren()}getData(){let t=(0,_.transform_cds_to_records)(this.model.source,!0);return this.model.configuration.dataTree&&(t=v(t,this.model.columns,this.model.indexes,this.model.aggregators)),t}getColumns(){var t;const e=null===(t=this.model.configuration)||void 0===t?void 0:t.columns;let i=[];if(i.push({field:"_index",frozen:!0}),null!=e)for(const t of e)if(null!=t.columns){const e=[];for(const i of t.columns)e.push(Object.assign({},i));i.push(Object.assign(Object.assign({},t),{columns:e}))}else if("expand"===t.formatter){const t={hozAlign:"center",cellClick:(t,e)=>{this._update_expand(e)},formatter:t=>this._expand_render(t),width:40,frozen:!0};i.push(t)}else{const e=Object.assign({},t);"rowSelection"===e.formatter&&(e.cellClick=(t,e)=>{e.getRow().toggleSelect()}),i.push(e)}for(const t of this.model.columns){let o=null;if(null!=e)for(const e of i)if(null!=e.columns){for(const i of e.columns)if(t.field===i.field){o=i;break}if(null!=o)break}else if(t.field===e.field){o=e;break}if(null==o&&(o={field:t.field}),null==o.title&&(o.title=t.title),null==o.width&&null!=t.width&&0!=t.width&&(o.width=t.width),null==o.formatter&&null!=t.formatter){const e=t.formatter.type;o.formatter="BooleanFormatter"===e?"tickCross":e=>{const i=t.formatter.doFormat(e.getRow(),e,e.getValue(),null,null);if("HTMLTemplateFormatter"===t.formatter.type)return i;const o=(0,h.div)();o.innerHTML=i;const s=o.children[0];return"function(){return c.convert(arguments)}"===s.innerHTML?"":s}}"timestamp"==o.sorter&&(o.sorter=T);const s=t.editor,l=s.type;null!=o.editor?"date"===o.editor?o.editor=C:"datetime"===o.editor&&(o.editor=S):"StringEditor"===l?s.completions.length>0?(o.editor="list",o.editorParams={values:s.completions,autocomplete:!0,listOnEmpty:!0}):o.editor="input":"TextEditor"===l?o.editor="textarea":"IntEditor"===l||"NumberEditor"===l?(o.editor="number",o.editorParams={step:s.step}):"CheckboxEditor"===l?o.editor="tickCross":"DateEditor"===l?o.editor=C:"SelectEditor"===l?(o.editor="list",o.editorParams={values:s.options}):null!=s&&null!=s.default_view&&(o.editor=(e,i,o,s)=>{this.renderEditor(t,e,i,o,s)}),o.editable=()=>this.model.editable&&null!=s.default_view,o.headerFilter&&"boolean"==typeof o.headerFilter&&"string"==typeof o.editor&&(o.headerFilter=o.editor,o.headerFilterParams=o.editorParams);for(const t of this.model.sorters)o.field===t.field&&(o.headerSortStartingDir=t.dir);o.cellClick=(e,i)=>{const o=i.getData()._index;this.model.trigger_event(new y(t.field,o))},null==e&&i.push(o)}for(const t in this.model.buttons){const e={formatter:()=>this.model.buttons[t],hozAlign:"center",cellClick:(e,i)=>{const o=i.getData()._index;this.model.trigger_event(new y(t,o))}};i.push(e)}return i}renderEditor(t,e,i,o,s){const l=t.editor,n=new l.default_view({column:t,model:l,parent:this,container:e._cell.element});return n.initialize(),n.connect_signals(),i((()=>{n.setValue(e.getValue())})),n.inputEl.addEventListener("change",(()=>{const t=n.serializeValue(),i=e.getValue(),l=n.validate();l.valid||s(l.msg),null!=i&&typeof t!=typeof i?s("Mismatching type"):o(n.serializeValue())})),n.inputEl}setData(){const t=this.getData();null!=this.model.pagination?this.tabulator.rowManager.setData(t,!0,!1):this.tabulator.setData(t),this.postUpdate()}addData(){const t=this.tabulator.rowManager.getRows(),e=t[t.length-1],i=(null==e?void 0:e.data._index)||0;this.setData(),this.postUpdate(),this.model.follow&&e&&this.tabulator.scrollToRow(i,"top",!1)}postUpdate(){this.model.pagination||this.setFrozen(),this.setSelection(),null==this.model.height&&null==this.model.pagination&&this.relayout()}updateOrAddData(){if(this._tabulator_cell_updating)return;let t=(0,_.transform_cds_to_records)(this.model.source,!0);this.tabulator.setData(t),this.postUpdate()}setFrozen(){for(const t of this.model.frozen_rows)this.tabulator.getRow(t).freeze()}updatePage(t){"local"===this.model.pagination&&this.model.page!==t&&(this._updating_page=!0,this.model.page=t,this._updating_page=!1)}setGroupBy(){if(0==this.model.groupby.length)return void this.tabulator.setGroupBy(!1);const t=t=>{const e=[];for(const i of this.model.groupby){const o=i+": "+t[i];e.push(o)}return e.join(", ")};this.tabulator.setGroupBy(t),this.tabulator.setGroupBy(t)}setSorters(){this._updating_sort||this.tabulator.setSort(this.sorters)}setCSS(){let t,e;"default"==this.model.theme?t="tabulator":(e="bootstrap"==this.model.theme?"bootstrap3":"semantic-ui"==this.model.theme?"semanticui":this.model.theme,t="tabulator_"+e);const i=this.model.theme_url+t+".min.css";let o=null;const s=document.getElementsByTagName("link"),l=this.model.theme_url.indexOf("dist/"),n=this.model.theme_url.slice(0,l);for(const t of s)if(t.href.indexOf(n)>=0){o=t;break}if(null!=o)return!o.href.endsWith(i)&&(o.href=i,setTimeout((()=>this.render()),100),!0);let a=document.getElementsByTagName("head")[0];const r=document.createElement("link");return r.type="text/css",r.rel="stylesheet",r.media="screen",r.href=i,r.onload=()=>{this._building||(this.render(),this.relayout())},a.appendChild(r),!0}setStyles(){if(null!=this.tabulator&&0!=this.tabulator.getDataCount()){this._applied_styles=!1;for(const t in this.model.styles.data){const e=this.model.styles.data[t],i=this.tabulator.getRow(t);if(!i)continue;const o=i._row.cells;for(const t in e){const i=e[t],s=o[t];if(null==s||!i.length)continue;const l=s.element;for(const t of i){let e,i;if((0,n.isArray)(t))[e,i]=t;else{if(!t.includes(":"))continue;[e,i]=t.split(":")}l.style.setProperty(e,i.trimLeft()),this._applied_styles=!0}}}}}setHidden(){for(const t of this.tabulator.getColumns()){const e=t._column;"_index"==e.field||this.model.hidden_columns.indexOf(e.field)>-1?t.hide():t.show()}}setMaxPage(){this.tabulator.setMaxPage(this.model.max_page),this.tabulator.modules.page.pagesElement&&this.tabulator.modules.page._setPageButtons()}setPage(){this.tabulator.setPage(Math.min(this.model.max_page,this.model.page))}setPageSize(){this.tabulator.setPageSize(this.model.page_size)}setSelection(){if(null==this.tabulator||this._selection_updating)return;const t=this.model.source.selected.indices,e=this.tabulator.getSelectedData().map((t=>t._index));if(JSON.stringify(t)!=JSON.stringify(e)){this._selection_updating=!0,this.tabulator.deselectRow(),this.tabulator.selectRow(t);for(const e of t){this.tabulator.rowManager.findRow(e)&&this.tabulator.scrollToRow(e,"center",!1).catch((()=>{}))}this._selection_updating=!1}}rowClicked(t,e){var i;if(this._selection_updating||this._initializing||"string"==typeof this.model.select_mode||!1===this.model.select_mode||this.model.configuration.dataTree||"\u25ba"===(null===(i=t.srcElement)||void 0===i?void 0:i.innerText))return;let o=[];const s=this.model.source.selected,l=e._row.data._index;if(t.ctrlKey||t.metaKey)o=this.model.source.selected.indices;else if(t.shiftKey&&s.indices.length){const t=s.indices[s.indices.length-1];if(l>t)for(let e=t;e<l;e++)o.push(e);else for(let e=t;e>l;e--)o.push(e)}if(o.indexOf(l)<0?o.push(l):o.splice(o.indexOf(l),1),"number"==typeof this.model.select_mode)for(;o.length>this.model.select_mode;)o.shift();const n=this._filter_selected(o);this.tabulator.deselectRow(),this.tabulator.selectRow(n),this._selection_updating=!0,s.indices=n,this._selection_updating=!1}_filter_selected(t){const e=[];for(const i of t)(null==this.model.selectable_rows||this.model.selectable_rows.indexOf(i)>=0)&&e.push(i);return e}rowSelectionChanged(t,e){if(this._selection_updating||this._initializing||"boolean"==typeof this.model.select_mode||"number"==typeof this.model.select_mode||this.model.configuration.dataTree)return;const i=t.map((t=>t._index)),o=this._filter_selected(i);this._selection_updating=i.length===o.length,this.model.source.selected.indices=o,this._selection_updating=!1}cellEdited(t){const e=t._cell.column.field,i=t.getData()._index,o=t._cell.value;this._tabulator_cell_updating=!0,f.comm_settings.debounce=!1;try{this.model.source.patch({[e]:[[i,o]]})}finally{f.comm_settings.debounce=!0,this._tabulator_cell_updating=!1}this.model.trigger_event(new b(e,i)),this.tabulator.scrollToRow(i,"top",!1)}}i.DataTabulatorView=k,k.__name__="DataTabulatorView",i.TableLayout=(0,u.Enum)("fit_data","fit_data_fill","fit_data_stretch","fit_data_table","fit_columns");class M extends a.HTMLBox{constructor(t){super(t)}static init_DataTabulator(){this.prototype.default_view=k,this.define((({Any:t,Array:e,Boolean:o,Nullable:s,Number:l,Ref:n,String:a})=>({aggregators:[t,{}],buttons:[t,{}],children:[t,{}],configuration:[t,{}],columns:[e(n(m.TableColumn)),[]],download:[o,!1],editable:[o,!0],expanded:[e(l),[]],filename:[a,"table.csv"],filters:[e(t),[]],follow:[o,!0],frozen_rows:[e(l),[]],groupby:[e(a),[]],hidden_columns:[e(a),[]],indexes:[e(a),[]],layout:[i.TableLayout,"fit_data"],max_page:[l,0],pagination:[s(a),null],page:[l,0],page_size:[l,0],select_mode:[t,!0],selectable_rows:[s(e(l)),null],source:[n(c.ColumnDataSource)],sorters:[e(t),[]],styles:[t,{}],theme:[a,"simple"],theme_url:[a,"https://unpkg.com/tabulator-tables@5.3.2/dist/css/"]})))}}i.DataTabulator=M,M.__name__="DataTabulator",M.__module__="panel.models.tabulator",M.init_DataTabulator()},
"99a25e6992": function _(n,l,u,t,e){function o(n,l,u){var t,e,o,a,r;function i(){var c=Date.now()-a;c<l&&c>=0?t=setTimeout(i,l-c):(t=null,u||(r=n.apply(o,e),o=e=null))}null==l&&(l=100);var c=function(){o=this,e=arguments,a=Date.now();var c=u&&!t;return t||(t=setTimeout(i,l)),c&&(r=n.apply(o,e),o=e=null),r};return c.clear=function(){t&&(clearTimeout(t),t=null)},c.flush=function(){t&&(r=n.apply(o,e),o=e=null,clearTimeout(t),t=null)},c}o.debounce=o,l.exports=o},
"7f7d9e0c6b": function _(n,t,e,o,r){o(),e.transform_cds_to_records=function(n,t=!1,e=0){const o=[],r=n.columns(),l=n.get_length();if(0===r.length||null===l)return[];for(let c=e;c<l;c++){const e={};for(const t of r){let o=n.get_array(t);const r=null==o[0].shape?null:o[0].shape;null!=r&&r.length>1&&"number"==typeof r[0]?e[t]=o.slice(c*r[1],c*r[1]+r[1]):e[t]=o[c]}t&&(e._index=c),o.push(e)}return o},e.dict_to_records=function(n,t=!0){for(let e=0;e<n.index.length;e++){const o={};for(const r of n)(t||"index"!==r)&&(o[r]=n[r][e])}return[]}},
"297274885a": function _(e,t,i,s,n){s();const o=e("tslib"),a=(0,o.__importDefault)(e("50d3473f3f")),l=e("@bokehjs/models/widgets/input_widget"),d=e("@bokehjs/core/dom"),r=e("@bokehjs/core/enums"),m=e("@bokehjs/core/util/types"),c=(0,o.__importStar)(e("@bokehjs/styles/widgets/inputs.css")),h=(0,o.__importDefault)(e("@bokehjs/styles/widgets/flatpickr.css"));function _(e){const t=[];for(const i of e)if((0,m.isString)(i))t.push(i);else{const[e,s]=i;t.push({from:e,to:s})}return t}class u extends l.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,min_date:t,max_date:i,disabled_dates:s,enabled_dates:n,position:o,inline:a,enable_time:l,enable_seconds:d,military_time:r,date_format:m,mode:c}=this.model.properties;this.connect(e.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.setDate(this.model.value)})),this.connect(t.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("minDate",this.model.min_date)})),this.connect(i.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("maxDate",this.model.max_date)})),this.connect(s.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("disable",this.model.disabled_dates)})),this.connect(n.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enable",this.model.enabled_dates)})),this.connect(o.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("position",this.model.position)})),this.connect(a.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("inline",this.model.inline)})),this.connect(l.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enableTime",this.model.enable_time)})),this.connect(d.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("enableSeconds",this.model.enable_seconds)})),this.connect(r.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("time_24hr",this.model.military_time)})),this.connect(c.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("mode",this.model.mode)})),this.connect(m.change,(()=>{var e;return null===(e=this._picker)||void 0===e?void 0:e.set("dateFormat",this.model.date_format)}))}remove(){var e;null===(e=this._picker)||void 0===e||e.destroy(),super.remove()}styles(){return[...super.styles(),h.default]}render(){null==this._picker&&(super.render(),this.input_el=(0,d.input)({type:"text",class:c.input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=(0,a.default)(this.input_el,{defaultDate:this.model.value,minDate:this.model.min_date?new Date(this.model.min_date):void 0,maxDate:this.model.max_date?new Date(this.model.max_date):void 0,inline:this.model.inline,position:this.model.position,disable:_(this.model.disabled_dates),enable:_(this.model.enabled_dates),enableTime:this.model.enable_time,enableSeconds:this.model.enable_seconds,time_24hr:this.model.military_time,dateFormat:this.model.date_format,mode:this.model.mode,onClose:(e,t,i)=>this._on_close(e,t,i)}),this._picker.maxDateHasTime=!0,this._picker.minDateHasTime=!0)}_on_close(e,t,i){("range"!=this.model.mode||t.includes("to"))&&(this.model.value=t,this.change_input())}}i.DatetimePickerView=u,u.__name__="DatetimePickerView";class p extends l.InputWidget{constructor(e){super(e)}static init_DatetimePicker(){this.prototype.default_view=u,this.define((({Boolean:e,String:t,Array:i,Tuple:s,Or:n,Nullable:o})=>{const a=i(n(t,s(t,t)));return{value:[t],min_date:[o(t),null],max_date:[o(t),null],disabled_dates:[a,[]],enabled_dates:[a,[]],position:[r.CalendarPosition,"auto"],inline:[e,!1],enable_time:[e,!0],enable_seconds:[e,!0],military_time:[e,!0],date_format:[t,"Y-m-d H:i:S"],mode:[t,"single"]}}))}}i.DatetimePicker=p,p.__name__="DatetimePicker",p.__module__="panel.models.datetime_picker",p.init_DatetimePicker()},
"50d3473f3f": function _(e,n,t,a,i){
/* flatpickr v4.6.6, @license MIT */var o,r;o=this,r=function(){"use strict";
/*! *****************************************************************************
        Copyright (c) Microsoft Corporation.
    
        Permission to use, copy, modify, and/or distribute this software for any
        purpose with or without fee is hereby granted.
    
        THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
        REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
        AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
        INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
        LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
        OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
        PERFORMANCE OF THIS SOFTWARE.
        ***************************************************************************** */var e=function(){return e=Object.assign||function(e){for(var n,t=1,a=arguments.length;t<a;t++)for(var i in n=arguments[t])Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i]);return e},e.apply(this,arguments)};function n(){for(var e=0,n=0,t=arguments.length;n<t;n++)e+=arguments[n].length;var a=Array(e),i=0;for(n=0;n<t;n++)for(var o=arguments[n],r=0,l=o.length;r<l;r++,i++)a[i]=o[r];return a}var t=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],a={_disable:[],_enable:[],allowInput:!1,allowInvalidPreload:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",autoFillDefaultTime:!0,clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enable:[],enableSeconds:!1,enableTime:!1,errorHandler:function(e){return"undefined"!=typeof console&&console.warn(e)},getWeek:function(e){var n=new Date(e.getTime());n.setHours(0,0,0,0),n.setDate(n.getDate()+3-(n.getDay()+6)%7);var t=new Date(n.getFullYear(),0,4);return 1+Math.round(((n.getTime()-t.getTime())/864e5-3+(t.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1},i={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(e){var n=e%100;if(n>3&&n<21)return"th";switch(n%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},o=function(e,n){return void 0===n&&(n=2),("000"+e).slice(-1*n)},r=function(e){return!0===e?1:0};function l(e,n,t){var a;return void 0===t&&(t=!1),function(){var i=this,o=arguments;null!==a&&clearTimeout(a),a=window.setTimeout((function(){a=null,t||e.apply(i,o)}),n),t&&!a&&e.apply(i,o)}}var c=function(e){return e instanceof Array?e:[e]};function d(e,n,t){if(!0===t)return e.classList.add(n);e.classList.remove(n)}function s(e,n,t){var a=window.document.createElement(e);return n=n||"",t=t||"",a.className=n,void 0!==t&&(a.textContent=t),a}function u(e){for(;e.firstChild;)e.removeChild(e.firstChild)}function f(e,n){return n(e)?e:e.parentNode?f(e.parentNode,n):void 0}function m(e,n){var t=s("div","numInputWrapper"),a=s("input","numInput "+e),i=s("span","arrowUp"),o=s("span","arrowDown");if(-1===navigator.userAgent.indexOf("MSIE 9.0")?a.type="number":(a.type="text",a.pattern="\\d*"),void 0!==n)for(var r in n)a.setAttribute(r,n[r]);return t.appendChild(a),t.appendChild(i),t.appendChild(o),t}function g(e){try{return"function"==typeof e.composedPath?e.composedPath()[0]:e.target}catch(n){return e.target}}var p=function(){},h=function(e,n,t){return t.months[n?"shorthand":"longhand"][e]},v={D:p,F:function(e,n,t){e.setMonth(t.months.longhand.indexOf(n))},G:function(e,n){e.setHours(parseFloat(n))},H:function(e,n){e.setHours(parseFloat(n))},J:function(e,n){e.setDate(parseFloat(n))},K:function(e,n,t){e.setHours(e.getHours()%12+12*r(new RegExp(t.amPM[1],"i").test(n)))},M:function(e,n,t){e.setMonth(t.months.shorthand.indexOf(n))},S:function(e,n){e.setSeconds(parseFloat(n))},U:function(e,n){return new Date(1e3*parseFloat(n))},W:function(e,n,t){var a=parseInt(n),i=new Date(e.getFullYear(),0,2+7*(a-1),0,0,0,0);return i.setDate(i.getDate()-i.getDay()+t.firstDayOfWeek),i},Y:function(e,n){e.setFullYear(parseFloat(n))},Z:function(e,n){return new Date(n)},d:function(e,n){e.setDate(parseFloat(n))},h:function(e,n){e.setHours(parseFloat(n))},i:function(e,n){e.setMinutes(parseFloat(n))},j:function(e,n){e.setDate(parseFloat(n))},l:p,m:function(e,n){e.setMonth(parseFloat(n)-1)},n:function(e,n){e.setMonth(parseFloat(n)-1)},s:function(e,n){e.setSeconds(parseFloat(n))},u:function(e,n){return new Date(parseFloat(n))},w:p,y:function(e,n){e.setFullYear(2e3+parseFloat(n))}},D={D:"(\\w+)",F:"(\\w+)",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"(\\w+)",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"(\\w+)",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},w={Z:function(e){return e.toISOString()},D:function(e,n,t){return n.weekdays.shorthand[w.w(e,n,t)]},F:function(e,n,t){return h(w.n(e,n,t)-1,!1,n)},G:function(e,n,t){return o(w.h(e,n,t))},H:function(e){return o(e.getHours())},J:function(e,n){return void 0!==n.ordinal?e.getDate()+n.ordinal(e.getDate()):e.getDate()},K:function(e,n){return n.amPM[r(e.getHours()>11)]},M:function(e,n){return h(e.getMonth(),!0,n)},S:function(e){return o(e.getSeconds())},U:function(e){return e.getTime()/1e3},W:function(e,n,t){return t.getWeek(e)},Y:function(e){return o(e.getFullYear(),4)},d:function(e){return o(e.getDate())},h:function(e){return e.getHours()%12?e.getHours()%12:12},i:function(e){return o(e.getMinutes())},j:function(e){return e.getDate()},l:function(e,n){return n.weekdays.longhand[e.getDay()]},m:function(e){return o(e.getMonth()+1)},n:function(e){return e.getMonth()+1},s:function(e){return e.getSeconds()},u:function(e){return e.getTime()},w:function(e){return e.getDay()},y:function(e){return String(e.getFullYear()).substring(2)}},b=function(e){var n=e.config,t=void 0===n?a:n,o=e.l10n,r=void 0===o?i:o,l=e.isMobile,c=void 0!==l&&l;return function(e,n,a){var i=a||r;return void 0===t.formatDate||c?n.split("").map((function(n,a,o){return w[n]&&"\\"!==o[a-1]?w[n](e,i,t):"\\"!==n?n:""})).join(""):t.formatDate(e,n,i)}},C=function(e){var n=e.config,t=void 0===n?a:n,o=e.l10n,r=void 0===o?i:o;return function(e,n,i,o){if(0===e||e){var l,c=o||r,d=e;if(e instanceof Date)l=new Date(e.getTime());else if("string"!=typeof e&&void 0!==e.toFixed)l=new Date(e);else if("string"==typeof e){var s=n||(t||a).dateFormat,u=String(e).trim();if("today"===u)l=new Date,i=!0;else if(/Z$/.test(u)||/GMT$/.test(u))l=new Date(e);else if(t&&t.parseDate)l=t.parseDate(e,s);else{l=t&&t.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0);for(var f=void 0,m=[],g=0,p=0,h="";g<s.length;g++){var w=s[g],b="\\"===w,C="\\"===s[g-1]||b;if(D[w]&&!C){h+=D[w];var M=new RegExp(h).exec(e);M&&(f=!0)&&m["Y"!==w?"push":"unshift"]({fn:v[w],val:M[++p]})}else b||(h+=".");m.forEach((function(e){var n=e.fn,t=e.val;return l=n(l,t,c)||l}))}l=f?l:void 0}}if(l instanceof Date&&!isNaN(l.getTime()))return!0===i&&l.setHours(0,0,0,0),l;t.errorHandler(new Error("Invalid date provided: "+d))}}};function M(e,n,t){return void 0===t&&(t=!0),!1!==t?new Date(e.getTime()).setHours(0,0,0,0)-new Date(n.getTime()).setHours(0,0,0,0):e.getTime()-n.getTime()}var y=864e5;function x(p,v){var w={config:e(e({},a),k.defaultConfig),l10n:i};function x(e){return e.bind(w)}function E(){var e=w.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==w.calendarContainer&&(w.calendarContainer.style.visibility="hidden",w.calendarContainer.style.display="block"),void 0!==w.daysContainer){var n=(w.days.offsetWidth+1)*e.showMonths;w.daysContainer.style.width=n+"px",w.calendarContainer.style.width=n+(void 0!==w.weekWrapper?w.weekWrapper.offsetWidth:0)+"px",w.calendarContainer.style.removeProperty("visibility"),w.calendarContainer.style.removeProperty("display")}}))}function T(e){if(0===w.selectedDates.length){var n=void 0!==w.config.minDate?new Date(w.config.minDate.getTime()):new Date,t=_(),a=t.hours,i=t.minutes,l=t.seconds;n.setHours(a,i,l,0),w.setDate(n,!1)}void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();var n="keydown"===e.type,t=g(e),a=t;void 0!==w.amPM&&t===w.amPM&&(w.amPM.textContent=w.l10n.amPM[r(w.amPM.textContent===w.l10n.amPM[0])]);var i=parseFloat(a.getAttribute("min")),l=parseFloat(a.getAttribute("max")),c=parseFloat(a.getAttribute("step")),d=parseInt(a.value,10),s=e.delta||(n?38===e.which?1:-1:0),u=d+c*s;if(void 0!==a.value&&2===a.value.length){var f=a===w.hourElement,m=a===w.minuteElement;u<i?(u=l+u+r(!f)+(r(f)&&r(!w.amPM)),m&&H(void 0,-1,w.hourElement)):u>l&&(u=a===w.hourElement?u-l-r(!w.amPM):i,m&&H(void 0,1,w.hourElement)),w.amPM&&f&&(1===c?u+d===23:Math.abs(u-d)>c)&&(w.amPM.textContent=w.l10n.amPM[r(w.amPM.textContent===w.l10n.amPM[0])]),a.value=o(u)}}(e);var c=w._input.value;I(),be(),w._input.value!==c&&w._debouncedChange()}function I(){if(void 0!==w.hourElement&&void 0!==w.minuteElement){var e,n,t=(parseInt(w.hourElement.value.slice(-2),10)||0)%24,a=(parseInt(w.minuteElement.value,10)||0)%60,i=void 0!==w.secondElement?(parseInt(w.secondElement.value,10)||0)%60:0;void 0!==w.amPM&&(e=t,n=w.amPM.textContent,t=e%12+12*r(n===w.l10n.amPM[1]));var o=void 0!==w.config.minTime||w.config.minDate&&w.minDateHasTime&&w.latestSelectedDateObj&&0===M(w.latestSelectedDateObj,w.config.minDate,!0);if(void 0!==w.config.maxTime||w.config.maxDate&&w.maxDateHasTime&&w.latestSelectedDateObj&&0===M(w.latestSelectedDateObj,w.config.maxDate,!0)){var l=void 0!==w.config.maxTime?w.config.maxTime:w.config.maxDate;(t=Math.min(t,l.getHours()))===l.getHours()&&(a=Math.min(a,l.getMinutes())),a===l.getMinutes()&&(i=Math.min(i,l.getSeconds()))}if(o){var c=void 0!==w.config.minTime?w.config.minTime:w.config.minDate;(t=Math.max(t,c.getHours()))===c.getHours()&&(a=Math.max(a,c.getMinutes())),a===c.getMinutes()&&(i=Math.max(i,c.getSeconds()))}O(t,a,i)}}function S(e){var n=e||w.latestSelectedDateObj;n&&O(n.getHours(),n.getMinutes(),n.getSeconds())}function _(){var e=w.config.defaultHour,n=w.config.defaultMinute,t=w.config.defaultSeconds;if(void 0!==w.config.minDate){var a=w.config.minDate.getHours(),i=w.config.minDate.getMinutes();(e=Math.max(e,a))===a&&(n=Math.max(i,n)),e===a&&n===i&&(t=w.config.minDate.getSeconds())}if(void 0!==w.config.maxDate){var o=w.config.maxDate.getHours(),r=w.config.maxDate.getMinutes();(e=Math.min(e,o))===o&&(n=Math.min(r,n)),e===o&&n===r&&(t=w.config.maxDate.getSeconds())}return{hours:e,minutes:n,seconds:t}}function O(e,n,t){void 0!==w.latestSelectedDateObj&&w.latestSelectedDateObj.setHours(e%24,n,t||0,0),w.hourElement&&w.minuteElement&&!w.isMobile&&(w.hourElement.value=o(w.config.time_24hr?e:(12+e)%12+12*r(e%12==0)),w.minuteElement.value=o(n),void 0!==w.amPM&&(w.amPM.textContent=w.l10n.amPM[r(e>=12)]),void 0!==w.secondElement&&(w.secondElement.value=o(t)))}function F(e){var n=g(e),t=parseInt(n.value)+(e.delta||0);(t/1e3>1||"Enter"===e.key&&!/[^\d]/.test(t.toString()))&&Q(t)}function N(e,n,t,a){return n instanceof Array?n.forEach((function(n){return N(e,n,t,a)})):e instanceof Array?e.forEach((function(e){return N(e,n,t,a)})):(e.addEventListener(n,t,a),void w._handlers.push({element:e,event:n,handler:t,options:a}))}function A(){pe("onChange")}function P(e,n){var t=void 0!==e?w.parseDate(e):w.latestSelectedDateObj||(w.config.minDate&&w.config.minDate>w.now?w.config.minDate:w.config.maxDate&&w.config.maxDate<w.now?w.config.maxDate:w.now),a=w.currentYear,i=w.currentMonth;try{void 0!==t&&(w.currentYear=t.getFullYear(),w.currentMonth=t.getMonth())}catch(e){e.message="Invalid date supplied: "+t,w.config.errorHandler(e)}n&&w.currentYear!==a&&(pe("onYearChange"),K()),!n||w.currentYear===a&&w.currentMonth===i||pe("onMonthChange"),w.redraw()}function Y(e){var n=g(e);~n.className.indexOf("arrow")&&H(e,n.classList.contains("arrowUp")?1:-1)}function H(e,n,t){var a=e&&g(e),i=t||a&&a.parentNode&&a.parentNode.firstChild,o=he("increment");o.delta=n,i&&i.dispatchEvent(o)}function j(e,n,t,a){var i=X(n,!0),o=s("span","flatpickr-day "+e,n.getDate().toString());return o.dateObj=n,o.$i=a,o.setAttribute("aria-label",w.formatDate(n,w.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===M(n,w.now)&&(w.todayDateElem=o,o.classList.add("today"),o.setAttribute("aria-current","date")),i?(o.tabIndex=-1,ve(n)&&(o.classList.add("selected"),w.selectedDateElem=o,"range"===w.config.mode&&(d(o,"startRange",w.selectedDates[0]&&0===M(n,w.selectedDates[0],!0)),d(o,"endRange",w.selectedDates[1]&&0===M(n,w.selectedDates[1],!0)),"nextMonthDay"===e&&o.classList.add("inRange")))):o.classList.add("flatpickr-disabled"),"range"===w.config.mode&&function(e){return!("range"!==w.config.mode||w.selectedDates.length<2)&&M(e,w.selectedDates[0])>=0&&M(e,w.selectedDates[1])<=0}(n)&&!ve(n)&&o.classList.add("inRange"),w.weekNumbers&&1===w.config.showMonths&&"prevMonthDay"!==e&&t%7==1&&w.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+w.config.getWeek(n)+"</span>"),pe("onDayCreate",o),o}function L(e){e.focus(),"range"===w.config.mode&&ae(e)}function W(e){for(var n=e>0?0:w.config.showMonths-1,t=e>0?w.config.showMonths:-1,a=n;a!=t;a+=e)for(var i=w.daysContainer.children[a],o=e>0?0:i.children.length-1,r=e>0?i.children.length:-1,l=o;l!=r;l+=e){var c=i.children[l];if(-1===c.className.indexOf("hidden")&&X(c.dateObj))return c}}function R(e,n){var t=ee(document.activeElement||document.body),a=void 0!==e?e:t?document.activeElement:void 0!==w.selectedDateElem&&ee(w.selectedDateElem)?w.selectedDateElem:void 0!==w.todayDateElem&&ee(w.todayDateElem)?w.todayDateElem:W(n>0?1:-1);void 0===a?w._input.focus():t?function(e,n){for(var t=-1===e.className.indexOf("Month")?e.dateObj.getMonth():w.currentMonth,a=n>0?w.config.showMonths:-1,i=n>0?1:-1,o=t-w.currentMonth;o!=a;o+=i)for(var r=w.daysContainer.children[o],l=t-w.currentMonth===o?e.$i+n:n<0?r.children.length-1:0,c=r.children.length,d=l;d>=0&&d<c&&d!=(n>0?c:-1);d+=i){var s=r.children[d];if(-1===s.className.indexOf("hidden")&&X(s.dateObj)&&Math.abs(e.$i-d)>=Math.abs(n))return L(s)}w.changeMonth(i),R(W(i),0)}(a,n):L(a)}function B(e,n){for(var t=(new Date(e,n,1).getDay()-w.l10n.firstDayOfWeek+7)%7,a=w.utils.getDaysInMonth((n-1+12)%12,e),i=w.utils.getDaysInMonth(n,e),o=window.document.createDocumentFragment(),r=w.config.showMonths>1,l=r?"prevMonthDay hidden":"prevMonthDay",c=r?"nextMonthDay hidden":"nextMonthDay",d=a+1-t,u=0;d<=a;d++,u++)o.appendChild(j(l,new Date(e,n-1,d),d,u));for(d=1;d<=i;d++,u++)o.appendChild(j("",new Date(e,n,d),d,u));for(var f=i+1;f<=42-t&&(1===w.config.showMonths||u%7!=0);f++,u++)o.appendChild(j(c,new Date(e,n+1,f%i),f,u));var m=s("div","dayContainer");return m.appendChild(o),m}function J(){if(void 0!==w.daysContainer){u(w.daysContainer),w.weekNumbers&&u(w.weekNumbers);for(var e=document.createDocumentFragment(),n=0;n<w.config.showMonths;n++){var t=new Date(w.currentYear,w.currentMonth,1);t.setMonth(w.currentMonth+n),e.appendChild(B(t.getFullYear(),t.getMonth()))}w.daysContainer.appendChild(e),w.days=w.daysContainer.firstChild,"range"===w.config.mode&&1===w.selectedDates.length&&ae()}}function K(){if(!(w.config.showMonths>1||"dropdown"!==w.config.monthSelectorType)){var e=function(e){return!(void 0!==w.config.minDate&&w.currentYear===w.config.minDate.getFullYear()&&e<w.config.minDate.getMonth()||void 0!==w.config.maxDate&&w.currentYear===w.config.maxDate.getFullYear()&&e>w.config.maxDate.getMonth())};w.monthsDropdownContainer.tabIndex=-1,w.monthsDropdownContainer.innerHTML="";for(var n=0;n<12;n++)if(e(n)){var t=s("option","flatpickr-monthDropdown-month");t.value=new Date(w.currentYear,n).getMonth().toString(),t.textContent=h(n,w.config.shorthandCurrentMonth,w.l10n),t.tabIndex=-1,w.currentMonth===n&&(t.selected=!0),w.monthsDropdownContainer.appendChild(t)}}}function U(){var e,n=s("div","flatpickr-month"),t=window.document.createDocumentFragment();w.config.showMonths>1||"static"===w.config.monthSelectorType?e=s("span","cur-month"):(w.monthsDropdownContainer=s("select","flatpickr-monthDropdown-months"),w.monthsDropdownContainer.setAttribute("aria-label",w.l10n.monthAriaLabel),N(w.monthsDropdownContainer,"change",(function(e){var n=g(e),t=parseInt(n.value,10);w.changeMonth(t-w.currentMonth),pe("onMonthChange")})),K(),e=w.monthsDropdownContainer);var a=m("cur-year",{tabindex:"-1"}),i=a.getElementsByTagName("input")[0];i.setAttribute("aria-label",w.l10n.yearAriaLabel),w.config.minDate&&i.setAttribute("min",w.config.minDate.getFullYear().toString()),w.config.maxDate&&(i.setAttribute("max",w.config.maxDate.getFullYear().toString()),i.disabled=!!w.config.minDate&&w.config.minDate.getFullYear()===w.config.maxDate.getFullYear());var o=s("div","flatpickr-current-month");return o.appendChild(e),o.appendChild(a),t.appendChild(o),n.appendChild(t),{container:n,yearElement:i,monthElement:e}}function q(){u(w.monthNav),w.monthNav.appendChild(w.prevMonthNav),w.config.showMonths&&(w.yearElements=[],w.monthElements=[]);for(var e=w.config.showMonths;e--;){var n=U();w.yearElements.push(n.yearElement),w.monthElements.push(n.monthElement),w.monthNav.appendChild(n.container)}w.monthNav.appendChild(w.nextMonthNav)}function $(){w.weekdayContainer?u(w.weekdayContainer):w.weekdayContainer=s("div","flatpickr-weekdays");for(var e=w.config.showMonths;e--;){var n=s("div","flatpickr-weekdaycontainer");w.weekdayContainer.appendChild(n)}return z(),w.weekdayContainer}function z(){if(w.weekdayContainer){var e=w.l10n.firstDayOfWeek,t=n(w.l10n.weekdays.shorthand);e>0&&e<t.length&&(t=n(t.splice(e,t.length),t.splice(0,e)));for(var a=w.config.showMonths;a--;)w.weekdayContainer.children[a].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+t.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function G(e,n){void 0===n&&(n=!0);var t=n?e:e-w.currentMonth;t<0&&!0===w._hidePrevMonthArrow||t>0&&!0===w._hideNextMonthArrow||(w.currentMonth+=t,(w.currentMonth<0||w.currentMonth>11)&&(w.currentYear+=w.currentMonth>11?1:-1,w.currentMonth=(w.currentMonth+12)%12,pe("onYearChange"),K()),J(),pe("onMonthChange"),De())}function V(e){return!(!w.config.appendTo||!w.config.appendTo.contains(e))||w.calendarContainer.contains(e)}function Z(e){if(w.isOpen&&!w.config.inline){var n=g(e),t=V(n),a=n===w.input||n===w.altInput||w.element.contains(n)||e.path&&e.path.indexOf&&(~e.path.indexOf(w.input)||~e.path.indexOf(w.altInput)),i="blur"===e.type?a&&e.relatedTarget&&!V(e.relatedTarget):!a&&!t&&!V(e.relatedTarget),o=!w.config.ignoredFocusElements.some((function(e){return e.contains(n)}));i&&o&&(void 0!==w.timeContainer&&void 0!==w.minuteElement&&void 0!==w.hourElement&&""!==w.input.value&&void 0!==w.input.value&&T(),w.close(),w.config&&"range"===w.config.mode&&1===w.selectedDates.length&&(w.clear(!1),w.redraw()))}}function Q(e){if(!(!e||w.config.minDate&&e<w.config.minDate.getFullYear()||w.config.maxDate&&e>w.config.maxDate.getFullYear())){var n=e,t=w.currentYear!==n;w.currentYear=n||w.currentYear,w.config.maxDate&&w.currentYear===w.config.maxDate.getFullYear()?w.currentMonth=Math.min(w.config.maxDate.getMonth(),w.currentMonth):w.config.minDate&&w.currentYear===w.config.minDate.getFullYear()&&(w.currentMonth=Math.max(w.config.minDate.getMonth(),w.currentMonth)),t&&(w.redraw(),pe("onYearChange"),K())}}function X(e,n){void 0===n&&(n=!0);var t=w.parseDate(e,void 0,n);if(w.config.minDate&&t&&M(t,w.config.minDate,void 0!==n?n:!w.minDateHasTime)<0||w.config.maxDate&&t&&M(t,w.config.maxDate,void 0!==n?n:!w.maxDateHasTime)>0)return!1;if(0===w.config.enable.length&&0===w.config.disable.length)return!0;if(void 0===t)return!1;for(var a=w.config.enable.length>0,i=a?w.config.enable:w.config.disable,o=0,r=void 0;o<i.length;o++){if("function"==typeof(r=i[o])&&r(t))return a;if(r instanceof Date&&void 0!==t&&r.getTime()===t.getTime())return a;if("string"==typeof r&&void 0!==t){var l=w.parseDate(r,void 0,!0);return l&&l.getTime()===t.getTime()?a:!a}if("object"==typeof r&&void 0!==t&&r.from&&r.to&&t.getTime()>=r.from.getTime()&&t.getTime()<=r.to.getTime())return a}return!a}function ee(e){return void 0!==w.daysContainer&&-1===e.className.indexOf("hidden")&&-1===e.className.indexOf("flatpickr-disabled")&&w.daysContainer.contains(e)}function ne(e){e.target!==w._input||e.relatedTarget&&V(e.relatedTarget)||w.setDate(w._input.value,!0,e.target===w.altInput?w.config.altFormat:w.config.dateFormat)}function te(e){var n=g(e),t=w.config.wrap?p.contains(n):n===w._input,a=w.config.allowInput,i=w.isOpen&&(!a||!t),o=w.config.inline&&t&&!a;if(13===e.keyCode&&t){if(a)return w.setDate(w._input.value,!0,n===w.altInput?w.config.altFormat:w.config.dateFormat),n.blur();w.open()}else if(V(n)||i||o){var r=!!w.timeContainer&&w.timeContainer.contains(n);switch(e.keyCode){case 13:r?(e.preventDefault(),T(),se()):ue(e);break;case 27:e.preventDefault(),se();break;case 8:case 46:t&&!w.config.allowInput&&(e.preventDefault(),w.clear());break;case 37:case 39:if(r||t)w.hourElement&&w.hourElement.focus();else if(e.preventDefault(),void 0!==w.daysContainer&&(!1===a||document.activeElement&&ee(document.activeElement))){var l=39===e.keyCode?1:-1;e.ctrlKey?(e.stopPropagation(),G(l),R(W(1),0)):R(void 0,l)}break;case 38:case 40:e.preventDefault();var c=40===e.keyCode?1:-1;w.daysContainer&&void 0!==n.$i||n===w.input||n===w.altInput?e.ctrlKey?(e.stopPropagation(),Q(w.currentYear-c),R(W(1),0)):r||R(void 0,7*c):n===w.currentYearElement?Q(w.currentYear-c):w.config.enableTime&&(!r&&w.hourElement&&w.hourElement.focus(),T(e),w._debouncedChange());break;case 9:if(r){var d=[w.hourElement,w.minuteElement,w.secondElement,w.amPM].concat(w.pluginElements).filter((function(e){return e})),s=d.indexOf(n);if(-1!==s){var u=d[s+(e.shiftKey?-1:1)];e.preventDefault(),(u||w._input).focus()}}else!w.config.noCalendar&&w.daysContainer&&w.daysContainer.contains(n)&&e.shiftKey&&(e.preventDefault(),w._input.focus())}}if(void 0!==w.amPM&&n===w.amPM)switch(e.key){case w.l10n.amPM[0].charAt(0):case w.l10n.amPM[0].charAt(0).toLowerCase():w.amPM.textContent=w.l10n.amPM[0],I(),be();break;case w.l10n.amPM[1].charAt(0):case w.l10n.amPM[1].charAt(0).toLowerCase():w.amPM.textContent=w.l10n.amPM[1],I(),be()}(t||V(n))&&pe("onKeyDown",e)}function ae(e){if(1===w.selectedDates.length&&(!e||e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled"))){for(var n=e?e.dateObj.getTime():w.days.firstElementChild.dateObj.getTime(),t=w.parseDate(w.selectedDates[0],void 0,!0).getTime(),a=Math.min(n,w.selectedDates[0].getTime()),i=Math.max(n,w.selectedDates[0].getTime()),o=!1,r=0,l=0,c=a;c<i;c+=y)X(new Date(c),!0)||(o=o||c>a&&c<i,c<t&&(!r||c>r)?r=c:c>t&&(!l||c<l)&&(l=c));for(var d=0;d<w.config.showMonths;d++)for(var s=w.daysContainer.children[d],u=function(a,i){var c,d,u,f=s.children[a],m=f.dateObj.getTime(),g=r>0&&m<r||l>0&&m>l;return g?(f.classList.add("notAllowed"),["inRange","startRange","endRange"].forEach((function(e){f.classList.remove(e)})),"continue"):o&&!g?"continue":(["startRange","inRange","endRange","notAllowed"].forEach((function(e){f.classList.remove(e)})),void(void 0!==e&&(e.classList.add(n<=w.selectedDates[0].getTime()?"startRange":"endRange"),t<n&&m===t?f.classList.add("startRange"):t>n&&m===t&&f.classList.add("endRange"),m>=r&&(0===l||m<=l)&&(d=t,u=n,(c=m)>Math.min(d,u)&&c<Math.max(d,u))&&f.classList.add("inRange"))))},f=0,m=s.children.length;f<m;f++)u(f)}}function ie(){!w.isOpen||w.config.static||w.config.inline||ce()}function oe(e){return function(n){var t=w.config["_"+e+"Date"]=w.parseDate(n,w.config.dateFormat),a=w.config["_"+("min"===e?"max":"min")+"Date"];void 0!==t&&(w["min"===e?"minDateHasTime":"maxDateHasTime"]=t.getHours()>0||t.getMinutes()>0||t.getSeconds()>0),w.selectedDates&&(w.selectedDates=w.selectedDates.filter((function(e){return X(e)})),w.selectedDates.length||"min"!==e||S(t),be()),w.daysContainer&&(de(),void 0!==t?w.currentYearElement[e]=t.getFullYear().toString():w.currentYearElement.removeAttribute(e),w.currentYearElement.disabled=!!a&&void 0!==t&&a.getFullYear()===t.getFullYear())}}function re(){return w.config.wrap?p.querySelector("[data-input]"):p}function le(){"object"!=typeof w.config.locale&&void 0===k.l10ns[w.config.locale]&&w.config.errorHandler(new Error("flatpickr: invalid locale "+w.config.locale)),w.l10n=e(e({},k.l10ns.default),"object"==typeof w.config.locale?w.config.locale:"default"!==w.config.locale?k.l10ns[w.config.locale]:void 0),D.K="("+w.l10n.amPM[0]+"|"+w.l10n.amPM[1]+"|"+w.l10n.amPM[0].toLowerCase()+"|"+w.l10n.amPM[1].toLowerCase()+")",void 0===e(e({},v),JSON.parse(JSON.stringify(p.dataset||{}))).time_24hr&&void 0===k.defaultConfig.time_24hr&&(w.config.time_24hr=w.l10n.time_24hr),w.formatDate=b(w),w.parseDate=C({config:w.config,l10n:w.l10n})}function ce(e){if(void 0!==w.calendarContainer){pe("onPreCalendarPosition");var n=e||w._positionElement,t=Array.prototype.reduce.call(w.calendarContainer.children,(function(e,n){return e+n.offsetHeight}),0),a=w.calendarContainer.offsetWidth,i=w.config.position.split(" "),o=i[0],r=i.length>1?i[1]:null,l=n.getBoundingClientRect(),c=window.innerHeight-l.bottom,s="above"===o||"below"!==o&&c<t&&l.top>t,u=window.pageYOffset+l.top+(s?-t-2:n.offsetHeight+2);if(d(w.calendarContainer,"arrowTop",!s),d(w.calendarContainer,"arrowBottom",s),!w.config.inline){var f=window.pageXOffset+l.left,m=!1,g=!1;"center"===r?(f-=(a-l.width)/2,m=!0):"right"===r&&(f-=a-l.width,g=!0),d(w.calendarContainer,"arrowLeft",!m&&!g),d(w.calendarContainer,"arrowCenter",m),d(w.calendarContainer,"arrowRight",g);var p=window.document.body.offsetWidth-(window.pageXOffset+l.right),h=f+a>window.document.body.offsetWidth,v=p+a>window.document.body.offsetWidth;if(d(w.calendarContainer,"rightMost",h),!w.config.static)if(w.calendarContainer.style.top=u+"px",h)if(v){var D=function(){for(var e=null,n=0;n<document.styleSheets.length;n++){var t=document.styleSheets[n];try{t.cssRules}catch(e){continue}e=t;break}return null!=e?e:(a=document.createElement("style"),document.head.appendChild(a),a.sheet);var a}();if(void 0===D)return;var b=window.document.body.offsetWidth,C=Math.max(0,b/2-a/2),M=D.cssRules.length,y="{left:"+l.left+"px;right:auto;}";d(w.calendarContainer,"rightMost",!1),d(w.calendarContainer,"centerMost",!0),D.insertRule(".flatpickr-calendar.centerMost:before,.flatpickr-calendar.centerMost:after"+y,M),w.calendarContainer.style.left=C+"px",w.calendarContainer.style.right="auto"}else w.calendarContainer.style.left="auto",w.calendarContainer.style.right=p+"px";else w.calendarContainer.style.left=f+"px",w.calendarContainer.style.right="auto"}}}function de(){w.config.noCalendar||w.isMobile||(K(),De(),J())}function se(){w._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(w.close,0):w.close()}function ue(e){e.preventDefault(),e.stopPropagation();var n=f(g(e),(function(e){return e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")}));if(void 0!==n){var t=n,a=w.latestSelectedDateObj=new Date(t.dateObj.getTime()),i=(a.getMonth()<w.currentMonth||a.getMonth()>w.currentMonth+w.config.showMonths-1)&&"range"!==w.config.mode;if(w.selectedDateElem=t,"single"===w.config.mode)w.selectedDates=[a];else if("multiple"===w.config.mode){var o=ve(a);o?w.selectedDates.splice(parseInt(o),1):w.selectedDates.push(a)}else"range"===w.config.mode&&(2===w.selectedDates.length&&w.clear(!1,!1),w.latestSelectedDateObj=a,w.selectedDates.push(a),0!==M(a,w.selectedDates[0],!0)&&w.selectedDates.sort((function(e,n){return e.getTime()-n.getTime()})));if(I(),i){var r=w.currentYear!==a.getFullYear();w.currentYear=a.getFullYear(),w.currentMonth=a.getMonth(),r&&(pe("onYearChange"),K()),pe("onMonthChange")}if(De(),J(),be(),i||"range"===w.config.mode||1!==w.config.showMonths?void 0!==w.selectedDateElem&&void 0===w.hourElement&&w.selectedDateElem&&w.selectedDateElem.focus():L(t),void 0!==w.hourElement&&void 0!==w.hourElement&&w.hourElement.focus(),w.config.closeOnSelect){var l="single"===w.config.mode&&!w.config.enableTime,c="range"===w.config.mode&&2===w.selectedDates.length&&!w.config.enableTime;(l||c)&&se()}A()}}w.parseDate=C({config:w.config,l10n:w.l10n}),w._handlers=[],w.pluginElements=[],w.loadedPlugins=[],w._bind=N,w._setHoursFromDate=S,w._positionCalendar=ce,w.changeMonth=G,w.changeYear=Q,w.clear=function(e,n){if(void 0===e&&(e=!0),void 0===n&&(n=!0),w.input.value="",void 0!==w.altInput&&(w.altInput.value=""),void 0!==w.mobileInput&&(w.mobileInput.value=""),w.selectedDates=[],w.latestSelectedDateObj=void 0,!0===n&&(w.currentYear=w._initialDate.getFullYear(),w.currentMonth=w._initialDate.getMonth()),!0===w.config.enableTime){var t=_(),a=t.hours,i=t.minutes,o=t.seconds;O(a,i,o)}w.redraw(),e&&pe("onChange")},w.close=function(){w.isOpen=!1,w.isMobile||(void 0!==w.calendarContainer&&w.calendarContainer.classList.remove("open"),void 0!==w._input&&w._input.classList.remove("active")),pe("onClose")},w._createElement=s,w.destroy=function(){void 0!==w.config&&pe("onDestroy");for(var e=w._handlers.length;e--;){var n=w._handlers[e];n.element.removeEventListener(n.event,n.handler,n.options)}if(w._handlers=[],w.mobileInput)w.mobileInput.parentNode&&w.mobileInput.parentNode.removeChild(w.mobileInput),w.mobileInput=void 0;else if(w.calendarContainer&&w.calendarContainer.parentNode)if(w.config.static&&w.calendarContainer.parentNode){var t=w.calendarContainer.parentNode;if(t.lastChild&&t.removeChild(t.lastChild),t.parentNode){for(;t.firstChild;)t.parentNode.insertBefore(t.firstChild,t);t.parentNode.removeChild(t)}}else w.calendarContainer.parentNode.removeChild(w.calendarContainer);w.altInput&&(w.input.type="text",w.altInput.parentNode&&w.altInput.parentNode.removeChild(w.altInput),delete w.altInput),w.input&&(w.input.type=w.input._type,w.input.classList.remove("flatpickr-input"),w.input.removeAttribute("readonly")),["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((function(e){try{delete w[e]}catch(e){}}))},w.isEnabled=X,w.jumpToDate=P,w.open=function(e,n){if(void 0===n&&(n=w._positionElement),!0===w.isMobile){if(e){e.preventDefault();var t=g(e);t&&t.blur()}return void 0!==w.mobileInput&&(w.mobileInput.focus(),w.mobileInput.click()),void pe("onOpen")}if(!w._input.disabled&&!w.config.inline){var a=w.isOpen;w.isOpen=!0,a||(w.calendarContainer.classList.add("open"),w._input.classList.add("active"),pe("onOpen"),ce(n)),!0===w.config.enableTime&&!0===w.config.noCalendar&&(!1!==w.config.allowInput||void 0!==e&&w.timeContainer.contains(e.relatedTarget)||setTimeout((function(){return w.hourElement.select()}),50))}},w.redraw=de,w.set=function(e,n){if(null!==e&&"object"==typeof e)for(var a in Object.assign(w.config,e),e)void 0!==fe[a]&&fe[a].forEach((function(e){return e()}));else w.config[e]=n,void 0!==fe[e]?fe[e].forEach((function(e){return e()})):t.indexOf(e)>-1&&(w.config[e]=c(n));w.redraw(),be(!0)},w.setDate=function(e,n,t){if(void 0===n&&(n=!1),void 0===t&&(t=w.config.dateFormat),0!==e&&!e||e instanceof Array&&0===e.length)return w.clear(n);me(e,t),w.latestSelectedDateObj=w.selectedDates[w.selectedDates.length-1],w.redraw(),P(void 0,n),S(),0===w.selectedDates.length&&w.clear(!1),be(n),n&&pe("onChange")},w.toggle=function(e){if(!0===w.isOpen)return w.close();w.open(e)};var fe={locale:[le,z],showMonths:[q,E,$],minDate:[P],maxDate:[P]};function me(e,n){var t=[];if(e instanceof Array)t=e.map((function(e){return w.parseDate(e,n)}));else if(e instanceof Date||"number"==typeof e)t=[w.parseDate(e,n)];else if("string"==typeof e)switch(w.config.mode){case"single":case"time":t=[w.parseDate(e,n)];break;case"multiple":t=e.split(w.config.conjunction).map((function(e){return w.parseDate(e,n)}));break;case"range":t=e.split(w.l10n.rangeSeparator).map((function(e){return w.parseDate(e,n)}))}else w.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(e)));w.selectedDates=w.config.allowInvalidPreload?t:t.filter((function(e){return e instanceof Date&&X(e,!1)})),"range"===w.config.mode&&w.selectedDates.sort((function(e,n){return e.getTime()-n.getTime()}))}function ge(e){return e.slice().map((function(e){return"string"==typeof e||"number"==typeof e||e instanceof Date?w.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:w.parseDate(e.from,void 0),to:w.parseDate(e.to,void 0)}:e})).filter((function(e){return e}))}function pe(e,n){if(void 0!==w.config){var t=w.config[e];if(void 0!==t&&t.length>0)for(var a=0;t[a]&&a<t.length;a++)t[a](w.selectedDates,w.input.value,w,n);"onChange"===e&&(w.input.dispatchEvent(he("change")),w.input.dispatchEvent(he("input")))}}function he(e){var n=document.createEvent("Event");return n.initEvent(e,!0,!0),n}function ve(e){for(var n=0;n<w.selectedDates.length;n++)if(0===M(w.selectedDates[n],e))return""+n;return!1}function De(){w.config.noCalendar||w.isMobile||!w.monthNav||(w.yearElements.forEach((function(e,n){var t=new Date(w.currentYear,w.currentMonth,1);t.setMonth(w.currentMonth+n),w.config.showMonths>1||"static"===w.config.monthSelectorType?w.monthElements[n].textContent=h(t.getMonth(),w.config.shorthandCurrentMonth,w.l10n)+" ":w.monthsDropdownContainer.value=t.getMonth().toString(),e.value=t.getFullYear().toString()})),w._hidePrevMonthArrow=void 0!==w.config.minDate&&(w.currentYear===w.config.minDate.getFullYear()?w.currentMonth<=w.config.minDate.getMonth():w.currentYear<w.config.minDate.getFullYear()),w._hideNextMonthArrow=void 0!==w.config.maxDate&&(w.currentYear===w.config.maxDate.getFullYear()?w.currentMonth+1>w.config.maxDate.getMonth():w.currentYear>w.config.maxDate.getFullYear()))}function we(e){return w.selectedDates.map((function(n){return w.formatDate(n,e)})).filter((function(e,n,t){return"range"!==w.config.mode||w.config.enableTime||t.indexOf(e)===n})).join("range"!==w.config.mode?w.config.conjunction:w.l10n.rangeSeparator)}function be(e){void 0===e&&(e=!0),void 0!==w.mobileInput&&w.mobileFormatStr&&(w.mobileInput.value=void 0!==w.latestSelectedDateObj?w.formatDate(w.latestSelectedDateObj,w.mobileFormatStr):""),w.input.value=we(w.config.dateFormat),void 0!==w.altInput&&(w.altInput.value=we(w.config.altFormat)),!1!==e&&pe("onValueUpdate")}function Ce(e){var n=g(e),t=w.prevMonthNav.contains(n),a=w.nextMonthNav.contains(n);t||a?G(t?-1:1):w.yearElements.indexOf(n)>=0?n.select():n.classList.contains("arrowUp")?w.changeYear(w.currentYear+1):n.classList.contains("arrowDown")&&w.changeYear(w.currentYear-1)}return function(){w.element=w.input=p,w.isOpen=!1,function(){var n=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],i=e(e({},JSON.parse(JSON.stringify(p.dataset||{}))),v),o={};w.config.parseDate=i.parseDate,w.config.formatDate=i.formatDate,Object.defineProperty(w.config,"enable",{get:function(){return w.config._enable},set:function(e){w.config._enable=ge(e)}}),Object.defineProperty(w.config,"disable",{get:function(){return w.config._disable},set:function(e){w.config._disable=ge(e)}});var r="time"===i.mode;if(!i.dateFormat&&(i.enableTime||r)){var l=k.defaultConfig.dateFormat||a.dateFormat;o.dateFormat=i.noCalendar||r?"H:i"+(i.enableSeconds?":S":""):l+" H:i"+(i.enableSeconds?":S":"")}if(i.altInput&&(i.enableTime||r)&&!i.altFormat){var d=k.defaultConfig.altFormat||a.altFormat;o.altFormat=i.noCalendar||r?"h:i"+(i.enableSeconds?":S K":" K"):d+" h:i"+(i.enableSeconds?":S":"")+" K"}Object.defineProperty(w.config,"minDate",{get:function(){return w.config._minDate},set:oe("min")}),Object.defineProperty(w.config,"maxDate",{get:function(){return w.config._maxDate},set:oe("max")});var s=function(e){return function(n){w.config["min"===e?"_minTime":"_maxTime"]=w.parseDate(n,"H:i:S")}};Object.defineProperty(w.config,"minTime",{get:function(){return w.config._minTime},set:s("min")}),Object.defineProperty(w.config,"maxTime",{get:function(){return w.config._maxTime},set:s("max")}),"time"===i.mode&&(w.config.noCalendar=!0,w.config.enableTime=!0),Object.assign(w.config,o,i);for(var u=0;u<n.length;u++)w.config[n[u]]=!0===w.config[n[u]]||"true"===w.config[n[u]];for(t.filter((function(e){return void 0!==w.config[e]})).forEach((function(e){w.config[e]=c(w.config[e]||[]).map(x)})),w.isMobile=!w.config.disableMobile&&!w.config.inline&&"single"===w.config.mode&&!w.config.disable.length&&!w.config.enable.length&&!w.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),u=0;u<w.config.plugins.length;u++){var f=w.config.plugins[u](w)||{};for(var m in f)t.indexOf(m)>-1?w.config[m]=c(f[m]).map(x).concat(w.config[m]):void 0===i[m]&&(w.config[m]=f[m])}i.altInputClass||(w.config.altInputClass=re().className+" "+w.config.altInputClass),pe("onParseConfig")}(),le(),w.input=re(),w.input?(w.input._type=w.input.type,w.input.type="text",w.input.classList.add("flatpickr-input"),w._input=w.input,w.config.altInput&&(w.altInput=s(w.input.nodeName,w.config.altInputClass),w._input=w.altInput,w.altInput.placeholder=w.input.placeholder,w.altInput.disabled=w.input.disabled,w.altInput.required=w.input.required,w.altInput.tabIndex=w.input.tabIndex,w.altInput.type="text",w.input.setAttribute("type","hidden"),!w.config.static&&w.input.parentNode&&w.input.parentNode.insertBefore(w.altInput,w.input.nextSibling)),w.config.allowInput||w._input.setAttribute("readonly","readonly"),w._positionElement=w.config.positionElement||w._input):w.config.errorHandler(new Error("Invalid input element specified")),function(){w.selectedDates=[],w.now=w.parseDate(w.config.now)||new Date;var e=w.config.defaultDate||("INPUT"!==w.input.nodeName&&"TEXTAREA"!==w.input.nodeName||!w.input.placeholder||w.input.value!==w.input.placeholder?w.input.value:null);e&&me(e,w.config.dateFormat),w._initialDate=w.selectedDates.length>0?w.selectedDates[0]:w.config.minDate&&w.config.minDate.getTime()>w.now.getTime()?w.config.minDate:w.config.maxDate&&w.config.maxDate.getTime()<w.now.getTime()?w.config.maxDate:w.now,w.currentYear=w._initialDate.getFullYear(),w.currentMonth=w._initialDate.getMonth(),w.selectedDates.length>0&&(w.latestSelectedDateObj=w.selectedDates[0]),void 0!==w.config.minTime&&(w.config.minTime=w.parseDate(w.config.minTime,"H:i")),void 0!==w.config.maxTime&&(w.config.maxTime=w.parseDate(w.config.maxTime,"H:i")),w.minDateHasTime=!!w.config.minDate&&(w.config.minDate.getHours()>0||w.config.minDate.getMinutes()>0||w.config.minDate.getSeconds()>0),w.maxDateHasTime=!!w.config.maxDate&&(w.config.maxDate.getHours()>0||w.config.maxDate.getMinutes()>0||w.config.maxDate.getSeconds()>0)}(),w.utils={getDaysInMonth:function(e,n){return void 0===e&&(e=w.currentMonth),void 0===n&&(n=w.currentYear),1===e&&(n%4==0&&n%100!=0||n%400==0)?29:w.l10n.daysInMonth[e]}},w.isMobile||function(){var e=window.document.createDocumentFragment();if(w.calendarContainer=s("div","flatpickr-calendar"),w.calendarContainer.tabIndex=-1,!w.config.noCalendar){if(e.appendChild((w.monthNav=s("div","flatpickr-months"),w.yearElements=[],w.monthElements=[],w.prevMonthNav=s("span","flatpickr-prev-month"),w.prevMonthNav.innerHTML=w.config.prevArrow,w.nextMonthNav=s("span","flatpickr-next-month"),w.nextMonthNav.innerHTML=w.config.nextArrow,q(),Object.defineProperty(w,"_hidePrevMonthArrow",{get:function(){return w.__hidePrevMonthArrow},set:function(e){w.__hidePrevMonthArrow!==e&&(d(w.prevMonthNav,"flatpickr-disabled",e),w.__hidePrevMonthArrow=e)}}),Object.defineProperty(w,"_hideNextMonthArrow",{get:function(){return w.__hideNextMonthArrow},set:function(e){w.__hideNextMonthArrow!==e&&(d(w.nextMonthNav,"flatpickr-disabled",e),w.__hideNextMonthArrow=e)}}),w.currentYearElement=w.yearElements[0],De(),w.monthNav)),w.innerContainer=s("div","flatpickr-innerContainer"),w.config.weekNumbers){var n=function(){w.calendarContainer.classList.add("hasWeeks");var e=s("div","flatpickr-weekwrapper");e.appendChild(s("span","flatpickr-weekday",w.l10n.weekAbbreviation));var n=s("div","flatpickr-weeks");return e.appendChild(n),{weekWrapper:e,weekNumbers:n}}(),t=n.weekWrapper,a=n.weekNumbers;w.innerContainer.appendChild(t),w.weekNumbers=a,w.weekWrapper=t}w.rContainer=s("div","flatpickr-rContainer"),w.rContainer.appendChild($()),w.daysContainer||(w.daysContainer=s("div","flatpickr-days"),w.daysContainer.tabIndex=-1),J(),w.rContainer.appendChild(w.daysContainer),w.innerContainer.appendChild(w.rContainer),e.appendChild(w.innerContainer)}w.config.enableTime&&e.appendChild(function(){w.calendarContainer.classList.add("hasTime"),w.config.noCalendar&&w.calendarContainer.classList.add("noCalendar"),w.timeContainer=s("div","flatpickr-time"),w.timeContainer.tabIndex=-1;var e=s("span","flatpickr-time-separator",":"),n=m("flatpickr-hour",{"aria-label":w.l10n.hourAriaLabel});w.hourElement=n.getElementsByTagName("input")[0];var t=m("flatpickr-minute",{"aria-label":w.l10n.minuteAriaLabel});if(w.minuteElement=t.getElementsByTagName("input")[0],w.hourElement.tabIndex=w.minuteElement.tabIndex=-1,w.hourElement.value=o(w.latestSelectedDateObj?w.latestSelectedDateObj.getHours():w.config.time_24hr?w.config.defaultHour:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(w.config.defaultHour)),w.minuteElement.value=o(w.latestSelectedDateObj?w.latestSelectedDateObj.getMinutes():w.config.defaultMinute),w.hourElement.setAttribute("step",w.config.hourIncrement.toString()),w.minuteElement.setAttribute("step",w.config.minuteIncrement.toString()),w.hourElement.setAttribute("min",w.config.time_24hr?"0":"1"),w.hourElement.setAttribute("max",w.config.time_24hr?"23":"12"),w.minuteElement.setAttribute("min","0"),w.minuteElement.setAttribute("max","59"),w.timeContainer.appendChild(n),w.timeContainer.appendChild(e),w.timeContainer.appendChild(t),w.config.time_24hr&&w.timeContainer.classList.add("time24hr"),w.config.enableSeconds){w.timeContainer.classList.add("hasSeconds");var a=m("flatpickr-second");w.secondElement=a.getElementsByTagName("input")[0],w.secondElement.value=o(w.latestSelectedDateObj?w.latestSelectedDateObj.getSeconds():w.config.defaultSeconds),w.secondElement.setAttribute("step",w.minuteElement.getAttribute("step")),w.secondElement.setAttribute("min","0"),w.secondElement.setAttribute("max","59"),w.timeContainer.appendChild(s("span","flatpickr-time-separator",":")),w.timeContainer.appendChild(a)}return w.config.time_24hr||(w.amPM=s("span","flatpickr-am-pm",w.l10n.amPM[r((w.latestSelectedDateObj?w.hourElement.value:w.config.defaultHour)>11)]),w.amPM.title=w.l10n.toggleTitle,w.amPM.tabIndex=-1,w.timeContainer.appendChild(w.amPM)),w.timeContainer}()),d(w.calendarContainer,"rangeMode","range"===w.config.mode),d(w.calendarContainer,"animate",!0===w.config.animate),d(w.calendarContainer,"multiMonth",w.config.showMonths>1),w.calendarContainer.appendChild(e);var i=void 0!==w.config.appendTo&&void 0!==w.config.appendTo.nodeType;if((w.config.inline||w.config.static)&&(w.calendarContainer.classList.add(w.config.inline?"inline":"static"),w.config.inline&&(!i&&w.element.parentNode?w.element.parentNode.insertBefore(w.calendarContainer,w._input.nextSibling):void 0!==w.config.appendTo&&w.config.appendTo.appendChild(w.calendarContainer)),w.config.static)){var l=s("div","flatpickr-wrapper");w.element.parentNode&&w.element.parentNode.insertBefore(l,w.element),l.appendChild(w.element),w.altInput&&l.appendChild(w.altInput),l.appendChild(w.calendarContainer)}w.config.static||w.config.inline||(void 0!==w.config.appendTo?w.config.appendTo:window.document.body).appendChild(w.calendarContainer)}(),function(){if(w.config.wrap&&["open","close","toggle","clear"].forEach((function(e){Array.prototype.forEach.call(w.element.querySelectorAll("[data-"+e+"]"),(function(n){return N(n,"click",w[e])}))})),w.isMobile)!function(){var e=w.config.enableTime?w.config.noCalendar?"time":"datetime-local":"date";w.mobileInput=s("input",w.input.className+" flatpickr-mobile"),w.mobileInput.tabIndex=1,w.mobileInput.type=e,w.mobileInput.disabled=w.input.disabled,w.mobileInput.required=w.input.required,w.mobileInput.placeholder=w.input.placeholder,w.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",w.selectedDates.length>0&&(w.mobileInput.defaultValue=w.mobileInput.value=w.formatDate(w.selectedDates[0],w.mobileFormatStr)),w.config.minDate&&(w.mobileInput.min=w.formatDate(w.config.minDate,"Y-m-d")),w.config.maxDate&&(w.mobileInput.max=w.formatDate(w.config.maxDate,"Y-m-d")),w.input.getAttribute("step")&&(w.mobileInput.step=String(w.input.getAttribute("step"))),w.input.type="hidden",void 0!==w.altInput&&(w.altInput.type="hidden");try{w.input.parentNode&&w.input.parentNode.insertBefore(w.mobileInput,w.input.nextSibling)}catch(e){}N(w.mobileInput,"change",(function(e){w.setDate(g(e).value,!1,w.mobileFormatStr),pe("onChange"),pe("onClose")}))}();else{var e=l(ie,50);if(w._debouncedChange=l(A,300),w.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&N(w.daysContainer,"mouseover",(function(e){"range"===w.config.mode&&ae(g(e))})),N(window.document.body,"keydown",te),w.config.inline||w.config.static||N(window,"resize",e),void 0!==window.ontouchstart?N(window.document,"touchstart",Z):N(window.document,"click",Z),N(window.document,"focus",Z,{capture:!0}),!0===w.config.clickOpens&&(N(w._input,"focus",w.open),N(w._input,"click",w.open)),void 0!==w.daysContainer&&(N(w.monthNav,"click",Ce),N(w.monthNav,["keyup","increment"],F),N(w.daysContainer,"click",ue)),void 0!==w.timeContainer&&void 0!==w.minuteElement&&void 0!==w.hourElement){var n=function(e){return g(e).select()};N(w.timeContainer,["increment"],T),N(w.timeContainer,"blur",T,{capture:!0}),N(w.timeContainer,"click",Y),N([w.hourElement,w.minuteElement],["focus","click"],n),void 0!==w.secondElement&&N(w.secondElement,"focus",(function(){return w.secondElement&&w.secondElement.select()})),void 0!==w.amPM&&N(w.amPM,"click",(function(e){T(e),A()}))}w.config.allowInput&&N(w._input,"blur",ne)}}(),(w.selectedDates.length||w.config.noCalendar)&&(w.config.enableTime&&S(w.config.noCalendar?w.latestSelectedDateObj||w.config.minDate:void 0),be(!1)),E();var n=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!w.isMobile&&n&&ce(),pe("onReady")}(),w}function E(e,n){for(var t=Array.prototype.slice.call(e).filter((function(e){return e instanceof HTMLElement})),a=[],i=0;i<t.length;i++){var o=t[i];try{if(null!==o.getAttribute("data-fp-omit"))continue;void 0!==o._flatpickr&&(o._flatpickr.destroy(),o._flatpickr=void 0),o._flatpickr=x(o,n||{}),a.push(o._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"function"!=typeof Object.assign&&(Object.assign=function(e){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];if(!e)throw TypeError("Cannot convert undefined or null to object");for(var a=function(n){n&&Object.keys(n).forEach((function(t){return e[t]=n[t]}))},i=0,o=n;i<o.length;i++){var r=o[i];a(r)}return e}),"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return E(this,e)},HTMLElement.prototype.flatpickr=function(e){return E([this],e)});var k=function(e,n){return"string"==typeof e?E(window.document.querySelectorAll(e),n):e instanceof Node?E([e],n):E(e,n)};return k.defaultConfig={},k.l10ns={en:e({},i),default:e({},i)},k.localize=function(n){k.l10ns.default=e(e({},k.l10ns.default),n)},k.setDefaults=function(n){k.defaultConfig=e(e({},k.defaultConfig),n)},k.parseDate=C({}),k.formatDate=b({}),k.compareDates=M,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return E(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=k),k},"object"==typeof t&&void 0!==n?n.exports=r():"function"==typeof define&&define.amd?define(r):(o=o||self).flatpickr=r()},
"0155f7af4d": function _(e,t,o,i,n){i();const s=e("tslib"),a=e("@bokehjs/core/dom"),c=e("@bokehjs/models/layouts/html_box"),r=e("@bokehjs/models/sources/column_data_source"),d=e("99a25e6992"),l=e("7f7d9e0c6b"),_=e("80a6464b1f"),h=e("6e04fbe567"),p=(0,s.__importDefault)(e("093eb75864"));function u(){const e={},t=window.deck,o=Object.keys(t).filter((e=>e.charAt(0)===e.charAt(0).toUpperCase()));for(const i of o)e[i]=t[i];return e}class w extends _.PanelHTMLBoxView{connect_signals(){super.connect_signals();const{data:e,mapbox_api_key:t,tooltip:o,layers:i,initialViewState:n,data_sources:s}=this.model.properties;this.on_change([t,o],(()=>this.render())),this.on_change([e,n],(()=>this.updateDeck())),this.on_change([i],(()=>this._update_layers())),this.on_change([s],(()=>this._connect_sources(!0))),this._layer_map={},this._connected=[],this._connect_sources()}_update_layers(){this._layer_map={},this._update_data(!0)}_connect_sources(e=!1){for(const e of this.model.data_sources)this._connected.indexOf(e)<0&&(this.connect(e.properties.data.change,(()=>this._update_data(!0))),this._connected.push(e));this._update_data(e)}initialize(){if(super.initialize(),window.deck.JSONConverter){const{CSVLoader:e,Tiles3DLoader:t}=window.loaders;window.loaders.registerLoaders([t,e]);const o={classes:u(),enumerations:{COORDINATE_SYSTEM:window.deck.COORDINATE_SYSTEM,GL:p.default},constants:{Tiles3DLoader:t}};this.jsonConverter=new window.deck.JSONConverter({configuration:o})}}_update_data(e=!0){let t=0;for(const e of this.model.layers){let o;if(t+=1,t-1 in this._layer_map)o=this.model.data_sources[this._layer_map[t-1]];else{if("number"!=typeof e.data)continue;this._layer_map[t-1]=e.data,o=this.model.data_sources[e.data]}e.data=(0,l.transform_cds_to_records)(o)}e&&this.updateDeck()}_on_click_event(e){const t={coordinate:e.coordinate,lngLat:e.coordinate,index:e.index};e.layer&&(t.layer=e.layer.id),this.model.clickState=t}_on_hover_event(e){if(null==e.coordinate)return;const t={coordinate:e.coordinate,lngLat:e.coordinate,index:e.index};e.layer&&(t.layer=e.layer.id),this.model.hoverState=t}_on_viewState_event(e){const t=Object.assign({},e.viewState);delete t.normalize;for(const e in t)e.startsWith("transition")&&delete t[e];const o=new window.deck.WebMercatorViewport(t);t.nw=o.unproject([0,0]),t.se=o.unproject([o.width,o.height]),this.model.viewState=t}getData(){const e=this.model.throttle.view||200,t=this.model.throttle.hover||100,o=(0,d.debounce)((e=>this._on_viewState_event(e)),e,!1),i=(0,d.debounce)((e=>this._on_hover_event(e)),t,!1);return Object.assign(Object.assign({},this.model.data),{layers:this.model.layers,initialViewState:this.model.initialViewState,onViewStateChange:o,onClick:e=>this._on_click_event(e),onHover:i})}updateDeck(){if(!this.deckGL)return void this.render();const e=this.getData();if(window.deck.updateDeck)window.deck.updateDeck(e,this.deckGL);else{const t=this.jsonConverter.convert(e);this.deckGL.setProps(t)}}createDeck({mapboxApiKey:e,container:t,jsonInput:o,tooltip:i}){let n;try{const s=this.jsonConverter.convert(o),a=(0,h.makeTooltip)(i,s.layers);n=new window.deck.DeckGL(Object.assign(Object.assign({},s),{map:window.mapboxgl,mapboxApiAccessToken:e,container:t,getTooltip:a}))}catch(e){console.error(e)}return n}render(){super.render();const e=(0,a.div)({class:"deckgl"});(0,_.set_size)(e,this.model);const t=this.model.mapbox_api_key,o=this.model.tooltip,i=this.getData();window.deck.createDeck?this.deckGL=window.deck.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}):this.deckGL=this.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}),this.el.appendChild(e)}}o.DeckGLPlotView=w,w.__name__="DeckGLPlotView";class k extends c.HTMLBox{constructor(e){super(e)}static init_DeckGLPlot(){this.prototype.default_view=w,this.define((({Any:e,Array:t,String:o,Ref:i})=>({data:[e],data_sources:[t(i(r.ColumnDataSource)),[]],clickState:[e,{}],hoverState:[e,{}],initialViewState:[e,{}],layers:[t(e),[]],mapbox_api_key:[o,""],throttle:[e,{}],tooltip:[e,!0],viewState:[e,{}]}))),this.override({height:400,width:600})}}o.DeckGLPlot=k,k.__name__="DeckGLPlot",k.__module__="panel.models.deckgl",k.init_DeckGLPlot()},
"6e04fbe567": function _(t,e,n,i,l){
/*
    This file was adapted from https://github.com/uber/deck.gl/ the LICENSE
    below is preserved to comply with the original license.
    
    Copyright (c) 2015 - 2017 Uber Technologies, Inc.
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    */
let o,r;i();const c={fontFamily:'"Helvetica Neue", Helvetica, Arial, sans-serif',display:"flex",flex:"wrap",maxWidth:"500px",flexDirection:"column",zIndex:2};function s(){return document.createElement("div")}function a(t){if(!t.picked)return null;if(t.object===o)return r;const e={html:u(t.object),style:c};return r=e,o=t.object,e}n.getTooltipDefault=a;const f=new Set(["position","index"]);function u(t){const e=s();for(const n in t){if(f.has(n))continue;const i=s();i.className="header",i.textContent=n;const l=s();l.className="value",l.textContent=h(t[n]);const o=s();p(o,i,l),o.appendChild(i),o.appendChild(l),e.appendChild(o)}return e.innerHTML}function p(t,e,n){Object.assign(e.style,{fontWeight:700,marginRight:"10px",flex:"1 1 0%"}),Object.assign(n.style,{flex:"none",maxWidth:"250px",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"}),Object.assign(t.style,{display:"flex",flexDirection:"row",justifyContent:"space-between",alignItems:"stretch"})}function h(t){let e;if(Array.isArray(t)&&t.length>4)e=`Array<${t.length}>`;else if("string"==typeof t)e=t;else if("number"==typeof t)e=String(t);else try{e=JSON.stringify(t)}catch(t){e="<Non-Serializable Object>"}return e.length>50&&(e=e.slice(0,50)),e}function d(t,e){let n=t;for(const t in e){if("object"==typeof e[t])for(const i in e[t])n=n.replace(`{${t}.${i}}`,e[t][i]);n=n.replace(`{${t}}`,e[t])}return n}n.tabularize=u,n.toText=h,n.substituteIn=d,n.makeTooltip=function(t,e){if(!t)return null;let n=!1;const i={};for(let l=0;l<e.length;l++){const o=e[l].id;"boolean"!=typeof t&&(l.toString()in t||o in t)&&(i[o]=o in t?t[o]:t[l.toString()],n=!0)}return t.html||t.text||n?e=>{if(!e.picked)return null;const l=n?i[e.layer.id]:t;if(null==l)return;if("boolean"==typeof l)return l?a(e):null;const o={style:l.style||c};return l.html?o.html=d(l.html,e.object):o.text=d(l.text,e.object),o}:a}},
"093eb75864": function _(E,_,R,T,A){_.exports={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,FUNC_ADD:32774,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,BLEND_COLOR:32773,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,VENDOR:7936,RENDERER:7937,VERSION:7938,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,BROWSER_DEFAULT_WEBGL:37444,STATIC_DRAW:35044,STREAM_DRAW:35040,DYNAMIC_DRAW:35048,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,CULL_FACE:2884,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,BLEND:3042,DEPTH_TEST:2929,DITHER:3024,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,SCISSOR_TEST:3089,STENCIL_TEST:2960,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CONTEXT_LOST_WEBGL:37442,CW:2304,CCW:2305,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DOUBLE:5130,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,COMPILE_STATUS:35713,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_ATTRIBUTES:35721,ACTIVE_UNIFORMS:35718,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,ALWAYS:519,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,GEQUAL:518,NOTEQUAL:517,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,TEXTURE_WIDTH:4096,TEXTURE_HEIGHT:4097,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,MAX_3D_TEXTURE_SIZE:32883,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,MAX_TEXTURE_LOD_BIAS:34045,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,RASTERIZER_DISCARD:35977,VERTEX_ARRAY_BINDING:34229,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,MAX_ELEMENT_INDEX:36203,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,RGB9_E5:35901,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,RGB10_A2UI:36975,TEXTURE_IMMUTABLE_FORMAT:37167,TEXTURE_IMMUTABLE_LEVELS:33503,UNSIGNED_INT_2_10_10_10_REV:33640,UNSIGNED_INT_10F_11F_11F_REV:35899,UNSIGNED_INT_5_9_9_9_REV:35902,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,UNSIGNED_INT_24_8:34042,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,INT_2_10_10_10_REV:36255,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,MAX_SAMPLES:36183,SAMPLER_BINDING:35097,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,UNSIGNED_NORMALIZED:35863,SIGNED_NORMALIZED:36764,VERTEX_ATTRIB_ARRAY_INTEGER:35069,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,DEPTH24_STENCIL8:35056,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,COLOR:6144,DEPTH:6145,STENCIL:6146,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,INVALID_INDEX:4294967295,TIMEOUT_IGNORED:-1,MAX_CLIENT_WAIT_TIMEOUT_WEBGL:37447,VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE:35070,UNMASKED_VENDOR_WEBGL:37445,UNMASKED_RENDERER_WEBGL:37446,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047,TEXTURE_MAX_ANISOTROPY_EXT:34046,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_RGBA8_ETC2_EAC:37493,COMPRESSED_SRGB8_ETC2:37494,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37495,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37496,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37497,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,COMPRESSED_RGB_ATC_WEBGL:35986,COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL:35986,COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL:34798,UNSIGNED_INT_24_8_WEBGL:34042,HALF_FLOAT_OES:36193,RGBA32F_EXT:34836,RGB32F_EXT:34837,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT:33297,UNSIGNED_NORMALIZED_EXT:35863,MIN_EXT:32775,MAX_EXT:32776,SRGB_EXT:35904,SRGB_ALPHA_EXT:35906,SRGB8_ALPHA8_EXT:35907,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT:33296,FRAGMENT_SHADER_DERIVATIVE_HINT_OES:35723,COLOR_ATTACHMENT0_WEBGL:36064,COLOR_ATTACHMENT1_WEBGL:36065,COLOR_ATTACHMENT2_WEBGL:36066,COLOR_ATTACHMENT3_WEBGL:36067,COLOR_ATTACHMENT4_WEBGL:36068,COLOR_ATTACHMENT5_WEBGL:36069,COLOR_ATTACHMENT6_WEBGL:36070,COLOR_ATTACHMENT7_WEBGL:36071,COLOR_ATTACHMENT8_WEBGL:36072,COLOR_ATTACHMENT9_WEBGL:36073,COLOR_ATTACHMENT10_WEBGL:36074,COLOR_ATTACHMENT11_WEBGL:36075,COLOR_ATTACHMENT12_WEBGL:36076,COLOR_ATTACHMENT13_WEBGL:36077,COLOR_ATTACHMENT14_WEBGL:36078,COLOR_ATTACHMENT15_WEBGL:36079,DRAW_BUFFER0_WEBGL:34853,DRAW_BUFFER1_WEBGL:34854,DRAW_BUFFER2_WEBGL:34855,DRAW_BUFFER3_WEBGL:34856,DRAW_BUFFER4_WEBGL:34857,DRAW_BUFFER5_WEBGL:34858,DRAW_BUFFER6_WEBGL:34859,DRAW_BUFFER7_WEBGL:34860,DRAW_BUFFER8_WEBGL:34861,DRAW_BUFFER9_WEBGL:34862,DRAW_BUFFER10_WEBGL:34863,DRAW_BUFFER11_WEBGL:34864,DRAW_BUFFER12_WEBGL:34865,DRAW_BUFFER13_WEBGL:34866,DRAW_BUFFER14_WEBGL:34867,DRAW_BUFFER15_WEBGL:34868,MAX_COLOR_ATTACHMENTS_WEBGL:36063,MAX_DRAW_BUFFERS_WEBGL:34852,VERTEX_ARRAY_BINDING_OES:34229,QUERY_COUNTER_BITS_EXT:34916,CURRENT_QUERY_EXT:34917,QUERY_RESULT_EXT:34918,QUERY_RESULT_AVAILABLE_EXT:34919,TIME_ELAPSED_EXT:35007,TIMESTAMP_EXT:36392,GPU_DISJOINT_EXT:36795}},
"9d046c4720": function _(t,e,s,h,i){h();const r=t("@bokehjs/models/layouts/html_box");class n extends r.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,(()=>this._plot()));const{width:t,height:e,renderer:s,theme:h}=this.model.properties;this.on_change([t,e],(()=>this._resize())),this.on_change([h,s],(()=>this.render()))}render(){super.render();const t={width:this.model.width,height:this.model.height,renderer:this.model.renderer};null!=this._chart&&window.echarts.dispose(this._chart),this._chart=window.echarts.init(this.el,this.model.theme,t),this._plot()}after_layout(){super.after_layout(),this._chart.resize()}_plot(){null!=window.echarts&&this._chart.setOption(this.model.data)}_resize(){this._chart.resize({width:this.model.width,height:this.model.height})}}s.EChartsView=n,n.__name__="EChartsView";class a extends r.HTMLBox{constructor(t){super(t)}static init_ECharts(){this.prototype.default_view=n,this.define((({Any:t,String:e})=>({data:[t,{}],theme:[e,"default"],renderer:[e,"canvas"]})))}}s.ECharts=a,a.__name__="ECharts",a.__module__="panel.models.echarts",a.init_ECharts()},
"3d7593ca5a": function _(e,t,n,s,r){s();const i=e("@bokehjs/models/widgets/markup"),o=e("@bokehjs/core/bokeh_events"),l=e("80a6464b1f"),_=e("d92f7d4d2b");class a extends o.ModelEvent{constructor(e,t){super(),this.node=e,this.data=t,this.event_name="dom_event"}_to_json(){return{model:this.origin,node:this.node,data:this.data}}}function d(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}function c(e){Array.from(e.querySelectorAll("script")).forEach((e=>{const t=document.createElement("script");Array.from(e.attributes).forEach((e=>t.setAttribute(e.name,e.value))),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)}))}n.DOMEvent=a,a.__name__="DOMEvent",n.htmlDecode=d,n.runScripts=c;class h extends l.PanelMarkupView{constructor(){super(...arguments),this._event_listeners={}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.events.change,(()=>{this._remove_event_listeners(),this._setup_event_listeners()}))}rerender(){this.render(),this.invalidate_layout()}render(){super.render();const e=this.process_tex();e?(this.markup_el.innerHTML=e,c(this.markup_el),this._setup_event_listeners()):this.markup_el.innerHTML=""}process_tex(){const e=d(this.model.text)||this.model.text;if(this.model.disable_math||!this.contains_tex(e))return e;const t=this.provider.MathJax.find_tex(e),n=[];let s=0;for(const r of t)n.push(e.slice(s,r.start.n)),n.push(this.provider.MathJax.tex2svg(r.math,{display:r.display}).outerHTML),s=r.end.n;return s<e.length&&n.push(e.slice(s)),n.join("")}contains_tex(e){return!!this.provider.MathJax&&this.provider.MathJax.find_tex(e).length>0}_remove_event_listeners(){for(const e in this._event_listeners){const t=document.getElementById(e);if(null!=t)for(const n in this._event_listeners[e]){const s=this._event_listeners[e][n];t.removeEventListener(n,s)}else console.warn(`DOM node '${e}' could not be found. Cannot subscribe to DOM events.`)}this._event_listeners={}}_setup_event_listeners(){for(const e in this.model.events){const t=document.getElementById(e);if(null!=t)for(const n of this.model.events[e]){const s=t=>{this.model.trigger_event(new a(e,(0,_.serializeEvent)(t)))};t.addEventListener(n,s),e in this._event_listeners||(this._event_listeners[e]={}),this._event_listeners[e][n]=s}else console.warn(`DOM node '${e}' could not be found. Cannot subscribe to DOM events.`)}}}n.HTMLView=h,h.__name__="HTMLView";class u extends i.Markup{constructor(e){super(e)}static init_HTML(){this.prototype.default_view=h,this.define((({Any:e})=>({events:[e,{}]})))}}n.HTML=u,u.__name__="HTML",u.__module__="panel.models.markup",u.init_HTML()},
"d92f7d4d2b": function _(e,t,a,r,n){function i(e){let t=null;return e&&(t=function(e){return{boundingClientRect:Object.assign({},e.getBoundingClientRect())}}(e),e.tagName in l&&l[e.tagName].forEach((a=>Object.assign(t,a(e))))),t}r(),a.serializeEvent=
/*
    The MIT License (MIT)
    
    Copyright (c) 2019 Ryan S. Morshead
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
    */
function(e){const t={};return void 0!==e.detail&&Object.assign(t,{detail:JSON.parse(JSON.stringify(e.detail))}),e.type in d&&Object.assign(t,d[e.type](e)),t.target=i(e.target),t.currentTarget=e.target===e.currentTarget?t.target:i(e.currentTarget),t.relatedTarget=i(e.relatedTarget),t};const o={hasValue:e=>({value:e.value}),hasCurrentTime:e=>({currentTime:e.currentTime}),hasFiles:e=>"file"===(null==e?void 0:e.type)?{files:Array.from(e.files).map((e=>({lastModified:e.lastModified,name:e.name,size:e.size,type:e.type})))}:{}};const s={hasValue:["BUTTON","INPUT","OPTION","LI","METER","PROGRESS","PARAM","SELECT","TEXTAREA"],hasCurrentTime:["AUDIO","VIDEO"],hasFiles:["INPUT"]},l={};Object.keys(s).forEach((e=>{s[e].forEach((t=>{(l[t]||(l[t]=[])).push(o[e])}))}));class c{clipboard(e){return{clipboardData:e.clipboardData}}composition(e){return{data:e.data}}keyboard(e){return{altKey:e.altKey,charCode:e.charCode,ctrlKey:e.ctrlKey,key:e.key,keyCode:e.keyCode,locale:e.locale,location:e.location,metaKey:e.metaKey,repeat:e.repeat,shiftKey:e.shiftKey,which:e.which}}mouse(e){return{altKey:e.altKey,button:e.button,buttons:e.buttons,clientX:e.clientX,clientY:e.clientY,ctrlKey:e.ctrlKey,metaKey:e.metaKey,pageX:e.pageX,pageY:e.pageY,screenX:e.screenX,screenY:e.screenY,shiftKey:e.shiftKey}}pointer(e){return Object.assign(Object.assign({},this.mouse(e)),{pointerId:e.pointerId,width:e.width,height:e.height,pressure:e.pressure,tiltX:e.tiltX,tiltY:e.tiltY,pointerType:e.pointerType,isPrimary:e.isPrimary})}selection(){return{selectedText:window.getSelection().toString()}}touch(e){return{altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,shiftKey:e.shiftKey}}ui(e){return{detail:e.detail}}wheel(e){return{deltaMode:e.deltaMode,deltaX:e.deltaX,deltaY:e.deltaY,deltaZ:e.deltaZ}}animation(e){return{animationName:e.animationName,pseudoElement:e.pseudoElement,elapsedTime:e.elapsedTime}}transition(e){return{propertyName:e.propertyName,pseudoElement:e.pseudoElement,elapsedTime:e.elapsedTime}}}c.__name__="EventTransformCategories";const u={clipboard:["copy","cut","paste"],composition:["compositionend","compositionstart","compositionupdate"],keyboard:["keydown","keypress","keyup"],mouse:["click","contextmenu","doubleclick","drag","dragend","dragenter","dragexit","dragleave","dragover","dragstart","drop","mousedown","mouseenter","mouseleave","mousemove","mouseout","mouseover","mouseup"],pointer:["pointerdown","pointermove","pointerup","pointercancel","gotpointercapture","lostpointercapture","pointerenter","pointerleave","pointerover","pointerout"],selection:["select"],touch:["touchcancel","touchend","touchmove","touchstart"],ui:["scroll"],wheel:["wheel"],animation:["animationstart","animationend","animationiteration"],transition:["transitionend"]},d={},p=new c;Object.keys(u).forEach((e=>{u[e].forEach((t=>{d[t]=p[e]}))}))},
"7d45bd3bc4": function _(require,module,exports,__esModule,__esExport){__esModule();const preact_1=require("6f11f2ef27"),hooks_1=require("4c02a9b43f"),preact_2=require("b3f51db71c"),fast_json_patch_1=require("cbecfde9cd"),html_box_1=require("@bokehjs/models/layouts/html_box"),layout_1=require("80a6464b1f"),event_to_object_1=require("d92f7d4d2b"),LayoutConfigContext=(0,preact_1.createContext)({});function mountLayout(e,t,o,n){(0,preact_1.render)(preact_2.html`
      <${Layout}
        saveUpdateHook=${t}
        sendEvent=${o}
        importSourceUrl=${n}
      />
    `,e)}function Layout({saveUpdateHook:e,sendEvent:t,importSourceUrl:o}){const[n,r]=useInplaceJsonPatch({});return(0,hooks_1.useEffect)((()=>e(r)),[r]),n.tagName?preact_2.html`
      <${LayoutConfigContext.Provider}
        value=${{sendEvent:t,importSourceUrl:o}}
      >
        <${Element} model=${n} />
      <//>
    `:preact_2.html`<div />`}function Element({model:e}){return e.importSource?preact_2.html`<${ImportedElement} model=${e} />`:preact_2.html`<${StandardElement} model=${e} />`}function ImportedElement({model:e}){const t=(0,hooks_1.useContext)(LayoutConfigContext),o=useLazyModule(e.importSource.source,t.importSourceUrl);if(o){const n=getPathProperty(o,e.tagName),r=elementChildren(e),a=elementAttributes(e,t.sendEvent);return preact_2.html`<${n} ...${a}>${r}<//>`}{const t=e.importSource.fallback;if(!t)return preact_2.html`<div />`;switch(typeof t){case"object":return preact_2.html`<${Element} model=${t} />`;case"string":return preact_2.html`<div>${t}</div>`;default:return null}}}function StandardElement({model:e}){const t=(0,hooks_1.useContext)(LayoutConfigContext),o=elementChildren(e),n=elementAttributes(e,t.sendEvent);return e.children&&e.children.length?preact_2.html`<${e.tagName} ...${n}>${o}<//>`:preact_2.html`<${e.tagName} ...${n} />`}function elementChildren(e){return e.children?e.children.map((e=>{switch(typeof e){case"object":return preact_2.html`<${Element} model=${e} />`;case"string":return e;default:return null}})):[]}function elementAttributes(e,t){const o=Object.assign({},e.attributes);return e.eventHandlers&&Object.keys(e.eventHandlers).forEach((n=>{const r=e.eventHandlers[n];o[n]=eventHandler(t,r)})),o}function eventHandler(e,t){return function(){const o=Array.from(arguments).map((e=>"object"==typeof e?(t.preventDefault&&e.preventDefault(),t.stopPropagation&&e.stopPropagation(),(0,event_to_object_1.serializeEvent)(e)):e));return new Promise((n=>{const r={data:o,target:t.target};e(r),n(r)}))}}function useLazyModule(source,sourceUrlBase=""){const[module,setModule]=(0,hooks_1.useState)(null);return module||eval(`import('${joinUrl(sourceUrlBase,source)}')`).then(setModule),module}function getPathProperty(e,t){const o=t.split(".");let n=e[o.shift()];for(let e=0;e<o.length;e++)n=n[o[e]];return n}function useInplaceJsonPatch(e){const t=(0,hooks_1.useRef)(e),o=useForceUpdate(),n=(0,hooks_1.useCallback)(((e,n)=>{applyPatchInplace(t.current,e,n),o()}),[t,o]);return[t.current,n]}function applyPatchInplace(e,t,o){t?(0,fast_json_patch_1.applyPatch)(e,[{op:"replace",path:t,value:(0,fast_json_patch_1.applyPatch)((0,fast_json_patch_1.getValueByPointer)(e,t),o,!1,!1).newDocument}]):(0,fast_json_patch_1.applyPatch)(e,o)}function useForceUpdate(){const[,e]=(0,hooks_1.useState)({});return(0,hooks_1.useCallback)((()=>e({})),[])}function joinUrl(e,t){return t.startsWith("./")?(e.endsWith("/")?e.slice(0,-1):e)+t.slice(1):t}exports.mountLayout=mountLayout,exports.default=Layout;class IDOMView extends layout_1.PanelHTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.event.change,(()=>{this._update(...this.model.event),setTimeout((()=>{requestAnimationFrame((()=>this.fix_layout()))}))}))}fix_layout(){this.update_layout(),this.compute_layout(),this.invalidate_layout(),(0,layout_1.set_size)(this.el,this.model)}initialize(){super.initialize(),mountLayout(this.el,(e=>this._save_update(e)),(e=>this._send(e)),this.model.importSourceUrl)}async lazy_initialize(){await super.lazy_initialize(),await new Promise((e=>{const t=()=>{this._update?e(null):setTimeout(t,100)};t()}))}_save_update(e){this._update=e}async render(){super.render(),this._update(...this.model.event),await new Promise((e=>{const t=()=>{this.el.children.length?(this.fix_layout(),e(null)):setTimeout(t,50)};t()}))}_send(e){this.model.msg=e}}exports.IDOMView=IDOMView,IDOMView.__name__="IDOMView";class IDOM extends html_box_1.HTMLBox{constructor(e){super(e)}static init_IDOM(){this.prototype.default_view=IDOMView,this.define((({Any:e,String:t})=>({event:[e,[]],importSourceUrl:[t,""],msg:[e,{}]})))}}exports.IDOM=IDOM,IDOM.__name__="IDOM",IDOM.__module__="panel.models.idom",IDOM.init_IDOM()},
"6f11f2ef27": function _(e,n,t,_,l){_();var o,r,i,u,s,c,f={},p=[],a=/acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;function d(e,n){for(var t in n)e[t]=n[t];return e}function h(e){var n=e.parentNode;n&&n.removeChild(e)}function v(e,n,t){var _,l,o,r=arguments,i={};for(o in n)"key"==o?_=n[o]:"ref"==o?l=n[o]:i[o]=n[o];if(arguments.length>3)for(t=[t],o=3;o<arguments.length;o++)t.push(r[o]);if(null!=t&&(i.children=t),"function"==typeof e&&null!=e.defaultProps)for(o in e.defaultProps)void 0===i[o]&&(i[o]=e.defaultProps[o]);return y(e,i,_,l,null)}function y(e,n,t,_,l){var r={type:e,props:n,key:t,ref:_,__k:null,__:null,__b:0,__e:null,__d:void 0,__c:null,__h:null,constructor:void 0,__v:null==l?++o.__v:l};return null!=o.vnode&&o.vnode(r),r}function m(e){return e.children}function k(e,n){this.props=e,this.context=n}function g(e,n){if(null==n)return e.__?g(e.__,e.__.__k.indexOf(e)+1):null;for(var t;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e)return t.__e;return"function"==typeof e.type?g(e):null}function b(e){var n,t;if(null!=(e=e.__)&&null!=e.__c){for(e.__e=e.__c.base=null,n=0;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e){e.__e=e.__c.base=t.__e;break}return b(e)}}function C(e){(!e.__d&&(e.__d=!0)&&i.push(e)&&!x.__r++||s!==o.debounceRendering)&&((s=o.debounceRendering)||u)(x)}function x(){for(var e;x.__r=i.length;)e=i.sort((function(e,n){return e.__v.__b-n.__v.__b})),i=[],e.some((function(e){var n,t,_,l,o,r;e.__d&&(o=(l=(n=e).__v).__e,(r=n.__P)&&(t=[],(_=d({},l)).__v=l.__v+1,A(r,l,_,n.__n,void 0!==r.ownerSVGElement,null!=l.__h?[o]:null,t,null==o?g(l):o,l.__h),N(t,l),l.__e!=o&&b(l)))}))}function P(e,n,t,_,l,o,r,i,u,s){var c,a,d,h,v,k,b,C=_&&_.__k||p,x=C.length;for(t.__k=[],c=0;c<n.length;c++)if(null!=(h=t.__k[c]=null==(h=n[c])||"boolean"==typeof h?null:"string"==typeof h||"number"==typeof h?y(null,h,null,null,h):Array.isArray(h)?y(m,{children:h},null,null,null):h.__b>0?y(h.type,h.props,h.key,null,h.__v):h)){if(h.__=t,h.__b=t.__b+1,null===(d=C[c])||d&&h.key==d.key&&h.type===d.type)C[c]=void 0;else for(a=0;a<x;a++){if((d=C[a])&&h.key==d.key&&h.type===d.type){C[a]=void 0;break}d=null}A(e,h,d=d||f,l,o,r,i,u,s),v=h.__e,(a=h.ref)&&d.ref!=a&&(b||(b=[]),d.ref&&b.push(d.ref,null,h),b.push(a,h.__c||v,h)),null!=v?(null==k&&(k=v),"function"==typeof h.type&&null!=h.__k&&h.__k===d.__k?h.__d=u=S(h,u,e):u=E(e,h,d,C,v,u),s||"option"!==t.type?"function"==typeof t.type&&(t.__d=u):e.value=""):u&&d.__e==u&&u.parentNode!=e&&(u=g(d))}for(t.__e=k,c=x;c--;)null!=C[c]&&("function"==typeof t.type&&null!=C[c].__e&&C[c].__e==t.__d&&(t.__d=g(_,c+1)),M(C[c],C[c]));if(b)for(c=0;c<b.length;c++)L(b[c],b[++c],b[++c])}function S(e,n,t){var _,l;for(_=0;_<e.__k.length;_++)(l=e.__k[_])&&(l.__=e,n="function"==typeof l.type?S(l,n,t):E(t,l,l,e.__k,l.__e,n));return n}function E(e,n,t,_,l,o){var r,i,u;if(void 0!==n.__d)r=n.__d,n.__d=void 0;else if(null==t||l!=o||null==l.parentNode)e:if(null==o||o.parentNode!==e)e.appendChild(l),r=null;else{for(i=o,u=0;(i=i.nextSibling)&&u<_.length;u+=2)if(i==l)break e;e.insertBefore(l,o),r=o}return void 0!==r?r:l.nextSibling}function w(e,n,t){"-"===n[0]?e.setProperty(n,t):e[n]=null==t?"":"number"!=typeof t||a.test(n)?t:t+"px"}function U(e,n,t,_,l){var o;e:if("style"===n)if("string"==typeof t)e.style.cssText=t;else{if("string"==typeof _&&(e.style.cssText=_=""),_)for(n in _)t&&n in t||w(e.style,n,"");if(t)for(n in t)_&&t[n]===_[n]||w(e.style,n,t[n])}else if("o"===n[0]&&"n"===n[1])o=n!==(n=n.replace(/Capture$/,"")),n=n.toLowerCase()in e?n.toLowerCase().slice(2):n.slice(2),e.l||(e.l={}),e.l[n+o]=t,t?_||e.addEventListener(n,o?T:D,o):e.removeEventListener(n,o?T:D,o);else if("dangerouslySetInnerHTML"!==n){if(l)n=n.replace(/xlink[H:h]/,"h").replace(/sName$/,"s");else if("href"!==n&&"list"!==n&&"form"!==n&&"download"!==n&&n in e)try{e[n]=null==t?"":t;break e}catch(e){}"function"==typeof t||(null!=t&&(!1!==t||"a"===n[0]&&"r"===n[1])?e.setAttribute(n,t):e.removeAttribute(n))}}function D(e){this.l[e.type+!1](o.event?o.event(e):e)}function T(e){this.l[e.type+!0](o.event?o.event(e):e)}function A(e,n,t,_,l,r,i,u,s){var c,f,p,a,h,v,y,g,b,C,x,S=n.type;if(void 0!==n.constructor)return null;null!=t.__h&&(s=t.__h,u=n.__e=t.__e,n.__h=null,r=[u]),(c=o.__b)&&c(n);try{e:if("function"==typeof S){if(g=n.props,b=(c=S.contextType)&&_[c.__c],C=c?b?b.props.value:c.__:_,t.__c?y=(f=n.__c=t.__c).__=f.__E:("prototype"in S&&S.prototype.render?n.__c=f=new S(g,C):(n.__c=f=new k(g,C),f.constructor=S,f.render=F),b&&b.sub(f),f.props=g,f.state||(f.state={}),f.context=C,f.__n=_,p=f.__d=!0,f.__h=[]),null==f.__s&&(f.__s=f.state),null!=S.getDerivedStateFromProps&&(f.__s==f.state&&(f.__s=d({},f.__s)),d(f.__s,S.getDerivedStateFromProps(g,f.__s))),a=f.props,h=f.state,p)null==S.getDerivedStateFromProps&&null!=f.componentWillMount&&f.componentWillMount(),null!=f.componentDidMount&&f.__h.push(f.componentDidMount);else{if(null==S.getDerivedStateFromProps&&g!==a&&null!=f.componentWillReceiveProps&&f.componentWillReceiveProps(g,C),!f.__e&&null!=f.shouldComponentUpdate&&!1===f.shouldComponentUpdate(g,f.__s,C)||n.__v===t.__v){f.props=g,f.state=f.__s,n.__v!==t.__v&&(f.__d=!1),f.__v=n,n.__e=t.__e,n.__k=t.__k,f.__h.length&&i.push(f);break e}null!=f.componentWillUpdate&&f.componentWillUpdate(g,f.__s,C),null!=f.componentDidUpdate&&f.__h.push((function(){f.componentDidUpdate(a,h,v)}))}f.context=C,f.props=g,f.state=f.__s,(c=o.__r)&&c(n),f.__d=!1,f.__v=n,f.__P=e,c=f.render(f.props,f.state,f.context),f.state=f.__s,null!=f.getChildContext&&(_=d(d({},_),f.getChildContext())),p||null==f.getSnapshotBeforeUpdate||(v=f.getSnapshotBeforeUpdate(a,h)),x=null!=c&&c.type===m&&null==c.key?c.props.children:c,P(e,Array.isArray(x)?x:[x],n,t,_,l,r,i,u,s),f.base=n.__e,n.__h=null,f.__h.length&&i.push(f),y&&(f.__E=f.__=null),f.__e=!1}else null==r&&n.__v===t.__v?(n.__k=t.__k,n.__e=t.__e):n.__e=W(t.__e,n,t,_,l,r,i,s);(c=o.diffed)&&c(n)}catch(e){n.__v=null,(s||null!=r)&&(n.__e=u,n.__h=!!s,r[r.indexOf(u)]=null),o.__e(e,n,t)}}function N(e,n){o.__c&&o.__c(n,e),e.some((function(n){try{e=n.__h,n.__h=[],e.some((function(e){e.call(n)}))}catch(e){o.__e(e,n.__v)}}))}function W(e,n,t,_,l,o,r,i){var u,s,c,a,d=t.props,v=n.props,y=n.type,m=0;if("svg"===y&&(l=!0),null!=o)for(;m<o.length;m++)if((u=o[m])&&(u===e||(y?u.localName==y:3==u.nodeType))){e=u,o[m]=null;break}if(null==e){if(null===y)return document.createTextNode(v);e=l?document.createElementNS("http://www.w3.org/2000/svg",y):document.createElement(y,v.is&&v),o=null,i=!1}if(null===y)d===v||i&&e.data===v||(e.data=v);else{if(o=o&&p.slice.call(e.childNodes),s=(d=t.props||f).dangerouslySetInnerHTML,c=v.dangerouslySetInnerHTML,!i){if(null!=o)for(d={},a=0;a<e.attributes.length;a++)d[e.attributes[a].name]=e.attributes[a].value;(c||s)&&(c&&(s&&c.__html==s.__html||c.__html===e.innerHTML)||(e.innerHTML=c&&c.__html||""))}if(function(e,n,t,_,l){var o;for(o in t)"children"===o||"key"===o||o in n||U(e,o,null,t[o],_);for(o in n)l&&"function"!=typeof n[o]||"children"===o||"key"===o||"value"===o||"checked"===o||t[o]===n[o]||U(e,o,n[o],t[o],_)}(e,v,d,l,i),c)n.__k=[];else if(m=n.props.children,P(e,Array.isArray(m)?m:[m],n,t,_,l&&"foreignObject"!==y,o,r,e.firstChild,i),null!=o)for(m=o.length;m--;)null!=o[m]&&h(o[m]);i||("value"in v&&void 0!==(m=v.value)&&(m!==e.value||"progress"===y&&!m)&&U(e,"value",m,d.value,!1),"checked"in v&&void 0!==(m=v.checked)&&m!==e.checked&&U(e,"checked",m,d.checked,!1))}return e}function L(e,n,t){try{"function"==typeof e?e(n):e.current=n}catch(e){o.__e(e,t)}}function M(e,n,t){var _,l,r;if(o.unmount&&o.unmount(e),(_=e.ref)&&(_.current&&_.current!==e.__e||L(_,null,n)),t||"function"==typeof e.type||(t=null!=(l=e.__e)),e.__e=e.__d=void 0,null!=(_=e.__c)){if(_.componentWillUnmount)try{_.componentWillUnmount()}catch(e){o.__e(e,n)}_.base=_.__P=null}if(_=e.__k)for(r=0;r<_.length;r++)_[r]&&M(_[r],n,t);null!=l&&h(l)}function F(e,n,t){return this.constructor(e,t)}function H(e,n,t){var _,l,r;o.__&&o.__(e,n),l=(_="function"==typeof t)?null:t&&t.__k||n.__k,r=[],A(n,e=(!_&&t||n).__k=v(m,null,[e]),l||f,f,void 0!==n.ownerSVGElement,!_&&t?[t]:l?null:n.firstChild?p.slice.call(n.childNodes):null,r,!_&&t?t:l?l.__e:n.firstChild,_),N(r,e)}t.options=o,t.isValidElement=r,t.createElement=v,t.h=v,t.createRef=function(){return{current:null}},t.Fragment=m,t.Component=k,t.toChildArray=function e(n,t){return t=t||[],null==n||"boolean"==typeof n||(Array.isArray(n)?n.some((function(n){e(n,t)})):t.push(n)),t},t.render=H,t.hydrate=function e(n,t){H(n,t,e)},t.cloneElement=function(e,n,t){var _,l,o,r=arguments,i=d({},e.props);for(o in n)"key"==o?_=n[o]:"ref"==o?l=n[o]:i[o]=n[o];if(arguments.length>3)for(t=[t],o=3;o<arguments.length;o++)t.push(r[o]);return null!=t&&(i.children=t),y(e.type,i,_||e.key,l||e.ref,null)},t.createContext=function(e,n){var t={__c:n="__cC"+c++,__:e,Consumer:function(e,n){return e.children(n)},Provider:function(e){var t,_;return this.getChildContext||(t=[],(_={})[n]=this,this.getChildContext=function(){return _},this.shouldComponentUpdate=function(e){this.props.value!==e.value&&t.some(C)},this.sub=function(e){t.push(e);var n=e.componentWillUnmount;e.componentWillUnmount=function(){t.splice(t.indexOf(e),1),n&&n.call(e)}}),e.children}};return t.Provider.__=t.Consumer.contextType=t},t.options=o={__e:function(e,n){for(var t,_,l;n=n.__;)if((t=n.__c)&&!t.__)try{if((_=t.constructor)&&null!=_.getDerivedStateFromError&&(t.setState(_.getDerivedStateFromError(e)),l=t.__d),null!=t.componentDidCatch&&(t.componentDidCatch(e),l=t.__d),l)return t.__E=t}catch(n){e=n}throw e},__v:0},t.isValidElement=r=function(e){return null!=e&&void 0===e.constructor},k.prototype.setState=function(e,n){var t;t=null!=this.__s&&this.__s!==this.state?this.__s:this.__s=d({},this.state),"function"==typeof e&&(e=e(d({},t),this.props)),e&&d(t,e),null!=e&&this.__v&&(n&&this.__h.push(n),C(this))},k.prototype.forceUpdate=function(e){this.__v&&(this.__e=!0,e&&this.__h.push(e),C(this))},k.prototype.render=m,i=[],u="function"==typeof Promise?Promise.prototype.then.bind(Promise.resolve()):setTimeout,x.__r=0,c=0},
"4c02a9b43f": function _(_,n,t,o,u){o();const e=_("6f11f2ef27");var i,c,r,f=0,a=[],s=e.options.__b,h=e.options.__r,p=e.options.diffed,v=e.options.__c,m=e.options.unmount;function l(_,n){e.options.__h&&e.options.__h(c,_,f||n),f=0;var t=c.__H||(c.__H={__:[],__h:[]});return _>=t.__.length&&t.__.push({}),t.__[_]}function H(_){return f=1,d(q,_)}function d(_,n,t){var o=l(i++,2);return o.t=_,o.__c||(o.__=[t?t(n):q(void 0,n),function(_){var n=o.t(o.__[0],_);o.__[0]!==n&&(o.__=[n,o.__[1]],o.__c.setState({}))}],o.__c=c),o.__}function E(_,n){var t=l(i++,4);!e.options.__s&&F(t.__H,n)&&(t.__=_,t.__H=n,c.__h.push(t))}function y(_,n){var t=l(i++,7);return F(t.__H,n)&&(t.__=_(),t.__H=n,t.__h=_),t.__}function b(){a.forEach((function(_){if(_.__P)try{_.__H.__h.forEach(A),_.__H.__h.forEach(D),_.__H.__h=[]}catch(n){_.__H.__h=[],e.options.__e(n,_.__v)}})),a=[]}t.useState=H,t.useReducer=d,t.useEffect=function(_,n){var t=l(i++,3);!e.options.__s&&F(t.__H,n)&&(t.__=_,t.__H=n,c.__H.__h.push(t))},t.useLayoutEffect=E,t.useRef=function(_){return f=5,y((function(){return{current:_}}),[])},t.useImperativeHandle=function(_,n,t){f=6,E((function(){"function"==typeof _?_(n()):_&&(_.current=n())}),null==t?t:t.concat(_))},t.useMemo=y,t.useCallback=function(_,n){return f=8,y((function(){return _}),n)},t.useContext=function(_){var n=c.context[_.__c],t=l(i++,9);return t.__c=_,n?(null==t.__&&(t.__=!0,n.sub(c)),n.props.value):_.__},t.useDebugValue=function(_,n){e.options.useDebugValue&&e.options.useDebugValue(n?n(_):_)},t.useErrorBoundary=function(_){var n=l(i++,10),t=H();return n.__=_,c.componentDidCatch||(c.componentDidCatch=function(_){n.__&&n.__(_),t[1](_)}),[t[0],function(){t[1](void 0)}]},e.options.__b=function(_){c=null,s&&s(_)},e.options.__r=function(_){h&&h(_),i=0;var n=(c=_.__c).__H;n&&(n.__h.forEach(A),n.__h.forEach(D),n.__h=[])},e.options.diffed=function(_){p&&p(_);var n=_.__c;n&&n.__H&&n.__H.__h.length&&(1!==a.push(n)&&r===e.options.requestAnimationFrame||((r=e.options.requestAnimationFrame)||function(_){var n,t=function(){clearTimeout(o),g&&cancelAnimationFrame(n),setTimeout(_)},o=setTimeout(t,100);g&&(n=requestAnimationFrame(t))})(b)),c=void 0},e.options.__c=function(_,n){n.some((function(_){try{_.__h.forEach(A),_.__h=_.__h.filter((function(_){return!_.__||D(_)}))}catch(t){n.some((function(_){_.__h&&(_.__h=[])})),n=[],e.options.__e(t,_.__v)}})),v&&v(_,n)},e.options.unmount=function(_){m&&m(_);var n=_.__c;if(n&&n.__H)try{n.__H.__.forEach(A)}catch(_){e.options.__e(_,n.__v)}};var g="function"==typeof requestAnimationFrame;function A(_){var n=c;"function"==typeof _.__c&&_.__c(),c=n}function D(_){var n=c;_.__c=_.__(),c=n}function F(_,n){return!_||_.length!==n.length||n.some((function(n,t){return n!==_[t]}))}function q(_,n){return"function"==typeof n?n(_):n}},
"b3f51db71c": function _(e,f,n,t,o){t();const r=e("tslib"),d=e("6f11f2ef27");var a=e("6f11f2ef27");o("h",a.h),o("render",a.render),o("Component",a.Component);var h=(0,r.__importDefault)(e("ab33dd3f38")).default.bind(d.h);n.html=h},
"ab33dd3f38": function _(n,t,s,u,r){u();var e=function(n,t,s,u){var r;t[0]=0;for(var h=1;h<t.length;h++){var p=t[h++],a=t[h]?(t[0]|=p?1:2,s[t[h++]]):t[++h];3===p?u[0]=a:4===p?u[1]=Object.assign(u[1]||{},a):5===p?(u[1]=u[1]||{})[t[++h]]=a:6===p?u[1][t[++h]]+=a+"":p?(r=n.apply(a,e(n,a,s,["",null])),u.push(r),a[0]?t[0]|=2:(t[h-2]=0,t[h]=r)):u.push(a)}return u},h=new Map;s.default=function(n){var t=h.get(this);return t||(t=new Map,h.set(this,t)),(t=e(this,t.get(n)||(t.set(n,t=function(n){for(var t,s,u=1,r="",e="",h=[0],p=function(n){1===u&&(n||(r=r.replace(/^\s*\n\s*|\s*\n\s*$/g,"")))?h.push(0,n,r):3===u&&(n||r)?(h.push(3,n,r),u=2):2===u&&"..."===r&&n?h.push(4,n,0):2===u&&r&&!n?h.push(5,0,!0,r):u>=5&&((r||!n&&5===u)&&(h.push(u,0,r,s),u=6),n&&(h.push(u,n,0,s),u=6)),r=""},a=0;a<n.length;a++){a&&(1===u&&p(),p(a));for(var f=0;f<n[a].length;f++)t=n[a][f],1===u?"<"===t?(p(),h=[h],u=3):r+=t:4===u?"--"===r&&">"===t?(u=1,r=""):r=t+r[0]:e?t===e?e="":r+=t:'"'===t||"'"===t?e=t:">"===t?(p(),u=1):u&&("="===t?(u=5,s=r,r=""):"/"===t&&(u<5||">"===n[a][f+1])?(p(),3===u&&(h=h[0]),u=h,(h=h[0]).push(2,0,u),u=0):" "===t||"\t"===t||"\n"===t||"\r"===t?(p(),u=2):r+=t),3===u&&"!--"===r&&(u=4,h=h[0])}return p(),h}(n)),t),arguments,[])).length>1?t:t[0]}},
"cbecfde9cd": function _(e,n,t,o,a){var r=this&&this.__assign||function(){return r=Object.assign||function(e){for(var n,t=1,o=arguments.length;t<o;t++)for(var a in n=arguments[t])Object.prototype.hasOwnProperty.call(n,a)&&(e[a]=n[a]);return e},r.apply(this,arguments)};o();
/*!
     * https://github.com/Starcounter-Jack/JSON-Patch
     * (c) 2017 Joachim Wester
     * MIT license
     */
var p=e("cb21060ee5"),s=e("b2f693e532"),c=e("b2f693e532");t.applyOperation=c.applyOperation,t.applyPatch=c.applyPatch,t.applyReducer=c.applyReducer,t.getValueByPointer=c.getValueByPointer,t.validate=c.validate,t.validator=c.validator;var i=e("cb21060ee5");t.JsonPatchError=i.PatchError,t.deepClone=i._deepClone,t.escapePathComponent=i.escapePathComponent,t.unescapePathComponent=i.unescapePathComponent;var u=new WeakMap,l=function(e){this.observers=new Map,this.obj=e},v=function(e,n){this.callback=e,this.observer=n};function h(e,n){n.unobserve()}function d(e,n){var t,o=function(e){return u.get(e)}(e);if(o){var a=function(e,n){return e.observers.get(n)}(o,n);t=a&&a.observer}else o=new l(e),u.set(e,o);if(t)return t;if(t={},o.value=p._deepClone(e),n){t.callback=n,t.next=null;var r=function(){f(t)},s=function(){clearTimeout(t.next),t.next=setTimeout(r)};"undefined"!=typeof window&&(window.addEventListener("mouseup",s),window.addEventListener("keyup",s),window.addEventListener("mousedown",s),window.addEventListener("keydown",s),window.addEventListener("change",s))}return t.patches=[],t.object=e,t.unobserve=function(){f(t),clearTimeout(t.next),function(e,n){e.observers.delete(n.callback)}(o,t),"undefined"!=typeof window&&(window.removeEventListener("mouseup",s),window.removeEventListener("keyup",s),window.removeEventListener("mousedown",s),window.removeEventListener("keydown",s),window.removeEventListener("change",s))},o.observers.set(n,new v(n,t)),t}function f(e,n){void 0===n&&(n=!1);var t=u.get(e.object);w(t.value,e.object,e.patches,"",n),e.patches.length&&s.applyPatch(t.value,e.patches);var o=e.patches;return o.length>0&&(e.patches=[],e.callback&&e.callback(o)),o}function w(e,n,t,o,a){if(n!==e){"function"==typeof n.toJSON&&(n=n.toJSON());for(var r=p._objectKeys(n),s=p._objectKeys(e),c=!1,i=s.length-1;i>=0;i--){var u=e[v=s[i]];if(!p.hasOwnProperty(n,v)||void 0===n[v]&&void 0!==u&&!1===Array.isArray(n))Array.isArray(e)===Array.isArray(n)?(a&&t.push({op:"test",path:o+"/"+p.escapePathComponent(v),value:p._deepClone(u)}),t.push({op:"remove",path:o+"/"+p.escapePathComponent(v)}),c=!0):(a&&t.push({op:"test",path:o,value:e}),t.push({op:"replace",path:o,value:n}),!0);else{var l=n[v];"object"==typeof u&&null!=u&&"object"==typeof l&&null!=l?w(u,l,t,o+"/"+p.escapePathComponent(v),a):u!==l&&(!0,a&&t.push({op:"test",path:o+"/"+p.escapePathComponent(v),value:p._deepClone(u)}),t.push({op:"replace",path:o+"/"+p.escapePathComponent(v),value:p._deepClone(l)}))}}if(c||r.length!=s.length)for(i=0;i<r.length;i++){var v=r[i];p.hasOwnProperty(e,v)||void 0===n[v]||t.push({op:"add",path:o+"/"+p.escapePathComponent(v),value:p._deepClone(n[v])})}}}function b(e,n,t){void 0===t&&(t=!1);var o=[];return w(e,n,o,"",t),o}t.unobserve=h,t.observe=d,t.generate=f,t.compare=b;var y=e("b2f693e532"),m=e("cb21060ee5");t.default=r({},y,{unobserve:h,observe:d,generate:f,compare:b,JsonPatchError:m.PatchError,deepClone:p._deepClone,escapePathComponent:p.escapePathComponent,unescapePathComponent:m.unescapePathComponent})},
"cb21060ee5": function _(r,e,t,n,o){
/*!
     * https://github.com/Starcounter-Jack/JSON-Patch
     * (c) 2017 Joachim Wester
     * MIT license
     */
var i,f=this&&this.__extends||(i=function(r,e){return i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(r,e){r.__proto__=e}||function(r,e){for(var t in e)e.hasOwnProperty(t)&&(r[t]=e[t])},i(r,e)},function(r,e){function t(){this.constructor=r}i(r,e),r.prototype=null===e?Object.create(e):(t.prototype=e.prototype,new t)});n();var u=Object.prototype.hasOwnProperty;function a(r,e){return u.call(r,e)}function c(r){if(Array.isArray(r)){for(var e=new Array(r.length),t=0;t<e.length;t++)e[t]=""+t;return e}if(Object.keys)return Object.keys(r);e=[];for(var n in r)a(r,n)&&e.push(n);return e}function p(r){return-1===r.indexOf("/")&&-1===r.indexOf("~")?r:r.replace(/~/g,"~0").replace(/\//g,"~1")}function s(r,e){var t;for(var n in r)if(a(r,n)){if(r[n]===e)return p(n)+"/";if("object"==typeof r[n]&&""!=(t=s(r[n],e)))return p(n)+"/"+t}return""}function h(r,e){var t=[r];for(var n in e){var o="object"==typeof e[n]?JSON.stringify(e[n],null,2):e[n];void 0!==o&&t.push(n+": "+o)}return t.join("\n")}t.hasOwnProperty=a,t._objectKeys=c,t._deepClone=function(r){switch(typeof r){case"object":return JSON.parse(JSON.stringify(r));case"undefined":return null;default:return r}},t.isInteger=function(r){for(var e,t=0,n=r.length;t<n;){if(!((e=r.charCodeAt(t))>=48&&e<=57))return!1;t++}return!0},t.escapePathComponent=p,t.unescapePathComponent=function(r){return r.replace(/~1/g,"/").replace(/~0/g,"~")},t._getPathRecursive=s,t.getPath=function(r,e){if(r===e)return"/";var t=s(r,e);if(""===t)throw new Error("Object not found in root");return"/"+t},t.hasUndefined=function r(e){if(void 0===e)return!0;if(e)if(Array.isArray(e)){for(var t=0,n=e.length;t<n;t++)if(r(e[t]))return!0}else if("object"==typeof e){var o=c(e),i=o.length;for(t=0;t<i;t++)if(r(e[o[t]]))return!0}return!1};var y=function(r){function e(e,t,n,o,i){var f=this.constructor,u=r.call(this,h(e,{name:t,index:n,operation:o,tree:i}))||this;return u.name=t,u.index=n,u.operation=o,u.tree=i,Object.setPrototypeOf(u,f.prototype),u.message=h(e,{name:t,index:n,operation:o,tree:i}),u}return f(e,r),e}(Error);t.PatchError=y},
"b2f693e532": function _(e,t,o,r,n){r();var a=e("0c8122087b"),i=e("cb21060ee5");o.JsonPatchError=i.PatchError,o.deepClone=i._deepClone;var p={add:function(e,t,o){return e[t]=this.value,{newDocument:o}},remove:function(e,t,o){var r=e[t];return delete e[t],{newDocument:o,removed:r}},replace:function(e,t,o){var r=e[t];return e[t]=this.value,{newDocument:o,removed:r}},move:function(e,t,o){var r=h(o,this.path);r&&(r=i._deepClone(r));var n=c(o,{op:"remove",path:this.from}).removed;return c(o,{op:"add",path:this.path,value:n}),{newDocument:o,removed:r}},copy:function(e,t,o){var r=h(o,this.from);return c(o,{op:"add",path:this.path,value:i._deepClone(r)}),{newDocument:o}},test:function(e,t,o){return{newDocument:o,test:a(e[t],this.value)}},_get:function(e,t,o){return this.value=e[t],{newDocument:o}}},s={add:function(e,t,o){return i.isInteger(t)?e.splice(t,0,this.value):e[t]=this.value,{newDocument:o,index:t}},remove:function(e,t,o){return{newDocument:o,removed:e.splice(t,1)[0]}},replace:function(e,t,o){var r=e[t];return e[t]=this.value,{newDocument:o,removed:r}},move:p.move,copy:p.copy,test:p.test,_get:p._get};function h(e,t){if(""==t)return e;var o={op:"_get",path:t};return c(e,o),o.value}function c(e,t,r,n,c,u){if(void 0===r&&(r=!1),void 0===n&&(n=!0),void 0===c&&(c=!0),void 0===u&&(u=0),r&&("function"==typeof r?r(t,0,e,t.path):d(t,0)),""===t.path){var f={newDocument:e};if("add"===t.op)return f.newDocument=t.value,f;if("replace"===t.op)return f.newDocument=t.value,f.removed=e,f;if("move"===t.op||"copy"===t.op)return f.newDocument=h(e,t.from),"move"===t.op&&(f.removed=e),f;if("test"===t.op){if(f.test=a(e,t.value),!1===f.test)throw new o.JsonPatchError("Test operation failed","TEST_OPERATION_FAILED",u,t,e);return f.newDocument=e,f}if("remove"===t.op)return f.removed=e,f.newDocument=null,f;if("_get"===t.op)return t.value=e,f;if(r)throw new o.JsonPatchError("Operation `op` property is not one of operations defined in RFC-6902","OPERATION_OP_INVALID",u,t,e);return f}n||(e=i._deepClone(e));var l=(t.path||"").split("/"),v=e,E=1,_=l.length,O=void 0,w=void 0,A=void 0;for(A="function"==typeof r?r:d;;){if(w=l[E],c&&"__proto__"==w)throw new TypeError("JSON-Patch: modifying `__proto__` prop is banned for security reasons, if this was on purpose, please set `banPrototypeModifications` flag false and pass it to this function. More info in fast-json-patch README");if(r&&void 0===O&&(void 0===v[w]?O=l.slice(0,E).join("/"):E==_-1&&(O=t.path),void 0!==O&&A(t,0,e,O)),E++,Array.isArray(v)){if("-"===w)w=v.length;else{if(r&&!i.isInteger(w))throw new o.JsonPatchError("Expected an unsigned base-10 integer value, making the new referenced value the array element with the zero-based index","OPERATION_PATH_ILLEGAL_ARRAY_INDEX",u,t,e);i.isInteger(w)&&(w=~~w)}if(E>=_){if(r&&"add"===t.op&&w>v.length)throw new o.JsonPatchError("The specified index MUST NOT be greater than the number of elements in the array","OPERATION_VALUE_OUT_OF_BOUNDS",u,t,e);if(!1===(f=s[t.op].call(t,v,w,e)).test)throw new o.JsonPatchError("Test operation failed","TEST_OPERATION_FAILED",u,t,e);return f}}else if(w&&-1!=w.indexOf("~")&&(w=i.unescapePathComponent(w)),E>=_){if(!1===(f=p[t.op].call(t,v,w,e)).test)throw new o.JsonPatchError("Test operation failed","TEST_OPERATION_FAILED",u,t,e);return f}v=v[w]}}function u(e,t,r,n,a){if(void 0===n&&(n=!0),void 0===a&&(a=!0),r&&!Array.isArray(t))throw new o.JsonPatchError("Patch sequence must be an array","SEQUENCE_NOT_AN_ARRAY");n||(e=i._deepClone(e));for(var p=new Array(t.length),s=0,h=t.length;s<h;s++)p[s]=c(e,t[s],r,!0,a,s),e=p[s].newDocument;return p.newDocument=e,p}function f(e,t,r){var n=c(e,t);if(!1===n.test)throw new o.JsonPatchError("Test operation failed","TEST_OPERATION_FAILED",r,t,e);return n.newDocument}function d(e,t,r,n){if("object"!=typeof e||null===e||Array.isArray(e))throw new o.JsonPatchError("Operation is not an object","OPERATION_NOT_AN_OBJECT",t,e,r);if(!p[e.op])throw new o.JsonPatchError("Operation `op` property is not one of operations defined in RFC-6902","OPERATION_OP_INVALID",t,e,r);if("string"!=typeof e.path)throw new o.JsonPatchError("Operation `path` property is not a string","OPERATION_PATH_INVALID",t,e,r);if(0!==e.path.indexOf("/")&&e.path.length>0)throw new o.JsonPatchError('Operation `path` property must start with "/"',"OPERATION_PATH_INVALID",t,e,r);if(("move"===e.op||"copy"===e.op)&&"string"!=typeof e.from)throw new o.JsonPatchError("Operation `from` property is not present (applicable in `move` and `copy` operations)","OPERATION_FROM_REQUIRED",t,e,r);if(("add"===e.op||"replace"===e.op||"test"===e.op)&&void 0===e.value)throw new o.JsonPatchError("Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)","OPERATION_VALUE_REQUIRED",t,e,r);if(("add"===e.op||"replace"===e.op||"test"===e.op)&&i.hasUndefined(e.value))throw new o.JsonPatchError("Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)","OPERATION_VALUE_CANNOT_CONTAIN_UNDEFINED",t,e,r);if(r)if("add"==e.op){var a=e.path.split("/").length,s=n.split("/").length;if(a!==s+1&&a!==s)throw new o.JsonPatchError("Cannot perform an `add` operation at the desired path","OPERATION_PATH_CANNOT_ADD",t,e,r)}else if("replace"===e.op||"remove"===e.op||"_get"===e.op){if(e.path!==n)throw new o.JsonPatchError("Cannot perform the operation at a path that does not exist","OPERATION_PATH_UNRESOLVABLE",t,e,r)}else if("move"===e.op||"copy"===e.op){var h=l([{op:"_get",path:e.from,value:void 0}],r);if(h&&"OPERATION_PATH_UNRESOLVABLE"===h.name)throw new o.JsonPatchError("Cannot perform the operation from a path that does not exist","OPERATION_FROM_UNRESOLVABLE",t,e,r)}}function l(e,t,r){try{if(!Array.isArray(e))throw new o.JsonPatchError("Patch sequence must be an array","SEQUENCE_NOT_AN_ARRAY");if(t)u(i._deepClone(t),i._deepClone(e),r||!0);else{r=r||d;for(var n=0;n<e.length;n++)r(e[n],n,t,void 0)}}catch(e){if(e instanceof o.JsonPatchError)return e;throw e}}o.getValueByPointer=h,o.applyOperation=c,o.applyPatch=u,o.applyReducer=f,o.validator=d,o.validate=l,o.default={JsonPatchError:o.JsonPatchError,deepClone:o.deepClone,getValueByPointer:h,applyOperation:c,applyPatch:u,applyReducer:f,validator:d,validate:l}},
"0c8122087b": function _(r,t,e,n,f){var i=Array.isArray,o=Object.keys,u=Object.prototype.hasOwnProperty;t.exports=function r(t,e){if(t===e)return!0;if(t&&e&&"object"==typeof t&&"object"==typeof e){var n,f,a,c=i(t),g=i(e);if(c&&g){if((f=t.length)!=e.length)return!1;for(n=f;0!=n--;)if(!r(t[n],e[n]))return!1;return!0}if(c!=g)return!1;var p=t instanceof Date,s=e instanceof Date;if(p!=s)return!1;if(p&&s)return t.getTime()==e.getTime();var y=t instanceof RegExp,l=e instanceof RegExp;if(y!=l)return!1;if(y&&l)return t.toString()==e.toString();var h=o(t);if((f=h.length)!==o(e).length)return!1;for(n=f;0!=n--;)if(!u.call(e,h[n]))return!1;for(n=f;0!=n--;)if(!r(t[a=h[n]],e[a]))return!1;return!0}return t!=t&&e!=e}},
"0eae77d68f": function _(e,i,t,n,d){n();const s=e("@bokehjs/models/layouts/html_box"),l=e("80a6464b1f"),o=window.Jupyter;class a extends l.PanelHTMLBoxView{constructor(){super(...arguments),this.rendered=!1}render(){super.render(),this._render().then((()=>{this.rendered=!0,this.invalidate_layout(),this.notify_finished()}))}has_finished(){return this.rendered&&super.has_finished()}async _render(){const{spec:e,state:i}=this.model.bundle;let t;if(null!=o&&null!=o.notebook?t=o.notebook.kernel.widget_manager:null!=window.PyViz.widget_manager&&(t=window.PyViz.widget_manager),t)if(null==this.ipyview){const n=(await t.set_state(i)).find((i=>i.model_id==e.model_id));if(null!=n){const e=await t.create_view(n,{el:this.el});if(this.ipyview=e,e.children_views)for(const i of e.children_views.views)await i;this.el.appendChild(e.el),e.trigger("displayed",e)}}else this.el.appendChild(this.ipyview.el);else console.log("Panel IPyWidget model could not find a WidgetManager")}}t.IPyWidgetView=a,a.__name__="IPyWidgetView";class r extends s.HTMLBox{constructor(e){super(e)}static init_IPyWidget(){this.prototype.default_view=a,this.define((({Any:e})=>({bundle:[e,{}]})))}}t.IPyWidget=r,r.__name__="IPyWidget",r.__module__="panel.models.ipywidget",r.init_IPyWidget()},
"0d30bea0c8": function _(e,t,r,s,n){s();const i=e("tslib"),o=e("@bokehjs/core/kinds"),d=e("@bokehjs/models/widgets/markup"),l=(0,i.__importDefault)(e("18bba7b7e1")),a=e("80a6464b1f");class h extends a.PanelMarkupView{connect_signals(){super.connect_signals();const{depth:e,hover_preview:t,theme:r}=this.model.properties;this.on_change([e,t,r],(()=>this.render()))}render(){super.render();const e=this.model.text.replace(/(\r\n|\n|\r)/gm,"");let t;try{t=window.JSON.parse(e)}catch(e){return void(this.markup_el.innerHTML="<b>Invalid JSON:</b> "+e.toString())}const r={hoverPreviewEnabled:this.model.hover_preview,theme:this.model.theme},s=null==this.model.depth?1/0:this.model.depth,n=new l.default(t,s,r).render();let i="border-radius: 5px; padding: 10px;";"dark"==this.model.theme?n.style.cssText="background-color: rgb(30, 30, 30);"+i:n.style.cssText=i,this.markup_el.append(n)}}r.JSONView=h,h.__name__="JSONView",r.JSONTheme=(0,o.Enum)("dark","light");class p extends d.Markup{constructor(e){super(e)}static init_JSON(){this.prototype.default_view=h,this.define((({Boolean:e,Int:t,Nullable:s})=>({depth:[s(t),1],hover_preview:[e,!1],theme:[r.JSONTheme,"dark"]})))}}r.JSON=p,p.__name__="JSON",p.__module__="panel.models.markup",p.init_JSON()},
"18bba7b7e1": function _(t,e,r,n,o){function i(t){return null===t?"null":typeof t}function s(t){return!!t&&"object"==typeof t}function a(t){if(void 0===t)return"";if(null===t)return"Object";if("object"==typeof t&&!t.constructor)return"Object";var e=/function ([^(]*)/.exec(t.constructor.toString());return e&&e.length>1?e[1]:""}function f(t,e,r){return"null"===t||"undefined"===t?t:("string"!==t&&"stringifiable"!==t||(r='"'+r.replace(/"/g,'\\"')+'"'),"function"===t?e.toString().replace(/[\r\n]/g,"").replace(/\{.*\}/,"")+"{\u2026}":r)}function m(t){var e="";return s(t)?(e=a(t),Array.isArray(t)&&(e+="["+t.length+"]")):e=f(i(t),t,t),e}function l(t){return"json-formatter-"+t}function d(t,e,r){var n=document.createElement(t);return e&&n.classList.add(l(e)),void 0!==r&&(r instanceof Node?n.appendChild(r):n.appendChild(document.createTextNode(String(r)))),n}n(),function(t){if("undefined"!=typeof window){var e=document.createElement("style");e.setAttribute("media","screen"),e.innerHTML=t,document.head.appendChild(e)}}('.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-row,\n.json-formatter-row a,\n.json-formatter-row a:hover {\n  color: black;\n  text-decoration: none;\n}\n.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-row .json-formatter-string,\n.json-formatter-row .json-formatter-stringifiable {\n  color: green;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-row .json-formatter-number {\n  color: blue;\n}\n.json-formatter-row .json-formatter-boolean {\n  color: red;\n}\n.json-formatter-row .json-formatter-null {\n  color: #855A00;\n}\n.json-formatter-row .json-formatter-undefined {\n  color: #ca0b69;\n}\n.json-formatter-row .json-formatter-function {\n  color: #FF20ED;\n}\n.json-formatter-row .json-formatter-date {\n  background-color: rgba(0, 0, 0, 0.05);\n}\n.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: blue;\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-bracket {\n  color: blue;\n}\n.json-formatter-row .json-formatter-key {\n  color: #00008B;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "\u25ba";\n}\n.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n.json-formatter-dark.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-dark.json-formatter-row,\n.json-formatter-dark.json-formatter-row a,\n.json-formatter-dark.json-formatter-row a:hover {\n  color: white;\n  text-decoration: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-string,\n.json-formatter-dark.json-formatter-row .json-formatter-stringifiable {\n  color: #31F031;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-number {\n  color: #66C2FF;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-boolean {\n  color: #EC4242;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-null {\n  color: #EEC97D;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-undefined {\n  color: #ef8fbe;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-function {\n  color: #FD48CB;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-date {\n  background-color: rgba(255, 255, 255, 0.05);\n}\n.json-formatter-dark.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: #027BFF;\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-bracket {\n  color: #9494FF;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-key {\n  color: #23A0DB;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "\u25ba";\n}\n.json-formatter-dark.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-dark.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n');var c=/(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/,p=/\d{2}:\d{2}:\d{2} GMT-\d{4}/,j=/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/,h=window.requestAnimationFrame||function(t){return t(),0},u={hoverPreviewEnabled:!1,hoverPreviewArrayCount:100,hoverPreviewFieldCount:5,animateOpen:!0,animateClose:!0,theme:null,useToJSON:!0,sortPropertiesBy:null},g=function(){function t(t,e,r,n){void 0===e&&(e=1),void 0===r&&(r=u),this.json=t,this.open=e,this.config=r,this.key=n,this._isOpen=null,void 0===this.config.hoverPreviewEnabled&&(this.config.hoverPreviewEnabled=u.hoverPreviewEnabled),void 0===this.config.hoverPreviewArrayCount&&(this.config.hoverPreviewArrayCount=u.hoverPreviewArrayCount),void 0===this.config.hoverPreviewFieldCount&&(this.config.hoverPreviewFieldCount=u.hoverPreviewFieldCount),void 0===this.config.useToJSON&&(this.config.useToJSON=u.useToJSON),""===this.key&&(this.key='""')}return Object.defineProperty(t.prototype,"isOpen",{get:function(){return null!==this._isOpen?this._isOpen:this.open>0},set:function(t){this._isOpen=t},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isDate",{get:function(){return this.json instanceof Date||"string"===this.type&&(c.test(this.json)||j.test(this.json)||p.test(this.json))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isUrl",{get:function(){return"string"===this.type&&0===this.json.indexOf("http")},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isArray",{get:function(){return Array.isArray(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isObject",{get:function(){return s(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isEmptyObject",{get:function(){return!this.keys.length&&!this.isArray},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"isEmpty",{get:function(){return this.isEmptyObject||this.keys&&!this.keys.length&&this.isArray},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"useToJSON",{get:function(){return this.config.useToJSON&&"stringifiable"===this.type},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hasKey",{get:function(){return void 0!==this.key},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"constructorName",{get:function(){return a(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return this.config.useToJSON&&this.json&&this.json.toJSON?"stringifiable":i(this.json)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"keys",{get:function(){if(this.isObject){var t=Object.keys(this.json);return!this.isArray&&this.config.sortPropertiesBy?t.sort(this.config.sortPropertiesBy):t}return[]},enumerable:!0,configurable:!0}),t.prototype.toggleOpen=function(){this.isOpen=!this.isOpen,this.element&&(this.isOpen?this.appendChildren(this.config.animateOpen):this.removeChildren(this.config.animateClose),this.element.classList.toggle(l("open")))},t.prototype.openAtDepth=function(t){void 0===t&&(t=1),t<0||(this.open=t,this.isOpen=0!==t,this.element&&(this.removeChildren(!1),0===t?this.element.classList.remove(l("open")):(this.appendChildren(this.config.animateOpen),this.element.classList.add(l("open")))))},t.prototype.getInlinepreview=function(){var t=this;if(this.isArray)return this.json.length>this.config.hoverPreviewArrayCount?"Array["+this.json.length+"]":"["+this.json.map(m).join(", ")+"]";var e=this.keys,r=e.slice(0,this.config.hoverPreviewFieldCount).map((function(e){return e+":"+m(t.json[e])})),n=e.length>=this.config.hoverPreviewFieldCount?"\u2026":"";return"{"+r.join(", ")+n+"}"},t.prototype.render=function(){this.element=d("div","row");var t=this.isObject?d("a","toggler-link"):d("span");if(this.isObject&&!this.useToJSON&&t.appendChild(d("span","toggler")),this.hasKey&&t.appendChild(d("span","key",this.key+":")),this.isObject&&!this.useToJSON){var e=d("span","value"),r=d("span"),n=d("span","constructor-name",this.constructorName);if(r.appendChild(n),this.isArray){var o=d("span");o.appendChild(d("span","bracket","[")),o.appendChild(d("span","number",this.json.length)),o.appendChild(d("span","bracket","]")),r.appendChild(o)}e.appendChild(r),t.appendChild(e)}else{(e=this.isUrl?d("a"):d("span")).classList.add(l(this.type)),this.isDate&&e.classList.add(l("date")),this.isUrl&&(e.classList.add(l("url")),e.setAttribute("href",this.json));var i=f(this.type,this.json,this.useToJSON?this.json.toJSON():this.json);e.appendChild(document.createTextNode(i)),t.appendChild(e)}if(this.isObject&&this.config.hoverPreviewEnabled){var s=d("span","preview-text");s.appendChild(document.createTextNode(this.getInlinepreview())),t.appendChild(s)}var a=d("div","children");return this.isObject&&a.classList.add(l("object")),this.isArray&&a.classList.add(l("array")),this.isEmpty&&a.classList.add(l("empty")),this.config&&this.config.theme&&this.element.classList.add(l(this.config.theme)),this.isOpen&&this.element.classList.add(l("open")),this.element.appendChild(t),this.element.appendChild(a),this.isObject&&this.isOpen&&this.appendChildren(),this.isObject&&!this.useToJSON&&t.addEventListener("click",this.toggleOpen.bind(this)),this.element},t.prototype.appendChildren=function(e){var r=this;void 0===e&&(e=!1);var n=this.element.querySelector("div."+l("children"));if(n&&!this.isEmpty)if(e){var o=0,i=function(){var e=r.keys[o],s=new t(r.json[e],r.open-1,r.config,e);n.appendChild(s.render()),(o+=1)<r.keys.length&&(o>10?i():h(i))};h(i)}else this.keys.forEach((function(e){var o=new t(r.json[e],r.open-1,r.config,e);n.appendChild(o.render())}))},t.prototype.removeChildren=function(t){void 0===t&&(t=!1);var e=this.element.querySelector("div."+l("children"));if(t){var r=0,n=function(){e&&e.children.length&&(e.removeChild(e.children[0]),(r+=1)>10?n():h(n))};h(n)}else e&&(e.innerHTML="")},t}();r.default=g},
"be9f51fc39": function _(e,t,s,o,i){o();const n=e("@bokehjs/core/bokeh_events"),d=e("@bokehjs/models/layouts/html_box"),a=e("80a6464b1f");class h extends n.ModelEvent{constructor(e){super(),this.data=e,this.event_name="json_edit"}_to_json(){return{model:this.origin,data:this.data}}}s.JSONEditEvent=h,h.__name__="JSONEditEvent";class m extends a.PanelHTMLBoxView{connect_signals(){super.connect_signals();const{data:e,disabled:t,templates:s,menu:o,mode:i,search:n,schema:d}=this.model.properties;this.on_change([e],(()=>this.editor.update(this.model.data))),this.on_change([s],(()=>{this.editor.options.templates=this.model.templates})),this.on_change([o],(()=>{this.editor.options.menu=this.model.menu})),this.on_change([n],(()=>{this.editor.options.search=this.model.search})),this.on_change([d],(()=>{this.editor.options.schema=this.model.schema})),this.on_change([t,i],(()=>{const e=this.model.disabled?"view":this.model.mode;this.editor.setMode(e)}))}remove(){super.remove(),this.editor.destroy()}render(){super.render();const e=this.model.disabled?"view":this.model.mode;this.editor=new window.JSONEditor(this.el,{menu:this.model.menu,mode:e,onChangeJSON:e=>{this.model.data=e},onSelectionChange:(e,t)=>{this.model.selection=[e,t]},search:this.model.search,schema:this.model.schema,templates:this.model.templates}),this.editor.set(this.model.data)}}s.JSONEditorView=m,m.__name__="JSONEditorView";class r extends d.HTMLBox{constructor(e){super(e)}static init_JSONEditor(){this.prototype.default_view=m,this.define((({Any:e,Array:t,Boolean:s,String:o})=>({data:[e,{}],mode:[o,"tree"],menu:[s,!0],search:[s,!0],selection:[t(e),[]],schema:[e,null],templates:[t(e),[]]})))}}s.JSONEditor=r,r.__name__="JSONEditor",r.__module__="panel.models.json_editor",r.init_JSONEditor()},
"1767172ffa": function _(e,t,i,s,l){s();const n=e("tslib"),o=e("@bokehjs/models/widgets/input_widget"),a=(0,n.__importStar)(e("@bokehjs/styles/buttons.css")),h=a,d=e("@bokehjs/core/dom"),_=e("@bokehjs/core/enums");class r extends o.InputWidgetView{constructor(){super(...arguments),this._downloadable=!1,this._embed=!1,this._prev_href="",this._prev_download=""}initialize(){super.initialize(),this.model.data&&this.model.filename&&(this._embed=!0)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.button_type.change,(()=>this._update_button_style())),this.connect(this.model.properties.filename.change,(()=>this._update_download())),this.connect(this.model.properties._transfers.change,(()=>this._handle_click())),this.connect(this.model.properties.label.change,(()=>this._update_label())),this.connect(this.model.properties.disabled.change,(()=>this.set_disabled()))}render(){super.render(),this.group_el.style.display="flex",this.group_el.style.alignItems="stretch",this.anchor_el=document.createElement("a"),this._update_button_style(),this._update_label(),this.model.disabled?(this.anchor_el.setAttribute("disabled",""),this._downloadable=!1):(this.anchor_el.removeAttribute("disabled"),this._prev_download&&(this.anchor_el.download=this._prev_download),this._prev_href&&(this.anchor_el.href=this._prev_href),this.anchor_el.download&&this.anchor_el.download&&(this._downloadable=!0)),this._embed?this._make_link_downloadable():(this._click_listener=this._increment_clicks.bind(this),this.anchor_el.addEventListener("click",this._click_listener)),this.group_el.appendChild(this.anchor_el),this.input_el=(0,d.input)({type:"bk_btn, bk_btn_type"}),this.input_el.addEventListener("change",(()=>this.change_input()))}styles(){return[...super.styles(),a.default]}_increment_clicks(){this.model.clicks=this.model.clicks+1}_handle_click(){!this.model.auto&&this._downloadable||(this._make_link_downloadable(),!this._embed&&this.model.auto&&(this.anchor_el.removeEventListener("click",this._click_listener),this.anchor_el.click(),this.anchor_el.removeAttribute("href"),this.anchor_el.removeAttribute("download"),this.anchor_el.addEventListener("click",this._click_listener)),this._prev_href=this.anchor_el.getAttribute("href"),this._prev_download=this.anchor_el.getAttribute("download"))}_make_link_downloadable(){this._update_href(),this._update_download(),this.anchor_el.download&&this.anchor_el.href&&(this._downloadable=!0)}_update_href(){if(this.model.data){const e=function(e){const t=atob(e.split(",")[1]),i=e.split(",")[0].split(":")[1].split(";")[0],s=new ArrayBuffer(t.length),l=new Uint8Array(s);for(let e=0;e<t.length;e++)l[e]=t.charCodeAt(e);return new Blob([s],{type:i})}(this.model.data);this.anchor_el.href=URL.createObjectURL(e)}}_update_download(){this.model.filename&&(this.anchor_el.download=this.model.filename)}_update_label(){this.anchor_el.textContent=this.model.label}_update_button_style(){const e=h[`btn_${this.model.button_type}`];if(this.anchor_el.hasAttribute("class")){const t=this.anchor_el.classList.item(1);t&&this.anchor_el.classList.replace(t,e)}else this.anchor_el.classList.add(h.btn),this.anchor_el.classList.add(e)}set_disabled(){this.model.disabled?this.anchor_el.setAttribute("disabled",""):this.anchor_el.removeAttribute("disabled")}}i.FileDownloadView=r,r.__name__="FileDownloadView";class c extends o.InputWidget{constructor(e){super(e)}static init_FileDownload(){this.prototype.default_view=r,this.define((({Boolean:e,Int:t,Nullable:i,String:s})=>({auto:[e,!1],clicks:[t,0],data:[i(s),null],label:[s,"Download"],filename:[i(s),null],button_type:[_.ButtonType,"default"],_transfers:[t,0]}))),this.override({title:""})}}i.FileDownload=c,c.__name__="FileDownload",c.__module__="panel.models.widgets",c.init_FileDownload()},
"7b859fb3cf": function _(e,t,i,a,n){a();const s=e("@bokehjs/models/widgets/markup"),r=e("80a6464b1f");class l extends r.PanelMarkupView{render(){super.render(),this.markup_el.innerHTML=this.model.text,window.renderMathInElement&&window.renderMathInElement(this.el,{delimiters:[{left:"$$",right:"$$",display:!0},{left:"\\[",right:"\\]",display:!0},{left:"$",right:"$",display:!1},{left:"\\(",right:"\\)",display:!1}]})}}i.KaTeXView=l,l.__name__="KaTeXView";class d extends s.Markup{constructor(e){super(e)}static init_KaTeX(){this.prototype.default_view=l}}i.KaTeX=d,d.__name__="KaTeX",d.__module__="panel.models.katex",d.init_KaTeX()},
"0c52a301f3": function _(e,o,t,i,h){i();const a=e("@bokehjs/core/view"),s=e("@bokehjs/model");class n extends a.View{initialize(){super.initialize(),this.model.pathname=window.location.pathname,this.model.search=window.location.search,this.model.hash=window.location.hash,this.model.href=window.location.href,this.model.hostname=window.location.hostname,this.model.protocol=window.location.protocol,this.model.port=window.location.port,this._hash_listener=()=>{this.model.hash=window.location.hash},window.addEventListener("hashchange",this._hash_listener)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.pathname.change,(()=>this.update("pathname"))),this.connect(this.model.properties.search.change,(()=>this.update("search"))),this.connect(this.model.properties.hash.change,(()=>this.update("hash"))),this.connect(this.model.properties.reload.change,(()=>this.update("reload")))}remove(){super.remove(),window.removeEventListener("hashchange",this._hash_listener)}update(e){this.model.reload&&"reload"!==e?("pathname"==e&&(window.location.pathname=this.model.pathname),"search"==e&&(window.location.search=this.model.search),"hash"==e&&(window.location.hash=this.model.hash)):(window.history.pushState({},"",`${this.model.pathname}${this.model.search}${this.model.hash}`),this.model.href=window.location.href,"reload"===e&&window.location.reload())}}t.LocationView=n,n.__name__="LocationView";class l extends s.Model{constructor(e){super(e)}static init_Location(){this.prototype.default_view=n,this.define((({Boolean:e,String:o})=>({href:[o,""],hostname:[o,""],pathname:[o,""],protocol:[o,""],port:[o,""],search:[o,""],hash:[o,""],reload:[e,!1]})))}}t.Location=l,l.__name__="Location",l.__module__="panel.models.location",l.init_Location()},
"0c21036737": function _(e,t,a,i,s){i();const h=e("@bokehjs/models/widgets/markup"),_=e("80a6464b1f");class n extends _.PanelMarkupView{initialize(){super.initialize(),this._hub=window.MathJax.Hub,this._hub.Config({tex2jax:{inlineMath:[["$","$"],["\\(","\\)"]]}})}render(){super.render(),this._hub&&(this.markup_el.innerHTML=this.model.text,this._hub.Queue(["Typeset",this._hub,this.markup_el]))}}a.MathJaxView=n,n.__name__="MathJaxView";class u extends h.Markup{constructor(e){super(e)}static init_MathJax(){this.prototype.default_view=n}}a.MathJax=u,u.__name__="MathJax",u.__module__="panel.models.mathjax",u.init_MathJax()},
"4ae96bd77b": function _(e,t,s,i,n){i();const l=e("@bokehjs/models/layouts/html_box"),o=e("@bokehjs/core/dom"),r=e("@bokehjs/models/sources/column_data_source"),a=e("80a6464b1f"),c={"material-dark":"Material Dark",material:"Material Light","material-dense":"Material Light","material-dense-dark":"Material Dark",vaporwave:"Vaporwave",solarized:"Solarized","solarized-dark":"Solarized Dark",monokai:"Monokai"},h={datagrid:"Datagrid",d3_x_bar:"X Bar",d3_y_bar:"Y Bar",d3_xy_line:"X/Y Line",d3_y_line:"Y Line",d3_y_area:"Y Area",d3_y_scatter:"Y Scatter",d3_xy_scatter:"X/Y Scatter",d3_treemap:"Treemap",d3_candlestick:"Candlestick",d3_sunburst:"Sunburst",d3_heatmap:"Heatmap",d3_ohlc:"OHLC"};function p(e){const t={};return Object.keys(e).forEach((s=>{t[e[s]]=s})),t}const _=p(h),d=p(c);class m extends a.PanelHTMLBoxView{constructor(){super(...arguments),this._updating=!1,this._config_listener=null,this._current_config=null,this._event_listener=null,this._loaded=!1}connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,(()=>this.setData())),this.connect(this.model.properties.toggle_config.change,(()=>{this.perspective_element.toggleConfig(),this.fix_layout()})),this.connect(this.model.properties.columns.change,(()=>{this.perspective_element.restore({columns:this.model.columns})})),this.connect(this.model.properties.expressions.change,(()=>{this.perspective_element.restore({expressions:this.model.expressions})})),this.connect(this.model.properties.split_by.change,(()=>{this.perspective_element.restore({split_by:this.model.split_by})})),this.connect(this.model.properties.group_by.change,(()=>{this.perspective_element.restore({group_by:this.model.group_by})})),this.connect(this.model.properties.aggregates.change,(()=>{this.perspective_element.restore({aggregates:this.model.aggregates})})),this.connect(this.model.properties.filters.change,(()=>{this.perspective_element.restore({filter:this.model.filters})})),this.connect(this.model.properties.sort.change,(()=>{this.perspective_element.restore({sort:this.model.sort})})),this.connect(this.model.properties.plugin.change,(()=>{this.perspective_element.restore({plugin:h[this.model.plugin]})})),this.connect(this.model.properties.selectable.change,(()=>{this.perspective_element.restore({plugin_config:Object.assign(Object.assign({},this._current_config),{selectable:this.model.selectable})})})),this.connect(this.model.properties.editable.change,(()=>{this.perspective_element.restore({plugin_config:Object.assign(Object.assign({},this._current_config),{editable:this.model.editable})})})),this.connect(this.model.properties.theme.change,(()=>{this.perspective_element.restore({theme:c[this.model.theme]}).catch((()=>{}))})),null!=this.model.document&&(this._event_listener=e=>this.on_event(e),this.model.document.on_change(this._event_listener))}disconnect_signals(){null!=this._config_listener&&this.perspective_element.removeEventListener("perspective-config-update",this._config_listener),this._config_listener=null,null!=this.model.document&&null!=this._event_listener&&this.model.document.remove_on_change(this._event_listener),this._event_listener=null,super.disconnect_signals()}async render(){super.render(),this.worker=window.perspective.worker(),this.table=await this.worker.table(this.model.schema),this.table.update(this.data);const e=(0,o.div)({class:"pnx-perspective-viewer",style:{zIndex:0}});(0,a.set_size)(e,this.model),e.innerHTML="<perspective-viewer style='height:100%; width:100%;'></perspective-viewer>",this.perspective_element=e.children[0],this.perspective_element.resetThemes([...Object.values(c)]).catch((()=>{})),(0,a.set_size)(this.perspective_element,this.model),this.el.appendChild(e),this.perspective_element.load(this.table);const t=Object.assign(Object.assign({},this.model.plugin_config),{editable:this.model.editable,selectable:this.model.selectable});this.perspective_element.restore({aggregates:this.model.aggregates,columns:this.model.columns,expressions:this.model.expressions,filter:this.model.filters,split_by:this.model.split_by,group_by:this.model.group_by,plugin:h[this.model.plugin],plugin_config:t,sort:this.model.sort,theme:c[this.model.theme]}).catch((()=>{})),this._config_listener=()=>this.sync_config(),this._current_config=await this.perspective_element.save(),this.model.toggle_config&&this.perspective_element.toggleConfig(),this.perspective_element.addEventListener("perspective-config-update",this._config_listener),this._loaded=!0,this.fix_layout()}fix_layout(){this.update_layout(),this.compute_layout(),this.invalidate_layout()}sync_config(){return this._updating||this.perspective_element.save().then((e=>{this._current_config=e;const t={};for(let s in e){let i=e[s];void 0===i||"plugin"==s&&"debug"===i||"settings"===s||("filter"===s?s="filters":"plugin"===s?i=_[i]:"theme"===s&&(i=d[i]),t[s]=i)}this._updating=!0,this.model.setv(t),this._updating=!1})),!0}on_event(e){null!=(e=e.hint)&&null!=e.column_source&&e.column_source.id==this.model.source.id&&(void 0!==e.rollover?this.stream(e.data,e.rollover):void 0!==e.patches&&this.patch(e.patches))}get data(){const e={};for(const t of this.model.source.columns())e[t]=this.model.source.get_array(t);return e}stream(e,t){this._loaded&&(null==t?this.table.update(e):this.table.replace(this.data))}patch(e){this.table.replace(this.data)}setData(){this._loaded&&this.table.load(this.data)}}s.PerspectiveView=m,m.__name__="PerspectiveView";class g extends l.HTMLBox{constructor(e){super(e)}static init_Perspective(){this.prototype.default_view=m,this.define((({Any:e,Array:t,Boolean:s,Ref:i,Nullable:n,String:l})=>({aggregates:[e],columns:[t(n(l))],expressions:[n(t(l))],split_by:[n(t(l))],editable:[n(s)],filters:[n(t(e))],group_by:[n(t(l))],plugin:[l],plugin_config:[e],selectable:[n(s)],schema:[e,{}],toggle_config:[s,!0],sort:[n(t(t(l)))],source:[i(r.ColumnDataSource)],theme:[l]})))}}s.Perspective=g,g.__name__="Perspective",g.__module__="panel.models.perspective",g.init_Perspective()},
"588a5ae70d": function _(e,t,i,s,o){s();const l=e("@bokehjs/core/kinds"),n=e("@bokehjs/core/dom"),a=e("@bokehjs/models/widgets/widget");function r(e){e.forEach((e=>e.style.borderStyle="inset"))}function d(e){e.forEach((e=>e.style.borderStyle="outset"))}class h extends a.WidgetView{constructor(){super(...arguments),this._changing=!1}connect_signals(){super.connect_signals(),this.connect(this.model.properties.direction.change,(()=>this.set_direction())),this.connect(this.model.properties.value.change,(()=>this.render())),this.connect(this.model.properties.loop_policy.change,(()=>this.set_loop_state(this.model.loop_policy))),this.connect(this.model.properties.disabled.change,(()=>this.toggle_disable())),this.connect(this.model.properties.show_loop_controls.change,(()=>{this.model.show_loop_controls&&this.loop_state.parentNode!=this.groupEl?this.groupEl.appendChild(this.loop_state):this.model.show_loop_controls||this.loop_state.parentNode!=this.groupEl||this.groupEl.removeChild(this.loop_state)}))}toggle_disable(){this.sliderEl.disabled=this.model.disabled;for(const e of this.buttonEl.children){e.disabled=this.model.disabled}for(const e of this.loop_state.children)if("input"==e.tagName){e.disabled=this.model.disabled}}get_height(){return 250}render(){if(null!=this.sliderEl)return this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),void(this.sliderEl.value=String(this.model.value));super.render(),this.groupEl=(0,n.div)(),this.groupEl.style.display="flex",this.groupEl.style.flexDirection="column",this.groupEl.style.alignItems="center",this.sliderEl=document.createElement("input"),this.sliderEl.style.width="100%",this.sliderEl.setAttribute("type","range"),this.sliderEl.value=String(this.model.value),this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),this.sliderEl.addEventListener("input",(e=>{this.set_frame(parseInt(e.target.value),!1)})),this.sliderEl.addEventListener("change",(e=>{this.set_frame(parseInt(e.target.value))}));const e=(0,n.div)();this.buttonEl=e,e.style.cssText="margin: 0 auto; display: flex; padding: 5px; align-items: stretch; width: 100%;";const t="text-align: center; min-width: 20px; flex-grow: 1; margin: 2px",i="text-align: center; min-width: 40px; flex-grow: 2; margin: 2px",s=document.createElement("button");s.style.cssText=t,s.appendChild(document.createTextNode("\u2013")),s.onclick=()=>this.slower(),e.appendChild(s);const o=document.createElement("button");o.style.cssText=i,o.appendChild(document.createTextNode("\u275a\u25c0\u25c0")),o.onclick=()=>this.first_frame(),e.appendChild(o);const l=document.createElement("button");l.style.cssText=i,l.appendChild(document.createTextNode("\u275a\u25c0")),l.onclick=()=>this.previous_frame(),e.appendChild(l);const a=document.createElement("button");a.style.cssText=i,a.appendChild(document.createTextNode("\u25c0")),a.onclick=()=>this.reverse_animation(),e.appendChild(a);const h=document.createElement("button");h.style.cssText=i,h.appendChild(document.createTextNode("\u275a\u275a")),h.onclick=()=>this.pause_animation(),e.appendChild(h);const c=document.createElement("button");c.style.cssText=i,c.appendChild(document.createTextNode("\u25b6")),c.onclick=()=>this.play_animation(),e.appendChild(c);const p=document.createElement("button");p.style.cssText=i,p.appendChild(document.createTextNode("\u25b6\u275a")),p.onclick=()=>this.next_frame(),e.appendChild(p);const m=document.createElement("button");m.style.cssText=i,m.appendChild(document.createTextNode("\u25b6\u25b6\u275a")),m.onclick=()=>this.last_frame(),e.appendChild(m);const _=document.createElement("button");_.style.cssText=t,_.appendChild(document.createTextNode("+")),_.onclick=()=>this.faster(),e.appendChild(_),this._toggle_reverse=()=>{d([h,c]),r([a])},this._toogle_pause=()=>{d([a,c]),r([h])},this._toggle_play=()=>{d([a,h]),r([c])},this.loop_state=document.createElement("form"),this.loop_state.style.cssText="margin: 0 auto; display: table";const u=document.createElement("input");u.type="radio",u.value="once",u.name="state";const g=document.createElement("label");g.innerHTML="Once",g.style.cssText="padding: 0 10px 0 5px; user-select:none;";const f=document.createElement("input");f.setAttribute("type","radio"),f.setAttribute("value","loop"),f.setAttribute("name","state");const v=document.createElement("label");v.innerHTML="Loop",v.style.cssText="padding: 0 10px 0 5px; user-select:none;";const E=document.createElement("input");E.setAttribute("type","radio"),E.setAttribute("value","reflect"),E.setAttribute("name","state");const y=document.createElement("label");y.innerHTML="Reflect",y.style.cssText="padding: 0 10px 0 5px; user-select:none;","once"==this.model.loop_policy?u.checked=!0:"loop"==this.model.loop_policy?f.checked=!0:E.checked=!0,this.loop_state.appendChild(u),this.loop_state.appendChild(g),this.loop_state.appendChild(f),this.loop_state.appendChild(v),this.loop_state.appendChild(E),this.loop_state.appendChild(y),this.groupEl.appendChild(this.sliderEl),this.groupEl.appendChild(e),this.model.show_loop_controls&&this.groupEl.appendChild(this.loop_state),this.toggle_disable(),this.el.appendChild(this.groupEl)}set_frame(e,t=!0){this.model.value=e,t&&(this.model.value_throttled=e),this.sliderEl.value!=String(e)&&(this.sliderEl.value=String(e))}get_loop_state(){for(var e=this.loop_state.state,t=0;t<e.length;t++){var i=e[t];if(i.checked)return i.value}return"once"}set_loop_state(e){for(var t=this.loop_state.state,i=0;i<t.length;i++){var s=t[i];s.value==e&&(s.checked=!0)}}next_frame(){this.set_frame(Math.min(this.model.end,this.model.value+this.model.step))}previous_frame(){this.set_frame(Math.max(this.model.start,this.model.value-this.model.step))}first_frame(){this.set_frame(this.model.start)}last_frame(){this.set_frame(this.model.end)}slower(){this.model.interval=Math.round(this.model.interval/.7),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}faster(){this.model.interval=Math.round(.7*this.model.interval),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}anim_step_forward(){if(this.model.value<this.model.end)this.next_frame();else{var e=this.get_loop_state();"loop"==e?this.first_frame():"reflect"==e?(this.last_frame(),this.reverse_animation()):(this.pause_animation(),this.last_frame())}}anim_step_reverse(){if(this.model.value>this.model.start)this.previous_frame();else{var e=this.get_loop_state();"loop"==e?this.last_frame():"reflect"==e?(this.first_frame(),this.play_animation()):(this.pause_animation(),this.first_frame())}}set_direction(){this._changing||(0===this.model.direction?this.pause_animation():1===this.model.direction?this.play_animation():-1===this.model.direction&&this.reverse_animation())}pause_animation(){this._toogle_pause(),this._changing=!0,this.model.direction=0,this._changing=!1,this.timer&&(clearInterval(this.timer),this.timer=null)}play_animation(){this.pause_animation(),this._toggle_play(),this._changing=!0,this.model.direction=1,this._changing=!1,this.timer||(this.timer=setInterval((()=>this.anim_step_forward()),this.model.interval))}reverse_animation(){this.pause_animation(),this._toggle_reverse(),this._changing=!0,this.model.direction=-1,this._changing=!1,this.timer||(this.timer=setInterval((()=>this.anim_step_reverse()),this.model.interval))}}i.PlayerView=h,h.__name__="PlayerView",i.LoopPolicy=(0,l.Enum)("once","loop","reflect");class c extends a.Widget{constructor(e){super(e)}static init_Player(){this.prototype.default_view=h,this.define((({Boolean:e,Int:t})=>({direction:[t,0],interval:[t,500],start:[t,0],end:[t,10],step:[t,1],loop_policy:[i.LoopPolicy,"once"],value:[t,0],value_throttled:[t,0],show_loop_controls:[e,!0]}))),this.override({width:400})}}i.Player=c,c.__name__="Player",c.__module__="panel.models.widgets",c.init_Player()},
"42de27e56c": function _(t,e,o,i,l){i();const s=t("@bokehjs/core/dom"),r=t("@bokehjs/core/util/object"),a=t("@bokehjs/core/util/eq"),n=t("@bokehjs/models/layouts/html_box"),p=t("@bokehjs/models/sources/column_data_source"),_=t("99a25e6992"),h=t("990b5dd5c7"),u=t("80a6464b1f"),d=(t,e,o)=>{let i=Array.isArray(e)?[]:{};if("click"===o||"hover"===o||"selected"===o){const o=[];if(null==e)return null;const l=t.data;for(let t=0;t<e.points.length;t++){const i=e.points[t];let s={};for(let t in i){const e=i[t];!i.hasOwnProperty(t)||Array.isArray(e)||(0,h.isPlainObject)(e)||(s[t]=e)}null!=i&&(i.hasOwnProperty("curveNumber")&&i.hasOwnProperty("pointNumber")&&l[i.curveNumber].hasOwnProperty("customdata")&&(s.customdata=l[i.curveNumber].customdata[i.pointNumber]),i.hasOwnProperty("pointNumbers")&&(s.pointNumbers=i.pointNumbers)),o[t]=s}i.points=o}else if("relayout"===o||"restyle"===o)for(let t in e)e.hasOwnProperty(t)&&(i[t]=e[t]);return e.hasOwnProperty("range")&&(i.range=e.range),e.hasOwnProperty("lassoPoints")&&(i.lassoPoints=e.lassoPoints),i};class y extends u.PanelHTMLBoxView{constructor(){super(...arguments),this._settingViewport=!1,this._plotInitialized=!1,this._reacting=!1,this._relayouting=!1,this._end_relayouting=(0,_.debounce)((()=>{this._relayouting=!1}),2e3,!1)}initialize(){super.initialize(),this._layout_wrapper=(0,s.div)({style:"height: 100%; width: 100%;"})}connect_signals(){super.connect_signals();const{data:t,data_sources:e,layout:o,relayout:i,restyle:l}=this.model.properties;this.on_change([t,e,o],(()=>{const t=this.model._render_count;setTimeout((()=>{this.model._render_count===t&&(this.model._render_count+=1)}),250)})),this.on_change([i],(()=>{null!=this.model.relayout&&(window.Plotly.relayout(this._layout_wrapper,this.model.relayout),this.model.relayout=null)})),this.on_change([l],(()=>{null!=this.model.restyle&&(window.Plotly.restyle(this._layout_wrapper,this.model.restyle.data,this.model.restyle.traces),this.model.restyle=null)})),this.connect(this.model.properties.viewport_update_policy.change,(()=>{this._updateSetViewportFunction()})),this.connect(this.model.properties.viewport_update_throttle.change,(()=>{this._updateSetViewportFunction()})),this.connect(this.model.properties._render_count.change,(()=>{this.plot()})),this.connect(this.model.properties.frames.change,(()=>{this.plot(!0)})),this.connect(this.model.properties.viewport.change,(()=>this._updateViewportFromProperty())),this.connect(this.model.properties.visibility.change,(()=>{this.el.style.visibility=this.model.visibility?"visible":"hidden"}))}async render(){super.render(),this.el.style.visibility=this.model.visibility?"visible":"hidden",this.el.appendChild(this._layout_wrapper),await this.plot(),window.Plotly.relayout(this._layout_wrapper,this.model.relayout)}_trace_data(){const t=[];for(let e=0;e<this.model.data.length;e++)t.push(this._get_trace(e,!1));return t}_layout_data(){const t=(0,h.deepCopy)(this.model.layout);if(this._relayouting){const{layout:e}=this._layout_wrapper;Object.keys(e).reduce(((e,o)=>{"axis"===o.slice(1,5)&&"range"in e&&(t[o].range=e.range)}),{})}return t}_install_callbacks(){this._layout_wrapper.on("plotly_relayout",(t=>{!0!==t._update_from_property&&(this.model.relayout_data=d(this._layout_wrapper,t,"relayout"),this._updateViewportProperty(),this._end_relayouting())})),this._layout_wrapper.on("plotly_relayouting",(()=>{"mouseup"!==this.model.viewport_update_policy&&(this._relayouting=!0,this._updateViewportProperty())})),this._layout_wrapper.on("plotly_restyle",(t=>{this.model.restyle_data=d(this._layout_wrapper,t,"restyle"),this._updateViewportProperty()})),this._layout_wrapper.on("plotly_click",(t=>{this.model.click_data=d(this._layout_wrapper,t,"click")})),this._layout_wrapper.on("plotly_hover",(t=>{this.model.hover_data=d(this._layout_wrapper,t,"hover")})),this._layout_wrapper.on("plotly_selected",(t=>{this.model.selected_data=d(this._layout_wrapper,t,"selected")})),this._layout_wrapper.on("plotly_clickannotation",(t=>{delete t.event,delete t.fullAnnotation,this.model.clickannotation_data=t})),this._layout_wrapper.on("plotly_deselect",(()=>{this.model.selected_data=null})),this._layout_wrapper.on("plotly_unhover",(()=>{this.model.hover_data=null}))}async plot(t=!1){if(!window.Plotly)return;const e=this._trace_data(),o=this._layout_data();if(this._reacting=!0,t){const t={data:e,layout:o,config:this.model.config,frames:this.model.frames};await window.Plotly.newPlot(this._layout_wrapper,t)}else await window.Plotly.react(this._layout_wrapper,e,o,this.model.config),null!=this.model.frames&&await window.Plotly.addFrames(this._layout_wrapper,this.model.frames);var i,l;this._updateSetViewportFunction(),this._updateViewportProperty(),this._plotInitialized?(i=this._layout_wrapper,(l=window.getComputedStyle(i).display)&&"none"!==l&&window.Plotly.Plots.resize(this._layout_wrapper)):this._install_callbacks(),this._reacting=!1,this._plotInitialized=!0}after_layout(){super.after_layout(),(0,u.set_size)(this.el,this.model),window.Plotly&&this._plotInitialized&&window.Plotly.Plots.resize(this._layout_wrapper)}_get_trace(t,e){const o=(0,r.clone)(this.model.data[t]),i=this.model.data_sources[t];for(const t of i.columns()){let l=i.get_array(t)[0];if(null!=l.shape&&l.shape.length>1){const t=[],e=l.shape;for(let o=0;o<e[0];o++)t.push(l.slice(o*e[1],(o+1)*e[1]));l=t}let s=t.split("."),r=s[s.length-1],a=o;for(let t of s.slice(0,-1))a=a[t];e&&1==s.length?a[r]=[l]:a[r]=l}return o}_updateViewportFromProperty(){if(!window.Plotly||this._settingViewport||this._reacting||!this.model.viewport)return;const t=this._layout_wrapper._fullLayout;Object.keys(this.model.viewport).reduce(((e,o)=>{if((0,a.isEqual)((0,h.get)(t,o),e))return!0;{let t=(0,h.deepCopy)(this.model.viewport);return t._update_from_property=!0,this._settingViewport=!0,window.Plotly.relayout(this.el,t).then((()=>{this._settingViewport=!1})),!1}}),{})}_updateViewportProperty(){const t=this._layout_wrapper._fullLayout;let e={};for(let o in t){if(!t.hasOwnProperty(o))continue;let i=o.slice(0,5);"xaxis"!==i&&"yaxis"!==i||(e[o+".range"]=(0,h.deepCopy)(t[o].range))}(0,a.isEqual)(e,this.model.viewport)||this._setViewport(e)}_updateSetViewportFunction(){"continuous"===this.model.viewport_update_policy||"mouseup"===this.model.viewport_update_policy?this._setViewport=t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}:this._setViewport=(0,h.throttle)((t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}),this.model.viewport_update_throttle)}}o.PlotlyPlotView=y,y.__name__="PlotlyPlotView";class c extends n.HTMLBox{constructor(t){super(t)}static init_PlotlyPlot(){this.prototype.default_view=y,this.define((({Array:t,Any:e,Boolean:o,Ref:i,String:l,Nullable:s,Number:r})=>({data:[t(e),[]],layout:[e,{}],config:[e,{}],frames:[s(t(e)),null],data_sources:[t(i(p.ColumnDataSource)),[]],relayout:[s(e),{}],restyle:[s(e),{}],relayout_data:[e,{}],restyle_data:[t(e),[]],click_data:[e,{}],hover_data:[e,{}],clickannotation_data:[e,{}],selected_data:[e,{}],viewport:[e,{}],viewport_update_policy:[l,"mouseup"],viewport_update_throttle:[r,200],visibility:[o,!0],_render_count:[r,0]})))}}o.PlotlyPlot=c,c.__name__="PlotlyPlot",c.__module__="panel.models.plotly",c.init_PlotlyPlot()},
"990b5dd5c7": function _(t,n,r,e,o){e();r.get=(t,n,r)=>{const e=r=>String.prototype.split.call(n,r).filter(Boolean).reduce(((t,n)=>null!=t?t[n]:t),t),o=e(/[,[\]]+?/)||e(/[,[\].]+?/);return void 0===o||o===t?r:o},r.throttle=function(t,n){var r=0;return function(){var e=Number(new Date);e-r>=n&&(t(),r=e)}},r.deepCopy=function t(n){var r;if(null==n||"object"!=typeof n)return n;if(n instanceof Array){r=[];for(var e=0,o=n.length;e<o;e++)r[e]=t(n[e]);return r}if(n instanceof Object){const r={};for(const e in n){const o=e;n.hasOwnProperty(o)&&(r[o]=t(n[o]))}return r}throw new Error("Unable to copy obj! Its type isn't supported.")},r.isPlainObject=function(t){return"[object Object]"===Object.prototype.toString.call(t)}},
"979633320f": function _(e,s,t,i,o){i();const l=e("@bokehjs/models/layouts/html_box"),r=e("80a6464b1f");class h extends l.HTMLBoxView{connect_signals(){super.connect_signals();const e=()=>{this.render(),this.root.compute_layout()};this.connect(this.model.properties.height.change,e),this.connect(this.model.properties.width.change,e),this.connect(this.model.properties.height_policy.change,e),this.connect(this.model.properties.width_policy.change,e),this.connect(this.model.properties.sizing_mode.change,e),this.connect(this.model.properties.active.change,(()=>this.setCSS())),this.connect(this.model.properties.bar_color.change,(()=>this.setCSS())),this.connect(this.model.properties.css_classes.change,(()=>this.setCSS())),this.connect(this.model.properties.value.change,(()=>this.setValue())),this.connect(this.model.properties.max.change,(()=>this.setMax()))}render(){super.render();const e=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.progressEl=document.createElement("progress"),this.setValue(),this.setMax(),(0,r.set_size)(this.progressEl,this.model),this.setCSS();for(const s in e)this.progressEl.style.setProperty(s,e[s]);this.el.appendChild(this.progressEl)}setCSS(){let e=this.model.css_classes.join(" ")+" "+this.model.bar_color;this.model.active&&(e+=" active"),this.progressEl.className=e}setValue(){null==this.model.value?this.progressEl.value=0:this.model.value>=0?this.progressEl.value=this.model.value:this.model.value<0&&this.progressEl.removeAttribute("value"),console.log(this.progressEl)}setMax(){null!=this.model.max&&(this.progressEl.max=this.model.max)}_update_layout(){let e=void 0!==this._prev_sizing_mode&&this._prev_sizing_mode!==this.model.sizing_mode;this._prev_sizing_mode=this.model.sizing_mode,this.layout=new r.CachedVariadicBox(this.el,this.model.sizing_mode,e),this.layout.set_sizing(this.box_sizing())}}t.ProgressView=h,h.__name__="ProgressView";class n extends l.HTMLBox{constructor(e){super(e)}static init_Progress(){this.prototype.default_view=h,this.define((({Any:e,Boolean:s,Number:t,String:i})=>({active:[s,!0],bar_color:[i,"primary"],style:[e,{}],max:[t,100],value:[e,null]})))}}t.Progress=n,n.__name__="Progress",n.__module__="panel.models.widgets",n.init_Progress()},
"d51a79a0a3": function _(t,e,i,l,o){l();const s=t("@bokehjs/core/dom"),n=t("@bokehjs/models/layouts/html_box"),h=t("80a6464b1f");class a extends h.PanelHTMLBoxView{initialize(){super.initialize(),this._container=(0,s.div)({})}connect_signals(){super.connect_signals(),this.connect(this.model.properties.disabled.change,(()=>this.quill.enable(!this.model.disabled))),this.connect(this.model.properties.text.change,(()=>{this._editing||(this._editing=!0,this.quill.enable(!1),this.quill.setContents([]),this.quill.clipboard.dangerouslyPasteHTML(this.model.text),this.quill.enable(!this.model.disabled),this._editing=!1)}));const{mode:t,toolbar:e,placeholder:i}=this.model.properties;this.on_change([i],(()=>{this.quill.root.setAttribute("data-placeholder",this.model.placeholder)})),this.on_change([t,e],(()=>{this.render(),this._layout_toolbar()}))}_layout_toolbar(){if(null==this._toolbar)this.el.style.removeProperty("padding-top");else{const t=this._toolbar.getBoundingClientRect().height+1;this.el.style.paddingTop=t+"px",this._toolbar.style.marginTop=-t+"px"}}render(){super.render(),this.el.appendChild(this._container);const t="bubble"===this.model.mode?"bubble":"snow";this.quill=new window.Quill(this._container,{modules:{toolbar:this.model.toolbar},readOnly:!0,placeholder:this.model.placeholder,theme:t}),this._editor=this.el.querySelector(".ql-editor"),this._toolbar=this.el.querySelector(".ql-toolbar"),this.quill.clipboard.dangerouslyPasteHTML(this.model.text),this.quill.on("text-change",(()=>{this._editing||(this._editing=!0,this.model.text=this._editor.innerHTML,this._editing=!1)})),this.model.disabled||this.quill.enable(!this.model.disabled)}after_layout(){super.after_layout(),this._layout_toolbar()}}i.QuillInputView=a,a.__name__="QuillInputView";class d extends n.HTMLBox{constructor(t){super(t)}static init_QuillInput(){this.prototype.default_view=a,this.define((({Any:t,String:e})=>({mode:[e,"toolbar"],placeholder:[e,""],text:[e,""],toolbar:[t,null]}))),this.override({height:300})}}i.QuillInput=d,d.__name__="QuillInput",d.__module__="panel.models.quill",d.init_QuillInput()},
"ad426de39c": function _(e,t,n,s,i){s();const o=e("6f11f2ef27"),l=e("4c02a9b43f"),r=e("b3f51db71c"),c=e("@bokehjs/core/build_views"),a=e("@bokehjs/core/util/types"),d=e("@bokehjs/models/layouts/html_box"),h=e("@bokehjs/core/dom"),_=e("@bokehjs/core/util/color"),u=e("7f7d9e0c6b"),p=e("d92f7d4d2b"),m=e("3d7593ca5a"),f=e("80a6464b1f");function v(e,t,n){const s={};for(const e of n)s[`{${e}}`]="(.*)";const i=[];let o="^"+(e.replace(/[-\/\\^$*+?.()|[\]]/g,"\\$&")+"$");let l,r,c;for(const t in s)if(r=e.indexOf(t),r>-1){for(o=o.replace(t,s[t]),c={index:r,token:t},l=0;l<i.length&&i[l].index<r;l++);l<i.length?i.splice(l,0,c):i.push(c)}o=o.replace(/\{[^{}]+\}/g,".*");var a=new RegExp(o).exec(t);let d=null;if(a)for(d={},l=0;l<i.length;l++)d[i[l].token.slice(1,-1)]=a[l+1];return d}class g extends f.PanelHTMLBoxView{constructor(){super(...arguments),this._parent=null,this._changing=!1,this._event_listeners={},this._mutation_observers=[],this._script_fns={},this._state={}}initialize(){super.initialize(),this.html=(0,m.htmlDecode)(this.model.html)||this.model.html}_recursive_connect(e,t,n){for(const s in e.properties){let i;i=n.length?`${n}.${s}`:s;const o=e[s];null!=o&&(null!=o.properties&&this._recursive_connect(o,!0,i),this.connect(e.properties[s].change,(()=>{if(t)for(const t in this.model.children)if(this.model.children[t]==s){let n=e[s];return(0,a.isArray)(n)||(n=[n]),this._render_node(t,n),void this.invalidate_layout()}this._changing||(this._update(i),this.invalidate_layout())})))}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,(async()=>{this.html=(0,m.htmlDecode)(this.model.html)||this.model.html,await this.rebuild(),this.invalidate_layout()})),this._recursive_connect(this.model.data,!0,""),this.connect(this.model.properties.events.change,(()=>{this._remove_event_listeners(),this._setup_event_listeners()})),this.connect_scripts()}connect_scripts(){const e=this.model.data.id;for(let t in this.model.scripts){const n=this.model.scripts[t];let s,i=this.model.data;if(t.indexOf(".")>=0){const e=t.split(".");s=e[e.length-1];for(const t of e.slice(0,-1))i=i[t]}else s=t;for(const o of n){const n=(0,m.htmlDecode)(o)||o,l=this._render_script(n,e);this._script_fns[t]=l;const r=i.properties[s];null!=r&&this.connect(r.change,(()=>{this._changing||this.run_script(t)}))}}}run_script(e,t=!1){const n=this._script_fns[e];if(void 0===n)return void(t||console.log(`Script '${e}' could not be found.`));const s={get_records:(e,t)=>this.get_records(e,t)};for(const e in this._script_fns)s[e]=()=>this.run_script(e);return n(this.model,this.model.data,this._state,this,(e=>this.run_script(e)),s)}get_records(e,t=!0){return(0,u.dict_to_records)(this.model.data[e],t)}disconnect_signals(){super.disconnect_signals(),this._remove_event_listeners(),this._remove_mutation_observers(),this.run_script("remove",!0)}get child_models(){const e=[];for(const t in this.model.children)for(const n of this.model.children[t])"string"!=typeof n&&e.push(n);return e}async build_child_views(){await(0,c.build_views)(this._child_views,this.child_models,{parent:null})}compute_layout(){this.root!=this?super.compute_layout():(this.update_position(),this.after_layout(),this.notify_finished())}after_layout(){for(const e of this.child_views)e.after_layout();this.run_script("after_layout",!0),this._has_finished=!0}update_layout(){for(const e of this.child_views)this._align_view(e),e.compute_viewport(),e.update_layout(),e.compute_layout();this.root!=this&&this._update_layout()}_align_view(e){const{align:t}=e.model;let n,s;(0,a.isArray)(t)?[n,s]=t:n=s=t,"center"===n?(e.el.style.marginLeft="auto",e.el.style.marginRight="auto"):"end"===n&&(e.el.style.marginLeft="auto"),"center"===s?(e.el.style.marginTop="auto",e.el.style.marginBottom="auto"):"end"===s&&(e.el.style.marginTop="auto")}render(){(0,h.empty)(this.el);const{background:e}=this.model;this.el.style.backgroundColor=null!=e?(0,_.color2css)(e):"",(0,h.classes)(this.el).clear().add(...this.css_classes()),this._update(),this._render_children(),this._setup_mutation_observers(),this._setup_event_listeners(),this.run_script("render",!0)}_send_event(e,t,n){let s=(0,p.serializeEvent)(n);s.type=t;for(const e in s)void 0===s[e]&&delete s[e];this.model.trigger_event(new m.DOMEvent(e,s))}_render_child(e,t){const n=this._child_views.get(e);null==n?t.innerHTML=(0,m.htmlDecode)(e)||e:(n._parent=this,n.renderTo(t))}resize_layout(){null!=this._parent&&this._parent.resize_layout(),this.root!=this&&super.resize_layout()}invalidate_layout(){null!=this._parent&&this._parent.invalidate_layout(),this.root!=this&&this.root.has_finished()&&super.invalidate_layout()}update_position(){if(this.root!=this)return void super.update_position();this.el.style.display=this.model.visible?"block":"none",(0,f.set_size)(this.el,this.model);let{margin:e}=this.model,t=null;if(null==e)this.el.style.margin="";else{if((0,a.isNumber)(e))t={top:e,right:e,bottom:e,left:e};else if(2==e.length){const[n,s]=e;t={top:n,right:s,bottom:n,left:s}}else{const[n,s,i,o]=e;t={top:n,right:s,bottom:i,left:o}}const{top:n,right:s,bottom:i,left:o}=t;this.el.style.padding=`${n}px ${s}px ${i}px ${o}px`}for(const e of this.child_views)e.update_position()}_render_node(e,t){const n=this.model.data.id;if(this.model.looped.indexOf(e)>-1)for(let s=0;s<t.length;s++){let i=document.getElementById(`${e}-${s}-${n}`);null!=i?this._render_child(t[s],i):console.warn(`DOM node '${e}-${s}-${n}' could not be found. Cannot render children.`)}else{let s=document.getElementById(`${e}-${n}`);if(null==s)return void console.warn(`DOM node '${e}-${n}' could not be found. Cannot render children.`);for(const e of t)this._render_child(e,s)}}_render_children(){for(const e in this.model.children){let t=this.model.children[e];"string"==typeof t&&(t=this.model.data[t],(0,a.isArray)(t)||(t=[t])),this._render_node(e,t)}}_render_html(e,t={}){let n=e,s="";const i=[];for(const e in this.model.callbacks)for(const t of this.model.callbacks[e]){const[o,l]=t;let r;if(n=n.replaceAll("${"+l+"}","$--{"+l+"}"),l.startsWith("script(")){const e=l.replace("('","_").replace("')","").replace('("',"_").replace('")',"").replace("-","_"),t=e.replaceAll("script_","");n=n.replaceAll(l,e),r=`\n          const ${e} = (event) => {\n            view._state.event = event\n            view.run_script("${t}")\n            delete view._state.event\n          }\n          `}else r=`\n          const ${l} = (event) => {\n            let elname = "${e}"\n            if (RegExp("{{.*loop.index.*}}").test(elname)) {\n              const pattern = RegExp(elname.replace(/{{(.+?)}}/g, String.fromCharCode(92) + "d+"))\n              for (const p of event.path) {\n                if (pattern.exec(p.id) != null) {\n                  elname = p.id.split("-").slice(null, -1).join("-")\n                  break\n                }\n              }\n            }\n            view._send_event(elname, "${o}", event)\n          }\n          `;i.indexOf(l)>-1||(i.push(l),s+=r)}return n=n.replaceAll("${model.","$-{model.").replaceAll("${","${data.").replaceAll("$-{model.","${model.").replaceAll("$--{","${"),new Function("view, model, data, state, html, useCallback",s+"return html`"+n+"`;")(this,this.model,this.model.data,t,r.html,l.useCallback)}_render_script(e,t){const n=[];for(const s of this.model.nodes){const i=s.replace("-","_");if(-1===e.indexOf(i))continue;const o=`\n      const ${i} = document.getElementById('${s}-${t}')\n      if (${i} == null) {\n        console.warn("DOM node '${s}' could not be found. Cannot execute callback.")\n        return\n      }\n      `;n.push(o)}return n.push("\n    if (state.event !== undefined) {\n      const event = state.event\n    }\n    "),n.push(e),new Function("model, data, state, view, script, self",n.join("\n"))}_remove_mutation_observers(){for(const e of this._mutation_observers)e.disconnect();this._mutation_observers=[]}_setup_mutation_observers(){const e=this.model.data.id;for(const t in this.model.attrs){const n=document.getElementById(`${t}-${e}`);if(null==n){console.warn(`DOM node '${t}-${e}' could not be found. Cannot set up MutationObserver.`);continue}const s=new MutationObserver((()=>{this._update_model(n,t)}));s.observe(n,{attributes:!0}),this._mutation_observers.push(s)}}_remove_event_listeners(){const e=this.model.data.id;for(const t in this._event_listeners){const n=document.getElementById(`${t}-${e}`);if(null!=n)for(const e in this._event_listeners[t]){const s=this._event_listeners[t][e];n.removeEventListener(e,s)}}this._event_listeners={}}_setup_event_listeners(){const e=this.model.data.id;for(const t in this.model.events){const n=document.getElementById(`${t}-${e}`);if(null==n){console.warn(`DOM node '${t}-${e}' could not be found. Cannot subscribe to DOM events.`);continue}const s=this.model.events[t];for(const e in s){const i=i=>{this._send_event(t,e,i),t in this.model.attrs&&s[e]&&this._update_model(n,t)};n.addEventListener(e,i),t in this._event_listeners||(this._event_listeners[t]={}),this._event_listeners[t][e]=i}}}_update(e=null){if(null==e||this.html.indexOf(`\${${e}}`)>-1){const e=this._render_html(this.html);try{this._changing=!0,(0,o.render)(e,this.el)}finally{this._changing=!1}}}_update_model(e,t){if(this._changing)return;const n={};for(const s of this.model.attrs[t]){const[i,o,l]=s;let r="children"===i?e.innerHTML:e[i];if(1===o.length&&`{${o[0]}}`===l)n[o[0]]=r;else if("string"==typeof r)if(r=v(l,r,o),null==r)console.warn(`Could not resolve parameters in ${t} element ${i} attribute value ${r}.`);else for(const e in r)void 0===r[e]?console.warn(`Could not resolve ${e} in ${t} element ${i} attribute value ${r}.`):n[e]=r[e]}try{this._changing=!0,this.model.data.setv(function(e){const t={};for(const n in e){let s=e[n];"string"!=typeof s?s=s:""===s||"NaN"!==s&&isNaN(Number(s))?"false"!==s&&"true"!==s||(s="true"===s):s=Number(s),t[n]=s}return t}(n))}catch(e){console.log("Could not serialize",n)}finally{this._changing=!1}}}n.ReactiveHTMLView=g,g.__name__="ReactiveHTMLView";class $ extends d.HTMLBox{constructor(e){super(e)}static init_ReactiveHTML(){this.prototype.default_view=g,this.define((({Array:e,Any:t,String:n})=>({attrs:[t,{}],callbacks:[t,{}],children:[t,{}],data:[t],events:[t,{}],html:[n,""],looped:[e(n),[]],nodes:[e(n),[]],scripts:[t,{}]})))}}n.ReactiveHTML=$,$.__name__="ReactiveHTML",$.__module__="panel.models.reactive_html",$.init_ReactiveHTML()},
"ab54efe08a": function _(e,t,s,i,n){i();const l=e("tslib"),o=e("@bokehjs/core/dom"),c=e("@bokehjs/core/util/types"),r=e("@bokehjs/models/widgets/input_widget"),d=(0,l.__importStar)(e("@bokehjs/styles/widgets/inputs.css"));class h extends r.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.value.change,(()=>this.render_selection())),this.connect(this.model.properties.options.change,(()=>this.render())),this.connect(this.model.properties.disabled_options.change,(()=>this.render())),this.connect(this.model.properties.name.change,(()=>this.render())),this.connect(this.model.properties.title.change,(()=>this.render())),this.connect(this.model.properties.size.change,(()=>this.render())),this.connect(this.model.properties.disabled.change,(()=>this.render()))}render(){super.render();const e=this.model.options.map((e=>{let t,s;(0,c.isString)(e)?t=s=e:[t,s]=e;let i=this.model.disabled_options.includes(t);return(0,o.option)({value:t,disabled:i},s)}));this.select_el=(0,o.select)({multiple:!1,class:d.input,name:this.model.name,disabled:this.model.disabled},e),this.select_el.style.backgroundImage="none",this.select_el.addEventListener("change",(()=>this.change_input())),this.group_el.appendChild(this.select_el),this.render_selection()}render_selection(){const e=this.model.value;for(const t of this.el.querySelectorAll("option"))t.value===e&&(t.selected=!0);this.select_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus");let t=null;for(const e of this.el.querySelectorAll("option"))if(e.selected){t=e.value;break}this.model.value=t,super.change_input(),e&&this.select_el.focus()}}s.SingleSelectView=h,h.__name__="SingleSelectView";class a extends r.InputWidget{constructor(e){super(e)}static init_SingleSelect(){this.prototype.default_view=h,this.define((({Any:e,Array:t,Int:s,String:i})=>({disabled_options:[t(i),[]],options:[t(e),[]],size:[s,4],value:[i,""]})))}}s.SingleSelect=a,a.__name__="SingleSelect",a.__module__="panel.models.widgets",a.init_SingleSelect()},
"a96be0bcc9": function _(t,e,i,o,n){o();const s=t("@bokehjs/models/layouts/html_box"),r="Click to START the speech recognition.",{webkitSpeechRecognition:h}=window,{webkitSpeechGrammarList:l}=window;class a extends s.HTMLBoxView{initialize(){var t,e;super.initialize(),this.recognition=new h,this.recognition.lang=this.model.lang,this.recognition.continuous=this.model.continuous,this.recognition.interimResults=this.model.interim_results,this.recognition.maxAlternatives=this.model.max_alternatives,this.recognition.serviceURI=this.model.service_uri,this.setGrammars(),this.recognition.onresult=t=>{this.model.results=function(t){const e=[];for(let o of t){let t=[],n={is_final:o.isFinal,alternatives:t};for(let e=0;e<o.length;e++){let n={confidence:(i=o[e].confidence,Math.round(100*(i+Number.EPSILON))/100),transcript:o[e].transcript};t.push(n)}n.alternatives=t,e.push(n)}var i;return e}(t.results)},this.recognition.onerror=t=>{console.log("SpeechToText Error"),console.log(t)},this.recognition.onnomatch=t=>{console.log("SpeechToText No Match"),console.log(t)},this.recognition.onaudiostart=()=>this.model.audio_started=!0,this.recognition.onaudioend=()=>this.model.audio_started=!1,this.recognition.onsoundstart=()=>this.model.sound_started=!0,this.recognition.onsoundend=()=>this.model.sound_started=!1,this.recognition.onspeechstart=()=>this.model.speech_started=!0,this.recognition.onspeechend=()=>this.model.speech_started=!1,this.recognition.onstart=()=>{this.buttonEl.onclick=()=>{this.recognition.stop()},this.buttonEl.innerHTML=this.iconStarted(),this.buttonEl.setAttribute("title","Click to STOP the speech recognition."),this.model.started=!0},this.recognition.onend=()=>{this.buttonEl.onclick=()=>{this.recognition.start()},this.buttonEl.innerHTML=this.iconNotStarted(),this.buttonEl.setAttribute("title",r),this.model.started=!1},this.buttonEl=(t=`<button class="bk bk-btn bk-btn-${this.model.button_type}" type="button" title="${r}"></button>`,e=document.createElement("template"),t=t.trim(),e.innerHTML=t,e.content.firstChild),this.buttonEl.innerHTML=this.iconNotStarted(),this.buttonEl.onclick=()=>this.recognition.start()}iconStarted(){return""!==this.model.button_started?this.model.button_started:'<svg xmlns="http://www.w3.org/2000/svg" height="22px" style="vertical-align: middle;" fill="currentColor" class="bi bi-mic" viewBox="0 0 16 16">\n  <path fill-rule="evenodd" d="M3.5 6.5A.5.5 0 0 1 4 7v1a4 4 0 0 0 8 0V7a.5.5 0 0 1 1 0v1a5 5 0 0 1-4.5 4.975V15h3a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1h3v-2.025A5 5 0 0 1 3 8V7a.5.5 0 0 1 .5-.5z"/>\n  <path fill-rule="evenodd" d="M10 8V3a2 2 0 1 0-4 0v5a2 2 0 1 0 4 0zM8 0a3 3 0 0 0-3 3v5a3 3 0 0 0 6 0V3a3 3 0 0 0-3-3z"/>\n</svg>'}iconNotStarted(){return""!==this.model.button_not_started?this.model.button_not_started:'<svg xmlns="http://www.w3.org/2000/svg" height="22px" style="vertical-align: middle;" fill="currentColor" class="bi bi-mic-mute" viewBox="0 0 16 16">\n<path fill-rule="evenodd" d="M12.734 9.613A4.995 4.995 0 0 0 13 8V7a.5.5 0 0 0-1 0v1c0 .274-.027.54-.08.799l.814.814zm-2.522 1.72A4 4 0 0 1 4 8V7a.5.5 0 0 0-1 0v1a5 5 0 0 0 4.5 4.975V15h-3a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-3v-2.025a4.973 4.973 0 0 0 2.43-.923l-.718-.719zM11 7.88V3a3 3 0 0 0-5.842-.963l.845.845A2 2 0 0 1 10 3v3.879l1 1zM8.738 9.86l.748.748A3 3 0 0 1 5 8V6.121l1 1V8a2 2 0 0 0 2.738 1.86zm4.908 3.494l-12-12 .708-.708 12 12-.708.707z"/>\n</svg>'}setIcon(){this.model.started?this.buttonEl.innerHTML=this.iconStarted():this.buttonEl.innerHTML=this.iconNotStarted()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.start.change,(()=>{this.model.start=!1,this.recognition.start()})),this.connect(this.model.properties.stop.change,(()=>{this.model.stop=!1,this.recognition.stop()})),this.connect(this.model.properties.abort.change,(()=>{this.model.abort=!1,this.recognition.abort()})),this.connect(this.model.properties.grammars.change,(()=>this.setGrammars())),this.connect(this.model.properties.lang.change,(()=>this.recognition.lang=this.model.lang)),this.connect(this.model.properties.continuous.change,(()=>this.recognition.continuous=this.model.continuous)),this.connect(this.model.properties.interim_results.change,(()=>this.recognition.interimResults=this.model.interim_results)),this.connect(this.model.properties.max_alternatives.change,(()=>this.recognition.maxAlternatives=this.model.max_alternatives)),this.connect(this.model.properties.service_uri.change,(()=>this.recognition.serviceURI=this.model.service_uri)),this.connect(this.model.properties.button_type.change,(()=>this.buttonEl.className=`bk bk-btn bk-btn-${this.model.button_type}`)),this.connect(this.model.properties.button_hide.change,(()=>this.render()));const{button_not_started:t,button_started:e}=this.model.properties;this.on_change([t,e],(()=>this.setIcon()))}setGrammars(){this.recognition.grammars=function(t){if(t){var e=new l;for(let i of t)i.src?e.addFromString(i.src,i.weight):i.uri&&e.addFromURI(i.uri,i.weight);return e}return null}(this.model.grammars)}render(){super.render(),this.model.button_hide||this.el.appendChild(this.buttonEl)}}i.SpeechToTextView=a,a.__name__="SpeechToTextView";class c extends s.HTMLBox{constructor(t){super(t)}static init_SpeechToText(){this.prototype.default_view=a,this.define((({Array:t,Boolean:e,Number:i,String:o})=>({start:[e,!1],stop:[e,!1],abort:[e,!1],grammars:[t(o),[]],lang:[o,""],continuous:[e,!1],interim_results:[e,!1],max_alternatives:[i,1],service_uri:[o],started:[e,!1],audio_started:[e,!1],sound_started:[e,!1],speech_started:[e,!1],button_type:[o,"light"],button_hide:[e,!1],button_not_started:[o,""],button_started:[o,""],results:[t(o),[]]})))}}i.SpeechToText=c,c.__name__="SpeechToText",c.__module__="panel.models.speech_to_text",c.init_SpeechToText()},
"bfa46a5f19": function _(e,t,s,a,i){a();const o=e("@bokehjs/core/view"),c=e("@bokehjs/core/util/array"),n=e("@bokehjs/model"),h=e("@bokehjs/protocol/receiver");class _ extends o.View{renderTo(){}}s.StateView=_,_.__name__="StateView";class r extends n.Model{constructor(e){super(e),this._receiver=new h.Receiver,this._cache={}}apply_state(e){this._receiver.consume(e.header),this._receiver.consume(e.metadata),this._receiver.consume(e.content),this._receiver.message&&this.document&&this.document.apply_json_patch(this._receiver.message.content)}_receive_json(e,t){const s=JSON.parse(e);this._cache[t]=s;let a=this.state;for(const e of this.values)a=a[e];a===t?this.apply_state(s):this._cache[a]&&this.apply_state(this._cache[a])}set_state(e,t){let s=(0,c.copy)(this.values);s[this.widgets[e.id]]=t;let a=this.state;for(const e of s)a=a[e];var i,o,n;this.values=s,this.json?this._cache[a]?this.apply_state(this._cache[a]):(i=a,o=e=>this._receive_json(e,a),(n=new XMLHttpRequest).overrideMimeType("application/json"),n.open("GET",i,!0),n.onreadystatechange=function(){4==n.readyState&&200==n.status&&o(n.responseText)},n.send(null)):this.apply_state(a)}static init_State(){this.prototype.default_view=_,this.define((({Any:e,Boolean:t})=>({json:[t,!1],state:[e,{}],widgets:[e,{}],values:[e,[]]})))}}s.State=r,r.__name__="State",r.__module__="panel.models.state",r.init_State()},
"f693d9aa84": function _(e,t,s,i,l){i();const h=e("tslib"),a=e("@bokehjs/core/layout"),o=e("@bokehjs/core/dom"),d=e("@bokehjs/core/util/array"),c=e("@bokehjs/models/layouts/tabs"),r=e("@bokehjs/models/layouts/layout_dom"),n=(0,h.__importStar)(e("@bokehjs/styles/tabs.css")),_=(0,h.__importStar)(e("@bokehjs/styles/buttons.css")),p=(0,h.__importStar)(e("@bokehjs/styles/menus.css"));function b(e){e.style.visibility="",e.style.opacity=""}function u(e){e.style.visibility="hidden",e.style.opacity="0"}class m extends c.TabsView{connect_signals(){super.connect_signals();let e=this;for(;null!=e;)e.model.type.endsWith("Tabs")&&e.connect(e.model.properties.active.change,(()=>this.update_zindex())),e=e.parent||e._parent}get is_visible(){let e=this.parent,t=this;for(;null!=e;){if(e.model.type.endsWith("Tabs")&&e.child_views.indexOf(t)!==e.model.active)return!1;t=e,e=e.parent||e._parent}return!0}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:i}=this;this.header=new class extends a.ContentBox{_measure(e){const l=(0,o.size)(s),h=(0,o.children)(i).slice(0,3).map((e=>(0,o.size)(e))),{width:a,height:c}=super._measure(e);if(t){const t=l.width+(0,d.sum)(h.map((e=>e.width)));return{width:e.width!=1/0?e.width:t,height:c}}{const t=l.height+(0,d.sum)(h.map((e=>e.height)));return{width:a,height:e.height!=1/0?e.height:t}}}}(this.header_el);let{width_policy:l,height_policy:h}=this.model;"auto"==l&&(l=this._width_policy()),"auto"==h&&(h=this._height_policy());const{sizing_mode:c}=this.model;null!=c&&("fixed"==c?l=h="fixed":"stretch_both"==c?l=h="max":"stretch_width"==c?l="max":"stretch_height"==c&&(h="max")),t?this.header.set_sizing({width_policy:l,height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:h});let r=1,n=1;switch(e){case"above":r-=1;break;case"below":r+=1;break;case"left":n-=1;break;case"right":n+=1}const _={layout:this.header,row:r,col:n},p=this.child_views.map((e=>({layout:e.layout,row:1,col:1})));this.layout=new a.Grid([_,...p]),this.layout.set_sizing(this.box_sizing())}update_zindex(){const{child_views:e}=this;for(const t of e)null!=t&&null!=t.el&&(t.el.style.zIndex="");if(this.is_visible){const t=e[this.model.active];null!=t&&null!=t.el&&(t.el.style.zIndex="1")}}update_position(){super.update_position(),this.header_el.style.position="absolute",(0,o.position)(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=(0,o.size)(this.scroll_el),i=(0,o.scroll_size)(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=e-s.width+"px",(0,o.display)(this.scroll_el),this.do_scroll(this.model.active)):(this.headers_el.style.left="0px",this.wrapper_el.style.maxWidth="",(0,o.undisplay)(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=e-s.height+"px",(0,o.display)(this.scroll_el),this.do_scroll(this.model.active)):(this.headers_el.style.top="0px",this.wrapper_el.style.maxHeight="",(0,o.undisplay)(this.scroll_el))}const{child_views:l}=this;for(const e of l)u(e.el),e.el.style.removeProperty("zIndex");const h=l[this.model.active];null!=h&&b(h.el)}render(){r.LayoutDOMView.prototype.render.call(this);let{active:e}=this.model;const t=this.model.tabs.map(((t,s)=>{const i=(0,o.div)({class:[n.tab,s==e?n.active:null]},t.title);if(i.addEventListener("click",(e=>{this.model.disabled||e.target==e.currentTarget&&this.change_active(s)})),t.closable){const e=(0,o.div)({class:n.close});e.addEventListener("click",(e=>{if(e.target==e.currentTarget){this.model.tabs=(0,d.remove_at)(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}})),i.appendChild(e)}return(this.model.disabled||t.disabled)&&i.classList.add(n.disabled),i}));this.headers_el=(0,o.div)({class:[n.headers]},t),this.wrapper_el=(0,o.div)({class:n.headers_wrapper},this.headers_el),this.left_el=(0,o.div)({class:[_.btn,_.btn_default],disabled:""},(0,o.div)({class:[p.caret,n.left]})),this.right_el=(0,o.div)({class:[_.btn,_.btn_default]},(0,o.div)({class:[p.caret,n.right]})),this.left_el.addEventListener("click",(()=>this.do_scroll("left"))),this.right_el.addEventListener("click",(()=>this.do_scroll("right"))),this.scroll_el=(0,o.div)({class:_.btn_group},this.left_el,this.right_el);const s=this.model.tabs_location;this.header_el=(0,o.div)({class:[n.tabs_header,n[s]]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el),this.update_zindex(),-1===e&&this.model.tabs.length&&(this.model.active=0)}on_active_change(){const e=this.model.active,t=(0,o.children)(this.headers_el);for(const e of t)e.classList.remove(n.active);t[e].classList.add(n.active);const{child_views:s}=this;for(const e of s)u(e.el);b(s[e].el)}}s.TabsView=m,m.__name__="TabsView";class y extends c.Tabs{constructor(e){super(e)}static init_Tabs(){this.prototype.default_view=m,this.define((({})=>({})))}}s.Tabs=y,y.__name__="Tabs",y.__module__="panel.models.tabs",y.init_Tabs()},
"3ea011fa55": function _(e,t,i,n,s){n();const r=e("@bokehjs/models/layouts/html_box"),o=e("@bokehjs/core/dom"),l=e("@bokehjs/core/bokeh_events"),a=e("80a6464b1f");class h extends l.ModelEvent{constructor(e){super(),this.key=e,this.event_name="keystroke"}_to_json(){return{model:this.origin,key:this.key}}}i.KeystrokeEvent=h,h.__name__="KeystrokeEvent";class d extends a.PanelHTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.output.change,this.write),this.connect(this.model.properties._clears.change,this.clear)}render(){super.render(),this.container=(0,o.div)({class:"terminal-container"}),(0,a.set_size)(this.container,this.model),this.term=this.getNewTerminal(),this.term.onData((e=>{this.handleOnData(e)})),this.webLinksAddon=this.getNewWebLinksAddon(),this.term.loadAddon(this.webLinksAddon),this.term.open(this.container),this.term.onRender((()=>{this._rendered||this.fit()})),this.write(),this.el.appendChild(this.container)}getNewTerminal(){const e=window;return e.Terminal?new e.Terminal(this.model.options):new e.xtermjs.Terminal(this.model.options)}getNewWebLinksAddon(){return new window.WebLinksAddon.WebLinksAddon}handleOnData(e){this.model.trigger_event(new h(e))}write(){const e=this.model.output;if(null==e||!e.length)return;const t=e.replace(/\r?\n/g,"\r\n");this.term.write(t)}clear(){this.term.clear()}fit(){const e=this.box_sizing(),t=null==e.margin?0:e.margin.top+e.margin.bottom,i=null==e.margin?0:e.margin.left+e.margin.right,n=(this.layout.inner_bbox.width||this.model.width||0)-i,s=(this.layout.inner_bbox.height||this.model.height||0)-t,r=this.term._core._renderService,o=r.dimensions.actualCellWidth||9,l=r.dimensions.actualCellHeight||18;if(null==n||null==s||n<=0||s<=0)return;const a=Math.max(2,Math.floor(n/o)),h=Math.max(1,Math.floor(s/l));this.term.rows===h&&this.term.cols===a||this.term.resize(a,h),this.model.ncols=a,this.model.nrows=h,this._rendered=!0}after_layout(){super.after_layout(),this.fit()}resize_layout(){super.resize_layout(),this.fit()}}i.TerminalView=d,d.__name__="TerminalView";class m extends r.HTMLBox{constructor(e){super(e)}static init_Terminal(){this.prototype.default_view=d,this.define((({Any:e,Int:t,String:i})=>({_clears:[t,0],options:[e,{}],output:[i],ncols:[t],nrows:[t]})))}}i.Terminal=m,m.__name__="Terminal",m.__module__="panel.models.terminal",m.init_Terminal()},
"33cd2c254e": function _(e,s,i,t,n){t();const h=e("@bokehjs/models/layouts/html_box");function o(e){var s=[];for(let t of e){var i={default:t.default,lang:t.lang,local_service:t.localService,name:t.name,voice_uri:t.voiceURI};s.push(i)}return s}class c extends h.HTMLBoxView{initialize(){super.initialize(),this.model.paused=speechSynthesis.paused,this.model.pending=speechSynthesis.pending,this.model.speaking=speechSynthesis.speaking,this._callback=window.setInterval((function(){!speechSynthesis.paused&&speechSynthesis.speaking&&window.speechSynthesis.resume()}),1e4);const e=()=>{"undefined"!=typeof speechSynthesis&&(this.voices=speechSynthesis.getVoices(),this.voices&&(this.model.voices=o(this.voices)))};e(),"undefined"!=typeof speechSynthesis&&void 0!==speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=e)}remove(){null!=this._callback&&clearInterval(this._callback),speechSynthesis.cancel(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.speak.change,(()=>{this.speak()})),this.connect(this.model.properties.pause.change,(()=>{this.model.pause=!1,speechSynthesis.pause()})),this.connect(this.model.properties.resume.change,(()=>{this.model.resume=!1,speechSynthesis.resume()})),this.connect(this.model.properties.cancel.change,(()=>{this.model.cancel=!1,speechSynthesis.cancel()}))}speak(){let e=new SpeechSynthesisUtterance(this.model.speak.text);if(e.pitch=this.model.speak.pitch,e.volume=this.model.speak.volume,e.rate=this.model.speak.rate,this.model.voices)for(let s of this.voices)s.name===this.model.speak.voice&&(e.voice=s);e.onpause=()=>this.model.paused=!0,e.onstart=()=>{this.model.speaking=!0,this.model.paused=!1,this.model.pending=speechSynthesis.pending},e.onresume=()=>this.model.paused=!1,e.onend=()=>{this.model.speaking=!1,this.model.paused=!1,this.model.pending=speechSynthesis.pending},speechSynthesis.speak(e),this.model.paused=speechSynthesis.paused,this.model.pending=speechSynthesis.pending}render(){super.render(),this.model.voices||(this.model.voices=o(this.voices)),null!=this.model.speak&&this.model.speak.text&&this.speak()}}i.TextToSpeechView=c,c.__name__="TextToSpeechView";class p extends h.HTMLBox{constructor(e){super(e)}static init_TextToSpeech(){this.prototype.default_view=c,this.define((({Any:e,Array:s,Boolean:i})=>({paused:[i,!1],pending:[i,!1],speaking:[i,!1],voices:[s(e),[]],cancel:[i,!1],pause:[i,!1],resume:[i,!1],speak:[e,{}]})))}}i.TextToSpeech=p,p.__name__="TextToSpeech",p.__module__="panel.models.text_to_speech",p.init_TextToSpeech()},
"effe070807": function _(t,e,i,l,o){l();const s=t("@bokehjs/models/layouts/html_box"),h=t("@bokehjs/core/build_views"),a=t("@bokehjs/models/plots"),n=t("@bokehjs/models/glyphs"),d=t("@bokehjs/core/dom"),r=t("@bokehjs/models/sources/column_data_source"),c=t("@bokehjs/models/formatters");class p extends s.HTMLBoxView{initialize(){super.initialize(),this.containerDiv=(0,d.div)({style:"height:100%; width:100%;"}),this.titleDiv=(0,d.div)({style:"font-size: 1em; word-wrap: break-word;"}),this.valueDiv=(0,d.div)({style:"font-size: 2em"}),this.value2Div=(0,d.div)({style:"font-size: 1em; opacity: 0.5; display: inline"}),this.changeDiv=(0,d.div)({style:"font-size: 1em; opacity: 0.5; display: inline"}),this.textDiv=(0,d.div)({},this.titleDiv,this.valueDiv,(0,d.div)({},this.changeDiv,this.value2Div)),this.updateTitle(),this.updateValue(),this.updateValue2(),this.updateValueChange(),this.updateTextFontSize(),this.plotDiv=(0,d.div)({}),this.containerDiv=(0,d.div)({style:"height:100%; width:100%"},this.textDiv,this.plotDiv),this.updateLayout()}connect_signals(){super.connect_signals();const{pos_color:t,neg_color:e}=this.model.properties;this.on_change([t,e],(()=>this.updateValueChange()));const{plot_color:i,plot_type:l,width:o,height:s,sizing_mode:h}=this.model.properties;this.on_change([i,l,o,s,h],(()=>this.render())),this.connect(this.model.properties.title.change,(()=>this.updateTitle(!0))),this.connect(this.model.properties.value.change,(()=>this.updateValue(!0))),this.connect(this.model.properties.value_change.change,(()=>this.updateValue2(!0))),this.connect(this.model.properties.layout.change,(()=>this.updateLayout()))}async render(){super.render(),this.el.appendChild(this.containerDiv),await this.setPlot()}async setPlot(){this.plot=new a.Plot({background_fill_color:null,border_fill_color:null,outline_line_color:null,min_border:0,sizing_mode:"stretch_both",toolbar_location:null});var t=this.model.source;if("line"===this.model.plot_type){var e=new n.Line({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:4,line_color:this.model.plot_color});this.plot.add_glyph(e,t)}else if("step"===this.model.plot_type){var i=new n.Step({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:3,line_color:this.model.plot_color});this.plot.add_glyph(i,t)}else if("area"===this.model.plot_type){var l=new n.VArea({x:{field:this.model.plot_x},y1:{field:this.model.plot_y},y2:0,fill_color:this.model.plot_color,fill_alpha:.5});this.plot.add_glyph(l,t);e=new n.Line({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:3,line_color:this.model.plot_color});this.plot.add_glyph(e,t)}else{var o=new n.VBar({x:{field:this.model.plot_x},top:{field:this.model.plot_y},width:.9,line_color:null,fill_color:this.model.plot_color});this.plot.add_glyph(o,t)}const s=await(0,h.build_view)(this.plot);this.plotDiv.innerHTML="",s.renderTo(this.plotDiv)}after_layout(){super.after_layout(),this.updateTextFontSize()}updateTextFontSize(){this.updateTextFontSizeColumn()}updateTextFontSizeColumn(){let t=this.containerDiv.clientWidth,e=this.containerDiv.clientHeight;"column"===this.model.layout?e=Math.round(e/2):t=Math.round(t/2);const i=t/this.model.title.length*2,l=t/(2*this._value_format.length)*1.8,o=t/(this._value_change_format.length+1)*2,s=e/6,h=Math.min(i,l,o,s);this.textDiv.style.fontSize=Math.trunc(h)+"px",this.textDiv.style.lineHeight="1.3"}updateTitle(t=!1){this.titleDiv.innerText=this.model.title,t&&this.updateTextFontSize()}updateValue(t=!1){this._value_format=this.model.formatter.doFormat([this.model.value],{loc:0})[0],this.valueDiv.innerText=this._value_format,t&&this.updateTextFontSize()}updateValue2(t=!1){this._value_change_format=this.model.change_formatter.doFormat([this.model.value_change],{loc:0})[0],this.value2Div.innerText=this._value_change_format,this.updateValueChange(),t&&this.updateTextFontSize()}updateValueChange(){this.model.value_change>0?(this.changeDiv.innerHTML="&#9650;",this.changeDiv.style.color=this.model.pos_color):this.model.value_change<0?(this.changeDiv.innerHTML="&#9660;",this.changeDiv.style.color=this.model.neg_color):(this.changeDiv.innerHTML="&nbsp;",this.changeDiv.style.color="inherit")}updateLayout(){"column"===this.model.layout?(this.containerDiv.style.display="block",this.textDiv.style.height="50%",this.textDiv.style.width="100%",this.plotDiv.style.height="50%",this.plotDiv.style.width="100%"):(this.containerDiv.style.display="flex",this.textDiv.style.height="100%",this.textDiv.style.width="",this.plotDiv.style.height="100%",this.plotDiv.style.width="",this.textDiv.style.flex="1",this.plotDiv.style.flex="1"),this._has_finished&&this.invalidate_layout()}}i.TrendIndicatorView=p,p.__name__="TrendIndicatorView";class _ extends s.HTMLBox{constructor(t){super(t)}static init_TrendIndicator(){this.prototype.default_view=p,this.define((({Number:t,String:e,Ref:i})=>({description:[e,""],formatter:[i(c.TickFormatter),()=>new c.BasicTickFormatter],change_formatter:[i(c.TickFormatter),()=>new c.NumeralTickFormatter],layout:[e,"column"],source:[i(r.ColumnDataSource)],plot_x:[e,"x"],plot_y:[e,"y"],plot_color:[e,"#428bca"],plot_type:[e,"bar"],pos_color:[e,"#5cb85c"],neg_color:[e,"#d9534f"],title:[e,""],value:[t,0],value_change:[t,0]})))}}i.TrendIndicator=_,_.__name__="TrendIndicator",_.__module__="panel.models.trend",_.init_TrendIndicator()},
"fea356270f": function _(t,e,s,o,i){o();const a=t("@bokehjs/core/bokeh_events"),n=t("@bokehjs/core/util/types"),h=t("@bokehjs/models/layouts/html_box"),c=t("99a25e6992");class _ extends a.ModelEvent{constructor(t){super(),this.data=t,this.event_name="vega_event"}_to_json(){return{model:this.origin,data:this.data}}}s.VegaEvent=_,_.__name__="VegaEvent";class d extends h.HTMLBoxView{connect_signals(){super.connect_signals();const{data:t,show_actions:e,theme:s}=this.model.properties;this.on_change([t,e,s],(()=>{this._plot()})),this.connect(this.model.properties.data_sources.change,(()=>this._connect_sources())),this.connect(this.model.properties.events.change,(()=>{for(const t of this.model.events){if(this._callbacks.indexOf(t)>-1)continue;this._callbacks.push(t);const e=(t,e)=>this._dispatch_event(t,e),s=this.model.throttle[t]||20;this.vega_view.addSignalListener(t,(0,c.debounce)(e,s,!1))}})),this._connected=[],this._connect_sources()}_connect_sources(){for(const t in this.model.data_sources){const e=this.model.data_sources[t];this._connected.indexOf(t)<0&&(this.connect(e.properties.data.change,this._plot),this._connected.push(t))}}_dispatch_event(t,e){if("vlPoint"in e&&null!=e.vlPoint.or){const t=[];for(const s of e.vlPoint.or)t.push(s._vgsid_);e=t}this.model.trigger_event(new _({type:t,value:e}))}_fetch_datasets(){const t={};for(const e in this.model.data_sources){const s=this.model.data_sources[e],o=[],i=s.columns();for(let t=0;t<s.get_length();t++){const e={};for(const o of i)e[o]=s.data[o][t];o.push(e)}t[e]=o}return t}render(){super.render(),this._callbacks=[],this._plot()}_plot(){const t=this.model.data;if(null==t||!window.vegaEmbed)return;if(this.model.data_sources&&Object.keys(this.model.data_sources).length>0){const e=this._fetch_datasets();if("data"in e&&(t.data.values=e.data,delete e.data),null!=t.data){const s=(0,n.isArray)(t.data)?t.data:[t.data];for(const t of s)t.name in e&&(t.values=e[t.name],delete e[t.name])}this.model.data.datasets=e}const e={actions:this.model.show_actions,theme:this.model.theme};window.vegaEmbed(this.el,this.model.data,e).then((t=>{this.vega_view=t.view,this.relayout(),(this.vega_view._viewHeight<=0||this.vega_view._viewWidth<=0)&&window.dispatchEvent(new Event("resize"));const e=(t,e)=>this._dispatch_event(t,e);for(const t of this.model.events){this._callbacks.push(t);const s=this.model.throttle[t]||20;this.vega_view.addSignalListener(t,(0,c.debounce)(e,s,!1))}}))}relayout(){this.update_layout(),this.compute_layout(),this.root!==this?this.invalidate_layout():null!=this._parent&&this._parent.invalidate_layout()}box_sizing(){const t=super.box_sizing();return null!=this.vega_view&&("fixed"===t.height_policy&&(t.height=this.vega_view._viewHeight),"fixed"===t.width_policy&&(t.width=this.vega_view._viewWidth)),t}}s.VegaPlotView=d,d.__name__="VegaPlotView";class l extends h.HTMLBox{constructor(t){super(t)}static init_VegaPlot(){this.prototype.default_view=d,this.define((({Any:t,Array:e,Boolean:s,String:o})=>({data:[t,{}],data_sources:[t,{}],events:[e(o),[]],show_actions:[s,!1],theme:[o],throttle:[t,{}]})))}}s.VegaPlot=l,l.__name__="VegaPlot",l.__module__="panel.models.vega",l.init_VegaPlot()},
"1b46fd56a8": function _(e,t,i,o,s){o();const l=e("@bokehjs/models/layouts/html_box"),d=e("80a6464b1f");class h extends d.PanelHTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.loop.change,(()=>this.set_loop())),this.connect(this.model.properties.paused.change,(()=>this.set_paused())),this.connect(this.model.properties.muted.change,(()=>this.set_muted())),this.connect(this.model.properties.autoplay.change,(()=>this.set_autoplay())),this.connect(this.model.properties.time.change,(()=>this.set_time())),this.connect(this.model.properties.value.change,(()=>this.set_value())),this.connect(this.model.properties.volume.change,(()=>this.set_volume()))}render(){super.render(),this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.videoEl.controls=!0,this.videoEl.src=this.model.value,this.videoEl.currentTime=this.model.time,this.videoEl.loop=this.model.loop,this.videoEl.muted=this.model.muted,this.videoEl.autoplay=this.model.autoplay,null!=this.model.volume?this.videoEl.volume=this.model.volume/100:this.model.volume=100*this.videoEl.volume,this.videoEl.onpause=()=>this.model.paused=!0,this.videoEl.onplay=()=>this.model.paused=!1,this.videoEl.ontimeupdate=()=>this.update_time(this),this.videoEl.onvolumechange=()=>this.update_volume(this),this.el.appendChild(this.videoEl),this.model.paused||this.videoEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.videoEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.videoEl.volume)}set_loop(){this.videoEl.loop=this.model.loop}set_muted(){this.videoEl.muted=this.model.muted}set_autoplay(){this.videoEl.autoplay=this.model.autoplay}set_paused(){!this.videoEl.paused&&this.model.paused&&this.videoEl.pause(),this.videoEl.paused&&!this.model.paused&&this.videoEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.videoEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.videoEl.currentTime=this.model.time)}set_value(){this.videoEl.src=this.model.value}}i.VideoView=h,h.__name__="VideoView";class m extends l.HTMLBox{constructor(e){super(e)}static init_Video(){this.prototype.default_view=h,this.define((({Any:e,Boolean:t,Int:i,Number:o})=>({loop:[t,!1],paused:[t,!0],muted:[t,!1],autoplay:[t,!1],time:[o,0],throttle:[i,250],value:[e,""],volume:[i]})))}}i.Video=m,m.__name__="Video",m.__module__="panel.models.widgets",m.init_Video()},
"e3e9b8e495": function _(e,t,i,s,o){s();const h=e("@bokehjs/models/layouts/html_box"),l=e("80a6464b1f");class a extends l.PanelHTMLBoxView{constructor(){super(...arguments),this.constraints={audio:!1,video:!0}}initialize(){super.initialize(),null!==this.model.timeout&&this.set_timeout()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.timeout.change,(()=>this.set_timeout())),this.connect(this.model.properties.snapshot.change,(()=>this.snapshot())),this.connect(this.model.properties.paused.change,(()=>this.pause()))}pause(){this.model.paused?(null!=this.timer&&(clearInterval(this.timer),this.timer=null),this.videoEl.pause()):this.videoEl.play(),this.set_timeout()}set_timeout(){this.timer&&(clearInterval(this.timer),this.timer=null),null!=this.model.timeout&&this.model.timeout>0&&(this.timer=setInterval((()=>this.snapshot()),this.model.timeout))}snapshot(){this.canvasEl.width=this.videoEl.videoWidth,this.canvasEl.height=this.videoEl.videoHeight;const e=this.canvasEl.getContext("2d");e&&e.drawImage(this.videoEl,0,0,this.canvasEl.width,this.canvasEl.height),this.model.value=this.canvasEl.toDataURL("image/"+this.model.format,.95)}remove(){super.remove(),this.timer&&(clearInterval(this.timer),this.timer=null)}render(){super.render(),this.videoEl||(this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.canvasEl=document.createElement("canvas"),this.el.appendChild(this.videoEl),navigator.mediaDevices.getUserMedia&&navigator.mediaDevices.getUserMedia(this.constraints).then((e=>{this.videoEl.srcObject=e,this.model.paused||this.videoEl.play()})).catch(console.error))}}i.VideoStreamView=a,a.__name__="VideoStreamView";class n extends h.HTMLBox{constructor(e){super(e)}static init_VideoStream(){this.prototype.default_view=a,this.define((({Any:e,Boolean:t,Int:i,Nullable:s,String:o})=>({format:[o,"png"],paused:[t,!1],snapshot:[t,!1],timeout:[s(i),null],value:[e]}))),this.override({height:240,width:320})}}i.VideoStream=n,n.__name__="VideoStream",n.__module__="panel.models.widgets",n.init_VideoStream()},
"c51f25e2a7": function _(o,V,l,K,T){K(),T("VTKJSPlot",o("b6d9199d03").VTKJSPlot),T("VTKVolumePlot",o("7785475bdd").VTKVolumePlot),T("VTKAxes",o("ab478186ba").VTKAxes),T("VTKSynchronizedPlot",o("0a57062475").VTKSynchronizedPlot)},
"b6d9199d03": function _(e,t,n,i,s){i();const a=e("e13c143c7d"),r=e("993f3118b2");class _ extends a.AbstractVTKView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,(()=>{this.invalidate_render()}))}render(){super.render(),this._create_orientation_widget(),this._set_axes()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=r.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this.el,container:this._vtk_container})}plot(){if(!this.model.data)return void this._vtk_renwin.getRenderWindow().render();const e=r.vtkns.DataAccessHelper.get("zip",{zipContent:atob(this.model.data),callback:t=>{const n=r.vtkns.HttpSceneLoader.newInstance({renderer:this._vtk_renwin.getRenderer(),dataAccessHelper:e}),i=window.vtk.macro.debounce((()=>setTimeout((()=>{null==this._axes&&this.model.axes&&this._set_axes(),this._set_camera_state(),this._get_camera_state()}),100)),100);n.setUrl("index.json"),n.onReady(i)}})}}n.VTKJSPlotView=_,_.__name__="VTKJSPlotView";class o extends a.AbstractVTKPlot{static init_VTKJSPlot(){this.prototype.default_view=_,this.define((({Boolean:e,Nullable:t,String:n})=>({data:[t(n)],enable_keybindings:[e,!1]})))}}n.VTKJSPlot=o,o.__name__="VTKJSPlot",o.init_VTKJSPlot()},
"e13c143c7d": function _(e,t,i,n,s){n();const a=e("@bokehjs/core/dom"),r=e("@bokehjs/models/layouts/html_box"),o=e("@bokehjs/core/util/object"),_=e("@bokehjs/models/mappers/color_mapper"),d=e("@bokehjs/core/kinds"),h=e("80a6464b1f"),c=e("993f3118b2"),l=e("c010237f8b"),g=e("ab478186ba"),p={padding:"0px 2px 0px 2px",maxHeight:"150px",height:"auto",backgroundColor:"rgba(255, 255, 255, 0.4)",borderRadius:"10px",margin:"2px",boxSizing:"border-box",overflow:"hidden",overflowY:"auto",transition:"width 0.1s linear",bottom:"0px",position:"absolute"},m=(0,d.Enum)("LowerLeft","LowerRight","UpperLeft","UpperRight","LowerEdge","RightEdge","LeftEdge","UpperEdge");class v extends h.PanelHTMLBoxView{initialize(){super.initialize(),this._camera_callbacks=[],this._renderable=!0,this._setting_camera=!1}_add_colorbars(){const e=this.el.querySelector(".vtk_info");if(e&&this.el.removeChild(e),this.model.color_mappers.length<1)return;const t=document.createElement("div"),i="350px",n="30px";t.classList.add("vtk_info"),(0,c.applyStyle)(t,p),(0,c.applyStyle)(t,{width:i}),this.el.appendChild(t);const s=[];this.model.color_mappers.forEach((e=>{const i=new l.VTKColorBar(t,e);s.push(i)}));const a=document.createElement("div");(0,c.applyStyle)(a,{textAlign:"center",fontSize:"20px"}),a.innerText="...",t.addEventListener("click",(()=>{t.style.width===n?(t.removeChild(a),(0,c.applyStyle)(t,{height:"auto",width:i}),s.forEach((e=>t.appendChild(e.canvas)))):(s.forEach((e=>t.removeChild(e.canvas))),(0,c.applyStyle)(t,{height:n,width:n}),t.appendChild(a))})),t.click()}_init_annotations_container(){this._annotations_container||(this._annotations_container=document.createElement("div"),this._annotations_container.style.position="absolute",this._annotations_container.style.width="100%",this._annotations_container.style.height="100%",this._annotations_container.style.top="0",this._annotations_container.style.left="0",this._annotations_container.style.pointerEvents="none")}_clean_annotations(){if(this._annotations_container)for(;this._annotations_container.firstElementChild;)this._annotations_container.firstElementChild.remove()}_add_annotations(){this._clean_annotations();const{annotations:e}=this.model;if(null!=e)for(let t of e){const{viewport:e,color:i,fontSize:n,fontFamily:s}=t;m.values.forEach((a=>{const r=t[a];if(r){const t=document.createElement("div");t.textContent=r;const{style:o}=t;o.position="absolute",o.color=`rgb(${i.map((e=>255*e)).join(",")})`,o.fontSize=`${n}px`,o.padding="5px",o.fontFamily=s,o.width="fit-content","UpperLeft"==a&&(o.top=100*(1-e[3])+"%",o.left=100*e[0]+"%"),"UpperRight"==a&&(o.top=100*(1-e[3])+"%",o.right=100*(1-e[2])+"%"),"LowerLeft"==a&&(o.bottom=100*e[1]+"%",o.left=100*e[0]+"%"),"LowerRight"==a&&(o.bottom=100*e[1]+"%",o.right=100*(1-e[2])+"%"),"UpperEdge"==a&&(o.top=100*(1-e[3])+"%",o.left=100*(e[0]+(e[2]-e[0])/2)+"%",o.transform="translateX(-50%)"),"LowerEdge"==a&&(o.bottom=100*e[1]+"%",o.left=100*(e[0]+(e[2]-e[0])/2)+"%",o.transform="translateX(-50%)"),"LeftEdge"==a&&(o.left=100*e[0]+"%",o.top=100*(1-e[3]+(e[3]-e[1])/2)+"%",o.transform="translateY(-50%)"),"RightEdge"==a&&(o.right=100*(1-e[2])+"%",o.top=100*(1-e[3]+(e[3]-e[1])/2)+"%",o.transform="translateY(-50%)"),this._annotations_container.appendChild(t)}}))}}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.orientation_widget,(()=>{this._orientation_widget_visibility(this.model.orientation_widget)})),this.on_change(this.model.properties.camera,(()=>this._set_camera_state())),this.on_change(this.model.properties.axes,(()=>{this._delete_axes(),this.model.axes&&this._set_axes(),this._vtk_render()})),this.on_change(this.model.properties.color_mappers,(()=>this._add_colorbars())),this.on_change(this.model.properties.annotations,(()=>this._add_annotations()))}render(){super.render(),this._vtk_renwin&&this._vtk_container?((0,h.set_size)(this._vtk_container,this.model),this.el.appendChild(this._vtk_container)):(this._orientationWidget=null,this._axes=null,this._vtk_container=(0,a.div)(),this.init_vtk_renwin(),this._init_annotations_container(),(0,h.set_size)(this._vtk_container,this.model),this.el.appendChild(this._vtk_container),this._vtk_renwin.getInteractor().onEndAnimation((()=>this._get_camera_state())),this._remove_default_key_binding(),this._bind_key_events(),this.plot(),this._add_colorbars(),this._add_annotations(),this.model.renderer_el=this._vtk_renwin),this.el.appendChild(this._annotations_container)}after_layout(){super.after_layout(),this._renderable&&this._vtk_renwin.resize(),this._vtk_render()}invalidate_render(){this._unsubscribe_camera_cb(),super.invalidate_render()}resize_layout(){this.layout&&super.resize_layout()}remove(){this._unsubscribe_camera_cb(),window.removeEventListener("resize",this._vtk_renwin.resize),null!=this._orientationWidget&&this._orientationWidget.delete(),this._vtk_renwin.getRenderWindow().getInteractor().delete(),this._vtk_renwin.delete(),super.remove()}get _vtk_camera_state(){const e=this._vtk_renwin.getRenderer().getActiveCamera();let t;return e&&(t=(0,o.clone)(e.get()),delete t.classHierarchy,delete t.vtkObject,delete t.vtkCamera,delete t.viewPlaneNormal,delete t.flattenedDepIds,delete t.managedInstanceId,delete t.directionOfProjection),t}get _axes_canvas(){let e=this._vtk_container.querySelector(".axes-canvas");return e||(e=(0,a.canvas)({style:{position:"absolute",top:"0",left:"0",width:"100%",height:"100%"}}),e.classList.add("axes-canvas"),this._vtk_container.appendChild(e),this._vtk_renwin.setResizeCallback((()=>{if(this._axes_canvas){const e=this._vtk_container.getBoundingClientRect(),t=Math.floor(e.width*window.devicePixelRatio),i=Math.floor(e.height*window.devicePixelRatio);this._axes_canvas.setAttribute("width",t.toFixed()),this._axes_canvas.setAttribute("height",i.toFixed())}}))),e}_bind_key_events(){this.el.addEventListener("mouseenter",(()=>{const e=this._vtk_renwin.getInteractor();this.model.enable_keybindings&&(document.querySelector("body").addEventListener("keypress",e.handleKeyPress),document.querySelector("body").addEventListener("keydown",e.handleKeyDown),document.querySelector("body").addEventListener("keyup",e.handleKeyUp))})),this.el.addEventListener("mouseleave",(()=>{const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}))}_create_orientation_widget(){const e=c.vtkns.AxesActor.newInstance();this._orientationWidget=c.vtkns.OrientationMarkerWidget.newInstance({actor:e,interactor:this._vtk_renwin.getInteractor()}),this._orientationWidget.setEnabled(!0),this._orientationWidget.setViewportCorner(c.vtkns.OrientationMarkerWidget.Corners.BOTTOM_RIGHT),this._orientationWidget.setViewportSize(.15),this._orientationWidget.setMinPixelSize(75),this._orientationWidget.setMaxPixelSize(300),this.model.interactive_orientation_widget&&this._make_orientation_widget_interactive(),this._orientation_widget_visibility(this.model.orientation_widget)}_make_orientation_widget_interactive(){this._widgetManager=c.vtkns.WidgetManager.newInstance(),this._widgetManager.setRenderer(this._orientationWidget.getRenderer());const e=this._orientationWidget.getActor(),t=c.vtkns.InteractiveOrientationWidget.newInstance();t.placeWidget(e.getBounds()),t.setBounds(e.getBounds()),t.setPlaceFactor(1);this._widgetManager.addWidget(t).onOrientationChange((({direction:e})=>{const t=this._vtk_renwin.getRenderer().getActiveCamera(),i=t.getFocalPoint(),n=t.getPosition(),s=t.getViewUp(),a=Math.sqrt(Math.pow(n[0]-i[0],2)+Math.pow(n[1]-i[1],2)+Math.pow(n[2]-i[2],2));t.setPosition(i[0]+e[0]*a,i[1]+e[1]*a,i[2]+e[2]*a),e[0]&&t.setViewUp((0,c.majorAxis)(s,1,2)),e[1]&&t.setViewUp((0,c.majorAxis)(s,0,2)),e[2]&&t.setViewUp((0,c.majorAxis)(s,0,1)),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._vtk_render(),this._get_camera_state()}))}_delete_axes(){if(this._axes){Object.keys(this._axes).forEach((e=>this._vtk_renwin.getRenderer().removeActor(this._axes[e]))),this._axes=null;const e=this._axes_canvas.getContext("2d");e&&e.clearRect(0,0,this._axes_canvas.clientWidth*window.devicePixelRatio,this._axes_canvas.clientHeight*window.devicePixelRatio)}}_get_camera_state(){this._setting_camera||(this._setting_camera=!0,this.model.camera=this._vtk_camera_state,this._setting_camera=!1)}_orientation_widget_visibility(e){this._orientationWidget.setEnabled(e),null!=this._widgetManager&&(e?this._widgetManager.enablePicking():this._widgetManager.disablePicking()),this._vtk_render()}_remove_default_key_binding(){const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}_set_axes(){if(this.model.axes&&this._vtk_renwin.getRenderer()){const{psActor:e,axesActor:t,gridActor:i}=this.model.axes.create_axes(this._axes_canvas);this._axes={psActor:e,axesActor:t,gridActor:i},e&&this._vtk_renwin.getRenderer().addActor(e),t&&this._vtk_renwin.getRenderer().addActor(t),i&&this._vtk_renwin.getRenderer().addActor(i)}}_set_camera_state(){this._setting_camera||void 0===this._vtk_renwin.getRenderer()||(this._setting_camera=!0,this.model.camera&&JSON.stringify(this.model.camera)!=JSON.stringify(this._vtk_camera_state)&&this._vtk_renwin.getRenderer().getActiveCamera().set(this.model.camera),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._vtk_render(),this._setting_camera=!1)}_unsubscribe_camera_cb(){this._camera_callbacks.splice(0,this._camera_callbacks.length).map((e=>e.unsubscribe()))}_vtk_render(){this._renderable&&(this._orientationWidget&&this._orientationWidget.updateMarkerOrientation(),this._vtk_renwin.getRenderWindow().render())}}i.AbstractVTKView=v,v.__name__="AbstractVTKView";class w extends r.HTMLBox{constructor(e){(0,c.setup_vtkns)(),super(e)}getActors(){return this.renderer_el.getRenderer().getActors()}static init_AbstractVTKPlot(){this.define((({Any:e,Ref:t,Array:i,Boolean:n,Nullable:s})=>({axes:[s(t(g.VTKAxes)),null],camera:[e],color_mappers:[i(t(_.ColorMapper)),[]],orientation_widget:[n,!1],interactive_orientation_widget:[n,!1],annotations:[s(i(e)),null]}))),this.override({height:300,width:300})}}i.AbstractVTKPlot=w,w.__name__="AbstractVTKPlot",w.__module__="panel.models.vtk",w.init_AbstractVTKPlot()},
"993f3118b2": function _(e,n,t,r,a){r();const o=e("@bokehjs/core/util/array"),i=e("@bokehjs/core/kinds");function s(){if(null!=t.vtkns.Actor)return;const e=window.vtk;t.vtkns.Actor=e.Rendering.Core.vtkActor,t.vtkns.AxesActor=e.Rendering.Core.vtkAxesActor,t.vtkns.Base64=e.Common.Core.vtkBase64,t.vtkns.BoundingBox=e.Common.DataModel.vtkBoundingBox,t.vtkns.Camera=e.Rendering.Core.vtkCamera,t.vtkns.ColorTransferFunction=e.Rendering.Core.vtkColorTransferFunction,t.vtkns.CubeSource=e.Filters.Sources.vtkCubeSource,t.vtkns.DataAccessHelper=e.IO.Core.DataAccessHelper,t.vtkns.DataArray=e.Common.Core.vtkDataArray,t.vtkns.Follower=e.Rendering.Core.vtkFollower,t.vtkns.FullScreenRenderWindow=e.Rendering.Misc.vtkFullScreenRenderWindow,t.vtkns.Glyph3DMapper=e.Rendering.Core.vtkGlyph3DMapper,t.vtkns.HttpSceneLoader=e.IO.Core.vtkHttpSceneLoader,t.vtkns.ImageData=e.Common.DataModel.vtkImageData,t.vtkns.ImageMapper=e.Rendering.Core.vtkImageMapper,t.vtkns.ImageProperty=e.Rendering.Core.vtkImageProperty,t.vtkns.ImageSlice=e.Rendering.Core.vtkImageSlice,t.vtkns.InteractiveOrientationWidget=e.Widgets.Widgets3D.vtkInteractiveOrientationWidget,t.vtkns.InteractorStyleTrackballCamera=e.Interaction.Style.vtkInteractorStyleTrackballCamera,t.vtkns.Light=e.Rendering.Core.vtkLight,t.vtkns.LineSource=e.Filters.Sources.vtkLineSource,t.vtkns.LookupTable=e.Common.Core.vtkLookupTable,t.vtkns.macro=e.macro,t.vtkns.Mapper=e.Rendering.Core.vtkMapper,t.vtkns.OpenGLRenderWindow=e.Rendering.OpenGL.vtkRenderWindow,t.vtkns.OrientationMarkerWidget=e.Interaction.Widgets.vtkOrientationMarkerWidget,t.vtkns.OutlineFilter=e.Filters.General.vtkOutlineFilter,t.vtkns.PiecewiseFunction=e.Common.DataModel.vtkPiecewiseFunction,t.vtkns.PixelSpaceCallbackMapper=e.Rendering.Core.vtkPixelSpaceCallbackMapper,t.vtkns.PlaneSource=e.Filters.Sources.vtkPlaneSource,t.vtkns.PointSource=e.Filters.Sources.vtkPointSource,t.vtkns.PolyData=e.Common.DataModel.vtkPolyData,t.vtkns.Property=e.Rendering.Core.vtkProperty,t.vtkns.Renderer=e.Rendering.Core.vtkRenderer,t.vtkns.RenderWindow=e.Rendering.Core.vtkRenderWindow,t.vtkns.RenderWindowInteractor=e.Rendering.Core.vtkRenderWindowInteractor,t.vtkns.SphereMapper=e.Rendering.Core.vtkSphereMapper,t.vtkns.SynchronizableRenderWindow=e.Rendering.Misc.vtkSynchronizableRenderWindow,t.vtkns.ThirdParty=e.ThirdParty,t.vtkns.Texture=e.Rendering.Core.vtkTexture,t.vtkns.Volume=e.Rendering.Core.vtkVolume,t.vtkns.VolumeController=e.Interaction.UI.vtkVolumeController,t.vtkns.VolumeMapper=e.Rendering.Core.vtkVolumeMapper,t.vtkns.VolumeProperty=e.Rendering.Core.vtkVolumeProperty,t.vtkns.WidgetManager=e.Widgets.Core.vtkWidgetManager;const{vtkObjectManager:n}=t.vtkns.SynchronizableRenderWindow;n.setTypeMapping("vtkVolumeMapper",t.vtkns.VolumeMapper.newInstance,n.oneTimeGenericUpdater),n.setTypeMapping("vtkSmartVolumeMapper",t.vtkns.VolumeMapper.newInstance,n.oneTimeGenericUpdater),n.setTypeMapping("vtkFollower",t.vtkns.Follower.newInstance,n.genericUpdater),n.setTypeMapping("vtkOpenGLGlyph3DMapper",t.vtkns.Glyph3DMapper.newInstance,n.genericUpdater)}function k(e){const n=Math.min(Math.max(Math.round(e),0),255).toString(16);return 2==n.length?n:"0"+n}function c(e,n,t){return"#"+k(e)+k(n)+k(t)}function v(e){for(var n=new ArrayBuffer(e.length),t=new Uint8Array(n),r=0,a=e.length;r<a;r++)t[r]=e.charCodeAt(r);return n}t.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},t.vtkns={},t.setup_vtkns=s,window.vtk&&s(),t.Interpolation=(0,i.Enum)("fast_linear","linear","nearest"),t.applyStyle=function(e,n){Object.keys(n).forEach((t=>{e.style[t]=n[t]}))},t.hexToRGB=function(e){return[parseInt(e.slice(1,3),16)/255,parseInt(e.slice(3,5),16)/255,parseInt(e.slice(5,7),16)/255]},t.rgbToHex=c,t.vtkLutToMapper=function(e){const{scale:n,nodes:r}=e.get("scale","nodes");if(n!==t.vtkns.ColorTransferFunction.Scale.LINEAR)throw"Error transfer function scale not handle";const a=r.map((e=>e.x)),i=Math.min(...a),s=Math.max(...a),k=(0,o.linspace)(i,s,255),v=[0,0,0];return{low:i,high:s,palette:k.map((n=>(e.getColor(n,v),c(255*v[0],255*v[1],255*v[2]))))}},t.data2VTKImageData=function(e){const n=t.vtkns.ImageData.newInstance({spacing:e.spacing});n.setDimensions(e.dims),n.setOrigin(null!=e.origin?e.origin:e.dims.map((e=>e/2)));const r=t.vtkns.DataArray.newInstance({name:"scalars",numberOfComponents:1,values:new t.ARRAY_TYPES[e.dtype](v(atob(e.buffer)))});return n.getPointData().setScalars(r),n},t.majorAxis=function(e,n,t){const r=[0,0,0],a=Math.abs(e[n])>Math.abs(e[t])?n:t,o=e[a]>0?1:-1;return r[a]=o,r},t.cartesian_product=function(...e){return e.reduce(((e,n)=>e.flatMap((e=>n.map((n=>[].concat(e,n)))))))}},
"c010237f8b": function _(t,i,e,s,h){s();const a=t("@bokehjs/models/mappers"),n=t("@bokehjs/core/util/array");class c{constructor(t,i,e={}){this.parent=t,this.mapper=i,this.options=e,e.ticksNum||(e.ticksNum=5),e.fontFamily||(e.fontFamily="Arial"),e.fontSize||(e.fontSize="12px"),e.ticksSize||(e.ticksSize=2),this.canvas=document.createElement("canvas"),this.canvas.style.width="100%",this.parent.appendChild(this.canvas),this.ctx=this.canvas.getContext("2d"),this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`,this.ctx.lineWidth=e.ticksSize,e.height||(e.height=4*(this.font_height+1)+"px"),this.canvas.style.height=e.height,this.draw_colorbar()}get values(){const{min:t,max:i}=this.mapper.metrics;return(0,n.linspace)(t,i,this.options.ticksNum)}get ticks(){return this.values.map((t=>t.toExponential(3)))}get title(){return this.mapper.name?this.mapper.name:"scalars"}get font_height(){let t=0;return this.values.forEach((i=>{const{actualBoundingBoxAscent:e,actualBoundingBoxDescent:s}=this.ctx.measureText(`${i}`),h=e+s;t<h&&(t=h)})),t}draw_colorbar(){this.canvas.width=this.canvas.clientWidth,this.canvas.height=this.canvas.clientHeight;const{palette:t}=this.mapper;this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`;const i=this.font_height;this.ctx.save();const e=document.createElement("canvas"),s=t.length;e.width=s,e.height=1;const h=e.getContext("2d"),c=h.getImageData(0,0,s,1),o=new a.LinearColorMapper({palette:t}).rgba_mapper.v_compute((0,n.range)(0,t.length));c.data.set(o),h.putImageData(c,0,0),this.ctx.drawImage(e,0,2*(this.font_height+1)+1,this.canvas.width,this.canvas.height),this.ctx.restore(),this.ctx.save(),this.ctx.textAlign="center",this.ctx.fillText(this.title,this.canvas.width/2,i+1),this.ctx.restore(),this.ctx.save();const r=(0,n.linspace)(0,this.canvas.width,5);r.forEach(((t,e)=>{let s=t;0==e?(s=t+Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="left"):e==r.length-1?(s=t-Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="right"):this.ctx.textAlign="center",this.ctx.moveTo(s,2*(i+1)),this.ctx.lineTo(s,2*(i+1)+5),this.ctx.stroke(),this.ctx.fillText(`${this.ticks[e]}`,t,2*(i+1))})),this.ctx.restore()}}e.VTKColorBar=c,c.__name__="VTKColorBar"},
"ab478186ba": function _(t,i,s,e,n){e();const a=t("@bokehjs/model"),c=t("2f3fd5db07"),r=t("993f3118b2");class h extends a.Model{constructor(t){super(t)}static init_VTKAxes(){this.define((({Any:t,Array:i,Boolean:s,Number:e})=>({origin:[i(e)],xticker:[t],yticker:[t],zticker:[t],digits:[e,1],show_grid:[s,!0],grid_opacity:[e,.1],axes_opacity:[e,1],fontsize:[e,12]})))}get xticks(){return this.xticker?this.xticker.ticks:[]}get yticks(){return this.yticker?this.yticker.ticks:[]}get zticks(){return this.zticker?this.zticker.ticks:[]}get xlabels(){return this.xticker.labels?this.xticker.labels:this.xticks.map((t=>t.toFixed(this.digits)))}get ylabels(){return this.yticker.labels?this.yticker.labels:this.yticks.map((t=>t.toFixed(this.digits)))}get zlabels(){return this.zticker.labels?this.zticker.labels:this.zticks.map((t=>t.toFixed(this.digits)))}_make_grid_lines(t,i,s){const e=[];for(let n=0;n<t-1;n++)for(let t=0;t<i-1;t++){const a=n*i+t+s,c=[5,a,n*i+t+1+s,(n+1)*i+t+1+s,(n+1)*i+t+s,a];e.push(c)}return e}_create_grid_axes(){const t=[];t.push((0,r.cartesian_product)(this.xticks,this.yticks,[this.origin[2]])),t.push((0,r.cartesian_product)([this.origin[0]],this.yticks,this.zticks)),t.push((0,r.cartesian_product)(this.xticks,[this.origin[1]],this.zticks));const i=[];let s=0;i.push(this._make_grid_lines(this.xticks.length,this.yticks.length,s)),s+=this.xticks.length*this.yticks.length,i.push(this._make_grid_lines(this.yticks.length,this.zticks.length,s)),s+=this.yticks.length*this.zticks.length,i.push(this._make_grid_lines(this.xticks.length,this.zticks.length,s));const e=window.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:t.flat(2)},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:i.flat(2)}}),n=r.vtkns.Mapper.newInstance(),a=r.vtkns.Actor.newInstance();return n.setInputData(e),a.setMapper(n),a.getProperty().setOpacity(this.grid_opacity),a.setVisibility(this.show_grid),a}create_axes(t){if(null==this.origin)return{psActor:null,axesActor:null,gridActor:null};const i=[this.xticks,this.yticks,this.zticks].map(((t,i)=>{let s=null;switch(i){case 0:s=(0,r.cartesian_product)(t,[this.origin[1]],[this.origin[2]]);break;case 1:s=(0,r.cartesian_product)([this.origin[0]],t,[this.origin[2]]);break;case 2:s=(0,r.cartesian_product)([this.origin[0]],[this.origin[1]],t)}return s})).flat(2),s=window.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:i},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:[2,0,this.xticks.length-1,2,this.xticks.length,this.xticks.length+this.yticks.length-1,2,this.xticks.length+this.yticks.length,this.xticks.length+this.yticks.length+this.zticks.length-1]}}),e=r.vtkns.PixelSpaceCallbackMapper.newInstance();e.setInputData(s),e.setUseZValues(!0),e.setCallback(((i,s,n)=>{const a=t.getContext("2d");if(a){const r={height:t.clientHeight*window.devicePixelRatio,width:t.clientWidth*window.devicePixelRatio},h=e.getInputData().getPoints(),l=s.getViewMatrix();c.mat4.transpose(l,l);const o=s.getProjectionMatrix(n,-1,1);c.mat4.transpose(o,o),a.clearRect(0,0,r.width,r.height),i.forEach(((t,i)=>{const s=h.getPoint(i),e=c.vec3.fromValues(s[0],s[1],s[2]);if(c.vec3.transformMat4(e,e,l),e[2]+=.05,c.vec3.transformMat4(e,e,o),e[2]-.001<t[3]){let s;a.font="30px serif",a.textAlign="center",a.textBaseline="alphabetic",a.fillText(".",t[0],r.height-t[1]+2),a.font=this.fontsize*window.devicePixelRatio+"px serif",a.textAlign="right",a.textBaseline="top",s=i<this.xticks.length?this.xlabels[i]:i>=this.xticks.length&&i<this.xticks.length+this.yticks.length?this.ylabels[i-this.xticks.length]:this.zlabels[i-(this.xticks.length+this.yticks.length)],a.fillText(`${s}`,t[0],r.height-t[1])}}))}}));const n=r.vtkns.Actor.newInstance();n.setMapper(e);const a=r.vtkns.Mapper.newInstance();a.setInputData(s);const h=r.vtkns.Actor.newInstance();h.setMapper(a),h.getProperty().setOpacity(this.axes_opacity);return{psActor:n,axesActor:h,gridActor:this._create_grid_axes()}}}s.VTKAxes=h,h.__name__="VTKAxes",h.__module__="panel.models.vtk",h.init_VTKAxes()},
"2f3fd5db07": function _(t,c,a,o,r){o();const _=t("tslib"),m=(0,_.__importStar)(t("68ca94c15c"));a.glMatrix=m;const i=(0,_.__importStar)(t("7c0b8e6048"));a.mat2=i;const n=(0,_.__importStar)(t("dc03f0a621"));a.mat2d=n;const s=(0,_.__importStar)(t("0285c50a7e"));a.mat3=s;const p=(0,_.__importStar)(t("a427635f32"));a.mat4=p;const S=(0,_.__importStar)(t("eb06fc032a"));a.quat=S;const e=(0,_.__importStar)(t("277615c682"));a.quat2=e;const f=(0,_.__importStar)(t("c56d9ff837"));a.vec2=f;const b=(0,_.__importStar)(t("2c5eb22089"));a.vec3=b;const d=(0,_.__importStar)(t("c1aa33d719"));a.vec4=d},
"68ca94c15c": function _(t,a,r,n,o){n(),r.EPSILON=1e-6,r.ARRAY_TYPE="undefined"!=typeof Float32Array?Float32Array:Array,r.RANDOM=Math.random,r.setMatrixArrayType=function(t){r.ARRAY_TYPE=t};var h=Math.PI/180;r.toRadian=function(t){return t*h},r.equals=function(t,a){return Math.abs(t-a)<=r.EPSILON*Math.max(1,Math.abs(t),Math.abs(a))},Math.hypot||(Math.hypot=function(){for(var t=0,a=arguments.length;a--;)t+=arguments[a]*arguments[a];return Math.sqrt(t)})},
"7c0b8e6048": function _(t,n,r,a,u){a();const e=(0,t("tslib").__importStar)(t("68ca94c15c"));function o(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=r[0],i=r[1],f=r[2],s=r[3];return t[0]=a*c+e*i,t[1]=u*c+o*i,t[2]=a*f+e*s,t[3]=u*f+o*s,t}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}r.create=function(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.transpose=function(t,n){if(t===n){var r=n[1];t[1]=n[2],t[2]=r}else t[0]=n[0],t[1]=n[2],t[2]=n[1],t[3]=n[3];return t},r.invert=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*e-u*a;return o?(o=1/o,t[0]=e*o,t[1]=-a*o,t[2]=-u*o,t[3]=r*o,t):null},r.adjoint=function(t,n){var r=n[0];return t[0]=n[3],t[1]=-n[1],t[2]=-n[2],t[3]=r,t},r.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},r.multiply=o,r.rotate=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=Math.sin(r),i=Math.cos(r);return t[0]=a*i+e*c,t[1]=u*i+o*c,t[2]=a*-c+e*i,t[3]=u*-c+o*i,t},r.scale=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],c=r[0],i=r[1];return t[0]=a*c,t[1]=u*c,t[2]=e*i,t[3]=o*i,t},r.fromRotation=function(t,n){var r=Math.sin(n),a=Math.cos(n);return t[0]=a,t[1]=r,t[2]=-r,t[3]=a,t},r.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t},r.str=function(t){return"mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},r.LDU=function(t,n,r,a){return t[2]=a[2]/a[0],r[0]=a[0],r[1]=a[1],r[3]=a[3]-t[2]*r[1],[t,n,r]},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=c,r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],c=n[0],i=n[1],f=n[2],s=n[3];return Math.abs(r-c)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(c))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-f)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(o-s)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(s))},r.multiplyScalar=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.multiplyScalarAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.mul=o,r.sub=c},
"dc03f0a621": function _(t,n,a,r,u){r();const o=(0,t("tslib").__importStar)(t("68ca94c15c"));function e(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1],f=a[2],M=a[3],b=a[4],l=a[5];return t[0]=r*s+o*h,t[1]=u*s+e*h,t[2]=r*f+o*M,t[3]=u*f+e*M,t[4]=r*b+o*l+c,t[5]=u*b+e*l+i,t}function c(t,n,a){return t[0]=n[0]-a[0],t[1]=n[1]-a[1],t[2]=n[2]-a[2],t[3]=n[3]-a[3],t[4]=n[4]-a[4],t[5]=n[5]-a[5],t}a.create=function(){var t=new o.ARRAY_TYPE(6);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0),t[0]=1,t[3]=1,t},a.clone=function(t){var n=new o.ARRAY_TYPE(6);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n},a.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t},a.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},a.fromValues=function(t,n,a,r,u,e){var c=new o.ARRAY_TYPE(6);return c[0]=t,c[1]=n,c[2]=a,c[3]=r,c[4]=u,c[5]=e,c},a.set=function(t,n,a,r,u,o,e){return t[0]=n,t[1]=a,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t},a.invert=function(t,n){var a=n[0],r=n[1],u=n[2],o=n[3],e=n[4],c=n[5],i=a*o-r*u;return i?(i=1/i,t[0]=o*i,t[1]=-r*i,t[2]=-u*i,t[3]=a*i,t[4]=(u*c-o*e)*i,t[5]=(r*e-a*c)*i,t):null},a.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},a.multiply=e,a.rotate=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=Math.sin(a),h=Math.cos(a);return t[0]=r*h+o*s,t[1]=u*h+e*s,t[2]=r*-s+o*h,t[3]=u*-s+e*h,t[4]=c,t[5]=i,t},a.scale=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1];return t[0]=r*s,t[1]=u*s,t[2]=o*h,t[3]=e*h,t[4]=c,t[5]=i,t},a.translate=function(t,n,a){var r=n[0],u=n[1],o=n[2],e=n[3],c=n[4],i=n[5],s=a[0],h=a[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=r*s+o*h+c,t[5]=u*s+e*h+i,t},a.fromRotation=function(t,n){var a=Math.sin(n),r=Math.cos(n);return t[0]=r,t[1]=a,t[2]=-a,t[3]=r,t[4]=0,t[5]=0,t},a.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t[4]=0,t[5]=0,t},a.fromTranslation=function(t,n){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=n[0],t[5]=n[1],t},a.str=function(t){return"mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},a.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},a.add=function(t,n,a){return t[0]=n[0]+a[0],t[1]=n[1]+a[1],t[2]=n[2]+a[2],t[3]=n[3]+a[3],t[4]=n[4]+a[4],t[5]=n[5]+a[5],t},a.subtract=c,a.multiplyScalar=function(t,n,a){return t[0]=n[0]*a,t[1]=n[1]*a,t[2]=n[2]*a,t[3]=n[3]*a,t[4]=n[4]*a,t[5]=n[5]*a,t},a.multiplyScalarAndAdd=function(t,n,a,r){return t[0]=n[0]+a[0]*r,t[1]=n[1]+a[1]*r,t[2]=n[2]+a[2]*r,t[3]=n[3]+a[3]*r,t[4]=n[4]+a[4]*r,t[5]=n[5]+a[5]*r,t},a.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]&&t[4]===n[4]&&t[5]===n[5]},a.equals=function(t,n){var a=t[0],r=t[1],u=t[2],e=t[3],c=t[4],i=t[5],s=n[0],h=n[1],f=n[2],M=n[3],b=n[4],l=n[5];return Math.abs(a-s)<=o.EPSILON*Math.max(1,Math.abs(a),Math.abs(s))&&Math.abs(r-h)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(h))&&Math.abs(u-f)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(e-M)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(M))&&Math.abs(c-b)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(b))&&Math.abs(i-l)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))},a.mul=e,a.sub=c},
"0285c50a7e": function _(t,a,n,r,u){r();const o=(0,t("tslib").__importStar)(t("68ca94c15c"));function e(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=n[0],b=n[1],l=n[2],m=n[3],v=n[4],E=n[5],P=n[6],S=n[7],A=n[8];return t[0]=f*r+b*e+l*s,t[1]=f*u+b*i+l*M,t[2]=f*o+b*c+l*h,t[3]=m*r+v*e+E*s,t[4]=m*u+v*i+E*M,t[5]=m*o+v*c+E*h,t[6]=P*r+S*e+A*s,t[7]=P*u+S*i+A*M,t[8]=P*o+S*c+A*h,t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t}n.create=function(){var t=new o.ARRAY_TYPE(9);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t},n.fromMat4=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[4],t[4]=a[5],t[5]=a[6],t[6]=a[8],t[7]=a[9],t[8]=a[10],t},n.clone=function(t){var a=new o.ARRAY_TYPE(9);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromValues=function(t,a,n,r,u,e,i,c,s){var M=new o.ARRAY_TYPE(9);return M[0]=t,M[1]=a,M[2]=n,M[3]=r,M[4]=u,M[5]=e,M[6]=i,M[7]=c,M[8]=s,M},n.set=function(t,a,n,r,u,o,e,i,c,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t[6]=i,t[7]=c,t[8]=s,t},n.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],u=a[5];t[1]=a[3],t[2]=a[6],t[3]=n,t[5]=a[7],t[6]=r,t[7]=u}else t[0]=a[0],t[1]=a[3],t[2]=a[6],t[3]=a[1],t[4]=a[4],t[5]=a[7],t[6]=a[2],t[7]=a[5],t[8]=a[8];return t},n.invert=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8],h=M*e-i*s,f=-M*o+i*c,b=s*o-e*c,l=n*h+r*f+u*b;return l?(l=1/l,t[0]=h*l,t[1]=(-M*r+u*s)*l,t[2]=(i*r-u*e)*l,t[3]=f*l,t[4]=(M*n-u*c)*l,t[5]=(-i*n+u*o)*l,t[6]=b*l,t[7]=(-s*n+r*c)*l,t[8]=(e*n-r*o)*l,t):null},n.adjoint=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8];return t[0]=e*M-i*s,t[1]=u*s-r*M,t[2]=r*i-u*e,t[3]=i*c-o*M,t[4]=n*M-u*c,t[5]=u*o-n*i,t[6]=o*s-e*c,t[7]=r*c-n*s,t[8]=n*e-r*o,t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],u=t[3],o=t[4],e=t[5],i=t[6],c=t[7],s=t[8];return a*(s*o-e*c)+n*(-s*u+e*i)+r*(c*u-o*i)},n.multiply=e,n.translate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=n[0],b=n[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=i,t[5]=c,t[6]=f*r+b*e+s,t[7]=f*u+b*i+M,t[8]=f*o+b*c+h,t},n.rotate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],c=a[5],s=a[6],M=a[7],h=a[8],f=Math.sin(n),b=Math.cos(n);return t[0]=b*r+f*e,t[1]=b*u+f*i,t[2]=b*o+f*c,t[3]=b*e-f*r,t[4]=b*i-f*u,t[5]=b*c-f*o,t[6]=s,t[7]=M,t[8]=h,t},n.scale=function(t,a,n){var r=n[0],u=n[1];return t[0]=r*a[0],t[1]=r*a[1],t[2]=r*a[2],t[3]=u*a[3],t[4]=u*a[4],t[5]=u*a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=a[0],t[7]=a[1],t[8]=1,t},n.fromRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=-n,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=a[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromMat2d=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=0,t[3]=a[2],t[4]=a[3],t[5]=0,t[6]=a[4],t[7]=a[5],t[8]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=n+n,i=r+r,c=u+u,s=n*e,M=r*e,h=r*i,f=u*e,b=u*i,l=u*c,m=o*e,v=o*i,E=o*c;return t[0]=1-h-l,t[3]=M-E,t[6]=f+v,t[1]=M+E,t[4]=1-s-l,t[7]=b-m,t[2]=f-v,t[5]=b+m,t[8]=1-s-h,t},n.normalFromMat4=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],c=a[6],s=a[7],M=a[8],h=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],E=a[15],P=n*i-r*e,S=n*c-u*e,A=n*s-o*e,x=r*c-u*i,d=r*s-o*i,I=u*s-o*c,L=M*m-h*l,N=M*v-f*l,O=M*E-b*l,R=h*v-f*m,p=h*E-b*m,Y=f*E-b*v,y=P*Y-S*p+A*R+x*O-d*N+I*L;return y?(y=1/y,t[0]=(i*Y-c*p+s*R)*y,t[1]=(c*O-e*Y-s*N)*y,t[2]=(e*p-i*O+s*L)*y,t[3]=(u*p-r*Y-o*R)*y,t[4]=(n*Y-u*O+o*N)*y,t[5]=(r*O-n*p-o*L)*y,t[6]=(m*I-v*d+E*x)*y,t[7]=(v*A-l*I-E*S)*y,t[8]=(l*d-m*A+E*P)*y,t):null},n.projection=function(t,a,n){return t[0]=2/a,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/n,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},n.str=function(t){return"mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]},n.equals=function(t,a){var n=t[0],r=t[1],u=t[2],e=t[3],i=t[4],c=t[5],s=t[6],M=t[7],h=t[8],f=a[0],b=a[1],l=a[2],m=a[3],v=a[4],E=a[5],P=a[6],S=a[7],A=a[8];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-b)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(e-m)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(m))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(c-E)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(E))&&Math.abs(s-P)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(P))&&Math.abs(M-S)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(S))&&Math.abs(h-A)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))},n.mul=e,n.sub=i},
"a427635f32": function _(t,a,n,r,h){r();const o=(0,t("tslib").__importStar)(t("68ca94c15c"));function u(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function M(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],M=a[4],s=a[5],e=a[6],i=a[7],c=a[8],f=a[9],b=a[10],l=a[11],m=a[12],v=a[13],P=a[14],E=a[15],S=n[0],I=n[1],O=n[2],L=n[3];return t[0]=S*r+I*M+O*c+L*m,t[1]=S*h+I*s+O*f+L*v,t[2]=S*o+I*e+O*b+L*P,t[3]=S*u+I*i+O*l+L*E,S=n[4],I=n[5],O=n[6],L=n[7],t[4]=S*r+I*M+O*c+L*m,t[5]=S*h+I*s+O*f+L*v,t[6]=S*o+I*e+O*b+L*P,t[7]=S*u+I*i+O*l+L*E,S=n[8],I=n[9],O=n[10],L=n[11],t[8]=S*r+I*M+O*c+L*m,t[9]=S*h+I*s+O*f+L*v,t[10]=S*o+I*e+O*b+L*P,t[11]=S*u+I*i+O*l+L*E,S=n[12],I=n[13],O=n[14],L=n[15],t[12]=S*r+I*M+O*c+L*m,t[13]=S*h+I*s+O*f+L*v,t[14]=S*o+I*e+O*b+L*P,t[15]=S*u+I*i+O*l+L*E,t}function s(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],M=r+r,s=h+h,e=o+o,i=r*M,c=r*s,f=r*e,b=h*s,l=h*e,m=o*e,v=u*M,P=u*s,E=u*e;return t[0]=1-(b+m),t[1]=c+E,t[2]=f-P,t[3]=0,t[4]=c-E,t[5]=1-(i+m),t[6]=l+v,t[7]=0,t[8]=f+P,t[9]=l-v,t[10]=1-(i+b),t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t}function e(t,a){var n=a[0],r=a[1],h=a[2],o=a[4],u=a[5],M=a[6],s=a[8],e=a[9],i=a[10];return t[0]=Math.hypot(n,r,h),t[1]=Math.hypot(o,u,M),t[2]=Math.hypot(s,e,i),t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t[9]=a[9]-n[9],t[10]=a[10]-n[10],t[11]=a[11]-n[11],t[12]=a[12]-n[12],t[13]=a[13]-n[13],t[14]=a[14]-n[14],t[15]=a[15]-n[15],t}n.create=function(){var t=new o.ARRAY_TYPE(16);return o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(16);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a[9]=t[9],a[10]=t[10],a[11]=t[11],a[12]=t[12],a[13]=t[13],a[14]=t[14],a[15]=t[15],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.fromValues=function(t,a,n,r,h,u,M,s,e,i,c,f,b,l,m,v){var P=new o.ARRAY_TYPE(16);return P[0]=t,P[1]=a,P[2]=n,P[3]=r,P[4]=h,P[5]=u,P[6]=M,P[7]=s,P[8]=e,P[9]=i,P[10]=c,P[11]=f,P[12]=b,P[13]=l,P[14]=m,P[15]=v,P},n.set=function(t,a,n,r,h,o,u,M,s,e,i,c,f,b,l,m,v){return t[0]=a,t[1]=n,t[2]=r,t[3]=h,t[4]=o,t[5]=u,t[6]=M,t[7]=s,t[8]=e,t[9]=i,t[10]=c,t[11]=f,t[12]=b,t[13]=l,t[14]=m,t[15]=v,t},n.identity=u,n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],h=a[3],o=a[6],u=a[7],M=a[11];t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=n,t[6]=a[9],t[7]=a[13],t[8]=r,t[9]=o,t[11]=a[14],t[12]=h,t[13]=u,t[14]=M}else t[0]=a[0],t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=a[1],t[5]=a[5],t[6]=a[9],t[7]=a[13],t[8]=a[2],t[9]=a[6],t[10]=a[10],t[11]=a[14],t[12]=a[3],t[13]=a[7],t[14]=a[11],t[15]=a[15];return t},n.invert=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],M=a[5],s=a[6],e=a[7],i=a[8],c=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],P=a[15],E=n*M-r*u,S=n*s-h*u,I=n*e-o*u,O=r*s-h*M,L=r*e-o*M,N=h*e-o*s,p=i*m-c*l,R=i*v-f*l,x=i*P-b*l,A=c*v-f*m,y=c*P-b*m,Y=f*P-b*v,g=E*Y-S*y+I*A+O*x-L*R+N*p;return g?(g=1/g,t[0]=(M*Y-s*y+e*A)*g,t[1]=(h*y-r*Y-o*A)*g,t[2]=(m*N-v*L+P*O)*g,t[3]=(f*L-c*N-b*O)*g,t[4]=(s*x-u*Y-e*R)*g,t[5]=(n*Y-h*x+o*R)*g,t[6]=(v*I-l*N-P*S)*g,t[7]=(i*N-f*I+b*S)*g,t[8]=(u*y-M*x+e*p)*g,t[9]=(r*x-n*y-o*p)*g,t[10]=(l*L-m*I+P*E)*g,t[11]=(c*I-i*L-b*E)*g,t[12]=(M*R-u*A-s*p)*g,t[13]=(n*A-r*R+h*p)*g,t[14]=(m*S-l*O-v*E)*g,t[15]=(i*O-c*S+f*E)*g,t):null},n.adjoint=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],M=a[5],s=a[6],e=a[7],i=a[8],c=a[9],f=a[10],b=a[11],l=a[12],m=a[13],v=a[14],P=a[15];return t[0]=M*(f*P-b*v)-c*(s*P-e*v)+m*(s*b-e*f),t[1]=-(r*(f*P-b*v)-c*(h*P-o*v)+m*(h*b-o*f)),t[2]=r*(s*P-e*v)-M*(h*P-o*v)+m*(h*e-o*s),t[3]=-(r*(s*b-e*f)-M*(h*b-o*f)+c*(h*e-o*s)),t[4]=-(u*(f*P-b*v)-i*(s*P-e*v)+l*(s*b-e*f)),t[5]=n*(f*P-b*v)-i*(h*P-o*v)+l*(h*b-o*f),t[6]=-(n*(s*P-e*v)-u*(h*P-o*v)+l*(h*e-o*s)),t[7]=n*(s*b-e*f)-u*(h*b-o*f)+i*(h*e-o*s),t[8]=u*(c*P-b*m)-i*(M*P-e*m)+l*(M*b-e*c),t[9]=-(n*(c*P-b*m)-i*(r*P-o*m)+l*(r*b-o*c)),t[10]=n*(M*P-e*m)-u*(r*P-o*m)+l*(r*e-o*M),t[11]=-(n*(M*b-e*c)-u*(r*b-o*c)+i*(r*e-o*M)),t[12]=-(u*(c*v-f*m)-i*(M*v-s*m)+l*(M*f-s*c)),t[13]=n*(c*v-f*m)-i*(r*v-h*m)+l*(r*f-h*c),t[14]=-(n*(M*v-s*m)-u*(r*v-h*m)+l*(r*s-h*M)),t[15]=n*(M*f-s*c)-u*(r*f-h*c)+i*(r*s-h*M),t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],h=t[3],o=t[4],u=t[5],M=t[6],s=t[7],e=t[8],i=t[9],c=t[10],f=t[11],b=t[12],l=t[13],m=t[14],v=t[15];return(a*u-n*o)*(c*v-f*m)-(a*M-r*o)*(i*v-f*l)+(a*s-h*o)*(i*m-c*l)+(n*M-r*u)*(e*v-f*b)-(n*s-h*u)*(e*m-c*b)+(r*s-h*M)*(e*l-i*b)},n.multiply=M,n.translate=function(t,a,n){var r,h,o,u,M,s,e,i,c,f,b,l,m=n[0],v=n[1],P=n[2];return a===t?(t[12]=a[0]*m+a[4]*v+a[8]*P+a[12],t[13]=a[1]*m+a[5]*v+a[9]*P+a[13],t[14]=a[2]*m+a[6]*v+a[10]*P+a[14],t[15]=a[3]*m+a[7]*v+a[11]*P+a[15]):(r=a[0],h=a[1],o=a[2],u=a[3],M=a[4],s=a[5],e=a[6],i=a[7],c=a[8],f=a[9],b=a[10],l=a[11],t[0]=r,t[1]=h,t[2]=o,t[3]=u,t[4]=M,t[5]=s,t[6]=e,t[7]=i,t[8]=c,t[9]=f,t[10]=b,t[11]=l,t[12]=r*m+M*v+c*P+a[12],t[13]=h*m+s*v+f*P+a[13],t[14]=o*m+e*v+b*P+a[14],t[15]=u*m+i*v+l*P+a[15]),t},n.scale=function(t,a,n){var r=n[0],h=n[1],o=n[2];return t[0]=a[0]*r,t[1]=a[1]*r,t[2]=a[2]*r,t[3]=a[3]*r,t[4]=a[4]*h,t[5]=a[5]*h,t[6]=a[6]*h,t[7]=a[7]*h,t[8]=a[8]*o,t[9]=a[9]*o,t[10]=a[10]*o,t[11]=a[11]*o,t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.rotate=function(t,a,n,r){var h,u,M,s,e,i,c,f,b,l,m,v,P,E,S,I,O,L,N,p,R,x,A,y,Y=r[0],g=r[1],T=r[2],d=Math.hypot(Y,g,T);return d<o.EPSILON?null:(Y*=d=1/d,g*=d,T*=d,h=Math.sin(n),M=1-(u=Math.cos(n)),s=a[0],e=a[1],i=a[2],c=a[3],f=a[4],b=a[5],l=a[6],m=a[7],v=a[8],P=a[9],E=a[10],S=a[11],I=Y*Y*M+u,O=g*Y*M+T*h,L=T*Y*M-g*h,N=Y*g*M-T*h,p=g*g*M+u,R=T*g*M+Y*h,x=Y*T*M+g*h,A=g*T*M-Y*h,y=T*T*M+u,t[0]=s*I+f*O+v*L,t[1]=e*I+b*O+P*L,t[2]=i*I+l*O+E*L,t[3]=c*I+m*O+S*L,t[4]=s*N+f*p+v*R,t[5]=e*N+b*p+P*R,t[6]=i*N+l*p+E*R,t[7]=c*N+m*p+S*R,t[8]=s*x+f*A+v*y,t[9]=e*x+b*A+P*y,t[10]=i*x+l*A+E*y,t[11]=c*x+m*A+S*y,a!==t&&(t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t)},n.rotateX=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[4],u=a[5],M=a[6],s=a[7],e=a[8],i=a[9],c=a[10],f=a[11];return a!==t&&(t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[4]=o*h+e*r,t[5]=u*h+i*r,t[6]=M*h+c*r,t[7]=s*h+f*r,t[8]=e*h-o*r,t[9]=i*h-u*r,t[10]=c*h-M*r,t[11]=f*h-s*r,t},n.rotateY=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],M=a[2],s=a[3],e=a[8],i=a[9],c=a[10],f=a[11];return a!==t&&(t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[0]=o*h-e*r,t[1]=u*h-i*r,t[2]=M*h-c*r,t[3]=s*h-f*r,t[8]=o*r+e*h,t[9]=u*r+i*h,t[10]=M*r+c*h,t[11]=s*r+f*h,t},n.rotateZ=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],M=a[2],s=a[3],e=a[4],i=a[5],c=a[6],f=a[7];return a!==t&&(t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]),t[0]=o*h+e*r,t[1]=u*h+i*r,t[2]=M*h+c*r,t[3]=s*h+f*r,t[4]=e*h-o*r,t[5]=i*h-u*r,t[6]=c*h-M*r,t[7]=f*h-s*r,t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=a[0],t[13]=a[1],t[14]=a[2],t[15]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=a[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotation=function(t,a,n){var r,h,u,M=n[0],s=n[1],e=n[2],i=Math.hypot(M,s,e);return i<o.EPSILON?null:(M*=i=1/i,s*=i,e*=i,r=Math.sin(a),u=1-(h=Math.cos(a)),t[0]=M*M*u+h,t[1]=s*M*u+e*r,t[2]=e*M*u-s*r,t[3]=0,t[4]=M*s*u-e*r,t[5]=s*s*u+h,t[6]=e*s*u+M*r,t[7]=0,t[8]=M*e*u+s*r,t[9]=s*e*u-M*r,t[10]=e*e*u+h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t)},n.fromXRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=r,t[6]=n,t[7]=0,t[8]=0,t[9]=-n,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromYRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=0,t[2]=-n,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=n,t[9]=0,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromZRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=0,t[4]=-n,t[5]=r,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotationTranslation=s,n.fromQuat2=function(t,a){var n=new o.ARRAY_TYPE(3),r=-a[0],h=-a[1],u=-a[2],M=a[3],e=a[4],i=a[5],c=a[6],f=a[7],b=r*r+h*h+u*u+M*M;return b>0?(n[0]=2*(e*M+f*r+i*u-c*h)/b,n[1]=2*(i*M+f*h+c*r-e*u)/b,n[2]=2*(c*M+f*u+e*h-i*r)/b):(n[0]=2*(e*M+f*r+i*u-c*h),n[1]=2*(i*M+f*h+c*r-e*u),n[2]=2*(c*M+f*u+e*h-i*r)),s(t,a,n),t},n.getTranslation=function(t,a){return t[0]=a[12],t[1]=a[13],t[2]=a[14],t},n.getScaling=e,n.getRotation=function(t,a){var n=new o.ARRAY_TYPE(3);e(n,a);var r=1/n[0],h=1/n[1],u=1/n[2],M=a[0]*r,s=a[1]*h,i=a[2]*u,c=a[4]*r,f=a[5]*h,b=a[6]*u,l=a[8]*r,m=a[9]*h,v=a[10]*u,P=M+f+v,E=0;return P>0?(E=2*Math.sqrt(P+1),t[3]=.25*E,t[0]=(b-m)/E,t[1]=(l-i)/E,t[2]=(s-c)/E):M>f&&M>v?(E=2*Math.sqrt(1+M-f-v),t[3]=(b-m)/E,t[0]=.25*E,t[1]=(s+c)/E,t[2]=(l+i)/E):f>v?(E=2*Math.sqrt(1+f-M-v),t[3]=(l-i)/E,t[0]=(s+c)/E,t[1]=.25*E,t[2]=(b+m)/E):(E=2*Math.sqrt(1+v-M-f),t[3]=(s-c)/E,t[0]=(l+i)/E,t[1]=(b+m)/E,t[2]=.25*E),t},n.fromRotationTranslationScale=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],M=a[3],s=h+h,e=o+o,i=u+u,c=h*s,f=h*e,b=h*i,l=o*e,m=o*i,v=u*i,P=M*s,E=M*e,S=M*i,I=r[0],O=r[1],L=r[2];return t[0]=(1-(l+v))*I,t[1]=(f+S)*I,t[2]=(b-E)*I,t[3]=0,t[4]=(f-S)*O,t[5]=(1-(c+v))*O,t[6]=(m+P)*O,t[7]=0,t[8]=(b+E)*L,t[9]=(m-P)*L,t[10]=(1-(c+l))*L,t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t},n.fromRotationTranslationScaleOrigin=function(t,a,n,r,h){var o=a[0],u=a[1],M=a[2],s=a[3],e=o+o,i=u+u,c=M+M,f=o*e,b=o*i,l=o*c,m=u*i,v=u*c,P=M*c,E=s*e,S=s*i,I=s*c,O=r[0],L=r[1],N=r[2],p=h[0],R=h[1],x=h[2],A=(1-(m+P))*O,y=(b+I)*O,Y=(l-S)*O,g=(b-I)*L,T=(1-(f+P))*L,d=(v+E)*L,_=(l+S)*N,q=(v-E)*N,w=(1-(f+m))*N;return t[0]=A,t[1]=y,t[2]=Y,t[3]=0,t[4]=g,t[5]=T,t[6]=d,t[7]=0,t[8]=_,t[9]=q,t[10]=w,t[11]=0,t[12]=n[0]+p-(A*p+g*R+_*x),t[13]=n[1]+R-(y*p+T*R+q*x),t[14]=n[2]+x-(Y*p+d*R+w*x),t[15]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=n+n,M=r+r,s=h+h,e=n*u,i=r*u,c=r*M,f=h*u,b=h*M,l=h*s,m=o*u,v=o*M,P=o*s;return t[0]=1-c-l,t[1]=i+P,t[2]=f-v,t[3]=0,t[4]=i-P,t[5]=1-e-l,t[6]=b+m,t[7]=0,t[8]=f+v,t[9]=b-m,t[10]=1-e-c,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.frustum=function(t,a,n,r,h,o,u){var M=1/(n-a),s=1/(h-r),e=1/(o-u);return t[0]=2*o*M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*o*s,t[6]=0,t[7]=0,t[8]=(n+a)*M,t[9]=(h+r)*s,t[10]=(u+o)*e,t[11]=-1,t[12]=0,t[13]=0,t[14]=u*o*2*e,t[15]=0,t},n.perspective=function(t,a,n,r,h){var o,u=1/Math.tan(a/2);return t[0]=u/n,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=h&&h!==1/0?(o=1/(r-h),t[10]=(h+r)*o,t[14]=2*h*r*o):(t[10]=-1,t[14]=-2*r),t},n.perspectiveFromFieldOfView=function(t,a,n,r){var h=Math.tan(a.upDegrees*Math.PI/180),o=Math.tan(a.downDegrees*Math.PI/180),u=Math.tan(a.leftDegrees*Math.PI/180),M=Math.tan(a.rightDegrees*Math.PI/180),s=2/(u+M),e=2/(h+o);return t[0]=s,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=-(u-M)*s*.5,t[9]=(h-o)*e*.5,t[10]=r/(n-r),t[11]=-1,t[12]=0,t[13]=0,t[14]=r*n/(n-r),t[15]=0,t},n.ortho=function(t,a,n,r,h,o,u){var M=1/(a-n),s=1/(r-h),e=1/(o-u);return t[0]=-2*M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*s,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*e,t[11]=0,t[12]=(a+n)*M,t[13]=(h+r)*s,t[14]=(u+o)*e,t[15]=1,t},n.lookAt=function(t,a,n,r){var h,M,s,e,i,c,f,b,l,m,v=a[0],P=a[1],E=a[2],S=r[0],I=r[1],O=r[2],L=n[0],N=n[1],p=n[2];return Math.abs(v-L)<o.EPSILON&&Math.abs(P-N)<o.EPSILON&&Math.abs(E-p)<o.EPSILON?u(t):(f=v-L,b=P-N,l=E-p,h=I*(l*=m=1/Math.hypot(f,b,l))-O*(b*=m),M=O*(f*=m)-S*l,s=S*b-I*f,(m=Math.hypot(h,M,s))?(h*=m=1/m,M*=m,s*=m):(h=0,M=0,s=0),e=b*s-l*M,i=l*h-f*s,c=f*M-b*h,(m=Math.hypot(e,i,c))?(e*=m=1/m,i*=m,c*=m):(e=0,i=0,c=0),t[0]=h,t[1]=e,t[2]=f,t[3]=0,t[4]=M,t[5]=i,t[6]=b,t[7]=0,t[8]=s,t[9]=c,t[10]=l,t[11]=0,t[12]=-(h*v+M*P+s*E),t[13]=-(e*v+i*P+c*E),t[14]=-(f*v+b*P+l*E),t[15]=1,t)},n.targetTo=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],M=r[0],s=r[1],e=r[2],i=h-n[0],c=o-n[1],f=u-n[2],b=i*i+c*c+f*f;b>0&&(i*=b=1/Math.sqrt(b),c*=b,f*=b);var l=s*f-e*c,m=e*i-M*f,v=M*c-s*i;return(b=l*l+m*m+v*v)>0&&(l*=b=1/Math.sqrt(b),m*=b,v*=b),t[0]=l,t[1]=m,t[2]=v,t[3]=0,t[4]=c*v-f*m,t[5]=f*l-i*v,t[6]=i*m-c*l,t[7]=0,t[8]=i,t[9]=c,t[10]=f,t[11]=0,t[12]=h,t[13]=o,t[14]=u,t[15]=1,t},n.str=function(t){return"mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t[9]=a[9]+n[9],t[10]=a[10]+n[10],t[11]=a[11]+n[11],t[12]=a[12]+n[12],t[13]=a[13]+n[13],t[14]=a[14]+n[14],t[15]=a[15]+n[15],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t[9]=a[9]*n,t[10]=a[10]*n,t[11]=a[11]*n,t[12]=a[12]*n,t[13]=a[13]*n,t[14]=a[14]*n,t[15]=a[15]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t[9]=a[9]+n[9]*r,t[10]=a[10]+n[10]*r,t[11]=a[11]+n[11]*r,t[12]=a[12]+n[12]*r,t[13]=a[13]+n[13]*r,t[14]=a[14]+n[14]*r,t[15]=a[15]+n[15]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]&&t[9]===a[9]&&t[10]===a[10]&&t[11]===a[11]&&t[12]===a[12]&&t[13]===a[13]&&t[14]===a[14]&&t[15]===a[15]},n.equals=function(t,a){var n=t[0],r=t[1],h=t[2],u=t[3],M=t[4],s=t[5],e=t[6],i=t[7],c=t[8],f=t[9],b=t[10],l=t[11],m=t[12],v=t[13],P=t[14],E=t[15],S=a[0],I=a[1],O=a[2],L=a[3],N=a[4],p=a[5],R=a[6],x=a[7],A=a[8],y=a[9],Y=a[10],g=a[11],T=a[12],d=a[13],_=a[14],q=a[15];return Math.abs(n-S)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(S))&&Math.abs(r-I)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(I))&&Math.abs(h-O)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(O))&&Math.abs(u-L)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(L))&&Math.abs(M-N)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(N))&&Math.abs(s-p)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(p))&&Math.abs(e-R)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(R))&&Math.abs(i-x)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(c-A)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(A))&&Math.abs(f-y)<=o.EPSILON*Math.max(1,Math.abs(f),Math.abs(y))&&Math.abs(b-Y)<=o.EPSILON*Math.max(1,Math.abs(b),Math.abs(Y))&&Math.abs(l-g)<=o.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(m-T)<=o.EPSILON*Math.max(1,Math.abs(m),Math.abs(T))&&Math.abs(v-d)<=o.EPSILON*Math.max(1,Math.abs(v),Math.abs(d))&&Math.abs(P-_)<=o.EPSILON*Math.max(1,Math.abs(P),Math.abs(_))&&Math.abs(E-q)<=o.EPSILON*Math.max(1,Math.abs(E),Math.abs(q))},n.mul=M,n.sub=i},
"eb06fc032a": function _(t,a,r,n,e){n();const o=t("tslib"),s=(0,o.__importStar)(t("68ca94c15c")),u=(0,o.__importStar)(t("0285c50a7e")),c=(0,o.__importStar)(t("2c5eb22089")),i=(0,o.__importStar)(t("c1aa33d719"));function h(){var t=new s.ARRAY_TYPE(4);return s.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function M(t,a,r){r*=.5;var n=Math.sin(r);return t[0]=n*a[0],t[1]=n*a[1],t[2]=n*a[2],t[3]=Math.cos(r),t}function l(t,a,r){var n=a[0],e=a[1],o=a[2],s=a[3],u=r[0],c=r[1],i=r[2],h=r[3];return t[0]=n*h+s*u+e*i-o*c,t[1]=e*h+s*c+o*u-n*i,t[2]=o*h+s*i+n*c-e*u,t[3]=s*h-n*u-e*c-o*i,t}function f(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=Math.sqrt(r*r+n*n+e*e),u=Math.exp(o),c=s>0?u*Math.sin(s)/s:0;return t[0]=r*c,t[1]=n*c,t[2]=e*c,t[3]=u*Math.cos(s),t}function v(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=Math.sqrt(r*r+n*n+e*e),u=s>0?Math.atan2(s,o)/s:0;return t[0]=r*u,t[1]=n*u,t[2]=e*u,t[3]=.5*Math.log(r*r+n*n+e*e+o*o),t}function m(t,a,r,n){var e,o,u,c,i,h=a[0],M=a[1],l=a[2],f=a[3],v=r[0],m=r[1],q=r[2],d=r[3];return(o=h*v+M*m+l*q+f*d)<0&&(o=-o,v=-v,m=-m,q=-q,d=-d),1-o>s.EPSILON?(e=Math.acos(o),u=Math.sin(e),c=Math.sin((1-n)*e)/u,i=Math.sin(n*e)/u):(c=1-n,i=n),t[0]=c*h+i*v,t[1]=c*M+i*m,t[2]=c*l+i*q,t[3]=c*f+i*d,t}function q(t,a){var r,n=a[0]+a[4]+a[8];if(n>0)r=Math.sqrt(n+1),t[3]=.5*r,r=.5/r,t[0]=(a[5]-a[7])*r,t[1]=(a[6]-a[2])*r,t[2]=(a[1]-a[3])*r;else{var e=0;a[4]>a[0]&&(e=1),a[8]>a[3*e+e]&&(e=2);var o=(e+1)%3,s=(e+2)%3;r=Math.sqrt(a[3*e+e]-a[3*o+o]-a[3*s+s]+1),t[e]=.5*r,r=.5/r,t[3]=(a[3*o+s]-a[3*s+o])*r,t[o]=(a[3*o+e]+a[3*e+o])*r,t[s]=(a[3*s+e]+a[3*e+s])*r}return t}var d,p,A,g,_,P;r.create=h,r.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},r.setAxisAngle=M,r.getAxisAngle=function(t,a){var r=2*Math.acos(a[3]),n=Math.sin(r/2);return n>s.EPSILON?(t[0]=a[0]/n,t[1]=a[1]/n,t[2]=a[2]/n):(t[0]=1,t[1]=0,t[2]=0),r},r.getAngle=function(t,a){var n=(0,r.dot)(t,a);return Math.acos(2*n*n-1)},r.multiply=l,r.rotateX=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+s*u,t[1]=e*c+o*u,t[2]=o*c-e*u,t[3]=s*c-n*u,t},r.rotateY=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c-o*u,t[1]=e*c+s*u,t[2]=o*c+n*u,t[3]=s*c-e*u,t},r.rotateZ=function(t,a,r){r*=.5;var n=a[0],e=a[1],o=a[2],s=a[3],u=Math.sin(r),c=Math.cos(r);return t[0]=n*c+e*u,t[1]=e*c-n*u,t[2]=o*c+s*u,t[3]=s*c-o*u,t},r.calculateW=function(t,a){var r=a[0],n=a[1],e=a[2];return t[0]=r,t[1]=n,t[2]=e,t[3]=Math.sqrt(Math.abs(1-r*r-n*n-e*e)),t},r.exp=f,r.ln=v,r.pow=function(t,a,n){return v(t,a),(0,r.scale)(t,t,n),f(t,t),t},r.slerp=m,r.random=function(t){var a=s.RANDOM(),r=s.RANDOM(),n=s.RANDOM(),e=Math.sqrt(1-a),o=Math.sqrt(a);return t[0]=e*Math.sin(2*Math.PI*r),t[1]=e*Math.cos(2*Math.PI*r),t[2]=o*Math.sin(2*Math.PI*n),t[3]=o*Math.cos(2*Math.PI*n),t},r.invert=function(t,a){var r=a[0],n=a[1],e=a[2],o=a[3],s=r*r+n*n+e*e+o*o,u=s?1/s:0;return t[0]=-r*u,t[1]=-n*u,t[2]=-e*u,t[3]=o*u,t},r.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t},r.fromMat3=q,r.fromEuler=function(t,a,r,n){var e=.5*Math.PI/180;a*=e,r*=e,n*=e;var o=Math.sin(a),s=Math.cos(a),u=Math.sin(r),c=Math.cos(r),i=Math.sin(n),h=Math.cos(n);return t[0]=o*c*h-s*u*i,t[1]=s*u*h+o*c*i,t[2]=s*c*i-o*u*h,t[3]=s*c*h+o*u*i,t},r.str=function(t){return"quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.clone=i.clone,r.fromValues=i.fromValues,r.copy=i.copy,r.set=i.set,r.add=i.add,r.mul=l,r.scale=i.scale,r.dot=i.dot,r.lerp=i.lerp,r.length=i.length,r.len=r.length,r.squaredLength=i.squaredLength,r.sqrLen=r.squaredLength,r.normalize=i.normalize,r.exactEquals=i.exactEquals,r.equals=i.equals,r.rotationTo=(d=c.create(),p=c.fromValues(1,0,0),A=c.fromValues(0,1,0),function(t,a,n){var e=c.dot(a,n);return e<-.999999?(c.cross(d,p,a),c.len(d)<1e-6&&c.cross(d,A,a),c.normalize(d,d),M(t,d,Math.PI),t):e>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(c.cross(d,a,n),t[0]=d[0],t[1]=d[1],t[2]=d[2],t[3]=1+e,(0,r.normalize)(t,t))}),r.sqlerp=(g=h(),_=h(),function(t,a,r,n,e,o){return m(g,a,e,o),m(_,r,n,o),m(t,g,_,2*o*(1-o)),t}),r.setAxes=(P=u.create(),function(t,a,n,e){return P[0]=n[0],P[3]=n[1],P[6]=n[2],P[1]=e[0],P[4]=e[1],P[7]=e[2],P[2]=-a[0],P[5]=-a[1],P[8]=-a[2],(0,r.normalize)(t,q(t,P))})},
"2c5eb22089": function _(t,n,r,a,u){a();const e=(0,t("tslib").__importStar)(t("68ca94c15c"));function o(){var t=new e.ARRAY_TYPE(3);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function i(t){var n=t[0],r=t[1],a=t[2];return Math.hypot(n,r,a)}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t}function h(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t}function M(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t}function s(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return Math.hypot(r,a,u)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return r*r+a*a+u*u}function v(t){var n=t[0],r=t[1],a=t[2];return n*n+r*r+a*a}function l(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]}var m;r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(3);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n},r.length=i,r.fromValues=function(t,n,r){var a=new e.ARRAY_TYPE(3);return a[0]=t,a[1]=n,a[2]=r,a},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t},r.set=function(t,n,r,a){return t[0]=n,t[1]=r,t[2]=a,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t},r.subtract=c,r.multiply=h,r.divide=M,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t},r.distance=s,r.squaredDistance=f,r.squaredLength=v,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=r*r+a*a+u*u;return e>0&&(e=1/Math.sqrt(e)),t[0]=n[0]*e,t[1]=n[1]*e,t[2]=n[2]*e,t},r.dot=l,r.cross=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2];return t[0]=u*c-e*i,t[1]=e*o-a*c,t[2]=a*i-u*o,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t},r.hermite=function(t,n,r,a,u,e){var o=e*e,i=o*(2*e-3)+1,c=o*(e-2)+e,h=o*(e-1),M=o*(3-2*e);return t[0]=n[0]*i+r[0]*c+a[0]*h+u[0]*M,t[1]=n[1]*i+r[1]*c+a[1]*h+u[1]*M,t[2]=n[2]*i+r[2]*c+a[2]*h+u[2]*M,t},r.bezier=function(t,n,r,a,u,e){var o=1-e,i=o*o,c=e*e,h=i*o,M=3*e*i,s=3*c*o,f=c*e;return t[0]=n[0]*h+r[0]*M+a[0]*s+u[0]*f,t[1]=n[1]*h+r[1]*M+a[1]*s+u[1]*f,t[2]=n[2]*h+r[2]*M+a[2]*s+u[2]*f,t},r.random=function(t,n){n=n||1;var r=2*e.RANDOM()*Math.PI,a=2*e.RANDOM()-1,u=Math.sqrt(1-a*a)*n;return t[0]=Math.cos(r)*u,t[1]=Math.sin(r)*u,t[2]=a*n,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[3]*a+r[7]*u+r[11]*e+r[15];return o=o||1,t[0]=(r[0]*a+r[4]*u+r[8]*e+r[12])/o,t[1]=(r[1]*a+r[5]*u+r[9]*e+r[13])/o,t[2]=(r[2]*a+r[6]*u+r[10]*e+r[14])/o,t},r.transformMat3=function(t,n,r){var a=n[0],u=n[1],e=n[2];return t[0]=a*r[0]+u*r[3]+e*r[6],t[1]=a*r[1]+u*r[4]+e*r[7],t[2]=a*r[2]+u*r[5]+e*r[8],t},r.transformQuat=function(t,n,r){var a=r[0],u=r[1],e=r[2],o=r[3],i=n[0],c=n[1],h=n[2],M=u*h-e*c,s=e*i-a*h,f=a*c-u*i,v=u*f-e*s,l=e*M-a*f,m=a*s-u*M,d=2*o;return M*=d,s*=d,f*=d,v*=2,l*=2,m*=2,t[0]=i+M+v,t[1]=c+s+l,t[2]=h+f+m,t},r.rotateX=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0],e[1]=u[1]*Math.cos(a)-u[2]*Math.sin(a),e[2]=u[1]*Math.sin(a)+u[2]*Math.cos(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateY=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[2]*Math.sin(a)+u[0]*Math.cos(a),e[1]=u[1],e[2]=u[2]*Math.cos(a)-u[0]*Math.sin(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateZ=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0]*Math.cos(a)-u[1]*Math.sin(a),e[1]=u[0]*Math.sin(a)+u[1]*Math.cos(a),e[2]=u[2],t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.angle=function(t,n){var r=t[0],a=t[1],u=t[2],e=n[0],o=n[1],i=n[2],c=Math.sqrt(r*r+a*a+u*u)*Math.sqrt(e*e+o*o+i*i),h=c&&l(t,n)/c;return Math.acos(Math.min(Math.max(h,-1),1))},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},r.str=function(t){return"vec3("+t[0]+", "+t[1]+", "+t[2]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=n[0],i=n[1],c=n[2];return Math.abs(r-o)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(o))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-c)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(c))},r.sub=c,r.mul=h,r.div=M,r.dist=s,r.sqrDist=f,r.len=i,r.sqrLen=v,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=3),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2];return t})},
"c1aa33d719": function _(t,n,r,a,u){a();const e=(0,t("tslib").__importStar)(t("68ca94c15c"));function o(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function i(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}function c(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t[3]=n[3]*r[3],t}function h(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t[3]=n[3]/r[3],t}function M(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return Math.hypot(r,a,u,e)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return r*r+a*a+u*u+e*e}function s(t){var n=t[0],r=t[1],a=t[2],u=t[3];return Math.hypot(n,r,a,u)}function l(t){var n=t[0],r=t[1],a=t[2],u=t[3];return n*n+r*r+a*a+u*u}var m;r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=i,r.multiply=c,r.divide=h,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t[3]=Math.ceil(n[3]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t[3]=Math.floor(n[3]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t[3]=Math.min(n[3],r[3]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t[3]=Math.max(n[3],r[3]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t[3]=Math.round(n[3]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.distance=M,r.squaredDistance=f,r.length=s,r.squaredLength=l,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t[3]=-n[3],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t[3]=1/n[3],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*r+a*a+u*u+e*e;return o>0&&(o=1/Math.sqrt(o)),t[0]=r*o,t[1]=a*o,t[2]=u*o,t[3]=e*o,t},r.dot=function(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]+t[3]*n[3]},r.cross=function(t,n,r,a){var u=r[0]*a[1]-r[1]*a[0],e=r[0]*a[2]-r[2]*a[0],o=r[0]*a[3]-r[3]*a[0],i=r[1]*a[2]-r[2]*a[1],c=r[1]*a[3]-r[3]*a[1],h=r[2]*a[3]-r[3]*a[2],M=n[0],f=n[1],s=n[2],l=n[3];return t[0]=f*h-s*c+l*i,t[1]=-M*h+s*o-l*e,t[2]=M*c-f*o+l*u,t[3]=-M*i+f*e-s*u,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2],i=n[3];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t[3]=i+a*(r[3]-i),t},r.random=function(t,n){var r,a,u,o,i,c;n=n||1;do{i=(r=2*e.RANDOM()-1)*r+(a=2*e.RANDOM()-1)*a}while(i>=1);do{c=(u=2*e.RANDOM()-1)*u+(o=2*e.RANDOM()-1)*o}while(c>=1);var h=Math.sqrt((1-i)/c);return t[0]=n*r,t[1]=n*a,t[2]=n*u*h,t[3]=n*o*h,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3];return t[0]=r[0]*a+r[4]*u+r[8]*e+r[12]*o,t[1]=r[1]*a+r[5]*u+r[9]*e+r[13]*o,t[2]=r[2]*a+r[6]*u+r[10]*e+r[14]*o,t[3]=r[3]*a+r[7]*u+r[11]*e+r[15]*o,t},r.transformQuat=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2],h=r[3],M=h*a+i*e-c*u,f=h*u+c*a-o*e,s=h*e+o*u-i*a,l=-o*a-i*u-c*e;return t[0]=M*h+l*-o+f*-c-s*-i,t[1]=f*h+l*-i+s*-o-M*-c,t[2]=s*h+l*-c+M*-i-f*-o,t[3]=n[3],t},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},r.str=function(t){return"vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],i=n[0],c=n[1],h=n[2],M=n[3];return Math.abs(r-i)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))&&Math.abs(u-h)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(h))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))},r.sub=i,r.mul=c,r.div=h,r.dist=M,r.sqrDist=f,r.len=s,r.sqrLen=l,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=4),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],m[3]=t[o+3],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2],t[o+3]=m[3];return t})},
"277615c682": function _(t,a,n,r,e){r();const u=t("tslib"),o=(0,u.__importStar)(t("68ca94c15c")),i=(0,u.__importStar)(t("eb06fc032a")),s=(0,u.__importStar)(t("a427635f32"));function c(t,a,n){var r=.5*n[0],e=.5*n[1],u=.5*n[2],o=a[0],i=a[1],s=a[2],c=a[3];return t[0]=o,t[1]=i,t[2]=s,t[3]=c,t[4]=r*c+e*s-u*i,t[5]=e*c+u*o-r*s,t[6]=u*c+r*i-e*o,t[7]=-r*o-e*i-u*s,t}function h(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t}function f(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[4],s=n[5],c=n[6],h=n[7],f=a[4],M=a[5],b=a[6],l=a[7],v=n[0],m=n[1],R=n[2],A=n[3];return t[0]=r*A+o*v+e*R-u*m,t[1]=e*A+o*m+u*v-r*R,t[2]=u*A+o*R+r*m-e*v,t[3]=o*A-r*v-e*m-u*R,t[4]=r*h+o*i+e*c-u*s+f*A+l*v+M*R-b*m,t[5]=e*h+o*s+u*i-r*c+M*A+l*m+b*v-f*R,t[6]=u*h+o*c+r*s-e*i+b*A+l*R+f*m-M*v,t[7]=o*h-r*i-e*s-u*c+l*A-f*v-M*m-b*R,t}n.create=function(){var t=new o.ARRAY_TYPE(8);return o.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0),t[3]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(8);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a},n.fromValues=function(t,a,n,r,e,u,i,s){var c=new o.ARRAY_TYPE(8);return c[0]=t,c[1]=a,c[2]=n,c[3]=r,c[4]=e,c[5]=u,c[6]=i,c[7]=s,c},n.fromRotationTranslationValues=function(t,a,n,r,e,u,i){var s=new o.ARRAY_TYPE(8);s[0]=t,s[1]=a,s[2]=n,s[3]=r;var c=.5*e,h=.5*u,f=.5*i;return s[4]=c*r+h*n-f*a,s[5]=h*r+f*t-c*n,s[6]=f*r+c*a-h*t,s[7]=-c*t-h*a-f*n,s},n.fromRotationTranslation=c,n.fromTranslation=function(t,a){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*a[0],t[5]=.5*a[1],t[6]=.5*a[2],t[7]=0,t},n.fromRotation=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.fromMat4=function(t,a){var n=i.create();s.getRotation(n,a);var r=new o.ARRAY_TYPE(3);return s.getTranslation(r,a),c(t,n,r),t},n.copy=h,n.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.set=function(t,a,n,r,e,u,o,i,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=e,t[4]=u,t[5]=o,t[6]=i,t[7]=s,t},n.getReal=i.copy,n.getDual=function(t,a){return t[0]=a[4],t[1]=a[5],t[2]=a[6],t[3]=a[7],t},n.setReal=i.copy,n.setDual=function(t,a){return t[4]=a[0],t[5]=a[1],t[6]=a[2],t[7]=a[3],t},n.getTranslation=function(t,a){var n=a[4],r=a[5],e=a[6],u=a[7],o=-a[0],i=-a[1],s=-a[2],c=a[3];return t[0]=2*(n*c+u*o+r*s-e*i),t[1]=2*(r*c+u*i+e*o-n*s),t[2]=2*(e*c+u*s+n*i-r*o),t},n.translate=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=.5*n[0],s=.5*n[1],c=.5*n[2],h=a[4],f=a[5],M=a[6],b=a[7];return t[0]=r,t[1]=e,t[2]=u,t[3]=o,t[4]=o*i+e*c-u*s+h,t[5]=o*s+u*i-r*c+f,t[6]=o*c+r*s-e*i+M,t[7]=-r*i-e*s-u*c+b,t},n.rotateX=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateX(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateY=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateY(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateZ=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],c=a[5],h=a[6],f=a[7],M=s*o+f*r+c*u-h*e,b=c*o+f*e+h*r-s*u,l=h*o+f*u+s*e-c*r,v=f*o-s*r-c*e-h*u;return i.rotateZ(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateByQuatAppend=function(t,a,n){var r=n[0],e=n[1],u=n[2],o=n[3],i=a[0],s=a[1],c=a[2],h=a[3];return t[0]=i*o+h*r+s*u-c*e,t[1]=s*o+h*e+c*r-i*u,t[2]=c*o+h*u+i*e-s*r,t[3]=h*o-i*r-s*e-c*u,i=a[4],s=a[5],c=a[6],h=a[7],t[4]=i*o+h*r+s*u-c*e,t[5]=s*o+h*e+c*r-i*u,t[6]=c*o+h*u+i*e-s*r,t[7]=h*o-i*r-s*e-c*u,t},n.rotateByQuatPrepend=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[0],s=n[1],c=n[2],h=n[3];return t[0]=r*h+o*i+e*c-u*s,t[1]=e*h+o*s+u*i-r*c,t[2]=u*h+o*c+r*s-e*i,t[3]=o*h-r*i-e*s-u*c,i=n[4],s=n[5],c=n[6],h=n[7],t[4]=r*h+o*i+e*c-u*s,t[5]=e*h+o*s+u*i-r*c,t[6]=u*h+o*c+r*s-e*i,t[7]=o*h-r*i-e*s-u*c,t},n.rotateAroundAxis=function(t,a,n,r){if(Math.abs(r)<o.EPSILON)return h(t,a);var e=Math.hypot(n[0],n[1],n[2]);r*=.5;var u=Math.sin(r),i=u*n[0]/e,s=u*n[1]/e,c=u*n[2]/e,f=Math.cos(r),M=a[0],b=a[1],l=a[2],v=a[3];t[0]=M*f+v*i+b*c-l*s,t[1]=b*f+v*s+l*i-M*c,t[2]=l*f+v*c+M*s-b*i,t[3]=v*f-M*i-b*s-l*c;var m=a[4],R=a[5],A=a[6],E=a[7];return t[4]=m*f+E*i+R*c-A*s,t[5]=R*f+E*s+A*i-m*c,t[6]=A*f+E*c+m*s-R*i,t[7]=E*f-m*i-R*s-A*c,t},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t},n.multiply=f,n.mul=f,n.scale=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t},n.dot=i.dot,n.lerp=function(t,a,r,e){var u=1-e;return(0,n.dot)(a,r)<0&&(e=-e),t[0]=a[0]*u+r[0]*e,t[1]=a[1]*u+r[1]*e,t[2]=a[2]*u+r[2]*e,t[3]=a[3]*u+r[3]*e,t[4]=a[4]*u+r[4]*e,t[5]=a[5]*u+r[5]*e,t[6]=a[6]*u+r[6]*e,t[7]=a[7]*u+r[7]*e,t},n.invert=function(t,a){var r=(0,n.squaredLength)(a);return t[0]=-a[0]/r,t[1]=-a[1]/r,t[2]=-a[2]/r,t[3]=a[3]/r,t[4]=-a[4]/r,t[5]=-a[5]/r,t[6]=-a[6]/r,t[7]=a[7]/r,t},n.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t[4]=-a[4],t[5]=-a[5],t[6]=-a[6],t[7]=a[7],t},n.length=i.length,n.len=n.length,n.squaredLength=i.squaredLength,n.sqrLen=n.squaredLength,n.normalize=function(t,a){var r=(0,n.squaredLength)(a);if(r>0){r=Math.sqrt(r);var e=a[0]/r,u=a[1]/r,o=a[2]/r,i=a[3]/r,s=a[4],c=a[5],h=a[6],f=a[7],M=e*s+u*c+o*h+i*f;t[0]=e,t[1]=u,t[2]=o,t[3]=i,t[4]=(s-e*M)/r,t[5]=(c-u*M)/r,t[6]=(h-o*M)/r,t[7]=(f-i*M)/r}return t},n.str=function(t){return"quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]},n.equals=function(t,a){var n=t[0],r=t[1],e=t[2],u=t[3],i=t[4],s=t[5],c=t[6],h=t[7],f=a[0],M=a[1],b=a[2],l=a[3],v=a[4],m=a[5],R=a[6],A=a[7];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-M)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(M))&&Math.abs(e-b)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(s-m)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(c-R)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(R))&&Math.abs(h-A)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))}},
"c56d9ff837": function _(n,t,r,a,u){a();const e=(0,n("tslib").__importStar)(n("68ca94c15c"));function o(){var n=new e.ARRAY_TYPE(2);return e.ARRAY_TYPE!=Float32Array&&(n[0]=0,n[1]=0),n}function c(n,t,r){return n[0]=t[0]-r[0],n[1]=t[1]-r[1],n}function i(n,t,r){return n[0]=t[0]*r[0],n[1]=t[1]*r[1],n}function f(n,t,r){return n[0]=t[0]/r[0],n[1]=t[1]/r[1],n}function s(n,t){var r=t[0]-n[0],a=t[1]-n[1];return Math.hypot(r,a)}function h(n,t){var r=t[0]-n[0],a=t[1]-n[1];return r*r+a*a}function M(n){var t=n[0],r=n[1];return Math.hypot(t,r)}function l(n){var t=n[0],r=n[1];return t*t+r*r}var v;r.create=o,r.clone=function(n){var t=new e.ARRAY_TYPE(2);return t[0]=n[0],t[1]=n[1],t},r.fromValues=function(n,t){var r=new e.ARRAY_TYPE(2);return r[0]=n,r[1]=t,r},r.copy=function(n,t){return n[0]=t[0],n[1]=t[1],n},r.set=function(n,t,r){return n[0]=t,n[1]=r,n},r.add=function(n,t,r){return n[0]=t[0]+r[0],n[1]=t[1]+r[1],n},r.subtract=c,r.multiply=i,r.divide=f,r.ceil=function(n,t){return n[0]=Math.ceil(t[0]),n[1]=Math.ceil(t[1]),n},r.floor=function(n,t){return n[0]=Math.floor(t[0]),n[1]=Math.floor(t[1]),n},r.min=function(n,t,r){return n[0]=Math.min(t[0],r[0]),n[1]=Math.min(t[1],r[1]),n},r.max=function(n,t,r){return n[0]=Math.max(t[0],r[0]),n[1]=Math.max(t[1],r[1]),n},r.round=function(n,t){return n[0]=Math.round(t[0]),n[1]=Math.round(t[1]),n},r.scale=function(n,t,r){return n[0]=t[0]*r,n[1]=t[1]*r,n},r.scaleAndAdd=function(n,t,r,a){return n[0]=t[0]+r[0]*a,n[1]=t[1]+r[1]*a,n},r.distance=s,r.squaredDistance=h,r.length=M,r.squaredLength=l,r.negate=function(n,t){return n[0]=-t[0],n[1]=-t[1],n},r.inverse=function(n,t){return n[0]=1/t[0],n[1]=1/t[1],n},r.normalize=function(n,t){var r=t[0],a=t[1],u=r*r+a*a;return u>0&&(u=1/Math.sqrt(u)),n[0]=t[0]*u,n[1]=t[1]*u,n},r.dot=function(n,t){return n[0]*t[0]+n[1]*t[1]},r.cross=function(n,t,r){var a=t[0]*r[1]-t[1]*r[0];return n[0]=n[1]=0,n[2]=a,n},r.lerp=function(n,t,r,a){var u=t[0],e=t[1];return n[0]=u+a*(r[0]-u),n[1]=e+a*(r[1]-e),n},r.random=function(n,t){t=t||1;var r=2*e.RANDOM()*Math.PI;return n[0]=Math.cos(r)*t,n[1]=Math.sin(r)*t,n},r.transformMat2=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u,n[1]=r[1]*a+r[3]*u,n},r.transformMat2d=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u+r[4],n[1]=r[1]*a+r[3]*u+r[5],n},r.transformMat3=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[3]*u+r[6],n[1]=r[1]*a+r[4]*u+r[7],n},r.transformMat4=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[4]*u+r[12],n[1]=r[1]*a+r[5]*u+r[13],n},r.rotate=function(n,t,r,a){var u=t[0]-r[0],e=t[1]-r[1],o=Math.sin(a),c=Math.cos(a);return n[0]=u*c-e*o+r[0],n[1]=u*o+e*c+r[1],n},r.angle=function(n,t){var r=n[0],a=n[1],u=t[0],e=t[1],o=Math.sqrt(r*r+a*a)*Math.sqrt(u*u+e*e),c=o&&(r*u+a*e)/o;return Math.acos(Math.min(Math.max(c,-1),1))},r.zero=function(n){return n[0]=0,n[1]=0,n},r.str=function(n){return"vec2("+n[0]+", "+n[1]+")"},r.exactEquals=function(n,t){return n[0]===t[0]&&n[1]===t[1]},r.equals=function(n,t){var r=n[0],a=n[1],u=t[0],o=t[1];return Math.abs(r-u)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(u))&&Math.abs(a-o)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(o))},r.len=M,r.sub=c,r.mul=i,r.div=f,r.dist=s,r.sqrDist=h,r.sqrLen=l,r.forEach=(v=o(),function(n,t,r,a,u,e){var o,c;for(t||(t=2),r||(r=0),c=a?Math.min(a*t+r,n.length):n.length,o=r;o<c;o+=t)v[0]=n[o],v[1]=n[o+1],u(v,v,e),n[o]=v[0],n[o+1]=v[1];return n})},
"7785475bdd": function _(e,t,i,s,n){s();const r=e("e13c143c7d"),o=e("993f3118b2");class a extends r.AbstractVTKView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.data.change,(()=>{this._vtk_image_data=(0,o.data2VTKImageData)(this.model.data),this.invalidate_render()})),this.connect(this.model.properties.colormap.change,(()=>{this.colormap_selector.value=this.model.colormap;const e=new Event("change");this.colormap_selector.dispatchEvent(e)})),this.connect(this.model.properties.shadow.change,(()=>{this.shadow_selector.value=this.model.shadow?"1":"0";const e=new Event("change");this.shadow_selector.dispatchEvent(e)})),this.connect(this.model.properties.sampling.change,(()=>{this.sampling_slider.value=this.model.sampling.toFixed(2);const e=new Event("input");this.sampling_slider.dispatchEvent(e)})),this.connect(this.model.properties.edge_gradient.change,(()=>{this.edge_gradient_slider.value=this.model.edge_gradient.toFixed(2);const e=new Event("input");this.edge_gradient_slider.dispatchEvent(e)})),this.connect(this.model.properties.rescale.change,(()=>{this._controllerWidget.setRescaleColorMap(this.model.rescale),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.ambient.change,(()=>{this.volume.getProperty().setAmbient(this.model.ambient),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.diffuse.change,(()=>{this.volume.getProperty().setDiffuse(this.model.diffuse),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.specular.change,(()=>{this.volume.getProperty().setSpecular(this.model.specular),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.specular_power.change,(()=>{this.volume.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.display_volume.change,(()=>{this._set_volume_visibility(this.model.display_volume),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.display_slices.change,(()=>{this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.slice_i.change,(()=>{void 0!==this.image_actor_i&&(this.image_actor_i.getMapper().setISlice(this.model.slice_i),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.slice_j.change,(()=>{void 0!==this.image_actor_j&&(this.image_actor_j.getMapper().setJSlice(this.model.slice_j),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.slice_k.change,(()=>{void 0!==this.image_actor_k&&(this.image_actor_k.getMapper().setKSlice(this.model.slice_k),this._vtk_renwin.getRenderWindow().render())})),this.connect(this.model.properties.render_background.change,(()=>{this._vtk_renwin.getRenderer().setBackground(...(0,o.hexToRGB)(this.model.render_background)),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.interpolation.change,(()=>{this._set_interpolation(this.model.interpolation),this._vtk_renwin.getRenderWindow().render()})),this.connect(this.model.properties.controller_expanded.change,(()=>{null!=this._controllerWidget&&this._controllerWidget.setExpanded(this.model.controller_expanded)})),this.connect(this.model.properties.nan_opacity.change,(()=>{const e=this.image_actor_i.getProperty().getScalarOpacity();e.get(["nodes"]).nodes[0].y=this.model.nan_opacity,e.modified(),this._vtk_renwin.getRenderWindow().render()}))}render(){this._vtk_renwin=null,this._orientationWidget=null,this._axes=null,super.render(),this._create_orientation_widget(),this._set_axes(),this.model.camera?this._set_camera_state():this._vtk_renwin.getRenderer().resetCamera(),this._get_camera_state()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=o.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this.el,container:this._vtk_container})}plot(){this._controllerWidget=o.vtkns.VolumeController.newInstance({size:[400,150],rescaleColorMap:this.model.rescale}),this._plot_volume(),this._plot_slices(),this._controllerWidget.setupContent(this._vtk_renwin.getRenderWindow(),this.volume,!0),this._controllerWidget.setContainer(this.el),this._controllerWidget.setExpanded(this.model.controller_expanded),this._connect_js_controls(),this._vtk_renwin.getRenderWindow().getInteractor(),this._vtk_renwin.getRenderWindow().getInteractor().setDesiredUpdateRate(45),this._set_volume_visibility(this.model.display_volume),this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderer().setBackground(...(0,o.hexToRGB)(this.model.render_background)),this._set_interpolation(this.model.interpolation),this._set_camera_state()}get vtk_image_data(){return this._vtk_image_data||(this._vtk_image_data=(0,o.data2VTKImageData)(this.model.data)),this._vtk_image_data}get volume(){return this._vtk_renwin.getRenderer().getVolumes()[0]}get image_actor_i(){return this._vtk_renwin.getRenderer().getActors()[0]}get image_actor_j(){return this._vtk_renwin.getRenderer().getActors()[1]}get image_actor_k(){return this._vtk_renwin.getRenderer().getActors()[2]}get shadow_selector(){return this.el.querySelector(".js-shadow")}get edge_gradient_slider(){return this.el.querySelector(".js-edge")}get sampling_slider(){return this.el.querySelector(".js-spacing")}get colormap_selector(){return this.el.querySelector(".js-color-preset")}_connect_js_controls(){const{el:e}=this._controllerWidget.get("el");if(void 0!==e){e.querySelector(".js-button").addEventListener("click",(()=>this.model.controller_expanded=this._controllerWidget.getExpanded()))}this.colormap_selector.addEventListener("change",(()=>{this.model.colormap=this.colormap_selector.value})),this.model.colormap?this.model.properties.colormap.change.emit():this.model.colormap=this.colormap_selector.value,this.shadow_selector.addEventListener("change",(()=>{this.model.shadow=!!Number(this.shadow_selector.value)})),(this.model.shadow=!!Number(this.shadow_selector.value))&&this.model.properties.shadow.change.emit(),this.sampling_slider.addEventListener("input",(()=>{const e=Number(this.sampling_slider.value);Math.abs(this.model.sampling-e)>=.005&&(this.model.sampling=e)})),Math.abs(this.model.sampling-Number(this.shadow_selector.value))>=.005&&this.model.properties.sampling.change.emit(),this.edge_gradient_slider.addEventListener("input",(()=>{const e=Number(this.edge_gradient_slider.value);Math.abs(this.model.edge_gradient-e)>=.005&&(this.model.edge_gradient=e)})),Math.abs(this.model.edge_gradient-Number(this.edge_gradient_slider.value))>=.005&&this.model.properties.edge_gradient.change.emit()}_plot_slices(){const e=this._vtk_image_data,t=o.vtkns.ImageSlice.newInstance(),i=o.vtkns.ImageSlice.newInstance(),s=o.vtkns.ImageSlice.newInstance(),n=o.vtkns.ImageMapper.newInstance(),r=o.vtkns.ImageMapper.newInstance(),a=o.vtkns.ImageMapper.newInstance();n.setInputData(e),n.setISlice(this.model.slice_i),t.setMapper(n),r.setInputData(e),r.setJSlice(this.model.slice_j),i.setMapper(r),a.setInputData(e),a.setKSlice(this.model.slice_k),s.setMapper(a);const l=o.vtkns.PiecewiseFunction.newInstance(),d=this.volume.getProperty().getRGBTransferFunction(0),c=this.volume.getMapper().getInputData().getPointData().getScalars().getRange();l.removeAllPoints(),l.addPoint(c[0]-1,this.model.nan_opacity),l.addPoint(c[0],1),l.addPoint(c[1],1);const _=t.getProperty();i.setProperty(_),s.setProperty(_),_.setRGBTransferFunction(d),_.setScalarOpacity(l);const h=this._vtk_renwin.getRenderer();h.addActor(t),h.addActor(i),h.addActor(s)}_plot_volume(){const e=this.vtk_image_data,t=o.vtkns.Volume.newInstance(),i=o.vtkns.VolumeMapper.newInstance();t.setMapper(i),i.setInputData(e);const s=(e.getPointData().getScalars()||e.getPointData().getArrays()[0]).getRange(),n=o.vtkns.ColorTransferFunction.newInstance();n.onModified((()=>this.model.mapper=(0,o.vtkLutToMapper)(n)));const r=o.vtkns.PiecewiseFunction.newInstance(),a=.7*Math.sqrt(e.getSpacing().map((e=>e*e)).reduce(((e,t)=>e+t),0));i.setSampleDistance(a),t.getProperty().setRGBTransferFunction(0,n),t.getProperty().setScalarOpacity(0,r),t.getProperty().setInterpolationTypeToFastLinear(),t.getProperty().setScalarOpacityUnitDistance(0,o.vtkns.BoundingBox.getDiagonalLength(e.getBounds())/Math.max(...e.getDimensions())),t.getProperty().setGradientOpacityMinimumValue(0,0),t.getProperty().setGradientOpacityMaximumValue(0,.05*(s[1]-s[0])),t.getProperty().setShade(this.model.shadow),t.getProperty().setUseGradientOpacity(0,!0),t.getProperty().setGradientOpacityMinimumOpacity(0,0),t.getProperty().setGradientOpacityMaximumOpacity(0,1),t.getProperty().setAmbient(this.model.ambient),t.getProperty().setDiffuse(this.model.diffuse),t.getProperty().setSpecular(this.model.specular),t.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderer().addVolume(t)}_set_interpolation(e){"fast_linear"==e?(this.volume.getProperty().setInterpolationTypeToFastLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):"linear"==e?(this.volume.getProperty().setInterpolationTypeToLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):(this.volume.getProperty().setInterpolationTypeToNearest(),this.image_actor_i.getProperty().setInterpolationTypeToNearest())}_set_slices_visibility(e){this.image_actor_i.setVisibility(e),this.image_actor_j.setVisibility(e),this.image_actor_k.setVisibility(e)}_set_volume_visibility(e){this.volume.setVisibility(e)}}i.VTKVolumePlotView=a,a.__name__="VTKVolumePlotView";class l extends r.AbstractVTKPlot{constructor(e){super(e)}static init_VTKVolumePlot(){this.prototype.default_view=a,this.define((({Any:e,Array:t,Boolean:i,Int:s,Number:n,String:r,Struct:a})=>({ambient:[n,.2],colormap:[r],data:[e],diffuse:[n,.7],display_slices:[i,!1],display_volume:[i,!0],edge_gradient:[n,.2],interpolation:[o.Interpolation,"fast_linear"],mapper:[a({palette:t(r),low:n,high:n})],nan_opacity:[n,1],render_background:[r,"#52576e"],rescale:[i,!1],sampling:[n,.4],shadow:[i,!0],slice_i:[s,0],slice_j:[s,0],slice_k:[s,0],specular:[n,.3],specular_power:[n,8],controller_expanded:[i,!0]})))}}i.VTKVolumePlot=l,l.__name__="VTKVolumePlot",l.init_VTKVolumePlot()},
"0a57062475": function _(e,t,n,s,i){s();const r=e("@bokehjs/core/util/object"),o=e("e13c143c7d"),_=e("877619fe71"),a=e("993f3118b2"),c="panel";class h extends o.AbstractVTKView{initialize(){super.initialize(),this._promises=[],this._renderable=!1,this._arrays={},this._decoded_arrays={},this._pending_arrays={},this.registerArray=(e,t)=>(this._arrays[e]=t,this._pending_arrays[e]&&this._pending_arrays[e].resolve(t),!0),this._synchronizer_context=a.vtkns.SynchronizableRenderWindow.getSynchronizerContext(c)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.arrays.change,(()=>this._decode_arrays())),this.connect(this.model.properties.scene.change,(()=>{if(this.model.rebuild)this._vtk_renwin=null,this.invalidate_render();else{const e=(0,r.clone)(this.model.scene);Promise.all(this._promises).then((()=>{this._sync_plot(e,(()=>{this._on_scene_ready()}))}))}})),this.connect(this.model.properties.one_time_reset.change,(()=>{this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters()}))}init_vtk_renwin(){this._vtk_renwin=a.vtkns.FullScreenRenderWindowSynchronized.newInstance({rootContainer:this.el,container:this._vtk_container,synchronizerContext:this._synchronizer_context})}plot(){this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters(),this._decode_arrays();const e=(0,r.clone)(this.model.scene);Promise.all(this._promises).then((()=>{this._sync_plot(e,(()=>this._on_scene_ready())).then((()=>{this._set_camera_state(),this._get_camera_state()}))}))}_decode_arrays(){const e=new a.vtkns.ThirdParty.JSZip,t=this.model.arrays,n=this.registerArray,s=this.model.arrays_processed,i=this.model;Object.keys(t).forEach((r=>{this._decoded_arrays[r]||(this._decoded_arrays[r]=!0,this._promises.push(function(r){return e.loadAsync(atob(t[r])).then((e=>e.file("data/"+r))).then((e=>e.async("arraybuffer"))).then((e=>n(r,e))).then((()=>{s.push(r),i.properties.arrays_processed.change.emit()}))}(r)))}))}_on_scene_ready(){this._promises.length>0||(this._renderable=!0,this._camera_callbacks.push(this._vtk_renwin.getRenderer().getActiveCamera().onModified((()=>this._vtk_render()))),this._orientationWidget||this._create_orientation_widget(),this._axes||this._set_axes(),this._vtk_renwin.resize(),this._vtk_render())}_sync_plot(e,t){this._renderable=!1,this._promises=[],this._unsubscribe_camera_cb(),this._synchronizer_context.setFetchArrayFunction((e=>Promise.resolve(this._arrays[e])));const n=this._synchronizer_context.getInstance(this.model.scene.dependencies[0].id);return n&&!this._vtk_renwin.getRenderer()&&this._vtk_renwin.getRenderWindow().addRenderer(n),this._vtk_renwin.getRenderWindow().synchronize(e).then(t)}}n.VTKSynchronizedPlotView=h,h.__name__="VTKSynchronizedPlotView";class d extends o.AbstractVTKPlot{constructor(e){super(e),(0,_.initialize_fullscreen_render)(),this.outline=a.vtkns.OutlineFilter.newInstance();const t=a.vtkns.Mapper.newInstance();t.setInputConnection(this.outline.getOutputPort()),this.outline_actor=a.vtkns.Actor.newInstance(),this.outline_actor.setMapper(t)}getActors(e){let t=this.renderer_el.getRenderer().getActors();if(e){const n=this.renderer_el.getSynchronizerContext(c);t=t.filter((t=>{const s=n.getInstanceId(t);return!!s&&s.slice(-16)==e.slice(1,17)}))}return t}static init_VTKSynchronizedPlot(){this.prototype.default_view=h,this.define((({Any:e,Array:t,Boolean:n,String:s})=>({arrays:[e,{}],arrays_processed:[t(s),[]],enable_keybindings:[n,!1],one_time_reset:[n],rebuild:[n,!1],scene:[e,{}]}))),this.override({height:300,width:300})}}n.VTKSynchronizedPlot=d,d.__name__="VTKSynchronizedPlot",d.__module__="panel.models.vtk",d.init_VTKSynchronizedPlot()},
"877619fe71": function _(e,n,o,t,r){t();const i=e("993f3118b2"),l={containerStyle:null,controlPanelStyle:null,listenWindowResize:!0,resizeCallback:null,controllerVisibility:!0,synchronizerContextName:"default"},a={position:"absolute",left:"25px",top:"25px",backgroundColor:"white",borderRadius:"5px",listStyle:"none",padding:"5px 10px",margin:"0",display:"block",border:"solid 1px black",maxWidth:"calc(100vw - 70px)",maxHeight:"calc(100vh - 60px)",overflow:"auto"};o.initialize_fullscreen_render=function(){let e={newInstance:window.vtk.macro.newInstance(((e,n,o={})=>{Object.assign(n,l,o),window.vtk.macro.obj(e,n),window.vtk.macro.get(e,n,["renderWindow","openGLRenderWindow","interactor","rootContainer","container","controlContainer","synchronizerContext"]),function(e,n){n.renderWindow=i.vtkns.SynchronizableRenderWindow.newInstance({synchronizerContext:n.synchronizerContext}),n.openGLRenderWindow=i.vtkns.OpenGLRenderWindow.newInstance(),n.openGLRenderWindow.setContainer(n.container),n.renderWindow.addView(n.openGLRenderWindow),n.interactor=i.vtkns.RenderWindowInteractor.newInstance(),n.interactor.setInteractorStyle(i.vtkns.InteractorStyleTrackballCamera.newInstance()),n.interactor.setView(n.openGLRenderWindow),n.interactor.initialize(),n.interactor.bindEvents(n.container),e.getRenderer=()=>n.renderWindow.getRenderers()[0],e.removeController=()=>{const e=n.controlContainer;e&&e.parentNode.removeChild(e)},e.setControllerVisibility=e=>{n.controllerVisibility=e,n.controlContainer&&(n.controlContainer.style.display=e?"block":"none")},e.toggleControllerVisibility=()=>{e.setControllerVisibility(!n.controllerVisibility)},e.addController=o=>{n.controlContainer=document.createElement("div"),(0,i.applyStyle)(n.controlContainer,n.controlPanelStyle||a),n.rootContainer.appendChild(n.controlContainer),n.controlContainer.innerHTML=o,e.setControllerVisibility(n.controllerVisibility),n.rootContainer.addEventListener("keypress",(n=>{"c"===String.fromCharCode(n.charCode)&&e.toggleControllerVisibility()}))},e.delete=window.vtk.macro.chain(e.setContainer,n.openGLRenderWindow.delete,e.delete),e.resize=()=>{const e=n.container.getBoundingClientRect(),o=window.devicePixelRatio||1;n.openGLRenderWindow.setSize(Math.floor(e.width*o),Math.floor(e.height*o)),n.resizeCallback&&n.resizeCallback(e),n.renderWindow.render()},e.setResizeCallback=o=>{n.resizeCallback=o,e.resize()},n.listenWindowResize&&window.addEventListener("resize",e.resize),e.resize()}(e,n)}))};i.vtkns.FullScreenRenderWindowSynchronized=e}},
}, "4e90918c0a", {"index":"4e90918c0a","models/index":"eed113197d","models/ace":"2e12ebdb23","models/layout":"80a6464b1f","models/audio":"33955cfa6f","models/card":"0972f6e77b","models/comm_manager":"754fbb1f55","models/customselect":"e258e515be","models/tabulator":"6ab332f75c","models/data":"7f7d9e0c6b","models/datetime_picker":"297274885a","models/deckgl":"0155f7af4d","models/tooltips":"6e04fbe567","models/echarts":"9d046c4720","models/html":"3d7593ca5a","models/event-to-object":"d92f7d4d2b","models/idom":"7d45bd3bc4","models/ipywidget":"0eae77d68f","models/json":"0d30bea0c8","models/json_editor":"be9f51fc39","models/file_download":"1767172ffa","models/katex":"7b859fb3cf","models/location":"0c52a301f3","models/mathjax":"0c21036737","models/perspective":"4ae96bd77b","models/player":"588a5ae70d","models/plotly":"42de27e56c","models/util":"990b5dd5c7","models/progress":"979633320f","models/quill":"d51a79a0a3","models/reactive_html":"ad426de39c","models/singleselect":"ab54efe08a","models/speech_to_text":"a96be0bcc9","models/state":"bfa46a5f19","models/tabs":"f693d9aa84","models/terminal":"3ea011fa55","models/text_to_speech":"33cd2c254e","models/trend":"effe070807","models/vega":"fea356270f","models/video":"1b46fd56a8","models/videostream":"e3e9b8e495","models/vtk/index":"c51f25e2a7","models/vtk/vtkjs":"b6d9199d03","models/vtk/vtklayout":"e13c143c7d","models/vtk/util":"993f3118b2","models/vtk/vtkcolorbar":"c010237f8b","models/vtk/vtkaxes":"ab478186ba","models/vtk/vtkvolume":"7785475bdd","models/vtk/vtksynchronized":"0a57062475","models/vtk/panel_fullscreen_renwin_sync":"877619fe71"}, {});});
