import json
from pathlib import Path

import pytest
from pymultirole_plugins.v1.schema import Document, DocumentList

from pyprocessors_deepl.deepl import DeepLProcessor, DeepLParameters, TargetLang


def test_deepl_basic():
    model = DeepLProcessor.get_model()
    model_class = model.construct().__class__
    assert model_class == DeepLParameters


@pytest.mark.skip(reason="Not a test")
def test_deepl():
    testdir = Path(__file__).parent
    source = Path(
        testdir,
        "data/from.json",
    )

    with source.open("r") as fin:
        jdocs = json.load(fin)
        docs = [Document(**jdoc) for jdoc in jdocs]

        parameters = DeepLParameters(target_lang=TargetLang.FR)
        processor = DeepLProcessor()
        docs = processor.process(docs, parameters)
        target = Path(
            testdir,
            "data/to.json",
        )
        with target.open("w") as fout:
            dl = DocumentList(__root__=docs)
            print(dl.json(exclude_none=True, exclude_unset=True, indent=2), file=fout)

        parameters.as_altText = "translation"
        parameters.target_lang = TargetLang.EN_US
        docs = processor.process(docs, parameters)
        target = Path(
            testdir,
            "data/toalts.json",
        )
        with target.open("w") as fout:
            dl = DocumentList(__root__=docs)
            print(dl.json(exclude_none=True, exclude_unset=True, indent=2), file=fout)
