# AUTOGENERATED! DO NOT EDIT! File to edit: image.ipynb (unless otherwise specified).

__all__ = ['Img', 'FileImg', 'File16bitImg', 'ArrayImg']

# Cell
import warnings

import numpy as np
import torch
from PIL import Image

from .utils import *

# Cell
class Img:
    def exists(self):               raise NotImplementedError('Please implement exists()')

    @property
    def name(self):                 raise NotImplementedError('Please implement name')
    @property
    def size(self):                 raise NotImplementedError('Please implement size')

    def array(self, dtype, device): raise NotImplementedError('Please implement array')
    def array_gs(self, dtype, device=None): # gs == "gray scale"
        arr = self.array(dtype, device)
        sz = arr.shape
        if len(sz) == 3 and sz[2] == 3: arr = rgb2gray(arr)
        elif len(sz) == 2:              pass
        else:                           raise RuntimeError(f'Invalid shape: {arr.shape}')
        return arr

    def __repr__(self): return f'{self.__class__.__name__}({self.name})'

# Cell
class FileImg(Img):
    def __init__(self, file_img):
        self.file_img = file_img

    def exists(self): return self.file_img.exists()

    @property
    def name(self):   return self.file_img.stem
    @property
    def size(self):   return reverse(Image.open(self.file_img).size) # fast

# Cell
class File16bitImg(FileImg):
    def __init__(self, file_img):
        super().__init__(file_img)

    def array(self, dtype, device=None):
        arr = np2torch(np.array(Image.open(self.file_img))).to(dtype=dtype, device=device)
        arr /= 2**16-1 # Scale between 0 and 1 for 16 bit image
        return arr

# Cell
class ArrayImg(Img):
    def __init__(self, arr, name=None):
        if len(arr.shape) < 2: raise RuntimeError('Input array has less than 2 dimensions')
        self.sz = arr.shape[:2]
        self.n = name

        if arr.min() < 0: warnings.warn('Value less than 0 found')
        if arr.max() > 1: warnings.warn('Value greater than 1 found')
        self.arr = arr

    @property
    def name(self):                      return self.n
    @property
    def size(self):                      return self.sz
    def array(self, dtype, device=None): return self.arr.to(dtype=dtype, device=device)
    def exists(self):                    return True