# AUTOGENERATED! DO NOT EDIT! File to edit: cb_geom.ipynb (unless otherwise specified).

__all__ = ['PGeom', 'BGeom', 'CpGeom', 'CpCSRGrid', 'CpCSDGrid', 'FmGeom', 'FmCFPGrid', 'CbGeom']

# Cell
import matplotlib.pyplot as plt
import numpy as np
import torch

from .utils import *

# Cell
class PGeom():
    def ps(self, dtype, device): return NotImplementedError('Please implement ps')

# Cell
class BGeom():
    def bs(self, dtype, device): return NotImplementedError('Please implement bs')

# Cell
class CpGeom(PGeom, BGeom): pass

# Cell
class CpCSRGrid(CpGeom):
    def __init__(self, num_h, num_w, spacing):
        self.num_h, self.num_w, self.spacing = num_h, num_w, spacing

    def ps(self, dtype, device=None):
        return csrgrid(self.num_h, self.num_w, self.spacing, dtype=dtype, device=device)

    def bs(self, dtype, device=None):
        b = cfpgrid(self.spacing, self.spacing, dtype=dtype, device=device)[[0,1,3,2]]
        return np.array([b+p for p in self.ps(dtype, device)], np.object)

# Cell
class CpCSDGrid(CpGeom):
    def __init__(self, num_h, num_w, spacing, fo):
        self.num_h, self.num_w, self.spacing, self.fo = num_h, num_w, spacing, fo

    def ps(self, dtype, device=None):
        return csdgrid(self.num_h, self.num_w, self.spacing, self.fo, dtype=dtype, device=device)

    def bs(self, dtype, device=None):
        b = csdgrid(3, 3, self.spacing, False, dtype=dtype, device=device)[[0,1,3,2]]
        return np.array([b+p for p in self.ps(dtype, device)], np.object)

# Cell
class FmGeom(PGeom): pass

# Cell
class FmCFPGrid(FmGeom):
    def __init__(self, h, w):
        self.h, self.w = h, w

    def ps(self, dtype, device=None): return cfpgrid(self.h, self.w, dtype=dtype, device=device)

# Cell
class CbGeom():
    def __init__(self,
                 h_cb,
                 w_cb,
                 cp_geom,
                 fm_geom=None,
                 idx_c_exclude=torch.LongTensor(),
                 idx_f_exclude=torch.LongTensor()):
        self.h_cb, self.w_cb = h_cb, w_cb
        self.cp_geom = cp_geom
        self.fm_geom = fm_geom
        self.idx_c_exclude = idx_c_exclude
        self.idx_f_exclude = idx_f_exclude

    def ps_c(self, dtype, device=None): return delete(self.cp_geom.ps(dtype, device), self.idx_c_exclude)
    def bs_c(self, dtype, device=None): return delete(self.cp_geom.bs(dtype, device), self.idx_c_exclude)
    def ps_f(self, dtype, device=None): return delete(self.fm_geom.ps(dtype, device), self.idx_f_exclude)

    def plot(self, ax=None):
        if ax is None:
            plt.figure(figsize=(10,10))
            ax = plt.gca()

        def _plot_ps(ps, style):
            ax.plot(ps[:,0], ps[:,1], style)
            for idx, p in enumerate(ps): ax.text(p[0], p[1], str(idx))

        # Control points
        _plot_ps(self.ps_c(torch.float), 'gs')
        for b_c in self.bs_c(torch.float):
            ax.plot(torch.cat([b_c[:,0], b_c[0:1,0]]),
                    torch.cat([b_c[:,1], b_c[0:1,1]]), 'r')

        # Fiducial markers
        if self.fm_geom is not None: _plot_ps(self.ps_f(torch.float), 'bs')

        ax.set_xlim(-self.w_cb/2, self.w_cb/2)
        ax.set_ylim(-self.h_cb/2, self.h_cb/2)
        ax.invert_yaxis()
        ax.set_aspect(1)