# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, BinaryIO, Any


class AbolishDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class AbolishDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AbolishDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AbolishDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AbolishDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddProjectMemberToRoleRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
        role_code: str = None,
        client_token: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id
        self.role_code = role_code
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class AddProjectMemberToRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddProjectMemberToRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddProjectMemberToRoleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddProjectMemberToRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddToMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class AddToMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddToMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddToMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddToMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApprovePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
        approve_comment: str = None,
        approve_action: int = None,
    ):
        self.flow_id = flow_id
        self.approve_comment = approve_comment
        self.approve_action = approve_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.approve_comment is not None:
            result['ApproveComment'] = self.approve_comment
        if self.approve_action is not None:
            result['ApproveAction'] = self.approve_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('ApproveComment') is not None:
            self.approve_comment = m.get('ApproveComment')
        if m.get('ApproveAction') is not None:
            self.approve_action = m.get('ApproveAction')
        return self


class ApprovePermissionApplyOrderResponseBody(TeaModel):
    def __init__(
        self,
        approve_success: bool = None,
        request_id: str = None,
    ):
        self.approve_success = approve_success
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.approve_success is not None:
            result['ApproveSuccess'] = self.approve_success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApproveSuccess') is not None:
            self.approve_success = m.get('ApproveSuccess')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApprovePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ApprovePermissionApplyOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ApprovePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckEngineMetaPartitionRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        partition: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.partition = partition
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckEngineMetaPartitionResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckEngineMetaPartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckEngineMetaPartitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckEngineMetaPartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckEngineMetaTableRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckEngineMetaTableResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckEngineMetaTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckEngineMetaTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckEngineMetaTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckFileDeploymentRequest(TeaModel):
    def __init__(
        self,
        checker_instance_id: str = None,
        status: str = None,
        check_detail_url: str = None,
    ):
        self.checker_instance_id = checker_instance_id
        self.status = status
        self.check_detail_url = check_detail_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.checker_instance_id is not None:
            result['CheckerInstanceId'] = self.checker_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.check_detail_url is not None:
            result['CheckDetailUrl'] = self.check_detail_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckerInstanceId') is not None:
            self.checker_instance_id = m.get('CheckerInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CheckDetailUrl') is not None:
            self.check_detail_url = m.get('CheckDetailUrl')
        return self


class CheckFileDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckFileDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckFileDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckFileDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaPartitionRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        partition: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.partition = partition
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition is not None:
            result['Partition'] = self.partition
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Partition') is not None:
            self.partition = m.get('Partition')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckMetaPartitionResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckMetaPartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckMetaPartitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaPartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaTableRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class CheckMetaTableResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckMetaTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckMetaTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckMetaTableTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckMetaTableTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckMetaTableTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckMetaTableTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        business_name: str = None,
        description: str = None,
        owner: str = None,
        use_type: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.business_name = business_name
        self.description = description
        self.owner = owner
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.description is not None:
            result['Description'] = self.description
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class CreateBusinessResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        business_id: int = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.business_id = business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class CreateBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConnectionRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        description: str = None,
        connection_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        content: str = None,
    ):
        self.project_id = project_id
        self.name = name
        self.description = description
        self.connection_type = connection_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateConnectionResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: str = None,
        data: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagComplementRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        start_biz_date: str = None,
        name: str = None,
        root_node_id: int = None,
        include_node_ids: str = None,
        exclude_node_ids: str = None,
        biz_begin_time: str = None,
        biz_end_time: str = None,
        parallelism: bool = None,
        end_biz_date: str = None,
        node_params: str = None,
    ):
        self.project_env = project_env
        self.start_biz_date = start_biz_date
        self.name = name
        self.root_node_id = root_node_id
        self.include_node_ids = include_node_ids
        self.exclude_node_ids = exclude_node_ids
        self.biz_begin_time = biz_begin_time
        self.biz_end_time = biz_end_time
        self.parallelism = parallelism
        self.end_biz_date = end_biz_date
        self.node_params = node_params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.start_biz_date is not None:
            result['StartBizDate'] = self.start_biz_date
        if self.name is not None:
            result['Name'] = self.name
        if self.root_node_id is not None:
            result['RootNodeId'] = self.root_node_id
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        if self.biz_begin_time is not None:
            result['BizBeginTime'] = self.biz_begin_time
        if self.biz_end_time is not None:
            result['BizEndTime'] = self.biz_end_time
        if self.parallelism is not None:
            result['Parallelism'] = self.parallelism
        if self.end_biz_date is not None:
            result['EndBizDate'] = self.end_biz_date
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('StartBizDate') is not None:
            self.start_biz_date = m.get('StartBizDate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RootNodeId') is not None:
            self.root_node_id = m.get('RootNodeId')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        if m.get('BizBeginTime') is not None:
            self.biz_begin_time = m.get('BizBeginTime')
        if m.get('BizEndTime') is not None:
            self.biz_end_time = m.get('BizEndTime')
        if m.get('Parallelism') is not None:
            self.parallelism = m.get('Parallelism')
        if m.get('EndBizDate') is not None:
            self.end_biz_date = m.get('EndBizDate')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class CreateDagComplementResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: List[int] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateDagComplementResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDagComplementResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDagComplementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDagTestRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        bizdate: str = None,
        name: str = None,
        node_id: int = None,
        node_params: str = None,
    ):
        self.project_env = project_env
        self.bizdate = bizdate
        self.name = name
        self.node_id = node_id
        self.node_params = node_params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.node_params is not None:
            result['NodeParams'] = self.node_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('NodeParams') is not None:
            self.node_params = m.get('NodeParams')
        return self


class CreateDagTestResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDagTestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDagTestResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDagTestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_name: str = None,
        group_id: str = None,
        api_mode: int = None,
        request_method: int = None,
        response_content_type: int = None,
        timeout: int = None,
        visible_range: int = None,
        protocols: str = None,
        wizard_details: str = None,
        script_details: str = None,
        registration_details: str = None,
        api_path: str = None,
        api_description: str = None,
        folder_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_name = api_name
        self.group_id = group_id
        self.api_mode = api_mode
        self.request_method = request_method
        self.response_content_type = response_content_type
        self.timeout = timeout
        self.visible_range = visible_range
        self.protocols = protocols
        self.wizard_details = wizard_details
        self.script_details = script_details
        self.registration_details = registration_details
        self.api_path = api_path
        self.api_description = api_description
        self.folder_id = folder_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.api_description is not None:
            result['ApiDescription'] = self.api_description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('WizardDetails') is not None:
            self.wizard_details = m.get('WizardDetails')
        if m.get('ScriptDetails') is not None:
            self.script_details = m.get('ScriptDetails')
        if m.get('RegistrationDetails') is not None:
            self.registration_details = m.get('RegistrationDetails')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('ApiDescription') is not None:
            self.api_description = m.get('ApiDescription')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class CreateDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
        authorized_project_id: int = None,
        end_time: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id
        self.end_time = end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class CreateDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceApiAuthorityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        folder_name: str = None,
        parent_id: int = None,
        group_id: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.folder_name = folder_name
        self.parent_id = parent_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateDataServiceFolderResponseBody(TeaModel):
    def __init__(
        self,
        folder_id: int = None,
        request_id: str = None,
    ):
        self.folder_id = folder_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_gateway_group_id: str = None,
        group_name: str = None,
        description: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_gateway_group_id = api_gateway_group_id
        self.group_name = group_name
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateDataServiceGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        request_id: str = None,
    ):
        self.group_id = group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataServiceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataSourceRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        description: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        content: str = None,
    ):
        self.project_id = project_id
        self.name = name
        self.description = description
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: str = None,
        data: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_content: str = None,
        task_param: str = None,
        task_name: str = None,
        client_token: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_content = task_content
        self.task_param = task_param
        self.task_name = task_name
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_content is not None:
            result['TaskContent'] = self.task_content
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskContent') is not None:
            self.task_content = m.get('TaskContent')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
        file_id: int = None,
    ):
        self.status = status
        self.message = message
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class CreateDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: CreateDISyncTaskResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileRequest(TeaModel):
    def __init__(
        self,
        file_folder_path: str = None,
        project_id: int = None,
        file_name: str = None,
        file_description: str = None,
        file_type: int = None,
        owner: str = None,
        content: str = None,
        auto_rerun_times: int = None,
        auto_rerun_interval_millis: int = None,
        rerun_mode: str = None,
        stop: bool = None,
        para_value: str = None,
        start_effect_date: int = None,
        end_effect_date: int = None,
        cron_express: str = None,
        cycle_type: str = None,
        dependent_type: str = None,
        dependent_node_id_list: str = None,
        input_list: str = None,
        project_identifier: str = None,
        resource_group_identifier: str = None,
        resource_group_id: int = None,
        connection_name: str = None,
        auto_parsing: bool = None,
        scheduler_type: str = None,
    ):
        self.file_folder_path = file_folder_path
        self.project_id = project_id
        self.file_name = file_name
        self.file_description = file_description
        self.file_type = file_type
        self.owner = owner
        self.content = content
        self.auto_rerun_times = auto_rerun_times
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        self.rerun_mode = rerun_mode
        self.stop = stop
        self.para_value = para_value
        self.start_effect_date = start_effect_date
        self.end_effect_date = end_effect_date
        self.cron_express = cron_express
        self.cycle_type = cycle_type
        self.dependent_type = dependent_type
        self.dependent_node_id_list = dependent_node_id_list
        self.input_list = input_list
        self.project_identifier = project_identifier
        self.resource_group_identifier = resource_group_identifier
        self.resource_group_id = resource_group_id
        self.connection_name = connection_name
        self.auto_parsing = auto_parsing
        self.scheduler_type = scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.content is not None:
            result['Content'] = self.content
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.stop is not None:
            result['Stop'] = self.stop
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.resource_group_identifier is not None:
            result['ResourceGroupIdentifier'] = self.resource_group_identifier
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ResourceGroupIdentifier') is not None:
            self.resource_group_identifier = m.get('ResourceGroupIdentifier')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        return self


class CreateFileResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFolderRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        folder_path: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.folder_path = folder_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class CreateFolderResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: str = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImportMigrationRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        package_type: str = None,
        package_file: str = None,
        resource_group_map: str = None,
        workspace_map: str = None,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
    ):
        self.project_id = project_id
        self.name = name
        self.package_type = package_type
        self.package_file = package_file
        self.resource_group_map = resource_group_map
        self.workspace_map = workspace_map
        self.calculate_engine_map = calculate_engine_map
        self.commit_rule = commit_rule
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_file is not None:
            result['PackageFile'] = self.package_file
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageFile') is not None:
            self.package_file = m.get('PackageFile')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateImportMigrationAdvanceRequest(TeaModel):
    def __init__(
        self,
        package_file_object: BinaryIO = None,
        project_id: int = None,
        name: str = None,
        package_type: str = None,
        resource_group_map: str = None,
        workspace_map: str = None,
        calculate_engine_map: str = None,
        commit_rule: str = None,
        description: str = None,
    ):
        self.package_file_object = package_file_object
        self.project_id = project_id
        self.name = name
        self.package_type = package_type
        self.resource_group_map = resource_group_map
        self.workspace_map = workspace_map
        self.calculate_engine_map = calculate_engine_map
        self.commit_rule = commit_rule
        self.description = description

    def validate(self):
        self.validate_required(self.package_file_object, 'package_file_object')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_file_object is not None:
            result['PackageFileObject'] = self.package_file_object
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.resource_group_map is not None:
            result['ResourceGroupMap'] = self.resource_group_map
        if self.workspace_map is not None:
            result['WorkspaceMap'] = self.workspace_map
        if self.calculate_engine_map is not None:
            result['CalculateEngineMap'] = self.calculate_engine_map
        if self.commit_rule is not None:
            result['CommitRule'] = self.commit_rule
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageFileObject') is not None:
            self.package_file_object = m.get('PackageFileObject')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('ResourceGroupMap') is not None:
            self.resource_group_map = m.get('ResourceGroupMap')
        if m.get('WorkspaceMap') is not None:
            self.workspace_map = m.get('WorkspaceMap')
        if m.get('CalculateEngineMap') is not None:
            self.calculate_engine_map = m.get('CalculateEngineMap')
        if m.get('CommitRule') is not None:
            self.commit_rule = m.get('CommitRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateImportMigrationResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateImportMigrationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateImportMigrationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateImportMigrationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateManualDagRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_name: str = None,
        flow_name: str = None,
        biz_date: str = None,
        node_parameters: str = None,
        dag_parameters: str = None,
        include_node_ids: str = None,
        exclude_node_ids: str = None,
    ):
        self.project_env = project_env
        self.project_name = project_name
        self.flow_name = flow_name
        self.biz_date = biz_date
        self.node_parameters = node_parameters
        self.dag_parameters = dag_parameters
        self.include_node_ids = include_node_ids
        self.exclude_node_ids = exclude_node_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.node_parameters is not None:
            result['NodeParameters'] = self.node_parameters
        if self.dag_parameters is not None:
            result['DagParameters'] = self.dag_parameters
        if self.include_node_ids is not None:
            result['IncludeNodeIds'] = self.include_node_ids
        if self.exclude_node_ids is not None:
            result['ExcludeNodeIds'] = self.exclude_node_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('NodeParameters') is not None:
            self.node_parameters = m.get('NodeParameters')
        if m.get('DagParameters') is not None:
            self.dag_parameters = m.get('DagParameters')
        if m.get('IncludeNodeIds') is not None:
            self.include_node_ids = m.get('IncludeNodeIds')
        if m.get('ExcludeNodeIds') is not None:
            self.exclude_node_ids = m.get('ExcludeNodeIds')
        return self


class CreateManualDagResponseBody(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        request_id: str = None,
    ):
        self.dag_id = dag_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateManualDagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateManualDagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateManualDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        comment: str = None,
        parent_id: int = None,
    ):
        self.name = name
        self.comment = comment
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateMetaCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class CreateMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: CreateMetaCategoryResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = CreateMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePermissionApplyOrderRequestApplyObjectColumnMetaList(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequestApplyObject(TeaModel):
    def __init__(
        self,
        actions: str = None,
        column_meta_list: List[CreatePermissionApplyOrderRequestApplyObjectColumnMetaList] = None,
        name: str = None,
    ):
        self.actions = actions
        self.column_meta_list = column_meta_list
        self.name = name

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actions is not None:
            result['Actions'] = self.actions
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Actions') is not None:
            self.actions = m.get('Actions')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = CreatePermissionApplyOrderRequestApplyObjectColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePermissionApplyOrderRequest(TeaModel):
    def __init__(
        self,
        apply_user_ids: str = None,
        deadline: int = None,
        apply_reason: str = None,
        max_compute_project_name: str = None,
        workspace_id: int = None,
        order_type: int = None,
        engine_type: str = None,
        apply_object: List[CreatePermissionApplyOrderRequestApplyObject] = None,
    ):
        self.apply_user_ids = apply_user_ids
        self.deadline = deadline
        self.apply_reason = apply_reason
        self.max_compute_project_name = max_compute_project_name
        self.workspace_id = workspace_id
        self.order_type = order_type
        self.engine_type = engine_type
        self.apply_object = apply_object

    def validate(self):
        if self.apply_object:
            for k in self.apply_object:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_user_ids is not None:
            result['ApplyUserIds'] = self.apply_user_ids
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.engine_type is not None:
            result['EngineType'] = self.engine_type
        result['ApplyObject'] = []
        if self.apply_object is not None:
            for k in self.apply_object:
                result['ApplyObject'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyUserIds') is not None:
            self.apply_user_ids = m.get('ApplyUserIds')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('EngineType') is not None:
            self.engine_type = m.get('EngineType')
        self.apply_object = []
        if m.get('ApplyObject') is not None:
            for k in m.get('ApplyObject'):
                temp_model = CreatePermissionApplyOrderRequestApplyObject()
                self.apply_object.append(temp_model.from_map(k))
        return self


class CreatePermissionApplyOrderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        flow_id: List[str] = None,
    ):
        self.request_id = request_id
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class CreatePermissionApplyOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreatePermissionApplyOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreatePermissionApplyOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProjectMemberRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
        client_token: str = None,
        role_code: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id
        self.client_token = client_token
        self.role_code = role_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.role_code is not None:
            result['RoleCode'] = self.role_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('RoleCode') is not None:
            self.role_code = m.get('RoleCode')
        return self


class CreateProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityEntityRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        table_name: str = None,
        env_type: str = None,
        match_expression: str = None,
        entity_level: int = None,
    ):
        self.project_name = project_name
        self.table_name = table_name
        self.env_type = env_type
        self.match_expression = match_expression
        self.entity_level = entity_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        return self


class CreateQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        follower: str = None,
        alarm_mode: int = None,
        entity_id: int = None,
    ):
        self.project_name = project_name
        self.follower = follower
        self.alarm_mode = alarm_mode
        self.entity_id = entity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.follower is not None:
            result['Follower'] = self.follower
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class CreateQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRelativeNodeRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        node_id: int = None,
        project_id: int = None,
        target_node_project_name: str = None,
        project_name: str = None,
        table_name: str = None,
        target_node_project_id: int = None,
    ):
        self.env_type = env_type
        self.match_expression = match_expression
        self.node_id = node_id
        self.project_id = project_id
        self.target_node_project_name = target_node_project_name
        self.project_name = project_name
        self.table_name = table_name
        self.target_node_project_id = target_node_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        return self


class CreateQualityRelativeNodeResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateQualityRelativeNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityRelativeNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRuleRequest(TeaModel):
    def __init__(
        self,
        block_type: int = None,
        entity_id: int = None,
        comment: str = None,
        checker: int = None,
        expect_value: str = None,
        trend: str = None,
        method_name: str = None,
        operator: str = None,
        project_name: str = None,
        property: str = None,
        property_type: str = None,
        rule_type: int = None,
        where_condition: str = None,
        critical_threshold: str = None,
        warning_threshold: str = None,
        template_id: int = None,
        rule_name: str = None,
        predict_type: int = None,
    ):
        self.block_type = block_type
        self.entity_id = entity_id
        self.comment = comment
        self.checker = checker
        self.expect_value = expect_value
        self.trend = trend
        self.method_name = method_name
        self.operator = operator
        self.project_name = project_name
        self.property = property
        self.property_type = property_type
        self.rule_type = rule_type
        self.where_condition = where_condition
        self.critical_threshold = critical_threshold
        self.warning_threshold = warning_threshold
        self.template_id = template_id
        self.rule_name = rule_name
        self.predict_type = predict_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.property is not None:
            result['Property'] = self.property
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        return self


class CreateQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: str = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRemindRequest(TeaModel):
    def __init__(
        self,
        remind_name: str = None,
        dnd_end: str = None,
        remind_unit: str = None,
        node_ids: str = None,
        baseline_ids: str = None,
        project_id: int = None,
        biz_process_ids: str = None,
        remind_type: str = None,
        max_alert_times: int = None,
        alert_interval: int = None,
        detail: str = None,
        alert_unit: str = None,
        alert_methods: str = None,
        alert_targets: str = None,
        robot_urls: str = None,
    ):
        self.remind_name = remind_name
        self.dnd_end = dnd_end
        self.remind_unit = remind_unit
        self.node_ids = node_ids
        self.baseline_ids = baseline_ids
        self.project_id = project_id
        self.biz_process_ids = biz_process_ids
        self.remind_type = remind_type
        self.max_alert_times = max_alert_times
        self.alert_interval = alert_interval
        self.detail = detail
        self.alert_unit = alert_unit
        self.alert_methods = alert_methods
        self.alert_targets = alert_targets
        self.robot_urls = robot_urls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.baseline_ids is not None:
            result['BaselineIds'] = self.baseline_ids
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.biz_process_ids is not None:
            result['BizProcessIds'] = self.biz_process_ids
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.robot_urls is not None:
            result['RobotUrls'] = self.robot_urls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('BaselineIds') is not None:
            self.baseline_ids = m.get('BaselineIds')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BizProcessIds') is not None:
            self.biz_process_ids = m.get('BizProcessIds')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('RobotUrls') is not None:
            self.robot_urls = m.get('RobotUrls')
        return self


class CreateRemindResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateRemindResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableRequestColumns(TeaModel):
    def __init__(
        self,
        column_name_cn: str = None,
        column_name: str = None,
        comment: str = None,
        column_type: str = None,
        seq_number: int = None,
        length: int = None,
        is_partition_col: bool = None,
    ):
        self.column_name_cn = column_name_cn
        self.column_name = column_name
        self.comment = comment
        self.column_type = column_type
        self.seq_number = seq_number
        self.length = length
        self.is_partition_col = is_partition_col

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name_cn is not None:
            result['ColumnNameCn'] = self.column_name_cn
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.seq_number is not None:
            result['SeqNumber'] = self.seq_number
        if self.length is not None:
            result['Length'] = self.length
        if self.is_partition_col is not None:
            result['IsPartitionCol'] = self.is_partition_col
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnNameCn') is not None:
            self.column_name_cn = m.get('ColumnNameCn')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('SeqNumber') is not None:
            self.seq_number = m.get('SeqNumber')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('IsPartitionCol') is not None:
            self.is_partition_col = m.get('IsPartitionCol')
        return self


class CreateTableRequestThemes(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        theme_level: int = None,
    ):
        self.theme_id = theme_id
        self.theme_level = theme_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.theme_level is not None:
            result['ThemeLevel'] = self.theme_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ThemeLevel') is not None:
            self.theme_level = m.get('ThemeLevel')
        return self


class CreateTableRequest(TeaModel):
    def __init__(
        self,
        is_view: int = None,
        visibility: int = None,
        life_cycle: int = None,
        category_id: int = None,
        logical_level_id: int = None,
        physics_level_id: int = None,
        external_table_type: str = None,
        location: str = None,
        project_id: int = None,
        table_name: str = None,
        endpoint: str = None,
        env_type: int = None,
        app_guid: str = None,
        comment: str = None,
        owner_id: str = None,
        has_part: int = None,
        client_token: str = None,
        columns: List[CreateTableRequestColumns] = None,
        themes: List[CreateTableRequestThemes] = None,
    ):
        self.is_view = is_view
        self.visibility = visibility
        self.life_cycle = life_cycle
        self.category_id = category_id
        self.logical_level_id = logical_level_id
        self.physics_level_id = physics_level_id
        self.external_table_type = external_table_type
        self.location = location
        self.project_id = project_id
        self.table_name = table_name
        self.endpoint = endpoint
        self.env_type = env_type
        self.app_guid = app_guid
        self.comment = comment
        self.owner_id = owner_id
        self.has_part = has_part
        self.client_token = client_token
        self.columns = columns
        self.themes = themes

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()
        if self.themes:
            for k in self.themes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.visibility is not None:
            result['Visibility'] = self.visibility
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.logical_level_id is not None:
            result['LogicalLevelId'] = self.logical_level_id
        if self.physics_level_id is not None:
            result['PhysicsLevelId'] = self.physics_level_id
        if self.external_table_type is not None:
            result['ExternalTableType'] = self.external_table_type
        if self.location is not None:
            result['Location'] = self.location
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.has_part is not None:
            result['HasPart'] = self.has_part
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        result['Themes'] = []
        if self.themes is not None:
            for k in self.themes:
                result['Themes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('Visibility') is not None:
            self.visibility = m.get('Visibility')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('LogicalLevelId') is not None:
            self.logical_level_id = m.get('LogicalLevelId')
        if m.get('PhysicsLevelId') is not None:
            self.physics_level_id = m.get('PhysicsLevelId')
        if m.get('ExternalTableType') is not None:
            self.external_table_type = m.get('ExternalTableType')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('HasPart') is not None:
            self.has_part = m.get('HasPart')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = CreateTableRequestColumns()
                self.columns.append(temp_model.from_map(k))
        self.themes = []
        if m.get('Themes') is not None:
            for k in m.get('Themes'):
                temp_model = CreateTableRequestThemes()
                self.themes.append(temp_model.from_map(k))
        return self


class CreateTableResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        next_task_id: str = None,
        task_id: str = None,
        content: str = None,
    ):
        self.status = status
        self.next_task_id = next_task_id
        self.task_id = task_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: CreateTableResponseBodyTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableLevelRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        level_type: int = None,
        name: str = None,
        description: str = None,
    ):
        self.project_id = project_id
        self.level_type = level_type
        self.name = name
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level_type is not None:
            result['LevelType'] = self.level_type
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('LevelType') is not None:
            self.level_type = m.get('LevelType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateTableLevelResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        level_id: int = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.level_id = level_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        return self


class CreateTableLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTableLevelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTableThemeRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        level: int = None,
        name: str = None,
        parent_id: int = None,
    ):
        self.project_id = project_id
        self.level = level
        self.name = name
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.level is not None:
            result['Level'] = self.level
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateTableThemeResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        theme_id: int = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.theme_id = theme_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        return self


class CreateTableThemeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTableThemeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUdfFileRequest(TeaModel):
    def __init__(
        self,
        file_folder_path: str = None,
        project_id: int = None,
        file_name: str = None,
        function_type: str = None,
        class_name: str = None,
        resources: str = None,
        udf_description: str = None,
        cmd_description: str = None,
        parameter_description: str = None,
        return_value: str = None,
        example: str = None,
        project_identifier: str = None,
    ):
        self.file_folder_path = file_folder_path
        self.project_id = project_id
        self.file_name = file_name
        self.function_type = function_type
        self.class_name = class_name
        self.resources = resources
        self.udf_description = udf_description
        self.cmd_description = cmd_description
        self.parameter_description = parameter_description
        self.return_value = return_value
        self.example = example
        self.project_identifier = project_identifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_folder_path is not None:
            result['FileFolderPath'] = self.file_folder_path
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.function_type is not None:
            result['FunctionType'] = self.function_type
        if self.class_name is not None:
            result['ClassName'] = self.class_name
        if self.resources is not None:
            result['Resources'] = self.resources
        if self.udf_description is not None:
            result['UdfDescription'] = self.udf_description
        if self.cmd_description is not None:
            result['CmdDescription'] = self.cmd_description
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.return_value is not None:
            result['ReturnValue'] = self.return_value
        if self.example is not None:
            result['Example'] = self.example
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileFolderPath') is not None:
            self.file_folder_path = m.get('FileFolderPath')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('FunctionType') is not None:
            self.function_type = m.get('FunctionType')
        if m.get('ClassName') is not None:
            self.class_name = m.get('ClassName')
        if m.get('Resources') is not None:
            self.resources = m.get('Resources')
        if m.get('UdfDescription') is not None:
            self.udf_description = m.get('UdfDescription')
        if m.get('CmdDescription') is not None:
            self.cmd_description = m.get('CmdDescription')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ReturnValue') is not None:
            self.return_value = m.get('ReturnValue')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        return self


class CreateUdfFileResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class CreateUdfFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateUdfFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUdfFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateViewRequestViewColumn(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        comment: str = None,
    ):
        self.column_name = column_name
        self.comment = comment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.comment is not None:
            result['Comment'] = self.comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        return self


class CreateViewRequest(TeaModel):
    def __init__(
        self,
        view_name: str = None,
        select_column: str = None,
        select_table_name: str = None,
        select_where: str = None,
        select_sql: str = None,
        app_guid: str = None,
        comment: str = None,
        client_token: str = None,
        view_column: List[CreateViewRequestViewColumn] = None,
    ):
        self.view_name = view_name
        self.select_column = select_column
        self.select_table_name = select_table_name
        self.select_where = select_where
        self.select_sql = select_sql
        self.app_guid = app_guid
        self.comment = comment
        self.client_token = client_token
        self.view_column = view_column

    def validate(self):
        if self.view_column:
            for k in self.view_column:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.view_name is not None:
            result['ViewName'] = self.view_name
        if self.select_column is not None:
            result['SelectColumn'] = self.select_column
        if self.select_table_name is not None:
            result['SelectTableName'] = self.select_table_name
        if self.select_where is not None:
            result['SelectWhere'] = self.select_where
        if self.select_sql is not None:
            result['SelectSQL'] = self.select_sql
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['ViewColumn'] = []
        if self.view_column is not None:
            for k in self.view_column:
                result['ViewColumn'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ViewName') is not None:
            self.view_name = m.get('ViewName')
        if m.get('SelectColumn') is not None:
            self.select_column = m.get('SelectColumn')
        if m.get('SelectTableName') is not None:
            self.select_table_name = m.get('SelectTableName')
        if m.get('SelectWhere') is not None:
            self.select_where = m.get('SelectWhere')
        if m.get('SelectSQL') is not None:
            self.select_sql = m.get('SelectSQL')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.view_column = []
        if m.get('ViewColumn') is not None:
            for k in m.get('ViewColumn'):
                temp_model = CreateViewRequestViewColumn()
                self.view_column.append(temp_model.from_map(k))
        return self


class CreateViewResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        next_task_id: str = None,
        task_id: str = None,
        content: str = None,
    ):
        self.status = status
        self.next_task_id = next_task_id
        self.task_id = task_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class CreateViewResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: CreateViewResponseBodyTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = CreateViewResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class CreateViewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateViewResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        business_id: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.business_id = business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class DeleteBusinessResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConnectionRequest(TeaModel):
    def __init__(
        self,
        connection_id: int = None,
    ):
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class DeleteConnectionResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: str = None,
        data: bool = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConnectionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteConnectionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class DeleteDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataServiceApiAuthorityRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
        authorized_project_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id
        self.authorized_project_id = authorized_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.authorized_project_id is not None:
            result['AuthorizedProjectId'] = self.authorized_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('AuthorizedProjectId') is not None:
            self.authorized_project_id = m.get('AuthorizedProjectId')
        return self


class DeleteDataServiceApiAuthorityResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
    ):
        self.success = success
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDataServiceApiAuthorityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDataServiceApiAuthorityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataServiceApiAuthorityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDataSourceRequest(TeaModel):
    def __init__(
        self,
        data_source_id: int = None,
    ):
        self.data_source_id = data_source_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        return self


class DeleteDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: str = None,
        data: bool = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: DeleteDISyncTaskResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DeleteDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeleteDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFileRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteFileResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        deployment_id: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.deployment_id = deployment_id
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFolderRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        folder_id: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.folder_id = folder_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class DeleteFolderResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFromMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
        table_guid: str = None,
    ):
        self.category_id = category_id
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class DeleteFromMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFromMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFromMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFromMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        category_id: int = None,
    ):
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DeleteMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProjectMemberRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        user_id: str = None,
    ):
        self.project_id = project_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DeleteProjectMemberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteProjectMemberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteProjectMemberResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProjectMemberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityEntityRequest(TeaModel):
    def __init__(
        self,
        entity_id: int = None,
        project_name: str = None,
        env_type: str = None,
    ):
        self.entity_id = entity_id
        self.project_name = project_name
        self.env_type = env_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class DeleteQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        follower_id: int = None,
    ):
        self.project_name = project_name
        self.follower_id = follower_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.follower_id is not None:
            result['FollowerId'] = self.follower_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('FollowerId') is not None:
            self.follower_id = m.get('FollowerId')
        return self


class DeleteQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRelativeNodeRequest(TeaModel):
    def __init__(
        self,
        env_type: str = None,
        match_expression: str = None,
        node_id: int = None,
        project_id: int = None,
        target_node_project_name: str = None,
        project_name: str = None,
        table_name: str = None,
        target_node_project_id: int = None,
    ):
        self.env_type = env_type
        self.match_expression = match_expression
        self.node_id = node_id
        self.project_id = project_id
        self.target_node_project_name = target_node_project_name
        self.project_name = project_name
        self.table_name = table_name
        self.target_node_project_id = target_node_project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.target_node_project_name is not None:
            result['TargetNodeProjectName'] = self.target_node_project_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.target_node_project_id is not None:
            result['TargetNodeProjectId'] = self.target_node_project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TargetNodeProjectName') is not None:
            self.target_node_project_name = m.get('TargetNodeProjectName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TargetNodeProjectId') is not None:
            self.target_node_project_id = m.get('TargetNodeProjectId')
        return self


class DeleteQualityRelativeNodeResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteQualityRelativeNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityRelativeNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityRelativeNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRuleRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        rule_id: int = None,
    ):
        self.project_name = project_name
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRemindRequest(TeaModel):
    def __init__(
        self,
        remind_id: int = None,
    ):
        self.remind_id = remind_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class DeleteRemindResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: bool = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeleteRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRemindResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        table_name: str = None,
        env_type: int = None,
        app_guid: str = None,
    ):
        self.project_id = project_id
        self.table_name = table_name
        self.env_type = env_type
        self.app_guid = app_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        return self


class DeleteTableResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        next_task_id: str = None,
        task_id: str = None,
        content: str = None,
    ):
        self.status = status
        self.next_task_id = next_task_id
        self.task_id = task_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DeleteTableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: DeleteTableResponseBodyTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteTableResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class DeleteTableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTableResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableLevelRequest(TeaModel):
    def __init__(
        self,
        level_id: int = None,
        project_id: int = None,
    ):
        self.level_id = level_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableLevelResponseBody(TeaModel):
    def __init__(
        self,
        delete_result: bool = None,
        request_id: str = None,
    ):
        self.delete_result = delete_result
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTableLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTableLevelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTableThemeRequest(TeaModel):
    def __init__(
        self,
        theme_id: int = None,
        project_id: int = None,
    ):
        self.theme_id = theme_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteTableThemeResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        delete_result: bool = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.delete_result = delete_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.delete_result is not None:
            result['DeleteResult'] = self.delete_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DeleteResult') is not None:
            self.delete_result = m.get('DeleteResult')
        return self


class DeleteTableThemeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTableThemeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTableThemeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteViewRequest(TeaModel):
    def __init__(
        self,
        view_name: str = None,
        app_guid: str = None,
    ):
        self.view_name = view_name
        self.app_guid = app_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.view_name is not None:
            result['ViewName'] = self.view_name
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ViewName') is not None:
            self.view_name = m.get('ViewName')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        return self


class DeleteViewResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        next_task_id: str = None,
        task_id: str = None,
        content: str = None,
    ):
        self.status = status
        self.next_task_id = next_task_id
        self.task_id = task_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DeleteViewResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_info: DeleteViewResponseBodyTaskInfo = None,
    ):
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = DeleteViewResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class DeleteViewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteViewResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteViewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeployDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeployDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: DeployDISyncTaskResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = DeployDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DeployDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeployDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeployDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployFileRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        file_id: int = None,
        comment: str = None,
        node_id: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.file_id = file_id
        self.comment = comment
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DeployFileResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DeployFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeployFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeployFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DesensitizeDataRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        scene_code: str = None,
    ):
        self.data = data
        self.scene_code = scene_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.scene_code is not None:
            result['SceneCode'] = self.scene_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('SceneCode') is not None:
            self.scene_code = m.get('SceneCode')
        return self


class DesensitizeDataResponseBody(TeaModel):
    def __init__(
        self,
        desensitize_data: str = None,
        request_id: str = None,
    ):
        self.desensitize_data = desensitize_data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desensitize_data is not None:
            result['DesensitizeData'] = self.desensitize_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesensitizeData') is not None:
            self.desensitize_data = m.get('DesensitizeData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DesensitizeDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DesensitizeDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DesensitizeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EstablishRelationTableToBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        business_id: str = None,
        table_guid: str = None,
        folder_id: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.business_id = business_id
        self.table_guid = table_guid
        self.folder_id = folder_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class EstablishRelationTableToBusinessResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EstablishRelationTableToBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EstablishRelationTableToBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EstablishRelationTableToBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportConnectionsRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ExportConnectionsResponseBodyDataDataSources(TeaModel):
    def __init__(
        self,
        status: int = None,
        project_id: int = None,
        sub_type: str = None,
        gmt_modified: str = None,
        env_type: int = None,
        connect_status: int = None,
        sequence: int = None,
        description: str = None,
        data_source_type: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        shared: bool = None,
        operator: str = None,
        name: str = None,
        content: str = None,
        id: int = None,
        binding_calc_engine_id: int = None,
        tenant_id: int = None,
    ):
        self.status = status
        self.project_id = project_id
        self.sub_type = sub_type
        self.gmt_modified = gmt_modified
        self.env_type = env_type
        self.connect_status = connect_status
        self.sequence = sequence
        self.description = description
        self.data_source_type = data_source_type
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.shared = shared
        self.operator = operator
        self.name = name
        self.content = content
        self.id = id
        self.binding_calc_engine_id = binding_calc_engine_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ExportConnectionsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_sources: List[ExportConnectionsResponseBodyDataDataSources] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_sources = data_sources

    def validate(self):
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportConnectionsResponseBodyDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ExportConnectionsResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: ExportConnectionsResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ExportConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ExportConnectionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportConnectionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        data_source_type: str = None,
        sub_type: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.data_source_type = data_source_type
        self.sub_type = sub_type
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ExportDataSourcesResponseBodyDataDataSources(TeaModel):
    def __init__(
        self,
        status: int = None,
        project_id: int = None,
        sub_type: str = None,
        gmt_modified: str = None,
        env_type: int = None,
        connect_status: int = None,
        sequence: int = None,
        description: str = None,
        data_source_type: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        shared: bool = None,
        operator: str = None,
        name: str = None,
        content: str = None,
        id: int = None,
        binding_calc_engine_id: int = None,
        tenant_id: int = None,
    ):
        self.status = status
        self.project_id = project_id
        self.sub_type = sub_type
        self.gmt_modified = gmt_modified
        self.env_type = env_type
        self.connect_status = connect_status
        self.sequence = sequence
        self.description = description
        self.data_source_type = data_source_type
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.shared = shared
        self.operator = operator
        self.name = name
        self.content = content
        self.id = id
        self.binding_calc_engine_id = binding_calc_engine_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.description is not None:
            result['Description'] = self.description
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ExportDataSourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_sources: List[ExportDataSourcesResponseBodyDataDataSources] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_sources = data_sources

    def validate(self):
        if self.data_sources:
            for k in self.data_sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataSources'] = []
        if self.data_sources is not None:
            for k in self.data_sources:
                result['DataSources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_sources = []
        if m.get('DataSources') is not None:
            for k in m.get('DataSources'):
                temp_model = ExportDataSourcesResponseBodyDataDataSources()
                self.data_sources.append(temp_model.from_map(k))
        return self


class ExportDataSourcesResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: ExportDataSourcesResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ExportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ExportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportDataSourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportDISyncTasksRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_param: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_param = task_param

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        return self


class ExportDISyncTasksResponseBodyData(TeaModel):
    def __init__(
        self,
        real_time_solution: str = None,
    ):
        self.real_time_solution = real_time_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.real_time_solution is not None:
            result['realTimeSolution'] = self.real_time_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('realTimeSolution') is not None:
            self.real_time_solution = m.get('realTimeSolution')
        return self


class ExportDISyncTasksResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: ExportDISyncTasksResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['success'] = self.success
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = ExportDISyncTasksResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        return self


class ExportDISyncTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportDISyncTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportDISyncTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDISyncTaskConfigForCreatingRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_param: str = None,
        client_token: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_param = task_param
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class GenerateDISyncTaskConfigForCreatingResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        process_id: int = None,
        message: str = None,
    ):
        self.status = status
        self.process_id = process_id
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class GenerateDISyncTaskConfigForCreatingResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: GenerateDISyncTaskConfigForCreatingResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateDISyncTaskConfigForCreatingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateDISyncTaskConfigForCreatingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateDISyncTaskConfigForCreatingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDISyncTaskConfigForCreatingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDISyncTaskConfigForUpdatingRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        task_param: str = None,
        client_token: str = None,
        task_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.task_param = task_param
        self.client_token = client_token
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GenerateDISyncTaskConfigForUpdatingResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        process_id: int = None,
        message: str = None,
    ):
        self.status = status
        self.process_id = process_id
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.process_id is not None:
            result['ProcessId'] = self.process_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProcessId') is not None:
            self.process_id = m.get('ProcessId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class GenerateDISyncTaskConfigForUpdatingResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: GenerateDISyncTaskConfigForUpdatingResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateDISyncTaskConfigForUpdatingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateDISyncTaskConfigForUpdatingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GenerateDISyncTaskConfigForUpdatingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDISyncTaskConfigForUpdatingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineConfigRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetBaselineConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        hour_sla_detail: str = None,
        is_default: bool = None,
        owner: str = None,
        project_id: int = None,
        priority: int = None,
        sla_minu: int = None,
        sla_hour: int = None,
        baseline_id: int = None,
        baseline_name: str = None,
        hour_exp_detail: str = None,
        use_flag: bool = None,
        exp_hour: int = None,
        baseline_type: str = None,
        exp_minu: int = None,
    ):
        self.hour_sla_detail = hour_sla_detail
        self.is_default = is_default
        self.owner = owner
        self.project_id = project_id
        self.priority = priority
        self.sla_minu = sla_minu
        self.sla_hour = sla_hour
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.hour_exp_detail = hour_exp_detail
        self.use_flag = use_flag
        self.exp_hour = exp_hour
        self.baseline_type = baseline_type
        self.exp_minu = exp_minu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        return self


class GetBaselineConfigResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetBaselineConfigResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetBaselineConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBaselineConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBaselineConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineKeyPathRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: str = None,
        in_group_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineKeyPathResponseBodyDataRuns(TeaModel):
    def __init__(
        self,
        status: str = None,
        abs_time: int = None,
        begin_running_time: int = None,
        cyc_time: int = None,
        owner: str = None,
        finish_time: int = None,
        project_id: int = None,
        begin_cast: int = None,
        instance_id: int = None,
        end_cast: int = None,
        begin_wait_res_time: int = None,
        in_group_id: int = None,
        node_name: str = None,
        bizdate: int = None,
        begin_wait_time_time: int = None,
        node_id: int = None,
    ):
        self.status = status
        self.abs_time = abs_time
        self.begin_running_time = begin_running_time
        self.cyc_time = cyc_time
        self.owner = owner
        self.finish_time = finish_time
        self.project_id = project_id
        self.begin_cast = begin_cast
        self.instance_id = instance_id
        self.end_cast = end_cast
        self.begin_wait_res_time = begin_wait_res_time
        self.in_group_id = in_group_id
        self.node_name = node_name
        self.bizdate = bizdate
        self.begin_wait_time_time = begin_wait_time_time
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.abs_time is not None:
            result['AbsTime'] = self.abs_time
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.begin_cast is not None:
            result['BeginCast'] = self.begin_cast
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AbsTime') is not None:
            self.abs_time = m.get('AbsTime')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BeginCast') is not None:
            self.begin_cast = m.get('BeginCast')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetBaselineKeyPathResponseBodyDataTopics(TeaModel):
    def __init__(
        self,
        topic_name: int = None,
        instance_id: int = None,
        topic_id: int = None,
        add_time: int = None,
    ):
        self.topic_name = topic_name
        self.instance_id = instance_id
        self.topic_id = topic_id
        self.add_time = add_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        return self


class GetBaselineKeyPathResponseBodyData(TeaModel):
    def __init__(
        self,
        owner: str = None,
        node_name: str = None,
        bizdate: int = None,
        project_id: int = None,
        instance_id: int = None,
        prg_type: int = None,
        node_id: int = None,
        in_group_id: int = None,
        runs: List[GetBaselineKeyPathResponseBodyDataRuns] = None,
        topics: List[GetBaselineKeyPathResponseBodyDataTopics] = None,
    ):
        self.owner = owner
        self.node_name = node_name
        self.bizdate = bizdate
        self.project_id = project_id
        self.instance_id = instance_id
        self.prg_type = prg_type
        self.node_id = node_id
        self.in_group_id = in_group_id
        self.runs = runs
        self.topics = topics

    def validate(self):
        if self.runs:
            for k in self.runs:
                if k:
                    k.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        result['Runs'] = []
        if self.runs is not None:
            for k in self.runs:
                result['Runs'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        self.runs = []
        if m.get('Runs') is not None:
            for k in m.get('Runs'):
                temp_model = GetBaselineKeyPathResponseBodyDataRuns()
                self.runs.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = GetBaselineKeyPathResponseBodyDataTopics()
                self.topics.append(temp_model.from_map(k))
        return self


class GetBaselineKeyPathResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: List[GetBaselineKeyPathResponseBodyData] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetBaselineKeyPathResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetBaselineKeyPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBaselineKeyPathResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineKeyPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBaselineStatusRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
        bizdate: str = None,
        in_group_id: int = None,
    ):
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetBaselineStatusResponseBodyDataLastInstance(TeaModel):
    def __init__(
        self,
        status: str = None,
        owner: str = None,
        finish_time: int = None,
        node_name: str = None,
        project_id: int = None,
        instance_id: int = None,
        end_cast: int = None,
        node_id: int = None,
    ):
        self.status = status
        self.owner = owner
        self.finish_time = finish_time
        self.node_name = node_name
        self.project_id = project_id
        self.instance_id = instance_id
        self.end_cast = end_cast
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetBaselineStatusResponseBodyDataBlockInstance(TeaModel):
    def __init__(
        self,
        status: str = None,
        owner: str = None,
        finish_time: int = None,
        node_name: str = None,
        project_id: int = None,
        instance_id: int = None,
        end_cast: int = None,
        node_id: int = None,
    ):
        self.status = status
        self.owner = owner
        self.finish_time = finish_time
        self.node_name = node_name
        self.project_id = project_id
        self.instance_id = instance_id
        self.end_cast = end_cast
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetBaselineStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        owner: str = None,
        finish_time: int = None,
        project_id: int = None,
        priority: int = None,
        end_cast: int = None,
        in_group_id: int = None,
        baseline_name: str = None,
        baseline_id: int = None,
        finish_status: str = None,
        bizdate: int = None,
        buffer: float = None,
        sla_time: int = None,
        exp_time: int = None,
        last_instance: GetBaselineStatusResponseBodyDataLastInstance = None,
        block_instance: GetBaselineStatusResponseBodyDataBlockInstance = None,
    ):
        self.status = status
        self.owner = owner
        self.finish_time = finish_time
        self.project_id = project_id
        self.priority = priority
        self.end_cast = end_cast
        self.in_group_id = in_group_id
        self.baseline_name = baseline_name
        self.baseline_id = baseline_id
        self.finish_status = finish_status
        self.bizdate = bizdate
        self.buffer = buffer
        self.sla_time = sla_time
        self.exp_time = exp_time
        self.last_instance = last_instance
        self.block_instance = block_instance

    def validate(self):
        if self.last_instance:
            self.last_instance.validate()
        if self.block_instance:
            self.block_instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        if self.last_instance is not None:
            result['LastInstance'] = self.last_instance.to_map()
        if self.block_instance is not None:
            result['BlockInstance'] = self.block_instance.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        if m.get('LastInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataLastInstance()
            self.last_instance = temp_model.from_map(m['LastInstance'])
        if m.get('BlockInstance') is not None:
            temp_model = GetBaselineStatusResponseBodyDataBlockInstance()
            self.block_instance = temp_model.from_map(m['BlockInstance'])
        return self


class GetBaselineStatusResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetBaselineStatusResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetBaselineStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBaselineStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBaselineStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBaselineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        business_id: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.business_id = business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        return self


class GetBusinessResponseBodyData(TeaModel):
    def __init__(
        self,
        owner: str = None,
        description: str = None,
        project_id: str = None,
        business_id: int = None,
        business_name: str = None,
        use_type: str = None,
    ):
        self.owner = owner
        self.description = description
        self.project_id = project_id
        self.business_id = business_id
        self.business_name = business_name
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.description is not None:
            result['Description'] = self.description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class GetBusinessResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetBusinessResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConnectionMetaRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        page_number: int = None,
        page_size: int = None,
        env_type: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.page_number = page_number
        self.page_size = page_size
        self.env_type = env_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class GetConnectionMetaResponseBodyData(TeaModel):
    def __init__(
        self,
        meta: str = None,
    ):
        self.meta = meta

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.meta is not None:
            result['Meta'] = self.meta
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        return self


class GetConnectionMetaResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: GetConnectionMetaResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetConnectionMetaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetConnectionMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetConnectionMetaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetConnectionMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDagRequest(TeaModel):
    def __init__(
        self,
        dag_id: int = None,
        project_env: str = None,
    ):
        self.dag_id = dag_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetDagResponseBodyData(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        finish_time: int = None,
        create_time: int = None,
        project_id: int = None,
        dag_id: int = None,
        gmtdate: int = None,
        start_time: int = None,
        create_user: str = None,
        bizdate: int = None,
        name: str = None,
        modify_time: int = None,
    ):
        self.type = type
        self.status = status
        self.finish_time = finish_time
        self.create_time = create_time
        self.project_id = project_id
        self.dag_id = dag_id
        self.gmtdate = gmtdate
        self.start_time = start_time
        self.create_user = create_user
        self.bizdate = bizdate
        self.name = name
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.gmtdate is not None:
            result['Gmtdate'] = self.gmtdate
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.name is not None:
            result['Name'] = self.name
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('Gmtdate') is not None:
            self.gmtdate = m.get('Gmtdate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetDagResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetDagResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDagResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApiRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        api_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.api_id = api_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        error_code: str = None,
        error_solution: str = None,
    ):
        self.error_message = error_message
        self.error_code = error_code
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        parameter_data_type: int = None,
        example_value: str = None,
        is_required_parameter: bool = None,
    ):
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServiceApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(
        self,
        service_host: str = None,
        service_content_type: int = None,
        service_path: str = None,
        successful_result_sample: str = None,
        failed_result_sample: str = None,
        service_request_body_description: str = None,
        registration_error_codes: List[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters] = None,
    ):
        self.service_host = service_host
        self.service_content_type = service_content_type
        self.service_path = service_path
        self.successful_result_sample = successful_result_sample
        self.failed_result_sample = failed_result_sample
        self.service_request_body_description = service_request_body_description
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        parameter_data_type: int = None,
        example_value: str = None,
        is_required_parameter: bool = None,
    ):
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        column_name: str = None,
        parameter_name: str = None,
        parameter_data_type: int = None,
        example_value: str = None,
    ):
        self.parameter_description = parameter_description
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        connection_id: int = None,
    ):
        self.table_name = table_name
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServiceApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(
        self,
        script: str = None,
        is_paged_response: bool = None,
        script_request_parameters: List[GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters] = None,
        script_connection: GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection = None,
    ):
        self.script = script
        self.is_paged_response = is_paged_response
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters
        self.script_connection = script_connection

    def validate(self):
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()
        if self.script_connection:
            self.script_connection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script is not None:
            result['Script'] = self.script
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        parameter_data_type: int = None,
        example_value: str = None,
        is_required_parameter: bool = None,
    ):
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        column_name: str = None,
        parameter_name: str = None,
        parameter_data_type: int = None,
        example_value: str = None,
    ):
        self.parameter_description = parameter_description
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        connection_id: int = None,
    ):
        self.table_name = table_name
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServiceApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        wizard_request_parameters: List[GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters] = None,
        wizard_response_parameters: List[GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters] = None,
        wizard_connection: GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection = None,
    ):
        self.is_paged_response = is_paged_response
        self.wizard_request_parameters = wizard_request_parameters
        self.wizard_response_parameters = wizard_response_parameters
        self.wizard_connection = wizard_connection

    def validate(self):
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()
        if self.wizard_connection:
            self.wizard_connection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        return self


class GetDataServiceApiResponseBodyData(TeaModel):
    def __init__(
        self,
        timeout: int = None,
        status: int = None,
        api_id: int = None,
        api_mode: int = None,
        project_id: int = None,
        response_content_type: int = None,
        creator_id: str = None,
        visible_range: int = None,
        modified_time: str = None,
        operator_id: str = None,
        group_id: str = None,
        description: str = None,
        folder_id: int = None,
        request_method: int = None,
        created_time: str = None,
        api_name: str = None,
        tenant_id: int = None,
        api_path: str = None,
        protocols: List[int] = None,
        registration_details: GetDataServiceApiResponseBodyDataRegistrationDetails = None,
        script_details: GetDataServiceApiResponseBodyDataScriptDetails = None,
        wizard_details: GetDataServiceApiResponseBodyDataWizardDetails = None,
    ):
        self.timeout = timeout
        self.status = status
        self.api_id = api_id
        self.api_mode = api_mode
        self.project_id = project_id
        self.response_content_type = response_content_type
        self.creator_id = creator_id
        self.visible_range = visible_range
        self.modified_time = modified_time
        self.operator_id = operator_id
        self.group_id = group_id
        self.description = description
        self.folder_id = folder_id
        self.request_method = request_method
        self.created_time = created_time
        self.api_name = api_name
        self.tenant_id = tenant_id
        self.api_path = api_path
        self.protocols = protocols
        self.registration_details = registration_details
        self.script_details = script_details
        self.wizard_details = wizard_details

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.status is not None:
            result['Status'] = self.status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServiceApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServiceApiResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetDataServiceApiResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetDataServiceApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataServiceApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceApplicationRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        application_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetDataServiceApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        application_code: str = None,
        application_key: str = None,
        application_secret: str = None,
        project_id: int = None,
        application_name: str = None,
        application_id: int = None,
    ):
        self.application_code = application_code
        self.application_key = application_key
        self.application_secret = application_secret
        self.project_id = project_id
        self.application_name = application_name
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_code is not None:
            result['ApplicationCode'] = self.application_code
        if self.application_key is not None:
            result['ApplicationKey'] = self.application_key
        if self.application_secret is not None:
            result['ApplicationSecret'] = self.application_secret
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationCode') is not None:
            self.application_code = m.get('ApplicationCode')
        if m.get('ApplicationKey') is not None:
            self.application_key = m.get('ApplicationKey')
        if m.get('ApplicationSecret') is not None:
            self.application_secret = m.get('ApplicationSecret')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetDataServiceApplicationResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetDataServiceApplicationResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetDataServiceApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataServiceApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceApplicationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceFolderRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        folder_id: int = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.folder_id = folder_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class GetDataServiceFolderResponseBodyFolder(TeaModel):
    def __init__(
        self,
        parent_id: int = None,
        modified_time: str = None,
        group_id: str = None,
        folder_id: int = None,
        project_id: int = None,
        folder_name: str = None,
        created_time: str = None,
        tenant_id: int = None,
    ):
        self.parent_id = parent_id
        self.modified_time = modified_time
        self.group_id = group_id
        self.folder_id = folder_id
        self.project_id = project_id
        self.folder_name = folder_name
        self.created_time = created_time
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.folder_name is not None:
            result['FolderName'] = self.folder_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FolderName') is not None:
            self.folder_name = m.get('FolderName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceFolderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        folder: GetDataServiceFolderResponseBodyFolder = None,
    ):
        self.request_id = request_id
        self.folder = folder

    def validate(self):
        if self.folder:
            self.folder.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.folder is not None:
            result['Folder'] = self.folder.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Folder') is not None:
            temp_model = GetDataServiceFolderResponseBodyFolder()
            self.folder = temp_model.from_map(m['Folder'])
        return self


class GetDataServiceFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServiceGroupRequest(TeaModel):
    def __init__(
        self,
        tenant_id: int = None,
        project_id: int = None,
        group_id: str = None,
    ):
        self.tenant_id = tenant_id
        self.project_id = project_id
        self.group_id = group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class GetDataServiceGroupResponseBodyGroup(TeaModel):
    def __init__(
        self,
        modified_time: str = None,
        description: str = None,
        group_name: str = None,
        group_id: str = None,
        project_id: int = None,
        api_gateway_group_id: str = None,
        creator_id: str = None,
        created_time: str = None,
        tenant_id: int = None,
    ):
        self.modified_time = modified_time
        self.description = description
        self.group_name = group_name
        self.group_id = group_id
        self.project_id = project_id
        self.api_gateway_group_id = api_gateway_group_id
        self.creator_id = creator_id
        self.created_time = created_time
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.api_gateway_group_id is not None:
            result['ApiGatewayGroupId'] = self.api_gateway_group_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ApiGatewayGroupId') is not None:
            self.api_gateway_group_id = m.get('ApiGatewayGroupId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetDataServiceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        group: GetDataServiceGroupResponseBodyGroup = None,
    ):
        self.request_id = request_id
        self.group = group

    def validate(self):
        if self.group:
            self.group.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.group is not None:
            result['Group'] = self.group.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Group') is not None:
            temp_model = GetDataServiceGroupResponseBodyGroup()
            self.group = temp_model.from_map(m['Group'])
        return self


class GetDataServiceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServiceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServiceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataServicePublishedApiRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        tenant_id: int = None,
        api_id: int = None,
    ):
        self.project_id = project_id
        self.tenant_id = tenant_id
        self.api_id = api_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        error_code: str = None,
        error_solution: str = None,
    ):
        self.error_message = error_message
        self.error_code = error_code
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        example_value: str = None,
        parameter_data_type: int = None,
        is_required_parameter: bool = None,
    ):
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServicePublishedApiResponseBodyDataRegistrationDetails(TeaModel):
    def __init__(
        self,
        service_host: str = None,
        service_content_type: int = None,
        service_path: str = None,
        successful_result_sample: str = None,
        failed_result_sample: str = None,
        service_request_body_description: str = None,
        registration_error_codes: List[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters] = None,
    ):
        self.service_host = service_host
        self.service_content_type = service_content_type
        self.service_path = service_path
        self.successful_result_sample = successful_result_sample
        self.failed_result_sample = failed_result_sample
        self.service_request_body_description = service_request_body_description
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        error_code: str = None,
        error_solution: str = None,
    ):
        self.error_message = error_message
        self.error_code = error_code
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        example_value: str = None,
        parameter_data_type: int = None,
        is_required_parameter: bool = None,
    ):
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        parameter_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
    ):
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        connection_id: int = None,
    ):
        self.table_name = table_name
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServicePublishedApiResponseBodyDataScriptDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        successful_result_sample: str = None,
        failed_result_sample: str = None,
        script: str = None,
        script_error_codes: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes] = None,
        script_request_parameters: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters] = None,
        script_connection: GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection = None,
    ):
        self.is_paged_response = is_paged_response
        self.successful_result_sample = successful_result_sample
        self.failed_result_sample = failed_result_sample
        self.script = script
        self.script_error_codes = script_error_codes
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters
        self.script_connection = script_connection

    def validate(self):
        if self.script_error_codes:
            for k in self.script_error_codes:
                if k:
                    k.validate()
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()
        if self.script_connection:
            self.script_connection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.script is not None:
            result['Script'] = self.script
        result['ScriptErrorCodes'] = []
        if self.script_error_codes is not None:
            for k in self.script_error_codes:
                result['ScriptErrorCodes'].append(k.to_map() if k else None)
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('Script') is not None:
            self.script = m.get('Script')
        self.script_error_codes = []
        if m.get('ScriptErrorCodes') is not None:
            for k in m.get('ScriptErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptErrorCodes()
                self.script_error_codes.append(temp_model.from_map(k))
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('ScriptConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        error_code: str = None,
        error_solution: str = None,
    ):
        self.error_message = error_message
        self.error_code = error_code
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        example_value: str = None,
        parameter_data_type: int = None,
        is_required_parameter: bool = None,
    ):
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        parameter_name: str = None,
        example_value: str = None,
        parameter_data_type: int = None,
    ):
        self.parameter_description = parameter_description
        self.parameter_name = parameter_name
        self.example_value = example_value
        self.parameter_data_type = parameter_data_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        connection_id: int = None,
    ):
        self.table_name = table_name
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class GetDataServicePublishedApiResponseBodyDataWizardDetails(TeaModel):
    def __init__(
        self,
        is_paged_response: bool = None,
        successful_result_sample: str = None,
        failed_result_sample: str = None,
        wizard_error_codes: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes] = None,
        wizard_request_parameters: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters] = None,
        wizard_response_parameters: List[GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters] = None,
        wizard_connection: GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection = None,
    ):
        self.is_paged_response = is_paged_response
        self.successful_result_sample = successful_result_sample
        self.failed_result_sample = failed_result_sample
        self.wizard_error_codes = wizard_error_codes
        self.wizard_request_parameters = wizard_request_parameters
        self.wizard_response_parameters = wizard_response_parameters
        self.wizard_connection = wizard_connection

    def validate(self):
        if self.wizard_error_codes:
            for k in self.wizard_error_codes:
                if k:
                    k.validate()
        if self.wizard_request_parameters:
            for k in self.wizard_request_parameters:
                if k:
                    k.validate()
        if self.wizard_response_parameters:
            for k in self.wizard_response_parameters:
                if k:
                    k.validate()
        if self.wizard_connection:
            self.wizard_connection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        result['WizardErrorCodes'] = []
        if self.wizard_error_codes is not None:
            for k in self.wizard_error_codes:
                result['WizardErrorCodes'].append(k.to_map() if k else None)
        result['WizardRequestParameters'] = []
        if self.wizard_request_parameters is not None:
            for k in self.wizard_request_parameters:
                result['WizardRequestParameters'].append(k.to_map() if k else None)
        result['WizardResponseParameters'] = []
        if self.wizard_response_parameters is not None:
            for k in self.wizard_response_parameters:
                result['WizardResponseParameters'].append(k.to_map() if k else None)
        if self.wizard_connection is not None:
            result['WizardConnection'] = self.wizard_connection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        self.wizard_error_codes = []
        if m.get('WizardErrorCodes') is not None:
            for k in m.get('WizardErrorCodes'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardErrorCodes()
                self.wizard_error_codes.append(temp_model.from_map(k))
        self.wizard_request_parameters = []
        if m.get('WizardRequestParameters') is not None:
            for k in m.get('WizardRequestParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardRequestParameters()
                self.wizard_request_parameters.append(temp_model.from_map(k))
        self.wizard_response_parameters = []
        if m.get('WizardResponseParameters') is not None:
            for k in m.get('WizardResponseParameters'):
                temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardResponseParameters()
                self.wizard_response_parameters.append(temp_model.from_map(k))
        if m.get('WizardConnection') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetailsWizardConnection()
            self.wizard_connection = temp_model.from_map(m['WizardConnection'])
        return self


class GetDataServicePublishedApiResponseBodyData(TeaModel):
    def __init__(
        self,
        timeout: int = None,
        status: int = None,
        api_id: int = None,
        api_mode: int = None,
        project_id: int = None,
        response_content_type: int = None,
        creator_id: str = None,
        visible_range: int = None,
        modified_time: str = None,
        operator_id: str = None,
        group_id: str = None,
        description: str = None,
        request_method: int = None,
        created_time: str = None,
        api_name: str = None,
        tenant_id: int = None,
        api_path: str = None,
        protocols: List[int] = None,
        registration_details: GetDataServicePublishedApiResponseBodyDataRegistrationDetails = None,
        script_details: GetDataServicePublishedApiResponseBodyDataScriptDetails = None,
        wizard_details: GetDataServicePublishedApiResponseBodyDataWizardDetails = None,
    ):
        self.timeout = timeout
        self.status = status
        self.api_id = api_id
        self.api_mode = api_mode
        self.project_id = project_id
        self.response_content_type = response_content_type
        self.creator_id = creator_id
        self.visible_range = visible_range
        self.modified_time = modified_time
        self.operator_id = operator_id
        self.group_id = group_id
        self.description = description
        self.request_method = request_method
        self.created_time = created_time
        self.api_name = api_name
        self.tenant_id = tenant_id
        self.api_path = api_path
        self.protocols = protocols
        self.registration_details = registration_details
        self.script_details = script_details
        self.wizard_details = wizard_details

    def validate(self):
        if self.registration_details:
            self.registration_details.validate()
        if self.script_details:
            self.script_details.validate()
        if self.wizard_details:
            self.wizard_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.status is not None:
            result['Status'] = self.status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.api_mode is not None:
            result['ApiMode'] = self.api_mode
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.response_content_type is not None:
            result['ResponseContentType'] = self.response_content_type
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.visible_range is not None:
            result['VisibleRange'] = self.visible_range
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.description is not None:
            result['Description'] = self.description
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.registration_details is not None:
            result['RegistrationDetails'] = self.registration_details.to_map()
        if self.script_details is not None:
            result['ScriptDetails'] = self.script_details.to_map()
        if self.wizard_details is not None:
            result['WizardDetails'] = self.wizard_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ApiMode') is not None:
            self.api_mode = m.get('ApiMode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ResponseContentType') is not None:
            self.response_content_type = m.get('ResponseContentType')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('VisibleRange') is not None:
            self.visible_range = m.get('VisibleRange')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RegistrationDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataRegistrationDetails()
            self.registration_details = temp_model.from_map(m['RegistrationDetails'])
        if m.get('ScriptDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataScriptDetails()
            self.script_details = temp_model.from_map(m['ScriptDetails'])
        if m.get('WizardDetails') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyDataWizardDetails()
            self.wizard_details = temp_model.from_map(m['WizardDetails'])
        return self


class GetDataServicePublishedApiResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetDataServicePublishedApiResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetDataServicePublishedApiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataServicePublishedApiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataServicePublishedApiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataServicePublishedApiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataSourceMetaRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        datasource_name: str = None,
        page_number: int = None,
        page_size: int = None,
        env_type: str = None,
    ):
        self.project_id = project_id
        self.datasource_name = datasource_name
        self.page_number = page_number
        self.page_size = page_size
        self.env_type = env_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.datasource_name is not None:
            result['DatasourceName'] = self.datasource_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DatasourceName') is not None:
            self.datasource_name = m.get('DatasourceName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        return self


class GetDataSourceMetaResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
        meta: str = None,
    ):
        self.status = status
        self.message = message
        self.meta = meta

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.meta is not None:
            result['Meta'] = self.meta
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        return self


class GetDataSourceMetaResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: GetDataSourceMetaResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDataSourceMetaResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataSourceMetaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDataSourceMetaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataSourceMetaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDDLJobStatusRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetDDLJobStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        next_task_id: str = None,
        task_id: str = None,
        content: str = None,
    ):
        self.status = status
        self.next_task_id = next_task_id
        self.task_id = task_id
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.next_task_id is not None:
            result['NextTaskId'] = self.next_task_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NextTaskId') is not None:
            self.next_task_id = m.get('NextTaskId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class GetDDLJobStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetDDLJobStatusResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDDLJobStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDDLJobStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDDLJobStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDDLJobStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeploymentRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        deployment_id: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.deployment_id = deployment_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetDeploymentResponseBodyDataDeployment(TeaModel):
    def __init__(
        self,
        status: int = None,
        error_message: str = None,
        from_environment: int = None,
        to_environment: int = None,
        checking_status: int = None,
        create_time: int = None,
        handler_id: str = None,
        creator_id: str = None,
        execute_time: int = None,
        name: str = None,
    ):
        self.status = status
        self.error_message = error_message
        self.from_environment = from_environment
        self.to_environment = to_environment
        self.checking_status = checking_status
        self.create_time = create_time
        self.handler_id = handler_id
        self.creator_id = creator_id
        self.execute_time = execute_time
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.from_environment is not None:
            result['FromEnvironment'] = self.from_environment
        if self.to_environment is not None:
            result['ToEnvironment'] = self.to_environment
        if self.checking_status is not None:
            result['CheckingStatus'] = self.checking_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FromEnvironment') is not None:
            self.from_environment = m.get('FromEnvironment')
        if m.get('ToEnvironment') is not None:
            self.to_environment = m.get('ToEnvironment')
        if m.get('CheckingStatus') is not None:
            self.checking_status = m.get('CheckingStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetDeploymentResponseBodyData(TeaModel):
    def __init__(
        self,
        deployment: GetDeploymentResponseBodyDataDeployment = None,
    ):
        self.deployment = deployment

    def validate(self):
        if self.deployment:
            self.deployment.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment is not None:
            result['Deployment'] = self.deployment.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Deployment') is not None:
            temp_model = GetDeploymentResponseBodyDataDeployment()
            self.deployment = temp_model.from_map(m['Deployment'])
        return self


class GetDeploymentResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetDeploymentResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeploymentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDeploymentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncInstanceInfoRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail(TeaModel):
    def __init__(
        self,
        status: str = None,
        step_id: int = None,
        step_name: str = None,
    ):
        self.status = status
        self.step_id = step_id
        self.step_name = step_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.step_id is not None:
            result['StepId'] = self.step_id
        if self.step_name is not None:
            result['StepName'] = self.step_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StepId') is not None:
            self.step_id = m.get('StepId')
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        return self


class GetDISyncInstanceInfoResponseBodyDataSolutionInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        id: int = None,
        creator_name: str = None,
        step_detail: List[GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail] = None,
    ):
        self.status = status
        self.id = id
        self.creator_name = creator_name
        self.step_detail = step_detail

    def validate(self):
        if self.step_detail:
            for k in self.step_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.id is not None:
            result['Id'] = self.id
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        result['StepDetail'] = []
        if self.step_detail is not None:
            for k in self.step_detail:
                result['StepDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        self.step_detail = []
        if m.get('StepDetail') is not None:
            for k in m.get('StepDetail'):
                temp_model = GetDISyncInstanceInfoResponseBodyDataSolutionInfoStepDetail()
                self.step_detail.append(temp_model.from_map(k))
        return self


class GetDISyncInstanceInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        message: str = None,
        name: str = None,
        solution_info: GetDISyncInstanceInfoResponseBodyDataSolutionInfo = None,
    ):
        self.status = status
        self.message = message
        self.name = name
        self.solution_info = solution_info

    def validate(self):
        if self.solution_info:
            self.solution_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.solution_info is not None:
            result['SolutionInfo'] = self.solution_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SolutionInfo') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyDataSolutionInfo()
            self.solution_info = temp_model.from_map(m['SolutionInfo'])
        return self


class GetDISyncInstanceInfoResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: GetDISyncInstanceInfoResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDISyncInstanceInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDISyncInstanceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDISyncInstanceInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncInstanceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncTaskRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        file_id: int = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.file_id = file_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class GetDISyncTaskResponseBodyDataSolutionDetail(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        start_time: str = None,
        creator_name: str = None,
        project_id: int = None,
        source_type: str = None,
        process_content: str = None,
        name: str = None,
        process_extra: str = None,
        submit_time: str = None,
        id: int = None,
    ):
        self.status = status
        self.type = type
        self.start_time = start_time
        self.creator_name = creator_name
        self.project_id = project_id
        self.source_type = source_type
        self.process_content = process_content
        self.name = name
        self.process_extra = process_extra
        self.submit_time = submit_time
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.process_content is not None:
            result['ProcessContent'] = self.process_content
        if self.name is not None:
            result['Name'] = self.name
        if self.process_extra is not None:
            result['ProcessExtra'] = self.process_extra
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('ProcessContent') is not None:
            self.process_content = m.get('ProcessContent')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProcessExtra') is not None:
            self.process_extra = m.get('ProcessExtra')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetDISyncTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        code: str = None,
        status: str = None,
        message: str = None,
        solution_detail: GetDISyncTaskResponseBodyDataSolutionDetail = None,
    ):
        self.code = code
        self.status = status
        self.message = message
        self.solution_detail = solution_detail

    def validate(self):
        if self.solution_detail:
            self.solution_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        if self.solution_detail is not None:
            result['SolutionDetail'] = self.solution_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SolutionDetail') is not None:
            temp_model = GetDISyncTaskResponseBodyDataSolutionDetail()
            self.solution_detail = temp_model.from_map(m['SolutionDetail'])
        return self


class GetDISyncTaskResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: GetDISyncTaskResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDISyncTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDISyncTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDISyncTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDISyncTaskMetricInfoRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        file_id: int = None,
        start_date: int = None,
        end_date: int = None,
    ):
        self.project_id = project_id
        self.file_id = file_id
        self.start_date = start_date
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetDISyncTaskMetricInfoResponseBodyMetricInfo(TeaModel):
    def __init__(
        self,
        message: str = None,
        sum_reader_records: int = None,
        sum_writer_records: int = None,
        last_task_delay: int = None,
        insert_reader_records: int = None,
        update_reader_records: int = None,
        delete_reader_records: int = None,
        insert_writer_records: int = None,
        update_writer_records: int = None,
        delete_writer_records: int = None,
    ):
        self.message = message
        self.sum_reader_records = sum_reader_records
        self.sum_writer_records = sum_writer_records
        self.last_task_delay = last_task_delay
        self.insert_reader_records = insert_reader_records
        self.update_reader_records = update_reader_records
        self.delete_reader_records = delete_reader_records
        self.insert_writer_records = insert_writer_records
        self.update_writer_records = update_writer_records
        self.delete_writer_records = delete_writer_records

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.sum_reader_records is not None:
            result['SumReaderRecords'] = self.sum_reader_records
        if self.sum_writer_records is not None:
            result['SumWriterRecords'] = self.sum_writer_records
        if self.last_task_delay is not None:
            result['LastTaskDelay'] = self.last_task_delay
        if self.insert_reader_records is not None:
            result['InsertReaderRecords'] = self.insert_reader_records
        if self.update_reader_records is not None:
            result['UpdateReaderRecords'] = self.update_reader_records
        if self.delete_reader_records is not None:
            result['DeleteReaderRecords'] = self.delete_reader_records
        if self.insert_writer_records is not None:
            result['InsertWriterRecords'] = self.insert_writer_records
        if self.update_writer_records is not None:
            result['UpdateWriterRecords'] = self.update_writer_records
        if self.delete_writer_records is not None:
            result['DeleteWriterRecords'] = self.delete_writer_records
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('SumReaderRecords') is not None:
            self.sum_reader_records = m.get('SumReaderRecords')
        if m.get('SumWriterRecords') is not None:
            self.sum_writer_records = m.get('SumWriterRecords')
        if m.get('LastTaskDelay') is not None:
            self.last_task_delay = m.get('LastTaskDelay')
        if m.get('InsertReaderRecords') is not None:
            self.insert_reader_records = m.get('InsertReaderRecords')
        if m.get('UpdateReaderRecords') is not None:
            self.update_reader_records = m.get('UpdateReaderRecords')
        if m.get('DeleteReaderRecords') is not None:
            self.delete_reader_records = m.get('DeleteReaderRecords')
        if m.get('InsertWriterRecords') is not None:
            self.insert_writer_records = m.get('InsertWriterRecords')
        if m.get('UpdateWriterRecords') is not None:
            self.update_writer_records = m.get('UpdateWriterRecords')
        if m.get('DeleteWriterRecords') is not None:
            self.delete_writer_records = m.get('DeleteWriterRecords')
        return self


class GetDISyncTaskMetricInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        metric_info: GetDISyncTaskMetricInfoResponseBodyMetricInfo = None,
    ):
        # Id of the request
        self.request_id = request_id
        # isSuccess
        self.success = success
        self.metric_info = metric_info

    def validate(self):
        if self.metric_info:
            self.metric_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.metric_info is not None:
            result['MetricInfo'] = self.metric_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('MetricInfo') is not None:
            temp_model = GetDISyncTaskMetricInfoResponseBodyMetricInfo()
            self.metric_info = temp_model.from_map(m['MetricInfo'])
        return self


class GetDISyncTaskMetricInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetDISyncTaskMetricInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDISyncTaskMetricInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        file_id: int = None,
        node_id: int = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.file_id = file_id
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetFileResponseBodyDataFile(TeaModel):
    def __init__(
        self,
        commit_status: int = None,
        auto_parsing: bool = None,
        owner: str = None,
        create_time: int = None,
        file_type: int = None,
        current_version: int = None,
        biz_id: int = None,
        last_edit_user: str = None,
        file_name: str = None,
        connection_name: str = None,
        use_type: str = None,
        file_folder_id: str = None,
        parent_id: int = None,
        create_user: str = None,
        is_max_compute: bool = None,
        business_id: int = None,
        file_description: str = None,
        deleted_status: str = None,
        last_edit_time: int = None,
        content: str = None,
        node_id: int = None,
    ):
        self.commit_status = commit_status
        self.auto_parsing = auto_parsing
        self.owner = owner
        self.create_time = create_time
        self.file_type = file_type
        self.current_version = current_version
        self.biz_id = biz_id
        self.last_edit_user = last_edit_user
        self.file_name = file_name
        self.connection_name = connection_name
        self.use_type = use_type
        self.file_folder_id = file_folder_id
        self.parent_id = parent_id
        self.create_user = create_user
        self.is_max_compute = is_max_compute
        self.business_id = business_id
        self.file_description = file_description
        self.deleted_status = deleted_status
        self.last_edit_time = last_edit_time
        self.content = content
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit_status is not None:
            result['CommitStatus'] = self.commit_status
        if self.auto_parsing is not None:
            result['AutoParsing'] = self.auto_parsing
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.file_type is not None:
            result['FileType'] = self.file_type
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.last_edit_user is not None:
            result['LastEditUser'] = self.last_edit_user
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.connection_name is not None:
            result['ConnectionName'] = self.connection_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        if self.file_folder_id is not None:
            result['FileFolderId'] = self.file_folder_id
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.create_user is not None:
            result['CreateUser'] = self.create_user
        if self.is_max_compute is not None:
            result['IsMaxCompute'] = self.is_max_compute
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.file_description is not None:
            result['FileDescription'] = self.file_description
        if self.deleted_status is not None:
            result['DeletedStatus'] = self.deleted_status
        if self.last_edit_time is not None:
            result['LastEditTime'] = self.last_edit_time
        if self.content is not None:
            result['Content'] = self.content
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommitStatus') is not None:
            self.commit_status = m.get('CommitStatus')
        if m.get('AutoParsing') is not None:
            self.auto_parsing = m.get('AutoParsing')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('FileType') is not None:
            self.file_type = m.get('FileType')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('LastEditUser') is not None:
            self.last_edit_user = m.get('LastEditUser')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ConnectionName') is not None:
            self.connection_name = m.get('ConnectionName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        if m.get('FileFolderId') is not None:
            self.file_folder_id = m.get('FileFolderId')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('CreateUser') is not None:
            self.create_user = m.get('CreateUser')
        if m.get('IsMaxCompute') is not None:
            self.is_max_compute = m.get('IsMaxCompute')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('FileDescription') is not None:
            self.file_description = m.get('FileDescription')
        if m.get('DeletedStatus') is not None:
            self.deleted_status = m.get('DeletedStatus')
        if m.get('LastEditTime') is not None:
            self.last_edit_time = m.get('LastEditTime')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetFileResponseBodyDataNodeConfigurationInputList(TeaModel):
    def __init__(
        self,
        input: str = None,
        parse_type: str = None,
    ):
        self.input = input
        self.parse_type = parse_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input is not None:
            result['Input'] = self.input
        if self.parse_type is not None:
            result['ParseType'] = self.parse_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Input') is not None:
            self.input = m.get('Input')
        if m.get('ParseType') is not None:
            self.parse_type = m.get('ParseType')
        return self


class GetFileResponseBodyDataNodeConfigurationOutputList(TeaModel):
    def __init__(
        self,
        ref_table_name: str = None,
        output: str = None,
    ):
        self.ref_table_name = ref_table_name
        self.output = output

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ref_table_name is not None:
            result['RefTableName'] = self.ref_table_name
        if self.output is not None:
            result['Output'] = self.output
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RefTableName') is not None:
            self.ref_table_name = m.get('RefTableName')
        if m.get('Output') is not None:
            self.output = m.get('Output')
        return self


class GetFileResponseBodyDataNodeConfiguration(TeaModel):
    def __init__(
        self,
        rerun_mode: str = None,
        scheduler_type: str = None,
        stop: bool = None,
        para_value: str = None,
        start_effect_date: int = None,
        end_effect_date: int = None,
        cycle_type: str = None,
        dependent_node_id_list: str = None,
        resource_group_id: int = None,
        dependent_type: str = None,
        auto_rerun_times: int = None,
        auto_rerun_interval_millis: int = None,
        cron_express: str = None,
        input_list: List[GetFileResponseBodyDataNodeConfigurationInputList] = None,
        output_list: List[GetFileResponseBodyDataNodeConfigurationOutputList] = None,
    ):
        self.rerun_mode = rerun_mode
        self.scheduler_type = scheduler_type
        self.stop = stop
        self.para_value = para_value
        self.start_effect_date = start_effect_date
        self.end_effect_date = end_effect_date
        self.cycle_type = cycle_type
        self.dependent_node_id_list = dependent_node_id_list
        self.resource_group_id = resource_group_id
        self.dependent_type = dependent_type
        self.auto_rerun_times = auto_rerun_times
        self.auto_rerun_interval_millis = auto_rerun_interval_millis
        self.cron_express = cron_express
        self.input_list = input_list
        self.output_list = output_list

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.output_list:
            for k in self.output_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rerun_mode is not None:
            result['RerunMode'] = self.rerun_mode
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.stop is not None:
            result['Stop'] = self.stop
        if self.para_value is not None:
            result['ParaValue'] = self.para_value
        if self.start_effect_date is not None:
            result['StartEffectDate'] = self.start_effect_date
        if self.end_effect_date is not None:
            result['EndEffectDate'] = self.end_effect_date
        if self.cycle_type is not None:
            result['CycleType'] = self.cycle_type
        if self.dependent_node_id_list is not None:
            result['DependentNodeIdList'] = self.dependent_node_id_list
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.dependent_type is not None:
            result['DependentType'] = self.dependent_type
        if self.auto_rerun_times is not None:
            result['AutoRerunTimes'] = self.auto_rerun_times
        if self.auto_rerun_interval_millis is not None:
            result['AutoRerunIntervalMillis'] = self.auto_rerun_interval_millis
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        result['OutputList'] = []
        if self.output_list is not None:
            for k in self.output_list:
                result['OutputList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RerunMode') is not None:
            self.rerun_mode = m.get('RerunMode')
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('Stop') is not None:
            self.stop = m.get('Stop')
        if m.get('ParaValue') is not None:
            self.para_value = m.get('ParaValue')
        if m.get('StartEffectDate') is not None:
            self.start_effect_date = m.get('StartEffectDate')
        if m.get('EndEffectDate') is not None:
            self.end_effect_date = m.get('EndEffectDate')
        if m.get('CycleType') is not None:
            self.cycle_type = m.get('CycleType')
        if m.get('DependentNodeIdList') is not None:
            self.dependent_node_id_list = m.get('DependentNodeIdList')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('DependentType') is not None:
            self.dependent_type = m.get('DependentType')
        if m.get('AutoRerunTimes') is not None:
            self.auto_rerun_times = m.get('AutoRerunTimes')
        if m.get('AutoRerunIntervalMillis') is not None:
            self.auto_rerun_interval_millis = m.get('AutoRerunIntervalMillis')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationInputList()
                self.input_list.append(temp_model.from_map(k))
        self.output_list = []
        if m.get('OutputList') is not None:
            for k in m.get('OutputList'):
                temp_model = GetFileResponseBodyDataNodeConfigurationOutputList()
                self.output_list.append(temp_model.from_map(k))
        return self


class GetFileResponseBodyData(TeaModel):
    def __init__(
        self,
        file: GetFileResponseBodyDataFile = None,
        node_configuration: GetFileResponseBodyDataNodeConfiguration = None,
    ):
        self.file = file
        self.node_configuration = node_configuration

    def validate(self):
        if self.file:
            self.file.validate()
        if self.node_configuration:
            self.node_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file is not None:
            result['File'] = self.file.to_map()
        if self.node_configuration is not None:
            result['NodeConfiguration'] = self.node_configuration.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('File') is not None:
            temp_model = GetFileResponseBodyDataFile()
            self.file = temp_model.from_map(m['File'])
        if m.get('NodeConfiguration') is not None:
            temp_model = GetFileResponseBodyDataNodeConfiguration()
            self.node_configuration = temp_model.from_map(m['NodeConfiguration'])
        return self


class GetFileResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetFileResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFileResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFileResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileTypeStatisticRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetFileTypeStatisticResponseBodyProgramTypeAndCounts(TeaModel):
    def __init__(
        self,
        count: int = None,
        program_type: str = None,
    ):
        self.count = count
        self.program_type = program_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        return self


class GetFileTypeStatisticResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        program_type_and_counts: List[GetFileTypeStatisticResponseBodyProgramTypeAndCounts] = None,
    ):
        self.request_id = request_id
        self.program_type_and_counts = program_type_and_counts

    def validate(self):
        if self.program_type_and_counts:
            for k in self.program_type_and_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ProgramTypeAndCounts'] = []
        if self.program_type_and_counts is not None:
            for k in self.program_type_and_counts:
                result['ProgramTypeAndCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.program_type_and_counts = []
        if m.get('ProgramTypeAndCounts') is not None:
            for k in m.get('ProgramTypeAndCounts'):
                temp_model = GetFileTypeStatisticResponseBodyProgramTypeAndCounts()
                self.program_type_and_counts.append(temp_model.from_map(k))
        return self


class GetFileTypeStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFileTypeStatisticResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileTypeStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFileVersionRequest(TeaModel):
    def __init__(
        self,
        file_id: int = None,
        project_id: int = None,
        project_identifier: str = None,
        file_version: int = None,
    ):
        self.file_id = file_id
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.file_version = file_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        return self


class GetFileVersionResponseBodyData(TeaModel):
    def __init__(
        self,
        file_content: str = None,
        is_current_prod: bool = None,
        status: str = None,
        node_content: str = None,
        commit_user: str = None,
        comment: str = None,
        file_property_content: str = None,
        file_name: str = None,
        use_type: str = None,
        change_type: str = None,
        file_version: int = None,
        commit_time: int = None,
        node_id: int = None,
    ):
        self.file_content = file_content
        self.is_current_prod = is_current_prod
        self.status = status
        self.node_content = node_content
        self.commit_user = commit_user
        self.comment = comment
        self.file_property_content = file_property_content
        self.file_name = file_name
        self.use_type = use_type
        self.change_type = change_type
        self.file_version = file_version
        self.commit_time = commit_time
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_content is not None:
            result['FileContent'] = self.file_content
        if self.is_current_prod is not None:
            result['IsCurrentProd'] = self.is_current_prod
        if self.status is not None:
            result['Status'] = self.status
        if self.node_content is not None:
            result['NodeContent'] = self.node_content
        if self.commit_user is not None:
            result['CommitUser'] = self.commit_user
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.file_property_content is not None:
            result['FilePropertyContent'] = self.file_property_content
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.file_version is not None:
            result['FileVersion'] = self.file_version
        if self.commit_time is not None:
            result['CommitTime'] = self.commit_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileContent') is not None:
            self.file_content = m.get('FileContent')
        if m.get('IsCurrentProd') is not None:
            self.is_current_prod = m.get('IsCurrentProd')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('NodeContent') is not None:
            self.node_content = m.get('NodeContent')
        if m.get('CommitUser') is not None:
            self.commit_user = m.get('CommitUser')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('FilePropertyContent') is not None:
            self.file_property_content = m.get('FilePropertyContent')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('FileVersion') is not None:
            self.file_version = m.get('FileVersion')
        if m.get('CommitTime') is not None:
            self.commit_time = m.get('CommitTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetFileVersionResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetFileVersionResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetFileVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFileVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFileVersionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFileVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFolderRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        folder_id: str = None,
        folder_path: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.folder_id = folder_id
        self.folder_path = folder_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        return self


class GetFolderResponseBodyData(TeaModel):
    def __init__(
        self,
        folder_path: str = None,
        folder_id: str = None,
    ):
        self.folder_path = folder_path
        self.folder_id = folder_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.folder_path is not None:
            result['FolderPath'] = self.folder_path
        if self.folder_id is not None:
            result['FolderId'] = self.folder_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FolderPath') is not None:
            self.folder_path = m.get('FolderPath')
        if m.get('FolderId') is not None:
            self.folder_id = m.get('FolderId')
        return self


class GetFolderResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetFolderResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetFolderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetFolderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetFolderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetFolderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        project_env: str = None,
    ):
        self.instance_id = instance_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        status: str = None,
        cyc_time: int = None,
        begin_running_time: int = None,
        finish_time: int = None,
        create_time: int = None,
        dag_id: int = None,
        priority: int = None,
        task_type: str = None,
        param_values: str = None,
        connection: str = None,
        baseline_id: int = None,
        dqc_type: int = None,
        dag_type: str = None,
        business_id: int = None,
        task_rerun_time: int = None,
        modify_time: int = None,
        repeatability: bool = None,
        repeat_interval: int = None,
        instance_id: int = None,
        begin_wait_res_time: int = None,
        related_flow_id: int = None,
        bizdate: int = None,
        node_name: str = None,
        begin_wait_time_time: int = None,
        dqc_description: str = None,
        node_id: int = None,
    ):
        self.status = status
        self.cyc_time = cyc_time
        self.begin_running_time = begin_running_time
        self.finish_time = finish_time
        self.create_time = create_time
        self.dag_id = dag_id
        self.priority = priority
        self.task_type = task_type
        self.param_values = param_values
        self.connection = connection
        self.baseline_id = baseline_id
        self.dqc_type = dqc_type
        self.dag_type = dag_type
        self.business_id = business_id
        self.task_rerun_time = task_rerun_time
        self.modify_time = modify_time
        self.repeatability = repeatability
        self.repeat_interval = repeat_interval
        self.instance_id = instance_id
        self.begin_wait_res_time = begin_wait_res_time
        self.related_flow_id = related_flow_id
        self.bizdate = bizdate
        self.node_name = node_name
        self.begin_wait_time_time = begin_wait_time_time
        self.dqc_description = dqc_description
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.task_rerun_time is not None:
            result['TaskRerunTime'] = self.task_rerun_time
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('TaskRerunTime') is not None:
            self.task_rerun_time = m.get('TaskRerunTime')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetInstanceResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetInstanceResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceConsumeTimeRankRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        bizdate: str = None,
    ):
        self.project_id = project_id
        self.bizdate = bizdate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank(TeaModel):
    def __init__(
        self,
        owner: str = None,
        node_name: str = None,
        bizdate: int = None,
        instance_id: int = None,
        prg_type: int = None,
        node_id: int = None,
        consumed: int = None,
    ):
        self.owner = owner
        self.node_name = node_name
        self.bizdate = bizdate
        self.instance_id = instance_id
        self.prg_type = prg_type
        self.node_id = node_id
        self.consumed = consumed

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.consumed is not None:
            result['Consumed'] = self.consumed
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Consumed') is not None:
            self.consumed = m.get('Consumed')
        return self


class GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank(TeaModel):
    def __init__(
        self,
        update_time: int = None,
        consume_time_rank: List[GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank] = None,
    ):
        self.update_time = update_time
        self.consume_time_rank = consume_time_rank

    def validate(self):
        if self.consume_time_rank:
            for k in self.consume_time_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ConsumeTimeRank'] = []
        if self.consume_time_rank is not None:
            for k in self.consume_time_rank:
                result['ConsumeTimeRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.consume_time_rank = []
        if m.get('ConsumeTimeRank') is not None:
            for k in m.get('ConsumeTimeRank'):
                temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRankConsumeTimeRank()
                self.consume_time_rank.append(temp_model.from_map(k))
        return self


class GetInstanceConsumeTimeRankResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_consume_time_rank: GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank = None,
    ):
        self.request_id = request_id
        self.instance_consume_time_rank = instance_consume_time_rank

    def validate(self):
        if self.instance_consume_time_rank:
            self.instance_consume_time_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_consume_time_rank is not None:
            result['InstanceConsumeTimeRank'] = self.instance_consume_time_rank.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceConsumeTimeRank') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBodyInstanceConsumeTimeRank()
            self.instance_consume_time_rank = temp_model.from_map(m['InstanceConsumeTimeRank'])
        return self


class GetInstanceConsumeTimeRankResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceConsumeTimeRankResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceConsumeTimeRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceCountTrendRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        begin_date: str = None,
        end_date: str = None,
    ):
        self.project_id = project_id
        self.begin_date = begin_date
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetInstanceCountTrendResponseBodyInstanceCounts(TeaModel):
    def __init__(
        self,
        date: int = None,
        count: int = None,
    ):
        self.date = date
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetInstanceCountTrendResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_counts: List[GetInstanceCountTrendResponseBodyInstanceCounts] = None,
    ):
        self.request_id = request_id
        self.instance_counts = instance_counts

    def validate(self):
        if self.instance_counts:
            for k in self.instance_counts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['InstanceCounts'] = []
        if self.instance_counts is not None:
            for k in self.instance_counts:
                result['InstanceCounts'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instance_counts = []
        if m.get('InstanceCounts') is not None:
            for k in m.get('InstanceCounts'):
                temp_model = GetInstanceCountTrendResponseBodyInstanceCounts()
                self.instance_counts.append(temp_model.from_map(k))
        return self


class GetInstanceCountTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceCountTrendResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceCountTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceErrorRankRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank(TeaModel):
    def __init__(
        self,
        owner: str = None,
        node_name: str = None,
        project_id: int = None,
        node_id: int = None,
        count: int = None,
        prg_type: int = None,
    ):
        self.owner = owner
        self.node_name = node_name
        self.project_id = project_id
        self.node_id = node_id
        self.count = count
        self.prg_type = prg_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.count is not None:
            result['Count'] = self.count
        if self.prg_type is not None:
            result['PrgType'] = self.prg_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PrgType') is not None:
            self.prg_type = m.get('PrgType')
        return self


class GetInstanceErrorRankResponseBodyInstanceErrorRank(TeaModel):
    def __init__(
        self,
        update_time: int = None,
        error_rank: List[GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank] = None,
    ):
        self.update_time = update_time
        self.error_rank = error_rank

    def validate(self):
        if self.error_rank:
            for k in self.error_rank:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        result['ErrorRank'] = []
        if self.error_rank is not None:
            for k in self.error_rank:
                result['ErrorRank'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        self.error_rank = []
        if m.get('ErrorRank') is not None:
            for k in m.get('ErrorRank'):
                temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRankErrorRank()
                self.error_rank.append(temp_model.from_map(k))
        return self


class GetInstanceErrorRankResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_error_rank: GetInstanceErrorRankResponseBodyInstanceErrorRank = None,
    ):
        self.request_id = request_id
        self.instance_error_rank = instance_error_rank

    def validate(self):
        if self.instance_error_rank:
            self.instance_error_rank.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_error_rank is not None:
            result['InstanceErrorRank'] = self.instance_error_rank.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceErrorRank') is not None:
            temp_model = GetInstanceErrorRankResponseBodyInstanceErrorRank()
            self.instance_error_rank = temp_model.from_map(m['InstanceErrorRank'])
        return self


class GetInstanceErrorRankResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceErrorRankResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceErrorRankResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceLogRequest(TeaModel):
    def __init__(
        self,
        instance_id: int = None,
        project_env: str = None,
    ):
        self.instance_id = instance_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetInstanceLogResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: str = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusCountRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
        biz_date: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env
        self.biz_date = biz_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        return self


class GetInstanceStatusCountResponseBodyStatusCount(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        wait_time_count: int = None,
        running_count: int = None,
        success_count: int = None,
        total_count: int = None,
        not_run_count: int = None,
        wait_res_count: int = None,
    ):
        self.failure_count = failure_count
        self.wait_time_count = wait_time_count
        self.running_count = running_count
        self.success_count = success_count
        self.total_count = total_count
        self.not_run_count = not_run_count
        self.wait_res_count = wait_res_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        return self


class GetInstanceStatusCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusCountResponseBodyStatusCount = None,
    ):
        self.request_id = request_id
        self.status_count = status_count

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusCountResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceStatusCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceStatusStatisticRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_env: str = None,
        biz_date: str = None,
    ):
        self.project_id = project_id
        self.project_env = project_env
        self.biz_date = biz_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        return self


class GetInstanceStatusStatisticResponseBodyStatusCount(TeaModel):
    def __init__(
        self,
        failure_count: int = None,
        wait_time_count: int = None,
        running_count: int = None,
        success_count: int = None,
        total_count: int = None,
        not_run_count: int = None,
        wait_res_count: int = None,
    ):
        self.failure_count = failure_count
        self.wait_time_count = wait_time_count
        self.running_count = running_count
        self.success_count = success_count
        self.total_count = total_count
        self.not_run_count = not_run_count
        self.wait_res_count = wait_res_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.wait_time_count is not None:
            result['WaitTimeCount'] = self.wait_time_count
        if self.running_count is not None:
            result['RunningCount'] = self.running_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.not_run_count is not None:
            result['NotRunCount'] = self.not_run_count
        if self.wait_res_count is not None:
            result['WaitResCount'] = self.wait_res_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('WaitTimeCount') is not None:
            self.wait_time_count = m.get('WaitTimeCount')
        if m.get('RunningCount') is not None:
            self.running_count = m.get('RunningCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NotRunCount') is not None:
            self.not_run_count = m.get('NotRunCount')
        if m.get('WaitResCount') is not None:
            self.wait_res_count = m.get('WaitResCount')
        return self


class GetInstanceStatusStatisticResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status_count: GetInstanceStatusStatisticResponseBodyStatusCount = None,
    ):
        self.request_id = request_id
        self.status_count = status_count

    def validate(self):
        if self.status_count:
            self.status_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status_count is not None:
            result['StatusCount'] = self.status_count.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StatusCount') is not None:
            temp_model = GetInstanceStatusStatisticResponseBodyStatusCount()
            self.status_count = temp_model.from_map(m['StatusCount'])
        return self


class GetInstanceStatusStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetInstanceStatusStatisticResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetInstanceStatusStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetManualDagInstancesRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        project_name: str = None,
        dag_id: str = None,
    ):
        self.project_env = project_env
        self.project_name = project_name
        self.dag_id = dag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        return self


class GetManualDagInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        status: str = None,
        begin_running_time: int = None,
        biz_date: int = None,
        cyc_time: int = None,
        finish_time: int = None,
        create_time: int = None,
        dag_id: int = None,
        instance_id: int = None,
        begin_wait_res_time: int = None,
        task_type: str = None,
        param_values: str = None,
        dag_type: str = None,
        node_name: str = None,
        begin_wait_time_time: int = None,
        node_id: int = None,
        modify_time: int = None,
    ):
        self.status = status
        self.begin_running_time = begin_running_time
        self.biz_date = biz_date
        self.cyc_time = cyc_time
        self.finish_time = finish_time
        self.create_time = create_time
        self.dag_id = dag_id
        self.instance_id = instance_id
        self.begin_wait_res_time = begin_wait_res_time
        self.task_type = task_type
        self.param_values = param_values
        self.dag_type = dag_type
        self.node_name = node_name
        self.begin_wait_time_time = begin_wait_time_time
        self.node_id = node_id
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.begin_running_time is not None:
            result['BeginRunningTime'] = self.begin_running_time
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.cyc_time is not None:
            result['CycTime'] = self.cyc_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dag_id is not None:
            result['DagId'] = self.dag_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.begin_wait_res_time is not None:
            result['BeginWaitResTime'] = self.begin_wait_res_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.dag_type is not None:
            result['DagType'] = self.dag_type
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.begin_wait_time_time is not None:
            result['BeginWaitTimeTime'] = self.begin_wait_time_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BeginRunningTime') is not None:
            self.begin_running_time = m.get('BeginRunningTime')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('CycTime') is not None:
            self.cyc_time = m.get('CycTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DagId') is not None:
            self.dag_id = m.get('DagId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('BeginWaitResTime') is not None:
            self.begin_wait_res_time = m.get('BeginWaitResTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('DagType') is not None:
            self.dag_type = m.get('DagType')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('BeginWaitTimeTime') is not None:
            self.begin_wait_time_time = m.get('BeginWaitTimeTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetManualDagInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instances: List[GetManualDagInstancesResponseBodyInstances] = None,
    ):
        self.request_id = request_id
        self.instances = instances

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = GetManualDagInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        return self


class GetManualDagInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetManualDagInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetManualDagInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaCategoryRequest(TeaModel):
    def __init__(
        self,
        parent_category_id: int = None,
        page_num: int = None,
        page_size: int = None,
    ):
        self.parent_category_id = parent_category_id
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetMetaCategoryResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        depth: int = None,
        comment: str = None,
        modified_time: int = None,
        create_time: int = None,
        category_id: int = None,
        last_operator_id: str = None,
        name: str = None,
        parent_category_id: int = None,
        owner_id: str = None,
    ):
        self.depth = depth
        self.comment = comment
        self.modified_time = modified_time
        self.create_time = create_time
        self.category_id = category_id
        self.last_operator_id = last_operator_id
        self.name = name
        self.parent_category_id = parent_category_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depth is not None:
            result['Depth'] = self.depth
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.last_operator_id is not None:
            result['LastOperatorId'] = self.last_operator_id
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_category_id is not None:
            result['ParentCategoryId'] = self.parent_category_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Depth') is not None:
            self.depth = m.get('Depth')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('LastOperatorId') is not None:
            self.last_operator_id = m.get('LastOperatorId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentCategoryId') is not None:
            self.parent_category_id = m.get('ParentCategoryId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class GetMetaCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaCategoryResponseBodyDataDataEntityList] = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaCategoryResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaCategoryResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaCategoryResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaColumnLineageRequest(TeaModel):
    def __init__(
        self,
        column_guid: str = None,
        direction: str = None,
        page_num: int = None,
        page_size: int = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        column_name: str = None,
        data_source_type: str = None,
    ):
        self.column_guid = column_guid
        self.direction = direction
        self.page_num = page_num
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.column_name = column_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaColumnLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        column_guid: str = None,
        column_name: str = None,
        table_name: str = None,
        database_name: str = None,
        cluster_id: str = None,
    ):
        self.column_guid = column_guid
        self.column_name = column_name
        self.table_name = table_name
        self.database_name = database_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class GetMetaColumnLineageResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaColumnLineageResponseBodyDataDataEntityList] = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaColumnLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaColumnLineageResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaColumnLineageResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaColumnLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaColumnLineageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaColumnLineageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaColumnLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBInfoRequest(TeaModel):
    def __init__(
        self,
        app_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        data_source_type: str = None,
    ):
        self.app_guid = app_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaDBInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        type: str = None,
        comment: str = None,
        create_time: int = None,
        project_id: int = None,
        project_name: str = None,
        app_guid: str = None,
        owner_name: str = None,
        owner_id: str = None,
        env_type: int = None,
        project_name_cn: str = None,
        endpoint: str = None,
        cluster_biz_id: str = None,
        name: str = None,
        location: str = None,
        tenant_id: int = None,
        modify_time: int = None,
    ):
        self.type = type
        self.comment = comment
        self.create_time = create_time
        self.project_id = project_id
        self.project_name = project_name
        self.app_guid = app_guid
        self.owner_name = owner_name
        self.owner_id = owner_id
        self.env_type = env_type
        self.project_name_cn = project_name_cn
        self.endpoint = endpoint
        self.cluster_biz_id = cluster_biz_id
        self.name = name
        self.location = location
        self.tenant_id = tenant_id
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.project_name_cn is not None:
            result['ProjectNameCn'] = self.project_name_cn
        if self.endpoint is not None:
            result['Endpoint'] = self.endpoint
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.name is not None:
            result['Name'] = self.name
        if self.location is not None:
            result['Location'] = self.location
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ProjectNameCn') is not None:
            self.project_name_cn = m.get('ProjectNameCn')
        if m.get('Endpoint') is not None:
            self.endpoint = m.get('Endpoint')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetMetaDBInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetMetaDBInfoResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMetaDBInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaDBInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaDBInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaDBInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaDBTableListRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        app_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        data_source_type: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.app_guid = app_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.app_guid is not None:
            result['AppGuid'] = self.app_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('AppGuid') is not None:
            self.app_guid = m.get('AppGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaDBTableListResponseBodyDataTableEntityList(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        table_guid: str = None,
        database_name: str = None,
    ):
        self.table_name = table_name
        self.table_guid = table_guid
        self.database_name = database_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        return self


class GetMetaDBTableListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        table_entity_list: List[GetMetaDBTableListResponseBodyDataTableEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.table_entity_list = table_entity_list

    def validate(self):
        if self.table_entity_list:
            for k in self.table_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TableEntityList'] = []
        if self.table_entity_list is not None:
            for k in self.table_entity_list:
                result['TableEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.table_entity_list = []
        if m.get('TableEntityList') is not None:
            for k in m.get('TableEntityList'):
                temp_model = GetMetaDBTableListResponseBodyDataTableEntityList()
                self.table_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaDBTableListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: GetMetaDBTableListResponseBodyData = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetMetaDBTableListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaDBTableListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaDBTableListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaDBTableListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableBasicInfoRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
        extension: bool = None,
    ):
        self.table_guid = table_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type
        self.extension = extension

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class GetMetaTableBasicInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        favorite_count: int = None,
        comment: str = None,
        column_count: int = None,
        create_time: int = None,
        project_id: int = None,
        owner_id: str = None,
        env_type: int = None,
        database_name: str = None,
        is_visible: int = None,
        table_guid: str = None,
        read_count: int = None,
        cluster_id: str = None,
        is_partition_table: bool = None,
        is_view: bool = None,
        life_cycle: int = None,
        project_name: str = None,
        view_count: int = None,
        last_access_time: int = None,
        data_size: int = None,
        last_modify_time: int = None,
        last_ddl_time: int = None,
        partition_keys: str = None,
        location: str = None,
        caption: str = None,
        tenant_id: int = None,
    ):
        self.table_name = table_name
        self.favorite_count = favorite_count
        self.comment = comment
        self.column_count = column_count
        self.create_time = create_time
        self.project_id = project_id
        self.owner_id = owner_id
        self.env_type = env_type
        self.database_name = database_name
        self.is_visible = is_visible
        self.table_guid = table_guid
        self.read_count = read_count
        self.cluster_id = cluster_id
        self.is_partition_table = is_partition_table
        self.is_view = is_view
        self.life_cycle = life_cycle
        self.project_name = project_name
        self.view_count = view_count
        self.last_access_time = last_access_time
        self.data_size = data_size
        self.last_modify_time = last_modify_time
        self.last_ddl_time = last_ddl_time
        self.partition_keys = partition_keys
        self.location = location
        self.caption = caption
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.favorite_count is not None:
            result['FavoriteCount'] = self.favorite_count
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_count is not None:
            result['ColumnCount'] = self.column_count
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.read_count is not None:
            result['ReadCount'] = self.read_count
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.is_partition_table is not None:
            result['IsPartitionTable'] = self.is_partition_table
        if self.is_view is not None:
            result['IsView'] = self.is_view
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.view_count is not None:
            result['ViewCount'] = self.view_count
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.location is not None:
            result['Location'] = self.location
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('FavoriteCount') is not None:
            self.favorite_count = m.get('FavoriteCount')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnCount') is not None:
            self.column_count = m.get('ColumnCount')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ReadCount') is not None:
            self.read_count = m.get('ReadCount')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('IsPartitionTable') is not None:
            self.is_partition_table = m.get('IsPartitionTable')
        if m.get('IsView') is not None:
            self.is_view = m.get('IsView')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ViewCount') is not None:
            self.view_count = m.get('ViewCount')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetMetaTableBasicInfoResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableBasicInfoResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableBasicInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableBasicInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableBasicInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableChangeLogRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        change_type: str = None,
        object_type: str = None,
        start_date: str = None,
        end_date: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.change_type = change_type
        self.object_type = object_type
        self.start_date = start_date
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetMetaTableChangeLogResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        object_type: str = None,
        modified_time: int = None,
        create_time: int = None,
        change_content: str = None,
        operator: str = None,
        change_type: str = None,
    ):
        self.object_type = object_type
        self.modified_time = modified_time
        self.create_time = create_time
        self.change_content = change_content
        self.operator = operator
        self.change_type = change_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.change_content is not None:
            result['ChangeContent'] = self.change_content
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChangeContent') is not None:
            self.change_content = m.get('ChangeContent')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        return self


class GetMetaTableChangeLogResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaTableChangeLogResponseBodyDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableChangeLogResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableChangeLogResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableChangeLogResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableChangeLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableChangeLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableChangeLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableChangeLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableColumnRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        page_num: int = None,
        page_size: int = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.page_num = page_num
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableColumnResponseBodyDataColumnList(TeaModel):
    def __init__(
        self,
        column_guid: str = None,
        column_name: str = None,
        is_partition_column: bool = None,
        comment: str = None,
        column_type: str = None,
        is_primary_key: bool = None,
        position: int = None,
        caption: str = None,
        is_foreign_key: bool = None,
    ):
        self.column_guid = column_guid
        self.column_name = column_name
        self.is_partition_column = is_partition_column
        self.comment = comment
        self.column_type = column_type
        self.is_primary_key = is_primary_key
        self.position = position
        self.caption = caption
        self.is_foreign_key = is_foreign_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        return self


class GetMetaTableColumnResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        column_list: List[GetMetaTableColumnResponseBodyDataColumnList] = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count
        self.column_list = column_list

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableColumnResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        return self


class GetMetaTableColumnResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableColumnResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableColumnResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableColumnResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableColumnResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableColumnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableFullInfoRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        page_num: int = None,
        page_size: int = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.page_num = page_num
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableFullInfoResponseBodyDataColumnList(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_guid: str = None,
        is_partition_column: bool = None,
        comment: str = None,
        column_type: str = None,
        is_primary_key: bool = None,
        position: int = None,
        caption: str = None,
        is_foreign_key: bool = None,
    ):
        self.column_name = column_name
        self.column_guid = column_guid
        self.is_partition_column = is_partition_column
        self.comment = comment
        self.column_type = column_type
        self.is_primary_key = is_primary_key
        self.position = position
        self.caption = caption
        self.is_foreign_key = is_foreign_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_guid is not None:
            result['ColumnGuid'] = self.column_guid
        if self.is_partition_column is not None:
            result['IsPartitionColumn'] = self.is_partition_column
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.is_primary_key is not None:
            result['IsPrimaryKey'] = self.is_primary_key
        if self.position is not None:
            result['Position'] = self.position
        if self.caption is not None:
            result['Caption'] = self.caption
        if self.is_foreign_key is not None:
            result['IsForeignKey'] = self.is_foreign_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnGuid') is not None:
            self.column_guid = m.get('ColumnGuid')
        if m.get('IsPartitionColumn') is not None:
            self.is_partition_column = m.get('IsPartitionColumn')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('IsPrimaryKey') is not None:
            self.is_primary_key = m.get('IsPrimaryKey')
        if m.get('Position') is not None:
            self.position = m.get('Position')
        if m.get('Caption') is not None:
            self.caption = m.get('Caption')
        if m.get('IsForeignKey') is not None:
            self.is_foreign_key = m.get('IsForeignKey')
        return self


class GetMetaTableFullInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        comment: str = None,
        life_cycle: int = None,
        create_time: int = None,
        project_name: str = None,
        project_id: int = None,
        owner_id: str = None,
        env_type: int = None,
        last_access_time: int = None,
        data_size: int = None,
        last_modify_time: int = None,
        database_name: str = None,
        is_visible: int = None,
        total_column_count: int = None,
        table_guid: str = None,
        partition_keys: str = None,
        last_ddl_time: int = None,
        location: str = None,
        cluster_id: str = None,
        tenant_id: int = None,
        column_list: List[GetMetaTableFullInfoResponseBodyDataColumnList] = None,
    ):
        self.table_name = table_name
        self.comment = comment
        self.life_cycle = life_cycle
        self.create_time = create_time
        self.project_name = project_name
        self.project_id = project_id
        self.owner_id = owner_id
        self.env_type = env_type
        self.last_access_time = last_access_time
        self.data_size = data_size
        self.last_modify_time = last_modify_time
        self.database_name = database_name
        self.is_visible = is_visible
        self.total_column_count = total_column_count
        self.table_guid = table_guid
        self.partition_keys = partition_keys
        self.last_ddl_time = last_ddl_time
        self.location = location
        self.cluster_id = cluster_id
        self.tenant_id = tenant_id
        self.column_list = column_list

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.life_cycle is not None:
            result['LifeCycle'] = self.life_cycle
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.last_access_time is not None:
            result['LastAccessTime'] = self.last_access_time
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.last_modify_time is not None:
            result['LastModifyTime'] = self.last_modify_time
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.is_visible is not None:
            result['IsVisible'] = self.is_visible
        if self.total_column_count is not None:
            result['TotalColumnCount'] = self.total_column_count
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.partition_keys is not None:
            result['PartitionKeys'] = self.partition_keys
        if self.last_ddl_time is not None:
            result['LastDdlTime'] = self.last_ddl_time
        if self.location is not None:
            result['Location'] = self.location
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('LifeCycle') is not None:
            self.life_cycle = m.get('LifeCycle')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('LastAccessTime') is not None:
            self.last_access_time = m.get('LastAccessTime')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('LastModifyTime') is not None:
            self.last_modify_time = m.get('LastModifyTime')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('IsVisible') is not None:
            self.is_visible = m.get('IsVisible')
        if m.get('TotalColumnCount') is not None:
            self.total_column_count = m.get('TotalColumnCount')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('PartitionKeys') is not None:
            self.partition_keys = m.get('PartitionKeys')
        if m.get('LastDdlTime') is not None:
            self.last_ddl_time = m.get('LastDdlTime')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = GetMetaTableFullInfoResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        return self


class GetMetaTableFullInfoResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableFullInfoResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableFullInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableFullInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableFullInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableFullInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableIntroWikiRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        wiki_version: int = None,
    ):
        self.table_guid = table_guid
        self.wiki_version = wiki_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.wiki_version is not None:
            result['WikiVersion'] = self.wiki_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('WikiVersion') is not None:
            self.wiki_version = m.get('WikiVersion')
        return self


class GetMetaTableIntroWikiResponseBodyData(TeaModel):
    def __init__(
        self,
        modified_time: int = None,
        version: int = None,
        create_time: int = None,
        creator_name: str = None,
        content: str = None,
        creator: str = None,
    ):
        self.modified_time = modified_time
        self.version = version
        self.create_time = create_time
        self.creator_name = creator_name
        self.content = content
        self.creator = creator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.version is not None:
            result['Version'] = self.version
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.creator_name is not None:
            result['CreatorName'] = self.creator_name
        if self.content is not None:
            result['Content'] = self.content
        if self.creator is not None:
            result['Creator'] = self.creator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreatorName') is not None:
            self.creator_name = m.get('CreatorName')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        return self


class GetMetaTableIntroWikiResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableIntroWikiResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableIntroWikiResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableIntroWikiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableIntroWikiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableIntroWikiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableLineageRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        direction: str = None,
        next_primary_key: str = None,
        page_size: int = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.direction = direction
        self.next_primary_key = next_primary_key
        self.page_size = page_size
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableLineageResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        table_guid: str = None,
    ):
        self.table_name = table_name
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTableLineageResponseBodyData(TeaModel):
    def __init__(
        self,
        next_primary_key: str = None,
        has_next: bool = None,
        data_entity_list: List[GetMetaTableLineageResponseBodyDataDataEntityList] = None,
    ):
        self.next_primary_key = next_primary_key
        self.has_next = has_next
        self.data_entity_list = data_entity_list

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_primary_key is not None:
            result['NextPrimaryKey'] = self.next_primary_key
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextPrimaryKey') is not None:
            self.next_primary_key = m.get('NextPrimaryKey')
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableLineageResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableLineageResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableLineageResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableLineageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableLineageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableLineageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableLineageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableListByCategoryRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        category_id: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class GetMetaTableListByCategoryResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        table_guid_list: List[str] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.table_guid_list = table_guid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.table_guid_list is not None:
            result['TableGuidList'] = self.table_guid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TableGuidList') is not None:
            self.table_guid_list = m.get('TableGuidList')
        return self


class GetMetaTableListByCategoryResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableListByCategoryResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableListByCategoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableListByCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableListByCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableListByCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableOutputRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        start_date: str = None,
        end_date: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.start_date = start_date
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        return self


class GetMetaTableOutputResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        task_instance_id: int = None,
        start_time: str = None,
        project_id: int = None,
        wait_time: str = None,
        table_guid: str = None,
        task_id: str = None,
    ):
        self.end_time = end_time
        self.task_instance_id = task_instance_id
        self.start_time = start_time
        self.project_id = project_id
        self.wait_time = wait_time
        self.table_guid = table_guid
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.task_instance_id is not None:
            result['TaskInstanceId'] = self.task_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.wait_time is not None:
            result['WaitTime'] = self.wait_time
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TaskInstanceId') is not None:
            self.task_instance_id = m.get('TaskInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('WaitTime') is not None:
            self.wait_time = m.get('WaitTime')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetMetaTableOutputResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaTableOutputResponseBodyDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTableOutputResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTableOutputResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTableOutputResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTableOutputResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTableOutputResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableOutputResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableOutputResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTablePartitionRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        table_guid: str = None,
        cluster_id: str = None,
        database_name: str = None,
        table_name: str = None,
        data_source_type: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.table_guid = table_guid
        self.cluster_id = cluster_id
        self.database_name = database_name
        self.table_name = table_name
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTablePartitionResponseBodyDataDataEntityList(TeaModel):
    def __init__(
        self,
        partition_path: str = None,
        data_size: int = None,
        partition_name: str = None,
        comment: str = None,
        modified_time: int = None,
        create_time: int = None,
        record_count: int = None,
        partition_type: str = None,
        partition_guid: str = None,
        partition_location: str = None,
        table_guid: str = None,
    ):
        self.partition_path = partition_path
        self.data_size = data_size
        self.partition_name = partition_name
        self.comment = comment
        self.modified_time = modified_time
        self.create_time = create_time
        self.record_count = record_count
        self.partition_type = partition_type
        self.partition_guid = partition_guid
        self.partition_location = partition_location
        self.table_guid = table_guid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.partition_path is not None:
            result['PartitionPath'] = self.partition_path
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.partition_name is not None:
            result['PartitionName'] = self.partition_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.partition_type is not None:
            result['PartitionType'] = self.partition_type
        if self.partition_guid is not None:
            result['PartitionGuid'] = self.partition_guid
        if self.partition_location is not None:
            result['PartitionLocation'] = self.partition_location
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PartitionPath') is not None:
            self.partition_path = m.get('PartitionPath')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('PartitionName') is not None:
            self.partition_name = m.get('PartitionName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('PartitionType') is not None:
            self.partition_type = m.get('PartitionType')
        if m.get('PartitionGuid') is not None:
            self.partition_guid = m.get('PartitionGuid')
        if m.get('PartitionLocation') is not None:
            self.partition_location = m.get('PartitionLocation')
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        return self


class GetMetaTablePartitionResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        data_entity_list: List[GetMetaTablePartitionResponseBodyDataDataEntityList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.data_entity_list = data_entity_list

    def validate(self):
        if self.data_entity_list:
            for k in self.data_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['DataEntityList'] = []
        if self.data_entity_list is not None:
            for k in self.data_entity_list:
                result['DataEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data_entity_list = []
        if m.get('DataEntityList') is not None:
            for k in m.get('DataEntityList'):
                temp_model = GetMetaTablePartitionResponseBodyDataDataEntityList()
                self.data_entity_list.append(temp_model.from_map(k))
        return self


class GetMetaTablePartitionResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        data: GetMetaTablePartitionResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = GetMetaTablePartitionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetMetaTablePartitionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTablePartitionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTablePartitionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMetaTableThemeLevelRequest(TeaModel):
    def __init__(
        self,
        table_guid: str = None,
        data_source_type: str = None,
    ):
        self.table_guid = table_guid
        self.data_source_type = data_source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_guid is not None:
            result['TableGuid'] = self.table_guid
        if self.data_source_type is not None:
            result['DataSourceType'] = self.data_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableGuid') is not None:
            self.table_guid = m.get('TableGuid')
        if m.get('DataSourceType') is not None:
            self.data_source_type = m.get('DataSourceType')
        return self


class GetMetaTableThemeLevelResponseBodyEntityTheme(TeaModel):
    def __init__(
        self,
        parent_id: int = None,
        name: str = None,
        theme_id: int = None,
        level: int = None,
    ):
        self.parent_id = parent_id
        self.name = name
        self.theme_id = theme_id
        self.level = level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.name is not None:
            result['Name'] = self.name
        if self.theme_id is not None:
            result['ThemeId'] = self.theme_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ThemeId') is not None:
            self.theme_id = m.get('ThemeId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class GetMetaTableThemeLevelResponseBodyEntityLevel(TeaModel):
    def __init__(
        self,
        type: int = None,
        description: str = None,
        name: str = None,
        level_id: int = None,
    ):
        self.type = type
        self.description = description
        self.name = name
        self.level_id = level_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.level_id is not None:
            result['LevelId'] = self.level_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LevelId') is not None:
            self.level_id = m.get('LevelId')
        return self


class GetMetaTableThemeLevelResponseBodyEntity(TeaModel):
    def __init__(
        self,
        theme: List[GetMetaTableThemeLevelResponseBodyEntityTheme] = None,
        level: List[GetMetaTableThemeLevelResponseBodyEntityLevel] = None,
    ):
        self.theme = theme
        self.level = level

    def validate(self):
        if self.theme:
            for k in self.theme:
                if k:
                    k.validate()
        if self.level:
            for k in self.level:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Theme'] = []
        if self.theme is not None:
            for k in self.theme:
                result['Theme'].append(k.to_map() if k else None)
        result['Level'] = []
        if self.level is not None:
            for k in self.level:
                result['Level'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.theme = []
        if m.get('Theme') is not None:
            for k in m.get('Theme'):
                temp_model = GetMetaTableThemeLevelResponseBodyEntityTheme()
                self.theme.append(temp_model.from_map(k))
        self.level = []
        if m.get('Level') is not None:
            for k in m.get('Level'):
                temp_model = GetMetaTableThemeLevelResponseBodyEntityLevel()
                self.level.append(temp_model.from_map(k))
        return self


class GetMetaTableThemeLevelResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
        entity: GetMetaTableThemeLevelResponseBodyEntity = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code
        self.entity = entity

    def validate(self):
        if self.entity:
            self.entity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.entity is not None:
            result['Entity'] = self.entity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Entity') is not None:
            temp_model = GetMetaTableThemeLevelResponseBodyEntity()
            self.entity = temp_model.from_map(m['Entity'])
        return self


class GetMetaTableThemeLevelResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMetaTableThemeLevelResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMetaTableThemeLevelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMigrationProcessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        migration_id: int = None,
    ):
        self.project_id = project_id
        self.migration_id = migration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.migration_id is not None:
            result['MigrationId'] = self.migration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('MigrationId') is not None:
            self.migration_id = m.get('MigrationId')
        return self


class GetMigrationProcessResponseBodyData(TeaModel):
    def __init__(
        self,
        task_status: str = None,
        task_name: str = None,
    ):
        self.task_status = task_status
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class GetMigrationProcessResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: List[GetMigrationProcessResponseBodyData] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetMigrationProcessResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetMigrationProcessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetMigrationProcessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetMigrationProcessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeResponseBodyData(TeaModel):
    def __init__(
        self,
        scheduler_type: str = None,
        repeat_interval: int = None,
        repeatability: str = None,
        project_id: int = None,
        program_type: str = None,
        priority: int = None,
        owner_id: str = None,
        connection: str = None,
        param_values: str = None,
        related_flow_id: int = None,
        dqc_type: int = None,
        baseline_id: int = None,
        description: str = None,
        node_name: str = None,
        res_group_name: str = None,
        business_id: int = None,
        dqc_description: str = None,
        cron_express: str = None,
        node_id: int = None,
    ):
        self.scheduler_type = scheduler_type
        self.repeat_interval = repeat_interval
        self.repeatability = repeatability
        self.project_id = project_id
        self.program_type = program_type
        self.priority = priority
        self.owner_id = owner_id
        self.connection = connection
        self.param_values = param_values
        self.related_flow_id = related_flow_id
        self.dqc_type = dqc_type
        self.baseline_id = baseline_id
        self.description = description
        self.node_name = node_name
        self.res_group_name = res_group_name
        self.business_id = business_id
        self.dqc_description = dqc_description
        self.cron_express = cron_express
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.repeat_interval is not None:
            result['RepeatInterval'] = self.repeat_interval
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.connection is not None:
            result['Connection'] = self.connection
        if self.param_values is not None:
            result['ParamValues'] = self.param_values
        if self.related_flow_id is not None:
            result['RelatedFlowId'] = self.related_flow_id
        if self.dqc_type is not None:
            result['DqcType'] = self.dqc_type
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.description is not None:
            result['Description'] = self.description
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.res_group_name is not None:
            result['ResGroupName'] = self.res_group_name
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.dqc_description is not None:
            result['DqcDescription'] = self.dqc_description
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('RepeatInterval') is not None:
            self.repeat_interval = m.get('RepeatInterval')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Connection') is not None:
            self.connection = m.get('Connection')
        if m.get('ParamValues') is not None:
            self.param_values = m.get('ParamValues')
        if m.get('RelatedFlowId') is not None:
            self.related_flow_id = m.get('RelatedFlowId')
        if m.get('DqcType') is not None:
            self.dqc_type = m.get('DqcType')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ResGroupName') is not None:
            self.res_group_name = m.get('ResGroupName')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('DqcDescription') is not None:
            self.dqc_description = m.get('DqcDescription')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetNodeResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetNodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeChildrenRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        node_id: int = None,
    ):
        self.project_env = project_env
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeChildrenResponseBodyDataNodes(TeaModel):
    def __init__(
        self,
        scheduler_type: str = None,
        baseline_id: int = None,
        repeatability: bool = None,
        node_name: str = None,
        project_id: int = None,
        program_type: str = None,
        priority: int = None,
        owner_id: str = None,
        cron_express: str = None,
        node_id: int = None,
    ):
        self.scheduler_type = scheduler_type
        self.baseline_id = baseline_id
        self.repeatability = repeatability
        self.node_name = node_name
        self.project_id = project_id
        self.program_type = program_type
        self.priority = priority
        self.owner_id = owner_id
        self.cron_express = cron_express
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeChildrenResponseBodyData(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodeChildrenResponseBodyDataNodes] = None,
    ):
        self.nodes = nodes

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeChildrenResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeChildrenResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetNodeChildrenResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetNodeChildrenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeChildrenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeChildrenResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeChildrenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeCodeRequest(TeaModel):
    def __init__(
        self,
        node_id: int = None,
        project_env: str = None,
    ):
        self.node_id = node_id
        self.project_env = project_env

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        return self


class GetNodeCodeResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        data: str = None,
        error_message: str = None,
        request_id: str = None,
        success: bool = None,
        error_code: str = None,
    ):
        self.http_status_code = http_status_code
        self.data = data
        self.error_message = error_message
        self.request_id = request_id
        self.success = success
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class GetNodeCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeCodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeOnBaselineRequest(TeaModel):
    def __init__(
        self,
        baseline_id: int = None,
    ):
        self.baseline_id = baseline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetNodeOnBaselineResponseBodyData(TeaModel):
    def __init__(
        self,
        owner: str = None,
        node_name: str = None,
        node_id: int = None,
        project_id: int = None,
    ):
        self.owner = owner
        self.node_name = node_name
        self.node_id = node_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetNodeOnBaselineResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: str = None,
        data: List[GetNodeOnBaselineResponseBodyData] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetNodeOnBaselineResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetNodeOnBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeOnBaselineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeOnBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeParentsRequest(TeaModel):
    def __init__(
        self,
        project_env: str = None,
        node_id: int = None,
    ):
        self.project_env = project_env
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_env is not None:
            result['ProjectEnv'] = self.project_env
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectEnv') is not None:
            self.project_env = m.get('ProjectEnv')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeParentsResponseBodyDataNodes(TeaModel):
    def __init__(
        self,
        scheduler_type: str = None,
        baseline_id: int = None,
        repeatability: bool = None,
        node_name: str = None,
        project_id: int = None,
        program_type: str = None,
        priority: int = None,
        owner_id: str = None,
        cron_express: str = None,
        node_id: int = None,
    ):
        self.scheduler_type = scheduler_type
        self.baseline_id = baseline_id
        self.repeatability = repeatability
        self.node_name = node_name
        self.project_id = project_id
        self.program_type = program_type
        self.priority = priority
        self.owner_id = owner_id
        self.cron_express = cron_express
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scheduler_type is not None:
            result['SchedulerType'] = self.scheduler_type
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.repeatability is not None:
            result['Repeatability'] = self.repeatability
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.program_type is not None:
            result['ProgramType'] = self.program_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.cron_express is not None:
            result['CronExpress'] = self.cron_express
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SchedulerType') is not None:
            self.scheduler_type = m.get('SchedulerType')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Repeatability') is not None:
            self.repeatability = m.get('Repeatability')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProgramType') is not None:
            self.program_type = m.get('ProgramType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('CronExpress') is not None:
            self.cron_express = m.get('CronExpress')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetNodeParentsResponseBodyData(TeaModel):
    def __init__(
        self,
        nodes: List[GetNodeParentsResponseBodyDataNodes] = None,
    ):
        self.nodes = nodes

    def validate(self):
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetNodeParentsResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        return self


class GetNodeParentsResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetNodeParentsResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetNodeParentsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetNodeParentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeParentsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeParentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodeTypeListInfoRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        page_number: int = None,
        page_size: int = None,
        keyword: str = None,
        locale: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.page_number = page_number
        self.page_size = page_size
        self.keyword = keyword
        self.locale = locale

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.locale is not None:
            result['Locale'] = self.locale
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        return self


class GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo(TeaModel):
    def __init__(
        self,
        node_type_name: str = None,
        node_type: int = None,
    ):
        self.node_type_name = node_type_name
        self.node_type = node_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_type_name is not None:
            result['NodeTypeName'] = self.node_type_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeTypeName') is not None:
            self.node_type_name = m.get('NodeTypeName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class GetNodeTypeListInfoResponseBodyNodeTypeInfoList(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        node_type_info: List[GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.node_type_info = node_type_info

    def validate(self):
        if self.node_type_info:
            for k in self.node_type_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['NodeTypeInfo'] = []
        if self.node_type_info is not None:
            for k in self.node_type_info:
                result['NodeTypeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.node_type_info = []
        if m.get('NodeTypeInfo') is not None:
            for k in m.get('NodeTypeInfo'):
                temp_model = GetNodeTypeListInfoResponseBodyNodeTypeInfoListNodeTypeInfo()
                self.node_type_info.append(temp_model.from_map(k))
        return self


class GetNodeTypeListInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        node_type_info_list: GetNodeTypeListInfoResponseBodyNodeTypeInfoList = None,
    ):
        self.request_id = request_id
        self.node_type_info_list = node_type_info_list

    def validate(self):
        if self.node_type_info_list:
            self.node_type_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.node_type_info_list is not None:
            result['NodeTypeInfoList'] = self.node_type_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('NodeTypeInfoList') is not None:
            temp_model = GetNodeTypeListInfoResponseBodyNodeTypeInfoList()
            self.node_type_info_list = temp_model.from_map(m['NodeTypeInfoList'])
        return self


class GetNodeTypeListInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetNodeTypeListInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodeTypeListInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpRiskDataRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_no: int = None,
        name: str = None,
        date: str = None,
        risk_type: str = None,
    ):
        self.page_size = page_size
        self.page_no = page_no
        self.name = name
        self.date = date
        self.risk_type = risk_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.name is not None:
            result['Name'] = self.name
        if self.date is not None:
            result['Date'] = self.date
        if self.risk_type is not None:
            result['RiskType'] = self.risk_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('RiskType') is not None:
            self.risk_type = m.get('RiskType')
        return self


class GetOpRiskDataResponseBody(TeaModel):
    def __init__(
        self,
        risk_data: str = None,
        request_id: str = None,
    ):
        self.risk_data = risk_data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_data is not None:
            result['RiskData'] = self.risk_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RiskData') is not None:
            self.risk_data = m.get('RiskData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOpRiskDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOpRiskDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOpRiskDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOpSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        page_size: int = None,
        page_no: int = None,
        date: str = None,
        op_type: str = None,
    ):
        self.name = name
        self.page_size = page_size
        self.page_no = page_no
        self.date = date
        self.op_type = op_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.date is not None:
            result['Date'] = self.date
        if self.op_type is not None:
            result['OpType'] = self.op_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('OpType') is not None:
            self.op_type = m.get('OpType')
        return self


class GetOpSensitiveDataResponseBody(TeaModel):
    def __init__(
        self,
        op_sensitive_data: str = None,
        request_id: str = None,
    ):
        self.op_sensitive_data = op_sensitive_data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.op_sensitive_data is not None:
            result['OpSensitiveData'] = self.op_sensitive_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpSensitiveData') is not None:
            self.op_sensitive_data = m.get('OpSensitiveData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetOpSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetOpSensitiveDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetOpSensitiveDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPermissionApplyOrderDetailRequest(TeaModel):
    def __init__(
        self,
        flow_id: str = None,
    ):
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList(TeaModel):
    def __init__(
        self,
        base_id: str = None,
    ):
        self.base_id = base_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_id is not None:
            result['BaseId'] = self.base_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaseId') is not None:
            self.base_id = m.get('BaseId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList(TeaModel):
    def __init__(
        self,
        grantee_type: int = None,
        grantee_type_sub: int = None,
        grantee_name: str = None,
        grantee_id: str = None,
    ):
        self.grantee_type = grantee_type
        self.grantee_type_sub = grantee_type_sub
        self.grantee_name = grantee_name
        self.grantee_id = grantee_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grantee_type is not None:
            result['GranteeType'] = self.grantee_type
        if self.grantee_type_sub is not None:
            result['GranteeTypeSub'] = self.grantee_type_sub
        if self.grantee_name is not None:
            result['GranteeName'] = self.grantee_name
        if self.grantee_id is not None:
            result['GranteeId'] = self.grantee_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GranteeType') is not None:
            self.grantee_type = m.get('GranteeType')
        if m.get('GranteeTypeSub') is not None:
            self.grantee_type_sub = m.get('GranteeTypeSub')
        if m.get('GranteeName') is not None:
            self.grantee_name = m.get('GranteeName')
        if m.get('GranteeId') is not None:
            self.grantee_id = m.get('GranteeId')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        column_comment: str = None,
    ):
        self.column_name = column_name
        self.column_comment = column_comment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_comment is not None:
            result['ColumnComment'] = self.column_comment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnComment') is not None:
            self.column_comment = m.get('ColumnComment')
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList(TeaModel):
    def __init__(
        self,
        object_name: str = None,
        column_meta_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList] = None,
    ):
        self.object_name = object_name
        self.column_meta_list = column_meta_list

    def validate(self):
        if self.column_meta_list:
            for k in self.column_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        result['ColumnMetaList'] = []
        if self.column_meta_list is not None:
            for k in self.column_meta_list:
                result['ColumnMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        self.column_meta_list = []
        if m.get('ColumnMetaList') is not None:
            for k in m.get('ColumnMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaListColumnMetaList()
                self.column_meta_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta(TeaModel):
    def __init__(
        self,
        max_compute_project_name: str = None,
        workspace_id: int = None,
        object_meta_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList] = None,
    ):
        self.max_compute_project_name = max_compute_project_name
        self.workspace_id = workspace_id
        self.object_meta_list = object_meta_list

    def validate(self):
        if self.object_meta_list:
            for k in self.object_meta_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_compute_project_name is not None:
            result['MaxComputeProjectName'] = self.max_compute_project_name
        if self.workspace_id is not None:
            result['WorkspaceId'] = self.workspace_id
        result['ObjectMetaList'] = []
        if self.object_meta_list is not None:
            for k in self.object_meta_list:
                result['ObjectMetaList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxComputeProjectName') is not None:
            self.max_compute_project_name = m.get('MaxComputeProjectName')
        if m.get('WorkspaceId') is not None:
            self.workspace_id = m.get('WorkspaceId')
        self.object_meta_list = []
        if m.get('ObjectMetaList') is not None:
            for k in m.get('ObjectMetaList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMetaObjectMetaList()
                self.object_meta_list.append(temp_model.from_map(k))
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent(TeaModel):
    def __init__(
        self,
        apply_reason: str = None,
        deadline: int = None,
        order_type: int = None,
        project_meta: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta = None,
    ):
        self.apply_reason = apply_reason
        self.deadline = deadline
        self.order_type = order_type
        self.project_meta = project_meta

    def validate(self):
        if self.project_meta:
            self.project_meta.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_reason is not None:
            result['ApplyReason'] = self.apply_reason
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.project_meta is not None:
            result['ProjectMeta'] = self.project_meta.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyReason') is not None:
            self.apply_reason = m.get('ApplyReason')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('ProjectMeta') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContentProjectMeta()
            self.project_meta = temp_model.from_map(m['ProjectMeta'])
        return self


class GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail(TeaModel):
    def __init__(
        self,
        apply_base_id: str = None,
        apply_timestamp: int = None,
        flow_id: str = None,
        flow_status: int = None,
        approve_account_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList] = None,
        grantee_object_list: List[GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList] = None,
        approve_content: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent = None,
    ):
        self.apply_base_id = apply_base_id
        self.apply_timestamp = apply_timestamp
        self.flow_id = flow_id
        self.flow_status = flow_status
        self.approve_account_list = approve_account_list
        self.grantee_object_list = grantee_object_list
        self.approve_content = approve_content

    def validate(self):
        if self.approve_account_list:
            for k in self.approve_account_list:
                if k:
                    k.validate()
        if self.grantee_object_list:
            for k in self.grantee_object_list:
                if k:
                    k.validate()
        if self.approve_content:
            self.approve_content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_base_id is not None:
            result['ApplyBaseId'] = self.apply_base_id
        if self.apply_timestamp is not None:
            result['ApplyTimestamp'] = self.apply_timestamp
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_status is not None:
            result['FlowStatus'] = self.flow_status
        result['ApproveAccountList'] = []
        if self.approve_account_list is not None:
            for k in self.approve_account_list:
                result['ApproveAccountList'].append(k.to_map() if k else None)
        result['GranteeObjectList'] = []
        if self.grantee_object_list is not None:
            for k in self.grantee_object_list:
                result['GranteeObjectList'].append(k.to_map() if k else None)
        if self.approve_content is not None:
            result['ApproveContent'] = self.approve_content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplyBaseId') is not None:
            self.apply_base_id = m.get('ApplyBaseId')
        if m.get('ApplyTimestamp') is not None:
            self.apply_timestamp = m.get('ApplyTimestamp')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowStatus') is not None:
            self.flow_status = m.get('FlowStatus')
        self.approve_account_list = []
        if m.get('ApproveAccountList') is not None:
            for k in m.get('ApproveAccountList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveAccountList()
                self.approve_account_list.append(temp_model.from_map(k))
        self.grantee_object_list = []
        if m.get('GranteeObjectList') is not None:
            for k in m.get('GranteeObjectList'):
                temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailGranteeObjectList()
                self.grantee_object_list.append(temp_model.from_map(k))
        if m.get('ApproveContent') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetailApproveContent()
            self.approve_content = temp_model.from_map(m['ApproveContent'])
        return self


class GetPermissionApplyOrderDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        apply_order_detail: GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail = None,
    ):
        self.request_id = request_id
        self.apply_order_detail = apply_order_detail

    def validate(self):
        if self.apply_order_detail:
            self.apply_order_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.apply_order_detail is not None:
            result['ApplyOrderDetail'] = self.apply_order_detail.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ApplyOrderDetail') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBodyApplyOrderDetail()
            self.apply_order_detail = temp_model.from_map(m['ApplyOrderDetail'])
        return self


class GetPermissionApplyOrderDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetPermissionApplyOrderDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetPermissionApplyOrderDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectResponseBodyData(TeaModel):
    def __init__(
        self,
        status: int = None,
        max_flow_node: int = None,
        project_id: int = None,
        is_allow_download: int = None,
        project_mode: int = None,
        gmt_modified: str = None,
        prod_storage_quota: str = None,
        project_description: str = None,
        development_type: int = None,
        table_privacy_mode: int = None,
        default_di_resource_group_identifier: str = None,
        scheduler_max_retry_times: int = None,
        protected_mode: int = None,
        scheduler_retry_interval: int = None,
        appkey: str = None,
        dev_storage_quota: str = None,
        resident_area: str = None,
        is_default: int = None,
        destination: int = None,
        project_name: str = None,
        project_identifier: str = None,
        disable_development: bool = None,
        project_owner_base_id: str = None,
        base_project: bool = None,
        use_proxy_odps_account: bool = None,
        gmt_create: str = None,
        tenant_id: int = None,
        env_types: List[str] = None,
    ):
        self.status = status
        self.max_flow_node = max_flow_node
        self.project_id = project_id
        self.is_allow_download = is_allow_download
        self.project_mode = project_mode
        self.gmt_modified = gmt_modified
        self.prod_storage_quota = prod_storage_quota
        self.project_description = project_description
        self.development_type = development_type
        self.table_privacy_mode = table_privacy_mode
        self.default_di_resource_group_identifier = default_di_resource_group_identifier
        self.scheduler_max_retry_times = scheduler_max_retry_times
        self.protected_mode = protected_mode
        self.scheduler_retry_interval = scheduler_retry_interval
        self.appkey = appkey
        self.dev_storage_quota = dev_storage_quota
        self.resident_area = resident_area
        self.is_default = is_default
        self.destination = destination
        self.project_name = project_name
        self.project_identifier = project_identifier
        self.disable_development = disable_development
        self.project_owner_base_id = project_owner_base_id
        self.base_project = base_project
        self.use_proxy_odps_account = use_proxy_odps_account
        self.gmt_create = gmt_create
        self.tenant_id = tenant_id
        self.env_types = env_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.max_flow_node is not None:
            result['MaxFlowNode'] = self.max_flow_node
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.prod_storage_quota is not None:
            result['ProdStorageQuota'] = self.prod_storage_quota
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.table_privacy_mode is not None:
            result['TablePrivacyMode'] = self.table_privacy_mode
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.appkey is not None:
            result['Appkey'] = self.appkey
        if self.dev_storage_quota is not None:
            result['DevStorageQuota'] = self.dev_storage_quota
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.disable_development is not None:
            result['DisableDevelopment'] = self.disable_development
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.base_project is not None:
            result['BaseProject'] = self.base_project
        if self.use_proxy_odps_account is not None:
            result['UseProxyOdpsAccount'] = self.use_proxy_odps_account
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('MaxFlowNode') is not None:
            self.max_flow_node = m.get('MaxFlowNode')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProdStorageQuota') is not None:
            self.prod_storage_quota = m.get('ProdStorageQuota')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('TablePrivacyMode') is not None:
            self.table_privacy_mode = m.get('TablePrivacyMode')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('Appkey') is not None:
            self.appkey = m.get('Appkey')
        if m.get('DevStorageQuota') is not None:
            self.dev_storage_quota = m.get('DevStorageQuota')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('DisableDevelopment') is not None:
            self.disable_development = m.get('DisableDevelopment')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('BaseProject') is not None:
            self.base_project = m.get('BaseProject')
        if m.get('UseProxyOdpsAccount') is not None:
            self.use_proxy_odps_account = m.get('UseProxyOdpsAccount')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        return self


class GetProjectResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: GetProjectResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetProjectResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetProjectDetailRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetProjectDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        status: int = None,
        resident_area: str = None,
        project_id: int = None,
        project_identifier: str = None,
        project_name: str = None,
        is_allow_download: int = None,
        project_mode: int = None,
        project_description: str = None,
        gmt_modified: str = None,
        project_owner_base_id: str = None,
        development_type: int = None,
        default_di_resource_group_identifier: str = None,
        gmt_create: str = None,
        scheduler_max_retry_times: int = None,
        protected_mode: int = None,
        tenant_id: int = None,
        scheduler_retry_interval: int = None,
        env_types: List[str] = None,
    ):
        self.status = status
        self.resident_area = resident_area
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.project_name = project_name
        self.is_allow_download = is_allow_download
        self.project_mode = project_mode
        self.project_description = project_description
        self.gmt_modified = gmt_modified
        self.project_owner_base_id = project_owner_base_id
        self.development_type = development_type
        self.default_di_resource_group_identifier = default_di_resource_group_identifier
        self.gmt_create = gmt_create
        self.scheduler_max_retry_times = scheduler_max_retry_times
        self.protected_mode = protected_mode
        self.tenant_id = tenant_id
        self.scheduler_retry_interval = scheduler_retry_interval
        self.env_types = env_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.resident_area is not None:
            result['ResidentArea'] = self.resident_area
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.is_allow_download is not None:
            result['IsAllowDownload'] = self.is_allow_download
        if self.project_mode is not None:
            result['ProjectMode'] = self.project_mode
        if self.project_description is not None:
            result['ProjectDescription'] = self.project_description
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.project_owner_base_id is not None:
            result['ProjectOwnerBaseId'] = self.project_owner_base_id
        if self.development_type is not None:
            result['DevelopmentType'] = self.development_type
        if self.default_di_resource_group_identifier is not None:
            result['DefaultDiResourceGroupIdentifier'] = self.default_di_resource_group_identifier
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.scheduler_max_retry_times is not None:
            result['SchedulerMaxRetryTimes'] = self.scheduler_max_retry_times
        if self.protected_mode is not None:
            result['ProtectedMode'] = self.protected_mode
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.scheduler_retry_interval is not None:
            result['SchedulerRetryInterval'] = self.scheduler_retry_interval
        if self.env_types is not None:
            result['EnvTypes'] = self.env_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ResidentArea') is not None:
            self.resident_area = m.get('ResidentArea')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('IsAllowDownload') is not None:
            self.is_allow_download = m.get('IsAllowDownload')
        if m.get('ProjectMode') is not None:
            self.project_mode = m.get('ProjectMode')
        if m.get('ProjectDescription') is not None:
            self.project_description = m.get('ProjectDescription')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ProjectOwnerBaseId') is not None:
            self.project_owner_base_id = m.get('ProjectOwnerBaseId')
        if m.get('DevelopmentType') is not None:
            self.development_type = m.get('DevelopmentType')
        if m.get('DefaultDiResourceGroupIdentifier') is not None:
            self.default_di_resource_group_identifier = m.get('DefaultDiResourceGroupIdentifier')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('SchedulerMaxRetryTimes') is not None:
            self.scheduler_max_retry_times = m.get('SchedulerMaxRetryTimes')
        if m.get('ProtectedMode') is not None:
            self.protected_mode = m.get('ProtectedMode')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('SchedulerRetryInterval') is not None:
            self.scheduler_retry_interval = m.get('SchedulerRetryInterval')
        if m.get('EnvTypes') is not None:
            self.env_types = m.get('EnvTypes')
        return self


class GetProjectDetailResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: GetProjectDetailResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetProjectDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetProjectDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetProjectDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetProjectDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityEntityRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        table_name: str = None,
        env_type: str = None,
        match_expression: str = None,
    ):
        self.project_name = project_name
        self.table_name = table_name
        self.env_type = env_type
        self.match_expression = match_expression

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        return self


class GetQualityEntityResponseBodyData(TeaModel):
    def __init__(
        self,
        relative_node: str = None,
        on_duty_account_name: str = None,
        task: int = None,
        table_name: str = None,
        followers: str = None,
        on_duty: str = None,
        match_expression: str = None,
        create_time: int = None,
        project_name: str = None,
        has_relative_node: bool = None,
        env_type: str = None,
        entity_level: int = None,
        modify_user: str = None,
        sql: int = None,
        id: int = None,
        modify_time: int = None,
    ):
        self.relative_node = relative_node
        self.on_duty_account_name = on_duty_account_name
        self.task = task
        self.table_name = table_name
        self.followers = followers
        self.on_duty = on_duty
        self.match_expression = match_expression
        self.create_time = create_time
        self.project_name = project_name
        self.has_relative_node = has_relative_node
        self.env_type = env_type
        self.entity_level = entity_level
        self.modify_user = modify_user
        self.sql = sql
        self.id = id
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relative_node is not None:
            result['RelativeNode'] = self.relative_node
        if self.on_duty_account_name is not None:
            result['OnDutyAccountName'] = self.on_duty_account_name
        if self.task is not None:
            result['Task'] = self.task
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.followers is not None:
            result['Followers'] = self.followers
        if self.on_duty is not None:
            result['OnDuty'] = self.on_duty
        if self.match_expression is not None:
            result['MatchExpression'] = self.match_expression
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.has_relative_node is not None:
            result['HasRelativeNode'] = self.has_relative_node
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.entity_level is not None:
            result['EntityLevel'] = self.entity_level
        if self.modify_user is not None:
            result['ModifyUser'] = self.modify_user
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RelativeNode') is not None:
            self.relative_node = m.get('RelativeNode')
        if m.get('OnDutyAccountName') is not None:
            self.on_duty_account_name = m.get('OnDutyAccountName')
        if m.get('Task') is not None:
            self.task = m.get('Task')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('Followers') is not None:
            self.followers = m.get('Followers')
        if m.get('OnDuty') is not None:
            self.on_duty = m.get('OnDuty')
        if m.get('MatchExpression') is not None:
            self.match_expression = m.get('MatchExpression')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('HasRelativeNode') is not None:
            self.has_relative_node = m.get('HasRelativeNode')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('EntityLevel') is not None:
            self.entity_level = m.get('EntityLevel')
        if m.get('ModifyUser') is not None:
            self.modify_user = m.get('ModifyUser')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class GetQualityEntityResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: List[GetQualityEntityResponseBodyData] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityEntityResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetQualityEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQualityEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityFollowerRequest(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        entity_id: int = None,
    ):
        self.project_name = project_name
        self.entity_id = entity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class GetQualityFollowerResponseBodyData(TeaModel):
    def __init__(
        self,
        follower_account_name: str = None,
        table_name: str = None,
        alarm_mode: int = None,
        entity_id: str = None,
        project_name: str = None,
        id: int = None,
        follower: str = None,
    ):
        self.follower_account_name = follower_account_name
        self.table_name = table_name
        self.alarm_mode = alarm_mode
        self.entity_id = entity_id
        self.project_name = project_name
        self.id = id
        self.follower = follower

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.follower_account_name is not None:
            result['FollowerAccountName'] = self.follower_account_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.alarm_mode is not None:
            result['AlarmMode'] = self.alarm_mode
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.id is not None:
            result['Id'] = self.id
        if self.follower is not None:
            result['Follower'] = self.follower
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FollowerAccountName') is not None:
            self.follower_account_name = m.get('FollowerAccountName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('AlarmMode') is not None:
            self.alarm_mode = m.get('AlarmMode')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Follower') is not None:
            self.follower = m.get('Follower')
        return self


class GetQualityFollowerResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: List[GetQualityFollowerResponseBodyData] = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityFollowerResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class GetQualityFollowerResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQualityFollowerResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityFollowerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleRequest(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
        project_name: str = None,
    ):
        self.rule_id = rule_id
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class GetQualityRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        block_type: int = None,
        on_duty_account_name: str = None,
        warning_threshold: str = None,
        property: str = None,
        rule_type: int = None,
        comment: str = None,
        on_duty: str = None,
        checker: int = None,
        fix_check: bool = None,
        method_id: int = None,
        critical_threshold: str = None,
        predict_type: int = None,
        template_name: str = None,
        checker_name: str = None,
        rule_name: str = None,
        method_name: str = None,
        entity_id: int = None,
        where_condition: str = None,
        operator: str = None,
        expect_value: str = None,
        trend: str = None,
        template_id: int = None,
        id: int = None,
    ):
        self.block_type = block_type
        self.on_duty_account_name = on_duty_account_name
        self.warning_threshold = warning_threshold
        self.property = property
        self.rule_type = rule_type
        self.comment = comment
        self.on_duty = on_duty
        self.checker = checker
        self.fix_check = fix_check
        self.method_id = method_id
        self.critical_threshold = critical_threshold
        self.predict_type = predict_type
        self.template_name = template_name
        self.checker_name = checker_name
        self.rule_name = rule_name
        self.method_name = method_name
        self.entity_id = entity_id
        self.where_condition = where_condition
        self.operator = operator
        self.expect_value = expect_value
        self.trend = trend
        self.template_id = template_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_type is not None:
            result['BlockType'] = self.block_type
        if self.on_duty_account_name is not None:
            result['OnDutyAccountName'] = self.on_duty_account_name
        if self.warning_threshold is not None:
            result['WarningThreshold'] = self.warning_threshold
        if self.property is not None:
            result['Property'] = self.property
        if self.rule_type is not None:
            result['RuleType'] = self.rule_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.on_duty is not None:
            result['OnDuty'] = self.on_duty
        if self.checker is not None:
            result['Checker'] = self.checker
        if self.fix_check is not None:
            result['FixCheck'] = self.fix_check
        if self.method_id is not None:
            result['MethodId'] = self.method_id
        if self.critical_threshold is not None:
            result['CriticalThreshold'] = self.critical_threshold
        if self.predict_type is not None:
            result['PredictType'] = self.predict_type
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.checker_name is not None:
            result['CheckerName'] = self.checker_name
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.method_name is not None:
            result['MethodName'] = self.method_name
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.where_condition is not None:
            result['WhereCondition'] = self.where_condition
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.expect_value is not None:
            result['ExpectValue'] = self.expect_value
        if self.trend is not None:
            result['Trend'] = self.trend
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockType') is not None:
            self.block_type = m.get('BlockType')
        if m.get('OnDutyAccountName') is not None:
            self.on_duty_account_name = m.get('OnDutyAccountName')
        if m.get('WarningThreshold') is not None:
            self.warning_threshold = m.get('WarningThreshold')
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('RuleType') is not None:
            self.rule_type = m.get('RuleType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OnDuty') is not None:
            self.on_duty = m.get('OnDuty')
        if m.get('Checker') is not None:
            self.checker = m.get('Checker')
        if m.get('FixCheck') is not None:
            self.fix_check = m.get('FixCheck')
        if m.get('MethodId') is not None:
            self.method_id = m.get('MethodId')
        if m.get('CriticalThreshold') is not None:
            self.critical_threshold = m.get('CriticalThreshold')
        if m.get('PredictType') is not None:
            self.predict_type = m.get('PredictType')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('CheckerName') is not None:
            self.checker_name = m.get('CheckerName')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('MethodName') is not None:
            self.method_name = m.get('MethodName')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('WhereCondition') is not None:
            self.where_condition = m.get('WhereCondition')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('ExpectValue') is not None:
            self.expect_value = m.get('ExpectValue')
        if m.get('Trend') is not None:
            self.trend = m.get('Trend')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetQualityRuleResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetQualityRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRemindRequest(TeaModel):
    def __init__(
        self,
        remind_id: int = None,
    ):
        self.remind_id = remind_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        return self


class GetRemindResponseBodyDataRobots(TeaModel):
    def __init__(
        self,
        web_url: str = None,
        at_all: bool = None,
    ):
        self.web_url = web_url
        self.at_all = at_all

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.web_url is not None:
            result['WebUrl'] = self.web_url
        if self.at_all is not None:
            result['AtAll'] = self.at_all
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WebUrl') is not None:
            self.web_url = m.get('WebUrl')
        if m.get('AtAll') is not None:
            self.at_all = m.get('AtAll')
        return self


class GetRemindResponseBodyDataNodes(TeaModel):
    def __init__(
        self,
        owner: str = None,
        node_name: str = None,
        node_id: int = None,
        project_id: int = None,
    ):
        self.owner = owner
        self.node_name = node_name
        self.node_id = node_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetRemindResponseBodyDataBaselines(TeaModel):
    def __init__(
        self,
        baseline_name: str = None,
        baseline_id: int = None,
    ):
        self.baseline_name = baseline_name
        self.baseline_id = baseline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        return self


class GetRemindResponseBodyDataProjects(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetRemindResponseBodyDataBizProcesses(TeaModel):
    def __init__(
        self,
        biz_process_name: str = None,
        biz_id: int = None,
    ):
        self.biz_process_name = biz_process_name
        self.biz_id = biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_process_name is not None:
            result['BizProcessName'] = self.biz_process_name
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizProcessName') is not None:
            self.biz_process_name = m.get('BizProcessName')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        return self


class GetRemindResponseBodyData(TeaModel):
    def __init__(
        self,
        max_alert_times: int = None,
        remind_unit: str = None,
        alert_interval: int = None,
        useflag: bool = None,
        founder: str = None,
        remind_id: int = None,
        dnd_end: str = None,
        remind_type: str = None,
        alert_unit: str = None,
        dnd_start: str = None,
        remind_name: str = None,
        detail: str = None,
        robots: List[GetRemindResponseBodyDataRobots] = None,
        nodes: List[GetRemindResponseBodyDataNodes] = None,
        baselines: List[GetRemindResponseBodyDataBaselines] = None,
        projects: List[GetRemindResponseBodyDataProjects] = None,
        biz_processes: List[GetRemindResponseBodyDataBizProcesses] = None,
        alert_targets: List[str] = None,
        alert_methods: List[str] = None,
    ):
        self.max_alert_times = max_alert_times
        self.remind_unit = remind_unit
        self.alert_interval = alert_interval
        self.useflag = useflag
        self.founder = founder
        self.remind_id = remind_id
        self.dnd_end = dnd_end
        self.remind_type = remind_type
        self.alert_unit = alert_unit
        self.dnd_start = dnd_start
        self.remind_name = remind_name
        self.detail = detail
        self.robots = robots
        self.nodes = nodes
        self.baselines = baselines
        self.projects = projects
        self.biz_processes = biz_processes
        self.alert_targets = alert_targets
        self.alert_methods = alert_methods

    def validate(self):
        if self.robots:
            for k in self.robots:
                if k:
                    k.validate()
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()
        if self.projects:
            for k in self.projects:
                if k:
                    k.validate()
        if self.biz_processes:
            for k in self.biz_processes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_alert_times is not None:
            result['MaxAlertTimes'] = self.max_alert_times
        if self.remind_unit is not None:
            result['RemindUnit'] = self.remind_unit
        if self.alert_interval is not None:
            result['AlertInterval'] = self.alert_interval
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        if self.founder is not None:
            result['Founder'] = self.founder
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.dnd_end is not None:
            result['DndEnd'] = self.dnd_end
        if self.remind_type is not None:
            result['RemindType'] = self.remind_type
        if self.alert_unit is not None:
            result['AlertUnit'] = self.alert_unit
        if self.dnd_start is not None:
            result['DndStart'] = self.dnd_start
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.detail is not None:
            result['Detail'] = self.detail
        result['Robots'] = []
        if self.robots is not None:
            for k in self.robots:
                result['Robots'].append(k.to_map() if k else None)
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        result['Projects'] = []
        if self.projects is not None:
            for k in self.projects:
                result['Projects'].append(k.to_map() if k else None)
        result['BizProcesses'] = []
        if self.biz_processes is not None:
            for k in self.biz_processes:
                result['BizProcesses'].append(k.to_map() if k else None)
        if self.alert_targets is not None:
            result['AlertTargets'] = self.alert_targets
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxAlertTimes') is not None:
            self.max_alert_times = m.get('MaxAlertTimes')
        if m.get('RemindUnit') is not None:
            self.remind_unit = m.get('RemindUnit')
        if m.get('AlertInterval') is not None:
            self.alert_interval = m.get('AlertInterval')
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        if m.get('Founder') is not None:
            self.founder = m.get('Founder')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('DndEnd') is not None:
            self.dnd_end = m.get('DndEnd')
        if m.get('RemindType') is not None:
            self.remind_type = m.get('RemindType')
        if m.get('AlertUnit') is not None:
            self.alert_unit = m.get('AlertUnit')
        if m.get('DndStart') is not None:
            self.dnd_start = m.get('DndStart')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        self.robots = []
        if m.get('Robots') is not None:
            for k in m.get('Robots'):
                temp_model = GetRemindResponseBodyDataRobots()
                self.robots.append(temp_model.from_map(k))
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = GetRemindResponseBodyDataNodes()
                self.nodes.append(temp_model.from_map(k))
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = GetRemindResponseBodyDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        self.projects = []
        if m.get('Projects') is not None:
            for k in m.get('Projects'):
                temp_model = GetRemindResponseBodyDataProjects()
                self.projects.append(temp_model.from_map(k))
        self.biz_processes = []
        if m.get('BizProcesses') is not None:
            for k in m.get('BizProcesses'):
                temp_model = GetRemindResponseBodyDataBizProcesses()
                self.biz_processes.append(temp_model.from_map(k))
        if m.get('AlertTargets') is not None:
            self.alert_targets = m.get('AlertTargets')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        return self


class GetRemindResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetRemindResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetRemindResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetRemindResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetRemindResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRemindResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSensitiveDataRequest(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_no: int = None,
        name: str = None,
    ):
        self.page_size = page_size
        self.page_no = page_no
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetSensitiveDataResponseBody(TeaModel):
    def __init__(
        self,
        sensitive_data: Dict[str, Any] = None,
        request_id: str = None,
    ):
        self.sensitive_data = sensitive_data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sensitive_data is not None:
            result['SensitiveData'] = self.sensitive_data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SensitiveData') is not None:
            self.sensitive_data = m.get('SensitiveData')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetSensitiveDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSensitiveDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSensitiveDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSuccessInstanceTrendRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
    ):
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend(TeaModel):
    def __init__(
        self,
        time_point: str = None,
        count: int = None,
    ):
        self.time_point = time_point
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend(TeaModel):
    def __init__(
        self,
        time_point: str = None,
        count: int = None,
    ):
        self.time_point = time_point
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend(TeaModel):
    def __init__(
        self,
        time_point: str = None,
        count: int = None,
    ):
        self.time_point = time_point
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class GetSuccessInstanceTrendResponseBodyInstanceStatusTrend(TeaModel):
    def __init__(
        self,
        today_trend: List[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend] = None,
        yesterday_trend: List[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend] = None,
        avg_trend: List[GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend] = None,
    ):
        self.today_trend = today_trend
        self.yesterday_trend = yesterday_trend
        self.avg_trend = avg_trend

    def validate(self):
        if self.today_trend:
            for k in self.today_trend:
                if k:
                    k.validate()
        if self.yesterday_trend:
            for k in self.yesterday_trend:
                if k:
                    k.validate()
        if self.avg_trend:
            for k in self.avg_trend:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TodayTrend'] = []
        if self.today_trend is not None:
            for k in self.today_trend:
                result['TodayTrend'].append(k.to_map() if k else None)
        result['YesterdayTrend'] = []
        if self.yesterday_trend is not None:
            for k in self.yesterday_trend:
                result['YesterdayTrend'].append(k.to_map() if k else None)
        result['AvgTrend'] = []
        if self.avg_trend is not None:
            for k in self.avg_trend:
                result['AvgTrend'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.today_trend = []
        if m.get('TodayTrend') is not None:
            for k in m.get('TodayTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendTodayTrend()
                self.today_trend.append(temp_model.from_map(k))
        self.yesterday_trend = []
        if m.get('YesterdayTrend') is not None:
            for k in m.get('YesterdayTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendYesterdayTrend()
                self.yesterday_trend.append(temp_model.from_map(k))
        self.avg_trend = []
        if m.get('AvgTrend') is not None:
            for k in m.get('AvgTrend'):
                temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrendAvgTrend()
                self.avg_trend.append(temp_model.from_map(k))
        return self


class GetSuccessInstanceTrendResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_status_trend: GetSuccessInstanceTrendResponseBodyInstanceStatusTrend = None,
    ):
        self.request_id = request_id
        self.instance_status_trend = instance_status_trend

    def validate(self):
        if self.instance_status_trend:
            self.instance_status_trend.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_status_trend is not None:
            result['InstanceStatusTrend'] = self.instance_status_trend.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceStatusTrend') is not None:
            temp_model = GetSuccessInstanceTrendResponseBodyInstanceStatusTrend()
            self.instance_status_trend = temp_model.from_map(m['InstanceStatusTrend'])
        return self


class GetSuccessInstanceTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSuccessInstanceTrendResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSuccessInstanceTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicRequest(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
    ):
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicResponseBodyData(TeaModel):
    def __init__(
        self,
        owner: str = None,
        topic_name: str = None,
        baseline_status: str = None,
        project_id: int = None,
        next_alert_time: int = None,
        instance_id: int = None,
        fix_time: int = None,
        baseline_in_group_id: int = None,
        baseline_buffer: int = None,
        topic_type: str = None,
        topic_status: str = None,
        happen_time: int = None,
        deal_time: int = None,
        deal_user: str = None,
        baseline_name: str = None,
        baseline_id: int = None,
        node_name: str = None,
        alert_time: int = None,
        buffer: int = None,
        assigner: str = None,
        topic_id: int = None,
        add_time: int = None,
        node_id: int = None,
    ):
        self.owner = owner
        self.topic_name = topic_name
        self.baseline_status = baseline_status
        self.project_id = project_id
        self.next_alert_time = next_alert_time
        self.instance_id = instance_id
        self.fix_time = fix_time
        self.baseline_in_group_id = baseline_in_group_id
        self.baseline_buffer = baseline_buffer
        self.topic_type = topic_type
        self.topic_status = topic_status
        self.happen_time = happen_time
        self.deal_time = deal_time
        self.deal_user = deal_user
        self.baseline_name = baseline_name
        self.baseline_id = baseline_id
        self.node_name = node_name
        self.alert_time = alert_time
        self.buffer = buffer
        self.assigner = assigner
        self.topic_id = topic_id
        self.add_time = add_time
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.baseline_status is not None:
            result['BaselineStatus'] = self.baseline_status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.next_alert_time is not None:
            result['NextAlertTime'] = self.next_alert_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.baseline_in_group_id is not None:
            result['BaselineInGroupId'] = self.baseline_in_group_id
        if self.baseline_buffer is not None:
            result['BaselineBuffer'] = self.baseline_buffer
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        if self.happen_time is not None:
            result['HappenTime'] = self.happen_time
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_user is not None:
            result['DealUser'] = self.deal_user
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.assigner is not None:
            result['Assigner'] = self.assigner
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.add_time is not None:
            result['AddTime'] = self.add_time
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('BaselineStatus') is not None:
            self.baseline_status = m.get('BaselineStatus')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('NextAlertTime') is not None:
            self.next_alert_time = m.get('NextAlertTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('BaselineInGroupId') is not None:
            self.baseline_in_group_id = m.get('BaselineInGroupId')
        if m.get('BaselineBuffer') is not None:
            self.baseline_buffer = m.get('BaselineBuffer')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        if m.get('HappenTime') is not None:
            self.happen_time = m.get('HappenTime')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealUser') is not None:
            self.deal_user = m.get('DealUser')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('Assigner') is not None:
            self.assigner = m.get('Assigner')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('AddTime') is not None:
            self.add_time = m.get('AddTime')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class GetTopicResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetTopicResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetTopicResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetTopicResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetTopicResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTopicInfluenceRequest(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
    ):
        self.topic_id = topic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class GetTopicInfluenceResponseBodyDataInfluences(TeaModel):
    def __init__(
        self,
        status: str = None,
        owner: str = None,
        baseline_name: str = None,
        baseline_id: int = None,
        bizdate: int = None,
        buffer: int = None,
        project_id: int = None,
        priority: int = None,
        in_group_id: int = None,
    ):
        self.status = status
        self.owner = owner
        self.baseline_name = baseline_name
        self.baseline_id = baseline_id
        self.bizdate = bizdate
        self.buffer = buffer
        self.project_id = project_id
        self.priority = priority
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class GetTopicInfluenceResponseBodyData(TeaModel):
    def __init__(
        self,
        topic_id: int = None,
        influences: List[GetTopicInfluenceResponseBodyDataInfluences] = None,
    ):
        self.topic_id = topic_id
        self.influences = influences

    def validate(self):
        if self.influences:
            for k in self.influences:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        result['Influences'] = []
        if self.influences is not None:
            for k in self.influences:
                result['Influences'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        self.influences = []
        if m.get('Influences') is not None:
            for k in m.get('Influences'):
                temp_model = GetTopicInfluenceResponseBodyDataInfluences()
                self.influences.append(temp_model.from_map(k))
        return self


class GetTopicInfluenceResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: GetTopicInfluenceResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = GetTopicInfluenceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetTopicInfluenceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetTopicInfluenceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetTopicInfluenceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportConnectionsRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        connections: str = None,
    ):
        self.project_id = project_id
        self.connections = connections

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.connections is not None:
            result['Connections'] = self.connections
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Connections') is not None:
            self.connections = m.get('Connections')
        return self


class ImportConnectionsResponseBodyData(TeaModel):
    def __init__(
        self,
        status: bool = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ImportConnectionsResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: ImportConnectionsResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ImportConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportConnectionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportConnectionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportDataSourcesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        data_sources: str = None,
    ):
        self.project_id = project_id
        self.data_sources = data_sources

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.data_sources is not None:
            result['DataSources'] = self.data_sources
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('DataSources') is not None:
            self.data_sources = m.get('DataSources')
        return self


class ImportDataSourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        status: bool = None,
        message: str = None,
    ):
        self.status = status
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ImportDataSourcesResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        data: ImportDataSourcesResponseBodyData = None,
    ):
        self.success = success
        self.request_id = request_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = ImportDataSourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ImportDataSourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportDataSourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportDataSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportDISyncTasksRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        task_type: str = None,
        body: str = None,
        task_param: str = None,
    ):
        self.project_id = project_id
        self.task_type = task_type
        self.body = body
        self.task_param = task_param

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.body is not None:
            result['body'] = self.body
        if self.task_param is not None:
            result['TaskParam'] = self.task_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('body') is not None:
            self.body = m.get('body')
        if m.get('TaskParam') is not None:
            self.task_param = m.get('TaskParam')
        return self


class ImportDISyncTasksResponseBodyTaskInfo(TeaModel):
    def __init__(
        self,
        task_id: int = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ImportDISyncTasksResponseBody(TeaModel):
    def __init__(
        self,
        success: bool = None,
        request_id: str = None,
        task_info: ImportDISyncTasksResponseBodyTaskInfo = None,
    ):
        self.success = success
        self.request_id = request_id
        self.task_info = task_info

    def validate(self):
        if self.task_info:
            self.task_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_info is not None:
            result['TaskInfo'] = self.task_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskInfo') is not None:
            temp_model = ImportDISyncTasksResponseBodyTaskInfo()
            self.task_info = temp_model.from_map(m['TaskInfo'])
        return self


class ImportDISyncTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ImportDISyncTasksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportDISyncTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAlertMessagesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        begin_time: str = None,
        end_time: str = None,
        remind_id: int = None,
        alert_methods: str = None,
        alert_user: str = None,
        alert_rule_types: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.begin_time = begin_time
        self.end_time = end_time
        self.remind_id = remind_id
        self.alert_methods = alert_methods
        self.alert_user = alert_user
        self.alert_rule_types = alert_rule_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.begin_time is not None:
            result['BeginTime'] = self.begin_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.alert_methods is not None:
            result['AlertMethods'] = self.alert_methods
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.alert_rule_types is not None:
            result['AlertRuleTypes'] = self.alert_rule_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('BeginTime') is not None:
            self.begin_time = m.get('BeginTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('AlertMethods') is not None:
            self.alert_methods = m.get('AlertMethods')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('AlertRuleTypes') is not None:
            self.alert_rule_types = m.get('AlertRuleTypes')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesInstances(TeaModel):
    def __init__(
        self,
        status: str = None,
        instance_id: int = None,
        node_name: str = None,
        node_id: int = None,
        project_id: int = None,
    ):
        self.status = status
        self.instance_id = instance_id
        self.node_name = node_name
        self.node_id = node_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesTopics(TeaModel):
    def __init__(
        self,
        topic_name: str = None,
        instance_id: int = None,
        topic_id: int = None,
        topic_owner: str = None,
        node_id: int = None,
        topic_status: str = None,
    ):
        self.topic_name = topic_name
        self.instance_id = instance_id
        self.topic_id = topic_id
        self.topic_owner = topic_owner
        self.node_id = node_id
        self.topic_status = topic_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_name is not None:
            result['TopicName'] = self.topic_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.topic_owner is not None:
            result['TopicOwner'] = self.topic_owner
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.topic_status is not None:
            result['TopicStatus'] = self.topic_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TopicName') is not None:
            self.topic_name = m.get('TopicName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('TopicOwner') is not None:
            self.topic_owner = m.get('TopicOwner')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TopicStatus') is not None:
            self.topic_status = m.get('TopicStatus')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesNodes(TeaModel):
    def __init__(
        self,
        owner: str = None,
        node_name: str = None,
        node_id: int = None,
        project_id: int = None,
    ):
        self.owner = owner
        self.node_name = node_name
        self.node_id = node_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert(TeaModel):
    def __init__(
        self,
        status: str = None,
        baseline_owner: str = None,
        baseline_id: int = None,
        baseline_name: str = None,
        bizdate: int = None,
        project_id: int = None,
        in_group_id: int = None,
    ):
        self.status = status
        self.baseline_owner = baseline_owner
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.bizdate = bizdate
        self.project_id = project_id
        self.in_group_id = in_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.baseline_owner is not None:
            result['BaselineOwner'] = self.baseline_owner
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BaselineOwner') is not None:
            self.baseline_owner = m.get('BaselineOwner')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        return self


class ListAlertMessagesResponseBodyDataAlertMessages(TeaModel):
    def __init__(
        self,
        remind_id: int = None,
        alert_message_status: str = None,
        alert_user: str = None,
        alert_time: int = None,
        alert_method: str = None,
        source: str = None,
        content: str = None,
        remind_name: str = None,
        alert_id: int = None,
        instances: List[ListAlertMessagesResponseBodyDataAlertMessagesInstances] = None,
        topics: List[ListAlertMessagesResponseBodyDataAlertMessagesTopics] = None,
        nodes: List[ListAlertMessagesResponseBodyDataAlertMessagesNodes] = None,
        sla_alert: ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert = None,
    ):
        self.remind_id = remind_id
        self.alert_message_status = alert_message_status
        self.alert_user = alert_user
        self.alert_time = alert_time
        self.alert_method = alert_method
        self.source = source
        self.content = content
        self.remind_name = remind_name
        self.alert_id = alert_id
        self.instances = instances
        self.topics = topics
        self.nodes = nodes
        self.sla_alert = sla_alert

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.topics:
            for k in self.topics:
                if k:
                    k.validate()
        if self.nodes:
            for k in self.nodes:
                if k:
                    k.validate()
        if self.sla_alert:
            self.sla_alert.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_id is not None:
            result['RemindId'] = self.remind_id
        if self.alert_message_status is not None:
            result['AlertMessageStatus'] = self.alert_message_status
        if self.alert_user is not None:
            result['AlertUser'] = self.alert_user
        if self.alert_time is not None:
            result['AlertTime'] = self.alert_time
        if self.alert_method is not None:
            result['AlertMethod'] = self.alert_method
        if self.source is not None:
            result['Source'] = self.source
        if self.content is not None:
            result['Content'] = self.content
        if self.remind_name is not None:
            result['RemindName'] = self.remind_name
        if self.alert_id is not None:
            result['AlertId'] = self.alert_id
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        result['Topics'] = []
        if self.topics is not None:
            for k in self.topics:
                result['Topics'].append(k.to_map() if k else None)
        result['Nodes'] = []
        if self.nodes is not None:
            for k in self.nodes:
                result['Nodes'].append(k.to_map() if k else None)
        if self.sla_alert is not None:
            result['SlaAlert'] = self.sla_alert.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindId') is not None:
            self.remind_id = m.get('RemindId')
        if m.get('AlertMessageStatus') is not None:
            self.alert_message_status = m.get('AlertMessageStatus')
        if m.get('AlertUser') is not None:
            self.alert_user = m.get('AlertUser')
        if m.get('AlertTime') is not None:
            self.alert_time = m.get('AlertTime')
        if m.get('AlertMethod') is not None:
            self.alert_method = m.get('AlertMethod')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('RemindName') is not None:
            self.remind_name = m.get('RemindName')
        if m.get('AlertId') is not None:
            self.alert_id = m.get('AlertId')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesInstances()
                self.instances.append(temp_model.from_map(k))
        self.topics = []
        if m.get('Topics') is not None:
            for k in m.get('Topics'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesTopics()
                self.topics.append(temp_model.from_map(k))
        self.nodes = []
        if m.get('Nodes') is not None:
            for k in m.get('Nodes'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessagesNodes()
                self.nodes.append(temp_model.from_map(k))
        if m.get('SlaAlert') is not None:
            temp_model = ListAlertMessagesResponseBodyDataAlertMessagesSlaAlert()
            self.sla_alert = temp_model.from_map(m['SlaAlert'])
        return self


class ListAlertMessagesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: str = None,
        page_size: str = None,
        total_count: str = None,
        alert_messages: List[ListAlertMessagesResponseBodyDataAlertMessages] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.alert_messages = alert_messages

    def validate(self):
        if self.alert_messages:
            for k in self.alert_messages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['AlertMessages'] = []
        if self.alert_messages is not None:
            for k in self.alert_messages:
                result['AlertMessages'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.alert_messages = []
        if m.get('AlertMessages') is not None:
            for k in m.get('AlertMessages'):
                temp_model = ListAlertMessagesResponseBodyDataAlertMessages()
                self.alert_messages.append(temp_model.from_map(k))
        return self


class ListAlertMessagesResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: ListAlertMessagesResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListAlertMessagesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListAlertMessagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAlertMessagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAlertMessagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBaselineConfigsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        owner: str = None,
        project_id: int = None,
        priority: str = None,
        useflag: bool = None,
        baseline_types: str = None,
        search_text: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.owner = owner
        self.project_id = project_id
        self.priority = priority
        self.useflag = useflag
        self.baseline_types = baseline_types
        self.search_text = search_text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.useflag is not None:
            result['Useflag'] = self.useflag
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Useflag') is not None:
            self.useflag = m.get('Useflag')
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        return self


class ListBaselineConfigsResponseBodyDataBaselines(TeaModel):
    def __init__(
        self,
        hour_sla_detail: str = None,
        is_default: bool = None,
        owner: str = None,
        project_id: int = None,
        priority: int = None,
        sla_minu: int = None,
        sla_hour: int = None,
        baseline_id: int = None,
        baseline_name: str = None,
        hour_exp_detail: str = None,
        use_flag: bool = None,
        exp_hour: int = None,
        baseline_type: str = None,
        exp_minu: int = None,
    ):
        self.hour_sla_detail = hour_sla_detail
        self.is_default = is_default
        self.owner = owner
        self.project_id = project_id
        self.priority = priority
        self.sla_minu = sla_minu
        self.sla_hour = sla_hour
        self.baseline_id = baseline_id
        self.baseline_name = baseline_name
        self.hour_exp_detail = hour_exp_detail
        self.use_flag = use_flag
        self.exp_hour = exp_hour
        self.baseline_type = baseline_type
        self.exp_minu = exp_minu

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hour_sla_detail is not None:
            result['HourSlaDetail'] = self.hour_sla_detail
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.sla_minu is not None:
            result['SlaMinu'] = self.sla_minu
        if self.sla_hour is not None:
            result['SlaHour'] = self.sla_hour
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.hour_exp_detail is not None:
            result['HourExpDetail'] = self.hour_exp_detail
        if self.use_flag is not None:
            result['UseFlag'] = self.use_flag
        if self.exp_hour is not None:
            result['ExpHour'] = self.exp_hour
        if self.baseline_type is not None:
            result['BaselineType'] = self.baseline_type
        if self.exp_minu is not None:
            result['ExpMinu'] = self.exp_minu
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HourSlaDetail') is not None:
            self.hour_sla_detail = m.get('HourSlaDetail')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SlaMinu') is not None:
            self.sla_minu = m.get('SlaMinu')
        if m.get('SlaHour') is not None:
            self.sla_hour = m.get('SlaHour')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('HourExpDetail') is not None:
            self.hour_exp_detail = m.get('HourExpDetail')
        if m.get('UseFlag') is not None:
            self.use_flag = m.get('UseFlag')
        if m.get('ExpHour') is not None:
            self.exp_hour = m.get('ExpHour')
        if m.get('BaselineType') is not None:
            self.baseline_type = m.get('BaselineType')
        if m.get('ExpMinu') is not None:
            self.exp_minu = m.get('ExpMinu')
        return self


class ListBaselineConfigsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        baselines: List[ListBaselineConfigsResponseBodyDataBaselines] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.baselines = baselines

    def validate(self):
        if self.baselines:
            for k in self.baselines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Baselines'] = []
        if self.baselines is not None:
            for k in self.baselines:
                result['Baselines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.baselines = []
        if m.get('Baselines') is not None:
            for k in m.get('Baselines'):
                temp_model = ListBaselineConfigsResponseBodyDataBaselines()
                self.baselines.append(temp_model.from_map(k))
        return self


class ListBaselineConfigsResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: ListBaselineConfigsResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListBaselineConfigsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBaselineConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBaselineConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBaselineConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBaselineStatusesRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        bizdate: str = None,
        priority: str = None,
        search_text: str = None,
        owner: str = None,
        topic_id: int = None,
        finish_status: str = None,
        status: str = None,
        baseline_types: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.bizdate = bizdate
        self.priority = priority
        self.search_text = search_text
        self.owner = owner
        self.topic_id = topic_id
        self.finish_status = finish_status
        self.status = status
        self.baseline_types = baseline_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.search_text is not None:
            result['SearchText'] = self.search_text
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.status is not None:
            result['Status'] = self.status
        if self.baseline_types is not None:
            result['BaselineTypes'] = self.baseline_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SearchText') is not None:
            self.search_text = m.get('SearchText')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BaselineTypes') is not None:
            self.baseline_types = m.get('BaselineTypes')
        return self


class ListBaselineStatusesResponseBodyDataBaselineStatuses(TeaModel):
    def __init__(
        self,
        status: str = None,
        owner: str = None,
        finish_time: int = None,
        project_id: int = None,
        priority: int = None,
        end_cast: int = None,
        in_group_id: int = None,
        baseline_name: str = None,
        baseline_id: int = None,
        finish_status: str = None,
        bizdate: int = None,
        buffer: int = None,
        sla_time: int = None,
        exp_time: int = None,
    ):
        self.status = status
        self.owner = owner
        self.finish_time = finish_time
        self.project_id = project_id
        self.priority = priority
        self.end_cast = end_cast
        self.in_group_id = in_group_id
        self.baseline_name = baseline_name
        self.baseline_id = baseline_id
        self.finish_status = finish_status
        self.bizdate = bizdate
        self.buffer = buffer
        self.sla_time = sla_time
        self.exp_time = exp_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.end_cast is not None:
            result['EndCast'] = self.end_cast
        if self.in_group_id is not None:
            result['InGroupId'] = self.in_group_id
        if self.baseline_name is not None:
            result['BaselineName'] = self.baseline_name
        if self.baseline_id is not None:
            result['BaselineId'] = self.baseline_id
        if self.finish_status is not None:
            result['FinishStatus'] = self.finish_status
        if self.bizdate is not None:
            result['Bizdate'] = self.bizdate
        if self.buffer is not None:
            result['Buffer'] = self.buffer
        if self.sla_time is not None:
            result['SlaTime'] = self.sla_time
        if self.exp_time is not None:
            result['ExpTime'] = self.exp_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('EndCast') is not None:
            self.end_cast = m.get('EndCast')
        if m.get('InGroupId') is not None:
            self.in_group_id = m.get('InGroupId')
        if m.get('BaselineName') is not None:
            self.baseline_name = m.get('BaselineName')
        if m.get('BaselineId') is not None:
            self.baseline_id = m.get('BaselineId')
        if m.get('FinishStatus') is not None:
            self.finish_status = m.get('FinishStatus')
        if m.get('Bizdate') is not None:
            self.bizdate = m.get('Bizdate')
        if m.get('Buffer') is not None:
            self.buffer = m.get('Buffer')
        if m.get('SlaTime') is not None:
            self.sla_time = m.get('SlaTime')
        if m.get('ExpTime') is not None:
            self.exp_time = m.get('ExpTime')
        return self


class ListBaselineStatusesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        baseline_statuses: List[ListBaselineStatusesResponseBodyDataBaselineStatuses] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.baseline_statuses = baseline_statuses

    def validate(self):
        if self.baseline_statuses:
            for k in self.baseline_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['BaselineStatuses'] = []
        if self.baseline_statuses is not None:
            for k in self.baseline_statuses:
                result['BaselineStatuses'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.baseline_statuses = []
        if m.get('BaselineStatuses') is not None:
            for k in m.get('BaselineStatuses'):
                temp_model = ListBaselineStatusesResponseBodyDataBaselineStatuses()
                self.baseline_statuses.append(temp_model.from_map(k))
        return self


class ListBaselineStatusesResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        error_code: str = None,
        success: bool = None,
        data: ListBaselineStatusesResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListBaselineStatusesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBaselineStatusesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBaselineStatusesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBaselineStatusesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBusinessRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        project_identifier: str = None,
        page_number: int = None,
        page_size: int = None,
        keyword: str = None,
    ):
        self.project_id = project_id
        self.project_identifier = project_identifier
        self.page_number = page_number
        self.page_size = page_size
        self.keyword = keyword

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_identifier is not None:
            result['ProjectIdentifier'] = self.project_identifier
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectIdentifier') is not None:
            self.project_identifier = m.get('ProjectIdentifier')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        return self


class ListBusinessResponseBodyDataBusiness(TeaModel):
    def __init__(
        self,
        owner: str = None,
        description: str = None,
        project_id: int = None,
        business_id: int = None,
        business_name: str = None,
        use_type: str = None,
    ):
        self.owner = owner
        self.description = description
        self.project_id = project_id
        self.business_id = business_id
        self.business_name = business_name
        self.use_type = use_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.description is not None:
            result['Description'] = self.description
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.business_id is not None:
            result['BusinessId'] = self.business_id
        if self.business_name is not None:
            result['BusinessName'] = self.business_name
        if self.use_type is not None:
            result['UseType'] = self.use_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('BusinessId') is not None:
            self.business_id = m.get('BusinessId')
        if m.get('BusinessName') is not None:
            self.business_name = m.get('BusinessName')
        if m.get('UseType') is not None:
            self.use_type = m.get('UseType')
        return self


class ListBusinessResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        business: List[ListBusinessResponseBodyDataBusiness] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.business = business

    def validate(self):
        if self.business:
            for k in self.business:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Business'] = []
        if self.business is not None:
            for k in self.business:
                result['Business'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.business = []
        if m.get('Business') is not None:
            for k in m.get('Business'):
                temp_model = ListBusinessResponseBodyDataBusiness()
                self.business.append(temp_model.from_map(k))
        return self


class ListBusinessResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        error_message: str = None,
        request_id: str = None,
        error_code: str = None,
        success: bool = None,
        data: ListBusinessResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.error_message = error_message
        self.request_id = request_id
        self.error_code = error_code
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListBusinessResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListBusinessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBusinessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBusinessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCalcEnginesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        calc_engine_type: str = None,
        env_type: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.calc_engine_type = calc_engine_type
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListCalcEnginesResponseBodyDataCalcEngines(TeaModel):
    def __init__(
        self,
        binding_project_name: str = None,
        is_default: bool = None,
        engine_id: int = None,
        dw_region: str = None,
        task_auth_type: str = None,
        calc_engine_type: str = None,
        engine_info: Dict[str, Any] = None,
        env_type: str = None,
        region: str = None,
        gmt_create: str = None,
        binding_project_id: int = None,
        name: str = None,
        tenant_id: int = None,
    ):
        self.binding_project_name = binding_project_name
        self.is_default = is_default
        self.engine_id = engine_id
        self.dw_region = dw_region
        self.task_auth_type = task_auth_type
        self.calc_engine_type = calc_engine_type
        self.engine_info = engine_info
        self.env_type = env_type
        self.region = region
        self.gmt_create = gmt_create
        self.binding_project_id = binding_project_id
        self.name = name
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binding_project_name is not None:
            result['BindingProjectName'] = self.binding_project_name
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.engine_id is not None:
            result['EngineId'] = self.engine_id
        if self.dw_region is not None:
            result['DwRegion'] = self.dw_region
        if self.task_auth_type is not None:
            result['TaskAuthType'] = self.task_auth_type
        if self.calc_engine_type is not None:
            result['CalcEngineType'] = self.calc_engine_type
        if self.engine_info is not None:
            result['EngineInfo'] = self.engine_info
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.region is not None:
            result['Region'] = self.region
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.binding_project_id is not None:
            result['BindingProjectId'] = self.binding_project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindingProjectName') is not None:
            self.binding_project_name = m.get('BindingProjectName')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('EngineId') is not None:
            self.engine_id = m.get('EngineId')
        if m.get('DwRegion') is not None:
            self.dw_region = m.get('DwRegion')
        if m.get('TaskAuthType') is not None:
            self.task_auth_type = m.get('TaskAuthType')
        if m.get('CalcEngineType') is not None:
            self.calc_engine_type = m.get('CalcEngineType')
        if m.get('EngineInfo') is not None:
            self.engine_info = m.get('EngineInfo')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('BindingProjectId') is not None:
            self.binding_project_id = m.get('BindingProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListCalcEnginesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        calc_engines: List[ListCalcEnginesResponseBodyDataCalcEngines] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.calc_engines = calc_engines

    def validate(self):
        if self.calc_engines:
            for k in self.calc_engines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['CalcEngines'] = []
        if self.calc_engines is not None:
            for k in self.calc_engines:
                result['CalcEngines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.calc_engines = []
        if m.get('CalcEngines') is not None:
            for k in m.get('CalcEngines'):
                temp_model = ListCalcEnginesResponseBodyDataCalcEngines()
                self.calc_engines.append(temp_model.from_map(k))
        return self


class ListCalcEnginesResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: ListCalcEnginesResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListCalcEnginesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListCalcEnginesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListCalcEnginesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListCalcEnginesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListConnectionsRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        name: str = None,
        connection_type: str = None,
        sub_type: str = None,
        status: str = None,
        env_type: int = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.project_id = project_id
        self.name = name
        self.connection_type = connection_type
        self.sub_type = sub_type
        self.status = status
        self.env_type = env_type
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.status is not None:
            result['Status'] = self.status
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListConnectionsResponseBodyDataConnections(TeaModel):
    def __init__(
        self,
        status: int = None,
        connection_type: str = None,
        project_id: int = None,
        sub_type: str = None,
        gmt_modified: str = None,
        env_type: int = None,
        connect_status: int = None,
        sequence: int = None,
        description: str = None,
        gmt_create: str = None,
        default_engine: bool = None,
        shared: bool = None,
        operator: str = None,
        name: str = None,
        content: str = None,
        id: int = None,
        binding_calc_engine_id: int = None,
        tenant_id: int = None,
    ):
        self.status = status
        self.connection_type = connection_type
        self.project_id = project_id
        self.sub_type = sub_type
        self.gmt_modified = gmt_modified
        self.env_type = env_type
        self.connect_status = connect_status
        self.sequence = sequence
        self.description = description
        self.gmt_create = gmt_create
        self.default_engine = default_engine
        self.shared = shared
        self.operator = operator
        self.name = name
        self.content = content
        self.id = id
        self.binding_calc_engine_id = binding_calc_engine_id
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.connection_type is not None:
            result['ConnectionType'] = self.connection_type
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.connect_status is not None:
            result['ConnectStatus'] = self.connect_status
        if self.sequence is not None:
            result['Sequence'] = self.sequence
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_engine is not None:
            result['DefaultEngine'] = self.default_engine
        if self.shared is not None:
            result['Shared'] = self.shared
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.name is not None:
            result['Name'] = self.name
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.binding_calc_engine_id is not None:
            result['BindingCalcEngineId'] = self.binding_calc_engine_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ConnectionType') is not None:
            self.connection_type = m.get('ConnectionType')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('ConnectStatus') is not None:
            self.connect_status = m.get('ConnectStatus')
        if m.get('Sequence') is not None:
            self.sequence = m.get('Sequence')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultEngine') is not None:
            self.default_engine = m.get('DefaultEngine')
        if m.get('Shared') is not None:
            self.shared = m.get('Shared')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BindingCalcEngineId') is not None:
            self.binding_calc_engine_id = m.get('BindingCalcEngineId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListConnectionsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        connections: List[ListConnectionsResponseBodyDataConnections] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.connections = connections

    def validate(self):
        if self.connections:
            for k in self.connections:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Connections'] = []
        if self.connections is not None:
            for k in self.connections:
                result['Connections'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.connections = []
        if m.get('Connections') is not None:
            for k in m.get('Connections'):
                temp_model = ListConnectionsResponseBodyDataConnections()
                self.connections.append(temp_model.from_map(k))
        return self


class ListConnectionsResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
        data: ListConnectionsResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Data') is not None:
            temp_model = ListConnectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListConnectionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListConnectionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListConnectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApiAuthoritiesRequest(TeaModel):
    def __init__(
        self,
        project_id: int = None,
        page_number: int = None,
        page_size: int = None,
        tenant_id: int = None,
        api_name_keyword: str = None,
    ):
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size
        self.tenant_id = tenant_id
        self.api_name_keyword = api_name_keyword

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        return self


class ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        creator_id: str = None,
        created_time: str = None,
        project_id: int = None,
    ):
        self.end_time = end_time
        self.creator_id = creator_id
        self.created_time = created_time
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList(TeaModel):
    def __init__(
        self,
        api_status: int = None,
        api_id: int = None,
        modified_time: str = None,
        group_id: str = None,
        project_id: int = None,
        creator_id: str = None,
        created_time: str = None,
        api_name: str = None,
        tenant_id: int = None,
        api_path: str = None,
        authorization_records: List[ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords] = None,
    ):
        self.api_status = api_status
        self.api_id = api_id
        self.modified_time = modified_time
        self.group_id = group_id
        self.project_id = project_id
        self.creator_id = creator_id
        self.created_time = created_time
        self.api_name = api_name
        self.tenant_id = tenant_id
        self.api_path = api_path
        self.authorization_records = authorization_records

    def validate(self):
        if self.authorization_records:
            for k in self.authorization_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_status is not None:
            result['ApiStatus'] = self.api_status
        if self.api_id is not None:
            result['ApiId'] = self.api_id
        if self.modified_time is not None:
            result['ModifiedTime'] = self.modified_time
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.api_name is not None:
            result['ApiName'] = self.api_name
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        result['AuthorizationRecords'] = []
        if self.authorization_records is not None:
            for k in self.authorization_records:
                result['AuthorizationRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApiStatus') is not None:
            self.api_status = m.get('ApiStatus')
        if m.get('ApiId') is not None:
            self.api_id = m.get('ApiId')
        if m.get('ModifiedTime') is not None:
            self.modified_time = m.get('ModifiedTime')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ApiName') is not None:
            self.api_name = m.get('ApiName')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        self.authorization_records = []
        if m.get('AuthorizationRecords') is not None:
            for k in m.get('AuthorizationRecords'):
                temp_model = ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationListAuthorizationRecords()
                self.authorization_records.append(temp_model.from_map(k))
        return self


class ListDataServiceApiAuthoritiesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        api_authorization_list: List[ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.api_authorization_list = api_authorization_list

    def validate(self):
        if self.api_authorization_list:
            for k in self.api_authorization_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['ApiAuthorizationList'] = []
        if self.api_authorization_list is not None:
            for k in self.api_authorization_list:
                result['ApiAuthorizationList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.api_authorization_list = []
        if m.get('ApiAuthorizationList') is not None:
            for k in m.get('ApiAuthorizationList'):
                temp_model = ListDataServiceApiAuthoritiesResponseBodyDataApiAuthorizationList()
                self.api_authorization_list.append(temp_model.from_map(k))
        return self


class ListDataServiceApiAuthoritiesResponseBody(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        request_id: str = None,
        error_message: str = None,
        success: bool = None,
        error_code: str = None,
        data: ListDataServiceApiAuthoritiesResponseBodyData = None,
    ):
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.error_message = error_message
        self.success = success
        self.error_code = error_code
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success is not None:
            result['Success'] = self.success
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Data') is not None:
            temp_model = ListDataServiceApiAuthoritiesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDataServiceApiAuthoritiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDataServiceApiAuthoritiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDataServiceApiAuthoritiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDataServiceApisRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        project_id: int = None,
        tenant_id: int = None,
        api_name_keyword: str = None,
        api_path_keyword: str = None,
        creator_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.project_id = project_id
        self.tenant_id = tenant_id
        self.api_name_keyword = api_name_keyword
        self.api_path_keyword = api_path_keyword
        self.creator_id = creator_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.api_name_keyword is not None:
            result['ApiNameKeyword'] = self.api_name_keyword
        if self.api_path_keyword is not None:
            result['ApiPathKeyword'] = self.api_path_keyword
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('ApiNameKeyword') is not None:
            self.api_name_keyword = m.get('ApiNameKeyword')
        if m.get('ApiPathKeyword') is not None:
            self.api_path_keyword = m.get('ApiPathKeyword')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        error_code: str = None,
        error_solution: str = None,
    ):
        self.error_message = error_message
        self.error_code = error_code
        self.error_solution = error_solution

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_solution is not None:
            result['ErrorSolution'] = self.error_solution
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorSolution') is not None:
            self.error_solution = m.get('ErrorSolution')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        parameter_data_type: int = None,
        example_value: str = None,
        is_required_parameter: bool = None,
    ):
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class ListDataServiceApisResponseBodyDataApisRegistrationDetails(TeaModel):
    def __init__(
        self,
        service_host: str = None,
        service_content_type: int = None,
        service_path: str = None,
        successful_result_sample: str = None,
        failed_result_sample: str = None,
        service_request_body_description: str = None,
        registration_error_codes: List[ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes] = None,
        registration_request_parameters: List[ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters] = None,
    ):
        self.service_host = service_host
        self.service_content_type = service_content_type
        self.service_path = service_path
        self.successful_result_sample = successful_result_sample
        self.failed_result_sample = failed_result_sample
        self.service_request_body_description = service_request_body_description
        self.registration_error_codes = registration_error_codes
        self.registration_request_parameters = registration_request_parameters

    def validate(self):
        if self.registration_error_codes:
            for k in self.registration_error_codes:
                if k:
                    k.validate()
        if self.registration_request_parameters:
            for k in self.registration_request_parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_host is not None:
            result['ServiceHost'] = self.service_host
        if self.service_content_type is not None:
            result['ServiceContentType'] = self.service_content_type
        if self.service_path is not None:
            result['ServicePath'] = self.service_path
        if self.successful_result_sample is not None:
            result['SuccessfulResultSample'] = self.successful_result_sample
        if self.failed_result_sample is not None:
            result['FailedResultSample'] = self.failed_result_sample
        if self.service_request_body_description is not None:
            result['ServiceRequestBodyDescription'] = self.service_request_body_description
        result['RegistrationErrorCodes'] = []
        if self.registration_error_codes is not None:
            for k in self.registration_error_codes:
                result['RegistrationErrorCodes'].append(k.to_map() if k else None)
        result['RegistrationRequestParameters'] = []
        if self.registration_request_parameters is not None:
            for k in self.registration_request_parameters:
                result['RegistrationRequestParameters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceHost') is not None:
            self.service_host = m.get('ServiceHost')
        if m.get('ServiceContentType') is not None:
            self.service_content_type = m.get('ServiceContentType')
        if m.get('ServicePath') is not None:
            self.service_path = m.get('ServicePath')
        if m.get('SuccessfulResultSample') is not None:
            self.successful_result_sample = m.get('SuccessfulResultSample')
        if m.get('FailedResultSample') is not None:
            self.failed_result_sample = m.get('FailedResultSample')
        if m.get('ServiceRequestBodyDescription') is not None:
            self.service_request_body_description = m.get('ServiceRequestBodyDescription')
        self.registration_error_codes = []
        if m.get('RegistrationErrorCodes') is not None:
            for k in m.get('RegistrationErrorCodes'):
                temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationErrorCodes()
                self.registration_error_codes.append(temp_model.from_map(k))
        self.registration_request_parameters = []
        if m.get('RegistrationRequestParameters') is not None:
            for k in m.get('RegistrationRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisRegistrationDetailsRegistrationRequestParameters()
                self.registration_request_parameters.append(temp_model.from_map(k))
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        parameter_data_type: int = None,
        example_value: str = None,
        is_required_parameter: bool = None,
    ):
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        column_name: str = None,
        parameter_name: str = None,
        parameter_data_type: int = None,
        example_value: str = None,
    ):
        self.parameter_description = parameter_description
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        connection_id: int = None,
    ):
        self.table_name = table_name
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self


class ListDataServiceApisResponseBodyDataApisScriptDetails(TeaModel):
    def __init__(
        self,
        script: str = None,
        is_paged_response: bool = None,
        script_request_parameters: List[ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters] = None,
        script_response_parameters: List[ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters] = None,
        script_connection: ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection = None,
    ):
        self.script = script
        self.is_paged_response = is_paged_response
        self.script_request_parameters = script_request_parameters
        self.script_response_parameters = script_response_parameters
        self.script_connection = script_connection

    def validate(self):
        if self.script_request_parameters:
            for k in self.script_request_parameters:
                if k:
                    k.validate()
        if self.script_response_parameters:
            for k in self.script_response_parameters:
                if k:
                    k.validate()
        if self.script_connection:
            self.script_connection.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script is not None:
            result['Script'] = self.script
        if self.is_paged_response is not None:
            result['IsPagedResponse'] = self.is_paged_response
        result['ScriptRequestParameters'] = []
        if self.script_request_parameters is not None:
            for k in self.script_request_parameters:
                result['ScriptRequestParameters'].append(k.to_map() if k else None)
        result['ScriptResponseParameters'] = []
        if self.script_response_parameters is not None:
            for k in self.script_response_parameters:
                result['ScriptResponseParameters'].append(k.to_map() if k else None)
        if self.script_connection is not None:
            result['ScriptConnection'] = self.script_connection.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Script') is not None:
            self.script = m.get('Script')
        if m.get('IsPagedResponse') is not None:
            self.is_paged_response = m.get('IsPagedResponse')
        self.script_request_parameters = []
        if m.get('ScriptRequestParameters') is not None:
            for k in m.get('ScriptRequestParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptRequestParameters()
                self.script_request_parameters.append(temp_model.from_map(k))
        self.script_response_parameters = []
        if m.get('ScriptResponseParameters') is not None:
            for k in m.get('ScriptResponseParameters'):
                temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptResponseParameters()
                self.script_response_parameters.append(temp_model.from_map(k))
        if m.get('ScriptConnection') is not None:
            temp_model = ListDataServiceApisResponseBodyDataApisScriptDetailsScriptConnection()
            self.script_connection = temp_model.from_map(m['ScriptConnection'])
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardRequestParameters(TeaModel):
    def __init__(
        self,
        column_name: str = None,
        parameter_name: str = None,
        parameter_position: int = None,
        parameter_description: str = None,
        default_value: str = None,
        parameter_operator: int = None,
        parameter_data_type: int = None,
        example_value: str = None,
        is_required_parameter: bool = None,
    ):
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_position = parameter_position
        self.parameter_description = parameter_description
        self.default_value = default_value
        self.parameter_operator = parameter_operator
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value
        self.is_required_parameter = is_required_parameter

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_position is not None:
            result['ParameterPosition'] = self.parameter_position
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.parameter_operator is not None:
            result['ParameterOperator'] = self.parameter_operator
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        if self.is_required_parameter is not None:
            result['IsRequiredParameter'] = self.is_required_parameter
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterPosition') is not None:
            self.parameter_position = m.get('ParameterPosition')
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('ParameterOperator') is not None:
            self.parameter_operator = m.get('ParameterOperator')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        if m.get('IsRequiredParameter') is not None:
            self.is_required_parameter = m.get('IsRequiredParameter')
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardResponseParameters(TeaModel):
    def __init__(
        self,
        parameter_description: str = None,
        column_name: str = None,
        parameter_name: str = None,
        parameter_data_type: int = None,
        example_value: str = None,
    ):
        self.parameter_description = parameter_description
        self.column_name = column_name
        self.parameter_name = parameter_name
        self.parameter_data_type = parameter_data_type
        self.example_value = example_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_description is not None:
            result['ParameterDescription'] = self.parameter_description
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.parameter_data_type is not None:
            result['ParameterDataType'] = self.parameter_data_type
        if self.example_value is not None:
            result['ExampleValue'] = self.example_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParameterDescription') is not None:
            self.parameter_description = m.get('ParameterDescription')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('ParameterDataType') is not None:
            self.parameter_data_type = m.get('ParameterDataType')
        if m.get('ExampleValue') is not None:
            self.example_value = m.get('ExampleValue')
        return self


class ListDataServiceApisResponseBodyDataApisWizardDetailsWizardConnection(TeaModel):
    def __init__(
        self,
        table_name: str = None,
        connection_id: int = None,
    ):
        self.table_name = table_name
        self.connection_id = connection_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        return self