# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: proto/secret/v1/secret.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Dict

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


@dataclass(eq=False, repr=False)
class SecretPutRequest(betterproto.Message):
    """Request to put a secret to a Secret Store"""

    # The Secret to put to the Secret store
    secret: "Secret" = betterproto.message_field(1)
    # The value to assign to that secret
    value: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class SecretPutResponse(betterproto.Message):
    """Result from putting the secret to a Secret Store"""

    # The id of the secret
    secret_version: "SecretVersion" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SecretAccessRequest(betterproto.Message):
    """Request to get a secret from a Secret Store"""

    # The id of the secret
    secret_version: "SecretVersion" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SecretAccessResponse(betterproto.Message):
    """The secret response"""

    # The version of the secret that was requested
    secret_version: "SecretVersion" = betterproto.message_field(1)
    # The value of the secret
    value: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class Secret(betterproto.Message):
    """The secret container"""

    # The secret name
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class SecretVersion(betterproto.Message):
    """A version of a secret"""

    # Reference to the secret container
    secret: "Secret" = betterproto.message_field(1)
    # The secret version
    version: str = betterproto.string_field(2)


class SecretServiceStub(betterproto.ServiceStub):
    async def put(
        self, *, secret: "Secret" = None, value: bytes = b""
    ) -> "SecretPutResponse":

        request = SecretPutRequest()
        if secret is not None:
            request.secret = secret
        request.value = value

        return await self._unary_unary(
            "/nitric.secret.v1.SecretService/Put", request, SecretPutResponse
        )

    async def access(
        self, *, secret_version: "SecretVersion" = None
    ) -> "SecretAccessResponse":

        request = SecretAccessRequest()
        if secret_version is not None:
            request.secret_version = secret_version

        return await self._unary_unary(
            "/nitric.secret.v1.SecretService/Access", request, SecretAccessResponse
        )


class SecretServiceBase(ServiceBase):
    async def put(self, secret: "Secret", value: bytes) -> "SecretPutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def access(self, secret_version: "SecretVersion") -> "SecretAccessResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_put(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "secret": request.secret,
            "value": request.value,
        }

        response = await self.put(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_access(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {
            "secret_version": request.secret_version,
        }

        response = await self.access(**request_kwargs)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/nitric.secret.v1.SecretService/Put": grpclib.const.Handler(
                self.__rpc_put,
                grpclib.const.Cardinality.UNARY_UNARY,
                SecretPutRequest,
                SecretPutResponse,
            ),
            "/nitric.secret.v1.SecretService/Access": grpclib.const.Handler(
                self.__rpc_access,
                grpclib.const.Cardinality.UNARY_UNARY,
                SecretAccessRequest,
                SecretAccessResponse,
            ),
        }
