"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flatMap = exports.deepRemoveUndefined = exports.dropIfEmpty = exports.makeComparator = void 0;
/**
 * Turn a (multi-key) extraction function into a comparator for use in Array.sort()
 */
function makeComparator(keyFn) {
    return (a, b) => {
        const keyA = keyFn(a);
        const keyB = keyFn(b);
        const len = Math.min(keyA.length, keyB.length);
        for (let i = 0; i < len; i++) {
            const c = compare(keyA[i], keyB[i]);
            if (c !== 0) {
                return c;
            }
        }
        // Arrays are the same up to the min length -- shorter array sorts first
        return keyA.length - keyB.length;
    };
}
exports.makeComparator = makeComparator;
function compare(a, b) {
    if (a < b) {
        return -1;
    }
    if (b < a) {
        return 1;
    }
    return 0;
}
function dropIfEmpty(xs) {
    return xs.length > 0 ? xs : undefined;
}
exports.dropIfEmpty = dropIfEmpty;
function deepRemoveUndefined(x) {
    if (typeof x === undefined || x === null) {
        return x;
    }
    if (Array.isArray(x)) {
        return x.map(deepRemoveUndefined);
    }
    if (typeof x === 'object') {
        for (const [key, value] of Object.entries(x)) {
            x[key] = deepRemoveUndefined(value);
            if (x[key] === undefined) {
                delete x[key];
            }
        }
        return x;
    }
    return x;
}
exports.deepRemoveUndefined = deepRemoveUndefined;
function flatMap(xs, f) {
    const ret = new Array();
    for (const x of xs) {
        ret.push(...f(x));
    }
    return ret;
}
exports.flatMap = flatMap;
//# sourceMappingURL=data:application/json;base64,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