"use strict";
/* eslint-disable no-console */
/**
 * Report on spec fragment files that are being held back.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const fs = require("fs-extra");
async function main(args) {
    if (args.length < 2) {
        throw new Error('Usage: report-issues <DIR> <FORMAT>');
    }
    const [dir, format] = args;
    const officialVersion = (await fs.readJson(path.join(dir, '001_Version.json'))).ResourceSpecificationVersion;
    let headerPrinted = false;
    for (const file of await fs.readdir(dir)) {
        if (!file.startsWith('000_')) {
            continue;
        }
        const json = await fs.readJson(path.join(dir, file));
        const fragmentVersion = json.$version;
        switch (format) {
            case 'outdated':
                if (fragmentVersion !== officialVersion) {
                    if (!headerPrinted) {
                        console.log('## Unapplied changes');
                        console.log('');
                        headerPrinted = true;
                    }
                    const serviceName = file.replace(/^000_/, '').replace(/\.json$/, '').replace('_', '::');
                    console.log(`* ${serviceName} is at ${fragmentVersion}`);
                }
                break;
            default:
                throw new Error(`Unknown format type requested: ${format}`);
        }
    }
}
main(process.argv.slice(2)).catch(e => {
    // eslint-disable-next-line no-console
    console.error(e);
    process.exitCode = 1;
});
//# sourceMappingURL=data:application/json;base64,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