"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expect = void 0;
const cdk = require("aws-cdk-lib");
const api = require("aws-cdk-lib/cx-api");
const inspector_1 = require("./inspector");
const synth_utils_1 = require("./synth-utils");
function expect(stack, skipValidation = false) {
    // if this is already a synthesized stack, then just inspect it.
    const artifact = stack instanceof api.CloudFormationStackArtifact ? stack
        : cdk.Stack.isStack(stack) ? synth_utils_1.SynthUtils._synthesizeWithNested(stack, { skipValidation })
            : stack; // This is a template already
    return new inspector_1.StackInspector(artifact);
}
exports.expect = expect;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhwZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhwZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLG1DQUFtQztBQUNuQywwQ0FBMEM7QUFDMUMsMkNBQTZDO0FBQzdDLCtDQUEyQztBQUUzQyxTQUFnQixNQUFNLENBQUMsS0FBd0UsRUFBRSxjQUFjLEdBQUcsS0FBSztJQUNySCxnRUFBZ0U7SUFDaEUsTUFBTSxRQUFRLEdBQUcsS0FBSyxZQUFZLEdBQUcsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUMsS0FBSztRQUN2RSxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLHdCQUFVLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLEVBQUUsY0FBYyxFQUFFLENBQUM7WUFDdEYsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLDZCQUE2QjtJQUMxQyxPQUFPLElBQUksMEJBQWMsQ0FBQyxRQUFRLENBQUMsQ0FBQztBQUN0QyxDQUFDO0FBTkQsd0JBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgYXBpIGZyb20gJ2F3cy1jZGstbGliL2N4LWFwaSc7XG5pbXBvcnQgeyBTdGFja0luc3BlY3RvciB9IGZyb20gJy4vaW5zcGVjdG9yJztcbmltcG9ydCB7IFN5bnRoVXRpbHMgfSBmcm9tICcuL3N5bnRoLXV0aWxzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGV4cGVjdChzdGFjazogYXBpLkNsb3VkRm9ybWF0aW9uU3RhY2tBcnRpZmFjdCB8IGNkay5TdGFjayB8IFJlY29yZDxzdHJpbmcsIGFueT4sIHNraXBWYWxpZGF0aW9uID0gZmFsc2UpOiBTdGFja0luc3BlY3RvciB7XG4gIC8vIGlmIHRoaXMgaXMgYWxyZWFkeSBhIHN5bnRoZXNpemVkIHN0YWNrLCB0aGVuIGp1c3QgaW5zcGVjdCBpdC5cbiAgY29uc3QgYXJ0aWZhY3QgPSBzdGFjayBpbnN0YW5jZW9mIGFwaS5DbG91ZEZvcm1hdGlvblN0YWNrQXJ0aWZhY3QgPyBzdGFja1xuICAgIDogY2RrLlN0YWNrLmlzU3RhY2soc3RhY2spID8gU3ludGhVdGlscy5fc3ludGhlc2l6ZVdpdGhOZXN0ZWQoc3RhY2ssIHsgc2tpcFZhbGlkYXRpb24gfSlcbiAgICAgIDogc3RhY2s7IC8vIFRoaXMgaXMgYSB0ZW1wbGF0ZSBhbHJlYWR5XG4gIHJldHVybiBuZXcgU3RhY2tJbnNwZWN0b3IoYXJ0aWZhY3QpO1xufVxuIl19