# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class PivotTable(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'Link',
        'show_pivot_style_last_column': 'bool',
        'row_header_caption': 'str',
        'column_range': 'CellArea',
        'refresh_data_on_opening_file': 'bool',
        'page_fields': 'list[PivotField]',
        'data_fields': 'list[PivotField]',
        'data_body_range': 'CellArea',
        'show_drill': 'bool',
        'refresh_data_flag': 'bool',
        'column_grand': 'bool',
        'pivot_table_style_name': 'str',
        'pivot_filters': 'list[PivotFilter]',
        'null_string': 'str',
        'item_print_titles': 'bool',
        'display_null_string': 'bool',
        'enable_field_list': 'bool',
        'table_range2': 'CellArea',
        'row_fields': 'list[PivotField]',
        'page_field_order': 'str',
        'auto_format_type': 'str',
        'enable_data_value_editing': 'bool',
        'show_pivot_style_row_header': 'bool',
        'is_grid_drop_zones': 'bool',
        'enable_wizard': 'bool',
        'show_member_property_tips': 'bool',
        'alt_text_description': 'str',
        'show_data_tips': 'bool',
        'print_titles': 'bool',
        'table_range1': 'CellArea',
        'show_empty_row': 'bool',
        'is_multiple_field_filters': 'bool',
        'show_empty_col': 'bool',
        'show_row_header_caption': 'bool',
        'has_blank_rows': 'bool',
        'data_source': 'list[str]',
        'tag': 'str',
        'enable_drilldown': 'bool',
        'indent': 'int',
        'name': 'str',
        'row_grand': 'bool',
        'grand_total_name': 'str',
        'display_error_string': 'bool',
        'row_range': 'CellArea',
        'is_selected': 'bool',
        'column_fields': 'list[PivotField]',
        'column_header_caption': 'str',
        'show_values_row': 'bool',
        'enable_field_dialog': 'bool',
        'missing_items_limit': 'str',
        'show_pivot_style_row_stripes': 'bool',
        'manual_update': 'bool',
        'is_auto_format': 'bool',
        'display_immediate_items': 'bool',
        'error_string': 'str',
        'custom_list_sort': 'bool',
        'merge_labels': 'bool',
        'page_field_wrap_count': 'int',
        'show_pivot_style_column_stripes': 'bool',
        'field_list_sort_ascending': 'bool',
        'alt_text_title': 'str',
        'preserve_formatting': 'bool',
        'pivot_table_style_type': 'str',
        'data_field': 'PivotField',
        'save_data': 'bool',
        'subtotal_hidden_page_items': 'bool',
        'print_drill': 'bool',
        'show_pivot_style_column_header': 'bool',
        'base_fields': 'list[PivotField]'
    }

    attribute_map = {
        'link': 'link',
        'show_pivot_style_last_column': 'ShowPivotStyleLastColumn',
        'row_header_caption': 'RowHeaderCaption',
        'column_range': 'ColumnRange',
        'refresh_data_on_opening_file': 'RefreshDataOnOpeningFile',
        'page_fields': 'PageFields',
        'data_fields': 'DataFields',
        'data_body_range': 'DataBodyRange',
        'show_drill': 'ShowDrill',
        'refresh_data_flag': 'RefreshDataFlag',
        'column_grand': 'ColumnGrand',
        'pivot_table_style_name': 'PivotTableStyleName',
        'pivot_filters': 'PivotFilters',
        'null_string': 'NullString',
        'item_print_titles': 'ItemPrintTitles',
        'display_null_string': 'DisplayNullString',
        'enable_field_list': 'EnableFieldList',
        'table_range2': 'TableRange2',
        'row_fields': 'RowFields',
        'page_field_order': 'PageFieldOrder',
        'auto_format_type': 'AutoFormatType',
        'enable_data_value_editing': 'EnableDataValueEditing',
        'show_pivot_style_row_header': 'ShowPivotStyleRowHeader',
        'is_grid_drop_zones': 'IsGridDropZones',
        'enable_wizard': 'EnableWizard',
        'show_member_property_tips': 'ShowMemberPropertyTips',
        'alt_text_description': 'AltTextDescription',
        'show_data_tips': 'ShowDataTips',
        'print_titles': 'PrintTitles',
        'table_range1': 'TableRange1',
        'show_empty_row': 'ShowEmptyRow',
        'is_multiple_field_filters': 'IsMultipleFieldFilters',
        'show_empty_col': 'ShowEmptyCol',
        'show_row_header_caption': 'ShowRowHeaderCaption',
        'has_blank_rows': 'HasBlankRows',
        'data_source': 'DataSource',
        'tag': 'Tag',
        'enable_drilldown': 'EnableDrilldown',
        'indent': 'Indent',
        'name': 'Name',
        'row_grand': 'RowGrand',
        'grand_total_name': 'GrandTotalName',
        'display_error_string': 'DisplayErrorString',
        'row_range': 'RowRange',
        'is_selected': 'IsSelected',
        'column_fields': 'ColumnFields',
        'column_header_caption': 'ColumnHeaderCaption',
        'show_values_row': 'ShowValuesRow',
        'enable_field_dialog': 'EnableFieldDialog',
        'missing_items_limit': 'MissingItemsLimit',
        'show_pivot_style_row_stripes': 'ShowPivotStyleRowStripes',
        'manual_update': 'ManualUpdate',
        'is_auto_format': 'IsAutoFormat',
        'display_immediate_items': 'DisplayImmediateItems',
        'error_string': 'ErrorString',
        'custom_list_sort': 'CustomListSort',
        'merge_labels': 'MergeLabels',
        'page_field_wrap_count': 'PageFieldWrapCount',
        'show_pivot_style_column_stripes': 'ShowPivotStyleColumnStripes',
        'field_list_sort_ascending': 'FieldListSortAscending',
        'alt_text_title': 'AltTextTitle',
        'preserve_formatting': 'PreserveFormatting',
        'pivot_table_style_type': 'PivotTableStyleType',
        'data_field': 'DataField',
        'save_data': 'SaveData',
        'subtotal_hidden_page_items': 'SubtotalHiddenPageItems',
        'print_drill': 'PrintDrill',
        'show_pivot_style_column_header': 'ShowPivotStyleColumnHeader',
        'base_fields': 'BaseFields'
    }
    
    @staticmethod
    def get_swagger_types():
        return PivotTable.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return PivotTable.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, link=None, show_pivot_style_last_column=None, row_header_caption=None, column_range=None, refresh_data_on_opening_file=None, page_fields=None, data_fields=None, data_body_range=None, show_drill=None, refresh_data_flag=None, column_grand=None, pivot_table_style_name=None, pivot_filters=None, null_string=None, item_print_titles=None, display_null_string=None, enable_field_list=None, table_range2=None, row_fields=None, page_field_order=None, auto_format_type=None, enable_data_value_editing=None, show_pivot_style_row_header=None, is_grid_drop_zones=None, enable_wizard=None, show_member_property_tips=None, alt_text_description=None, show_data_tips=None, print_titles=None, table_range1=None, show_empty_row=None, is_multiple_field_filters=None, show_empty_col=None, show_row_header_caption=None, has_blank_rows=None, data_source=None, tag=None, enable_drilldown=None, indent=None, name=None, row_grand=None, grand_total_name=None, display_error_string=None, row_range=None, is_selected=None, column_fields=None, column_header_caption=None, show_values_row=None, enable_field_dialog=None, missing_items_limit=None, show_pivot_style_row_stripes=None, manual_update=None, is_auto_format=None, display_immediate_items=None, error_string=None, custom_list_sort=None, merge_labels=None, page_field_wrap_count=None, show_pivot_style_column_stripes=None, field_list_sort_ascending=None, alt_text_title=None, preserve_formatting=None, pivot_table_style_type=None, data_field=None, save_data=None, subtotal_hidden_page_items=None, print_drill=None, show_pivot_style_column_header=None, base_fields=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        PivotTable - a model defined in Swagger
        """

        self.container['link'] = None
        self.container['show_pivot_style_last_column'] = None
        self.container['row_header_caption'] = None
        self.container['column_range'] = None
        self.container['refresh_data_on_opening_file'] = None
        self.container['page_fields'] = None
        self.container['data_fields'] = None
        self.container['data_body_range'] = None
        self.container['show_drill'] = None
        self.container['refresh_data_flag'] = None
        self.container['column_grand'] = None
        self.container['pivot_table_style_name'] = None
        self.container['pivot_filters'] = None
        self.container['null_string'] = None
        self.container['item_print_titles'] = None
        self.container['display_null_string'] = None
        self.container['enable_field_list'] = None
        self.container['table_range2'] = None
        self.container['row_fields'] = None
        self.container['page_field_order'] = None
        self.container['auto_format_type'] = None
        self.container['enable_data_value_editing'] = None
        self.container['show_pivot_style_row_header'] = None
        self.container['is_grid_drop_zones'] = None
        self.container['enable_wizard'] = None
        self.container['show_member_property_tips'] = None
        self.container['alt_text_description'] = None
        self.container['show_data_tips'] = None
        self.container['print_titles'] = None
        self.container['table_range1'] = None
        self.container['show_empty_row'] = None
        self.container['is_multiple_field_filters'] = None
        self.container['show_empty_col'] = None
        self.container['show_row_header_caption'] = None
        self.container['has_blank_rows'] = None
        self.container['data_source'] = None
        self.container['tag'] = None
        self.container['enable_drilldown'] = None
        self.container['indent'] = None
        self.container['name'] = None
        self.container['row_grand'] = None
        self.container['grand_total_name'] = None
        self.container['display_error_string'] = None
        self.container['row_range'] = None
        self.container['is_selected'] = None
        self.container['column_fields'] = None
        self.container['column_header_caption'] = None
        self.container['show_values_row'] = None
        self.container['enable_field_dialog'] = None
        self.container['missing_items_limit'] = None
        self.container['show_pivot_style_row_stripes'] = None
        self.container['manual_update'] = None
        self.container['is_auto_format'] = None
        self.container['display_immediate_items'] = None
        self.container['error_string'] = None
        self.container['custom_list_sort'] = None
        self.container['merge_labels'] = None
        self.container['page_field_wrap_count'] = None
        self.container['show_pivot_style_column_stripes'] = None
        self.container['field_list_sort_ascending'] = None
        self.container['alt_text_title'] = None
        self.container['preserve_formatting'] = None
        self.container['pivot_table_style_type'] = None
        self.container['data_field'] = None
        self.container['save_data'] = None
        self.container['subtotal_hidden_page_items'] = None
        self.container['print_drill'] = None
        self.container['show_pivot_style_column_header'] = None
        self.container['base_fields'] = None

        if link is not None:
          self.link = link
        if show_pivot_style_last_column is not None:
          self.show_pivot_style_last_column = show_pivot_style_last_column
        if row_header_caption is not None:
          self.row_header_caption = row_header_caption
        if column_range is not None:
          self.column_range = column_range
        if refresh_data_on_opening_file is not None:
          self.refresh_data_on_opening_file = refresh_data_on_opening_file
        if page_fields is not None:
          self.page_fields = page_fields
        if data_fields is not None:
          self.data_fields = data_fields
        if data_body_range is not None:
          self.data_body_range = data_body_range
        if show_drill is not None:
          self.show_drill = show_drill
        if refresh_data_flag is not None:
          self.refresh_data_flag = refresh_data_flag
        if column_grand is not None:
          self.column_grand = column_grand
        if pivot_table_style_name is not None:
          self.pivot_table_style_name = pivot_table_style_name
        if pivot_filters is not None:
          self.pivot_filters = pivot_filters
        if null_string is not None:
          self.null_string = null_string
        if item_print_titles is not None:
          self.item_print_titles = item_print_titles
        if display_null_string is not None:
          self.display_null_string = display_null_string
        if enable_field_list is not None:
          self.enable_field_list = enable_field_list
        if table_range2 is not None:
          self.table_range2 = table_range2
        if row_fields is not None:
          self.row_fields = row_fields
        if page_field_order is not None:
          self.page_field_order = page_field_order
        if auto_format_type is not None:
          self.auto_format_type = auto_format_type
        if enable_data_value_editing is not None:
          self.enable_data_value_editing = enable_data_value_editing
        if show_pivot_style_row_header is not None:
          self.show_pivot_style_row_header = show_pivot_style_row_header
        if is_grid_drop_zones is not None:
          self.is_grid_drop_zones = is_grid_drop_zones
        if enable_wizard is not None:
          self.enable_wizard = enable_wizard
        if show_member_property_tips is not None:
          self.show_member_property_tips = show_member_property_tips
        if alt_text_description is not None:
          self.alt_text_description = alt_text_description
        if show_data_tips is not None:
          self.show_data_tips = show_data_tips
        if print_titles is not None:
          self.print_titles = print_titles
        if table_range1 is not None:
          self.table_range1 = table_range1
        if show_empty_row is not None:
          self.show_empty_row = show_empty_row
        if is_multiple_field_filters is not None:
          self.is_multiple_field_filters = is_multiple_field_filters
        if show_empty_col is not None:
          self.show_empty_col = show_empty_col
        if show_row_header_caption is not None:
          self.show_row_header_caption = show_row_header_caption
        if has_blank_rows is not None:
          self.has_blank_rows = has_blank_rows
        if data_source is not None:
          self.data_source = data_source
        if tag is not None:
          self.tag = tag
        if enable_drilldown is not None:
          self.enable_drilldown = enable_drilldown
        if indent is not None:
          self.indent = indent
        if name is not None:
          self.name = name
        if row_grand is not None:
          self.row_grand = row_grand
        if grand_total_name is not None:
          self.grand_total_name = grand_total_name
        if display_error_string is not None:
          self.display_error_string = display_error_string
        if row_range is not None:
          self.row_range = row_range
        if is_selected is not None:
          self.is_selected = is_selected
        if column_fields is not None:
          self.column_fields = column_fields
        if column_header_caption is not None:
          self.column_header_caption = column_header_caption
        if show_values_row is not None:
          self.show_values_row = show_values_row
        if enable_field_dialog is not None:
          self.enable_field_dialog = enable_field_dialog
        if missing_items_limit is not None:
          self.missing_items_limit = missing_items_limit
        if show_pivot_style_row_stripes is not None:
          self.show_pivot_style_row_stripes = show_pivot_style_row_stripes
        if manual_update is not None:
          self.manual_update = manual_update
        if is_auto_format is not None:
          self.is_auto_format = is_auto_format
        if display_immediate_items is not None:
          self.display_immediate_items = display_immediate_items
        if error_string is not None:
          self.error_string = error_string
        if custom_list_sort is not None:
          self.custom_list_sort = custom_list_sort
        if merge_labels is not None:
          self.merge_labels = merge_labels
        if page_field_wrap_count is not None:
          self.page_field_wrap_count = page_field_wrap_count
        if show_pivot_style_column_stripes is not None:
          self.show_pivot_style_column_stripes = show_pivot_style_column_stripes
        if field_list_sort_ascending is not None:
          self.field_list_sort_ascending = field_list_sort_ascending
        if alt_text_title is not None:
          self.alt_text_title = alt_text_title
        if preserve_formatting is not None:
          self.preserve_formatting = preserve_formatting
        if pivot_table_style_type is not None:
          self.pivot_table_style_type = pivot_table_style_type
        if data_field is not None:
          self.data_field = data_field
        if save_data is not None:
          self.save_data = save_data
        if subtotal_hidden_page_items is not None:
          self.subtotal_hidden_page_items = subtotal_hidden_page_items
        if print_drill is not None:
          self.print_drill = print_drill
        if show_pivot_style_column_header is not None:
          self.show_pivot_style_column_header = show_pivot_style_column_header
        if base_fields is not None:
          self.base_fields = base_fields

    @property
    def link(self):
        """
        Gets the link of this PivotTable.

        :return: The link of this PivotTable.
        :rtype: Link
        """
        return self.container['link']

    @link.setter
    def link(self, link):
        """
        Sets the link of this PivotTable.

        :param link: The link of this PivotTable.
        :type: Link
        """

        self.container['link'] = link

    @property
    def show_pivot_style_last_column(self):
        """
        Gets the show_pivot_style_last_column of this PivotTable.

        :return: The show_pivot_style_last_column of this PivotTable.
        :rtype: bool
        """
        return self.container['show_pivot_style_last_column']

    @show_pivot_style_last_column.setter
    def show_pivot_style_last_column(self, show_pivot_style_last_column):
        """
        Sets the show_pivot_style_last_column of this PivotTable.

        :param show_pivot_style_last_column: The show_pivot_style_last_column of this PivotTable.
        :type: bool
        """

        self.container['show_pivot_style_last_column'] = show_pivot_style_last_column

    @property
    def row_header_caption(self):
        """
        Gets the row_header_caption of this PivotTable.

        :return: The row_header_caption of this PivotTable.
        :rtype: str
        """
        return self.container['row_header_caption']

    @row_header_caption.setter
    def row_header_caption(self, row_header_caption):
        """
        Sets the row_header_caption of this PivotTable.

        :param row_header_caption: The row_header_caption of this PivotTable.
        :type: str
        """

        self.container['row_header_caption'] = row_header_caption

    @property
    def column_range(self):
        """
        Gets the column_range of this PivotTable.

        :return: The column_range of this PivotTable.
        :rtype: CellArea
        """
        return self.container['column_range']

    @column_range.setter
    def column_range(self, column_range):
        """
        Sets the column_range of this PivotTable.

        :param column_range: The column_range of this PivotTable.
        :type: CellArea
        """

        self.container['column_range'] = column_range

    @property
    def refresh_data_on_opening_file(self):
        """
        Gets the refresh_data_on_opening_file of this PivotTable.

        :return: The refresh_data_on_opening_file of this PivotTable.
        :rtype: bool
        """
        return self.container['refresh_data_on_opening_file']

    @refresh_data_on_opening_file.setter
    def refresh_data_on_opening_file(self, refresh_data_on_opening_file):
        """
        Sets the refresh_data_on_opening_file of this PivotTable.

        :param refresh_data_on_opening_file: The refresh_data_on_opening_file of this PivotTable.
        :type: bool
        """

        self.container['refresh_data_on_opening_file'] = refresh_data_on_opening_file

    @property
    def page_fields(self):
        """
        Gets the page_fields of this PivotTable.

        :return: The page_fields of this PivotTable.
        :rtype: list[PivotField]
        """
        return self.container['page_fields']

    @page_fields.setter
    def page_fields(self, page_fields):
        """
        Sets the page_fields of this PivotTable.

        :param page_fields: The page_fields of this PivotTable.
        :type: list[PivotField]
        """

        self.container['page_fields'] = page_fields

    @property
    def data_fields(self):
        """
        Gets the data_fields of this PivotTable.

        :return: The data_fields of this PivotTable.
        :rtype: list[PivotField]
        """
        return self.container['data_fields']

    @data_fields.setter
    def data_fields(self, data_fields):
        """
        Sets the data_fields of this PivotTable.

        :param data_fields: The data_fields of this PivotTable.
        :type: list[PivotField]
        """

        self.container['data_fields'] = data_fields

    @property
    def data_body_range(self):
        """
        Gets the data_body_range of this PivotTable.

        :return: The data_body_range of this PivotTable.
        :rtype: CellArea
        """
        return self.container['data_body_range']

    @data_body_range.setter
    def data_body_range(self, data_body_range):
        """
        Sets the data_body_range of this PivotTable.

        :param data_body_range: The data_body_range of this PivotTable.
        :type: CellArea
        """

        self.container['data_body_range'] = data_body_range

    @property
    def show_drill(self):
        """
        Gets the show_drill of this PivotTable.

        :return: The show_drill of this PivotTable.
        :rtype: bool
        """
        return self.container['show_drill']

    @show_drill.setter
    def show_drill(self, show_drill):
        """
        Sets the show_drill of this PivotTable.

        :param show_drill: The show_drill of this PivotTable.
        :type: bool
        """

        self.container['show_drill'] = show_drill

    @property
    def refresh_data_flag(self):
        """
        Gets the refresh_data_flag of this PivotTable.

        :return: The refresh_data_flag of this PivotTable.
        :rtype: bool
        """
        return self.container['refresh_data_flag']

    @refresh_data_flag.setter
    def refresh_data_flag(self, refresh_data_flag):
        """
        Sets the refresh_data_flag of this PivotTable.

        :param refresh_data_flag: The refresh_data_flag of this PivotTable.
        :type: bool
        """

        self.container['refresh_data_flag'] = refresh_data_flag

    @property
    def column_grand(self):
        """
        Gets the column_grand of this PivotTable.

        :return: The column_grand of this PivotTable.
        :rtype: bool
        """
        return self.container['column_grand']

    @column_grand.setter
    def column_grand(self, column_grand):
        """
        Sets the column_grand of this PivotTable.

        :param column_grand: The column_grand of this PivotTable.
        :type: bool
        """

        self.container['column_grand'] = column_grand

    @property
    def pivot_table_style_name(self):
        """
        Gets the pivot_table_style_name of this PivotTable.

        :return: The pivot_table_style_name of this PivotTable.
        :rtype: str
        """
        return self.container['pivot_table_style_name']

    @pivot_table_style_name.setter
    def pivot_table_style_name(self, pivot_table_style_name):
        """
        Sets the pivot_table_style_name of this PivotTable.

        :param pivot_table_style_name: The pivot_table_style_name of this PivotTable.
        :type: str
        """

        self.container['pivot_table_style_name'] = pivot_table_style_name

    @property
    def pivot_filters(self):
        """
        Gets the pivot_filters of this PivotTable.

        :return: The pivot_filters of this PivotTable.
        :rtype: list[PivotFilter]
        """
        return self.container['pivot_filters']

    @pivot_filters.setter
    def pivot_filters(self, pivot_filters):
        """
        Sets the pivot_filters of this PivotTable.

        :param pivot_filters: The pivot_filters of this PivotTable.
        :type: list[PivotFilter]
        """

        self.container['pivot_filters'] = pivot_filters

    @property
    def null_string(self):
        """
        Gets the null_string of this PivotTable.

        :return: The null_string of this PivotTable.
        :rtype: str
        """
        return self.container['null_string']

    @null_string.setter
    def null_string(self, null_string):
        """
        Sets the null_string of this PivotTable.

        :param null_string: The null_string of this PivotTable.
        :type: str
        """

        self.container['null_string'] = null_string

    @property
    def item_print_titles(self):
        """
        Gets the item_print_titles of this PivotTable.

        :return: The item_print_titles of this PivotTable.
        :rtype: bool
        """
        return self.container['item_print_titles']

    @item_print_titles.setter
    def item_print_titles(self, item_print_titles):
        """
        Sets the item_print_titles of this PivotTable.

        :param item_print_titles: The item_print_titles of this PivotTable.
        :type: bool
        """

        self.container['item_print_titles'] = item_print_titles

    @property
    def display_null_string(self):
        """
        Gets the display_null_string of this PivotTable.

        :return: The display_null_string of this PivotTable.
        :rtype: bool
        """
        return self.container['display_null_string']

    @display_null_string.setter
    def display_null_string(self, display_null_string):
        """
        Sets the display_null_string of this PivotTable.

        :param display_null_string: The display_null_string of this PivotTable.
        :type: bool
        """

        self.container['display_null_string'] = display_null_string

    @property
    def enable_field_list(self):
        """
        Gets the enable_field_list of this PivotTable.

        :return: The enable_field_list of this PivotTable.
        :rtype: bool
        """
        return self.container['enable_field_list']

    @enable_field_list.setter
    def enable_field_list(self, enable_field_list):
        """
        Sets the enable_field_list of this PivotTable.

        :param enable_field_list: The enable_field_list of this PivotTable.
        :type: bool
        """

        self.container['enable_field_list'] = enable_field_list

    @property
    def table_range2(self):
        """
        Gets the table_range2 of this PivotTable.

        :return: The table_range2 of this PivotTable.
        :rtype: CellArea
        """
        return self.container['table_range2']

    @table_range2.setter
    def table_range2(self, table_range2):
        """
        Sets the table_range2 of this PivotTable.

        :param table_range2: The table_range2 of this PivotTable.
        :type: CellArea
        """

        self.container['table_range2'] = table_range2

    @property
    def row_fields(self):
        """
        Gets the row_fields of this PivotTable.

        :return: The row_fields of this PivotTable.
        :rtype: list[PivotField]
        """
        return self.container['row_fields']

    @row_fields.setter
    def row_fields(self, row_fields):
        """
        Sets the row_fields of this PivotTable.

        :param row_fields: The row_fields of this PivotTable.
        :type: list[PivotField]
        """

        self.container['row_fields'] = row_fields

    @property
    def page_field_order(self):
        """
        Gets the page_field_order of this PivotTable.

        :return: The page_field_order of this PivotTable.
        :rtype: str
        """
        return self.container['page_field_order']

    @page_field_order.setter
    def page_field_order(self, page_field_order):
        """
        Sets the page_field_order of this PivotTable.

        :param page_field_order: The page_field_order of this PivotTable.
        :type: str
        """

        self.container['page_field_order'] = page_field_order

    @property
    def auto_format_type(self):
        """
        Gets the auto_format_type of this PivotTable.

        :return: The auto_format_type of this PivotTable.
        :rtype: str
        """
        return self.container['auto_format_type']

    @auto_format_type.setter
    def auto_format_type(self, auto_format_type):
        """
        Sets the auto_format_type of this PivotTable.

        :param auto_format_type: The auto_format_type of this PivotTable.
        :type: str
        """

        self.container['auto_format_type'] = auto_format_type

    @property
    def enable_data_value_editing(self):
        """
        Gets the enable_data_value_editing of this PivotTable.

        :return: The enable_data_value_editing of this PivotTable.
        :rtype: bool
        """
        return self.container['enable_data_value_editing']

    @enable_data_value_editing.setter
    def enable_data_value_editing(self, enable_data_value_editing):
        """
        Sets the enable_data_value_editing of this PivotTable.

        :param enable_data_value_editing: The enable_data_value_editing of this PivotTable.
        :type: bool
        """

        self.container['enable_data_value_editing'] = enable_data_value_editing

    @property
    def show_pivot_style_row_header(self):
        """
        Gets the show_pivot_style_row_header of this PivotTable.

        :return: The show_pivot_style_row_header of this PivotTable.
        :rtype: bool
        """
        return self.container['show_pivot_style_row_header']

    @show_pivot_style_row_header.setter
    def show_pivot_style_row_header(self, show_pivot_style_row_header):
        """
        Sets the show_pivot_style_row_header of this PivotTable.

        :param show_pivot_style_row_header: The show_pivot_style_row_header of this PivotTable.
        :type: bool
        """

        self.container['show_pivot_style_row_header'] = show_pivot_style_row_header

    @property
    def is_grid_drop_zones(self):
        """
        Gets the is_grid_drop_zones of this PivotTable.

        :return: The is_grid_drop_zones of this PivotTable.
        :rtype: bool
        """
        return self.container['is_grid_drop_zones']

    @is_grid_drop_zones.setter
    def is_grid_drop_zones(self, is_grid_drop_zones):
        """
        Sets the is_grid_drop_zones of this PivotTable.

        :param is_grid_drop_zones: The is_grid_drop_zones of this PivotTable.
        :type: bool
        """

        self.container['is_grid_drop_zones'] = is_grid_drop_zones

    @property
    def enable_wizard(self):
        """
        Gets the enable_wizard of this PivotTable.

        :return: The enable_wizard of this PivotTable.
        :rtype: bool
        """
        return self.container['enable_wizard']

    @enable_wizard.setter
    def enable_wizard(self, enable_wizard):
        """
        Sets the enable_wizard of this PivotTable.

        :param enable_wizard: The enable_wizard of this PivotTable.
        :type: bool
        """

        self.container['enable_wizard'] = enable_wizard

    @property
    def show_member_property_tips(self):
        """
        Gets the show_member_property_tips of this PivotTable.

        :return: The show_member_property_tips of this PivotTable.
        :rtype: bool
        """
        return self.container['show_member_property_tips']

    @show_member_property_tips.setter
    def show_member_property_tips(self, show_member_property_tips):
        """
        Sets the show_member_property_tips of this PivotTable.

        :param show_member_property_tips: The show_member_property_tips of this PivotTable.
        :type: bool
        """

        self.container['show_member_property_tips'] = show_member_property_tips

    @property
    def alt_text_description(self):
        """
        Gets the alt_text_description of this PivotTable.

        :return: The alt_text_description of this PivotTable.
        :rtype: str
        """
        return self.container['alt_text_description']

    @alt_text_description.setter
    def alt_text_description(self, alt_text_description):
        """
        Sets the alt_text_description of this PivotTable.

        :param alt_text_description: The alt_text_description of this PivotTable.
        :type: str
        """

        self.container['alt_text_description'] = alt_text_description

    @property
    def show_data_tips(self):
        """
        Gets the show_data_tips of this PivotTable.

        :return: The show_data_tips of this PivotTable.
        :rtype: bool
        """
        return self.container['show_data_tips']

    @show_data_tips.setter
    def show_data_tips(self, show_data_tips):
        """
        Sets the show_data_tips of this PivotTable.

        :param show_data_tips: The show_data_tips of this PivotTable.
        :type: bool
        """

        self.container['show_data_tips'] = show_data_tips

    @property
    def print_titles(self):
        """
        Gets the print_titles of this PivotTable.

        :return: The print_titles of this PivotTable.
        :rtype: bool
        """
        return self.container['print_titles']

    @print_titles.setter
    def print_titles(self, print_titles):
        """
        Sets the print_titles of this PivotTable.

        :param print_titles: The print_titles of this PivotTable.
        :type: bool
        """

        self.container['print_titles'] = print_titles

    @property
    def table_range1(self):
        """
        Gets the table_range1 of this PivotTable.

        :return: The table_range1 of this PivotTable.
        :rtype: CellArea
        """
        return self.container['table_range1']

    @table_range1.setter
    def table_range1(self, table_range1):
        """
        Sets the table_range1 of this PivotTable.

        :param table_range1: The table_range1 of this PivotTable.
        :type: CellArea
        """

        self.container['table_range1'] = table_range1

    @property
    def show_empty_row(self):
        """
        Gets the show_empty_row of this PivotTable.

        :return: The show_empty_row of this PivotTable.
        :rtype: bool
        """
        return self.container['show_empty_row']

    @show_empty_row.setter
    def show_empty_row(self, show_empty_row):
        """
        Sets the show_empty_row of this PivotTable.

        :param show_empty_row: The show_empty_row of this PivotTable.
        :type: bool
        """

        self.container['show_empty_row'] = show_empty_row

    @property
    def is_multiple_field_filters(self):
        """
        Gets the is_multiple_field_filters of this PivotTable.

        :return: The is_multiple_field_filters of this PivotTable.
        :rtype: bool
        """
        return self.container['is_multiple_field_filters']

    @is_multiple_field_filters.setter
    def is_multiple_field_filters(self, is_multiple_field_filters):
        """
        Sets the is_multiple_field_filters of this PivotTable.

        :param is_multiple_field_filters: The is_multiple_field_filters of this PivotTable.
        :type: bool
        """

        self.container['is_multiple_field_filters'] = is_multiple_field_filters

    @property
    def show_empty_col(self):
        """
        Gets the show_empty_col of this PivotTable.

        :return: The show_empty_col of this PivotTable.
        :rtype: bool
        """
        return self.container['show_empty_col']

    @show_empty_col.setter
    def show_empty_col(self, show_empty_col):
        """
        Sets the show_empty_col of this PivotTable.

        :param show_empty_col: The show_empty_col of this PivotTable.
        :type: bool
        """

        self.container['show_empty_col'] = show_empty_col

    @property
    def show_row_header_caption(self):
        """
        Gets the show_row_header_caption of this PivotTable.

        :return: The show_row_header_caption of this PivotTable.
        :rtype: bool
        """
        return self.container['show_row_header_caption']

    @show_row_header_caption.setter
    def show_row_header_caption(self, show_row_header_caption):
        """
        Sets the show_row_header_caption of this PivotTable.

        :param show_row_header_caption: The show_row_header_caption of this PivotTable.
        :type: bool
        """

        self.container['show_row_header_caption'] = show_row_header_caption

    @property
    def has_blank_rows(self):
        """
        Gets the has_blank_rows of this PivotTable.

        :return: The has_blank_rows of this PivotTable.
        :rtype: bool
        """
        return self.container['has_blank_rows']

    @has_blank_rows.setter
    def has_blank_rows(self, has_blank_rows):
        """
        Sets the has_blank_rows of this PivotTable.

        :param has_blank_rows: The has_blank_rows of this PivotTable.
        :type: bool
        """

        self.container['has_blank_rows'] = has_blank_rows

    @property
    def data_source(self):
        """
        Gets the data_source of this PivotTable.

        :return: The data_source of this PivotTable.
        :rtype: list[str]
        """
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        """
        Sets the data_source of this PivotTable.

        :param data_source: The data_source of this PivotTable.
        :type: list[str]
        """

        self.container['data_source'] = data_source

    @property
    def tag(self):
        """
        Gets the tag of this PivotTable.

        :return: The tag of this PivotTable.
        :rtype: str
        """
        return self.container['tag']

    @tag.setter
    def tag(self, tag):
        """
        Sets the tag of this PivotTable.

        :param tag: The tag of this PivotTable.
        :type: str
        """

        self.container['tag'] = tag

    @property
    def enable_drilldown(self):
        """
        Gets the enable_drilldown of this PivotTable.

        :return: The enable_drilldown of this PivotTable.
        :rtype: bool
        """
        return self.container['enable_drilldown']

    @enable_drilldown.setter
    def enable_drilldown(self, enable_drilldown):
        """
        Sets the enable_drilldown of this PivotTable.

        :param enable_drilldown: The enable_drilldown of this PivotTable.
        :type: bool
        """

        self.container['enable_drilldown'] = enable_drilldown

    @property
    def indent(self):
        """
        Gets the indent of this PivotTable.

        :return: The indent of this PivotTable.
        :rtype: int
        """
        return self.container['indent']

    @indent.setter
    def indent(self, indent):
        """
        Sets the indent of this PivotTable.

        :param indent: The indent of this PivotTable.
        :type: int
        """

        self.container['indent'] = indent

    @property
    def name(self):
        """
        Gets the name of this PivotTable.

        :return: The name of this PivotTable.
        :rtype: str
        """
        return self.container['name']

    @name.setter
    def name(self, name):
        """
        Sets the name of this PivotTable.

        :param name: The name of this PivotTable.
        :type: str
        """

        self.container['name'] = name

    @property
    def row_grand(self):
        """
        Gets the row_grand of this PivotTable.

        :return: The row_grand of this PivotTable.
        :rtype: bool
        """
        return self.container['row_grand']

    @row_grand.setter
    def row_grand(self, row_grand):
        """
        Sets the row_grand of this PivotTable.

        :param row_grand: The row_grand of this PivotTable.
        :type: bool
        """

        self.container['row_grand'] = row_grand

    @property
    def grand_total_name(self):
        """
        Gets the grand_total_name of this PivotTable.

        :return: The grand_total_name of this PivotTable.
        :rtype: str
        """
        return self.container['grand_total_name']

    @grand_total_name.setter
    def grand_total_name(self, grand_total_name):
        """
        Sets the grand_total_name of this PivotTable.

        :param grand_total_name: The grand_total_name of this PivotTable.
        :type: str
        """

        self.container['grand_total_name'] = grand_total_name

    @property
    def display_error_string(self):
        """
        Gets the display_error_string of this PivotTable.

        :return: The display_error_string of this PivotTable.
        :rtype: bool
        """
        return self.container['display_error_string']

    @display_error_string.setter
    def display_error_string(self, display_error_string):
        """
        Sets the display_error_string of this PivotTable.

        :param display_error_string: The display_error_string of this PivotTable.
        :type: bool
        """

        self.container['display_error_string'] = display_error_string

    @property
    def row_range(self):
        """
        Gets the row_range of this PivotTable.

        :return: The row_range of this PivotTable.
        :rtype: CellArea
        """
        return self.container['row_range']

    @row_range.setter
    def row_range(self, row_range):
        """
        Sets the row_range of this PivotTable.

        :param row_range: The row_range of this PivotTable.
        :type: CellArea
        """

        self.container['row_range'] = row_range

    @property
    def is_selected(self):
        """
        Gets the is_selected of this PivotTable.

        :return: The is_selected of this PivotTable.
        :rtype: bool
        """
        return self.container['is_selected']

    @is_selected.setter
    def is_selected(self, is_selected):
        """
        Sets the is_selected of this PivotTable.

        :param is_selected: The is_selected of this PivotTable.
        :type: bool
        """

        self.container['is_selected'] = is_selected

    @property
    def column_fields(self):
        """
        Gets the column_fields of this PivotTable.

        :return: The column_fields of this PivotTable.
        :rtype: list[PivotField]
        """
        return self.container['column_fields']

    @column_fields.setter
    def column_fields(self, column_fields):
        """
        Sets the column_fields of this PivotTable.

        :param column_fields: The column_fields of this PivotTable.
        :type: list[PivotField]
        """

        self.container['column_fields'] = column_fields

    @property
    def column_header_caption(self):
        """
        Gets the column_header_caption of this PivotTable.

        :return: The column_header_caption of this PivotTable.
        :rtype: str
        """
        return self.container['column_header_caption']

    @column_header_caption.setter
    def column_header_caption(self, column_header_caption):
        """
        Sets the column_header_caption of this PivotTable.

        :param column_header_caption: The column_header_caption of this PivotTable.
        :type: str
        """

        self.container['column_header_caption'] = column_header_caption

    @property
    def show_values_row(self):
        """
        Gets the show_values_row of this PivotTable.

        :return: The show_values_row of this PivotTable.
        :rtype: bool
        """
        return self.container['show_values_row']

    @show_values_row.setter
    def show_values_row(self, show_values_row):
        """
        Sets the show_values_row of this PivotTable.

        :param show_values_row: The show_values_row of this PivotTable.
        :type: bool
        """

        self.container['show_values_row'] = show_values_row

    @property
    def enable_field_dialog(self):
        """
        Gets the enable_field_dialog of this PivotTable.

        :return: The enable_field_dialog of this PivotTable.
        :rtype: bool
        """
        return self.container['enable_field_dialog']

    @enable_field_dialog.setter
    def enable_field_dialog(self, enable_field_dialog):
        """
        Sets the enable_field_dialog of this PivotTable.

        :param enable_field_dialog: The enable_field_dialog of this PivotTable.
        :type: bool
        """

        self.container['enable_field_dialog'] = enable_field_dialog

    @property
    def missing_items_limit(self):
        """
        Gets the missing_items_limit of this PivotTable.

        :return: The missing_items_limit of this PivotTable.
        :rtype: str
        """
        return self.container['missing_items_limit']

    @missing_items_limit.setter
    def missing_items_limit(self, missing_items_limit):
        """
        Sets the missing_items_limit of this PivotTable.

        :param missing_items_limit: The missing_items_limit of this PivotTable.
        :type: str
        """

        self.container['missing_items_limit'] = missing_items_limit

    @property
    def show_pivot_style_row_stripes(self):
        """
        Gets the show_pivot_style_row_stripes of this PivotTable.

        :return: The show_pivot_style_row_stripes of this PivotTable.
        :rtype: bool
        """
        return self.container['show_pivot_style_row_stripes']

    @show_pivot_style_row_stripes.setter
    def show_pivot_style_row_stripes(self, show_pivot_style_row_stripes):
        """
        Sets the show_pivot_style_row_stripes of this PivotTable.

        :param show_pivot_style_row_stripes: The show_pivot_style_row_stripes of this PivotTable.
        :type: bool
        """

        self.container['show_pivot_style_row_stripes'] = show_pivot_style_row_stripes

    @property
    def manual_update(self):
        """
        Gets the manual_update of this PivotTable.

        :return: The manual_update of this PivotTable.
        :rtype: bool
        """
        return self.container['manual_update']

    @manual_update.setter
    def manual_update(self, manual_update):
        """
        Sets the manual_update of this PivotTable.

        :param manual_update: The manual_update of this PivotTable.
        :type: bool
        """

        self.container['manual_update'] = manual_update

    @property
    def is_auto_format(self):
        """
        Gets the is_auto_format of this PivotTable.

        :return: The is_auto_format of this PivotTable.
        :rtype: bool
        """
        return self.container['is_auto_format']

    @is_auto_format.setter
    def is_auto_format(self, is_auto_format):
        """
        Sets the is_auto_format of this PivotTable.

        :param is_auto_format: The is_auto_format of this PivotTable.
        :type: bool
        """

        self.container['is_auto_format'] = is_auto_format

    @property
    def display_immediate_items(self):
        """
        Gets the display_immediate_items of this PivotTable.

        :return: The display_immediate_items of this PivotTable.
        :rtype: bool
        """
        return self.container['display_immediate_items']

    @display_immediate_items.setter
    def display_immediate_items(self, display_immediate_items):
        """
        Sets the display_immediate_items of this PivotTable.

        :param display_immediate_items: The display_immediate_items of this PivotTable.
        :type: bool
        """

        self.container['display_immediate_items'] = display_immediate_items

    @property
    def error_string(self):
        """
        Gets the error_string of this PivotTable.

        :return: The error_string of this PivotTable.
        :rtype: str
        """
        return self.container['error_string']

    @error_string.setter
    def error_string(self, error_string):
        """
        Sets the error_string of this PivotTable.

        :param error_string: The error_string of this PivotTable.
        :type: str
        """

        self.container['error_string'] = error_string

    @property
    def custom_list_sort(self):
        """
        Gets the custom_list_sort of this PivotTable.

        :return: The custom_list_sort of this PivotTable.
        :rtype: bool
        """
        return self.container['custom_list_sort']

    @custom_list_sort.setter
    def custom_list_sort(self, custom_list_sort):
        """
        Sets the custom_list_sort of this PivotTable.

        :param custom_list_sort: The custom_list_sort of this PivotTable.
        :type: bool
        """

        self.container['custom_list_sort'] = custom_list_sort

    @property
    def merge_labels(self):
        """
        Gets the merge_labels of this PivotTable.

        :return: The merge_labels of this PivotTable.
        :rtype: bool
        """
        return self.container['merge_labels']

    @merge_labels.setter
    def merge_labels(self, merge_labels):
        """
        Sets the merge_labels of this PivotTable.

        :param merge_labels: The merge_labels of this PivotTable.
        :type: bool
        """

        self.container['merge_labels'] = merge_labels

    @property
    def page_field_wrap_count(self):
        """
        Gets the page_field_wrap_count of this PivotTable.

        :return: The page_field_wrap_count of this PivotTable.
        :rtype: int
        """
        return self.container['page_field_wrap_count']

    @page_field_wrap_count.setter
    def page_field_wrap_count(self, page_field_wrap_count):
        """
        Sets the page_field_wrap_count of this PivotTable.

        :param page_field_wrap_count: The page_field_wrap_count of this PivotTable.
        :type: int
        """

        self.container['page_field_wrap_count'] = page_field_wrap_count

    @property
    def show_pivot_style_column_stripes(self):
        """
        Gets the show_pivot_style_column_stripes of this PivotTable.

        :return: The show_pivot_style_column_stripes of this PivotTable.
        :rtype: bool
        """
        return self.container['show_pivot_style_column_stripes']

    @show_pivot_style_column_stripes.setter
    def show_pivot_style_column_stripes(self, show_pivot_style_column_stripes):
        """
        Sets the show_pivot_style_column_stripes of this PivotTable.

        :param show_pivot_style_column_stripes: The show_pivot_style_column_stripes of this PivotTable.
        :type: bool
        """

        self.container['show_pivot_style_column_stripes'] = show_pivot_style_column_stripes

    @property
    def field_list_sort_ascending(self):
        """
        Gets the field_list_sort_ascending of this PivotTable.

        :return: The field_list_sort_ascending of this PivotTable.
        :rtype: bool
        """
        return self.container['field_list_sort_ascending']

    @field_list_sort_ascending.setter
    def field_list_sort_ascending(self, field_list_sort_ascending):
        """
        Sets the field_list_sort_ascending of this PivotTable.

        :param field_list_sort_ascending: The field_list_sort_ascending of this PivotTable.
        :type: bool
        """

        self.container['field_list_sort_ascending'] = field_list_sort_ascending

    @property
    def alt_text_title(self):
        """
        Gets the alt_text_title of this PivotTable.

        :return: The alt_text_title of this PivotTable.
        :rtype: str
        """
        return self.container['alt_text_title']

    @alt_text_title.setter
    def alt_text_title(self, alt_text_title):
        """
        Sets the alt_text_title of this PivotTable.

        :param alt_text_title: The alt_text_title of this PivotTable.
        :type: str
        """

        self.container['alt_text_title'] = alt_text_title

    @property
    def preserve_formatting(self):
        """
        Gets the preserve_formatting of this PivotTable.

        :return: The preserve_formatting of this PivotTable.
        :rtype: bool
        """
        return self.container['preserve_formatting']

    @preserve_formatting.setter
    def preserve_formatting(self, preserve_formatting):
        """
        Sets the preserve_formatting of this PivotTable.

        :param preserve_formatting: The preserve_formatting of this PivotTable.
        :type: bool
        """

        self.container['preserve_formatting'] = preserve_formatting

    @property
    def pivot_table_style_type(self):
        """
        Gets the pivot_table_style_type of this PivotTable.

        :return: The pivot_table_style_type of this PivotTable.
        :rtype: str
        """
        return self.container['pivot_table_style_type']

    @pivot_table_style_type.setter
    def pivot_table_style_type(self, pivot_table_style_type):
        """
        Sets the pivot_table_style_type of this PivotTable.

        :param pivot_table_style_type: The pivot_table_style_type of this PivotTable.
        :type: str
        """

        self.container['pivot_table_style_type'] = pivot_table_style_type

    @property
    def data_field(self):
        """
        Gets the data_field of this PivotTable.

        :return: The data_field of this PivotTable.
        :rtype: PivotField
        """
        return self.container['data_field']

    @data_field.setter
    def data_field(self, data_field):
        """
        Sets the data_field of this PivotTable.

        :param data_field: The data_field of this PivotTable.
        :type: PivotField
        """

        self.container['data_field'] = data_field

    @property
    def save_data(self):
        """
        Gets the save_data of this PivotTable.

        :return: The save_data of this PivotTable.
        :rtype: bool
        """
        return self.container['save_data']

    @save_data.setter
    def save_data(self, save_data):
        """
        Sets the save_data of this PivotTable.

        :param save_data: The save_data of this PivotTable.
        :type: bool
        """

        self.container['save_data'] = save_data

    @property
    def subtotal_hidden_page_items(self):
        """
        Gets the subtotal_hidden_page_items of this PivotTable.

        :return: The subtotal_hidden_page_items of this PivotTable.
        :rtype: bool
        """
        return self.container['subtotal_hidden_page_items']

    @subtotal_hidden_page_items.setter
    def subtotal_hidden_page_items(self, subtotal_hidden_page_items):
        """
        Sets the subtotal_hidden_page_items of this PivotTable.

        :param subtotal_hidden_page_items: The subtotal_hidden_page_items of this PivotTable.
        :type: bool
        """

        self.container['subtotal_hidden_page_items'] = subtotal_hidden_page_items

    @property
    def print_drill(self):
        """
        Gets the print_drill of this PivotTable.

        :return: The print_drill of this PivotTable.
        :rtype: bool
        """
        return self.container['print_drill']

    @print_drill.setter
    def print_drill(self, print_drill):
        """
        Sets the print_drill of this PivotTable.

        :param print_drill: The print_drill of this PivotTable.
        :type: bool
        """

        self.container['print_drill'] = print_drill

    @property
    def show_pivot_style_column_header(self):
        """
        Gets the show_pivot_style_column_header of this PivotTable.

        :return: The show_pivot_style_column_header of this PivotTable.
        :rtype: bool
        """
        return self.container['show_pivot_style_column_header']

    @show_pivot_style_column_header.setter
    def show_pivot_style_column_header(self, show_pivot_style_column_header):
        """
        Sets the show_pivot_style_column_header of this PivotTable.

        :param show_pivot_style_column_header: The show_pivot_style_column_header of this PivotTable.
        :type: bool
        """

        self.container['show_pivot_style_column_header'] = show_pivot_style_column_header

    @property
    def base_fields(self):
        """
        Gets the base_fields of this PivotTable.

        :return: The base_fields of this PivotTable.
        :rtype: list[PivotField]
        """
        return self.container['base_fields']

    @base_fields.setter
    def base_fields(self, base_fields):
        """
        Sets the base_fields of this PivotTable.

        :param base_fields: The base_fields of this PivotTable.
        :type: list[PivotField]
        """

        self.container['base_fields'] = base_fields

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PivotTable):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
