# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class CustomParserConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'column_index': 'int',
        'custom_style': 'str',
        'parse_method': 'str'
    }

    attribute_map = {
        'column_index': 'ColumnIndex',
        'custom_style': 'CustomStyle',
        'parse_method': 'ParseMethod'
    }
    
    @staticmethod
    def get_swagger_types():
        return CustomParserConfig.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return CustomParserConfig.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, column_index=None, custom_style=None, parse_method=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        CustomParserConfig - a model defined in Swagger
        """

        self.container['column_index'] = None
        self.container['custom_style'] = None
        self.container['parse_method'] = None

        if column_index is not None:
          self.column_index = column_index
        if custom_style is not None:
          self.custom_style = custom_style
        if parse_method is not None:
          self.parse_method = parse_method

    @property
    def column_index(self):
        """
        Gets the column_index of this CustomParserConfig.

        :return: The column_index of this CustomParserConfig.
        :rtype: int
        """
        return self.container['column_index']

    @column_index.setter
    def column_index(self, column_index):
        """
        Sets the column_index of this CustomParserConfig.

        :param column_index: The column_index of this CustomParserConfig.
        :type: int
        """

        self.container['column_index'] = column_index

    @property
    def custom_style(self):
        """
        Gets the custom_style of this CustomParserConfig.

        :return: The custom_style of this CustomParserConfig.
        :rtype: str
        """
        return self.container['custom_style']

    @custom_style.setter
    def custom_style(self, custom_style):
        """
        Sets the custom_style of this CustomParserConfig.

        :param custom_style: The custom_style of this CustomParserConfig.
        :type: str
        """

        self.container['custom_style'] = custom_style

    @property
    def parse_method(self):
        """
        Gets the parse_method of this CustomParserConfig.

        :return: The parse_method of this CustomParserConfig.
        :rtype: str
        """
        return self.container['parse_method']

    @parse_method.setter
    def parse_method(self, parse_method):
        """
        Sets the parse_method of this CustomParserConfig.

        :param parse_method: The parse_method of this CustomParserConfig.
        :type: str
        """

        self.container['parse_method'] = parse_method

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CustomParserConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
