# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class Chart(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'Link',
        'first_slice_angle': 'int',
        'floor': 'LinkElement',
        'plot_empty_cells_type': 'str',
        'auto_scaling': 'bool',
        'style': 'int',
        'series_axis': 'LinkElement',
        'value_axis': 'LinkElement',
        'show_data_table': 'bool',
        'is3_d': 'bool',
        'chart_area': 'LinkElement',
        'elevation': 'int',
        'side_wall': 'LinkElement',
        'type': 'str',
        'title': 'LinkElement',
        'walls': 'LinkElement',
        'back_wall': 'LinkElement',
        'chart_data_table': 'LinkElement',
        'height_percent': 'int',
        'gap_width': 'int',
        'legend': 'LinkElement',
        'chart_object': 'LinkElement',
        'is_rectangular_cornered': 'bool',
        'second_category_axis': 'LinkElement',
        'second_value_axis': 'LinkElement',
        'placement': 'str',
        'name': 'str',
        'size_with_window': 'bool',
        'right_angle_axes': 'bool',
        'plot_visible_cells': 'bool',
        'show_legend': 'bool',
        'pivot_source': 'str',
        'depth_percent': 'int',
        'print_size': 'str',
        'gap_depth': 'int',
        'shapes': 'LinkElement',
        'walls_and_gridlines2_d': 'bool',
        'n_series': 'LinkElement',
        'rotation_angle': 'int',
        'plot_area': 'LinkElement',
        'category_axis': 'LinkElement',
        'perspective': 'int',
        'hide_pivot_field_buttons': 'bool',
        'page_setup': 'LinkElement'
    }

    attribute_map = {
        'link': 'link',
        'first_slice_angle': 'FirstSliceAngle',
        'floor': 'Floor',
        'plot_empty_cells_type': 'PlotEmptyCellsType',
        'auto_scaling': 'AutoScaling',
        'style': 'Style',
        'series_axis': 'SeriesAxis',
        'value_axis': 'ValueAxis',
        'show_data_table': 'ShowDataTable',
        'is3_d': 'Is3D',
        'chart_area': 'ChartArea',
        'elevation': 'Elevation',
        'side_wall': 'SideWall',
        'type': 'Type',
        'title': 'Title',
        'walls': 'Walls',
        'back_wall': 'BackWall',
        'chart_data_table': 'ChartDataTable',
        'height_percent': 'HeightPercent',
        'gap_width': 'GapWidth',
        'legend': 'Legend',
        'chart_object': 'ChartObject',
        'is_rectangular_cornered': 'IsRectangularCornered',
        'second_category_axis': 'SecondCategoryAxis',
        'second_value_axis': 'SecondValueAxis',
        'placement': 'Placement',
        'name': 'Name',
        'size_with_window': 'SizeWithWindow',
        'right_angle_axes': 'RightAngleAxes',
        'plot_visible_cells': 'PlotVisibleCells',
        'show_legend': 'ShowLegend',
        'pivot_source': 'PivotSource',
        'depth_percent': 'DepthPercent',
        'print_size': 'PrintSize',
        'gap_depth': 'GapDepth',
        'shapes': 'Shapes',
        'walls_and_gridlines2_d': 'WallsAndGridlines2D',
        'n_series': 'NSeries',
        'rotation_angle': 'RotationAngle',
        'plot_area': 'PlotArea',
        'category_axis': 'CategoryAxis',
        'perspective': 'Perspective',
        'hide_pivot_field_buttons': 'HidePivotFieldButtons',
        'page_setup': 'PageSetup'
    }
    
    @staticmethod
    def get_swagger_types():
        return Chart.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return Chart.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, link=None, first_slice_angle=None, floor=None, plot_empty_cells_type=None, auto_scaling=None, style=None, series_axis=None, value_axis=None, show_data_table=None, is3_d=None, chart_area=None, elevation=None, side_wall=None, type=None, title=None, walls=None, back_wall=None, chart_data_table=None, height_percent=None, gap_width=None, legend=None, chart_object=None, is_rectangular_cornered=None, second_category_axis=None, second_value_axis=None, placement=None, name=None, size_with_window=None, right_angle_axes=None, plot_visible_cells=None, show_legend=None, pivot_source=None, depth_percent=None, print_size=None, gap_depth=None, shapes=None, walls_and_gridlines2_d=None, n_series=None, rotation_angle=None, plot_area=None, category_axis=None, perspective=None, hide_pivot_field_buttons=None, page_setup=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        Chart - a model defined in Swagger
        """

        self.container['link'] = None
        self.container['first_slice_angle'] = None
        self.container['floor'] = None
        self.container['plot_empty_cells_type'] = None
        self.container['auto_scaling'] = None
        self.container['style'] = None
        self.container['series_axis'] = None
        self.container['value_axis'] = None
        self.container['show_data_table'] = None
        self.container['is3_d'] = None
        self.container['chart_area'] = None
        self.container['elevation'] = None
        self.container['side_wall'] = None
        self.container['type'] = None
        self.container['title'] = None
        self.container['walls'] = None
        self.container['back_wall'] = None
        self.container['chart_data_table'] = None
        self.container['height_percent'] = None
        self.container['gap_width'] = None
        self.container['legend'] = None
        self.container['chart_object'] = None
        self.container['is_rectangular_cornered'] = None
        self.container['second_category_axis'] = None
        self.container['second_value_axis'] = None
        self.container['placement'] = None
        self.container['name'] = None
        self.container['size_with_window'] = None
        self.container['right_angle_axes'] = None
        self.container['plot_visible_cells'] = None
        self.container['show_legend'] = None
        self.container['pivot_source'] = None
        self.container['depth_percent'] = None
        self.container['print_size'] = None
        self.container['gap_depth'] = None
        self.container['shapes'] = None
        self.container['walls_and_gridlines2_d'] = None
        self.container['n_series'] = None
        self.container['rotation_angle'] = None
        self.container['plot_area'] = None
        self.container['category_axis'] = None
        self.container['perspective'] = None
        self.container['hide_pivot_field_buttons'] = None
        self.container['page_setup'] = None

        if link is not None:
          self.link = link
        if first_slice_angle is not None:
          self.first_slice_angle = first_slice_angle
        if floor is not None:
          self.floor = floor
        if plot_empty_cells_type is not None:
          self.plot_empty_cells_type = plot_empty_cells_type
        if auto_scaling is not None:
          self.auto_scaling = auto_scaling
        if style is not None:
          self.style = style
        if series_axis is not None:
          self.series_axis = series_axis
        if value_axis is not None:
          self.value_axis = value_axis
        if show_data_table is not None:
          self.show_data_table = show_data_table
        if is3_d is not None:
          self.is3_d = is3_d
        if chart_area is not None:
          self.chart_area = chart_area
        if elevation is not None:
          self.elevation = elevation
        if side_wall is not None:
          self.side_wall = side_wall
        if type is not None:
          self.type = type
        if title is not None:
          self.title = title
        if walls is not None:
          self.walls = walls
        if back_wall is not None:
          self.back_wall = back_wall
        if chart_data_table is not None:
          self.chart_data_table = chart_data_table
        if height_percent is not None:
          self.height_percent = height_percent
        if gap_width is not None:
          self.gap_width = gap_width
        if legend is not None:
          self.legend = legend
        if chart_object is not None:
          self.chart_object = chart_object
        if is_rectangular_cornered is not None:
          self.is_rectangular_cornered = is_rectangular_cornered
        if second_category_axis is not None:
          self.second_category_axis = second_category_axis
        if second_value_axis is not None:
          self.second_value_axis = second_value_axis
        if placement is not None:
          self.placement = placement
        if name is not None:
          self.name = name
        if size_with_window is not None:
          self.size_with_window = size_with_window
        if right_angle_axes is not None:
          self.right_angle_axes = right_angle_axes
        if plot_visible_cells is not None:
          self.plot_visible_cells = plot_visible_cells
        if show_legend is not None:
          self.show_legend = show_legend
        if pivot_source is not None:
          self.pivot_source = pivot_source
        if depth_percent is not None:
          self.depth_percent = depth_percent
        if print_size is not None:
          self.print_size = print_size
        if gap_depth is not None:
          self.gap_depth = gap_depth
        if shapes is not None:
          self.shapes = shapes
        if walls_and_gridlines2_d is not None:
          self.walls_and_gridlines2_d = walls_and_gridlines2_d
        if n_series is not None:
          self.n_series = n_series
        if rotation_angle is not None:
          self.rotation_angle = rotation_angle
        if plot_area is not None:
          self.plot_area = plot_area
        if category_axis is not None:
          self.category_axis = category_axis
        if perspective is not None:
          self.perspective = perspective
        if hide_pivot_field_buttons is not None:
          self.hide_pivot_field_buttons = hide_pivot_field_buttons
        if page_setup is not None:
          self.page_setup = page_setup

    @property
    def link(self):
        """
        Gets the link of this Chart.

        :return: The link of this Chart.
        :rtype: Link
        """
        return self.container['link']

    @link.setter
    def link(self, link):
        """
        Sets the link of this Chart.

        :param link: The link of this Chart.
        :type: Link
        """

        self.container['link'] = link

    @property
    def first_slice_angle(self):
        """
        Gets the first_slice_angle of this Chart.
        Gets or sets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical). Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.

        :return: The first_slice_angle of this Chart.
        :rtype: int
        """
        return self.container['first_slice_angle']

    @first_slice_angle.setter
    def first_slice_angle(self, first_slice_angle):
        """
        Sets the first_slice_angle of this Chart.
        Gets or sets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical). Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.

        :param first_slice_angle: The first_slice_angle of this Chart.
        :type: int
        """

        self.container['first_slice_angle'] = first_slice_angle

    @property
    def floor(self):
        """
        Gets the floor of this Chart.
        Returns a Floor object that represents the walls of a 3-D chart.             

        :return: The floor of this Chart.
        :rtype: LinkElement
        """
        return self.container['floor']

    @floor.setter
    def floor(self, floor):
        """
        Sets the floor of this Chart.
        Returns a Floor object that represents the walls of a 3-D chart.             

        :param floor: The floor of this Chart.
        :type: LinkElement
        """

        self.container['floor'] = floor

    @property
    def plot_empty_cells_type(self):
        """
        Gets the plot_empty_cells_type of this Chart.
        Gets and sets how to plot the empty cells.

        :return: The plot_empty_cells_type of this Chart.
        :rtype: str
        """
        return self.container['plot_empty_cells_type']

    @plot_empty_cells_type.setter
    def plot_empty_cells_type(self, plot_empty_cells_type):
        """
        Sets the plot_empty_cells_type of this Chart.
        Gets and sets how to plot the empty cells.

        :param plot_empty_cells_type: The plot_empty_cells_type of this Chart.
        :type: str
        """

        self.container['plot_empty_cells_type'] = plot_empty_cells_type

    @property
    def auto_scaling(self):
        """
        Gets the auto_scaling of this Chart.
        True if Microsoft Excel scales a 3-D chart so that it's closer in size to the equivalent 2-D chart. The RightAngleAxes property must be True.

        :return: The auto_scaling of this Chart.
        :rtype: bool
        """
        return self.container['auto_scaling']

    @auto_scaling.setter
    def auto_scaling(self, auto_scaling):
        """
        Sets the auto_scaling of this Chart.
        True if Microsoft Excel scales a 3-D chart so that it's closer in size to the equivalent 2-D chart. The RightAngleAxes property must be True.

        :param auto_scaling: The auto_scaling of this Chart.
        :type: bool
        """

        self.container['auto_scaling'] = auto_scaling

    @property
    def style(self):
        """
        Gets the style of this Chart.
        Gets and sets the builtin style.

        :return: The style of this Chart.
        :rtype: int
        """
        return self.container['style']

    @style.setter
    def style(self, style):
        """
        Sets the style of this Chart.
        Gets and sets the builtin style.

        :param style: The style of this Chart.
        :type: int
        """

        self.container['style'] = style

    @property
    def series_axis(self):
        """
        Gets the series_axis of this Chart.
        Gets the chart's series axis.

        :return: The series_axis of this Chart.
        :rtype: LinkElement
        """
        return self.container['series_axis']

    @series_axis.setter
    def series_axis(self, series_axis):
        """
        Sets the series_axis of this Chart.
        Gets the chart's series axis.

        :param series_axis: The series_axis of this Chart.
        :type: LinkElement
        """

        self.container['series_axis'] = series_axis

    @property
    def value_axis(self):
        """
        Gets the value_axis of this Chart.
        Gets the chart's Y axis.

        :return: The value_axis of this Chart.
        :rtype: LinkElement
        """
        return self.container['value_axis']

    @value_axis.setter
    def value_axis(self, value_axis):
        """
        Sets the value_axis of this Chart.
        Gets the chart's Y axis.

        :param value_axis: The value_axis of this Chart.
        :type: LinkElement
        """

        self.container['value_axis'] = value_axis

    @property
    def show_data_table(self):
        """
        Gets the show_data_table of this Chart.
        Gets or sets a value indicating whether the chart displays a data table.

        :return: The show_data_table of this Chart.
        :rtype: bool
        """
        return self.container['show_data_table']

    @show_data_table.setter
    def show_data_table(self, show_data_table):
        """
        Sets the show_data_table of this Chart.
        Gets or sets a value indicating whether the chart displays a data table.

        :param show_data_table: The show_data_table of this Chart.
        :type: bool
        """

        self.container['show_data_table'] = show_data_table

    @property
    def is3_d(self):
        """
        Gets the is3_d of this Chart.
        Indicates whether the chart is a 3d chart.

        :return: The is3_d of this Chart.
        :rtype: bool
        """
        return self.container['is3_d']

    @is3_d.setter
    def is3_d(self, is3_d):
        """
        Sets the is3_d of this Chart.
        Indicates whether the chart is a 3d chart.

        :param is3_d: The is3_d of this Chart.
        :type: bool
        """

        self.container['is3_d'] = is3_d

    @property
    def chart_area(self):
        """
        Gets the chart_area of this Chart.
        Gets the chart area in the worksheet

        :return: The chart_area of this Chart.
        :rtype: LinkElement
        """
        return self.container['chart_area']

    @chart_area.setter
    def chart_area(self, chart_area):
        """
        Sets the chart_area of this Chart.
        Gets the chart area in the worksheet

        :param chart_area: The chart_area of this Chart.
        :type: LinkElement
        """

        self.container['chart_area'] = chart_area

    @property
    def elevation(self):
        """
        Gets the elevation of this Chart.
        Represents the elevation of the 3-D chart view, in degrees.

        :return: The elevation of this Chart.
        :rtype: int
        """
        return self.container['elevation']

    @elevation.setter
    def elevation(self, elevation):
        """
        Sets the elevation of this Chart.
        Represents the elevation of the 3-D chart view, in degrees.

        :param elevation: The elevation of this Chart.
        :type: int
        """

        self.container['elevation'] = elevation

    @property
    def side_wall(self):
        """
        Gets the side_wall of this Chart.

        :return: The side_wall of this Chart.
        :rtype: LinkElement
        """
        return self.container['side_wall']

    @side_wall.setter
    def side_wall(self, side_wall):
        """
        Sets the side_wall of this Chart.

        :param side_wall: The side_wall of this Chart.
        :type: LinkElement
        """

        self.container['side_wall'] = side_wall

    @property
    def type(self):
        """
        Gets the type of this Chart.
        Gets or sets a chart's type.

        :return: The type of this Chart.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this Chart.
        Gets or sets a chart's type.

        :param type: The type of this Chart.
        :type: str
        """

        self.container['type'] = type

    @property
    def title(self):
        """
        Gets the title of this Chart.
        Gets the chart's title.

        :return: The title of this Chart.
        :rtype: LinkElement
        """
        return self.container['title']

    @title.setter
    def title(self, title):
        """
        Sets the title of this Chart.
        Gets the chart's title.

        :param title: The title of this Chart.
        :type: LinkElement
        """

        self.container['title'] = title

    @property
    def walls(self):
        """
        Gets the walls of this Chart.
        Returns a Walls object that represents the walls of a 3-D chart.

        :return: The walls of this Chart.
        :rtype: LinkElement
        """
        return self.container['walls']

    @walls.setter
    def walls(self, walls):
        """
        Sets the walls of this Chart.
        Returns a Walls object that represents the walls of a 3-D chart.

        :param walls: The walls of this Chart.
        :type: LinkElement
        """

        self.container['walls'] = walls

    @property
    def back_wall(self):
        """
        Gets the back_wall of this Chart.

        :return: The back_wall of this Chart.
        :rtype: LinkElement
        """
        return self.container['back_wall']

    @back_wall.setter
    def back_wall(self, back_wall):
        """
        Sets the back_wall of this Chart.

        :param back_wall: The back_wall of this Chart.
        :type: LinkElement
        """

        self.container['back_wall'] = back_wall

    @property
    def chart_data_table(self):
        """
        Gets the chart_data_table of this Chart.
        Represents the chart data table.

        :return: The chart_data_table of this Chart.
        :rtype: LinkElement
        """
        return self.container['chart_data_table']

    @chart_data_table.setter
    def chart_data_table(self, chart_data_table):
        """
        Sets the chart_data_table of this Chart.
        Represents the chart data table.

        :param chart_data_table: The chart_data_table of this Chart.
        :type: LinkElement
        """

        self.container['chart_data_table'] = chart_data_table

    @property
    def height_percent(self):
        """
        Gets the height_percent of this Chart.
        Returns or sets the height of a 3-D chart as a percentage of the chart width (between 5 and 500 percent).

        :return: The height_percent of this Chart.
        :rtype: int
        """
        return self.container['height_percent']

    @height_percent.setter
    def height_percent(self, height_percent):
        """
        Sets the height_percent of this Chart.
        Returns or sets the height of a 3-D chart as a percentage of the chart width (between 5 and 500 percent).

        :param height_percent: The height_percent of this Chart.
        :type: int
        """

        self.container['height_percent'] = height_percent

    @property
    def gap_width(self):
        """
        Gets the gap_width of this Chart.
        Returns or sets the space between bar or column clusters, as a percentage of the bar or column width. The value of this property must be between 0 and 500.             

        :return: The gap_width of this Chart.
        :rtype: int
        """
        return self.container['gap_width']

    @gap_width.setter
    def gap_width(self, gap_width):
        """
        Sets the gap_width of this Chart.
        Returns or sets the space between bar or column clusters, as a percentage of the bar or column width. The value of this property must be between 0 and 500.             

        :param gap_width: The gap_width of this Chart.
        :type: int
        """

        self.container['gap_width'] = gap_width

    @property
    def legend(self):
        """
        Gets the legend of this Chart.
        Gets the chart legend.

        :return: The legend of this Chart.
        :rtype: LinkElement
        """
        return self.container['legend']

    @legend.setter
    def legend(self, legend):
        """
        Sets the legend of this Chart.
        Gets the chart legend.

        :param legend: The legend of this Chart.
        :type: LinkElement
        """

        self.container['legend'] = legend

    @property
    def chart_object(self):
        """
        Gets the chart_object of this Chart.
        Represents the chartShape;

        :return: The chart_object of this Chart.
        :rtype: LinkElement
        """
        return self.container['chart_object']

    @chart_object.setter
    def chart_object(self, chart_object):
        """
        Sets the chart_object of this Chart.
        Represents the chartShape;

        :param chart_object: The chart_object of this Chart.
        :type: LinkElement
        """

        self.container['chart_object'] = chart_object

    @property
    def is_rectangular_cornered(self):
        """
        Gets the is_rectangular_cornered of this Chart.
        Gets or sets a value indicating whether the chart displays a data table.

        :return: The is_rectangular_cornered of this Chart.
        :rtype: bool
        """
        return self.container['is_rectangular_cornered']

    @is_rectangular_cornered.setter
    def is_rectangular_cornered(self, is_rectangular_cornered):
        """
        Sets the is_rectangular_cornered of this Chart.
        Gets or sets a value indicating whether the chart displays a data table.

        :param is_rectangular_cornered: The is_rectangular_cornered of this Chart.
        :type: bool
        """

        self.container['is_rectangular_cornered'] = is_rectangular_cornered

    @property
    def second_category_axis(self):
        """
        Gets the second_category_axis of this Chart.
        Gets the chart's second X axis.

        :return: The second_category_axis of this Chart.
        :rtype: LinkElement
        """
        return self.container['second_category_axis']

    @second_category_axis.setter
    def second_category_axis(self, second_category_axis):
        """
        Sets the second_category_axis of this Chart.
        Gets the chart's second X axis.

        :param second_category_axis: The second_category_axis of this Chart.
        :type: LinkElement
        """

        self.container['second_category_axis'] = second_category_axis

    @property
    def second_value_axis(self):
        """
        Gets the second_value_axis of this Chart.
        Gets the chart's second Y axis.

        :return: The second_value_axis of this Chart.
        :rtype: LinkElement
        """
        return self.container['second_value_axis']

    @second_value_axis.setter
    def second_value_axis(self, second_value_axis):
        """
        Sets the second_value_axis of this Chart.
        Gets the chart's second Y axis.

        :param second_value_axis: The second_value_axis of this Chart.
        :type: LinkElement
        """

        self.container['second_value_axis'] = second_value_axis

    @property
    def placement(self):
        """
        Gets the placement of this Chart.
        Represents the way the chart is attached to the cells below it.

        :return: The placement of this Chart.
        :rtype: str
        """
        return self.container['placement']

    @placement.setter
    def placement(self, placement):
        """
        Sets the placement of this Chart.
        Represents the way the chart is attached to the cells below it.

        :param placement: The placement of this Chart.
        :type: str
        """

        self.container['placement'] = placement

    @property
    def name(self):
        """
        Gets the name of this Chart.
        Gets and sets the name of the chart.

        :return: The name of this Chart.
        :rtype: str
        """
        return self.container['name']

    @name.setter
    def name(self, name):
        """
        Sets the name of this Chart.
        Gets and sets the name of the chart.

        :param name: The name of this Chart.
        :type: str
        """

        self.container['name'] = name

    @property
    def size_with_window(self):
        """
        Gets the size_with_window of this Chart.
        True if Microsoft Excel resizes the chart to match the size of the chart sheet window.

        :return: The size_with_window of this Chart.
        :rtype: bool
        """
        return self.container['size_with_window']

    @size_with_window.setter
    def size_with_window(self, size_with_window):
        """
        Sets the size_with_window of this Chart.
        True if Microsoft Excel resizes the chart to match the size of the chart sheet window.

        :param size_with_window: The size_with_window of this Chart.
        :type: bool
        """

        self.container['size_with_window'] = size_with_window

    @property
    def right_angle_axes(self):
        """
        Gets the right_angle_axes of this Chart.
        True if the chart axes are at right angles.Applies only for 3-D charts(except Column3D and 3-D Pie Charts).

        :return: The right_angle_axes of this Chart.
        :rtype: bool
        """
        return self.container['right_angle_axes']

    @right_angle_axes.setter
    def right_angle_axes(self, right_angle_axes):
        """
        Sets the right_angle_axes of this Chart.
        True if the chart axes are at right angles.Applies only for 3-D charts(except Column3D and 3-D Pie Charts).

        :param right_angle_axes: The right_angle_axes of this Chart.
        :type: bool
        """

        self.container['right_angle_axes'] = right_angle_axes

    @property
    def plot_visible_cells(self):
        """
        Gets the plot_visible_cells of this Chart.
        Indicates whether only plot visible cells.

        :return: The plot_visible_cells of this Chart.
        :rtype: bool
        """
        return self.container['plot_visible_cells']

    @plot_visible_cells.setter
    def plot_visible_cells(self, plot_visible_cells):
        """
        Sets the plot_visible_cells of this Chart.
        Indicates whether only plot visible cells.

        :param plot_visible_cells: The plot_visible_cells of this Chart.
        :type: bool
        """

        self.container['plot_visible_cells'] = plot_visible_cells

    @property
    def show_legend(self):
        """
        Gets the show_legend of this Chart.
        Gets or sets a value indicating whether the chart legend will be displayed. Default is true.

        :return: The show_legend of this Chart.
        :rtype: bool
        """
        return self.container['show_legend']

    @show_legend.setter
    def show_legend(self, show_legend):
        """
        Sets the show_legend of this Chart.
        Gets or sets a value indicating whether the chart legend will be displayed. Default is true.

        :param show_legend: The show_legend of this Chart.
        :type: bool
        """

        self.container['show_legend'] = show_legend

    @property
    def pivot_source(self):
        """
        Gets the pivot_source of this Chart.
        The source is the data of the pivotTable.If PivotSource is not empty ,the chart is PivotChart.

        :return: The pivot_source of this Chart.
        :rtype: str
        """
        return self.container['pivot_source']

    @pivot_source.setter
    def pivot_source(self, pivot_source):
        """
        Sets the pivot_source of this Chart.
        The source is the data of the pivotTable.If PivotSource is not empty ,the chart is PivotChart.

        :param pivot_source: The pivot_source of this Chart.
        :type: str
        """

        self.container['pivot_source'] = pivot_source

    @property
    def depth_percent(self):
        """
        Gets the depth_percent of this Chart.
        Represents the depth of a 3-D chart as a percentage of the chart width (between 20 and 2000 percent).

        :return: The depth_percent of this Chart.
        :rtype: int
        """
        return self.container['depth_percent']

    @depth_percent.setter
    def depth_percent(self, depth_percent):
        """
        Sets the depth_percent of this Chart.
        Represents the depth of a 3-D chart as a percentage of the chart width (between 20 and 2000 percent).

        :param depth_percent: The depth_percent of this Chart.
        :type: int
        """

        self.container['depth_percent'] = depth_percent

    @property
    def print_size(self):
        """
        Gets the print_size of this Chart.
        Gets and sets the printed chart size.

        :return: The print_size of this Chart.
        :rtype: str
        """
        return self.container['print_size']

    @print_size.setter
    def print_size(self, print_size):
        """
        Sets the print_size of this Chart.
        Gets and sets the printed chart size.

        :param print_size: The print_size of this Chart.
        :type: str
        """

        self.container['print_size'] = print_size

    @property
    def gap_depth(self):
        """
        Gets the gap_depth of this Chart.
        Gets or sets the distance between the data series in a 3-D chart, as a percentage of the marker width.The value of this property must be between 0 and 500.

        :return: The gap_depth of this Chart.
        :rtype: int
        """
        return self.container['gap_depth']

    @gap_depth.setter
    def gap_depth(self, gap_depth):
        """
        Sets the gap_depth of this Chart.
        Gets or sets the distance between the data series in a 3-D chart, as a percentage of the marker width.The value of this property must be between 0 and 500.

        :param gap_depth: The gap_depth of this Chart.
        :type: int
        """

        self.container['gap_depth'] = gap_depth

    @property
    def shapes(self):
        """
        Gets the shapes of this Chart.
        Returns all drawing shapes in this chart.

        :return: The shapes of this Chart.
        :rtype: LinkElement
        """
        return self.container['shapes']

    @shapes.setter
    def shapes(self, shapes):
        """
        Sets the shapes of this Chart.
        Returns all drawing shapes in this chart.

        :param shapes: The shapes of this Chart.
        :type: LinkElement
        """

        self.container['shapes'] = shapes

    @property
    def walls_and_gridlines2_d(self):
        """
        Gets the walls_and_gridlines2_d of this Chart.
        True if gridlines are drawn two-dimensionally on a 3-D chart.

        :return: The walls_and_gridlines2_d of this Chart.
        :rtype: bool
        """
        return self.container['walls_and_gridlines2_d']

    @walls_and_gridlines2_d.setter
    def walls_and_gridlines2_d(self, walls_and_gridlines2_d):
        """
        Sets the walls_and_gridlines2_d of this Chart.
        True if gridlines are drawn two-dimensionally on a 3-D chart.

        :param walls_and_gridlines2_d: The walls_and_gridlines2_d of this Chart.
        :type: bool
        """

        self.container['walls_and_gridlines2_d'] = walls_and_gridlines2_d

    @property
    def n_series(self):
        """
        Gets the n_series of this Chart.
        Gets a SeriesCollection collection representing the data series in the chart.

        :return: The n_series of this Chart.
        :rtype: LinkElement
        """
        return self.container['n_series']

    @n_series.setter
    def n_series(self, n_series):
        """
        Sets the n_series of this Chart.
        Gets a SeriesCollection collection representing the data series in the chart.

        :param n_series: The n_series of this Chart.
        :type: LinkElement
        """

        self.container['n_series'] = n_series

    @property
    def rotation_angle(self):
        """
        Gets the rotation_angle of this Chart.
        Represents the rotation of the 3-D chart view (the rotation of the plot area around the z-axis, in degrees).

        :return: The rotation_angle of this Chart.
        :rtype: int
        """
        return self.container['rotation_angle']

    @rotation_angle.setter
    def rotation_angle(self, rotation_angle):
        """
        Sets the rotation_angle of this Chart.
        Represents the rotation of the 3-D chart view (the rotation of the plot area around the z-axis, in degrees).

        :param rotation_angle: The rotation_angle of this Chart.
        :type: int
        """

        self.container['rotation_angle'] = rotation_angle

    @property
    def plot_area(self):
        """
        Gets the plot_area of this Chart.
        Gets the chart's plot area which includes axis tick lables.

        :return: The plot_area of this Chart.
        :rtype: LinkElement
        """
        return self.container['plot_area']

    @plot_area.setter
    def plot_area(self, plot_area):
        """
        Sets the plot_area of this Chart.
        Gets the chart's plot area which includes axis tick lables.

        :param plot_area: The plot_area of this Chart.
        :type: LinkElement
        """

        self.container['plot_area'] = plot_area

    @property
    def category_axis(self):
        """
        Gets the category_axis of this Chart.
        Gets the chart's X axis. The property is read only

        :return: The category_axis of this Chart.
        :rtype: LinkElement
        """
        return self.container['category_axis']

    @category_axis.setter
    def category_axis(self, category_axis):
        """
        Sets the category_axis of this Chart.
        Gets the chart's X axis. The property is read only

        :param category_axis: The category_axis of this Chart.
        :type: LinkElement
        """

        self.container['category_axis'] = category_axis

    @property
    def perspective(self):
        """
        Gets the perspective of this Chart.
        Returns or sets the perspective for the 3-D chart view. Must be between 0 and 100.This property is ignored if the RightAngleAxes property is True.

        :return: The perspective of this Chart.
        :rtype: int
        """
        return self.container['perspective']

    @perspective.setter
    def perspective(self, perspective):
        """
        Sets the perspective of this Chart.
        Returns or sets the perspective for the 3-D chart view. Must be between 0 and 100.This property is ignored if the RightAngleAxes property is True.

        :param perspective: The perspective of this Chart.
        :type: int
        """

        self.container['perspective'] = perspective

    @property
    def hide_pivot_field_buttons(self):
        """
        Gets the hide_pivot_field_buttons of this Chart.
        Indicates whether hide the pivot chart field buttons only when the chart is PivotChart

        :return: The hide_pivot_field_buttons of this Chart.
        :rtype: bool
        """
        return self.container['hide_pivot_field_buttons']

    @hide_pivot_field_buttons.setter
    def hide_pivot_field_buttons(self, hide_pivot_field_buttons):
        """
        Sets the hide_pivot_field_buttons of this Chart.
        Indicates whether hide the pivot chart field buttons only when the chart is PivotChart

        :param hide_pivot_field_buttons: The hide_pivot_field_buttons of this Chart.
        :type: bool
        """

        self.container['hide_pivot_field_buttons'] = hide_pivot_field_buttons

    @property
    def page_setup(self):
        """
        Gets the page_setup of this Chart.
        Represents the page setup description in this chart.

        :return: The page_setup of this Chart.
        :rtype: LinkElement
        """
        return self.container['page_setup']

    @page_setup.setter
    def page_setup(self, page_setup):
        """
        Sets the page_setup of this Chart.
        Represents the page setup description in this chart.

        :param page_setup: The page_setup of this Chart.
        :type: LinkElement
        """

        self.container['page_setup'] = page_setup

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Chart):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
