"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const appsync_generated_1 = require("./appsync.generated");
const caching_key_1 = require("./caching-key");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("@aws-cdk/core");
/**
 * An AppSync resolver
 */
class Resolver extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_ResolverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Resolver);
            }
            throw error;
        }
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ?
            { functions: props.pipelineConfig.map((func) => func.functionId) }
            : undefined;
        if (pipelineConfig && props.dataSource) {
            throw new Error(`Pipeline Resolver cannot have data source. Received: ${props.dataSource.name}`);
        }
        if (props.cachingConfig?.ttl && (props.cachingConfig.ttl.toSeconds() < 1 || props.cachingConfig.ttl.toSeconds() > 3600)) {
            throw new Error(`Caching config TTL must be between 1 and 3600 seconds. Received: ${props.cachingConfig.ttl.toSeconds()}`);
        }
        if (props.cachingConfig?.cachingKeys) {
            if (props.cachingConfig.cachingKeys.find(cachingKey => !core_1.Token.isUnresolved(cachingKey) && !caching_key_1.BASE_CACHING_KEYS.find(baseCachingKey => cachingKey.startsWith(baseCachingKey)))) {
                throw new Error(`Caching config keys must begin with $context.arguments, $context.source or $context.identity. Received: ${props.cachingConfig.cachingKeys}`);
            }
        }
        this.resolver = new appsync_generated_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
            cachingConfig: this.createCachingConfig(props.cachingConfig),
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
    createCachingConfig(config) {
        return config ? {
            cachingKeys: config.cachingKeys,
            ttl: config.ttl?.toSeconds(),
        } : undefined;
    }
}
exports.Resolver = Resolver;
_a = JSII_RTTI_SYMBOL_1;
Resolver[_a] = { fqn: "@aws-cdk/aws-appsync.Resolver", version: "1.181.1" };
//# sourceMappingURL=data:application/json;base64,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