# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcceptAttachCcnInstancesRequest(AbstractModel):
    r"""AcceptAttachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: List of associated instances.
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        r"""List of associated instances.
        :rtype: list of CcnInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcceptAttachCcnInstancesResponse(AbstractModel):
    r"""AcceptAttachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AccountAttribute(AbstractModel):
    r"""Account attribute object

    """

    def __init__(self):
        r"""
        :param _AttributeName: Attribute name
        :type AttributeName: str
        :param _AttributeValues: Attribute values
        :type AttributeValues: list of str
        """
        self._AttributeName = None
        self._AttributeValues = None

    @property
    def AttributeName(self):
        r"""Attribute name
        :rtype: str
        """
        return self._AttributeName

    @AttributeName.setter
    def AttributeName(self, AttributeName):
        self._AttributeName = AttributeName

    @property
    def AttributeValues(self):
        r"""Attribute values
        :rtype: list of str
        """
        return self._AttributeValues

    @AttributeValues.setter
    def AttributeValues(self, AttributeValues):
        self._AttributeValues = AttributeValues


    def _deserialize(self, params):
        self._AttributeName = params.get("AttributeName")
        self._AttributeValues = params.get("AttributeValues")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBandwidthPackageResourcesRequest(AbstractModel):
    r"""AddBandwidthPackageResources request structure.

    """

    def __init__(self):
        r"""
        :param _ResourceIds: The unique ID of the source, such as 'eip-xxxx' and 'lb-xxxx'. EIP and LB resources are currently supported.
        :type ResourceIds: list of str
        :param _BandwidthPackageId: The unique ID of the bandwidth package, such as 'bwp-xxxx'.
        :type BandwidthPackageId: str
        :param _NetworkType: The network type of the bandwidth package. Valid value: `BGP`, indicating that the internal resource is a BGP IP.
        :type NetworkType: str
        :param _ResourceType: The resource type, including `Address` and `LoadBalance`.
        :type ResourceType: str
        :param _Protocol: The protocol type of the bandwidth package. Valid values: `ipv4` and `ipv6`.
        :type Protocol: str
        """
        self._ResourceIds = None
        self._BandwidthPackageId = None
        self._NetworkType = None
        self._ResourceType = None
        self._Protocol = None

    @property
    def ResourceIds(self):
        r"""The unique ID of the source, such as 'eip-xxxx' and 'lb-xxxx'. EIP and LB resources are currently supported.
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def BandwidthPackageId(self):
        r"""The unique ID of the bandwidth package, such as 'bwp-xxxx'.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def NetworkType(self):
        r"""The network type of the bandwidth package. Valid value: `BGP`, indicating that the internal resource is a BGP IP.
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ResourceType(self):
        r"""The resource type, including `Address` and `LoadBalance`.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Protocol(self):
        r"""The protocol type of the bandwidth package. Valid values: `ipv4` and `ipv6`.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._NetworkType = params.get("NetworkType")
        self._ResourceType = params.get("ResourceType")
        self._Protocol = params.get("Protocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBandwidthPackageResourcesResponse(AbstractModel):
    r"""AddBandwidthPackageResources response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddTemplateMemberRequest(AbstractModel):
    r"""AddTemplateMember request structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Parameter template instance ID, which can be the instance ID of a parameter template of the following four types: IP address, protocol port, IP address group, and protocol port group.
        :type TemplateId: str
        :param _TemplateMember: Information on the parameter template to be added. The template can be of the following four types: IP address, protocol port, IP address group, and protocol port group. The type should be consistent with that of the template specified by the TemplateId parameter.
        :type TemplateMember: list of MemberInfo
        """
        self._TemplateId = None
        self._TemplateMember = None

    @property
    def TemplateId(self):
        r"""Parameter template instance ID, which can be the instance ID of a parameter template of the following four types: IP address, protocol port, IP address group, and protocol port group.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateMember(self):
        r"""Information on the parameter template to be added. The template can be of the following four types: IP address, protocol port, IP address group, and protocol port group. The type should be consistent with that of the template specified by the TemplateId parameter.
        :rtype: list of MemberInfo
        """
        return self._TemplateMember

    @TemplateMember.setter
    def TemplateMember(self, TemplateMember):
        self._TemplateMember = TemplateMember


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("TemplateMember") is not None:
            self._TemplateMember = []
            for item in params.get("TemplateMember"):
                obj = MemberInfo()
                obj._deserialize(item)
                self._TemplateMember.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTemplateMemberResponse(AbstractModel):
    r"""AddTemplateMember response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Address(AbstractModel):
    r"""Detailed EIP information

    """

    def __init__(self):
        r"""
        :param _AddressId: `EIP` `ID`, the unique ID of the `EIP`.
        :type AddressId: str
        :param _AddressName: The `EIP` name.
        :type AddressName: str
        :param _AddressStatus: Possible `EIP` states are 'CREATING', 'BINDING', 'BIND', 'UNBINDING', 'UNBIND', 'OFFLINING', and 'BIND_ENI'.
        :type AddressStatus: str
        :param _AddressIp: The public IP address
        :type AddressIp: str
        :param _InstanceId: The ID of the bound resource instance. This can be a `CVM` or `NAT`.
        :type InstanceId: str
        :param _CreatedTime: The creation time, which follows the `ISO8601` standard and uses `UTC` time in the format of `YYYY-MM-DDThh:mm:ssZ`.
        :type CreatedTime: str
        :param _NetworkInterfaceId: The ID of the bound ENI
        :type NetworkInterfaceId: str
        :param _PrivateAddressIp: The private IP of the bound resources
        :type PrivateAddressIp: str
        :param _IsArrears: The isolation status of the resource. `True` indicates the EIP is isolated. `False` indicates that the resource is not isolated.
        :type IsArrears: bool
        :param _IsBlocked: The block status of the resource. `True` indicates the EIP is blocked. `False` indicates that the EIP is not blocked.
        :type IsBlocked: bool
        :param _IsEipDirectConnection: Whether the EIP supports direct connection mode. `True` indicates the EIP supports direct connection. `False` indicates that the resource does not support direct connection.
        :type IsEipDirectConnection: bool
        :param _AddressType: EIP resource type. Valid values: `CalcIP` (device IP), `WanIP` (public IP), `EIP` (elastic IP), `AnycastEIP` (accelerated EIP), and `AntiDDoSEIP` (anti-DDoS EIP).
        :type AddressType: str
        :param _CascadeRelease: Whether the EIP is automatically released after being unbound. `True` indicates the EIP will be automatically released after being unbound. `False` indicates the EIP will not be automatically released after being unbound.
        :type CascadeRelease: bool
        :param _EipAlgType: Type of the protocol used in EIP ALG
        :type EipAlgType: :class:`tencentcloud.vpc.v20170312.models.AlgType`
        :param _InternetServiceProvider: The ISP of an EIP/Elastic IP, with possible return values currently including "CMCC", "CTCC", "CUCC" and "BGP"
        :type InternetServiceProvider: str
        :param _LocalBgp: Whether the EIP is in a local BGP.
        :type LocalBgp: bool
        :param _Bandwidth: Bandwidth value of EIP. The EIP for the bill-by-CVM account will return `null`.
Note: this field may return `null`, indicating that no valid value was found.
        :type Bandwidth: int
        :param _InternetChargeType: Network billing mode of EIP. The EIP for the bill-by-CVM account will return `null`.
Note: this field may return `null`, indicating that no valid value was found.
Including:
<li><strong>BANDWIDTH_PREPAID_BY_MONTH</strong></li>
<p style="padding-left: 30px;">Prepaid by monthly-subscribed bandwidth.</p>
<li><strong>TRAFFIC_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">Pay-as-you-go billing by hourly traffic.</p>
<li><strong>BANDWIDTH_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">Pay-as-you-go billing by hourly bandwidth.</p>
<li><strong>BANDWIDTH_PACKAGE</strong></li>
<p style="padding-left: 30px;">Bandwidth package.</p>
Note: this field may return `null`, indicating that no valid value was found.
        :type InternetChargeType: str
        :param _TagSet: List of tags associated with the EIP
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type TagSet: list of Tag
        :param _DeadlineDate: The expiration time.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeadlineDate: str
        :param _InstanceType: The type of instance bound with the EIP
Note: this field may return `null`, indicating that no valid value was found.
        :type InstanceType: str
        :param _Egress: Static single-line IP network egress
Note: This field may return null, indicating that no valid value was found.
        :type Egress: str
        :param _AntiDDoSPackageId: ID of the Anti-DDoS service package. It is returned if the EIP is an Anti-DDoS EIP. 
        :type AntiDDoSPackageId: str
        :param _RenewFlag: Indicates whether the current EIP is auto-renewed. This field is displayed only for EIPs with monthly prepaid bandwidth. Valid values are as follows:
<li>NOTIFY_AND_MANUAL_RENEW: Normal renewal</li><li>NOTIFY_AND_AUTO_RENEW: Automatic renewal</li><li>DISABLE_NOTIFY_AND_MANUAL_RENEW: No renewal upon expiration</li>

        :type RenewFlag: str
        :param _BandwidthPackageId: Indicates the ID of the Bandwidth Package associated with the current public IP. If the public IP is not billed by Bandwidth Package, this field is empty.
Note: This field may return null, indicating that no valid value was found.
        :type BandwidthPackageId: str
        :param _UnVpcId: Indicates the unique ID of the VPC to which the traditional EIPv6 belongs.
Note: This field may return null, indicating that no valid value was found.
        :type UnVpcId: str
        :param _DedicatedClusterId: Indicates the unique ID of the CDC.
Note: This field may return 'null', indicating that no valid value was found.
        :type DedicatedClusterId: str
        """
        self._AddressId = None
        self._AddressName = None
        self._AddressStatus = None
        self._AddressIp = None
        self._InstanceId = None
        self._CreatedTime = None
        self._NetworkInterfaceId = None
        self._PrivateAddressIp = None
        self._IsArrears = None
        self._IsBlocked = None
        self._IsEipDirectConnection = None
        self._AddressType = None
        self._CascadeRelease = None
        self._EipAlgType = None
        self._InternetServiceProvider = None
        self._LocalBgp = None
        self._Bandwidth = None
        self._InternetChargeType = None
        self._TagSet = None
        self._DeadlineDate = None
        self._InstanceType = None
        self._Egress = None
        self._AntiDDoSPackageId = None
        self._RenewFlag = None
        self._BandwidthPackageId = None
        self._UnVpcId = None
        self._DedicatedClusterId = None

    @property
    def AddressId(self):
        r"""`EIP` `ID`, the unique ID of the `EIP`.
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressName(self):
        r"""The `EIP` name.
        :rtype: str
        """
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def AddressStatus(self):
        r"""Possible `EIP` states are 'CREATING', 'BINDING', 'BIND', 'UNBINDING', 'UNBIND', 'OFFLINING', and 'BIND_ENI'.
        :rtype: str
        """
        return self._AddressStatus

    @AddressStatus.setter
    def AddressStatus(self, AddressStatus):
        self._AddressStatus = AddressStatus

    @property
    def AddressIp(self):
        r"""The public IP address
        :rtype: str
        """
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp

    @property
    def InstanceId(self):
        r"""The ID of the bound resource instance. This can be a `CVM` or `NAT`.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CreatedTime(self):
        r"""The creation time, which follows the `ISO8601` standard and uses `UTC` time in the format of `YYYY-MM-DDThh:mm:ssZ`.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the bound ENI
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateAddressIp(self):
        r"""The private IP of the bound resources
        :rtype: str
        """
        return self._PrivateAddressIp

    @PrivateAddressIp.setter
    def PrivateAddressIp(self, PrivateAddressIp):
        self._PrivateAddressIp = PrivateAddressIp

    @property
    def IsArrears(self):
        r"""The isolation status of the resource. `True` indicates the EIP is isolated. `False` indicates that the resource is not isolated.
        :rtype: bool
        """
        return self._IsArrears

    @IsArrears.setter
    def IsArrears(self, IsArrears):
        self._IsArrears = IsArrears

    @property
    def IsBlocked(self):
        r"""The block status of the resource. `True` indicates the EIP is blocked. `False` indicates that the EIP is not blocked.
        :rtype: bool
        """
        return self._IsBlocked

    @IsBlocked.setter
    def IsBlocked(self, IsBlocked):
        self._IsBlocked = IsBlocked

    @property
    def IsEipDirectConnection(self):
        r"""Whether the EIP supports direct connection mode. `True` indicates the EIP supports direct connection. `False` indicates that the resource does not support direct connection.
        :rtype: bool
        """
        return self._IsEipDirectConnection

    @IsEipDirectConnection.setter
    def IsEipDirectConnection(self, IsEipDirectConnection):
        self._IsEipDirectConnection = IsEipDirectConnection

    @property
    def AddressType(self):
        r"""EIP resource type. Valid values: `CalcIP` (device IP), `WanIP` (public IP), `EIP` (elastic IP), `AnycastEIP` (accelerated EIP), and `AntiDDoSEIP` (anti-DDoS EIP).
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def CascadeRelease(self):
        r"""Whether the EIP is automatically released after being unbound. `True` indicates the EIP will be automatically released after being unbound. `False` indicates the EIP will not be automatically released after being unbound.
        :rtype: bool
        """
        return self._CascadeRelease

    @CascadeRelease.setter
    def CascadeRelease(self, CascadeRelease):
        self._CascadeRelease = CascadeRelease

    @property
    def EipAlgType(self):
        r"""Type of the protocol used in EIP ALG
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AlgType`
        """
        return self._EipAlgType

    @EipAlgType.setter
    def EipAlgType(self, EipAlgType):
        self._EipAlgType = EipAlgType

    @property
    def InternetServiceProvider(self):
        r"""The ISP of an EIP/Elastic IP, with possible return values currently including "CMCC", "CTCC", "CUCC" and "BGP"
        :rtype: str
        """
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def LocalBgp(self):
        r"""Whether the EIP is in a local BGP.
        :rtype: bool
        """
        return self._LocalBgp

    @LocalBgp.setter
    def LocalBgp(self, LocalBgp):
        self._LocalBgp = LocalBgp

    @property
    def Bandwidth(self):
        r"""Bandwidth value of EIP. The EIP for the bill-by-CVM account will return `null`.
Note: this field may return `null`, indicating that no valid value was found.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def InternetChargeType(self):
        r"""Network billing mode of EIP. The EIP for the bill-by-CVM account will return `null`.
Note: this field may return `null`, indicating that no valid value was found.
Including:
<li><strong>BANDWIDTH_PREPAID_BY_MONTH</strong></li>
<p style="padding-left: 30px;">Prepaid by monthly-subscribed bandwidth.</p>
<li><strong>TRAFFIC_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">Pay-as-you-go billing by hourly traffic.</p>
<li><strong>BANDWIDTH_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">Pay-as-you-go billing by hourly bandwidth.</p>
<li><strong>BANDWIDTH_PACKAGE</strong></li>
<p style="padding-left: 30px;">Bandwidth package.</p>
Note: this field may return `null`, indicating that no valid value was found.
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def TagSet(self):
        r"""List of tags associated with the EIP
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def DeadlineDate(self):
        r"""The expiration time.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DeadlineDate

    @DeadlineDate.setter
    def DeadlineDate(self, DeadlineDate):
        self._DeadlineDate = DeadlineDate

    @property
    def InstanceType(self):
        r"""The type of instance bound with the EIP
Note: this field may return `null`, indicating that no valid value was found.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Egress(self):
        r"""Static single-line IP network egress
Note: This field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def AntiDDoSPackageId(self):
        r"""ID of the Anti-DDoS service package. It is returned if the EIP is an Anti-DDoS EIP. 
        :rtype: str
        """
        return self._AntiDDoSPackageId

    @AntiDDoSPackageId.setter
    def AntiDDoSPackageId(self, AntiDDoSPackageId):
        self._AntiDDoSPackageId = AntiDDoSPackageId

    @property
    def RenewFlag(self):
        r"""Indicates whether the current EIP is auto-renewed. This field is displayed only for EIPs with monthly prepaid bandwidth. Valid values are as follows:
<li>NOTIFY_AND_MANUAL_RENEW: Normal renewal</li><li>NOTIFY_AND_AUTO_RENEW: Automatic renewal</li><li>DISABLE_NOTIFY_AND_MANUAL_RENEW: No renewal upon expiration</li>

        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BandwidthPackageId(self):
        r"""Indicates the ID of the Bandwidth Package associated with the current public IP. If the public IP is not billed by Bandwidth Package, this field is empty.
Note: This field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def UnVpcId(self):
        r"""Indicates the unique ID of the VPC to which the traditional EIPv6 belongs.
Note: This field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._UnVpcId

    @UnVpcId.setter
    def UnVpcId(self, UnVpcId):
        self._UnVpcId = UnVpcId

    @property
    def DedicatedClusterId(self):
        r"""Indicates the unique ID of the CDC.
Note: This field may return 'null', indicating that no valid value was found.
        :rtype: str
        """
        return self._DedicatedClusterId

    @DedicatedClusterId.setter
    def DedicatedClusterId(self, DedicatedClusterId):
        self._DedicatedClusterId = DedicatedClusterId


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressName = params.get("AddressName")
        self._AddressStatus = params.get("AddressStatus")
        self._AddressIp = params.get("AddressIp")
        self._InstanceId = params.get("InstanceId")
        self._CreatedTime = params.get("CreatedTime")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateAddressIp = params.get("PrivateAddressIp")
        self._IsArrears = params.get("IsArrears")
        self._IsBlocked = params.get("IsBlocked")
        self._IsEipDirectConnection = params.get("IsEipDirectConnection")
        self._AddressType = params.get("AddressType")
        self._CascadeRelease = params.get("CascadeRelease")
        if params.get("EipAlgType") is not None:
            self._EipAlgType = AlgType()
            self._EipAlgType._deserialize(params.get("EipAlgType"))
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._LocalBgp = params.get("LocalBgp")
        self._Bandwidth = params.get("Bandwidth")
        self._InternetChargeType = params.get("InternetChargeType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._DeadlineDate = params.get("DeadlineDate")
        self._InstanceType = params.get("InstanceType")
        self._Egress = params.get("Egress")
        self._AntiDDoSPackageId = params.get("AntiDDoSPackageId")
        self._RenewFlag = params.get("RenewFlag")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._UnVpcId = params.get("UnVpcId")
        self._DedicatedClusterId = params.get("DedicatedClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressChargePrepaid(AbstractModel):
    r"""EIP cost object

    """

    def __init__(self):
        r"""
        :param _Period: Purchased usage period, in month. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36
        :type Period: int
        :param _AutoRenewFlag: Setting of renewal. Valid values: 0: manual renewal; 1: auto-renewal; 2: no renewal after expiration. Default value: 0
        :type AutoRenewFlag: int
        """
        self._Period = None
        self._AutoRenewFlag = None

    @property
    def Period(self):
        r"""Purchased usage period, in month. Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def AutoRenewFlag(self):
        r"""Setting of renewal. Valid values: 0: manual renewal; 1: auto-renewal; 2: no renewal after expiration. Default value: 0
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag


    def _deserialize(self, params):
        self._Period = params.get("Period")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressInfo(AbstractModel):
    r"""IP address template information

    """

    def __init__(self):
        r"""
        :param _Address: IP address
        :type Address: str
        :param _Description: Remarks
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Description: str
        """
        self._Address = None
        self._Description = None

    @property
    def Address(self):
        r"""IP address
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def Description(self):
        r"""Remarks
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Address = params.get("Address")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplate(AbstractModel):
    r"""IP address template

    """

    def __init__(self):
        r"""
        :param _AddressTemplateName: IP address template name.
        :type AddressTemplateName: str
        :param _AddressTemplateId: The unique ID of the IP address template instance.
        :type AddressTemplateId: str
        :param _AddressSet: IP address information.
        :type AddressSet: list of str
        :param _CreatedTime: Creation Time.
        :type CreatedTime: str
        :param _AddressExtraSet: IP address information with remarks
        :type AddressExtraSet: list of AddressInfo
        """
        self._AddressTemplateName = None
        self._AddressTemplateId = None
        self._AddressSet = None
        self._CreatedTime = None
        self._AddressExtraSet = None

    @property
    def AddressTemplateName(self):
        r"""IP address template name.
        :rtype: str
        """
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def AddressTemplateId(self):
        r"""The unique ID of the IP address template instance.
        :rtype: str
        """
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressSet(self):
        r"""IP address information.
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def CreatedTime(self):
        r"""Creation Time.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def AddressExtraSet(self):
        r"""IP address information with remarks
        :rtype: list of AddressInfo
        """
        return self._AddressExtraSet

    @AddressExtraSet.setter
    def AddressExtraSet(self, AddressExtraSet):
        self._AddressExtraSet = AddressExtraSet


    def _deserialize(self, params):
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressSet = params.get("AddressSet")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("AddressExtraSet") is not None:
            self._AddressExtraSet = []
            for item in params.get("AddressExtraSet"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressExtraSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateGroup(AbstractModel):
    r"""IP address template group

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupName: IP address template group name.
        :type AddressTemplateGroupName: str
        :param _AddressTemplateGroupId: IP address template group instance ID, such as `ipmg-dih8xdbq`.
        :type AddressTemplateGroupId: str
        :param _AddressTemplateIdSet: IP address template ID.
        :type AddressTemplateIdSet: list of str
        :param _CreatedTime: Creation Time.
        :type CreatedTime: str
        :param _AddressTemplateSet: IP address template instance
        :type AddressTemplateSet: list of AddressTemplateItem
        """
        self._AddressTemplateGroupName = None
        self._AddressTemplateGroupId = None
        self._AddressTemplateIdSet = None
        self._CreatedTime = None
        self._AddressTemplateSet = None

    @property
    def AddressTemplateGroupName(self):
        r"""IP address template group name.
        :rtype: str
        """
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateGroupId(self):
        r"""IP address template group instance ID, such as `ipmg-dih8xdbq`.
        :rtype: str
        """
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId

    @property
    def AddressTemplateIdSet(self):
        r"""IP address template ID.
        :rtype: list of str
        """
        return self._AddressTemplateIdSet

    @AddressTemplateIdSet.setter
    def AddressTemplateIdSet(self, AddressTemplateIdSet):
        self._AddressTemplateIdSet = AddressTemplateIdSet

    @property
    def CreatedTime(self):
        r"""Creation Time.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def AddressTemplateSet(self):
        r"""IP address template instance
        :rtype: list of AddressTemplateItem
        """
        return self._AddressTemplateSet

    @AddressTemplateSet.setter
    def AddressTemplateSet(self, AddressTemplateSet):
        self._AddressTemplateSet = AddressTemplateSet


    def _deserialize(self, params):
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        self._AddressTemplateIdSet = params.get("AddressTemplateIdSet")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("AddressTemplateSet") is not None:
            self._AddressTemplateSet = []
            for item in params.get("AddressTemplateSet"):
                obj = AddressTemplateItem()
                obj._deserialize(item)
                self._AddressTemplateSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateItem(AbstractModel):
    r"""Address information

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: ipm-xxxxxxxx
        :type AddressTemplateId: str
        :param _AddressTemplateName: IP template name
        :type AddressTemplateName: str
        :param _From: Disused
        :type From: str
        :param _To: Disused
        :type To: str
        """
        self._AddressTemplateId = None
        self._AddressTemplateName = None
        self._From = None
        self._To = None

    @property
    def AddressTemplateId(self):
        r"""ipm-xxxxxxxx
        :rtype: str
        """
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressTemplateName(self):
        r"""IP template name
        :rtype: str
        """
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def From(self):
        r"""Disused
        :rtype: str
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        r"""Disused
        :rtype: str
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._From = params.get("From")
        self._To = params.get("To")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateSpecification(AbstractModel):
    r"""IP address template

    """

    def __init__(self):
        r"""
        :param _AddressId: The ID of the IP address, such as `ipm-2uw6ujo6`.
        :type AddressId: str
        :param _AddressGroupId: The ID of the IP address group, such as `ipmg-2uw6ujo6`.
        :type AddressGroupId: str
        """
        self._AddressId = None
        self._AddressGroupId = None

    @property
    def AddressId(self):
        r"""The ID of the IP address, such as `ipm-2uw6ujo6`.
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressGroupId(self):
        r"""The ID of the IP address group, such as `ipmg-2uw6ujo6`.
        :rtype: str
        """
        return self._AddressGroupId

    @AddressGroupId.setter
    def AddressGroupId(self, AddressGroupId):
        self._AddressGroupId = AddressGroupId


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressGroupId = params.get("AddressGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustPublicAddressRequest(AbstractModel):
    r"""AdjustPublicAddress request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The unique ID of the CVM instance, such as `ins-11112222`.
        :type InstanceId: str
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        """
        self._InstanceId = None
        self._AddressId = None

    @property
    def InstanceId(self):
        r"""The unique ID of the CVM instance, such as `ins-11112222`.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AddressId(self):
        r"""The unique ID of the EIP, such as `eip-11112222`.
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AddressId = params.get("AddressId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustPublicAddressResponse(AbstractModel):
    r"""AdjustPublicAddress response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AlgType(AbstractModel):
    r"""ALG protocol type

    """

    def __init__(self):
        r"""
        :param _Ftp: Whether FTP ALG is enabled
        :type Ftp: bool
        :param _Sip: Whether SIP ALG is enabled
        :type Sip: bool
        """
        self._Ftp = None
        self._Sip = None

    @property
    def Ftp(self):
        r"""Whether FTP ALG is enabled
        :rtype: bool
        """
        return self._Ftp

    @Ftp.setter
    def Ftp(self, Ftp):
        self._Ftp = Ftp

    @property
    def Sip(self):
        r"""Whether SIP ALG is enabled
        :rtype: bool
        """
        return self._Sip

    @Sip.setter
    def Sip(self, Sip):
        self._Sip = Sip


    def _deserialize(self, params):
        self._Ftp = params.get("Ftp")
        self._Sip = params.get("Sip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateAddressesRequest(AbstractModel):
    r"""AllocateAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _AddressCount: The number of EIPs. Default: 1.
        :type AddressCount: int
        :param _InternetServiceProvider: The EIP line type. Default: BGP.
<ul style="margin:0"><li>For a user who has activated the static single-line IP allowlist, possible values are:<ul><li>CMCC: China Mobile</li>
<li>CTCC: China Telecom</li>
<li>CUCC: China Unicom</li></ul>Note: Only certain regions support static single-line IP addresses.</li></ul>
        :type InternetServiceProvider: str
        :param _InternetChargeType: The EIP billing method.
<ul style="margin:0"><li>For bill-by-IP account beta users, valid values: <ul><li>BANDWIDTH_PACKAGE: paid by the [bandwidth package](https://intl.cloud.tencent.com/document/product/684/15255?from_cn_redirect=1)(who must also be bandwidth package beta users)</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR: billed by hourly bandwidth on a pay-as-you-go basis</li>
<li>BANDWIDTH_PREPAID_BY_MONTH: monthly bandwidth subscription</li>
<li>TRAFFIC_POSTPAID_BY_HOUR: billed by hourly traffic on a pay-as-you-go basis</li></ul>Default value: TRAFFIC_POSTPAID_BY_HOUR</li>
<li>If you are not a bill-by-IP account beta user, the EIP billing is the same as that for the instance bound to the EIP. Therefore, you do not need to pass in this parameter.</li></ul>
        :type InternetChargeType: str
        :param _InternetMaxBandwidthOut: The EIP outbound bandwidth cap, in Mbps.
<ul style="margin:0"><li>For bill-by-IP account beta users, the bandwidth cap range is determined by the EIP billing mode. <ul><li>`BANDWIDTH_PACKAGE`: 1 Mbps to 2000 Mbps</li>
<li>`BANDWIDTH_POSTPAID_BY_HOUR`: 1 Mbps to 100 Mbps</li>
<li>`BANDWIDTH_PREPAID_BY_MONTH`: 1 Mbps to 200 Mbps</li>
<li>`TRAFFIC_POSTPAID_BY_HOUR`: 1 Mbps to 100 Mbps</li></ul>Default value: 1 Mbps </li>
<li>If you are not a bill-by-IP account beta user, the EIP outbound bandwidth cap is subject to the bandwidth cap of the instance bound to the EIP. Therefore, you do not need to pass in this parameter. </li></ul>
        :type InternetMaxBandwidthOut: int
        :param _AddressChargePrepaid: A required billing parameter for an EIP billed by monthly bandwidth subscription. For EIPs using other billing modes, it can be ignored.
        :type AddressChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.AddressChargePrepaid`
        :param _AddressType: EIP type. Default value: EIP.
<ul style="margin:0"><li>For beta users of AIA, the value can be:</li></ul>`AnycastEIP`: an AIA IP address. For more information, see [Anycast Internet Acceleration](https://intl.cloud.tencent.com/document/product/644?from_cn_redirect=1).</li></ul>Note: Anycast EIPs are supported only in partial regions. </li></ul>
<ul style="margin:0"><li>For beta users of dedicated IP, the value can be: <ul><li>`HighQualityEIP`: Dedicated IP</li></ul>Note that dedicated IPs are only available in partial regions. </li></ul>
</ul>
<ul style="margin:0"><li>For beta users of Anti-DDoS IP, the value can be: <ul><li>`AntiDDoSEIP`: Anti-DDoS EIP</li></ul>Note that Anti-DDoS IPs are only available in partial regions. </li></ul>
        :type AddressType: str
        :param _AnycastZone: Anycast publishing region
<ul style="margin:0"><li>Valid for users who have activated AIA. Values:<ul><li>ANYCAST_ZONE_GLOBAL: global publishing region </li><li>ANYCAST_ZONE_OVERSEAS: overseas publishing region</li><li><b>**[Disused]**</b> ANYCAST_ZONE_A: publishing region A (updated to ANYCAST_ZONE_GLOBAL)</li><li><b>**[Disused]**</b> ANYCAST_ZONE_B: publishing region B (updated to ANYCAST_ZONE_GLOBAL)</li></ul>Default: ANYCAST_ZONE_OVERSEAS.</li></ul>
        :type AnycastZone: str
        :param _VipCluster: 
        :type VipCluster: list of str
        :param _ApplicableForCLB: <b>**[Disused]**</b>
Whether the Anycast EIP can be bound to CLB instances.
<ul style="margin:0"><li>Valid for users who have activated the AIA. Values:<ul><li>TRUE: the Anycast EIP can be bound to CLB instances.</li>
<li>FALSE: the Anycast EIP can be bound to CVMs, NAT gateways, and HAVIPs.</li></ul>Default: FALSE.</li></ul>
        :type ApplicableForCLB: bool
        :param _Tags: List of tags to be bound.
        :type Tags: list of Tag
        :param _BandwidthPackageId: The unique ID of a BGP bandwidth package. If you configure this parameter and set InternetChargeType as BANDWIDTH_PACKAGE, the new EIP is added to this package and billed by the bandwidth package mode.
        :type BandwidthPackageId: str
        :param _AddressName: EIP name, which is the custom EIP name given by the user when applying for the EIP. Default: not named
        :type AddressName: str
        :param _DedicatedClusterId: 
        :type DedicatedClusterId: str
        :param _IsDedicatedAddressPool: 
        :type IsDedicatedAddressPool: bool
        :param _Egress: Network egress. It defaults to `center_egress1`.
        :type Egress: str
        :param _AntiDDoSPackageId: Anti-DDoS service package ID. This is required when you want to request an Anti-DDoS IP.
        :type AntiDDoSPackageId: str
        :param _ClientToken: A string used to ensure the idempotency of the request. Generate a value based on your client. This can ensure that the value is unique for different requests. It only supports ASCII characters and can contain up to 64 characters. 
        :type ClientToken: str
        """
        self._AddressCount = None
        self._InternetServiceProvider = None
        self._InternetChargeType = None
        self._InternetMaxBandwidthOut = None
        self._AddressChargePrepaid = None
        self._AddressType = None
        self._AnycastZone = None
        self._VipCluster = None
        self._ApplicableForCLB = None
        self._Tags = None
        self._BandwidthPackageId = None
        self._AddressName = None
        self._DedicatedClusterId = None
        self._IsDedicatedAddressPool = None
        self._Egress = None
        self._AntiDDoSPackageId = None
        self._ClientToken = None

    @property
    def AddressCount(self):
        r"""The number of EIPs. Default: 1.
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def InternetServiceProvider(self):
        r"""The EIP line type. Default: BGP.
<ul style="margin:0"><li>For a user who has activated the static single-line IP allowlist, possible values are:<ul><li>CMCC: China Mobile</li>
<li>CTCC: China Telecom</li>
<li>CUCC: China Unicom</li></ul>Note: Only certain regions support static single-line IP addresses.</li></ul>
        :rtype: str
        """
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def InternetChargeType(self):
        r"""The EIP billing method.
<ul style="margin:0"><li>For bill-by-IP account beta users, valid values: <ul><li>BANDWIDTH_PACKAGE: paid by the [bandwidth package](https://intl.cloud.tencent.com/document/product/684/15255?from_cn_redirect=1)(who must also be bandwidth package beta users)</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR: billed by hourly bandwidth on a pay-as-you-go basis</li>
<li>BANDWIDTH_PREPAID_BY_MONTH: monthly bandwidth subscription</li>
<li>TRAFFIC_POSTPAID_BY_HOUR: billed by hourly traffic on a pay-as-you-go basis</li></ul>Default value: TRAFFIC_POSTPAID_BY_HOUR</li>
<li>If you are not a bill-by-IP account beta user, the EIP billing is the same as that for the instance bound to the EIP. Therefore, you do not need to pass in this parameter.</li></ul>
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def InternetMaxBandwidthOut(self):
        r"""The EIP outbound bandwidth cap, in Mbps.
<ul style="margin:0"><li>For bill-by-IP account beta users, the bandwidth cap range is determined by the EIP billing mode. <ul><li>`BANDWIDTH_PACKAGE`: 1 Mbps to 2000 Mbps</li>
<li>`BANDWIDTH_POSTPAID_BY_HOUR`: 1 Mbps to 100 Mbps</li>
<li>`BANDWIDTH_PREPAID_BY_MONTH`: 1 Mbps to 200 Mbps</li>
<li>`TRAFFIC_POSTPAID_BY_HOUR`: 1 Mbps to 100 Mbps</li></ul>Default value: 1 Mbps </li>
<li>If you are not a bill-by-IP account beta user, the EIP outbound bandwidth cap is subject to the bandwidth cap of the instance bound to the EIP. Therefore, you do not need to pass in this parameter. </li></ul>
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def AddressChargePrepaid(self):
        r"""A required billing parameter for an EIP billed by monthly bandwidth subscription. For EIPs using other billing modes, it can be ignored.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AddressChargePrepaid`
        """
        return self._AddressChargePrepaid

    @AddressChargePrepaid.setter
    def AddressChargePrepaid(self, AddressChargePrepaid):
        self._AddressChargePrepaid = AddressChargePrepaid

    @property
    def AddressType(self):
        r"""EIP type. Default value: EIP.
<ul style="margin:0"><li>For beta users of AIA, the value can be:</li></ul>`AnycastEIP`: an AIA IP address. For more information, see [Anycast Internet Acceleration](https://intl.cloud.tencent.com/document/product/644?from_cn_redirect=1).</li></ul>Note: Anycast EIPs are supported only in partial regions. </li></ul>
<ul style="margin:0"><li>For beta users of dedicated IP, the value can be: <ul><li>`HighQualityEIP`: Dedicated IP</li></ul>Note that dedicated IPs are only available in partial regions. </li></ul>
</ul>
<ul style="margin:0"><li>For beta users of Anti-DDoS IP, the value can be: <ul><li>`AntiDDoSEIP`: Anti-DDoS EIP</li></ul>Note that Anti-DDoS IPs are only available in partial regions. </li></ul>
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def AnycastZone(self):
        r"""Anycast publishing region
<ul style="margin:0"><li>Valid for users who have activated AIA. Values:<ul><li>ANYCAST_ZONE_GLOBAL: global publishing region </li><li>ANYCAST_ZONE_OVERSEAS: overseas publishing region</li><li><b>**[Disused]**</b> ANYCAST_ZONE_A: publishing region A (updated to ANYCAST_ZONE_GLOBAL)</li><li><b>**[Disused]**</b> ANYCAST_ZONE_B: publishing region B (updated to ANYCAST_ZONE_GLOBAL)</li></ul>Default: ANYCAST_ZONE_OVERSEAS.</li></ul>
        :rtype: str
        """
        return self._AnycastZone

    @AnycastZone.setter
    def AnycastZone(self, AnycastZone):
        self._AnycastZone = AnycastZone

    @property
    def VipCluster(self):
        r"""
        :rtype: list of str
        """
        return self._VipCluster

    @VipCluster.setter
    def VipCluster(self, VipCluster):
        self._VipCluster = VipCluster

    @property
    def ApplicableForCLB(self):
        r"""<b>**[Disused]**</b>
Whether the Anycast EIP can be bound to CLB instances.
<ul style="margin:0"><li>Valid for users who have activated the AIA. Values:<ul><li>TRUE: the Anycast EIP can be bound to CLB instances.</li>
<li>FALSE: the Anycast EIP can be bound to CVMs, NAT gateways, and HAVIPs.</li></ul>Default: FALSE.</li></ul>
        :rtype: bool
        """
        return self._ApplicableForCLB

    @ApplicableForCLB.setter
    def ApplicableForCLB(self, ApplicableForCLB):
        self._ApplicableForCLB = ApplicableForCLB

    @property
    def Tags(self):
        r"""List of tags to be bound.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def BandwidthPackageId(self):
        r"""The unique ID of a BGP bandwidth package. If you configure this parameter and set InternetChargeType as BANDWIDTH_PACKAGE, the new EIP is added to this package and billed by the bandwidth package mode.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def AddressName(self):
        r"""EIP name, which is the custom EIP name given by the user when applying for the EIP. Default: not named
        :rtype: str
        """
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def DedicatedClusterId(self):
        r"""
        :rtype: str
        """
        return self._DedicatedClusterId

    @DedicatedClusterId.setter
    def DedicatedClusterId(self, DedicatedClusterId):
        self._DedicatedClusterId = DedicatedClusterId

    @property
    def IsDedicatedAddressPool(self):
        r"""
        :rtype: bool
        """
        return self._IsDedicatedAddressPool

    @IsDedicatedAddressPool.setter
    def IsDedicatedAddressPool(self, IsDedicatedAddressPool):
        self._IsDedicatedAddressPool = IsDedicatedAddressPool

    @property
    def Egress(self):
        r"""Network egress. It defaults to `center_egress1`.
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def AntiDDoSPackageId(self):
        r"""Anti-DDoS service package ID. This is required when you want to request an Anti-DDoS IP.
        :rtype: str
        """
        return self._AntiDDoSPackageId

    @AntiDDoSPackageId.setter
    def AntiDDoSPackageId(self, AntiDDoSPackageId):
        self._AntiDDoSPackageId = AntiDDoSPackageId

    @property
    def ClientToken(self):
        r"""A string used to ensure the idempotency of the request. Generate a value based on your client. This can ensure that the value is unique for different requests. It only supports ASCII characters and can contain up to 64 characters. 
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._AddressCount = params.get("AddressCount")
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._InternetChargeType = params.get("InternetChargeType")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        if params.get("AddressChargePrepaid") is not None:
            self._AddressChargePrepaid = AddressChargePrepaid()
            self._AddressChargePrepaid._deserialize(params.get("AddressChargePrepaid"))
        self._AddressType = params.get("AddressType")
        self._AnycastZone = params.get("AnycastZone")
        self._VipCluster = params.get("VipCluster")
        self._ApplicableForCLB = params.get("ApplicableForCLB")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._AddressName = params.get("AddressName")
        self._DedicatedClusterId = params.get("DedicatedClusterId")
        self._IsDedicatedAddressPool = params.get("IsDedicatedAddressPool")
        self._Egress = params.get("Egress")
        self._AntiDDoSPackageId = params.get("AntiDDoSPackageId")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateAddressesResponse(AbstractModel):
    r"""AllocateAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _AddressSet: List of the unique IDs of the requested EIPs.
        :type AddressSet: list of str
        :param _TaskId: The Async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressSet = None
        self._TaskId = None
        self._RequestId = None

    @property
    def AddressSet(self):
        r"""List of the unique IDs of the requested EIPs.
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def TaskId(self):
        r"""The Async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AddressSet = params.get("AddressSet")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AllocateIPv6AddressesRequest(AbstractModel):
    r"""AllocateIPv6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _AddressName: EIPv6 name, which is the custom EIPv6 name given by the user when the user applies for the EIPv6. Default: not named.
        :type AddressName: str
        :param _AddressType: Indicates the type of EIPv6. Valid values:

- EIPv6: common IPv6
- HighQualityEIPv6: dedicated IPv6
Note: Contact the product team to enable the dedicated IPv6 allowlist. The dedicated IPv6 is only supported in some regions.

Default: EIPv6.
        :type AddressType: str
        :param _AddressCount: Number of applied EIPv6 addresses. Default: 1.
        :type AddressCount: int
        :param _InternetChargeType: Indicates the billing method of EIPv6. Valid values:

- BANDWIDTH_PACKAGE: billed by [Bandwidth Package](https://intl.cloud.tencent.com/document/product/684/15255?from_cn_redirect=1)
- TRAFFIC_POSTPAID_BY_HOUR: postpaid by traffic on an hourly basis

Default: TRAFFIC_POSTPAID_BY_HOUR.
        :type InternetChargeType: str
        :param _InternetServiceProvider: Indicates the type of EIPv6 line. Default: BGP.

For a user who has enabled the static single-line IP allowlist, valid values include:
- CMCC: China Mobile
- CTCC: China Telecom
- CUCC: China Unicom
Note: The static single-line IP is only supported in some regions.
        :type InternetServiceProvider: str
        :param _InternetMaxBandwidthOut: EIPv6 bandwidth cap, in Mbps.

Valid values depend on the EIP billing method:

- BANDWIDTH_PACKAGE: 1 Mbps to 2000 Mbps
- TRAFFIC_POSTPAID_BY_HOUR: 1 Mbps to 100 Mbps

Default: 1 Mbps.
        :type InternetMaxBandwidthOut: int
        :param _BandwidthPackageId: Unique ID of the bandwidth package.
Setting this parameter and having InternetChargeType as BANDWIDTH_PACKAGE indicate that the created EIP will join this BGP bandwidth package and the billing method of bandwidth package will be adopted.
        :type BandwidthPackageId: str
        :param _Tags: List of tags to be associated.
        :type Tags: list of Tag
        :param _Egress: EIPv6 network egress. Valid values:

- CENTER_EGRESS_1: Central egress point 1
- CENTER_EGRESS_2: Central egress point 2
- CENTER_EGRESS_3: Central egress point 3
Note: The network egress for different Internet Service Providers (ISPs) or resource types requires contacting the product team for enablement.

Default: CENTER_EGRESS_1.
        :type Egress: str
        """
        self._AddressName = None
        self._AddressType = None
        self._AddressCount = None
        self._InternetChargeType = None
        self._InternetServiceProvider = None
        self._InternetMaxBandwidthOut = None
        self._BandwidthPackageId = None
        self._Tags = None
        self._Egress = None

    @property
    def AddressName(self):
        r"""EIPv6 name, which is the custom EIPv6 name given by the user when the user applies for the EIPv6. Default: not named.
        :rtype: str
        """
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def AddressType(self):
        r"""Indicates the type of EIPv6. Valid values:

- EIPv6: common IPv6
- HighQualityEIPv6: dedicated IPv6
Note: Contact the product team to enable the dedicated IPv6 allowlist. The dedicated IPv6 is only supported in some regions.

Default: EIPv6.
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def AddressCount(self):
        r"""Number of applied EIPv6 addresses. Default: 1.
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def InternetChargeType(self):
        r"""Indicates the billing method of EIPv6. Valid values:

- BANDWIDTH_PACKAGE: billed by [Bandwidth Package](https://intl.cloud.tencent.com/document/product/684/15255?from_cn_redirect=1)
- TRAFFIC_POSTPAID_BY_HOUR: postpaid by traffic on an hourly basis

Default: TRAFFIC_POSTPAID_BY_HOUR.
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def InternetServiceProvider(self):
        r"""Indicates the type of EIPv6 line. Default: BGP.

For a user who has enabled the static single-line IP allowlist, valid values include:
- CMCC: China Mobile
- CTCC: China Telecom
- CUCC: China Unicom
Note: The static single-line IP is only supported in some regions.
        :rtype: str
        """
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def InternetMaxBandwidthOut(self):
        r"""EIPv6 bandwidth cap, in Mbps.

Valid values depend on the EIP billing method:

- BANDWIDTH_PACKAGE: 1 Mbps to 2000 Mbps
- TRAFFIC_POSTPAID_BY_HOUR: 1 Mbps to 100 Mbps

Default: 1 Mbps.
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def BandwidthPackageId(self):
        r"""Unique ID of the bandwidth package.
Setting this parameter and having InternetChargeType as BANDWIDTH_PACKAGE indicate that the created EIP will join this BGP bandwidth package and the billing method of bandwidth package will be adopted.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def Tags(self):
        r"""List of tags to be associated.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Egress(self):
        r"""EIPv6 network egress. Valid values:

- CENTER_EGRESS_1: Central egress point 1
- CENTER_EGRESS_2: Central egress point 2
- CENTER_EGRESS_3: Central egress point 3
Note: The network egress for different Internet Service Providers (ISPs) or resource types requires contacting the product team for enablement.

Default: CENTER_EGRESS_1.
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        self._AddressName = params.get("AddressName")
        self._AddressType = params.get("AddressType")
        self._AddressCount = params.get("AddressCount")
        self._InternetChargeType = params.get("InternetChargeType")
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Egress = params.get("Egress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateIPv6AddressesResponse(AbstractModel):
    r"""AllocateIPv6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _AddressSet: List of unique IDs of applied EIPv6 addresses.
        :type AddressSet: list of str
        :param _TaskId: Async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressSet = None
        self._TaskId = None
        self._RequestId = None

    @property
    def AddressSet(self):
        r"""List of unique IDs of applied EIPv6 addresses.
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def TaskId(self):
        r"""Async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AddressSet = params.get("AddressSet")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AllocateIp6AddressesBandwidthRequest(AbstractModel):
    r"""AllocateIp6AddressesBandwidth request structure.

    """

    def __init__(self):
        r"""
        :param _Ip6Addresses: IPv6 addresses that require the public network access capability.
        :type Ip6Addresses: list of str
        :param _InternetMaxBandwidthOut: Bandwidth, in Mbps. The default value is 1 Mbps.
        :type InternetMaxBandwidthOut: int
        :param _InternetChargeType: Network billing mode. IPv6 addresses currently support "TRAFFIC_POSTPAID_BY_HOUR" and "BANDWIDTH_PACKAGE". The default network billing mode is "TRAFFIC_POSTPAID_BY_HOUR".
        :type InternetChargeType: str
        :param _BandwidthPackageId: Bandwidth package ID. This ID is required for standard accounts to add the IPv6 addresses to the bandwidth package, thus using the billing mode.
        :type BandwidthPackageId: str
        :param _Tags: List of tags to be associated.		
        :type Tags: list of Tag
        """
        self._Ip6Addresses = None
        self._InternetMaxBandwidthOut = None
        self._InternetChargeType = None
        self._BandwidthPackageId = None
        self._Tags = None

    @property
    def Ip6Addresses(self):
        r"""IPv6 addresses that require the public network access capability.
        :rtype: list of str
        """
        return self._Ip6Addresses

    @Ip6Addresses.setter
    def Ip6Addresses(self, Ip6Addresses):
        self._Ip6Addresses = Ip6Addresses

    @property
    def InternetMaxBandwidthOut(self):
        r"""Bandwidth, in Mbps. The default value is 1 Mbps.
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def InternetChargeType(self):
        r"""Network billing mode. IPv6 addresses currently support "TRAFFIC_POSTPAID_BY_HOUR" and "BANDWIDTH_PACKAGE". The default network billing mode is "TRAFFIC_POSTPAID_BY_HOUR".
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def BandwidthPackageId(self):
        r"""Bandwidth package ID. This ID is required for standard accounts to add the IPv6 addresses to the bandwidth package, thus using the billing mode.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def Tags(self):
        r"""List of tags to be associated.		
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Ip6Addresses = params.get("Ip6Addresses")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._InternetChargeType = params.get("InternetChargeType")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateIp6AddressesBandwidthResponse(AbstractModel):
    r"""AllocateIp6AddressesBandwidth response structure.

    """

    def __init__(self):
        r"""
        :param _AddressSet: List of unique IDs of Classic elastic Public IPv6 instances.
        :type AddressSet: list of str
        :param _TaskId: Asynchronous task ID. You can call the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressSet = None
        self._TaskId = None
        self._RequestId = None

    @property
    def AddressSet(self):
        r"""List of unique IDs of Classic elastic Public IPv6 instances.
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def TaskId(self):
        r"""Asynchronous task ID. You can call the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AddressSet = params.get("AddressSet")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AssignIpv6AddressesRequest(AbstractModel):
    r"""AssignIpv6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The `ID` of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _Ipv6Addresses: A list of `IPv6` addresses. You can specify a maximum of 10 at one time. The quota is calculated together with that of `Ipv6AddressCount`, a required input parameter alternative to this one.
        :type Ipv6Addresses: list of Ipv6Address
        :param _Ipv6AddressCount: The number of automatically assigned `IPv6` addresses. The total number of private IP addresses cannot exceed the quota. The quota is calculated together with that of `Ipv6Addresses`, a required input parameter alternative to this one.
        :type Ipv6AddressCount: int
        """
        self._NetworkInterfaceId = None
        self._Ipv6Addresses = None
        self._Ipv6AddressCount = None

    @property
    def NetworkInterfaceId(self):
        r"""The `ID` of the ENI instance, such as `eni-m6dyj72l`.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def Ipv6Addresses(self):
        r"""A list of `IPv6` addresses. You can specify a maximum of 10 at one time. The quota is calculated together with that of `Ipv6AddressCount`, a required input parameter alternative to this one.
        :rtype: list of Ipv6Address
        """
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses

    @property
    def Ipv6AddressCount(self):
        r"""The number of automatically assigned `IPv6` addresses. The total number of private IP addresses cannot exceed the quota. The quota is calculated together with that of `Ipv6Addresses`, a required input parameter alternative to this one.
        :rtype: int
        """
        return self._Ipv6AddressCount

    @Ipv6AddressCount.setter
    def Ipv6AddressCount(self, Ipv6AddressCount):
        self._Ipv6AddressCount = Ipv6AddressCount


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("Ipv6Addresses") is not None:
            self._Ipv6Addresses = []
            for item in params.get("Ipv6Addresses"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6Addresses.append(obj)
        self._Ipv6AddressCount = params.get("Ipv6AddressCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6AddressesResponse(AbstractModel):
    r"""AssignIpv6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6AddressSet: The list of `IPv6` addresses assigned to ENIs.
        :type Ipv6AddressSet: list of Ipv6Address
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6AddressSet = None
        self._RequestId = None

    @property
    def Ipv6AddressSet(self):
        r"""The list of `IPv6` addresses assigned to ENIs.
        :rtype: list of Ipv6Address
        """
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssignIpv6CidrBlockRequest(AbstractModel):
    r"""AssignIpv6CidrBlock request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        r"""The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6CidrBlockResponse(AbstractModel):
    r"""AssignIpv6CidrBlock response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6CidrBlock: The assigned `IPv6` IP range, such as `3402:4e00:20:1000::/56`
        :type Ipv6CidrBlock: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6CidrBlock = None
        self._RequestId = None

    @property
    def Ipv6CidrBlock(self):
        r"""The assigned `IPv6` IP range, such as `3402:4e00:20:1000::/56`
        :rtype: str
        """
        return self._Ipv6CidrBlock

    @Ipv6CidrBlock.setter
    def Ipv6CidrBlock(self, Ipv6CidrBlock):
        self._Ipv6CidrBlock = Ipv6CidrBlock

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ipv6CidrBlock = params.get("Ipv6CidrBlock")
        self._RequestId = params.get("RequestId")


class AssignIpv6SubnetCidrBlockRequest(AbstractModel):
    r"""AssignIpv6SubnetCidrBlock request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the VPC where the subnet is located, such as `vpc-f49l6u0z`.
        :type VpcId: str
        :param _Ipv6SubnetCidrBlocks: The assigned `IPv6` subnet IP range list.
        :type Ipv6SubnetCidrBlocks: list of Ipv6SubnetCidrBlock
        """
        self._VpcId = None
        self._Ipv6SubnetCidrBlocks = None

    @property
    def VpcId(self):
        r"""The `ID` of the VPC where the subnet is located, such as `vpc-f49l6u0z`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Ipv6SubnetCidrBlocks(self):
        r"""The assigned `IPv6` subnet IP range list.
        :rtype: list of Ipv6SubnetCidrBlock
        """
        return self._Ipv6SubnetCidrBlocks

    @Ipv6SubnetCidrBlocks.setter
    def Ipv6SubnetCidrBlocks(self, Ipv6SubnetCidrBlocks):
        self._Ipv6SubnetCidrBlocks = Ipv6SubnetCidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        if params.get("Ipv6SubnetCidrBlocks") is not None:
            self._Ipv6SubnetCidrBlocks = []
            for item in params.get("Ipv6SubnetCidrBlocks"):
                obj = Ipv6SubnetCidrBlock()
                obj._deserialize(item)
                self._Ipv6SubnetCidrBlocks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6SubnetCidrBlockResponse(AbstractModel):
    r"""AssignIpv6SubnetCidrBlock response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6SubnetCidrBlockSet: The assigned `IPv6` subnet IP range list.
        :type Ipv6SubnetCidrBlockSet: list of Ipv6SubnetCidrBlock
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6SubnetCidrBlockSet = None
        self._RequestId = None

    @property
    def Ipv6SubnetCidrBlockSet(self):
        r"""The assigned `IPv6` subnet IP range list.
        :rtype: list of Ipv6SubnetCidrBlock
        """
        return self._Ipv6SubnetCidrBlockSet

    @Ipv6SubnetCidrBlockSet.setter
    def Ipv6SubnetCidrBlockSet(self, Ipv6SubnetCidrBlockSet):
        self._Ipv6SubnetCidrBlockSet = Ipv6SubnetCidrBlockSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6SubnetCidrBlockSet") is not None:
            self._Ipv6SubnetCidrBlockSet = []
            for item in params.get("Ipv6SubnetCidrBlockSet"):
                obj = Ipv6SubnetCidrBlock()
                obj._deserialize(item)
                self._Ipv6SubnetCidrBlockSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssignPrivateIpAddressesRequest(AbstractModel):
    r"""AssignPrivateIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _PrivateIpAddresses: The information on private IP addresses, of which you can specify a maximum of 10 at a time. You should provide either this parameter or SecondaryPrivateIpAddressCount, or both.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _SecondaryPrivateIpAddressCount: The number of newly-applied private IP addresses. You should provide either this parameter or PrivateIpAddresses, or both. The total number of private IP addresses cannot exceed the quota. For more information, see<a href="/document/product/576/18527">ENI Use Limits</a>.
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP service level. It is used together with `SecondaryPrivateIpAddressCount`. Values: PT` (Gold), `AU` (Silver), `AG `(Bronze) and DEFAULT (Default).
        :type QosLevel: str
        :param _ClientToken: 
        :type ClientToken: str
        """
        self._NetworkInterfaceId = None
        self._PrivateIpAddresses = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._ClientToken = None

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the ENI instance, such as `eni-m6dyj72l`.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddresses(self):
        r"""The information on private IP addresses, of which you can specify a maximum of 10 at a time. You should provide either this parameter or SecondaryPrivateIpAddressCount, or both.
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def SecondaryPrivateIpAddressCount(self):
        r"""The number of newly-applied private IP addresses. You should provide either this parameter or PrivateIpAddresses, or both. The total number of private IP addresses cannot exceed the quota. For more information, see<a href="/document/product/576/18527">ENI Use Limits</a>.
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        r"""IP service level. It is used together with `SecondaryPrivateIpAddressCount`. Values: PT` (Gold), `AU` (Silver), `AG `(Bronze) and DEFAULT (Default).
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def ClientToken(self):
        r"""
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignPrivateIpAddressesResponse(AbstractModel):
    r"""AssignPrivateIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _PrivateIpAddressSet: The detailed information of the Private IP.
        :type PrivateIpAddressSet: list of PrivateIpAddressSpecification
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PrivateIpAddressSet = None
        self._RequestId = None

    @property
    def PrivateIpAddressSet(self):
        r"""The detailed information of the Private IP.
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddressSet

    @PrivateIpAddressSet.setter
    def PrivateIpAddressSet(self, PrivateIpAddressSet):
        self._PrivateIpAddressSet = PrivateIpAddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PrivateIpAddressSet") is not None:
            self._PrivateIpAddressSet = []
            for item in params.get("PrivateIpAddressSet"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssistantCidr(AbstractModel):
    r"""Information about the secondary CIDR of the VPC.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of a `VPC` instance, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _CidrBlock: The secondary CIDR, such as `172.16.0.0/16`.
        :type CidrBlock: str
        :param _AssistantType: The secondary CIDR block type. 0: common secondary CIDR block. 1: container secondary CIDR block. Default: 0.
        :type AssistantType: int
        :param _SubnetSet: Subnet Split by Auxiliary CIDR
        :type SubnetSet: list of Subnet
        """
        self._VpcId = None
        self._CidrBlock = None
        self._AssistantType = None
        self._SubnetSet = None

    @property
    def VpcId(self):
        r"""The `ID` of a `VPC` instance, such as `vpc-6v2ht8q5`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlock(self):
        r"""The secondary CIDR, such as `172.16.0.0/16`.
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def AssistantType(self):
        r"""The secondary CIDR block type. 0: common secondary CIDR block. 1: container secondary CIDR block. Default: 0.
        :rtype: int
        """
        return self._AssistantType

    @AssistantType.setter
    def AssistantType(self, AssistantType):
        self._AssistantType = AssistantType

    @property
    def SubnetSet(self):
        r"""Subnet Split by Auxiliary CIDR
        :rtype: list of Subnet
        """
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlock = params.get("CidrBlock")
        self._AssistantType = params.get("AssistantType")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateAddressRequest(AbstractModel):
    r"""AssociateAddress request structure.

    """

    def __init__(self):
        r"""
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        :param _InstanceId: The ID of the instance to be bound, such as `ins-11112222`, `lb-11112222`. You can query the instance ID by logging into the [Console](https://console.cloud.tencent.com/cvm). You can also obtain the parameter value from the `InstanceId` field in the returned result of [DescribeInstances](https://intl.cloud.tencent.com/document/api/213/15728?from_cn_redirect=1) API.
        :type InstanceId: str
        :param _NetworkInterfaceId: The ID of the ENI to be bonud, such as `eni-11112222`. `NetworkInterfaceId` and `InstanceId` cannot be specified at the same time. You can query the ENI ID by logging into the [Console](https://console.cloud.tencent.com/vpc/eni). You can also obtain the parameter value from the `networkInterfaceId` field in the returned result of [DescribeNetworkInterfaces](https://intl.cloud.tencent.com/document/api/215/15817?from_cn_redirect=1) API.
        :type NetworkInterfaceId: str
        :param _PrivateIpAddress: The private IP to be bound. If you specify `NetworkInterfaceId`, then you must also specify `PrivateIpAddress`, indicating the EIP is bound to the specified private IP of the specified ENI. At the same time, you must ensure the specified `PrivateIpAddress` is a private IP on the `NetworkInterfaceId`. You can query the private IP of the specified ENI by logging into the [Console](https://console.cloud.tencent.com/vpc/eni). You can also obtain the parameter value from the `privateIpAddress` field in the returned result of [DescribeNetworkInterfaces](https://intl.cloud.tencent.com/document/api/215/15817?from_cn_redirect=1) API.
        :type PrivateIpAddress: str
        :param _EipDirectConnection: Specify whether to configure direct access when binding EIPs. For details, see [EIP Direct Access](https://intl.cloud.tencent.com/document/product/213/12540). Valid values: `True` and `False` (default). This parameter can be set to `True` when binding EIPs to a CVM instance or EKS cluster. It is in a beta test. To try it out, please [submit a ticket](https://console.cloud.tencent.com/workorder/category?level1_id=6&level2_id=163&source=0&data_title=%E8%B4%9F%E8%BD%BD%E5%9D%87%E8%A1%A1%20CLB&level3_id=1071&queue=96&scene_code=34639&step=2).
        :type EipDirectConnection: bool
        """
        self._AddressId = None
        self._InstanceId = None
        self._NetworkInterfaceId = None
        self._PrivateIpAddress = None
        self._EipDirectConnection = None

    @property
    def AddressId(self):
        r"""The unique ID of the EIP, such as `eip-11112222`.
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def InstanceId(self):
        r"""The ID of the instance to be bound, such as `ins-11112222`, `lb-11112222`. You can query the instance ID by logging into the [Console](https://console.cloud.tencent.com/cvm). You can also obtain the parameter value from the `InstanceId` field in the returned result of [DescribeInstances](https://intl.cloud.tencent.com/document/api/213/15728?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the ENI to be bonud, such as `eni-11112222`. `NetworkInterfaceId` and `InstanceId` cannot be specified at the same time. You can query the ENI ID by logging into the [Console](https://console.cloud.tencent.com/vpc/eni). You can also obtain the parameter value from the `networkInterfaceId` field in the returned result of [DescribeNetworkInterfaces](https://intl.cloud.tencent.com/document/api/215/15817?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddress(self):
        r"""The private IP to be bound. If you specify `NetworkInterfaceId`, then you must also specify `PrivateIpAddress`, indicating the EIP is bound to the specified private IP of the specified ENI. At the same time, you must ensure the specified `PrivateIpAddress` is a private IP on the `NetworkInterfaceId`. You can query the private IP of the specified ENI by logging into the [Console](https://console.cloud.tencent.com/vpc/eni). You can also obtain the parameter value from the `privateIpAddress` field in the returned result of [DescribeNetworkInterfaces](https://intl.cloud.tencent.com/document/api/215/15817?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def EipDirectConnection(self):
        r"""Specify whether to configure direct access when binding EIPs. For details, see [EIP Direct Access](https://intl.cloud.tencent.com/document/product/213/12540). Valid values: `True` and `False` (default). This parameter can be set to `True` when binding EIPs to a CVM instance or EKS cluster. It is in a beta test. To try it out, please [submit a ticket](https://console.cloud.tencent.com/workorder/category?level1_id=6&level2_id=163&source=0&data_title=%E8%B4%9F%E8%BD%BD%E5%9D%87%E8%A1%A1%20CLB&level3_id=1071&queue=96&scene_code=34639&step=2).
        :rtype: bool
        """
        return self._EipDirectConnection

    @EipDirectConnection.setter
    def EipDirectConnection(self, EipDirectConnection):
        self._EipDirectConnection = EipDirectConnection


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._InstanceId = params.get("InstanceId")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._EipDirectConnection = params.get("EipDirectConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateAddressResponse(AbstractModel):
    r"""AssociateAddress response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AssociateDirectConnectGatewayNatGatewayRequest(AbstractModel):
    r"""AssociateDirectConnectGatewayNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID. VPC instance ID, which can be obtained from the `VpcId` field in the response of the `DescribeVpcs` API.
        :type VpcId: str
        :param _NatGatewayId: The NAT Gateway ID.
        :type NatGatewayId: str
        :param _DirectConnectGatewayId: The direct connect gateway ID.
        :type DirectConnectGatewayId: str
        """
        self._VpcId = None
        self._NatGatewayId = None
        self._DirectConnectGatewayId = None

    @property
    def VpcId(self):
        r"""VPC instance ID. VPC instance ID, which can be obtained from the `VpcId` field in the response of the `DescribeVpcs` API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NatGatewayId(self):
        r"""The NAT Gateway ID.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DirectConnectGatewayId(self):
        r"""The direct connect gateway ID.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NatGatewayId = params.get("NatGatewayId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateDirectConnectGatewayNatGatewayResponse(AbstractModel):
    r"""AssociateDirectConnectGatewayNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateIPv6AddressRequest(AbstractModel):
    r"""AssociateIPv6Address request structure.

    """

    def __init__(self):
        r"""
        :param _IPv6AddressId: Unique ID of the EIPv6, such as eipv6-11112222.
        :type IPv6AddressId: str
        :param _NetworkInterfaceId: ID of the ENI to be bound, such as eni-11112222. NetworkInterfaceId and InstanceId cannot be specified at the same time. The ENI ID can be queried by logging in to the console or obtained from the networkInterfaceId field in the returned value of the DescribeNetworkInterfaces API.
        :type NetworkInterfaceId: str
        :param _PrivateIPv6Address: Private IPv6 to be bound. If NetworkInterfaceId is specified, PrivateIPv6Address must also be specified, which indicates that the EIP will be bound to the specified private IPv6 of the specified ENI. At the same time, it shall be ensured that the specified PrivateIPv6Address is a private IPv6 on the specified NetworkInterfaceId. The specified ENI's private IPv6 can be queried by logging in to the console or obtained from the Ipv6AddressSet.Address field in the returned value of the DescribeNetworkInterfaces API.
        :type PrivateIPv6Address: str
        """
        self._IPv6AddressId = None
        self._NetworkInterfaceId = None
        self._PrivateIPv6Address = None

    @property
    def IPv6AddressId(self):
        r"""Unique ID of the EIPv6, such as eipv6-11112222.
        :rtype: str
        """
        return self._IPv6AddressId

    @IPv6AddressId.setter
    def IPv6AddressId(self, IPv6AddressId):
        self._IPv6AddressId = IPv6AddressId

    @property
    def NetworkInterfaceId(self):
        r"""ID of the ENI to be bound, such as eni-11112222. NetworkInterfaceId and InstanceId cannot be specified at the same time. The ENI ID can be queried by logging in to the console or obtained from the networkInterfaceId field in the returned value of the DescribeNetworkInterfaces API.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIPv6Address(self):
        r"""Private IPv6 to be bound. If NetworkInterfaceId is specified, PrivateIPv6Address must also be specified, which indicates that the EIP will be bound to the specified private IPv6 of the specified ENI. At the same time, it shall be ensured that the specified PrivateIPv6Address is a private IPv6 on the specified NetworkInterfaceId. The specified ENI's private IPv6 can be queried by logging in to the console or obtained from the Ipv6AddressSet.Address field in the returned value of the DescribeNetworkInterfaces API.
        :rtype: str
        """
        return self._PrivateIPv6Address

    @PrivateIPv6Address.setter
    def PrivateIPv6Address(self, PrivateIPv6Address):
        self._PrivateIPv6Address = PrivateIPv6Address


    def _deserialize(self, params):
        self._IPv6AddressId = params.get("IPv6AddressId")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateIPv6Address = params.get("PrivateIPv6Address")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateIPv6AddressResponse(AbstractModel):
    r"""AssociateIPv6Address response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNatGatewayAddressRequest(AbstractModel):
    r"""AssociateNatGatewayAddress request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _AddressCount: The number of EIPs you want to apply for. Either `AddressCount` or `PublicAddresses` must be passed in.
        :type AddressCount: int
        :param _PublicIpAddresses: Array of the EIPs bound to the NAT gateway. Either `AddressCount` or `PublicAddresses` must be passed in.
        :type PublicIpAddresses: list of str
        :param _Zone: The availability zone of the EIP, which is passed in when the EIP is automatically assigned.
        :type Zone: str
        :param _StockPublicIpAddressesBandwidthOut: The bandwidth size (in Mbps) of the EIP bound to the NAT gateway, which defaults to the maximum value applicable for the current user type.
        :type StockPublicIpAddressesBandwidthOut: int
        :param _PublicIpAddressesBandwidthOut: The size of the public network IP bandwidth to be applied for (in Mbps), which defaults to the maximum value applicable for the current user type.
        :type PublicIpAddressesBandwidthOut: int
        :param _PublicIpFromSameZone: Whether the public IP and the NAT gateway must be in the same availability zone. Valid values: `true` and `false`. This parameter is valid only when `Zone` is specified.
        :type PublicIpFromSameZone: bool
        """
        self._NatGatewayId = None
        self._AddressCount = None
        self._PublicIpAddresses = None
        self._Zone = None
        self._StockPublicIpAddressesBandwidthOut = None
        self._PublicIpAddressesBandwidthOut = None
        self._PublicIpFromSameZone = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT gateway, such as `nat-df45454`.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def AddressCount(self):
        r"""The number of EIPs you want to apply for. Either `AddressCount` or `PublicAddresses` must be passed in.
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def PublicIpAddresses(self):
        r"""Array of the EIPs bound to the NAT gateway. Either `AddressCount` or `PublicAddresses` must be passed in.
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def Zone(self):
        r"""The availability zone of the EIP, which is passed in when the EIP is automatically assigned.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def StockPublicIpAddressesBandwidthOut(self):
        r"""The bandwidth size (in Mbps) of the EIP bound to the NAT gateway, which defaults to the maximum value applicable for the current user type.
        :rtype: int
        """
        return self._StockPublicIpAddressesBandwidthOut

    @StockPublicIpAddressesBandwidthOut.setter
    def StockPublicIpAddressesBandwidthOut(self, StockPublicIpAddressesBandwidthOut):
        self._StockPublicIpAddressesBandwidthOut = StockPublicIpAddressesBandwidthOut

    @property
    def PublicIpAddressesBandwidthOut(self):
        r"""The size of the public network IP bandwidth to be applied for (in Mbps), which defaults to the maximum value applicable for the current user type.
        :rtype: int
        """
        return self._PublicIpAddressesBandwidthOut

    @PublicIpAddressesBandwidthOut.setter
    def PublicIpAddressesBandwidthOut(self, PublicIpAddressesBandwidthOut):
        self._PublicIpAddressesBandwidthOut = PublicIpAddressesBandwidthOut

    @property
    def PublicIpFromSameZone(self):
        r"""Whether the public IP and the NAT gateway must be in the same availability zone. Valid values: `true` and `false`. This parameter is valid only when `Zone` is specified.
        :rtype: bool
        """
        return self._PublicIpFromSameZone

    @PublicIpFromSameZone.setter
    def PublicIpFromSameZone(self, PublicIpFromSameZone):
        self._PublicIpFromSameZone = PublicIpFromSameZone


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._AddressCount = params.get("AddressCount")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._Zone = params.get("Zone")
        self._StockPublicIpAddressesBandwidthOut = params.get("StockPublicIpAddressesBandwidthOut")
        self._PublicIpAddressesBandwidthOut = params.get("PublicIpAddressesBandwidthOut")
        self._PublicIpFromSameZone = params.get("PublicIpFromSameZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNatGatewayAddressResponse(AbstractModel):
    r"""AssociateNatGatewayAddress response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNetworkAclSubnetsRequest(AbstractModel):
    r"""AssociateNetworkAclSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _SubnetIds: Array of subnet instance IDs, such as [subnet-12345678]
        :type SubnetIds: list of str
        """
        self._NetworkAclId = None
        self._SubnetIds = None

    @property
    def NetworkAclId(self):
        r"""Network ACL instance ID, such as `acl-12345678`.
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def SubnetIds(self):
        r"""Array of subnet instance IDs, such as [subnet-12345678]
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNetworkAclSubnetsResponse(AbstractModel):
    r"""AssociateNetworkAclSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNetworkInterfaceSecurityGroupsRequest(AbstractModel):
    r"""AssociateNetworkInterfaceSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: ENI instance ID, e.g. eni-pxir56ns. You can enter up to 100 instances for each request.
        :type NetworkInterfaceIds: list of str
        :param _SecurityGroupIds: The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups. You can enter up to 100 instances for each request.
        :type SecurityGroupIds: list of str
        """
        self._NetworkInterfaceIds = None
        self._SecurityGroupIds = None

    @property
    def NetworkInterfaceIds(self):
        r"""ENI instance ID, e.g. eni-pxir56ns. You can enter up to 100 instances for each request.
        :rtype: list of str
        """
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def SecurityGroupIds(self):
        r"""The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups. You can enter up to 100 instances for each request.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNetworkInterfaceSecurityGroupsResponse(AbstractModel):
    r"""AssociateNetworkInterfaceSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachCcnInstancesRequest(AbstractModel):
    r"""AttachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: List of associated network instances
        :type Instances: list of CcnInstance
        :param _CcnUin: The UIN (root account) of the CCN. By default, the current account belongs to the UIN
        :type CcnUin: str
        """
        self._CcnId = None
        self._Instances = None
        self._CcnUin = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        r"""List of associated network instances
        :rtype: list of CcnInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CcnUin(self):
        r"""The UIN (root account) of the CCN. By default, the current account belongs to the UIN
        :rtype: str
        """
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CcnUin = params.get("CcnUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachCcnInstancesResponse(AbstractModel):
    r"""AttachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachClassicLinkVpcRequest(AbstractModel):
    r"""AttachClassicLinkVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _InstanceIds: CVM Instance ID
        :type InstanceIds: list of str
        """
        self._VpcId = None
        self._InstanceIds = None

    @property
    def VpcId(self):
        r"""VPC instance ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceIds(self):
        r"""CVM Instance ID
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachClassicLinkVpcResponse(AbstractModel):
    r"""AttachClassicLinkVpc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachNetworkInterfaceRequest(AbstractModel):
    r"""AttachNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _InstanceId: The ID of the CVM instance, such as `ins-r8hr2upy`.
        :type InstanceId: str
        :param _AttachType: ENI mounting type. Valid values: `0` (standard); `1` (extension); default value: `0`
        :type AttachType: int
        """
        self._NetworkInterfaceId = None
        self._InstanceId = None
        self._AttachType = None

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the ENI instance, such as `eni-m6dyj72l`.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def InstanceId(self):
        r"""The ID of the CVM instance, such as `ins-r8hr2upy`.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AttachType(self):
        r"""ENI mounting type. Valid values: `0` (standard); `1` (extension); default value: `0`
        :rtype: int
        """
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._InstanceId = params.get("InstanceId")
        self._AttachType = params.get("AttachType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachNetworkInterfaceResponse(AbstractModel):
    r"""AttachNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachSnapshotInstancesRequest(AbstractModel):
    r"""AttachSnapshotInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _Instances: Information of associated instances
        :type Instances: list of SnapshotInstance
        """
        self._SnapshotPolicyId = None
        self._Instances = None

    @property
    def SnapshotPolicyId(self):
        r"""Snapshot policy IDs
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Instances(self):
        r"""Information of associated instances
        :rtype: list of SnapshotInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachSnapshotInstancesResponse(AbstractModel):
    r"""AttachSnapshotInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AuditCrossBorderComplianceRequest(AbstractModel):
    r"""AuditCrossBorderCompliance request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: Service provider. Valid values: `UNICOM`.
        :type ServiceProvider: str
        :param _ComplianceId: Unique ID of compliance review request.
        :type ComplianceId: int
        :param _AuditBehavior: Audit behavior. Valid values: `APPROVED` and `DENY`.
        :type AuditBehavior: str
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._AuditBehavior = None

    @property
    def ServiceProvider(self):
        r"""Service provider. Valid values: `UNICOM`.
        :rtype: str
        """
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        r"""Unique ID of compliance review request.
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def AuditBehavior(self):
        r"""Audit behavior. Valid values: `APPROVED` and `DENY`.
        :rtype: str
        """
        return self._AuditBehavior

    @AuditBehavior.setter
    def AuditBehavior(self, AuditBehavior):
        self._AuditBehavior = AuditBehavior


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._AuditBehavior = params.get("AuditBehavior")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditCrossBorderComplianceResponse(AbstractModel):
    r"""AuditCrossBorderCompliance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BackupPolicy(AbstractModel):
    r"""Details of scheduled snapshot policy

    """

    def __init__(self):
        r"""
        :param _BackupDay: Scheduled backup day. Values: `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, `sunday`.
        :type BackupDay: str
        :param _BackupTime: Backup point in time. Format: HH:mm:ss.
        :type BackupTime: str
        """
        self._BackupDay = None
        self._BackupTime = None

    @property
    def BackupDay(self):
        r"""Scheduled backup day. Values: `monday`, `tuesday`, `wednesday`, `thursday`, `friday`, `saturday`, `sunday`.
        :rtype: str
        """
        return self._BackupDay

    @BackupDay.setter
    def BackupDay(self, BackupDay):
        self._BackupDay = BackupDay

    @property
    def BackupTime(self):
        r"""Backup point in time. Format: HH:mm:ss.
        :rtype: str
        """
        return self._BackupTime

    @BackupTime.setter
    def BackupTime(self, BackupTime):
        self._BackupTime = BackupTime


    def _deserialize(self, params):
        self._BackupDay = params.get("BackupDay")
        self._BackupTime = params.get("BackupTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthPackage(AbstractModel):
    r"""The structure of information of the bandwidth package.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package.
        :type BandwidthPackageId: str
        :param _NetworkType: Bandwidth package type, includes:
<li>BGP: General BGP bandwidth package</li>
<li>HIGH_QUALITY_BGP: Dedicated BGP bandwidth package</li>
<li>ANYCAST: AIA BGP bandwidth package</li>
<li>SINGLEISP_CMCC: CMCC bandwidth package</li>
<li>SINGLEISP_CTCC: CTCC bandwidth package</li>
<li>SINGLEISP_CUCC: CUCC bandwidth package</li>
        :type NetworkType: str
        :param _ChargeType: Bandwidth package billing type, includes:
<li>ENHANCED95_POSTPAID_BY_MONTH: Pay-as-you-go - Enhanced 95th percentile</li>
<li>PRIMARY_TRAFFIC_POSTPAID_BY_HOUR: Postpaid - Main Traffic Billing</li>
<li>BANDWIDTH_POSTPAID_BY_DAY: General BGP, Pay-as-you-go - Bandwidth-based</li>
<li>PEAK_BANDWIDTH_POSTPAID_BY_DAY: Static single-line, Pay-as-you-go - Daily billed</li>
<li>TOP5_POSTPAID_BY_MONTH: Pay-as-you-go - Monthly top 5th, If you need to use this Bglling mode, please submit a ticket</li>

        :type ChargeType: str
        :param _BandwidthPackageName: The name of the bandwidth package.
        :type BandwidthPackageName: str
        :param _CreatedTime: The creation time of the bandwidth package, which follows the `ISO8601` standard and uses `UTC` time in the format of `YYYY-MM-DDThh:mm:ssZ`.
        :type CreatedTime: str
        :param _Status: The status of the bandwidth package. Valid values: 'CREATING', 'CREATED', 'DELETING', and 'DELETED'.
        :type Status: str
        :param _ResourceSet: The resource information of the bandwidth package.
        :type ResourceSet: list of Resource
        :param _Bandwidth: The limit of the bandwidth package in Mbps. The value '-1' indicates there is no limit.
        :type Bandwidth: int
        :param _Egress: Network egress. It defaults to `center_egress1`. Valid values:
center_egress1,center_egress2,center_egress3

        :type Egress: str
        """
        self._BandwidthPackageId = None
        self._NetworkType = None
        self._ChargeType = None
        self._BandwidthPackageName = None
        self._CreatedTime = None
        self._Status = None
        self._ResourceSet = None
        self._Bandwidth = None
        self._Egress = None

    @property
    def BandwidthPackageId(self):
        r"""The unique ID of the bandwidth package.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def NetworkType(self):
        r"""Bandwidth package type, includes:
<li>BGP: General BGP bandwidth package</li>
<li>HIGH_QUALITY_BGP: Dedicated BGP bandwidth package</li>
<li>ANYCAST: AIA BGP bandwidth package</li>
<li>SINGLEISP_CMCC: CMCC bandwidth package</li>
<li>SINGLEISP_CTCC: CTCC bandwidth package</li>
<li>SINGLEISP_CUCC: CUCC bandwidth package</li>
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ChargeType(self):
        r"""Bandwidth package billing type, includes:
<li>ENHANCED95_POSTPAID_BY_MONTH: Pay-as-you-go - Enhanced 95th percentile</li>
<li>PRIMARY_TRAFFIC_POSTPAID_BY_HOUR: Postpaid - Main Traffic Billing</li>
<li>BANDWIDTH_POSTPAID_BY_DAY: General BGP, Pay-as-you-go - Bandwidth-based</li>
<li>PEAK_BANDWIDTH_POSTPAID_BY_DAY: Static single-line, Pay-as-you-go - Daily billed</li>
<li>TOP5_POSTPAID_BY_MONTH: Pay-as-you-go - Monthly top 5th, If you need to use this Bglling mode, please submit a ticket</li>

        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def BandwidthPackageName(self):
        r"""The name of the bandwidth package.
        :rtype: str
        """
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def CreatedTime(self):
        r"""The creation time of the bandwidth package, which follows the `ISO8601` standard and uses `UTC` time in the format of `YYYY-MM-DDThh:mm:ssZ`.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def Status(self):
        r"""The status of the bandwidth package. Valid values: 'CREATING', 'CREATED', 'DELETING', and 'DELETED'.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ResourceSet(self):
        r"""The resource information of the bandwidth package.
        :rtype: list of Resource
        """
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def Bandwidth(self):
        r"""The limit of the bandwidth package in Mbps. The value '-1' indicates there is no limit.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Egress(self):
        r"""Network egress. It defaults to `center_egress1`. Valid values:
center_egress1,center_egress2,center_egress3

        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._NetworkType = params.get("NetworkType")
        self._ChargeType = params.get("ChargeType")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._CreatedTime = params.get("CreatedTime")
        self._Status = params.get("Status")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._Bandwidth = params.get("Bandwidth")
        self._Egress = params.get("Egress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthPackageBillBandwidth(AbstractModel):
    r"""Current billable usage of a pay-as-you-go bandwidth package

    """

    def __init__(self):
        r"""
        :param _BandwidthUsage: Current billable usage, in Mbps
        :type BandwidthUsage: float
        """
        self._BandwidthUsage = None

    @property
    def BandwidthUsage(self):
        r"""Current billable usage, in Mbps
        :rtype: float
        """
        return self._BandwidthUsage

    @BandwidthUsage.setter
    def BandwidthUsage(self, BandwidthUsage):
        self._BandwidthUsage = BandwidthUsage


    def _deserialize(self, params):
        self._BandwidthUsage = params.get("BandwidthUsage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifySnapshotPolicy(AbstractModel):
    r"""Modify attributes of a scheduled snapshot policy

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _SnapshotPolicyName: Snapshot policy name
        :type SnapshotPolicyName: str
        :param _BackupPolicies: Backup policy
        :type BackupPolicies: list of BackupPolicy
        :param _KeepTime: Snapshot retention period. Range: 1 to 365 days
        :type KeepTime: int
        """
        self._SnapshotPolicyId = None
        self._SnapshotPolicyName = None
        self._BackupPolicies = None
        self._KeepTime = None

    @property
    def SnapshotPolicyId(self):
        r"""Snapshot policy IDs
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotPolicyName(self):
        r"""Snapshot policy name
        :rtype: str
        """
        return self._SnapshotPolicyName

    @SnapshotPolicyName.setter
    def SnapshotPolicyName(self, SnapshotPolicyName):
        self._SnapshotPolicyName = SnapshotPolicyName

    @property
    def BackupPolicies(self):
        r"""Backup policy
        :rtype: list of BackupPolicy
        """
        return self._BackupPolicies

    @BackupPolicies.setter
    def BackupPolicies(self, BackupPolicies):
        self._BackupPolicies = BackupPolicies

    @property
    def KeepTime(self):
        r"""Snapshot retention period. Range: 1 to 365 days
        :rtype: int
        """
        return self._KeepTime

    @KeepTime.setter
    def KeepTime(self, KeepTime):
        self._KeepTime = KeepTime


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotPolicyName = params.get("SnapshotPolicyName")
        if params.get("BackupPolicies") is not None:
            self._BackupPolicies = []
            for item in params.get("BackupPolicies"):
                obj = BackupPolicy()
                obj._deserialize(item)
                self._BackupPolicies.append(obj)
        self._KeepTime = params.get("KeepTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCN(AbstractModel):
    r"""The CCN object

    """

    def __init__(self):
        r"""
        :param _CcnId: The unique ID of the CCN
        :type CcnId: str
        :param _CcnName: The name of the CCN
        :type CcnName: str
        :param _CcnDescription: The detailed information of the CCN
        :type CcnDescription: str
        :param _InstanceCount: The number of associated instances
        :type InstanceCount: int
        :param _CreateTime: The creation time
        :type CreateTime: str
        :param _State: The instance status. 'ISOLATED': Being isolated (instance is in arrears and service is suspended). 'AVAILABLE': Operating.
        :type State: str
        :param _QosLevel: The instance service quality. ’PT’: Platinum , 'AU': Gold, 'AG': Silver.
        :type QosLevel: str
        :param _InstanceChargeType: The billing method. POSTPAID indicates postpaid.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceChargeType: str
        :param _BandwidthLimitType: The limit type. INTER_REGION_LIMIT is the limit between regions. OUTER_REGION_LIMIT is a region egress limit.
Note: This field may return null, indicating no valid value.
        :type BandwidthLimitType: str
        :param _TagSet: Tag key-value pairs.
        :type TagSet: list of Tag
        :param _RoutePriorityFlag: Whether the CCN route priority feature is supported. Valid values: False: do not support; True: support.
        :type RoutePriorityFlag: bool
        :param _RouteTableCount: Number of route tables associated with the instance.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableCount: int
        :param _RouteTableFlag: Whether the multiple route tables feature is enabled for the CCN instance. Valid values: `False`: no; `True`: yes. Default value: `False`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableFlag: bool
        :param _IsSecurityLock: 
        :type IsSecurityLock: bool
        :param _RouteBroadcastPolicyFlag: Status of CCN route broadcasting policy. Values: `False` (Disabled), `True` (Enabled)
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type RouteBroadcastPolicyFlag: bool
        """
        self._CcnId = None
        self._CcnName = None
        self._CcnDescription = None
        self._InstanceCount = None
        self._CreateTime = None
        self._State = None
        self._QosLevel = None
        self._InstanceChargeType = None
        self._BandwidthLimitType = None
        self._TagSet = None
        self._RoutePriorityFlag = None
        self._RouteTableCount = None
        self._RouteTableFlag = None
        self._IsSecurityLock = None
        self._RouteBroadcastPolicyFlag = None

    @property
    def CcnId(self):
        r"""The unique ID of the CCN
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnName(self):
        r"""The name of the CCN
        :rtype: str
        """
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        r"""The detailed information of the CCN
        :rtype: str
        """
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription

    @property
    def InstanceCount(self):
        r"""The number of associated instances
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def CreateTime(self):
        r"""The creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def State(self):
        r"""The instance status. 'ISOLATED': Being isolated (instance is in arrears and service is suspended). 'AVAILABLE': Operating.
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def QosLevel(self):
        r"""The instance service quality. ’PT’: Platinum , 'AU': Gold, 'AG': Silver.
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def InstanceChargeType(self):
        r"""The billing method. POSTPAID indicates postpaid.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def BandwidthLimitType(self):
        r"""The limit type. INTER_REGION_LIMIT is the limit between regions. OUTER_REGION_LIMIT is a region egress limit.
Note: This field may return null, indicating no valid value.
        :rtype: str
        """
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType

    @property
    def TagSet(self):
        r"""Tag key-value pairs.
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def RoutePriorityFlag(self):
        r"""Whether the CCN route priority feature is supported. Valid values: False: do not support; True: support.
        :rtype: bool
        """
        return self._RoutePriorityFlag

    @RoutePriorityFlag.setter
    def RoutePriorityFlag(self, RoutePriorityFlag):
        self._RoutePriorityFlag = RoutePriorityFlag

    @property
    def RouteTableCount(self):
        r"""Number of route tables associated with the instance.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RouteTableCount

    @RouteTableCount.setter
    def RouteTableCount(self, RouteTableCount):
        self._RouteTableCount = RouteTableCount

    @property
    def RouteTableFlag(self):
        r"""Whether the multiple route tables feature is enabled for the CCN instance. Valid values: `False`: no; `True`: yes. Default value: `False`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._RouteTableFlag

    @RouteTableFlag.setter
    def RouteTableFlag(self, RouteTableFlag):
        self._RouteTableFlag = RouteTableFlag

    @property
    def IsSecurityLock(self):
        r"""
        :rtype: bool
        """
        return self._IsSecurityLock

    @IsSecurityLock.setter
    def IsSecurityLock(self, IsSecurityLock):
        self._IsSecurityLock = IsSecurityLock

    @property
    def RouteBroadcastPolicyFlag(self):
        r"""Status of CCN route broadcasting policy. Values: `False` (Disabled), `True` (Enabled)
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._RouteBroadcastPolicyFlag

    @RouteBroadcastPolicyFlag.setter
    def RouteBroadcastPolicyFlag(self, RouteBroadcastPolicyFlag):
        self._RouteBroadcastPolicyFlag = RouteBroadcastPolicyFlag


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        self._InstanceCount = params.get("InstanceCount")
        self._CreateTime = params.get("CreateTime")
        self._State = params.get("State")
        self._QosLevel = params.get("QosLevel")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._RoutePriorityFlag = params.get("RoutePriorityFlag")
        self._RouteTableCount = params.get("RouteTableCount")
        self._RouteTableFlag = params.get("RouteTableFlag")
        self._IsSecurityLock = params.get("IsSecurityLock")
        self._RouteBroadcastPolicyFlag = params.get("RouteBroadcastPolicyFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnAttachedInstance(AbstractModel):
    r"""The instance object associated with a CCN

    """

    def __init__(self):
        r"""
        :param _CcnId: The ID of a CCN instance.
        :type CcnId: str
        :param _InstanceType: The type of associated instances:
<li>`VPC`: VPC</li>
<li>`DIRECTCONNECT`: Direct Connect</li>
<li>`BMVPC`: BM VPC</li>
        :type InstanceType: str
        :param _InstanceId: The ID of the associated instance.
        :type InstanceId: str
        :param _InstanceName: The name of the associated instance.
        :type InstanceName: str
        :param _InstanceRegion: The region to which the associated instance belongs, such as `ap-guangzhou`.
        :type InstanceRegion: str
        :param _InstanceUin: The UIN (root account) to which the associated instance belongs.
        :type InstanceUin: str
        :param _CidrBlock: The CIDR of the associated instance.
        :type CidrBlock: list of str
        :param _State: The status of the associated instance:
<li>`PENDING`: In application</li>
<li>`ACTIVE`: Connected</li>
<li>`EXPIRED`: Expired</li>
<li>`REJECTED`: Rejected</li>
<li>`DELETED`: Deleted</li>
<li>`FAILED`: Failed (it will be asynchronously unbound after 2 hours)</li>
<li>`ATTACHING`: binding</li>
<li>`DETACHING`: Unbinding</li>
<li>`DETACHFAILED`: The unbinding failed (it will be asynchronously unbound after 2 hours)</li>
        :type State: str
        :param _AttachedTime: Association Time.
        :type AttachedTime: str
        :param _CcnUin: The UIN (root account) to which the CCN belongs.
        :type CcnUin: str
        :param _InstanceArea: General location of the associated instance, such as CHINA_MAINLAND.
        :type InstanceArea: str
        :param _Description: Description
        :type Description: str
        :param _RouteTableId: Route table ID
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableId: str
        :param _RouteTableName: Route table name
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableName: str
        """
        self._CcnId = None
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceRegion = None
        self._InstanceUin = None
        self._CidrBlock = None
        self._State = None
        self._AttachedTime = None
        self._CcnUin = None
        self._InstanceArea = None
        self._Description = None
        self._RouteTableId = None
        self._RouteTableName = None

    @property
    def CcnId(self):
        r"""The ID of a CCN instance.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def InstanceType(self):
        r"""The type of associated instances:
<li>`VPC`: VPC</li>
<li>`DIRECTCONNECT`: Direct Connect</li>
<li>`BMVPC`: BM VPC</li>
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        r"""The ID of the associated instance.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""The name of the associated instance.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceRegion(self):
        r"""The region to which the associated instance belongs, such as `ap-guangzhou`.
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def InstanceUin(self):
        r"""The UIN (root account) to which the associated instance belongs.
        :rtype: str
        """
        return self._InstanceUin

    @InstanceUin.setter
    def InstanceUin(self, InstanceUin):
        self._InstanceUin = InstanceUin

    @property
    def CidrBlock(self):
        r"""The CIDR of the associated instance.
        :rtype: list of str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def State(self):
        r"""The status of the associated instance:
<li>`PENDING`: In application</li>
<li>`ACTIVE`: Connected</li>
<li>`EXPIRED`: Expired</li>
<li>`REJECTED`: Rejected</li>
<li>`DELETED`: Deleted</li>
<li>`FAILED`: Failed (it will be asynchronously unbound after 2 hours)</li>
<li>`ATTACHING`: binding</li>
<li>`DETACHING`: Unbinding</li>
<li>`DETACHFAILED`: The unbinding failed (it will be asynchronously unbound after 2 hours)</li>
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def AttachedTime(self):
        r"""Association Time.
        :rtype: str
        """
        return self._AttachedTime

    @AttachedTime.setter
    def AttachedTime(self, AttachedTime):
        self._AttachedTime = AttachedTime

    @property
    def CcnUin(self):
        r"""The UIN (root account) to which the CCN belongs.
        :rtype: str
        """
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin

    @property
    def InstanceArea(self):
        r"""General location of the associated instance, such as CHINA_MAINLAND.
        :rtype: str
        """
        return self._InstanceArea

    @InstanceArea.setter
    def InstanceArea(self, InstanceArea):
        self._InstanceArea = InstanceArea

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RouteTableId(self):
        r"""Route table ID
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteTableName(self):
        r"""Route table name
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceRegion = params.get("InstanceRegion")
        self._InstanceUin = params.get("InstanceUin")
        self._CidrBlock = params.get("CidrBlock")
        self._State = params.get("State")
        self._AttachedTime = params.get("AttachedTime")
        self._CcnUin = params.get("CcnUin")
        self._InstanceArea = params.get("InstanceArea")
        self._Description = params.get("Description")
        self._RouteTableId = params.get("RouteTableId")
        self._RouteTableName = params.get("RouteTableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnBandwidthInfo(AbstractModel):
    r"""The information of the cross-region bandwidth limit for CCN instances.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN ID that the bandwidth belongs to.
Note: this field may return null, indicating that no valid value was found.
        :type CcnId: str
        :param _CreatedTime: The creation time of the instance.
Note: this field may return null, indicating that no valid value was found.
        :type CreatedTime: str
        :param _ExpiredTime: The expiration time of the instance.
Note: this field may return null, indicating that no valid value was found.
        :type ExpiredTime: str
        :param _RegionFlowControlId: The unique ID of the bandwidth instance.
Note: this field may return null, indicating that no valid value was found.
        :type RegionFlowControlId: str
        :param _RenewFlag: The billing flag.
Note: this field may return null, indicating that no valid value was found.
        :type RenewFlag: str
        :param _CcnRegionBandwidthLimit: The information of the bandwidth regions and bandwidth caps. The parameter is only returned for the cross-region limit mode, but not for egress limit.
Note: this field may return null, indicating that no valid value was found.
        :type CcnRegionBandwidthLimit: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimit`
        :param _MarketId: Cloud marketplace instance ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type MarketId: str
        :param _TagSet: The list of tags to be bound.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TagSet: list of Tag
        """
        self._CcnId = None
        self._CreatedTime = None
        self._ExpiredTime = None
        self._RegionFlowControlId = None
        self._RenewFlag = None
        self._CcnRegionBandwidthLimit = None
        self._MarketId = None
        self._TagSet = None

    @property
    def CcnId(self):
        r"""The CCN ID that the bandwidth belongs to.
Note: this field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CreatedTime(self):
        r"""The creation time of the instance.
Note: this field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ExpiredTime(self):
        r"""The expiration time of the instance.
Note: this field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def RegionFlowControlId(self):
        r"""The unique ID of the bandwidth instance.
Note: this field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._RegionFlowControlId

    @RegionFlowControlId.setter
    def RegionFlowControlId(self, RegionFlowControlId):
        self._RegionFlowControlId = RegionFlowControlId

    @property
    def RenewFlag(self):
        r"""The billing flag.
Note: this field may return null, indicating that no valid value was found.
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def CcnRegionBandwidthLimit(self):
        r"""The information of the bandwidth regions and bandwidth caps. The parameter is only returned for the cross-region limit mode, but not for egress limit.
Note: this field may return null, indicating that no valid value was found.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimit`
        """
        return self._CcnRegionBandwidthLimit

    @CcnRegionBandwidthLimit.setter
    def CcnRegionBandwidthLimit(self, CcnRegionBandwidthLimit):
        self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit

    @property
    def MarketId(self):
        r"""Cloud marketplace instance ID.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MarketId

    @MarketId.setter
    def MarketId(self, MarketId):
        self._MarketId = MarketId

    @property
    def TagSet(self):
        r"""The list of tags to be bound.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CreatedTime = params.get("CreatedTime")
        self._ExpiredTime = params.get("ExpiredTime")
        self._RegionFlowControlId = params.get("RegionFlowControlId")
        self._RenewFlag = params.get("RenewFlag")
        if params.get("CcnRegionBandwidthLimit") is not None:
            self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit()
            self._CcnRegionBandwidthLimit._deserialize(params.get("CcnRegionBandwidthLimit"))
        self._MarketId = params.get("MarketId")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnInstance(AbstractModel):
    r"""The instance object associated with a CCN.

    """

    def __init__(self):
        r"""
        :param _InstanceType: The type of the associated instance. Available values are:
<li>`VPC`: VPC</li>
<li>`DIRECTCONNECT`: Direct Connect</li>
<li>`BMVPC`: BM VPC</li>
        :type InstanceType: str
        :param _InstanceId: The ID of the associated instance.
        :type InstanceId: str
        :param _InstanceRegion: The region to which the associated instance ID belongs, such as `ap-guangzhou`.
        :type InstanceRegion: str
        :param _Description: Description
        :type Description: str
        :param _RouteTableId: The ID of the route table associated with the instance
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type RouteTableId: str
        """
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceRegion = None
        self._Description = None
        self._RouteTableId = None

    @property
    def InstanceType(self):
        r"""The type of the associated instance. Available values are:
<li>`VPC`: VPC</li>
<li>`DIRECTCONNECT`: Direct Connect</li>
<li>`BMVPC`: BM VPC</li>
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        r"""The ID of the associated instance.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceRegion(self):
        r"""The region to which the associated instance ID belongs, such as `ap-guangzhou`.
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RouteTableId(self):
        r"""The ID of the route table associated with the instance
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceRegion = params.get("InstanceRegion")
        self._Description = params.get("Description")
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRegionBandwidthLimit(AbstractModel):
    r"""The outbound bandwidth cap of the CCN region

    """

    def __init__(self):
        r"""
        :param _Region: Region, such as `ap-guangzhou`
        :type Region: str
        :param _BandwidthLimit: The outbound bandwidth cap. Units: Mbps
        :type BandwidthLimit: int
        :param _IsBm: Whether it is a BM region. The default is `false`.
        :type IsBm: bool
        :param _DstRegion: The target region, such as `ap-shanghai`
Note: This field may return null, indicating no valid value.
        :type DstRegion: str
        :param _DstIsBm: Whether the target region is a BM region. The default is `false`.
        :type DstIsBm: bool
        """
        self._Region = None
        self._BandwidthLimit = None
        self._IsBm = None
        self._DstRegion = None
        self._DstIsBm = None

    @property
    def Region(self):
        r"""Region, such as `ap-guangzhou`
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BandwidthLimit(self):
        r"""The outbound bandwidth cap. Units: Mbps
        :rtype: int
        """
        return self._BandwidthLimit

    @BandwidthLimit.setter
    def BandwidthLimit(self, BandwidthLimit):
        self._BandwidthLimit = BandwidthLimit

    @property
    def IsBm(self):
        r"""Whether it is a BM region. The default is `false`.
        :rtype: bool
        """
        return self._IsBm

    @IsBm.setter
    def IsBm(self, IsBm):
        self._IsBm = IsBm

    @property
    def DstRegion(self):
        r"""The target region, such as `ap-shanghai`
Note: This field may return null, indicating no valid value.
        :rtype: str
        """
        return self._DstRegion

    @DstRegion.setter
    def DstRegion(self, DstRegion):
        self._DstRegion = DstRegion

    @property
    def DstIsBm(self):
        r"""Whether the target region is a BM region. The default is `false`.
        :rtype: bool
        """
        return self._DstIsBm

    @DstIsBm.setter
    def DstIsBm(self, DstIsBm):
        self._DstIsBm = DstIsBm


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._BandwidthLimit = params.get("BandwidthLimit")
        self._IsBm = params.get("IsBm")
        self._DstRegion = params.get("DstRegion")
        self._DstIsBm = params.get("DstIsBm")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRoute(AbstractModel):
    r"""The CCN routing policy object

    """

    def __init__(self):
        r"""
        :param _RouteId: The ID of the routing policy
        :type RouteId: str
        :param _DestinationCidrBlock: Destination
        :type DestinationCidrBlock: str
        :param _InstanceType: The type of the next hop (associated instance type). Available types: VPC, DIRECTCONNECT
        :type InstanceType: str
        :param _InstanceId: The next hop (associated instance)
        :type InstanceId: str
        :param _InstanceName: The name of the next hop (associated instance name)
        :type InstanceName: str
        :param _InstanceRegion: The region of the next hop (the region of the associated instance)
        :type InstanceRegion: str
        :param _UpdateTime: Update Time
        :type UpdateTime: str
        :param _Enabled: Whether the route is enabled
        :type Enabled: bool
        :param _InstanceUin: The UIN (root account) to which the associated instance belongs
        :type InstanceUin: str
        :param _ExtraState: Additional status of the route
        :type ExtraState: str
        :param _IsBgp: Whether it is a dynamic route
        :type IsBgp: bool
        :param _RoutePriority: Route priority
        :type RoutePriority: int
        :param _InstanceExtraName: Next hop port name (associated instance’s port name)
        :type InstanceExtraName: str
        """
        self._RouteId = None
        self._DestinationCidrBlock = None
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceRegion = None
        self._UpdateTime = None
        self._Enabled = None
        self._InstanceUin = None
        self._ExtraState = None
        self._IsBgp = None
        self._RoutePriority = None
        self._InstanceExtraName = None

    @property
    def RouteId(self):
        r"""The ID of the routing policy
        :rtype: str
        """
        return self._RouteId

    @RouteId.setter
    def RouteId(self, RouteId):
        self._RouteId = RouteId

    @property
    def DestinationCidrBlock(self):
        r"""Destination
        :rtype: str
        """
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def InstanceType(self):
        r"""The type of the next hop (associated instance type). Available types: VPC, DIRECTCONNECT
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        r"""The next hop (associated instance)
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""The name of the next hop (associated instance name)
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceRegion(self):
        r"""The region of the next hop (the region of the associated instance)
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def UpdateTime(self):
        r"""Update Time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Enabled(self):
        r"""Whether the route is enabled
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def InstanceUin(self):
        r"""The UIN (root account) to which the associated instance belongs
        :rtype: str
        """
        return self._InstanceUin

    @InstanceUin.setter
    def InstanceUin(self, InstanceUin):
        self._InstanceUin = InstanceUin

    @property
    def ExtraState(self):
        r"""Additional status of the route
        :rtype: str
        """
        return self._ExtraState

    @ExtraState.setter
    def ExtraState(self, ExtraState):
        self._ExtraState = ExtraState

    @property
    def IsBgp(self):
        r"""Whether it is a dynamic route
        :rtype: bool
        """
        return self._IsBgp

    @IsBgp.setter
    def IsBgp(self, IsBgp):
        self._IsBgp = IsBgp

    @property
    def RoutePriority(self):
        r"""Route priority
        :rtype: int
        """
        return self._RoutePriority

    @RoutePriority.setter
    def RoutePriority(self, RoutePriority):
        self._RoutePriority = RoutePriority

    @property
    def InstanceExtraName(self):
        r"""Next hop port name (associated instance’s port name)
        :rtype: str
        """
        return self._InstanceExtraName

    @InstanceExtraName.setter
    def InstanceExtraName(self, InstanceExtraName):
        self._InstanceExtraName = InstanceExtraName


    def _deserialize(self, params):
        self._RouteId = params.get("RouteId")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceRegion = params.get("InstanceRegion")
        self._UpdateTime = params.get("UpdateTime")
        self._Enabled = params.get("Enabled")
        self._InstanceUin = params.get("InstanceUin")
        self._ExtraState = params.get("ExtraState")
        self._IsBgp = params.get("IsBgp")
        self._RoutePriority = params.get("RoutePriority")
        self._InstanceExtraName = params.get("InstanceExtraName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAssistantCidrRequest(AbstractModel):
    r"""CheckAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, e.g. `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _NewCidrBlocks: Load CIDR blocks to add. CIDR block set; format: e.g. ["10.0.0.0/16", "172.16.0.0/16"]
        :type NewCidrBlocks: list of str
        :param _OldCidrBlocks: Load CIDR blocks to delete. CIDR block set; Format: e.g. ["10.0.0.0/16", "172.16.0.0/16"]
        :type OldCidrBlocks: list of str
        """
        self._VpcId = None
        self._NewCidrBlocks = None
        self._OldCidrBlocks = None

    @property
    def VpcId(self):
        r"""`VPC` instance `ID`, e.g. `vpc-6v2ht8q5`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NewCidrBlocks(self):
        r"""Load CIDR blocks to add. CIDR block set; format: e.g. ["10.0.0.0/16", "172.16.0.0/16"]
        :rtype: list of str
        """
        return self._NewCidrBlocks

    @NewCidrBlocks.setter
    def NewCidrBlocks(self, NewCidrBlocks):
        self._NewCidrBlocks = NewCidrBlocks

    @property
    def OldCidrBlocks(self):
        r"""Load CIDR blocks to delete. CIDR block set; Format: e.g. ["10.0.0.0/16", "172.16.0.0/16"]
        :rtype: list of str
        """
        return self._OldCidrBlocks

    @OldCidrBlocks.setter
    def OldCidrBlocks(self, OldCidrBlocks):
        self._OldCidrBlocks = OldCidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NewCidrBlocks = params.get("NewCidrBlocks")
        self._OldCidrBlocks = params.get("OldCidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAssistantCidrResponse(AbstractModel):
    r"""CheckAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _ConflictSourceSet: Array of conflict resources.
        :type ConflictSourceSet: list of ConflictSource
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConflictSourceSet = None
        self._RequestId = None

    @property
    def ConflictSourceSet(self):
        r"""Array of conflict resources.
        :rtype: list of ConflictSource
        """
        return self._ConflictSourceSet

    @ConflictSourceSet.setter
    def ConflictSourceSet(self, ConflictSourceSet):
        self._ConflictSourceSet = ConflictSourceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ConflictSourceSet") is not None:
            self._ConflictSourceSet = []
            for item in params.get("ConflictSourceSet"):
                obj = ConflictSource()
                obj._deserialize(item)
                self._ConflictSourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class CheckNetDetectStateRequest(AbstractModel):
    r"""CheckNetDetectState request structure.

    """

    def __init__(self):
        r"""
        :param _DetectDestinationIp: The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :type DetectDestinationIp: list of str
        :param _NetDetectId: ID of a network inspector instance, e.g. netd-12345678. Enter at least one of this parameter, VpcId, SubnetId, and NetDetectName. Use NetDetectId if it is present.
        :type NetDetectId: str
        :param _VpcId: ID of a `VPC` instance, e.g. `vpc-12345678`, which is used together with SubnetId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :type VpcId: str
        :param _SubnetId: ID of a subnet instance, e.g. `subnet-12345678`, which is used together with VpcId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :type SubnetId: str
        :param _NetDetectName: The name of a network inspector, up to 60 bytes in length. It is used together with VpcId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :type NetDetectName: str
        :param _NextHopType: The type of the next hop. Currently supported types are:
VPN: VPN gateway;
DIRECTCONNECT: direct connect gateway;
PEERCONNECTION: peering connection;
NAT: NAT gateway;
NORMAL_CVM: normal CVM.
        :type NextHopType: str
        :param _NextHopDestination: The next-hop destination gateway. The value is related to NextHopType.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
If NextHopType is set to DIRECTCONNECT, the value of this parameter is the direct connect gateway ID, such as dcg-12345678.
If NextHopType is set to PEERCONNECTION, the value of this parameter is the peering connection ID, such as pcx-12345678.
If NextHopType is set to NAT, the value of this parameter is the NAT gateway ID, such as nat-12345678.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
        :type NextHopDestination: str
        """
        self._DetectDestinationIp = None
        self._NetDetectId = None
        self._VpcId = None
        self._SubnetId = None
        self._NetDetectName = None
        self._NextHopType = None
        self._NextHopDestination = None

    @property
    def DetectDestinationIp(self):
        r"""The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :rtype: list of str
        """
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NetDetectId(self):
        r"""ID of a network inspector instance, e.g. netd-12345678. Enter at least one of this parameter, VpcId, SubnetId, and NetDetectName. Use NetDetectId if it is present.
        :rtype: str
        """
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId

    @property
    def VpcId(self):
        r"""ID of a `VPC` instance, e.g. `vpc-12345678`, which is used together with SubnetId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""ID of a subnet instance, e.g. `subnet-12345678`, which is used together with VpcId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetDetectName(self):
        r"""The name of a network inspector, up to 60 bytes in length. It is used together with VpcId and NetDetectName. You should enter either this parameter or NetDetectId, or both. Use NetDetectId if it is present.
        :rtype: str
        """
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def NextHopType(self):
        r"""The type of the next hop. Currently supported types are:
VPN: VPN gateway;
DIRECTCONNECT: direct connect gateway;
PEERCONNECTION: peering connection;
NAT: NAT gateway;
NORMAL_CVM: normal CVM.
        :rtype: str
        """
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        r"""The next-hop destination gateway. The value is related to NextHopType.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
If NextHopType is set to DIRECTCONNECT, the value of this parameter is the direct connect gateway ID, such as dcg-12345678.
If NextHopType is set to PEERCONNECTION, the value of this parameter is the peering connection ID, such as pcx-12345678.
If NextHopType is set to NAT, the value of this parameter is the NAT gateway ID, such as nat-12345678.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
        :rtype: str
        """
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination


    def _deserialize(self, params):
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NetDetectId = params.get("NetDetectId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetDetectName = params.get("NetDetectName")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetDetectStateResponse(AbstractModel):
    r"""CheckNetDetectState response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectIpStateSet: The array of network detection verification results.
        :type NetDetectIpStateSet: list of NetDetectIpState
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetectIpStateSet = None
        self._RequestId = None

    @property
    def NetDetectIpStateSet(self):
        r"""The array of network detection verification results.
        :rtype: list of NetDetectIpState
        """
        return self._NetDetectIpStateSet

    @NetDetectIpStateSet.setter
    def NetDetectIpStateSet(self, NetDetectIpStateSet):
        self._NetDetectIpStateSet = NetDetectIpStateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectIpStateSet") is not None:
            self._NetDetectIpStateSet = []
            for item in params.get("NetDetectIpStateSet"):
                obj = NetDetectIpState()
                obj._deserialize(item)
                self._NetDetectIpStateSet.append(obj)
        self._RequestId = params.get("RequestId")


class CidrForCcn(AbstractModel):
    r"""Publishes the routing policy of the VPC subnet to CCN

    """

    def __init__(self):
        r"""
        :param _Cidr: Local CIDR block, including subnet CIDR block and secondary CIDR block
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Cidr: str
        :param _PublishedToVbc: Whether the routing policy of the VPC subnet is published to CCN.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type PublishedToVbc: bool
        """
        self._Cidr = None
        self._PublishedToVbc = None

    @property
    def Cidr(self):
        r"""Local CIDR block, including subnet CIDR block and secondary CIDR block
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Cidr

    @Cidr.setter
    def Cidr(self, Cidr):
        self._Cidr = Cidr

    @property
    def PublishedToVbc(self):
        r"""Whether the routing policy of the VPC subnet is published to CCN.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._PublishedToVbc

    @PublishedToVbc.setter
    def PublishedToVbc(self, PublishedToVbc):
        self._PublishedToVbc = PublishedToVbc


    def _deserialize(self, params):
        self._Cidr = params.get("Cidr")
        self._PublishedToVbc = params.get("PublishedToVbc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicLinkInstance(AbstractModel):
    r"""Classiclink instance

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _InstanceId: The unique ID of the CVM instance
        :type InstanceId: str
        """
        self._VpcId = None
        self._InstanceId = None

    @property
    def VpcId(self):
        r"""VPC instance ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceId(self):
        r"""The unique ID of the CVM instance
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneSecurityGroupRequest(AbstractModel):
    r"""CloneSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: Security group instance ID, such as `esg-33ocnj9n`, which can be obtained through the <a href="https://intl.cloud.tencent.com/document/product/215/15808?from_cn_redirect=1">DescribeSecurityGroups</a> API.
        :type SecurityGroupId: str
        :param _GroupName: The name of security group clone. You can enter any name within 60 characters. If this parameter is left empty, the security group clone will use the name of the source security group.
        :type GroupName: str
        :param _GroupDescription: Description of the security group clone. You can enter up to 100 characters. If this parameter is left empty, the security group clone will use the description of the source security group.
        :type GroupDescription: str
        :param _ProjectId: Project ID. Default value: 0. You can query it on the <a href="https://console.cloud.tencent.com/project">project management page</a> of the Tencent Cloud console.
        :type ProjectId: str
        :param _RemoteRegion: The region of the source security group for a cross-region clone. For example, to clone the security group in Guangzhou to Shanghai, set it to `ap-guangzhou`.
        :type RemoteRegion: str
        """
        self._SecurityGroupId = None
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._RemoteRegion = None

    @property
    def SecurityGroupId(self):
        r"""Security group instance ID, such as `esg-33ocnj9n`, which can be obtained through the <a href="https://intl.cloud.tencent.com/document/product/215/15808?from_cn_redirect=1">DescribeSecurityGroups</a> API.
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def GroupName(self):
        r"""The name of security group clone. You can enter any name within 60 characters. If this parameter is left empty, the security group clone will use the name of the source security group.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        r"""Description of the security group clone. You can enter up to 100 characters. If this parameter is left empty, the security group clone will use the description of the source security group.
        :rtype: str
        """
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        r"""Project ID. Default value: 0. You can query it on the <a href="https://console.cloud.tencent.com/project">project management page</a> of the Tencent Cloud console.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RemoteRegion(self):
        r"""The region of the source security group for a cross-region clone. For example, to clone the security group in Guangzhou to Shanghai, set it to `ap-guangzhou`.
        :rtype: str
        """
        return self._RemoteRegion

    @RemoteRegion.setter
    def RemoteRegion(self, RemoteRegion):
        self._RemoteRegion = RemoteRegion


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        self._RemoteRegion = params.get("RemoteRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneSecurityGroupResponse(AbstractModel):
    r"""CloneSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group object
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        r"""Security group object
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class ConflictItem(AbstractModel):
    r"""Conflict resource items.

    """

    def __init__(self):
        r"""
        :param _ConfilctId: Conflict resource ID
        :type ConfilctId: str
        :param _DestinationItem: Conflict destination resource
        :type DestinationItem: str
        """
        self._ConfilctId = None
        self._DestinationItem = None

    @property
    def ConfilctId(self):
        r"""Conflict resource ID
        :rtype: str
        """
        return self._ConfilctId

    @ConfilctId.setter
    def ConfilctId(self, ConfilctId):
        self._ConfilctId = ConfilctId

    @property
    def DestinationItem(self):
        r"""Conflict destination resource
        :rtype: str
        """
        return self._DestinationItem

    @DestinationItem.setter
    def DestinationItem(self, DestinationItem):
        self._DestinationItem = DestinationItem


    def _deserialize(self, params):
        self._ConfilctId = params.get("ConfilctId")
        self._DestinationItem = params.get("DestinationItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConflictSource(AbstractModel):
    r"""Conflict resource.

    """

    def __init__(self):
        r"""
        :param _ConflictSourceId: Conflict resource ID
        :type ConflictSourceId: str
        :param _SourceItem: Conflict resource
        :type SourceItem: str
        :param _ConflictItemSet: Conflict resource items
        :type ConflictItemSet: list of ConflictItem
        """
        self._ConflictSourceId = None
        self._SourceItem = None
        self._ConflictItemSet = None

    @property
    def ConflictSourceId(self):
        r"""Conflict resource ID
        :rtype: str
        """
        return self._ConflictSourceId

    @ConflictSourceId.setter
    def ConflictSourceId(self, ConflictSourceId):
        self._ConflictSourceId = ConflictSourceId

    @property
    def SourceItem(self):
        r"""Conflict resource
        :rtype: str
        """
        return self._SourceItem

    @SourceItem.setter
    def SourceItem(self, SourceItem):
        self._SourceItem = SourceItem

    @property
    def ConflictItemSet(self):
        r"""Conflict resource items
        :rtype: list of ConflictItem
        """
        return self._ConflictItemSet

    @ConflictItemSet.setter
    def ConflictItemSet(self, ConflictItemSet):
        self._ConflictItemSet = ConflictItemSet


    def _deserialize(self, params):
        self._ConflictSourceId = params.get("ConflictSourceId")
        self._SourceItem = params.get("SourceItem")
        if params.get("ConflictItemSet") is not None:
            self._ConflictItemSet = []
            for item in params.get("ConflictItemSet"):
                obj = ConflictItem()
                obj._deserialize(item)
                self._ConflictItemSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateGroupRequest(AbstractModel):
    r"""CreateAddressTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupName: Name of the IP address template group
        :type AddressTemplateGroupName: str
        :param _AddressTemplateIds: IP address template instance ID, such as `ipm-mdunqeb6`.
        :type AddressTemplateIds: list of str
        """
        self._AddressTemplateGroupName = None
        self._AddressTemplateIds = None

    @property
    def AddressTemplateGroupName(self):
        r"""Name of the IP address template group
        :rtype: str
        """
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateIds(self):
        r"""IP address template instance ID, such as `ipm-mdunqeb6`.
        :rtype: list of str
        """
        return self._AddressTemplateIds

    @AddressTemplateIds.setter
    def AddressTemplateIds(self, AddressTemplateIds):
        self._AddressTemplateIds = AddressTemplateIds


    def _deserialize(self, params):
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateIds = params.get("AddressTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateGroupResponse(AbstractModel):
    r"""CreateAddressTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroup: Group object of the IP address template.
        :type AddressTemplateGroup: :class:`tencentcloud.vpc.v20170312.models.AddressTemplateGroup`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressTemplateGroup = None
        self._RequestId = None

    @property
    def AddressTemplateGroup(self):
        r"""Group object of the IP address template.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AddressTemplateGroup`
        """
        return self._AddressTemplateGroup

    @AddressTemplateGroup.setter
    def AddressTemplateGroup(self, AddressTemplateGroup):
        self._AddressTemplateGroup = AddressTemplateGroup

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressTemplateGroup") is not None:
            self._AddressTemplateGroup = AddressTemplateGroup()
            self._AddressTemplateGroup._deserialize(params.get("AddressTemplateGroup"))
        self._RequestId = params.get("RequestId")


class CreateAddressTemplateRequest(AbstractModel):
    r"""CreateAddressTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateName: IP address template name.
        :type AddressTemplateName: str
        :param _Addresses: The address information can be presented by the IP, CIDR block or IP address range. Either Addresses or AddressesExtra is required.
        :type Addresses: list of str
        :param _AddressesExtra: The address information can contain remarks and be presented by the IP, CIDR block or IP address range. Either Addresses or AddressesExtra is required.
        :type AddressesExtra: list of AddressInfo
        """
        self._AddressTemplateName = None
        self._Addresses = None
        self._AddressesExtra = None

    @property
    def AddressTemplateName(self):
        r"""IP address template name.
        :rtype: str
        """
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def Addresses(self):
        r"""The address information can be presented by the IP, CIDR block or IP address range. Either Addresses or AddressesExtra is required.
        :rtype: list of str
        """
        return self._Addresses

    @Addresses.setter
    def Addresses(self, Addresses):
        self._Addresses = Addresses

    @property
    def AddressesExtra(self):
        r"""The address information can contain remarks and be presented by the IP, CIDR block or IP address range. Either Addresses or AddressesExtra is required.
        :rtype: list of AddressInfo
        """
        return self._AddressesExtra

    @AddressesExtra.setter
    def AddressesExtra(self, AddressesExtra):
        self._AddressesExtra = AddressesExtra


    def _deserialize(self, params):
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._Addresses = params.get("Addresses")
        if params.get("AddressesExtra") is not None:
            self._AddressesExtra = []
            for item in params.get("AddressesExtra"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateResponse(AbstractModel):
    r"""CreateAddressTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplate: The template object of the IP address.
        :type AddressTemplate: :class:`tencentcloud.vpc.v20170312.models.AddressTemplate`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressTemplate = None
        self._RequestId = None

    @property
    def AddressTemplate(self):
        r"""The template object of the IP address.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AddressTemplate`
        """
        return self._AddressTemplate

    @AddressTemplate.setter
    def AddressTemplate(self, AddressTemplate):
        self._AddressTemplate = AddressTemplate

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressTemplate") is not None:
            self._AddressTemplate = AddressTemplate()
            self._AddressTemplate._deserialize(params.get("AddressTemplate"))
        self._RequestId = params.get("RequestId")


class CreateAndAttachNetworkInterfaceRequest(AbstractModel):
    r"""CreateAndAttachNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the `VpcId` field in the returned result of the `DescribeVpcs` API.
        :type VpcId: str
        :param _NetworkInterfaceName: The name of the ENI. The maximum length is 60 bytes.
        :type NetworkInterfaceName: str
        :param _SubnetId: The subnet instance ID of the ENI, such as 'subnet-0ap8nwca'.
        :type SubnetId: str
        :param _InstanceId: CVM instance ID.
        :type InstanceId: str
        :param _PrivateIpAddresses: The information of the specified private IPs. You can specify a maximum of 10 IPs each time.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _SecondaryPrivateIpAddressCount: The number of private IP addresses you apply for. The total number of private IP addresses cannot exceed the quota.
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP service level. It is used together with `SecondaryPrivateIpAddressCount`. Values: `PT` (Gold), `AU` (Silver), `AG` (Bronze) and `DEFAULT` (Default).
        :type QosLevel: str
        :param _SecurityGroupIds: The security group to be bound with, such as ['sg-1dd51d'].
        :type SecurityGroupIds: list of str
        :param _NetworkInterfaceDescription: The ENI description. You can enter any information within 60 characters.
        :type NetworkInterfaceDescription: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _AttachType: ENI mounting type. Valid values: `0` (standard); `1` (extension); default value: `0`
        :type AttachType: int
        :param _ClientToken: 
        :type ClientToken: str
        """
        self._VpcId = None
        self._NetworkInterfaceName = None
        self._SubnetId = None
        self._InstanceId = None
        self._PrivateIpAddresses = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._SecurityGroupIds = None
        self._NetworkInterfaceDescription = None
        self._Tags = None
        self._AttachType = None
        self._ClientToken = None

    @property
    def VpcId(self):
        r"""The ID of the VPC instance. You can obtain the parameter value from the `VpcId` field in the returned result of the `DescribeVpcs` API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkInterfaceName(self):
        r"""The name of the ENI. The maximum length is 60 bytes.
        :rtype: str
        """
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def SubnetId(self):
        r"""The subnet instance ID of the ENI, such as 'subnet-0ap8nwca'.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def InstanceId(self):
        r"""CVM instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PrivateIpAddresses(self):
        r"""The information of the specified private IPs. You can specify a maximum of 10 IPs each time.
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def SecondaryPrivateIpAddressCount(self):
        r"""The number of private IP addresses you apply for. The total number of private IP addresses cannot exceed the quota.
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        r"""IP service level. It is used together with `SecondaryPrivateIpAddressCount`. Values: `PT` (Gold), `AU` (Silver), `AG` (Bronze) and `DEFAULT` (Default).
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def SecurityGroupIds(self):
        r"""The security group to be bound with, such as ['sg-1dd51d'].
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def NetworkInterfaceDescription(self):
        r"""The ENI description. You can enter any information within 60 characters.
        :rtype: str
        """
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AttachType(self):
        r"""ENI mounting type. Valid values: `0` (standard); `1` (extension); default value: `0`
        :rtype: int
        """
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType

    @property
    def ClientToken(self):
        r"""
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._SubnetId = params.get("SubnetId")
        self._InstanceId = params.get("InstanceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AttachType = params.get("AttachType")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAndAttachNetworkInterfaceResponse(AbstractModel):
    r"""CreateAndAttachNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterface: The ENI instance.
        :type NetworkInterface: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkInterface = None
        self._RequestId = None

    @property
    def NetworkInterface(self):
        r"""The ENI instance.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        """
        return self._NetworkInterface

    @NetworkInterface.setter
    def NetworkInterface(self, NetworkInterface):
        self._NetworkInterface = NetworkInterface

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterface") is not None:
            self._NetworkInterface = NetworkInterface()
            self._NetworkInterface._deserialize(params.get("NetworkInterface"))
        self._RequestId = params.get("RequestId")


class CreateAssistantCidrRequest(AbstractModel):
    r"""CreateAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _CidrBlocks: Array of CIDR blocks, such as ["10.0.0.0/16", "172.16.0.0/16"]
        :type CidrBlocks: list of str
        """
        self._VpcId = None
        self._CidrBlocks = None

    @property
    def VpcId(self):
        r"""`VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlocks(self):
        r"""Array of CIDR blocks, such as ["10.0.0.0/16", "172.16.0.0/16"]
        :rtype: list of str
        """
        return self._CidrBlocks

    @CidrBlocks.setter
    def CidrBlocks(self, CidrBlocks):
        self._CidrBlocks = CidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlocks = params.get("CidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssistantCidrResponse(AbstractModel):
    r"""CreateAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: Array of secondary CIDR blocks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AssistantCidrSet: list of AssistantCidr
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        r"""Array of secondary CIDR blocks.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of AssistantCidr
        """
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateBandwidthPackageRequest(AbstractModel):
    r"""CreateBandwidthPackage request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkType: The network type of the bandwidth package. Default value: `BGP`. Valid values:
`BGP`
`HIGH_QUALITY_BGP`
        :type NetworkType: str
        :param _ChargeType: The billing mode of the bandwidth package. Default value: `ENHANCED95_POSTPAID_BY_MONTH`. Valid values:
<li>`ENHANCED95_POSTPAID_BY_MONTH`: Pay-as-you-go - Enhanced 95th percentile</li>
<li>`PRIMARY_TRAFFIC_POSTPAID_BY_HOUR`: Postpaid - Main Traffic Billing</li>
<li>`BANDWIDTH_POSTPAID_BY_DAY`: General BGP, Pay-as-you-go - Bandwidth-based</li>
<li>`PEAK_BANDWIDTH_POSTPAID_BY_DAY`: Static single-line, Pay-as-you-go - Daily billed</li>
<li>`TOP5_POSTPAID_BY_MONTH`: Pay-as-you-go - Monthly top 5th, If you need to use this Bglling mode, please submit a ticket.</li>


        :type ChargeType: str
        :param _BandwidthPackageName: The name of the bandwidth package.
        :type BandwidthPackageName: str
        :param _BandwidthPackageCount: The number of bandwidth packages to create. Valid range: 1-20. It can only be "1" for bill-by-CVM accounts.
        :type BandwidthPackageCount: int
        :param _InternetMaxBandwidth: The limit of the bandwidth package in Mbps. The value '-1' indicates there is no limit. This feature is currently in beta.
        :type InternetMaxBandwidth: int
        :param _Tags: The list of tags to be bound.
        :type Tags: list of Tag
        :param _Protocol: The protocol type of the bandwidth package. Valid values: 'ipv4' and 'ipv6'. Default value: 'ipv4'.
        :type Protocol: str
        :param _TimeSpan: 
        :type TimeSpan: int
        :param _Egress:     Network egress. It defaults to `center_egress1`. Valid values:
center_egress1,center_egress2,center_egress3

        :type Egress: str
        """
        self._NetworkType = None
        self._ChargeType = None
        self._BandwidthPackageName = None
        self._BandwidthPackageCount = None
        self._InternetMaxBandwidth = None
        self._Tags = None
        self._Protocol = None
        self._TimeSpan = None
        self._Egress = None

    @property
    def NetworkType(self):
        r"""The network type of the bandwidth package. Default value: `BGP`. Valid values:
`BGP`
`HIGH_QUALITY_BGP`
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ChargeType(self):
        r"""The billing mode of the bandwidth package. Default value: `ENHANCED95_POSTPAID_BY_MONTH`. Valid values:
<li>`ENHANCED95_POSTPAID_BY_MONTH`: Pay-as-you-go - Enhanced 95th percentile</li>
<li>`PRIMARY_TRAFFIC_POSTPAID_BY_HOUR`: Postpaid - Main Traffic Billing</li>
<li>`BANDWIDTH_POSTPAID_BY_DAY`: General BGP, Pay-as-you-go - Bandwidth-based</li>
<li>`PEAK_BANDWIDTH_POSTPAID_BY_DAY`: Static single-line, Pay-as-you-go - Daily billed</li>
<li>`TOP5_POSTPAID_BY_MONTH`: Pay-as-you-go - Monthly top 5th, If you need to use this Bglling mode, please submit a ticket.</li>


        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def BandwidthPackageName(self):
        r"""The name of the bandwidth package.
        :rtype: str
        """
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def BandwidthPackageCount(self):
        r"""The number of bandwidth packages to create. Valid range: 1-20. It can only be "1" for bill-by-CVM accounts.
        :rtype: int
        """
        return self._BandwidthPackageCount

    @BandwidthPackageCount.setter
    def BandwidthPackageCount(self, BandwidthPackageCount):
        self._BandwidthPackageCount = BandwidthPackageCount

    @property
    def InternetMaxBandwidth(self):
        r"""The limit of the bandwidth package in Mbps. The value '-1' indicates there is no limit. This feature is currently in beta.
        :rtype: int
        """
        return self._InternetMaxBandwidth

    @InternetMaxBandwidth.setter
    def InternetMaxBandwidth(self, InternetMaxBandwidth):
        self._InternetMaxBandwidth = InternetMaxBandwidth

    @property
    def Tags(self):
        r"""The list of tags to be bound.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Protocol(self):
        r"""The protocol type of the bandwidth package. Valid values: 'ipv4' and 'ipv6'. Default value: 'ipv4'.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def TimeSpan(self):
        r"""
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def Egress(self):
        r"""    Network egress. It defaults to `center_egress1`. Valid values:
center_egress1,center_egress2,center_egress3

        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        self._NetworkType = params.get("NetworkType")
        self._ChargeType = params.get("ChargeType")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._BandwidthPackageCount = params.get("BandwidthPackageCount")
        self._InternetMaxBandwidth = params.get("InternetMaxBandwidth")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Protocol = params.get("Protocol")
        self._TimeSpan = params.get("TimeSpan")
        self._Egress = params.get("Egress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBandwidthPackageResponse(AbstractModel):
    r"""CreateBandwidthPackage response structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package.
        :type BandwidthPackageId: str
        :param _BandwidthPackageIds: The unique ID list of the bandwidth package (effective only when you apply for more than 1 bandwidth packages).
        :type BandwidthPackageIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BandwidthPackageId = None
        self._BandwidthPackageIds = None
        self._RequestId = None

    @property
    def BandwidthPackageId(self):
        r"""The unique ID of the bandwidth package.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def BandwidthPackageIds(self):
        r"""The unique ID list of the bandwidth package (effective only when you apply for more than 1 bandwidth packages).
        :rtype: list of str
        """
        return self._BandwidthPackageIds

    @BandwidthPackageIds.setter
    def BandwidthPackageIds(self, BandwidthPackageIds):
        self._BandwidthPackageIds = BandwidthPackageIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._BandwidthPackageIds = params.get("BandwidthPackageIds")
        self._RequestId = params.get("RequestId")


class CreateCcnRequest(AbstractModel):
    r"""CreateCcn request structure.

    """

    def __init__(self):
        r"""
        :param _CcnName: The name of the CCN. The maximum length is 60 characters.
        :type CcnName: str
        :param _CcnDescription: The description of the CCN. The maximum length is 100 characters.
        :type CcnDescription: str
        :param _QosLevel: CCN service quality, 'PT': Platinum, 'AU': Gold, 'AG': Silver. The default is 'AU'.
        :type QosLevel: str
        :param _InstanceChargeType: The billing method. POSTPAID: postpaid by traffic. Default: POSTPAID.
        :type InstanceChargeType: str
        :param _BandwidthLimitType: The bandwidth limit type. Valid values: OUTER_REGION_LIMIT: region outbound bandwidth limit; INTER_REGION_LIMIT: inter-region bandwidth limit. Default value: OUTER_REGION_LIMIT. Monthly-subscribed CCN instances only support inter-region bandwidth limit, while pay-as-you-go CCN instances support the both bandwidth limit types.
        :type BandwidthLimitType: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._CcnName = None
        self._CcnDescription = None
        self._QosLevel = None
        self._InstanceChargeType = None
        self._BandwidthLimitType = None
        self._Tags = None

    @property
    def CcnName(self):
        r"""The name of the CCN. The maximum length is 60 characters.
        :rtype: str
        """
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        r"""The description of the CCN. The maximum length is 100 characters.
        :rtype: str
        """
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription

    @property
    def QosLevel(self):
        r"""CCN service quality, 'PT': Platinum, 'AU': Gold, 'AG': Silver. The default is 'AU'.
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def InstanceChargeType(self):
        r"""The billing method. POSTPAID: postpaid by traffic. Default: POSTPAID.
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def BandwidthLimitType(self):
        r"""The bandwidth limit type. Valid values: OUTER_REGION_LIMIT: region outbound bandwidth limit; INTER_REGION_LIMIT: inter-region bandwidth limit. Default value: OUTER_REGION_LIMIT. Monthly-subscribed CCN instances only support inter-region bandwidth limit, while pay-as-you-go CCN instances support the both bandwidth limit types.
        :rtype: str
        """
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        self._QosLevel = params.get("QosLevel")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCcnResponse(AbstractModel):
    r"""CreateCcn response structure.

    """

    def __init__(self):
        r"""
        :param _Ccn: The CCN object.
        :type Ccn: :class:`tencentcloud.vpc.v20170312.models.CCN`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ccn = None
        self._RequestId = None

    @property
    def Ccn(self):
        r"""The CCN object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CCN`
        """
        return self._Ccn

    @Ccn.setter
    def Ccn(self, Ccn):
        self._Ccn = Ccn

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ccn") is not None:
            self._Ccn = CCN()
            self._Ccn._deserialize(params.get("Ccn"))
        self._RequestId = params.get("RequestId")


class CreateCustomerGatewayRequest(AbstractModel):
    r"""CreateCustomerGateway request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayName: Customer gateway can be named freely, but the maximum length is 60 characters.
        :type CustomerGatewayName: str
        :param _IpAddress: Customer gateway public IP.
        :type IpAddress: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._CustomerGatewayName = None
        self._IpAddress = None
        self._Tags = None

    @property
    def CustomerGatewayName(self):
        r"""Customer gateway can be named freely, but the maximum length is 60 characters.
        :rtype: str
        """
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName

    @property
    def IpAddress(self):
        r"""Customer gateway public IP.
        :rtype: str
        """
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        self._IpAddress = params.get("IpAddress")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomerGatewayResponse(AbstractModel):
    r"""CreateCustomerGateway response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGateway: Customer gateway object
        :type CustomerGateway: :class:`tencentcloud.vpc.v20170312.models.CustomerGateway`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGateway = None
        self._RequestId = None

    @property
    def CustomerGateway(self):
        r"""Customer gateway object
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CustomerGateway`
        """
        return self._CustomerGateway

    @CustomerGateway.setter
    def CustomerGateway(self, CustomerGateway):
        self._CustomerGateway = CustomerGateway

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGateway") is not None:
            self._CustomerGateway = CustomerGateway()
            self._CustomerGateway._deserialize(params.get("CustomerGateway"))
        self._RequestId = params.get("RequestId")


class CreateDefaultVpcRequest(AbstractModel):
    r"""CreateDefaultVpc request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: The ID of the availability zone in which the subnet resides. This parameter can be obtained through the [`DescribeZones`](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1) API, such as `ap-guangzhou-1`. If it’s not specified, a random availability zone will be used.
        :type Zone: str
        :param _Force: Whether to forcibly return a default VPC
        :type Force: bool
        """
        self._Zone = None
        self._Force = None

    @property
    def Zone(self):
        r"""The ID of the availability zone in which the subnet resides. This parameter can be obtained through the [`DescribeZones`](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1) API, such as `ap-guangzhou-1`. If it’s not specified, a random availability zone will be used.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Force(self):
        r"""Whether to forcibly return a default VPC
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefaultVpcResponse(AbstractModel):
    r"""CreateDefaultVpc response structure.

    """

    def __init__(self):
        r"""
        :param _Vpc: Default VPC and subnet IDs
        :type Vpc: :class:`tencentcloud.vpc.v20170312.models.DefaultVpcSubnet`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Vpc = None
        self._RequestId = None

    @property
    def Vpc(self):
        r"""Default VPC and subnet IDs
        :rtype: :class:`tencentcloud.vpc.v20170312.models.DefaultVpcSubnet`
        """
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Vpc") is not None:
            self._Vpc = DefaultVpcSubnet()
            self._Vpc._deserialize(params.get("Vpc"))
        self._RequestId = params.get("RequestId")


class CreateDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    r"""CreateDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :type DirectConnectGatewayId: str
        :param _Routes: The list of IDC IP range that must be connected
        :type Routes: list of DirectConnectGatewayCcnRoute
        """
        self._DirectConnectGatewayId = None
        self._Routes = None

    @property
    def DirectConnectGatewayId(self):
        r"""The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def Routes(self):
        r"""The list of IDC IP range that must be connected
        :rtype: list of DirectConnectGatewayCcnRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    r"""CreateDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDirectConnectGatewayRequest(AbstractModel):
    r"""CreateDirectConnectGateway request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayName: The name of the direct connect gateway.
        :type DirectConnectGatewayName: str
        :param _NetworkType: The type of the associated network. Valid values:
<li>VPC</li>
<li>CCN</li>
        :type NetworkType: str
        :param _NetworkInstanceId: <li>When the NetworkType is VPC, this value is the VPC instance ID</li>
<li>When the NetworkType is CCN, this value is the CCN instance ID</li>
        :type NetworkInstanceId: str
        :param _GatewayType: The type of the gateway. Valid values:
<li>NORMAL - (Default) Standard type. Note: CCN only supports the standard type</li>
<li>NAT - NAT type</li>NAT gateway supports network address translation. The specified type cannot be modified. A VPC can create one NAT direct connect gateway and one non-NAT direct connect gateway
        :type GatewayType: str
        :param _ModeType: CCN route publishing method. Valid values: `standard` and `exquisite`. This parameter is only valid for the CCN direct connect gateway.
        :type ModeType: str
        :param _Zone: Availability zone where the direct connect gateway resides.
        :type Zone: str
        :param _HaZoneGroupId: ID of DC highly available placement group
        :type HaZoneGroupId: str
        """
        self._DirectConnectGatewayName = None
        self._NetworkType = None
        self._NetworkInstanceId = None
        self._GatewayType = None
        self._ModeType = None
        self._Zone = None
        self._HaZoneGroupId = None

    @property
    def DirectConnectGatewayName(self):
        r"""The name of the direct connect gateway.
        :rtype: str
        """
        return self._DirectConnectGatewayName

    @DirectConnectGatewayName.setter
    def DirectConnectGatewayName(self, DirectConnectGatewayName):
        self._DirectConnectGatewayName = DirectConnectGatewayName

    @property
    def NetworkType(self):
        r"""The type of the associated network. Valid values:
<li>VPC</li>
<li>CCN</li>
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def NetworkInstanceId(self):
        r"""<li>When the NetworkType is VPC, this value is the VPC instance ID</li>
<li>When the NetworkType is CCN, this value is the CCN instance ID</li>
        :rtype: str
        """
        return self._NetworkInstanceId

    @NetworkInstanceId.setter
    def NetworkInstanceId(self, NetworkInstanceId):
        self._NetworkInstanceId = NetworkInstanceId

    @property
    def GatewayType(self):
        r"""The type of the gateway. Valid values:
<li>NORMAL - (Default) Standard type. Note: CCN only supports the standard type</li>
<li>NAT - NAT type</li>NAT gateway supports network address translation. The specified type cannot be modified. A VPC can create one NAT direct connect gateway and one non-NAT direct connect gateway
        :rtype: str
        """
        return self._GatewayType

    @GatewayType.setter
    def GatewayType(self, GatewayType):
        self._GatewayType = GatewayType

    @property
    def ModeType(self):
        r"""CCN route publishing method. Valid values: `standard` and `exquisite`. This parameter is only valid for the CCN direct connect gateway.
        :rtype: str
        """
        return self._ModeType

    @ModeType.setter
    def ModeType(self, ModeType):
        self._ModeType = ModeType

    @property
    def Zone(self):
        r"""Availability zone where the direct connect gateway resides.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def HaZoneGroupId(self):
        r"""ID of DC highly available placement group
        :rtype: str
        """
        return self._HaZoneGroupId

    @HaZoneGroupId.setter
    def HaZoneGroupId(self, HaZoneGroupId):
        self._HaZoneGroupId = HaZoneGroupId


    def _deserialize(self, params):
        self._DirectConnectGatewayName = params.get("DirectConnectGatewayName")
        self._NetworkType = params.get("NetworkType")
        self._NetworkInstanceId = params.get("NetworkInstanceId")
        self._GatewayType = params.get("GatewayType")
        self._ModeType = params.get("ModeType")
        self._Zone = params.get("Zone")
        self._HaZoneGroupId = params.get("HaZoneGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectConnectGatewayResponse(AbstractModel):
    r"""CreateDirectConnectGateway response structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGateway: The object of the direct connect gateway.
        :type DirectConnectGateway: :class:`tencentcloud.vpc.v20170312.models.DirectConnectGateway`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DirectConnectGateway = None
        self._RequestId = None

    @property
    def DirectConnectGateway(self):
        r"""The object of the direct connect gateway.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.DirectConnectGateway`
        """
        return self._DirectConnectGateway

    @DirectConnectGateway.setter
    def DirectConnectGateway(self, DirectConnectGateway):
        self._DirectConnectGateway = DirectConnectGateway

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DirectConnectGateway") is not None:
            self._DirectConnectGateway = DirectConnectGateway()
            self._DirectConnectGateway._deserialize(params.get("DirectConnectGateway"))
        self._RequestId = params.get("RequestId")


class CreateFlowLogRequest(AbstractModel):
    r"""CreateFlowLog request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogName: The name of the flow log instance.
        :type FlowLogName: str
        :param _ResourceType: The type of resource associated with the flow log. Valid values: `VPC`, `SUBNET`, `NETWORKINTERFACE`, `CCN`, `NAT`, and `DCG`.
        :type ResourceType: str
        :param _ResourceId: The unique ID of the resource.
        :type ResourceId: str
        :param _TrafficType: Type of the flow logs to be collected. Valid values: `ACCEPT`, `REJECT` and `ALL`.
        :type TrafficType: str
        :param _VpcId: The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless the `ResourceType` is set to `CCN`.
        :type VpcId: str
        :param _FlowLogDescription: The description of the flow log.
        :type FlowLogDescription: str
        :param _CloudLogId: The storage ID of the flow log.
        :type CloudLogId: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _StorageType: Consumer types: `cls` and `ckafka`
        :type StorageType: str
        :param _FlowLogStorage: Information of the flow log consumer, which is required when the consumer type is `ckafka`.
        :type FlowLogStorage: :class:`tencentcloud.vpc.v20170312.models.FlowLogStorage`
        :param _CloudLogRegion: The region corresponding to the flow log storage ID. If not passed in, this field defaults to the current region.
        :type CloudLogRegion: str
        """
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._VpcId = None
        self._FlowLogDescription = None
        self._CloudLogId = None
        self._Tags = None
        self._StorageType = None
        self._FlowLogStorage = None
        self._CloudLogRegion = None

    @property
    def FlowLogName(self):
        r"""The name of the flow log instance.
        :rtype: str
        """
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        r"""The type of resource associated with the flow log. Valid values: `VPC`, `SUBNET`, `NETWORKINTERFACE`, `CCN`, `NAT`, and `DCG`.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        r"""The unique ID of the resource.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        r"""Type of the flow logs to be collected. Valid values: `ACCEPT`, `REJECT` and `ALL`.
        :rtype: str
        """
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def VpcId(self):
        r"""The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless the `ResourceType` is set to `CCN`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogDescription(self):
        r"""The description of the flow log.
        :rtype: str
        """
        return self._FlowLogDescription

    @FlowLogDescription.setter
    def FlowLogDescription(self, FlowLogDescription):
        self._FlowLogDescription = FlowLogDescription

    @property
    def CloudLogId(self):
        r"""The storage ID of the flow log.
        :rtype: str
        """
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def StorageType(self):
        r"""Consumer types: `cls` and `ckafka`
        :rtype: str
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def FlowLogStorage(self):
        r"""Information of the flow log consumer, which is required when the consumer type is `ckafka`.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.FlowLogStorage`
        """
        return self._FlowLogStorage

    @FlowLogStorage.setter
    def FlowLogStorage(self, FlowLogStorage):
        self._FlowLogStorage = FlowLogStorage

    @property
    def CloudLogRegion(self):
        r"""The region corresponding to the flow log storage ID. If not passed in, this field defaults to the current region.
        :rtype: str
        """
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._VpcId = params.get("VpcId")
        self._FlowLogDescription = params.get("FlowLogDescription")
        self._CloudLogId = params.get("CloudLogId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._StorageType = params.get("StorageType")
        if params.get("FlowLogStorage") is not None:
            self._FlowLogStorage = FlowLogStorage()
            self._FlowLogStorage._deserialize(params.get("FlowLogStorage"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFlowLogResponse(AbstractModel):
    r"""CreateFlowLog response structure.

    """

    def __init__(self):
        r"""
        :param _FlowLog: The information of the flow log created.
        :type FlowLog: list of FlowLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowLog = None
        self._RequestId = None

    @property
    def FlowLog(self):
        r"""The information of the flow log created.
        :rtype: list of FlowLog
        """
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._RequestId = params.get("RequestId")


class CreateHaVipRequest(AbstractModel):
    r"""CreateHaVip request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the VPC to which the `HAVIP` belongs.
        :type VpcId: str
        :param _HaVipName: The name of the `HAVIP`.
        :type HaVipName: str
        :param _SubnetId: The `ID` of the subnet to which the `HAVIP` belongs.
        :type SubnetId: str
        :param _Vip: The specified virtual IP address, which must be within the IP range of the `VPC` and not in use. It will be automatically assigned if not specified.
        :type Vip: str
        :param _NetworkInterfaceId: The ID of the ENI associated with the HAVIP.
        :type NetworkInterfaceId: str
        """
        self._VpcId = None
        self._HaVipName = None
        self._SubnetId = None
        self._Vip = None
        self._NetworkInterfaceId = None

    @property
    def VpcId(self):
        r"""The `ID` of the VPC to which the `HAVIP` belongs.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def HaVipName(self):
        r"""The name of the `HAVIP`.
        :rtype: str
        """
        return self._HaVipName

    @HaVipName.setter
    def HaVipName(self, HaVipName):
        self._HaVipName = HaVipName

    @property
    def SubnetId(self):
        r"""The `ID` of the subnet to which the `HAVIP` belongs.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Vip(self):
        r"""The specified virtual IP address, which must be within the IP range of the `VPC` and not in use. It will be automatically assigned if not specified.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the ENI associated with the HAVIP.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._HaVipName = params.get("HaVipName")
        self._SubnetId = params.get("SubnetId")
        self._Vip = params.get("Vip")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHaVipResponse(AbstractModel):
    r"""CreateHaVip response structure.

    """

    def __init__(self):
        r"""
        :param _HaVip: `HAVIP` object.
        :type HaVip: :class:`tencentcloud.vpc.v20170312.models.HaVip`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HaVip = None
        self._RequestId = None

    @property
    def HaVip(self):
        r"""`HAVIP` object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.HaVip`
        """
        return self._HaVip

    @HaVip.setter
    def HaVip(self, HaVip):
        self._HaVip = HaVip

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HaVip") is not None:
            self._HaVip = HaVip()
            self._HaVip._deserialize(params.get("HaVip"))
        self._RequestId = params.get("RequestId")


class CreateLocalGatewayRequest(AbstractModel):
    r"""CreateLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewayName: Local gateway name
        :type LocalGatewayName: str
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _CdcId: CDC instance ID
        :type CdcId: str
        """
        self._LocalGatewayName = None
        self._VpcId = None
        self._CdcId = None

    @property
    def LocalGatewayName(self):
        r"""Local gateway name
        :rtype: str
        """
        return self._LocalGatewayName

    @LocalGatewayName.setter
    def LocalGatewayName(self, LocalGatewayName):
        self._LocalGatewayName = LocalGatewayName

    @property
    def VpcId(self):
        r"""VPC instance ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CdcId(self):
        r"""CDC instance ID
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._LocalGatewayName = params.get("LocalGatewayName")
        self._VpcId = params.get("VpcId")
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLocalGatewayResponse(AbstractModel):
    r"""CreateLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _LocalGateway: Local gateway information
        :type LocalGateway: :class:`tencentcloud.vpc.v20170312.models.LocalGateway`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LocalGateway = None
        self._RequestId = None

    @property
    def LocalGateway(self):
        r"""Local gateway information
        :rtype: :class:`tencentcloud.vpc.v20170312.models.LocalGateway`
        """
        return self._LocalGateway

    @LocalGateway.setter
    def LocalGateway(self, LocalGateway):
        self._LocalGateway = LocalGateway

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LocalGateway") is not None:
            self._LocalGateway = LocalGateway()
            self._LocalGateway._deserialize(params.get("LocalGateway"))
        self._RequestId = params.get("RequestId")


class CreateNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    r"""CreateNatGatewayDestinationIpPortTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _DestinationIpPortTranslationNatRules: The port forwarding rules of the NAT gateway.
        :type DestinationIpPortTranslationNatRules: list of DestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._DestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT gateway, such as `nat-df45454`.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DestinationIpPortTranslationNatRules(self):
        r"""The port forwarding rules of the NAT gateway.
        :rtype: list of DestinationIpPortTranslationNatRule
        """
        return self._DestinationIpPortTranslationNatRules

    @DestinationIpPortTranslationNatRules.setter
    def DestinationIpPortTranslationNatRules(self, DestinationIpPortTranslationNatRules):
        self._DestinationIpPortTranslationNatRules = DestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("DestinationIpPortTranslationNatRules") is not None:
            self._DestinationIpPortTranslationNatRules = []
            for item in params.get("DestinationIpPortTranslationNatRules"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    r"""CreateNatGatewayDestinationIpPortTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNatGatewayRequest(AbstractModel):
    r"""CreateNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayName: NAT gateway name
        :type NatGatewayName: str
        :param _VpcId: The ID of the VPC instance, which can be obtained from the `VpcId` field in response of the `DescribeVpcs` API.
        :type VpcId: str
        :param _InternetMaxBandwidthOut: The maximum outbound bandwidth of the NAT gateway (unit: Mbps). Supported parameter values: `20, 50, 100, 200, 500, 1000, 2000, 5000`. Default: `100`.
        :type InternetMaxBandwidthOut: int
        :param _MaxConcurrentConnection: The concurrent connection cap of the NAT gateway. Values: `1000000, 3000000, 10000000`. The default value is `1000000`.
        :type MaxConcurrentConnection: int
        :param _AddressCount: The number of EIPs that you want to apply for. Either `AddressCount` or `PublicIpAddresses` must be passed in.
        :type AddressCount: int
        :param _PublicIpAddresses: The EIP array bound to the NAT gateway. Either AddressCount or PublicIpAddresses must be passed in.
        :type PublicIpAddresses: list of str
        :param _Zone: The availability zone, such as `ap-guangzhou-1`.
        :type Zone: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _SubnetId: Subnet of the NAT gateway
        :type SubnetId: str
        :param _StockPublicIpAddressesBandwidthOut: The bandwidth size (in Mbps) of the EIP bound to the NAT gateway, which defaults to the maximum value applicable for the current user type.
        :type StockPublicIpAddressesBandwidthOut: int
        :param _PublicIpAddressesBandwidthOut: The size of the public network IP bandwidth to be applied for (in Mbps), which defaults to the maximum value applicable for the current user type.
        :type PublicIpAddressesBandwidthOut: int
        :param _PublicIpFromSameZone: Whether the public IP and the NAT gateway must be in the same availability zone. Valid values: `true` and `false`. This parameter is valid only when `Zone` is specified.
        :type PublicIpFromSameZone: bool
        :param _NatProductVersion: NAT gateway major version. `1`: Classic, `2`: Standard
        :type NatProductVersion: int
        """
        self._NatGatewayName = None
        self._VpcId = None
        self._InternetMaxBandwidthOut = None
        self._MaxConcurrentConnection = None
        self._AddressCount = None
        self._PublicIpAddresses = None
        self._Zone = None
        self._Tags = None
        self._SubnetId = None
        self._StockPublicIpAddressesBandwidthOut = None
        self._PublicIpAddressesBandwidthOut = None
        self._PublicIpFromSameZone = None
        self._NatProductVersion = None

    @property
    def NatGatewayName(self):
        r"""NAT gateway name
        :rtype: str
        """
        return self._NatGatewayName

    @NatGatewayName.setter
    def NatGatewayName(self, NatGatewayName):
        self._NatGatewayName = NatGatewayName

    @property
    def VpcId(self):
        r"""The ID of the VPC instance, which can be obtained from the `VpcId` field in response of the `DescribeVpcs` API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InternetMaxBandwidthOut(self):
        r"""The maximum outbound bandwidth of the NAT gateway (unit: Mbps). Supported parameter values: `20, 50, 100, 200, 500, 1000, 2000, 5000`. Default: `100`.
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def MaxConcurrentConnection(self):
        r"""The concurrent connection cap of the NAT gateway. Values: `1000000, 3000000, 10000000`. The default value is `1000000`.
        :rtype: int
        """
        return self._MaxConcurrentConnection

    @MaxConcurrentConnection.setter
    def MaxConcurrentConnection(self, MaxConcurrentConnection):
        self._MaxConcurrentConnection = MaxConcurrentConnection

    @property
    def AddressCount(self):
        r"""The number of EIPs that you want to apply for. Either `AddressCount` or `PublicIpAddresses` must be passed in.
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def PublicIpAddresses(self):
        r"""The EIP array bound to the NAT gateway. Either AddressCount or PublicIpAddresses must be passed in.
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def Zone(self):
        r"""The availability zone, such as `ap-guangzhou-1`.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def SubnetId(self):
        warnings.warn("parameter `SubnetId` is deprecated", DeprecationWarning) 

        r"""Subnet of the NAT gateway
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        warnings.warn("parameter `SubnetId` is deprecated", DeprecationWarning) 

        self._SubnetId = SubnetId

    @property
    def StockPublicIpAddressesBandwidthOut(self):
        r"""The bandwidth size (in Mbps) of the EIP bound to the NAT gateway, which defaults to the maximum value applicable for the current user type.
        :rtype: int
        """
        return self._StockPublicIpAddressesBandwidthOut

    @StockPublicIpAddressesBandwidthOut.setter
    def StockPublicIpAddressesBandwidthOut(self, StockPublicIpAddressesBandwidthOut):
        self._StockPublicIpAddressesBandwidthOut = StockPublicIpAddressesBandwidthOut

    @property
    def PublicIpAddressesBandwidthOut(self):
        r"""The size of the public network IP bandwidth to be applied for (in Mbps), which defaults to the maximum value applicable for the current user type.
        :rtype: int
        """
        return self._PublicIpAddressesBandwidthOut

    @PublicIpAddressesBandwidthOut.setter
    def PublicIpAddressesBandwidthOut(self, PublicIpAddressesBandwidthOut):
        self._PublicIpAddressesBandwidthOut = PublicIpAddressesBandwidthOut

    @property
    def PublicIpFromSameZone(self):
        r"""Whether the public IP and the NAT gateway must be in the same availability zone. Valid values: `true` and `false`. This parameter is valid only when `Zone` is specified.
        :rtype: bool
        """
        return self._PublicIpFromSameZone

    @PublicIpFromSameZone.setter
    def PublicIpFromSameZone(self, PublicIpFromSameZone):
        self._PublicIpFromSameZone = PublicIpFromSameZone

    @property
    def NatProductVersion(self):
        r"""NAT gateway major version. `1`: Classic, `2`: Standard
        :rtype: int
        """
        return self._NatProductVersion

    @NatProductVersion.setter
    def NatProductVersion(self, NatProductVersion):
        self._NatProductVersion = NatProductVersion


    def _deserialize(self, params):
        self._NatGatewayName = params.get("NatGatewayName")
        self._VpcId = params.get("VpcId")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._MaxConcurrentConnection = params.get("MaxConcurrentConnection")
        self._AddressCount = params.get("AddressCount")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._Zone = params.get("Zone")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._SubnetId = params.get("SubnetId")
        self._StockPublicIpAddressesBandwidthOut = params.get("StockPublicIpAddressesBandwidthOut")
        self._PublicIpAddressesBandwidthOut = params.get("PublicIpAddressesBandwidthOut")
        self._PublicIpFromSameZone = params.get("PublicIpFromSameZone")
        self._NatProductVersion = params.get("NatProductVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayResponse(AbstractModel):
    r"""CreateNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewaySet: NAT gateway object array.
        :type NatGatewaySet: list of NatGateway
        :param _TotalCount: The number of eligible NAT gateway objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewaySet(self):
        r"""NAT gateway object array.
        :rtype: list of NatGateway
        """
        return self._NatGatewaySet

    @NatGatewaySet.setter
    def NatGatewaySet(self, NatGatewaySet):
        self._NatGatewaySet = NatGatewaySet

    @property
    def TotalCount(self):
        r"""The number of eligible NAT gateway objects.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewaySet") is not None:
            self._NatGatewaySet = []
            for item in params.get("NatGatewaySet"):
                obj = NatGateway()
                obj._deserialize(item)
                self._NatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class CreateNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    r"""CreateNatGatewaySourceIpTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT Gateway, such as `nat-df45454`
        :type NatGatewayId: str
        :param _SourceIpTranslationNatRules: The SNAT forwarding rule of the NAT Gateway
        :type SourceIpTranslationNatRules: list of SourceIpTranslationNatRule
        """
        self._NatGatewayId = None
        self._SourceIpTranslationNatRules = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT Gateway, such as `nat-df45454`
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def SourceIpTranslationNatRules(self):
        r"""The SNAT forwarding rule of the NAT Gateway
        :rtype: list of SourceIpTranslationNatRule
        """
        return self._SourceIpTranslationNatRules

    @SourceIpTranslationNatRules.setter
    def SourceIpTranslationNatRules(self, SourceIpTranslationNatRules):
        self._SourceIpTranslationNatRules = SourceIpTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("SourceIpTranslationNatRules") is not None:
            self._SourceIpTranslationNatRules = []
            for item in params.get("SourceIpTranslationNatRules"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    r"""CreateNatGatewaySourceIpTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetDetectRequest(AbstractModel):
    r"""CreateNetDetect request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of a VPC instance, such as `vpc-12345678`.
        :type VpcId: str
        :param _SubnetId: The ID of a subnet instance, such as subnet-12345678.
        :type SubnetId: str
        :param _NetDetectName: The name of a network detection instance. The maximum length is 60 characters.
        :type NetDetectName: str
        :param _DetectDestinationIp: The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :type DetectDestinationIp: list of str
        :param _NextHopType: Type of the next hop. Valid values:
`VPN`: VPN gateway;
`DIRECTCONNECT`: Direct connect gateway;
`PEERCONNECTION`: Peering connection;
`NAT`: NAT gateway;
`NORMAL_CVM`: CVM instance;
`CCN`: CCN instance;
`NONEXTHOP`: No next hop.
        :type NextHopType: str
        :param _NextHopDestination: ID of the next-hop gateway.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
`NextHopType` = `DIRECTCONNECT`: Direct connect gateway ID, such as `dcg-12345678`.
`NextHopType` = `PEERCONNECTION`: Peering connection ID, such as `pcx-12345678`.
`NextHopType` = `NAT`: NAT gateway ID, such as `nat-12345678`.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
`NextHopType` = `CCN`: CCN instance ID, such as `ccn-12345678`.
`NextHopType` = `NONEXTHOP`: No next hop.
        :type NextHopDestination: str
        :param _NetDetectDescription: Network detection description.
        :type NetDetectDescription: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._NetDetectName = None
        self._DetectDestinationIp = None
        self._NextHopType = None
        self._NextHopDestination = None
        self._NetDetectDescription = None

    @property
    def VpcId(self):
        r"""The ID of a VPC instance, such as `vpc-12345678`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""The ID of a subnet instance, such as subnet-12345678.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetDetectName(self):
        r"""The name of a network detection instance. The maximum length is 60 characters.
        :rtype: str
        """
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def DetectDestinationIp(self):
        r"""The array of detection destination IPv4 addresses, which contains at most two IP addresses.
        :rtype: list of str
        """
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NextHopType(self):
        r"""Type of the next hop. Valid values:
`VPN`: VPN gateway;
`DIRECTCONNECT`: Direct connect gateway;
`PEERCONNECTION`: Peering connection;
`NAT`: NAT gateway;
`NORMAL_CVM`: CVM instance;
`CCN`: CCN instance;
`NONEXTHOP`: No next hop.
        :rtype: str
        """
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        r"""ID of the next-hop gateway.
If NextHopType is set to VPN, the value of this parameter is the VPN gateway ID, such as vpngw-12345678.
`NextHopType` = `DIRECTCONNECT`: Direct connect gateway ID, such as `dcg-12345678`.
`NextHopType` = `PEERCONNECTION`: Peering connection ID, such as `pcx-12345678`.
`NextHopType` = `NAT`: NAT gateway ID, such as `nat-12345678`.
If NextHopType is set to NORMAL_CVM, the value of this parameter is the IPv4 address of the CVM, such as 10.0.0.12.
`NextHopType` = `CCN`: CCN instance ID, such as `ccn-12345678`.
`NextHopType` = `NONEXTHOP`: No next hop.
        :rtype: str
        """
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination

    @property
    def NetDetectDescription(self):
        r"""Network detection description.
        :rtype: str
        """
        return self._NetDetectDescription

    @NetDetectDescription.setter
    def NetDetectDescription(self, NetDetectDescription):
        self._NetDetectDescription = NetDetectDescription


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetDetectName = params.get("NetDetectName")
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        self._NetDetectDescription = params.get("NetDetectDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetDetectResponse(AbstractModel):
    r"""CreateNetDetect response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetect: The network detection (NetDetect) object.
        :type NetDetect: :class:`tencentcloud.vpc.v20170312.models.NetDetect`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetect = None
        self._RequestId = None

    @property
    def NetDetect(self):
        r"""The network detection (NetDetect) object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetDetect`
        """
        return self._NetDetect

    @NetDetect.setter
    def NetDetect(self, NetDetect):
        self._NetDetect = NetDetect

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetect") is not None:
            self._NetDetect = NetDetect()
            self._NetDetect._deserialize(params.get("NetDetect"))
        self._RequestId = params.get("RequestId")


class CreateNetworkAclQuintupleEntriesRequest(AbstractModel):
    r"""CreateNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: Network ACL quintuple rule set.
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        r"""Network ACL instance ID, such as `acl-12345678`.
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        r"""Network ACL quintuple rule set.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclQuintupleEntriesResponse(AbstractModel):
    r"""CreateNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetworkAclRequest(AbstractModel):
    r"""CreateNetworkAcl request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
        :type VpcId: str
        :param _NetworkAclName: Network ACL name, which can contain up to 60 bytes.
        :type NetworkAclName: str
        :param _NetworkAclType: Network ACL type. Valid values: `TRIPLE` and `QUINTUPLE`.
        :type NetworkAclType: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._NetworkAclName = None
        self._NetworkAclType = None
        self._Tags = None

    @property
    def VpcId(self):
        r"""VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkAclName(self):
        r"""Network ACL name, which can contain up to 60 bytes.
        :rtype: str
        """
        return self._NetworkAclName

    @NetworkAclName.setter
    def NetworkAclName(self, NetworkAclName):
        self._NetworkAclName = NetworkAclName

    @property
    def NetworkAclType(self):
        r"""Network ACL type. Valid values: `TRIPLE` and `QUINTUPLE`.
        :rtype: str
        """
        return self._NetworkAclType

    @NetworkAclType.setter
    def NetworkAclType(self, NetworkAclType):
        self._NetworkAclType = NetworkAclType

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkAclName = params.get("NetworkAclName")
        self._NetworkAclType = params.get("NetworkAclType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclResponse(AbstractModel):
    r"""CreateNetworkAcl response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAcl: Network ACL instance
        :type NetworkAcl: :class:`tencentcloud.vpc.v20170312.models.NetworkAcl`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkAcl = None
        self._RequestId = None

    @property
    def NetworkAcl(self):
        r"""Network ACL instance
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAcl`
        """
        return self._NetworkAcl

    @NetworkAcl.setter
    def NetworkAcl(self, NetworkAcl):
        self._NetworkAcl = NetworkAcl

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAcl") is not None:
            self._NetworkAcl = NetworkAcl()
            self._NetworkAcl._deserialize(params.get("NetworkAcl"))
        self._RequestId = params.get("RequestId")


class CreateNetworkInterfaceRequest(AbstractModel):
    r"""CreateNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _NetworkInterfaceName: The name of the ENI. The maximum length is 60 characters.
        :type NetworkInterfaceName: str
        :param _SubnetId: The subnet instance ID of the ENI, such as `subnet-0ap8nwca`.
        :type SubnetId: str
        :param _NetworkInterfaceDescription: ENI description can be named freely, but the maximum length is 60 characters.
        :type NetworkInterfaceDescription: str
        :param _SecondaryPrivateIpAddressCount: The number of private IP addresses you apply for. The total number of private IP addresses cannot exceed the quota.
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP service level. It is used together with `SecondaryPrivateIpAddressCount`. Values: `PT` (Gold), `AU` (Silver), `AG` (Bronze) and `DEFAULT` (Default).
        :type QosLevel: str
        :param _SecurityGroupIds: Specifies the security group to be bound with, such as ['sg-1dd51d'].
        :type SecurityGroupIds: list of str
        :param _PrivateIpAddresses: The information of the specified private IPs. You can specify a maximum of 10 each time.
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _TrunkingFlag: Configuration of the ENI trunking mode. Valid values: `Enable` and `Disable`. Default value: `Disable`.
        :type TrunkingFlag: str
        :param _ClientToken: 
        :type ClientToken: str
        """
        self._VpcId = None
        self._NetworkInterfaceName = None
        self._SubnetId = None
        self._NetworkInterfaceDescription = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._SecurityGroupIds = None
        self._PrivateIpAddresses = None
        self._Tags = None
        self._TrunkingFlag = None
        self._ClientToken = None

    @property
    def VpcId(self):
        r"""The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkInterfaceName(self):
        r"""The name of the ENI. The maximum length is 60 characters.
        :rtype: str
        """
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def SubnetId(self):
        r"""The subnet instance ID of the ENI, such as `subnet-0ap8nwca`.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetworkInterfaceDescription(self):
        r"""ENI description can be named freely, but the maximum length is 60 characters.
        :rtype: str
        """
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def SecondaryPrivateIpAddressCount(self):
        r"""The number of private IP addresses you apply for. The total number of private IP addresses cannot exceed the quota.
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        r"""IP service level. It is used together with `SecondaryPrivateIpAddressCount`. Values: `PT` (Gold), `AU` (Silver), `AG` (Bronze) and `DEFAULT` (Default).
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def SecurityGroupIds(self):
        r"""Specifies the security group to be bound with, such as ['sg-1dd51d'].
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def PrivateIpAddresses(self):
        r"""The information of the specified private IPs. You can specify a maximum of 10 each time.
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def TrunkingFlag(self):
        r"""Configuration of the ENI trunking mode. Valid values: `Enable` and `Disable`. Default value: `Disable`.
        :rtype: str
        """
        return self._TrunkingFlag

    @TrunkingFlag.setter
    def TrunkingFlag(self, TrunkingFlag):
        self._TrunkingFlag = TrunkingFlag

    @property
    def ClientToken(self):
        r"""
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._SubnetId = params.get("SubnetId")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._TrunkingFlag = params.get("TrunkingFlag")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkInterfaceResponse(AbstractModel):
    r"""CreateNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterface: ENI instance.
        :type NetworkInterface: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkInterface = None
        self._RequestId = None

    @property
    def NetworkInterface(self):
        r"""ENI instance.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        """
        return self._NetworkInterface

    @NetworkInterface.setter
    def NetworkInterface(self, NetworkInterface):
        self._NetworkInterface = NetworkInterface

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterface") is not None:
            self._NetworkInterface = NetworkInterface()
            self._NetworkInterface._deserialize(params.get("NetworkInterface"))
        self._RequestId = params.get("RequestId")


class CreateReserveIpAddressesRequest(AbstractModel):
    r"""CreateReserveIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: Unique ID of the VPC.
        :type VpcId: str
        :param _IpAddresses: Reserved private IP address to be applied for.
        :type IpAddresses: list of str
        :param _IpAddressCount: Number of reserved private IP addresses that can be automatically assigned with no IP address specified.
        :type IpAddressCount: int
        :param _SubnetId: Unique ID of the subnet.
        :type SubnetId: str
        :param _Name: Name of the reserved private IP address.
        :type Name: str
        :param _Description: Description of the reserved private IP address.
        :type Description: str
        :param _Tags: List of tags to be bound, for example, [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _ClientToken: A string used to ensure the idempotence of the request. This string is generated by the customer and should be unique across different requests, with a maximum length of 64 ASCII characters. If this parameter is not specified, the idempotence of the request cannot be guaranteed.
        :type ClientToken: str
        """
        self._VpcId = None
        self._IpAddresses = None
        self._IpAddressCount = None
        self._SubnetId = None
        self._Name = None
        self._Description = None
        self._Tags = None
        self._ClientToken = None

    @property
    def VpcId(self):
        r"""Unique ID of the VPC.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def IpAddresses(self):
        r"""Reserved private IP address to be applied for.
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def IpAddressCount(self):
        r"""Number of reserved private IP addresses that can be automatically assigned with no IP address specified.
        :rtype: int
        """
        return self._IpAddressCount

    @IpAddressCount.setter
    def IpAddressCount(self, IpAddressCount):
        self._IpAddressCount = IpAddressCount

    @property
    def SubnetId(self):
        r"""Unique ID of the subnet.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Name(self):
        r"""Name of the reserved private IP address.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""Description of the reserved private IP address.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        r"""List of tags to be bound, for example, [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ClientToken(self):
        r"""A string used to ensure the idempotence of the request. This string is generated by the customer and should be unique across different requests, with a maximum length of 64 ASCII characters. If this parameter is not specified, the idempotence of the request cannot be guaranteed.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._IpAddresses = params.get("IpAddresses")
        self._IpAddressCount = params.get("IpAddressCount")
        self._SubnetId = params.get("SubnetId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateReserveIpAddressesResponse(AbstractModel):
    r"""CreateReserveIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _ReserveIpAddressSet: Information returned from the reserved private IP address.
        :type ReserveIpAddressSet: list of ReserveIpAddressInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ReserveIpAddressSet = None
        self._RequestId = None

    @property
    def ReserveIpAddressSet(self):
        r"""Information returned from the reserved private IP address.
        :rtype: list of ReserveIpAddressInfo
        """
        return self._ReserveIpAddressSet

    @ReserveIpAddressSet.setter
    def ReserveIpAddressSet(self, ReserveIpAddressSet):
        self._ReserveIpAddressSet = ReserveIpAddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReserveIpAddressSet") is not None:
            self._ReserveIpAddressSet = []
            for item in params.get("ReserveIpAddressSet"):
                obj = ReserveIpAddressInfo()
                obj._deserialize(item)
                self._ReserveIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateRoutePolicyAssociationsRequest(AbstractModel):
    r"""CreateRoutePolicyAssociations request structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyAssociationSet: Route reception policy binding object list.
        :type RoutePolicyAssociationSet: list of RoutePolicyAssociation
        """
        self._RoutePolicyAssociationSet = None

    @property
    def RoutePolicyAssociationSet(self):
        r"""Route reception policy binding object list.
        :rtype: list of RoutePolicyAssociation
        """
        return self._RoutePolicyAssociationSet

    @RoutePolicyAssociationSet.setter
    def RoutePolicyAssociationSet(self, RoutePolicyAssociationSet):
        self._RoutePolicyAssociationSet = RoutePolicyAssociationSet


    def _deserialize(self, params):
        if params.get("RoutePolicyAssociationSet") is not None:
            self._RoutePolicyAssociationSet = []
            for item in params.get("RoutePolicyAssociationSet"):
                obj = RoutePolicyAssociation()
                obj._deserialize(item)
                self._RoutePolicyAssociationSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutePolicyAssociationsResponse(AbstractModel):
    r"""CreateRoutePolicyAssociations response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRoutePolicyEntriesRequest(AbstractModel):
    r"""CreateRoutePolicyEntries request structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyId: Specifies the instance ID of the route reception policy.
        :type RoutePolicyId: str
        :param _RoutePolicyEntrySet: Route reception policy entry list.
        :type RoutePolicyEntrySet: list of RoutePolicyEntry
        """
        self._RoutePolicyId = None
        self._RoutePolicyEntrySet = None

    @property
    def RoutePolicyId(self):
        r"""Specifies the instance ID of the route reception policy.
        :rtype: str
        """
        return self._RoutePolicyId

    @RoutePolicyId.setter
    def RoutePolicyId(self, RoutePolicyId):
        self._RoutePolicyId = RoutePolicyId

    @property
    def RoutePolicyEntrySet(self):
        r"""Route reception policy entry list.
        :rtype: list of RoutePolicyEntry
        """
        return self._RoutePolicyEntrySet

    @RoutePolicyEntrySet.setter
    def RoutePolicyEntrySet(self, RoutePolicyEntrySet):
        self._RoutePolicyEntrySet = RoutePolicyEntrySet


    def _deserialize(self, params):
        self._RoutePolicyId = params.get("RoutePolicyId")
        if params.get("RoutePolicyEntrySet") is not None:
            self._RoutePolicyEntrySet = []
            for item in params.get("RoutePolicyEntrySet"):
                obj = RoutePolicyEntry()
                obj._deserialize(item)
                self._RoutePolicyEntrySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutePolicyEntriesResponse(AbstractModel):
    r"""CreateRoutePolicyEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRoutePolicyRequest(AbstractModel):
    r"""CreateRoutePolicy request structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyDescription: Routing policy description.
        :type RoutePolicyDescription: str
        :param _RoutePolicyName: Specifies the routing strategy name.
        :type RoutePolicyName: str
        :param _RoutePolicyEntrySet: Routing policy entry list.
        :type RoutePolicyEntrySet: list of RoutePolicyEntry
        """
        self._RoutePolicyDescription = None
        self._RoutePolicyName = None
        self._RoutePolicyEntrySet = None

    @property
    def RoutePolicyDescription(self):
        r"""Routing policy description.
        :rtype: str
        """
        return self._RoutePolicyDescription

    @RoutePolicyDescription.setter
    def RoutePolicyDescription(self, RoutePolicyDescription):
        self._RoutePolicyDescription = RoutePolicyDescription

    @property
    def RoutePolicyName(self):
        r"""Specifies the routing strategy name.
        :rtype: str
        """
        return self._RoutePolicyName

    @RoutePolicyName.setter
    def RoutePolicyName(self, RoutePolicyName):
        self._RoutePolicyName = RoutePolicyName

    @property
    def RoutePolicyEntrySet(self):
        r"""Routing policy entry list.
        :rtype: list of RoutePolicyEntry
        """
        return self._RoutePolicyEntrySet

    @RoutePolicyEntrySet.setter
    def RoutePolicyEntrySet(self, RoutePolicyEntrySet):
        self._RoutePolicyEntrySet = RoutePolicyEntrySet


    def _deserialize(self, params):
        self._RoutePolicyDescription = params.get("RoutePolicyDescription")
        self._RoutePolicyName = params.get("RoutePolicyName")
        if params.get("RoutePolicyEntrySet") is not None:
            self._RoutePolicyEntrySet = []
            for item in params.get("RoutePolicyEntrySet"):
                obj = RoutePolicyEntry()
                obj._deserialize(item)
                self._RoutePolicyEntrySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutePolicyResponse(AbstractModel):
    r"""CreateRoutePolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicy: Specifies the routing policy ID and rules.
        :type RoutePolicy: :class:`tencentcloud.vpc.v20170312.models.RoutePolicy`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoutePolicy = None
        self._RequestId = None

    @property
    def RoutePolicy(self):
        r"""Specifies the routing policy ID and rules.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.RoutePolicy`
        """
        return self._RoutePolicy

    @RoutePolicy.setter
    def RoutePolicy(self, RoutePolicy):
        self._RoutePolicy = RoutePolicy

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoutePolicy") is not None:
            self._RoutePolicy = RoutePolicy()
            self._RoutePolicy._deserialize(params.get("RoutePolicy"))
        self._RequestId = params.get("RequestId")


class CreateRouteTableRequest(AbstractModel):
    r"""CreateRouteTable request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance to be operated on. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _RouteTableName: The route table name. The maximum length is 60 characters.
        :type RouteTableName: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._RouteTableName = None
        self._Tags = None

    @property
    def VpcId(self):
        r"""The ID of the VPC instance to be operated on. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def RouteTableName(self):
        r"""The route table name. The maximum length is 60 characters.
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._RouteTableName = params.get("RouteTableName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRouteTableResponse(AbstractModel):
    r"""CreateRouteTable response structure.

    """

    def __init__(self):
        r"""
        :param _RouteTable: Route table object.
        :type RouteTable: :class:`tencentcloud.vpc.v20170312.models.RouteTable`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RouteTable = None
        self._RequestId = None

    @property
    def RouteTable(self):
        r"""Route table object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.RouteTable`
        """
        return self._RouteTable

    @RouteTable.setter
    def RouteTable(self, RouteTable):
        self._RouteTable = RouteTable

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteTable") is not None:
            self._RouteTable = RouteTable()
            self._RouteTable._deserialize(params.get("RouteTable"))
        self._RequestId = params.get("RequestId")


class CreateRoutesRequest(AbstractModel):
    r"""CreateRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: Route table instance ID.
        :type RouteTableId: str
        :param _Routes: Routing policy object.
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        r"""Route table instance ID.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        r"""Routing policy object.
        :rtype: list of Route
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutesResponse(AbstractModel):
    r"""CreateRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of newly added instances.
        :type TotalCount: int
        :param _RouteTableSet: Route table object.
        :type RouteTableSet: list of RouteTable
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of newly added instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        r"""Route table object.
        :rtype: list of RouteTable
        """
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupPoliciesRequest(AbstractModel):
    r"""CreateSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: Security group policy set.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        r"""The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        r"""Security group policy set.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupPoliciesResponse(AbstractModel):
    r"""CreateSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupRequest(AbstractModel):
    r"""CreateSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _GroupName: Security group can be named freely, but cannot exceed 60 characters.
        :type GroupName: str
        :param _GroupDescription: The remarks for the security group. The maximum length is 100 characters.
        :type GroupDescription: str
        :param _ProjectId: Project ID. The default is 0. You can query it on the project management page of the Qcloud console.
        :type ProjectId: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        """
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._Tags = None

    @property
    def GroupName(self):
        r"""Security group can be named freely, but cannot exceed 60 characters.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        r"""The remarks for the security group. The maximum length is 100 characters.
        :rtype: str
        """
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        r"""Project ID. The default is 0. You can query it on the project management page of the Qcloud console.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupResponse(AbstractModel):
    r"""CreateSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group object.
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        r"""Security group object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupWithPoliciesRequest(AbstractModel):
    r"""CreateSecurityGroupWithPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _GroupName: Security group can be named freely, but cannot exceed 60 characters.
        :type GroupName: str
        :param _GroupDescription: The remarks for the security group. The maximum length is 100 characters.
        :type GroupDescription: str
        :param _ProjectId: Project ID. Default value: 0. You can query it on the <a href="https://console.cloud.tencent.com/project">project management page</a> of the Tencent Cloud console.
        :type ProjectId: str
        :param _SecurityGroupPolicySet: Security group policy set.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._SecurityGroupPolicySet = None

    @property
    def GroupName(self):
        r"""Security group can be named freely, but cannot exceed 60 characters.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        r"""The remarks for the security group. The maximum length is 100 characters.
        :rtype: str
        """
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        r"""Project ID. Default value: 0. You can query it on the <a href="https://console.cloud.tencent.com/project">project management page</a> of the Tencent Cloud console.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SecurityGroupPolicySet(self):
        r"""Security group policy set.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupWithPoliciesResponse(AbstractModel):
    r"""CreateSecurityGroupWithPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: Security group object.
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        r"""Security group object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateServiceTemplateGroupRequest(AbstractModel):
    r"""CreateServiceTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupName: Group name of the protocol port template.
        :type ServiceTemplateGroupName: str
        :param _ServiceTemplateIds: Instance ID of the protocol port template, such as `ppm-4dw6agho`.
        :type ServiceTemplateIds: list of str
        """
        self._ServiceTemplateGroupName = None
        self._ServiceTemplateIds = None

    @property
    def ServiceTemplateGroupName(self):
        r"""Group name of the protocol port template.
        :rtype: str
        """
        return self._ServiceTemplateGroupName

    @ServiceTemplateGroupName.setter
    def ServiceTemplateGroupName(self, ServiceTemplateGroupName):
        self._ServiceTemplateGroupName = ServiceTemplateGroupName

    @property
    def ServiceTemplateIds(self):
        r"""Instance ID of the protocol port template, such as `ppm-4dw6agho`.
        :rtype: list of str
        """
        return self._ServiceTemplateIds

    @ServiceTemplateIds.setter
    def ServiceTemplateIds(self, ServiceTemplateIds):
        self._ServiceTemplateIds = ServiceTemplateIds


    def _deserialize(self, params):
        self._ServiceTemplateGroupName = params.get("ServiceTemplateGroupName")
        self._ServiceTemplateIds = params.get("ServiceTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateServiceTemplateGroupResponse(AbstractModel):
    r"""CreateServiceTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroup: Group object of the protocol port template.
        :type ServiceTemplateGroup: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplateGroup`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ServiceTemplateGroup = None
        self._RequestId = None

    @property
    def ServiceTemplateGroup(self):
        r"""Group object of the protocol port template.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplateGroup`
        """
        return self._ServiceTemplateGroup

    @ServiceTemplateGroup.setter
    def ServiceTemplateGroup(self, ServiceTemplateGroup):
        self._ServiceTemplateGroup = ServiceTemplateGroup

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceTemplateGroup") is not None:
            self._ServiceTemplateGroup = ServiceTemplateGroup()
            self._ServiceTemplateGroup._deserialize(params.get("ServiceTemplateGroup"))
        self._RequestId = params.get("RequestId")


class CreateServiceTemplateRequest(AbstractModel):
    r"""CreateServiceTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateName: Template name of the protocol port
        :type ServiceTemplateName: str
        :param _Services: Supported ports inlcude single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP and GRE. Either Services or ServicesExtra is required.
        :type Services: list of str
        :param _ServicesExtra: You can add remarks. Supported ports include single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP and GRE. Either Services or ServicesExtra is required.
        :type ServicesExtra: list of ServicesInfo
        """
        self._ServiceTemplateName = None
        self._Services = None
        self._ServicesExtra = None

    @property
    def ServiceTemplateName(self):
        r"""Template name of the protocol port
        :rtype: str
        """
        return self._ServiceTemplateName

    @ServiceTemplateName.setter
    def ServiceTemplateName(self, ServiceTemplateName):
        self._ServiceTemplateName = ServiceTemplateName

    @property
    def Services(self):
        r"""Supported ports inlcude single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP and GRE. Either Services or ServicesExtra is required.
        :rtype: list of str
        """
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def ServicesExtra(self):
        r"""You can add remarks. Supported ports include single port, multiple ports, consecutive ports and all ports. Supported protocols include TCP, UDP, ICMP and GRE. Either Services or ServicesExtra is required.
        :rtype: list of ServicesInfo
        """
        return self._ServicesExtra

    @ServicesExtra.setter
    def ServicesExtra(self, ServicesExtra):
        self._ServicesExtra = ServicesExtra


    def _deserialize(self, params):
        self._ServiceTemplateName = params.get("ServiceTemplateName")
        self._Services = params.get("Services")
        if params.get("ServicesExtra") is not None:
            self._ServicesExtra = []
            for item in params.get("ServicesExtra"):
                obj = ServicesInfo()
                obj._deserialize(item)
                self._ServicesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateServiceTemplateResponse(AbstractModel):
    r"""CreateServiceTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplate: Protocol port template object.
        :type ServiceTemplate: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplate`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ServiceTemplate = None
        self._RequestId = None

    @property
    def ServiceTemplate(self):
        r"""Protocol port template object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplate`
        """
        return self._ServiceTemplate

    @ServiceTemplate.setter
    def ServiceTemplate(self, ServiceTemplate):
        self._ServiceTemplate = ServiceTemplate

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceTemplate") is not None:
            self._ServiceTemplate = ServiceTemplate()
            self._ServiceTemplate._deserialize(params.get("ServiceTemplate"))
        self._RequestId = params.get("RequestId")


class CreateSnapshotPoliciesRequest(AbstractModel):
    r"""CreateSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicies: Details of a snapshot policy
        :type SnapshotPolicies: list of SnapshotPolicy
        """
        self._SnapshotPolicies = None

    @property
    def SnapshotPolicies(self):
        r"""Details of a snapshot policy
        :rtype: list of SnapshotPolicy
        """
        return self._SnapshotPolicies

    @SnapshotPolicies.setter
    def SnapshotPolicies(self, SnapshotPolicies):
        self._SnapshotPolicies = SnapshotPolicies


    def _deserialize(self, params):
        if params.get("SnapshotPolicies") is not None:
            self._SnapshotPolicies = []
            for item in params.get("SnapshotPolicies"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotPoliciesResponse(AbstractModel):
    r"""CreateSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicies: Snapshot policies
        :type SnapshotPolicies: list of SnapshotPolicy
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SnapshotPolicies = None
        self._RequestId = None

    @property
    def SnapshotPolicies(self):
        r"""Snapshot policies
        :rtype: list of SnapshotPolicy
        """
        return self._SnapshotPolicies

    @SnapshotPolicies.setter
    def SnapshotPolicies(self, SnapshotPolicies):
        self._SnapshotPolicies = SnapshotPolicies

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotPolicies") is not None:
            self._SnapshotPolicies = []
            for item in params.get("SnapshotPolicies"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicies.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSubnetRequest(AbstractModel):
    r"""CreateSubnet request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance to be operated on. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _SubnetName: The subnet name. The maximum length is 60 bytes.
        :type SubnetName: str
        :param _CidrBlock: The subnet IP address range. It must be within the VPC IP address range. Subnet IP address ranges cannot overlap with each other within the same VPC.
        :type CidrBlock: str
        :param _Zone: The ID of the availability zone in which the subnet resides. You can set up disaster recovery across availability zones by choosing different availability zones for different subnets.
        :type Zone: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _CdcId: CDC instance ID
        :type CdcId: str
        """
        self._VpcId = None
        self._SubnetName = None
        self._CidrBlock = None
        self._Zone = None
        self._Tags = None
        self._CdcId = None

    @property
    def VpcId(self):
        r"""The ID of the VPC instance to be operated on. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetName(self):
        r"""The subnet name. The maximum length is 60 bytes.
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def CidrBlock(self):
        r"""The subnet IP address range. It must be within the VPC IP address range. Subnet IP address ranges cannot overlap with each other within the same VPC.
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def Zone(self):
        r"""The ID of the availability zone in which the subnet resides. You can set up disaster recovery across availability zones by choosing different availability zones for different subnets.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        r"""CDC instance ID
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetName = params.get("SubnetName")
        self._CidrBlock = params.get("CidrBlock")
        self._Zone = params.get("Zone")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetResponse(AbstractModel):
    r"""CreateSubnet response structure.

    """

    def __init__(self):
        r"""
        :param _Subnet: Subnet object.
        :type Subnet: :class:`tencentcloud.vpc.v20170312.models.Subnet`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Subnet = None
        self._RequestId = None

    @property
    def Subnet(self):
        r"""Subnet object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Subnet`
        """
        return self._Subnet

    @Subnet.setter
    def Subnet(self, Subnet):
        self._Subnet = Subnet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Subnet") is not None:
            self._Subnet = Subnet()
            self._Subnet._deserialize(params.get("Subnet"))
        self._RequestId = params.get("RequestId")


class CreateSubnetsRequest(AbstractModel):
    r"""CreateSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC` instance, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _Subnets: The subnet object list.
        :type Subnets: list of SubnetInput
        :param _Tags: Bound tags. Note that the collection of tags here is shared by all subnet objects in the list. You cannot specify tags for each subnet. Example: [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _CdcId: ID of the CDC instance to which the subnets will be created
        :type CdcId: str
        """
        self._VpcId = None
        self._Subnets = None
        self._Tags = None
        self._CdcId = None

    @property
    def VpcId(self):
        r"""The `ID` of the `VPC` instance, such as `vpc-6v2ht8q5`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Subnets(self):
        r"""The subnet object list.
        :rtype: list of SubnetInput
        """
        return self._Subnets

    @Subnets.setter
    def Subnets(self, Subnets):
        self._Subnets = Subnets

    @property
    def Tags(self):
        r"""Bound tags. Note that the collection of tags here is shared by all subnet objects in the list. You cannot specify tags for each subnet. Example: [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        r"""ID of the CDC instance to which the subnets will be created
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        if params.get("Subnets") is not None:
            self._Subnets = []
            for item in params.get("Subnets"):
                obj = SubnetInput()
                obj._deserialize(item)
                self._Subnets.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetsResponse(AbstractModel):
    r"""CreateSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _SubnetSet: The list of newly created subnets.
        :type SubnetSet: list of Subnet
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubnetSet = None
        self._RequestId = None

    @property
    def SubnetSet(self):
        r"""The list of newly created subnets.
        :rtype: list of Subnet
        """
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointRequest(AbstractModel):
    r"""CreateVpcEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _SubnetId: Subnet instance ID
        :type SubnetId: str
        :param _EndPointName: Endpoint name
        :type EndPointName: str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _EndPointVip: Endpoint VIP. You can apply for a specified IP.
        :type EndPointVip: str
        :param _SecurityGroupId: Security group ID
        :type SecurityGroupId: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._EndPointName = None
        self._EndPointServiceId = None
        self._EndPointVip = None
        self._SecurityGroupId = None

    @property
    def VpcId(self):
        r"""VPC instance ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet instance ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def EndPointName(self):
        r"""Endpoint name
        :rtype: str
        """
        return self._EndPointName

    @EndPointName.setter
    def EndPointName(self, EndPointName):
        self._EndPointName = EndPointName

    @property
    def EndPointServiceId(self):
        r"""Endpoint service ID
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def EndPointVip(self):
        r"""Endpoint VIP. You can apply for a specified IP.
        :rtype: str
        """
        return self._EndPointVip

    @EndPointVip.setter
    def EndPointVip(self, EndPointVip):
        self._EndPointVip = EndPointVip

    @property
    def SecurityGroupId(self):
        r"""Security group ID
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._EndPointName = params.get("EndPointName")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._EndPointVip = params.get("EndPointVip")
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointResponse(AbstractModel):
    r"""CreateVpcEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _EndPoint: Endpoint details
        :type EndPoint: :class:`tencentcloud.vpc.v20170312.models.EndPoint`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPoint = None
        self._RequestId = None

    @property
    def EndPoint(self):
        r"""Endpoint details
        :rtype: :class:`tencentcloud.vpc.v20170312.models.EndPoint`
        """
        return self._EndPoint

    @EndPoint.setter
    def EndPoint(self, EndPoint):
        self._EndPoint = EndPoint

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPoint") is not None:
            self._EndPoint = EndPoint()
            self._EndPoint._deserialize(params.get("EndPoint"))
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointServiceRequest(AbstractModel):
    r"""CreateVpcEndPointService request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID
        :type VpcId: str
        :param _EndPointServiceName: Endpoint service name
        :type EndPointServiceName: str
        :param _AutoAcceptFlag: Whether to automatically accept
        :type AutoAcceptFlag: bool
        :param _ServiceInstanceId: Real server ID, such as `lb-xxx`.
        :type ServiceInstanceId: str
        :param _IsPassService: (Disused) Whether it’s a PaaS service
        :type IsPassService: bool
        :param _ServiceType: Mounted PaaS service type. Values: `CLB` (default), `CDB`, `CRS`
        :type ServiceType: str
        """
        self._VpcId = None
        self._EndPointServiceName = None
        self._AutoAcceptFlag = None
        self._ServiceInstanceId = None
        self._IsPassService = None
        self._ServiceType = None

    @property
    def VpcId(self):
        r"""VPC instance ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def EndPointServiceName(self):
        r"""Endpoint service name
        :rtype: str
        """
        return self._EndPointServiceName

    @EndPointServiceName.setter
    def EndPointServiceName(self, EndPointServiceName):
        self._EndPointServiceName = EndPointServiceName

    @property
    def AutoAcceptFlag(self):
        r"""Whether to automatically accept
        :rtype: bool
        """
        return self._AutoAcceptFlag

    @AutoAcceptFlag.setter
    def AutoAcceptFlag(self, AutoAcceptFlag):
        self._AutoAcceptFlag = AutoAcceptFlag

    @property
    def ServiceInstanceId(self):
        r"""Real server ID, such as `lb-xxx`.
        :rtype: str
        """
        return self._ServiceInstanceId

    @ServiceInstanceId.setter
    def ServiceInstanceId(self, ServiceInstanceId):
        self._ServiceInstanceId = ServiceInstanceId

    @property
    def IsPassService(self):
        r"""(Disused) Whether it’s a PaaS service
        :rtype: bool
        """
        return self._IsPassService

    @IsPassService.setter
    def IsPassService(self, IsPassService):
        self._IsPassService = IsPassService

    @property
    def ServiceType(self):
        r"""Mounted PaaS service type. Values: `CLB` (default), `CDB`, `CRS`
        :rtype: str
        """
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._EndPointServiceName = params.get("EndPointServiceName")
        self._AutoAcceptFlag = params.get("AutoAcceptFlag")
        self._ServiceInstanceId = params.get("ServiceInstanceId")
        self._IsPassService = params.get("IsPassService")
        self._ServiceType = params.get("ServiceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointServiceResponse(AbstractModel):
    r"""CreateVpcEndPointService response structure.

    """

    def __init__(self):
        r"""
        :param _EndPointService: Endpoint service details
        :type EndPointService: :class:`tencentcloud.vpc.v20170312.models.EndPointService`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPointService = None
        self._RequestId = None

    @property
    def EndPointService(self):
        r"""Endpoint service details
        :rtype: :class:`tencentcloud.vpc.v20170312.models.EndPointService`
        """
        return self._EndPointService

    @EndPointService.setter
    def EndPointService(self, EndPointService):
        self._EndPointService = EndPointService

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointService") is not None:
            self._EndPointService = EndPointService()
            self._EndPointService._deserialize(params.get("EndPointService"))
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointServiceWhiteListRequest(AbstractModel):
    r"""CreateVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _UserUin: UIN
        :type UserUin: str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        :param _Description: Allowlist description
        :type Description: str
        """
        self._UserUin = None
        self._EndPointServiceId = None
        self._Description = None

    @property
    def UserUin(self):
        r"""UIN
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        r"""Endpoint service ID
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def Description(self):
        r"""Allowlist description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointServiceWhiteListResponse(AbstractModel):
    r"""CreateVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateVpcRequest(AbstractModel):
    r"""CreateVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcName: The VPC name. The maximum length is 60 bytes.
        :type VpcName: str
        :param _CidrBlock: VPC CIDR block, which must fall within the following three private network IP ranges: 10.0.0.0/12, 172.16.0.0/12, and 192.168.0.0/16.
        :type CidrBlock: str
        :param _EnableMulticast: Whether multicast is enabled. `true`: Enabled. `false`: Not enabled.
        :type EnableMulticast: str
        :param _DnsServers: DNS address. A maximum of 4 addresses is supported.
        :type DnsServers: list of str
        :param _DomainName: Domain name of DHCP
        :type DomainName: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _EnableRouteVpcPublish: Vpc association with CCN route publish policy. true: enables cidr route publishing. false: enables subnet route publishing. default is subnet route publishing when creating a vpc. to select cidr route publishing, submit a ticket for adding to allowlist.
        :type EnableRouteVpcPublish: bool
        """
        self._VpcName = None
        self._CidrBlock = None
        self._EnableMulticast = None
        self._DnsServers = None
        self._DomainName = None
        self._Tags = None
        self._EnableRouteVpcPublish = None

    @property
    def VpcName(self):
        r"""The VPC name. The maximum length is 60 bytes.
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def CidrBlock(self):
        r"""VPC CIDR block, which must fall within the following three private network IP ranges: 10.0.0.0/12, 172.16.0.0/12, and 192.168.0.0/16.
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def EnableMulticast(self):
        r"""Whether multicast is enabled. `true`: Enabled. `false`: Not enabled.
        :rtype: str
        """
        return self._EnableMulticast

    @EnableMulticast.setter
    def EnableMulticast(self, EnableMulticast):
        self._EnableMulticast = EnableMulticast

    @property
    def DnsServers(self):
        r"""DNS address. A maximum of 4 addresses is supported.
        :rtype: list of str
        """
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers

    @property
    def DomainName(self):
        r"""Domain name of DHCP
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def EnableRouteVpcPublish(self):
        r"""Vpc association with CCN route publish policy. true: enables cidr route publishing. false: enables subnet route publishing. default is subnet route publishing when creating a vpc. to select cidr route publishing, submit a ticket for adding to allowlist.
        :rtype: bool
        """
        return self._EnableRouteVpcPublish

    @EnableRouteVpcPublish.setter
    def EnableRouteVpcPublish(self, EnableRouteVpcPublish):
        self._EnableRouteVpcPublish = EnableRouteVpcPublish


    def _deserialize(self, params):
        self._VpcName = params.get("VpcName")
        self._CidrBlock = params.get("CidrBlock")
        self._EnableMulticast = params.get("EnableMulticast")
        self._DnsServers = params.get("DnsServers")
        self._DomainName = params.get("DomainName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._EnableRouteVpcPublish = params.get("EnableRouteVpcPublish")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcResponse(AbstractModel):
    r"""CreateVpc response structure.

    """

    def __init__(self):
        r"""
        :param _Vpc: The VPC object.
        :type Vpc: :class:`tencentcloud.vpc.v20170312.models.Vpc`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Vpc = None
        self._RequestId = None

    @property
    def Vpc(self):
        r"""The VPC object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Vpc`
        """
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Vpc") is not None:
            self._Vpc = Vpc()
            self._Vpc._deserialize(params.get("Vpc"))
        self._RequestId = params.get("RequestId")


class CreateVpnConnectionRequest(AbstractModel):
    r"""CreateVpnConnection request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _CustomerGatewayId: The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/product/215/17516?from_cn_redirect=1) API.
        :type CustomerGatewayId: str
        :param _VpnConnectionName: Gateway can be named freely, but the maximum length is 60 characters.
        :type VpnConnectionName: str
        :param _PreShareKey: The pre-shared key.
        :type PreShareKey: str
        :param _VpcId: VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
This parameter is optional for a CCN-based VPN tunnel.
        :type VpcId: str
        :param _SecurityPolicyDatabases: The SPD policy group, for example: {"10.0.0.5/24":["172.123.10.5/16"]}. 10.0.0.5/24 is the VPC internal IP range, and 172.123.10.5/16 is the IDC IP range. The user specifies the IP range in the VPC that can communicate with the IP range in the IDC.
        :type SecurityPolicyDatabases: list of SecurityPolicyDatabase
        :param _IKEOptionsSpecification: Internet Key Exchange (IKE) configuration. IKE has a self-protection mechanism. The network security protocol is configured by the user.
        :type IKEOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IKEOptionsSpecification`
        :param _IPSECOptionsSpecification: IPSec configuration. The IPSec secure session configuration is provided by Tencent Cloud.
        :type IPSECOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IPSECOptionsSpecification`
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _EnableHealthCheck: Whether the tunnel health check is supported. The default value is `False`.
        :type EnableHealthCheck: bool
        :param _HealthCheckLocalIp: Local IP of health check. It defaults to a random IP within 169.254.128.0/17.
        :type HealthCheckLocalIp: str
        :param _HealthCheckRemoteIp: Peer IP of health check. It defaults to a random IP within 169.254.128.0/17.
        :type HealthCheckRemoteIp: str
        :param _RouteType: Tunnel type. Valid values: `STATIC`, `StaticRoute`, and `Policy`.
        :type RouteType: str
        :param _NegotiationType: Negotiation type. Valid values: `active` (default value), `passive` and `flowTrigger`.
        :type NegotiationType: str
        :param _DpdEnable: Specifies whether to enable DPD. Valid values: `0` (disable) and `1` (enable)
        :type DpdEnable: int
        :param _DpdTimeout: DPD timeout period. Default: 30; unit: second. If the request is not responded within this period, the peer end is considered not exists. This parameter is valid when the value of `DpdEnable` is 1. 
        :type DpdTimeout: str
        :param _DpdAction: The action after DPD timeout. Valid values: `clear` (disconnect) and `restart` (try again). It’s valid when `DpdEnable` is `1`. 
        :type DpdAction: str
        """
        self._VpnGatewayId = None
        self._CustomerGatewayId = None
        self._VpnConnectionName = None
        self._PreShareKey = None
        self._VpcId = None
        self._SecurityPolicyDatabases = None
        self._IKEOptionsSpecification = None
        self._IPSECOptionsSpecification = None
        self._Tags = None
        self._EnableHealthCheck = None
        self._HealthCheckLocalIp = None
        self._HealthCheckRemoteIp = None
        self._RouteType = None
        self._NegotiationType = None
        self._DpdEnable = None
        self._DpdTimeout = None
        self._DpdAction = None

    @property
    def VpnGatewayId(self):
        r"""The ID of the VPN gateway instance.
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def CustomerGatewayId(self):
        r"""The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/product/215/17516?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def VpnConnectionName(self):
        r"""Gateway can be named freely, but the maximum length is 60 characters.
        :rtype: str
        """
        return self._VpnConnectionName

    @VpnConnectionName.setter
    def VpnConnectionName(self, VpnConnectionName):
        self._VpnConnectionName = VpnConnectionName

    @property
    def PreShareKey(self):
        r"""The pre-shared key.
        :rtype: str
        """
        return self._PreShareKey

    @PreShareKey.setter
    def PreShareKey(self, PreShareKey):
        self._PreShareKey = PreShareKey

    @property
    def VpcId(self):
        r"""VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
This parameter is optional for a CCN-based VPN tunnel.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SecurityPolicyDatabases(self):
        r"""The SPD policy group, for example: {"10.0.0.5/24":["172.123.10.5/16"]}. 10.0.0.5/24 is the VPC internal IP range, and 172.123.10.5/16 is the IDC IP range. The user specifies the IP range in the VPC that can communicate with the IP range in the IDC.
        :rtype: list of SecurityPolicyDatabase
        """
        return self._SecurityPolicyDatabases

    @SecurityPolicyDatabases.setter
    def SecurityPolicyDatabases(self, SecurityPolicyDatabases):
        self._SecurityPolicyDatabases = SecurityPolicyDatabases

    @property
    def IKEOptionsSpecification(self):
        r"""Internet Key Exchange (IKE) configuration. IKE has a self-protection mechanism. The network security protocol is configured by the user.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.IKEOptionsSpecification`
        """
        return self._IKEOptionsSpecification

    @IKEOptionsSpecification.setter
    def IKEOptionsSpecification(self, IKEOptionsSpecification):
        self._IKEOptionsSpecification = IKEOptionsSpecification

    @property
    def IPSECOptionsSpecification(self):
        r"""IPSec configuration. The IPSec secure session configuration is provided by Tencent Cloud.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.IPSECOptionsSpecification`
        """
        return self._IPSECOptionsSpecification

    @IPSECOptionsSpecification.setter
    def IPSECOptionsSpecification(self, IPSECOptionsSpecification):
        self._IPSECOptionsSpecification = IPSECOptionsSpecification

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def EnableHealthCheck(self):
        r"""Whether the tunnel health check is supported. The default value is `False`.
        :rtype: bool
        """
        return self._EnableHealthCheck

    @EnableHealthCheck.setter
    def EnableHealthCheck(self, EnableHealthCheck):
        self._EnableHealthCheck = EnableHealthCheck

    @property
    def HealthCheckLocalIp(self):
        r"""Local IP of health check. It defaults to a random IP within 169.254.128.0/17.
        :rtype: str
        """
        return self._HealthCheckLocalIp

    @HealthCheckLocalIp.setter
    def HealthCheckLocalIp(self, HealthCheckLocalIp):
        self._HealthCheckLocalIp = HealthCheckLocalIp

    @property
    def HealthCheckRemoteIp(self):
        r"""Peer IP of health check. It defaults to a random IP within 169.254.128.0/17.
        :rtype: str
        """
        return self._HealthCheckRemoteIp

    @HealthCheckRemoteIp.setter
    def HealthCheckRemoteIp(self, HealthCheckRemoteIp):
        self._HealthCheckRemoteIp = HealthCheckRemoteIp

    @property
    def RouteType(self):
        r"""Tunnel type. Valid values: `STATIC`, `StaticRoute`, and `Policy`.
        :rtype: str
        """
        return self._RouteType

    @RouteType.setter
    def RouteType(self, RouteType):
        self._RouteType = RouteType

    @property
    def NegotiationType(self):
        r"""Negotiation type. Valid values: `active` (default value), `passive` and `flowTrigger`.
        :rtype: str
        """
        return self._NegotiationType

    @NegotiationType.setter
    def NegotiationType(self, NegotiationType):
        self._NegotiationType = NegotiationType

    @property
    def DpdEnable(self):
        r"""Specifies whether to enable DPD. Valid values: `0` (disable) and `1` (enable)
        :rtype: int
        """
        return self._DpdEnable

    @DpdEnable.setter
    def DpdEnable(self, DpdEnable):
        self._DpdEnable = DpdEnable

    @property
    def DpdTimeout(self):
        r"""DPD timeout period. Default: 30; unit: second. If the request is not responded within this period, the peer end is considered not exists. This parameter is valid when the value of `DpdEnable` is 1. 
        :rtype: str
        """
        return self._DpdTimeout

    @DpdTimeout.setter
    def DpdTimeout(self, DpdTimeout):
        self._DpdTimeout = DpdTimeout

    @property
    def DpdAction(self):
        r"""The action after DPD timeout. Valid values: `clear` (disconnect) and `restart` (try again). It’s valid when `DpdEnable` is `1`. 
        :rtype: str
        """
        return self._DpdAction

    @DpdAction.setter
    def DpdAction(self, DpdAction):
        self._DpdAction = DpdAction


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._VpnConnectionName = params.get("VpnConnectionName")
        self._PreShareKey = params.get("PreShareKey")
        self._VpcId = params.get("VpcId")
        if params.get("SecurityPolicyDatabases") is not None:
            self._SecurityPolicyDatabases = []
            for item in params.get("SecurityPolicyDatabases"):
                obj = SecurityPolicyDatabase()
                obj._deserialize(item)
                self._SecurityPolicyDatabases.append(obj)
        if params.get("IKEOptionsSpecification") is not None:
            self._IKEOptionsSpecification = IKEOptionsSpecification()
            self._IKEOptionsSpecification._deserialize(params.get("IKEOptionsSpecification"))
        if params.get("IPSECOptionsSpecification") is not None:
            self._IPSECOptionsSpecification = IPSECOptionsSpecification()
            self._IPSECOptionsSpecification._deserialize(params.get("IPSECOptionsSpecification"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._EnableHealthCheck = params.get("EnableHealthCheck")
        self._HealthCheckLocalIp = params.get("HealthCheckLocalIp")
        self._HealthCheckRemoteIp = params.get("HealthCheckRemoteIp")
        self._RouteType = params.get("RouteType")
        self._NegotiationType = params.get("NegotiationType")
        self._DpdEnable = params.get("DpdEnable")
        self._DpdTimeout = params.get("DpdTimeout")
        self._DpdAction = params.get("DpdAction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnConnectionResponse(AbstractModel):
    r"""CreateVpnConnection response structure.

    """

    def __init__(self):
        r"""
        :param _VpnConnection: Tunnel instance object.
        :type VpnConnection: :class:`tencentcloud.vpc.v20170312.models.VpnConnection`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpnConnection = None
        self._RequestId = None

    @property
    def VpnConnection(self):
        r"""Tunnel instance object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.VpnConnection`
        """
        return self._VpnConnection

    @VpnConnection.setter
    def VpnConnection(self, VpnConnection):
        self._VpnConnection = VpnConnection

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpnConnection") is not None:
            self._VpnConnection = VpnConnection()
            self._VpnConnection._deserialize(params.get("VpnConnection"))
        self._RequestId = params.get("RequestId")


class CreateVpnGatewayRequest(AbstractModel):
    r"""CreateVpnGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
        :type VpcId: str
        :param _VpnGatewayName: The VPN gateway name. The maximum length is 60 bytes.
        :type VpnGatewayName: str
        :param _InternetMaxBandwidthOut: The public network bandwidth configuration. Available bandwidth specifications: 5, 10, 20, 50, and 100. Unit: Mbps
        :type InternetMaxBandwidthOut: int
        :param _InstanceChargeType: The VPN gateway billing mode. PREPAID: prepaid means monthly subscription. POSTPAID_BY_HOUR: postpaid means pay-as-you-go. Default: POSTPAID_BY_HOUR. If prepaid mode is specified, the `InstanceChargePrepaid` parameter must be entered.
        :type InstanceChargeType: str
        :param _InstanceChargePrepaid: Parameter settings for prepaid billing mode, also known as monthly subscription. This parameter can specify the purchase period and other attributes such as auto-renewal. This parameter is mandatory for prepaid instances.
        :type InstanceChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        :param _Zone: The availability zone, such as `ap-guangzhou-2`.
        :type Zone: str
        :param _Type: VPN gateway type. Values: `CCN` (CCN VPN gateway), `SSL` (SSL VPN gateway)
        :type Type: str
        :param _Tags: Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :type Tags: list of Tag
        :param _CdcId: CDC instance ID
        :type CdcId: str
        :param _MaxConnection: Maximum number of connected clients allowed for the SSL VPN gateway. Valid values: [5, 10, 20, 50, 100]. This parameter is only required for SSL VPN gateways.
        :type MaxConnection: int
        """
        self._VpcId = None
        self._VpnGatewayName = None
        self._InternetMaxBandwidthOut = None
        self._InstanceChargeType = None
        self._InstanceChargePrepaid = None
        self._Zone = None
        self._Type = None
        self._Tags = None
        self._CdcId = None
        self._MaxConnection = None

    @property
    def VpcId(self):
        r"""VPC instance ID, which can be obtained from the `VpcId` field in the response of the [`DescribeVpcs`](https://intl.cloud.tencent.com/document/product/215/15778?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpnGatewayName(self):
        r"""The VPN gateway name. The maximum length is 60 bytes.
        :rtype: str
        """
        return self._VpnGatewayName

    @VpnGatewayName.setter
    def VpnGatewayName(self, VpnGatewayName):
        self._VpnGatewayName = VpnGatewayName

    @property
    def InternetMaxBandwidthOut(self):
        r"""The public network bandwidth configuration. Available bandwidth specifications: 5, 10, 20, 50, and 100. Unit: Mbps
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def InstanceChargeType(self):
        r"""The VPN gateway billing mode. PREPAID: prepaid means monthly subscription. POSTPAID_BY_HOUR: postpaid means pay-as-you-go. Default: POSTPAID_BY_HOUR. If prepaid mode is specified, the `InstanceChargePrepaid` parameter must be entered.
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def InstanceChargePrepaid(self):
        r"""Parameter settings for prepaid billing mode, also known as monthly subscription. This parameter can specify the purchase period and other attributes such as auto-renewal. This parameter is mandatory for prepaid instances.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        """
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid

    @property
    def Zone(self):
        r"""The availability zone, such as `ap-guangzhou-2`.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Type(self):
        r"""VPN gateway type. Values: `CCN` (CCN VPN gateway), `SSL` (SSL VPN gateway)
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        r"""Bound tags, such as [{"Key": "city", "Value": "shanghai"}].
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        r"""CDC instance ID
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def MaxConnection(self):
        r"""Maximum number of connected clients allowed for the SSL VPN gateway. Valid values: [5, 10, 20, 50, 100]. This parameter is only required for SSL VPN gateways.
        :rtype: int
        """
        return self._MaxConnection

    @MaxConnection.setter
    def MaxConnection(self, MaxConnection):
        self._MaxConnection = MaxConnection


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpnGatewayName = params.get("VpnGatewayName")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._InstanceChargeType = params.get("InstanceChargeType")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        self._Zone = params.get("Zone")
        self._Type = params.get("Type")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        self._MaxConnection = params.get("MaxConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewayResponse(AbstractModel):
    r"""CreateVpnGateway response structure.

    """

    def __init__(self):
        r"""
        :param _VpnGateway: VPN gateway object.
        :type VpnGateway: :class:`tencentcloud.vpc.v20170312.models.VpnGateway`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpnGateway = None
        self._RequestId = None

    @property
    def VpnGateway(self):
        r"""VPN gateway object.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.VpnGateway`
        """
        return self._VpnGateway

    @VpnGateway.setter
    def VpnGateway(self, VpnGateway):
        self._VpnGateway = VpnGateway

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpnGateway") is not None:
            self._VpnGateway = VpnGateway()
            self._VpnGateway._deserialize(params.get("VpnGateway"))
        self._RequestId = params.get("RequestId")


class CreateVpnGatewayRoutesRequest(AbstractModel):
    r"""CreateVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN gateway ID
        :type VpnGatewayId: str
        :param _Routes: Destination route list of a VPN gateway
        :type Routes: list of VpnGatewayRoute
        """
        self._VpnGatewayId = None
        self._Routes = None

    @property
    def VpnGatewayId(self):
        r"""VPN gateway ID
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Routes(self):
        r"""Destination route list of a VPN gateway
        :rtype: list of VpnGatewayRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewayRoutesResponse(AbstractModel):
    r"""CreateVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _Routes: Destination routes of a VPN gateway
        :type Routes: list of VpnGatewayRoute
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Routes = None
        self._RequestId = None

    @property
    def Routes(self):
        r"""Destination routes of a VPN gateway
        :rtype: list of VpnGatewayRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        self._RequestId = params.get("RequestId")


class CrossBorderCompliance(AbstractModel):
    r"""Compliance review request

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: Service provider. Valid values: `UNICOM`.
        :type ServiceProvider: str
        :param _ComplianceId: ID of compliance review request.
        :type ComplianceId: int
        :param _Company: Full company name.
        :type Company: str
        :param _UniformSocialCreditCode: Unified Social Credit Code.
        :type UniformSocialCreditCode: str
        :param _LegalPerson: Legal person.
        :type LegalPerson: str
        :param _IssuingAuthority: Issuing authority.
        :type IssuingAuthority: str
        :param _BusinessLicense: Business license.
        :type BusinessLicense: str
        :param _BusinessAddress: Business address.
        :type BusinessAddress: str
        :param _PostCode: Zip code.
        :type PostCode: int
        :param _Manager: Operator.
        :type Manager: str
        :param _ManagerId: Operator ID card number.
        :type ManagerId: str
        :param _ManagerIdCard: Operator ID card.
        :type ManagerIdCard: str
        :param _ManagerAddress: Operator address.
        :type ManagerAddress: str
        :param _ManagerTelephone: Operator phone number.
        :type ManagerTelephone: str
        :param _Email: Email.
        :type Email: str
        :param _ServiceHandlingForm: Service handling form.
        :type ServiceHandlingForm: str
        :param _AuthorizationLetter: Authorization letter.
        :type AuthorizationLetter: str
        :param _SafetyCommitment: Information security commitment.
        :type SafetyCommitment: str
        :param _ServiceStartDate: Service start date.
        :type ServiceStartDate: str
        :param _ServiceEndDate: Service end date.
        :type ServiceEndDate: str
        :param _State: Status. Valid values: `PENDING`, `APPROVED`, and `DENY`.
        :type State: str
        :param _CreatedTime: Creation time of the review form.
        :type CreatedTime: str
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._Company = None
        self._UniformSocialCreditCode = None
        self._LegalPerson = None
        self._IssuingAuthority = None
        self._BusinessLicense = None
        self._BusinessAddress = None
        self._PostCode = None
        self._Manager = None
        self._ManagerId = None
        self._ManagerIdCard = None
        self._ManagerAddress = None
        self._ManagerTelephone = None
        self._Email = None
        self._ServiceHandlingForm = None
        self._AuthorizationLetter = None
        self._SafetyCommitment = None
        self._ServiceStartDate = None
        self._ServiceEndDate = None
        self._State = None
        self._CreatedTime = None

    @property
    def ServiceProvider(self):
        r"""Service provider. Valid values: `UNICOM`.
        :rtype: str
        """
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        r"""ID of compliance review request.
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def Company(self):
        r"""Full company name.
        :rtype: str
        """
        return self._Company

    @Company.setter
    def Company(self, Company):
        self._Company = Company

    @property
    def UniformSocialCreditCode(self):
        r"""Unified Social Credit Code.
        :rtype: str
        """
        return self._UniformSocialCreditCode

    @UniformSocialCreditCode.setter
    def UniformSocialCreditCode(self, UniformSocialCreditCode):
        self._UniformSocialCreditCode = UniformSocialCreditCode

    @property
    def LegalPerson(self):
        r"""Legal person.
        :rtype: str
        """
        return self._LegalPerson

    @LegalPerson.setter
    def LegalPerson(self, LegalPerson):
        self._LegalPerson = LegalPerson

    @property
    def IssuingAuthority(self):
        r"""Issuing authority.
        :rtype: str
        """
        return self._IssuingAuthority

    @IssuingAuthority.setter
    def IssuingAuthority(self, IssuingAuthority):
        self._IssuingAuthority = IssuingAuthority

    @property
    def BusinessLicense(self):
        r"""Business license.
        :rtype: str
        """
        return self._BusinessLicense

    @BusinessLicense.setter
    def BusinessLicense(self, BusinessLicense):
        self._BusinessLicense = BusinessLicense

    @property
    def BusinessAddress(self):
        r"""Business address.
        :rtype: str
        """
        return self._BusinessAddress

    @BusinessAddress.setter
    def BusinessAddress(self, BusinessAddress):
        self._BusinessAddress = BusinessAddress

    @property
    def PostCode(self):
        r"""Zip code.
        :rtype: int
        """
        return self._PostCode

    @PostCode.setter
    def PostCode(self, PostCode):
        self._PostCode = PostCode

    @property
    def Manager(self):
        r"""Operator.
        :rtype: str
        """
        return self._Manager

    @Manager.setter
    def Manager(self, Manager):
        self._Manager = Manager

    @property
    def ManagerId(self):
        r"""Operator ID card number.
        :rtype: str
        """
        return self._ManagerId

    @ManagerId.setter
    def ManagerId(self, ManagerId):
        self._ManagerId = ManagerId

    @property
    def ManagerIdCard(self):
        r"""Operator ID card.
        :rtype: str
        """
        return self._ManagerIdCard

    @ManagerIdCard.setter
    def ManagerIdCard(self, ManagerIdCard):
        self._ManagerIdCard = ManagerIdCard

    @property
    def ManagerAddress(self):
        r"""Operator address.
        :rtype: str
        """
        return self._ManagerAddress

    @ManagerAddress.setter
    def ManagerAddress(self, ManagerAddress):
        self._ManagerAddress = ManagerAddress

    @property
    def ManagerTelephone(self):
        r"""Operator phone number.
        :rtype: str
        """
        return self._ManagerTelephone

    @ManagerTelephone.setter
    def ManagerTelephone(self, ManagerTelephone):
        self._ManagerTelephone = ManagerTelephone

    @property
    def Email(self):
        r"""Email.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ServiceHandlingForm(self):
        r"""Service handling form.
        :rtype: str
        """
        return self._ServiceHandlingForm

    @ServiceHandlingForm.setter
    def ServiceHandlingForm(self, ServiceHandlingForm):
        self._ServiceHandlingForm = ServiceHandlingForm

    @property
    def AuthorizationLetter(self):
        r"""Authorization letter.
        :rtype: str
        """
        return self._AuthorizationLetter

    @AuthorizationLetter.setter
    def AuthorizationLetter(self, AuthorizationLetter):
        self._AuthorizationLetter = AuthorizationLetter

    @property
    def SafetyCommitment(self):
        r"""Information security commitment.
        :rtype: str
        """
        return self._SafetyCommitment

    @SafetyCommitment.setter
    def SafetyCommitment(self, SafetyCommitment):
        self._SafetyCommitment = SafetyCommitment

    @property
    def ServiceStartDate(self):
        r"""Service start date.
        :rtype: str
        """
        return self._ServiceStartDate

    @ServiceStartDate.setter
    def ServiceStartDate(self, ServiceStartDate):
        self._ServiceStartDate = ServiceStartDate

    @property
    def ServiceEndDate(self):
        r"""Service end date.
        :rtype: str
        """
        return self._ServiceEndDate

    @ServiceEndDate.setter
    def ServiceEndDate(self, ServiceEndDate):
        self._ServiceEndDate = ServiceEndDate

    @property
    def State(self):
        r"""Status. Valid values: `PENDING`, `APPROVED`, and `DENY`.
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreatedTime(self):
        r"""Creation time of the review form.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._Company = params.get("Company")
        self._UniformSocialCreditCode = params.get("UniformSocialCreditCode")
        self._LegalPerson = params.get("LegalPerson")
        self._IssuingAuthority = params.get("IssuingAuthority")
        self._BusinessLicense = params.get("BusinessLicense")
        self._BusinessAddress = params.get("BusinessAddress")
        self._PostCode = params.get("PostCode")
        self._Manager = params.get("Manager")
        self._ManagerId = params.get("ManagerId")
        self._ManagerIdCard = params.get("ManagerIdCard")
        self._ManagerAddress = params.get("ManagerAddress")
        self._ManagerTelephone = params.get("ManagerTelephone")
        self._Email = params.get("Email")
        self._ServiceHandlingForm = params.get("ServiceHandlingForm")
        self._AuthorizationLetter = params.get("AuthorizationLetter")
        self._SafetyCommitment = params.get("SafetyCommitment")
        self._ServiceStartDate = params.get("ServiceStartDate")
        self._ServiceEndDate = params.get("ServiceEndDate")
        self._State = params.get("State")
        self._CreatedTime = params.get("CreatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomerGateway(AbstractModel):
    r"""Customer Gateway

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: The unique ID of the customer gateway
        :type CustomerGatewayId: str
        :param _CustomerGatewayName: Gateway Name
        :type CustomerGatewayName: str
        :param _IpAddress: Public network address
        :type IpAddress: str
        :param _CreatedTime: The creation time.
        :type CreatedTime: str
        """
        self._CustomerGatewayId = None
        self._CustomerGatewayName = None
        self._IpAddress = None
        self._CreatedTime = None

    @property
    def CustomerGatewayId(self):
        r"""The unique ID of the customer gateway
        :rtype: str
        """
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def CustomerGatewayName(self):
        r"""Gateway Name
        :rtype: str
        """
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName

    @property
    def IpAddress(self):
        r"""Public network address
        :rtype: str
        """
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def CreatedTime(self):
        r"""The creation time.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        self._IpAddress = params.get("IpAddress")
        self._CreatedTime = params.get("CreatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomerGatewayVendor(AbstractModel):
    r"""Customer gateway vendor information object.

    """

    def __init__(self):
        r"""
        :param _Platform: Platform.
        :type Platform: str
        :param _SoftwareVersion: Software version.
        :type SoftwareVersion: str
        :param _VendorName: Vendor name.
        :type VendorName: str
        """
        self._Platform = None
        self._SoftwareVersion = None
        self._VendorName = None

    @property
    def Platform(self):
        r"""Platform.
        :rtype: str
        """
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def SoftwareVersion(self):
        r"""Software version.
        :rtype: str
        """
        return self._SoftwareVersion

    @SoftwareVersion.setter
    def SoftwareVersion(self, SoftwareVersion):
        self._SoftwareVersion = SoftwareVersion

    @property
    def VendorName(self):
        r"""Vendor name.
        :rtype: str
        """
        return self._VendorName

    @VendorName.setter
    def VendorName(self, VendorName):
        self._VendorName = VendorName


    def _deserialize(self, params):
        self._Platform = params.get("Platform")
        self._SoftwareVersion = params.get("SoftwareVersion")
        self._VendorName = params.get("VendorName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CvmInstance(AbstractModel):
    r"""A CVM instance.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _SubnetId: Subnet instance ID.
        :type SubnetId: str
        :param _InstanceId: CVM instance ID.
        :type InstanceId: str
        :param _InstanceName: CVM Name
        :type InstanceName: str
        :param _InstanceState: CVM status.
        :type InstanceState: str
        :param _CPU: Number of CPU cores in an instance (in core).
        :type CPU: int
        :param _Memory: Instance’s memory capacity. Unit: GB.
        :type Memory: int
        :param _CreatedTime: The creation time.
        :type CreatedTime: str
        :param _InstanceType: Instance type.
        :type InstanceType: str
        :param _EniLimit: Instance ENI quota (including primary ENIs).
        :type EniLimit: int
        :param _EniIpLimit: Private IP quoata for instance ENIs (including primary ENIs).
        :type EniIpLimit: int
        :param _InstanceEniCount: The number of ENIs (including primary ENIs) bound to a instance.
        :type InstanceEniCount: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceState = None
        self._CPU = None
        self._Memory = None
        self._CreatedTime = None
        self._InstanceType = None
        self._EniLimit = None
        self._EniIpLimit = None
        self._InstanceEniCount = None

    @property
    def VpcId(self):
        r"""VPC instance ID.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet instance ID.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def InstanceId(self):
        r"""CVM instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""CVM Name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceState(self):
        r"""CVM status.
        :rtype: str
        """
        return self._InstanceState

    @InstanceState.setter
    def InstanceState(self, InstanceState):
        self._InstanceState = InstanceState

    @property
    def CPU(self):
        r"""Number of CPU cores in an instance (in core).
        :rtype: int
        """
        return self._CPU

    @CPU.setter
    def CPU(self, CPU):
        self._CPU = CPU

    @property
    def Memory(self):
        r"""Instance’s memory capacity. Unit: GB.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def CreatedTime(self):
        r"""The creation time.
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def InstanceType(self):
        r"""Instance type.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def EniLimit(self):
        r"""Instance ENI quota (including primary ENIs).
        :rtype: int
        """
        return self._EniLimit

    @EniLimit.setter
    def EniLimit(self, EniLimit):
        self._EniLimit = EniLimit

    @property
    def EniIpLimit(self):
        r"""Private IP quoata for instance ENIs (including primary ENIs).
        :rtype: int
        """
        return self._EniIpLimit

    @EniIpLimit.setter
    def EniIpLimit(self, EniIpLimit):
        self._EniIpLimit = EniIpLimit

    @property
    def InstanceEniCount(self):
        r"""The number of ENIs (including primary ENIs) bound to a instance.
        :rtype: int
        """
        return self._InstanceEniCount

    @InstanceEniCount.setter
    def InstanceEniCount(self, InstanceEniCount):
        self._InstanceEniCount = InstanceEniCount


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceState = params.get("InstanceState")
        self._CPU = params.get("CPU")
        self._Memory = params.get("Memory")
        self._CreatedTime = params.get("CreatedTime")
        self._InstanceType = params.get("InstanceType")
        self._EniLimit = params.get("EniLimit")
        self._EniIpLimit = params.get("EniIpLimit")
        self._InstanceEniCount = params.get("InstanceEniCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultVpcSubnet(AbstractModel):
    r"""Default VPC and subnet

    """

    def __init__(self):
        r"""
        :param _VpcId: Default VPC ID
        :type VpcId: str
        :param _SubnetId: Default subnet ID
        :type SubnetId: str
        :param _VpcName: Default VPC name
        :type VpcName: str
        :param _SubnetName: Default subnet name
        :type SubnetName: str
        :param _CidrBlock: Default subnet IP range
        :type CidrBlock: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._VpcName = None
        self._SubnetName = None
        self._CidrBlock = None

    @property
    def VpcId(self):
        r"""Default VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Default subnet ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcName(self):
        r"""Default VPC name
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def SubnetName(self):
        r"""Default subnet name
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def CidrBlock(self):
        r"""Default subnet IP range
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._VpcName = params.get("VpcName")
        self._SubnetName = params.get("SubnetName")
        self._CidrBlock = params.get("CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateGroupRequest(AbstractModel):
    r"""DeleteAddressTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupId: The IP address template group instance ID, such as `ipmg-90cex8mq`.
        :type AddressTemplateGroupId: str
        """
        self._AddressTemplateGroupId = None

    @property
    def AddressTemplateGroupId(self):
        r"""The IP address template group instance ID, such as `ipmg-90cex8mq`.
        :rtype: str
        """
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId


    def _deserialize(self, params):
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateGroupResponse(AbstractModel):
    r"""DeleteAddressTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAddressTemplateRequest(AbstractModel):
    r"""DeleteAddressTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: The IP address template instance ID, such as `ipm-09o5m8kc`.
        :type AddressTemplateId: str
        """
        self._AddressTemplateId = None

    @property
    def AddressTemplateId(self):
        r"""The IP address template instance ID, such as `ipm-09o5m8kc`.
        :rtype: str
        """
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateResponse(AbstractModel):
    r"""DeleteAddressTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAssistantCidrRequest(AbstractModel):
    r"""DeleteAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :type VpcId: str
        :param _CidrBlocks: Array of CIDR blocks, such as ["10.0.0.0/16", "172.16.0.0/16"]
        :type CidrBlocks: list of str
        """
        self._VpcId = None
        self._CidrBlocks = None

    @property
    def VpcId(self):
        r"""`VPC` instance `ID`, such as `vpc-6v2ht8q5`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlocks(self):
        r"""Array of CIDR blocks, such as ["10.0.0.0/16", "172.16.0.0/16"]
        :rtype: list of str
        """
        return self._CidrBlocks

    @CidrBlocks.setter
    def CidrBlocks(self, CidrBlocks):
        self._CidrBlocks = CidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlocks = params.get("CidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAssistantCidrResponse(AbstractModel):
    r"""DeleteAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBandwidthPackageRequest(AbstractModel):
    r"""DeleteBandwidthPackage request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: The unique ID of the bandwidth package to be deleted.
        :type BandwidthPackageId: str
        """
        self._BandwidthPackageId = None

    @property
    def BandwidthPackageId(self):
        r"""The unique ID of the bandwidth package to be deleted.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBandwidthPackageResponse(AbstractModel):
    r"""DeleteBandwidthPackage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCcnRequest(AbstractModel):
    r"""DeleteCcn request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCcnResponse(AbstractModel):
    r"""DeleteCcn response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCustomerGatewayRequest(AbstractModel):
    r"""DeleteCustomerGateway request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/api/215/17516?from_cn_redirect=1) API.
        :type CustomerGatewayId: str
        """
        self._CustomerGatewayId = None

    @property
    def CustomerGatewayId(self):
        r"""The ID of the customer gateway, such as `cgw-2wqq41m9`. You can query the customer gateway by using the [DescribeCustomerGateways](https://intl.cloud.tencent.com/document/api/215/17516?from_cn_redirect=1) API.
        :rtype: str
        """
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomerGatewayResponse(AbstractModel):
    r"""DeleteCustomerGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    r"""DeleteDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :type DirectConnectGatewayId: str
        :param _RouteIds: The route ID, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        """
        self._DirectConnectGatewayId = None
        self._RouteIds = None

    @property
    def DirectConnectGatewayId(self):
        r"""The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def RouteIds(self):
        r"""The route ID, such as `ccnr-f49l6u0z`.
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    r"""DeleteDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDirectConnectGatewayRequest(AbstractModel):
    r"""DeleteDirectConnectGateway request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The unique `ID` of the direct connect gateway, such as `dcg-9o233uri`.
        :type DirectConnectGatewayId: str
        """
        self._DirectConnectGatewayId = None

    @property
    def DirectConnectGatewayId(self):
        r"""The unique `ID` of the direct connect gateway, such as `dcg-9o233uri`.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDirectConnectGatewayResponse(AbstractModel):
    r"""DeleteDirectConnectGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFlowLogRequest(AbstractModel):
    r"""DeleteFlowLog request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        :param _VpcId: The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless a CCN flow log is deleted.
        :type VpcId: str
        """
        self._FlowLogId = None
        self._VpcId = None

    @property
    def FlowLogId(self):
        r"""The unique ID of the flow log.
        :rtype: str
        """
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def VpcId(self):
        r"""The VPC ID or unique ID of the resource. We recommend using the unique ID. This parameter is required unless a CCN flow log is deleted.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._FlowLogId = params.get("FlowLogId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFlowLogResponse(AbstractModel):
    r"""DeleteFlowLog response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHaVipRequest(AbstractModel):
    r"""DeleteHaVip request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipId: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :type HaVipId: str
        """
        self._HaVipId = None

    @property
    def HaVipId(self):
        r"""The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :rtype: str
        """
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHaVipResponse(AbstractModel):
    r"""DeleteHaVip response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLocalGatewayRequest(AbstractModel):
    r"""DeleteLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewayId: Local gateway instance ID
        :type LocalGatewayId: str
        :param _CdcId: CDC instance ID
        :type CdcId: str
        :param _VpcId: VPC instance ID
        :type VpcId: str
        """
        self._LocalGatewayId = None
        self._CdcId = None
        self._VpcId = None

    @property
    def LocalGatewayId(self):
        r"""Local gateway instance ID
        :rtype: str
        """
        return self._LocalGatewayId

    @LocalGatewayId.setter
    def LocalGatewayId(self, LocalGatewayId):
        self._LocalGatewayId = LocalGatewayId

    @property
    def CdcId(self):
        r"""CDC instance ID
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def VpcId(self):
        r"""VPC instance ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._LocalGatewayId = params.get("LocalGatewayId")
        self._CdcId = params.get("CdcId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLocalGatewayResponse(AbstractModel):
    r"""DeleteLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    r"""DeleteNatGatewayDestinationIpPortTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _DestinationIpPortTranslationNatRules: The port forwarding rules of the NAT gateway.
        :type DestinationIpPortTranslationNatRules: list of DestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._DestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT gateway, such as `nat-df45454`.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DestinationIpPortTranslationNatRules(self):
        r"""The port forwarding rules of the NAT gateway.
        :rtype: list of DestinationIpPortTranslationNatRule
        """
        return self._DestinationIpPortTranslationNatRules

    @DestinationIpPortTranslationNatRules.setter
    def DestinationIpPortTranslationNatRules(self, DestinationIpPortTranslationNatRules):
        self._DestinationIpPortTranslationNatRules = DestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("DestinationIpPortTranslationNatRules") is not None:
            self._DestinationIpPortTranslationNatRules = []
            for item in params.get("DestinationIpPortTranslationNatRules"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    r"""DeleteNatGatewayDestinationIpPortTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewayRequest(AbstractModel):
    r"""DeleteNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        """
        self._NatGatewayId = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT gateway, such as `nat-df45454`.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayResponse(AbstractModel):
    r"""DeleteNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    r"""DeleteNatGatewaySourceIpTranslationNatRule request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT Gateway, such as `nat-df45454`
        :type NatGatewayId: str
        :param _NatGatewaySnatIds: The list of SNAT rule IDs of a NAT Gateway, such as `snat-df43254`
        :type NatGatewaySnatIds: list of str
        """
        self._NatGatewayId = None
        self._NatGatewaySnatIds = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT Gateway, such as `nat-df45454`
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def NatGatewaySnatIds(self):
        r"""The list of SNAT rule IDs of a NAT Gateway, such as `snat-df43254`
        :rtype: list of str
        """
        return self._NatGatewaySnatIds

    @NatGatewaySnatIds.setter
    def NatGatewaySnatIds(self, NatGatewaySnatIds):
        self._NatGatewaySnatIds = NatGatewaySnatIds


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._NatGatewaySnatIds = params.get("NatGatewaySnatIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    r"""DeleteNatGatewaySourceIpTranslationNatRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetDetectRequest(AbstractModel):
    r"""DeleteNetDetect request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectId: ID of a network probe, such as `netd-12345678`.
        :type NetDetectId: str
        """
        self._NetDetectId = None

    @property
    def NetDetectId(self):
        r"""ID of a network probe, such as `netd-12345678`.
        :rtype: str
        """
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId


    def _deserialize(self, params):
        self._NetDetectId = params.get("NetDetectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetDetectResponse(AbstractModel):
    r"""DeleteNetDetect response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclQuintupleEntriesRequest(AbstractModel):
    r"""DeleteNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: Network ACL quintuple rule set.
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        r"""Network ACL instance ID, such as `acl-12345678`.
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        r"""Network ACL quintuple rule set.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclQuintupleEntriesResponse(AbstractModel):
    r"""DeleteNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclRequest(AbstractModel):
    r"""DeleteNetworkAcl request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        """
        self._NetworkAclId = None

    @property
    def NetworkAclId(self):
        r"""Network ACL instance ID, such as `acl-12345678`.
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclResponse(AbstractModel):
    r"""DeleteNetworkAcl response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkInterfaceRequest(AbstractModel):
    r"""DeleteNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        """
        self._NetworkInterfaceId = None

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the ENI instance, such as `eni-m6dyj72l`.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkInterfaceResponse(AbstractModel):
    r"""DeleteNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReserveIpAddressesRequest(AbstractModel):
    r"""DeleteReserveIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: Unique ID of the VPC.
        :type VpcId: str
        :param _ReserveIpIds: List of reserved private IP addresses.
        :type ReserveIpIds: list of str
        """
        self._VpcId = None
        self._ReserveIpIds = None

    @property
    def VpcId(self):
        r"""Unique ID of the VPC.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ReserveIpIds(self):
        r"""List of reserved private IP addresses.
        :rtype: list of str
        """
        return self._ReserveIpIds

    @ReserveIpIds.setter
    def ReserveIpIds(self, ReserveIpIds):
        self._ReserveIpIds = ReserveIpIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._ReserveIpIds = params.get("ReserveIpIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReserveIpAddressesResponse(AbstractModel):
    r"""DeleteReserveIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoutePolicyAssociationsRequest(AbstractModel):
    r"""DeleteRoutePolicyAssociations request structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyAssociationSet: Routing policy binding object list. during routing policy unbinding, use the RouteTableId and RoutePolicyId fields of RoutePolicyAssociation (you do not need to fill in the Priority field).
        :type RoutePolicyAssociationSet: list of RoutePolicyAssociation
        """
        self._RoutePolicyAssociationSet = None

    @property
    def RoutePolicyAssociationSet(self):
        r"""Routing policy binding object list. during routing policy unbinding, use the RouteTableId and RoutePolicyId fields of RoutePolicyAssociation (you do not need to fill in the Priority field).
        :rtype: list of RoutePolicyAssociation
        """
        return self._RoutePolicyAssociationSet

    @RoutePolicyAssociationSet.setter
    def RoutePolicyAssociationSet(self, RoutePolicyAssociationSet):
        self._RoutePolicyAssociationSet = RoutePolicyAssociationSet


    def _deserialize(self, params):
        if params.get("RoutePolicyAssociationSet") is not None:
            self._RoutePolicyAssociationSet = []
            for item in params.get("RoutePolicyAssociationSet"):
                obj = RoutePolicyAssociation()
                obj._deserialize(item)
                self._RoutePolicyAssociationSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutePolicyAssociationsResponse(AbstractModel):
    r"""DeleteRoutePolicyAssociations response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoutePolicyEntriesRequest(AbstractModel):
    r"""DeleteRoutePolicyEntries request structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyId: Specifies the instance ID of the route reception policy.
        :type RoutePolicyId: str
        :param _RoutePolicyEntrySet: Route reception policy entry list. when deleting a routing policy rule, use the routepolicyentryid field of RoutePolicyEntry.
        :type RoutePolicyEntrySet: list of RoutePolicyEntry
        """
        self._RoutePolicyId = None
        self._RoutePolicyEntrySet = None

    @property
    def RoutePolicyId(self):
        r"""Specifies the instance ID of the route reception policy.
        :rtype: str
        """
        return self._RoutePolicyId

    @RoutePolicyId.setter
    def RoutePolicyId(self, RoutePolicyId):
        self._RoutePolicyId = RoutePolicyId

    @property
    def RoutePolicyEntrySet(self):
        r"""Route reception policy entry list. when deleting a routing policy rule, use the routepolicyentryid field of RoutePolicyEntry.
        :rtype: list of RoutePolicyEntry
        """
        return self._RoutePolicyEntrySet

    @RoutePolicyEntrySet.setter
    def RoutePolicyEntrySet(self, RoutePolicyEntrySet):
        self._RoutePolicyEntrySet = RoutePolicyEntrySet


    def _deserialize(self, params):
        self._RoutePolicyId = params.get("RoutePolicyId")
        if params.get("RoutePolicyEntrySet") is not None:
            self._RoutePolicyEntrySet = []
            for item in params.get("RoutePolicyEntrySet"):
                obj = RoutePolicyEntry()
                obj._deserialize(item)
                self._RoutePolicyEntrySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutePolicyEntriesResponse(AbstractModel):
    r"""DeleteRoutePolicyEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoutePolicyRequest(AbstractModel):
    r"""DeleteRoutePolicy request structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyId: Specifies the unique ID of the route reception policy.
        :type RoutePolicyId: str
        """
        self._RoutePolicyId = None

    @property
    def RoutePolicyId(self):
        r"""Specifies the unique ID of the route reception policy.
        :rtype: str
        """
        return self._RoutePolicyId

    @RoutePolicyId.setter
    def RoutePolicyId(self, RoutePolicyId):
        self._RoutePolicyId = RoutePolicyId


    def _deserialize(self, params):
        self._RoutePolicyId = params.get("RoutePolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutePolicyResponse(AbstractModel):
    r"""DeleteRoutePolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRouteTableRequest(AbstractModel):
    r"""DeleteRouteTable request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableId: str
        """
        self._RouteTableId = None

    @property
    def RouteTableId(self):
        r"""The route table instance ID, such as `rtb-azd4dt1c`.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRouteTableResponse(AbstractModel):
    r"""DeleteRouteTable response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoutesRequest(AbstractModel):
    r"""DeleteRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: Route table instance ID.
        :type RouteTableId: str
        :param _Routes: Routing policy object. Only the `RouteId` field is required when deleting a routing policy.
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        r"""Route table instance ID.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        r"""Routing policy object. Only the `RouteId` field is required when deleting a routing policy.
        :rtype: list of Route
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutesResponse(AbstractModel):
    r"""DeleteRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RouteSet: Details of the routing policy that has been deleted.
        :type RouteSet: list of Route
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RouteSet = None
        self._RequestId = None

    @property
    def RouteSet(self):
        r"""Details of the routing policy that has been deleted.
        :rtype: list of Route
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = Route()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteSecurityGroupPoliciesRequest(AbstractModel):
    r"""DeleteSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: The policy set of the security group. One request can only delete one or more policies in one direction. Both PolicyIndex-matching deletion and security group policy-matching deletion methods are supported. Each request can use only one matching method.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        r"""The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        r"""The policy set of the security group. One request can only delete one or more policies in one direction. Both PolicyIndex-matching deletion and security group policy-matching deletion methods are supported. Each request can use only one matching method.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityGroupPoliciesResponse(AbstractModel):
    r"""DeleteSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSecurityGroupRequest(AbstractModel):
    r"""DeleteSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        """
        self._SecurityGroupId = None

    @property
    def SecurityGroupId(self):
        r"""The security group instance ID, such as `sg-33ocnj9n`. This can be obtained through DescribeSecurityGroups.
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityGroupResponse(AbstractModel):
    r"""DeleteSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteServiceTemplateGroupRequest(AbstractModel):
    r"""DeleteServiceTemplateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupId: The protocol port template group instance ID, such as `ppmg-n17uxvve`.
        :type ServiceTemplateGroupId: str
        """
        self._ServiceTemplateGroupId = None

    @property
    def ServiceTemplateGroupId(self):
        r"""The protocol port template group instance ID, such as `ppmg-n17uxvve`.
        :rtype: str
        """
        return self._ServiceTemplateGroupId

    @ServiceTemplateGroupId.setter
    def ServiceTemplateGroupId(self, ServiceTemplateGroupId):
        self._ServiceTemplateGroupId = ServiceTemplateGroupId


    def _deserialize(self, params):
        self._ServiceTemplateGroupId = params.get("ServiceTemplateGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServiceTemplateGroupResponse(AbstractModel):
    r"""DeleteServiceTemplateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteServiceTemplateRequest(AbstractModel):
    r"""DeleteServiceTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateId: Protocol port template instance ID, such as `ppm-e6dy460g`.
        :type ServiceTemplateId: str
        """
        self._ServiceTemplateId = None

    @property
    def ServiceTemplateId(self):
        r"""Protocol port template instance ID, such as `ppm-e6dy460g`.
        :rtype: str
        """
        return self._ServiceTemplateId

    @ServiceTemplateId.setter
    def ServiceTemplateId(self, ServiceTemplateId):
        self._ServiceTemplateId = ServiceTemplateId


    def _deserialize(self, params):
        self._ServiceTemplateId = params.get("ServiceTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServiceTemplateResponse(AbstractModel):
    r"""DeleteServiceTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotPoliciesRequest(AbstractModel):
    r"""DeleteSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        """
        self._SnapshotPolicyIds = None

    @property
    def SnapshotPolicyIds(self):
        r"""Snapshot policy IDs
        :rtype: list of str
        """
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotPoliciesResponse(AbstractModel):
    r"""DeleteSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSubnetRequest(AbstractModel):
    r"""DeleteSubnet request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetId: The ID of the subnet instance. You can obtain the parameter value from the SubnetId field in the returned result of DescribeSubnets API.
        :type SubnetId: str
        """
        self._SubnetId = None

    @property
    def SubnetId(self):
        r"""The ID of the subnet instance. You can obtain the parameter value from the SubnetId field in the returned result of DescribeSubnets API.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSubnetResponse(AbstractModel):
    r"""DeleteSubnet response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTemplateMemberRequest(AbstractModel):
    r"""DeleteTemplateMember request structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Parameter template instance ID, which can be the instance ID of a parameter template of the following four types: IP address, protocol port, IP address group, and protocol port group.
        :type TemplateId: str
        :param _TemplateMember: Information on the parameter template to be added. The template can be of the following four types: IP address, protocol port, IP address group, and protocol port group. The type should be consistent with that of the template specified by the TemplateId parameter.
        :type TemplateMember: list of MemberInfo
        """
        self._TemplateId = None
        self._TemplateMember = None

    @property
    def TemplateId(self):
        r"""Parameter template instance ID, which can be the instance ID of a parameter template of the following four types: IP address, protocol port, IP address group, and protocol port group.
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateMember(self):
        r"""Information on the parameter template to be added. The template can be of the following four types: IP address, protocol port, IP address group, and protocol port group. The type should be consistent with that of the template specified by the TemplateId parameter.
        :rtype: list of MemberInfo
        """
        return self._TemplateMember

    @TemplateMember.setter
    def TemplateMember(self, TemplateMember):
        self._TemplateMember = TemplateMember


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("TemplateMember") is not None:
            self._TemplateMember = []
            for item in params.get("TemplateMember"):
                obj = MemberInfo()
                obj._deserialize(item)
                self._TemplateMember.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTemplateMemberResponse(AbstractModel):
    r"""DeleteTemplateMember response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrafficPackagesRequest(AbstractModel):
    r"""DeleteTrafficPackages request structure.

    """

    def __init__(self):
        r"""
        :param _TrafficPackageIds: The unique ID array of traffic packages to delete
        :type TrafficPackageIds: list of str
        """
        self._TrafficPackageIds = None

    @property
    def TrafficPackageIds(self):
        r"""The unique ID array of traffic packages to delete
        :rtype: list of str
        """
        return self._TrafficPackageIds

    @TrafficPackageIds.setter
    def TrafficPackageIds(self, TrafficPackageIds):
        self._TrafficPackageIds = TrafficPackageIds


    def _deserialize(self, params):
        self._TrafficPackageIds = params.get("TrafficPackageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrafficPackagesResponse(AbstractModel):
    r"""DeleteTrafficPackages response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointRequest(AbstractModel):
    r"""DeleteVpcEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointId: Endpoint ID
        :type EndPointId: str
        """
        self._EndPointId = None

    @property
    def EndPointId(self):
        r"""Endpoint ID
        :rtype: str
        """
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointResponse(AbstractModel):
    r"""DeleteVpcEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointServiceRequest(AbstractModel):
    r"""DeleteVpcEndPointService request structure.

    """

    def __init__(self):
        r"""
        :param _EndPointServiceId: Endpoint ID
        :type EndPointServiceId: str
        """
        self._EndPointServiceId = None

    @property
    def EndPointServiceId(self):
        r"""Endpoint ID
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId


    def _deserialize(self, params):
        self._EndPointServiceId = params.get("EndPointServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointServiceResponse(AbstractModel):
    r"""DeleteVpcEndPointService response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointServiceWhiteListRequest(AbstractModel):
    r"""DeleteVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _UserUin: Array of user UINs
        :type UserUin: list of str
        :param _EndPointServiceId: Endpoint service ID
        :type EndPointServiceId: str
        """
        self._UserUin = None
        self._EndPointServiceId = None

    @property
    def UserUin(self):
        r"""Array of user UINs
        :rtype: list of str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        r"""Endpoint service ID
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointServiceWhiteListResponse(AbstractModel):
    r"""DeleteVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcRequest(AbstractModel):
    r"""DeleteVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        r"""The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcResponse(AbstractModel):
    r"""DeleteVpc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnConnectionRequest(AbstractModel):
    r"""DeleteVpnConnection request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _VpnConnectionId: The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :type VpnConnectionId: str
        """
        self._VpnGatewayId = None
        self._VpnConnectionId = None

    @property
    def VpnGatewayId(self):
        r"""The ID of the VPN gateway instance.
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnConnectionId(self):
        r"""The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :rtype: str
        """
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnConnectionId = params.get("VpnConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnConnectionResponse(AbstractModel):
    r"""DeleteVpnConnection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewayRequest(AbstractModel):
    r"""DeleteVpnGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        """
        self._VpnGatewayId = None

    @property
    def VpnGatewayId(self):
        r"""The ID of the VPN gateway instance.
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayResponse(AbstractModel):
    r"""DeleteVpnGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewayRoutesRequest(AbstractModel):
    r"""DeleteVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _RouteIds: List of route IDs
        :type RouteIds: list of str
        """
        self._VpnGatewayId = None
        self._RouteIds = None

    @property
    def VpnGatewayId(self):
        r"""Instance ID of the VPN gateway
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def RouteIds(self):
        r"""List of route IDs
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayRoutesResponse(AbstractModel):
    r"""DeleteVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAccountAttributesRequest(AbstractModel):
    r"""DescribeAccountAttributes request structure.

    """


class DescribeAccountAttributesResponse(AbstractModel):
    r"""DescribeAccountAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _AccountAttributeSet: User account attribute object
        :type AccountAttributeSet: list of AccountAttribute
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AccountAttributeSet = None
        self._RequestId = None

    @property
    def AccountAttributeSet(self):
        r"""User account attribute object
        :rtype: list of AccountAttribute
        """
        return self._AccountAttributeSet

    @AccountAttributeSet.setter
    def AccountAttributeSet(self, AccountAttributeSet):
        self._AccountAttributeSet = AccountAttributeSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AccountAttributeSet") is not None:
            self._AccountAttributeSet = []
            for item in params.get("AccountAttributeSet"):
                obj = AccountAttribute()
                obj._deserialize(item)
                self._AccountAttributeSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressQuotaRequest(AbstractModel):
    r"""DescribeAddressQuota request structure.

    """


class DescribeAddressQuotaResponse(AbstractModel):
    r"""DescribeAddressQuota response structure.

    """

    def __init__(self):
        r"""
        :param _QuotaSet: The quota information of EIPs in an account.
        :type QuotaSet: list of Quota
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        r"""The quota information of EIPs in an account.
        :rtype: list of Quota
        """
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressTemplateGroupsRequest(AbstractModel):
    r"""DescribeAddressTemplateGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions.
<li>address-template-group-name - String - (Filter condition) IP address template group name.</li>
<li>address-template-group-id - String - (Filter condition) IP address template group instance ID, such as `ipmg-mdunqeb6`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filter conditions.
<li>address-template-group-name - String - (Filter condition) IP address template group name.</li>
<li>address-template-group-id - String - (Filter condition) IP address template group instance ID, such as `ipmg-mdunqeb6`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. The default value is 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of values to be returned. The default value is 20. Maximum is 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressTemplateGroupsResponse(AbstractModel):
    r"""DescribeAddressTemplateGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _AddressTemplateGroupSet: IP address template.
        :type AddressTemplateGroupSet: list of AddressTemplateGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressTemplateGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressTemplateGroupSet(self):
        r"""IP address template.
        :rtype: list of AddressTemplateGroup
        """
        return self._AddressTemplateGroupSet

    @AddressTemplateGroupSet.setter
    def AddressTemplateGroupSet(self, AddressTemplateGroupSet):
        self._AddressTemplateGroupSet = AddressTemplateGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressTemplateGroupSet") is not None:
            self._AddressTemplateGroupSet = []
            for item in params.get("AddressTemplateGroupSet"):
                obj = AddressTemplateGroup()
                obj._deserialize(item)
                self._AddressTemplateGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressTemplatesRequest(AbstractModel):
    r"""DescribeAddressTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters
<li>address-template-name - IP address template name.</li>
<li>address-template-id - IP address template ID, such as `ipm-mdunqeb6`.</li>
<li>address-ip - IP address.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filters
<li>address-template-name - IP address template name.</li>
<li>address-template-id - IP address template ID, such as `ipm-mdunqeb6`.</li>
<li>address-ip - IP address.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. The default value is 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of values to be returned. The default value is 20. Maximum is 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressTemplatesResponse(AbstractModel):
    r"""DescribeAddressTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _AddressTemplateSet: IP address template.
        :type AddressTemplateSet: list of AddressTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressTemplateSet(self):
        r"""IP address template.
        :rtype: list of AddressTemplate
        """
        return self._AddressTemplateSet

    @AddressTemplateSet.setter
    def AddressTemplateSet(self, AddressTemplateSet):
        self._AddressTemplateSet = AddressTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressTemplateSet") is not None:
            self._AddressTemplateSet = []
            for item in params.get("AddressTemplateSet"):
                obj = AddressTemplate()
                obj._deserialize(item)
                self._AddressTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressesRequest(AbstractModel):
    r"""DescribeAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _AddressIds: The list of unique IDs of EIPs in the format of `eip-11112222`. `AddressIds` and `Filters.address-id` cannot be specified at the same time.
        :type AddressIds: list of str
        :param _Filters: Each request can have up to 10 `Filters` and 100 `Filter.Values`. Detailed filter conditions:
<li> address-id - String - Optional - Filter by unique EIP ID, such as `eip-11112222`.</li>
<li> address-name - String - Optional - Filter by EIP name. Fuzzy filtering is not supported.</li>
<li> address-ip - String - Optional - Filter by EIP address.</li>
<li> address-status - String - Optional - Filter by EIP status. Valid values: `CREATING`, `BINDING`, `BIND`, `UNBINDING`, `UNBIND`, `OFFLINING`, and `BIND_ENI`.</li>
<li> instance-id - String - Optional - Filter by the ID of the instance bound to the EIP, such as `ins-11112222`.</li>
<li> private-ip-address - String - Optional - Filter by the private IP address bound to the EIP.</li>
<li> network-interface-id - String - Optional - Filter by ID of the ENI bound to the EIP, such as `eni-11112222`.</li>
<li> is-arrears - String - Optional - Filter by the fact whether the EIP is overdue (TRUE: the EIP is overdue | FALSE: the billing status of the EIP is normal).</li>
<li> address-type - String - Optional - Filter by IP type. Valid values: `WanIP`, `EIP`, `AnycastEIP`, and `HighQualityEIP`. Default value: `EIP`.</li>
<li> address-isp - String - Optional - Filter by ISP type. Valid values: `BGP`, `CMCC`, `CUCC`, and `CTCC`.</li>
<li> dedicated-cluster-id - String - Optional - Filter by unique CDC ID, such as `cluster-11112222`.</li>
<li> tag-key - String - Optional - Filter by tag key.</li>
<li> tag-value - String - Optional - Filter by tag value.</li>
<li> tag:tag-key - String - Optional - Filter by tag key-value pair. Use a specific tag key to replace `tag-key`.</li>
        :type Filters: list of Filter
        :param _Offset: The Offset. The default value is 0. For more information on Offset, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100. For more information on Limit, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Limit: int
        """
        self._AddressIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def AddressIds(self):
        r"""The list of unique IDs of EIPs in the format of `eip-11112222`. `AddressIds` and `Filters.address-id` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._AddressIds

    @AddressIds.setter
    def AddressIds(self, AddressIds):
        self._AddressIds = AddressIds

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters` and 100 `Filter.Values`. Detailed filter conditions:
<li> address-id - String - Optional - Filter by unique EIP ID, such as `eip-11112222`.</li>
<li> address-name - String - Optional - Filter by EIP name. Fuzzy filtering is not supported.</li>
<li> address-ip - String - Optional - Filter by EIP address.</li>
<li> address-status - String - Optional - Filter by EIP status. Valid values: `CREATING`, `BINDING`, `BIND`, `UNBINDING`, `UNBIND`, `OFFLINING`, and `BIND_ENI`.</li>
<li> instance-id - String - Optional - Filter by the ID of the instance bound to the EIP, such as `ins-11112222`.</li>
<li> private-ip-address - String - Optional - Filter by the private IP address bound to the EIP.</li>
<li> network-interface-id - String - Optional - Filter by ID of the ENI bound to the EIP, such as `eni-11112222`.</li>
<li> is-arrears - String - Optional - Filter by the fact whether the EIP is overdue (TRUE: the EIP is overdue | FALSE: the billing status of the EIP is normal).</li>
<li> address-type - String - Optional - Filter by IP type. Valid values: `WanIP`, `EIP`, `AnycastEIP`, and `HighQualityEIP`. Default value: `EIP`.</li>
<li> address-isp - String - Optional - Filter by ISP type. Valid values: `BGP`, `CMCC`, `CUCC`, and `CTCC`.</li>
<li> dedicated-cluster-id - String - Optional - Filter by unique CDC ID, such as `cluster-11112222`.</li>
<li> tag-key - String - Optional - Filter by tag key.</li>
<li> tag-value - String - Optional - Filter by tag value.</li>
<li> tag:tag-key - String - Optional - Filter by tag key-value pair. Use a specific tag key to replace `tag-key`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The Offset. The default value is 0. For more information on Offset, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100. For more information on Limit, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._AddressIds = params.get("AddressIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressesResponse(AbstractModel):
    r"""DescribeAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of EIPs meeting the condition.
        :type TotalCount: int
        :param _AddressSet: List of EIPs details.
        :type AddressSet: list of Address
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of EIPs meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressSet(self):
        r"""List of EIPs details.
        :rtype: list of Address
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressSet") is not None:
            self._AddressSet = []
            for item in params.get("AddressSet"):
                obj = Address()
                obj._deserialize(item)
                self._AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssistantCidrRequest(AbstractModel):
    r"""DescribeAssistantCidr request structure.

    """

    def __init__(self):
        r"""
        :param _VpcIds: The ID of a VPC instance set, such as `vpc-6v2ht8q5`.
        :type VpcIds: list of str
        :param _Filters: Filter condition. `VpcIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._VpcIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcIds(self):
        r"""The ID of a VPC instance set, such as `vpc-6v2ht8q5`.
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def Filters(self):
        r"""Filter condition. `VpcIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssistantCidrResponse(AbstractModel):
    r"""DescribeAssistantCidr response structure.

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: A set of eligible secondary CIDR blocks
Note: This field may return null, indicating that no valid value was found.
        :type AssistantCidrSet: list of AssistantCidr
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        r"""A set of eligible secondary CIDR blocks
Note: This field may return null, indicating that no valid value was found.
        :rtype: list of AssistantCidr
        """
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageBillUsageRequest(AbstractModel):
    r"""DescribeBandwidthPackageBillUsage request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: Unique ID of the pay-as-you-go bandwidth package.
        :type BandwidthPackageId: str
        """
        self._BandwidthPackageId = None

    @property
    def BandwidthPackageId(self):
        r"""Unique ID of the pay-as-you-go bandwidth package.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackageBillUsageResponse(AbstractModel):
    r"""DescribeBandwidthPackageBillUsage response structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageBillBandwidthSet: Current billable usage.
        :type BandwidthPackageBillBandwidthSet: list of BandwidthPackageBillBandwidth
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BandwidthPackageBillBandwidthSet = None
        self._RequestId = None

    @property
    def BandwidthPackageBillBandwidthSet(self):
        r"""Current billable usage.
        :rtype: list of BandwidthPackageBillBandwidth
        """
        return self._BandwidthPackageBillBandwidthSet

    @BandwidthPackageBillBandwidthSet.setter
    def BandwidthPackageBillBandwidthSet(self, BandwidthPackageBillBandwidthSet):
        self._BandwidthPackageBillBandwidthSet = BandwidthPackageBillBandwidthSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BandwidthPackageBillBandwidthSet") is not None:
            self._BandwidthPackageBillBandwidthSet = []
            for item in params.get("BandwidthPackageBillBandwidthSet"):
                obj = BandwidthPackageBillBandwidth()
                obj._deserialize(item)
                self._BandwidthPackageBillBandwidthSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageQuotaRequest(AbstractModel):
    r"""DescribeBandwidthPackageQuota request structure.

    """


class DescribeBandwidthPackageQuotaResponse(AbstractModel):
    r"""DescribeBandwidthPackageQuota response structure.

    """

    def __init__(self):
        r"""
        :param _QuotaSet: The quota of the bandwidth package.
        :type QuotaSet: list of Quota
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        r"""The quota of the bandwidth package.
        :rtype: list of Quota
        """
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageResourcesRequest(AbstractModel):
    r"""DescribeBandwidthPackageResources request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: Unique ID of the bandwidth package in the form of `bwp-11112222`.
        :type BandwidthPackageId: str
        :param _Filters: Each request can have up to 10 `Filters` and 5 `Filter.Values`. The specific filter conditions are as follows:
<li>resource-id - String - Required: no - (Filter condition) Filters by the unique ID of resources in a bandwidth package, such as `eip-11112222`.</li>
<li>resource-type - String - Required: no - (Filter condition) Filters by the type of resources in a bandwidth package. It now supports only EIP (`Address`) and load balancer (`LoadBalance`).</li>
        :type Filters: list of Filter
        :param _Offset: The offset. Default value: 0. For more information on `Offset`, see the relevant sections in API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Offset: int
        :param _Limit: The number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant sections in API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Limit: int
        """
        self._BandwidthPackageId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def BandwidthPackageId(self):
        r"""Unique ID of the bandwidth package in the form of `bwp-11112222`.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters` and 5 `Filter.Values`. The specific filter conditions are as follows:
<li>resource-id - String - Required: no - (Filter condition) Filters by the unique ID of resources in a bandwidth package, such as `eip-11112222`.</li>
<li>resource-type - String - Required: no - (Filter condition) Filters by the type of resources in a bandwidth package. It now supports only EIP (`Address`) and load balancer (`LoadBalance`).</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The offset. Default value: 0. For more information on `Offset`, see the relevant sections in API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant sections in API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackageResourcesResponse(AbstractModel):
    r"""DescribeBandwidthPackageResources response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of eligible resources in the bandwidth package.
        :type TotalCount: int
        :param _ResourceSet: The list of resources in the bandwidth package.
        :type ResourceSet: list of Resource
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ResourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of eligible resources in the bandwidth package.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ResourceSet(self):
        r"""The list of resources in the bandwidth package.
        :rtype: list of Resource
        """
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackagesRequest(AbstractModel):
    r"""DescribeBandwidthPackages request structure.

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageIds: The unique ID list of bandwidth packages.
        :type BandwidthPackageIds: list of str
        :param _Filters: Each request can have up to 10 `Filters`. parameters do not support specifying `BandwidthPackageIds` and `Filters` at the same time. detailed filter criteria are as follows:.
<li>bandwidth-package-id - String - required: no - (filter condition) filter by the unique id of the bandwidth package.</li>.
<li>bandwidth-package-name - String - required: no - (filter criteria) filter by bandwidth package name. fuzzy filtering is not supported.</li>.
<li>network-type - String - required: no - (filter condition) filter by bandwidth package type. network type can be found in [BandwidthPackage](https://intl.cloud.tencent.com/document/api/215/15824?from_cn_redirect=1#BandwidthPackage).</li>.
<li>- charge-type - String - required: no - (filter condition) filter by the billing type of the bandwidth package. the billing type can be found in BandwidthPackage (https://intl.cloud.tencent.com/document/api/215/15824?from_cn_redirect=1#BandwidthPackage).</li>.
<li>resource.resource-type - String - required: no - (filter criteria) filter by bandwidth package resource type. resource types include 'Address' and 'LoadBalance'.</li>.
<li>resource.resource-id - String - required: no - (filter criteria) filter by bandwidth package resource id. resource id is in the format of 'eip-xxxx','lb-xxxx'.</li>.
<li>resource.address-ip - String - required: no - filter by bandwidth package resource ip.</li>.
<li>tag-key - String - required: no - (filter condition) filter according to the tag key.</li>.
<li>`tag-value` - String - Optional - Filter by the tag value.</li>

<li>tag:tag-key - String - required: no - (filter condition) filter by tag key-value pair. replace tag-key with a specific tag key.</li>.
        :type Filters: list of Filter
        :param _Offset: Offset. This value defaults to 0. For more information on Offset, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Offset: int
        :param _Limit: Number of bandwidth packages returned. This value defaults to 20. The maximum is 100. For more information on Limit, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Limit: int
        """
        self._BandwidthPackageIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def BandwidthPackageIds(self):
        r"""The unique ID list of bandwidth packages.
        :rtype: list of str
        """
        return self._BandwidthPackageIds

    @BandwidthPackageIds.setter
    def BandwidthPackageIds(self, BandwidthPackageIds):
        self._BandwidthPackageIds = BandwidthPackageIds

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters`. parameters do not support specifying `BandwidthPackageIds` and `Filters` at the same time. detailed filter criteria are as follows:.
<li>bandwidth-package-id - String - required: no - (filter condition) filter by the unique id of the bandwidth package.</li>.
<li>bandwidth-package-name - String - required: no - (filter criteria) filter by bandwidth package name. fuzzy filtering is not supported.</li>.
<li>network-type - String - required: no - (filter condition) filter by bandwidth package type. network type can be found in [BandwidthPackage](https://intl.cloud.tencent.com/document/api/215/15824?from_cn_redirect=1#BandwidthPackage).</li>.
<li>- charge-type - String - required: no - (filter condition) filter by the billing type of the bandwidth package. the billing type can be found in BandwidthPackage (https://intl.cloud.tencent.com/document/api/215/15824?from_cn_redirect=1#BandwidthPackage).</li>.
<li>resource.resource-type - String - required: no - (filter criteria) filter by bandwidth package resource type. resource types include 'Address' and 'LoadBalance'.</li>.
<li>resource.resource-id - String - required: no - (filter criteria) filter by bandwidth package resource id. resource id is in the format of 'eip-xxxx','lb-xxxx'.</li>.
<li>resource.address-ip - String - required: no - filter by bandwidth package resource ip.</li>.
<li>tag-key - String - required: no - (filter condition) filter according to the tag key.</li>.
<li>`tag-value` - String - Optional - Filter by the tag value.</li>

<li>tag:tag-key - String - required: no - (filter condition) filter by tag key-value pair. replace tag-key with a specific tag key.</li>.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. This value defaults to 0. For more information on Offset, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of bandwidth packages returned. This value defaults to 20. The maximum is 100. For more information on Limit, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BandwidthPackageIds = params.get("BandwidthPackageIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackagesResponse(AbstractModel):
    r"""DescribeBandwidthPackages response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of eligible bandwidth packages.
        :type TotalCount: int
        :param _BandwidthPackageSet: Detail information of the bandwidth package.
        :type BandwidthPackageSet: list of BandwidthPackage
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._BandwidthPackageSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of eligible bandwidth packages.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BandwidthPackageSet(self):
        r"""Detail information of the bandwidth package.
        :rtype: list of BandwidthPackage
        """
        return self._BandwidthPackageSet

    @BandwidthPackageSet.setter
    def BandwidthPackageSet(self, BandwidthPackageSet):
        self._BandwidthPackageSet = BandwidthPackageSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BandwidthPackageSet") is not None:
            self._BandwidthPackageSet = []
            for item in params.get("BandwidthPackageSet"):
                obj = BandwidthPackage()
                obj._deserialize(item)
                self._BandwidthPackageSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnAttachedInstancesRequest(AbstractModel):
    r"""DescribeCcnAttachedInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        :param _Filters: Filter conditions:
<li>`ccn-id` - String - The CCN instance ID. </li>
<li>`instance-type` - String - The associated instance type. </li>
<li>`instance-region` - String - The associated instance region. </li>
<li>`instance-id` - String - The instance ID of the associated instance. </li>
        :type Filters: list of Filter
        :param _CcnId: The ID of the CCN instance
        :type CcnId: str
        :param _OrderField: The order field supports `CcnId`, `InstanceType`, `InstanceId`, `InstanceName`, `InstanceRegion`, `AttachedTime`, and `State`.
        :type OrderField: str
        :param _OrderDirection: Order methods. Ascending: `ASC`, Descending: `DESC`.
        :type OrderDirection: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._CcnId = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Filter conditions:
<li>`ccn-id` - String - The CCN instance ID. </li>
<li>`instance-type` - String - The associated instance type. </li>
<li>`instance-region` - String - The associated instance region. </li>
<li>`instance-id` - String - The instance ID of the associated instance. </li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def CcnId(self):
        r"""The ID of the CCN instance
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def OrderField(self):
        r"""The order field supports `CcnId`, `InstanceType`, `InstanceId`, `InstanceName`, `InstanceRegion`, `AttachedTime`, and `State`.
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""Order methods. Ascending: `ASC`, Descending: `DESC`.
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._CcnId = params.get("CcnId")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnAttachedInstancesResponse(AbstractModel):
    r"""DescribeCcnAttachedInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _InstanceSet: The list of associated instances.
        :type InstanceSet: list of CcnAttachedInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        r"""The list of associated instances.
        :rtype: list of CcnAttachedInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CcnAttachedInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnRegionBandwidthLimitsRequest(AbstractModel):
    r"""DescribeCcnRegionBandwidthLimits request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID in the format of `ccn-f49l6u0z`.
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        r"""The CCN instance ID in the format of `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRegionBandwidthLimitsResponse(AbstractModel):
    r"""DescribeCcnRegionBandwidthLimits response structure.

    """

    def __init__(self):
        r"""
        :param _CcnRegionBandwidthLimitSet: The outbound bandwidth caps of all regions connected with the specified CCN instance
        :type CcnRegionBandwidthLimitSet: list of CcnRegionBandwidthLimit
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CcnRegionBandwidthLimitSet = None
        self._RequestId = None

    @property
    def CcnRegionBandwidthLimitSet(self):
        r"""The outbound bandwidth caps of all regions connected with the specified CCN instance
        :rtype: list of CcnRegionBandwidthLimit
        """
        return self._CcnRegionBandwidthLimitSet

    @CcnRegionBandwidthLimitSet.setter
    def CcnRegionBandwidthLimitSet(self, CcnRegionBandwidthLimitSet):
        self._CcnRegionBandwidthLimitSet = CcnRegionBandwidthLimitSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnRegionBandwidthLimitSet") is not None:
            self._CcnRegionBandwidthLimitSet = []
            for item in params.get("CcnRegionBandwidthLimitSet"):
                obj = CcnRegionBandwidthLimit()
                obj._deserialize(item)
                self._CcnRegionBandwidthLimitSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnRoutesRequest(AbstractModel):
    r"""DescribeCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-gree226l`.
        :type CcnId: str
        :param _RouteIds: The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        :param _Filters: Filter condition. `RouteIds` and `Filters` cannot be specified at the same time.
<li>route-id - String - (Filter condition) Routing policy ID.</li>
<li>cidr-block - String - (Filter condition) Destination.</li>
<li>instance-type - String - (Filter condition) The next hop type.</li>
<li>instance-region - String - (Filter condition) The next hop region.</li>
<li>instance-id - String - (Filter condition) The instance ID of the next hop.</li>
<li>route-table-id - String - (Filter condition) The list of route table IDs in the format of `ccntr-1234edfr`. Filters by the route table ID.</li>
        :type Filters: list of Filter
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        """
        self._CcnId = None
        self._RouteIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-gree226l`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        r"""The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds

    @property
    def Filters(self):
        r"""Filter condition. `RouteIds` and `Filters` cannot be specified at the same time.
<li>route-id - String - (Filter condition) Routing policy ID.</li>
<li>cidr-block - String - (Filter condition) Destination.</li>
<li>instance-type - String - (Filter condition) The next hop type.</li>
<li>instance-region - String - (Filter condition) The next hop region.</li>
<li>instance-id - String - (Filter condition) The instance ID of the next hop.</li>
<li>route-table-id - String - (Filter condition) The list of route table IDs in the format of `ccntr-1234edfr`. Filters by the route table ID.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRoutesResponse(AbstractModel):
    r"""DescribeCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _RouteSet: The CCN routing policy object.
        :type RouteSet: list of CcnRoute
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        r"""The CCN routing policy object.
        :rtype: list of CcnRoute
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = CcnRoute()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnsRequest(AbstractModel):
    r"""DescribeCcns request structure.

    """

    def __init__(self):
        r"""
        :param _CcnIds: The CCN instance ID, such as `ccn-f49l6u0z`. Each request can have a maximum of 100 instances. `CcnIds` and `Filters` cannot be specified at the same time
        :type CcnIds: list of str
        :param _Filters: Filter conditions. `CcnIds` and `Filters` cannot be specified at the same time.
<li>ccn-id - String - (Filter condition) The unique ID of the CCN, such as `vpc-f49l6u0z`.</li>
<li>ccn-name - String - (Filter condition) The CCN name.</li>
<li>ccn-description - String - (Filter condition) CCN description.</li>
<li>state - String - (Filter condition) The instance status. 'ISOLATED': Isolated (the account is in arrears and the service is suspended.) 'AVAILABLE': Running.</li>
<li>tag-key - String - Required: no - (Filter condition) Filters by tag key.</li>
<li>`tag:tag-key` - String - Required: no - (Filter condition) Filters by tag key pair. For this parameter, `tag-key` will be replaced with a specific tag key. For more information, see this example: **Querying the list of CCNs bound to tags**.</li>
        :type Filters: list of Filter
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        :param _OrderField: Order fields support `CcnId`, `CcnName`, `CreateTime`, `State`, and `QosLevel`
        :type OrderField: str
        :param _OrderDirection: Order methods. Ascending: `ASC`, Descending: `DESC`.
        :type OrderDirection: str
        """
        self._CcnIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def CcnIds(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`. Each request can have a maximum of 100 instances. `CcnIds` and `Filters` cannot be specified at the same time
        :rtype: list of str
        """
        return self._CcnIds

    @CcnIds.setter
    def CcnIds(self, CcnIds):
        self._CcnIds = CcnIds

    @property
    def Filters(self):
        r"""Filter conditions. `CcnIds` and `Filters` cannot be specified at the same time.
<li>ccn-id - String - (Filter condition) The unique ID of the CCN, such as `vpc-f49l6u0z`.</li>
<li>ccn-name - String - (Filter condition) The CCN name.</li>
<li>ccn-description - String - (Filter condition) CCN description.</li>
<li>state - String - (Filter condition) The instance status. 'ISOLATED': Isolated (the account is in arrears and the service is suspended.) 'AVAILABLE': Running.</li>
<li>tag-key - String - Required: no - (Filter condition) Filters by tag key.</li>
<li>`tag:tag-key` - String - Required: no - (Filter condition) Filters by tag key pair. For this parameter, `tag-key` will be replaced with a specific tag key. For more information, see this example: **Querying the list of CCNs bound to tags**.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        r"""Order fields support `CcnId`, `CcnName`, `CreateTime`, `State`, and `QosLevel`
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""Order methods. Ascending: `ASC`, Descending: `DESC`.
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._CcnIds = params.get("CcnIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnsResponse(AbstractModel):
    r"""DescribeCcns response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _CcnSet: CCN object.
        :type CcnSet: list of CCN
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._CcnSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CcnSet(self):
        r"""CCN object.
        :rtype: list of CCN
        """
        return self._CcnSet

    @CcnSet.setter
    def CcnSet(self, CcnSet):
        self._CcnSet = CcnSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CcnSet") is not None:
            self._CcnSet = []
            for item in params.get("CcnSet"):
                obj = CCN()
                obj._deserialize(item)
                self._CcnSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClassicLinkInstancesRequest(AbstractModel):
    r"""DescribeClassicLinkInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions.
<li>vpc-id - String - (Filter condition) The VPC instance ID.</li>
<li>vm-ip - String - (Filter condition) The IP address of the CVM on the basic network.</li>
        :type Filters: list of FilterObject
        :param _Offset: Offset
        :type Offset: str
        :param _Limit: The returned quantity
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filter conditions.
<li>vpc-id - String - (Filter condition) The VPC instance ID.</li>
<li>vm-ip - String - (Filter condition) The IP address of the CVM on the basic network.</li>
        :rtype: list of FilterObject
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterObject()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicLinkInstancesResponse(AbstractModel):
    r"""DescribeClassicLinkInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _ClassicLinkInstanceSet: Classiclink instance.
        :type ClassicLinkInstanceSet: list of ClassicLinkInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClassicLinkInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClassicLinkInstanceSet(self):
        r"""Classiclink instance.
        :rtype: list of ClassicLinkInstance
        """
        return self._ClassicLinkInstanceSet

    @ClassicLinkInstanceSet.setter
    def ClassicLinkInstanceSet(self, ClassicLinkInstanceSet):
        self._ClassicLinkInstanceSet = ClassicLinkInstanceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClassicLinkInstanceSet") is not None:
            self._ClassicLinkInstanceSet = []
            for item in params.get("ClassicLinkInstanceSet"):
                obj = ClassicLinkInstance()
                obj._deserialize(item)
                self._ClassicLinkInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCrossBorderComplianceRequest(AbstractModel):
    r"""DescribeCrossBorderCompliance request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: (Exact match) Service provider. Valid values: `UNICOM`.
        :type ServiceProvider: str
        :param _ComplianceId: (Exact match) ID of compliance review request.
        :type ComplianceId: int
        :param _Company: (Fuzzy match) Company name.
        :type Company: str
        :param _UniformSocialCreditCode: (Fuzzy match) Unified Social Credit Code.
        :type UniformSocialCreditCode: str
        :param _LegalPerson: (Fuzzy match) Legal person.
        :type LegalPerson: str
        :param _LegalPersonId: 
        :type LegalPersonId: str
        :param _IssuingAuthority: (Fuzzy match) Issuing authority.
        :type IssuingAuthority: str
        :param _BusinessAddress: (Fuzzy match) Business address.
        :type BusinessAddress: str
        :param _PostCode: (Exact match) Zip code.
        :type PostCode: int
        :param _Manager: (Fuzzy match) Operator.
        :type Manager: str
        :param _ManagerId: (Exact match) Operator ID card number.
        :type ManagerId: str
        :param _ManagerAddress: (Fuzzy match) Operator address.
        :type ManagerAddress: str
        :param _ManagerTelephone: (Exact match) Operator phone number.
        :type ManagerTelephone: str
        :param _Email: (Exact match) Email.
        :type Email: str
        :param _ServiceStartDate: (Exact match) Service start date, such as `2020-07-28`.
        :type ServiceStartDate: str
        :param _ServiceEndDate: (Exact match) Service end date, such as `2020-07-28`.
        :type ServiceEndDate: str
        :param _State: (Exact match) Status. Valid values: `PENDING`, `APPROVED`, and `DENY`.
        :type State: str
        :param _Offset: The offset value
        :type Offset: int
        :param _Limit: Quantity of returned items
        :type Limit: int
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._Company = None
        self._UniformSocialCreditCode = None
        self._LegalPerson = None
        self._LegalPersonId = None
        self._IssuingAuthority = None
        self._BusinessAddress = None
        self._PostCode = None
        self._Manager = None
        self._ManagerId = None
        self._ManagerAddress = None
        self._ManagerTelephone = None
        self._Email = None
        self._ServiceStartDate = None
        self._ServiceEndDate = None
        self._State = None
        self._Offset = None
        self._Limit = None

    @property
    def ServiceProvider(self):
        r"""(Exact match) Service provider. Valid values: `UNICOM`.
        :rtype: str
        """
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        r"""(Exact match) ID of compliance review request.
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def Company(self):
        r"""(Fuzzy match) Company name.
        :rtype: str
        """
        return self._Company

    @Company.setter
    def Company(self, Company):
        self._Company = Company

    @property
    def UniformSocialCreditCode(self):
        r"""(Fuzzy match) Unified Social Credit Code.
        :rtype: str
        """
        return self._UniformSocialCreditCode

    @UniformSocialCreditCode.setter
    def UniformSocialCreditCode(self, UniformSocialCreditCode):
        self._UniformSocialCreditCode = UniformSocialCreditCode

    @property
    def LegalPerson(self):
        r"""(Fuzzy match) Legal person.
        :rtype: str
        """
        return self._LegalPerson

    @LegalPerson.setter
    def LegalPerson(self, LegalPerson):
        self._LegalPerson = LegalPerson

    @property
    def LegalPersonId(self):
        r"""
        :rtype: str
        """
        return self._LegalPersonId

    @LegalPersonId.setter
    def LegalPersonId(self, LegalPersonId):
        self._LegalPersonId = LegalPersonId

    @property
    def IssuingAuthority(self):
        r"""(Fuzzy match) Issuing authority.
        :rtype: str
        """
        return self._IssuingAuthority

    @IssuingAuthority.setter
    def IssuingAuthority(self, IssuingAuthority):
        self._IssuingAuthority = IssuingAuthority

    @property
    def BusinessAddress(self):
        r"""(Fuzzy match) Business address.
        :rtype: str
        """
        return self._BusinessAddress

    @BusinessAddress.setter
    def BusinessAddress(self, BusinessAddress):
        self._BusinessAddress = BusinessAddress

    @property
    def PostCode(self):
        r"""(Exact match) Zip code.
        :rtype: int
        """
        return self._PostCode

    @PostCode.setter
    def PostCode(self, PostCode):
        self._PostCode = PostCode

    @property
    def Manager(self):
        r"""(Fuzzy match) Operator.
        :rtype: str
        """
        return self._Manager

    @Manager.setter
    def Manager(self, Manager):
        self._Manager = Manager

    @property
    def ManagerId(self):
        r"""(Exact match) Operator ID card number.
        :rtype: str
        """
        return self._ManagerId

    @ManagerId.setter
    def ManagerId(self, ManagerId):
        self._ManagerId = ManagerId

    @property
    def ManagerAddress(self):
        r"""(Fuzzy match) Operator address.
        :rtype: str
        """
        return self._ManagerAddress

    @ManagerAddress.setter
    def ManagerAddress(self, ManagerAddress):
        self._ManagerAddress = ManagerAddress

    @property
    def ManagerTelephone(self):
        r"""(Exact match) Operator phone number.
        :rtype: str
        """
        return self._ManagerTelephone

    @ManagerTelephone.setter
    def ManagerTelephone(self, ManagerTelephone):
        self._ManagerTelephone = ManagerTelephone

    @property
    def Email(self):
        r"""(Exact match) Email.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ServiceStartDate(self):
        r"""(Exact match) Service start date, such as `2020-07-28`.
        :rtype: str
        """
        return self._ServiceStartDate

    @ServiceStartDate.setter
    def ServiceStartDate(self, ServiceStartDate):
        self._ServiceStartDate = ServiceStartDate

    @property
    def ServiceEndDate(self):
        r"""(Exact match) Service end date, such as `2020-07-28`.
        :rtype: str
        """
        return self._ServiceEndDate

    @ServiceEndDate.setter
    def ServiceEndDate(self, ServiceEndDate):
        self._ServiceEndDate = ServiceEndDate

    @property
    def State(self):
        r"""(Exact match) Status. Valid values: `PENDING`, `APPROVED`, and `DENY`.
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Offset(self):
        r"""The offset value
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Quantity of returned items
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._Company = params.get("Company")
        self._UniformSocialCreditCode = params.get("UniformSocialCreditCode")
        self._LegalPerson = params.get("LegalPerson")
        self._LegalPersonId = params.get("LegalPersonId")
        self._IssuingAuthority = params.get("IssuingAuthority")
        self._BusinessAddress = params.get("BusinessAddress")
        self._PostCode = params.get("PostCode")
        self._Manager = params.get("Manager")
        self._ManagerId = params.get("ManagerId")
        self._ManagerAddress = params.get("ManagerAddress")
        self._ManagerTelephone = params.get("ManagerTelephone")
        self._Email = params.get("Email")
        self._ServiceStartDate = params.get("ServiceStartDate")
        self._ServiceEndDate = params.get("ServiceEndDate")
        self._State = params.get("State")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCrossBorderComplianceResponse(AbstractModel):
    r"""DescribeCrossBorderCompliance response structure.

    """

    def __init__(self):
        r"""
        :param _CrossBorderComplianceSet: List of compliance review requests.
        :type CrossBorderComplianceSet: list of CrossBorderCompliance
        :param _TotalCount: Total number of compliance review requests.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CrossBorderComplianceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CrossBorderComplianceSet(self):
        r"""List of compliance review requests.
        :rtype: list of CrossBorderCompliance
        """
        return self._CrossBorderComplianceSet

    @CrossBorderComplianceSet.setter
    def CrossBorderComplianceSet(self, CrossBorderComplianceSet):
        self._CrossBorderComplianceSet = CrossBorderComplianceSet

    @property
    def TotalCount(self):
        r"""Total number of compliance review requests.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CrossBorderComplianceSet") is not None:
            self._CrossBorderComplianceSet = []
            for item in params.get("CrossBorderComplianceSet"):
                obj = CrossBorderCompliance()
                obj._deserialize(item)
                self._CrossBorderComplianceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCustomerGatewayVendorsRequest(AbstractModel):
    r"""DescribeCustomerGatewayVendors request structure.

    """


class DescribeCustomerGatewayVendorsResponse(AbstractModel):
    r"""DescribeCustomerGatewayVendors response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayVendorSet: Customer gateway vendor information object.
        :type CustomerGatewayVendorSet: list of CustomerGatewayVendor
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGatewayVendorSet = None
        self._RequestId = None

    @property
    def CustomerGatewayVendorSet(self):
        r"""Customer gateway vendor information object.
        :rtype: list of CustomerGatewayVendor
        """
        return self._CustomerGatewayVendorSet

    @CustomerGatewayVendorSet.setter
    def CustomerGatewayVendorSet(self, CustomerGatewayVendorSet):
        self._CustomerGatewayVendorSet = CustomerGatewayVendorSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGatewayVendorSet") is not None:
            self._CustomerGatewayVendorSet = []
            for item in params.get("CustomerGatewayVendorSet"):
                obj = CustomerGatewayVendor()
                obj._deserialize(item)
                self._CustomerGatewayVendorSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomerGatewaysRequest(AbstractModel):
    r"""DescribeCustomerGateways request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayIds: Customer gateway ID, such as `cgw-2wqq41m9`. Each request can have a maximum of 100 instances. `CustomerGatewayIds` and `Filters` cannot be specified at the same time.
        :type CustomerGatewayIds: list of str
        :param _Filters: The filter condition. For details, see the Instance Filter Conditions Table. The upper limit for `Filters` in each request is 10 and 5 for `Filter.Values`. `CustomerGatewayIds` and `Filters` cannot be specified at the same time.
<li>customer-gateway-id - String - (Filter condition) The unique ID of the user gateway, such as `cgw-mgp33pll`.</li>
<li>customer-gateway-name - String - (Filter condition) The name of the user gateway, such as `test-cgw`.</li>
<li>ip-address - String - (Filter condition) The public IP address, such as `58.211.1.12`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0. For more information on Offset, see the relevant section in the API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._CustomerGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def CustomerGatewayIds(self):
        r"""Customer gateway ID, such as `cgw-2wqq41m9`. Each request can have a maximum of 100 instances. `CustomerGatewayIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._CustomerGatewayIds

    @CustomerGatewayIds.setter
    def CustomerGatewayIds(self, CustomerGatewayIds):
        self._CustomerGatewayIds = CustomerGatewayIds

    @property
    def Filters(self):
        r"""The filter condition. For details, see the Instance Filter Conditions Table. The upper limit for `Filters` in each request is 10 and 5 for `Filter.Values`. `CustomerGatewayIds` and `Filters` cannot be specified at the same time.
<li>customer-gateway-id - String - (Filter condition) The unique ID of the user gateway, such as `cgw-mgp33pll`.</li>
<li>customer-gateway-name - String - (Filter condition) The name of the user gateway, such as `test-cgw`.</li>
<li>ip-address - String - (Filter condition) The public IP address, such as `58.211.1.12`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0. For more information on Offset, see the relevant section in the API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CustomerGatewayIds = params.get("CustomerGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomerGatewaysResponse(AbstractModel):
    r"""DescribeCustomerGateways response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewaySet: Customer gateway object list
        :type CustomerGatewaySet: list of CustomerGateway
        :param _TotalCount: Number of eligible instances
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CustomerGatewaySet(self):
        r"""Customer gateway object list
        :rtype: list of CustomerGateway
        """
        return self._CustomerGatewaySet

    @CustomerGatewaySet.setter
    def CustomerGatewaySet(self, CustomerGatewaySet):
        self._CustomerGatewaySet = CustomerGatewaySet

    @property
    def TotalCount(self):
        r"""Number of eligible instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGatewaySet") is not None:
            self._CustomerGatewaySet = []
            for item in params.get("CustomerGatewaySet"):
                obj = CustomerGateway()
                obj._deserialize(item)
                self._CustomerGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    r"""DescribeDirectConnectGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`.
        :type DirectConnectGatewayId: str
        :param _CcnRouteType: The route learning type of the CCN. Available values:
<li>`BGP` - Automatic learning.</li>
<li>`STATIC` - Static means user-configured. This is the default value.</li>
        :type CcnRouteType: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity.
        :type Limit: int
        """
        self._DirectConnectGatewayId = None
        self._CcnRouteType = None
        self._Offset = None
        self._Limit = None

    @property
    def DirectConnectGatewayId(self):
        r"""The ID of the Direct Connect gateway, such as `dcg-prpqlmg1`.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def CcnRouteType(self):
        r"""The route learning type of the CCN. Available values:
<li>`BGP` - Automatic learning.</li>
<li>`STATIC` - Static means user-configured. This is the default value.</li>
        :rtype: str
        """
        return self._CcnRouteType

    @CcnRouteType.setter
    def CcnRouteType(self, CcnRouteType):
        self._CcnRouteType = CcnRouteType

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._CcnRouteType = params.get("CcnRouteType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    r"""DescribeDirectConnectGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _RouteSet: The CCN route (IDC IP range) list.
        :type RouteSet: list of DirectConnectGatewayCcnRoute
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        r"""The CCN route (IDC IP range) list.
        :rtype: list of DirectConnectGatewayCcnRoute
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectGatewaysRequest(AbstractModel):
    r"""DescribeDirectConnectGateways request structure.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayIds: The unique ID of the direct connect gateway, such as `dcg-9o233uri`.
        :type DirectConnectGatewayIds: list of str
        :param _Filters: Filter condition. `DirectConnectGatewayIds` and `Filters` cannot be specified at the same time.
<li>direct-connect-gateway-id - String - The unique ID of the direct connect gateway, such as `dcg-9o233uri`.</li>
<li>direct-connect-gateway-name - String - The name of the direct connect gateway. The default is fuzzy query.</li>
<li>direct-connect-gateway-ip - String - The IP of the direct connect gateway.</li>
<li>gateway-type - String - The gateway type. Valid values: `NORMAL` (Standard type), `NAT` (NAT type).</li>
<li>network-type- String - The network type. Valid values: `VPC` (VPC type), `CCN` (CCN type).</li>
<li>ccn-id - String - The ID of the CCN where the direct connect gateway resides.</li>
<li>vpc-id - String - The ID of the VPC where the direct connect gateway resides.</li>
        :type Filters: list of Filter
        :param _Offset: The offset.
        :type Offset: int
        :param _Limit: Max number of results returned
        :type Limit: int
        """
        self._DirectConnectGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def DirectConnectGatewayIds(self):
        r"""The unique ID of the direct connect gateway, such as `dcg-9o233uri`.
        :rtype: list of str
        """
        return self._DirectConnectGatewayIds

    @DirectConnectGatewayIds.setter
    def DirectConnectGatewayIds(self, DirectConnectGatewayIds):
        self._DirectConnectGatewayIds = DirectConnectGatewayIds

    @property
    def Filters(self):
        r"""Filter condition. `DirectConnectGatewayIds` and `Filters` cannot be specified at the same time.
<li>direct-connect-gateway-id - String - The unique ID of the direct connect gateway, such as `dcg-9o233uri`.</li>
<li>direct-connect-gateway-name - String - The name of the direct connect gateway. The default is fuzzy query.</li>
<li>direct-connect-gateway-ip - String - The IP of the direct connect gateway.</li>
<li>gateway-type - String - The gateway type. Valid values: `NORMAL` (Standard type), `NAT` (NAT type).</li>
<li>network-type- String - The network type. Valid values: `VPC` (VPC type), `CCN` (CCN type).</li>
<li>ccn-id - String - The ID of the CCN where the direct connect gateway resides.</li>
<li>vpc-id - String - The ID of the VPC where the direct connect gateway resides.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Max number of results returned
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DirectConnectGatewayIds = params.get("DirectConnectGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectGatewaysResponse(AbstractModel):
    r"""DescribeDirectConnectGateways response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _DirectConnectGatewaySet: The object array of the direct connect gateway.
        :type DirectConnectGatewaySet: list of DirectConnectGateway
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DirectConnectGatewaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of eligible objects.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DirectConnectGatewaySet(self):
        r"""The object array of the direct connect gateway.
        :rtype: list of DirectConnectGateway
        """
        return self._DirectConnectGatewaySet

    @DirectConnectGatewaySet.setter
    def DirectConnectGatewaySet(self, DirectConnectGatewaySet):
        self._DirectConnectGatewaySet = DirectConnectGatewaySet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DirectConnectGatewaySet") is not None:
            self._DirectConnectGatewaySet = []
            for item in params.get("DirectConnectGatewaySet"):
                obj = DirectConnectGateway()
                obj._deserialize(item)
                self._DirectConnectGatewaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowLogRequest(AbstractModel):
    r"""DescribeFlowLog request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: ID of the VPC instance.
        :type VpcId: str
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        """
        self._VpcId = None
        self._FlowLogId = None

    @property
    def VpcId(self):
        r"""ID of the VPC instance.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        r"""The unique ID of the flow log.
        :rtype: str
        """
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLogResponse(AbstractModel):
    r"""DescribeFlowLog response structure.

    """

    def __init__(self):
        r"""
        :param _FlowLog: The flow log information.
        :type FlowLog: list of FlowLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowLog = None
        self._RequestId = None

    @property
    def FlowLog(self):
        r"""The flow log information.
        :rtype: list of FlowLog
        """
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowLogsRequest(AbstractModel):
    r"""DescribeFlowLogs request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: ID of the VPC instance
        :type VpcId: str
        :param _FlowLogId: The unique ID of the flow log.
        :type FlowLogId: str
        :param _FlowLogName: The name of the flow log instance.
        :type FlowLogName: str
        :param _ResourceType: The resource type of the flow log. Valid values: 'VPC', 'SUBNET', and 'NETWORKINTERFACE'.
        :type ResourceType: str
        :param _ResourceId: The unique ID of the resource.
        :type ResourceId: str
        :param _TrafficType: Type of flow logs to be collected. Valid values: 'ACCEPT', 'REJECT' and 'ALL'.
        :type TrafficType: str
        :param _CloudLogId: The storage ID of the flow log.
        :type CloudLogId: str
        :param _CloudLogState: The storage ID status of the flow log.
        :type CloudLogState: str
        :param _OrderField: Order by field. Valid values: 'flowLogName' and 'createTime'. Default value: 'createTime'.
        :type OrderField: str
        :param _OrderDirection: In ascending (`asc`) or descending (`desc`) order. Default value: 'desc'.
        :type OrderDirection: str
        :param _Offset: The offset. Default value: 0.
        :type Offset: int
        :param _Limit: The number of rows per page. Default value: 10.
        :type Limit: int
        :param _Filters: Filter condition. `FlowLogId` and `Filters` cannot be specified at the same time.
<li> `tag-key` - String - Optional - Filter by the tag key.</li>
<li> `tag:tag-key` - String - Optional - Filter by the tag key-value pair. The tag-key should be replaced with a specified tag key.</li>
        :type Filters: :class:`tencentcloud.vpc.v20170312.models.Filter`
        :param _CloudLogRegion: The region corresponding to the flow log storage ID.
        :type CloudLogRegion: str
        """
        self._VpcId = None
        self._FlowLogId = None
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._CloudLogId = None
        self._CloudLogState = None
        self._OrderField = None
        self._OrderDirection = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._CloudLogRegion = None

    @property
    def VpcId(self):
        r"""ID of the VPC instance
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        r"""The unique ID of the flow log.
        :rtype: str
        """
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def FlowLogName(self):
        r"""The name of the flow log instance.
        :rtype: str
        """
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        r"""The resource type of the flow log. Valid values: 'VPC', 'SUBNET', and 'NETWORKINTERFACE'.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        r"""The unique ID of the resource.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        r"""Type of flow logs to be collected. Valid values: 'ACCEPT', 'REJECT' and 'ALL'.
        :rtype: str
        """
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def CloudLogId(self):
        r"""The storage ID of the flow log.
        :rtype: str
        """
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def CloudLogState(self):
        r"""The storage ID status of the flow log.
        :rtype: str
        """
        return self._CloudLogState

    @CloudLogState.setter
    def CloudLogState(self, CloudLogState):
        self._CloudLogState = CloudLogState

    @property
    def OrderField(self):
        r"""Order by field. Valid values: 'flowLogName' and 'createTime'. Default value: 'createTime'.
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""In ascending (`asc`) or descending (`desc`) order. Default value: 'desc'.
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection

    @property
    def Offset(self):
        r"""The offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of rows per page. Default value: 10.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Filter condition. `FlowLogId` and `Filters` cannot be specified at the same time.
<li> `tag-key` - String - Optional - Filter by the tag key.</li>
<li> `tag:tag-key` - String - Optional - Filter by the tag key-value pair. The tag-key should be replaced with a specified tag key.</li>
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Filter`
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def CloudLogRegion(self):
        r"""The region corresponding to the flow log storage ID.
        :rtype: str
        """
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._CloudLogId = params.get("CloudLogId")
        self._CloudLogState = params.get("CloudLogState")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLogsResponse(AbstractModel):
    r"""DescribeFlowLogs response structure.

    """

    def __init__(self):
        r"""
        :param _FlowLog: The instance set of flow logs.
        :type FlowLog: list of FlowLog
        :param _TotalNum: The total number of flow logs.
        :type TotalNum: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowLog = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def FlowLog(self):
        r"""The instance set of flow logs.
        :rtype: list of FlowLog
        """
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def TotalNum(self):
        r"""The total number of flow logs.
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeGatewayFlowMonitorDetailRequest(AbstractModel):
    r"""DescribeGatewayFlowMonitorDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TimePoint: The point in time. This indicates details of this minute will be queried. For example, in `2019-02-28 18:15:20`, details at `18:15` will be queried.
        :type TimePoint: str
        :param _VpnId: The instance ID of the VPN gateway, such as `vpn-ltjahce6`.
        :type VpnId: str
        :param _DirectConnectGatewayId: The instance ID of the Direct Connect gateway, such as `dcg-ltjahce6`.
        :type DirectConnectGatewayId: str
        :param _PeeringConnectionId: The instance ID of the peering connection, such as `pcx-ltjahce6`.
        :type PeeringConnectionId: str
        :param _NatId: The instance ID of the NAT gateway, such as `nat-ltjahce6`.
        :type NatId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity.
        :type Limit: int
        :param _OrderField: The order field supports `InPkg`, `OutPkg`, `InTraffic`, and `OutTraffic`.
        :type OrderField: str
        :param _OrderDirection: Order methods. Ascending: `ASC`, Descending: `DESC`.
        :type OrderDirection: str
        """
        self._TimePoint = None
        self._VpnId = None
        self._DirectConnectGatewayId = None
        self._PeeringConnectionId = None
        self._NatId = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def TimePoint(self):
        r"""The point in time. This indicates details of this minute will be queried. For example, in `2019-02-28 18:15:20`, details at `18:15` will be queried.
        :rtype: str
        """
        return self._TimePoint

    @TimePoint.setter
    def TimePoint(self, TimePoint):
        self._TimePoint = TimePoint

    @property
    def VpnId(self):
        r"""The instance ID of the VPN gateway, such as `vpn-ltjahce6`.
        :rtype: str
        """
        return self._VpnId

    @VpnId.setter
    def VpnId(self, VpnId):
        self._VpnId = VpnId

    @property
    def DirectConnectGatewayId(self):
        r"""The instance ID of the Direct Connect gateway, such as `dcg-ltjahce6`.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def PeeringConnectionId(self):
        r"""The instance ID of the peering connection, such as `pcx-ltjahce6`.
        :rtype: str
        """
        return self._PeeringConnectionId

    @PeeringConnectionId.setter
    def PeeringConnectionId(self, PeeringConnectionId):
        self._PeeringConnectionId = PeeringConnectionId

    @property
    def NatId(self):
        r"""The instance ID of the NAT gateway, such as `nat-ltjahce6`.
        :rtype: str
        """
        return self._NatId

    @NatId.setter
    def NatId(self, NatId):
        self._NatId = NatId

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        r"""The order field supports `InPkg`, `OutPkg`, `InTraffic`, and `OutTraffic`.
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""Order methods. Ascending: `ASC`, Descending: `DESC`.
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._TimePoint = params.get("TimePoint")
        self._VpnId = params.get("VpnId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._PeeringConnectionId = params.get("PeeringConnectionId")
        self._NatId = params.get("NatId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayFlowMonitorDetailResponse(AbstractModel):
    r"""DescribeGatewayFlowMonitorDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _GatewayFlowMonitorDetailSet: The gateway traffic monitoring details.
        :type GatewayFlowMonitorDetailSet: list of GatewayFlowMonitorDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._GatewayFlowMonitorDetailSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def GatewayFlowMonitorDetailSet(self):
        r"""The gateway traffic monitoring details.
        :rtype: list of GatewayFlowMonitorDetail
        """
        return self._GatewayFlowMonitorDetailSet

    @GatewayFlowMonitorDetailSet.setter
    def GatewayFlowMonitorDetailSet(self, GatewayFlowMonitorDetailSet):
        self._GatewayFlowMonitorDetailSet = GatewayFlowMonitorDetailSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("GatewayFlowMonitorDetailSet") is not None:
            self._GatewayFlowMonitorDetailSet = []
            for item in params.get("GatewayFlowMonitorDetailSet"):
                obj = GatewayFlowMonitorDetail()
                obj._deserialize(item)
                self._GatewayFlowMonitorDetailSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeGatewayFlowQosRequest(AbstractModel):
    r"""DescribeGatewayFlowQos request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        :param _IpAddresses: CVM private IP addresses with limited bandwidth.
        :type IpAddresses: list of str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._GatewayId = None
        self._IpAddresses = None
        self._Offset = None
        self._Limit = None

    @property
    def GatewayId(self):
        r"""Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :rtype: str
        """
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def IpAddresses(self):
        r"""CVM private IP addresses with limited bandwidth.
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        self._IpAddresses = params.get("IpAddresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayFlowQosResponse(AbstractModel):
    r"""DescribeGatewayFlowQos response structure.

    """

    def __init__(self):
        r"""
        :param _GatewayQosSet: List of instance details
        :type GatewayQosSet: list of GatewayQos
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GatewayQosSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def GatewayQosSet(self):
        r"""List of instance details
        :rtype: list of GatewayQos
        """
        return self._GatewayQosSet

    @GatewayQosSet.setter
    def GatewayQosSet(self, GatewayQosSet):
        self._GatewayQosSet = GatewayQosSet

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GatewayQosSet") is not None:
            self._GatewayQosSet = []
            for item in params.get("GatewayQosSet"):
                obj = GatewayQos()
                obj._deserialize(item)
                self._GatewayQosSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeHaVipsRequest(AbstractModel):
    r"""DescribeHaVips request structure.

    """

    def __init__(self):
        r"""
        :param _HaVipIds: The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :type HaVipIds: list of str
        :param _Filters: Filter condition. `HaVipIds` and `Filters` cannot be specified at the same time.
li>havip-id - String - The unique ID of the HAVIP, such as `havip-9o233uri`.</li>
<li>havip-name - String - HAVIP name.</li>
<li>vpc-id - String - VPC ID of the HAVIP.</li>
<li>subnet-id - String - Subnet ID of the HAVIP.</li>
<li>vip - String - Virtual IP address of the HAVIP.</li>
<li>address-ip - String - Bound EIP.</li>
        :type Filters: list of Filter
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        """
        self._HaVipIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def HaVipIds(self):
        r"""The unique `ID` of the `HAVIP`, such as `havip-9o233uri`.
        :rtype: list of str
        """
        return self._HaVipIds

    @HaVipIds.setter
    def HaVipIds(self, HaVipIds):
        self._HaVipIds = HaVipIds

    @property
    def Filters(self):
        r"""Filter condition. `HaVipIds` and `Filters` cannot be specified at the same time.
li>havip-id - String - The unique ID of the HAVIP, such as `havip-9o233uri`.</li>
<li>havip-name - String - HAVIP name.</li>
<li>vpc-id - String - VPC ID of the HAVIP.</li>
<li>subnet-id - String - Subnet ID of the HAVIP.</li>
<li>vip - String - Virtual IP address of the HAVIP.</li>
<li>address-ip - String - Bound EIP.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._HaVipIds = params.get("HaVipIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHaVipsResponse(AbstractModel):
    r"""DescribeHaVips response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _HaVipSet: `HAVIP` object array.
        :type HaVipSet: list of HaVip
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._HaVipSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HaVipSet(self):
        r"""`HAVIP` object array.
        :rtype: list of HaVip
        """
        return self._HaVipSet

    @HaVipSet.setter
    def HaVipSet(self, HaVipSet):
        self._HaVipSet = HaVipSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HaVipSet") is not None:
            self._HaVipSet = []
            for item in params.get("HaVipSet"):
                obj = HaVip()
                obj._deserialize(item)
                self._HaVipSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIPv6AddressesRequest(AbstractModel):
    r"""DescribeIPv6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _IPv6AddressIds: Unique ID column identifying IPv6.

- Unique ID of the traditional EIPv6, such as `eip-11112222`
- Unique ID of the EIPv6, such as `eipv6-11112222`

Note: `IPv6AddressIds` and `Filters` cannot be specified at the same time.
        :type IPv6AddressIds: list of str
        :param _Filters: Each request can have up to 10 `Filters` and 100 `Filter.Values`. `IPv6AddressIds` and `Filters` cannot be specified at the same time. The detailed filter conditions are as follows:

- address-id - String - Required: No - (Filter condition) Filter by the unique ID of the EIPv6.
- public-ipv6-address - String - Required: No - (Filter condition) Filter by the public IPv6 address.
- network-interface-id - String - Required: No - (Filter condition) Filter by the unique ID of the ENI.
- instance-id - String - Required: No - (Filter condition) Filter by the unique ID of the bound instance.
- charge-type - String - Required: No - (Filter condition) Filter by the billing type.
- private-ipv6-address - String - Required: No - (Filter condition) Filter by the bound private IPv6 address.
- egress - String - Required: No - (Filter condition) Filter by the egress.
- address-type - String - Required: No - (Filter condition) Filter by the IPv6 type. Valid values: 'EIP6', 'EIPv6', 'WanIPv6', and 'HighQualityEIPv6'. Default: 'EIPv6'.
- address-isp - String - Required: No - (Filter condition) Filter by the ISP type. Valid values: 'BGP', 'CMCC', 'CUCC', and 'CTCC'.
- address-status - String - Required: No - (Filter condition) Filter by the EIP status. Valid values: 'CREATING', 'BINDING', 'BIND', 'UNBINDING', 'UNBIND', 'OFFLINING', 'BIND_ENI', and 'PRIVATE'.
- address-name - String - Required: No - (Filter condition) Filter by the EIP name. Fuzzy filtering is not supported.
- tag-key - String - Required: No - (Filter condition) Filter by the tag key.
- tag-value - String - Required: No - (Filter condition) Filter by the tag value.
- tag:tag-key - String - Required: No - (Filter condition) Filter by the tag-key - value pair. Replace tag-key with a specific tag key.
        :type Filters: list of Filter
        :param _Traditional: Indicates whether to query the traditional IPv6 address information.
        :type Traditional: bool
        :param _Offset: Offset. Default: 0. For more information on Offset, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Offset: int
        :param _Limit: Number of returned results. Default: 20. Maximum: 100. For more information on Limit, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Limit: int
        """
        self._IPv6AddressIds = None
        self._Filters = None
        self._Traditional = None
        self._Offset = None
        self._Limit = None

    @property
    def IPv6AddressIds(self):
        r"""Unique ID column identifying IPv6.

- Unique ID of the traditional EIPv6, such as `eip-11112222`
- Unique ID of the EIPv6, such as `eipv6-11112222`

Note: `IPv6AddressIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._IPv6AddressIds

    @IPv6AddressIds.setter
    def IPv6AddressIds(self, IPv6AddressIds):
        self._IPv6AddressIds = IPv6AddressIds

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters` and 100 `Filter.Values`. `IPv6AddressIds` and `Filters` cannot be specified at the same time. The detailed filter conditions are as follows:

- address-id - String - Required: No - (Filter condition) Filter by the unique ID of the EIPv6.
- public-ipv6-address - String - Required: No - (Filter condition) Filter by the public IPv6 address.
- network-interface-id - String - Required: No - (Filter condition) Filter by the unique ID of the ENI.
- instance-id - String - Required: No - (Filter condition) Filter by the unique ID of the bound instance.
- charge-type - String - Required: No - (Filter condition) Filter by the billing type.
- private-ipv6-address - String - Required: No - (Filter condition) Filter by the bound private IPv6 address.
- egress - String - Required: No - (Filter condition) Filter by the egress.
- address-type - String - Required: No - (Filter condition) Filter by the IPv6 type. Valid values: 'EIP6', 'EIPv6', 'WanIPv6', and 'HighQualityEIPv6'. Default: 'EIPv6'.
- address-isp - String - Required: No - (Filter condition) Filter by the ISP type. Valid values: 'BGP', 'CMCC', 'CUCC', and 'CTCC'.
- address-status - String - Required: No - (Filter condition) Filter by the EIP status. Valid values: 'CREATING', 'BINDING', 'BIND', 'UNBINDING', 'UNBIND', 'OFFLINING', 'BIND_ENI', and 'PRIVATE'.
- address-name - String - Required: No - (Filter condition) Filter by the EIP name. Fuzzy filtering is not supported.
- tag-key - String - Required: No - (Filter condition) Filter by the tag key.
- tag-value - String - Required: No - (Filter condition) Filter by the tag value.
- tag:tag-key - String - Required: No - (Filter condition) Filter by the tag-key - value pair. Replace tag-key with a specific tag key.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Traditional(self):
        r"""Indicates whether to query the traditional IPv6 address information.
        :rtype: bool
        """
        return self._Traditional

    @Traditional.setter
    def Traditional(self, Traditional):
        self._Traditional = Traditional

    @property
    def Offset(self):
        r"""Offset. Default: 0. For more information on Offset, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default: 20. Maximum: 100. For more information on Limit, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._IPv6AddressIds = params.get("IPv6AddressIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Traditional = params.get("Traditional")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIPv6AddressesResponse(AbstractModel):
    r"""DescribeIPv6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of IPv6 meeting conditions.
        :type TotalCount: int
        :param _AddressSet: IPv6 detailed information list.
        :type AddressSet: list of Address
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of IPv6 meeting conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressSet(self):
        r"""IPv6 detailed information list.
        :rtype: list of Address
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressSet") is not None:
            self._AddressSet = []
            for item in params.get("AddressSet"):
                obj = Address()
                obj._deserialize(item)
                self._AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceJumboRequest(AbstractModel):
    r"""DescribeInstanceJumbo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceIds: Instance ID list of CVM. limits up to 10 instances for each query.
        :type InstanceIds: list of str
        """
        self._InstanceIds = None

    @property
    def InstanceIds(self):
        r"""Instance ID list of CVM. limits up to 10 instances for each query.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceJumboResponse(AbstractModel):
    r"""DescribeInstanceJumbo response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceJumboSet: Specifies the jumbo frame status of the cloud virtual machine.
        :type InstanceJumboSet: list of InstanceJumbo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceJumboSet = None
        self._RequestId = None

    @property
    def InstanceJumboSet(self):
        r"""Specifies the jumbo frame status of the cloud virtual machine.
        :rtype: list of InstanceJumbo
        """
        return self._InstanceJumboSet

    @InstanceJumboSet.setter
    def InstanceJumboSet(self, InstanceJumboSet):
        self._InstanceJumboSet = InstanceJumboSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceJumboSet") is not None:
            self._InstanceJumboSet = []
            for item in params.get("InstanceJumboSet"):
                obj = InstanceJumbo()
                obj._deserialize(item)
                self._InstanceJumboSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIp6AddressesRequest(AbstractModel):
    r"""DescribeIp6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _Ip6AddressIds: List of unique IDs that identify IPv6 instances. The unique ID of an IPv6 instance is in the format of `eip-11112222`. Parameters `Ip6AddressIds` and `Filters` cannot be specified at the same time.
        :type Ip6AddressIds: list of str
        :param _Filters: Each request can have up to 10 `Filters` values and 100 `Filter.Values` values. Parameters `AddressIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li>address-ip - String - Required: No - (Filter condition) Filter by the IP address of IPv6 instances.</li>
<li>network-interface-id - String - Required: No - (Filter condition) Filter by the unique ID of ENIs.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0. For more information on `Offset`, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :type Limit: int
        """
        self._Ip6AddressIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Ip6AddressIds(self):
        r"""List of unique IDs that identify IPv6 instances. The unique ID of an IPv6 instance is in the format of `eip-11112222`. Parameters `Ip6AddressIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._Ip6AddressIds

    @Ip6AddressIds.setter
    def Ip6AddressIds(self, Ip6AddressIds):
        self._Ip6AddressIds = Ip6AddressIds

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters` values and 100 `Filter.Values` values. Parameters `AddressIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li>address-ip - String - Required: No - (Filter condition) Filter by the IP address of IPv6 instances.</li>
<li>network-interface-id - String - Required: No - (Filter condition) Filter by the unique ID of ENIs.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0. For more information on `Offset`, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant section in the API [Introduction](https://www.tencentcloud.com/document/api/213/15688).
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Ip6AddressIds = params.get("Ip6AddressIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIp6AddressesResponse(AbstractModel):
    r"""DescribeIp6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of IPv6 meeting conditions.
        :type TotalCount: int
        :param _AddressSet: IPv6 detailed information list.
        :type AddressSet: list of Address
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of IPv6 meeting conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressSet(self):
        r"""IPv6 detailed information list.
        :rtype: list of Address
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressSet") is not None:
            self._AddressSet = []
            for item in params.get("AddressSet"):
                obj = Address()
                obj._deserialize(item)
                self._AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIpGeolocationDatabaseUrlRequest(AbstractModel):
    r"""DescribeIpGeolocationDatabaseUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Protocol type for an IP location database. Valid value: `ipv4`.
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        r"""Protocol type for an IP location database. Valid value: `ipv4`.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpGeolocationDatabaseUrlResponse(AbstractModel):
    r"""DescribeIpGeolocationDatabaseUrl response structure.

    """

    def __init__(self):
        r"""
        :param _DownLoadUrl: Download link of an IP location database
        :type DownLoadUrl: str
        :param _ExpiredAt: Link expiration time in UTC format following the ISO8601 standard.
        :type ExpiredAt: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownLoadUrl = None
        self._ExpiredAt = None
        self._RequestId = None

    @property
    def DownLoadUrl(self):
        r"""Download link of an IP location database
        :rtype: str
        """
        return self._DownLoadUrl

    @DownLoadUrl.setter
    def DownLoadUrl(self, DownLoadUrl):
        self._DownLoadUrl = DownLoadUrl

    @property
    def ExpiredAt(self):
        r"""Link expiration time in UTC format following the ISO8601 standard.
        :rtype: str
        """
        return self._ExpiredAt

    @ExpiredAt.setter
    def ExpiredAt(self, ExpiredAt):
        self._ExpiredAt = ExpiredAt

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownLoadUrl = params.get("DownLoadUrl")
        self._ExpiredAt = params.get("ExpiredAt")
        self._RequestId = params.get("RequestId")


class DescribeIpGeolocationInfosRequest(AbstractModel):
    r"""DescribeIpGeolocationInfos request structure.

    """

    def __init__(self):
        r"""
        :param _AddressIps: The list of IP addresses (only IPv4 addresses are available currently) to be queried; upper limit: 100
        :type AddressIps: list of str
        :param _Fields: Fields of the IP addresses to be queried.
        :type Fields: :class:`tencentcloud.vpc.v20170312.models.IpField`
        """
        self._AddressIps = None
        self._Fields = None

    @property
    def AddressIps(self):
        r"""The list of IP addresses (only IPv4 addresses are available currently) to be queried; upper limit: 100
        :rtype: list of str
        """
        return self._AddressIps

    @AddressIps.setter
    def AddressIps(self, AddressIps):
        self._AddressIps = AddressIps

    @property
    def Fields(self):
        r"""Fields of the IP addresses to be queried.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.IpField`
        """
        return self._Fields

    @Fields.setter
    def Fields(self, Fields):
        self._Fields = Fields


    def _deserialize(self, params):
        self._AddressIps = params.get("AddressIps")
        if params.get("Fields") is not None:
            self._Fields = IpField()
            self._Fields._deserialize(params.get("Fields"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpGeolocationInfosResponse(AbstractModel):
    r"""DescribeIpGeolocationInfos response structure.

    """

    def __init__(self):
        r"""
        :param _AddressInfo: IP address details
        :type AddressInfo: list of IpGeolocationInfo
        :param _Total: Number of IP addresses
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AddressInfo = None
        self._Total = None
        self._RequestId = None

    @property
    def AddressInfo(self):
        r"""IP address details
        :rtype: list of IpGeolocationInfo
        """
        return self._AddressInfo

    @AddressInfo.setter
    def AddressInfo(self, AddressInfo):
        self._AddressInfo = AddressInfo

    @property
    def Total(self):
        r"""Number of IP addresses
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressInfo") is not None:
            self._AddressInfo = []
            for item in params.get("AddressInfo"):
                obj = IpGeolocationInfo()
                obj._deserialize(item)
                self._AddressInfo.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeLocalGatewayRequest(AbstractModel):
    r"""DescribeLocalGateway request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Query criteria:
vpc-id: filter by VPC ID; local-gateway-name: filter by local gateway name (fuzzy search is supported); local-gateway-id: filter by local gateway instance ID; cdc-id: filter by CDC instance ID.
        :type Filters: list of Filter
        :param _Offset: The offset. Default value: 0. For more information on `Offset`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Offset: int
        :param _Limit: The number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Query criteria:
vpc-id: filter by VPC ID; local-gateway-name: filter by local gateway name (fuzzy search is supported); local-gateway-id: filter by local gateway instance ID; cdc-id: filter by CDC instance ID.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The offset. Default value: 0. For more information on `Offset`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of returned results. Default value: 20. Maximum value: 100. For more information on `Limit`, see the relevant sections in API [Introduction](https://intl.cloud.tencent.com/document/api/213/11646?from_cn_redirect=1).
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLocalGatewayResponse(AbstractModel):
    r"""DescribeLocalGateway response structure.

    """

    def __init__(self):
        r"""
        :param _LocalGatewaySet: Information set of local gateways
        :type LocalGatewaySet: list of LocalGateway
        :param _TotalCount: Total number of local gateways
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LocalGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def LocalGatewaySet(self):
        r"""Information set of local gateways
        :rtype: list of LocalGateway
        """
        return self._LocalGatewaySet

    @LocalGatewaySet.setter
    def LocalGatewaySet(self, LocalGatewaySet):
        self._LocalGatewaySet = LocalGatewaySet

    @property
    def TotalCount(self):
        r"""Total number of local gateways
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LocalGatewaySet") is not None:
            self._LocalGatewaySet = []
            for item in params.get("LocalGatewaySet"):
                obj = LocalGateway()
                obj._deserialize(item)
                self._LocalGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewayDestinationIpPortTranslationNatRulesRequest(AbstractModel):
    r"""DescribeNatGatewayDestinationIpPortTranslationNatRules request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: NAT gateway ID.
        :type NatGatewayIds: list of str
        :param _Filters: Filters:
`NatGatewayIds` and `Filters` cannot be specified at the same time.
<li> `nat-gateway-id`: The NAT gateway ID, such as `nat-0yi4hekt`.</li>
<li> `vpc-id`: The VPC ID, such as `vpc-0yi4hekt`.</li>
<li> `public-ip-address`: The EIP, such as `139.199.232.238`.</li>
<li>`public-port`: The public network port.</li>
<li>`private-ip-address`: The private IP, such as `10.0.0.1`.</li>
<li>`private-port`. The private network port.</li>
<li>`description`. The rule description.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayIds(self):
        r"""NAT gateway ID.
        :rtype: list of str
        """
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        r"""Filters:
`NatGatewayIds` and `Filters` cannot be specified at the same time.
<li> `nat-gateway-id`: The NAT gateway ID, such as `nat-0yi4hekt`.</li>
<li> `vpc-id`: The VPC ID, such as `vpc-0yi4hekt`.</li>
<li> `public-ip-address`: The EIP, such as `139.199.232.238`.</li>
<li>`public-port`: The public network port.</li>
<li>`private-ip-address`: The private IP, such as `10.0.0.1`.</li>
<li>`private-port`. The private network port.</li>
<li>`description`. The rule description.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewayDestinationIpPortTranslationNatRulesResponse(AbstractModel):
    r"""DescribeNatGatewayDestinationIpPortTranslationNatRules response structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayDestinationIpPortTranslationNatRuleSet: The object array of port forwarding rules for the NAT gateway.
        :type NatGatewayDestinationIpPortTranslationNatRuleSet: list of NatGatewayDestinationIpPortTranslationNatRule
        :param _TotalCount: The number of eligible object arrays of NAT port forwarding rules.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatGatewayDestinationIpPortTranslationNatRuleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewayDestinationIpPortTranslationNatRuleSet(self):
        r"""The object array of port forwarding rules for the NAT gateway.
        :rtype: list of NatGatewayDestinationIpPortTranslationNatRule
        """
        return self._NatGatewayDestinationIpPortTranslationNatRuleSet

    @NatGatewayDestinationIpPortTranslationNatRuleSet.setter
    def NatGatewayDestinationIpPortTranslationNatRuleSet(self, NatGatewayDestinationIpPortTranslationNatRuleSet):
        self._NatGatewayDestinationIpPortTranslationNatRuleSet = NatGatewayDestinationIpPortTranslationNatRuleSet

    @property
    def TotalCount(self):
        r"""The number of eligible object arrays of NAT port forwarding rules.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewayDestinationIpPortTranslationNatRuleSet") is not None:
            self._NatGatewayDestinationIpPortTranslationNatRuleSet = []
            for item in params.get("NatGatewayDestinationIpPortTranslationNatRuleSet"):
                obj = NatGatewayDestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._NatGatewayDestinationIpPortTranslationNatRuleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewayDirectConnectGatewayRouteRequest(AbstractModel):
    r"""DescribeNatGatewayDirectConnectGatewayRoute request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: Unique ID of the NAT gateway
        :type NatGatewayId: str
        :param _VpcId: Unique ID of VPC
        :type VpcId: str
        :param _Limit: Valid range: 0-200
        :type Limit: int
        :param _Offset: Greater than 0
        :type Offset: int
        """
        self._NatGatewayId = None
        self._VpcId = None
        self._Limit = None
        self._Offset = None

    @property
    def NatGatewayId(self):
        r"""Unique ID of the NAT gateway
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def VpcId(self):
        r"""Unique ID of VPC
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Limit(self):
        r"""Valid range: 0-200
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Greater than 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._VpcId = params.get("VpcId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewayDirectConnectGatewayRouteResponse(AbstractModel):
    r"""DescribeNatGatewayDirectConnectGatewayRoute response structure.

    """

    def __init__(self):
        r"""
        :param _NatDirectConnectGatewayRouteSet: Route data
        :type NatDirectConnectGatewayRouteSet: list of NatDirectConnectGatewayRoute
        :param _Total: Total number of routes
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatDirectConnectGatewayRouteSet = None
        self._Total = None
        self._RequestId = None

    @property
    def NatDirectConnectGatewayRouteSet(self):
        r"""Route data
        :rtype: list of NatDirectConnectGatewayRoute
        """
        return self._NatDirectConnectGatewayRouteSet

    @NatDirectConnectGatewayRouteSet.setter
    def NatDirectConnectGatewayRouteSet(self, NatDirectConnectGatewayRouteSet):
        self._NatDirectConnectGatewayRouteSet = NatDirectConnectGatewayRouteSet

    @property
    def Total(self):
        r"""Total number of routes
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatDirectConnectGatewayRouteSet") is not None:
            self._NatDirectConnectGatewayRouteSet = []
            for item in params.get("NatDirectConnectGatewayRouteSet"):
                obj = NatDirectConnectGatewayRoute()
                obj._deserialize(item)
                self._NatDirectConnectGatewayRouteSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewaySourceIpTranslationNatRulesRequest(AbstractModel):
    r"""DescribeNatGatewaySourceIpTranslationNatRules request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The unique ID of the NAT Gateway, such as `nat-123xx454`.
        :type NatGatewayId: str
        :param _Filters: Filter:
<li>`resource-id`: The subnet ID (such as `subnet-0yi4hekt`) or CVM ID</li>
<li>`public-ip-address`: The EIP, such as `139.199.232.238`</li>
<li>`description` The rule description</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NatGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayId(self):
        r"""The unique ID of the NAT Gateway, such as `nat-123xx454`.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def Filters(self):
        r"""Filter:
<li>`resource-id`: The subnet ID (such as `subnet-0yi4hekt`) or CVM ID</li>
<li>`public-ip-address`: The EIP, such as `139.199.232.238`</li>
<li>`description` The rule description</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaySourceIpTranslationNatRulesResponse(AbstractModel):
    r"""DescribeNatGatewaySourceIpTranslationNatRules response structure.

    """

    def __init__(self):
        r"""
        :param _SourceIpTranslationNatRuleSet: Array of objects of a NAT gateway's SNAT rules.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SourceIpTranslationNatRuleSet: list of SourceIpTranslationNatRule
        :param _TotalCount: The number of eligible object arrays of a NAT gateway's forwarding rules.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SourceIpTranslationNatRuleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SourceIpTranslationNatRuleSet(self):
        r"""Array of objects of a NAT gateway's SNAT rules.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of SourceIpTranslationNatRule
        """
        return self._SourceIpTranslationNatRuleSet

    @SourceIpTranslationNatRuleSet.setter
    def SourceIpTranslationNatRuleSet(self, SourceIpTranslationNatRuleSet):
        self._SourceIpTranslationNatRuleSet = SourceIpTranslationNatRuleSet

    @property
    def TotalCount(self):
        r"""The number of eligible object arrays of a NAT gateway's forwarding rules.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SourceIpTranslationNatRuleSet") is not None:
            self._SourceIpTranslationNatRuleSet = []
            for item in params.get("SourceIpTranslationNatRuleSet"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRuleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewaysRequest(AbstractModel):
    r"""DescribeNatGateways request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: The unified ID of the NAT gateways, such as `nat-123xx454`.
        :type NatGatewayIds: list of str
        :param _Filters: Filters. `NatGatewayIds` and `Filters` cannot be specified at the same time.
<li>nat-gateway-id - String - (Filter) The ID of the protocol port template instance, such as `nat-123xx454`.</li>
<li>vpc-id - String - (Filter) The unique ID of the VPC, such as `vpc-123xx454`.</li>
<li>nat-gateway-name - String - (Filter) The ID of the protocol port template instance, such as `test_nat`.</li>
<li>tag-key - String - (Filter) The tag key, such as `test-key`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayIds(self):
        r"""The unified ID of the NAT gateways, such as `nat-123xx454`.
        :rtype: list of str
        """
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        r"""Filters. `NatGatewayIds` and `Filters` cannot be specified at the same time.
<li>nat-gateway-id - String - (Filter) The ID of the protocol port template instance, such as `nat-123xx454`.</li>
<li>vpc-id - String - (Filter) The unique ID of the VPC, such as `vpc-123xx454`.</li>
<li>nat-gateway-name - String - (Filter) The ID of the protocol port template instance, such as `test_nat`.</li>
<li>tag-key - String - (Filter) The tag key, such as `test-key`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaysResponse(AbstractModel):
    r"""DescribeNatGateways response structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewaySet: NAT gateway object array.
        :type NatGatewaySet: list of NatGateway
        :param _TotalCount: The number of eligible NAT gateway objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewaySet(self):
        r"""NAT gateway object array.
        :rtype: list of NatGateway
        """
        return self._NatGatewaySet

    @NatGatewaySet.setter
    def NatGatewaySet(self, NatGatewaySet):
        self._NatGatewaySet = NatGatewaySet

    @property
    def TotalCount(self):
        r"""The number of eligible NAT gateway objects.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewaySet") is not None:
            self._NatGatewaySet = []
            for item in params.get("NatGatewaySet"):
                obj = NatGateway()
                obj._deserialize(item)
                self._NatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetDetectStatesRequest(AbstractModel):
    r"""DescribeNetDetectStates request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectIds: The array of network probe IDs, such as [`netd-12345678`].
        :type NetDetectIds: list of str
        :param _Filters: Filter conditions. `NetDetectIds` and `Filters` cannot be specified at the same time.
<li>`net-detect-id` - String - The network probe ID, such as `netd-12345678`.</li>
        :type Filters: list of Filter
        :param _Offset: The offset. Default: 0.
        :type Offset: int
        :param _Limit: The number of returned values. Default: 20. Maximum: 100.
        :type Limit: int
        """
        self._NetDetectIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetDetectIds(self):
        r"""The array of network probe IDs, such as [`netd-12345678`].
        :rtype: list of str
        """
        return self._NetDetectIds

    @NetDetectIds.setter
    def NetDetectIds(self, NetDetectIds):
        self._NetDetectIds = NetDetectIds

    @property
    def Filters(self):
        r"""Filter conditions. `NetDetectIds` and `Filters` cannot be specified at the same time.
<li>`net-detect-id` - String - The network probe ID, such as `netd-12345678`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The offset. Default: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of returned values. Default: 20. Maximum: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetDetectIds = params.get("NetDetectIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetDetectStatesResponse(AbstractModel):
    r"""DescribeNetDetectStates response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectStateSet: The array of network detection verification results that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetDetectStateSet: list of NetDetectState
        :param _TotalCount: The number of network detection verification results that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetectStateSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetDetectStateSet(self):
        r"""The array of network detection verification results that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NetDetectState
        """
        return self._NetDetectStateSet

    @NetDetectStateSet.setter
    def NetDetectStateSet(self, NetDetectStateSet):
        self._NetDetectStateSet = NetDetectStateSet

    @property
    def TotalCount(self):
        r"""The number of network detection verification results that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectStateSet") is not None:
            self._NetDetectStateSet = []
            for item in params.get("NetDetectStateSet"):
                obj = NetDetectState()
                obj._deserialize(item)
                self._NetDetectStateSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetDetectsRequest(AbstractModel):
    r"""DescribeNetDetects request structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectIds: The array of network probe IDs, such as [`netd-12345678`].
        :type NetDetectIds: list of str
        :param _Filters: Filter conditions. `NetDetectIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) The VPC instance ID, such as vpc-12345678.</li>
<li>net-detect-id - String - (Filter condition) The network detection instance ID, such as netd-12345678.</li>
<li>subnet-id - String - (Filter condition) The subnet instance ID, such as subnet-12345678.</li>
<li>net-detect-name - String - (Filter condition) The network detection name.</li>
        :type Filters: list of Filter
        :param _Offset: The offset. Default: 0.
        :type Offset: int
        :param _Limit: The number of returned values. Default: 20. Maximum: 100.
        :type Limit: int
        """
        self._NetDetectIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetDetectIds(self):
        r"""The array of network probe IDs, such as [`netd-12345678`].
        :rtype: list of str
        """
        return self._NetDetectIds

    @NetDetectIds.setter
    def NetDetectIds(self, NetDetectIds):
        self._NetDetectIds = NetDetectIds

    @property
    def Filters(self):
        r"""Filter conditions. `NetDetectIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) The VPC instance ID, such as vpc-12345678.</li>
<li>net-detect-id - String - (Filter condition) The network detection instance ID, such as netd-12345678.</li>
<li>subnet-id - String - (Filter condition) The subnet instance ID, such as subnet-12345678.</li>
<li>net-detect-name - String - (Filter condition) The network detection name.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The offset. Default: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of returned values. Default: 20. Maximum: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetDetectIds = params.get("NetDetectIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetDetectsResponse(AbstractModel):
    r"""DescribeNetDetects response structure.

    """

    def __init__(self):
        r"""
        :param _NetDetectSet: The array of network detection objects that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetDetectSet: list of NetDetect
        :param _TotalCount: The number of network detection objects that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetDetectSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetDetectSet(self):
        r"""The array of network detection objects that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NetDetect
        """
        return self._NetDetectSet

    @NetDetectSet.setter
    def NetDetectSet(self, NetDetectSet):
        self._NetDetectSet = NetDetectSet

    @property
    def TotalCount(self):
        r"""The number of network detection objects that meet requirements.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectSet") is not None:
            self._NetDetectSet = []
            for item in params.get("NetDetectSet"):
                obj = NetDetect()
                obj._deserialize(item)
                self._NetDetectSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAclQuintupleEntriesRequest(AbstractModel):
    r"""DescribeNetworkAclQuintupleEntries request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Returned quantity. Default: 20. Value range: 1-100.
        :type Limit: int
        :param _Filters: Filter condition. `HaVipIds` and `Filters` cannot be specified at the same time.
<li>`protocol` - String - Such as `TCP`</li>
<li>`description` - String - Description</li>
<li>`destination-cidr` - String - Destination CIDR block, such as `192.168.0.0/24`</li>
<li>`source-cidr` - String - Source CIDR block, such as `192.168.0.0/24`</li>
<li>`action` - String - ·Values: `ACCEPT`, `DROP`</li>
<li>`network-acl-quintuple-entry-id` - String - Unique ID of the quintuple, such as `acli45-ahnu4rv5`</li>
<li>`network-acl-direction` - String - Direction of the policy. Values: `INGRESS` or `EGRESS`.</li>
        :type Filters: list of Filter
        """
        self._NetworkAclId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def NetworkAclId(self):
        r"""Network ACL instance ID, such as `acl-12345678`.
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Returned quantity. Default: 20. Value range: 1-100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Filter condition. `HaVipIds` and `Filters` cannot be specified at the same time.
<li>`protocol` - String - Such as `TCP`</li>
<li>`description` - String - Description</li>
<li>`destination-cidr` - String - Destination CIDR block, such as `192.168.0.0/24`</li>
<li>`source-cidr` - String - Source CIDR block, such as `192.168.0.0/24`</li>
<li>`action` - String - ·Values: `ACCEPT`, `DROP`</li>
<li>`network-acl-quintuple-entry-id` - String - Unique ID of the quintuple, such as `acli45-ahnu4rv5`</li>
<li>`network-acl-direction` - String - Direction of the policy. Values: `INGRESS` or `EGRESS`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkAclQuintupleEntriesResponse(AbstractModel):
    r"""DescribeNetworkAclQuintupleEntries response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclQuintupleSet: The list of the network ACL quintuple entries
        :type NetworkAclQuintupleSet: list of NetworkAclQuintupleEntry
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkAclQuintupleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkAclQuintupleSet(self):
        r"""The list of the network ACL quintuple entries
        :rtype: list of NetworkAclQuintupleEntry
        """
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = []
            for item in params.get("NetworkAclQuintupleSet"):
                obj = NetworkAclQuintupleEntry()
                obj._deserialize(item)
                self._NetworkAclQuintupleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAclsRequest(AbstractModel):
    r"""DescribeNetworkAcls request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclIds: Array of network ACL instance IDs, such as [acl-12345678]. Up to 100 instances are allowed for each request. This parameter does not support specifying `NetworkAclIds` and `Filters` at the same time.
        :type NetworkAclIds: list of str
        :param _Filters: Filter condition. `NetworkAclIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as vpc-12345678.</li>
<li>network-acl-id - String - (Filter condition) Network ACL instance ID, such as acl-12345678.</li>
<li>network-acl-name - String - (Filter condition) Network ACL instance name.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default: 0.
        :type Offset: int
        :param _Limit: Returned quantity. Default: 20. Value range: 1-100.
        :type Limit: int
        """
        self._NetworkAclIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetworkAclIds(self):
        r"""Array of network ACL instance IDs, such as [acl-12345678]. Up to 100 instances are allowed for each request. This parameter does not support specifying `NetworkAclIds` and `Filters` at the same time.
        :rtype: list of str
        """
        return self._NetworkAclIds

    @NetworkAclIds.setter
    def NetworkAclIds(self, NetworkAclIds):
        self._NetworkAclIds = NetworkAclIds

    @property
    def Filters(self):
        r"""Filter condition. `NetworkAclIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as vpc-12345678.</li>
<li>network-acl-id - String - (Filter condition) Network ACL instance ID, such as acl-12345678.</li>
<li>network-acl-name - String - (Filter condition) Network ACL instance name.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Returned quantity. Default: 20. Value range: 1-100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetworkAclIds = params.get("NetworkAclIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkAclsResponse(AbstractModel):
    r"""DescribeNetworkAcls response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclSet: List of instance details.
        :type NetworkAclSet: list of NetworkAcl
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkAclSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkAclSet(self):
        r"""List of instance details.
        :rtype: list of NetworkAcl
        """
        return self._NetworkAclSet

    @NetworkAclSet.setter
    def NetworkAclSet(self, NetworkAclSet):
        self._NetworkAclSet = NetworkAclSet

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAclSet") is not None:
            self._NetworkAclSet = []
            for item in params.get("NetworkAclSet"):
                obj = NetworkAcl()
                obj._deserialize(item)
                self._NetworkAclSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkInterfaceLimitRequest(AbstractModel):
    r"""DescribeNetworkInterfaceLimit request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of a CVM instance or ENI to query
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""ID of a CVM instance or ENI to query
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkInterfaceLimitResponse(AbstractModel):
    r"""DescribeNetworkInterfaceLimit response structure.

    """

    def __init__(self):
        r"""
        :param _EniQuantity: Quota of ENIs mounted to a CVM instance in a standard way
        :type EniQuantity: int
        :param _EniPrivateIpAddressQuantity: Quota of IP addresses that can be allocated to each standard-mounted ENI
        :type EniPrivateIpAddressQuantity: int
        :param _ExtendEniQuantity: Quota of ENIs mounted to a CVM instance as an extension
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ExtendEniQuantity: int
        :param _ExtendEniPrivateIpAddressQuantity: Quota of IP addresses that can be allocated to each extension-mounted ENI.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ExtendEniPrivateIpAddressQuantity: int
        :param _SubEniQuantity: The quota of relayed ENIs
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SubEniQuantity: int
        :param _SubEniPrivateIpAddressQuantity: The quota of IPs that can be assigned to each relayed ENI.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SubEniPrivateIpAddressQuantity: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EniQuantity = None
        self._EniPrivateIpAddressQuantity = None
        self._ExtendEniQuantity = None
        self._ExtendEniPrivateIpAddressQuantity = None
        self._SubEniQuantity = None
        self._SubEniPrivateIpAddressQuantity = None
        self._RequestId = None

    @property
    def EniQuantity(self):
        r"""Quota of ENIs mounted to a CVM instance in a standard way
        :rtype: int
        """
        return self._EniQuantity

    @EniQuantity.setter
    def EniQuantity(self, EniQuantity):
        self._EniQuantity = EniQuantity

    @property
    def EniPrivateIpAddressQuantity(self):
        r"""Quota of IP addresses that can be allocated to each standard-mounted ENI
        :rtype: int
        """
        return self._EniPrivateIpAddressQuantity

    @EniPrivateIpAddressQuantity.setter
    def EniPrivateIpAddressQuantity(self, EniPrivateIpAddressQuantity):
        self._EniPrivateIpAddressQuantity = EniPrivateIpAddressQuantity

    @property
    def ExtendEniQuantity(self):
        r"""Quota of ENIs mounted to a CVM instance as an extension
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExtendEniQuantity

    @ExtendEniQuantity.setter
    def ExtendEniQuantity(self, ExtendEniQuantity):
        self._ExtendEniQuantity = ExtendEniQuantity

    @property
    def ExtendEniPrivateIpAddressQuantity(self):
        r"""Quota of IP addresses that can be allocated to each extension-mounted ENI.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExtendEniPrivateIpAddressQuantity

    @ExtendEniPrivateIpAddressQuantity.setter
    def ExtendEniPrivateIpAddressQuantity(self, ExtendEniPrivateIpAddressQuantity):
        self._ExtendEniPrivateIpAddressQuantity = ExtendEniPrivateIpAddressQuantity

    @property
    def SubEniQuantity(self):
        r"""The quota of relayed ENIs
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SubEniQuantity

    @SubEniQuantity.setter
    def SubEniQuantity(self, SubEniQuantity):
        self._SubEniQuantity = SubEniQuantity

    @property
    def SubEniPrivateIpAddressQuantity(self):
        r"""The quota of IPs that can be assigned to each relayed ENI.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SubEniPrivateIpAddressQuantity

    @SubEniPrivateIpAddressQuantity.setter
    def SubEniPrivateIpAddressQuantity(self, SubEniPrivateIpAddressQuantity):
        self._SubEniPrivateIpAddressQuantity = SubEniPrivateIpAddressQuantity

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EniQuantity = params.get("EniQuantity")
        self._EniPrivateIpAddressQuantity = params.get("EniPrivateIpAddressQuantity")
        self._ExtendEniQuantity = params.get("ExtendEniQuantity")
        self._ExtendEniPrivateIpAddressQuantity = params.get("ExtendEniPrivateIpAddressQuantity")
        self._SubEniQuantity = params.get("SubEniQuantity")
        self._SubEniPrivateIpAddressQuantity = params.get("SubEniPrivateIpAddressQuantity")
        self._RequestId = params.get("RequestId")


class DescribeNetworkInterfacesRequest(AbstractModel):
    r"""DescribeNetworkInterfaces request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: Queries the ID of the ENI instance, such as `eni-pxir56ns`. Each request can have a maximum of 100 instances. `NetworkInterfaceIds` and `Filters` cannot be specified at the same time.
        :type NetworkInterfaceIds: list of str
        :param _Filters: Filter. `NetworkInterfaceIds` and `Filters` cannot be specified at the same time.
<li>`vpc-id` - String - VPC ID, such as `vpc-f49l6u0z`. </li>
<li>`subnet-id` - String - Subnet ID, such as `subnet-f49l6u0z`. </li>
<li>`network-interface-id` - String - ENI ID, such as `eni-5k56k7k7`. </li>
<li>`attachment.instance-id` - String - ID of the bound CVM instance, such as `ins-3nqpdn3i`. </li>
<li>`groups.security-group-id` - String - ID of the bound security group, such as `sg-f9ekbxeq`. </li>
<li>`network-interface-name` - String - ENI instance name. </li>
<li>`network-interface-description` - String - ENI instance description. </li>
<li>`address-ip` - String - Private IPv4 address. A single IP will be fuzzily matched with the suffix, while multiple IPs will be exactly matched. It can be used with `ip-exact-match` to query and exactly match a single IP. </li>
<li>`ip-exact-match` - Boolean - Exact match by private IPv4 address. The first value will be returned if multiple values are found. </li>
<li>`tag-key` - String - Optional - Tag key. See Example 2 to learn more details. </li>
<li>`tag:tag-key` - String - Optional - Tag key-value pair. The `tag-key` should be replaced with a specific tag key. See Example 2 to learn more details. </li>
<li>`is-primary` - Boolean - Optional - Filter based on whether it is a primary ENI. Values: `true`, `false`. If this parameter is not specified, filter the both. </li>
<li>`eni-type` - String - Optional - Filter by ENI type. Values: `0` (Secondary ENI), `1` (Primary ENI), `2` (Relayed ENI) </li>
<li>`eni-qos` - String - Optional - Filter by ENI service level. Values: `AG` (Bronze), `AU` (Silver) </li>
<li>`address-ipv6` - String - Optional - Filter by private IPv6 address. Multiple IPv6 addresses can be used for query. If this field is used together with `address-ip`, their intersection will be used. </li>
<li>`public-address-ip` - String - Public IPv4 address. It supports exact matching. </li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._NetworkInterfaceIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetworkInterfaceIds(self):
        r"""Queries the ID of the ENI instance, such as `eni-pxir56ns`. Each request can have a maximum of 100 instances. `NetworkInterfaceIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def Filters(self):
        r"""Filter. `NetworkInterfaceIds` and `Filters` cannot be specified at the same time.
<li>`vpc-id` - String - VPC ID, such as `vpc-f49l6u0z`. </li>
<li>`subnet-id` - String - Subnet ID, such as `subnet-f49l6u0z`. </li>
<li>`network-interface-id` - String - ENI ID, such as `eni-5k56k7k7`. </li>
<li>`attachment.instance-id` - String - ID of the bound CVM instance, such as `ins-3nqpdn3i`. </li>
<li>`groups.security-group-id` - String - ID of the bound security group, such as `sg-f9ekbxeq`. </li>
<li>`network-interface-name` - String - ENI instance name. </li>
<li>`network-interface-description` - String - ENI instance description. </li>
<li>`address-ip` - String - Private IPv4 address. A single IP will be fuzzily matched with the suffix, while multiple IPs will be exactly matched. It can be used with `ip-exact-match` to query and exactly match a single IP. </li>
<li>`ip-exact-match` - Boolean - Exact match by private IPv4 address. The first value will be returned if multiple values are found. </li>
<li>`tag-key` - String - Optional - Tag key. See Example 2 to learn more details. </li>
<li>`tag:tag-key` - String - Optional - Tag key-value pair. The `tag-key` should be replaced with a specific tag key. See Example 2 to learn more details. </li>
<li>`is-primary` - Boolean - Optional - Filter based on whether it is a primary ENI. Values: `true`, `false`. If this parameter is not specified, filter the both. </li>
<li>`eni-type` - String - Optional - Filter by ENI type. Values: `0` (Secondary ENI), `1` (Primary ENI), `2` (Relayed ENI) </li>
<li>`eni-qos` - String - Optional - Filter by ENI service level. Values: `AG` (Bronze), `AU` (Silver) </li>
<li>`address-ipv6` - String - Optional - Filter by private IPv6 address. Multiple IPv6 addresses can be used for query. If this field is used together with `address-ip`, their intersection will be used. </li>
<li>`public-address-ip` - String - Public IPv4 address. It supports exact matching. </li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkInterfacesResponse(AbstractModel):
    r"""DescribeNetworkInterfaces response structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceSet: List of instance details.
        :type NetworkInterfaceSet: list of NetworkInterface
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetworkInterfaceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkInterfaceSet(self):
        r"""List of instance details.
        :rtype: list of NetworkInterface
        """
        return self._NetworkInterfaceSet

    @NetworkInterfaceSet.setter
    def NetworkInterfaceSet(self, NetworkInterfaceSet):
        self._NetworkInterfaceSet = NetworkInterfaceSet

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterfaceSet") is not None:
            self._NetworkInterfaceSet = []
            for item in params.get("NetworkInterfaceSet"):
                obj = NetworkInterface()
                obj._deserialize(item)
                self._NetworkInterfaceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeReserveIpAddressesRequest(AbstractModel):
    r"""DescribeReserveIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _ReserveIpIds: List of unique IDs of reserved private IP addresses.
        :type ReserveIpIds: list of str
        :param _Filters: Filter criteria. ReserveIpIds and Filters cannot be specified at the same time.

reserve-ip-id - String - (Filter criteria) Unique ID of a reserved private IP address, for example, rsvip-pvqgv9vi.
vpc-id - String - (Filter criteria) VPC instance ID, for example, vpc-f49l6u0z.
subnet-id - String - (Filter criteria) Subnet instance ID, for example, subnet-f49l6u0z.
address-ip - String - (Filter criteria) Reserved private IP address, for example, 192.168.0.10.
ip-type - String - (Filter criteria) Business type (IpType), for example, 0.
name - String - (Filter criteria) Name.
state - String - (Filter criteria) Status. Valid values: Bind and UnBind.
resource-id - String - (Filter criteria) Bound instance resource, for example, eni-059qmnif.
tag-key - String - (Filter criteria) Tag key.
tag:tag-key - String - (Filter criteria) Tag key-value pair. Replace tag-key with the specific tag key.

        :type Filters: list of Filter
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: Number of request objects.
        :type Limit: int
        """
        self._ReserveIpIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ReserveIpIds(self):
        r"""List of unique IDs of reserved private IP addresses.
        :rtype: list of str
        """
        return self._ReserveIpIds

    @ReserveIpIds.setter
    def ReserveIpIds(self, ReserveIpIds):
        self._ReserveIpIds = ReserveIpIds

    @property
    def Filters(self):
        r"""Filter criteria. ReserveIpIds and Filters cannot be specified at the same time.

reserve-ip-id - String - (Filter criteria) Unique ID of a reserved private IP address, for example, rsvip-pvqgv9vi.
vpc-id - String - (Filter criteria) VPC instance ID, for example, vpc-f49l6u0z.
subnet-id - String - (Filter criteria) Subnet instance ID, for example, subnet-f49l6u0z.
address-ip - String - (Filter criteria) Reserved private IP address, for example, 192.168.0.10.
ip-type - String - (Filter criteria) Business type (IpType), for example, 0.
name - String - (Filter criteria) Name.
state - String - (Filter criteria) Status. Valid values: Bind and UnBind.
resource-id - String - (Filter criteria) Bound instance resource, for example, eni-059qmnif.
tag-key - String - (Filter criteria) Tag key.
tag:tag-key - String - (Filter criteria) Tag key-value pair. Replace tag-key with the specific tag key.

        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of request objects.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ReserveIpIds = params.get("ReserveIpIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReserveIpAddressesResponse(AbstractModel):
    r"""DescribeReserveIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _ReserveIpAddressSet: Information returned from the reserved private IP address.
        :type ReserveIpAddressSet: list of ReserveIpAddressInfo
        :param _TotalCount: Number of reserved private IP addresses returned.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ReserveIpAddressSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ReserveIpAddressSet(self):
        r"""Information returned from the reserved private IP address.
        :rtype: list of ReserveIpAddressInfo
        """
        return self._ReserveIpAddressSet

    @ReserveIpAddressSet.setter
    def ReserveIpAddressSet(self, ReserveIpAddressSet):
        self._ReserveIpAddressSet = ReserveIpAddressSet

    @property
    def TotalCount(self):
        r"""Number of reserved private IP addresses returned.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReserveIpAddressSet") is not None:
            self._ReserveIpAddressSet = []
            for item in params.get("ReserveIpAddressSet"):
                obj = ReserveIpAddressInfo()
                obj._deserialize(item)
                self._ReserveIpAddressSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRoutePolicyEntriesRequest(AbstractModel):
    r"""DescribeRoutePolicyEntries request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria. RoutePolicyEntryIds and Filters cannot be specified at the same time.
<li>route-policy-id - String - (filter condition) specifies the instance id of the route reception policy, such as rrp-f49l6u0z.</li>.
<li>cidr-block - String - (filter condition) cidr (subnet part before the mask), such as 10.0.0.0/8.</li>.
<li>priority - Integer - filter condition. specifies the priority, such as 20.</li>.
<li>gateway-type - String - (filter criteria) next hop type, such as CVM.</li>.
<li>GatewayId - String - specifies the unique id of the next hop instance, such as ccn-f49l6u0z.</li>.
<li>route-type - String - (filter condition) routing type. valid values: USER (USER route), NETD (route issued by network probe), CCN (CCN route).</li>.
<li>action - String - (filter condition) specifies the action. valid values: DROP (DROP), DISABLE (receive and DISABLE), ACCEPT (receive and enable).</li>.
<li>description - String - specifies the filter condition description, such as TEST.</li>.
<li>route-policy-item-id - String - (filter condition) specifies the entry unique id of the route reception policy, such as rrpi-dq782kw7.</li>.
        :type Filters: list of Filter
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: Number of request objects.
        :type Limit: int
        :param _OrderField: Sorting field. currently only supports the priority field.
        :type OrderField: str
        :param _OrderDirection: Specifies the sorting order.
ASC: ascending order.
DESC: descending order.
        :type OrderDirection: str
        :param _RoutePolicyEntryIds: Specifies the routing strategy entry ID.
        :type RoutePolicyEntryIds: list of str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None
        self._RoutePolicyEntryIds = None

    @property
    def Filters(self):
        r"""Filter criteria. RoutePolicyEntryIds and Filters cannot be specified at the same time.
<li>route-policy-id - String - (filter condition) specifies the instance id of the route reception policy, such as rrp-f49l6u0z.</li>.
<li>cidr-block - String - (filter condition) cidr (subnet part before the mask), such as 10.0.0.0/8.</li>.
<li>priority - Integer - filter condition. specifies the priority, such as 20.</li>.
<li>gateway-type - String - (filter criteria) next hop type, such as CVM.</li>.
<li>GatewayId - String - specifies the unique id of the next hop instance, such as ccn-f49l6u0z.</li>.
<li>route-type - String - (filter condition) routing type. valid values: USER (USER route), NETD (route issued by network probe), CCN (CCN route).</li>.
<li>action - String - (filter condition) specifies the action. valid values: DROP (DROP), DISABLE (receive and DISABLE), ACCEPT (receive and enable).</li>.
<li>description - String - specifies the filter condition description, such as TEST.</li>.
<li>route-policy-item-id - String - (filter condition) specifies the entry unique id of the route reception policy, such as rrpi-dq782kw7.</li>.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of request objects.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        r"""Sorting field. currently only supports the priority field.
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""Specifies the sorting order.
ASC: ascending order.
DESC: descending order.
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection

    @property
    def RoutePolicyEntryIds(self):
        r"""Specifies the routing strategy entry ID.
        :rtype: list of str
        """
        return self._RoutePolicyEntryIds

    @RoutePolicyEntryIds.setter
    def RoutePolicyEntryIds(self, RoutePolicyEntryIds):
        self._RoutePolicyEntryIds = RoutePolicyEntryIds


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        self._RoutePolicyEntryIds = params.get("RoutePolicyEntryIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoutePolicyEntriesResponse(AbstractModel):
    r"""DescribeRoutePolicyEntries response structure.

    """

    def __init__(self):
        r"""
        :param _RoutePolicyEntrySet: Route reception policy entry list.
        :type RoutePolicyEntrySet: list of RoutePolicyEntry
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoutePolicyEntrySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RoutePolicyEntrySet(self):
        r"""Route reception policy entry list.
        :rtype: list of RoutePolicyEntry
        """
        return self._RoutePolicyEntrySet

    @RoutePolicyEntrySet.setter
    def RoutePolicyEntrySet(self, RoutePolicyEntrySet):
        self._RoutePolicyEntrySet = RoutePolicyEntrySet

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoutePolicyEntrySet") is not None:
            self._RoutePolicyEntrySet = []
            for item in params.get("RoutePolicyEntrySet"):
                obj = RoutePolicyEntry()
                obj._deserialize(item)
                self._RoutePolicyEntrySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRouteTablesRequest(AbstractModel):
    r"""DescribeRouteTables request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter condition. `RouteTableIds` and `Filters` cannot be specified at the same time.
<li>route-table-id - String - (Filter condition) Route table instance ID.</li>
<li>route-table-name - String - (Filter condition) Route table name.</li>
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>association.main - String - (Filter condition) Whether it is the main route table.</li>
<li>tag-key - String - Required: no - (Filter condition) Filter by tag key.</li>
<li>tag:tag-key - String - Required: no - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`. See Example 2 for the detailed usage.</li>
        :type Filters: list of Filter
        :param _RouteTableIds: The route table instance ID, such as `rtb-azd4dt1c`.
        :type RouteTableIds: list of str
        :param _Offset: Offset.
        :type Offset: str
        :param _Limit: The number of request objects.
        :type Limit: str
        :param _NeedRouterInfo: 
        :type NeedRouterInfo: bool
        """
        self._Filters = None
        self._RouteTableIds = None
        self._Offset = None
        self._Limit = None
        self._NeedRouterInfo = None

    @property
    def Filters(self):
        r"""Filter condition. `RouteTableIds` and `Filters` cannot be specified at the same time.
<li>route-table-id - String - (Filter condition) Route table instance ID.</li>
<li>route-table-name - String - (Filter condition) Route table name.</li>
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>association.main - String - (Filter condition) Whether it is the main route table.</li>
<li>tag-key - String - Required: no - (Filter condition) Filter by tag key.</li>
<li>tag:tag-key - String - Required: no - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`. See Example 2 for the detailed usage.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def RouteTableIds(self):
        r"""The route table instance ID, such as `rtb-azd4dt1c`.
        :rtype: list of str
        """
        return self._RouteTableIds

    @RouteTableIds.setter
    def RouteTableIds(self, RouteTableIds):
        self._RouteTableIds = RouteTableIds

    @property
    def Offset(self):
        r"""Offset.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of request objects.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedRouterInfo(self):
        r"""
        :rtype: bool
        """
        return self._NeedRouterInfo

    @NeedRouterInfo.setter
    def NeedRouterInfo(self, NeedRouterInfo):
        self._NeedRouterInfo = NeedRouterInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._RouteTableIds = params.get("RouteTableIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedRouterInfo = params.get("NeedRouterInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTablesResponse(AbstractModel):
    r"""DescribeRouteTables response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible instances.
        :type TotalCount: int
        :param _RouteTableSet: Route table object.
        :type RouteTableSet: list of RouteTable
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        r"""Route table object.
        :rtype: list of RouteTable
        """
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupAssociationStatisticsRequest(AbstractModel):
    r"""DescribeSecurityGroupAssociationStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: The Security instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups.
        :type SecurityGroupIds: list of str
        """
        self._SecurityGroupIds = None

    @property
    def SecurityGroupIds(self):
        r"""The Security instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupAssociationStatisticsResponse(AbstractModel):
    r"""DescribeSecurityGroupAssociationStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupAssociationStatisticsSet: Statistics on the instances associated with a security group.
        :type SecurityGroupAssociationStatisticsSet: list of SecurityGroupAssociationStatistics
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroupAssociationStatisticsSet = None
        self._RequestId = None

    @property
    def SecurityGroupAssociationStatisticsSet(self):
        r"""Statistics on the instances associated with a security group.
        :rtype: list of SecurityGroupAssociationStatistics
        """
        return self._SecurityGroupAssociationStatisticsSet

    @SecurityGroupAssociationStatisticsSet.setter
    def SecurityGroupAssociationStatisticsSet(self, SecurityGroupAssociationStatisticsSet):
        self._SecurityGroupAssociationStatisticsSet = SecurityGroupAssociationStatisticsSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupAssociationStatisticsSet") is not None:
            self._SecurityGroupAssociationStatisticsSet = []
            for item in params.get("SecurityGroupAssociationStatisticsSet"):
                obj = SecurityGroupAssociationStatistics()
                obj._deserialize(item)
                self._SecurityGroupAssociationStatisticsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupPoliciesRequest(AbstractModel):
    r"""DescribeSecurityGroupPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups.
        :type SecurityGroupId: str
        :param _Filters: Filters
<li>`security-group-id` - String - Security group ID in the rule.</li>
<li>`ip` - String - IP. IPV4 and IPV6 fuzzy matching is supported.</li>
<li>`address-module` - String - IP address or address group template ID.</li>
<li>`service-module` - String - Protocol port or port group template ID.</li>
<li>`protocol-type` - String - Protocol supported by the security group policy. Valid values: `TCP`, `UDP`, `ICMP`, `ICMPV6`, `GRE`, `ALL`.</li>
<li>`port` - String - Optional - Port. Fuzzy matching is supported. Query all ports when the protocol value is `ALL`.</li>
<li>`poly` - String - Policy type. Valid values: `ALL`, `ACCEPT` and `DROP`.</li>
<li>`direction` - String - Direction of the rule. Valid values: `ALL`, `INBOUND` and `OUTBOUND`.</li>
<li>`description` - String - Policy description. Fuzzy matching is supported.</li>
        :type Filters: list of Filter
        """
        self._SecurityGroupId = None
        self._Filters = None

    @property
    def SecurityGroupId(self):
        r"""The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups.
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def Filters(self):
        r"""Filters
<li>`security-group-id` - String - Security group ID in the rule.</li>
<li>`ip` - String - IP. IPV4 and IPV6 fuzzy matching is supported.</li>
<li>`address-module` - String - IP address or address group template ID.</li>
<li>`service-module` - String - Protocol port or port group template ID.</li>
<li>`protocol-type` - String - Protocol supported by the security group policy. Valid values: `TCP`, `UDP`, `ICMP`, `ICMPV6`, `GRE`, `ALL`.</li>
<li>`port` - String - Optional - Port. Fuzzy matching is supported. Query all ports when the protocol value is `ALL`.</li>
<li>`poly` - String - Policy type. Valid values: `ALL`, `ACCEPT` and `DROP`.</li>
<li>`direction` - String - Direction of the rule. Valid values: `ALL`, `INBOUND` and `OUTBOUND`.</li>
<li>`description` - String - Policy description. Fuzzy matching is supported.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupPoliciesResponse(AbstractModel):
    r"""DescribeSecurityGroupPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupPolicySet: Security group policy set.
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroupPolicySet = None
        self._RequestId = None

    @property
    def SecurityGroupPolicySet(self):
        r"""Security group policy set.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupReferencesRequest(AbstractModel):
    r"""DescribeSecurityGroupReferences request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: A set of security group instance IDs, e.g. ['sg-12345678']
        :type SecurityGroupIds: list of str
        """
        self._SecurityGroupIds = None

    @property
    def SecurityGroupIds(self):
        r"""A set of security group instance IDs, e.g. ['sg-12345678']
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupReferencesResponse(AbstractModel):
    r"""DescribeSecurityGroupReferences response structure.

    """

    def __init__(self):
        r"""
        :param _ReferredSecurityGroupSet: Referred security groups.
        :type ReferredSecurityGroupSet: list of ReferredSecurityGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ReferredSecurityGroupSet = None
        self._RequestId = None

    @property
    def ReferredSecurityGroupSet(self):
        r"""Referred security groups.
        :rtype: list of ReferredSecurityGroup
        """
        return self._ReferredSecurityGroupSet

    @ReferredSecurityGroupSet.setter
    def ReferredSecurityGroupSet(self, ReferredSecurityGroupSet):
        self._ReferredSecurityGroupSet = ReferredSecurityGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReferredSecurityGroupSet") is not None:
            self._ReferredSecurityGroupSet = []
            for item in params.get("ReferredSecurityGroupSet"):
                obj = ReferredSecurityGroup()
                obj._deserialize(item)
                self._ReferredSecurityGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupsRequest(AbstractModel):
    r"""DescribeSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: Security group ID, such as `sg-33ocnj9n`. Each request can contain up to 100 instances at a time. `SecurityGroupIds` and `Filters` cannot be specified at the same time.
        :type SecurityGroupIds: list of str
        :param _Filters: Filter conditions. `SecurityGroupIds` and `Filters` cannot be specified at the same time.
<li>security-group-id - String - (Filter condition) The security group ID.</li>
<li>project-id - Integer - (Filter condition) The project ID.</li>
<li>security-group-name - String - (Filter condition) The security group name.</li>
<li>tag-key - String - Required: no - (Filter condition) Filters by tag key. For more information, see Example 2.</li>
<li> `tag:tag-key` - String - Required: no - (Filter condition) Filters by tag key pair. For this parameter, `tag-key` will be replaced with a specific tag key. For more information, see Example 3.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: str
        :param _OrderField: Sorting field. Values: `CreatedTime`, `UpdateTime` Note: This field does not have default value.
        :type OrderField: str
        :param _OrderDirection: Sorting method Order methods. Ascending: `ASC`, Descending: `DESC`. Default: `ASC`
        :type OrderDirection: str
        """
        self._SecurityGroupIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def SecurityGroupIds(self):
        r"""Security group ID, such as `sg-33ocnj9n`. Each request can contain up to 100 instances at a time. `SecurityGroupIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Filters(self):
        r"""Filter conditions. `SecurityGroupIds` and `Filters` cannot be specified at the same time.
<li>security-group-id - String - (Filter condition) The security group ID.</li>
<li>project-id - Integer - (Filter condition) The project ID.</li>
<li>security-group-name - String - (Filter condition) The security group name.</li>
<li>tag-key - String - Required: no - (Filter condition) Filters by tag key. For more information, see Example 2.</li>
<li> `tag:tag-key` - String - Required: no - (Filter condition) Filters by tag key pair. For this parameter, `tag-key` will be replaced with a specific tag key. For more information, see Example 3.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        r"""Sorting field. Values: `CreatedTime`, `UpdateTime` Note: This field does not have default value.
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""Sorting method Order methods. Ascending: `ASC`, Descending: `DESC`. Default: `ASC`
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupsResponse(AbstractModel):
    r"""DescribeSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupSet: Security group object.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SecurityGroupSet: list of SecurityGroup
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SecurityGroupSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SecurityGroupSet(self):
        r"""Security group object.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of SecurityGroup
        """
        return self._SecurityGroupSet

    @SecurityGroupSet.setter
    def SecurityGroupSet(self, SecurityGroupSet):
        self._SecurityGroupSet = SecurityGroupSet

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupSet") is not None:
            self._SecurityGroupSet = []
            for item in params.get("SecurityGroupSet"):
                obj = SecurityGroup()
                obj._deserialize(item)
                self._SecurityGroupSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeServiceTemplateGroupsRequest(AbstractModel):
    r"""DescribeServiceTemplateGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions.
<li>service-template-group-name - String - (Filter condition) Protocol port template group name.</li>
<li>service-template-group-id - String - (Filter condition) Protocol port template group instance ID, such as `ppmg-e6dy460g`.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filter conditions.
<li>service-template-group-name - String - (Filter condition) Protocol port template group name.</li>
<li>service-template-group-id - String - (Filter condition) Protocol port template group instance ID, such as `ppmg-e6dy460g`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. The default value is 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of values to be returned. The default value is 20. Maximum is 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceTemplateGroupsResponse(AbstractModel):
    r"""DescribeServiceTemplateGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _ServiceTemplateGroupSet: Protocol port template group.
        :type ServiceTemplateGroupSet: list of ServiceTemplateGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ServiceTemplateGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ServiceTemplateGroupSet(self):
        r"""Protocol port template group.
        :rtype: list of ServiceTemplateGroup
        """
        return self._ServiceTemplateGroupSet

    @ServiceTemplateGroupSet.setter
    def ServiceTemplateGroupSet(self, ServiceTemplateGroupSet):
        self._ServiceTemplateGroupSet = ServiceTemplateGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ServiceTemplateGroupSet") is not None:
            self._ServiceTemplateGroupSet = []
            for item in params.get("ServiceTemplateGroupSet"):
                obj = ServiceTemplateGroup()
                obj._deserialize(item)
                self._ServiceTemplateGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServiceTemplatesRequest(AbstractModel):
    r"""DescribeServiceTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters
<li>service-template-name - Protocol port template name.</li>
<li>service-template-id - Protocol port template ID, such as `ppm-e6dy460g`.</li>
<li>service-port-Protocol port.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. The default value is 0.
        :type Offset: str
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filters
<li>service-template-name - Protocol port template name.</li>
<li>service-template-id - Protocol port template ID, such as `ppm-e6dy460g`.</li>
<li>service-port-Protocol port.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. The default value is 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of values to be returned. The default value is 20. Maximum is 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceTemplatesResponse(AbstractModel):
    r"""DescribeServiceTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _ServiceTemplateSet: Protocol port template object.
        :type ServiceTemplateSet: list of ServiceTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ServiceTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ServiceTemplateSet(self):
        r"""Protocol port template object.
        :rtype: list of ServiceTemplate
        """
        return self._ServiceTemplateSet

    @ServiceTemplateSet.setter
    def ServiceTemplateSet(self, ServiceTemplateSet):
        self._ServiceTemplateSet = ServiceTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ServiceTemplateSet") is not None:
            self._ServiceTemplateSet = []
            for item in params.get("ServiceTemplateSet"):
                obj = ServiceTemplate()
                obj._deserialize(item)
                self._ServiceTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSgSnapshotFileContentRequest(AbstractModel):
    r"""DescribeSgSnapshotFileContent request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _SnapshotFileId: Snapshot file ID
        :type SnapshotFileId: str
        :param _SecurityGroupId: Security group ID
        :type SecurityGroupId: str
        """
        self._SnapshotPolicyId = None
        self._SnapshotFileId = None
        self._SecurityGroupId = None

    @property
    def SnapshotPolicyId(self):
        r"""Snapshot policy IDs
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotFileId(self):
        r"""Snapshot file ID
        :rtype: str
        """
        return self._SnapshotFileId

    @SnapshotFileId.setter
    def SnapshotFileId(self, SnapshotFileId):
        self._SnapshotFileId = SnapshotFileId

    @property
    def SecurityGroupId(self):
        r"""Security group ID
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotFileId = params.get("SnapshotFileId")
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSgSnapshotFileContentResponse(AbstractModel):
    r"""DescribeSgSnapshotFileContent response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Security group ID
        :type InstanceId: str
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _SnapshotFileId: Snapshot file ID
        :type SnapshotFileId: str
        :param _BackupTime: Backup time
        :type BackupTime: str
        :param _Operator: Operator
        :type Operator: str
        :param _OriginalData: Original data
        :type OriginalData: list of SecurityGroupPolicy
        :param _BackupData: Backup data
        :type BackupData: list of SecurityGroupPolicy
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._SnapshotPolicyId = None
        self._SnapshotFileId = None
        self._BackupTime = None
        self._Operator = None
        self._OriginalData = None
        self._BackupData = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Security group ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SnapshotPolicyId(self):
        r"""Snapshot policy IDs
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotFileId(self):
        r"""Snapshot file ID
        :rtype: str
        """
        return self._SnapshotFileId

    @SnapshotFileId.setter
    def SnapshotFileId(self, SnapshotFileId):
        self._SnapshotFileId = SnapshotFileId

    @property
    def BackupTime(self):
        r"""Backup time
        :rtype: str
        """
        return self._BackupTime

    @BackupTime.setter
    def BackupTime(self, BackupTime):
        self._BackupTime = BackupTime

    @property
    def Operator(self):
        r"""Operator
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def OriginalData(self):
        r"""Original data
        :rtype: list of SecurityGroupPolicy
        """
        return self._OriginalData

    @OriginalData.setter
    def OriginalData(self, OriginalData):
        self._OriginalData = OriginalData

    @property
    def BackupData(self):
        r"""Backup data
        :rtype: list of SecurityGroupPolicy
        """
        return self._BackupData

    @BackupData.setter
    def BackupData(self, BackupData):
        self._BackupData = BackupData

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotFileId = params.get("SnapshotFileId")
        self._BackupTime = params.get("BackupTime")
        self._Operator = params.get("Operator")
        if params.get("OriginalData") is not None:
            self._OriginalData = []
            for item in params.get("OriginalData"):
                obj = SecurityGroupPolicy()
                obj._deserialize(item)
                self._OriginalData.append(obj)
        if params.get("BackupData") is not None:
            self._BackupData = []
            for item in params.get("BackupData"):
                obj = SecurityGroupPolicy()
                obj._deserialize(item)
                self._BackupData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotAttachedInstancesRequest(AbstractModel):
    r"""DescribeSnapshotAttachedInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _Filters: Filters
Values:
<li>`instance-id`: Instance ID</li>
<li>`instance-region`: Instance region</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 200.
        :type Limit: int
        """
        self._SnapshotPolicyId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SnapshotPolicyId(self):
        r"""Snapshot policy IDs
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Filters(self):
        r"""Filters
Values:
<li>`instance-id`: Instance ID</li>
<li>`instance-region`: Instance region</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 200.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotAttachedInstancesResponse(AbstractModel):
    r"""DescribeSnapshotAttachedInstances response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceSet: List of instances
        :type InstanceSet: list of SnapshotInstance
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def InstanceSet(self):
        r"""List of instances
        :rtype: list of SnapshotInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def TotalCount(self):
        r"""The number of eligible objects.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSnapshotFilesRequest(AbstractModel):
    r"""DescribeSnapshotFiles request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessType: Type of associated resource. Values: `securitygroup`
        :type BusinessType: str
        :param _InstanceId: Service instance ID. It's corresponding to the `BusinessType`. 
        :type InstanceId: str
        :param _StartDate: Start time. Format: %Y-%m-%d %H:%M:%S
        :type StartDate: str
        :param _EndDate: End time. Format: %Y-%m-%d %H:%M:%S
        :type EndDate: str
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._BusinessType = None
        self._InstanceId = None
        self._StartDate = None
        self._EndDate = None
        self._Offset = None
        self._Limit = None

    @property
    def BusinessType(self):
        r"""Type of associated resource. Values: `securitygroup`
        :rtype: str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def InstanceId(self):
        r"""Service instance ID. It's corresponding to the `BusinessType`. 
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartDate(self):
        r"""Start time. Format: %Y-%m-%d %H:%M:%S
        :rtype: str
        """
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        r"""End time. Format: %Y-%m-%d %H:%M:%S
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def Offset(self):
        r"""Offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BusinessType = params.get("BusinessType")
        self._InstanceId = params.get("InstanceId")
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotFilesResponse(AbstractModel):
    r"""DescribeSnapshotFiles response structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotFileSet: Snapshot files
        :type SnapshotFileSet: list of SnapshotFileInfo
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SnapshotFileSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SnapshotFileSet(self):
        r"""Snapshot files
        :rtype: list of SnapshotFileInfo
        """
        return self._SnapshotFileSet

    @SnapshotFileSet.setter
    def SnapshotFileSet(self, SnapshotFileSet):
        self._SnapshotFileSet = SnapshotFileSet

    @property
    def TotalCount(self):
        r"""The number of eligible objects.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotFileSet") is not None:
            self._SnapshotFileSet = []
            for item in params.get("SnapshotFileSet"):
                obj = SnapshotFileInfo()
                obj._deserialize(item)
                self._SnapshotFileSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSnapshotPoliciesRequest(AbstractModel):
    r"""DescribeSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        :param _Filters: Filter conditions. `SnapshotPolicyIds` and `Filters` cannot be both specified.
<li>`snapshot-policy-id` - String - Snapshot policy ID</li>
<li>`snapshot-policy-name` - String - Snapshot policy name</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 200.
        :type Limit: int
        """
        self._SnapshotPolicyIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SnapshotPolicyIds(self):
        r"""Snapshot policy IDs
        :rtype: list of str
        """
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds

    @property
    def Filters(self):
        r"""Filter conditions. `SnapshotPolicyIds` and `Filters` cannot be both specified.
<li>`snapshot-policy-id` - String - Snapshot policy ID</li>
<li>`snapshot-policy-name` - String - Snapshot policy name</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 200.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotPoliciesResponse(AbstractModel):
    r"""DescribeSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicySet: Snapshot policies
        :type SnapshotPolicySet: list of SnapshotPolicy
        :param _TotalCount: The number of eligible objects.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SnapshotPolicySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SnapshotPolicySet(self):
        r"""Snapshot policies
        :rtype: list of SnapshotPolicy
        """
        return self._SnapshotPolicySet

    @SnapshotPolicySet.setter
    def SnapshotPolicySet(self, SnapshotPolicySet):
        self._SnapshotPolicySet = SnapshotPolicySet

    @property
    def TotalCount(self):
        r"""The number of eligible objects.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotPolicySet") is not None:
            self._SnapshotPolicySet = []
            for item in params.get("SnapshotPolicySet"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSubnetResourceDashboardRequest(AbstractModel):
    r"""DescribeSubnetResourceDashboard request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetIds: Subnet instance ID, such as `subnet-f1xjkw1b`.
        :type SubnetIds: list of str
        """
        self._SubnetIds = None

    @property
    def SubnetIds(self):
        r"""Subnet instance ID, such as `subnet-f1xjkw1b`.
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetResourceDashboardResponse(AbstractModel):
    r"""DescribeSubnetResourceDashboard response structure.

    """

    def __init__(self):
        r"""
        :param _ResourceStatisticsSet: Information of resources returned
        :type ResourceStatisticsSet: list of ResourceStatistics
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ResourceStatisticsSet = None
        self._RequestId = None

    @property
    def ResourceStatisticsSet(self):
        r"""Information of resources returned
        :rtype: list of ResourceStatistics
        """
        return self._ResourceStatisticsSet

    @ResourceStatisticsSet.setter
    def ResourceStatisticsSet(self, ResourceStatisticsSet):
        self._ResourceStatisticsSet = ResourceStatisticsSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceStatisticsSet") is not None:
            self._ResourceStatisticsSet = []
            for item in params.get("ResourceStatisticsSet"):
                obj = ResourceStatistics()
                obj._deserialize(item)
                self._ResourceStatisticsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubnetsRequest(AbstractModel):
    r"""DescribeSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _SubnetIds: Queries the ID of the subnet instance, such as `subnet-pxir56ns`. Each request can have a maximum of 100 instances. `SubnetIds` and `Filters` cannot be specified at the same time.
        :type SubnetIds: list of str
        :param _Filters: Filter condition. `SubnetIds` and `Filters` cannot be specified at the same time.
<li>subnet-id - String - (Filter condition) Subnet instance name.</li>
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>cidr-block - String - (Filter condition) Subnet IP range, such as `192.168.1.0`.</li>
<li>is-default - Boolean - (Filter condition) Whether it is the default subnet.</li>
<li>is-remote-vpc-snat - Boolean - (Filter condition) Whether it is a VPC SNAT address pool subnet.</li>
<li>subnet-name - String - (Filter condition) Subnet name.</li>
<li>zone - String - (Filter condition) Availability zone.</li>
<li> tag-key - String - Required: No - (Filter condition) Filter by tag key.</li>
<li>tag:tag-key - String - Required: No - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`. For its usage, see example 2.</li>
<li>cdc-id - String - Required: No - (Filter condition) Filter by CDC ID to obtain subnets in the specified CDC.</li>
<li>is-cdc-subnet - String - Required: No - (Filter condition) Whether it is a CDC subnet. Valid values: `0` (no); `1` (yes).</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: str
        """
        self._SubnetIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SubnetIds(self):
        r"""Queries the ID of the subnet instance, such as `subnet-pxir56ns`. Each request can have a maximum of 100 instances. `SubnetIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def Filters(self):
        r"""Filter condition. `SubnetIds` and `Filters` cannot be specified at the same time.
<li>subnet-id - String - (Filter condition) Subnet instance name.</li>
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>cidr-block - String - (Filter condition) Subnet IP range, such as `192.168.1.0`.</li>
<li>is-default - Boolean - (Filter condition) Whether it is the default subnet.</li>
<li>is-remote-vpc-snat - Boolean - (Filter condition) Whether it is a VPC SNAT address pool subnet.</li>
<li>subnet-name - String - (Filter condition) Subnet name.</li>
<li>zone - String - (Filter condition) Availability zone.</li>
<li> tag-key - String - Required: No - (Filter condition) Filter by tag key.</li>
<li>tag:tag-key - String - Required: No - (Filter condition) Filter by tag key-value pair. Use a specific tag key to replace `tag-key`. For its usage, see example 2.</li>
<li>cdc-id - String - Required: No - (Filter condition) Filter by CDC ID to obtain subnets in the specified CDC.</li>
<li>is-cdc-subnet - String - Required: No - (Filter condition) Whether it is a CDC subnet. Valid values: `0` (no); `1` (yes).</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubnetIds = params.get("SubnetIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetsResponse(AbstractModel):
    r"""DescribeSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _SubnetSet: Subnet object.
        :type SubnetSet: list of Subnet
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SubnetSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SubnetSet(self):
        r"""Subnet object.
        :rtype: list of Subnet
        """
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskResultRequest(AbstractModel):
    r"""DescribeTaskResult request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Async task ID. Either TaskId or DealName must be entered.
        :type TaskId: int
        :param _DealName: Billing order No. Either TaskId or DealName must be entered.
        :type DealName: str
        """
        self._TaskId = None
        self._DealName = None

    @property
    def TaskId(self):
        r"""Async task ID. Either TaskId or DealName must be entered.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DealName(self):
        r"""Billing order No. Either TaskId or DealName must be entered.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DealName = params.get("DealName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskResultResponse(AbstractModel):
    r"""DescribeTaskResult response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Job ID
        :type TaskId: int
        :param _Result: The execution results, including `SUCCESS`, `FAILED`, and `RUNNING`
        :type Result: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Job ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        r"""The execution results, including `SUCCESS`, `FAILED`, and `RUNNING`
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DescribeTrafficPackagesRequest(AbstractModel):
    r"""DescribeTrafficPackages request structure.

    """

    def __init__(self):
        r"""
        :param _TrafficPackageIds: Traffic package IDs. Multiple values can be used.
        :type TrafficPackageIds: list of str
        :param _Filters: Each request can have up to 10 `Filters`. `TrafficPackageIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li> `traffic-package_id` - String - Optional - Filter by the traffic package ID.</li>
<li> `traffic-package-name` - String - Optional - Filter by the traffic package name. Fuzzy match is not supported.</li>
<li> `status` - String - Optional - Filter by the traffic package status. Values: [AVAILABLE|EXPIRED|EXHAUSTED].</li>
        :type Filters: list of Filter
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _Limit: Pagination parameter
        :type Limit: int
        """
        self._TrafficPackageIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def TrafficPackageIds(self):
        r"""Traffic package IDs. Multiple values can be used.
        :rtype: list of str
        """
        return self._TrafficPackageIds

    @TrafficPackageIds.setter
    def TrafficPackageIds(self, TrafficPackageIds):
        self._TrafficPackageIds = TrafficPackageIds

    @property
    def Filters(self):
        r"""Each request can have up to 10 `Filters`. `TrafficPackageIds` and `Filters` cannot be specified at the same time. The specific filter conditions are as follows:
<li> `traffic-package_id` - String - Optional - Filter by the traffic package ID.</li>
<li> `traffic-package-name` - String - Optional - Filter by the traffic package name. Fuzzy match is not supported.</li>
<li> `status` - String - Optional - Filter by the traffic package status. Values: [AVAILABLE|EXPIRED|EXHAUSTED].</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Pagination parameter
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination parameter
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TrafficPackageIds = params.get("TrafficPackageIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrafficPackagesResponse(AbstractModel):
    r"""DescribeTrafficPackages response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible traffic packages
        :type TotalCount: int
        :param _TrafficPackageSet: Traffic package information
        :type TrafficPackageSet: list of TrafficPackage
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TrafficPackageSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible traffic packages
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TrafficPackageSet(self):
        r"""Traffic package information
        :rtype: list of TrafficPackage
        """
        return self._TrafficPackageSet

    @TrafficPackageSet.setter
    def TrafficPackageSet(self, TrafficPackageSet):
        self._TrafficPackageSet = TrafficPackageSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TrafficPackageSet") is not None:
            self._TrafficPackageSet = []
            for item in params.get("TrafficPackageSet"):
                obj = TrafficPackage()
                obj._deserialize(item)
                self._TrafficPackageSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUsedIpAddressRequest(AbstractModel):
    r"""DescribeUsedIpAddress request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC instance ID.
        :type VpcId: str
        :param _SubnetId: Subnet instance ID
        :type SubnetId: str
        :param _IpAddresses: List of IPs to be queried. The IPs must be within the VPC or subnet. Up to 100 IPs can be queried at a time.
        :type IpAddresses: list of str
        :param _Offset: The offset. Default value: 0
        :type Offset: int
        :param _Limit: The number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._IpAddresses = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcId(self):
        r"""VPC instance ID.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet instance ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def IpAddresses(self):
        r"""List of IPs to be queried. The IPs must be within the VPC or subnet. Up to 100 IPs can be queried at a time.
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def Offset(self):
        r"""The offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of returned results. Default value: 20. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._IpAddresses = params.get("IpAddresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsedIpAddressResponse(AbstractModel):
    r"""DescribeUsedIpAddress response structure.

    """

    def __init__(self):
        r"""
        :param _IpAddressStates: Information of resources bound with the queried IPs 
Note: This parameter may return null, indicating that no valid values can be obtained.
        :type IpAddressStates: list of IpAddressStates
        :param _TotalCount: Number of taken IPs 
Note: This parameter may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IpAddressStates = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IpAddressStates(self):
        r"""Information of resources bound with the queried IPs 
Note: This parameter may return null, indicating that no valid values can be obtained.
        :rtype: list of IpAddressStates
        """
        return self._IpAddressStates

    @IpAddressStates.setter
    def IpAddressStates(self, IpAddressStates):
        self._IpAddressStates = IpAddressStates

    @property
    def TotalCount(self):
        r"""Number of taken IPs 
Note: This parameter may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IpAddressStates") is not None:
            self._IpAddressStates = []
            for item in params.get("IpAddressStates"):
                obj = IpAddressStates()
                obj._deserialize(item)
                self._IpAddressStates.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointRequest(AbstractModel):
    r"""DescribeVpcEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter condition
<li> end-point-service-id - String - (Filter condition) Endpoint service ID.</li>
<li>end-point-name - String - (Filter condition) Endpoint instance name.</li>
<li> end-point-id - String - (Filter condition) Endpoint instance ID.</li>
<li> vpc-id - String - (Filter condition) VPC instance ID.</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results per page; default value: 20; maximum value: 100.
        :type Limit: int
        :param _EndPointId: Endpoint ID list
        :type EndPointId: list of str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._EndPointId = None

    @property
    def Filters(self):
        r"""Filter condition
<li> end-point-service-id - String - (Filter condition) Endpoint service ID.</li>
<li>end-point-name - String - (Filter condition) Endpoint instance name.</li>
<li> end-point-id - String - (Filter condition) Endpoint instance ID.</li>
<li> vpc-id - String - (Filter condition) VPC instance ID.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of results per page; default value: 20; maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def EndPointId(self):
        r"""Endpoint ID list
        :rtype: list of str
        """
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointResponse(AbstractModel):
    r"""DescribeVpcEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _EndPointSet: Endpoint
        :type EndPointSet: list of EndPoint
        :param _TotalCount: Number of matched endpoints
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPointSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EndPointSet(self):
        r"""Endpoint
        :rtype: list of EndPoint
        """
        return self._EndPointSet

    @EndPointSet.setter
    def EndPointSet(self, EndPointSet):
        self._EndPointSet = EndPointSet

    @property
    def TotalCount(self):
        r"""Number of matched endpoints
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointSet") is not None:
            self._EndPointSet = []
            for item in params.get("EndPointSet"):
                obj = EndPoint()
                obj._deserialize(item)
                self._EndPointSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointServiceRequest(AbstractModel):
    r"""DescribeVpcEndPointService request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters. `EndPointServiceIds` and `Filters` cannot be both passed in. 
<li>`service-id` - String - Unique endpoint service ID. </li>
<li>`service-name` - String - Endpoint service instance name. </li>
<li>`service-instance-id` - String - Unique backend service ID in the format of `lb-xxx`. </li>
<li>`service-type` - String - Backend PaaS service type. It can be `CLB`, `CDB` or `CRS`. It defaults to `CLB` if not specified. </li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results per page; default value: 20; maximum value: 100.
        :type Limit: int
        :param _EndPointServiceIds: Endpoint service ID `EndPointServiceIds` and `Filters` cannot be both passed in. 
        :type EndPointServiceIds: list of str
        :param _IsListAuthorizedEndPointService: 
        :type IsListAuthorizedEndPointService: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._EndPointServiceIds = None
        self._IsListAuthorizedEndPointService = None

    @property
    def Filters(self):
        r"""Filters. `EndPointServiceIds` and `Filters` cannot be both passed in. 
<li>`service-id` - String - Unique endpoint service ID. </li>
<li>`service-name` - String - Endpoint service instance name. </li>
<li>`service-instance-id` - String - Unique backend service ID in the format of `lb-xxx`. </li>
<li>`service-type` - String - Backend PaaS service type. It can be `CLB`, `CDB` or `CRS`. It defaults to `CLB` if not specified. </li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of results per page; default value: 20; maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def EndPointServiceIds(self):
        r"""Endpoint service ID `EndPointServiceIds` and `Filters` cannot be both passed in. 
        :rtype: list of str
        """
        return self._EndPointServiceIds

    @EndPointServiceIds.setter
    def EndPointServiceIds(self, EndPointServiceIds):
        self._EndPointServiceIds = EndPointServiceIds

    @property
    def IsListAuthorizedEndPointService(self):
        r"""
        :rtype: bool
        """
        return self._IsListAuthorizedEndPointService

    @IsListAuthorizedEndPointService.setter
    def IsListAuthorizedEndPointService(self, IsListAuthorizedEndPointService):
        self._IsListAuthorizedEndPointService = IsListAuthorizedEndPointService


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._EndPointServiceIds = params.get("EndPointServiceIds")
        self._IsListAuthorizedEndPointService = params.get("IsListAuthorizedEndPointService")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointServiceResponse(AbstractModel):
    r"""DescribeVpcEndPointService response structure.

    """

    def __init__(self):
        r"""
        :param _EndPointServiceSet: Array of endpoint services
        :type EndPointServiceSet: list of EndPointService
        :param _TotalCount: Number of matched results
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EndPointServiceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EndPointServiceSet(self):
        r"""Array of endpoint services
        :rtype: list of EndPointService
        """
        return self._EndPointServiceSet

    @EndPointServiceSet.setter
    def EndPointServiceSet(self, EndPointServiceSet):
        self._EndPointServiceSet = EndPointServiceSet

    @property
    def TotalCount(self):
        r"""Number of matched results
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointServiceSet") is not None:
            self._EndPointServiceSet = []
            for item in params.get("EndPointServiceSet"):
                obj = EndPointService()
                obj._deserialize(item)
                self._EndPointServiceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointServiceWhiteListRequest(AbstractModel):
    r"""DescribeVpcEndPointServiceWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results per page; default value: 20; maximum value: 100.
        :type Limit: int
        :param _Filters: Filter condition
<li> user-uin - String - (Filter condition) UIN.</li>
<li> end-point-service-id - String - (Filter condition) Endpoint service ID.</li>
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of results per page; default value: 20; maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Filter condition
<li> user-uin - String - (Filter condition) UIN.</li>
<li> end-point-service-id - String - (Filter condition) Endpoint service ID.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointServiceWhiteListResponse(AbstractModel):
    r"""DescribeVpcEndPointServiceWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _VpcEndpointServiceUserSet: Array of allowed endpoint services
        :type VpcEndpointServiceUserSet: list of VpcEndPointServiceUser
        :param _TotalCount: Number of matched allowlists
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpcEndpointServiceUserSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def VpcEndpointServiceUserSet(self):
        r"""Array of allowed endpoint services
        :rtype: list of VpcEndPointServiceUser
        """
        return self._VpcEndpointServiceUserSet

    @VpcEndpointServiceUserSet.setter
    def VpcEndpointServiceUserSet(self, VpcEndpointServiceUserSet):
        self._VpcEndpointServiceUserSet = VpcEndpointServiceUserSet

    @property
    def TotalCount(self):
        r"""Number of matched allowlists
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcEndpointServiceUserSet") is not None:
            self._VpcEndpointServiceUserSet = []
            for item in params.get("VpcEndpointServiceUserSet"):
                obj = VpcEndPointServiceUser()
                obj._deserialize(item)
                self._VpcEndpointServiceUserSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcInstancesRequest(AbstractModel):
    r"""DescribeVpcInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter condition. `RouteTableIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>instance-type - String - (Filter condition) CVM instance ID.</li>
<li>instance-name - String - (Filter condition) CVM name.</li>
        :type Filters: list of Filter
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The number of requested objects.
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filter condition. `RouteTableIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>instance-type - String - (Filter condition) CVM instance ID.</li>
<li>instance-name - String - (Filter condition) CVM name.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of requested objects.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcInstancesResponse(AbstractModel):
    r"""DescribeVpcInstances response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceSet: List of CVM instances.
        :type InstanceSet: list of CvmInstance
        :param _TotalCount: The number of eligible CVM instances.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def InstanceSet(self):
        r"""List of CVM instances.
        :rtype: list of CvmInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def TotalCount(self):
        r"""The number of eligible CVM instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CvmInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcIpv6AddressesRequest(AbstractModel):
    r"""DescribeVpcIpv6Addresses request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :type VpcId: str
        :param _Ipv6Addresses: The `IP` address list. Each request supports a maximum of `10` batch querying.
        :type Ipv6Addresses: list of str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity.
        :type Limit: int
        """
        self._VpcId = None
        self._Ipv6Addresses = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcId(self):
        r"""The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Ipv6Addresses(self):
        r"""The `IP` address list. Each request supports a maximum of `10` batch querying.
        :rtype: list of str
        """
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Ipv6Addresses = params.get("Ipv6Addresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcIpv6AddressesResponse(AbstractModel):
    r"""DescribeVpcIpv6Addresses response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6AddressSet: The `IPv6` address list.
        :type Ipv6AddressSet: list of VpcIpv6Address
        :param _TotalCount: The total number of `IPv6` addresses.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6AddressSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Ipv6AddressSet(self):
        r"""The `IPv6` address list.
        :rtype: list of VpcIpv6Address
        """
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def TotalCount(self):
        r"""The total number of `IPv6` addresses.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = VpcIpv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcPrivateIpAddressesRequest(AbstractModel):
    r"""DescribeVpcPrivateIpAddresses request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :type VpcId: str
        :param _PrivateIpAddresses: The private `IP` address list. Each request supports a maximum of `10` batch querying.
        :type PrivateIpAddresses: list of str
        """
        self._VpcId = None
        self._PrivateIpAddresses = None

    @property
    def VpcId(self):
        r"""The `ID` of the `VPC`, such as `vpc-f49l6u0z`.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PrivateIpAddresses(self):
        r"""The private `IP` address list. Each request supports a maximum of `10` batch querying.
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcPrivateIpAddressesResponse(AbstractModel):
    r"""DescribeVpcPrivateIpAddresses response structure.

    """

    def __init__(self):
        r"""
        :param _VpcPrivateIpAddressSet: The list of private `IP` address information.
        :type VpcPrivateIpAddressSet: list of VpcPrivateIpAddress
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VpcPrivateIpAddressSet = None
        self._RequestId = None

    @property
    def VpcPrivateIpAddressSet(self):
        r"""The list of private `IP` address information.
        :rtype: list of VpcPrivateIpAddress
        """
        return self._VpcPrivateIpAddressSet

    @VpcPrivateIpAddressSet.setter
    def VpcPrivateIpAddressSet(self, VpcPrivateIpAddressSet):
        self._VpcPrivateIpAddressSet = VpcPrivateIpAddressSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcPrivateIpAddressSet") is not None:
            self._VpcPrivateIpAddressSet = []
            for item in params.get("VpcPrivateIpAddressSet"):
                obj = VpcPrivateIpAddress()
                obj._deserialize(item)
                self._VpcPrivateIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcResourceDashboardRequest(AbstractModel):
    r"""DescribeVpcResourceDashboard request structure.

    """

    def __init__(self):
        r"""
        :param _VpcIds: Vpc instance ID, e.g. vpc-f1xjkw1b.
        :type VpcIds: list of str
        """
        self._VpcIds = None

    @property
    def VpcIds(self):
        r"""Vpc instance ID, e.g. vpc-f1xjkw1b.
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcResourceDashboardResponse(AbstractModel):
    r"""DescribeVpcResourceDashboard response structure.

    """

    def __init__(self):
        r"""
        :param _ResourceDashboardSet: List of resource objects.
        :type ResourceDashboardSet: list of ResourceDashboard
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ResourceDashboardSet = None
        self._RequestId = None

    @property
    def ResourceDashboardSet(self):
        r"""List of resource objects.
        :rtype: list of ResourceDashboard
        """
        return self._ResourceDashboardSet

    @ResourceDashboardSet.setter
    def ResourceDashboardSet(self, ResourceDashboardSet):
        self._ResourceDashboardSet = ResourceDashboardSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceDashboardSet") is not None:
            self._ResourceDashboardSet = []
            for item in params.get("ResourceDashboardSet"):
                obj = ResourceDashboard()
                obj._deserialize(item)
                self._ResourceDashboardSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcTaskResultRequest(AbstractModel):
    r"""DescribeVpcTaskResult request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: `RequestId` returned by an async task
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""`RequestId` returned by an async task
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcTaskResultResponse(AbstractModel):
    r"""DescribeVpcTaskResult response structure.

    """

    def __init__(self):
        r"""
        :param _Status: The execution results of an async task. Valid values: `SUCCESS`(task executed successfully), `FAILED` (task execution failed), and `RUNNING` (task in progress). 
        :type Status: str
        :param _Output: Output of the async task execution result
        :type Output: str
        :param _Result: Detailed result of an async task, such as the result of batch deleting ENIs.
Note: this field may return `null`, indicating that no valid value can be obtained.
        :type Result: list of VpcTaskResultDetailInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Output = None
        self._Result = None
        self._RequestId = None

    @property
    def Status(self):
        r"""The execution results of an async task. Valid values: `SUCCESS`(task executed successfully), `FAILED` (task execution failed), and `RUNNING` (task in progress). 
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Output(self):
        r"""Output of the async task execution result
        :rtype: str
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Result(self):
        r"""Detailed result of an async task, such as the result of batch deleting ENIs.
Note: this field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of VpcTaskResultDetailInfo
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Output = params.get("Output")
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = VpcTaskResultDetailInfo()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcsRequest(AbstractModel):
    r"""DescribeVpcs request structure.

    """

    def __init__(self):
        r"""
        :param _VpcIds: The VPC instance ID, such as `vpc-f49l6u0z`. Each request supports a maximum of 100 instances. `VpcIds` and `Filters` cannot be specified at the same time.
        :type VpcIds: list of str
        :param _Filters: Filter condition. `VpcIds` and `Filters` cannot be specified at the same time.
Valid filters include:
<li>`vpc-name`: VPC instance name, which supports fuzzy search.</li>
<li>`is-default`: Indicates whether it is the default VPC</li>
<li>`vpc-id`: VPC instance ID, such as `vpc-f49l6u0z`</li>
<li>`cidr-block`: VPC CIDR block</li>
<li>`tag-key`: (Optional) tag key</li>
<li>`tag:tag-key`: (Optional) tag key-value pair. Replace the `tag-key` with a specified tag value. For its usage, refer to Example 2.</li>
  **Note:** If one filter has multiple values, the logical relationship between these values is `OR`. The logical relationship between filters is `AND`.
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100.
        :type Limit: str
        """
        self._VpcIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcIds(self):
        r"""The VPC instance ID, such as `vpc-f49l6u0z`. Each request supports a maximum of 100 instances. `VpcIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def Filters(self):
        r"""Filter condition. `VpcIds` and `Filters` cannot be specified at the same time.
Valid filters include:
<li>`vpc-name`: VPC instance name, which supports fuzzy search.</li>
<li>`is-default`: Indicates whether it is the default VPC</li>
<li>`vpc-id`: VPC instance ID, such as `vpc-f49l6u0z`</li>
<li>`cidr-block`: VPC CIDR block</li>
<li>`tag-key`: (Optional) tag key</li>
<li>`tag:tag-key`: (Optional) tag key-value pair. Replace the `tag-key` with a specified tag value. For its usage, refer to Example 2.</li>
  **Note:** If one filter has multiple values, the logical relationship between these values is `OR`. The logical relationship between filters is `AND`.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcsResponse(AbstractModel):
    r"""DescribeVpcs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of objects meeting the condition.
        :type TotalCount: int
        :param _VpcSet: The VPC object.
        :type VpcSet: list of Vpc
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpcSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of objects meeting the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpcSet(self):
        r"""The VPC object.
        :rtype: list of Vpc
        """
        return self._VpcSet

    @VpcSet.setter
    def VpcSet(self, VpcSet):
        self._VpcSet = VpcSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpcSet") is not None:
            self._VpcSet = []
            for item in params.get("VpcSet"):
                obj = Vpc()
                obj._deserialize(item)
                self._VpcSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpnConnectionsRequest(AbstractModel):
    r"""DescribeVpnConnections request structure.

    """

    def __init__(self):
        r"""
        :param _VpnConnectionIds: The instance ID of the VPN tunnel, such as `vpnx-f49l6u0z`. Each request can have a maximum of 100 instances. `VpnConnectionIds` and `Filters` cannot be specified at the same time.
        :type VpnConnectionIds: list of str
        :param _Filters: Filter condition. In each request, the upper limit for `Filters` is 10 and 5 for `Filter.Values`. `VpnConnectionIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - VPC instance ID, such as `vpc-0a36uwkr`.</li>
<li>vpn-gateway-id - String - VPN gateway instance ID, such as `vpngw-p4lmqawn`.</li>
<li>customer-gateway-id - String - Customer gateway instance ID, such as `cgw-l4rblw63`.</li>
<li>vpn-connection-name - String - Connection name, such as `test-vpn`.</li>
<li>vpn-connection-id - String - Connection instance ID, such as `vpnx-5p7vkch8"`.</li>
        :type Filters: list of Filter
        :param _Offset: The Offset. The default value is 0. For more information about Offset, see the relevant section in the API Introduction.
        :type Offset: int
        :param _Limit: Number of values to be returned. The default value is 20. Maximum is 100.
        :type Limit: int
        """
        self._VpnConnectionIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnConnectionIds(self):
        r"""The instance ID of the VPN tunnel, such as `vpnx-f49l6u0z`. Each request can have a maximum of 100 instances. `VpnConnectionIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._VpnConnectionIds

    @VpnConnectionIds.setter
    def VpnConnectionIds(self, VpnConnectionIds):
        self._VpnConnectionIds = VpnConnectionIds

    @property
    def Filters(self):
        r"""Filter condition. In each request, the upper limit for `Filters` is 10 and 5 for `Filter.Values`. `VpnConnectionIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - VPC instance ID, such as `vpc-0a36uwkr`.</li>
<li>vpn-gateway-id - String - VPN gateway instance ID, such as `vpngw-p4lmqawn`.</li>
<li>customer-gateway-id - String - Customer gateway instance ID, such as `cgw-l4rblw63`.</li>
<li>vpn-connection-name - String - Connection name, such as `test-vpn`.</li>
<li>vpn-connection-id - String - Connection instance ID, such as `vpnx-5p7vkch8"`.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""The Offset. The default value is 0. For more information about Offset, see the relevant section in the API Introduction.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of values to be returned. The default value is 20. Maximum is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnConnectionIds = params.get("VpnConnectionIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnConnectionsResponse(AbstractModel):
    r"""DescribeVpnConnections response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _VpnConnectionSet: VPN tunnel instance.
        :type VpnConnectionSet: list of VpnConnection
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpnConnectionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpnConnectionSet(self):
        r"""VPN tunnel instance.
        :rtype: list of VpnConnection
        """
        return self._VpnConnectionSet

    @VpnConnectionSet.setter
    def VpnConnectionSet(self, VpnConnectionSet):
        self._VpnConnectionSet = VpnConnectionSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpnConnectionSet") is not None:
            self._VpnConnectionSet = []
            for item in params.get("VpnConnectionSet"):
                obj = VpnConnection()
                obj._deserialize(item)
                self._VpnConnectionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewayCcnRoutesRequest(AbstractModel):
    r"""DescribeVpnGatewayCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The returned quantity
        :type Limit: int
        """
        self._VpnGatewayId = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayId(self):
        r"""Instance ID of the VPN gateway
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The returned quantity
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewayCcnRoutesResponse(AbstractModel):
    r"""DescribeVpnGatewayCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RouteSet: The CCN route (IDC IP range) list.
        :type RouteSet: list of VpngwCcnRoutes
        :param _TotalCount: Number of objects that meet the condition.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RouteSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RouteSet(self):
        r"""The CCN route (IDC IP range) list.
        :rtype: list of VpngwCcnRoutes
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def TotalCount(self):
        r"""Number of objects that meet the condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = VpngwCcnRoutes()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewayRoutesRequest(AbstractModel):
    r"""DescribeVpnGatewayRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: Instance ID of the VPN gateway
        :type VpnGatewayId: str
        :param _Filters: Filter condition. Valid values: `DestinationCidr`, `InstanceId`, and `InstanceType`.
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Limit: Number of returned results per page. Default value: 20; maximum value: 100
        :type Limit: int
        """
        self._VpnGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayId(self):
        r"""Instance ID of the VPN gateway
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Filters(self):
        r"""Filter condition. Valid values: `DestinationCidr`, `InstanceId`, and `InstanceType`.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results per page. Default value: 20; maximum value: 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewayRoutesResponse(AbstractModel):
    r"""DescribeVpnGatewayRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _Routes: Destination routes of the VPN gateway
        :type Routes: list of VpnGatewayRoute
        :param _TotalCount: 
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Routes = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Routes(self):
        r"""Destination routes of the VPN gateway
        :rtype: list of VpnGatewayRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes

    @property
    def TotalCount(self):
        r"""
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewaysRequest(AbstractModel):
    r"""DescribeVpnGateways request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayIds: The VPN gateway instance ID, such as `vpngw-f49l6u0z`. Each request can have a maximum of 100 instances. `VpnGatewayIds` and `Filters` cannot be specified at the same time.
        :type VpnGatewayIds: list of str
        :param _Filters: Filter condition. `VpnGatewayIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>vpn-gateway-id - String - (Filter condition) VPN instance ID, such as `vpngw-5aluhh9t`.</li>
<li>vpn-gateway-name - String - (Filter condition) VPN instance name.</li>
<li>type - String - (Filter condition) VPN gateway type: 'IPSEC', 'SSL'.</li>
<li>public-ip-address- String - (Filter condition) Public IP.</li>
<li>renew-flag - String - (Filter condition) Gateway renewal type. Manual renewal: `NOTIFY_AND_MANUAL_RENEW`, Automatic renewal: `NOTIFY_AND_AUTO_RENEW`.</li>
<li>zone - String - (Filter condition) The availability zone where the VPN is located, such as `ap-guangzhou-2`.</li>
        :type Filters: list of FilterObject
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The number of request objects.
        :type Limit: int
        """
        self._VpnGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayIds(self):
        r"""The VPN gateway instance ID, such as `vpngw-f49l6u0z`. Each request can have a maximum of 100 instances. `VpnGatewayIds` and `Filters` cannot be specified at the same time.
        :rtype: list of str
        """
        return self._VpnGatewayIds

    @VpnGatewayIds.setter
    def VpnGatewayIds(self, VpnGatewayIds):
        self._VpnGatewayIds = VpnGatewayIds

    @property
    def Filters(self):
        r"""Filter condition. `VpnGatewayIds` and `Filters` cannot be specified at the same time.
<li>vpc-id - String - (Filter condition) VPC instance ID, such as `vpc-f49l6u0z`.</li>
<li>vpn-gateway-id - String - (Filter condition) VPN instance ID, such as `vpngw-5aluhh9t`.</li>
<li>vpn-gateway-name - String - (Filter condition) VPN instance name.</li>
<li>type - String - (Filter condition) VPN gateway type: 'IPSEC', 'SSL'.</li>
<li>public-ip-address- String - (Filter condition) Public IP.</li>
<li>renew-flag - String - (Filter condition) Gateway renewal type. Manual renewal: `NOTIFY_AND_MANUAL_RENEW`, Automatic renewal: `NOTIFY_AND_AUTO_RENEW`.</li>
<li>zone - String - (Filter condition) The availability zone where the VPN is located, such as `ap-guangzhou-2`.</li>
        :rtype: list of FilterObject
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of request objects.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayIds = params.get("VpnGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterObject()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewaysResponse(AbstractModel):
    r"""DescribeVpnGateways response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of instances meeting the filter condition.
        :type TotalCount: int
        :param _VpnGatewaySet: The list of details of VPN gateway instances.
        :type VpnGatewaySet: list of VpnGateway
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpnGatewaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of instances meeting the filter condition.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpnGatewaySet(self):
        r"""The list of details of VPN gateway instances.
        :rtype: list of VpnGateway
        """
        return self._VpnGatewaySet

    @VpnGatewaySet.setter
    def VpnGatewaySet(self, VpnGatewaySet):
        self._VpnGatewaySet = VpnGatewaySet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpnGatewaySet") is not None:
            self._VpnGatewaySet = []
            for item in params.get("VpnGatewaySet"):
                obj = VpnGateway()
                obj._deserialize(item)
                self._VpnGatewaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DestinationIpPortTranslationNatRule(AbstractModel):
    r"""The port forwarding rules of the NAT gateway

    """

    def __init__(self):
        r"""
        :param _IpProtocol: Network protocol. Valid values: `TCP`, `UDP`.
        :type IpProtocol: str
        :param _PublicIpAddress: EIP.
        :type PublicIpAddress: str
        :param _PublicPort: Public network port.
        :type PublicPort: int
        :param _PrivateIpAddress: Private network address.
        :type PrivateIpAddress: str
        :param _PrivatePort: Private network port.
        :type PrivatePort: int
        :param _Description: Description of NAT gateway forwarding rules.
        :type Description: str
        """
        self._IpProtocol = None
        self._PublicIpAddress = None
        self._PublicPort = None
        self._PrivateIpAddress = None
        self._PrivatePort = None
        self._Description = None

    @property
    def IpProtocol(self):
        r"""Network protocol. Valid values: `TCP`, `UDP`.
        :rtype: str
        """
        return self._IpProtocol

    @IpProtocol.setter
    def IpProtocol(self, IpProtocol):
        self._IpProtocol = IpProtocol

    @property
    def PublicIpAddress(self):
        r"""EIP.
        :rtype: str
        """
        return self._PublicIpAddress

    @PublicIpAddress.setter
    def PublicIpAddress(self, PublicIpAddress):
        self._PublicIpAddress = PublicIpAddress

    @property
    def PublicPort(self):
        r"""Public network port.
        :rtype: int
        """
        return self._PublicPort

    @PublicPort.setter
    def PublicPort(self, PublicPort):
        self._PublicPort = PublicPort

    @property
    def PrivateIpAddress(self):
        r"""Private network address.
        :rtype: str
        """
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def PrivatePort(self):
        r"""Private network port.
        :rtype: int
        """
        return self._PrivatePort

    @PrivatePort.setter
    def PrivatePort(self, PrivatePort):
        self._PrivatePort = PrivatePort

    @property
    def Description(self):
        r"""Description of NAT gateway forwarding rules.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._IpProtocol = params.get("IpProtocol")
        self._PublicIpAddress = params.get("PublicIpAddress")
        self._PublicPort = params.get("PublicPort")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._PrivatePort = params.get("PrivatePort")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachCcnInstancesRequest(AbstractModel):
    r"""DetachCcnInstances request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _Instances: The list of network instances to be unbound
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        r"""The list of network instances to be unbound
        :rtype: list of CcnInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachCcnInstancesResponse(AbstractModel):
    r"""DetachCcnInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachClassicLinkVpcRequest(AbstractModel):
    r"""DetachClassicLinkVpc request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :type VpcId: str
        :param _InstanceIds: Queries the ID of the CVM instance, such as `ins-r8hr2upy`.
        :type InstanceIds: list of str
        """
        self._VpcId = None
        self._InstanceIds = None

    @property
    def VpcId(self):
        r"""The ID of the VPC instance. You can obtain the parameter value from the VpcId field in the returned result of DescribeVpcs API.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceIds(self):
        r"""Queries the ID of the CVM instance, such as `ins-r8hr2upy`.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachClassicLinkVpcResponse(AbstractModel):
    r"""DetachClassicLinkVpc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachNetworkInterfaceRequest(AbstractModel):
    r"""DetachNetworkInterface request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: The ID of the ENI instance, such as `eni-m6dyj72l`.
        :type NetworkInterfaceId: str
        :param _InstanceId: The ID of the CVM instance, such as `ins-r8hr2upy`.
        :type InstanceId: str
        """
        self._NetworkInterfaceId = None
        self._InstanceId = None

    @property
    def NetworkInterfaceId(self):
        r"""The ID of the ENI instance, such as `eni-m6dyj72l`.
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def InstanceId(self):
        r"""The ID of the CVM instance, such as `ins-r8hr2upy`.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachNetworkInterfaceResponse(AbstractModel):
    r"""DetachNetworkInterface response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachSnapshotInstancesRequest(AbstractModel):
    r"""DetachSnapshotInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: Snapshot policy IDs
        :type SnapshotPolicyId: str
        :param _Instances: Information of instances
        :type Instances: list of SnapshotInstance
        """
        self._SnapshotPolicyId = None
        self._Instances = None

    @property
    def SnapshotPolicyId(self):
        r"""Snapshot policy IDs
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Instances(self):
        r"""Information of instances
        :rtype: list of SnapshotInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachSnapshotInstancesResponse(AbstractModel):
    r"""DetachSnapshotInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DirectConnectGateway(AbstractModel):
    r"""Direct Connect gateway object.

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: Direct Connect `ID`.
        :type DirectConnectGatewayId: str
        :param _DirectConnectGatewayName: Direct Connect gateway name.
        :type DirectConnectGatewayName: str
        :param _VpcId: The `ID` of the `VPC` instance associated with the Direct Connect gateway.
        :type VpcId: str
        :param _NetworkType: The associated network type:
<li>`VPC` - VPC</li>
<li>`CCN` - CCN</li>
        :type NetworkType: str
        :param _NetworkInstanceId: The `ID` of the associated network instance:
<li>When the NetworkType is `VPC`, this value is the VPC instance `ID`</li>
<li>When the NetworkType is `CCN`, this value is the CCN instance `ID`</li>
        :type NetworkInstanceId: str
        :param _GatewayType: Gateway type:
<li>NORMAL - Standard type. Note: CCN only supports the standard type</li>
<li>NAT - NAT type</li>
NAT type supports network address switch configuration. After the type is confirmed, it cannot be modified. A VPC can create one NAT-type Direct Connect gateway and one non-NAT-type Direct Connect gateway
        :type GatewayType: str
        :param _CreateTime: Creation Time.
        :type CreateTime: str
        :param _DirectConnectGatewayIp: Direct Connect gateway IP.
        :type DirectConnectGatewayIp: str
        :param _CcnId: The `ID` of the `CCN` instance associated with the Direct Connect gateway.
        :type CcnId: str
        :param _CcnRouteType: The route-learning type of the CCN:
<li>`BGP` - Automatic learning.</li>
<li>`STATIC` - Static, that is, user-configured.</li>
        :type CcnRouteType: str
        :param _EnableBGP: Whether BGP is enabled.
        :type EnableBGP: bool
        :param _EnableBGPCommunity: Whether to enable BGP's `community` attribute. Valid values: enable, disable
        :type EnableBGPCommunity: bool
        :param _NatGatewayId: ID of the NAT gateway bound.
Note: this field may return `null`, indicating that no valid value was found.
        :type NatGatewayId: str
        :param _VXLANSupport: Whether the direct connect gateway supports the VXLAN architecture.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type VXLANSupport: list of bool
        :param _ModeType: CCN route publishing mode. Valid values: `standard` and `exquisite`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ModeType: str
        :param _LocalZone: Whether the direct connect gateway is for an edge zone.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type LocalZone: bool
        :param _Zone: Availability zone where the direct connect gateway resides.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Zone: str
        :param _EnableFlowDetails: The status of gateway traffic monitoring
0: disable
1: enable
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type EnableFlowDetails: int
        :param _FlowDetailsUpdateTime: The last time when the gateway traffic monitoring is enabled/disabled
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type FlowDetailsUpdateTime: str
        :param _NewAfc: Whether gateway traffic monitoring is supported
0: No
1: Yes
Note: this field may return `null`, indicating that no valid values can be found.
        :type NewAfc: int
        :param _AccessNetworkType: Direct connect gateway access network types:
<li>`VXLAN` - VXLAN type.</li>
<li>`MPLS` - MPLS type.</li>
<li>`Hybrid` - Hybrid type.</li>
Note: this field may return `null`, indicating that no valid values can be found.
        :type AccessNetworkType: str
        :param _HaZoneList: AZ list of direct connect gateway with cross-AZ placement groups
Note: this field may return `null`, indicating that no valid values can be found.
        :type HaZoneList: list of str
        """
        self._DirectConnectGatewayId = None
        self._DirectConnectGatewayName = None
        self._VpcId = None
        self._NetworkType = None
        self._NetworkInstanceId = None
        self._GatewayType = None
        self._CreateTime = None
        self._DirectConnectGatewayIp = None
        self._CcnId = None
        self._CcnRouteType = None
        self._EnableBGP = None
        self._EnableBGPCommunity = None
        self._NatGatewayId = None
        self._VXLANSupport = None
        self._ModeType = None
        self._LocalZone = None
        self._Zone = None
        self._EnableFlowDetails = None
        self._FlowDetailsUpdateTime = None
        self._NewAfc = None
        self._AccessNetworkType = None
        self._HaZoneList = None

    @property
    def DirectConnectGatewayId(self):
        r"""Direct Connect `ID`.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def DirectConnectGatewayName(self):
        r"""Direct Connect gateway name.
        :rtype: str
        """
        return self._DirectConnectGatewayName

    @DirectConnectGatewayName.setter
    def DirectConnectGatewayName(self, DirectConnectGatewayName):
        self._DirectConnectGatewayName = DirectConnectGatewayName

    @property
    def VpcId(self):
        r"""The `ID` of the `VPC` instance associated with the Direct Connect gateway.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkType(self):
        r"""The associated network type:
<li>`VPC` - VPC</li>
<li>`CCN` - CCN</li>
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def NetworkInstanceId(self):
        r"""The `ID` of the associated network instance:
<li>When the NetworkType is `VPC`, this value is the VPC instance `ID`</li>
<li>When the NetworkType is `CCN`, this value is the CCN instance `ID`</li>
        :rtype: str
        """
        return self._NetworkInstanceId

    @NetworkInstanceId.setter
    def NetworkInstanceId(self, NetworkInstanceId):
        self._NetworkInstanceId = NetworkInstanceId

    @property
    def GatewayType(self):
        r"""Gateway type:
<li>NORMAL - Standard type. Note: CCN only supports the standard type</li>
<li>NAT - NAT type</li>
NAT type supports network address switch configuration. After the type is confirmed, it cannot be modified. A VPC can create one NAT-type Direct Connect gateway and one non-NAT-type Direct Connect gateway
        :rtype: str
        """
        return self._GatewayType

    @GatewayType.setter
    def GatewayType(self, GatewayType):
        self._GatewayType = GatewayType

    @property
    def CreateTime(self):
        r"""Creation Time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DirectConnectGatewayIp(self):
        r"""Direct Connect gateway IP.
        :rtype: str
        """
        return self._DirectConnectGatewayIp

    @DirectConnectGatewayIp.setter
    def DirectConnectGatewayIp(self, DirectConnectGatewayIp):
        self._DirectConnectGatewayIp = DirectConnectGatewayIp

    @property
    def CcnId(self):
        r"""The `ID` of the `CCN` instance associated with the Direct Connect gateway.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnRouteType(self):
        r"""The route-learning type of the CCN:
<li>`BGP` - Automatic learning.</li>
<li>`STATIC` - Static, that is, user-configured.</li>
        :rtype: str
        """
        return self._CcnRouteType

    @CcnRouteType.setter
    def CcnRouteType(self, CcnRouteType):
        self._CcnRouteType = CcnRouteType

    @property
    def EnableBGP(self):
        r"""Whether BGP is enabled.
        :rtype: bool
        """
        return self._EnableBGP

    @EnableBGP.setter
    def EnableBGP(self, EnableBGP):
        self._EnableBGP = EnableBGP

    @property
    def EnableBGPCommunity(self):
        r"""Whether to enable BGP's `community` attribute. Valid values: enable, disable
        :rtype: bool
        """
        return self._EnableBGPCommunity

    @EnableBGPCommunity.setter
    def EnableBGPCommunity(self, EnableBGPCommunity):
        self._EnableBGPCommunity = EnableBGPCommunity

    @property
    def NatGatewayId(self):
        r"""ID of the NAT gateway bound.
Note: this field may return `null`, indicating that no valid value was found.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def VXLANSupport(self):
        r"""Whether the direct connect gateway supports the VXLAN architecture.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of bool
        """
        return self._VXLANSupport

    @VXLANSupport.setter
    def VXLANSupport(self, VXLANSupport):
        self._VXLANSupport = VXLANSupport

    @property
    def ModeType(self):
        r"""CCN route publishing mode. Valid values: `standard` and `exquisite`.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ModeType

    @ModeType.setter
    def ModeType(self, ModeType):
        self._ModeType = ModeType

    @property
    def LocalZone(self):
        r"""Whether the direct connect gateway is for an edge zone.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._LocalZone

    @LocalZone.setter
    def LocalZone(self, LocalZone):
        self._LocalZone = LocalZone

    @property
    def Zone(self):
        r"""Availability zone where the direct connect gateway resides.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def EnableFlowDetails(self):
        r"""The status of gateway traffic monitoring
0: disable
1: enable
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._EnableFlowDetails

    @EnableFlowDetails.setter
    def EnableFlowDetails(self, EnableFlowDetails):
        self._EnableFlowDetails = EnableFlowDetails

    @property
    def FlowDetailsUpdateTime(self):
        r"""The last time when the gateway traffic monitoring is enabled/disabled
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FlowDetailsUpdateTime

    @FlowDetailsUpdateTime.setter
    def FlowDetailsUpdateTime(self, FlowDetailsUpdateTime):
        self._FlowDetailsUpdateTime = FlowDetailsUpdateTime

    @property
    def NewAfc(self):
        r"""Whether gateway traffic monitoring is supported
0: No
1: Yes
Note: this field may return `null`, indicating that no valid values can be found.
        :rtype: int
        """
        return self._NewAfc

    @NewAfc.setter
    def NewAfc(self, NewAfc):
        self._NewAfc = NewAfc

    @property
    def AccessNetworkType(self):
        r"""Direct connect gateway access network types:
<li>`VXLAN` - VXLAN type.</li>
<li>`MPLS` - MPLS type.</li>
<li>`Hybrid` - Hybrid type.</li>
Note: this field may return `null`, indicating that no valid values can be found.
        :rtype: str
        """
        return self._AccessNetworkType

    @AccessNetworkType.setter
    def AccessNetworkType(self, AccessNetworkType):
        self._AccessNetworkType = AccessNetworkType

    @property
    def HaZoneList(self):
        r"""AZ list of direct connect gateway with cross-AZ placement groups
Note: this field may return `null`, indicating that no valid values can be found.
        :rtype: list of str
        """
        return self._HaZoneList

    @HaZoneList.setter
    def HaZoneList(self, HaZoneList):
        self._HaZoneList = HaZoneList


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._DirectConnectGatewayName = params.get("DirectConnectGatewayName")
        self._VpcId = params.get("VpcId")
        self._NetworkType = params.get("NetworkType")
        self._NetworkInstanceId = params.get("NetworkInstanceId")
        self._GatewayType = params.get("GatewayType")
        self._CreateTime = params.get("CreateTime")
        self._DirectConnectGatewayIp = params.get("DirectConnectGatewayIp")
        self._CcnId = params.get("CcnId")
        self._CcnRouteType = params.get("CcnRouteType")
        self._EnableBGP = params.get("EnableBGP")
        self._EnableBGPCommunity = params.get("EnableBGPCommunity")
        self._NatGatewayId = params.get("NatGatewayId")
        self._VXLANSupport = params.get("VXLANSupport")
        self._ModeType = params.get("ModeType")
        self._LocalZone = params.get("LocalZone")
        self._Zone = params.get("Zone")
        self._EnableFlowDetails = params.get("EnableFlowDetails")
        self._FlowDetailsUpdateTime = params.get("FlowDetailsUpdateTime")
        self._NewAfc = params.get("NewAfc")
        self._AccessNetworkType = params.get("AccessNetworkType")
        self._HaZoneList = params.get("HaZoneList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DirectConnectGatewayCcnRoute(AbstractModel):
    r"""The object of the CCN route (IDC IP range) of the Direct Connect gateway

    """

    def __init__(self):
        r"""
        :param _RouteId: Route ID.
        :type RouteId: str
        :param _DestinationCidrBlock: IDC IP range.
        :type DestinationCidrBlock: str
        :param _ASPath: The `AS-Path` attribute of `BGP`.
        :type ASPath: list of str
        :param _Description: Remarks
        :type Description: str
        :param _UpdateTime: Last updated time
        :type UpdateTime: str
        """
        self._RouteId = None
        self._DestinationCidrBlock = None
        self._ASPath = None
        self._Description = None
        self._UpdateTime = None

    @property
    def RouteId(self):
        r"""Route ID.
        :rtype: str
        """
        return self._RouteId

    @RouteId.setter
    def RouteId(self, RouteId):
        self._RouteId = RouteId

    @property
    def DestinationCidrBlock(self):
        r"""IDC IP range.
        :rtype: str
        """
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def ASPath(self):
        r"""The `AS-Path` attribute of `BGP`.
        :rtype: list of str
        """
        return self._ASPath

    @ASPath.setter
    def ASPath(self, ASPath):
        self._ASPath = ASPath

    @property
    def Description(self):
        r"""Remarks
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def UpdateTime(self):
        r"""Last updated time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._RouteId = params.get("RouteId")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._ASPath = params.get("ASPath")
        self._Description = params.get("Description")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DirectConnectSubnet(AbstractModel):
    r"""IDC subnet information

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: The direct connect gateway ID.
        :type DirectConnectGatewayId: str
        :param _CidrBlock: IDC subnet IP range
        :type CidrBlock: str
        """
        self._DirectConnectGatewayId = None
        self._CidrBlock = None

    @property
    def DirectConnectGatewayId(self):
        r"""The direct connect gateway ID.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def CidrBlock(self):
        r"""IDC subnet IP range
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._CidrBlock = params.get("CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableCcnRoutesRequest(AbstractModel):
    r"""DisableCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _RouteIds: The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        """
        self._CcnId = None
        self._RouteIds = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        r"""The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableCcnRoutesResponse(AbstractModel):
    r"""DisableCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableFlowLogsRequest(AbstractModel):
    r"""DisableFlowLogs request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogIds: Flow log ID.
        :type FlowLogIds: list of str
        """
        self._FlowLogIds = None

    @property
    def FlowLogIds(self):
        r"""Flow log ID.
        :rtype: list of str
        """
        return self._FlowLogIds

    @FlowLogIds.setter
    def FlowLogIds(self, FlowLogIds):
        self._FlowLogIds = FlowLogIds


    def _deserialize(self, params):
        self._FlowLogIds = params.get("FlowLogIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableFlowLogsResponse(AbstractModel):
    r"""DisableFlowLogs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableGatewayFlowMonitorRequest(AbstractModel):
    r"""DisableGatewayFlowMonitor request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        """
        self._GatewayId = None

    @property
    def GatewayId(self):
        r"""Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :rtype: str
        """
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableGatewayFlowMonitorResponse(AbstractModel):
    r"""DisableGatewayFlowMonitor response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableRoutesRequest(AbstractModel):
    r"""DisableRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: Unique route table ID.
        :type RouteTableId: str
        :param _RouteIds: Routing policy ID. This parameter cannot be used simultaneously with RouteItemIds, but at least one of them should be entered. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.tencent.com/document/product/215/15763?from_cn_redirect=1)).
        :type RouteIds: list of int non-negative
        :param _RouteItemIds: Unique routing policy ID. This parameter cannot be used simultaneously with RouteIds, but at least one of them should be entered. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.tencent.com/document/product/215/15763?from_cn_redirect=1)).
        :type RouteItemIds: list of str
        """
        self._RouteTableId = None
        self._RouteIds = None
        self._RouteItemIds = None

    @property
    def RouteTableId(self):
        r"""Unique route table ID.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteIds(self):
        r"""Routing policy ID. This parameter cannot be used simultaneously with RouteItemIds, but at least one of them should be entered. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.tencent.com/document/product/215/15763?from_cn_redirect=1)).
        :rtype: list of int non-negative
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds

    @property
    def RouteItemIds(self):
        r"""Unique routing policy ID. This parameter cannot be used simultaneously with RouteIds, but at least one of them should be entered. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.tencent.com/document/product/215/15763?from_cn_redirect=1)).
        :rtype: list of str
        """
        return self._RouteItemIds

    @RouteItemIds.setter
    def RouteItemIds(self, RouteItemIds):
        self._RouteItemIds = RouteItemIds


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        self._RouteIds = params.get("RouteIds")
        self._RouteItemIds = params.get("RouteItemIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableRoutesResponse(AbstractModel):
    r"""DisableRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableSnapshotPoliciesRequest(AbstractModel):
    r"""DisableSnapshotPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: Snapshot policy IDs
        :type SnapshotPolicyIds: list of str
        """
        self._SnapshotPolicyIds = None

    @property
    def SnapshotPolicyIds(self):
        r"""Snapshot policy IDs
        :rtype: list of str
        """
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableSnapshotPoliciesResponse(AbstractModel):
    r"""DisableSnapshotPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateAddressRequest(AbstractModel):
    r"""DisassociateAddress request structure.

    """

    def __init__(self):
        r"""
        :param _AddressId: The unique ID of the EIP, such as `eip-11112222`.
        :type AddressId: str
        :param _ReallocateNormalPublicIp: Whether a common public IP is assigned after the EIP is unbound. Value range:<br><li>TRUE: Indicates that after the EIP is unbound, a common public IP is assigned.<br><li>FALSE: Indicates that after the EIP is unbound, a common public IP is not assigned.<br>Default value: FALSE.<br><br>The parameter can be specified only under the following conditions:<br><li>It can only be specified when you unbind an EIP from the primary private IP of the primary ENI.<br><li>After an EIP is unbound, you can assign public IPs to an account up to 10 times per day. For more information, use the [DescribeAddressQuota] (https://intl.cloud.tencent.com/document/api/213/1378?from_cn_redirect=1) API.
        :type ReallocateNormalPublicIp: bool
        """
        self._AddressId = None
        self._ReallocateNormalPublicIp = None

    @property
    def AddressId(self):
        r"""The unique ID of the EIP, such as `eip-11112222`.
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def ReallocateNormalPublicIp(self):
        r"""Whether a common public IP is assigned after the EIP is unbound. Value range:<br><li>TRUE: Indicates that after the EIP is unbound, a common public IP is assigned.<br><li>FALSE: Indicates that after the EIP is unbound, a common public IP is not assigned.<br>Default value: FALSE.<br><br>The parameter can be specified only under the following conditions:<br><li>It can only be specified when you unbind an EIP from the primary private IP of the primary ENI.<br><li>After an EIP is unbound, you can assign public IPs to an account up to 10 times per day. For more information, use the [DescribeAddressQuota] (https://intl.cloud.tencent.com/document/api/213/1378?from_cn_redirect=1) API.
        :rtype: bool
        """
        return self._ReallocateNormalPublicIp

    @ReallocateNormalPublicIp.setter
    def ReallocateNormalPublicIp(self, ReallocateNormalPublicIp):
        self._ReallocateNormalPublicIp = ReallocateNormalPublicIp


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._ReallocateNormalPublicIp = params.get("ReallocateNormalPublicIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateAddressResponse(AbstractModel):
    r"""DisassociateAddress response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""The async task ID. You can use the [DescribeTaskResult](https://intl.cloud.tencent.com/document/api/215/36271?from_cn_redirect=1) API to query the task status.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DisassociateDirectConnectGatewayNatGatewayRequest(AbstractModel):
    r"""DisassociateDirectConnectGatewayNatGateway request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: The direct connect gateway ID.
        :type VpcId: str
        :param _NatGatewayId: The NAT Gateway ID.
        :type NatGatewayId: str
        :param _DirectConnectGatewayId: The ID of the VPC instance, which can be obtained from the `VpcId` field in response of the `DescribeVpcs` API.
        :type DirectConnectGatewayId: str
        """
        self._VpcId = None
        self._NatGatewayId = None
        self._DirectConnectGatewayId = None

    @property
    def VpcId(self):
        r"""The direct connect gateway ID.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NatGatewayId(self):
        r"""The NAT Gateway ID.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DirectConnectGatewayId(self):
        r"""The ID of the VPC instance, which can be obtained from the `VpcId` field in response of the `DescribeVpcs` API.
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NatGatewayId = params.get("NatGatewayId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateDirectConnectGatewayNatGatewayResponse(AbstractModel):
    r"""DisassociateDirectConnectGatewayNatGateway response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateIPv6AddressRequest(AbstractModel):
    r"""DisassociateIPv6Address request structure.

    """

    def __init__(self):
        r"""
        :param _IPv6AddressId: Indicates the unique ID of the EIPv6, such as eipv6-11112222.
        :type IPv6AddressId: str
        :param _KeepBindWithEni: Indicates whether to keep the ENI bound when unbinding.
        :type KeepBindWithEni: bool
        """
        self._IPv6AddressId = None
        self._KeepBindWithEni = None

    @property
    def IPv6AddressId(self):
        r"""Indicates the unique ID of the EIPv6, such as eipv6-11112222.
        :rtype: str
        """
        return self._IPv6AddressId

    @IPv6AddressId.setter
    def IPv6AddressId(self, IPv6AddressId):
        self._IPv6AddressId = IPv6AddressId

    @property
    def KeepBindWithEni(self):
        r"""Indicates whether to keep the ENI bound when unbinding.
        :rtype: bool
        """
        return self._KeepBindWithEni

    @KeepBindWithEni.setter
    def KeepBindWithEni(self, KeepBindWithEni):
        self._KeepBindWithEni = KeepBindWithEni


    def _deserialize(self, params):
        self._IPv6AddressId = params.get("IPv6AddressId")
        self._KeepBindWithEni = params.get("KeepBindWithEni")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateIPv6AddressResponse(AbstractModel):
    r"""DisassociateIPv6Address response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateNatGatewayAddressRequest(AbstractModel):
    r"""DisassociateNatGatewayAddress request structure.

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: The ID of the NAT gateway, such as `nat-df45454`.
        :type NatGatewayId: str
        :param _PublicIpAddresses: Array of the EIPs to be unbound from the NAT gateway.
        :type PublicIpAddresses: list of str
        """
        self._NatGatewayId = None
        self._PublicIpAddresses = None

    @property
    def NatGatewayId(self):
        r"""The ID of the NAT gateway, such as `nat-df45454`.
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def PublicIpAddresses(self):
        r"""Array of the EIPs to be unbound from the NAT gateway.
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateNatGatewayAddressResponse(AbstractModel):
    r"""DisassociateNatGatewayAddress response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateNetworkAclSubnetsRequest(AbstractModel):
    r"""DisassociateNetworkAclSubnets request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: Network ACL instance ID, such as `acl-12345678`.
        :type NetworkAclId: str
        :param _SubnetIds: Array of subnet instance IDs, such as [subnet-12345678].
        :type SubnetIds: list of str
        """
        self._NetworkAclId = None
        self._SubnetIds = None

    @property
    def NetworkAclId(self):
        r"""Network ACL instance ID, such as `acl-12345678`.
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def SubnetIds(self):
        r"""Array of subnet instance IDs, such as [subnet-12345678].
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateNetworkAclSubnetsResponse(AbstractModel):
    r"""DisassociateNetworkAclSubnets response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateNetworkInterfaceSecurityGroupsRequest(AbstractModel):
    r"""DisassociateNetworkInterfaceSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: ENI instance ID, e.g. eni-pxir56ns. You can enter up to 100 instances for each request.
        :type NetworkInterfaceIds: list of str
        :param _SecurityGroupIds: The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups. You can enter up to 100 instances for each request.
        :type SecurityGroupIds: list of str
        """
        self._NetworkInterfaceIds = None
        self._SecurityGroupIds = None

    @property
    def NetworkInterfaceIds(self):
        r"""ENI instance ID, e.g. eni-pxir56ns. You can enter up to 100 instances for each request.
        :rtype: list of str
        """
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def SecurityGroupIds(self):
        r"""The security group instance ID, such as `sg-33ocnj9n`. It can be obtained through DescribeSecurityGroups. You can enter up to 100 instances for each request.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateNetworkInterfaceSecurityGroupsResponse(AbstractModel):
    r"""DisassociateNetworkInterfaceSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisassociateVpcEndPointSecurityGroupsRequest(AbstractModel):
    r"""DisassociateVpcEndPointSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: Array of security group IDs
        :type SecurityGroupIds: list of str
        :param _EndPointId: Endpoint ID
        :type EndPointId: str
        """
        self._SecurityGroupIds = None
        self._EndPointId = None

    @property
    def SecurityGroupIds(self):
        r"""Array of security group IDs
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def EndPointId(self):
        r"""Endpoint ID
        :rtype: str
        """
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateVpcEndPointSecurityGroupsResponse(AbstractModel):
    r"""DisassociateVpcEndPointSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DownloadCustomerGatewayConfigurationRequest(AbstractModel):
    r"""DownloadCustomerGatewayConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: The ID of the VPN gateway instance.
        :type VpnGatewayId: str
        :param _VpnConnectionId: The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :type VpnConnectionId: str
        :param _CustomerGatewayVendor: Customer gateway vendor information object, which can be obtained through DescribeCustomerGatewayVendors.
        :type CustomerGatewayVendor: :class:`tencentcloud.vpc.v20170312.models.CustomerGatewayVendor`
        :param _InterfaceName: Name of the physical API for tunnel access device.
        :type InterfaceName: str
        """
        self._VpnGatewayId = None
        self._VpnConnectionId = None
        self._CustomerGatewayVendor = None
        self._InterfaceName = None

    @property
    def VpnGatewayId(self):
        r"""The ID of the VPN gateway instance.
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnConnectionId(self):
        r"""The ID of the VPN tunnel instance, such as `vpnx-f49l6u0z`.
        :rtype: str
        """
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId

    @property
    def CustomerGatewayVendor(self):
        r"""Customer gateway vendor information object, which can be obtained through DescribeCustomerGatewayVendors.
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CustomerGatewayVendor`
        """
        return self._CustomerGatewayVendor

    @CustomerGatewayVendor.setter
    def CustomerGatewayVendor(self, CustomerGatewayVendor):
        self._CustomerGatewayVendor = CustomerGatewayVendor

    @property
    def InterfaceName(self):
        r"""Name of the physical API for tunnel access device.
        :rtype: str
        """
        return self._InterfaceName

    @InterfaceName.setter
    def InterfaceName(self, InterfaceName):
        self._InterfaceName = InterfaceName


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnConnectionId = params.get("VpnConnectionId")
        if params.get("CustomerGatewayVendor") is not None:
            self._CustomerGatewayVendor = CustomerGatewayVendor()
            self._CustomerGatewayVendor._deserialize(params.get("CustomerGatewayVendor"))
        self._InterfaceName = params.get("InterfaceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadCustomerGatewayConfigurationResponse(AbstractModel):
    r"""DownloadCustomerGatewayConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayConfiguration: Configuration information in XML format.
        :type CustomerGatewayConfiguration: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CustomerGatewayConfiguration = None
        self._RequestId = None

    @property
    def CustomerGatewayConfiguration(self):
        r"""Configuration information in XML format.
        :rtype: str
        """
        return self._CustomerGatewayConfiguration

    @CustomerGatewayConfiguration.setter
    def CustomerGatewayConfiguration(self, CustomerGatewayConfiguration):
        self._CustomerGatewayConfiguration = CustomerGatewayConfiguration

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CustomerGatewayConfiguration = params.get("CustomerGatewayConfiguration")
        self._RequestId = params.get("RequestId")


class EnableCcnRoutesRequest(AbstractModel):
    r"""EnableCcnRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _CcnId: The CCN instance ID, such as `ccn-f49l6u0z`.
        :type CcnId: str
        :param _RouteIds: The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :type RouteIds: list of str
        """
        self._CcnId = None
        self._RouteIds = None

    @property
    def CcnId(self):
        r"""The CCN instance ID, such as `ccn-f49l6u0z`.
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        r"""The unique ID of the CCN routing policy, such as `ccnr-f49l6u0z`.
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableCcnRoutesResponse(AbstractModel):
    r"""EnableCcnRoutes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableFlowLogsRequest(AbstractModel):
    r"""EnableFlowLogs request structure.

    """

    def __init__(self):
        r"""
        :param _FlowLogIds: Flow log ID.
        :type FlowLogIds: list of str
        """
        self._FlowLogIds = None

    @property
    def FlowLogIds(self):
        r"""Flow log ID.
        :rtype: list of str
        """
        return self._FlowLogIds

    @FlowLogIds.setter
    def FlowLogIds(self, FlowLogIds):
        self._FlowLogIds = FlowLogIds


    def _deserialize(self, params):
        self._FlowLogIds = params.get("FlowLogIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableFlowLogsResponse(AbstractModel):
    r"""EnableFlowLogs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableGatewayFlowMonitorRequest(AbstractModel):
    r"""EnableGatewayFlowMonitor request structure.

    """

    def __init__(self):
        r"""
        :param _GatewayId: Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :type GatewayId: str
        """
        self._GatewayId = None

    @property
    def GatewayId(self):
        r"""Gateway instance ID. Supported types:
Direct connect gateway instance, such as `dcg-ltjahce6`;
NAT gateway instance, such as `nat-ltjahce6`;
VPN gateway instance, such as `vpn-ltjahce6`.
        :rtype: str
        """
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableGatewayFlowMonitorResponse(AbstractModel):
    r"""EnableGatewayFlowMonitor response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableRoutesRequest(AbstractModel):
    r"""EnableRoutes request structure.

    """

    def __init__(self):
        r"""
        :param _RouteTableId: Unique route table ID.
        :type RouteTableId: str
        :param _RouteIds: Routing policy ID. This parameter cannot be used simultaneously with RouteItemIds, but at least one of them should be entered. The maximum number of items processed in a single request is 100. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.tencent.com/document/product/215/15763?from_cn_redirect=1)).
        :type RouteIds: list of int non-negative
        :param _RouteItemIds: Unique routing policy ID. This parameter cannot be used simultaneously with RouteIds, but at least one of them should be entered. The maximum number of items processed in a single request is 100. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.tencent.com/document/product/215/15763?from_cn_redirect=1)).
        :type RouteItemIds: list of str
        """
        self._RouteTableId = None
        self._RouteIds = None
        self._RouteItemIds = None

    @property
    def RouteTableId(self):
        r"""Unique route table ID.
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteIds(self):
        r"""Routing policy ID. This parameter cannot be used simultaneously with RouteItemIds, but at least one of them should be entered. The maximum number of items processed in a single request is 100. The value of this parameter can be obtained by querying the route list ([DescribeRouteTables](https://intl.cloud.ten