# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class CreateIncrementalMigrationStrategyRequest(AbstractModel):
    r"""CreateIncrementalMigrationStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _BucketId: The bucket ID where the strategy takes effect.
        :type BucketId: str
        :param _StrategyName: Incremental migration strategy name. The name length should not exceed 100 characters. Allowed characters include: Chinese characters, English characters, `0-9`,` _` and ` -`.
        :type StrategyName: str
        :param _OriginType: Source type. Valid values: 
<li>HTTP: the source type is HTTP.</li>
        :type OriginType: str
        :param _HttpOriginConfig: Incremental migration HTTP origin source configuration. This field is required when the OriginType value is `HTTP`.
        :type HttpOriginConfig: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginConfig`
        """
        self._SubAppId = None
        self._BucketId = None
        self._StrategyName = None
        self._OriginType = None
        self._HttpOriginConfig = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BucketId(self):
        r"""The bucket ID where the strategy takes effect.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def StrategyName(self):
        r"""Incremental migration strategy name. The name length should not exceed 100 characters. Allowed characters include: Chinese characters, English characters, `0-9`,` _` and ` -`.
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def OriginType(self):
        r"""Source type. Valid values: 
<li>HTTP: the source type is HTTP.</li>
        :rtype: str
        """
        return self._OriginType

    @OriginType.setter
    def OriginType(self, OriginType):
        self._OriginType = OriginType

    @property
    def HttpOriginConfig(self):
        r"""Incremental migration HTTP origin source configuration. This field is required when the OriginType value is `HTTP`.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginConfig`
        """
        return self._HttpOriginConfig

    @HttpOriginConfig.setter
    def HttpOriginConfig(self, HttpOriginConfig):
        self._HttpOriginConfig = HttpOriginConfig


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._BucketId = params.get("BucketId")
        self._StrategyName = params.get("StrategyName")
        self._OriginType = params.get("OriginType")
        if params.get("HttpOriginConfig") is not None:
            self._HttpOriginConfig = IncrementalMigrationHttpOriginConfig()
            self._HttpOriginConfig._deserialize(params.get("HttpOriginConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIncrementalMigrationStrategyResponse(AbstractModel):
    r"""CreateIncrementalMigrationStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _StrategyId: The ID of the incremental migration strategy.
        :type StrategyId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StrategyId = None
        self._RequestId = None

    @property
    def StrategyId(self):
        r"""The ID of the incremental migration strategy.
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._RequestId = params.get("RequestId")


class CreateStorageCredentialsRequest(AbstractModel):
    r"""CreateStorageCredentials request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _Policy: The policy string serialized by URL Encode is used as the input parameter Policy. The server will URL Decode the Policy value and grant temporary access credentials according to the parsed policy. Please pass in parameters according to the specification.
Note:
1.The policy syntax refers to [Cloud Access Management](/document/product/598/10603).
2.The policy cannot contain the principal element.
3.The policy actions include: 
<li>name/vod:ListObjects;</li>
<li>name/vod:ListObjectsV2;</li>
<li>name/vod:HeadObject;</li>
<li>name/vod:PutObject;</li>
<li>name/vod:ListParts;</li>
<li>name/vod:PostObject;</li>
<li>name/vod:CreateMultipartUpload;</li>
<li>name/vod:UploadPart;</li>
<li>name/vod:CompleteMultipartUpload;</li>
<li>name/vod:AbortMultipartUpload;</li>
<li>name/vod:ListMultipartUploads;</li>
<li>name/vod:CopyObject;</li>
<li>name/vod:RestoreObject;</li>
<li>name/vod:DeleteObjects;</li>
<li>name/vod:DeleteObject;</li>
<li>name/vod:UploadPartCopy.</li>4.The resource format of the policy is `qcs::vod:[region]:uid/[AppID]:prefix//[SubAppId]/[BucketId]/[Path]`, where AppID, SubAppId, BucketId and Path need to be filled in as required.

        :type Policy: str
        :param _DurationSeconds: Specifies the validity period of credentials in seconds. The default value is 1800 seconds and the maximum value is 129600 seconds.
        :type DurationSeconds: int
        """
        self._SubAppId = None
        self._Policy = None
        self._DurationSeconds = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Policy(self):
        r"""The policy string serialized by URL Encode is used as the input parameter Policy. The server will URL Decode the Policy value and grant temporary access credentials according to the parsed policy. Please pass in parameters according to the specification.
Note:
1.The policy syntax refers to [Cloud Access Management](/document/product/598/10603).
2.The policy cannot contain the principal element.
3.The policy actions include: 
<li>name/vod:ListObjects;</li>
<li>name/vod:ListObjectsV2;</li>
<li>name/vod:HeadObject;</li>
<li>name/vod:PutObject;</li>
<li>name/vod:ListParts;</li>
<li>name/vod:PostObject;</li>
<li>name/vod:CreateMultipartUpload;</li>
<li>name/vod:UploadPart;</li>
<li>name/vod:CompleteMultipartUpload;</li>
<li>name/vod:AbortMultipartUpload;</li>
<li>name/vod:ListMultipartUploads;</li>
<li>name/vod:CopyObject;</li>
<li>name/vod:RestoreObject;</li>
<li>name/vod:DeleteObjects;</li>
<li>name/vod:DeleteObject;</li>
<li>name/vod:UploadPartCopy.</li>4.The resource format of the policy is `qcs::vod:[region]:uid/[AppID]:prefix//[SubAppId]/[BucketId]/[Path]`, where AppID, SubAppId, BucketId and Path need to be filled in as required.

        :rtype: str
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def DurationSeconds(self):
        r"""Specifies the validity period of credentials in seconds. The default value is 1800 seconds and the maximum value is 129600 seconds.
        :rtype: int
        """
        return self._DurationSeconds

    @DurationSeconds.setter
    def DurationSeconds(self, DurationSeconds):
        self._DurationSeconds = DurationSeconds


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Policy = params.get("Policy")
        self._DurationSeconds = params.get("DurationSeconds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStorageCredentialsResponse(AbstractModel):
    r"""CreateStorageCredentials response structure.

    """

    def __init__(self):
        r"""
        :param _Credentials: Credentials.
        :type Credentials: :class:`tencentcloud.vod.v20240718.models.Credentials`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Credentials = None
        self._RequestId = None

    @property
    def Credentials(self):
        r"""Credentials.
        :rtype: :class:`tencentcloud.vod.v20240718.models.Credentials`
        """
        return self._Credentials

    @Credentials.setter
    def Credentials(self, Credentials):
        self._Credentials = Credentials

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Credentials") is not None:
            self._Credentials = Credentials()
            self._Credentials._deserialize(params.get("Credentials"))
        self._RequestId = params.get("RequestId")


class CreateStorageRequest(AbstractModel):
    r"""CreateStorage request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _StorageRegion: Storage region, which must be a region supported by the system. All storage regions and the regions where storage buckets have already been enabled can be queried using the [DescribeStorageRegions](https://www.tencentcloud.com/document/product/266/46542) API.
        :type StorageRegion: str
        :param _StorageName: The name of the storage.
<li>Only lowercase English letters, numbers, hyphens "-", and their combinations are supported.</li>
<li>The storage name cannot start or end with a "-".</li>
<li>The maximum length of the storage name is 64 characters.</li>
        :type StorageName: str
        """
        self._SubAppId = None
        self._StorageRegion = None
        self._StorageName = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def StorageRegion(self):
        r"""Storage region, which must be a region supported by the system. All storage regions and the regions where storage buckets have already been enabled can be queried using the [DescribeStorageRegions](https://www.tencentcloud.com/document/product/266/46542) API.
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def StorageName(self):
        r"""The name of the storage.
<li>Only lowercase English letters, numbers, hyphens "-", and their combinations are supported.</li>
<li>The storage name cannot start or end with a "-".</li>
<li>The maximum length of the storage name is 64 characters.</li>
        :rtype: str
        """
        return self._StorageName

    @StorageName.setter
    def StorageName(self, StorageName):
        self._StorageName = StorageName


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._StorageRegion = params.get("StorageRegion")
        self._StorageName = params.get("StorageName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStorageResponse(AbstractModel):
    r"""CreateStorage response structure.

    """

    def __init__(self):
        r"""
        :param _BucketId: The unique identifier ID of the storage bucket.
        :type BucketId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BucketId = None
        self._RequestId = None

    @property
    def BucketId(self):
        r"""The unique identifier ID of the storage bucket.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BucketId = params.get("BucketId")
        self._RequestId = params.get("RequestId")


class Credentials(AbstractModel):
    r"""Credentials.

    """

    def __init__(self):
        r"""
        :param _AccessKeyId: Access Key ID.
        :type AccessKeyId: str
        :param _SecretAccessKey: Secret Access Key.
        :type SecretAccessKey: str
        :param _SessionToken: The session token length depends on the binding policy and is no longer than 4096 bytes.
        :type SessionToken: str
        :param _Expiration: The expiration time of the credentials.
        :type Expiration: str
        """
        self._AccessKeyId = None
        self._SecretAccessKey = None
        self._SessionToken = None
        self._Expiration = None

    @property
    def AccessKeyId(self):
        r"""Access Key ID.
        :rtype: str
        """
        return self._AccessKeyId

    @AccessKeyId.setter
    def AccessKeyId(self, AccessKeyId):
        self._AccessKeyId = AccessKeyId

    @property
    def SecretAccessKey(self):
        r"""Secret Access Key.
        :rtype: str
        """
        return self._SecretAccessKey

    @SecretAccessKey.setter
    def SecretAccessKey(self, SecretAccessKey):
        self._SecretAccessKey = SecretAccessKey

    @property
    def SessionToken(self):
        r"""The session token length depends on the binding policy and is no longer than 4096 bytes.
        :rtype: str
        """
        return self._SessionToken

    @SessionToken.setter
    def SessionToken(self, SessionToken):
        self._SessionToken = SessionToken

    @property
    def Expiration(self):
        r"""The expiration time of the credentials.
        :rtype: str
        """
        return self._Expiration

    @Expiration.setter
    def Expiration(self, Expiration):
        self._Expiration = Expiration


    def _deserialize(self, params):
        self._AccessKeyId = params.get("AccessKeyId")
        self._SecretAccessKey = params.get("SecretAccessKey")
        self._SessionToken = params.get("SessionToken")
        self._Expiration = params.get("Expiration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIncrementalMigrationStrategyRequest(AbstractModel):
    r"""DeleteIncrementalMigrationStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _BucketId: The bucket ID where the strategy takes effect.
        :type BucketId: str
        :param _StrategyId: The ID of the incremental migration strategy.
        :type StrategyId: str
        """
        self._SubAppId = None
        self._BucketId = None
        self._StrategyId = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BucketId(self):
        r"""The bucket ID where the strategy takes effect.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def StrategyId(self):
        r"""The ID of the incremental migration strategy.
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._BucketId = params.get("BucketId")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIncrementalMigrationStrategyResponse(AbstractModel):
    r"""DeleteIncrementalMigrationStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeIncrementalMigrationStrategyInfosRequest(AbstractModel):
    r"""DescribeIncrementalMigrationStrategyInfos request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _Filters: Filter criteria. The maximum number of Filters.Values is `20`. If this parameter is not input, all stategy information under the current SubAppId will be returned. The detailed filter criteria are as follows:
<li>BucketId: Filter by the ID of bucket;</li>
<li>StrategyId: Filter by the ID of strategy.</li>
        :type Filters: list of Filter
        :param _SortBy: Sort the returned results according to this field. 
SortBy.Field Values include: 
<li>UpdateTime: (Default) Update time of the strategy.</li>SortBy.Order Values include: 
<li>Desc: (Default) The order is descend.</li> 

        :type SortBy: :class:`tencentcloud.vod.v20240718.models.SortBy`
        :param _Offset: Offset for paginated queries. Default value: `0`.
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: `20`. Maximum value: `100`.
        :type Limit: int
        """
        self._SubAppId = None
        self._Filters = None
        self._SortBy = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Filters(self):
        r"""Filter criteria. The maximum number of Filters.Values is `20`. If this parameter is not input, all stategy information under the current SubAppId will be returned. The detailed filter criteria are as follows:
<li>BucketId: Filter by the ID of bucket;</li>
<li>StrategyId: Filter by the ID of strategy.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""Sort the returned results according to this field. 
SortBy.Field Values include: 
<li>UpdateTime: (Default) Update time of the strategy.</li>SortBy.Order Values include: 
<li>Desc: (Default) The order is descend.</li> 

        :rtype: :class:`tencentcloud.vod.v20240718.models.SortBy`
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Offset(self):
        r"""Offset for paginated queries. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit on paginated queries. Default value: `20`. Maximum value: `100`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("SortBy") is not None:
            self._SortBy = SortBy()
            self._SortBy._deserialize(params.get("SortBy"))
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIncrementalMigrationStrategyInfosResponse(AbstractModel):
    r"""DescribeIncrementalMigrationStrategyInfos response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total count of matched strategies.
        :type TotalCount: int
        :param _StrategyInfoSet: Information of all matched strategies.
        :type StrategyInfoSet: list of IncrementalMigrationStrategyInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._StrategyInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total count of matched strategies.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def StrategyInfoSet(self):
        r"""Information of all matched strategies.
        :rtype: list of IncrementalMigrationStrategyInfo
        """
        return self._StrategyInfoSet

    @StrategyInfoSet.setter
    def StrategyInfoSet(self, StrategyInfoSet):
        self._StrategyInfoSet = StrategyInfoSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("StrategyInfoSet") is not None:
            self._StrategyInfoSet = []
            for item in params.get("StrategyInfoSet"):
                obj = IncrementalMigrationStrategyInfo()
                obj._deserialize(item)
                self._StrategyInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageRequest(AbstractModel):
    r"""DescribeStorage request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _Filters: Filter criteria. The maximum number of Filters.Values is `20`. If this parameter is not input, all storage under the current SubAppId will be returned. The detailed filter criteria are as follows:
<li>BucketId: Filter by the ID of bucket;</li>
<li>StorageName: Filter by the name of storage.</li>
        :type Filters: list of Filter
        :param _SortBy: Sort the returned results according to this field. 
SortBy.Field Values include: 
<li>UpdateTime: (Default) Create time of the storage.</li>SortBy.Order Values include: 
<li>Asc: (Default) The order is ascend.</li> 

        :type SortBy: :class:`tencentcloud.vod.v20240718.models.SortBy`
        :param _Offset: Offset for paginated queries. Default value: `0`.
        :type Offset: int
        :param _Limit: Limit on paginated queries. Default value: `20`. Maximum value: `1000`.
        :type Limit: int
        """
        self._SubAppId = None
        self._Filters = None
        self._SortBy = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Filters(self):
        r"""Filter criteria. The maximum number of Filters.Values is `20`. If this parameter is not input, all storage under the current SubAppId will be returned. The detailed filter criteria are as follows:
<li>BucketId: Filter by the ID of bucket;</li>
<li>StorageName: Filter by the name of storage.</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""Sort the returned results according to this field. 
SortBy.Field Values include: 
<li>UpdateTime: (Default) Create time of the storage.</li>SortBy.Order Values include: 
<li>Asc: (Default) The order is ascend.</li> 

        :rtype: :class:`tencentcloud.vod.v20240718.models.SortBy`
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Offset(self):
        r"""Offset for paginated queries. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit on paginated queries. Default value: `20`. Maximum value: `1000`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("SortBy") is not None:
            self._SortBy = SortBy()
            self._SortBy._deserialize(params.get("SortBy"))
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageResponse(AbstractModel):
    r"""DescribeStorage response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total count of matched storage.
        :type TotalCount: int
        :param _StorageInfoSet: Information of all matched storage.
        :type StorageInfoSet: list of StorageInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._StorageInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total count of matched storage.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def StorageInfoSet(self):
        r"""Information of all matched storage.
        :rtype: list of StorageInfo
        """
        return self._StorageInfoSet

    @StorageInfoSet.setter
    def StorageInfoSet(self, StorageInfoSet):
        self._StorageInfoSet = StorageInfoSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("StorageInfoSet") is not None:
            self._StorageInfoSet = []
            for item in params.get("StorageInfoSet"):
                obj = StorageInfo()
                obj._deserialize(item)
                self._StorageInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class Filter(AbstractModel):
    r"""Key-value pair filters for conditional filtering queries, such as filtering ID, name, and status.
    If more than one filter exists, the logical relationship between these filters is `AND`.
    If multiple values exist in one filter, the logical relationship between these values under the same filter is `OR`.

    """

    def __init__(self):
        r"""
        :param _Name: Fields to be filtered.
        :type Name: str
        :param _Values: Value of the filtered field.
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Fields to be filtered.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Value of the filtered field.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpEndpointInfo(AbstractModel):
    r"""Incremental migration source address information.

    """

    def __init__(self):
        r"""
        :param _Endpoint: Address information, supporting domain names or IP addresses.
        :type Endpoint: str
        :param _StandbyEndpointSet: Backup address information.
        :type StandbyEndpointSet: list of str
        """
        self._Endpoint = None
        self._StandbyEndpointSet = None

    @property
    def Endpoint(self):
        r"""Address information, supporting domain names or IP addresses.
        :rtype: str
        """
        return self._Endpoint

    @Endpoint.setter
    def Endpoint(self, Endpoint):
        self._Endpoint = Endpoint

    @property
    def StandbyEndpointSet(self):
        r"""Backup address information.
        :rtype: list of str
        """
        return self._StandbyEndpointSet

    @StandbyEndpointSet.setter
    def StandbyEndpointSet(self, StandbyEndpointSet):
        self._StandbyEndpointSet = StandbyEndpointSet


    def _deserialize(self, params):
        self._Endpoint = params.get("Endpoint")
        self._StandbyEndpointSet = params.get("StandbyEndpointSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpHeader(AbstractModel):
    r"""Incremental migration back-to-origin HTTP Header.

    """

    def __init__(self):
        r"""
        :param _Key: Header Key.
        :type Key: str
        :param _Value: Header Value.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""Header Key.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Header Value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpHeaderInfo(AbstractModel):
    r"""Incremental migration back-to-origin HTTP Header information.

    """

    def __init__(self):
        r"""
        :param _HeaderFollowMode: HTTP Header Passthrough Mode. Values valid:
<li>FOLLOW_ALL: Pass through all header information;<\li>
<li>FOLLOW_PART: Pass through partial header information;<\li>
<li>IGNORE_PART: Ignore partial header information.<\li>
        :type HeaderFollowMode: str
        :param _FollowHttpHeaderKeySet: Header Key Set for Passthrough. This field is required only when the HeaderFollowMode is set to `FOLLOW_PART`.
        :type FollowHttpHeaderKeySet: list of str
        :param _NewHttpHeaderSet: Add Header Key-Value Pair Collection.
        :type NewHttpHeaderSet: list of IncrementalMigrationHttpHeader
        """
        self._HeaderFollowMode = None
        self._FollowHttpHeaderKeySet = None
        self._NewHttpHeaderSet = None

    @property
    def HeaderFollowMode(self):
        r"""HTTP Header Passthrough Mode. Values valid:
<li>FOLLOW_ALL: Pass through all header information;<\li>
<li>FOLLOW_PART: Pass through partial header information;<\li>
<li>IGNORE_PART: Ignore partial header information.<\li>
        :rtype: str
        """
        return self._HeaderFollowMode

    @HeaderFollowMode.setter
    def HeaderFollowMode(self, HeaderFollowMode):
        self._HeaderFollowMode = HeaderFollowMode

    @property
    def FollowHttpHeaderKeySet(self):
        r"""Header Key Set for Passthrough. This field is required only when the HeaderFollowMode is set to `FOLLOW_PART`.
        :rtype: list of str
        """
        return self._FollowHttpHeaderKeySet

    @FollowHttpHeaderKeySet.setter
    def FollowHttpHeaderKeySet(self, FollowHttpHeaderKeySet):
        self._FollowHttpHeaderKeySet = FollowHttpHeaderKeySet

    @property
    def NewHttpHeaderSet(self):
        r"""Add Header Key-Value Pair Collection.
        :rtype: list of IncrementalMigrationHttpHeader
        """
        return self._NewHttpHeaderSet

    @NewHttpHeaderSet.setter
    def NewHttpHeaderSet(self, NewHttpHeaderSet):
        self._NewHttpHeaderSet = NewHttpHeaderSet


    def _deserialize(self, params):
        self._HeaderFollowMode = params.get("HeaderFollowMode")
        self._FollowHttpHeaderKeySet = params.get("FollowHttpHeaderKeySet")
        if params.get("NewHttpHeaderSet") is not None:
            self._NewHttpHeaderSet = []
            for item in params.get("NewHttpHeaderSet"):
                obj = IncrementalMigrationHttpHeader()
                obj._deserialize(item)
                self._NewHttpHeaderSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpOriginCondition(AbstractModel):
    r"""Incremental migration back-to-source conditions.

    """

    def __init__(self):
        r"""
        :param _HttpStatusCode: HTTP code to trigger back-to-source conditions. If not filled, the default value is `404`.
        :type HttpStatusCode: int
        :param _Prefix: Object key prefix to trigger back-to-source conditions
        :type Prefix: str
        """
        self._HttpStatusCode = None
        self._Prefix = None

    @property
    def HttpStatusCode(self):
        r"""HTTP code to trigger back-to-source conditions. If not filled, the default value is `404`.
        :rtype: int
        """
        return self._HttpStatusCode

    @HttpStatusCode.setter
    def HttpStatusCode(self, HttpStatusCode):
        self._HttpStatusCode = HttpStatusCode

    @property
    def Prefix(self):
        r"""Object key prefix to trigger back-to-source conditions
        :rtype: str
        """
        return self._Prefix

    @Prefix.setter
    def Prefix(self, Prefix):
        self._Prefix = Prefix


    def _deserialize(self, params):
        self._HttpStatusCode = params.get("HttpStatusCode")
        self._Prefix = params.get("Prefix")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpOriginConfig(AbstractModel):
    r"""Configuration of the origin for incremental migration back-to-source.

    """

    def __init__(self):
        r"""
        :param _OriginInfo: Origin information for back-to-source.
        :type OriginInfo: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginInfo`
        :param _OriginParameter: Back-to-source parameters.
        :type OriginParameter: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginParameter`
        :param _Mode: Back-to-source mode. Valid values:
<li>SYNC: Synchronous back-to-source;</li>
<li>ASYNC: Asynchronous back-to-source.</li>
        :type Mode: str
        :param _OriginCondition: Back-to-source conditions.
        :type OriginCondition: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginCondition`
        """
        self._OriginInfo = None
        self._OriginParameter = None
        self._Mode = None
        self._OriginCondition = None

    @property
    def OriginInfo(self):
        r"""Origin information for back-to-source.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginInfo`
        """
        return self._OriginInfo

    @OriginInfo.setter
    def OriginInfo(self, OriginInfo):
        self._OriginInfo = OriginInfo

    @property
    def OriginParameter(self):
        r"""Back-to-source parameters.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginParameter`
        """
        return self._OriginParameter

    @OriginParameter.setter
    def OriginParameter(self, OriginParameter):
        self._OriginParameter = OriginParameter

    @property
    def Mode(self):
        r"""Back-to-source mode. Valid values:
<li>SYNC: Synchronous back-to-source;</li>
<li>ASYNC: Asynchronous back-to-source.</li>
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def OriginCondition(self):
        r"""Back-to-source conditions.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginCondition`
        """
        return self._OriginCondition

    @OriginCondition.setter
    def OriginCondition(self, OriginCondition):
        self._OriginCondition = OriginCondition


    def _deserialize(self, params):
        if params.get("OriginInfo") is not None:
            self._OriginInfo = IncrementalMigrationHttpOriginInfo()
            self._OriginInfo._deserialize(params.get("OriginInfo"))
        if params.get("OriginParameter") is not None:
            self._OriginParameter = IncrementalMigrationHttpOriginParameter()
            self._OriginParameter._deserialize(params.get("OriginParameter"))
        self._Mode = params.get("Mode")
        if params.get("OriginCondition") is not None:
            self._OriginCondition = IncrementalMigrationHttpOriginCondition()
            self._OriginCondition._deserialize(params.get("OriginCondition"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpOriginInfo(AbstractModel):
    r"""Incremental migration source information.

    """

    def __init__(self):
        r"""
        :param _EndpointInfo: Incremental migration source address information.
        :type EndpointInfo: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpEndpointInfo`
        :param _FileInfo: Incremental migration source file information.
        :type FileInfo: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginFileInfo`
        """
        self._EndpointInfo = None
        self._FileInfo = None

    @property
    def EndpointInfo(self):
        r"""Incremental migration source address information.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpEndpointInfo`
        """
        return self._EndpointInfo

    @EndpointInfo.setter
    def EndpointInfo(self, EndpointInfo):
        self._EndpointInfo = EndpointInfo

    @property
    def FileInfo(self):
        r"""Incremental migration source file information.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginFileInfo`
        """
        return self._FileInfo

    @FileInfo.setter
    def FileInfo(self, FileInfo):
        self._FileInfo = FileInfo


    def _deserialize(self, params):
        if params.get("EndpointInfo") is not None:
            self._EndpointInfo = IncrementalMigrationHttpEndpointInfo()
            self._EndpointInfo._deserialize(params.get("EndpointInfo"))
        if params.get("FileInfo") is not None:
            self._FileInfo = IncrementalMigrationOriginFileInfo()
            self._FileInfo._deserialize(params.get("FileInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationHttpOriginParameter(AbstractModel):
    r"""Incremental migration back-to-source parameters.

    """

    def __init__(self):
        r"""
        :param _HttpHeaderInfo: HTTP header passthrough information.
        :type HttpHeaderInfo: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpHeaderInfo`
        :param _Protocol: Back-to-source protocol. Valid values:
<li>HTTP: Force HTTP;</li>
<li>HTTPS: Force HTTPS;</li>
<li>FOLLOW: Follow the request protocol.</li>
        :type Protocol: str
        :param _QueryStringFollowMode: Query string passthrough mode. Valid values
<li>FOLLOW: Fully passthrough;</li>
<li>IGNORE: No passthrough at all.</li>
        :type QueryStringFollowMode: str
        :param _HttpRedirectCode: HTTP Code for redirection. Currently, only `301`, `302`, and `307` are supported. The default value is `302`.
        :type HttpRedirectCode: int
        :param _OriginRedirectionFollowMode: Origin server redirection follow mode. Valid values:
<li>FOLLOW: Follow origin server redirection;</li>
<li>IGNORE: Ignore origin server redirection.</li>
        :type OriginRedirectionFollowMode: str
        """
        self._HttpHeaderInfo = None
        self._Protocol = None
        self._QueryStringFollowMode = None
        self._HttpRedirectCode = None
        self._OriginRedirectionFollowMode = None

    @property
    def HttpHeaderInfo(self):
        r"""HTTP header passthrough information.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpHeaderInfo`
        """
        return self._HttpHeaderInfo

    @HttpHeaderInfo.setter
    def HttpHeaderInfo(self, HttpHeaderInfo):
        self._HttpHeaderInfo = HttpHeaderInfo

    @property
    def Protocol(self):
        r"""Back-to-source protocol. Valid values:
<li>HTTP: Force HTTP;</li>
<li>HTTPS: Force HTTPS;</li>
<li>FOLLOW: Follow the request protocol.</li>
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def QueryStringFollowMode(self):
        r"""Query string passthrough mode. Valid values
<li>FOLLOW: Fully passthrough;</li>
<li>IGNORE: No passthrough at all.</li>
        :rtype: str
        """
        return self._QueryStringFollowMode

    @QueryStringFollowMode.setter
    def QueryStringFollowMode(self, QueryStringFollowMode):
        self._QueryStringFollowMode = QueryStringFollowMode

    @property
    def HttpRedirectCode(self):
        r"""HTTP Code for redirection. Currently, only `301`, `302`, and `307` are supported. The default value is `302`.
        :rtype: int
        """
        return self._HttpRedirectCode

    @HttpRedirectCode.setter
    def HttpRedirectCode(self, HttpRedirectCode):
        self._HttpRedirectCode = HttpRedirectCode

    @property
    def OriginRedirectionFollowMode(self):
        r"""Origin server redirection follow mode. Valid values:
<li>FOLLOW: Follow origin server redirection;</li>
<li>IGNORE: Ignore origin server redirection.</li>
        :rtype: str
        """
        return self._OriginRedirectionFollowMode

    @OriginRedirectionFollowMode.setter
    def OriginRedirectionFollowMode(self, OriginRedirectionFollowMode):
        self._OriginRedirectionFollowMode = OriginRedirectionFollowMode


    def _deserialize(self, params):
        if params.get("HttpHeaderInfo") is not None:
            self._HttpHeaderInfo = IncrementalMigrationHttpHeaderInfo()
            self._HttpHeaderInfo._deserialize(params.get("HttpHeaderInfo"))
        self._Protocol = params.get("Protocol")
        self._QueryStringFollowMode = params.get("QueryStringFollowMode")
        self._HttpRedirectCode = params.get("HttpRedirectCode")
        self._OriginRedirectionFollowMode = params.get("OriginRedirectionFollowMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationOriginFileInfo(AbstractModel):
    r"""Incremental migration of origin file information.

    """

    def __init__(self):
        r"""
        :param _PrefixConfig: File prefix configuration.
        :type PrefixConfig: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginPrefixConfig`
        :param _SuffixConfig: File 	suffix configuration.
        :type SuffixConfig: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginSuffixConfig`
        :param _FixedFileConfig: Fixed file configuration.
        :type FixedFileConfig: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginFixedFileConfig`
        """
        self._PrefixConfig = None
        self._SuffixConfig = None
        self._FixedFileConfig = None

    @property
    def PrefixConfig(self):
        r"""File prefix configuration.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginPrefixConfig`
        """
        return self._PrefixConfig

    @PrefixConfig.setter
    def PrefixConfig(self, PrefixConfig):
        self._PrefixConfig = PrefixConfig

    @property
    def SuffixConfig(self):
        r"""File 	suffix configuration.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginSuffixConfig`
        """
        return self._SuffixConfig

    @SuffixConfig.setter
    def SuffixConfig(self, SuffixConfig):
        self._SuffixConfig = SuffixConfig

    @property
    def FixedFileConfig(self):
        r"""Fixed file configuration.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationOriginFixedFileConfig`
        """
        return self._FixedFileConfig

    @FixedFileConfig.setter
    def FixedFileConfig(self, FixedFileConfig):
        self._FixedFileConfig = FixedFileConfig


    def _deserialize(self, params):
        if params.get("PrefixConfig") is not None:
            self._PrefixConfig = IncrementalMigrationOriginPrefixConfig()
            self._PrefixConfig._deserialize(params.get("PrefixConfig"))
        if params.get("SuffixConfig") is not None:
            self._SuffixConfig = IncrementalMigrationOriginSuffixConfig()
            self._SuffixConfig._deserialize(params.get("SuffixConfig"))
        if params.get("FixedFileConfig") is not None:
            self._FixedFileConfig = IncrementalMigrationOriginFixedFileConfig()
            self._FixedFileConfig._deserialize(params.get("FixedFileConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationOriginFixedFileConfig(AbstractModel):
    r"""Incremental migration of origin fixed file path configuration.

    """

    def __init__(self):
        r"""
        :param _FixedFilePath: Fixed file path: If you fill in `example/test.png`, the origin-pull address will be: `http(s)://<origin domain>/example/test.png`.
        :type FixedFilePath: str
        """
        self._FixedFilePath = None

    @property
    def FixedFilePath(self):
        r"""Fixed file path: If you fill in `example/test.png`, the origin-pull address will be: `http(s)://<origin domain>/example/test.png`.
        :rtype: str
        """
        return self._FixedFilePath

    @FixedFilePath.setter
    def FixedFilePath(self, FixedFilePath):
        self._FixedFilePath = FixedFilePath


    def _deserialize(self, params):
        self._FixedFilePath = params.get("FixedFilePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationOriginPrefixConfig(AbstractModel):
    r"""Incremental migration of origin address prefix configuration.

    """

    def __init__(self):
        r"""
        :param _Prefix: Origin address prefix: If you fill in `test/`, the origin-pull address will be `http(s)://<origin domain>/test/<file name>`.
        :type Prefix: str
        """
        self._Prefix = None

    @property
    def Prefix(self):
        r"""Origin address prefix: If you fill in `test/`, the origin-pull address will be `http(s)://<origin domain>/test/<file name>`.
        :rtype: str
        """
        return self._Prefix

    @Prefix.setter
    def Prefix(self, Prefix):
        self._Prefix = Prefix


    def _deserialize(self, params):
        self._Prefix = params.get("Prefix")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationOriginSuffixConfig(AbstractModel):
    r"""Incremental migration of origin file suffix configuration.

    """

    def __init__(self):
        r"""
        :param _Suffix: File suffix.
if filled with `.ts`, the origin-pull address will be: `http(s)://<origin domain>/<file name>.ts`.
        :type Suffix: str
        """
        self._Suffix = None

    @property
    def Suffix(self):
        r"""File suffix.
if filled with `.ts`, the origin-pull address will be: `http(s)://<origin domain>/<file name>.ts`.
        :rtype: str
        """
        return self._Suffix

    @Suffix.setter
    def Suffix(self, Suffix):
        self._Suffix = Suffix


    def _deserialize(self, params):
        self._Suffix = params.get("Suffix")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IncrementalMigrationStrategyInfo(AbstractModel):
    r"""Incremental migration strategy information.

    """

    def __init__(self):
        r"""
        :param _StrategyId: The ID of the incremental migration strategy.
        :type StrategyId: str
        :param _StrategyName: The name of the incremental migration strategy.
        :type StrategyName: str
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _BucketId: The bucket ID where the strategy takes effect.
        :type BucketId: str
        :param _OriginType: Source type.
        :type OriginType: str
        :param _HttpOriginConfig: Incremental migration HTTP origin source configuration.
        :type HttpOriginConfig: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginConfig`
        """
        self._StrategyId = None
        self._StrategyName = None
        self._SubAppId = None
        self._BucketId = None
        self._OriginType = None
        self._HttpOriginConfig = None

    @property
    def StrategyId(self):
        r"""The ID of the incremental migration strategy.
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def StrategyName(self):
        r"""The name of the incremental migration strategy.
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BucketId(self):
        r"""The bucket ID where the strategy takes effect.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def OriginType(self):
        r"""Source type.
        :rtype: str
        """
        return self._OriginType

    @OriginType.setter
    def OriginType(self, OriginType):
        self._OriginType = OriginType

    @property
    def HttpOriginConfig(self):
        r"""Incremental migration HTTP origin source configuration.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginConfig`
        """
        return self._HttpOriginConfig

    @HttpOriginConfig.setter
    def HttpOriginConfig(self, HttpOriginConfig):
        self._HttpOriginConfig = HttpOriginConfig


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._StrategyName = params.get("StrategyName")
        self._SubAppId = params.get("SubAppId")
        self._BucketId = params.get("BucketId")
        self._OriginType = params.get("OriginType")
        if params.get("HttpOriginConfig") is not None:
            self._HttpOriginConfig = IncrementalMigrationHttpOriginConfig()
            self._HttpOriginConfig._deserialize(params.get("HttpOriginConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIncrementalMigrationStrategyRequest(AbstractModel):
    r"""ModifyIncrementalMigrationStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :type SubAppId: int
        :param _BucketId: The bucket ID where the strategy takes effect.
        :type BucketId: str
        :param _StrategyId: The ID of the incremental migration strategy.
        :type StrategyId: str
        :param _StrategyName: The name of the incremental migration strategy.
        :type StrategyName: str
        :param _OriginType: Source type. Valid values: 
<li>HTTP: (Default) the source type is HTTP.</li>
        :type OriginType: str
        :param _HttpOriginConfig: Incremental migration HTTP origin source configuration. If left blank, it will default to no modification.
        :type HttpOriginConfig: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginConfig`
        """
        self._SubAppId = None
        self._BucketId = None
        self._StrategyId = None
        self._StrategyName = None
        self._OriginType = None
        self._HttpOriginConfig = None

    @property
    def SubAppId(self):
        r"""<b>The ID of [VOD Professional Application](http://tencentcloud.com/document/product/266/67977).</b>
        :rtype: int
        """
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def BucketId(self):
        r"""The bucket ID where the strategy takes effect.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def StrategyId(self):
        r"""The ID of the incremental migration strategy.
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def StrategyName(self):
        r"""The name of the incremental migration strategy.
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def OriginType(self):
        r"""Source type. Valid values: 
<li>HTTP: (Default) the source type is HTTP.</li>
        :rtype: str
        """
        return self._OriginType

    @OriginType.setter
    def OriginType(self, OriginType):
        self._OriginType = OriginType

    @property
    def HttpOriginConfig(self):
        r"""Incremental migration HTTP origin source configuration. If left blank, it will default to no modification.
        :rtype: :class:`tencentcloud.vod.v20240718.models.IncrementalMigrationHttpOriginConfig`
        """
        return self._HttpOriginConfig

    @HttpOriginConfig.setter
    def HttpOriginConfig(self, HttpOriginConfig):
        self._HttpOriginConfig = HttpOriginConfig


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._BucketId = params.get("BucketId")
        self._StrategyId = params.get("StrategyId")
        self._StrategyName = params.get("StrategyName")
        self._OriginType = params.get("OriginType")
        if params.get("HttpOriginConfig") is not None:
            self._HttpOriginConfig = IncrementalMigrationHttpOriginConfig()
            self._HttpOriginConfig._deserialize(params.get("HttpOriginConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIncrementalMigrationStrategyResponse(AbstractModel):
    r"""ModifyIncrementalMigrationStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SortBy(AbstractModel):
    r"""Sort by criterion

    """

    def __init__(self):
        r"""
        :param _Field: Sort by field
        :type Field: str
        :param _Order: Sorting order. Valid values: Asc (ascending), Desc (descending)
        :type Order: str
        """
        self._Field = None
        self._Order = None

    @property
    def Field(self):
        r"""Sort by field
        :rtype: str
        """
        return self._Field

    @Field.setter
    def Field(self, Field):
        self._Field = Field

    @property
    def Order(self):
        r"""Sorting order. Valid values: Asc (ascending), Desc (descending)
        :rtype: str
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Field = params.get("Field")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StorageInfo(AbstractModel):
    r"""Storage information for the professional application.

    """

    def __init__(self):
        r"""
        :param _BucketId: The ID of bucket.
        :type BucketId: str
        :param _StorageName: The name of bucket.
        :type StorageName: str
        :param _StorageRegion: The region of storage.
        :type StorageRegion: str
        :param _InternetAccessDomainStatus: The status of the internet access domain name is stored. Valid values: <li>ONLINE: Active;</li> <li>DEPLOYING: In deployment.</li>
        :type InternetAccessDomainStatus: str
        :param _InternetAccessDomain: The internet access domain name of storage.
        :type InternetAccessDomain: str
        :param _CreateTime: The creation time of the storage.
        :type CreateTime: str
        """
        self._BucketId = None
        self._StorageName = None
        self._StorageRegion = None
        self._InternetAccessDomainStatus = None
        self._InternetAccessDomain = None
        self._CreateTime = None

    @property
    def BucketId(self):
        r"""The ID of bucket.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def StorageName(self):
        r"""The name of bucket.
        :rtype: str
        """
        return self._StorageName

    @StorageName.setter
    def StorageName(self, StorageName):
        self._StorageName = StorageName

    @property
    def StorageRegion(self):
        r"""The region of storage.
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def InternetAccessDomainStatus(self):
        r"""The status of the internet access domain name is stored. Valid values: <li>ONLINE: Active;</li> <li>DEPLOYING: In deployment.</li>
        :rtype: str
        """
        return self._InternetAccessDomainStatus

    @InternetAccessDomainStatus.setter
    def InternetAccessDomainStatus(self, InternetAccessDomainStatus):
        self._InternetAccessDomainStatus = InternetAccessDomainStatus

    @property
    def InternetAccessDomain(self):
        r"""The internet access domain name of storage.
        :rtype: str
        """
        return self._InternetAccessDomain

    @InternetAccessDomain.setter
    def InternetAccessDomain(self, InternetAccessDomain):
        self._InternetAccessDomain = InternetAccessDomain

    @property
    def CreateTime(self):
        r"""The creation time of the storage.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._BucketId = params.get("BucketId")
        self._StorageName = params.get("StorageName")
        self._StorageRegion = params.get("StorageRegion")
        self._InternetAccessDomainStatus = params.get("InternetAccessDomainStatus")
        self._InternetAccessDomain = params.get("InternetAccessDomain")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        