# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class DescribeImageAnimateJobRequest(AbstractModel):
    r"""DescribeImageAnimateJob request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Task ID.
        :type JobId: str
        """
        self._JobId = None

    @property
    def JobId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAnimateJobResponse(AbstractModel):
    r"""DescribeImageAnimateJob response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful.
        :type Status: str
        :param _ErrorCode: Error code.
        :type ErrorCode: str
        :param _ErrorMessage: Error message.
        :type ErrorMessage: str
        :param _ResultVideoUrl: Generated video URL. It is valid for 24 hours.
        :type ResultVideoUrl: str
        :param _MaskVideoUrl: Masked video URL.
        :type MaskVideoUrl: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._ErrorCode = None
        self._ErrorMessage = None
        self._ResultVideoUrl = None
        self._MaskVideoUrl = None
        self._RequestId = None

    @property
    def Status(self):
        r"""Task status. WAIT: waiting; RUN: running; FAIL: failed; DONE: successful.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrorCode(self):
        r"""Error code.
        :rtype: str
        """
        return self._ErrorCode

    @ErrorCode.setter
    def ErrorCode(self, ErrorCode):
        self._ErrorCode = ErrorCode

    @property
    def ErrorMessage(self):
        r"""Error message.
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def ResultVideoUrl(self):
        r"""Generated video URL. It is valid for 24 hours.
        :rtype: str
        """
        return self._ResultVideoUrl

    @ResultVideoUrl.setter
    def ResultVideoUrl(self, ResultVideoUrl):
        self._ResultVideoUrl = ResultVideoUrl

    @property
    def MaskVideoUrl(self):
        r"""Masked video URL.
        :rtype: str
        """
        return self._MaskVideoUrl

    @MaskVideoUrl.setter
    def MaskVideoUrl(self, MaskVideoUrl):
        self._MaskVideoUrl = MaskVideoUrl

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrorCode = params.get("ErrorCode")
        self._ErrorMessage = params.get("ErrorMessage")
        self._ResultVideoUrl = params.get("ResultVideoUrl")
        self._MaskVideoUrl = params.get("MaskVideoUrl")
        self._RequestId = params.get("RequestId")


class LogoParam(AbstractModel):
    r"""Logo parameter

    """

    def __init__(self):
        r"""
        :param _LogoUrl: Watermark URL

Note: This field may return null, indicating that no valid values can be obtained.
        :type LogoUrl: str
        :param _LogoImage: Watermark Base64 code is supported. Either the Base64 code or URL must be provided. If both are provided, the URL prevails.

Note: This field may return null, indicating that no valid values can be obtained.
        :type LogoImage: str
        :param _LogoRect: The coordinates of the watermark image in the generated image. The mark image will be expanded according to the coordinates.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogoRect: :class:`tencentcloud.vclm.v20240523.models.LogoRect`
        """
        self._LogoUrl = None
        self._LogoImage = None
        self._LogoRect = None

    @property
    def LogoUrl(self):
        r"""Watermark URL

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LogoUrl

    @LogoUrl.setter
    def LogoUrl(self, LogoUrl):
        self._LogoUrl = LogoUrl

    @property
    def LogoImage(self):
        r"""Watermark Base64 code is supported. Either the Base64 code or URL must be provided. If both are provided, the URL prevails.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LogoImage

    @LogoImage.setter
    def LogoImage(self, LogoImage):
        self._LogoImage = LogoImage

    @property
    def LogoRect(self):
        r"""The coordinates of the watermark image in the generated image. The mark image will be expanded according to the coordinates.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.vclm.v20240523.models.LogoRect`
        """
        return self._LogoRect

    @LogoRect.setter
    def LogoRect(self, LogoRect):
        self._LogoRect = LogoRect


    def _deserialize(self, params):
        self._LogoUrl = params.get("LogoUrl")
        self._LogoImage = params.get("LogoImage")
        if params.get("LogoRect") is not None:
            self._LogoRect = LogoRect()
            self._LogoRect._deserialize(params.get("LogoRect"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogoRect(AbstractModel):
    r"""Input box

    """

    def __init__(self):
        r"""
        :param _X: X-axis coordinate of the upper left corner

Note: This field may return null, indicating that no valid values can be obtained.
        :type X: int
        :param _Y: Y-axis coordinate of the upper left corner

Note: This field may return null, indicating that no valid values can be obtained.
        :type Y: int
        :param _Width: Box width

Note: This field may return null, indicating that no valid values can be obtained.
        :type Width: int
        :param _Height: Box height

Note: This field may return null, indicating that no valid values can be obtained.
        :type Height: int
        """
        self._X = None
        self._Y = None
        self._Width = None
        self._Height = None

    @property
    def X(self):
        r"""X-axis coordinate of the upper left corner

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._X

    @X.setter
    def X(self, X):
        self._X = X

    @property
    def Y(self):
        r"""Y-axis coordinate of the upper left corner

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Y

    @Y.setter
    def Y(self, Y):
        self._Y = Y

    @property
    def Width(self):
        r"""Box width

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Box height

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._X = params.get("X")
        self._Y = params.get("Y")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubmitImageAnimateJobRequest(AbstractModel):
    r"""SubmitImageAnimateJob request structure.

    """

    def __init__(self):
        r"""
        :param _ImageUrl: Image format: PNG, JPG, and JPEG formats are supported.
Image resolution: The long edge resolution should not exceed 2056.
Image size: The size should not exceed 10 MB.
Image aspect ratio: The ratio of width to height should be in the range of 1:2 to 1:1.2.
        :type ImageUrl: str
        :param _ImageBase64: Image information after Base64 encoding. Image format: PNG, JPG, and JPEG formats are supported. Image resolution: The long side resolution should not exceed 2056. Image size: The size should not exceed 10 MB. Image aspect ratio: The ratio of width to height should be in the range of 1:2 to 1:1.2.
        :type ImageBase64: str
        :param _TemplateId: Action template ID. ke3: kemusan; tuziwu: rabbit dance; huajiangwu: paddling dance.

        :type TemplateId: str
        :param _EnableAudio: Whether the generated video retains the audio in the template. The default value is true.
        :type EnableAudio: bool
        :param _EnableBodyJoins: Whether to detect 12 body parts in the input image (head, neck, right shoulder, right elbow, right wrist, left shoulder, left elbow, left wrist, right hip, left hip, left knee, and right knee). They are not detected by default.
        :type EnableBodyJoins: bool
        :param _EnableSegment: Whether the final video retains the background of the original image. (This parameter does not take effect when TemplateId is set to tuziwu or huajiangwu.)

        :type EnableSegment: bool
        :param _LogoAdd: Whether to add a mark to the generated video. The default value is 0.
1: A mark is added.
0: No mark is added.
Other values: A mark is added by default.
It is recommended to use an obvious mark to indicate that the video is synthesized by AI.
        :type LogoAdd: int
        :param _LogoParam: Mark text settings.
By default, the text "Synthesized by AI" is added to the bottom right corner of the generated video. You can also use other text images.
        :type LogoParam: :class:`tencentcloud.vclm.v20240523.models.LogoParam`
        """
        self._ImageUrl = None
        self._ImageBase64 = None
        self._TemplateId = None
        self._EnableAudio = None
        self._EnableBodyJoins = None
        self._EnableSegment = None
        self._LogoAdd = None
        self._LogoParam = None

    @property
    def ImageUrl(self):
        r"""Image format: PNG, JPG, and JPEG formats are supported.
Image resolution: The long edge resolution should not exceed 2056.
Image size: The size should not exceed 10 MB.
Image aspect ratio: The ratio of width to height should be in the range of 1:2 to 1:1.2.
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def ImageBase64(self):
        r"""Image information after Base64 encoding. Image format: PNG, JPG, and JPEG formats are supported. Image resolution: The long side resolution should not exceed 2056. Image size: The size should not exceed 10 MB. Image aspect ratio: The ratio of width to height should be in the range of 1:2 to 1:1.2.
        :rtype: str
        """
        return self._ImageBase64

    @ImageBase64.setter
    def ImageBase64(self, ImageBase64):
        self._ImageBase64 = ImageBase64

    @property
    def TemplateId(self):
        r"""Action template ID. ke3: kemusan; tuziwu: rabbit dance; huajiangwu: paddling dance.

        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def EnableAudio(self):
        r"""Whether the generated video retains the audio in the template. The default value is true.
        :rtype: bool
        """
        return self._EnableAudio

    @EnableAudio.setter
    def EnableAudio(self, EnableAudio):
        self._EnableAudio = EnableAudio

    @property
    def EnableBodyJoins(self):
        r"""Whether to detect 12 body parts in the input image (head, neck, right shoulder, right elbow, right wrist, left shoulder, left elbow, left wrist, right hip, left hip, left knee, and right knee). They are not detected by default.
        :rtype: bool
        """
        return self._EnableBodyJoins

    @EnableBodyJoins.setter
    def EnableBodyJoins(self, EnableBodyJoins):
        self._EnableBodyJoins = EnableBodyJoins

    @property
    def EnableSegment(self):
        r"""Whether the final video retains the background of the original image. (This parameter does not take effect when TemplateId is set to tuziwu or huajiangwu.)

        :rtype: bool
        """
        return self._EnableSegment

    @EnableSegment.setter
    def EnableSegment(self, EnableSegment):
        self._EnableSegment = EnableSegment

    @property
    def LogoAdd(self):
        r"""Whether to add a mark to the generated video. The default value is 0.
1: A mark is added.
0: No mark is added.
Other values: A mark is added by default.
It is recommended to use an obvious mark to indicate that the video is synthesized by AI.
        :rtype: int
        """
        return self._LogoAdd

    @LogoAdd.setter
    def LogoAdd(self, LogoAdd):
        self._LogoAdd = LogoAdd

    @property
    def LogoParam(self):
        r"""Mark text settings.
By default, the text "Synthesized by AI" is added to the bottom right corner of the generated video. You can also use other text images.
        :rtype: :class:`tencentcloud.vclm.v20240523.models.LogoParam`
        """
        return self._LogoParam

    @LogoParam.setter
    def LogoParam(self, LogoParam):
        self._LogoParam = LogoParam


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._ImageBase64 = params.get("ImageBase64")
        self._TemplateId = params.get("TemplateId")
        self._EnableAudio = params.get("EnableAudio")
        self._EnableBodyJoins = params.get("EnableBodyJoins")
        self._EnableSegment = params.get("EnableSegment")
        self._LogoAdd = params.get("LogoAdd")
        if params.get("LogoParam") is not None:
            self._LogoParam = LogoParam()
            self._LogoParam._deserialize(params.get("LogoParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubmitImageAnimateJobResponse(AbstractModel):
    r"""SubmitImageAnimateJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Task ID.
        :type JobId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")