# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class ChangeMigratingTopicToNextStageRequest(AbstractModel):
    r"""ChangeMigratingTopicToNextStage request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        :param _TopicNameList: List of topic names. topic name can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the api [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in data type.

        :type TopicNameList: list of str
        :param _NamespaceList: Namespace list. It is valid only for 4.x clusters and has a one-to-one relationship with TopicNameList. The list can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :type NamespaceList: list of str
        """
        self._TaskId = None
        self._TopicNameList = None
        self._NamespaceList = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TopicNameList(self):
        r"""List of topic names. topic name can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the api [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in data type.

        :rtype: list of str
        """
        return self._TopicNameList

    @TopicNameList.setter
    def TopicNameList(self, TopicNameList):
        self._TopicNameList = TopicNameList

    @property
    def NamespaceList(self):
        r"""Namespace list. It is valid only for 4.x clusters and has a one-to-one relationship with TopicNameList. The list can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :rtype: list of str
        """
        return self._NamespaceList

    @NamespaceList.setter
    def NamespaceList(self, NamespaceList):
        self._NamespaceList = NamespaceList


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TopicNameList = params.get("TopicNameList")
        self._NamespaceList = params.get("NamespaceList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeMigratingTopicToNextStageResponse(AbstractModel):
    r"""ChangeMigratingTopicToNextStage response structure.

    """

    def __init__(self):
        r"""
        :param _Results: Result list of migration topic status modification.
        :type Results: list of TopicStageChangeResult
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Results = None
        self._RequestId = None

    @property
    def Results(self):
        r"""Result list of migration topic status modification.
        :rtype: list of TopicStageChangeResult
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = TopicStageChangeResult()
                obj._deserialize(item)
                self._Results.append(obj)
        self._RequestId = params.get("RequestId")


class ClientSubscriptionInfo(AbstractModel):
    r"""Client subscription details, which are used to help determine clients with inconsistent subscription relationships.

    """

    def __init__(self):
        r"""
        :param _ClientId: Client ID
        :type ClientId: str
        :param _ClientAddr: Client ip address.
        :type ClientAddr: str
        :param _Topic: Specifies the subscribed topic.
        :type Topic: str
        :param _SubString: Subscription expression.
        :type SubString: str
        :param _ExpressionType: Specifies the subscription method.
        :type ExpressionType: str
        """
        self._ClientId = None
        self._ClientAddr = None
        self._Topic = None
        self._SubString = None
        self._ExpressionType = None

    @property
    def ClientId(self):
        r"""Client ID
        :rtype: str
        """
        return self._ClientId

    @ClientId.setter
    def ClientId(self, ClientId):
        self._ClientId = ClientId

    @property
    def ClientAddr(self):
        r"""Client ip address.
        :rtype: str
        """
        return self._ClientAddr

    @ClientAddr.setter
    def ClientAddr(self, ClientAddr):
        self._ClientAddr = ClientAddr

    @property
    def Topic(self):
        r"""Specifies the subscribed topic.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def SubString(self):
        r"""Subscription expression.
        :rtype: str
        """
        return self._SubString

    @SubString.setter
    def SubString(self, SubString):
        self._SubString = SubString

    @property
    def ExpressionType(self):
        r"""Specifies the subscription method.
        :rtype: str
        """
        return self._ExpressionType

    @ExpressionType.setter
    def ExpressionType(self, ExpressionType):
        self._ExpressionType = ExpressionType


    def _deserialize(self, params):
        self._ClientId = params.get("ClientId")
        self._ClientAddr = params.get("ClientAddr")
        self._Topic = params.get("Topic")
        self._SubString = params.get("SubString")
        self._ExpressionType = params.get("ExpressionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConsumerClient(AbstractModel):
    r"""Consumer client

    """

    def __init__(self):
        r"""
        :param _ClientId: Client ID
        :type ClientId: str
        :param _ClientAddr: Client address.
        :type ClientAddr: str
        :param _Language: Client SDK language
        :type Language: str
        :param _Version: Client SDK version
        :type Version: str
        :param _ConsumerLag: Client consumption heap

Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerLag: int
        :param _ChannelProtocol: Consumer client type. valid values:.

-Specifies the grpc protocol.
-remoting protocol.
-http protocol.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ChannelProtocol: str
        """
        self._ClientId = None
        self._ClientAddr = None
        self._Language = None
        self._Version = None
        self._ConsumerLag = None
        self._ChannelProtocol = None

    @property
    def ClientId(self):
        r"""Client ID
        :rtype: str
        """
        return self._ClientId

    @ClientId.setter
    def ClientId(self, ClientId):
        self._ClientId = ClientId

    @property
    def ClientAddr(self):
        r"""Client address.
        :rtype: str
        """
        return self._ClientAddr

    @ClientAddr.setter
    def ClientAddr(self, ClientAddr):
        self._ClientAddr = ClientAddr

    @property
    def Language(self):
        r"""Client SDK language
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Version(self):
        r"""Client SDK version
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def ConsumerLag(self):
        r"""Client consumption heap

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ConsumerLag

    @ConsumerLag.setter
    def ConsumerLag(self, ConsumerLag):
        self._ConsumerLag = ConsumerLag

    @property
    def ChannelProtocol(self):
        r"""Consumer client type. valid values:.

-Specifies the grpc protocol.
-remoting protocol.
-http protocol.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChannelProtocol

    @ChannelProtocol.setter
    def ChannelProtocol(self, ChannelProtocol):
        self._ChannelProtocol = ChannelProtocol


    def _deserialize(self, params):
        self._ClientId = params.get("ClientId")
        self._ClientAddr = params.get("ClientAddr")
        self._Language = params.get("Language")
        self._Version = params.get("Version")
        self._ConsumerLag = params.get("ConsumerLag")
        self._ChannelProtocol = params.get("ChannelProtocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConsumerGroupRequest(AbstractModel):
    r"""CreateConsumerGroup request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _MaxRetryTimes: Maximum number of retries. Value range: 0 to 1000.
        :type MaxRetryTimes: int
        :param _ConsumeEnable: Whether to enable consumption.
        :type ConsumeEnable: bool
        :param _ConsumeMessageOrderly: Specifies whether to use ordered delivery. valid values: true.
Concurrent delivery: false.
        :type ConsumeMessageOrderly: bool
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        :param _Remark: Remarks. Up to 128 characters are allowed.
        :type Remark: str
        :param _TagList: Tag list
        :type TagList: list of Tag
        """
        self._InstanceId = None
        self._MaxRetryTimes = None
        self._ConsumeEnable = None
        self._ConsumeMessageOrderly = None
        self._ConsumerGroup = None
        self._Remark = None
        self._TagList = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def MaxRetryTimes(self):
        r"""Maximum number of retries. Value range: 0 to 1000.
        :rtype: int
        """
        return self._MaxRetryTimes

    @MaxRetryTimes.setter
    def MaxRetryTimes(self, MaxRetryTimes):
        self._MaxRetryTimes = MaxRetryTimes

    @property
    def ConsumeEnable(self):
        r"""Whether to enable consumption.
        :rtype: bool
        """
        return self._ConsumeEnable

    @ConsumeEnable.setter
    def ConsumeEnable(self, ConsumeEnable):
        self._ConsumeEnable = ConsumeEnable

    @property
    def ConsumeMessageOrderly(self):
        r"""Specifies whether to use ordered delivery. valid values: true.
Concurrent delivery: false.
        :rtype: bool
        """
        return self._ConsumeMessageOrderly

    @ConsumeMessageOrderly.setter
    def ConsumeMessageOrderly(self, ConsumeMessageOrderly):
        self._ConsumeMessageOrderly = ConsumeMessageOrderly

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def Remark(self):
        r"""Remarks. Up to 128 characters are allowed.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TagList(self):
        r"""Tag list
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._MaxRetryTimes = params.get("MaxRetryTimes")
        self._ConsumeEnable = params.get("ConsumeEnable")
        self._ConsumeMessageOrderly = params.get("ConsumeMessageOrderly")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._Remark = params.get("Remark")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConsumerGroupResponse(AbstractModel):
    r"""CreateConsumerGroup response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID
        :type InstanceId: str
        :param _ConsumerGroup: Specifies the consumer group name.
        :type ConsumerGroup: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._ConsumerGroup = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConsumerGroup(self):
        r"""Specifies the consumer group name.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._RequestId = params.get("RequestId")


class CreateInstanceRequest(AbstractModel):
    r"""CreateInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceType: Instance type. valid values are as follows:.

-EXPERIMENT: specifies the trial version.

- BASIC: BASIC edition.

-PRO edition.

-PLATINUM: platinum version.
        :type InstanceType: str
        :param _Name: Cluster name. values cannot be empty. 3-64 characters, only comprised of digits, letters, "-", and "_".
        :type Name: str
        :param _SkuCode: Product specification. It can be obtained from the output parameters of [ProductSKU](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU) of the API [DescribeProductSKUs](https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).
        :type SkuCode: str
        :param _VpcList: Specifies the VPC information bound to the cluster.
        :type VpcList: list of VpcInfo
        :param _Remark: Remarks
        :type Remark: str
        :param _TagList: Tag list
        :type TagList: list of Tag
        :param _EnablePublic: Whether public network access is enabled. the default value of false means not enabled.
        :type EnablePublic: bool
        :param _BillingFlow: Whether the public network is billed by traffic. the default value is false, which indicates that the public network is not billed by traffic.
        :type BillingFlow: bool
        :param _Bandwidth: Public network bandwidth (unit: mbps). the default value is 0. if public network access is enabled, this field must be a positive integer above 0.
        :type Bandwidth: int
        :param _IpRules: Public network access allowlist. if left blank, it means deny all IP access.
        :type IpRules: list of IpRule
        :param _MessageRetention: Message retention time (unit: hr). value range refers to the ProductSKU response parameters structure in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).

-Default value: DefaultRetention parameter.
-Minimum value: specifies the RetentionLowerLimit parameter.
-Specifies the maximum value of the RetentionUpperLimit parameter.
        :type MessageRetention: int
        :param _PayMode: Payment mode (0: postpaid; 1: prepaid). the default value is 0.
        :type PayMode: int
        :param _RenewFlag: Whether the prepaid cluster is automatically renewed (0: no auto-renewal; 1: auto-renewal). default value: 0.
        :type RenewFlag: int
        :param _TimeSpan: Specifies the purchase duration (unit: month) for a prepaid cluster. value range: 1–60. default value: 1.
        :type TimeSpan: int
        :param _MaxTopicNum: Specifies the maximum number of topics that can be created. obtained from the ProductSKU response parameters structure in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1) (https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU).

-Default value and minimum value: specifies the TopicNumLimit parameter.
-Maximum value of TopicNumUpperLimit parameter.
        :type MaxTopicNum: int
        :param _ZoneIds: Deployment AZ list. obtain from the [ZoneInfo](https://www.tencentcloud.comom/document/api/1596/77932?from_cn_redirect=1#ZoneInfo) data structure returned by the api [DescribeZones](https://www.tencentcloud.comom/document/product/1596/77929?from_cn_redirect=1).
        :type ZoneIds: list of int
        """
        self._InstanceType = None
        self._Name = None
        self._SkuCode = None
        self._VpcList = None
        self._Remark = None
        self._TagList = None
        self._EnablePublic = None
        self._BillingFlow = None
        self._Bandwidth = None
        self._IpRules = None
        self._MessageRetention = None
        self._PayMode = None
        self._RenewFlag = None
        self._TimeSpan = None
        self._MaxTopicNum = None
        self._ZoneIds = None

    @property
    def InstanceType(self):
        r"""Instance type. valid values are as follows:.

-EXPERIMENT: specifies the trial version.

- BASIC: BASIC edition.

-PRO edition.

-PLATINUM: platinum version.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Name(self):
        r"""Cluster name. values cannot be empty. 3-64 characters, only comprised of digits, letters, "-", and "_".
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SkuCode(self):
        r"""Product specification. It can be obtained from the output parameters of [ProductSKU](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU) of the API [DescribeProductSKUs](https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).
        :rtype: str
        """
        return self._SkuCode

    @SkuCode.setter
    def SkuCode(self, SkuCode):
        self._SkuCode = SkuCode

    @property
    def VpcList(self):
        r"""Specifies the VPC information bound to the cluster.
        :rtype: list of VpcInfo
        """
        return self._VpcList

    @VpcList.setter
    def VpcList(self, VpcList):
        self._VpcList = VpcList

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TagList(self):
        r"""Tag list
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList

    @property
    def EnablePublic(self):
        r"""Whether public network access is enabled. the default value of false means not enabled.
        :rtype: bool
        """
        return self._EnablePublic

    @EnablePublic.setter
    def EnablePublic(self, EnablePublic):
        self._EnablePublic = EnablePublic

    @property
    def BillingFlow(self):
        r"""Whether the public network is billed by traffic. the default value is false, which indicates that the public network is not billed by traffic.
        :rtype: bool
        """
        return self._BillingFlow

    @BillingFlow.setter
    def BillingFlow(self, BillingFlow):
        self._BillingFlow = BillingFlow

    @property
    def Bandwidth(self):
        r"""Public network bandwidth (unit: mbps). the default value is 0. if public network access is enabled, this field must be a positive integer above 0.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def IpRules(self):
        r"""Public network access allowlist. if left blank, it means deny all IP access.
        :rtype: list of IpRule
        """
        return self._IpRules

    @IpRules.setter
    def IpRules(self, IpRules):
        self._IpRules = IpRules

    @property
    def MessageRetention(self):
        r"""Message retention time (unit: hr). value range refers to the ProductSKU response parameters structure in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).

-Default value: DefaultRetention parameter.
-Minimum value: specifies the RetentionLowerLimit parameter.
-Specifies the maximum value of the RetentionUpperLimit parameter.
        :rtype: int
        """
        return self._MessageRetention

    @MessageRetention.setter
    def MessageRetention(self, MessageRetention):
        self._MessageRetention = MessageRetention

    @property
    def PayMode(self):
        r"""Payment mode (0: postpaid; 1: prepaid). the default value is 0.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def RenewFlag(self):
        r"""Whether the prepaid cluster is automatically renewed (0: no auto-renewal; 1: auto-renewal). default value: 0.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def TimeSpan(self):
        r"""Specifies the purchase duration (unit: month) for a prepaid cluster. value range: 1–60. default value: 1.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def MaxTopicNum(self):
        r"""Specifies the maximum number of topics that can be created. obtained from the ProductSKU response parameters structure in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1) (https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU).

-Default value and minimum value: specifies the TopicNumLimit parameter.
-Maximum value of TopicNumUpperLimit parameter.
        :rtype: int
        """
        return self._MaxTopicNum

    @MaxTopicNum.setter
    def MaxTopicNum(self, MaxTopicNum):
        self._MaxTopicNum = MaxTopicNum

    @property
    def ZoneIds(self):
        r"""Deployment AZ list. obtain from the [ZoneInfo](https://www.tencentcloud.comom/document/api/1596/77932?from_cn_redirect=1#ZoneInfo) data structure returned by the api [DescribeZones](https://www.tencentcloud.comom/document/product/1596/77929?from_cn_redirect=1).
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._Name = params.get("Name")
        self._SkuCode = params.get("SkuCode")
        if params.get("VpcList") is not None:
            self._VpcList = []
            for item in params.get("VpcList"):
                obj = VpcInfo()
                obj._deserialize(item)
                self._VpcList.append(obj)
        self._Remark = params.get("Remark")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        self._EnablePublic = params.get("EnablePublic")
        self._BillingFlow = params.get("BillingFlow")
        self._Bandwidth = params.get("Bandwidth")
        if params.get("IpRules") is not None:
            self._IpRules = []
            for item in params.get("IpRules"):
                obj = IpRule()
                obj._deserialize(item)
                self._IpRules.append(obj)
        self._MessageRetention = params.get("MessageRetention")
        self._PayMode = params.get("PayMode")
        self._RenewFlag = params.get("RenewFlag")
        self._TimeSpan = params.get("TimeSpan")
        self._MaxTopicNum = params.get("MaxTopicNum")
        self._ZoneIds = params.get("ZoneIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInstanceResponse(AbstractModel):
    r"""CreateInstance response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class CreateRoleRequest(AbstractModel):
    r"""CreateRole request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Role: Role name. It cannot be left blank. Only digits, uppercase and lowercase letters, and separators (_ -) are supported. The name cannot exceed 32 characters.
        :type Role: str
        :param _PermWrite: Whether to enable production permission
        :type PermWrite: bool
        :param _PermRead: Whether to enable consumption permission
        :type PermRead: bool
        :param _Remark: Remarks
        :type Remark: str
        :param _PermType: Specifies the types of permissions. the default is to authorize by Cluster (Cluster: at the Cluster level; TopicAndGroup: topic and consumer group level).
        :type PermType: str
        :param _DetailedPerms: Permission configuration in the topic/group dimension. It is required when the permission type parameter is set to TopicAndGroup.
        :type DetailedPerms: list of DetailedRolePerm
        """
        self._InstanceId = None
        self._Role = None
        self._PermWrite = None
        self._PermRead = None
        self._Remark = None
        self._PermType = None
        self._DetailedPerms = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Role(self):
        r"""Role name. It cannot be left blank. Only digits, uppercase and lowercase letters, and separators (_ -) are supported. The name cannot exceed 32 characters.
        :rtype: str
        """
        return self._Role

    @Role.setter
    def Role(self, Role):
        self._Role = Role

    @property
    def PermWrite(self):
        r"""Whether to enable production permission
        :rtype: bool
        """
        return self._PermWrite

    @PermWrite.setter
    def PermWrite(self, PermWrite):
        self._PermWrite = PermWrite

    @property
    def PermRead(self):
        r"""Whether to enable consumption permission
        :rtype: bool
        """
        return self._PermRead

    @PermRead.setter
    def PermRead(self, PermRead):
        self._PermRead = PermRead

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PermType(self):
        r"""Specifies the types of permissions. the default is to authorize by Cluster (Cluster: at the Cluster level; TopicAndGroup: topic and consumer group level).
        :rtype: str
        """
        return self._PermType

    @PermType.setter
    def PermType(self, PermType):
        self._PermType = PermType

    @property
    def DetailedPerms(self):
        r"""Permission configuration in the topic/group dimension. It is required when the permission type parameter is set to TopicAndGroup.
        :rtype: list of DetailedRolePerm
        """
        return self._DetailedPerms

    @DetailedPerms.setter
    def DetailedPerms(self, DetailedPerms):
        self._DetailedPerms = DetailedPerms


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Role = params.get("Role")
        self._PermWrite = params.get("PermWrite")
        self._PermRead = params.get("PermRead")
        self._Remark = params.get("Remark")
        self._PermType = params.get("PermType")
        if params.get("DetailedPerms") is not None:
            self._DetailedPerms = []
            for item in params.get("DetailedPerms"):
                obj = DetailedRolePerm()
                obj._deserialize(item)
                self._DetailedPerms.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoleResponse(AbstractModel):
    r"""CreateRole response structure.

    """

    def __init__(self):
        r"""
        :param _Role: Role name.
        :type Role: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Role = None
        self._RequestId = None

    @property
    def Role(self):
        r"""Role name.
        :rtype: str
        """
        return self._Role

    @Role.setter
    def Role(self, Role):
        self._Role = Role

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Role = params.get("Role")
        self._RequestId = params.get("RequestId")


class DeleteConsumerGroupRequest(AbstractModel):
    r"""DeleteConsumerGroup request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        """
        self._InstanceId = None
        self._ConsumerGroup = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteConsumerGroupResponse(AbstractModel):
    r"""DeleteConsumerGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteInstanceRequest(AbstractModel):
    r"""DeleteInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteInstanceResponse(AbstractModel):
    r"""DeleteInstance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoleRequest(AbstractModel):
    r"""DeleteRole request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Role: Role name. It can be obtained from [RoleItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#RoleItem) returned by the API [DescribeRoleList](https://www.tencentcloud.comom/document/api/1493/98862?from_cn_redirect=1) or from the console.
        :type Role: str
        """
        self._InstanceId = None
        self._Role = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Role(self):
        r"""Role name. It can be obtained from [RoleItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#RoleItem) returned by the API [DescribeRoleList](https://www.tencentcloud.comom/document/api/1493/98862?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Role

    @Role.setter
    def Role(self, Role):
        self._Role = Role


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Role = params.get("Role")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoleResponse(AbstractModel):
    r"""DeleteRole response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSmoothMigrationTaskRequest(AbstractModel):
    r"""DeleteSmoothMigrationTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSmoothMigrationTaskResponse(AbstractModel):
    r"""DeleteSmoothMigrationTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTopicRequest(AbstractModel):
    r"""DeleteTopic request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        """
        self._InstanceId = None
        self._Topic = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTopicResponse(AbstractModel):
    r"""DeleteTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeConsumerClientListRequest(AbstractModel):
    r"""DescribeConsumerClientList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        """
        self._InstanceId = None
        self._ConsumerGroup = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConsumerClientListResponse(AbstractModel):
    r"""DescribeConsumerClientList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Consumer client
        :type Data: list of ConsumerClient
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Consumer client
        :rtype: list of ConsumerClient
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ConsumerClient()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeConsumerClientRequest(AbstractModel):
    r"""DescribeConsumerClient request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _ClientId: Client ID. It can be obtained from the output parameters of [ConsumerClient](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumerClient) of the API [DescribeConsumerClientList](https://www.tencentcloud.comom/document/api/1493/120140?from_cn_redirect=1).
        :type ClientId: str
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        """
        self._InstanceId = None
        self._ClientId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._ConsumerGroup = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClientId(self):
        r"""Client ID. It can be obtained from the output parameters of [ConsumerClient](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumerClient) of the API [DescribeConsumerClientList](https://www.tencentcloud.comom/document/api/1493/120140?from_cn_redirect=1).
        :rtype: str
        """
        return self._ClientId

    @ClientId.setter
    def ClientId(self, ClientId):
        self._ClientId = ClientId

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClientId = params.get("ClientId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConsumerGroup = params.get("ConsumerGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConsumerClientResponse(AbstractModel):
    r"""DescribeConsumerClient response structure.

    """

    def __init__(self):
        r"""
        :param _Client: Client details

Note: This field may return null, indicating that no valid values can be obtained.
        :type Client: :class:`tencentcloud.trocket.v20230308.models.ConsumerClient`
        :param _TopicList: Topic consumption information

Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicList: list of TopicConsumeStats
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Client = None
        self._TopicList = None
        self._RequestId = None

    @property
    def Client(self):
        r"""Client details

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.trocket.v20230308.models.ConsumerClient`
        """
        return self._Client

    @Client.setter
    def Client(self, Client):
        self._Client = Client

    @property
    def TopicList(self):
        r"""Topic consumption information

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TopicConsumeStats
        """
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Client") is not None:
            self._Client = ConsumerClient()
            self._Client._deserialize(params.get("Client"))
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = TopicConsumeStats()
                obj._deserialize(item)
                self._TopicList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeConsumerGroupRequest(AbstractModel):
    r"""DescribeConsumerGroup request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        """
        self._InstanceId = None
        self._ConsumerGroup = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConsumerGroupResponse(AbstractModel):
    r"""DescribeConsumerGroup response structure.

    """

    def __init__(self):
        r"""
        :param _ConsumerNum: Number of online consumers.
        :type ConsumerNum: int
        :param _Tps: TPS
        :type Tps: int
        :param _ConsumerLag: Specifies the number of accumulated messages.
        :type ConsumerLag: int
        :param _ConsumeType: Consumption type. valid values as follows:.

-PULL: specifies the pull consumption type.
-PUSH: specifies the push consumption type.
-POP: specifies the pop consumption type.
        :type ConsumeType: str
        :param _CreatedTime: Creation time. **It is a Unix timestamp (ms).**
        :type CreatedTime: int
        :param _ConsumeMessageOrderly: Specifies whether to use ordered delivery. valid values: true.
Concurrent delivery: false.
        :type ConsumeMessageOrderly: bool
        :param _ConsumeEnable: Whether to enable consumption.
        :type ConsumeEnable: bool
        :param _MaxRetryTimes: Maximum number of retries.
        :type MaxRetryTimes: int
        :param _Remark: Remarks
        :type Remark: str
        :param _MessageModel: Specifies the consumption mode.
BROADCASTING.
CLUSTERING cluster mode.
        :type MessageModel: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConsumerNum = None
        self._Tps = None
        self._ConsumerLag = None
        self._ConsumeType = None
        self._CreatedTime = None
        self._ConsumeMessageOrderly = None
        self._ConsumeEnable = None
        self._MaxRetryTimes = None
        self._Remark = None
        self._MessageModel = None
        self._RequestId = None

    @property
    def ConsumerNum(self):
        r"""Number of online consumers.
        :rtype: int
        """
        return self._ConsumerNum

    @ConsumerNum.setter
    def ConsumerNum(self, ConsumerNum):
        self._ConsumerNum = ConsumerNum

    @property
    def Tps(self):
        r"""TPS
        :rtype: int
        """
        return self._Tps

    @Tps.setter
    def Tps(self, Tps):
        self._Tps = Tps

    @property
    def ConsumerLag(self):
        r"""Specifies the number of accumulated messages.
        :rtype: int
        """
        return self._ConsumerLag

    @ConsumerLag.setter
    def ConsumerLag(self, ConsumerLag):
        self._ConsumerLag = ConsumerLag

    @property
    def ConsumeType(self):
        r"""Consumption type. valid values as follows:.

-PULL: specifies the pull consumption type.
-PUSH: specifies the push consumption type.
-POP: specifies the pop consumption type.
        :rtype: str
        """
        return self._ConsumeType

    @ConsumeType.setter
    def ConsumeType(self, ConsumeType):
        self._ConsumeType = ConsumeType

    @property
    def CreatedTime(self):
        r"""Creation time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ConsumeMessageOrderly(self):
        r"""Specifies whether to use ordered delivery. valid values: true.
Concurrent delivery: false.
        :rtype: bool
        """
        return self._ConsumeMessageOrderly

    @ConsumeMessageOrderly.setter
    def ConsumeMessageOrderly(self, ConsumeMessageOrderly):
        self._ConsumeMessageOrderly = ConsumeMessageOrderly

    @property
    def ConsumeEnable(self):
        r"""Whether to enable consumption.
        :rtype: bool
        """
        return self._ConsumeEnable

    @ConsumeEnable.setter
    def ConsumeEnable(self, ConsumeEnable):
        self._ConsumeEnable = ConsumeEnable

    @property
    def MaxRetryTimes(self):
        r"""Maximum number of retries.
        :rtype: int
        """
        return self._MaxRetryTimes

    @MaxRetryTimes.setter
    def MaxRetryTimes(self, MaxRetryTimes):
        self._MaxRetryTimes = MaxRetryTimes

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MessageModel(self):
        r"""Specifies the consumption mode.
BROADCASTING.
CLUSTERING cluster mode.
        :rtype: str
        """
        return self._MessageModel

    @MessageModel.setter
    def MessageModel(self, MessageModel):
        self._MessageModel = MessageModel

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConsumerNum = params.get("ConsumerNum")
        self._Tps = params.get("Tps")
        self._ConsumerLag = params.get("ConsumerLag")
        self._ConsumeType = params.get("ConsumeType")
        self._CreatedTime = params.get("CreatedTime")
        self._ConsumeMessageOrderly = params.get("ConsumeMessageOrderly")
        self._ConsumeEnable = params.get("ConsumeEnable")
        self._MaxRetryTimes = params.get("MaxRetryTimes")
        self._Remark = params.get("Remark")
        self._MessageModel = params.get("MessageModel")
        self._RequestId = params.get("RequestId")


class DescribeConsumerLagRequest(AbstractModel):
    r"""DescribeConsumerLag request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        :param _Namespace: Namespace. It is required for 4.x clusters. The namespace can be obtained from [RocketMQNamespace](https://www.tencentcloud.comom/document/api/1179/46089?from_cn_redirect=1#RocketMQNamespace) returned by the API [DescribeRocketMQNamespaces](https://www.tencentcloud.comom/document/api/1179/63419?from_cn_redirect=1) or from the console.
        :type Namespace: str
        :param _SubscribeTopic: Subscribed topic. If it is not left blank, query heaped messages of consumer groups subscribing to the topic. The topic can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type SubscribeTopic: str
        """
        self._InstanceId = None
        self._ConsumerGroup = None
        self._Namespace = None
        self._SubscribeTopic = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def Namespace(self):
        r"""Namespace. It is required for 4.x clusters. The namespace can be obtained from [RocketMQNamespace](https://www.tencentcloud.comom/document/api/1179/46089?from_cn_redirect=1#RocketMQNamespace) returned by the API [DescribeRocketMQNamespaces](https://www.tencentcloud.comom/document/api/1179/63419?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def SubscribeTopic(self):
        r"""Subscribed topic. If it is not left blank, query heaped messages of consumer groups subscribing to the topic. The topic can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._SubscribeTopic

    @SubscribeTopic.setter
    def SubscribeTopic(self, SubscribeTopic):
        self._SubscribeTopic = SubscribeTopic


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._Namespace = params.get("Namespace")
        self._SubscribeTopic = params.get("SubscribeTopic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConsumerLagResponse(AbstractModel):
    r"""DescribeConsumerLag response structure.

    """

    def __init__(self):
        r"""
        :param _ConsumerLag: Number of heaped messages.
        :type ConsumerLag: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ConsumerLag = None
        self._RequestId = None

    @property
    def ConsumerLag(self):
        r"""Number of heaped messages.
        :rtype: int
        """
        return self._ConsumerLag

    @ConsumerLag.setter
    def ConsumerLag(self, ConsumerLag):
        self._ConsumerLag = ConsumerLag

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConsumerLag = params.get("ConsumerLag")
        self._RequestId = params.get("RequestId")


class DescribeFusionInstanceListRequest(AbstractModel):
    r"""DescribeFusionInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _TagFilters: Tag filter
        :type TagFilters: list of TagFilter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._TagFilters = None

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        r"""Tag filter
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFusionInstanceListResponse(AbstractModel):
    r"""DescribeFusionInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Instance list
        :type Data: list of FusionInstanceItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Instance list
        :rtype: list of FusionInstanceItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = FusionInstanceItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceListRequest(AbstractModel):
    r"""DescribeInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _TagFilters: Tag filter
        :type TagFilters: list of TagFilter
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        """
        self._Filters = None
        self._TagFilters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagFilters(self):
        r"""Tag filter
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceListResponse(AbstractModel):
    r"""DescribeInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Instance list
        :type Data: list of InstanceItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Instance list
        :rtype: list of InstanceItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceRequest(AbstractModel):
    r"""DescribeInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceResponse(AbstractModel):
    r"""DescribeInstance response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceType: Instance type.
Specifies the EXPERIMENT trial version.
BASIC version.
PRO edition.
PLATINUM. platinum version.
        :type InstanceType: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _TopicNum: Number of topics
        :type TopicNum: int
        :param _TopicNumLimit: Maximum number of topics per instance
        :type TopicNumLimit: int
        :param _GroupNum: Number of consumer groups
        :type GroupNum: int
        :param _GroupNumLimit: Maximum number of consumer groups per instance
        :type GroupNumLimit: int
        :param _MessageRetention: Message retention time, in hours
        :type MessageRetention: int
        :param _RetentionUpperLimit: Maximum adjustable message retention time, in hours
        :type RetentionUpperLimit: int
        :param _RetentionLowerLimit: Minimum adjustable message retention time, in hours
        :type RetentionLowerLimit: int
        :param _TpsLimit: TPS throttle value
        :type TpsLimit: int
        :param _ScaledTpsLimit: Elastic TPS throttle value
        :type ScaledTpsLimit: int
        :param _MaxMessageDelay: Maximum delayed message time, in hours
        :type MaxMessageDelay: int
        :param _CreatedTime: Creation time. **It is a Unix timestamp (ms).**
        :type CreatedTime: int
        :param _SendReceiveRatio: Message sending and receiving ratio
        :type SendReceiveRatio: float
        :param _TagList: Tag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TagList: list of Tag
        :param _EndpointList: Access point list

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndpointList: list of Endpoint
        :param _TopicQueueNumUpperLimit: Maximum number of topic queues
        :type TopicQueueNumUpperLimit: int
        :param _TopicQueueNumLowerLimit: Minimum queue count for topic
        :type TopicQueueNumLowerLimit: int
        :param _Remark: Remarks
        :type Remark: str
        :param _InstanceStatus: Instance status. valid values are as follows:.

- RUNNING: RUNNING.
-ABNORMAL: indicates an abnormal status.
-OVERDUE: isolated.
-DESTROYED: specifies the terminated status.
-CREATING: creating.
-MODIFYING.
-CREATE_FAILURE: creation failed.
-MODIFY_FAILURE: configuration adjustment failure.
-DELETING: deleting.
        :type InstanceStatus: str
        :param _SkuCode: Instance specification.
        :type SkuCode: str
        :param _PayMode: Billing mode. valid enumeration values are as follows:.

- POSTPAID: POSTPAID pay-as-you-go billing.
- PREPAID: PREPAID annual and monthly.
        :type PayMode: str
        :param _ScaledTpsEnabled: Whether to enable elastic TPS.
        :type ScaledTpsEnabled: bool
        :param _RenewFlag: Specifies whether the prepaid cluster is automatically renewed. valid values are as follows:.

- 0: no automatic renewal.
- 1: specifies automatic renewal.
        :type RenewFlag: int
        :param _ExpiryTime: Expiration time. **It is a Unix timestamp (ms).**
        :type ExpiryTime: int
        :param _RoleNumLimit: Specifies the limit on the number of roles.
        :type RoleNumLimit: int
        :param _AclEnabled: Whether ACL is enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AclEnabled: bool
        :param _TopicNumLowerLimit: Number of topics within the free quota.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicNumLowerLimit: int
        :param _TopicNumUpperLimit: Maximum settable number of topics.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicNumUpperLimit: int
        :param _ZoneIds: AZ list. See [ZoneInfo](https://www.tencentcloud.comom/document/api/1596/77932?from_cn_redirect=1#ZoneInfo) returned by the API [DescribeZones](https://www.tencentcloud.comom/document/product/1596/77929?from_cn_redirect=1) in Data Type.
        :type ZoneIds: list of int
        :param _NodeCount: Number of proxy nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeCount: int
        :param _ZoneScheduledList: Proxy scheduling details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneScheduledList: list of ZoneScheduledItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._TopicNum = None
        self._TopicNumLimit = None
        self._GroupNum = None
        self._GroupNumLimit = None
        self._MessageRetention = None
        self._RetentionUpperLimit = None
        self._RetentionLowerLimit = None
        self._TpsLimit = None
        self._ScaledTpsLimit = None
        self._MaxMessageDelay = None
        self._CreatedTime = None
        self._SendReceiveRatio = None
        self._TagList = None
        self._EndpointList = None
        self._TopicQueueNumUpperLimit = None
        self._TopicQueueNumLowerLimit = None
        self._Remark = None
        self._InstanceStatus = None
        self._SkuCode = None
        self._PayMode = None
        self._ScaledTpsEnabled = None
        self._RenewFlag = None
        self._ExpiryTime = None
        self._RoleNumLimit = None
        self._AclEnabled = None
        self._TopicNumLowerLimit = None
        self._TopicNumUpperLimit = None
        self._ZoneIds = None
        self._NodeCount = None
        self._ZoneScheduledList = None
        self._RequestId = None

    @property
    def InstanceType(self):
        r"""Instance type.
Specifies the EXPERIMENT trial version.
BASIC version.
PRO edition.
PLATINUM. platinum version.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def TopicNum(self):
        r"""Number of topics
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def TopicNumLimit(self):
        r"""Maximum number of topics per instance
        :rtype: int
        """
        return self._TopicNumLimit

    @TopicNumLimit.setter
    def TopicNumLimit(self, TopicNumLimit):
        self._TopicNumLimit = TopicNumLimit

    @property
    def GroupNum(self):
        r"""Number of consumer groups
        :rtype: int
        """
        return self._GroupNum

    @GroupNum.setter
    def GroupNum(self, GroupNum):
        self._GroupNum = GroupNum

    @property
    def GroupNumLimit(self):
        r"""Maximum number of consumer groups per instance
        :rtype: int
        """
        return self._GroupNumLimit

    @GroupNumLimit.setter
    def GroupNumLimit(self, GroupNumLimit):
        self._GroupNumLimit = GroupNumLimit

    @property
    def MessageRetention(self):
        r"""Message retention time, in hours
        :rtype: int
        """
        return self._MessageRetention

    @MessageRetention.setter
    def MessageRetention(self, MessageRetention):
        self._MessageRetention = MessageRetention

    @property
    def RetentionUpperLimit(self):
        r"""Maximum adjustable message retention time, in hours
        :rtype: int
        """
        return self._RetentionUpperLimit

    @RetentionUpperLimit.setter
    def RetentionUpperLimit(self, RetentionUpperLimit):
        self._RetentionUpperLimit = RetentionUpperLimit

    @property
    def RetentionLowerLimit(self):
        r"""Minimum adjustable message retention time, in hours
        :rtype: int
        """
        return self._RetentionLowerLimit

    @RetentionLowerLimit.setter
    def RetentionLowerLimit(self, RetentionLowerLimit):
        self._RetentionLowerLimit = RetentionLowerLimit

    @property
    def TpsLimit(self):
        r"""TPS throttle value
        :rtype: int
        """
        return self._TpsLimit

    @TpsLimit.setter
    def TpsLimit(self, TpsLimit):
        self._TpsLimit = TpsLimit

    @property
    def ScaledTpsLimit(self):
        r"""Elastic TPS throttle value
        :rtype: int
        """
        return self._ScaledTpsLimit

    @ScaledTpsLimit.setter
    def ScaledTpsLimit(self, ScaledTpsLimit):
        self._ScaledTpsLimit = ScaledTpsLimit

    @property
    def MaxMessageDelay(self):
        r"""Maximum delayed message time, in hours
        :rtype: int
        """
        return self._MaxMessageDelay

    @MaxMessageDelay.setter
    def MaxMessageDelay(self, MaxMessageDelay):
        self._MaxMessageDelay = MaxMessageDelay

    @property
    def CreatedTime(self):
        r"""Creation time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def SendReceiveRatio(self):
        r"""Message sending and receiving ratio
        :rtype: float
        """
        return self._SendReceiveRatio

    @SendReceiveRatio.setter
    def SendReceiveRatio(self, SendReceiveRatio):
        self._SendReceiveRatio = SendReceiveRatio

    @property
    def TagList(self):
        r"""Tag.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList

    @property
    def EndpointList(self):
        r"""Access point list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Endpoint
        """
        return self._EndpointList

    @EndpointList.setter
    def EndpointList(self, EndpointList):
        self._EndpointList = EndpointList

    @property
    def TopicQueueNumUpperLimit(self):
        r"""Maximum number of topic queues
        :rtype: int
        """
        return self._TopicQueueNumUpperLimit

    @TopicQueueNumUpperLimit.setter
    def TopicQueueNumUpperLimit(self, TopicQueueNumUpperLimit):
        self._TopicQueueNumUpperLimit = TopicQueueNumUpperLimit

    @property
    def TopicQueueNumLowerLimit(self):
        r"""Minimum queue count for topic
        :rtype: int
        """
        return self._TopicQueueNumLowerLimit

    @TopicQueueNumLowerLimit.setter
    def TopicQueueNumLowerLimit(self, TopicQueueNumLowerLimit):
        self._TopicQueueNumLowerLimit = TopicQueueNumLowerLimit

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def InstanceStatus(self):
        r"""Instance status. valid values are as follows:.

- RUNNING: RUNNING.
-ABNORMAL: indicates an abnormal status.
-OVERDUE: isolated.
-DESTROYED: specifies the terminated status.
-CREATING: creating.
-MODIFYING.
-CREATE_FAILURE: creation failed.
-MODIFY_FAILURE: configuration adjustment failure.
-DELETING: deleting.
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def SkuCode(self):
        r"""Instance specification.
        :rtype: str
        """
        return self._SkuCode

    @SkuCode.setter
    def SkuCode(self, SkuCode):
        self._SkuCode = SkuCode

    @property
    def PayMode(self):
        r"""Billing mode. valid enumeration values are as follows:.

- POSTPAID: POSTPAID pay-as-you-go billing.
- PREPAID: PREPAID annual and monthly.
        :rtype: str
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ScaledTpsEnabled(self):
        r"""Whether to enable elastic TPS.
        :rtype: bool
        """
        return self._ScaledTpsEnabled

    @ScaledTpsEnabled.setter
    def ScaledTpsEnabled(self, ScaledTpsEnabled):
        self._ScaledTpsEnabled = ScaledTpsEnabled

    @property
    def RenewFlag(self):
        r"""Specifies whether the prepaid cluster is automatically renewed. valid values are as follows:.

- 0: no automatic renewal.
- 1: specifies automatic renewal.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def ExpiryTime(self):
        r"""Expiration time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._ExpiryTime

    @ExpiryTime.setter
    def ExpiryTime(self, ExpiryTime):
        self._ExpiryTime = ExpiryTime

    @property
    def RoleNumLimit(self):
        r"""Specifies the limit on the number of roles.
        :rtype: int
        """
        return self._RoleNumLimit

    @RoleNumLimit.setter
    def RoleNumLimit(self, RoleNumLimit):
        self._RoleNumLimit = RoleNumLimit

    @property
    def AclEnabled(self):
        r"""Whether ACL is enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AclEnabled

    @AclEnabled.setter
    def AclEnabled(self, AclEnabled):
        self._AclEnabled = AclEnabled

    @property
    def TopicNumLowerLimit(self):
        r"""Number of topics within the free quota.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicNumLowerLimit

    @TopicNumLowerLimit.setter
    def TopicNumLowerLimit(self, TopicNumLowerLimit):
        self._TopicNumLowerLimit = TopicNumLowerLimit

    @property
    def TopicNumUpperLimit(self):
        r"""Maximum settable number of topics.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicNumUpperLimit

    @TopicNumUpperLimit.setter
    def TopicNumUpperLimit(self, TopicNumUpperLimit):
        self._TopicNumUpperLimit = TopicNumUpperLimit

    @property
    def ZoneIds(self):
        r"""AZ list. See [ZoneInfo](https://www.tencentcloud.comom/document/api/1596/77932?from_cn_redirect=1#ZoneInfo) returned by the API [DescribeZones](https://www.tencentcloud.comom/document/product/1596/77929?from_cn_redirect=1) in Data Type.
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def NodeCount(self):
        r"""Number of proxy nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def ZoneScheduledList(self):
        r"""Proxy scheduling details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ZoneScheduledItem
        """
        return self._ZoneScheduledList

    @ZoneScheduledList.setter
    def ZoneScheduledList(self, ZoneScheduledList):
        self._ZoneScheduledList = ZoneScheduledList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._TopicNum = params.get("TopicNum")
        self._TopicNumLimit = params.get("TopicNumLimit")
        self._GroupNum = params.get("GroupNum")
        self._GroupNumLimit = params.get("GroupNumLimit")
        self._MessageRetention = params.get("MessageRetention")
        self._RetentionUpperLimit = params.get("RetentionUpperLimit")
        self._RetentionLowerLimit = params.get("RetentionLowerLimit")
        self._TpsLimit = params.get("TpsLimit")
        self._ScaledTpsLimit = params.get("ScaledTpsLimit")
        self._MaxMessageDelay = params.get("MaxMessageDelay")
        self._CreatedTime = params.get("CreatedTime")
        self._SendReceiveRatio = params.get("SendReceiveRatio")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        if params.get("EndpointList") is not None:
            self._EndpointList = []
            for item in params.get("EndpointList"):
                obj = Endpoint()
                obj._deserialize(item)
                self._EndpointList.append(obj)
        self._TopicQueueNumUpperLimit = params.get("TopicQueueNumUpperLimit")
        self._TopicQueueNumLowerLimit = params.get("TopicQueueNumLowerLimit")
        self._Remark = params.get("Remark")
        self._InstanceStatus = params.get("InstanceStatus")
        self._SkuCode = params.get("SkuCode")
        self._PayMode = params.get("PayMode")
        self._ScaledTpsEnabled = params.get("ScaledTpsEnabled")
        self._RenewFlag = params.get("RenewFlag")
        self._ExpiryTime = params.get("ExpiryTime")
        self._RoleNumLimit = params.get("RoleNumLimit")
        self._AclEnabled = params.get("AclEnabled")
        self._TopicNumLowerLimit = params.get("TopicNumLowerLimit")
        self._TopicNumUpperLimit = params.get("TopicNumUpperLimit")
        self._ZoneIds = params.get("ZoneIds")
        self._NodeCount = params.get("NodeCount")
        if params.get("ZoneScheduledList") is not None:
            self._ZoneScheduledList = []
            for item in params.get("ZoneScheduledList"):
                obj = ZoneScheduledItem()
                obj._deserialize(item)
                self._ZoneScheduledList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMessageListRequest(AbstractModel):
    r"""DescribeMessageList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _StartTime: Start time for querying messages. **It is a Unix timestamp (ms).**
        :type StartTime: int
        :param _EndTime: End time for querying messages. **It is a Unix timestamp (ms).**
        :type EndTime: int
        :param _TaskRequestId: Query identifier. For the first query, input a null string. If the query results involve pagination, use the TaskRequestId value in the previous request response as the value of this input parameter for requesting data on the next page.
        :type TaskRequestId: str
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        :param _MsgId: Message ID. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from the workload logs.
        :type MsgId: str
        :param _MsgKey: Message key. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from workload logs.
        :type MsgKey: str
        :param _RecentMessageNum: Query the last N messages. The value of N cannot exceed 1024. By default, -1 indicates other query conditions.
        :type RecentMessageNum: int
        :param _QueryDeadLetterMessage: Whether to query dead letter messages. Default value: false.
        :type QueryDeadLetterMessage: bool
        :param _Tag: Message tag. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from workload logs.
        :type Tag: str
        """
        self._InstanceId = None
        self._Topic = None
        self._StartTime = None
        self._EndTime = None
        self._TaskRequestId = None
        self._Offset = None
        self._Limit = None
        self._ConsumerGroup = None
        self._MsgId = None
        self._MsgKey = None
        self._RecentMessageNum = None
        self._QueryDeadLetterMessage = None
        self._Tag = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def StartTime(self):
        r"""Start time for querying messages. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time for querying messages. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskRequestId(self):
        r"""Query identifier. For the first query, input a null string. If the query results involve pagination, use the TaskRequestId value in the previous request response as the value of this input parameter for requesting data on the next page.
        :rtype: str
        """
        return self._TaskRequestId

    @TaskRequestId.setter
    def TaskRequestId(self, TaskRequestId):
        self._TaskRequestId = TaskRequestId

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def MsgId(self):
        r"""Message ID. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from the workload logs.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def MsgKey(self):
        r"""Message key. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from workload logs.
        :rtype: str
        """
        return self._MsgKey

    @MsgKey.setter
    def MsgKey(self, MsgKey):
        self._MsgKey = MsgKey

    @property
    def RecentMessageNum(self):
        r"""Query the last N messages. The value of N cannot exceed 1024. By default, -1 indicates other query conditions.
        :rtype: int
        """
        return self._RecentMessageNum

    @RecentMessageNum.setter
    def RecentMessageNum(self, RecentMessageNum):
        self._RecentMessageNum = RecentMessageNum

    @property
    def QueryDeadLetterMessage(self):
        r"""Whether to query dead letter messages. Default value: false.
        :rtype: bool
        """
        return self._QueryDeadLetterMessage

    @QueryDeadLetterMessage.setter
    def QueryDeadLetterMessage(self, QueryDeadLetterMessage):
        self._QueryDeadLetterMessage = QueryDeadLetterMessage

    @property
    def Tag(self):
        r"""Message tag. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from workload logs.
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskRequestId = params.get("TaskRequestId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._MsgId = params.get("MsgId")
        self._MsgKey = params.get("MsgKey")
        self._RecentMessageNum = params.get("RecentMessageNum")
        self._QueryDeadLetterMessage = params.get("QueryDeadLetterMessage")
        self._Tag = params.get("Tag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMessageListResponse(AbstractModel):
    r"""DescribeMessageList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Message record list

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of MessageItem
        :param _TaskRequestId: One-time query ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskRequestId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._TaskRequestId = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Message record list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MessageItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def TaskRequestId(self):
        r"""One-time query ID

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskRequestId

    @TaskRequestId.setter
    def TaskRequestId(self, TaskRequestId):
        self._TaskRequestId = TaskRequestId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = MessageItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._TaskRequestId = params.get("TaskRequestId")
        self._RequestId = params.get("RequestId")


class DescribeMessageRequest(AbstractModel):
    r"""DescribeMessage request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _MsgId: Message ID. It can be obtained from the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or workload logs.
        :type MsgId: str
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _QueryDeadLetterMessage: Whether the message is dead letter message. Default value: false.
        :type QueryDeadLetterMessage: bool
        :param _QueryDelayMessage: Whether the message is delayed. Default value: false.
        :type QueryDelayMessage: bool
        """
        self._InstanceId = None
        self._Topic = None
        self._MsgId = None
        self._Offset = None
        self._Limit = None
        self._QueryDeadLetterMessage = None
        self._QueryDelayMessage = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def MsgId(self):
        r"""Message ID. It can be obtained from the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or workload logs.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def QueryDeadLetterMessage(self):
        r"""Whether the message is dead letter message. Default value: false.
        :rtype: bool
        """
        return self._QueryDeadLetterMessage

    @QueryDeadLetterMessage.setter
    def QueryDeadLetterMessage(self, QueryDeadLetterMessage):
        self._QueryDeadLetterMessage = QueryDeadLetterMessage

    @property
    def QueryDelayMessage(self):
        r"""Whether the message is delayed. Default value: false.
        :rtype: bool
        """
        return self._QueryDelayMessage

    @QueryDelayMessage.setter
    def QueryDelayMessage(self, QueryDelayMessage):
        self._QueryDelayMessage = QueryDelayMessage


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._MsgId = params.get("MsgId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._QueryDeadLetterMessage = params.get("QueryDeadLetterMessage")
        self._QueryDelayMessage = params.get("QueryDelayMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMessageResponse(AbstractModel):
    r"""DescribeMessage response structure.

    """

    def __init__(self):
        r"""
        :param _Body: Message body.
        :type Body: str
        :param _Properties: Detailed parameters.
        :type Properties: str
        :param _ProduceTime: Production time.
        :type ProduceTime: str
        :param _MessageId: Message ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MessageId: str
        :param _ProducerAddr: Producer address.
        :type ProducerAddr: str
        :param _MessageTracks: List of message consumption situations.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MessageTracks: list of MessageTrackItem
        :param _ShowTopicName: Topic name
        :type ShowTopicName: str
        :param _MessageTracksCount: Total number of items in the message consumption status list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MessageTracksCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Body = None
        self._Properties = None
        self._ProduceTime = None
        self._MessageId = None
        self._ProducerAddr = None
        self._MessageTracks = None
        self._ShowTopicName = None
        self._MessageTracksCount = None
        self._RequestId = None

    @property
    def Body(self):
        r"""Message body.
        :rtype: str
        """
        return self._Body

    @Body.setter
    def Body(self, Body):
        self._Body = Body

    @property
    def Properties(self):
        r"""Detailed parameters.
        :rtype: str
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def ProduceTime(self):
        r"""Production time.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def MessageId(self):
        r"""Message ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def ProducerAddr(self):
        r"""Producer address.
        :rtype: str
        """
        return self._ProducerAddr

    @ProducerAddr.setter
    def ProducerAddr(self, ProducerAddr):
        self._ProducerAddr = ProducerAddr

    @property
    def MessageTracks(self):
        r"""List of message consumption situations.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MessageTrackItem
        """
        return self._MessageTracks

    @MessageTracks.setter
    def MessageTracks(self, MessageTracks):
        self._MessageTracks = MessageTracks

    @property
    def ShowTopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._ShowTopicName

    @ShowTopicName.setter
    def ShowTopicName(self, ShowTopicName):
        self._ShowTopicName = ShowTopicName

    @property
    def MessageTracksCount(self):
        r"""Total number of items in the message consumption status list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MessageTracksCount

    @MessageTracksCount.setter
    def MessageTracksCount(self, MessageTracksCount):
        self._MessageTracksCount = MessageTracksCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Body = params.get("Body")
        self._Properties = params.get("Properties")
        self._ProduceTime = params.get("ProduceTime")
        self._MessageId = params.get("MessageId")
        self._ProducerAddr = params.get("ProducerAddr")
        if params.get("MessageTracks") is not None:
            self._MessageTracks = []
            for item in params.get("MessageTracks"):
                obj = MessageTrackItem()
                obj._deserialize(item)
                self._MessageTracks.append(obj)
        self._ShowTopicName = params.get("ShowTopicName")
        self._MessageTracksCount = params.get("MessageTracksCount")
        self._RequestId = params.get("RequestId")


class DescribeMessageTraceRequest(AbstractModel):
    r"""DescribeMessageTrace request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _MsgId: Message ID. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from the workload logs.
        :type MsgId: str
        :param _QueryDeadLetterMessage: Whether the message is dead letter message. Default value: false.
        :type QueryDeadLetterMessage: bool
        :param _QueryDelayMessage: Whether the message is delayed. Default value: false.
        :type QueryDelayMessage: bool
        """
        self._InstanceId = None
        self._Topic = None
        self._MsgId = None
        self._QueryDeadLetterMessage = None
        self._QueryDelayMessage = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def MsgId(self):
        r"""Message ID. It can be obtained from [MessageItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MessageItem) returned by the API [DescribeMessageList](https://www.tencentcloud.comom/document/api/1493/114593?from_cn_redirect=1) or from the workload logs.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def QueryDeadLetterMessage(self):
        r"""Whether the message is dead letter message. Default value: false.
        :rtype: bool
        """
        return self._QueryDeadLetterMessage

    @QueryDeadLetterMessage.setter
    def QueryDeadLetterMessage(self, QueryDeadLetterMessage):
        self._QueryDeadLetterMessage = QueryDeadLetterMessage

    @property
    def QueryDelayMessage(self):
        r"""Whether the message is delayed. Default value: false.
        :rtype: bool
        """
        return self._QueryDelayMessage

    @QueryDelayMessage.setter
    def QueryDelayMessage(self, QueryDelayMessage):
        self._QueryDelayMessage = QueryDelayMessage


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._MsgId = params.get("MsgId")
        self._QueryDeadLetterMessage = params.get("QueryDeadLetterMessage")
        self._QueryDelayMessage = params.get("QueryDelayMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMessageTraceResponse(AbstractModel):
    r"""DescribeMessageTrace response structure.

    """

    def __init__(self):
        r"""
        :param _ShowTopicName: Topic name
        :type ShowTopicName: str
        :param _Data: Track details

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of MessageTraceItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ShowTopicName = None
        self._Data = None
        self._RequestId = None

    @property
    def ShowTopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._ShowTopicName

    @ShowTopicName.setter
    def ShowTopicName(self, ShowTopicName):
        self._ShowTopicName = ShowTopicName

    @property
    def Data(self):
        r"""Track details

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MessageTraceItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ShowTopicName = params.get("ShowTopicName")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = MessageTraceItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMigratingGroupStatsRequest(AbstractModel):
    r"""DescribeMigratingGroupStats request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.
        :type TaskId: str
        :param _GroupName: Specifies the consumer group name. it can be obtained from [SourceClusterGroupConfig](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SourceClusterGroupConfig) returned by the api [DescribeSourceClusterGroupList](https://www.tencentcloud.comom/document/api/1493/118006?from_cn_redirect=1) or in the console.

        :type GroupName: str
        :param _Namespace: Namespace. it is valid only when migrated to 4.x clusters. the namespace can be obtained from [SourceClusterGroupConfig](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SourceClusterGroupConfig) returned by the api [DescribeSourceClusterGroupList](https://www.tencentcloud.comom/document/api/1493/118006?from_cn_redirect=1) or from the console.
        :type Namespace: str
        """
        self._TaskId = None
        self._GroupName = None
        self._Namespace = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def GroupName(self):
        r"""Specifies the consumer group name. it can be obtained from [SourceClusterGroupConfig](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SourceClusterGroupConfig) returned by the api [DescribeSourceClusterGroupList](https://www.tencentcloud.comom/document/api/1493/118006?from_cn_redirect=1) or in the console.

        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Namespace(self):
        r"""Namespace. it is valid only when migrated to 4.x clusters. the namespace can be obtained from [SourceClusterGroupConfig](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SourceClusterGroupConfig) returned by the api [DescribeSourceClusterGroupList](https://www.tencentcloud.comom/document/api/1493/118006?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._GroupName = params.get("GroupName")
        self._Namespace = params.get("Namespace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMigratingGroupStatsResponse(AbstractModel):
    r"""DescribeMigratingGroupStats response structure.

    """

    def __init__(self):
        r"""
        :param _SourceConsumeLag: Source cluster consumer group accumulation.
        :type SourceConsumeLag: int
        :param _TargetConsumeLag: Target cluster consumer group accumulation.
        :type TargetConsumeLag: int
        :param _SourceConsumerClients: Source cluster connection client list.
        :type SourceConsumerClients: list of ConsumerClient
        :param _TargetConsumerClients: Target cluster connection client list.
        :type TargetConsumerClients: list of ConsumerClient
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SourceConsumeLag = None
        self._TargetConsumeLag = None
        self._SourceConsumerClients = None
        self._TargetConsumerClients = None
        self._RequestId = None

    @property
    def SourceConsumeLag(self):
        r"""Source cluster consumer group accumulation.
        :rtype: int
        """
        return self._SourceConsumeLag

    @SourceConsumeLag.setter
    def SourceConsumeLag(self, SourceConsumeLag):
        self._SourceConsumeLag = SourceConsumeLag

    @property
    def TargetConsumeLag(self):
        r"""Target cluster consumer group accumulation.
        :rtype: int
        """
        return self._TargetConsumeLag

    @TargetConsumeLag.setter
    def TargetConsumeLag(self, TargetConsumeLag):
        self._TargetConsumeLag = TargetConsumeLag

    @property
    def SourceConsumerClients(self):
        r"""Source cluster connection client list.
        :rtype: list of ConsumerClient
        """
        return self._SourceConsumerClients

    @SourceConsumerClients.setter
    def SourceConsumerClients(self, SourceConsumerClients):
        self._SourceConsumerClients = SourceConsumerClients

    @property
    def TargetConsumerClients(self):
        r"""Target cluster connection client list.
        :rtype: list of ConsumerClient
        """
        return self._TargetConsumerClients

    @TargetConsumerClients.setter
    def TargetConsumerClients(self, TargetConsumerClients):
        self._TargetConsumerClients = TargetConsumerClients

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SourceConsumeLag = params.get("SourceConsumeLag")
        self._TargetConsumeLag = params.get("TargetConsumeLag")
        if params.get("SourceConsumerClients") is not None:
            self._SourceConsumerClients = []
            for item in params.get("SourceConsumerClients"):
                obj = ConsumerClient()
                obj._deserialize(item)
                self._SourceConsumerClients.append(obj)
        if params.get("TargetConsumerClients") is not None:
            self._TargetConsumerClients = []
            for item in params.get("TargetConsumerClients"):
                obj = ConsumerClient()
                obj._deserialize(item)
                self._TargetConsumerClients.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMigratingTopicListRequest(AbstractModel):
    r"""DescribeMigratingTopicList request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        """
        self._TaskId = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMigratingTopicListResponse(AbstractModel):
    r"""DescribeMigratingTopicList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _MigrateTopics: Topic list.
        :type MigrateTopics: list of MigratingTopic
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._MigrateTopics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def MigrateTopics(self):
        r"""Topic list.
        :rtype: list of MigratingTopic
        """
        return self._MigrateTopics

    @MigrateTopics.setter
    def MigrateTopics(self, MigrateTopics):
        self._MigrateTopics = MigrateTopics

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("MigrateTopics") is not None:
            self._MigrateTopics = []
            for item in params.get("MigrateTopics"):
                obj = MigratingTopic()
                obj._deserialize(item)
                self._MigrateTopics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMigratingTopicStatsRequest(AbstractModel):
    r"""DescribeMigratingTopicStats request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        :param _TopicName: Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :type TopicName: str
        :param _Namespace: Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :type Namespace: str
        """
        self._TaskId = None
        self._TopicName = None
        self._Namespace = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TopicName(self):
        r"""Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Namespace(self):
        r"""Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TopicName = params.get("TopicName")
        self._Namespace = params.get("Namespace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMigratingTopicStatsResponse(AbstractModel):
    r"""DescribeMigratingTopicStats response structure.

    """

    def __init__(self):
        r"""
        :param _SourceClusterConsumerCount: Number of consumers in the source cluster.
        :type SourceClusterConsumerCount: int
        :param _TargetClusterConsumerCount: Number of consumers in the target cluster.
        :type TargetClusterConsumerCount: int
        :param _SourceClusterConsumerGroups: Source cluster consumer group list.
        :type SourceClusterConsumerGroups: list of str
        :param _TargetClusterConsumerGroups: Target cluster consumer group list.
        :type TargetClusterConsumerGroups: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SourceClusterConsumerCount = None
        self._TargetClusterConsumerCount = None
        self._SourceClusterConsumerGroups = None
        self._TargetClusterConsumerGroups = None
        self._RequestId = None

    @property
    def SourceClusterConsumerCount(self):
        r"""Number of consumers in the source cluster.
        :rtype: int
        """
        return self._SourceClusterConsumerCount

    @SourceClusterConsumerCount.setter
    def SourceClusterConsumerCount(self, SourceClusterConsumerCount):
        self._SourceClusterConsumerCount = SourceClusterConsumerCount

    @property
    def TargetClusterConsumerCount(self):
        r"""Number of consumers in the target cluster.
        :rtype: int
        """
        return self._TargetClusterConsumerCount

    @TargetClusterConsumerCount.setter
    def TargetClusterConsumerCount(self, TargetClusterConsumerCount):
        self._TargetClusterConsumerCount = TargetClusterConsumerCount

    @property
    def SourceClusterConsumerGroups(self):
        r"""Source cluster consumer group list.
        :rtype: list of str
        """
        return self._SourceClusterConsumerGroups

    @SourceClusterConsumerGroups.setter
    def SourceClusterConsumerGroups(self, SourceClusterConsumerGroups):
        self._SourceClusterConsumerGroups = SourceClusterConsumerGroups

    @property
    def TargetClusterConsumerGroups(self):
        r"""Target cluster consumer group list.
        :rtype: list of str
        """
        return self._TargetClusterConsumerGroups

    @TargetClusterConsumerGroups.setter
    def TargetClusterConsumerGroups(self, TargetClusterConsumerGroups):
        self._TargetClusterConsumerGroups = TargetClusterConsumerGroups

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SourceClusterConsumerCount = params.get("SourceClusterConsumerCount")
        self._TargetClusterConsumerCount = params.get("TargetClusterConsumerCount")
        self._SourceClusterConsumerGroups = params.get("SourceClusterConsumerGroups")
        self._TargetClusterConsumerGroups = params.get("TargetClusterConsumerGroups")
        self._RequestId = params.get("RequestId")


class DescribeMigrationTaskListRequest(AbstractModel):
    r"""DescribeMigrationTaskList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Query criteria list
        :type Filters: list of Filter
        :param _Offset: Query start position
        :type Offset: int
        :param _Limit: Query result limit count
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""Query criteria list
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Query start position
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Query result limit count
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMigrationTaskListResponse(AbstractModel):
    r"""DescribeMigrationTaskList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Tasks: Migration Task List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tasks: list of MigrationTaskItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Tasks = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Tasks(self):
        r"""Migration Task List
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MigrationTaskItem
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = MigrationTaskItem()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProducerListRequest(AbstractModel):
    r"""DescribeProducerList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        """
        self._InstanceId = None
        self._Topic = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProducerListResponse(AbstractModel):
    r"""DescribeProducerList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _ProducerList: Producer information list.
        :type ProducerList: list of ProducerInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProducerList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProducerList(self):
        r"""Producer information list.
        :rtype: list of ProducerInfo
        """
        return self._ProducerList

    @ProducerList.setter
    def ProducerList(self, ProducerList):
        self._ProducerList = ProducerList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProducerList") is not None:
            self._ProducerList = []
            for item in params.get("ProducerList"):
                obj = ProducerInfo()
                obj._deserialize(item)
                self._ProducerList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProductSKUsRequest(AbstractModel):
    r"""DescribeProductSKUs request structure.

    """


class DescribeProductSKUsResponse(AbstractModel):
    r"""DescribeProductSKUs response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Product configuration information

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of ProductSKU
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""Product configuration information

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ProductSKU
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ProductSKU()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRoleListRequest(AbstractModel):
    r"""DescribeRoleList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListResponse(AbstractModel):
    r"""DescribeRoleList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Role information list
        :type Data: list of RoleItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Role information list
        :rtype: list of RoleItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RoleItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSmoothMigrationTaskListRequest(AbstractModel):
    r"""DescribeSmoothMigrationTaskList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSmoothMigrationTaskListResponse(AbstractModel):
    r"""DescribeSmoothMigrationTaskList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Task list.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of SmoothMigrationTaskItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Task list.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SmoothMigrationTaskItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = SmoothMigrationTaskItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSourceClusterGroupListRequest(AbstractModel):
    r"""DescribeSourceClusterGroupList request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Specifies the task ID. it can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the api [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        """
        self._TaskId = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def TaskId(self):
        r"""Specifies the task ID. it can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the api [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSourceClusterGroupListResponse(AbstractModel):
    r"""DescribeSourceClusterGroupList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Groups: List of consumption group configurations.
        :type Groups: list of SourceClusterGroupConfig
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Groups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Groups(self):
        r"""List of consumption group configurations.
        :rtype: list of SourceClusterGroupConfig
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = SourceClusterGroupConfig()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopicListByGroupRequest(AbstractModel):
    r"""DescribeTopicListByGroup request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._ConsumerGroup = None
        self._Filters = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ConsumerGroup = params.get("ConsumerGroup")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopicListByGroupResponse(AbstractModel):
    r"""DescribeTopicListByGroup response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Topic list.
        :type Data: list of SubscriptionData
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Topic list.
        :rtype: list of SubscriptionData
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = SubscriptionData()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopicListRequest(AbstractModel):
    r"""DescribeTopicList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _TagFilters: Tag filter
        :type TagFilters: list of TagFilter
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        :param _FromGroup: Queries subscribed topics by consumer group.
        :type FromGroup: str
        """
        self._InstanceId = None
        self._TagFilters = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._FromGroup = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TagFilters(self):
        r"""Tag filter
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def FromGroup(self):
        r"""Queries subscribed topics by consumer group.
        :rtype: str
        """
        return self._FromGroup

    @FromGroup.setter
    def FromGroup(self, FromGroup):
        self._FromGroup = FromGroup


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._FromGroup = params.get("FromGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopicListResponse(AbstractModel):
    r"""DescribeTopicList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total query count
        :type TotalCount: int
        :param _Data: Topic list.
        :type Data: list of TopicItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total query count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Data(self):
        r"""Topic list.
        :rtype: list of TopicItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TopicItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopicRequest(AbstractModel):
    r"""DescribeTopic request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _Filters: Filtering condition list. See the description of the API using this parameter for the usage method.
        :type Filters: list of Filter
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum number of queried results. Default value: 20.
        :type Limit: int
        """
        self._InstanceId = None
        self._Topic = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Filters(self):
        r"""Filtering condition list. See the description of the API using this parameter for the usage method.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number of queried results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopicResponse(AbstractModel):
    r"""DescribeTopic response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Topic: Topic name
        :type Topic: str
        :param _TopicType: Topic type.
UNSPECIFIED: not specified.
NORMAL: normal message.
FIFO: sequential message.
DELAY: delayed message.
TRANSACTION: transaction message.
        :type TopicType: str
        :param _Remark: Remarks
        :type Remark: str
        :param _CreatedTime: Creation time. **It is a Unix timestamp (ms).**
        :type CreatedTime: int
        :param _LastUpdateTime: Last write time. **It is a Unix timestamp (ms).**
        :type LastUpdateTime: int
        :param _SubscriptionCount: Number of Subscriptions
        :type SubscriptionCount: int
        :param _SubscriptionData: Subscribe to the relationship list.
        :type SubscriptionData: list of SubscriptionData
        :param _MsgTTL: Message retention period. Unit: hour.
        :type MsgTTL: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._Topic = None
        self._TopicType = None
        self._Remark = None
        self._CreatedTime = None
        self._LastUpdateTime = None
        self._SubscriptionCount = None
        self._SubscriptionData = None
        self._MsgTTL = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def TopicType(self):
        r"""Topic type.
UNSPECIFIED: not specified.
NORMAL: normal message.
FIFO: sequential message.
DELAY: delayed message.
TRANSACTION: transaction message.
        :rtype: str
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreatedTime(self):
        r"""Creation time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def LastUpdateTime(self):
        r"""Last write time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime

    @property
    def SubscriptionCount(self):
        r"""Number of Subscriptions
        :rtype: int
        """
        return self._SubscriptionCount

    @SubscriptionCount.setter
    def SubscriptionCount(self, SubscriptionCount):
        self._SubscriptionCount = SubscriptionCount

    @property
    def SubscriptionData(self):
        r"""Subscribe to the relationship list.
        :rtype: list of SubscriptionData
        """
        return self._SubscriptionData

    @SubscriptionData.setter
    def SubscriptionData(self, SubscriptionData):
        self._SubscriptionData = SubscriptionData

    @property
    def MsgTTL(self):
        r"""Message retention period. Unit: hour.
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._TopicType = params.get("TopicType")
        self._Remark = params.get("Remark")
        self._CreatedTime = params.get("CreatedTime")
        self._LastUpdateTime = params.get("LastUpdateTime")
        self._SubscriptionCount = params.get("SubscriptionCount")
        if params.get("SubscriptionData") is not None:
            self._SubscriptionData = []
            for item in params.get("SubscriptionData"):
                obj = SubscriptionData()
                obj._deserialize(item)
                self._SubscriptionData.append(obj)
        self._MsgTTL = params.get("MsgTTL")
        self._RequestId = params.get("RequestId")


class DetailedRolePerm(AbstractModel):
    r"""Permission configuration in Topic & Group dimension.

    """

    def __init__(self):
        r"""
        :param _Resource: Resources corresponding to permissions.
Specifies the topic name, which can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the api [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
Specifies the consumer group name, which can be obtained from the api response of DescribeConsumerGroupList (https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or the console.
        :type Resource: str
        :param _PermWrite: Whether to enable production permission
        :type PermWrite: bool
        :param _PermRead: Whether to enable consumption permission
        :type PermRead: bool
        :param _ResourceType: Authorize resource type (Topic: theme; Group: consumption Group).
        :type ResourceType: str
        :param _Remark: Resource remark.
        :type Remark: str
        """
        self._Resource = None
        self._PermWrite = None
        self._PermRead = None
        self._ResourceType = None
        self._Remark = None

    @property
    def Resource(self):
        r"""Resources corresponding to permissions.
Specifies the topic name, which can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the api [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
Specifies the consumer group name, which can be obtained from the api response of DescribeConsumerGroupList (https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._Resource

    @Resource.setter
    def Resource(self, Resource):
        self._Resource = Resource

    @property
    def PermWrite(self):
        r"""Whether to enable production permission
        :rtype: bool
        """
        return self._PermWrite

    @PermWrite.setter
    def PermWrite(self, PermWrite):
        self._PermWrite = PermWrite

    @property
    def PermRead(self):
        r"""Whether to enable consumption permission
        :rtype: bool
        """
        return self._PermRead

    @PermRead.setter
    def PermRead(self, PermRead):
        self._PermRead = PermRead

    @property
    def ResourceType(self):
        r"""Authorize resource type (Topic: theme; Group: consumption Group).
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Remark(self):
        r"""Resource remark.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._Resource = params.get("Resource")
        self._PermWrite = params.get("PermWrite")
        self._PermRead = params.get("PermRead")
        self._ResourceType = params.get("ResourceType")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DoHealthCheckOnMigratingTopicRequest(AbstractModel):
    r"""DoHealthCheckOnMigratingTopic request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        :param _TopicName: Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :type TopicName: str
        :param _IgnoreCheck: Whether to ignore the current check.
        :type IgnoreCheck: bool
        :param _Namespace: Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :type Namespace: str
        """
        self._TaskId = None
        self._TopicName = None
        self._IgnoreCheck = None
        self._Namespace = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TopicName(self):
        r"""Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def IgnoreCheck(self):
        r"""Whether to ignore the current check.
        :rtype: bool
        """
        return self._IgnoreCheck

    @IgnoreCheck.setter
    def IgnoreCheck(self, IgnoreCheck):
        self._IgnoreCheck = IgnoreCheck

    @property
    def Namespace(self):
        r"""Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TopicName = params.get("TopicName")
        self._IgnoreCheck = params.get("IgnoreCheck")
        self._Namespace = params.get("Namespace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DoHealthCheckOnMigratingTopicResponse(AbstractModel):
    r"""DoHealthCheckOnMigratingTopic response structure.

    """

    def __init__(self):
        r"""
        :param _Passed: Whether to Pass		
        :type Passed: bool
        :param _Reason: Error information returned by health check.
NotChecked indicates the check is not executed. 
Unknown error. 
TopicNotImported. specifies the topic is not imported.
TopicNotExistsInSourceCluster specifies the topic does not exist in the source cluster. 
Topic does not exist in the target cluster. 
ConsumerConnectedOnTarget specifies whether consumer connections exist on the target cluster. 
SourceTopicHasNewMessagesIn5Minutes indicates that new messages were written to the source cluster topic in the last 5 minutes. 
TargetTopicHasNewMessagesIn5Minutes specifies whether new messages were written to the target cluster topic in the last 5 minutes. 
SourceTopicHasNoMessagesIn5Minutes specifies no new messages were written to the source cluster in the last 5 minutes. 
TargetTopicHasNoMessagesIn5Minutes specifies that no new messages were written to the source cluster in the last 5 minutes. 
Inconsistent number of subscription groups. 
SourceTopicHasUnconsumedMessages specifies that unconsumed messages exist in the source cluster topic.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Reason: str
        :param _ReasonList: List of error information returned by health check.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReasonList: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Passed = None
        self._Reason = None
        self._ReasonList = None
        self._RequestId = None

    @property
    def Passed(self):
        r"""Whether to Pass		
        :rtype: bool
        """
        return self._Passed

    @Passed.setter
    def Passed(self, Passed):
        self._Passed = Passed

    @property
    def Reason(self):
        r"""Error information returned by health check.
NotChecked indicates the check is not executed. 
Unknown error. 
TopicNotImported. specifies the topic is not imported.
TopicNotExistsInSourceCluster specifies the topic does not exist in the source cluster. 
Topic does not exist in the target cluster. 
ConsumerConnectedOnTarget specifies whether consumer connections exist on the target cluster. 
SourceTopicHasNewMessagesIn5Minutes indicates that new messages were written to the source cluster topic in the last 5 minutes. 
TargetTopicHasNewMessagesIn5Minutes specifies whether new messages were written to the target cluster topic in the last 5 minutes. 
SourceTopicHasNoMessagesIn5Minutes specifies no new messages were written to the source cluster in the last 5 minutes. 
TargetTopicHasNoMessagesIn5Minutes specifies that no new messages were written to the source cluster in the last 5 minutes. 
Inconsistent number of subscription groups. 
SourceTopicHasUnconsumedMessages specifies that unconsumed messages exist in the source cluster topic.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def ReasonList(self):
        r"""List of error information returned by health check.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._ReasonList

    @ReasonList.setter
    def ReasonList(self, ReasonList):
        self._ReasonList = ReasonList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Passed = params.get("Passed")
        self._Reason = params.get("Reason")
        self._ReasonList = params.get("ReasonList")
        self._RequestId = params.get("RequestId")


class Endpoint(AbstractModel):
    r"""Access point information.

    """

    def __init__(self):
        r"""
        :param _Type: Access point type, with the enumerated values as follows:.

- VPC: specifies the VPC network.

-PUBLIC: public network.

-INTERNAL: specifies the support network.
        :type Type: str
        :param _Status: Status.
OPEN: indicates to start or activate a function.
CLOSE: indicates the closed state.
PROCESSING: operation in progress.
        :type Status: str
        :param _PayMode: Payment type, only public network.
PREPAID: annual/monthly package.
Pay-As-You-Go.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayMode: str
        :param _EndpointUrl: Access point address.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndpointUrl: str
        :param _VpcId: VPC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _SubnetId: Specifies the subnet ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubnetId: str
        :param _Bandwidth: Public network bandwidth, in Mbps

Note: This field may return null, indicating that no valid values can be obtained.
        :type Bandwidth: int
        :param _IpRules: Public network access rules

Note: This field may return null, indicating that no valid values can be obtained.
        :type IpRules: list of IpRule
        :param _BillingFlow: Whether the public network is billed by traffic.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingFlow: bool
        """
        self._Type = None
        self._Status = None
        self._PayMode = None
        self._EndpointUrl = None
        self._VpcId = None
        self._SubnetId = None
        self._Bandwidth = None
        self._IpRules = None
        self._BillingFlow = None

    @property
    def Type(self):
        r"""Access point type, with the enumerated values as follows:.

- VPC: specifies the VPC network.

-PUBLIC: public network.

-INTERNAL: specifies the support network.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        r"""Status.
OPEN: indicates to start or activate a function.
CLOSE: indicates the closed state.
PROCESSING: operation in progress.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PayMode(self):
        r"""Payment type, only public network.
PREPAID: annual/monthly package.
Pay-As-You-Go.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def EndpointUrl(self):
        r"""Access point address.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EndpointUrl

    @EndpointUrl.setter
    def EndpointUrl(self, EndpointUrl):
        self._EndpointUrl = EndpointUrl

    @property
    def VpcId(self):
        r"""VPC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Specifies the subnet ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Bandwidth(self):
        r"""Public network bandwidth, in Mbps

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def IpRules(self):
        r"""Public network access rules

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of IpRule
        """
        return self._IpRules

    @IpRules.setter
    def IpRules(self, IpRules):
        self._IpRules = IpRules

    @property
    def BillingFlow(self):
        r"""Whether the public network is billed by traffic.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._BillingFlow

    @BillingFlow.setter
    def BillingFlow(self, BillingFlow):
        self._BillingFlow = BillingFlow


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._PayMode = params.get("PayMode")
        self._EndpointUrl = params.get("EndpointUrl")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Bandwidth = params.get("Bandwidth")
        if params.get("IpRules") is not None:
            self._IpRules = []
            for item in params.get("IpRules"):
                obj = IpRule()
                obj._deserialize(item)
                self._IpRules.append(obj)
        self._BillingFlow = params.get("BillingFlow")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    r"""Query filter

    """

    def __init__(self):
        r"""
        :param _Name: Filter condition parameter name.
        :type Name: str
        :param _Values: Filter criterion value
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Filter condition parameter name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Filter criterion value
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FusionInstanceItem(AbstractModel):
    r"""Instance information on the instance list page

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _Version: Instance version.
        :type Version: str
        :param _InstanceType: Instance type.
Trial version.
BASIC version.
PRO, professional edition.
PLATINUM edition.
        :type InstanceType: str
        :param _InstanceStatus: Instance status.
RUNNING. specifies the running status.
MAINTAINING.
ABNORMAL.
OVERDUE. specifies the state of arrears.
`DESTROYED`: `deleted`.
CREATING.
MODIFYING.
CREATE_FAILURE. specifies that the creation failed.
MODIFY_FAILURE. indicates a configuration adjustment failure.
Valid values: DELETING. indicates that the resource is being deleted.
        :type InstanceStatus: str
        :param _TopicNumLimit: Maximum number of instance topics
        :type TopicNumLimit: int
        :param _GroupNumLimit: Maximum number of instance consumer groups
        :type GroupNumLimit: int
        :param _PayMode: Billing mode. valid enumeration values are as follows:.

-POSTPAID: pay-as-you-go.

- PREPAID: monthly subscription.
        :type PayMode: str
        :param _ExpiryTime: Expiration time. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpiryTime: int
        :param _Remark: Remarks

Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _TopicNum: Number of topics
        :type TopicNum: int
        :param _GroupNum: Number of consumer groups
        :type GroupNum: int
        :param _TagList: Tag list

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagList: list of Tag
        :param _SkuCode: Specifies the product specification.
        :type SkuCode: str
        :param _TpsLimit: TPS throttle value

Note: This field may return null, indicating that no valid values can be obtained.
        :type TpsLimit: int
        :param _ScaledTpsLimit: Elastic TPS throttle value
        :type ScaledTpsLimit: int
        :param _MessageRetention: Message retention time, in hours
        :type MessageRetention: int
        :param _MaxMessageDelay: Maximum delayed message duration, in hours
        :type MaxMessageDelay: int
        :param _RenewFlag: Specifies whether the prepaid cluster is automatically renewed. valid values are as follows:.

- 0: no automatic renewal.
- 1: specifies automatic renewal.
        :type RenewFlag: int
        :param _InstanceItemExtraInfo: Data unique to version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceItemExtraInfo: :class:`tencentcloud.trocket.v20230308.models.InstanceItemExtraInfo`
        :param _DestroyTime: Expected termination time. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :type DestroyTime: int
        :param _ZoneIds: AZ list. See [ZoneInfo](https://www.tencentcloud.comom/document/api/1596/77932?from_cn_redirect=1#ZoneInfo) returned by the API [DescribeZones](https://www.tencentcloud.comom/document/product/1596/77929?from_cn_redirect=1) in Data Type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneIds: list of int
        :param _EnableDeletionProtection: Whether to enable deletion protection
        :type EnableDeletionProtection: bool
        :param _CreateTime: Instance creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _ScaledTpsEnabled: Elastic TPS switch.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScaledTpsEnabled: bool
        """
        self._InstanceId = None
        self._InstanceName = None
        self._Version = None
        self._InstanceType = None
        self._InstanceStatus = None
        self._TopicNumLimit = None
        self._GroupNumLimit = None
        self._PayMode = None
        self._ExpiryTime = None
        self._Remark = None
        self._TopicNum = None
        self._GroupNum = None
        self._TagList = None
        self._SkuCode = None
        self._TpsLimit = None
        self._ScaledTpsLimit = None
        self._MessageRetention = None
        self._MaxMessageDelay = None
        self._RenewFlag = None
        self._InstanceItemExtraInfo = None
        self._DestroyTime = None
        self._ZoneIds = None
        self._EnableDeletionProtection = None
        self._CreateTime = None
        self._ScaledTpsEnabled = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Version(self):
        r"""Instance version.
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def InstanceType(self):
        r"""Instance type.
Trial version.
BASIC version.
PRO, professional edition.
PLATINUM edition.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceStatus(self):
        r"""Instance status.
RUNNING. specifies the running status.
MAINTAINING.
ABNORMAL.
OVERDUE. specifies the state of arrears.
`DESTROYED`: `deleted`.
CREATING.
MODIFYING.
CREATE_FAILURE. specifies that the creation failed.
MODIFY_FAILURE. indicates a configuration adjustment failure.
Valid values: DELETING. indicates that the resource is being deleted.
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def TopicNumLimit(self):
        r"""Maximum number of instance topics
        :rtype: int
        """
        return self._TopicNumLimit

    @TopicNumLimit.setter
    def TopicNumLimit(self, TopicNumLimit):
        self._TopicNumLimit = TopicNumLimit

    @property
    def GroupNumLimit(self):
        r"""Maximum number of instance consumer groups
        :rtype: int
        """
        return self._GroupNumLimit

    @GroupNumLimit.setter
    def GroupNumLimit(self, GroupNumLimit):
        self._GroupNumLimit = GroupNumLimit

    @property
    def PayMode(self):
        r"""Billing mode. valid enumeration values are as follows:.

-POSTPAID: pay-as-you-go.

- PREPAID: monthly subscription.
        :rtype: str
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ExpiryTime(self):
        r"""Expiration time. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExpiryTime

    @ExpiryTime.setter
    def ExpiryTime(self, ExpiryTime):
        self._ExpiryTime = ExpiryTime

    @property
    def Remark(self):
        r"""Remarks

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TopicNum(self):
        r"""Number of topics
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def GroupNum(self):
        r"""Number of consumer groups
        :rtype: int
        """
        return self._GroupNum

    @GroupNum.setter
    def GroupNum(self, GroupNum):
        self._GroupNum = GroupNum

    @property
    def TagList(self):
        r"""Tag list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList

    @property
    def SkuCode(self):
        r"""Specifies the product specification.
        :rtype: str
        """
        return self._SkuCode

    @SkuCode.setter
    def SkuCode(self, SkuCode):
        self._SkuCode = SkuCode

    @property
    def TpsLimit(self):
        r"""TPS throttle value

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TpsLimit

    @TpsLimit.setter
    def TpsLimit(self, TpsLimit):
        self._TpsLimit = TpsLimit

    @property
    def ScaledTpsLimit(self):
        r"""Elastic TPS throttle value
        :rtype: int
        """
        return self._ScaledTpsLimit

    @ScaledTpsLimit.setter
    def ScaledTpsLimit(self, ScaledTpsLimit):
        self._ScaledTpsLimit = ScaledTpsLimit

    @property
    def MessageRetention(self):
        r"""Message retention time, in hours
        :rtype: int
        """
        return self._MessageRetention

    @MessageRetention.setter
    def MessageRetention(self, MessageRetention):
        self._MessageRetention = MessageRetention

    @property
    def MaxMessageDelay(self):
        r"""Maximum delayed message duration, in hours
        :rtype: int
        """
        return self._MaxMessageDelay

    @MaxMessageDelay.setter
    def MaxMessageDelay(self, MaxMessageDelay):
        self._MaxMessageDelay = MaxMessageDelay

    @property
    def RenewFlag(self):
        r"""Specifies whether the prepaid cluster is automatically renewed. valid values are as follows:.

- 0: no automatic renewal.
- 1: specifies automatic renewal.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def InstanceItemExtraInfo(self):
        r"""Data unique to version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.trocket.v20230308.models.InstanceItemExtraInfo`
        """
        return self._InstanceItemExtraInfo

    @InstanceItemExtraInfo.setter
    def InstanceItemExtraInfo(self, InstanceItemExtraInfo):
        self._InstanceItemExtraInfo = InstanceItemExtraInfo

    @property
    def DestroyTime(self):
        r"""Expected termination time. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DestroyTime

    @DestroyTime.setter
    def DestroyTime(self, DestroyTime):
        self._DestroyTime = DestroyTime

    @property
    def ZoneIds(self):
        r"""AZ list. See [ZoneInfo](https://www.tencentcloud.comom/document/api/1596/77932?from_cn_redirect=1#ZoneInfo) returned by the API [DescribeZones](https://www.tencentcloud.comom/document/product/1596/77929?from_cn_redirect=1) in Data Type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def EnableDeletionProtection(self):
        r"""Whether to enable deletion protection
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection

    @property
    def CreateTime(self):
        r"""Instance creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ScaledTpsEnabled(self):
        r"""Elastic TPS switch.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._ScaledTpsEnabled

    @ScaledTpsEnabled.setter
    def ScaledTpsEnabled(self, ScaledTpsEnabled):
        self._ScaledTpsEnabled = ScaledTpsEnabled


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Version = params.get("Version")
        self._InstanceType = params.get("InstanceType")
        self._InstanceStatus = params.get("InstanceStatus")
        self._TopicNumLimit = params.get("TopicNumLimit")
        self._GroupNumLimit = params.get("GroupNumLimit")
        self._PayMode = params.get("PayMode")
        self._ExpiryTime = params.get("ExpiryTime")
        self._Remark = params.get("Remark")
        self._TopicNum = params.get("TopicNum")
        self._GroupNum = params.get("GroupNum")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        self._SkuCode = params.get("SkuCode")
        self._TpsLimit = params.get("TpsLimit")
        self._ScaledTpsLimit = params.get("ScaledTpsLimit")
        self._MessageRetention = params.get("MessageRetention")
        self._MaxMessageDelay = params.get("MaxMessageDelay")
        self._RenewFlag = params.get("RenewFlag")
        if params.get("InstanceItemExtraInfo") is not None:
            self._InstanceItemExtraInfo = InstanceItemExtraInfo()
            self._InstanceItemExtraInfo._deserialize(params.get("InstanceItemExtraInfo"))
        self._DestroyTime = params.get("DestroyTime")
        self._ZoneIds = params.get("ZoneIds")
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        self._CreateTime = params.get("CreateTime")
        self._ScaledTpsEnabled = params.get("ScaledTpsEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceItem(AbstractModel):
    r"""Instance information on the instance list page

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _Version: Instance version.
        :type Version: str
        :param _InstanceType: Instance type.
Trial version.
BASIC version.
PRO, professional edition.
PLATINUM edition.
        :type InstanceType: str
        :param _InstanceStatus: Instance status.
RUNNING. specifies the running status.
MAINTAINING.
ABNORMAL.
OVERDUE. specifies the state of arrears.
`DESTROYED`: deleted.
CREATING.
MODIFYING.
CREATE_FAILURE. specifies that the creation failed.
MODIFY_FAILURE. indicates a configuration adjustment failure.
DELETING.
        :type InstanceStatus: str
        :param _TopicNumLimit: Maximum number of instance topics
        :type TopicNumLimit: int
        :param _GroupNumLimit: Maximum number of instance consumer groups
        :type GroupNumLimit: int
        :param _PayMode: Billing mode. valid enumeration values are as follows:.

-POSTPAID: pay-as-you-go.

- PREPAID: monthly subscription.
        :type PayMode: str
        :param _ExpiryTime: Expiration timestamp. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpiryTime: int
        :param _Remark: Remarks

Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _TopicNum: Number of topics
        :type TopicNum: int
        :param _GroupNum: Number of consumer groups
        :type GroupNum: int
        :param _TagList: Tag list

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagList: list of Tag
        :param _SkuCode: Specifies the product specification.
        :type SkuCode: str
        :param _TpsLimit: TPS throttle value
        :type TpsLimit: int
        :param _ScaledTpsLimit: Elastic TPS throttle value
        :type ScaledTpsLimit: int
        :param _MessageRetention: Message retention time, in hours
        :type MessageRetention: int
        :param _MaxMessageDelay: Maximum delayed message duration, in hours
        :type MaxMessageDelay: int
        :param _RenewFlag: Whether automatic renewal is enabled. This parameter is valid only for prepaid clusters. 0: automatic renewal disabled; 1: automatic renewal enabled.
        :type RenewFlag: int
        """
        self._InstanceId = None
        self._InstanceName = None
        self._Version = None
        self._InstanceType = None
        self._InstanceStatus = None
        self._TopicNumLimit = None
        self._GroupNumLimit = None
        self._PayMode = None
        self._ExpiryTime = None
        self._Remark = None
        self._TopicNum = None
        self._GroupNum = None
        self._TagList = None
        self._SkuCode = None
        self._TpsLimit = None
        self._ScaledTpsLimit = None
        self._MessageRetention = None
        self._MaxMessageDelay = None
        self._RenewFlag = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Version(self):
        r"""Instance version.
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def InstanceType(self):
        r"""Instance type.
Trial version.
BASIC version.
PRO, professional edition.
PLATINUM edition.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceStatus(self):
        r"""Instance status.
RUNNING. specifies the running status.
MAINTAINING.
ABNORMAL.
OVERDUE. specifies the state of arrears.
`DESTROYED`: deleted.
CREATING.
MODIFYING.
CREATE_FAILURE. specifies that the creation failed.
MODIFY_FAILURE. indicates a configuration adjustment failure.
DELETING.
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def TopicNumLimit(self):
        r"""Maximum number of instance topics
        :rtype: int
        """
        return self._TopicNumLimit

    @TopicNumLimit.setter
    def TopicNumLimit(self, TopicNumLimit):
        self._TopicNumLimit = TopicNumLimit

    @property
    def GroupNumLimit(self):
        r"""Maximum number of instance consumer groups
        :rtype: int
        """
        return self._GroupNumLimit

    @GroupNumLimit.setter
    def GroupNumLimit(self, GroupNumLimit):
        self._GroupNumLimit = GroupNumLimit

    @property
    def PayMode(self):
        r"""Billing mode. valid enumeration values are as follows:.

-POSTPAID: pay-as-you-go.

- PREPAID: monthly subscription.
        :rtype: str
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ExpiryTime(self):
        r"""Expiration timestamp. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExpiryTime

    @ExpiryTime.setter
    def ExpiryTime(self, ExpiryTime):
        self._ExpiryTime = ExpiryTime

    @property
    def Remark(self):
        r"""Remarks

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TopicNum(self):
        r"""Number of topics
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def GroupNum(self):
        r"""Number of consumer groups
        :rtype: int
        """
        return self._GroupNum

    @GroupNum.setter
    def GroupNum(self, GroupNum):
        self._GroupNum = GroupNum

    @property
    def TagList(self):
        r"""Tag list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList

    @property
    def SkuCode(self):
        r"""Specifies the product specification.
        :rtype: str
        """
        return self._SkuCode

    @SkuCode.setter
    def SkuCode(self, SkuCode):
        self._SkuCode = SkuCode

    @property
    def TpsLimit(self):
        r"""TPS throttle value
        :rtype: int
        """
        return self._TpsLimit

    @TpsLimit.setter
    def TpsLimit(self, TpsLimit):
        self._TpsLimit = TpsLimit

    @property
    def ScaledTpsLimit(self):
        r"""Elastic TPS throttle value
        :rtype: int
        """
        return self._ScaledTpsLimit

    @ScaledTpsLimit.setter
    def ScaledTpsLimit(self, ScaledTpsLimit):
        self._ScaledTpsLimit = ScaledTpsLimit

    @property
    def MessageRetention(self):
        r"""Message retention time, in hours
        :rtype: int
        """
        return self._MessageRetention

    @MessageRetention.setter
    def MessageRetention(self, MessageRetention):
        self._MessageRetention = MessageRetention

    @property
    def MaxMessageDelay(self):
        r"""Maximum delayed message duration, in hours
        :rtype: int
        """
        return self._MaxMessageDelay

    @MaxMessageDelay.setter
    def MaxMessageDelay(self, MaxMessageDelay):
        self._MaxMessageDelay = MaxMessageDelay

    @property
    def RenewFlag(self):
        r"""Whether automatic renewal is enabled. This parameter is valid only for prepaid clusters. 0: automatic renewal disabled; 1: automatic renewal enabled.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Version = params.get("Version")
        self._InstanceType = params.get("InstanceType")
        self._InstanceStatus = params.get("InstanceStatus")
        self._TopicNumLimit = params.get("TopicNumLimit")
        self._GroupNumLimit = params.get("GroupNumLimit")
        self._PayMode = params.get("PayMode")
        self._ExpiryTime = params.get("ExpiryTime")
        self._Remark = params.get("Remark")
        self._TopicNum = params.get("TopicNum")
        self._GroupNum = params.get("GroupNum")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        self._SkuCode = params.get("SkuCode")
        self._TpsLimit = params.get("TpsLimit")
        self._ScaledTpsLimit = params.get("ScaledTpsLimit")
        self._MessageRetention = params.get("MessageRetention")
        self._MaxMessageDelay = params.get("MaxMessageDelay")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceItemExtraInfo(AbstractModel):
    r"""Unified list display for 4.x clusters and 5.0 clusters shows the 4.x special data carrying interface.

    """

    def __init__(self):
        r"""
        :param _IsVip: Whether it is a vip.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsVip: bool
        :param _VipInstanceStatus: Specifies the dedicated cluster status of version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VipInstanceStatus: int
        :param _MaxBandWidth: Specifies the peak bandwidth of the dedicated cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxBandWidth: int
        :param _SpecName: Exclusive cluster specification.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SpecName: str
        :param _NodeCount: Specifies the quantity of exclusive cluster nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeCount: int
        :param _MaxStorage: Specifies the maximum storage of the dedicated cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxStorage: int
        :param _MaxRetention: Specifies the maximum retention time of the dedicated cluster. the unit is hour.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxRetention: int
        :param _MinRetention: Special project cluster maximum retention time, unit: hr.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MinRetention: int
        :param _InstanceStatus: Status of 4.0 shared cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceStatus: int
        :param _IsFrozen: Whether it is frozen.
        :type IsFrozen: bool
        """
        self._IsVip = None
        self._VipInstanceStatus = None
        self._MaxBandWidth = None
        self._SpecName = None
        self._NodeCount = None
        self._MaxStorage = None
        self._MaxRetention = None
        self._MinRetention = None
        self._InstanceStatus = None
        self._IsFrozen = None

    @property
    def IsVip(self):
        r"""Whether it is a vip.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsVip

    @IsVip.setter
    def IsVip(self, IsVip):
        self._IsVip = IsVip

    @property
    def VipInstanceStatus(self):
        r"""Specifies the dedicated cluster status of version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._VipInstanceStatus

    @VipInstanceStatus.setter
    def VipInstanceStatus(self, VipInstanceStatus):
        self._VipInstanceStatus = VipInstanceStatus

    @property
    def MaxBandWidth(self):
        r"""Specifies the peak bandwidth of the dedicated cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxBandWidth

    @MaxBandWidth.setter
    def MaxBandWidth(self, MaxBandWidth):
        self._MaxBandWidth = MaxBandWidth

    @property
    def SpecName(self):
        r"""Exclusive cluster specification.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def NodeCount(self):
        r"""Specifies the quantity of exclusive cluster nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def MaxStorage(self):
        r"""Specifies the maximum storage of the dedicated cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxStorage

    @MaxStorage.setter
    def MaxStorage(self, MaxStorage):
        self._MaxStorage = MaxStorage

    @property
    def MaxRetention(self):
        r"""Specifies the maximum retention time of the dedicated cluster. the unit is hour.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxRetention

    @MaxRetention.setter
    def MaxRetention(self, MaxRetention):
        self._MaxRetention = MaxRetention

    @property
    def MinRetention(self):
        r"""Special project cluster maximum retention time, unit: hr.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MinRetention

    @MinRetention.setter
    def MinRetention(self, MinRetention):
        self._MinRetention = MinRetention

    @property
    def InstanceStatus(self):
        r"""Status of 4.0 shared cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def IsFrozen(self):
        r"""Whether it is frozen.
        :rtype: bool
        """
        return self._IsFrozen

    @IsFrozen.setter
    def IsFrozen(self, IsFrozen):
        self._IsFrozen = IsFrozen


    def _deserialize(self, params):
        self._IsVip = params.get("IsVip")
        self._VipInstanceStatus = params.get("VipInstanceStatus")
        self._MaxBandWidth = params.get("MaxBandWidth")
        self._SpecName = params.get("SpecName")
        self._NodeCount = params.get("NodeCount")
        self._MaxStorage = params.get("MaxStorage")
        self._MaxRetention = params.get("MaxRetention")
        self._MinRetention = params.get("MinRetention")
        self._InstanceStatus = params.get("InstanceStatus")
        self._IsFrozen = params.get("IsFrozen")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpRule(AbstractModel):
    r"""IP rules

    """

    def __init__(self):
        r"""
        :param _Ip: Specifies the IP address.
        :type Ip: str
        :param _Allow: Whether the IP address is allowed. Default value: false, indicating that the IP address is denied.
        :type Allow: bool
        :param _Remark: Remarks
        :type Remark: str
        """
        self._Ip = None
        self._Allow = None
        self._Remark = None

    @property
    def Ip(self):
        r"""Specifies the IP address.
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Allow(self):
        r"""Whether the IP address is allowed. Default value: false, indicating that the IP address is denied.
        :rtype: bool
        """
        return self._Allow

    @Allow.setter
    def Allow(self, Allow):
        self._Allow = Allow

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Allow = params.get("Allow")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MessageItem(AbstractModel):
    r"""Message log

    """

    def __init__(self):
        r"""
        :param _MsgId: Message ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgId: str
        :param _Tags: Message tag

Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: str
        :param _Keys: Message key.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Keys: str
        :param _ProducerAddr: Client address.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProducerAddr: str
        :param _ProduceTime: Message Sending Time	
	
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProduceTime: str
        :param _DeadLetterResendTimes: Dead-letter resend count	
	
Note: This field may return null, indicating that no valid values can be obtained.
        :type DeadLetterResendTimes: int
        :param _DeadLetterResendSuccessTimes: Dead Letter Resend Success Count

Note: This field may return null, indicating that no valid values can be obtained.
        :type DeadLetterResendSuccessTimes: int
        """
        self._MsgId = None
        self._Tags = None
        self._Keys = None
        self._ProducerAddr = None
        self._ProduceTime = None
        self._DeadLetterResendTimes = None
        self._DeadLetterResendSuccessTimes = None

    @property
    def MsgId(self):
        r"""Message ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def Tags(self):
        r"""Message tag

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Keys(self):
        r"""Message key.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Keys

    @Keys.setter
    def Keys(self, Keys):
        self._Keys = Keys

    @property
    def ProducerAddr(self):
        r"""Client address.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProducerAddr

    @ProducerAddr.setter
    def ProducerAddr(self, ProducerAddr):
        self._ProducerAddr = ProducerAddr

    @property
    def ProduceTime(self):
        r"""Message Sending Time	
	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def DeadLetterResendTimes(self):
        r"""Dead-letter resend count	
	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DeadLetterResendTimes

    @DeadLetterResendTimes.setter
    def DeadLetterResendTimes(self, DeadLetterResendTimes):
        self._DeadLetterResendTimes = DeadLetterResendTimes

    @property
    def DeadLetterResendSuccessTimes(self):
        r"""Dead Letter Resend Success Count

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DeadLetterResendSuccessTimes

    @DeadLetterResendSuccessTimes.setter
    def DeadLetterResendSuccessTimes(self, DeadLetterResendSuccessTimes):
        self._DeadLetterResendSuccessTimes = DeadLetterResendSuccessTimes


    def _deserialize(self, params):
        self._MsgId = params.get("MsgId")
        self._Tags = params.get("Tags")
        self._Keys = params.get("Keys")
        self._ProducerAddr = params.get("ProducerAddr")
        self._ProduceTime = params.get("ProduceTime")
        self._DeadLetterResendTimes = params.get("DeadLetterResendTimes")
        self._DeadLetterResendSuccessTimes = params.get("DeadLetterResendSuccessTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MessageTraceItem(AbstractModel):
    r"""Message trace.

    """

    def __init__(self):
        r"""
        :param _Stage: Message handling phase. valid values are as follows:.

-Produces messages.

-Persists message storage.

-Consumes messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Stage: str
        :param _Data: Track details

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        """
        self._Stage = None
        self._Data = None

    @property
    def Stage(self):
        r"""Message handling phase. valid values are as follows:.

-Produces messages.

-Persists message storage.

-Consumes messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Stage

    @Stage.setter
    def Stage(self, Stage):
        self._Stage = Stage

    @property
    def Data(self):
        r"""Track details

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Stage = params.get("Stage")
        self._Data = params.get("Data")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MessageTrackItem(AbstractModel):
    r"""MessageTrack

    """

    def __init__(self):
        r"""
        :param _ConsumerGroup: Specifies the consumer group name.
        :type ConsumerGroup: str
        :param _ConsumeStatus: Consumption status. CONSUMED: Consumed CONSUMED_BUT_FILTERED: Filtered NOT_CONSUME: Not consumed ENTER_RETRY: Enter retry queue. ENTER_DLQ: Enter dead letter queue. UNKNOWN: Consumption status unknown
        :type ConsumeStatus: str
        :param _TrackType: Track type
        :type TrackType: str
        :param _ExceptionDesc: Exception information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptionDesc: str
        """
        self._ConsumerGroup = None
        self._ConsumeStatus = None
        self._TrackType = None
        self._ExceptionDesc = None

    @property
    def ConsumerGroup(self):
        r"""Specifies the consumer group name.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def ConsumeStatus(self):
        r"""Consumption status. CONSUMED: Consumed CONSUMED_BUT_FILTERED: Filtered NOT_CONSUME: Not consumed ENTER_RETRY: Enter retry queue. ENTER_DLQ: Enter dead letter queue. UNKNOWN: Consumption status unknown
        :rtype: str
        """
        return self._ConsumeStatus

    @ConsumeStatus.setter
    def ConsumeStatus(self, ConsumeStatus):
        self._ConsumeStatus = ConsumeStatus

    @property
    def TrackType(self):
        r"""Track type
        :rtype: str
        """
        return self._TrackType

    @TrackType.setter
    def TrackType(self, TrackType):
        self._TrackType = TrackType

    @property
    def ExceptionDesc(self):
        r"""Exception information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExceptionDesc

    @ExceptionDesc.setter
    def ExceptionDesc(self, ExceptionDesc):
        self._ExceptionDesc = ExceptionDesc


    def _deserialize(self, params):
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._ConsumeStatus = params.get("ConsumeStatus")
        self._TrackType = params.get("TrackType")
        self._ExceptionDesc = params.get("ExceptionDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigratingTopic(AbstractModel):
    r"""Migrating topic.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name
        :type TopicName: str
        :param _MigrationStatus: Migration status. 
S_RW_D_NA source cluster read/write.
S_RW_D_R specifies read and write permissions for the source cluster and read permissions for the target cluster.
S_RW_D_RW specifies read-write for the source cluster and read-write for the target cluster.
SRDRW specifies source cluster read and destination cluster read/write.
S_NA_D_RW specifies the read-write target cluster.
        :type MigrationStatus: str
        :param _HealthCheckPassed: Specifies whether the health check is completed.	
        :type HealthCheckPassed: bool
        :param _HealthCheckError: Error information returned by the last health check is valid only when HealthCheckPassed is false. NotChecked: check not executed. Unknown: Unknown error. TopicNotImported: topic not imported. TopicNotExistsInSourceCluster: topic does not exist in the source cluster. TopicNotExistsInTargetCluster: topic does not exist in the target cluster. ConsumerConnectedOnTarget: consumer connections exist on the target cluster. SourceTopicHasNewMessagesIn5Minutes: new messages were written to the source cluster topic in the last 5 Minutes. TargetTopicHasNewMessagesIn5Minutes: new messages were written to the target cluster topic in the last 5 Minutes. SourceTopicHasNoMessagesIn5Minutes: no new messages were written to the source cluster in the last 5 Minutes. TargetTopicHasNoMessagesIn5Minutes: no new messages were written to the target cluster in the last 5 Minutes. ConsumerGroupCountNotMatch: inconsistent number of subscription groups. SourceTopicHasUnconsumedMessages: unconsumed messages exist in the source cluster topic.
        :type HealthCheckError: str
        :param _Namespace: Namespace. specifies that it is only valid for 4.x clusters.
        :type Namespace: str
        :param _NamespaceV4: Namespace of 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NamespaceV4: str
        :param _TopicNameV4: Topic name for version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicNameV4: str
        :param _FullNamespaceV4: Complete namespace for 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FullNamespaceV4: str
        :param _HealthCheckErrorList: Error list returned from the last health check.
        :type HealthCheckErrorList: list of str
        """
        self._TopicName = None
        self._MigrationStatus = None
        self._HealthCheckPassed = None
        self._HealthCheckError = None
        self._Namespace = None
        self._NamespaceV4 = None
        self._TopicNameV4 = None
        self._FullNamespaceV4 = None
        self._HealthCheckErrorList = None

    @property
    def TopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MigrationStatus(self):
        r"""Migration status. 
S_RW_D_NA source cluster read/write.
S_RW_D_R specifies read and write permissions for the source cluster and read permissions for the target cluster.
S_RW_D_RW specifies read-write for the source cluster and read-write for the target cluster.
SRDRW specifies source cluster read and destination cluster read/write.
S_NA_D_RW specifies the read-write target cluster.
        :rtype: str
        """
        return self._MigrationStatus

    @MigrationStatus.setter
    def MigrationStatus(self, MigrationStatus):
        self._MigrationStatus = MigrationStatus

    @property
    def HealthCheckPassed(self):
        r"""Specifies whether the health check is completed.	
        :rtype: bool
        """
        return self._HealthCheckPassed

    @HealthCheckPassed.setter
    def HealthCheckPassed(self, HealthCheckPassed):
        self._HealthCheckPassed = HealthCheckPassed

    @property
    def HealthCheckError(self):
        r"""Error information returned by the last health check is valid only when HealthCheckPassed is false. NotChecked: check not executed. Unknown: Unknown error. TopicNotImported: topic not imported. TopicNotExistsInSourceCluster: topic does not exist in the source cluster. TopicNotExistsInTargetCluster: topic does not exist in the target cluster. ConsumerConnectedOnTarget: consumer connections exist on the target cluster. SourceTopicHasNewMessagesIn5Minutes: new messages were written to the source cluster topic in the last 5 Minutes. TargetTopicHasNewMessagesIn5Minutes: new messages were written to the target cluster topic in the last 5 Minutes. SourceTopicHasNoMessagesIn5Minutes: no new messages were written to the source cluster in the last 5 Minutes. TargetTopicHasNoMessagesIn5Minutes: no new messages were written to the target cluster in the last 5 Minutes. ConsumerGroupCountNotMatch: inconsistent number of subscription groups. SourceTopicHasUnconsumedMessages: unconsumed messages exist in the source cluster topic.
        :rtype: str
        """
        return self._HealthCheckError

    @HealthCheckError.setter
    def HealthCheckError(self, HealthCheckError):
        self._HealthCheckError = HealthCheckError

    @property
    def Namespace(self):
        r"""Namespace. specifies that it is only valid for 4.x clusters.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def NamespaceV4(self):
        r"""Namespace of 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NamespaceV4

    @NamespaceV4.setter
    def NamespaceV4(self, NamespaceV4):
        self._NamespaceV4 = NamespaceV4

    @property
    def TopicNameV4(self):
        r"""Topic name for version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TopicNameV4

    @TopicNameV4.setter
    def TopicNameV4(self, TopicNameV4):
        self._TopicNameV4 = TopicNameV4

    @property
    def FullNamespaceV4(self):
        r"""Complete namespace for 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FullNamespaceV4

    @FullNamespaceV4.setter
    def FullNamespaceV4(self, FullNamespaceV4):
        self._FullNamespaceV4 = FullNamespaceV4

    @property
    def HealthCheckErrorList(self):
        r"""Error list returned from the last health check.
        :rtype: list of str
        """
        return self._HealthCheckErrorList

    @HealthCheckErrorList.setter
    def HealthCheckErrorList(self, HealthCheckErrorList):
        self._HealthCheckErrorList = HealthCheckErrorList


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._MigrationStatus = params.get("MigrationStatus")
        self._HealthCheckPassed = params.get("HealthCheckPassed")
        self._HealthCheckError = params.get("HealthCheckError")
        self._Namespace = params.get("Namespace")
        self._NamespaceV4 = params.get("NamespaceV4")
        self._TopicNameV4 = params.get("TopicNameV4")
        self._FullNamespaceV4 = params.get("FullNamespaceV4")
        self._HealthCheckErrorList = params.get("HealthCheckErrorList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MigrationTaskItem(AbstractModel):
    r"""Migration task information.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _Type: 0 - not specified (existing).
Metadata import.
        :type Type: int
        :param _TopicNum: Total number of topics.
        :type TopicNum: int
        :param _GroupNum: Total Number of Consumer Groups
        :type GroupNum: int
        :param _Status: Task status. 0: migrating; 1: migration successful; 2: migration completed, with only part of the data migrated.
        :type Status: int
        :param _CreateTime: Creation time.
        :type CreateTime: int
        """
        self._TaskId = None
        self._InstanceId = None
        self._Type = None
        self._TopicNum = None
        self._GroupNum = None
        self._Status = None
        self._CreateTime = None

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Type(self):
        r"""0 - not specified (existing).
Metadata import.
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TopicNum(self):
        r"""Total number of topics.
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def GroupNum(self):
        r"""Total Number of Consumer Groups
        :rtype: int
        """
        return self._GroupNum

    @GroupNum.setter
    def GroupNum(self, GroupNum):
        self._GroupNum = GroupNum

    @property
    def Status(self):
        r"""Task status. 0: migrating; 1: migration successful; 2: migration completed, with only part of the data migrated.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._InstanceId = params.get("InstanceId")
        self._Type = params.get("Type")
        self._TopicNum = params.get("TopicNum")
        self._GroupNum = params.get("GroupNum")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyConsumerGroupRequest(AbstractModel):
    r"""ModifyConsumerGroup request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        :param _ConsumeEnable: Whether to enable consumption.
        :type ConsumeEnable: bool
        :param _ConsumeMessageOrderly: Specifies whether to use ordered delivery. valid values: true.
Concurrent delivery: false.
        :type ConsumeMessageOrderly: bool
        :param _MaxRetryTimes: Maximum number of retries. Value range: 0 to 1000.
        :type MaxRetryTimes: int
        :param _Remark: Remarks. Up to 128 characters are allowed.
        :type Remark: str
        """
        self._InstanceId = None
        self._ConsumerGroup = None
        self._ConsumeEnable = None
        self._ConsumeMessageOrderly = None
        self._MaxRetryTimes = None
        self._Remark = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def ConsumeEnable(self):
        r"""Whether to enable consumption.
        :rtype: bool
        """
        return self._ConsumeEnable

    @ConsumeEnable.setter
    def ConsumeEnable(self, ConsumeEnable):
        self._ConsumeEnable = ConsumeEnable

    @property
    def ConsumeMessageOrderly(self):
        r"""Specifies whether to use ordered delivery. valid values: true.
Concurrent delivery: false.
        :rtype: bool
        """
        return self._ConsumeMessageOrderly

    @ConsumeMessageOrderly.setter
    def ConsumeMessageOrderly(self, ConsumeMessageOrderly):
        self._ConsumeMessageOrderly = ConsumeMessageOrderly

    @property
    def MaxRetryTimes(self):
        r"""Maximum number of retries. Value range: 0 to 1000.
        :rtype: int
        """
        return self._MaxRetryTimes

    @MaxRetryTimes.setter
    def MaxRetryTimes(self, MaxRetryTimes):
        self._MaxRetryTimes = MaxRetryTimes

    @property
    def Remark(self):
        r"""Remarks. Up to 128 characters are allowed.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._ConsumeEnable = params.get("ConsumeEnable")
        self._ConsumeMessageOrderly = params.get("ConsumeMessageOrderly")
        self._MaxRetryTimes = params.get("MaxRetryTimes")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyConsumerGroupResponse(AbstractModel):
    r"""ModifyConsumerGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceEndpointRequest(AbstractModel):
    r"""ModifyInstanceEndpoint request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Type: Access point type.
PUBLIC network.
        :type Type: str
        :param _Bandwidth: Public network bandwidth, in Mbps
        :type Bandwidth: int
        :param _IpRules: Public network security group information
        :type IpRules: list of IpRule
        :param _BillingFlow: Whether the public network is billed by traffic.
        :type BillingFlow: bool
        """
        self._InstanceId = None
        self._Type = None
        self._Bandwidth = None
        self._IpRules = None
        self._BillingFlow = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Type(self):
        r"""Access point type.
PUBLIC network.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Bandwidth(self):
        r"""Public network bandwidth, in Mbps
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def IpRules(self):
        r"""Public network security group information
        :rtype: list of IpRule
        """
        return self._IpRules

    @IpRules.setter
    def IpRules(self, IpRules):
        self._IpRules = IpRules

    @property
    def BillingFlow(self):
        r"""Whether the public network is billed by traffic.
        :rtype: bool
        """
        return self._BillingFlow

    @BillingFlow.setter
    def BillingFlow(self, BillingFlow):
        self._BillingFlow = BillingFlow


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Type = params.get("Type")
        self._Bandwidth = params.get("Bandwidth")
        if params.get("IpRules") is not None:
            self._IpRules = []
            for item in params.get("IpRules"):
                obj = IpRule()
                obj._deserialize(item)
                self._IpRules.append(obj)
        self._BillingFlow = params.get("BillingFlow")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceEndpointResponse(AbstractModel):
    r"""ModifyInstanceEndpoint response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceRequest(AbstractModel):
    r"""ModifyInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Name: Instance name. It cannot be left blank. It can contain 3 to 64 characters consisting of only digits, letters, hyphens (-), and underscores (_).
        :type Name: str
        :param _Remark: Remarks. Up to 128 characters are allowed.
        :type Remark: str
        :param _SendReceiveRatio: Message sending and receiving ratio
        :type SendReceiveRatio: float
        :param _SkuCode: Product specification. It can be obtained from the output parameters of [ProductSKU](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU) of the API [DescribeProductSKUs](https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).
        :type SkuCode: str
        :param _MessageRetention: Message retention time (unit: hr). value range refers to the ProductSKU response parameters structure in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).

-Default value: DefaultRetention parameter.
-Minimum value: specifies the RetentionLowerLimit parameter.
-Specifies the maximum value of the RetentionUpperLimit parameter.
        :type MessageRetention: int
        :param _ScaledTpsEnabled: Whether to enable elastic TPS.
        :type ScaledTpsEnabled: bool
        :param _AclEnabled: Whether ACL is enabled.
        :type AclEnabled: bool
        :param _MaxTopicNum: The maximum number of topics that can be created. value ranges from...to... refer to the ProductSKU output parameter in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1) (https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU).

-Minimum value and default value: TopicNumLimit parameter.
-Maximum value of TopicNumUpperLimit parameter.
        :type MaxTopicNum: int
        :param _ExtraTopicNum: Number of topics not included in the free quota. For the free quota, see the TopicNumLimit parameter in the output parameters of [ProductSKU](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU) of the API [DescribeProductSKUs](https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).
        :type ExtraTopicNum: str
        :param _EnableDeletionProtection: Whether to enable deletion protection
        :type EnableDeletionProtection: bool
        """
        self._InstanceId = None
        self._Name = None
        self._Remark = None
        self._SendReceiveRatio = None
        self._SkuCode = None
        self._MessageRetention = None
        self._ScaledTpsEnabled = None
        self._AclEnabled = None
        self._MaxTopicNum = None
        self._ExtraTopicNum = None
        self._EnableDeletionProtection = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Name(self):
        r"""Instance name. It cannot be left blank. It can contain 3 to 64 characters consisting of only digits, letters, hyphens (-), and underscores (_).
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Remarks. Up to 128 characters are allowed.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SendReceiveRatio(self):
        r"""Message sending and receiving ratio
        :rtype: float
        """
        return self._SendReceiveRatio

    @SendReceiveRatio.setter
    def SendReceiveRatio(self, SendReceiveRatio):
        self._SendReceiveRatio = SendReceiveRatio

    @property
    def SkuCode(self):
        r"""Product specification. It can be obtained from the output parameters of [ProductSKU](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU) of the API [DescribeProductSKUs](https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).
        :rtype: str
        """
        return self._SkuCode

    @SkuCode.setter
    def SkuCode(self, SkuCode):
        self._SkuCode = SkuCode

    @property
    def MessageRetention(self):
        r"""Message retention time (unit: hr). value range refers to the ProductSKU response parameters structure in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).

-Default value: DefaultRetention parameter.
-Minimum value: specifies the RetentionLowerLimit parameter.
-Specifies the maximum value of the RetentionUpperLimit parameter.
        :rtype: int
        """
        return self._MessageRetention

    @MessageRetention.setter
    def MessageRetention(self, MessageRetention):
        self._MessageRetention = MessageRetention

    @property
    def ScaledTpsEnabled(self):
        r"""Whether to enable elastic TPS.
        :rtype: bool
        """
        return self._ScaledTpsEnabled

    @ScaledTpsEnabled.setter
    def ScaledTpsEnabled(self, ScaledTpsEnabled):
        self._ScaledTpsEnabled = ScaledTpsEnabled

    @property
    def AclEnabled(self):
        r"""Whether ACL is enabled.
        :rtype: bool
        """
        return self._AclEnabled

    @AclEnabled.setter
    def AclEnabled(self, AclEnabled):
        self._AclEnabled = AclEnabled

    @property
    def MaxTopicNum(self):
        r"""The maximum number of topics that can be created. value ranges from...to... refer to the ProductSKU output parameter in the DescribeProductSKUs api (https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1) (https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU).

-Minimum value and default value: TopicNumLimit parameter.
-Maximum value of TopicNumUpperLimit parameter.
        :rtype: int
        """
        return self._MaxTopicNum

    @MaxTopicNum.setter
    def MaxTopicNum(self, MaxTopicNum):
        self._MaxTopicNum = MaxTopicNum

    @property
    def ExtraTopicNum(self):
        r"""Number of topics not included in the free quota. For the free quota, see the TopicNumLimit parameter in the output parameters of [ProductSKU](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ProductSKU) of the API [DescribeProductSKUs](https://www.tencentcloud.comom/document/api/1493/107676?from_cn_redirect=1).
        :rtype: str
        """
        return self._ExtraTopicNum

    @ExtraTopicNum.setter
    def ExtraTopicNum(self, ExtraTopicNum):
        self._ExtraTopicNum = ExtraTopicNum

    @property
    def EnableDeletionProtection(self):
        r"""Whether to enable deletion protection
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        self._SendReceiveRatio = params.get("SendReceiveRatio")
        self._SkuCode = params.get("SkuCode")
        self._MessageRetention = params.get("MessageRetention")
        self._ScaledTpsEnabled = params.get("ScaledTpsEnabled")
        self._AclEnabled = params.get("AclEnabled")
        self._MaxTopicNum = params.get("MaxTopicNum")
        self._ExtraTopicNum = params.get("ExtraTopicNum")
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceResponse(AbstractModel):
    r"""ModifyInstance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRoleRequest(AbstractModel):
    r"""ModifyRole request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Role: Role name. It can be obtained from [RoleItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#RoleItem) returned by the API [DescribeRoleList](https://www.tencentcloud.comom/document/api/1493/98862?from_cn_redirect=1) or from the console.
        :type Role: str
        :param _PermRead: Whether to enable consumption.
        :type PermRead: bool
        :param _PermWrite: Whether to enable production
        :type PermWrite: bool
        :param _PermType: Specifies the types of permissions. the default is to authorize by Cluster (Cluster: at the Cluster level; TopicAndGroup: topic and consumer group dimension).
        :type PermType: str
        :param _Remark: Remarks
        :type Remark: str
        :param _DetailedPerms: Permission configuration in the topic/group dimension. It is required when the permission type parameter is set to TopicAndGroup.
        :type DetailedPerms: list of DetailedRolePerm
        """
        self._InstanceId = None
        self._Role = None
        self._PermRead = None
        self._PermWrite = None
        self._PermType = None
        self._Remark = None
        self._DetailedPerms = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Role(self):
        r"""Role name. It can be obtained from [RoleItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#RoleItem) returned by the API [DescribeRoleList](https://www.tencentcloud.comom/document/api/1493/98862?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Role

    @Role.setter
    def Role(self, Role):
        self._Role = Role

    @property
    def PermRead(self):
        r"""Whether to enable consumption.
        :rtype: bool
        """
        return self._PermRead

    @PermRead.setter
    def PermRead(self, PermRead):
        self._PermRead = PermRead

    @property
    def PermWrite(self):
        r"""Whether to enable production
        :rtype: bool
        """
        return self._PermWrite

    @PermWrite.setter
    def PermWrite(self, PermWrite):
        self._PermWrite = PermWrite

    @property
    def PermType(self):
        r"""Specifies the types of permissions. the default is to authorize by Cluster (Cluster: at the Cluster level; TopicAndGroup: topic and consumer group dimension).
        :rtype: str
        """
        return self._PermType

    @PermType.setter
    def PermType(self, PermType):
        self._PermType = PermType

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def DetailedPerms(self):
        r"""Permission configuration in the topic/group dimension. It is required when the permission type parameter is set to TopicAndGroup.
        :rtype: list of DetailedRolePerm
        """
        return self._DetailedPerms

    @DetailedPerms.setter
    def DetailedPerms(self, DetailedPerms):
        self._DetailedPerms = DetailedPerms


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Role = params.get("Role")
        self._PermRead = params.get("PermRead")
        self._PermWrite = params.get("PermWrite")
        self._PermType = params.get("PermType")
        self._Remark = params.get("Remark")
        if params.get("DetailedPerms") is not None:
            self._DetailedPerms = []
            for item in params.get("DetailedPerms"):
                obj = DetailedRolePerm()
                obj._deserialize(item)
                self._DetailedPerms.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRoleResponse(AbstractModel):
    r"""ModifyRole response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTopicRequest(AbstractModel):
    r"""ModifyTopic request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _QueueNum: Number of queues. Value range: 3 to 16.
        :type QueueNum: int
        :param _Remark: Remarks. Up to 128 characters are allowed.
        :type Remark: str
        :param _MsgTTL: Message retention period (unit: hour).
        :type MsgTTL: int
        """
        self._InstanceId = None
        self._Topic = None
        self._QueueNum = None
        self._Remark = None
        self._MsgTTL = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def QueueNum(self):
        r"""Number of queues. Value range: 3 to 16.
        :rtype: int
        """
        return self._QueueNum

    @QueueNum.setter
    def QueueNum(self, QueueNum):
        self._QueueNum = QueueNum

    @property
    def Remark(self):
        r"""Remarks. Up to 128 characters are allowed.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MsgTTL(self):
        r"""Message retention period (unit: hour).
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._QueueNum = params.get("QueueNum")
        self._Remark = params.get("Remark")
        self._MsgTTL = params.get("MsgTTL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTopicResponse(AbstractModel):
    r"""ModifyTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class PriceTag(AbstractModel):
    r"""Price tag information. A complete price tag includes the billing category and the billing item.

    """

    def __init__(self):
        r"""
        :param _Name: Price name. Enumeration values: tps: basic price of TPS; stepTps: TPS step size.
        :type Name: str
        :param _Step: Step size corresponding to the billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Step: int
        """
        self._Name = None
        self._Step = None

    @property
    def Name(self):
        r"""Price name. Enumeration values: tps: basic price of TPS; stepTps: TPS step size.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Step(self):
        r"""Step size corresponding to the billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Step

    @Step.setter
    def Step(self, Step):
        self._Step = Step


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Step = params.get("Step")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProducerInfo(AbstractModel):
    r"""Producer information.

    """

    def __init__(self):
        r"""
        :param _ClientId: Client ID	
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientId: str
        :param _ClientIp: Client IP.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientIp: str
        :param _Language: Client language. 
- JAVA((byte) 0)
- CPP((byte) 1) 
- DOTNET((byte) 2) 
- PYTHON((byte) 3)
- DELPHI((byte) 4)
- ERLANG((byte) 5)
- RUBY((byte) 6)
- OTHER((byte) 7)
- HTTP((byte) 8)
- GO((byte) 9)
- PHP((byte) 10)
- OMS((byte) 11)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Language: str
        :param _Version: Client version.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: str
        :param _LastUpdateTimestamp: Last production time, **Unix timestamp (seconds)**.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastUpdateTimestamp: int
        :param _ChannelProtocol: Producer client protocol type. valid values: the following.

-Specifies the grpc protocol.
-remoting protocol.
-http protocol.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ChannelProtocol: str
        """
        self._ClientId = None
        self._ClientIp = None
        self._Language = None
        self._Version = None
        self._LastUpdateTimestamp = None
        self._ChannelProtocol = None

    @property
    def ClientId(self):
        r"""Client ID	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientId

    @ClientId.setter
    def ClientId(self, ClientId):
        self._ClientId = ClientId

    @property
    def ClientIp(self):
        r"""Client IP.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def Language(self):
        r"""Client language. 
- JAVA((byte) 0)
- CPP((byte) 1) 
- DOTNET((byte) 2) 
- PYTHON((byte) 3)
- DELPHI((byte) 4)
- ERLANG((byte) 5)
- RUBY((byte) 6)
- OTHER((byte) 7)
- HTTP((byte) 8)
- GO((byte) 9)
- PHP((byte) 10)
- OMS((byte) 11)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Version(self):
        r"""Client version.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def LastUpdateTimestamp(self):
        r"""Last production time, **Unix timestamp (seconds)**.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._LastUpdateTimestamp

    @LastUpdateTimestamp.setter
    def LastUpdateTimestamp(self, LastUpdateTimestamp):
        self._LastUpdateTimestamp = LastUpdateTimestamp

    @property
    def ChannelProtocol(self):
        r"""Producer client protocol type. valid values: the following.

-Specifies the grpc protocol.
-remoting protocol.
-http protocol.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChannelProtocol

    @ChannelProtocol.setter
    def ChannelProtocol(self, ChannelProtocol):
        self._ChannelProtocol = ChannelProtocol


    def _deserialize(self, params):
        self._ClientId = params.get("ClientId")
        self._ClientIp = params.get("ClientIp")
        self._Language = params.get("Language")
        self._Version = params.get("Version")
        self._LastUpdateTimestamp = params.get("LastUpdateTimestamp")
        self._ChannelProtocol = params.get("ChannelProtocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProductSKU(AbstractModel):
    r"""Product sales information

    """

    def __init__(self):
        r"""
        :param _InstanceType: Specifies the product type.
Trial version.
BASIC version.
PRO, professional edition.
PLATINUM edition.
        :type InstanceType: str
        :param _SkuCode: Specification code
        :type SkuCode: str
        :param _TpsLimit: TPS limit
        :type TpsLimit: int
        :param _ScaledTpsLimit: Elastic TPS upper limit
        :type ScaledTpsLimit: int
        :param _TopicNumLimit: Default maximum number of topics.
        :type TopicNumLimit: int
        :param _GroupNumLimit: Maximum number of consumer groups
        :type GroupNumLimit: int
        :param _DefaultRetention: Default message retention time, in hours
        :type DefaultRetention: int
        :param _RetentionUpperLimit: Adjustable maximum message retention time, in hours
        :type RetentionUpperLimit: int
        :param _RetentionLowerLimit: Adjustable minimum message retention time, in hours
        :type RetentionLowerLimit: int
        :param _MaxMessageDelay: Maximum delayed message duration, in hours
        :type MaxMessageDelay: int
        :param _OnSale: Whether it is purchasable
        :type OnSale: bool
        :param _PriceTags: Billing item information
        :type PriceTags: list of PriceTag
        :param _TopicNumUpperLimit: Default maximum number of topics.
        :type TopicNumUpperLimit: int
        """
        self._InstanceType = None
        self._SkuCode = None
        self._TpsLimit = None
        self._ScaledTpsLimit = None
        self._TopicNumLimit = None
        self._GroupNumLimit = None
        self._DefaultRetention = None
        self._RetentionUpperLimit = None
        self._RetentionLowerLimit = None
        self._MaxMessageDelay = None
        self._OnSale = None
        self._PriceTags = None
        self._TopicNumUpperLimit = None

    @property
    def InstanceType(self):
        r"""Specifies the product type.
Trial version.
BASIC version.
PRO, professional edition.
PLATINUM edition.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def SkuCode(self):
        r"""Specification code
        :rtype: str
        """
        return self._SkuCode

    @SkuCode.setter
    def SkuCode(self, SkuCode):
        self._SkuCode = SkuCode

    @property
    def TpsLimit(self):
        r"""TPS limit
        :rtype: int
        """
        return self._TpsLimit

    @TpsLimit.setter
    def TpsLimit(self, TpsLimit):
        self._TpsLimit = TpsLimit

    @property
    def ScaledTpsLimit(self):
        r"""Elastic TPS upper limit
        :rtype: int
        """
        return self._ScaledTpsLimit

    @ScaledTpsLimit.setter
    def ScaledTpsLimit(self, ScaledTpsLimit):
        self._ScaledTpsLimit = ScaledTpsLimit

    @property
    def TopicNumLimit(self):
        r"""Default maximum number of topics.
        :rtype: int
        """
        return self._TopicNumLimit

    @TopicNumLimit.setter
    def TopicNumLimit(self, TopicNumLimit):
        self._TopicNumLimit = TopicNumLimit

    @property
    def GroupNumLimit(self):
        r"""Maximum number of consumer groups
        :rtype: int
        """
        return self._GroupNumLimit

    @GroupNumLimit.setter
    def GroupNumLimit(self, GroupNumLimit):
        self._GroupNumLimit = GroupNumLimit

    @property
    def DefaultRetention(self):
        r"""Default message retention time, in hours
        :rtype: int
        """
        return self._DefaultRetention

    @DefaultRetention.setter
    def DefaultRetention(self, DefaultRetention):
        self._DefaultRetention = DefaultRetention

    @property
    def RetentionUpperLimit(self):
        r"""Adjustable maximum message retention time, in hours
        :rtype: int
        """
        return self._RetentionUpperLimit

    @RetentionUpperLimit.setter
    def RetentionUpperLimit(self, RetentionUpperLimit):
        self._RetentionUpperLimit = RetentionUpperLimit

    @property
    def RetentionLowerLimit(self):
        r"""Adjustable minimum message retention time, in hours
        :rtype: int
        """
        return self._RetentionLowerLimit

    @RetentionLowerLimit.setter
    def RetentionLowerLimit(self, RetentionLowerLimit):
        self._RetentionLowerLimit = RetentionLowerLimit

    @property
    def MaxMessageDelay(self):
        r"""Maximum delayed message duration, in hours
        :rtype: int
        """
        return self._MaxMessageDelay

    @MaxMessageDelay.setter
    def MaxMessageDelay(self, MaxMessageDelay):
        self._MaxMessageDelay = MaxMessageDelay

    @property
    def OnSale(self):
        r"""Whether it is purchasable
        :rtype: bool
        """
        return self._OnSale

    @OnSale.setter
    def OnSale(self, OnSale):
        self._OnSale = OnSale

    @property
    def PriceTags(self):
        r"""Billing item information
        :rtype: list of PriceTag
        """
        return self._PriceTags

    @PriceTags.setter
    def PriceTags(self, PriceTags):
        self._PriceTags = PriceTags

    @property
    def TopicNumUpperLimit(self):
        r"""Default maximum number of topics.
        :rtype: int
        """
        return self._TopicNumUpperLimit

    @TopicNumUpperLimit.setter
    def TopicNumUpperLimit(self, TopicNumUpperLimit):
        self._TopicNumUpperLimit = TopicNumUpperLimit


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._SkuCode = params.get("SkuCode")
        self._TpsLimit = params.get("TpsLimit")
        self._ScaledTpsLimit = params.get("ScaledTpsLimit")
        self._TopicNumLimit = params.get("TopicNumLimit")
        self._GroupNumLimit = params.get("GroupNumLimit")
        self._DefaultRetention = params.get("DefaultRetention")
        self._RetentionUpperLimit = params.get("RetentionUpperLimit")
        self._RetentionLowerLimit = params.get("RetentionLowerLimit")
        self._MaxMessageDelay = params.get("MaxMessageDelay")
        self._OnSale = params.get("OnSale")
        if params.get("PriceTags") is not None:
            self._PriceTags = []
            for item in params.get("PriceTags"):
                obj = PriceTag()
                obj._deserialize(item)
                self._PriceTags.append(obj)
        self._TopicNumUpperLimit = params.get("TopicNumUpperLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveMigratingTopicRequest(AbstractModel):
    r"""RemoveMigratingTopic request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.
        :type TaskId: str
        :param _TopicName: Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :type TopicName: str
        :param _Namespace: Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :type Namespace: str
        """
        self._TaskId = None
        self._TopicName = None
        self._Namespace = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TopicName(self):
        r"""Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Namespace(self):
        r"""Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TopicName = params.get("TopicName")
        self._Namespace = params.get("Namespace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveMigratingTopicResponse(AbstractModel):
    r"""RemoveMigratingTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResendDeadLetterMessageRequest(AbstractModel):
    r"""ResendDeadLetterMessage request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _MessageIds: List of dead letter message ids.
        :type MessageIds: list of str
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        """
        self._InstanceId = None
        self._MessageIds = None
        self._ConsumerGroup = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def MessageIds(self):
        r"""List of dead letter message ids.
        :rtype: list of str
        """
        return self._MessageIds

    @MessageIds.setter
    def MessageIds(self, MessageIds):
        self._MessageIds = MessageIds

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._MessageIds = params.get("MessageIds")
        self._ConsumerGroup = params.get("ConsumerGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResendDeadLetterMessageResponse(AbstractModel):
    r"""ResendDeadLetterMessage response structure.

    """

    def __init__(self):
        r"""
        :param _ResendResult: Specifies the result of resending a message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResendResult: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ResendResult = None
        self._RequestId = None

    @property
    def ResendResult(self):
        r"""Specifies the result of resending a message.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._ResendResult

    @ResendResult.setter
    def ResendResult(self, ResendResult):
        self._ResendResult = ResendResult

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResendResult = params.get("ResendResult")
        self._RequestId = params.get("RequestId")


class ResetConsumerGroupOffsetRequest(AbstractModel):
    r"""ResetConsumerGroupOffset request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :type InstanceId: str
        :param _Topic: Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :type Topic: str
        :param _ResetTimestamp: Timestamp (unit: millisecond) for resetting the offset. The value -1 indicates resetting to the latest offset.
        :type ResetTimestamp: int
        :param _ConsumerGroup: Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :type ConsumerGroup: str
        """
        self._InstanceId = None
        self._Topic = None
        self._ResetTimestamp = None
        self._ConsumerGroup = None

    @property
    def InstanceId(self):
        r"""TDMQ RocketMQ instance ID. It can be obtained from the API [DescribeFusionInstanceList](https://www.tencentcloud.comom/document/api/1493/106745?from_cn_redirect=1) or the console.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name. It can be obtained from [TopicItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#TopicItem) returned by the API [DescribeTopicList](https://www.tencentcloud.comom/document/api/1493/96030?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def ResetTimestamp(self):
        r"""Timestamp (unit: millisecond) for resetting the offset. The value -1 indicates resetting to the latest offset.
        :rtype: int
        """
        return self._ResetTimestamp

    @ResetTimestamp.setter
    def ResetTimestamp(self, ResetTimestamp):
        self._ResetTimestamp = ResetTimestamp

    @property
    def ConsumerGroup(self):
        r"""Consumer group name. It can be obtained from [ConsumeGroupItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#ConsumeGroupItem) returned by the API [DescribeConsumerGroupList](https://www.tencentcloud.comom/document/api/1493/101535?from_cn_redirect=1) or from the console.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._ResetTimestamp = params.get("ResetTimestamp")
        self._ConsumerGroup = params.get("ConsumerGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetConsumerGroupOffsetResponse(AbstractModel):
    r"""ResetConsumerGroupOffset response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RoleItem(AbstractModel):
    r"""Role information.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name.
        :type RoleName: str
        :param _PermRead: Whether to enable consumption.
        :type PermRead: bool
        :param _PermWrite: Whether to enable production
        :type PermWrite: bool
        :param _AccessKey: Access Key
        :type AccessKey: str
        :param _SecretKey: Secret Key
        :type SecretKey: str
        :param _Remark: Remarks
        :type Remark: str
        :param _CreatedTime: Role creation time. **It is a Unix timestamp (ms).**
        :type CreatedTime: int
        :param _ModifiedTime: Role update time. **It is a Unix timestamp (ms).**
        :type ModifiedTime: int
        :param _PermType: Specifies the types of permissions. the default is to authorize by Cluster (Cluster: at the Cluster level; TopicAndGroup: topic and consumer group level).
        :type PermType: str
        :param _DetailedRolePerms: Permission configuration in Topic and Group dimension.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetailedRolePerms: list of DetailedRolePerm
        """
        self._RoleName = None
        self._PermRead = None
        self._PermWrite = None
        self._AccessKey = None
        self._SecretKey = None
        self._Remark = None
        self._CreatedTime = None
        self._ModifiedTime = None
        self._PermType = None
        self._DetailedRolePerms = None

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def PermRead(self):
        r"""Whether to enable consumption.
        :rtype: bool
        """
        return self._PermRead

    @PermRead.setter
    def PermRead(self, PermRead):
        self._PermRead = PermRead

    @property
    def PermWrite(self):
        r"""Whether to enable production
        :rtype: bool
        """
        return self._PermWrite

    @PermWrite.setter
    def PermWrite(self, PermWrite):
        self._PermWrite = PermWrite

    @property
    def AccessKey(self):
        r"""Access Key
        :rtype: str
        """
        return self._AccessKey

    @AccessKey.setter
    def AccessKey(self, AccessKey):
        self._AccessKey = AccessKey

    @property
    def SecretKey(self):
        r"""Secret Key
        :rtype: str
        """
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreatedTime(self):
        r"""Role creation time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ModifiedTime(self):
        r"""Role update time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def PermType(self):
        r"""Specifies the types of permissions. the default is to authorize by Cluster (Cluster: at the Cluster level; TopicAndGroup: topic and consumer group level).
        :rtype: str
        """
        return self._PermType

    @PermType.setter
    def PermType(self, PermType):
        self._PermType = PermType

    @property
    def DetailedRolePerms(self):
        r"""Permission configuration in Topic and Group dimension.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DetailedRolePerm
        """
        return self._DetailedRolePerms

    @DetailedRolePerms.setter
    def DetailedRolePerms(self, DetailedRolePerms):
        self._DetailedRolePerms = DetailedRolePerms


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._PermRead = params.get("PermRead")
        self._PermWrite = params.get("PermWrite")
        self._AccessKey = params.get("AccessKey")
        self._SecretKey = params.get("SecretKey")
        self._Remark = params.get("Remark")
        self._CreatedTime = params.get("CreatedTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._PermType = params.get("PermType")
        if params.get("DetailedRolePerms") is not None:
            self._DetailedRolePerms = []
            for item in params.get("DetailedRolePerms"):
                obj = DetailedRolePerm()
                obj._deserialize(item)
                self._DetailedRolePerms.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackMigratingTopicStageRequest(AbstractModel):
    r"""RollbackMigratingTopicStage request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :type TaskId: str
        :param _TopicName: Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :type TopicName: str
        :param _Namespace: Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :type Namespace: str
        """
        self._TaskId = None
        self._TopicName = None
        self._Namespace = None

    @property
    def TaskId(self):
        r"""Task ID. It can be obtained from [SmoothMigrationTaskItem](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SmoothMigrationTaskItem) returned by the API [DescribeSmoothMigrationTaskList](https://www.tencentcloud.comom/document/api/1493/119997?from_cn_redirect=1) or from the console.

        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TopicName(self):
        r"""Topic name. It can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.

        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Namespace(self):
        r"""Namespace. This parameter is valid only for migration to a 4.x cluster. The namespace can be obtained from [MigratingTopic](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#MigratingTopic) returned by the API [DescribeMigratingTopicList](https://www.tencentcloud.comom/document/api/1493/118007?from_cn_redirect=1) in Data Type.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TopicName = params.get("TopicName")
        self._Namespace = params.get("Namespace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackMigratingTopicStageResponse(AbstractModel):
    r"""RollbackMigratingTopicStage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SmoothMigrationTaskItem(AbstractModel):
    r"""Hitless migration task.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _TaskName: Task name.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskName: str
        :param _SourceClusterName: Source cluster name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceClusterName: str
        :param _InstanceId: Destination cluster instance ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _ConnectionType: Specifies the network connection type. 
PUBLIC network. 
Specifies the VPC virtual private cloud. 
OTHER.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConnectionType: str
        :param _SourceNameServer: Source cluster NameServer address.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceNameServer: str
        :param _TaskStatus: Task status.
Migration Configuration. specifies the migration Configuration.
SourceConnecting specifies connecting to source cluster.
MetaDataImport specifies metadata import.
EndpointSetup specifies the access point switchover.
Service migration is in progress.
Completed.
Cancelled: canceled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskStatus: str
        :param _InstanceVersion: Specifies the target cluster instance version.
4 indicates version 4.x.
5 indicates version 5.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceVersion: str
        """
        self._TaskId = None
        self._TaskName = None
        self._SourceClusterName = None
        self._InstanceId = None
        self._ConnectionType = None
        self._SourceNameServer = None
        self._TaskStatus = None
        self._InstanceVersion = None

    @property
    def TaskId(self):
        r"""Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        r"""Task name.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def SourceClusterName(self):
        r"""Source cluster name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SourceClusterName

    @SourceClusterName.setter
    def SourceClusterName(self, SourceClusterName):
        self._SourceClusterName = SourceClusterName

    @property
    def InstanceId(self):
        r"""Destination cluster instance ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ConnectionType(self):
        r"""Specifies the network connection type. 
PUBLIC network. 
Specifies the VPC virtual private cloud. 
OTHER.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def SourceNameServer(self):
        r"""Source cluster NameServer address.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SourceNameServer

    @SourceNameServer.setter
    def SourceNameServer(self, SourceNameServer):
        self._SourceNameServer = SourceNameServer

    @property
    def TaskStatus(self):
        r"""Task status.
Migration Configuration. specifies the migration Configuration.
SourceConnecting specifies connecting to source cluster.
MetaDataImport specifies metadata import.
EndpointSetup specifies the access point switchover.
Service migration is in progress.
Completed.
Cancelled: canceled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def InstanceVersion(self):
        r"""Specifies the target cluster instance version.
4 indicates version 4.x.
5 indicates version 5.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._SourceClusterName = params.get("SourceClusterName")
        self._InstanceId = params.get("InstanceId")
        self._ConnectionType = params.get("ConnectionType")
        self._SourceNameServer = params.get("SourceNameServer")
        self._TaskStatus = params.get("TaskStatus")
        self._InstanceVersion = params.get("InstanceVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SourceClusterGroupConfig(AbstractModel):
    r"""Specifies the consumer group configuration information.

    """

    def __init__(self):
        r"""
        :param _GroupName: Consumer group name. It can be obtained from [SourceClusterGroupConfig](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SourceClusterGroupConfig) returned by the API [DescribeSourceClusterGroupList](https://www.tencentcloud.comom/document/api/1493/118006?from_cn_redirect=1).
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupName: str
        :param _Remark: Remarks

Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _Imported: Specifies whether it has been imported. it is unavailable when used as an input parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Imported: bool
        :param _Namespace: Namespace, valid for 4.x clusters only.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param _ImportStatus: Import status.
Unknown. specifies an unknown status.
Success.
Failure.
AlreadyExists. specifies the resource already exists.

Used as an output parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImportStatus: str
        :param _NamespaceV4: Namespace of 4.x. output usage.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NamespaceV4: str
        :param _GroupNameV4: Consumer group name for version 4.x. output usage.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupNameV4: str
        :param _FullNamespaceV4: Complete namespace for version 4.x. output usage.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FullNamespaceV4: str
        :param _ConsumeMessageOrderly: Specifies whether it is ordered delivery. valid value: 5.0.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumeMessageOrderly: bool
        """
        self._GroupName = None
        self._Remark = None
        self._Imported = None
        self._Namespace = None
        self._ImportStatus = None
        self._NamespaceV4 = None
        self._GroupNameV4 = None
        self._FullNamespaceV4 = None
        self._ConsumeMessageOrderly = None

    @property
    def GroupName(self):
        r"""Consumer group name. It can be obtained from [SourceClusterGroupConfig](https://www.tencentcloud.comom/document/api/1493/96031?from_cn_redirect=1#SourceClusterGroupConfig) returned by the API [DescribeSourceClusterGroupList](https://www.tencentcloud.comom/document/api/1493/118006?from_cn_redirect=1).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Remark(self):
        r"""Remarks

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Imported(self):
        r"""Specifies whether it has been imported. it is unavailable when used as an input parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Imported

    @Imported.setter
    def Imported(self, Imported):
        self._Imported = Imported

    @property
    def Namespace(self):
        r"""Namespace, valid for 4.x clusters only.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ImportStatus(self):
        r"""Import status.
Unknown. specifies an unknown status.
Success.
Failure.
AlreadyExists. specifies the resource already exists.

Used as an output parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ImportStatus

    @ImportStatus.setter
    def ImportStatus(self, ImportStatus):
        self._ImportStatus = ImportStatus

    @property
    def NamespaceV4(self):
        r"""Namespace of 4.x. output usage.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NamespaceV4

    @NamespaceV4.setter
    def NamespaceV4(self, NamespaceV4):
        self._NamespaceV4 = NamespaceV4

    @property
    def GroupNameV4(self):
        r"""Consumer group name for version 4.x. output usage.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._GroupNameV4

    @GroupNameV4.setter
    def GroupNameV4(self, GroupNameV4):
        self._GroupNameV4 = GroupNameV4

    @property
    def FullNamespaceV4(self):
        r"""Complete namespace for version 4.x. output usage.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FullNamespaceV4

    @FullNamespaceV4.setter
    def FullNamespaceV4(self, FullNamespaceV4):
        self._FullNamespaceV4 = FullNamespaceV4

    @property
    def ConsumeMessageOrderly(self):
        r"""Specifies whether it is ordered delivery. valid value: 5.0.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._ConsumeMessageOrderly

    @ConsumeMessageOrderly.setter
    def ConsumeMessageOrderly(self, ConsumeMessageOrderly):
        self._ConsumeMessageOrderly = ConsumeMessageOrderly


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Remark = params.get("Remark")
        self._Imported = params.get("Imported")
        self._Namespace = params.get("Namespace")
        self._ImportStatus = params.get("ImportStatus")
        self._NamespaceV4 = params.get("NamespaceV4")
        self._GroupNameV4 = params.get("GroupNameV4")
        self._FullNamespaceV4 = params.get("FullNamespaceV4")
        self._ConsumeMessageOrderly = params.get("ConsumeMessageOrderly")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubscriptionData(AbstractModel):
    r"""Topic and consumer group subscription relationship data

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _Topic: Topic name

Note: This field may return null, indicating that no valid values can be obtained.
        :type Topic: str
        :param _TopicType: Topic type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicType: str
        :param _TopicQueueNum: Number of topic queues on a single node

Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicQueueNum: int
        :param _ConsumerGroup: Specifies the consumer group name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerGroup: str
        :param _IsOnline: Online status

Note: This field may return null, indicating that no valid values can be obtained.
        :type IsOnline: bool
        :param _ConsumeType: Consumption type. valid values as follows:.

-PULL: specifies the pull consumption type.
-PUSH: specifies the push consumption type.
-POP: specifies the pop consumption type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumeType: str
        :param _SubString: Subscription rule.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubString: str
        :param _ExpressionType: Filter type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpressionType: str
        :param _Consistency: Subscription consistency. enumerated as follows:.

-Subscription consistency.
-Subscription inconsistency.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Consistency: int
        :param _ConsumerLag: Consumption heap

Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerLag: int
        :param _LastUpdateTime: Last consumption progress update time. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastUpdateTime: int
        :param _MaxRetryTimes: Maximum number of retries.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxRetryTimes: int
        :param _ConsumeMessageOrderly: Whether it is sequential consumption

Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumeMessageOrderly: bool
        :param _MessageModel: Specifies the consumption mode. 
BROADCASTING mode.
CLUSTERING: cluster mode.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MessageModel: str
        :param _ClientSubscriptionInfos: List of clients with inconsistent subscriptions.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientSubscriptionInfos: list of ClientSubscriptionInfo
        """
        self._InstanceId = None
        self._Topic = None
        self._TopicType = None
        self._TopicQueueNum = None
        self._ConsumerGroup = None
        self._IsOnline = None
        self._ConsumeType = None
        self._SubString = None
        self._ExpressionType = None
        self._Consistency = None
        self._ConsumerLag = None
        self._LastUpdateTime = None
        self._MaxRetryTimes = None
        self._ConsumeMessageOrderly = None
        self._MessageModel = None
        self._ClientSubscriptionInfos = None

    @property
    def InstanceId(self):
        r"""Instance ID

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def TopicType(self):
        r"""Topic type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def TopicQueueNum(self):
        r"""Number of topic queues on a single node

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicQueueNum

    @TopicQueueNum.setter
    def TopicQueueNum(self, TopicQueueNum):
        self._TopicQueueNum = TopicQueueNum

    @property
    def ConsumerGroup(self):
        r"""Specifies the consumer group name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def IsOnline(self):
        r"""Online status

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsOnline

    @IsOnline.setter
    def IsOnline(self, IsOnline):
        self._IsOnline = IsOnline

    @property
    def ConsumeType(self):
        r"""Consumption type. valid values as follows:.

-PULL: specifies the pull consumption type.
-PUSH: specifies the push consumption type.
-POP: specifies the pop consumption type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsumeType

    @ConsumeType.setter
    def ConsumeType(self, ConsumeType):
        self._ConsumeType = ConsumeType

    @property
    def SubString(self):
        r"""Subscription rule.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubString

    @SubString.setter
    def SubString(self, SubString):
        self._SubString = SubString

    @property
    def ExpressionType(self):
        r"""Filter type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpressionType

    @ExpressionType.setter
    def ExpressionType(self, ExpressionType):
        self._ExpressionType = ExpressionType

    @property
    def Consistency(self):
        r"""Subscription consistency. enumerated as follows:.

-Subscription consistency.
-Subscription inconsistency.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Consistency

    @Consistency.setter
    def Consistency(self, Consistency):
        self._Consistency = Consistency

    @property
    def ConsumerLag(self):
        r"""Consumption heap

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ConsumerLag

    @ConsumerLag.setter
    def ConsumerLag(self, ConsumerLag):
        self._ConsumerLag = ConsumerLag

    @property
    def LastUpdateTime(self):
        r"""Last consumption progress update time. **It is a Unix timestamp (ms).**
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime

    @property
    def MaxRetryTimes(self):
        r"""Maximum number of retries.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxRetryTimes

    @MaxRetryTimes.setter
    def MaxRetryTimes(self, MaxRetryTimes):
        self._MaxRetryTimes = MaxRetryTimes

    @property
    def ConsumeMessageOrderly(self):
        r"""Whether it is sequential consumption

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._ConsumeMessageOrderly

    @ConsumeMessageOrderly.setter
    def ConsumeMessageOrderly(self, ConsumeMessageOrderly):
        self._ConsumeMessageOrderly = ConsumeMessageOrderly

    @property
    def MessageModel(self):
        r"""Specifies the consumption mode. 
BROADCASTING mode.
CLUSTERING: cluster mode.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MessageModel

    @MessageModel.setter
    def MessageModel(self, MessageModel):
        self._MessageModel = MessageModel

    @property
    def ClientSubscriptionInfos(self):
        r"""List of clients with inconsistent subscriptions.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ClientSubscriptionInfo
        """
        return self._ClientSubscriptionInfos

    @ClientSubscriptionInfos.setter
    def ClientSubscriptionInfos(self, ClientSubscriptionInfos):
        self._ClientSubscriptionInfos = ClientSubscriptionInfos


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._TopicType = params.get("TopicType")
        self._TopicQueueNum = params.get("TopicQueueNum")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._IsOnline = params.get("IsOnline")
        self._ConsumeType = params.get("ConsumeType")
        self._SubString = params.get("SubString")
        self._ExpressionType = params.get("ExpressionType")
        self._Consistency = params.get("Consistency")
        self._ConsumerLag = params.get("ConsumerLag")
        self._LastUpdateTime = params.get("LastUpdateTime")
        self._MaxRetryTimes = params.get("MaxRetryTimes")
        self._ConsumeMessageOrderly = params.get("ConsumeMessageOrderly")
        self._MessageModel = params.get("MessageModel")
        if params.get("ClientSubscriptionInfos") is not None:
            self._ClientSubscriptionInfos = []
            for item in params.get("ClientSubscriptionInfos"):
                obj = ClientSubscriptionInfo()
                obj._deserialize(item)
                self._ClientSubscriptionInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Tag(AbstractModel):
    r"""Tag data

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TagKey: str
        :param _TagValue: Tag value

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        r"""Tag name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        r"""Tag value

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TagFilter(AbstractModel):
    r"""Tag filter

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag key name
        :type TagKey: str
        :param _TagValues: Tag value list
        :type TagValues: list of str
        """
        self._TagKey = None
        self._TagValues = None

    @property
    def TagKey(self):
        r"""Tag key name
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValues(self):
        r"""Tag value list
        :rtype: list of str
        """
        return self._TagValues

    @TagValues.setter
    def TagValues(self, TagValues):
        self._TagValues = TagValues


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValues = params.get("TagValues")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TopicConsumeStats(AbstractModel):
    r"""Topic consumption progress

    """

    def __init__(self):
        r"""
        :param _Topic: Topic name
        :type Topic: str
        :param _TopicType: Topic type. valid values are as follows:.

-UNSPECIFIED: unspecified.
-NORMAL: standard message.
-FIFO: specifies sequential messaging.
-DELAY: specifies the delayed message.
-Specifies the TRANSACTION message.
        :type TopicType: str
        :param _QueueNum: Number of topic queues per node
        :type QueueNum: int
        :param _ConsumerLag: Consumption heap
        :type ConsumerLag: int
        :param _SubString: Subscription rule. `*` indicates subscription to all topics.
        :type SubString: str
        :param _LastUpdateTime: Last consumption progress update time. **It is a Unix timestamp (ms).**
        :type LastUpdateTime: int
        """
        self._Topic = None
        self._TopicType = None
        self._QueueNum = None
        self._ConsumerLag = None
        self._SubString = None
        self._LastUpdateTime = None

    @property
    def Topic(self):
        r"""Topic name
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def TopicType(self):
        r"""Topic type. valid values are as follows:.

-UNSPECIFIED: unspecified.
-NORMAL: standard message.
-FIFO: specifies sequential messaging.
-DELAY: specifies the delayed message.
-Specifies the TRANSACTION message.
        :rtype: str
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def QueueNum(self):
        r"""Number of topic queues per node
        :rtype: int
        """
        return self._QueueNum

    @QueueNum.setter
    def QueueNum(self, QueueNum):
        self._QueueNum = QueueNum

    @property
    def ConsumerLag(self):
        r"""Consumption heap
        :rtype: int
        """
        return self._ConsumerLag

    @ConsumerLag.setter
    def ConsumerLag(self, ConsumerLag):
        self._ConsumerLag = ConsumerLag

    @property
    def SubString(self):
        r"""Subscription rule. `*` indicates subscription to all topics.
        :rtype: str
        """
        return self._SubString

    @SubString.setter
    def SubString(self, SubString):
        self._SubString = SubString

    @property
    def LastUpdateTime(self):
        r"""Last consumption progress update time. **It is a Unix timestamp (ms).**
        :rtype: int
        """
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime


    def _deserialize(self, params):
        self._Topic = params.get("Topic")
        self._TopicType = params.get("TopicType")
        self._QueueNum = params.get("QueueNum")
        self._ConsumerLag = params.get("ConsumerLag")
        self._SubString = params.get("SubString")
        self._LastUpdateTime = params.get("LastUpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TopicItem(AbstractModel):
    r"""Topic information on the list

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Topic: Topic name
        :type Topic: str
        :param _TopicType: Topic type.
NORMAL: regular message.
FIFO: sequential messaging.
DELAY: delayed message.
TRANSACTION message.
        :type TopicType: str
        :param _QueueNum: Number of queues
        :type QueueNum: int
        :param _Remark: Remarks
        :type Remark: str
        :param _ClusterIdV4: Cluster id of version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterIdV4: str
        :param _NamespaceV4: Namespace of 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NamespaceV4: str
        :param _TopicV4: Topic name for version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicV4: str
        :param _FullNamespaceV4: Complete namespace for 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FullNamespaceV4: str
        :param _MsgTTL: Message retention time.
        :type MsgTTL: int
        :param _TagList: List of bound tags
        :type TagList: list of Tag
        """
        self._InstanceId = None
        self._Topic = None
        self._TopicType = None
        self._QueueNum = None
        self._Remark = None
        self._ClusterIdV4 = None
        self._NamespaceV4 = None
        self._TopicV4 = None
        self._FullNamespaceV4 = None
        self._MsgTTL = None
        self._TagList = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Topic(self):
        r"""Topic name
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def TopicType(self):
        r"""Topic type.
NORMAL: regular message.
FIFO: sequential messaging.
DELAY: delayed message.
TRANSACTION message.
        :rtype: str
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def QueueNum(self):
        r"""Number of queues
        :rtype: int
        """
        return self._QueueNum

    @QueueNum.setter
    def QueueNum(self, QueueNum):
        self._QueueNum = QueueNum

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ClusterIdV4(self):
        r"""Cluster id of version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClusterIdV4

    @ClusterIdV4.setter
    def ClusterIdV4(self, ClusterIdV4):
        self._ClusterIdV4 = ClusterIdV4

    @property
    def NamespaceV4(self):
        r"""Namespace of 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NamespaceV4

    @NamespaceV4.setter
    def NamespaceV4(self, NamespaceV4):
        self._NamespaceV4 = NamespaceV4

    @property
    def TopicV4(self):
        r"""Topic name for version 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TopicV4

    @TopicV4.setter
    def TopicV4(self, TopicV4):
        self._TopicV4 = TopicV4

    @property
    def FullNamespaceV4(self):
        r"""Complete namespace for 4.x.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FullNamespaceV4

    @FullNamespaceV4.setter
    def FullNamespaceV4(self, FullNamespaceV4):
        self._FullNamespaceV4 = FullNamespaceV4

    @property
    def MsgTTL(self):
        r"""Message retention time.
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def TagList(self):
        r"""List of bound tags
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Topic = params.get("Topic")
        self._TopicType = params.get("TopicType")
        self._QueueNum = params.get("QueueNum")
        self._Remark = params.get("Remark")
        self._ClusterIdV4 = params.get("ClusterIdV4")
        self._NamespaceV4 = params.get("NamespaceV4")
        self._TopicV4 = params.get("TopicV4")
        self._FullNamespaceV4 = params.get("FullNamespaceV4")
        self._MsgTTL = params.get("MsgTTL")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TopicStageChangeResult(AbstractModel):
    r"""Result after modifying the status of the migration topic.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name
        :type TopicName: str
        :param _Success: Success status
        :type Success: bool
        :param _Namespace: Namespace. valid only for 4.x.
        :type Namespace: str
        """
        self._TopicName = None
        self._Success = None
        self._Namespace = None

    @property
    def TopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Success(self):
        r"""Success status
        :rtype: bool
        """
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Namespace(self):
        r"""Namespace. valid only for 4.x.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._Success = params.get("Success")
        self._Namespace = params.get("Namespace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcInfo(AbstractModel):
    r"""VPC information.

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _SubnetId: Subnet ID.
        :type SubnetId: str
        """
        self._VpcId = None
        self._SubnetId = None

    @property
    def VpcId(self):
        r"""VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ZoneScheduledItem(AbstractModel):
    r"""Whether there are scheduling tasks in each AZ during proxy scheduling.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Availability zone ID.
        :type ZoneId: str
        :param _NodePermWipeFlag: The value is true when there are scheduling tasks to be eliminated and no AZs for switchback; otherwise, it is false.
        :type NodePermWipeFlag: bool
        """
        self._ZoneId = None
        self._NodePermWipeFlag = None

    @property
    def ZoneId(self):
        r"""Availability zone ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NodePermWipeFlag(self):
        r"""The value is true when there are scheduling tasks to be eliminated and no AZs for switchback; otherwise, it is false.
        :rtype: bool
        """
        return self._NodePermWipeFlag

    @NodePermWipeFlag.setter
    def NodePermWipeFlag(self, NodePermWipeFlag):
        self._NodePermWipeFlag = NodePermWipeFlag


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NodePermWipeFlag = params.get("NodePermWipeFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        