# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcknowledgeMessageRequest(AbstractModel):
    r"""AcknowledgeMessage request structure.

    """

    def __init__(self):
        r"""
        :param _MessageId: Unique ID used to identify the message, which can be obtained from the returned value of `receiveMessage`.
        :type MessageId: str
        :param _AckTopic: Topic name, which can be obtained from the returned value of `receiveMessage` and is better to be the full path of the topic, such as `tenant/namespace/topic`. If it is not specified, `public/default` will be used by default.
        :type AckTopic: str
        :param _SubName: Subscriber name, which can be obtained from the returned value of `receiveMessage`. Make sure that it is the same as the subscriber name identified in `receiveMessage`; otherwise, the received message cannot be correctly acknowledged.
        :type SubName: str
        """
        self._MessageId = None
        self._AckTopic = None
        self._SubName = None

    @property
    def MessageId(self):
        r"""Unique ID used to identify the message, which can be obtained from the returned value of `receiveMessage`.
        :rtype: str
        """
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def AckTopic(self):
        r"""Topic name, which can be obtained from the returned value of `receiveMessage` and is better to be the full path of the topic, such as `tenant/namespace/topic`. If it is not specified, `public/default` will be used by default.
        :rtype: str
        """
        return self._AckTopic

    @AckTopic.setter
    def AckTopic(self, AckTopic):
        self._AckTopic = AckTopic

    @property
    def SubName(self):
        r"""Subscriber name, which can be obtained from the returned value of `receiveMessage`. Make sure that it is the same as the subscriber name identified in `receiveMessage`; otherwise, the received message cannot be correctly acknowledged.
        :rtype: str
        """
        return self._SubName

    @SubName.setter
    def SubName(self, SubName):
        self._SubName = SubName


    def _deserialize(self, params):
        self._MessageId = params.get("MessageId")
        self._AckTopic = params.get("AckTopic")
        self._SubName = params.get("SubName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcknowledgeMessageResponse(AbstractModel):
    r"""AcknowledgeMessage response structure.

    """

    def __init__(self):
        r"""
        :param _ErrorMsg: If "", it indicates that there is no error return. otherwise return specific error information.
        :type ErrorMsg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrorMsg = None
        self._RequestId = None

    @property
    def ErrorMsg(self):
        r"""If "", it indicates that there is no error return. otherwise return specific error information.
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrorMsg = params.get("ErrorMsg")
        self._RequestId = params.get("RequestId")


class BindCluster(AbstractModel):
    r"""Information of dedicated clusters

    """

    def __init__(self):
        r"""
        :param _ClusterName: Name of a physical cluster.
        :type ClusterName: str
        """
        self._ClusterName = None

    @property
    def ClusterName(self):
        r"""Name of a physical cluster.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertificateInfo(AbstractModel):
    r"""Pulsar cluster TLS certificate information.

    """

    def __init__(self):
        r"""
        :param _CertificateId: Specifies the id in SSL certificate management.
        :type CertificateId: str
        :param _ExpireTime: Certificate expiration time.
        :type ExpireTime: str
        :param _DomainName: Specifies the domain name bound to the certificate.
        :type DomainName: str
        :param _Status: Certificate status: 0 indicates issued.
Expiring soon.
Not activated.
3. indicates expired.
Indicates the unavailability.
        :type Status: str
        :param _Type: Certificate type: 0: root certificate, 1: server certificate.
        :type Type: str
        :param _Origin: TencentCloud: SSL certificate. Default: TDMQ official Default certificate.
        :type Origin: str
        :param _ModifyTime: Certificate addition/update time.
        :type ModifyTime: str
        """
        self._CertificateId = None
        self._ExpireTime = None
        self._DomainName = None
        self._Status = None
        self._Type = None
        self._Origin = None
        self._ModifyTime = None

    @property
    def CertificateId(self):
        r"""Specifies the id in SSL certificate management.
        :rtype: str
        """
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId

    @property
    def ExpireTime(self):
        r"""Certificate expiration time.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def DomainName(self):
        r"""Specifies the domain name bound to the certificate.
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Status(self):
        r"""Certificate status: 0 indicates issued.
Expiring soon.
Not activated.
3. indicates expired.
Indicates the unavailability.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Type(self):
        r"""Certificate type: 0: root certificate, 1: server certificate.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Origin(self):
        r"""TencentCloud: SSL certificate. Default: TDMQ official Default certificate.
        :rtype: str
        """
        return self._Origin

    @Origin.setter
    def Origin(self, Origin):
        self._Origin = Origin

    @property
    def ModifyTime(self):
        r"""Certificate addition/update time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._CertificateId = params.get("CertificateId")
        self._ExpireTime = params.get("ExpireTime")
        self._DomainName = params.get("DomainName")
        self._Status = params.get("Status")
        self._Type = params.get("Type")
        self._Origin = params.get("Origin")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearCmqQueueRequest(AbstractModel):
    r"""ClearCmqQueue request structure.

    """

    def __init__(self):
        r"""
        :param _QueueName: Queue name, unique under the same account in a single region. queue name is a string of no more than 64 characters, beginning with a letter, the rest may contain letters, digits, and hyphens (-).
        :type QueueName: str
        """
        self._QueueName = None

    @property
    def QueueName(self):
        r"""Queue name, unique under the same account in a single region. queue name is a string of no more than 64 characters, beginning with a letter, the rest may contain letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearCmqQueueResponse(AbstractModel):
    r"""ClearCmqQueue response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ClearCmqSubscriptionFilterTagsRequest(AbstractModel):
    r"""ClearCmqSubscriptionFilterTags request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _SubscriptionName: Subscription name, which must be unique under the same account and same topic in a single region. the name is a string of no more than 64 characters, beginning with a letter, and the remaining part may contain letters, numbers, and hyphens (-).
        :type SubscriptionName: str
        """
        self._TopicName = None
        self._SubscriptionName = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def SubscriptionName(self):
        r"""Subscription name, which must be unique under the same account and same topic in a single region. the name is a string of no more than 64 characters, beginning with a letter, and the remaining part may contain letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._SubscriptionName = params.get("SubscriptionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearCmqSubscriptionFilterTagsResponse(AbstractModel):
    r"""ClearCmqSubscriptionFilterTags response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ClientSubscriptionInfo(AbstractModel):
    r"""Client subscription details, which are used to help determine clients with inconsistent subscription relationships.

    """

    def __init__(self):
        r"""
        :param _ClientId: Client ID
        :type ClientId: str
        :param _ClientAddr: Client IP.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientAddr: str
        :param _Topic: Subscribed topic.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Topic: str
        :param _SubString: Subscription expression.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubString: str
        :param _ExpressionType: Subscription method.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpressionType: str
        """
        self._ClientId = None
        self._ClientAddr = None
        self._Topic = None
        self._SubString = None
        self._ExpressionType = None

    @property
    def ClientId(self):
        r"""Client ID
        :rtype: str
        """
        return self._ClientId

    @ClientId.setter
    def ClientId(self, ClientId):
        self._ClientId = ClientId

    @property
    def ClientAddr(self):
        r"""Client IP.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientAddr

    @ClientAddr.setter
    def ClientAddr(self, ClientAddr):
        self._ClientAddr = ClientAddr

    @property
    def Topic(self):
        r"""Subscribed topic.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def SubString(self):
        r"""Subscription expression.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubString

    @SubString.setter
    def SubString(self, SubString):
        self._SubString = SubString

    @property
    def ExpressionType(self):
        r"""Subscription method.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpressionType

    @ExpressionType.setter
    def ExpressionType(self, ExpressionType):
        self._ExpressionType = ExpressionType


    def _deserialize(self, params):
        self._ClientId = params.get("ClientId")
        self._ClientAddr = params.get("ClientAddr")
        self._Topic = params.get("Topic")
        self._SubString = params.get("SubString")
        self._ExpressionType = params.get("ExpressionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Cluster(AbstractModel):
    r"""Set of cluster information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _ClusterName: Cluster name.
        :type ClusterName: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _EndPointNum: Number of access points
        :type EndPointNum: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _Healthy: Whether the cluster is healthy. 1: healthy; 0: exceptional
        :type Healthy: int
        :param _HealthyInfo: Cluster health information
Note: this field may return null, indicating that no valid values can be obtained.
        :type HealthyInfo: str
        :param _Status: Cluster status. 0: creating; 1: normal; 2: terminating; 3: deleted; 4. isolated; 5. creation failed; 6: deletion failed
        :type Status: int
        :param _MaxNamespaceNum: Maximum number of namespaces
        :type MaxNamespaceNum: int
        :param _MaxTopicNum: Maximum number of topics
        :type MaxTopicNum: int
        :param _MaxQps: Maximum QPS
        :type MaxQps: int
        :param _MessageRetentionTime: Maximum message retention period in seconds
        :type MessageRetentionTime: int
        :param _MaxStorageCapacity: Maximum storage capacity
        :type MaxStorageCapacity: int
        :param _Version: Cluster version
Note: this field may return null, indicating that no valid values can be obtained.
        :type Version: str
        :param _PublicEndPoint: Public network access point
Note: this field may return null, indicating that no valid values can be obtained.
        :type PublicEndPoint: str
        :param _VpcEndPoint: VPC access point
Note: this field may return null, indicating that no valid values can be obtained.
        :type VpcEndPoint: str
        :param _NamespaceNum: Number of namespaces
Note: this field may return null, indicating that no valid values can be obtained.
        :type NamespaceNum: int
        :param _UsedStorageBudget: Limit of used storage in MB
Note: this field may return null, indicating that no valid values can be obtained.
        :type UsedStorageBudget: int
        :param _MaxPublishRateInMessages: Maximum message production rate in messages
Note: this field may return null, indicating that no valid values can be obtained.
        :type MaxPublishRateInMessages: int
        :param _MaxDispatchRateInMessages: Maximum message push rate in messages
Note: this field may return null, indicating that no valid values can be obtained.
        :type MaxDispatchRateInMessages: int
        :param _MaxPublishRateInBytes: Maximum message production rate in bytes
Note: this field may return null, indicating that no valid values can be obtained.
        :type MaxPublishRateInBytes: int
        :param _MaxDispatchRateInBytes: Maximum message push rate in bytes
Note: this field may return null, indicating that no valid values can be obtained.
        :type MaxDispatchRateInBytes: int
        :param _TopicNum: Number of created topics
Note: this field may return null, indicating that no valid values can be obtained.
        :type TopicNum: int
        :param _MaxMessageDelayInSeconds: Maximum message delay in seconds
Note: this field may return null, indicating that no valid values can be obtained.
        :type MaxMessageDelayInSeconds: int
        :param _PublicAccessEnabled: Whether to enable public network access. If this parameter is left empty, the feature will be enabled by default
Note: this field may return null, indicating that no valid values can be obtained.
        :type PublicAccessEnabled: bool
        :param _Tags: Tag
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _PayMode: Billing mode:
`0`: Pay-as-you-go
`1`: Monthly subscription
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PayMode: int
        :param _ProjectId: Project ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProjectId: int
        :param _ProjectName: Project name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProjectName: str
        :param _UpgradeProInstance: Specifies whether the pro edition instance can be upgraded.
        :type UpgradeProInstance: bool
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Remark = None
        self._EndPointNum = None
        self._CreateTime = None
        self._Healthy = None
        self._HealthyInfo = None
        self._Status = None
        self._MaxNamespaceNum = None
        self._MaxTopicNum = None
        self._MaxQps = None
        self._MessageRetentionTime = None
        self._MaxStorageCapacity = None
        self._Version = None
        self._PublicEndPoint = None
        self._VpcEndPoint = None
        self._NamespaceNum = None
        self._UsedStorageBudget = None
        self._MaxPublishRateInMessages = None
        self._MaxDispatchRateInMessages = None
        self._MaxPublishRateInBytes = None
        self._MaxDispatchRateInBytes = None
        self._TopicNum = None
        self._MaxMessageDelayInSeconds = None
        self._PublicAccessEnabled = None
        self._Tags = None
        self._PayMode = None
        self._ProjectId = None
        self._ProjectName = None
        self._UpgradeProInstance = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def EndPointNum(self):
        r"""Number of access points
        :rtype: int
        """
        return self._EndPointNum

    @EndPointNum.setter
    def EndPointNum(self, EndPointNum):
        self._EndPointNum = EndPointNum

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Healthy(self):
        r"""Whether the cluster is healthy. 1: healthy; 0: exceptional
        :rtype: int
        """
        return self._Healthy

    @Healthy.setter
    def Healthy(self, Healthy):
        self._Healthy = Healthy

    @property
    def HealthyInfo(self):
        r"""Cluster health information
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HealthyInfo

    @HealthyInfo.setter
    def HealthyInfo(self, HealthyInfo):
        self._HealthyInfo = HealthyInfo

    @property
    def Status(self):
        r"""Cluster status. 0: creating; 1: normal; 2: terminating; 3: deleted; 4. isolated; 5. creation failed; 6: deletion failed
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MaxNamespaceNum(self):
        r"""Maximum number of namespaces
        :rtype: int
        """
        return self._MaxNamespaceNum

    @MaxNamespaceNum.setter
    def MaxNamespaceNum(self, MaxNamespaceNum):
        self._MaxNamespaceNum = MaxNamespaceNum

    @property
    def MaxTopicNum(self):
        r"""Maximum number of topics
        :rtype: int
        """
        return self._MaxTopicNum

    @MaxTopicNum.setter
    def MaxTopicNum(self, MaxTopicNum):
        self._MaxTopicNum = MaxTopicNum

    @property
    def MaxQps(self):
        r"""Maximum QPS
        :rtype: int
        """
        return self._MaxQps

    @MaxQps.setter
    def MaxQps(self, MaxQps):
        self._MaxQps = MaxQps

    @property
    def MessageRetentionTime(self):
        r"""Maximum message retention period in seconds
        :rtype: int
        """
        return self._MessageRetentionTime

    @MessageRetentionTime.setter
    def MessageRetentionTime(self, MessageRetentionTime):
        self._MessageRetentionTime = MessageRetentionTime

    @property
    def MaxStorageCapacity(self):
        r"""Maximum storage capacity
        :rtype: int
        """
        return self._MaxStorageCapacity

    @MaxStorageCapacity.setter
    def MaxStorageCapacity(self, MaxStorageCapacity):
        self._MaxStorageCapacity = MaxStorageCapacity

    @property
    def Version(self):
        r"""Cluster version
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def PublicEndPoint(self):
        r"""Public network access point
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PublicEndPoint

    @PublicEndPoint.setter
    def PublicEndPoint(self, PublicEndPoint):
        self._PublicEndPoint = PublicEndPoint

    @property
    def VpcEndPoint(self):
        r"""VPC access point
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcEndPoint

    @VpcEndPoint.setter
    def VpcEndPoint(self, VpcEndPoint):
        self._VpcEndPoint = VpcEndPoint

    @property
    def NamespaceNum(self):
        r"""Number of namespaces
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NamespaceNum

    @NamespaceNum.setter
    def NamespaceNum(self, NamespaceNum):
        self._NamespaceNum = NamespaceNum

    @property
    def UsedStorageBudget(self):
        r"""Limit of used storage in MB
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UsedStorageBudget

    @UsedStorageBudget.setter
    def UsedStorageBudget(self, UsedStorageBudget):
        self._UsedStorageBudget = UsedStorageBudget

    @property
    def MaxPublishRateInMessages(self):
        r"""Maximum message production rate in messages
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxPublishRateInMessages

    @MaxPublishRateInMessages.setter
    def MaxPublishRateInMessages(self, MaxPublishRateInMessages):
        self._MaxPublishRateInMessages = MaxPublishRateInMessages

    @property
    def MaxDispatchRateInMessages(self):
        r"""Maximum message push rate in messages
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxDispatchRateInMessages

    @MaxDispatchRateInMessages.setter
    def MaxDispatchRateInMessages(self, MaxDispatchRateInMessages):
        self._MaxDispatchRateInMessages = MaxDispatchRateInMessages

    @property
    def MaxPublishRateInBytes(self):
        r"""Maximum message production rate in bytes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxPublishRateInBytes

    @MaxPublishRateInBytes.setter
    def MaxPublishRateInBytes(self, MaxPublishRateInBytes):
        self._MaxPublishRateInBytes = MaxPublishRateInBytes

    @property
    def MaxDispatchRateInBytes(self):
        r"""Maximum message push rate in bytes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxDispatchRateInBytes

    @MaxDispatchRateInBytes.setter
    def MaxDispatchRateInBytes(self, MaxDispatchRateInBytes):
        self._MaxDispatchRateInBytes = MaxDispatchRateInBytes

    @property
    def TopicNum(self):
        r"""Number of created topics
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def MaxMessageDelayInSeconds(self):
        r"""Maximum message delay in seconds
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxMessageDelayInSeconds

    @MaxMessageDelayInSeconds.setter
    def MaxMessageDelayInSeconds(self, MaxMessageDelayInSeconds):
        self._MaxMessageDelayInSeconds = MaxMessageDelayInSeconds

    @property
    def PublicAccessEnabled(self):
        r"""Whether to enable public network access. If this parameter is left empty, the feature will be enabled by default
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._PublicAccessEnabled

    @PublicAccessEnabled.setter
    def PublicAccessEnabled(self, PublicAccessEnabled):
        self._PublicAccessEnabled = PublicAccessEnabled

    @property
    def Tags(self):
        r"""Tag
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def PayMode(self):
        r"""Billing mode:
`0`: Pay-as-you-go
`1`: Monthly subscription
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ProjectId(self):
        r"""Project ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectName(self):
        r"""Project name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def UpgradeProInstance(self):
        r"""Specifies whether the pro edition instance can be upgraded.
        :rtype: bool
        """
        return self._UpgradeProInstance

    @UpgradeProInstance.setter
    def UpgradeProInstance(self, UpgradeProInstance):
        self._UpgradeProInstance = UpgradeProInstance


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Remark = params.get("Remark")
        self._EndPointNum = params.get("EndPointNum")
        self._CreateTime = params.get("CreateTime")
        self._Healthy = params.get("Healthy")
        self._HealthyInfo = params.get("HealthyInfo")
        self._Status = params.get("Status")
        self._MaxNamespaceNum = params.get("MaxNamespaceNum")
        self._MaxTopicNum = params.get("MaxTopicNum")
        self._MaxQps = params.get("MaxQps")
        self._MessageRetentionTime = params.get("MessageRetentionTime")
        self._MaxStorageCapacity = params.get("MaxStorageCapacity")
        self._Version = params.get("Version")
        self._PublicEndPoint = params.get("PublicEndPoint")
        self._VpcEndPoint = params.get("VpcEndPoint")
        self._NamespaceNum = params.get("NamespaceNum")
        self._UsedStorageBudget = params.get("UsedStorageBudget")
        self._MaxPublishRateInMessages = params.get("MaxPublishRateInMessages")
        self._MaxDispatchRateInMessages = params.get("MaxDispatchRateInMessages")
        self._MaxPublishRateInBytes = params.get("MaxPublishRateInBytes")
        self._MaxDispatchRateInBytes = params.get("MaxDispatchRateInBytes")
        self._TopicNum = params.get("TopicNum")
        self._MaxMessageDelayInSeconds = params.get("MaxMessageDelayInSeconds")
        self._PublicAccessEnabled = params.get("PublicAccessEnabled")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._PayMode = params.get("PayMode")
        self._ProjectId = params.get("ProjectId")
        self._ProjectName = params.get("ProjectName")
        self._UpgradeProInstance = params.get("UpgradeProInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CmqDeadLetterPolicy(AbstractModel):
    r"""cmq DeadLetterPolicy

    """

    def __init__(self):
        r"""
        :param _DeadLetterQueue: Dead letter queue.
        :type DeadLetterQueue: str
        :param _Policy: Dead letter queue policy. 0: maximum number of receipt. 1: maximum unconsumed time.
        :type Policy: int
        :param _MaxTimeToLive: Maximum unconsumed expiration time. Required if policy is 1. Range: 300-43,200 seconds, must be less than the maximum message retention time MsgRetentionSeconds.
        :type MaxTimeToLive: int
        :param _MaxReceiveCount: Maximum number of receipt. required when Policy is 0. value range: 1 to 1000.
        :type MaxReceiveCount: int
        """
        self._DeadLetterQueue = None
        self._Policy = None
        self._MaxTimeToLive = None
        self._MaxReceiveCount = None

    @property
    def DeadLetterQueue(self):
        r"""Dead letter queue.
        :rtype: str
        """
        return self._DeadLetterQueue

    @DeadLetterQueue.setter
    def DeadLetterQueue(self, DeadLetterQueue):
        self._DeadLetterQueue = DeadLetterQueue

    @property
    def Policy(self):
        r"""Dead letter queue policy. 0: maximum number of receipt. 1: maximum unconsumed time.
        :rtype: int
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def MaxTimeToLive(self):
        r"""Maximum unconsumed expiration time. Required if policy is 1. Range: 300-43,200 seconds, must be less than the maximum message retention time MsgRetentionSeconds.
        :rtype: int
        """
        return self._MaxTimeToLive

    @MaxTimeToLive.setter
    def MaxTimeToLive(self, MaxTimeToLive):
        self._MaxTimeToLive = MaxTimeToLive

    @property
    def MaxReceiveCount(self):
        r"""Maximum number of receipt. required when Policy is 0. value range: 1 to 1000.
        :rtype: int
        """
        return self._MaxReceiveCount

    @MaxReceiveCount.setter
    def MaxReceiveCount(self, MaxReceiveCount):
        self._MaxReceiveCount = MaxReceiveCount


    def _deserialize(self, params):
        self._DeadLetterQueue = params.get("DeadLetterQueue")
        self._Policy = params.get("Policy")
        self._MaxTimeToLive = params.get("MaxTimeToLive")
        self._MaxReceiveCount = params.get("MaxReceiveCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CmqDeadLetterSource(AbstractModel):
    r"""Cmq DeadLetterSource

    """

    def __init__(self):
        r"""
        :param _QueueId: Message queue ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type QueueId: str
        :param _QueueName: Message queue name.
        :type QueueName: str
        """
        self._QueueId = None
        self._QueueName = None

    @property
    def QueueId(self):
        r"""Message queue ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._QueueId

    @QueueId.setter
    def QueueId(self, QueueId):
        self._QueueId = QueueId

    @property
    def QueueName(self):
        r"""Message queue name.
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._QueueId = params.get("QueueId")
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CmqQueue(AbstractModel):
    r"""Batch queue attribute information of CMQ

    """

    def __init__(self):
        r"""
        :param _QueueId: Message queue ID.
        :type QueueId: str
        :param _QueueName: Message queue name.
        :type QueueName: str
        :param _Qps: Limit on the number of messages produced per second. The size of consumed messages is 1.1 times this value.
        :type Qps: int
        :param _Bps: Bandwidth limit.
        :type Bps: int
        :param _MaxDelaySeconds: Specifies the maximum retention time for in-flight messages, which must be less than the message retention period.
        :type MaxDelaySeconds: int
        :param _MaxMsgHeapNum: Maximum number of heaped messages. The value range is 1,000,000–10,000,000 during the beta test and can be 1,000,000–1,000,000,000 after the product is officially released. The default value is 10,000,000 during the beta test and will be 100,000,000 after the product is officially released.
        :type MaxMsgHeapNum: int
        :param _PollingWaitSeconds: Long polling waiting time for message receipt. Value range 0-30 seconds, default value 0.
        :type PollingWaitSeconds: int
        :param _MsgRetentionSeconds: Message retention period. The value range is 60-1,296,000 seconds (1 min-15 days), with a default value of 345,600 seconds (4 days).
        :type MsgRetentionSeconds: int
        :param _VisibilityTimeout: Message visibility timeout period. The value range is 1-43,200 seconds (within 12 hours), with a default value of 30.
        :type VisibilityTimeout: int
        :param _MaxMsgSize: Maximum message length. Range: 1,024-1,048,576 bytes (i.e., 1K-1,024K). Default value is 65,536.
        :type MaxMsgSize: int
        :param _RewindSeconds: Maximum message backtracking time for backtracking queues, range 0-43,200 seconds. 0 means message backtracking is not enabled.
        :type RewindSeconds: int
        :param _CreateTime: Creation time of queues. Returns a Unix timestamp, accurate to milliseconds.
        :type CreateTime: int
        :param _LastModifyTime: The last time the queue attribute was modified. Returns a Unix timestamp, accurate to milliseconds.
        :type LastModifyTime: int
        :param _ActiveMsgNum: Total number of active messages (not being consumed) in queue, an approximate value.
        :type ActiveMsgNum: int
        :param _InactiveMsgNum: Total number of inactive messages (being consumed) in queue, an approximate value.
        :type InactiveMsgNum: int
        :param _DelayMsgNum: Number of delayed messages.
Note: this field may return null, indicating that no valid values can be obtained.
        :type DelayMsgNum: int
        :param _RewindMsgNum: Number of retained messages which have been deleted by the `DelMsg` API but are still within their rewind time range.
Note: this field may return null, indicating that no valid values can be obtained.
        :type RewindMsgNum: int
        :param _MinMsgTime: Minimum unconsumed time of message in seconds.
Note: this field may return null, indicating that no valid values can be obtained.
        :type MinMsgTime: int
        :param _Transaction: Transaction message queue. true: transaction message type; false: other message types.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Transaction: bool
        :param _DeadLetterSource: Dead letter queue.
Note: this field may return null, indicating that no valid values can be obtained.
        :type DeadLetterSource: list of CmqDeadLetterSource
        :param _DeadLetterPolicy: Dead letter queue policy.
Note: this field may return null, indicating that no valid values can be obtained.
        :type DeadLetterPolicy: :class:`tencentcloud.tdmq.v20200217.models.CmqDeadLetterPolicy`
        :param _TransactionPolicy: Transaction message policy.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TransactionPolicy: :class:`tencentcloud.tdmq.v20200217.models.CmqTransactionPolicy`
        :param _CreateUin: Creator `Uin`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CreateUin: int
        :param _Tags: Associated tag.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _Trace: Message trace. true: enabled; false: not enabled
Note: this field may return null, indicating that no valid values can be obtained.
        :type Trace: bool
        :param _TenantId: Tenant ID
        :type TenantId: str
        :param _NamespaceName: Specifies the namespace name.
        :type NamespaceName: str
        :param _Status: Cluster status. 0: Creating, 1: Normal, 2: Deleting, 3: Deleted, 4: Isolating, 5: Creation failed, 6: Deletion failed
        :type Status: int
        :param _MaxUnackedMsgNum: Maximum Number of Unacknowledged Messages
        :type MaxUnackedMsgNum: int
        :param _MaxMsgBacklogSize: Maximum Message Backlog Size (bytes)
        :type MaxMsgBacklogSize: int
        :param _RetentionSizeInMB: Queue retrospective storage space. Value range: 1024 MB to 10240 MB. 0 indicates disabled.
        :type RetentionSizeInMB: int
        """
        self._QueueId = None
        self._QueueName = None
        self._Qps = None
        self._Bps = None
        self._MaxDelaySeconds = None
        self._MaxMsgHeapNum = None
        self._PollingWaitSeconds = None
        self._MsgRetentionSeconds = None
        self._VisibilityTimeout = None
        self._MaxMsgSize = None
        self._RewindSeconds = None
        self._CreateTime = None
        self._LastModifyTime = None
        self._ActiveMsgNum = None
        self._InactiveMsgNum = None
        self._DelayMsgNum = None
        self._RewindMsgNum = None
        self._MinMsgTime = None
        self._Transaction = None
        self._DeadLetterSource = None
        self._DeadLetterPolicy = None
        self._TransactionPolicy = None
        self._CreateUin = None
        self._Tags = None
        self._Trace = None
        self._TenantId = None
        self._NamespaceName = None
        self._Status = None
        self._MaxUnackedMsgNum = None
        self._MaxMsgBacklogSize = None
        self._RetentionSizeInMB = None

    @property
    def QueueId(self):
        r"""Message queue ID.
        :rtype: str
        """
        return self._QueueId

    @QueueId.setter
    def QueueId(self, QueueId):
        self._QueueId = QueueId

    @property
    def QueueName(self):
        r"""Message queue name.
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def Qps(self):
        r"""Limit on the number of messages produced per second. The size of consumed messages is 1.1 times this value.
        :rtype: int
        """
        return self._Qps

    @Qps.setter
    def Qps(self, Qps):
        self._Qps = Qps

    @property
    def Bps(self):
        r"""Bandwidth limit.
        :rtype: int
        """
        return self._Bps

    @Bps.setter
    def Bps(self, Bps):
        self._Bps = Bps

    @property
    def MaxDelaySeconds(self):
        r"""Specifies the maximum retention time for in-flight messages, which must be less than the message retention period.
        :rtype: int
        """
        return self._MaxDelaySeconds

    @MaxDelaySeconds.setter
    def MaxDelaySeconds(self, MaxDelaySeconds):
        self._MaxDelaySeconds = MaxDelaySeconds

    @property
    def MaxMsgHeapNum(self):
        r"""Maximum number of heaped messages. The value range is 1,000,000–10,000,000 during the beta test and can be 1,000,000–1,000,000,000 after the product is officially released. The default value is 10,000,000 during the beta test and will be 100,000,000 after the product is officially released.
        :rtype: int
        """
        return self._MaxMsgHeapNum

    @MaxMsgHeapNum.setter
    def MaxMsgHeapNum(self, MaxMsgHeapNum):
        self._MaxMsgHeapNum = MaxMsgHeapNum

    @property
    def PollingWaitSeconds(self):
        r"""Long polling waiting time for message receipt. Value range 0-30 seconds, default value 0.
        :rtype: int
        """
        return self._PollingWaitSeconds

    @PollingWaitSeconds.setter
    def PollingWaitSeconds(self, PollingWaitSeconds):
        self._PollingWaitSeconds = PollingWaitSeconds

    @property
    def MsgRetentionSeconds(self):
        r"""Message retention period. The value range is 60-1,296,000 seconds (1 min-15 days), with a default value of 345,600 seconds (4 days).
        :rtype: int
        """
        return self._MsgRetentionSeconds

    @MsgRetentionSeconds.setter
    def MsgRetentionSeconds(self, MsgRetentionSeconds):
        self._MsgRetentionSeconds = MsgRetentionSeconds

    @property
    def VisibilityTimeout(self):
        r"""Message visibility timeout period. The value range is 1-43,200 seconds (within 12 hours), with a default value of 30.
        :rtype: int
        """
        return self._VisibilityTimeout

    @VisibilityTimeout.setter
    def VisibilityTimeout(self, VisibilityTimeout):
        self._VisibilityTimeout = VisibilityTimeout

    @property
    def MaxMsgSize(self):
        r"""Maximum message length. Range: 1,024-1,048,576 bytes (i.e., 1K-1,024K). Default value is 65,536.
        :rtype: int
        """
        return self._MaxMsgSize

    @MaxMsgSize.setter
    def MaxMsgSize(self, MaxMsgSize):
        self._MaxMsgSize = MaxMsgSize

    @property
    def RewindSeconds(self):
        r"""Maximum message backtracking time for backtracking queues, range 0-43,200 seconds. 0 means message backtracking is not enabled.
        :rtype: int
        """
        return self._RewindSeconds

    @RewindSeconds.setter
    def RewindSeconds(self, RewindSeconds):
        self._RewindSeconds = RewindSeconds

    @property
    def CreateTime(self):
        r"""Creation time of queues. Returns a Unix timestamp, accurate to milliseconds.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def LastModifyTime(self):
        r"""The last time the queue attribute was modified. Returns a Unix timestamp, accurate to milliseconds.
        :rtype: int
        """
        return self._LastModifyTime

    @LastModifyTime.setter
    def LastModifyTime(self, LastModifyTime):
        self._LastModifyTime = LastModifyTime

    @property
    def ActiveMsgNum(self):
        r"""Total number of active messages (not being consumed) in queue, an approximate value.
        :rtype: int
        """
        return self._ActiveMsgNum

    @ActiveMsgNum.setter
    def ActiveMsgNum(self, ActiveMsgNum):
        self._ActiveMsgNum = ActiveMsgNum

    @property
    def InactiveMsgNum(self):
        r"""Total number of inactive messages (being consumed) in queue, an approximate value.
        :rtype: int
        """
        return self._InactiveMsgNum

    @InactiveMsgNum.setter
    def InactiveMsgNum(self, InactiveMsgNum):
        self._InactiveMsgNum = InactiveMsgNum

    @property
    def DelayMsgNum(self):
        r"""Number of delayed messages.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DelayMsgNum

    @DelayMsgNum.setter
    def DelayMsgNum(self, DelayMsgNum):
        self._DelayMsgNum = DelayMsgNum

    @property
    def RewindMsgNum(self):
        r"""Number of retained messages which have been deleted by the `DelMsg` API but are still within their rewind time range.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RewindMsgNum

    @RewindMsgNum.setter
    def RewindMsgNum(self, RewindMsgNum):
        self._RewindMsgNum = RewindMsgNum

    @property
    def MinMsgTime(self):
        r"""Minimum unconsumed time of message in seconds.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MinMsgTime

    @MinMsgTime.setter
    def MinMsgTime(self, MinMsgTime):
        self._MinMsgTime = MinMsgTime

    @property
    def Transaction(self):
        r"""Transaction message queue. true: transaction message type; false: other message types.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Transaction

    @Transaction.setter
    def Transaction(self, Transaction):
        self._Transaction = Transaction

    @property
    def DeadLetterSource(self):
        r"""Dead letter queue.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of CmqDeadLetterSource
        """
        return self._DeadLetterSource

    @DeadLetterSource.setter
    def DeadLetterSource(self, DeadLetterSource):
        self._DeadLetterSource = DeadLetterSource

    @property
    def DeadLetterPolicy(self):
        r"""Dead letter queue policy.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.CmqDeadLetterPolicy`
        """
        return self._DeadLetterPolicy

    @DeadLetterPolicy.setter
    def DeadLetterPolicy(self, DeadLetterPolicy):
        self._DeadLetterPolicy = DeadLetterPolicy

    @property
    def TransactionPolicy(self):
        r"""Transaction message policy.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.CmqTransactionPolicy`
        """
        return self._TransactionPolicy

    @TransactionPolicy.setter
    def TransactionPolicy(self, TransactionPolicy):
        self._TransactionPolicy = TransactionPolicy

    @property
    def CreateUin(self):
        r"""Creator `Uin`.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateUin

    @CreateUin.setter
    def CreateUin(self, CreateUin):
        self._CreateUin = CreateUin

    @property
    def Tags(self):
        r"""Associated tag.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Trace(self):
        r"""Message trace. true: enabled; false: not enabled
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Trace

    @Trace.setter
    def Trace(self, Trace):
        self._Trace = Trace

    @property
    def TenantId(self):
        r"""Tenant ID
        :rtype: str
        """
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def NamespaceName(self):
        r"""Specifies the namespace name.
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def Status(self):
        r"""Cluster status. 0: Creating, 1: Normal, 2: Deleting, 3: Deleted, 4: Isolating, 5: Creation failed, 6: Deletion failed
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MaxUnackedMsgNum(self):
        r"""Maximum Number of Unacknowledged Messages
        :rtype: int
        """
        return self._MaxUnackedMsgNum

    @MaxUnackedMsgNum.setter
    def MaxUnackedMsgNum(self, MaxUnackedMsgNum):
        self._MaxUnackedMsgNum = MaxUnackedMsgNum

    @property
    def MaxMsgBacklogSize(self):
        r"""Maximum Message Backlog Size (bytes)
        :rtype: int
        """
        return self._MaxMsgBacklogSize

    @MaxMsgBacklogSize.setter
    def MaxMsgBacklogSize(self, MaxMsgBacklogSize):
        self._MaxMsgBacklogSize = MaxMsgBacklogSize

    @property
    def RetentionSizeInMB(self):
        r"""Queue retrospective storage space. Value range: 1024 MB to 10240 MB. 0 indicates disabled.
        :rtype: int
        """
        return self._RetentionSizeInMB

    @RetentionSizeInMB.setter
    def RetentionSizeInMB(self, RetentionSizeInMB):
        self._RetentionSizeInMB = RetentionSizeInMB


    def _deserialize(self, params):
        self._QueueId = params.get("QueueId")
        self._QueueName = params.get("QueueName")
        self._Qps = params.get("Qps")
        self._Bps = params.get("Bps")
        self._MaxDelaySeconds = params.get("MaxDelaySeconds")
        self._MaxMsgHeapNum = params.get("MaxMsgHeapNum")
        self._PollingWaitSeconds = params.get("PollingWaitSeconds")
        self._MsgRetentionSeconds = params.get("MsgRetentionSeconds")
        self._VisibilityTimeout = params.get("VisibilityTimeout")
        self._MaxMsgSize = params.get("MaxMsgSize")
        self._RewindSeconds = params.get("RewindSeconds")
        self._CreateTime = params.get("CreateTime")
        self._LastModifyTime = params.get("LastModifyTime")
        self._ActiveMsgNum = params.get("ActiveMsgNum")
        self._InactiveMsgNum = params.get("InactiveMsgNum")
        self._DelayMsgNum = params.get("DelayMsgNum")
        self._RewindMsgNum = params.get("RewindMsgNum")
        self._MinMsgTime = params.get("MinMsgTime")
        self._Transaction = params.get("Transaction")
        if params.get("DeadLetterSource") is not None:
            self._DeadLetterSource = []
            for item in params.get("DeadLetterSource"):
                obj = CmqDeadLetterSource()
                obj._deserialize(item)
                self._DeadLetterSource.append(obj)
        if params.get("DeadLetterPolicy") is not None:
            self._DeadLetterPolicy = CmqDeadLetterPolicy()
            self._DeadLetterPolicy._deserialize(params.get("DeadLetterPolicy"))
        if params.get("TransactionPolicy") is not None:
            self._TransactionPolicy = CmqTransactionPolicy()
            self._TransactionPolicy._deserialize(params.get("TransactionPolicy"))
        self._CreateUin = params.get("CreateUin")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Trace = params.get("Trace")
        self._TenantId = params.get("TenantId")
        self._NamespaceName = params.get("NamespaceName")
        self._Status = params.get("Status")
        self._MaxUnackedMsgNum = params.get("MaxUnackedMsgNum")
        self._MaxMsgBacklogSize = params.get("MaxMsgBacklogSize")
        self._RetentionSizeInMB = params.get("RetentionSizeInMB")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CmqSubscription(AbstractModel):
    r"""Subscription response parameter in CMQ

    """

    def __init__(self):
        r"""
        :param _SubscriptionName: Subscription name, which must be unique under the same account and same topic in a single region. the name is a string of no more than 64 characters, beginning with a letter, and the remaining part may contain letters, numbers, and hyphens (-).
        :type SubscriptionName: str
        :param _SubscriptionId: Subscription ID. The subscription ID is used when monitoring data is pulled.
        :type SubscriptionId: str
        :param _TopicOwner: Subscription owner `APPID`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TopicOwner: int
        :param _MsgCount: The number of messages waiting for shipping for this subscription.
        :type MsgCount: int
        :param _LastModifyTime: The last time the subscription attribute was modified. Returns a Unix timestamp, accurate to milliseconds.
        :type LastModifyTime: int
        :param _CreateTime: The time when the subscription was created. Returns a Unix timestamp, accurate to milliseconds.
        :type CreateTime: int
        :param _BindingKey: Filtering policy for subscribing to and receiving messages.
Note: this field may return null, indicating that no valid values can be obtained.
        :type BindingKey: list of str
        :param _Endpoint: The endpoint that receives notifications is differentiated by protocol: For HTTP, the endpoint must start with http://, and the host can be a domain name or IP; for queue, fill in queueName.
        :type Endpoint: str
        :param _FilterTags: Describes the filtering policy selected by users when creating subscriptions.
filterType = 1 indicates Tag filtering when users use filterTag.
filterType = 2 indicates user use bindingKey for filtering.
        :type FilterTags: list of str
        :param _Protocol: The subscription protocol, currently supports two protocols: HTTP and queue. When the HTTP protocol is used, users need to set up their own web server to accept messages. When the queue protocol is used, messages will automatically be pushed to CMQ queues, and users can pull messages concurrently.
        :type Protocol: str
        :param _NotifyStrategy: Specifies the CMQ push server retry policy when an error occurs while pushing messages to an endpoint. valid values:.
BACKOFF_RETRY, backoff retry. retry at regular intervals, discard the message after a certain number of retries, and continue to push the next message.
(2) EXPONENTIAL_DECAY_RETRY, EXPONENTIAL DECAY RETRY. the interval between retries increases exponentially, for example starting at 1s, followed by 2s, 4s, 8s... since the Topic message period is one day, RETRY for at most one day then discard the message. default value is EXPONENTIAL_DECAY_RETRY.
        :type NotifyStrategy: str
        :param _NotifyContentFormat: The format of the push content. Values: (1) JSON; (2) SIMPLIFIED, i.e., raw format. If protocol is queue, the value must be SIMPLIFIED. If protocol is HTTP, both values are acceptable, with the default being JSON.
        :type NotifyContentFormat: str
        :param _TopicName: Topic Name of the Subscription
        :type TopicName: str
        """
        self._SubscriptionName = None
        self._SubscriptionId = None
        self._TopicOwner = None
        self._MsgCount = None
        self._LastModifyTime = None
        self._CreateTime = None
        self._BindingKey = None
        self._Endpoint = None
        self._FilterTags = None
        self._Protocol = None
        self._NotifyStrategy = None
        self._NotifyContentFormat = None
        self._TopicName = None

    @property
    def SubscriptionName(self):
        r"""Subscription name, which must be unique under the same account and same topic in a single region. the name is a string of no more than 64 characters, beginning with a letter, and the remaining part may contain letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def SubscriptionId(self):
        r"""Subscription ID. The subscription ID is used when monitoring data is pulled.
        :rtype: str
        """
        return self._SubscriptionId

    @SubscriptionId.setter
    def SubscriptionId(self, SubscriptionId):
        self._SubscriptionId = SubscriptionId

    @property
    def TopicOwner(self):
        r"""Subscription owner `APPID`.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicOwner

    @TopicOwner.setter
    def TopicOwner(self, TopicOwner):
        self._TopicOwner = TopicOwner

    @property
    def MsgCount(self):
        r"""The number of messages waiting for shipping for this subscription.
        :rtype: int
        """
        return self._MsgCount

    @MsgCount.setter
    def MsgCount(self, MsgCount):
        self._MsgCount = MsgCount

    @property
    def LastModifyTime(self):
        r"""The last time the subscription attribute was modified. Returns a Unix timestamp, accurate to milliseconds.
        :rtype: int
        """
        return self._LastModifyTime

    @LastModifyTime.setter
    def LastModifyTime(self, LastModifyTime):
        self._LastModifyTime = LastModifyTime

    @property
    def CreateTime(self):
        r"""The time when the subscription was created. Returns a Unix timestamp, accurate to milliseconds.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BindingKey(self):
        r"""Filtering policy for subscribing to and receiving messages.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._BindingKey

    @BindingKey.setter
    def BindingKey(self, BindingKey):
        self._BindingKey = BindingKey

    @property
    def Endpoint(self):
        r"""The endpoint that receives notifications is differentiated by protocol: For HTTP, the endpoint must start with http://, and the host can be a domain name or IP; for queue, fill in queueName.
        :rtype: str
        """
        return self._Endpoint

    @Endpoint.setter
    def Endpoint(self, Endpoint):
        self._Endpoint = Endpoint

    @property
    def FilterTags(self):
        r"""Describes the filtering policy selected by users when creating subscriptions.
filterType = 1 indicates Tag filtering when users use filterTag.
filterType = 2 indicates user use bindingKey for filtering.
        :rtype: list of str
        """
        return self._FilterTags

    @FilterTags.setter
    def FilterTags(self, FilterTags):
        self._FilterTags = FilterTags

    @property
    def Protocol(self):
        r"""The subscription protocol, currently supports two protocols: HTTP and queue. When the HTTP protocol is used, users need to set up their own web server to accept messages. When the queue protocol is used, messages will automatically be pushed to CMQ queues, and users can pull messages concurrently.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def NotifyStrategy(self):
        r"""Specifies the CMQ push server retry policy when an error occurs while pushing messages to an endpoint. valid values:.
BACKOFF_RETRY, backoff retry. retry at regular intervals, discard the message after a certain number of retries, and continue to push the next message.
(2) EXPONENTIAL_DECAY_RETRY, EXPONENTIAL DECAY RETRY. the interval between retries increases exponentially, for example starting at 1s, followed by 2s, 4s, 8s... since the Topic message period is one day, RETRY for at most one day then discard the message. default value is EXPONENTIAL_DECAY_RETRY.
        :rtype: str
        """
        return self._NotifyStrategy

    @NotifyStrategy.setter
    def NotifyStrategy(self, NotifyStrategy):
        self._NotifyStrategy = NotifyStrategy

    @property
    def NotifyContentFormat(self):
        r"""The format of the push content. Values: (1) JSON; (2) SIMPLIFIED, i.e., raw format. If protocol is queue, the value must be SIMPLIFIED. If protocol is HTTP, both values are acceptable, with the default being JSON.
        :rtype: str
        """
        return self._NotifyContentFormat

    @NotifyContentFormat.setter
    def NotifyContentFormat(self, NotifyContentFormat):
        self._NotifyContentFormat = NotifyContentFormat

    @property
    def TopicName(self):
        r"""Topic Name of the Subscription
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._SubscriptionName = params.get("SubscriptionName")
        self._SubscriptionId = params.get("SubscriptionId")
        self._TopicOwner = params.get("TopicOwner")
        self._MsgCount = params.get("MsgCount")
        self._LastModifyTime = params.get("LastModifyTime")
        self._CreateTime = params.get("CreateTime")
        self._BindingKey = params.get("BindingKey")
        self._Endpoint = params.get("Endpoint")
        self._FilterTags = params.get("FilterTags")
        self._Protocol = params.get("Protocol")
        self._NotifyStrategy = params.get("NotifyStrategy")
        self._NotifyContentFormat = params.get("NotifyContentFormat")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CmqTopic(AbstractModel):
    r"""Display field of the returned CMQ topic information

    """

    def __init__(self):
        r"""
        :param _TopicId: Topic ID.
        :type TopicId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _MsgRetentionSeconds: Maximum lifetime of messages in a topic. After the time specified by this parameter has elapsed since sending to this topic, the message will be deleted whether or not it has been successfully pushed to the user. Measured in seconds and fixed at one day (86,400 seconds). This attribute cannot be modified.
        :type MsgRetentionSeconds: int
        :param _MaxMsgSize: Maximum message length. value range: 1024-1048576 bytes (1-1024 kb). default value: 1048576.
        :type MaxMsgSize: int
        :param _Qps: Number of messages published per second.
        :type Qps: int
        :param _FilterType: Describes the filtering policy selected by users when creating subscriptions.
FilterType = 1 means when users use Tag filtering with FilterTag.
FilterType = 2 indicates user use BindingKey for filtering.
        :type FilterType: int
        :param _CreateTime: Topic creation time. Returns a Unix timestamp, accurate to milliseconds.
        :type CreateTime: int
        :param _LastModifyTime: The last time the topic attribute was modified. Returns a Unix timestamp, accurate to milliseconds.
        :type LastModifyTime: int
        :param _MsgCount: Number of messages in the current topic (message backlog).
        :type MsgCount: int
        :param _CreateUin: Creator `Uin`. The `resource` field for CAM authentication is composed of this field.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CreateUin: int
        :param _Tags: Associated tag.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _Trace: Message trace. true: enabled; false: not enabled
Note: this field may return null, indicating that no valid values can be obtained.
        :type Trace: bool
        :param _TenantId: Tenant ID
        :type TenantId: str
        :param _NamespaceName: Specifies the namespace name.
        :type NamespaceName: str
        :param _Status: Cluster status. 0: Creating, 1: Normal, 2: Deleting, 3: Deleted, 4: Isolating, 5: Creation failed, 6: Deletion failed
        :type Status: int
        :param _BrokerType: 0: Pulsar, 1: RocketMQ
        :type BrokerType: int
        :param _SubscriptionCount: Number of Subscriptions
        :type SubscriptionCount: int
        """
        self._TopicId = None
        self._TopicName = None
        self._MsgRetentionSeconds = None
        self._MaxMsgSize = None
        self._Qps = None
        self._FilterType = None
        self._CreateTime = None
        self._LastModifyTime = None
        self._MsgCount = None
        self._CreateUin = None
        self._Tags = None
        self._Trace = None
        self._TenantId = None
        self._NamespaceName = None
        self._Status = None
        self._BrokerType = None
        self._SubscriptionCount = None

    @property
    def TopicId(self):
        r"""Topic ID.
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MsgRetentionSeconds(self):
        r"""Maximum lifetime of messages in a topic. After the time specified by this parameter has elapsed since sending to this topic, the message will be deleted whether or not it has been successfully pushed to the user. Measured in seconds and fixed at one day (86,400 seconds). This attribute cannot be modified.
        :rtype: int
        """
        return self._MsgRetentionSeconds

    @MsgRetentionSeconds.setter
    def MsgRetentionSeconds(self, MsgRetentionSeconds):
        self._MsgRetentionSeconds = MsgRetentionSeconds

    @property
    def MaxMsgSize(self):
        r"""Maximum message length. value range: 1024-1048576 bytes (1-1024 kb). default value: 1048576.
        :rtype: int
        """
        return self._MaxMsgSize

    @MaxMsgSize.setter
    def MaxMsgSize(self, MaxMsgSize):
        self._MaxMsgSize = MaxMsgSize

    @property
    def Qps(self):
        r"""Number of messages published per second.
        :rtype: int
        """
        return self._Qps

    @Qps.setter
    def Qps(self, Qps):
        self._Qps = Qps

    @property
    def FilterType(self):
        r"""Describes the filtering policy selected by users when creating subscriptions.
FilterType = 1 means when users use Tag filtering with FilterTag.
FilterType = 2 indicates user use BindingKey for filtering.
        :rtype: int
        """
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def CreateTime(self):
        r"""Topic creation time. Returns a Unix timestamp, accurate to milliseconds.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def LastModifyTime(self):
        r"""The last time the topic attribute was modified. Returns a Unix timestamp, accurate to milliseconds.
        :rtype: int
        """
        return self._LastModifyTime

    @LastModifyTime.setter
    def LastModifyTime(self, LastModifyTime):
        self._LastModifyTime = LastModifyTime

    @property
    def MsgCount(self):
        r"""Number of messages in the current topic (message backlog).
        :rtype: int
        """
        return self._MsgCount

    @MsgCount.setter
    def MsgCount(self, MsgCount):
        self._MsgCount = MsgCount

    @property
    def CreateUin(self):
        r"""Creator `Uin`. The `resource` field for CAM authentication is composed of this field.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateUin

    @CreateUin.setter
    def CreateUin(self, CreateUin):
        self._CreateUin = CreateUin

    @property
    def Tags(self):
        r"""Associated tag.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Trace(self):
        r"""Message trace. true: enabled; false: not enabled
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Trace

    @Trace.setter
    def Trace(self, Trace):
        self._Trace = Trace

    @property
    def TenantId(self):
        r"""Tenant ID
        :rtype: str
        """
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def NamespaceName(self):
        r"""Specifies the namespace name.
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def Status(self):
        r"""Cluster status. 0: Creating, 1: Normal, 2: Deleting, 3: Deleted, 4: Isolating, 5: Creation failed, 6: Deletion failed
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def BrokerType(self):
        r"""0: Pulsar, 1: RocketMQ
        :rtype: int
        """
        return self._BrokerType

    @BrokerType.setter
    def BrokerType(self, BrokerType):
        self._BrokerType = BrokerType

    @property
    def SubscriptionCount(self):
        r"""Number of Subscriptions
        :rtype: int
        """
        return self._SubscriptionCount

    @SubscriptionCount.setter
    def SubscriptionCount(self, SubscriptionCount):
        self._SubscriptionCount = SubscriptionCount


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._MsgRetentionSeconds = params.get("MsgRetentionSeconds")
        self._MaxMsgSize = params.get("MaxMsgSize")
        self._Qps = params.get("Qps")
        self._FilterType = params.get("FilterType")
        self._CreateTime = params.get("CreateTime")
        self._LastModifyTime = params.get("LastModifyTime")
        self._MsgCount = params.get("MsgCount")
        self._CreateUin = params.get("CreateUin")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Trace = params.get("Trace")
        self._TenantId = params.get("TenantId")
        self._NamespaceName = params.get("NamespaceName")
        self._Status = params.get("Status")
        self._BrokerType = params.get("BrokerType")
        self._SubscriptionCount = params.get("SubscriptionCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CmqTransactionPolicy(AbstractModel):
    r"""cmq TransactionPolicy

    """

    def __init__(self):
        r"""
        :param _FirstQueryInterval: First recheck time.
        :type FirstQueryInterval: int
        :param _MaxQueryCount: Maximum query times.
        :type MaxQueryCount: int
        """
        self._FirstQueryInterval = None
        self._MaxQueryCount = None

    @property
    def FirstQueryInterval(self):
        r"""First recheck time.
        :rtype: int
        """
        return self._FirstQueryInterval

    @FirstQueryInterval.setter
    def FirstQueryInterval(self, FirstQueryInterval):
        self._FirstQueryInterval = FirstQueryInterval

    @property
    def MaxQueryCount(self):
        r"""Maximum query times.
        :rtype: int
        """
        return self._MaxQueryCount

    @MaxQueryCount.setter
    def MaxQueryCount(self, MaxQueryCount):
        self._MaxQueryCount = MaxQueryCount


    def _deserialize(self, params):
        self._FirstQueryInterval = params.get("FirstQueryInterval")
        self._MaxQueryCount = params.get("MaxQueryCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Consumer(AbstractModel):
    r"""Consumer.

    """

    def __init__(self):
        r"""
        :param _ConnectedSince: The time when the consumer started connecting.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConnectedSince: str
        :param _ConsumerAddr: Consumer address.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerAddr: str
        :param _ConsumerName: Consumer name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerName: str
        :param _ClientVersion: Consumer version.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientVersion: str
        :param _Partition: Serial number of the topic partition connected to the consumer.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Partition: int
        """
        self._ConnectedSince = None
        self._ConsumerAddr = None
        self._ConsumerName = None
        self._ClientVersion = None
        self._Partition = None

    @property
    def ConnectedSince(self):
        r"""The time when the consumer started connecting.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConnectedSince

    @ConnectedSince.setter
    def ConnectedSince(self, ConnectedSince):
        self._ConnectedSince = ConnectedSince

    @property
    def ConsumerAddr(self):
        r"""Consumer address.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsumerAddr

    @ConsumerAddr.setter
    def ConsumerAddr(self, ConsumerAddr):
        self._ConsumerAddr = ConsumerAddr

    @property
    def ConsumerName(self):
        r"""Consumer name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsumerName

    @ConsumerName.setter
    def ConsumerName(self, ConsumerName):
        self._ConsumerName = ConsumerName

    @property
    def ClientVersion(self):
        r"""Consumer version.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientVersion

    @ClientVersion.setter
    def ClientVersion(self, ClientVersion):
        self._ClientVersion = ClientVersion

    @property
    def Partition(self):
        r"""Serial number of the topic partition connected to the consumer.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Partition

    @Partition.setter
    def Partition(self, Partition):
        self._Partition = Partition


    def _deserialize(self, params):
        self._ConnectedSince = params.get("ConnectedSince")
        self._ConsumerAddr = params.get("ConsumerAddr")
        self._ConsumerName = params.get("ConsumerName")
        self._ClientVersion = params.get("ClientVersion")
        self._Partition = params.get("Partition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConsumerLog(AbstractModel):
    r"""Consumption log

    """

    def __init__(self):
        r"""
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _ConsumerGroup: Consumption group.
        :type ConsumerGroup: str
        :param _ConsumerName: Consumer name.
        :type ConsumerName: str
        :param _ConsumeTime: Consumption time.
        :type ConsumeTime: str
        :param _ConsumerAddr: Consumer client address.
        :type ConsumerAddr: str
        :param _ConsumeUseTime: Consumption time (milliseconds).
        :type ConsumeUseTime: int
        :param _Status: Consumption status.
        :type Status: str
        """
        self._MsgId = None
        self._ConsumerGroup = None
        self._ConsumerName = None
        self._ConsumeTime = None
        self._ConsumerAddr = None
        self._ConsumeUseTime = None
        self._Status = None

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ConsumerGroup(self):
        r"""Consumption group.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def ConsumerName(self):
        r"""Consumer name.
        :rtype: str
        """
        return self._ConsumerName

    @ConsumerName.setter
    def ConsumerName(self, ConsumerName):
        self._ConsumerName = ConsumerName

    @property
    def ConsumeTime(self):
        r"""Consumption time.
        :rtype: str
        """
        return self._ConsumeTime

    @ConsumeTime.setter
    def ConsumeTime(self, ConsumeTime):
        self._ConsumeTime = ConsumeTime

    @property
    def ConsumerAddr(self):
        r"""Consumer client address.
        :rtype: str
        """
        return self._ConsumerAddr

    @ConsumerAddr.setter
    def ConsumerAddr(self, ConsumerAddr):
        self._ConsumerAddr = ConsumerAddr

    @property
    def ConsumeUseTime(self):
        r"""Consumption time (milliseconds).
        :rtype: int
        """
        return self._ConsumeUseTime

    @ConsumeUseTime.setter
    def ConsumeUseTime(self, ConsumeUseTime):
        self._ConsumeUseTime = ConsumeUseTime

    @property
    def Status(self):
        r"""Consumption status.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MsgId = params.get("MsgId")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._ConsumerName = params.get("ConsumerName")
        self._ConsumeTime = params.get("ConsumeTime")
        self._ConsumerAddr = params.get("ConsumerAddr")
        self._ConsumeUseTime = params.get("ConsumeUseTime")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConsumerLogs(AbstractModel):
    r"""Consumption information

    """

    def __init__(self):
        r"""
        :param _TotalCount: Record count.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _ConsumerLogSets: Consumption log.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerLogSets: list of ConsumerLog
        """
        self._TotalCount = None
        self._ConsumerLogSets = None

    @property
    def TotalCount(self):
        r"""Record count.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ConsumerLogSets(self):
        r"""Consumption log.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ConsumerLog
        """
        return self._ConsumerLogSets

    @ConsumerLogSets.setter
    def ConsumerLogSets(self, ConsumerLogSets):
        self._ConsumerLogSets = ConsumerLogSets


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ConsumerLogSets") is not None:
            self._ConsumerLogSets = []
            for item in params.get("ConsumerLogSets"):
                obj = ConsumerLog()
                obj._deserialize(item)
                self._ConsumerLogSets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConsumersSchedule(AbstractModel):
    r"""Consumption progress details

    """

    def __init__(self):
        r"""
        :param _Partitions: ID of the current partition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Partitions: int
        :param _NumberOfEntries: The number of messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NumberOfEntries: int
        :param _MsgBacklog: The number of heaped messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgBacklog: int
        :param _MsgRateOut: The total number of messages delivered by the consumer per second.
        :type MsgRateOut: str
        :param _MsgThroughputOut: The size (in bytes) of messages consumed by the consumer per second.
        :type MsgThroughputOut: str
        :param _MsgRateExpired: Percentage of messages discarded due to timeout.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgRateExpired: str
        """
        self._Partitions = None
        self._NumberOfEntries = None
        self._MsgBacklog = None
        self._MsgRateOut = None
        self._MsgThroughputOut = None
        self._MsgRateExpired = None

    @property
    def Partitions(self):
        r"""ID of the current partition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def NumberOfEntries(self):
        r"""The number of messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NumberOfEntries

    @NumberOfEntries.setter
    def NumberOfEntries(self, NumberOfEntries):
        self._NumberOfEntries = NumberOfEntries

    @property
    def MsgBacklog(self):
        r"""The number of heaped messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MsgBacklog

    @MsgBacklog.setter
    def MsgBacklog(self, MsgBacklog):
        self._MsgBacklog = MsgBacklog

    @property
    def MsgRateOut(self):
        r"""The total number of messages delivered by the consumer per second.
        :rtype: str
        """
        return self._MsgRateOut

    @MsgRateOut.setter
    def MsgRateOut(self, MsgRateOut):
        self._MsgRateOut = MsgRateOut

    @property
    def MsgThroughputOut(self):
        r"""The size (in bytes) of messages consumed by the consumer per second.
        :rtype: str
        """
        return self._MsgThroughputOut

    @MsgThroughputOut.setter
    def MsgThroughputOut(self, MsgThroughputOut):
        self._MsgThroughputOut = MsgThroughputOut

    @property
    def MsgRateExpired(self):
        r"""Percentage of messages discarded due to timeout.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgRateExpired

    @MsgRateExpired.setter
    def MsgRateExpired(self, MsgRateExpired):
        self._MsgRateExpired = MsgRateExpired


    def _deserialize(self, params):
        self._Partitions = params.get("Partitions")
        self._NumberOfEntries = params.get("NumberOfEntries")
        self._MsgBacklog = params.get("MsgBacklog")
        self._MsgRateOut = params.get("MsgRateOut")
        self._MsgThroughputOut = params.get("MsgThroughputOut")
        self._MsgRateExpired = params.get("MsgRateExpired")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterRequest(AbstractModel):
    r"""CreateCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterName: Specifies the cluster name, which does not support chinese characters and special characters other than hyphens and underscores, with a length of no more than 64 characters.
        :type ClusterName: str
        :param _BindClusterId: ID of your dedicated physical cluster. If it is not passed in, cluster resources will be created in a public cluster by default.
        :type BindClusterId: int
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _Tags: Cluster tag list (deprecated).
        :type Tags: list of Tag
        :param _PublicAccessEnabled: Whether to enable public network access. If this parameter is left empty, the feature will be enabled by default
        :type PublicAccessEnabled: bool
        """
        self._ClusterName = None
        self._BindClusterId = None
        self._Remark = None
        self._Tags = None
        self._PublicAccessEnabled = None

    @property
    def ClusterName(self):
        r"""Specifies the cluster name, which does not support chinese characters and special characters other than hyphens and underscores, with a length of no more than 64 characters.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def BindClusterId(self):
        r"""ID of your dedicated physical cluster. If it is not passed in, cluster resources will be created in a public cluster by default.
        :rtype: int
        """
        return self._BindClusterId

    @BindClusterId.setter
    def BindClusterId(self, BindClusterId):
        self._BindClusterId = BindClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Tags(self):
        r"""Cluster tag list (deprecated).
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def PublicAccessEnabled(self):
        r"""Whether to enable public network access. If this parameter is left empty, the feature will be enabled by default
        :rtype: bool
        """
        return self._PublicAccessEnabled

    @PublicAccessEnabled.setter
    def PublicAccessEnabled(self, PublicAccessEnabled):
        self._PublicAccessEnabled = PublicAccessEnabled


    def _deserialize(self, params):
        self._ClusterName = params.get("ClusterName")
        self._BindClusterId = params.get("BindClusterId")
        self._Remark = params.get("Remark")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._PublicAccessEnabled = params.get("PublicAccessEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterResponse(AbstractModel):
    r"""CreateCluster response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class CreateCmqQueueRequest(AbstractModel):
    r"""CreateCmqQueue request structure.

    """

    def __init__(self):
        r"""
        :param _QueueName: Queue name, which is unique under the same account in a single region. It is a string of up to 64 characters. It can contain letters, digits, and hyphens (-) and must start with a letter.
        :type QueueName: str
        :param _MaxMsgHeapNum: Maximum number of heaped messages. The value range is 1,000,000–10,000,000 during the beta test and can be 1,000,000–1,000,000,000 after the product is officially released. The default value is 10,000,000 during the beta test and will be 100,000,000 after the product is officially released.
        :type MaxMsgHeapNum: int
        :param _PollingWaitSeconds: Long polling wait time for message reception. Value range: 0–30 seconds. Default value: 0.
        :type PollingWaitSeconds: int
        :param _VisibilityTimeout: Message visibility timeout period. Value range: 1–43200 seconds (i.e., 12 hours). Default value: 30.
        :type VisibilityTimeout: int
        :param _MaxMsgSize: Maximum message length. value range: 1024-1048576 Byte (1-1024K). default value: 1048576.
        :type MaxMsgSize: int
        :param _MsgRetentionSeconds: The max period during which a message is retained before it is automatically acknowledged. Value range: 30-43,200 seconds (30 seconds to 12 hours). Default value: 3600 seconds (1 hour).
        :type MsgRetentionSeconds: int
        :param _RewindSeconds: Rewindable time of messages in the queue. Value range: 0-1,296,000s (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :type RewindSeconds: int
        :param _Transaction: 1: transaction queue; 0: general queue
        :type Transaction: int
        :param _FirstQueryInterval: First lookback interval
        :type FirstQueryInterval: int
        :param _MaxQueryCount: Maximum number of lookbacks
        :type MaxQueryCount: int
        :param _DeadLetterQueueName: Dead letter queue name
        :type DeadLetterQueueName: str
        :param _Policy: Dead letter policy. 0: message has been consumed multiple times but not deleted; 1: `Time-To-Live` has elapsed
        :type Policy: int
        :param _MaxReceiveCount: Maximum receipt times. Value range: 1–1000
        :type MaxReceiveCount: int
        :param _MaxTimeToLive: Maximum period in seconds before an unconsumed message expires, which is required if `policy` is 1. Value range: 300–43200. This value should be smaller than `msgRetentionSeconds` (maximum message retention period)
        :type MaxTimeToLive: int
        :param _Trace: Whether to enable message trace. true: yes; false: no. If this field is not configured, the feature will not be enabled
        :type Trace: bool
        :param _Tags: Tag array.
        :type Tags: list of Tag
        :param _RetentionSizeInMB: Queue storage space configured for message rewind. Value range: 10,240-512,000 MB (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :type RetentionSizeInMB: int
        """
        self._QueueName = None
        self._MaxMsgHeapNum = None
        self._PollingWaitSeconds = None
        self._VisibilityTimeout = None
        self._MaxMsgSize = None
        self._MsgRetentionSeconds = None
        self._RewindSeconds = None
        self._Transaction = None
        self._FirstQueryInterval = None
        self._MaxQueryCount = None
        self._DeadLetterQueueName = None
        self._Policy = None
        self._MaxReceiveCount = None
        self._MaxTimeToLive = None
        self._Trace = None
        self._Tags = None
        self._RetentionSizeInMB = None

    @property
    def QueueName(self):
        r"""Queue name, which is unique under the same account in a single region. It is a string of up to 64 characters. It can contain letters, digits, and hyphens (-) and must start with a letter.
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def MaxMsgHeapNum(self):
        r"""Maximum number of heaped messages. The value range is 1,000,000–10,000,000 during the beta test and can be 1,000,000–1,000,000,000 after the product is officially released. The default value is 10,000,000 during the beta test and will be 100,000,000 after the product is officially released.
        :rtype: int
        """
        return self._MaxMsgHeapNum

    @MaxMsgHeapNum.setter
    def MaxMsgHeapNum(self, MaxMsgHeapNum):
        self._MaxMsgHeapNum = MaxMsgHeapNum

    @property
    def PollingWaitSeconds(self):
        r"""Long polling wait time for message reception. Value range: 0–30 seconds. Default value: 0.
        :rtype: int
        """
        return self._PollingWaitSeconds

    @PollingWaitSeconds.setter
    def PollingWaitSeconds(self, PollingWaitSeconds):
        self._PollingWaitSeconds = PollingWaitSeconds

    @property
    def VisibilityTimeout(self):
        r"""Message visibility timeout period. Value range: 1–43200 seconds (i.e., 12 hours). Default value: 30.
        :rtype: int
        """
        return self._VisibilityTimeout

    @VisibilityTimeout.setter
    def VisibilityTimeout(self, VisibilityTimeout):
        self._VisibilityTimeout = VisibilityTimeout

    @property
    def MaxMsgSize(self):
        r"""Maximum message length. value range: 1024-1048576 Byte (1-1024K). default value: 1048576.
        :rtype: int
        """
        return self._MaxMsgSize

    @MaxMsgSize.setter
    def MaxMsgSize(self, MaxMsgSize):
        self._MaxMsgSize = MaxMsgSize

    @property
    def MsgRetentionSeconds(self):
        r"""The max period during which a message is retained before it is automatically acknowledged. Value range: 30-43,200 seconds (30 seconds to 12 hours). Default value: 3600 seconds (1 hour).
        :rtype: int
        """
        return self._MsgRetentionSeconds

    @MsgRetentionSeconds.setter
    def MsgRetentionSeconds(self, MsgRetentionSeconds):
        self._MsgRetentionSeconds = MsgRetentionSeconds

    @property
    def RewindSeconds(self):
        r"""Rewindable time of messages in the queue. Value range: 0-1,296,000s (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :rtype: int
        """
        return self._RewindSeconds

    @RewindSeconds.setter
    def RewindSeconds(self, RewindSeconds):
        self._RewindSeconds = RewindSeconds

    @property
    def Transaction(self):
        r"""1: transaction queue; 0: general queue
        :rtype: int
        """
        return self._Transaction

    @Transaction.setter
    def Transaction(self, Transaction):
        self._Transaction = Transaction

    @property
    def FirstQueryInterval(self):
        r"""First lookback interval
        :rtype: int
        """
        return self._FirstQueryInterval

    @FirstQueryInterval.setter
    def FirstQueryInterval(self, FirstQueryInterval):
        self._FirstQueryInterval = FirstQueryInterval

    @property
    def MaxQueryCount(self):
        r"""Maximum number of lookbacks
        :rtype: int
        """
        return self._MaxQueryCount

    @MaxQueryCount.setter
    def MaxQueryCount(self, MaxQueryCount):
        self._MaxQueryCount = MaxQueryCount

    @property
    def DeadLetterQueueName(self):
        r"""Dead letter queue name
        :rtype: str
        """
        return self._DeadLetterQueueName

    @DeadLetterQueueName.setter
    def DeadLetterQueueName(self, DeadLetterQueueName):
        self._DeadLetterQueueName = DeadLetterQueueName

    @property
    def Policy(self):
        r"""Dead letter policy. 0: message has been consumed multiple times but not deleted; 1: `Time-To-Live` has elapsed
        :rtype: int
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def MaxReceiveCount(self):
        r"""Maximum receipt times. Value range: 1–1000
        :rtype: int
        """
        return self._MaxReceiveCount

    @MaxReceiveCount.setter
    def MaxReceiveCount(self, MaxReceiveCount):
        self._MaxReceiveCount = MaxReceiveCount

    @property
    def MaxTimeToLive(self):
        r"""Maximum period in seconds before an unconsumed message expires, which is required if `policy` is 1. Value range: 300–43200. This value should be smaller than `msgRetentionSeconds` (maximum message retention period)
        :rtype: int
        """
        return self._MaxTimeToLive

    @MaxTimeToLive.setter
    def MaxTimeToLive(self, MaxTimeToLive):
        self._MaxTimeToLive = MaxTimeToLive

    @property
    def Trace(self):
        r"""Whether to enable message trace. true: yes; false: no. If this field is not configured, the feature will not be enabled
        :rtype: bool
        """
        return self._Trace

    @Trace.setter
    def Trace(self, Trace):
        self._Trace = Trace

    @property
    def Tags(self):
        r"""Tag array.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def RetentionSizeInMB(self):
        r"""Queue storage space configured for message rewind. Value range: 10,240-512,000 MB (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :rtype: int
        """
        return self._RetentionSizeInMB

    @RetentionSizeInMB.setter
    def RetentionSizeInMB(self, RetentionSizeInMB):
        self._RetentionSizeInMB = RetentionSizeInMB


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        self._MaxMsgHeapNum = params.get("MaxMsgHeapNum")
        self._PollingWaitSeconds = params.get("PollingWaitSeconds")
        self._VisibilityTimeout = params.get("VisibilityTimeout")
        self._MaxMsgSize = params.get("MaxMsgSize")
        self._MsgRetentionSeconds = params.get("MsgRetentionSeconds")
        self._RewindSeconds = params.get("RewindSeconds")
        self._Transaction = params.get("Transaction")
        self._FirstQueryInterval = params.get("FirstQueryInterval")
        self._MaxQueryCount = params.get("MaxQueryCount")
        self._DeadLetterQueueName = params.get("DeadLetterQueueName")
        self._Policy = params.get("Policy")
        self._MaxReceiveCount = params.get("MaxReceiveCount")
        self._MaxTimeToLive = params.get("MaxTimeToLive")
        self._Trace = params.get("Trace")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._RetentionSizeInMB = params.get("RetentionSizeInMB")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCmqQueueResponse(AbstractModel):
    r"""CreateCmqQueue response structure.

    """

    def __init__(self):
        r"""
        :param _QueueId: `queueId` of a successfully created queue
        :type QueueId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QueueId = None
        self._RequestId = None

    @property
    def QueueId(self):
        r"""`queueId` of a successfully created queue
        :rtype: str
        """
        return self._QueueId

    @QueueId.setter
    def QueueId(self, QueueId):
        self._QueueId = QueueId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._QueueId = params.get("QueueId")
        self._RequestId = params.get("RequestId")


class CreateCmqSubscribeRequest(AbstractModel):
    r"""CreateCmqSubscribe request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _SubscriptionName: Subscription name, uniquely identifies under the same topic of the same account in a single region. subscription name is a string of no more than 64 characters, beginning with a letter, the remaining part can contain letters, digits, and hyphens (-).
        :type SubscriptionName: str
        :param _Protocol: Subscription protocol. Currently, two protocols are supported: HTTP and queue. To use the HTTP protocol, you need to build your own web server to receive messages. With the queue protocol, messages are automatically pushed to a CMQ queue and you can pull them concurrently.
        :type Protocol: str
        :param _Endpoint: `Endpoint` for notification receipt, which is distinguished by `Protocol`. For `http`, `Endpoint` must begin with `http://` and `host` can be a domain name or IP. For `Queue`, enter `QueueName`. Note that currently the push service cannot push messages to a VPC; therefore, if a VPC domain name or address is entered for `Endpoint`, pushed messages will not be received. Currently, messages can be pushed only to the public network and classic network.
        :type Endpoint: str
        :param _NotifyStrategy: CMQ push server retry policy in case an error occurs while pushing a message to `Endpoint`. Valid values: 1. BACKOFF_RETRY: backoff retry, which is to retry at a fixed interval, discard the message after a certain number of retries, and continue to push the next message; 2. EXPONENTIAL_DECAY_RETRY: exponential decay retry, which is to retry at an exponentially increasing interval, such as 1s, 2s, 4s, 8s, and so on. As a message can be retained in a topic for one day, failed messages will be discarded at most after one day of retry. Default value: EXPONENTIAL_DECAY_RETRY.
        :type NotifyStrategy: str
        :param _FilterTag: Message body tag (used for message filtering). The number of tags cannot exceed 5, and each tag can contain up to 16 characters. It is used in conjunction with the `MsgTag` parameter of `(Batch)PublishMessage`. Rules: 1. If `FilterTag` is not configured, no matter whether `MsgTag` is configured, the subscription will receive all messages published to the topic; 2. If the array of `FilterTag` values has a value, only when at least one of the values in the array also exists in the array of `MsgTag` values (i.e., `FilterTag` and `MsgTag` have an intersection) can the subscription receive messages published to the topic; 3. If the array of `FilterTag` values has a value, but `MsgTag` is not configured, then no message published to the topic will be received, which can be considered as a special case of rule 2 as `FilterTag` and `MsgTag` do not intersect in this case. The overall design idea of rules is based on the intention of the subscriber.
        :type FilterTag: list of str
        :param _BindingKey: The number of `BindingKey` cannot exceed 5, and the length of each `BindingKey` cannot exceed 64 bytes. This field indicates the filtering policy for subscribing to and receiving messages. Each `BindingKey` includes up to 15 dots (namely up to 16 segments).
        :type BindingKey: list of str
        :param _NotifyContentFormat: Push content format. Valid values: 1. JSON; 2. SIMPLIFIED, i.e., the raw format. If `Protocol` is `queue`, this value must be `SIMPLIFIED`. If `Protocol` is `http`, both options are acceptable, and the default value is `JSON`.
        :type NotifyContentFormat: str
        """
        self._TopicName = None
        self._SubscriptionName = None
        self._Protocol = None
        self._Endpoint = None
        self._NotifyStrategy = None
        self._FilterTag = None
        self._BindingKey = None
        self._NotifyContentFormat = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def SubscriptionName(self):
        r"""Subscription name, uniquely identifies under the same topic of the same account in a single region. subscription name is a string of no more than 64 characters, beginning with a letter, the remaining part can contain letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def Protocol(self):
        r"""Subscription protocol. Currently, two protocols are supported: HTTP and queue. To use the HTTP protocol, you need to build your own web server to receive messages. With the queue protocol, messages are automatically pushed to a CMQ queue and you can pull them concurrently.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Endpoint(self):
        r"""`Endpoint` for notification receipt, which is distinguished by `Protocol`. For `http`, `Endpoint` must begin with `http://` and `host` can be a domain name or IP. For `Queue`, enter `QueueName`. Note that currently the push service cannot push messages to a VPC; therefore, if a VPC domain name or address is entered for `Endpoint`, pushed messages will not be received. Currently, messages can be pushed only to the public network and classic network.
        :rtype: str
        """
        return self._Endpoint

    @Endpoint.setter
    def Endpoint(self, Endpoint):
        self._Endpoint = Endpoint

    @property
    def NotifyStrategy(self):
        r"""CMQ push server retry policy in case an error occurs while pushing a message to `Endpoint`. Valid values: 1. BACKOFF_RETRY: backoff retry, which is to retry at a fixed interval, discard the message after a certain number of retries, and continue to push the next message; 2. EXPONENTIAL_DECAY_RETRY: exponential decay retry, which is to retry at an exponentially increasing interval, such as 1s, 2s, 4s, 8s, and so on. As a message can be retained in a topic for one day, failed messages will be discarded at most after one day of retry. Default value: EXPONENTIAL_DECAY_RETRY.
        :rtype: str
        """
        return self._NotifyStrategy

    @NotifyStrategy.setter
    def NotifyStrategy(self, NotifyStrategy):
        self._NotifyStrategy = NotifyStrategy

    @property
    def FilterTag(self):
        r"""Message body tag (used for message filtering). The number of tags cannot exceed 5, and each tag can contain up to 16 characters. It is used in conjunction with the `MsgTag` parameter of `(Batch)PublishMessage`. Rules: 1. If `FilterTag` is not configured, no matter whether `MsgTag` is configured, the subscription will receive all messages published to the topic; 2. If the array of `FilterTag` values has a value, only when at least one of the values in the array also exists in the array of `MsgTag` values (i.e., `FilterTag` and `MsgTag` have an intersection) can the subscription receive messages published to the topic; 3. If the array of `FilterTag` values has a value, but `MsgTag` is not configured, then no message published to the topic will be received, which can be considered as a special case of rule 2 as `FilterTag` and `MsgTag` do not intersect in this case. The overall design idea of rules is based on the intention of the subscriber.
        :rtype: list of str
        """
        return self._FilterTag

    @FilterTag.setter
    def FilterTag(self, FilterTag):
        self._FilterTag = FilterTag

    @property
    def BindingKey(self):
        r"""The number of `BindingKey` cannot exceed 5, and the length of each `BindingKey` cannot exceed 64 bytes. This field indicates the filtering policy for subscribing to and receiving messages. Each `BindingKey` includes up to 15 dots (namely up to 16 segments).
        :rtype: list of str
        """
        return self._BindingKey

    @BindingKey.setter
    def BindingKey(self, BindingKey):
        self._BindingKey = BindingKey

    @property
    def NotifyContentFormat(self):
        r"""Push content format. Valid values: 1. JSON; 2. SIMPLIFIED, i.e., the raw format. If `Protocol` is `queue`, this value must be `SIMPLIFIED`. If `Protocol` is `http`, both options are acceptable, and the default value is `JSON`.
        :rtype: str
        """
        return self._NotifyContentFormat

    @NotifyContentFormat.setter
    def NotifyContentFormat(self, NotifyContentFormat):
        self._NotifyContentFormat = NotifyContentFormat


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._SubscriptionName = params.get("SubscriptionName")
        self._Protocol = params.get("Protocol")
        self._Endpoint = params.get("Endpoint")
        self._NotifyStrategy = params.get("NotifyStrategy")
        self._FilterTag = params.get("FilterTag")
        self._BindingKey = params.get("BindingKey")
        self._NotifyContentFormat = params.get("NotifyContentFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCmqSubscribeResponse(AbstractModel):
    r"""CreateCmqSubscribe response structure.

    """

    def __init__(self):
        r"""
        :param _SubscriptionId: Subscription ID
        :type SubscriptionId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubscriptionId = None
        self._RequestId = None

    @property
    def SubscriptionId(self):
        r"""Subscription ID
        :rtype: str
        """
        return self._SubscriptionId

    @SubscriptionId.setter
    def SubscriptionId(self, SubscriptionId):
        self._SubscriptionId = SubscriptionId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubscriptionId = params.get("SubscriptionId")
        self._RequestId = params.get("RequestId")


class CreateCmqTopicRequest(AbstractModel):
    r"""CreateCmqTopic request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _MaxMsgSize: Maximum message length. Value range: 1024–65536 bytes (i.e., 1–64 KB). Default value: 65536.
        :type MaxMsgSize: int
        :param _FilterType: Used to specify the message match policy for the topic. 1: tag match policy (default value); 2: routing match policy.
        :type FilterType: int
        :param _MsgRetentionSeconds: Message retention period. Value range: 60–86400 seconds (i.e., 1 minute–1 day). Default value: 86400.
        :type MsgRetentionSeconds: int
        :param _Trace: Whether to enable message trace. true: yes; false: no. If this field is left empty, the feature will not be enabled.
        :type Trace: bool
        :param _Tags: Tag array.
        :type Tags: list of Tag
        """
        self._TopicName = None
        self._MaxMsgSize = None
        self._FilterType = None
        self._MsgRetentionSeconds = None
        self._Trace = None
        self._Tags = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MaxMsgSize(self):
        r"""Maximum message length. Value range: 1024–65536 bytes (i.e., 1–64 KB). Default value: 65536.
        :rtype: int
        """
        return self._MaxMsgSize

    @MaxMsgSize.setter
    def MaxMsgSize(self, MaxMsgSize):
        self._MaxMsgSize = MaxMsgSize

    @property
    def FilterType(self):
        r"""Used to specify the message match policy for the topic. 1: tag match policy (default value); 2: routing match policy.
        :rtype: int
        """
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def MsgRetentionSeconds(self):
        r"""Message retention period. Value range: 60–86400 seconds (i.e., 1 minute–1 day). Default value: 86400.
        :rtype: int
        """
        return self._MsgRetentionSeconds

    @MsgRetentionSeconds.setter
    def MsgRetentionSeconds(self, MsgRetentionSeconds):
        self._MsgRetentionSeconds = MsgRetentionSeconds

    @property
    def Trace(self):
        r"""Whether to enable message trace. true: yes; false: no. If this field is left empty, the feature will not be enabled.
        :rtype: bool
        """
        return self._Trace

    @Trace.setter
    def Trace(self, Trace):
        self._Trace = Trace

    @property
    def Tags(self):
        r"""Tag array.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._MaxMsgSize = params.get("MaxMsgSize")
        self._FilterType = params.get("FilterType")
        self._MsgRetentionSeconds = params.get("MsgRetentionSeconds")
        self._Trace = params.get("Trace")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCmqTopicResponse(AbstractModel):
    r"""CreateCmqTopic response structure.

    """

    def __init__(self):
        r"""
        :param _TopicId: Topic ID
        :type TopicId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicId = None
        self._RequestId = None

    @property
    def TopicId(self):
        r"""Topic ID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._RequestId = params.get("RequestId")


class CreateEnvironmentRequest(AbstractModel):
    r"""CreateEnvironment request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name, which can contain up to 16 letters, digits, hyphens, and underscores.
        :type EnvironmentId: str
        :param _MsgTTL: Retention period for unconsumed messages in seconds. Value range: 60s to 1,296,000s (or 15 days).
        :type MsgTTL: int
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _RetentionPolicy: Message retention policy
        :type RetentionPolicy: :class:`tencentcloud.tdmq.v20200217.models.RetentionPolicy`
        :param _AutoSubscriptionCreation: Whether to enable "Auto-Create Subscription"
        :type AutoSubscriptionCreation: bool
        """
        self._EnvironmentId = None
        self._MsgTTL = None
        self._ClusterId = None
        self._Remark = None
        self._RetentionPolicy = None
        self._AutoSubscriptionCreation = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name, which can contain up to 16 letters, digits, hyphens, and underscores.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def MsgTTL(self):
        r"""Retention period for unconsumed messages in seconds. Value range: 60s to 1,296,000s (or 15 days).
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RetentionPolicy(self):
        r"""Message retention policy
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RetentionPolicy`
        """
        return self._RetentionPolicy

    @RetentionPolicy.setter
    def RetentionPolicy(self, RetentionPolicy):
        self._RetentionPolicy = RetentionPolicy

    @property
    def AutoSubscriptionCreation(self):
        r"""Whether to enable "Auto-Create Subscription"
        :rtype: bool
        """
        return self._AutoSubscriptionCreation

    @AutoSubscriptionCreation.setter
    def AutoSubscriptionCreation(self, AutoSubscriptionCreation):
        self._AutoSubscriptionCreation = AutoSubscriptionCreation


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._MsgTTL = params.get("MsgTTL")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        if params.get("RetentionPolicy") is not None:
            self._RetentionPolicy = RetentionPolicy()
            self._RetentionPolicy._deserialize(params.get("RetentionPolicy"))
        self._AutoSubscriptionCreation = params.get("AutoSubscriptionCreation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEnvironmentResponse(AbstractModel):
    r"""CreateEnvironment response structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _MsgTTL: TTL for unconsumed messages in seconds.
        :type MsgTTL: int
        :param _Remark: Remarks (up to 128 characters).
Note: this field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _NamespaceId: Namespace ID
        :type NamespaceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EnvironmentId = None
        self._MsgTTL = None
        self._Remark = None
        self._NamespaceId = None
        self._RequestId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def MsgTTL(self):
        r"""TTL for unconsumed messages in seconds.
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def NamespaceId(self):
        r"""Namespace ID
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._MsgTTL = params.get("MsgTTL")
        self._Remark = params.get("Remark")
        self._NamespaceId = params.get("NamespaceId")
        self._RequestId = params.get("RequestId")


class CreateEnvironmentRoleRequest(AbstractModel):
    r"""CreateEnvironmentRole request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Permissions: Permissions, which is a non-empty string array of `produce` and `consume` at the most.
        :type Permissions: list of str
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._RoleName = None
        self._Permissions = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Permissions(self):
        r"""Permissions, which is a non-empty string array of `produce` and `consume` at the most.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleName = params.get("RoleName")
        self._Permissions = params.get("Permissions")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEnvironmentRoleResponse(AbstractModel):
    r"""CreateEnvironmentRole response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateProClusterRequest(AbstractModel):
    r"""CreateProCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneIds: Specifies multi-az deployment with three azs, for example [200002,200003,200004].

Single-AZ deployment selects an availability zone. example: [200002].
        :type ZoneIds: list of int
        :param _ProductName: Cluster specification code.
Refers to professional cluster specifications (https://www.tencentcloud.comom/document/product/1179/83705?from_cn_redirect=1).
        :type ProductName: str
        :param _StorageSize: Specifies the storage specification.
Refers to professional cluster specifications (https://www.tencentcloud.comom/document/product/1179/83705?from_cn_redirect=1).
        :type StorageSize: int
        :param _AutoRenewFlag: `1`: true. enables automatic monthly renewal.

false. disables automatic monthly renewal.
        :type AutoRenewFlag: int
        :param _TimeSpan: Purchase duration. value range: 1–50.
        :type TimeSpan: int
        :param _ClusterName: Specifies the cluster name, which does not support chinese characters and special characters other than hyphens and underscores, with a length of no more than 64 characters.
        :type ClusterName: str
        :param _AutoVoucher: Whether to automatically select voucher. valid values: 1 (yes), 0 (no). default is 0.
        :type AutoVoucher: int
        :param _Vpc: Specifies the vpc network tag.
        :type Vpc: :class:`tencentcloud.tdmq.v20200217.models.VpcInfo`
        :param _Tags: Tag list of the cluster (abandoned).
        :type Tags: list of Tag
        """
        self._ZoneIds = None
        self._ProductName = None
        self._StorageSize = None
        self._AutoRenewFlag = None
        self._TimeSpan = None
        self._ClusterName = None
        self._AutoVoucher = None
        self._Vpc = None
        self._Tags = None

    @property
    def ZoneIds(self):
        r"""Specifies multi-az deployment with three azs, for example [200002,200003,200004].

Single-AZ deployment selects an availability zone. example: [200002].
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def ProductName(self):
        r"""Cluster specification code.
Refers to professional cluster specifications (https://www.tencentcloud.comom/document/product/1179/83705?from_cn_redirect=1).
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def StorageSize(self):
        r"""Specifies the storage specification.
Refers to professional cluster specifications (https://www.tencentcloud.comom/document/product/1179/83705?from_cn_redirect=1).
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def AutoRenewFlag(self):
        r"""`1`: true. enables automatic monthly renewal.

false. disables automatic monthly renewal.
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def TimeSpan(self):
        r"""Purchase duration. value range: 1–50.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def ClusterName(self):
        r"""Specifies the cluster name, which does not support chinese characters and special characters other than hyphens and underscores, with a length of no more than 64 characters.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def AutoVoucher(self):
        r"""Whether to automatically select voucher. valid values: 1 (yes), 0 (no). default is 0.
        :rtype: int
        """
        return self._AutoVoucher

    @AutoVoucher.setter
    def AutoVoucher(self, AutoVoucher):
        self._AutoVoucher = AutoVoucher

    @property
    def Vpc(self):
        r"""Specifies the vpc network tag.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.VpcInfo`
        """
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def Tags(self):
        r"""Tag list of the cluster (abandoned).
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ZoneIds = params.get("ZoneIds")
        self._ProductName = params.get("ProductName")
        self._StorageSize = params.get("StorageSize")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._TimeSpan = params.get("TimeSpan")
        self._ClusterName = params.get("ClusterName")
        self._AutoVoucher = params.get("AutoVoucher")
        if params.get("Vpc") is not None:
            self._Vpc = VpcInfo()
            self._Vpc._deserialize(params.get("Vpc"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProClusterResponse(AbstractModel):
    r"""CreateProCluster response structure.

    """

    def __init__(self):
        r"""
        :param _DealName: Specifies the sub-order number.
        :type DealName: str
        :param _BigDealId: Order ID
        :type BigDealId: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name.
        :type ClusterName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DealName = None
        self._BigDealId = None
        self._ClusterId = None
        self._ClusterName = None
        self._RequestId = None

    @property
    def DealName(self):
        r"""Specifies the sub-order number.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def BigDealId(self):
        r"""Order ID
        :rtype: str
        """
        return self._BigDealId

    @BigDealId.setter
    def BigDealId(self, BigDealId):
        self._BigDealId = BigDealId

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DealName = params.get("DealName")
        self._BigDealId = params.get("BigDealId")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._RequestId = params.get("RequestId")


class CreateRabbitMQBindingRequest(AbstractModel):
    r"""CreateRabbitMQBinding request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _Source: Source exchange.
        :type Source: str
        :param _DestinationType: Target type. Valid values: queue, exchange.
        :type DestinationType: str
        :param _Destination: Target
        :type Destination: str
        :param _RoutingKey: Routing key
        :type RoutingKey: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Source = None
        self._DestinationType = None
        self._Destination = None
        self._RoutingKey = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Source(self):
        r"""Source exchange.
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def DestinationType(self):
        r"""Target type. Valid values: queue, exchange.
        :rtype: str
        """
        return self._DestinationType

    @DestinationType.setter
    def DestinationType(self, DestinationType):
        self._DestinationType = DestinationType

    @property
    def Destination(self):
        r"""Target
        :rtype: str
        """
        return self._Destination

    @Destination.setter
    def Destination(self, Destination):
        self._Destination = Destination

    @property
    def RoutingKey(self):
        r"""Routing key
        :rtype: str
        """
        return self._RoutingKey

    @RoutingKey.setter
    def RoutingKey(self, RoutingKey):
        self._RoutingKey = RoutingKey


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Source = params.get("Source")
        self._DestinationType = params.get("DestinationType")
        self._Destination = params.get("Destination")
        self._RoutingKey = params.get("RoutingKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRabbitMQBindingResponse(AbstractModel):
    r"""CreateRabbitMQBinding response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _VirtualHost: Vhost name
        :type VirtualHost: str
        :param _BindingId: Routing relationship ID.
        :type BindingId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._BindingId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost name
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def BindingId(self):
        r"""Routing relationship ID.
        :rtype: int
        """
        return self._BindingId

    @BindingId.setter
    def BindingId(self, BindingId):
        self._BindingId = BindingId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._BindingId = params.get("BindingId")
        self._RequestId = params.get("RequestId")


class CreateRabbitMQUserRequest(AbstractModel):
    r"""CreateRabbitMQUser request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, which is used for login.
        :type User: str
        :param _Password: Password, used when logging in. requirement: cannot be empty, 8-64 characters, must contain at least two items from lowercase letters, uppercase letters, digits, and special characters [`()~!@#$%^&*_=|{}[]:;',.?/].
        :type Password: str
        :param _Description: Description
        :type Description: str
        :param _Tags: User tag, which defines a user's permission scope for accessing RabbitMQ Managementu.
Valid values: `management` (Common console user), monitoring` (Console admin user), other values: Non-console user.
        :type Tags: list of str
        :param _MaxConnections: The maximum number of connections for the user. If this parameter is left empty, there's no limit for the number.
        :type MaxConnections: int
        :param _MaxChannels: The maximum number of channels for the user. If this parameter is left empty, there's no limit for the number.
        :type MaxChannels: int
        """
        self._InstanceId = None
        self._User = None
        self._Password = None
        self._Description = None
        self._Tags = None
        self._MaxConnections = None
        self._MaxChannels = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, which is used for login.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Password(self):
        r"""Password, used when logging in. requirement: cannot be empty, 8-64 characters, must contain at least two items from lowercase letters, uppercase letters, digits, and special characters [`()~!@#$%^&*_=|{}[]:;',.?/].
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        r"""User tag, which defines a user's permission scope for accessing RabbitMQ Managementu.
Valid values: `management` (Common console user), monitoring` (Console admin user), other values: Non-console user.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def MaxConnections(self):
        r"""The maximum number of connections for the user. If this parameter is left empty, there's no limit for the number.
        :rtype: int
        """
        return self._MaxConnections

    @MaxConnections.setter
    def MaxConnections(self, MaxConnections):
        self._MaxConnections = MaxConnections

    @property
    def MaxChannels(self):
        r"""The maximum number of channels for the user. If this parameter is left empty, there's no limit for the number.
        :rtype: int
        """
        return self._MaxChannels

    @MaxChannels.setter
    def MaxChannels(self, MaxChannels):
        self._MaxChannels = MaxChannels


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._Password = params.get("Password")
        self._Description = params.get("Description")
        self._Tags = params.get("Tags")
        self._MaxConnections = params.get("MaxConnections")
        self._MaxChannels = params.get("MaxChannels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRabbitMQUserResponse(AbstractModel):
    r"""CreateRabbitMQUser response structure.

    """

    def __init__(self):
        r"""
        :param _User: Username, which is used for login.
        :type User: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._User = None
        self._RequestId = None

    @property
    def User(self):
        r"""Username, which is used for login.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._User = params.get("User")
        self._RequestId = params.get("RequestId")


class CreateRabbitMQVipInstanceRequest(AbstractModel):
    r"""CreateRabbitMQVipInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneIds: AZ
        :type ZoneIds: list of int
        :param _VpcId: vpc ID, such as vpc-xxx. valid VpcId can be obtained by logging in to the virtual private cloud console (https://console.cloud.tencent.com/vpc/vpc?rid=1) or via api call to DescribeVpcEx (https://www.tencentcloud.comom/document/api/215/1372?from_cn_redirect=1), retrieving the unVpcId field from the api response. if both VpcId and SubnetId are set to DEFAULT when creating an instance, the DEFAULT vpc network will be forcibly used.
        :type VpcId: str
        :param _SubnetId: The subnet ID of the vpc, such as subnet-xxx. valid subnet ids can be queried by logging in to the subnet console (https://console.cloud.tencent.com/vpc/subnet?rid=1) or by calling the api [DescribeSubnets](https://www.tencentcloud.comom/document/api/215/15784?from_cn_redirect=1) and obtaining the unSubnetId field from the api response. if both SubnetId and VpcId are set to DEFAULT when creating an instance, the DEFAULT vpc network will be forcibly used.
        :type SubnetId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _NodeSpec: Node specification of the cluster. need to enter the corresponding specification flag.
2C8G:rabbit-vip-profession-2c8g
4C16G:rabbit-vip-profession-4c16g
8C32G:rabbit-vip-profession-8c32g
16C32G:rabbit-vip-basic-4
16C64G:rabbit-vip-profession-16c64g
2C4G:rabbit-vip-basic-5
4C8G:rabbit-vip-basic-1
8C16G (sold out): rabbit-vip-basic-2.
Specifies the default value as 4C8G: rabbit-vip-basic-1.
        :type NodeSpec: str
        :param _NodeNum: Number of nodes, which is at least three for multi-AZ deployment. If this parameter is left empty, the value will be set to 1 for single-AZ deployment and 3 for multi-AZ deployment by default.
        :type NodeNum: int
        :param _StorageSize: Storage capacity of a single node, which is 200 GB by default.
        :type StorageSize: int
        :param _EnableCreateDefaultHaMirrorQueue: Whether the default image queue is enabled. true means enabled, false means not enabled. defaults to false if not specified.
        :type EnableCreateDefaultHaMirrorQueue: bool
        :param _AutoRenewFlag: Only applies to prepaid clusters (when PayMode parameter is 1). specifies whether the cluster is automatically renewed. true means auto-renewal is enabled. the default is true if not specified.
        :type AutoRenewFlag: bool
        :param _TimeSpan: Validity period, which is one month by default.
        :type TimeSpan: int
        :param _PayMode: Payment mode. 0: postpaid, (pay-as-you-go); 1: prepaid (monthly subscription). Monthly subscription is used by default.
        :type PayMode: int
        :param _ClusterVersion: Specifies the cluster edition. defaults to 3.8.30. valid values: 3.8.30, 3.11.8, 3.13.7.
        :type ClusterVersion: str
        :param _IsIntl: Whether the request is from the international website. Default value: false.
        :type IsIntl: bool
        :param _ResourceTags: Resource tag list.
        :type ResourceTags: list of Tag
        :param _Bandwidth: Specifies the public bandwidth size in Mbps.
        :type Bandwidth: int
        :param _EnablePublicAccess: Whether to enable public network access. If this parameter is not specified, the value is false by default.
        :type EnablePublicAccess: bool
        :param _EnableDeletionProtection: Whether to enable cluster deletion protection. if this parameter is not specified, the value is false by default.
        :type EnableDeletionProtection: bool
        """
        self._ZoneIds = None
        self._VpcId = None
        self._SubnetId = None
        self._ClusterName = None
        self._NodeSpec = None
        self._NodeNum = None
        self._StorageSize = None
        self._EnableCreateDefaultHaMirrorQueue = None
        self._AutoRenewFlag = None
        self._TimeSpan = None
        self._PayMode = None
        self._ClusterVersion = None
        self._IsIntl = None
        self._ResourceTags = None
        self._Bandwidth = None
        self._EnablePublicAccess = None
        self._EnableDeletionProtection = None

    @property
    def ZoneIds(self):
        r"""AZ
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def VpcId(self):
        r"""vpc ID, such as vpc-xxx. valid VpcId can be obtained by logging in to the virtual private cloud console (https://console.cloud.tencent.com/vpc/vpc?rid=1) or via api call to DescribeVpcEx (https://www.tencentcloud.comom/document/api/215/1372?from_cn_redirect=1), retrieving the unVpcId field from the api response. if both VpcId and SubnetId are set to DEFAULT when creating an instance, the DEFAULT vpc network will be forcibly used.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""The subnet ID of the vpc, such as subnet-xxx. valid subnet ids can be queried by logging in to the subnet console (https://console.cloud.tencent.com/vpc/subnet?rid=1) or by calling the api [DescribeSubnets](https://www.tencentcloud.comom/document/api/215/15784?from_cn_redirect=1) and obtaining the unSubnetId field from the api response. if both SubnetId and VpcId are set to DEFAULT when creating an instance, the DEFAULT vpc network will be forcibly used.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def NodeSpec(self):
        r"""Node specification of the cluster. need to enter the corresponding specification flag.
2C8G:rabbit-vip-profession-2c8g
4C16G:rabbit-vip-profession-4c16g
8C32G:rabbit-vip-profession-8c32g
16C32G:rabbit-vip-basic-4
16C64G:rabbit-vip-profession-16c64g
2C4G:rabbit-vip-basic-5
4C8G:rabbit-vip-basic-1
8C16G (sold out): rabbit-vip-basic-2.
Specifies the default value as 4C8G: rabbit-vip-basic-1.
        :rtype: str
        """
        return self._NodeSpec

    @NodeSpec.setter
    def NodeSpec(self, NodeSpec):
        self._NodeSpec = NodeSpec

    @property
    def NodeNum(self):
        r"""Number of nodes, which is at least three for multi-AZ deployment. If this parameter is left empty, the value will be set to 1 for single-AZ deployment and 3 for multi-AZ deployment by default.
        :rtype: int
        """
        return self._NodeNum

    @NodeNum.setter
    def NodeNum(self, NodeNum):
        self._NodeNum = NodeNum

    @property
    def StorageSize(self):
        r"""Storage capacity of a single node, which is 200 GB by default.
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def EnableCreateDefaultHaMirrorQueue(self):
        r"""Whether the default image queue is enabled. true means enabled, false means not enabled. defaults to false if not specified.
        :rtype: bool
        """
        return self._EnableCreateDefaultHaMirrorQueue

    @EnableCreateDefaultHaMirrorQueue.setter
    def EnableCreateDefaultHaMirrorQueue(self, EnableCreateDefaultHaMirrorQueue):
        self._EnableCreateDefaultHaMirrorQueue = EnableCreateDefaultHaMirrorQueue

    @property
    def AutoRenewFlag(self):
        r"""Only applies to prepaid clusters (when PayMode parameter is 1). specifies whether the cluster is automatically renewed. true means auto-renewal is enabled. the default is true if not specified.
        :rtype: bool
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def TimeSpan(self):
        r"""Validity period, which is one month by default.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PayMode(self):
        r"""Payment mode. 0: postpaid, (pay-as-you-go); 1: prepaid (monthly subscription). Monthly subscription is used by default.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ClusterVersion(self):
        r"""Specifies the cluster edition. defaults to 3.8.30. valid values: 3.8.30, 3.11.8, 3.13.7.
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def IsIntl(self):
        r"""Whether the request is from the international website. Default value: false.
        :rtype: bool
        """
        return self._IsIntl

    @IsIntl.setter
    def IsIntl(self, IsIntl):
        self._IsIntl = IsIntl

    @property
    def ResourceTags(self):
        r"""Resource tag list.
        :rtype: list of Tag
        """
        return self._ResourceTags

    @ResourceTags.setter
    def ResourceTags(self, ResourceTags):
        self._ResourceTags = ResourceTags

    @property
    def Bandwidth(self):
        r"""Specifies the public bandwidth size in Mbps.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def EnablePublicAccess(self):
        r"""Whether to enable public network access. If this parameter is not specified, the value is false by default.
        :rtype: bool
        """
        return self._EnablePublicAccess

    @EnablePublicAccess.setter
    def EnablePublicAccess(self, EnablePublicAccess):
        self._EnablePublicAccess = EnablePublicAccess

    @property
    def EnableDeletionProtection(self):
        r"""Whether to enable cluster deletion protection. if this parameter is not specified, the value is false by default.
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection


    def _deserialize(self, params):
        self._ZoneIds = params.get("ZoneIds")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._ClusterName = params.get("ClusterName")
        self._NodeSpec = params.get("NodeSpec")
        self._NodeNum = params.get("NodeNum")
        self._StorageSize = params.get("StorageSize")
        self._EnableCreateDefaultHaMirrorQueue = params.get("EnableCreateDefaultHaMirrorQueue")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._TimeSpan = params.get("TimeSpan")
        self._PayMode = params.get("PayMode")
        self._ClusterVersion = params.get("ClusterVersion")
        self._IsIntl = params.get("IsIntl")
        if params.get("ResourceTags") is not None:
            self._ResourceTags = []
            for item in params.get("ResourceTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ResourceTags.append(obj)
        self._Bandwidth = params.get("Bandwidth")
        self._EnablePublicAccess = params.get("EnablePublicAccess")
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRabbitMQVipInstanceResponse(AbstractModel):
    r"""CreateRabbitMQVipInstance response structure.

    """

    def __init__(self):
        r"""
        :param _TranId: Order ID.
        :type TranId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TranId = None
        self._InstanceId = None
        self._RequestId = None

    @property
    def TranId(self):
        r"""Order ID.
        :rtype: str
        """
        return self._TranId

    @TranId.setter
    def TranId(self, TranId):
        self._TranId = TranId

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TranId = params.get("TranId")
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class CreateRabbitMQVirtualHostRequest(AbstractModel):
    r"""CreateRabbitMQVirtualHost request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: Vhost name
        :type VirtualHost: str
        :param _Description: Description
        :type Description: str
        :param _TraceFlag: Message trace flag. Valid values: `true` (Enabled), `false` (Disabled, which is the default value).
        :type TraceFlag: bool
        :param _MirrorQueuePolicyFlag: Whether to create an image queue policy. Default value: true.
        :type MirrorQueuePolicyFlag: bool
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Description = None
        self._TraceFlag = None
        self._MirrorQueuePolicyFlag = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost name
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def TraceFlag(self):
        r"""Message trace flag. Valid values: `true` (Enabled), `false` (Disabled, which is the default value).
        :rtype: bool
        """
        return self._TraceFlag

    @TraceFlag.setter
    def TraceFlag(self, TraceFlag):
        self._TraceFlag = TraceFlag

    @property
    def MirrorQueuePolicyFlag(self):
        r"""Whether to create an image queue policy. Default value: true.
        :rtype: bool
        """
        return self._MirrorQueuePolicyFlag

    @MirrorQueuePolicyFlag.setter
    def MirrorQueuePolicyFlag(self, MirrorQueuePolicyFlag):
        self._MirrorQueuePolicyFlag = MirrorQueuePolicyFlag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Description = params.get("Description")
        self._TraceFlag = params.get("TraceFlag")
        self._MirrorQueuePolicyFlag = params.get("MirrorQueuePolicyFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRabbitMQVirtualHostResponse(AbstractModel):
    r"""CreateRabbitMQVirtualHost response structure.

    """

    def __init__(self):
        r"""
        :param _VirtualHost: Vhost name
        :type VirtualHost: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VirtualHost = None
        self._RequestId = None

    @property
    def VirtualHost(self):
        r"""Vhost name
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VirtualHost = params.get("VirtualHost")
        self._RequestId = params.get("RequestId")


class CreateRocketMQClusterRequest(AbstractModel):
    r"""CreateRocketMQCluster request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Cluster name, which can contain 3–64 letters, digits, hyphens, and underscores
        :type Name: str
        :param _Remark: Cluster description (up to 128 characters)
        :type Remark: str
        :param _TagList: Tag list
        :type TagList: list of Tag
        """
        self._Name = None
        self._Remark = None
        self._TagList = None

    @property
    def Name(self):
        r"""Cluster name, which can contain 3–64 letters, digits, hyphens, and underscores
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Cluster description (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TagList(self):
        r"""Tag list
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQClusterResponse(AbstractModel):
    r"""CreateRocketMQCluster response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class CreateRocketMQEnvironmentRoleRequest(AbstractModel):
    r"""CreateRocketMQEnvironmentRole request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Namespace
        :type EnvironmentId: str
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Permissions: Authorization item, which can contain a non-empty character array of up to 2 items including produce and consume.
        :type Permissions: list of str
        :param _ClusterId: Required field, cluster ID
        :type ClusterId: str
        :param _DetailedPerms: Permission configuration for topic and group dimensions.
        :type DetailedPerms: list of DetailedRolePerm
        """
        self._EnvironmentId = None
        self._RoleName = None
        self._Permissions = None
        self._ClusterId = None
        self._DetailedPerms = None

    @property
    def EnvironmentId(self):
        r"""Namespace
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Permissions(self):
        r"""Authorization item, which can contain a non-empty character array of up to 2 items including produce and consume.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def ClusterId(self):
        r"""Required field, cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DetailedPerms(self):
        r"""Permission configuration for topic and group dimensions.
        :rtype: list of DetailedRolePerm
        """
        return self._DetailedPerms

    @DetailedPerms.setter
    def DetailedPerms(self, DetailedPerms):
        self._DetailedPerms = DetailedPerms


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleName = params.get("RoleName")
        self._Permissions = params.get("Permissions")
        self._ClusterId = params.get("ClusterId")
        if params.get("DetailedPerms") is not None:
            self._DetailedPerms = []
            for item in params.get("DetailedPerms"):
                obj = DetailedRolePerm()
                obj._deserialize(item)
                self._DetailedPerms.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQEnvironmentRoleResponse(AbstractModel):
    r"""CreateRocketMQEnvironmentRole response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRocketMQGroupRequest(AbstractModel):
    r"""CreateRocketMQGroup request structure.

    """

    def __init__(self):
        r"""
        :param _GroupId: Group name (8–64 characters)
        :type GroupId: str
        :param _Namespaces: Namespace. Currently, only one namespace is supported
        :type Namespaces: list of str
        :param _ReadEnable: Whether to enable consumption
        :type ReadEnable: bool
        :param _BroadcastEnable: Whether to enable broadcast consumption
        :type BroadcastEnable: bool
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters)
        :type Remark: str
        :param _GroupType: Group type (`TCP`, `HTTP`)
        :type GroupType: str
        :param _RetryMaxTimes: The maximum number of retries for a group
        :type RetryMaxTimes: int
        """
        self._GroupId = None
        self._Namespaces = None
        self._ReadEnable = None
        self._BroadcastEnable = None
        self._ClusterId = None
        self._Remark = None
        self._GroupType = None
        self._RetryMaxTimes = None

    @property
    def GroupId(self):
        r"""Group name (8–64 characters)
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Namespaces(self):
        r"""Namespace. Currently, only one namespace is supported
        :rtype: list of str
        """
        return self._Namespaces

    @Namespaces.setter
    def Namespaces(self, Namespaces):
        self._Namespaces = Namespaces

    @property
    def ReadEnable(self):
        r"""Whether to enable consumption
        :rtype: bool
        """
        return self._ReadEnable

    @ReadEnable.setter
    def ReadEnable(self, ReadEnable):
        self._ReadEnable = ReadEnable

    @property
    def BroadcastEnable(self):
        r"""Whether to enable broadcast consumption
        :rtype: bool
        """
        return self._BroadcastEnable

    @BroadcastEnable.setter
    def BroadcastEnable(self, BroadcastEnable):
        self._BroadcastEnable = BroadcastEnable

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def GroupType(self):
        r"""Group type (`TCP`, `HTTP`)
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def RetryMaxTimes(self):
        r"""The maximum number of retries for a group
        :rtype: int
        """
        return self._RetryMaxTimes

    @RetryMaxTimes.setter
    def RetryMaxTimes(self, RetryMaxTimes):
        self._RetryMaxTimes = RetryMaxTimes


    def _deserialize(self, params):
        self._GroupId = params.get("GroupId")
        self._Namespaces = params.get("Namespaces")
        self._ReadEnable = params.get("ReadEnable")
        self._BroadcastEnable = params.get("BroadcastEnable")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._GroupType = params.get("GroupType")
        self._RetryMaxTimes = params.get("RetryMaxTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQGroupResponse(AbstractModel):
    r"""CreateRocketMQGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRocketMQNamespaceRequest(AbstractModel):
    r"""CreateRocketMQNamespace request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace name, which can contain 3–64 letters, digits, hyphens, and underscores
        :type NamespaceId: str
        :param _Ttl: This parameter is disused.
        :type Ttl: int
        :param _RetentionTime: This parameter is disused.
        :type RetentionTime: int
        :param _Remark: Remarks (up to 128 characters)
        :type Remark: str
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._Ttl = None
        self._RetentionTime = None
        self._Remark = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name, which can contain 3–64 letters, digits, hyphens, and underscores
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Ttl(self):
        r"""This parameter is disused.
        :rtype: int
        """
        return self._Ttl

    @Ttl.setter
    def Ttl(self, Ttl):
        self._Ttl = Ttl

    @property
    def RetentionTime(self):
        r"""This parameter is disused.
        :rtype: int
        """
        return self._RetentionTime

    @RetentionTime.setter
    def RetentionTime(self, RetentionTime):
        self._RetentionTime = RetentionTime

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Ttl = params.get("Ttl")
        self._RetentionTime = params.get("RetentionTime")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQNamespaceResponse(AbstractModel):
    r"""CreateRocketMQNamespace response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRocketMQRoleRequest(AbstractModel):
    r"""CreateRocketMQRole request structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name. Does not support Chinese characters and special characters other than hyphens (-) and underscores (_), and must be greater than 0 and less than or equal to 32 in length.
        :type RoleName: str
        :param _ClusterId: Required field, cluster ID
        :type ClusterId: str
        :param _Remark: Remark description. Length must be greater than or equal to 0 and less than or equal to 128.
        :type Remark: str
        :param _PermType: Role authorization type (cluster: Cluster; topic or consumer group: TopicAndGroup).
        :type PermType: str
        """
        self._RoleName = None
        self._ClusterId = None
        self._Remark = None
        self._PermType = None

    @property
    def RoleName(self):
        r"""Role name. Does not support Chinese characters and special characters other than hyphens (-) and underscores (_), and must be greater than 0 and less than or equal to 32 in length.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def ClusterId(self):
        r"""Required field, cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remark description. Length must be greater than or equal to 0 and less than or equal to 128.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PermType(self):
        r"""Role authorization type (cluster: Cluster; topic or consumer group: TopicAndGroup).
        :rtype: str
        """
        return self._PermType

    @PermType.setter
    def PermType(self, PermType):
        self._PermType = PermType


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._PermType = params.get("PermType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQRoleResponse(AbstractModel):
    r"""CreateRocketMQRole response structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Token: Role token.
        :type Token: str
        :param _Remark: Specifies the remark description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleName = None
        self._Token = None
        self._Remark = None
        self._RequestId = None

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Token(self):
        r"""Role token.
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Remark(self):
        r"""Specifies the remark description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._Token = params.get("Token")
        self._Remark = params.get("Remark")
        self._RequestId = params.get("RequestId")


class CreateRocketMQTopicRequest(AbstractModel):
    r"""CreateRocketMQTopic request structure.

    """

    def __init__(self):
        r"""
        :param _Topic: Topic name, which can contain 3–64 letters, digits, hyphens, and underscores
        :type Topic: str
        :param _Namespaces: Topic namespace. Currently, you can create topics only in one single namespace.
        :type Namespaces: list of str
        :param _Type: Topic type. Valid values: Normal, GlobalOrder, PartitionedOrder, Transaction, and DelayScheduled. Transaction is only supported in the Exclusive Edition.
        :type Type: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Remark: Topic remarks (up to 128 characters)
        :type Remark: str
        :param _PartitionNum: Number of partitions, which doesn't take effect for globally sequential messages
        :type PartitionNum: int
        """
        self._Topic = None
        self._Namespaces = None
        self._Type = None
        self._ClusterId = None
        self._Remark = None
        self._PartitionNum = None

    @property
    def Topic(self):
        r"""Topic name, which can contain 3–64 letters, digits, hyphens, and underscores
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Namespaces(self):
        r"""Topic namespace. Currently, you can create topics only in one single namespace.
        :rtype: list of str
        """
        return self._Namespaces

    @Namespaces.setter
    def Namespaces(self, Namespaces):
        self._Namespaces = Namespaces

    @property
    def Type(self):
        r"""Topic type. Valid values: Normal, GlobalOrder, PartitionedOrder, Transaction, and DelayScheduled. Transaction is only supported in the Exclusive Edition.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Topic remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PartitionNum(self):
        r"""Number of partitions, which doesn't take effect for globally sequential messages
        :rtype: int
        """
        return self._PartitionNum

    @PartitionNum.setter
    def PartitionNum(self, PartitionNum):
        self._PartitionNum = PartitionNum


    def _deserialize(self, params):
        self._Topic = params.get("Topic")
        self._Namespaces = params.get("Namespaces")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._PartitionNum = params.get("PartitionNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQTopicResponse(AbstractModel):
    r"""CreateRocketMQTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRocketMQVipInstanceRequest(AbstractModel):
    r"""CreateRocketMQVipInstance request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Instance name
        :type Name: str
        :param _Spec: Cluster specification. Supported specifications: 1. 	General: rocket-vip-basic-0; 2. Basic: rocket-vip-basic-1; 3. Standard: rocket-vip-basic-2; 4. Advanced I: rocket-vip-basic-3; 5. Advanced II: rocket-vip-basic-4.
        :type Spec: str
        :param _NodeCount: Number of nodes. Value range: 2–20.
        :type NodeCount: int
        :param _StorageSize: Single-node storage space, in GB. The minimum space is 200 GB.
        :type StorageSize: int
        :param _ZoneIds: The zone ID list for node deployment. For example, the ID of Guangzhou Zone 1 is 100001. For details, see the official website of the cloud platform.
        :type ZoneIds: list of str
        :param _VpcInfo: Describes the VPC information.
        :type VpcInfo: :class:`tencentcloud.tdmq.v20200217.models.VpcInfo`
        :param _TimeSpan: Purchase duration, in months.
        :type TimeSpan: int
        :param _SupportsMigrateToCloud: Whether it is used for cloud migration. The default value is false.
        :type SupportsMigrateToCloud: bool
        :param _EnablePublic: Specifies whether public network access is enabled.
        :type EnablePublic: bool
        :param _Bandwidth: Public network bandwidth, a required field when the public network is enabled.
        :type Bandwidth: int
        :param _IpRules: Public network allowlist.
        :type IpRules: list of PublicAccessRule
        :param _Tags: Tag.
        :type Tags: list of Tag
        """
        self._Name = None
        self._Spec = None
        self._NodeCount = None
        self._StorageSize = None
        self._ZoneIds = None
        self._VpcInfo = None
        self._TimeSpan = None
        self._SupportsMigrateToCloud = None
        self._EnablePublic = None
        self._Bandwidth = None
        self._IpRules = None
        self._Tags = None

    @property
    def Name(self):
        r"""Instance name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Spec(self):
        r"""Cluster specification. Supported specifications: 1. 	General: rocket-vip-basic-0; 2. Basic: rocket-vip-basic-1; 3. Standard: rocket-vip-basic-2; 4. Advanced I: rocket-vip-basic-3; 5. Advanced II: rocket-vip-basic-4.
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def NodeCount(self):
        r"""Number of nodes. Value range: 2–20.
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def StorageSize(self):
        r"""Single-node storage space, in GB. The minimum space is 200 GB.
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def ZoneIds(self):
        r"""The zone ID list for node deployment. For example, the ID of Guangzhou Zone 1 is 100001. For details, see the official website of the cloud platform.
        :rtype: list of str
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def VpcInfo(self):
        r"""Describes the VPC information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.VpcInfo`
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo

    @property
    def TimeSpan(self):
        r"""Purchase duration, in months.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def SupportsMigrateToCloud(self):
        r"""Whether it is used for cloud migration. The default value is false.
        :rtype: bool
        """
        return self._SupportsMigrateToCloud

    @SupportsMigrateToCloud.setter
    def SupportsMigrateToCloud(self, SupportsMigrateToCloud):
        self._SupportsMigrateToCloud = SupportsMigrateToCloud

    @property
    def EnablePublic(self):
        r"""Specifies whether public network access is enabled.
        :rtype: bool
        """
        return self._EnablePublic

    @EnablePublic.setter
    def EnablePublic(self, EnablePublic):
        self._EnablePublic = EnablePublic

    @property
    def Bandwidth(self):
        r"""Public network bandwidth, a required field when the public network is enabled.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def IpRules(self):
        r"""Public network allowlist.
        :rtype: list of PublicAccessRule
        """
        return self._IpRules

    @IpRules.setter
    def IpRules(self, IpRules):
        self._IpRules = IpRules

    @property
    def Tags(self):
        r"""Tag.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Spec = params.get("Spec")
        self._NodeCount = params.get("NodeCount")
        self._StorageSize = params.get("StorageSize")
        self._ZoneIds = params.get("ZoneIds")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = VpcInfo()
            self._VpcInfo._deserialize(params.get("VpcInfo"))
        self._TimeSpan = params.get("TimeSpan")
        self._SupportsMigrateToCloud = params.get("SupportsMigrateToCloud")
        self._EnablePublic = params.get("EnablePublic")
        self._Bandwidth = params.get("Bandwidth")
        if params.get("IpRules") is not None:
            self._IpRules = []
            for item in params.get("IpRules"):
                obj = PublicAccessRule()
                obj._deserialize(item)
                self._IpRules.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRocketMQVipInstanceResponse(AbstractModel):
    r"""CreateRocketMQVipInstance response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class CreateRoleRequest(AbstractModel):
    r"""CreateRole request structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name, which can contain up to 32 letters, digits, hyphens, and underscores.
        :type RoleName: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        """
        self._RoleName = None
        self._Remark = None
        self._ClusterId = None

    @property
    def RoleName(self):
        r"""Role name, which can contain up to 32 letters, digits, hyphens, and underscores.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._Remark = params.get("Remark")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoleResponse(AbstractModel):
    r"""CreateRole response structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name
        :type RoleName: str
        :param _Token: Role token
        :type Token: str
        :param _Remark: Remarks
Note: this field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _EnvironmentRoleSets: Namespaces that are bound in batches
Note: This field may return null, indicating that no valid values can be obtained.
        :type EnvironmentRoleSets: list of EnvironmentRoleSet
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleName = None
        self._Token = None
        self._Remark = None
        self._EnvironmentRoleSets = None
        self._RequestId = None

    @property
    def RoleName(self):
        r"""Role name
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Token(self):
        r"""Role token
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Remark(self):
        r"""Remarks
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def EnvironmentRoleSets(self):
        r"""Namespaces that are bound in batches
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of EnvironmentRoleSet
        """
        return self._EnvironmentRoleSets

    @EnvironmentRoleSets.setter
    def EnvironmentRoleSets(self, EnvironmentRoleSets):
        self._EnvironmentRoleSets = EnvironmentRoleSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._Token = params.get("Token")
        self._Remark = params.get("Remark")
        if params.get("EnvironmentRoleSets") is not None:
            self._EnvironmentRoleSets = []
            for item in params.get("EnvironmentRoleSets"):
                obj = EnvironmentRoleSet()
                obj._deserialize(item)
                self._EnvironmentRoleSets.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSubscriptionRequest(AbstractModel):
    r"""CreateSubscription request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _SubscriptionName: Subscriber name, which can contain up to 128 characters.
        :type SubscriptionName: str
        :param _IsIdempotent: Whether the creation is idempotent; if not, you cannot create subscriptions with the same name.
        :type IsIdempotent: bool
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _AutoCreatePolicyTopic: Whether to automatically create a dead letter topic and a retry letter topic. true: yes (default value); false: no.
        :type AutoCreatePolicyTopic: bool
        :param _PostFixPattern: Naming convention for dead letter and retry letter topics. `LEGACY` indicates to use the legacy naming convention, and `COMMUNITY` indicates to use the naming convention in the Pulsar community.
        :type PostFixPattern: str
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._SubscriptionName = None
        self._IsIdempotent = None
        self._ClusterId = None
        self._Remark = None
        self._AutoCreatePolicyTopic = None
        self._PostFixPattern = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def SubscriptionName(self):
        r"""Subscriber name, which can contain up to 128 characters.
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def IsIdempotent(self):
        r"""Whether the creation is idempotent; if not, you cannot create subscriptions with the same name.
        :rtype: bool
        """
        return self._IsIdempotent

    @IsIdempotent.setter
    def IsIdempotent(self, IsIdempotent):
        self._IsIdempotent = IsIdempotent

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def AutoCreatePolicyTopic(self):
        r"""Whether to automatically create a dead letter topic and a retry letter topic. true: yes (default value); false: no.
        :rtype: bool
        """
        return self._AutoCreatePolicyTopic

    @AutoCreatePolicyTopic.setter
    def AutoCreatePolicyTopic(self, AutoCreatePolicyTopic):
        self._AutoCreatePolicyTopic = AutoCreatePolicyTopic

    @property
    def PostFixPattern(self):
        r"""Naming convention for dead letter and retry letter topics. `LEGACY` indicates to use the legacy naming convention, and `COMMUNITY` indicates to use the naming convention in the Pulsar community.
        :rtype: str
        """
        return self._PostFixPattern

    @PostFixPattern.setter
    def PostFixPattern(self, PostFixPattern):
        self._PostFixPattern = PostFixPattern


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._SubscriptionName = params.get("SubscriptionName")
        self._IsIdempotent = params.get("IsIdempotent")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._AutoCreatePolicyTopic = params.get("AutoCreatePolicyTopic")
        self._PostFixPattern = params.get("PostFixPattern")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubscriptionResponse(AbstractModel):
    r"""CreateSubscription response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Creation result.
        :type Result: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        r"""Creation result.
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateTopicRequest(AbstractModel):
    r"""CreateTopic request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _TopicName: Topic name, which can contain up to 64 letters, digits, hyphens, and underscores.
        :type TopicName: str
        :param _Partitions: The input parameter is 1, which means creating a non-partitioned topic with no partition. if the input parameter is greater than 1, it indicates the number of partitions for a partitioned topic, and the maximum cannot exceed 32.
        :type Partitions: int
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _TopicType: This input parameter will be disused soon. You can use `PulsarTopicType` instead.
0: General message;
1: Globally sequential message;
2: Partitionally sequential message;
3: Retry letter topic;
4: Dead letter topic.
        :type TopicType: int
        :param _PulsarTopicType: Pulsar topic type.
`0`: Non-persistent and non-partitioned
`1`: Non-persistent and partitioned
`2`: Persistent and non-partitioned
`3`: Persistent and partitioned
        :type PulsarTopicType: int
        :param _MsgTTL: Retention period for unconsumed messages in seconds. value ranges from 60 seconds to 15 days.
        :type MsgTTL: int
        :param _UnackPolicy: Default if not passed is native policy. DefaultPolicy means when the subscription reaches the maximum unacknowledged messages of 5000, the server will stop pushing messages to all consumers under the current subscription. DynamicPolicy means dynamically adjust the maximum unacknowledged messages of the subscription, with the specific quota being the maximum between 5000 and the number of consumers multiplied by 20. the default maximum unacknowledged message count per consumer is 20. exceeding this limit only affects that consumer and does not affect other consumers.
        :type UnackPolicy: str
        :param _IsolateConsumerEnable: Whether exception consumer isolation is enabled.
        :type IsolateConsumerEnable: bool
        :param _AckTimeOut: Specifies the consumer Ack timeout period in seconds. value range: 60-(3600*24).
        :type AckTimeOut: int
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._Partitions = None
        self._ClusterId = None
        self._Remark = None
        self._TopicType = None
        self._PulsarTopicType = None
        self._MsgTTL = None
        self._UnackPolicy = None
        self._IsolateConsumerEnable = None
        self._AckTimeOut = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name, which can contain up to 64 letters, digits, hyphens, and underscores.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Partitions(self):
        r"""The input parameter is 1, which means creating a non-partitioned topic with no partition. if the input parameter is greater than 1, it indicates the number of partitions for a partitioned topic, and the maximum cannot exceed 32.
        :rtype: int
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TopicType(self):
        r"""This input parameter will be disused soon. You can use `PulsarTopicType` instead.
0: General message;
1: Globally sequential message;
2: Partitionally sequential message;
3: Retry letter topic;
4: Dead letter topic.
        :rtype: int
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def PulsarTopicType(self):
        r"""Pulsar topic type.
`0`: Non-persistent and non-partitioned
`1`: Non-persistent and partitioned
`2`: Persistent and non-partitioned
`3`: Persistent and partitioned
        :rtype: int
        """
        return self._PulsarTopicType

    @PulsarTopicType.setter
    def PulsarTopicType(self, PulsarTopicType):
        self._PulsarTopicType = PulsarTopicType

    @property
    def MsgTTL(self):
        r"""Retention period for unconsumed messages in seconds. value ranges from 60 seconds to 15 days.
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def UnackPolicy(self):
        r"""Default if not passed is native policy. DefaultPolicy means when the subscription reaches the maximum unacknowledged messages of 5000, the server will stop pushing messages to all consumers under the current subscription. DynamicPolicy means dynamically adjust the maximum unacknowledged messages of the subscription, with the specific quota being the maximum between 5000 and the number of consumers multiplied by 20. the default maximum unacknowledged message count per consumer is 20. exceeding this limit only affects that consumer and does not affect other consumers.
        :rtype: str
        """
        return self._UnackPolicy

    @UnackPolicy.setter
    def UnackPolicy(self, UnackPolicy):
        self._UnackPolicy = UnackPolicy

    @property
    def IsolateConsumerEnable(self):
        r"""Whether exception consumer isolation is enabled.
        :rtype: bool
        """
        return self._IsolateConsumerEnable

    @IsolateConsumerEnable.setter
    def IsolateConsumerEnable(self, IsolateConsumerEnable):
        self._IsolateConsumerEnable = IsolateConsumerEnable

    @property
    def AckTimeOut(self):
        r"""Specifies the consumer Ack timeout period in seconds. value range: 60-(3600*24).
        :rtype: int
        """
        return self._AckTimeOut

    @AckTimeOut.setter
    def AckTimeOut(self, AckTimeOut):
        self._AckTimeOut = AckTimeOut


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._Partitions = params.get("Partitions")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._TopicType = params.get("TopicType")
        self._PulsarTopicType = params.get("PulsarTopicType")
        self._MsgTTL = params.get("MsgTTL")
        self._UnackPolicy = params.get("UnackPolicy")
        self._IsolateConsumerEnable = params.get("IsolateConsumerEnable")
        self._AckTimeOut = params.get("AckTimeOut")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTopicResponse(AbstractModel):
    r"""CreateTopic response structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _Partitions: Valid value: 0 or 1. Non-partitioned topic: No partitions. A value greater than 1: The partition count of a partitioned topic. `0` is returned for existing non-partitioned topics, and `1` is returned for incremental non-partitioned topics.
        :type Partitions: int
        :param _Remark: Remarks, within 128 characters.
        :type Remark: str
        :param _TopicType: 0: standard message.
Global sequential message.
2: local ordered messages.
Specifies the retry queue.
4: dead letter queue.
        :type TopicType: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._Partitions = None
        self._Remark = None
        self._TopicType = None
        self._RequestId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Partitions(self):
        r"""Valid value: 0 or 1. Non-partitioned topic: No partitions. A value greater than 1: The partition count of a partitioned topic. `0` is returned for existing non-partitioned topics, and `1` is returned for incremental non-partitioned topics.
        :rtype: int
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Remark(self):
        r"""Remarks, within 128 characters.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def TopicType(self):
        r"""0: standard message.
Global sequential message.
2: local ordered messages.
Specifies the retry queue.
4: dead letter queue.
        :rtype: int
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._Partitions = params.get("Partitions")
        self._Remark = params.get("Remark")
        self._TopicType = params.get("TopicType")
        self._RequestId = params.get("RequestId")


class DeleteClusterRequest(AbstractModel):
    r"""DeleteCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of the cluster to be deleted.
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""ID of the cluster to be deleted.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterResponse(AbstractModel):
    r"""DeleteCluster response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class DeleteCmqQueueRequest(AbstractModel):
    r"""DeleteCmqQueue request structure.

    """

    def __init__(self):
        r"""
        :param _QueueName: Queue name, unique under the same account in a single region. queue name is a string of no more than 64 characters, beginning with a letter, the remainder can contain letters, digits, and hyphens (-).
        :type QueueName: str
        """
        self._QueueName = None

    @property
    def QueueName(self):
        r"""Queue name, unique under the same account in a single region. queue name is a string of no more than 64 characters, beginning with a letter, the remainder can contain letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCmqQueueResponse(AbstractModel):
    r"""DeleteCmqQueue response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCmqSubscribeRequest(AbstractModel):
    r"""DeleteCmqSubscribe request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. the name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _SubscriptionName: Subscription name, uniquely identifies under the same topic of the same account in a single region. subscription name is a string of no more than 64 characters, beginning with a letter, the remaining part can contain letters, digits, and hyphens (-).
        :type SubscriptionName: str
        """
        self._TopicName = None
        self._SubscriptionName = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. the name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def SubscriptionName(self):
        r"""Subscription name, uniquely identifies under the same topic of the same account in a single region. subscription name is a string of no more than 64 characters, beginning with a letter, the remaining part can contain letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._SubscriptionName = params.get("SubscriptionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCmqSubscribeResponse(AbstractModel):
    r"""DeleteCmqSubscribe response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCmqTopicRequest(AbstractModel):
    r"""DeleteCmqTopic request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. the name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        """
        self._TopicName = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. the name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCmqTopicResponse(AbstractModel):
    r"""DeleteCmqTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEnvironmentRolesRequest(AbstractModel):
    r"""DeleteEnvironmentRoles request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _RoleNames: Array of role names.
        :type RoleNames: list of str
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._RoleNames = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleNames(self):
        r"""Array of role names.
        :rtype: list of str
        """
        return self._RoleNames

    @RoleNames.setter
    def RoleNames(self, RoleNames):
        self._RoleNames = RoleNames

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleNames = params.get("RoleNames")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEnvironmentRolesResponse(AbstractModel):
    r"""DeleteEnvironmentRoles response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEnvironmentsRequest(AbstractModel):
    r"""DeleteEnvironments request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentIds: Array of environments (namespaces). Up to 20 environments can be deleted at a time.
        :type EnvironmentIds: list of str
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._EnvironmentIds = None
        self._ClusterId = None

    @property
    def EnvironmentIds(self):
        r"""Array of environments (namespaces). Up to 20 environments can be deleted at a time.
        :rtype: list of str
        """
        return self._EnvironmentIds

    @EnvironmentIds.setter
    def EnvironmentIds(self, EnvironmentIds):
        self._EnvironmentIds = EnvironmentIds

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentIds = params.get("EnvironmentIds")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEnvironmentsResponse(AbstractModel):
    r"""DeleteEnvironments response structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentIds: Array of environments (namespaces) successfully deleted.
        :type EnvironmentIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EnvironmentIds = None
        self._RequestId = None

    @property
    def EnvironmentIds(self):
        r"""Array of environments (namespaces) successfully deleted.
        :rtype: list of str
        """
        return self._EnvironmentIds

    @EnvironmentIds.setter
    def EnvironmentIds(self, EnvironmentIds):
        self._EnvironmentIds = EnvironmentIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EnvironmentIds = params.get("EnvironmentIds")
        self._RequestId = params.get("RequestId")


class DeleteProClusterRequest(AbstractModel):
    r"""DeleteProCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProClusterResponse(AbstractModel):
    r"""DeleteProCluster response structure.

    """

    def __init__(self):
        r"""
        :param _DealName: Order number of the terminated instance.
        :type DealName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DealName = None
        self._RequestId = None

    @property
    def DealName(self):
        r"""Order number of the terminated instance.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DealName = params.get("DealName")
        self._RequestId = params.get("RequestId")


class DeleteRabbitMQBindingRequest(AbstractModel):
    r"""DeleteRabbitMQBinding request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _BindingId: Routing relationship ID.
        :type BindingId: int
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._BindingId = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def BindingId(self):
        r"""Routing relationship ID.
        :rtype: int
        """
        return self._BindingId

    @BindingId.setter
    def BindingId(self, BindingId):
        self._BindingId = BindingId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._BindingId = params.get("BindingId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRabbitMQBindingResponse(AbstractModel):
    r"""DeleteRabbitMQBinding response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _VirtualHost: Vhost parameter.
        :type VirtualHost: str
        :param _BindingId: Routing relationship ID.
        :type BindingId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._BindingId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost parameter.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def BindingId(self):
        r"""Routing relationship ID.
        :rtype: int
        """
        return self._BindingId

    @BindingId.setter
    def BindingId(self, BindingId):
        self._BindingId = BindingId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._BindingId = params.get("BindingId")
        self._RequestId = params.get("RequestId")


class DeleteRabbitMQPermissionRequest(AbstractModel):
    r"""DeleteRabbitMQPermission request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :type User: str
        :param _VirtualHost: VirtualHost name, such as testvhost. valid VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        """
        self._InstanceId = None
        self._User = None
        self._VirtualHost = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. valid VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._VirtualHost = params.get("VirtualHost")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRabbitMQPermissionResponse(AbstractModel):
    r"""DeleteRabbitMQPermission response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRabbitMQUserRequest(AbstractModel):
    r"""DeleteRabbitMQUser request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :type User: str
        """
        self._InstanceId = None
        self._User = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRabbitMQUserResponse(AbstractModel):
    r"""DeleteRabbitMQUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRabbitMQVipInstanceRequest(AbstractModel):
    r"""DeleteRabbitMQVipInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _IsIntl: Whether the request is from the international website. Default value: false.
        :type IsIntl: bool
        """
        self._InstanceId = None
        self._IsIntl = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def IsIntl(self):
        r"""Whether the request is from the international website. Default value: false.
        :rtype: bool
        """
        return self._IsIntl

    @IsIntl.setter
    def IsIntl(self, IsIntl):
        self._IsIntl = IsIntl


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._IsIntl = params.get("IsIntl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRabbitMQVipInstanceResponse(AbstractModel):
    r"""DeleteRabbitMQVipInstance response structure.

    """

    def __init__(self):
        r"""
        :param _TranId: Order ID.
        :type TranId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TranId = None
        self._InstanceId = None
        self._RequestId = None

    @property
    def TranId(self):
        r"""Order ID.
        :rtype: str
        """
        return self._TranId

    @TranId.setter
    def TranId(self, TranId):
        self._TranId = TranId

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TranId = params.get("TranId")
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class DeleteRabbitMQVirtualHostRequest(AbstractModel):
    r"""DeleteRabbitMQVirtualHost request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        """
        self._InstanceId = None
        self._VirtualHost = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRabbitMQVirtualHostResponse(AbstractModel):
    r"""DeleteRabbitMQVirtualHost response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRocketMQClusterRequest(AbstractModel):
    r"""DeleteRocketMQCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of the cluster to be deleted.
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""ID of the cluster to be deleted.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQClusterResponse(AbstractModel):
    r"""DeleteRocketMQCluster response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRocketMQEnvironmentRolesRequest(AbstractModel):
    r"""DeleteRocketMQEnvironmentRoles request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _RoleNames: Role name array.
        :type RoleNames: list of str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._RoleNames = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleNames(self):
        r"""Role name array.
        :rtype: list of str
        """
        return self._RoleNames

    @RoleNames.setter
    def RoleNames(self, RoleNames):
        self._RoleNames = RoleNames

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleNames = params.get("RoleNames")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQEnvironmentRolesResponse(AbstractModel):
    r"""DeleteRocketMQEnvironmentRoles response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRocketMQGroupRequest(AbstractModel):
    r"""DeleteRocketMQGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace name
        :type NamespaceId: str
        :param _GroupId: Consumer group name
        :type GroupId: str
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._GroupId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupId(self):
        r"""Consumer group name
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQGroupResponse(AbstractModel):
    r"""DeleteRocketMQGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRocketMQNamespaceRequest(AbstractModel):
    r"""DeleteRocketMQNamespace request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace name
        :type NamespaceId: str
        """
        self._ClusterId = None
        self._NamespaceId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQNamespaceResponse(AbstractModel):
    r"""DeleteRocketMQNamespace response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRocketMQRolesRequest(AbstractModel):
    r"""DeleteRocketMQRoles request structure.

    """

    def __init__(self):
        r"""
        :param _RoleNames: Role name array.
        :type RoleNames: list of str
        :param _ClusterId: Required field, cluster ID
        :type ClusterId: str
        """
        self._RoleNames = None
        self._ClusterId = None

    @property
    def RoleNames(self):
        r"""Role name array.
        :rtype: list of str
        """
        return self._RoleNames

    @RoleNames.setter
    def RoleNames(self, RoleNames):
        self._RoleNames = RoleNames

    @property
    def ClusterId(self):
        r"""Required field, cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._RoleNames = params.get("RoleNames")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQRolesResponse(AbstractModel):
    r"""DeleteRocketMQRoles response structure.

    """

    def __init__(self):
        r"""
        :param _RoleNames: Successfully deleted role name array.
        :type RoleNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleNames = None
        self._RequestId = None

    @property
    def RoleNames(self):
        r"""Successfully deleted role name array.
        :rtype: list of str
        """
        return self._RoleNames

    @RoleNames.setter
    def RoleNames(self, RoleNames):
        self._RoleNames = RoleNames

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoleNames = params.get("RoleNames")
        self._RequestId = params.get("RequestId")


class DeleteRocketMQTopicRequest(AbstractModel):
    r"""DeleteRocketMQTopic request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace name
        :type NamespaceId: str
        :param _Topic: Topic name
        :type Topic: str
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._Topic = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Topic(self):
        r"""Topic name
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Topic = params.get("Topic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQTopicResponse(AbstractModel):
    r"""DeleteRocketMQTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRocketMQVipInstanceRequest(AbstractModel):
    r"""DeleteRocketMQVipInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID of the instance.
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID of the instance.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRocketMQVipInstanceResponse(AbstractModel):
    r"""DeleteRocketMQVipInstance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRolesRequest(AbstractModel):
    r"""DeleteRoles request structure.

    """

    def __init__(self):
        r"""
        :param _RoleNames: Array of role names.
        :type RoleNames: list of str
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        """
        self._RoleNames = None
        self._ClusterId = None

    @property
    def RoleNames(self):
        r"""Array of role names.
        :rtype: list of str
        """
        return self._RoleNames

    @RoleNames.setter
    def RoleNames(self, RoleNames):
        self._RoleNames = RoleNames

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._RoleNames = params.get("RoleNames")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRolesResponse(AbstractModel):
    r"""DeleteRoles response structure.

    """

    def __init__(self):
        r"""
        :param _RoleNames: Name array of roles successfully deleted.
        :type RoleNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleNames = None
        self._RequestId = None

    @property
    def RoleNames(self):
        r"""Name array of roles successfully deleted.
        :rtype: list of str
        """
        return self._RoleNames

    @RoleNames.setter
    def RoleNames(self, RoleNames):
        self._RoleNames = RoleNames

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoleNames = params.get("RoleNames")
        self._RequestId = params.get("RequestId")


class DeleteSubscriptionsRequest(AbstractModel):
    r"""DeleteSubscriptions request structure.

    """

    def __init__(self):
        r"""
        :param _SubscriptionTopicSets: Subscription set. Up to 20 subscriptions can be deleted at a time.
        :type SubscriptionTopicSets: list of SubscriptionTopic
        :param _ClusterId: Pulsar cluster ID.
        :type ClusterId: str
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _Force: Whether to forcibly delete a subscription. Default value: `false`.
        :type Force: bool
        """
        self._SubscriptionTopicSets = None
        self._ClusterId = None
        self._EnvironmentId = None
        self._Force = None

    @property
    def SubscriptionTopicSets(self):
        r"""Subscription set. Up to 20 subscriptions can be deleted at a time.
        :rtype: list of SubscriptionTopic
        """
        return self._SubscriptionTopicSets

    @SubscriptionTopicSets.setter
    def SubscriptionTopicSets(self, SubscriptionTopicSets):
        self._SubscriptionTopicSets = SubscriptionTopicSets

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Force(self):
        r"""Whether to forcibly delete a subscription. Default value: `false`.
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        if params.get("SubscriptionTopicSets") is not None:
            self._SubscriptionTopicSets = []
            for item in params.get("SubscriptionTopicSets"):
                obj = SubscriptionTopic()
                obj._deserialize(item)
                self._SubscriptionTopicSets.append(obj)
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSubscriptionsResponse(AbstractModel):
    r"""DeleteSubscriptions response structure.

    """

    def __init__(self):
        r"""
        :param _SubscriptionTopicSets: Array of successfully deleted subscriptions.
        :type SubscriptionTopicSets: list of SubscriptionTopic
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubscriptionTopicSets = None
        self._RequestId = None

    @property
    def SubscriptionTopicSets(self):
        r"""Array of successfully deleted subscriptions.
        :rtype: list of SubscriptionTopic
        """
        return self._SubscriptionTopicSets

    @SubscriptionTopicSets.setter
    def SubscriptionTopicSets(self, SubscriptionTopicSets):
        self._SubscriptionTopicSets = SubscriptionTopicSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubscriptionTopicSets") is not None:
            self._SubscriptionTopicSets = []
            for item in params.get("SubscriptionTopicSets"):
                obj = SubscriptionTopic()
                obj._deserialize(item)
                self._SubscriptionTopicSets.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteTopicsRequest(AbstractModel):
    r"""DeleteTopics request structure.

    """

    def __init__(self):
        r"""
        :param _TopicSets: Topic set. Up to 20 topics can be deleted at a time.
        :type TopicSets: list of TopicRecord
        :param _ClusterId: Pulsar cluster ID.
        :type ClusterId: str
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _Force: Whether to forcibly delete a topic. Default value: `false`.
        :type Force: bool
        """
        self._TopicSets = None
        self._ClusterId = None
        self._EnvironmentId = None
        self._Force = None

    @property
    def TopicSets(self):
        r"""Topic set. Up to 20 topics can be deleted at a time.
        :rtype: list of TopicRecord
        """
        return self._TopicSets

    @TopicSets.setter
    def TopicSets(self, TopicSets):
        self._TopicSets = TopicSets

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Force(self):
        r"""Whether to forcibly delete a topic. Default value: `false`.
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        if params.get("TopicSets") is not None:
            self._TopicSets = []
            for item in params.get("TopicSets"):
                obj = TopicRecord()
                obj._deserialize(item)
                self._TopicSets.append(obj)
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTopicsResponse(AbstractModel):
    r"""DeleteTopics response structure.

    """

    def __init__(self):
        r"""
        :param _TopicSets: Array of deleted topics.
        :type TopicSets: list of TopicRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicSets = None
        self._RequestId = None

    @property
    def TopicSets(self):
        r"""Array of deleted topics.
        :rtype: list of TopicRecord
        """
        return self._TopicSets

    @TopicSets.setter
    def TopicSets(self, TopicSets):
        self._TopicSets = TopicSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TopicSets") is not None:
            self._TopicSets = []
            for item in params.get("TopicSets"):
                obj = TopicRecord()
                obj._deserialize(item)
                self._TopicSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBindClustersRequest(AbstractModel):
    r"""DescribeBindClusters request structure.

    """


class DescribeBindClustersResponse(AbstractModel):
    r"""DescribeBindClusters response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of dedicated clusters
        :type TotalCount: int
        :param _ClusterSet: List of dedicated clusters
        :type ClusterSet: list of BindCluster
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of dedicated clusters
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterSet(self):
        r"""List of dedicated clusters
        :rtype: list of BindCluster
        """
        return self._ClusterSet

    @ClusterSet.setter
    def ClusterSet(self, ClusterSet):
        self._ClusterSet = ClusterSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterSet") is not None:
            self._ClusterSet = []
            for item in params.get("ClusterSet"):
                obj = BindCluster()
                obj._deserialize(item)
                self._ClusterSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBindVpcsRequest(AbstractModel):
    r"""DescribeBindVpcs request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. If this parameter is left empty, 0 will be used by default.
        :type Offset: int
        :param _Limit: Number of results to be returned. If this parameter is left empty, 10 will be used by default. The maximum value is 20.
        :type Limit: int
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._Offset = None
        self._Limit = None
        self._ClusterId = None

    @property
    def Offset(self):
        r"""Offset. If this parameter is left empty, 0 will be used by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of results to be returned. If this parameter is left empty, 10 will be used by default. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBindVpcsResponse(AbstractModel):
    r"""DescribeBindVpcs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of records.
        :type TotalCount: int
        :param _VpcSets: Set of VPCs.
        :type VpcSets: list of VpcBindRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpcSets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpcSets(self):
        r"""Set of VPCs.
        :rtype: list of VpcBindRecord
        """
        return self._VpcSets

    @VpcSets.setter
    def VpcSets(self, VpcSets):
        self._VpcSets = VpcSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpcSets") is not None:
            self._VpcSets = []
            for item in params.get("VpcSets"):
                obj = VpcBindRecord()
                obj._deserialize(item)
                self._VpcSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterDetailRequest(AbstractModel):
    r"""DescribeClusterDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDetailResponse(AbstractModel):
    r"""DescribeClusterDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterSet: Cluster details
        :type ClusterSet: :class:`tencentcloud.tdmq.v20200217.models.Cluster`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterSet = None
        self._RequestId = None

    @property
    def ClusterSet(self):
        r"""Cluster details
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.Cluster`
        """
        return self._ClusterSet

    @ClusterSet.setter
    def ClusterSet(self, ClusterSet):
        self._ClusterSet = ClusterSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterSet") is not None:
            self._ClusterSet = Cluster()
            self._ClusterSet._deserialize(params.get("ClusterSet"))
        self._RequestId = params.get("RequestId")


class DescribeClustersRequest(AbstractModel):
    r"""DescribeClusters request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Start offset, which defaults to 0 if left empty.
        :type Offset: int
        :param _Limit: The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :type Limit: int
        :param _ClusterIdList: Filter by cluster ID.
        :type ClusterIdList: list of str
        :param _IsTagFilter: Whether to filter by tag.
        :type IsTagFilter: bool
        :param _Filters: Filter. Currently, you can filter by tag.
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._ClusterIdList = None
        self._IsTagFilter = None
        self._Filters = None

    @property
    def Offset(self):
        r"""Start offset, which defaults to 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ClusterIdList(self):
        r"""Filter by cluster ID.
        :rtype: list of str
        """
        return self._ClusterIdList

    @ClusterIdList.setter
    def ClusterIdList(self, ClusterIdList):
        self._ClusterIdList = ClusterIdList

    @property
    def IsTagFilter(self):
        r"""Whether to filter by tag.
        :rtype: bool
        """
        return self._IsTagFilter

    @IsTagFilter.setter
    def IsTagFilter(self, IsTagFilter):
        self._IsTagFilter = IsTagFilter

    @property
    def Filters(self):
        r"""Filter. Currently, you can filter by tag.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ClusterIdList = params.get("ClusterIdList")
        self._IsTagFilter = params.get("IsTagFilter")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClustersResponse(AbstractModel):
    r"""DescribeClusters response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of clusters.
        :type TotalCount: int
        :param _ClusterSet: Cluster information list
        :type ClusterSet: list of Cluster
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of clusters.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterSet(self):
        r"""Cluster information list
        :rtype: list of Cluster
        """
        return self._ClusterSet

    @ClusterSet.setter
    def ClusterSet(self, ClusterSet):
        self._ClusterSet = ClusterSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterSet") is not None:
            self._ClusterSet = []
            for item in params.get("ClusterSet"):
                obj = Cluster()
                obj._deserialize(item)
                self._ClusterSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCmqQueueDetailRequest(AbstractModel):
    r"""DescribeCmqQueueDetail request structure.

    """

    def __init__(self):
        r"""
        :param _QueueName: Exact match by `QueueName`
        :type QueueName: str
        """
        self._QueueName = None

    @property
    def QueueName(self):
        r"""Exact match by `QueueName`
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCmqQueueDetailResponse(AbstractModel):
    r"""DescribeCmqQueueDetail response structure.

    """

    def __init__(self):
        r"""
        :param _QueueDescribe: List of queue details.
        :type QueueDescribe: :class:`tencentcloud.tdmq.v20200217.models.CmqQueue`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QueueDescribe = None
        self._RequestId = None

    @property
    def QueueDescribe(self):
        r"""List of queue details.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.CmqQueue`
        """
        return self._QueueDescribe

    @QueueDescribe.setter
    def QueueDescribe(self, QueueDescribe):
        self._QueueDescribe = QueueDescribe

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QueueDescribe") is not None:
            self._QueueDescribe = CmqQueue()
            self._QueueDescribe._deserialize(params.get("QueueDescribe"))
        self._RequestId = params.get("RequestId")


class DescribeCmqQueuesRequest(AbstractModel):
    r"""DescribeCmqQueues request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Starting position of a queue list to be returned on the current page in case of paginated return. If a value is entered, `limit` must be specified. If this parameter is left empty, 0 will be used by default.
        :type Offset: int
        :param _Limit: The number of queues to be returned per page in case of paginated return. If this parameter is not passed in, 20 will be used by default. Maximum value: 50.
        :type Limit: int
        :param _QueueName: Filter by `QueueName`
        :type QueueName: str
        :param _QueueNameList: Filter by CMQ queue name.
        :type QueueNameList: list of str
        :param _IsTagFilter: For filtering by tag, this parameter must be set to `true`.
        :type IsTagFilter: bool
        :param _Filters: Filter. Currently, you can filter by tag. The tag name must be prefixed with “tag:”, such as “tag: owner”, “tag: environment”, or “tag: business”.
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._QueueName = None
        self._QueueNameList = None
        self._IsTagFilter = None
        self._Filters = None

    @property
    def Offset(self):
        r"""Starting position of a queue list to be returned on the current page in case of paginated return. If a value is entered, `limit` must be specified. If this parameter is left empty, 0 will be used by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of queues to be returned per page in case of paginated return. If this parameter is not passed in, 20 will be used by default. Maximum value: 50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def QueueName(self):
        r"""Filter by `QueueName`
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def QueueNameList(self):
        r"""Filter by CMQ queue name.
        :rtype: list of str
        """
        return self._QueueNameList

    @QueueNameList.setter
    def QueueNameList(self, QueueNameList):
        self._QueueNameList = QueueNameList

    @property
    def IsTagFilter(self):
        r"""For filtering by tag, this parameter must be set to `true`.
        :rtype: bool
        """
        return self._IsTagFilter

    @IsTagFilter.setter
    def IsTagFilter(self, IsTagFilter):
        self._IsTagFilter = IsTagFilter

    @property
    def Filters(self):
        r"""Filter. Currently, you can filter by tag. The tag name must be prefixed with “tag:”, such as “tag: owner”, “tag: environment”, or “tag: business”.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._QueueName = params.get("QueueName")
        self._QueueNameList = params.get("QueueNameList")
        self._IsTagFilter = params.get("IsTagFilter")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCmqQueuesResponse(AbstractModel):
    r"""DescribeCmqQueues response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of queues.
        :type TotalCount: int
        :param _QueueList: Queue list.
        :type QueueList: list of CmqQueue
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._QueueList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of queues.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QueueList(self):
        r"""Queue list.
        :rtype: list of CmqQueue
        """
        return self._QueueList

    @QueueList.setter
    def QueueList(self, QueueList):
        self._QueueList = QueueList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QueueList") is not None:
            self._QueueList = []
            for item in params.get("QueueList"):
                obj = CmqQueue()
                obj._deserialize(item)
                self._QueueList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCmqSubscriptionDetailRequest(AbstractModel):
    r"""DescribeCmqSubscriptionDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _Offset: Starting position of the list of topics to be returned on the current page in case of paginated return. If a value is entered, `limit` is required. If this parameter is left empty, 0 will be used by default
        :type Offset: int
        :param _Limit: Number of topics to be returned per page in case of paginated return. If this parameter is not passed in, 20 will be used by default. Maximum value: 50.
        :type Limit: int
        :param _SubscriptionName: Fuzzy search by `SubscriptionName`
        :type SubscriptionName: str
        :param _QueueName: Queue name. Endpoint of bound subscription
        :type QueueName: str
        :param _QueryType: Query type. valid values: (1) topic; (2) queue.
Default value is topic. if queryType is topic, query subscriptions under the topic. if queryType is queue, query subscriptions bound to the queue.
        :type QueryType: str
        """
        self._TopicName = None
        self._Offset = None
        self._Limit = None
        self._SubscriptionName = None
        self._QueueName = None
        self._QueryType = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Offset(self):
        r"""Starting position of the list of topics to be returned on the current page in case of paginated return. If a value is entered, `limit` is required. If this parameter is left empty, 0 will be used by default
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of topics to be returned per page in case of paginated return. If this parameter is not passed in, 20 will be used by default. Maximum value: 50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SubscriptionName(self):
        r"""Fuzzy search by `SubscriptionName`
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def QueueName(self):
        r"""Queue name. Endpoint of bound subscription
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def QueryType(self):
        r"""Query type. valid values: (1) topic; (2) queue.
Default value is topic. if queryType is topic, query subscriptions under the topic. if queryType is queue, query subscriptions bound to the queue.
        :rtype: str
        """
        return self._QueryType

    @QueryType.setter
    def QueryType(self, QueryType):
        self._QueryType = QueryType


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SubscriptionName = params.get("SubscriptionName")
        self._QueueName = params.get("QueueName")
        self._QueryType = params.get("QueryType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCmqSubscriptionDetailResponse(AbstractModel):
    r"""DescribeCmqSubscriptionDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _SubscriptionSet: Subscription attribute collection
        :type SubscriptionSet: list of CmqSubscription
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SubscriptionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SubscriptionSet(self):
        r"""Subscription attribute collection
        :rtype: list of CmqSubscription
        """
        return self._SubscriptionSet

    @SubscriptionSet.setter
    def SubscriptionSet(self, SubscriptionSet):
        self._SubscriptionSet = SubscriptionSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SubscriptionSet") is not None:
            self._SubscriptionSet = []
            for item in params.get("SubscriptionSet"):
                obj = CmqSubscription()
                obj._deserialize(item)
                self._SubscriptionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCmqTopicDetailRequest(AbstractModel):
    r"""DescribeCmqTopicDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Exact match by `TopicName`.
        :type TopicName: str
        """
        self._TopicName = None

    @property
    def TopicName(self):
        r"""Exact match by `TopicName`.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCmqTopicDetailResponse(AbstractModel):
    r"""DescribeCmqTopicDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TopicDescribe: Topic details
        :type TopicDescribe: :class:`tencentcloud.tdmq.v20200217.models.CmqTopic`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicDescribe = None
        self._RequestId = None

    @property
    def TopicDescribe(self):
        r"""Topic details
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.CmqTopic`
        """
        return self._TopicDescribe

    @TopicDescribe.setter
    def TopicDescribe(self, TopicDescribe):
        self._TopicDescribe = TopicDescribe

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TopicDescribe") is not None:
            self._TopicDescribe = CmqTopic()
            self._TopicDescribe._deserialize(params.get("TopicDescribe"))
        self._RequestId = params.get("RequestId")


class DescribeCmqTopicsRequest(AbstractModel):
    r"""DescribeCmqTopics request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Starting position of a queue list to be returned on the current page in case of paginated return. If a value is entered, `limit` must be specified. If this parameter is left empty, 0 will be used by default.
        :type Offset: int
        :param _Limit: The number of queues to be returned per page in case of paginated return. If this parameter is not passed in, 20 will be used by default. Maximum value: 50.
        :type Limit: int
        :param _TopicName: Fuzzy search by `TopicName`
        :type TopicName: str
        :param _TopicNameList: Filter by CMQ topic name.
        :type TopicNameList: list of str
        :param _IsTagFilter: For filtering by tag, this parameter must be set to `true`.
        :type IsTagFilter: bool
        :param _Filters: Filter. Currently, you can filter by tag. The tag name must be prefixed with “tag:”, such as “tag: owner”, “tag: environment”, or “tag: business”.
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._TopicName = None
        self._TopicNameList = None
        self._IsTagFilter = None
        self._Filters = None

    @property
    def Offset(self):
        r"""Starting position of a queue list to be returned on the current page in case of paginated return. If a value is entered, `limit` must be specified. If this parameter is left empty, 0 will be used by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of queues to be returned per page in case of paginated return. If this parameter is not passed in, 20 will be used by default. Maximum value: 50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TopicName(self):
        r"""Fuzzy search by `TopicName`
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def TopicNameList(self):
        r"""Filter by CMQ topic name.
        :rtype: list of str
        """
        return self._TopicNameList

    @TopicNameList.setter
    def TopicNameList(self, TopicNameList):
        self._TopicNameList = TopicNameList

    @property
    def IsTagFilter(self):
        r"""For filtering by tag, this parameter must be set to `true`.
        :rtype: bool
        """
        return self._IsTagFilter

    @IsTagFilter.setter
    def IsTagFilter(self, IsTagFilter):
        self._IsTagFilter = IsTagFilter

    @property
    def Filters(self):
        r"""Filter. Currently, you can filter by tag. The tag name must be prefixed with “tag:”, such as “tag: owner”, “tag: environment”, or “tag: business”.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TopicName = params.get("TopicName")
        self._TopicNameList = params.get("TopicNameList")
        self._IsTagFilter = params.get("IsTagFilter")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCmqTopicsResponse(AbstractModel):
    r"""DescribeCmqTopics response structure.

    """

    def __init__(self):
        r"""
        :param _TopicList: Topic list.
        :type TopicList: list of CmqTopic
        :param _TotalCount: The total number of topics.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TopicList(self):
        r"""Topic list.
        :rtype: list of CmqTopic
        """
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList

    @property
    def TotalCount(self):
        r"""The total number of topics.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = CmqTopic()
                obj._deserialize(item)
                self._TopicList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeEnvironmentAttributesRequest(AbstractModel):
    r"""DescribeEnvironmentAttributes request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnvironmentAttributesResponse(AbstractModel):
    r"""DescribeEnvironmentAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _MsgTTL: TTL for unconsumed messages in seconds. Maximum value: 1296000 seconds (i.e., 15 days).
        :type MsgTTL: int
        :param _RateInByte: Consumption rate limit in bytes/second. 0: unlimited.
        :type RateInByte: int
        :param _RateInSize: Consumption rate limit in messages/second. 0: unlimited.
        :type RateInSize: int
        :param _RetentionHours: Retention policy for consumed messages in hours. 0: deleted immediately after consumption.
        :type RetentionHours: int
        :param _RetentionSize: Retention policy for consumed messages in GB. 0: deleted immediately after consumption.
        :type RetentionSize: int
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _Replicas: Number of replicas.
        :type Replicas: int
        :param _Remark: Remarks.
        :type Remark: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MsgTTL = None
        self._RateInByte = None
        self._RateInSize = None
        self._RetentionHours = None
        self._RetentionSize = None
        self._EnvironmentId = None
        self._Replicas = None
        self._Remark = None
        self._RequestId = None

    @property
    def MsgTTL(self):
        r"""TTL for unconsumed messages in seconds. Maximum value: 1296000 seconds (i.e., 15 days).
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def RateInByte(self):
        r"""Consumption rate limit in bytes/second. 0: unlimited.
        :rtype: int
        """
        return self._RateInByte

    @RateInByte.setter
    def RateInByte(self, RateInByte):
        self._RateInByte = RateInByte

    @property
    def RateInSize(self):
        r"""Consumption rate limit in messages/second. 0: unlimited.
        :rtype: int
        """
        return self._RateInSize

    @RateInSize.setter
    def RateInSize(self, RateInSize):
        self._RateInSize = RateInSize

    @property
    def RetentionHours(self):
        r"""Retention policy for consumed messages in hours. 0: deleted immediately after consumption.
        :rtype: int
        """
        return self._RetentionHours

    @RetentionHours.setter
    def RetentionHours(self, RetentionHours):
        self._RetentionHours = RetentionHours

    @property
    def RetentionSize(self):
        r"""Retention policy for consumed messages in GB. 0: deleted immediately after consumption.
        :rtype: int
        """
        return self._RetentionSize

    @RetentionSize.setter
    def RetentionSize(self, RetentionSize):
        self._RetentionSize = RetentionSize

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Replicas(self):
        r"""Number of replicas.
        :rtype: int
        """
        return self._Replicas

    @Replicas.setter
    def Replicas(self, Replicas):
        self._Replicas = Replicas

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MsgTTL = params.get("MsgTTL")
        self._RateInByte = params.get("RateInByte")
        self._RateInSize = params.get("RateInSize")
        self._RetentionHours = params.get("RetentionHours")
        self._RetentionSize = params.get("RetentionSize")
        self._EnvironmentId = params.get("EnvironmentId")
        self._Replicas = params.get("Replicas")
        self._Remark = params.get("Remark")
        self._RequestId = params.get("RequestId")


class DescribeEnvironmentRolesRequest(AbstractModel):
    r"""DescribeEnvironmentRoles request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _Offset: Offset, which defaults to 0 if left empty.
        :type Offset: int
        :param _Limit: The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :type Limit: int
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Filters: * RoleName
Filter by role name for exact query.
Type: String
Required: No
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._Offset = None
        self._Limit = None
        self._RoleName = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Offset(self):
        r"""Offset, which defaults to 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Filters(self):
        r"""* RoleName
Filter by role name for exact query.
Type: String
Required: No
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RoleName = params.get("RoleName")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnvironmentRolesResponse(AbstractModel):
    r"""DescribeEnvironmentRoles response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of records.
        :type TotalCount: int
        :param _EnvironmentRoleSets: Namespace role set.
        :type EnvironmentRoleSets: list of EnvironmentRole
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EnvironmentRoleSets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EnvironmentRoleSets(self):
        r"""Namespace role set.
        :rtype: list of EnvironmentRole
        """
        return self._EnvironmentRoleSets

    @EnvironmentRoleSets.setter
    def EnvironmentRoleSets(self, EnvironmentRoleSets):
        self._EnvironmentRoleSets = EnvironmentRoleSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EnvironmentRoleSets") is not None:
            self._EnvironmentRoleSets = []
            for item in params.get("EnvironmentRoleSets"):
                obj = EnvironmentRole()
                obj._deserialize(item)
                self._EnvironmentRoleSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEnvironmentsRequest(AbstractModel):
    r"""DescribeEnvironments request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _EnvironmentId: Fuzzy search by namespace name.
        :type EnvironmentId: str
        :param _Offset: Offset, which defaults to 0 if left empty.
        :type Offset: int
        :param _Limit: The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :type Limit: int
        :param _Filters: * EnvironmentId
Filter by namespace for exact query.
Type: String
Required: No
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Fuzzy search by namespace name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Offset(self):
        r"""Offset, which defaults to 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""* EnvironmentId
Filter by namespace for exact query.
Type: String
Required: No
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnvironmentsResponse(AbstractModel):
    r"""DescribeEnvironments response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of namespaces.
        :type TotalCount: int
        :param _EnvironmentSet: Array of namespace sets.
        :type EnvironmentSet: list of Environment
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EnvironmentSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of namespaces.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EnvironmentSet(self):
        r"""Array of namespace sets.
        :rtype: list of Environment
        """
        return self._EnvironmentSet

    @EnvironmentSet.setter
    def EnvironmentSet(self, EnvironmentSet):
        self._EnvironmentSet = EnvironmentSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EnvironmentSet") is not None:
            self._EnvironmentSet = []
            for item in params.get("EnvironmentSet"):
                obj = Environment()
                obj._deserialize(item)
                self._EnvironmentSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMqMsgTraceRequest(AbstractModel):
    r"""DescribeMqMsgTrace request structure.

    """

    def __init__(self):
        r"""
        :param _Protocol: pulsar,rocketmq,rabbitmq,cmq
        :type Protocol: str
        :param _MsgId: Message ID
        :type MsgId: str
        :param _ClusterId: Cluster id. cmq is empty.
        :type ClusterId: str
        :param _EnvironmentId: Namespace. cmq is empty.
        :type EnvironmentId: str
        :param _TopicName: Topic. empty for cmq. group id when querying rocketmq dead letters.
        :type TopicName: str
        :param _QueueName: cmq is required. fill in the blank for other protocols.
        :type QueueName: str
        :param _GroupName: Consumer Group and Subscription
        :type GroupName: str
        :param _QueryDlqMsg: The value is true when querying dead letters, and only valid for RocketMQ.
        :type QueryDlqMsg: bool
        :param _ProduceTime: Message production time.
        :type ProduceTime: str
        """
        self._Protocol = None
        self._MsgId = None
        self._ClusterId = None
        self._EnvironmentId = None
        self._TopicName = None
        self._QueueName = None
        self._GroupName = None
        self._QueryDlqMsg = None
        self._ProduceTime = None

    @property
    def Protocol(self):
        r"""pulsar,rocketmq,rabbitmq,cmq
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ClusterId(self):
        r"""Cluster id. cmq is empty.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Namespace. cmq is empty.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic. empty for cmq. group id when querying rocketmq dead letters.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def QueueName(self):
        r"""cmq is required. fill in the blank for other protocols.
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def GroupName(self):
        r"""Consumer Group and Subscription
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def QueryDlqMsg(self):
        r"""The value is true when querying dead letters, and only valid for RocketMQ.
        :rtype: bool
        """
        return self._QueryDlqMsg

    @QueryDlqMsg.setter
    def QueryDlqMsg(self, QueryDlqMsg):
        self._QueryDlqMsg = QueryDlqMsg

    @property
    def ProduceTime(self):
        r"""Message production time.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime


    def _deserialize(self, params):
        self._Protocol = params.get("Protocol")
        self._MsgId = params.get("MsgId")
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._QueueName = params.get("QueueName")
        self._GroupName = params.get("GroupName")
        self._QueryDlqMsg = params.get("QueryDlqMsg")
        self._ProduceTime = params.get("ProduceTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMqMsgTraceResponse(AbstractModel):
    r"""DescribeMqMsgTrace response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Message content.
        :type Result: list of TraceResult
        :param _ShowTopicName: Topic Name Displayed on Message Trace Page
        :type ShowTopicName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._ShowTopicName = None
        self._RequestId = None

    @property
    def Result(self):
        r"""Message content.
        :rtype: list of TraceResult
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ShowTopicName(self):
        r"""Topic Name Displayed on Message Trace Page
        :rtype: str
        """
        return self._ShowTopicName

    @ShowTopicName.setter
    def ShowTopicName(self, ShowTopicName):
        self._ShowTopicName = ShowTopicName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = TraceResult()
                obj._deserialize(item)
                self._Result.append(obj)
        self._ShowTopicName = params.get("ShowTopicName")
        self._RequestId = params.get("RequestId")


class DescribeMsgRequest(AbstractModel):
    r"""DescribeMsg request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._MsgId = None
        self._TopicName = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._MsgId = params.get("MsgId")
        self._TopicName = params.get("TopicName")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMsgResponse(AbstractModel):
    r"""DescribeMsg response structure.

    """

    def __init__(self):
        r"""
        :param _Properties: Message attributes.
        :type Properties: str
        :param _Body: Message body.
        :type Body: str
        :param _BatchId: Batch ID.
        :type BatchId: str
        :param _ProduceTime: Production time.
        :type ProduceTime: str
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _ProducerName: Producer name.
        :type ProducerName: str
        :param _Key: Message key
Note: This field may return null, indicating that no valid values can be obtained.
        :type Key: str
        :param _Metadata: Message metadata information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Metadata: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Properties = None
        self._Body = None
        self._BatchId = None
        self._ProduceTime = None
        self._MsgId = None
        self._ProducerName = None
        self._Key = None
        self._Metadata = None
        self._RequestId = None

    @property
    def Properties(self):
        r"""Message attributes.
        :rtype: str
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def Body(self):
        r"""Message body.
        :rtype: str
        """
        return self._Body

    @Body.setter
    def Body(self, Body):
        self._Body = Body

    @property
    def BatchId(self):
        r"""Batch ID.
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def ProduceTime(self):
        r"""Production time.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ProducerName(self):
        r"""Producer name.
        :rtype: str
        """
        return self._ProducerName

    @ProducerName.setter
    def ProducerName(self, ProducerName):
        self._ProducerName = ProducerName

    @property
    def Key(self):
        r"""Message key
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Metadata(self):
        r"""Message metadata information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Metadata

    @Metadata.setter
    def Metadata(self, Metadata):
        self._Metadata = Metadata

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Properties = params.get("Properties")
        self._Body = params.get("Body")
        self._BatchId = params.get("BatchId")
        self._ProduceTime = params.get("ProduceTime")
        self._MsgId = params.get("MsgId")
        self._ProducerName = params.get("ProducerName")
        self._Key = params.get("Key")
        self._Metadata = params.get("Metadata")
        self._RequestId = params.get("RequestId")


class DescribeMsgTraceRequest(AbstractModel):
    r"""DescribeMsgTrace request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace).
        :type EnvironmentId: str
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _ProduceTime: Message production time.
        :type ProduceTime: str
        :param _Offset: Starting index. Default is 0 if left empty.
        :type Offset: int
        :param _Limit: Number of returns, default to 10 if not specified, maximum value: 20.
        :type Limit: int
        :param _SubscriptionName: Fuzzy matching of consumer group name.
        :type SubscriptionName: str
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._MsgId = None
        self._ProduceTime = None
        self._Offset = None
        self._Limit = None
        self._SubscriptionName = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace).
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ProduceTime(self):
        r"""Message production time.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def Offset(self):
        r"""Starting index. Default is 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returns, default to 10 if not specified, maximum value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SubscriptionName(self):
        r"""Fuzzy matching of consumer group name.
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._MsgId = params.get("MsgId")
        self._ProduceTime = params.get("ProduceTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SubscriptionName = params.get("SubscriptionName")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMsgTraceResponse(AbstractModel):
    r"""DescribeMsgTrace response structure.

    """

    def __init__(self):
        r"""
        :param _ProducerLog: Produce information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProducerLog: :class:`tencentcloud.tdmq.v20200217.models.ProducerLog`
        :param _ServerLog: Service provider information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServerLog: :class:`tencentcloud.tdmq.v20200217.models.ServerLog`
        :param _ConsumerLogs: Consumption information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerLogs: :class:`tencentcloud.tdmq.v20200217.models.ConsumerLogs`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProducerLog = None
        self._ServerLog = None
        self._ConsumerLogs = None
        self._RequestId = None

    @property
    def ProducerLog(self):
        r"""Produce information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.ProducerLog`
        """
        return self._ProducerLog

    @ProducerLog.setter
    def ProducerLog(self, ProducerLog):
        self._ProducerLog = ProducerLog

    @property
    def ServerLog(self):
        r"""Service provider information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.ServerLog`
        """
        return self._ServerLog

    @ServerLog.setter
    def ServerLog(self, ServerLog):
        self._ServerLog = ServerLog

    @property
    def ConsumerLogs(self):
        r"""Consumption information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.ConsumerLogs`
        """
        return self._ConsumerLogs

    @ConsumerLogs.setter
    def ConsumerLogs(self, ConsumerLogs):
        self._ConsumerLogs = ConsumerLogs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProducerLog") is not None:
            self._ProducerLog = ProducerLog()
            self._ProducerLog._deserialize(params.get("ProducerLog"))
        if params.get("ServerLog") is not None:
            self._ServerLog = ServerLog()
            self._ServerLog._deserialize(params.get("ServerLog"))
        if params.get("ConsumerLogs") is not None:
            self._ConsumerLogs = ConsumerLogs()
            self._ConsumerLogs._deserialize(params.get("ConsumerLogs"))
        self._RequestId = params.get("RequestId")


class DescribePublisherSummaryRequest(AbstractModel):
    r"""DescribePublisherSummary request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _Namespace: Namespace name.
        :type Namespace: str
        :param _Topic: Topic name.
        :type Topic: str
        """
        self._ClusterId = None
        self._Namespace = None
        self._Topic = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Namespace(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Topic(self):
        r"""Topic name.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Namespace = params.get("Namespace")
        self._Topic = params.get("Topic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublisherSummaryResponse(AbstractModel):
    r"""DescribePublisherSummary response structure.

    """

    def __init__(self):
        r"""
        :param _MsgRateIn: Production rate (messages/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MsgRateIn: float
        :param _MsgThroughputIn: Production rate (byte/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MsgThroughputIn: float
        :param _PublisherCount: The number of producers.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type PublisherCount: int
        :param _StorageSize: Message storage size in bytes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type StorageSize: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MsgRateIn = None
        self._MsgThroughputIn = None
        self._PublisherCount = None
        self._StorageSize = None
        self._RequestId = None

    @property
    def MsgRateIn(self):
        r"""Production rate (messages/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MsgRateIn

    @MsgRateIn.setter
    def MsgRateIn(self, MsgRateIn):
        self._MsgRateIn = MsgRateIn

    @property
    def MsgThroughputIn(self):
        r"""Production rate (byte/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MsgThroughputIn

    @MsgThroughputIn.setter
    def MsgThroughputIn(self, MsgThroughputIn):
        self._MsgThroughputIn = MsgThroughputIn

    @property
    def PublisherCount(self):
        r"""The number of producers.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PublisherCount

    @PublisherCount.setter
    def PublisherCount(self, PublisherCount):
        self._PublisherCount = PublisherCount

    @property
    def StorageSize(self):
        r"""Message storage size in bytes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MsgRateIn = params.get("MsgRateIn")
        self._MsgThroughputIn = params.get("MsgThroughputIn")
        self._PublisherCount = params.get("PublisherCount")
        self._StorageSize = params.get("StorageSize")
        self._RequestId = params.get("RequestId")


class DescribePublishersRequest(AbstractModel):
    r"""DescribePublishers request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _Namespace: Namespace name.
        :type Namespace: str
        :param _Topic: Topic name.
        :type Topic: str
        :param _Filters: Parameter filter. The `ProducerName` and `Address` fields are supported.
        :type Filters: list of Filter
        :param _Offset: Offset for query. Default value: `0`.
        :type Offset: int
        :param _Limit: The number of query results displayed per page. Default value: `20`.
        :type Limit: int
        :param _Sort: Sort by field.
        :type Sort: :class:`tencentcloud.tdmq.v20200217.models.Sort`
        """
        self._ClusterId = None
        self._Namespace = None
        self._Topic = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Sort = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Namespace(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Topic(self):
        r"""Topic name.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Filters(self):
        r"""Parameter filter. The `ProducerName` and `Address` fields are supported.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset for query. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of query results displayed per page. Default value: `20`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Sort(self):
        r"""Sort by field.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.Sort`
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Namespace = params.get("Namespace")
        self._Topic = params.get("Topic")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Sort") is not None:
            self._Sort = Sort()
            self._Sort._deserialize(params.get("Sort"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePublishersResponse(AbstractModel):
    r"""DescribePublishers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of query results.
        :type TotalCount: int
        :param _Publishers: List of producer information.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Publishers: list of Publisher
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Publishers = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of query results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Publishers(self):
        r"""List of producer information.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of Publisher
        """
        return self._Publishers

    @Publishers.setter
    def Publishers(self, Publishers):
        self._Publishers = Publishers

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Publishers") is not None:
            self._Publishers = []
            for item in params.get("Publishers"):
                obj = Publisher()
                obj._deserialize(item)
                self._Publishers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePulsarProInstanceDetailRequest(AbstractModel):
    r"""DescribePulsarProInstanceDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePulsarProInstanceDetailResponse(AbstractModel):
    r"""DescribePulsarProInstanceDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterInfo: Cluster information
        :type ClusterInfo: :class:`tencentcloud.tdmq.v20200217.models.PulsarProClusterInfo`
        :param _NetworkAccessPointInfos: Cluster network access point information
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkAccessPointInfos: list of PulsarNetworkAccessPointInfo
        :param _ClusterSpecInfo: Cluster specification information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterSpecInfo: :class:`tencentcloud.tdmq.v20200217.models.PulsarProClusterSpecInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterInfo = None
        self._NetworkAccessPointInfos = None
        self._ClusterSpecInfo = None
        self._RequestId = None

    @property
    def ClusterInfo(self):
        r"""Cluster information
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.PulsarProClusterInfo`
        """
        return self._ClusterInfo

    @ClusterInfo.setter
    def ClusterInfo(self, ClusterInfo):
        self._ClusterInfo = ClusterInfo

    @property
    def NetworkAccessPointInfos(self):
        r"""Cluster network access point information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of PulsarNetworkAccessPointInfo
        """
        return self._NetworkAccessPointInfos

    @NetworkAccessPointInfos.setter
    def NetworkAccessPointInfos(self, NetworkAccessPointInfos):
        self._NetworkAccessPointInfos = NetworkAccessPointInfos

    @property
    def ClusterSpecInfo(self):
        r"""Cluster specification information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.PulsarProClusterSpecInfo`
        """
        return self._ClusterSpecInfo

    @ClusterSpecInfo.setter
    def ClusterSpecInfo(self, ClusterSpecInfo):
        self._ClusterSpecInfo = ClusterSpecInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterInfo") is not None:
            self._ClusterInfo = PulsarProClusterInfo()
            self._ClusterInfo._deserialize(params.get("ClusterInfo"))
        if params.get("NetworkAccessPointInfos") is not None:
            self._NetworkAccessPointInfos = []
            for item in params.get("NetworkAccessPointInfos"):
                obj = PulsarNetworkAccessPointInfo()
                obj._deserialize(item)
                self._NetworkAccessPointInfos.append(obj)
        if params.get("ClusterSpecInfo") is not None:
            self._ClusterSpecInfo = PulsarProClusterSpecInfo()
            self._ClusterSpecInfo._deserialize(params.get("ClusterSpecInfo"))
        self._RequestId = params.get("RequestId")


class DescribePulsarProInstancesRequest(AbstractModel):
    r"""DescribePulsarProInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Query condition filter
        :type Filters: list of Filter
        :param _Limit: The maximum number of queried items, which defaults to `20`.
        :type Limit: int
        :param _Offset: Start offset for query
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        r"""Query condition filter
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""The maximum number of queried items, which defaults to `20`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Start offset for query
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePulsarProInstancesResponse(AbstractModel):
    r"""DescribePulsarProInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of unpaginated items
        :type TotalCount: int
        :param _Instances: Instance information list
        :type Instances: list of PulsarProInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Instances = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of unpaginated items
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Instances(self):
        r"""Instance information list
        :rtype: list of PulsarProInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = PulsarProInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQBindingsRequest(AbstractModel):
    r"""DescribeRabbitMQBindings request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _Offset: Specifies the page offset. default is 0.
        :type Offset: int
        :param _Limit: Page limit. default value: 20.
        :type Limit: int
        :param _SearchWord: Search keyword. Performs fuzzy search based on source exchange name, target resource name, or binding key.
        :type SearchWord: str
        :param _SourceExchange: Precise search filter based on source exchange.
        :type SourceExchange: str
        :param _QueueName: Filters by the target queue name. cannot be set with DestinationExchange filtering.
        :type QueueName: str
        :param _DestinationExchange: Precise search filter based on target exchange. Cannot be set simultaneously with queuename filter.
        :type DestinationExchange: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._SourceExchange = None
        self._QueueName = None
        self._DestinationExchange = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Offset(self):
        r"""Specifies the page offset. default is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page limit. default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        r"""Search keyword. Performs fuzzy search based on source exchange name, target resource name, or binding key.
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def SourceExchange(self):
        r"""Precise search filter based on source exchange.
        :rtype: str
        """
        return self._SourceExchange

    @SourceExchange.setter
    def SourceExchange(self, SourceExchange):
        self._SourceExchange = SourceExchange

    @property
    def QueueName(self):
        r"""Filters by the target queue name. cannot be set with DestinationExchange filtering.
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def DestinationExchange(self):
        r"""Precise search filter based on target exchange. Cannot be set simultaneously with queuename filter.
        :rtype: str
        """
        return self._DestinationExchange

    @DestinationExchange.setter
    def DestinationExchange(self, DestinationExchange):
        self._DestinationExchange = DestinationExchange


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._SourceExchange = params.get("SourceExchange")
        self._QueueName = params.get("QueueName")
        self._DestinationExchange = params.get("DestinationExchange")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQBindingsResponse(AbstractModel):
    r"""DescribeRabbitMQBindings response structure.

    """

    def __init__(self):
        r"""
        :param _BindingInfoList: Route relationship list
        :type BindingInfoList: list of RabbitMQBindingListInfo
        :param _TotalCount: Number of routing relationships.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BindingInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def BindingInfoList(self):
        r"""Route relationship list
        :rtype: list of RabbitMQBindingListInfo
        """
        return self._BindingInfoList

    @BindingInfoList.setter
    def BindingInfoList(self, BindingInfoList):
        self._BindingInfoList = BindingInfoList

    @property
    def TotalCount(self):
        r"""Number of routing relationships.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BindingInfoList") is not None:
            self._BindingInfoList = []
            for item in params.get("BindingInfoList"):
                obj = RabbitMQBindingListInfo()
                obj._deserialize(item)
                self._BindingInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQExchangesRequest(AbstractModel):
    r"""DescribeRabbitMQExchanges request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _Offset: Specifies the pagination offset. default is 0.
        :type Offset: int
        :param _Limit: Pagination limit. default is 20.
        :type Limit: int
        :param _SearchWord: Search keyword, supports fuzzy matching.  
        :type SearchWord: str
        :param _ExchangeTypeFilters: Filters the exchange type. each element in the array is a selected filter type. only direct, fanout, topic, and header are supported.
        :type ExchangeTypeFilters: list of str
        :param _ExchangeCreatorFilters: Filter exchange creation source, "system": "system created", "user": "user created".
        :type ExchangeCreatorFilters: list of str
        :param _ExchangeName: Exchange name, used for exact matching.
        :type ExchangeName: str
        :param _SortElement: Sorting field:
MessageRateInOut - Total production and consumption rate.
MessageRateIn - Production rate.
MessageRateOut - Consumption rate: Specifies the message consumption rate.
        :type SortElement: str
        :param _SortOrder: Sorting order. Valid values: ascend and descend.
Specifies the ascending order.
Desc - descending.
        :type SortOrder: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._ExchangeTypeFilters = None
        self._ExchangeCreatorFilters = None
        self._ExchangeName = None
        self._SortElement = None
        self._SortOrder = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Offset(self):
        r"""Specifies the pagination offset. default is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination limit. default is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        r"""Search keyword, supports fuzzy matching.  
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def ExchangeTypeFilters(self):
        r"""Filters the exchange type. each element in the array is a selected filter type. only direct, fanout, topic, and header are supported.
        :rtype: list of str
        """
        return self._ExchangeTypeFilters

    @ExchangeTypeFilters.setter
    def ExchangeTypeFilters(self, ExchangeTypeFilters):
        self._ExchangeTypeFilters = ExchangeTypeFilters

    @property
    def ExchangeCreatorFilters(self):
        r"""Filter exchange creation source, "system": "system created", "user": "user created".
        :rtype: list of str
        """
        return self._ExchangeCreatorFilters

    @ExchangeCreatorFilters.setter
    def ExchangeCreatorFilters(self, ExchangeCreatorFilters):
        self._ExchangeCreatorFilters = ExchangeCreatorFilters

    @property
    def ExchangeName(self):
        r"""Exchange name, used for exact matching.
        :rtype: str
        """
        return self._ExchangeName

    @ExchangeName.setter
    def ExchangeName(self, ExchangeName):
        self._ExchangeName = ExchangeName

    @property
    def SortElement(self):
        r"""Sorting field:
MessageRateInOut - Total production and consumption rate.
MessageRateIn - Production rate.
MessageRateOut - Consumption rate: Specifies the message consumption rate.
        :rtype: str
        """
        return self._SortElement

    @SortElement.setter
    def SortElement(self, SortElement):
        self._SortElement = SortElement

    @property
    def SortOrder(self):
        r"""Sorting order. Valid values: ascend and descend.
Specifies the ascending order.
Desc - descending.
        :rtype: str
        """
        return self._SortOrder

    @SortOrder.setter
    def SortOrder(self, SortOrder):
        self._SortOrder = SortOrder


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._ExchangeTypeFilters = params.get("ExchangeTypeFilters")
        self._ExchangeCreatorFilters = params.get("ExchangeCreatorFilters")
        self._ExchangeName = params.get("ExchangeName")
        self._SortElement = params.get("SortElement")
        self._SortOrder = params.get("SortOrder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQExchangesResponse(AbstractModel):
    r"""DescribeRabbitMQExchanges response structure.

    """

    def __init__(self):
        r"""
        :param _ExchangeInfoList: Policy list information.
        :type ExchangeInfoList: list of RabbitMQExchangeListInfo
        :param _TotalCount: Total number of policy results.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ExchangeInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ExchangeInfoList(self):
        r"""Policy list information.
        :rtype: list of RabbitMQExchangeListInfo
        """
        return self._ExchangeInfoList

    @ExchangeInfoList.setter
    def ExchangeInfoList(self, ExchangeInfoList):
        self._ExchangeInfoList = ExchangeInfoList

    @property
    def TotalCount(self):
        r"""Total number of policy results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ExchangeInfoList") is not None:
            self._ExchangeInfoList = []
            for item in params.get("ExchangeInfoList"):
                obj = RabbitMQExchangeListInfo()
                obj._deserialize(item)
                self._ExchangeInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQNodeListRequest(AbstractModel):
    r"""DescribeRabbitMQNodeList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. specifies the effective InstanceId that can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _Offset: Offset, default value 0.
        :type Offset: int
        :param _Limit: Page limit. default value: 20.
        :type Limit: int
        :param _NodeName: Node name for fuzzy search
        :type NodeName: str
        :param _Filters: Filter parameter name and value. currently only support filtering based on node status.
"Name": "nodeStatus"
"Value": running or down

        :type Filters: list of Filter
        :param _SortElement: Sorts by the specified element. only 2 are present.
CPU usage: specifies the CPU utilization of the node.
diskUsage: specifies the node disk utilization.
        :type SortElement: str
        :param _SortOrder: Sorting order.
Valid values: `ascend`, `descend`.
        :type SortOrder: str
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._NodeName = None
        self._Filters = None
        self._SortElement = None
        self._SortOrder = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. specifies the effective InstanceId that can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""Offset, default value 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page limit. default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NodeName(self):
        r"""Node name for fuzzy search
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Filters(self):
        r"""Filter parameter name and value. currently only support filtering based on node status.
"Name": "nodeStatus"
"Value": running or down

        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortElement(self):
        r"""Sorts by the specified element. only 2 are present.
CPU usage: specifies the CPU utilization of the node.
diskUsage: specifies the node disk utilization.
        :rtype: str
        """
        return self._SortElement

    @SortElement.setter
    def SortElement(self, SortElement):
        self._SortElement = SortElement

    @property
    def SortOrder(self):
        r"""Sorting order.
Valid values: `ascend`, `descend`.
        :rtype: str
        """
        return self._SortOrder

    @SortOrder.setter
    def SortOrder(self, SortOrder):
        self._SortOrder = SortOrder


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NodeName = params.get("NodeName")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortElement = params.get("SortElement")
        self._SortOrder = params.get("SortOrder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQNodeListResponse(AbstractModel):
    r"""DescribeRabbitMQNodeList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Specifies the cluster node quantity.
        :type TotalCount: int
        :param _NodeList: Listing Cluster Nodes
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeList: list of RabbitMQPrivateNode
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._NodeList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Specifies the cluster node quantity.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NodeList(self):
        r"""Listing Cluster Nodes
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RabbitMQPrivateNode
        """
        return self._NodeList

    @NodeList.setter
    def NodeList(self, NodeList):
        self._NodeList = NodeList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("NodeList") is not None:
            self._NodeList = []
            for item in params.get("NodeList"):
                obj = RabbitMQPrivateNode()
                obj._deserialize(item)
                self._NodeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQPermissionRequest(AbstractModel):
    r"""DescribeRabbitMQPermission request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :type User: str
        :param _VirtualHost: VirtualHost name, such as testvhost. valid VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _Offset: Specifies the page Offset. default is 0.
        :type Offset: int
        :param _Limit: Page Limit. default value: 20.
        :type Limit: int
        """
        self._InstanceId = None
        self._User = None
        self._VirtualHost = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. valid VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Offset(self):
        r"""Specifies the page Offset. default is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page Limit. default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._VirtualHost = params.get("VirtualHost")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQPermissionResponse(AbstractModel):
    r"""DescribeRabbitMQPermission response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Specifies the number of permissions returned.
        :type TotalCount: int
        :param _RabbitMQPermissionList: Permission details list.
        :type RabbitMQPermissionList: list of RabbitMQPermission
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RabbitMQPermissionList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Specifies the number of permissions returned.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RabbitMQPermissionList(self):
        r"""Permission details list.
        :rtype: list of RabbitMQPermission
        """
        return self._RabbitMQPermissionList

    @RabbitMQPermissionList.setter
    def RabbitMQPermissionList(self, RabbitMQPermissionList):
        self._RabbitMQPermissionList = RabbitMQPermissionList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RabbitMQPermissionList") is not None:
            self._RabbitMQPermissionList = []
            for item in params.get("RabbitMQPermissionList"):
                obj = RabbitMQPermission()
                obj._deserialize(item)
                self._RabbitMQPermissionList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQQueueDetailRequest(AbstractModel):
    r"""DescribeRabbitMQQueueDetail request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _QueueName: Queue Name
        :type QueueName: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._QueueName = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def QueueName(self):
        r"""Queue Name
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQQueueDetailResponse(AbstractModel):
    r"""DescribeRabbitMQQueueDetail response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance name
        :type InstanceId: str
        :param _VirtualHost: Vhost parameter.
        :type VirtualHost: str
        :param _QueueName: Queue name.
        :type QueueName: str
        :param _QueueType: Queue type. Valid values: classic and quorum.
        :type QueueType: str
        :param _Consumers: The number of online consumers.

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Consumers: int
        :param _Durable: Durable queue flag.
        :type Durable: bool
        :param _AutoDelete: Automatic cleanup.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AutoDelete: bool
        :param _Remark: Remarks

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Remark: str
        :param _MessageTTL: Messagettl parameter, specific to classic type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessageTTL: int
        :param _AutoExpire: Autoexpire parameter.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AutoExpire: int
        :param _MaxLength: The maxlength parameter specifies the maximum length.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MaxLength: int
        :param _MaxLengthBytes: The maxlengthbytes parameter specifies the maximum length in bytes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MaxLengthBytes: int
        :param _DeliveryLimit: The deliverylimit parameter is used for quorum type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeliveryLimit: int
        :param _OverflowBehaviour: The overflowbehaviour parameter specifies the behavior when overflow occurs. Valid values: drop-head, reject-publish, reject-publish-dlx.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type OverflowBehaviour: str
        :param _DeadLetterExchange: The deadletterexchange parameter specifies the dead letter exchange.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeadLetterExchange: str
        :param _DeadLetterRoutingKey: The deadletterroutingkey parameter specifies the routing key for dead letters. Valid values: [value1, value2, value3].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeadLetterRoutingKey: str
        :param _SingleActiveConsumer: The singleactiveconsumer parameter indicates whether only one consumer can be active at a time. Valid values: [true, false].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type SingleActiveConsumer: bool
        :param _MaximumPriority: The maximumpriority parameter, for classic type only, specifies the maximum priority level. Value range: 1-30.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MaximumPriority: int
        :param _LazyMode: The lazymode parameter, for classic type only, indicates whether lazy mode is enabled. Valid values: [true, false].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type LazyMode: bool
        :param _MasterLocator: The masterlocator parameter, for classic type only, specifies the master locator strategy. Valid values: [strategy1, strategy2, strategy3].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MasterLocator: str
        :param _MaxInMemoryLength: The maxinmemorylength parameter, specific to quorum type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MaxInMemoryLength: int
        :param _MaxInMemoryBytes: The maxinmemorybytes parameter, specific to quorum type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MaxInMemoryBytes: int
        :param _CreateTime: Creation timestamp. Unit: seconds.
        :type CreateTime: int
        :param _Node: Node

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Node: str
        :param _DeadLetterStrategy: Quorum queue dead letter consistency policy.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeadLetterStrategy: str
        :param _QueueLeaderLocator: Leader election policy for quorum queue.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type QueueLeaderLocator: str
        :param _QuorumInitialGroupSize: Initial replica group size of arbitration queue.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type QuorumInitialGroupSize: int
        :param _Exclusive: Whether the queue is an exclusive queue.
        :type Exclusive: bool
        :param _Policy: Effective policy name.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Policy: str
        :param _Arguments: Extended parameters of the key-value type.
        :type Arguments: str
        :param _CreateTs: Creation timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification timestamp.
        :type ModifyTs: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._QueueName = None
        self._QueueType = None
        self._Consumers = None
        self._Durable = None
        self._AutoDelete = None
        self._Remark = None
        self._MessageTTL = None
        self._AutoExpire = None
        self._MaxLength = None
        self._MaxLengthBytes = None
        self._DeliveryLimit = None
        self._OverflowBehaviour = None
        self._DeadLetterExchange = None
        self._DeadLetterRoutingKey = None
        self._SingleActiveConsumer = None
        self._MaximumPriority = None
        self._LazyMode = None
        self._MasterLocator = None
        self._MaxInMemoryLength = None
        self._MaxInMemoryBytes = None
        self._CreateTime = None
        self._Node = None
        self._DeadLetterStrategy = None
        self._QueueLeaderLocator = None
        self._QuorumInitialGroupSize = None
        self._Exclusive = None
        self._Policy = None
        self._Arguments = None
        self._CreateTs = None
        self._ModifyTs = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost parameter.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def QueueName(self):
        r"""Queue name.
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def QueueType(self):
        r"""Queue type. Valid values: classic and quorum.
        :rtype: str
        """
        return self._QueueType

    @QueueType.setter
    def QueueType(self, QueueType):
        self._QueueType = QueueType

    @property
    def Consumers(self):
        r"""The number of online consumers.

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Consumers

    @Consumers.setter
    def Consumers(self, Consumers):
        self._Consumers = Consumers

    @property
    def Durable(self):
        r"""Durable queue flag.
        :rtype: bool
        """
        return self._Durable

    @Durable.setter
    def Durable(self, Durable):
        self._Durable = Durable

    @property
    def AutoDelete(self):
        r"""Automatic cleanup.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AutoDelete

    @AutoDelete.setter
    def AutoDelete(self, AutoDelete):
        self._AutoDelete = AutoDelete

    @property
    def Remark(self):
        r"""Remarks

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MessageTTL(self):
        r"""Messagettl parameter, specific to classic type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MessageTTL

    @MessageTTL.setter
    def MessageTTL(self, MessageTTL):
        self._MessageTTL = MessageTTL

    @property
    def AutoExpire(self):
        r"""Autoexpire parameter.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AutoExpire

    @AutoExpire.setter
    def AutoExpire(self, AutoExpire):
        self._AutoExpire = AutoExpire

    @property
    def MaxLength(self):
        r"""The maxlength parameter specifies the maximum length.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxLength

    @MaxLength.setter
    def MaxLength(self, MaxLength):
        self._MaxLength = MaxLength

    @property
    def MaxLengthBytes(self):
        r"""The maxlengthbytes parameter specifies the maximum length in bytes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxLengthBytes

    @MaxLengthBytes.setter
    def MaxLengthBytes(self, MaxLengthBytes):
        self._MaxLengthBytes = MaxLengthBytes

    @property
    def DeliveryLimit(self):
        r"""The deliverylimit parameter is used for quorum type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DeliveryLimit

    @DeliveryLimit.setter
    def DeliveryLimit(self, DeliveryLimit):
        self._DeliveryLimit = DeliveryLimit

    @property
    def OverflowBehaviour(self):
        r"""The overflowbehaviour parameter specifies the behavior when overflow occurs. Valid values: drop-head, reject-publish, reject-publish-dlx.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OverflowBehaviour

    @OverflowBehaviour.setter
    def OverflowBehaviour(self, OverflowBehaviour):
        self._OverflowBehaviour = OverflowBehaviour

    @property
    def DeadLetterExchange(self):
        r"""The deadletterexchange parameter specifies the dead letter exchange.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DeadLetterExchange

    @DeadLetterExchange.setter
    def DeadLetterExchange(self, DeadLetterExchange):
        self._DeadLetterExchange = DeadLetterExchange

    @property
    def DeadLetterRoutingKey(self):
        r"""The deadletterroutingkey parameter specifies the routing key for dead letters. Valid values: [value1, value2, value3].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DeadLetterRoutingKey

    @DeadLetterRoutingKey.setter
    def DeadLetterRoutingKey(self, DeadLetterRoutingKey):
        self._DeadLetterRoutingKey = DeadLetterRoutingKey

    @property
    def SingleActiveConsumer(self):
        r"""The singleactiveconsumer parameter indicates whether only one consumer can be active at a time. Valid values: [true, false].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._SingleActiveConsumer

    @SingleActiveConsumer.setter
    def SingleActiveConsumer(self, SingleActiveConsumer):
        self._SingleActiveConsumer = SingleActiveConsumer

    @property
    def MaximumPriority(self):
        r"""The maximumpriority parameter, for classic type only, specifies the maximum priority level. Value range: 1-30.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaximumPriority

    @MaximumPriority.setter
    def MaximumPriority(self, MaximumPriority):
        self._MaximumPriority = MaximumPriority

    @property
    def LazyMode(self):
        r"""The lazymode parameter, for classic type only, indicates whether lazy mode is enabled. Valid values: [true, false].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._LazyMode

    @LazyMode.setter
    def LazyMode(self, LazyMode):
        self._LazyMode = LazyMode

    @property
    def MasterLocator(self):
        r"""The masterlocator parameter, for classic type only, specifies the master locator strategy. Valid values: [strategy1, strategy2, strategy3].
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MasterLocator

    @MasterLocator.setter
    def MasterLocator(self, MasterLocator):
        self._MasterLocator = MasterLocator

    @property
    def MaxInMemoryLength(self):
        r"""The maxinmemorylength parameter, specific to quorum type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxInMemoryLength

    @MaxInMemoryLength.setter
    def MaxInMemoryLength(self, MaxInMemoryLength):
        self._MaxInMemoryLength = MaxInMemoryLength

    @property
    def MaxInMemoryBytes(self):
        r"""The maxinmemorybytes parameter, specific to quorum type.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxInMemoryBytes

    @MaxInMemoryBytes.setter
    def MaxInMemoryBytes(self, MaxInMemoryBytes):
        self._MaxInMemoryBytes = MaxInMemoryBytes

    @property
    def CreateTime(self):
        r"""Creation timestamp. Unit: seconds.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Node(self):
        r"""Node

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Node

    @Node.setter
    def Node(self, Node):
        self._Node = Node

    @property
    def DeadLetterStrategy(self):
        r"""Quorum queue dead letter consistency policy.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DeadLetterStrategy

    @DeadLetterStrategy.setter
    def DeadLetterStrategy(self, DeadLetterStrategy):
        self._DeadLetterStrategy = DeadLetterStrategy

    @property
    def QueueLeaderLocator(self):
        r"""Leader election policy for quorum queue.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._QueueLeaderLocator

    @QueueLeaderLocator.setter
    def QueueLeaderLocator(self, QueueLeaderLocator):
        self._QueueLeaderLocator = QueueLeaderLocator

    @property
    def QuorumInitialGroupSize(self):
        r"""Initial replica group size of arbitration queue.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._QuorumInitialGroupSize

    @QuorumInitialGroupSize.setter
    def QuorumInitialGroupSize(self, QuorumInitialGroupSize):
        self._QuorumInitialGroupSize = QuorumInitialGroupSize

    @property
    def Exclusive(self):
        r"""Whether the queue is an exclusive queue.
        :rtype: bool
        """
        return self._Exclusive

    @Exclusive.setter
    def Exclusive(self, Exclusive):
        self._Exclusive = Exclusive

    @property
    def Policy(self):
        r"""Effective policy name.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def Arguments(self):
        r"""Extended parameters of the key-value type.
        :rtype: str
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def CreateTs(self):
        r"""Creation timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._QueueName = params.get("QueueName")
        self._QueueType = params.get("QueueType")
        self._Consumers = params.get("Consumers")
        self._Durable = params.get("Durable")
        self._AutoDelete = params.get("AutoDelete")
        self._Remark = params.get("Remark")
        self._MessageTTL = params.get("MessageTTL")
        self._AutoExpire = params.get("AutoExpire")
        self._MaxLength = params.get("MaxLength")
        self._MaxLengthBytes = params.get("MaxLengthBytes")
        self._DeliveryLimit = params.get("DeliveryLimit")
        self._OverflowBehaviour = params.get("OverflowBehaviour")
        self._DeadLetterExchange = params.get("DeadLetterExchange")
        self._DeadLetterRoutingKey = params.get("DeadLetterRoutingKey")
        self._SingleActiveConsumer = params.get("SingleActiveConsumer")
        self._MaximumPriority = params.get("MaximumPriority")
        self._LazyMode = params.get("LazyMode")
        self._MasterLocator = params.get("MasterLocator")
        self._MaxInMemoryLength = params.get("MaxInMemoryLength")
        self._MaxInMemoryBytes = params.get("MaxInMemoryBytes")
        self._CreateTime = params.get("CreateTime")
        self._Node = params.get("Node")
        self._DeadLetterStrategy = params.get("DeadLetterStrategy")
        self._QueueLeaderLocator = params.get("QueueLeaderLocator")
        self._QuorumInitialGroupSize = params.get("QuorumInitialGroupSize")
        self._Exclusive = params.get("Exclusive")
        self._Policy = params.get("Policy")
        self._Arguments = params.get("Arguments")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQQueuesRequest(AbstractModel):
    r"""DescribeRabbitMQQueues request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _Offset: Specifies the pagination Offset. default is 0.
        :type Offset: int
        :param _Limit: Pagination Limit. default is 20.
        :type Limit: int
        :param _SearchWord: Search keywords
        :type SearchWord: str
        :param _QueueType: Filter criteria for queue type. valid values: "all" (default): filter regular and quorum queues; "classic": filter classic (ordinary) queues; "quorum": filter quorum queues.
        :type QueueType: str
        :param _SortElement: Sorting field.
ConsumerNumber - Indicates the number of online consumers.
MessageHeapCount - Indicates the number of retained messages.
MessageRateInOut - Indicates the total production and consumption rate.
MessageRateIn - Production rate.
MessageRateOut - Consumption rate: Specifies the message consumption rate.
        :type SortElement: str
        :param _SortOrder: Sorting order. Valid values: ascend and descend.
Specifies the ascending order.
Desc - descending.
        :type SortOrder: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Offset = None
        self._Limit = None
        self._SearchWord = None
        self._QueueType = None
        self._SortElement = None
        self._SortOrder = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Offset(self):
        r"""Specifies the pagination Offset. default is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination Limit. default is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchWord(self):
        r"""Search keywords
        :rtype: str
        """
        return self._SearchWord

    @SearchWord.setter
    def SearchWord(self, SearchWord):
        self._SearchWord = SearchWord

    @property
    def QueueType(self):
        r"""Filter criteria for queue type. valid values: "all" (default): filter regular and quorum queues; "classic": filter classic (ordinary) queues; "quorum": filter quorum queues.
        :rtype: str
        """
        return self._QueueType

    @QueueType.setter
    def QueueType(self, QueueType):
        self._QueueType = QueueType

    @property
    def SortElement(self):
        r"""Sorting field.
ConsumerNumber - Indicates the number of online consumers.
MessageHeapCount - Indicates the number of retained messages.
MessageRateInOut - Indicates the total production and consumption rate.
MessageRateIn - Production rate.
MessageRateOut - Consumption rate: Specifies the message consumption rate.
        :rtype: str
        """
        return self._SortElement

    @SortElement.setter
    def SortElement(self, SortElement):
        self._SortElement = SortElement

    @property
    def SortOrder(self):
        r"""Sorting order. Valid values: ascend and descend.
Specifies the ascending order.
Desc - descending.
        :rtype: str
        """
        return self._SortOrder

    @SortOrder.setter
    def SortOrder(self, SortOrder):
        self._SortOrder = SortOrder


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchWord = params.get("SearchWord")
        self._QueueType = params.get("QueueType")
        self._SortElement = params.get("SortElement")
        self._SortOrder = params.get("SortOrder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQQueuesResponse(AbstractModel):
    r"""DescribeRabbitMQQueues response structure.

    """

    def __init__(self):
        r"""
        :param _QueueInfoList: Queue list information.
        :type QueueInfoList: list of RabbitMQQueueListInfo
        :param _TotalCount: Number of queues
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QueueInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def QueueInfoList(self):
        r"""Queue list information.
        :rtype: list of RabbitMQQueueListInfo
        """
        return self._QueueInfoList

    @QueueInfoList.setter
    def QueueInfoList(self, QueueInfoList):
        self._QueueInfoList = QueueInfoList

    @property
    def TotalCount(self):
        r"""Number of queues
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QueueInfoList") is not None:
            self._QueueInfoList = []
            for item in params.get("QueueInfoList"):
                obj = RabbitMQQueueListInfo()
                obj._deserialize(item)
                self._QueueInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQUserRequest(AbstractModel):
    r"""DescribeRabbitMQUser request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _SearchUser: Username search by prefix or suffix
        :type SearchUser: str
        :param _Offset: Specifies the page Offset. default is 0.
        :type Offset: int
        :param _Limit: Page Limit. default value: 20.
        :type Limit: int
        :param _User: Username, which is queried by exact match.
        :type User: str
        :param _Tags: User tag, used to determine the access permission of the user for RabbitMQ Management.
management: ordinary console user. monitoring: administrative console user. other value: non-console user.
        :type Tags: list of str
        """
        self._InstanceId = None
        self._SearchUser = None
        self._Offset = None
        self._Limit = None
        self._User = None
        self._Tags = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SearchUser(self):
        r"""Username search by prefix or suffix
        :rtype: str
        """
        return self._SearchUser

    @SearchUser.setter
    def SearchUser(self, SearchUser):
        self._SearchUser = SearchUser

    @property
    def Offset(self):
        r"""Specifies the page Offset. default is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page Limit. default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def User(self):
        r"""Username, which is queried by exact match.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Tags(self):
        r"""User tag, used to determine the access permission of the user for RabbitMQ Management.
management: ordinary console user. monitoring: administrative console user. other value: non-console user.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._SearchUser = params.get("SearchUser")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._User = params.get("User")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQUserResponse(AbstractModel):
    r"""DescribeRabbitMQUser response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Returned number of users
        :type TotalCount: int
        :param _RabbitMQUserList: The list of the created TDMQ for RabbitMQ users
        :type RabbitMQUserList: list of RabbitMQUser
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RabbitMQUserList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Returned number of users
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RabbitMQUserList(self):
        r"""The list of the created TDMQ for RabbitMQ users
        :rtype: list of RabbitMQUser
        """
        return self._RabbitMQUserList

    @RabbitMQUserList.setter
    def RabbitMQUserList(self, RabbitMQUserList):
        self._RabbitMQUserList = RabbitMQUserList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RabbitMQUserList") is not None:
            self._RabbitMQUserList = []
            for item in params.get("RabbitMQUserList"):
                obj = RabbitMQUser()
                obj._deserialize(item)
                self._RabbitMQUserList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQVipInstanceRequest(AbstractModel):
    r"""DescribeRabbitMQVipInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQVipInstanceResponse(AbstractModel):
    r"""DescribeRabbitMQVipInstance response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterInfo: 
        :type ClusterInfo: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterInfo`
        :param _ClusterSpecInfo: 
        :type ClusterSpecInfo: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterSpecInfo`
        :param _ClusterNetInfo: Cluster network information.
        :type ClusterNetInfo: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterAccessInfo`
        :param _ClusterWhiteListInfo: Cluster allowlist.
        :type ClusterWhiteListInfo: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterWhiteListInfo`
        :param _VirtualHostQuota: 
        :type VirtualHostQuota: :class:`tencentcloud.tdmq.v20200217.models.VirtualHostQuota`
        :param _ExchangeQuota: 
        :type ExchangeQuota: :class:`tencentcloud.tdmq.v20200217.models.ExchangeQuota`
        :param _QueueQuota: 
        :type QueueQuota: :class:`tencentcloud.tdmq.v20200217.models.QueueQuota`
        :param _UserQuota: User quota information.
        :type UserQuota: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQUserQuota`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterInfo = None
        self._ClusterSpecInfo = None
        self._ClusterNetInfo = None
        self._ClusterWhiteListInfo = None
        self._VirtualHostQuota = None
        self._ExchangeQuota = None
        self._QueueQuota = None
        self._UserQuota = None
        self._RequestId = None

    @property
    def ClusterInfo(self):
        r"""
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterInfo`
        """
        return self._ClusterInfo

    @ClusterInfo.setter
    def ClusterInfo(self, ClusterInfo):
        self._ClusterInfo = ClusterInfo

    @property
    def ClusterSpecInfo(self):
        r"""
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterSpecInfo`
        """
        return self._ClusterSpecInfo

    @ClusterSpecInfo.setter
    def ClusterSpecInfo(self, ClusterSpecInfo):
        self._ClusterSpecInfo = ClusterSpecInfo

    @property
    def ClusterNetInfo(self):
        r"""Cluster network information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterAccessInfo`
        """
        return self._ClusterNetInfo

    @ClusterNetInfo.setter
    def ClusterNetInfo(self, ClusterNetInfo):
        self._ClusterNetInfo = ClusterNetInfo

    @property
    def ClusterWhiteListInfo(self):
        r"""Cluster allowlist.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQClusterWhiteListInfo`
        """
        return self._ClusterWhiteListInfo

    @ClusterWhiteListInfo.setter
    def ClusterWhiteListInfo(self, ClusterWhiteListInfo):
        self._ClusterWhiteListInfo = ClusterWhiteListInfo

    @property
    def VirtualHostQuota(self):
        r"""
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.VirtualHostQuota`
        """
        return self._VirtualHostQuota

    @VirtualHostQuota.setter
    def VirtualHostQuota(self, VirtualHostQuota):
        self._VirtualHostQuota = VirtualHostQuota

    @property
    def ExchangeQuota(self):
        r"""
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.ExchangeQuota`
        """
        return self._ExchangeQuota

    @ExchangeQuota.setter
    def ExchangeQuota(self, ExchangeQuota):
        self._ExchangeQuota = ExchangeQuota

    @property
    def QueueQuota(self):
        r"""
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.QueueQuota`
        """
        return self._QueueQuota

    @QueueQuota.setter
    def QueueQuota(self, QueueQuota):
        self._QueueQuota = QueueQuota

    @property
    def UserQuota(self):
        r"""User quota information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQUserQuota`
        """
        return self._UserQuota

    @UserQuota.setter
    def UserQuota(self, UserQuota):
        self._UserQuota = UserQuota

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterInfo") is not None:
            self._ClusterInfo = RabbitMQClusterInfo()
            self._ClusterInfo._deserialize(params.get("ClusterInfo"))
        if params.get("ClusterSpecInfo") is not None:
            self._ClusterSpecInfo = RabbitMQClusterSpecInfo()
            self._ClusterSpecInfo._deserialize(params.get("ClusterSpecInfo"))
        if params.get("ClusterNetInfo") is not None:
            self._ClusterNetInfo = RabbitMQClusterAccessInfo()
            self._ClusterNetInfo._deserialize(params.get("ClusterNetInfo"))
        if params.get("ClusterWhiteListInfo") is not None:
            self._ClusterWhiteListInfo = RabbitMQClusterWhiteListInfo()
            self._ClusterWhiteListInfo._deserialize(params.get("ClusterWhiteListInfo"))
        if params.get("VirtualHostQuota") is not None:
            self._VirtualHostQuota = VirtualHostQuota()
            self._VirtualHostQuota._deserialize(params.get("VirtualHostQuota"))
        if params.get("ExchangeQuota") is not None:
            self._ExchangeQuota = ExchangeQuota()
            self._ExchangeQuota._deserialize(params.get("ExchangeQuota"))
        if params.get("QueueQuota") is not None:
            self._QueueQuota = QueueQuota()
            self._QueueQuota._deserialize(params.get("QueueQuota"))
        if params.get("UserQuota") is not None:
            self._UserQuota = RabbitMQUserQuota()
            self._UserQuota._deserialize(params.get("UserQuota"))
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQVipInstancesRequest(AbstractModel):
    r"""DescribeRabbitMQVipInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Query condition filter
        :type Filters: list of Filter
        :param _Limit: Maximum number of items for query. Default value: 20.
        :type Limit: int
        :param _Offset: Starting position of the query. Default value: 0.
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        r"""Query condition filter
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""Maximum number of items for query. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting position of the query. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQVipInstancesResponse(AbstractModel):
    r"""DescribeRabbitMQVipInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of unpaginated items
        :type TotalCount: int
        :param _Instances: Instance information list
        :type Instances: list of RabbitMQVipInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Instances = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of unpaginated items
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Instances(self):
        r"""Instance information list
        :rtype: list of RabbitMQVipInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = RabbitMQVipInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRabbitMQVirtualHostRequest(AbstractModel):
    r"""DescribeRabbitMQVirtualHost request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID
        :type InstanceId: str
        :param _VirtualHost: Vhost name. If this parameter is not specified, all will be queried by default.
        :type VirtualHost: str
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Pagination limit
        :type Limit: int
        :param _Filters: Fuzzy query by vhost name
        :type Filters: :class:`tencentcloud.tdmq.v20200217.models.Filter`
        :param _SortElement: Specifies the sorting field.
MessageHeapCount - specifies the message backlog count.
MessageRateInOut - total production and consumption rate.
MessageRateIn - production rate.
MessageRateOut - consumption rate.
        :type SortElement: str
        :param _SortOrder: Sorting order. Valid values: ascend and descend.
        :type SortOrder: str
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._SortElement = None
        self._SortOrder = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost name. If this parameter is not specified, all will be queried by default.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Offset(self):
        r"""Pagination offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Fuzzy query by vhost name
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.Filter`
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortElement(self):
        r"""Specifies the sorting field.
MessageHeapCount - specifies the message backlog count.
MessageRateInOut - total production and consumption rate.
MessageRateIn - production rate.
MessageRateOut - consumption rate.
        :rtype: str
        """
        return self._SortElement

    @SortElement.setter
    def SortElement(self, SortElement):
        self._SortElement = SortElement

    @property
    def SortOrder(self):
        r"""Sorting order. Valid values: ascend and descend.
        :rtype: str
        """
        return self._SortOrder

    @SortOrder.setter
    def SortOrder(self, SortOrder):
        self._SortOrder = SortOrder


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        self._SortElement = params.get("SortElement")
        self._SortOrder = params.get("SortOrder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRabbitMQVirtualHostResponse(AbstractModel):
    r"""DescribeRabbitMQVirtualHost response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Returned number of vhosts
        :type TotalCount: int
        :param _VirtualHostList: List of vhost details
        :type VirtualHostList: list of RabbitMQVirtualHostInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._VirtualHostList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Returned number of vhosts
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VirtualHostList(self):
        r"""List of vhost details
        :rtype: list of RabbitMQVirtualHostInfo
        """
        return self._VirtualHostList

    @VirtualHostList.setter
    def VirtualHostList(self, VirtualHostList):
        self._VirtualHostList = VirtualHostList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VirtualHostList") is not None:
            self._VirtualHostList = []
            for item in params.get("VirtualHostList"):
                obj = RabbitMQVirtualHostInfo()
                obj._deserialize(item)
                self._VirtualHostList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQClusterRequest(AbstractModel):
    r"""DescribeRocketMQCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQClusterResponse(AbstractModel):
    r"""DescribeRocketMQCluster response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterInfo: Cluster information
        :type ClusterInfo: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterInfo`
        :param _ClusterConfig: Cluster configuration
        :type ClusterConfig: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterConfig`
        :param _ClusterStats: Cluster recent usage, about to be deprecated. Use TCOP to obtain related data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterStats: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterRecentStats`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterInfo = None
        self._ClusterConfig = None
        self._ClusterStats = None
        self._RequestId = None

    @property
    def ClusterInfo(self):
        r"""Cluster information
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterInfo`
        """
        return self._ClusterInfo

    @ClusterInfo.setter
    def ClusterInfo(self, ClusterInfo):
        self._ClusterInfo = ClusterInfo

    @property
    def ClusterConfig(self):
        r"""Cluster configuration
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterConfig`
        """
        return self._ClusterConfig

    @ClusterConfig.setter
    def ClusterConfig(self, ClusterConfig):
        self._ClusterConfig = ClusterConfig

    @property
    def ClusterStats(self):
        r"""Cluster recent usage, about to be deprecated. Use TCOP to obtain related data.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterRecentStats`
        """
        return self._ClusterStats

    @ClusterStats.setter
    def ClusterStats(self, ClusterStats):
        self._ClusterStats = ClusterStats

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterInfo") is not None:
            self._ClusterInfo = RocketMQClusterInfo()
            self._ClusterInfo._deserialize(params.get("ClusterInfo"))
        if params.get("ClusterConfig") is not None:
            self._ClusterConfig = RocketMQClusterConfig()
            self._ClusterConfig._deserialize(params.get("ClusterConfig"))
        if params.get("ClusterStats") is not None:
            self._ClusterStats = RocketMQClusterRecentStats()
            self._ClusterStats._deserialize(params.get("ClusterStats"))
        self._RequestId = params.get("RequestId")


class DescribeRocketMQClustersRequest(AbstractModel):
    r"""DescribeRocketMQClusters request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The max number of returned results.
        :type Limit: int
        :param _IdKeyword: Search by cluster ID.
        :type IdKeyword: str
        :param _NameKeyword: Search by cluster name.
        :type NameKeyword: str
        :param _ClusterIdList: Filter by cluster ID.
        :type ClusterIdList: list of str
        :param _IsTagFilter: For filtering by tag, this parameter must be set to `true`.
        :type IsTagFilter: bool
        :param _Filters: Filter. Currently, you can filter only by tag.
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._IdKeyword = None
        self._NameKeyword = None
        self._ClusterIdList = None
        self._IsTagFilter = None
        self._Filters = None

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The max number of returned results.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def IdKeyword(self):
        r"""Search by cluster ID.
        :rtype: str
        """
        return self._IdKeyword

    @IdKeyword.setter
    def IdKeyword(self, IdKeyword):
        self._IdKeyword = IdKeyword

    @property
    def NameKeyword(self):
        r"""Search by cluster name.
        :rtype: str
        """
        return self._NameKeyword

    @NameKeyword.setter
    def NameKeyword(self, NameKeyword):
        self._NameKeyword = NameKeyword

    @property
    def ClusterIdList(self):
        r"""Filter by cluster ID.
        :rtype: list of str
        """
        return self._ClusterIdList

    @ClusterIdList.setter
    def ClusterIdList(self, ClusterIdList):
        self._ClusterIdList = ClusterIdList

    @property
    def IsTagFilter(self):
        r"""For filtering by tag, this parameter must be set to `true`.
        :rtype: bool
        """
        return self._IsTagFilter

    @IsTagFilter.setter
    def IsTagFilter(self, IsTagFilter):
        self._IsTagFilter = IsTagFilter

    @property
    def Filters(self):
        r"""Filter. Currently, you can filter only by tag.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._IdKeyword = params.get("IdKeyword")
        self._NameKeyword = params.get("NameKeyword")
        self._ClusterIdList = params.get("ClusterIdList")
        self._IsTagFilter = params.get("IsTagFilter")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQClustersResponse(AbstractModel):
    r"""DescribeRocketMQClusters response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterList: Cluster information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterList: list of RocketMQClusterDetail
        :param _TotalCount: The total number of returned results.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ClusterList(self):
        r"""Cluster information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RocketMQClusterDetail
        """
        return self._ClusterList

    @ClusterList.setter
    def ClusterList(self, ClusterList):
        self._ClusterList = ClusterList

    @property
    def TotalCount(self):
        r"""The total number of returned results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterList") is not None:
            self._ClusterList = []
            for item in params.get("ClusterList"):
                obj = RocketMQClusterDetail()
                obj._deserialize(item)
                self._ClusterList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQEnvironmentRolesRequest(AbstractModel):
    r"""DescribeRocketMQEnvironmentRoles request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Required. Specifies the ID of the RocketMQ cluster.
        :type ClusterId: str
        :param _EnvironmentId: Namespace
        :type EnvironmentId: str
        :param _Offset: Starting index. Default is 0 if left empty.
        :type Offset: int
        :param _Limit: Number of returns, default to 10 if not specified, maximum value: 20.
        :type Limit: int
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Filters: Filters RoleName by role name for precise query. Type: string. Required: no.
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._Offset = None
        self._Limit = None
        self._RoleName = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""Required. Specifies the ID of the RocketMQ cluster.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Namespace
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Offset(self):
        r"""Starting index. Default is 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returns, default to 10 if not specified, maximum value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Filters(self):
        r"""Filters RoleName by role name for precise query. Type: string. Required: no.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RoleName = params.get("RoleName")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQEnvironmentRolesResponse(AbstractModel):
    r"""DescribeRocketMQEnvironmentRoles response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Record count.
        :type TotalCount: int
        :param _EnvironmentRoleSets: Namespace role collection.
        :type EnvironmentRoleSets: list of EnvironmentRole
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EnvironmentRoleSets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Record count.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EnvironmentRoleSets(self):
        r"""Namespace role collection.
        :rtype: list of EnvironmentRole
        """
        return self._EnvironmentRoleSets

    @EnvironmentRoleSets.setter
    def EnvironmentRoleSets(self, EnvironmentRoleSets):
        self._EnvironmentRoleSets = EnvironmentRoleSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EnvironmentRoleSets") is not None:
            self._EnvironmentRoleSets = []
            for item in params.get("EnvironmentRoleSets"):
                obj = EnvironmentRole()
                obj._deserialize(item)
                self._EnvironmentRoleSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQGroupsRequest(AbstractModel):
    r"""DescribeRocketMQGroups request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _NamespaceId: Namespace.
        :type NamespaceId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The max number of returned results.
        :type Limit: int
        :param _FilterTopic: Topic name, which can be used to query all subscription groups under the topic
        :type FilterTopic: str
        :param _FilterGroup: Consumer group query by consumer group name. Fuzzy query is supported
        :type FilterGroup: str
        :param _SortedBy: Sorts by the specified field. Valid value: subscribeNum: number of subscribed topics.
        :type SortedBy: str
        :param _SortOrder: Sort in ascending or descending order. Valid values: `asc`, `desc`.
        :type SortOrder: str
        :param _FilterOneGroup: Subscription group name. After it is specified, the information of only this subscription group will be returned.
        :type FilterOneGroup: str
        :param _Types: Group type
        :type Types: list of str
        :param _TagFilters: Tag filter
        :type TagFilters: list of TagFilter
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._Offset = None
        self._Limit = None
        self._FilterTopic = None
        self._FilterGroup = None
        self._SortedBy = None
        self._SortOrder = None
        self._FilterOneGroup = None
        self._Types = None
        self._TagFilters = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The max number of returned results.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def FilterTopic(self):
        r"""Topic name, which can be used to query all subscription groups under the topic
        :rtype: str
        """
        return self._FilterTopic

    @FilterTopic.setter
    def FilterTopic(self, FilterTopic):
        self._FilterTopic = FilterTopic

    @property
    def FilterGroup(self):
        r"""Consumer group query by consumer group name. Fuzzy query is supported
        :rtype: str
        """
        return self._FilterGroup

    @FilterGroup.setter
    def FilterGroup(self, FilterGroup):
        self._FilterGroup = FilterGroup

    @property
    def SortedBy(self):
        r"""Sorts by the specified field. Valid value: subscribeNum: number of subscribed topics.
        :rtype: str
        """
        return self._SortedBy

    @SortedBy.setter
    def SortedBy(self, SortedBy):
        self._SortedBy = SortedBy

    @property
    def SortOrder(self):
        r"""Sort in ascending or descending order. Valid values: `asc`, `desc`.
        :rtype: str
        """
        return self._SortOrder

    @SortOrder.setter
    def SortOrder(self, SortOrder):
        self._SortOrder = SortOrder

    @property
    def FilterOneGroup(self):
        r"""Subscription group name. After it is specified, the information of only this subscription group will be returned.
        :rtype: str
        """
        return self._FilterOneGroup

    @FilterOneGroup.setter
    def FilterOneGroup(self, FilterOneGroup):
        self._FilterOneGroup = FilterOneGroup

    @property
    def Types(self):
        r"""Group type
        :rtype: list of str
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def TagFilters(self):
        r"""Tag filter
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._FilterTopic = params.get("FilterTopic")
        self._FilterGroup = params.get("FilterGroup")
        self._SortedBy = params.get("SortedBy")
        self._SortOrder = params.get("SortOrder")
        self._FilterOneGroup = params.get("FilterOneGroup")
        self._Types = params.get("Types")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQGroupsResponse(AbstractModel):
    r"""DescribeRocketMQGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of subscription groups.
        :type TotalCount: int
        :param _Groups: List of subscription groups
        :type Groups: list of RocketMQGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Groups = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of subscription groups.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Groups(self):
        r"""List of subscription groups
        :rtype: list of RocketMQGroup
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = RocketMQGroup()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQMsgRequest(AbstractModel):
    r"""DescribeRocketMQMsg request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _EnvironmentId: Namespace ID
        :type EnvironmentId: str
        :param _TopicName: Topic name. Pass in the group ID when querying a dead letter queue.
        :type TopicName: str
        :param _MsgId: Message ID
        :type MsgId: str
        :param _PulsarMsgId: ID of a TDMQ for Pulsar message
        :type PulsarMsgId: str
        :param _QueryDlqMsg: The value of this parameter is `true` when you query a dead letter queue. It only applies to TDMQ for RocketMQ.
        :type QueryDlqMsg: bool
        :param _QueryDeadLetterMessage: The value is true when querying dead letters, and only valid for RocketMQ.
        :type QueryDeadLetterMessage: bool
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Pagination limit
        :type Limit: int
        :param _FilterTrackGroup: Filters consumption details based on the consumer group name.
        :type FilterTrackGroup: str
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._TopicName = None
        self._MsgId = None
        self._PulsarMsgId = None
        self._QueryDlqMsg = None
        self._QueryDeadLetterMessage = None
        self._Offset = None
        self._Limit = None
        self._FilterTrackGroup = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Namespace ID
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name. Pass in the group ID when querying a dead letter queue.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def PulsarMsgId(self):
        r"""ID of a TDMQ for Pulsar message
        :rtype: str
        """
        return self._PulsarMsgId

    @PulsarMsgId.setter
    def PulsarMsgId(self, PulsarMsgId):
        self._PulsarMsgId = PulsarMsgId

    @property
    def QueryDlqMsg(self):
        warnings.warn("parameter `QueryDlqMsg` is deprecated", DeprecationWarning) 

        r"""The value of this parameter is `true` when you query a dead letter queue. It only applies to TDMQ for RocketMQ.
        :rtype: bool
        """
        return self._QueryDlqMsg

    @QueryDlqMsg.setter
    def QueryDlqMsg(self, QueryDlqMsg):
        warnings.warn("parameter `QueryDlqMsg` is deprecated", DeprecationWarning) 

        self._QueryDlqMsg = QueryDlqMsg

    @property
    def QueryDeadLetterMessage(self):
        r"""The value is true when querying dead letters, and only valid for RocketMQ.
        :rtype: bool
        """
        return self._QueryDeadLetterMessage

    @QueryDeadLetterMessage.setter
    def QueryDeadLetterMessage(self, QueryDeadLetterMessage):
        self._QueryDeadLetterMessage = QueryDeadLetterMessage

    @property
    def Offset(self):
        r"""Pagination offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def FilterTrackGroup(self):
        r"""Filters consumption details based on the consumer group name.
        :rtype: str
        """
        return self._FilterTrackGroup

    @FilterTrackGroup.setter
    def FilterTrackGroup(self, FilterTrackGroup):
        self._FilterTrackGroup = FilterTrackGroup


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._MsgId = params.get("MsgId")
        self._PulsarMsgId = params.get("PulsarMsgId")
        self._QueryDlqMsg = params.get("QueryDlqMsg")
        self._QueryDeadLetterMessage = params.get("QueryDeadLetterMessage")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._FilterTrackGroup = params.get("FilterTrackGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQMsgResponse(AbstractModel):
    r"""DescribeRocketMQMsg response structure.

    """

    def __init__(self):
        r"""
        :param _Body: Message body
        :type Body: str
        :param _Properties: Details parameter
        :type Properties: str
        :param _ProduceTime: Production time
        :type ProduceTime: str
        :param _MsgId: Message ID
        :type MsgId: str
        :param _ProducerAddr: Producer address
        :type ProducerAddr: str
        :param _MessageTracks: Consumer group consumption list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MessageTracks: list of RocketMQMessageTrack
        :param _ShowTopicName: Topic name displayed on the details page
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShowTopicName: str
        :param _MessageTracksCount: Total number of consumer group consumption lists.
        :type MessageTracksCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Body = None
        self._Properties = None
        self._ProduceTime = None
        self._MsgId = None
        self._ProducerAddr = None
        self._MessageTracks = None
        self._ShowTopicName = None
        self._MessageTracksCount = None
        self._RequestId = None

    @property
    def Body(self):
        r"""Message body
        :rtype: str
        """
        return self._Body

    @Body.setter
    def Body(self, Body):
        self._Body = Body

    @property
    def Properties(self):
        r"""Details parameter
        :rtype: str
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def ProduceTime(self):
        r"""Production time
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ProducerAddr(self):
        r"""Producer address
        :rtype: str
        """
        return self._ProducerAddr

    @ProducerAddr.setter
    def ProducerAddr(self, ProducerAddr):
        self._ProducerAddr = ProducerAddr

    @property
    def MessageTracks(self):
        r"""Consumer group consumption list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RocketMQMessageTrack
        """
        return self._MessageTracks

    @MessageTracks.setter
    def MessageTracks(self, MessageTracks):
        self._MessageTracks = MessageTracks

    @property
    def ShowTopicName(self):
        r"""Topic name displayed on the details page
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ShowTopicName

    @ShowTopicName.setter
    def ShowTopicName(self, ShowTopicName):
        self._ShowTopicName = ShowTopicName

    @property
    def MessageTracksCount(self):
        r"""Total number of consumer group consumption lists.
        :rtype: int
        """
        return self._MessageTracksCount

    @MessageTracksCount.setter
    def MessageTracksCount(self, MessageTracksCount):
        self._MessageTracksCount = MessageTracksCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Body = params.get("Body")
        self._Properties = params.get("Properties")
        self._ProduceTime = params.get("ProduceTime")
        self._MsgId = params.get("MsgId")
        self._ProducerAddr = params.get("ProducerAddr")
        if params.get("MessageTracks") is not None:
            self._MessageTracks = []
            for item in params.get("MessageTracks"):
                obj = RocketMQMessageTrack()
                obj._deserialize(item)
                self._MessageTracks.append(obj)
        self._ShowTopicName = params.get("ShowTopicName")
        self._MessageTracksCount = params.get("MessageTracksCount")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQMsgTraceRequest(AbstractModel):
    r"""DescribeRocketMQMsgTrace request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _EnvironmentId: Namespace
        :type EnvironmentId: str
        :param _TopicName: Topic. When the system queries RocketMQ dead letters, the value is groupId.
        :type TopicName: str
        :param _MsgId: Message ID
        :type MsgId: str
        :param _GroupName: Consumer Group and Subscription
        :type GroupName: str
        :param _QueryDLQMsg: The value is true when querying dead letters.
        :type QueryDLQMsg: bool
        :param _QueryDeadLetterMessage: The value is true when querying dead letters.
        :type QueryDeadLetterMessage: str
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._TopicName = None
        self._MsgId = None
        self._GroupName = None
        self._QueryDLQMsg = None
        self._QueryDeadLetterMessage = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Namespace
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic. When the system queries RocketMQ dead letters, the value is groupId.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def GroupName(self):
        r"""Consumer Group and Subscription
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def QueryDLQMsg(self):
        warnings.warn("parameter `QueryDLQMsg` is deprecated", DeprecationWarning) 

        r"""The value is true when querying dead letters.
        :rtype: bool
        """
        return self._QueryDLQMsg

    @QueryDLQMsg.setter
    def QueryDLQMsg(self, QueryDLQMsg):
        warnings.warn("parameter `QueryDLQMsg` is deprecated", DeprecationWarning) 

        self._QueryDLQMsg = QueryDLQMsg

    @property
    def QueryDeadLetterMessage(self):
        r"""The value is true when querying dead letters.
        :rtype: str
        """
        return self._QueryDeadLetterMessage

    @QueryDeadLetterMessage.setter
    def QueryDeadLetterMessage(self, QueryDeadLetterMessage):
        self._QueryDeadLetterMessage = QueryDeadLetterMessage


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._MsgId = params.get("MsgId")
        self._GroupName = params.get("GroupName")
        self._QueryDLQMsg = params.get("QueryDLQMsg")
        self._QueryDeadLetterMessage = params.get("QueryDeadLetterMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQMsgTraceResponse(AbstractModel):
    r"""DescribeRocketMQMsgTrace response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Trace details list.
        :type Result: list of TraceResult
        :param _ShowTopicName: Topic Name Displayed on Message Trace Page
        :type ShowTopicName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._ShowTopicName = None
        self._RequestId = None

    @property
    def Result(self):
        r"""Trace details list.
        :rtype: list of TraceResult
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ShowTopicName(self):
        r"""Topic Name Displayed on Message Trace Page
        :rtype: str
        """
        return self._ShowTopicName

    @ShowTopicName.setter
    def ShowTopicName(self, ShowTopicName):
        self._ShowTopicName = ShowTopicName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = TraceResult()
                obj._deserialize(item)
                self._Result.append(obj)
        self._ShowTopicName = params.get("ShowTopicName")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQNamespacesRequest(AbstractModel):
    r"""DescribeRocketMQNamespaces request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: The max number of returned results.
        :type Limit: int
        :param _NameKeyword: Search by name.
        :type NameKeyword: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._NameKeyword = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The max number of returned results.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NameKeyword(self):
        r"""Search by name.
        :rtype: str
        """
        return self._NameKeyword

    @NameKeyword.setter
    def NameKeyword(self, NameKeyword):
        self._NameKeyword = NameKeyword


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NameKeyword = params.get("NameKeyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQNamespacesResponse(AbstractModel):
    r"""DescribeRocketMQNamespaces response structure.

    """

    def __init__(self):
        r"""
        :param _Namespaces: List of namespaces
        :type Namespaces: list of RocketMQNamespace
        :param _TotalCount: The total number of returned results.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Namespaces = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Namespaces(self):
        r"""List of namespaces
        :rtype: list of RocketMQNamespace
        """
        return self._Namespaces

    @Namespaces.setter
    def Namespaces(self, Namespaces):
        self._Namespaces = Namespaces

    @property
    def TotalCount(self):
        r"""The total number of returned results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Namespaces") is not None:
            self._Namespaces = []
            for item in params.get("Namespaces"):
                obj = RocketMQNamespace()
                obj._deserialize(item)
                self._Namespaces.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQProducersRequest(AbstractModel):
    r"""DescribeRocketMQProducers request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace
        :type NamespaceId: str
        :param _Topic: Topic name
        :type Topic: str
        :param _Offset: Pagination Offset
        :type Offset: int
        :param _Limit: Pagination Limit
        :type Limit: int
        :param _Filters: Query filter criteria list. supports the following filter parameters:.

-ClientId: specifies the producer client ID.
-ClientIp: specifies the producer client IP.
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._Topic = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Topic(self):
        r"""Topic name
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Offset(self):
        r"""Pagination Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination Limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""Query filter criteria list. supports the following filter parameters:.

-ClientId: specifies the producer client ID.
-ClientIp: specifies the producer client IP.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Topic = params.get("Topic")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQProducersResponse(AbstractModel):
    r"""DescribeRocketMQProducers response structure.

    """

    def __init__(self):
        r"""
        :param _Producers: Producer client list.
        :type Producers: list of ProducerInfo
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Producers = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Producers(self):
        r"""Producer client list.
        :rtype: list of ProducerInfo
        """
        return self._Producers

    @Producers.setter
    def Producers(self, Producers):
        self._Producers = Producers

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Producers") is not None:
            self._Producers = []
            for item in params.get("Producers"):
                obj = ProducerInfo()
                obj._deserialize(item)
                self._Producers.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQPublicAccessMonitorDataRequest(AbstractModel):
    r"""DescribeRocketMQPublicAccessMonitorData request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Exclusive Edition cluster ID.
        :type InstanceId: str
        :param _MetricName: Metric name. Only single-metric pulling is supported. Currently supported metrics: ClientIntraffic and ClientOuttraffic.
        :type MetricName: str
        :param _StartTime: Start time.
        :type StartTime: str
        :param _EndTime: End time, current time by default.
        :type EndTime: str
        :param _Period: Monitoring statistical period, such as 60 (in seconds). The default value is 300.
        :type Period: int
        """
        self._InstanceId = None
        self._MetricName = None
        self._StartTime = None
        self._EndTime = None
        self._Period = None

    @property
    def InstanceId(self):
        r"""Exclusive Edition cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def MetricName(self):
        r"""Metric name. Only single-metric pulling is supported. Currently supported metrics: ClientIntraffic and ClientOuttraffic.
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time, current time by default.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Period(self):
        r"""Monitoring statistical period, such as 60 (in seconds). The default value is 300.
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._MetricName = params.get("MetricName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Period = params.get("Period")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQPublicAccessMonitorDataResponse(AbstractModel):
    r"""DescribeRocketMQPublicAccessMonitorData response structure.

    """

    def __init__(self):
        r"""
        :param _MetricName: Metric name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MetricName: str
        :param _Period: Monitoring statistical period, such as 60 (in seconds). The default value is 300.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Period: int
        :param _StartTime: Start time, for example, 2018-09-22T19:51:23+08:00.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param _EndTime: End time, such as 2018-09-22T20:51:23+08:00. The default value is the current time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _DataPoints: Data point array
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataPoints: list of RocketMQDataPoint
        :param _Msg: Returned information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Msg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricName = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None
        self._DataPoints = None
        self._Msg = None
        self._RequestId = None

    @property
    def MetricName(self):
        r"""Metric name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def Period(self):
        r"""Monitoring statistical period, such as 60 (in seconds). The default value is 300.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StartTime(self):
        r"""Start time, for example, 2018-09-22T19:51:23+08:00.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time, such as 2018-09-22T20:51:23+08:00. The default value is the current time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataPoints(self):
        r"""Data point array
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RocketMQDataPoint
        """
        return self._DataPoints

    @DataPoints.setter
    def DataPoints(self, DataPoints):
        self._DataPoints = DataPoints

    @property
    def Msg(self):
        r"""Returned information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Msg

    @Msg.setter
    def Msg(self, Msg):
        self._Msg = Msg

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MetricName = params.get("MetricName")
        self._Period = params.get("Period")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("DataPoints") is not None:
            self._DataPoints = []
            for item in params.get("DataPoints"):
                obj = RocketMQDataPoint()
                obj._deserialize(item)
                self._DataPoints.append(obj)
        self._Msg = params.get("Msg")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQPublicAccessPointRequest(AbstractModel):
    r"""DescribeRocketMQPublicAccessPoint request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID. Currently, the system only supports dedicated clusters.
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Cluster ID. Currently, the system only supports dedicated clusters.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQPublicAccessPointResponse(AbstractModel):
    r"""DescribeRocketMQPublicAccessPoint response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Indicates the public network access point status.
0. enabled.
Closed.
2: enabled.
Disabling.
Modifying.
        :type Status: int
        :param _PayStatus: Payment status.
0 or unknown.
Normal.
Indicates arrears.
        :type PayStatus: int
        :param _AccessUrl: Endpoint address.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessUrl: str
        :param _Rules: Security Access Rule List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Rules: list of PublicAccessRule
        :param _Bandwidth: Bandwidth
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bandwidth: int
        :param _PayMode: Payment mode
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayMode: int
        :param _BillingFlow: Whether public network is billed by traffic.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingFlow: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._PayStatus = None
        self._AccessUrl = None
        self._Rules = None
        self._Bandwidth = None
        self._PayMode = None
        self._BillingFlow = None
        self._RequestId = None

    @property
    def Status(self):
        r"""Indicates the public network access point status.
0. enabled.
Closed.
2: enabled.
Disabling.
Modifying.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PayStatus(self):
        r"""Payment status.
0 or unknown.
Normal.
Indicates arrears.
        :rtype: int
        """
        return self._PayStatus

    @PayStatus.setter
    def PayStatus(self, PayStatus):
        self._PayStatus = PayStatus

    @property
    def AccessUrl(self):
        r"""Endpoint address.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessUrl

    @AccessUrl.setter
    def AccessUrl(self, AccessUrl):
        self._AccessUrl = AccessUrl

    @property
    def Rules(self):
        r"""Security Access Rule List
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of PublicAccessRule
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def Bandwidth(self):
        r"""Bandwidth
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def PayMode(self):
        r"""Payment mode
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def BillingFlow(self):
        r"""Whether public network is billed by traffic.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._BillingFlow

    @BillingFlow.setter
    def BillingFlow(self, BillingFlow):
        self._BillingFlow = BillingFlow

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._PayStatus = params.get("PayStatus")
        self._AccessUrl = params.get("AccessUrl")
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = PublicAccessRule()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._Bandwidth = params.get("Bandwidth")
        self._PayMode = params.get("PayMode")
        self._BillingFlow = params.get("BillingFlow")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQRolesRequest(AbstractModel):
    r"""DescribeRocketMQRoles request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Starting index. Default is 0 if left empty.
        :type Offset: int
        :param _Limit: Number of returns, default to 10 if not specified, maximum value: 20.
        :type Limit: int
        :param _ClusterId: Required field, cluster ID
        :type ClusterId: str
        :param _RoleName: Role name, fuzzy search
        :type RoleName: str
        :param _Filters: Filters RoleName by role name for precise query. Type: string. Required: no.
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._ClusterId = None
        self._RoleName = None
        self._Filters = None

    @property
    def Offset(self):
        r"""Starting index. Default is 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returns, default to 10 if not specified, maximum value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ClusterId(self):
        r"""Required field, cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RoleName(self):
        r"""Role name, fuzzy search
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Filters(self):
        r"""Filters RoleName by role name for precise query. Type: string. Required: no.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ClusterId = params.get("ClusterId")
        self._RoleName = params.get("RoleName")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQRolesResponse(AbstractModel):
    r"""DescribeRocketMQRoles response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Record count.
        :type TotalCount: int
        :param _RoleSets: Role array.
        :type RoleSets: list of Role
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RoleSets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Record count.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RoleSets(self):
        r"""Role array.
        :rtype: list of Role
        """
        return self._RoleSets

    @RoleSets.setter
    def RoleSets(self, RoleSets):
        self._RoleSets = RoleSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RoleSets") is not None:
            self._RoleSets = []
            for item in params.get("RoleSets"):
                obj = Role()
                obj._deserialize(item)
                self._RoleSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQTopUsagesRequest(AbstractModel):
    r"""DescribeRocketMQTopUsages request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _MetricName: Metric name. support the following:.
consumeLag. specifies the consumer group backlog count.
deadLetterCount. specifies the dead letter count.
Topic production rate.
Topic consumption rate. specifies the Topic consumption rate.
topicStorageSize. specifies the Topic storage space.
Topic API call count.
        :type MetricName: str
        :param _Limit: Sort quantity. The maximum value is 20.
        :type Limit: int
        """
        self._ClusterId = None
        self._MetricName = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def MetricName(self):
        r"""Metric name. support the following:.
consumeLag. specifies the consumer group backlog count.
deadLetterCount. specifies the dead letter count.
Topic production rate.
Topic consumption rate. specifies the Topic consumption rate.
topicStorageSize. specifies the Topic storage space.
Topic API call count.
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def Limit(self):
        r"""Sort quantity. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._MetricName = params.get("MetricName")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQTopUsagesResponse(AbstractModel):
    r"""DescribeRocketMQTopUsages response structure.

    """

    def __init__(self):
        r"""
        :param _Values: Metric Value List
        :type Values: list of int
        :param _Dimensions: Dimension combinations corresponding to metric value. this API has the following dimensions:.
tenant,namespace,group,topic
        :type Dimensions: list of DimensionInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Values = None
        self._Dimensions = None
        self._RequestId = None

    @property
    def Values(self):
        r"""Metric Value List
        :rtype: list of int
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Dimensions(self):
        r"""Dimension combinations corresponding to metric value. this API has the following dimensions:.
tenant,namespace,group,topic
        :rtype: list of DimensionInstance
        """
        return self._Dimensions

    @Dimensions.setter
    def Dimensions(self, Dimensions):
        self._Dimensions = Dimensions

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Values = params.get("Values")
        if params.get("Dimensions") is not None:
            self._Dimensions = []
            for item in params.get("Dimensions"):
                obj = DimensionInstance()
                obj._deserialize(item)
                self._Dimensions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQTopicMsgsRequest(AbstractModel):
    r"""DescribeRocketMQTopicMsgs request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _EnvironmentId: Namespace
        :type EnvironmentId: str
        :param _TopicName: Topic name, which is groupId when the system queries dead letters.
        :type TopicName: str
        :param _StartTime: Start time.
        :type StartTime: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _MsgKey: Message key
        :type MsgKey: str
        :param _Offset: Query Offset
        :type Offset: int
        :param _Limit: Query Quotas
        :type Limit: int
        :param _TaskRequestId: Mark a pagination transaction.
        :type TaskRequestId: str
        :param _QueryDlqMsg: This value is true when the system queries dead letters, and is only valid for RocketMQ.
        :type QueryDlqMsg: bool
        :param _NumOfLatestMsg: Query the last N messages. The value of N cannot exceed 1024. By default, -1 indicates other query conditions.
        :type NumOfLatestMsg: int
        :param _Tag: Tag expression.
        :type Tag: str
        :param _QueryDeadLetterMessage: This value is true when the system queries dead letters, and is only valid for RocketMQ.
        :type QueryDeadLetterMessage: bool
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._TopicName = None
        self._StartTime = None
        self._EndTime = None
        self._MsgId = None
        self._MsgKey = None
        self._Offset = None
        self._Limit = None
        self._TaskRequestId = None
        self._QueryDlqMsg = None
        self._NumOfLatestMsg = None
        self._Tag = None
        self._QueryDeadLetterMessage = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Namespace
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name, which is groupId when the system queries dead letters.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def MsgKey(self):
        r"""Message key
        :rtype: str
        """
        return self._MsgKey

    @MsgKey.setter
    def MsgKey(self, MsgKey):
        self._MsgKey = MsgKey

    @property
    def Offset(self):
        r"""Query Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Query Quotas
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TaskRequestId(self):
        r"""Mark a pagination transaction.
        :rtype: str
        """
        return self._TaskRequestId

    @TaskRequestId.setter
    def TaskRequestId(self, TaskRequestId):
        self._TaskRequestId = TaskRequestId

    @property
    def QueryDlqMsg(self):
        warnings.warn("parameter `QueryDlqMsg` is deprecated", DeprecationWarning) 

        r"""This value is true when the system queries dead letters, and is only valid for RocketMQ.
        :rtype: bool
        """
        return self._QueryDlqMsg

    @QueryDlqMsg.setter
    def QueryDlqMsg(self, QueryDlqMsg):
        warnings.warn("parameter `QueryDlqMsg` is deprecated", DeprecationWarning) 

        self._QueryDlqMsg = QueryDlqMsg

    @property
    def NumOfLatestMsg(self):
        r"""Query the last N messages. The value of N cannot exceed 1024. By default, -1 indicates other query conditions.
        :rtype: int
        """
        return self._NumOfLatestMsg

    @NumOfLatestMsg.setter
    def NumOfLatestMsg(self, NumOfLatestMsg):
        self._NumOfLatestMsg = NumOfLatestMsg

    @property
    def Tag(self):
        r"""Tag expression.
        :rtype: str
        """
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def QueryDeadLetterMessage(self):
        r"""This value is true when the system queries dead letters, and is only valid for RocketMQ.
        :rtype: bool
        """
        return self._QueryDeadLetterMessage

    @QueryDeadLetterMessage.setter
    def QueryDeadLetterMessage(self, QueryDeadLetterMessage):
        self._QueryDeadLetterMessage = QueryDeadLetterMessage


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MsgId = params.get("MsgId")
        self._MsgKey = params.get("MsgKey")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TaskRequestId = params.get("TaskRequestId")
        self._QueryDlqMsg = params.get("QueryDlqMsg")
        self._NumOfLatestMsg = params.get("NumOfLatestMsg")
        self._Tag = params.get("Tag")
        self._QueryDeadLetterMessage = params.get("QueryDeadLetterMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQTopicMsgsResponse(AbstractModel):
    r"""DescribeRocketMQTopicMsgs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _TopicMsgLogSets: Message List
        :type TopicMsgLogSets: list of RocketMQMsgLog
        :param _TaskRequestId: Mark a pagination transaction.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskRequestId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TopicMsgLogSets = None
        self._TaskRequestId = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TopicMsgLogSets(self):
        r"""Message List
        :rtype: list of RocketMQMsgLog
        """
        return self._TopicMsgLogSets

    @TopicMsgLogSets.setter
    def TopicMsgLogSets(self, TopicMsgLogSets):
        self._TopicMsgLogSets = TopicMsgLogSets

    @property
    def TaskRequestId(self):
        r"""Mark a pagination transaction.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskRequestId

    @TaskRequestId.setter
    def TaskRequestId(self, TaskRequestId):
        self._TaskRequestId = TaskRequestId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TopicMsgLogSets") is not None:
            self._TopicMsgLogSets = []
            for item in params.get("TopicMsgLogSets"):
                obj = RocketMQMsgLog()
                obj._deserialize(item)
                self._TopicMsgLogSets.append(obj)
        self._TaskRequestId = params.get("TaskRequestId")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQTopicRequest(AbstractModel):
    r"""DescribeRocketMQTopic request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace
        :type NamespaceId: str
        :param _TopicName: Topic name
        :type TopicName: str
        :param _ConsumerGroup: Consumer group name.
        :type ConsumerGroup: str
        :param _Offset: Subscription list pagination parameter Offset.
        :type Offset: int
        :param _Limit: Subscription list pagination parameter Limit.
        :type Limit: int
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._TopicName = None
        self._ConsumerGroup = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def TopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def ConsumerGroup(self):
        r"""Consumer group name.
        :rtype: str
        """
        return self._ConsumerGroup

    @ConsumerGroup.setter
    def ConsumerGroup(self, ConsumerGroup):
        self._ConsumerGroup = ConsumerGroup

    @property
    def Offset(self):
        r"""Subscription list pagination parameter Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Subscription list pagination parameter Limit.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._TopicName = params.get("TopicName")
        self._ConsumerGroup = params.get("ConsumerGroup")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQTopicResponse(AbstractModel):
    r"""DescribeRocketMQTopic response structure.

    """

    def __init__(self):
        r"""
        :param _Topic: Topic details.
        :type Topic: :class:`tencentcloud.tdmq.v20200217.models.RocketMQTopic`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Topic = None
        self._RequestId = None

    @property
    def Topic(self):
        r"""Topic details.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQTopic`
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Topic") is not None:
            self._Topic = RocketMQTopic()
            self._Topic._deserialize(params.get("Topic"))
        self._RequestId = params.get("RequestId")


class DescribeRocketMQTopicStatsRequest(AbstractModel):
    r"""DescribeRocketMQTopicStats request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Instance ID.
        :type ClusterId: str
        :param _NamespaceId: Namespace
        :type NamespaceId: str
        :param _TopicName: Topic name
        :type TopicName: str
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._TopicName = None

    @property
    def ClusterId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def TopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQTopicStatsResponse(AbstractModel):
    r"""DescribeRocketMQTopicStats response structure.

    """

    def __init__(self):
        r"""
        :param _TopicStatsList: Production details list.
        :type TopicStatsList: list of TopicStats
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicStatsList = None
        self._RequestId = None

    @property
    def TopicStatsList(self):
        r"""Production details list.
        :rtype: list of TopicStats
        """
        return self._TopicStatsList

    @TopicStatsList.setter
    def TopicStatsList(self, TopicStatsList):
        self._TopicStatsList = TopicStatsList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TopicStatsList") is not None:
            self._TopicStatsList = []
            for item in params.get("TopicStatsList"):
                obj = TopicStats()
                obj._deserialize(item)
                self._TopicStatsList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQTopicsByGroupRequest(AbstractModel):
    r"""DescribeRocketMQTopicsByGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Specifies the namespace name.
        :type NamespaceId: str
        :param _GroupId: Consumer group name.
        :type GroupId: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: Limit of Items
        :type Limit: int
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._GroupId = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Specifies the namespace name.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupId(self):
        r"""Consumer group name.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit of Items
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupId = params.get("GroupId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQTopicsByGroupResponse(AbstractModel):
    r"""DescribeRocketMQTopicsByGroup response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _Topics: Topic list.
        :type Topics: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Topics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of entries
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Topics(self):
        r"""Topic list.
        :rtype: list of str
        """
        return self._Topics

    @Topics.setter
    def Topics(self, Topics):
        self._Topics = Topics

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._Topics = params.get("Topics")
        self._RequestId = params.get("RequestId")


class DescribeRocketMQTopicsRequest(AbstractModel):
    r"""DescribeRocketMQTopics request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset for query.
        :type Offset: int
        :param _Limit: Query limit.
        :type Limit: int
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _NamespaceId: Namespace.
        :type NamespaceId: str
        :param _FilterType: Filter by topic type. Valid values: `Normal`, `GlobalOrder`, `PartitionedOrder`, `Transaction`.
        :type FilterType: list of str
        :param _FilterName: Search by topic name. Fuzzy query is supported.
        :type FilterName: str
        :param _FilterGroup: Filters by subscription consumer group name.
        :type FilterGroup: str
        :param _TagFilters: Tag filter
        :type TagFilters: list of TagFilter
        """
        self._Offset = None
        self._Limit = None
        self._ClusterId = None
        self._NamespaceId = None
        self._FilterType = None
        self._FilterName = None
        self._FilterGroup = None
        self._TagFilters = None

    @property
    def Offset(self):
        r"""Offset for query.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Query limit.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def FilterType(self):
        r"""Filter by topic type. Valid values: `Normal`, `GlobalOrder`, `PartitionedOrder`, `Transaction`.
        :rtype: list of str
        """
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def FilterName(self):
        r"""Search by topic name. Fuzzy query is supported.
        :rtype: str
        """
        return self._FilterName

    @FilterName.setter
    def FilterName(self, FilterName):
        self._FilterName = FilterName

    @property
    def FilterGroup(self):
        r"""Filters by subscription consumer group name.
        :rtype: str
        """
        return self._FilterGroup

    @FilterGroup.setter
    def FilterGroup(self, FilterGroup):
        self._FilterGroup = FilterGroup

    @property
    def TagFilters(self):
        r"""Tag filter
        :rtype: list of TagFilter
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._FilterType = params.get("FilterType")
        self._FilterName = params.get("FilterName")
        self._FilterGroup = params.get("FilterGroup")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagFilter()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQTopicsResponse(AbstractModel):
    r"""DescribeRocketMQTopics response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of query records.
        :type TotalCount: int
        :param _Topics: List of topic information
        :type Topics: list of RocketMQTopic
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Topics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of query records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Topics(self):
        r"""List of topic information
        :rtype: list of RocketMQTopic
        """
        return self._Topics

    @Topics.setter
    def Topics(self, Topics):
        self._Topics = Topics

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Topics") is not None:
            self._Topics = []
            for item in params.get("Topics"):
                obj = RocketMQTopic()
                obj._deserialize(item)
                self._Topics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRocketMQVipInstanceDetailRequest(AbstractModel):
    r"""DescribeRocketMQVipInstanceDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQVipInstanceDetailResponse(AbstractModel):
    r"""DescribeRocketMQVipInstanceDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterInfo: Cluster information
        :type ClusterInfo: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterInfo`
        :param _InstanceConfig: Cluster configuration
        :type InstanceConfig: :class:`tencentcloud.tdmq.v20200217.models.RocketMQInstanceConfig`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterInfo = None
        self._InstanceConfig = None
        self._RequestId = None

    @property
    def ClusterInfo(self):
        r"""Cluster information
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterInfo`
        """
        return self._ClusterInfo

    @ClusterInfo.setter
    def ClusterInfo(self, ClusterInfo):
        self._ClusterInfo = ClusterInfo

    @property
    def InstanceConfig(self):
        r"""Cluster configuration
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQInstanceConfig`
        """
        return self._InstanceConfig

    @InstanceConfig.setter
    def InstanceConfig(self, InstanceConfig):
        self._InstanceConfig = InstanceConfig

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterInfo") is not None:
            self._ClusterInfo = RocketMQClusterInfo()
            self._ClusterInfo._deserialize(params.get("ClusterInfo"))
        if params.get("InstanceConfig") is not None:
            self._InstanceConfig = RocketMQInstanceConfig()
            self._InstanceConfig._deserialize(params.get("InstanceConfig"))
        self._RequestId = params.get("RequestId")


class DescribeRocketMQVipInstancesRequest(AbstractModel):
    r"""DescribeRocketMQVipInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Query condition filter. supported query conditions are as follows:.
Instance ids - specifies the instance ids.
Instance name - specifies the instance name.
Status - specifies the instance status.
        :type Filters: list of Filter
        :param _Limit: The maximum number of queried items, which defaults to 20.
        :type Limit: int
        :param _Offset: Start offset for query
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        r"""Query condition filter. supported query conditions are as follows:.
Instance ids - specifies the instance ids.
Instance name - specifies the instance name.
Status - specifies the instance status.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""The maximum number of queried items, which defaults to 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Start offset for query
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRocketMQVipInstancesResponse(AbstractModel):
    r"""DescribeRocketMQVipInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of unpaginated items
        :type TotalCount: int
        :param _Instances: Instance information list
        :type Instances: list of RocketMQVipInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Instances = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of unpaginated items
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Instances(self):
        r"""Instance information list
        :rtype: list of RocketMQVipInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = RocketMQVipInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRolesRequest(AbstractModel):
    r"""DescribeRoles request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        :param _RoleName: Fuzzy query by role name
        :type RoleName: str
        :param _Offset: Offset. If this parameter is left empty, 0 will be used by default.
        :type Offset: int
        :param _Limit: Number of results to be returned. If this parameter is left empty, 10 will be used by default. The maximum value is 20.
        :type Limit: int
        :param _Filters: * RoleName
Filter by role name for exact query.
Type: String
Required: no
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._RoleName = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RoleName(self):
        r"""Fuzzy query by role name
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Offset(self):
        r"""Offset. If this parameter is left empty, 0 will be used by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of results to be returned. If this parameter is left empty, 10 will be used by default. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""* RoleName
Filter by role name for exact query.
Type: String
Required: no
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RoleName = params.get("RoleName")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRolesResponse(AbstractModel):
    r"""DescribeRoles response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of records.
        :type TotalCount: int
        :param _RoleSets: Array of roles.
        :type RoleSets: list of Role
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RoleSets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RoleSets(self):
        r"""Array of roles.
        :rtype: list of Role
        """
        return self._RoleSets

    @RoleSets.setter
    def RoleSets(self, RoleSets):
        self._RoleSets = RoleSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RoleSets") is not None:
            self._RoleSets = []
            for item in params.get("RoleSets"):
                obj = Role()
                obj._deserialize(item)
                self._RoleSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubscriptionsRequest(AbstractModel):
    r"""DescribeSubscriptions request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _Offset: Offset, which defaults to 0 if left empty.
        :type Offset: int
        :param _Limit: The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :type Limit: int
        :param _SubscriptionName: Fuzzy match by subscriber name.
        :type SubscriptionName: str
        :param _Filters: Data filter.
        :type Filters: list of FilterSubscription
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._SubscriptionName = None
        self._Filters = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        r"""Offset, which defaults to 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SubscriptionName(self):
        r"""Fuzzy match by subscriber name.
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def Filters(self):
        r"""Data filter.
        :rtype: list of FilterSubscription
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SubscriptionName = params.get("SubscriptionName")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterSubscription()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubscriptionsResponse(AbstractModel):
    r"""DescribeSubscriptions response structure.

    """

    def __init__(self):
        r"""
        :param _SubscriptionSets: Array of subscriber sets.
        :type SubscriptionSets: list of Subscription
        :param _TotalCount: The total number of returned results.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubscriptionSets = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SubscriptionSets(self):
        r"""Array of subscriber sets.
        :rtype: list of Subscription
        """
        return self._SubscriptionSets

    @SubscriptionSets.setter
    def SubscriptionSets(self, SubscriptionSets):
        self._SubscriptionSets = SubscriptionSets

    @property
    def TotalCount(self):
        r"""The total number of returned results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubscriptionSets") is not None:
            self._SubscriptionSets = []
            for item in params.get("SubscriptionSets"):
                obj = Subscription()
                obj._deserialize(item)
                self._SubscriptionSets.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTopicMsgsRequest(AbstractModel):
    r"""DescribeTopicMsgs request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _StartTime: Start time.
        :type StartTime: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _Offset: Starting index. Default is 0 if left empty.
        :type Offset: int
        :param _Limit: Number of returns, default to 10 if not specified, maximum value: 20.
        :type Limit: int
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._MsgId = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""Starting index. Default is 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returns, default to 10 if not specified, maximum value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MsgId = params.get("MsgId")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopicMsgsResponse(AbstractModel):
    r"""DescribeTopicMsgs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total record count.
        :type TotalCount: int
        :param _TopicMsgLogSets: Message log list.
        :type TopicMsgLogSets: list of MsgLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TopicMsgLogSets = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total record count.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TopicMsgLogSets(self):
        r"""Message log list.
        :rtype: list of MsgLog
        """
        return self._TopicMsgLogSets

    @TopicMsgLogSets.setter
    def TopicMsgLogSets(self, TopicMsgLogSets):
        self._TopicMsgLogSets = TopicMsgLogSets

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TopicMsgLogSets") is not None:
            self._TopicMsgLogSets = []
            for item in params.get("TopicMsgLogSets"):
                obj = MsgLog()
                obj._deserialize(item)
                self._TopicMsgLogSets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopicsRequest(AbstractModel):
    r"""DescribeTopics request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _ClusterId: Pulsar cluster ID.
        :type ClusterId: str
        :param _TopicName: Fuzzy match by topic name.
        :type TopicName: str
        :param _Offset: Offset, which defaults to 0 if left empty.
        :type Offset: int
        :param _Limit: The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :type Limit: int
        :param _TopicType: Topic type description:
0: Non-persistent and non-partitioned topic;
1: Non-persistent and partitioned topic;
2: Persistent and non-partitioned topic;
3: Persistent and partitioned topic.
        :type TopicType: int
        :param _Filters: * TopicName
Query by topic name for exact search.
Type: String
Required: No
        :type Filters: list of Filter
        :param _TopicCreator: Topic creator:
1: User
2: System
        :type TopicCreator: int
        """
        self._EnvironmentId = None
        self._ClusterId = None
        self._TopicName = None
        self._Offset = None
        self._Limit = None
        self._TopicType = None
        self._Filters = None
        self._TopicCreator = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def TopicName(self):
        r"""Fuzzy match by topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Offset(self):
        r"""Offset, which defaults to 0 if left empty.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The number of results to be returned, which defaults to 10 if left empty. The maximum value is 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TopicType(self):
        r"""Topic type description:
0: Non-persistent and non-partitioned topic;
1: Non-persistent and partitioned topic;
2: Persistent and non-partitioned topic;
3: Persistent and partitioned topic.
        :rtype: int
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType

    @property
    def Filters(self):
        r"""* TopicName
Query by topic name for exact search.
Type: String
Required: No
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TopicCreator(self):
        r"""Topic creator:
1: User
2: System
        :rtype: int
        """
        return self._TopicCreator

    @TopicCreator.setter
    def TopicCreator(self, TopicCreator):
        self._TopicCreator = TopicCreator


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._ClusterId = params.get("ClusterId")
        self._TopicName = params.get("TopicName")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TopicType = params.get("TopicType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._TopicCreator = params.get("TopicCreator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopicsResponse(AbstractModel):
    r"""DescribeTopics response structure.

    """

    def __init__(self):
        r"""
        :param _TopicSets: Array of topic sets.
        :type TopicSets: list of Topic
        :param _TotalCount: The number of topics.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TopicSets = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TopicSets(self):
        r"""Array of topic sets.
        :rtype: list of Topic
        """
        return self._TopicSets

    @TopicSets.setter
    def TopicSets(self, TopicSets):
        self._TopicSets = TopicSets

    @property
    def TotalCount(self):
        r"""The number of topics.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TopicSets") is not None:
            self._TopicSets = []
            for item in params.get("TopicSets"):
                obj = Topic()
                obj._deserialize(item)
                self._TopicSets.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DetailedRolePerm(AbstractModel):
    r"""Permission configuration in the topic/group dimension.

    """

    def __init__(self):
        r"""
        :param _Resource: Resources corresponding to permissions.
        :type Resource: str
        :param _PermWrite: Whether to enable production permission
        :type PermWrite: bool
        :param _PermRead: Whether to enable consumption permission
        :type PermRead: bool
        :param _ResourceType: Authorized resource type (Topic: topic; Group: consumer group).
        :type ResourceType: str
        :param _Remark: Resource remarks.
        :type Remark: str
        """
        self._Resource = None
        self._PermWrite = None
        self._PermRead = None
        self._ResourceType = None
        self._Remark = None

    @property
    def Resource(self):
        r"""Resources corresponding to permissions.
        :rtype: str
        """
        return self._Resource

    @Resource.setter
    def Resource(self, Resource):
        self._Resource = Resource

    @property
    def PermWrite(self):
        r"""Whether to enable production permission
        :rtype: bool
        """
        return self._PermWrite

    @PermWrite.setter
    def PermWrite(self, PermWrite):
        self._PermWrite = PermWrite

    @property
    def PermRead(self):
        r"""Whether to enable consumption permission
        :rtype: bool
        """
        return self._PermRead

    @PermRead.setter
    def PermRead(self, PermRead):
        self._PermRead = PermRead

    @property
    def ResourceType(self):
        r"""Authorized resource type (Topic: topic; Group: consumer group).
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Remark(self):
        r"""Resource remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._Resource = params.get("Resource")
        self._PermWrite = params.get("PermWrite")
        self._PermRead = params.get("PermRead")
        self._ResourceType = params.get("ResourceType")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionInstance(AbstractModel):
    r"""Array of instance dimension combinations

    """

    def __init__(self):
        r"""
        :param _Dimensions: Dimension Combination of Instance
Note: This field may return null, indicating that no valid values can be obtained.
        :type Dimensions: list of DimensionOpt
        """
        self._Dimensions = None

    @property
    def Dimensions(self):
        r"""Dimension Combination of Instance
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DimensionOpt
        """
        return self._Dimensions

    @Dimensions.setter
    def Dimensions(self, Dimensions):
        self._Dimensions = Dimensions


    def _deserialize(self, params):
        if params.get("Dimensions") is not None:
            self._Dimensions = []
            for item in params.get("Dimensions"):
                obj = DimensionOpt()
                obj._deserialize(item)
                self._Dimensions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionOpt(AbstractModel):
    r"""Metric Dimension Object

    """

    def __init__(self):
        r"""
        :param _Name: Queried dimension name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Value: Queried Dimension Value
Note: This field may return null, indicating that no valid values can be obtained.
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        r"""Queried dimension name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""Queried Dimension Value
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Environment(AbstractModel):
    r"""Namespace information

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Namespace name.
        :type EnvironmentId: str
        :param _Remark: Description.
        :type Remark: str
        :param _MsgTTL: Retention period for unconsumed messages in seconds. Maximum value: 1,296,000 seconds (15 days).
        :type MsgTTL: int
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Last modified.
        :type UpdateTime: str
        :param _NamespaceId: Namespace ID.
        :type NamespaceId: str
        :param _NamespaceName: Namespace name.
        :type NamespaceName: str
        :param _TopicNum: The number of topics.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicNum: int
        :param _RetentionPolicy: Message retention policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RetentionPolicy: :class:`tencentcloud.tdmq.v20200217.models.RetentionPolicy`
        :param _AutoSubscriptionCreation: Whether to enable "Auto-Create Subscription"
Note: This field may return null, indicating that no valid values can be obtained.
        :type AutoSubscriptionCreation: bool
        """
        self._EnvironmentId = None
        self._Remark = None
        self._MsgTTL = None
        self._CreateTime = None
        self._UpdateTime = None
        self._NamespaceId = None
        self._NamespaceName = None
        self._TopicNum = None
        self._RetentionPolicy = None
        self._AutoSubscriptionCreation = None

    @property
    def EnvironmentId(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Remark(self):
        r"""Description.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MsgTTL(self):
        r"""Retention period for unconsumed messages in seconds. Maximum value: 1,296,000 seconds (15 days).
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def NamespaceId(self):
        r"""Namespace ID.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def NamespaceName(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._NamespaceName

    @NamespaceName.setter
    def NamespaceName(self, NamespaceName):
        self._NamespaceName = NamespaceName

    @property
    def TopicNum(self):
        r"""The number of topics.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def RetentionPolicy(self):
        r"""Message retention policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RetentionPolicy`
        """
        return self._RetentionPolicy

    @RetentionPolicy.setter
    def RetentionPolicy(self, RetentionPolicy):
        self._RetentionPolicy = RetentionPolicy

    @property
    def AutoSubscriptionCreation(self):
        r"""Whether to enable "Auto-Create Subscription"
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AutoSubscriptionCreation

    @AutoSubscriptionCreation.setter
    def AutoSubscriptionCreation(self, AutoSubscriptionCreation):
        self._AutoSubscriptionCreation = AutoSubscriptionCreation


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._Remark = params.get("Remark")
        self._MsgTTL = params.get("MsgTTL")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._NamespaceId = params.get("NamespaceId")
        self._NamespaceName = params.get("NamespaceName")
        self._TopicNum = params.get("TopicNum")
        if params.get("RetentionPolicy") is not None:
            self._RetentionPolicy = RetentionPolicy()
            self._RetentionPolicy._deserialize(params.get("RetentionPolicy"))
        self._AutoSubscriptionCreation = params.get("AutoSubscriptionCreation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnvironmentRole(AbstractModel):
    r"""Set of environment roles

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace).
        :type EnvironmentId: str
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Permissions: Permissions, which is a non-empty string array of `produce` and `consume` at the most.
        :type Permissions: list of str
        :param _RoleDescribe: Role description.
        :type RoleDescribe: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        """
        self._EnvironmentId = None
        self._RoleName = None
        self._Permissions = None
        self._RoleDescribe = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace).
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Permissions(self):
        r"""Permissions, which is a non-empty string array of `produce` and `consume` at the most.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def RoleDescribe(self):
        r"""Role description.
        :rtype: str
        """
        return self._RoleDescribe

    @RoleDescribe.setter
    def RoleDescribe(self, RoleDescribe):
        self._RoleDescribe = RoleDescribe

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleName = params.get("RoleName")
        self._Permissions = params.get("Permissions")
        self._RoleDescribe = params.get("RoleDescribe")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnvironmentRoleSet(AbstractModel):
    r"""Relationship between the namespaces that are bound in batches and role permissions

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: The IDs of the bound namespaces cannot be delicate and the namespaces must contain resources
Note: This field may return null, indicating that no valid values can be obtained.
        :type EnvironmentId: str
        :param _Permissions: Permissions to be bound to a namespace. Enumerated values: `consume`, `produce`, and `consume, produce`. This parameter cannot be left empty.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Permissions: list of str
        """
        self._EnvironmentId = None
        self._Permissions = None

    @property
    def EnvironmentId(self):
        r"""The IDs of the bound namespaces cannot be delicate and the namespaces must contain resources
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def Permissions(self):
        r"""Permissions to be bound to a namespace. Enumerated values: `consume`, `produce`, and `consume, produce`. This parameter cannot be left empty.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._Permissions = params.get("Permissions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExchangeQuota(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _MaxExchange: 
        :type MaxExchange: int
        :param _UsedExchange: Number of created exchanges.
        :type UsedExchange: int
        """
        self._MaxExchange = None
        self._UsedExchange = None

    @property
    def MaxExchange(self):
        r"""
        :rtype: int
        """
        return self._MaxExchange

    @MaxExchange.setter
    def MaxExchange(self, MaxExchange):
        self._MaxExchange = MaxExchange

    @property
    def UsedExchange(self):
        r"""Number of created exchanges.
        :rtype: int
        """
        return self._UsedExchange

    @UsedExchange.setter
    def UsedExchange(self, UsedExchange):
        self._UsedExchange = UsedExchange


    def _deserialize(self, params):
        self._MaxExchange = params.get("MaxExchange")
        self._UsedExchange = params.get("UsedExchange")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportRocketMQMessageDetailRequest(AbstractModel):
    r"""ExportRocketMQMessageDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _EnvironmentId: Application namespace.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
If it is a dead letter message, isDlqMsg=true.
        :type TopicName: str
        :param _MsgId: Message ID
        :type MsgId: str
        :param _IncludeMsgBody: Whether to Includes Message Body
        :type IncludeMsgBody: bool
        :param _DeadLetterMsg: Whether It a Dead Letter Message
        :type DeadLetterMsg: bool
        """
        self._ClusterId = None
        self._EnvironmentId = None
        self._TopicName = None
        self._MsgId = None
        self._IncludeMsgBody = None
        self._DeadLetterMsg = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EnvironmentId(self):
        r"""Application namespace.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
If it is a dead letter message, isDlqMsg=true.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def IncludeMsgBody(self):
        r"""Whether to Includes Message Body
        :rtype: bool
        """
        return self._IncludeMsgBody

    @IncludeMsgBody.setter
    def IncludeMsgBody(self, IncludeMsgBody):
        self._IncludeMsgBody = IncludeMsgBody

    @property
    def DeadLetterMsg(self):
        r"""Whether It a Dead Letter Message
        :rtype: bool
        """
        return self._DeadLetterMsg

    @DeadLetterMsg.setter
    def DeadLetterMsg(self, DeadLetterMsg):
        self._DeadLetterMsg = DeadLetterMsg


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._MsgId = params.get("MsgId")
        self._IncludeMsgBody = params.get("IncludeMsgBody")
        self._DeadLetterMsg = params.get("DeadLetterMsg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportRocketMQMessageDetailResponse(AbstractModel):
    r"""ExportRocketMQMessageDetail response structure.

    """

    def __init__(self):
        r"""
        :param _MsgId: Message ID
        :type MsgId: str
        :param _BornTimestamp: Message Generation Timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :type BornTimestamp: int
        :param _StoreTimestamp: Message Storage Timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :type StoreTimestamp: int
        :param _BornHost: Message Production Client Address
Note: This field may return null, indicating that no valid values can be obtained.
        :type BornHost: str
        :param _MsgTag: Message Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgTag: str
        :param _MsgKey: Message key
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgKey: str
        :param _Properties: Message Attributes
Note: This field may return null, indicating that no valid values can be obtained.
        :type Properties: str
        :param _ReConsumeTimes: Message Retry Count
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReConsumeTimes: int
        :param _MsgBody: Base64 Encoded String
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgBody: str
        :param _MsgBodyCRC: CRC32 Code of Message Content
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgBodyCRC: int
        :param _MsgBodySize: Specifies the message body size (unit K).
Does not return messages when above 2048.
        :type MsgBodySize: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MsgId = None
        self._BornTimestamp = None
        self._StoreTimestamp = None
        self._BornHost = None
        self._MsgTag = None
        self._MsgKey = None
        self._Properties = None
        self._ReConsumeTimes = None
        self._MsgBody = None
        self._MsgBodyCRC = None
        self._MsgBodySize = None
        self._RequestId = None

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def BornTimestamp(self):
        r"""Message Generation Timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._BornTimestamp

    @BornTimestamp.setter
    def BornTimestamp(self, BornTimestamp):
        self._BornTimestamp = BornTimestamp

    @property
    def StoreTimestamp(self):
        r"""Message Storage Timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StoreTimestamp

    @StoreTimestamp.setter
    def StoreTimestamp(self, StoreTimestamp):
        self._StoreTimestamp = StoreTimestamp

    @property
    def BornHost(self):
        r"""Message Production Client Address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._BornHost

    @BornHost.setter
    def BornHost(self, BornHost):
        self._BornHost = BornHost

    @property
    def MsgTag(self):
        r"""Message Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgTag

    @MsgTag.setter
    def MsgTag(self, MsgTag):
        self._MsgTag = MsgTag

    @property
    def MsgKey(self):
        r"""Message key
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgKey

    @MsgKey.setter
    def MsgKey(self, MsgKey):
        self._MsgKey = MsgKey

    @property
    def Properties(self):
        r"""Message Attributes
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def ReConsumeTimes(self):
        r"""Message Retry Count
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ReConsumeTimes

    @ReConsumeTimes.setter
    def ReConsumeTimes(self, ReConsumeTimes):
        self._ReConsumeTimes = ReConsumeTimes

    @property
    def MsgBody(self):
        r"""Base64 Encoded String
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgBody

    @MsgBody.setter
    def MsgBody(self, MsgBody):
        self._MsgBody = MsgBody

    @property
    def MsgBodyCRC(self):
        r"""CRC32 Code of Message Content
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MsgBodyCRC

    @MsgBodyCRC.setter
    def MsgBodyCRC(self, MsgBodyCRC):
        self._MsgBodyCRC = MsgBodyCRC

    @property
    def MsgBodySize(self):
        r"""Specifies the message body size (unit K).
Does not return messages when above 2048.
        :rtype: int
        """
        return self._MsgBodySize

    @MsgBodySize.setter
    def MsgBodySize(self, MsgBodySize):
        self._MsgBodySize = MsgBodySize

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MsgId = params.get("MsgId")
        self._BornTimestamp = params.get("BornTimestamp")
        self._StoreTimestamp = params.get("StoreTimestamp")
        self._BornHost = params.get("BornHost")
        self._MsgTag = params.get("MsgTag")
        self._MsgKey = params.get("MsgKey")
        self._Properties = params.get("Properties")
        self._ReConsumeTimes = params.get("ReConsumeTimes")
        self._MsgBody = params.get("MsgBody")
        self._MsgBodyCRC = params.get("MsgBodyCRC")
        self._MsgBodySize = params.get("MsgBodySize")
        self._RequestId = params.get("RequestId")


class Filter(AbstractModel):
    r"""Filter parameter

    """

    def __init__(self):
        r"""
        :param _Name: Filter parameter name
        :type Name: str
        :param _Values: Value
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Filter parameter name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Value
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FilterSubscription(AbstractModel):
    r"""Filter subscriptions

    """

    def __init__(self):
        r"""
        :param _ConsumerHasCount: Whether to only display subscriptions that include real consumers.
        :type ConsumerHasCount: bool
        :param _ConsumerHasBacklog: Whether to only display subscriptions with heaped messages.
        :type ConsumerHasBacklog: bool
        :param _ConsumerHasExpired: Whether to only display subscriptions with messages discarded after expiration.
        :type ConsumerHasExpired: bool
        :param _SubscriptionNames: Filter by subscription name for exact query.
        :type SubscriptionNames: list of str
        """
        self._ConsumerHasCount = None
        self._ConsumerHasBacklog = None
        self._ConsumerHasExpired = None
        self._SubscriptionNames = None

    @property
    def ConsumerHasCount(self):
        r"""Whether to only display subscriptions that include real consumers.
        :rtype: bool
        """
        return self._ConsumerHasCount

    @ConsumerHasCount.setter
    def ConsumerHasCount(self, ConsumerHasCount):
        self._ConsumerHasCount = ConsumerHasCount

    @property
    def ConsumerHasBacklog(self):
        r"""Whether to only display subscriptions with heaped messages.
        :rtype: bool
        """
        return self._ConsumerHasBacklog

    @ConsumerHasBacklog.setter
    def ConsumerHasBacklog(self, ConsumerHasBacklog):
        self._ConsumerHasBacklog = ConsumerHasBacklog

    @property
    def ConsumerHasExpired(self):
        r"""Whether to only display subscriptions with messages discarded after expiration.
        :rtype: bool
        """
        return self._ConsumerHasExpired

    @ConsumerHasExpired.setter
    def ConsumerHasExpired(self, ConsumerHasExpired):
        self._ConsumerHasExpired = ConsumerHasExpired

    @property
    def SubscriptionNames(self):
        r"""Filter by subscription name for exact query.
        :rtype: list of str
        """
        return self._SubscriptionNames

    @SubscriptionNames.setter
    def SubscriptionNames(self, SubscriptionNames):
        self._SubscriptionNames = SubscriptionNames


    def _deserialize(self, params):
        self._ConsumerHasCount = params.get("ConsumerHasCount")
        self._ConsumerHasBacklog = params.get("ConsumerHasBacklog")
        self._ConsumerHasExpired = params.get("ConsumerHasExpired")
        self._SubscriptionNames = params.get("SubscriptionNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceNodeDistribution(AbstractModel):
    r"""Information of instance node distribution

    """

    def __init__(self):
        r"""
        :param _ZoneName: AZ
        :type ZoneName: str
        :param _ZoneId: AZ ID
        :type ZoneId: str
        :param _NodeCount: Number of nodes
        :type NodeCount: int
        :param _NodePermWipeFlag: This flag is true if there is a scheduling task with no switchback AZs.
        :type NodePermWipeFlag: bool
        :param _ZoneStatus: Availability zone status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneStatus: str
        """
        self._ZoneName = None
        self._ZoneId = None
        self._NodeCount = None
        self._NodePermWipeFlag = None
        self._ZoneStatus = None

    @property
    def ZoneName(self):
        r"""AZ
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def ZoneId(self):
        r"""AZ ID
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NodeCount(self):
        r"""Number of nodes
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def NodePermWipeFlag(self):
        r"""This flag is true if there is a scheduling task with no switchback AZs.
        :rtype: bool
        """
        return self._NodePermWipeFlag

    @NodePermWipeFlag.setter
    def NodePermWipeFlag(self, NodePermWipeFlag):
        self._NodePermWipeFlag = NodePermWipeFlag

    @property
    def ZoneStatus(self):
        r"""Availability zone status
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ZoneStatus

    @ZoneStatus.setter
    def ZoneStatus(self, ZoneStatus):
        self._ZoneStatus = ZoneStatus


    def _deserialize(self, params):
        self._ZoneName = params.get("ZoneName")
        self._ZoneId = params.get("ZoneId")
        self._NodeCount = params.get("NodeCount")
        self._NodePermWipeFlag = params.get("NodePermWipeFlag")
        self._ZoneStatus = params.get("ZoneStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterRequest(AbstractModel):
    r"""ModifyCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of the Pulsar cluster to be updated.
        :type ClusterId: str
        :param _ClusterName: Updated cluster name.
        :type ClusterName: str
        :param _Remark: Description information. length limit is 128 bytes.
        :type Remark: str
        :param _PublicAccessEnabled: Enables public network access, which can only be `true`.
        :type PublicAccessEnabled: bool
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Remark = None
        self._PublicAccessEnabled = None

    @property
    def ClusterId(self):
        r"""ID of the Pulsar cluster to be updated.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Updated cluster name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Remark(self):
        r"""Description information. length limit is 128 bytes.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PublicAccessEnabled(self):
        r"""Enables public network access, which can only be `true`.
        :rtype: bool
        """
        return self._PublicAccessEnabled

    @PublicAccessEnabled.setter
    def PublicAccessEnabled(self, PublicAccessEnabled):
        self._PublicAccessEnabled = PublicAccessEnabled


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Remark = params.get("Remark")
        self._PublicAccessEnabled = params.get("PublicAccessEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterResponse(AbstractModel):
    r"""ModifyCluster response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class ModifyCmqQueueAttributeRequest(AbstractModel):
    r"""ModifyCmqQueueAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _QueueName: Queue name, which must be unique under the same account in the same region. A queue name is a string of up to 64 characters, starting with a letter, and the remaining part can include letters, digits, and hyphens (-).
        :type QueueName: str
        :param _MaxMsgHeapNum: Maximum number of heaped messages. The value range is 1,000,000–10,000,000 during the beta test and can be 1,000,000–1,000,000,000 after the product is officially released. The default value is 10,000,000 during the beta test and will be 100,000,000 after the product is officially released.
        :type MaxMsgHeapNum: int
        :param _PollingWaitSeconds: Long polling wait time for message reception. Value range: 0–30 seconds. Default value: 0.
        :type PollingWaitSeconds: int
        :param _VisibilityTimeout: Message visibility timeout period. Value range: 1–43200 seconds (i.e., 12 hours). Default value: 30.
        :type VisibilityTimeout: int
        :param _MaxMsgSize: Max message size, which defaults to 1,024 KB for the queue of TDMQ for CMQ and cannot be modified.
        :type MaxMsgSize: int
        :param _MsgRetentionSeconds: The max period during which a message is retained before it is automatically acknowledged. Value range: 30-43,200 seconds (30 seconds to 12 hours). Default value: 3600 seconds (1 hour).
        :type MsgRetentionSeconds: int
        :param _RewindSeconds: Rewindable time of messages in the queue. Value range: 0-1,296,000s (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :type RewindSeconds: int
        :param _FirstQueryInterval: First query time
        :type FirstQueryInterval: int
        :param _MaxQueryCount: Maximum number of queries
        :type MaxQueryCount: int
        :param _DeadLetterQueueName: Dead letter queue name
        :type DeadLetterQueueName: str
        :param _MaxTimeToLive: Specifies the essential parameter when policy is 1. maximum unconsumed expiration time. value range: 300-43200 in seconds, must be less than the maximum message retention time MsgRetentionSeconds.
        :type MaxTimeToLive: int
        :param _MaxReceiveCount: Maximum number of receipts
        :type MaxReceiveCount: int
        :param _Policy: Dead letter queue policy
        :type Policy: int
        :param _Trace: Whether to enable message trace. true: yes; false: no. If this field is left empty, the feature will not be enabled.
        :type Trace: bool
        :param _Transaction: Whether to enable transaction. 1: yes; 0: no
        :type Transaction: int
        :param _RetentionSizeInMB: Queue storage space configured for message rewind. Value range: 10,240-512,000 MB (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :type RetentionSizeInMB: int
        """
        self._QueueName = None
        self._MaxMsgHeapNum = None
        self._PollingWaitSeconds = None
        self._VisibilityTimeout = None
        self._MaxMsgSize = None
        self._MsgRetentionSeconds = None
        self._RewindSeconds = None
        self._FirstQueryInterval = None
        self._MaxQueryCount = None
        self._DeadLetterQueueName = None
        self._MaxTimeToLive = None
        self._MaxReceiveCount = None
        self._Policy = None
        self._Trace = None
        self._Transaction = None
        self._RetentionSizeInMB = None

    @property
    def QueueName(self):
        r"""Queue name, which must be unique under the same account in the same region. A queue name is a string of up to 64 characters, starting with a letter, and the remaining part can include letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def MaxMsgHeapNum(self):
        r"""Maximum number of heaped messages. The value range is 1,000,000–10,000,000 during the beta test and can be 1,000,000–1,000,000,000 after the product is officially released. The default value is 10,000,000 during the beta test and will be 100,000,000 after the product is officially released.
        :rtype: int
        """
        return self._MaxMsgHeapNum

    @MaxMsgHeapNum.setter
    def MaxMsgHeapNum(self, MaxMsgHeapNum):
        self._MaxMsgHeapNum = MaxMsgHeapNum

    @property
    def PollingWaitSeconds(self):
        r"""Long polling wait time for message reception. Value range: 0–30 seconds. Default value: 0.
        :rtype: int
        """
        return self._PollingWaitSeconds

    @PollingWaitSeconds.setter
    def PollingWaitSeconds(self, PollingWaitSeconds):
        self._PollingWaitSeconds = PollingWaitSeconds

    @property
    def VisibilityTimeout(self):
        r"""Message visibility timeout period. Value range: 1–43200 seconds (i.e., 12 hours). Default value: 30.
        :rtype: int
        """
        return self._VisibilityTimeout

    @VisibilityTimeout.setter
    def VisibilityTimeout(self, VisibilityTimeout):
        self._VisibilityTimeout = VisibilityTimeout

    @property
    def MaxMsgSize(self):
        r"""Max message size, which defaults to 1,024 KB for the queue of TDMQ for CMQ and cannot be modified.
        :rtype: int
        """
        return self._MaxMsgSize

    @MaxMsgSize.setter
    def MaxMsgSize(self, MaxMsgSize):
        self._MaxMsgSize = MaxMsgSize

    @property
    def MsgRetentionSeconds(self):
        r"""The max period during which a message is retained before it is automatically acknowledged. Value range: 30-43,200 seconds (30 seconds to 12 hours). Default value: 3600 seconds (1 hour).
        :rtype: int
        """
        return self._MsgRetentionSeconds

    @MsgRetentionSeconds.setter
    def MsgRetentionSeconds(self, MsgRetentionSeconds):
        self._MsgRetentionSeconds = MsgRetentionSeconds

    @property
    def RewindSeconds(self):
        r"""Rewindable time of messages in the queue. Value range: 0-1,296,000s (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :rtype: int
        """
        return self._RewindSeconds

    @RewindSeconds.setter
    def RewindSeconds(self, RewindSeconds):
        self._RewindSeconds = RewindSeconds

    @property
    def FirstQueryInterval(self):
        r"""First query time
        :rtype: int
        """
        return self._FirstQueryInterval

    @FirstQueryInterval.setter
    def FirstQueryInterval(self, FirstQueryInterval):
        self._FirstQueryInterval = FirstQueryInterval

    @property
    def MaxQueryCount(self):
        r"""Maximum number of queries
        :rtype: int
        """
        return self._MaxQueryCount

    @MaxQueryCount.setter
    def MaxQueryCount(self, MaxQueryCount):
        self._MaxQueryCount = MaxQueryCount

    @property
    def DeadLetterQueueName(self):
        r"""Dead letter queue name
        :rtype: str
        """
        return self._DeadLetterQueueName

    @DeadLetterQueueName.setter
    def DeadLetterQueueName(self, DeadLetterQueueName):
        self._DeadLetterQueueName = DeadLetterQueueName

    @property
    def MaxTimeToLive(self):
        r"""Specifies the essential parameter when policy is 1. maximum unconsumed expiration time. value range: 300-43200 in seconds, must be less than the maximum message retention time MsgRetentionSeconds.
        :rtype: int
        """
        return self._MaxTimeToLive

    @MaxTimeToLive.setter
    def MaxTimeToLive(self, MaxTimeToLive):
        self._MaxTimeToLive = MaxTimeToLive

    @property
    def MaxReceiveCount(self):
        r"""Maximum number of receipts
        :rtype: int
        """
        return self._MaxReceiveCount

    @MaxReceiveCount.setter
    def MaxReceiveCount(self, MaxReceiveCount):
        self._MaxReceiveCount = MaxReceiveCount

    @property
    def Policy(self):
        r"""Dead letter queue policy
        :rtype: int
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def Trace(self):
        r"""Whether to enable message trace. true: yes; false: no. If this field is left empty, the feature will not be enabled.
        :rtype: bool
        """
        return self._Trace

    @Trace.setter
    def Trace(self, Trace):
        self._Trace = Trace

    @property
    def Transaction(self):
        r"""Whether to enable transaction. 1: yes; 0: no
        :rtype: int
        """
        return self._Transaction

    @Transaction.setter
    def Transaction(self, Transaction):
        self._Transaction = Transaction

    @property
    def RetentionSizeInMB(self):
        r"""Queue storage space configured for message rewind. Value range: 10,240-512,000 MB (if message rewind is enabled). The value “0” indicates that message rewind is not enabled.
        :rtype: int
        """
        return self._RetentionSizeInMB

    @RetentionSizeInMB.setter
    def RetentionSizeInMB(self, RetentionSizeInMB):
        self._RetentionSizeInMB = RetentionSizeInMB


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        self._MaxMsgHeapNum = params.get("MaxMsgHeapNum")
        self._PollingWaitSeconds = params.get("PollingWaitSeconds")
        self._VisibilityTimeout = params.get("VisibilityTimeout")
        self._MaxMsgSize = params.get("MaxMsgSize")
        self._MsgRetentionSeconds = params.get("MsgRetentionSeconds")
        self._RewindSeconds = params.get("RewindSeconds")
        self._FirstQueryInterval = params.get("FirstQueryInterval")
        self._MaxQueryCount = params.get("MaxQueryCount")
        self._DeadLetterQueueName = params.get("DeadLetterQueueName")
        self._MaxTimeToLive = params.get("MaxTimeToLive")
        self._MaxReceiveCount = params.get("MaxReceiveCount")
        self._Policy = params.get("Policy")
        self._Trace = params.get("Trace")
        self._Transaction = params.get("Transaction")
        self._RetentionSizeInMB = params.get("RetentionSizeInMB")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCmqQueueAttributeResponse(AbstractModel):
    r"""ModifyCmqQueueAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCmqSubscriptionAttributeRequest(AbstractModel):
    r"""ModifyCmqSubscriptionAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _SubscriptionName: Subscription name, which must be unique under the same account and same topic in a single region. the name is a string of no more than 64 characters, beginning with a letter, and the remaining part may contain letters, numbers, and hyphens (-).
        :type SubscriptionName: str
        :param _NotifyStrategy: CMQ push server retry policy in case an error occurs while pushing a message to the endpoint. Valid values:
(1) BACKOFF_RETRY: backoff retry, which is to retry at a fixed interval, discard the message after a certain number of retries, and continue to push the next message.
(2) EXPONENTIAL_DECAY_RETRY: exponential decay retry, which is to retry at an exponentially increasing interval, such as 1s, 2s, 4s, 8s, and so on. As a message can be retained in a topic for one day, failed messages will be discarded at most after one day of retry. Default value: EXPONENTIAL_DECAY_RETRY.
        :type NotifyStrategy: str
        :param _NotifyContentFormat: Push content format. Valid values: 1. JSON; 2. SIMPLIFIED, i.e., the raw format. If `Protocol` is `queue`, this value must be `SIMPLIFIED`. If `Protocol` is `HTTP`, both values are acceptable, and the default value is `JSON`.
        :type NotifyContentFormat: str
        :param _FilterTags: Message body tag (used for message filtering). The number of tags cannot exceed 5, and each tag can contain up to 16 characters. It is used in conjunction with the `MsgTag` parameter of `(Batch)PublishMessage`. Rules: 1. If `FilterTag` is not configured, no matter whether `MsgTag` is configured, the subscription will receive all messages published to the topic; 2. If the array of `FilterTag` values has a value, only when at least one of the values in the array also exists in the array of `MsgTag` values (i.e., `FilterTag` and `MsgTag` have an intersection) can the subscription receive messages published to the topic; 3. If the array of `FilterTag` values has a value, but `MsgTag` is not configured, then no message published to the topic will be received, which can be considered as a special case of rule 2 as `FilterTag` and `MsgTag` do not intersect in this case. The overall design idea of rules is based on the intention of the subscriber.
        :type FilterTags: list of str
        :param _BindingKey: The number of `BindingKey` cannot exceed 5, and the length of each `BindingKey` cannot exceed 64 bytes. This field indicates the filtering policy for subscribing to and receiving messages. Each `BindingKey` includes up to 15 dots (namely up to 16 segments).
        :type BindingKey: list of str
        """
        self._TopicName = None
        self._SubscriptionName = None
        self._NotifyStrategy = None
        self._NotifyContentFormat = None
        self._FilterTags = None
        self._BindingKey = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. The name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def SubscriptionName(self):
        r"""Subscription name, which must be unique under the same account and same topic in a single region. the name is a string of no more than 64 characters, beginning with a letter, and the remaining part may contain letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def NotifyStrategy(self):
        r"""CMQ push server retry policy in case an error occurs while pushing a message to the endpoint. Valid values:
(1) BACKOFF_RETRY: backoff retry, which is to retry at a fixed interval, discard the message after a certain number of retries, and continue to push the next message.
(2) EXPONENTIAL_DECAY_RETRY: exponential decay retry, which is to retry at an exponentially increasing interval, such as 1s, 2s, 4s, 8s, and so on. As a message can be retained in a topic for one day, failed messages will be discarded at most after one day of retry. Default value: EXPONENTIAL_DECAY_RETRY.
        :rtype: str
        """
        return self._NotifyStrategy

    @NotifyStrategy.setter
    def NotifyStrategy(self, NotifyStrategy):
        self._NotifyStrategy = NotifyStrategy

    @property
    def NotifyContentFormat(self):
        r"""Push content format. Valid values: 1. JSON; 2. SIMPLIFIED, i.e., the raw format. If `Protocol` is `queue`, this value must be `SIMPLIFIED`. If `Protocol` is `HTTP`, both values are acceptable, and the default value is `JSON`.
        :rtype: str
        """
        return self._NotifyContentFormat

    @NotifyContentFormat.setter
    def NotifyContentFormat(self, NotifyContentFormat):
        self._NotifyContentFormat = NotifyContentFormat

    @property
    def FilterTags(self):
        r"""Message body tag (used for message filtering). The number of tags cannot exceed 5, and each tag can contain up to 16 characters. It is used in conjunction with the `MsgTag` parameter of `(Batch)PublishMessage`. Rules: 1. If `FilterTag` is not configured, no matter whether `MsgTag` is configured, the subscription will receive all messages published to the topic; 2. If the array of `FilterTag` values has a value, only when at least one of the values in the array also exists in the array of `MsgTag` values (i.e., `FilterTag` and `MsgTag` have an intersection) can the subscription receive messages published to the topic; 3. If the array of `FilterTag` values has a value, but `MsgTag` is not configured, then no message published to the topic will be received, which can be considered as a special case of rule 2 as `FilterTag` and `MsgTag` do not intersect in this case. The overall design idea of rules is based on the intention of the subscriber.
        :rtype: list of str
        """
        return self._FilterTags

    @FilterTags.setter
    def FilterTags(self, FilterTags):
        self._FilterTags = FilterTags

    @property
    def BindingKey(self):
        r"""The number of `BindingKey` cannot exceed 5, and the length of each `BindingKey` cannot exceed 64 bytes. This field indicates the filtering policy for subscribing to and receiving messages. Each `BindingKey` includes up to 15 dots (namely up to 16 segments).
        :rtype: list of str
        """
        return self._BindingKey

    @BindingKey.setter
    def BindingKey(self, BindingKey):
        self._BindingKey = BindingKey


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._SubscriptionName = params.get("SubscriptionName")
        self._NotifyStrategy = params.get("NotifyStrategy")
        self._NotifyContentFormat = params.get("NotifyContentFormat")
        self._FilterTags = params.get("FilterTags")
        self._BindingKey = params.get("BindingKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCmqSubscriptionAttributeResponse(AbstractModel):
    r"""ModifyCmqSubscriptionAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCmqTopicAttributeRequest(AbstractModel):
    r"""ModifyCmqTopicAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name, which must be unique under the same account in a single region. the name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :type TopicName: str
        :param _MaxMsgSize: Maximum message length. Value range: 1024–65536 bytes (i.e., 1–64 KB). Default value: 65536.
        :type MaxMsgSize: int
        :param _MsgRetentionSeconds: Message retention period. Value range: 60–86400 seconds (i.e., 1 minute–1 day). Default value: 86400.
        :type MsgRetentionSeconds: int
        :param _Trace: Whether to enable message trace. true: yes; false: no. If this field is left empty, the feature will not be enabled.
        :type Trace: bool
        """
        self._TopicName = None
        self._MaxMsgSize = None
        self._MsgRetentionSeconds = None
        self._Trace = None

    @property
    def TopicName(self):
        r"""Topic name, which must be unique under the same account in a single region. the name is a string of no more than 64 characters, starting with a letter, and the remaining part may include letters, numbers, and hyphens (-).
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MaxMsgSize(self):
        r"""Maximum message length. Value range: 1024–65536 bytes (i.e., 1–64 KB). Default value: 65536.
        :rtype: int
        """
        return self._MaxMsgSize

    @MaxMsgSize.setter
    def MaxMsgSize(self, MaxMsgSize):
        self._MaxMsgSize = MaxMsgSize

    @property
    def MsgRetentionSeconds(self):
        r"""Message retention period. Value range: 60–86400 seconds (i.e., 1 minute–1 day). Default value: 86400.
        :rtype: int
        """
        return self._MsgRetentionSeconds

    @MsgRetentionSeconds.setter
    def MsgRetentionSeconds(self, MsgRetentionSeconds):
        self._MsgRetentionSeconds = MsgRetentionSeconds

    @property
    def Trace(self):
        r"""Whether to enable message trace. true: yes; false: no. If this field is left empty, the feature will not be enabled.
        :rtype: bool
        """
        return self._Trace

    @Trace.setter
    def Trace(self, Trace):
        self._Trace = Trace


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._MaxMsgSize = params.get("MaxMsgSize")
        self._MsgRetentionSeconds = params.get("MsgRetentionSeconds")
        self._Trace = params.get("Trace")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCmqTopicAttributeResponse(AbstractModel):
    r"""ModifyCmqTopicAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyEnvironmentAttributesRequest(AbstractModel):
    r"""ModifyEnvironmentAttributes request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Namespace name.
        :type EnvironmentId: str
        :param _MsgTTL: Retention period for unconsumed messages in seconds. Value range: 60s to 1,296,000s (or 15 days).
        :type MsgTTL: int
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _RetentionPolicy: Message retention policy
        :type RetentionPolicy: :class:`tencentcloud.tdmq.v20200217.models.RetentionPolicy`
        :param _AutoSubscriptionCreation: Whether to enable "Auto-Create Subscription"
        :type AutoSubscriptionCreation: bool
        """
        self._EnvironmentId = None
        self._MsgTTL = None
        self._ClusterId = None
        self._Remark = None
        self._RetentionPolicy = None
        self._AutoSubscriptionCreation = None

    @property
    def EnvironmentId(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def MsgTTL(self):
        r"""Retention period for unconsumed messages in seconds. Value range: 60s to 1,296,000s (or 15 days).
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RetentionPolicy(self):
        r"""Message retention policy
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RetentionPolicy`
        """
        return self._RetentionPolicy

    @RetentionPolicy.setter
    def RetentionPolicy(self, RetentionPolicy):
        self._RetentionPolicy = RetentionPolicy

    @property
    def AutoSubscriptionCreation(self):
        r"""Whether to enable "Auto-Create Subscription"
        :rtype: bool
        """
        return self._AutoSubscriptionCreation

    @AutoSubscriptionCreation.setter
    def AutoSubscriptionCreation(self, AutoSubscriptionCreation):
        self._AutoSubscriptionCreation = AutoSubscriptionCreation


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._MsgTTL = params.get("MsgTTL")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        if params.get("RetentionPolicy") is not None:
            self._RetentionPolicy = RetentionPolicy()
            self._RetentionPolicy._deserialize(params.get("RetentionPolicy"))
        self._AutoSubscriptionCreation = params.get("AutoSubscriptionCreation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyEnvironmentAttributesResponse(AbstractModel):
    r"""ModifyEnvironmentAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Namespace name.
        :type EnvironmentId: str
        :param _MsgTTL: TTL for unconsumed messages in seconds.
        :type MsgTTL: int
        :param _Remark: Remarks (up to 128 characters).
Note: this field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _NamespaceId: Namespace ID
Note: this field may return null, indicating that no valid values can be obtained.
        :type NamespaceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EnvironmentId = None
        self._MsgTTL = None
        self._Remark = None
        self._NamespaceId = None
        self._RequestId = None

    @property
    def EnvironmentId(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def MsgTTL(self):
        r"""TTL for unconsumed messages in seconds.
        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def NamespaceId(self):
        r"""Namespace ID
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._MsgTTL = params.get("MsgTTL")
        self._Remark = params.get("Remark")
        self._NamespaceId = params.get("NamespaceId")
        self._RequestId = params.get("RequestId")


class ModifyEnvironmentRoleRequest(AbstractModel):
    r"""ModifyEnvironmentRole request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Permissions: Permissions, which is a non-empty string array of `produce` and `consume` at the most.
        :type Permissions: list of str
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._RoleName = None
        self._Permissions = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Permissions(self):
        r"""Permissions, which is a non-empty string array of `produce` and `consume` at the most.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleName = params.get("RoleName")
        self._Permissions = params.get("Permissions")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyEnvironmentRoleResponse(AbstractModel):
    r"""ModifyEnvironmentRole response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPublicNetworkSecurityPolicyRequest(AbstractModel):
    r"""ModifyPublicNetworkSecurityPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _PolicyList: Policy List
        :type PolicyList: list of SecurityPolicy
        """
        self._InstanceId = None
        self._PolicyList = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PolicyList(self):
        r"""Policy List
        :rtype: list of SecurityPolicy
        """
        return self._PolicyList

    @PolicyList.setter
    def PolicyList(self, PolicyList):
        self._PolicyList = PolicyList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("PolicyList") is not None:
            self._PolicyList = []
            for item in params.get("PolicyList"):
                obj = SecurityPolicy()
                obj._deserialize(item)
                self._PolicyList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPublicNetworkSecurityPolicyResponse(AbstractModel):
    r"""ModifyPublicNetworkSecurityPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _ModifyResult: Valid values: SUCCESS or FAILURE.
        :type ModifyResult: str
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ModifyResult = None
        self._InstanceId = None
        self._RequestId = None

    @property
    def ModifyResult(self):
        r"""Valid values: SUCCESS or FAILURE.
        :rtype: str
        """
        return self._ModifyResult

    @ModifyResult.setter
    def ModifyResult(self, ModifyResult):
        self._ModifyResult = ModifyResult

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModifyResult = params.get("ModifyResult")
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class ModifyRabbitMQPermissionRequest(AbstractModel):
    r"""ModifyRabbitMQPermission request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, such as admin. valid User names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and finding the list of users in the User and permission management tab, thereby locating the username.
        :type User: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _ConfigRegexp: Permission types, declare-related operations, specifies the regular expression for resource names that the user can operate on under the vhost.
        :type ConfigRegexp: str
        :param _WriteRegexp: Permission types, message write-related operations, specifies the regular expression for resource names that the user can operate on under the vhost.
        :type WriteRegexp: str
        :param _ReadRegexp: Permission types, message read-related operations, specifies the regular expression for resource names that the user can operate on under the vhost.
        :type ReadRegexp: str
        """
        self._InstanceId = None
        self._User = None
        self._VirtualHost = None
        self._ConfigRegexp = None
        self._WriteRegexp = None
        self._ReadRegexp = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. valid InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, such as admin. valid User names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and finding the list of users in the User and permission management tab, thereby locating the username.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def ConfigRegexp(self):
        r"""Permission types, declare-related operations, specifies the regular expression for resource names that the user can operate on under the vhost.
        :rtype: str
        """
        return self._ConfigRegexp

    @ConfigRegexp.setter
    def ConfigRegexp(self, ConfigRegexp):
        self._ConfigRegexp = ConfigRegexp

    @property
    def WriteRegexp(self):
        r"""Permission types, message write-related operations, specifies the regular expression for resource names that the user can operate on under the vhost.
        :rtype: str
        """
        return self._WriteRegexp

    @WriteRegexp.setter
    def WriteRegexp(self, WriteRegexp):
        self._WriteRegexp = WriteRegexp

    @property
    def ReadRegexp(self):
        r"""Permission types, message read-related operations, specifies the regular expression for resource names that the user can operate on under the vhost.
        :rtype: str
        """
        return self._ReadRegexp

    @ReadRegexp.setter
    def ReadRegexp(self, ReadRegexp):
        self._ReadRegexp = ReadRegexp


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._VirtualHost = params.get("VirtualHost")
        self._ConfigRegexp = params.get("ConfigRegexp")
        self._WriteRegexp = params.get("WriteRegexp")
        self._ReadRegexp = params.get("ReadRegexp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRabbitMQPermissionResponse(AbstractModel):
    r"""ModifyRabbitMQPermission response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRabbitMQUserRequest(AbstractModel):
    r"""ModifyRabbitMQUser request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :type User: str
        :param _Password: Password, used when logging in. requirement: cannot be empty, 8-64 characters, must contain at least two items from lowercase letters, uppercase letters, digits, and special characters [`()~!@#$%^&*_=|{}[]:;',.?/].
        :type Password: str
        :param _Description: Description. If this parameter is not passed in, it won't be modified.
        :type Description: str
        :param _Tags: User tag, used to determine the access permission of the user for RabbitMQ Management.
management: ordinary console user. monitoring: administrative console user. other value: non-console user.
        :type Tags: list of str
        :param _MaxConnections: The maximum number of connections for the user. If this parameter is not passed in, it won't be modified.
        :type MaxConnections: int
        :param _MaxChannels: The maximum number of channels for the user. If this parameter is not passed in, it won't be modified.
        :type MaxChannels: int
        """
        self._InstanceId = None
        self._User = None
        self._Password = None
        self._Description = None
        self._Tags = None
        self._MaxConnections = None
        self._MaxChannels = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Password(self):
        r"""Password, used when logging in. requirement: cannot be empty, 8-64 characters, must contain at least two items from lowercase letters, uppercase letters, digits, and special characters [`()~!@#$%^&*_=|{}[]:;',.?/].
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Description(self):
        r"""Description. If this parameter is not passed in, it won't be modified.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        r"""User tag, used to determine the access permission of the user for RabbitMQ Management.
management: ordinary console user. monitoring: administrative console user. other value: non-console user.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def MaxConnections(self):
        r"""The maximum number of connections for the user. If this parameter is not passed in, it won't be modified.
        :rtype: int
        """
        return self._MaxConnections

    @MaxConnections.setter
    def MaxConnections(self, MaxConnections):
        self._MaxConnections = MaxConnections

    @property
    def MaxChannels(self):
        r"""The maximum number of channels for the user. If this parameter is not passed in, it won't be modified.
        :rtype: int
        """
        return self._MaxChannels

    @MaxChannels.setter
    def MaxChannels(self, MaxChannels):
        self._MaxChannels = MaxChannels


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._Password = params.get("Password")
        self._Description = params.get("Description")
        self._Tags = params.get("Tags")
        self._MaxConnections = params.get("MaxConnections")
        self._MaxChannels = params.get("MaxChannels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRabbitMQUserResponse(AbstractModel):
    r"""ModifyRabbitMQUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRabbitMQVirtualHostRequest(AbstractModel):
    r"""ModifyRabbitMQVirtualHost request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. specifies the effective InstanceId that can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _VirtualHost: VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _Description: Describes the Virtual Host.
        :type Description: str
        :param _TraceFlag: Message trace flag. Valid values: `true` (Enabled), `false` (Disabled).
        :type TraceFlag: bool
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Description = None
        self._TraceFlag = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. specifies the effective InstanceId that can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. effective VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Description(self):
        r"""Describes the Virtual Host.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def TraceFlag(self):
        r"""Message trace flag. Valid values: `true` (Enabled), `false` (Disabled).
        :rtype: bool
        """
        return self._TraceFlag

    @TraceFlag.setter
    def TraceFlag(self, TraceFlag):
        self._TraceFlag = TraceFlag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Description = params.get("Description")
        self._TraceFlag = params.get("TraceFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRabbitMQVirtualHostResponse(AbstractModel):
    r"""ModifyRabbitMQVirtualHost response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRocketMQClusterRequest(AbstractModel):
    r"""ModifyRocketMQCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: RocketMQ cluster ID
        :type ClusterId: str
        :param _ClusterName: 3–64 letters, digits, hyphens, and underscores
        :type ClusterName: str
        :param _Remark: Remarks (up to 128 characters)
        :type Remark: str
        :param _PublicAccessEnabled: Whether to enable the HTTP access over the public network
        :type PublicAccessEnabled: bool
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Remark = None
        self._PublicAccessEnabled = None

    @property
    def ClusterId(self):
        r"""RocketMQ cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""3–64 letters, digits, hyphens, and underscores
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PublicAccessEnabled(self):
        r"""Whether to enable the HTTP access over the public network
        :rtype: bool
        """
        return self._PublicAccessEnabled

    @PublicAccessEnabled.setter
    def PublicAccessEnabled(self, PublicAccessEnabled):
        self._PublicAccessEnabled = PublicAccessEnabled


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Remark = params.get("Remark")
        self._PublicAccessEnabled = params.get("PublicAccessEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQClusterResponse(AbstractModel):
    r"""ModifyRocketMQCluster response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRocketMQEnvironmentRoleRequest(AbstractModel):
    r"""ModifyRocketMQEnvironmentRole request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Permissions: Authorization item, which can contain a non-empty character array of up to 2 items including produce and consume.
        :type Permissions: list of str
        :param _ClusterId: Required field, cluster ID
        :type ClusterId: str
        :param _DetailedPerms: Permission configuration for topic and group dimensions.
        :type DetailedPerms: list of DetailedRolePerm
        """
        self._EnvironmentId = None
        self._RoleName = None
        self._Permissions = None
        self._ClusterId = None
        self._DetailedPerms = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Permissions(self):
        r"""Authorization item, which can contain a non-empty character array of up to 2 items including produce and consume.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def ClusterId(self):
        r"""Required field, cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DetailedPerms(self):
        r"""Permission configuration for topic and group dimensions.
        :rtype: list of DetailedRolePerm
        """
        return self._DetailedPerms

    @DetailedPerms.setter
    def DetailedPerms(self, DetailedPerms):
        self._DetailedPerms = DetailedPerms


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._RoleName = params.get("RoleName")
        self._Permissions = params.get("Permissions")
        self._ClusterId = params.get("ClusterId")
        if params.get("DetailedPerms") is not None:
            self._DetailedPerms = []
            for item in params.get("DetailedPerms"):
                obj = DetailedRolePerm()
                obj._deserialize(item)
                self._DetailedPerms.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQEnvironmentRoleResponse(AbstractModel):
    r"""ModifyRocketMQEnvironmentRole response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRocketMQGroupRequest(AbstractModel):
    r"""ModifyRocketMQGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace
        :type NamespaceId: str
        :param _GroupId: Consumer group name
        :type GroupId: str
        :param _Remark: Remarks (up to 128 characters)
        :type Remark: str
        :param _ReadEnable: Whether to enable consumption
        :type ReadEnable: bool
        :param _BroadcastEnable: Whether to enable broadcast consumption
        :type BroadcastEnable: bool
        :param _RetryMaxTimes: The maximum number of retries
        :type RetryMaxTimes: int
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._GroupId = None
        self._Remark = None
        self._ReadEnable = None
        self._BroadcastEnable = None
        self._RetryMaxTimes = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupId(self):
        r"""Consumer group name
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ReadEnable(self):
        r"""Whether to enable consumption
        :rtype: bool
        """
        return self._ReadEnable

    @ReadEnable.setter
    def ReadEnable(self, ReadEnable):
        self._ReadEnable = ReadEnable

    @property
    def BroadcastEnable(self):
        r"""Whether to enable broadcast consumption
        :rtype: bool
        """
        return self._BroadcastEnable

    @BroadcastEnable.setter
    def BroadcastEnable(self, BroadcastEnable):
        self._BroadcastEnable = BroadcastEnable

    @property
    def RetryMaxTimes(self):
        r"""The maximum number of retries
        :rtype: int
        """
        return self._RetryMaxTimes

    @RetryMaxTimes.setter
    def RetryMaxTimes(self, RetryMaxTimes):
        self._RetryMaxTimes = RetryMaxTimes


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupId = params.get("GroupId")
        self._Remark = params.get("Remark")
        self._ReadEnable = params.get("ReadEnable")
        self._BroadcastEnable = params.get("BroadcastEnable")
        self._RetryMaxTimes = params.get("RetryMaxTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQGroupResponse(AbstractModel):
    r"""ModifyRocketMQGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRocketMQInstanceRequest(AbstractModel):
    r"""ModifyRocketMQInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Dedicated Instance ID
        :type InstanceId: str
        :param _Name: Instance name
        :type Name: str
        :param _Remark: Instance Remarks
        :type Remark: str
        :param _MessageRetention: Instance message retention time, in hours
        :type MessageRetention: int
        :param _EnableDeletionProtection: Whether to enable deletion protection
        :type EnableDeletionProtection: bool
        :param _SendReceiveRatio: Controls the TPS ratio for producing and consuming messages. Value range: 0–1. Default value: 0.5.
        :type SendReceiveRatio: float
        """
        self._InstanceId = None
        self._Name = None
        self._Remark = None
        self._MessageRetention = None
        self._EnableDeletionProtection = None
        self._SendReceiveRatio = None

    @property
    def InstanceId(self):
        r"""Dedicated Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Name(self):
        r"""Instance name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Instance Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MessageRetention(self):
        r"""Instance message retention time, in hours
        :rtype: int
        """
        return self._MessageRetention

    @MessageRetention.setter
    def MessageRetention(self, MessageRetention):
        self._MessageRetention = MessageRetention

    @property
    def EnableDeletionProtection(self):
        r"""Whether to enable deletion protection
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection

    @property
    def SendReceiveRatio(self):
        r"""Controls the TPS ratio for producing and consuming messages. Value range: 0–1. Default value: 0.5.
        :rtype: float
        """
        return self._SendReceiveRatio

    @SendReceiveRatio.setter
    def SendReceiveRatio(self, SendReceiveRatio):
        self._SendReceiveRatio = SendReceiveRatio


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        self._MessageRetention = params.get("MessageRetention")
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        self._SendReceiveRatio = params.get("SendReceiveRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQInstanceResponse(AbstractModel):
    r"""ModifyRocketMQInstance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRocketMQInstanceSpecRequest(AbstractModel):
    r"""ModifyRocketMQInstanceSpec request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of the exclusive instance
        :type InstanceId: str
        :param _Specification: Instance specification.
Valid values: `rocket-vip-basic-1` (Basic),
`rocket-vip-basic-2` (Standard),
`rocket-vip-basic-3` (Advanced I),
`rocket-vip-basic-4` (Advanced II).
        :type Specification: str
        :param _NodeCount: Node count
        :type NodeCount: int
        :param _StorageSize: Storage space in GB
        :type StorageSize: int
        """
        self._InstanceId = None
        self._Specification = None
        self._NodeCount = None
        self._StorageSize = None

    @property
    def InstanceId(self):
        r"""ID of the exclusive instance
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Specification(self):
        r"""Instance specification.
Valid values: `rocket-vip-basic-1` (Basic),
`rocket-vip-basic-2` (Standard),
`rocket-vip-basic-3` (Advanced I),
`rocket-vip-basic-4` (Advanced II).
        :rtype: str
        """
        return self._Specification

    @Specification.setter
    def Specification(self, Specification):
        self._Specification = Specification

    @property
    def NodeCount(self):
        r"""Node count
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def StorageSize(self):
        r"""Storage space in GB
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Specification = params.get("Specification")
        self._NodeCount = params.get("NodeCount")
        self._StorageSize = params.get("StorageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQInstanceSpecResponse(AbstractModel):
    r"""ModifyRocketMQInstanceSpec response structure.

    """

    def __init__(self):
        r"""
        :param _OrderId: Order ID
        :type OrderId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OrderId = None
        self._RequestId = None

    @property
    def OrderId(self):
        r"""Order ID
        :rtype: str
        """
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        self._RequestId = params.get("RequestId")


class ModifyRocketMQNamespaceRequest(AbstractModel):
    r"""ModifyRocketMQNamespace request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace name, which can contain 3–64 letters, digits, hyphens, and underscores
        :type NamespaceId: str
        :param _Ttl: This parameter is disused.
        :type Ttl: int
        :param _RetentionTime: This parameter is disused.
        :type RetentionTime: int
        :param _Remark: Remarks (up to 128 characters)
        :type Remark: str
        :param _PublicAccessEnabled: Whether to enable the public network access
        :type PublicAccessEnabled: bool
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._Ttl = None
        self._RetentionTime = None
        self._Remark = None
        self._PublicAccessEnabled = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name, which can contain 3–64 letters, digits, hyphens, and underscores
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Ttl(self):
        r"""This parameter is disused.
        :rtype: int
        """
        return self._Ttl

    @Ttl.setter
    def Ttl(self, Ttl):
        self._Ttl = Ttl

    @property
    def RetentionTime(self):
        r"""This parameter is disused.
        :rtype: int
        """
        return self._RetentionTime

    @RetentionTime.setter
    def RetentionTime(self, RetentionTime):
        self._RetentionTime = RetentionTime

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PublicAccessEnabled(self):
        r"""Whether to enable the public network access
        :rtype: bool
        """
        return self._PublicAccessEnabled

    @PublicAccessEnabled.setter
    def PublicAccessEnabled(self, PublicAccessEnabled):
        self._PublicAccessEnabled = PublicAccessEnabled


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Ttl = params.get("Ttl")
        self._RetentionTime = params.get("RetentionTime")
        self._Remark = params.get("Remark")
        self._PublicAccessEnabled = params.get("PublicAccessEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQNamespaceResponse(AbstractModel):
    r"""ModifyRocketMQNamespace response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRocketMQRoleRequest(AbstractModel):
    r"""ModifyRocketMQRole request structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name. Does not support Chinese characters and special characters other than hyphens (-) and underscores (_), and must be greater than 0 and less than or equal to 32 in length.
        :type RoleName: str
        :param _ClusterId: Required field, cluster ID
        :type ClusterId: str
        :param _Remark: Remark description. Length must be greater than or equal to 0 and less than or equal to 128.
        :type Remark: str
        :param _PermType: Permission type. Permissions are granted by cluster by default. Cluster: cluster level; TopicAndGroup: topic/consumer group level.
        :type PermType: str
        """
        self._RoleName = None
        self._ClusterId = None
        self._Remark = None
        self._PermType = None

    @property
    def RoleName(self):
        r"""Role name. Does not support Chinese characters and special characters other than hyphens (-) and underscores (_), and must be greater than 0 and less than or equal to 32 in length.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def ClusterId(self):
        r"""Required field, cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remark description. Length must be greater than or equal to 0 and less than or equal to 128.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PermType(self):
        r"""Permission type. Permissions are granted by cluster by default. Cluster: cluster level; TopicAndGroup: topic/consumer group level.
        :rtype: str
        """
        return self._PermType

    @PermType.setter
    def PermType(self, PermType):
        self._PermType = PermType


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._PermType = params.get("PermType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQRoleResponse(AbstractModel):
    r"""ModifyRocketMQRole response structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name.
        :type RoleName: str
        :param _Remark: Specifies the remark description.
        :type Remark: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleName = None
        self._Remark = None
        self._RequestId = None

    @property
    def RoleName(self):
        r"""Role name.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Remark(self):
        r"""Specifies the remark description.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._Remark = params.get("Remark")
        self._RequestId = params.get("RequestId")


class ModifyRocketMQTopicRequest(AbstractModel):
    r"""ModifyRocketMQTopic request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NamespaceId: Namespace name
        :type NamespaceId: str
        :param _Topic: Topic name
        :type Topic: str
        :param _Remark: Remarks (up to 128 characters)
        :type Remark: str
        :param _PartitionNum: Number of partitions, which is invalid for globally sequential messages and cannot be less than the current number of partitions.
        :type PartitionNum: int
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._Topic = None
        self._Remark = None
        self._PartitionNum = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Topic(self):
        r"""Topic name
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters)
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PartitionNum(self):
        r"""Number of partitions, which is invalid for globally sequential messages and cannot be less than the current number of partitions.
        :rtype: int
        """
        return self._PartitionNum

    @PartitionNum.setter
    def PartitionNum(self, PartitionNum):
        self._PartitionNum = PartitionNum


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._Topic = params.get("Topic")
        self._Remark = params.get("Remark")
        self._PartitionNum = params.get("PartitionNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRocketMQTopicResponse(AbstractModel):
    r"""ModifyRocketMQTopic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyRoleRequest(AbstractModel):
    r"""ModifyRole request structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name, which can contain up to 32 letters, digits, hyphens, and underscores.
        :type RoleName: str
        :param _ClusterId: Cluster ID (required)
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _EnvironmentRoleSets: Batch binds namespace information.
        :type EnvironmentRoleSets: list of EnvironmentRoleSet
        :param _UnbindAllEnvironment: Unbinds all namespaces. set to true.
        :type UnbindAllEnvironment: bool
        """
        self._RoleName = None
        self._ClusterId = None
        self._Remark = None
        self._EnvironmentRoleSets = None
        self._UnbindAllEnvironment = None

    @property
    def RoleName(self):
        r"""Role name, which can contain up to 32 letters, digits, hyphens, and underscores.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def ClusterId(self):
        r"""Cluster ID (required)
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def EnvironmentRoleSets(self):
        r"""Batch binds namespace information.
        :rtype: list of EnvironmentRoleSet
        """
        return self._EnvironmentRoleSets

    @EnvironmentRoleSets.setter
    def EnvironmentRoleSets(self, EnvironmentRoleSets):
        self._EnvironmentRoleSets = EnvironmentRoleSets

    @property
    def UnbindAllEnvironment(self):
        r"""Unbinds all namespaces. set to true.
        :rtype: bool
        """
        return self._UnbindAllEnvironment

    @UnbindAllEnvironment.setter
    def UnbindAllEnvironment(self, UnbindAllEnvironment):
        self._UnbindAllEnvironment = UnbindAllEnvironment


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        if params.get("EnvironmentRoleSets") is not None:
            self._EnvironmentRoleSets = []
            for item in params.get("EnvironmentRoleSets"):
                obj = EnvironmentRoleSet()
                obj._deserialize(item)
                self._EnvironmentRoleSets.append(obj)
        self._UnbindAllEnvironment = params.get("UnbindAllEnvironment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRoleResponse(AbstractModel):
    r"""ModifyRole response structure.

    """

    def __init__(self):
        r"""
        :param _RoleName: Role name
        :type RoleName: str
        :param _Remark: Remarks
        :type Remark: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleName = None
        self._Remark = None
        self._RequestId = None

    @property
    def RoleName(self):
        r"""Role name
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoleName = params.get("RoleName")
        self._Remark = params.get("Remark")
        self._RequestId = params.get("RequestId")


class ModifyTopicRequest(AbstractModel):
    r"""ModifyTopic request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Environment (namespace) name.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _Partitions: Specifies the number of partitions, which must be greater than or equal to the original partition count. if you want to maintain the original number of partitions, please enter the original number. changing the number of partitions is only effective for non-global sequential messages and cannot exceed 32 partitions.
        :type Partitions: int
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _MsgTTL: Unconsumed message expiration time. measurement unit: seconds. value range: 60 seconds to 15 days.

        :type MsgTTL: int
        :param _UnackPolicy: Default if not passed is native policy. DefaultPolicy means when the subscription reaches the maximum unacknowledged messages of 5000, the server will stop pushing messages to all consumers under the current subscription. DynamicPolicy refers to dynamically adjusting the maximum unacknowledged messages under the subscription, with the specific quota being the maximum between 5000 and the number of consumers multiplied by 20. the default maximum unacknowledged message count per consumer is 20. exceeding this limit only affects that consumer and does not affect other consumers.
        :type UnackPolicy: str
        :param _IsolateConsumerEnable: Whether exception consumer isolation is enabled.
        :type IsolateConsumerEnable: bool
        :param _AckTimeOut: Consumer Ack timeout period in seconds. value range: 60-(3600*24).
        :type AckTimeOut: int
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._Partitions = None
        self._ClusterId = None
        self._Remark = None
        self._MsgTTL = None
        self._UnackPolicy = None
        self._IsolateConsumerEnable = None
        self._AckTimeOut = None

    @property
    def EnvironmentId(self):
        r"""Environment (namespace) name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Partitions(self):
        r"""Specifies the number of partitions, which must be greater than or equal to the original partition count. if you want to maintain the original number of partitions, please enter the original number. changing the number of partitions is only effective for non-global sequential messages and cannot exceed 32 partitions.
        :rtype: int
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MsgTTL(self):
        r"""Unconsumed message expiration time. measurement unit: seconds. value range: 60 seconds to 15 days.

        :rtype: int
        """
        return self._MsgTTL

    @MsgTTL.setter
    def MsgTTL(self, MsgTTL):
        self._MsgTTL = MsgTTL

    @property
    def UnackPolicy(self):
        r"""Default if not passed is native policy. DefaultPolicy means when the subscription reaches the maximum unacknowledged messages of 5000, the server will stop pushing messages to all consumers under the current subscription. DynamicPolicy refers to dynamically adjusting the maximum unacknowledged messages under the subscription, with the specific quota being the maximum between 5000 and the number of consumers multiplied by 20. the default maximum unacknowledged message count per consumer is 20. exceeding this limit only affects that consumer and does not affect other consumers.
        :rtype: str
        """
        return self._UnackPolicy

    @UnackPolicy.setter
    def UnackPolicy(self, UnackPolicy):
        self._UnackPolicy = UnackPolicy

    @property
    def IsolateConsumerEnable(self):
        r"""Whether exception consumer isolation is enabled.
        :rtype: bool
        """
        return self._IsolateConsumerEnable

    @IsolateConsumerEnable.setter
    def IsolateConsumerEnable(self, IsolateConsumerEnable):
        self._IsolateConsumerEnable = IsolateConsumerEnable

    @property
    def AckTimeOut(self):
        r"""Consumer Ack timeout period in seconds. value range: 60-(3600*24).
        :rtype: int
        """
        return self._AckTimeOut

    @AckTimeOut.setter
    def AckTimeOut(self, AckTimeOut):
        self._AckTimeOut = AckTimeOut


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._Partitions = params.get("Partitions")
        self._ClusterId = params.get("ClusterId")
        self._Remark = params.get("Remark")
        self._MsgTTL = params.get("MsgTTL")
        self._UnackPolicy = params.get("UnackPolicy")
        self._IsolateConsumerEnable = params.get("IsolateConsumerEnable")
        self._AckTimeOut = params.get("AckTimeOut")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTopicResponse(AbstractModel):
    r"""ModifyTopic response structure.

    """

    def __init__(self):
        r"""
        :param _Partitions: Number of partitions
        :type Partitions: int
        :param _Remark: Remarks (up to 128 characters).
        :type Remark: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Partitions = None
        self._Remark = None
        self._RequestId = None

    @property
    def Partitions(self):
        r"""Number of partitions
        :rtype: int
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Remark(self):
        r"""Remarks (up to 128 characters).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Partitions = params.get("Partitions")
        self._Remark = params.get("Remark")
        self._RequestId = params.get("RequestId")


class MsgLog(AbstractModel):
    r"""Message log

    """

    def __init__(self):
        r"""
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _ProducerName: Producer name.
        :type ProducerName: str
        :param _ProduceTime: Production time.
        :type ProduceTime: str
        :param _ProducerAddr: Producer client address.
        :type ProducerAddr: str
        """
        self._MsgId = None
        self._ProducerName = None
        self._ProduceTime = None
        self._ProducerAddr = None

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ProducerName(self):
        r"""Producer name.
        :rtype: str
        """
        return self._ProducerName

    @ProducerName.setter
    def ProducerName(self, ProducerName):
        self._ProducerName = ProducerName

    @property
    def ProduceTime(self):
        r"""Production time.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def ProducerAddr(self):
        r"""Producer client address.
        :rtype: str
        """
        return self._ProducerAddr

    @ProducerAddr.setter
    def ProducerAddr(self, ProducerAddr):
        self._ProducerAddr = ProducerAddr


    def _deserialize(self, params):
        self._MsgId = params.get("MsgId")
        self._ProducerName = params.get("ProducerName")
        self._ProduceTime = params.get("ProduceTime")
        self._ProducerAddr = params.get("ProducerAddr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PartitionsTopic(AbstractModel):
    r"""Partitioned topic

    """

    def __init__(self):
        r"""
        :param _AverageMsgSize: Average size of the messages published in the last interval in bytes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AverageMsgSize: str
        :param _ConsumerCount: The number of consumers.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerCount: str
        :param _LastConfirmedEntry: The total number of recorded messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastConfirmedEntry: str
        :param _LastLedgerCreatedTimestamp: Time when the last ledger was created.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastLedgerCreatedTimestamp: str
        :param _MsgRateIn: The number of messages published by local and replicated publishers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgRateIn: str
        :param _MsgRateOut: The total number of messages delivered by local and replicated consumers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgRateOut: str
        :param _MsgThroughputIn: The size (in bytes) of messages published by local and replicated publishers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgThroughputIn: str
        :param _MsgThroughputOut: The size (in bytes) of messages delivered by local and replicated consumers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgThroughputOut: str
        :param _NumberOfEntries: The total number of recorded messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NumberOfEntries: str
        :param _Partitions: Subpartition ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Partitions: int
        :param _ProducerCount: The number of producers.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProducerCount: str
        :param _TotalSize: Total size of all stored messages in bytes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalSize: str
        :param _TopicType: Topic type description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicType: int
        """
        self._AverageMsgSize = None
        self._ConsumerCount = None
        self._LastConfirmedEntry = None
        self._LastLedgerCreatedTimestamp = None
        self._MsgRateIn = None
        self._MsgRateOut = None
        self._MsgThroughputIn = None
        self._MsgThroughputOut = None
        self._NumberOfEntries = None
        self._Partitions = None
        self._ProducerCount = None
        self._TotalSize = None
        self._TopicType = None

    @property
    def AverageMsgSize(self):
        r"""Average size of the messages published in the last interval in bytes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AverageMsgSize

    @AverageMsgSize.setter
    def AverageMsgSize(self, AverageMsgSize):
        self._AverageMsgSize = AverageMsgSize

    @property
    def ConsumerCount(self):
        r"""The number of consumers.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsumerCount

    @ConsumerCount.setter
    def ConsumerCount(self, ConsumerCount):
        self._ConsumerCount = ConsumerCount

    @property
    def LastConfirmedEntry(self):
        r"""The total number of recorded messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LastConfirmedEntry

    @LastConfirmedEntry.setter
    def LastConfirmedEntry(self, LastConfirmedEntry):
        self._LastConfirmedEntry = LastConfirmedEntry

    @property
    def LastLedgerCreatedTimestamp(self):
        r"""Time when the last ledger was created.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LastLedgerCreatedTimestamp

    @LastLedgerCreatedTimestamp.setter
    def LastLedgerCreatedTimestamp(self, LastLedgerCreatedTimestamp):
        self._LastLedgerCreatedTimestamp = LastLedgerCreatedTimestamp

    @property
    def MsgRateIn(self):
        r"""The number of messages published by local and replicated publishers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgRateIn

    @MsgRateIn.setter
    def MsgRateIn(self, MsgRateIn):
        self._MsgRateIn = MsgRateIn

    @property
    def MsgRateOut(self):
        r"""The total number of messages delivered by local and replicated consumers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgRateOut

    @MsgRateOut.setter
    def MsgRateOut(self, MsgRateOut):
        self._MsgRateOut = MsgRateOut

    @property
    def MsgThroughputIn(self):
        r"""The size (in bytes) of messages published by local and replicated publishers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgThroughputIn

    @MsgThroughputIn.setter
    def MsgThroughputIn(self, MsgThroughputIn):
        self._MsgThroughputIn = MsgThroughputIn

    @property
    def MsgThroughputOut(self):
        r"""The size (in bytes) of messages delivered by local and replicated consumers per second.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgThroughputOut

    @MsgThroughputOut.setter
    def MsgThroughputOut(self, MsgThroughputOut):
        self._MsgThroughputOut = MsgThroughputOut

    @property
    def NumberOfEntries(self):
        r"""The total number of recorded messages.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NumberOfEntries

    @NumberOfEntries.setter
    def NumberOfEntries(self, NumberOfEntries):
        self._NumberOfEntries = NumberOfEntries

    @property
    def Partitions(self):
        r"""Subpartition ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def ProducerCount(self):
        r"""The number of producers.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProducerCount

    @ProducerCount.setter
    def ProducerCount(self, ProducerCount):
        self._ProducerCount = ProducerCount

    @property
    def TotalSize(self):
        r"""Total size of all stored messages in bytes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def TopicType(self):
        r"""Topic type description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicType

    @TopicType.setter
    def TopicType(self, TopicType):
        self._TopicType = TopicType


    def _deserialize(self, params):
        self._AverageMsgSize = params.get("AverageMsgSize")
        self._ConsumerCount = params.get("ConsumerCount")
        self._LastConfirmedEntry = params.get("LastConfirmedEntry")
        self._LastLedgerCreatedTimestamp = params.get("LastLedgerCreatedTimestamp")
        self._MsgRateIn = params.get("MsgRateIn")
        self._MsgRateOut = params.get("MsgRateOut")
        self._MsgThroughputIn = params.get("MsgThroughputIn")
        self._MsgThroughputOut = params.get("MsgThroughputOut")
        self._NumberOfEntries = params.get("NumberOfEntries")
        self._Partitions = params.get("Partitions")
        self._ProducerCount = params.get("ProducerCount")
        self._TotalSize = params.get("TotalSize")
        self._TopicType = params.get("TopicType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProducerInfo(AbstractModel):
    r"""Producer client details.

    """

    def __init__(self):
        r"""
        :param _ClientId: Client ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientId: str
        :param _ClientIp: Client IP.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClientIp: str
        :param _Language: Specifies the client language.
JAVA((byte) 0),
    CPP((byte) 1),
    DOTNET((byte) 2),
    PYTHON((byte) 3),
    DELPHI((byte) 4),
    ERLANG((byte) 5),
    RUBY((byte) 6),
    OTHER((byte) 7),
    HTTP((byte) 8),
    GO((byte) 9),
    PHP((byte) 10),
    OMS((byte) 11);
Note: This field may return null, indicating that no valid values can be obtained.
        :type Language: str
        :param _Version: Client version.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: str
        :param _LastUpdateTimestamp: Last production time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastUpdateTimestamp: int
        """
        self._ClientId = None
        self._ClientIp = None
        self._Language = None
        self._Version = None
        self._LastUpdateTimestamp = None

    @property
    def ClientId(self):
        r"""Client ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientId

    @ClientId.setter
    def ClientId(self, ClientId):
        self._ClientId = ClientId

    @property
    def ClientIp(self):
        r"""Client IP.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def Language(self):
        r"""Specifies the client language.
JAVA((byte) 0),
    CPP((byte) 1),
    DOTNET((byte) 2),
    PYTHON((byte) 3),
    DELPHI((byte) 4),
    ERLANG((byte) 5),
    RUBY((byte) 6),
    OTHER((byte) 7),
    HTTP((byte) 8),
    GO((byte) 9),
    PHP((byte) 10),
    OMS((byte) 11);
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Language

    @Language.setter
    def Language(self, Language):
        self._Language = Language

    @property
    def Version(self):
        r"""Client version.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def LastUpdateTimestamp(self):
        r"""Last production time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._LastUpdateTimestamp

    @LastUpdateTimestamp.setter
    def LastUpdateTimestamp(self, LastUpdateTimestamp):
        self._LastUpdateTimestamp = LastUpdateTimestamp


    def _deserialize(self, params):
        self._ClientId = params.get("ClientId")
        self._ClientIp = params.get("ClientIp")
        self._Language = params.get("Language")
        self._Version = params.get("Version")
        self._LastUpdateTimestamp = params.get("LastUpdateTimestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProducerLog(AbstractModel):
    r"""Message production information

    """

    def __init__(self):
        r"""
        :param _MsgId: Message ID.
        :type MsgId: str
        :param _ProducerName: Producer name.
        :type ProducerName: str
        :param _ProduceTime: Message production time.
        :type ProduceTime: str
        :param _ProducerAddr: Producer client.
        :type ProducerAddr: str
        :param _ProduceUseTime: Production time cost (in seconds).
        :type ProduceUseTime: int
        :param _Status: Status.
        :type Status: str
        """
        self._MsgId = None
        self._ProducerName = None
        self._ProduceTime = None
        self._ProducerAddr = None
        self._ProduceUseTime = None
        self._Status = None

    @property
    def MsgId(self):
        r"""Message ID.
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def ProducerName(self):
        r"""Producer name.
        :rtype: str
        """
        return self._ProducerName

    @ProducerName.setter
    def ProducerName(self, ProducerName):
        self._ProducerName = ProducerName

    @property
    def ProduceTime(self):
        r"""Message production time.
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def ProducerAddr(self):
        r"""Producer client.
        :rtype: str
        """
        return self._ProducerAddr

    @ProducerAddr.setter
    def ProducerAddr(self, ProducerAddr):
        self._ProducerAddr = ProducerAddr

    @property
    def ProduceUseTime(self):
        r"""Production time cost (in seconds).
        :rtype: int
        """
        return self._ProduceUseTime

    @ProduceUseTime.setter
    def ProduceUseTime(self, ProduceUseTime):
        self._ProduceUseTime = ProduceUseTime

    @property
    def Status(self):
        r"""Status.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MsgId = params.get("MsgId")
        self._ProducerName = params.get("ProducerName")
        self._ProduceTime = params.get("ProduceTime")
        self._ProducerAddr = params.get("ProducerAddr")
        self._ProduceUseTime = params.get("ProduceUseTime")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PrometheusEndpointInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _PrometheusEndpointStatus: 
        :type PrometheusEndpointStatus: str
        :param _VpcPrometheusEndpoint: 
        :type VpcPrometheusEndpoint: list of str
        :param _NodePrometheusAddress: 
        :type NodePrometheusAddress: list of str
        :param _VpcEndpointInfo: 
        :type VpcEndpointInfo: :class:`tencentcloud.tdmq.v20200217.models.VpcEndpointInfo`
        """
        self._PrometheusEndpointStatus = None
        self._VpcPrometheusEndpoint = None
        self._NodePrometheusAddress = None
        self._VpcEndpointInfo = None

    @property
    def PrometheusEndpointStatus(self):
        r"""
        :rtype: str
        """
        return self._PrometheusEndpointStatus

    @PrometheusEndpointStatus.setter
    def PrometheusEndpointStatus(self, PrometheusEndpointStatus):
        self._PrometheusEndpointStatus = PrometheusEndpointStatus

    @property
    def VpcPrometheusEndpoint(self):
        r"""
        :rtype: list of str
        """
        return self._VpcPrometheusEndpoint

    @VpcPrometheusEndpoint.setter
    def VpcPrometheusEndpoint(self, VpcPrometheusEndpoint):
        self._VpcPrometheusEndpoint = VpcPrometheusEndpoint

    @property
    def NodePrometheusAddress(self):
        r"""
        :rtype: list of str
        """
        return self._NodePrometheusAddress

    @NodePrometheusAddress.setter
    def NodePrometheusAddress(self, NodePrometheusAddress):
        self._NodePrometheusAddress = NodePrometheusAddress

    @property
    def VpcEndpointInfo(self):
        r"""
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.VpcEndpointInfo`
        """
        return self._VpcEndpointInfo

    @VpcEndpointInfo.setter
    def VpcEndpointInfo(self, VpcEndpointInfo):
        self._VpcEndpointInfo = VpcEndpointInfo


    def _deserialize(self, params):
        self._PrometheusEndpointStatus = params.get("PrometheusEndpointStatus")
        self._VpcPrometheusEndpoint = params.get("VpcPrometheusEndpoint")
        self._NodePrometheusAddress = params.get("NodePrometheusAddress")
        if params.get("VpcEndpointInfo") is not None:
            self._VpcEndpointInfo = VpcEndpointInfo()
            self._VpcEndpointInfo._deserialize(params.get("VpcEndpointInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PublicAccessRule(AbstractModel):
    r"""Public Network Access Security Rules

    """

    def __init__(self):
        r"""
        :param _IpRule: IP Subnet Information
        :type IpRule: str
        :param _Allow: Allow or Deny
        :type Allow: bool
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        """
        self._IpRule = None
        self._Allow = None
        self._Remark = None

    @property
    def IpRule(self):
        r"""IP Subnet Information
        :rtype: str
        """
        return self._IpRule

    @IpRule.setter
    def IpRule(self, IpRule):
        self._IpRule = IpRule

    @property
    def Allow(self):
        r"""Allow or Deny
        :rtype: bool
        """
        return self._Allow

    @Allow.setter
    def Allow(self, Allow):
        self._Allow = Allow

    @property
    def Remark(self):
        r"""Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._IpRule = params.get("IpRule")
        self._Allow = params.get("Allow")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PublishCmqMsgRequest(AbstractModel):
    r"""PublishCmqMsg request structure.

    """

    def __init__(self):
        r"""
        :param _TopicName: Topic name
        :type TopicName: str
        :param _MsgContent: Message content. The total message size is up to 1,024 KB.
        :type MsgContent: str
        :param _MsgTag: Message tag. You can pass in multiple tags or a single route. Each tag or route can contain up to 64 characters.
        :type MsgTag: list of str
        """
        self._TopicName = None
        self._MsgContent = None
        self._MsgTag = None

    @property
    def TopicName(self):
        r"""Topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def MsgContent(self):
        r"""Message content. The total message size is up to 1,024 KB.
        :rtype: str
        """
        return self._MsgContent

    @MsgContent.setter
    def MsgContent(self, MsgContent):
        self._MsgContent = MsgContent

    @property
    def MsgTag(self):
        r"""Message tag. You can pass in multiple tags or a single route. Each tag or route can contain up to 64 characters.
        :rtype: list of str
        """
        return self._MsgTag

    @MsgTag.setter
    def MsgTag(self, MsgTag):
        self._MsgTag = MsgTag


    def _deserialize(self, params):
        self._TopicName = params.get("TopicName")
        self._MsgContent = params.get("MsgContent")
        self._MsgTag = params.get("MsgTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PublishCmqMsgResponse(AbstractModel):
    r"""PublishCmqMsg response structure.

    """

    def __init__(self):
        r"""
        :param _Result: `true` indicates that the sending is successful
        :type Result: bool
        :param _MsgId: Message ID
        :type MsgId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._MsgId = None
        self._RequestId = None

    @property
    def Result(self):
        r"""`true` indicates that the sending is successful
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._MsgId = params.get("MsgId")
        self._RequestId = params.get("RequestId")


class Publisher(AbstractModel):
    r"""Producer information

    """

    def __init__(self):
        r"""
        :param _ProducerId: Producer ID.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ProducerId: int
        :param _ProducerName: Producer name.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ProducerName: str
        :param _Address: Producer address.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Address: str
        :param _ClientVersion: Client version.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ClientVersion: str
        :param _MsgRateIn: Message production rate (message/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MsgRateIn: float
        :param _MsgThroughputIn: Message production throughput rate (byte/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MsgThroughputIn: float
        :param _AverageMsgSize: Average message size in bytes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type AverageMsgSize: float
        :param _ConnectedSince: Connection time.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ConnectedSince: str
        :param _Partition: Serial number of the topic partition connected to the producer.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Partition: int
        """
        self._ProducerId = None
        self._ProducerName = None
        self._Address = None
        self._ClientVersion = None
        self._MsgRateIn = None
        self._MsgThroughputIn = None
        self._AverageMsgSize = None
        self._ConnectedSince = None
        self._Partition = None

    @property
    def ProducerId(self):
        r"""Producer ID.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ProducerId

    @ProducerId.setter
    def ProducerId(self, ProducerId):
        self._ProducerId = ProducerId

    @property
    def ProducerName(self):
        r"""Producer name.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProducerName

    @ProducerName.setter
    def ProducerName(self, ProducerName):
        self._ProducerName = ProducerName

    @property
    def Address(self):
        r"""Producer address.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def ClientVersion(self):
        r"""Client version.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ClientVersion

    @ClientVersion.setter
    def ClientVersion(self, ClientVersion):
        self._ClientVersion = ClientVersion

    @property
    def MsgRateIn(self):
        r"""Message production rate (message/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MsgRateIn

    @MsgRateIn.setter
    def MsgRateIn(self, MsgRateIn):
        self._MsgRateIn = MsgRateIn

    @property
    def MsgThroughputIn(self):
        r"""Message production throughput rate (byte/sec).
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MsgThroughputIn

    @MsgThroughputIn.setter
    def MsgThroughputIn(self, MsgThroughputIn):
        self._MsgThroughputIn = MsgThroughputIn

    @property
    def AverageMsgSize(self):
        r"""Average message size in bytes.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._AverageMsgSize

    @AverageMsgSize.setter
    def AverageMsgSize(self, AverageMsgSize):
        self._AverageMsgSize = AverageMsgSize

    @property
    def ConnectedSince(self):
        r"""Connection time.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConnectedSince

    @ConnectedSince.setter
    def ConnectedSince(self, ConnectedSince):
        self._ConnectedSince = ConnectedSince

    @property
    def Partition(self):
        r"""Serial number of the topic partition connected to the producer.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Partition

    @Partition.setter
    def Partition(self, Partition):
        self._Partition = Partition


    def _deserialize(self, params):
        self._ProducerId = params.get("ProducerId")
        self._ProducerName = params.get("ProducerName")
        self._Address = params.get("Address")
        self._ClientVersion = params.get("ClientVersion")
        self._MsgRateIn = params.get("MsgRateIn")
        self._MsgThroughputIn = params.get("MsgThroughputIn")
        self._AverageMsgSize = params.get("AverageMsgSize")
        self._ConnectedSince = params.get("ConnectedSince")
        self._Partition = params.get("Partition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PulsarNetworkAccessPointInfo(AbstractModel):
    r"""TDMQ for Pulsar network access point information

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC ID. This field is left empty for supporting network and public network access points.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _SubnetId: Subnet ID. This field is left empty for supporting network and public network access points.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubnetId: str
        :param _Endpoint: Access address
        :type Endpoint: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _RouteType: Access point type: 
`0`: Supporting network access point 
`1`: VPC access point 
`2`: Public network access point
        :type RouteType: int
        :param _OperationType: 0: local region access. since cross-region disaster recovery is not configured, this type of access point cannot perform cross-region switchover or switch back from remote access.
Local region access. due to the configuration of cross-region disaster recovery, switchover can be performed at any time in a different location. this state is used for the primary cluster access point.
Cross-Region access, completed offsite switchover, this state is used for the access point of the source cluster. the access point in this state is non-deletable.
3: cross-region access can be switched back from remote access at any time. this state is for the access point of the target cluster. the access point in this state is non-deletable.
Cross-Region access. the target cluster has completed offsite switchback and is in the state of waiting for deletion.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationType: int
        :param _AccessPointsType: Access point type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessPointsType: str
        :param _Bandwidth: Bandwidth. currently only public network has this value.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bandwidth: int
        :param _SecurityPolicy: Class.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecurityPolicy: list of SecurityPolicy
        :param _StandardAccessPoint: Indicates whether it is a standard access point. valid values: true (standard), false (not standard).
Note: This field may return null, indicating that no valid values can be obtained.
        :type StandardAccessPoint: bool
        :param _ZoneName: AZ information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneName: str
        :param _Tls: Specifies whether TLS encryption is enabled.
        :type Tls: bool
        :param _CustomUrl: Access point custom domain name.
        :type CustomUrl: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._Endpoint = None
        self._InstanceId = None
        self._RouteType = None
        self._OperationType = None
        self._AccessPointsType = None
        self._Bandwidth = None
        self._SecurityPolicy = None
        self._StandardAccessPoint = None
        self._ZoneName = None
        self._Tls = None
        self._CustomUrl = None

    @property
    def VpcId(self):
        r"""VPC ID. This field is left empty for supporting network and public network access points.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID. This field is left empty for supporting network and public network access points.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Endpoint(self):
        r"""Access address
        :rtype: str
        """
        return self._Endpoint

    @Endpoint.setter
    def Endpoint(self, Endpoint):
        self._Endpoint = Endpoint

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RouteType(self):
        r"""Access point type: 
`0`: Supporting network access point 
`1`: VPC access point 
`2`: Public network access point
        :rtype: int
        """
        return self._RouteType

    @RouteType.setter
    def RouteType(self, RouteType):
        self._RouteType = RouteType

    @property
    def OperationType(self):
        r"""0: local region access. since cross-region disaster recovery is not configured, this type of access point cannot perform cross-region switchover or switch back from remote access.
Local region access. due to the configuration of cross-region disaster recovery, switchover can be performed at any time in a different location. this state is used for the primary cluster access point.
Cross-Region access, completed offsite switchover, this state is used for the access point of the source cluster. the access point in this state is non-deletable.
3: cross-region access can be switched back from remote access at any time. this state is for the access point of the target cluster. the access point in this state is non-deletable.
Cross-Region access. the target cluster has completed offsite switchback and is in the state of waiting for deletion.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def AccessPointsType(self):
        r"""Access point type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessPointsType

    @AccessPointsType.setter
    def AccessPointsType(self, AccessPointsType):
        self._AccessPointsType = AccessPointsType

    @property
    def Bandwidth(self):
        r"""Bandwidth. currently only public network has this value.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def SecurityPolicy(self):
        r"""Class.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SecurityPolicy
        """
        return self._SecurityPolicy

    @SecurityPolicy.setter
    def SecurityPolicy(self, SecurityPolicy):
        self._SecurityPolicy = SecurityPolicy

    @property
    def StandardAccessPoint(self):
        r"""Indicates whether it is a standard access point. valid values: true (standard), false (not standard).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._StandardAccessPoint

    @StandardAccessPoint.setter
    def StandardAccessPoint(self, StandardAccessPoint):
        self._StandardAccessPoint = StandardAccessPoint

    @property
    def ZoneName(self):
        r"""AZ information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def Tls(self):
        r"""Specifies whether TLS encryption is enabled.
        :rtype: bool
        """
        return self._Tls

    @Tls.setter
    def Tls(self, Tls):
        self._Tls = Tls

    @property
    def CustomUrl(self):
        r"""Access point custom domain name.
        :rtype: str
        """
        return self._CustomUrl

    @CustomUrl.setter
    def CustomUrl(self, CustomUrl):
        self._CustomUrl = CustomUrl


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Endpoint = params.get("Endpoint")
        self._InstanceId = params.get("InstanceId")
        self._RouteType = params.get("RouteType")
        self._OperationType = params.get("OperationType")
        self._AccessPointsType = params.get("AccessPointsType")
        self._Bandwidth = params.get("Bandwidth")
        if params.get("SecurityPolicy") is not None:
            self._SecurityPolicy = []
            for item in params.get("SecurityPolicy"):
                obj = SecurityPolicy()
                obj._deserialize(item)
                self._SecurityPolicy.append(obj)
        self._StandardAccessPoint = params.get("StandardAccessPoint")
        self._ZoneName = params.get("ZoneName")
        self._Tls = params.get("Tls")
        self._CustomUrl = params.get("CustomUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PulsarProClusterInfo(AbstractModel):
    r"""TDMQ for Pulsar pro cluster information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _Remark: Description
        :type Remark: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _Status: Cluster status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated).
        :type Status: int
        :param _Version: Cluster version
        :type Version: str
        :param _NodeDistribution: Node distribution
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeDistribution: list of InstanceNodeDistribution
        :param _MaxStorage: Max storage capacity in MB
        :type MaxStorage: int
        :param _CanEditRoute: Whether the route can be modified
Note: This field may return null, indicating that no valid values can be obtained.
        :type CanEditRoute: bool
        :param _BillingLabelVersion: Specifies different billing specifications for pro edition and small-scale professional edition: PULSAR.P1 fixed storage and PULSAR.P2 elastic storage.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingLabelVersion: str
        :param _ExpireTime: Instance expiration timestamp, accurate to the millisecond level.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpireTime: int
        :param _AutoCreateTopicStatus: Whether to enable automatic topic creation.
true indicates enabled. false indicates disabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AutoCreateTopicStatus: bool
        :param _DefaultPartitionNumber: Specifies the default number of partitions for automatic topic creation. valid values: 0 if not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefaultPartitionNumber: int
        :param _Tenant: User-Defined tenant alias. if there is no, reuse the professional cluster ID.

        :type Tenant: str
        :param _DeleteProtection: Deletion protection switch flag.
        :type DeleteProtection: int
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Remark = None
        self._CreateTime = None
        self._Status = None
        self._Version = None
        self._NodeDistribution = None
        self._MaxStorage = None
        self._CanEditRoute = None
        self._BillingLabelVersion = None
        self._ExpireTime = None
        self._AutoCreateTopicStatus = None
        self._DefaultPartitionNumber = None
        self._Tenant = None
        self._DeleteProtection = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Remark(self):
        r"""Description
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        r"""Cluster status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        r"""Cluster version
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def NodeDistribution(self):
        r"""Node distribution
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of InstanceNodeDistribution
        """
        return self._NodeDistribution

    @NodeDistribution.setter
    def NodeDistribution(self, NodeDistribution):
        self._NodeDistribution = NodeDistribution

    @property
    def MaxStorage(self):
        r"""Max storage capacity in MB
        :rtype: int
        """
        return self._MaxStorage

    @MaxStorage.setter
    def MaxStorage(self, MaxStorage):
        self._MaxStorage = MaxStorage

    @property
    def CanEditRoute(self):
        r"""Whether the route can be modified
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._CanEditRoute

    @CanEditRoute.setter
    def CanEditRoute(self, CanEditRoute):
        self._CanEditRoute = CanEditRoute

    @property
    def BillingLabelVersion(self):
        r"""Specifies different billing specifications for pro edition and small-scale professional edition: PULSAR.P1 fixed storage and PULSAR.P2 elastic storage.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._BillingLabelVersion

    @BillingLabelVersion.setter
    def BillingLabelVersion(self, BillingLabelVersion):
        self._BillingLabelVersion = BillingLabelVersion

    @property
    def ExpireTime(self):
        r"""Instance expiration timestamp, accurate to the millisecond level.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def AutoCreateTopicStatus(self):
        r"""Whether to enable automatic topic creation.
true indicates enabled. false indicates disabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AutoCreateTopicStatus

    @AutoCreateTopicStatus.setter
    def AutoCreateTopicStatus(self, AutoCreateTopicStatus):
        self._AutoCreateTopicStatus = AutoCreateTopicStatus

    @property
    def DefaultPartitionNumber(self):
        r"""Specifies the default number of partitions for automatic topic creation. valid values: 0 if not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DefaultPartitionNumber

    @DefaultPartitionNumber.setter
    def DefaultPartitionNumber(self, DefaultPartitionNumber):
        self._DefaultPartitionNumber = DefaultPartitionNumber

    @property
    def Tenant(self):
        r"""User-Defined tenant alias. if there is no, reuse the professional cluster ID.

        :rtype: str
        """
        return self._Tenant

    @Tenant.setter
    def Tenant(self, Tenant):
        self._Tenant = Tenant

    @property
    def DeleteProtection(self):
        r"""Deletion protection switch flag.
        :rtype: int
        """
        return self._DeleteProtection

    @DeleteProtection.setter
    def DeleteProtection(self, DeleteProtection):
        self._DeleteProtection = DeleteProtection


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Remark = params.get("Remark")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        if params.get("NodeDistribution") is not None:
            self._NodeDistribution = []
            for item in params.get("NodeDistribution"):
                obj = InstanceNodeDistribution()
                obj._deserialize(item)
                self._NodeDistribution.append(obj)
        self._MaxStorage = params.get("MaxStorage")
        self._CanEditRoute = params.get("CanEditRoute")
        self._BillingLabelVersion = params.get("BillingLabelVersion")
        self._ExpireTime = params.get("ExpireTime")
        self._AutoCreateTopicStatus = params.get("AutoCreateTopicStatus")
        self._DefaultPartitionNumber = params.get("DefaultPartitionNumber")
        self._Tenant = params.get("Tenant")
        self._DeleteProtection = params.get("DeleteProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PulsarProClusterSpecInfo(AbstractModel):
    r"""TDMQ for Pulsar pro cluster specification information

    """

    def __init__(self):
        r"""
        :param _SpecName: Cluster specification name
        :type SpecName: str
        :param _MaxTps: Peak TPS
        :type MaxTps: int
        :param _MaxBandWidth: Peak bandwidth in Mbps
        :type MaxBandWidth: int
        :param _MaxNamespaces: Maximum number of namespaces
        :type MaxNamespaces: int
        :param _MaxTopics: Maximum number of topic partitions
        :type MaxTopics: int
        :param _ScalableTps: Elastic TPS beyond the specification
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScalableTps: int
        :param _MaxPartitions: 32 or 128.
Maximum number of partitions for topics in the current cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxPartitions: int
        :param _MaxDelayedMessages: Maximum delayed message count for the product. 0 indicates no limit.	
        :type MaxDelayedMessages: int
        """
        self._SpecName = None
        self._MaxTps = None
        self._MaxBandWidth = None
        self._MaxNamespaces = None
        self._MaxTopics = None
        self._ScalableTps = None
        self._MaxPartitions = None
        self._MaxDelayedMessages = None

    @property
    def SpecName(self):
        r"""Cluster specification name
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def MaxTps(self):
        r"""Peak TPS
        :rtype: int
        """
        return self._MaxTps

    @MaxTps.setter
    def MaxTps(self, MaxTps):
        self._MaxTps = MaxTps

    @property
    def MaxBandWidth(self):
        r"""Peak bandwidth in Mbps
        :rtype: int
        """
        return self._MaxBandWidth

    @MaxBandWidth.setter
    def MaxBandWidth(self, MaxBandWidth):
        self._MaxBandWidth = MaxBandWidth

    @property
    def MaxNamespaces(self):
        r"""Maximum number of namespaces
        :rtype: int
        """
        return self._MaxNamespaces

    @MaxNamespaces.setter
    def MaxNamespaces(self, MaxNamespaces):
        self._MaxNamespaces = MaxNamespaces

    @property
    def MaxTopics(self):
        r"""Maximum number of topic partitions
        :rtype: int
        """
        return self._MaxTopics

    @MaxTopics.setter
    def MaxTopics(self, MaxTopics):
        self._MaxTopics = MaxTopics

    @property
    def ScalableTps(self):
        r"""Elastic TPS beyond the specification
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ScalableTps

    @ScalableTps.setter
    def ScalableTps(self, ScalableTps):
        self._ScalableTps = ScalableTps

    @property
    def MaxPartitions(self):
        r"""32 or 128.
Maximum number of partitions for topics in the current cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxPartitions

    @MaxPartitions.setter
    def MaxPartitions(self, MaxPartitions):
        self._MaxPartitions = MaxPartitions

    @property
    def MaxDelayedMessages(self):
        r"""Maximum delayed message count for the product. 0 indicates no limit.	
        :rtype: int
        """
        return self._MaxDelayedMessages

    @MaxDelayedMessages.setter
    def MaxDelayedMessages(self, MaxDelayedMessages):
        self._MaxDelayedMessages = MaxDelayedMessages


    def _deserialize(self, params):
        self._SpecName = params.get("SpecName")
        self._MaxTps = params.get("MaxTps")
        self._MaxBandWidth = params.get("MaxBandWidth")
        self._MaxNamespaces = params.get("MaxNamespaces")
        self._MaxTopics = params.get("MaxTopics")
        self._ScalableTps = params.get("ScalableTps")
        self._MaxPartitions = params.get("MaxPartitions")
        self._MaxDelayedMessages = params.get("MaxDelayedMessages")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PulsarProInstance(AbstractModel):
    r"""TDMQ for Pulsar pro instance information

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _InstanceVersion: Instance version
        :type InstanceVersion: str
        :param _Status: Instance status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated), `3` (Terminated), `4` (Abnormal), `5` (Delivery failed), `6` (Adjusting configuration), `7` (Configuration adjustment failed).
        :type Status: int
        :param _ConfigDisplay: Instance specification name
        :type ConfigDisplay: str
        :param _MaxTps: Peak TPS
        :type MaxTps: int
        :param _MaxStorage: Storage capacity in GB
        :type MaxStorage: int
        :param _ExpireTime: Instance expiration time in milliseconds
        :type ExpireTime: int
        :param _AutoRenewFlag: Renewal mode. Valid values: `0` (Manual renewal, which is the default mode), `1` (Auto-renewal), `2` (Manual renewal, which is specified by users).
        :type AutoRenewFlag: int
        :param _PayMode: Payment mode. Valid values: `0` (Pay-as-you-go), `1` (Monthly subscription).
        :type PayMode: int
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _SpecName: Instance specification ID
        :type SpecName: str
        :param _ScalableTps: Elastic TPS beyond the specification
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScalableTps: int
        :param _VpcId: VPC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _SubnetId: Subnet ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubnetId: str
        :param _MaxBandWidth: Peak bandwidth in Mbps
        :type MaxBandWidth: int
        :param _Tags: Tag list of the cluster
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _CreateTime: Cluster Creation Time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _BillingLabelVersion: Specifies the different billing specifications for pro edition and small-scale professional edition: PULSAR.P1 fixed storage and PULSAR.P2 elastic storage.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingLabelVersion: str
        :param _Tenant: Custom tenant.
        :type Tenant: str
        :param _CertificateList: Certificate list of the cluster.
        :type CertificateList: list of CertificateInfo
        """
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceVersion = None
        self._Status = None
        self._ConfigDisplay = None
        self._MaxTps = None
        self._MaxStorage = None
        self._ExpireTime = None
        self._AutoRenewFlag = None
        self._PayMode = None
        self._Remark = None
        self._SpecName = None
        self._ScalableTps = None
        self._VpcId = None
        self._SubnetId = None
        self._MaxBandWidth = None
        self._Tags = None
        self._CreateTime = None
        self._BillingLabelVersion = None
        self._Tenant = None
        self._CertificateList = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceVersion(self):
        r"""Instance version
        :rtype: str
        """
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion

    @property
    def Status(self):
        r"""Instance status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated), `3` (Terminated), `4` (Abnormal), `5` (Delivery failed), `6` (Adjusting configuration), `7` (Configuration adjustment failed).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ConfigDisplay(self):
        r"""Instance specification name
        :rtype: str
        """
        return self._ConfigDisplay

    @ConfigDisplay.setter
    def ConfigDisplay(self, ConfigDisplay):
        self._ConfigDisplay = ConfigDisplay

    @property
    def MaxTps(self):
        r"""Peak TPS
        :rtype: int
        """
        return self._MaxTps

    @MaxTps.setter
    def MaxTps(self, MaxTps):
        self._MaxTps = MaxTps

    @property
    def MaxStorage(self):
        r"""Storage capacity in GB
        :rtype: int
        """
        return self._MaxStorage

    @MaxStorage.setter
    def MaxStorage(self, MaxStorage):
        self._MaxStorage = MaxStorage

    @property
    def ExpireTime(self):
        r"""Instance expiration time in milliseconds
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def AutoRenewFlag(self):
        r"""Renewal mode. Valid values: `0` (Manual renewal, which is the default mode), `1` (Auto-renewal), `2` (Manual renewal, which is specified by users).
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def PayMode(self):
        r"""Payment mode. Valid values: `0` (Pay-as-you-go), `1` (Monthly subscription).
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Remark(self):
        r"""Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SpecName(self):
        r"""Instance specification ID
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def ScalableTps(self):
        r"""Elastic TPS beyond the specification
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ScalableTps

    @ScalableTps.setter
    def ScalableTps(self, ScalableTps):
        self._ScalableTps = ScalableTps

    @property
    def VpcId(self):
        r"""VPC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def MaxBandWidth(self):
        r"""Peak bandwidth in Mbps
        :rtype: int
        """
        return self._MaxBandWidth

    @MaxBandWidth.setter
    def MaxBandWidth(self, MaxBandWidth):
        self._MaxBandWidth = MaxBandWidth

    @property
    def Tags(self):
        r"""Tag list of the cluster
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CreateTime(self):
        r"""Cluster Creation Time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BillingLabelVersion(self):
        r"""Specifies the different billing specifications for pro edition and small-scale professional edition: PULSAR.P1 fixed storage and PULSAR.P2 elastic storage.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._BillingLabelVersion

    @BillingLabelVersion.setter
    def BillingLabelVersion(self, BillingLabelVersion):
        self._BillingLabelVersion = BillingLabelVersion

    @property
    def Tenant(self):
        r"""Custom tenant.
        :rtype: str
        """
        return self._Tenant

    @Tenant.setter
    def Tenant(self, Tenant):
        self._Tenant = Tenant

    @property
    def CertificateList(self):
        r"""Certificate list of the cluster.
        :rtype: list of CertificateInfo
        """
        return self._CertificateList

    @CertificateList.setter
    def CertificateList(self, CertificateList):
        self._CertificateList = CertificateList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceVersion = params.get("InstanceVersion")
        self._Status = params.get("Status")
        self._ConfigDisplay = params.get("ConfigDisplay")
        self._MaxTps = params.get("MaxTps")
        self._MaxStorage = params.get("MaxStorage")
        self._ExpireTime = params.get("ExpireTime")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._PayMode = params.get("PayMode")
        self._Remark = params.get("Remark")
        self._SpecName = params.get("SpecName")
        self._ScalableTps = params.get("ScalableTps")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._MaxBandWidth = params.get("MaxBandWidth")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._BillingLabelVersion = params.get("BillingLabelVersion")
        self._Tenant = params.get("Tenant")
        if params.get("CertificateList") is not None:
            self._CertificateList = []
            for item in params.get("CertificateList"):
                obj = CertificateInfo()
                obj._deserialize(item)
                self._CertificateList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueueQuota(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _MaxQueue: 
        :type MaxQueue: int
        :param _UsedQueue: Number of created Queues.
        :type UsedQueue: int
        """
        self._MaxQueue = None
        self._UsedQueue = None

    @property
    def MaxQueue(self):
        r"""
        :rtype: int
        """
        return self._MaxQueue

    @MaxQueue.setter
    def MaxQueue(self, MaxQueue):
        self._MaxQueue = MaxQueue

    @property
    def UsedQueue(self):
        r"""Number of created Queues.
        :rtype: int
        """
        return self._UsedQueue

    @UsedQueue.setter
    def UsedQueue(self, UsedQueue):
        self._UsedQueue = UsedQueue


    def _deserialize(self, params):
        self._MaxQueue = params.get("MaxQueue")
        self._UsedQueue = params.get("UsedQueue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQBindingListInfo(AbstractModel):
    r"""RabbitMQ routing relationship list member.

    """

    def __init__(self):
        r"""
        :param _BindingId: Routing relationship ID.
        :type BindingId: int
        :param _VirtualHost: VhostName
        :type VirtualHost: str
        :param _Source: Source exchange name.
        :type Source: str
        :param _DestinationType: Destination type. Valid values: queue and exchange.
        :type DestinationType: str
        :param _Destination: Destination resource name.
        :type Destination: str
        :param _RoutingKey: Binds the key.
        :type RoutingKey: str
        :param _SourceExchangeType: Source exchange type.
        :type SourceExchangeType: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _ModifyTime: Modification time.
        :type ModifyTime: str
        :param _CreateTs: Creation timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification timestamp.
        :type ModifyTs: int
        """
        self._BindingId = None
        self._VirtualHost = None
        self._Source = None
        self._DestinationType = None
        self._Destination = None
        self._RoutingKey = None
        self._SourceExchangeType = None
        self._CreateTime = None
        self._ModifyTime = None
        self._CreateTs = None
        self._ModifyTs = None

    @property
    def BindingId(self):
        r"""Routing relationship ID.
        :rtype: int
        """
        return self._BindingId

    @BindingId.setter
    def BindingId(self, BindingId):
        self._BindingId = BindingId

    @property
    def VirtualHost(self):
        r"""VhostName
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Source(self):
        r"""Source exchange name.
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def DestinationType(self):
        r"""Destination type. Valid values: queue and exchange.
        :rtype: str
        """
        return self._DestinationType

    @DestinationType.setter
    def DestinationType(self, DestinationType):
        self._DestinationType = DestinationType

    @property
    def Destination(self):
        r"""Destination resource name.
        :rtype: str
        """
        return self._Destination

    @Destination.setter
    def Destination(self, Destination):
        self._Destination = Destination

    @property
    def RoutingKey(self):
        r"""Binds the key.
        :rtype: str
        """
        return self._RoutingKey

    @RoutingKey.setter
    def RoutingKey(self, RoutingKey):
        self._RoutingKey = RoutingKey

    @property
    def SourceExchangeType(self):
        r"""Source exchange type.
        :rtype: str
        """
        return self._SourceExchangeType

    @SourceExchangeType.setter
    def SourceExchangeType(self, SourceExchangeType):
        self._SourceExchangeType = SourceExchangeType

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        r"""Modification time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTs(self):
        r"""Creation timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs


    def _deserialize(self, params):
        self._BindingId = params.get("BindingId")
        self._VirtualHost = params.get("VirtualHost")
        self._Source = params.get("Source")
        self._DestinationType = params.get("DestinationType")
        self._Destination = params.get("Destination")
        self._RoutingKey = params.get("RoutingKey")
        self._SourceExchangeType = params.get("SourceExchangeType")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQClusterAccessInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _PublicAccessEndpoint: 
        :type PublicAccessEndpoint: str
        :param _WebConsoleEndpoint: 
        :type WebConsoleEndpoint: str
        :param _WebConsoleUsername: 
        :type WebConsoleUsername: str
        :param _WebConsolePassword: 
        :type WebConsolePassword: str
        :param _PublicAccessEndpointStatus: 
        :type PublicAccessEndpointStatus: bool
        :param _PublicControlConsoleSwitchStatus: 
        :type PublicControlConsoleSwitchStatus: bool
        :param _VpcControlConsoleSwitchStatus: 
        :type VpcControlConsoleSwitchStatus: bool
        :param _VpcWebConsoleEndpoint: 
        :type VpcWebConsoleEndpoint: str
        :param _PublicWebConsoleSwitchStatus: Status of the public network access point in the console. Valid values: OFF, ON, CREATING, and DELETING.
        :type PublicWebConsoleSwitchStatus: str
        :param _VpcWebConsoleSwitchStatus: Vpc console switch state. example value.
OFF/ON/CREATING/DELETING
        :type VpcWebConsoleSwitchStatus: str
        :param _PublicDataStreamStatus: Status of the public network access point in the console. Valid values: OFF, ON, CREATING, and DELETING.
        :type PublicDataStreamStatus: str
        :param _PrometheusEndpointInfo: Prometheus information.
        :type PrometheusEndpointInfo: :class:`tencentcloud.tdmq.v20200217.models.PrometheusEndpointInfo`
        :param _WebConsoleDomainEndpoint: Public domain name access point.
        :type WebConsoleDomainEndpoint: str
        :param _ControlPlaneEndpointInfo: VPC information used by the control plane.
        :type ControlPlaneEndpointInfo: :class:`tencentcloud.tdmq.v20200217.models.VpcEndpointInfo`
        :param _PublicTlsAccessEndpoint: Encrypted TLS data stream public network access point.
        :type PublicTlsAccessEndpoint: str
        :param _PublicIpReused: Specifies whether to reuse the public IP address.
        :type PublicIpReused: bool
        """
        self._PublicAccessEndpoint = None
        self._WebConsoleEndpoint = None
        self._WebConsoleUsername = None
        self._WebConsolePassword = None
        self._PublicAccessEndpointStatus = None
        self._PublicControlConsoleSwitchStatus = None
        self._VpcControlConsoleSwitchStatus = None
        self._VpcWebConsoleEndpoint = None
        self._PublicWebConsoleSwitchStatus = None
        self._VpcWebConsoleSwitchStatus = None
        self._PublicDataStreamStatus = None
        self._PrometheusEndpointInfo = None
        self._WebConsoleDomainEndpoint = None
        self._ControlPlaneEndpointInfo = None
        self._PublicTlsAccessEndpoint = None
        self._PublicIpReused = None

    @property
    def PublicAccessEndpoint(self):
        r"""
        :rtype: str
        """
        return self._PublicAccessEndpoint

    @PublicAccessEndpoint.setter
    def PublicAccessEndpoint(self, PublicAccessEndpoint):
        self._PublicAccessEndpoint = PublicAccessEndpoint

    @property
    def WebConsoleEndpoint(self):
        r"""
        :rtype: str
        """
        return self._WebConsoleEndpoint

    @WebConsoleEndpoint.setter
    def WebConsoleEndpoint(self, WebConsoleEndpoint):
        self._WebConsoleEndpoint = WebConsoleEndpoint

    @property
    def WebConsoleUsername(self):
        r"""
        :rtype: str
        """
        return self._WebConsoleUsername

    @WebConsoleUsername.setter
    def WebConsoleUsername(self, WebConsoleUsername):
        self._WebConsoleUsername = WebConsoleUsername

    @property
    def WebConsolePassword(self):
        r"""
        :rtype: str
        """
        return self._WebConsolePassword

    @WebConsolePassword.setter
    def WebConsolePassword(self, WebConsolePassword):
        self._WebConsolePassword = WebConsolePassword

    @property
    def PublicAccessEndpointStatus(self):
        r"""
        :rtype: bool
        """
        return self._PublicAccessEndpointStatus

    @PublicAccessEndpointStatus.setter
    def PublicAccessEndpointStatus(self, PublicAccessEndpointStatus):
        self._PublicAccessEndpointStatus = PublicAccessEndpointStatus

    @property
    def PublicControlConsoleSwitchStatus(self):
        r"""
        :rtype: bool
        """
        return self._PublicControlConsoleSwitchStatus

    @PublicControlConsoleSwitchStatus.setter
    def PublicControlConsoleSwitchStatus(self, PublicControlConsoleSwitchStatus):
        self._PublicControlConsoleSwitchStatus = PublicControlConsoleSwitchStatus

    @property
    def VpcControlConsoleSwitchStatus(self):
        r"""
        :rtype: bool
        """
        return self._VpcControlConsoleSwitchStatus

    @VpcControlConsoleSwitchStatus.setter
    def VpcControlConsoleSwitchStatus(self, VpcControlConsoleSwitchStatus):
        self._VpcControlConsoleSwitchStatus = VpcControlConsoleSwitchStatus

    @property
    def VpcWebConsoleEndpoint(self):
        r"""
        :rtype: str
        """
        return self._VpcWebConsoleEndpoint

    @VpcWebConsoleEndpoint.setter
    def VpcWebConsoleEndpoint(self, VpcWebConsoleEndpoint):
        self._VpcWebConsoleEndpoint = VpcWebConsoleEndpoint

    @property
    def PublicWebConsoleSwitchStatus(self):
        r"""Status of the public network access point in the console. Valid values: OFF, ON, CREATING, and DELETING.
        :rtype: str
        """
        return self._PublicWebConsoleSwitchStatus

    @PublicWebConsoleSwitchStatus.setter
    def PublicWebConsoleSwitchStatus(self, PublicWebConsoleSwitchStatus):
        self._PublicWebConsoleSwitchStatus = PublicWebConsoleSwitchStatus

    @property
    def VpcWebConsoleSwitchStatus(self):
        r"""Vpc console switch state. example value.
OFF/ON/CREATING/DELETING
        :rtype: str
        """
        return self._VpcWebConsoleSwitchStatus

    @VpcWebConsoleSwitchStatus.setter
    def VpcWebConsoleSwitchStatus(self, VpcWebConsoleSwitchStatus):
        self._VpcWebConsoleSwitchStatus = VpcWebConsoleSwitchStatus

    @property
    def PublicDataStreamStatus(self):
        r"""Status of the public network access point in the console. Valid values: OFF, ON, CREATING, and DELETING.
        :rtype: str
        """
        return self._PublicDataStreamStatus

    @PublicDataStreamStatus.setter
    def PublicDataStreamStatus(self, PublicDataStreamStatus):
        self._PublicDataStreamStatus = PublicDataStreamStatus

    @property
    def PrometheusEndpointInfo(self):
        r"""Prometheus information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.PrometheusEndpointInfo`
        """
        return self._PrometheusEndpointInfo

    @PrometheusEndpointInfo.setter
    def PrometheusEndpointInfo(self, PrometheusEndpointInfo):
        self._PrometheusEndpointInfo = PrometheusEndpointInfo

    @property
    def WebConsoleDomainEndpoint(self):
        r"""Public domain name access point.
        :rtype: str
        """
        return self._WebConsoleDomainEndpoint

    @WebConsoleDomainEndpoint.setter
    def WebConsoleDomainEndpoint(self, WebConsoleDomainEndpoint):
        self._WebConsoleDomainEndpoint = WebConsoleDomainEndpoint

    @property
    def ControlPlaneEndpointInfo(self):
        r"""VPC information used by the control plane.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.VpcEndpointInfo`
        """
        return self._ControlPlaneEndpointInfo

    @ControlPlaneEndpointInfo.setter
    def ControlPlaneEndpointInfo(self, ControlPlaneEndpointInfo):
        self._ControlPlaneEndpointInfo = ControlPlaneEndpointInfo

    @property
    def PublicTlsAccessEndpoint(self):
        r"""Encrypted TLS data stream public network access point.
        :rtype: str
        """
        return self._PublicTlsAccessEndpoint

    @PublicTlsAccessEndpoint.setter
    def PublicTlsAccessEndpoint(self, PublicTlsAccessEndpoint):
        self._PublicTlsAccessEndpoint = PublicTlsAccessEndpoint

    @property
    def PublicIpReused(self):
        r"""Specifies whether to reuse the public IP address.
        :rtype: bool
        """
        return self._PublicIpReused

    @PublicIpReused.setter
    def PublicIpReused(self, PublicIpReused):
        self._PublicIpReused = PublicIpReused


    def _deserialize(self, params):
        self._PublicAccessEndpoint = params.get("PublicAccessEndpoint")
        self._WebConsoleEndpoint = params.get("WebConsoleEndpoint")
        self._WebConsoleUsername = params.get("WebConsoleUsername")
        self._WebConsolePassword = params.get("WebConsolePassword")
        self._PublicAccessEndpointStatus = params.get("PublicAccessEndpointStatus")
        self._PublicControlConsoleSwitchStatus = params.get("PublicControlConsoleSwitchStatus")
        self._VpcControlConsoleSwitchStatus = params.get("VpcControlConsoleSwitchStatus")
        self._VpcWebConsoleEndpoint = params.get("VpcWebConsoleEndpoint")
        self._PublicWebConsoleSwitchStatus = params.get("PublicWebConsoleSwitchStatus")
        self._VpcWebConsoleSwitchStatus = params.get("VpcWebConsoleSwitchStatus")
        self._PublicDataStreamStatus = params.get("PublicDataStreamStatus")
        if params.get("PrometheusEndpointInfo") is not None:
            self._PrometheusEndpointInfo = PrometheusEndpointInfo()
            self._PrometheusEndpointInfo._deserialize(params.get("PrometheusEndpointInfo"))
        self._WebConsoleDomainEndpoint = params.get("WebConsoleDomainEndpoint")
        if params.get("ControlPlaneEndpointInfo") is not None:
            self._ControlPlaneEndpointInfo = VpcEndpointInfo()
            self._ControlPlaneEndpointInfo._deserialize(params.get("ControlPlaneEndpointInfo"))
        self._PublicTlsAccessEndpoint = params.get("PublicTlsAccessEndpoint")
        self._PublicIpReused = params.get("PublicIpReused")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQClusterInfo(AbstractModel):
    r"""RabbitMQ cluster basic information.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: 
        :type ClusterName: str
        :param _Region: 
        :type Region: str
        :param _CreateTime: Creation time in milliseconds. unix timestamp.
        :type CreateTime: int
        :param _Remark: Cluster description information
        :type Remark: str
        :param _Vpcs: 
        :type Vpcs: list of VpcEndpointInfo
        :param _ZoneIds: AZ information
        :type ZoneIds: list of int
        :param _VirtualHostNumber: 
        :type VirtualHostNumber: int
        :param _QueueNumber: 
        :type QueueNumber: int
        :param _MessagePublishRate: 
        :type MessagePublishRate: float
        :param _MessageStackNumber: 
        :type MessageStackNumber: int
        :param _ExpireTime: Specifies the instance expiration time in milliseconds as a unix timestamp. the value is 0 for pay-as-you-go resources.
        :type ExpireTime: int
        :param _ChannelNumber: 
        :type ChannelNumber: int
        :param _ConnectionNumber: 
        :type ConnectionNumber: int
        :param _ConsumerNumber: 
        :type ConsumerNumber: int
        :param _ExchangeNumber: 
        :type ExchangeNumber: int
        :param _ExceptionInformation: Cluster exception information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptionInformation: str
        :param _ClusterStatus: Instance status. 0: creating; 1: normal; 2: isolating; 3: terminated; 4: abnormal; 5: delivery failed.
        :type ClusterStatus: int
        :param _AutoRenewFlag: Auto-renewal flag. 0 indicates the default status (If the default status is not configured, manual renewal is enabled), 1 indicates auto-renewal, and 2 indicates explicitly no auto-renewal (configured by the user).
        :type AutoRenewFlag: int
        :param _MirrorQueuePolicyFlag: Whether the image queue policy is enabled. 1: enabled; 0: disabled.
        :type MirrorQueuePolicyFlag: int
        :param _MessageConsumeRate: Number of messages consumed per second. Unit: messages/second.
        :type MessageConsumeRate: float
        :param _ClusterVersion: Cluster version information.
        :type ClusterVersion: str
        :param _PayMode: Billing mode. 0: postpaid; 1: prepaid.
        :type PayMode: int
        :param _InstanceType: Instance type. 0: Exclusive Edition; 1: Serverless Edition.
        :type InstanceType: int
        :param _IsolatedTime: Specifies the isolation time started. unix timestamp.
        :type IsolatedTime: int
        :param _Container: Whether it is a container instance. default true.
        :type Container: bool
        :param _Tags: Tag list
        :type Tags: list of Tag
        :param _EnableDeletionProtection: Whether deletion protection is enabled.
        :type EnableDeletionProtection: bool
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Region = None
        self._CreateTime = None
        self._Remark = None
        self._Vpcs = None
        self._ZoneIds = None
        self._VirtualHostNumber = None
        self._QueueNumber = None
        self._MessagePublishRate = None
        self._MessageStackNumber = None
        self._ExpireTime = None
        self._ChannelNumber = None
        self._ConnectionNumber = None
        self._ConsumerNumber = None
        self._ExchangeNumber = None
        self._ExceptionInformation = None
        self._ClusterStatus = None
        self._AutoRenewFlag = None
        self._MirrorQueuePolicyFlag = None
        self._MessageConsumeRate = None
        self._ClusterVersion = None
        self._PayMode = None
        self._InstanceType = None
        self._IsolatedTime = None
        self._Container = None
        self._Tags = None
        self._EnableDeletionProtection = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Region(self):
        r"""
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def CreateTime(self):
        r"""Creation time in milliseconds. unix timestamp.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Remark(self):
        r"""Cluster description information
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Vpcs(self):
        r"""
        :rtype: list of VpcEndpointInfo
        """
        return self._Vpcs

    @Vpcs.setter
    def Vpcs(self, Vpcs):
        self._Vpcs = Vpcs

    @property
    def ZoneIds(self):
        r"""AZ information
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def VirtualHostNumber(self):
        r"""
        :rtype: int
        """
        return self._VirtualHostNumber

    @VirtualHostNumber.setter
    def VirtualHostNumber(self, VirtualHostNumber):
        self._VirtualHostNumber = VirtualHostNumber

    @property
    def QueueNumber(self):
        r"""
        :rtype: int
        """
        return self._QueueNumber

    @QueueNumber.setter
    def QueueNumber(self, QueueNumber):
        self._QueueNumber = QueueNumber

    @property
    def MessagePublishRate(self):
        r"""
        :rtype: float
        """
        return self._MessagePublishRate

    @MessagePublishRate.setter
    def MessagePublishRate(self, MessagePublishRate):
        self._MessagePublishRate = MessagePublishRate

    @property
    def MessageStackNumber(self):
        r"""
        :rtype: int
        """
        return self._MessageStackNumber

    @MessageStackNumber.setter
    def MessageStackNumber(self, MessageStackNumber):
        self._MessageStackNumber = MessageStackNumber

    @property
    def ExpireTime(self):
        r"""Specifies the instance expiration time in milliseconds as a unix timestamp. the value is 0 for pay-as-you-go resources.
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def ChannelNumber(self):
        r"""
        :rtype: int
        """
        return self._ChannelNumber

    @ChannelNumber.setter
    def ChannelNumber(self, ChannelNumber):
        self._ChannelNumber = ChannelNumber

    @property
    def ConnectionNumber(self):
        r"""
        :rtype: int
        """
        return self._ConnectionNumber

    @ConnectionNumber.setter
    def ConnectionNumber(self, ConnectionNumber):
        self._ConnectionNumber = ConnectionNumber

    @property
    def ConsumerNumber(self):
        r"""
        :rtype: int
        """
        return self._ConsumerNumber

    @ConsumerNumber.setter
    def ConsumerNumber(self, ConsumerNumber):
        self._ConsumerNumber = ConsumerNumber

    @property
    def ExchangeNumber(self):
        r"""
        :rtype: int
        """
        return self._ExchangeNumber

    @ExchangeNumber.setter
    def ExchangeNumber(self, ExchangeNumber):
        self._ExchangeNumber = ExchangeNumber

    @property
    def ExceptionInformation(self):
        r"""Cluster exception information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExceptionInformation

    @ExceptionInformation.setter
    def ExceptionInformation(self, ExceptionInformation):
        self._ExceptionInformation = ExceptionInformation

    @property
    def ClusterStatus(self):
        r"""Instance status. 0: creating; 1: normal; 2: isolating; 3: terminated; 4: abnormal; 5: delivery failed.
        :rtype: int
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def AutoRenewFlag(self):
        r"""Auto-renewal flag. 0 indicates the default status (If the default status is not configured, manual renewal is enabled), 1 indicates auto-renewal, and 2 indicates explicitly no auto-renewal (configured by the user).
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def MirrorQueuePolicyFlag(self):
        r"""Whether the image queue policy is enabled. 1: enabled; 0: disabled.
        :rtype: int
        """
        return self._MirrorQueuePolicyFlag

    @MirrorQueuePolicyFlag.setter
    def MirrorQueuePolicyFlag(self, MirrorQueuePolicyFlag):
        self._MirrorQueuePolicyFlag = MirrorQueuePolicyFlag

    @property
    def MessageConsumeRate(self):
        r"""Number of messages consumed per second. Unit: messages/second.
        :rtype: float
        """
        return self._MessageConsumeRate

    @MessageConsumeRate.setter
    def MessageConsumeRate(self, MessageConsumeRate):
        self._MessageConsumeRate = MessageConsumeRate

    @property
    def ClusterVersion(self):
        r"""Cluster version information.
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def PayMode(self):
        r"""Billing mode. 0: postpaid; 1: prepaid.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def InstanceType(self):
        r"""Instance type. 0: Exclusive Edition; 1: Serverless Edition.
        :rtype: int
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def IsolatedTime(self):
        r"""Specifies the isolation time started. unix timestamp.
        :rtype: int
        """
        return self._IsolatedTime

    @IsolatedTime.setter
    def IsolatedTime(self, IsolatedTime):
        self._IsolatedTime = IsolatedTime

    @property
    def Container(self):
        r"""Whether it is a container instance. default true.
        :rtype: bool
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Tags(self):
        r"""Tag list
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def EnableDeletionProtection(self):
        r"""Whether deletion protection is enabled.
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Region = params.get("Region")
        self._CreateTime = params.get("CreateTime")
        self._Remark = params.get("Remark")
        if params.get("Vpcs") is not None:
            self._Vpcs = []
            for item in params.get("Vpcs"):
                obj = VpcEndpointInfo()
                obj._deserialize(item)
                self._Vpcs.append(obj)
        self._ZoneIds = params.get("ZoneIds")
        self._VirtualHostNumber = params.get("VirtualHostNumber")
        self._QueueNumber = params.get("QueueNumber")
        self._MessagePublishRate = params.get("MessagePublishRate")
        self._MessageStackNumber = params.get("MessageStackNumber")
        self._ExpireTime = params.get("ExpireTime")
        self._ChannelNumber = params.get("ChannelNumber")
        self._ConnectionNumber = params.get("ConnectionNumber")
        self._ConsumerNumber = params.get("ConsumerNumber")
        self._ExchangeNumber = params.get("ExchangeNumber")
        self._ExceptionInformation = params.get("ExceptionInformation")
        self._ClusterStatus = params.get("ClusterStatus")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._MirrorQueuePolicyFlag = params.get("MirrorQueuePolicyFlag")
        self._MessageConsumeRate = params.get("MessageConsumeRate")
        self._ClusterVersion = params.get("ClusterVersion")
        self._PayMode = params.get("PayMode")
        self._InstanceType = params.get("InstanceType")
        self._IsolatedTime = params.get("IsolatedTime")
        self._Container = params.get("Container")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQClusterSpecInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _SpecName: 
        :type SpecName: str
        :param _NodeCount: 
        :type NodeCount: int
        :param _MaxTps: 
        :type MaxTps: int
        :param _MaxBandWidth: 
        :type MaxBandWidth: int
        :param _MaxStorage: 
        :type MaxStorage: int
        :param _PublicNetworkTps: 
        :type PublicNetworkTps: int
        """
        self._SpecName = None
        self._NodeCount = None
        self._MaxTps = None
        self._MaxBandWidth = None
        self._MaxStorage = None
        self._PublicNetworkTps = None

    @property
    def SpecName(self):
        r"""
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def NodeCount(self):
        r"""
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def MaxTps(self):
        r"""
        :rtype: int
        """
        return self._MaxTps

    @MaxTps.setter
    def MaxTps(self, MaxTps):
        self._MaxTps = MaxTps

    @property
    def MaxBandWidth(self):
        r"""
        :rtype: int
        """
        return self._MaxBandWidth

    @MaxBandWidth.setter
    def MaxBandWidth(self, MaxBandWidth):
        self._MaxBandWidth = MaxBandWidth

    @property
    def MaxStorage(self):
        r"""
        :rtype: int
        """
        return self._MaxStorage

    @MaxStorage.setter
    def MaxStorage(self, MaxStorage):
        self._MaxStorage = MaxStorage

    @property
    def PublicNetworkTps(self):
        r"""
        :rtype: int
        """
        return self._PublicNetworkTps

    @PublicNetworkTps.setter
    def PublicNetworkTps(self, PublicNetworkTps):
        self._PublicNetworkTps = PublicNetworkTps


    def _deserialize(self, params):
        self._SpecName = params.get("SpecName")
        self._NodeCount = params.get("NodeCount")
        self._MaxTps = params.get("MaxTps")
        self._MaxBandWidth = params.get("MaxBandWidth")
        self._MaxStorage = params.get("MaxStorage")
        self._PublicNetworkTps = params.get("PublicNetworkTps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQClusterWhiteListInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _WhiteList: Deprecated.
        :type WhiteList: str
        :param _PublicControlConsoleWhiteList: Public network console allowlist.
        :type PublicControlConsoleWhiteList: str
        :param _PublicDataStreamWhiteList: Public network data flow allowlist.
        :type PublicDataStreamWhiteList: str
        :param _PublicControlConsoleWhiteListStatus: 
        :type PublicControlConsoleWhiteListStatus: str
        :param _PublicDataStreamWhiteListStatus: 
        :type PublicDataStreamWhiteListStatus: str
        """
        self._WhiteList = None
        self._PublicControlConsoleWhiteList = None
        self._PublicDataStreamWhiteList = None
        self._PublicControlConsoleWhiteListStatus = None
        self._PublicDataStreamWhiteListStatus = None

    @property
    def WhiteList(self):
        r"""Deprecated.
        :rtype: str
        """
        return self._WhiteList

    @WhiteList.setter
    def WhiteList(self, WhiteList):
        self._WhiteList = WhiteList

    @property
    def PublicControlConsoleWhiteList(self):
        r"""Public network console allowlist.
        :rtype: str
        """
        return self._PublicControlConsoleWhiteList

    @PublicControlConsoleWhiteList.setter
    def PublicControlConsoleWhiteList(self, PublicControlConsoleWhiteList):
        self._PublicControlConsoleWhiteList = PublicControlConsoleWhiteList

    @property
    def PublicDataStreamWhiteList(self):
        r"""Public network data flow allowlist.
        :rtype: str
        """
        return self._PublicDataStreamWhiteList

    @PublicDataStreamWhiteList.setter
    def PublicDataStreamWhiteList(self, PublicDataStreamWhiteList):
        self._PublicDataStreamWhiteList = PublicDataStreamWhiteList

    @property
    def PublicControlConsoleWhiteListStatus(self):
        r"""
        :rtype: str
        """
        return self._PublicControlConsoleWhiteListStatus

    @PublicControlConsoleWhiteListStatus.setter
    def PublicControlConsoleWhiteListStatus(self, PublicControlConsoleWhiteListStatus):
        self._PublicControlConsoleWhiteListStatus = PublicControlConsoleWhiteListStatus

    @property
    def PublicDataStreamWhiteListStatus(self):
        r"""
        :rtype: str
        """
        return self._PublicDataStreamWhiteListStatus

    @PublicDataStreamWhiteListStatus.setter
    def PublicDataStreamWhiteListStatus(self, PublicDataStreamWhiteListStatus):
        self._PublicDataStreamWhiteListStatus = PublicDataStreamWhiteListStatus


    def _deserialize(self, params):
        self._WhiteList = params.get("WhiteList")
        self._PublicControlConsoleWhiteList = params.get("PublicControlConsoleWhiteList")
        self._PublicDataStreamWhiteList = params.get("PublicDataStreamWhiteList")
        self._PublicControlConsoleWhiteListStatus = params.get("PublicControlConsoleWhiteListStatus")
        self._PublicDataStreamWhiteListStatus = params.get("PublicDataStreamWhiteListStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQExchangeListInfo(AbstractModel):
    r"""RabbitMQ exchange list member information

    """

    def __init__(self):
        r"""
        :param _ExchangeName: Exchange name.
        :type ExchangeName: str
        :param _Remark: Remarks

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Remark: str
        :param _ExchangeType: Exchange type. Valid values: "fanout", "direct", "topic", "headers".
        :type ExchangeType: str
        :param _VirtualHost: Specifies the Host name of the Virtual switch.
        :type VirtualHost: str
        :param _ExchangeCreator: Exchange creator. "system": "created by the system"; "user": "created by a user".
        :type ExchangeCreator: str
        :param _CreateTimeStamp: Exchange creation time.
        :type CreateTimeStamp: str
        :param _ModTimeStamp: Exchange modification time.
        :type ModTimeStamp: str
        :param _MessageRateIn: Input message rate.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessageRateIn: float
        :param _MessageRateOut: Indicates the output message rate.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessageRateOut: float
        :param _Durable: Whether the exchange is a durable one. true: durable; false: non-durable.
        :type Durable: bool
        :param _AutoDelete: Whether automatic deletion is set for the exchange. true: automatic deletion set; false: automatic deletion not set.
        :type AutoDelete: bool
        :param _Internal: Whether the exchange is an internal one. true: internal exchange.
        :type Internal: bool
        :param _InstanceId: Instance ID of the exchange.
        :type InstanceId: str
        :param _Policy: Effective policy name.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Policy: str
        :param _Arguments: Extended parameters of the key-value object type.
        :type Arguments: str
        :param _MessagesDelayed: Number of unscheduled delayed messages.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessagesDelayed: int
        :param _CreateTs: Creation time timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification time timestamp.
        :type ModifyTs: int
        """
        self._ExchangeName = None
        self._Remark = None
        self._ExchangeType = None
        self._VirtualHost = None
        self._ExchangeCreator = None
        self._CreateTimeStamp = None
        self._ModTimeStamp = None
        self._MessageRateIn = None
        self._MessageRateOut = None
        self._Durable = None
        self._AutoDelete = None
        self._Internal = None
        self._InstanceId = None
        self._Policy = None
        self._Arguments = None
        self._MessagesDelayed = None
        self._CreateTs = None
        self._ModifyTs = None

    @property
    def ExchangeName(self):
        r"""Exchange name.
        :rtype: str
        """
        return self._ExchangeName

    @ExchangeName.setter
    def ExchangeName(self, ExchangeName):
        self._ExchangeName = ExchangeName

    @property
    def Remark(self):
        r"""Remarks

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ExchangeType(self):
        r"""Exchange type. Valid values: "fanout", "direct", "topic", "headers".
        :rtype: str
        """
        return self._ExchangeType

    @ExchangeType.setter
    def ExchangeType(self, ExchangeType):
        self._ExchangeType = ExchangeType

    @property
    def VirtualHost(self):
        r"""Specifies the Host name of the Virtual switch.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def ExchangeCreator(self):
        r"""Exchange creator. "system": "created by the system"; "user": "created by a user".
        :rtype: str
        """
        return self._ExchangeCreator

    @ExchangeCreator.setter
    def ExchangeCreator(self, ExchangeCreator):
        self._ExchangeCreator = ExchangeCreator

    @property
    def CreateTimeStamp(self):
        r"""Exchange creation time.
        :rtype: str
        """
        return self._CreateTimeStamp

    @CreateTimeStamp.setter
    def CreateTimeStamp(self, CreateTimeStamp):
        self._CreateTimeStamp = CreateTimeStamp

    @property
    def ModTimeStamp(self):
        r"""Exchange modification time.
        :rtype: str
        """
        return self._ModTimeStamp

    @ModTimeStamp.setter
    def ModTimeStamp(self, ModTimeStamp):
        self._ModTimeStamp = ModTimeStamp

    @property
    def MessageRateIn(self):
        r"""Input message rate.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MessageRateIn

    @MessageRateIn.setter
    def MessageRateIn(self, MessageRateIn):
        self._MessageRateIn = MessageRateIn

    @property
    def MessageRateOut(self):
        r"""Indicates the output message rate.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MessageRateOut

    @MessageRateOut.setter
    def MessageRateOut(self, MessageRateOut):
        self._MessageRateOut = MessageRateOut

    @property
    def Durable(self):
        r"""Whether the exchange is a durable one. true: durable; false: non-durable.
        :rtype: bool
        """
        return self._Durable

    @Durable.setter
    def Durable(self, Durable):
        self._Durable = Durable

    @property
    def AutoDelete(self):
        r"""Whether automatic deletion is set for the exchange. true: automatic deletion set; false: automatic deletion not set.
        :rtype: bool
        """
        return self._AutoDelete

    @AutoDelete.setter
    def AutoDelete(self, AutoDelete):
        self._AutoDelete = AutoDelete

    @property
    def Internal(self):
        r"""Whether the exchange is an internal one. true: internal exchange.
        :rtype: bool
        """
        return self._Internal

    @Internal.setter
    def Internal(self, Internal):
        self._Internal = Internal

    @property
    def InstanceId(self):
        r"""Instance ID of the exchange.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Policy(self):
        r"""Effective policy name.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def Arguments(self):
        r"""Extended parameters of the key-value object type.
        :rtype: str
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def MessagesDelayed(self):
        r"""Number of unscheduled delayed messages.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MessagesDelayed

    @MessagesDelayed.setter
    def MessagesDelayed(self, MessagesDelayed):
        self._MessagesDelayed = MessagesDelayed

    @property
    def CreateTs(self):
        r"""Creation time timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification time timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs


    def _deserialize(self, params):
        self._ExchangeName = params.get("ExchangeName")
        self._Remark = params.get("Remark")
        self._ExchangeType = params.get("ExchangeType")
        self._VirtualHost = params.get("VirtualHost")
        self._ExchangeCreator = params.get("ExchangeCreator")
        self._CreateTimeStamp = params.get("CreateTimeStamp")
        self._ModTimeStamp = params.get("ModTimeStamp")
        self._MessageRateIn = params.get("MessageRateIn")
        self._MessageRateOut = params.get("MessageRateOut")
        self._Durable = params.get("Durable")
        self._AutoDelete = params.get("AutoDelete")
        self._Internal = params.get("Internal")
        self._InstanceId = params.get("InstanceId")
        self._Policy = params.get("Policy")
        self._Arguments = params.get("Arguments")
        self._MessagesDelayed = params.get("MessagesDelayed")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQPermission(AbstractModel):
    r"""RabbitMQ permission details

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :type User: str
        :param _VirtualHost: VirtualHost name, such as testvhost. valid VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :type VirtualHost: str
        :param _ConfigRegexp: Type of permissions related to declare operations. This regular expression controls resource creation and deletion permissions of users in this vhost.
        :type ConfigRegexp: str
        :param _WriteRegexp: Type of permissions related to message write operations. This regular expression controls resource creation and deletion permissions of users in this vhost.
        :type WriteRegexp: str
        :param _ReadRegexp: Type of permissions related to message read operations. This regular expression controls resource creation and deletion permissions of users in this vhost.
        :type ReadRegexp: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _ModifyTime: Modification time.
        :type ModifyTime: str
        :param _CreateTs: Creation timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification timestamp.
        :type ModifyTs: int
        """
        self._InstanceId = None
        self._User = None
        self._VirtualHost = None
        self._ConfigRegexp = None
        self._WriteRegexp = None
        self._ReadRegexp = None
        self._CreateTime = None
        self._ModifyTime = None
        self._CreateTs = None
        self._ModifyTs = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, such as admin. effective User names can be found by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking a cluster in the cluster list, entering cluster details, and locating the list of users under the User and permission management tab, thereby finding the username.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def VirtualHost(self):
        r"""VirtualHost name, such as testvhost. valid VirtualHost names can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1), clicking Vhost in the left sidebar, and finding the Vhost name in the Vhost list.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def ConfigRegexp(self):
        r"""Type of permissions related to declare operations. This regular expression controls resource creation and deletion permissions of users in this vhost.
        :rtype: str
        """
        return self._ConfigRegexp

    @ConfigRegexp.setter
    def ConfigRegexp(self, ConfigRegexp):
        self._ConfigRegexp = ConfigRegexp

    @property
    def WriteRegexp(self):
        r"""Type of permissions related to message write operations. This regular expression controls resource creation and deletion permissions of users in this vhost.
        :rtype: str
        """
        return self._WriteRegexp

    @WriteRegexp.setter
    def WriteRegexp(self, WriteRegexp):
        self._WriteRegexp = WriteRegexp

    @property
    def ReadRegexp(self):
        r"""Type of permissions related to message read operations. This regular expression controls resource creation and deletion permissions of users in this vhost.
        :rtype: str
        """
        return self._ReadRegexp

    @ReadRegexp.setter
    def ReadRegexp(self, ReadRegexp):
        self._ReadRegexp = ReadRegexp

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        r"""Modification time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTs(self):
        r"""Creation timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._VirtualHost = params.get("VirtualHost")
        self._ConfigRegexp = params.get("ConfigRegexp")
        self._WriteRegexp = params.get("WriteRegexp")
        self._ReadRegexp = params.get("ReadRegexp")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQPrivateNode(AbstractModel):
    r"""RabbitMQ node information.

    """

    def __init__(self):
        r"""
        :param _NodeName: Node name
Note: This field may return null, indicating that no valid value can be obtained.
        :type NodeName: str
        :param _NodeStatus: Node status. running indicates the node is active. down indicates an exception.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeStatus: str
        :param _CPUUsage: CPU utilization
Note: This field may return null, indicating that no valid values can be obtained.
        :type CPUUsage: str
        :param _Memory: Memory usage in MB
Note: This field may return null, indicating that no valid values can be obtained.
        :type Memory: int
        :param _DiskUsage: Disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
        :type DiskUsage: str
        :param _ProcessNumber: The number of RabbitMQ Erlang processes
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessNumber: int
        """
        self._NodeName = None
        self._NodeStatus = None
        self._CPUUsage = None
        self._Memory = None
        self._DiskUsage = None
        self._ProcessNumber = None

    @property
    def NodeName(self):
        r"""Node name
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeStatus(self):
        r"""Node status. running indicates the node is active. down indicates an exception.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NodeStatus

    @NodeStatus.setter
    def NodeStatus(self, NodeStatus):
        self._NodeStatus = NodeStatus

    @property
    def CPUUsage(self):
        r"""CPU utilization
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CPUUsage

    @CPUUsage.setter
    def CPUUsage(self, CPUUsage):
        self._CPUUsage = CPUUsage

    @property
    def Memory(self):
        r"""Memory usage in MB
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def DiskUsage(self):
        r"""Disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DiskUsage

    @DiskUsage.setter
    def DiskUsage(self, DiskUsage):
        self._DiskUsage = DiskUsage

    @property
    def ProcessNumber(self):
        r"""The number of RabbitMQ Erlang processes
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ProcessNumber

    @ProcessNumber.setter
    def ProcessNumber(self, ProcessNumber):
        self._ProcessNumber = ProcessNumber


    def _deserialize(self, params):
        self._NodeName = params.get("NodeName")
        self._NodeStatus = params.get("NodeStatus")
        self._CPUUsage = params.get("CPUUsage")
        self._Memory = params.get("Memory")
        self._DiskUsage = params.get("DiskUsage")
        self._ProcessNumber = params.get("ProcessNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQQueueListConsumerDetailInfo(AbstractModel):
    r"""RabbitMQ queue list consumer info

    """

    def __init__(self):
        r"""
        :param _ConsumersNumber: Consumer count.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type ConsumersNumber: int
        """
        self._ConsumersNumber = None

    @property
    def ConsumersNumber(self):
        r"""Consumer count.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ConsumersNumber

    @ConsumersNumber.setter
    def ConsumersNumber(self, ConsumersNumber):
        self._ConsumersNumber = ConsumersNumber


    def _deserialize(self, params):
        self._ConsumersNumber = params.get("ConsumersNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQQueueListInfo(AbstractModel):
    r"""RabbitMQ queue list member information.

    """

    def __init__(self):
        r"""
        :param _QueueName: Queue name
        :type QueueName: str
        :param _Remark: Remarks

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Remark: str
        :param _ConsumerDetail: Consumer information.
        :type ConsumerDetail: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQQueueListConsumerDetailInfo`
        :param _QueueType: Queue type. Valid values: "classic" and "quorum".
        :type QueueType: str
        :param _MessageHeapCount: Number of retained messages

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessageHeapCount: int
        :param _MessageRateIn: Message production rate per second.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessageRateIn: float
        :param _MessageRateOut: Message consumption rate per second.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type MessageRateOut: float
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _ModifyTime: Modification time.
        :type ModifyTime: str
        :param _Durable: Whether the queue is durable. true: durable; false: non-durable.
        :type Durable: bool
        :param _AutoDelete: Whether automatic deletion is set for the queue. true: automatic deletion set; false: automatic deletion not set.
        :type AutoDelete: bool
        :param _InstanceId: Instance ID of the queue.
        :type InstanceId: str
        :param _VirtualHost: Vhost name of the queue.
        :type VirtualHost: str
        :param _Node: Primary node name of the queue.
        :type Node: str
        :param _Policy: Indicates the name of the effective policy.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Policy: str
        :param _Arguments: Extended parameters of the key-value object type.
        :type Arguments: str
        :param _Exclusive: Whether the queue is exclusive.
        :type Exclusive: bool
        :param _CreateTs: Creation time timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification time timestamp.
        :type ModifyTs: int
        """
        self._QueueName = None
        self._Remark = None
        self._ConsumerDetail = None
        self._QueueType = None
        self._MessageHeapCount = None
        self._MessageRateIn = None
        self._MessageRateOut = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Durable = None
        self._AutoDelete = None
        self._InstanceId = None
        self._VirtualHost = None
        self._Node = None
        self._Policy = None
        self._Arguments = None
        self._Exclusive = None
        self._CreateTs = None
        self._ModifyTs = None

    @property
    def QueueName(self):
        r"""Queue name
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def Remark(self):
        r"""Remarks

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ConsumerDetail(self):
        r"""Consumer information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQQueueListConsumerDetailInfo`
        """
        return self._ConsumerDetail

    @ConsumerDetail.setter
    def ConsumerDetail(self, ConsumerDetail):
        self._ConsumerDetail = ConsumerDetail

    @property
    def QueueType(self):
        r"""Queue type. Valid values: "classic" and "quorum".
        :rtype: str
        """
        return self._QueueType

    @QueueType.setter
    def QueueType(self, QueueType):
        self._QueueType = QueueType

    @property
    def MessageHeapCount(self):
        r"""Number of retained messages

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MessageHeapCount

    @MessageHeapCount.setter
    def MessageHeapCount(self, MessageHeapCount):
        self._MessageHeapCount = MessageHeapCount

    @property
    def MessageRateIn(self):
        r"""Message production rate per second.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MessageRateIn

    @MessageRateIn.setter
    def MessageRateIn(self, MessageRateIn):
        self._MessageRateIn = MessageRateIn

    @property
    def MessageRateOut(self):
        r"""Message consumption rate per second.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._MessageRateOut

    @MessageRateOut.setter
    def MessageRateOut(self, MessageRateOut):
        self._MessageRateOut = MessageRateOut

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        r"""Modification time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Durable(self):
        r"""Whether the queue is durable. true: durable; false: non-durable.
        :rtype: bool
        """
        return self._Durable

    @Durable.setter
    def Durable(self, Durable):
        self._Durable = Durable

    @property
    def AutoDelete(self):
        r"""Whether automatic deletion is set for the queue. true: automatic deletion set; false: automatic deletion not set.
        :rtype: bool
        """
        return self._AutoDelete

    @AutoDelete.setter
    def AutoDelete(self, AutoDelete):
        self._AutoDelete = AutoDelete

    @property
    def InstanceId(self):
        r"""Instance ID of the queue.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost name of the queue.
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Node(self):
        r"""Primary node name of the queue.
        :rtype: str
        """
        return self._Node

    @Node.setter
    def Node(self, Node):
        self._Node = Node

    @property
    def Policy(self):
        r"""Indicates the name of the effective policy.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def Arguments(self):
        r"""Extended parameters of the key-value object type.
        :rtype: str
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def Exclusive(self):
        r"""Whether the queue is exclusive.
        :rtype: bool
        """
        return self._Exclusive

    @Exclusive.setter
    def Exclusive(self, Exclusive):
        self._Exclusive = Exclusive

    @property
    def CreateTs(self):
        r"""Creation time timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification time timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        self._Remark = params.get("Remark")
        if params.get("ConsumerDetail") is not None:
            self._ConsumerDetail = RabbitMQQueueListConsumerDetailInfo()
            self._ConsumerDetail._deserialize(params.get("ConsumerDetail"))
        self._QueueType = params.get("QueueType")
        self._MessageHeapCount = params.get("MessageHeapCount")
        self._MessageRateIn = params.get("MessageRateIn")
        self._MessageRateOut = params.get("MessageRateOut")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Durable = params.get("Durable")
        self._AutoDelete = params.get("AutoDelete")
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Node = params.get("Node")
        self._Policy = params.get("Policy")
        self._Arguments = params.get("Arguments")
        self._Exclusive = params.get("Exclusive")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQUser(AbstractModel):
    r"""TDMQ for RabbitMQ user entity details

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :type InstanceId: str
        :param _User: Username, which is used for login.
        :type User: str
        :param _Password: Password, which is used for login.
        :type Password: str
        :param _Description: User description
        :type Description: str
        :param _Tags: User tags, which determine the scope of permissions of this user to access RabbitMQ Management.
        :type Tags: list of str
        :param _CreateTime: User creation time
        :type CreateTime: str
        :param _ModifyTime: Last user modification time
        :type ModifyTime: str
        :param _Type: User type. Valid values: `System` (Created by system), `User` (Created by user).
        :type Type: str
        :param _MaxConnections: Maximum number of available connections per user.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxConnections: int
        :param _MaxChannels: Maximum number of available channels per user.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxChannels: int
        :param _CreateTs: Creation timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification timestamp.
        :type ModifyTs: int
        """
        self._InstanceId = None
        self._User = None
        self._Password = None
        self._Description = None
        self._Tags = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Type = None
        self._MaxConnections = None
        self._MaxChannels = None
        self._CreateTs = None
        self._ModifyTs = None

    @property
    def InstanceId(self):
        r"""Instance ID, such as amqp-xxxxxxxx. effective InstanceId can be queried by logging in to the TDMQ RabbitMQ console (https://console.cloud.tencent.com/trabbitmq/cluster?rid=1).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def User(self):
        r"""Username, which is used for login.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Password(self):
        r"""Password, which is used for login.
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Description(self):
        r"""User description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        r"""User tags, which determine the scope of permissions of this user to access RabbitMQ Management.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CreateTime(self):
        r"""User creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        r"""Last user modification time
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Type(self):
        r"""User type. Valid values: `System` (Created by system), `User` (Created by user).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def MaxConnections(self):
        r"""Maximum number of available connections per user.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxConnections

    @MaxConnections.setter
    def MaxConnections(self, MaxConnections):
        self._MaxConnections = MaxConnections

    @property
    def MaxChannels(self):
        r"""Maximum number of available channels per user.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxChannels

    @MaxChannels.setter
    def MaxChannels(self, MaxChannels):
        self._MaxChannels = MaxChannels

    @property
    def CreateTs(self):
        r"""Creation timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._User = params.get("User")
        self._Password = params.get("Password")
        self._Description = params.get("Description")
        self._Tags = params.get("Tags")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Type = params.get("Type")
        self._MaxConnections = params.get("MaxConnections")
        self._MaxChannels = params.get("MaxChannels")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQUserQuota(AbstractModel):
    r"""RabbitMQ instance user quota information.

    """

    def __init__(self):
        r"""
        :param _MaxUser: Maximum creation number of users.
        :type MaxUser: int
        :param _UsedUser: Indicates the number of users in use.
        :type UsedUser: int
        """
        self._MaxUser = None
        self._UsedUser = None

    @property
    def MaxUser(self):
        r"""Maximum creation number of users.
        :rtype: int
        """
        return self._MaxUser

    @MaxUser.setter
    def MaxUser(self, MaxUser):
        self._MaxUser = MaxUser

    @property
    def UsedUser(self):
        r"""Indicates the number of users in use.
        :rtype: int
        """
        return self._UsedUser

    @UsedUser.setter
    def UsedUser(self, UsedUser):
        self._UsedUser = UsedUser


    def _deserialize(self, params):
        self._MaxUser = params.get("MaxUser")
        self._UsedUser = params.get("UsedUser")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQVipInstance(AbstractModel):
    r"""RabbitMQ managed instance information.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _InstanceVersion: Instance version.
        :type InstanceVersion: str
        :param _Status: Instance status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated), `3` (Terminated), `4` (Abnormal), `5` (Delivery failed).
        :type Status: int
        :param _NodeCount: Number of nodes
        :type NodeCount: int
        :param _ConfigDisplay: Instance specification name
        :type ConfigDisplay: str
        :param _MaxTps: Peak TPS
        :type MaxTps: int
        :param _MaxBandWidth: Peak bandwidth in Mbps
        :type MaxBandWidth: int
        :param _MaxStorage: Storage capacity in GB
        :type MaxStorage: int
        :param _ExpireTime: Specifies the instance expiration time in milliseconds as a unix timestamp. the value is 0 for pay-as-you-go resources.
        :type ExpireTime: int
        :param _AutoRenewFlag: Renewal mode. Valid values: `0` (Manual renewal, which is the default mode), `1` (Auto-renewal), `2` (Manual renewal, which is specified by users).
        :type AutoRenewFlag: int
        :param _PayMode: 1 indicates prepaid mode, 0 indicates postpaid.
        :type PayMode: int
        :param _Remark: Remarks
        :type Remark: str
        :param _SpecName: Node specification of the cluster. specifies the corresponding flag.
2C8G:rabbit-vip-profession-2c8g
4C16G:rabbit-vip-profession-4c16g
8C32G:rabbit-vip-profession-8c32g
16C32G:rabbit-vip-basic-4
16C64G:rabbit-vip-profession-16c64g
2C4G:rabbit-vip-basic-5
4C8G:rabbit-vip-basic-1
8C16G (sold out): rabbit-vip-basic-2.
Specifies the default value as 4C8G: rabbit-vip-basic-1.
        :type SpecName: str
        :param _ExceptionInformation: Cluster exception information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptionInformation: str
        :param _ClusterStatus: Instance status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated), `3` (Terminated), `4` (Abnormal), `5` (Delivery failed).
This parameter is used to display the instance status additionally and distinguish from the `Status` parameter.
        :type ClusterStatus: int
        :param _PublicAccessEndpoint: Public network access point.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublicAccessEndpoint: str
        :param _Vpcs: VPC access point list.
        :type Vpcs: list of VpcEndpointInfo
        :param _CreateTime: Creation time in milliseconds. unix timestamp.
        :type CreateTime: int
        :param _InstanceType: Instance type. valid values: 0 (managed), 1 (Serverless).
        :type InstanceType: int
        :param _IsolatedTime: Isolation time, in milliseconds. unix timestamp.
        :type IsolatedTime: int
        :param _EnableDeletionProtection: Whether deletion protection is enabled.
        :type EnableDeletionProtection: bool
        :param _Tags: Tag list
        :type Tags: list of Tag
        """
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceVersion = None
        self._Status = None
        self._NodeCount = None
        self._ConfigDisplay = None
        self._MaxTps = None
        self._MaxBandWidth = None
        self._MaxStorage = None
        self._ExpireTime = None
        self._AutoRenewFlag = None
        self._PayMode = None
        self._Remark = None
        self._SpecName = None
        self._ExceptionInformation = None
        self._ClusterStatus = None
        self._PublicAccessEndpoint = None
        self._Vpcs = None
        self._CreateTime = None
        self._InstanceType = None
        self._IsolatedTime = None
        self._EnableDeletionProtection = None
        self._Tags = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceVersion(self):
        r"""Instance version.
        :rtype: str
        """
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion

    @property
    def Status(self):
        r"""Instance status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated), `3` (Terminated), `4` (Abnormal), `5` (Delivery failed).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def NodeCount(self):
        r"""Number of nodes
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def ConfigDisplay(self):
        r"""Instance specification name
        :rtype: str
        """
        return self._ConfigDisplay

    @ConfigDisplay.setter
    def ConfigDisplay(self, ConfigDisplay):
        self._ConfigDisplay = ConfigDisplay

    @property
    def MaxTps(self):
        r"""Peak TPS
        :rtype: int
        """
        return self._MaxTps

    @MaxTps.setter
    def MaxTps(self, MaxTps):
        self._MaxTps = MaxTps

    @property
    def MaxBandWidth(self):
        r"""Peak bandwidth in Mbps
        :rtype: int
        """
        return self._MaxBandWidth

    @MaxBandWidth.setter
    def MaxBandWidth(self, MaxBandWidth):
        self._MaxBandWidth = MaxBandWidth

    @property
    def MaxStorage(self):
        r"""Storage capacity in GB
        :rtype: int
        """
        return self._MaxStorage

    @MaxStorage.setter
    def MaxStorage(self, MaxStorage):
        self._MaxStorage = MaxStorage

    @property
    def ExpireTime(self):
        r"""Specifies the instance expiration time in milliseconds as a unix timestamp. the value is 0 for pay-as-you-go resources.
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def AutoRenewFlag(self):
        r"""Renewal mode. Valid values: `0` (Manual renewal, which is the default mode), `1` (Auto-renewal), `2` (Manual renewal, which is specified by users).
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def PayMode(self):
        r"""1 indicates prepaid mode, 0 indicates postpaid.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SpecName(self):
        r"""Node specification of the cluster. specifies the corresponding flag.
2C8G:rabbit-vip-profession-2c8g
4C16G:rabbit-vip-profession-4c16g
8C32G:rabbit-vip-profession-8c32g
16C32G:rabbit-vip-basic-4
16C64G:rabbit-vip-profession-16c64g
2C4G:rabbit-vip-basic-5
4C8G:rabbit-vip-basic-1
8C16G (sold out): rabbit-vip-basic-2.
Specifies the default value as 4C8G: rabbit-vip-basic-1.
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def ExceptionInformation(self):
        r"""Cluster exception information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExceptionInformation

    @ExceptionInformation.setter
    def ExceptionInformation(self, ExceptionInformation):
        self._ExceptionInformation = ExceptionInformation

    @property
    def ClusterStatus(self):
        r"""Instance status. Valid values: `0` (Creating), `1` (Normal), `2` (Isolated), `3` (Terminated), `4` (Abnormal), `5` (Delivery failed).
This parameter is used to display the instance status additionally and distinguish from the `Status` parameter.
        :rtype: int
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def PublicAccessEndpoint(self):
        r"""Public network access point.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PublicAccessEndpoint

    @PublicAccessEndpoint.setter
    def PublicAccessEndpoint(self, PublicAccessEndpoint):
        self._PublicAccessEndpoint = PublicAccessEndpoint

    @property
    def Vpcs(self):
        r"""VPC access point list.
        :rtype: list of VpcEndpointInfo
        """
        return self._Vpcs

    @Vpcs.setter
    def Vpcs(self, Vpcs):
        self._Vpcs = Vpcs

    @property
    def CreateTime(self):
        r"""Creation time in milliseconds. unix timestamp.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def InstanceType(self):
        r"""Instance type. valid values: 0 (managed), 1 (Serverless).
        :rtype: int
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def IsolatedTime(self):
        r"""Isolation time, in milliseconds. unix timestamp.
        :rtype: int
        """
        return self._IsolatedTime

    @IsolatedTime.setter
    def IsolatedTime(self, IsolatedTime):
        self._IsolatedTime = IsolatedTime

    @property
    def EnableDeletionProtection(self):
        r"""Whether deletion protection is enabled.
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection

    @property
    def Tags(self):
        r"""Tag list
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceVersion = params.get("InstanceVersion")
        self._Status = params.get("Status")
        self._NodeCount = params.get("NodeCount")
        self._ConfigDisplay = params.get("ConfigDisplay")
        self._MaxTps = params.get("MaxTps")
        self._MaxBandWidth = params.get("MaxBandWidth")
        self._MaxStorage = params.get("MaxStorage")
        self._ExpireTime = params.get("ExpireTime")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._PayMode = params.get("PayMode")
        self._Remark = params.get("Remark")
        self._SpecName = params.get("SpecName")
        self._ExceptionInformation = params.get("ExceptionInformation")
        self._ClusterStatus = params.get("ClusterStatus")
        self._PublicAccessEndpoint = params.get("PublicAccessEndpoint")
        if params.get("Vpcs") is not None:
            self._Vpcs = []
            for item in params.get("Vpcs"):
                obj = VpcEndpointInfo()
                obj._deserialize(item)
                self._Vpcs.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._InstanceType = params.get("InstanceType")
        self._IsolatedTime = params.get("IsolatedTime")
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQVirtualHostInfo(AbstractModel):
    r"""TDMQ for RabbitMQ vhost details

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID
        :type InstanceId: str
        :param _VirtualHost: Vhost name
        :type VirtualHost: str
        :param _Description: Vhost description information.
        :type Description: str
        :param _Tags: Vhost tags.
        :type Tags: list of str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _ModifyTime: Modification time.
        :type ModifyTime: str
        :param _VirtualHostStatistics: Vhost overview statistics information.
        :type VirtualHostStatistics: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQVirtualHostStatistics`
        :param _TraceFlag: Message trace enabling status. true: enabled; false: disabled.
        :type TraceFlag: bool
        :param _Status: Vhost status, which corresponds to status in the native product console. Valid values: running, partial, stopped, and unknown.
        :type Status: str
        :param _MessageHeapCount: Message backlog count.
        :type MessageHeapCount: int
        :param _MessageRateIn: Message input rate.
        :type MessageRateIn: float
        :param _MessageRateOut: Message output rate.
        :type MessageRateOut: float
        :param _MirrorQueuePolicyFlag: Whether an image queue policy exists. true: Exists; false: Does not exist.
        :type MirrorQueuePolicyFlag: bool
        :param _CreateTs: Creation timestamp.
        :type CreateTs: int
        :param _ModifyTs: Modification timestamp.
        :type ModifyTs: int
        """
        self._InstanceId = None
        self._VirtualHost = None
        self._Description = None
        self._Tags = None
        self._CreateTime = None
        self._ModifyTime = None
        self._VirtualHostStatistics = None
        self._TraceFlag = None
        self._Status = None
        self._MessageHeapCount = None
        self._MessageRateIn = None
        self._MessageRateOut = None
        self._MirrorQueuePolicyFlag = None
        self._CreateTs = None
        self._ModifyTs = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VirtualHost(self):
        r"""Vhost name
        :rtype: str
        """
        return self._VirtualHost

    @VirtualHost.setter
    def VirtualHost(self, VirtualHost):
        self._VirtualHost = VirtualHost

    @property
    def Description(self):
        r"""Vhost description information.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        r"""Vhost tags.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        r"""Modification time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def VirtualHostStatistics(self):
        r"""Vhost overview statistics information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RabbitMQVirtualHostStatistics`
        """
        return self._VirtualHostStatistics

    @VirtualHostStatistics.setter
    def VirtualHostStatistics(self, VirtualHostStatistics):
        self._VirtualHostStatistics = VirtualHostStatistics

    @property
    def TraceFlag(self):
        r"""Message trace enabling status. true: enabled; false: disabled.
        :rtype: bool
        """
        return self._TraceFlag

    @TraceFlag.setter
    def TraceFlag(self, TraceFlag):
        self._TraceFlag = TraceFlag

    @property
    def Status(self):
        r"""Vhost status, which corresponds to status in the native product console. Valid values: running, partial, stopped, and unknown.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MessageHeapCount(self):
        r"""Message backlog count.
        :rtype: int
        """
        return self._MessageHeapCount

    @MessageHeapCount.setter
    def MessageHeapCount(self, MessageHeapCount):
        self._MessageHeapCount = MessageHeapCount

    @property
    def MessageRateIn(self):
        r"""Message input rate.
        :rtype: float
        """
        return self._MessageRateIn

    @MessageRateIn.setter
    def MessageRateIn(self, MessageRateIn):
        self._MessageRateIn = MessageRateIn

    @property
    def MessageRateOut(self):
        r"""Message output rate.
        :rtype: float
        """
        return self._MessageRateOut

    @MessageRateOut.setter
    def MessageRateOut(self, MessageRateOut):
        self._MessageRateOut = MessageRateOut

    @property
    def MirrorQueuePolicyFlag(self):
        r"""Whether an image queue policy exists. true: Exists; false: Does not exist.
        :rtype: bool
        """
        return self._MirrorQueuePolicyFlag

    @MirrorQueuePolicyFlag.setter
    def MirrorQueuePolicyFlag(self, MirrorQueuePolicyFlag):
        self._MirrorQueuePolicyFlag = MirrorQueuePolicyFlag

    @property
    def CreateTs(self):
        r"""Creation timestamp.
        :rtype: int
        """
        return self._CreateTs

    @CreateTs.setter
    def CreateTs(self, CreateTs):
        self._CreateTs = CreateTs

    @property
    def ModifyTs(self):
        r"""Modification timestamp.
        :rtype: int
        """
        return self._ModifyTs

    @ModifyTs.setter
    def ModifyTs(self, ModifyTs):
        self._ModifyTs = ModifyTs


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._VirtualHost = params.get("VirtualHost")
        self._Description = params.get("Description")
        self._Tags = params.get("Tags")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        if params.get("VirtualHostStatistics") is not None:
            self._VirtualHostStatistics = RabbitMQVirtualHostStatistics()
            self._VirtualHostStatistics._deserialize(params.get("VirtualHostStatistics"))
        self._TraceFlag = params.get("TraceFlag")
        self._Status = params.get("Status")
        self._MessageHeapCount = params.get("MessageHeapCount")
        self._MessageRateIn = params.get("MessageRateIn")
        self._MessageRateOut = params.get("MessageRateOut")
        self._MirrorQueuePolicyFlag = params.get("MirrorQueuePolicyFlag")
        self._CreateTs = params.get("CreateTs")
        self._ModifyTs = params.get("ModifyTs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RabbitMQVirtualHostStatistics(AbstractModel):
    r"""Statistics of vhost overview

    """

    def __init__(self):
        r"""
        :param _CurrentQueues: The number of queues in the current vhost
        :type CurrentQueues: int
        :param _CurrentExchanges: The number of exchanges in the current vhost
        :type CurrentExchanges: int
        :param _CurrentConnections: The number of connections in the current vhost
        :type CurrentConnections: int
        :param _CurrentChannels: The number of channels in the current vhost
        :type CurrentChannels: int
        :param _CurrentUsers: The number of users in the current vhost
        :type CurrentUsers: int
        """
        self._CurrentQueues = None
        self._CurrentExchanges = None
        self._CurrentConnections = None
        self._CurrentChannels = None
        self._CurrentUsers = None

    @property
    def CurrentQueues(self):
        r"""The number of queues in the current vhost
        :rtype: int
        """
        return self._CurrentQueues

    @CurrentQueues.setter
    def CurrentQueues(self, CurrentQueues):
        self._CurrentQueues = CurrentQueues

    @property
    def CurrentExchanges(self):
        r"""The number of exchanges in the current vhost
        :rtype: int
        """
        return self._CurrentExchanges

    @CurrentExchanges.setter
    def CurrentExchanges(self, CurrentExchanges):
        self._CurrentExchanges = CurrentExchanges

    @property
    def CurrentConnections(self):
        r"""The number of connections in the current vhost
        :rtype: int
        """
        return self._CurrentConnections

    @CurrentConnections.setter
    def CurrentConnections(self, CurrentConnections):
        self._CurrentConnections = CurrentConnections

    @property
    def CurrentChannels(self):
        r"""The number of channels in the current vhost
        :rtype: int
        """
        return self._CurrentChannels

    @CurrentChannels.setter
    def CurrentChannels(self, CurrentChannels):
        self._CurrentChannels = CurrentChannels

    @property
    def CurrentUsers(self):
        r"""The number of users in the current vhost
        :rtype: int
        """
        return self._CurrentUsers

    @CurrentUsers.setter
    def CurrentUsers(self, CurrentUsers):
        self._CurrentUsers = CurrentUsers


    def _deserialize(self, params):
        self._CurrentQueues = params.get("CurrentQueues")
        self._CurrentExchanges = params.get("CurrentExchanges")
        self._CurrentConnections = params.get("CurrentConnections")
        self._CurrentChannels = params.get("CurrentChannels")
        self._CurrentUsers = params.get("CurrentUsers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReceiveMessageRequest(AbstractModel):
    r"""ReceiveMessage request structure.

    """

    def __init__(self):
        r"""
        :param _Topic: Name of the topic which receives the message. It is better to be the full path of the topic, such as `tenant/namespace/topic`. If it is not specified, `public/default` will be used by default.
        :type Topic: str
        :param _SubscriptionName: Subscriber name
        :type SubscriptionName: str
        :param _ReceiverQueueSize: Default value: 1000. Messages received by the consumer will first be stored in the `receiverQueueSize` queue to tune the message receiving rate.
        :type ReceiverQueueSize: int
        :param _SubInitialPosition: A parameter used to determine the position where the consumer initially receives messages. Valid values: `Earliest` (default), `Latest`.
        :type SubInitialPosition: str
        :param _MaxNumMessages: This parameter is used to specify the maximum number of received messages in a batch for `BatchReceivePolicy`. The default value is 0, indicating that `BatchReceivePolicy` is disabled.
        :type MaxNumMessages: int
        :param _MaxNumBytes: This parameter is used to specify the maximum body size (in bytes) of received messages in a batch for `BatchReceivePolicy`. The default value is 0, indicating that `BatchReceivePolicy` is disabled.
        :type MaxNumBytes: int
        :param _Timeout: This parameter is used to specify the maximum wait timeout (in milliseconds) for receiving a batch of messages for `BatchReceivePolicy`. The default value is 0, indicating that `BatchReceivePolicy` is disabled.
        :type Timeout: int
        """
        self._Topic = None
        self._SubscriptionName = None
        self._ReceiverQueueSize = None
        self._SubInitialPosition = None
        self._MaxNumMessages = None
        self._MaxNumBytes = None
        self._Timeout = None

    @property
    def Topic(self):
        r"""Name of the topic which receives the message. It is better to be the full path of the topic, such as `tenant/namespace/topic`. If it is not specified, `public/default` will be used by default.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def SubscriptionName(self):
        r"""Subscriber name
        :rtype: str
        """
        return self._SubscriptionName

    @SubscriptionName.setter
    def SubscriptionName(self, SubscriptionName):
        self._SubscriptionName = SubscriptionName

    @property
    def ReceiverQueueSize(self):
        r"""Default value: 1000. Messages received by the consumer will first be stored in the `receiverQueueSize` queue to tune the message receiving rate.
        :rtype: int
        """
        return self._ReceiverQueueSize

    @ReceiverQueueSize.setter
    def ReceiverQueueSize(self, ReceiverQueueSize):
        self._ReceiverQueueSize = ReceiverQueueSize

    @property
    def SubInitialPosition(self):
        r"""A parameter used to determine the position where the consumer initially receives messages. Valid values: `Earliest` (default), `Latest`.
        :rtype: str
        """
        return self._SubInitialPosition

    @SubInitialPosition.setter
    def SubInitialPosition(self, SubInitialPosition):
        self._SubInitialPosition = SubInitialPosition

    @property
    def MaxNumMessages(self):
        r"""This parameter is used to specify the maximum number of received messages in a batch for `BatchReceivePolicy`. The default value is 0, indicating that `BatchReceivePolicy` is disabled.
        :rtype: int
        """
        return self._MaxNumMessages

    @MaxNumMessages.setter
    def MaxNumMessages(self, MaxNumMessages):
        self._MaxNumMessages = MaxNumMessages

    @property
    def MaxNumBytes(self):
        r"""This parameter is used to specify the maximum body size (in bytes) of received messages in a batch for `BatchReceivePolicy`. The default value is 0, indicating that `BatchReceivePolicy` is disabled.
        :rtype: int
        """
        return self._MaxNumBytes

    @MaxNumBytes.setter
    def MaxNumBytes(self, MaxNumBytes):
        self._MaxNumBytes = MaxNumBytes

    @property
    def Timeout(self):
        r"""This parameter is used to specify the maximum wait timeout (in milliseconds) for receiving a batch of messages for `BatchReceivePolicy`. The default value is 0, indicating that `BatchReceivePolicy` is disabled.
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout


    def _deserialize(self, params):
        self._Topic = params.get("Topic")
        self._SubscriptionName = params.get("SubscriptionName")
        self._ReceiverQueueSize = params.get("ReceiverQueueSize")
        self._SubInitialPosition = params.get("SubInitialPosition")
        self._MaxNumMessages = params.get("MaxNumMessages")
        self._MaxNumBytes = params.get("MaxNumBytes")
        self._Timeout = params.get("Timeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReceiveMessageResponse(AbstractModel):
    r"""ReceiveMessage response structure.

    """

    def __init__(self):
        r"""
        :param _MessageID: Unique primary key used to identify the message
        :type MessageID: str
        :param _MessagePayload: Content of the received message
        :type MessagePayload: str
        :param _AckTopic: Provided to the `Ack` API and used to acknowledge messages in the topic
        :type AckTopic: str
        :param _ErrorMsg: Returned error message. If it is null, it means there is no error.
        :type ErrorMsg: str
        :param _SubName: Returned subscriber names, used for creating Ack consumers
        :type SubName: str
        :param _MessageIDList: BatchReceivePolicy specifies the messageids of multiple messages returned at one time, using '###' to distinguish different messageids.
        :type MessageIDList: str
        :param _MessagesPayload: BatchReceivePolicy specifies the message content of multiple messages returned at one time, using '###' to distinguish different message content.
        :type MessagesPayload: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MessageID = None
        self._MessagePayload = None
        self._AckTopic = None
        self._ErrorMsg = None
        self._SubName = None
        self._MessageIDList = None
        self._MessagesPayload = None
        self._RequestId = None

    @property
    def MessageID(self):
        r"""Unique primary key used to identify the message
        :rtype: str
        """
        return self._MessageID

    @MessageID.setter
    def MessageID(self, MessageID):
        self._MessageID = MessageID

    @property
    def MessagePayload(self):
        r"""Content of the received message
        :rtype: str
        """
        return self._MessagePayload

    @MessagePayload.setter
    def MessagePayload(self, MessagePayload):
        self._MessagePayload = MessagePayload

    @property
    def AckTopic(self):
        r"""Provided to the `Ack` API and used to acknowledge messages in the topic
        :rtype: str
        """
        return self._AckTopic

    @AckTopic.setter
    def AckTopic(self, AckTopic):
        self._AckTopic = AckTopic

    @property
    def ErrorMsg(self):
        r"""Returned error message. If it is null, it means there is no error.
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def SubName(self):
        r"""Returned subscriber names, used for creating Ack consumers
        :rtype: str
        """
        return self._SubName

    @SubName.setter
    def SubName(self, SubName):
        self._SubName = SubName

    @property
    def MessageIDList(self):
        r"""BatchReceivePolicy specifies the messageids of multiple messages returned at one time, using '###' to distinguish different messageids.
        :rtype: str
        """
        return self._MessageIDList

    @MessageIDList.setter
    def MessageIDList(self, MessageIDList):
        self._MessageIDList = MessageIDList

    @property
    def MessagesPayload(self):
        r"""BatchReceivePolicy specifies the message content of multiple messages returned at one time, using '###' to distinguish different message content.
        :rtype: str
        """
        return self._MessagesPayload

    @MessagesPayload.setter
    def MessagesPayload(self, MessagesPayload):
        self._MessagesPayload = MessagesPayload

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MessageID = params.get("MessageID")
        self._MessagePayload = params.get("MessagePayload")
        self._AckTopic = params.get("AckTopic")
        self._ErrorMsg = params.get("ErrorMsg")
        self._SubName = params.get("SubName")
        self._MessageIDList = params.get("MessageIDList")
        self._MessagesPayload = params.get("MessagesPayload")
        self._RequestId = params.get("RequestId")


class ResetMsgSubOffsetByTimestampRequest(AbstractModel):
    r"""ResetMsgSubOffsetByTimestamp request structure.

    """

    def __init__(self):
        r"""
        :param _EnvironmentId: Namespace name.
        :type EnvironmentId: str
        :param _TopicName: Topic name.
        :type TopicName: str
        :param _Subscription: Subscriber name.
        :type Subscription: str
        :param _ToTimestamp: Timestamp, accurate down to the millisecond.
        :type ToTimestamp: int
        :param _ClusterId: Pulsar cluster ID
        :type ClusterId: str
        """
        self._EnvironmentId = None
        self._TopicName = None
        self._Subscription = None
        self._ToTimestamp = None
        self._ClusterId = None

    @property
    def EnvironmentId(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._EnvironmentId

    @EnvironmentId.setter
    def EnvironmentId(self, EnvironmentId):
        self._EnvironmentId = EnvironmentId

    @property
    def TopicName(self):
        r"""Topic name.
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Subscription(self):
        r"""Subscriber name.
        :rtype: str
        """
        return self._Subscription

    @Subscription.setter
    def Subscription(self, Subscription):
        self._Subscription = Subscription

    @property
    def ToTimestamp(self):
        r"""Timestamp, accurate down to the millisecond.
        :rtype: int
        """
        return self._ToTimestamp

    @ToTimestamp.setter
    def ToTimestamp(self, ToTimestamp):
        self._ToTimestamp = ToTimestamp

    @property
    def ClusterId(self):
        r"""Pulsar cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._EnvironmentId = params.get("EnvironmentId")
        self._TopicName = params.get("TopicName")
        self._Subscription = params.get("Subscription")
        self._ToTimestamp = params.get("ToTimestamp")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetMsgSubOffsetByTimestampResponse(AbstractModel):
    r"""ResetMsgSubOffsetByTimestamp response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Result.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        r"""Result.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ResetRocketMQConsumerOffSetRequest(AbstractModel):
    r"""ResetRocketMQConsumerOffSet request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _NamespaceId: Namespace name.
        :type NamespaceId: str
        :param _GroupId: Consumer group name.
        :type GroupId: str
        :param _Type: Reset method. 0: Start from the latest offset; 1: Start from specified time point.
        :type Type: int
        :param _Topic: Topic name.
        :type Topic: str
        :param _ResetTimestamp: The specified timestamp that has been reset, in milliseconds. This parameter only takes effect when the value of `Type` is `1`.
        :type ResetTimestamp: int
        :param _RetryFlag: Whether the reset flag is retry topic.
        :type RetryFlag: bool
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._GroupId = None
        self._Type = None
        self._Topic = None
        self._ResetTimestamp = None
        self._RetryFlag = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Namespace name.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupId(self):
        r"""Consumer group name.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Type(self):
        r"""Reset method. 0: Start from the latest offset; 1: Start from specified time point.
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Topic(self):
        r"""Topic name.
        :rtype: str
        """
        return self._Topic

    @Topic.setter
    def Topic(self, Topic):
        self._Topic = Topic

    @property
    def ResetTimestamp(self):
        r"""The specified timestamp that has been reset, in milliseconds. This parameter only takes effect when the value of `Type` is `1`.
        :rtype: int
        """
        return self._ResetTimestamp

    @ResetTimestamp.setter
    def ResetTimestamp(self, ResetTimestamp):
        self._ResetTimestamp = ResetTimestamp

    @property
    def RetryFlag(self):
        r"""Whether the reset flag is retry topic.
        :rtype: bool
        """
        return self._RetryFlag

    @RetryFlag.setter
    def RetryFlag(self, RetryFlag):
        self._RetryFlag = RetryFlag


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupId = params.get("GroupId")
        self._Type = params.get("Type")
        self._Topic = params.get("Topic")
        self._ResetTimestamp = params.get("ResetTimestamp")
        self._RetryFlag = params.get("RetryFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetRocketMQConsumerOffSetResponse(AbstractModel):
    r"""ResetRocketMQConsumerOffSet response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RetentionPolicy(AbstractModel):
    r"""Message retention policy

    """

    def __init__(self):
        r"""
        :param _TimeInMinutes: Message retention period
        :type TimeInMinutes: int
        :param _SizeInMB: Message retention size
        :type SizeInMB: int
        """
        self._TimeInMinutes = None
        self._SizeInMB = None

    @property
    def TimeInMinutes(self):
        r"""Message retention period
        :rtype: int
        """
        return self._TimeInMinutes

    @TimeInMinutes.setter
    def TimeInMinutes(self, TimeInMinutes):
        self._TimeInMinutes = TimeInMinutes

    @property
    def SizeInMB(self):
        r"""Message retention size
        :rtype: int
        """
        return self._SizeInMB

    @SizeInMB.setter
    def SizeInMB(self, SizeInMB):
        self._SizeInMB = SizeInMB


    def _deserialize(self, params):
        self._TimeInMinutes = params.get("TimeInMinutes")
        self._SizeInMB = params.get("SizeInMB")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RetryRocketMQDlqMessageRequest(AbstractModel):
    r"""RetryRocketMQDlqMessage request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _NamespaceId: Specifies the namespace name.
        :type NamespaceId: str
        :param _GroupName: Group Name
        :type GroupName: str
        :param _MessageIds: Dead Letter Message ID
        :type MessageIds: list of str
        """
        self._ClusterId = None
        self._NamespaceId = None
        self._GroupName = None
        self._MessageIds = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NamespaceId(self):
        r"""Specifies the namespace name.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def GroupName(self):
        r"""Group Name
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def MessageIds(self):
        r"""Dead Letter Message ID
        :rtype: list of str
        """
        return self._MessageIds

    @MessageIds.setter
    def MessageIds(self, MessageIds):
        self._MessageIds = MessageIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NamespaceId = params.get("NamespaceId")
        self._GroupName = params.get("GroupName")
        self._MessageIds = params.get("MessageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RetryRocketMQDlqMessageResponse(AbstractModel):
    r"""RetryRocketMQDlqMessage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RewindCmqQueueRequest(AbstractModel):
    r"""RewindCmqQueue request structure.

    """

    def __init__(self):
        r"""
        :param _QueueName: Queue name, unique under the same account in a single region. queue name is a string of no more than 64 characters, beginning with a letter, the rest may contain letters, digits, and hyphens (-).
        :type QueueName: str
        :param _StartConsumeTime: After this time is configured, the `(Batch)receiveMessage` API will consume the messages received after this timestamp in the order in which they are produced.
        :type StartConsumeTime: int
        """
        self._QueueName = None
        self._StartConsumeTime = None

    @property
    def QueueName(self):
        r"""Queue name, unique under the same account in a single region. queue name is a string of no more than 64 characters, beginning with a letter, the rest may contain letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def StartConsumeTime(self):
        r"""After this time is configured, the `(Batch)receiveMessage` API will consume the messages received after this timestamp in the order in which they are produced.
        :rtype: int
        """
        return self._StartConsumeTime

    @StartConsumeTime.setter
    def StartConsumeTime(self, StartConsumeTime):
        self._StartConsumeTime = StartConsumeTime


    def _deserialize(self, params):
        self._QueueName = params.get("QueueName")
        self._StartConsumeTime = params.get("StartConsumeTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RewindCmqQueueResponse(AbstractModel):
    r"""RewindCmqQueue response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RocketMQClusterConfig(AbstractModel):
    r"""RocketMQ cluster configuration

    """

    def __init__(self):
        r"""
        :param _MaxTpsPerNamespace: Upper limit of TPS per single namespace.
        :type MaxTpsPerNamespace: int
        :param _MaxNamespaceNum: Maximum number of namespaces
        :type MaxNamespaceNum: int
        :param _UsedNamespaceNum: Number of used namespaces
        :type UsedNamespaceNum: int
        :param _MaxTopicNum: Maximum number of topics
        :type MaxTopicNum: int
        :param _UsedTopicNum: Number of used topics
        :type UsedTopicNum: int
        :param _MaxGroupNum: Maximum number of groups
        :type MaxGroupNum: int
        :param _UsedGroupNum: Number of used groups
        :type UsedGroupNum: int
        :param _MaxRetentionTime: Maximum message retention period in milliseconds
        :type MaxRetentionTime: int
        :param _MaxLatencyTime: Maximum message delay in milliseconds
        :type MaxLatencyTime: int
        :param _MaxQueuesPerTopic: The maximum number of queues in a single topic
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxQueuesPerTopic: int
        :param _TopicDistribution: Topic distribution.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicDistribution: list of RocketMQTopicDistribution
        :param _MaxRoleNum: Maximum number of roles.
        :type MaxRoleNum: int
        :param _MaxTpsLimit: TPS quota.
        :type MaxTpsLimit: int
        """
        self._MaxTpsPerNamespace = None
        self._MaxNamespaceNum = None
        self._UsedNamespaceNum = None
        self._MaxTopicNum = None
        self._UsedTopicNum = None
        self._MaxGroupNum = None
        self._UsedGroupNum = None
        self._MaxRetentionTime = None
        self._MaxLatencyTime = None
        self._MaxQueuesPerTopic = None
        self._TopicDistribution = None
        self._MaxRoleNum = None
        self._MaxTpsLimit = None

    @property
    def MaxTpsPerNamespace(self):
        warnings.warn("parameter `MaxTpsPerNamespace` is deprecated", DeprecationWarning) 

        r"""Upper limit of TPS per single namespace.
        :rtype: int
        """
        return self._MaxTpsPerNamespace

    @MaxTpsPerNamespace.setter
    def MaxTpsPerNamespace(self, MaxTpsPerNamespace):
        warnings.warn("parameter `MaxTpsPerNamespace` is deprecated", DeprecationWarning) 

        self._MaxTpsPerNamespace = MaxTpsPerNamespace

    @property
    def MaxNamespaceNum(self):
        r"""Maximum number of namespaces
        :rtype: int
        """
        return self._MaxNamespaceNum

    @MaxNamespaceNum.setter
    def MaxNamespaceNum(self, MaxNamespaceNum):
        self._MaxNamespaceNum = MaxNamespaceNum

    @property
    def UsedNamespaceNum(self):
        r"""Number of used namespaces
        :rtype: int
        """
        return self._UsedNamespaceNum

    @UsedNamespaceNum.setter
    def UsedNamespaceNum(self, UsedNamespaceNum):
        self._UsedNamespaceNum = UsedNamespaceNum

    @property
    def MaxTopicNum(self):
        r"""Maximum number of topics
        :rtype: int
        """
        return self._MaxTopicNum

    @MaxTopicNum.setter
    def MaxTopicNum(self, MaxTopicNum):
        self._MaxTopicNum = MaxTopicNum

    @property
    def UsedTopicNum(self):
        r"""Number of used topics
        :rtype: int
        """
        return self._UsedTopicNum

    @UsedTopicNum.setter
    def UsedTopicNum(self, UsedTopicNum):
        self._UsedTopicNum = UsedTopicNum

    @property
    def MaxGroupNum(self):
        r"""Maximum number of groups
        :rtype: int
        """
        return self._MaxGroupNum

    @MaxGroupNum.setter
    def MaxGroupNum(self, MaxGroupNum):
        self._MaxGroupNum = MaxGroupNum

    @property
    def UsedGroupNum(self):
        r"""Number of used groups
        :rtype: int
        """
        return self._UsedGroupNum

    @UsedGroupNum.setter
    def UsedGroupNum(self, UsedGroupNum):
        self._UsedGroupNum = UsedGroupNum

    @property
    def MaxRetentionTime(self):
        r"""Maximum message retention period in milliseconds
        :rtype: int
        """
        return self._MaxRetentionTime

    @MaxRetentionTime.setter
    def MaxRetentionTime(self, MaxRetentionTime):
        self._MaxRetentionTime = MaxRetentionTime

    @property
    def MaxLatencyTime(self):
        r"""Maximum message delay in milliseconds
        :rtype: int
        """
        return self._MaxLatencyTime

    @MaxLatencyTime.setter
    def MaxLatencyTime(self, MaxLatencyTime):
        self._MaxLatencyTime = MaxLatencyTime

    @property
    def MaxQueuesPerTopic(self):
        r"""The maximum number of queues in a single topic
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxQueuesPerTopic

    @MaxQueuesPerTopic.setter
    def MaxQueuesPerTopic(self, MaxQueuesPerTopic):
        self._MaxQueuesPerTopic = MaxQueuesPerTopic

    @property
    def TopicDistribution(self):
        r"""Topic distribution.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RocketMQTopicDistribution
        """
        return self._TopicDistribution

    @TopicDistribution.setter
    def TopicDistribution(self, TopicDistribution):
        self._TopicDistribution = TopicDistribution

    @property
    def MaxRoleNum(self):
        r"""Maximum number of roles.
        :rtype: int
        """
        return self._MaxRoleNum

    @MaxRoleNum.setter
    def MaxRoleNum(self, MaxRoleNum):
        self._MaxRoleNum = MaxRoleNum

    @property
    def MaxTpsLimit(self):
        r"""TPS quota.
        :rtype: int
        """
        return self._MaxTpsLimit

    @MaxTpsLimit.setter
    def MaxTpsLimit(self, MaxTpsLimit):
        self._MaxTpsLimit = MaxTpsLimit


    def _deserialize(self, params):
        self._MaxTpsPerNamespace = params.get("MaxTpsPerNamespace")
        self._MaxNamespaceNum = params.get("MaxNamespaceNum")
        self._UsedNamespaceNum = params.get("UsedNamespaceNum")
        self._MaxTopicNum = params.get("MaxTopicNum")
        self._UsedTopicNum = params.get("UsedTopicNum")
        self._MaxGroupNum = params.get("MaxGroupNum")
        self._UsedGroupNum = params.get("UsedGroupNum")
        self._MaxRetentionTime = params.get("MaxRetentionTime")
        self._MaxLatencyTime = params.get("MaxLatencyTime")
        self._MaxQueuesPerTopic = params.get("MaxQueuesPerTopic")
        if params.get("TopicDistribution") is not None:
            self._TopicDistribution = []
            for item in params.get("TopicDistribution"):
                obj = RocketMQTopicDistribution()
                obj._deserialize(item)
                self._TopicDistribution.append(obj)
        self._MaxRoleNum = params.get("MaxRoleNum")
        self._MaxTpsLimit = params.get("MaxTpsLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQClusterDetail(AbstractModel):
    r"""Details of the tenant’s RocketMQ cluster

    """

    def __init__(self):
        r"""
        :param _Info: Basic cluster information.
        :type Info: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterInfo`
        :param _Config: Cluster configuration information.
        :type Config: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterConfig`
        :param _Status: Cluster status. 0: Creating; 1: Normal; 2: Terminating; 3: Deleted; 4. Isolated; 5. Creation failed; 6: Deletion failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._Info = None
        self._Config = None
        self._Status = None

    @property
    def Info(self):
        r"""Basic cluster information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterInfo`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def Config(self):
        r"""Cluster configuration information.
        :rtype: :class:`tencentcloud.tdmq.v20200217.models.RocketMQClusterConfig`
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def Status(self):
        r"""Cluster status. 0: Creating; 1: Normal; 2: Terminating; 3: Deleted; 4. Isolated; 5. Creation failed; 6: Deletion failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = RocketMQClusterInfo()
            self._Info._deserialize(params.get("Info"))
        if params.get("Config") is not None:
            self._Config = RocketMQClusterConfig()
            self._Config._deserialize(params.get("Config"))
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQClusterInfo(AbstractModel):
    r"""RocketMQ cluster's basic information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _Region: Region information
        :type Region: str
        :param _CreateTime: Creation time in milliseconds
        :type CreateTime: int
        :param _Remark: Cluster remarks
Note: this field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _PublicEndPoint: Public network access address
        :type PublicEndPoint: str
        :param _VpcEndPoint: VPC access address
        :type VpcEndPoint: str
        :param _SupportNamespaceEndpoint: Whether the namespace access point is supported.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type SupportNamespaceEndpoint: bool
        :param _Vpcs: VPC Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Vpcs: list of VpcConfig
        :param _IsVip: Whether it is an exclusive instance
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsVip: bool
        :param _RocketMQFlag: TDMQ for RocketMQ cluster type flag
Note: This field may return null, indicating that no valid values can be obtained.
        :type RocketMQFlag: bool
        :param _Status: Billing status (`1`: Normal; `2`: Service suspended; `3`: Terminated)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _IsolateTime: Service suspension time in milliseconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateTime: int
        :param _HttpPublicEndpoint: HTTP-based public network access address
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpPublicEndpoint: str
        :param _HttpVpcEndpoint: HTTP-based VPC access address
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpVpcEndpoint: str
        :param _InternalEndpoint: Internal TCP access address
Note: This field may return null, indicating that no valid values can be obtained.
        :type InternalEndpoint: str
        :param _HttpInternalEndpoint: Internal HTTP access address
Note: This field may return null, indicating that no valid values can be obtained.
        :type HttpInternalEndpoint: str
        :param _AclEnabled: Whether to enable ACL authentication. For Exclusive Edition instances, ACL authentication can be disabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AclEnabled: bool
        :param _PublicClbId: Public network CLB instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublicClbId: str
        :param _Vip: vip
Note: This field may return null, indicating that no valid values can be obtained.
        :type Vip: str
        :param _VpcId: Specifies the VPC it belongs to.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _SupportMigration: Whether migration is supported.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SupportMigration: bool
        :param _InstanceStatus: Instance status:
0: Creating
1: Normal
2: Isolating
3: Destroyed
4: Abnormal
5: Deliver failed
6: Changing the configuration
7: Configuration change failed
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceStatus: int
        :param _ZoneId: Indicates the AZ to which the cluster belongs.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneId: int
        :param _ZoneIds: The AZ where the cluster nodes are located. If the cluster is a cross-AZ cluster, it includes multiple AZs where the cluster nodes are located.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneIds: list of int
        :param _IsFrozen: Whether it is frozen.
        :type IsFrozen: bool
        :param _AutoCreateTopicEnabled: Whether to enable automatic topic creation.
        :type AutoCreateTopicEnabled: bool
        :param _AdminFeatureEnabled: Whether to enable the admin feature of the cluster.
        :type AdminFeatureEnabled: bool
        :param _AdminAccessKey: Admin AK
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminAccessKey: str
        :param _AdminSecretKey: Admin SK
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminSecretKey: str
        :param _EnableDeletionProtection: Whether to enable deletion protection
        :type EnableDeletionProtection: bool
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Region = None
        self._CreateTime = None
        self._Remark = None
        self._PublicEndPoint = None
        self._VpcEndPoint = None
        self._SupportNamespaceEndpoint = None
        self._Vpcs = None
        self._IsVip = None
        self._RocketMQFlag = None
        self._Status = None
        self._IsolateTime = None
        self._HttpPublicEndpoint = None
        self._HttpVpcEndpoint = None
        self._InternalEndpoint = None
        self._HttpInternalEndpoint = None
        self._AclEnabled = None
        self._PublicClbId = None
        self._Vip = None
        self._VpcId = None
        self._SupportMigration = None
        self._InstanceStatus = None
        self._ZoneId = None
        self._ZoneIds = None
        self._IsFrozen = None
        self._AutoCreateTopicEnabled = None
        self._AdminFeatureEnabled = None
        self._AdminAccessKey = None
        self._AdminSecretKey = None
        self._EnableDeletionProtection = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Region(self):
        r"""Region information
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def CreateTime(self):
        r"""Creation time in milliseconds
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Remark(self):
        r"""Cluster remarks
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PublicEndPoint(self):
        r"""Public network access address
        :rtype: str
        """
        return self._PublicEndPoint

    @PublicEndPoint.setter
    def PublicEndPoint(self, PublicEndPoint):
        self._PublicEndPoint = PublicEndPoint

    @property
    def VpcEndPoint(self):
        r"""VPC access address
        :rtype: str
        """
        return self._VpcEndPoint

    @VpcEndPoint.setter
    def VpcEndPoint(self, VpcEndPoint):
        self._VpcEndPoint = VpcEndPoint

    @property
    def SupportNamespaceEndpoint(self):
        r"""Whether the namespace access point is supported.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._SupportNamespaceEndpoint

    @SupportNamespaceEndpoint.setter
    def SupportNamespaceEndpoint(self, SupportNamespaceEndpoint):
        self._SupportNamespaceEndpoint = SupportNamespaceEndpoint

    @property
    def Vpcs(self):
        r"""VPC Information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of VpcConfig
        """
        return self._Vpcs

    @Vpcs.setter
    def Vpcs(self, Vpcs):
        self._Vpcs = Vpcs

    @property
    def IsVip(self):
        r"""Whether it is an exclusive instance
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsVip

    @IsVip.setter
    def IsVip(self, IsVip):
        self._IsVip = IsVip

    @property
    def RocketMQFlag(self):
        r"""TDMQ for RocketMQ cluster type flag
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._RocketMQFlag

    @RocketMQFlag.setter
    def RocketMQFlag(self, RocketMQFlag):
        self._RocketMQFlag = RocketMQFlag

    @property
    def Status(self):
        r"""Billing status (`1`: Normal; `2`: Service suspended; `3`: Terminated)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsolateTime(self):
        r"""Service suspension time in milliseconds
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def HttpPublicEndpoint(self):
        r"""HTTP-based public network access address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpPublicEndpoint

    @HttpPublicEndpoint.setter
    def HttpPublicEndpoint(self, HttpPublicEndpoint):
        self._HttpPublicEndpoint = HttpPublicEndpoint

    @property
    def HttpVpcEndpoint(self):
        r"""HTTP-based VPC access address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpVpcEndpoint

    @HttpVpcEndpoint.setter
    def HttpVpcEndpoint(self, HttpVpcEndpoint):
        self._HttpVpcEndpoint = HttpVpcEndpoint

    @property
    def InternalEndpoint(self):
        r"""Internal TCP access address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InternalEndpoint

    @InternalEndpoint.setter
    def InternalEndpoint(self, InternalEndpoint):
        self._InternalEndpoint = InternalEndpoint

    @property
    def HttpInternalEndpoint(self):
        r"""Internal HTTP access address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HttpInternalEndpoint

    @HttpInternalEndpoint.setter
    def HttpInternalEndpoint(self, HttpInternalEndpoint):
        self._HttpInternalEndpoint = HttpInternalEndpoint

    @property
    def AclEnabled(self):
        r"""Whether to enable ACL authentication. For Exclusive Edition instances, ACL authentication can be disabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AclEnabled

    @AclEnabled.setter
    def AclEnabled(self, AclEnabled):
        self._AclEnabled = AclEnabled

    @property
    def PublicClbId(self):
        r"""Public network CLB instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PublicClbId

    @PublicClbId.setter
    def PublicClbId(self, PublicClbId):
        self._PublicClbId = PublicClbId

    @property
    def Vip(self):
        r"""vip
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def VpcId(self):
        r"""Specifies the VPC it belongs to.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SupportMigration(self):
        r"""Whether migration is supported.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._SupportMigration

    @SupportMigration.setter
    def SupportMigration(self, SupportMigration):
        self._SupportMigration = SupportMigration

    @property
    def InstanceStatus(self):
        r"""Instance status:
0: Creating
1: Normal
2: Isolating
3: Destroyed
4: Abnormal
5: Deliver failed
6: Changing the configuration
7: Configuration change failed
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def ZoneId(self):
        r"""Indicates the AZ to which the cluster belongs.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ZoneIds(self):
        r"""The AZ where the cluster nodes are located. If the cluster is a cross-AZ cluster, it includes multiple AZs where the cluster nodes are located.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._ZoneIds

    @ZoneIds.setter
    def ZoneIds(self, ZoneIds):
        self._ZoneIds = ZoneIds

    @property
    def IsFrozen(self):
        r"""Whether it is frozen.
        :rtype: bool
        """
        return self._IsFrozen

    @IsFrozen.setter
    def IsFrozen(self, IsFrozen):
        self._IsFrozen = IsFrozen

    @property
    def AutoCreateTopicEnabled(self):
        r"""Whether to enable automatic topic creation.
        :rtype: bool
        """
        return self._AutoCreateTopicEnabled

    @AutoCreateTopicEnabled.setter
    def AutoCreateTopicEnabled(self, AutoCreateTopicEnabled):
        self._AutoCreateTopicEnabled = AutoCreateTopicEnabled

    @property
    def AdminFeatureEnabled(self):
        r"""Whether to enable the admin feature of the cluster.
        :rtype: bool
        """
        return self._AdminFeatureEnabled

    @AdminFeatureEnabled.setter
    def AdminFeatureEnabled(self, AdminFeatureEnabled):
        self._AdminFeatureEnabled = AdminFeatureEnabled

    @property
    def AdminAccessKey(self):
        r"""Admin AK
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AdminAccessKey

    @AdminAccessKey.setter
    def AdminAccessKey(self, AdminAccessKey):
        self._AdminAccessKey = AdminAccessKey

    @property
    def AdminSecretKey(self):
        r"""Admin SK
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AdminSecretKey

    @AdminSecretKey.setter
    def AdminSecretKey(self, AdminSecretKey):
        self._AdminSecretKey = AdminSecretKey

    @property
    def EnableDeletionProtection(self):
        r"""Whether to enable deletion protection
        :rtype: bool
        """
        return self._EnableDeletionProtection

    @EnableDeletionProtection.setter
    def EnableDeletionProtection(self, EnableDeletionProtection):
        self._EnableDeletionProtection = EnableDeletionProtection


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Region = params.get("Region")
        self._CreateTime = params.get("CreateTime")
        self._Remark = params.get("Remark")
        self._PublicEndPoint = params.get("PublicEndPoint")
        self._VpcEndPoint = params.get("VpcEndPoint")
        self._SupportNamespaceEndpoint = params.get("SupportNamespaceEndpoint")
        if params.get("Vpcs") is not None:
            self._Vpcs = []
            for item in params.get("Vpcs"):
                obj = VpcConfig()
                obj._deserialize(item)
                self._Vpcs.append(obj)
        self._IsVip = params.get("IsVip")
        self._RocketMQFlag = params.get("RocketMQFlag")
        self._Status = params.get("Status")
        self._IsolateTime = params.get("IsolateTime")
        self._HttpPublicEndpoint = params.get("HttpPublicEndpoint")
        self._HttpVpcEndpoint = params.get("HttpVpcEndpoint")
        self._InternalEndpoint = params.get("InternalEndpoint")
        self._HttpInternalEndpoint = params.get("HttpInternalEndpoint")
        self._AclEnabled = params.get("AclEnabled")
        self._PublicClbId = params.get("PublicClbId")
        self._Vip = params.get("Vip")
        self._VpcId = params.get("VpcId")
        self._SupportMigration = params.get("SupportMigration")
        self._InstanceStatus = params.get("InstanceStatus")
        self._ZoneId = params.get("ZoneId")
        self._ZoneIds = params.get("ZoneIds")
        self._IsFrozen = params.get("IsFrozen")
        self._AutoCreateTopicEnabled = params.get("AutoCreateTopicEnabled")
        self._AdminFeatureEnabled = params.get("AdminFeatureEnabled")
        self._AdminAccessKey = params.get("AdminAccessKey")
        self._AdminSecretKey = params.get("AdminSecretKey")
        self._EnableDeletionProtection = params.get("EnableDeletionProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQClusterRecentStats(AbstractModel):
    r"""Recent RocketMQ usage

    """

    def __init__(self):
        r"""
        :param _TopicNum: Number of topics
        :type TopicNum: int
        :param _ProducedMsgNum: Number of produced messages
        :type ProducedMsgNum: int
        :param _ConsumedMsgNum: Number of consumed messages
        :type ConsumedMsgNum: int
        :param _AccumulativeMsgNum: Number of retained messages
        :type AccumulativeMsgNum: int
        """
        self._TopicNum = None
        self._ProducedMsgNum = None
        self._ConsumedMsgNum = None
        self._AccumulativeMsgNum = None

    @property
    def TopicNum(self):
        r"""Number of topics
        :rtype: int
        """
        return self._TopicNum

    @TopicNum.setter
    def TopicNum(self, TopicNum):
        self._TopicNum = TopicNum

    @property
    def ProducedMsgNum(self):
        r"""Number of produced messages
        :rtype: int
        """
        return self._ProducedMsgNum

    @ProducedMsgNum.setter
    def ProducedMsgNum(self, ProducedMsgNum):
        self._ProducedMsgNum = ProducedMsgNum

    @property
    def ConsumedMsgNum(self):
        r"""Number of consumed messages
        :rtype: int
        """
        return self._ConsumedMsgNum

    @ConsumedMsgNum.setter
    def ConsumedMsgNum(self, ConsumedMsgNum):
        self._ConsumedMsgNum = ConsumedMsgNum

    @property
    def AccumulativeMsgNum(self):
        r"""Number of retained messages
        :rtype: int
        """
        return self._AccumulativeMsgNum

    @AccumulativeMsgNum.setter
    def AccumulativeMsgNum(self, AccumulativeMsgNum):
        self._AccumulativeMsgNum = AccumulativeMsgNum


    def _deserialize(self, params):
        self._TopicNum = params.get("TopicNum")
        self._ProducedMsgNum = params.get("ProducedMsgNum")
        self._ConsumedMsgNum = params.get("ConsumedMsgNum")
        self._AccumulativeMsgNum = params.get("AccumulativeMsgNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQDataPoint(AbstractModel):
    r"""Monitoring data points

    """

    def __init__(self):
        r"""
        :param _Timestamps: Monitoring value array, which corresponds one-to-one with Timestamps
Note: This field may return null, indicating that no valid values can be obtained.
        :type Timestamps: list of int
        :param _Values: Monitoring data point position. For example, a day is divided into 1,440 points per minute, with each point having a serial number between 0 and 1439. If a certain serial number is not in the array, it indicates a missing data point.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Values: list of float
        """
        self._Timestamps = None
        self._Values = None

    @property
    def Timestamps(self):
        r"""Monitoring value array, which corresponds one-to-one with Timestamps
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._Timestamps

    @Timestamps.setter
    def Timestamps(self, Timestamps):
        self._Timestamps = Timestamps

    @property
    def Values(self):
        r"""Monitoring data point position. For example, a day is divided into 1,440 points per minute, with each point having a serial number between 0 and 1439. If a certain serial number is not in the array, it indicates a missing data point.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of float
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Timestamps = params.get("Timestamps")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQGroup(AbstractModel):
    r"""RocketMQ consumer group information

    """

    def __init__(self):
        r"""
        :param _Name: Consumer group name.
        :type Name: str
        :param _ConsumerNum: The number of online consumers.
        :type ConsumerNum: int
        :param _TPS: Consumption TPS.
        :type TPS: int
        :param _TotalAccumulative: The total number of heaped messages.
        :type TotalAccumulative: int
        :param _ConsumptionMode: 0: Cluster consumption mode; 1: Broadcast consumption mode; -1: Unknown.
        :type ConsumptionMode: int
        :param _ReadEnabled: Whether to allow consumption.
        :type ReadEnabled: bool
        :param _RetryPartitionNum: The number of partitions in a retry topic.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RetryPartitionNum: int
        :param _CreateTime: Creation time in milliseconds.
        :type CreateTime: int
        :param _UpdateTime: Modification time in milliseconds.
        :type UpdateTime: int
        :param _ClientProtocol: Client protocol.
        :type ClientProtocol: str
        :param _Remark: Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _ConsumerType: Consumer type. Enumerated values: `ACTIVELY` or `PASSIVELY`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsumerType: str
        :param _BroadcastEnabled: Whether to enable broadcast consumption.
        :type BroadcastEnabled: bool
        :param _GroupType: Group type
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupType: str
        :param _RetryMaxTimes: The number of retries
Note: This field may return null, indicating that no valid values can be obtained.
        :type RetryMaxTimes: int
        :param _InstanceId: Instance ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _Namespace: Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param _SubscribeTopicNum: Number of subscribed topics.
        :type SubscribeTopicNum: int
        :param _TagList: List of bound tags
        :type TagList: list of Tag
        """
        self._Name = None
        self._ConsumerNum = None
        self._TPS = None
        self._TotalAccumulative = None
        self._ConsumptionMode = None
        self._ReadEnabled = None
        self._RetryPartitionNum = None
        self._CreateTime = None
        self._UpdateTime = None
        self._ClientProtocol = None
        self._Remark = None
        self._ConsumerType = None
        self._BroadcastEnabled = None
        self._GroupType = None
        self._RetryMaxTimes = None
        self._InstanceId = None
        self._Namespace = None
        self._SubscribeTopicNum = None
        self._TagList = None

    @property
    def Name(self):
        r"""Consumer group name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ConsumerNum(self):
        r"""The number of online consumers.
        :rtype: int
        """
        return self._ConsumerNum

    @ConsumerNum.setter
    def ConsumerNum(self, ConsumerNum):
        self._ConsumerNum = ConsumerNum

    @property
    def TPS(self):
        warnings.warn("parameter `TPS` is deprecated", DeprecationWarning) 

        r"""Consumption TPS.
        :rtype: int
        """
        return self._TPS

    @TPS.setter
    def TPS(self, TPS):
        warnings.warn("parameter `TPS` is deprecated", DeprecationWarning) 

        self._TPS = TPS

    @property
    def TotalAccumulative(self):
        warnings.warn("parameter `TotalAccumulative` is deprecated", DeprecationWarning) 

        r"""The total number of heaped messages.
        :rtype: int
        """
        return self._TotalAccumulative

    @TotalAccumulative.setter
    def TotalAccumulative(self, TotalAccumulative):
        warnings.warn("parameter `TotalAccumulative` is deprecated", DeprecationWarning) 

        self._TotalAccumulative = TotalAccumulative

    @property
    def ConsumptionMode(self):
        r"""0: Cluster consumption mode; 1: Broadcast consumption mode; -1: Unknown.
        :rtype: int
        """
        return self._ConsumptionMode

    @ConsumptionMode.setter
    def ConsumptionMode(self, ConsumptionMode):
        self._ConsumptionMode = ConsumptionMode

    @property
    def ReadEnabled(self):
        r"""Whether to allow consumption.
        :rtype: bool
        """
        return self._ReadEnabled

    @ReadEnabled.setter
    def ReadEnabled(self, ReadEnabled):
        self._ReadEnabled = ReadEnabled

    @property
    def RetryPartitionNum(self):
        r"""The number of partitions in a retry topic.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RetryPartitionNum

    @RetryPartitionNum.setter
    def RetryPartitionNum(self, RetryPartitionNum):
        self._RetryPartitionNum = RetryPartitionNum

    @property
    def CreateTime(self):
        r"""Creation time in milliseconds.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Modification time in milliseconds.
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ClientProtocol(self):
        r"""Client protocol.
        :rtype: str
        """
        return self._ClientProtocol

    @ClientProtocol.setter
    def ClientProtocol(self, ClientProtocol):
        self._ClientProtocol = ClientProtocol

    @property
    def Remark(self):
        r"""Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ConsumerType(self):
        r"""Consumer type. Enumerated values: `ACTIVELY` or `PASSIVELY`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsumerType

    @ConsumerType.setter
    def ConsumerType(self, ConsumerType):
        self._ConsumerType = ConsumerType

    @property
    def BroadcastEnabled(self):
        r"""Whether to enable broadcast consumption.
        :rtype: bool
        """
        return self._BroadcastEnabled

    @BroadcastEnabled.setter
    def BroadcastEnabled(self, BroadcastEnabled):
        self._BroadcastEnabled = BroadcastEnabled

    @property
    def GroupType(self):
        r"""Group type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def RetryMaxTimes(self):
        r"""The number of retries
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RetryMaxTimes

    @RetryMaxTimes.setter
    def RetryMaxTimes(self, RetryMaxTimes):
        self._RetryMaxTimes = RetryMaxTimes

    @property
    def InstanceId(self):
        r"""Instance ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Namespace(self):
        r"""Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def SubscribeTopicNum(self):
        r"""Number of subscribed topics.
        :rtype: int
        """
        return self._SubscribeTopicNum

    @SubscribeTopicNum.setter
    def SubscribeTopicNum(self, SubscribeTopicNum):
        self._SubscribeTopicNum = SubscribeTopicNum

    @property
    def TagList(self):
        r"""List of bound tags
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ConsumerNum = params.get("ConsumerNum")
        self._TPS = params.get("TPS")
        self._TotalAccumulative = params.get("TotalAccumulative")
        self._ConsumptionMode = params.get("ConsumptionMode")
        self._ReadEnabled = params.get("ReadEnabled")
        self._RetryPartitionNum = params.get("RetryPartitionNum")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._ClientProtocol = params.get("ClientProtocol")
        self._Remark = params.get("Remark")
        self._ConsumerType = params.get("ConsumerType")
        self._BroadcastEnabled = params.get("BroadcastEnabled")
        self._GroupType = params.get("GroupType")
        self._RetryMaxTimes = params.get("RetryMaxTimes")
        self._InstanceId = params.get("InstanceId")
        self._Namespace = params.get("Namespace")
        self._SubscribeTopicNum = params.get("SubscribeTopicNum")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQInstanceConfig(AbstractModel):
    r"""Instance configurations of a TDMQ for RocketMQ exclusive cluster

    """

    def __init__(self):
        r"""
        :param _MaxTpsPerNamespace: Maximum TPS per namespace
        :type MaxTpsPerNamespace: int
        :param _MaxNamespaceNum: Maximum number of namespaces
        :type MaxNamespaceNum: int
        :param _UsedNamespaceNum: Number of used namespaces
        :type UsedNamespaceNum: int
        :param _MaxTopicNum: Maximum number of topics
        :type MaxTopicNum: int
        :param _UsedTopicNum: Number of used topics
        :type UsedTopicNum: int
        :param _MaxGroupNum: Maximum number of groups
        :type MaxGroupNum: int
        :param _UsedGroupNum: Number of used groups
        :type UsedGroupNum: int
        :param _ConfigDisplay: Cluster type
        :type ConfigDisplay: str
        :param _NodeCount: Number of nodes in the cluster
        :type NodeCount: int
        :param _NodeDistribution: Node distribution
        :type NodeDistribution: list of InstanceNodeDistribution
        :param _TopicDistribution: Topic distribution
        :type TopicDistribution: list of RocketMQTopicDistribution
        :param _MaxQueuesPerTopic: 
        :type MaxQueuesPerTopic: int
        :param _MaxRetention: Maximum configurable message retention time, in hours	
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxRetention: int
        :param _MinRetention: Minimum configurable message retention time, in hours
Note: This field may return null, indicating that no valid values can be obtained.
        :type MinRetention: int
        :param _Retention: Instance message retention time, in hours
Note: This field may return null, indicating that no valid values can be obtained.
        :type Retention: int
        :param _TopicNumLowerLimit: Minimum quota for the number of topics, which is the free quota. The default number is the minimum quota per node in the cluster specification multiplied by the number of nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicNumLowerLimit: int
        :param _TopicNumUpperLimit: Maximum quota for the number of topics. The default number is the maximum quota per node in the cluster specification multiplied by the number of nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicNumUpperLimit: int
        :param _SendReceiveRatio: Controls the TPS ratio for producing and consuming messages. Value range: 0–1. Default value: 0.5.
        :type SendReceiveRatio: float
        """
        self._MaxTpsPerNamespace = None
        self._MaxNamespaceNum = None
        self._UsedNamespaceNum = None
        self._MaxTopicNum = None
        self._UsedTopicNum = None
        self._MaxGroupNum = None
        self._UsedGroupNum = None
        self._ConfigDisplay = None
        self._NodeCount = None
        self._NodeDistribution = None
        self._TopicDistribution = None
        self._MaxQueuesPerTopic = None
        self._MaxRetention = None
        self._MinRetention = None
        self._Retention = None
        self._TopicNumLowerLimit = None
        self._TopicNumUpperLimit = None
        self._SendReceiveRatio = None

    @property
    def MaxTpsPerNamespace(self):
        r"""Maximum TPS per namespace
        :rtype: int
        """
        return self._MaxTpsPerNamespace

    @MaxTpsPerNamespace.setter
    def MaxTpsPerNamespace(self, MaxTpsPerNamespace):
        self._MaxTpsPerNamespace = MaxTpsPerNamespace

    @property
    def MaxNamespaceNum(self):
        r"""Maximum number of namespaces
        :rtype: int
        """
        return self._MaxNamespaceNum

    @MaxNamespaceNum.setter
    def MaxNamespaceNum(self, MaxNamespaceNum):
        self._MaxNamespaceNum = MaxNamespaceNum

    @property
    def UsedNamespaceNum(self):
        r"""Number of used namespaces
        :rtype: int
        """
        return self._UsedNamespaceNum

    @UsedNamespaceNum.setter
    def UsedNamespaceNum(self, UsedNamespaceNum):
        self._UsedNamespaceNum = UsedNamespaceNum

    @property
    def MaxTopicNum(self):
        r"""Maximum number of topics
        :rtype: int
        """
        return self._MaxTopicNum

    @MaxTopicNum.setter
    def MaxTopicNum(self, MaxTopicNum):
        self._MaxTopicNum = MaxTopicNum

    @property
    def UsedTopicNum(self):
        r"""Number of used topics
        :rtype: int
        """
        return self._UsedTopicNum

    @UsedTopicNum.setter
    def UsedTopicNum(self, UsedTopicNum):
        self._UsedTopicNum = UsedTopicNum

    @property
    def MaxGroupNum(self):
        r"""Maximum number of groups
        :rtype: int
        """
        return self._MaxGroupNum

    @MaxGroupNum.setter
    def MaxGroupNum(self, MaxGroupNum):
        self._MaxGroupNum = MaxGroupNum

    @property
    def UsedGroupNum(self):
        r"""Number of used groups
        :rtype: int
        """
        return self._UsedGroupNum

    @UsedGroupNum.setter
    def UsedGroupNum(self, UsedGroupNum):
        self._UsedGroupNum = UsedGroupNum

    @property
    def ConfigDisplay(self):
        r"""Cluster type
        :rtype: str
        """
        return self._ConfigDisplay

    @ConfigDisplay.setter
    def ConfigDisplay(self, ConfigDisplay):
        self._ConfigDisplay = ConfigDisplay

    @property
    def NodeCount(self):
        r"""Number of nodes in the cluster
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def NodeDistribution(self):
        r"""Node distribution
        :rtype: list of InstanceNodeDistribution
        """
        return self._NodeDistribution

    @NodeDistribution.setter
    def NodeDistribution(self, NodeDistribution):
        self._NodeDistribution = NodeDistribution

    @property
    def TopicDistribution(self):
        r"""Topic distribution
        :rtype: list of RocketMQTopicDistribution
        """
        return self._TopicDistribution

    @TopicDistribution.setter
    def TopicDistribution(self, TopicDistribution):
        self._TopicDistribution = TopicDistribution

    @property
    def MaxQueuesPerTopic(self):
        r"""
        :rtype: int
        """
        return self._MaxQueuesPerTopic

    @MaxQueuesPerTopic.setter
    def MaxQueuesPerTopic(self, MaxQueuesPerTopic):
        self._MaxQueuesPerTopic = MaxQueuesPerTopic

    @property
    def MaxRetention(self):
        r"""Maximum configurable message retention time, in hours	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MaxRetention

    @MaxRetention.setter
    def MaxRetention(self, MaxRetention):
        self._MaxRetention = MaxRetention

    @property
    def MinRetention(self):
        r"""Minimum configurable message retention time, in hours
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MinRetention

    @MinRetention.setter
    def MinRetention(self, MinRetention):
        self._MinRetention = MinRetention

    @property
    def Retention(self):
        r"""Instance message retention time, in hours
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Retention

    @Retention.setter
    def Retention(self, Retention):
        self._Retention = Retention

    @property
    def TopicNumLowerLimit(self):
        r"""Minimum quota for the number of topics, which is the free quota. The default number is the minimum quota per node in the cluster specification multiplied by the number of nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicNumLowerLimit

    @TopicNumLowerLimit.setter
    def TopicNumLowerLimit(self, TopicNumLowerLimit):
        self._TopicNumLowerLimit = TopicNumLowerLimit

    @property
    def TopicNumUpperLimit(self):
        r"""Maximum quota for the number of topics. The default number is the maximum quota per node in the cluster specification multiplied by the number of nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TopicNumUpperLimit

    @TopicNumUpperLimit.setter
    def TopicNumUpperLimit(self, TopicNumUpperLimit):
        self._TopicNumUpperLimit = TopicNumUpperLimit

    @property
    def SendReceiveRatio(self):
        r"""Controls the TPS ratio for producing and consuming messages. Value range: 0–1. Default value: 0.5.
        :rtype: float
        """
        return self._SendReceiveRatio

    @SendReceiveRatio.setter
    def SendReceiveRatio(self, SendReceiveRatio):
        self._SendReceiveRatio = SendReceiveRatio


    def _deserialize(self, params):
        self._MaxTpsPerNamespace = params.get("MaxTpsPerNamespace")
        self._MaxNamespaceNum = params.get("MaxNamespaceNum")
        self._UsedNamespaceNum = params.get("UsedNamespaceNum")
        self._MaxTopicNum = params.get("MaxTopicNum")
        self._UsedTopicNum = params.get("UsedTopicNum")
        self._MaxGroupNum = params.get("MaxGroupNum")
        self._UsedGroupNum = params.get("UsedGroupNum")
        self._ConfigDisplay = params.get("ConfigDisplay")
        self._NodeCount = params.get("NodeCount")
        if params.get("NodeDistribution") is not None:
            self._NodeDistribution = []
            for item in params.get("NodeDistribution"):
                obj = InstanceNodeDistribution()
                obj._deserialize(item)
                self._NodeDistribution.append(obj)
        if params.get("TopicDistribution") is not None:
            self._TopicDistribution = []
            for item in params.get("TopicDistribution"):
                obj = RocketMQTopicDistribution()
                obj._deserialize(item)
                self._TopicDistribution.append(obj)
        self._MaxQueuesPerTopic = params.get("MaxQueuesPerTopic")
        self._MaxRetention = params.get("MaxRetention")
        self._MinRetention = params.get("MinRetention")
        self._Retention = params.get("Retention")
        self._TopicNumLowerLimit = params.get("TopicNumLowerLimit")
        self._TopicNumUpperLimit = params.get("TopicNumUpperLimit")
        self._SendReceiveRatio = params.get("SendReceiveRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQMessageTrack(AbstractModel):
    r"""TDMQ for RocketMQ message trace information

    """

    def __init__(self):
        r"""
        :param _Group: Consumer group
        :type Group: str
        :param _ConsumeStatus: Consumption status.
CONSUMED.
CONSUMED BUT FILTERED.
NOT_CONSUME: specifies unconsumed.
ENTER_RETRY: specifies whether to enter the retry queue.
ENTER_DLQ: specifies whether the message enters the dead letter queue.
Consumption status UNKNOWN.
        :type ConsumeStatus: str
        :param _TrackType: Message trace type
        :type TrackType: str
        :param _ExceptionDesc: Exception information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExceptionDesc: str
        """
        self._Group = None
        self._ConsumeStatus = None
        self._TrackType = None
        self._ExceptionDesc = None

    @property
    def Group(self):
        r"""Consumer group
        :rtype: str
        """
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group

    @property
    def ConsumeStatus(self):
        r"""Consumption status.
CONSUMED.
CONSUMED BUT FILTERED.
NOT_CONSUME: specifies unconsumed.
ENTER_RETRY: specifies whether to enter the retry queue.
ENTER_DLQ: specifies whether the message enters the dead letter queue.
Consumption status UNKNOWN.
        :rtype: str
        """
        return self._ConsumeStatus

    @ConsumeStatus.setter
    def ConsumeStatus(self, ConsumeStatus):
        self._ConsumeStatus = ConsumeStatus

    @property
    def TrackType(self):
        r"""Message trace type
        :rtype: str
        """
        return self._TrackType

    @TrackType.setter
    def TrackType(self, TrackType):
        self._TrackType = TrackType

    @property
    def ExceptionDesc(self):
        r"""Exception information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExceptionDesc

    @ExceptionDesc.setter
    def ExceptionDesc(self, ExceptionDesc):
        self._ExceptionDesc = ExceptionDesc


    def _deserialize(self, params):
        self._Group = params.get("Group")
        self._ConsumeStatus = params.get("ConsumeStatus")
        self._TrackType = params.get("TrackType")
        self._ExceptionDesc = params.get("ExceptionDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQMsgLog(AbstractModel):
    r"""RocketMQ Message Log

    """

    def __init__(self):
        r"""
        :param _MsgId: Message ID
        :type MsgId: str
        :param _MsgTag: Message tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgTag: str
        :param _MsgKey: Message key.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MsgKey: str
        :param _ProducerAddr: Specifies the client ip address.
        :type ProducerAddr: str
        :param _ProduceTime: Message Sending Time
        :type ProduceTime: str
        :param _PulsarMsgId: Pulsar Message ID
        :type PulsarMsgId: str
        :param _DeadLetterResendTimes: Dead-letter resend count
Note: This field may return null, indicating that no valid values can be obtained.
        :type DeadLetterResendTimes: int
        :param _ResendSuccessCount: Dead Letter Resend Success Count
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResendSuccessCount: int
        """
        self._MsgId = None
        self._MsgTag = None
        self._MsgKey = None
        self._ProducerAddr = None
        self._ProduceTime = None
        self._PulsarMsgId = None
        self._DeadLetterResendTimes = None
        self._ResendSuccessCount = None

    @property
    def MsgId(self):
        r"""Message ID
        :rtype: str
        """
        return self._MsgId

    @MsgId.setter
    def MsgId(self, MsgId):
        self._MsgId = MsgId

    @property
    def MsgTag(self):
        r"""Message tag
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgTag

    @MsgTag.setter
    def MsgTag(self, MsgTag):
        self._MsgTag = MsgTag

    @property
    def MsgKey(self):
        r"""Message key.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MsgKey

    @MsgKey.setter
    def MsgKey(self, MsgKey):
        self._MsgKey = MsgKey

    @property
    def ProducerAddr(self):
        r"""Specifies the client ip address.
        :rtype: str
        """
        return self._ProducerAddr

    @ProducerAddr.setter
    def ProducerAddr(self, ProducerAddr):
        self._ProducerAddr = ProducerAddr

    @property
    def ProduceTime(self):
        r"""Message Sending Time
        :rtype: str
        """
        return self._ProduceTime

    @ProduceTime.setter
    def ProduceTime(self, ProduceTime):
        self._ProduceTime = ProduceTime

    @property
    def PulsarMsgId(self):
        r"""Pulsar Message ID
        :rtype: str
        """
        return self._PulsarMsgId

    @PulsarMsgId.setter
    def PulsarMsgId(self, PulsarMsgId):
        self._PulsarMsgId = PulsarMsgId

    @property
    def DeadLetterResendTimes(self):
        r"""Dead-letter resend count
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DeadLetterResendTimes

    @DeadLetterResendTimes.setter
    def DeadLetterResendTimes(self, DeadLetterResendTimes):
        self._DeadLetterResendTimes = DeadLetterResendTimes

    @property
    def ResendSuccessCount(self):
        r"""Dead Letter Resend Success Count
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ResendSuccessCount

    @ResendSuccessCount.setter
    def ResendSuccessCount(self, ResendSuccessCount):
        self._ResendSuccessCount = ResendSuccessCount


    def _deserialize(self, params):
        self._MsgId = params.get("MsgId")
        self._MsgTag = params.get("MsgTag")
        self._MsgKey = params.get("MsgKey")
        self._ProducerAddr = params.get("ProducerAddr")
        self._ProduceTime = params.get("ProduceTime")
        self._PulsarMsgId = params.get("PulsarMsgId")
        self._DeadLetterResendTimes = params.get("DeadLetterResendTimes")
        self._ResendSuccessCount = params.get("ResendSuccessCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQNamespace(AbstractModel):
    r"""RocketMQ namespace information

    """

    def __init__(self):
        r"""
        :param _NamespaceId: Namespace name, which can contain 3 - 64 letters, digits, hyphens, and underscores.
        :type NamespaceId: str
        :param _Ttl: Retention period for unconsumed messages in milliseconds. Valid range: 60 seconds - 15 days. This parameter is disused.
        :type Ttl: int
        :param _RetentionTime: Retention period for persistently stored messages in milliseconds.
        :type RetentionTime: int
        :param _Remark: Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _PublicEndpoint: Public network access point address.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublicEndpoint: str
        :param _VpcEndpoint: VPC access point address.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcEndpoint: str
        :param _InternalEndpoint: Internal access point address
Note: This field may return null, indicating that no valid values can be obtained.
        :type InternalEndpoint: str
        """
        self._NamespaceId = None
        self._Ttl = None
        self._RetentionTime = None
        self._Remark = None
        self._PublicEndpoint = None
        self._VpcEndpoint = None
        self._InternalEndpoint = None

    @property
    def NamespaceId(self):
        r"""Namespace name, which can contain 3 - 64 letters, digits, hyphens, and underscores.
        :rtype: str
        """
        return self._NamespaceId

    @NamespaceId.setter
    def NamespaceId(self, NamespaceId):
        self._NamespaceId = NamespaceId

    @property
    def Ttl(self):
        r"""Retention period for unconsumed messages in milliseconds. Valid range: 60 seconds - 15 days. This parameter is disused.
        :rtype: int
        """
        return self._Ttl

    @Ttl.setter
    def Ttl(self, Ttl):
        self._Ttl = Ttl

    @property
    def RetentionTime(self):
        r"""Retention period for persistently stored messages in milliseconds.
        :rtype: int
        """
        return self._RetentionTime

    @RetentionTime.setter
    def RetentionTime(self, RetentionTime):
        self._RetentionTime = RetentionTime

    @property
    def Remark(self):
        r"""Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PublicEndpoint(self):
        r"""Public network access point address.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PublicEndpoint

    @PublicEndpoint.setter
    def PublicEndpoint(self, PublicEndpoint):
        self._PublicEndpoint = PublicEndpoint

    @property
    def VpcEndpoint(self):
        r"""VPC access point address.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcEndpoint

    @VpcEndpoint.setter
    def VpcEndpoint(self, VpcEndpoint):
        self._VpcEndpoint = VpcEndpoint

    @property
    def InternalEndpoint(self):
        r"""Internal access point address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InternalEndpoint

    @InternalEndpoint.setter
    def InternalEndpoint(self, InternalEndpoint):
        self._InternalEndpoint = InternalEndpoint


    def _deserialize(self, params):
        self._NamespaceId = params.get("NamespaceId")
        self._Ttl = params.get("Ttl")
        self._RetentionTime = params.get("RetentionTime")
        self._Remark = params.get("Remark")
        self._PublicEndpoint = params.get("PublicEndpoint")
        self._VpcEndpoint = params.get("VpcEndpoint")
        self._InternalEndpoint = params.get("InternalEndpoint")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RocketMQSubscription(AbstractModel):
    r"""RocketMQ Consumer Group Subscription Information

    ""