# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.



from tencentcloud.common.abstract_client_async import AbstractClient
from tencentcloud.sts.v20180813 import models
from typing import Dict


class StsClient(AbstractClient):
    _apiVersion = '2018-08-13'
    _endpoint = 'sts.intl.tencentcloudapi.com'
    _service = 'sts'

    async def AssumeRole(
            self,
            request: models.AssumeRoleRequest,
            opts: Dict = None,
    ) -> models.AssumeRoleResponse:
        """
        This API is used to request for the temporary security credentials of a role.
        """
        
        kwargs = {}
        kwargs["action"] = "AssumeRole"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.AssumeRoleResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def AssumeRoleWithSAML(
            self,
            request: models.AssumeRoleWithSAMLRequest,
            opts: Dict = None,
    ) -> models.AssumeRoleWithSAMLResponse:
        """
        This API is used to request for the temporary credentials for a role that has been authenticated via a SAML assertion.
        """
        
        kwargs = {}
        kwargs["action"] = "AssumeRoleWithSAML"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.AssumeRoleWithSAMLResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def AssumeRoleWithWebIdentity(
            self,
            request: models.AssumeRoleWithWebIdentityRequest,
            opts: Dict = None,
    ) -> models.AssumeRoleWithWebIdentityResponse:
        """
        This API is used to apply for an OIDC role credential.
        """
        
        kwargs = {}
        kwargs["action"] = "AssumeRoleWithWebIdentity"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.AssumeRoleWithWebIdentityResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def GetCallerIdentity(
            self,
            request: models.GetCallerIdentityRequest,
            opts: Dict = None,
    ) -> models.GetCallerIdentityResponse:
        """
        This API is used to get the identity information of the current caller.
        The persistent keys of the root account and sub-account as well as the temporary credentials generated by `AssumeRole` and `GetFederationToken` can be used to get the identity information.
        """
        
        kwargs = {}
        kwargs["action"] = "GetCallerIdentity"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.GetCallerIdentityResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)
        
    async def GetFederationToken(
            self,
            request: models.GetFederationTokenRequest,
            opts: Dict = None,
    ) -> models.GetFederationTokenResponse:
        """
        This API is used to get temporary credentials for a federated user.
        """
        
        kwargs = {}
        kwargs["action"] = "GetFederationToken"
        kwargs["params"] = request._serialize()
        kwargs["resp_cls"] = models.GetFederationTokenResponse
        kwargs["headers"] = request.headers
        kwargs["opts"] = opts or {}
        
        return await self.call_and_deserialize(**kwargs)