# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class CreateLibraryRequest(AbstractModel):
    r"""CreateLibrary request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Media library name. up to 50 characters.
        :type Name: str
        :param _Remark: Specifies the remark, up to 250 characters.
        :type Remark: str
        :param _BucketName: Specifies the full name of the bucket, which cannot be changed after creation. the current version no longer supports specified buckets.
        :type BucketName: str
        :param _BucketRegion: Bucket location cannot be changed after creation. the current version no longer supports specifying bucket location.
        :type BucketRegion: str
        :param _LibraryExtension: Media library configuration item. some parameters cannot be changed after creation.
        :type LibraryExtension: :class:`tencentcloud.smh.v20210712.models.LibraryExtension`
        """
        self._Name = None
        self._Remark = None
        self._BucketName = None
        self._BucketRegion = None
        self._LibraryExtension = None

    @property
    def Name(self):
        r"""Media library name. up to 50 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Specifies the remark, up to 250 characters.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def BucketName(self):
        r"""Specifies the full name of the bucket, which cannot be changed after creation. the current version no longer supports specified buckets.
        :rtype: str
        """
        return self._BucketName

    @BucketName.setter
    def BucketName(self, BucketName):
        self._BucketName = BucketName

    @property
    def BucketRegion(self):
        r"""Bucket location cannot be changed after creation. the current version no longer supports specifying bucket location.
        :rtype: str
        """
        return self._BucketRegion

    @BucketRegion.setter
    def BucketRegion(self, BucketRegion):
        self._BucketRegion = BucketRegion

    @property
    def LibraryExtension(self):
        r"""Media library configuration item. some parameters cannot be changed after creation.
        :rtype: :class:`tencentcloud.smh.v20210712.models.LibraryExtension`
        """
        return self._LibraryExtension

    @LibraryExtension.setter
    def LibraryExtension(self, LibraryExtension):
        self._LibraryExtension = LibraryExtension


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        self._BucketName = params.get("BucketName")
        self._BucketRegion = params.get("BucketRegion")
        if params.get("LibraryExtension") is not None:
            self._LibraryExtension = LibraryExtension()
            self._LibraryExtension._deserialize(params.get("LibraryExtension"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLibraryResponse(AbstractModel):
    r"""CreateLibrary response structure.

    """

    def __init__(self):
        r"""
        :param _LibraryId: Media library ID.
        :type LibraryId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LibraryId = None
        self._RequestId = None

    @property
    def LibraryId(self):
        r"""Media library ID.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LibraryId = params.get("LibraryId")
        self._RequestId = params.get("RequestId")


class DeleteLibraryRequest(AbstractModel):
    r"""DeleteLibrary request structure.

    """

    def __init__(self):
        r"""
        :param _LibraryId: Media library ID.
        :type LibraryId: str
        """
        self._LibraryId = None

    @property
    def LibraryId(self):
        r"""Media library ID.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId


    def _deserialize(self, params):
        self._LibraryId = params.get("LibraryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLibraryResponse(AbstractModel):
    r"""DeleteLibrary response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeLibrariesRequest(AbstractModel):
    r"""DescribeLibraries request structure.

    """

    def __init__(self):
        r"""
        :param _LibraryIds: Specifies one or more media library ids for querying, with a maximum of 100 per request.
        :type LibraryIds: list of str
        :param _PageNumber: Page number, int, used in conjunction with PageSize. default value is 1.
        :type PageNumber: int
        :param _PageSize: Number of items per page, integer, used in conjunction with PageNumber. default value is 20. maximum value is 100.
        :type PageSize: int
        """
        self._LibraryIds = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def LibraryIds(self):
        r"""Specifies one or more media library ids for querying, with a maximum of 100 per request.
        :rtype: list of str
        """
        return self._LibraryIds

    @LibraryIds.setter
    def LibraryIds(self, LibraryIds):
        self._LibraryIds = LibraryIds

    @property
    def PageNumber(self):
        r"""Page number, int, used in conjunction with PageSize. default value is 1.
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        r"""Number of items per page, integer, used in conjunction with PageNumber. default value is 20. maximum value is 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._LibraryIds = params.get("LibraryIds")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLibrariesResponse(AbstractModel):
    r"""DescribeLibraries response structure.

    """

    def __init__(self):
        r"""
        :param _List: Library list.
        :type List: list of Library
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        r"""Library list.
        :rtype: list of Library
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = Library()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLibrarySecretRequest(AbstractModel):
    r"""DescribeLibrarySecret request structure.

    """

    def __init__(self):
        r"""
        :param _LibraryId: Media library ID.
        :type LibraryId: str
        """
        self._LibraryId = None

    @property
    def LibraryId(self):
        r"""Media library ID.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId


    def _deserialize(self, params):
        self._LibraryId = params.get("LibraryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLibrarySecretResponse(AbstractModel):
    r"""DescribeLibrarySecret response structure.

    """

    def __init__(self):
        r"""
        :param _LibraryId: Specifies the media library ID to query.
        :type LibraryId: str
        :param _LibrarySecret: Queried media library key.
        :type LibrarySecret: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LibraryId = None
        self._LibrarySecret = None
        self._RequestId = None

    @property
    def LibraryId(self):
        r"""Specifies the media library ID to query.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId

    @property
    def LibrarySecret(self):
        r"""Queried media library key.
        :rtype: str
        """
        return self._LibrarySecret

    @LibrarySecret.setter
    def LibrarySecret(self, LibrarySecret):
        self._LibrarySecret = LibrarySecret

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LibraryId = params.get("LibraryId")
        self._LibrarySecret = params.get("LibrarySecret")
        self._RequestId = params.get("RequestId")


class DescribeOfficialInstancesRequest(AbstractModel):
    r"""DescribeOfficialInstances request structure.

    """

    def __init__(self):
        r"""
        :param _SuperAdminAccount: Specifies whether to query the super admin account bound to the instance. default value is false.
        :type SuperAdminAccount: bool
        :param _InstanceIds: Specifies one or more instance ids for querying, with a maximum of 100 per request.
        :type InstanceIds: list of str
        :param _PageNumber: Page number, int, used in conjunction with PageSize. default value is 1.
        :type PageNumber: int
        :param _PageSize: Number of items per page, integer, used in conjunction with PageNumber. default value is 20. maximum value is 100.
        :type PageSize: int
        :param _OrderBy: Specifies the column to sort.
        :type OrderBy: str
        :param _OrderByType: Sorting method.
        :type OrderByType: str
        :param _AutoRenew: Specifies the filter type for renewal management.
        :type AutoRenew: int
        :param _BindPhone: Specifies whether the super admin account is bound to a mobile number.
        :type BindPhone: bool
        """
        self._SuperAdminAccount = None
        self._InstanceIds = None
        self._PageNumber = None
        self._PageSize = None
        self._OrderBy = None
        self._OrderByType = None
        self._AutoRenew = None
        self._BindPhone = None

    @property
    def SuperAdminAccount(self):
        r"""Specifies whether to query the super admin account bound to the instance. default value is false.
        :rtype: bool
        """
        return self._SuperAdminAccount

    @SuperAdminAccount.setter
    def SuperAdminAccount(self, SuperAdminAccount):
        self._SuperAdminAccount = SuperAdminAccount

    @property
    def InstanceIds(self):
        r"""Specifies one or more instance ids for querying, with a maximum of 100 per request.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def PageNumber(self):
        r"""Page number, int, used in conjunction with PageSize. default value is 1.
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        r"""Number of items per page, integer, used in conjunction with PageNumber. default value is 20. maximum value is 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderBy(self):
        r"""Specifies the column to sort.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting method.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def AutoRenew(self):
        r"""Specifies the filter type for renewal management.
        :rtype: int
        """
        return self._AutoRenew

    @AutoRenew.setter
    def AutoRenew(self, AutoRenew):
        self._AutoRenew = AutoRenew

    @property
    def BindPhone(self):
        r"""Specifies whether the super admin account is bound to a mobile number.
        :rtype: bool
        """
        return self._BindPhone

    @BindPhone.setter
    def BindPhone(self, BindPhone):
        self._BindPhone = BindPhone


    def _deserialize(self, params):
        self._SuperAdminAccount = params.get("SuperAdminAccount")
        self._InstanceIds = params.get("InstanceIds")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        self._AutoRenew = params.get("AutoRenew")
        self._BindPhone = params.get("BindPhone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOfficialInstancesResponse(AbstractModel):
    r"""DescribeOfficialInstances response structure.

    """

    def __init__(self):
        r"""
        :param _List: Instance list
        :type List: list of Instance
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        r"""Instance list
        :rtype: list of Instance
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = Instance()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeOfficialOverviewRequest(AbstractModel):
    r"""DescribeOfficialOverview request structure.

    """


class DescribeOfficialOverviewResponse(AbstractModel):
    r"""DescribeOfficialOverview response structure.

    """

    def __init__(self):
        r"""
        :param _Quantity: Specifies the instance count of cloud disks.
        :type Quantity: int
        :param _Storage: Indicates the total storage already used in Bytes. since the number type has precision limitations, this field is a String type.
        :type Storage: str
        :param _UserCount: Total number of users already allocated and used.
        :type UserCount: int
        :param _InternetTraffic: Public network downstream traffic this month in Bytes. since the number type has precision limitations, this field is a String type.
        :type InternetTraffic: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Quantity = None
        self._Storage = None
        self._UserCount = None
        self._InternetTraffic = None
        self._RequestId = None

    @property
    def Quantity(self):
        r"""Specifies the instance count of cloud disks.
        :rtype: int
        """
        return self._Quantity

    @Quantity.setter
    def Quantity(self, Quantity):
        self._Quantity = Quantity

    @property
    def Storage(self):
        r"""Indicates the total storage already used in Bytes. since the number type has precision limitations, this field is a String type.
        :rtype: str
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def UserCount(self):
        r"""Total number of users already allocated and used.
        :rtype: int
        """
        return self._UserCount

    @UserCount.setter
    def UserCount(self, UserCount):
        self._UserCount = UserCount

    @property
    def InternetTraffic(self):
        r"""Public network downstream traffic this month in Bytes. since the number type has precision limitations, this field is a String type.
        :rtype: str
        """
        return self._InternetTraffic

    @InternetTraffic.setter
    def InternetTraffic(self, InternetTraffic):
        self._InternetTraffic = InternetTraffic

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Quantity = params.get("Quantity")
        self._Storage = params.get("Storage")
        self._UserCount = params.get("UserCount")
        self._InternetTraffic = params.get("InternetTraffic")
        self._RequestId = params.get("RequestId")


class DescribeTrafficPackagesRequest(AbstractModel):
    r"""DescribeTrafficPackages request structure.

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Specifies one or more resource ids for querying, with a maximum of 100 per request.
        :type ResourceIds: list of str
        :param _PageNumber: Page number, int, used in conjunction with PageSize. default value is 1.
        :type PageNumber: int
        :param _PageSize: Number of items per page, integer, used in conjunction with PageNumber. default value is 20. maximum value is 100.
        :type PageSize: int
        :param _OrderBy: Specifies the column to sort.
        :type OrderBy: str
        :param _OrderByType: Sorting method.
        :type OrderByType: str
        :param _Type: Specifies the source type filter criteria.
        :type Type: int
        """
        self._ResourceIds = None
        self._PageNumber = None
        self._PageSize = None
        self._OrderBy = None
        self._OrderByType = None
        self._Type = None

    @property
    def ResourceIds(self):
        r"""Specifies one or more resource ids for querying, with a maximum of 100 per request.
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def PageNumber(self):
        r"""Page number, int, used in conjunction with PageSize. default value is 1.
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        r"""Number of items per page, integer, used in conjunction with PageNumber. default value is 20. maximum value is 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderBy(self):
        r"""Specifies the column to sort.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting method.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def Type(self):
        r"""Specifies the source type filter criteria.
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrafficPackagesResponse(AbstractModel):
    r"""DescribeTrafficPackages response structure.

    """

    def __init__(self):
        r"""
        :param _List: Package list.
        :type List: list of TrafficPackage
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        r"""Package list.
        :rtype: list of TrafficPackage
        """
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = TrafficPackage()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class Instance(AbstractModel):
    r"""Describes official cloud disk instance information.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _Domain: Dedicated domain name. if the instance has no dedicated domain name, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _EffectiveTime: Effective time.
        :type EffectiveTime: str
        :param _ExpireTime: Expiration time. if the instance is pay-as-you-go or permanently valid, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpireTime: str
        :param _UserLimit: Number of users. if the instance uses pay-as-you-go billing or has unlimited users, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserLimit: int
        :param _StorageLimit: Storage capacity in Bytes. this field is of String type due to precision limitations of numeric types. this property is null for pay-as-you-go instances or instances with unlimited storage capacity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StorageLimit: str
        :param _StorageLimitGB: Storage capacity in GB. if the instance uses pay-as-you-go billing or has unlimited storage capacity, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StorageLimitGB: int
        :param _Isolated: Is expired isolation.
        :type Isolated: bool
        :param _AutoRenew: Renewal flag. 0: manual renewal; 1: automatic renewal; 2: non-renewal upon expiration.
        :type AutoRenew: int
        :param _SuperAdminAccount: Specifies the super administrator account. if no selection query is made for the instance-bound super administrator account or the current instance is not bound to a super administrator account, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuperAdminAccount: str
        :param _Bucket: In selected bucket mode, shows bucket usage.
        :type Bucket: str
        :param _LogBucket: Specifies the log bucket usage in selected mode.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogBucket: str
        """
        self._InstanceId = None
        self._Domain = None
        self._EffectiveTime = None
        self._ExpireTime = None
        self._UserLimit = None
        self._StorageLimit = None
        self._StorageLimitGB = None
        self._Isolated = None
        self._AutoRenew = None
        self._SuperAdminAccount = None
        self._Bucket = None
        self._LogBucket = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Domain(self):
        r"""Dedicated domain name. if the instance has no dedicated domain name, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def EffectiveTime(self):
        r"""Effective time.
        :rtype: str
        """
        return self._EffectiveTime

    @EffectiveTime.setter
    def EffectiveTime(self, EffectiveTime):
        self._EffectiveTime = EffectiveTime

    @property
    def ExpireTime(self):
        r"""Expiration time. if the instance is pay-as-you-go or permanently valid, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def UserLimit(self):
        r"""Number of users. if the instance uses pay-as-you-go billing or has unlimited users, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UserLimit

    @UserLimit.setter
    def UserLimit(self, UserLimit):
        self._UserLimit = UserLimit

    @property
    def StorageLimit(self):
        r"""Storage capacity in Bytes. this field is of String type due to precision limitations of numeric types. this property is null for pay-as-you-go instances or instances with unlimited storage capacity.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def StorageLimitGB(self):
        r"""Storage capacity in GB. if the instance uses pay-as-you-go billing or has unlimited storage capacity, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StorageLimitGB

    @StorageLimitGB.setter
    def StorageLimitGB(self, StorageLimitGB):
        self._StorageLimitGB = StorageLimitGB

    @property
    def Isolated(self):
        r"""Is expired isolation.
        :rtype: bool
        """
        return self._Isolated

    @Isolated.setter
    def Isolated(self, Isolated):
        self._Isolated = Isolated

    @property
    def AutoRenew(self):
        r"""Renewal flag. 0: manual renewal; 1: automatic renewal; 2: non-renewal upon expiration.
        :rtype: int
        """
        return self._AutoRenew

    @AutoRenew.setter
    def AutoRenew(self, AutoRenew):
        self._AutoRenew = AutoRenew

    @property
    def SuperAdminAccount(self):
        r"""Specifies the super administrator account. if no selection query is made for the instance-bound super administrator account or the current instance is not bound to a super administrator account, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SuperAdminAccount

    @SuperAdminAccount.setter
    def SuperAdminAccount(self, SuperAdminAccount):
        self._SuperAdminAccount = SuperAdminAccount

    @property
    def Bucket(self):
        r"""In selected bucket mode, shows bucket usage.
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def LogBucket(self):
        r"""Specifies the log bucket usage in selected mode.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LogBucket

    @LogBucket.setter
    def LogBucket(self, LogBucket):
        self._LogBucket = LogBucket


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Domain = params.get("Domain")
        self._EffectiveTime = params.get("EffectiveTime")
        self._ExpireTime = params.get("ExpireTime")
        self._UserLimit = params.get("UserLimit")
        self._StorageLimit = params.get("StorageLimit")
        self._StorageLimitGB = params.get("StorageLimitGB")
        self._Isolated = params.get("Isolated")
        self._AutoRenew = params.get("AutoRenew")
        self._SuperAdminAccount = params.get("SuperAdminAccount")
        self._Bucket = params.get("Bucket")
        self._LogBucket = params.get("LogBucket")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Library(AbstractModel):
    r"""PaaS service media library information.

    """

    def __init__(self):
        r"""
        :param _LibraryId: Media library ID.
        :type LibraryId: str
        :param _Name: Specifies the friendly name of the media library.
        :type Name: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _BucketName: Specifies the COS storage bucket bound to the media library.
        :type BucketName: str
        :param _BucketRegion: Specifies the region where the COS bucket bound to the media library is located.
        :type BucketRegion: str
        :param _AccessDomain: Specifies the access domain of the business API for the media library.
        :type AccessDomain: str
        :param _CreationTime: Creation time of the media library.
        :type CreationTime: str
        :param _LibraryExtension: Media library configuration item.
        :type LibraryExtension: :class:`tencentcloud.smh.v20210712.models.LibraryExtension`
        :param _Size: Media library amount in Bytes. since the number type has precision limitations, this field is a String type.
        :type Size: str
        :param _DirNum: Number of media library directories. since the String type is used due to precision limitations of the number type, this field is of String type.
        :type DirNum: str
        :param _FileNum: Number of files in the media library. since the String type is used due to precision limitations of the number type, this field is of String type.
        :type FileNum: str
        """
        self._LibraryId = None
        self._Name = None
        self._Remark = None
        self._BucketName = None
        self._BucketRegion = None
        self._AccessDomain = None
        self._CreationTime = None
        self._LibraryExtension = None
        self._Size = None
        self._DirNum = None
        self._FileNum = None

    @property
    def LibraryId(self):
        r"""Media library ID.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId

    @property
    def Name(self):
        r"""Specifies the friendly name of the media library.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def BucketName(self):
        r"""Specifies the COS storage bucket bound to the media library.
        :rtype: str
        """
        return self._BucketName

    @BucketName.setter
    def BucketName(self, BucketName):
        self._BucketName = BucketName

    @property
    def BucketRegion(self):
        r"""Specifies the region where the COS bucket bound to the media library is located.
        :rtype: str
        """
        return self._BucketRegion

    @BucketRegion.setter
    def BucketRegion(self, BucketRegion):
        self._BucketRegion = BucketRegion

    @property
    def AccessDomain(self):
        r"""Specifies the access domain of the business API for the media library.
        :rtype: str
        """
        return self._AccessDomain

    @AccessDomain.setter
    def AccessDomain(self, AccessDomain):
        self._AccessDomain = AccessDomain

    @property
    def CreationTime(self):
        r"""Creation time of the media library.
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def LibraryExtension(self):
        r"""Media library configuration item.
        :rtype: :class:`tencentcloud.smh.v20210712.models.LibraryExtension`
        """
        return self._LibraryExtension

    @LibraryExtension.setter
    def LibraryExtension(self, LibraryExtension):
        self._LibraryExtension = LibraryExtension

    @property
    def Size(self):
        r"""Media library amount in Bytes. since the number type has precision limitations, this field is a String type.
        :rtype: str
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def DirNum(self):
        r"""Number of media library directories. since the String type is used due to precision limitations of the number type, this field is of String type.
        :rtype: str
        """
        return self._DirNum

    @DirNum.setter
    def DirNum(self, DirNum):
        self._DirNum = DirNum

    @property
    def FileNum(self):
        r"""Number of files in the media library. since the String type is used due to precision limitations of the number type, this field is of String type.
        :rtype: str
        """
        return self._FileNum

    @FileNum.setter
    def FileNum(self, FileNum):
        self._FileNum = FileNum


    def _deserialize(self, params):
        self._LibraryId = params.get("LibraryId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        self._BucketName = params.get("BucketName")
        self._BucketRegion = params.get("BucketRegion")
        self._AccessDomain = params.get("AccessDomain")
        self._CreationTime = params.get("CreationTime")
        if params.get("LibraryExtension") is not None:
            self._LibraryExtension = LibraryExtension()
            self._LibraryExtension._deserialize(params.get("LibraryExtension"))
        self._Size = params.get("Size")
        self._DirNum = params.get("DirNum")
        self._FileNum = params.get("FileNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LibraryExtension(AbstractModel):
    r"""Media library configuration item.

    """

    def __init__(self):
        r"""
        :param _IsFileLibrary: Specifies whether it is a file type media library that can store any type of file (true) or a media type media library that can only store images and playable video types (false). defaults to false. cannot be modified once created.
        :type IsFileLibrary: bool
        :param _IsMultiSpace: true indicates a multi-tenant space media library, allowing the creation of multiple tenant spaces. false indicates a single-tenant space media library, where tenant spaces cannot be created and only the default single tenant space can be used. defaults to false. cannot be modified after the media library is created.
        :type IsMultiSpace: bool
        :param _CosStorageClass: Specifies the storage type for files saved to cloud object storage. valid values: STANDARD, STANDARD_IA, INTELLIGENT_TIERING, MAZ_STANDARD, MAZ_STANDARD_IA, and MAZ_INTELLIGENT_TIERING. defaults to STANDARD. when using a multi-AZ bucket, MAZ_ prefixed storage types for multi-AZ are automatically used, otherwise non-MAZ_ prefixed storage types for non-multi-AZ are used. when specifying INTELLIGENT TIERING storage INTELLIGENT_TIERING or MAZ_INTELLIGENT_TIERING, the bucket must have INTELLIGENT TIERING storage enabled beforehand, otherwise failure will be returned. cannot be modified after the media library is created.
        :type CosStorageClass: str
        :param _UseRecycleBin: Specifies whether the recycle bin feature is enabled. defaults to false.
        :type UseRecycleBin: bool
        :param _AutoRemoveRecycledDays: Specifies the number of days to automatically delete items in the recycle bin when enabled, must not exceed 1095 (3 years). a value of 0 indicates no automatic deletion, defaults to 0. this property is null when the recycle bin is not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AutoRemoveRecycledDays: int
        :param _EnableSearch: Whether to enable the file path search feature. is false by default.
        :type EnableSearch: bool
        :param _DenyOnQuotaLessThanUsage: Specifies whether to deny the configuration request when setting the space quota for a media library or tenant and the quota is less than the used storage capacity. is false by default.
        :type DenyOnQuotaLessThanUsage: bool
        :param _EnableFileHistory: Specifies whether the earlier version is enabled. defaults to false.
        :type EnableFileHistory: bool
        :param _FileHistoryCount: Specifies the maximum number of historical versions to retain for a single file when versioning is enabled, with a value range of 1 to 999. this property may be null when versioning is not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileHistoryCount: int
        :param _FileHistoryExpireDay: Specifies the maximum days to retain earlier versions when versioning is enabled, with a value range of 0 to 999. when set to 0, it represents permanent retention. this property may be null when versioning is not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileHistoryExpireDay: int
        :param _MaxDirFileNameLength: The maximum length of a directory or file name must not exceed 255, with a default value of 255. modifying this parameter will not affect existing directories or file names. if the value of this field is decreased, the length of existing directories or file names exceeding the target value does not change.
        :type MaxDirFileNameLength: int
        :param _IsPublicRead: Whether public read is enabled. once enabled, read operations require no access token. it is false by default. this property is supported only in single-tenant space media libraries. otherwise, it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsPublicRead: bool
        :param _IsMultiAlbum: Specifies whether the multi-album feature is enabled for the media type media library. once enabled, first-level directories (albums) can be created, and media files can only be saved in these albums. unless enabled, albums cannot be created, and media files can only be saved in the root directory. defaults to false. this property is only supported for single-tenant space media type media libraries, otherwise it is null. cannot be modified after the media library is created.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsMultiAlbum: bool
        :param _AllowPhoto: Specifies whether the media library of the media type allows image uploads, set to true by default. this property is supported only for the media library of the media type in a single tenant space, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AllowPhoto: bool
        :param _AllowPhotoExtName: Specifies the allowed extensions when the media type media library allows photo uploads. empty array by default. at this point, it will automatically determine based on the MIME type corresponding to the file extension. this property is supported only for single-tenant space media type media libraries. otherwise, the property is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AllowPhotoExtName: list of str
        :param _AllowVideo: Media type media library specifies whether video upload is allowed, set to true by default. this property is supported only in single tenant space media type media library, otherwise the property is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AllowVideo: bool
        :param _AllowVideoExtName: Specifies the allowed extensions when the media type media library permits video uploads. the default is an empty array, at which point it will automatically determine based on the MIME type corresponding to the file extension. this property is supported only for single-tenant space media type media libraries, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AllowVideoExtName: list of str
        :param _AllowFileExtName: Specifies the file extensions allowed in the file type media library, empty by default. at this point, all types of files are upload allowed. this property is supported only for the file type media library in a single tenant space, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AllowFileExtName: list of str
        :param _RecognizeSensitiveContent: Specifies whether to perform sensitive content identification during image upload. the value is false by default. this property is supported only in the single-tenant space media library, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecognizeSensitiveContent: bool
        """
        self._IsFileLibrary = None
        self._IsMultiSpace = None
        self._CosStorageClass = None
        self._UseRecycleBin = None
        self._AutoRemoveRecycledDays = None
        self._EnableSearch = None
        self._DenyOnQuotaLessThanUsage = None
        self._EnableFileHistory = None
        self._FileHistoryCount = None
        self._FileHistoryExpireDay = None
        self._MaxDirFileNameLength = None
        self._IsPublicRead = None
        self._IsMultiAlbum = None
        self._AllowPhoto = None
        self._AllowPhotoExtName = None
        self._AllowVideo = None
        self._AllowVideoExtName = None
        self._AllowFileExtName = None
        self._RecognizeSensitiveContent = None

    @property
    def IsFileLibrary(self):
        r"""Specifies whether it is a file type media library that can store any type of file (true) or a media type media library that can only store images and playable video types (false). defaults to false. cannot be modified once created.
        :rtype: bool
        """
        return self._IsFileLibrary

    @IsFileLibrary.setter
    def IsFileLibrary(self, IsFileLibrary):
        self._IsFileLibrary = IsFileLibrary

    @property
    def IsMultiSpace(self):
        r"""true indicates a multi-tenant space media library, allowing the creation of multiple tenant spaces. false indicates a single-tenant space media library, where tenant spaces cannot be created and only the default single tenant space can be used. defaults to false. cannot be modified after the media library is created.
        :rtype: bool
        """
        return self._IsMultiSpace

    @IsMultiSpace.setter
    def IsMultiSpace(self, IsMultiSpace):
        self._IsMultiSpace = IsMultiSpace

    @property
    def CosStorageClass(self):
        r"""Specifies the storage type for files saved to cloud object storage. valid values: STANDARD, STANDARD_IA, INTELLIGENT_TIERING, MAZ_STANDARD, MAZ_STANDARD_IA, and MAZ_INTELLIGENT_TIERING. defaults to STANDARD. when using a multi-AZ bucket, MAZ_ prefixed storage types for multi-AZ are automatically used, otherwise non-MAZ_ prefixed storage types for non-multi-AZ are used. when specifying INTELLIGENT TIERING storage INTELLIGENT_TIERING or MAZ_INTELLIGENT_TIERING, the bucket must have INTELLIGENT TIERING storage enabled beforehand, otherwise failure will be returned. cannot be modified after the media library is created.
        :rtype: str
        """
        return self._CosStorageClass

    @CosStorageClass.setter
    def CosStorageClass(self, CosStorageClass):
        self._CosStorageClass = CosStorageClass

    @property
    def UseRecycleBin(self):
        r"""Specifies whether the recycle bin feature is enabled. defaults to false.
        :rtype: bool
        """
        return self._UseRecycleBin

    @UseRecycleBin.setter
    def UseRecycleBin(self, UseRecycleBin):
        self._UseRecycleBin = UseRecycleBin

    @property
    def AutoRemoveRecycledDays(self):
        r"""Specifies the number of days to automatically delete items in the recycle bin when enabled, must not exceed 1095 (3 years). a value of 0 indicates no automatic deletion, defaults to 0. this property is null when the recycle bin is not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AutoRemoveRecycledDays

    @AutoRemoveRecycledDays.setter
    def AutoRemoveRecycledDays(self, AutoRemoveRecycledDays):
        self._AutoRemoveRecycledDays = AutoRemoveRecycledDays

    @property
    def EnableSearch(self):
        r"""Whether to enable the file path search feature. is false by default.
        :rtype: bool
        """
        return self._EnableSearch

    @EnableSearch.setter
    def EnableSearch(self, EnableSearch):
        self._EnableSearch = EnableSearch

    @property
    def DenyOnQuotaLessThanUsage(self):
        r"""Specifies whether to deny the configuration request when setting the space quota for a media library or tenant and the quota is less than the used storage capacity. is false by default.
        :rtype: bool
        """
        return self._DenyOnQuotaLessThanUsage

    @DenyOnQuotaLessThanUsage.setter
    def DenyOnQuotaLessThanUsage(self, DenyOnQuotaLessThanUsage):
        self._DenyOnQuotaLessThanUsage = DenyOnQuotaLessThanUsage

    @property
    def EnableFileHistory(self):
        r"""Specifies whether the earlier version is enabled. defaults to false.
        :rtype: bool
        """
        return self._EnableFileHistory

    @EnableFileHistory.setter
    def EnableFileHistory(self, EnableFileHistory):
        self._EnableFileHistory = EnableFileHistory

    @property
    def FileHistoryCount(self):
        r"""Specifies the maximum number of historical versions to retain for a single file when versioning is enabled, with a value range of 1 to 999. this property may be null when versioning is not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._FileHistoryCount

    @FileHistoryCount.setter
    def FileHistoryCount(self, FileHistoryCount):
        self._FileHistoryCount = FileHistoryCount

    @property
    def FileHistoryExpireDay(self):
        r"""Specifies the maximum days to retain earlier versions when versioning is enabled, with a value range of 0 to 999. when set to 0, it represents permanent retention. this property may be null when versioning is not enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._FileHistoryExpireDay

    @FileHistoryExpireDay.setter
    def FileHistoryExpireDay(self, FileHistoryExpireDay):
        self._FileHistoryExpireDay = FileHistoryExpireDay

    @property
    def MaxDirFileNameLength(self):
        r"""The maximum length of a directory or file name must not exceed 255, with a default value of 255. modifying this parameter will not affect existing directories or file names. if the value of this field is decreased, the length of existing directories or file names exceeding the target value does not change.
        :rtype: int
        """
        return self._MaxDirFileNameLength

    @MaxDirFileNameLength.setter
    def MaxDirFileNameLength(self, MaxDirFileNameLength):
        self._MaxDirFileNameLength = MaxDirFileNameLength

    @property
    def IsPublicRead(self):
        r"""Whether public read is enabled. once enabled, read operations require no access token. it is false by default. this property is supported only in single-tenant space media libraries. otherwise, it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsPublicRead

    @IsPublicRead.setter
    def IsPublicRead(self, IsPublicRead):
        self._IsPublicRead = IsPublicRead

    @property
    def IsMultiAlbum(self):
        r"""Specifies whether the multi-album feature is enabled for the media type media library. once enabled, first-level directories (albums) can be created, and media files can only be saved in these albums. unless enabled, albums cannot be created, and media files can only be saved in the root directory. defaults to false. this property is only supported for single-tenant space media type media libraries, otherwise it is null. cannot be modified after the media library is created.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsMultiAlbum

    @IsMultiAlbum.setter
    def IsMultiAlbum(self, IsMultiAlbum):
        self._IsMultiAlbum = IsMultiAlbum

    @property
    def AllowPhoto(self):
        r"""Specifies whether the media library of the media type allows image uploads, set to true by default. this property is supported only for the media library of the media type in a single tenant space, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AllowPhoto

    @AllowPhoto.setter
    def AllowPhoto(self, AllowPhoto):
        self._AllowPhoto = AllowPhoto

    @property
    def AllowPhotoExtName(self):
        r"""Specifies the allowed extensions when the media type media library allows photo uploads. empty array by default. at this point, it will automatically determine based on the MIME type corresponding to the file extension. this property is supported only for single-tenant space media type media libraries. otherwise, the property is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._AllowPhotoExtName

    @AllowPhotoExtName.setter
    def AllowPhotoExtName(self, AllowPhotoExtName):
        self._AllowPhotoExtName = AllowPhotoExtName

    @property
    def AllowVideo(self):
        r"""Media type media library specifies whether video upload is allowed, set to true by default. this property is supported only in single tenant space media type media library, otherwise the property is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._AllowVideo

    @AllowVideo.setter
    def AllowVideo(self, AllowVideo):
        self._AllowVideo = AllowVideo

    @property
    def AllowVideoExtName(self):
        r"""Specifies the allowed extensions when the media type media library permits video uploads. the default is an empty array, at which point it will automatically determine based on the MIME type corresponding to the file extension. this property is supported only for single-tenant space media type media libraries, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._AllowVideoExtName

    @AllowVideoExtName.setter
    def AllowVideoExtName(self, AllowVideoExtName):
        self._AllowVideoExtName = AllowVideoExtName

    @property
    def AllowFileExtName(self):
        r"""Specifies the file extensions allowed in the file type media library, empty by default. at this point, all types of files are upload allowed. this property is supported only for the file type media library in a single tenant space, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._AllowFileExtName

    @AllowFileExtName.setter
    def AllowFileExtName(self, AllowFileExtName):
        self._AllowFileExtName = AllowFileExtName

    @property
    def RecognizeSensitiveContent(self):
        r"""Specifies whether to perform sensitive content identification during image upload. the value is false by default. this property is supported only in the single-tenant space media library, otherwise it is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._RecognizeSensitiveContent

    @RecognizeSensitiveContent.setter
    def RecognizeSensitiveContent(self, RecognizeSensitiveContent):
        self._RecognizeSensitiveContent = RecognizeSensitiveContent


    def _deserialize(self, params):
        self._IsFileLibrary = params.get("IsFileLibrary")
        self._IsMultiSpace = params.get("IsMultiSpace")
        self._CosStorageClass = params.get("CosStorageClass")
        self._UseRecycleBin = params.get("UseRecycleBin")
        self._AutoRemoveRecycledDays = params.get("AutoRemoveRecycledDays")
        self._EnableSearch = params.get("EnableSearch")
        self._DenyOnQuotaLessThanUsage = params.get("DenyOnQuotaLessThanUsage")
        self._EnableFileHistory = params.get("EnableFileHistory")
        self._FileHistoryCount = params.get("FileHistoryCount")
        self._FileHistoryExpireDay = params.get("FileHistoryExpireDay")
        self._MaxDirFileNameLength = params.get("MaxDirFileNameLength")
        self._IsPublicRead = params.get("IsPublicRead")
        self._IsMultiAlbum = params.get("IsMultiAlbum")
        self._AllowPhoto = params.get("AllowPhoto")
        self._AllowPhotoExtName = params.get("AllowPhotoExtName")
        self._AllowVideo = params.get("AllowVideo")
        self._AllowVideoExtName = params.get("AllowVideoExtName")
        self._AllowFileExtName = params.get("AllowFileExtName")
        self._RecognizeSensitiveContent = params.get("RecognizeSensitiveContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLibraryRequest(AbstractModel):
    r"""ModifyLibrary request structure.

    """

    def __init__(self):
        r"""
        :param _LibraryId: Media library ID.
        :type LibraryId: str
        :param _Name: Media library name. up to 50 characters. leave empty to keep the current value.
        :type Name: str
        :param _Remark: Specifies the remark, up to 250 characters. leave it empty to keep the original value.
        :type Remark: str
        :param _LibraryExtension: Media library configuration item. some parameters cannot be changed after creation and only modify passed parameters. if this parameter is not passed, no configuration item will be modified.
        :type LibraryExtension: :class:`tencentcloud.smh.v20210712.models.LibraryExtension`
        """
        self._LibraryId = None
        self._Name = None
        self._Remark = None
        self._LibraryExtension = None

    @property
    def LibraryId(self):
        r"""Media library ID.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId

    @property
    def Name(self):
        r"""Media library name. up to 50 characters. leave empty to keep the current value.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Specifies the remark, up to 250 characters. leave it empty to keep the original value.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def LibraryExtension(self):
        r"""Media library configuration item. some parameters cannot be changed after creation and only modify passed parameters. if this parameter is not passed, no configuration item will be modified.
        :rtype: :class:`tencentcloud.smh.v20210712.models.LibraryExtension`
        """
        return self._LibraryExtension

    @LibraryExtension.setter
    def LibraryExtension(self, LibraryExtension):
        self._LibraryExtension = LibraryExtension


    def _deserialize(self, params):
        self._LibraryId = params.get("LibraryId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        if params.get("LibraryExtension") is not None:
            self._LibraryExtension = LibraryExtension()
            self._LibraryExtension._deserialize(params.get("LibraryExtension"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLibraryResponse(AbstractModel):
    r"""ModifyLibrary response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SendSmsCodeRequest(AbstractModel):
    r"""SendSmsCode request structure.

    """

    def __init__(self):
        r"""
        :param _Purpose: Captcha target, currently supported: rebind super administrator account, BindSuperAdmin; trial version business upgrade, ChannelUpdateVerify.
        :type Purpose: str
        :param _PhoneNumber: Specifies the mobile number as the super admin account.
        :type PhoneNumber: str
        :param _InstanceId: Official cloud disk instance ID.
        :type InstanceId: str
        :param _CountryCode: Specifies the country code of the mobile number that serves as the super administrator account. defaults to +86.
        :type CountryCode: str
        """
        self._Purpose = None
        self._PhoneNumber = None
        self._InstanceId = None
        self._CountryCode = None

    @property
    def Purpose(self):
        r"""Captcha target, currently supported: rebind super administrator account, BindSuperAdmin; trial version business upgrade, ChannelUpdateVerify.
        :rtype: str
        """
        return self._Purpose

    @Purpose.setter
    def Purpose(self, Purpose):
        self._Purpose = Purpose

    @property
    def PhoneNumber(self):
        r"""Specifies the mobile number as the super admin account.
        :rtype: str
        """
        return self._PhoneNumber

    @PhoneNumber.setter
    def PhoneNumber(self, PhoneNumber):
        self._PhoneNumber = PhoneNumber

    @property
    def InstanceId(self):
        r"""Official cloud disk instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CountryCode(self):
        r"""Specifies the country code of the mobile number that serves as the super administrator account. defaults to +86.
        :rtype: str
        """
        return self._CountryCode

    @CountryCode.setter
    def CountryCode(self, CountryCode):
        self._CountryCode = CountryCode


    def _deserialize(self, params):
        self._Purpose = params.get("Purpose")
        self._PhoneNumber = params.get("PhoneNumber")
        self._InstanceId = params.get("InstanceId")
        self._CountryCode = params.get("CountryCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SendSmsCodeResponse(AbstractModel):
    r"""SendSmsCode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class TrafficPackage(AbstractModel):
    r"""Traffic package information.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Specifies the instance ID offset by the traffic package.
        :type InstanceId: str
        :param _Domain: Dedicated domain name. if the instance has no dedicated domain name, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _Type: Source type of the traffic package. valid values: 0 (purchase), 1 (complimentary).
        :type Type: int
        :param _Size: Total traffic in Bytes. since the number type has precision limitations, this field is a String type.
        :type Size: str
        :param _SizeGB: Total traffic in GB.
        :type SizeGB: int
        :param _Remain: Remaining traffic in Bytes. this field is of String type due to precision limitations of numeric data types.
        :type Remain: str
        :param _Used: Used traffic in Bytes. since the number type has precision limitations, this field is a String type.
        :type Used: str
        :param _UsedPercentage: Usage percentage. since the String type is used due to precision limitations of the number type, this field is of String type.
        :type UsedPercentage: str
        :param _EffectiveTime: Effective time, the order time of the traffic package.
        :type EffectiveTime: str
        :param _ExpireTime: Expiration time, which is the expiration time of the offset instance. if the traffic package offsets a pay-as-you-go or permanently valid instance, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpireTime: str
        """
        self._InstanceId = None
        self._Domain = None
        self._Type = None
        self._Size = None
        self._SizeGB = None
        self._Remain = None
        self._Used = None
        self._UsedPercentage = None
        self._EffectiveTime = None
        self._ExpireTime = None

    @property
    def InstanceId(self):
        r"""Specifies the instance ID offset by the traffic package.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Domain(self):
        r"""Dedicated domain name. if the instance has no dedicated domain name, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Type(self):
        r"""Source type of the traffic package. valid values: 0 (purchase), 1 (complimentary).
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Size(self):
        r"""Total traffic in Bytes. since the number type has precision limitations, this field is a String type.
        :rtype: str
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def SizeGB(self):
        r"""Total traffic in GB.
        :rtype: int
        """
        return self._SizeGB

    @SizeGB.setter
    def SizeGB(self, SizeGB):
        self._SizeGB = SizeGB

    @property
    def Remain(self):
        r"""Remaining traffic in Bytes. this field is of String type due to precision limitations of numeric data types.
        :rtype: str
        """
        return self._Remain

    @Remain.setter
    def Remain(self, Remain):
        self._Remain = Remain

    @property
    def Used(self):
        r"""Used traffic in Bytes. since the number type has precision limitations, this field is a String type.
        :rtype: str
        """
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def UsedPercentage(self):
        r"""Usage percentage. since the String type is used due to precision limitations of the number type, this field is of String type.
        :rtype: str
        """
        return self._UsedPercentage

    @UsedPercentage.setter
    def UsedPercentage(self, UsedPercentage):
        self._UsedPercentage = UsedPercentage

    @property
    def EffectiveTime(self):
        r"""Effective time, the order time of the traffic package.
        :rtype: str
        """
        return self._EffectiveTime

    @EffectiveTime.setter
    def EffectiveTime(self, EffectiveTime):
        self._EffectiveTime = EffectiveTime

    @property
    def ExpireTime(self):
        r"""Expiration time, which is the expiration time of the offset instance. if the traffic package offsets a pay-as-you-go or permanently valid instance, this attribute is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Domain = params.get("Domain")
        self._Type = params.get("Type")
        self._Size = params.get("Size")
        self._SizeGB = params.get("SizeGB")
        self._Remain = params.get("Remain")
        self._Used = params.get("Used")
        self._UsedPercentage = params.get("UsedPercentage")
        self._EffectiveTime = params.get("EffectiveTime")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VerifySmsCodeRequest(AbstractModel):
    r"""VerifySmsCode request structure.

    """

    def __init__(self):
        r"""
        :param _Purpose: Captcha target, currently supported: rebind super administrator account, BindSuperAdmin; trial version business upgrade verification, ChannelUpdateVerify.
        :type Purpose: str
        :param _PhoneNumber: Specifies the mobile number as the super admin account.
        :type PhoneNumber: str
        :param _Code: Specifies the sms verification code.
        :type Code: str
        :param _InstanceId: Official cloud disk instance ID.
        :type InstanceId: str
        :param _CountryCode: Specifies the country code of the mobile number that serves as the super administrator account. defaults to +86.
        :type CountryCode: str
        """
        self._Purpose = None
        self._PhoneNumber = None
        self._Code = None
        self._InstanceId = None
        self._CountryCode = None

    @property
    def Purpose(self):
        r"""Captcha target, currently supported: rebind super administrator account, BindSuperAdmin; trial version business upgrade verification, ChannelUpdateVerify.
        :rtype: str
        """
        return self._Purpose

    @Purpose.setter
    def Purpose(self, Purpose):
        self._Purpose = Purpose

    @property
    def PhoneNumber(self):
        r"""Specifies the mobile number as the super admin account.
        :rtype: str
        """
        return self._PhoneNumber

    @PhoneNumber.setter
    def PhoneNumber(self, PhoneNumber):
        self._PhoneNumber = PhoneNumber

    @property
    def Code(self):
        r"""Specifies the sms verification code.
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def InstanceId(self):
        r"""Official cloud disk instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CountryCode(self):
        r"""Specifies the country code of the mobile number that serves as the super administrator account. defaults to +86.
        :rtype: str
        """
        return self._CountryCode

    @CountryCode.setter
    def CountryCode(self, CountryCode):
        self._CountryCode = CountryCode


    def _deserialize(self, params):
        self._Purpose = params.get("Purpose")
        self._PhoneNumber = params.get("PhoneNumber")
        self._Code = params.get("Code")
        self._InstanceId = params.get("InstanceId")
        self._CountryCode = params.get("CountryCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VerifySmsCodeResponse(AbstractModel):
    r"""VerifySmsCode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")