# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class DescribeProductsRequest(AbstractModel):
    r"""DescribeProducts request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned results, defaults to 20, maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. default value: 0.
        :type Offset: int
        """
        self._Limit = None
        self._Offset = None

    @property
    def Limit(self):
        r"""Number of returned results, defaults to 20, maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset. default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProductsResponse(AbstractModel):
    r"""DescribeProducts response structure.

    """

    def __init__(self):
        r"""
        :param _Products: Product detailed information list.
        :type Products: list of RegionProduct
        :param _TotalCount: Total number of products.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Products = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Products(self):
        r"""Product detailed information list.
        :rtype: list of RegionProduct
        """
        return self._Products

    @Products.setter
    def Products(self, Products):
        self._Products = Products

    @property
    def TotalCount(self):
        r"""Total number of products.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Products") is not None:
            self._Products = []
            for item in params.get("Products"):
                obj = RegionProduct()
                obj._deserialize(item)
                self._Products.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRegionsRequest(AbstractModel):
    r"""DescribeRegions request structure.

    """

    def __init__(self):
        r"""
        :param _Product: Name of the product to be queried, such as cvm. for specific value, query the DescribeProducts api.
        :type Product: str
        :param _Scene: Not passed or 0 means no query [optional business allowlist], 1 means query [optional business allowlist]. if this parameter is set to 1, the allowlist will only be queried when no business allowlist is found.
        :type Scene: int
        """
        self._Product = None
        self._Scene = None

    @property
    def Product(self):
        r"""Name of the product to be queried, such as cvm. for specific value, query the DescribeProducts api.
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Scene(self):
        r"""Not passed or 0 means no query [optional business allowlist], 1 means query [optional business allowlist]. if this parameter is set to 1, the allowlist will only be queried when no business allowlist is found.
        :rtype: int
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene


    def _deserialize(self, params):
        self._Product = params.get("Product")
        self._Scene = params.get("Scene")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRegionsResponse(AbstractModel):
    r"""DescribeRegions response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of Regions
        :type TotalCount: int
        :param _RegionSet: List Information of Region
        :type RegionSet: list of RegionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RegionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of Regions
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RegionSet(self):
        r"""List Information of Region
        :rtype: list of RegionInfo
        """
        return self._RegionSet

    @RegionSet.setter
    def RegionSet(self, RegionSet):
        self._RegionSet = RegionSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RegionSet") is not None:
            self._RegionSet = []
            for item in params.get("RegionSet"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._RegionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeZonesRequest(AbstractModel):
    r"""DescribeZones request structure.

    """

    def __init__(self):
        r"""
        :param _Product: Name of the product to be queried, such as cvm. for specific value, query the DescribeProducts api.
        :type Product: str
        :param _Scene: No input or 0 means no query [optional business allowlist], 1 means query [optional business allowlist]. if this parameter is set to 1, the allowlist will only be queried when no result is found in the business allowlist.
        :type Scene: int
        """
        self._Product = None
        self._Scene = None

    @property
    def Product(self):
        r"""Name of the product to be queried, such as cvm. for specific value, query the DescribeProducts api.
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Scene(self):
        r"""No input or 0 means no query [optional business allowlist], 1 means query [optional business allowlist]. if this parameter is set to 1, the allowlist will only be queried when no result is found in the business allowlist.
        :rtype: int
        """
        return self._Scene

    @Scene.setter
    def Scene(self, Scene):
        self._Scene = Scene


    def _deserialize(self, params):
        self._Product = params.get("Product")
        self._Scene = params.get("Scene")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeZonesResponse(AbstractModel):
    r"""DescribeZones response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of availability zones.
        :type TotalCount: int
        :param _ZoneSet: Availability zone list information.
        :type ZoneSet: list of ZoneInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ZoneSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of availability zones.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ZoneSet(self):
        r"""Availability zone list information.
        :rtype: list of ZoneInfo
        """
        return self._ZoneSet

    @ZoneSet.setter
    def ZoneSet(self, ZoneSet):
        self._ZoneSet = ZoneSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ZoneSet") is not None:
            self._ZoneSet = []
            for item in params.get("ZoneSet"):
                obj = ZoneInfo()
                obj._deserialize(item)
                self._ZoneSet.append(obj)
        self._RequestId = params.get("RequestId")


class RegionInfo(AbstractModel):
    r"""Region information

    """

    def __init__(self):
        r"""
        :param _Region: Region name, such as ap-guangzhou.
        :type Region: str
        :param _RegionName: Region description, for example, South China (Guangzhou).
        :type RegionName: str
        :param _RegionState: Whether the region is in an available state.
        :type RegionState: str
        :param _RegionTypeMC: Console type. defaults to null when called via api.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegionTypeMC: int
        :param _LocationMC: Region for different languages.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LocationMC: str
        :param _RegionNameMC: Region description on console display.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegionNameMC: str
        :param _RegionIdMC: 1
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegionIdMC: str
        """
        self._Region = None
        self._RegionName = None
        self._RegionState = None
        self._RegionTypeMC = None
        self._LocationMC = None
        self._RegionNameMC = None
        self._RegionIdMC = None

    @property
    def Region(self):
        r"""Region name, such as ap-guangzhou.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def RegionName(self):
        r"""Region description, for example, South China (Guangzhou).
        :rtype: str
        """
        return self._RegionName

    @RegionName.setter
    def RegionName(self, RegionName):
        self._RegionName = RegionName

    @property
    def RegionState(self):
        r"""Whether the region is in an available state.
        :rtype: str
        """
        return self._RegionState

    @RegionState.setter
    def RegionState(self, RegionState):
        self._RegionState = RegionState

    @property
    def RegionTypeMC(self):
        r"""Console type. defaults to null when called via api.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RegionTypeMC

    @RegionTypeMC.setter
    def RegionTypeMC(self, RegionTypeMC):
        self._RegionTypeMC = RegionTypeMC

    @property
    def LocationMC(self):
        r"""Region for different languages.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LocationMC

    @LocationMC.setter
    def LocationMC(self, LocationMC):
        self._LocationMC = LocationMC

    @property
    def RegionNameMC(self):
        r"""Region description on console display.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RegionNameMC

    @RegionNameMC.setter
    def RegionNameMC(self, RegionNameMC):
        self._RegionNameMC = RegionNameMC

    @property
    def RegionIdMC(self):
        r"""1
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RegionIdMC

    @RegionIdMC.setter
    def RegionIdMC(self, RegionIdMC):
        self._RegionIdMC = RegionIdMC


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._RegionName = params.get("RegionName")
        self._RegionState = params.get("RegionState")
        self._RegionTypeMC = params.get("RegionTypeMC")
        self._LocationMC = params.get("LocationMC")
        self._RegionNameMC = params.get("RegionNameMC")
        self._RegionIdMC = params.get("RegionIdMC")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegionProduct(AbstractModel):
    r"""Region management system product information.

    """

    def __init__(self):
        r"""
        :param _Name: Product name, for example cvm.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        r"""Product name, for example cvm.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ZoneInfo(AbstractModel):
    r"""Availability zone information

    """

    def __init__(self):
        r"""
        :param _Zone: Availability zone name, for example, ap-guangzhou-3.

The names of availability zones across the network are as follows:.
<li> ap-chongqing-1 </li>
<li> ap-seoul-1 </li>
<li> ap-seoul-2 </li>
<li> ap-chengdu-1 </li>
<li> ap-chengdu-2 </li>
<li> ap-hongkong-1 </li>
<li> ap-hongkong-2 </li>
<li> ap-shenzhen-fsi-1 </li>
<li> ap-shenzhen-fsi-2 </li>
<li> ap-shenzhen-fsi-3 </li>
<Li> ap-guangzhou-1 (sold-out)</li>.
<Li> ap-guangzhou-2 (resource out of stock)</li>.
<li> ap-guangzhou-3 </li>
<li> ap-guangzhou-4 </li>
<li> ap-guangzhou-6 </li>
<li> ap-tokyo-1 </li>
<li> ap-singapore-1 </li>
<li> ap-singapore-2 </li>
<li> ap-shanghai-fsi-1 </li>
<li> ap-shanghai-fsi-2 </li>
<li> ap-shanghai-fsi-3 </li>
<li> ap-bangkok-1 </li>
<Li> ap-shanghai-1 (resource out of stock) </li>.
<li> ap-shanghai-2 </li>
<li> ap-shanghai-3 </li>
<li> ap-shanghai-4 </li>
<li> ap-shanghai-5 </li>
<li> ap-mumbai-1 </li>
<li> ap-mumbai-2 </li>
<li> ap-beijing-1 </li>
<li> ap-beijing-2 </li>
<li> ap-beijing-3 </li>
<li> ap-beijing-4 </li>
<li> ap-beijing-5 </li>
<li> na-siliconvalley-1 </li>
<li> na-siliconvalley-2 </li>
<li> eu-frankfurt-1 </li>
<li> na-ashburn-1 </li>
<li> na-ashburn-2 </li>
<li> ap-nanjing-1 </li>
<li> ap-nanjing-2 </li>
        :type Zone: str
        :param _ZoneName: Availability zone description, such as Guangzhou Zone 3.
        :type ZoneName: str
        :param _ZoneId: AZ ID
        :type ZoneId: str
        :param _ZoneState: Availability zone status, including AVAILABLE and UNAVAILABLE. AVAILABLE indicates available, and UNAVAILABLE indicates unavailable.
        :type ZoneState: str
        :param _ParentZone: Parent zone.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentZone: str
        :param _ParentZoneId: Parent availability zone ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentZoneId: str
        :param _ParentZoneName: Describes the parent availability zone.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentZoneName: str
        :param _ZoneType: zone type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneType: str
        :param _MachineRoomTypeMC: Console type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineRoomTypeMC: str
        :param _ZoneIdMC: Same as ZoneId. suitable for console invocation.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneIdMC: str
        """
        self._Zone = None
        self._ZoneName = None
        self._ZoneId = None
        self._ZoneState = None
        self._ParentZone = None
        self._ParentZoneId = None
        self._ParentZoneName = None
        self._ZoneType = None
        self._MachineRoomTypeMC = None
        self._ZoneIdMC = None

    @property
    def Zone(self):
        r"""Availability zone name, for example, ap-guangzhou-3.

The names of availability zones across the network are as follows:.
<li> ap-chongqing-1 </li>
<li> ap-seoul-1 </li>
<li> ap-seoul-2 </li>
<li> ap-chengdu-1 </li>
<li> ap-chengdu-2 </li>
<li> ap-hongkong-1 </li>
<li> ap-hongkong-2 </li>
<li> ap-shenzhen-fsi-1 </li>
<li> ap-shenzhen-fsi-2 </li>
<li> ap-shenzhen-fsi-3 </li>
<Li> ap-guangzhou-1 (sold-out)</li>.
<Li> ap-guangzhou-2 (resource out of stock)</li>.
<li> ap-guangzhou-3 </li>
<li> ap-guangzhou-4 </li>
<li> ap-guangzhou-6 </li>
<li> ap-tokyo-1 </li>
<li> ap-singapore-1 </li>
<li> ap-singapore-2 </li>
<li> ap-shanghai-fsi-1 </li>
<li> ap-shanghai-fsi-2 </li>
<li> ap-shanghai-fsi-3 </li>
<li> ap-bangkok-1 </li>
<Li> ap-shanghai-1 (resource out of stock) </li>.
<li> ap-shanghai-2 </li>
<li> ap-shanghai-3 </li>
<li> ap-shanghai-4 </li>
<li> ap-shanghai-5 </li>
<li> ap-mumbai-1 </li>
<li> ap-mumbai-2 </li>
<li> ap-beijing-1 </li>
<li> ap-beijing-2 </li>
<li> ap-beijing-3 </li>
<li> ap-beijing-4 </li>
<li> ap-beijing-5 </li>
<li> na-siliconvalley-1 </li>
<li> na-siliconvalley-2 </li>
<li> eu-frankfurt-1 </li>
<li> na-ashburn-1 </li>
<li> na-ashburn-2 </li>
<li> ap-nanjing-1 </li>
<li> ap-nanjing-2 </li>
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ZoneName(self):
        r"""Availability zone description, such as Guangzhou Zone 3.
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def ZoneId(self):
        r"""AZ ID
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ZoneState(self):
        r"""Availability zone status, including AVAILABLE and UNAVAILABLE. AVAILABLE indicates available, and UNAVAILABLE indicates unavailable.
        :rtype: str
        """
        return self._ZoneState

    @ZoneState.setter
    def ZoneState(self, ZoneState):
        self._ZoneState = ZoneState

    @property
    def ParentZone(self):
        r"""Parent zone.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ParentZone

    @ParentZone.setter
    def ParentZone(self, ParentZone):
        self._ParentZone = ParentZone

    @property
    def ParentZoneId(self):
        r"""Parent availability zone ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ParentZoneId

    @ParentZoneId.setter
    def ParentZoneId(self, ParentZoneId):
        self._ParentZoneId = ParentZoneId

    @property
    def ParentZoneName(self):
        r"""Describes the parent availability zone.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ParentZoneName

    @ParentZoneName.setter
    def ParentZoneName(self, ParentZoneName):
        self._ParentZoneName = ParentZoneName

    @property
    def ZoneType(self):
        r"""zone type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ZoneType

    @ZoneType.setter
    def ZoneType(self, ZoneType):
        self._ZoneType = ZoneType

    @property
    def MachineRoomTypeMC(self):
        r"""Console type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MachineRoomTypeMC

    @MachineRoomTypeMC.setter
    def MachineRoomTypeMC(self, MachineRoomTypeMC):
        self._MachineRoomTypeMC = MachineRoomTypeMC

    @property
    def ZoneIdMC(self):
        r"""Same as ZoneId. suitable for console invocation.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ZoneIdMC

    @ZoneIdMC.setter
    def ZoneIdMC(self, ZoneIdMC):
        self._ZoneIdMC = ZoneIdMC


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._ZoneName = params.get("ZoneName")
        self._ZoneId = params.get("ZoneId")
        self._ZoneState = params.get("ZoneState")
        self._ParentZone = params.get("ParentZone")
        self._ParentZoneId = params.get("ParentZoneId")
        self._ParentZoneName = params.get("ParentZoneName")
        self._ZoneType = params.get("ZoneType")
        self._MachineRoomTypeMC = params.get("MachineRoomTypeMC")
        self._ZoneIdMC = params.get("ZoneIdMC")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        