# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class DescribeRiskAssessmentRequest(AbstractModel):
    r"""DescribeRiskAssessment request structure.

    """

    def __init__(self):
        r"""
        :param _BizCryptoData: Business parameters
        :type BizCryptoData: :class:`tencentcloud.rce.v20201103.models.InputBizCryptoData`
        """
        self._BizCryptoData = None

    @property
    def BizCryptoData(self):
        r"""Business parameters
        :rtype: :class:`tencentcloud.rce.v20201103.models.InputBizCryptoData`
        """
        return self._BizCryptoData

    @BizCryptoData.setter
    def BizCryptoData(self, BizCryptoData):
        self._BizCryptoData = BizCryptoData


    def _deserialize(self, params):
        if params.get("BizCryptoData") is not None:
            self._BizCryptoData = InputBizCryptoData()
            self._BizCryptoData._deserialize(params.get("BizCryptoData"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskAssessmentResponse(AbstractModel):
    r"""DescribeRiskAssessment response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Business output parameters.
        :type Data: :class:`tencentcloud.rce.v20201103.models.OutputRiskAssessment`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""Business output parameters.
        :rtype: :class:`tencentcloud.rce.v20201103.models.OutputRiskAssessment`
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OutputRiskAssessment()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class InputBizCryptoData(AbstractModel):
    r"""Query input parameters of risk assessment results

    """

    def __init__(self):
        r"""
        :param _IsAuthorized: Whether to authorize.
        :type IsAuthorized: str
        :param _CryptoType: Encryption type.
        :type CryptoType: str
        :param _CryptoContent: Encrypted content.
        :type CryptoContent: str
        """
        self._IsAuthorized = None
        self._CryptoType = None
        self._CryptoContent = None

    @property
    def IsAuthorized(self):
        r"""Whether to authorize.
        :rtype: str
        """
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized

    @property
    def CryptoType(self):
        r"""Encryption type.
        :rtype: str
        """
        return self._CryptoType

    @CryptoType.setter
    def CryptoType(self, CryptoType):
        self._CryptoType = CryptoType

    @property
    def CryptoContent(self):
        r"""Encrypted content.
        :rtype: str
        """
        return self._CryptoContent

    @CryptoContent.setter
    def CryptoContent(self, CryptoContent):
        self._CryptoContent = CryptoContent


    def _deserialize(self, params):
        self._IsAuthorized = params.get("IsAuthorized")
        self._CryptoType = params.get("CryptoType")
        self._CryptoContent = params.get("CryptoContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OutputRiskAssessment(AbstractModel):
    r"""Query output parameters of risk assessment results.

    """

    def __init__(self):
        r"""
        :param _Code: Return code.
Note: This field may return null, indicating that no valid value is found.
        :type Code: int
        :param _Message: Returned information

Note: This field may return null, indicating that no valid value is found.
        :type Message: str
        :param _Value: Business details.
Note: This field may return null, indicating that no valid value is found.
        :type Value: :class:`tencentcloud.rce.v20201103.models.OutputRiskAssessmentInfo`
        :param _UUid: Request ID.
Note: This field may return null, indicating that no valid value is found.
        :type UUid: str
        """
        self._Code = None
        self._Message = None
        self._Value = None
        self._UUid = None

    @property
    def Code(self):
        r"""Return code.
Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Message(self):
        r"""Returned information

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Value(self):
        r"""Business details.
Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.rce.v20201103.models.OutputRiskAssessmentInfo`
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def UUid(self):
        r"""Request ID.
Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UUid

    @UUid.setter
    def UUid(self, UUid):
        self._UUid = UUid


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Message = params.get("Message")
        if params.get("Value") is not None:
            self._Value = OutputRiskAssessmentInfo()
            self._Value._deserialize(params.get("Value"))
        self._UUid = params.get("UUid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OutputRiskAssessmentExtraInfoPair(AbstractModel):
    r"""Risk assessment extended attribute key-value pairs.

    """

    def __init__(self):
        r"""
        :param _Key: Key.
Note: This field may return null, indicating that no valid value is found.
        :type Key: str
        :param _Value: Value.
Note: This field may return null, indicating that no valid value is found.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""Key.
Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Value.
Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OutputRiskAssessmentInfo(AbstractModel):
    r"""Query output parameters of risk assessment results.

    """

    def __init__(self):
        r"""
        :param _RiskLevel: Risk value.
Note: This field may return null, indicating that no valid value is found.
        :type RiskLevel: str
        :param _RiskType: Risk type.
Note: This field may return null, indicating that no valid value is found.
        :type RiskType: list of int
        :param _DeviceId: Device identification

Note: This field may return null, indicating that no valid value is found.
        :type DeviceId: str
        :param _ExtraInfo: Extended attributes.
Note: This field may return null, indicating that no valid value is found.
        :type ExtraInfo: list of OutputRiskAssessmentExtraInfoPair
        :param _TokenTime: Token generation timestamp.
Note: This field may return null, indicating that no valid value is found.
        :type TokenTime: str
        """
        self._RiskLevel = None
        self._RiskType = None
        self._DeviceId = None
        self._ExtraInfo = None
        self._TokenTime = None

    @property
    def RiskLevel(self):
        r"""Risk value.
Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def RiskType(self):
        r"""Risk type.
Note: This field may return null, indicating that no valid value is found.
        :rtype: list of int
        """
        return self._RiskType

    @RiskType.setter
    def RiskType(self, RiskType):
        self._RiskType = RiskType

    @property
    def DeviceId(self):
        r"""Device identification

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def ExtraInfo(self):
        r"""Extended attributes.
Note: This field may return null, indicating that no valid value is found.
        :rtype: list of OutputRiskAssessmentExtraInfoPair
        """
        return self._ExtraInfo

    @ExtraInfo.setter
    def ExtraInfo(self, ExtraInfo):
        self._ExtraInfo = ExtraInfo

    @property
    def TokenTime(self):
        r"""Token generation timestamp.
Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._TokenTime

    @TokenTime.setter
    def TokenTime(self, TokenTime):
        self._TokenTime = TokenTime


    def _deserialize(self, params):
        self._RiskLevel = params.get("RiskLevel")
        self._RiskType = params.get("RiskType")
        self._DeviceId = params.get("DeviceId")
        if params.get("ExtraInfo") is not None:
            self._ExtraInfo = []
            for item in params.get("ExtraInfo"):
                obj = OutputRiskAssessmentExtraInfoPair()
                obj._deserialize(item)
                self._ExtraInfo.append(obj)
        self._TokenTime = params.get("TokenTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        