# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcceptJoinShareUnitInvitationRequest(AbstractModel):
    r"""AcceptJoinShareUnitInvitation request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        """
        self._UnitId = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcceptJoinShareUnitInvitationResponse(AbstractModel):
    r"""AcceptJoinShareUnitInvitation response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddExternalSAMLIdPCertificateRequest(AbstractModel):
    r"""AddExternalSAMLIdPCertificate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _X509Certificate: X509 certificate in PEM format, provided by the SAML identity provider.
        :type X509Certificate: str
        """
        self._ZoneId = None
        self._X509Certificate = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def X509Certificate(self):
        r"""X509 certificate in PEM format, provided by the SAML identity provider.
        :rtype: str
        """
        return self._X509Certificate

    @X509Certificate.setter
    def X509Certificate(self, X509Certificate):
        self._X509Certificate = X509Certificate


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._X509Certificate = params.get("X509Certificate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddExternalSAMLIdPCertificateResponse(AbstractModel):
    r"""AddExternalSAMLIdPCertificate response structure.

    """

    def __init__(self):
        r"""
        :param _CertificateId: SAML signing certificate ID.
        :type CertificateId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CertificateId = None
        self._RequestId = None

    @property
    def CertificateId(self):
        r"""SAML signing certificate ID.
        :rtype: str
        """
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CertificateId = params.get("CertificateId")
        self._RequestId = params.get("RequestId")


class AddOrganizationMemberEmailRequest(AbstractModel):
    r"""AddOrganizationMemberEmail request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member uin.
        :type MemberUin: int
        :param _Email: Email address.
        :type Email: str
        :param _CountryCode: International area code.
        :type CountryCode: str
        :param _Phone: Mobile number.
        :type Phone: str
        """
        self._MemberUin = None
        self._Email = None
        self._CountryCode = None
        self._Phone = None

    @property
    def MemberUin(self):
        r"""Member uin.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def Email(self):
        r"""Email address.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def CountryCode(self):
        r"""International area code.
        :rtype: str
        """
        return self._CountryCode

    @CountryCode.setter
    def CountryCode(self, CountryCode):
        self._CountryCode = CountryCode

    @property
    def Phone(self):
        r"""Mobile number.
        :rtype: str
        """
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._Email = params.get("Email")
        self._CountryCode = params.get("CountryCode")
        self._Phone = params.get("Phone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOrganizationMemberEmailResponse(AbstractModel):
    r"""AddOrganizationMemberEmail response structure.

    """

    def __init__(self):
        r"""
        :param _BindId: Bound ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type BindId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BindId = None
        self._RequestId = None

    @property
    def BindId(self):
        r"""Bound ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._BindId

    @BindId.setter
    def BindId(self, BindId):
        self._BindId = BindId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BindId = params.get("BindId")
        self._RequestId = params.get("RequestId")


class AddOrganizationNodeRequest(AbstractModel):
    r"""AddOrganizationNode request structure.

    """

    def __init__(self):
        r"""
        :param _ParentNodeId: Parent node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type ParentNodeId: int
        :param _Name: Node name, which can contain up to 40 letters, digits, and symbols `+@&._[]-`.
        :type Name: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _Tags: Department tag list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._ParentNodeId = None
        self._Name = None
        self._Remark = None
        self._Tags = None

    @property
    def ParentNodeId(self):
        r"""Parent node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :rtype: int
        """
        return self._ParentNodeId

    @ParentNodeId.setter
    def ParentNodeId(self, ParentNodeId):
        self._ParentNodeId = ParentNodeId

    @property
    def Name(self):
        r"""Node name, which can contain up to 40 letters, digits, and symbols `+@&._[]-`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Tags(self):
        r"""Department tag list, with a maximum of 10.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ParentNodeId = params.get("ParentNodeId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOrganizationNodeResponse(AbstractModel):
    r"""AddOrganizationNode response structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Node ID.
        :type NodeId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NodeId = None
        self._RequestId = None

    @property
    def NodeId(self):
        r"""Node ID.
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._RequestId = params.get("RequestId")


class AddPermissionPolicyToRoleConfigurationRequest(AbstractModel):
    r"""AddPermissionPolicyToRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RolePolicyType: Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.  
        :type RolePolicyType: str
        :param _RolePolicyNames: Permission policy name, supporting up to 20 policies, with each policy having a maximum of 32 characters. If you need to add a system policy, it is recommended to use the RolePolicies parameter. For custom policies, the array length is up to 1.
        :type RolePolicyNames: list of str
        :param _RolePolicies: Details of an added system policy.
        :type RolePolicies: list of PolicyDetail
        :param _CustomPolicyDocument: Custom policy content, which contains up to 4096 characters. When RolePolicyType is Inline, this parameter must be configured. For details, see the permission policy syntax and structure.
        :type CustomPolicyDocument: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._RolePolicyType = None
        self._RolePolicyNames = None
        self._RolePolicies = None
        self._CustomPolicyDocument = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RolePolicyType(self):
        r"""Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.  
        :rtype: str
        """
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def RolePolicyNames(self):
        r"""Permission policy name, supporting up to 20 policies, with each policy having a maximum of 32 characters. If you need to add a system policy, it is recommended to use the RolePolicies parameter. For custom policies, the array length is up to 1.
        :rtype: list of str
        """
        return self._RolePolicyNames

    @RolePolicyNames.setter
    def RolePolicyNames(self, RolePolicyNames):
        self._RolePolicyNames = RolePolicyNames

    @property
    def RolePolicies(self):
        r"""Details of an added system policy.
        :rtype: list of PolicyDetail
        """
        return self._RolePolicies

    @RolePolicies.setter
    def RolePolicies(self, RolePolicies):
        self._RolePolicies = RolePolicies

    @property
    def CustomPolicyDocument(self):
        r"""Custom policy content, which contains up to 4096 characters. When RolePolicyType is Inline, this parameter must be configured. For details, see the permission policy syntax and structure.
        :rtype: str
        """
        return self._CustomPolicyDocument

    @CustomPolicyDocument.setter
    def CustomPolicyDocument(self, CustomPolicyDocument):
        self._CustomPolicyDocument = CustomPolicyDocument


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RolePolicyType = params.get("RolePolicyType")
        self._RolePolicyNames = params.get("RolePolicyNames")
        if params.get("RolePolicies") is not None:
            self._RolePolicies = []
            for item in params.get("RolePolicies"):
                obj = PolicyDetail()
                obj._deserialize(item)
                self._RolePolicies.append(obj)
        self._CustomPolicyDocument = params.get("CustomPolicyDocument")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddPermissionPolicyToRoleConfigurationResponse(AbstractModel):
    r"""AddPermissionPolicyToRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddShareUnitMembersRequest(AbstractModel):
    r"""AddShareUnitMembers request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Area: Shared unit region.
        :type Area: str
        :param _Members: Shared member list. Maximum: 10.
        :type Members: list of ShareMember
        """
        self._UnitId = None
        self._Area = None
        self._Members = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Members(self):
        r"""Shared member list. Maximum: 10.
        :rtype: list of ShareMember
        """
        return self._Members

    @Members.setter
    def Members(self, Members):
        self._Members = Members


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Area = params.get("Area")
        if params.get("Members") is not None:
            self._Members = []
            for item in params.get("Members"):
                obj = ShareMember()
                obj._deserialize(item)
                self._Members.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddShareUnitMembersResponse(AbstractModel):
    r"""AddShareUnitMembers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddShareUnitRequest(AbstractModel):
    r"""AddShareUnit request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Shared unit name. It only supports combinations of uppercase and lowercase letters, digits, hyphens (-), and underscores (_), with 3 to 128 characters.
        :type Name: str
        :param _Area: Shared unit region. You can obtain supported shared regions through the API [DescribeShareAreas](https://intl.cloud.tencent.com/document/product/850/103050?from_cn_redirect=1).
        :type Area: str
        :param _Description: Shared unit description. Maximum: 128 characters.
        :type Description: str
        :param _ShareScope: Sharing scope. Valid values: 1: Only sharing within a group organization is allowed; 2: Sharing with any account is allowed. Default value: 1
        :type ShareScope: int
        """
        self._Name = None
        self._Area = None
        self._Description = None
        self._ShareScope = None

    @property
    def Name(self):
        r"""Shared unit name. It only supports combinations of uppercase and lowercase letters, digits, hyphens (-), and underscores (_), with 3 to 128 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Area(self):
        r"""Shared unit region. You can obtain supported shared regions through the API [DescribeShareAreas](https://intl.cloud.tencent.com/document/product/850/103050?from_cn_redirect=1).
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Description(self):
        r"""Shared unit description. Maximum: 128 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ShareScope(self):
        r"""Sharing scope. Valid values: 1: Only sharing within a group organization is allowed; 2: Sharing with any account is allowed. Default value: 1
        :rtype: int
        """
        return self._ShareScope

    @ShareScope.setter
    def ShareScope(self, ShareScope):
        self._ShareScope = ShareScope


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Area = params.get("Area")
        self._Description = params.get("Description")
        self._ShareScope = params.get("ShareScope")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddShareUnitResourcesRequest(AbstractModel):
    r"""AddShareUnitResources request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Area: Shared unit region.
        :type Area: str
        :param _Type: Shared resource type. For supported shared resource types, see [Overview of Resource Sharing](https://intl.cloud.tencent.com/document/product/850/59489?from_cn_redirect=1).
        :type Type: str
        :param _Resources: Shared resource list. Maximum: 10.
        :type Resources: list of ProductResource
        """
        self._UnitId = None
        self._Area = None
        self._Type = None
        self._Resources = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Type(self):
        r"""Shared resource type. For supported shared resource types, see [Overview of Resource Sharing](https://intl.cloud.tencent.com/document/product/850/59489?from_cn_redirect=1).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Resources(self):
        r"""Shared resource list. Maximum: 10.
        :rtype: list of ProductResource
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Area = params.get("Area")
        self._Type = params.get("Type")
        if params.get("Resources") is not None:
            self._Resources = []
            for item in params.get("Resources"):
                obj = ProductResource()
                obj._deserialize(item)
                self._Resources.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddShareUnitResourcesResponse(AbstractModel):
    r"""AddShareUnitResources response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddShareUnitResponse(AbstractModel):
    r"""AddShareUnit response structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UnitId = None
        self._RequestId = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._RequestId = params.get("RequestId")


class AddUserToGroupRequest(AbstractModel):
    r"""AddUserToGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _UserId: User ID.
        :type UserId: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._UserId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddUserToGroupResponse(AbstractModel):
    r"""AddUserToGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AuthRelationFile(AbstractModel):
    r"""Real-name mutual trust application proof file.

    """

    def __init__(self):
        r"""
        :param _Name: File name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Url: File path.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Url: str
        """
        self._Name = None
        self._Url = None

    @property
    def Name(self):
        r"""File name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Url(self):
        r"""File path.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOrganizationMemberAuthAccountRequest(AbstractModel):
    r"""BindOrganizationMemberAuthAccount request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyId: Policy ID, which can be obtained by calling [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        :param _OrgSubAccountUins: List of sub-account UINs of the organization admin, which can contain up to five UINs.
        :type OrgSubAccountUins: list of int
        """
        self._MemberUin = None
        self._PolicyId = None
        self._OrgSubAccountUins = None

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyId(self):
        r"""Policy ID, which can be obtained by calling [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def OrgSubAccountUins(self):
        r"""List of sub-account UINs of the organization admin, which can contain up to five UINs.
        :rtype: list of int
        """
        return self._OrgSubAccountUins

    @OrgSubAccountUins.setter
    def OrgSubAccountUins(self, OrgSubAccountUins):
        self._OrgSubAccountUins = OrgSubAccountUins


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._PolicyId = params.get("PolicyId")
        self._OrgSubAccountUins = params.get("OrgSubAccountUins")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOrganizationMemberAuthAccountResponse(AbstractModel):
    r"""BindOrganizationMemberAuthAccount response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelOrganizationMemberAuthAccountRequest(AbstractModel):
    r"""CancelOrganizationMemberAuthAccount request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyId: Policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        :param _OrgSubAccountUin: Organization sub-account UIN.
        :type OrgSubAccountUin: int
        """
        self._MemberUin = None
        self._PolicyId = None
        self._OrgSubAccountUin = None

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyId(self):
        r"""Policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def OrgSubAccountUin(self):
        r"""Organization sub-account UIN.
        :rtype: int
        """
        return self._OrgSubAccountUin

    @OrgSubAccountUin.setter
    def OrgSubAccountUin(self, OrgSubAccountUin):
        self._OrgSubAccountUin = OrgSubAccountUin


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._PolicyId = params.get("PolicyId")
        self._OrgSubAccountUin = params.get("OrgSubAccountUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelOrganizationMemberAuthAccountResponse(AbstractModel):
    r"""CancelOrganizationMemberAuthAccount response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ClearExternalSAMLIdentityProviderRequest(AbstractModel):
    r"""ClearExternalSAMLIdentityProvider request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearExternalSAMLIdentityProviderResponse(AbstractModel):
    r"""ClearExternalSAMLIdentityProvider response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateGroupRequest(AbstractModel):
    r"""CreateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupName: User group name, which contains up to 128 characters, including English letters, digits, and special characters (-).
        :type GroupName: str
        :param _Description: User group description, which contains up to 1024 characters.
        :type Description: str
        :param _GroupType: User group type. Manual: manually created, Synchronized: imported from external sources.
        :type GroupType: str
        """
        self._ZoneId = None
        self._GroupName = None
        self._Description = None
        self._GroupType = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupName(self):
        r"""User group name, which contains up to 128 characters, including English letters, digits, and special characters (-).
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        r"""User group description, which contains up to 1024 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def GroupType(self):
        r"""User group type. Manual: manually created, Synchronized: imported from external sources.
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        self._GroupType = params.get("GroupType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGroupResponse(AbstractModel):
    r"""CreateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupInfo: User group information.
        :type GroupInfo: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupInfo = None
        self._RequestId = None

    @property
    def GroupInfo(self):
        r"""User group information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        """
        return self._GroupInfo

    @GroupInfo.setter
    def GroupInfo(self, GroupInfo):
        self._GroupInfo = GroupInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupInfo") is not None:
            self._GroupInfo = GroupInfo()
            self._GroupInfo._deserialize(params.get("GroupInfo"))
        self._RequestId = params.get("RequestId")


class CreateOrgServiceAssignRequest(AbstractModel):
    r"""CreateOrgServiceAssign request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUins: Uin list of the delegated admins, including up to 20 items.
        :type MemberUins: list of int
        :param _ServiceId: Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :type ServiceId: int
        :param _ManagementScope: Management scope of the delegated admin. Valid values: 1 (all members), 2 (partial members). Default value: 1.
        :type ManagementScope: int
        :param _ManagementScopeUins: Uin list of the managed members. This parameter is valid when ManagementScope is 2.
        :type ManagementScopeUins: list of int
        :param _ManagementScopeNodeIds: ID list of the managed departments. This parameter is valid when ManagementScope is 2.
        :type ManagementScopeNodeIds: list of int
        """
        self._MemberUins = None
        self._ServiceId = None
        self._ManagementScope = None
        self._ManagementScopeUins = None
        self._ManagementScopeNodeIds = None

    @property
    def MemberUins(self):
        r"""Uin list of the delegated admins, including up to 20 items.
        :rtype: list of int
        """
        return self._MemberUins

    @MemberUins.setter
    def MemberUins(self, MemberUins):
        self._MemberUins = MemberUins

    @property
    def ServiceId(self):
        r"""Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :rtype: int
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def ManagementScope(self):
        r"""Management scope of the delegated admin. Valid values: 1 (all members), 2 (partial members). Default value: 1.
        :rtype: int
        """
        return self._ManagementScope

    @ManagementScope.setter
    def ManagementScope(self, ManagementScope):
        self._ManagementScope = ManagementScope

    @property
    def ManagementScopeUins(self):
        r"""Uin list of the managed members. This parameter is valid when ManagementScope is 2.
        :rtype: list of int
        """
        return self._ManagementScopeUins

    @ManagementScopeUins.setter
    def ManagementScopeUins(self, ManagementScopeUins):
        self._ManagementScopeUins = ManagementScopeUins

    @property
    def ManagementScopeNodeIds(self):
        r"""ID list of the managed departments. This parameter is valid when ManagementScope is 2.
        :rtype: list of int
        """
        return self._ManagementScopeNodeIds

    @ManagementScopeNodeIds.setter
    def ManagementScopeNodeIds(self, ManagementScopeNodeIds):
        self._ManagementScopeNodeIds = ManagementScopeNodeIds


    def _deserialize(self, params):
        self._MemberUins = params.get("MemberUins")
        self._ServiceId = params.get("ServiceId")
        self._ManagementScope = params.get("ManagementScope")
        self._ManagementScopeUins = params.get("ManagementScopeUins")
        self._ManagementScopeNodeIds = params.get("ManagementScopeNodeIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrgServiceAssignResponse(AbstractModel):
    r"""CreateOrgServiceAssign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateOrganizationIdentityRequest(AbstractModel):
    r"""CreateOrganizationIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _IdentityAliasName: Identity name.
        :type IdentityAliasName: str
        :param _IdentityPolicy: Identity policy.
        :type IdentityPolicy: list of IdentityPolicy
        :param _Description: Identity description.
        :type Description: str
        """
        self._IdentityAliasName = None
        self._IdentityPolicy = None
        self._Description = None

    @property
    def IdentityAliasName(self):
        r"""Identity name.
        :rtype: str
        """
        return self._IdentityAliasName

    @IdentityAliasName.setter
    def IdentityAliasName(self, IdentityAliasName):
        self._IdentityAliasName = IdentityAliasName

    @property
    def IdentityPolicy(self):
        r"""Identity policy.
        :rtype: list of IdentityPolicy
        """
        return self._IdentityPolicy

    @IdentityPolicy.setter
    def IdentityPolicy(self, IdentityPolicy):
        self._IdentityPolicy = IdentityPolicy

    @property
    def Description(self):
        r"""Identity description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._IdentityAliasName = params.get("IdentityAliasName")
        if params.get("IdentityPolicy") is not None:
            self._IdentityPolicy = []
            for item in params.get("IdentityPolicy"):
                obj = IdentityPolicy()
                obj._deserialize(item)
                self._IdentityPolicy.append(obj)
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationIdentityResponse(AbstractModel):
    r"""CreateOrganizationIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IdentityId = None
        self._RequestId = None

    @property
    def IdentityId(self):
        r"""Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._RequestId = params.get("RequestId")


class CreateOrganizationMemberAuthIdentityRequest(AbstractModel):
    r"""CreateOrganizationMemberAuthIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUins: Member UIN list, including up to 10 items.
        :type MemberUins: list of int non-negative
        :param _IdentityIds: Identity ID list, including up to 5 items, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityIds: list of int non-negative
        """
        self._MemberUins = None
        self._IdentityIds = None

    @property
    def MemberUins(self):
        r"""Member UIN list, including up to 10 items.
        :rtype: list of int non-negative
        """
        return self._MemberUins

    @MemberUins.setter
    def MemberUins(self, MemberUins):
        self._MemberUins = MemberUins

    @property
    def IdentityIds(self):
        r"""Identity ID list, including up to 5 items, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :rtype: list of int non-negative
        """
        return self._IdentityIds

    @IdentityIds.setter
    def IdentityIds(self, IdentityIds):
        self._IdentityIds = IdentityIds


    def _deserialize(self, params):
        self._MemberUins = params.get("MemberUins")
        self._IdentityIds = params.get("IdentityIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationMemberAuthIdentityResponse(AbstractModel):
    r"""CreateOrganizationMemberAuthIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateOrganizationMemberPolicyRequest(AbstractModel):
    r"""CreateOrganizationMemberPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyName: Policy name, which can contain up to 128 letters, digits, and symbols `+=,.@_-`.
        :type PolicyName: str
        :param _IdentityId: Member access identity ID, which can be obtained through [DescribeOrganizationMemberAuthIdentities](https://intl.cloud.tencent.com/document/product/850/82936?from_cn_redirect=1).
        :type IdentityId: int
        :param _Description: Description.
        :type Description: str
        """
        self._MemberUin = None
        self._PolicyName = None
        self._IdentityId = None
        self._Description = None

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyName(self):
        r"""Policy name, which can contain up to 128 letters, digits, and symbols `+=,.@_-`.
        :rtype: str
        """
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        r"""Member access identity ID, which can be obtained through [DescribeOrganizationMemberAuthIdentities](https://intl.cloud.tencent.com/document/product/850/82936?from_cn_redirect=1).
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def Description(self):
        r"""Description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationMemberPolicyResponse(AbstractModel):
    r"""CreateOrganizationMemberPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PolicyId = None
        self._RequestId = None

    @property
    def PolicyId(self):
        r"""Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._RequestId = params.get("RequestId")


class CreateOrganizationMemberRequest(AbstractModel):
    r"""CreateOrganizationMember request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Member name, which can contain up to 25 letters, digits, and symbols `+@&._[]-:,`.
        :type Name: str
        :param _PolicyType: Relationship policy. Valid value: `Financial`.
        :type PolicyType: str
        :param _PermissionIds: Member Finanace Authorization. Valid values: 1: View Bills. 2: View Balance.  4: Consolidate Bills. 5: Invoice. 6: Inherit Offer. 7: Pay On Behalf. 8: Cost Explorer. 9: Budget Management.  1, 2 and 7 are required.
        :type PermissionIds: list of int non-negative
        :param _NodeId: Node ID of the member's department, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _AccountName: Account name, which can contain up to 25 letters, digits, and symbols `+@&._[]-:,`.
        :type AccountName: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _RecordId: Member creation record ID, which is required during retry upon creation exception.
        :type RecordId: int
        :param _PayUin: Payer UIN, which is required during paying for a member.
        :type PayUin: str
        :param _IdentityRoleID: List of member access identity IDs, which can be obtained through the `ListOrganizationIdentity` API. `1` indicates supported, which is the default value.
        :type IdentityRoleID: list of int non-negative
        :param _AuthRelationId: Verified entity relationship ID, which is required during creating members for different entities.
        :type AuthRelationId: int
        :param _Tags: Member tag list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._Name = None
        self._PolicyType = None
        self._PermissionIds = None
        self._NodeId = None
        self._AccountName = None
        self._Remark = None
        self._RecordId = None
        self._PayUin = None
        self._IdentityRoleID = None
        self._AuthRelationId = None
        self._Tags = None

    @property
    def Name(self):
        r"""Member name, which can contain up to 25 letters, digits, and symbols `+@&._[]-:,`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PolicyType(self):
        r"""Relationship policy. Valid value: `Financial`.
        :rtype: str
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PermissionIds(self):
        r"""Member Finanace Authorization. Valid values: 1: View Bills. 2: View Balance.  4: Consolidate Bills. 5: Invoice. 6: Inherit Offer. 7: Pay On Behalf. 8: Cost Explorer. 9: Budget Management.  1, 2 and 7 are required.
        :rtype: list of int non-negative
        """
        return self._PermissionIds

    @PermissionIds.setter
    def PermissionIds(self, PermissionIds):
        self._PermissionIds = PermissionIds

    @property
    def NodeId(self):
        r"""Node ID of the member's department, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def AccountName(self):
        r"""Account name, which can contain up to 25 letters, digits, and symbols `+@&._[]-:,`.
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RecordId(self):
        r"""Member creation record ID, which is required during retry upon creation exception.
        :rtype: int
        """
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def PayUin(self):
        r"""Payer UIN, which is required during paying for a member.
        :rtype: str
        """
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def IdentityRoleID(self):
        r"""List of member access identity IDs, which can be obtained through the `ListOrganizationIdentity` API. `1` indicates supported, which is the default value.
        :rtype: list of int non-negative
        """
        return self._IdentityRoleID

    @IdentityRoleID.setter
    def IdentityRoleID(self, IdentityRoleID):
        self._IdentityRoleID = IdentityRoleID

    @property
    def AuthRelationId(self):
        r"""Verified entity relationship ID, which is required during creating members for different entities.
        :rtype: int
        """
        return self._AuthRelationId

    @AuthRelationId.setter
    def AuthRelationId(self, AuthRelationId):
        self._AuthRelationId = AuthRelationId

    @property
    def Tags(self):
        r"""Member tag list, with a maximum of 10.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._PolicyType = params.get("PolicyType")
        self._PermissionIds = params.get("PermissionIds")
        self._NodeId = params.get("NodeId")
        self._AccountName = params.get("AccountName")
        self._Remark = params.get("Remark")
        self._RecordId = params.get("RecordId")
        self._PayUin = params.get("PayUin")
        self._IdentityRoleID = params.get("IdentityRoleID")
        self._AuthRelationId = params.get("AuthRelationId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationMemberResponse(AbstractModel):
    r"""CreateOrganizationMember response structure.

    """

    def __init__(self):
        r"""
        :param _Uin: Member UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uin: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Uin = None
        self._RequestId = None

    @property
    def Uin(self):
        r"""Member UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Uin = params.get("Uin")
        self._RequestId = params.get("RequestId")


class CreateOrganizationMembersPolicyRequest(AbstractModel):
    r"""CreateOrganizationMembersPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUins: Member UIN list, including up to 10 items.
        :type MemberUins: list of int
        :param _PolicyName: Policy name, which contains 1 to 128 characters, including English letters, digits, and symbols `+=,.@_-`.
        :type PolicyName: str
        :param _IdentityId: Member access identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityId: int
        :param _Description: Policy description, which contains up to 128 characters.
        :type Description: str
        """
        self._MemberUins = None
        self._PolicyName = None
        self._IdentityId = None
        self._Description = None

    @property
    def MemberUins(self):
        r"""Member UIN list, including up to 10 items.
        :rtype: list of int
        """
        return self._MemberUins

    @MemberUins.setter
    def MemberUins(self, MemberUins):
        self._MemberUins = MemberUins

    @property
    def PolicyName(self):
        r"""Policy name, which contains 1 to 128 characters, including English letters, digits, and symbols `+=,.@_-`.
        :rtype: str
        """
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        r"""Member access identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def Description(self):
        r"""Policy description, which contains up to 128 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._MemberUins = params.get("MemberUins")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationMembersPolicyResponse(AbstractModel):
    r"""CreateOrganizationMembersPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.

Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PolicyId = None
        self._RequestId = None

    @property
    def PolicyId(self):
        r"""Policy ID.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._RequestId = params.get("RequestId")


class CreateOrganizationRequest(AbstractModel):
    r"""CreateOrganization request structure.

    """


class CreateOrganizationResponse(AbstractModel):
    r"""CreateOrganization response structure.

    """

    def __init__(self):
        r"""
        :param _OrgId: Organization ID.
        :type OrgId: int
        :param _NickName: Creator's nickname.
        :type NickName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OrgId = None
        self._NickName = None
        self._RequestId = None

    @property
    def OrgId(self):
        r"""Organization ID.
        :rtype: int
        """
        return self._OrgId

    @OrgId.setter
    def OrgId(self, OrgId):
        self._OrgId = OrgId

    @property
    def NickName(self):
        r"""Creator's nickname.
        :rtype: str
        """
        return self._NickName

    @NickName.setter
    def NickName(self, NickName):
        self._NickName = NickName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OrgId = params.get("OrgId")
        self._NickName = params.get("NickName")
        self._RequestId = params.get("RequestId")


class CreateRoleAssignmentRequest(AbstractModel):
    r"""CreateRoleAssignment request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleAssignmentInfo: Authorized member account information, up to 50 entries.
        :type RoleAssignmentInfo: list of RoleAssignmentInfo
        """
        self._ZoneId = None
        self._RoleAssignmentInfo = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleAssignmentInfo(self):
        r"""Authorized member account information, up to 50 entries.
        :rtype: list of RoleAssignmentInfo
        """
        return self._RoleAssignmentInfo

    @RoleAssignmentInfo.setter
    def RoleAssignmentInfo(self, RoleAssignmentInfo):
        self._RoleAssignmentInfo = RoleAssignmentInfo


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("RoleAssignmentInfo") is not None:
            self._RoleAssignmentInfo = []
            for item in params.get("RoleAssignmentInfo"):
                obj = RoleAssignmentInfo()
                obj._deserialize(item)
                self._RoleAssignmentInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoleAssignmentResponse(AbstractModel):
    r"""CreateRoleAssignment response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.
        :type Tasks: list of TaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        r"""Task details.
        :rtype: list of TaskInfo
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = TaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class CreateRoleConfigurationRequest(AbstractModel):
    r"""CreateRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationName: Permission configuration name, which contains up to 128 characters, including English letters, digits, and hyphens (-).
        :type RoleConfigurationName: str
        :param _Description: Permission configuration description, which contains up to 1,024 characters.
        :type Description: str
        :param _SessionDuration: Session duration, in seconds. It is the maximum time a CIC user can maintain a session while using permission configurations to access a target account in TCO. Value range: 900 to 43200 (15 minutes to 12 hours). Default: 3600 (1 hour).
        :type SessionDuration: int
        :param _RelayState: Initial access page. It is the initial page address when a CIC user uses permission configurations to access a target account in TCO. This page must be a Tencent Cloud console page. The default value is empty, representing a redirection to the home page of the Tencent Cloud console.
        :type RelayState: str
        """
        self._ZoneId = None
        self._RoleConfigurationName = None
        self._Description = None
        self._SessionDuration = None
        self._RelayState = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationName(self):
        r"""Permission configuration name, which contains up to 128 characters, including English letters, digits, and hyphens (-).
        :rtype: str
        """
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def Description(self):
        r"""Permission configuration description, which contains up to 1,024 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SessionDuration(self):
        r"""Session duration, in seconds. It is the maximum time a CIC user can maintain a session while using permission configurations to access a target account in TCO. Value range: 900 to 43200 (15 minutes to 12 hours). Default: 3600 (1 hour).
        :rtype: int
        """
        return self._SessionDuration

    @SessionDuration.setter
    def SessionDuration(self, SessionDuration):
        self._SessionDuration = SessionDuration

    @property
    def RelayState(self):
        r"""Initial access page. It is the initial page address when a CIC user uses permission configurations to access a target account in TCO. This page must be a Tencent Cloud console page. The default value is empty, representing a redirection to the home page of the Tencent Cloud console.
        :rtype: str
        """
        return self._RelayState

    @RelayState.setter
    def RelayState(self, RelayState):
        self._RelayState = RelayState


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._Description = params.get("Description")
        self._SessionDuration = params.get("SessionDuration")
        self._RelayState = params.get("RelayState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoleConfigurationResponse(AbstractModel):
    r"""CreateRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationInfo: Access configuration details.
        :type RoleConfigurationInfo: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleConfigurationInfo = None
        self._RequestId = None

    @property
    def RoleConfigurationInfo(self):
        r"""Access configuration details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        """
        return self._RoleConfigurationInfo

    @RoleConfigurationInfo.setter
    def RoleConfigurationInfo(self, RoleConfigurationInfo):
        self._RoleConfigurationInfo = RoleConfigurationInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoleConfigurationInfo") is not None:
            self._RoleConfigurationInfo = RoleConfiguration()
            self._RoleConfigurationInfo._deserialize(params.get("RoleConfigurationInfo"))
        self._RequestId = params.get("RequestId")


class CreateSCIMCredentialRequest(AbstractModel):
    r"""CreateSCIMCredential request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSCIMCredentialResponse(AbstractModel):
    r"""CreateSCIMCredential response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _CredentialId: SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :type CredentialId: str
        :param _CredentialType: SCIM key type.
        :type CredentialType: str
        :param _CreateTime: Creation time of a SCIM key.
        :type CreateTime: str
        :param _ExpireTime: Expiration time of a SCIM key.
        :type ExpireTime: str
        :param _CredentialStatus: SCIM key status. Enabled: enabled. Disabled: disabled.
        :type CredentialStatus: str
        :param _CredentialSecret: SCIM key.
        :type CredentialSecret: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._CredentialId = None
        self._CredentialType = None
        self._CreateTime = None
        self._ExpireTime = None
        self._CredentialStatus = None
        self._CredentialSecret = None
        self._RequestId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CredentialId(self):
        r"""SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._CredentialId

    @CredentialId.setter
    def CredentialId(self, CredentialId):
        self._CredentialId = CredentialId

    @property
    def CredentialType(self):
        r"""SCIM key type.
        :rtype: str
        """
        return self._CredentialType

    @CredentialType.setter
    def CredentialType(self, CredentialType):
        self._CredentialType = CredentialType

    @property
    def CreateTime(self):
        r"""Creation time of a SCIM key.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        r"""Expiration time of a SCIM key.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def CredentialStatus(self):
        r"""SCIM key status. Enabled: enabled. Disabled: disabled.
        :rtype: str
        """
        return self._CredentialStatus

    @CredentialStatus.setter
    def CredentialStatus(self, CredentialStatus):
        self._CredentialStatus = CredentialStatus

    @property
    def CredentialSecret(self):
        r"""SCIM key.
        :rtype: str
        """
        return self._CredentialSecret

    @CredentialSecret.setter
    def CredentialSecret(self, CredentialSecret):
        self._CredentialSecret = CredentialSecret

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CredentialId = params.get("CredentialId")
        self._CredentialType = params.get("CredentialType")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        self._CredentialStatus = params.get("CredentialStatus")
        self._CredentialSecret = params.get("CredentialSecret")
        self._RequestId = params.get("RequestId")


class CreateUserRequest(AbstractModel):
    r"""CreateUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserName: User name, which must be unique within the space and cannot be modified. It contains up to 64 characters, including digits, English letters, and special characters such as plus signs (+), equal signs (=), commas (,), periods (.), at signs (@), hyphens (-), and underscores (_).
        :type UserName: str
        :param _FirstName: Last name of the user, which contains up to 64 characters.
        :type FirstName: str
        :param _LastName: First name of the user, which contains up to 64 characters.
        :type LastName: str
        :param _DisplayName: Display name of the user, which contains up to 256 characters.
        :type DisplayName: str
        :param _Description: User description, which contains up to 1024 characters.
        :type Description: str
        :param _Email: Email address of the user, which must be unique within the directory and contains up to 128 characters.
        :type Email: str
        :param _UserStatus: User status. Valid values: Enabled (default), Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created, Synchronized: imported from external sources.
        :type UserType: str
        """
        self._ZoneId = None
        self._UserName = None
        self._FirstName = None
        self._LastName = None
        self._DisplayName = None
        self._Description = None
        self._Email = None
        self._UserStatus = None
        self._UserType = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserName(self):
        r"""User name, which must be unique within the space and cannot be modified. It contains up to 64 characters, including digits, English letters, and special characters such as plus signs (+), equal signs (=), commas (,), periods (.), at signs (@), hyphens (-), and underscores (_).
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def FirstName(self):
        r"""Last name of the user, which contains up to 64 characters.
        :rtype: str
        """
        return self._FirstName

    @FirstName.setter
    def FirstName(self, FirstName):
        self._FirstName = FirstName

    @property
    def LastName(self):
        r"""First name of the user, which contains up to 64 characters.
        :rtype: str
        """
        return self._LastName

    @LastName.setter
    def LastName(self, LastName):
        self._LastName = LastName

    @property
    def DisplayName(self):
        r"""Display name of the user, which contains up to 256 characters.
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        r"""User description, which contains up to 1024 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Email(self):
        r"""Email address of the user, which must be unique within the directory and contains up to 128 characters.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def UserStatus(self):
        r"""User status. Valid values: Enabled (default), Disabled.
        :rtype: str
        """
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        r"""User type. Manual: manually created, Synchronized: imported from external sources.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserName = params.get("UserName")
        self._FirstName = params.get("FirstName")
        self._LastName = params.get("LastName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._Email = params.get("Email")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserResponse(AbstractModel):
    r"""CreateUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User details.
        :type UserInfo: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""User details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class CreateUserSyncProvisioningRequest(AbstractModel):
    r"""CreateUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserSyncProvisionings: CAM user synchronization information.
        :type UserSyncProvisionings: list of UserSyncProvisioning
        """
        self._ZoneId = None
        self._UserSyncProvisionings = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserSyncProvisionings(self):
        r"""CAM user synchronization information.
        :rtype: list of UserSyncProvisioning
        """
        return self._UserSyncProvisionings

    @UserSyncProvisionings.setter
    def UserSyncProvisionings(self, UserSyncProvisionings):
        self._UserSyncProvisionings = UserSyncProvisionings


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("UserSyncProvisionings") is not None:
            self._UserSyncProvisionings = []
            for item in params.get("UserSyncProvisionings"):
                obj = UserSyncProvisioning()
                obj._deserialize(item)
                self._UserSyncProvisionings.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserSyncProvisioningResponse(AbstractModel):
    r"""CreateUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.
        :type Tasks: list of UserProvisioningsTask
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        r"""Task details.
        :rtype: list of UserProvisioningsTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = UserProvisioningsTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteGroupRequest(AbstractModel):
    r"""DeleteGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        """
        self._ZoneId = None
        self._GroupId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGroupResponse(AbstractModel):
    r"""DeleteGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrgServiceAssignRequest(AbstractModel):
    r"""DeleteOrgServiceAssign request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Uin of the delegated admin.
        :type MemberUin: int
        :param _ServiceId: Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :type ServiceId: int
        """
        self._MemberUin = None
        self._ServiceId = None

    @property
    def MemberUin(self):
        r"""Uin of the delegated admin.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def ServiceId(self):
        r"""Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :rtype: int
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._ServiceId = params.get("ServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrgServiceAssignResponse(AbstractModel):
    r"""DeleteOrgServiceAssign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationIdentityRequest(AbstractModel):
    r"""DeleteOrganizationIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityId: int
        """
        self._IdentityId = None

    @property
    def IdentityId(self):
        r"""Identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationIdentityResponse(AbstractModel):
    r"""DeleteOrganizationIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationMemberAuthIdentityRequest(AbstractModel):
    r"""DeleteOrganizationMemberAuthIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _IdentityId: Identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityId: int
        """
        self._MemberUin = None
        self._IdentityId = None

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def IdentityId(self):
        r"""Identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._IdentityId = params.get("IdentityId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationMemberAuthIdentityResponse(AbstractModel):
    r"""DeleteOrganizationMemberAuthIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationMembersPolicyRequest(AbstractModel):
    r"""DeleteOrganizationMembersPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _PolicyId: Access policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        """
        self._PolicyId = None

    @property
    def PolicyId(self):
        r"""Access policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationMembersPolicyResponse(AbstractModel):
    r"""DeleteOrganizationMembersPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationMembersRequest(AbstractModel):
    r"""DeleteOrganizationMembers request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Uin list of the deleted members.
        :type MemberUin: list of int
        """
        self._MemberUin = None

    @property
    def MemberUin(self):
        r"""Uin list of the deleted members.
        :rtype: list of int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationMembersResponse(AbstractModel):
    r"""DeleteOrganizationMembers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationNodesRequest(AbstractModel):
    r"""DeleteOrganizationNodes request structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Node ID list, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: list of int
        """
        self._NodeId = None

    @property
    def NodeId(self):
        r"""Node ID list, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :rtype: list of int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationNodesResponse(AbstractModel):
    r"""DeleteOrganizationNodes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationRequest(AbstractModel):
    r"""DeleteOrganization request structure.

    """


class DeleteOrganizationResponse(AbstractModel):
    r"""DeleteOrganization response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoleAssignmentRequest(AbstractModel):
    r"""DeleteRoleAssignment request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _PrincipalType: Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :type PrincipalType: str
        :param _PrincipalId: User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-********). When PrincipalType is User, it is a user ID (u-********).
        :type PrincipalId: str
        :param _DeprovisionStrategy: Whether to remove the permission configuration deployment when removing the last authorization with a certain permission configuration from a target account in TCO. Valid values: DeprovisionForLastRoleAssignmentOnAccount: Remove the permission configuration deployment. None (default): Do not remove the permission configuration deployment.
        :type DeprovisionStrategy: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._TargetType = None
        self._TargetUin = None
        self._PrincipalType = None
        self._PrincipalId = None
        self._DeprovisionStrategy = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        r"""UIN of the target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def PrincipalType(self):
        r"""Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalId(self):
        r"""User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-********). When PrincipalType is User, it is a user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def DeprovisionStrategy(self):
        r"""Whether to remove the permission configuration deployment when removing the last authorization with a certain permission configuration from a target account in TCO. Valid values: DeprovisionForLastRoleAssignmentOnAccount: Remove the permission configuration deployment. None (default): Do not remove the permission configuration deployment.
        :rtype: str
        """
        return self._DeprovisionStrategy

    @DeprovisionStrategy.setter
    def DeprovisionStrategy(self, DeprovisionStrategy):
        self._DeprovisionStrategy = DeprovisionStrategy


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalId = params.get("PrincipalId")
        self._DeprovisionStrategy = params.get("DeprovisionStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoleAssignmentResponse(AbstractModel):
    r"""DeleteRoleAssignment response structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task details.
        :type Task: :class:`tencentcloud.organization.v20210331.models.TaskInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Task = None
        self._RequestId = None

    @property
    def Task(self):
        r"""Task details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.TaskInfo`
        """
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = TaskInfo()
            self._Task._deserialize(params.get("Task"))
        self._RequestId = params.get("RequestId")


class DeleteRoleConfigurationRequest(AbstractModel):
    r"""DeleteRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoleConfigurationResponse(AbstractModel):
    r"""DeleteRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSCIMCredentialRequest(AbstractModel):
    r"""DeleteSCIMCredential request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _CredentialId: SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :type CredentialId: str
        """
        self._ZoneId = None
        self._CredentialId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CredentialId(self):
        r"""SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._CredentialId

    @CredentialId.setter
    def CredentialId(self, CredentialId):
        self._CredentialId = CredentialId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CredentialId = params.get("CredentialId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSCIMCredentialResponse(AbstractModel):
    r"""DeleteSCIMCredential response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteShareUnitMembersRequest(AbstractModel):
    r"""DeleteShareUnitMembers request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Area: Shared unit region.
        :type Area: str
        :param _Members: Member list.
        :type Members: list of ShareMember
        """
        self._UnitId = None
        self._Area = None
        self._Members = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Members(self):
        r"""Member list.
        :rtype: list of ShareMember
        """
        return self._Members

    @Members.setter
    def Members(self, Members):
        self._Members = Members


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Area = params.get("Area")
        if params.get("Members") is not None:
            self._Members = []
            for item in params.get("Members"):
                obj = ShareMember()
                obj._deserialize(item)
                self._Members.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteShareUnitMembersResponse(AbstractModel):
    r"""DeleteShareUnitMembers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteShareUnitRequest(AbstractModel):
    r"""DeleteShareUnit request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        """
        self._UnitId = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteShareUnitResourcesRequest(AbstractModel):
    r"""DeleteShareUnitResources request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Area: Shared unit region.
        :type Area: str
        :param _Type: Shared resource type. For supported shared resource types, see [Overview of Resource Sharing](https://intl.cloud.tencent.com/document/product/850/59489?from_cn_redirect=1).
        :type Type: str
        :param _Resources: Shared resource list. Maximum: 10.
        :type Resources: list of ShareResource
        """
        self._UnitId = None
        self._Area = None
        self._Type = None
        self._Resources = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Type(self):
        r"""Shared resource type. For supported shared resource types, see [Overview of Resource Sharing](https://intl.cloud.tencent.com/document/product/850/59489?from_cn_redirect=1).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Resources(self):
        r"""Shared resource list. Maximum: 10.
        :rtype: list of ShareResource
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Area = params.get("Area")
        self._Type = params.get("Type")
        if params.get("Resources") is not None:
            self._Resources = []
            for item in params.get("Resources"):
                obj = ShareResource()
                obj._deserialize(item)
                self._Resources.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteShareUnitResourcesResponse(AbstractModel):
    r"""DeleteShareUnitResources response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteShareUnitResponse(AbstractModel):
    r"""DeleteShareUnit response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserRequest(AbstractModel):
    r"""DeleteUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID.
        :type UserId: str
        """
        self._ZoneId = None
        self._UserId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserResponse(AbstractModel):
    r"""DeleteUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserSyncProvisioningRequest(AbstractModel):
    r"""DeleteUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserProvisioningId: User synchronization ID.
        :type UserProvisioningId: str
        """
        self._ZoneId = None
        self._UserProvisioningId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserProvisioningId(self):
        r"""User synchronization ID.
        :rtype: str
        """
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserProvisioningId = params.get("UserProvisioningId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserSyncProvisioningResponse(AbstractModel):
    r"""DeleteUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.
        :type Tasks: :class:`tencentcloud.organization.v20210331.models.UserProvisioningsTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        r"""Task details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.UserProvisioningsTask`
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = UserProvisioningsTask()
            self._Tasks._deserialize(params.get("Tasks"))
        self._RequestId = params.get("RequestId")


class DescribeIdentityCenterRequest(AbstractModel):
    r"""DescribeIdentityCenter request structure.

    """


class DescribeIdentityCenterResponse(AbstractModel):
    r"""DescribeIdentityCenter response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _ZoneName: Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :type ZoneName: str
        :param _ServiceStatus: Service activation status. Disabled: not activated; Enabled: activated.
        :type ServiceStatus: str
        :param _ScimSyncStatus: SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :type ScimSyncStatus: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateTime: Update date
        :type UpdateTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._ZoneName = None
        self._ServiceStatus = None
        self._ScimSyncStatus = None
        self._CreateTime = None
        self._UpdateTime = None
        self._RequestId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ZoneName(self):
        r"""Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def ServiceStatus(self):
        r"""Service activation status. Disabled: not activated; Enabled: activated.
        :rtype: str
        """
        return self._ServiceStatus

    @ServiceStatus.setter
    def ServiceStatus(self, ServiceStatus):
        self._ServiceStatus = ServiceStatus

    @property
    def ScimSyncStatus(self):
        r"""SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :rtype: str
        """
        return self._ScimSyncStatus

    @ScimSyncStatus.setter
    def ScimSyncStatus(self, ScimSyncStatus):
        self._ScimSyncStatus = ScimSyncStatus

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update date
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ZoneName = params.get("ZoneName")
        self._ServiceStatus = params.get("ServiceStatus")
        self._ScimSyncStatus = params.get("ScimSyncStatus")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberAuthAccountsRequest(AbstractModel):
    r"""DescribeOrganizationMemberAuthAccounts request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyId: Policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        """
        self._Offset = None
        self._Limit = None
        self._MemberUin = None
        self._PolicyId = None

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1-50. Default value: 10.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyId(self):
        r"""Policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MemberUin = params.get("MemberUin")
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberAuthAccountsResponse(AbstractModel):
    r"""DescribeOrganizationMemberAuthAccounts response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgMemberAuthAccount
        :param _Total: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        r"""List
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgMemberAuthAccount
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        r"""Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMemberAuthAccount()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberAuthIdentitiesRequest(AbstractModel):
    r"""DescribeOrganizationMemberAuthIdentities request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset, which is an integer multiple of the value of `Limit`. Default value: `0`.
        :type Offset: int
        :param _Limit: Limit, which defaults to `10`. Value range: 1-50.
        :type Limit: int
        :param _MemberUin: Uin of the organization member. At least one of the input parameters MemberUin and IdentityId must be entered.
        :type MemberUin: int
        :param _IdentityId: Identity ID. At least one of the input parameters MemberUin and IdentityId must be provided. It can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityId: int
        """
        self._Offset = None
        self._Limit = None
        self._MemberUin = None
        self._IdentityId = None

    @property
    def Offset(self):
        r"""Offset, which is an integer multiple of the value of `Limit`. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit, which defaults to `10`. Value range: 1-50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MemberUin(self):
        r"""Uin of the organization member. At least one of the input parameters MemberUin and IdentityId must be entered.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def IdentityId(self):
        r"""Identity ID. At least one of the input parameters MemberUin and IdentityId must be provided. It can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MemberUin = params.get("MemberUin")
        self._IdentityId = params.get("IdentityId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberAuthIdentitiesResponse(AbstractModel):
    r"""DescribeOrganizationMemberAuthIdentities response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List of authorizable identities
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgMemberAuthIdentity
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        r"""List of authorizable identities
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgMemberAuthIdentity
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        r"""Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMemberAuthIdentity()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberEmailBindRequest(AbstractModel):
    r"""DescribeOrganizationMemberEmailBind request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member uin.
        :type MemberUin: int
        """
        self._MemberUin = None

    @property
    def MemberUin(self):
        r"""Member uin.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberEmailBindResponse(AbstractModel):
    r"""DescribeOrganizationMemberEmailBind response structure.

    """

    def __init__(self):
        r"""
        :param _BindId: Bound ID.
        :type BindId: int
        :param _ApplyTime: Application time.
        :type ApplyTime: str
        :param _Email: Email address.
        :type Email: str
        :param _Phone: Verification mobile number.
        :type Phone: str
        :param _BindStatus: Binding status: unbound indicates not bound; valid indicates to be activated; success indicates bound successfully; failed indicates binding failed.
        :type BindStatus: str
        :param _BindTime: Binding time.
        :type BindTime: str
        :param _Description: Failure description.
        :type Description: str
        :param _PhoneBind: Verification mobile number binding status. 0 indicates unbound and 1 indicates bound.
        :type PhoneBind: int
        :param _CountryCode: International area code.
        :type CountryCode: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BindId = None
        self._ApplyTime = None
        self._Email = None
        self._Phone = None
        self._BindStatus = None
        self._BindTime = None
        self._Description = None
        self._PhoneBind = None
        self._CountryCode = None
        self._RequestId = None

    @property
    def BindId(self):
        r"""Bound ID.
        :rtype: int
        """
        return self._BindId

    @BindId.setter
    def BindId(self, BindId):
        self._BindId = BindId

    @property
    def ApplyTime(self):
        r"""Application time.
        :rtype: str
        """
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def Email(self):
        r"""Email address.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Phone(self):
        r"""Verification mobile number.
        :rtype: str
        """
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone

    @property
    def BindStatus(self):
        r"""Binding status: unbound indicates not bound; valid indicates to be activated; success indicates bound successfully; failed indicates binding failed.
        :rtype: str
        """
        return self._BindStatus

    @BindStatus.setter
    def BindStatus(self, BindStatus):
        self._BindStatus = BindStatus

    @property
    def BindTime(self):
        r"""Binding time.
        :rtype: str
        """
        return self._BindTime

    @BindTime.setter
    def BindTime(self, BindTime):
        self._BindTime = BindTime

    @property
    def Description(self):
        r"""Failure description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PhoneBind(self):
        r"""Verification mobile number binding status. 0 indicates unbound and 1 indicates bound.
        :rtype: int
        """
        return self._PhoneBind

    @PhoneBind.setter
    def PhoneBind(self, PhoneBind):
        self._PhoneBind = PhoneBind

    @property
    def CountryCode(self):
        r"""International area code.
        :rtype: str
        """
        return self._CountryCode

    @CountryCode.setter
    def CountryCode(self, CountryCode):
        self._CountryCode = CountryCode

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BindId = params.get("BindId")
        self._ApplyTime = params.get("ApplyTime")
        self._Email = params.get("Email")
        self._Phone = params.get("Phone")
        self._BindStatus = params.get("BindStatus")
        self._BindTime = params.get("BindTime")
        self._Description = params.get("Description")
        self._PhoneBind = params.get("PhoneBind")
        self._CountryCode = params.get("CountryCode")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberPoliciesRequest(AbstractModel):
    r"""DescribeOrganizationMemberPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _SearchKey: Search keyword, which can be the policy name or description.
        :type SearchKey: str
        """
        self._Offset = None
        self._Limit = None
        self._MemberUin = None
        self._SearchKey = None

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1-50. Default value: 10.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def SearchKey(self):
        r"""Search keyword, which can be the policy name or description.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MemberUin = params.get("MemberUin")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberPoliciesResponse(AbstractModel):
    r"""DescribeOrganizationMemberPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgMemberPolicy
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        r"""List.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgMemberPolicy
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        r"""Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMemberPolicy()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMembersRequest(AbstractModel):
    r"""DescribeOrganizationMembers request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset, which is an integer multiple of the value of `Limit`. Default value: `0`.
        :type Offset: int
        :param _Limit: Limit, which defaults to `10`. Value range: 1-50.
        :type Limit: int
        :param _Lang: Valid values: `en` (Tencent Cloud International); `zh` (Tencent Cloud).
        :type Lang: str
        :param _SearchKey: Search by member name or ID.
        :type SearchKey: str
        :param _AuthName: Entity name.
        :type AuthName: str
        :param _Product: Abbreviation of the trusted service, which is required during querying the trusted service admin.
        :type Product: str
        :param _Tags: Member tag search list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._Offset = None
        self._Limit = None
        self._Lang = None
        self._SearchKey = None
        self._AuthName = None
        self._Product = None
        self._Tags = None

    @property
    def Offset(self):
        r"""Offset, which is an integer multiple of the value of `Limit`. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit, which defaults to `10`. Value range: 1-50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Lang(self):
        r"""Valid values: `en` (Tencent Cloud International); `zh` (Tencent Cloud).
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def SearchKey(self):
        r"""Search by member name or ID.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey

    @property
    def AuthName(self):
        r"""Entity name.
        :rtype: str
        """
        return self._AuthName

    @AuthName.setter
    def AuthName(self, AuthName):
        self._AuthName = AuthName

    @property
    def Product(self):
        r"""Abbreviation of the trusted service, which is required during querying the trusted service admin.
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Tags(self):
        r"""Member tag search list, with a maximum of 10.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Lang = params.get("Lang")
        self._SearchKey = params.get("SearchKey")
        self._AuthName = params.get("AuthName")
        self._Product = params.get("Product")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMembersResponse(AbstractModel):
    r"""DescribeOrganizationMembers response structure.

    """

    def __init__(self):
        r"""
        :param _Items: Member list.
        :type Items: list of OrgMember
        :param _Total: Total number.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        r"""Member list.
        :rtype: list of OrgMember
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        r"""Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMember()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationNodesRequest(AbstractModel):
    r"""DescribeOrganizationNodes request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Maximum number of returned results. Maximum value: `50`.
        :type Limit: int
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Tags: Department tag search list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._Limit = None
        self._Offset = None
        self._Tags = None

    @property
    def Limit(self):
        r"""Maximum number of returned results. Maximum value: `50`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Tags(self):
        r"""Department tag search list, with a maximum of 10.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationNodesResponse(AbstractModel):
    r"""DescribeOrganizationNodes response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: List details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgNode
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""List details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgNode
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgNode()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOrganizationRequest(AbstractModel):
    r"""DescribeOrganization request structure.

    """

    def __init__(self):
        r"""
        :param _Lang: Valid values: `en` (Tencent Cloud International); `zh` (Tencent Cloud).
        :type Lang: str
        :param _Product: Abbreviation of the trusted service, which is required during querying the trusted service admin.
        :type Product: str
        """
        self._Lang = None
        self._Product = None

    @property
    def Lang(self):
        r"""Valid values: `en` (Tencent Cloud International); `zh` (Tencent Cloud).
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def Product(self):
        r"""Abbreviation of the trusted service, which is required during querying the trusted service admin.
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product


    def _deserialize(self, params):
        self._Lang = params.get("Lang")
        self._Product = params.get("Product")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationResponse(AbstractModel):
    r"""DescribeOrganization response structure.

    """

    def __init__(self):
        r"""
        :param _OrgId: Organization ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgId: int
        :param _HostUin: Creator UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostUin: int
        :param _NickName: Creator name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NickName: str
        :param _OrgType: Organization type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgType: int
        :param _IsManager: Whether the member is the organization admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsManager: bool
        :param _OrgPolicyType: Policy type. Valid values: `Financial` (finance management).
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyType: str
        :param _OrgPolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyName: str
        :param _OrgPermission: List of member financial permissions.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPermission: list of OrgPermission
        :param _RootNodeId: Organization root node ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RootNodeId: int
        :param _CreateTime: Organization creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _JoinTime: Member joining time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type JoinTime: str
        :param _IsAllowQuit: Whether the member is allowed to leave. Valid values: `Allow`, `Denied`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayUin: str
        :param _PayName: Payer name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayName: str
        :param _IsAssignManager: Whether the member is the trusted service admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAssignManager: bool
        :param _IsAuthManager: Whether the member is the verified entity admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAuthManager: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OrgId = None
        self._HostUin = None
        self._NickName = None
        self._OrgType = None
        self._IsManager = None
        self._OrgPolicyType = None
        self._OrgPolicyName = None
        self._OrgPermission = None
        self._RootNodeId = None
        self._CreateTime = None
        self._JoinTime = None
        self._IsAllowQuit = None
        self._PayUin = None
        self._PayName = None
        self._IsAssignManager = None
        self._IsAuthManager = None
        self._RequestId = None

    @property
    def OrgId(self):
        r"""Organization ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._OrgId

    @OrgId.setter
    def OrgId(self, OrgId):
        self._OrgId = OrgId

    @property
    def HostUin(self):
        r"""Creator UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._HostUin

    @HostUin.setter
    def HostUin(self, HostUin):
        self._HostUin = HostUin

    @property
    def NickName(self):
        r"""Creator name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NickName

    @NickName.setter
    def NickName(self, NickName):
        self._NickName = NickName

    @property
    def OrgType(self):
        r"""Organization type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._OrgType

    @OrgType.setter
    def OrgType(self, OrgType):
        self._OrgType = OrgType

    @property
    def IsManager(self):
        r"""Whether the member is the organization admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsManager

    @IsManager.setter
    def IsManager(self, IsManager):
        self._IsManager = IsManager

    @property
    def OrgPolicyType(self):
        r"""Policy type. Valid values: `Financial` (finance management).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OrgPolicyType

    @OrgPolicyType.setter
    def OrgPolicyType(self, OrgPolicyType):
        self._OrgPolicyType = OrgPolicyType

    @property
    def OrgPolicyName(self):
        r"""Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OrgPolicyName

    @OrgPolicyName.setter
    def OrgPolicyName(self, OrgPolicyName):
        self._OrgPolicyName = OrgPolicyName

    @property
    def OrgPermission(self):
        r"""List of member financial permissions.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgPermission
        """
        return self._OrgPermission

    @OrgPermission.setter
    def OrgPermission(self, OrgPermission):
        self._OrgPermission = OrgPermission

    @property
    def RootNodeId(self):
        r"""Organization root node ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RootNodeId

    @RootNodeId.setter
    def RootNodeId(self, RootNodeId):
        self._RootNodeId = RootNodeId

    @property
    def CreateTime(self):
        r"""Organization creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def JoinTime(self):
        r"""Member joining time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._JoinTime

    @JoinTime.setter
    def JoinTime(self, JoinTime):
        self._JoinTime = JoinTime

    @property
    def IsAllowQuit(self):
        r"""Whether the member is allowed to leave. Valid values: `Allow`, `Denied`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        r"""Payer UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def PayName(self):
        r"""Payer name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PayName

    @PayName.setter
    def PayName(self, PayName):
        self._PayName = PayName

    @property
    def IsAssignManager(self):
        r"""Whether the member is the trusted service admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsAssignManager

    @IsAssignManager.setter
    def IsAssignManager(self, IsAssignManager):
        self._IsAssignManager = IsAssignManager

    @property
    def IsAuthManager(self):
        r"""Whether the member is the verified entity admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsAuthManager

    @IsAuthManager.setter
    def IsAuthManager(self, IsAuthManager):
        self._IsAuthManager = IsAuthManager

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OrgId = params.get("OrgId")
        self._HostUin = params.get("HostUin")
        self._NickName = params.get("NickName")
        self._OrgType = params.get("OrgType")
        self._IsManager = params.get("IsManager")
        self._OrgPolicyType = params.get("OrgPolicyType")
        self._OrgPolicyName = params.get("OrgPolicyName")
        if params.get("OrgPermission") is not None:
            self._OrgPermission = []
            for item in params.get("OrgPermission"):
                obj = OrgPermission()
                obj._deserialize(item)
                self._OrgPermission.append(obj)
        self._RootNodeId = params.get("RootNodeId")
        self._CreateTime = params.get("CreateTime")
        self._JoinTime = params.get("JoinTime")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        self._PayName = params.get("PayName")
        self._IsAssignManager = params.get("IsAssignManager")
        self._IsAuthManager = params.get("IsAuthManager")
        self._RequestId = params.get("RequestId")


class DescribeShareAreasRequest(AbstractModel):
    r"""DescribeShareAreas request structure.

    """

    def __init__(self):
        r"""
        :param _Lang: Valid values: en (Tencent Cloud International); zh (Tencent Cloud).
        :type Lang: str
        """
        self._Lang = None

    @property
    def Lang(self):
        r"""Valid values: en (Tencent Cloud International); zh (Tencent Cloud).
        :rtype: str
        """
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang


    def _deserialize(self, params):
        self._Lang = params.get("Lang")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeShareAreasResponse(AbstractModel):
    r"""DescribeShareAreas response structure.

    """

    def __init__(self):
        r"""
        :param _Items: Details.
        :type Items: list of ShareArea
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._RequestId = None

    @property
    def Items(self):
        r"""Details.
        :rtype: list of ShareArea
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ShareArea()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeShareUnitMembersRequest(AbstractModel):
    r"""DescribeShareUnitMembers request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Area: Shared unit region.
        :type Area: str
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1–50.
        :type Limit: int
        :param _SearchKey: Search keyword. Member UIN search is supported.
        :type SearchKey: str
        """
        self._UnitId = None
        self._Area = None
        self._Offset = None
        self._Limit = None
        self._SearchKey = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1–50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        r"""Search keyword. Member UIN search is supported.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Area = params.get("Area")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeShareUnitMembersResponse(AbstractModel):
    r"""DescribeShareUnitMembers response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
        :type Total: int
        :param _Items: Shared unit member list.
        :type Items: list of ShareUnitMember
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""Shared unit member list.
        :rtype: list of ShareUnitMember
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ShareUnitMember()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeShareUnitResourcesRequest(AbstractModel):
    r"""DescribeShareUnitResources request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Area: Shared unit region.
        :type Area: str
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1–50.
        :type Limit: int
        :param _SearchKey: Search keyword. Product resource ID search is supported.
        :type SearchKey: str
        :param _Type: Shared resource type. For supported shared resource types, see [Overview of Resource Sharing](https://intl.cloud.tencent.com/document/product/850/59489?from_cn_redirect=1).
        :type Type: str
        """
        self._UnitId = None
        self._Area = None
        self._Offset = None
        self._Limit = None
        self._SearchKey = None
        self._Type = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1–50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        r"""Search keyword. Product resource ID search is supported.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey

    @property
    def Type(self):
        r"""Shared resource type. For supported shared resource types, see [Overview of Resource Sharing](https://intl.cloud.tencent.com/document/product/850/59489?from_cn_redirect=1).
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Area = params.get("Area")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeShareUnitResourcesResponse(AbstractModel):
    r"""DescribeShareUnitResources response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
        :type Total: int
        :param _Items: Shared unit resource list.
        :type Items: list of ShareUnitResource
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""Shared unit resource list.
        :rtype: list of ShareUnitResource
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ShareUnitResource()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeShareUnitsRequest(AbstractModel):
    r"""DescribeShareUnits request structure.

    """

    def __init__(self):
        r"""
        :param _Area: Shared unit region. You can obtain supported shared regions through the API [DescribeShareAreas](https://intl.cloud.tencent.com/document/product/850/103050?from_cn_redirect=1).
        :type Area: str
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1–50.
        :type Limit: int
        :param _SearchKey: Search keyword. UnitId and Name search is supported.
        :type SearchKey: str
        """
        self._Area = None
        self._Offset = None
        self._Limit = None
        self._SearchKey = None

    @property
    def Area(self):
        r"""Shared unit region. You can obtain supported shared regions through the API [DescribeShareAreas](https://intl.cloud.tencent.com/document/product/850/103050?from_cn_redirect=1).
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1–50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        r"""Search keyword. UnitId and Name search is supported.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._Area = params.get("Area")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeShareUnitsResponse(AbstractModel):
    r"""DescribeShareUnits response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
        :type Total: int
        :param _Items: Shared unit list.
        :type Items: list of ManagerShareUnit
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""Shared unit list.
        :rtype: list of ManagerShareUnit
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ManagerShareUnit()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DismantleRoleConfigurationRequest(AbstractModel):
    r"""DismantleRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._TargetType = None
        self._TargetUin = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        r"""UIN of the synchronized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DismantleRoleConfigurationResponse(AbstractModel):
    r"""DismantleRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task details.
        :type Task: :class:`tencentcloud.organization.v20210331.models.RoleProvisioningsTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Task = None
        self._RequestId = None

    @property
    def Task(self):
        r"""Task details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.RoleProvisioningsTask`
        """
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = RoleProvisioningsTask()
            self._Task._deserialize(params.get("Task"))
        self._RequestId = params.get("RequestId")


class GetExternalSAMLIdentityProviderRequest(AbstractModel):
    r"""GetExternalSAMLIdentityProvider request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetExternalSAMLIdentityProviderResponse(AbstractModel):
    r"""GetExternalSAMLIdentityProvider response structure.

    """

    def __init__(self):
        r"""
        :param _SAMLIdentityProviderConfiguration: SAML identity provider configuration information.
        :type SAMLIdentityProviderConfiguration: :class:`tencentcloud.organization.v20210331.models.SAMLIdentityProviderConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SAMLIdentityProviderConfiguration = None
        self._RequestId = None

    @property
    def SAMLIdentityProviderConfiguration(self):
        r"""SAML identity provider configuration information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.SAMLIdentityProviderConfiguration`
        """
        return self._SAMLIdentityProviderConfiguration

    @SAMLIdentityProviderConfiguration.setter
    def SAMLIdentityProviderConfiguration(self, SAMLIdentityProviderConfiguration):
        self._SAMLIdentityProviderConfiguration = SAMLIdentityProviderConfiguration

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SAMLIdentityProviderConfiguration") is not None:
            self._SAMLIdentityProviderConfiguration = SAMLIdentityProviderConfiguration()
            self._SAMLIdentityProviderConfiguration._deserialize(params.get("SAMLIdentityProviderConfiguration"))
        self._RequestId = params.get("RequestId")


class GetGroupRequest(AbstractModel):
    r"""GetGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        """
        self._ZoneId = None
        self._GroupId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetGroupResponse(AbstractModel):
    r"""GetGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupInfo: User group information.
        :type GroupInfo: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupInfo = None
        self._RequestId = None

    @property
    def GroupInfo(self):
        r"""User group information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        """
        return self._GroupInfo

    @GroupInfo.setter
    def GroupInfo(self, GroupInfo):
        self._GroupInfo = GroupInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupInfo") is not None:
            self._GroupInfo = GroupInfo()
            self._GroupInfo._deserialize(params.get("GroupInfo"))
        self._RequestId = params.get("RequestId")


class GetProvisioningTaskStatusRequest(AbstractModel):
    r"""GetProvisioningTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _TaskId: Task ID.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetProvisioningTaskStatusResponse(AbstractModel):
    r"""GetProvisioningTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status information.
        :type TaskStatus: :class:`tencentcloud.organization.v20210331.models.TaskStatus`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        r"""Task status information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.TaskStatus`
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskStatus") is not None:
            self._TaskStatus = TaskStatus()
            self._TaskStatus._deserialize(params.get("TaskStatus"))
        self._RequestId = params.get("RequestId")


class GetRoleConfigurationRequest(AbstractModel):
    r"""GetRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetRoleConfigurationResponse(AbstractModel):
    r"""GetRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationInfo: Permission configuration details.
        :type RoleConfigurationInfo: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleConfigurationInfo = None
        self._RequestId = None

    @property
    def RoleConfigurationInfo(self):
        r"""Permission configuration details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        """
        return self._RoleConfigurationInfo

    @RoleConfigurationInfo.setter
    def RoleConfigurationInfo(self, RoleConfigurationInfo):
        self._RoleConfigurationInfo = RoleConfigurationInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoleConfigurationInfo") is not None:
            self._RoleConfigurationInfo = RoleConfiguration()
            self._RoleConfigurationInfo._deserialize(params.get("RoleConfigurationInfo"))
        self._RequestId = params.get("RequestId")


class GetSCIMSynchronizationStatusRequest(AbstractModel):
    r"""GetSCIMSynchronizationStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetSCIMSynchronizationStatusResponse(AbstractModel):
    r"""GetSCIMSynchronizationStatus response structure.

    """

    def __init__(self):
        r"""
        :param _SCIMSynchronizationStatus: SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :type SCIMSynchronizationStatus: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SCIMSynchronizationStatus = None
        self._RequestId = None

    @property
    def SCIMSynchronizationStatus(self):
        r"""SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :rtype: str
        """
        return self._SCIMSynchronizationStatus

    @SCIMSynchronizationStatus.setter
    def SCIMSynchronizationStatus(self, SCIMSynchronizationStatus):
        self._SCIMSynchronizationStatus = SCIMSynchronizationStatus

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SCIMSynchronizationStatus = params.get("SCIMSynchronizationStatus")
        self._RequestId = params.get("RequestId")


class GetTaskStatusRequest(AbstractModel):
    r"""GetTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _TaskId: Task ID.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetTaskStatusResponse(AbstractModel):
    r"""GetTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status information.
        :type TaskStatus: :class:`tencentcloud.organization.v20210331.models.TaskStatus`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        r"""Task status information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.TaskStatus`
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskStatus") is not None:
            self._TaskStatus = TaskStatus()
            self._TaskStatus._deserialize(params.get("TaskStatus"))
        self._RequestId = params.get("RequestId")


class GetUserRequest(AbstractModel):
    r"""GetUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID.
        :type UserId: str
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._UserId = None
        self._ZoneId = None

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetUserResponse(AbstractModel):
    r"""GetUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User information.
        :type UserInfo: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""User information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class GetUserSyncProvisioningRequest(AbstractModel):
    r"""GetUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserProvisioningId: ID of the CAM user synchronization.
        :type UserProvisioningId: str
        """
        self._ZoneId = None
        self._UserProvisioningId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserProvisioningId(self):
        r"""ID of the CAM user synchronization.
        :rtype: str
        """
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserProvisioningId = params.get("UserProvisioningId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetUserSyncProvisioningResponse(AbstractModel):
    r"""GetUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _UserProvisioning: CAM user synchronization information.
        :type UserProvisioning: :class:`tencentcloud.organization.v20210331.models.UserProvisioning`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserProvisioning = None
        self._RequestId = None

    @property
    def UserProvisioning(self):
        r"""CAM user synchronization information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.UserProvisioning`
        """
        return self._UserProvisioning

    @UserProvisioning.setter
    def UserProvisioning(self, UserProvisioning):
        self._UserProvisioning = UserProvisioning

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserProvisioning") is not None:
            self._UserProvisioning = UserProvisioning()
            self._UserProvisioning._deserialize(params.get("UserProvisioning"))
        self._RequestId = params.get("RequestId")


class GetZoneSAMLServiceProviderInfoRequest(AbstractModel):
    r"""GetZoneSAMLServiceProviderInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetZoneSAMLServiceProviderInfoResponse(AbstractModel):
    r"""GetZoneSAMLServiceProviderInfo response structure.

    """

    def __init__(self):
        r"""
        :param _SAMLServiceProvider: SAML service provider configuration information.
        :type SAMLServiceProvider: :class:`tencentcloud.organization.v20210331.models.SAMLServiceProvider`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SAMLServiceProvider = None
        self._RequestId = None

    @property
    def SAMLServiceProvider(self):
        r"""SAML service provider configuration information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.SAMLServiceProvider`
        """
        return self._SAMLServiceProvider

    @SAMLServiceProvider.setter
    def SAMLServiceProvider(self, SAMLServiceProvider):
        self._SAMLServiceProvider = SAMLServiceProvider

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SAMLServiceProvider") is not None:
            self._SAMLServiceProvider = SAMLServiceProvider()
            self._SAMLServiceProvider._deserialize(params.get("SAMLServiceProvider"))
        self._RequestId = params.get("RequestId")


class GetZoneStatisticsRequest(AbstractModel):
    r"""GetZoneStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetZoneStatisticsResponse(AbstractModel):
    r"""GetZoneStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneStatistics: Space statistics.
        :type ZoneStatistics: :class:`tencentcloud.organization.v20210331.models.ZoneStatistics`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneStatistics = None
        self._RequestId = None

    @property
    def ZoneStatistics(self):
        r"""Space statistics.
        :rtype: :class:`tencentcloud.organization.v20210331.models.ZoneStatistics`
        """
        return self._ZoneStatistics

    @ZoneStatistics.setter
    def ZoneStatistics(self, ZoneStatistics):
        self._ZoneStatistics = ZoneStatistics

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ZoneStatistics") is not None:
            self._ZoneStatistics = ZoneStatistics()
            self._ZoneStatistics._deserialize(params.get("ZoneStatistics"))
        self._RequestId = params.get("RequestId")


class GroupInfo(AbstractModel):
    r"""User group information.

    """

    def __init__(self):
        r"""
        :param _GroupName: User group name.
        :type GroupName: str
        :param _Description: User group description.
        :type Description: str
        :param _CreateTime: Creation time of the user group.
        :type CreateTime: str
        :param _GroupType: User group type. Manual: manually created; Synchronized: externally imported.
        :type GroupType: str
        :param _UpdateTime: Modification time of the user group.
        :type UpdateTime: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _MemberCount: Number of group members.
        :type MemberCount: int
        :param _IsSelected: If the input parameter FilterUsers is provided, return true when the user is in the user group; otherwise, return false.
        :type IsSelected: bool
        """
        self._GroupName = None
        self._Description = None
        self._CreateTime = None
        self._GroupType = None
        self._UpdateTime = None
        self._GroupId = None
        self._MemberCount = None
        self._IsSelected = None

    @property
    def GroupName(self):
        r"""User group name.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        r"""User group description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time of the user group.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def GroupType(self):
        r"""User group type. Manual: manually created; Synchronized: externally imported.
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def UpdateTime(self):
        r"""Modification time of the user group.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def MemberCount(self):
        r"""Number of group members.
        :rtype: int
        """
        return self._MemberCount

    @MemberCount.setter
    def MemberCount(self, MemberCount):
        self._MemberCount = MemberCount

    @property
    def IsSelected(self):
        r"""If the input parameter FilterUsers is provided, return true when the user is in the user group; otherwise, return false.
        :rtype: bool
        """
        return self._IsSelected

    @IsSelected.setter
    def IsSelected(self, IsSelected):
        self._IsSelected = IsSelected


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._GroupType = params.get("GroupType")
        self._UpdateTime = params.get("UpdateTime")
        self._GroupId = params.get("GroupId")
        self._MemberCount = params.get("MemberCount")
        self._IsSelected = params.get("IsSelected")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupMembers(AbstractModel):
    r"""User information.

    """

    def __init__(self):
        r"""
        :param _UserName: Queried username.
        :type UserName: str
        :param _DisplayName: Display name of the user.
        :type DisplayName: str
        :param _Description: User description.
        :type Description: str
        :param _Email: Email address of the user, which must be unique within the directory.
        :type Email: str
        :param _UserStatus: User status: Enabled, Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created; Synchronized: externally imported.
        :type UserType: str
        :param _UserId: User ID.
        :type UserId: str
        :param _JoinTime: Time when the user joins the user group.
        :type JoinTime: str
        """
        self._UserName = None
        self._DisplayName = None
        self._Description = None
        self._Email = None
        self._UserStatus = None
        self._UserType = None
        self._UserId = None
        self._JoinTime = None

    @property
    def UserName(self):
        r"""Queried username.
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def DisplayName(self):
        r"""Display name of the user.
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        r"""User description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Email(self):
        r"""Email address of the user, which must be unique within the directory.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def UserStatus(self):
        r"""User status: Enabled, Disabled.
        :rtype: str
        """
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        r"""User type. Manual: manually created; Synchronized: externally imported.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def JoinTime(self):
        r"""Time when the user joins the user group.
        :rtype: str
        """
        return self._JoinTime

    @JoinTime.setter
    def JoinTime(self, JoinTime):
        self._JoinTime = JoinTime


    def _deserialize(self, params):
        self._UserName = params.get("UserName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._Email = params.get("Email")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        self._UserId = params.get("UserId")
        self._JoinTime = params.get("JoinTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IdentityPolicy(AbstractModel):
    r"""Organization identity policy

    """

    def __init__(self):
        r"""
        :param _PolicyId: CAM preset policy ID, which is valid and required when PolicyType is a preset policy.
        :type PolicyId: int
        :param _PolicyName: CAM preset policy name, which is valid and required when PolicyType is a preset policy.
        :type PolicyName: str
        :param _PolicyType: Policy type. Valid values: 1 (custom policy), 2 (preset policy). The default is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyType: int
        :param _PolicyDocument: Custom policy content, which follows the CAM policy syntax. It is valid and required when PolicyType is a custom policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyDocument: str
        """
        self._PolicyId = None
        self._PolicyName = None
        self._PolicyType = None
        self._PolicyDocument = None

    @property
    def PolicyId(self):
        r"""CAM preset policy ID, which is valid and required when PolicyType is a preset policy.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        r"""CAM preset policy name, which is valid and required when PolicyType is a preset policy.
        :rtype: str
        """
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def PolicyType(self):
        r"""Policy type. Valid values: 1 (custom policy), 2 (preset policy). The default is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PolicyDocument(self):
        r"""Custom policy content, which follows the CAM policy syntax. It is valid and required when PolicyType is a custom policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PolicyDocument

    @PolicyDocument.setter
    def PolicyDocument(self, PolicyDocument):
        self._PolicyDocument = PolicyDocument


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        self._PolicyType = params.get("PolicyType")
        self._PolicyDocument = params.get("PolicyDocument")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InviteOrganizationMemberRequest(AbstractModel):
    r"""InviteOrganizationMember request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: UIN of an invited account.
        :type MemberUin: int
        :param _Name: Member name, which contains up to 25 characters, including English letters, digits, and symbols `+@&._[]-:,`.
        :type Name: str
        :param _PolicyType: Relationship policy. Valid value: `Financial`.
        :type PolicyType: str
        :param _PermissionIds: Member Finanace Authorization. Valid values: 1: View Bills. 2: View Balance.  4: Consolidate Bills. 5: Invoice. 6: Inherit Offer. 7: Pay On Behalf. 8: Cost Explorer. 9: Budget Management.  1 and 2 are required.
        :type PermissionIds: list of int non-negative
        :param _NodeId: Node ID of the member's department, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _Remark: Remarks.
        :type Remark: str
        :param _IsAllowQuit: Whether to allow a member to exit. Valid values: Allow, Denied.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN, which is required when pay-on-behalf mode is used.
        :type PayUin: str
        :param _RelationAuthName: Name of a mutual trust real-name entity.
        :type RelationAuthName: str
        :param _AuthFile: List of proof files of a mutual trust entity.
        :type AuthFile: list of AuthRelationFile
        :param _Tags: Member tag list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._MemberUin = None
        self._Name = None
        self._PolicyType = None
        self._PermissionIds = None
        self._NodeId = None
        self._Remark = None
        self._IsAllowQuit = None
        self._PayUin = None
        self._RelationAuthName = None
        self._AuthFile = None
        self._Tags = None

    @property
    def MemberUin(self):
        r"""UIN of an invited account.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def Name(self):
        r"""Member name, which contains up to 25 characters, including English letters, digits, and symbols `+@&._[]-:,`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PolicyType(self):
        r"""Relationship policy. Valid value: `Financial`.
        :rtype: str
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PermissionIds(self):
        r"""Member Finanace Authorization. Valid values: 1: View Bills. 2: View Balance.  4: Consolidate Bills. 5: Invoice. 6: Inherit Offer. 7: Pay On Behalf. 8: Cost Explorer. 9: Budget Management.  1 and 2 are required.
        :rtype: list of int non-negative
        """
        return self._PermissionIds

    @PermissionIds.setter
    def PermissionIds(self, PermissionIds):
        self._PermissionIds = PermissionIds

    @property
    def NodeId(self):
        r"""Node ID of the member's department, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def IsAllowQuit(self):
        r"""Whether to allow a member to exit. Valid values: Allow, Denied.
        :rtype: str
        """
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        r"""Payer UIN, which is required when pay-on-behalf mode is used.
        :rtype: str
        """
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def RelationAuthName(self):
        r"""Name of a mutual trust real-name entity.
        :rtype: str
        """
        return self._RelationAuthName

    @RelationAuthName.setter
    def RelationAuthName(self, RelationAuthName):
        self._RelationAuthName = RelationAuthName

    @property
    def AuthFile(self):
        r"""List of proof files of a mutual trust entity.
        :rtype: list of AuthRelationFile
        """
        return self._AuthFile

    @AuthFile.setter
    def AuthFile(self, AuthFile):
        self._AuthFile = AuthFile

    @property
    def Tags(self):
        r"""Member tag list, with a maximum of 10.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._Name = params.get("Name")
        self._PolicyType = params.get("PolicyType")
        self._PermissionIds = params.get("PermissionIds")
        self._NodeId = params.get("NodeId")
        self._Remark = params.get("Remark")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        self._RelationAuthName = params.get("RelationAuthName")
        if params.get("AuthFile") is not None:
            self._AuthFile = []
            for item in params.get("AuthFile"):
                obj = AuthRelationFile()
                obj._deserialize(item)
                self._AuthFile.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InviteOrganizationMemberResponse(AbstractModel):
    r"""InviteOrganizationMember response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class JoinedGroups(AbstractModel):
    r"""User group joined by the user.

    """

    def __init__(self):
        r"""
        :param _GroupName: User group name.
        :type GroupName: str
        :param _Description: User group description.
        :type Description: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _GroupType: User group type. Valid values:

Manual: manually created.
Synchronized: externally synchronized.
        :type GroupType: str
        :param _JoinTime: Time of joining the user group.
        :type JoinTime: str
        """
        self._GroupName = None
        self._Description = None
        self._GroupId = None
        self._GroupType = None
        self._JoinTime = None

    @property
    def GroupName(self):
        r"""User group name.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        r"""User group description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupType(self):
        r"""User group type. Valid values:

Manual: manually created.
Synchronized: externally synchronized.
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def JoinTime(self):
        r"""Time of joining the user group.
        :rtype: str
        """
        return self._JoinTime

    @JoinTime.setter
    def JoinTime(self, JoinTime):
        self._JoinTime = JoinTime


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        self._GroupId = params.get("GroupId")
        self._GroupType = params.get("GroupType")
        self._JoinTime = params.get("JoinTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListExternalSAMLIdPCertificatesRequest(AbstractModel):
    r"""ListExternalSAMLIdPCertificates request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListExternalSAMLIdPCertificatesResponse(AbstractModel):
    r"""ListExternalSAMLIdPCertificates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _SAMLIdPCertificates: SAML signing certificate list.
        :type SAMLIdPCertificates: list of SAMLIdPCertificate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._SAMLIdPCertificates = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def SAMLIdPCertificates(self):
        r"""SAML signing certificate list.
        :rtype: list of SAMLIdPCertificate
        """
        return self._SAMLIdPCertificates

    @SAMLIdPCertificates.setter
    def SAMLIdPCertificates(self, SAMLIdPCertificates):
        self._SAMLIdPCertificates = SAMLIdPCertificates

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        if params.get("SAMLIdPCertificates") is not None:
            self._SAMLIdPCertificates = []
            for item in params.get("SAMLIdPCertificates"):
                obj = SAMLIdPCertificate()
                obj._deserialize(item)
                self._SAMLIdPCertificates.append(obj)
        self._RequestId = params.get("RequestId")


class ListGroupMembersRequest(AbstractModel):
    r"""ListGroupMembers request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User ID.
        :type GroupId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _UserType: Type of the user. Manual: manually created; Synchronized: imported from external sources.
        :type UserType: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._NextToken = None
        self._MaxResults = None
        self._UserType = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        r"""User ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def UserType(self):
        r"""Type of the user. Manual: manually created; Synchronized: imported from external sources.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._UserType = params.get("UserType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListGroupMembersResponse(AbstractModel):
    r"""ListGroupMembers response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _GroupMembers: The user list of a user group.
        :type GroupMembers: list of GroupMembers
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._GroupMembers = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def GroupMembers(self):
        r"""The user list of a user group.
        :rtype: list of GroupMembers
        """
        return self._GroupMembers

    @GroupMembers.setter
    def GroupMembers(self, GroupMembers):
        self._GroupMembers = GroupMembers

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("GroupMembers") is not None:
            self._GroupMembers = []
            for item in params.get("GroupMembers"):
                obj = GroupMembers()
                obj._deserialize(item)
                self._GroupMembers.append(obj)
        self._RequestId = params.get("RequestId")


class ListGroupsRequest(AbstractModel):
    r"""ListGroups request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _Filter: Filter criterion. Format: <Attribute> <Operator> <Value>, case-insensitive. Currently, <Attribute> supports only GroupName, and <Operator> supports only eq (Equals) and sw (Start With). For example, Filter = "GroupName sw test" indicates querying all user groups with names starting with test; Filter = "GroupName eq testgroup" indicates querying the user group with the name testgroup.
        :type Filter: str
        :param _GroupType: User group type. Manual: manually created; Synchronized: externally imported.
        :type GroupType: str
        :param _FilterUsers: Filtered user. IsSelected=1 will be returned for the user group associated with this user.
        :type FilterUsers: list of str
        :param _SortField: Sorting field, which currently only supports CreateTime. The default is the CreateTime field.
        :type SortField: str
        :param _SortType: Sorting type. Desc: descending order; Asc: ascending order. It should be set along with SortField.
        :type SortType: str
        :param _Offset: Pagination offset. Do not use it together with NextToken, prioritizing using NextToken.
        :type Offset: int
        """
        self._ZoneId = None
        self._NextToken = None
        self._MaxResults = None
        self._Filter = None
        self._GroupType = None
        self._FilterUsers = None
        self._SortField = None
        self._SortType = None
        self._Offset = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def Filter(self):
        r"""Filter criterion. Format: <Attribute> <Operator> <Value>, case-insensitive. Currently, <Attribute> supports only GroupName, and <Operator> supports only eq (Equals) and sw (Start With). For example, Filter = "GroupName sw test" indicates querying all user groups with names starting with test; Filter = "GroupName eq testgroup" indicates querying the user group with the name testgroup.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def GroupType(self):
        r"""User group type. Manual: manually created; Synchronized: externally imported.
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def FilterUsers(self):
        r"""Filtered user. IsSelected=1 will be returned for the user group associated with this user.
        :rtype: list of str
        """
        return self._FilterUsers

    @FilterUsers.setter
    def FilterUsers(self, FilterUsers):
        self._FilterUsers = FilterUsers

    @property
    def SortField(self):
        r"""Sorting field, which currently only supports CreateTime. The default is the CreateTime field.
        :rtype: str
        """
        return self._SortField

    @SortField.setter
    def SortField(self, SortField):
        self._SortField = SortField

    @property
    def SortType(self):
        r"""Sorting type. Desc: descending order; Asc: ascending order. It should be set along with SortField.
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def Offset(self):
        r"""Pagination offset. Do not use it together with NextToken, prioritizing using NextToken.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._Filter = params.get("Filter")
        self._GroupType = params.get("GroupType")
        self._FilterUsers = params.get("FilterUsers")
        self._SortField = params.get("SortField")
        self._SortType = params.get("SortType")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListGroupsResponse(AbstractModel):
    r"""ListGroups response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _Groups: User group list.
        :type Groups: list of GroupInfo
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._Groups = None
        self._MaxResults = None
        self._TotalCounts = None
        self._IsTruncated = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def Groups(self):
        r"""User group list.
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._MaxResults = params.get("MaxResults")
        self._TotalCounts = params.get("TotalCounts")
        self._IsTruncated = params.get("IsTruncated")
        self._RequestId = params.get("RequestId")


class ListJoinedGroupsForUserRequest(AbstractModel):
    r"""ListJoinedGroupsForUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID
        :type UserId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        """
        self._ZoneId = None
        self._UserId = None
        self._NextToken = None
        self._MaxResults = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        r"""User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListJoinedGroupsForUserResponse(AbstractModel):
    r"""ListJoinedGroupsForUser response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _JoinedGroups: List of user groups joined by the user.
        :type JoinedGroups: list of JoinedGroups
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._JoinedGroups = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def JoinedGroups(self):
        r"""List of user groups joined by the user.
        :rtype: list of JoinedGroups
        """
        return self._JoinedGroups

    @JoinedGroups.setter
    def JoinedGroups(self, JoinedGroups):
        self._JoinedGroups = JoinedGroups

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("JoinedGroups") is not None:
            self._JoinedGroups = []
            for item in params.get("JoinedGroups"):
                obj = JoinedGroups()
                obj._deserialize(item)
                self._JoinedGroups.append(obj)
        self._RequestId = params.get("RequestId")


class ListOrgServiceAssignMemberRequest(AbstractModel):
    r"""ListOrgServiceAssignMember request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _ServiceId: Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :type ServiceId: int
        """
        self._Offset = None
        self._Limit = None
        self._ServiceId = None

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1-50. Default value: 10.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ServiceId(self):
        r"""Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :rtype: int
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ServiceId = params.get("ServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListOrgServiceAssignMemberResponse(AbstractModel):
    r"""ListOrgServiceAssignMember response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: List of the delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrganizationServiceAssignMember
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""List of the delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrganizationServiceAssignMember
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrganizationServiceAssignMember()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class ListOrganizationIdentityRequest(AbstractModel):
    r"""ListOrganizationIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset.  It must be an integer multiple of the value of `Limit`.  Default value: `0`.
        :type Offset: int
        :param _Limit: The limit for the number of query results.  Value range:  1-50.  Default value:  `10`.
        :type Limit: int
        :param _SearchKey: Search by name.
        :type SearchKey: str
        :param _IdentityId: Identity ID, which can be searched by identity ID.
        :type IdentityId: int
        :param _IdentityType: Identity type.  Valid values: `1` (Preset), `2` (Custom).
        :type IdentityType: int
        """
        self._Offset = None
        self._Limit = None
        self._SearchKey = None
        self._IdentityId = None
        self._IdentityType = None

    @property
    def Offset(self):
        r"""Offset.  It must be an integer multiple of the value of `Limit`.  Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The limit for the number of query results.  Value range:  1-50.  Default value:  `10`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        r"""Search by name.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey

    @property
    def IdentityId(self):
        r"""Identity ID, which can be searched by identity ID.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityType(self):
        r"""Identity type.  Valid values: `1` (Preset), `2` (Custom).
        :rtype: int
        """
        return self._IdentityType

    @IdentityType.setter
    def IdentityType(self, IdentityType):
        self._IdentityType = IdentityType


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        self._IdentityId = params.get("IdentityId")
        self._IdentityType = params.get("IdentityType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListOrganizationIdentityResponse(AbstractModel):
    r"""ListOrganizationIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: Item details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgIdentity
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""Item details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgIdentity
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgIdentity()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class ListOrganizationServiceRequest(AbstractModel):
    r"""ListOrganizationService request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _SearchKey: Keyword for search by name.
        :type SearchKey: str
        """
        self._Offset = None
        self._Limit = None
        self._SearchKey = None

    @property
    def Offset(self):
        r"""Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit. Value range: 1-50. Default value: 10.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        r"""Keyword for search by name.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListOrganizationServiceResponse(AbstractModel):
    r"""ListOrganizationService response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: Organization service list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrganizationServiceAssign
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        r"""Organization service list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrganizationServiceAssign
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrganizationServiceAssign()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class ListPermissionPoliciesInRoleConfigurationRequest(AbstractModel):
    r"""ListPermissionPoliciesInRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RolePolicyType: Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.
        :type RolePolicyType: str
        :param _Filter: Search by policy name.
        :type Filter: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._RolePolicyType = None
        self._Filter = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RolePolicyType(self):
        r"""Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.
        :rtype: str
        """
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def Filter(self):
        r"""Search by policy name.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RolePolicyType = params.get("RolePolicyType")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListPermissionPoliciesInRoleConfigurationResponse(AbstractModel):
    r"""ListPermissionPoliciesInRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of permission policies.
        :type TotalCounts: int
        :param _RolePolicies: Permission policy list.
        :type RolePolicies: list of RolePolicie
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._RolePolicies = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        r"""Total number of permission policies.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def RolePolicies(self):
        r"""Permission policy list.
        :rtype: list of RolePolicie
        """
        return self._RolePolicies

    @RolePolicies.setter
    def RolePolicies(self, RolePolicies):
        self._RolePolicies = RolePolicies

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        if params.get("RolePolicies") is not None:
            self._RolePolicies = []
            for item in params.get("RolePolicies"):
                obj = RolePolicie()
                obj._deserialize(item)
                self._RolePolicies.append(obj)
        self._RequestId = params.get("RequestId")


class ListRoleAssignmentsRequest(AbstractModel):
    r"""ListRoleAssignments request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _PrincipalType: Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :type PrincipalType: str
        :param _PrincipalId: User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-****). When PrincipalType is User, it is a user ID (u-****).
        :type PrincipalId: str
        :param _Filter: Query condition, which currently only supports search by permission configuration name.
        :type Filter: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._MaxResults = None
        self._NextToken = None
        self._TargetType = None
        self._TargetUin = None
        self._PrincipalType = None
        self._PrincipalId = None
        self._Filter = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        r"""UIN of the synchronized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def PrincipalType(self):
        r"""Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalId(self):
        r"""User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-****). When PrincipalType is User, it is a user ID (u-****).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def Filter(self):
        r"""Query condition, which currently only supports search by permission configuration name.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalId = params.get("PrincipalId")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListRoleAssignmentsResponse(AbstractModel):
    r"""ListRoleAssignments response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RoleAssignments: Authorization list of the target account of the Tencent Cloud Organization.
        :type RoleAssignments: list of RoleAssignments
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._RoleAssignments = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RoleAssignments(self):
        r"""Authorization list of the target account of the Tencent Cloud Organization.
        :rtype: list of RoleAssignments
        """
        return self._RoleAssignments

    @RoleAssignments.setter
    def RoleAssignments(self, RoleAssignments):
        self._RoleAssignments = RoleAssignments

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("RoleAssignments") is not None:
            self._RoleAssignments = []
            for item in params.get("RoleAssignments"):
                obj = RoleAssignments()
                obj._deserialize(item)
                self._RoleAssignments.append(obj)
        self._RequestId = params.get("RequestId")


class ListRoleConfigurationProvisioningsRequest(AbstractModel):
    r"""ListRoleConfigurationProvisionings request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _DeploymentStatus: Deployed: Deployment succeeded; DeployedRequired: Redeployment required; DeployFailed: Deployment failed.
        :type DeploymentStatus: str
        :param _Filter: Search by configuration name is supported.
        :type Filter: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._MaxResults = None
        self._NextToken = None
        self._TargetType = None
        self._TargetUin = None
        self._DeploymentStatus = None
        self._Filter = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        r"""UIN of the synchronized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def DeploymentStatus(self):
        r"""Deployed: Deployment succeeded; DeployedRequired: Redeployment required; DeployFailed: Deployment failed.
        :rtype: str
        """
        return self._DeploymentStatus

    @DeploymentStatus.setter
    def DeploymentStatus(self, DeploymentStatus):
        self._DeploymentStatus = DeploymentStatus

    @property
    def Filter(self):
        r"""Search by configuration name is supported.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        self._DeploymentStatus = params.get("DeploymentStatus")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListRoleConfigurationProvisioningsResponse(AbstractModel):
    r"""ListRoleConfigurationProvisionings response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RoleConfigurationProvisionings: Department member account list.
        :type RoleConfigurationProvisionings: list of RoleConfigurationProvisionings
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._RoleConfigurationProvisionings = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RoleConfigurationProvisionings(self):
        r"""Department member account list.
        :rtype: list of RoleConfigurationProvisionings
        """
        return self._RoleConfigurationProvisionings

    @RoleConfigurationProvisionings.setter
    def RoleConfigurationProvisionings(self, RoleConfigurationProvisionings):
        self._RoleConfigurationProvisionings = RoleConfigurationProvisionings

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("RoleConfigurationProvisionings") is not None:
            self._RoleConfigurationProvisionings = []
            for item in params.get("RoleConfigurationProvisionings"):
                obj = RoleConfigurationProvisionings()
                obj._deserialize(item)
                self._RoleConfigurationProvisionings.append(obj)
        self._RequestId = params.get("RequestId")


class ListRoleConfigurationsRequest(AbstractModel):
    r"""ListRoleConfigurations request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _Filter: Filter criteria, which are case insensitive. Currently, only RoleConfigurationName is supported and only eq (Equals) and sw (Start With) are supported. Example: Filter = "RoleConfigurationName, only sw test" means querying all permission configurations starting with test. Filter = "RoleConfigurationName, only eq TestRoleConfiguration" means querying the permission configuration named TestRoleConfiguration.
        :type Filter: str
        :param _FilterTargets: Check whether the member account has been configured with permissions. If configured, return IsSelected: true; otherwise, return false.
        :type FilterTargets: list of int
        :param _PrincipalId: UserId of the authorized user or GroupId of the authorized user group, which must be set together with the input parameter FilterTargets.
        :type PrincipalId: str
        """
        self._ZoneId = None
        self._NextToken = None
        self._MaxResults = None
        self._Filter = None
        self._FilterTargets = None
        self._PrincipalId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def Filter(self):
        r"""Filter criteria, which are case insensitive. Currently, only RoleConfigurationName is supported and only eq (Equals) and sw (Start With) are supported. Example: Filter = "RoleConfigurationName, only sw test" means querying all permission configurations starting with test. Filter = "RoleConfigurationName, only eq TestRoleConfiguration" means querying the permission configuration named TestRoleConfiguration.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def FilterTargets(self):
        r"""Check whether the member account has been configured with permissions. If configured, return IsSelected: true; otherwise, return false.
        :rtype: list of int
        """
        return self._FilterTargets

    @FilterTargets.setter
    def FilterTargets(self, FilterTargets):
        self._FilterTargets = FilterTargets

    @property
    def PrincipalId(self):
        r"""UserId of the authorized user or GroupId of the authorized user group, which must be set together with the input parameter FilterTargets.
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._Filter = params.get("Filter")
        self._FilterTargets = params.get("FilterTargets")
        self._PrincipalId = params.get("PrincipalId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListRoleConfigurationsResponse(AbstractModel):
    r"""ListRoleConfigurations response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _RoleConfigurations: Permission configuration list.
        :type RoleConfigurations: list of RoleConfiguration
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._NextToken = None
        self._RoleConfigurations = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def RoleConfigurations(self):
        r"""Permission configuration list.
        :rtype: list of RoleConfiguration
        """
        return self._RoleConfigurations

    @RoleConfigurations.setter
    def RoleConfigurations(self, RoleConfigurations):
        self._RoleConfigurations = RoleConfigurations

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        self._NextToken = params.get("NextToken")
        if params.get("RoleConfigurations") is not None:
            self._RoleConfigurations = []
            for item in params.get("RoleConfigurations"):
                obj = RoleConfiguration()
                obj._deserialize(item)
                self._RoleConfigurations.append(obj)
        self._RequestId = params.get("RequestId")


class ListSCIMCredentialsRequest(AbstractModel):
    r"""ListSCIMCredentials request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _CredentialId: SCIM key ID.
        :type CredentialId: str
        """
        self._ZoneId = None
        self._CredentialId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CredentialId(self):
        r"""SCIM key ID.
        :rtype: str
        """
        return self._CredentialId

    @CredentialId.setter
    def CredentialId(self, CredentialId):
        self._CredentialId = CredentialId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CredentialId = params.get("CredentialId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListSCIMCredentialsResponse(AbstractModel):
    r"""ListSCIMCredentials response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Number of SCIM keys.
        :type TotalCounts: int
        :param _SCIMCredentials: SCIM key information.
        :type SCIMCredentials: list of SCIMCredential
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._SCIMCredentials = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        r"""Number of SCIM keys.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def SCIMCredentials(self):
        r"""SCIM key information.
        :rtype: list of SCIMCredential
        """
        return self._SCIMCredentials

    @SCIMCredentials.setter
    def SCIMCredentials(self, SCIMCredentials):
        self._SCIMCredentials = SCIMCredentials

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        if params.get("SCIMCredentials") is not None:
            self._SCIMCredentials = []
            for item in params.get("SCIMCredentials"):
                obj = SCIMCredential()
                obj._deserialize(item)
                self._SCIMCredentials.append(obj)
        self._RequestId = params.get("RequestId")


class ListTasksRequest(AbstractModel):
    r"""ListTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _PrincipalId: User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-****). When PrincipalType is User, it is a user ID (u-****).
        :type PrincipalId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _PrincipalType: Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _Status: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :type Status: str
        :param _TaskType: Task type.
        :type TaskType: str
        """
        self._ZoneId = None
        self._PrincipalId = None
        self._NextToken = None
        self._MaxResults = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetType = None
        self._RoleConfigurationId = None
        self._Status = None
        self._TaskType = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PrincipalId(self):
        r"""User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-****). When PrincipalType is User, it is a user ID (u-****).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def PrincipalType(self):
        r"""Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        r"""UIN of the synchronized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def Status(self):
        r"""InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskType(self):
        r"""Task type.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PrincipalId = params.get("PrincipalId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._Status = params.get("Status")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListTasksResponse(AbstractModel):
    r"""ListTasks response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _Tasks: Task details.
        :type Tasks: list of TaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._Tasks = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def Tasks(self):
        r"""Task details.
        :rtype: list of TaskInfo
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = TaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class ListUserSyncProvisioningsRequest(AbstractModel):
    r"""ListUserSyncProvisionings request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _PrincipalId: User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-********). When PrincipalType is User, it is a user ID (u-********).
        :type PrincipalId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _PrincipalType: Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _Filter: Detection condition.
        :type Filter: str
        """
        self._ZoneId = None
        self._PrincipalId = None
        self._NextToken = None
        self._MaxResults = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetType = None
        self._Filter = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PrincipalId(self):
        r"""User synchronization ID. Valid values: When PrincipalType is Group, it is a user group ID (g-********). When PrincipalType is User, it is a user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def PrincipalType(self):
        r"""Identity types synchronized for CAM users. Valid values: User: indicates the synchronized identity is a user. Group: indicates the synchronized identity is a user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        r"""UIN of the target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def Filter(self):
        r"""Detection condition.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PrincipalId = params.get("PrincipalId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListUserSyncProvisioningsResponse(AbstractModel):
    r"""ListUserSyncProvisionings response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _UserProvisionings: User list of the CAM synchronization.
        :type UserProvisionings: list of UserProvisioning
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._UserProvisionings = None
        self._RequestId = None

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def UserProvisionings(self):
        r"""User list of the CAM synchronization.
        :rtype: list of UserProvisioning
        """
        return self._UserProvisionings

    @UserProvisionings.setter
    def UserProvisionings(self, UserProvisionings):
        self._UserProvisionings = UserProvisionings

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("UserProvisionings") is not None:
            self._UserProvisionings = []
            for item in params.get("UserProvisionings"):
                obj = UserProvisioning()
                obj._deserialize(item)
                self._UserProvisionings.append(obj)
        self._RequestId = params.get("RequestId")


class ListUsersRequest(AbstractModel):
    r"""ListUsers request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserStatus: User status: Enabled, Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created; Synchronized: externally imported.
        :type UserType: str
        :param _Filter: Filter criterion, which currently only supports username, email address, userId, and description.
        :type Filter: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _FilterGroups: Filtered user group. IsSelected=1 will be returned for the sub-user associated with this user group.
        :type FilterGroups: list of str
        :param _SortField: Sorting field, which currently only supports CreateTime. The default is the CreateTime field.
        :type SortField: str
        :param _SortType: Sorting type. Desc: descending order; Asc: ascending order. It should be set along with SortField.
        :type SortType: str
        :param _Offset: Pagination offset. Do not use it together with NextToken, prioritizing using NextToken.
        :type Offset: int
        """
        self._ZoneId = None
        self._UserStatus = None
        self._UserType = None
        self._Filter = None
        self._MaxResults = None
        self._NextToken = None
        self._FilterGroups = None
        self._SortField = None
        self._SortType = None
        self._Offset = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserStatus(self):
        r"""User status: Enabled, Disabled.
        :rtype: str
        """
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        r"""User type. Manual: manually created; Synchronized: externally imported.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def Filter(self):
        r"""Filter criterion, which currently only supports username, email address, userId, and description.
        :rtype: str
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def FilterGroups(self):
        r"""Filtered user group. IsSelected=1 will be returned for the sub-user associated with this user group.
        :rtype: list of str
        """
        return self._FilterGroups

    @FilterGroups.setter
    def FilterGroups(self, FilterGroups):
        self._FilterGroups = FilterGroups

    @property
    def SortField(self):
        r"""Sorting field, which currently only supports CreateTime. The default is the CreateTime field.
        :rtype: str
        """
        return self._SortField

    @SortField.setter
    def SortField(self, SortField):
        self._SortField = SortField

    @property
    def SortType(self):
        r"""Sorting type. Desc: descending order; Asc: ascending order. It should be set along with SortField.
        :rtype: str
        """
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def Offset(self):
        r"""Pagination offset. Do not use it together with NextToken, prioritizing using NextToken.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        self._Filter = params.get("Filter")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._FilterGroups = params.get("FilterGroups")
        self._SortField = params.get("SortField")
        self._SortType = params.get("SortType")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListUsersResponse(AbstractModel):
    r"""ListUsers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _Users: User list.
        :type Users: list of UserInfo
        :param _NextToken: Token for querying the next page of returned results. This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._MaxResults = None
        self._Users = None
        self._NextToken = None
        self._IsTruncated = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        r"""Total number of data entries that meet the request parameter conditions.
        :rtype: int
        """
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        r"""Maximum number of data entries per page.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def Users(self):
        r"""User list.
        :rtype: list of UserInfo
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def NextToken(self):
        r"""Token for querying the next page of returned results. This parameter is displayed only when IsTruncated is true.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def IsTruncated(self):
        r"""Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :rtype: bool
        """
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        if params.get("Users") is not None:
            self._Users = []
            for item in params.get("Users"):
                obj = UserInfo()
                obj._deserialize(item)
                self._Users.append(obj)
        self._NextToken = params.get("NextToken")
        self._IsTruncated = params.get("IsTruncated")
        self._RequestId = params.get("RequestId")


class ManagerShareUnit(AbstractModel):
    r"""Details of my shared unit list

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Name: Shared unit name.
        :type Name: str
        :param _Uin: Shared unit administrator UIN.
        :type Uin: int
        :param _OwnerUin: Shared unit administrator OwnerUin.
        :type OwnerUin: int
        :param _Area: Shared unit region.
        :type Area: str
        :param _Description: Description.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Creation time.

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _ShareResourceNum: The number of resources in a shared unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShareResourceNum: int
        :param _ShareMemberNum: The number of members in a shared unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShareMemberNum: int
        :param _ShareScope: Sharing scope. Valid values: 1: Only sharing within a group organization is allowed; 2: Sharing with any account is allowed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShareScope: int
        """
        self._UnitId = None
        self._Name = None
        self._Uin = None
        self._OwnerUin = None
        self._Area = None
        self._Description = None
        self._CreateTime = None
        self._ShareResourceNum = None
        self._ShareMemberNum = None
        self._ShareScope = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Name(self):
        r"""Shared unit name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Uin(self):
        r"""Shared unit administrator UIN.
        :rtype: int
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def OwnerUin(self):
        r"""Shared unit administrator OwnerUin.
        :rtype: int
        """
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def Area(self):
        r"""Shared unit region.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Description(self):
        r"""Description.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ShareResourceNum(self):
        r"""The number of resources in a shared unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShareResourceNum

    @ShareResourceNum.setter
    def ShareResourceNum(self, ShareResourceNum):
        self._ShareResourceNum = ShareResourceNum

    @property
    def ShareMemberNum(self):
        r"""The number of members in a shared unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShareMemberNum

    @ShareMemberNum.setter
    def ShareMemberNum(self, ShareMemberNum):
        self._ShareMemberNum = ShareMemberNum

    @property
    def ShareScope(self):
        r"""Sharing scope. Valid values: 1: Only sharing within a group organization is allowed; 2: Sharing with any account is allowed.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShareScope

    @ShareScope.setter
    def ShareScope(self, ShareScope):
        self._ShareScope = ShareScope


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Name = params.get("Name")
        self._Uin = params.get("Uin")
        self._OwnerUin = params.get("OwnerUin")
        self._Area = params.get("Area")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._ShareResourceNum = params.get("ShareResourceNum")
        self._ShareMemberNum = params.get("ShareMemberNum")
        self._ShareScope = params.get("ShareScope")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MemberIdentity(AbstractModel):
    r"""Member management identity

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityAliasName: Identity name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityAliasName: str
        """
        self._IdentityId = None
        self._IdentityAliasName = None

    @property
    def IdentityId(self):
        r"""Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityAliasName(self):
        r"""Identity name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityAliasName

    @IdentityAliasName.setter
    def IdentityAliasName(self, IdentityAliasName):
        self._IdentityAliasName = IdentityAliasName


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._IdentityAliasName = params.get("IdentityAliasName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MemberMainInfo(AbstractModel):
    r"""Main member information.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _MemberName: Member name j.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberName: str
        """
        self._MemberUin = None
        self._MemberName = None

    @property
    def MemberUin(self):
        r"""Member UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def MemberName(self):
        r"""Member name j.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._MemberName = params.get("MemberName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MoveOrganizationNodeMembersRequest(AbstractModel):
    r"""MoveOrganizationNodeMembers request structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Organization node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _MemberUin: Uin list of the members.
        :type MemberUin: list of int
        """
        self._NodeId = None
        self._MemberUin = None

    @property
    def NodeId(self):
        r"""Organization node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def MemberUin(self):
        r"""Uin list of the members.
        :rtype: list of int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._MemberUin = params.get("MemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MoveOrganizationNodeMembersResponse(AbstractModel):
    r"""MoveOrganizationNodeMembers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class NodeMainInfo(AbstractModel):
    r"""Main department information.

    """

    def __init__(self):
        r"""
        :param _NodeId: Department ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeId: int
        :param _NodeName: Department name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeName: str
        """
        self._NodeId = None
        self._NodeName = None

    @property
    def NodeId(self):
        r"""Department ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def NodeName(self):
        r"""Department name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenIdentityCenterRequest(AbstractModel):
    r"""OpenIdentityCenter request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneName: Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :type ZoneName: str
        """
        self._ZoneName = None

    @property
    def ZoneName(self):
        r"""Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :rtype: str
        """
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName


    def _deserialize(self, params):
        self._ZoneName = params.get("ZoneName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenIdentityCenterResponse(AbstractModel):
    r"""OpenIdentityCenter response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._RequestId = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RequestId = params.get("RequestId")


class OrgIdentity(AbstractModel):
    r"""Organization identity

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityAliasName: Identity name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityAliasName: str
        :param _Description: Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _IdentityPolicy: Identity policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityPolicy: list of IdentityPolicy
        :param _IdentityType: Identity type. Valid values: `1` (preset); `2` (custom).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityType: int
        :param _UpdateTime: Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._IdentityId = None
        self._IdentityAliasName = None
        self._Description = None
        self._IdentityPolicy = None
        self._IdentityType = None
        self._UpdateTime = None

    @property
    def IdentityId(self):
        r"""Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityAliasName(self):
        r"""Identity name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityAliasName

    @IdentityAliasName.setter
    def IdentityAliasName(self, IdentityAliasName):
        self._IdentityAliasName = IdentityAliasName

    @property
    def Description(self):
        r"""Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IdentityPolicy(self):
        r"""Identity policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of IdentityPolicy
        """
        return self._IdentityPolicy

    @IdentityPolicy.setter
    def IdentityPolicy(self, IdentityPolicy):
        self._IdentityPolicy = IdentityPolicy

    @property
    def IdentityType(self):
        r"""Identity type. Valid values: `1` (preset); `2` (custom).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityType

    @IdentityType.setter
    def IdentityType(self, IdentityType):
        self._IdentityType = IdentityType

    @property
    def UpdateTime(self):
        r"""Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._IdentityAliasName = params.get("IdentityAliasName")
        self._Description = params.get("Description")
        if params.get("IdentityPolicy") is not None:
            self._IdentityPolicy = []
            for item in params.get("IdentityPolicy"):
                obj = IdentityPolicy()
                obj._deserialize(item)
                self._IdentityPolicy.append(obj)
        self._IdentityType = params.get("IdentityType")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMember(AbstractModel):
    r"""Organization member

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _Name: Member name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _MemberType: Member type. Valid values: `Invite` (invited); `Create` (created).
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberType: str
        :param _OrgPolicyType: Relationship policy type
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyType: str
        :param _OrgPolicyName: Relationship policy name
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyName: str
        :param _OrgPermission: Relationship policy permission
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPermission: list of OrgPermission
        :param _NodeId: Node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeId: int
        :param _NodeName: Node name
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeName: str
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _IsAllowQuit: Whether the member is allowed to leave. Valid values: `Allow`, `Denied`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayUin: str
        :param _PayName: Payer name
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayName: str
        :param _OrgIdentity: Management identity
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgIdentity: list of MemberIdentity
        :param _BindStatus: Security information binding status. Valid values: `Unbound`, `Valid`, `Success`, `Failed`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BindStatus: str
        :param _PermissionStatus: Member permission status. Valid values: `Confirmed`, `UnConfirmed`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PermissionStatus: str
        :param _Tags: Member tag list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        """
        self._MemberUin = None
        self._Name = None
        self._MemberType = None
        self._OrgPolicyType = None
        self._OrgPolicyName = None
        self._OrgPermission = None
        self._NodeId = None
        self._NodeName = None
        self._Remark = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsAllowQuit = None
        self._PayUin = None
        self._PayName = None
        self._OrgIdentity = None
        self._BindStatus = None
        self._PermissionStatus = None
        self._Tags = None

    @property
    def MemberUin(self):
        r"""Member UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def Name(self):
        r"""Member name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def MemberType(self):
        r"""Member type. Valid values: `Invite` (invited); `Create` (created).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MemberType

    @MemberType.setter
    def MemberType(self, MemberType):
        self._MemberType = MemberType

    @property
    def OrgPolicyType(self):
        r"""Relationship policy type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OrgPolicyType

    @OrgPolicyType.setter
    def OrgPolicyType(self, OrgPolicyType):
        self._OrgPolicyType = OrgPolicyType

    @property
    def OrgPolicyName(self):
        r"""Relationship policy name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OrgPolicyName

    @OrgPolicyName.setter
    def OrgPolicyName(self, OrgPolicyName):
        self._OrgPolicyName = OrgPolicyName

    @property
    def OrgPermission(self):
        r"""Relationship policy permission
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of OrgPermission
        """
        return self._OrgPermission

    @OrgPermission.setter
    def OrgPermission(self, OrgPermission):
        self._OrgPermission = OrgPermission

    @property
    def NodeId(self):
        r"""Node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def NodeName(self):
        r"""Node name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Remark(self):
        r"""Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreateTime(self):
        r"""Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsAllowQuit(self):
        r"""Whether the member is allowed to leave. Valid values: `Allow`, `Denied`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        r"""Payer UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def PayName(self):
        r"""Payer name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PayName

    @PayName.setter
    def PayName(self, PayName):
        self._PayName = PayName

    @property
    def OrgIdentity(self):
        r"""Management identity
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MemberIdentity
        """
        return self._OrgIdentity

    @OrgIdentity.setter
    def OrgIdentity(self, OrgIdentity):
        self._OrgIdentity = OrgIdentity

    @property
    def BindStatus(self):
        r"""Security information binding status. Valid values: `Unbound`, `Valid`, `Success`, `Failed`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._BindStatus

    @BindStatus.setter
    def BindStatus(self, BindStatus):
        self._BindStatus = BindStatus

    @property
    def PermissionStatus(self):
        r"""Member permission status. Valid values: `Confirmed`, `UnConfirmed`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PermissionStatus

    @PermissionStatus.setter
    def PermissionStatus(self, PermissionStatus):
        self._PermissionStatus = PermissionStatus

    @property
    def Tags(self):
        r"""Member tag list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._Name = params.get("Name")
        self._MemberType = params.get("MemberType")
        self._OrgPolicyType = params.get("OrgPolicyType")
        self._OrgPolicyName = params.get("OrgPolicyName")
        if params.get("OrgPermission") is not None:
            self._OrgPermission = []
            for item in params.get("OrgPermission"):
                obj = OrgPermission()
                obj._deserialize(item)
                self._OrgPermission.append(obj)
        self._NodeId = params.get("NodeId")
        self._NodeName = params.get("NodeName")
        self._Remark = params.get("Remark")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        self._PayName = params.get("PayName")
        if params.get("OrgIdentity") is not None:
            self._OrgIdentity = []
            for item in params.get("OrgIdentity"):
                obj = MemberIdentity()
                obj._deserialize(item)
                self._OrgIdentity.append(obj)
        self._BindStatus = params.get("BindStatus")
        self._PermissionStatus = params.get("PermissionStatus")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMemberAuthAccount(AbstractModel):
    r"""Authorization relationship between the member and sub-account

    """

    def __init__(self):
        r"""
        :param _OrgSubAccountUin: Organization sub-account UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgSubAccountUin: int
        :param _PolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _PolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyName: str
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityRoleName: Identity role name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleName: str
        :param _IdentityRoleAliasName: Identity role alias.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleAliasName: str
        :param _CreateTime: Creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _OrgSubAccountName: Sub-account name
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgSubAccountName: str
        """
        self._OrgSubAccountUin = None
        self._PolicyId = None
        self._PolicyName = None
        self._IdentityId = None
        self._IdentityRoleName = None
        self._IdentityRoleAliasName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._OrgSubAccountName = None

    @property
    def OrgSubAccountUin(self):
        r"""Organization sub-account UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._OrgSubAccountUin

    @OrgSubAccountUin.setter
    def OrgSubAccountUin(self, OrgSubAccountUin):
        self._OrgSubAccountUin = OrgSubAccountUin

    @property
    def PolicyId(self):
        r"""Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        r"""Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        r"""Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityRoleName(self):
        r"""Identity role name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityRoleName

    @IdentityRoleName.setter
    def IdentityRoleName(self, IdentityRoleName):
        self._IdentityRoleName = IdentityRoleName

    @property
    def IdentityRoleAliasName(self):
        r"""Identity role alias.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityRoleAliasName

    @IdentityRoleAliasName.setter
    def IdentityRoleAliasName(self, IdentityRoleAliasName):
        self._IdentityRoleAliasName = IdentityRoleAliasName

    @property
    def CreateTime(self):
        r"""Creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def OrgSubAccountName(self):
        r"""Sub-account name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OrgSubAccountName

    @OrgSubAccountName.setter
    def OrgSubAccountName(self, OrgSubAccountName):
        self._OrgSubAccountName = OrgSubAccountName


    def _deserialize(self, params):
        self._OrgSubAccountUin = params.get("OrgSubAccountUin")
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._IdentityRoleName = params.get("IdentityRoleName")
        self._IdentityRoleAliasName = params.get("IdentityRoleAliasName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._OrgSubAccountName = params.get("OrgSubAccountName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMemberAuthIdentity(AbstractModel):
    r"""Authorizable identity of the organization member

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityRoleName: Role name of an identity
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleName: str
        :param _IdentityRoleAliasName: Role alias of an identity
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleAliasName: str
        :param _Description: Identity description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Time of initial configuration success.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Time of last configuration success.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _IdentityType: Identity type. Valid values: 1 (preset identity), 2 (custom identity).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityType: int
        :param _Status: Configuration status. Valid values: 1 (configuration completed), 2 (reconfiguration required).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _MemberUin: Member Uin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _MemberName: Member name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberName: str
        """
        self._IdentityId = None
        self._IdentityRoleName = None
        self._IdentityRoleAliasName = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IdentityType = None
        self._Status = None
        self._MemberUin = None
        self._MemberName = None

    @property
    def IdentityId(self):
        r"""Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityRoleName(self):
        r"""Role name of an identity
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityRoleName

    @IdentityRoleName.setter
    def IdentityRoleName(self, IdentityRoleName):
        self._IdentityRoleName = IdentityRoleName

    @property
    def IdentityRoleAliasName(self):
        r"""Role alias of an identity
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityRoleAliasName

    @IdentityRoleAliasName.setter
    def IdentityRoleAliasName(self, IdentityRoleAliasName):
        self._IdentityRoleAliasName = IdentityRoleAliasName

    @property
    def Description(self):
        r"""Identity description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Time of initial configuration success.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Time of last configuration success.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IdentityType(self):
        r"""Identity type. Valid values: 1 (preset identity), 2 (custom identity).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityType

    @IdentityType.setter
    def IdentityType(self, IdentityType):
        self._IdentityType = IdentityType

    @property
    def Status(self):
        r"""Configuration status. Valid values: 1 (configuration completed), 2 (reconfiguration required).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MemberUin(self):
        r"""Member Uin.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def MemberName(self):
        r"""Member name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._IdentityRoleName = params.get("IdentityRoleName")
        self._IdentityRoleAliasName = params.get("IdentityRoleAliasName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IdentityType = params.get("IdentityType")
        self._Status = params.get("Status")
        self._MemberUin = params.get("MemberUin")
        self._MemberName = params.get("MemberName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMemberPolicy(AbstractModel):
    r"""Authorized policy of the organization member

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _PolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyName: str
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityRoleName: Identity role name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleName: str
        :param _IdentityRoleAliasName: Identity role alias.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleAliasName: str
        :param _Description: Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._PolicyId = None
        self._PolicyName = None
        self._IdentityId = None
        self._IdentityRoleName = None
        self._IdentityRoleAliasName = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PolicyId(self):
        r"""Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        r"""Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        r"""Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityRoleName(self):
        r"""Identity role name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityRoleName

    @IdentityRoleName.setter
    def IdentityRoleName(self, IdentityRoleName):
        self._IdentityRoleName = IdentityRoleName

    @property
    def IdentityRoleAliasName(self):
        r"""Identity role alias.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IdentityRoleAliasName

    @IdentityRoleAliasName.setter
    def IdentityRoleAliasName(self, IdentityRoleAliasName):
        self._IdentityRoleAliasName = IdentityRoleAliasName

    @property
    def Description(self):
        r"""Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._IdentityRoleName = params.get("IdentityRoleName")
        self._IdentityRoleAliasName = params.get("IdentityRoleAliasName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgNode(AbstractModel):
    r"""Department

    """

    def __init__(self):
        r"""
        :param _NodeId: Organization node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeId: int
        :param _Name: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _ParentNodeId: Parent node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentNodeId: int
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _Tags: Member tag list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        """
        self._NodeId = None
        self._Name = None
        self._ParentNodeId = None
        self._Remark = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Tags = None

    @property
    def NodeId(self):
        r"""Organization node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def Name(self):
        r"""Name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ParentNodeId(self):
        r"""Parent node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ParentNodeId

    @ParentNodeId.setter
    def ParentNodeId(self, ParentNodeId):
        self._ParentNodeId = ParentNodeId

    @property
    def Remark(self):
        r"""Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreateTime(self):
        r"""Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Tags(self):
        r"""Member tag list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._Name = params.get("Name")
        self._ParentNodeId = params.get("ParentNodeId")
        self._Remark = params.get("Remark")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgPermission(AbstractModel):
    r"""Relationship policy permission

    """

    def __init__(self):
        r"""
        :param _Id: Permission ID
        :type Id: int
        :param _Name: Permission name
        :type Name: str
        """
        self._Id = None
        self._Name = None

    @property
    def Id(self):
        r"""Permission ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        r"""Permission name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrganizationServiceAssign(AbstractModel):
    r"""Organization service settings.

    """

    def __init__(self):
        r"""
        :param _ServiceId: Organization service ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceId: int
        :param _ProductName: Organization service product name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProductName: str
        :param _IsAssign: Whether to support delegation. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAssign: int
        :param _Description: Organization service description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _MemberNum: Number of the current delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberNum: str
        :param _Document: Help documentation.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Document: str
        :param _ConsoleUrl: Console path of the organization service product.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsoleUrl: str
        :param _IsUsageStatus: Whether to access the usage status. Valid values: 1 (yes), 
 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsUsageStatus: int
        :param _CanAssignCount: Limit for the number of delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CanAssignCount: int
        :param _Product: Organization service product identifier.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Product: str
        :param _ServiceGrant: Whether to support organization service authorization. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceGrant: int
        :param _GrantStatus: Enabling status of organization service authorization. This field is valid when ServiceGrant is 1. Valid values: Enabled, Disabled. 
Note: This field may return null, indicating that no valid values can be obtained.
        :type GrantStatus: str
        :param _IsSetManagementScope: Whether to support setting the delegated management scope. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsSetManagementScope: int
        """
        self._ServiceId = None
        self._ProductName = None
        self._IsAssign = None
        self._Description = None
        self._MemberNum = None
        self._Document = None
        self._ConsoleUrl = None
        self._IsUsageStatus = None
        self._CanAssignCount = None
        self._Product = None
        self._ServiceGrant = None
        self._GrantStatus = None
        self._IsSetManagementScope = None

    @property
    def ServiceId(self):
        r"""Organization service ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def ProductName(self):
        r"""Organization service product name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def IsAssign(self):
        r"""Whether to support delegation. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IsAssign

    @IsAssign.setter
    def IsAssign(self, IsAssign):
        self._IsAssign = IsAssign

    @property
    def Description(self):
        r"""Organization service description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MemberNum(self):
        r"""Number of the current delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MemberNum

    @MemberNum.setter
    def MemberNum(self, MemberNum):
        self._MemberNum = MemberNum

    @property
    def Document(self):
        r"""Help documentation.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Document

    @Document.setter
    def Document(self, Document):
        self._Document = Document

    @property
    def ConsoleUrl(self):
        r"""Console path of the organization service product.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConsoleUrl

    @ConsoleUrl.setter
    def ConsoleUrl(self, ConsoleUrl):
        self._ConsoleUrl = ConsoleUrl

    @property
    def IsUsageStatus(self):
        r"""Whether to access the usage status. Valid values: 1 (yes), 
 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IsUsageStatus

    @IsUsageStatus.setter
    def IsUsageStatus(self, IsUsageStatus):
        self._IsUsageStatus = IsUsageStatus

    @property
    def CanAssignCount(self):
        r"""Limit for the number of delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CanAssignCount

    @CanAssignCount.setter
    def CanAssignCount(self, CanAssignCount):
        self._CanAssignCount = CanAssignCount

    @property
    def Product(self):
        r"""Organization service product identifier.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def ServiceGrant(self):
        r"""Whether to support organization service authorization. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ServiceGrant

    @ServiceGrant.setter
    def ServiceGrant(self, ServiceGrant):
        self._ServiceGrant = ServiceGrant

    @property
    def GrantStatus(self):
        r"""Enabling status of organization service authorization. This field is valid when ServiceGrant is 1. Valid values: Enabled, Disabled. 
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._GrantStatus

    @GrantStatus.setter
    def GrantStatus(self, GrantStatus):
        self._GrantStatus = GrantStatus

    @property
    def IsSetManagementScope(self):
        r"""Whether to support setting the delegated management scope. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IsSetManagementScope

    @IsSetManagementScope.setter
    def IsSetManagementScope(self, IsSetManagementScope):
        self._IsSetManagementScope = IsSetManagementScope


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._ProductName = params.get("ProductName")
        self._IsAssign = params.get("IsAssign")
        self._Description = params.get("Description")
        self._MemberNum = params.get("MemberNum")
        self._Document = params.get("Document")
        self._ConsoleUrl = params.get("ConsoleUrl")
        self._IsUsageStatus = params.get("IsUsageStatus")
        self._CanAssignCount = params.get("CanAssignCount")
        self._Product = params.get("Product")
        self._ServiceGrant = params.get("ServiceGrant")
        self._GrantStatus = params.get("GrantStatus")
        self._IsSetManagementScope = params.get("IsSetManagementScope")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrganizationServiceAssignMember(AbstractModel):
    r"""Information on the delegated member of the organization service.

    """

    def __init__(self):
        r"""
        :param _ServiceId: Organization service ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceId: int
        :param _ProductName: Organization service product name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProductName: str
        :param _MemberUin: Uin of the delegated admin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _MemberName: Name of the delegated admin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberName: str
        :param _UsageStatus: Activation status. Valid values: 0 (the service has no activation status), 1 (activated), 2 (not activated).
Note: This field may return null, indicating that no valid values can be obtained.
        :type UsageStatus: int
        :param _CreateTime: Delegation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _ManagementScope: Management scope of the delegated admin. Valid values: 1 (all members), 2 (partial members).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ManagementScope: int
        :param _ManagementScopeMembers: Uin list of managed members. This parameter is valid when ManagementScope is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ManagementScopeMembers: list of MemberMainInfo
        :param _ManagementScopeNodes: ID list of the managed departments. This parameter is valid when ManagementScope is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ManagementScopeNodes: list of NodeMainInfo
        """
        self._ServiceId = None
        self._ProductName = None
        self._MemberUin = None
        self._MemberName = None
        self._UsageStatus = None
        self._CreateTime = None
        self._ManagementScope = None
        self._ManagementScopeMembers = None
        self._ManagementScopeNodes = None

    @property
    def ServiceId(self):
        r"""Organization service ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def ProductName(self):
        r"""Organization service product name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def MemberUin(self):
        r"""Uin of the delegated admin.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def MemberName(self):
        r"""Name of the delegated admin.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName

    @property
    def UsageStatus(self):
        r"""Activation status. Valid values: 0 (the service has no activation status), 1 (activated), 2 (not activated).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UsageStatus

    @UsageStatus.setter
    def UsageStatus(self, UsageStatus):
        self._UsageStatus = UsageStatus

    @property
    def CreateTime(self):
        r"""Delegation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ManagementScope(self):
        r"""Management scope of the delegated admin. Valid values: 1 (all members), 2 (partial members).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ManagementScope

    @ManagementScope.setter
    def ManagementScope(self, ManagementScope):
        self._ManagementScope = ManagementScope

    @property
    def ManagementScopeMembers(self):
        r"""Uin list of managed members. This parameter is valid when ManagementScope is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MemberMainInfo
        """
        return self._ManagementScopeMembers

    @ManagementScopeMembers.setter
    def ManagementScopeMembers(self, ManagementScopeMembers):
        self._ManagementScopeMembers = ManagementScopeMembers

    @property
    def ManagementScopeNodes(self):
        r"""ID list of the managed departments. This parameter is valid when ManagementScope is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeMainInfo
        """
        return self._ManagementScopeNodes

    @ManagementScopeNodes.setter
    def ManagementScopeNodes(self, ManagementScopeNodes):
        self._ManagementScopeNodes = ManagementScopeNodes


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._ProductName = params.get("ProductName")
        self._MemberUin = params.get("MemberUin")
        self._MemberName = params.get("MemberName")
        self._UsageStatus = params.get("UsageStatus")
        self._CreateTime = params.get("CreateTime")
        self._ManagementScope = params.get("ManagementScope")
        if params.get("ManagementScopeMembers") is not None:
            self._ManagementScopeMembers = []
            for item in params.get("ManagementScopeMembers"):
                obj = MemberMainInfo()
                obj._deserialize(item)
                self._ManagementScopeMembers.append(obj)
        if params.get("ManagementScopeNodes") is not None:
            self._ManagementScopeNodes = []
            for item in params.get("ManagementScopeNodes"):
                obj = NodeMainInfo()
                obj._deserialize(item)
                self._ManagementScopeNodes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PolicyDetail(AbstractModel):
    r"""Policy details.

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.
        :type PolicyId: int
        :param _PolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyName: str
        """
        self._PolicyId = None
        self._PolicyName = None

    @property
    def PolicyId(self):
        r"""Policy ID.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        r"""Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProductResource(AbstractModel):
    r"""Product resources

    """

    def __init__(self):
        r"""
        :param _ProductResourceId: Product resource ID.
        :type ProductResourceId: str
        :param _ResourceGrantLast: The last section of the six-segment resource description.
        :type ResourceGrantLast: str
        """
        self._ProductResourceId = None
        self._ResourceGrantLast = None

    @property
    def ProductResourceId(self):
        r"""Product resource ID.
        :rtype: str
        """
        return self._ProductResourceId

    @ProductResourceId.setter
    def ProductResourceId(self, ProductResourceId):
        self._ProductResourceId = ProductResourceId

    @property
    def ResourceGrantLast(self):
        warnings.warn("parameter `ResourceGrantLast` is deprecated", DeprecationWarning) 

        r"""The last section of the six-segment resource description.
        :rtype: str
        """
        return self._ResourceGrantLast

    @ResourceGrantLast.setter
    def ResourceGrantLast(self, ResourceGrantLast):
        warnings.warn("parameter `ResourceGrantLast` is deprecated", DeprecationWarning) 

        self._ResourceGrantLast = ResourceGrantLast


    def _deserialize(self, params):
        self._ProductResourceId = params.get("ProductResourceId")
        self._ResourceGrantLast = params.get("ResourceGrantLast")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProvisionRoleConfigurationRequest(AbstractModel):
    r"""ProvisionRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._TargetType = None
        self._TargetUin = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        r"""UIN of the target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProvisionRoleConfigurationResponse(AbstractModel):
    r"""ProvisionRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task details.
        :type Task: :class:`tencentcloud.organization.v20210331.models.RoleProvisioningsTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Task = None
        self._RequestId = None

    @property
    def Task(self):
        r"""Task details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.RoleProvisioningsTask`
        """
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = RoleProvisioningsTask()
            self._Task._deserialize(params.get("Task"))
        self._RequestId = params.get("RequestId")


class QuitOrganizationRequest(AbstractModel):
    r"""QuitOrganization request structure.

    """

    def __init__(self):
        r"""
        :param _OrgId: Organization ID.
        :type OrgId: int
        """
        self._OrgId = None

    @property
    def OrgId(self):
        r"""Organization ID.
        :rtype: int
        """
        return self._OrgId

    @OrgId.setter
    def OrgId(self, OrgId):
        self._OrgId = OrgId


    def _deserialize(self, params):
        self._OrgId = params.get("OrgId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QuitOrganizationResponse(AbstractModel):
    r"""QuitOrganization response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RejectJoinShareUnitInvitationRequest(AbstractModel):
    r"""RejectJoinShareUnitInvitation request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        """
        self._UnitId = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RejectJoinShareUnitInvitationResponse(AbstractModel):
    r"""RejectJoinShareUnitInvitation response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RemoveExternalSAMLIdPCertificateRequest(AbstractModel):
    r"""RemoveExternalSAMLIdPCertificate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _CertificateId: X509 certificate in PEM format, provided by the SAML identity provider.
        :type CertificateId: str
        """
        self._ZoneId = None
        self._CertificateId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CertificateId(self):
        r"""X509 certificate in PEM format, provided by the SAML identity provider.
        :rtype: str
        """
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CertificateId = params.get("CertificateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveExternalSAMLIdPCertificateResponse(AbstractModel):
    r"""RemoveExternalSAMLIdPCertificate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RemovePermissionPolicyFromRoleConfigurationRequest(AbstractModel):
    r"""RemovePermissionPolicyFromRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RolePolicyType: Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.
        :type RolePolicyType: str
        :param _RolePolicyName: Permission policy name, which contains up to 32 characters.
        :type RolePolicyName: str
        :param _RolePolicyId: Policy ID.
        :type RolePolicyId: int
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._RolePolicyType = None
        self._RolePolicyName = None
        self._RolePolicyId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RolePolicyType(self):
        r"""Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.
        :rtype: str
        """
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def RolePolicyName(self):
        r"""Permission policy name, which contains up to 32 characters.
        :rtype: str
        """
        return self._RolePolicyName

    @RolePolicyName.setter
    def RolePolicyName(self, RolePolicyName):
        self._RolePolicyName = RolePolicyName

    @property
    def RolePolicyId(self):
        r"""Policy ID.
        :rtype: int
        """
        return self._RolePolicyId

    @RolePolicyId.setter
    def RolePolicyId(self, RolePolicyId):
        self._RolePolicyId = RolePolicyId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RolePolicyType = params.get("RolePolicyType")
        self._RolePolicyName = params.get("RolePolicyName")
        self._RolePolicyId = params.get("RolePolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemovePermissionPolicyFromRoleConfigurationResponse(AbstractModel):
    r"""RemovePermissionPolicyFromRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RemoveUserFromGroupRequest(AbstractModel):
    r"""RemoveUserFromGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _UserId: User ID.
        :type UserId: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._UserId = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveUserFromGroupResponse(AbstractModel):
    r"""RemoveUserFromGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RoleAssignmentInfo(AbstractModel):
    r"""Authorized member account information.

    """

    def __init__(self):
        r"""
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        """
        self._PrincipalId = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetType = None
        self._RoleConfigurationId = None

    @property
    def PrincipalId(self):
        r"""Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        r"""Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        r"""UIN of the synchronized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId


    def _deserialize(self, params):
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleAssignments(AbstractModel):
    r"""Authorization details of the member account.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _PrincipalName: User name or user group name.
        :type PrincipalName: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        :param _TargetName: Name of the target account of the Tencent Cloud Organization.
        :type TargetName: str
        """
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetType = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._PrincipalName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TargetName = None

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        r"""Permission configuration name.
        :rtype: str
        """
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        r"""UIN of the target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def PrincipalId(self):
        r"""Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        r"""Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalName(self):
        r"""User name or user group name.
        :rtype: str
        """
        return self._PrincipalName

    @PrincipalName.setter
    def PrincipalName(self, PrincipalName):
        self._PrincipalName = PrincipalName

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TargetName(self):
        r"""Name of the target account of the Tencent Cloud Organization.
        :rtype: str
        """
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName


    def _deserialize(self, params):
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalName = params.get("PrincipalName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TargetName = params.get("TargetName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleConfiguration(AbstractModel):
    r"""CIC permission configuration.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _Description: Permission configuration description.
        :type Description: str
        :param _SessionDuration: Session duration. It indicates the maximum session duration when CIC users use the access configuration to access member accounts.
Unit: seconds.
        :type SessionDuration: int
        :param _RelayState: Initial access page. It indicates the initial access page URL when CIC users use the access configuration to access member accounts.
        :type RelayState: str
        :param _CreateTime: Creation time of the permission configuration.
        :type CreateTime: str
        :param _UpdateTime: Update time of the permission configuration.
        :type UpdateTime: str
        :param _IsSelected: If the input parameter FilterTargets is provided, check whether the member account has been configured with permissions. If configured, return true; otherwise, return false.
        :type IsSelected: bool
        """
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._Description = None
        self._SessionDuration = None
        self._RelayState = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsSelected = None

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        r"""Permission configuration name.
        :rtype: str
        """
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def Description(self):
        r"""Permission configuration description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SessionDuration(self):
        r"""Session duration. It indicates the maximum session duration when CIC users use the access configuration to access member accounts.
Unit: seconds.
        :rtype: int
        """
        return self._SessionDuration

    @SessionDuration.setter
    def SessionDuration(self, SessionDuration):
        self._SessionDuration = SessionDuration

    @property
    def RelayState(self):
        r"""Initial access page. It indicates the initial access page URL when CIC users use the access configuration to access member accounts.
        :rtype: str
        """
        return self._RelayState

    @RelayState.setter
    def RelayState(self, RelayState):
        self._RelayState = RelayState

    @property
    def CreateTime(self):
        r"""Creation time of the permission configuration.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time of the permission configuration.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsSelected(self):
        r"""If the input parameter FilterTargets is provided, check whether the member account has been configured with permissions. If configured, return true; otherwise, return false.
        :rtype: bool
        """
        return self._IsSelected

    @IsSelected.setter
    def IsSelected(self, IsSelected):
        self._IsSelected = IsSelected


    def _deserialize(self, params):
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._Description = params.get("Description")
        self._SessionDuration = params.get("SessionDuration")
        self._RelayState = params.get("RelayState")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsSelected = params.get("IsSelected")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleConfigurationProvisionings(AbstractModel):
    r"""Permission configuration synchronization.

    """

    def __init__(self):
        r"""
        :param _DeploymentStatus: Deployed: Deployment succeeded; DeployedRequired: Redeployment required; DeployFailed: Deployment failed.
        :type DeploymentStatus: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetName: Name of the target account of the Tencent Cloud Organization.
        :type TargetName: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Modification time.
        :type UpdateTime: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        """
        self._DeploymentStatus = None
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TargetType = None

    @property
    def DeploymentStatus(self):
        r"""Deployed: Deployment succeeded; DeployedRequired: Redeployment required; DeployFailed: Deployment failed.
        :rtype: str
        """
        return self._DeploymentStatus

    @DeploymentStatus.setter
    def DeploymentStatus(self, DeploymentStatus):
        self._DeploymentStatus = DeploymentStatus

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        r"""Permission configuration name.
        :rtype: str
        """
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        r"""UIN of the target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetName(self):
        r"""Name of the target account of the Tencent Cloud Organization.
        :rtype: str
        """
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Modification time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType


    def _deserialize(self, params):
        self._DeploymentStatus = params.get("DeploymentStatus")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetName = params.get("TargetName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TargetType = params.get("TargetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RolePolicie(AbstractModel):
    r"""CIC permission policy.

    """

    def __init__(self):
        r"""
        :param _RolePolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RolePolicyId: int
        :param _RolePolicyName: Permission policy name.
        :type RolePolicyName: str
        :param _RolePolicyType: Permission policy type.
        :type RolePolicyType: str
        :param _RolePolicyDocument: Custom policy content. This parameter is only returned for custom policies.
        :type RolePolicyDocument: str
        :param _AddTime: The time when the permission policy is added to the permission configuration.
        :type AddTime: str
        """
        self._RolePolicyId = None
        self._RolePolicyName = None
        self._RolePolicyType = None
        self._RolePolicyDocument = None
        self._AddTime = None

    @property
    def RolePolicyId(self):
        r"""Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RolePolicyId

    @RolePolicyId.setter
    def RolePolicyId(self, RolePolicyId):
        self._RolePolicyId = RolePolicyId

    @property
    def RolePolicyName(self):
        r"""Permission policy name.
        :rtype: str
        """
        return self._RolePolicyName

    @RolePolicyName.setter
    def RolePolicyName(self, RolePolicyName):
        self._RolePolicyName = RolePolicyName

    @property
    def RolePolicyType(self):
        r"""Permission policy type.
        :rtype: str
        """
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def RolePolicyDocument(self):
        r"""Custom policy content. This parameter is only returned for custom policies.
        :rtype: str
        """
        return self._RolePolicyDocument

    @RolePolicyDocument.setter
    def RolePolicyDocument(self, RolePolicyDocument):
        self._RolePolicyDocument = RolePolicyDocument

    @property
    def AddTime(self):
        r"""The time when the permission policy is added to the permission configuration.
        :rtype: str
        """
        return self._AddTime

    @AddTime.setter
    def AddTime(self, AddTime):
        self._AddTime = AddTime


    def _deserialize(self, params):
        self._RolePolicyId = params.get("RolePolicyId")
        self._RolePolicyName = params.get("RolePolicyName")
        self._RolePolicyType = params.get("RolePolicyType")
        self._RolePolicyDocument = params.get("RolePolicyDocument")
        self._AddTime = params.get("AddTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleProvisioningsTask(AbstractModel):
    r"""Status information of the role synchronization task.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the authorized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetType: str
        :param _TaskType: Task type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskType: str
        :param _TaskStatus: Task status. InProgress: The task is in progress; Failed: The task failed; Success: The task succeeded.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskStatus: str
        """
        self._TaskId = None
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetType = None
        self._TaskType = None
        self._TaskStatus = None

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        r"""Permission configuration name.
        :rtype: str
        """
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        r"""UIN of the authorized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TaskType(self):
        r"""Task type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskStatus(self):
        r"""Task status. InProgress: The task is in progress; Failed: The task failed; Success: The task succeeded.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._TaskType = params.get("TaskType")
        self._TaskStatus = params.get("TaskStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SAMLIdPCertificate(AbstractModel):
    r"""SAML signing certificate information.

    """

    def __init__(self):
        r"""
        :param _SerialNumber: Certificate serial number.
        :type SerialNumber: str
        :param _Issuer: Certificate issuer.
        :type Issuer: str
        :param _Version: Certificate version.
        :type Version: int
        :param _CertificateId: Certificate ID.
        :type CertificateId: str
        :param _PublicKey: Public key certificate in PEM format (Base64 encoded).
        :type PublicKey: str
        :param _SignatureAlgorithm: Signature algorithm of the certificate.
        :type SignatureAlgorithm: str
        :param _NotAfter: Expiration time of the certificate.
        :type NotAfter: str
        :param _NotBefore: Creation time of the certificate.
        :type NotBefore: str
        :param _Subject: Certificate subject.
        :type Subject: str
        :param _X509Certificate: X509 certificate in PEM format.
        :type X509Certificate: str
        """
        self._SerialNumber = None
        self._Issuer = None
        self._Version = None
        self._CertificateId = None
        self._PublicKey = None
        self._SignatureAlgorithm = None
        self._NotAfter = None
        self._NotBefore = None
        self._Subject = None
        self._X509Certificate = None

    @property
    def SerialNumber(self):
        r"""Certificate serial number.
        :rtype: str
        """
        return self._SerialNumber

    @SerialNumber.setter
    def SerialNumber(self, SerialNumber):
        self._SerialNumber = SerialNumber

    @property
    def Issuer(self):
        r"""Certificate issuer.
        :rtype: str
        """
        return self._Issuer

    @Issuer.setter
    def Issuer(self, Issuer):
        self._Issuer = Issuer

    @property
    def Version(self):
        r"""Certificate version.
        :rtype: int
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def CertificateId(self):
        r"""Certificate ID.
        :rtype: str
        """
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId

    @property
    def PublicKey(self):
        r"""Public key certificate in PEM format (Base64 encoded).
        :rtype: str
        """
        return self._PublicKey

    @PublicKey.setter
    def PublicKey(self, PublicKey):
        self._PublicKey = PublicKey

    @property
    def SignatureAlgorithm(self):
        r"""Signature algorithm of the certificate.
        :rtype: str
        """
        return self._SignatureAlgorithm

    @SignatureAlgorithm.setter
    def SignatureAlgorithm(self, SignatureAlgorithm):
        self._SignatureAlgorithm = SignatureAlgorithm

    @property
    def NotAfter(self):
        r"""Expiration time of the certificate.
        :rtype: str
        """
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def NotBefore(self):
        r"""Creation time of the certificate.
        :rtype: str
        """
        return self._NotBefore

    @NotBefore.setter
    def NotBefore(self, NotBefore):
        self._NotBefore = NotBefore

    @property
    def Subject(self):
        r"""Certificate subject.
        :rtype: str
        """
        return self._Subject

    @Subject.setter
    def Subject(self, Subject):
        self._Subject = Subject

    @property
    def X509Certificate(self):
        r"""X509 certificate in PEM format.
        :rtype: str
        """
        return self._X509Certificate

    @X509Certificate.setter
    def X509Certificate(self, X509Certificate):
        self._X509Certificate = X509Certificate


    def _deserialize(self, params):
        self._SerialNumber = params.get("SerialNumber")
        self._Issuer = params.get("Issuer")
        self._Version = params.get("Version")
        self._CertificateId = params.get("CertificateId")
        self._PublicKey = params.get("PublicKey")
        self._SignatureAlgorithm = params.get("SignatureAlgorithm")
        self._NotAfter = params.get("NotAfter")
        self._NotBefore = params.get("NotBefore")
        self._Subject = params.get("Subject")
        self._X509Certificate = params.get("X509Certificate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SAMLIdentityProviderConfiguration(AbstractModel):
    r"""SAML identity provider configuration information.

    """

    def __init__(self):
        r"""
        :param _EntityId: IdP identifier.
        :type EntityId: str
        :param _SSOStatus: SSO enabling status. Valid values: Enabled, Disabled (default).
        :type SSOStatus: str
        :param _EncodedMetadataDocument: IdP metadata document (Base64 encoded).
        :type EncodedMetadataDocument: str
        :param _CertificateIds: X509 certificate ID.
        :type CertificateIds: list of str
        :param _LoginUrl: IdP login URL.
        :type LoginUrl: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        """
        self._EntityId = None
        self._SSOStatus = None
        self._EncodedMetadataDocument = None
        self._CertificateIds = None
        self._LoginUrl = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def EntityId(self):
        r"""IdP identifier.
        :rtype: str
        """
        return self._EntityId

    @EntityId.setter
    def EntityId(self, EntityId):
        self._EntityId = EntityId

    @property
    def SSOStatus(self):
        r"""SSO enabling status. Valid values: Enabled, Disabled (default).
        :rtype: str
        """
        return self._SSOStatus

    @SSOStatus.setter
    def SSOStatus(self, SSOStatus):
        self._SSOStatus = SSOStatus

    @property
    def EncodedMetadataDocument(self):
        r"""IdP metadata document (Base64 encoded).
        :rtype: str
        """
        return self._EncodedMetadataDocument

    @EncodedMetadataDocument.setter
    def EncodedMetadataDocument(self, EncodedMetadataDocument):
        self._EncodedMetadataDocument = EncodedMetadataDocument

    @property
    def CertificateIds(self):
        r"""X509 certificate ID.
        :rtype: list of str
        """
        return self._CertificateIds

    @CertificateIds.setter
    def CertificateIds(self, CertificateIds):
        self._CertificateIds = CertificateIds

    @property
    def LoginUrl(self):
        r"""IdP login URL.
        :rtype: str
        """
        return self._LoginUrl

    @LoginUrl.setter
    def LoginUrl(self, LoginUrl):
        self._LoginUrl = LoginUrl

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._EntityId = params.get("EntityId")
        self._SSOStatus = params.get("SSOStatus")
        self._EncodedMetadataDocument = params.get("EncodedMetadataDocument")
        self._CertificateIds = params.get("CertificateIds")
        self._LoginUrl = params.get("LoginUrl")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SAMLServiceProvider(AbstractModel):
    r"""SAML service provider information.

    """

    def __init__(self):
        r"""
        :param _EntityId: https://tencentcloudsso.com/saml/sp/z-sjw8ensa**
        :type EntityId: str
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _EncodedMetadataDocument: SP metadata document (Base64 encoded).
        :type EncodedMetadataDocument: str
        :param _AcsUrl: SP ACS URL.
        :type AcsUrl: str
        """
        self._EntityId = None
        self._ZoneId = None
        self._EncodedMetadataDocument = None
        self._AcsUrl = None

    @property
    def EntityId(self):
        r"""https://tencentcloudsso.com/saml/sp/z-sjw8ensa**
        :rtype: str
        """
        return self._EntityId

    @EntityId.setter
    def EntityId(self, EntityId):
        self._EntityId = EntityId

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def EncodedMetadataDocument(self):
        r"""SP metadata document (Base64 encoded).
        :rtype: str
        """
        return self._EncodedMetadataDocument

    @EncodedMetadataDocument.setter
    def EncodedMetadataDocument(self, EncodedMetadataDocument):
        self._EncodedMetadataDocument = EncodedMetadataDocument

    @property
    def AcsUrl(self):
        r"""SP ACS URL.
        :rtype: str
        """
        return self._AcsUrl

    @AcsUrl.setter
    def AcsUrl(self, AcsUrl):
        self._AcsUrl = AcsUrl


    def _deserialize(self, params):
        self._EntityId = params.get("EntityId")
        self._ZoneId = params.get("ZoneId")
        self._EncodedMetadataDocument = params.get("EncodedMetadataDocument")
        self._AcsUrl = params.get("AcsUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SCIMCredential(AbstractModel):
    r"""SCIM key.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _Status: SCIM key status. Enabled: enabled. Disabled: disabled.
        :type Status: str
        :param _CredentialId: SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :type CredentialId: str
        :param _CredentialType: SCIM key type.
        :type CredentialType: str
        :param _CreateTime: Creation time of a SCIM key.
        :type CreateTime: str
        :param _ExpireTime: Expiration time of a SCIM key.
        :type ExpireTime: str
        """
        self._ZoneId = None
        self._Status = None
        self._CredentialId = None
        self._CredentialType = None
        self._CreateTime = None
        self._ExpireTime = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Status(self):
        r"""SCIM key status. Enabled: enabled. Disabled: disabled.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CredentialId(self):
        r"""SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._CredentialId

    @CredentialId.setter
    def CredentialId(self, CredentialId):
        self._CredentialId = CredentialId

    @property
    def CredentialType(self):
        r"""SCIM key type.
        :rtype: str
        """
        return self._CredentialType

    @CredentialType.setter
    def CredentialType(self, CredentialType):
        self._CredentialType = CredentialType

    @property
    def CreateTime(self):
        r"""Creation time of a SCIM key.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        r"""Expiration time of a SCIM key.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._Status = params.get("Status")
        self._CredentialId = params.get("CredentialId")
        self._CredentialType = params.get("CredentialType")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SendOrgMemberAccountBindEmailRequest(AbstractModel):
    r"""SendOrgMemberAccountBindEmail request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member uin.
        :type MemberUin: int
        :param _BindId: Bound ID, which can be obtained through describeorganizationmemberemailbind (https://intl.cloud.tencent.com/document/product/850/93332?from_cn_redirect=1).
        :type BindId: int
        """
        self._MemberUin = None
        self._BindId = None

    @property
    def MemberUin(self):
        r"""Member uin.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def BindId(self):
        r"""Bound ID, which can be obtained through describeorganizationmemberemailbind (https://intl.cloud.tencent.com/document/product/850/93332?from_cn_redirect=1).
        :rtype: int
        """
        return self._BindId

    @BindId.setter
    def BindId(self, BindId):
        self._BindId = BindId


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._BindId = params.get("BindId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SendOrgMemberAccountBindEmailResponse(AbstractModel):
    r"""SendOrgMemberAccountBindEmail response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SetExternalSAMLIdentityProviderRequest(AbstractModel):
    r"""SetExternalSAMLIdentityProvider request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _EncodedMetadataDocument: IdP metadata document (Base64 encoded). Provided by an IdP that supports the SAML 2.0 protocol.
        :type EncodedMetadataDocument: str
        :param _SSOStatus: SSO enabling status. Valid values: Enabled, Disabled (default).
        :type SSOStatus: str
        :param _EntityId: IdP identifier.
        :type EntityId: str
        :param _LoginUrl: IdP login URL.
        :type LoginUrl: str
        :param _X509Certificate: X509 certificate in PEM format. If this parameter is specified, all existing certificates will be replaced.
        :type X509Certificate: str
        """
        self._ZoneId = None
        self._EncodedMetadataDocument = None
        self._SSOStatus = None
        self._EntityId = None
        self._LoginUrl = None
        self._X509Certificate = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def EncodedMetadataDocument(self):
        r"""IdP metadata document (Base64 encoded). Provided by an IdP that supports the SAML 2.0 protocol.
        :rtype: str
        """
        return self._EncodedMetadataDocument

    @EncodedMetadataDocument.setter
    def EncodedMetadataDocument(self, EncodedMetadataDocument):
        self._EncodedMetadataDocument = EncodedMetadataDocument

    @property
    def SSOStatus(self):
        r"""SSO enabling status. Valid values: Enabled, Disabled (default).
        :rtype: str
        """
        return self._SSOStatus

    @SSOStatus.setter
    def SSOStatus(self, SSOStatus):
        self._SSOStatus = SSOStatus

    @property
    def EntityId(self):
        r"""IdP identifier.
        :rtype: str
        """
        return self._EntityId

    @EntityId.setter
    def EntityId(self, EntityId):
        self._EntityId = EntityId

    @property
    def LoginUrl(self):
        r"""IdP login URL.
        :rtype: str
        """
        return self._LoginUrl

    @LoginUrl.setter
    def LoginUrl(self, LoginUrl):
        self._LoginUrl = LoginUrl

    @property
    def X509Certificate(self):
        r"""X509 certificate in PEM format. If this parameter is specified, all existing certificates will be replaced.
        :rtype: str
        """
        return self._X509Certificate

    @X509Certificate.setter
    def X509Certificate(self, X509Certificate):
        self._X509Certificate = X509Certificate


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._EncodedMetadataDocument = params.get("EncodedMetadataDocument")
        self._SSOStatus = params.get("SSOStatus")
        self._EntityId = params.get("EntityId")
        self._LoginUrl = params.get("LoginUrl")
        self._X509Certificate = params.get("X509Certificate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetExternalSAMLIdentityProviderResponse(AbstractModel):
    r"""SetExternalSAMLIdentityProvider response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ShareArea(AbstractModel):
    r"""Shared region

    """

    def __init__(self):
        r"""
        :param _Name: Region name.
        :type Name: str
        :param _Area: Region identifier.
        :type Area: str
        :param _AreaId: Region ID.
        :type AreaId: int
        """
        self._Name = None
        self._Area = None
        self._AreaId = None

    @property
    def Name(self):
        r"""Region name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Area(self):
        r"""Region identifier.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def AreaId(self):
        r"""Region ID.
        :rtype: int
        """
        return self._AreaId

    @AreaId.setter
    def AreaId(self, AreaId):
        self._AreaId = AreaId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Area = params.get("Area")
        self._AreaId = params.get("AreaId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ShareMember(AbstractModel):
    r"""Shared member information

    """

    def __init__(self):
        r"""
        :param _ShareMemberUin: Shared member UIN.
        :type ShareMemberUin: int
        """
        self._ShareMemberUin = None

    @property
    def ShareMemberUin(self):
        r"""Shared member UIN.
        :rtype: int
        """
        return self._ShareMemberUin

    @ShareMemberUin.setter
    def ShareMemberUin(self, ShareMemberUin):
        self._ShareMemberUin = ShareMemberUin


    def _deserialize(self, params):
        self._ShareMemberUin = params.get("ShareMemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ShareResource(AbstractModel):
    r"""Shared resources

    """

    def __init__(self):
        r"""
        :param _ResourceId: Shared resource ID.
        :type ResourceId: str
        :param _ProductResourceId: Product resource ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProductResourceId: str
        """
        self._ResourceId = None
        self._ProductResourceId = None

    @property
    def ResourceId(self):
        warnings.warn("parameter `ResourceId` is deprecated", DeprecationWarning) 

        r"""Shared resource ID.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        warnings.warn("parameter `ResourceId` is deprecated", DeprecationWarning) 

        self._ResourceId = ResourceId

    @property
    def ProductResourceId(self):
        r"""Product resource ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProductResourceId

    @ProductResourceId.setter
    def ProductResourceId(self, ProductResourceId):
        self._ProductResourceId = ProductResourceId


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._ProductResourceId = params.get("ProductResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ShareUnitMember(AbstractModel):
    r"""Shared unit members

    """

    def __init__(self):
        r"""
        :param _ShareMemberUin: Shared member UIN.
        :type ShareMemberUin: int
        :param _CreateTime: Creation time.

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._ShareMemberUin = None
        self._CreateTime = None

    @property
    def ShareMemberUin(self):
        r"""Shared member UIN.
        :rtype: int
        """
        return self._ShareMemberUin

    @ShareMemberUin.setter
    def ShareMemberUin(self, ShareMemberUin):
        self._ShareMemberUin = ShareMemberUin

    @property
    def CreateTime(self):
        r"""Creation time.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._ShareMemberUin = params.get("ShareMemberUin")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ShareUnitResource(AbstractModel):
    r"""Shared unit resources

    """

    def __init__(self):
        r"""
        :param _ResourceId: Shared resource ID.
        :type ResourceId: str
        :param _Type: Shared resource type.
        :type Type: str
        :param _CreateTime: Creation time.

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _ProductResourceId: Product resource ID.
        :type ProductResourceId: str
        :param _SharedMemberNum: The number of members in a shared unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SharedMemberNum: int
        :param _SharedMemberUseNum: The number of shared unit members in use.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SharedMemberUseNum: int
        :param _ShareManagerUin: Shared administrator OwnerUin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShareManagerUin: int
        """
        self._ResourceId = None
        self._Type = None
        self._CreateTime = None
        self._ProductResourceId = None
        self._SharedMemberNum = None
        self._SharedMemberUseNum = None
        self._ShareManagerUin = None

    @property
    def ResourceId(self):
        r"""Shared resource ID.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Type(self):
        r"""Shared resource type.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CreateTime(self):
        r"""Creation time.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ProductResourceId(self):
        r"""Product resource ID.
        :rtype: str
        """
        return self._ProductResourceId

    @ProductResourceId.setter
    def ProductResourceId(self, ProductResourceId):
        self._ProductResourceId = ProductResourceId

    @property
    def SharedMemberNum(self):
        r"""The number of members in a shared unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SharedMemberNum

    @SharedMemberNum.setter
    def SharedMemberNum(self, SharedMemberNum):
        self._SharedMemberNum = SharedMemberNum

    @property
    def SharedMemberUseNum(self):
        r"""The number of shared unit members in use.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SharedMemberUseNum

    @SharedMemberUseNum.setter
    def SharedMemberUseNum(self, SharedMemberUseNum):
        self._SharedMemberUseNum = SharedMemberUseNum

    @property
    def ShareManagerUin(self):
        r"""Shared administrator OwnerUin.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShareManagerUin

    @ShareManagerUin.setter
    def ShareManagerUin(self, ShareManagerUin):
        self._ShareManagerUin = ShareManagerUin


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._Type = params.get("Type")
        self._CreateTime = params.get("CreateTime")
        self._ProductResourceId = params.get("ProductResourceId")
        self._SharedMemberNum = params.get("SharedMemberNum")
        self._SharedMemberUseNum = params.get("SharedMemberUseNum")
        self._ShareManagerUin = params.get("ShareManagerUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Tag(AbstractModel):
    r"""Tag key-value pair.

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag key

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagKey: str
        :param _TagValue: Tag value

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        r"""Tag key

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        r"""Tag value

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskInfo(AbstractModel):
    r"""Task status information.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the authorized target member account.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _PrincipalId: Identity ID for the user authorization. If the identity type is CIC user, it is the user ID; if the identity type is user group, it is the user group ID.
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the user authorization. User: CIC user; Group: CIC user group.
        :type PrincipalType: str
        :param _TaskType: Task type.
        :type TaskType: str
        :param _Status: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :type Status: str
        :param _FailureReason: Cause of the failure.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailureReason: str
        """
        self._TaskId = None
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetType = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._TaskType = None
        self._Status = None
        self._FailureReason = None

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        r"""Permission configuration name.
        :rtype: str
        """
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        r"""UIN of the authorized target member account.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def PrincipalId(self):
        r"""Identity ID for the user authorization. If the identity type is CIC user, it is the user ID; if the identity type is user group, it is the user group ID.
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        r"""Identity type for the user authorization. User: CIC user; Group: CIC user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TaskType(self):
        r"""Task type.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        r"""InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FailureReason(self):
        r"""Cause of the failure.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._FailureReason = params.get("FailureReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskStatus(AbstractModel):
    r"""Task status information.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :type Status: str
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _TaskType: Task type. Valid values:ProvisionRoleConfiguration: Deploy permission configurations.
DeprovisionRoleConfiguration: Undeploy permission configurations.CreateRoleAssignment: Grant authorizations on member accounts.
DeleteRoleAssignment: Remove authorizations on member accounts.
        :type TaskType: str
        :param _FailureReason: Cause of task failure.
Description.
This parameter is displayed only when the Status is Failed.
        :type FailureReason: str
        """
        self._Status = None
        self._TaskId = None
        self._TaskType = None
        self._FailureReason = None

    @property
    def Status(self):
        r"""Task status. Valid values: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        r"""Task type. Valid values:ProvisionRoleConfiguration: Deploy permission configurations.
DeprovisionRoleConfiguration: Undeploy permission configurations.CreateRoleAssignment: Grant authorizations on member accounts.
DeleteRoleAssignment: Remove authorizations on member accounts.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def FailureReason(self):
        r"""Cause of task failure.
Description.
This parameter is displayed only when the Status is Failed.
        :rtype: str
        """
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        self._FailureReason = params.get("FailureReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateCustomPolicyForRoleConfigurationRequest(AbstractModel):
    r"""UpdateCustomPolicyForRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _CustomPolicyName: Permission policy name, which contains up to 32 characters.
        :type CustomPolicyName: str
        :param _NewCustomPolicyDocument: Custom policy content, which contains up to 4096 characters. When RolePolicyType is Inline, this parameter must be configured. For details, see the permission policy syntax and structure.
        :type NewCustomPolicyDocument: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._CustomPolicyName = None
        self._NewCustomPolicyDocument = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def CustomPolicyName(self):
        r"""Permission policy name, which contains up to 32 characters.
        :rtype: str
        """
        return self._CustomPolicyName

    @CustomPolicyName.setter
    def CustomPolicyName(self, CustomPolicyName):
        self._CustomPolicyName = CustomPolicyName

    @property
    def NewCustomPolicyDocument(self):
        r"""Custom policy content, which contains up to 4096 characters. When RolePolicyType is Inline, this parameter must be configured. For details, see the permission policy syntax and structure.
        :rtype: str
        """
        return self._NewCustomPolicyDocument

    @NewCustomPolicyDocument.setter
    def NewCustomPolicyDocument(self, NewCustomPolicyDocument):
        self._NewCustomPolicyDocument = NewCustomPolicyDocument


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._CustomPolicyName = params.get("CustomPolicyName")
        self._NewCustomPolicyDocument = params.get("NewCustomPolicyDocument")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateCustomPolicyForRoleConfigurationResponse(AbstractModel):
    r"""UpdateCustomPolicyForRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateGroupRequest(AbstractModel):
    r"""UpdateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _NewGroupName: New user group name.
        :type NewGroupName: str
        :param _NewDescription: New user group description.
        :type NewDescription: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._NewGroupName = None
        self._NewDescription = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        r"""User group ID.
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def NewGroupName(self):
        r"""New user group name.
        :rtype: str
        """
        return self._NewGroupName

    @NewGroupName.setter
    def NewGroupName(self, NewGroupName):
        self._NewGroupName = NewGroupName

    @property
    def NewDescription(self):
        r"""New user group description.
        :rtype: str
        """
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._NewGroupName = params.get("NewGroupName")
        self._NewDescription = params.get("NewDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateGroupResponse(AbstractModel):
    r"""UpdateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupInfo: User group information.
        :type GroupInfo: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupInfo = None
        self._RequestId = None

    @property
    def GroupInfo(self):
        r"""User group information.
        :rtype: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        """
        return self._GroupInfo

    @GroupInfo.setter
    def GroupInfo(self, GroupInfo):
        self._GroupInfo = GroupInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupInfo") is not None:
            self._GroupInfo = GroupInfo()
            self._GroupInfo._deserialize(params.get("GroupInfo"))
        self._RequestId = params.get("RequestId")


class UpdateOrganizationIdentityRequest(AbstractModel):
    r"""UpdateOrganizationIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityId: int
        :param _Description: Identity description.
        :type Description: str
        :param _IdentityPolicy: Identity policy.
        :type IdentityPolicy: list of IdentityPolicy
        """
        self._IdentityId = None
        self._Description = None
        self._IdentityPolicy = None

    @property
    def IdentityId(self):
        r"""Identity ID, which can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :rtype: int
        """
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def Description(self):
        r"""Identity description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IdentityPolicy(self):
        r"""Identity policy.
        :rtype: list of IdentityPolicy
        """
        return self._IdentityPolicy

    @IdentityPolicy.setter
    def IdentityPolicy(self, IdentityPolicy):
        self._IdentityPolicy = IdentityPolicy


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._Description = params.get("Description")
        if params.get("IdentityPolicy") is not None:
            self._IdentityPolicy = []
            for item in params.get("IdentityPolicy"):
                obj = IdentityPolicy()
                obj._deserialize(item)
                self._IdentityPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateOrganizationIdentityResponse(AbstractModel):
    r"""UpdateOrganizationIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateOrganizationMemberEmailBindRequest(AbstractModel):
    r"""UpdateOrganizationMemberEmailBind request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member uin.
        :type MemberUin: int
        :param _BindId: Bound ID, which can be obtained through describeorganizationmemberemailbind (https://intl.cloud.tencent.com/document/product/850/93332?from_cn_redirect=1).
        :type BindId: int
        :param _Email: Email address.
        :type Email: str
        :param _CountryCode: International area code.
        :type CountryCode: str
        :param _Phone: Mobile number.
        :type Phone: str
        """
        self._MemberUin = None
        self._BindId = None
        self._Email = None
        self._CountryCode = None
        self._Phone = None

    @property
    def MemberUin(self):
        r"""Member uin.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def BindId(self):
        r"""Bound ID, which can be obtained through describeorganizationmemberemailbind (https://intl.cloud.tencent.com/document/product/850/93332?from_cn_redirect=1).
        :rtype: int
        """
        return self._BindId

    @BindId.setter
    def BindId(self, BindId):
        self._BindId = BindId

    @property
    def Email(self):
        r"""Email address.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def CountryCode(self):
        r"""International area code.
        :rtype: str
        """
        return self._CountryCode

    @CountryCode.setter
    def CountryCode(self, CountryCode):
        self._CountryCode = CountryCode

    @property
    def Phone(self):
        r"""Mobile number.
        :rtype: str
        """
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._BindId = params.get("BindId")
        self._Email = params.get("Email")
        self._CountryCode = params.get("CountryCode")
        self._Phone = params.get("Phone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateOrganizationMemberEmailBindResponse(AbstractModel):
    r"""UpdateOrganizationMemberEmailBind response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateOrganizationMemberRequest(AbstractModel):
    r"""UpdateOrganizationMember request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _Name: Member name, which contains up to 25 characters, including English letters, digits, and symbols `+@&._[]-:,`.
        :type Name: str
        :param _Remark: Remarks, which contain up to 40 characters.
        :type Remark: str
        :param _PolicyType: Relationship policy type. When PolicyType is not empty, PermissionIds cannot be empty. Value: Financial.
        :type PolicyType: str
        :param _PermissionIds: List of member financial permission IDs. When PermissionIds is not empty, PolicyType cannot be empty.
Valid values: 1: View bills. 2: View balance. 3: Allocate funds. 4: Consolidate bills. 5: Issue invoices. 6: Inherit discounts. 7: Pay on behalf. 8: Analyze costs. 1 and 2 are required by default.
        :type PermissionIds: list of int non-negative
        :param _IsAllowQuit: Whether to allow members to exit an organization. Valid values: Allow: permitted, Denied: not permitted.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN, which is required when pay-on-behalf mode is used in member financial permission. The value is the principal administrator UIN of the corresponding member.
        :type PayUin: str
        """
        self._MemberUin = None
        self._Name = None
        self._Remark = None
        self._PolicyType = None
        self._PermissionIds = None
        self._IsAllowQuit = None
        self._PayUin = None

    @property
    def MemberUin(self):
        r"""Member UIN.
        :rtype: int
        """
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def Name(self):
        r"""Member name, which contains up to 25 characters, including English letters, digits, and symbols `+@&._[]-:,`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Remarks, which contain up to 40 characters.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PolicyType(self):
        r"""Relationship policy type. When PolicyType is not empty, PermissionIds cannot be empty. Value: Financial.
        :rtype: str
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PermissionIds(self):
        r"""List of member financial permission IDs. When PermissionIds is not empty, PolicyType cannot be empty.
Valid values: 1: View bills. 2: View balance. 3: Allocate funds. 4: Consolidate bills. 5: Issue invoices. 6: Inherit discounts. 7: Pay on behalf. 8: Analyze costs. 1 and 2 are required by default.
        :rtype: list of int non-negative
        """
        return self._PermissionIds

    @PermissionIds.setter
    def PermissionIds(self, PermissionIds):
        self._PermissionIds = PermissionIds

    @property
    def IsAllowQuit(self):
        r"""Whether to allow members to exit an organization. Valid values: Allow: permitted, Denied: not permitted.
        :rtype: str
        """
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        r"""Payer UIN, which is required when pay-on-behalf mode is used in member financial permission. The value is the principal administrator UIN of the corresponding member.
        :rtype: str
        """
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        self._PolicyType = params.get("PolicyType")
        self._PermissionIds = params.get("PermissionIds")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateOrganizationMemberResponse(AbstractModel):
    r"""UpdateOrganizationMember response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateOrganizationNodeRequest(AbstractModel):
    r"""UpdateOrganizationNode request structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _Name: Node name, which can contain up to 40 letters, digits, and symbols `+@&._[]-`.
        :type Name: str
        :param _Remark: Remarks.
        :type Remark: str
        """
        self._NodeId = None
        self._Name = None
        self._Remark = None

    @property
    def NodeId(self):
        r"""Node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :rtype: int
        """
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def Name(self):
        r"""Node name, which can contain up to 40 letters, digits, and symbols `+@&._[]-`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateOrganizationNodeResponse(AbstractModel):
    r"""UpdateOrganizationNode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateRoleConfigurationRequest(AbstractModel):
    r"""UpdateRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _NewDescription: New permission configuration description, which contains up to 1,024 characters.
        :type NewDescription: str
        :param _NewSessionDuration: New session duration, in seconds. It is the maximum time a CIC user can maintain a session while using permission configurations to access a target account in TCO. Value range: 900 to 43200 (15 minutes to 12 hours).
        :type NewSessionDuration: int
        :param _NewRelayState: New initial access page. It is the initial page address when a CIC user uses permission configurations to access a target account in TCO. This page must be a Tencent Cloud console page.
        :type NewRelayState: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._NewDescription = None
        self._NewSessionDuration = None
        self._NewRelayState = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        r"""Permission configuration ID.
        :rtype: str
        """
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def NewDescription(self):
        r"""New permission configuration description, which contains up to 1,024 characters.
        :rtype: str
        """
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription

    @property
    def NewSessionDuration(self):
        r"""New session duration, in seconds. It is the maximum time a CIC user can maintain a session while using permission configurations to access a target account in TCO. Value range: 900 to 43200 (15 minutes to 12 hours).
        :rtype: int
        """
        return self._NewSessionDuration

    @NewSessionDuration.setter
    def NewSessionDuration(self, NewSessionDuration):
        self._NewSessionDuration = NewSessionDuration

    @property
    def NewRelayState(self):
        r"""New initial access page. It is the initial page address when a CIC user uses permission configurations to access a target account in TCO. This page must be a Tencent Cloud console page.
        :rtype: str
        """
        return self._NewRelayState

    @NewRelayState.setter
    def NewRelayState(self, NewRelayState):
        self._NewRelayState = NewRelayState


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._NewDescription = params.get("NewDescription")
        self._NewSessionDuration = params.get("NewSessionDuration")
        self._NewRelayState = params.get("NewRelayState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateRoleConfigurationResponse(AbstractModel):
    r"""UpdateRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationInfo: Permission configuration details.
        :type RoleConfigurationInfo: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleConfigurationInfo = None
        self._RequestId = None

    @property
    def RoleConfigurationInfo(self):
        r"""Permission configuration details.
        :rtype: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        """
        return self._RoleConfigurationInfo

    @RoleConfigurationInfo.setter
    def RoleConfigurationInfo(self, RoleConfigurationInfo):
        self._RoleConfigurationInfo = RoleConfigurationInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoleConfigurationInfo") is not None:
            self._RoleConfigurationInfo = RoleConfiguration()
            self._RoleConfigurationInfo._deserialize(params.get("RoleConfigurationInfo"))
        self._RequestId = params.get("RequestId")


class UpdateSCIMCredentialStatusRequest(AbstractModel):
    r"""UpdateSCIMCredentialStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _CredentialId: SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :type CredentialId: str
        :param _NewStatus: SCIM key status. Enabled: enabled. Disabled: disabled.
        :type NewStatus: str
        """
        self._ZoneId = None
        self._CredentialId = None
        self._NewStatus = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CredentialId(self):
        r"""SCIM key ID, which starts with the scimcred- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._CredentialId

    @CredentialId.setter
    def CredentialId(self, CredentialId):
        self._CredentialId = CredentialId

    @property
    def NewStatus(self):
        r"""SCIM key status. Enabled: enabled. Disabled: disabled.
        :rtype: str
        """
        return self._NewStatus

    @NewStatus.setter
    def NewStatus(self, NewStatus):
        self._NewStatus = NewStatus


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CredentialId = params.get("CredentialId")
        self._NewStatus = params.get("NewStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateSCIMCredentialStatusResponse(AbstractModel):
    r"""UpdateSCIMCredentialStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateSCIMSynchronizationStatusRequest(AbstractModel):
    r"""UpdateSCIMSynchronizationStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _SCIMSynchronizationStatus: SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :type SCIMSynchronizationStatus: str
        """
        self._ZoneId = None
        self._SCIMSynchronizationStatus = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def SCIMSynchronizationStatus(self):
        r"""SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :rtype: str
        """
        return self._SCIMSynchronizationStatus

    @SCIMSynchronizationStatus.setter
    def SCIMSynchronizationStatus(self, SCIMSynchronizationStatus):
        self._SCIMSynchronizationStatus = SCIMSynchronizationStatus


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._SCIMSynchronizationStatus = params.get("SCIMSynchronizationStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateSCIMSynchronizationStatusResponse(AbstractModel):
    r"""UpdateSCIMSynchronizationStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateShareUnitRequest(AbstractModel):
    r"""UpdateShareUnit request structure.

    """

    def __init__(self):
        r"""
        :param _UnitId: Shared unit ID.
        :type UnitId: str
        :param _Name: Shared unit name. It only supports combinations of uppercase and lowercase letters, digits, hyphens (-), and underscores (_), with 3 to 128 characters.
        :type Name: str
        :param _Description: Shared unit description. Maximum: 128 characters.
        :type Description: str
        :param _ShareScope: Sharing scope. Valid values: 1: Only sharing within a group organization is allowed; 2: Sharing with any account is allowed. Default value: 1
        :type ShareScope: int
        """
        self._UnitId = None
        self._Name = None
        self._Description = None
        self._ShareScope = None

    @property
    def UnitId(self):
        r"""Shared unit ID.
        :rtype: str
        """
        return self._UnitId

    @UnitId.setter
    def UnitId(self, UnitId):
        self._UnitId = UnitId

    @property
    def Name(self):
        r"""Shared unit name. It only supports combinations of uppercase and lowercase letters, digits, hyphens (-), and underscores (_), with 3 to 128 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""Shared unit description. Maximum: 128 characters.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ShareScope(self):
        r"""Sharing scope. Valid values: 1: Only sharing within a group organization is allowed; 2: Sharing with any account is allowed. Default value: 1
        :rtype: int
        """
        return self._ShareScope

    @ShareScope.setter
    def ShareScope(self, ShareScope):
        self._ShareScope = ShareScope


    def _deserialize(self, params):
        self._UnitId = params.get("UnitId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._ShareScope = params.get("ShareScope")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateShareUnitResponse(AbstractModel):
    r"""UpdateShareUnit response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateUserRequest(AbstractModel):
    r"""UpdateUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID.
        :type UserId: str
        :param _NewFirstName: First name of the user.
        :type NewFirstName: str
        :param _NewLastName: Last name of the user.
        :type NewLastName: str
        :param _NewDisplayName: Display name of the user.
        :type NewDisplayName: str
        :param _NewDescription: User description.
        :type NewDescription: str
        :param _NewEmail: Email address of the user.
        :type NewEmail: str
        """
        self._ZoneId = None
        self._UserId = None
        self._NewFirstName = None
        self._NewLastName = None
        self._NewDisplayName = None
        self._NewDescription = None
        self._NewEmail = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def NewFirstName(self):
        r"""First name of the user.
        :rtype: str
        """
        return self._NewFirstName

    @NewFirstName.setter
    def NewFirstName(self, NewFirstName):
        self._NewFirstName = NewFirstName

    @property
    def NewLastName(self):
        r"""Last name of the user.
        :rtype: str
        """
        return self._NewLastName

    @NewLastName.setter
    def NewLastName(self, NewLastName):
        self._NewLastName = NewLastName

    @property
    def NewDisplayName(self):
        r"""Display name of the user.
        :rtype: str
        """
        return self._NewDisplayName

    @NewDisplayName.setter
    def NewDisplayName(self, NewDisplayName):
        self._NewDisplayName = NewDisplayName

    @property
    def NewDescription(self):
        r"""User description.
        :rtype: str
        """
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription

    @property
    def NewEmail(self):
        r"""Email address of the user.
        :rtype: str
        """
        return self._NewEmail

    @NewEmail.setter
    def NewEmail(self, NewEmail):
        self._NewEmail = NewEmail


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        self._NewFirstName = params.get("NewFirstName")
        self._NewLastName = params.get("NewLastName")
        self._NewDisplayName = params.get("NewDisplayName")
        self._NewDescription = params.get("NewDescription")
        self._NewEmail = params.get("NewEmail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserResponse(AbstractModel):
    r"""UpdateUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User information
        :type UserInfo: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""User information
        :rtype: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class UpdateUserStatusRequest(AbstractModel):
    r"""UpdateUserStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID.
        :type UserId: str
        :param _NewUserStatus: User status. Valid values: Enabled, Disabled.
        :type NewUserStatus: str
        """
        self._ZoneId = None
        self._UserId = None
        self._NewUserStatus = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def NewUserStatus(self):
        r"""User status. Valid values: Enabled, Disabled.
        :rtype: str
        """
        return self._NewUserStatus

    @NewUserStatus.setter
    def NewUserStatus(self, NewUserStatus):
        self._NewUserStatus = NewUserStatus


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        self._NewUserStatus = params.get("NewUserStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserStatusResponse(AbstractModel):
    r"""UpdateUserStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateUserSyncProvisioningRequest(AbstractModel):
    r"""UpdateUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserProvisioningId: User synchronization ID.
        :type UserProvisioningId: str
        :param _NewDescription: User synchronization description.
        :type NewDescription: str
        :param _NewDuplicationStateful: Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :type NewDuplicationStateful: str
        :param _NewDeletionStrategy: Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :type NewDeletionStrategy: str
        """
        self._ZoneId = None
        self._UserProvisioningId = None
        self._NewDescription = None
        self._NewDuplicationStateful = None
        self._NewDeletionStrategy = None

    @property
    def ZoneId(self):
        r"""Space ID.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserProvisioningId(self):
        r"""User synchronization ID.
        :rtype: str
        """
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId

    @property
    def NewDescription(self):
        r"""User synchronization description.
        :rtype: str
        """
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription

    @property
    def NewDuplicationStateful(self):
        r"""Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :rtype: str
        """
        return self._NewDuplicationStateful

    @NewDuplicationStateful.setter
    def NewDuplicationStateful(self, NewDuplicationStateful):
        self._NewDuplicationStateful = NewDuplicationStateful

    @property
    def NewDeletionStrategy(self):
        r"""Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :rtype: str
        """
        return self._NewDeletionStrategy

    @NewDeletionStrategy.setter
    def NewDeletionStrategy(self, NewDeletionStrategy):
        self._NewDeletionStrategy = NewDeletionStrategy


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserProvisioningId = params.get("UserProvisioningId")
        self._NewDescription = params.get("NewDescription")
        self._NewDuplicationStateful = params.get("NewDuplicationStateful")
        self._NewDeletionStrategy = params.get("NewDeletionStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserSyncProvisioningResponse(AbstractModel):
    r"""UpdateUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateZoneRequest(AbstractModel):
    r"""UpdateZone request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _NewZoneName: Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :type NewZoneName: str
        """
        self._ZoneId = None
        self._NewZoneName = None

    @property
    def ZoneId(self):
        r"""Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :rtype: str
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NewZoneName(self):
        r"""Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :rtype: str
        """
        return self._NewZoneName

    @NewZoneName.setter
    def NewZoneName(self, NewZoneName):
        self._NewZoneName = NewZoneName


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NewZoneName = params.get("NewZoneName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateZoneResponse(AbstractModel):
    r"""UpdateZone response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UserInfo(AbstractModel):
    r"""User information.

    """

    def __init__(self):
        r"""
        :param _UserName: Queried username.
        :type UserName: str
        :param _FirstName: First name of the user.
        :type FirstName: str
        :param _LastName: Last name of the user.
        :type LastName: str
        :param _DisplayName: Display name of the user.
        :type DisplayName: str
        :param _Description: User description.
        :type Description: str
        :param _Email: Email address of the user, which must be unique within the directory.
        :type Email: str
        :param _UserStatus: User status. Valid values: Enabled, Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created; Synchronized: externally imported.
        :type UserType: str
        :param _UserId: User ID.
        :type UserId: str
        :param _CreateTime: Creation time of the user.
        :type CreateTime: str
        :param _UpdateTime: Modification time of the user.
        :type UpdateTime: str
        :param _IsSelected: Whether selected
        :type IsSelected: bool
        """
        self._UserName = None
        self._FirstName = None
        self._LastName = None
        self._DisplayName = None
        self._Description = None
        self._Email = None
        self._UserStatus = None
        self._UserType = None
        self._UserId = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsSelected = None

    @property
    def UserName(self):
        r"""Queried username.
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def FirstName(self):
        r"""First name of the user.
        :rtype: str
        """
        return self._FirstName

    @FirstName.setter
    def FirstName(self, FirstName):
        self._FirstName = FirstName

    @property
    def LastName(self):
        r"""Last name of the user.
        :rtype: str
        """
        return self._LastName

    @LastName.setter
    def LastName(self, LastName):
        self._LastName = LastName

    @property
    def DisplayName(self):
        r"""Display name of the user.
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        r"""User description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Email(self):
        r"""Email address of the user, which must be unique within the directory.
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def UserStatus(self):
        r"""User status. Valid values: Enabled, Disabled.
        :rtype: str
        """
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        r"""User type. Manual: manually created; Synchronized: externally imported.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserId(self):
        r"""User ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def CreateTime(self):
        r"""Creation time of the user.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Modification time of the user.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsSelected(self):
        r"""Whether selected
        :rtype: bool
        """
        return self._IsSelected

    @IsSelected.setter
    def IsSelected(self, IsSelected):
        self._IsSelected = IsSelected


    def _deserialize(self, params):
        self._UserName = params.get("UserName")
        self._FirstName = params.get("FirstName")
        self._LastName = params.get("LastName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._Email = params.get("Email")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        self._UserId = params.get("UserId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsSelected = params.get("IsSelected")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserProvisioning(AbstractModel):
    r"""User synchronization information.

    """

    def __init__(self):
        r"""
        :param _UserProvisioningId: CAM user synchronization status. Valid values:

Enabled: CAM user synchronization is enabled.
Disabled: CAM user synchronization is disabled.
        :type UserProvisioningId: str
        :param _Description: Description.
        :type Description: str
        :param _Status: CAM user synchronization status. Valid values:

Enabled: CAM user synchronization is enabled.
Disabled: CAM user synchronization is disabled.
        :type Status: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalName: Identity name for the CAM user synchronization. Valid values:When the PrincipalType value is Group, it is the CIC user group name.
When the PrincipalType value is User, it is the CIC user name.
        :type PrincipalName: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetName: Name of the target account of the Tencent Cloud Organization.
        :type TargetName: str
        :param _DuplicationStrategy: Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :type DuplicationStrategy: str
        :param _DeletionStrategy: Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :type DeletionStrategy: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        """
        self._UserProvisioningId = None
        self._Description = None
        self._Status = None
        self._PrincipalId = None
        self._PrincipalName = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetName = None
        self._DuplicationStrategy = None
        self._DeletionStrategy = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TargetType = None

    @property
    def UserProvisioningId(self):
        r"""CAM user synchronization status. Valid values:

Enabled: CAM user synchronization is enabled.
Disabled: CAM user synchronization is disabled.
        :rtype: str
        """
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId

    @property
    def Description(self):
        r"""Description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        r"""CAM user synchronization status. Valid values:

Enabled: CAM user synchronization is enabled.
Disabled: CAM user synchronization is disabled.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PrincipalId(self):
        r"""Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalName(self):
        r"""Identity name for the CAM user synchronization. Valid values:When the PrincipalType value is Group, it is the CIC user group name.
When the PrincipalType value is User, it is the CIC user name.
        :rtype: str
        """
        return self._PrincipalName

    @PrincipalName.setter
    def PrincipalName(self, PrincipalName):
        self._PrincipalName = PrincipalName

    @property
    def PrincipalType(self):
        r"""Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        r"""UIN of the target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetName(self):
        r"""Name of the target account of the Tencent Cloud Organization.
        :rtype: str
        """
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName

    @property
    def DuplicationStrategy(self):
        r"""Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :rtype: str
        """
        return self._DuplicationStrategy

    @DuplicationStrategy.setter
    def DuplicationStrategy(self, DuplicationStrategy):
        self._DuplicationStrategy = DuplicationStrategy

    @property
    def DeletionStrategy(self):
        r"""Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :rtype: str
        """
        return self._DeletionStrategy

    @DeletionStrategy.setter
    def DeletionStrategy(self, DeletionStrategy):
        self._DeletionStrategy = DeletionStrategy

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType


    def _deserialize(self, params):
        self._UserProvisioningId = params.get("UserProvisioningId")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalName = params.get("PrincipalName")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetName = params.get("TargetName")
        self._DuplicationStrategy = params.get("DuplicationStrategy")
        self._DeletionStrategy = params.get("DeletionStrategy")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TargetType = params.get("TargetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserProvisioningsTask(AbstractModel):
    r"""Status information of the user synchronization task.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _TargetUin: UIN of the authorized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TaskType: Task type. StartProvisioning: Start the user synchronization; DeleteProvisioning: Delete the user synchronization.
        :type TaskType: str
        :param _TaskStatus: Task status. InProgress: The task is in progress; Failed: The task failed; Success: The task succeeded.
        :type TaskStatus: str
        :param _UserProvisioningId: User synchronization ID.
        :type UserProvisioningId: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _PrincipalName: User name or user group name.
        :type PrincipalName: str
        :param _DuplicationStrategy: Conflict policy. KeepBoth: Keep both; TakeOver: Replace.
        :type DuplicationStrategy: str
        :param _DeletionStrategy: Deletion policy: Delete, Keep.
        :type DeletionStrategy: str
        """
        self._TaskId = None
        self._TargetUin = None
        self._TargetType = None
        self._TaskType = None
        self._TaskStatus = None
        self._UserProvisioningId = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._PrincipalName = None
        self._DuplicationStrategy = None
        self._DeletionStrategy = None

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TargetUin(self):
        r"""UIN of the authorized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TaskType(self):
        r"""Task type. StartProvisioning: Start the user synchronization; DeleteProvisioning: Delete the user synchronization.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskStatus(self):
        r"""Task status. InProgress: The task is in progress; Failed: The task failed; Success: The task succeeded.
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def UserProvisioningId(self):
        r"""User synchronization ID.
        :rtype: str
        """
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId

    @property
    def PrincipalId(self):
        r"""Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        r"""Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalName(self):
        r"""User name or user group name.
        :rtype: str
        """
        return self._PrincipalName

    @PrincipalName.setter
    def PrincipalName(self, PrincipalName):
        self._PrincipalName = PrincipalName

    @property
    def DuplicationStrategy(self):
        r"""Conflict policy. KeepBoth: Keep both; TakeOver: Replace.
        :rtype: str
        """
        return self._DuplicationStrategy

    @DuplicationStrategy.setter
    def DuplicationStrategy(self, DuplicationStrategy):
        self._DuplicationStrategy = DuplicationStrategy

    @property
    def DeletionStrategy(self):
        r"""Deletion policy: Delete, Keep.
        :rtype: str
        """
        return self._DeletionStrategy

    @DeletionStrategy.setter
    def DeletionStrategy(self, DeletionStrategy):
        self._DeletionStrategy = DeletionStrategy


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._TaskType = params.get("TaskType")
        self._TaskStatus = params.get("TaskStatus")
        self._UserProvisioningId = params.get("UserProvisioningId")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalName = params.get("PrincipalName")
        self._DuplicationStrategy = params.get("DuplicationStrategy")
        self._DeletionStrategy = params.get("DeletionStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserSyncProvisioning(AbstractModel):
    r"""CAM user synchronization information.

    """

    def __init__(self):
        r"""
        :param _Description: Description.
        :type Description: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _DuplicationStrategy: Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :type DuplicationStrategy: str
        :param _DeletionStrategy: Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :type DeletionStrategy: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        """
        self._Description = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._TargetUin = None
        self._DuplicationStrategy = None
        self._DeletionStrategy = None
        self._TargetType = None

    @property
    def Description(self):
        r"""Description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PrincipalId(self):
        r"""Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :rtype: str
        """
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        r"""Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :rtype: str
        """
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        r"""UIN of the synchronized target account of the Tencent Cloud Organization.
        :rtype: int
        """
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def DuplicationStrategy(self):
        r"""Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :rtype: str
        """
        return self._DuplicationStrategy

    @DuplicationStrategy.setter
    def DuplicationStrategy(self, DuplicationStrategy):
        self._DuplicationStrategy = DuplicationStrategy

    @property
    def DeletionStrategy(self):
        r"""Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :rtype: str
        """
        return self._DeletionStrategy

    @DeletionStrategy.setter
    def DeletionStrategy(self, DeletionStrategy):
        self._DeletionStrategy = DeletionStrategy

    @property
    def TargetType(self):
        r"""Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :rtype: str
        """
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._DuplicationStrategy = params.get("DuplicationStrategy")
        self._DeletionStrategy = params.get("DeletionStrategy")
        self._TargetType = params.get("TargetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ZoneStatistics(AbstractModel):
    r"""CIC space statistics.

    """

    def __init__(self):
        r"""
        :param _UserQuota: User quota.
        :type UserQuota: int
        :param _GroupQuota: User group quota.
        :type GroupQuota: int
        :param _RoleConfigurationQuota: Permission configuration quota.
        :type RoleConfigurationQuota: int
        :param _SystemPolicyPerRoleConfigurationQuota: System policy quota bound to the permission configuration.
        :type SystemPolicyPerRoleConfigurationQuota: int
        :param _UserCount: Number of users.
        :type UserCount: int
        :param _GroupCount: Number of user groups.
        :type GroupCount: int
        :param _RoleConfigurationCount: Number of permission configurations.
        :type RoleConfigurationCount: int
        :param _UserProvisioningCount: Number of synchronized users.
        :type UserProvisioningCount: int
        :param _RoleConfigurationSyncCount: Number of synchronized roles.
        :type RoleConfigurationSyncCount: int
        """
        self._UserQuota = None
        self._GroupQuota = None
        self._RoleConfigurationQuota = None
        self._SystemPolicyPerRoleConfigurationQuota = None
        self._UserCount = None
        self._GroupCount = None
        self._RoleConfigurationCount = None
        self._UserProvisioningCount = None
        self._RoleConfigurationSyncCount = None

    @property
    def UserQuota(self):
        r"""User quota.
        :rtype: int
        """
        return self._UserQuota

    @UserQuota.setter
    def UserQuota(self, UserQuota):
        self._UserQuota = UserQuota

    @property
    def GroupQuota(self):
        r"""User group quota.
        :rtype: int
        """
        return self._GroupQuota

    @GroupQuota.setter
    def GroupQuota(self, GroupQuota):
        self._GroupQuota = GroupQuota

    @property
    def RoleConfigurationQuota(self):
        r"""Permission configuration quota.
        :rtype: int
        """
        return self._RoleConfigurationQuota

    @RoleConfigurationQuota.setter
    def RoleConfigurationQuota(self, RoleConfigurationQuota):
        self._RoleConfigurationQuota = RoleConfigurationQuota

    @property
    def SystemPolicyPerRoleConfigurationQuota(self):
        r"""System policy quota bound to the permission configuration.
        :rtype: int
        """
        return self._SystemPolicyPerRoleConfigurationQuota

    @SystemPolicyPerRoleConfigurationQuota.setter
    def SystemPolicyPerRoleConfigurationQuota(self, SystemPolicyPerRoleConfigurationQuota):
        self._SystemPolicyPerRoleConfigurationQuota = SystemPolicyPerRoleConfigurationQuota

    @property
    def UserCount(self):
        r"""Number of users.
        :rtype: int
        """
        return self._UserCount

    @UserCount.setter
    def UserCount(self, UserCount):
        self._UserCount = UserCount

    @property
    def GroupCount(self):
        r"""Number of user groups.
        :rtype: int
        """
        return self._GroupCount

    @GroupCount.setter
    def GroupCount(self, GroupCount):
        self._GroupCount = GroupCount

    @property
    def RoleConfigurationCount(self):
        r"""Number of permission configurations.
        :rtype: int
        """
        return self._RoleConfigurationCount

    @RoleConfigurationCount.setter
    def RoleConfigurationCount(self, RoleConfigurationCount):
        self._RoleConfigurationCount = RoleConfigurationCount

    @property
    def UserProvisioningCount(self):
        r"""Number of synchronized users.
        :rtype: int
        """
        return self._UserProvisioningCount

    @UserProvisioningCount.setter
    def UserProvisioningCount(self, UserProvisioningCount):
        self._UserProvisioningCount = UserProvisioningCount

    @property
    def RoleConfigurationSyncCount(self):
        r"""Number of synchronized roles.
        :rtype: int
        """
        return self._RoleConfigurationSyncCount

    @RoleConfigurationSyncCount.setter
    def RoleConfigurationSyncCount(self, RoleConfigurationSyncCount):
        self._RoleConfigurationSyncCount = RoleConfigurationSyncCount


    def _deserialize(self, params):
        self._UserQuota = params.get("UserQuota")
        self._GroupQuota = params.get("GroupQuota")
        self._RoleConfigurationQuota = params.get("RoleConfigurationQuota")
        self._SystemPolicyPerRoleConfigurationQuota = params.get("SystemPolicyPerRoleConfigurationQuota")
        self._UserCount = params.get("UserCount")
        self._GroupCount = params.get("GroupCount")
        self._RoleConfigurationCount = params.get("RoleConfigurationCount")
        self._UserProvisioningCount = params.get("UserProvisioningCount")
        self._RoleConfigurationSyncCount = params.get("RoleConfigurationSyncCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        