# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    r"""AI-based intelligent analysis template details

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of intelligent analysis template.
        :type Definition: int
        :param _Name: Intelligent analysis template name.
        :type Name: str
        :param _Comment: Intelligent analysis template description.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: Control parameter of intelligent tagging task.
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type UpdateTime: str
        :param _Type: The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        r"""Unique ID of intelligent analysis template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""Intelligent analysis template name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Intelligent analysis template description.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        r"""Control parameter of intelligent categorization task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        r"""Control parameter of intelligent tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        r"""Control parameter of intelligent cover generating task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        r"""Control parameter of intelligent frame-specific tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def CreateTime(self):
        r"""Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    r"""Details of a video content recognition template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        :param _Name: Name of a video content recognition template.
        :type Name: str
        :param _Comment: Description of a video content recognition template.
        :type Comment: str
        :param _FaceConfigure: Face recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: Full text recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: Text keyword recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: Full speech recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: Speech keyword recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        :param _TranslateConfigure: Voice translation control parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TranslateConfigure: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _Type: The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._TranslateConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        r"""Unique ID of a video content recognition template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""Name of a video content recognition template.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description of a video content recognition template.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        r"""Face recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        r"""Full text recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        r"""Text keyword recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        r"""Full speech recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        r"""Speech keyword recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def TranslateConfigure(self):
        r"""Voice translation control parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        """
        return self._TranslateConfigure

    @TranslateConfigure.setter
    def TranslateConfigure(self, TranslateConfigure):
        self._TranslateConfigure = TranslateConfigure

    @property
    def CreateTime(self):
        r"""Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("TranslateConfigure") is not None:
            self._TranslateConfigure = TranslateConfigureInfo()
            self._TranslateConfigure._deserialize(params.get("TranslateConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Activity(AbstractModel):
    r"""A subtask of a scheme.

    """

    def __init__(self):
        r"""
        :param _ActivityType: Atomic task type.
<li>input: starting node.</li>.
<li>output: termination node.</li>.
<li>action-trans: specifies transcoding.</li>.
<li>action-samplesnapshot: specifies sampled screenshot taking.</li>.
<li>action-AIAnalysis: analysis.</li>.
<li>action-AIRecognition: recognition.</li>.
<li>action-aiReview: specifies the review action.</li>.
<li>action-animated-graphics: specifies the animated image.</li>.
<li>action-image-sprite: specifies the sprite sheet.</li>.
<li>action-snapshotByTimeOffset: specifies time point screenshot taking.</li>.
<li>action-adaptive-substream: specifies the adaptive bitrate stream.</li>.
<li>action-AIQualityControl: media quality inspection.</li>.
<li>action-SmartSubtitles: smart subtitling.</li>.
<li>action-exec-rules: judgment rule.</li>.
<li>action-SmartErase: smart erasure.</li>.



        :type ActivityType: str
        :param _ReardriveIndex: Rear node index array.
        :type ReardriveIndex: list of int
        :param _ActivityPara: The parameters of a subtask.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ActivityPara: :class:`tencentcloud.mps.v20190612.models.ActivityPara`
        """
        self._ActivityType = None
        self._ReardriveIndex = None
        self._ActivityPara = None

    @property
    def ActivityType(self):
        r"""Atomic task type.
<li>input: starting node.</li>.
<li>output: termination node.</li>.
<li>action-trans: specifies transcoding.</li>.
<li>action-samplesnapshot: specifies sampled screenshot taking.</li>.
<li>action-AIAnalysis: analysis.</li>.
<li>action-AIRecognition: recognition.</li>.
<li>action-aiReview: specifies the review action.</li>.
<li>action-animated-graphics: specifies the animated image.</li>.
<li>action-image-sprite: specifies the sprite sheet.</li>.
<li>action-snapshotByTimeOffset: specifies time point screenshot taking.</li>.
<li>action-adaptive-substream: specifies the adaptive bitrate stream.</li>.
<li>action-AIQualityControl: media quality inspection.</li>.
<li>action-SmartSubtitles: smart subtitling.</li>.
<li>action-exec-rules: judgment rule.</li>.
<li>action-SmartErase: smart erasure.</li>.



        :rtype: str
        """
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ReardriveIndex(self):
        r"""Rear node index array.
        :rtype: list of int
        """
        return self._ReardriveIndex

    @ReardriveIndex.setter
    def ReardriveIndex(self, ReardriveIndex):
        self._ReardriveIndex = ReardriveIndex

    @property
    def ActivityPara(self):
        r"""The parameters of a subtask.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ActivityPara`
        """
        return self._ActivityPara

    @ActivityPara.setter
    def ActivityPara(self, ActivityPara):
        self._ActivityPara = ActivityPara


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        self._ReardriveIndex = params.get("ReardriveIndex")
        if params.get("ActivityPara") is not None:
            self._ActivityPara = ActivityPara()
            self._ActivityPara._deserialize(params.get("ActivityPara"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityPara(AbstractModel):
    r"""A subtask of a scheme.

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: A transcoding task.
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        :param _AnimatedGraphicTask: An animated screenshot generation task.
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        :param _SnapshotByTimeOffsetTask: A time point screenshot task.
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        :param _SampleSnapshotTask: A sampled screenshot task.
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        :param _ImageSpriteTask: An image sprite screenshot task.
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        :param _AdaptiveDynamicStreamingTask: An adaptive bitrate streaming task.
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        :param _AiContentReviewTask: A content moderation task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: A content analysis task.
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: A content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _QualityControlTask: Media quality inspection task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QualityControlTask: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        :param _ExecRulesTask: Conditional judgment of the task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExecRulesTask: :class:`tencentcloud.mps.v20190612.models.ExecRulesTask`
        :param _SmartSubtitlesTask: Smart subtitle task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SmartSubtitlesTask: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        :param _SmartEraseTask: Smart erasure task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SmartEraseTask: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskInput`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._QualityControlTask = None
        self._ExecRulesTask = None
        self._SmartSubtitlesTask = None
        self._SmartEraseTask = None

    @property
    def TranscodeTask(self):
        r"""A transcoding task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        """
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        r"""An animated screenshot generation task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        """
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        r"""A time point screenshot task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        """
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        r"""A sampled screenshot task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        """
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        r"""An image sprite screenshot task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        """
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        r"""An adaptive bitrate streaming task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        """
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def AiContentReviewTask(self):
        r"""A content moderation task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        """
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        r"""A content analysis task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        """
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        r"""A content recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        """
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def QualityControlTask(self):
        r"""Media quality inspection task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        """
        return self._QualityControlTask

    @QualityControlTask.setter
    def QualityControlTask(self, QualityControlTask):
        self._QualityControlTask = QualityControlTask

    @property
    def ExecRulesTask(self):
        r"""Conditional judgment of the task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ExecRulesTask`
        """
        return self._ExecRulesTask

    @ExecRulesTask.setter
    def ExecRulesTask(self, ExecRulesTask):
        self._ExecRulesTask = ExecRulesTask

    @property
    def SmartSubtitlesTask(self):
        r"""Smart subtitle task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        """
        return self._SmartSubtitlesTask

    @SmartSubtitlesTask.setter
    def SmartSubtitlesTask(self, SmartSubtitlesTask):
        self._SmartSubtitlesTask = SmartSubtitlesTask

    @property
    def SmartEraseTask(self):
        r"""Smart erasure task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskInput`
        """
        return self._SmartEraseTask

    @SmartEraseTask.setter
    def SmartEraseTask(self, SmartEraseTask):
        self._SmartEraseTask = SmartEraseTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = TranscodeTaskInput()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = AnimatedGraphicTaskInput()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTaskInput()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = SampleSnapshotTaskInput()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = ImageSpriteTaskInput()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTaskInput()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("QualityControlTask") is not None:
            self._QualityControlTask = AiQualityControlTaskInput()
            self._QualityControlTask._deserialize(params.get("QualityControlTask"))
        if params.get("ExecRulesTask") is not None:
            self._ExecRulesTask = ExecRulesTask()
            self._ExecRulesTask._deserialize(params.get("ExecRulesTask"))
        if params.get("SmartSubtitlesTask") is not None:
            self._SmartSubtitlesTask = SmartSubtitlesTaskInput()
            self._SmartSubtitlesTask._deserialize(params.get("SmartSubtitlesTask"))
        if params.get("SmartEraseTask") is not None:
            self._SmartEraseTask = SmartEraseTaskInput()
            self._SmartEraseTask._deserialize(params.get("SmartEraseTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResItem(AbstractModel):
    r"""The execution results of the subtasks of a scheme.

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: The result of a transcoding task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        :param _AnimatedGraphicTask: The result of an animated image generating task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        :param _SnapshotByTimeOffsetTask: The result of a time point screenshot task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        :param _SampleSnapshotTask: The result of a sampled screenshot task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _ImageSpriteTask: The result of an image sprite task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        :param _AdaptiveDynamicStreamingTask: The result of an adaptive bitrate streaming task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        :param _RecognitionTask: The result of a content recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecognitionTask: :class:`tencentcloud.mps.v20190612.models.ScheduleRecognitionTaskResult`
        :param _ReviewTask: The result of a content moderation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReviewTask: :class:`tencentcloud.mps.v20190612.models.ScheduleReviewTaskResult`
        :param _AnalysisTask: The result of a content analysis task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AnalysisTask: :class:`tencentcloud.mps.v20190612.models.ScheduleAnalysisTaskResult`
        :param _QualityControlTask: Media quality inspection task output.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QualityControlTask: :class:`tencentcloud.mps.v20190612.models.ScheduleQualityControlTaskResult`
        :param _ExecRuleTask: Conditional judgment task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExecRuleTask: :class:`tencentcloud.mps.v20190612.models.ScheduleExecRuleTaskResult`
        :param _SmartSubtitlesTask: Smart subtitle task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SmartSubtitlesTask: :class:`tencentcloud.mps.v20190612.models.ScheduleSmartSubtitleTaskResult`
        :param _SmartEraseTask: Smart erase task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SmartEraseTask: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskResult`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._RecognitionTask = None
        self._ReviewTask = None
        self._AnalysisTask = None
        self._QualityControlTask = None
        self._ExecRuleTask = None
        self._SmartSubtitlesTask = None
        self._SmartEraseTask = None

    @property
    def TranscodeTask(self):
        r"""The result of a transcoding task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        """
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        r"""The result of an animated image generating task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        """
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        r"""The result of a time point screenshot task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        """
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        r"""The result of a sampled screenshot task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        """
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        r"""The result of an image sprite task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        """
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        r"""The result of an adaptive bitrate streaming task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        """
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def RecognitionTask(self):
        r"""The result of a content recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleRecognitionTaskResult`
        """
        return self._RecognitionTask

    @RecognitionTask.setter
    def RecognitionTask(self, RecognitionTask):
        self._RecognitionTask = RecognitionTask

    @property
    def ReviewTask(self):
        r"""The result of a content moderation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleReviewTaskResult`
        """
        return self._ReviewTask

    @ReviewTask.setter
    def ReviewTask(self, ReviewTask):
        self._ReviewTask = ReviewTask

    @property
    def AnalysisTask(self):
        r"""The result of a content analysis task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleAnalysisTaskResult`
        """
        return self._AnalysisTask

    @AnalysisTask.setter
    def AnalysisTask(self, AnalysisTask):
        self._AnalysisTask = AnalysisTask

    @property
    def QualityControlTask(self):
        r"""Media quality inspection task output.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleQualityControlTaskResult`
        """
        return self._QualityControlTask

    @QualityControlTask.setter
    def QualityControlTask(self, QualityControlTask):
        self._QualityControlTask = QualityControlTask

    @property
    def ExecRuleTask(self):
        r"""Conditional judgment task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleExecRuleTaskResult`
        """
        return self._ExecRuleTask

    @ExecRuleTask.setter
    def ExecRuleTask(self, ExecRuleTask):
        self._ExecRuleTask = ExecRuleTask

    @property
    def SmartSubtitlesTask(self):
        r"""Smart subtitle task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleSmartSubtitleTaskResult`
        """
        return self._SmartSubtitlesTask

    @SmartSubtitlesTask.setter
    def SmartSubtitlesTask(self, SmartSubtitlesTask):
        self._SmartSubtitlesTask = SmartSubtitlesTask

    @property
    def SmartEraseTask(self):
        r"""Smart erase task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseTaskResult`
        """
        return self._SmartEraseTask

    @SmartEraseTask.setter
    def SmartEraseTask(self, SmartEraseTask):
        self._SmartEraseTask = SmartEraseTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = MediaProcessTaskTranscodeResult()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = MediaProcessTaskAnimatedGraphicResult()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = MediaProcessTaskSnapshotByTimeOffsetResult()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = MediaProcessTaskSampleSnapshotResult()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = MediaProcessTaskImageSpriteResult()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = MediaProcessTaskAdaptiveDynamicStreamingResult()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("RecognitionTask") is not None:
            self._RecognitionTask = ScheduleRecognitionTaskResult()
            self._RecognitionTask._deserialize(params.get("RecognitionTask"))
        if params.get("ReviewTask") is not None:
            self._ReviewTask = ScheduleReviewTaskResult()
            self._ReviewTask._deserialize(params.get("ReviewTask"))
        if params.get("AnalysisTask") is not None:
            self._AnalysisTask = ScheduleAnalysisTaskResult()
            self._AnalysisTask._deserialize(params.get("AnalysisTask"))
        if params.get("QualityControlTask") is not None:
            self._QualityControlTask = ScheduleQualityControlTaskResult()
            self._QualityControlTask._deserialize(params.get("QualityControlTask"))
        if params.get("ExecRuleTask") is not None:
            self._ExecRuleTask = ScheduleExecRuleTaskResult()
            self._ExecRuleTask._deserialize(params.get("ExecRuleTask"))
        if params.get("SmartSubtitlesTask") is not None:
            self._SmartSubtitlesTask = ScheduleSmartSubtitleTaskResult()
            self._SmartSubtitlesTask._deserialize(params.get("SmartSubtitlesTask"))
        if params.get("SmartEraseTask") is not None:
            self._SmartEraseTask = SmartEraseTaskResult()
            self._SmartEraseTask._deserialize(params.get("SmartEraseTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResult(AbstractModel):
    r"""The execution result of a scheme.

    """

    def __init__(self):
        r"""
        :param _ActivityType: Atomic task type.
<Li>Transcode: transcoding.</li>.
<Li>SampleSnapshot: specifies sampled screenshot taking.</li>.
<Li>AnimatedGraphics: specifies the animated image.</li>.
<Li>SnapshotByTimeOffset: specifies time point screenshot taking.</li>.
<Li>ImageSprites: specifies the sprite sheet.</li>.
<Li>AdaptiveDynamicStreaming: adaptive bitrate streaming.</li>.
<Li>AiContentReview: specifies content moderation.</li>.
<Li>AIRecognition: intelligent identification.</li>.
<Li>AIAnalysis: specifies ai analysis.</li>.
<li>AiQualityControl: media quality inspection</li>

<Li>SmartSubtitles: smart subtitle</li>

<Li>SmartErase: smart erasure.</li>.
        :type ActivityType: str
        :param _ActivityResItem: The execution results of the subtasks of the scheme.
        :type ActivityResItem: :class:`tencentcloud.mps.v20190612.models.ActivityResItem`
        """
        self._ActivityType = None
        self._ActivityResItem = None

    @property
    def ActivityType(self):
        r"""Atomic task type.
<Li>Transcode: transcoding.</li>.
<Li>SampleSnapshot: specifies sampled screenshot taking.</li>.
<Li>AnimatedGraphics: specifies the animated image.</li>.
<Li>SnapshotByTimeOffset: specifies time point screenshot taking.</li>.
<Li>ImageSprites: specifies the sprite sheet.</li>.
<Li>AdaptiveDynamicStreaming: adaptive bitrate streaming.</li>.
<Li>AiContentReview: specifies content moderation.</li>.
<Li>AIRecognition: intelligent identification.</li>.
<Li>AIAnalysis: specifies ai analysis.</li>.
<li>AiQualityControl: media quality inspection</li>

<Li>SmartSubtitles: smart subtitle</li>

<Li>SmartErase: smart erasure.</li>.
        :rtype: str
        """
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ActivityResItem(self):
        r"""The execution results of the subtasks of the scheme.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ActivityResItem`
        """
        return self._ActivityResItem

    @ActivityResItem.setter
    def ActivityResItem(self, ActivityResItem):
        self._ActivityResItem = ActivityResItem


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        if params.get("ActivityResItem") is not None:
            self._ActivityResItem = ActivityResItem()
            self._ActivityResItem._deserialize(params.get("ActivityResItem"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    r"""Adaptive bitrate streaming information

    """

    def __init__(self):
        r"""
        :param _Definition: Adaptive bitrate streaming specification.
        :type Definition: int
        :param _Package: Container format. Valid values: HLS, MPEG-DASH.
        :type Package: str
        :param _Path: Playback address.
        :type Path: str
        :param _Storage: Storage location of adaptive bitrate streaming files.
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._Package = None
        self._Path = None
        self._Storage = None

    @property
    def Definition(self):
        r"""Adaptive bitrate streaming specification.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        r"""Container format. Valid values: HLS, MPEG-DASH.
        :rtype: str
        """
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def Path(self):
        r"""Playback address.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Storage(self):
        r"""Storage location of adaptive bitrate streaming files.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._Path = params.get("Path")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    r"""Input parameter type of adaptive bitrate streaming

    """

    def __init__(self):
        r"""
        :param _Definition: Adaptive dynamic streaming template ID.
        :type Definition: int
        :param _WatermarkSet: Watermark list. Multiple image or text watermarks up to a maximum of 10 are supported.
        :type WatermarkSet: list of WatermarkInput
        :param _BlindWatermark: Digital watermark parameter.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type BlindWatermark: :class:`tencentcloud.mps.v20190612.models.BlindWatermarkInput`
        :param _OutputStorage: Target storage for files after adaptive dynamic streaming. If left blank, it inherits the upper-level OutputStorage value.
Note: This field may return null, indicating that no valid value can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: Output path for the manifest file after adaptive dynamic streaming. It can be either a relative path or an absolute path.
If you need to define an output path, the path must end with `.{format}`. Refer to [Filename Variable Description](https://intl.cloud.tencent.com/document/product/862/37039?from_cn_redirect=1) for variable names.
Example of relative path:
<li>filename_{variable name}.{format}</li>
<li>filename.{format}</li>
Example of absolute path:
<li>/custom path/filename_{variable name}.{format}</li>
If not filled in, it is a relative path by default: {inputName}_adaptiveDynamicStreaming_{definition}.{format}.
        :type OutputObjectPath: str
        :param _SubStreamObjectName: After adaptive dynamic streaming, the output path of substream files can only be a relative path. If not filled in, it is a relative path by default: `{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}.{format}`.
        :type SubStreamObjectName: str
        :param _SegmentObjectName: After adaptive dynamic streaming (for HLS only), the output path of segment files can only be a relative path. If not filled in, it is a relative path by default: `{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}_{segmentNumber}.{format}`.
        :type SegmentObjectName: str
        :param _AddOnSubtitles: External subtitle feature specifies the subtitle file to be inserted.
Note: This field may return null, indicating that no valid value can be obtained.
        :type AddOnSubtitles: list of AddOnSubtitle
        :param _DrmInfo: Specifies the Drm information.
Note: This field may return null, indicating that no valid value can be obtained.
        :type DrmInfo: :class:`tencentcloud.mps.v20190612.models.DrmInfo`
        :param _DefinitionType: Adaptive transcoding template type.
Common: audio/video type.
PureAudio: audio-only.
        :type DefinitionType: str
        :param _SubtitleTemplate: Hard subtitle (suppression subtitle) feature, specify subtitles source, font size, position and other subtitle parameters.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SubtitleTemplate: :class:`tencentcloud.mps.v20190612.models.SubtitleTemplate`
        :param _StdExtInfo: Transcoding parameter extension field.
        :type StdExtInfo: str
        :param _KeyPTSList: Specifies the frame at the given pts time as a key frame and segments it. unit: milliseconds (relative deviation <=1ms is allowed). when gop and segment duration are specified simultaneously, they function together. note: enable RawPts, keep the frame rate as source, and ensure the passed-in pts time corresponds to a frame in the source.
Note: This field may return null, indicating that no valid values can be obtained.
        :type KeyPTSList: list of int
        """
        self._Definition = None
        self._WatermarkSet = None
        self._BlindWatermark = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._SubStreamObjectName = None
        self._SegmentObjectName = None
        self._AddOnSubtitles = None
        self._DrmInfo = None
        self._DefinitionType = None
        self._SubtitleTemplate = None
        self._StdExtInfo = None
        self._KeyPTSList = None

    @property
    def Definition(self):
        r"""Adaptive dynamic streaming template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        r"""Watermark list. Multiple image or text watermarks up to a maximum of 10 are supported.
        :rtype: list of WatermarkInput
        """
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def BlindWatermark(self):
        r"""Digital watermark parameter.	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.BlindWatermarkInput`
        """
        return self._BlindWatermark

    @BlindWatermark.setter
    def BlindWatermark(self, BlindWatermark):
        self._BlindWatermark = BlindWatermark

    @property
    def OutputStorage(self):
        r"""Target storage for files after adaptive dynamic streaming. If left blank, it inherits the upper-level OutputStorage value.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        r"""Output path for the manifest file after adaptive dynamic streaming. It can be either a relative path or an absolute path.
If you need to define an output path, the path must end with `.{format}`. Refer to [Filename Variable Description](https://intl.cloud.tencent.com/document/product/862/37039?from_cn_redirect=1) for variable names.
Example of relative path:
<li>filename_{variable name}.{format}</li>
<li>filename.{format}</li>
Example of absolute path:
<li>/custom path/filename_{variable name}.{format}</li>
If not filled in, it is a relative path by default: {inputName}_adaptiveDynamicStreaming_{definition}.{format}.
        :rtype: str
        """
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def SubStreamObjectName(self):
        r"""After adaptive dynamic streaming, the output path of substream files can only be a relative path. If not filled in, it is a relative path by default: `{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}.{format}`.
        :rtype: str
        """
        return self._SubStreamObjectName

    @SubStreamObjectName.setter
    def SubStreamObjectName(self, SubStreamObjectName):
        self._SubStreamObjectName = SubStreamObjectName

    @property
    def SegmentObjectName(self):
        r"""After adaptive dynamic streaming (for HLS only), the output path of segment files can only be a relative path. If not filled in, it is a relative path by default: `{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}_{segmentNumber}.{format}`.
        :rtype: str
        """
        return self._SegmentObjectName

    @SegmentObjectName.setter
    def SegmentObjectName(self, SegmentObjectName):
        self._SegmentObjectName = SegmentObjectName

    @property
    def AddOnSubtitles(self):
        r"""External subtitle feature specifies the subtitle file to be inserted.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of AddOnSubtitle
        """
        return self._AddOnSubtitles

    @AddOnSubtitles.setter
    def AddOnSubtitles(self, AddOnSubtitles):
        self._AddOnSubtitles = AddOnSubtitles

    @property
    def DrmInfo(self):
        r"""Specifies the Drm information.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.DrmInfo`
        """
        return self._DrmInfo

    @DrmInfo.setter
    def DrmInfo(self, DrmInfo):
        self._DrmInfo = DrmInfo

    @property
    def DefinitionType(self):
        r"""Adaptive transcoding template type.
Common: audio/video type.
PureAudio: audio-only.
        :rtype: str
        """
        return self._DefinitionType

    @DefinitionType.setter
    def DefinitionType(self, DefinitionType):
        self._DefinitionType = DefinitionType

    @property
    def SubtitleTemplate(self):
        r"""Hard subtitle (suppression subtitle) feature, specify subtitles source, font size, position and other subtitle parameters.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SubtitleTemplate`
        """
        return self._SubtitleTemplate

    @SubtitleTemplate.setter
    def SubtitleTemplate(self, SubtitleTemplate):
        self._SubtitleTemplate = SubtitleTemplate

    @property
    def StdExtInfo(self):
        r"""Transcoding parameter extension field.
        :rtype: str
        """
        return self._StdExtInfo

    @StdExtInfo.setter
    def StdExtInfo(self, StdExtInfo):
        self._StdExtInfo = StdExtInfo

    @property
    def KeyPTSList(self):
        r"""Specifies the frame at the given pts time as a key frame and segments it. unit: milliseconds (relative deviation <=1ms is allowed). when gop and segment duration are specified simultaneously, they function together. note: enable RawPts, keep the frame rate as source, and ensure the passed-in pts time corresponds to a frame in the source.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._KeyPTSList

    @KeyPTSList.setter
    def KeyPTSList(self, KeyPTSList):
        self._KeyPTSList = KeyPTSList


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("BlindWatermark") is not None:
            self._BlindWatermark = BlindWatermarkInput()
            self._BlindWatermark._deserialize(params.get("BlindWatermark"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        self._SubStreamObjectName = params.get("SubStreamObjectName")
        self._SegmentObjectName = params.get("SegmentObjectName")
        if params.get("AddOnSubtitles") is not None:
            self._AddOnSubtitles = []
            for item in params.get("AddOnSubtitles"):
                obj = AddOnSubtitle()
                obj._deserialize(item)
                self._AddOnSubtitles.append(obj)
        if params.get("DrmInfo") is not None:
            self._DrmInfo = DrmInfo()
            self._DrmInfo._deserialize(params.get("DrmInfo"))
        self._DefinitionType = params.get("DefinitionType")
        if params.get("SubtitleTemplate") is not None:
            self._SubtitleTemplate = SubtitleTemplate()
            self._SubtitleTemplate._deserialize(params.get("SubtitleTemplate"))
        self._StdExtInfo = params.get("StdExtInfo")
        self._KeyPTSList = params.get("KeyPTSList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    r"""Details of an adaptive bitrate streaming template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        :param _Name: Name of an adaptive bitrate streaming template.
        :type Name: str
        :param _Comment: Description of an adaptive bitrate streaming template.
        :type Comment: str
        :param _Format: Adaptive bitrate streaming format. Valid values:
<li>HLS;</li>
<li>MPEG-DASH.</li>
        :type Format: str
        :param _StreamInfos: Parameter information of input streams for transcoding to adaptive bitrate streaming. Up to 10 streams can be input.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        :param _PureAudio: Whether it is an audio-only template. 0: video template. 1: audio-only template.Note: This field may return null, indicating that no valid values can be obtained.
        :type PureAudio: int
        :param _SegmentType: HLS segment type. Valid values:
<li>ts-segment: HLS+TS segment.</li>
<li>ts-byterange: HLS+TS byte range.</li>
<li>mp4-segment: HLS+MP4 segment.</li>
<li>mp4-byterange: HLS+MP4 byte range.</li>
<li>ts-packed-audio: TS+Packed audio.</li>
<li>mp4-packed-audio: MP4+Packed audio.</li>
Default value: ts-segment.

Note: The HLS segment format for adaptive bitrate streaming is based on this field.Note: This field may return null, indicating that no valid values can be obtained.
        :type SegmentType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Definition(self):
        r"""Unique ID of an adaptive bitrate streaming template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""Template type. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Name of an adaptive bitrate streaming template.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description of an adaptive bitrate streaming template.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        r"""Adaptive bitrate streaming format. Valid values:
<li>HLS;</li>
<li>MPEG-DASH.</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        r"""Parameter information of input streams for transcoding to adaptive bitrate streaming. Up to 10 streams can be input.
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        r"""Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        r"""Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        r"""Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def PureAudio(self):
        r"""Whether it is an audio-only template. 0: video template. 1: audio-only template.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        r"""HLS segment type. Valid values:
<li>ts-segment: HLS+TS segment.</li>
<li>ts-byterange: HLS+TS byte range.</li>
<li>mp4-segment: HLS+MP4 segment.</li>
<li>mp4-byterange: HLS+MP4 byte range.</li>
<li>ts-packed-audio: TS+Packed audio.</li>
<li>mp4-packed-audio: MP4+Packed audio.</li>
Default value: ts-segment.

Note: The HLS segment format for adaptive bitrate streaming is based on this field.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    r"""Adaptive bitrate streaming parameter template

    """

    def __init__(self):
        r"""
        :param _Audio: Audio parameter information.
        :type Audio: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _Video: Video parameter information.
        :type Video: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _RemoveAudio: Whether to remove audio stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type RemoveAudio: int
        :param _RemoveVideo: Whether to remove video stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type RemoveVideo: int
        :param _AudioList: Audio parameter information list.
The parameter is only used when merging multiple audio tracks in adaptive bitrate transcoding. the maximum length of the parameter array is 64.

Note: This field may return null, indicating that no valid value can be obtained.
        :type AudioList: list of AudioTemplateInfo
        """
        self._Audio = None
        self._Video = None
        self._RemoveAudio = None
        self._RemoveVideo = None
        self._AudioList = None

    @property
    def Audio(self):
        r"""Audio parameter information.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        """
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Video(self):
        r"""Video parameter information.
        :rtype: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        """
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def RemoveAudio(self):
        r"""Whether to remove audio stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        r"""Whether to remove video stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def AudioList(self):
        r"""Audio parameter information list.
The parameter is only used when merging multiple audio tracks in adaptive bitrate transcoding. the maximum length of the parameter array is 64.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of AudioTemplateInfo
        """
        return self._AudioList

    @AudioList.setter
    def AudioList(self, AudioList):
        self._AudioList = AudioList


    def _deserialize(self, params):
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        if params.get("AudioList") is not None:
            self._AudioList = []
            for item in params.get("AudioList"):
                obj = AudioTemplateInfo()
                obj._deserialize(item)
                self._AudioList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOnSubtitle(AbstractModel):
    r"""The information of the subtitles to add.

    """

    def __init__(self):
        r"""
        :param _Type: The mode. Valid values:
<li>`subtitle-stream`: Add a subtitle track.</li>
<li>`close-caption-708`: Embed CEA-708 subtitles in SEI frames.</li>
<li>`close-caption-608`: Embed CEA-608 subtitles in SEI frames.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Subtitle: The subtitle file.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _SubtitleName: Subtitle name.
Note: supports Chinese characters, letters, digits, spaces, underscores (_), hyphens (-), periods (.), and parentheses. Max 64 characters.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SubtitleName: str
        :param _OutputFormat: Output format of the subtitle. valid values: "WebVTT", "TTML".
Default value: "WebVTT".
        :type OutputFormat: str
        :param _DefaultTrack: Default subtitle track. specifies the current subtitle as the default track when true. a maximum of 1 default subtitle track can be specified.
Default value: `false`.
        :type DefaultTrack: bool
        """
        self._Type = None
        self._Subtitle = None
        self._SubtitleName = None
        self._OutputFormat = None
        self._DefaultTrack = None

    @property
    def Type(self):
        r"""The mode. Valid values:
<li>`subtitle-stream`: Add a subtitle track.</li>
<li>`close-caption-708`: Embed CEA-708 subtitles in SEI frames.</li>
<li>`close-caption-608`: Embed CEA-608 subtitles in SEI frames.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        r"""The subtitle file.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def SubtitleName(self):
        r"""Subtitle name.
Note: supports Chinese characters, letters, digits, spaces, underscores (_), hyphens (-), periods (.), and parentheses. Max 64 characters.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._SubtitleName

    @SubtitleName.setter
    def SubtitleName(self, SubtitleName):
        self._SubtitleName = SubtitleName

    @property
    def OutputFormat(self):
        r"""Output format of the subtitle. valid values: "WebVTT", "TTML".
Default value: "WebVTT".
        :rtype: str
        """
        return self._OutputFormat

    @OutputFormat.setter
    def OutputFormat(self, OutputFormat):
        self._OutputFormat = OutputFormat

    @property
    def DefaultTrack(self):
        r"""Default subtitle track. specifies the current subtitle as the default track when true. a maximum of 1 default subtitle track can be specified.
Default value: `false`.
        :rtype: bool
        """
        return self._DefaultTrack

    @DefaultTrack.setter
    def DefaultTrack(self, DefaultTrack):
        self._DefaultTrack = DefaultTrack


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = MediaInputInfo()
            self._Subtitle._deserialize(params.get("Subtitle"))
        self._SubtitleName = params.get("SubtitleName")
        self._OutputFormat = params.get("OutputFormat")
        self._DefaultTrack = params.get("DefaultTrack")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdvancedSuperResolutionConfig(AbstractModel):
    r"""Super-resolution configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Capability configuration switch. Valid values:
<li>ON: enabled.</li>
<li>OFF: disabled.</li>
Default value: ON.
        :type Switch: str
        :param _Type: Type. Valid values:
<li>standard: standard super-resolution.</li>
<li>super: advanced super-resolution.</li>
Default value: standard.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Mode: Image output mode. The default value is percent.
<li>aspect: obtain a larger rectangle with specified width and height through super-resolution.</li>
<li>fixed: obtain images of fixed width and height through super-resolution, with forced scaling supported.</li>
<li>percent: magnification factor of super-resolution, which can be a decimal.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Mode: str
        :param _Percent: Magnification factor of super-resolution, which can be a decimal.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Percent: float
        :param _Width: Width of the target image. The value cannot exceed 4096.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Width: int
        :param _Height: Height of the target image. The value cannot exceed 4096.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Height: int
        """
        self._Switch = None
        self._Type = None
        self._Mode = None
        self._Percent = None
        self._Width = None
        self._Height = None

    @property
    def Switch(self):
        r"""Capability configuration switch. Valid values:
<li>ON: enabled.</li>
<li>OFF: disabled.</li>
Default value: ON.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""Type. Valid values:
<li>standard: standard super-resolution.</li>
<li>super: advanced super-resolution.</li>
Default value: standard.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Mode(self):
        r"""Image output mode. The default value is percent.
<li>aspect: obtain a larger rectangle with specified width and height through super-resolution.</li>
<li>fixed: obtain images of fixed width and height through super-resolution, with forced scaling supported.</li>
<li>percent: magnification factor of super-resolution, which can be a decimal.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Percent(self):
        r"""Magnification factor of super-resolution, which can be a decimal.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent

    @property
    def Width(self):
        r"""Width of the target image. The value cannot exceed 4096.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Height of the target image. The value cannot exceed 4096.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Mode = params.get("Mode")
        self._Percent = params.get("Percent")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    r"""Intelligent analysis results

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>Classification: smart classification.</li>
<li>Cover: smart cover.</li>
<li>Tag: smart tag.</li>
<li>FrameTag: smart frame tag.</li>
<li>Highlight: smart highlights.</li>
<li>DeLogo: smart erasing.</li>
<li>Description: LLM summary.</li>
<li>Dubbing: smart dubbing.</li>
<li>VideoRemake: video deduplication.</li>
<li>VideoComprehension: video (audio) recognition.</li>
        :type Type: str
        :param _ClassificationTask: Query result of intelligent categorization task in video content analysis, which is valid if task type is `Classification`.
        :type ClassificationTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: Query result of intelligent cover generating task in video content analysis, which is valid if task type is `Cover`.
        :type CoverTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverResult`
        :param _TagTask: Query result of intelligent tagging task in video content analysis, which is valid if task type is `Tag`.
        :type TagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: Query result of intelligent frame-specific tagging task in video content analysis, which is valid if task type is `FrameTag`.
        :type FrameTagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: The result of a highlight generation task. This parameter is valid if `Type` is `Highlight`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HighlightTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightResult`
        :param _DeLogoTask: The query result of an intelligent removal task for video analysis, which is valid when the task type is DeLogo.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DeLogoTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoResult`
        :param _SegmentTask: The query result of a splitting task for video analysis, which is valid when the task type is SegmentRecognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SegmentTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentResult`
        :param _HeadTailTask: The query result of an opening and closing segments recognition task for video analysis, which is valid when the task type is HeadTailRecognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HeadTailTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailResult`
        :param _DescriptionTask: The query result of a video analysis summarization task, which is valid when the task type is Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DescriptionTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionResult`
        :param _HorizontalToVerticalTask: The query result of a landscape-to-portrait task for video analysis, which is valid when the task type is HorizontalToVertical.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HorizontalToVerticalTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalResult`
        :param _DubbingTask: The query result of a Dubbing task for video content analysis, which is valid when the task type is Dubbing.
Note: This field may return null, indicating that no valid value can be obtained.
        :type DubbingTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingResult`
        :param _VideoRemakeTask: The query result of a video content deduplication task, which is valid when the task type is VideoRemake.
Note: This field may return null, indicating that no valid value can be obtained.
        :type VideoRemakeTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeResult`
        :param _VideoComprehensionTask: Query result of the video (audio) recognition task. This parameter is valid when the task type is VideoComprehension.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VideoComprehensionTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None
        self._DeLogoTask = None
        self._SegmentTask = None
        self._HeadTailTask = None
        self._DescriptionTask = None
        self._HorizontalToVerticalTask = None
        self._DubbingTask = None
        self._VideoRemakeTask = None
        self._VideoComprehensionTask = None

    @property
    def Type(self):
        r"""Task type. Valid values:
<li>Classification: smart classification.</li>
<li>Cover: smart cover.</li>
<li>Tag: smart tag.</li>
<li>FrameTag: smart frame tag.</li>
<li>Highlight: smart highlights.</li>
<li>DeLogo: smart erasing.</li>
<li>Description: LLM summary.</li>
<li>Dubbing: smart dubbing.</li>
<li>VideoRemake: video deduplication.</li>
<li>VideoComprehension: video (audio) recognition.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        r"""Query result of intelligent categorization task in video content analysis, which is valid if task type is `Classification`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationResult`
        """
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        r"""Query result of intelligent cover generating task in video content analysis, which is valid if task type is `Cover`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverResult`
        """
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        r"""Query result of intelligent tagging task in video content analysis, which is valid if task type is `Tag`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagResult`
        """
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        r"""Query result of intelligent frame-specific tagging task in video content analysis, which is valid if task type is `FrameTag`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagResult`
        """
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        r"""The result of a highlight generation task. This parameter is valid if `Type` is `Highlight`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightResult`
        """
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask

    @property
    def DeLogoTask(self):
        r"""The query result of an intelligent removal task for video analysis, which is valid when the task type is DeLogo.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoResult`
        """
        return self._DeLogoTask

    @DeLogoTask.setter
    def DeLogoTask(self, DeLogoTask):
        self._DeLogoTask = DeLogoTask

    @property
    def SegmentTask(self):
        r"""The query result of a splitting task for video analysis, which is valid when the task type is SegmentRecognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentResult`
        """
        return self._SegmentTask

    @SegmentTask.setter
    def SegmentTask(self, SegmentTask):
        self._SegmentTask = SegmentTask

    @property
    def HeadTailTask(self):
        r"""The query result of an opening and closing segments recognition task for video analysis, which is valid when the task type is HeadTailRecognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailResult`
        """
        return self._HeadTailTask

    @HeadTailTask.setter
    def HeadTailTask(self, HeadTailTask):
        self._HeadTailTask = HeadTailTask

    @property
    def DescriptionTask(self):
        r"""The query result of a video analysis summarization task, which is valid when the task type is Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionResult`
        """
        return self._DescriptionTask

    @DescriptionTask.setter
    def DescriptionTask(self, DescriptionTask):
        self._DescriptionTask = DescriptionTask

    @property
    def HorizontalToVerticalTask(self):
        r"""The query result of a landscape-to-portrait task for video analysis, which is valid when the task type is HorizontalToVertical.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalResult`
        """
        return self._HorizontalToVerticalTask

    @HorizontalToVerticalTask.setter
    def HorizontalToVerticalTask(self, HorizontalToVerticalTask):
        self._HorizontalToVerticalTask = HorizontalToVerticalTask

    @property
    def DubbingTask(self):
        r"""The query result of a Dubbing task for video content analysis, which is valid when the task type is Dubbing.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingResult`
        """
        return self._DubbingTask

    @DubbingTask.setter
    def DubbingTask(self, DubbingTask):
        self._DubbingTask = DubbingTask

    @property
    def VideoRemakeTask(self):
        r"""The query result of a video content deduplication task, which is valid when the task type is VideoRemake.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeResult`
        """
        return self._VideoRemakeTask

    @VideoRemakeTask.setter
    def VideoRemakeTask(self, VideoRemakeTask):
        self._VideoRemakeTask = VideoRemakeTask

    @property
    def VideoComprehensionTask(self):
        r"""Query result of the video (audio) recognition task. This parameter is valid when the task type is VideoComprehension.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionResult`
        """
        return self._VideoComprehensionTask

    @VideoComprehensionTask.setter
    def VideoComprehensionTask(self, VideoComprehensionTask):
        self._VideoComprehensionTask = VideoComprehensionTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        if params.get("DeLogoTask") is not None:
            self._DeLogoTask = AiAnalysisTaskDelLogoResult()
            self._DeLogoTask._deserialize(params.get("DeLogoTask"))
        if params.get("SegmentTask") is not None:
            self._SegmentTask = AiAnalysisTaskSegmentResult()
            self._SegmentTask._deserialize(params.get("SegmentTask"))
        if params.get("HeadTailTask") is not None:
            self._HeadTailTask = AiAnalysisTaskHeadTailResult()
            self._HeadTailTask._deserialize(params.get("HeadTailTask"))
        if params.get("DescriptionTask") is not None:
            self._DescriptionTask = AiAnalysisTaskDescriptionResult()
            self._DescriptionTask._deserialize(params.get("DescriptionTask"))
        if params.get("HorizontalToVerticalTask") is not None:
            self._HorizontalToVerticalTask = AiAnalysisTaskHorizontalToVerticalResult()
            self._HorizontalToVerticalTask._deserialize(params.get("HorizontalToVerticalTask"))
        if params.get("DubbingTask") is not None:
            self._DubbingTask = AiAnalysisTaskDubbingResult()
            self._DubbingTask._deserialize(params.get("DubbingTask"))
        if params.get("VideoRemakeTask") is not None:
            self._VideoRemakeTask = AiAnalysisTaskVideoRemakeResult()
            self._VideoRemakeTask._deserialize(params.get("VideoRemakeTask"))
        if params.get("VideoComprehensionTask") is not None:
            self._VideoComprehensionTask = AiAnalysisTaskVideoComprehensionResult()
            self._VideoComprehensionTask._deserialize(params.get("VideoComprehensionTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    r"""Input type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video categorization template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent video categorization template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    r"""Result information of intelligent categorization

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: List of intelligently generated video categories.
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        """
        self._ClassificationSet = None

    @property
    def ClassificationSet(self):
        r"""List of intelligently generated video categories.
        :rtype: list of MediaAiAnalysisClassificationItem
        """
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    r"""Result type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent categorization task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationInput`
        :param _Output: Output of intelligent categorization task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input of intelligent categorization task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of intelligent categorization task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    r"""Input type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video cover generating template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent video cover generating template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    r"""Result information of intelligent cover generating

    """

    def __init__(self):
        r"""
        :param _CoverSet: List of intelligently generated covers.
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _OutputStorage: Storage location of intelligently generated cover.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._CoverSet = None
        self._OutputStorage = None

    @property
    def CoverSet(self):
        r"""List of intelligently generated covers.
        :rtype: list of MediaAiAnalysisCoverItem
        """
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def OutputStorage(self):
        r"""Storage location of intelligently generated cover.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    r"""Result type of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent cover generating task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverInput`
        :param _Output: Output of intelligent cover generating task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input of intelligent cover generating task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of intelligent cover generating task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoInput(AbstractModel):
    r"""Intelligent removal task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent removal template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent removal template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoOutput(AbstractModel):
    r"""Intelligent removal result.

    """

    def __init__(self):
        r"""
        :param _Path: Path of a file after removal.
        :type Path: str
        :param _OutputStorage: Storage location of a file after removal.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OriginSubtitlePath: Path of a subtitle file extracted from a video.
        :type OriginSubtitlePath: str
        :param _TranslateSubtitlePath: Path of a subtitle translation file extracted from a video.
        :type TranslateSubtitlePath: str
        :param _SubtitlePos: Position of the erased subtitle. Note: This field is only valid for subtitle extraction when the option to return subtitle positions is enabled.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SubtitlePos: :class:`tencentcloud.mps.v20190612.models.SubtitlePosition`
        :param _VoiceClonedVideo: Specifies the file url of the video after voice cloning.
Note: This field may return null, indicating that no valid value can be obtained.
        :type VoiceClonedVideo: str
        :param _VoiceClonedMarkFile: Specifies the file address of the voice type clone annotation.
Note: This field may return null, indicating that no valid value can be obtained.
        :type VoiceClonedMarkFile: str
        """
        self._Path = None
        self._OutputStorage = None
        self._OriginSubtitlePath = None
        self._TranslateSubtitlePath = None
        self._SubtitlePos = None
        self._VoiceClonedVideo = None
        self._VoiceClonedMarkFile = None

    @property
    def Path(self):
        r"""Path of a file after removal.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""Storage location of a file after removal.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OriginSubtitlePath(self):
        r"""Path of a subtitle file extracted from a video.
        :rtype: str
        """
        return self._OriginSubtitlePath

    @OriginSubtitlePath.setter
    def OriginSubtitlePath(self, OriginSubtitlePath):
        self._OriginSubtitlePath = OriginSubtitlePath

    @property
    def TranslateSubtitlePath(self):
        r"""Path of a subtitle translation file extracted from a video.
        :rtype: str
        """
        return self._TranslateSubtitlePath

    @TranslateSubtitlePath.setter
    def TranslateSubtitlePath(self, TranslateSubtitlePath):
        self._TranslateSubtitlePath = TranslateSubtitlePath

    @property
    def SubtitlePos(self):
        r"""Position of the erased subtitle. Note: This field is only valid for subtitle extraction when the option to return subtitle positions is enabled.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SubtitlePosition`
        """
        return self._SubtitlePos

    @SubtitlePos.setter
    def SubtitlePos(self, SubtitlePos):
        self._SubtitlePos = SubtitlePos

    @property
    def VoiceClonedVideo(self):
        r"""Specifies the file url of the video after voice cloning.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._VoiceClonedVideo

    @VoiceClonedVideo.setter
    def VoiceClonedVideo(self, VoiceClonedVideo):
        self._VoiceClonedVideo = VoiceClonedVideo

    @property
    def VoiceClonedMarkFile(self):
        r"""Specifies the file address of the voice type clone annotation.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._VoiceClonedMarkFile

    @VoiceClonedMarkFile.setter
    def VoiceClonedMarkFile(self, VoiceClonedMarkFile):
        self._VoiceClonedMarkFile = VoiceClonedMarkFile


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OriginSubtitlePath = params.get("OriginSubtitlePath")
        self._TranslateSubtitlePath = params.get("TranslateSubtitlePath")
        if params.get("SubtitlePos") is not None:
            self._SubtitlePos = SubtitlePosition()
            self._SubtitlePos._deserialize(params.get("SubtitlePos"))
        self._VoiceClonedVideo = params.get("VoiceClonedVideo")
        self._VoiceClonedMarkFile = params.get("VoiceClonedMarkFile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoResult(AbstractModel):
    r"""Intelligent removal result type.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
        :type Status: str
        :param _ErrCode: Error code. `0`: Task successful. Other values: Task failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Intelligent removal task input.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoInput`
        :param _Output: Intelligent removal task output.Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: Task successful. Other values: Task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Intelligent removal task input.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Intelligent removal task output.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDelLogoInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDelLogoOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionInput(AbstractModel):
    r"""Intelligent classification task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent description template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent description template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionOutput(AbstractModel):
    r"""Intelligent description result information.

    """

    def __init__(self):
        r"""
        :param _DescriptionSet: Intelligent video description list.
        :type DescriptionSet: list of MediaAiAnalysisDescriptionItem
        """
        self._DescriptionSet = None

    @property
    def DescriptionSet(self):
        r"""Intelligent video description list.
        :rtype: list of MediaAiAnalysisDescriptionItem
        """
        return self._DescriptionSet

    @DescriptionSet.setter
    def DescriptionSet(self, DescriptionSet):
        self._DescriptionSet = DescriptionSet


    def _deserialize(self, params):
        if params.get("DescriptionSet") is not None:
            self._DescriptionSet = []
            for item in params.get("DescriptionSet"):
                obj = MediaAiAnalysisDescriptionItem()
                obj._deserialize(item)
                self._DescriptionSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionResult(AbstractModel):
    r"""Intelligent description result type.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
        :type Status: str
        :param _ErrCode: Error code. `0`: Task successful. Other values: Task failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Intelligent description task input.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionInput`
        :param _Output: Intelligent description task output.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: Task successful. Other values: Task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Intelligent description task input.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Intelligent description task output.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDescriptionInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDescriptionOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDubbingInput(AbstractModel):
    r"""Intelligent translation task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Video translation template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Video translation template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDubbingOutput(AbstractModel):
    r"""Intelligent translation result information.

    """

    def __init__(self):
        r"""
        :param _VideoPath: Specifies the video path for translation.
        :type VideoPath: str
        :param _SpeakerPath: Specifies the file path of the tag.

        :type SpeakerPath: str
        :param _OutputStorage: Specifies the storage location of the transcoded video.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._VideoPath = None
        self._SpeakerPath = None
        self._OutputStorage = None

    @property
    def VideoPath(self):
        r"""Specifies the video path for translation.
        :rtype: str
        """
        return self._VideoPath

    @VideoPath.setter
    def VideoPath(self, VideoPath):
        self._VideoPath = VideoPath

    @property
    def SpeakerPath(self):
        r"""Specifies the file path of the tag.

        :rtype: str
        """
        return self._SpeakerPath

    @SpeakerPath.setter
    def SpeakerPath(self, SpeakerPath):
        self._SpeakerPath = SpeakerPath

    @property
    def OutputStorage(self):
        r"""Specifies the storage location of the transcoded video.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        self._VideoPath = params.get("VideoPath")
        self._SpeakerPath = params.get("SpeakerPath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDubbingResult(AbstractModel):
    r"""Intelligent translation result type.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
        :type Status: str
        :param _ErrCode: Error code. `0`: Task successful. Other values: Task failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Describes the task input for intelligent translation.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingInput`
        :param _Output: Describes the task output of intelligent translation.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: Task successful. Other values: Task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Describes the task input for intelligent translation.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Describes the task output of intelligent translation.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDubbingOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDubbingInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDubbingOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    r"""Input type of intelligent frame-specific tagging task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent frame-specific video tagging template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent frame-specific video tagging template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    r"""Result information of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of frame-specific video tags.
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        r"""List of frame-specific video tags.
        :rtype: list of MediaAiAnalysisFrameTagSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    r"""Result type of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent frame-specific tagging task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagInput`
        :param _Output: Output of intelligent frame-specific tagging task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input of intelligent frame-specific tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of intelligent frame-specific tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailInput(AbstractModel):
    r"""Opening and closing segments recognition task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Opening and closing segments recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Opening and closing segments recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailOutput(AbstractModel):
    r"""Opening and closing segments recognition result.

    """

    def __init__(self):
        r"""
        :param _HeadTimeOffset: Opening segment PTS.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HeadTimeOffset: float
        :param _TailTimeOffset: Closing segment PTS.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TailTimeOffset: float
        """
        self._HeadTimeOffset = None
        self._TailTimeOffset = None

    @property
    def HeadTimeOffset(self):
        r"""Opening segment PTS.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._HeadTimeOffset

    @HeadTimeOffset.setter
    def HeadTimeOffset(self, HeadTimeOffset):
        self._HeadTimeOffset = HeadTimeOffset

    @property
    def TailTimeOffset(self):
        r"""Closing segment PTS.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._TailTimeOffset

    @TailTimeOffset.setter
    def TailTimeOffset(self, TailTimeOffset):
        self._TailTimeOffset = TailTimeOffset


    def _deserialize(self, params):
        self._HeadTimeOffset = params.get("HeadTimeOffset")
        self._TailTimeOffset = params.get("TailTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailResult(AbstractModel):
    r"""Opening and closing segments recognition result type.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
        :type Status: str
        :param _ErrCode: Error code. `0`: Task successful. Other values: Task failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Opening and closing segments recognition task input.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailInput`
        :param _Output: Opening and closing segments recognition task output.Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: Task successful. Other values: Task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Opening and closing segments recognition task input.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Opening and closing segments recognition task output.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHeadTailInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHeadTailOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    r"""The input of an intelligent highlight generation task.

    """

    def __init__(self):
        r"""
        :param _Definition: The ID of the intelligent highlight generation template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The ID of the intelligent highlight generation template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    r"""The output of an intelligent highlight generation task.

    """

    def __init__(self):
        r"""
        :param _HighlightSet: A list of the highlight segments generated.
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _OutputStorage: The storage location of the highlight segments.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._HighlightSet = None
        self._OutputStorage = None

    @property
    def HighlightSet(self):
        r"""A list of the highlight segments generated.
        :rtype: list of MediaAiAnalysisHighlightItem
        """
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def OutputStorage(self):
        r"""The storage location of the highlight segments.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    r"""The result of an intelligent highlight generation task.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: `PROCESSING`, `SUCCESS`, `FAIL`.
        :type Status: str
        :param _ErrCode: Error code. `0`: The task succeeded; other values: The task failed.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the intelligent highlight generation task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightInput`
        :param _Output: The output of the intelligent highlight generation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""The task status. Valid values: `PROCESSING`, `SUCCESS`, `FAIL`.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: The task succeeded; other values: The task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""The error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input of the intelligent highlight generation task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of the intelligent highlight generation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHorizontalToVerticalInput(AbstractModel):
    r"""Intelligent landscape-to-portrait task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent landscape-to-portrait template ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent landscape-to-portrait template ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHorizontalToVerticalOutput(AbstractModel):
    r"""Intelligent landscape-to-portrait result.

    """

    def __init__(self):
        r"""
        :param _Path: Intelligent landscape-to-portrait video list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        :param _OutputStorage: Storage location of intelligent landscape-to-portrait videos.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Confidence: Confidence.	
	
Note: This field may return null, indicating that no valid values can be obtained.
        :type Confidence: float
        """
        self._Path = None
        self._OutputStorage = None
        self._Confidence = None

    @property
    def Path(self):
        r"""Intelligent landscape-to-portrait video list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""Storage location of intelligent landscape-to-portrait videos.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def Confidence(self):
        r"""Confidence.	
	
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHorizontalToVerticalResult(AbstractModel):
    r"""Intelligent landscape-to-portrait result type.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param _ErrCode: Error code. 0: Task successful. Other values: Task failed.

Note: This field may return null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: Error message

Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Intelligent landscape-to-portrait task input.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalInput`
        :param _Output: Intelligent landscape-to-portrait task output.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. 0: Task successful. Other values: Task failed.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Intelligent landscape-to-portrait task input.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Intelligent landscape-to-portrait task output.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHorizontalToVerticalOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHorizontalToVerticalInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHorizontalToVerticalOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    r"""AI video intelligent analysis input parameter types

    """

    def __init__(self):
        r"""
        :param _Definition: Video content analysis template ID.
        :type Definition: int
        :param _ExtendedParameter: Additional parameter. Its value is a serialized JSON string.
Note: This parameter is used to meet customization requirements. References:
[Smart Erase Tutorial]: https://intl.cloud.tencent.com/document/product/862/101530?from_cn_redirect=1
[Video Splitting (Long Videos to Short Videos) Tutorial](https://intl.cloud.tencent.com/document/product/862/112098?from_cn_redirect=1)
[Intelligent Highlights Tutorial](https://intl.cloud.tencent.com/document/product/862/107280?from_cn_redirect=1)
[Horizontal-to-Vertical Video Transformation Tutorial](https://intl.cloud.tencent.com/document/product/862/112112?from_cn_redirect=1)
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtendedParameter: str
        """
        self._Definition = None
        self._ExtendedParameter = None

    @property
    def Definition(self):
        r"""Video content analysis template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ExtendedParameter(self):
        r"""Additional parameter. Its value is a serialized JSON string.
Note: This parameter is used to meet customization requirements. References:
[Smart Erase Tutorial]: https://intl.cloud.tencent.com/document/product/862/101530?from_cn_redirect=1
[Video Splitting (Long Videos to Short Videos) Tutorial](https://intl.cloud.tencent.com/document/product/862/112098?from_cn_redirect=1)
[Intelligent Highlights Tutorial](https://intl.cloud.tencent.com/document/product/862/107280?from_cn_redirect=1)
[Horizontal-to-Vertical Video Transformation Tutorial](https://intl.cloud.tencent.com/document/product/862/112112?from_cn_redirect=1)
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._ExtendedParameter

    @ExtendedParameter.setter
    def ExtendedParameter(self, ExtendedParameter):
        self._ExtendedParameter = ExtendedParameter


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ExtendedParameter = params.get("ExtendedParameter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentInput(AbstractModel):
    r"""Splitting task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Splitting task template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Splitting task template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentOutput(AbstractModel):
    r"""Intelligent splitting result.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: Intelligent splitting sub-segment list.
        :type SegmentSet: list of SegmentRecognitionItem
        :param _Abstract: Video abstract, used for offline scenarios.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Abstract: str
        """
        self._SegmentSet = None
        self._Abstract = None

    @property
    def SegmentSet(self):
        r"""Intelligent splitting sub-segment list.
        :rtype: list of SegmentRecognitionItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def Abstract(self):
        r"""Video abstract, used for offline scenarios.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Abstract

    @Abstract.setter
    def Abstract(self, Abstract):
        self._Abstract = Abstract


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = SegmentRecognitionItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._Abstract = params.get("Abstract")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentResult(AbstractModel):
    r"""Splitting result type.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
        :type Status: str
        :param _ErrCode: Error code. `0`: Task successful. Other values: Task failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Splitting task input.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentInput`
        :param _Output: Splitting task output.Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: Task successful. Other values: Task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Splitting task input.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Splitting task output.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskSegmentInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskSegmentOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    r"""Input type of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video tagging template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent video tagging template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    r"""Result information of intelligent tagging

    """

    def __init__(self):
        r"""
        :param _TagSet: List of intelligently generated video tags.
        :type TagSet: list of MediaAiAnalysisTagItem
        """
        self._TagSet = None

    @property
    def TagSet(self):
        r"""List of intelligently generated video tags.
        :rtype: list of MediaAiAnalysisTagItem
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    r"""Result type of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent tagging task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagInput`
        :param _Output: Output of intelligent tagging task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input of intelligent tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of intelligent tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoComprehensionInput(AbstractModel):
    r"""Input file for the video (audio) recognition task.

    """

    def __init__(self):
        r"""
        :param _Definition: Video (audio) recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Video (audio) recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoComprehensionOutput(AbstractModel):
    r"""Information about the video (audio) recognition output content result.

    """

    def __init__(self):
        r"""
        :param _VideoComprehensionAnalysisResult: Details of the video (audio) recognition output content.
        :type VideoComprehensionAnalysisResult: str
        """
        self._VideoComprehensionAnalysisResult = None

    @property
    def VideoComprehensionAnalysisResult(self):
        r"""Details of the video (audio) recognition output content.
        :rtype: str
        """
        return self._VideoComprehensionAnalysisResult

    @VideoComprehensionAnalysisResult.setter
    def VideoComprehensionAnalysisResult(self, VideoComprehensionAnalysisResult):
        self._VideoComprehensionAnalysisResult = VideoComprehensionAnalysisResult


    def _deserialize(self, params):
        self._VideoComprehensionAnalysisResult = params.get("VideoComprehensionAnalysisResult")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoComprehensionResult(AbstractModel):
    r"""Video (audio) recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: `PROCESSING`, `SUCCESS`, and `FAIL`.
        :type Status: str
        :param _ErrCode: Error code. 0: successful; other values: failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input file for video (audio) recognition.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionInput`
        :param _Output: Output file for video (audio) recognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionOutput`
        :param _ErrCodeExt: Error code. A null string indicates that the task is successful, while other values indicate that the task has failed. For valid values, see the list of MPS error codes.
        :type ErrCodeExt: str
        :param _Progress: Task progress
        :type Progress: int
        :param _BeginProcessTime: Starting time of task execution, in ISO date and time format.
        :type BeginProcessTime: str
        :param _FinishTime: Completion time of task execution, in ISO date and time format.
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._ErrCodeExt = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        r"""Task status. Valid values: `PROCESSING`, `SUCCESS`, and `FAIL`.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. 0: successful; other values: failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input file for video (audio) recognition.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output file for video (audio) recognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoComprehensionOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def ErrCodeExt(self):
        r"""Error code. A null string indicates that the task is successful, while other values indicate that the task has failed. For valid values, see the list of MPS error codes.
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Progress(self):
        r"""Task progress
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        r"""Starting time of task execution, in ISO date and time format.
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""Completion time of task execution, in ISO date and time format.
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskVideoComprehensionInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskVideoComprehensionOutput()
            self._Output._deserialize(params.get("Output"))
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoRemakeInput(AbstractModel):
    r"""Video deduplication task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent deduplication template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Intelligent deduplication template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoRemakeOutput(AbstractModel):
    r"""Video deduplication result information.

    """

    def __init__(self):
        r"""
        :param _Path: Specifies the file path for intelligent video deduplication.
        :type Path: str
        :param _OutputStorage: Specifies the storage location for intelligent video deduplication.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Path = None
        self._OutputStorage = None

    @property
    def Path(self):
        r"""Specifies the file path for intelligent video deduplication.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        r"""Specifies the storage location for intelligent video deduplication.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskVideoRemakeResult(AbstractModel):
    r"""Video deduplication result data structure.

    """

    def __init__(self):
        r"""
        :param _Status: Specifies the task status. valid values: `PROCESSING`, `SUCCESS`, and `FAIL`.
        :type Status: str
        :param _ErrCode: Error code. 0: success. other values: failure.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Deduplication task input.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeInput`
        :param _Output: Task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Specifies the task status. valid values: `PROCESSING`, `SUCCESS`, and `FAIL`.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. 0: success. other values: failure.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Deduplication task input.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Task output.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskVideoRemakeOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskVideoRemakeInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskVideoRemakeOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    r"""Content audit result

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>Porn (in images)</li>
<li>Terrorism (in images)</li>
<li>Political (in images)</li>
<li>Porn.Asr</li>
<li>Porn.Ocr</li>
<li>Political.Asr</li>
<li>Political.Ocr</li>
<li>Terrorism.Ocr</li>
<li>Prohibited.Asr</li>
<li>Prohibited.Ocr</li>
        :type Type: str
        :param _SampleRate: Sample rate, which indicates the number of video frames captured per second for audit
        :type SampleRate: float
        :param _Duration: Audited video duration in seconds.
        :type Duration: float
        :param _PornTask: Query result of an intelligent porn information detection in image task in video content audit, which is valid when task type is `Porn`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornResult`
        :param _TerrorismTask: The result of detecting terrorism content in images, which is valid when the task type is `Terrorism`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TerrorismTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: The result of detecting politically sensitive information in images, which is valid when the task type is `Political`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: Query result of an ASR-based porn information detection in text task in video content audit, which is valid when task type is `Porn.Asr`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: Query result of an OCR-based porn information detection in text task in video content audit, which is valid when task type is `Porn.Ocr`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: The result of detecting politically sensitive information based on ASR, which is valid when the task type is `Political.Asr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: The result of detecting politically sensitive information based on OCR, which is valid when the task type is `Political.Ocr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: The result of detecting terrorism content based on OCR, which is valid when task type is `Terrorism.Ocr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TerrorismOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedAsrTask: Query result of ASR-based prohibited information detection in speech task in video content audit, which is valid if task type is `Prohibited.Asr`.
        :type ProhibitedAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedAsrResult`
        :param _ProhibitedOcrTask: Query result of OCR-based prohibited information detection in text task in video content audit, which is valid if task type is `Prohibited.Ocr`.
        :type ProhibitedOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedOcrResult`
        """
        self._Type = None
        self._SampleRate = None
        self._Duration = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedAsrTask = None
        self._ProhibitedOcrTask = None

    @property
    def Type(self):
        r"""Task type. Valid values:
<li>Porn (in images)</li>
<li>Terrorism (in images)</li>
<li>Political (in images)</li>
<li>Porn.Asr</li>
<li>Porn.Ocr</li>
<li>Political.Asr</li>
<li>Political.Ocr</li>
<li>Terrorism.Ocr</li>
<li>Prohibited.Asr</li>
<li>Prohibited.Ocr</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SampleRate(self):
        r"""Sample rate, which indicates the number of video frames captured per second for audit
        :rtype: float
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def Duration(self):
        r"""Audited video duration in seconds.
        :rtype: float
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def PornTask(self):
        r"""Query result of an intelligent porn information detection in image task in video content audit, which is valid when task type is `Porn`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornResult`
        """
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        r"""The result of detecting terrorism content in images, which is valid when the task type is `Terrorism`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismResult`
        """
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        r"""The result of detecting politically sensitive information in images, which is valid when the task type is `Political`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalResult`
        """
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        r"""Query result of an ASR-based porn information detection in text task in video content audit, which is valid when task type is `Porn.Asr`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornAsrResult`
        """
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        r"""Query result of an OCR-based porn information detection in text task in video content audit, which is valid when task type is `Porn.Ocr`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornOcrResult`
        """
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        r"""The result of detecting politically sensitive information based on ASR, which is valid when the task type is `Political.Asr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalAsrResult`
        """
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        r"""The result of detecting politically sensitive information based on OCR, which is valid when the task type is `Political.Ocr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalOcrResult`
        """
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        r"""The result of detecting terrorism content based on OCR, which is valid when task type is `Terrorism.Ocr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismOcrResult`
        """
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedAsrTask(self):
        r"""Query result of ASR-based prohibited information detection in speech task in video content audit, which is valid if task type is `Prohibited.Asr`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedAsrResult`
        """
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask

    @property
    def ProhibitedOcrTask(self):
        r"""Query result of OCR-based prohibited information detection in text task in video content audit, which is valid if task type is `Prohibited.Ocr`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedOcrResult`
        """
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SampleRate = params.get("SampleRate")
        self._Duration = params.get("Duration")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    r"""Task type of intelligent content audit

    """

    def __init__(self):
        r"""
        :param _Definition: Video content audit template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Video content audit template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiParagraphInfo(AbstractModel):
    r"""Segment information.

    """

    def __init__(self):
        r"""
        :param _Summary: Segment summary.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Summary: str
        :param _Title: Segment title.
        :type Title: str
        :param _Keywords: Segment keywords.
        :type Keywords: list of str
        :param _StartTimeOffset: Segmentation start time point, in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTimeOffset: float
        :param _EndTimeOffset: Segmentation end time point, in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTimeOffset: float
        """
        self._Summary = None
        self._Title = None
        self._Keywords = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Summary(self):
        r"""Segment summary.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Summary

    @Summary.setter
    def Summary(self, Summary):
        self._Summary = Summary

    @property
    def Title(self):
        r"""Segment title.
        :rtype: str
        """
        return self._Title

    @Title.setter
    def Title(self, Title):
        self._Title = Title

    @property
    def Keywords(self):
        r"""Segment keywords.
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def StartTimeOffset(self):
        r"""Segmentation start time point, in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""Segmentation end time point, in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Summary = params.get("Summary")
        self._Title = params.get("Title")
        self._Keywords = params.get("Keywords")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiQualityControlTaskInput(AbstractModel):
    r"""Input parameter type for media quality inspection.

    """

    def __init__(self):
        r"""
        :param _Definition: Media quality inspection template ID.
You can directly use a preset template or customize a template in the console. The preset templates are as follows:
- 10: Enable all quality inspection items.
- 20: Only enable quality inspection items corresponding to format diagnosis.
- 30: Only enable quality inspection items corresponding to no-reference scoring.
- 40: Only enable quality inspection items corresponding to screen quality.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Definition: int
        :param _ChannelExtPara: The channel extension parameter, which is a serialized JSON string.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ChannelExtPara: str
        """
        self._Definition = None
        self._ChannelExtPara = None

    @property
    def Definition(self):
        r"""Media quality inspection template ID.
You can directly use a preset template or customize a template in the console. The preset templates are as follows:
- 10: Enable all quality inspection items.
- 20: Only enable quality inspection items corresponding to format diagnosis.
- 30: Only enable quality inspection items corresponding to no-reference scoring.
- 40: Only enable quality inspection items corresponding to screen quality.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ChannelExtPara(self):
        r"""The channel extension parameter, which is a serialized JSON string.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChannelExtPara

    @ChannelExtPara.setter
    def ChannelExtPara(self, ChannelExtPara):
        self._ChannelExtPara = ChannelExtPara


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ChannelExtPara = params.get("ChannelExtPara")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    r"""Intelligent recognition result.

    """

    def __init__(self):
        r"""
        :param _Type: The task type. Valid values:
<li>FaceRecognition: Face recognition</li>
<li>AsrWordsRecognition: Speech keyword recognition</li>
<li>OcrWordsRecognition: Text keyword recognition</li>
<li>AsrFullTextRecognition: Full speech recognition</li>
<li>OcrFullTextRecognition: Full text recognition</li>
<li>TransTextRecognition: Speech translation</li>
        :type Type: str
        :param _FaceTask: Face recognition result, which is valid when `Type` is 
 `FaceRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FaceTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: Speech keyword recognition result, which is valid when `Type` is
 `AsrWordsRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: Full speech recognition result, which is valid when `Type` is
 `AsrFullTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResult`
        :param _OcrWordsTask: Text keyword recognition result, which is valid when `Type` is
 `OcrWordsRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: Full text recognition result, which is valid when `Type` is
 `OcrFullTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResult`
        :param _TransTextTask: The translation result. This parameter is valid only if `Type` is
 `TransTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResult`
        :param _ObjectTask: Object recognition result, which is valid when Type is

ObjectRecognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ObjectTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResult`
        """
        self._Type = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._TransTextTask = None
        self._ObjectTask = None

    @property
    def Type(self):
        r"""The task type. Valid values:
<li>FaceRecognition: Face recognition</li>
<li>AsrWordsRecognition: Speech keyword recognition</li>
<li>OcrWordsRecognition: Text keyword recognition</li>
<li>AsrFullTextRecognition: Full speech recognition</li>
<li>OcrFullTextRecognition: Full text recognition</li>
<li>TransTextRecognition: Speech translation</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceTask(self):
        r"""Face recognition result, which is valid when `Type` is 
 `FaceRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResult`
        """
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        r"""Speech keyword recognition result, which is valid when `Type` is
 `AsrWordsRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResult`
        """
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        r"""Full speech recognition result, which is valid when `Type` is
 `AsrFullTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResult`
        """
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def OcrWordsTask(self):
        r"""Text keyword recognition result, which is valid when `Type` is
 `OcrWordsRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResult`
        """
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        r"""Full text recognition result, which is valid when `Type` is
 `OcrFullTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResult`
        """
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def TransTextTask(self):
        r"""The translation result. This parameter is valid only if `Type` is
 `TransTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResult`
        """
        return self._TransTextTask

    @TransTextTask.setter
    def TransTextTask(self, TransTextTask):
        self._TransTextTask = TransTextTask

    @property
    def ObjectTask(self):
        r"""Object recognition result, which is valid when Type is

ObjectRecognition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResult`
        """
        return self._ObjectTask

    @ObjectTask.setter
    def ObjectTask(self, ObjectTask):
        self._ObjectTask = ObjectTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("TransTextTask") is not None:
            self._TransTextTask = AiRecognitionTaskTransTextResult()
            self._TransTextTask._deserialize(params.get("TransTextTask"))
        if params.get("ObjectTask") is not None:
            self._ObjectTask = AiRecognitionTaskObjectResult()
            self._ObjectTask._deserialize(params.get("ObjectTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    r"""Full speech recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a full speech recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: Output information of a full speech recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultOutput`
        :param _Progress: Task progress.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input information of a full speech recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output information of a full speech recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""Task progress.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    r"""Input for full speech recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Full speech recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Full speech recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    r"""Full speech recognition result.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of full speech recognition segments.
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SubtitlePath: Subtitles file address.
        :type SubtitlePath: str
        :param _OutputStorage: Subtitles file storage location.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._SegmentSet = None
        self._SubtitlePath = None
        self._OutputStorage = None

    @property
    def SegmentSet(self):
        r"""List of full speech recognition segments.
        :rtype: list of AiRecognitionTaskAsrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        r"""Subtitles file address.
        :rtype: str
        """
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath

    @property
    def OutputStorage(self):
        warnings.warn("parameter `OutputStorage` is deprecated", DeprecationWarning) 

        r"""Subtitles file storage location.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        warnings.warn("parameter `OutputStorage` is deprecated", DeprecationWarning) 

        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    r"""Full speech recognition segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Text: Recognized text.
        :type Text: str
        :param _Wordlist: Word timestamp information.
        :type Wordlist: list of WordResult
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Wordlist = None

    @property
    def Confidence(self):
        r"""Confidence of a recognition segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""Start time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        r"""Recognized text.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Wordlist(self):
        r"""Word timestamp information.
        :rtype: list of WordResult
        """
        return self._Wordlist

    @Wordlist.setter
    def Wordlist(self, Wordlist):
        self._Wordlist = Wordlist


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        if params.get("Wordlist") is not None:
            self._Wordlist = []
            for item in params.get("Wordlist"):
                obj = WordResult()
                obj._deserialize(item)
                self._Wordlist.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    r"""Speech keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a speech keyword recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: Output information of a speech keyword recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input information of a speech keyword recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output information of a speech keyword recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    r"""Input for speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Speech keyword recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Speech keyword recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    r"""Speech keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Word: Speech keyword.
        :type Word: str
        :param _SegmentSet: List of time segments that contain the speech keyword.
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        r"""Speech keyword.
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        r"""List of time segments that contain the speech keyword.
        :rtype: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    r"""Output of speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Speech keyword recognition result set.
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""Speech keyword recognition result set.
        :rtype: list of AiRecognitionTaskAsrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    r"""Speech recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        r"""Start time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""Confidence of a recognition segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    r"""Face recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a face recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultInput`
        :param _Output: Output information of a face recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input information of a face recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output information of a face recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    r"""Face recognition input.

    """

    def __init__(self):
        r"""
        :param _Definition: Face recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Face recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    r"""Face recognition result

    """

    def __init__(self):
        r"""
        :param _Id: Unique ID of a figure.
        :type Id: str
        :param _Type: Figure library type, indicating to which figure library the recognized figure belongs:
<li>Default: Default figure library;</li>
<li>UserDefine: Custom figure library.</li>
        :type Type: str
        :param _Name: Name of a figure.
        :type Name: str
        :param _SegmentSet: Result set of segments that contain a figure.
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        :param _Gender: Gender of the person.
<Li>Male: man.</li>.
<Li>Female: specifies the woman.</li>.
        :type Gender: str
        :param _Birthday: Date of birth.
        :type Birthday: str
        :param _Profession: Occupation or position of a person.
        :type Profession: str
        :param _SchoolOfGraduation: Specifies the graduation institution of the person.
        :type SchoolOfGraduation: str
        :param _Abstract: Description of the person.
        :type Abstract: str
        :param _PlaceOfBirth: Specifies the birthplace or place of origin.
        :type PlaceOfBirth: str
        :param _PersonType: Person type.
<Li>Politician: specifies the official.</li>.
<Li>Artist: specifies the artist.</li>.
        :type PersonType: str
        :param _Remark: Sensitivity labeling.
<Li>Normal: specifies the scaling group is normal.</li>.
<Li>Sensitive: specifies sensitivity.</li>.
        :type Remark: str
        :param _Url: Specifies the screenshot link.
        :type Url: str
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None
        self._Gender = None
        self._Birthday = None
        self._Profession = None
        self._SchoolOfGraduation = None
        self._Abstract = None
        self._PlaceOfBirth = None
        self._PersonType = None
        self._Remark = None
        self._Url = None

    @property
    def Id(self):
        r"""Unique ID of a figure.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        r"""Figure library type, indicating to which figure library the recognized figure belongs:
<li>Default: Default figure library;</li>
<li>UserDefine: Custom figure library.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Name of a figure.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        r"""Result set of segments that contain a figure.
        :rtype: list of AiRecognitionTaskFaceSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def Gender(self):
        r"""Gender of the person.
<Li>Male: man.</li>.
<Li>Female: specifies the woman.</li>.
        :rtype: str
        """
        return self._Gender

    @Gender.setter
    def Gender(self, Gender):
        self._Gender = Gender

    @property
    def Birthday(self):
        r"""Date of birth.
        :rtype: str
        """
        return self._Birthday

    @Birthday.setter
    def Birthday(self, Birthday):
        self._Birthday = Birthday

    @property
    def Profession(self):
        r"""Occupation or position of a person.
        :rtype: str
        """
        return self._Profession

    @Profession.setter
    def Profession(self, Profession):
        self._Profession = Profession

    @property
    def SchoolOfGraduation(self):
        r"""Specifies the graduation institution of the person.
        :rtype: str
        """
        return self._SchoolOfGraduation

    @SchoolOfGraduation.setter
    def SchoolOfGraduation(self, SchoolOfGraduation):
        self._SchoolOfGraduation = SchoolOfGraduation

    @property
    def Abstract(self):
        r"""Description of the person.
        :rtype: str
        """
        return self._Abstract

    @Abstract.setter
    def Abstract(self, Abstract):
        self._Abstract = Abstract

    @property
    def PlaceOfBirth(self):
        r"""Specifies the birthplace or place of origin.
        :rtype: str
        """
        return self._PlaceOfBirth

    @PlaceOfBirth.setter
    def PlaceOfBirth(self, PlaceOfBirth):
        self._PlaceOfBirth = PlaceOfBirth

    @property
    def PersonType(self):
        r"""Person type.
<Li>Politician: specifies the official.</li>.
<Li>Artist: specifies the artist.</li>.
        :rtype: str
        """
        return self._PersonType

    @PersonType.setter
    def PersonType(self, PersonType):
        self._PersonType = PersonType

    @property
    def Remark(self):
        r"""Sensitivity labeling.
<Li>Normal: specifies the scaling group is normal.</li>.
<Li>Sensitive: specifies sensitivity.</li>.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Url(self):
        r"""Specifies the screenshot link.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._Gender = params.get("Gender")
        self._Birthday = params.get("Birthday")
        self._Profession = params.get("Profession")
        self._SchoolOfGraduation = params.get("SchoolOfGraduation")
        self._Abstract = params.get("Abstract")
        self._PlaceOfBirth = params.get("PlaceOfBirth")
        self._PersonType = params.get("PersonType")
        self._Remark = params.get("Remark")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    r"""Output of intelligent face recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Intelligent face recognition result set.
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""Intelligent face recognition result set.
        :rtype: list of AiRecognitionTaskFaceResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    r"""Face recognition result segment

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""Start time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""Confidence of a recognition segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    r"""Input parameter type of video content recognition

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video recognition template ID.
        :type Definition: int
        :param _UserExtPara: User extension field, which does not need to be filled in for general scenarios.
        :type UserExtPara: str
        """
        self._Definition = None
        self._UserExtPara = None

    @property
    def Definition(self):
        r"""Intelligent video recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def UserExtPara(self):
        r"""User extension field, which does not need to be filled in for general scenarios.
        :rtype: str
        """
        return self._UserExtPara

    @UserExtPara.setter
    def UserExtPara(self, UserExtPara):
        self._UserExtPara = UserExtPara


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._UserExtPara = params.get("UserExtPara")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResult(AbstractModel):
    r"""Object recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status, including PROCESSING, SUCCESS, and FAIL.
        :type Status: str
        :param _ErrCode: Error code. `0`: Task successful. Other values: Task failed.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Object recognition task input.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultInput`
        :param _Output: Object recognition task output.Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status, including PROCESSING, SUCCESS, and FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code. `0`: Task successful. Other values: Task failed.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Object recognition task input.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Object recognition task output.Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskObjectResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskObjectResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultInput(AbstractModel):
    r"""Object recognition task input type.

    """

    def __init__(self):
        r"""
        :param _Definition: Object recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Object recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultItem(AbstractModel):
    r"""Single object recognition result.

    """

    def __init__(self):
        r"""
        :param _Name: Name of a recognized object.
        :type Name: str
        :param _SegmentSet: List of segments that contain the object.
        :type SegmentSet: list of AiRecognitionTaskObjectSeqmentItem
        """
        self._Name = None
        self._SegmentSet = None

    @property
    def Name(self):
        r"""Name of a recognized object.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        r"""List of segments that contain the object.
        :rtype: list of AiRecognitionTaskObjectSeqmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskObjectSeqmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultOutput(AbstractModel):
    r"""Intelligent object recognition output.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Intelligent object recognition result set.
        :type ResultSet: list of AiRecognitionTaskObjectResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""Intelligent object recognition result set.
        :rtype: list of AiRecognitionTaskObjectResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskObjectResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSeqmentItem(AbstractModel):
    r"""Object recognition result segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognized segment, in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognized segment, in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognized segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of the recognition result. An array contains four elements: [x1, y1, x2, y2], representing the horizontal and vertical coordinates of the top-left and bottom-right corners, respectively.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""Start time offset of a recognized segment, in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time offset of a recognized segment, in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""Confidence of a recognized segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""Zone coordinates of the recognition result. An array contains four elements: [x1, y1, x2, y2], representing the horizontal and vertical coordinates of the top-left and bottom-right corners, respectively.
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    r"""Full text recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a full text recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: Output information of a full text recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input information of a full text recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output information of a full text recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    r"""Input for full text recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Full text recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Full text recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    r"""Output of full text recognition.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: Full text recognition result set.
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        r"""Full text recognition result set.
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    r"""Full text recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _TextSet: Recognition segment result set.
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        r"""Start time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        r"""Recognition segment result set.
        :rtype: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    r"""Full text recognition segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        :param _Text: Recognized text.
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        r"""Confidence of a recognition segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        r"""Recognized text.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    r"""Text keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a text keyword recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: Output information of a text keyword recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input information of a text keyword recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output information of a text keyword recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    r"""Input for text keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Text keyword recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Text keyword recognition template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    r"""Text keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Word: Text keyword.
        :type Word: str
        :param _SegmentSet: List of segments that contain a text keyword.
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        r"""Text keyword.
        :rtype: str
        """
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        r"""List of segments that contain a text keyword.
        :rtype: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    r"""Output of text keyword recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Text keyword recognition result set.
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        r"""Text keyword recognition result set.
        :rtype: list of AiRecognitionTaskOcrWordsResultItem
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    r"""Text recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        r"""Start time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time offset of a recognition segment in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        r"""Confidence of a recognition segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        r"""Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :rtype: list of int
        """
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResult(AbstractModel):
    r"""The translation result.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value indicates the task has failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: The error code. `0` indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the translation task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultInput`
        :param _Output: The output of the translation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultOutput`
        :param _Progress: Task progress.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        r"""The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value indicates the task has failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""The error code. `0` indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""The error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input of the translation task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of the translation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        r"""Task progress.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskTransTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskTransTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultInput(AbstractModel):
    r"""The translation input.

    """

    def __init__(self):
        r"""
        :param _Definition: The translation template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The translation template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultOutput(AbstractModel):
    r"""The translation result.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: The translated segments.
        :type SegmentSet: list of AiRecognitionTaskTransTextSegmentItem
        :param _SubtitlePath: The subtitle URL.
        :type SubtitlePath: str
        """
        self._SegmentSet = None
        self._SubtitlePath = None

    @property
    def SegmentSet(self):
        r"""The translated segments.
        :rtype: list of AiRecognitionTaskTransTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        r"""The subtitle URL.
        :rtype: str
        """
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskTransTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextSegmentItem(AbstractModel):
    r"""The translated segments.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for a segment. Value range: 0-100.
        :type Confidence: float
        :param _StartTimeOffset: The start time offset (seconds) of a segment.
        :type StartTimeOffset: float
        :param _EndTimeOffset: The end time offset (seconds) of a segment.
        :type EndTimeOffset: float
        :param _Text: The text transcript.
        :type Text: str
        :param _Trans: The translation.
        :type Trans: str
        :param _Wordlist: Word timestamp information.
        :type Wordlist: list of WordResult
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Trans = None
        self._Wordlist = None

    @property
    def Confidence(self):
        r"""The confidence score for a segment. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        r"""The start time offset (seconds) of a segment.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""The end time offset (seconds) of a segment.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        r"""The text transcript.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Trans(self):
        r"""The translation.
        :rtype: str
        """
        return self._Trans

    @Trans.setter
    def Trans(self, Trans):
        self._Trans = Trans

    @property
    def Wordlist(self):
        r"""Word timestamp information.
        :rtype: list of WordResult
        """
        return self._Wordlist

    @Wordlist.setter
    def Wordlist(self, Wordlist):
        self._Wordlist = Wordlist


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        self._Trans = params.get("Trans")
        if params.get("Wordlist") is not None:
            self._Wordlist = []
            for item in params.get("Wordlist"):
                obj = WordResult()
                obj._deserialize(item)
                self._Wordlist.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    r"""The input parameters for ASR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    r"""The information about the sensitive content detected based on ASR.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the ASR-based detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected based on ASR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: The video segments that contain sensitive information detected based on ASR.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""The confidence score for the ASR-based detection of sensitive information. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""The suggestion for handling the sensitive information detected based on ASR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""The video segments that contain sensitive information detected based on ASR.
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    r"""The input parameters for OCR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    r"""The information about the sensitive content detected based on OCR.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the OCR-based detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected based on OCR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: The video segments that contain sensitive information detected based on OCR.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""The confidence score for the OCR-based detection of sensitive information. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""The suggestion for handling the sensitive information detected based on OCR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""The video segments that contain sensitive information detected based on OCR.
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    r"""The input parameters for the detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    r"""The sensitive information detected.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: The labels for the detected sensitive content. The relationship between the values of this parameter and those of the `LabelSet` parameter in [PoliticalImgReviewTemplateInfo](https://intl.cloud.tencent.com/document/api/862/37615?from_cn_redirect=1#AiReviewPoliticalTaskOutput) is as follows:
violation_photo:
<li>violation_photo (banned icons)</li>
Other values (politician/entertainment/sport/entrepreneur/scholar/celebrity/military):
<li>politician</li>
        :type Label: str
        :param _SegmentSet: The video segments that contain sensitive information.
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""The confidence score for the detection of sensitive information. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""The suggestion for handling the sensitive information detected. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""The labels for the detected sensitive content. The relationship between the values of this parameter and those of the `LabelSet` parameter in [PoliticalImgReviewTemplateInfo](https://intl.cloud.tencent.com/document/api/862/37615?from_cn_redirect=1#AiReviewPoliticalTaskOutput) is as follows:
violation_photo:
<li>violation_photo (banned icons)</li>
Other values (politician/entertainment/sport/entrepreneur/scholar/celebrity/military):
<li>politician</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""The video segments that contain sensitive information.
        :rtype: list of MediaContentReviewPoliticalSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    r"""Input parameter type of an ASR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Definition: ID of a porn information detection template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""ID of a porn information detection template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    r"""ASR-detected porn information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of the ASR-detected porn information in text from 0 to 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for the ASR-detected porn information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the ASR-detected porn information in text.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Score of the ASR-detected porn information in text from 0 to 100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Suggestion for the ASR-detected porn information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""List of video segments that contain the ASR-detected porn information in text.
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    r"""Input parameter type of an OCR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Definition: ID of a porn information detection template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""ID of a porn information detection template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    r"""OCR-detected porn information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of the OCR-detected porn information in text from 0 to 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for the OCR-detected porn information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the OCR-detected porn information in text.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Score of the OCR-detected porn information in text from 0 to 100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Suggestion for the OCR-detected porn information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""List of video segments that contain the OCR-detected porn information in text.
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    r"""Input parameter type of a porn information detection task during content audit

    """

    def __init__(self):
        r"""
        :param _Definition: The ID of a porn detection template.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The ID of a porn detection template.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    r"""Porn information detection result

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of the detected porn information in video from 0 to 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for the detected porn information. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _Label: Tag of the detected porn information in video. Valid values:
<li>porn: Porn.</li>
<li>sexy: Sexiness.</li>
<li>vulgar: Vulgarity.</li>
<li>intimacy: Intimacy.</li>
        :type Label: str
        :param _SegmentSet: List of video segments that contain the detected porn information.
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Score of the detected porn information in video from 0 to 100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Suggestion for the detected porn information. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""Tag of the detected porn information in video. Valid values:
<li>porn: Porn.</li>
<li>sexy: Sexiness.</li>
<li>vulgar: Vulgarity.</li>
<li>intimacy: Intimacy.</li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""List of video segments that contain the detected porn information.
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    r"""Input parameter type of ASR-based prohibited information detection in speech task in content audit

    """

    def __init__(self):
        r"""
        :param _Definition: Prohibited information detection template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Prohibited information detection template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    r"""ASR-detected prohibited information in speech

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of ASR-detected prohibited information in speech between 0 and 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for ASR-detected prohibited information in speech. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the ASR-detected prohibited information in speech.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Score of ASR-detected prohibited information in speech between 0 and 100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Suggestion for ASR-detected prohibited information in speech. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""List of video segments that contain the ASR-detected prohibited information in speech.
        :rtype: list of MediaContentReviewAsrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    r"""Input parameter type of OCR-based prohibited information detection in text task in content audit

    """

    def __init__(self):
        r"""
        :param _Definition: Prohibited information detection template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Prohibited information detection template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    r"""OCR-detected prohibited information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of OCR-detected prohibited information in text between 0 and 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for OCR-detected prohibited information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the OCR-detected prohibited information in text.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""Score of OCR-detected prohibited information in text between 0 and 100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""Suggestion for OCR-detected prohibited information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""List of video segments that contain the OCR-detected prohibited information in text.
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    r"""The result of ASR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for ASR-based detection of politically sensitive information.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: The output of ASR-based detection of politically sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input parameter for ASR-based detection of politically sensitive information.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of ASR-based detection of politically sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    r"""The result of OCR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: The input parameter for OCR-based detection of politically sensitive information.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: The output of OCR-based detection of politically sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input parameter for OCR-based detection of politically sensitive information.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of OCR-based detection of politically sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    r"""The result of sensitive information detection.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for sensitive information detection.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskInput`
        :param _Output: The output of sensitive information detection.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input parameter for sensitive information detection.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of sensitive information detection.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    r"""Result type of an ASR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an ASR-based porn information detection in text task during content audit.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskInput`
        :param _Output: Output of an ASR-based porn information detection in text task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input for an ASR-based porn information detection in text task during content audit.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of an ASR-based porn information detection in text task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    r"""Result type of an OCR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an OCR-based porn information detection in text task during content audit.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskInput`
        :param _Output: Output of an OCR-based porn information detection in text task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input for an OCR-based porn information detection in text task during content audit.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of an OCR-based porn information detection in text task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    r"""Result type of a porn information detection task during content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for a porn information detection task during content audit.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskInput`
        :param _Output: Output of a porn information detection task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input for a porn information detection task during content audit.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of a porn information detection task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    r"""Result type of ASR-based prohibited information detection in speech task in content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of ASR-based prohibited information detection in speech task in content audit
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: Output of ASR-based prohibited information detection in speech task in content audit
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input of ASR-based prohibited information detection in speech task in content audit
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of ASR-based prohibited information detection in speech task in content audit
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    r"""Result type of OCR-based prohibited information detection in text task in content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of OCR-based prohibited information detection in text task in content audit
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: Output of OCR-based prohibited information detection in text task in content audit
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""Input of OCR-based prohibited information detection in text task in content audit
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""Output of OCR-based prohibited information detection in text task in content audit
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    r"""The result of OCR-based detection of terrorism content.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for OCR-based detection of terrorism content.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: The output of OCR-based detection of terrorism content.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input parameter for OCR-based detection of terrorism content.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of OCR-based detection of terrorism content.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    r"""The result of sensitive information detection.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for sensitive information detection.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskInput`
        :param _Output: The output of sensitive information detection.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        r"""Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        r"""The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :rtype: str
        """
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        r"""Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        r"""The input parameter for sensitive information detection.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        r"""The output of sensitive information detection.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskOutput`
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    r"""The input parameter for OCR-based detection of sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    r"""The information about the sensitive content detected based on OCR.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the OCR-based detection of sensitive information. Value range: 1-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected based on OCR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: The video segments that contain sensitive information detected based on OCR.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""The confidence score for the OCR-based detection of sensitive information. Value range: 1-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""The suggestion for handling the sensitive information detected based on OCR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        r"""The video segments that contain sensitive information detected based on OCR.
        :rtype: list of MediaContentReviewOcrTextSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    r"""The input parameter for the detection of sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    r"""The information about the sensitive content detected.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: The labels for the detected sensitive content. Valid values:
<li>guns</li>
<li>crowd</li>
<li>police</li>
<li>bloody</li>
<li>banners (sensitive flags)</li>
<li>militant</li>
<li>explosion</li>
<li>terrorists</li>
<li>scenario (sensitive scenes) </li>
        :type Label: str
        :param _SegmentSet: The video segments that contain sensitive information.
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        r"""The confidence score for the detection of sensitive information. Value range: 0-100.
        :rtype: float
        """
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        r"""The suggestion for handling the sensitive information detected. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        r"""The labels for the detected sensitive content. Valid values:
<li>guns</li>
<li>crowd</li>
<li>police</li>
<li>bloody</li>
<li>banners (sensitive flags)</li>
<li>militant</li>
<li>explosion</li>
<li>terrorists</li>
<li>scenario (sensitive scenes) </li>
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        r"""The video segments that contain sensitive information.
        :rtype: list of MediaContentReviewSegmentItem
        """
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    r"""AI-based sample management - face information.

    """

    def __init__(self):
        r"""
        :param _FaceId: Face image ID.
        :type FaceId: str
        :param _Url: Face image address.
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        r"""Face image ID.
        :rtype: str
        """
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        r"""Face image address.
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    r"""AI-based sample management - face data operation.

    """

    def __init__(self):
        r"""
        :param _Type: Operation type. Valid values: add, delete, reset. The `reset` operation will clear the existing face data of a figure and add `FaceContents` as the specified face data.
        :type Type: str
        :param _FaceIds: Face ID set. This field is required when `Type` is `delete`.
        :type FaceIds: list of str
        :param _FaceContents: String set generated by [Base64-encoding](https://tools.ietf.org/html/rfc4648) the face image.
<li>This field is required when `Type` is `add` or `reset`;</li>
<li>Array length limit: 5 images.</li>
Note: The image must be a relatively clear full-face photo of a figure in at least 200 * 200 px.
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        r"""Operation type. Valid values: add, delete, reset. The `reset` operation will clear the existing face data of a figure and add `FaceContents` as the specified face data.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        r"""Face ID set. This field is required when `Type` is `delete`.
        :rtype: list of str
        """
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        r"""String set generated by [Base64-encoding](https://tools.ietf.org/html/rfc4648) the face image.
<li>This field is required when `Type` is `add` or `reset`;</li>
<li>Array length limit: 5 images.</li>
Note: The image must be a relatively clear full-face photo of a figure in at least 200 * 200 px.
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    r"""AI-based sample management - face information failing to be processed.

    """

    def __init__(self):
        r"""
        :param _Index: Corresponds to incorrect image subscripts in the `FaceContents` input parameter, starting from 0.
        :type Index: int
        :param _ErrCode: Error code. Valid values:
<li>0: Succeeded;</li>
<li>Other values: Failed.</li>
        :type ErrCode: int
        :param _Message: Error description.
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        r"""Corresponds to incorrect image subscripts in the `FaceContents` input parameter, starting from 0.
        :rtype: int
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        r"""Error code. Valid values:
<li>0: Succeeded;</li>
<li>Other values: Failed.</li>
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        r"""Error description.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    r"""AI-based sample management - figure information.

    """

    def __init__(self):
        r"""
        :param _PersonId: Figure ID.
        :type PersonId: str
        :param _Name: Name of a figure.
        :type Name: str
        :param _Description: Figure description.
        :type Description: str
        :param _FaceInfoSet: Face information.
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: Figure tag.
        :type TagSet: list of str
        :param _UsageSet: Use case.
        :type UsageSet: list of str
        :param _CreateTime: Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        r"""Figure ID.
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        r"""Name of a figure.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""Figure description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        r"""Face information.
        :rtype: list of AiSampleFaceInfo
        """
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        r"""Figure tag.
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        r"""Use case.
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        r"""Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    r"""AI-based sample management - tag operation.

    """

    def __init__(self):
        r"""
        :param _Type: Operation type. Valid values: add, delete, reset.
        :type Type: str
        :param _Tags: Tag. Length limit: 128 characters.
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        r"""Operation type. Valid values: add, delete, reset.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        r"""Tag. Length limit: 128 characters.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    r"""AI-based sample management - keyword output information.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword.
        :type Keyword: str
        :param _TagSet: Keyword tag.
        :type TagSet: list of str
        :param _UsageSet: Keyword use case.
        :type UsageSet: list of str
        :param _CreateTime: Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        r"""Keyword.
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        r"""Keyword tag.
        :rtype: list of str
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        r"""Keyword use case.
        :rtype: list of str
        """
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        r"""Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    r"""AI-based sample management - keyword input information.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword. Length limit: 20 characters.
        :type Keyword: str
        :param _Tags: Keyword tag
<li>Array length limit: 20 tags;</li>
<li>Tag length limit: 128 characters.</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        r"""Keyword. Length limit: 20 characters.
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        r"""Keyword tag
<li>Array length limit: 20 tags;</li>
<li>Tag length limit: 128 characters.</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    r"""Type of an animated image generating task.

    """

    def __init__(self):
        r"""
        :param _Definition: Animated image generating template ID.
        :type Definition: int
        :param _StartTimeOffset: Start time of an animated image in a video in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time of an animated image in a video in seconds.
        :type EndTimeOffset: float
        :param _OutputStorage: Target bucket of a generated animated image file. If this parameter is left empty, the `OutputStorage` value of the upper folder will be inherited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: Output path of a file after animated image generating, which can be a relative or absolute path.
If you need to define an output path, the path must end with `.{format}`. For variable names, refer to [Filename Variable](https://intl.cloud.tencent.com/document/product/862/37039?from_cn_redirect=1).
Relative path example:
<li>Filename_{Variable name}.{format}.</li>
<li>Filename.{format}.</li>
Absolute path example:
<li>/Custom path/Filename_{Variable name}.{format}.</li>
If left empty, a relative path is used by default: `{inputName}_animatedGraphic_{definition}.{format}`.
        :type OutputObjectPath: str
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._OutputStorage = None
        self._OutputObjectPath = None

    @property
    def Definition(self):
        r"""Animated image generating template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        r"""Start time of an animated image in a video in seconds.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""End time of an animated image in a video in seconds.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def OutputStorage(self):
        r"""Target bucket of a generated animated image file. If this parameter is left empty, the `OutputStorage` value of the upper folder will be inherited.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        r"""Output path of a file after animated image generating, which can be a relative or absolute path.
If you need to define an output path, the path must end with `.{format}`. For variable names, refer to [Filename Variable](https://intl.cloud.tencent.com/document/product/862/37039?from_cn_redirect=1).
Relative path example:
<li>Filename_{Variable name}.{format}.</li>
<li>Filename.{format}.</li>
Absolute path example:
<li>/Custom path/Filename_{Variable name}.{format}.</li>
If left empty, a relative path is used by default: `{inputName}_animatedGraphic_{definition}.{format}`.
        :rtype: str
        """
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    r"""Details of an animated image generating template.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Name of an animated image generating template.
        :type Name: str
        :param _Comment: Description of an animated image generating template.
        :type Comment: str
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: Enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: Disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format.
        :type Format: str
        :param _Fps: Frame rate.
        :type Fps: int
        :param _Quality: Image quality.
        :type Quality: float
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""Unique ID of an animated image generating template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""Template type. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Name of an animated image generating template.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description of an animated image generating template.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        r"""Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Maximum value of the height (or short side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""Resolution adaption. Valid values:
<li>open: Enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: Disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""Animated image format.
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        r"""Frame rate.
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        r"""Image quality.
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        r"""Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ArtifactRepairConfig(AbstractModel):
    r"""Artifact removal (smoothing) configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>weak</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""The strength. Valid values:
<li>weak</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    r"""Control parameter of a full speech recognition task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a full speech recognition task. Valid values:
<li>ON: Enables an intelligent full speech recognition task;</li>
<li>OFF: Disables an intelligent full speech recognition task.</li>
        :type Switch: str
        :param _SubtitleFormat: Format of the generated subtitles file. If this parameter is left empty or an empty string is entered, no subtitles files will be generated. Valid value:
<li>vtt: Generates a WebVTT subtitles file.</li>
        :type SubtitleFormat: str
        """
        self._Switch = None
        self._SubtitleFormat = None

    @property
    def Switch(self):
        r"""Switch of a full speech recognition task. Valid values:
<li>ON: Enables an intelligent full speech recognition task;</li>
<li>OFF: Disables an intelligent full speech recognition task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        r"""Format of the generated subtitles file. If this parameter is left empty or an empty string is entered, no subtitles files will be generated. Valid value:
<li>vtt: Generates a WebVTT subtitles file.</li>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    r"""Control parameter of a full speech recognition task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a full speech recognition task. Valid values:
<li>ON: Enables an intelligent full speech recognition task;</li>
<li>OFF: Disables an intelligent full speech recognition task.</li>
        :type Switch: str
        :param _SubtitleFormat: Format of the generated subtitles file. If an empty string is entered, no subtitles files will be generated. Valid value:
<li>vtt: Generates a WebVTT subtitles file.</li>
        :type SubtitleFormat: str
        """
        self._Switch = None
        self._SubtitleFormat = None

    @property
    def Switch(self):
        r"""Switch of a full speech recognition task. Valid values:
<li>ON: Enables an intelligent full speech recognition task;</li>
<li>OFF: Disables an intelligent full speech recognition task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        r"""Format of the generated subtitles file. If an empty string is entered, no subtitles files will be generated. Valid value:
<li>vtt: Generates a WebVTT subtitles file.</li>
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrHotWordsConfigure(AbstractModel):
    r"""Smart subtitle hotword parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Hotword switch.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Switch: str
        :param _LibraryId: Hotword lexicon ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :type LibraryId: str
        """
        self._Switch = None
        self._LibraryId = None

    @property
    def Switch(self):
        r"""Hotword switch.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LibraryId(self):
        r"""Hotword lexicon ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._LibraryId

    @LibraryId.setter
    def LibraryId(self, LibraryId):
        self._LibraryId = LibraryId


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LibraryId = params.get("LibraryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrHotwordsSet(AbstractModel):
    r"""Returned result set of hotword lexicon query.

    """

    def __init__(self):
        r"""
        :param _HotwordsId: Hotword lexicon ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :type HotwordsId: str
        :param _Status: Current hotword lexicon status. The value indicates the number of smart subtitle templates bound to this hotword lexicon.
If the value of Status is 0, it indicates that the hotword lexicon is not referenced by any smart subtitle template and that it can be deleted.
If the value of Status is not 0, it indicates that the hotword lexicon cannot be deleted.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Status: int
        :param _Name: Hotword lexicon name.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _WordCount: Number of hotwords in the hotword lexicon.
Note: This field may return null, indicating that no valid value can be obtained.
        :type WordCount: int
        :param _FileName: Name of the uploaded hotword file.
Note: This field may return null, indicating that no valid value can be obtained.
        :type FileName: str
        :param _CreateTime: Creation time of the hotword lexicon in ISO datetime format (UTC time). For example, 2006-01-02T15:04:05Z.
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Creation time of the hotword lexicon in ISO datetime format (UTC time). For example, 2006-01-02T15:04:05Z.
Note: This field may return null, indicating that no valid value can be obtained.
        :type UpdateTime: str
        :param _Type: 0: temporary hotword lexicon
1: file-based hotword lexicon
Note: This field may return null, indicating that no valid value can be obtained.
        :type Type: int
        """
        self._HotwordsId = None
        self._Status = None
        self._Name = None
        self._WordCount = None
        self._FileName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def HotwordsId(self):
        r"""Hotword lexicon ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Status(self):
        r"""Current hotword lexicon status. The value indicates the number of smart subtitle templates bound to this hotword lexicon.
If the value of Status is 0, it indicates that the hotword lexicon is not referenced by any smart subtitle template and that it can be deleted.
If the value of Status is not 0, it indicates that the hotword lexicon cannot be deleted.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Name(self):
        r"""Hotword lexicon name.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def WordCount(self):
        r"""Number of hotwords in the hotword lexicon.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._WordCount

    @WordCount.setter
    def WordCount(self, WordCount):
        self._WordCount = WordCount

    @property
    def FileName(self):
        r"""Name of the uploaded hotword file.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def CreateTime(self):
        r"""Creation time of the hotword lexicon in ISO datetime format (UTC time). For example, 2006-01-02T15:04:05Z.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Creation time of the hotword lexicon in ISO datetime format (UTC time). For example, 2006-01-02T15:04:05Z.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""0: temporary hotword lexicon
1: file-based hotword lexicon
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Status = params.get("Status")
        self._Name = params.get("Name")
        self._WordCount = params.get("WordCount")
        self._FileName = params.get("FileName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrHotwordsSetItem(AbstractModel):
    r"""Information on a single hotword.

    """

    def __init__(self):
        r"""
        :param _Id: Hotword ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: int
        :param _Text: Hotword text.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Text: str
        :param _Weight: Hotword weight. The value can be 11 or 100 or be in the range of 1 to 10.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Weight: int
        """
        self._Id = None
        self._Text = None
        self._Weight = None

    @property
    def Id(self):
        r"""Hotword ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Text(self):
        r"""Hotword text.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Weight(self):
        r"""Hotword weight. The value can be 11 or 100 or be in the range of 1 to 10.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Text = params.get("Text")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    r"""Speech keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a speech keyword recognition task. Valid values:
<li>ON: Enables a speech keyword recognition task;</li>
<li>OFF: Disables a speech keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        r"""Switch of a speech keyword recognition task. Valid values:
<li>ON: Enables a speech keyword recognition task;</li>
<li>OFF: Disables a speech keyword recognition task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        r"""Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    r"""Speech keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a speech keyword recognition task. Valid values:
<li>ON: Enables a speech keyword recognition task;</li>
<li>OFF: Disables a speech keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        r"""Switch of a speech keyword recognition task. Valid values:
<li>ON: Enables a speech keyword recognition task;</li>
<li>OFF: Disables a speech keyword recognition task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        r"""Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :rtype: list of str
        """
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioBeautifyConfig(AbstractModel):
    r"""The audio improvement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :type Switch: str
        :param _Types: The audio improvement options. You can specify multiple options. Valid values:
<li>`declick`: Noise removal.</li>
<li>`deesser`: De-essing.</li>
Default: `declick`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Types: list of str
        """
        self._Switch = None
        self._Types = None

    @property
    def Switch(self):
        r"""Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Types(self):
        r"""The audio improvement options. You can specify multiple options. Valid values:
<li>`declick`: Noise removal.</li>
<li>`deesser`: De-essing.</li>
Default: `declick`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioDenoiseConfig(AbstractModel):
    r"""The noise reduction configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioEnhanceConfig(AbstractModel):
    r"""The audio enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Denoise: The audio noise reduction configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Denoise: :class:`tencentcloud.mps.v20190612.models.AudioDenoiseConfig`
        :param _Separate: The audio separation configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Separate: :class:`tencentcloud.mps.v20190612.models.AudioSeparateConfig`
        :param _VolumeBalance: The volume equalization configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VolumeBalance: :class:`tencentcloud.mps.v20190612.models.VolumeBalanceConfig`
        :param _Beautify: The audio improvement configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Beautify: :class:`tencentcloud.mps.v20190612.models.AudioBeautifyConfig`
        """
        self._Denoise = None
        self._Separate = None
        self._VolumeBalance = None
        self._Beautify = None

    @property
    def Denoise(self):
        r"""The audio noise reduction configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioDenoiseConfig`
        """
        return self._Denoise

    @Denoise.setter
    def Denoise(self, Denoise):
        self._Denoise = Denoise

    @property
    def Separate(self):
        r"""The audio separation configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioSeparateConfig`
        """
        return self._Separate

    @Separate.setter
    def Separate(self, Separate):
        self._Separate = Separate

    @property
    def VolumeBalance(self):
        r"""The volume equalization configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.VolumeBalanceConfig`
        """
        return self._VolumeBalance

    @VolumeBalance.setter
    def VolumeBalance(self, VolumeBalance):
        self._VolumeBalance = VolumeBalance

    @property
    def Beautify(self):
        r"""The audio improvement configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioBeautifyConfig`
        """
        return self._Beautify

    @Beautify.setter
    def Beautify(self, Beautify):
        self._Beautify = Beautify


    def _deserialize(self, params):
        if params.get("Denoise") is not None:
            self._Denoise = AudioDenoiseConfig()
            self._Denoise._deserialize(params.get("Denoise"))
        if params.get("Separate") is not None:
            self._Separate = AudioSeparateConfig()
            self._Separate._deserialize(params.get("Separate"))
        if params.get("VolumeBalance") is not None:
            self._VolumeBalance = VolumeBalanceConfig()
            self._VolumeBalance._deserialize(params.get("VolumeBalance"))
        if params.get("Beautify") is not None:
            self._Beautify = AudioBeautifyConfig()
            self._Beautify._deserialize(params.get("Beautify"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioSeparateConfig(AbstractModel):
    r"""The audio separation configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :type Switch: str
        :param _Type: The scenario. Valid values:
<li>`normal`: Separate voice and background audio.</li>
<li>`music`: Separate vocals and instrumentals.</li>
Default value: `normal`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Track: The output audio track. Valid values:
<li>`vocal`: Voice.</li>
<li>`background`: Output background audio if the scenario is `normal`, and output instrumentals if the scenario is `music`.</li>
Default value: `vocal`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Track: str
        """
        self._Switch = None
        self._Type = None
        self._Track = None

    @property
    def Switch(self):
        r"""Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""The scenario. Valid values:
<li>`normal`: Separate voice and background audio.</li>
<li>`music`: Separate vocals and instrumentals.</li>
Default value: `normal`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Track(self):
        r"""The output audio track. Valid values:
<li>`vocal`: Voice.</li>
<li>`background`: Output background audio if the scenario is `normal`, and output instrumentals if the scenario is `music`.</li>
Default value: `vocal`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Track

    @Track.setter
    def Track(self, Track):
        self._Track = Track


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Track = params.get("Track")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    r"""Audio stream configuration parameter

    """

    def __init__(self):
        r"""
        :param _Codec: Specifies the encoding format of the audio stream.
When audio transcoding is not needed, the optional values are:.
<li>copy.</li>
When the outer parameter Container is mp3, the valid values are:.
<li>mp3.</li>
When the outer parameter Container is ogg or flac, the valid values are:.
<li>flac.</li>
When the outer parameter Container is m4a, valid values are:.
<li>aac;</li>
<li>ac3.</li>
When the outer parameter Container is mp4 or flv, valid values are:.
<li>aac: more suitable for mp4;</li>.
<li>mp3: more suitable for flv;</li>.
<li>mp2.</li>
When the outer parameter Container is hls, valid values are:.
<li>aac;</li>
<li>mp3;</li>
<li>eac3: used when merging adaptive transcoding audio tracks.</li>.
        :type Codec: str
        :param _Bitrate: The bitrate of the audio stream. value ranges from 0 to 26 and in the range of [26, 256]. measurement unit: kbps.
If the value is 0, the audio bitrate will be the same as that of the original audio.
Specifies that when using the TrackChannelInfo parameter for adaptive transcoding audio track merging, the valid values are:.
Cannot be set to 0.
2). when Codec is aac, valid values: [26, 256].
3). when Codec is ac3, valid values: [26, 640].
4) when Codec is eac3, value range: [26, 6144]. remark: when SampleRate is 44100HZ, maximum value: 5644. when SampleRate is 48000HZ, maximum value: 6144.


        :type Bitrate: int
        :param _SampleRate: Sampling rate of the audio stream. Different encoding standards support different sampling rate options. The value of 0 indicates using the sampling rate value of the source audio.
For details, see [Supported Range of Audio Sampling Rate](https://www.tencentcloud.comom/document/product/862/77166?from_cn_redirect=1#f3b039f1-d817-4a96-b4e4-90132d31cd53).
Unit: Hz.
Note: Make sure that the sampling rate of the source audio stream is among the above options. Otherwise, transcoding may fail.
        :type SampleRate: int
        :param _AudioChannel: Audio channel mode. Valid values:
<li>1: mono-channel.</li>
<li>2: dual-channel.</li>
<li>6: 5.1 surround sound.
<li>Default value: 2.
When the container format is audio (flac, ogg, mp3, and m4a), the audio channel cannot be set to 5.1 surround sound.
        :type AudioChannel: int
        :param _TrackChannelInfo: Merge audio track information.
This field only takes effect in adaptive bitrate transcoding.

Note: This field may return null, indicating that no valid value can be obtained.
        :type TrackChannelInfo: :class:`tencentcloud.mps.v20190612.models.AudioTrackChannelInfo`
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None
        self._TrackChannelInfo = None

    @property
    def Codec(self):
        r"""Specifies the encoding format of the audio stream.
When audio transcoding is not needed, the optional values are:.
<li>copy.</li>
When the outer parameter Container is mp3, the valid values are:.
<li>mp3.</li>
When the outer parameter Container is ogg or flac, the valid values are:.
<li>flac.</li>
When the outer parameter Container is m4a, valid values are:.
<li>aac;</li>
<li>ac3.</li>
When the outer parameter Container is mp4 or flv, valid values are:.
<li>aac: more suitable for mp4;</li>.
<li>mp3: more suitable for flv;</li>.
<li>mp2.</li>
When the outer parameter Container is hls, valid values are:.
<li>aac;</li>
<li>mp3;</li>
<li>eac3: used when merging adaptive transcoding audio tracks.</li>.
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        r"""The bitrate of the audio stream. value ranges from 0 to 26 and in the range of [26, 256]. measurement unit: kbps.
If the value is 0, the audio bitrate will be the same as that of the original audio.
Specifies that when using the TrackChannelInfo parameter for adaptive transcoding audio track merging, the valid values are:.
Cannot be set to 0.
2). when Codec is aac, valid values: [26, 256].
3). when Codec is ac3, valid values: [26, 640].
4) when Codec is eac3, value range: [26, 6144]. remark: when SampleRate is 44100HZ, maximum value: 5644. when SampleRate is 48000HZ, maximum value: 6144.


        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        r"""Sampling rate of the audio stream. Different encoding standards support different sampling rate options. The value of 0 indicates using the sampling rate value of the source audio.
For details, see [Supported Range of Audio Sampling Rate](https://www.tencentcloud.comom/document/product/862/77166?from_cn_redirect=1#f3b039f1-d817-4a96-b4e4-90132d31cd53).
Unit: Hz.
Note: Make sure that the sampling rate of the source audio stream is among the above options. Otherwise, transcoding may fail.
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""Audio channel mode. Valid values:
<li>1: mono-channel.</li>
<li>2: dual-channel.</li>
<li>6: 5.1 surround sound.
<li>Default value: 2.
When the container format is audio (flac, ogg, mp3, and m4a), the audio channel cannot be set to 5.1 surround sound.
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def TrackChannelInfo(self):
        r"""Merge audio track information.
This field only takes effect in adaptive bitrate transcoding.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioTrackChannelInfo`
        """
        return self._TrackChannelInfo

    @TrackChannelInfo.setter
    def TrackChannelInfo(self, TrackChannelInfo):
        self._TrackChannelInfo = TrackChannelInfo


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        if params.get("TrackChannelInfo") is not None:
            self._TrackChannelInfo = AudioTrackChannelInfo()
            self._TrackChannelInfo._deserialize(params.get("TrackChannelInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    r"""Audio stream configuration parameter

    """

    def __init__(self):
        r"""
        :param _Codec: Audio stream encoding format.
When audio transcoding is not needed, the value is:
<li>copy.</li>
When the outer parameter Container is mp3, the value is:
<li>mp3.</li>
When the outer parameter Container is ogg or flac, the value is:
<li>flac.</li>
When the outer parameter Container is m4a, valid values are:
<li>aac;</li>
<li>ac3.</li>
When the outer parameter Container is mp4 or flv, valid values are:
<li>aac: more suitable for mp4;</li>
<li>mp3: more suitable for flv;</li>
<li>mp2.</li>
When the outer parameter Container is hls, valid values are:
<li>aac;</li>
<li>mp3.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Codec: str
        :param _Bitrate: Audio stream bitrate in Kbps. Value range: 0 and [26, 256]. If the value is 0, the bitrate of the audio stream will be the same as that of the original audio.
        :type Bitrate: int
        :param _SampleRate: Sampling rate of the audio stream. Different encoding standards support different sampling rate options. The value of 0 indicates using the sampling rate value of the source audio.
For details, see [Supported Range of Audio Sampling Rate](https://www.tencentcloud.comom/document/product/862/77166?from_cn_redirect=1#f3b039f1-d817-4a96-b4e4-90132d31cd53).
Unit: Hz.
Note: Make sure that the sampling rate of the source audio stream is among the above options. Otherwise, transcoding may fail.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SampleRate: int
        :param _AudioChannel: Audio channel mode. Valid values:
<li>1: mono-channel.</li>
<li>2: dual-channel.</li>
<li>6: 5.1 surround sound.
When the container format is audio (flac, ogg, mp3, and m4a), the audio channel cannot be set to 5.1 surround sound.

Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioChannel: int
        :param _StreamSelects: The audio tracks to retain. All audio tracks are retained by default.
        :type StreamSelects: list of int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None
        self._StreamSelects = None

    @property
    def Codec(self):
        r"""Audio stream encoding format.
When audio transcoding is not needed, the value is:
<li>copy.</li>
When the outer parameter Container is mp3, the value is:
<li>mp3.</li>
When the outer parameter Container is ogg or flac, the value is:
<li>flac.</li>
When the outer parameter Container is m4a, valid values are:
<li>aac;</li>
<li>ac3.</li>
When the outer parameter Container is mp4 or flv, valid values are:
<li>aac: more suitable for mp4;</li>
<li>mp3: more suitable for flv;</li>
<li>mp2.</li>
When the outer parameter Container is hls, valid values are:
<li>aac;</li>
<li>mp3.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        r"""Audio stream bitrate in Kbps. Value range: 0 and [26, 256]. If the value is 0, the bitrate of the audio stream will be the same as that of the original audio.
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        r"""Sampling rate of the audio stream. Different encoding standards support different sampling rate options. The value of 0 indicates using the sampling rate value of the source audio.
For details, see [Supported Range of Audio Sampling Rate](https://www.tencentcloud.comom/document/product/862/77166?from_cn_redirect=1#f3b039f1-d817-4a96-b4e4-90132d31cd53).
Unit: Hz.
Note: Make sure that the sampling rate of the source audio stream is among the above options. Otherwise, transcoding may fail.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""Audio channel mode. Valid values:
<li>1: mono-channel.</li>
<li>2: dual-channel.</li>
<li>6: 5.1 surround sound.
When the container format is audio (flac, ogg, mp3, and m4a), the audio channel cannot be set to 5.1 surround sound.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def StreamSelects(self):
        r"""The audio tracks to retain. All audio tracks are retained by default.
        :rtype: list of int
        """
        return self._StreamSelects

    @StreamSelects.setter
    def StreamSelects(self, StreamSelects):
        self._StreamSelects = StreamSelects


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._StreamSelects = params.get("StreamSelects")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTrackChannelInfo(AbstractModel):
    r"""Audio track information.

    """

    def __init__(self):
        r"""
        :param _ChannelsRemix: Whether to enable the feature of multi-audio track mixing. Valid values:
<li>0: To disable the multi-audio track mixing feature.
<li>1: To enable the multi-audio track mixing feature. 
<li>Default value: 0.

Note: This field may return null, indicating that no valid value can be obtained.
        :type ChannelsRemix: int
        :param _SelectType: Set the selector type for the input audio track. Valid values:
<li>track: indicates the usage of audio track id to identify the track to be used.
<li>track_channel: indicates the usage of both the audio track id and sound channel id to identify the track and channel to be used.
<li>Default value: track.
If the original audio track has multiple sound channels, please use track_channel.

Note: This field may return null, indicating that no valid value can be obtained.
        :type SelectType: str
        :param _InputTrackInfo: Audio track information.

Note: This field may return null, indicating that no valid value can be obtained.
        :type InputTrackInfo: list of TrackInfo
        """
        self._ChannelsRemix = None
        self._SelectType = None
        self._InputTrackInfo = None

    @property
    def ChannelsRemix(self):
        r"""Whether to enable the feature of multi-audio track mixing. Valid values:
<li>0: To disable the multi-audio track mixing feature.
<li>1: To enable the multi-audio track mixing feature. 
<li>Default value: 0.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._ChannelsRemix

    @ChannelsRemix.setter
    def ChannelsRemix(self, ChannelsRemix):
        self._ChannelsRemix = ChannelsRemix

    @property
    def SelectType(self):
        r"""Set the selector type for the input audio track. Valid values:
<li>track: indicates the usage of audio track id to identify the track to be used.
<li>track_channel: indicates the usage of both the audio track id and sound channel id to identify the track and channel to be used.
<li>Default value: track.
If the original audio track has multiple sound channels, please use track_channel.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._SelectType

    @SelectType.setter
    def SelectType(self, SelectType):
        self._SelectType = SelectType

    @property
    def InputTrackInfo(self):
        r"""Audio track information.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of TrackInfo
        """
        return self._InputTrackInfo

    @InputTrackInfo.setter
    def InputTrackInfo(self, InputTrackInfo):
        self._InputTrackInfo = InputTrackInfo


    def _deserialize(self, params):
        self._ChannelsRemix = params.get("ChannelsRemix")
        self._SelectType = params.get("SelectType")
        if params.get("InputTrackInfo") is not None:
            self._InputTrackInfo = []
            for item in params.get("InputTrackInfo"):
                obj = TrackInfo()
                obj._deserialize(item)
                self._InputTrackInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsS3FileUploadTrigger(AbstractModel):
    r"""An AWS S3 file upload trigger.

    """

    def __init__(self):
        r"""
        :param _S3Bucket: The AWS S3 bucket bound to the scheme.
        :type S3Bucket: str
        :param _S3Region: The region of the AWS S3 bucket.
        :type S3Region: str
        :param _Dir: The bucket directory bound. It must be an absolute path that starts and ends with `/`, such as `/movie/201907/`. If you do not specify this, the root directory will be bound.	
        :type Dir: str
        :param _Formats: The file formats that will trigger the scheme, such as ["mp4", "flv", "mov"]. If you do not specify this, the upload of files in any format will trigger the scheme.	
        :type Formats: list of str
        :param _S3SecretId: The key ID of the AWS S3 bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type S3SecretId: str
        :param _S3SecretKey: The key of the AWS S3 bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type S3SecretKey: str
        :param _AwsSQS: The SQS queue of the AWS S3 bucket.
Note: The queue must be in the same region as the bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AwsSQS: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        """
        self._S3Bucket = None
        self._S3Region = None
        self._Dir = None
        self._Formats = None
        self._S3SecretId = None
        self._S3SecretKey = None
        self._AwsSQS = None

    @property
    def S3Bucket(self):
        r"""The AWS S3 bucket bound to the scheme.
        :rtype: str
        """
        return self._S3Bucket

    @S3Bucket.setter
    def S3Bucket(self, S3Bucket):
        self._S3Bucket = S3Bucket

    @property
    def S3Region(self):
        r"""The region of the AWS S3 bucket.
        :rtype: str
        """
        return self._S3Region

    @S3Region.setter
    def S3Region(self, S3Region):
        self._S3Region = S3Region

    @property
    def Dir(self):
        r"""The bucket directory bound. It must be an absolute path that starts and ends with `/`, such as `/movie/201907/`. If you do not specify this, the root directory will be bound.	
        :rtype: str
        """
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        r"""The file formats that will trigger the scheme, such as ["mp4", "flv", "mov"]. If you do not specify this, the upload of files in any format will trigger the scheme.	
        :rtype: list of str
        """
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats

    @property
    def S3SecretId(self):
        r"""The key ID of the AWS S3 bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        r"""The key of the AWS S3 bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey

    @property
    def AwsSQS(self):
        r"""The SQS queue of the AWS S3 bucket.
Note: The queue must be in the same region as the bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        """
        return self._AwsSQS

    @AwsSQS.setter
    def AwsSQS(self, AwsSQS):
        self._AwsSQS = AwsSQS


    def _deserialize(self, params):
        self._S3Bucket = params.get("S3Bucket")
        self._S3Region = params.get("S3Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        if params.get("AwsSQS") is not None:
            self._AwsSQS = AwsSQS()
            self._AwsSQS._deserialize(params.get("AwsSQS"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsSQS(AbstractModel):
    r"""The information of an AWS SQS queue.

    """

    def __init__(self):
        r"""
        :param _SQSRegion: The region of the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SQSRegion: str
        :param _SQSQueueName: The name of the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SQSQueueName: str
        :param _S3SecretId: The key ID required to read from/write to the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :type S3SecretId: str
        :param _S3SecretKey: The key required to read from/write to the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :type S3SecretKey: str
        """
        self._SQSRegion = None
        self._SQSQueueName = None
        self._S3SecretId = None
        self._S3SecretKey = None

    @property
    def SQSRegion(self):
        r"""The region of the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SQSRegion

    @SQSRegion.setter
    def SQSRegion(self, SQSRegion):
        self._SQSRegion = SQSRegion

    @property
    def SQSQueueName(self):
        r"""The name of the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SQSQueueName

    @SQSQueueName.setter
    def SQSQueueName(self, SQSQueueName):
        self._SQSQueueName = SQSQueueName

    @property
    def S3SecretId(self):
        r"""The key ID required to read from/write to the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        r"""The key required to read from/write to the SQS queue.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey


    def _deserialize(self, params):
        self._SQSRegion = params.get("SQSRegion")
        self._SQSQueueName = params.get("SQSQueueName")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchProcessMediaRequest(AbstractModel):
    r"""BatchProcessMedia request structure.

    """

    def __init__(self):
        r"""
        :param _InputInfo: Path of the input file.
        :type InputInfo: list of MediaInputInfo
        :param _OutputStorage: Storage bucket for the output file. If it is left blank, the storage location in InputInfo will be inherited.
Note: When InputInfo.Type is URL, this parameter is required.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: Storage directory for the output file. It should start and end with a slash (/), such as `/movie/201907/`.
If left blank, it indicates that the directory is the same as the one where the file is located in InputInfo.
        :type OutputDir: str
        :param _SmartSubtitlesTask: Smart subtitle.
        :type SmartSubtitlesTask: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        :param _TaskNotifyConfig: Event notification information of the task. If left blank, it indicates that no event notification will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Priority of the task flow. The higher the value, the higher the priority. The value range is from -10 to 10. If left blank, the default value is 0.
        :type TasksPriority: int
        :param _SessionContext: Source context, which is used to pass through the user request information. The callback for task flow status changes will return the value of this field. The maximum length is 1,000 characters.
        :type SessionContext: str
        :param _ResourceId: Resource ID. Ensure the corresponding resource is in the enabled state. The default value is an account's primary resource ID.
        :type ResourceId: str
        :param _SkipMateData: Whether to skip metadata acquisition. Valid values:
0: do not skip.
1: skip.
Default value: 0		
        :type SkipMateData: int
        """
        self._InputInfo = None
        self._OutputStorage = None
        self._OutputDir = None
        self._SmartSubtitlesTask = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionContext = None
        self._ResourceId = None
        self._SkipMateData = None

    @property
    def InputInfo(self):
        r"""Path of the input file.
        :rtype: list of MediaInputInfo
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def OutputStorage(self):
        r"""Storage bucket for the output file. If it is left blank, the storage location in InputInfo will be inherited.
Note: When InputInfo.Type is URL, this parameter is required.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""Storage directory for the output file. It should start and end with a slash (/), such as `/movie/201907/`.
If left blank, it indicates that the directory is the same as the one where the file is located in InputInfo.
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def SmartSubtitlesTask(self):
        r"""Smart subtitle.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartSubtitlesTaskInput`
        """
        return self._SmartSubtitlesTask

    @SmartSubtitlesTask.setter
    def SmartSubtitlesTask(self, SmartSubtitlesTask):
        self._SmartSubtitlesTask = SmartSubtitlesTask

    @property
    def TaskNotifyConfig(self):
        r"""Event notification information of the task. If left blank, it indicates that no event notification will be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""Priority of the task flow. The higher the value, the higher the priority. The value range is from -10 to 10. If left blank, the default value is 0.
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionContext(self):
        r"""Source context, which is used to pass through the user request information. The callback for task flow status changes will return the value of this field. The maximum length is 1,000 characters.
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ResourceId(self):
        r"""Resource ID. Ensure the corresponding resource is in the enabled state. The default value is an account's primary resource ID.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def SkipMateData(self):
        r"""Whether to skip metadata acquisition. Valid values:
0: do not skip.
1: skip.
Default value: 0		
        :rtype: int
        """
        return self._SkipMateData

    @SkipMateData.setter
    def SkipMateData(self, SkipMateData):
        self._SkipMateData = SkipMateData


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = []
            for item in params.get("InputInfo"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._InputInfo.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("SmartSubtitlesTask") is not None:
            self._SmartSubtitlesTask = SmartSubtitlesTaskInput()
            self._SmartSubtitlesTask._deserialize(params.get("SmartSubtitlesTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionContext = params.get("SessionContext")
        self._ResourceId = params.get("ResourceId")
        self._SkipMateData = params.get("SkipMateData")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchProcessMediaResponse(AbstractModel):
    r"""BatchProcessMedia response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class BatchSmartSubtitlesResult(AbstractModel):
    r"""Smart subtitle task result.

    """

    def __init__(self):
        r"""
        :param _Input: Input information for smart subtitle tasks.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Input: :class:`tencentcloud.mps.v20190612.models.SmartSubtitleTaskResultInput`
        :param _Outputs: Output information for smart subtitle tasks.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Outputs: list of SmartSubtitleTaskBatchOutput
        """
        self._Input = None
        self._Outputs = None

    @property
    def Input(self):
        r"""Input information for smart subtitle tasks.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartSubtitleTaskResultInput`
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Outputs(self):
        r"""Output information for smart subtitle tasks.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of SmartSubtitleTaskBatchOutput
        """
        return self._Outputs

    @Outputs.setter
    def Outputs(self, Outputs):
        self._Outputs = Outputs


    def _deserialize(self, params):
        if params.get("Input") is not None:
            self._Input = SmartSubtitleTaskResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Outputs") is not None:
            self._Outputs = []
            for item in params.get("Outputs"):
                obj = SmartSubtitleTaskBatchOutput()
                obj._deserialize(item)
                self._Outputs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchSubTaskResult(AbstractModel):
    r"""Results of subtasks for a batch task.

    """

    def __init__(self):
        r"""
        :param _InputInfos: Input information for a batch task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type InputInfos: list of MediaInputInfo
        :param _Metadatas: Metadata of the original video.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Metadatas: list of MediaMetaData
        :param _SmartSubtitlesTaskResult: Execution result of the smart subtitle task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SmartSubtitlesTaskResult: :class:`tencentcloud.mps.v20190612.models.BatchSmartSubtitlesResult`
        """
        self._InputInfos = None
        self._Metadatas = None
        self._SmartSubtitlesTaskResult = None

    @property
    def InputInfos(self):
        r"""Input information for a batch task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of MediaInputInfo
        """
        return self._InputInfos

    @InputInfos.setter
    def InputInfos(self, InputInfos):
        self._InputInfos = InputInfos

    @property
    def Metadatas(self):
        r"""Metadata of the original video.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of MediaMetaData
        """
        return self._Metadatas

    @Metadatas.setter
    def Metadatas(self, Metadatas):
        self._Metadatas = Metadatas

    @property
    def SmartSubtitlesTaskResult(self):
        r"""Execution result of the smart subtitle task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.BatchSmartSubtitlesResult`
        """
        return self._SmartSubtitlesTaskResult

    @SmartSubtitlesTaskResult.setter
    def SmartSubtitlesTaskResult(self, SmartSubtitlesTaskResult):
        self._SmartSubtitlesTaskResult = SmartSubtitlesTaskResult


    def _deserialize(self, params):
        if params.get("InputInfos") is not None:
            self._InputInfos = []
            for item in params.get("InputInfos"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._InputInfos.append(obj)
        if params.get("Metadatas") is not None:
            self._Metadatas = []
            for item in params.get("Metadatas"):
                obj = MediaMetaData()
                obj._deserialize(item)
                self._Metadatas.append(obj)
        if params.get("SmartSubtitlesTaskResult") is not None:
            self._SmartSubtitlesTaskResult = BatchSmartSubtitlesResult()
            self._SmartSubtitlesTaskResult._deserialize(params.get("SmartSubtitlesTaskResult"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlindWatermarkInput(AbstractModel):
    r"""Digital watermark parameter type in the MPS task.

    """

    def __init__(self):
        r"""
        :param _Definition: Digital watermark template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Digital watermark template ID.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlindWatermarkTemplate(AbstractModel):
    r"""Digital watermark template details.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the digital watermark template.
        :type Definition: int
        :param _Type: Digital watermark type. Valid values: <li>blind-basic: basic copyright digital watermark;</li> <li>blind-nagra: NAGRA forensics watermark.</li>
        :type Type: str
        :param _Name: Digital watermark template name.
        :type Name: str
        :param _TextContent: Text content of the digital watermark template. The length cannot exceed 64 characters.
        :type TextContent: str
        :param _Comment: Description information of the digital watermark template.
        :type Comment: str
        :param _CreateTime: Creation time of the digital watermark template in [ISO date and time format](https://www.tencentcloud.comom/document/product/862/37710?from_cn_redirect=1#52).
        :type CreateTime: str
        :param _UpdateTime: Last modification time of the digital watermark template in [ISO date and time format](https://www.tencentcloud.comom/document/product/862/37710?from_cn_redirect=1#52).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._TextContent = None
        self._Comment = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        r"""Unique identifier of the digital watermark template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        r"""Digital watermark type. Valid values: <li>blind-basic: basic copyright digital watermark;</li> <li>blind-nagra: NAGRA forensics watermark.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Digital watermark template name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TextContent(self):
        r"""Text content of the digital watermark template. The length cannot exceed 64 characters.
        :rtype: str
        """
        return self._TextContent

    @TextContent.setter
    def TextContent(self, TextContent):
        self._TextContent = TextContent

    @property
    def Comment(self):
        r"""Description information of the digital watermark template.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CreateTime(self):
        r"""Creation time of the digital watermark template in [ISO date and time format](https://www.tencentcloud.comom/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modification time of the digital watermark template in [ISO date and time format](https://www.tencentcloud.comom/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._TextContent = params.get("TextContent")
        self._Comment = params.get("Comment")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfo(AbstractModel):
    r"""Control parameter of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    r"""Control parameter of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColorEnhanceConfig(AbstractModel):
    r"""Color enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>weak</li>
<li>normal</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""The strength. Valid values:
<li>weak</li>
<li>normal</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioItem(AbstractModel):
    r"""The audio element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: The media information of the element.
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _AudioOperations: The operations performed, such as muting.
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        r"""The media information of the element.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        r"""The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def AudioOperations(self):
        r"""The operations performed, such as muting.
        :rtype: list of ComposeAudioOperation
        """
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioOperation(AbstractModel):
    r"""The audio operations of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The operation type. Valid values:
<li>`Volume`: Volume adjustment. </li>
        :type Type: str
        :param _Volume:  The volume level. This parameter is valid if `Type` is `Volume`. Value range: 0–5. 
<li>If the parameter value is `0`, the video will be muted. </li>
<li>If the parameter value is smaller than 1, the volume will be reduced. </li>
<li>If the parameter value is `1`, the original volume will be kept. </li>
<li>If the parameter value is greater than 1, the volume will be increased. </li>
        :type Volume: float
        """
        self._Type = None
        self._Volume = None

    @property
    def Type(self):
        r"""The operation type. Valid values:
<li>`Volume`: Volume adjustment. </li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Volume(self):
        r""" The volume level. This parameter is valid if `Type` is `Volume`. Value range: 0–5. 
<li>If the parameter value is `0`, the video will be muted. </li>
<li>If the parameter value is smaller than 1, the volume will be reduced. </li>
<li>If the parameter value is `1`, the original volume will be kept. </li>
<li>If the parameter value is greater than 1, the volume will be increased. </li>
        :rtype: float
        """
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Volume = params.get("Volume")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioStream(AbstractModel):
    r"""The audio stream information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Codec: The codec of the audio stream. Valid values:
<li>`AAC`: AAC (default), which is used for the MP4 container. </li>
<li>`MP3`: MP3 codec, which is used for the MP3 container. </li>
        :type Codec: str
        :param _SampleRate: The sample rate (Hz) of the audio stream.
<li>16000 (default)</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
        :type SampleRate: int
        :param _AudioChannel: The number of sound channels. Valid values:
u200c<li>`1`: Mono. </li>
<li>`2`: Dual (default). </li>
        :type AudioChannel: int
        :param _Bitrate: Reference bitrate, in kbps. Value range: 26-10000.
If set, the encoder will try to encode at this bitrate.
If not set, the service will automatically adopt a suitable bitrate based on audio parameters.
        :type Bitrate: int
        """
        self._Codec = None
        self._SampleRate = None
        self._AudioChannel = None
        self._Bitrate = None

    @property
    def Codec(self):
        r"""The codec of the audio stream. Valid values:
<li>`AAC`: AAC (default), which is used for the MP4 container. </li>
<li>`MP3`: MP3 codec, which is used for the MP3 container. </li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def SampleRate(self):
        r"""The sample rate (Hz) of the audio stream.
<li>16000 (default)</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
        :rtype: int
        """
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        r"""The number of sound channels. Valid values:
u200c<li>`1`: Mono. </li>
<li>`2`: Dual (default). </li>
        :rtype: int
        """
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def Bitrate(self):
        r"""Reference bitrate, in kbps. Value range: 26-10000.
If set, the encoder will try to encode at this bitrate.
If not set, the service will automatically adopt a suitable bitrate based on audio parameters.
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._Bitrate = params.get("Bitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeCanvas(AbstractModel):
    r"""The canvas information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Color: The RGB value of the background color. The format is #RRGGBB, such as `#F0F0F0`. 
Default value: `#000000` (black).
        :type Color: str
        :param _Width: The canvas width (px), which is the width of the output video. Value range: 0–3840.  
The default value is `0`, which means that the canvas is as wide as the first video.
        :type Width: int
        :param _Height: The canvas height (px), which is the height of the output video. Value range: 0–3840.  
The default value is `0`, which means that the canvas is as high as the first video.
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        r"""The RGB value of the background color. The format is #RRGGBB, such as `#F0F0F0`. 
Default value: `#000000` (black).
        :rtype: str
        """
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        r"""The canvas width (px), which is the width of the output video. Value range: 0–3840.  
The default value is `0`, which means that the canvas is as wide as the first video.
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""The canvas height (px), which is the height of the output video. Value range: 0–3840.  
The default value is `0`, which means that the canvas is as high as the first video.
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeEmptyItem(AbstractModel):
    r"""The placeholder element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Duration: The element duration.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` indicates 3.5 seconds. </li>
        :type Duration: str
        """
        self._Duration = None

    @property
    def Duration(self):
        r"""The element duration.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` indicates 3.5 seconds. </li>
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageItem(AbstractModel):
    r"""The image element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: The media information of the element.
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: The horizontal distance of the element's center from the canvas origin. Two formats are supported:
<li>If the value ends with %, it specifies the distance as a percentage of the canvas width. For example, `10%` means that the distance is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type XPos: str
        :param _YPos: The vertical distance of the element's center from the canvas origin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the distance as a percentage of the canvas height. For example, `10%` means that the distance is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type YPos: str
        :param _Width: The width of the video segment. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas width. For example, `10%` means that the video width is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the video width is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Width: str
        :param _Height: The height of the element. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the video will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Height: str
        :param _ImageOperations: The image operations, such as image rotation.
        :type ImageOperations: list of ComposeImageOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None

    @property
    def SourceMedia(self):
        r"""The media information of the element.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        r"""The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        r"""The horizontal distance of the element's center from the canvas origin. Two formats are supported:
<li>If the value ends with %, it specifies the distance as a percentage of the canvas width. For example, `10%` means that the distance is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""The vertical distance of the element's center from the canvas origin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the distance as a percentage of the canvas height. For example, `10%` means that the distance is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        r"""The width of the video segment. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas width. For example, `10%` means that the video width is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the video width is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :rtype: str
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""The height of the element. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the video will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :rtype: str
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        r"""The image operations, such as image rotation.
        :rtype: list of ComposeImageOperation
        """
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageOperation(AbstractModel):
    r"""The image operations of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The type. Valid values:
u200c<li>`Rotate`: Image rotation. </li>
<li>`Flip`: Image flipping. </li>
        :type Type: str
        :param _RotateAngle: This is valid if `Type` is `Rotate`. The angle of rotation around the image center. Value range: 0–360.
        :type RotateAngle: float
        :param _FlipType: This is valid if `Type` is `Flip`. How to flip the image. Valid values:xa0
u200c<li>`Horizental`: Flip horizontally. </li>
<li>`Vertical`: Flip vertically. </li>
        :type FlipType: str
        """
        self._Type = None
        self._RotateAngle = None
        self._FlipType = None

    @property
    def Type(self):
        r"""The type. Valid values:
u200c<li>`Rotate`: Image rotation. </li>
<li>`Flip`: Image flipping. </li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RotateAngle(self):
        r"""This is valid if `Type` is `Rotate`. The angle of rotation around the image center. Value range: 0–360.
        :rtype: float
        """
        return self._RotateAngle

    @RotateAngle.setter
    def RotateAngle(self, RotateAngle):
        self._RotateAngle = RotateAngle

    @property
    def FlipType(self):
        r"""This is valid if `Type` is `Flip`. How to flip the image. Valid values:xa0
u200c<li>`Horizental`: Flip horizontally. </li>
<li>`Vertical`: Flip vertically. </li>
        :rtype: str
        """
        return self._FlipType

    @FlipType.setter
    def FlipType(self, FlipType):
        self._FlipType = FlipType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._RotateAngle = params.get("RotateAngle")
        self._FlipType = params.get("FlipType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaConfig(AbstractModel):
    r"""The information of a video editing/compositing task.

    The figure below outlines the relationships among tracks, elements, and the timeline.

    ![image](https://ie-mps-1258344699.cos.ap-nanjing.tencentcos.cn/common/cloud/EditMedia-Compose-Track-Item-en.png)

    """

    def __init__(self):
        r"""
        :param _TargetInfo: The information of the output video.
        :type TargetInfo: :class:`tencentcloud.mps.v20190612.models.ComposeTargetInfo`
        :param _Canvas: The canvas information of the output video.
        :type Canvas: :class:`tencentcloud.mps.v20190612.models.ComposeCanvas`
        :param _Styles: The global styles. This parameter is used together with `Tracks` to specify styles, such as the subtitle style.
        :type Styles: list of ComposeStyles
        :param _Tracks: The information of media tracks (consisting of video, audio, image, and text elements) used to composite the video. About tracks and the timeline:
<ul><li>The timeline of a track is the same as the timeline of the output video. </li><li>The elements of different tracks are overlaid at the same time point in the timeline.</li><ul><li>Video, image, and text elements are overlaid according to their track number, with the first track on top. </li><li>Audio elements are mixed. </li></ul></ul>Note: The different elements of the same track cannot be overlaid (except subtitles).
        :type Tracks: list of ComposeMediaTrack
        """
        self._TargetInfo = None
        self._Canvas = None
        self._Styles = None
        self._Tracks = None

    @property
    def TargetInfo(self):
        r"""The information of the output video.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTargetInfo`
        """
        return self._TargetInfo

    @TargetInfo.setter
    def TargetInfo(self, TargetInfo):
        self._TargetInfo = TargetInfo

    @property
    def Canvas(self):
        r"""The canvas information of the output video.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeCanvas`
        """
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Styles(self):
        r"""The global styles. This parameter is used together with `Tracks` to specify styles, such as the subtitle style.
        :rtype: list of ComposeStyles
        """
        return self._Styles

    @Styles.setter
    def Styles(self, Styles):
        self._Styles = Styles

    @property
    def Tracks(self):
        r"""The information of media tracks (consisting of video, audio, image, and text elements) used to composite the video. About tracks and the timeline:
<ul><li>The timeline of a track is the same as the timeline of the output video. </li><li>The elements of different tracks are overlaid at the same time point in the timeline.</li><ul><li>Video, image, and text elements are overlaid according to their track number, with the first track on top. </li><li>Audio elements are mixed. </li></ul></ul>Note: The different elements of the same track cannot be overlaid (except subtitles).
        :rtype: list of ComposeMediaTrack
        """
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks


    def _deserialize(self, params):
        if params.get("TargetInfo") is not None:
            self._TargetInfo = ComposeTargetInfo()
            self._TargetInfo._deserialize(params.get("TargetInfo"))
        if params.get("Canvas") is not None:
            self._Canvas = ComposeCanvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Styles") is not None:
            self._Styles = []
            for item in params.get("Styles"):
                obj = ComposeStyles()
                obj._deserialize(item)
                self._Styles.append(obj)
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = ComposeMediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaItem(AbstractModel):
    r"""The element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The element type. Valid values:
<li>`Video` </li>
<li>`Audio` </li>
<li>`Image` </li>
<li>`Transition` </li>
<li>`Subtitle` </li>
<li>`Empty` </li>
        :type Type: str
        :param _Video: The information of the video element, which is valid if `Type` is `Video`.
        :type Video: :class:`tencentcloud.mps.v20190612.models.ComposeVideoItem`
        :param _Audio: The information of the audio element, which is valid if `Type` is `Audio`.
        :type Audio: :class:`tencentcloud.mps.v20190612.models.ComposeAudioItem`
        :param _Image: The information of the image element, which is valid if `Type` is `Image`.
        :type Image: :class:`tencentcloud.mps.v20190612.models.ComposeImageItem`
        :param _Transition: The information of the transition element, which is valid if `Type` is `Transition`.
        :type Transition: :class:`tencentcloud.mps.v20190612.models.ComposeTransitionItem`
        :param _Subtitle: The information of the subtitle element, which is valid if `Type` is `Subtitle`.
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleItem`
        :param _Empty: The information of the empty element, which is valid if `Type` is `Empty`. An empty element is used as a placeholder in the timeline.
        :type Empty: :class:`tencentcloud.mps.v20190612.models.ComposeEmptyItem`
        """
        self._Type = None
        self._Video = None
        self._Audio = None
        self._Image = None
        self._Transition = None
        self._Subtitle = None
        self._Empty = None

    @property
    def Type(self):
        r"""The element type. Valid values:
<li>`Video` </li>
<li>`Audio` </li>
<li>`Image` </li>
<li>`Transition` </li>
<li>`Subtitle` </li>
<li>`Empty` </li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Video(self):
        r"""The information of the video element, which is valid if `Type` is `Video`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeVideoItem`
        """
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        r"""The information of the audio element, which is valid if `Type` is `Audio`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeAudioItem`
        """
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Image(self):
        r"""The information of the image element, which is valid if `Type` is `Image`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeImageItem`
        """
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image

    @property
    def Transition(self):
        r"""The information of the transition element, which is valid if `Type` is `Transition`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTransitionItem`
        """
        return self._Transition

    @Transition.setter
    def Transition(self, Transition):
        self._Transition = Transition

    @property
    def Subtitle(self):
        r"""The information of the subtitle element, which is valid if `Type` is `Subtitle`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleItem`
        """
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def Empty(self):
        r"""The information of the empty element, which is valid if `Type` is `Empty`. An empty element is used as a placeholder in the timeline.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeEmptyItem`
        """
        return self._Empty

    @Empty.setter
    def Empty(self, Empty):
        self._Empty = Empty


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Video") is not None:
            self._Video = ComposeVideoItem()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = ComposeAudioItem()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Image") is not None:
            self._Image = ComposeImageItem()
            self._Image._deserialize(params.get("Image"))
        if params.get("Transition") is not None:
            self._Transition = ComposeTransitionItem()
            self._Transition._deserialize(params.get("Transition"))
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleItem()
            self._Subtitle._deserialize(params.get("Subtitle"))
        if params.get("Empty") is not None:
            self._Empty = ComposeEmptyItem()
            self._Empty._deserialize(params.get("Empty"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTrack(AbstractModel):
    r"""The track information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: Track type. Valid values: <ul><li>Video: video track. It can consist of the following elements:</li><ul><li>Video elements</li><li>Image elements</li><li>Transition elements</li><li>Empty elements</li></ul><li>Audio: audio track. It can consist of the following elements:</li><ul><li>Audio elements</li><li>Transition elements</li><li>Empty elements</li></ul><li>Title: text track. It can consist of the following elements:</li><ul><li>Subtitle elements</li></ul></ul>
        :type Type: str
        :param _Items: The elements of a track.
        :type Items: list of ComposeMediaItem
        """
        self._Type = None
        self._Items = None

    @property
    def Type(self):
        r"""Track type. Valid values: <ul><li>Video: video track. It can consist of the following elements:</li><ul><li>Video elements</li><li>Image elements</li><li>Transition elements</li><li>Empty elements</li></ul><li>Audio: audio track. It can consist of the following elements:</li><ul><li>Audio elements</li><li>Transition elements</li><li>Empty elements</li></ul><li>Title: text track. It can consist of the following elements:</li><ul><li>Subtitle elements</li></ul></ul>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Items(self):
        r"""The elements of a track.
        :rtype: list of ComposeMediaItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ComposeMediaItem()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSourceMedia(AbstractModel):
    r"""The material source of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _FileId: The material ID, which can be found in `FileInfos`.
        :type FileId: str
        :param _StartTime: The start time of the material. The following two formats are supported.
<li>If the value of this parameter ends with `s`, it specifies the time in seconds. For example, `3.5s` indicates the time when 3.5 seconds of the material elapses.</li>
u200c<li>If the value of this parameter ends with `%`, it specifies the time as a percentage of the material's duration. For example, `10%` indicates the time when 10% of the material's duration elapses. </li>
Default value: `0s`.
        :type StartTime: str
        :param _EndTime: The end time of the material. This parameter and `StartTime` determine which time segment of the material is used. The following two formats are supported:
<li>If the value of this parameter ends with `s`, it specifies the time in seconds. For example, `3.5s` indicates the time when 3.5 seconds of the material elapses.</li>
u200c<li>If the value of this parameter ends with `%`, it specifies the time as a percentage of the material's duration. For example, `10%` indicates the time when 10% of the material's duration elapses. </li>
If the track duration is set, the default value is `StartTime` plus the track duration. If not, the default value is `StartTime` plus 1 second.
Note: `EndTime` must be at least 0.02 seconds later than `StartTime`.

        :type EndTime: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FileId(self):
        r"""The material ID, which can be found in `FileInfos`.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        r"""The start time of the material. The following two formats are supported.
<li>If the value of this parameter ends with `s`, it specifies the time in seconds. For example, `3.5s` indicates the time when 3.5 seconds of the material elapses.</li>
u200c<li>If the value of this parameter ends with `%`, it specifies the time as a percentage of the material's duration. For example, `10%` indicates the time when 10% of the material's duration elapses. </li>
Default value: `0s`.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""The end time of the material. This parameter and `StartTime` determine which time segment of the material is used. The following two formats are supported:
<li>If the value of this parameter ends with `s`, it specifies the time in seconds. For example, `3.5s` indicates the time when 3.5 seconds of the material elapses.</li>
u200c<li>If the value of this parameter ends with `%`, it specifies the time as a percentage of the material's duration. For example, `10%` indicates the time when 10% of the material's duration elapses. </li>
If the track duration is set, the default value is `StartTime` plus the track duration. If not, the default value is `StartTime` plus 1 second.
Note: `EndTime` must be at least 0.02 seconds later than `StartTime`.

        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeStyles(AbstractModel):
    r"""The style information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Id: The style ID, which identifies an element style.
Note: The style ID can be up to 32 characters long and can contain letters, digits, and special characters -_
        :type Id: str
        :param _Type: The type. Valid values:
<li>`Subtitle`: The subtitle style. </li>
        :type Type: str
        :param _Subtitle: The subtitle style details. This parameter is valid if `Type` is `Subtitle`.
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleStyle`
        """
        self._Id = None
        self._Type = None
        self._Subtitle = None

    @property
    def Id(self):
        r"""The style ID, which identifies an element style.
Note: The style ID can be up to 32 characters long and can contain letters, digits, and special characters -_
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        r"""The type. Valid values:
<li>`Subtitle`: The subtitle style. </li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        r"""The subtitle style details. This parameter is valid if `Type` is `Subtitle`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleStyle`
        """
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleStyle()
            self._Subtitle._deserialize(params.get("Subtitle"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleItem(AbstractModel):
    r"""The subtitle element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _StyleId: The subtitle style ID, which corresponds to the `Id` field of `ComposeStyles`.
        :type StyleId: str
        :param _Text: Subtitle text. note: long text may exceed the frame. recommend using \n for line breaks.
        :type Text: str
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.	
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        self._StyleId = None
        self._Text = None
        self._TrackTime = None

    @property
    def StyleId(self):
        r"""The subtitle style ID, which corresponds to the `Id` field of `ComposeStyles`.
        :rtype: str
        """
        return self._StyleId

    @StyleId.setter
    def StyleId(self, StyleId):
        self._StyleId = StyleId

    @property
    def Text(self):
        r"""Subtitle text. note: long text may exceed the frame. recommend using \n for line breaks.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def TrackTime(self):
        r"""The time of the element in the timeline. If this is not specified, the element will follow the previous element.	
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime


    def _deserialize(self, params):
        self._StyleId = params.get("StyleId")
        self._Text = params.get("Text")
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleStyle(AbstractModel):
    r"""The subtitle style of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Height: The subtitle height. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
The default value is the value of `FontSize`.
        :type Height: str
        :param _MarginBottom: The bottom margin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the margin as a percentage of the canvas height. For example, `10%` means that the margin is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the margin in pixels. For example, `100px` means that the margin is 100 pixels. </li>
Default value: `0px`.
        :type MarginBottom: str
        :param _FontType: The font type. Valid values:
<li>`SimHei`(default): Chinese font Heiti. </li>
<Li>`SimSun`: Chinese font Songti. </li>
        :type FontType: str
        :param _FontSize: The font size. Two formats are supported:
u200c<li>If the value ends with %, it specifies the size as a percentage of the canvas height. For example, `10%` means that the size is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the size in pixels. For example, `100px` means that the size is 100 pixels. </li>
Default value: `2%`.
        :type FontSize: str
        :param _FontBold: Whether to bold the text (some fonts may not support bold). Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type FontBold: int
        :param _FontItalic: Whether to italicize the text (some fonts may not support italics). Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type FontItalic: int
        :param _FontColor: The font color (#RRGGBBAA).  
Default value: `0x000000FF` (black).  
Note: `AA` in the color notation defines the opacity of the color. It's optional.

        :type FontColor: str
        :param _FontAlign: The text alignment. Valid values:
<li>`Center`(default) </li>
<li>`Left` </li>
<li>`Right` </li>
        :type FontAlign: str
        :param _FontAlignMargin: The margin for left/right align.
<li>If `FontAlign` is `Left`, this parameter specifies the left margin of the subtitles. </li>
<li>If `FontAlign` is `Right`, this parameter specifies the right margin of the subtitles. </li>
Two formats are supported:
u200c<li>If the value ends with %, it specifies the margin as a percentage of the canvas width. For example, `10%` means that the margin is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the margin in pixels. For example, `100px` means that the margin is 100 pixels. </li>
        :type FontAlignMargin: str
        :param _BorderWidth: The subtitle border width. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas height. For example, `10%` means that the width is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the width is 100 pixels. </li>
The default value is `0`, which means the subtitles will have no borders.
        :type BorderWidth: str
        :param _BorderColor: The border color, whose format is the same as that for `FontColor`. This parameter is valid if `BorderWidth` is not `0`.
        :type BorderColor: str
        :param _BottomColor: The text background color, whose format is the same as that for `FontColor`.  
The default value is an empty string, which means the subtitles will not have a background color.
        :type BottomColor: str
        """
        self._Height = None
        self._MarginBottom = None
        self._FontType = None
        self._FontSize = None
        self._FontBold = None
        self._FontItalic = None
        self._FontColor = None
        self._FontAlign = None
        self._FontAlignMargin = None
        self._BorderWidth = None
        self._BorderColor = None
        self._BottomColor = None

    @property
    def Height(self):
        r"""The subtitle height. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
The default value is the value of `FontSize`.
        :rtype: str
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def MarginBottom(self):
        r"""The bottom margin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the margin as a percentage of the canvas height. For example, `10%` means that the margin is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the margin in pixels. For example, `100px` means that the margin is 100 pixels. </li>
Default value: `0px`.
        :rtype: str
        """
        return self._MarginBottom

    @MarginBottom.setter
    def MarginBottom(self, MarginBottom):
        self._MarginBottom = MarginBottom

    @property
    def FontType(self):
        r"""The font type. Valid values:
<li>`SimHei`(default): Chinese font Heiti. </li>
<Li>`SimSun`: Chinese font Songti. </li>
        :rtype: str
        """
        return self._FontType

    @FontType.setter
    def FontType(self, FontType):
        self._FontType = FontType

    @property
    def FontSize(self):
        r"""The font size. Two formats are supported:
u200c<li>If the value ends with %, it specifies the size as a percentage of the canvas height. For example, `10%` means that the size is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the size in pixels. For example, `100px` means that the size is 100 pixels. </li>
Default value: `2%`.
        :rtype: str
        """
        return self._FontSize

    @FontSize.setter
    def FontSize(self, FontSize):
        self._FontSize = FontSize

    @property
    def FontBold(self):
        r"""Whether to bold the text (some fonts may not support bold). Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :rtype: int
        """
        return self._FontBold

    @FontBold.setter
    def FontBold(self, FontBold):
        self._FontBold = FontBold

    @property
    def FontItalic(self):
        r"""Whether to italicize the text (some fonts may not support italics). Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :rtype: int
        """
        return self._FontItalic

    @FontItalic.setter
    def FontItalic(self, FontItalic):
        self._FontItalic = FontItalic

    @property
    def FontColor(self):
        r"""The font color (#RRGGBBAA).  
Default value: `0x000000FF` (black).  
Note: `AA` in the color notation defines the opacity of the color. It's optional.

        :rtype: str
        """
        return self._FontColor

    @FontColor.setter
    def FontColor(self, FontColor):
        self._FontColor = FontColor

    @property
    def FontAlign(self):
        r"""The text alignment. Valid values:
<li>`Center`(default) </li>
<li>`Left` </li>
<li>`Right` </li>
        :rtype: str
        """
        return self._FontAlign

    @FontAlign.setter
    def FontAlign(self, FontAlign):
        self._FontAlign = FontAlign

    @property
    def FontAlignMargin(self):
        r"""The margin for left/right align.
<li>If `FontAlign` is `Left`, this parameter specifies the left margin of the subtitles. </li>
<li>If `FontAlign` is `Right`, this parameter specifies the right margin of the subtitles. </li>
Two formats are supported:
u200c<li>If the value ends with %, it specifies the margin as a percentage of the canvas width. For example, `10%` means that the margin is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the margin in pixels. For example, `100px` means that the margin is 100 pixels. </li>
        :rtype: str
        """
        return self._FontAlignMargin

    @FontAlignMargin.setter
    def FontAlignMargin(self, FontAlignMargin):
        self._FontAlignMargin = FontAlignMargin

    @property
    def BorderWidth(self):
        r"""The subtitle border width. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas height. For example, `10%` means that the width is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the width is 100 pixels. </li>
The default value is `0`, which means the subtitles will have no borders.
        :rtype: str
        """
        return self._BorderWidth

    @BorderWidth.setter
    def BorderWidth(self, BorderWidth):
        self._BorderWidth = BorderWidth

    @property
    def BorderColor(self):
        r"""The border color, whose format is the same as that for `FontColor`. This parameter is valid if `BorderWidth` is not `0`.
        :rtype: str
        """
        return self._BorderColor

    @BorderColor.setter
    def BorderColor(self, BorderColor):
        self._BorderColor = BorderColor

    @property
    def BottomColor(self):
        r"""The text background color, whose format is the same as that for `FontColor`.  
The default value is an empty string, which means the subtitles will not have a background color.
        :rtype: str
        """
        return self._BottomColor

    @BottomColor.setter
    def BottomColor(self, BottomColor):
        self._BottomColor = BottomColor


    def _deserialize(self, params):
        self._Height = params.get("Height")
        self._MarginBottom = params.get("MarginBottom")
        self._FontType = params.get("FontType")
        self._FontSize = params.get("FontSize")
        self._FontBold = params.get("FontBold")
        self._FontItalic = params.get("FontItalic")
        self._FontColor = params.get("FontColor")
        self._FontAlign = params.get("FontAlign")
        self._FontAlignMargin = params.get("FontAlignMargin")
        self._BorderWidth = params.get("BorderWidth")
        self._BorderColor = params.get("BorderColor")
        self._BottomColor = params.get("BottomColor")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTargetInfo(AbstractModel):
    r"""The output video information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Container: The container. Valid values:
<li>`mp4` (default), for video files. </li>
<li>`mp3`, for audio files. </li>
        :type Container: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type RemoveAudio: int
        :param _VideoStream: The information of the output video stream.
        :type VideoStream: :class:`tencentcloud.mps.v20190612.models.ComposeVideoStream`
        :param _AudioStream: The information of the output audio stream.
        :type AudioStream: :class:`tencentcloud.mps.v20190612.models.ComposeAudioStream`
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoStream = None
        self._AudioStream = None

    @property
    def Container(self):
        r"""The container. Valid values:
<li>`mp4` (default), for video files. </li>
<li>`mp3`, for audio files. </li>
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        r"""Whether to remove video data. Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""Whether to remove audio data. Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoStream(self):
        r"""The information of the output video stream.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeVideoStream`
        """
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        r"""The information of the output audio stream.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeAudioStream`
        """
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoStream") is not None:
            self._VideoStream = ComposeVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = ComposeAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTrackTime(AbstractModel):
    r"""The time information of an element on the output video track of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Start: The time when the element starts on the track.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` indicates the time when 3.5 seconds of the video elapses.</li>
Note: If this parameter is not specified, the start time will be the end time of the previous element. Therefore, you can also use the placeholder parameter `ComposeEmptyItem` to configure the start time.
        :type Start: str
        :param _Duration: The element duration.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` means 3.5 seconds.</li>
The default value is the material duration, which is determined by `EndTime` and `StartTime` of `ComposeSourceMedia`. If `ComposeSourceMedia` is not specified, the duration will be 1 second.
        :type Duration: str
        """
        self._Start = None
        self._Duration = None

    @property
    def Start(self):
        r"""The time when the element starts on the track.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` indicates the time when 3.5 seconds of the video elapses.</li>
Note: If this parameter is not specified, the start time will be the end time of the previous element. Therefore, you can also use the placeholder parameter `ComposeEmptyItem` to configure the start time.
        :rtype: str
        """
        return self._Start

    @Start.setter
    def Start(self, Start):
        self._Start = Start

    @property
    def Duration(self):
        r"""The element duration.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` means 3.5 seconds.</li>
The default value is the material duration, which is determined by `EndTime` and `StartTime` of `ComposeSourceMedia`. If `ComposeSourceMedia` is not specified, the duration will be 1 second.
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Start = params.get("Start")
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionItem(AbstractModel):
    r"""The transition element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Duration: The element duration. <li>The value of this parameter ends with `s`, which means seconds. For example, `3s` indicates 3 seconds. </li>
Default value: `1s`.
Note
<li>The number before `s` must be an integer. Non-integers will be rounded down to the nearest integer. </li>
<li>The transition element must be between two non-empty elements. </li>
<li>The duration of the transition element must be shorter than that of the preceding element and the following element. </li>
u200c<li>The start time of the following element on the track will be automatically changed to the end time of the preceding element minus the duration of the transition element. </li>
        :type Duration: str
        :param _Transitions: The transition effects.
The default transition effect is fade.
Note: You can add at most one image transition and one audio transition.
        :type Transitions: list of ComposeTransitionOperation
        """
        self._Duration = None
        self._Transitions = None

    @property
    def Duration(self):
        r"""The element duration. <li>The value of this parameter ends with `s`, which means seconds. For example, `3s` indicates 3 seconds. </li>
Default value: `1s`.
Note
<li>The number before `s` must be an integer. Non-integers will be rounded down to the nearest integer. </li>
<li>The transition element must be between two non-empty elements. </li>
<li>The duration of the transition element must be shorter than that of the preceding element and the following element. </li>
u200c<li>The start time of the following element on the track will be automatically changed to the end time of the preceding element minus the duration of the transition element. </li>
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Transitions(self):
        r"""The transition effects.
The default transition effect is fade.
Note: You can add at most one image transition and one audio transition.
        :rtype: list of ComposeTransitionOperation
        """
        return self._Transitions

    @Transitions.setter
    def Transitions(self, Transitions):
        self._Transitions = Transitions


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        if params.get("Transitions") is not None:
            self._Transitions = []
            for item in params.get("Transitions"):
                obj = ComposeTransitionOperation()
                obj._deserialize(item)
                self._Transitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionOperation(AbstractModel):
    r"""The transition information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The transition type.

The image transition, which connects two video segments.
<li>`ImageFadeInFadeOut` </li>
u200c<li>`BowTieHorizontal` </li>
u200c<li>`BowTieVertical` </li>
u200c<li>`ButterflyWaveScrawler` </li>
<li>`Cannabisleaf` </li>
<li>`Circle` </li>
<li>`CircleCrop` </li>
u200c<li>`Circleopen` </li>
<li>`Crosswarp` </li>
<li>`Cube` </li>
<li>`DoomScreenTransition` </li>
<li>`Doorway` </li>
<li>`Dreamy` </li>
<li>`DreamyZoom` </li>
<li>`FilmBurn` </li>
<li>`GlitchMemories` </li>
<li>`Heart` </li>
<li>`InvertedPageCurl` </li>
<li>`Luma` </li>
<li>`Mosaic` </li>
<li>`Pinwheel` </li>
<li>`PolarFunction` </li>
<li>`PolkaDotsCurtain` </li>
<li>`Radial` </li>
<li>`RotateScaleFade` </li>
<li>`Squeeze` </li>
<li>`Swap` </li>
<li>`Swirl` </li>
<li>`UndulatingBurnOutSwirl` </li>
<li>`Windowblinds` </li>
<li>`WipeDown` </li>
<li>`WipeLeft` </li>
<li>`WipeRight` </li>
<li>`WipeUp` </li>
<li>`ZoomInCircles` </li> 
The audio transition, which connects two audio segments.
<li>`AudioFadeInFadeOut` </li>
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        r"""The transition type.

The image transition, which connects two video segments.
<li>`ImageFadeInFadeOut` </li>
u200c<li>`BowTieHorizontal` </li>
u200c<li>`BowTieVertical` </li>
u200c<li>`ButterflyWaveScrawler` </li>
<li>`Cannabisleaf` </li>
<li>`Circle` </li>
<li>`CircleCrop` </li>
u200c<li>`Circleopen` </li>
<li>`Crosswarp` </li>
<li>`Cube` </li>
<li>`DoomScreenTransition` </li>
<li>`Doorway` </li>
<li>`Dreamy` </li>
<li>`DreamyZoom` </li>
<li>`FilmBurn` </li>
<li>`GlitchMemories` </li>
<li>`Heart` </li>
<li>`InvertedPageCurl` </li>
<li>`Luma` </li>
<li>`Mosaic` </li>
<li>`Pinwheel` </li>
<li>`PolarFunction` </li>
<li>`PolkaDotsCurtain` </li>
<li>`Radial` </li>
<li>`RotateScaleFade` </li>
<li>`Squeeze` </li>
<li>`Swap` </li>
<li>`Swirl` </li>
<li>`UndulatingBurnOutSwirl` </li>
<li>`Windowblinds` </li>
<li>`WipeDown` </li>
<li>`WipeLeft` </li>
<li>`WipeRight` </li>
<li>`WipeUp` </li>
<li>`ZoomInCircles` </li> 
The audio transition, which connects two audio segments.
<li>`AudioFadeInFadeOut` </li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoItem(AbstractModel):
    r"""The video element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: The media information of the element.
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: The horizontal distance of the element's center from the canvas origin. Two formats are supported:
<li>If the value ends with %, it specifies the distance as a percentage of the canvas width. For example, `10%` means that the distance is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type XPos: str
        :param _YPos: The vertical distance of the element's center from the canvas origin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the distance as a percentage of the canvas height. For example, `10%` means that the distance is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type YPos: str
        :param _Width: The width of the video segment. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas width. For example, `10%` means that the video width is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the video width is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Width: str
        :param _Height: The height of the element. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Height: str
        :param _ImageOperations: The image operations, such as image rotation.
        :type ImageOperations: list of ComposeImageOperation
        :param _AudioOperations: The audio operations, such as muting.
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        r"""The media information of the element.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        """
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        r"""The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        r"""The horizontal distance of the element's center from the canvas origin. Two formats are supported:
<li>If the value ends with %, it specifies the distance as a percentage of the canvas width. For example, `10%` means that the distance is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""The vertical distance of the element's center from the canvas origin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the distance as a percentage of the canvas height. For example, `10%` means that the distance is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        r"""The width of the video segment. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas width. For example, `10%` means that the video width is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the video width is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :rtype: str
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""The height of the element. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :rtype: str
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        r"""The image operations, such as image rotation.
        :rtype: list of ComposeImageOperation
        """
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations

    @property
    def AudioOperations(self):
        r"""The audio operations, such as muting.
        :rtype: list of ComposeAudioOperation
        """
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoStream(AbstractModel):
    r"""The video stream information of a video edit/compositing task.

    """

    def __init__(self):
        r"""
        :param _Codec: The codec. Valid values:
<li>`H.264` (default) </li>
        :type Codec: str
        :param _Fps: The video frame rate (Hz). Value range: 0–60.  
The default value is `0`, which means that the frame rate will be the same as that of the first video.
        :type Fps: int
        :param _Bitrate: Reference bitrate, in kbps. Value range: 50-35000.
If set, the encoder will try to encode at this bitrate.
If not set, the service will automatically adopt a suitable bitrate based on the complexity of an image.
        :type Bitrate: int
        """
        self._Codec = None
        self._Fps = None
        self._Bitrate = None

    @property
    def Codec(self):
        r"""The codec. Valid values:
<li>`H.264` (default) </li>
        :rtype: str
        """
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Fps(self):
        r"""The video frame rate (Hz). Value range: 0–60.  
The default value is `0`, which means that the frame rate will be the same as that of the first video.
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Bitrate(self):
        r"""Reference bitrate, in kbps. Value range: 50-35000.
If set, the encoder will try to encode at this bitrate.
If not set, the service will automatically adopt a suitable bitrate based on the complexity of an image.
        :rtype: int
        """
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Fps = params.get("Fps")
        self._Bitrate = params.get("Bitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerDiagnoseResultItem(AbstractModel):
    r"""Container format diagnostic result.

    """

    def __init__(self):
        r"""
        :param _Category: Diagnosed exception category. Valid values:
DecodeParamException: decoding parameter exception.
TimeStampException: timestamp exception.
FrameException: frame rate exception.
StreamStatusException: stream status exception.
StreamInfo: stream information exception.
StreamAbnormalCharacteristics: stream characteristics exception.
DecodeException: decoding exception.
HLSRequirements: HLS format exception.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Category: str
        :param _Type: Diagnosed specific exception type. Valid values:

VideoResolutionChanged: video resolution change.
AudioSampleRateChanged: audio sample rate change.
AudioChannelsChanged: audio channel quantity change.
ParameterSetsChanged: stream parameter set information change.
DarOrSarInvalid: video aspect ratio exception.
TimestampFallback: DTS timestamp rollback.
DtsJitter: DTS jitter too high.
PtsJitter: PTS jitter too high.
AACDurationDeviation: improper AAC frame timestamp interval.
AudioDroppingFrames: audio frame dropping.
VideoDroppingFrames: video frame dropping.
AVTimestampInterleave: improper audio-video interleaving.
PtsLessThanDts: PTS less than DTS for media streams.
ReceiveFpsJitter: significant jitter in the network receive frame rate.
ReceiveFpsTooSmall: network receive video frame rate too low.
FpsJitter: significant jitter in the stream frame rate calculated via PTS.
StreamOpenFailed: stream open failure.
StreamEnd: stream end.
StreamParseFailed: stream parsing failure.
VideoFirstFrameNotIdr: first frame not an IDR frame.
StreamNALUError: NALU start code error.
TsStreamNoAud: no AUD NALU in the H26x stream of MPEG-TS.
AudioStreamLack: no audio stream.
VideoStreamLack: no video stream.
LackAudioRecover: missing audio stream recovery.
LackVideoRecover: missing video stream recovery.
VideoBitrateOutofRange: video stream bitrate (kbps) out of range.
AudioBitrateOutofRange: audio stream bitrate (kbps) out of range.
VideoDecodeFailed: video decoding error.
AudioDecodeFailed: audio decoding error.
AudioOutOfPhase: opposite phase in dual-channel audio.
VideoDuplicatedFrame: duplicate frames in video streams.
AudioDuplicatedFrame: duplicate frames in audio streams.
VideoRotation: video rotation.
TsMultiPrograms: multiple programs in MPEG2-TS streams
Mp4InvalidCodecFourcc: codec FourCC in MP4 not meeting Apple HLS requirements.
HLSBadM3u8Format: invalid M3U8 file.
HLSInvalidMasterM3u8: invalid main M3U8 file.
HLSInvalidMediaM3u8: invalid media M3U8 file.
HLSMasterM3u8Recommended: parameters recommended by standards missing in main M3U8.
HLSMediaM3u8Recommended: parameters recommended by standards missing in media M3U8.
HLSMediaM3u8DiscontinuityExist: EXT-X-DISCONTINUITY in media M3U8.
HLSMediaSegmentsStreamNumChange: changed number of streams in segments.
HLSMediaSegmentsPTSJitterDeviation: PTS jumps between segments without EXT-X-DISCONTINUITY.
HLSMediaSegmentsDTSJitterDeviation: DTS jumps between segments without EXT-X-DISCONTINUITY.
TimecodeTrackExist: TMCD track in MP4.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _SeverityLevel: Diagnosed exception level. Valid values:
Fatal: affecting subsequent playback and parsing.
Error: may affect playback.
Warning: potential risk, which may not necessarily affect playback.
Notice: important stream information.
Info: general stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SeverityLevel: str
        :param _DateTimeSet: Timestamp of warning, in the format of 2022-12-25T13:14:16Z.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DateTimeSet: list of str
        :param _TimestampSet: Timestamp.

Note: This field may return null, indicating that no valid values can be obtained.
        :type TimestampSet: list of float
        """
        self._Category = None
        self._Type = None
        self._SeverityLevel = None
        self._DateTimeSet = None
        self._TimestampSet = None

    @property
    def Category(self):
        r"""Diagnosed exception category. Valid values:
DecodeParamException: decoding parameter exception.
TimeStampException: timestamp exception.
FrameException: frame rate exception.
StreamStatusException: stream status exception.
StreamInfo: stream information exception.
StreamAbnormalCharacteristics: stream characteristics exception.
DecodeException: decoding exception.
HLSRequirements: HLS format exception.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        r"""Diagnosed specific exception type. Valid values:

VideoResolutionChanged: video resolution change.
AudioSampleRateChanged: audio sample rate change.
AudioChannelsChanged: audio channel quantity change.
ParameterSetsChanged: stream parameter set information change.
DarOrSarInvalid: video aspect ratio exception.
TimestampFallback: DTS timestamp rollback.
DtsJitter: DTS jitter too high.
PtsJitter: PTS jitter too high.
AACDurationDeviation: improper AAC frame timestamp interval.
AudioDroppingFrames: audio frame dropping.
VideoDroppingFrames: video frame dropping.
AVTimestampInterleave: improper audio-video interleaving.
PtsLessThanDts: PTS less than DTS for media streams.
ReceiveFpsJitter: significant jitter in the network receive frame rate.
ReceiveFpsTooSmall: network receive video frame rate too low.
FpsJitter: significant jitter in the stream frame rate calculated via PTS.
StreamOpenFailed: stream open failure.
StreamEnd: stream end.
StreamParseFailed: stream parsing failure.
VideoFirstFrameNotIdr: first frame not an IDR frame.
StreamNALUError: NALU start code error.
TsStreamNoAud: no AUD NALU in the H26x stream of MPEG-TS.
AudioStreamLack: no audio stream.
VideoStreamLack: no video stream.
LackAudioRecover: missing audio stream recovery.
LackVideoRecover: missing video stream recovery.
VideoBitrateOutofRange: video stream bitrate (kbps) out of range.
AudioBitrateOutofRange: audio stream bitrate (kbps) out of range.
VideoDecodeFailed: video decoding error.
AudioDecodeFailed: audio decoding error.
AudioOutOfPhase: opposite phase in dual-channel audio.
VideoDuplicatedFrame: duplicate frames in video streams.
AudioDuplicatedFrame: duplicate frames in audio streams.
VideoRotation: video rotation.
TsMultiPrograms: multiple programs in MPEG2-TS streams
Mp4InvalidCodecFourcc: codec FourCC in MP4 not meeting Apple HLS requirements.
HLSBadM3u8Format: invalid M3U8 file.
HLSInvalidMasterM3u8: invalid main M3U8 file.
HLSInvalidMediaM3u8: invalid media M3U8 file.
HLSMasterM3u8Recommended: parameters recommended by standards missing in main M3U8.
HLSMediaM3u8Recommended: parameters recommended by standards missing in media M3U8.
HLSMediaM3u8DiscontinuityExist: EXT-X-DISCONTINUITY in media M3U8.
HLSMediaSegmentsStreamNumChange: changed number of streams in segments.
HLSMediaSegmentsPTSJitterDeviation: PTS jumps between segments without EXT-X-DISCONTINUITY.
HLSMediaSegmentsDTSJitterDeviation: DTS jumps between segments without EXT-X-DISCONTINUITY.
TimecodeTrackExist: TMCD track in MP4.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SeverityLevel(self):
        r"""Diagnosed exception level. Valid values:
Fatal: affecting subsequent playback and parsing.
Error: may affect playback.
Warning: potential risk, which may not necessarily affect playback.
Notice: important stream information.
Info: general stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SeverityLevel

    @SeverityLevel.setter
    def SeverityLevel(self, SeverityLevel):
        self._SeverityLevel = SeverityLevel

    @property
    def DateTimeSet(self):
        r"""Timestamp of warning, in the format of 2022-12-25T13:14:16Z.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DateTimeSet

    @DateTimeSet.setter
    def DateTimeSet(self, DateTimeSet):
        self._DateTimeSet = DateTimeSet

    @property
    def TimestampSet(self):
        r"""Timestamp.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of float
        """
        return self._TimestampSet

    @TimestampSet.setter
    def TimestampSet(self, TimestampSet):
        self._TimestampSet = TimestampSet


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._SeverityLevel = params.get("SeverityLevel")
        self._DateTimeSet = params.get("DateTimeSet")
        self._TimestampSet = params.get("TimestampSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    r"""Details of a content audit template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a content audit template.
        :type Definition: int
        :param _Name: Name of a content audit template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of a content audit template. Length limit: 256 characters.
        :type Comment: str
        :param _PornConfigure: Porn information detection control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: The parameters for detecting sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: The parameters for detecting sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: Custom content audit control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _Type: The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        r"""Unique ID of a content audit template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        r"""Name of a content audit template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description of a content audit template. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        r"""Porn information detection control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        r"""The parameters for detecting sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        r"""The parameters for detecting sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        r"""Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        r"""Custom content audit control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def CreateTime(self):
        r"""Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        r"""The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosFileUploadTrigger(AbstractModel):
    r"""Input rule bound to COS.

    """

    def __init__(self):
        r"""
        :param _Bucket: Name of the COS bucket bound to a workflow, such as `TopRankVideo-125xxx88`.
        :type Bucket: str
        :param _Region: Region of the COS bucket bound to a workflow, such as `ap-chongiqng`.
        :type Region: str
        :param _Dir: Input path directory bound to a workflow, such as `/movie/201907/`. If this parameter is left empty, the `/` root directory will be used.
        :type Dir: str
        :param _Formats: All supported formats are as follows:
- Video file extension. The following 15 options are supported:
`.mp4`, `.avi`, `.mov`, `.wmv`, `.flv`, `.mkv`, `.mpg`, `.mpeg`, `.rm`, `.rmvb`, `.asf`, `.3gp`, `.webm`, `.ts`, and `.m4v`.
- Audio file extension. The following 7 options are supported:
`.mp3`, `.wav`, `.aac`, `.flac`, `.ogg`, `.m4a`, and `.amr`.
- Subtitle file extension. The following 2 options are supported:
`.vtt` and `.srt`.
- `*`: any file format is supported.
- Unspecified or input an empty list: the system supports the following preset file formats: video (`.mp4`, `.ts`, `.flv`, `.wmv`, `.asf`, `.rm`, `.rmvb`, `.mpg`, `.mpeg`, `.3gp`, `.mov`, `.webm`, `.mkv`, `.avi`, and `.m4v`); audio (`.mp3`, `.m4a`, `.flac`, `.ogg`, `.wav`, `.amr`, and `.aac`); subtitle (`.vtt` and `.srt`).
**Note**:
1. If the input format list includes `*`, it indicates that any file format is supported.
2. File extensions can be provided with or without `.`, such as `.mp4` or `mp4`, both are supported.
3. Custom file extensions should consist of digits, letters, and characters, and have a length between 1 and 64 characters.
        :type Formats: list of str
        """
        self._Bucket = None
        self._Region = None
        self._Dir = None
        self._Formats = None

    @property
    def Bucket(self):
        r"""Name of the COS bucket bound to a workflow, such as `TopRankVideo-125xxx88`.
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""Region of the COS bucket bound to a workflow, such as `ap-chongiqng`.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Dir(self):
        r"""Input path directory bound to a workflow, such as `/movie/201907/`. If this parameter is left empty, the `/` root directory will be used.
        :rtype: str
        """
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        r"""All supported formats are as follows:
- Video file extension. The following 15 options are supported:
`.mp4`, `.avi`, `.mov`, `.wmv`, `.flv`, `.mkv`, `.mpg`, `.mpeg`, `.rm`, `.rmvb`, `.asf`, `.3gp`, `.webm`, `.ts`, and `.m4v`.
- Audio file extension. The following 7 options are supported:
`.mp3`, `.wav`, `.aac`, `.flac`, `.ogg`, `.m4a`, and `.amr`.
- Subtitle file extension. The following 2 options are supported:
`.vtt` and `.srt`.
- `*`: any file format is supported.
- Unspecified or input an empty list: the system supports the following preset file formats: video (`.mp4`, `.ts`, `.flv`, `.wmv`, `.asf`, `.rm`, `.rmvb`, `.mpg`, `.mpeg`, `.3gp`, `.mov`, `.webm`, `.mkv`, `.avi`, and `.m4v`); audio (`.mp3`, `.m4a`, `.flac`, `.ogg`, `.wav`, `.amr`, and `.aac`); subtitle (`.vtt` and `.srt`).
**Note**:
1. If the input format list includes `*`, it indicates that any file format is supported.
2. File extensions can be provided with or without `.`, such as `.mp4` or `mp4`, both are supported.
3. Custom file extensions should consist of digits, letters, and characters, and have a length between 1 and 64 characters.
        :rtype: list of str
        """
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosInputInfo(AbstractModel):
    r"""The information of the COS object to process.

    """

    def __init__(self):
        r"""
        :param _Bucket: The COS bucket of the object to process, such as `TopRankVideo-125xxx88`.
        :type Bucket: str
        :param _Region: The region of the COS bucket, such as `ap-chongqing`.
        :type Region: str
        :param _Object: The path of the object to process, such as `/movie/201907/WildAnimal.mov`.
        :type Object: str
        """
        self._Bucket = None
        self._Region = None
        self._Object = None

    @property
    def Bucket(self):
        r"""The COS bucket of the object to process, such as `TopRankVideo-125xxx88`.
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""The region of the COS bucket, such as `ap-chongqing`.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Object(self):
        r"""The path of the object to process, such as `/movie/201907/WildAnimal.mov`.
        :rtype: str
        """
        return self._Object

    @Object.setter
    def Object(self, Object):
        self._Object = Object


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Object = params.get("Object")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosOutputStorage(AbstractModel):
    r"""The information of the output COS object after media processing.

    """

    def __init__(self):
        r"""
        :param _Bucket: The bucket to which the output file of media processing is saved, such as `TopRankVideo-125xxx88`. If this parameter is left empty, the value of the upper layer will be inherited.
        :type Bucket: str
        :param _Region: The region of the output bucket, such as `ap-chongqing`. If this parameter is left empty, the value of the upper layer will be inherited.
        :type Region: str
        """
        self._Bucket = None
        self._Region = None

    @property
    def Bucket(self):
        r"""The bucket to which the output file of media processing is saved, such as `TopRankVideo-125xxx88`. If this parameter is left empty, the value of the upper layer will be inherited.
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""The region of the output bucket, such as `ap-chongqing`. If this parameter is left empty, the value of the upper layer will be inherited.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    r"""Control parameter of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    r"""Control parameter of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        r"""Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    r"""CreateAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Video content analysis template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Video content analysis template description. Length limit: 256 characters.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: Control parameter of intelligent tagging task.
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None

    @property
    def Name(self):
        r"""Video content analysis template name. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Video content analysis template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        r"""Control parameter of intelligent categorization task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        """
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        r"""Control parameter of intelligent tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        """
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        r"""Control parameter of intelligent cover generating task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        """
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        r"""Control parameter of intelligent frame-specific tagging task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    r"""CreateAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of video content analysis template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    r"""CreateAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of a video content recognition template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of a video content recognition template. Length limit: 256 characters.
        :type Comment: str
        :param _FaceConfigure: Face recognition control parameter.
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: Full text recognition control parameter.
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: Text keyword recognition control parameter.
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: Full speech recognition control parameter.
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: Speech keyword recognition control parameter.
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None

    @property
    def Name(self):
        r"""Name of a video content recognition template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description of a video content recognition template. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        r"""Face recognition control parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        """
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        r"""Full text recognition control parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        """
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        r"""Text keyword recognition control parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        """
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        r"""Full speech recognition control parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        """
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        r"""Speech keyword recognition control parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        """
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    r"""CreateAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of a video content recognition template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    r"""CreateAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Format: Adaptive bitrate streaming format. Valid values:
<li>HLS,</li>
<li>MPEG-DASH.</li>
        :type Format: str
        :param _StreamInfos: Parameter information of output substreams for transcoding to adaptive bitrate streaming. Up to 10 substreams can be output.
Note: the frame rate of each substream must be consistent; otherwise, the frame rate of the first substream is used as the output frame rate.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _Name: Template name. Length limit: 64 characters.
        :type Name: str
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: 0.
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: 0.
        :type DisableHigherVideoResolution: int
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _PureAudio: Indicates whether it is audio-only. 0 means video template, 1 means audio-only template.
When the value is 1.
1. StreamInfos.N.RemoveVideo=1
2. StreamInfos.N.RemoveAudio=0
3. StreamInfos.N.Video.Codec=copy

When the value is 0.
1. StreamInfos.N.Video.Codec cannot be copy.
2. StreamInfos.N.Video.Fps cannot be null.

Note:
This value only distinguishes template types. The task uses the values of RemoveAudio and RemoveVideo.
        :type PureAudio: int
        :param _SegmentType: Sharding type. available values: <li>ts-segment: HLS+ts segment</li> <li>ts-byterange: HLS+ts byte range</li> <li>mp4-segment: HLS+mp4 segment</li> <li>mp4-byterange: HLS+mp4 byte range</li> <li>ts-packed-audio: ts+packed audio</li> <li>mp4-packed-audio: mp4+packed audio</li> default value: ts-segment. 
Note: the shard format of the adaptive bitrate stream is based on this field.
        :type SegmentType: str
        """
        self._Format = None
        self._StreamInfos = None
        self._Name = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Format(self):
        r"""Adaptive bitrate streaming format. Valid values:
<li>HLS,</li>
<li>MPEG-DASH.</li>
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        r"""Parameter information of output substreams for transcoding to adaptive bitrate streaming. Up to 10 substreams can be output.
Note: the frame rate of each substream must be consistent; otherwise, the frame rate of the first substream is used as the output frame rate.
        :rtype: list of AdaptiveStreamTemplate
        """
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Name(self):
        r"""Template name. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisableHigherVideoBitrate(self):
        r"""Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: 0.
        :rtype: int
        """
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        r"""Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: 0.
        :rtype: int
        """
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PureAudio(self):
        r"""Indicates whether it is audio-only. 0 means video template, 1 means audio-only template.
When the value is 1.
1. StreamInfos.N.RemoveVideo=1
2. StreamInfos.N.RemoveAudio=0
3. StreamInfos.N.Video.Codec=copy

When the value is 0.
1. StreamInfos.N.Video.Codec cannot be copy.
2. StreamInfos.N.Video.Fps cannot be null.

Note:
This value only distinguishes template types. The task uses the values of RemoveAudio and RemoveVideo.
        :rtype: int
        """
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        r"""Sharding type. available values: <li>ts-segment: HLS+ts segment</li> <li>ts-byterange: HLS+ts byte range</li> <li>mp4-segment: HLS+mp4 segment</li> <li>mp4-byterange: HLS+mp4 byte range</li> <li>ts-packed-audio: ts+packed audio</li> <li>mp4-packed-audio: mp4+packed audio</li> default value: ts-segment. 
Note: the shard format of the adaptive bitrate stream is based on this field.
        :rtype: str
        """
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Name = params.get("Name")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    r"""CreateAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of an adaptive bitrate streaming template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    r"""CreateAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Fps: Video frame rate in Hz. Value range: [1, 30].
        :type Fps: int
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a video stream in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format. Valid values: gif; webp. Default value: gif.
        :type Format: str
        :param _Quality: Image quality. Value range: [1, 100]. Default value: 75.
        :type Quality: float
        :param _Name: Name of an animated image generating template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Fps = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        r"""Video frame rate in Hz. Value range: [1, 30].
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Width(self):
        r"""Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Maximum value of the height (or short side) of a video stream in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""Animated image format. Valid values: gif; webp. Default value: gif.
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        r"""Image quality. Value range: [1, 100]. Default value: 75.
        :rtype: float
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        r"""Name of an animated image generating template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    r"""CreateAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of an animated image generating template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAsrHotwordsRequest(AbstractModel):
    r"""CreateAsrHotwords request structure.

    """

    def __init__(self):
        r"""
        :param _Type: 0: temporary hotword; 1 file-based hotword.
        :type Type: int
        :param _Name: Hotword lexicon name.
        :type Name: str
        :param _Content: Hotword lexicon text. This field is required if Type is set to 0.
        :type Content: str
        :param _FileContent: Base64-encoded content of the hotword file. This field is required if Type is set to 1.


        :type FileContent: str
        :param _FileName: Name of the uploaded file.
        :type FileName: str
        """
        self._Type = None
        self._Name = None
        self._Content = None
        self._FileContent = None
        self._FileName = None

    @property
    def Type(self):
        r"""0: temporary hotword; 1 file-based hotword.
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Hotword lexicon name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Content(self):
        r"""Hotword lexicon text. This field is required if Type is set to 0.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def FileContent(self):
        r"""Base64-encoded content of the hotword file. This field is required if Type is set to 1.


        :rtype: str
        """
        return self._FileContent

    @FileContent.setter
    def FileContent(self, FileContent):
        self._FileContent = FileContent

    @property
    def FileName(self):
        r"""Name of the uploaded file.
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Content = params.get("Content")
        self._FileContent = params.get("FileContent")
        self._FileName = params.get("FileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAsrHotwordsResponse(AbstractModel):
    r"""CreateAsrHotwords response structure.

    """

    def __init__(self):
        r"""
        :param _HotwordsId: Hotword lexicon ID.
        :type HotwordsId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HotwordsId = None
        self._RequestId = None

    @property
    def HotwordsId(self):
        r"""Hotword lexicon ID.
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._RequestId = params.get("RequestId")


class CreateBlindWatermarkTemplateRequest(AbstractModel):
    r"""CreateBlindWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Digital watermark type. Valid values: <li>blind-basic: basic copyright digital watermark;</li> <li>blind-nagra: NAGRA watermark.</li>
        :type Type: str
        :param _TextContent: Text content of the digital watermark. The length cannot exceed 64 characters. After NAGRA watermark templates are created, the text content cannot be modified.
        :type TextContent: str
        :param _Name: Digital watermark template name, which supports Chinese, English, digits, underscores (_), hyphens (-), and periods (.). The length cannot exceed 64 characters.
        :type Name: str
        :param _Comment: Description information of the digital watermark template. The length cannot exceed 256 characters.
        :type Comment: str
        """
        self._Type = None
        self._TextContent = None
        self._Name = None
        self._Comment = None

    @property
    def Type(self):
        r"""Digital watermark type. Valid values: <li>blind-basic: basic copyright digital watermark;</li> <li>blind-nagra: NAGRA watermark.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TextContent(self):
        r"""Text content of the digital watermark. The length cannot exceed 64 characters. After NAGRA watermark templates are created, the text content cannot be modified.
        :rtype: str
        """
        return self._TextContent

    @TextContent.setter
    def TextContent(self, TextContent):
        self._TextContent = TextContent

    @property
    def Name(self):
        r"""Digital watermark template name, which supports Chinese, English, digits, underscores (_), hyphens (-), and periods (.). The length cannot exceed 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description information of the digital watermark template. The length cannot exceed 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TextContent = params.get("TextContent")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBlindWatermarkTemplateResponse(AbstractModel):
    r"""CreateBlindWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the digital watermark template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique identifier of the digital watermark template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    r"""CreateContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: The name of the content moderation template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: The template description. Length limit: 256 characters.
        :type Comment: str
        :param _PornConfigure: Control parameter for a pornography detection task.
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: Control parameter for a violence detection task.
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: Control parameter for a sensitive content detection task.
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this parameter is not supported yet.
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: Custom content moderation parameters.
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None

    @property
    def Name(self):
        r"""The name of the content moderation template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""The template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        r"""Control parameter for a pornography detection task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        """
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        r"""Control parameter for a violence detection task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        """
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        r"""Control parameter for a sensitive content detection task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        """
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        r"""Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this parameter is not supported yet.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        """
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        r"""Custom content moderation parameters.
        :rtype: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    r"""CreateContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The unique ID of the content moderation template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""The unique ID of the content moderation template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTemplateRequest(AbstractModel):
    r"""CreateImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SampleType: Sampling type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _RowCount: Subimage row count of an image sprite.
        :type RowCount: int
        :param _ColumnCount: Subimage column count of an image sprite.
        :type ColumnCount: int
        :param _Name: Name of an image sprite generating template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Subimage width of an image sprite in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Subimage height of an image sprite in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
Default value: black.
        :type FillType: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _Format: The image format. Valid values: jpg (default), png, webp.
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def SampleType(self):
        r"""Sampling type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        r"""Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        r"""Subimage row count of an image sprite.
        :rtype: int
        """
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        r"""Subimage column count of an image sprite.
        :rtype: int
        """
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def Name(self):
        r"""Name of an image sprite generating template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""Subimage width of an image sprite in px. Value range: [128, 4,096].
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Subimage height of an image sprite in px. Value range: [128, 4,096].
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def FillType(self):
        r"""Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
Default value: black.
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        r"""The image format. Valid values: jpg (default), png, webp.
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    r"""CreateImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of an image sprite generating template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateLiveRecordTemplateRequest(AbstractModel):
    r"""CreateLiveRecordTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _HLSConfigure: HLS configuration parameter. Either this parameter or MP4Configure should be specified.
        :type HLSConfigure: :class:`tencentcloud.mps.v20190612.models.HLSConfigureInfo`
        :param _MP4Configure: MP4 configuration parameter. Either this parameter or HLSConfigure should be specified.
        :type MP4Configure: :class:`tencentcloud.mps.v20190612.models.MP4ConfigureInfo`
        :param _Name: Recording template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description, with a length limit of 256 characters.
        :type Comment: str
        :param _RecordType: Recording type. Valid values: 

- video: audio and video recording; 
- audio: audio recording; 
- auto: automatic detection;

If it is left blank, "video" will be used as the default value.
        :type RecordType: str
        """
        self._HLSConfigure = None
        self._MP4Configure = None
        self._Name = None
        self._Comment = None
        self._RecordType = None

    @property
    def HLSConfigure(self):
        r"""HLS configuration parameter. Either this parameter or MP4Configure should be specified.
        :rtype: :class:`tencentcloud.mps.v20190612.models.HLSConfigureInfo`
        """
        return self._HLSConfigure

    @HLSConfigure.setter
    def HLSConfigure(self, HLSConfigure):
        self._HLSConfigure = HLSConfigure

    @property
    def MP4Configure(self):
        r"""MP4 configuration parameter. Either this parameter or HLSConfigure should be specified.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MP4ConfigureInfo`
        """
        return self._MP4Configure

    @MP4Configure.setter
    def MP4Configure(self, MP4Configure):
        self._MP4Configure = MP4Configure

    @property
    def Name(self):
        r"""Recording template name. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Template description, with a length limit of 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RecordType(self):
        r"""Recording type. Valid values: 

- video: audio and video recording; 
- audio: audio recording; 
- auto: automatic detection;

If it is left blank, "video" will be used as the default value.
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType


    def _deserialize(self, params):
        if params.get("HLSConfigure") is not None:
            self._HLSConfigure = HLSConfigureInfo()
            self._HLSConfigure._deserialize(params.get("HLSConfigure"))
        if params.get("MP4Configure") is not None:
            self._MP4Configure = MP4ConfigureInfo()
            self._MP4Configure._deserialize(params.get("MP4Configure"))
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RecordType = params.get("RecordType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveRecordTemplateResponse(AbstractModel):
    r"""CreateLiveRecordTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the recording template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique identifier of the recording template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreatePersonSampleRequest(AbstractModel):
    r"""CreatePersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of an image. Length limit: 20 characters
        :type Name: str
        :param _Usages: Image usage. Valid values:
1. Recognition: used for content recognition; equivalent to `Recognition.Face`
2. Review: used for inappropriate information recognition; equivalent to `Review.Face`
3. All: equivalent to 1+2
        :type Usages: list of str
        :param _Description: Image description. Length limit: 1,024 characters
        :type Description: str
        :param _FaceContents: [Base64](https://tools.ietf.org/html/rfc4648) string converted from an image. Only JPEG and PNG images are supported. Array length limit: 5 images
Note: the image must be a relatively clear facial feature photo of one person with a size of at least 200 x 200 pixels.
        :type FaceContents: list of str
        :param _Tags: Image tag
<li>Array length limit: 20 tags</li>
<li>Tag length limit: 128 characters</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        r"""Name of an image. Length limit: 20 characters
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        r"""Image usage. Valid values:
1. Recognition: used for content recognition; equivalent to `Recognition.Face`
2. Review: used for inappropriate information recognition; equivalent to `Review.Face`
3. All: equivalent to 1+2
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Description(self):
        r"""Image description. Length limit: 1,024 characters
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        r"""[Base64](https://tools.ietf.org/html/rfc4648) string converted from an image. Only JPEG and PNG images are supported. Array length limit: 5 images
Note: the image must be a relatively clear facial feature photo of one person with a size of at least 200 x 200 pixels.
        :rtype: list of str
        """
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        r"""Image tag
<li>Array length limit: 20 tags</li>
<li>Tag length limit: 128 characters</li>
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    r"""CreatePersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _Person: Image information
        :type Person: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        :param _FailFaceInfoSet: Information of images that failed the verification by facial feature positioning
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        r"""Image information
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        """
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        r"""Information of images that failed the verification by facial feature positioning
        :rtype: list of AiSampleFailFaceInfo
        """
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateProcessImageTemplateRequest(AbstractModel):
    r"""CreateProcessImageTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ProcessImageTemplate: Image processing template.
        :type ProcessImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageTaskInput`
        :param _Name: Image processing template name. The length cannot exceed 64 characters.
        :type Name: str
        :param _Comment: Description information of the image processing template. The length cannot exceed 256 characters.
        :type Comment: str
        """
        self._ProcessImageTemplate = None
        self._Name = None
        self._Comment = None

    @property
    def ProcessImageTemplate(self):
        r"""Image processing template.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageTaskInput`
        """
        return self._ProcessImageTemplate

    @ProcessImageTemplate.setter
    def ProcessImageTemplate(self, ProcessImageTemplate):
        self._ProcessImageTemplate = ProcessImageTemplate

    @property
    def Name(self):
        r"""Image processing template name. The length cannot exceed 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Description information of the image processing template. The length cannot exceed 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        if params.get("ProcessImageTemplate") is not None:
            self._ProcessImageTemplate = ImageTaskInput()
            self._ProcessImageTemplate._deserialize(params.get("ProcessImageTemplate"))
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcessImageTemplateResponse(AbstractModel):
    r"""CreateProcessImageTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the image processing template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique identifier of the image processing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateQualityControlTemplateRequest(AbstractModel):
    r"""CreateQualityControlTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Media quality inspection template name, with a length limit of 64 characters.
        :type Name: str
        :param _QualityControlItemSet: Media quality inspection control parameters.
        :type QualityControlItemSet: list of QualityControlItemConfig
        :param _Comment: Media quality inspection template description, with a length limit of 256 characters.
        :type Comment: str
        :param _RecordFormat: Recording file format. Valid values:
<li>PNG: PNG image.</li>
        :type RecordFormat: str
        :param _Strategy: Spot check policy for media quality inspection.
        :type Strategy: :class:`tencentcloud.mps.v20190612.models.QualityControlStrategy`
        """
        self._Name = None
        self._QualityControlItemSet = None
        self._Comment = None
        self._RecordFormat = None
        self._Strategy = None

    @property
    def Name(self):
        r"""Media quality inspection template name, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityControlItemSet(self):
        r"""Media quality inspection control parameters.
        :rtype: list of QualityControlItemConfig
        """
        return self._QualityControlItemSet

    @QualityControlItemSet.setter
    def QualityControlItemSet(self, QualityControlItemSet):
        self._QualityControlItemSet = QualityControlItemSet

    @property
    def Comment(self):
        r"""Media quality inspection template description, with a length limit of 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RecordFormat(self):
        r"""Recording file format. Valid values:
<li>PNG: PNG image.</li>
        :rtype: str
        """
        return self._RecordFormat

    @RecordFormat.setter
    def RecordFormat(self, RecordFormat):
        self._RecordFormat = RecordFormat

    @property
    def Strategy(self):
        r"""Spot check policy for media quality inspection.
        :rtype: :class:`tencentcloud.mps.v20190612.models.QualityControlStrategy`
        """
        return self._Strategy

    @Strategy.setter
    def Strategy(self, Strategy):
        self._Strategy = Strategy


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("QualityControlItemSet") is not None:
            self._QualityControlItemSet = []
            for item in params.get("QualityControlItemSet"):
                obj = QualityControlItemConfig()
                obj._deserialize(item)
                self._QualityControlItemSet.append(obj)
        self._Comment = params.get("Comment")
        self._RecordFormat = params.get("RecordFormat")
        if params.get("Strategy") is not None:
            self._Strategy = QualityControlStrategy()
            self._Strategy._deserialize(params.get("Strategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateQualityControlTemplateResponse(AbstractModel):
    r"""CreateQualityControlTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of a media quality inspection template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique identifier of a media quality inspection template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    r"""CreateSampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SampleType: Sampled screencapturing type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _Name: Name of a sampled screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Image width in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Image height in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: The image format. Valid values: jpg (default), png, webp.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        r"""Sampled screencapturing type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :rtype: str
        """
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        r"""Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :rtype: int
        """
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def Name(self):
        r"""Name of a sampled screencapturing template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""Image width in px. Value range: [128, 4,096].
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Image height in px. Value range: [128, 4,096].
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""The image format. Valid values: jpg (default), png, webp.
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    r"""CreateSampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of a sampled screencapturing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateScheduleRequest(AbstractModel):
    r"""CreateSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleName: The scheme name (max 128 characters). This name should be unique across your account.
        :type ScheduleName: str
        :param _Trigger: The trigger of the scheme. If a file is uploaded to the specified bucket, the scheme will be triggered.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: The subtasks of the scheme.
        :type Activities: list of Activity
        :param _OutputStorage: The bucket to save the output file. If you do not specify this parameter, the bucket in `Trigger` will be used.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this, the file will be saved to the trigger directory.
        :type OutputDir: str
        :param _TaskNotifyConfig: The notification configuration. If you do not specify this parameter, notifications will not be sent.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _ResourceId: Resource ID. Ensure the corresponding resource is in the enabled state. The default value is an account's primary resource ID.
        :type ResourceId: str
        """
        self._ScheduleName = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None
        self._ResourceId = None

    @property
    def ScheduleName(self):
        r"""The scheme name (max 128 characters). This name should be unique across your account.
        :rtype: str
        """
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Trigger(self):
        r"""The trigger of the scheme. If a file is uploaded to the specified bucket, the scheme will be triggered.
        :rtype: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        """
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        r"""The subtasks of the scheme.
        :rtype: list of Activity
        """
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        r"""The bucket to save the output file. If you do not specify this parameter, the bucket in `Trigger` will be used.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this, the file will be saved to the trigger directory.
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        r"""The notification configuration. If you do not specify this parameter, notifications will not be sent.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def ResourceId(self):
        r"""Resource ID. Ensure the corresponding resource is in the enabled state. The default value is an account's primary resource ID.
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ScheduleName = params.get("ScheduleName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScheduleResponse(AbstractModel):
    r"""CreateSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ScheduleId = None
        self._RequestId = None

    @property
    def ScheduleId(self):
        r"""The scheme ID.
        :rtype: int
        """
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._RequestId = params.get("RequestId")


class CreateSmartEraseTemplateRequest(AbstractModel):
    r"""CreateSmartEraseTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Length limit for the smart erasing template name: 64 characters.
        :type Name: str
        :param _EraseType: Erasing type.
-subtitle: subtitle removal.
-watermark: watermark removal.
-privacy: privacy protection.
        :type EraseType: str
        :param _Comment: Length limit for the description information of the smart erasing template: 256 characters.
        :type Comment: str
        :param _EraseSubtitleConfig: Subtitle erasing configuration. This parameter is required and valid only when the value of EraseType is set to subtitle.
        :type EraseSubtitleConfig: :class:`tencentcloud.mps.v20190612.models.SmartEraseSubtitleConfig`
        :param _EraseWatermarkConfig: Watermark erasing configuration. This parameter is required and valid only when the value of EraseType is set to watermark.
        :type EraseWatermarkConfig: :class:`tencentcloud.mps.v20190612.models.SmartEraseWatermarkConfig`
        :param _ErasePrivacyConfig: Privacy protection configuration. This parameter is required and valid only when the value of EraseType is set to privacy.
        :type ErasePrivacyConfig: :class:`tencentcloud.mps.v20190612.models.SmartErasePrivacyConfig`
        """
        self._Name = None
        self._EraseType = None
        self._Comment = None
        self._EraseSubtitleConfig = None
        self._EraseWatermarkConfig = None
        self._ErasePrivacyConfig = None

    @property
    def Name(self):
        r"""Length limit for the smart erasing template name: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def EraseType(self):
        r"""Erasing type.
-subtitle: subtitle removal.
-watermark: watermark removal.
-privacy: privacy protection.
        :rtype: str
        """
        return self._EraseType

    @EraseType.setter
    def EraseType(self, EraseType):
        self._EraseType = EraseType

    @property
    def Comment(self):
        r"""Length limit for the description information of the smart erasing template: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def EraseSubtitleConfig(self):
        r"""Subtitle erasing configuration. This parameter is required and valid only when the value of EraseType is set to subtitle.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseSubtitleConfig`
        """
        return self._EraseSubtitleConfig

    @EraseSubtitleConfig.setter
    def EraseSubtitleConfig(self, EraseSubtitleConfig):
        self._EraseSubtitleConfig = EraseSubtitleConfig

    @property
    def EraseWatermarkConfig(self):
        r"""Watermark erasing configuration. This parameter is required and valid only when the value of EraseType is set to watermark.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartEraseWatermarkConfig`
        """
        return self._EraseWatermarkConfig

    @EraseWatermarkConfig.setter
    def EraseWatermarkConfig(self, EraseWatermarkConfig):
        self._EraseWatermarkConfig = EraseWatermarkConfig

    @property
    def ErasePrivacyConfig(self):
        r"""Privacy protection configuration. This parameter is required and valid only when the value of EraseType is set to privacy.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SmartErasePrivacyConfig`
        """
        return self._ErasePrivacyConfig

    @ErasePrivacyConfig.setter
    def ErasePrivacyConfig(self, ErasePrivacyConfig):
        self._ErasePrivacyConfig = ErasePrivacyConfig


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._EraseType = params.get("EraseType")
        self._Comment = params.get("Comment")
        if params.get("EraseSubtitleConfig") is not None:
            self._EraseSubtitleConfig = SmartEraseSubtitleConfig()
            self._EraseSubtitleConfig._deserialize(params.get("EraseSubtitleConfig"))
        if params.get("EraseWatermarkConfig") is not None:
            self._EraseWatermarkConfig = SmartEraseWatermarkConfig()
            self._EraseWatermarkConfig._deserialize(params.get("EraseWatermarkConfig"))
        if params.get("ErasePrivacyConfig") is not None:
            self._ErasePrivacyConfig = SmartErasePrivacyConfig()
            self._ErasePrivacyConfig._deserialize(params.get("ErasePrivacyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSmartEraseTemplateResponse(AbstractModel):
    r"""CreateSmartEraseTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the smart erasing template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique identifier of the smart erasing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSmartSubtitleTemplateRequest(AbstractModel):
    r"""CreateSmartSubtitleTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Smart subtitle template name.
Length limit: 64 characters.
        :type Name: str
        :param _VideoSrcLanguage: Source language of the video with smart subtitles.
Currently, the following languages are supported:
`zh`: Simplified Chinese.
`yue`: Cantonese.
`zh-PY`: Chinese, English, and Cantonese.
`zh_medical`: Chinese (medical scenario).
`zh_dialect`: Chinese dialect.
`prime_zh`: Chinese, English, and Chinese dialects.
`zh_en`: Chinese and English.
`en`: English.
`ja`: Japanese.
`ko`: Korean.
`fr`: French.
`es`: Spanish.
`it`: Italian.
`de`: German.
`tr`: Turkish.
`ru`: Russian.
`pt`: Portuguese (Brazil).
`pt-PT`: Portuguese (Portugal).
`vi`: Vietnamese.
`id`: Indonesian.
`ms`: Malay.
`th`: Thai.
`ar`: Arabic.
`hi`: Hindi.
`fil`: Filipino.
`auto`: automatic recognition (it is only supported in pure subtitle translation).
        :type VideoSrcLanguage: str
        :param _SubtitleType: Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON.
        :type SubtitleType: int
        :param _Comment: Smart subtitle template description.
Length limit: 256 characters.
        :type Comment: str
        :param _SubtitleFormat: Smart subtitle file format:
- Under the ASR recognition and translation processing type:
     - vtt: WebVTT format subtitle.
     - srt: SRT format subtitle.
     - If this field is unspecified or left blank, no subtitle file will be generated.
- Under the pure subtitle translation processing type:
    - original: consistent with the source file.
    - vtt: WebVTT format subtitle.
    - srt: SRT format subtitle.
**Note**:
- For ASR recognition mode, when 2 or more languages are involved in translation, this field cannot be unspecified or left blank.
- For pure subtitle translation mode, this field cannot be unspecified or left blank.
        :type SubtitleFormat: str
        :param _AsrHotWordsConfigure: ASR hotword lexicon parameter.
        :type AsrHotWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrHotWordsConfigure`
        :param _TranslateSwitch: Subtitle translation switch.
`ON`: translation enabled.
`OFF`: translation disabled.
**Note**: For pure subtitle translation mode, the default value is enabled if the field is unspecified. The field cannot be left blank or set to `OFF`.
        :type TranslateSwitch: str
        :param _TranslateDstLanguage: Subtitle translation target language. This field is valid when the value of TranslateSwitch is `ON`.
Currently, the following languages are supported:
`zh`: Simplified Chinese.
`zh-TW`: Traditional Chinese.
`en`: English.
`ja`: Japanese.
`ko`: Korean.
`fr`: French.
`es`: Spanish.
`it`: Italian.
`de`: German.
`tr`: Turkish.
`ru`: Russian.
`pt`: Portuguese (Brazil).
`pt-PT`: Portuguese (Portugal).
`vi`: Vietnamese.
`id`: Indonesian.
`ms`: Malay.
`th`: Thai.
`ar`: Arabic.
`hi`: Hindi.
`fil`: Filipino.
**Note**: Use `/` to separate multiple languages, such as `en/ja`, which indicates English and Japanese.
        :type TranslateDstLanguage: str
        :param _ProcessType: Subtitle processing type:
- 0: ASR recognition subtitle.
- 1: pure subtitle translation.
**Note**: The default processing type is ASR recognition subtitle if the field is unspecified.
        :type ProcessType: int
        """
        self._Name = None
        self._VideoSrcLanguage = None
        self._SubtitleType = None
        self._Comment = None
        self._SubtitleFormat = None
        self._AsrHotWordsConfigure = None
        self._TranslateSwitch = None
        self._TranslateDstLanguage = None
        self._ProcessType = None

    @property
    def Name(self):
        r"""Smart subtitle template name.
Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VideoSrcLanguage(self):
        r"""Source language of the video with smart subtitles.
Currently, the following languages are supported:
`zh`: Simplified Chinese.
`yue`: Cantonese.
`zh-PY`: Chinese, English, and Cantonese.
`zh_medical`: Chinese (medical scenario).
`zh_dialect`: Chinese dialect.
`prime_zh`: Chinese, English, and Chinese dialects.
`zh_en`: Chinese and English.
`en`: English.
`ja`: Japanese.
`ko`: Korean.
`fr`: French.
`es`: Spanish.
`it`: Italian.
`de`: German.
`tr`: Turkish.
`ru`: Russian.
`pt`: Portuguese (Brazil).
`pt-PT`: Portuguese (Portugal).
`vi`: Vietnamese.
`id`: Indonesian.
`ms`: Malay.
`th`: Thai.
`ar`: Arabic.
`hi`: Hindi.
`fil`: Filipino.
`auto`: automatic recognition (it is only supported in pure subtitle translation).
        :rtype: str
        """
        return self._VideoSrcLanguage

    @VideoSrcLanguage.setter
    def VideoSrcLanguage(self, VideoSrcLanguage):
        self._VideoSrcLanguage = VideoSrcLanguage

    @property
    def SubtitleType(self):
        r"""Smart subtitle language type.
0: source language
1: target language
2: source language + target language
The value can only be 0 when TranslateSwitch is set to OFF. The value can only be 1 or 2 when TranslateSwitch is set to ON.
        :rtype: int
        """
        return self._SubtitleType

    @SubtitleType.setter
    def SubtitleType(self, SubtitleType):
        self._SubtitleType = SubtitleType

    @property
    def Comment(self):
        r"""Smart subtitle template description.
Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def SubtitleFormat(self):
        r"""Smart subtitle file format:
- Under the ASR recognition and translation processing type:
     - vtt: WebVTT format subtitle.
     - srt: SRT format subtitle.
     - If this field is unspecified or left blank, no subtitle file will be generated.
- Under the pure subtitle translation processing type:
    - original: consistent with the source file.
    - vtt: WebVTT format subtitle.
    - srt: SRT format subtitle.
**Note**:
- For ASR recognition mode, when 2 or more languages are involved in translation, this field cannot be unspecified or left blank.
- For pure subtitle translation mode, this field cannot be unspecified or left blank.
        :rtype: str
        """
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def AsrHotWordsConfigure(self):
        r"""ASR hotword lexicon parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AsrHotWordsConfigure`
        """
        return self._AsrHotWordsConfigure

    @AsrHotWordsConfigure.setter
    def AsrHotWordsConfigure(self, AsrHotWordsConfigure):
        self._AsrHotWordsConfigure = AsrHotWordsConfigure

    @property
    def TranslateSwitch(self):
        r"""Subtitle translation switch.
`ON`: translation enabled.
`OFF`: translation disabled.
**Note**: For pure subtitle translation mode, the default value is enabled if the field is unspecified. The field cannot be left blank or set to `OFF`.
        :rtype: str
        """
        return self._TranslateSwitch

    @TranslateSwitch.setter
    def TranslateSwitch(self, TranslateSwitch):
        self._TranslateSwitch = TranslateSwitch

    @property
    def TranslateDstLanguage(self):
        r"""Subtitle translation target language. This field is valid when the value of TranslateSwitch is `ON`.
Currently, the following languages are supported:
`zh`: Simplified Chinese.
`zh-TW`: Traditional Chinese.
`en`: English.
`ja`: Japanese.
`ko`: Korean.
`fr`: French.
`es`: Spanish.
`it`: Italian.
`de`: German.
`tr`: Turkish.
`ru`: Russian.
`pt`: Portuguese (Brazil).
`pt-PT`: Portuguese (Portugal).
`vi`: Vietnamese.
`id`: Indonesian.
`ms`: Malay.
`th`: Thai.
`ar`: Arabic.
`hi`: Hindi.
`fil`: Filipino.
**Note**: Use `/` to separate multiple languages, such as `en/ja`, which indicates English and Japanese.
        :rtype: str
        """
        return self._TranslateDstLanguage

    @TranslateDstLanguage.setter
    def TranslateDstLanguage(self, TranslateDstLanguage):
        self._TranslateDstLanguage = TranslateDstLanguage

    @property
    def ProcessType(self):
        r"""Subtitle processing type:
- 0: ASR recognition subtitle.
- 1: pure subtitle translation.
**Note**: The default processing type is ASR recognition subtitle if the field is unspecified.
        :rtype: int
        """
        return self._ProcessType

    @ProcessType.setter
    def ProcessType(self, ProcessType):
        self._ProcessType = ProcessType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._VideoSrcLanguage = params.get("VideoSrcLanguage")
        self._SubtitleType = params.get("SubtitleType")
        self._Comment = params.get("Comment")
        self._SubtitleFormat = params.get("SubtitleFormat")
        if params.get("AsrHotWordsConfigure") is not None:
            self._AsrHotWordsConfigure = AsrHotWordsConfigure()
            self._AsrHotWordsConfigure._deserialize(params.get("AsrHotWordsConfigure"))
        self._TranslateSwitch = params.get("TranslateSwitch")
        self._TranslateDstLanguage = params.get("TranslateDstLanguage")
        self._ProcessType = params.get("ProcessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSmartSubtitleTemplateResponse(AbstractModel):
    r"""CreateSmartSubtitleTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the smart subtitle template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique identifier of the smart subtitle template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    r"""CreateSnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of a time point screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Image width in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Image height in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: The image format. Valid values: jpg (default), png, webp.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Name(self):
        r"""Name of a time point screencapturing template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        r"""Image width in px. Value range: [128, 4,096].
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        r"""Image height in px. Value range: [128, 4,096].
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        r"""Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :rtype: str
        """
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        r"""The image format. Valid values: jpg (default), png, webp.
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        r"""Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :rtype: str
        """
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    r"""CreateSnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of a time point screencapturing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    r"""CreateTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Container: Container format. Valid values: mp4, flv, hls, ts, webm, mkv, mxf, mov, mp3, flac, ogg, and m4a. Among them, mp3, flac, ogg, and m4a are for audio-only files.
        :type Container: str
        :param _Name: Name of a transcoding template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
Default value: 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
Default value: 0.
        :type RemoveAudio: int
        :param _VideoTemplate: Video stream configuration parameter. This field is required when `RemoveVideo` is 0.
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _AudioTemplate: Audio stream configuration parameter. This field is required when `RemoveAudio` is 0.
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _TEHDConfig: TESHD transcoding parameter. To enable it, please contact your Tencent Cloud sales rep.
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        :param _EnhanceConfig: Audio/Video enhancement configuration.
        :type EnhanceConfig: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        :param _StdExtInfo: Additional parameter, which is a serialized JSON string.
        :type StdExtInfo: str
        """
        self._Container = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None
        self._StdExtInfo = None

    @property
    def Container(self):
        r"""Container format. Valid values: mp4, flv, hls, ts, webm, mkv, mxf, mov, mp3, flac, ogg, and m4a. Among them, mp3, flac, ogg, and m4a are for audio-only files.
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Name(self):
        r"""Name of a transcoding template. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        r"""Whether to remove video data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
Default value: 0.
        :rtype: int
        """
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        r"""Whether to remove audio data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
Default value: 0.
        :rtype: int
        """
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        r"""Video stream configuration parameter. This field is required when `RemoveVideo` is 0.
        :rtype: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        """
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        r"""Audio stream configuration parameter. This field is required when `RemoveAudio` is 0.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        """
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        r"""TESHD transcoding parameter. To enable it, please contact your Tencent Cloud sales rep.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        """
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        r"""Audio/Video enhancement configuration.
        :rtype: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        """
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig

    @property
    def StdExtInfo(self):
        r"""Additional parameter, which is a serialized JSON string.
        :rtype: str
        """
        return self._StdExtInfo

    @StdExtInfo.setter
    def StdExtInfo(self, StdExtInfo):
        self._StdExtInfo = StdExtInfo


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        self._StdExtInfo = params.get("StdExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    r"""CreateTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a transcoding template.
        :type Definition: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of a transcoding template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    r"""CreateWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Watermarking type. Valid values:
<li>image: Image watermark;</li>
<li>text: Text watermark;</li>
<li>svg: SVG watermark.</li>
        :type Type: str
        :param _Name: Watermarking template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _CoordinateOrigin: Origin position. Valid values:
<li>TopLeft: The origin of coordinates is in the top-left corner of the video, and the origin of the watermark is in the top-left corner of the image or text;</li>
<li>TopRight: The origin of coordinates is in the top-right corner of the video, and the origin of the watermark is in the top-right corner of the image or text;</li>
<li>BottomLeft: The origin of coordinates is in the bottom-left corner of the video, and the origin of the watermark is in the bottom-left corner of the image or text;</li>
<li>BottomRight: The origin of coordinates is in the bottom-right corner of the video, and the origin of the watermark is in the bottom-right corner of the image or text.</li>
Default value: TopLeft.
        :type CoordinateOrigin: str
        :param _XPos: The horizontal position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the watermark will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the watermark will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
Default value: 0 px.
        :type XPos: str
        :param _YPos: The vertical position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the watermark will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the watermark will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
Default value: 0 px.
        :type YPos: str
        :param _ImageTemplate: Image watermarking template. This field is required and valid only when `Type` is `image`.
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInput`
        :param _TextTemplate: Text watermarking template. This field is required and valid only when `Type` is `text`.
        :type TextTemplate: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG watermarking template. This field is required and valid only when `Type` is `svg`.
        :type SvgTemplate: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInput`
        """
        self._Type = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        r"""Watermarking type. Valid values:
<li>image: Image watermark;</li>
<li>text: Text watermark;</li>
<li>svg: SVG watermark.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Watermarking template name. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        r"""Template description. Length limit: 256 characters.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        r"""Origin position. Valid values:
<li>TopLeft: The origin of coordinates is in the top-left corner of the video, and the origin of the watermark is in the top-left corner of the image or text;</li>
<li>TopRight: The origin of coordinates is in the top-right corner of the video, and the origin of the watermark is in the top-right corner of the image or text;</li>
<li>BottomLeft: The origin of coordinates is in the bottom-left corner of the video, and the origin of the watermark is in the bottom-left corner of the image or text;</li>
<li>BottomRight: The origin of coordinates is in the bottom-right corner of the video, and the origin of the watermark is in the bottom-right corner of the image or text.</li>
Default value: TopLeft.
        :rtype: str
        """
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        r"""The horizontal position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the watermark will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the watermark will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
Default value: 0 px.
        :rtype: str
        """
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        r"""The vertical position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the watermark will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the watermark will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
Default value: 0 px.
        :rtype: str
        """
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        r"""Image watermarking template. This field is required and valid only when `Type` is `image`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInput`
        """
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        r"""Text watermarking template. This field is required and valid only when `Type` is `text`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInput`
        """
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        r"""SVG watermarking template. This field is required and valid only when `Type` is `svg`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInput`
        """
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    r"""CreateWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a watermarking template.
        :type Definition: int
        :param _ImageUrl: Watermark image address. This field is valid only when `Type` is `image`.
        :type ImageUrl: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        r"""Unique ID of a watermarking template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        r"""Watermark image address. This field is valid only when `Type` is `image`.
        :rtype: str
        """
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    r"""CreateWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
7. All: ASR- and OCR-based content recognition and inappropriate information detection; equivalent to 1+2+3+4
        :type Usages: list of str
        :param _Words: Keyword. Array length limit: 100.
        :type Words: list of AiSampleWordInfo
        """
        self._Usages = None
        self._Words = None

    @property
    def Usages(self):
        r"""<b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
7. All: ASR- and OCR-based content recognition and inappropriate information detection; equivalent to 1+2+3+4
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        r"""Keyword. Array length limit: 100.
        :rtype: list of AiSampleWordInfo
        """
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    r"""CreateWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWorkflowRequest(AbstractModel):
    r"""CreateWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowName: Workflow name of up to 128 characters, which must be unique for the same user.
        :type WorkflowName: str
        :param _Trigger: Triggering rule bound to a workflow. If an uploaded video hits the rule for the object, the workflow will be triggered.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _OutputStorage: The location to save the output file of media processing. If this parameter is left empty, the storage location in `Trigger` will be inherited.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this, the file will be saved to the trigger directory.
        :type OutputDir: str
        :param _MediaProcessTask: The media processing parameters to use.
        :type MediaProcessTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: Type parameter of a video content audit task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: Video content analysis task parameter.
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: Type parameter of a video content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _TaskNotifyConfig: Event notification configuration for a task. If this parameter is left empty, no event notifications will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TaskPriority: Workflow priority. The higher the value, the higher the priority. Value range: [-10, 10]. If this parameter is left empty, 0 will be used.
        :type TaskPriority: int
        """
        self._WorkflowName = None
        self._Trigger = None
        self._OutputStorage = None
        self._OutputDir = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._TaskNotifyConfig = None
        self._TaskPriority = None

    @property
    def WorkflowName(self):
        r"""Workflow name of up to 128 characters, which must be unique for the same user.
        :rtype: str
        """
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Trigger(self):
        r"""Triggering rule bound to a workflow. If an uploaded video hits the rule for the object, the workflow will be triggered.
        :rtype: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        """
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def OutputStorage(self):
        r"""The location to save the output file of media processing. If this parameter is left empty, the storage location in `Trigger` will be inherited.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        r"""The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this, the file will be saved to the trigger directory.
        :rtype: str
        """
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def MediaProcessTask(self):
        r"""The media processing parameters to use.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        """
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        r"""Type parameter of a video content audit task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        """
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        r"""Video content analysis task parameter.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        """
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        r"""Type parameter of a video content recognition task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        """
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def TaskNotifyConfig(self):
        r"""Event notification configuration for a task. If this parameter is left empty, no event notifications will be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TaskPriority(self):
        r"""Workflow priority. The higher the value, the higher the priority. Value range: [-10, 10]. If this parameter is left empty, 0 will be used.
        :rtype: int
        """
        return self._TaskPriority

    @TaskPriority.setter
    def TaskPriority(self, TaskPriority):
        self._TaskPriority = TaskPriority


    def _deserialize(self, params):
        self._WorkflowName = params.get("WorkflowName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TaskPriority = params.get("TaskPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowResponse(AbstractModel):
    r"""CreateWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WorkflowId = None
        self._RequestId = None

    @property
    def WorkflowId(self):
        r"""Workflow ID.
        :rtype: int
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._RequestId = params.get("RequestId")


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    r"""DeleteAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of video content analysis template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    r"""DeleteAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    r"""DeleteAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of a video content recognition template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    r"""DeleteAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    r"""DeleteAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of an adaptive bitrate streaming template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    r"""DeleteAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    r"""DeleteAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of an animated image generating template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    r"""DeleteAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAsrHotwordsRequest(AbstractModel):
    r"""DeleteAsrHotwords request structure.

    """

    def __init__(self):
        r"""
        :param _HotwordsId: ID of the hotword lexicon to be deleted.
        :type HotwordsId: str
        """
        self._HotwordsId = None

    @property
    def HotwordsId(self):
        r"""ID of the hotword lexicon to be deleted.
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAsrHotwordsResponse(AbstractModel):
    r"""DeleteAsrHotwords response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBlindWatermarkTemplateRequest(AbstractModel):
    r"""DeleteBlindWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the digital watermark template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique identifier of the digital watermark template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBlindWatermarkTemplateResponse(AbstractModel):
    r"""DeleteBlindWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    r"""DeleteContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The unique ID of the content moderation template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""The unique ID of the content moderation template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    r"""DeleteContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    r"""DeleteImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of an image sprite generating template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    r"""DeleteImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveRecordTemplateRequest(AbstractModel):
    r"""DeleteLiveRecordTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the recording template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique identifier of the recording template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveRecordTemplateResponse(AbstractModel):
    r"""DeleteLiveRecordTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    r"""DeletePersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _PersonId: Image ID
        :type PersonId: str
        """
        self._PersonId = None

    @property
    def PersonId(self):
        r"""Image ID
        :rtype: str
        """
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    r"""DeletePersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProcessImageTemplateRequest(AbstractModel):
    r"""DeleteProcessImageTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the image processing template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique identifier of the image processing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProcessImageTemplateResponse(AbstractModel):
    r"""DeleteProcessImageTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteQualityControlTemplateRequest(AbstractModel):
    r"""DeleteQualityControlTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of a media quality inspection template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique identifier of a media quality inspection template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteQualityControlTemplateResponse(AbstractModel):
    r"""DeleteQualityControlTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    r"""DeleteSampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of a sampled screencapturing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    r"""DeleteSampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScheduleRequest(AbstractModel):
    r"""DeleteSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        r"""The scheme ID.
        :rtype: int
        """
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScheduleResponse(AbstractModel):
    r"""DeleteSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSmartEraseTemplateRequest(AbstractModel):
    r"""DeleteSmartEraseTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the smart erasing template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique identifier of the smart erasing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSmartEraseTemplateResponse(AbstractModel):
    r"""DeleteSmartEraseTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSmartSubtitleTemplateRequest(AbstractModel):
    r"""DeleteSmartSubtitleTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique identifier of the smart subtitle template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique identifier of the smart subtitle template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSmartSubtitleTemplateResponse(AbstractModel):
    r"""DeleteSmartSubtitleTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    r"""DeleteSnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of a time point screencapturing template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    r"""DeleteSnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    r"""DeleteTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a transcoding template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of a transcoding template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    r"""DeleteTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    r"""DeleteWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a watermarking template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        r"""Unique ID of a watermarking template.
        :rtype: int
        """
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    r"""DeleteWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    r"""DeleteWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Keywords: Keyword. Array length limit: 100 words.
        :type Keywords: list of str
        """
        self._Keywords = None

    @property
    def Keywords(self):
        r"""Keyword. Array length limit: 100 words.
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    r"""DeleteWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWorkflowRequest(AbstractModel):
    r"""DeleteWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        r"""Workflow ID.
        :rtype: int
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowResponse(AbstractModel):
    r"""DeleteWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    r"""DescribeAIAnalysisTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of video content analysis templates. Array length limit: 10.
        :type Definitions: list of int
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :type Type: str
        :param _Name: Filter condition for video analysis template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of video content analysis templates. Array length limit: 10.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Pagination offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for video analysis template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    r"""DescribeAIAnalysisTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: List of video content analysis template details.
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        r"""List of video content analysis template details.
        :rtype: list of AIAnalysisTemplateItem
        """
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    r"""DescribeAIRecognitionTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of video content recognition templates. Array length limit: 10.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 50.
        :type Limit: int
        :param _Type: The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :type Type: str
        :param _Name: Filter condition for video recognition template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of video content recognition templates. Array length limit: 10.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for video recognition template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    r"""DescribeAIRecognitionTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: List of video content recognition template details.
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        r"""List of video content recognition template details.
        :rtype: list of AIRecognitionTemplateItem
        """
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    r"""DescribeAdaptiveDynamicStreamingTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of adaptive bitrate streaming templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        :param _PureAudio: Whether it is an audio-only template. 0: video template. 1: audio-only template.

Default value: 0
        :type PureAudio: int
        :param _Name: Filter condition for adaptive transcoding template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._PureAudio = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of adaptive bitrate streaming templates. Array length limit: 100.
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Pagination offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PureAudio(self):
        r"""Whether it is an audio-only template. 0: video template. 1: audio-only template.

Default value: 0
        :rtype: int
        """
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def Name(self):
        r"""Filter condition for adaptive transcoding template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._PureAudio = params.get("PureAudio")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    r"""DescribeAdaptiveDynamicStreamingTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: List of adaptive bitrate streaming template details.
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        r"""List of adaptive bitrate streaming template details.
        :rtype: list of AdaptiveDynamicStreamingTemplate
        """
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    r"""DescribeAnimatedGraphicsTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of animated image generating templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Filter condition for animated image generating template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of animated image generating templates. Array length limit: 100.
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for animated image generating template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    r"""DescribeAnimatedGraphicsTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: List of animated image generating template details.
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        r"""List of animated image generating template details.
        :rtype: list of AnimatedGraphicsTemplate
        """
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAsrHotwordsListRequest(AbstractModel):
    r"""DescribeAsrHotwordsList request structure.

    """

    def __init__(self):
        r"""
        :param _HotwordsId: Parameter for querying by hotword lexicon ID.
        :type HotwordsId: str
        :param _Name: Parameter for querying by hotword lexicon name.
        :type Name: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. All hotword lexicons are returned by default.
        :type Limit: int
        :param _OrderType: Hotword lexicon sorting order.

0: ascending (default)
1: descending
        :type OrderType: int
        :param _OrderBy: Sorts hotword lexicons by a specific field. By default, hotword lexicons are sorted by creation time. If an invalid field is used for sorting, the default sorting field applies.

 - CreateTime: sort by creation time
 - UpdateTime: sort by update time
 - Name: sort by hotword lexicon name
 - WordCount: sort by the number of hotwords
 - HotwordsId: sort by hotword lexicon ID
        :type OrderBy: str
        :param _Types: 0: temporary hotword; 1 file-based hotword.
        :type Types: list of int non-negative
        """
        self._HotwordsId = None
        self._Name = None
        self._Offset = None
        self._Limit = None
        self._OrderType = None
        self._OrderBy = None
        self._Types = None

    @property
    def HotwordsId(self):
        r"""Parameter for querying by hotword lexicon ID.
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Name(self):
        r"""Parameter for querying by hotword lexicon name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. All hotword lexicons are returned by default.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderType(self):
        r"""Hotword lexicon sorting order.

0: ascending (default)
1: descending
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def OrderBy(self):
        r"""Sorts hotword lexicons by a specific field. By default, hotword lexicons are sorted by creation time. If an invalid field is used for sorting, the default sorting field applies.

 - CreateTime: sort by creation time
 - UpdateTime: sort by update time
 - Name: sort by hotword lexicon name
 - WordCount: sort by the number of hotwords
 - HotwordsId: sort by hotword lexicon ID
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Types(self):
        r"""0: temporary hotword; 1 file-based hotword.
        :rtype: list of int non-negative
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderType = params.get("OrderType")
        self._OrderBy = params.get("OrderBy")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAsrHotwordsListResponse(AbstractModel):
    r"""DescribeAsrHotwordsList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of hotword lexicons.
        :type TotalCount: int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. All hotword lexicons are returned by default.
        :type Limit: int
        :param _AsrHotwordsSet: Hotword lexicon list.
        :type AsrHotwordsSet: list of AsrHotwordsSet
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Offset = None
        self._Limit = None
        self._AsrHotwordsSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of hotword lexicons.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. All hotword lexicons are returned by default.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def AsrHotwordsSet(self):
        r"""Hotword lexicon list.
        :rtype: list of AsrHotwordsSet
        """
        return self._AsrHotwordsSet

    @AsrHotwordsSet.setter
    def AsrHotwordsSet(self, AsrHotwordsSet):
        self._AsrHotwordsSet = AsrHotwordsSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("AsrHotwordsSet") is not None:
            self._AsrHotwordsSet = []
            for item in params.get("AsrHotwordsSet"):
                obj = AsrHotwordsSet()
                obj._deserialize(item)
                self._AsrHotwordsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAsrHotwordsRequest(AbstractModel):
    r"""DescribeAsrHotwords request structure.

    """

    def __init__(self):
        r"""
        :param _HotwordsId: ID of the hotword lexicon to be queried.
**Note: Either HotwordsId or Name should be specified. If both are specified, HotwordsId has a higher priority than Name.**
        :type HotwordsId: str
        :param _Name: Hotword lexicon name.
**Note: Either HotwordsId or Name should be specified. If both are specified, HotwordsId has a higher priority than Name.**
        :type Name: str
        :param _Offset: Paging offset. Default value: 0.


        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _OrderBy: Hotword sorting field. Valid values:

 - Default: Sort by the hotword upload sequence.
 - Weight: Sort by the weight.
 - Lexical: Sort by the first letter of hotwords.
        :type OrderBy: str
        :param _OrderType: Hotword sorting order. 0: ascending (default); 1: descending.
        :type OrderType: int
        """
        self._HotwordsId = None
        self._Name = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._OrderType = None

    @property
    def HotwordsId(self):
        r"""ID of the hotword lexicon to be queried.
**Note: Either HotwordsId or Name should be specified. If both are specified, HotwordsId has a higher priority than Name.**
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Name(self):
        r"""Hotword lexicon name.
**Note: Either HotwordsId or Name should be specified. If both are specified, HotwordsId has a higher priority than Name.**
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.


        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        r"""Hotword sorting field. Valid values:

 - Default: Sort by the hotword upload sequence.
 - Weight: Sort by the weight.
 - Lexical: Sort by the first letter of hotwords.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderType(self):
        r"""Hotword sorting order. 0: ascending (default); 1: descending.
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._OrderType = params.get("OrderType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAsrHotwordsResponse(AbstractModel):
    r"""DescribeAsrHotwords response structure.

    """

    def __init__(self):
        r"""
        :param _HotwordsId: ID of the hotword lexicon to be queried.
        :type HotwordsId: str
        :param _Status: Current hotword lexicon id status. a value of 0 indicates that no template is bound to this hotword lexicon at the query moment and it can be deleted.
        :type Status: int
        :param _Name: Name of the hot lexicon.
        :type Name: str
        :param _Type: Specifies the value is 0 for a temporary hotword lexicon and returns the string provided during creation.
Specifies the value is 1 for a file-based hotword lexicon, and returns the content of the file uploaded during creation.


        :type Type: int
        :param _FileName: Name of the uploaded hotword file.
        :type FileName: str
        :param _HotWords: List of hotwords returned for the query.
        :type HotWords: list of AsrHotwordsSetItem
        :param _Content: Hotword text, which depends on the value of Type.
If the value of Type is 0, the hotword string is returned.
If the value of Type is 1, the base64-encoded content of the hotword file is returned.
        :type Content: str
        :param _WordCount: Number of words contained in the hotword lexicon.
        :type WordCount: int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _CreateTime: Hot word lexicon createtime in ISOUTC format "2006-01-02T15:04:05Z".
        :type CreateTime: str
        :param _UpdateTime: Hot lexicon last modified in ISOUTC format "2006-01-02T15:04:05Z".
        :type UpdateTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HotwordsId = None
        self._Status = None
        self._Name = None
        self._Type = None
        self._FileName = None
        self._HotWords = None
        self._Content = None
        self._WordCount = None
        self._Offset = None
        self._Limit = None
        self._CreateTime = None
        self._UpdateTime = None
        self._RequestId = None

    @property
    def HotwordsId(self):
        r"""ID of the hotword lexicon to be queried.
        :rtype: str
        """
        return self._HotwordsId

    @HotwordsId.setter
    def HotwordsId(self, HotwordsId):
        self._HotwordsId = HotwordsId

    @property
    def Status(self):
        r"""Current hotword lexicon id status. a value of 0 indicates that no template is bound to this hotword lexicon at the query moment and it can be deleted.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Name(self):
        r"""Name of the hot lexicon.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""Specifies the value is 0 for a temporary hotword lexicon and returns the string provided during creation.
Specifies the value is 1 for a file-based hotword lexicon, and returns the content of the file uploaded during creation.


        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FileName(self):
        r"""Name of the uploaded hotword file.
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def HotWords(self):
        r"""List of hotwords returned for the query.
        :rtype: list of AsrHotwordsSetItem
        """
        return self._HotWords

    @HotWords.setter
    def HotWords(self, HotWords):
        self._HotWords = HotWords

    @property
    def Content(self):
        r"""Hotword text, which depends on the value of Type.
If the value of Type is 0, the hotword string is returned.
If the value of Type is 1, the base64-encoded content of the hotword file is returned.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def WordCount(self):
        r"""Number of words contained in the hotword lexicon.
        :rtype: int
        """
        return self._WordCount

    @WordCount.setter
    def WordCount(self, WordCount):
        self._WordCount = WordCount

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def CreateTime(self):
        r"""Hot word lexicon createtime in ISOUTC format "2006-01-02T15:04:05Z".
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Hot lexicon last modified in ISOUTC format "2006-01-02T15:04:05Z".
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HotwordsId = params.get("HotwordsId")
        self._Status = params.get("Status")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._FileName = params.get("FileName")
        if params.get("HotWords") is not None:
            self._HotWords = []
            for item in params.get("HotWords"):
                obj = AsrHotwordsSetItem()
                obj._deserialize(item)
                self._HotWords.append(obj)
        self._Content = params.get("Content")
        self._WordCount = params.get("WordCount")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._RequestId = params.get("RequestId")


class DescribeBatchTaskDetailRequest(AbstractModel):
    r"""DescribeBatchTaskDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video processing task ID.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Video processing task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchTaskDetailResponse(AbstractModel):
    r"""DescribeBatchTaskDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task type. Currently, the valid values include:
<Li>BatchTask: batch processing task for video workflows.</li>.
        :type TaskType: str
        :param _Status: Task status. Valid values:
<Li>WAITING: waiting.</li>
<Li>PROCESSING: processing.</li>
<li>FINISH: completed.</li>
        :type Status: str
        :param _CreateTime: Task creation time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type CreateTime: str
        :param _BeginProcessTime: Task execution start time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type BeginProcessTime: str
        :param _FinishTime: Task execution completion time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type FinishTime: str
        :param _TaskId: Media processing task ID.
        :type TaskId: str
        :param _BatchTaskResult: Video processing task information. this field has a value only when TaskType is BatchTask.
        :type BatchTaskResult: :class:`tencentcloud.mps.v20190612.models.BatchSubTaskResult`
        :param _TaskNotifyConfig: Event notification information of the task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Priority of the task flow, with a value range of [-10, 10].
        :type TasksPriority: int
        :param _SessionId: An identifier for deduplication. If there has been a request with the same identifier within the past seven days, an error will be returned for the current request. The maximum length is 50 characters. Leaving it blank or using a null string indicates no deduplication is required.
        :type SessionId: str
        :param _SessionContext: Source context, which is used to pass through user request information. The callback for task flow status changes will return the value of this field. The maximum length is 1,000 characters.
        :type SessionContext: str
        :param _ExtInfo: Additional information field, only used in specific scenarios.
        :type ExtInfo: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._TaskId = None
        self._BatchTaskResult = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None
        self._ExtInfo = None
        self._RequestId = None

    @property
    def TaskType(self):
        r"""Task type. Currently, the valid values include:
<Li>BatchTask: batch processing task for video workflows.</li>.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        r"""Task status. Valid values:
<Li>WAITING: waiting.</li>
<Li>PROCESSING: processing.</li>
<li>FINISH: completed.</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        r"""Task creation time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        r"""Task execution start time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""Task execution completion time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def TaskId(self):
        r"""Media processing task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BatchTaskResult(self):
        r"""Video processing task information. this field has a value only when TaskType is BatchTask.
        :rtype: :class:`tencentcloud.mps.v20190612.models.BatchSubTaskResult`
        """
        return self._BatchTaskResult

    @BatchTaskResult.setter
    def BatchTaskResult(self, BatchTaskResult):
        self._BatchTaskResult = BatchTaskResult

    @property
    def TaskNotifyConfig(self):
        r"""Event notification information of the task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""Priority of the task flow, with a value range of [-10, 10].
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        r"""An identifier for deduplication. If there has been a request with the same identifier within the past seven days, an error will be returned for the current request. The maximum length is 50 characters. Leaving it blank or using a null string indicates no deduplication is required.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""Source context, which is used to pass through user request information. The callback for task flow status changes will return the value of this field. The maximum length is 1,000 characters.
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        r"""Additional information field, only used in specific scenarios.
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        self._TaskId = params.get("TaskId")
        if params.get("BatchTaskResult") is not None:
            self._BatchTaskResult = BatchSubTaskResult()
            self._BatchTaskResult._deserialize(params.get("BatchTaskResult"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        self._RequestId = params.get("RequestId")


class DescribeBlindWatermarkTemplatesRequest(AbstractModel):
    r"""DescribeBlindWatermarkTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Filtering condition for the unique identifier of the digital watermark template. The array length cannot exceed 100.
        :type Definitions: list of int
        :param _Name: Filtering condition for the unique identifier of the digital watermark template. The length cannot exceed 64 characters.
        :type Name: str
        :param _Type: Digital watermark type. Valid values: <li>blind-basic: basic copyright digital watermark;</li> <li>blind-nagra: NAGRA forensics watermark.</li>
        :type Type: str
        :param _Offset: Pagination offset. The default value is 0.
        :type Offset: int
        :param _Limit: Number of returned records.
<li>Default value: 10.</li>
<li>Maximum value: 100.</li>
        :type Limit: int
        """
        self._Definitions = None
        self._Name = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        r"""Filtering condition for the unique identifier of the digital watermark template. The array length cannot exceed 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Name(self):
        r"""Filtering condition for the unique identifier of the digital watermark template. The length cannot exceed 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""Digital watermark type. Valid values: <li>blind-basic: basic copyright digital watermark;</li> <li>blind-nagra: NAGRA forensics watermark.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""Pagination offset. The default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned records.
<li>Default value: 10.</li>
<li>Maximum value: 100.</li>
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBlindWatermarkTemplatesResponse(AbstractModel):
    r"""DescribeBlindWatermarkTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records that meet the filtering conditions.
        :type TotalCount: int
        :param _BlindWatermarkTemplateSet: List of digital watermark template details.
        :type BlindWatermarkTemplateSet: list of BlindWatermarkTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._BlindWatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records that meet the filtering conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BlindWatermarkTemplateSet(self):
        r"""List of digital watermark template details.
        :rtype: list of BlindWatermarkTemplate
        """
        return self._BlindWatermarkTemplateSet

    @BlindWatermarkTemplateSet.setter
    def BlindWatermarkTemplateSet(self, BlindWatermarkTemplateSet):
        self._BlindWatermarkTemplateSet = BlindWatermarkTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BlindWatermarkTemplateSet") is not None:
            self._BlindWatermarkTemplateSet = []
            for item in params.get("BlindWatermarkTemplateSet"):
                obj = BlindWatermarkTemplate()
                obj._deserialize(item)
                self._BlindWatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    r"""DescribeContentReviewTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: The IDs of the content moderation templates to query. Array length limit: 50.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 50.
        :type Limit: int
        :param _Type: The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :type Type: str
        :param _Name: Filter condition for intelligent auditing template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""The IDs of the content moderation templates to query. Array length limit: 50.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 50.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for intelligent auditing template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    r"""DescribeContentReviewTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ContentReviewTemplateSet: List of content audit template details.
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        r"""List of content audit template details.
        :rtype: list of ContentReviewTemplateItem
        """
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    r"""DescribeImageSpriteTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of image sprite generating templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Filter condition for sprite template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of image sprite generating templates. Array length limit: 100.
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for sprite template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    r"""DescribeImageSpriteTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: List of image sprite generating template details.
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        r"""List of image sprite generating template details.
        :rtype: list of ImageSpriteTemplate
        """
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageTaskDetailRequest(AbstractModel):
    r"""DescribeImageTaskDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Image processing task ID.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Image processing task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageTaskDetailResponse(AbstractModel):
    r"""DescribeImageTaskDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task type. Currently, the valid values include:
<li>WorkflowTask: workflow processing task.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskType: str
        :param _Status: Task status. Valid values:
<Li>WAITING: waiting.</li>
<Li>PROCESSING: processing.</li>
<li>FINISH: completed.</li>
Note: This field may return null, indicating that no valid value can be obtained.
        :type Status: str
        :param _ErrCode: Error code when the task fails.
        :type ErrCode: int
        :param _ErrMsg: Error code. A null string indicates that the task is successful, while other values indicate that the task has failed. For valid values, see the list of [MPS error codes](https://www.tencentcloud.comom/document/product/862/50369?from_cn_redirect=1#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81).
        :type ErrMsg: str
        :param _Message: Task exception message.
        :type Message: str
        :param _ImageProcessTaskResultSet: Execution status and results of the image processing task.
Note: This field may return null, indicating that no valid value can be obtained.
        :type ImageProcessTaskResultSet: list of ImageProcessTaskResult
        :param _CreateTime: Task creation time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _FinishTime: Task execution completion time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return null, indicating that no valid value can be obtained.
        :type FinishTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._ErrCode = None
        self._ErrMsg = None
        self._Message = None
        self._ImageProcessTaskResultSet = None
        self._CreateTime = None
        self._FinishTime = None
        self._RequestId = None

    @property
    def TaskType(self):
        r"""Task type. Currently, the valid values include:
<li>WorkflowTask: workflow processing task.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        r"""Task status. Valid values:
<Li>WAITING: waiting.</li>
<Li>PROCESSING: processing.</li>
<li>FINISH: completed.</li>
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        r"""Error code when the task fails.
        :rtype: int
        """
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        r"""Error code. A null string indicates that the task is successful, while other values indicate that the task has failed. For valid values, see the list of [MPS error codes](https://www.tencentcloud.comom/document/product/862/50369?from_cn_redirect=1#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81).
        :rtype: str
        """
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def Message(self):
        r"""Task exception message.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def ImageProcessTaskResultSet(self):
        r"""Execution status and results of the image processing task.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of ImageProcessTaskResult
        """
        return self._ImageProcessTaskResultSet

    @ImageProcessTaskResultSet.setter
    def ImageProcessTaskResultSet(self, ImageProcessTaskResultSet):
        self._ImageProcessTaskResultSet = ImageProcessTaskResultSet

    @property
    def CreateTime(self):
        r"""Task creation time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def FinishTime(self):
        r"""Task execution completion time in [ISO datetime format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        self._Message = params.get("Message")
        if params.get("ImageProcessTaskResultSet") is not None:
            self._ImageProcessTaskResultSet = []
            for item in params.get("ImageProcessTaskResultSet"):
                obj = ImageProcessTaskResult()
                obj._deserialize(item)
                self._ImageProcessTaskResultSet.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._FinishTime = params.get("FinishTime")
        self._RequestId = params.get("RequestId")


class DescribeLiveRecordTemplatesRequest(AbstractModel):
    r"""DescribeLiveRecordTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Specifies the recording template unique identifier filter condition, with an array length limit of 100.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Indicates the template type filter condition. If left empty, all templates are returned. Valid values:
* Preset: System preset template;
* Custom
        :type Type: str
        :param _Name: Specifies the recording template identifier filter condition, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Specifies the recording template unique identifier filter condition, with an array length limit of 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Indicates the template type filter condition. If left empty, all templates are returned. Valid values:
* Preset: System preset template;
* Custom
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Specifies the recording template identifier filter condition, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveRecordTemplatesResponse(AbstractModel):
    r"""DescribeLiveRecordTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records that meet filter conditions.
        :type TotalCount: int
        :param _LiveRecordTemplateSet: Recording template details list.
        :type LiveRecordTemplateSet: list of LiveRecordTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LiveRecordTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records that meet filter conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LiveRecordTemplateSet(self):
        r"""Recording template details list.
        :rtype: list of LiveRecordTemplate
        """
        return self._LiveRecordTemplateSet

    @LiveRecordTemplateSet.setter
    def LiveRecordTemplateSet(self, LiveRecordTemplateSet):
        self._LiveRecordTemplateSet = LiveRecordTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LiveRecordTemplateSet") is not None:
            self._LiveRecordTemplateSet = []
            for item in params.get("LiveRecordTemplateSet"):
                obj = LiveRecordTemplate()
                obj._deserialize(item)
                self._LiveRecordTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaMetaDataRequest(AbstractModel):
    r"""DescribeMediaMetaData request structure.

    """

    def __init__(self):
        r"""
        :param _InputInfo: Input information of file for metadata getting.
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._InputInfo = None

    @property
    def InputInfo(self):
        r"""Input information of file for metadata getting.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaMetaDataResponse(AbstractModel):
    r"""DescribeMediaMetaData response structure.

    """

    def __init__(self):
        r"""
        :param _MetaData: Media metadata.
        :type MetaData: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetaData = None
        self._RequestId = None

    @property
    def MetaData(self):
        r"""Media metadata.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        """
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._RequestId = params.get("RequestId")


class DescribePersonSamplesRequest(AbstractModel):
    r"""DescribePersonSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Type of images to pull. Valid values:
<li>UserDefine: custom image library</li>
<li>Default: default image library</li>

Default value: UserDefine. Samples in the custom image library will be pulled.
Note: you can pull the default image library only using the image name or a combination of the image name and ID, and only one face image is returned.
        :type Type: str
        :param _PersonIds: Image ID. Array length limit: 100
        :type PersonIds: list of str
        :param _Names: Image name. Array length limit: 20
        :type Names: list of str
        :param _Tags: Image tag. Array length limit: 20
        :type Tags: list of str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 100. Maximum value: 100.
        :type Limit: int
        """
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Type(self):
        r"""Type of images to pull. Valid values:
<li>UserDefine: custom image library</li>
<li>Default: default image library</li>

Default value: UserDefine. Samples in the custom image library will be pulled.
Note: you can pull the default image library only using the image name or a combination of the image name and ID, and only one face image is returned.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        r"""Image ID. Array length limit: 100
        :rtype: list of str
        """
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        r"""Image name. Array length limit: 20
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        r"""Image tag. Array length limit: 20
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 100. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    r"""DescribePersonSamples response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _PersonSet: Image information
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        r"""Image information
        :rtype: list of AiSamplePerson
        """
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProcessImageTemplatesRequest(AbstractModel):
    r"""DescribeProcessImageTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Filtering condition for the unique identifier of the image processing template. The array length cannot exceed 100.
        :type Definitions: list of int
        :param _Offset: Pagination offset. The default value is 0.
        :type Offset: int
        :param _Limit: Number of returned entries. The default value is 10, and the maximum value is 100.
        :type Limit: int
        :param _Name: Filtering condition for the identifier of the image processing template.
        :type Name: str
        :param _OrderType: Sorting method. It is valid after OrderBy is set. Valid values: 0: ascending; 1: descending. The default value is 0.
        :type OrderType: int
        :param _OrderBy: Sorting field. Valid values:
Definition: unique identifier of the template.
Default value: creation time.
        :type OrderBy: str
        :param _Type: Filtering condition for the template type. Valid values: <li>Preset: system preset template;</li> <li>Custom: user-defined template.</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Name = None
        self._OrderType = None
        self._OrderBy = None
        self._Type = None

    @property
    def Definitions(self):
        r"""Filtering condition for the unique identifier of the image processing template. The array length cannot exceed 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Pagination offset. The default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. The default value is 10, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Name(self):
        r"""Filtering condition for the identifier of the image processing template.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def OrderType(self):
        r"""Sorting method. It is valid after OrderBy is set. Valid values: 0: ascending; 1: descending. The default value is 0.
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def OrderBy(self):
        r"""Sorting field. Valid values:
Definition: unique identifier of the template.
Default value: creation time.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Type(self):
        r"""Filtering condition for the template type. Valid values: <li>Preset: system preset template;</li> <li>Custom: user-defined template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Name = params.get("Name")
        self._OrderType = params.get("OrderType")
        self._OrderBy = params.get("OrderBy")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProcessImageTemplatesResponse(AbstractModel):
    r"""DescribeProcessImageTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records that meet the filtering conditions.
        :type TotalCount: int
        :param _ProcessImageTemplateSet: List of image processing template details.
        :type ProcessImageTemplateSet: list of ProcessImageTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProcessImageTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records that meet the filtering conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProcessImageTemplateSet(self):
        r"""List of image processing template details.
        :rtype: list of ProcessImageTemplate
        """
        return self._ProcessImageTemplateSet

    @ProcessImageTemplateSet.setter
    def ProcessImageTemplateSet(self, ProcessImageTemplateSet):
        self._ProcessImageTemplateSet = ProcessImageTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProcessImageTemplateSet") is not None:
            self._ProcessImageTemplateSet = []
            for item in params.get("ProcessImageTemplateSet"):
                obj = ProcessImageTemplate()
                obj._deserialize(item)
                self._ProcessImageTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQualityControlTemplatesRequest(AbstractModel):
    r"""DescribeQualityControlTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Filter condition for media quality inspection template unique identifiers, with an array length limit of 100.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries.

<li>Default value: 10.</li>
<li>Maximum value: 100.</li>
        :type Limit: int
        :param _Type: "Preset": preset template, "Custom": custom template
        :type Type: str
        :param _Name: Filter condition for media quality inspection template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Filter condition for media quality inspection template unique identifiers, with an array length limit of 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries.

<li>Default value: 10.</li>
<li>Maximum value: 100.</li>
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r""""Preset": preset template, "Custom": custom template
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for media quality inspection template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityControlTemplatesResponse(AbstractModel):
    r"""DescribeQualityControlTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records that meet filter conditions.
        :type TotalCount: int
        :param _QualityControlTemplateSet: List of media quality inspection templates.
        :type QualityControlTemplateSet: list of QualityControlTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._QualityControlTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records that meet filter conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QualityControlTemplateSet(self):
        r"""List of media quality inspection templates.
        :rtype: list of QualityControlTemplate
        """
        return self._QualityControlTemplateSet

    @QualityControlTemplateSet.setter
    def QualityControlTemplateSet(self, QualityControlTemplateSet):
        self._QualityControlTemplateSet = QualityControlTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QualityControlTemplateSet") is not None:
            self._QualityControlTemplateSet = []
            for item in params.get("QualityControlTemplateSet"):
                obj = QualityControlTemplate()
                obj._deserialize(item)
                self._QualityControlTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleSnapshotTemplatesRequest(AbstractModel):
    r"""DescribeSampleSnapshotTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of sampled screencapturing templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Filter condition for sampled screenshot template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of sampled screencapturing templates. Array length limit: 100.
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for sampled screenshot template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesResponse(AbstractModel):
    r"""DescribeSampleSnapshotTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _SampleSnapshotTemplateSet: List of sampled screencapturing template details.
        :type SampleSnapshotTemplateSet: list of SampleSnapshotTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SampleSnapshotTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SampleSnapshotTemplateSet(self):
        r"""List of sampled screencapturing template details.
        :rtype: list of SampleSnapshotTemplate
        """
        return self._SampleSnapshotTemplateSet

    @SampleSnapshotTemplateSet.setter
    def SampleSnapshotTemplateSet(self, SampleSnapshotTemplateSet):
        self._SampleSnapshotTemplateSet = SampleSnapshotTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SampleSnapshotTemplateSet") is not None:
            self._SampleSnapshotTemplateSet = []
            for item in params.get("SampleSnapshotTemplateSet"):
                obj = SampleSnapshotTemplate()
                obj._deserialize(item)
                self._SampleSnapshotTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulesRequest(AbstractModel):
    r"""DescribeSchedules request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleIds: The IDs of the schemes to query. Array length limit: 100.
        :type ScheduleIds: list of int
        :param _TriggerType: The trigger type. Valid values:
<li>`CosFileUpload`: The scheme is triggered when a file is uploaded to Tencent Cloud Object Storage (COS).</li>
<li>`AwsS3FileUpload`: The scheme is triggered when a file is uploaded to AWS S3.</li>
If you do not specify this parameter or leave it empty, all schemes will be returned regardless of the trigger type.
        :type TriggerType: str
        :param _Status: The scheme status. Valid values:
<li>`Enabled`</li>
<li>`Disabled`</li>
If you do not specify this parameter, all schemes will be returned regardless of the status.
        :type Status: str
        :param _Offset: The pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: The maximum number of records to return. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._ScheduleIds = None
        self._TriggerType = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def ScheduleIds(self):
        r"""The IDs of the schemes to query. Array length limit: 100.
        :rtype: list of int
        """
        return self._ScheduleIds

    @ScheduleIds.setter
    def ScheduleIds(self, ScheduleIds):
        self._ScheduleIds = ScheduleIds

    @property
    def TriggerType(self):
        r"""The trigger type. Valid values:
<li>`CosFileUpload`: The scheme is triggered when a file is uploaded to Tencent Cloud Object Storage (COS).</li>
<li>`AwsS3FileUpload`: The scheme is triggered when a file is uploaded to AWS S3.</li>
If you do not specify this parameter or leave it empty, all schemes will be returned regardless of the trigger type.
        :rtype: str
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def Status(self):
        r"""The scheme status. Valid values:
<li>`Enabled`</li>
<li>`Disabled`</li>
If you do not specify this parameter, all schemes will be returned regardless of the status.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        r"""The pagination offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The maximum number of records to return. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ScheduleIds = params.get("ScheduleIds")
        self._TriggerType = params.get("TriggerType")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulesResponse(AbstractModel):
    r"""DescribeSchedules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _ScheduleInfoSet: The information of the schemes.
        :type ScheduleInfoSet: list of SchedulesInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ScheduleInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of records that meet the conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScheduleInfoSet(self):
        r"""The information of the schemes.
        :rtype: list of SchedulesInfo
        """
        return self._ScheduleInfoSet

    @ScheduleInfoSet.setter
    def ScheduleInfoSet(self, ScheduleInfoSet):
        self._ScheduleInfoSet = ScheduleInfoSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ScheduleInfoSet") is not None:
            self._ScheduleInfoSet = []
            for item in params.get("ScheduleInfoSet"):
                obj = SchedulesInfo()
                obj._deserialize(item)
                self._ScheduleInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSmartEraseTemplatesRequest(AbstractModel):
    r"""DescribeSmartEraseTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Filtering condition for the unique identifier of the smart erasing template. Length limit of the array: 100.
        :type Definitions: list of int
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Filtering conditions for template type. If this parameter is not specified, all templates are returned. Valid values:
* Preset: system preset template.
* Custom: user-defined template.
        :type Type: str
        :param _EraseType: Erasing type filtering conditions for the smart erasing template.
- subtitle: subtitle removal.
- watermark: watermark removal.
- privacy: privacy protection.
        :type EraseType: str
        :param _Name: Filtering condition for the smart erasing template name. Length limit: 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._EraseType = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Filtering condition for the unique identifier of the smart erasing template. Length limit of the array: 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Pagination offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Filtering conditions for template type. If this parameter is not specified, all templates are returned. Valid values:
* Preset: system preset template.
* Custom: user-defined template.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def EraseType(self):
        r"""Erasing type filtering conditions for the smart erasing template.
- subtitle: subtitle removal.
- watermark: watermark removal.
- privacy: privacy protection.
        :rtype: str
        """
        return self._EraseType

    @EraseType.setter
    def EraseType(self, EraseType):
        self._EraseType = EraseType

    @property
    def Name(self):
        r"""Filtering condition for the smart erasing template name. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._EraseType = params.get("EraseType")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSmartEraseTemplatesResponse(AbstractModel):
    r"""DescribeSmartEraseTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records that meet the filtering conditions.
        :type TotalCount: int
        :param _SmartEraseTemplateSet: List of smart erasing template details.
        :type SmartEraseTemplateSet: list of SmartEraseTemplateItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SmartEraseTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records that meet the filtering conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SmartEraseTemplateSet(self):
        r"""List of smart erasing template details.
        :rtype: list of SmartEraseTemplateItem
        """
        return self._SmartEraseTemplateSet

    @SmartEraseTemplateSet.setter
    def SmartEraseTemplateSet(self, SmartEraseTemplateSet):
        self._SmartEraseTemplateSet = SmartEraseTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SmartEraseTemplateSet") is not None:
            self._SmartEraseTemplateSet = []
            for item in params.get("SmartEraseTemplateSet"):
                obj = SmartEraseTemplateItem()
                obj._deserialize(item)
                self._SmartEraseTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSmartSubtitleTemplatesRequest(AbstractModel):
    r"""DescribeSmartSubtitleTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique identifiers of smart subtitle templates for filtering. The array can contain up to 100 unique identifiers.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Condition for filtering templates by type. If this field is not specified, all templates are returned. Valid values:
* Preset: system preset template
* Custom: user-defined template
        :type Type: str
        :param _Name: Condition for filtering smart subtitle templates by ID. Length limit: 64 characters.
        :type Name: str
        :param _ProcessType: Subtitle processing type.
- 0: ASR recognition subtitle.
- 1: pure subtitle translation.
        :type ProcessType: int
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None
        self._ProcessType = None

    @property
    def Definitions(self):
        r"""Unique identifiers of smart subtitle templates for filtering. The array can contain up to 100 unique identifiers.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Condition for filtering templates by type. If this field is not specified, all templates are returned. Valid values:
* Preset: system preset template
* Custom: user-defined template
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Condition for filtering smart subtitle templates by ID. Length limit: 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProcessType(self):
        r"""Subtitle processing type.
- 0: ASR recognition subtitle.
- 1: pure subtitle translation.
        :rtype: int
        """
        return self._ProcessType

    @ProcessType.setter
    def ProcessType(self, ProcessType):
        self._ProcessType = ProcessType


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._ProcessType = params.get("ProcessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSmartSubtitleTemplatesResponse(AbstractModel):
    r"""DescribeSmartSubtitleTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records that meet filter conditions.
        :type TotalCount: int
        :param _SmartSubtitleTemplateSet: List of smart subtitle template details.
        :type SmartSubtitleTemplateSet: list of SmartSubtitleTemplateItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SmartSubtitleTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records that meet filter conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SmartSubtitleTemplateSet(self):
        r"""List of smart subtitle template details.
        :rtype: list of SmartSubtitleTemplateItem
        """
        return self._SmartSubtitleTemplateSet

    @SmartSubtitleTemplateSet.setter
    def SmartSubtitleTemplateSet(self, SmartSubtitleTemplateSet):
        self._SmartSubtitleTemplateSet = SmartSubtitleTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SmartSubtitleTemplateSet") is not None:
            self._SmartSubtitleTemplateSet = []
            for item in params.get("SmartSubtitleTemplateSet"):
                obj = SmartSubtitleTemplateItem()
                obj._deserialize(item)
                self._SmartSubtitleTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotByTimeOffsetTemplatesRequest(AbstractModel):
    r"""DescribeSnapshotByTimeOffsetTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of time point screencapturing templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Filter condition for time point screenshot template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of time point screencapturing templates. Array length limit: 100.
        :rtype: list of int non-negative
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        r"""Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""Filter condition for time point screenshot template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotByTimeOffsetTemplatesResponse(AbstractModel):
    r"""DescribeSnapshotByTimeOffsetTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _SnapshotByTimeOffsetTemplateSet: List of time point screencapturing template details.
        :type SnapshotByTimeOffsetTemplateSet: list of SnapshotByTimeOffsetTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SnapshotByTimeOffsetTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SnapshotByTimeOffsetTemplateSet(self):
        r"""List of time point screencapturing template details.
        :rtype: list of SnapshotByTimeOffsetTemplate
        """
        return self._SnapshotByTimeOffsetTemplateSet

    @SnapshotByTimeOffsetTemplateSet.setter
    def SnapshotByTimeOffsetTemplateSet(self, SnapshotByTimeOffsetTemplateSet):
        self._SnapshotByTimeOffsetTemplateSet = SnapshotByTimeOffsetTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SnapshotByTimeOffsetTemplateSet") is not None:
            self._SnapshotByTimeOffsetTemplateSet = []
            for item in params.get("SnapshotByTimeOffsetTemplateSet"):
                obj = SnapshotByTimeOffsetTemplate()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkSecurityGroupRequest(AbstractModel):
    r"""DescribeStreamLinkSecurityGroup request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Security group ID.
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        r"""Security group ID.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkSecurityGroupResponse(AbstractModel):
    r"""DescribeStreamLinkSecurityGroup response structure.

    """

    def __init__(self):
        r"""
        :param _Info: Information on the input security group.
        :type Info: :class:`tencentcloud.mps.v20190612.models.SecurityGroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        r"""Information on the input security group.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SecurityGroupInfo`
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = SecurityGroupInfo()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    r"""DescribeTaskDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video processing task ID.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Video processing task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    r"""DescribeTaskDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task type. Valid values:<li>WorkflowTask: video workflow processing task.</li><li>EditMediaTask: video editing task.</li><li>LiveStreamProcessTask: live stream processing task.</li><li>ScheduleTask: orchestration processing task.</li><li>EvaluationTask: evaluation task.</li>
        :type TaskType: str
        :param _Status: Task status. Valid values:
<li>WAITING: Waiting;</li>
<li>PROCESSING: Processing;</li>
<li>FINISH: Completed.</li>
        :type Status: str
        :param _CreateTime: Creation time of a task in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _BeginProcessTime: Start time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type BeginProcessTime: str
        :param _FinishTime: End time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type FinishTime: str
        :param _EditMediaTask: Video editing task information. This field has a value only when `TaskType` is `EditMediaTask`.
        :type EditMediaTask: :class:`tencentcloud.mps.v20190612.models.EditMediaTask`
        :param _WorkflowTask: Information of a video processing task. This field has a value only when `TaskType` is `WorkflowTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkflowTask: :class:`tencentcloud.mps.v20190612.models.WorkflowTask`
        :param _LiveStreamProcessTask: Information of a live stream processing task. This field has a value only when `TaskType` is `LiveStreamProcessTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LiveStreamProcessTask: :class:`tencentcloud.mps.v20190612.models.LiveStreamProcessTask`
        :param _ExtractBlindWatermarkTask: Extracts digital watermark task information. this field has a value only when TaskType is ExtractBlindWatermark.
        :type ExtractBlindWatermarkTask: :class:`tencentcloud.mps.v20190612.models.ExtractBlindWatermarkTask`
        :param _TaskNotifyConfig: Event notification information of a task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Task flow priority. Value range: [-10, 10].
        :type TasksPriority: int
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _ExtInfo: Extended information field, used in specific scenarios.
        :type ExtInfo: str
        :param _ScheduleTask: The information of a scheme. This parameter is valid only if `TaskType` is `ScheduleTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScheduleTask: :class:`tencentcloud.mps.v20190612.models.ScheduleTask`
        :param _LiveScheduleTask: The information of a live scheme. This parameter is valid only if `TaskType` is `LiveScheduleTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LiveScheduleTask: :class:`tencentcloud.mps.v20190612.models.LiveScheduleTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._EditMediaTask = None
        self._WorkflowTask = None
        self._LiveStreamProcessTask = None
        self._ExtractBlindWatermarkTask = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None
        self._ExtInfo = None
        self._ScheduleTask = None
        self._LiveScheduleTask = None
        self._RequestId = None

    @property
    def TaskType(self):
        r"""Task type. Valid values:<li>WorkflowTask: video workflow processing task.</li><li>EditMediaTask: video editing task.</li><li>LiveStreamProcessTask: live stream processing task.</li><li>ScheduleTask: orchestration processing task.</li><li>EvaluationTask: evaluation task.</li>
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        r"""Task status. Valid values:
<li>WAITING: Waiting;</li>
<li>PROCESSING: Processing;</li>
<li>FINISH: Completed.</li>
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        r"""Creation time of a task in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        r"""Start time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        r"""End time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def EditMediaTask(self):
        r"""Video editing task information. This field has a value only when `TaskType` is `EditMediaTask`.
        :rtype: :class:`tencentcloud.mps.v20190612.models.EditMediaTask`
        """
        return self._EditMediaTask

    @EditMediaTask.setter
    def EditMediaTask(self, EditMediaTask):
        self._EditMediaTask = EditMediaTask

    @property
    def WorkflowTask(self):
        r"""Information of a video processing task. This field has a value only when `TaskType` is `WorkflowTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.WorkflowTask`
        """
        return self._WorkflowTask

    @WorkflowTask.setter
    def WorkflowTask(self, WorkflowTask):
        self._WorkflowTask = WorkflowTask

    @property
    def LiveStreamProcessTask(self):
        r"""Information of a live stream processing task. This field has a value only when `TaskType` is `LiveStreamProcessTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.LiveStreamProcessTask`
        """
        return self._LiveStreamProcessTask

    @LiveStreamProcessTask.setter
    def LiveStreamProcessTask(self, LiveStreamProcessTask):
        self._LiveStreamProcessTask = LiveStreamProcessTask

    @property
    def ExtractBlindWatermarkTask(self):
        r"""Extracts digital watermark task information. this field has a value only when TaskType is ExtractBlindWatermark.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ExtractBlindWatermarkTask`
        """
        return self._ExtractBlindWatermarkTask

    @ExtractBlindWatermarkTask.setter
    def ExtractBlindWatermarkTask(self, ExtractBlindWatermarkTask):
        self._ExtractBlindWatermarkTask = ExtractBlindWatermarkTask

    @property
    def TaskNotifyConfig(self):
        r"""Event notification information of a task.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""Task flow priority. Value range: [-10, 10].
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        r"""The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        r"""Extended information field, used in specific scenarios.
        :rtype: str
        """
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def ScheduleTask(self):
        r"""The information of a scheme. This parameter is valid only if `TaskType` is `ScheduleTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ScheduleTask`
        """
        return self._ScheduleTask

    @ScheduleTask.setter
    def ScheduleTask(self, ScheduleTask):
        self._ScheduleTask = ScheduleTask

    @property
    def LiveScheduleTask(self):
        r"""The information of a live scheme. This parameter is valid only if `TaskType` is `LiveScheduleTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.LiveScheduleTask`
        """
        return self._LiveScheduleTask

    @LiveScheduleTask.setter
    def LiveScheduleTask(self, LiveScheduleTask):
        self._LiveScheduleTask = LiveScheduleTask

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        if params.get("EditMediaTask") is not None:
            self._EditMediaTask = EditMediaTask()
            self._EditMediaTask._deserialize(params.get("EditMediaTask"))
        if params.get("WorkflowTask") is not None:
            self._WorkflowTask = WorkflowTask()
            self._WorkflowTask._deserialize(params.get("WorkflowTask"))
        if params.get("LiveStreamProcessTask") is not None:
            self._LiveStreamProcessTask = LiveStreamProcessTask()
            self._LiveStreamProcessTask._deserialize(params.get("LiveStreamProcessTask"))
        if params.get("ExtractBlindWatermarkTask") is not None:
            self._ExtractBlindWatermarkTask = ExtractBlindWatermarkTask()
            self._ExtractBlindWatermarkTask._deserialize(params.get("ExtractBlindWatermarkTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        if params.get("ScheduleTask") is not None:
            self._ScheduleTask = ScheduleTask()
            self._ScheduleTask._deserialize(params.get("ScheduleTask"))
        if params.get("LiveScheduleTask") is not None:
            self._LiveScheduleTask = LiveScheduleTask()
            self._LiveScheduleTask._deserialize(params.get("LiveScheduleTask"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    r"""DescribeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _Status: Filters task status. available values:.
-WAITING.
-PROCESSING (processing).
-FINISH (completed).
        :type Status: str
        :param _SubTaskHasFailed: Whether there is a failed subtask when the task ends. If this parameter is left unspecified, ignore it.
<li>false: filter the main tasks to identify those that have no failed subtasks.</li>
<li>true: filter the main tasks to identify those that have failed subtasks.</li>
        :type SubTaskHasFailed: bool
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _ScrollToken: Scrolling identifier which is used for pulling in batches. If a single request cannot pull all the data entries, the API will return `ScrollToken`, and if the next request carries it, the next pull will start from the next entry.
        :type ScrollToken: str
        :param _StartTime: Query task start time.
        :type StartTime: str
        :param _EndTime: Query task end time.
        :type EndTime: str
        """
        self._Status = None
        self._SubTaskHasFailed = None
        self._Limit = None
        self._ScrollToken = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Status(self):
        r"""Filters task status. available values:.
-WAITING.
-PROCESSING (processing).
-FINISH (completed).
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SubTaskHasFailed(self):
        r"""Whether there is a failed subtask when the task ends. If this parameter is left unspecified, ignore it.
<li>false: filter the main tasks to identify those that have no failed subtasks.</li>
<li>true: filter the main tasks to identify those that have failed subtasks.</li>
        :rtype: bool
        """
        return self._SubTaskHasFailed

    @SubTaskHasFailed.setter
    def SubTaskHasFailed(self, SubTaskHasFailed):
        self._SubTaskHasFailed = SubTaskHasFailed

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ScrollToken(self):
        r"""Scrolling identifier which is used for pulling in batches. If a single request cannot pull all the data entries, the API will return `ScrollToken`, and if the next request carries it, the next pull will start from the next entry.
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def StartTime(self):
        r"""Query task start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Query task end time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._SubTaskHasFailed = params.get("SubTaskHasFailed")
        self._Limit = params.get("Limit")
        self._ScrollToken = params.get("ScrollToken")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    r"""DescribeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TaskSet: Task overview list.
        :type TaskSet: list of TaskSimpleInfo
        :param _ScrollToken: Scrolling identifier. If a request does not return all the data entries, this field indicates the ID of the next entry. If this field is an empty string, there is no more data.
        :type ScrollToken: str
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskSet = None
        self._ScrollToken = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskSet(self):
        r"""Task overview list.
        :rtype: list of TaskSimpleInfo
        """
        return self._TaskSet

    @TaskSet.setter
    def TaskSet(self, TaskSet):
        self._TaskSet = TaskSet

    @property
    def ScrollToken(self):
        r"""Scrolling identifier. If a request does not return all the data entries, this field indicates the ID of the next entry. If this field is an empty string, there is no more data.
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def TotalCount(self):
        r"""The total number of records that meet the conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskSet") is not None:
            self._TaskSet = []
            for item in params.get("TaskSet"):
                obj = TaskSimpleInfo()
                obj._deserialize(item)
                self._TaskSet.append(obj)
        self._ScrollToken = params.get("ScrollToken")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTranscodeTemplatesRequest(AbstractModel):
    r"""DescribeTranscodeTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of transcoding templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _ContainerType: Container format filter. Valid values:
<li>Video: Video container format that can contain both video stream and audio stream;</li>
<li>PureAudio: Audio container format that can contain only audio stream.</li>
        :type ContainerType: str
        :param _TEHDType: TESHD filter, which is used to filter common transcoding or ultra-fast HD transcoding templates. Valid values:
<li>Common: Common transcoding template;</li>
<li>TEHD: TESHD template.</li>
        :type TEHDType: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _TranscodeType: The template type (replacing `TEHDType`). Valid values:
<li>Common: Common transcoding template</li>
<li>TEHD: TESHD template</li>
<li>Enhance: Audio/Video enhancement template.</li>
This parameter is left empty by default, which indicates to return all types of templates.
        :type TranscodeType: str
        :param _Name: Filter condition for transcoding template identifiers, with a length limit of 64 characters.	
        :type Name: str
        :param _SceneType: Video scenario. Optional values: 
normal: General transcoding scenario: General transcoding and compression scenario. 
pgc: PGC HD TV shows and movies: At the time of compression, focus is placed on the viewing experience of TV shows and movies and ROI encoding is performed according to their characteristics, while high-quality contents of videos and audio are retained. 
materials_video: HD materials: Scenario involving material resources, where requirements for image quality are extremely high and there are many transparent images, with almost no visual loss during compression. 
ugc: UGC content: It is suitable for a wide range of UGC/short video scenarios, with an optimized encoding bitrate for short video characteristics, improved image quality, and enhanced business QOS/QOE metrics. 
e-commerce_video: Fashion show/e-commerce: At the time of compression, emphasis is placed on detail clarity and ROI enhancement, with a particular focus on maintaining the image quality of the face region. 
educational_video: Education: At the time of compression, emphasis is placed on the clarity and readability of text and images to help students better understand the content, ensuring that the teaching content is clearly conveyed. 
no_config: Not configured.
        :type SceneType: str
        :param _CompressType: Transcoding policy. Optional values: 
ultra_compress: Extreme compression: Compared to standard compression, this policy can maximize bitrate compression while ensuring a certain level of image quality, thus greatly saving bandwidth and storage costs. 
standard_compress: Comprehensively optimal: The compression ratio and image quality are balanced, and files are compressed as much as possible without a noticeable reduction in subjective image quality. Only audio and video TSC transcoding fees are charged for this policy. 
high_compress: Bitrate priority: Priority is given to reducing file size, which may result in certain image quality loss. Only audio and video TSC transcoding fees are charged for this policy. 
low_compress: Image quality priority: Priority is given to ensuring image quality, and the size of compressed files may be relatively large. Only audio and video TSC transcoding fees are charged for this policy. 
no_config: Not configured.
        :type CompressType: str
        :param _EnhanceSceneType: Enhancement scenario configuration. Valid values:
<li>common: common enhancement parameters, which are basic optimization parameters suitable for various video types, enhancing overall image quality.</li>
<li>AIGC: overall resolution enhancement. It uses AI technology to improve the overall video resolution and image clarity.</li>
<li>short_play: enhance facial and subtitle details, emphasizing characters' facial expressions and subtitle clarity to improve the viewing experience.</li>
<li>short_video: optimize complex and diverse image quality issues, tailoring quality enhancements for the complex scenarios such as short videos to address various visual issues.</li>
<li>game: fix motion blur and enhance details, with a focus on enhancing the clarity of game details and restoring blurry areas during motions to make the image content during gaming clearer and richer.</li>
<li>HD_movie_series: provide a smooth playback effect for UHD videos. Standard 4K HDR videos with an FPS of 60 are generated to meet the needs of broadcasting/OTT for UHD videos. Formats for broadcasting scenarios are supported.</li>
<li>LQ_material: low-definition material/old video restoration. It enhances overall resolution, and solves issues of old videos, such as low resolution, blur, distortion, scratches, and color temperature due to their age.</li>
<li>lecture: live shows, e-commerce, conferences, and lectures. It improves the face display effect and performs specific optimizations, including face region enhancement, noise reduction, and artifacts removal, for scenarios involving human explanation, such as live shows, e-commerce, conferences, and lectures.</li>
        :type EnhanceSceneType: str
        :param _EnhanceTranscodeType: Enhanced transcoding type. Valid values:
<li>Common: standard transcoding.</li>
<li>TEHD-100: top speed codec video transcoding.</li>
<li>TEHD-200: top speed codec audio transcoding.</li>
        :type EnhanceTranscodeType: str
        :param _EnhanceType: Enhancement type. Valid values:
<li>VideoEnhance: video enhancement only.</li>
<li>AudioEnhance (audio enhancement only).</li>
<li>VideoAudioEnhance: video and audio enhancement included.</li>
        :type EnhanceType: str
        """
        self._Definitions = None
        self._Type = None
        self._ContainerType = None
        self._TEHDType = None
        self._Offset = None
        self._Limit = None
        self._TranscodeType = None
        self._Name = None
        self._SceneType = None
        self._CompressType = None
        self._EnhanceSceneType = None
        self._EnhanceTranscodeType = None
        self._EnhanceType = None

    @property
    def Definitions(self):
        r"""Unique ID filter of transcoding templates. Array length limit: 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ContainerType(self):
        r"""Container format filter. Valid values:
<li>Video: Video container format that can contain both video stream and audio stream;</li>
<li>PureAudio: Audio container format that can contain only audio stream.</li>
        :rtype: str
        """
        return self._ContainerType

    @ContainerType.setter
    def ContainerType(self, ContainerType):
        self._ContainerType = ContainerType

    @property
    def TEHDType(self):
        r"""TESHD filter, which is used to filter common transcoding or ultra-fast HD transcoding templates. Valid values:
<li>Common: Common transcoding template;</li>
<li>TEHD: TESHD template.</li>
        :rtype: str
        """
        return self._TEHDType

    @TEHDType.setter
    def TEHDType(self, TEHDType):
        self._TEHDType = TEHDType

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TranscodeType(self):
        r"""The template type (replacing `TEHDType`). Valid values:
<li>Common: Common transcoding template</li>
<li>TEHD: TESHD template</li>
<li>Enhance: Audio/Video enhancement template.</li>
This parameter is left empty by default, which indicates to return all types of templates.
        :rtype: str
        """
        return self._TranscodeType

    @TranscodeType.setter
    def TranscodeType(self, TranscodeType):
        self._TranscodeType = TranscodeType

    @property
    def Name(self):
        r"""Filter condition for transcoding template identifiers, with a length limit of 64 characters.	
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SceneType(self):
        r"""Video scenario. Optional values: 
normal: General transcoding scenario: General transcoding and compression scenario. 
pgc: PGC HD TV shows and movies: At the time of compression, focus is placed on the viewing experience of TV shows and movies and ROI encoding is performed according to their characteristics, while high-quality contents of videos and audio are retained. 
materials_video: HD materials: Scenario involving material resources, where requirements for image quality are extremely high and there are many transparent images, with almost no visual loss during compression. 
ugc: UGC content: It is suitable for a wide range of UGC/short video scenarios, with an optimized encoding bitrate for short video characteristics, improved image quality, and enhanced business QOS/QOE metrics. 
e-commerce_video: Fashion show/e-commerce: At the time of compression, emphasis is placed on detail clarity and ROI enhancement, with a particular focus on maintaining the image quality of the face region. 
educational_video: Education: At the time of compression, emphasis is placed on the clarity and readability of text and images to help students better understand the content, ensuring that the teaching content is clearly conveyed. 
no_config: Not configured.
        :rtype: str
        """
        return self._SceneType

    @SceneType.setter
    def SceneType(self, SceneType):
        self._SceneType = SceneType

    @property
    def CompressType(self):
        r"""Transcoding policy. Optional values: 
ultra_compress: Extreme compression: Compared to standard compression, this policy can maximize bitrate compression while ensuring a certain level of image quality, thus greatly saving bandwidth and storage costs. 
standard_compress: Comprehensively optimal: The compression ratio and image quality are balanced, and files are compressed as much as possible without a noticeable reduction in subjective image quality. Only audio and video TSC transcoding fees are charged for this policy. 
high_compress: Bitrate priority: Priority is given to reducing file size, which may result in certain image quality loss. Only audio and video TSC transcoding fees are charged for this policy. 
low_compress: Image quality priority: Priority is given to ensuring image quality, and the size of compressed files may be relatively large. Only audio and video TSC transcoding fees are charged for this policy. 
no_config: Not configured.
        :rtype: str
        """
        return self._CompressType

    @CompressType.setter
    def CompressType(self, CompressType):
        self._CompressType = CompressType

    @property
    def EnhanceSceneType(self):
        r"""Enhancement scenario configuration. Valid values:
<li>common: common enhancement parameters, which are basic optimization parameters suitable for various video types, enhancing overall image quality.</li>
<li>AIGC: overall resolution enhancement. It uses AI technology to improve the overall video resolution and image clarity.</li>
<li>short_play: enhance facial and subtitle details, emphasizing characters' facial expressions and subtitle clarity to improve the viewing experience.</li>
<li>short_video: optimize complex and diverse image quality issues, tailoring quality enhancements for the complex scenarios such as short videos to address various visual issues.</li>
<li>game: fix motion blur and enhance details, with a focus on enhancing the clarity of game details and restoring blurry areas during motions to make the image content during gaming clearer and richer.</li>
<li>HD_movie_series: provide a smooth playback effect for UHD videos. Standard 4K HDR videos with an FPS of 60 are generated to meet the needs of broadcasting/OTT for UHD videos. Formats for broadcasting scenarios are supported.</li>
<li>LQ_material: low-definition material/old video restoration. It enhances overall resolution, and solves issues of old videos, such as low resolution, blur, distortion, scratches, and color temperature due to their age.</li>
<li>lecture: live shows, e-commerce, conferences, and lectures. It improves the face display effect and performs specific optimizations, including face region enhancement, noise reduction, and artifacts removal, for scenarios involving human explanation, such as live shows, e-commerce, conferences, and lectures.</li>
        :rtype: str
        """
        return self._EnhanceSceneType

    @EnhanceSceneType.setter
    def EnhanceSceneType(self, EnhanceSceneType):
        self._EnhanceSceneType = EnhanceSceneType

    @property
    def EnhanceTranscodeType(self):
        r"""Enhanced transcoding type. Valid values:
<li>Common: standard transcoding.</li>
<li>TEHD-100: top speed codec video transcoding.</li>
<li>TEHD-200: top speed codec audio transcoding.</li>
        :rtype: str
        """
        return self._EnhanceTranscodeType

    @EnhanceTranscodeType.setter
    def EnhanceTranscodeType(self, EnhanceTranscodeType):
        self._EnhanceTranscodeType = EnhanceTranscodeType

    @property
    def EnhanceType(self):
        r"""Enhancement type. Valid values:
<li>VideoEnhance: video enhancement only.</li>
<li>AudioEnhance (audio enhancement only).</li>
<li>VideoAudioEnhance: video and audio enhancement included.</li>
        :rtype: str
        """
        return self._EnhanceType

    @EnhanceType.setter
    def EnhanceType(self, EnhanceType):
        self._EnhanceType = EnhanceType


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._ContainerType = params.get("ContainerType")
        self._TEHDType = params.get("TEHDType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TranscodeType = params.get("TranscodeType")
        self._Name = params.get("Name")
        self._SceneType = params.get("SceneType")
        self._CompressType = params.get("CompressType")
        self._EnhanceSceneType = params.get("EnhanceSceneType")
        self._EnhanceTranscodeType = params.get("EnhanceTranscodeType")
        self._EnhanceType = params.get("EnhanceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTranscodeTemplatesResponse(AbstractModel):
    r"""DescribeTranscodeTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _TranscodeTemplateSet: List of transcoding template details.
        :type TranscodeTemplateSet: list of TranscodeTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranscodeTemplateSet(self):
        r"""List of transcoding template details.
        :rtype: list of TranscodeTemplate
        """
        return self._TranscodeTemplateSet

    @TranscodeTemplateSet.setter
    def TranscodeTemplateSet(self, TranscodeTemplateSet):
        self._TranscodeTemplateSet = TranscodeTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranscodeTemplateSet") is not None:
            self._TranscodeTemplateSet = []
            for item in params.get("TranscodeTemplateSet"):
                obj = TranscodeTemplate()
                obj._deserialize(item)
                self._TranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWatermarkTemplatesRequest(AbstractModel):
    r"""DescribeWatermarkTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of watermarking templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Type: Watermark type filter. Valid values:
<li>image: Image watermark;</li>
<li>text: Text watermark.</li>
        :type Type: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries
<li>Default value: 10;</li>
<li>Maximum value: 100.</li>
        :type Limit: int
        :param _Name: Filter condition for watermark template identifiers, with a length limit of 64 characters.
        :type Name: str
        """
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None
        self._Name = None

    @property
    def Definitions(self):
        r"""Unique ID filter of watermarking templates. Array length limit: 100.
        :rtype: list of int
        """
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        r"""Watermark type filter. Valid values:
<li>image: Image watermark;</li>
<li>text: Text watermark.</li>
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries
<li>Default value: 10;</li>
<li>Maximum value: 100.</li>
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Name(self):
        r"""Filter condition for watermark template identifiers, with a length limit of 64 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWatermarkTemplatesResponse(AbstractModel):
    r"""DescribeWatermarkTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _WatermarkTemplateSet: List of watermarking template details.
        :type WatermarkTemplateSet: list of WatermarkTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WatermarkTemplateSet(self):
        r"""List of watermarking template details.
        :rtype: list of WatermarkTemplate
        """
        return self._WatermarkTemplateSet

    @WatermarkTemplateSet.setter
    def WatermarkTemplateSet(self, WatermarkTemplateSet):
        self._WatermarkTemplateSet = WatermarkTemplateSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WatermarkTemplateSet") is not None:
            self._WatermarkTemplateSet = []
            for item in params.get("WatermarkTemplateSet"):
                obj = WatermarkTemplate()
                obj._deserialize(item)
                self._WatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWordSamplesRequest(AbstractModel):
    r"""DescribeWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Keywords: Keyword filter. Array length limit: 100 words.
        :type Keywords: list of str
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
You can select multiple elements, which are connected by OR logic. If a usage contains any element in this parameter, the keyword sample will be used.
        :type Usages: list of str
        :param _Tags: Tag filter. Array length limit: 20 words.
        :type Tags: list of str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 100. Maximum value: 100.
        :type Limit: int
        """
        self._Keywords = None
        self._Usages = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Keywords(self):
        r"""Keyword filter. Array length limit: 100 words.
        :rtype: list of str
        """
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def Usages(self):
        r"""<b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
You can select multiple elements, which are connected by OR logic. If a usage contains any element in this parameter, the keyword sample will be used.
        :rtype: list of str
        """
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Tags(self):
        r"""Tag filter. Array length limit: 20 words.
        :rtype: list of str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 100. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        self._Usages = params.get("Usages")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWordSamplesResponse(AbstractModel):
    r"""DescribeWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of qualified records.
        :type TotalCount: int
        :param _WordSet: Keyword information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WordSet: list of AiSampleWord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WordSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of qualified records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WordSet(self):
        r"""Keyword information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of AiSampleWord
        """
        return self._WordSet

    @WordSet.setter
    def WordSet(self, WordSet):
        self._WordSet = WordSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WordSet") is not None:
            self._WordSet = []
            for item in params.get("WordSet"):
                obj = AiSampleWord()
                obj._deserialize(item)
                self._WordSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWorkflowsRequest(AbstractModel):
    r"""DescribeWorkflows request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: Workflow ID filter. Array length limit: 100.
        :type WorkflowIds: list of int
        :param _Status: Workflow status. Valid values:
<li>Enabled: Enabled,</li>
<li>Disabled: Disabled.</li>
If this parameter is left empty, the workflow status will not be distinguished.
        :type Status: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._WorkflowIds = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def WorkflowIds(self):
        r"""Workflow ID filter. Array length limit: 100.
        :rtype: list of int
        """
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def Status(self):
        r"""Workflow status. Valid values:
<li>Enabled: Enabled,</li>
<li>Disabled: Disabled.</li>
If this parameter is left empty, the workflow status will not be distinguished.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        r"""Paging offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned entries. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowsResponse(AbstractModel):
    r"""DescribeWorkflows response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _WorkflowInfoSet: Workflow information array.
        :type WorkflowInfoSet: list of WorkflowInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WorkflowInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WorkflowInfoSet(self):
        r"""Workflow information array.
        :rtype: list of WorkflowInfo
        """
        return self._WorkflowInfoSet

    @WorkflowInfoSet.setter
    def WorkflowInfoSet(self, WorkflowInfoSet):
        self._WorkflowInfoSet = WorkflowInfoSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WorkflowInfoSet") is not None:
            self._WorkflowInfoSet = []
            for item in params.get("WorkflowInfoSet"):
                obj = WorkflowInfo()
                obj._deserialize(item)
                self._WorkflowInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DiagnoseResult(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _Category: Diagnosed exception category. Valid values:
DecodeParamException: decoding parameter exception.
TimeStampException: timestamp exception.
FrameException: frame rate exception.
StreamStatusException: stream status exception.
StreamInfo: stream information exception.
StreamAbnormalCharacteristics: stream characteristics exception.
DecodeException: decoding exception.
HLSRequirements: HLS format exception.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Category: str
        :param _Type: Diagnosed specific exception type. Valid values:

VideoResolutionChanged: video resolution change.
AudioSampleRateChanged: audio sample rate change.
AudioChannelsChanged: audio channel quantity change.ParameterSetsChanged: stream parameter set information change.
DarOrSarInvalid: video aspect ratio exception.
TimestampFallback: DTS timestamp rollback.DtsJitter: DTS jitter too high.
PtsJitter: PTS jitter too high.
AACDurationDeviation: improper AAC frame timestamp interval.
AudioDroppingFrames: audio frame dropping.
VideoDroppingFrames: video frame dropping.
AVTimestampInterleave: improper audio-video interleaving.
PtsLessThanDts: PTS less than DTS for media streams.
ReceiveFpsJitter: significant jitter in the network receive frame rate.ReceiveFpsTooSmall: network receive video frame rate too low.FpsJitter: significant jitter in the stream frame rate calculated via PTS.StreamOpenFailed: stream open failure.
StreamEnd: stream end.
StreamParseFailed: stream parsing failure.
VideoFirstFrameNotIdr: first frame not an IDR frame.
StreamNALUError: NALU start code error.
TsStreamNoAud: no AUD NALU in the H26x stream of MPEG-TS.AudioStreamLack: no audio stream.
VideoStreamLack: no video stream.
LackAudioRecover: missing audio stream recovery.
LackVideoRecover: missing video stream recovery.
VideoBitrateOutofRange: video stream bitrate (kbps) out of range.
AudioBitrateOutofRange: audio stream bitrate (kbps) out of range.
VideoDecodeFailed: video decoding error.
AudioDecodeFailed: audio decoding error.
AudioOutOfPhase: opposite phase in dual-channel audio.
VideoDuplicatedFrame: duplicate frames in video streams.
AudioDuplicatedFrame: duplicate frames in audio streams.
VideoRotation: video rotation.
TsMultiPrograms: multiple programs in MPEG2-TS streams.Mp4InvalidCodecFourcc: codec FourCC in MP4 not meeting Apple HLS requirements.
HLSBadM3u8Format: invalid M3U8 file.
HLSInvalidMasterM3u8: invalid main M3U8 file.
HLSInvalidMediaM3u8: invalid media M3U8 file.
HLSMasterM3u8Recommended: parameters recommended by standards missing in main M3U8.
HLSMediaM3u8Recommended: parameters recommended by standards missing in media M3U8.
HLSMediaM3u8DiscontinuityExist: EXT-X-DISCONTINUITY in media M3U8.
HLSMediaSegmentsStreamNumChange: changed number of streams in segments.
HLSMediaSegmentsPTSJitterDeviation: PTS jumps between segments without EXT-X-DISCONTINUITY.
HLSMediaSegmentsDTSJitterDeviation: DTS jumps between segments without EXT-X-DISCONTINUITY.
TimecodeTrackExist: TMCD track in MP4.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Timestamp: 
        :type Timestamp: float
        :param _Description: 
        :type Description: str
        :param _DateTime: 
        :type DateTime: str
        :param _SeverityLevel: Diagnosed exception level. Valid values:
Fatal: affecting subsequent playback and parsing.
Error: may affect playback.
Warning: potential risk, which may not necessarily affect playback.
Notice: important stream information.
Info: general stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SeverityLevel: str
        """
        self._Category = None
        self._Type = None
        self._Timestamp = None
        self._Description = None
        self._DateTime = None
        self._SeverityLevel = None

    @property
    def Category(self):
        r"""Diagnosed exception category. Valid values:
DecodeParamException: decoding parameter exception.
TimeStampException: timestamp exception.
FrameException: frame rate exception.
StreamStatusException: stream status exception.
StreamInfo: stream information exception.
StreamAbnormalCharacteristics: stream characteristics exception.
DecodeException: decoding exception.
HLSRequirements: HLS format exception.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        r"""Diagnosed specific exception type. Valid values:

VideoResolutionChanged: video resolution change.
AudioSampleRateChanged: audio sample rate change.
AudioChannelsChanged: audio channel quantity change.ParameterSetsChanged: stream parameter set information change.
DarOrSarInvalid: video aspect ratio exception.
TimestampFallback: DTS timestamp rollback.DtsJitter: DTS jitter too high.
PtsJitter: PTS jitter too high.
AACDurationDeviation: improper AAC frame timestamp interval.
AudioDroppingFrames: audio frame dropping.
VideoDroppingFrames: video frame dropping.
AVTimestampInterleave: improper audio-video interleaving.
PtsLessThanDts: PTS less than DTS for media streams.
ReceiveFpsJitter: significant jitter in the network receive frame rate.ReceiveFpsTooSmall: network receive video frame rate too low.FpsJitter: significant jitter in the stream frame rate calculated via PTS.StreamOpenFailed: stream open failure.
StreamEnd: stream end.
StreamParseFailed: stream parsing failure.
VideoFirstFrameNotIdr: first frame not an IDR frame.
StreamNALUError: NALU start code error.
TsStreamNoAud: no AUD NALU in the H26x stream of MPEG-TS.AudioStreamLack: no audio stream.
VideoStreamLack: no video stream.
LackAudioRecover: missing audio stream recovery.
LackVideoRecover: missing video stream recovery.
VideoBitrateOutofRange: video stream bitrate (kbps) out of range.
AudioBitrateOutofRange: audio stream bitrate (kbps) out of range.
VideoDecodeFailed: video decoding error.
AudioDecodeFailed: audio decoding error.
AudioOutOfPhase: opposite phase in dual-channel audio.
VideoDuplicatedFrame: duplicate frames in video streams.
AudioDuplicatedFrame: duplicate frames in audio streams.
VideoRotation: video rotation.
TsMultiPrograms: multiple programs in MPEG2-TS streams.Mp4InvalidCodecFourcc: codec FourCC in MP4 not meeting Apple HLS requirements.
HLSBadM3u8Format: invalid M3U8 file.
HLSInvalidMasterM3u8: invalid main M3U8 file.
HLSInvalidMediaM3u8: invalid media M3U8 file.
HLSMasterM3u8Recommended: parameters recommended by standards missing in main M3U8.
HLSMediaM3u8Recommended: parameters recommended by standards missing in media M3U8.
HLSMediaM3u8DiscontinuityExist: EXT-X-DISCONTINUITY in media M3U8.
HLSMediaSegmentsStreamNumChange: changed number of streams in segments.
HLSMediaSegmentsPTSJitterDeviation: PTS jumps between segments without EXT-X-DISCONTINUITY.
HLSMediaSegmentsDTSJitterDeviation: DTS jumps between segments without EXT-X-DISCONTINUITY.
TimecodeTrackExist: TMCD track in MP4.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Timestamp(self):
        r"""
        :rtype: float
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Description(self):
        r"""
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DateTime(self):
        r"""
        :rtype: str
        """
        return self._DateTime

    @DateTime.setter
    def DateTime(self, DateTime):
        self._DateTime = DateTime

    @property
    def SeverityLevel(self):
        r"""Diagnosed exception level. Valid values:
Fatal: affecting subsequent playback and parsing.
Error: may affect playback.
Warning: potential risk, which may not necessarily affect playback.
Notice: important stream information.
Info: general stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SeverityLevel

    @SeverityLevel.setter
    def SeverityLevel(self, SeverityLevel):
        self._SeverityLevel = SeverityLevel


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._Timestamp = params.get("Timestamp")
        self._Description = params.get("Description")
        self._DateTime = params.get("DateTime")
        self._SeverityLevel = params.get("SeverityLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DiffusionEnhanceConfig(AbstractModel):
    r"""LLM enhancement.

    """

    def __init__(self):
        r"""
        :param _Switch: Capability configuration switch. Valid values:
ON: enabled.
OFF: disabled.
Default value: OFF.
        :type Switch: str
        :param _Type: Strength type. Valid values:
weak
normal
strong
Default value: normal.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        r"""Capability configuration switch. Valid values:
ON: enabled.
OFF: disabled.
Default value: OFF.
        :rtype: str
        """
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        r"""Strength type. Valid values:
weak
normal
strong
Default value: normal.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableScheduleRequest(AbstractModel):
    r"""DisableSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        r"""The scheme ID.
        :rtype: int
        """
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableScheduleResponse(AbstractModel):
    r"""DisableSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableWorkflowRequest(AbstractModel):
    r"""DisableWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        r"""Workflow ID.
        :rtype: int
        """
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableWorkflowResponse(AbstractModel):
    r"""DisableWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DrmInfo(AbstractModel):
    r"""The DRM encryption details.

    """

    def __init__(self):
        r"""
        :param _Type: Encryption type.

- simpleaes
Can only be used for HLS. format support: ts and mp4.
Only can be used in slice mode. cannot be used in singlefile mode.

- fairplay:
Can only be used for HLS. the segment format can only be mp4.
Supports slice mode or singlefile mode.

- widevine:
Can be used for HLS and DASH. the slice format can only be mp4.
Output HLS: specifies the slicing or singlefile mode can be used.
OutputOutput DASH]: can only be in singlefile mode.

- playready:
Can be used for HLS and DASH. the slice format can only be mp4.
Output HLS: specifies the slicing or singlefile mode can be used.
Output DASH: can only be in singlefile mode.

- widevine+fairplay,playready+fairplay,widevine+playready+fairplay:
Can only be used for HLS. valid values: mp4.
Supports slice mode or single file mode.

- widevine+playready:
Applicable to HLS and MPEG-DASH. the format can only be mp4.
HLS format can use slice mode or single file mode.
Specifies that only singlefile mode can be used for MPEG-DASH.
        :type Type: str
        :param _SimpleAesDrm: The AES-128 encryption details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SimpleAesDrm: :class:`tencentcloud.mps.v20190612.models.SimpleAesDrm`
        :param _SpekeDrm: Information about FairPlay, WideVine, and PlayReady encryption.
        :type SpekeDrm: :class:`tencentcloud.mps.v20190612.models.SpekeDrm`
        """
        self._Type = None
        self._SimpleAesDrm = None
        self._SpekeDrm = None

    @property
    def Type(self):
        r"""Encryption type.

- simpleaes
Can only be used for HLS. format support: ts and mp4.
Only can be used in slice mode. cannot be used in singlefile mode.

- fairplay:
Can only be used for HLS. the segment format can only be mp4.
Supports slice mode or singlefile mode.

- widevine:
Can be used for HLS and DASH. the slice format can only be mp4.
Output HLS: specifies the slicing or singlefile mode can be used.
OutputOutput DASH]: can only be in singlefile mode.

- playready:
Can be used for HLS and DASH. the slice format can only be mp4.
Output HLS: specifies the slicing or singlefile mode can be used.
Output DASH: can only be in singlefile mode.

- widevine+fairplay,playready+fairplay,widevine+playready+fairplay:
Can only be used for HLS. valid values: mp4.
Supports slice mode or single file mode.

- widevine+playready:
Applicable to HLS and MPEG-DASH. the format can only be mp4.
HLS format can use slice mode or single file mode.
Specifies that only singlefile mode can be used for MPEG-DASH.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SimpleAesDrm(self):
        r"""The AES-128 encryption details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SimpleAesDrm`
        """
        return self._SimpleAesDrm

    @SimpleAesDrm.setter
    def SimpleAesDrm(self, SimpleAesDrm):
        self._SimpleAesDrm = SimpleAesDrm

    @property
    def SpekeDrm(self):
        r"""Information about FairPlay, WideVine, and PlayReady encryption.
        :rtype: :class:`tencentcloud.mps.v20190612.models.SpekeDrm`
        """
        return self._SpekeDrm

    @SpekeDrm.setter
    def SpekeDrm(self, SpekeDrm):
        self._SpekeDrm = SpekeDrm


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("SimpleAesDrm") is not None:
            self._SimpleAesDrm = SimpleAesDrm()
            self._SimpleAesDrm._deserialize(params.get("SimpleAesDrm"))
        if params.get("SpekeDrm") is not None:
            self._SpekeDrm = SpekeDrm()
            self._SpekeDrm._deserialize(params.get("SpekeDrm"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaFileInfo(AbstractModel):
    r"""VOD video file editing information

    """

    def __init__(self):
        r"""
        :param _InputInfo: Video input information.
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _StartTimeOffset: The start offset (seconds) for video clipping. This parameter is valid for video clipping tasks.
        :type StartTimeOffset: float
        :param _EndTimeOffset: The end offset (seconds) for video clipping. This parameter is valid for video clipping tasks.
        :type EndTimeOffset: float
        :param _Id: The ID of the material associated with an element. This parameter is required for video compositing tasks.

Note: The ID can be up to 32 characters long and can contain letters, digits, and special characters -_
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: str
        """
        self._InputInfo = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Id = None

    @property
    def InputInfo(self):
        r"""Video input information.
        :rtype: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def StartTimeOffset(self):
        r"""The start offset (seconds) for video clipping. This parameter is valid for video clipping tasks.
        :rtype: float
        """
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        r"""The end offset (seconds) for video clipping. This parameter is valid for video clipping tasks.
        :rtype: float
        """
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Id(self):
        r"""The ID of the material associated with an element. This parameter is required for video compositing tasks.

Note: The ID can be up to 32 characters long and can contain letters, digits, and special characters -_
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaOutputConfig(AbstractModel):
    r"""Configuration for output files of video editing

    """

    def __init__(self):
        r"""
        :param _Container: The container. Valid values: `mp4` (default), `hls`, `mov`, `flv`, `avi`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Container: str
        :param _Type: Editing mode. Optional values:
normal (default): Precise editing
fast: Fast editing, with faster processing speed but lower precision to some extent
Note: fast only supports individual files, and the default output transcoding format of normal is h264.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        """
        self._Container = None
        self._Type = None

    @property
    def Container(self):
        r"""The container. Valid values: `mp4` (default), `hls`, `mov`, `flv`, `avi`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Type(self):
        r"""Editing mode. Optional values:
normal (default): Precise editing
fast: Fast editing, with faster processing speed but lower precision to some extent
Note: fast only supports individual files, and the default output transcoding format of normal is h264.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaRequest(AbstractModel):
    r"""EditMedia request structure.

    """

    def __init__(self):
        r"""
        :param _FileInfos: Information of input video file.
        :type FileInfos: list of EditMediaFileInfo
        :param _OutputStorage: The storage location of the media processing output file.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: The path to save the media processing output file.

Note: For complex compositing tasks, the filename can be up to 64 characters long and can only contain digits, letters, and special characters -_

        :type OutputObjectPath: str
        :param _OutputConfig: The output settings for a video clipping task.
        :type OutputConfig: :class:`tencentcloud.mps.v20190612.models.EditMediaOutputConfig`
        :param _ComposeConfig: The settings for a video compositing task.

Note: If this parameter is not empty, the task is a video compositing task. Otherwise, the task is a video clipping task.
        :type ComposeConfig: :class:`tencentcloud.mps.v20190612.models.ComposeMediaConfig`
        :param _TaskNotifyConfig: Event notification information of task. If this parameter is left empty, no event notifications will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Task priority. The higher the value, the higher the priority. Value range: -10 - 10. If this parameter is left empty, 0 will be used.
        :type TasksPriority: int
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last three days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        """
        self._FileInfos = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._OutputConfig = None
        self._ComposeConfig = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def FileInfos(self):
        r"""Information of input video file.
        :rtype: list of EditMediaFileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def OutputStorage(self):
        r"""The storage location of the media processing output file.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        r"""The path to save the media processing output file.

Note: For complex compositing tasks, the filename can be up to 64 characters long and can only contain digits, letters, and special characters -_

        :rtype: str
        """
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def OutputConfig(self):
        r"""The output settings for a video clipping task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.EditMediaOutputConfig`
        """
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def ComposeConfig(self):
        r"""The settings for a video compositing task.

Note: If this parameter is not empty, the task is a video compositing task. Otherwise, the task is a video clipping task.
        :rtype: :class:`tencentcloud.mps.v20190612.models.ComposeMediaConfig`
        """
        return self._ComposeConfig

    @ComposeConfig.setter
    def ComposeConfig(self, ComposeConfig):
        self._ComposeConfig = ComposeConfig

    @property
    def TaskNotifyConfig(self):
        r"""Event notification information of task. If this parameter is left empty, no event notifications will be obtained.
        :rtype: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        r"""Task priority. The higher the value, the higher the priority. Value range: -10 - 10. If this parameter is left empty, 0 will be used.
        :rtype: int
        """
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        r"""The ID used for deduplication. If there was a request with the same ID in the last three days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        r"""The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :rtype: str
        """
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = EditMediaOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        if params.get("ComposeConfig") is not None:
            self._ComposeConfig = ComposeMediaConfig()
            self._ComposeConfig._deserialize(params.get("ComposeConfig"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaResponse(AbstractModel):
    r"""EditMedia response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video editing task ID, which can be used to query the status of an editing task.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Video editing task ID, which can be used to query the status of an editing task.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, th