# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class ModifySendChannelOnMsgTypesRequest(AbstractModel):
    r"""ModifySendChannelOnMsgTypes request structure.

    """

    def __init__(self):
        r"""
        :param _SendTypes: Message sending channel.
        :type SendTypes: list of SendType
        """
        self._SendTypes = None

    @property
    def SendTypes(self):
        r"""Message sending channel.
        :rtype: list of SendType
        """
        return self._SendTypes

    @SendTypes.setter
    def SendTypes(self, SendTypes):
        self._SendTypes = SendTypes


    def _deserialize(self, params):
        if params.get("SendTypes") is not None:
            self._SendTypes = []
            for item in params.get("SendTypes"):
                obj = SendType()
                obj._deserialize(item)
                self._SendTypes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySendChannelOnMsgTypesResponse(AbstractModel):
    r"""ModifySendChannelOnMsgTypes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SendType(AbstractModel):
    r"""Message type sending channel.

    """

    def __init__(self):
        r"""
        :param _MsgType: Message type.
        :type MsgType: int
        :param _SendChannel: Delivery channel.
        :type SendChannel: int
        """
        self._MsgType = None
        self._SendChannel = None

    @property
    def MsgType(self):
        r"""Message type.
        :rtype: int
        """
        return self._MsgType

    @MsgType.setter
    def MsgType(self, MsgType):
        self._MsgType = MsgType

    @property
    def SendChannel(self):
        r"""Delivery channel.
        :rtype: int
        """
        return self._SendChannel

    @SendChannel.setter
    def SendChannel(self, SendChannel):
        self._SendChannel = SendChannel


    def _deserialize(self, params):
        self._MsgType = params.get("MsgType")
        self._SendChannel = params.get("SendChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        