# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AssociateTargetGroupsRequest(AbstractModel):
    r"""AssociateTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Associations: Binding relationship array. A single request supports up to 20 items.
        :type Associations: list of TargetGroupAssociation
        """
        self._Associations = None

    @property
    def Associations(self):
        r"""Binding relationship array. A single request supports up to 20 items.
        :rtype: list of TargetGroupAssociation
        """
        return self._Associations

    @Associations.setter
    def Associations(self, Associations):
        self._Associations = Associations


    def _deserialize(self, params):
        if params.get("Associations") is not None:
            self._Associations = []
            for item in params.get("Associations"):
                obj = TargetGroupAssociation()
                obj._deserialize(item)
                self._Associations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateTargetGroupsResponse(AbstractModel):
    r"""AssociateTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociationItem(AbstractModel):
    r"""Rule associated with target group

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Associated GWLB instance ID
        :type LoadBalancerId: str
        :param _LoadBalancerName: GWLB instance name
        :type LoadBalancerName: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None

    @property
    def LoadBalancerId(self):
        r"""Associated GWLB instance ID
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""GWLB instance name
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGatewayLoadBalancerRequest(AbstractModel):
    r"""CreateGatewayLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: ID of the VPC to which the backend target device of the GWLB belongs, such as vpc-12345678. It can be obtained through the DescribeVpcEx interface. If left blank, it defaults to DefaultVPC. This parameter is required when a private network CLB instance is created.
        :type VpcId: str
        :param _SubnetId: Subnet ID of the VPC to which the backend target device of the GWLB belongs.
        :type SubnetId: str
        :param _LoadBalancerName: GWLB instance name. It supports input of 1 to 60 characters. If not filled in, it will be generated automatically by default.
        :type LoadBalancerName: str
        :param _Number: Number of GWLBs to create, with a default of 1. The maximum batch creation quantity is 10.
        :type Number: int
        :param _Tags: While the GWLB is purchased, it is tagged, with a maximum of 20 tag key-value pairs.
        :type Tags: list of TagInfo
        :param _LBChargeType: GWLB instance billing type, which currently supports POSTPAID_BY_HOUR only. The default is POSTPAID_BY_HOUR.
        :type LBChargeType: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._LoadBalancerName = None
        self._Number = None
        self._Tags = None
        self._LBChargeType = None

    @property
    def VpcId(self):
        r"""ID of the VPC to which the backend target device of the GWLB belongs, such as vpc-12345678. It can be obtained through the DescribeVpcEx interface. If left blank, it defaults to DefaultVPC. This parameter is required when a private network CLB instance is created.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID of the VPC to which the backend target device of the GWLB belongs.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def LoadBalancerName(self):
        r"""GWLB instance name. It supports input of 1 to 60 characters. If not filled in, it will be generated automatically by default.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Number(self):
        r"""Number of GWLBs to create, with a default of 1. The maximum batch creation quantity is 10.
        :rtype: int
        """
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number

    @property
    def Tags(self):
        r"""While the GWLB is purchased, it is tagged, with a maximum of 20 tag key-value pairs.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def LBChargeType(self):
        r"""GWLB instance billing type, which currently supports POSTPAID_BY_HOUR only. The default is POSTPAID_BY_HOUR.
        :rtype: str
        """
        return self._LBChargeType

    @LBChargeType.setter
    def LBChargeType(self, LBChargeType):
        self._LBChargeType = LBChargeType


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._Number = params.get("Number")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._LBChargeType = params.get("LBChargeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGatewayLoadBalancerResponse(AbstractModel):
    r"""CreateGatewayLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained.
        :type LoadBalancerIds: list of str
        :param _DealName: Order number.

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DealName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadBalancerIds = None
        self._DealName = None
        self._RequestId = None

    @property
    def LoadBalancerIds(self):
        r"""Array of unique GWLB instance IDs.In certain scenarios, for example, when there is a delay in creation, this field may return null; at this time, you can query the created resource ID through the DescribeTaskStatus API using the RequestId or DealName parameter returned by the API.Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def DealName(self):
        r"""Order number.

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._DealName = params.get("DealName")
        self._RequestId = params.get("RequestId")


class CreateTargetGroupRequest(AbstractModel):
    r"""CreateTargetGroup request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupName: Target group name, limited to 60 characters.
        :type TargetGroupName: str
        :param _VpcId: VPCID attribute of target group. If this parameter is left blank, the default VPC will be used.
        :type VpcId: str
        :param _Port: Default port of the target group, which can be used when servers are added later. Either 'Port' or 'TargetGroupInstances.N.port' must be filled in.
        :type Port: int
        :param _TargetGroupInstances: Real server bound to a target group
        :type TargetGroupInstances: list of TargetGroupInstance
        :param _Protocol: GWLB target group protocol.
- TENCENT_GENEVE: GENEVE standard protocol

- AWS_GENEVE: GENEVE compatibility protocol (a ticket is required for allowlisting)
        :type Protocol: str
        :param _HealthCheck: Health check settings.
        :type HealthCheck: :class:`tencentcloud.gwlb.v20240906.models.TargetGroupHealthCheck`
        :param _ScheduleAlgorithm: Load balancing algorithm.
- IP_HASH_3_ELASTIC: elastic hashing
        :type ScheduleAlgorithm: str
        :param _AllDeadToAlive: Whether "All Dead, All Alive" is supported. It is supported by default.
        :type AllDeadToAlive: bool
        """
        self._TargetGroupName = None
        self._VpcId = None
        self._Port = None
        self._TargetGroupInstances = None
        self._Protocol = None
        self._HealthCheck = None
        self._ScheduleAlgorithm = None
        self._AllDeadToAlive = None

    @property
    def TargetGroupName(self):
        r"""Target group name, limited to 60 characters.
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def VpcId(self):
        r"""VPCID attribute of target group. If this parameter is left blank, the default VPC will be used.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Port(self):
        r"""Default port of the target group, which can be used when servers are added later. Either 'Port' or 'TargetGroupInstances.N.port' must be filled in.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def TargetGroupInstances(self):
        r"""Real server bound to a target group
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances

    @property
    def Protocol(self):
        r"""GWLB target group protocol.
- TENCENT_GENEVE: GENEVE standard protocol

- AWS_GENEVE: GENEVE compatibility protocol (a ticket is required for allowlisting)
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def HealthCheck(self):
        r"""Health check settings.
        :rtype: :class:`tencentcloud.gwlb.v20240906.models.TargetGroupHealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def ScheduleAlgorithm(self):
        r"""Load balancing algorithm.
- IP_HASH_3_ELASTIC: elastic hashing
        :rtype: str
        """
        return self._ScheduleAlgorithm

    @ScheduleAlgorithm.setter
    def ScheduleAlgorithm(self, ScheduleAlgorithm):
        self._ScheduleAlgorithm = ScheduleAlgorithm

    @property
    def AllDeadToAlive(self):
        r"""Whether "All Dead, All Alive" is supported. It is supported by default.
        :rtype: bool
        """
        return self._AllDeadToAlive

    @AllDeadToAlive.setter
    def AllDeadToAlive(self, AllDeadToAlive):
        self._AllDeadToAlive = AllDeadToAlive


    def _deserialize(self, params):
        self._TargetGroupName = params.get("TargetGroupName")
        self._VpcId = params.get("VpcId")
        self._Port = params.get("Port")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        self._Protocol = params.get("Protocol")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = TargetGroupHealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._ScheduleAlgorithm = params.get("ScheduleAlgorithm")
        self._AllDeadToAlive = params.get("AllDeadToAlive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTargetGroupResponse(AbstractModel):
    r"""CreateTargetGroup response structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: ID generated after target group creation
        :type TargetGroupId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TargetGroupId = None
        self._RequestId = None

    @property
    def TargetGroupId(self):
        r"""ID generated after target group creation
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._RequestId = params.get("RequestId")


class DeleteGatewayLoadBalancerRequest(AbstractModel):
    r"""DeleteGatewayLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: Array of GWLB instance IDs to be deleted, with the array size up to 20.
        :type LoadBalancerIds: list of str
        """
        self._LoadBalancerIds = None

    @property
    def LoadBalancerIds(self):
        r"""Array of GWLB instance IDs to be deleted, with the array size up to 20.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGatewayLoadBalancerResponse(AbstractModel):
    r"""DeleteGatewayLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTargetGroupsRequest(AbstractModel):
    r"""DeleteTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupIds: Target group ID list.
        :type TargetGroupIds: list of str
        """
        self._TargetGroupIds = None

    @property
    def TargetGroupIds(self):
        r"""Target group ID list.
        :rtype: list of str
        """
        return self._TargetGroupIds

    @TargetGroupIds.setter
    def TargetGroupIds(self, TargetGroupIds):
        self._TargetGroupIds = TargetGroupIds


    def _deserialize(self, params):
        self._TargetGroupIds = params.get("TargetGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTargetGroupsResponse(AbstractModel):
    r"""DeleteTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeregisterTargetGroupInstancesRequest(AbstractModel):
    r"""DeregisterTargetGroupInstances request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID.
        :type TargetGroupId: str
        :param _TargetGroupInstances: Information on server to be unbound.
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID.
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Information on server to be unbound.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeregisterTargetGroupInstancesResponse(AbstractModel):
    r"""DeregisterTargetGroupInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeGatewayLoadBalancersRequest(AbstractModel):
    r"""DescribeGatewayLoadBalancers request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerIds: GWLB instance ID. Batch filtering is supported with a maximum of 20 instance IDs.
        :type LoadBalancerIds: list of str
        :param _Limit: Number of GWLB instances returned in a batch, with a default value of 20 and a maximum value of 100.
        :type Limit: int
        :param _Offset: Starting offset for returning the list of GWLB instances, with a default value of 0.
        :type Offset: int
        :param _Filters: Filter criteria for querying the CLB details list. For each request, the maximum value of Filters is 10, and the maximum value of Filter.Values is 100.Filter.Name and Filter.Values are both required. Detailed filter criteria are as follows:- name - String - required: No - (filter criteria) filter by GWLB instance name, such as "gwlb-xxxx".- VpcId - String - required: No - (filter criteria) filter by the VPC to which the GWLB instance belongs, such as "vpc-bhqk****".
        :type Filters: list of Filter
        :param _SearchKey: Search field, for fuzzy matching of name and VIP.
        :type SearchKey: str
        """
        self._LoadBalancerIds = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._SearchKey = None

    @property
    def LoadBalancerIds(self):
        r"""GWLB instance ID. Batch filtering is supported with a maximum of 20 instance IDs.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def Limit(self):
        r"""Number of GWLB instances returned in a batch, with a default value of 20 and a maximum value of 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting offset for returning the list of GWLB instances, with a default value of 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter criteria for querying the CLB details list. For each request, the maximum value of Filters is 10, and the maximum value of Filter.Values is 100.Filter.Name and Filter.Values are both required. Detailed filter criteria are as follows:- name - String - required: No - (filter criteria) filter by GWLB instance name, such as "gwlb-xxxx".- VpcId - String - required: No - (filter criteria) filter by the VPC to which the GWLB instance belongs, such as "vpc-bhqk****".
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SearchKey(self):
        r"""Search field, for fuzzy matching of name and VIP.
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayLoadBalancersResponse(AbstractModel):
    r"""DescribeGatewayLoadBalancers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of CLB instances that meet the filter criteria. This value is independent of the Limit in the input parameters.
        :type TotalCount: int
        :param _LoadBalancerSet: Returned GWLB instance array.
        :type LoadBalancerSet: list of GatewayLoadBalancer
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoadBalancerSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of CLB instances that meet the filter criteria. This value is independent of the Limit in the input parameters.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoadBalancerSet(self):
        r"""Returned GWLB instance array.
        :rtype: list of GatewayLoadBalancer
        """
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = GatewayLoadBalancer()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupInstanceStatusRequest(AbstractModel):
    r"""DescribeTargetGroupInstanceStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Unique target group ID
        :type TargetGroupId: str
        :param _TargetGroupInstanceIps: List of backend service IPs bound to the target group
        :type TargetGroupInstanceIps: list of str
        """
        self._TargetGroupId = None
        self._TargetGroupInstanceIps = None

    @property
    def TargetGroupId(self):
        r"""Unique target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstanceIps(self):
        r"""List of backend service IPs bound to the target group
        :rtype: list of str
        """
        return self._TargetGroupInstanceIps

    @TargetGroupInstanceIps.setter
    def TargetGroupInstanceIps(self, TargetGroupInstanceIps):
        self._TargetGroupInstanceIps = TargetGroupInstanceIps


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._TargetGroupInstanceIps = params.get("TargetGroupInstanceIps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupInstanceStatusResponse(AbstractModel):
    r"""DescribeTargetGroupInstanceStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupInstanceSet: Health check backend RS status list
        :type TargetGroupInstanceSet: list of TargetGroupInstanceStatus
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TargetGroupInstanceSet = None
        self._RequestId = None

    @property
    def TargetGroupInstanceSet(self):
        r"""Health check backend RS status list
        :rtype: list of TargetGroupInstanceStatus
        """
        return self._TargetGroupInstanceSet

    @TargetGroupInstanceSet.setter
    def TargetGroupInstanceSet(self, TargetGroupInstanceSet):
        self._TargetGroupInstanceSet = TargetGroupInstanceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TargetGroupInstanceSet") is not None:
            self._TargetGroupInstanceSet = []
            for item in params.get("TargetGroupInstanceSet"):
                obj = TargetGroupInstanceStatus()
                obj._deserialize(item)
                self._TargetGroupInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupInstancesRequest(AbstractModel):
    r"""DescribeTargetGroupInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria. Currently, only filtering by TargetGroupId, BindIP, or InstanceId is supported.
        :type Filters: list of Filter
        :param _Limit: Number of displayed results. Default value: 20.
        :type Limit: int
        :param _Offset: Displayed offset. Default value: 0.
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        r"""Filter criteria. Currently, only filtering by TargetGroupId, BindIP, or InstanceId is supported.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""Number of displayed results. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Displayed offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupInstancesResponse(AbstractModel):
    r"""DescribeTargetGroupInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of results returned for the current query.
        :type TotalCount: int
        :param _TargetGroupInstanceSet: Information on bound server.
        :type TargetGroupInstanceSet: list of TargetGroupBackend
        :param _RealCount: Actual statistical quantity, which is not affected by Limit, Offset, or CAM.
        :type RealCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TargetGroupInstanceSet = None
        self._RealCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of results returned for the current query.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TargetGroupInstanceSet(self):
        r"""Information on bound server.
        :rtype: list of TargetGroupBackend
        """
        return self._TargetGroupInstanceSet

    @TargetGroupInstanceSet.setter
    def TargetGroupInstanceSet(self, TargetGroupInstanceSet):
        self._TargetGroupInstanceSet = TargetGroupInstanceSet

    @property
    def RealCount(self):
        r"""Actual statistical quantity, which is not affected by Limit, Offset, or CAM.
        :rtype: int
        """
        return self._RealCount

    @RealCount.setter
    def RealCount(self, RealCount):
        self._RealCount = RealCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TargetGroupInstanceSet") is not None:
            self._TargetGroupInstanceSet = []
            for item in params.get("TargetGroupInstanceSet"):
                obj = TargetGroupBackend()
                obj._deserialize(item)
                self._TargetGroupInstanceSet.append(obj)
        self._RealCount = params.get("RealCount")
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupListRequest(AbstractModel):
    r"""DescribeTargetGroupList request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupIds: Target group ID array.
        :type TargetGroupIds: list of str
        :param _Filters: Filter criterion array, which supports TargetGroupVpcId and TargetGroupName.
        :type Filters: list of Filter
        :param _Offset: Starting display offset.
        :type Offset: int
        :param _Limit: Limit on the number of displayed entries. Default value: 20.
        :type Limit: int
        """
        self._TargetGroupIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def TargetGroupIds(self):
        r"""Target group ID array.
        :rtype: list of str
        """
        return self._TargetGroupIds

    @TargetGroupIds.setter
    def TargetGroupIds(self, TargetGroupIds):
        self._TargetGroupIds = TargetGroupIds

    @property
    def Filters(self):
        r"""Filter criterion array, which supports TargetGroupVpcId and TargetGroupName.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Starting display offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit on the number of displayed entries. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TargetGroupIds = params.get("TargetGroupIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupListResponse(AbstractModel):
    r"""DescribeTargetGroupList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of displayed results.
        :type TotalCount: int
        :param _TargetGroupSet: Collection of displayed target group information.
        :type TargetGroupSet: list of TargetGroupInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TargetGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of displayed results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TargetGroupSet(self):
        r"""Collection of displayed target group information.
        :rtype: list of TargetGroupInfo
        """
        return self._TargetGroupSet

    @TargetGroupSet.setter
    def TargetGroupSet(self, TargetGroupSet):
        self._TargetGroupSet = TargetGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TargetGroupSet") is not None:
            self._TargetGroupSet = []
            for item in params.get("TargetGroupSet"):
                obj = TargetGroupInfo()
                obj._deserialize(item)
                self._TargetGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTargetGroupsRequest(AbstractModel):
    r"""DescribeTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupIds: Target group ID, which is mutually exclusive with Filters.
        :type TargetGroupIds: list of str
        :param _Limit: Limit on the number of displayed entries. Default value: 20.
        :type Limit: int
        :param _Offset: Starting display offset.
        :type Offset: int
        :param _Filters: Filter criterion array, which supports TargetGroupVpcId and TargetGroupName.
        :type Filters: list of Filter
        """
        self._TargetGroupIds = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def TargetGroupIds(self):
        r"""Target group ID, which is mutually exclusive with Filters.
        :rtype: list of str
        """
        return self._TargetGroupIds

    @TargetGroupIds.setter
    def TargetGroupIds(self, TargetGroupIds):
        self._TargetGroupIds = TargetGroupIds

    @property
    def Limit(self):
        r"""Limit on the number of displayed entries. Default value: 20.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Starting display offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter criterion array, which supports TargetGroupVpcId and TargetGroupName.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TargetGroupIds = params.get("TargetGroupIds")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTargetGroupsResponse(AbstractModel):
    r"""DescribeTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of displayed results.
        :type TotalCount: int
        :param _TargetGroupSet: Collection of displayed target group information.
        :type TargetGroupSet: list of TargetGroupInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TargetGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of displayed results.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TargetGroupSet(self):
        r"""Collection of displayed target group information.
        :rtype: list of TargetGroupInfo
        """
        return self._TargetGroupSet

    @TargetGroupSet.setter
    def TargetGroupSet(self, TargetGroupSet):
        self._TargetGroupSet = TargetGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TargetGroupSet") is not None:
            self._TargetGroupSet = []
            for item in params.get("TargetGroupSet"):
                obj = TargetGroupInfo()
                obj._deserialize(item)
                self._TargetGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskStatusRequest(AbstractModel):
    r"""DescribeTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Request ID, which is the RequestId parameter returned by the API.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Request ID, which is the RequestId parameter returned by the API.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskStatusResponse(AbstractModel):
    r"""DescribeTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Current status of task. Valid values: 0 (succeeded), 1 (failed), 2 (in progress).
        :type Status: int
        :param _LoadBalancerIds: Array of unique CLB instance IDs.

Note: This field may return null, indicating that no valid value can be obtained.
        :type LoadBalancerIds: list of str
        :param _Message: Auxiliary description information, such as failure causes.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Message: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._LoadBalancerIds = None
        self._Message = None
        self._RequestId = None

    @property
    def Status(self):
        r"""Current status of task. Valid values: 0 (succeeded), 1 (failed), 2 (in progress).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LoadBalancerIds(self):
        r"""Array of unique CLB instance IDs.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of str
        """
        return self._LoadBalancerIds

    @LoadBalancerIds.setter
    def LoadBalancerIds(self, LoadBalancerIds):
        self._LoadBalancerIds = LoadBalancerIds

    @property
    def Message(self):
        r"""Auxiliary description information, such as failure causes.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._LoadBalancerIds = params.get("LoadBalancerIds")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class DisassociateTargetGroupsRequest(AbstractModel):
    r"""DisassociateTargetGroups request structure.

    """

    def __init__(self):
        r"""
        :param _Associations: List of target groups to unbind.
        :type Associations: list of TargetGroupAssociation
        """
        self._Associations = None

    @property
    def Associations(self):
        r"""List of target groups to unbind.
        :rtype: list of TargetGroupAssociation
        """
        return self._Associations

    @Associations.setter
    def Associations(self, Associations):
        self._Associations = Associations


    def _deserialize(self, params):
        if params.get("Associations") is not None:
            self._Associations = []
            for item in params.get("Associations"):
                obj = TargetGroupAssociation()
                obj._deserialize(item)
                self._Associations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisassociateTargetGroupsResponse(AbstractModel):
    r"""DisassociateTargetGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Filter(AbstractModel):
    r"""Filter criteria

    """

    def __init__(self):
        r"""
        :param _Name: Filter name
        :type Name: str
        :param _Values: Filter value array
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Filter name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Filter value array
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GatewayLoadBalancer(AbstractModel):
    r"""Information on the GWLB instance

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: GWLB instance ID.
        :type LoadBalancerId: str
        :param _LoadBalancerName: Name of the GWLB instance.
        :type LoadBalancerName: str
        :param _VpcId: VPC to which the GWLB belongs.Note: this field may return `null`, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _SubnetId: Subnet to which the GWLB belongs.
        :type SubnetId: str
        :param _Vips: Virtual IP of GWLB for providing service.
        :type Vips: list of str
        :param _Status: GWLB instance status.0: creating, 1: normal operation, 3: deleting.
        :type Status: int
        :param _TargetGroupId: Unique ID of associated target group.Note: this field may return `null`, indicating that no valid values can be obtained.
        :type TargetGroupId: str
        :param _DeleteProtect: Whether to enable the deletion protection feature.Note: this field may return `null`, indicating that no valid values can be obtained.
        :type DeleteProtect: bool
        :param _Tags: Tag information on the CLB instance.Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Tags: list of TagInfo
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _ChargeType: Billing type of the GWLB instance. POSTPAID_BY_HOUR: pay-as-you-goNote: this field may return `null`, indicating that no valid values can be obtained.
        :type ChargeType: str
        :param _Isolation: 0: Not isolated; 1: Isolated.

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type Isolation: int
        :param _IsolatedTime: CLB instance isolation time

Note: this field may return `null`, indicating that no valid values can be obtained.
        :type IsolatedTime: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._VpcId = None
        self._SubnetId = None
        self._Vips = None
        self._Status = None
        self._TargetGroupId = None
        self._DeleteProtect = None
        self._Tags = None
        self._CreateTime = None
        self._ChargeType = None
        self._Isolation = None
        self._IsolatedTime = None

    @property
    def LoadBalancerId(self):
        r"""GWLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""Name of the GWLB instance.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def VpcId(self):
        r"""VPC to which the GWLB belongs.Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet to which the GWLB belongs.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Vips(self):
        r"""Virtual IP of GWLB for providing service.
        :rtype: list of str
        """
        return self._Vips

    @Vips.setter
    def Vips(self, Vips):
        self._Vips = Vips

    @property
    def Status(self):
        r"""GWLB instance status.0: creating, 1: normal operation, 3: deleting.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TargetGroupId(self):
        r"""Unique ID of associated target group.Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def DeleteProtect(self):
        r"""Whether to enable the deletion protection feature.Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._DeleteProtect

    @DeleteProtect.setter
    def DeleteProtect(self, DeleteProtect):
        self._DeleteProtect = DeleteProtect

    @property
    def Tags(self):
        r"""Tag information on the CLB instance.Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ChargeType(self):
        r"""Billing type of the GWLB instance. POSTPAID_BY_HOUR: pay-as-you-goNote: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def Isolation(self):
        r"""0: Not isolated; 1: Isolated.

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Isolation

    @Isolation.setter
    def Isolation(self, Isolation):
        self._Isolation = Isolation

    @property
    def IsolatedTime(self):
        r"""CLB instance isolation time

Note: this field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IsolatedTime

    @IsolatedTime.setter
    def IsolatedTime(self, IsolatedTime):
        self._IsolatedTime = IsolatedTime


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Vips = params.get("Vips")
        self._Status = params.get("Status")
        self._TargetGroupId = params.get("TargetGroupId")
        self._DeleteProtect = params.get("DeleteProtect")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CreateTime = params.get("CreateTime")
        self._ChargeType = params.get("ChargeType")
        self._Isolation = params.get("Isolation")
        self._IsolatedTime = params.get("IsolatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceCreateGatewayLoadBalancerRequest(AbstractModel):
    r"""InquirePriceCreateGatewayLoadBalancer request structure.

    """

    def __init__(self):
        r"""
        :param _GoodsNum: Number of GWLB instances for inquiry, with a default of 1
        :type GoodsNum: int
        """
        self._GoodsNum = None

    @property
    def GoodsNum(self):
        r"""Number of GWLB instances for inquiry, with a default of 1
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum


    def _deserialize(self, params):
        self._GoodsNum = params.get("GoodsNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceCreateGatewayLoadBalancerResponse(AbstractModel):
    r"""InquirePriceCreateGatewayLoadBalancer response structure.

    """

    def __init__(self):
        r"""
        :param _Price: This parameter represents the corresponding price.
        :type Price: :class:`tencentcloud.gwlb.v20240906.models.Price`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Price = None
        self._RequestId = None

    @property
    def Price(self):
        r"""This parameter represents the corresponding price.
        :rtype: :class:`tencentcloud.gwlb.v20240906.models.Price`
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Price") is not None:
            self._Price = Price()
            self._Price._deserialize(params.get("Price"))
        self._RequestId = params.get("RequestId")


class ItemPrice(AbstractModel):
    r"""It describes the price information of a single item.

    """

    def __init__(self):
        r"""
        :param _UnitPrice: Postpaid unit price. Unit: CNY.

Note: This field may return null, indicating that no valid value can be obtained.
        :type UnitPrice: float
        :param _ChargeUnit: Pay-as-you-go billing unit. Valid values: HOUR: indicates that the billing unit is calculated by hour. Current scenarios involving this billing unit include: postpaid by hour for instances (POSTPAID_BY_HOUR).Note: This field may return null, indicating that no valid value can be obtained.
        :type ChargeUnit: str
        :param _OriginalPrice: Original price of pre-payment (in CNY).

Note: This field may return null, indicating that no valid value can be obtained.
        :type OriginalPrice: float
        :param _DiscountPrice: Discount price of prepaid costs, unit: CNY.

Note: This field may return null, indicating that no valid value can be obtained.
        :type DiscountPrice: float
        :param _UnitPriceDiscount: Discounted unit price for pay-as-you-go. Unit: CNY.Note: This field may return null, indicating that no valid value can be obtained.
        :type UnitPriceDiscount: float
        :param _Discount: Discount, such as 20.0 representing 80% off.

Note: This field may return null, indicating that no valid value can be obtained.
        :type Discount: float
        """
        self._UnitPrice = None
        self._ChargeUnit = None
        self._OriginalPrice = None
        self._DiscountPrice = None
        self._UnitPriceDiscount = None
        self._Discount = None

    @property
    def UnitPrice(self):
        r"""Postpaid unit price. Unit: CNY.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: float
        """
        return self._UnitPrice

    @UnitPrice.setter
    def UnitPrice(self, UnitPrice):
        self._UnitPrice = UnitPrice

    @property
    def ChargeUnit(self):
        r"""Pay-as-you-go billing unit. Valid values: HOUR: indicates that the billing unit is calculated by hour. Current scenarios involving this billing unit include: postpaid by hour for instances (POSTPAID_BY_HOUR).Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._ChargeUnit

    @ChargeUnit.setter
    def ChargeUnit(self, ChargeUnit):
        self._ChargeUnit = ChargeUnit

    @property
    def OriginalPrice(self):
        r"""Original price of pre-payment (in CNY).

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: float
        """
        return self._OriginalPrice

    @OriginalPrice.setter
    def OriginalPrice(self, OriginalPrice):
        self._OriginalPrice = OriginalPrice

    @property
    def DiscountPrice(self):
        r"""Discount price of prepaid costs, unit: CNY.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: float
        """
        return self._DiscountPrice

    @DiscountPrice.setter
    def DiscountPrice(self, DiscountPrice):
        self._DiscountPrice = DiscountPrice

    @property
    def UnitPriceDiscount(self):
        r"""Discounted unit price for pay-as-you-go. Unit: CNY.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: float
        """
        return self._UnitPriceDiscount

    @UnitPriceDiscount.setter
    def UnitPriceDiscount(self, UnitPriceDiscount):
        self._UnitPriceDiscount = UnitPriceDiscount

    @property
    def Discount(self):
        r"""Discount, such as 20.0 representing 80% off.

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: float
        """
        return self._Discount

    @Discount.setter
    def Discount(self, Discount):
        self._Discount = Discount


    def _deserialize(self, params):
        self._UnitPrice = params.get("UnitPrice")
        self._ChargeUnit = params.get("ChargeUnit")
        self._OriginalPrice = params.get("OriginalPrice")
        self._DiscountPrice = params.get("DiscountPrice")
        self._UnitPriceDiscount = params.get("UnitPriceDiscount")
        self._Discount = params.get("Discount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGatewayLoadBalancerAttributeRequest(AbstractModel):
    r"""ModifyGatewayLoadBalancerAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: Unique GWLB ID.
        :type LoadBalancerId: str
        :param _LoadBalancerName: GWLB instance name. It supports input of 1 to 60 characters.
        :type LoadBalancerName: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None

    @property
    def LoadBalancerId(self):
        r"""Unique GWLB ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        r"""GWLB instance name. It supports input of 1 to 60 characters.
        :rtype: str
        """
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGatewayLoadBalancerAttributeResponse(AbstractModel):
    r"""ModifyGatewayLoadBalancerAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetGroupAttributeRequest(AbstractModel):
    r"""ModifyTargetGroupAttribute request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID.
        :type TargetGroupId: str
        :param _TargetGroupName: New name of target group.
        :type TargetGroupName: str
        :param _HealthCheck: Health check details.
        :type HealthCheck: :class:`tencentcloud.gwlb.v20240906.models.TargetGroupHealthCheck`
        :param _AllDeadToAlive: Whether "All Dead, All Alive" is supported.
        :type AllDeadToAlive: bool
        """
        self._TargetGroupId = None
        self._TargetGroupName = None
        self._HealthCheck = None
        self._AllDeadToAlive = None

    @property
    def TargetGroupId(self):
        r"""Target group ID.
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupName(self):
        r"""New name of target group.
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def HealthCheck(self):
        r"""Health check details.
        :rtype: :class:`tencentcloud.gwlb.v20240906.models.TargetGroupHealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def AllDeadToAlive(self):
        r"""Whether "All Dead, All Alive" is supported.
        :rtype: bool
        """
        return self._AllDeadToAlive

    @AllDeadToAlive.setter
    def AllDeadToAlive(self, AllDeadToAlive):
        self._AllDeadToAlive = AllDeadToAlive


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._TargetGroupName = params.get("TargetGroupName")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = TargetGroupHealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._AllDeadToAlive = params.get("AllDeadToAlive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetGroupAttributeResponse(AbstractModel):
    r"""ModifyTargetGroupAttribute response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTargetGroupInstancesWeightRequest(AbstractModel):
    r"""ModifyTargetGroupInstancesWeight request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID.
        :type TargetGroupId: str
        :param _TargetGroupInstances: Instance binding configuration array.
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID.
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Instance binding configuration array.
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTargetGroupInstancesWeightResponse(AbstractModel):
    r"""ModifyTargetGroupInstancesWeight response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Price(AbstractModel):
    r"""It indicates the price of the GWLB.

    """

    def __init__(self):
        r"""
        :param _InstancePrice: It describes the instance price.Note: This field may return null, indicating that no valid value can be obtained.
        :type InstancePrice: :class:`tencentcloud.gwlb.v20240906.models.ItemPrice`
        :param _LcuPrice: It describes the price of GLCU.
Note: This field may return null, indicating that no valid value can be obtained.
        :type LcuPrice: :class:`tencentcloud.gwlb.v20240906.models.ItemPrice`
        """
        self._InstancePrice = None
        self._LcuPrice = None

    @property
    def InstancePrice(self):
        r"""It describes the instance price.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.gwlb.v20240906.models.ItemPrice`
        """
        return self._InstancePrice

    @InstancePrice.setter
    def InstancePrice(self, InstancePrice):
        self._InstancePrice = InstancePrice

    @property
    def LcuPrice(self):
        r"""It describes the price of GLCU.
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.gwlb.v20240906.models.ItemPrice`
        """
        return self._LcuPrice

    @LcuPrice.setter
    def LcuPrice(self, LcuPrice):
        self._LcuPrice = LcuPrice


    def _deserialize(self, params):
        if params.get("InstancePrice") is not None:
            self._InstancePrice = ItemPrice()
            self._InstancePrice._deserialize(params.get("InstancePrice"))
        if params.get("LcuPrice") is not None:
            self._LcuPrice = ItemPrice()
            self._LcuPrice._deserialize(params.get("LcuPrice"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterTargetGroupInstancesRequest(AbstractModel):
    r"""RegisterTargetGroupInstances request structure.

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _TargetGroupInstances: Server instance array
        :type TargetGroupInstances: list of TargetGroupInstance
        """
        self._TargetGroupId = None
        self._TargetGroupInstances = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def TargetGroupInstances(self):
        r"""Server instance array
        :rtype: list of TargetGroupInstance
        """
        return self._TargetGroupInstances

    @TargetGroupInstances.setter
    def TargetGroupInstances(self, TargetGroupInstances):
        self._TargetGroupInstances = TargetGroupInstances


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        if params.get("TargetGroupInstances") is not None:
            self._TargetGroupInstances = []
            for item in params.get("TargetGroupInstances"):
                obj = TargetGroupInstance()
                obj._deserialize(item)
                self._TargetGroupInstances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegisterTargetGroupInstancesResponse(AbstractModel):
    r"""RegisterTargetGroupInstances response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class TagInfo(AbstractModel):
    r"""Tag information on GWLB

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag key
        :type TagKey: str
        :param _TagValue: Tag value
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        r"""Tag key
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        r"""Tag value
        :rtype: str
        """
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupAssociation(AbstractModel):
    r"""Association relationship between rules and target groups.

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: GWLB instance ID.
        :type LoadBalancerId: str
        :param _TargetGroupId: Target group ID.
        :type TargetGroupId: str
        """
        self._LoadBalancerId = None
        self._TargetGroupId = None

    @property
    def LoadBalancerId(self):
        r"""GWLB instance ID.
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def TargetGroupId(self):
        r"""Target group ID.
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._TargetGroupId = params.get("TargetGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupBackend(AbstractModel):
    r"""Real server bound to a target group

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _Type: Backend service type. Valid values: CVM, ENI (to be supported soon)
        :type Type: str
        :param _InstanceId: Unique backend service ID
        :type InstanceId: str
        :param _Port: Listening port of backend service
        :type Port: int
        :param _Weight: Forwarding weight of backend service. Value range: [0, 100]. Default value: 10.
        :type Weight: int
        :param _PublicIpAddresses: Public network IP of the real server

Note: This field may return null, indicating that no valid value can be obtained.
        :type PublicIpAddresses: list of str
        :param _PrivateIpAddresses: Private network IP of backend serviceNote: This field may return null, indicating that no valid value can be obtained.
        :type PrivateIpAddresses: list of str
        :param _InstanceName: Instance name of the real server

Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceName: str
        :param _RegisteredTime: Real server binding time

Note: This field may return null, indicating that no valid value can be obtained.
        :type RegisteredTime: str
        :param _EniId: Unique ID of the ENI

Note: This field may return null, indicating that no valid value can be obtained.
        :type EniId: str
        :param _ZoneId: Available zone ID of backend serviceNote: This field may return null, indicating that no valid value can be obtained.
        :type ZoneId: int
        """
        self._TargetGroupId = None
        self._Type = None
        self._InstanceId = None
        self._Port = None
        self._Weight = None
        self._PublicIpAddresses = None
        self._PrivateIpAddresses = None
        self._InstanceName = None
        self._RegisteredTime = None
        self._EniId = None
        self._ZoneId = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def Type(self):
        r"""Backend service type. Valid values: CVM, ENI (to be supported soon)
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceId(self):
        r"""Unique backend service ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Port(self):
        r"""Listening port of backend service
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Weight(self):
        r"""Forwarding weight of backend service. Value range: [0, 100]. Default value: 10.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def PublicIpAddresses(self):
        r"""Public network IP of the real server

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def PrivateIpAddresses(self):
        r"""Private network IP of backend serviceNote: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceName(self):
        r"""Instance name of the real server

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def RegisteredTime(self):
        r"""Real server binding time

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._RegisteredTime

    @RegisteredTime.setter
    def RegisteredTime(self, RegisteredTime):
        self._RegisteredTime = RegisteredTime

    @property
    def EniId(self):
        r"""Unique ID of the ENI

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._EniId

    @EniId.setter
    def EniId(self, EniId):
        self._EniId = EniId

    @property
    def ZoneId(self):
        r"""Available zone ID of backend serviceNote: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._Type = params.get("Type")
        self._InstanceId = params.get("InstanceId")
        self._Port = params.get("Port")
        self._Weight = params.get("Weight")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceName = params.get("InstanceName")
        self._RegisteredTime = params.get("RegisteredTime")
        self._EniId = params.get("EniId")
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupHealthCheck(AbstractModel):
    r"""Details of target group health check

    """

    def __init__(self):
        r"""
        :param _HealthSwitch: Whether to enable the health check.
        :type HealthSwitch: bool
        :param _Protocol: Protocol used for health check, which supports PING and TCP and is PING by default.

- PING: icmp
- TCP: tcp
        :type Protocol: str
        :param _Port: Health check port, which is required when the probe protocol is TCP.
        :type Port: int
        :param _Timeout: Health check timeout. The default is 2 seconds. Value range: 2-30 seconds.
        :type Timeout: int
        :param _IntervalTime: Detection interval time. The default is 5 seconds. Value range: 2-300 seconds.
        :type IntervalTime: int
        :param _HealthNum: Health detection threshold. The default is 3 times. Value range: 2-10 times.
        :type HealthNum: int
        :param _UnHealthNum: Unhealth detection threshold. The default is 3 times. Value range: 2-10 times.
        :type UnHealthNum: int
        """
        self._HealthSwitch = None
        self._Protocol = None
        self._Port = None
        self._Timeout = None
        self._IntervalTime = None
        self._HealthNum = None
        self._UnHealthNum = None

    @property
    def HealthSwitch(self):
        r"""Whether to enable the health check.
        :rtype: bool
        """
        return self._HealthSwitch

    @HealthSwitch.setter
    def HealthSwitch(self, HealthSwitch):
        self._HealthSwitch = HealthSwitch

    @property
    def Protocol(self):
        r"""Protocol used for health check, which supports PING and TCP and is PING by default.

- PING: icmp
- TCP: tcp
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        r"""Health check port, which is required when the probe protocol is TCP.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Timeout(self):
        r"""Health check timeout. The default is 2 seconds. Value range: 2-30 seconds.
        :rtype: int
        """
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def IntervalTime(self):
        r"""Detection interval time. The default is 5 seconds. Value range: 2-300 seconds.
        :rtype: int
        """
        return self._IntervalTime

    @IntervalTime.setter
    def IntervalTime(self, IntervalTime):
        self._IntervalTime = IntervalTime

    @property
    def HealthNum(self):
        r"""Health detection threshold. The default is 3 times. Value range: 2-10 times.
        :rtype: int
        """
        return self._HealthNum

    @HealthNum.setter
    def HealthNum(self, HealthNum):
        self._HealthNum = HealthNum

    @property
    def UnHealthNum(self):
        r"""Unhealth detection threshold. The default is 3 times. Value range: 2-10 times.
        :rtype: int
        """
        return self._UnHealthNum

    @UnHealthNum.setter
    def UnHealthNum(self, UnHealthNum):
        self._UnHealthNum = UnHealthNum


    def _deserialize(self, params):
        self._HealthSwitch = params.get("HealthSwitch")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._Timeout = params.get("Timeout")
        self._IntervalTime = params.get("IntervalTime")
        self._HealthNum = params.get("HealthNum")
        self._UnHealthNum = params.get("UnHealthNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupInfo(AbstractModel):
    r"""Target group information

    """

    def __init__(self):
        r"""
        :param _TargetGroupId: Target group ID
        :type TargetGroupId: str
        :param _VpcId: VPCID of target group
        :type VpcId: str
        :param _TargetGroupName: Target group name
        :type TargetGroupName: str
        :param _Port: Default port of a target group

Note: This field may return null, indicating that no valid value can be obtained.
        :type Port: int
        :param _CreatedTime: Target group creation time
        :type CreatedTime: str
        :param _UpdatedTime: Target group modification time
        :type UpdatedTime: str
        :param _AssociatedRule: Associated rule array. This parameter cannot be obtained when the DescribeTargetGroupList API is called.Note: This field may return null, indicating that no valid value can be obtained.
        :type AssociatedRule: list of AssociationItem
        :param _Protocol: Backend protocol type.Note: This field may return null, indicating that no valid value can be obtained.
        :type Protocol: str
        :param _ScheduleAlgorithm: Scheduling algorithm.
ip_hash_3: elastic hashing
Note: This field may return null, indicating that no valid value can be obtained.
        :type ScheduleAlgorithm: str
        :param _HealthCheck: Health check details.Note: This field may return null, indicating that no valid value can be obtained.
        :type HealthCheck: :class:`tencentcloud.gwlb.v20240906.models.TargetGroupHealthCheck`
        :param _AllDeadToAlive: Whether "All Dead, All Alive" is supported.Note: This field may return null, indicating that no valid value can be obtained.
        :type AllDeadToAlive: bool
        :param _AssociatedRuleCount: Number of rules associated with the target group.Note: This field may return null, indicating that no valid value can be obtained.
        :type AssociatedRuleCount: int
        :param _RegisteredInstancesCount: Number of instances in the target group.Note: This field may return null, indicating that no valid value can be obtained.
        :type RegisteredInstancesCount: int
        """
        self._TargetGroupId = None
        self._VpcId = None
        self._TargetGroupName = None
        self._Port = None
        self._CreatedTime = None
        self._UpdatedTime = None
        self._AssociatedRule = None
        self._Protocol = None
        self._ScheduleAlgorithm = None
        self._HealthCheck = None
        self._AllDeadToAlive = None
        self._AssociatedRuleCount = None
        self._RegisteredInstancesCount = None

    @property
    def TargetGroupId(self):
        r"""Target group ID
        :rtype: str
        """
        return self._TargetGroupId

    @TargetGroupId.setter
    def TargetGroupId(self, TargetGroupId):
        self._TargetGroupId = TargetGroupId

    @property
    def VpcId(self):
        r"""VPCID of target group
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def TargetGroupName(self):
        r"""Target group name
        :rtype: str
        """
        return self._TargetGroupName

    @TargetGroupName.setter
    def TargetGroupName(self, TargetGroupName):
        self._TargetGroupName = TargetGroupName

    @property
    def Port(self):
        r"""Default port of a target group

Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def CreatedTime(self):
        r"""Target group creation time
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def UpdatedTime(self):
        r"""Target group modification time
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def AssociatedRule(self):
        r"""Associated rule array. This parameter cannot be obtained when the DescribeTargetGroupList API is called.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of AssociationItem
        """
        return self._AssociatedRule

    @AssociatedRule.setter
    def AssociatedRule(self, AssociatedRule):
        self._AssociatedRule = AssociatedRule

    @property
    def Protocol(self):
        r"""Backend protocol type.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def ScheduleAlgorithm(self):
        r"""Scheduling algorithm.
ip_hash_3: elastic hashing
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._ScheduleAlgorithm

    @ScheduleAlgorithm.setter
    def ScheduleAlgorithm(self, ScheduleAlgorithm):
        self._ScheduleAlgorithm = ScheduleAlgorithm

    @property
    def HealthCheck(self):
        r"""Health check details.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.gwlb.v20240906.models.TargetGroupHealthCheck`
        """
        return self._HealthCheck

    @HealthCheck.setter
    def HealthCheck(self, HealthCheck):
        self._HealthCheck = HealthCheck

    @property
    def AllDeadToAlive(self):
        r"""Whether "All Dead, All Alive" is supported.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: bool
        """
        return self._AllDeadToAlive

    @AllDeadToAlive.setter
    def AllDeadToAlive(self, AllDeadToAlive):
        self._AllDeadToAlive = AllDeadToAlive

    @property
    def AssociatedRuleCount(self):
        r"""Number of rules associated with the target group.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._AssociatedRuleCount

    @AssociatedRuleCount.setter
    def AssociatedRuleCount(self, AssociatedRuleCount):
        self._AssociatedRuleCount = AssociatedRuleCount

    @property
    def RegisteredInstancesCount(self):
        r"""Number of instances in the target group.Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: int
        """
        return self._RegisteredInstancesCount

    @RegisteredInstancesCount.setter
    def RegisteredInstancesCount(self, RegisteredInstancesCount):
        self._RegisteredInstancesCount = RegisteredInstancesCount


    def _deserialize(self, params):
        self._TargetGroupId = params.get("TargetGroupId")
        self._VpcId = params.get("VpcId")
        self._TargetGroupName = params.get("TargetGroupName")
        self._Port = params.get("Port")
        self._CreatedTime = params.get("CreatedTime")
        self._UpdatedTime = params.get("UpdatedTime")
        if params.get("AssociatedRule") is not None:
            self._AssociatedRule = []
            for item in params.get("AssociatedRule"):
                obj = AssociationItem()
                obj._deserialize(item)
                self._AssociatedRule.append(obj)
        self._Protocol = params.get("Protocol")
        self._ScheduleAlgorithm = params.get("ScheduleAlgorithm")
        if params.get("HealthCheck") is not None:
            self._HealthCheck = TargetGroupHealthCheck()
            self._HealthCheck._deserialize(params.get("HealthCheck"))
        self._AllDeadToAlive = params.get("AllDeadToAlive")
        self._AssociatedRuleCount = params.get("AssociatedRuleCount")
        self._RegisteredInstancesCount = params.get("RegisteredInstancesCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupInstance(AbstractModel):
    r"""Target group instance

    """

    def __init__(self):
        r"""
        :param _BindIP: Private network IP of target group instance.
        :type BindIP: str
        :param _Port: Port of target group instance. Only 6081 is supported.
        :type Port: int
        :param _Weight: Weight of target group instance. Only 0 or 16 is supported, and non-0 is uniformly treated as 16.
        :type Weight: int
        """
        self._BindIP = None
        self._Port = None
        self._Weight = None

    @property
    def BindIP(self):
        r"""Private network IP of target group instance.
        :rtype: str
        """
        return self._BindIP

    @BindIP.setter
    def BindIP(self, BindIP):
        self._BindIP = BindIP

    @property
    def Port(self):
        r"""Port of target group instance. Only 6081 is supported.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Weight(self):
        r"""Weight of target group instance. Only 0 or 16 is supported, and non-0 is uniformly treated as 16.
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._BindIP = params.get("BindIP")
        self._Port = params.get("Port")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetGroupInstanceStatus(AbstractModel):
    r"""It is used for the health check status of the target group backend RS.

    """

    def __init__(self):
        r"""
        :param _InstanceIp: IP of backend RS
        :type InstanceIp: str
        :param _Status: Health check status, with parameter values and meanings as follows:● on: indicates being under detection.● off: indicates that the health check is disabled.● health: indicates being healthy.● unhealth: indicates being abnormal.
        :type Status: str
        """
        self._InstanceIp = None
        self._Status = None

    @property
    def InstanceIp(self):
        r"""IP of backend RS
        :rtype: str
        """
        return self._InstanceIp

    @InstanceIp.setter
    def InstanceIp(self, InstanceIp):
        self._InstanceIp = InstanceIp

    @property
    def Status(self):
        r"""Health check status, with parameter values and meanings as follows:● on: indicates being under detection.● off: indicates that the health check is disabled.● health: indicates being healthy.● unhealth: indicates being abnormal.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._InstanceIp = params.get("InstanceIp")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        