# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddMetricScaleStrategyRequest(AbstractModel):
    r"""AddMetricScaleStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _StrategyType: 1 indicates scaling by load rules. 2 indicates scaling by time rules. This parameter is required and should match the following rule policy.
        :type StrategyType: int
        :param _LoadAutoScaleStrategy: Load-based scale-out rules.
        :type LoadAutoScaleStrategy: :class:`tencentcloud.emr.v20190103.models.LoadAutoScaleStrategy`
        :param _TimeAutoScaleStrategy: Rule for time-based scaling
        :type TimeAutoScaleStrategy: :class:`tencentcloud.emr.v20190103.models.TimeAutoScaleStrategy`
        """
        self._InstanceId = None
        self._StrategyType = None
        self._LoadAutoScaleStrategy = None
        self._TimeAutoScaleStrategy = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StrategyType(self):
        r"""1 indicates scaling by load rules. 2 indicates scaling by time rules. This parameter is required and should match the following rule policy.
        :rtype: int
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def LoadAutoScaleStrategy(self):
        r"""Load-based scale-out rules.
        :rtype: :class:`tencentcloud.emr.v20190103.models.LoadAutoScaleStrategy`
        """
        return self._LoadAutoScaleStrategy

    @LoadAutoScaleStrategy.setter
    def LoadAutoScaleStrategy(self, LoadAutoScaleStrategy):
        self._LoadAutoScaleStrategy = LoadAutoScaleStrategy

    @property
    def TimeAutoScaleStrategy(self):
        r"""Rule for time-based scaling
        :rtype: :class:`tencentcloud.emr.v20190103.models.TimeAutoScaleStrategy`
        """
        return self._TimeAutoScaleStrategy

    @TimeAutoScaleStrategy.setter
    def TimeAutoScaleStrategy(self, TimeAutoScaleStrategy):
        self._TimeAutoScaleStrategy = TimeAutoScaleStrategy


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StrategyType = params.get("StrategyType")
        if params.get("LoadAutoScaleStrategy") is not None:
            self._LoadAutoScaleStrategy = LoadAutoScaleStrategy()
            self._LoadAutoScaleStrategy._deserialize(params.get("LoadAutoScaleStrategy"))
        if params.get("TimeAutoScaleStrategy") is not None:
            self._TimeAutoScaleStrategy = TimeAutoScaleStrategy()
            self._TimeAutoScaleStrategy._deserialize(params.get("TimeAutoScaleStrategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddMetricScaleStrategyResponse(AbstractModel):
    r"""AddMetricScaleStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddNodeResourceConfigRequest(AbstractModel):
    r"""AddNodeResourceConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ResourceType: Node type: Core, Task, and Router.
        :type ResourceType: str
        :param _ResourceConfig: Resource details.
        :type ResourceConfig: :class:`tencentcloud.emr.v20190103.models.Resource`
        :param _PayMode: Payment mode.
        :type PayMode: int
        :param _IsDefault: Whether default configuration applies, DEFAULT or BACKUP. If it is not specified, the default configuration does not apply.
        :type IsDefault: str
        :param _ZoneId: Region ID.
        :type ZoneId: int
        :param _MultipleResourceConfig: When multiple specifications are added, details of the first specifications are in the ResourceConfig parameter, and those of the second to n-th are in the MultipleResourceConfig parameter.
        :type MultipleResourceConfig: list of Resource
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        :param _HardwareResourceType: Hardware type.
        :type HardwareResourceType: str
        """
        self._InstanceId = None
        self._ResourceType = None
        self._ResourceConfig = None
        self._PayMode = None
        self._IsDefault = None
        self._ZoneId = None
        self._MultipleResourceConfig = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None
        self._HardwareResourceType = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceType(self):
        r"""Node type: Core, Task, and Router.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceConfig(self):
        r"""Resource details.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Resource`
        """
        return self._ResourceConfig

    @ResourceConfig.setter
    def ResourceConfig(self, ResourceConfig):
        self._ResourceConfig = ResourceConfig

    @property
    def PayMode(self):
        r"""Payment mode.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def IsDefault(self):
        r"""Whether default configuration applies, DEFAULT or BACKUP. If it is not specified, the default configuration does not apply.
        :rtype: str
        """
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault

    @property
    def ZoneId(self):
        r"""Region ID.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def MultipleResourceConfig(self):
        r"""When multiple specifications are added, details of the first specifications are in the ResourceConfig parameter, and those of the second to n-th are in the MultipleResourceConfig parameter.
        :rtype: list of Resource
        """
        return self._MultipleResourceConfig

    @MultipleResourceConfig.setter
    def MultipleResourceConfig(self, MultipleResourceConfig):
        self._MultipleResourceConfig = MultipleResourceConfig

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId

    @property
    def HardwareResourceType(self):
        r"""Hardware type.
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ResourceType = params.get("ResourceType")
        if params.get("ResourceConfig") is not None:
            self._ResourceConfig = Resource()
            self._ResourceConfig._deserialize(params.get("ResourceConfig"))
        self._PayMode = params.get("PayMode")
        self._IsDefault = params.get("IsDefault")
        self._ZoneId = params.get("ZoneId")
        if params.get("MultipleResourceConfig") is not None:
            self._MultipleResourceConfig = []
            for item in params.get("MultipleResourceConfig"):
                obj = Resource()
                obj._deserialize(item)
                self._MultipleResourceConfig.append(obj)
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        self._HardwareResourceType = params.get("HardwareResourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNodeResourceConfigResponse(AbstractModel):
    r"""AddNodeResourceConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddUsersForUserManagerRequest(AbstractModel):
    r"""AddUsersForUserManager request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster string ID
        :type InstanceId: str
        :param _UserManagerUserList: User information list
        :type UserManagerUserList: list of UserInfoForUserManager
        """
        self._InstanceId = None
        self._UserManagerUserList = None

    @property
    def InstanceId(self):
        r"""Cluster string ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def UserManagerUserList(self):
        r"""User information list
        :rtype: list of UserInfoForUserManager
        """
        return self._UserManagerUserList

    @UserManagerUserList.setter
    def UserManagerUserList(self, UserManagerUserList):
        self._UserManagerUserList = UserManagerUserList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("UserManagerUserList") is not None:
            self._UserManagerUserList = []
            for item in params.get("UserManagerUserList"):
                obj = UserInfoForUserManager()
                obj._deserialize(item)
                self._UserManagerUserList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddUsersForUserManagerResponse(AbstractModel):
    r"""AddUsersForUserManager response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessUserList: The user list that is successfully added
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type SuccessUserList: list of str
        :param _FailedUserList: The user list that is not successfully added
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type FailedUserList: list of str
        :param _FlowId: Flow ID. If the flow ID is larger than 0, it means that the flow is launched; if the flow ID is equal to 0, it means that no flow is launched.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessUserList = None
        self._FailedUserList = None
        self._FlowId = None
        self._RequestId = None

    @property
    def SuccessUserList(self):
        r"""The user list that is successfully added
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of str
        """
        return self._SuccessUserList

    @SuccessUserList.setter
    def SuccessUserList(self, SuccessUserList):
        self._SuccessUserList = SuccessUserList

    @property
    def FailedUserList(self):
        r"""The user list that is not successfully added
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of str
        """
        return self._FailedUserList

    @FailedUserList.setter
    def FailedUserList(self, FailedUserList):
        self._FailedUserList = FailedUserList

    @property
    def FlowId(self):
        r"""Flow ID. If the flow ID is larger than 0, it means that the flow is launched; if the flow ID is equal to 0, it means that no flow is launched.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessUserList = params.get("SuccessUserList")
        self._FailedUserList = params.get("FailedUserList")
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class AllNodeResourceSpec(AbstractModel):
    r"""Resource description

    """

    def __init__(self):
        r"""
        :param _MasterResourceSpec: The description of master nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MasterResourceSpec: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        :param _CoreResourceSpec: The description of core nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CoreResourceSpec: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        :param _TaskResourceSpec: The description of task nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskResourceSpec: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        :param _CommonResourceSpec: The description of common nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CommonResourceSpec: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        :param _MasterCount: Number of Master nodes.
        :type MasterCount: int
        :param _CoreCount: Number of core nodes.
        :type CoreCount: int
        :param _TaskCount: Number of task nodes.
        :type TaskCount: int
        :param _CommonCount: Number of common nodes.
        :type CommonCount: int
        """
        self._MasterResourceSpec = None
        self._CoreResourceSpec = None
        self._TaskResourceSpec = None
        self._CommonResourceSpec = None
        self._MasterCount = None
        self._CoreCount = None
        self._TaskCount = None
        self._CommonCount = None

    @property
    def MasterResourceSpec(self):
        r"""The description of master nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        """
        return self._MasterResourceSpec

    @MasterResourceSpec.setter
    def MasterResourceSpec(self, MasterResourceSpec):
        self._MasterResourceSpec = MasterResourceSpec

    @property
    def CoreResourceSpec(self):
        r"""The description of core nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        """
        return self._CoreResourceSpec

    @CoreResourceSpec.setter
    def CoreResourceSpec(self, CoreResourceSpec):
        self._CoreResourceSpec = CoreResourceSpec

    @property
    def TaskResourceSpec(self):
        r"""The description of task nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        """
        return self._TaskResourceSpec

    @TaskResourceSpec.setter
    def TaskResourceSpec(self, TaskResourceSpec):
        self._TaskResourceSpec = TaskResourceSpec

    @property
    def CommonResourceSpec(self):
        r"""The description of common nodes.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        """
        return self._CommonResourceSpec

    @CommonResourceSpec.setter
    def CommonResourceSpec(self, CommonResourceSpec):
        self._CommonResourceSpec = CommonResourceSpec

    @property
    def MasterCount(self):
        r"""Number of Master nodes.
        :rtype: int
        """
        return self._MasterCount

    @MasterCount.setter
    def MasterCount(self, MasterCount):
        self._MasterCount = MasterCount

    @property
    def CoreCount(self):
        r"""Number of core nodes.
        :rtype: int
        """
        return self._CoreCount

    @CoreCount.setter
    def CoreCount(self, CoreCount):
        self._CoreCount = CoreCount

    @property
    def TaskCount(self):
        r"""Number of task nodes.
        :rtype: int
        """
        return self._TaskCount

    @TaskCount.setter
    def TaskCount(self, TaskCount):
        self._TaskCount = TaskCount

    @property
    def CommonCount(self):
        r"""Number of common nodes.
        :rtype: int
        """
        return self._CommonCount

    @CommonCount.setter
    def CommonCount(self, CommonCount):
        self._CommonCount = CommonCount


    def _deserialize(self, params):
        if params.get("MasterResourceSpec") is not None:
            self._MasterResourceSpec = NodeResourceSpec()
            self._MasterResourceSpec._deserialize(params.get("MasterResourceSpec"))
        if params.get("CoreResourceSpec") is not None:
            self._CoreResourceSpec = NodeResourceSpec()
            self._CoreResourceSpec._deserialize(params.get("CoreResourceSpec"))
        if params.get("TaskResourceSpec") is not None:
            self._TaskResourceSpec = NodeResourceSpec()
            self._TaskResourceSpec._deserialize(params.get("TaskResourceSpec"))
        if params.get("CommonResourceSpec") is not None:
            self._CommonResourceSpec = NodeResourceSpec()
            self._CommonResourceSpec._deserialize(params.get("CommonResourceSpec"))
        self._MasterCount = params.get("MasterCount")
        self._CoreCount = params.get("CoreCount")
        self._TaskCount = params.get("TaskCount")
        self._CommonCount = params.get("CommonCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationStatics(AbstractModel):
    r"""Yarn application statistics

    """

    def __init__(self):
        r"""
        :param _Queue: Queue name
        :type Queue: str
        :param _User: Username
        :type User: str
        :param _ApplicationType: Application type
        :type ApplicationType: str
        :param _SumMemorySeconds: `SumMemorySeconds` meaning
        :type SumMemorySeconds: int
        :param _SumVCoreSeconds: 
        :type SumVCoreSeconds: int
        :param _SumHDFSBytesWritten: SumHDFSBytesWritten (with unit)
        :type SumHDFSBytesWritten: str
        :param _SumHDFSBytesRead: SumHDFSBytesRead (with unit)
        :type SumHDFSBytesRead: str
        :param _CountApps: Application count
        :type CountApps: int
        """
        self._Queue = None
        self._User = None
        self._ApplicationType = None
        self._SumMemorySeconds = None
        self._SumVCoreSeconds = None
        self._SumHDFSBytesWritten = None
        self._SumHDFSBytesRead = None
        self._CountApps = None

    @property
    def Queue(self):
        r"""Queue name
        :rtype: str
        """
        return self._Queue

    @Queue.setter
    def Queue(self, Queue):
        self._Queue = Queue

    @property
    def User(self):
        r"""Username
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def ApplicationType(self):
        r"""Application type
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def SumMemorySeconds(self):
        r"""`SumMemorySeconds` meaning
        :rtype: int
        """
        return self._SumMemorySeconds

    @SumMemorySeconds.setter
    def SumMemorySeconds(self, SumMemorySeconds):
        self._SumMemorySeconds = SumMemorySeconds

    @property
    def SumVCoreSeconds(self):
        r"""
        :rtype: int
        """
        return self._SumVCoreSeconds

    @SumVCoreSeconds.setter
    def SumVCoreSeconds(self, SumVCoreSeconds):
        self._SumVCoreSeconds = SumVCoreSeconds

    @property
    def SumHDFSBytesWritten(self):
        r"""SumHDFSBytesWritten (with unit)
        :rtype: str
        """
        return self._SumHDFSBytesWritten

    @SumHDFSBytesWritten.setter
    def SumHDFSBytesWritten(self, SumHDFSBytesWritten):
        self._SumHDFSBytesWritten = SumHDFSBytesWritten

    @property
    def SumHDFSBytesRead(self):
        r"""SumHDFSBytesRead (with unit)
        :rtype: str
        """
        return self._SumHDFSBytesRead

    @SumHDFSBytesRead.setter
    def SumHDFSBytesRead(self, SumHDFSBytesRead):
        self._SumHDFSBytesRead = SumHDFSBytesRead

    @property
    def CountApps(self):
        r"""Application count
        :rtype: int
        """
        return self._CountApps

    @CountApps.setter
    def CountApps(self, CountApps):
        self._CountApps = CountApps


    def _deserialize(self, params):
        self._Queue = params.get("Queue")
        self._User = params.get("User")
        self._ApplicationType = params.get("ApplicationType")
        self._SumMemorySeconds = params.get("SumMemorySeconds")
        self._SumVCoreSeconds = params.get("SumVCoreSeconds")
        self._SumHDFSBytesWritten = params.get("SumHDFSBytesWritten")
        self._SumHDFSBytesRead = params.get("SumHDFSBytesRead")
        self._CountApps = params.get("CountApps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Arg(AbstractModel):
    r"""General parameters

    """

    def __init__(self):
        r"""
        :param _Key: key
        :type Key: str
        :param _Values: Value List

Note: This field may return null, indicating that no valid values can be obtained.
        :type Values: list of str
        """
        self._Key = None
        self._Values = None

    @property
    def Key(self):
        r"""key
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Values(self):
        r"""Value List

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachDisksRequest(AbstractModel):
    r"""AttachDisks request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of the EMR cluster instance.
        :type InstanceId: str
        :param _DiskIds: Cloud disk ID required for mounting.
        :type DiskIds: list of str
        :param _AlignType: Mount mode. Valid values.
AUTO_RENEW: auto-renewal.
ALIGN_DEADLINE: automatic alignment with the deadline.
        :type AlignType: str
        :param _CvmInstanceIds: List of CVM node IDs requiring mounting.
        :type CvmInstanceIds: list of str
        :param _CreateDisk: Whether to mount newly purchased cloud disks.
        :type CreateDisk: bool
        :param _DiskSpec: Specifications of newly purchased cloud disks.
        :type DiskSpec: :class:`tencentcloud.emr.v20190103.models.NodeSpecDiskV2`
        :param _DeleteWithInstance: Optional parameter. Only mount operation is performed if this parameter is not passed. When True is passed, the CBS will be set to termination with the cloud host upon successful mounting. This is only applicable to pay-as-you-go cloud disk.
        :type DeleteWithInstance: bool
        :param _SelectiveConfServices: Name list of services that can be configured when a new disk is mounted.
        :type SelectiveConfServices: list of str
        :param _ChargeType: Disk billing type (1: monthly subscription, 3: committed use).
        :type ChargeType: int
        :param _UnderWriteDuration: Disk committed use and purchase duration (only supports 12, 24, 36, 48, and 60).
        :type UnderWriteDuration: int
        """
        self._InstanceId = None
        self._DiskIds = None
        self._AlignType = None
        self._CvmInstanceIds = None
        self._CreateDisk = None
        self._DiskSpec = None
        self._DeleteWithInstance = None
        self._SelectiveConfServices = None
        self._ChargeType = None
        self._UnderWriteDuration = None

    @property
    def InstanceId(self):
        r"""ID of the EMR cluster instance.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DiskIds(self):
        r"""Cloud disk ID required for mounting.
        :rtype: list of str
        """
        return self._DiskIds

    @DiskIds.setter
    def DiskIds(self, DiskIds):
        self._DiskIds = DiskIds

    @property
    def AlignType(self):
        r"""Mount mode. Valid values.
AUTO_RENEW: auto-renewal.
ALIGN_DEADLINE: automatic alignment with the deadline.
        :rtype: str
        """
        return self._AlignType

    @AlignType.setter
    def AlignType(self, AlignType):
        self._AlignType = AlignType

    @property
    def CvmInstanceIds(self):
        r"""List of CVM node IDs requiring mounting.
        :rtype: list of str
        """
        return self._CvmInstanceIds

    @CvmInstanceIds.setter
    def CvmInstanceIds(self, CvmInstanceIds):
        self._CvmInstanceIds = CvmInstanceIds

    @property
    def CreateDisk(self):
        r"""Whether to mount newly purchased cloud disks.
        :rtype: bool
        """
        return self._CreateDisk

    @CreateDisk.setter
    def CreateDisk(self, CreateDisk):
        self._CreateDisk = CreateDisk

    @property
    def DiskSpec(self):
        r"""Specifications of newly purchased cloud disks.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeSpecDiskV2`
        """
        return self._DiskSpec

    @DiskSpec.setter
    def DiskSpec(self, DiskSpec):
        self._DiskSpec = DiskSpec

    @property
    def DeleteWithInstance(self):
        r"""Optional parameter. Only mount operation is performed if this parameter is not passed. When True is passed, the CBS will be set to termination with the cloud host upon successful mounting. This is only applicable to pay-as-you-go cloud disk.
        :rtype: bool
        """
        return self._DeleteWithInstance

    @DeleteWithInstance.setter
    def DeleteWithInstance(self, DeleteWithInstance):
        self._DeleteWithInstance = DeleteWithInstance

    @property
    def SelectiveConfServices(self):
        r"""Name list of services that can be configured when a new disk is mounted.
        :rtype: list of str
        """
        return self._SelectiveConfServices

    @SelectiveConfServices.setter
    def SelectiveConfServices(self, SelectiveConfServices):
        self._SelectiveConfServices = SelectiveConfServices

    @property
    def ChargeType(self):
        r"""Disk billing type (1: monthly subscription, 3: committed use).
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def UnderWriteDuration(self):
        r"""Disk committed use and purchase duration (only supports 12, 24, 36, 48, and 60).
        :rtype: int
        """
        return self._UnderWriteDuration

    @UnderWriteDuration.setter
    def UnderWriteDuration(self, UnderWriteDuration):
        self._UnderWriteDuration = UnderWriteDuration


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DiskIds = params.get("DiskIds")
        self._AlignType = params.get("AlignType")
        self._CvmInstanceIds = params.get("CvmInstanceIds")
        self._CreateDisk = params.get("CreateDisk")
        if params.get("DiskSpec") is not None:
            self._DiskSpec = NodeSpecDiskV2()
            self._DiskSpec._deserialize(params.get("DiskSpec"))
        self._DeleteWithInstance = params.get("DeleteWithInstance")
        self._SelectiveConfServices = params.get("SelectiveConfServices")
        self._ChargeType = params.get("ChargeType")
        self._UnderWriteDuration = params.get("UnderWriteDuration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachDisksResponse(AbstractModel):
    r"""AttachDisks response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Flow ID.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Flow ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class AutoScaleGroupAdvanceAttrs(AbstractModel):
    r"""Advanced settings of the auto-scaling group.

    """

    def __init__(self):
        r"""
        :param _ComputeResourceAdvanceParams: Advanced settings of computing resources.
        :type ComputeResourceAdvanceParams: :class:`tencentcloud.emr.v20190103.models.ComputeResourceAdvanceParams`
        """
        self._ComputeResourceAdvanceParams = None

    @property
    def ComputeResourceAdvanceParams(self):
        r"""Advanced settings of computing resources.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ComputeResourceAdvanceParams`
        """
        return self._ComputeResourceAdvanceParams

    @ComputeResourceAdvanceParams.setter
    def ComputeResourceAdvanceParams(self, ComputeResourceAdvanceParams):
        self._ComputeResourceAdvanceParams = ComputeResourceAdvanceParams


    def _deserialize(self, params):
        if params.get("ComputeResourceAdvanceParams") is not None:
            self._ComputeResourceAdvanceParams = ComputeResourceAdvanceParams()
            self._ComputeResourceAdvanceParams._deserialize(params.get("ComputeResourceAdvanceParams"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoScaleRecord(AbstractModel):
    r"""Elastic Scaling Record

    """

    def __init__(self):
        r"""
        :param _StrategyName: Name of the scale-in or scale-out rule.
        :type StrategyName: str
        :param _ScaleAction: "SCALE_OUT" and "SCALE_IN", representing expansion and reduction respectively.
        :type ScaleAction: str
        :param _ActionStatus: The values are "SUCCESS", "FAILED", "PART_SUCCESS", "IN_PROCESS", which indicate success, failure, partial success, and in-progress, respectively.
        :type ActionStatus: str
        :param _ActionTime: Process initiation time.
        :type ActionTime: str
        :param _ScaleInfo: Description related to auto-scaling.
        :type ScaleInfo: str
        :param _ExpectScaleNum: Valid only when ScaleAction is SCALE_OUT.
        :type ExpectScaleNum: int
        :param _EndTime: Process termination time.
        :type EndTime: str
        :param _StrategyType: Policy type. Valid values: 1 (load-based scaling), 2 (time-based scaling).
        :type StrategyType: int
        :param _SpecInfo: Specification information used during scale-out.
        :type SpecInfo: str
        :param _CompensateFlag: Compensatory scale-out. 0: disable, 1: enable.
        :type CompensateFlag: int
        :param _CompensateCount: Number of compensations.
        :type CompensateCount: int
        :param _RetryCount: Number of retries.
        :type RetryCount: int
        :param _RetryInfo: Retry information.
        :type RetryInfo: str
        :param _RetryEnReason: Retry description in English.
        :type RetryEnReason: str
        :param _RetryReason: Retry description.
        :type RetryReason: str
        """
        self._StrategyName = None
        self._ScaleAction = None
        self._ActionStatus = None
        self._ActionTime = None
        self._ScaleInfo = None
        self._ExpectScaleNum = None
        self._EndTime = None
        self._StrategyType = None
        self._SpecInfo = None
        self._CompensateFlag = None
        self._CompensateCount = None
        self._RetryCount = None
        self._RetryInfo = None
        self._RetryEnReason = None
        self._RetryReason = None

    @property
    def StrategyName(self):
        r"""Name of the scale-in or scale-out rule.
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def ScaleAction(self):
        r""""SCALE_OUT" and "SCALE_IN", representing expansion and reduction respectively.
        :rtype: str
        """
        return self._ScaleAction

    @ScaleAction.setter
    def ScaleAction(self, ScaleAction):
        self._ScaleAction = ScaleAction

    @property
    def ActionStatus(self):
        r"""The values are "SUCCESS", "FAILED", "PART_SUCCESS", "IN_PROCESS", which indicate success, failure, partial success, and in-progress, respectively.
        :rtype: str
        """
        return self._ActionStatus

    @ActionStatus.setter
    def ActionStatus(self, ActionStatus):
        self._ActionStatus = ActionStatus

    @property
    def ActionTime(self):
        r"""Process initiation time.
        :rtype: str
        """
        return self._ActionTime

    @ActionTime.setter
    def ActionTime(self, ActionTime):
        self._ActionTime = ActionTime

    @property
    def ScaleInfo(self):
        r"""Description related to auto-scaling.
        :rtype: str
        """
        return self._ScaleInfo

    @ScaleInfo.setter
    def ScaleInfo(self, ScaleInfo):
        self._ScaleInfo = ScaleInfo

    @property
    def ExpectScaleNum(self):
        r"""Valid only when ScaleAction is SCALE_OUT.
        :rtype: int
        """
        return self._ExpectScaleNum

    @ExpectScaleNum.setter
    def ExpectScaleNum(self, ExpectScaleNum):
        self._ExpectScaleNum = ExpectScaleNum

    @property
    def EndTime(self):
        r"""Process termination time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StrategyType(self):
        r"""Policy type. Valid values: 1 (load-based scaling), 2 (time-based scaling).
        :rtype: int
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def SpecInfo(self):
        r"""Specification information used during scale-out.
        :rtype: str
        """
        return self._SpecInfo

    @SpecInfo.setter
    def SpecInfo(self, SpecInfo):
        self._SpecInfo = SpecInfo

    @property
    def CompensateFlag(self):
        r"""Compensatory scale-out. 0: disable, 1: enable.
        :rtype: int
        """
        return self._CompensateFlag

    @CompensateFlag.setter
    def CompensateFlag(self, CompensateFlag):
        self._CompensateFlag = CompensateFlag

    @property
    def CompensateCount(self):
        r"""Number of compensations.
        :rtype: int
        """
        return self._CompensateCount

    @CompensateCount.setter
    def CompensateCount(self, CompensateCount):
        self._CompensateCount = CompensateCount

    @property
    def RetryCount(self):
        r"""Number of retries.
        :rtype: int
        """
        return self._RetryCount

    @RetryCount.setter
    def RetryCount(self, RetryCount):
        self._RetryCount = RetryCount

    @property
    def RetryInfo(self):
        r"""Retry information.
        :rtype: str
        """
        return self._RetryInfo

    @RetryInfo.setter
    def RetryInfo(self, RetryInfo):
        self._RetryInfo = RetryInfo

    @property
    def RetryEnReason(self):
        r"""Retry description in English.
        :rtype: str
        """
        return self._RetryEnReason

    @RetryEnReason.setter
    def RetryEnReason(self, RetryEnReason):
        self._RetryEnReason = RetryEnReason

    @property
    def RetryReason(self):
        r"""Retry description.
        :rtype: str
        """
        return self._RetryReason

    @RetryReason.setter
    def RetryReason(self, RetryReason):
        self._RetryReason = RetryReason


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        self._ScaleAction = params.get("ScaleAction")
        self._ActionStatus = params.get("ActionStatus")
        self._ActionTime = params.get("ActionTime")
        self._ScaleInfo = params.get("ScaleInfo")
        self._ExpectScaleNum = params.get("ExpectScaleNum")
        self._EndTime = params.get("EndTime")
        self._StrategyType = params.get("StrategyType")
        self._SpecInfo = params.get("SpecInfo")
        self._CompensateFlag = params.get("CompensateFlag")
        self._CompensateCount = params.get("CompensateCount")
        self._RetryCount = params.get("RetryCount")
        self._RetryInfo = params.get("RetryInfo")
        self._RetryEnReason = params.get("RetryEnReason")
        self._RetryReason = params.get("RetryReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoScaleResourceConf(AbstractModel):
    r"""Elastic scaling specification configuration

    """

    def __init__(self):
        r"""
        :param _Id: Configuration ID.
        :type Id: int
        :param _ClusterId: Cluster instance ID.
        :type ClusterId: int
        :param _ScaleLowerBound: Minimum number of instances retained for automatic scaling
        :type ScaleLowerBound: int
        :param _ScaleUpperBound: Maximum number of instances for auto scaling
        :type ScaleUpperBound: int
        :param _StrategyType: Scale-out rule type. 1: load-based scale-out rule, 2: time-based scale-out rule
        :type StrategyType: int
        :param _NextTimeCanScale: Next scale-out time.
        :type NextTimeCanScale: int
        :param _GraceDownFlag: Graceful scale-in switch.
        :type GraceDownFlag: bool
        :param _HardwareType: "CVM" indicates that the CVM type is used for all specifications, and "Pod" indicates that the container type is used for specifications. The default value is "CVM".
        :type HardwareType: str
        :param _PayMode: "POSTPAY" indicates the sole adoption of pay-as-you-go, and "SPOT_FIRST" indicates spot instance first, which is only supported when HardwareType is "HOST". "Pod" only supports pay-as-you-go.
        :type PayMode: str
        :param _PostPayPercentMin: The minimum percentage of pay-as-you-go resources in scenarios with spot instance first. It is an integer.
        :type PostPayPercentMin: int
        :param _ChangeToPod: When resource type is preset to HOST: Supports enabling/disabling "Fallback to pod when resources are insufficient"; Default state: 0 (disabled), Toggle state: 1 (enabled).
        :type ChangeToPod: int
        :param _GroupName: Scaling group name.
        :type GroupName: str
        :param _YarnNodeLabel: Tag.
        :type YarnNodeLabel: str
        :param _GroupStatus: Scaling group status.
        :type GroupStatus: int
        :param _Parallel: Parallel scaling. 0: disabled; 1: enabled.
        :type Parallel: int
        :param _EnableMNode: Whether MNode is supported.
        :type EnableMNode: int
        :param _ExtraAdvanceAttrs: More scaling group settings.
        :type ExtraAdvanceAttrs: :class:`tencentcloud.emr.v20190103.models.AutoScaleGroupAdvanceAttrs`
        """
        self._Id = None
        self._ClusterId = None
        self._ScaleLowerBound = None
        self._ScaleUpperBound = None
        self._StrategyType = None
        self._NextTimeCanScale = None
        self._GraceDownFlag = None
        self._HardwareType = None
        self._PayMode = None
        self._PostPayPercentMin = None
        self._ChangeToPod = None
        self._GroupName = None
        self._YarnNodeLabel = None
        self._GroupStatus = None
        self._Parallel = None
        self._EnableMNode = None
        self._ExtraAdvanceAttrs = None

    @property
    def Id(self):
        r"""Configuration ID.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ClusterId(self):
        r"""Cluster instance ID.
        :rtype: int
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ScaleLowerBound(self):
        r"""Minimum number of instances retained for automatic scaling
        :rtype: int
        """
        return self._ScaleLowerBound

    @ScaleLowerBound.setter
    def ScaleLowerBound(self, ScaleLowerBound):
        self._ScaleLowerBound = ScaleLowerBound

    @property
    def ScaleUpperBound(self):
        r"""Maximum number of instances for auto scaling
        :rtype: int
        """
        return self._ScaleUpperBound

    @ScaleUpperBound.setter
    def ScaleUpperBound(self, ScaleUpperBound):
        self._ScaleUpperBound = ScaleUpperBound

    @property
    def StrategyType(self):
        r"""Scale-out rule type. 1: load-based scale-out rule, 2: time-based scale-out rule
        :rtype: int
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def NextTimeCanScale(self):
        r"""Next scale-out time.
        :rtype: int
        """
        return self._NextTimeCanScale

    @NextTimeCanScale.setter
    def NextTimeCanScale(self, NextTimeCanScale):
        self._NextTimeCanScale = NextTimeCanScale

    @property
    def GraceDownFlag(self):
        r"""Graceful scale-in switch.
        :rtype: bool
        """
        return self._GraceDownFlag

    @GraceDownFlag.setter
    def GraceDownFlag(self, GraceDownFlag):
        self._GraceDownFlag = GraceDownFlag

    @property
    def HardwareType(self):
        r""""CVM" indicates that the CVM type is used for all specifications, and "Pod" indicates that the container type is used for specifications. The default value is "CVM".
        :rtype: str
        """
        return self._HardwareType

    @HardwareType.setter
    def HardwareType(self, HardwareType):
        self._HardwareType = HardwareType

    @property
    def PayMode(self):
        r""""POSTPAY" indicates the sole adoption of pay-as-you-go, and "SPOT_FIRST" indicates spot instance first, which is only supported when HardwareType is "HOST". "Pod" only supports pay-as-you-go.
        :rtype: str
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def PostPayPercentMin(self):
        r"""The minimum percentage of pay-as-you-go resources in scenarios with spot instance first. It is an integer.
        :rtype: int
        """
        return self._PostPayPercentMin

    @PostPayPercentMin.setter
    def PostPayPercentMin(self, PostPayPercentMin):
        self._PostPayPercentMin = PostPayPercentMin

    @property
    def ChangeToPod(self):
        r"""When resource type is preset to HOST: Supports enabling/disabling "Fallback to pod when resources are insufficient"; Default state: 0 (disabled), Toggle state: 1 (enabled).
        :rtype: int
        """
        return self._ChangeToPod

    @ChangeToPod.setter
    def ChangeToPod(self, ChangeToPod):
        self._ChangeToPod = ChangeToPod

    @property
    def GroupName(self):
        r"""Scaling group name.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def YarnNodeLabel(self):
        r"""Tag.
        :rtype: str
        """
        return self._YarnNodeLabel

    @YarnNodeLabel.setter
    def YarnNodeLabel(self, YarnNodeLabel):
        self._YarnNodeLabel = YarnNodeLabel

    @property
    def GroupStatus(self):
        r"""Scaling group status.
        :rtype: int
        """
        return self._GroupStatus

    @GroupStatus.setter
    def GroupStatus(self, GroupStatus):
        self._GroupStatus = GroupStatus

    @property
    def Parallel(self):
        r"""Parallel scaling. 0: disabled; 1: enabled.
        :rtype: int
        """
        return self._Parallel

    @Parallel.setter
    def Parallel(self, Parallel):
        self._Parallel = Parallel

    @property
    def EnableMNode(self):
        r"""Whether MNode is supported.
        :rtype: int
        """
        return self._EnableMNode

    @EnableMNode.setter
    def EnableMNode(self, EnableMNode):
        self._EnableMNode = EnableMNode

    @property
    def ExtraAdvanceAttrs(self):
        r"""More scaling group settings.
        :rtype: :class:`tencentcloud.emr.v20190103.models.AutoScaleGroupAdvanceAttrs`
        """
        return self._ExtraAdvanceAttrs

    @ExtraAdvanceAttrs.setter
    def ExtraAdvanceAttrs(self, ExtraAdvanceAttrs):
        self._ExtraAdvanceAttrs = ExtraAdvanceAttrs


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ClusterId = params.get("ClusterId")
        self._ScaleLowerBound = params.get("ScaleLowerBound")
        self._ScaleUpperBound = params.get("ScaleUpperBound")
        self._StrategyType = params.get("StrategyType")
        self._NextTimeCanScale = params.get("NextTimeCanScale")
        self._GraceDownFlag = params.get("GraceDownFlag")
        self._HardwareType = params.get("HardwareType")
        self._PayMode = params.get("PayMode")
        self._PostPayPercentMin = params.get("PostPayPercentMin")
        self._ChangeToPod = params.get("ChangeToPod")
        self._GroupName = params.get("GroupName")
        self._YarnNodeLabel = params.get("YarnNodeLabel")
        self._GroupStatus = params.get("GroupStatus")
        self._Parallel = params.get("Parallel")
        self._EnableMNode = params.get("EnableMNode")
        if params.get("ExtraAdvanceAttrs") is not None:
            self._ExtraAdvanceAttrs = AutoScaleGroupAdvanceAttrs()
            self._ExtraAdvanceAttrs._deserialize(params.get("ExtraAdvanceAttrs"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CBSInstance(AbstractModel):
    r"""CBS instance information.

    """

    def __init__(self):
        r"""
        :param _DiskId: Cloud disk ID.
        :type DiskId: str
        :param _DiskUsage: Cloud disk type.
        :type DiskUsage: str
        :param _DiskName: Cloud disk name.
        :type DiskName: str
        :param _DiskSize: Cloud disk size.
        :type DiskSize: int
        :param _DiskType: Cloud disk media type.
        :type DiskType: str
        :param _DeleteWithInstance: Whether to delete it with the instance.
        :type DeleteWithInstance: bool
        :param _DiskChargeType: Cloud disk billing type.
        :type DiskChargeType: str
        :param _DiskState: Cloud disk running status.
        :type DiskState: str
        :param _RenewFlag: Whether to perform auto-renewal.
        :type RenewFlag: str
        :param _DeadlineTime: Expiration time.
        :type DeadlineTime: str
        :param _Attached: Whether the cloud disk is mounted on the cloud host.
        :type Attached: bool
        :param _DifferDaysOfDeadline: Days remaining until disk expiration.
        :type DifferDaysOfDeadline: int
        :param _InstanceIdList: InstanceId of the CVM instance to which this cloud disk is currently mounted.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceIdList: list of str
        :param _InstanceId: ID of the cloud host to which the Cloud disk is mounted.
        :type InstanceId: str
        :param _Shareable: Whether the cloud disk is a shared cloud disk.
        :type Shareable: bool
        :param _EmrResourceId: EMR node ID.
        :type EmrResourceId: str
        :param _UnderwriteExpiredTime: Committed use expiration time.
        :type UnderwriteExpiredTime: str
        """
        self._DiskId = None
        self._DiskUsage = None
        self._DiskName = None
        self._DiskSize = None
        self._DiskType = None
        self._DeleteWithInstance = None
        self._DiskChargeType = None
        self._DiskState = None
        self._RenewFlag = None
        self._DeadlineTime = None
        self._Attached = None
        self._DifferDaysOfDeadline = None
        self._InstanceIdList = None
        self._InstanceId = None
        self._Shareable = None
        self._EmrResourceId = None
        self._UnderwriteExpiredTime = None

    @property
    def DiskId(self):
        r"""Cloud disk ID.
        :rtype: str
        """
        return self._DiskId

    @DiskId.setter
    def DiskId(self, DiskId):
        self._DiskId = DiskId

    @property
    def DiskUsage(self):
        r"""Cloud disk type.
        :rtype: str
        """
        return self._DiskUsage

    @DiskUsage.setter
    def DiskUsage(self, DiskUsage):
        self._DiskUsage = DiskUsage

    @property
    def DiskName(self):
        r"""Cloud disk name.
        :rtype: str
        """
        return self._DiskName

    @DiskName.setter
    def DiskName(self, DiskName):
        self._DiskName = DiskName

    @property
    def DiskSize(self):
        r"""Cloud disk size.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskType(self):
        r"""Cloud disk media type.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DeleteWithInstance(self):
        r"""Whether to delete it with the instance.
        :rtype: bool
        """
        return self._DeleteWithInstance

    @DeleteWithInstance.setter
    def DeleteWithInstance(self, DeleteWithInstance):
        self._DeleteWithInstance = DeleteWithInstance

    @property
    def DiskChargeType(self):
        r"""Cloud disk billing type.
        :rtype: str
        """
        return self._DiskChargeType

    @DiskChargeType.setter
    def DiskChargeType(self, DiskChargeType):
        self._DiskChargeType = DiskChargeType

    @property
    def DiskState(self):
        r"""Cloud disk running status.
        :rtype: str
        """
        return self._DiskState

    @DiskState.setter
    def DiskState(self, DiskState):
        self._DiskState = DiskState

    @property
    def RenewFlag(self):
        r"""Whether to perform auto-renewal.
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def DeadlineTime(self):
        r"""Expiration time.
        :rtype: str
        """
        return self._DeadlineTime

    @DeadlineTime.setter
    def DeadlineTime(self, DeadlineTime):
        self._DeadlineTime = DeadlineTime

    @property
    def Attached(self):
        r"""Whether the cloud disk is mounted on the cloud host.
        :rtype: bool
        """
        return self._Attached

    @Attached.setter
    def Attached(self, Attached):
        self._Attached = Attached

    @property
    def DifferDaysOfDeadline(self):
        r"""Days remaining until disk expiration.
        :rtype: int
        """
        return self._DifferDaysOfDeadline

    @DifferDaysOfDeadline.setter
    def DifferDaysOfDeadline(self, DifferDaysOfDeadline):
        self._DifferDaysOfDeadline = DifferDaysOfDeadline

    @property
    def InstanceIdList(self):
        r"""InstanceId of the CVM instance to which this cloud disk is currently mounted.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList

    @property
    def InstanceId(self):
        r"""ID of the cloud host to which the Cloud disk is mounted.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Shareable(self):
        r"""Whether the cloud disk is a shared cloud disk.
        :rtype: bool
        """
        return self._Shareable

    @Shareable.setter
    def Shareable(self, Shareable):
        self._Shareable = Shareable

    @property
    def EmrResourceId(self):
        r"""EMR node ID.
        :rtype: str
        """
        return self._EmrResourceId

    @EmrResourceId.setter
    def EmrResourceId(self, EmrResourceId):
        self._EmrResourceId = EmrResourceId

    @property
    def UnderwriteExpiredTime(self):
        r"""Committed use expiration time.
        :rtype: str
        """
        return self._UnderwriteExpiredTime

    @UnderwriteExpiredTime.setter
    def UnderwriteExpiredTime(self, UnderwriteExpiredTime):
        self._UnderwriteExpiredTime = UnderwriteExpiredTime


    def _deserialize(self, params):
        self._DiskId = params.get("DiskId")
        self._DiskUsage = params.get("DiskUsage")
        self._DiskName = params.get("DiskName")
        self._DiskSize = params.get("DiskSize")
        self._DiskType = params.get("DiskType")
        self._DeleteWithInstance = params.get("DeleteWithInstance")
        self._DiskChargeType = params.get("DiskChargeType")
        self._DiskState = params.get("DiskState")
        self._RenewFlag = params.get("RenewFlag")
        self._DeadlineTime = params.get("DeadlineTime")
        self._Attached = params.get("Attached")
        self._DifferDaysOfDeadline = params.get("DifferDaysOfDeadline")
        self._InstanceIdList = params.get("InstanceIdList")
        self._InstanceId = params.get("InstanceId")
        self._Shareable = params.get("Shareable")
        self._EmrResourceId = params.get("EmrResourceId")
        self._UnderwriteExpiredTime = params.get("UnderwriteExpiredTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class COSSettings(AbstractModel):
    r"""COS-related configuration

    """

    def __init__(self):
        r"""
        :param _CosSecretId: COS `SecretId`
        :type CosSecretId: str
        :param _CosSecretKey: COS `SecrectKey`
        :type CosSecretKey: str
        :param _LogOnCosPath: COS path to log
        :type LogOnCosPath: str
        """
        self._CosSecretId = None
        self._CosSecretKey = None
        self._LogOnCosPath = None

    @property
    def CosSecretId(self):
        r"""COS `SecretId`
        :rtype: str
        """
        return self._CosSecretId

    @CosSecretId.setter
    def CosSecretId(self, CosSecretId):
        self._CosSecretId = CosSecretId

    @property
    def CosSecretKey(self):
        r"""COS `SecrectKey`
        :rtype: str
        """
        return self._CosSecretKey

    @CosSecretKey.setter
    def CosSecretKey(self, CosSecretKey):
        self._CosSecretKey = CosSecretKey

    @property
    def LogOnCosPath(self):
        r"""COS path to log
        :rtype: str
        """
        return self._LogOnCosPath

    @LogOnCosPath.setter
    def LogOnCosPath(self, LogOnCosPath):
        self._LogOnCosPath = LogOnCosPath


    def _deserialize(self, params):
        self._CosSecretId = params.get("CosSecretId")
        self._CosSecretKey = params.get("CosSecretKey")
        self._LogOnCosPath = params.get("LogOnCosPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CapacityGlobalConfig(AbstractModel):
    r"""Global configurations of the capacity scheduler under Resource Scheduling.

    """

    def __init__(self):
        r"""
        :param _EnableLabel: Whether label-based scheduling is enabled.
        :type EnableLabel: bool
        :param _LabelDir: Path for tag information storage if label-based scheduling is enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LabelDir: str
        :param _QueueMappingOverride: Whether to overwrite the user-specified queue, wherein true indicates overwrite.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QueueMappingOverride: bool
        :param _DefaultSettings: Advanced settings.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefaultSettings: list of DefaultSetting
        """
        self._EnableLabel = None
        self._LabelDir = None
        self._QueueMappingOverride = None
        self._DefaultSettings = None

    @property
    def EnableLabel(self):
        r"""Whether label-based scheduling is enabled.
        :rtype: bool
        """
        return self._EnableLabel

    @EnableLabel.setter
    def EnableLabel(self, EnableLabel):
        self._EnableLabel = EnableLabel

    @property
    def LabelDir(self):
        r"""Path for tag information storage if label-based scheduling is enabled.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LabelDir

    @LabelDir.setter
    def LabelDir(self, LabelDir):
        self._LabelDir = LabelDir

    @property
    def QueueMappingOverride(self):
        r"""Whether to overwrite the user-specified queue, wherein true indicates overwrite.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._QueueMappingOverride

    @QueueMappingOverride.setter
    def QueueMappingOverride(self, QueueMappingOverride):
        self._QueueMappingOverride = QueueMappingOverride

    @property
    def DefaultSettings(self):
        r"""Advanced settings.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DefaultSetting
        """
        return self._DefaultSettings

    @DefaultSettings.setter
    def DefaultSettings(self, DefaultSettings):
        self._DefaultSettings = DefaultSettings


    def _deserialize(self, params):
        self._EnableLabel = params.get("EnableLabel")
        self._LabelDir = params.get("LabelDir")
        self._QueueMappingOverride = params.get("QueueMappingOverride")
        if params.get("DefaultSettings") is not None:
            self._DefaultSettings = []
            for item in params.get("DefaultSettings"):
                obj = DefaultSetting()
                obj._deserialize(item)
                self._DefaultSettings.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdbInfo(AbstractModel):
    r"""Output parameters

    """

    def __init__(self):
        r"""
        :param _InstanceName: Database instance.
        :type InstanceName: str
        :param _Ip: Database IP address.
        :type Ip: str
        :param _Port: Database port.
        :type Port: int
        :param _MemSize: Database memory specifications.
        :type MemSize: int
        :param _Volume: Database disk specifications.
        :type Volume: int
        :param _Service: Service identifier.
        :type Service: str
        :param _ExpireTime: Expiration time.
        :type ExpireTime: str
        :param _ApplyTime: Application time.
        :type ApplyTime: str
        :param _PayType: Billing type.
        :type PayType: int
        :param _ExpireFlag: Expiration flag.
        :type ExpireFlag: bool
        :param _Status: Database status.
        :type Status: int
        :param _IsAutoRenew: Renewal flag.
        :type IsAutoRenew: int
        :param _SerialNo: Database string.
        :type SerialNo: str
        :param _ZoneId: ZoneId
        :type ZoneId: int
        :param _RegionId: RegionId
        :type RegionId: int
        """
        self._InstanceName = None
        self._Ip = None
        self._Port = None
        self._MemSize = None
        self._Volume = None
        self._Service = None
        self._ExpireTime = None
        self._ApplyTime = None
        self._PayType = None
        self._ExpireFlag = None
        self._Status = None
        self._IsAutoRenew = None
        self._SerialNo = None
        self._ZoneId = None
        self._RegionId = None

    @property
    def InstanceName(self):
        r"""Database instance.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Ip(self):
        r"""Database IP address.
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        r"""Database port.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def MemSize(self):
        r"""Database memory specifications.
        :rtype: int
        """
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def Volume(self):
        r"""Database disk specifications.
        :rtype: int
        """
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume

    @property
    def Service(self):
        r"""Service identifier.
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def ExpireTime(self):
        r"""Expiration time.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def ApplyTime(self):
        r"""Application time.
        :rtype: str
        """
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def PayType(self):
        r"""Billing type.
        :rtype: int
        """
        return self._PayType

    @PayType.setter
    def PayType(self, PayType):
        self._PayType = PayType

    @property
    def ExpireFlag(self):
        r"""Expiration flag.
        :rtype: bool
        """
        return self._ExpireFlag

    @ExpireFlag.setter
    def ExpireFlag(self, ExpireFlag):
        self._ExpireFlag = ExpireFlag

    @property
    def Status(self):
        r"""Database status.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsAutoRenew(self):
        r"""Renewal flag.
        :rtype: int
        """
        return self._IsAutoRenew

    @IsAutoRenew.setter
    def IsAutoRenew(self, IsAutoRenew):
        self._IsAutoRenew = IsAutoRenew

    @property
    def SerialNo(self):
        r"""Database string.
        :rtype: str
        """
        return self._SerialNo

    @SerialNo.setter
    def SerialNo(self, SerialNo):
        self._SerialNo = SerialNo

    @property
    def ZoneId(self):
        r"""ZoneId
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RegionId(self):
        r"""RegionId
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._InstanceName = params.get("InstanceName")
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        self._MemSize = params.get("MemSize")
        self._Volume = params.get("Volume")
        self._Service = params.get("Service")
        self._ExpireTime = params.get("ExpireTime")
        self._ApplyTime = params.get("ApplyTime")
        self._PayType = params.get("PayType")
        self._ExpireFlag = params.get("ExpireFlag")
        self._Status = params.get("Status")
        self._IsAutoRenew = params.get("IsAutoRenew")
        self._SerialNo = params.get("SerialNo")
        self._ZoneId = params.get("ZoneId")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterExternalServiceInfo(AbstractModel):
    r"""Relationship between shared components and the current cluster

    """

    def __init__(self):
        r"""
        :param _DependType: Dependency relationship. 0: being depended on by other clusters, 1: depending on other clusters.
        :type DependType: int
        :param _Service: Shared component.
        :type Service: str
        :param _ClusterId: Shared cluster.
        :type ClusterId: str
        :param _ClusterStatus: Shared cluster status.
        :type ClusterStatus: int
        """
        self._DependType = None
        self._Service = None
        self._ClusterId = None
        self._ClusterStatus = None

    @property
    def DependType(self):
        r"""Dependency relationship. 0: being depended on by other clusters, 1: depending on other clusters.
        :rtype: int
        """
        return self._DependType

    @DependType.setter
    def DependType(self, DependType):
        self._DependType = DependType

    @property
    def Service(self):
        r"""Shared component.
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def ClusterId(self):
        r"""Shared cluster.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterStatus(self):
        r"""Shared cluster status.
        :rtype: int
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus


    def _deserialize(self, params):
        self._DependType = params.get("DependType")
        self._Service = params.get("Service")
        self._ClusterId = params.get("ClusterId")
        self._ClusterStatus = params.get("ClusterStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterIDToFlowID(AbstractModel):
    r"""Mapping of cluster ID and process ID

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _FlowId: Flow ID.
        :type FlowId: int
        """
        self._ClusterId = None
        self._FlowId = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def FlowId(self):
        r"""Flow ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterInstancesInfo(AbstractModel):
    r"""Cluster instance information

    """

    def __init__(self):
        r"""
        :param _Id: ID.
        :type Id: int
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _Ftitle: Title
Note: this field may return null, indicating that no valid values can be obtained.
        :type Ftitle: str
        :param _ClusterName: Cluster name.
        :type ClusterName: str
        :param _RegionId: Region ID.
        :type RegionId: int
        :param _ZoneId: Region ID.
        :type ZoneId: int
        :param _AppId: User AppID.
        :type AppId: int
        :param _Uin: User UIN.
        :type Uin: str
        :param _ProjectId: Project ID.
        :type ProjectId: int
        :param _VpcId: Cluster VPCID.
        :type VpcId: int
        :param _SubnetId: Subnet ID.
        :type SubnetId: int
        :param _Status: Instance status code. Valid range:
<li>2: the cluster is running.</li>
<li>3: the cluster is being created.</li>
<li>4: the cluster is being scaled out.</li>
<li>5: Router nodes are being added to the cluster.</li>
<li>6: components are being installed in the cluster.</li>
<li>7: commands are being executed in the cluster.</li>
<li>8: the service is being restarted.</li>
<li>9: maintenance is in progress.</li>
<li>10: the service is being suspended.</li>
<li>11: the cluster is exiting maintenance.</li>
<li>12: the cluster is exiting suspension.</li>
<li>13: the configuration is being distributed.</li>
<li>14: the cluster is being terminated.</li>
<li>15: the Core node is being destroyed.</li>
<li>16: the Task node is being destroyed.</li>
<li>17: the Router node is being destroyed.</li>
<li>18: the web proxy password is being changed.</li>
<li>19: the cluster is being isolated.</li>
<li>20: the cluster is undergoing a reversal transaction.</li>
<li>21: the cluster is being recycled.</li>
<li>22: the instance is waiting for resizing.</li>
<li>23: the cluster has been isolated.</li>
<li>24: the number of nodes is being reduced.</li>
<li>33: the cluster is waiting for a refund.</li>
<li>34: the cluster has received a refund.</li>
<li>301: creation failed.</li>
<li>302: scale-out failed.</li>
        :type Status: int
        :param _AddTime: Adding time.
        :type AddTime: str
        :param _RunTime: Runtime.
        :type RunTime: str
        :param _Config: Cluster product configuration information
Note: this field may return null, indicating that no valid values can be obtained.
        :type Config: :class:`tencentcloud.emr.v20190103.models.EmrProductConfigOutter`
        :param _MasterIp: Public network IP address of the primary node.
        :type MasterIp: str
        :param _EmrVersion: EMR version.
        :type EmrVersion: str
        :param _ChargeType: Charge type.
        :type ChargeType: int
        :param _TradeVersion: Transaction version.
        :type TradeVersion: int
        :param _ResourceOrderId: Resource order ID.
        :type ResourceOrderId: int
        :param _IsTradeCluster: Whether it is a billing cluster.
        :type IsTradeCluster: int
        :param _AlarmInfo: Alarm information of cluster error status.
        :type AlarmInfo: str
        :param _IsWoodpeckerCluster: Whether to adopt new architecture.
        :type IsWoodpeckerCluster: int
        :param _MetaDb: Metadatabase information.
        :type MetaDb: str
        :param _Tags: Tag information
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _HiveMetaDb: Hive metadata information.
        :type HiveMetaDb: str
        :param _ServiceClass: Cluster type: EMR,CLICKHOUSE,DRUID.
        :type ServiceClass: str
        :param _AliasInfo: Alias serialization of all nodes in the cluster.
        :type AliasInfo: str
        :param _ProductId: Cluster version ID.
        :type ProductId: int
        :param _Zone: Region ID.
        :type Zone: str
        :param _SceneName: Scenario name.
        :type SceneName: str
        :param _SceneServiceClass: Scenario-based cluster type.
        :type SceneServiceClass: str
        :param _SceneEmrVersion: Scenario-based EMR version.
        :type SceneEmrVersion: str
        :param _DisplayName: Scenario-based cluster type.
        :type DisplayName: str
        :param _VpcName: vpc name
        :type VpcName: str
        :param _SubnetName: subnet name
        :type SubnetName: str
        :param _ClusterExternalServiceInfo: Cluster dependency
Note: This field may return `null`, indicating that no valid value was found.
        :type ClusterExternalServiceInfo: list of ClusterExternalServiceInfo
        :param _UniqVpcId: Cluster vpcid string type.
        :type UniqVpcId: str
        :param _UniqSubnetId: Subnet ID string type.
        :type UniqSubnetId: str
        :param _TopologyInfoList: Node information
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TopologyInfoList: list of TopologyInfo
        :param _IsMultiZoneCluster: Whether it is a cross-AZ cluster.
        :type IsMultiZoneCluster: bool
        :param _IsCvmReplace: Whether to enable automatic compensation for abnormal nodes.
        :type IsCvmReplace: bool
        :param _ClusterTitle: Title.
        :type ClusterTitle: str
        :param _ConfigDetail: Cluster product configuration information

Note: This field may return null, indicating that no valid values can be obtained.
        :type ConfigDetail: :class:`tencentcloud.emr.v20190103.models.EmrProductConfigDetail`
        :param _BindFileSystemNum: Number of file systems bound to a cluster.
        :type BindFileSystemNum: int
        :param _ClusterRelationInfoList: Bound list of the RSS cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterRelationInfoList: list of ClusterRelationMeta
        :param _RedisId: Redis information.
        :type RedisId: str
        """
        self._Id = None
        self._ClusterId = None
        self._Ftitle = None
        self._ClusterName = None
        self._RegionId = None
        self._ZoneId = None
        self._AppId = None
        self._Uin = None
        self._ProjectId = None
        self._VpcId = None
        self._SubnetId = None
        self._Status = None
        self._AddTime = None
        self._RunTime = None
        self._Config = None
        self._MasterIp = None
        self._EmrVersion = None
        self._ChargeType = None
        self._TradeVersion = None
        self._ResourceOrderId = None
        self._IsTradeCluster = None
        self._AlarmInfo = None
        self._IsWoodpeckerCluster = None
        self._MetaDb = None
        self._Tags = None
        self._HiveMetaDb = None
        self._ServiceClass = None
        self._AliasInfo = None
        self._ProductId = None
        self._Zone = None
        self._SceneName = None
        self._SceneServiceClass = None
        self._SceneEmrVersion = None
        self._DisplayName = None
        self._VpcName = None
        self._SubnetName = None
        self._ClusterExternalServiceInfo = None
        self._UniqVpcId = None
        self._UniqSubnetId = None
        self._TopologyInfoList = None
        self._IsMultiZoneCluster = None
        self._IsCvmReplace = None
        self._ClusterTitle = None
        self._ConfigDetail = None
        self._BindFileSystemNum = None
        self._ClusterRelationInfoList = None
        self._RedisId = None

    @property
    def Id(self):
        r"""ID.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Ftitle(self):
        warnings.warn("parameter `Ftitle` is deprecated", DeprecationWarning) 

        r"""Title
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Ftitle

    @Ftitle.setter
    def Ftitle(self, Ftitle):
        warnings.warn("parameter `Ftitle` is deprecated", DeprecationWarning) 

        self._Ftitle = Ftitle

    @property
    def ClusterName(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def RegionId(self):
        r"""Region ID.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def ZoneId(self):
        r"""Region ID.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def AppId(self):
        r"""User AppID.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        r"""User UIN.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def ProjectId(self):
        r"""Project ID.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def VpcId(self):
        r"""Cluster VPCID.
        :rtype: int
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID.
        :rtype: int
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Status(self):
        r"""Instance status code. Valid range:
<li>2: the cluster is running.</li>
<li>3: the cluster is being created.</li>
<li>4: the cluster is being scaled out.</li>
<li>5: Router nodes are being added to the cluster.</li>
<li>6: components are being installed in the cluster.</li>
<li>7: commands are being executed in the cluster.</li>
<li>8: the service is being restarted.</li>
<li>9: maintenance is in progress.</li>
<li>10: the service is being suspended.</li>
<li>11: the cluster is exiting maintenance.</li>
<li>12: the cluster is exiting suspension.</li>
<li>13: the configuration is being distributed.</li>
<li>14: the cluster is being terminated.</li>
<li>15: the Core node is being destroyed.</li>
<li>16: the Task node is being destroyed.</li>
<li>17: the Router node is being destroyed.</li>
<li>18: the web proxy password is being changed.</li>
<li>19: the cluster is being isolated.</li>
<li>20: the cluster is undergoing a reversal transaction.</li>
<li>21: the cluster is being recycled.</li>
<li>22: the instance is waiting for resizing.</li>
<li>23: the cluster has been isolated.</li>
<li>24: the number of nodes is being reduced.</li>
<li>33: the cluster is waiting for a refund.</li>
<li>34: the cluster has received a refund.</li>
<li>301: creation failed.</li>
<li>302: scale-out failed.</li>
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AddTime(self):
        r"""Adding time.
        :rtype: str
        """
        return self._AddTime

    @AddTime.setter
    def AddTime(self, AddTime):
        self._AddTime = AddTime

    @property
    def RunTime(self):
        r"""Runtime.
        :rtype: str
        """
        return self._RunTime

    @RunTime.setter
    def RunTime(self, RunTime):
        self._RunTime = RunTime

    @property
    def Config(self):
        warnings.warn("parameter `Config` is deprecated", DeprecationWarning) 

        r"""Cluster product configuration information
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.EmrProductConfigOutter`
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        warnings.warn("parameter `Config` is deprecated", DeprecationWarning) 

        self._Config = Config

    @property
    def MasterIp(self):
        r"""Public network IP address of the primary node.
        :rtype: str
        """
        return self._MasterIp

    @MasterIp.setter
    def MasterIp(self, MasterIp):
        self._MasterIp = MasterIp

    @property
    def EmrVersion(self):
        r"""EMR version.
        :rtype: str
        """
        return self._EmrVersion

    @EmrVersion.setter
    def EmrVersion(self, EmrVersion):
        self._EmrVersion = EmrVersion

    @property
    def ChargeType(self):
        r"""Charge type.
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def TradeVersion(self):
        r"""Transaction version.
        :rtype: int
        """
        return self._TradeVersion

    @TradeVersion.setter
    def TradeVersion(self, TradeVersion):
        self._TradeVersion = TradeVersion

    @property
    def ResourceOrderId(self):
        r"""Resource order ID.
        :rtype: int
        """
        return self._ResourceOrderId

    @ResourceOrderId.setter
    def ResourceOrderId(self, ResourceOrderId):
        self._ResourceOrderId = ResourceOrderId

    @property
    def IsTradeCluster(self):
        r"""Whether it is a billing cluster.
        :rtype: int
        """
        return self._IsTradeCluster

    @IsTradeCluster.setter
    def IsTradeCluster(self, IsTradeCluster):
        self._IsTradeCluster = IsTradeCluster

    @property
    def AlarmInfo(self):
        r"""Alarm information of cluster error status.
        :rtype: str
        """
        return self._AlarmInfo

    @AlarmInfo.setter
    def AlarmInfo(self, AlarmInfo):
        self._AlarmInfo = AlarmInfo

    @property
    def IsWoodpeckerCluster(self):
        r"""Whether to adopt new architecture.
        :rtype: int
        """
        return self._IsWoodpeckerCluster

    @IsWoodpeckerCluster.setter
    def IsWoodpeckerCluster(self, IsWoodpeckerCluster):
        self._IsWoodpeckerCluster = IsWoodpeckerCluster

    @property
    def MetaDb(self):
        r"""Metadatabase information.
        :rtype: str
        """
        return self._MetaDb

    @MetaDb.setter
    def MetaDb(self, MetaDb):
        self._MetaDb = MetaDb

    @property
    def Tags(self):
        r"""Tag information
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def HiveMetaDb(self):
        r"""Hive metadata information.
        :rtype: str
        """
        return self._HiveMetaDb

    @HiveMetaDb.setter
    def HiveMetaDb(self, HiveMetaDb):
        self._HiveMetaDb = HiveMetaDb

    @property
    def ServiceClass(self):
        r"""Cluster type: EMR,CLICKHOUSE,DRUID.
        :rtype: str
        """
        return self._ServiceClass

    @ServiceClass.setter
    def ServiceClass(self, ServiceClass):
        self._ServiceClass = ServiceClass

    @property
    def AliasInfo(self):
        r"""Alias serialization of all nodes in the cluster.
        :rtype: str
        """
        return self._AliasInfo

    @AliasInfo.setter
    def AliasInfo(self, AliasInfo):
        self._AliasInfo = AliasInfo

    @property
    def ProductId(self):
        r"""Cluster version ID.
        :rtype: int
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def Zone(self):
        r"""Region ID.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def SceneName(self):
        r"""Scenario name.
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def SceneServiceClass(self):
        r"""Scenario-based cluster type.
        :rtype: str
        """
        return self._SceneServiceClass

    @SceneServiceClass.setter
    def SceneServiceClass(self, SceneServiceClass):
        self._SceneServiceClass = SceneServiceClass

    @property
    def SceneEmrVersion(self):
        r"""Scenario-based EMR version.
        :rtype: str
        """
        return self._SceneEmrVersion

    @SceneEmrVersion.setter
    def SceneEmrVersion(self, SceneEmrVersion):
        self._SceneEmrVersion = SceneEmrVersion

    @property
    def DisplayName(self):
        r"""Scenario-based cluster type.
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def VpcName(self):
        r"""vpc name
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def SubnetName(self):
        r"""subnet name
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def ClusterExternalServiceInfo(self):
        r"""Cluster dependency
Note: This field may return `null`, indicating that no valid value was found.
        :rtype: list of ClusterExternalServiceInfo
        """
        return self._ClusterExternalServiceInfo

    @ClusterExternalServiceInfo.setter
    def ClusterExternalServiceInfo(self, ClusterExternalServiceInfo):
        self._ClusterExternalServiceInfo = ClusterExternalServiceInfo

    @property
    def UniqVpcId(self):
        r"""Cluster vpcid string type.
        :rtype: str
        """
        return self._UniqVpcId

    @UniqVpcId.setter
    def UniqVpcId(self, UniqVpcId):
        self._UniqVpcId = UniqVpcId

    @property
    def UniqSubnetId(self):
        r"""Subnet ID string type.
        :rtype: str
        """
        return self._UniqSubnetId

    @UniqSubnetId.setter
    def UniqSubnetId(self, UniqSubnetId):
        self._UniqSubnetId = UniqSubnetId

    @property
    def TopologyInfoList(self):
        r"""Node information
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: list of TopologyInfo
        """
        return self._TopologyInfoList

    @TopologyInfoList.setter
    def TopologyInfoList(self, TopologyInfoList):
        self._TopologyInfoList = TopologyInfoList

    @property
    def IsMultiZoneCluster(self):
        r"""Whether it is a cross-AZ cluster.
        :rtype: bool
        """
        return self._IsMultiZoneCluster

    @IsMultiZoneCluster.setter
    def IsMultiZoneCluster(self, IsMultiZoneCluster):
        self._IsMultiZoneCluster = IsMultiZoneCluster

    @property
    def IsCvmReplace(self):
        r"""Whether to enable automatic compensation for abnormal nodes.
        :rtype: bool
        """
        return self._IsCvmReplace

    @IsCvmReplace.setter
    def IsCvmReplace(self, IsCvmReplace):
        self._IsCvmReplace = IsCvmReplace

    @property
    def ClusterTitle(self):
        r"""Title.
        :rtype: str
        """
        return self._ClusterTitle

    @ClusterTitle.setter
    def ClusterTitle(self, ClusterTitle):
        self._ClusterTitle = ClusterTitle

    @property
    def ConfigDetail(self):
        r"""Cluster product configuration information

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.EmrProductConfigDetail`
        """
        return self._ConfigDetail

    @ConfigDetail.setter
    def ConfigDetail(self, ConfigDetail):
        self._ConfigDetail = ConfigDetail

    @property
    def BindFileSystemNum(self):
        r"""Number of file systems bound to a cluster.
        :rtype: int
        """
        return self._BindFileSystemNum

    @BindFileSystemNum.setter
    def BindFileSystemNum(self, BindFileSystemNum):
        self._BindFileSystemNum = BindFileSystemNum

    @property
    def ClusterRelationInfoList(self):
        r"""Bound list of the RSS cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ClusterRelationMeta
        """
        return self._ClusterRelationInfoList

    @ClusterRelationInfoList.setter
    def ClusterRelationInfoList(self, ClusterRelationInfoList):
        self._ClusterRelationInfoList = ClusterRelationInfoList

    @property
    def RedisId(self):
        r"""Redis information.
        :rtype: str
        """
        return self._RedisId

    @RedisId.setter
    def RedisId(self, RedisId):
        self._RedisId = RedisId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ClusterId = params.get("ClusterId")
        self._Ftitle = params.get("Ftitle")
        self._ClusterName = params.get("ClusterName")
        self._RegionId = params.get("RegionId")
        self._ZoneId = params.get("ZoneId")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._ProjectId = params.get("ProjectId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Status = params.get("Status")
        self._AddTime = params.get("AddTime")
        self._RunTime = params.get("RunTime")
        if params.get("Config") is not None:
            self._Config = EmrProductConfigOutter()
            self._Config._deserialize(params.get("Config"))
        self._MasterIp = params.get("MasterIp")
        self._EmrVersion = params.get("EmrVersion")
        self._ChargeType = params.get("ChargeType")
        self._TradeVersion = params.get("TradeVersion")
        self._ResourceOrderId = params.get("ResourceOrderId")
        self._IsTradeCluster = params.get("IsTradeCluster")
        self._AlarmInfo = params.get("AlarmInfo")
        self._IsWoodpeckerCluster = params.get("IsWoodpeckerCluster")
        self._MetaDb = params.get("MetaDb")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._HiveMetaDb = params.get("HiveMetaDb")
        self._ServiceClass = params.get("ServiceClass")
        self._AliasInfo = params.get("AliasInfo")
        self._ProductId = params.get("ProductId")
        self._Zone = params.get("Zone")
        self._SceneName = params.get("SceneName")
        self._SceneServiceClass = params.get("SceneServiceClass")
        self._SceneEmrVersion = params.get("SceneEmrVersion")
        self._DisplayName = params.get("DisplayName")
        self._VpcName = params.get("VpcName")
        self._SubnetName = params.get("SubnetName")
        if params.get("ClusterExternalServiceInfo") is not None:
            self._ClusterExternalServiceInfo = []
            for item in params.get("ClusterExternalServiceInfo"):
                obj = ClusterExternalServiceInfo()
                obj._deserialize(item)
                self._ClusterExternalServiceInfo.append(obj)
        self._UniqVpcId = params.get("UniqVpcId")
        self._UniqSubnetId = params.get("UniqSubnetId")
        if params.get("TopologyInfoList") is not None:
            self._TopologyInfoList = []
            for item in params.get("TopologyInfoList"):
                obj = TopologyInfo()
                obj._deserialize(item)
                self._TopologyInfoList.append(obj)
        self._IsMultiZoneCluster = params.get("IsMultiZoneCluster")
        self._IsCvmReplace = params.get("IsCvmReplace")
        self._ClusterTitle = params.get("ClusterTitle")
        if params.get("ConfigDetail") is not None:
            self._ConfigDetail = EmrProductConfigDetail()
            self._ConfigDetail._deserialize(params.get("ConfigDetail"))
        self._BindFileSystemNum = params.get("BindFileSystemNum")
        if params.get("ClusterRelationInfoList") is not None:
            self._ClusterRelationInfoList = []
            for item in params.get("ClusterRelationInfoList"):
                obj = ClusterRelationMeta()
                obj._deserialize(item)
                self._ClusterRelationInfoList.append(obj)
        self._RedisId = params.get("RedisId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterRelationMeta(AbstractModel):
    r"""Inter-cluster binding and usage information.

    """

    def __init__(self):
        r"""
        :param _ClusterType: Cluster type.
        :type ClusterType: str
        :param _ClusterIdList: Cluster ID list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterIdList: list of str
        """
        self._ClusterType = None
        self._ClusterIdList = None

    @property
    def ClusterType(self):
        r"""Cluster type.
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterIdList(self):
        r"""Cluster ID list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._ClusterIdList

    @ClusterIdList.setter
    def ClusterIdList(self, ClusterIdList):
        self._ClusterIdList = ClusterIdList


    def _deserialize(self, params):
        self._ClusterType = params.get("ClusterType")
        self._ClusterIdList = params.get("ClusterIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentBasicRestartInfo(AbstractModel):
    r"""Target processes

    """

    def __init__(self):
        r"""
        :param _ComponentName: Process name which is required, such as NameNode.
        :type ComponentName: str
        :param _IpList: The target IP list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IpList: list of str
        """
        self._ComponentName = None
        self._IpList = None

    @property
    def ComponentName(self):
        r"""Process name which is required, such as NameNode.
        :rtype: str
        """
        return self._ComponentName

    @ComponentName.setter
    def ComponentName(self, ComponentName):
        self._ComponentName = ComponentName

    @property
    def IpList(self):
        r"""The target IP list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList


    def _deserialize(self, params):
        self._ComponentName = params.get("ComponentName")
        self._IpList = params.get("IpList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComputeResourceAdvanceParams(AbstractModel):
    r"""Advanced settings of computing resources.

    """

    def __init__(self):
        r"""
        :param _Labels: Node label array.
        :type Labels: list of TkeLabel
        :param _Taints: Node taint.
        :type Taints: list of Taint
        :param _PreStartUserScript: Base64-encoded user script: executed before node initializing.
        :type PreStartUserScript: str
        :param _UserScript: Base64-encoded user script. This script executes after Kubernetes components initialize. Users should ensure script reentrancy and implement retry logic. Both the script and its generated log files are accessible at the node path: /data/ccs_userscript/.
        :type UserScript: str
        """
        self._Labels = None
        self._Taints = None
        self._PreStartUserScript = None
        self._UserScript = None

    @property
    def Labels(self):
        r"""Node label array.
        :rtype: list of TkeLabel
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Taints(self):
        r"""Node taint.
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def PreStartUserScript(self):
        r"""Base64-encoded user script: executed before node initializing.
        :rtype: str
        """
        return self._PreStartUserScript

    @PreStartUserScript.setter
    def PreStartUserScript(self, PreStartUserScript):
        self._PreStartUserScript = PreStartUserScript

    @property
    def UserScript(self):
        r"""Base64-encoded user script. This script executes after Kubernetes components initialize. Users should ensure script reentrancy and implement retry logic. Both the script and its generated log files are accessible at the node path: /data/ccs_userscript/.
        :rtype: str
        """
        return self._UserScript

    @UserScript.setter
    def UserScript(self, UserScript):
        self._UserScript = UserScript


    def _deserialize(self, params):
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = TkeLabel()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Taints") is not None:
            self._Taints = []
            for item in params.get("Taints"):
                obj = Taint()
                obj._deserialize(item)
                self._Taints.append(obj)
        self._PreStartUserScript = params.get("PreStartUserScript")
        self._UserScript = params.get("UserScript")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigModifyInfoV2(AbstractModel):
    r"""Resource scheduling - Queue modification information

    """

    def __init__(self):
        r"""
        :param _OpType: Operation type. Valid values:

- 0: create a queue.
- 1: edit - full overwrite.
- 2: create a sub-queue.
- 3: delete.
- 4: clone. It is the same as sub-queue creation. Especially, for `fair`, a sub-queue can be copied to a new queue.
- 6: edit - incremental update.
        :type OpType: int
        :param _Name: Queue name. It cannot be modified.
        :type Name: str
        :param _ParentId: Create root queue: Pass "myId of root"; Create sub-queue: Pass "myId of the selected queue"; Clone queue: Pass "parentId of the selected queue".
        :type ParentId: str
        :param _MyId: Edit or delete operations: Require passing "myId of the selected queue". Passing is required for cloning only when the scheduler is `fair` in order to copy a sub-queue to a new queue.
        :type MyId: str
        :param _BasicParams: Basic configuration. The value of key is consistent with the field returned by **DescribeYarnQueue**.###### Fair scheduler
Values of key are as follows:

- type: parent queue. Value: **parent** or **null**.
- aclSubmitApps: submission ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- aclAdministerApps: administration ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- minSharePreemptionTimeout: timeout of minimum share before preemption. Value: **numeric string** or **null**.
- fairSharePreemptionTimeout: timeout of fair share before preemption. Value: **numeric string** or **null**.
- fairSharePreemptionThreshold: fair share preemption threshold. Value: **numeric string** or **null**. Numeric string range: (0,1].
- allowPreemptionFrom: preemption mode. Value: **Boolean string** or **null**.
- schedulingPolicy: scheduling policy. Value: **drf**, **fair**, **fifo**, or **null**.

```
type AclForYarnQueue struct {
	User  *string `json:"user"` // Username
	Group *string `json:"group"`// Group name
}
```
###### Capacity scheduler
Values of key are as follows:

- state: queue status. Value: **STOPPED** or **RUNNING**.
- default-node-label-expression: default tag expression. Value: **tag** or **null**.
- acl_submit_applications: submission ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- acl_administer_queue: administration ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- maximum-allocation-mb: maximum memory allocated to each container. Value: **numeric string** or **null**.
- maximum-allocation-vcores: maximum number of virtual cores allocated to each container. Value: **numeric string** or **null**.
```
type AclForYarnQueue struct {
	User  *string `json:"user"` // Username
	Group *string `json:"group"`// Group name
}
```
Note: This field may return null, indicating that no valid values can be obtained.
        :type BasicParams: :class:`tencentcloud.emr.v20190103.models.ItemSeq`
        :param _ConfigSetParams: Configuration set information. For the values, see the parameter description of ConfigSetInfo. Configuration set is the representation of the plan mode in the queue, containing different configuration item values for different time periods. The configuration set names of all queues are the same. For a single queue, the tags and parameters in each configuration set are the same, but the parameter values are different.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConfigSetParams: list of ConfigSetInfo
        :param _DeleteLables: This parameter is specific for capacity scheduling and is valid only when `OpType` is set to `6`. It indicates tags to be deleted from the queue. This parameter has a higher priority than LabelParams in ConfigSetParams.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DeleteLables: list of str
        """
        self._OpType = None
        self._Name = None
        self._ParentId = None
        self._MyId = None
        self._BasicParams = None
        self._ConfigSetParams = None
        self._DeleteLables = None

    @property
    def OpType(self):
        r"""Operation type. Valid values:

- 0: create a queue.
- 1: edit - full overwrite.
- 2: create a sub-queue.
- 3: delete.
- 4: clone. It is the same as sub-queue creation. Especially, for `fair`, a sub-queue can be copied to a new queue.
- 6: edit - incremental update.
        :rtype: int
        """
        return self._OpType

    @OpType.setter
    def OpType(self, OpType):
        self._OpType = OpType

    @property
    def Name(self):
        r"""Queue name. It cannot be modified.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ParentId(self):
        r"""Create root queue: Pass "myId of root"; Create sub-queue: Pass "myId of the selected queue"; Clone queue: Pass "parentId of the selected queue".
        :rtype: str
        """
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MyId(self):
        r"""Edit or delete operations: Require passing "myId of the selected queue". Passing is required for cloning only when the scheduler is `fair` in order to copy a sub-queue to a new queue.
        :rtype: str
        """
        return self._MyId

    @MyId.setter
    def MyId(self, MyId):
        self._MyId = MyId

    @property
    def BasicParams(self):
        r"""Basic configuration. The value of key is consistent with the field returned by **DescribeYarnQueue**.###### Fair scheduler
Values of key are as follows:

- type: parent queue. Value: **parent** or **null**.
- aclSubmitApps: submission ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- aclAdministerApps: administration ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- minSharePreemptionTimeout: timeout of minimum share before preemption. Value: **numeric string** or **null**.
- fairSharePreemptionTimeout: timeout of fair share before preemption. Value: **numeric string** or **null**.
- fairSharePreemptionThreshold: fair share preemption threshold. Value: **numeric string** or **null**. Numeric string range: (0,1].
- allowPreemptionFrom: preemption mode. Value: **Boolean string** or **null**.
- schedulingPolicy: scheduling policy. Value: **drf**, **fair**, **fifo**, or **null**.

```
type AclForYarnQueue struct {
	User  *string `json:"user"` // Username
	Group *string `json:"group"`// Group name
}
```
###### Capacity scheduler
Values of key are as follows:

- state: queue status. Value: **STOPPED** or **RUNNING**.
- default-node-label-expression: default tag expression. Value: **tag** or **null**.
- acl_submit_applications: submission ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- acl_administer_queue: administration ACL. Value: **JSON string of the AclForYarnQueue type** or **null**.
- maximum-allocation-mb: maximum memory allocated to each container. Value: **numeric string** or **null**.
- maximum-allocation-vcores: maximum number of virtual cores allocated to each container. Value: **numeric string** or **null**.
```
type AclForYarnQueue struct {
	User  *string `json:"user"` // Username
	Group *string `json:"group"`// Group name
}
```
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ItemSeq`
        """
        return self._BasicParams

    @BasicParams.setter
    def BasicParams(self, BasicParams):
        self._BasicParams = BasicParams

    @property
    def ConfigSetParams(self):
        r"""Configuration set information. For the values, see the parameter description of ConfigSetInfo. Configuration set is the representation of the plan mode in the queue, containing different configuration item values for different time periods. The configuration set names of all queues are the same. For a single queue, the tags and parameters in each configuration set are the same, but the parameter values are different.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ConfigSetInfo
        """
        return self._ConfigSetParams

    @ConfigSetParams.setter
    def ConfigSetParams(self, ConfigSetParams):
        self._ConfigSetParams = ConfigSetParams

    @property
    def DeleteLables(self):
        r"""This parameter is specific for capacity scheduling and is valid only when `OpType` is set to `6`. It indicates tags to be deleted from the queue. This parameter has a higher priority than LabelParams in ConfigSetParams.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DeleteLables

    @DeleteLables.setter
    def DeleteLables(self, DeleteLables):
        self._DeleteLables = DeleteLables


    def _deserialize(self, params):
        self._OpType = params.get("OpType")
        self._Name = params.get("Name")
        self._ParentId = params.get("ParentId")
        self._MyId = params.get("MyId")
        if params.get("BasicParams") is not None:
            self._BasicParams = ItemSeq()
            self._BasicParams._deserialize(params.get("BasicParams"))
        if params.get("ConfigSetParams") is not None:
            self._ConfigSetParams = []
            for item in params.get("ConfigSetParams"):
                obj = ConfigSetInfo()
                obj._deserialize(item)
                self._ConfigSetParams.append(obj)
        self._DeleteLables = params.get("DeleteLables")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigSetInfo(AbstractModel):
    r"""Resource scheduling - configuration set information.

    """

    def __init__(self):
        r"""
        :param _ConfigSet: Configuration set name.
        :type ConfigSet: str
        :param _LabelParams: The capacity scheduler will use it, where tag-related configuration is set. The key values are consistent with the fields returned by **DescribeYarnQueue**.
The key values are as follows:
- labelName: Tag name, that is, tags in tag management.
- capacity: Capacity. The value is a **numeric string**.
- maximum-capacity: Maximum capacity. The value is a **numeric string**.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LabelParams: list of ItemSeq
        :param _BasicParams: Set parameters related to the configuration set. The key values are consistent with the fields returned by **DescribeYarnQueue**.
###### Fair scheduler.
The key values are as follows:
- minResources: Minimum resource amount. The value is a **JSON string of the YarnResource type** or **null**.
- maxResources: Maximum resource amount. The value is a **JSON string of the YarnResource type** or **null**.
- maxChildResources: Maximum resource amount for undeclared subqueues. The value is a **numeric string** or **null**.
- maxRunningApps: Maximum number of apps that can run concurrently. The value is a **numeric string** or **null**.
- weight: weight. The value is a **numeric string** or **null**.
- maxAMShare: Maximum App Master share. The value is a **numeric string** or **null**, where the number range is [0,1] or -1.

```
type YarnResource struct {
	Vcores *int `json:"vcores"`
	Memory *int `json:"memory"`
	Type *string `json:"type"` // The value can be percent or null. When the value is percent, it indicates the percentage used; otherwise, the absolute value used is indicated. The value can be percent only for maxResources and maxChildResources.
}
```

###### Capacity scheduler.
The key values are as follows:
- minimum-user-limit-percent: Minimum user capacity. The value is a **JSON string of the YarnResource type** or **null**, where the number range is [0,100].
- user-limit-factor: User resource factor. The value is a **JSON string of the YarnResource type** or **null**.
- maximum-applications: Maximum number of applications, that is, Max-Applications. The value is a **numeric string** or **null**, where the numbers must be positive integers.
- maximum-am-resource-percent: maximum AM percent. The value is a **numeric string** or **null**, where the number range is [0,1] or -1.
- default-application-priority: Resource pool priority. The value is a **numeric string** or **null**, where the numbers must be positive integers.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BasicParams: list of Item
        """
        self._ConfigSet = None
        self._LabelParams = None
        self._BasicParams = None

    @property
    def ConfigSet(self):
        r"""Configuration set name.
        :rtype: str
        """
        return self._ConfigSet

    @ConfigSet.setter
    def ConfigSet(self, ConfigSet):
        self._ConfigSet = ConfigSet

    @property
    def LabelParams(self):
        r"""The capacity scheduler will use it, where tag-related configuration is set. The key values are consistent with the fields returned by **DescribeYarnQueue**.
The key values are as follows:
- labelName: Tag name, that is, tags in tag management.
- capacity: Capacity. The value is a **numeric string**.
- maximum-capacity: Maximum capacity. The value is a **numeric string**.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ItemSeq
        """
        return self._LabelParams

    @LabelParams.setter
    def LabelParams(self, LabelParams):
        self._LabelParams = LabelParams

    @property
    def BasicParams(self):
        r"""Set parameters related to the configuration set. The key values are consistent with the fields returned by **DescribeYarnQueue**.
###### Fair scheduler.
The key values are as follows:
- minResources: Minimum resource amount. The value is a **JSON string of the YarnResource type** or **null**.
- maxResources: Maximum resource amount. The value is a **JSON string of the YarnResource type** or **null**.
- maxChildResources: Maximum resource amount for undeclared subqueues. The value is a **numeric string** or **null**.
- maxRunningApps: Maximum number of apps that can run concurrently. The value is a **numeric string** or **null**.
- weight: weight. The value is a **numeric string** or **null**.
- maxAMShare: Maximum App Master share. The value is a **numeric string** or **null**, where the number range is [0,1] or -1.

```
type YarnResource struct {
	Vcores *int `json:"vcores"`
	Memory *int `json:"memory"`
	Type *string `json:"type"` // The value can be percent or null. When the value is percent, it indicates the percentage used; otherwise, the absolute value used is indicated. The value can be percent only for maxResources and maxChildResources.
}
```

###### Capacity scheduler.
The key values are as follows:
- minimum-user-limit-percent: Minimum user capacity. The value is a **JSON string of the YarnResource type** or **null**, where the number range is [0,100].
- user-limit-factor: User resource factor. The value is a **JSON string of the YarnResource type** or **null**.
- maximum-applications: Maximum number of applications, that is, Max-Applications. The value is a **numeric string** or **null**, where the numbers must be positive integers.
- maximum-am-resource-percent: maximum AM percent. The value is a **numeric string** or **null**, where the number range is [0,1] or -1.
- default-application-priority: Resource pool priority. The value is a **numeric string** or **null**, where the numbers must be positive integers.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Item
        """
        return self._BasicParams

    @BasicParams.setter
    def BasicParams(self, BasicParams):
        self._BasicParams = BasicParams


    def _deserialize(self, params):
        self._ConfigSet = params.get("ConfigSet")
        if params.get("LabelParams") is not None:
            self._LabelParams = []
            for item in params.get("LabelParams"):
                obj = ItemSeq()
                obj._deserialize(item)
                self._LabelParams.append(obj)
        if params.get("BasicParams") is not None:
            self._BasicParams = []
            for item in params.get("BasicParams"):
                obj = Item()
                obj._deserialize(item)
                self._BasicParams.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigurationItem(AbstractModel):
    r"""Configuration item (configuration management page).

    """

    def __init__(self):
        r"""
        :param _Name: Configuration item name.
        :type Name: str
        :param _Value: Configuration item value.
        :type Value: str
        :param _InFile: Name of the configuration file where the configuration item is located.
        :type InFile: str
        """
        self._Name = None
        self._Value = None
        self._InFile = None

    @property
    def Name(self):
        r"""Configuration item name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""Configuration item value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def InFile(self):
        r"""Name of the configuration file where the configuration item is located.
        :rtype: str
        """
        return self._InFile

    @InFile.setter
    def InFile(self, InFile):
        self._InFile = InFile


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        self._InFile = params.get("InFile")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConvertPreToPostClusterRequest(AbstractModel):
    r"""ConvertPreToPostCluster request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ClientToken: Non-reentrant identifier (5-minute window). Order identifier.
        :type ClientToken: str
        """
        self._InstanceId = None
        self._ClientToken = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClientToken(self):
        r"""Non-reentrant identifier (5-minute window). Order identifier.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConvertPreToPostClusterResponse(AbstractModel):
    r"""ConvertPreToPostCluster response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClusterRequest(AbstractModel):
    r"""CreateCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ProductVersion: The EMR version, such as `EMR-V2.3.0` that indicates the version 2.3.0 of EMR. You can query the EMR version [here](https://intl.cloud.tencent.com/document/product/589/66338?from_cn_redirect=1).
        :type ProductVersion: str
        :param _EnableSupportHAFlag: Whether to enable high availability for nodes. Valid values:
<li>`true`: Enable</li>
<li>`false`: Disable</li>
        :type EnableSupportHAFlag: bool
        :param _InstanceName: The instance name.
<li>Length limit: 6-36 characters.</li>
<li>Can contain only Chinese characters, letters, digits, hyphens (-), and underscores (_).</li>
        :type InstanceName: str
        :param _InstanceChargeType: The instance billing mode. Valid values:
<li>`POSTPAID_BY_HOUR`: The postpaid mode by hour.</li>
        :type InstanceChargeType: str
        :param _LoginSettings: The instance login setting. This parameter allows you to set a login password or key for your purchased node.
<li>If a key is set, the password will be used for login to the native component WebUI only.</li>
<li>If no key is set, the password will be used for login to all purchased nodes and the native component WebUI.</li>
        :type LoginSettings: :class:`tencentcloud.emr.v20190103.models.LoginSettings`
        :param _SceneSoftwareConfig: The configuration of cluster application scenario and supported components.
        :type SceneSoftwareConfig: :class:`tencentcloud.emr.v20190103.models.SceneSoftwareConfig`
        :param _InstanceChargePrepaid: The details of the monthly subscription, including the instance period and auto-renewal. It is required if `InstanceChargeType` is `PREPAID`.
        :type InstanceChargePrepaid: :class:`tencentcloud.emr.v20190103.models.InstanceChargePrepaid`
        :param _SecurityGroupIds: The ID of the security group to which the instance belongs, in the format of `sg-xxxxxxxx`. You can call the [DescribeSecurityGroups](https://intl.cloud.tencent.com/document/api/215/15808?from_cn_redirect=1) API and obtain this parameter from the `SecurityGroupId` field in the response.
        :type SecurityGroupIds: list of str
        :param _ScriptBootstrapActionConfig: The [Bootstrap action](https://intl.cloud.tencent.com/document/product/589/35656?from_cn_redirect=1) script settings.
        :type ScriptBootstrapActionConfig: list of ScriptBootstrapActionConfig
        :param _ClientToken: Unique random identifier with the time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from repeatedly creating resources, for example, a9a90aa6-****-****-****-fae360632808.
        :type ClientToken: str
        :param _NeedMasterWan: Whether to enable public IP access for master nodes. Valid values:
<li>`NEED_MASTER_WAN`: Enable public IP for master nodes.</li>
<li>`NOT_NEED_MASTER_WAN`: Disable.</li>The public IP is enabled for master nodes by default.
        :type NeedMasterWan: str
        :param _EnableRemoteLoginFlag: Whether to enable remote login over the public network. It is invalid if `SecurityGroupId` is passed in. It is disabled by default. Valid values:
<li>`true`: Enable</li>
<li>`false`: Disable</li>
        :type EnableRemoteLoginFlag: bool
        :param _EnableKerberosFlag: Whether to enable Kerberos authentication. Valid values:
<li>`true`: Enable</li>
<li>`false` (default): Disable</li>
        :type EnableKerberosFlag: bool
        :param _CustomConf: [Custom software configuration](https://intl.cloud.tencent.com/document/product/589/35655?from_cn_redirect=1?from_cn_redirect=1)
        :type CustomConf: str
        :param _Tags: The tag description list. This parameter is used to bind a tag to a resource instance.
        :type Tags: list of Tag
        :param _DisasterRecoverGroupIds: The list of spread placement group IDs. Only one can be specified.
You can call the [DescribeDisasterRecoverGroups](https://intl.cloud.tencent.com/document/product/213/17810?from_cn_redirect=1) API and obtain this parameter from the `DisasterRecoverGroupId` field in the response.
        :type DisasterRecoverGroupIds: list of str
        :param _EnableCbsEncryptFlag: Whether to enable the cluster-level CBS encryption. Valid values:
<li>`true`: Enable</li>
<li>`false` (default): Disable</li>
        :type EnableCbsEncryptFlag: bool
        :param _MetaDBInfo: The metadatabase information. If `MetaType` is `EMR_NEW_META`, `MetaDataJdbcUrl`, `MetaDataUser`, `MetaDataPass`, and `UnifyMetaInstanceId` are not required.
If `MetaType` is `EMR_EXIT_META`, `UnifyMetaInstanceId` is required.
If `MetaType` is `USER_CUSTOM_META`, `MetaDataJdbcUrl`, `MetaDataUser`, and `MetaDataPass` are required.
        :type MetaDBInfo: :class:`tencentcloud.emr.v20190103.models.CustomMetaDBInfo`
        :param _DependService: The shared component information.
        :type DependService: list of DependService
        :param _ZoneResourceConfiguration: The node resource specs. A spec is specified for each AZ, with the first spec for the primary AZ, the second for the backup AZ, and the third for the arbitrator AZ. If the multi-AZ mode is not enabled, only one spec is required.
        :type ZoneResourceConfiguration: list of ZoneResourceConfiguration
        :param _CosBucket: COS bucket path, which is used when you create StarRocks compute-storage separation clusters.
        :type CosBucket: str
        :param _NodeMarks: Node identifier information: currently used only in Terraform.
        :type NodeMarks: list of NodeMark
        :param _LoadBalancerId: clb id
        :type LoadBalancerId: str
        """
        self._ProductVersion = None
        self._EnableSupportHAFlag = None
        self._InstanceName = None
        self._InstanceChargeType = None
        self._LoginSettings = None
        self._SceneSoftwareConfig = None
        self._InstanceChargePrepaid = None
        self._SecurityGroupIds = None
        self._ScriptBootstrapActionConfig = None
        self._ClientToken = None
        self._NeedMasterWan = None
        self._EnableRemoteLoginFlag = None
        self._EnableKerberosFlag = None
        self._CustomConf = None
        self._Tags = None
        self._DisasterRecoverGroupIds = None
        self._EnableCbsEncryptFlag = None
        self._MetaDBInfo = None
        self._DependService = None
        self._ZoneResourceConfiguration = None
        self._CosBucket = None
        self._NodeMarks = None
        self._LoadBalancerId = None

    @property
    def ProductVersion(self):
        r"""The EMR version, such as `EMR-V2.3.0` that indicates the version 2.3.0 of EMR. You can query the EMR version [here](https://intl.cloud.tencent.com/document/product/589/66338?from_cn_redirect=1).
        :rtype: str
        """
        return self._ProductVersion

    @ProductVersion.setter
    def ProductVersion(self, ProductVersion):
        self._ProductVersion = ProductVersion

    @property
    def EnableSupportHAFlag(self):
        r"""Whether to enable high availability for nodes. Valid values:
<li>`true`: Enable</li>
<li>`false`: Disable</li>
        :rtype: bool
        """
        return self._EnableSupportHAFlag

    @EnableSupportHAFlag.setter
    def EnableSupportHAFlag(self, EnableSupportHAFlag):
        self._EnableSupportHAFlag = EnableSupportHAFlag

    @property
    def InstanceName(self):
        r"""The instance name.
<li>Length limit: 6-36 characters.</li>
<li>Can contain only Chinese characters, letters, digits, hyphens (-), and underscores (_).</li>
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceChargeType(self):
        r"""The instance billing mode. Valid values:
<li>`POSTPAID_BY_HOUR`: The postpaid mode by hour.</li>
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def LoginSettings(self):
        r"""The instance login setting. This parameter allows you to set a login password or key for your purchased node.
<li>If a key is set, the password will be used for login to the native component WebUI only.</li>
<li>If no key is set, the password will be used for login to all purchased nodes and the native component WebUI.</li>
        :rtype: :class:`tencentcloud.emr.v20190103.models.LoginSettings`
        """
        return self._LoginSettings

    @LoginSettings.setter
    def LoginSettings(self, LoginSettings):
        self._LoginSettings = LoginSettings

    @property
    def SceneSoftwareConfig(self):
        r"""The configuration of cluster application scenario and supported components.
        :rtype: :class:`tencentcloud.emr.v20190103.models.SceneSoftwareConfig`
        """
        return self._SceneSoftwareConfig

    @SceneSoftwareConfig.setter
    def SceneSoftwareConfig(self, SceneSoftwareConfig):
        self._SceneSoftwareConfig = SceneSoftwareConfig

    @property
    def InstanceChargePrepaid(self):
        r"""The details of the monthly subscription, including the instance period and auto-renewal. It is required if `InstanceChargeType` is `PREPAID`.
        :rtype: :class:`tencentcloud.emr.v20190103.models.InstanceChargePrepaid`
        """
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid

    @property
    def SecurityGroupIds(self):
        r"""The ID of the security group to which the instance belongs, in the format of `sg-xxxxxxxx`. You can call the [DescribeSecurityGroups](https://intl.cloud.tencent.com/document/api/215/15808?from_cn_redirect=1) API and obtain this parameter from the `SecurityGroupId` field in the response.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def ScriptBootstrapActionConfig(self):
        r"""The [Bootstrap action](https://intl.cloud.tencent.com/document/product/589/35656?from_cn_redirect=1) script settings.
        :rtype: list of ScriptBootstrapActionConfig
        """
        return self._ScriptBootstrapActionConfig

    @ScriptBootstrapActionConfig.setter
    def ScriptBootstrapActionConfig(self, ScriptBootstrapActionConfig):
        self._ScriptBootstrapActionConfig = ScriptBootstrapActionConfig

    @property
    def ClientToken(self):
        r"""Unique random identifier with the time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from repeatedly creating resources, for example, a9a90aa6-****-****-****-fae360632808.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def NeedMasterWan(self):
        r"""Whether to enable public IP access for master nodes. Valid values:
<li>`NEED_MASTER_WAN`: Enable public IP for master nodes.</li>
<li>`NOT_NEED_MASTER_WAN`: Disable.</li>The public IP is enabled for master nodes by default.
        :rtype: str
        """
        return self._NeedMasterWan

    @NeedMasterWan.setter
    def NeedMasterWan(self, NeedMasterWan):
        self._NeedMasterWan = NeedMasterWan

    @property
    def EnableRemoteLoginFlag(self):
        r"""Whether to enable remote login over the public network. It is invalid if `SecurityGroupId` is passed in. It is disabled by default. Valid values:
<li>`true`: Enable</li>
<li>`false`: Disable</li>
        :rtype: bool
        """
        return self._EnableRemoteLoginFlag

    @EnableRemoteLoginFlag.setter
    def EnableRemoteLoginFlag(self, EnableRemoteLoginFlag):
        self._EnableRemoteLoginFlag = EnableRemoteLoginFlag

    @property
    def EnableKerberosFlag(self):
        r"""Whether to enable Kerberos authentication. Valid values:
<li>`true`: Enable</li>
<li>`false` (default): Disable</li>
        :rtype: bool
        """
        return self._EnableKerberosFlag

    @EnableKerberosFlag.setter
    def EnableKerberosFlag(self, EnableKerberosFlag):
        self._EnableKerberosFlag = EnableKerberosFlag

    @property
    def CustomConf(self):
        r"""[Custom software configuration](https://intl.cloud.tencent.com/document/product/589/35655?from_cn_redirect=1?from_cn_redirect=1)
        :rtype: str
        """
        return self._CustomConf

    @CustomConf.setter
    def CustomConf(self, CustomConf):
        self._CustomConf = CustomConf

    @property
    def Tags(self):
        r"""The tag description list. This parameter is used to bind a tag to a resource instance.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DisasterRecoverGroupIds(self):
        r"""The list of spread placement group IDs. Only one can be specified.
You can call the [DescribeDisasterRecoverGroups](https://intl.cloud.tencent.com/document/product/213/17810?from_cn_redirect=1) API and obtain this parameter from the `DisasterRecoverGroupId` field in the response.
        :rtype: list of str
        """
        return self._DisasterRecoverGroupIds

    @DisasterRecoverGroupIds.setter
    def DisasterRecoverGroupIds(self, DisasterRecoverGroupIds):
        self._DisasterRecoverGroupIds = DisasterRecoverGroupIds

    @property
    def EnableCbsEncryptFlag(self):
        r"""Whether to enable the cluster-level CBS encryption. Valid values:
<li>`true`: Enable</li>
<li>`false` (default): Disable</li>
        :rtype: bool
        """
        return self._EnableCbsEncryptFlag

    @EnableCbsEncryptFlag.setter
    def EnableCbsEncryptFlag(self, EnableCbsEncryptFlag):
        self._EnableCbsEncryptFlag = EnableCbsEncryptFlag

    @property
    def MetaDBInfo(self):
        r"""The metadatabase information. If `MetaType` is `EMR_NEW_META`, `MetaDataJdbcUrl`, `MetaDataUser`, `MetaDataPass`, and `UnifyMetaInstanceId` are not required.
If `MetaType` is `EMR_EXIT_META`, `UnifyMetaInstanceId` is required.
If `MetaType` is `USER_CUSTOM_META`, `MetaDataJdbcUrl`, `MetaDataUser`, and `MetaDataPass` are required.
        :rtype: :class:`tencentcloud.emr.v20190103.models.CustomMetaDBInfo`
        """
        return self._MetaDBInfo

    @MetaDBInfo.setter
    def MetaDBInfo(self, MetaDBInfo):
        self._MetaDBInfo = MetaDBInfo

    @property
    def DependService(self):
        r"""The shared component information.
        :rtype: list of DependService
        """
        return self._DependService

    @DependService.setter
    def DependService(self, DependService):
        self._DependService = DependService

    @property
    def ZoneResourceConfiguration(self):
        r"""The node resource specs. A spec is specified for each AZ, with the first spec for the primary AZ, the second for the backup AZ, and the third for the arbitrator AZ. If the multi-AZ mode is not enabled, only one spec is required.
        :rtype: list of ZoneResourceConfiguration
        """
        return self._ZoneResourceConfiguration

    @ZoneResourceConfiguration.setter
    def ZoneResourceConfiguration(self, ZoneResourceConfiguration):
        self._ZoneResourceConfiguration = ZoneResourceConfiguration

    @property
    def CosBucket(self):
        r"""COS bucket path, which is used when you create StarRocks compute-storage separation clusters.
        :rtype: str
        """
        return self._CosBucket

    @CosBucket.setter
    def CosBucket(self, CosBucket):
        self._CosBucket = CosBucket

    @property
    def NodeMarks(self):
        r"""Node identifier information: currently used only in Terraform.
        :rtype: list of NodeMark
        """
        return self._NodeMarks

    @NodeMarks.setter
    def NodeMarks(self, NodeMarks):
        self._NodeMarks = NodeMarks

    @property
    def LoadBalancerId(self):
        r"""clb id
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId


    def _deserialize(self, params):
        self._ProductVersion = params.get("ProductVersion")
        self._EnableSupportHAFlag = params.get("EnableSupportHAFlag")
        self._InstanceName = params.get("InstanceName")
        self._InstanceChargeType = params.get("InstanceChargeType")
        if params.get("LoginSettings") is not None:
            self._LoginSettings = LoginSettings()
            self._LoginSettings._deserialize(params.get("LoginSettings"))
        if params.get("SceneSoftwareConfig") is not None:
            self._SceneSoftwareConfig = SceneSoftwareConfig()
            self._SceneSoftwareConfig._deserialize(params.get("SceneSoftwareConfig"))
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("ScriptBootstrapActionConfig") is not None:
            self._ScriptBootstrapActionConfig = []
            for item in params.get("ScriptBootstrapActionConfig"):
                obj = ScriptBootstrapActionConfig()
                obj._deserialize(item)
                self._ScriptBootstrapActionConfig.append(obj)
        self._ClientToken = params.get("ClientToken")
        self._NeedMasterWan = params.get("NeedMasterWan")
        self._EnableRemoteLoginFlag = params.get("EnableRemoteLoginFlag")
        self._EnableKerberosFlag = params.get("EnableKerberosFlag")
        self._CustomConf = params.get("CustomConf")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._DisasterRecoverGroupIds = params.get("DisasterRecoverGroupIds")
        self._EnableCbsEncryptFlag = params.get("EnableCbsEncryptFlag")
        if params.get("MetaDBInfo") is not None:
            self._MetaDBInfo = CustomMetaDBInfo()
            self._MetaDBInfo._deserialize(params.get("MetaDBInfo"))
        if params.get("DependService") is not None:
            self._DependService = []
            for item in params.get("DependService"):
                obj = DependService()
                obj._deserialize(item)
                self._DependService.append(obj)
        if params.get("ZoneResourceConfiguration") is not None:
            self._ZoneResourceConfiguration = []
            for item in params.get("ZoneResourceConfiguration"):
                obj = ZoneResourceConfiguration()
                obj._deserialize(item)
                self._ZoneResourceConfiguration.append(obj)
        self._CosBucket = params.get("CosBucket")
        if params.get("NodeMarks") is not None:
            self._NodeMarks = []
            for item in params.get("NodeMarks"):
                obj = NodeMark()
                obj._deserialize(item)
                self._NodeMarks.append(obj)
        self._LoadBalancerId = params.get("LoadBalancerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterResponse(AbstractModel):
    r"""CreateCluster response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class CreateGroupsSTDRequest(AbstractModel):
    r"""CreateGroupsSTD request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster name.
        :type InstanceId: str
        :param _Groups: Batch user group information.
        :type Groups: list of GroupInfo
        """
        self._InstanceId = None
        self._Groups = None

    @property
    def InstanceId(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Groups(self):
        r"""Batch user group information.
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGroupsSTDResponse(AbstractModel):
    r"""CreateGroupsSTD response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Output result of each user group.
        :type Data: list of ResultItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""Output result of each user group.
        :rtype: list of ResultItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ResultItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class CreateInstanceRequest(AbstractModel):
    r"""CreateInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ProductId: Product ID. Different product IDs stand for different EMR product versions. Valid range:
51: STARROCKS-V1.4.0
54: STARROCKS-V2.0.0
27: KAFKA-V1.0.0
50: KAFKA-V2.0.0
16: EMR-V2.3.0
20: EMR-V2.5.0
30: EMR-V2.6.0
38: EMR-V2.7.0
25: EMR-V3.1.0
33: EMR-V3.2.1
34: EMR-V3.3.0
37: EMR-V3.4.0
44: EMR-V3.5.0
53: EMR-V3.6.0
        :type ProductId: int
        :param _Software: List of deployed components. The list of component options varies by EMR product ID (i.e., `ProductId`; for specific meanings, please see the `ProductId` input parameter). For more information, please see [Component Version](https://intl.cloud.tencent.com/document/product/589/20279?from_cn_redirect=1).
Enter an instance value: `hive` or `flink`.
        :type Software: list of str
        :param _SupportHA: Whether to enable high node availability. Valid values:
<li>0: does not enable high availability of node.</li>
<li>1: enables high availability of node.</li>
        :type SupportHA: int
        :param _InstanceName: Instance name.
<li>Length limit: 6-36 characters.</li>
<li>Only letters, numbers, dashes (-), and underscores (_) are supported.</li>
        :type InstanceName: str
        :param _PayMode: Instance billing mode. Valid values:
<li>0: pay-as-you-go.</li>
        :type PayMode: int
        :param _TimeSpan: Purchase duration of instance, which needs to be used together with `TimeUnit`.
<li>When `TimeUnit` is `s`, this parameter can only be filled with 3600, indicating a pay-as-you-go instance.</li>
<li>When `TimeUnit` is `m`, the number entered in this parameter indicates the purchase duration of the monthly-subscription instance; for example, 1 means one month</li>
        :type TimeSpan: int
        :param _TimeUnit: Time unit of instance purchase duration. Valid values:
<li>s: seconds. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
<li>m: month. When `PayMode` is 1, `TimeUnit` can only be `m`.</li>
        :type TimeUnit: str
        :param _LoginSettings: Instance login settings. This parameter allows you to set the login password or key for your purchased node.
<li>If the key is set, the password will be only used for login to the native component WebUI.</li>
<li>If the key is not set, the password will be used for login to all purchased nodes and the native component WebUI.</li>
        :type LoginSettings: :class:`tencentcloud.emr.v20190103.models.LoginSettings`
        :param _VPCSettings: Configuration information of VPC. This parameter is used to specify the VPC ID, subnet ID, etc.
        :type VPCSettings: :class:`tencentcloud.emr.v20190103.models.VPCSettings`
        :param _ResourceSpec: Node resource specification.
        :type ResourceSpec: :class:`tencentcloud.emr.v20190103.models.NewResourceSpec`
        :param _COSSettings: Parameter required for enabling COS access.
        :type COSSettings: :class:`tencentcloud.emr.v20190103.models.COSSettings`
        :param _Placement: Instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :type Placement: :class:`tencentcloud.emr.v20190103.models.Placement`
        :param _SgId: Security group to which an instance belongs in the format of `sg-xxxxxxxx`. This parameter can be obtained from the `SecurityGroupId` field in the return value of the [DescribeSecurityGroups](https://intl.cloud.tencent.com/document/api/215/15808) API.
        :type SgId: str
        :param _PreExecutedFileSettings: [Bootstrap action](https://intl.cloud.tencent.com/document/product/589/35656?from_cn_redirect=1) script settings
        :type PreExecutedFileSettings: list of PreExecuteFileSettings
        :param _AutoRenew: Whether auto-renewal is enabled. Valid values:
<li>0: auto-renewal not enabled.</li>
<li>1: auto-renewal enabled.</li>
        :type AutoRenew: int
        :param _ClientToken: Unique random identifier with the time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources again, for example, a9a90aa6-****-****-****-fae36063280.
        :type ClientToken: str
        :param _NeedMasterWan: Whether to enable public IP access for master node. Valid values:
<li>NEED_MASTER_WAN: enables public IP for master node.</li>
<li>NOT_NEED_MASTER_WAN: does not enable.</li>Public IP is enabled for master node by default.
        :type NeedMasterWan: str
        :param _RemoteLoginAtCreate: Whether to enable remote public network login, i.e., port 22. When `SgId` is not empty, this parameter does not take effect.
        :type RemoteLoginAtCreate: int
        :param _CheckSecurity: Whether to enable secure cluster. 0: no; other values: yes.
        :type CheckSecurity: int
        :param _ExtendFsField: Accesses to external file system.
        :type ExtendFsField: str
        :param _Tags: Tag description list. This parameter is used to bind a tag to a resource instance.
        :type Tags: list of Tag
        :param _DisasterRecoverGroupIds: List of spread placement group IDs. Only one can be specified currently.
This parameter can be obtained in the `SecurityGroupId` field in the return value of the [DescribeSecurityGroups](https://intl.cloud.tencent.com/document/product/213/15486?from_cn_redirect=1) API.
        :type DisasterRecoverGroupIds: list of str
        :param _CbsEncrypt: CBS disk encryption at the cluster level. 0: not encrypted, 1: encrypted
        :type CbsEncrypt: int
        :param _MetaType: Hive-shared metadatabase type. Valid values:
<li>EMR_DEFAULT_META: the cluster creates one by default.</li>
<li>EMR_EXIST_META: the cluster uses the specified EMR-MetaDB instance.</li>
<li>USER_CUSTOM_META: the cluster uses a custom MetaDB instance.</li>
        :type MetaType: str
        :param _UnifyMetaInstanceId: EMR-MetaDB instance
        :type UnifyMetaInstanceId: str
        :param _MetaDBInfo: Custom MetaDB instance information
        :type MetaDBInfo: :class:`tencentcloud.emr.v20190103.models.CustomMetaInfo`
        :param _ApplicationRole: Custom application role.
        :type ApplicationRole: str
        :param _SceneName: Scenario-based values:
Hadoop-Kudu
Hadoop-Zookeeper
Hadoop-Presto
Hadoop-Hbase
        :type SceneName: str
        :param _ExternalService: Shared component information
        :type ExternalService: list of ExternalService
        :param _VersionID: 
        :type VersionID: int
        :param _MultiZone: `true` indicates that the multi-AZ deployment mode is enabled. This parameter is available only in cluster creation and cannot be changed after setting.
        :type MultiZone: bool
        :param _MultiZoneSettings: Node resource specs. The actual number of AZs is set, with the first AZ as the primary AZ, the second as the backup AZ, and the third as the arbitrator AZ. If the multi-AZ mode is not enabled, set the value to `1`.
        :type MultiZoneSettings: list of MultiZoneSetting
        :param _CosBucket: COS bucket path, which is used when you create StarRocks compute-storage separation clusters.
        :type CosBucket: str
        :param _NodeMarks: Node identifier information: currently used only in Terraform.
        :type NodeMarks: list of NodeMark
        :param _LoadBalancerId: CLB id
        :type LoadBalancerId: str
        """
        self._ProductId = None
        self._Software = None
        self._SupportHA = None
        self._InstanceName = None
        self._PayMode = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._LoginSettings = None
        self._VPCSettings = None
        self._ResourceSpec = None
        self._COSSettings = None
        self._Placement = None
        self._SgId = None
        self._PreExecutedFileSettings = None
        self._AutoRenew = None
        self._ClientToken = None
        self._NeedMasterWan = None
        self._RemoteLoginAtCreate = None
        self._CheckSecurity = None
        self._ExtendFsField = None
        self._Tags = None
        self._DisasterRecoverGroupIds = None
        self._CbsEncrypt = None
        self._MetaType = None
        self._UnifyMetaInstanceId = None
        self._MetaDBInfo = None
        self._ApplicationRole = None
        self._SceneName = None
        self._ExternalService = None
        self._VersionID = None
        self._MultiZone = None
        self._MultiZoneSettings = None
        self._CosBucket = None
        self._NodeMarks = None
        self._LoadBalancerId = None

    @property
    def ProductId(self):
        r"""Product ID. Different product IDs stand for different EMR product versions. Valid range:
51: STARROCKS-V1.4.0
54: STARROCKS-V2.0.0
27: KAFKA-V1.0.0
50: KAFKA-V2.0.0
16: EMR-V2.3.0
20: EMR-V2.5.0
30: EMR-V2.6.0
38: EMR-V2.7.0
25: EMR-V3.1.0
33: EMR-V3.2.1
34: EMR-V3.3.0
37: EMR-V3.4.0
44: EMR-V3.5.0
53: EMR-V3.6.0
        :rtype: int
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def Software(self):
        r"""List of deployed components. The list of component options varies by EMR product ID (i.e., `ProductId`; for specific meanings, please see the `ProductId` input parameter). For more information, please see [Component Version](https://intl.cloud.tencent.com/document/product/589/20279?from_cn_redirect=1).
Enter an instance value: `hive` or `flink`.
        :rtype: list of str
        """
        return self._Software

    @Software.setter
    def Software(self, Software):
        self._Software = Software

    @property
    def SupportHA(self):
        r"""Whether to enable high node availability. Valid values:
<li>0: does not enable high availability of node.</li>
<li>1: enables high availability of node.</li>
        :rtype: int
        """
        return self._SupportHA

    @SupportHA.setter
    def SupportHA(self, SupportHA):
        self._SupportHA = SupportHA

    @property
    def InstanceName(self):
        r"""Instance name.
<li>Length limit: 6-36 characters.</li>
<li>Only letters, numbers, dashes (-), and underscores (_) are supported.</li>
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def PayMode(self):
        r"""Instance billing mode. Valid values:
<li>0: pay-as-you-go.</li>
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def TimeSpan(self):
        r"""Purchase duration of instance, which needs to be used together with `TimeUnit`.
<li>When `TimeUnit` is `s`, this parameter can only be filled with 3600, indicating a pay-as-you-go instance.</li>
<li>When `TimeUnit` is `m`, the number entered in this parameter indicates the purchase duration of the monthly-subscription instance; for example, 1 means one month</li>
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Time unit of instance purchase duration. Valid values:
<li>s: seconds. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
<li>m: month. When `PayMode` is 1, `TimeUnit` can only be `m`.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def LoginSettings(self):
        r"""Instance login settings. This parameter allows you to set the login password or key for your purchased node.
<li>If the key is set, the password will be only used for login to the native component WebUI.</li>
<li>If the key is not set, the password will be used for login to all purchased nodes and the native component WebUI.</li>
        :rtype: :class:`tencentcloud.emr.v20190103.models.LoginSettings`
        """
        return self._LoginSettings

    @LoginSettings.setter
    def LoginSettings(self, LoginSettings):
        self._LoginSettings = LoginSettings

    @property
    def VPCSettings(self):
        r"""Configuration information of VPC. This parameter is used to specify the VPC ID, subnet ID, etc.
        :rtype: :class:`tencentcloud.emr.v20190103.models.VPCSettings`
        """
        return self._VPCSettings

    @VPCSettings.setter
    def VPCSettings(self, VPCSettings):
        self._VPCSettings = VPCSettings

    @property
    def ResourceSpec(self):
        r"""Node resource specification.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NewResourceSpec`
        """
        return self._ResourceSpec

    @ResourceSpec.setter
    def ResourceSpec(self, ResourceSpec):
        self._ResourceSpec = ResourceSpec

    @property
    def COSSettings(self):
        r"""Parameter required for enabling COS access.
        :rtype: :class:`tencentcloud.emr.v20190103.models.COSSettings`
        """
        return self._COSSettings

    @COSSettings.setter
    def COSSettings(self, COSSettings):
        self._COSSettings = COSSettings

    @property
    def Placement(self):
        r"""Instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Placement`
        """
        return self._Placement

    @Placement.setter
    def Placement(self, Placement):
        self._Placement = Placement

    @property
    def SgId(self):
        r"""Security group to which an instance belongs in the format of `sg-xxxxxxxx`. This parameter can be obtained from the `SecurityGroupId` field in the return value of the [DescribeSecurityGroups](https://intl.cloud.tencent.com/document/api/215/15808) API.
        :rtype: str
        """
        return self._SgId

    @SgId.setter
    def SgId(self, SgId):
        self._SgId = SgId

    @property
    def PreExecutedFileSettings(self):
        r"""[Bootstrap action](https://intl.cloud.tencent.com/document/product/589/35656?from_cn_redirect=1) script settings
        :rtype: list of PreExecuteFileSettings
        """
        return self._PreExecutedFileSettings

    @PreExecutedFileSettings.setter
    def PreExecutedFileSettings(self, PreExecutedFileSettings):
        self._PreExecutedFileSettings = PreExecutedFileSettings

    @property
    def AutoRenew(self):
        r"""Whether auto-renewal is enabled. Valid values:
<li>0: auto-renewal not enabled.</li>
<li>1: auto-renewal enabled.</li>
        :rtype: int
        """
        return self._AutoRenew

    @AutoRenew.setter
    def AutoRenew(self, AutoRenew):
        self._AutoRenew = AutoRenew

    @property
    def ClientToken(self):
        r"""Unique random identifier with the time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources again, for example, a9a90aa6-****-****-****-fae36063280.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def NeedMasterWan(self):
        r"""Whether to enable public IP access for master node. Valid values:
<li>NEED_MASTER_WAN: enables public IP for master node.</li>
<li>NOT_NEED_MASTER_WAN: does not enable.</li>Public IP is enabled for master node by default.
        :rtype: str
        """
        return self._NeedMasterWan

    @NeedMasterWan.setter
    def NeedMasterWan(self, NeedMasterWan):
        self._NeedMasterWan = NeedMasterWan

    @property
    def RemoteLoginAtCreate(self):
        r"""Whether to enable remote public network login, i.e., port 22. When `SgId` is not empty, this parameter does not take effect.
        :rtype: int
        """
        return self._RemoteLoginAtCreate

    @RemoteLoginAtCreate.setter
    def RemoteLoginAtCreate(self, RemoteLoginAtCreate):
        self._RemoteLoginAtCreate = RemoteLoginAtCreate

    @property
    def CheckSecurity(self):
        r"""Whether to enable secure cluster. 0: no; other values: yes.
        :rtype: int
        """
        return self._CheckSecurity

    @CheckSecurity.setter
    def CheckSecurity(self, CheckSecurity):
        self._CheckSecurity = CheckSecurity

    @property
    def ExtendFsField(self):
        r"""Accesses to external file system.
        :rtype: str
        """
        return self._ExtendFsField

    @ExtendFsField.setter
    def ExtendFsField(self, ExtendFsField):
        self._ExtendFsField = ExtendFsField

    @property
    def Tags(self):
        r"""Tag description list. This parameter is used to bind a tag to a resource instance.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DisasterRecoverGroupIds(self):
        r"""List of spread placement group IDs. Only one can be specified currently.
This parameter can be obtained in the `SecurityGroupId` field in the return value of the [DescribeSecurityGroups](https://intl.cloud.tencent.com/document/product/213/15486?from_cn_redirect=1) API.
        :rtype: list of str
        """
        return self._DisasterRecoverGroupIds

    @DisasterRecoverGroupIds.setter
    def DisasterRecoverGroupIds(self, DisasterRecoverGroupIds):
        self._DisasterRecoverGroupIds = DisasterRecoverGroupIds

    @property
    def CbsEncrypt(self):
        r"""CBS disk encryption at the cluster level. 0: not encrypted, 1: encrypted
        :rtype: int
        """
        return self._CbsEncrypt

    @CbsEncrypt.setter
    def CbsEncrypt(self, CbsEncrypt):
        self._CbsEncrypt = CbsEncrypt

    @property
    def MetaType(self):
        r"""Hive-shared metadatabase type. Valid values:
<li>EMR_DEFAULT_META: the cluster creates one by default.</li>
<li>EMR_EXIST_META: the cluster uses the specified EMR-MetaDB instance.</li>
<li>USER_CUSTOM_META: the cluster uses a custom MetaDB instance.</li>
        :rtype: str
        """
        return self._MetaType

    @MetaType.setter
    def MetaType(self, MetaType):
        self._MetaType = MetaType

    @property
    def UnifyMetaInstanceId(self):
        r"""EMR-MetaDB instance
        :rtype: str
        """
        return self._UnifyMetaInstanceId

    @UnifyMetaInstanceId.setter
    def UnifyMetaInstanceId(self, UnifyMetaInstanceId):
        self._UnifyMetaInstanceId = UnifyMetaInstanceId

    @property
    def MetaDBInfo(self):
        r"""Custom MetaDB instance information
        :rtype: :class:`tencentcloud.emr.v20190103.models.CustomMetaInfo`
        """
        return self._MetaDBInfo

    @MetaDBInfo.setter
    def MetaDBInfo(self, MetaDBInfo):
        self._MetaDBInfo = MetaDBInfo

    @property
    def ApplicationRole(self):
        r"""Custom application role.
        :rtype: str
        """
        return self._ApplicationRole

    @ApplicationRole.setter
    def ApplicationRole(self, ApplicationRole):
        self._ApplicationRole = ApplicationRole

    @property
    def SceneName(self):
        r"""Scenario-based values:
Hadoop-Kudu
Hadoop-Zookeeper
Hadoop-Presto
Hadoop-Hbase
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def ExternalService(self):
        r"""Shared component information
        :rtype: list of ExternalService
        """
        return self._ExternalService

    @ExternalService.setter
    def ExternalService(self, ExternalService):
        self._ExternalService = ExternalService

    @property
    def VersionID(self):
        r"""
        :rtype: int
        """
        return self._VersionID

    @VersionID.setter
    def VersionID(self, VersionID):
        self._VersionID = VersionID

    @property
    def MultiZone(self):
        r"""`true` indicates that the multi-AZ deployment mode is enabled. This parameter is available only in cluster creation and cannot be changed after setting.
        :rtype: bool
        """
        return self._MultiZone

    @MultiZone.setter
    def MultiZone(self, MultiZone):
        self._MultiZone = MultiZone

    @property
    def MultiZoneSettings(self):
        r"""Node resource specs. The actual number of AZs is set, with the first AZ as the primary AZ, the second as the backup AZ, and the third as the arbitrator AZ. If the multi-AZ mode is not enabled, set the value to `1`.
        :rtype: list of MultiZoneSetting
        """
        return self._MultiZoneSettings

    @MultiZoneSettings.setter
    def MultiZoneSettings(self, MultiZoneSettings):
        self._MultiZoneSettings = MultiZoneSettings

    @property
    def CosBucket(self):
        r"""COS bucket path, which is used when you create StarRocks compute-storage separation clusters.
        :rtype: str
        """
        return self._CosBucket

    @CosBucket.setter
    def CosBucket(self, CosBucket):
        self._CosBucket = CosBucket

    @property
    def NodeMarks(self):
        r"""Node identifier information: currently used only in Terraform.
        :rtype: list of NodeMark
        """
        return self._NodeMarks

    @NodeMarks.setter
    def NodeMarks(self, NodeMarks):
        self._NodeMarks = NodeMarks

    @property
    def LoadBalancerId(self):
        r"""CLB id
        :rtype: str
        """
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId


    def _deserialize(self, params):
        self._ProductId = params.get("ProductId")
        self._Software = params.get("Software")
        self._SupportHA = params.get("SupportHA")
        self._InstanceName = params.get("InstanceName")
        self._PayMode = params.get("PayMode")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        if params.get("LoginSettings") is not None:
            self._LoginSettings = LoginSettings()
            self._LoginSettings._deserialize(params.get("LoginSettings"))
        if params.get("VPCSettings") is not None:
            self._VPCSettings = VPCSettings()
            self._VPCSettings._deserialize(params.get("VPCSettings"))
        if params.get("ResourceSpec") is not None:
            self._ResourceSpec = NewResourceSpec()
            self._ResourceSpec._deserialize(params.get("ResourceSpec"))
        if params.get("COSSettings") is not None:
            self._COSSettings = COSSettings()
            self._COSSettings._deserialize(params.get("COSSettings"))
        if params.get("Placement") is not None:
            self._Placement = Placement()
            self._Placement._deserialize(params.get("Placement"))
        self._SgId = params.get("SgId")
        if params.get("PreExecutedFileSettings") is not None:
            self._PreExecutedFileSettings = []
            for item in params.get("PreExecutedFileSettings"):
                obj = PreExecuteFileSettings()
                obj._deserialize(item)
                self._PreExecutedFileSettings.append(obj)
        self._AutoRenew = params.get("AutoRenew")
        self._ClientToken = params.get("ClientToken")
        self._NeedMasterWan = params.get("NeedMasterWan")
        self._RemoteLoginAtCreate = params.get("RemoteLoginAtCreate")
        self._CheckSecurity = params.get("CheckSecurity")
        self._ExtendFsField = params.get("ExtendFsField")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._DisasterRecoverGroupIds = params.get("DisasterRecoverGroupIds")
        self._CbsEncrypt = params.get("CbsEncrypt")
        self._MetaType = params.get("MetaType")
        self._UnifyMetaInstanceId = params.get("UnifyMetaInstanceId")
        if params.get("MetaDBInfo") is not None:
            self._MetaDBInfo = CustomMetaInfo()
            self._MetaDBInfo._deserialize(params.get("MetaDBInfo"))
        self._ApplicationRole = params.get("ApplicationRole")
        self._SceneName = params.get("SceneName")
        if params.get("ExternalService") is not None:
            self._ExternalService = []
            for item in params.get("ExternalService"):
                obj = ExternalService()
                obj._deserialize(item)
                self._ExternalService.append(obj)
        self._VersionID = params.get("VersionID")
        self._MultiZone = params.get("MultiZone")
        if params.get("MultiZoneSettings") is not None:
            self._MultiZoneSettings = []
            for item in params.get("MultiZoneSettings"):
                obj = MultiZoneSetting()
                obj._deserialize(item)
                self._MultiZoneSettings.append(obj)
        self._CosBucket = params.get("CosBucket")
        if params.get("NodeMarks") is not None:
            self._NodeMarks = []
            for item in params.get("NodeMarks"):
                obj = NodeMark()
                obj._deserialize(item)
                self._NodeMarks.append(obj)
        self._LoadBalancerId = params.get("LoadBalancerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInstanceResponse(AbstractModel):
    r"""CreateInstance response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class CreateSLInstanceRequest(AbstractModel):
    r"""CreateSLInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceName: Instance name.
        :type InstanceName: str
        :param _PayMode: Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go.
        :type PayMode: int
        :param _DiskType: Instance storage type. Fill in CLOUD_HSSD to represent high-performance cloud storage.
        :type DiskType: str
        :param _DiskSize: The disk capacity of a single node of the instance, in GB. The disk capacity of a single node should be greater than or equal to 100 and less than or equal to 250 x the number of CPU cores. The capacity adjustment step is 100.
        :type DiskSize: int
        :param _NodeType: Instance node specification. You can fill in 4C16G, 8C32G, 16C64G, or 32C128G, which is case-insensitive.
        :type NodeType: str
        :param _ZoneSettings: Detailed configuration of the instance AZ. Currently, multiple availability zones are supported. The number of AZs must be 1 or 3, including the region names, VPC information, and number of nodes. The total number of nodes across all zones must be greater than or equal to 3 and less than or equal to 50.
        :type ZoneSettings: list of ZoneSetting
        :param _Tags: List of tags to be bound to the instance.
        :type Tags: list of Tag
        :param _PrePaySetting: Prepaid parameter.
        :type PrePaySetting: :class:`tencentcloud.emr.v20190103.models.PrePaySetting`
        :param _ClientToken: The unique random identifier with a time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources repeatedly. For example: a9a90aa6-****-****-****-fae360632808.
        :type ClientToken: str
        :param _DeploymentMode: 
        :type DeploymentMode: str
        """
        self._InstanceName = None
        self._PayMode = None
        self._DiskType = None
        self._DiskSize = None
        self._NodeType = None
        self._ZoneSettings = None
        self._Tags = None
        self._PrePaySetting = None
        self._ClientToken = None
        self._DeploymentMode = None

    @property
    def InstanceName(self):
        r"""Instance name.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def PayMode(self):
        r"""Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def DiskType(self):
        r"""Instance storage type. Fill in CLOUD_HSSD to represent high-performance cloud storage.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DiskSize(self):
        r"""The disk capacity of a single node of the instance, in GB. The disk capacity of a single node should be greater than or equal to 100 and less than or equal to 250 x the number of CPU cores. The capacity adjustment step is 100.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def NodeType(self):
        r"""Instance node specification. You can fill in 4C16G, 8C32G, 16C64G, or 32C128G, which is case-insensitive.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def ZoneSettings(self):
        r"""Detailed configuration of the instance AZ. Currently, multiple availability zones are supported. The number of AZs must be 1 or 3, including the region names, VPC information, and number of nodes. The total number of nodes across all zones must be greater than or equal to 3 and less than or equal to 50.
        :rtype: list of ZoneSetting
        """
        return self._ZoneSettings

    @ZoneSettings.setter
    def ZoneSettings(self, ZoneSettings):
        self._ZoneSettings = ZoneSettings

    @property
    def Tags(self):
        r"""List of tags to be bound to the instance.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def PrePaySetting(self):
        r"""Prepaid parameter.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PrePaySetting`
        """
        return self._PrePaySetting

    @PrePaySetting.setter
    def PrePaySetting(self, PrePaySetting):
        self._PrePaySetting = PrePaySetting

    @property
    def ClientToken(self):
        r"""The unique random identifier with a time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources repeatedly. For example: a9a90aa6-****-****-****-fae360632808.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def DeploymentMode(self):
        r"""
        :rtype: str
        """
        return self._DeploymentMode

    @DeploymentMode.setter
    def DeploymentMode(self, DeploymentMode):
        self._DeploymentMode = DeploymentMode


    def _deserialize(self, params):
        self._InstanceName = params.get("InstanceName")
        self._PayMode = params.get("PayMode")
        self._DiskType = params.get("DiskType")
        self._DiskSize = params.get("DiskSize")
        self._NodeType = params.get("NodeType")
        if params.get("ZoneSettings") is not None:
            self._ZoneSettings = []
            for item in params.get("ZoneSettings"):
                obj = ZoneSetting()
                obj._deserialize(item)
                self._ZoneSettings.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("PrePaySetting") is not None:
            self._PrePaySetting = PrePaySetting()
            self._PrePaySetting._deserialize(params.get("PrePaySetting"))
        self._ClientToken = params.get("ClientToken")
        self._DeploymentMode = params.get("DeploymentMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSLInstanceResponse(AbstractModel):
    r"""CreateSLInstance response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance unique identifier (string).
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance unique identifier (string).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class CustomMetaDBInfo(AbstractModel):
    r"""The user-created Hive-MetaDB instance information.

    """

    def __init__(self):
        r"""
        :param _MetaDataJdbcUrl: The JDBC URL of the custom metadatabase instance. Example: jdbc:mysql://10.10.10.10:3306/dbname
        :type MetaDataJdbcUrl: str
        :param _MetaDataUser: The custom metadatabase instance username.
        :type MetaDataUser: str
        :param _MetaDataPass: The custom metadatabase instance password.
        :type MetaDataPass: str
        :param _MetaType: The Hive-shared metadatabase type. Valid values:
<li>`EMR_DEFAULT_META`: The cluster creates one by default.</li>
<li>`EMR_EXIST_META`: The cluster uses the specified EMR metadatabase instance.</li>
<li>`USER_CUSTOM_META`: The cluster uses a custom metadatabase instance.</li>
        :type MetaType: str
        :param _UnifyMetaInstanceId: The EMR-MetaDB instance.
        :type UnifyMetaInstanceId: str
        """
        self._MetaDataJdbcUrl = None
        self._MetaDataUser = None
        self._MetaDataPass = None
        self._MetaType = None
        self._UnifyMetaInstanceId = None

    @property
    def MetaDataJdbcUrl(self):
        r"""The JDBC URL of the custom metadatabase instance. Example: jdbc:mysql://10.10.10.10:3306/dbname
        :rtype: str
        """
        return self._MetaDataJdbcUrl

    @MetaDataJdbcUrl.setter
    def MetaDataJdbcUrl(self, MetaDataJdbcUrl):
        self._MetaDataJdbcUrl = MetaDataJdbcUrl

    @property
    def MetaDataUser(self):
        r"""The custom metadatabase instance username.
        :rtype: str
        """
        return self._MetaDataUser

    @MetaDataUser.setter
    def MetaDataUser(self, MetaDataUser):
        self._MetaDataUser = MetaDataUser

    @property
    def MetaDataPass(self):
        r"""The custom metadatabase instance password.
        :rtype: str
        """
        return self._MetaDataPass

    @MetaDataPass.setter
    def MetaDataPass(self, MetaDataPass):
        self._MetaDataPass = MetaDataPass

    @property
    def MetaType(self):
        r"""The Hive-shared metadatabase type. Valid values:
<li>`EMR_DEFAULT_META`: The cluster creates one by default.</li>
<li>`EMR_EXIST_META`: The cluster uses the specified EMR metadatabase instance.</li>
<li>`USER_CUSTOM_META`: The cluster uses a custom metadatabase instance.</li>
        :rtype: str
        """
        return self._MetaType

    @MetaType.setter
    def MetaType(self, MetaType):
        self._MetaType = MetaType

    @property
    def UnifyMetaInstanceId(self):
        r"""The EMR-MetaDB instance.
        :rtype: str
        """
        return self._UnifyMetaInstanceId

    @UnifyMetaInstanceId.setter
    def UnifyMetaInstanceId(self, UnifyMetaInstanceId):
        self._UnifyMetaInstanceId = UnifyMetaInstanceId


    def _deserialize(self, params):
        self._MetaDataJdbcUrl = params.get("MetaDataJdbcUrl")
        self._MetaDataUser = params.get("MetaDataUser")
        self._MetaDataPass = params.get("MetaDataPass")
        self._MetaType = params.get("MetaType")
        self._UnifyMetaInstanceId = params.get("UnifyMetaInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomMetaInfo(AbstractModel):
    r"""User-created Hive-MetaDB instance information

    """

    def __init__(self):
        r"""
        :param _MetaDataJdbcUrl: JDBC connection to custom MetaDB instance beginning with `jdbc:mysql://`
        :type MetaDataJdbcUrl: str
        :param _MetaDataUser: Custom MetaDB instance username
        :type MetaDataUser: str
        :param _MetaDataPass: Custom MetaDB instance password
        :type MetaDataPass: str
        """
        self._MetaDataJdbcUrl = None
        self._MetaDataUser = None
        self._MetaDataPass = None

    @property
    def MetaDataJdbcUrl(self):
        r"""JDBC connection to custom MetaDB instance beginning with `jdbc:mysql://`
        :rtype: str
        """
        return self._MetaDataJdbcUrl

    @MetaDataJdbcUrl.setter
    def MetaDataJdbcUrl(self, MetaDataJdbcUrl):
        self._MetaDataJdbcUrl = MetaDataJdbcUrl

    @property
    def MetaDataUser(self):
        r"""Custom MetaDB instance username
        :rtype: str
        """
        return self._MetaDataUser

    @MetaDataUser.setter
    def MetaDataUser(self, MetaDataUser):
        self._MetaDataUser = MetaDataUser

    @property
    def MetaDataPass(self):
        r"""Custom MetaDB instance password
        :rtype: str
        """
        return self._MetaDataPass

    @MetaDataPass.setter
    def MetaDataPass(self, MetaDataPass):
        self._MetaDataPass = MetaDataPass


    def _deserialize(self, params):
        self._MetaDataJdbcUrl = params.get("MetaDataJdbcUrl")
        self._MetaDataUser = params.get("MetaDataUser")
        self._MetaDataPass = params.get("MetaDataPass")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomServiceDefine(AbstractModel):
    r"""Shared self-built component parameters

    """

    def __init__(self):
        r"""
        :param _Name: Custom parameter key
        :type Name: str
        :param _Value: Custom parameter value
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        r"""Custom parameter key
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""Custom parameter value
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DAGInfo(AbstractModel):
    r"""DAG information.

    """

    def __init__(self):
        r"""
        :param _ID: Query ID.
        :type ID: str
        :param _Type: DAG type. Only StarRocks is supported currently.
        :type Type: str
        :param _Content: Returned JSON string of the DAG.
        :type Content: str
        """
        self._ID = None
        self._Type = None
        self._Content = None

    @property
    def ID(self):
        r"""Query ID.
        :rtype: str
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Type(self):
        r"""DAG type. Only StarRocks is supported currently.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Content(self):
        r"""Returned JSON string of the DAG.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._ID = params.get("ID")
        self._Type = params.get("Type")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DayRepeatStrategy(AbstractModel):
    r"""Description of daily repeated tasks for elastic scaling

    """

    def __init__(self):
        r"""
        :param _ExecuteAtTimeOfDay: Specific time for repetition task execution, such as 01:02:00.
        :type ExecuteAtTimeOfDay: str
        :param _Step: Executing every Step days.
        :type Step: int
        """
        self._ExecuteAtTimeOfDay = None
        self._Step = None

    @property
    def ExecuteAtTimeOfDay(self):
        r"""Specific time for repetition task execution, such as 01:02:00.
        :rtype: str
        """
        return self._ExecuteAtTimeOfDay

    @ExecuteAtTimeOfDay.setter
    def ExecuteAtTimeOfDay(self, ExecuteAtTimeOfDay):
        self._ExecuteAtTimeOfDay = ExecuteAtTimeOfDay

    @property
    def Step(self):
        r"""Executing every Step days.
        :rtype: int
        """
        return self._Step

    @Step.setter
    def Step(self, Step):
        self._Step = Step


    def _deserialize(self, params):
        self._ExecuteAtTimeOfDay = params.get("ExecuteAtTimeOfDay")
        self._Step = params.get("Step")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultSetting(AbstractModel):
    r"""Default configurations of resource scheduling.

    """

    def __init__(self):
        r"""
        :param _Name: Name: the key for input parameters.
        :type Name: str
        :param _Desc: Description.
        :type Desc: str
        :param _Prompt: Prompt.
        :type Prompt: str
        :param _Key: Key: display the configuration item in the configuration file.
        :type Key: str
        :param _Value: Name value.
        :type Value: str
        """
        self._Name = None
        self._Desc = None
        self._Prompt = None
        self._Key = None
        self._Value = None

    @property
    def Name(self):
        r"""Name: the key for input parameters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        r"""Description.
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Prompt(self):
        r"""Prompt.
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def Key(self):
        r"""Key: display the configuration item in the configuration file.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Name value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Prompt = params.get("Prompt")
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAutoScaleStrategyRequest(AbstractModel):
    r"""DeleteAutoScaleStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _StrategyType: Automatic scaling rule type. 1: Scaling by load metrics; 2: Scaling by time rules.
        :type StrategyType: int
        :param _StrategyId: Rule ID.
        :type StrategyId: int
        :param _GroupId: Scaling group ID.
        :type GroupId: int
        """
        self._InstanceId = None
        self._StrategyType = None
        self._StrategyId = None
        self._GroupId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StrategyType(self):
        r"""Automatic scaling rule type. 1: Scaling by load metrics; 2: Scaling by time rules.
        :rtype: int
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def StrategyId(self):
        r"""Rule ID.
        :rtype: int
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def GroupId(self):
        r"""Scaling group ID.
        :rtype: int
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StrategyType = params.get("StrategyType")
        self._StrategyId = params.get("StrategyId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAutoScaleStrategyResponse(AbstractModel):
    r"""DeleteAutoScaleStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteGroupsSTDRequest(AbstractModel):
    r"""DeleteGroupsSTD request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster name.
        :type InstanceId: str
        :param _GroupNames: User group name array.
        :type GroupNames: list of str
        """
        self._InstanceId = None
        self._GroupNames = None

    @property
    def InstanceId(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def GroupNames(self):
        r"""User group name array.
        :rtype: list of str
        """
        return self._GroupNames

    @GroupNames.setter
    def GroupNames(self, GroupNames):
        self._GroupNames = GroupNames


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._GroupNames = params.get("GroupNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGroupsSTDResponse(AbstractModel):
    r"""DeleteGroupsSTD response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Deleting returned results.
        :type Data: list of ResultItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""Deleting returned results.
        :rtype: list of ResultItem
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ResultItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteNodeResourceConfigRequest(AbstractModel):
    r"""DeleteNodeResourceConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ResourceConfigId: Node configuration ID.
        :type ResourceConfigId: int
        :param _ResourceType: Node type: CORE, TASK, and ROUTER.
        :type ResourceType: str
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        """
        self._InstanceId = None
        self._ResourceConfigId = None
        self._ResourceType = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceConfigId(self):
        r"""Node configuration ID.
        :rtype: int
        """
        return self._ResourceConfigId

    @ResourceConfigId.setter
    def ResourceConfigId(self, ResourceConfigId):
        self._ResourceConfigId = ResourceConfigId

    @property
    def ResourceType(self):
        r"""Node type: CORE, TASK, and ROUTER.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ResourceConfigId = params.get("ResourceConfigId")
        self._ResourceType = params.get("ResourceType")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNodeResourceConfigResponse(AbstractModel):
    r"""DeleteNodeResourceConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DependService(AbstractModel):
    r"""Shared component information

    """

    def __init__(self):
        r"""
        :param _ServiceName: The shared component name.
        :type ServiceName: str
        :param _InstanceId: The cluster to which the shared component belongs.
        :type InstanceId: str
        """
        self._ServiceName = None
        self._InstanceId = None

    @property
    def ServiceName(self):
        r"""The shared component name.
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def InstanceId(self):
        r"""The cluster to which the shared component belongs.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._ServiceName = params.get("ServiceName")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployYarnConfRequest(AbstractModel):
    r"""DeployYarnConf request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: English ID of the EMR cluster.
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""English ID of the EMR cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeployYarnConfResponse(AbstractModel):
    r"""DeployYarnConf response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Process ID after the process is started. You can use the [DescribeClusterFlowStatusDetail](https://intl.cloud.tencent.com/document/product/589/107224?from_cn_redirect=1) API to obtain the process status.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Process ID after the process is started. You can use the [DescribeClusterFlowStatusDetail](https://intl.cloud.tencent.com/document/product/589/107224?from_cn_redirect=1) API to obtain the process status.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class DescribeAutoScaleGroupGlobalConfRequest(AbstractModel):
    r"""DescribeAutoScaleGroupGlobalConf request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoScaleGroupGlobalConfResponse(AbstractModel):
    r"""DescribeAutoScaleGroupGlobalConf response structure.

    """

    def __init__(self):
        r"""
        :param _GroupGlobalConfs: Global information of all scaling groups in the cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupGlobalConfs: list of GroupGlobalConfs
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupGlobalConfs = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def GroupGlobalConfs(self):
        r"""Global information of all scaling groups in the cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of GroupGlobalConfs
        """
        return self._GroupGlobalConfs

    @GroupGlobalConfs.setter
    def GroupGlobalConfs(self, GroupGlobalConfs):
        self._GroupGlobalConfs = GroupGlobalConfs

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupGlobalConfs") is not None:
            self._GroupGlobalConfs = []
            for item in params.get("GroupGlobalConfs"):
                obj = GroupGlobalConfs()
                obj._deserialize(item)
                self._GroupGlobalConfs.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoScaleRecordsRequest(AbstractModel):
    r"""DescribeAutoScaleRecords request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The instance ID.
        :type InstanceId: str
        :param _Filters: Record filter parameter, which can only be "StartTime", "EndTime", "StrategyName", "ActionStatus", or "ScaleAction".
Time format. Either 2006-01-02 15:04:05 or 2006/01/02 15:04:05 for StartTime and EndTime.
ActionStatus: 0 (INITED), 1 (SUCCESS), 2 (FAILED), 3 (LIMITED_SUCCESSED), 4 (IN_PROCESS), 5 (IN_RETRY).
ScaleAction: 1 (scale out), 2 (scale in).

        :type Filters: list of KeyValue
        :param _Offset: Pagination parameters.
        :type Offset: int
        :param _Limit: Pagination parameters. Maximum value: 100
        :type Limit: int
        :param _RecordSource: Whether it is automatic scaling (0) or managed scaling (1)
        :type RecordSource: int
        :param _Asc: Ascending or not. 1: ascending, 0: descending.
        :type Asc: int
        """
        self._InstanceId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._RecordSource = None
        self._Asc = None

    @property
    def InstanceId(self):
        r"""The instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Filters(self):
        r"""Record filter parameter, which can only be "StartTime", "EndTime", "StrategyName", "ActionStatus", or "ScaleAction".
Time format. Either 2006-01-02 15:04:05 or 2006/01/02 15:04:05 for StartTime and EndTime.
ActionStatus: 0 (INITED), 1 (SUCCESS), 2 (FAILED), 3 (LIMITED_SUCCESSED), 4 (IN_PROCESS), 5 (IN_RETRY).
ScaleAction: 1 (scale out), 2 (scale in).

        :rtype: list of KeyValue
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Pagination parameters.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination parameters. Maximum value: 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RecordSource(self):
        r"""Whether it is automatic scaling (0) or managed scaling (1)
        :rtype: int
        """
        return self._RecordSource

    @RecordSource.setter
    def RecordSource(self, RecordSource):
        self._RecordSource = RecordSource

    @property
    def Asc(self):
        r"""Ascending or not. 1: ascending, 0: descending.
        :rtype: int
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = KeyValue()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._RecordSource = params.get("RecordSource")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoScaleRecordsResponse(AbstractModel):
    r"""DescribeAutoScaleRecords response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total scale-in and scale-out records.
        :type TotalCount: int
        :param _RecordList: Record list.
        :type RecordList: list of AutoScaleRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RecordList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total scale-in and scale-out records.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RecordList(self):
        r"""Record list.
        :rtype: list of AutoScaleRecord
        """
        return self._RecordList

    @RecordList.setter
    def RecordList(self, RecordList):
        self._RecordList = RecordList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RecordList") is not None:
            self._RecordList = []
            for item in params.get("RecordList"):
                obj = AutoScaleRecord()
                obj._deserialize(item)
                self._RecordList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAutoScaleStrategiesRequest(AbstractModel):
    r"""DescribeAutoScaleStrategies request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _GroupId: Scaling group ID.
        :type GroupId: int
        """
        self._InstanceId = None
        self._GroupId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def GroupId(self):
        r"""Scaling group ID.
        :rtype: int
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoScaleStrategiesResponse(AbstractModel):
    r"""DescribeAutoScaleStrategies response structure.

    """

    def __init__(self):
        r"""
        :param _LoadAutoScaleStrategies: Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadAutoScaleStrategies: list of LoadAutoScaleStrategy
        :param _TimeBasedAutoScaleStrategies: Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeBasedAutoScaleStrategies: list of TimeAutoScaleStrategy
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LoadAutoScaleStrategies = None
        self._TimeBasedAutoScaleStrategies = None
        self._RequestId = None

    @property
    def LoadAutoScaleStrategies(self):
        r"""Load-based scaling rules

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of LoadAutoScaleStrategy
        """
        return self._LoadAutoScaleStrategies

    @LoadAutoScaleStrategies.setter
    def LoadAutoScaleStrategies(self, LoadAutoScaleStrategies):
        self._LoadAutoScaleStrategies = LoadAutoScaleStrategies

    @property
    def TimeBasedAutoScaleStrategies(self):
        r"""Scaling rules by time

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TimeAutoScaleStrategy
        """
        return self._TimeBasedAutoScaleStrategies

    @TimeBasedAutoScaleStrategies.setter
    def TimeBasedAutoScaleStrategies(self, TimeBasedAutoScaleStrategies):
        self._TimeBasedAutoScaleStrategies = TimeBasedAutoScaleStrategies

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LoadAutoScaleStrategies") is not None:
            self._LoadAutoScaleStrategies = []
            for item in params.get("LoadAutoScaleStrategies"):
                obj = LoadAutoScaleStrategy()
                obj._deserialize(item)
                self._LoadAutoScaleStrategies.append(obj)
        if params.get("TimeBasedAutoScaleStrategies") is not None:
            self._TimeBasedAutoScaleStrategies = []
            for item in params.get("TimeBasedAutoScaleStrategies"):
                obj = TimeAutoScaleStrategy()
                obj._deserialize(item)
                self._TimeBasedAutoScaleStrategies.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterFlowStatusDetailRequest(AbstractModel):
    r"""DescribeClusterFlowStatusDetail request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: EMR instance ID
        :type InstanceId: str
        :param _FlowParam: Process-related parameters.
        :type FlowParam: :class:`tencentcloud.emr.v20190103.models.FlowParam`
        :param _NeedExtraDetail: Whether to return additional task information.
The default value is false.
        :type NeedExtraDetail: bool
        """
        self._InstanceId = None
        self._FlowParam = None
        self._NeedExtraDetail = None

    @property
    def InstanceId(self):
        r"""EMR instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def FlowParam(self):
        r"""Process-related parameters.
        :rtype: :class:`tencentcloud.emr.v20190103.models.FlowParam`
        """
        return self._FlowParam

    @FlowParam.setter
    def FlowParam(self, FlowParam):
        self._FlowParam = FlowParam

    @property
    def NeedExtraDetail(self):
        r"""Whether to return additional task information.
The default value is false.
        :rtype: bool
        """
        return self._NeedExtraDetail

    @NeedExtraDetail.setter
    def NeedExtraDetail(self, NeedExtraDetail):
        self._NeedExtraDetail = NeedExtraDetail


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("FlowParam") is not None:
            self._FlowParam = FlowParam()
            self._FlowParam._deserialize(params.get("FlowParam"))
        self._NeedExtraDetail = params.get("NeedExtraDetail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterFlowStatusDetailResponse(AbstractModel):
    r"""DescribeClusterFlowStatusDetail response structure.

    """

    def __init__(self):
        r"""
        :param _StageDetails: Task step details

Note: This field may return null, indicating that no valid values can be obtained.
        :type StageDetails: list of StageInfoDetail
        :param _FlowDesc: Task parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FlowDesc: list of FlowParamsDesc
        :param _FlowName: Task name.
        :type FlowName: str
        :param _FlowTotalProgress: Overall task flow progress.
Example: 0.8.
        :type FlowTotalProgress: float
        :param _FlowTotalStatus: Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked.
        :type FlowTotalStatus: int
        :param _FlowExtraDetail: Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FlowExtraDetail: list of FlowExtraDetail
        :param _FlowInfo: Flow description.
        :type FlowInfo: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StageDetails = None
        self._FlowDesc = None
        self._FlowName = None
        self._FlowTotalProgress = None
        self._FlowTotalStatus = None
        self._FlowExtraDetail = None
        self._FlowInfo = None
        self._RequestId = None

    @property
    def StageDetails(self):
        r"""Task step details

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of StageInfoDetail
        """
        return self._StageDetails

    @StageDetails.setter
    def StageDetails(self, StageDetails):
        self._StageDetails = StageDetails

    @property
    def FlowDesc(self):
        r"""Task parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of FlowParamsDesc
        """
        return self._FlowDesc

    @FlowDesc.setter
    def FlowDesc(self, FlowDesc):
        self._FlowDesc = FlowDesc

    @property
    def FlowName(self):
        r"""Task name.
        :rtype: str
        """
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def FlowTotalProgress(self):
        r"""Overall task flow progress.
Example: 0.8.
        :rtype: float
        """
        return self._FlowTotalProgress

    @FlowTotalProgress.setter
    def FlowTotalProgress(self, FlowTotalProgress):
        self._FlowTotalProgress = FlowTotalProgress

    @property
    def FlowTotalStatus(self):
        r"""Overall process status definition.
0: initializing.
1: running.
2: completed.
3: completed (with skipped steps).
-1: failed.
-3: blocked.
        :rtype: int
        """
        return self._FlowTotalStatus

    @FlowTotalStatus.setter
    def FlowTotalStatus(self, FlowTotalStatus):
        self._FlowTotalStatus = FlowTotalStatus

    @property
    def FlowExtraDetail(self):
        r"""Additional process information.
This parameter is returned when NeedExtraDetail is true.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of FlowExtraDetail
        """
        return self._FlowExtraDetail

    @FlowExtraDetail.setter
    def FlowExtraDetail(self, FlowExtraDetail):
        self._FlowExtraDetail = FlowExtraDetail

    @property
    def FlowInfo(self):
        r"""Flow description.
        :rtype: str
        """
        return self._FlowInfo

    @FlowInfo.setter
    def FlowInfo(self, FlowInfo):
        self._FlowInfo = FlowInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StageDetails") is not None:
            self._StageDetails = []
            for item in params.get("StageDetails"):
                obj = StageInfoDetail()
                obj._deserialize(item)
                self._StageDetails.append(obj)
        if params.get("FlowDesc") is not None:
            self._FlowDesc = []
            for item in params.get("FlowDesc"):
                obj = FlowParamsDesc()
                obj._deserialize(item)
                self._FlowDesc.append(obj)
        self._FlowName = params.get("FlowName")
        self._FlowTotalProgress = params.get("FlowTotalProgress")
        self._FlowTotalStatus = params.get("FlowTotalStatus")
        if params.get("FlowExtraDetail") is not None:
            self._FlowExtraDetail = []
            for item in params.get("FlowExtraDetail"):
                obj = FlowExtraDetail()
                obj._deserialize(item)
                self._FlowExtraDetail.append(obj)
        self._FlowInfo = params.get("FlowInfo")
        self._RequestId = params.get("RequestId")


class DescribeClusterNodesRequest(AbstractModel):
    r"""DescribeClusterNodes request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID in the format of emr-xxxxxxxx
        :type InstanceId: str
        :param _NodeFlag: Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors.
        :type NodeFlag: str
        :param _ExportDb: Whether to carry CDB information when all node information is exported in CSV format.
        :type ExportDb: bool
        :param _Offset: Page number. Default value: 0, indicating the first page.
        :type Offset: int
        :param _Limit: Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned.
        :type Limit: int
        :param _HardwareResourceType: Resource type. Valid values: all, host, pod. Default value: all
        :type HardwareResourceType: str
        :param _SearchFields: Searchable field
        :type SearchFields: list of SearchItem
        :param _OrderField: Order field.
        :type OrderField: str
        :param _Asc: Ascending or not. 1: ascending; 0: descending.
        :type Asc: int
        """
        self._InstanceId = None
        self._NodeFlag = None
        self._ExportDb = None
        self._Offset = None
        self._Limit = None
        self._HardwareResourceType = None
        self._SearchFields = None
        self._OrderField = None
        self._Asc = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID in the format of emr-xxxxxxxx
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def NodeFlag(self):
        r"""Node flag. Valid values:
<li>all: gets the information of nodes in all types except TencentDB information.</li>
<li>master: gets master node information.</li>
<li>core: gets core node information.</li>
<li>task: gets task node information.</li>
<li>common: gets common node information.</li>
<li>router: gets router node information.</li>
<li>db: gets TencentDB information in normal status.</li>
Note: only the above values are supported for the time being. Entering other values will cause errors.
        :rtype: str
        """
        return self._NodeFlag

    @NodeFlag.setter
    def NodeFlag(self, NodeFlag):
        self._NodeFlag = NodeFlag

    @property
    def ExportDb(self):
        r"""Whether to carry CDB information when all node information is exported in CSV format.
        :rtype: bool
        """
        return self._ExportDb

    @ExportDb.setter
    def ExportDb(self, ExportDb):
        self._ExportDb = ExportDb

    @property
    def Offset(self):
        r"""Page number. Default value: 0, indicating the first page.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both offset and limit are not set, or both are set to 0, all data will be returned.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def HardwareResourceType(self):
        r"""Resource type. Valid values: all, host, pod. Default value: all
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType

    @property
    def SearchFields(self):
        r"""Searchable field
        :rtype: list of SearchItem
        """
        return self._SearchFields

    @SearchFields.setter
    def SearchFields(self, SearchFields):
        self._SearchFields = SearchFields

    @property
    def OrderField(self):
        r"""Order field.
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Asc(self):
        r"""Ascending or not. 1: ascending; 0: descending.
        :rtype: int
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._NodeFlag = params.get("NodeFlag")
        self._ExportDb = params.get("ExportDb")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._HardwareResourceType = params.get("HardwareResourceType")
        if params.get("SearchFields") is not None:
            self._SearchFields = []
            for item in params.get("SearchFields"):
                obj = SearchItem()
                obj._deserialize(item)
                self._SearchFields.append(obj)
        self._OrderField = params.get("OrderField")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterNodesResponse(AbstractModel):
    r"""DescribeClusterNodes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCnt: Total number of queried nodes
        :type TotalCnt: int
        :param _NodeList: List of node details
Note: this field may return null, indicating that no valid values can be obtained.
        :type NodeList: list of NodeHardwareInfo
        :param _TagKeys: List of tag keys owned by user
Note: this field may return null, indicating that no valid values can be obtained.
        :type TagKeys: list of str
        :param _HardwareResourceTypeList: Resource type list
Note: this field may return null, indicating that no valid values can be obtained.
        :type HardwareResourceTypeList: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCnt = None
        self._NodeList = None
        self._TagKeys = None
        self._HardwareResourceTypeList = None
        self._RequestId = None

    @property
    def TotalCnt(self):
        r"""Total number of queried nodes
        :rtype: int
        """
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def NodeList(self):
        r"""List of node details
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeHardwareInfo
        """
        return self._NodeList

    @NodeList.setter
    def NodeList(self, NodeList):
        self._NodeList = NodeList

    @property
    def TagKeys(self):
        r"""List of tag keys owned by user
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._TagKeys

    @TagKeys.setter
    def TagKeys(self, TagKeys):
        self._TagKeys = TagKeys

    @property
    def HardwareResourceTypeList(self):
        r"""Resource type list
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._HardwareResourceTypeList

    @HardwareResourceTypeList.setter
    def HardwareResourceTypeList(self, HardwareResourceTypeList):
        self._HardwareResourceTypeList = HardwareResourceTypeList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("NodeList") is not None:
            self._NodeList = []
            for item in params.get("NodeList"):
                obj = NodeHardwareInfo()
                obj._deserialize(item)
                self._NodeList.append(obj)
        self._TagKeys = params.get("TagKeys")
        self._HardwareResourceTypeList = params.get("HardwareResourceTypeList")
        self._RequestId = params.get("RequestId")


class DescribeDAGInfoRequest(AbstractModel):
    r"""DescribeDAGInfo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceID: Cluster ID.
        :type InstanceID: str
        :param _Type: DAG type. Only STARROCKS is supported currently.
        :type Type: str
        :param _IDList: Query ID list. The maximum length is 1.
        :type IDList: list of str
        """
        self._InstanceID = None
        self._Type = None
        self._IDList = None

    @property
    def InstanceID(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Type(self):
        r"""DAG type. Only STARROCKS is supported currently.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def IDList(self):
        r"""Query ID list. The maximum length is 1.
        :rtype: list of str
        """
        return self._IDList

    @IDList.setter
    def IDList(self, IDList):
        self._IDList = IDList


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._Type = params.get("Type")
        self._IDList = params.get("IDList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDAGInfoResponse(AbstractModel):
    r"""DescribeDAGInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number, which is used for pagination query.
        :type TotalCount: int
        :param _DAGInfoList: StarRocks information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DAGInfoList: list of DAGInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DAGInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number, which is used for pagination query.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DAGInfoList(self):
        r"""StarRocks information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DAGInfo
        """
        return self._DAGInfoList

    @DAGInfoList.setter
    def DAGInfoList(self, DAGInfoList):
        self._DAGInfoList = DAGInfoList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DAGInfoList") is not None:
            self._DAGInfoList = []
            for item in params.get("DAGInfoList"):
                obj = DAGInfo()
                obj._deserialize(item)
                self._DAGInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEmrApplicationStaticsRequest(AbstractModel):
    r"""DescribeEmrApplicationStatics request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID
        :type InstanceId: str
        :param _StartTime: Start time in the format of timestamp. Unit: seconds.
        :type StartTime: int
        :param _EndTime: End time in the format of timestamp. Unit: seconds.
        :type EndTime: int
        :param _Queues: Queue name used for filtering
        :type Queues: list of str
        :param _Users: Username used for filtering
        :type Users: list of str
        :param _ApplicationTypes: Application type used for filtering
        :type ApplicationTypes: list of str
        :param _GroupBy: Group field. Valid values: `queue`, `user`, and `applicationType`.
        :type GroupBy: list of str
        :param _OrderBy: Sorting field. Valid values: `sumMemorySeconds`, `sumVCoreSeconds`, `sumHDFSBytesWritten`, and `sumHDFSBytesRead`.
        :type OrderBy: str
        :param _IsAsc: Order type. Valid values: `0` (descending) and `1`(ascending).
        :type IsAsc: int
        :param _Offset: Page number
        :type Offset: int
        :param _Limit: Page capacity in the range of [10,100].
        :type Limit: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Queues = None
        self._Users = None
        self._ApplicationTypes = None
        self._GroupBy = None
        self._OrderBy = None
        self._IsAsc = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Start time in the format of timestamp. Unit: seconds.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time in the format of timestamp. Unit: seconds.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Queues(self):
        r"""Queue name used for filtering
        :rtype: list of str
        """
        return self._Queues

    @Queues.setter
    def Queues(self, Queues):
        self._Queues = Queues

    @property
    def Users(self):
        r"""Username used for filtering
        :rtype: list of str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def ApplicationTypes(self):
        r"""Application type used for filtering
        :rtype: list of str
        """
        return self._ApplicationTypes

    @ApplicationTypes.setter
    def ApplicationTypes(self, ApplicationTypes):
        self._ApplicationTypes = ApplicationTypes

    @property
    def GroupBy(self):
        r"""Group field. Valid values: `queue`, `user`, and `applicationType`.
        :rtype: list of str
        """
        return self._GroupBy

    @GroupBy.setter
    def GroupBy(self, GroupBy):
        self._GroupBy = GroupBy

    @property
    def OrderBy(self):
        r"""Sorting field. Valid values: `sumMemorySeconds`, `sumVCoreSeconds`, `sumHDFSBytesWritten`, and `sumHDFSBytesRead`.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def IsAsc(self):
        r"""Order type. Valid values: `0` (descending) and `1`(ascending).
        :rtype: int
        """
        return self._IsAsc

    @IsAsc.setter
    def IsAsc(self, IsAsc):
        self._IsAsc = IsAsc

    @property
    def Offset(self):
        r"""Page number
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page capacity in the range of [10,100].
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Queues = params.get("Queues")
        self._Users = params.get("Users")
        self._ApplicationTypes = params.get("ApplicationTypes")
        self._GroupBy = params.get("GroupBy")
        self._OrderBy = params.get("OrderBy")
        self._IsAsc = params.get("IsAsc")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmrApplicationStaticsResponse(AbstractModel):
    r"""DescribeEmrApplicationStatics response structure.

    """

    def __init__(self):
        r"""
        :param _Statics: Application statistics
        :type Statics: list of ApplicationStatics
        :param _TotalCount: Total count
        :type TotalCount: int
        :param _Queues: Available queue name
        :type Queues: list of str
        :param _Users: Available usernames
        :type Users: list of str
        :param _ApplicationTypes: Available application type
        :type ApplicationTypes: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Statics = None
        self._TotalCount = None
        self._Queues = None
        self._Users = None
        self._ApplicationTypes = None
        self._RequestId = None

    @property
    def Statics(self):
        r"""Application statistics
        :rtype: list of ApplicationStatics
        """
        return self._Statics

    @Statics.setter
    def Statics(self, Statics):
        self._Statics = Statics

    @property
    def TotalCount(self):
        r"""Total count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Queues(self):
        r"""Available queue name
        :rtype: list of str
        """
        return self._Queues

    @Queues.setter
    def Queues(self, Queues):
        self._Queues = Queues

    @property
    def Users(self):
        r"""Available usernames
        :rtype: list of str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def ApplicationTypes(self):
        r"""Available application type
        :rtype: list of str
        """
        return self._ApplicationTypes

    @ApplicationTypes.setter
    def ApplicationTypes(self, ApplicationTypes):
        self._ApplicationTypes = ApplicationTypes

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Statics") is not None:
            self._Statics = []
            for item in params.get("Statics"):
                obj = ApplicationStatics()
                obj._deserialize(item)
                self._Statics.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._Queues = params.get("Queues")
        self._Users = params.get("Users")
        self._ApplicationTypes = params.get("ApplicationTypes")
        self._RequestId = params.get("RequestId")


class DescribeEmrOverviewMetricsRequest(AbstractModel):
    r"""DescribeEmrOverviewMetrics request structure.

    """

    def __init__(self):
        r"""
        :param _End: End time
        :type End: int
        :param _Metric: Metric name. NODE.CPU: average CPU utilization and core count of the node; NODE.CPU.SLHBASE: average CPU utilization and core count of the Serverless instance; HDFS.NN.CAPACITY: storage utilization and total amount.
        :type Metric: str
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _Downsample: Granularity, for example, 30s-max, 1m-max, and 1h-max.
        :type Downsample: str
        :param _Start: Start time, not required for pie charts
        :type Start: int
        :param _Aggregator: Aggregation method, for future use
        :type Aggregator: str
        :param _Tags: Specific type of metrics to be queried, for example, "{"type":"CapacityTotal|CapacityRemaining"}".
        :type Tags: str
        """
        self._End = None
        self._Metric = None
        self._InstanceId = None
        self._Downsample = None
        self._Start = None
        self._Aggregator = None
        self._Tags = None

    @property
    def End(self):
        r"""End time
        :rtype: int
        """
        return self._End

    @End.setter
    def End(self, End):
        self._End = End

    @property
    def Metric(self):
        r"""Metric name. NODE.CPU: average CPU utilization and core count of the node; NODE.CPU.SLHBASE: average CPU utilization and core count of the Serverless instance; HDFS.NN.CAPACITY: storage utilization and total amount.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Downsample(self):
        r"""Granularity, for example, 30s-max, 1m-max, and 1h-max.
        :rtype: str
        """
        return self._Downsample

    @Downsample.setter
    def Downsample(self, Downsample):
        self._Downsample = Downsample

    @property
    def Start(self):
        r"""Start time, not required for pie charts
        :rtype: int
        """
        return self._Start

    @Start.setter
    def Start(self, Start):
        self._Start = Start

    @property
    def Aggregator(self):
        r"""Aggregation method, for future use
        :rtype: str
        """
        return self._Aggregator

    @Aggregator.setter
    def Aggregator(self, Aggregator):
        self._Aggregator = Aggregator

    @property
    def Tags(self):
        r"""Specific type of metrics to be queried, for example, "{"type":"CapacityTotal|CapacityRemaining"}".
        :rtype: str
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._End = params.get("End")
        self._Metric = params.get("Metric")
        self._InstanceId = params.get("InstanceId")
        self._Downsample = params.get("Downsample")
        self._Start = params.get("Start")
        self._Aggregator = params.get("Aggregator")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmrOverviewMetricsResponse(AbstractModel):
    r"""DescribeEmrOverviewMetrics response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Metric data details.
        :type Result: list of OverviewMetricData
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        r"""Metric data details.
        :rtype: list of OverviewMetricData
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = OverviewMetricData()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeGlobalConfigRequest(AbstractModel):
    r"""DescribeGlobalConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: English ID of the EMR cluster.
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""English ID of the EMR cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalConfigResponse(AbstractModel):
    r"""DescribeGlobalConfig response structure.

    """

    def __init__(self):
        r"""
        :param _EnableResourceSchedule: Whether the resource scheduling feature is enabled.
        :type EnableResourceSchedule: bool
        :param _ActiveScheduler: Currently effective resource scheduler.
        :type ActiveScheduler: str
        :param _CapacityGlobalConfig: Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CapacityGlobalConfig: :class:`tencentcloud.emr.v20190103.models.CapacityGlobalConfig`
        :param _FairGlobalConfig: Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FairGlobalConfig: :class:`tencentcloud.emr.v20190103.models.FairGlobalConfig`
        :param _Scheduler: Latest resource scheduler.
        :type Scheduler: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EnableResourceSchedule = None
        self._ActiveScheduler = None
        self._CapacityGlobalConfig = None
        self._FairGlobalConfig = None
        self._Scheduler = None
        self._RequestId = None

    @property
    def EnableResourceSchedule(self):
        r"""Whether the resource scheduling feature is enabled.
        :rtype: bool
        """
        return self._EnableResourceSchedule

    @EnableResourceSchedule.setter
    def EnableResourceSchedule(self, EnableResourceSchedule):
        self._EnableResourceSchedule = EnableResourceSchedule

    @property
    def ActiveScheduler(self):
        r"""Currently effective resource scheduler.
        :rtype: str
        """
        return self._ActiveScheduler

    @ActiveScheduler.setter
    def ActiveScheduler(self, ActiveScheduler):
        self._ActiveScheduler = ActiveScheduler

    @property
    def CapacityGlobalConfig(self):
        r"""Information of the fair scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.CapacityGlobalConfig`
        """
        return self._CapacityGlobalConfig

    @CapacityGlobalConfig.setter
    def CapacityGlobalConfig(self, CapacityGlobalConfig):
        self._CapacityGlobalConfig = CapacityGlobalConfig

    @property
    def FairGlobalConfig(self):
        r"""Information of the capacity scheduler.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.FairGlobalConfig`
        """
        return self._FairGlobalConfig

    @FairGlobalConfig.setter
    def FairGlobalConfig(self, FairGlobalConfig):
        self._FairGlobalConfig = FairGlobalConfig

    @property
    def Scheduler(self):
        r"""Latest resource scheduler.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EnableResourceSchedule = params.get("EnableResourceSchedule")
        self._ActiveScheduler = params.get("ActiveScheduler")
        if params.get("CapacityGlobalConfig") is not None:
            self._CapacityGlobalConfig = CapacityGlobalConfig()
            self._CapacityGlobalConfig._deserialize(params.get("CapacityGlobalConfig"))
        if params.get("FairGlobalConfig") is not None:
            self._FairGlobalConfig = FairGlobalConfig()
            self._FairGlobalConfig._deserialize(params.get("FairGlobalConfig"))
        self._Scheduler = params.get("Scheduler")
        self._RequestId = params.get("RequestId")


class DescribeGroupsSTDRequest(AbstractModel):
    r"""DescribeGroupsSTD request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster name.
        :type InstanceId: str
        :param _Filters: Description key-value pair filter, which is used for conditional filtering queries.
        :type Filters: list of Filter
        :param _OrderFields: Description order, which is used for sorting.
        :type OrderFields: :class:`tencentcloud.emr.v20190103.models.Order`
        :param _Limit: Number of returns.
        :type Limit: int
        :param _Offset: Pagination parameter.
        :type Offset: int
        """
        self._InstanceId = None
        self._Filters = None
        self._OrderFields = None
        self._Limit = None
        self._Offset = None

    @property
    def InstanceId(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Filters(self):
        r"""Description key-value pair filter, which is used for conditional filtering queries.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        r"""Description order, which is used for sorting.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Order`
        """
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Limit(self):
        r"""Number of returns.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Pagination parameter.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = Order()
            self._OrderFields._deserialize(params.get("OrderFields"))
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupsSTDResponse(AbstractModel):
    r"""DescribeGroupsSTD response structure.

    """

    def __init__(self):
        r"""
        :param _Data: User group information.
        :type Data: list of GroupInfos
        :param _TotalCount: Number of eligible user groups.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        r"""User group information.
        :rtype: list of GroupInfos
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def TotalCount(self):
        r"""Number of eligible user groups.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = GroupInfos()
                obj._deserialize(item)
                self._Data.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeHBaseTableOverviewRequest(AbstractModel):
    r"""DescribeHBaseTableOverview request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _Offset: Pagination query number offset, starting from 0.	
        :type Offset: int
        :param _Limit: Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :type Limit: int
        :param _Table: Table name, supporting fuzzy matching
        :type Table: str
        :param _OrderField: Field for sorting, with a default value
        :type OrderField: str
        :param _OrderType: asc: Ascending; desc: Descending (default)
        :type OrderType: str
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._Table = None
        self._OrderField = None
        self._OrderType = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""Pagination query number offset, starting from 0.	
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Table(self):
        r"""Table name, supporting fuzzy matching
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def OrderField(self):
        r"""Field for sorting, with a default value
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderType(self):
        r"""asc: Ascending; desc: Descending (default)
        :rtype: str
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Table = params.get("Table")
        self._OrderField = params.get("OrderField")
        self._OrderType = params.get("OrderType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHBaseTableOverviewResponse(AbstractModel):
    r"""DescribeHBaseTableOverview response structure.

    """

    def __init__(self):
        r"""
        :param _TableMonitorList: Overview data array
        :type TableMonitorList: list of OverviewRow
        :param _TotalCount: Overview data array length
        :type TotalCount: int
        :param _SchemaList: Table schema information
        :type SchemaList: list of TableSchemaItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableMonitorList = None
        self._TotalCount = None
        self._SchemaList = None
        self._RequestId = None

    @property
    def TableMonitorList(self):
        r"""Overview data array
        :rtype: list of OverviewRow
        """
        return self._TableMonitorList

    @TableMonitorList.setter
    def TableMonitorList(self, TableMonitorList):
        self._TableMonitorList = TableMonitorList

    @property
    def TotalCount(self):
        r"""Overview data array length
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SchemaList(self):
        r"""Table schema information
        :rtype: list of TableSchemaItem
        """
        return self._SchemaList

    @SchemaList.setter
    def SchemaList(self, SchemaList):
        self._SchemaList = SchemaList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMonitorList") is not None:
            self._TableMonitorList = []
            for item in params.get("TableMonitorList"):
                obj = OverviewRow()
                obj._deserialize(item)
                self._TableMonitorList.append(obj)
        self._TotalCount = params.get("TotalCount")
        if params.get("SchemaList") is not None:
            self._SchemaList = []
            for item in params.get("SchemaList"):
                obj = TableSchemaItem()
                obj._deserialize(item)
                self._SchemaList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHDFSStorageInfoRequest(AbstractModel):
    r"""DescribeHDFSStorageInfo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Query information obtainment start time (seconds).
        :type StartTime: int
        :param _EndTime: Query information obtainment end time (seconds).
        :type EndTime: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Query information obtainment start time (seconds).
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Query information obtainment end time (seconds).
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHDFSStorageInfoResponse(AbstractModel):
    r"""DescribeHDFSStorageInfo response structure.

    """

    def __init__(self):
        r"""
        :param _SampleTime: Sampling time.
        :type SampleTime: int
        :param _StorageSummaryDistribution: Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StorageSummaryDistribution: list of StorageSummaryDistribution
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SampleTime = None
        self._StorageSummaryDistribution = None
        self._RequestId = None

    @property
    def SampleTime(self):
        r"""Sampling time.
        :rtype: int
        """
        return self._SampleTime

    @SampleTime.setter
    def SampleTime(self, SampleTime):
        self._SampleTime = SampleTime

    @property
    def StorageSummaryDistribution(self):
        r"""Hdfs storage details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of StorageSummaryDistribution
        """
        return self._StorageSummaryDistribution

    @StorageSummaryDistribution.setter
    def StorageSummaryDistribution(self, StorageSummaryDistribution):
        self._StorageSummaryDistribution = StorageSummaryDistribution

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SampleTime = params.get("SampleTime")
        if params.get("StorageSummaryDistribution") is not None:
            self._StorageSummaryDistribution = []
            for item in params.get("StorageSummaryDistribution"):
                obj = StorageSummaryDistribution()
                obj._deserialize(item)
                self._StorageSummaryDistribution.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHiveQueriesRequest(AbstractModel):
    r"""DescribeHiveQueries request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The cluster ID.
        :type InstanceId: str
        :param _StartTime: The start time in seconds.
        :type StartTime: int
        :param _EndTime: The end time in seconds. EndTime-StartTime should not exceed one day's duration, which is 86400 seconds.
        :type EndTime: int
        :param _Offset: Starting offset for pagination. Start value: 0
        :type Offset: int
        :param _Limit: Page size. Valid range: [1,100]
        :type Limit: int
        :param _State: Execution status, for example, ERROR.
        :type State: list of str
        :param _EndTimeGte: Time point earlier than the end time.
        :type EndTimeGte: int
        :param _EndTimeLte: Time point later than the end time.
        :type EndTimeLte: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._State = None
        self._EndTimeGte = None
        self._EndTimeLte = None

    @property
    def InstanceId(self):
        r"""The cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""The start time in seconds.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""The end time in seconds. EndTime-StartTime should not exceed one day's duration, which is 86400 seconds.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""Starting offset for pagination. Start value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page size. Valid range: [1,100]
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def State(self):
        r"""Execution status, for example, ERROR.
        :rtype: list of str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def EndTimeGte(self):
        r"""Time point earlier than the end time.
        :rtype: int
        """
        return self._EndTimeGte

    @EndTimeGte.setter
    def EndTimeGte(self, EndTimeGte):
        self._EndTimeGte = EndTimeGte

    @property
    def EndTimeLte(self):
        r"""Time point later than the end time.
        :rtype: int
        """
        return self._EndTimeLte

    @EndTimeLte.setter
    def EndTimeLte(self, EndTimeLte):
        self._EndTimeLte = EndTimeLte


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._State = params.get("State")
        self._EndTimeGte = params.get("EndTimeGte")
        self._EndTimeLte = params.get("EndTimeLte")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHiveQueriesResponse(AbstractModel):
    r"""DescribeHiveQueries response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total items
        :type Total: int
        :param _Results: Result list
        :type Results: list of HiveQuery
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Results = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total items
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Results(self):
        r"""Result list
        :rtype: list of HiveQuery
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = HiveQuery()
                obj._deserialize(item)
                self._Results.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInsightListRequest(AbstractModel):
    r"""DescribeInsightList request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Start time of the obtained insight result. The time is specific for filtering the start time of App or Hive querying.
        :type StartTime: int
        :param _EndTime: End time of the obtained insight result. The time is specific for filtering the start time of App or Hive querying.
        :type EndTime: int
        :param _PageSize: Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :type PageSize: int
        :param _Page: Page number for pagination queries, starting from 1.
        :type Page: int
        :param _Type: Query type. Types such as Hive,Spark,DLC_Spark,Spark_SQL,SCHEDULE,MapReduce,Trino are supported. All are queried by default.
        :type Type: str
        :param _MustHasContext: 
        :type MustHasContext: bool
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._PageSize = None
        self._Page = None
        self._Type = None
        self._MustHasContext = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Start time of the obtained insight result. The time is specific for filtering the start time of App or Hive querying.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time of the obtained insight result. The time is specific for filtering the start time of App or Hive querying.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PageSize(self):
        r"""Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Page(self):
        r"""Page number for pagination queries, starting from 1.
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Type(self):
        r"""Query type. Types such as Hive,Spark,DLC_Spark,Spark_SQL,SCHEDULE,MapReduce,Trino are supported. All are queried by default.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def MustHasContext(self):
        r"""
        :rtype: bool
        """
        return self._MustHasContext

    @MustHasContext.setter
    def MustHasContext(self, MustHasContext):
        self._MustHasContext = MustHasContext


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PageSize = params.get("PageSize")
        self._Page = params.get("Page")
        self._Type = params.get("Type")
        self._MustHasContext = params.get("MustHasContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInsightListResponse(AbstractModel):
    r"""DescribeInsightList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number, which is used for pagination query.
        :type TotalCount: int
        :param _ResultList: Insight result array.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResultList: list of InsightResult
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ResultList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number, which is used for pagination query.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ResultList(self):
        r"""Insight result array.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of InsightResult
        """
        return self._ResultList

    @ResultList.setter
    def ResultList(self, ResultList):
        self._ResultList = ResultList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ResultList") is not None:
            self._ResultList = []
            for item in params.get("ResultList"):
                obj = InsightResult()
                obj._deserialize(item)
                self._ResultList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInspectionTaskResultRequest(AbstractModel):
    r"""DescribeInspectionTaskResult request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _Type: Type.
        :type Type: str
        :param _StartTime: Start time.
        :type StartTime: int
        :param _EndTime: End time.
        :type EndTime: int
        :param _Limit: Page size.
        :type Limit: int
        :param _Offset: Pagination offset.
        :type Offset: int
        """
        self._InstanceId = None
        self._Type = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Type(self):
        r"""Type.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""Page size.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Pagination offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Type = params.get("Type")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInspectionTaskResultResponse(AbstractModel):
    r"""DescribeInspectionTaskResult response structure.

    """

    def __init__(self):
        r"""
        :param _InspectionResultInfo: Inspection task record, encoded in Base64 format.
        :type InspectionResultInfo: str
        :param _Total: The total number of records.
        :type Total: int
        :param _TypeInfo: Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}.
        :type TypeInfo: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InspectionResultInfo = None
        self._Total = None
        self._TypeInfo = None
        self._RequestId = None

    @property
    def InspectionResultInfo(self):
        r"""Inspection task record, encoded in Base64 format.
        :rtype: str
        """
        return self._InspectionResultInfo

    @InspectionResultInfo.setter
    def InspectionResultInfo(self, InspectionResultInfo):
        self._InspectionResultInfo = InspectionResultInfo

    @property
    def Total(self):
        r"""The total number of records.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def TypeInfo(self):
        r"""Category information encoded in Base64 format, which includes {"FixedTime": "Fixed time", "RealTime": "Real time"}.
        :rtype: str
        """
        return self._TypeInfo

    @TypeInfo.setter
    def TypeInfo(self, TypeInfo):
        self._TypeInfo = TypeInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InspectionResultInfo = params.get("InspectionResultInfo")
        self._Total = params.get("Total")
        self._TypeInfo = params.get("TypeInfo")
        self._RequestId = params.get("RequestId")


class DescribeInstancesListRequest(AbstractModel):
    r"""DescribeInstancesList request structure.

    """

    def __init__(self):
        r"""
        :param _DisplayStrategy: Cluster filtering policy. Valid values: <li>clusterList: Queries the list of clusters excluding terminated ones.</li><li>monitorManage: Queries the list of clusters excluding those terminated, under creation and not successfully created.</li><li>cloudHardwareManage/componentManage: Two reserved values, which have the same implications as those of `monitorManage`.</li>
        :type DisplayStrategy: str
        :param _Offset: Page number. Default value: `0`, indicating the first page.
        :type Offset: int
        :param _Limit: Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both limit and offset are 0, all records will be queried.
        :type Limit: int
        :param _OrderField: Sorting field. Valid values: <li>clusterId: Sorting by instance ID. </li><li>addTime: Sorting by instance creation time.</li><li>status: Sorting by instance status code.</li>
        :type OrderField: str
        :param _Asc: Sort by OrderField in ascending or descending order. Valid values: <li>0: ascending order;</li> <li>1: descending order.</li> The default value is 0.
        :type Asc: int
        :param _Filters: Custom search filter. Examples: <li>instance of filtering by ClusterId: [{"Name":"ClusterId","Values":["emr-xxxxxxxx"]}]</li><li>instance of filtering by clusterName: [{"Name": "ClusterName","Values": ["cluster_name"]}]</li><li>instance of filtering by ClusterStatus: [{"Name": "ClusterStatus","Values": ["2"]}]</li>.
        :type Filters: list of Filters
        """
        self._DisplayStrategy = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Asc = None
        self._Filters = None

    @property
    def DisplayStrategy(self):
        r"""Cluster filtering policy. Valid values: <li>clusterList: Queries the list of clusters excluding terminated ones.</li><li>monitorManage: Queries the list of clusters excluding those terminated, under creation and not successfully created.</li><li>cloudHardwareManage/componentManage: Two reserved values, which have the same implications as those of `monitorManage`.</li>
        :rtype: str
        """
        return self._DisplayStrategy

    @DisplayStrategy.setter
    def DisplayStrategy(self, DisplayStrategy):
        self._DisplayStrategy = DisplayStrategy

    @property
    def Offset(self):
        r"""Page number. Default value: `0`, indicating the first page.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of records to be returned per page. The default value is 100, and the maximum value is 100.
If both limit and offset are 0, all records will be queried.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        r"""Sorting field. Valid values: <li>clusterId: Sorting by instance ID. </li><li>addTime: Sorting by instance creation time.</li><li>status: Sorting by instance status code.</li>
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Asc(self):
        r"""Sort by OrderField in ascending or descending order. Valid values: <li>0: ascending order;</li> <li>1: descending order.</li> The default value is 0.
        :rtype: int
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def Filters(self):
        r"""Custom search filter. Examples: <li>instance of filtering by ClusterId: [{"Name":"ClusterId","Values":["emr-xxxxxxxx"]}]</li><li>instance of filtering by clusterName: [{"Name": "ClusterName","Values": ["cluster_name"]}]</li><li>instance of filtering by ClusterStatus: [{"Name": "ClusterStatus","Values": ["2"]}]</li>.
        :rtype: list of Filters
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._DisplayStrategy = params.get("DisplayStrategy")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Asc = params.get("Asc")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesListResponse(AbstractModel):
    r"""DescribeInstancesList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCnt: Number of eligible instances.
        :type TotalCnt: int
        :param _InstancesList: Cluster instance list.
        :type InstancesList: list of EmrListInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCnt = None
        self._InstancesList = None
        self._RequestId = None

    @property
    def TotalCnt(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def InstancesList(self):
        r"""Cluster instance list.
        :rtype: list of EmrListInstance
        """
        return self._InstancesList

    @InstancesList.setter
    def InstancesList(self, InstancesList):
        self._InstancesList = InstancesList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("InstancesList") is not None:
            self._InstancesList = []
            for item in params.get("InstancesList"):
                obj = EmrListInstance()
                obj._deserialize(item)
                self._InstancesList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    r"""DescribeInstances request structure.

    """

    def __init__(self):
        r"""
        :param _DisplayStrategy: Cluster filtering policy. Valid values:
<li>clusterList: queries the list of clusters except terminated ones.</li>
<li>monitorManage: queries the list of clusters except those that have been terminated, are being created, or failed to be created.</li>
<li>cloudHardwareManage/componentManage: reserved fields with the same meaning as `monitorManage`.</li>
        :type DisplayStrategy: str
        :param _InstanceIds: Queries by one or more instance IDs in the format of `emr-xxxxxxxx`. For the format of this parameter, please see the `id.N` section in [API Overview](https://intl.cloud.tencent.com/document/api/213/15688). If no instance ID is entered, the list of all instances under this `APPID` will be returned.
        :type InstanceIds: list of str
        :param _Offset: Page number. Default value: 0, indicating the first page.
        :type Offset: int
        :param _Limit: Number of returned results per page. Default value: 10. Maximum value: 100
        :type Limit: int
        :param _ProjectId: ID of the project to which the instance belongs. This parameter can be obtained from the `projectId` field in the return value of the `DescribeProject` API. If this value is -1, the list of all instances will be returned.
        :type ProjectId: int
        :param _OrderField: Sorting field. Valid values:
<li>clusterId: sorts by cluster ID.</li>
<li>addTime: sorts by instance creation time.</li>
<li>status: sorts by instance status code.</li>
        :type OrderField: str
        :param _Asc: Sorts according to `OrderField` in ascending or descending order. Valid values:
<li>0: descending order.</li>
<li>1: ascending order.</li>Default value: 0.
        :type Asc: int
        """
        self._DisplayStrategy = None
        self._InstanceIds = None
        self._Offset = None
        self._Limit = None
        self._ProjectId = None
        self._OrderField = None
        self._Asc = None

    @property
    def DisplayStrategy(self):
        r"""Cluster filtering policy. Valid values:
<li>clusterList: queries the list of clusters except terminated ones.</li>
<li>monitorManage: queries the list of clusters except those that have been terminated, are being created, or failed to be created.</li>
<li>cloudHardwareManage/componentManage: reserved fields with the same meaning as `monitorManage`.</li>
        :rtype: str
        """
        return self._DisplayStrategy

    @DisplayStrategy.setter
    def DisplayStrategy(self, DisplayStrategy):
        self._DisplayStrategy = DisplayStrategy

    @property
    def InstanceIds(self):
        r"""Queries by one or more instance IDs in the format of `emr-xxxxxxxx`. For the format of this parameter, please see the `id.N` section in [API Overview](https://intl.cloud.tencent.com/document/api/213/15688). If no instance ID is entered, the list of all instances under this `APPID` will be returned.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def Offset(self):
        r"""Page number. Default value: 0, indicating the first page.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results per page. Default value: 10. Maximum value: 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ProjectId(self):
        r"""ID of the project to which the instance belongs. This parameter can be obtained from the `projectId` field in the return value of the `DescribeProject` API. If this value is -1, the list of all instances will be returned.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def OrderField(self):
        r"""Sorting field. Valid values:
<li>clusterId: sorts by cluster ID.</li>
<li>addTime: sorts by instance creation time.</li>
<li>status: sorts by instance status code.</li>
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Asc(self):
        r"""Sorts according to `OrderField` in ascending or descending order. Valid values:
<li>0: descending order.</li>
<li>1: ascending order.</li>Default value: 0.
        :rtype: int
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._DisplayStrategy = params.get("DisplayStrategy")
        self._InstanceIds = params.get("InstanceIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ProjectId = params.get("ProjectId")
        self._OrderField = params.get("OrderField")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    r"""DescribeInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCnt: Number of eligible instances.
        :type TotalCnt: int
        :param _ClusterList: List of EMR instance details.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClusterList: list of ClusterInstancesInfo
        :param _TagKeys: List of tag keys associated to an instance.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TagKeys: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCnt = None
        self._ClusterList = None
        self._TagKeys = None
        self._RequestId = None

    @property
    def TotalCnt(self):
        r"""Number of eligible instances.
        :rtype: int
        """
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def ClusterList(self):
        r"""List of EMR instance details.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of ClusterInstancesInfo
        """
        return self._ClusterList

    @ClusterList.setter
    def ClusterList(self, ClusterList):
        self._ClusterList = ClusterList

    @property
    def TagKeys(self):
        r"""List of tag keys associated to an instance.
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._TagKeys

    @TagKeys.setter
    def TagKeys(self, TagKeys):
        self._TagKeys = TagKeys

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("ClusterList") is not None:
            self._ClusterList = []
            for item in params.get("ClusterList"):
                obj = ClusterInstancesInfo()
                obj._deserialize(item)
                self._ClusterList.append(obj)
        self._TagKeys = params.get("TagKeys")
        self._RequestId = params.get("RequestId")


class DescribeKyuubiQueryInfoRequest(AbstractModel):
    r"""DescribeKyuubiQueryInfo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Query information obtainment start time (seconds).
        :type StartTime: int
        :param _EndTime: Query information obtainment end time (seconds).
        :type EndTime: int
        :param _PageSize: Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :type PageSize: int
        :param _Page: Page number for pagination queries, starting from 1.
        :type Page: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._PageSize = None
        self._Page = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Query information obtainment start time (seconds).
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Query information obtainment end time (seconds).
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PageSize(self):
        r"""Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Page(self):
        r"""Page number for pagination queries, starting from 1.
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PageSize = params.get("PageSize")
        self._Page = params.get("Page")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeKyuubiQueryInfoResponse(AbstractModel):
    r"""DescribeKyuubiQueryInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number, which is used for pagination query.
        :type TotalCount: int
        :param _KyuubiQueryInfoList: Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type KyuubiQueryInfoList: list of KyuubiQueryInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._KyuubiQueryInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number, which is used for pagination query.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def KyuubiQueryInfoList(self):
        r"""Kyuubi information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of KyuubiQueryInfo
        """
        return self._KyuubiQueryInfoList

    @KyuubiQueryInfoList.setter
    def KyuubiQueryInfoList(self, KyuubiQueryInfoList):
        self._KyuubiQueryInfoList = KyuubiQueryInfoList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("KyuubiQueryInfoList") is not None:
            self._KyuubiQueryInfoList = []
            for item in params.get("KyuubiQueryInfoList"):
                obj = KyuubiQueryInfo()
                obj._deserialize(item)
                self._KyuubiQueryInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNodeDataDisksRequest(AbstractModel):
    r"""DescribeNodeDataDisks request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of the EMR cluster instance.
        :type InstanceId: str
        :param _CvmInstanceIds: ID list of node CVM instances.
        :type CvmInstanceIds: list of str
        :param _Filters: Filter criteria for querying cloud disks.
        :type Filters: list of Filters
        :param _InnerSearch: Fuzzy search.
        :type InnerSearch: str
        :param _Limit: Number of items returned per page. The default value is 100, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Data offset.
        :type Offset: int
        """
        self._InstanceId = None
        self._CvmInstanceIds = None
        self._Filters = None
        self._InnerSearch = None
        self._Limit = None
        self._Offset = None

    @property
    def InstanceId(self):
        r"""ID of the EMR cluster instance.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CvmInstanceIds(self):
        r"""ID list of node CVM instances.
        :rtype: list of str
        """
        return self._CvmInstanceIds

    @CvmInstanceIds.setter
    def CvmInstanceIds(self, CvmInstanceIds):
        self._CvmInstanceIds = CvmInstanceIds

    @property
    def Filters(self):
        r"""Filter criteria for querying cloud disks.
        :rtype: list of Filters
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def InnerSearch(self):
        r"""Fuzzy search.
        :rtype: str
        """
        return self._InnerSearch

    @InnerSearch.setter
    def InnerSearch(self, InnerSearch):
        self._InnerSearch = InnerSearch

    @property
    def Limit(self):
        r"""Number of items returned per page. The default value is 100, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Data offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._CvmInstanceIds = params.get("CvmInstanceIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._InnerSearch = params.get("InnerSearch")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNodeDataDisksResponse(AbstractModel):
    r"""DescribeNodeDataDisks response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _CBSList: Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CBSList: list of CBSInstance
        :param _MaxSize: Maximum cloud disk capacity.
        :type MaxSize: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._CBSList = None
        self._MaxSize = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CBSList(self):
        r"""Cloud disk list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of CBSInstance
        """
        return self._CBSList

    @CBSList.setter
    def CBSList(self, CBSList):
        self._CBSList = CBSList

    @property
    def MaxSize(self):
        r"""Maximum cloud disk capacity.
        :rtype: int
        """
        return self._MaxSize

    @MaxSize.setter
    def MaxSize(self, MaxSize):
        self._MaxSize = MaxSize

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CBSList") is not None:
            self._CBSList = []
            for item in params.get("CBSList"):
                obj = CBSInstance()
                obj._deserialize(item)
                self._CBSList.append(obj)
        self._MaxSize = params.get("MaxSize")
        self._RequestId = params.get("RequestId")


class DescribeNodeResourceConfigFastRequest(AbstractModel):
    r"""DescribeNodeResourceConfigFast request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ResourceType: Node type, CORE, TASK, ROUTER or ALL.
        :type ResourceType: str
        :param _PayMode: Billing type.
        :type PayMode: int
        :param _ZoneId: Availability zone ID.
        :type ZoneId: int
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        :param _HardwareResourceType: Hardware type.
        :type HardwareResourceType: str
        """
        self._InstanceId = None
        self._ResourceType = None
        self._PayMode = None
        self._ZoneId = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None
        self._HardwareResourceType = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceType(self):
        r"""Node type, CORE, TASK, ROUTER or ALL.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def PayMode(self):
        r"""Billing type.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ZoneId(self):
        r"""Availability zone ID.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId

    @property
    def HardwareResourceType(self):
        r"""Hardware type.
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ResourceType = params.get("ResourceType")
        self._PayMode = params.get("PayMode")
        self._ZoneId = params.get("ZoneId")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        self._HardwareResourceType = params.get("HardwareResourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNodeResourceConfigFastResponse(AbstractModel):
    r"""DescribeNodeResourceConfigFast response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Return value of the DescribeResourceConfig API.
        :type Data: list of DescribeResourceConfig
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""Return value of the DescribeResourceConfig API.
        :rtype: list of DescribeResourceConfig
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribeResourceConfig()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNodeSpec(AbstractModel):
    r"""Node specifications.

    """

    def __init__(self):
        r"""
        :param _NodeType: Node type.
        :type NodeType: str
        :param _NodeName: Node type name.
        :type NodeName: str
        :param _Types: Types array.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Types: list of NodeSpecType
        :param _CmnTypes: Cloud Managed Node (M Node) model specifications list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CmnTypes: list of NodeSpecType
        """
        self._NodeType = None
        self._NodeName = None
        self._Types = None
        self._CmnTypes = None

    @property
    def NodeType(self):
        r"""Node type.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        r"""Node type name.
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Types(self):
        r"""Types array.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecType
        """
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def CmnTypes(self):
        r"""Cloud Managed Node (M Node) model specifications list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecType
        """
        return self._CmnTypes

    @CmnTypes.setter
    def CmnTypes(self, CmnTypes):
        self._CmnTypes = CmnTypes


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = NodeSpecType()
                obj._deserialize(item)
                self._Types.append(obj)
        if params.get("CmnTypes") is not None:
            self._CmnTypes = []
            for item in params.get("CmnTypes"):
                obj = NodeSpecType()
                obj._deserialize(item)
                self._CmnTypes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNodeSpecRequest(AbstractModel):
    r"""DescribeNodeSpec request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Availability zone (AZ) ID. https://document.capi.woa.com/document/api/1605/76892 can be accessed for related information.
        :type ZoneId: int
        :param _CvmPayMode: 0: pay-as-you-go; 1: yearly/monthly subscription; 99: a combination of pay-as-you-go and yearly/monthly subscription. Invalid values will suppress billing display.
        :type CvmPayMode: int
        :param _NodeType: Node type: Master,Core,Task,Router,All.
        :type NodeType: str
        :param _TradeType: 0: old billing page; 1: new billing page. Invalid values will be deemed to be old billing by default.
        :type TradeType: int
        :param _ProductId: Product ID. If left blank, the value is "0". This field is used to represent the product ID in all situations. It is required in front-end scenarios.

44	EMR	V3.5.0
43	EMR	V3.4.0.tlinux
42	EMR	V2.7.0.tlinux
41	DRUID	V1.1.0
67	STARROCKS	V2.2.0
45	DRUID	V1.1.0.tlinux
40	EMRCLOUD	v3.2.0
47	EMR	V4.0.0
48	STARROCKS	V1.2.0
49	STARROCKS	V1.3.0
50	KAFKA	V2.0.0
51	STARROCKS	V1.4.0
52	EMR-TKE	V1.0.0
53	EMR	V3.6.0
54	STARROCKS	V2.0.0
55	EMR-TKE	V1.0.1
56	EMR-TKE	DLCV1.0.0
57	EMR	V2.8.0
58	EMR	V3.6.1
59	SERVERLESS	V1.0.0
60	EMR-TKE	V1.1.0
62	STARROCKS	V2.1.1
63	STARROCKS	V2.1.1.tlinux
64	EMR-TKE	TCCV1.0.0
65	EMR-TKE-AI	V1.0.0
66	RSS	V1.0.0
24	EMR	TianQiong-V1.0.0
3	EMR	V2.0.1.tlinux
4	EMR	V2.1.0
7	EMR	V3.0.0
8	EMR	V3.0.0.tlinux
9	EMR	V2.2.0
11	CLICKHOUSE	V1.0.0
12	CLICKHOUSE	V1.0.0.tlinux
16	EMR	V2.3.0
17	CLICKHOUSE	V1.1.0
18	CLICKHOUSE	V1.1.0.tlinux
19	EMR	V2.4.0
20	EMR	V2.5.0
21	USERCUSTOM	V1.0.0
22	CLICKHOUSE	V1.2.0
39	STARROCKS	V1.1.0
25	EMR	V3.1.0
26	DORIS	V1.0.0
27	KAFKA	V1.0.0
28	EMR	V3.2.0
29	EMR	V2.5.1
30	EMR	V2.6.0
32	DORIS	V1.1.0
33	EMR	V3.2.1
34	EMR	V3.3.0
35	DORIS	V1.2.0
36	STARROCKS	V1.0.0
37	EMR	V3.4.0
38	EMR	V2.7.0
        :type ProductId: int
        :param _SceneName: Scenario name.
        :type SceneName: str
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        """
        self._ZoneId = None
        self._CvmPayMode = None
        self._NodeType = None
        self._TradeType = None
        self._ProductId = None
        self._SceneName = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None

    @property
    def ZoneId(self):
        r"""Availability zone (AZ) ID. https://document.capi.woa.com/document/api/1605/76892 can be accessed for related information.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CvmPayMode(self):
        r"""0: pay-as-you-go; 1: yearly/monthly subscription; 99: a combination of pay-as-you-go and yearly/monthly subscription. Invalid values will suppress billing display.
        :rtype: int
        """
        return self._CvmPayMode

    @CvmPayMode.setter
    def CvmPayMode(self, CvmPayMode):
        self._CvmPayMode = CvmPayMode

    @property
    def NodeType(self):
        r"""Node type: Master,Core,Task,Router,All.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def TradeType(self):
        r"""0: old billing page; 1: new billing page. Invalid values will be deemed to be old billing by default.
        :rtype: int
        """
        return self._TradeType

    @TradeType.setter
    def TradeType(self, TradeType):
        self._TradeType = TradeType

    @property
    def ProductId(self):
        r"""Product ID. If left blank, the value is "0". This field is used to represent the product ID in all situations. It is required in front-end scenarios.

44	EMR	V3.5.0
43	EMR	V3.4.0.tlinux
42	EMR	V2.7.0.tlinux
41	DRUID	V1.1.0
67	STARROCKS	V2.2.0
45	DRUID	V1.1.0.tlinux
40	EMRCLOUD	v3.2.0
47	EMR	V4.0.0
48	STARROCKS	V1.2.0
49	STARROCKS	V1.3.0
50	KAFKA	V2.0.0
51	STARROCKS	V1.4.0
52	EMR-TKE	V1.0.0
53	EMR	V3.6.0
54	STARROCKS	V2.0.0
55	EMR-TKE	V1.0.1
56	EMR-TKE	DLCV1.0.0
57	EMR	V2.8.0
58	EMR	V3.6.1
59	SERVERLESS	V1.0.0
60	EMR-TKE	V1.1.0
62	STARROCKS	V2.1.1
63	STARROCKS	V2.1.1.tlinux
64	EMR-TKE	TCCV1.0.0
65	EMR-TKE-AI	V1.0.0
66	RSS	V1.0.0
24	EMR	TianQiong-V1.0.0
3	EMR	V2.0.1.tlinux
4	EMR	V2.1.0
7	EMR	V3.0.0
8	EMR	V3.0.0.tlinux
9	EMR	V2.2.0
11	CLICKHOUSE	V1.0.0
12	CLICKHOUSE	V1.0.0.tlinux
16	EMR	V2.3.0
17	CLICKHOUSE	V1.1.0
18	CLICKHOUSE	V1.1.0.tlinux
19	EMR	V2.4.0
20	EMR	V2.5.0
21	USERCUSTOM	V1.0.0
22	CLICKHOUSE	V1.2.0
39	STARROCKS	V1.1.0
25	EMR	V3.1.0
26	DORIS	V1.0.0
27	KAFKA	V1.0.0
28	EMR	V3.2.0
29	EMR	V2.5.1
30	EMR	V2.6.0
32	DORIS	V1.1.0
33	EMR	V3.2.1
34	EMR	V3.3.0
35	DORIS	V1.2.0
36	STARROCKS	V1.0.0
37	EMR	V3.4.0
38	EMR	V2.7.0
        :rtype: int
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def SceneName(self):
        r"""Scenario name.
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CvmPayMode = params.get("CvmPayMode")
        self._NodeType = params.get("NodeType")
        self._TradeType = params.get("TradeType")
        self._ProductId = params.get("ProductId")
        self._SceneName = params.get("SceneName")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNodeSpecResponse(AbstractModel):
    r"""DescribeNodeSpec response structure.

    """

    def __init__(self):
        r"""
        :param _NodeSpecs: Node specification type.
        :type NodeSpecs: list of DescribeNodeSpec
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NodeSpecs = None
        self._RequestId = None

    @property
    def NodeSpecs(self):
        r"""Node specification type.
        :rtype: list of DescribeNodeSpec
        """
        return self._NodeSpecs

    @NodeSpecs.setter
    def NodeSpecs(self, NodeSpecs):
        self._NodeSpecs = NodeSpecs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodeSpecs") is not None:
            self._NodeSpecs = []
            for item in params.get("NodeSpecs"):
                obj = DescribeNodeSpec()
                obj._deserialize(item)
                self._NodeSpecs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourceConfig(AbstractModel):
    r"""Output parameters of the DescribeResourceConfig API.

    """

    def __init__(self):
        r"""
        :param _ResourceType: Specification management type.
        :type ResourceType: str
        :param _ResourceData: Specification management data.
        :type ResourceData: list of NodeResource
        """
        self._ResourceType = None
        self._ResourceData = None

    @property
    def ResourceType(self):
        r"""Specification management type.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceData(self):
        r"""Specification management data.
        :rtype: list of NodeResource
        """
        return self._ResourceData

    @ResourceData.setter
    def ResourceData(self, ResourceData):
        self._ResourceData = ResourceData


    def _deserialize(self, params):
        self._ResourceType = params.get("ResourceType")
        if params.get("ResourceData") is not None:
            self._ResourceData = []
            for item in params.get("ResourceData"):
                obj = NodeResource()
                obj._deserialize(item)
                self._ResourceData.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceScheduleDiffDetailRequest(AbstractModel):
    r"""DescribeResourceScheduleDiffDetail request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: English ID of the EMR cluster.
        :type InstanceId: str
        :param _Scheduler: Scheduler for the queried change details. The available values are fair and capacity. If this parameter is not passed or a null value is passed, the latest scheduler will be used.
        :type Scheduler: str
        """
        self._InstanceId = None
        self._Scheduler = None

    @property
    def InstanceId(self):
        r"""English ID of the EMR cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Scheduler(self):
        r"""Scheduler for the queried change details. The available values are fair and capacity. If this parameter is not passed or a null value is passed, the latest scheduler will be used.
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Scheduler = params.get("Scheduler")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceScheduleDiffDetailResponse(AbstractModel):
    r"""DescribeResourceScheduleDiffDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Details: Details of change items.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Details: list of DiffDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Details = None
        self._RequestId = None

    @property
    def Details(self):
        r"""Details of change items.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DiffDetail
        """
        return self._Details

    @Details.setter
    def Details(self, Details):
        self._Details = Details

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Details") is not None:
            self._Details = []
            for item in params.get("Details"):
                obj = DiffDetail()
                obj._deserialize(item)
                self._Details.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourceScheduleRequest(AbstractModel):
    r"""DescribeResourceSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: EMR cluster ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""EMR cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceScheduleResponse(AbstractModel):
    r"""DescribeResourceSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _OpenSwitch: Whether to enable the resource scheduling feature
        :type OpenSwitch: bool
        :param _Scheduler: The resource scheduler in service
        :type Scheduler: str
        :param _FSInfo: Fair Scheduler information
        :type FSInfo: str
        :param _CSInfo: Capacity Scheduler information
        :type CSInfo: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OpenSwitch = None
        self._Scheduler = None
        self._FSInfo = None
        self._CSInfo = None
        self._RequestId = None

    @property
    def OpenSwitch(self):
        r"""Whether to enable the resource scheduling feature
        :rtype: bool
        """
        return self._OpenSwitch

    @OpenSwitch.setter
    def OpenSwitch(self, OpenSwitch):
        self._OpenSwitch = OpenSwitch

    @property
    def Scheduler(self):
        r"""The resource scheduler in service
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def FSInfo(self):
        r"""Fair Scheduler information
        :rtype: str
        """
        return self._FSInfo

    @FSInfo.setter
    def FSInfo(self, FSInfo):
        self._FSInfo = FSInfo

    @property
    def CSInfo(self):
        r"""Capacity Scheduler information
        :rtype: str
        """
        return self._CSInfo

    @CSInfo.setter
    def CSInfo(self, CSInfo):
        self._CSInfo = CSInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OpenSwitch = params.get("OpenSwitch")
        self._Scheduler = params.get("Scheduler")
        self._FSInfo = params.get("FSInfo")
        self._CSInfo = params.get("CSInfo")
        self._RequestId = params.get("RequestId")


class DescribeSLInstanceListRequest(AbstractModel):
    r"""DescribeSLInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _DisplayStrategy: Instance filtering policy. Valid values: <li>clusterList: Query the list of instances except for those that have been terminated.</li> <li>monitorManage: Query the list of instances except for those that have been terminated, are being created, or fail to be created.</li>
        :type DisplayStrategy: str
        :param _Offset: Page number. The default value is 0, indicating the first page.
        :type Offset: int
        :param _Limit: Number of records to be returned per page. The default value is 10, and the maximum value is 100.	
        :type Limit: int
        :param _OrderField: Sorting field. Valid values: <li>clusterId: Sort by instance ID.</li> <li>addTime: Sort by instance creation time.</li> <li>status: Sort by instance status code.</li>
        :type OrderField: str
        :param _Asc: Sorts by OrderField in ascending or descending order. Valid values: <li>0: ascending order;</li> <li>1: descending order.</li> The default value is 0.
        :type Asc: int
        :param _Filters: Custom search filters. Examples: <li>Filter instances by ClusterId: [{"Name":"ClusterId","Values":["emr-xxxxxxxx"]}]</li><li> Filter instances by clusterName: [{"Name": "ClusterName","Values": ["cluster_name"]}]</li><li>Filter instances by ClusterStatus: [{"Name": "ClusterStatus","Values": ["2"]}]</li>
        :type Filters: list of Filters
        """
        self._DisplayStrategy = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._Asc = None
        self._Filters = None

    @property
    def DisplayStrategy(self):
        r"""Instance filtering policy. Valid values: <li>clusterList: Query the list of instances except for those that have been terminated.</li> <li>monitorManage: Query the list of instances except for those that have been terminated, are being created, or fail to be created.</li>
        :rtype: str
        """
        return self._DisplayStrategy

    @DisplayStrategy.setter
    def DisplayStrategy(self, DisplayStrategy):
        self._DisplayStrategy = DisplayStrategy

    @property
    def Offset(self):
        r"""Page number. The default value is 0, indicating the first page.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of records to be returned per page. The default value is 10, and the maximum value is 100.	
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        r"""Sorting field. Valid values: <li>clusterId: Sort by instance ID.</li> <li>addTime: Sort by instance creation time.</li> <li>status: Sort by instance status code.</li>
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def Asc(self):
        r"""Sorts by OrderField in ascending or descending order. Valid values: <li>0: ascending order;</li> <li>1: descending order.</li> The default value is 0.
        :rtype: int
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def Filters(self):
        r"""Custom search filters. Examples: <li>Filter instances by ClusterId: [{"Name":"ClusterId","Values":["emr-xxxxxxxx"]}]</li><li> Filter instances by clusterName: [{"Name": "ClusterName","Values": ["cluster_name"]}]</li><li>Filter instances by ClusterStatus: [{"Name": "ClusterStatus","Values": ["2"]}]</li>
        :rtype: list of Filters
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._DisplayStrategy = params.get("DisplayStrategy")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._Asc = params.get("Asc")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSLInstanceListResponse(AbstractModel):
    r"""DescribeSLInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCnt: Total number of qualified instances	.
        :type TotalCnt: int
        :param _InstancesList: Instance information list. If pagination is applied, only the current page's instance information list is displayed.
        :type InstancesList: list of SLInstanceInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCnt = None
        self._InstancesList = None
        self._RequestId = None

    @property
    def TotalCnt(self):
        r"""Total number of qualified instances	.
        :rtype: int
        """
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def InstancesList(self):
        r"""Instance information list. If pagination is applied, only the current page's instance information list is displayed.
        :rtype: list of SLInstanceInfo
        """
        return self._InstancesList

    @InstancesList.setter
    def InstancesList(self, InstancesList):
        self._InstancesList = InstancesList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("InstancesList") is not None:
            self._InstancesList = []
            for item in params.get("InstancesList"):
                obj = SLInstanceInfo()
                obj._deserialize(item)
                self._InstancesList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSLInstanceRequest(AbstractModel):
    r"""DescribeSLInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance unique identifier (string).
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Instance unique identifier (string).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSLInstanceResponse(AbstractModel):
    r"""DescribeSLInstance response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Character string identifier of the instance.
        :type InstanceId: str
        :param _InstanceName: Instance name.
        :type InstanceName: str
        :param _PayMode: Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription.
        :type PayMode: int
        :param _DiskType: Instance storage type.
        :type DiskType: str
        :param _DiskSize: Instance single-node disk capacity, in GB.
        :type DiskSize: int
        :param _NodeType: Instance node specifications.
        :type NodeType: str
        :param _ZoneSettings: Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes.
        :type ZoneSettings: list of ZoneSetting
        :param _Tags: List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _ClusterId: Numeric identifier of the instance.
        :type ClusterId: int
        :param _RegionId: Instance region ID.
        :type RegionId: int
        :param _Zone: Primary AZ of the instance.
        :type Zone: str
        :param _ExpireTime: Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
        :type ExpireTime: str
        :param _IsolateTime: Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
        :type IsolateTime: str
        :param _CreateTime: Instance creation time.
        :type CreateTime: str
        :param _Status: Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED".
        :type Status: int
        :param _AutoRenewFlag: Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0.
        :type AutoRenewFlag: int
        :param _NodeNum: Total number of instance nodes.
        :type NodeNum: int
        :param _SLInstance: 
        :type SLInstance: list of SLInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._InstanceName = None
        self._PayMode = None
        self._DiskType = None
        self._DiskSize = None
        self._NodeType = None
        self._ZoneSettings = None
        self._Tags = None
        self._ClusterId = None
        self._RegionId = None
        self._Zone = None
        self._ExpireTime = None
        self._IsolateTime = None
        self._CreateTime = None
        self._Status = None
        self._AutoRenewFlag = None
        self._NodeNum = None
        self._SLInstance = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Character string identifier of the instance.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def PayMode(self):
        r"""Instance billing mode. 0 indicates postpaid, i.e., pay-as-you-go; 1 indicates prepaid, i.e., monthly subscription.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def DiskType(self):
        r"""Instance storage type.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DiskSize(self):
        r"""Instance single-node disk capacity, in GB.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def NodeType(self):
        r"""Instance node specifications.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def ZoneSettings(self):
        r"""Detailed configuration of the instance AZ, including the AZ name, VPC information, and number of nodes.
        :rtype: list of ZoneSetting
        """
        return self._ZoneSettings

    @ZoneSettings.setter
    def ZoneSettings(self, ZoneSettings):
        self._ZoneSettings = ZoneSettings

    @property
    def Tags(self):
        r"""List of tags bound to the instance.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ClusterId(self):
        r"""Numeric identifier of the instance.
        :rtype: int
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RegionId(self):
        r"""Instance region ID.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def Zone(self):
        r"""Primary AZ of the instance.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ExpireTime(self):
        r"""Instance expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def IsolateTime(self):
        r"""Instance isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
        :rtype: str
        """
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def CreateTime(self):
        r"""Instance creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        r"""Instance status code: -2: "TERMINATED", 2: "RUNNING", 14: "TERMINATING", 19: "ISOLATING", 22: "ADJUSTING", and 201: "ISOLATED".
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AutoRenewFlag(self):
        r"""Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is 0.
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def NodeNum(self):
        r"""Total number of instance nodes.
        :rtype: int
        """
        return self._NodeNum

    @NodeNum.setter
    def NodeNum(self, NodeNum):
        self._NodeNum = NodeNum

    @property
    def SLInstance(self):
        r"""
        :rtype: list of SLInstance
        """
        return self._SLInstance

    @SLInstance.setter
    def SLInstance(self, SLInstance):
        self._SLInstance = SLInstance

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._PayMode = params.get("PayMode")
        self._DiskType = params.get("DiskType")
        self._DiskSize = params.get("DiskSize")
        self._NodeType = params.get("NodeType")
        if params.get("ZoneSettings") is not None:
            self._ZoneSettings = []
            for item in params.get("ZoneSettings"):
                obj = ZoneSetting()
                obj._deserialize(item)
                self._ZoneSettings.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ClusterId = params.get("ClusterId")
        self._RegionId = params.get("RegionId")
        self._Zone = params.get("Zone")
        self._ExpireTime = params.get("ExpireTime")
        self._IsolateTime = params.get("IsolateTime")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._NodeNum = params.get("NodeNum")
        if params.get("SLInstance") is not None:
            self._SLInstance = []
            for item in params.get("SLInstance"):
                obj = SLInstance()
                obj._deserialize(item)
                self._SLInstance.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServiceConfGroupInfosRequest(AbstractModel):
    r"""DescribeServiceConfGroupInfos request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _ServiceName: Component name.
        :type ServiceName: str
        :param _ConfGroupName: Configuration group name.
        :type ConfGroupName: str
        :param _PageNo: Page number, starting from 1.
        :type PageNo: int
        :param _PageSize: Page size.
        :type PageSize: int
        """
        self._InstanceId = None
        self._ServiceName = None
        self._ConfGroupName = None
        self._PageNo = None
        self._PageSize = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ServiceName(self):
        r"""Component name.
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def ConfGroupName(self):
        r"""Configuration group name.
        :rtype: str
        """
        return self._ConfGroupName

    @ConfGroupName.setter
    def ConfGroupName(self, ConfGroupName):
        self._ConfGroupName = ConfGroupName

    @property
    def PageNo(self):
        r"""Page number, starting from 1.
        :rtype: int
        """
        return self._PageNo

    @PageNo.setter
    def PageNo(self, PageNo):
        self._PageNo = PageNo

    @property
    def PageSize(self):
        r"""Page size.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ServiceName = params.get("ServiceName")
        self._ConfGroupName = params.get("ConfGroupName")
        self._PageNo = params.get("PageNo")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceConfGroupInfosResponse(AbstractModel):
    r"""DescribeServiceConfGroupInfos response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: List size.
        :type TotalCount: int
        :param _ConfItemKVList: Configuration item key-value list.
        :type ConfItemKVList: list of ConfigurationItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ConfItemKVList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""List size.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ConfItemKVList(self):
        r"""Configuration item key-value list.
        :rtype: list of ConfigurationItem
        """
        return self._ConfItemKVList

    @ConfItemKVList.setter
    def ConfItemKVList(self, ConfItemKVList):
        self._ConfItemKVList = ConfItemKVList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ConfItemKVList") is not None:
            self._ConfItemKVList = []
            for item in params.get("ConfItemKVList"):
                obj = ConfigurationItem()
                obj._deserialize(item)
                self._ConfItemKVList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServiceNodeInfosRequest(AbstractModel):
    r"""DescribeServiceNodeInfos request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _Offset: Page number.
        :type Offset: int
        :param _Limit: Page size.
        :type Limit: int
        :param _SearchText: Searching fields.
        :type SearchText: str
        :param _ConfStatus: Configuration status. -2: configuration failed; -1: configuration expired; 1: synchronized; -99: all.
        :type ConfStatus: int
        :param _MaintainStateId: Filter criteria: Maintenance status

0 indicates all statuses.
1 indicates normal.
2 indicates the maintenance status.

        :type MaintainStateId: int
        :param _OperatorStateId: Filter criteria: Operation status

0 indicates all statuses.
1 indicates started.
2 indicates stopped.
        :type OperatorStateId: int
        :param _HealthStateId: Filter criteria: health status.
0 indicates unavailable.
1 indicates good.
-2 indicates unknown.
-99 indicates all.
-3 indicates potential risks.
-4 indicates undetected.
        :type HealthStateId: str
        :param _ServiceName: Service component names (in all caps, for example, YARN).
        :type ServiceName: str
        :param _NodeTypeName: Node names: master, core, task, common, and router.
        :type NodeTypeName: str
        :param _DataNodeMaintenanceId: Filter criteria: whether DN is in the maintenance status.
0 indicates all statuses.
1 indicates the maintenance status.
        :type DataNodeMaintenanceId: int
        :param _SearchFields: Searchable fields (currently supported SearchType: ipv4).
        :type SearchFields: list of SearchItem
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._SearchText = None
        self._ConfStatus = None
        self._MaintainStateId = None
        self._OperatorStateId = None
        self._HealthStateId = None
        self._ServiceName = None
        self._NodeTypeName = None
        self._DataNodeMaintenanceId = None
        self._SearchFields = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""Page number.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page size.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchText(self):
        r"""Searching fields.
        :rtype: str
        """
        return self._SearchText

    @SearchText.setter
    def SearchText(self, SearchText):
        self._SearchText = SearchText

    @property
    def ConfStatus(self):
        r"""Configuration status. -2: configuration failed; -1: configuration expired; 1: synchronized; -99: all.
        :rtype: int
        """
        return self._ConfStatus

    @ConfStatus.setter
    def ConfStatus(self, ConfStatus):
        self._ConfStatus = ConfStatus

    @property
    def MaintainStateId(self):
        r"""Filter criteria: Maintenance status

0 indicates all statuses.
1 indicates normal.
2 indicates the maintenance status.

        :rtype: int
        """
        return self._MaintainStateId

    @MaintainStateId.setter
    def MaintainStateId(self, MaintainStateId):
        self._MaintainStateId = MaintainStateId

    @property
    def OperatorStateId(self):
        r"""Filter criteria: Operation status

0 indicates all statuses.
1 indicates started.
2 indicates stopped.
        :rtype: int
        """
        return self._OperatorStateId

    @OperatorStateId.setter
    def OperatorStateId(self, OperatorStateId):
        self._OperatorStateId = OperatorStateId

    @property
    def HealthStateId(self):
        r"""Filter criteria: health status.
0 indicates unavailable.
1 indicates good.
-2 indicates unknown.
-99 indicates all.
-3 indicates potential risks.
-4 indicates undetected.
        :rtype: str
        """
        return self._HealthStateId

    @HealthStateId.setter
    def HealthStateId(self, HealthStateId):
        self._HealthStateId = HealthStateId

    @property
    def ServiceName(self):
        r"""Service component names (in all caps, for example, YARN).
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def NodeTypeName(self):
        r"""Node names: master, core, task, common, and router.
        :rtype: str
        """
        return self._NodeTypeName

    @NodeTypeName.setter
    def NodeTypeName(self, NodeTypeName):
        self._NodeTypeName = NodeTypeName

    @property
    def DataNodeMaintenanceId(self):
        r"""Filter criteria: whether DN is in the maintenance status.
0 indicates all statuses.
1 indicates the maintenance status.
        :rtype: int
        """
        return self._DataNodeMaintenanceId

    @DataNodeMaintenanceId.setter
    def DataNodeMaintenanceId(self, DataNodeMaintenanceId):
        self._DataNodeMaintenanceId = DataNodeMaintenanceId

    @property
    def SearchFields(self):
        r"""Searchable fields (currently supported SearchType: ipv4).
        :rtype: list of SearchItem
        """
        return self._SearchFields

    @SearchFields.setter
    def SearchFields(self, SearchFields):
        self._SearchFields = SearchFields


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchText = params.get("SearchText")
        self._ConfStatus = params.get("ConfStatus")
        self._MaintainStateId = params.get("MaintainStateId")
        self._OperatorStateId = params.get("OperatorStateId")
        self._HealthStateId = params.get("HealthStateId")
        self._ServiceName = params.get("ServiceName")
        self._NodeTypeName = params.get("NodeTypeName")
        self._DataNodeMaintenanceId = params.get("DataNodeMaintenanceId")
        if params.get("SearchFields") is not None:
            self._SearchFields = []
            for item in params.get("SearchFields"):
                obj = SearchItem()
                obj._deserialize(item)
                self._SearchFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceNodeInfosResponse(AbstractModel):
    r"""DescribeServiceNodeInfos response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCnt: Total number.
        :type TotalCnt: int
        :param _ServiceNodeList: Process information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceNodeList: list of ServiceNodeDetailInfo
        :param _AliasInfo: Alias serialization of all nodes in the cluster.
        :type AliasInfo: str
        :param _SupportNodeFlagFilterList: Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained.
        :type SupportNodeFlagFilterList: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCnt = None
        self._ServiceNodeList = None
        self._AliasInfo = None
        self._SupportNodeFlagFilterList = None
        self._RequestId = None

    @property
    def TotalCnt(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def ServiceNodeList(self):
        r"""Process information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ServiceNodeDetailInfo
        """
        return self._ServiceNodeList

    @ServiceNodeList.setter
    def ServiceNodeList(self, ServiceNodeList):
        self._ServiceNodeList = ServiceNodeList

    @property
    def AliasInfo(self):
        r"""Alias serialization of all nodes in the cluster.
        :rtype: str
        """
        return self._AliasInfo

    @AliasInfo.setter
    def AliasInfo(self, AliasInfo):
        self._AliasInfo = AliasInfo

    @property
    def SupportNodeFlagFilterList(self):
        r"""Supported FlagNode list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SupportNodeFlagFilterList

    @SupportNodeFlagFilterList.setter
    def SupportNodeFlagFilterList(self, SupportNodeFlagFilterList):
        self._SupportNodeFlagFilterList = SupportNodeFlagFilterList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("ServiceNodeList") is not None:
            self._ServiceNodeList = []
            for item in params.get("ServiceNodeList"):
                obj = ServiceNodeDetailInfo()
                obj._deserialize(item)
                self._ServiceNodeList.append(obj)
        self._AliasInfo = params.get("AliasInfo")
        self._SupportNodeFlagFilterList = params.get("SupportNodeFlagFilterList")
        self._RequestId = params.get("RequestId")


class DescribeSparkApplicationsRequest(AbstractModel):
    r"""DescribeSparkApplications request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Querying start time.
        :type StartTime: int
        :param _EndTime: Querying end time.
        :type EndTime: int
        :param _PageSize: Number of entries per page.
        :type PageSize: int
        :param _Page: Which page.
        :type Page: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._PageSize = None
        self._Page = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Querying start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Querying end time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PageSize(self):
        r"""Number of entries per page.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Page(self):
        r"""Which page.
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PageSize = params.get("PageSize")
        self._Page = params.get("Page")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkApplicationsResponse(AbstractModel):
    r"""DescribeSparkApplications response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The number of returns.
        :type TotalCount: int
        :param _ResultList: Spark application list.
        :type ResultList: list of SparkApplicationsList
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ResultList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The number of returns.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ResultList(self):
        r"""Spark application list.
        :rtype: list of SparkApplicationsList
        """
        return self._ResultList

    @ResultList.setter
    def ResultList(self, ResultList):
        self._ResultList = ResultList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ResultList") is not None:
            self._ResultList = []
            for item in params.get("ResultList"):
                obj = SparkApplicationsList()
                obj._deserialize(item)
                self._ResultList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSparkQueriesRequest(AbstractModel):
    r"""DescribeSparkQueries request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Start time.
        :type StartTime: int
        :param _EndTime: End time.
        :type EndTime: int
        :param _Offset: Starting offset for pages, starting from 0.
        :type Offset: int
        :param _Limit: Page size. Valid range: [1,100].
        :type Limit: int
        :param _Status: Execution status: RUNNING,COMPLETED, FAILED.
        :type Status: list of str
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._Status = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""Starting offset for pages, starting from 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Page size. Valid range: [1,100].
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Status(self):
        r"""Execution status: RUNNING,COMPLETED, FAILED.
        :rtype: list of str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkQueriesResponse(AbstractModel):
    r"""DescribeSparkQueries response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
        :type Total: int
        :param _Results: Result list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Results: list of SparkQuery
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Results = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Results(self):
        r"""Result list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SparkQuery
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = SparkQuery()
                obj._deserialize(item)
                self._Results.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStarRocksQueryInfoRequest(AbstractModel):
    r"""DescribeStarRocksQueryInfo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Query information obtainment start time (seconds).
        :type StartTime: int
        :param _EndTime: Query information obtainment end time (seconds).
        :type EndTime: int
        :param _PageSize: Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :type PageSize: int
        :param _Page: Page number for pagination queries, starting from 1.
        :type Page: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._PageSize = None
        self._Page = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Query information obtainment start time (seconds).
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Query information obtainment end time (seconds).
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PageSize(self):
        r"""Page size for pagination query. The minimum value is 1, and the maximum value is 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Page(self):
        r"""Page number for pagination queries, starting from 1.
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PageSize = params.get("PageSize")
        self._Page = params.get("Page")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStarRocksQueryInfoResponse(AbstractModel):
    r"""DescribeStarRocksQueryInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number, which is used for pagination query.
        :type TotalCount: int
        :param _StarRocksQueryInfoList: StarRocks information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StarRocksQueryInfoList: list of StarRocksQueryInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._StarRocksQueryInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number, which is used for pagination query.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def StarRocksQueryInfoList(self):
        r"""StarRocks information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of StarRocksQueryInfo
        """
        return self._StarRocksQueryInfoList

    @StarRocksQueryInfoList.setter
    def StarRocksQueryInfoList(self, StarRocksQueryInfoList):
        self._StarRocksQueryInfoList = StarRocksQueryInfoList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("StarRocksQueryInfoList") is not None:
            self._StarRocksQueryInfoList = []
            for item in params.get("StarRocksQueryInfoList"):
                obj = StarRocksQueryInfo()
                obj._deserialize(item)
                self._StarRocksQueryInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTrinoQueryInfoRequest(AbstractModel):
    r"""DescribeTrinoQueryInfo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Obtain the start time for querying information (s).
        :type StartTime: int
        :param _EndTime: Obtain the end time for querying information (s).
        :type EndTime: int
        :param _PageSize: Page size for pagination queries. Minimum value: 1; maximum value: 100.
        :type PageSize: int
        :param _Page: Page number for pagination queries, starting from 1.
        :type Page: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._PageSize = None
        self._Page = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Obtain the start time for querying information (s).
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Obtain the end time for querying information (s).
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PageSize(self):
        r"""Page size for pagination queries. Minimum value: 1; maximum value: 100.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Page(self):
        r"""Page number for pagination queries, starting from 1.
        :rtype: int
        """
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PageSize = params.get("PageSize")
        self._Page = params.get("Page")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrinoQueryInfoResponse(AbstractModel):
    r"""DescribeTrinoQueryInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number, which is used for pagination query.
        :type TotalCount: int
        :param _QueryInfoList: Query result array.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QueryInfoList: list of TrinoQueryInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._QueryInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number, which is used for pagination query.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QueryInfoList(self):
        r"""Query result array.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TrinoQueryInfo
        """
        return self._QueryInfoList

    @QueryInfoList.setter
    def QueryInfoList(self, QueryInfoList):
        self._QueryInfoList = QueryInfoList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QueryInfoList") is not None:
            self._QueryInfoList = []
            for item in params.get("QueryInfoList"):
                obj = TrinoQueryInfo()
                obj._deserialize(item)
                self._QueryInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUsersForUserManagerRequest(AbstractModel):
    r"""DescribeUsersForUserManager request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID
        :type InstanceId: str
        :param _PageNo: Page number
        :type PageNo: int
        :param _PageSize: Pagination size.
All are queried by default. If the PageNo and PageSize settings are inappropriate, all are queried.
        :type PageSize: int
        :param _UserManagerFilter: User list query filter
        :type UserManagerFilter: :class:`tencentcloud.emr.v20190103.models.UserManagerFilter`
        :param _NeedKeytabInfo: Whether the Keytab file information is required. This field is only valid for clusters with Kerberos enabled and defaults to `false`.
        :type NeedKeytabInfo: bool
        """
        self._InstanceId = None
        self._PageNo = None
        self._PageSize = None
        self._UserManagerFilter = None
        self._NeedKeytabInfo = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PageNo(self):
        r"""Page number
        :rtype: int
        """
        return self._PageNo

    @PageNo.setter
    def PageNo(self, PageNo):
        self._PageNo = PageNo

    @property
    def PageSize(self):
        r"""Pagination size.
All are queried by default. If the PageNo and PageSize settings are inappropriate, all are queried.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def UserManagerFilter(self):
        r"""User list query filter
        :rtype: :class:`tencentcloud.emr.v20190103.models.UserManagerFilter`
        """
        return self._UserManagerFilter

    @UserManagerFilter.setter
    def UserManagerFilter(self, UserManagerFilter):
        self._UserManagerFilter = UserManagerFilter

    @property
    def NeedKeytabInfo(self):
        r"""Whether the Keytab file information is required. This field is only valid for clusters with Kerberos enabled and defaults to `false`.
        :rtype: bool
        """
        return self._NeedKeytabInfo

    @NeedKeytabInfo.setter
    def NeedKeytabInfo(self, NeedKeytabInfo):
        self._NeedKeytabInfo = NeedKeytabInfo


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._PageNo = params.get("PageNo")
        self._PageSize = params.get("PageSize")
        if params.get("UserManagerFilter") is not None:
            self._UserManagerFilter = UserManagerFilter()
            self._UserManagerFilter._deserialize(params.get("UserManagerFilter"))
        self._NeedKeytabInfo = params.get("NeedKeytabInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsersForUserManagerResponse(AbstractModel):
    r"""DescribeUsersForUserManager response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCnt: Total number
        :type TotalCnt: int
        :param _UserManagerUserList: User information list
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserManagerUserList: list of UserManagerUserBriefInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCnt = None
        self._UserManagerUserList = None
        self._RequestId = None

    @property
    def TotalCnt(self):
        r"""Total number
        :rtype: int
        """
        return self._TotalCnt

    @TotalCnt.setter
    def TotalCnt(self, TotalCnt):
        self._TotalCnt = TotalCnt

    @property
    def UserManagerUserList(self):
        r"""User information list
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of UserManagerUserBriefInfo
        """
        return self._UserManagerUserList

    @UserManagerUserList.setter
    def UserManagerUserList(self, UserManagerUserList):
        self._UserManagerUserList = UserManagerUserList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCnt = params.get("TotalCnt")
        if params.get("UserManagerUserList") is not None:
            self._UserManagerUserList = []
            for item in params.get("UserManagerUserList"):
                obj = UserManagerUserBriefInfo()
                obj._deserialize(item)
                self._UserManagerUserList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeYarnQueueRequest(AbstractModel):
    r"""DescribeYarnQueue request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID
        :type InstanceId: str
        :param _Scheduler: Scheduler. The values are as follows:

1. capacity
2. fair
        :type Scheduler: str
        """
        self._InstanceId = None
        self._Scheduler = None

    @property
    def InstanceId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Scheduler(self):
        r"""Scheduler. The values are as follows:

1. capacity
2. fair
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Scheduler = params.get("Scheduler")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeYarnQueueResponse(AbstractModel):
    r"""DescribeYarnQueue response structure.

    """

    def __init__(self):
        r"""
        :param _Queue: Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```.
        :type Queue: str
        :param _Version: Version
        :type Version: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Queue = None
        self._Version = None
        self._RequestId = None

    @property
    def Queue(self):
        r"""Queue information. It is a JSON string into which an object is converted. The corresponding Golang structure is as follows. For example, the first field `Name` of `QueueWithConfigSetForFairScheduler: ```Name                         string                               `json:"name"` //queue name ```  - `Name: field name - `string`: field type - `json:"name`:  indicates the corresponding `json key` during serialization/deserialization. Below, `json key` is used for referring.- `//`: the following comment content corresponds to the Name field seen on the page. Fields with types starting with `*` indicate that the value may be null under JSON specifications. Different languages need to be received through a type that can express null, such as Java's wrapper types. Fields with types starting with `[]` indicate an array type, which is used when `json key` calls `ModifyYarnQueueV2` API. - fair scheduler```type QueueWithConfigSetForFairScheduler struct {	Name                         string                               `json:"name"` //queue name MyId                         string                  `json:"myId"` // queue id, used for editing, deleting, and cloning	ParentId                     string                  `json:"parentId"`  // Parent queue Id	Type                         *string                              `json:"type"` // queue affinity. Parent or empty. Setting to be a parent or empty can be performed only when it is confirmed that a queue is a parent queue and has no subqueues. The queue is normally used to support the placement policy nestedUserQueue	AclSubmitApps                *AclForYarnQueue                     `json:"aclSubmitApps"` // submission access control	AclAdministerApps            *AclForYarnQueue                     `json:"aclAdministerApps"` // management access control	MinSharePreemptionTimeout    *int                                 `json:"minSharePreemptionTimeout"` // minimum share preemption timeout period	FairSharePreemptionTimeout   *int                                 `json:"fairSharePreemptionTimeout"` // fair share preemption timeout period	FairSharePreemptionThreshold *float32                             `json:"fairSharePreemptionThreshold"` // fair share preemption threshold. Value range (0, 1]	AllowPreemptionFrom          *bool                                `json:"allowPreemptionFrom"`                                        // preemption mode	SchedulingPolicy             *string                              `json:"schedulingPolicy"`  // scheduling policy with the valid values of drf, fair, and fifo	IsDefault                    *bool                                `json:"isDefault"` // whether it is the root.default queue	IsRoot                       *bool                                `json:"isRoot"` // whether it is the root queue	ConfigSets                   []ConfigSetForFairScheduler          `json:"configSets"` // configuration set settings	Children                     []QueueWithConfigSetForFairScheduler `json:"queues"` // subqueue information. recursive}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}type ConfigSetForFairScheduler struct {	Name              string        `json:"name"` // configuration set name	MinResources      *YarnResource `json:"minResources"` // minimum resource amount	MaxResources      *YarnResource `json:"maxResources"` // maximum resource amount	MaxChildResources *YarnResource `json:"maxChildResources"` //.The maximum quantity of resources that can be allocated to undefined subqueues	MaxRunningApps    *int          `json:"maxRunningApps"` // the maximum number of apps that can run concurrently	Weight            *float32      `json:"weight"`                   // Weight	MaxAMShare        *float32      `json:"maxAMShare"` // App Master maximum share}type YarnResource struct {	Vcores *int `json:"vcores"`	Memory *int `json:"memory"`	Type *string `json:"type"` // when the value is `percent`, it indicates usage as a percentage, otherwise an absolute value is used indeed}```- Capacity scheduler```type QueueForCapacitySchedulerV3 struct {	Name                       string                `json:"name"` // queue name	MyId                       string                `json:"myId"` // queue id, used in the case of editing, deleting, or cloning	ParentId                   string                `json:"parentId"` // parent queue id 	Configs                    []ConfigForCapacityV3 `json:"configs"` //configuration set settings	State                      *string         `json:"state"` // resource pool status	DefaultNodeLabelExpression *string               `json:"default-node-label-expression"` // default tag expression	AclSubmitApps              *AclForYarnQueue      `json:"acl_submit_applications"` // submission access control 	AclAdminQueue              *AclForYarnQueue      `json:"acl_administer_queue"` //management access control	MaxAllocationMB *int32 `json:"maximum-allocation-mb"` // maximum Memory allocated to Container	MaxAllocationVcores *int32                         `json:"maximum-allocation-vcores"` // the maximum number of Vcores for Container	IsDefault           *bool                          `json:"isDefault"`// whether it is the root.default queue	IsRoot              *bool                          `json:"isRoot"` // whether it is the root queue	Queues              []*QueueForCapacitySchedulerV3 `json:"queues"`//subqueue information. Recursive}type ConfigForCapacityV3 struct {	Name                string          `json:"configName"` // configuration set name	Labels              []CapacityLabel `json:"labels"` // tag information	MinUserLimitPercent *int32          `json:"minimum-user-limit-percent"` // minimum user capacity	UserLimitFactor     *float32        `json:"user-limit-factor" valid:"rangeExcludeLeft(0|)"`  // user resource factor	MaxApps *int32 `json:"maximum-applications" valid:"rangeExcludeLeft(0|)"` // the maximum number of applications Max-Applications	MaxAmPercent               *float32 `json:"maximum-am-resource-percent"` // the maximum AM ratio	DefaultApplicationPriority *int32   `json:"default-application-priority"` // resource pool priority}type CapacityLabel struct {	Name        string   `json:"labelName"`	Capacity    *float32 `json:"capacity"`  // capacity MaxCapacity *float32 `json:"maximum-capacity"` //maximum capacity}type AclForYarnQueue struct {	User  *string `json:"user"` //username	Group *string `json:"group"`//group name}```.
        :rtype: str
        """
        return self._Queue

    @Queue.setter
    def Queue(self, Queue):
        self._Queue = Queue

    @property
    def Version(self):
        r"""Version
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Queue = params.get("Queue")
        self._Version = params.get("Version")
        self._RequestId = params.get("RequestId")


class DescribeYarnScheduleHistoryRequest(AbstractModel):
    r"""DescribeYarnScheduleHistory request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _StartTime: Start time
        :type StartTime: int
        :param _EndTime: End time
        :type EndTime: int
        :param _Limit: Page number.
        :type Limit: int
        :param _Offset: Page size.
        :type Offset: int
        :param _SchedulerType: Scheduler type. The values are ALL, Capacity Scheduler, and Fair Scheduler.
        :type SchedulerType: str
        :param _TaskState: Task type. 0: waiting; 1: executing; 2: completed; -1: failed; -99: all.
        :type TaskState: int
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._SchedulerType = None
        self._TaskState = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Start time
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""Page number.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Page size.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SchedulerType(self):
        r"""Scheduler type. The values are ALL, Capacity Scheduler, and Fair Scheduler.
        :rtype: str
        """
        return self._SchedulerType

    @SchedulerType.setter
    def SchedulerType(self, SchedulerType):
        self._SchedulerType = SchedulerType

    @property
    def TaskState(self):
        r"""Task type. 0: waiting; 1: executing; 2: completed; -1: failed; -99: all.
        :rtype: int
        """
        return self._TaskState

    @TaskState.setter
    def TaskState(self, TaskState):
        self._TaskState = TaskState


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SchedulerType = params.get("SchedulerType")
        self._TaskState = params.get("TaskState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeYarnScheduleHistoryResponse(AbstractModel):
    r"""DescribeYarnScheduleHistory response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Tasks: list of SchedulerTaskInfo
        :param _Total: Total quantity of task details.
        :type Total: int
        :param _SchedulerNameList: Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained.
        :type SchedulerNameList: list of str
        :param _StateList: Status filter list

Note: This field may return null, indicating that no valid values can be obtained.
        :type StateList: list of int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._Total = None
        self._SchedulerNameList = None
        self._StateList = None
        self._RequestId = None

    @property
    def Tasks(self):
        r"""Task details.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SchedulerTaskInfo
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def Total(self):
        r"""Total quantity of task details.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def SchedulerNameList(self):
        r"""Scheduling type filter list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SchedulerNameList

    @SchedulerNameList.setter
    def SchedulerNameList(self, SchedulerNameList):
        self._SchedulerNameList = SchedulerNameList

    @property
    def StateList(self):
        r"""Status filter list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = SchedulerTaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._Total = params.get("Total")
        self._SchedulerNameList = params.get("SchedulerNameList")
        self._StateList = params.get("StateList")
        self._RequestId = params.get("RequestId")


class DiffDetail(AbstractModel):
    r"""Dynamically generated change details.

    """

    def __init__(self):
        r"""
        :param _Name: Tab page header.
        :type Name: str
        :param _Count: Number of change items.
        :type Count: int
        :param _Rows: Detailed data to be rendered.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Rows: list of DiffDetailItem
        :param _Header: Header information to be rendered.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Header: list of DiffHeader
        """
        self._Name = None
        self._Count = None
        self._Rows = None
        self._Header = None

    @property
    def Name(self):
        r"""Tab page header.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Count(self):
        r"""Number of change items.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Rows(self):
        r"""Detailed data to be rendered.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DiffDetailItem
        """
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def Header(self):
        r"""Header information to be rendered.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DiffHeader
        """
        return self._Header

    @Header.setter
    def Header(self, Header):
        self._Header = Header


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Count = params.get("Count")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DiffDetailItem()
                obj._deserialize(item)
                self._Rows.append(obj)
        if params.get("Header") is not None:
            self._Header = []
            for item in params.get("Header"):
                obj = DiffHeader()
                obj._deserialize(item)
                self._Header.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DiffDetailItem(AbstractModel):
    r"""Dynamically generated change detail entries.

    """

    def __init__(self):
        r"""
        :param _Attribute: Attribute.
        :type Attribute: str
        :param _InEffect: Currently effective.
        :type InEffect: str
        :param _PendingEffectiveness: To be effective.
        :type PendingEffectiveness: str
        :param _Operation: Operation.
        :type Operation: str
        :param _Queue: Queue.
        :type Queue: str
        :param _ConfigSet: Configuration set.
        :type ConfigSet: str
        :param _LabelName: Tag.
        :type LabelName: str
        :param _InEffectIndex: Current position.
        :type InEffectIndex: str
        :param _PendingEffectIndex: Position to be effective.
        :type PendingEffectIndex: str
        :param _PlanName: Plan mode name.
        :type PlanName: str
        :param _Label: Tag.
        :type Label: str
        :param _RuleName: Placement rule.
        :type RuleName: str
        :param _UserName: Username.
        :type UserName: str
        """
        self._Attribute = None
        self._InEffect = None
        self._PendingEffectiveness = None
        self._Operation = None
        self._Queue = None
        self._ConfigSet = None
        self._LabelName = None
        self._InEffectIndex = None
        self._PendingEffectIndex = None
        self._PlanName = None
        self._Label = None
        self._RuleName = None
        self._UserName = None

    @property
    def Attribute(self):
        r"""Attribute.
        :rtype: str
        """
        return self._Attribute

    @Attribute.setter
    def Attribute(self, Attribute):
        self._Attribute = Attribute

    @property
    def InEffect(self):
        r"""Currently effective.
        :rtype: str
        """
        return self._InEffect

    @InEffect.setter
    def InEffect(self, InEffect):
        self._InEffect = InEffect

    @property
    def PendingEffectiveness(self):
        r"""To be effective.
        :rtype: str
        """
        return self._PendingEffectiveness

    @PendingEffectiveness.setter
    def PendingEffectiveness(self, PendingEffectiveness):
        self._PendingEffectiveness = PendingEffectiveness

    @property
    def Operation(self):
        r"""Operation.
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def Queue(self):
        r"""Queue.
        :rtype: str
        """
        return self._Queue

    @Queue.setter
    def Queue(self, Queue):
        self._Queue = Queue

    @property
    def ConfigSet(self):
        r"""Configuration set.
        :rtype: str
        """
        return self._ConfigSet

    @ConfigSet.setter
    def ConfigSet(self, ConfigSet):
        self._ConfigSet = ConfigSet

    @property
    def LabelName(self):
        r"""Tag.
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def InEffectIndex(self):
        r"""Current position.
        :rtype: str
        """
        return self._InEffectIndex

    @InEffectIndex.setter
    def InEffectIndex(self, InEffectIndex):
        self._InEffectIndex = InEffectIndex

    @property
    def PendingEffectIndex(self):
        r"""Position to be effective.
        :rtype: str
        """
        return self._PendingEffectIndex

    @PendingEffectIndex.setter
    def PendingEffectIndex(self, PendingEffectIndex):
        self._PendingEffectIndex = PendingEffectIndex

    @property
    def PlanName(self):
        r"""Plan mode name.
        :rtype: str
        """
        return self._PlanName

    @PlanName.setter
    def PlanName(self, PlanName):
        self._PlanName = PlanName

    @property
    def Label(self):
        r"""Tag.
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def RuleName(self):
        r"""Placement rule.
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def UserName(self):
        r"""Username.
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName


    def _deserialize(self, params):
        self._Attribute = params.get("Attribute")
        self._InEffect = params.get("InEffect")
        self._PendingEffectiveness = params.get("PendingEffectiveness")
        self._Operation = params.get("Operation")
        self._Queue = params.get("Queue")
        self._ConfigSet = params.get("ConfigSet")
        self._LabelName = params.get("LabelName")
        self._InEffectIndex = params.get("InEffectIndex")
        self._PendingEffectIndex = params.get("PendingEffectIndex")
        self._PlanName = params.get("PlanName")
        self._Label = params.get("Label")
        self._RuleName = params.get("RuleName")
        self._UserName = params.get("UserName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DiffHeader(AbstractModel):
    r"""Dynamically generated change details.

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Id: ID, which is used by the front end.
        :type Id: str
        """
        self._Name = None
        self._Id = None

    @property
    def Name(self):
        r"""Name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Id(self):
        r"""ID, which is used by the front end.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DiskSpecInfo(AbstractModel):
    r"""Node disk information

    """

    def __init__(self):
        r"""
        :param _Count: Number of disks.
        :type Count: int
        :param _DiskType: Valid values of the system disk type:
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_BASIC: Cloud Disk.</li>
<li>LOCAL_BASIC: Local Disk.</li>
<li>LOCAL_SSD: Local SSD.</li>

Valid values of the data disk type.
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_BASIC: Cloud Disk.</li>
<li>LOCAL_BASIC: Local Disk.</li>
<li>LOCAL_SSD: Local SSD.</li>
<li>CLOUD_HSSD: Enhanced SSD.</li>
<li>CLOUD_THROUGHPUT: Throughput HDD.</li>
<li>CLOUD_TSSD: Tremendous SSD.</li>
<li>CLOUD_BIGDATA: Big Data Cloud Disk.</li>
<li>CLOUD_HIGHIO: High IO Cloud Disk.</li>
<li>CLOUD_BSSD: Balanced SSD.</li>
<li>REMOTE_SSD: Remote SSD.</li>

        :type DiskType: str
        :param _DiskSize: Data capacity in GB.
        :type DiskSize: int
        :param _ExtraPerformance: Additional performance.
        :type ExtraPerformance: int
        """
        self._Count = None
        self._DiskType = None
        self._DiskSize = None
        self._ExtraPerformance = None

    @property
    def Count(self):
        r"""Number of disks.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def DiskType(self):
        r"""Valid values of the system disk type:
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_BASIC: Cloud Disk.</li>
<li>LOCAL_BASIC: Local Disk.</li>
<li>LOCAL_SSD: Local SSD.</li>

Valid values of the data disk type.
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_BASIC: Cloud Disk.</li>
<li>LOCAL_BASIC: Local Disk.</li>
<li>LOCAL_SSD: Local SSD.</li>
<li>CLOUD_HSSD: Enhanced SSD.</li>
<li>CLOUD_THROUGHPUT: Throughput HDD.</li>
<li>CLOUD_TSSD: Tremendous SSD.</li>
<li>CLOUD_BIGDATA: Big Data Cloud Disk.</li>
<li>CLOUD_HIGHIO: High IO Cloud Disk.</li>
<li>CLOUD_BSSD: Balanced SSD.</li>
<li>REMOTE_SSD: Remote SSD.</li>

        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DiskSize(self):
        r"""Data capacity in GB.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def ExtraPerformance(self):
        r"""Additional performance.
        :rtype: int
        """
        return self._ExtraPerformance

    @ExtraPerformance.setter
    def ExtraPerformance(self, ExtraPerformance):
        self._ExtraPerformance = ExtraPerformance


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._DiskType = params.get("DiskType")
        self._DiskSize = params.get("DiskSize")
        self._ExtraPerformance = params.get("ExtraPerformance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Dps(AbstractModel):
    r"""Sampling sequence.

    """

    def __init__(self):
        r"""
        :param _Timestamp: Timestamp.
        :type Timestamp: str
        :param _Value: Sampling value.
        :type Value: str
        """
        self._Timestamp = None
        self._Value = None

    @property
    def Timestamp(self):
        r"""Timestamp.
        :rtype: str
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Value(self):
        r"""Sampling value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DynamicPodSpec(AbstractModel):
    r"""Pod floating specification

    """

    def __init__(self):
        r"""
        :param _RequestCpu: Minimum number of CPUs
        :type RequestCpu: float
        :param _LimitCpu: Maximum number of CPUs
        :type LimitCpu: float
        :param _RequestMemory: Minimum memory in MB
        :type RequestMemory: float
        :param _LimitMemory: Maximum memory in MB
        :type LimitMemory: float
        """
        self._RequestCpu = None
        self._LimitCpu = None
        self._RequestMemory = None
        self._LimitMemory = None

    @property
    def RequestCpu(self):
        r"""Minimum number of CPUs
        :rtype: float
        """
        return self._RequestCpu

    @RequestCpu.setter
    def RequestCpu(self, RequestCpu):
        self._RequestCpu = RequestCpu

    @property
    def LimitCpu(self):
        r"""Maximum number of CPUs
        :rtype: float
        """
        return self._LimitCpu

    @LimitCpu.setter
    def LimitCpu(self, LimitCpu):
        self._LimitCpu = LimitCpu

    @property
    def RequestMemory(self):
        r"""Minimum memory in MB
        :rtype: float
        """
        return self._RequestMemory

    @RequestMemory.setter
    def RequestMemory(self, RequestMemory):
        self._RequestMemory = RequestMemory

    @property
    def LimitMemory(self):
        r"""Maximum memory in MB
        :rtype: float
        """
        return self._LimitMemory

    @LimitMemory.setter
    def LimitMemory(self, LimitMemory):
        self._LimitMemory = LimitMemory


    def _deserialize(self, params):
        self._RequestCpu = params.get("RequestCpu")
        self._LimitCpu = params.get("LimitCpu")
        self._RequestMemory = params.get("RequestMemory")
        self._LimitMemory = params.get("LimitMemory")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmrListInstance(AbstractModel):
    r"""Returned cluster list sample

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _StatusDesc: Common status: cluster in production, cluster running, cluster creating, cluster closed, and cluster deleted.
        :type StatusDesc: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _ZoneId: Cluster region
        :type ZoneId: int
        :param _AppId: User APPID
        :type AppId: int
        :param _AddTime: Creation time
        :type AddTime: str
        :param _RunTime: Running time
        :type RunTime: str
        :param _MasterIp: Cluster IP
        :type MasterIp: str
        :param _EmrVersion: Cluster version
        :type EmrVersion: str
        :param _ChargeType: Cluster billing mode
        :type ChargeType: int
        :param _Id: EMR ID
        :type Id: int
        :param _ProductId: Product ID.
        :type ProductId: int
        :param _ProjectId: Project ID.
        :type ProjectId: int
        :param _RegionId: Region.
        :type RegionId: int
        :param _SubnetId: Subnet ID.
        :type SubnetId: int
        :param _VpcId: Network ID.
        :type VpcId: int
        :param _Zone: Region.
        :type Zone: str
        :param _Status: Status code. Valid values: -2 (cluster deleted), -1 (cluster closed), 0 (cluster in production), 2 (cluster running), 3 (cluster creating).
        :type Status: int
        :param _Tags: Instance tag
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Tags: list of Tag
        :param _AlarmInfo: Alarm information.
        :type AlarmInfo: str
        :param _IsWoodpeckerCluster: Whether it is a Woodpecker cluster.
        :type IsWoodpeckerCluster: int
        :param _VpcName: VPC name in Chinese.
        :type VpcName: str
        :param _SubnetName: Subnet in Chinese.
        :type SubnetName: str
        :param _UniqVpcId: String VpcId.
        :type UniqVpcId: str
        :param _UniqSubnetId: String subnet.
        :type UniqSubnetId: str
        :param _ClusterClass: Cluster type.
        :type ClusterClass: str
        :param _IsMultiZoneCluster: Whether it is a cross-AZ cluster.
        :type IsMultiZoneCluster: bool
        :param _IsHandsCluster: Whether it is a cluster created by a cluster CVM.
        :type IsHandsCluster: bool
        :param _OutSideSoftInfo: Client component information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutSideSoftInfo: list of SoftDependInfo
        :param _IsSupportOutsideCluster: Whether the current cluster's scenarios support external clients.
        :type IsSupportOutsideCluster: bool
        :param _IsDedicatedCluster: Whether the cluster is used in a dedicated cluster scenario.
        :type IsDedicatedCluster: bool
        :param _IsSupportClone: Cluster supports for cloning.
        :type IsSupportClone: bool
        """
        self._ClusterId = None
        self._StatusDesc = None
        self._ClusterName = None
        self._ZoneId = None
        self._AppId = None
        self._AddTime = None
        self._RunTime = None
        self._MasterIp = None
        self._EmrVersion = None
        self._ChargeType = None
        self._Id = None
        self._ProductId = None
        self._ProjectId = None
        self._RegionId = None
        self._SubnetId = None
        self._VpcId = None
        self._Zone = None
        self._Status = None
        self._Tags = None
        self._AlarmInfo = None
        self._IsWoodpeckerCluster = None
        self._VpcName = None
        self._SubnetName = None
        self._UniqVpcId = None
        self._UniqSubnetId = None
        self._ClusterClass = None
        self._IsMultiZoneCluster = None
        self._IsHandsCluster = None
        self._OutSideSoftInfo = None
        self._IsSupportOutsideCluster = None
        self._IsDedicatedCluster = None
        self._IsSupportClone = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def StatusDesc(self):
        r"""Common status: cluster in production, cluster running, cluster creating, cluster closed, and cluster deleted.
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ZoneId(self):
        r"""Cluster region
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def AppId(self):
        r"""User APPID
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def AddTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._AddTime

    @AddTime.setter
    def AddTime(self, AddTime):
        self._AddTime = AddTime

    @property
    def RunTime(self):
        r"""Running time
        :rtype: str
        """
        return self._RunTime

    @RunTime.setter
    def RunTime(self, RunTime):
        self._RunTime = RunTime

    @property
    def MasterIp(self):
        r"""Cluster IP
        :rtype: str
        """
        return self._MasterIp

    @MasterIp.setter
    def MasterIp(self, MasterIp):
        self._MasterIp = MasterIp

    @property
    def EmrVersion(self):
        r"""Cluster version
        :rtype: str
        """
        return self._EmrVersion

    @EmrVersion.setter
    def EmrVersion(self, EmrVersion):
        self._EmrVersion = EmrVersion

    @property
    def ChargeType(self):
        r"""Cluster billing mode
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def Id(self):
        r"""EMR ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProductId(self):
        r"""Product ID.
        :rtype: int
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def ProjectId(self):
        r"""Project ID.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RegionId(self):
        r"""Region.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def SubnetId(self):
        r"""Subnet ID.
        :rtype: int
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcId(self):
        r"""Network ID.
        :rtype: int
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Zone(self):
        r"""Region.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Status(self):
        r"""Status code. Valid values: -2 (cluster deleted), -1 (cluster closed), 0 (cluster in production), 2 (cluster running), 3 (cluster creating).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Tags(self):
        r"""Instance tag
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AlarmInfo(self):
        r"""Alarm information.
        :rtype: str
        """
        return self._AlarmInfo

    @AlarmInfo.setter
    def AlarmInfo(self, AlarmInfo):
        self._AlarmInfo = AlarmInfo

    @property
    def IsWoodpeckerCluster(self):
        r"""Whether it is a Woodpecker cluster.
        :rtype: int
        """
        return self._IsWoodpeckerCluster

    @IsWoodpeckerCluster.setter
    def IsWoodpeckerCluster(self, IsWoodpeckerCluster):
        self._IsWoodpeckerCluster = IsWoodpeckerCluster

    @property
    def VpcName(self):
        r"""VPC name in Chinese.
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def SubnetName(self):
        r"""Subnet in Chinese.
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def UniqVpcId(self):
        r"""String VpcId.
        :rtype: str
        """
        return self._UniqVpcId

    @UniqVpcId.setter
    def UniqVpcId(self, UniqVpcId):
        self._UniqVpcId = UniqVpcId

    @property
    def UniqSubnetId(self):
        r"""String subnet.
        :rtype: str
        """
        return self._UniqSubnetId

    @UniqSubnetId.setter
    def UniqSubnetId(self, UniqSubnetId):
        self._UniqSubnetId = UniqSubnetId

    @property
    def ClusterClass(self):
        r"""Cluster type.
        :rtype: str
        """
        return self._ClusterClass

    @ClusterClass.setter
    def ClusterClass(self, ClusterClass):
        self._ClusterClass = ClusterClass

    @property
    def IsMultiZoneCluster(self):
        r"""Whether it is a cross-AZ cluster.
        :rtype: bool
        """
        return self._IsMultiZoneCluster

    @IsMultiZoneCluster.setter
    def IsMultiZoneCluster(self, IsMultiZoneCluster):
        self._IsMultiZoneCluster = IsMultiZoneCluster

    @property
    def IsHandsCluster(self):
        r"""Whether it is a cluster created by a cluster CVM.
        :rtype: bool
        """
        return self._IsHandsCluster

    @IsHandsCluster.setter
    def IsHandsCluster(self, IsHandsCluster):
        self._IsHandsCluster = IsHandsCluster

    @property
    def OutSideSoftInfo(self):
        r"""Client component information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SoftDependInfo
        """
        return self._OutSideSoftInfo

    @OutSideSoftInfo.setter
    def OutSideSoftInfo(self, OutSideSoftInfo):
        self._OutSideSoftInfo = OutSideSoftInfo

    @property
    def IsSupportOutsideCluster(self):
        r"""Whether the current cluster's scenarios support external clients.
        :rtype: bool
        """
        return self._IsSupportOutsideCluster

    @IsSupportOutsideCluster.setter
    def IsSupportOutsideCluster(self, IsSupportOutsideCluster):
        self._IsSupportOutsideCluster = IsSupportOutsideCluster

    @property
    def IsDedicatedCluster(self):
        r"""Whether the cluster is used in a dedicated cluster scenario.
        :rtype: bool
        """
        return self._IsDedicatedCluster

    @IsDedicatedCluster.setter
    def IsDedicatedCluster(self, IsDedicatedCluster):
        self._IsDedicatedCluster = IsDedicatedCluster

    @property
    def IsSupportClone(self):
        r"""Cluster supports for cloning.
        :rtype: bool
        """
        return self._IsSupportClone

    @IsSupportClone.setter
    def IsSupportClone(self, IsSupportClone):
        self._IsSupportClone = IsSupportClone


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._StatusDesc = params.get("StatusDesc")
        self._ClusterName = params.get("ClusterName")
        self._ZoneId = params.get("ZoneId")
        self._AppId = params.get("AppId")
        self._AddTime = params.get("AddTime")
        self._RunTime = params.get("RunTime")
        self._MasterIp = params.get("MasterIp")
        self._EmrVersion = params.get("EmrVersion")
        self._ChargeType = params.get("ChargeType")
        self._Id = params.get("Id")
        self._ProductId = params.get("ProductId")
        self._ProjectId = params.get("ProjectId")
        self._RegionId = params.get("RegionId")
        self._SubnetId = params.get("SubnetId")
        self._VpcId = params.get("VpcId")
        self._Zone = params.get("Zone")
        self._Status = params.get("Status")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AlarmInfo = params.get("AlarmInfo")
        self._IsWoodpeckerCluster = params.get("IsWoodpeckerCluster")
        self._VpcName = params.get("VpcName")
        self._SubnetName = params.get("SubnetName")
        self._UniqVpcId = params.get("UniqVpcId")
        self._UniqSubnetId = params.get("UniqSubnetId")
        self._ClusterClass = params.get("ClusterClass")
        self._IsMultiZoneCluster = params.get("IsMultiZoneCluster")
        self._IsHandsCluster = params.get("IsHandsCluster")
        if params.get("OutSideSoftInfo") is not None:
            self._OutSideSoftInfo = []
            for item in params.get("OutSideSoftInfo"):
                obj = SoftDependInfo()
                obj._deserialize(item)
                self._OutSideSoftInfo.append(obj)
        self._IsSupportOutsideCluster = params.get("IsSupportOutsideCluster")
        self._IsDedicatedCluster = params.get("IsDedicatedCluster")
        self._IsSupportClone = params.get("IsSupportClone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmrPrice(AbstractModel):
    r"""EMR inquiry description

    """

    def __init__(self):
        r"""
        :param _OriginalCost: List price.
        :type OriginalCost: str
        :param _DiscountCost: Discounted price.
        :type DiscountCost: str
        :param _Unit: Unit.
        :type Unit: str
        :param _PriceSpec: The queried spec.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PriceSpec: :class:`tencentcloud.emr.v20190103.models.PriceResource`
        :param _SupportSpotPaid: Whether spot instances are supported.
        :type SupportSpotPaid: bool
        """
        self._OriginalCost = None
        self._DiscountCost = None
        self._Unit = None
        self._PriceSpec = None
        self._SupportSpotPaid = None

    @property
    def OriginalCost(self):
        r"""List price.
        :rtype: str
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discounted price.
        :rtype: str
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost

    @property
    def Unit(self):
        r"""Unit.
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def PriceSpec(self):
        r"""The queried spec.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PriceResource`
        """
        return self._PriceSpec

    @PriceSpec.setter
    def PriceSpec(self, PriceSpec):
        self._PriceSpec = PriceSpec

    @property
    def SupportSpotPaid(self):
        r"""Whether spot instances are supported.
        :rtype: bool
        """
        return self._SupportSpotPaid

    @SupportSpotPaid.setter
    def SupportSpotPaid(self, SupportSpotPaid):
        self._SupportSpotPaid = SupportSpotPaid


    def _deserialize(self, params):
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        self._Unit = params.get("Unit")
        if params.get("PriceSpec") is not None:
            self._PriceSpec = PriceResource()
            self._PriceSpec._deserialize(params.get("PriceSpec"))
        self._SupportSpotPaid = params.get("SupportSpotPaid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmrProductConfigDetail(AbstractModel):
    r"""EMR product configuration.

    """

    def __init__(self):
        r"""
        :param _SoftInfo: Software information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SoftInfo: list of str
        :param _MasterNodeSize: Number of Master nodes.
        :type MasterNodeSize: int
        :param _CoreNodeSize: Number of Core nodes.
        :type CoreNodeSize: int
        :param _TaskNodeSize: Number of Task nodes.
        :type TaskNodeSize: int
        :param _ComNodeSize: Number of Common nodes.
        :type ComNodeSize: int
        :param _MasterResource: Primary node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :type MasterResource: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        :param _CoreResource: Core node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :type CoreResource: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        :param _TaskResource: Task node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskResource: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        :param _ComResource: Common node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :type ComResource: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        :param _OnCos: Whether to use COS.
        :type OnCos: bool
        :param _ChargeType: Charge type.
        :type ChargeType: int
        :param _RouterNodeSize: Number of Router nodes.
        :type RouterNodeSize: int
        :param _SupportHA: Whether HA is supported.
        :type SupportHA: bool
        :param _SecurityOn: Whether security mode is supported.
        :type SecurityOn: bool
        :param _SecurityGroup: Security group name.
        :type SecurityGroup: str
        :param _CbsEncrypt: Whether to enable CBS encryption.
        :type CbsEncrypt: int
        :param _ApplicationRole: Custom application role.
        :type ApplicationRole: str
        :param _SecurityGroups: Security group.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecurityGroups: list of str
        :param _PublicKeyId: SSH key ID.
        :type PublicKeyId: str
        """
        self._SoftInfo = None
        self._MasterNodeSize = None
        self._CoreNodeSize = None
        self._TaskNodeSize = None
        self._ComNodeSize = None
        self._MasterResource = None
        self._CoreResource = None
        self._TaskResource = None
        self._ComResource = None
        self._OnCos = None
        self._ChargeType = None
        self._RouterNodeSize = None
        self._SupportHA = None
        self._SecurityOn = None
        self._SecurityGroup = None
        self._CbsEncrypt = None
        self._ApplicationRole = None
        self._SecurityGroups = None
        self._PublicKeyId = None

    @property
    def SoftInfo(self):
        r"""Software information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SoftInfo

    @SoftInfo.setter
    def SoftInfo(self, SoftInfo):
        self._SoftInfo = SoftInfo

    @property
    def MasterNodeSize(self):
        r"""Number of Master nodes.
        :rtype: int
        """
        return self._MasterNodeSize

    @MasterNodeSize.setter
    def MasterNodeSize(self, MasterNodeSize):
        self._MasterNodeSize = MasterNodeSize

    @property
    def CoreNodeSize(self):
        r"""Number of Core nodes.
        :rtype: int
        """
        return self._CoreNodeSize

    @CoreNodeSize.setter
    def CoreNodeSize(self, CoreNodeSize):
        self._CoreNodeSize = CoreNodeSize

    @property
    def TaskNodeSize(self):
        r"""Number of Task nodes.
        :rtype: int
        """
        return self._TaskNodeSize

    @TaskNodeSize.setter
    def TaskNodeSize(self, TaskNodeSize):
        self._TaskNodeSize = TaskNodeSize

    @property
    def ComNodeSize(self):
        r"""Number of Common nodes.
        :rtype: int
        """
        return self._ComNodeSize

    @ComNodeSize.setter
    def ComNodeSize(self, ComNodeSize):
        self._ComNodeSize = ComNodeSize

    @property
    def MasterResource(self):
        r"""Primary node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        """
        return self._MasterResource

    @MasterResource.setter
    def MasterResource(self, MasterResource):
        self._MasterResource = MasterResource

    @property
    def CoreResource(self):
        r"""Core node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        """
        return self._CoreResource

    @CoreResource.setter
    def CoreResource(self, CoreResource):
        self._CoreResource = CoreResource

    @property
    def TaskResource(self):
        r"""Task node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        """
        return self._TaskResource

    @TaskResource.setter
    def TaskResource(self, TaskResource):
        self._TaskResource = TaskResource

    @property
    def ComResource(self):
        r"""Common node resources

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ResourceDetail`
        """
        return self._ComResource

    @ComResource.setter
    def ComResource(self, ComResource):
        self._ComResource = ComResource

    @property
    def OnCos(self):
        r"""Whether to use COS.
        :rtype: bool
        """
        return self._OnCos

    @OnCos.setter
    def OnCos(self, OnCos):
        self._OnCos = OnCos

    @property
    def ChargeType(self):
        r"""Charge type.
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def RouterNodeSize(self):
        r"""Number of Router nodes.
        :rtype: int
        """
        return self._RouterNodeSize

    @RouterNodeSize.setter
    def RouterNodeSize(self, RouterNodeSize):
        self._RouterNodeSize = RouterNodeSize

    @property
    def SupportHA(self):
        r"""Whether HA is supported.
        :rtype: bool
        """
        return self._SupportHA

    @SupportHA.setter
    def SupportHA(self, SupportHA):
        self._SupportHA = SupportHA

    @property
    def SecurityOn(self):
        r"""Whether security mode is supported.
        :rtype: bool
        """
        return self._SecurityOn

    @SecurityOn.setter
    def SecurityOn(self, SecurityOn):
        self._SecurityOn = SecurityOn

    @property
    def SecurityGroup(self):
        r"""Security group name.
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def CbsEncrypt(self):
        r"""Whether to enable CBS encryption.
        :rtype: int
        """
        return self._CbsEncrypt

    @CbsEncrypt.setter
    def CbsEncrypt(self, CbsEncrypt):
        self._CbsEncrypt = CbsEncrypt

    @property
    def ApplicationRole(self):
        r"""Custom application role.
        :rtype: str
        """
        return self._ApplicationRole

    @ApplicationRole.setter
    def ApplicationRole(self, ApplicationRole):
        self._ApplicationRole = ApplicationRole

    @property
    def SecurityGroups(self):
        r"""Security group.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SecurityGroups

    @SecurityGroups.setter
    def SecurityGroups(self, SecurityGroups):
        self._SecurityGroups = SecurityGroups

    @property
    def PublicKeyId(self):
        r"""SSH key ID.
        :rtype: str
        """
        return self._PublicKeyId

    @PublicKeyId.setter
    def PublicKeyId(self, PublicKeyId):
        self._PublicKeyId = PublicKeyId


    def _deserialize(self, params):
        self._SoftInfo = params.get("SoftInfo")
        self._MasterNodeSize = params.get("MasterNodeSize")
        self._CoreNodeSize = params.get("CoreNodeSize")
        self._TaskNodeSize = params.get("TaskNodeSize")
        self._ComNodeSize = params.get("ComNodeSize")
        if params.get("MasterResource") is not None:
            self._MasterResource = ResourceDetail()
            self._MasterResource._deserialize(params.get("MasterResource"))
        if params.get("CoreResource") is not None:
            self._CoreResource = ResourceDetail()
            self._CoreResource._deserialize(params.get("CoreResource"))
        if params.get("TaskResource") is not None:
            self._TaskResource = ResourceDetail()
            self._TaskResource._deserialize(params.get("TaskResource"))
        if params.get("ComResource") is not None:
            self._ComResource = ResourceDetail()
            self._ComResource._deserialize(params.get("ComResource"))
        self._OnCos = params.get("OnCos")
        self._ChargeType = params.get("ChargeType")
        self._RouterNodeSize = params.get("RouterNodeSize")
        self._SupportHA = params.get("SupportHA")
        self._SecurityOn = params.get("SecurityOn")
        self._SecurityGroup = params.get("SecurityGroup")
        self._CbsEncrypt = params.get("CbsEncrypt")
        self._ApplicationRole = params.get("ApplicationRole")
        self._SecurityGroups = params.get("SecurityGroups")
        self._PublicKeyId = params.get("PublicKeyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmrProductConfigOutter(AbstractModel):
    r"""EMR product configuration

    """

    def __init__(self):
        r"""
        :param _SoftInfo: Software information
Note: this field may return null, indicating that no valid values can be obtained.
        :type SoftInfo: list of str
        :param _MasterNodeSize: Number of master nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :type MasterNodeSize: int
        :param _CoreNodeSize: Number of core nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :type CoreNodeSize: int
        :param _TaskNodeSize: Number of task nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :type TaskNodeSize: int
        :param _ComNodeSize: Number of common nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :type ComNodeSize: int
        :param _MasterResource: Master node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :type MasterResource: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        :param _CoreResource: Core node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :type CoreResource: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        :param _TaskResource: Task node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :type TaskResource: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        :param _ComResource: Common node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :type ComResource: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        :param _OnCos: Whether COS is used
Note: this field may return null, indicating that no valid values can be obtained.
        :type OnCos: bool
        :param _ChargeType: Billing mode
Note: this field may return null, indicating that no valid values can be obtained.
        :type ChargeType: int
        :param _RouterNodeSize: Number of router nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :type RouterNodeSize: int
        :param _SupportHA: Whether HA is supported
Note: this field may return null, indicating that no valid values can be obtained.
        :type SupportHA: bool
        :param _SecurityOn: Whether secure mode is supported
Note: this field may return null, indicating that no valid values can be obtained.
        :type SecurityOn: bool
        :param _SecurityGroup: Initial security group ID of the cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecurityGroup: str
        :param _CbsEncrypt: Whether to enable CBS encryption
Note: this field may return null, indicating that no valid values can be obtained.
        :type CbsEncrypt: int
        :param _ApplicationRole: Custom application role
Note: this field may return `null`, indicating that no valid value can be obtained.
        :type ApplicationRole: str
        :param _SecurityGroups: Security group ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecurityGroups: list of str
        :param _PublicKeyId: SSH key ID
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PublicKeyId: str
        """
        self._SoftInfo = None
        self._MasterNodeSize = None
        self._CoreNodeSize = None
        self._TaskNodeSize = None
        self._ComNodeSize = None
        self._MasterResource = None
        self._CoreResource = None
        self._TaskResource = None
        self._ComResource = None
        self._OnCos = None
        self._ChargeType = None
        self._RouterNodeSize = None
        self._SupportHA = None
        self._SecurityOn = None
        self._SecurityGroup = None
        self._CbsEncrypt = None
        self._ApplicationRole = None
        self._SecurityGroups = None
        self._PublicKeyId = None

    @property
    def SoftInfo(self):
        r"""Software information
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SoftInfo

    @SoftInfo.setter
    def SoftInfo(self, SoftInfo):
        self._SoftInfo = SoftInfo

    @property
    def MasterNodeSize(self):
        r"""Number of master nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MasterNodeSize

    @MasterNodeSize.setter
    def MasterNodeSize(self, MasterNodeSize):
        self._MasterNodeSize = MasterNodeSize

    @property
    def CoreNodeSize(self):
        r"""Number of core nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CoreNodeSize

    @CoreNodeSize.setter
    def CoreNodeSize(self, CoreNodeSize):
        self._CoreNodeSize = CoreNodeSize

    @property
    def TaskNodeSize(self):
        r"""Number of task nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TaskNodeSize

    @TaskNodeSize.setter
    def TaskNodeSize(self, TaskNodeSize):
        self._TaskNodeSize = TaskNodeSize

    @property
    def ComNodeSize(self):
        r"""Number of common nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ComNodeSize

    @ComNodeSize.setter
    def ComNodeSize(self, ComNodeSize):
        self._ComNodeSize = ComNodeSize

    @property
    def MasterResource(self):
        r"""Master node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        """
        return self._MasterResource

    @MasterResource.setter
    def MasterResource(self, MasterResource):
        self._MasterResource = MasterResource

    @property
    def CoreResource(self):
        r"""Core node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        """
        return self._CoreResource

    @CoreResource.setter
    def CoreResource(self, CoreResource):
        self._CoreResource = CoreResource

    @property
    def TaskResource(self):
        r"""Task node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        """
        return self._TaskResource

    @TaskResource.setter
    def TaskResource(self, TaskResource):
        self._TaskResource = TaskResource

    @property
    def ComResource(self):
        r"""Common node resource
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.OutterResource`
        """
        return self._ComResource

    @ComResource.setter
    def ComResource(self, ComResource):
        self._ComResource = ComResource

    @property
    def OnCos(self):
        r"""Whether COS is used
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._OnCos

    @OnCos.setter
    def OnCos(self, OnCos):
        self._OnCos = OnCos

    @property
    def ChargeType(self):
        r"""Billing mode
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def RouterNodeSize(self):
        r"""Number of router nodes
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RouterNodeSize

    @RouterNodeSize.setter
    def RouterNodeSize(self, RouterNodeSize):
        self._RouterNodeSize = RouterNodeSize

    @property
    def SupportHA(self):
        r"""Whether HA is supported
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._SupportHA

    @SupportHA.setter
    def SupportHA(self, SupportHA):
        self._SupportHA = SupportHA

    @property
    def SecurityOn(self):
        r"""Whether secure mode is supported
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._SecurityOn

    @SecurityOn.setter
    def SecurityOn(self, SecurityOn):
        self._SecurityOn = SecurityOn

    @property
    def SecurityGroup(self):
        r"""Initial security group ID of the cluster.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def CbsEncrypt(self):
        r"""Whether to enable CBS encryption
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CbsEncrypt

    @CbsEncrypt.setter
    def CbsEncrypt(self, CbsEncrypt):
        self._CbsEncrypt = CbsEncrypt

    @property
    def ApplicationRole(self):
        r"""Custom application role
Note: this field may return `null`, indicating that no valid value can be obtained.
        :rtype: str
        """
        return self._ApplicationRole

    @ApplicationRole.setter
    def ApplicationRole(self, ApplicationRole):
        self._ApplicationRole = ApplicationRole

    @property
    def SecurityGroups(self):
        r"""Security group ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SecurityGroups

    @SecurityGroups.setter
    def SecurityGroups(self, SecurityGroups):
        self._SecurityGroups = SecurityGroups

    @property
    def PublicKeyId(self):
        r"""SSH key ID
Note: This field may return `null`, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PublicKeyId

    @PublicKeyId.setter
    def PublicKeyId(self, PublicKeyId):
        self._PublicKeyId = PublicKeyId


    def _deserialize(self, params):
        self._SoftInfo = params.get("SoftInfo")
        self._MasterNodeSize = params.get("MasterNodeSize")
        self._CoreNodeSize = params.get("CoreNodeSize")
        self._TaskNodeSize = params.get("TaskNodeSize")
        self._ComNodeSize = params.get("ComNodeSize")
        if params.get("MasterResource") is not None:
            self._MasterResource = OutterResource()
            self._MasterResource._deserialize(params.get("MasterResource"))
        if params.get("CoreResource") is not None:
            self._CoreResource = OutterResource()
            self._CoreResource._deserialize(params.get("CoreResource"))
        if params.get("TaskResource") is not None:
            self._TaskResource = OutterResource()
            self._TaskResource._deserialize(params.get("TaskResource"))
        if params.get("ComResource") is not None:
            self._ComResource = OutterResource()
            self._ComResource._deserialize(params.get("ComResource"))
        self._OnCos = params.get("OnCos")
        self._ChargeType = params.get("ChargeType")
        self._RouterNodeSize = params.get("RouterNodeSize")
        self._SupportHA = params.get("SupportHA")
        self._SecurityOn = params.get("SecurityOn")
        self._SecurityGroup = params.get("SecurityGroup")
        self._CbsEncrypt = params.get("CbsEncrypt")
        self._ApplicationRole = params.get("ApplicationRole")
        self._SecurityGroups = params.get("SecurityGroups")
        self._PublicKeyId = params.get("PublicKeyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExternalService(AbstractModel):
    r"""Shared component information

    """

    def __init__(self):
        r"""
        :param _ShareType: Shared component type, which can be EMR or CUSTOM
        :type ShareType: str
        :param _CustomServiceDefineList: Custom parameters
        :type CustomServiceDefineList: list of CustomServiceDefine
        :param _Service: Shared component name
        :type Service: str
        :param _InstanceId: Shared component cluster
        :type InstanceId: str
        """
        self._ShareType = None
        self._CustomServiceDefineList = None
        self._Service = None
        self._InstanceId = None

    @property
    def ShareType(self):
        r"""Shared component type, which can be EMR or CUSTOM
        :rtype: str
        """
        return self._ShareType

    @ShareType.setter
    def ShareType(self, ShareType):
        self._ShareType = ShareType

    @property
    def CustomServiceDefineList(self):
        r"""Custom parameters
        :rtype: list of CustomServiceDefine
        """
        return self._CustomServiceDefineList

    @CustomServiceDefineList.setter
    def CustomServiceDefineList(self, CustomServiceDefineList):
        self._CustomServiceDefineList = CustomServiceDefineList

    @property
    def Service(self):
        r"""Shared component name
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def InstanceId(self):
        r"""Shared component cluster
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._ShareType = params.get("ShareType")
        if params.get("CustomServiceDefineList") is not None:
            self._CustomServiceDefineList = []
            for item in params.get("CustomServiceDefineList"):
                obj = CustomServiceDefine()
                obj._deserialize(item)
                self._CustomServiceDefineList.append(obj)
        self._Service = params.get("Service")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FairGlobalConfig(AbstractModel):
    r"""Global configurations of the fair scheduler under Resource Scheduling.

    """

    def __init__(self):
        r"""
        :param _UserMaxAppsDefault: Corresponds to <p>Program Upper Limit</p> of the page.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserMaxAppsDefault: int
        """
        self._UserMaxAppsDefault = None

    @property
    def UserMaxAppsDefault(self):
        r"""Corresponds to <p>Program Upper Limit</p> of the page.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UserMaxAppsDefault

    @UserMaxAppsDefault.setter
    def UserMaxAppsDefault(self, UserMaxAppsDefault):
        self._UserMaxAppsDefault = UserMaxAppsDefault


    def _deserialize(self, params):
        self._UserMaxAppsDefault = params.get("UserMaxAppsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    r"""A key-value pair filter used for condition filtering and queries.

    """

    def __init__(self):
        r"""
        :param _Name: Fields that need to be filtered.
        :type Name: str
        :param _Values: Filter value of the field.
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Fields that need to be filtered.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Filter value of the field.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filters(AbstractModel):
    r"""Custom query filter of the EMR cluster instance list

    """

    def __init__(self):
        r"""
        :param _Name: Field name
        :type Name: str
        :param _Values: Filters by the field value
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Field name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Filters by the field value
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowExtraDetail(AbstractModel):
    r"""Additional process information.

    """

    def __init__(self):
        r"""
        :param _Title: Additional information title.
        :type Title: str
        :param _Detail: Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Detail: list of FlowParamsDesc
        """
        self._Title = None
        self._Detail = None

    @property
    def Title(self):
        r"""Additional information title.
        :rtype: str
        """
        return self._Title

    @Title.setter
    def Title(self, Title):
        self._Title = Title

    @property
    def Detail(self):
        r"""Additional information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of FlowParamsDesc
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail


    def _deserialize(self, params):
        self._Title = params.get("Title")
        if params.get("Detail") is not None:
            self._Detail = []
            for item in params.get("Detail"):
                obj = FlowParamsDesc()
                obj._deserialize(item)
                self._Detail.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowParam(AbstractModel):
    r"""FlowParam process parameters.

    """

    def __init__(self):
        r"""
        :param _FKey: Process parameter key.
TraceId: Query by TraceId.
FlowId: Query by FlowId.
        :type FKey: str
        :param _FValue: Parameter value
        :type FValue: str
        """
        self._FKey = None
        self._FValue = None

    @property
    def FKey(self):
        r"""Process parameter key.
TraceId: Query by TraceId.
FlowId: Query by FlowId.
        :rtype: str
        """
        return self._FKey

    @FKey.setter
    def FKey(self, FKey):
        self._FKey = FKey

    @property
    def FValue(self):
        r"""Parameter value
        :rtype: str
        """
        return self._FValue

    @FValue.setter
    def FValue(self, FValue):
        self._FValue = FValue


    def _deserialize(self, params):
        self._FKey = params.get("FKey")
        self._FValue = params.get("FValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowParamsDesc(AbstractModel):
    r"""Task parameter description

    """

    def __init__(self):
        r"""
        :param _PKey: Parameter key
        :type PKey: str
        :param _PValue: Parameter value.
        :type PValue: str
        """
        self._PKey = None
        self._PValue = None

    @property
    def PKey(self):
        r"""Parameter key
        :rtype: str
        """
        return self._PKey

    @PKey.setter
    def PKey(self, PKey):
        self._PKey = PKey

    @property
    def PValue(self):
        r"""Parameter value.
        :rtype: str
        """
        return self._PValue

    @PValue.setter
    def PValue(self, PValue):
        self._PValue = PValue


    def _deserialize(self, params):
        self._PKey = params.get("PKey")
        self._PValue = params.get("PValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupGlobalConfs(AbstractModel):
    r"""Global parameter information of all scaling groups in the cluster.

    """

    def __init__(self):
        r"""
        :param _GroupGlobalConf: Scaling group information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupGlobalConf: :class:`tencentcloud.emr.v20190103.models.AutoScaleResourceConf`
        :param _CurrentNodes: Number of nodes scaled out in the current scaling group.
        :type CurrentNodes: int
        :param _CurrentPostPaidNodes: Number of postpaid nodes scaled out in the current scaling group.
        :type CurrentPostPaidNodes: int
        :param _CurrentSpotPaidNodes: Number of spot instance nodes scaled out in the current scaling group.
        :type CurrentSpotPaidNodes: int
        """
        self._GroupGlobalConf = None
        self._CurrentNodes = None
        self._CurrentPostPaidNodes = None
        self._CurrentSpotPaidNodes = None

    @property
    def GroupGlobalConf(self):
        r"""Scaling group information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.AutoScaleResourceConf`
        """
        return self._GroupGlobalConf

    @GroupGlobalConf.setter
    def GroupGlobalConf(self, GroupGlobalConf):
        self._GroupGlobalConf = GroupGlobalConf

    @property
    def CurrentNodes(self):
        r"""Number of nodes scaled out in the current scaling group.
        :rtype: int
        """
        return self._CurrentNodes

    @CurrentNodes.setter
    def CurrentNodes(self, CurrentNodes):
        self._CurrentNodes = CurrentNodes

    @property
    def CurrentPostPaidNodes(self):
        r"""Number of postpaid nodes scaled out in the current scaling group.
        :rtype: int
        """
        return self._CurrentPostPaidNodes

    @CurrentPostPaidNodes.setter
    def CurrentPostPaidNodes(self, CurrentPostPaidNodes):
        self._CurrentPostPaidNodes = CurrentPostPaidNodes

    @property
    def CurrentSpotPaidNodes(self):
        r"""Number of spot instance nodes scaled out in the current scaling group.
        :rtype: int
        """
        return self._CurrentSpotPaidNodes

    @CurrentSpotPaidNodes.setter
    def CurrentSpotPaidNodes(self, CurrentSpotPaidNodes):
        self._CurrentSpotPaidNodes = CurrentSpotPaidNodes


    def _deserialize(self, params):
        if params.get("GroupGlobalConf") is not None:
            self._GroupGlobalConf = AutoScaleResourceConf()
            self._GroupGlobalConf._deserialize(params.get("GroupGlobalConf"))
        self._CurrentNodes = params.get("CurrentNodes")
        self._CurrentPostPaidNodes = params.get("CurrentPostPaidNodes")
        self._CurrentSpotPaidNodes = params.get("CurrentSpotPaidNodes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupInfo(AbstractModel):
    r"""User group information.

    """

    def __init__(self):
        r"""
        :param _GroupName: Group name.
        :type GroupName: str
        :param _Description: Remarks.
        :type Description: str
        :param _Users: User list.
        :type Users: list of str
        """
        self._GroupName = None
        self._Description = None
        self._Users = None

    @property
    def GroupName(self):
        r"""Group name.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Users(self):
        r"""User list.
        :rtype: list of str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        self._Users = params.get("Users")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupInfos(AbstractModel):
    r"""User group information.

    """

    def __init__(self):
        r"""
        :param _GroupName: User group name.
        :type GroupName: str
        :param _Users: User name list.
        :type Users: list of str
        :param _Description: Remarks.
        :type Description: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _GroupType: User group type.
        :type GroupType: int
        :param _GroupTypeDesc: User group type description.
        :type GroupTypeDesc: str
        """
        self._GroupName = None
        self._Users = None
        self._Description = None
        self._CreateTime = None
        self._GroupType = None
        self._GroupTypeDesc = None

    @property
    def GroupName(self):
        r"""User group name.
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Users(self):
        r"""User name list.
        :rtype: list of str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def Description(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def GroupType(self):
        r"""User group type.
        :rtype: int
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def GroupTypeDesc(self):
        r"""User group type description.
        :rtype: str
        """
        return self._GroupTypeDesc

    @GroupTypeDesc.setter
    def GroupTypeDesc(self, GroupTypeDesc):
        self._GroupTypeDesc = GroupTypeDesc


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Users = params.get("Users")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._GroupType = params.get("GroupType")
        self._GroupTypeDesc = params.get("GroupTypeDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HealthStatus(AbstractModel):
    r"""Process health status

    """

    def __init__(self):
        r"""
        :param _Code: Running normally.
        :type Code: int
        :param _Text: Running normally.
        :type Text: str
        :param _Desc: Running normally.
        :type Desc: str
        """
        self._Code = None
        self._Text = None
        self._Desc = None

    @property
    def Code(self):
        r"""Running normally.
        :rtype: int
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Text(self):
        r"""Running normally.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Desc(self):
        r"""Running normally.
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Text = params.get("Text")
        self._Desc = params.get("Desc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HiveQuery(AbstractModel):
    r"""Hive query details

    """

    def __init__(self):
        r"""
        :param _Statement: Query statement.
        :type Statement: str
        :param _Duration: Execution duration.
        :type Duration: str
        :param _StartTime: Start time in milliseconds.
        :type StartTime: int
        :param _EndTime: End time in milliseconds.
        :type EndTime: int
        :param _State: Status.
        :type State: str
        :param _User: User.
        :type User: str
        :param _JobIds: AppId List
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobIds: list of str
        :param _ExecutionEngine: Execution engine.
        :type ExecutionEngine: str
        :param _Id: Query ID.
        :type Id: str
        """
        self._Statement = None
        self._Duration = None
        self._StartTime = None
        self._EndTime = None
        self._State = None
        self._User = None
        self._JobIds = None
        self._ExecutionEngine = None
        self._Id = None

    @property
    def Statement(self):
        r"""Query statement.
        :rtype: str
        """
        return self._Statement

    @Statement.setter
    def Statement(self, Statement):
        self._Statement = Statement

    @property
    def Duration(self):
        r"""Execution duration.
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def StartTime(self):
        r"""Start time in milliseconds.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time in milliseconds.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def State(self):
        r"""Status.
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def User(self):
        r"""User.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def JobIds(self):
        r"""AppId List
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._JobIds

    @JobIds.setter
    def JobIds(self, JobIds):
        self._JobIds = JobIds

    @property
    def ExecutionEngine(self):
        r"""Execution engine.
        :rtype: str
        """
        return self._ExecutionEngine

    @ExecutionEngine.setter
    def ExecutionEngine(self, ExecutionEngine):
        self._ExecutionEngine = ExecutionEngine

    @property
    def Id(self):
        r"""Query ID.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Statement = params.get("Statement")
        self._Duration = params.get("Duration")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._State = params.get("State")
        self._User = params.get("User")
        self._JobIds = params.get("JobIds")
        self._ExecutionEngine = params.get("ExecutionEngine")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostVolumeContext(AbstractModel):
    r"""Description of `HostPath` mounting method in the pod

    """

    def __init__(self):
        r"""
        :param _VolumePath: Directory for mounting the host in the pod. As the mount point of the host in the resource, a specified mount point corresponds to the host path and is used as the data storage directory in the pod.
        :type VolumePath: str
        """
        self._VolumePath = None

    @property
    def VolumePath(self):
        r"""Directory for mounting the host in the pod. As the mount point of the host in the resource, a specified mount point corresponds to the host path and is used as the data storage directory in the pod.
        :rtype: str
        """
        return self._VolumePath

    @VolumePath.setter
    def VolumePath(self, VolumePath):
        self._VolumePath = VolumePath


    def _deserialize(self, params):
        self._VolumePath = params.get("VolumePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceCreateInstanceRequest(AbstractModel):
    r"""InquiryPriceCreateInstance request structure.

    """

    def __init__(self):
        r"""
        :param _TimeUnit: Time unit of instance purchase duration. Valid values:
<li>s: seconds. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
        :type TimeUnit: str
        :param _TimeSpan: Purchase duration of instance, which needs to be used together with `TimeUnit`.
<li>When `TimeUnit` is `s`, this parameter can only be filled with 3600, indicating a pay-as-you-go instance.</li>
<li>When `TimeUnit` is `m`, the number entered in this parameter indicates the purchase duration of the monthly-subscription instance; for example, 1 means one month</li>
        :type TimeSpan: int
        :param _Currency: Currency.
        :type Currency: str
        :param _PayMode: Instance billing mode. Valid values:
<li>0: pay-as-you-go.</li>
        :type PayMode: int
        :param _SupportHA: Whether to enable high availability of node. Valid values:
<li>0: does not enable high availability of node.</li>
<li>1: enables high availability of node.</li>
        :type SupportHA: int
        :param _Software: List of deployed components. Different required components need to be selected for different EMR product IDs (ProductId: For specific meanings, see the ProductId field in the input parameters): <li>When ProductId is 2 (EMR v2.0.1), the required components include hdfs-2.7.3, yarn-2.7.3, zookeeper-3.4.9, and knox-1.2.0.</li> <li>When ProductId is 16 (EMR v2.3.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.5.5, and knox-1.2.0.</li> <li>When ProductId is 20 (EMR v2.5.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 30 (EMR v2.6.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.1, openldap-2.4.44, and knox-1.2.0.</li> <li>When ProductId is 38 (EMR v2.7.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 57 (EMR v2.8.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 7 (EMR v3.0.0), the required components include hdfs-3.1.2, yarn-3.1.2, zookeeper-3.4.9, and knox-1.2.0.</li> <li>When ProductId is 25 (EMR v3.1.0), the required components include hdfs-3.1.2, yarn-3.1.2, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 31 (EMR v3.1.1), the required components include hdfs-3.1.2, yarn-3.1.2, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 28 (EMR v3.2.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 33 (EMR v3.2.1), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.1, openldap-2.4.44, and knox-1.2.0.</li> <li>When ProductId is 34 (EMR v3.3.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.1, openldap-2.4.44, and knox-1.2.0.</li> <li>When ProductId is 37 (EMR v3.4.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 44 (EMR v3.5.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 53 (EMR v3.6.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 58 (EMR v3.6.1), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.46, and knox-1.6.1.</li> <li>When ProductId is 47 (EMR v4.0.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li>
        :type Software: list of str
        :param _ResourceSpec: Node specification queried for price.
        :type ResourceSpec: :class:`tencentcloud.emr.v20190103.models.NewResourceSpec`
        :param _Placement: Instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :type Placement: :class:`tencentcloud.emr.v20190103.models.Placement`
        :param _VPCSettings: Configuration information of VPC. This parameter is used to specify the VPC ID, subnet ID, etc.
        :type VPCSettings: :class:`tencentcloud.emr.v20190103.models.VPCSettings`
        :param _MetaType: Hive-shared metadatabase type. Valid values:
<li>EMR_DEFAULT_META: the cluster creates one by default.</li>
<li>EMR_EXIST_META: the cluster uses the specified EMR-MetaDB instance.</li>
<li>USER_CUSTOM_META: the cluster uses a custom MetaDB instance.</li>
        :type MetaType: str
        :param _UnifyMetaInstanceId: EMR-MetaDB instance
        :type UnifyMetaInstanceId: str
        :param _MetaDBInfo: Custom MetaDB instance information
        :type MetaDBInfo: :class:`tencentcloud.emr.v20190103.models.CustomMetaInfo`
        :param _ProductId: Product ID. Different product IDs represent different EMR product versions. Valid values: <li>2: EMR v2.0.1;</li> <li>16: EMR v2.3.0;</li> <li>20: EMR v2.5.0;</li> <li>30: EMR v2.6.0;</li> <li>38: EMR v2.7.0;</li> <li>57: EMR v2.8.0;</li> <li>7: EMR v3.0.0;</li> <li>25: EMR v3.1.0;</li> <li>31: EMR v3.1.1;</li> <li>28: EMR v3.2.0</li> <li>33: EMR v3.2.1</li> <li>34: EMR v3.3.0</li> <li>37: EMR v3.4.0;</li> <li>44: EMR v3.5.0;</li> <li>53: EMR v3.6.0;</li> <li>58: EMR v3.6.1;</li> <li>47: EMR v4.0.0.</li>
        :type ProductId: int
        :param _SceneName: Scenario values: Hadoop-Kudu, Hadoop-ZooKeeper, Hadoop-Presto, and Hadoop-HBase.
        :type SceneName: str
        :param _ExternalService: Shared component information
        :type ExternalService: list of ExternalService
        :param _VersionID: 
        :type VersionID: int
        :param _MultiZoneSettings: AZ specs
        :type MultiZoneSettings: list of MultiZoneSetting
        """
        self._TimeUnit = None
        self._TimeSpan = None
        self._Currency = None
        self._PayMode = None
        self._SupportHA = None
        self._Software = None
        self._ResourceSpec = None
        self._Placement = None
        self._VPCSettings = None
        self._MetaType = None
        self._UnifyMetaInstanceId = None
        self._MetaDBInfo = None
        self._ProductId = None
        self._SceneName = None
        self._ExternalService = None
        self._VersionID = None
        self._MultiZoneSettings = None

    @property
    def TimeUnit(self):
        r"""Time unit of instance purchase duration. Valid values:
<li>s: seconds. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Purchase duration of instance, which needs to be used together with `TimeUnit`.
<li>When `TimeUnit` is `s`, this parameter can only be filled with 3600, indicating a pay-as-you-go instance.</li>
<li>When `TimeUnit` is `m`, the number entered in this parameter indicates the purchase duration of the monthly-subscription instance; for example, 1 means one month</li>
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def Currency(self):
        r"""Currency.
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def PayMode(self):
        r"""Instance billing mode. Valid values:
<li>0: pay-as-you-go.</li>
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def SupportHA(self):
        r"""Whether to enable high availability of node. Valid values:
<li>0: does not enable high availability of node.</li>
<li>1: enables high availability of node.</li>
        :rtype: int
        """
        return self._SupportHA

    @SupportHA.setter
    def SupportHA(self, SupportHA):
        self._SupportHA = SupportHA

    @property
    def Software(self):
        r"""List of deployed components. Different required components need to be selected for different EMR product IDs (ProductId: For specific meanings, see the ProductId field in the input parameters): <li>When ProductId is 2 (EMR v2.0.1), the required components include hdfs-2.7.3, yarn-2.7.3, zookeeper-3.4.9, and knox-1.2.0.</li> <li>When ProductId is 16 (EMR v2.3.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.5.5, and knox-1.2.0.</li> <li>When ProductId is 20 (EMR v2.5.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 30 (EMR v2.6.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.1, openldap-2.4.44, and knox-1.2.0.</li> <li>When ProductId is 38 (EMR v2.7.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 57 (EMR v2.8.0), the required components include hdfs-2.8.5, yarn-2.8.5, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 7 (EMR v3.0.0), the required components include hdfs-3.1.2, yarn-3.1.2, zookeeper-3.4.9, and knox-1.2.0.</li> <li>When ProductId is 25 (EMR v3.1.0), the required components include hdfs-3.1.2, yarn-3.1.2, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 31 (EMR v3.1.1), the required components include hdfs-3.1.2, yarn-3.1.2, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 28 (EMR v3.2.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.1, and knox-1.2.0.</li> <li>When ProductId is 33 (EMR v3.2.1), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.1, openldap-2.4.44, and knox-1.2.0.</li> <li>When ProductId is 34 (EMR v3.3.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.1, openldap-2.4.44, and knox-1.2.0.</li> <li>When ProductId is 37 (EMR v3.4.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 44 (EMR v3.5.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 53 (EMR v3.6.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li> <li>When ProductId is 58 (EMR v3.6.1), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.46, and knox-1.6.1.</li> <li>When ProductId is 47 (EMR v4.0.0), the required components include hdfs-3.2.2, yarn-3.2.2, zookeeper-3.6.3, openldap-2.4.44, and knox-1.6.1.</li>
        :rtype: list of str
        """
        return self._Software

    @Software.setter
    def Software(self, Software):
        self._Software = Software

    @property
    def ResourceSpec(self):
        r"""Node specification queried for price.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NewResourceSpec`
        """
        return self._ResourceSpec

    @ResourceSpec.setter
    def ResourceSpec(self, ResourceSpec):
        self._ResourceSpec = ResourceSpec

    @property
    def Placement(self):
        r"""Instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Placement`
        """
        return self._Placement

    @Placement.setter
    def Placement(self, Placement):
        self._Placement = Placement

    @property
    def VPCSettings(self):
        r"""Configuration information of VPC. This parameter is used to specify the VPC ID, subnet ID, etc.
        :rtype: :class:`tencentcloud.emr.v20190103.models.VPCSettings`
        """
        return self._VPCSettings

    @VPCSettings.setter
    def VPCSettings(self, VPCSettings):
        self._VPCSettings = VPCSettings

    @property
    def MetaType(self):
        r"""Hive-shared metadatabase type. Valid values:
<li>EMR_DEFAULT_META: the cluster creates one by default.</li>
<li>EMR_EXIST_META: the cluster uses the specified EMR-MetaDB instance.</li>
<li>USER_CUSTOM_META: the cluster uses a custom MetaDB instance.</li>
        :rtype: str
        """
        return self._MetaType

    @MetaType.setter
    def MetaType(self, MetaType):
        self._MetaType = MetaType

    @property
    def UnifyMetaInstanceId(self):
        r"""EMR-MetaDB instance
        :rtype: str
        """
        return self._UnifyMetaInstanceId

    @UnifyMetaInstanceId.setter
    def UnifyMetaInstanceId(self, UnifyMetaInstanceId):
        self._UnifyMetaInstanceId = UnifyMetaInstanceId

    @property
    def MetaDBInfo(self):
        r"""Custom MetaDB instance information
        :rtype: :class:`tencentcloud.emr.v20190103.models.CustomMetaInfo`
        """
        return self._MetaDBInfo

    @MetaDBInfo.setter
    def MetaDBInfo(self, MetaDBInfo):
        self._MetaDBInfo = MetaDBInfo

    @property
    def ProductId(self):
        r"""Product ID. Different product IDs represent different EMR product versions. Valid values: <li>2: EMR v2.0.1;</li> <li>16: EMR v2.3.0;</li> <li>20: EMR v2.5.0;</li> <li>30: EMR v2.6.0;</li> <li>38: EMR v2.7.0;</li> <li>57: EMR v2.8.0;</li> <li>7: EMR v3.0.0;</li> <li>25: EMR v3.1.0;</li> <li>31: EMR v3.1.1;</li> <li>28: EMR v3.2.0</li> <li>33: EMR v3.2.1</li> <li>34: EMR v3.3.0</li> <li>37: EMR v3.4.0;</li> <li>44: EMR v3.5.0;</li> <li>53: EMR v3.6.0;</li> <li>58: EMR v3.6.1;</li> <li>47: EMR v4.0.0.</li>
        :rtype: int
        """
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def SceneName(self):
        r"""Scenario values: Hadoop-Kudu, Hadoop-ZooKeeper, Hadoop-Presto, and Hadoop-HBase.
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName

    @property
    def ExternalService(self):
        r"""Shared component information
        :rtype: list of ExternalService
        """
        return self._ExternalService

    @ExternalService.setter
    def ExternalService(self, ExternalService):
        self._ExternalService = ExternalService

    @property
    def VersionID(self):
        r"""
        :rtype: int
        """
        return self._VersionID

    @VersionID.setter
    def VersionID(self, VersionID):
        self._VersionID = VersionID

    @property
    def MultiZoneSettings(self):
        r"""AZ specs
        :rtype: list of MultiZoneSetting
        """
        return self._MultiZoneSettings

    @MultiZoneSettings.setter
    def MultiZoneSettings(self, MultiZoneSettings):
        self._MultiZoneSettings = MultiZoneSettings


    def _deserialize(self, params):
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        self._Currency = params.get("Currency")
        self._PayMode = params.get("PayMode")
        self._SupportHA = params.get("SupportHA")
        self._Software = params.get("Software")
        if params.get("ResourceSpec") is not None:
            self._ResourceSpec = NewResourceSpec()
            self._ResourceSpec._deserialize(params.get("ResourceSpec"))
        if params.get("Placement") is not None:
            self._Placement = Placement()
            self._Placement._deserialize(params.get("Placement"))
        if params.get("VPCSettings") is not None:
            self._VPCSettings = VPCSettings()
            self._VPCSettings._deserialize(params.get("VPCSettings"))
        self._MetaType = params.get("MetaType")
        self._UnifyMetaInstanceId = params.get("UnifyMetaInstanceId")
        if params.get("MetaDBInfo") is not None:
            self._MetaDBInfo = CustomMetaInfo()
            self._MetaDBInfo._deserialize(params.get("MetaDBInfo"))
        self._ProductId = params.get("ProductId")
        self._SceneName = params.get("SceneName")
        if params.get("ExternalService") is not None:
            self._ExternalService = []
            for item in params.get("ExternalService"):
                obj = ExternalService()
                obj._deserialize(item)
                self._ExternalService.append(obj)
        self._VersionID = params.get("VersionID")
        if params.get("MultiZoneSettings") is not None:
            self._MultiZoneSettings = []
            for item in params.get("MultiZoneSettings"):
                obj = MultiZoneSetting()
                obj._deserialize(item)
                self._MultiZoneSettings.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceCreateInstanceResponse(AbstractModel):
    r"""InquiryPriceCreateInstance response structure.

    """

    def __init__(self):
        r"""
        :param _OriginalCost: Original price.
        :type OriginalCost: float
        :param _DiscountCost: Discounted price.
        :type DiscountCost: float
        :param _TimeUnit: Time unit of purchase instances. Valid values.
<li>s: seconds.</li>
        :type TimeUnit: str
        :param _TimeSpan: Instance purchase duration.
        :type TimeSpan: int
        :param _PriceList: The price list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PriceList: list of ZoneDetailPriceResult
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginalCost = None
        self._DiscountCost = None
        self._TimeUnit = None
        self._TimeSpan = None
        self._PriceList = None
        self._RequestId = None

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discounted price.
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost

    @property
    def TimeUnit(self):
        r"""Time unit of purchase instances. Valid values.
<li>s: seconds.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Instance purchase duration.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PriceList(self):
        r"""The price list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ZoneDetailPriceResult
        """
        return self._PriceList

    @PriceList.setter
    def PriceList(self, PriceList):
        self._PriceList = PriceList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        if params.get("PriceList") is not None:
            self._PriceList = []
            for item in params.get("PriceList"):
                obj = ZoneDetailPriceResult()
                obj._deserialize(item)
                self._PriceList.append(obj)
        self._RequestId = params.get("RequestId")


class InquiryPriceRenewInstanceRequest(AbstractModel):
    r"""InquiryPriceRenewInstance request structure.

    """

    def __init__(self):
        r"""
        :param _TimeSpan: How long the instance will be renewed for, which needs to be used together with `TimeUnit`.
        :type TimeSpan: int
        :param _PayMode: Instance billing mode.
        :type PayMode: int
        :param _ResourceIds: List of resource IDs of the node to be renewed. The resource ID is in the format of `emr-vm-xxxxxxxx`. A valid resource ID can be queried in the [console](https://console.cloud.tencent.com/emr/static/hardware).
        :type ResourceIds: list of str
        :param _TimeUnit: Unit of time for instance renewal.
        :type TimeUnit: str
        :param _Currency: Currency.
        :type Currency: str
        :param _Placement: Location of the instance. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :type Placement: :class:`tencentcloud.emr.v20190103.models.Placement`
        :param _ModifyPayMode: Whether to change from pay-as-you-go billing to monthly subscription billing. `0`: no; `1`: yes
        :type ModifyPayMode: int
        :param _NeedDetail: Whether the renewal price for every node is required.
        :type NeedDetail: bool
        :param _InstanceId: Cluster ID. This parameter can be filled to get renewal information for all yearly/monthly subscription nodes in the cluster.
        :type InstanceId: str
        """
        self._TimeSpan = None
        self._PayMode = None
        self._ResourceIds = None
        self._TimeUnit = None
        self._Currency = None
        self._Placement = None
        self._ModifyPayMode = None
        self._NeedDetail = None
        self._InstanceId = None

    @property
    def TimeSpan(self):
        r"""How long the instance will be renewed for, which needs to be used together with `TimeUnit`.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PayMode(self):
        r"""Instance billing mode.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ResourceIds(self):
        r"""List of resource IDs of the node to be renewed. The resource ID is in the format of `emr-vm-xxxxxxxx`. A valid resource ID can be queried in the [console](https://console.cloud.tencent.com/emr/static/hardware).
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def TimeUnit(self):
        r"""Unit of time for instance renewal.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def Currency(self):
        r"""Currency.
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def Placement(self):
        r"""Location of the instance. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Placement`
        """
        return self._Placement

    @Placement.setter
    def Placement(self, Placement):
        self._Placement = Placement

    @property
    def ModifyPayMode(self):
        r"""Whether to change from pay-as-you-go billing to monthly subscription billing. `0`: no; `1`: yes
        :rtype: int
        """
        return self._ModifyPayMode

    @ModifyPayMode.setter
    def ModifyPayMode(self, ModifyPayMode):
        self._ModifyPayMode = ModifyPayMode

    @property
    def NeedDetail(self):
        r"""Whether the renewal price for every node is required.
        :rtype: bool
        """
        return self._NeedDetail

    @NeedDetail.setter
    def NeedDetail(self, NeedDetail):
        self._NeedDetail = NeedDetail

    @property
    def InstanceId(self):
        r"""Cluster ID. This parameter can be filled to get renewal information for all yearly/monthly subscription nodes in the cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._PayMode = params.get("PayMode")
        self._ResourceIds = params.get("ResourceIds")
        self._TimeUnit = params.get("TimeUnit")
        self._Currency = params.get("Currency")
        if params.get("Placement") is not None:
            self._Placement = Placement()
            self._Placement._deserialize(params.get("Placement"))
        self._ModifyPayMode = params.get("ModifyPayMode")
        self._NeedDetail = params.get("NeedDetail")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceRenewInstanceResponse(AbstractModel):
    r"""InquiryPriceRenewInstance response structure.

    """

    def __init__(self):
        r"""
        :param _OriginalCost: Original price.
        :type OriginalCost: float
        :param _DiscountCost: Discounted price.
        :type DiscountCost: float
        :param _TimeUnit: Time unit for instance renewal.
        :type TimeUnit: str
        :param _TimeSpan: Duration of instance renewal.
        :type TimeSpan: int
        :param _PriceDetail: Price details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PriceDetail: list of PriceDetail
        :param _NodeRenewPriceDetails: Node renewal pricing list.
        :type NodeRenewPriceDetails: list of NodeRenewPriceDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginalCost = None
        self._DiscountCost = None
        self._TimeUnit = None
        self._TimeSpan = None
        self._PriceDetail = None
        self._NodeRenewPriceDetails = None
        self._RequestId = None

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discounted price.
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost

    @property
    def TimeUnit(self):
        r"""Time unit for instance renewal.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Duration of instance renewal.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PriceDetail(self):
        r"""Price details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of PriceDetail
        """
        return self._PriceDetail

    @PriceDetail.setter
    def PriceDetail(self, PriceDetail):
        self._PriceDetail = PriceDetail

    @property
    def NodeRenewPriceDetails(self):
        r"""Node renewal pricing list.
        :rtype: list of NodeRenewPriceDetail
        """
        return self._NodeRenewPriceDetails

    @NodeRenewPriceDetails.setter
    def NodeRenewPriceDetails(self, NodeRenewPriceDetails):
        self._NodeRenewPriceDetails = NodeRenewPriceDetails

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        if params.get("PriceDetail") is not None:
            self._PriceDetail = []
            for item in params.get("PriceDetail"):
                obj = PriceDetail()
                obj._deserialize(item)
                self._PriceDetail.append(obj)
        if params.get("NodeRenewPriceDetails") is not None:
            self._NodeRenewPriceDetails = []
            for item in params.get("NodeRenewPriceDetails"):
                obj = NodeRenewPriceDetail()
                obj._deserialize(item)
                self._NodeRenewPriceDetails.append(obj)
        self._RequestId = params.get("RequestId")


class InquiryPriceScaleOutInstanceRequest(AbstractModel):
    r"""InquiryPriceScaleOutInstance request structure.

    """

    def __init__(self):
        r"""
        :param _TimeUnit: Time unit of scale-out. Valid value:
<li>s: Second. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
        :type TimeUnit: str
        :param _TimeSpan: Time span of scale-out, which needs to be used together with `TimeUnit`.
<li>When `PayMode` is 0, `TimeSpan` can only be 3,600.</li>
        :type TimeSpan: int
        :param _ZoneId: ID of the AZ where an instance resides.
        :type ZoneId: int
        :param _PayMode: Instance billing mode. Valid value:
<li>0: Pay-as-you-go.</li>
        :type PayMode: int
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _CoreCount: Number of core nodes to be added.
        :type CoreCount: int
        :param _TaskCount: Number of task nodes to be added.
        :type TaskCount: int
        :param _Currency: Currency.
        :type Currency: str
        :param _RouterCount: Number of router nodes to be added.
        :type RouterCount: int
        :param _MasterCount: Number of master nodes to be added.
        :type MasterCount: int
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        :param _HardwareResourceType: Scale-out resource type.
        :type HardwareResourceType: str
        """
        self._TimeUnit = None
        self._TimeSpan = None
        self._ZoneId = None
        self._PayMode = None
        self._InstanceId = None
        self._CoreCount = None
        self._TaskCount = None
        self._Currency = None
        self._RouterCount = None
        self._MasterCount = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None
        self._HardwareResourceType = None

    @property
    def TimeUnit(self):
        r"""Time unit of scale-out. Valid value:
<li>s: Second. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Time span of scale-out, which needs to be used together with `TimeUnit`.
<li>When `PayMode` is 0, `TimeSpan` can only be 3,600.</li>
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def ZoneId(self):
        r"""ID of the AZ where an instance resides.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PayMode(self):
        r"""Instance billing mode. Valid value:
<li>0: Pay-as-you-go.</li>
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CoreCount(self):
        r"""Number of core nodes to be added.
        :rtype: int
        """
        return self._CoreCount

    @CoreCount.setter
    def CoreCount(self, CoreCount):
        self._CoreCount = CoreCount

    @property
    def TaskCount(self):
        r"""Number of task nodes to be added.
        :rtype: int
        """
        return self._TaskCount

    @TaskCount.setter
    def TaskCount(self, TaskCount):
        self._TaskCount = TaskCount

    @property
    def Currency(self):
        r"""Currency.
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def RouterCount(self):
        r"""Number of router nodes to be added.
        :rtype: int
        """
        return self._RouterCount

    @RouterCount.setter
    def RouterCount(self, RouterCount):
        self._RouterCount = RouterCount

    @property
    def MasterCount(self):
        r"""Number of master nodes to be added.
        :rtype: int
        """
        return self._MasterCount

    @MasterCount.setter
    def MasterCount(self, MasterCount):
        self._MasterCount = MasterCount

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId

    @property
    def HardwareResourceType(self):
        r"""Scale-out resource type.
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType


    def _deserialize(self, params):
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        self._ZoneId = params.get("ZoneId")
        self._PayMode = params.get("PayMode")
        self._InstanceId = params.get("InstanceId")
        self._CoreCount = params.get("CoreCount")
        self._TaskCount = params.get("TaskCount")
        self._Currency = params.get("Currency")
        self._RouterCount = params.get("RouterCount")
        self._MasterCount = params.get("MasterCount")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        self._HardwareResourceType = params.get("HardwareResourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceScaleOutInstanceResponse(AbstractModel):
    r"""InquiryPriceScaleOutInstance response structure.

    """

    def __init__(self):
        r"""
        :param _OriginalCost: Original price.
        :type OriginalCost: str
        :param _DiscountCost: Discounted price.
        :type DiscountCost: str
        :param _Unit: Time unit of scale-out. Valid values.
<li>s: second.</li>
        :type Unit: str
        :param _PriceSpec: Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PriceSpec: :class:`tencentcloud.emr.v20190103.models.PriceResource`
        :param _MultipleEmrPrice: The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MultipleEmrPrice: list of EmrPrice
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginalCost = None
        self._DiscountCost = None
        self._Unit = None
        self._PriceSpec = None
        self._MultipleEmrPrice = None
        self._RequestId = None

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: str
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discounted price.
        :rtype: str
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost

    @property
    def Unit(self):
        r"""Time unit of scale-out. Valid values.
<li>s: second.</li>
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def PriceSpec(self):
        r"""Node spec queried for price.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PriceResource`
        """
        return self._PriceSpec

    @PriceSpec.setter
    def PriceSpec(self, PriceSpec):
        self._PriceSpec = PriceSpec

    @property
    def MultipleEmrPrice(self):
        r"""The inquiry results corresponding to the specs specified by the input parameter `MultipleResources`, with the result of the first spec returned by other output parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of EmrPrice
        """
        return self._MultipleEmrPrice

    @MultipleEmrPrice.setter
    def MultipleEmrPrice(self, MultipleEmrPrice):
        self._MultipleEmrPrice = MultipleEmrPrice

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        self._Unit = params.get("Unit")
        if params.get("PriceSpec") is not None:
            self._PriceSpec = PriceResource()
            self._PriceSpec._deserialize(params.get("PriceSpec"))
        if params.get("MultipleEmrPrice") is not None:
            self._MultipleEmrPrice = []
            for item in params.get("MultipleEmrPrice"):
                obj = EmrPrice()
                obj._deserialize(item)
                self._MultipleEmrPrice.append(obj)
        self._RequestId = params.get("RequestId")


class InquiryPriceUpdateInstanceRequest(AbstractModel):
    r"""InquiryPriceUpdateInstance request structure.

    """

    def __init__(self):
        r"""
        :param _TimeUnit: Time unit of scaling. Valid values:
<li>s: seconds. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
        :type TimeUnit: str
        :param _TimeSpan: Duration of scaling, which needs to be used together with `TimeUnit`.
<li>When `PayMode` is 0, `TimeSpan` can only be 3,600.</li>
        :type TimeSpan: int
        :param _PayMode: Instance billing mode. Valid values:
<li>0: pay-as-you-go.</li>
        :type PayMode: int
        :param _Currency: Currency.
        :type Currency: str
        :param _UpdateSpec: Target node specification.
        :type UpdateSpec: :class:`tencentcloud.emr.v20190103.models.UpdateInstanceSettings`
        :param _Placement: Instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :type Placement: :class:`tencentcloud.emr.v20190103.models.Placement`
        :param _ResourceIdList: The resource ID list for batch configuration change.
        :type ResourceIdList: list of str
        """
        self._TimeUnit = None
        self._TimeSpan = None
        self._PayMode = None
        self._Currency = None
        self._UpdateSpec = None
        self._Placement = None
        self._ResourceIdList = None

    @property
    def TimeUnit(self):
        r"""Time unit of scaling. Valid values:
<li>s: seconds. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Duration of scaling, which needs to be used together with `TimeUnit`.
<li>When `PayMode` is 0, `TimeSpan` can only be 3,600.</li>
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PayMode(self):
        r"""Instance billing mode. Valid values:
<li>0: pay-as-you-go.</li>
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Currency(self):
        r"""Currency.
        :rtype: str
        """
        return self._Currency

    @Currency.setter
    def Currency(self, Currency):
        self._Currency = Currency

    @property
    def UpdateSpec(self):
        r"""Target node specification.
        :rtype: :class:`tencentcloud.emr.v20190103.models.UpdateInstanceSettings`
        """
        return self._UpdateSpec

    @UpdateSpec.setter
    def UpdateSpec(self, UpdateSpec):
        self._UpdateSpec = UpdateSpec

    @property
    def Placement(self):
        r"""Instance location. This parameter is used to specify the AZ, project, and other attributes of the instance.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Placement`
        """
        return self._Placement

    @Placement.setter
    def Placement(self, Placement):
        self._Placement = Placement

    @property
    def ResourceIdList(self):
        r"""The resource ID list for batch configuration change.
        :rtype: list of str
        """
        return self._ResourceIdList

    @ResourceIdList.setter
    def ResourceIdList(self, ResourceIdList):
        self._ResourceIdList = ResourceIdList


    def _deserialize(self, params):
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        self._PayMode = params.get("PayMode")
        self._Currency = params.get("Currency")
        if params.get("UpdateSpec") is not None:
            self._UpdateSpec = UpdateInstanceSettings()
            self._UpdateSpec._deserialize(params.get("UpdateSpec"))
        if params.get("Placement") is not None:
            self._Placement = Placement()
            self._Placement._deserialize(params.get("Placement"))
        self._ResourceIdList = params.get("ResourceIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquiryPriceUpdateInstanceResponse(AbstractModel):
    r"""InquiryPriceUpdateInstance response structure.

    """

    def __init__(self):
        r"""
        :param _OriginalCost: Original price.
        :type OriginalCost: float
        :param _DiscountCost: Discounted price.
        :type DiscountCost: float
        :param _TimeUnit: Time unit of resizing. Valid values:
<li>s: second.</li>
        :type TimeUnit: str
        :param _TimeSpan: Desizing duration.
        :type TimeSpan: int
        :param _PriceDetail: Pricing details
Note: This field may return null, indicating that no valid values can be obtained.
        :type PriceDetail: list of PriceDetail
        :param _NewConfigPrice: New configuration price.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NewConfigPrice: :class:`tencentcloud.emr.v20190103.models.PriceResult`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OriginalCost = None
        self._DiscountCost = None
        self._TimeUnit = None
        self._TimeSpan = None
        self._PriceDetail = None
        self._NewConfigPrice = None
        self._RequestId = None

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discounted price.
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost

    @property
    def TimeUnit(self):
        r"""Time unit of resizing. Valid values:
<li>s: second.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Desizing duration.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PriceDetail(self):
        r"""Pricing details
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of PriceDetail
        """
        return self._PriceDetail

    @PriceDetail.setter
    def PriceDetail(self, PriceDetail):
        self._PriceDetail = PriceDetail

    @property
    def NewConfigPrice(self):
        r"""New configuration price.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PriceResult`
        """
        return self._NewConfigPrice

    @NewConfigPrice.setter
    def NewConfigPrice(self, NewConfigPrice):
        self._NewConfigPrice = NewConfigPrice

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        if params.get("PriceDetail") is not None:
            self._PriceDetail = []
            for item in params.get("PriceDetail"):
                obj = PriceDetail()
                obj._deserialize(item)
                self._PriceDetail.append(obj)
        if params.get("NewConfigPrice") is not None:
            self._NewConfigPrice = PriceResult()
            self._NewConfigPrice._deserialize(params.get("NewConfigPrice"))
        self._RequestId = params.get("RequestId")


class InsightResult(AbstractModel):
    r"""Insight result item.

    """

    def __init__(self):
        r"""
        :param _ID: When Type is HIVE, the value is Hive query ID; when Type is MAPREDUCE, SPARK or TEZ, the value is YarnAppID.
        :type ID: str
        :param _Type: Insight application type. Value values: HIVE, SPARK, MAPREDUCE, and TEZ.
        :type Type: str
        :param _RuleID: Insight rule ID.
HIVE-ScanManyMeta: too much scanned metadata.
HIVE-ScanManyPartition: large table scanning.
HIVE-SlowCompile: compilation duration too long.
HIVE-UnSuitableConfig: improper parameter.
MAPREDUCE-MapperDataSkew: Map data skew.
MAPREDUCE-MapperMemWaste: MapMemory resource waste.
MAPREDUCE-MapperSlowTask: slow map task.
MAPREDUCE-MapperTaskGC:MapperTaskGC
MAPREDUCE-MemExceeded: peak memory exceeded.
MAPREDUCE-ReducerDataSkew: Reduce data skew.
MAPREDUCE-ReducerMemWaste: ReduceMemory resource waste.
MAPREDUCE-ReducerSlowTask: slow reduce task.
MAPREDUCE-ReducerTaskGC:ReducerTaskGC
MAPREDUCE-SchedulingDelay: scheduling delay.
SPARK-CpuWaste: CPU resource waste.
SPARK-DataSkew: data skew.
SPARK-ExecutorGC:ExecutorGC
SPARK-MemExceeded: peak memory exceeded.
SPARK-MemWaste: Memory resource waste.
SPARK-ScheduleOverhead:ScheduleOverhead
SPARK-ScheduleSkew: scheduling skew.
SPARK-SlowTask: slow task.
TEZ-DataSkew: data skew.
TEZ-MapperDataSkew: Map data skew.
TEZ-ReducerDataSkew: Reduce data skew.
TEZ-TezMemWaste: Memory resource waste.
TEZ-TezSlowTask: slow task.
TEZ-TezTaskGC:TasksGC
        :type RuleID: str
        :param _RuleName: Insight rule name. Refer to the description of RuleID.
        :type RuleName: str
        :param _RuleExplain: Insight rules interpretation.
        :type RuleExplain: str
        :param _Detail: Details.
        :type Detail: str
        :param _Suggestion: Recommended message.
        :type Suggestion: str
        :param _Value: Anomaly metrics measure insight severity. Higher values indicate greater severity within the same insight category. Metrics across different insight types cannot be meaningfully compared.
        :type Value: int
        :param _ScheduleTaskExecID: Scheduling task execution ID.
        :type ScheduleTaskExecID: str
        :param _ScheduleFlowName: Scheduling flow, DAG.
        :type ScheduleFlowName: str
        :param _ScheduleTaskName: A Task node in the scheduling flow.
        :type ScheduleTaskName: str
        :param _JobConf: Core configurations for Yarn tasks.
        :type JobConf: str
        :param _Context: Insight structure information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Context: str
        """
        self._ID = None
        self._Type = None
        self._RuleID = None
        self._RuleName = None
        self._RuleExplain = None
        self._Detail = None
        self._Suggestion = None
        self._Value = None
        self._ScheduleTaskExecID = None
        self._ScheduleFlowName = None
        self._ScheduleTaskName = None
        self._JobConf = None
        self._Context = None

    @property
    def ID(self):
        r"""When Type is HIVE, the value is Hive query ID; when Type is MAPREDUCE, SPARK or TEZ, the value is YarnAppID.
        :rtype: str
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Type(self):
        r"""Insight application type. Value values: HIVE, SPARK, MAPREDUCE, and TEZ.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RuleID(self):
        r"""Insight rule ID.
HIVE-ScanManyMeta: too much scanned metadata.
HIVE-ScanManyPartition: large table scanning.
HIVE-SlowCompile: compilation duration too long.
HIVE-UnSuitableConfig: improper parameter.
MAPREDUCE-MapperDataSkew: Map data skew.
MAPREDUCE-MapperMemWaste: MapMemory resource waste.
MAPREDUCE-MapperSlowTask: slow map task.
MAPREDUCE-MapperTaskGC:MapperTaskGC
MAPREDUCE-MemExceeded: peak memory exceeded.
MAPREDUCE-ReducerDataSkew: Reduce data skew.
MAPREDUCE-ReducerMemWaste: ReduceMemory resource waste.
MAPREDUCE-ReducerSlowTask: slow reduce task.
MAPREDUCE-ReducerTaskGC:ReducerTaskGC
MAPREDUCE-SchedulingDelay: scheduling delay.
SPARK-CpuWaste: CPU resource waste.
SPARK-DataSkew: data skew.
SPARK-ExecutorGC:ExecutorGC
SPARK-MemExceeded: peak memory exceeded.
SPARK-MemWaste: Memory resource waste.
SPARK-ScheduleOverhead:ScheduleOverhead
SPARK-ScheduleSkew: scheduling skew.
SPARK-SlowTask: slow task.
TEZ-DataSkew: data skew.
TEZ-MapperDataSkew: Map data skew.
TEZ-ReducerDataSkew: Reduce data skew.
TEZ-TezMemWaste: Memory resource waste.
TEZ-TezSlowTask: slow task.
TEZ-TezTaskGC:TasksGC
        :rtype: str
        """
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def RuleName(self):
        r"""Insight rule name. Refer to the description of RuleID.
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleExplain(self):
        r"""Insight rules interpretation.
        :rtype: str
        """
        return self._RuleExplain

    @RuleExplain.setter
    def RuleExplain(self, RuleExplain):
        self._RuleExplain = RuleExplain

    @property
    def Detail(self):
        r"""Details.
        :rtype: str
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def Suggestion(self):
        r"""Recommended message.
        :rtype: str
        """
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Value(self):
        r"""Anomaly metrics measure insight severity. Higher values indicate greater severity within the same insight category. Metrics across different insight types cannot be meaningfully compared.
        :rtype: int
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ScheduleTaskExecID(self):
        r"""Scheduling task execution ID.
        :rtype: str
        """
        return self._ScheduleTaskExecID

    @ScheduleTaskExecID.setter
    def ScheduleTaskExecID(self, ScheduleTaskExecID):
        self._ScheduleTaskExecID = ScheduleTaskExecID

    @property
    def ScheduleFlowName(self):
        r"""Scheduling flow, DAG.
        :rtype: str
        """
        return self._ScheduleFlowName

    @ScheduleFlowName.setter
    def ScheduleFlowName(self, ScheduleFlowName):
        self._ScheduleFlowName = ScheduleFlowName

    @property
    def ScheduleTaskName(self):
        r"""A Task node in the scheduling flow.
        :rtype: str
        """
        return self._ScheduleTaskName

    @ScheduleTaskName.setter
    def ScheduleTaskName(self, ScheduleTaskName):
        self._ScheduleTaskName = ScheduleTaskName

    @property
    def JobConf(self):
        r"""Core configurations for Yarn tasks.
        :rtype: str
        """
        return self._JobConf

    @JobConf.setter
    def JobConf(self, JobConf):
        self._JobConf = JobConf

    @property
    def Context(self):
        r"""Insight structure information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context


    def _deserialize(self, params):
        self._ID = params.get("ID")
        self._Type = params.get("Type")
        self._RuleID = params.get("RuleID")
        self._RuleName = params.get("RuleName")
        self._RuleExplain = params.get("RuleExplain")
        self._Detail = params.get("Detail")
        self._Suggestion = params.get("Suggestion")
        self._Value = params.get("Value")
        self._ScheduleTaskExecID = params.get("ScheduleTaskExecID")
        self._ScheduleFlowName = params.get("ScheduleFlowName")
        self._ScheduleTaskName = params.get("ScheduleTaskName")
        self._JobConf = params.get("JobConf")
        self._Context = params.get("Context")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InspectionTaskSettings(AbstractModel):
    r"""Setting inspection task configurations.

    """

    def __init__(self):
        r"""
        :param _TaskType: Unique identifier for inspection tasks.
        :type TaskType: str
        :param _Group: Inspection task group name.
        :type Group: str
        :param _Name: Inspection task name.
        :type Name: str
        :param _TaskSettings: Inspection task parameter settings.
        :type TaskSettings: list of TaskSettings
        :param _Selected: Whether it is selected, with the valid values of "true" and "false".
        :type Selected: str
        :param _Enable: Whether monitoring is enabled.
        :type Enable: str
        :param _SettingsJson: Event JSON template.
        :type SettingsJson: str
        """
        self._TaskType = None
        self._Group = None
        self._Name = None
        self._TaskSettings = None
        self._Selected = None
        self._Enable = None
        self._SettingsJson = None

    @property
    def TaskType(self):
        r"""Unique identifier for inspection tasks.
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Group(self):
        r"""Inspection task group name.
        :rtype: str
        """
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group

    @property
    def Name(self):
        r"""Inspection task name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TaskSettings(self):
        r"""Inspection task parameter settings.
        :rtype: list of TaskSettings
        """
        return self._TaskSettings

    @TaskSettings.setter
    def TaskSettings(self, TaskSettings):
        self._TaskSettings = TaskSettings

    @property
    def Selected(self):
        r"""Whether it is selected, with the valid values of "true" and "false".
        :rtype: str
        """
        return self._Selected

    @Selected.setter
    def Selected(self, Selected):
        self._Selected = Selected

    @property
    def Enable(self):
        r"""Whether monitoring is enabled.
        :rtype: str
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def SettingsJson(self):
        r"""Event JSON template.
        :rtype: str
        """
        return self._SettingsJson

    @SettingsJson.setter
    def SettingsJson(self, SettingsJson):
        self._SettingsJson = SettingsJson


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Group = params.get("Group")
        self._Name = params.get("Name")
        if params.get("TaskSettings") is not None:
            self._TaskSettings = []
            for item in params.get("TaskSettings"):
                obj = TaskSettings()
                obj._deserialize(item)
                self._TaskSettings.append(obj)
        self._Selected = params.get("Selected")
        self._Enable = params.get("Enable")
        self._SettingsJson = params.get("SettingsJson")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceChargePrepaid(AbstractModel):
    r"""Instance prepayment parameter. This parameter is valid only when the payment type is PREPAID.

    """

    def __init__(self):
        r"""
        :param _Period: The period of monthly subscription, which defaults to 1 and is expressed in month.
Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36, 48, 60.
        :type Period: int
        :param _RenewFlag: Whether to enable auto-renewal. Valid values:
<li>`true`: Enable</li>
<li>`false` (default): Disable</li>
        :type RenewFlag: bool
        """
        self._Period = None
        self._RenewFlag = None

    @property
    def Period(self):
        r"""The period of monthly subscription, which defaults to 1 and is expressed in month.
Valid values: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36, 48, 60.
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def RenewFlag(self):
        r"""Whether to enable auto-renewal. Valid values:
<li>`true`: Enable</li>
<li>`false` (default): Disable</li>
        :rtype: bool
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._Period = params.get("Period")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Item(AbstractModel):
    r"""A key-value structure

    """

    def __init__(self):
        r"""
        :param _Key: Key value.
        :type Key: str
        :param _Value: Value.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""Key value.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ItemSeq(AbstractModel):
    r"""List of key-value pairs

    """

    def __init__(self):
        r"""
        :param _Items: Tag name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of Item
        """
        self._Items = None

    @property
    def Items(self):
        r"""Tag name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Item
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Item()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KeyValue(AbstractModel):
    r"""Key-value pair, primarily used for filtering

    """

    def __init__(self):
        r"""
        :param _Key: Key.
        :type Key: str
        :param _Value: Value.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""Key.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KyuubiQueryInfo(AbstractModel):
    r"""Kyuubi query information.

    """

    def __init__(self):
        r"""
        :param _ClientIP: Submitter IP address.
        :type ClientIP: str
        :param _Duration: Execution duration.
        :type Duration: int
        :param _EndTime: End time.
        :type EndTime: int
        :param _EngineID: Engine Id
        :type EngineID: str
        :param _EngineType: Computing engine.
        :type EngineType: str
        :param _Id: ID
        :type Id: str
        :param _SessionID: Session Id
        :type SessionID: str
        :param _BeginTime: Start time.
        :type BeginTime: int
        :param _ExecutionState: Execution status.
        :type ExecutionState: str
        :param _ExecutionStatement: Execution statement.
        :type ExecutionStatement: str
        :param _StatementID: Statement Id
        :type StatementID: str
        :param _User: User who submits requests.
        :type User: str
        """
        self._ClientIP = None
        self._Duration = None
        self._EndTime = None
        self._EngineID = None
        self._EngineType = None
        self._Id = None
        self._SessionID = None
        self._BeginTime = None
        self._ExecutionState = None
        self._ExecutionStatement = None
        self._StatementID = None
        self._User = None

    @property
    def ClientIP(self):
        r"""Submitter IP address.
        :rtype: str
        """
        return self._ClientIP

    @ClientIP.setter
    def ClientIP(self, ClientIP):
        self._ClientIP = ClientIP

    @property
    def Duration(self):
        r"""Execution duration.
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def EndTime(self):
        r"""End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def EngineID(self):
        r"""Engine Id
        :rtype: str
        """
        return self._EngineID

    @EngineID.setter
    def EngineID(self, EngineID):
        self._EngineID = EngineID

    @property
    def EngineType(self):
        r"""Computing engine.
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def Id(self):
        r"""ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def SessionID(self):
        r"""Session Id
        :rtype: str
        """
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID

    @property
    def BeginTime(self):
        r"""Start time.
        :rtype: int
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def ExecutionState(self):
        r"""Execution status.
        :rtype: str
        """
        return self._ExecutionState

    @ExecutionState.setter
    def ExecutionState(self, ExecutionState):
        self._ExecutionState = ExecutionState

    @property
    def ExecutionStatement(self):
        r"""Execution statement.
        :rtype: str
        """
        return self._ExecutionStatement

    @ExecutionStatement.setter
    def ExecutionStatement(self, ExecutionStatement):
        self._ExecutionStatement = ExecutionStatement

    @property
    def StatementID(self):
        r"""Statement Id
        :rtype: str
        """
        return self._StatementID

    @StatementID.setter
    def StatementID(self, StatementID):
        self._StatementID = StatementID

    @property
    def User(self):
        r"""User who submits requests.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User


    def _deserialize(self, params):
        self._ClientIP = params.get("ClientIP")
        self._Duration = params.get("Duration")
        self._EndTime = params.get("EndTime")
        self._EngineID = params.get("EngineID")
        self._EngineType = params.get("EngineType")
        self._Id = params.get("Id")
        self._SessionID = params.get("SessionID")
        self._BeginTime = params.get("BeginTime")
        self._ExecutionState = params.get("ExecutionState")
        self._ExecutionStatement = params.get("ExecutionStatement")
        self._StatementID = params.get("StatementID")
        self._User = params.get("User")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadAutoScaleStrategy(AbstractModel):
    r"""Automatic scaling rule based on load metrics

    """

    def __init__(self):
        r"""
        :param _StrategyId: Rule ID.
        :type StrategyId: int
        :param _StrategyName: Rule name.
        :type StrategyName: str
        :param _CalmDownTime: Cooling time for a rule to take effect.
        :type CalmDownTime: int
        :param _ScaleAction: Scaling action. 1: scale-out, 2: scale-in.
        :type ScaleAction: int
        :param _ScaleNum: Scaling amount each time the rule takes effect.
        :type ScaleNum: int
        :param _ProcessMethod: Metric processing method. 1: MAX, 2: MIN, 3: AVG.
        :type ProcessMethod: int
        :param _Priority: Rule priority, which is not applicable during adding. The default is auto-increment.
        :type Priority: int
        :param _StrategyStatus: Rule status. 1: enabled, 3: disabled.
        :type StrategyStatus: int
        :param _YarnNodeLabel: Specified Yarn Node Label for rule scale-out.
        :type YarnNodeLabel: str
        :param _PeriodValid: Effective time of the rule
        :type PeriodValid: str
        :param _GraceDownFlag: Graceful scale-in switch
        :type GraceDownFlag: bool
        :param _GraceDownTime: Graceful scale-in wait time
        :type GraceDownTime: int
        :param _Tags: Bound tag list

Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _ConfigGroupAssigned: Preset configuration group.
        :type ConfigGroupAssigned: str
        :param _MeasureMethod: Calculation method of scale-out resources:"DEFAULT","INSTANCE", "CPU", "MEMORYGB".
"DEFAULT" indicates the default method, which is the same as "INSTANCE".
"INSTANCE" indicates calculation based on nodes (default mode).
"CPU" indicates calculation based on the quantity of cores of the machine.
"MEMORYGB" indicates calculation based on the memory size of the machine.
        :type MeasureMethod: str
        :param _SoftDeployDesc: Node deployment service list, such as ["HDFS-3.1.2","YARN-3.1.2"].
Note: This field may return null, indicating that no valid values can be obtained.
        :type SoftDeployDesc: list of str
        :param _ServiceNodeDesc: Startup process list, such as ["NodeManager"].
        :type ServiceNodeDesc: str
        :param _ServiceNodeInfo: Startup process list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceNodeInfo: list of int
        :param _SoftDeployInfo: Node deployment service list. Only HDFS and YARN should be specified in the deployment service list. For details, see [Mapping Table for Component Names](https://www.tencentcloud.comom/document/product/589/98760?from_cn_redirect=1).
Note: This field may return null, indicating that no valid values can be obtained.
        :type SoftDeployInfo: list of int
        :param _LoadMetricsConditions: Multi-metric trigger condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadMetricsConditions: :class:`tencentcloud.emr.v20190103.models.LoadMetricsConditions`
        :param _GroupId: Scaling group ID.
        :type GroupId: int
        :param _Soft: Soft (for example, YARN).
        :type Soft: str
        """
        self._StrategyId = None
        self._StrategyName = None
        self._CalmDownTime = None
        self._ScaleAction = None
        self._ScaleNum = None
        self._ProcessMethod = None
        self._Priority = None
        self._StrategyStatus = None
        self._YarnNodeLabel = None
        self._PeriodValid = None
        self._GraceDownFlag = None
        self._GraceDownTime = None
        self._Tags = None
        self._ConfigGroupAssigned = None
        self._MeasureMethod = None
        self._SoftDeployDesc = None
        self._ServiceNodeDesc = None
        self._ServiceNodeInfo = None
        self._SoftDeployInfo = None
        self._LoadMetricsConditions = None
        self._GroupId = None
        self._Soft = None

    @property
    def StrategyId(self):
        r"""Rule ID.
        :rtype: int
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def StrategyName(self):
        r"""Rule name.
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def CalmDownTime(self):
        r"""Cooling time for a rule to take effect.
        :rtype: int
        """
        return self._CalmDownTime

    @CalmDownTime.setter
    def CalmDownTime(self, CalmDownTime):
        self._CalmDownTime = CalmDownTime

    @property
    def ScaleAction(self):
        r"""Scaling action. 1: scale-out, 2: scale-in.
        :rtype: int
        """
        return self._ScaleAction

    @ScaleAction.setter
    def ScaleAction(self, ScaleAction):
        self._ScaleAction = ScaleAction

    @property
    def ScaleNum(self):
        r"""Scaling amount each time the rule takes effect.
        :rtype: int
        """
        return self._ScaleNum

    @ScaleNum.setter
    def ScaleNum(self, ScaleNum):
        self._ScaleNum = ScaleNum

    @property
    def ProcessMethod(self):
        r"""Metric processing method. 1: MAX, 2: MIN, 3: AVG.
        :rtype: int
        """
        return self._ProcessMethod

    @ProcessMethod.setter
    def ProcessMethod(self, ProcessMethod):
        self._ProcessMethod = ProcessMethod

    @property
    def Priority(self):
        r"""Rule priority, which is not applicable during adding. The default is auto-increment.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def StrategyStatus(self):
        r"""Rule status. 1: enabled, 3: disabled.
        :rtype: int
        """
        return self._StrategyStatus

    @StrategyStatus.setter
    def StrategyStatus(self, StrategyStatus):
        self._StrategyStatus = StrategyStatus

    @property
    def YarnNodeLabel(self):
        r"""Specified Yarn Node Label for rule scale-out.
        :rtype: str
        """
        return self._YarnNodeLabel

    @YarnNodeLabel.setter
    def YarnNodeLabel(self, YarnNodeLabel):
        self._YarnNodeLabel = YarnNodeLabel

    @property
    def PeriodValid(self):
        r"""Effective time of the rule
        :rtype: str
        """
        return self._PeriodValid

    @PeriodValid.setter
    def PeriodValid(self, PeriodValid):
        self._PeriodValid = PeriodValid

    @property
    def GraceDownFlag(self):
        r"""Graceful scale-in switch
        :rtype: bool
        """
        return self._GraceDownFlag

    @GraceDownFlag.setter
    def GraceDownFlag(self, GraceDownFlag):
        self._GraceDownFlag = GraceDownFlag

    @property
    def GraceDownTime(self):
        r"""Graceful scale-in wait time
        :rtype: int
        """
        return self._GraceDownTime

    @GraceDownTime.setter
    def GraceDownTime(self, GraceDownTime):
        self._GraceDownTime = GraceDownTime

    @property
    def Tags(self):
        r"""Bound tag list

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ConfigGroupAssigned(self):
        r"""Preset configuration group.
        :rtype: str
        """
        return self._ConfigGroupAssigned

    @ConfigGroupAssigned.setter
    def ConfigGroupAssigned(self, ConfigGroupAssigned):
        self._ConfigGroupAssigned = ConfigGroupAssigned

    @property
    def MeasureMethod(self):
        r"""Calculation method of scale-out resources:"DEFAULT","INSTANCE", "CPU", "MEMORYGB".
"DEFAULT" indicates the default method, which is the same as "INSTANCE".
"INSTANCE" indicates calculation based on nodes (default mode).
"CPU" indicates calculation based on the quantity of cores of the machine.
"MEMORYGB" indicates calculation based on the memory size of the machine.
        :rtype: str
        """
        return self._MeasureMethod

    @MeasureMethod.setter
    def MeasureMethod(self, MeasureMethod):
        self._MeasureMethod = MeasureMethod

    @property
    def SoftDeployDesc(self):
        r"""Node deployment service list, such as ["HDFS-3.1.2","YARN-3.1.2"].
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SoftDeployDesc

    @SoftDeployDesc.setter
    def SoftDeployDesc(self, SoftDeployDesc):
        self._SoftDeployDesc = SoftDeployDesc

    @property
    def ServiceNodeDesc(self):
        r"""Startup process list, such as ["NodeManager"].
        :rtype: str
        """
        return self._ServiceNodeDesc

    @ServiceNodeDesc.setter
    def ServiceNodeDesc(self, ServiceNodeDesc):
        self._ServiceNodeDesc = ServiceNodeDesc

    @property
    def ServiceNodeInfo(self):
        r"""Startup process list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._ServiceNodeInfo

    @ServiceNodeInfo.setter
    def ServiceNodeInfo(self, ServiceNodeInfo):
        self._ServiceNodeInfo = ServiceNodeInfo

    @property
    def SoftDeployInfo(self):
        r"""Node deployment service list. Only HDFS and YARN should be specified in the deployment service list. For details, see [Mapping Table for Component Names](https://www.tencentcloud.comom/document/product/589/98760?from_cn_redirect=1).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._SoftDeployInfo

    @SoftDeployInfo.setter
    def SoftDeployInfo(self, SoftDeployInfo):
        self._SoftDeployInfo = SoftDeployInfo

    @property
    def LoadMetricsConditions(self):
        r"""Multi-metric trigger condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.LoadMetricsConditions`
        """
        return self._LoadMetricsConditions

    @LoadMetricsConditions.setter
    def LoadMetricsConditions(self, LoadMetricsConditions):
        self._LoadMetricsConditions = LoadMetricsConditions

    @property
    def GroupId(self):
        r"""Scaling group ID.
        :rtype: int
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def Soft(self):
        r"""Soft (for example, YARN).
        :rtype: str
        """
        return self._Soft

    @Soft.setter
    def Soft(self, Soft):
        self._Soft = Soft


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._StrategyName = params.get("StrategyName")
        self._CalmDownTime = params.get("CalmDownTime")
        self._ScaleAction = params.get("ScaleAction")
        self._ScaleNum = params.get("ScaleNum")
        self._ProcessMethod = params.get("ProcessMethod")
        self._Priority = params.get("Priority")
        self._StrategyStatus = params.get("StrategyStatus")
        self._YarnNodeLabel = params.get("YarnNodeLabel")
        self._PeriodValid = params.get("PeriodValid")
        self._GraceDownFlag = params.get("GraceDownFlag")
        self._GraceDownTime = params.get("GraceDownTime")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ConfigGroupAssigned = params.get("ConfigGroupAssigned")
        self._MeasureMethod = params.get("MeasureMethod")
        self._SoftDeployDesc = params.get("SoftDeployDesc")
        self._ServiceNodeDesc = params.get("ServiceNodeDesc")
        self._ServiceNodeInfo = params.get("ServiceNodeInfo")
        self._SoftDeployInfo = params.get("SoftDeployInfo")
        if params.get("LoadMetricsConditions") is not None:
            self._LoadMetricsConditions = LoadMetricsConditions()
            self._LoadMetricsConditions._deserialize(params.get("LoadMetricsConditions"))
        self._GroupId = params.get("GroupId")
        self._Soft = params.get("Soft")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadMetricsCondition(AbstractModel):
    r"""Load metric condition.

    """

    def __init__(self):
        r"""
        :param _StatisticPeriod: Rule statistics cycle. Options include 1 min, 3 min, and 5 min.
        :type StatisticPeriod: int
        :param _TriggerThreshold: Trigger count. Scaling begins only after it has been triggered continuously more than TriggerThreshold times.
        :type TriggerThreshold: int
        :param _LoadMetrics: Scaling load metric.
        :type LoadMetrics: str
        :param _MetricId: Rule metadata record ID.
        :type MetricId: int
        :param _Conditions: Trigger condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Conditions: list of TriggerCondition
        """
        self._StatisticPeriod = None
        self._TriggerThreshold = None
        self._LoadMetrics = None
        self._MetricId = None
        self._Conditions = None

    @property
    def StatisticPeriod(self):
        r"""Rule statistics cycle. Options include 1 min, 3 min, and 5 min.
        :rtype: int
        """
        return self._StatisticPeriod

    @StatisticPeriod.setter
    def StatisticPeriod(self, StatisticPeriod):
        self._StatisticPeriod = StatisticPeriod

    @property
    def TriggerThreshold(self):
        r"""Trigger count. Scaling begins only after it has been triggered continuously more than TriggerThreshold times.
        :rtype: int
        """
        return self._TriggerThreshold

    @TriggerThreshold.setter
    def TriggerThreshold(self, TriggerThreshold):
        self._TriggerThreshold = TriggerThreshold

    @property
    def LoadMetrics(self):
        r"""Scaling load metric.
        :rtype: str
        """
        return self._LoadMetrics

    @LoadMetrics.setter
    def LoadMetrics(self, LoadMetrics):
        self._LoadMetrics = LoadMetrics

    @property
    def MetricId(self):
        r"""Rule metadata record ID.
        :rtype: int
        """
        return self._MetricId

    @MetricId.setter
    def MetricId(self, MetricId):
        self._MetricId = MetricId

    @property
    def Conditions(self):
        r"""Trigger condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TriggerCondition
        """
        return self._Conditions

    @Conditions.setter
    def Conditions(self, Conditions):
        self._Conditions = Conditions


    def _deserialize(self, params):
        self._StatisticPeriod = params.get("StatisticPeriod")
        self._TriggerThreshold = params.get("TriggerThreshold")
        self._LoadMetrics = params.get("LoadMetrics")
        self._MetricId = params.get("MetricId")
        if params.get("Conditions") is not None:
            self._Conditions = []
            for item in params.get("Conditions"):
                obj = TriggerCondition()
                obj._deserialize(item)
                self._Conditions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadMetricsConditions(AbstractModel):
    r"""Load metric.

    """

    def __init__(self):
        r"""
        :param _LoadMetrics: Trigger rule condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadMetrics: list of LoadMetricsCondition
        :param _Match: 0: all conditions should be met.
1: any one of the conditions is met.
        :type Match: int
        """
        self._LoadMetrics = None
        self._Match = None

    @property
    def LoadMetrics(self):
        r"""Trigger rule condition.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of LoadMetricsCondition
        """
        return self._LoadMetrics

    @LoadMetrics.setter
    def LoadMetrics(self, LoadMetrics):
        self._LoadMetrics = LoadMetrics

    @property
    def Match(self):
        r"""0: all conditions should be met.
1: any one of the conditions is met.
        :rtype: int
        """
        return self._Match

    @Match.setter
    def Match(self, Match):
        self._Match = Match


    def _deserialize(self, params):
        if params.get("LoadMetrics") is not None:
            self._LoadMetrics = []
            for item in params.get("LoadMetrics"):
                obj = LoadMetricsCondition()
                obj._deserialize(item)
                self._LoadMetrics.append(obj)
        self._Match = params.get("Match")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoginSettings(AbstractModel):
    r"""Login settings

    """

    def __init__(self):
        r"""
        :param _Password: The login password of the instance, which contains 8 to 16 uppercase letters, lowercase letters, digits, and special characters (only !@%^*) and cannot start with a special character.
        :type Password: str
        :param _PublicKeyId: The key ID. After an instance is associated with a key, you can access it with the private key in the key pair. You can call [DescribeKeyPairs](https://intl.cloud.tencent.com/document/api/213/15699?from_cn_redirect=1) to obtain `PublicKeyId`.
        :type PublicKeyId: str
        """
        self._Password = None
        self._PublicKeyId = None

    @property
    def Password(self):
        r"""The login password of the instance, which contains 8 to 16 uppercase letters, lowercase letters, digits, and special characters (only !@%^*) and cannot start with a special character.
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def PublicKeyId(self):
        r"""The key ID. After an instance is associated with a key, you can access it with the private key in the key pair. You can call [DescribeKeyPairs](https://intl.cloud.tencent.com/document/api/213/15699?from_cn_redirect=1) to obtain `PublicKeyId`.
        :rtype: str
        """
        return self._PublicKeyId

    @PublicKeyId.setter
    def PublicKeyId(self, PublicKeyId):
        self._PublicKeyId = PublicKeyId


    def _deserialize(self, params):
        self._Password = params.get("Password")
        self._PublicKeyId = params.get("PublicKeyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MetricTags(AbstractModel):
    r"""Metric tag.

    """

    def __init__(self):
        r"""
        :param _Unit: Metric Unit.
        :type Unit: str
        :param _Type: Metric type.
        :type Type: str
        """
        self._Unit = None
        self._Type = None

    @property
    def Unit(self):
        r"""Metric Unit.
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def Type(self):
        r"""Metric type.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Unit = params.get("Unit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAutoRenewFlagRequest(AbstractModel):
    r"""ModifyAutoRenewFlag request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _ResourceIds: Instance ID.
        :type ResourceIds: list of str
        :param _RenewFlag: NOTIFY_AND_MANUAL_RENEW: Notification of impending expiration, without auto-renewal. NOTIFY_AND_AUTO_RENEW: Notification of impending expiration, with auto-renewal. DISABLE_NOTIFY_AND_MANUAL_RENEW: No notification of impending expiration, without auto-renewal.
        :type RenewFlag: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        """
        self._InstanceId = None
        self._ResourceIds = None
        self._RenewFlag = None
        self._ComputeResourceId = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceIds(self):
        r"""Instance ID.
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def RenewFlag(self):
        r"""NOTIFY_AND_MANUAL_RENEW: Notification of impending expiration, without auto-renewal. NOTIFY_AND_AUTO_RENEW: Notification of impending expiration, with auto-renewal. DISABLE_NOTIFY_AND_MANUAL_RENEW: No notification of impending expiration, without auto-renewal.
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ResourceIds = params.get("ResourceIds")
        self._RenewFlag = params.get("RenewFlag")
        self._ComputeResourceId = params.get("ComputeResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAutoRenewFlagResponse(AbstractModel):
    r"""ModifyAutoRenewFlag response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAutoScaleStrategyRequest(AbstractModel):
    r"""ModifyAutoScaleStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _StrategyType: Automatic scaling rule type. 1: Scaling by load metrics; 2: Scaling by time
        :type StrategyType: int
        :param _LoadAutoScaleStrategies: Metric for load-based scaling.
        :type LoadAutoScaleStrategies: list of LoadAutoScaleStrategy
        :param _TimeAutoScaleStrategies: Rule for time-based scaling
        :type TimeAutoScaleStrategies: list of TimeAutoScaleStrategy
        :param _GroupId: Scaling group ID.
        :type GroupId: int
        """
        self._InstanceId = None
        self._StrategyType = None
        self._LoadAutoScaleStrategies = None
        self._TimeAutoScaleStrategies = None
        self._GroupId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StrategyType(self):
        r"""Automatic scaling rule type. 1: Scaling by load metrics; 2: Scaling by time
        :rtype: int
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def LoadAutoScaleStrategies(self):
        r"""Metric for load-based scaling.
        :rtype: list of LoadAutoScaleStrategy
        """
        return self._LoadAutoScaleStrategies

    @LoadAutoScaleStrategies.setter
    def LoadAutoScaleStrategies(self, LoadAutoScaleStrategies):
        self._LoadAutoScaleStrategies = LoadAutoScaleStrategies

    @property
    def TimeAutoScaleStrategies(self):
        r"""Rule for time-based scaling
        :rtype: list of TimeAutoScaleStrategy
        """
        return self._TimeAutoScaleStrategies

    @TimeAutoScaleStrategies.setter
    def TimeAutoScaleStrategies(self, TimeAutoScaleStrategies):
        self._TimeAutoScaleStrategies = TimeAutoScaleStrategies

    @property
    def GroupId(self):
        r"""Scaling group ID.
        :rtype: int
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StrategyType = params.get("StrategyType")
        if params.get("LoadAutoScaleStrategies") is not None:
            self._LoadAutoScaleStrategies = []
            for item in params.get("LoadAutoScaleStrategies"):
                obj = LoadAutoScaleStrategy()
                obj._deserialize(item)
                self._LoadAutoScaleStrategies.append(obj)
        if params.get("TimeAutoScaleStrategies") is not None:
            self._TimeAutoScaleStrategies = []
            for item in params.get("TimeAutoScaleStrategies"):
                obj = TimeAutoScaleStrategy()
                obj._deserialize(item)
                self._TimeAutoScaleStrategies.append(obj)
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAutoScaleStrategyResponse(AbstractModel):
    r"""ModifyAutoScaleStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyGlobalConfigRequest(AbstractModel):
    r"""ModifyGlobalConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: English ID of the EMR cluster.
        :type InstanceId: str
        :param _Items: List of modified configurations. Key values have a one-to-one correspondence with the output parameters of the `DescribeGlobalConfig` API and are case-insensitive (if an error occurs indicating the key cannot be found, refer to the output parameters). The values are:
1. enableResourceSchedule: Enables or disables resource scheduling. When disabling, a synchronous operation option (sync) is available with values true or false.
2. scheduler type: scheduler.
2. enableLabel: Enables or disables tags, with values true or false.
2. tag directory: labelDir.
3. whether to overwrite the user-specified queue, with values true or false.
4. userMaxAppsDefault: program upper limit.
5. dynamic configuration item: Corresponds to the Name field in the DefaultSettings object returned by the DescribeGlobalConfig API.
The values are strings. For **whether to overwrite the user-specified queue** and **program upper limit**, null in the JSON specifications means clearing the value of this configuration. Individual configuration items can be modified. For **dynamic configurations**, a full transmission is required to perform overwriting.
        :type Items: list of Item
        """
        self._InstanceId = None
        self._Items = None

    @property
    def InstanceId(self):
        r"""English ID of the EMR cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Items(self):
        r"""List of modified configurations. Key values have a one-to-one correspondence with the output parameters of the `DescribeGlobalConfig` API and are case-insensitive (if an error occurs indicating the key cannot be found, refer to the output parameters). The values are:
1. enableResourceSchedule: Enables or disables resource scheduling. When disabling, a synchronous operation option (sync) is available with values true or false.
2. scheduler type: scheduler.
2. enableLabel: Enables or disables tags, with values true or false.
2. tag directory: labelDir.
3. whether to overwrite the user-specified queue, with values true or false.
4. userMaxAppsDefault: program upper limit.
5. dynamic configuration item: Corresponds to the Name field in the DefaultSettings object returned by the DescribeGlobalConfig API.
The values are strings. For **whether to overwrite the user-specified queue** and **program upper limit**, null in the JSON specifications means clearing the value of this configuration. Individual configuration items can be modified. For **dynamic configurations**, a full transmission is required to perform overwriting.
        :rtype: list of Item
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Item()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGlobalConfigResponse(AbstractModel):
    r"""ModifyGlobalConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInspectionSettingsRequest(AbstractModel):
    r"""ModifyInspectionSettings request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _Type: Inspection type, FixedTime or RealTime.
        :type Type: str
        :param _Settings: Task configurations.
        :type Settings: list of InspectionTaskSettings
        :param _StartTime: Start timestamp.
        :type StartTime: int
        :param _EndTime: End timestamp.
        :type EndTime: int
        :param _Strategy: Inspection cycle, such as EveryDay, EveryWeek or EveryMonth.
        :type Strategy: str
        :param _Clock: Start time of each day.
        :type Clock: str
        :param _DayOfWeek: Day of the week.
        :type DayOfWeek: str
        :param _DayOfMonth: Number of the day in a month.
        :type DayOfMonth: str
        :param _JobId: Inspection job ID.
        :type JobId: str
        """
        self._InstanceId = None
        self._Type = None
        self._Settings = None
        self._StartTime = None
        self._EndTime = None
        self._Strategy = None
        self._Clock = None
        self._DayOfWeek = None
        self._DayOfMonth = None
        self._JobId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Type(self):
        r"""Inspection type, FixedTime or RealTime.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Settings(self):
        r"""Task configurations.
        :rtype: list of InspectionTaskSettings
        """
        return self._Settings

    @Settings.setter
    def Settings(self, Settings):
        self._Settings = Settings

    @property
    def StartTime(self):
        r"""Start timestamp.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End timestamp.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Strategy(self):
        r"""Inspection cycle, such as EveryDay, EveryWeek or EveryMonth.
        :rtype: str
        """
        return self._Strategy

    @Strategy.setter
    def Strategy(self, Strategy):
        self._Strategy = Strategy

    @property
    def Clock(self):
        r"""Start time of each day.
        :rtype: str
        """
        return self._Clock

    @Clock.setter
    def Clock(self, Clock):
        self._Clock = Clock

    @property
    def DayOfWeek(self):
        r"""Day of the week.
        :rtype: str
        """
        return self._DayOfWeek

    @DayOfWeek.setter
    def DayOfWeek(self, DayOfWeek):
        self._DayOfWeek = DayOfWeek

    @property
    def DayOfMonth(self):
        r"""Number of the day in a month.
        :rtype: str
        """
        return self._DayOfMonth

    @DayOfMonth.setter
    def DayOfMonth(self, DayOfMonth):
        self._DayOfMonth = DayOfMonth

    @property
    def JobId(self):
        r"""Inspection job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Type = params.get("Type")
        if params.get("Settings") is not None:
            self._Settings = []
            for item in params.get("Settings"):
                obj = InspectionTaskSettings()
                obj._deserialize(item)
                self._Settings.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Strategy = params.get("Strategy")
        self._Clock = params.get("Clock")
        self._DayOfWeek = params.get("DayOfWeek")
        self._DayOfMonth = params.get("DayOfMonth")
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInspectionSettingsResponse(AbstractModel):
    r"""ModifyInspectionSettings response structure.

    """

    def __init__(self):
        r"""
        :param _Info: Description of the returned value.
        :type Info: str
        :param _JobId: ID of the successfully modified inspection task.
        :type JobId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Info = None
        self._JobId = None
        self._RequestId = None

    @property
    def Info(self):
        r"""Description of the returned value.
        :rtype: str
        """
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def JobId(self):
        r"""ID of the successfully modified inspection task.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Info = params.get("Info")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class ModifyInstanceBasicRequest(AbstractModel):
    r"""ModifyInstanceBasic request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ClusterName: Cluster name.
        :type ClusterName: str
        :param _ResourceBaseType: Used to label computing resources that need to be modified.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID that needs to be modified, and can be used together with ResourceBaseType.
        :type ComputeResourceId: str
        """
        self._InstanceId = None
        self._ClusterName = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterName(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ResourceBaseType(self):
        r"""Used to label computing resources that need to be modified.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID that needs to be modified, and can be used together with ResourceBaseType.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterName = params.get("ClusterName")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceBasicResponse(AbstractModel):
    r"""ModifyInstanceBasic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyResourceRequest(AbstractModel):
    r"""ModifyResource request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _PayMode: Billing type.
        :type PayMode: int
        :param _NewCpu: Resized CPU.
        :type NewCpu: int
        :param _NewMem: Resized memory.
        :type NewMem: int
        :param _ClientToken: Token
        :type ClientToken: str
        :param _InstanceType: Resized machine specifications.
        :type InstanceType: str
        :param _ResourceIdList: Node ID List.
        :type ResourceIdList: list of str
        """
        self._InstanceId = None
        self._PayMode = None
        self._NewCpu = None
        self._NewMem = None
        self._ClientToken = None
        self._InstanceType = None
        self._ResourceIdList = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PayMode(self):
        r"""Billing type.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def NewCpu(self):
        r"""Resized CPU.
        :rtype: int
        """
        return self._NewCpu

    @NewCpu.setter
    def NewCpu(self, NewCpu):
        self._NewCpu = NewCpu

    @property
    def NewMem(self):
        r"""Resized memory.
        :rtype: int
        """
        return self._NewMem

    @NewMem.setter
    def NewMem(self, NewMem):
        self._NewMem = NewMem

    @property
    def ClientToken(self):
        r"""Token
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def InstanceType(self):
        r"""Resized machine specifications.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def ResourceIdList(self):
        r"""Node ID List.
        :rtype: list of str
        """
        return self._ResourceIdList

    @ResourceIdList.setter
    def ResourceIdList(self, ResourceIdList):
        self._ResourceIdList = ResourceIdList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._PayMode = params.get("PayMode")
        self._NewCpu = params.get("NewCpu")
        self._NewMem = params.get("NewMem")
        self._ClientToken = params.get("ClientToken")
        self._InstanceType = params.get("InstanceType")
        self._ResourceIdList = params.get("ResourceIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourceResponse(AbstractModel):
    r"""ModifyResource response structure.

    """

    def __init__(self):
        r"""
        :param _TraceId: Process traceId.
        :type TraceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TraceId = None
        self._RequestId = None

    @property
    def TraceId(self):
        r"""Process traceId.
        :rtype: str
        """
        return self._TraceId

    @TraceId.setter
    def TraceId(self, TraceId):
        self._TraceId = TraceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TraceId = params.get("TraceId")
        self._RequestId = params.get("RequestId")


class ModifyResourceScheduleConfigRequest(AbstractModel):
    r"""ModifyResourceScheduleConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: EMR cluster ID
        :type InstanceId: str
        :param _Key: Business identifier. `fair`: Edit fair configuration items; `fairPlan`: Edit the execution plan; `capacity`: Edit capacity configuration items.
        :type Key: str
        :param _Value: Modified module information
        :type Value: str
        """
        self._InstanceId = None
        self._Key = None
        self._Value = None

    @property
    def InstanceId(self):
        r"""EMR cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Key(self):
        r"""Business identifier. `fair`: Edit fair configuration items; `fairPlan`: Edit the execution plan; `capacity`: Edit capacity configuration items.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Modified module information
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourceScheduleConfigResponse(AbstractModel):
    r"""ModifyResourceScheduleConfig response structure.

    """

    def __init__(self):
        r"""
        :param _IsDraft: `true`: Draft, indicating the resource pool is not refreshed.
        :type IsDraft: bool
        :param _ErrorMsg: Verification error information. If it is not empty, it means that verification fails and configuration is not successful.
        :type ErrorMsg: str
        :param _Data: Returned data.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsDraft = None
        self._ErrorMsg = None
        self._Data = None
        self._RequestId = None

    @property
    def IsDraft(self):
        r"""`true`: Draft, indicating the resource pool is not refreshed.
        :rtype: bool
        """
        return self._IsDraft

    @IsDraft.setter
    def IsDraft(self, IsDraft):
        self._IsDraft = IsDraft

    @property
    def ErrorMsg(self):
        r"""Verification error information. If it is not empty, it means that verification fails and configuration is not successful.
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def Data(self):
        r"""Returned data.
        :rtype: str
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsDraft = params.get("IsDraft")
        self._ErrorMsg = params.get("ErrorMsg")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyResourceSchedulerRequest(AbstractModel):
    r"""ModifyResourceScheduler request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: EMR cluster ID
        :type InstanceId: str
        :param _OldValue: The original scheduler: `fair`
        :type OldValue: str
        :param _NewValue: The new scheduler: `capacity`
        :type NewValue: str
        """
        self._InstanceId = None
        self._OldValue = None
        self._NewValue = None

    @property
    def InstanceId(self):
        r"""EMR cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def OldValue(self):
        r"""The original scheduler: `fair`
        :rtype: str
        """
        return self._OldValue

    @OldValue.setter
    def OldValue(self, OldValue):
        self._OldValue = OldValue

    @property
    def NewValue(self):
        r"""The new scheduler: `capacity`
        :rtype: str
        """
        return self._NewValue

    @NewValue.setter
    def NewValue(self, NewValue):
        self._NewValue = NewValue


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._OldValue = params.get("OldValue")
        self._NewValue = params.get("NewValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourceSchedulerResponse(AbstractModel):
    r"""ModifyResourceScheduler response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyResourceTags(AbstractModel):
    r"""Forcibly Modifying Tags

    """

    def __init__(self):
        r"""
        :param _ResourceId: Cluster ID or CVM ID
        :type ResourceId: str
        :param _Resource: 6-segment resource expression
        :type Resource: str
        :param _ResourcePrefix: Resource prefix
        :type ResourcePrefix: str
        :param _ResourceRegion: ap-beijing
        :type ResourceRegion: str
        :param _ServiceType: emr
        :type ServiceType: str
        :param _DeleteTags: List of deleted tags
        :type DeleteTags: list of Tag
        :param _AddTags: List of added tags
        :type AddTags: list of Tag
        :param _ModifyTags: List of modified tags
        :type ModifyTags: list of Tag
        """
        self._ResourceId = None
        self._Resource = None
        self._ResourcePrefix = None
        self._ResourceRegion = None
        self._ServiceType = None
        self._DeleteTags = None
        self._AddTags = None
        self._ModifyTags = None

    @property
    def ResourceId(self):
        r"""Cluster ID or CVM ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Resource(self):
        r"""6-segment resource expression
        :rtype: str
        """
        return self._Resource

    @Resource.setter
    def Resource(self, Resource):
        self._Resource = Resource

    @property
    def ResourcePrefix(self):
        r"""Resource prefix
        :rtype: str
        """
        return self._ResourcePrefix

    @ResourcePrefix.setter
    def ResourcePrefix(self, ResourcePrefix):
        self._ResourcePrefix = ResourcePrefix

    @property
    def ResourceRegion(self):
        r"""ap-beijing
        :rtype: str
        """
        return self._ResourceRegion

    @ResourceRegion.setter
    def ResourceRegion(self, ResourceRegion):
        self._ResourceRegion = ResourceRegion

    @property
    def ServiceType(self):
        r"""emr
        :rtype: str
        """
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def DeleteTags(self):
        r"""List of deleted tags
        :rtype: list of Tag
        """
        return self._DeleteTags

    @DeleteTags.setter
    def DeleteTags(self, DeleteTags):
        self._DeleteTags = DeleteTags

    @property
    def AddTags(self):
        r"""List of added tags
        :rtype: list of Tag
        """
        return self._AddTags

    @AddTags.setter
    def AddTags(self, AddTags):
        self._AddTags = AddTags

    @property
    def ModifyTags(self):
        r"""List of modified tags
        :rtype: list of Tag
        """
        return self._ModifyTags

    @ModifyTags.setter
    def ModifyTags(self, ModifyTags):
        self._ModifyTags = ModifyTags


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._Resource = params.get("Resource")
        self._ResourcePrefix = params.get("ResourcePrefix")
        self._ResourceRegion = params.get("ResourceRegion")
        self._ServiceType = params.get("ServiceType")
        if params.get("DeleteTags") is not None:
            self._DeleteTags = []
            for item in params.get("DeleteTags"):
                obj = Tag()
                obj._deserialize(item)
                self._DeleteTags.append(obj)
        if params.get("AddTags") is not None:
            self._AddTags = []
            for item in params.get("AddTags"):
                obj = Tag()
                obj._deserialize(item)
                self._AddTags.append(obj)
        if params.get("ModifyTags") is not None:
            self._ModifyTags = []
            for item in params.get("ModifyTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ModifyTags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourcesTagsRequest(AbstractModel):
    r"""ModifyResourcesTags request structure.

    """

    def __init__(self):
        r"""
        :param _ModifyType: Tag type. Valid values: Cluster and Node
        :type ModifyType: str
        :param _ModifyResourceTagsInfoList: Tag information
        :type ModifyResourceTagsInfoList: list of ModifyResourceTags
        """
        self._ModifyType = None
        self._ModifyResourceTagsInfoList = None

    @property
    def ModifyType(self):
        r"""Tag type. Valid values: Cluster and Node
        :rtype: str
        """
        return self._ModifyType

    @ModifyType.setter
    def ModifyType(self, ModifyType):
        self._ModifyType = ModifyType

    @property
    def ModifyResourceTagsInfoList(self):
        r"""Tag information
        :rtype: list of ModifyResourceTags
        """
        return self._ModifyResourceTagsInfoList

    @ModifyResourceTagsInfoList.setter
    def ModifyResourceTagsInfoList(self, ModifyResourceTagsInfoList):
        self._ModifyResourceTagsInfoList = ModifyResourceTagsInfoList


    def _deserialize(self, params):
        self._ModifyType = params.get("ModifyType")
        if params.get("ModifyResourceTagsInfoList") is not None:
            self._ModifyResourceTagsInfoList = []
            for item in params.get("ModifyResourceTagsInfoList"):
                obj = ModifyResourceTags()
                obj._deserialize(item)
                self._ModifyResourceTagsInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourcesTagsResponse(AbstractModel):
    r"""ModifyResourcesTags response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessList: List of resource IDs with successful modification
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuccessList: list of str
        :param _FailList: List of resource IDs with failed modification
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailList: list of str
        :param _PartSuccessList: List of resource IDs with partial successful modification
Note: This field may return null, indicating that no valid values can be obtained.
        :type PartSuccessList: list of str
        :param _ClusterToFlowIdList: Mapping list of cluster IDs and process IDs
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterToFlowIdList: list of ClusterIDToFlowID
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessList = None
        self._FailList = None
        self._PartSuccessList = None
        self._ClusterToFlowIdList = None
        self._RequestId = None

    @property
    def SuccessList(self):
        r"""List of resource IDs with successful modification
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SuccessList

    @SuccessList.setter
    def SuccessList(self, SuccessList):
        self._SuccessList = SuccessList

    @property
    def FailList(self):
        r"""List of resource IDs with failed modification
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._FailList

    @FailList.setter
    def FailList(self, FailList):
        self._FailList = FailList

    @property
    def PartSuccessList(self):
        r"""List of resource IDs with partial successful modification
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._PartSuccessList

    @PartSuccessList.setter
    def PartSuccessList(self, PartSuccessList):
        self._PartSuccessList = PartSuccessList

    @property
    def ClusterToFlowIdList(self):
        r"""Mapping list of cluster IDs and process IDs
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ClusterIDToFlowID
        """
        return self._ClusterToFlowIdList

    @ClusterToFlowIdList.setter
    def ClusterToFlowIdList(self, ClusterToFlowIdList):
        self._ClusterToFlowIdList = ClusterToFlowIdList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessList = params.get("SuccessList")
        self._FailList = params.get("FailList")
        self._PartSuccessList = params.get("PartSuccessList")
        if params.get("ClusterToFlowIdList") is not None:
            self._ClusterToFlowIdList = []
            for item in params.get("ClusterToFlowIdList"):
                obj = ClusterIDToFlowID()
                obj._deserialize(item)
                self._ClusterToFlowIdList.append(obj)
        self._RequestId = params.get("RequestId")


class ModifySLInstanceBasicRequest(AbstractModel):
    r"""ModifySLInstanceBasic request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _ClusterName: Instance name.
        :type ClusterName: str
        """
        self._InstanceId = None
        self._ClusterName = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterName(self):
        r"""Instance name.
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySLInstanceBasicResponse(AbstractModel):
    r"""ModifySLInstanceBasic response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySLInstanceRequest(AbstractModel):
    r"""ModifySLInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance unique identifier (string).
        :type InstanceId: str
        :param _Zone: Region name to be changed.
        :type Zone: str
        :param _NodeNum: Target node count after configuration change in this region. The total number of nodes across all regions should be greater than or equal to 3 and less than or equal to 50.
        :type NodeNum: int
        :param _ClientToken: The unique random identifier with a time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources repeatedly. For example: a9a90aa6-****-****-****-fae360632808.
        :type ClientToken: str
        """
        self._InstanceId = None
        self._Zone = None
        self._NodeNum = None
        self._ClientToken = None

    @property
    def InstanceId(self):
        r"""Instance unique identifier (string).
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Zone(self):
        r"""Region name to be changed.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def NodeNum(self):
        r"""Target node count after configuration change in this region. The total number of nodes across all regions should be greater than or equal to 3 and less than or equal to 50.
        :rtype: int
        """
        return self._NodeNum

    @NodeNum.setter
    def NodeNum(self, NodeNum):
        self._NodeNum = NodeNum

    @property
    def ClientToken(self):
        r"""The unique random identifier with a time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources repeatedly. For example: a9a90aa6-****-****-****-fae360632808.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Zone = params.get("Zone")
        self._NodeNum = params.get("NodeNum")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySLInstanceResponse(AbstractModel):
    r"""ModifySLInstance response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserGroupRequest(AbstractModel):
    r"""ModifyUserGroup request structure.

    """

    def __init__(self):
        r"""
        :param _Users: User information list.
        :type Users: list of str
        :param _UserGroup: User primary group. The CVM cluster is a required parameter, while the TKE cluster is optional.
        :type UserGroup: str
        :param _Groups: User subgroup.
        :type Groups: list of str
        :param _Remark: Remarks.
        :type Remark: str
        """
        self._Users = None
        self._UserGroup = None
        self._Groups = None
        self._Remark = None

    @property
    def Users(self):
        r"""User information list.
        :rtype: list of str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def UserGroup(self):
        r"""User primary group. The CVM cluster is a required parameter, while the TKE cluster is optional.
        :rtype: str
        """
        return self._UserGroup

    @UserGroup.setter
    def UserGroup(self, UserGroup):
        self._UserGroup = UserGroup

    @property
    def Groups(self):
        r"""User subgroup.
        :rtype: list of str
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._Users = params.get("Users")
        self._UserGroup = params.get("UserGroup")
        self._Groups = params.get("Groups")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserGroupResponse(AbstractModel):
    r"""ModifyUserGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserManagerPwdRequest(AbstractModel):
    r"""ModifyUserManagerPwd request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID
        :type InstanceId: str
        :param _UserName: Username
        :type UserName: str
        :param _PassWord: Password
        :type PassWord: str
        """
        self._InstanceId = None
        self._UserName = None
        self._PassWord = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def UserName(self):
        r"""Username
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def PassWord(self):
        r"""Password
        :rtype: str
        """
        return self._PassWord

    @PassWord.setter
    def PassWord(self, PassWord):
        self._PassWord = PassWord


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._UserName = params.get("UserName")
        self._PassWord = params.get("PassWord")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserManagerPwdResponse(AbstractModel):
    r"""ModifyUserManagerPwd response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUsersOfGroupSTDRequest(AbstractModel):
    r"""ModifyUsersOfGroupSTD request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster name.
        :type InstanceId: str
        :param _Group: User group name.
        :type Group: str
        :param _Users: User list.
        :type Users: list of str
        :param _Description: User group description.
        :type Description: str
        :param _OperateAction: Enumeration class. Valid values: ADD, DELETE, SYNC.


Enumeration class description.
- ADD: Batched users to add. Adding the same user multiple times will not trigger an error.
- DELETE: Batched users to remove from the user group. Deleting non-existing users will not trigger an error.
- SYNC: Overwrites the entire user group. An empty list clears all existing members.
Defaults to SYNC.

        :type OperateAction: str
        """
        self._InstanceId = None
        self._Group = None
        self._Users = None
        self._Description = None
        self._OperateAction = None

    @property
    def InstanceId(self):
        r"""Cluster name.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Group(self):
        r"""User group name.
        :rtype: str
        """
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group

    @property
    def Users(self):
        r"""User list.
        :rtype: list of str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def Description(self):
        r"""User group description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OperateAction(self):
        r"""Enumeration class. Valid values: ADD, DELETE, SYNC.


Enumeration class description.
- ADD: Batched users to add. Adding the same user multiple times will not trigger an error.
- DELETE: Batched users to remove from the user group. Deleting non-existing users will not trigger an error.
- SYNC: Overwrites the entire user group. An empty list clears all existing members.
Defaults to SYNC.

        :rtype: str
        """
        return self._OperateAction

    @OperateAction.setter
    def OperateAction(self, OperateAction):
        self._OperateAction = OperateAction


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Group = params.get("Group")
        self._Users = params.get("Users")
        self._Description = params.get("Description")
        self._OperateAction = params.get("OperateAction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUsersOfGroupSTDResponse(AbstractModel):
    r"""ModifyUsersOfGroupSTD response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Whether modification is successful.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        r"""Whether modification is successful.
        :rtype: bool
        """
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class ModifyYarnDeployRequest(AbstractModel):
    r"""ModifyYarnDeploy request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _NewScheduler: Scheduler after switching. The values are fair and capacity.
        :type NewScheduler: str
        :param _OldScheduler: Currently used scheduler. The values are fair and capacity.
        :type OldScheduler: str
        """
        self._InstanceId = None
        self._NewScheduler = None
        self._OldScheduler = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def NewScheduler(self):
        r"""Scheduler after switching. The values are fair and capacity.
        :rtype: str
        """
        return self._NewScheduler

    @NewScheduler.setter
    def NewScheduler(self, NewScheduler):
        self._NewScheduler = NewScheduler

    @property
    def OldScheduler(self):
        r"""Currently used scheduler. The values are fair and capacity.
        :rtype: str
        """
        return self._OldScheduler

    @OldScheduler.setter
    def OldScheduler(self, OldScheduler):
        self._OldScheduler = OldScheduler


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._NewScheduler = params.get("NewScheduler")
        self._OldScheduler = params.get("OldScheduler")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyYarnDeployResponse(AbstractModel):
    r"""ModifyYarnDeploy response structure.

    """

    def __init__(self):
        r"""
        :param _IsDraft: When the value is "false", both the "Apply" and "Reset" buttons are grayed out.
        :type IsDraft: bool
        :param _ErrorMsg: Error information. This field is reserved.
        :type ErrorMsg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsDraft = None
        self._ErrorMsg = None
        self._RequestId = None

    @property
    def IsDraft(self):
        r"""When the value is "false", both the "Apply" and "Reset" buttons are grayed out.
        :rtype: bool
        """
        return self._IsDraft

    @IsDraft.setter
    def IsDraft(self, IsDraft):
        self._IsDraft = IsDraft

    @property
    def ErrorMsg(self):
        r"""Error information. This field is reserved.
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsDraft = params.get("IsDraft")
        self._ErrorMsg = params.get("ErrorMsg")
        self._RequestId = params.get("RequestId")


class ModifyYarnQueueV2Request(AbstractModel):
    r"""ModifyYarnQueueV2 request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID
        :type InstanceId: str
        :param _Scheduler: Scheduler type. The values are as follows:

1. capacity
2. fair
        :type Scheduler: str
        :param _ConfigModifyInfoList: Resource pool data
        :type ConfigModifyInfoList: list of ConfigModifyInfoV2
        """
        self._InstanceId = None
        self._Scheduler = None
        self._ConfigModifyInfoList = None

    @property
    def InstanceId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Scheduler(self):
        r"""Scheduler type. The values are as follows:

1. capacity
2. fair
        :rtype: str
        """
        return self._Scheduler

    @Scheduler.setter
    def Scheduler(self, Scheduler):
        self._Scheduler = Scheduler

    @property
    def ConfigModifyInfoList(self):
        r"""Resource pool data
        :rtype: list of ConfigModifyInfoV2
        """
        return self._ConfigModifyInfoList

    @ConfigModifyInfoList.setter
    def ConfigModifyInfoList(self, ConfigModifyInfoList):
        self._ConfigModifyInfoList = ConfigModifyInfoList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Scheduler = params.get("Scheduler")
        if params.get("ConfigModifyInfoList") is not None:
            self._ConfigModifyInfoList = []
            for item in params.get("ConfigModifyInfoList"):
                obj = ConfigModifyInfoV2()
                obj._deserialize(item)
                self._ConfigModifyInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyYarnQueueV2Response(AbstractModel):
    r"""ModifyYarnQueueV2 response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MonthRepeatStrategy(AbstractModel):
    r"""Scheduled scaling of monthly recurring task policy

    """

    def __init__(self):
        r"""
        :param _ExecuteAtTimeOfDay: Specific time for repetition task execution, such as 01:02:00.
        :type ExecuteAtTimeOfDay: str
        :param _DaysOfMonthRange: Description of time period in days of the month. The length must be 2. For example, [2,10] indicates from the 2nd day to the 10th day every month.

Note: This field may return null, indicating that no valid values can be obtained.
        :type DaysOfMonthRange: list of int non-negative
        """
        self._ExecuteAtTimeOfDay = None
        self._DaysOfMonthRange = None

    @property
    def ExecuteAtTimeOfDay(self):
        r"""Specific time for repetition task execution, such as 01:02:00.
        :rtype: str
        """
        return self._ExecuteAtTimeOfDay

    @ExecuteAtTimeOfDay.setter
    def ExecuteAtTimeOfDay(self, ExecuteAtTimeOfDay):
        self._ExecuteAtTimeOfDay = ExecuteAtTimeOfDay

    @property
    def DaysOfMonthRange(self):
        r"""Description of time period in days of the month. The length must be 2. For example, [2,10] indicates from the 2nd day to the 10th day every month.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int non-negative
        """
        return self._DaysOfMonthRange

    @DaysOfMonthRange.setter
    def DaysOfMonthRange(self, DaysOfMonthRange):
        self._DaysOfMonthRange = DaysOfMonthRange


    def _deserialize(self, params):
        self._ExecuteAtTimeOfDay = params.get("ExecuteAtTimeOfDay")
        self._DaysOfMonthRange = params.get("DaysOfMonthRange")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MultiDisk(AbstractModel):
    r"""Multi-cloud disk parameters

    """

    def __init__(self):
        r"""
        :param _DiskType: Cloud disk type.
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_HSSD: Enhanced SSD.</li>
        :type DiskType: str
        :param _Volume: Cloud disk size.
        :type Volume: int
        :param _Count: Number of cloud disks of this type.
        :type Count: int
        """
        self._DiskType = None
        self._Volume = None
        self._Count = None

    @property
    def DiskType(self):
        r"""Cloud disk type.
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_HSSD: Enhanced SSD.</li>
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def Volume(self):
        r"""Cloud disk size.
        :rtype: int
        """
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume

    @property
    def Count(self):
        r"""Number of cloud disks of this type.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._DiskType = params.get("DiskType")
        self._Volume = params.get("Volume")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MultiDiskMC(AbstractModel):
    r"""Multi-cloud disk parameters

    """

    def __init__(self):
        r"""
        :param _Count: Number of cloud disks of this type.
        :type Count: int
        :param _Type: Disk type.
1: Local Disk.
2: Cloud Disk.
3: Local SSD.
4: Cloud SSD.
5: Premium Cloud Disk.
6: Enhanced SSD.
11: Throughput HDD.
12: Tremendous SSD.
13: Balanced SSD.
14: Big Data Cloud Disk.
15: High IO Cloud Disk.
16: Remote SSD.
        :type Type: int
        :param _Size: Disk size.
        :type Size: str
        :param _Volume: Cloud disk size (bytes).
        :type Volume: int
        """
        self._Count = None
        self._Type = None
        self._Size = None
        self._Volume = None

    @property
    def Count(self):
        r"""Number of cloud disks of this type.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Type(self):
        r"""Disk type.
1: Local Disk.
2: Cloud Disk.
3: Local SSD.
4: Cloud SSD.
5: Premium Cloud Disk.
6: Enhanced SSD.
11: Throughput HDD.
12: Tremendous SSD.
13: Balanced SSD.
14: Big Data Cloud Disk.
15: High IO Cloud Disk.
16: Remote SSD.
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Size(self):
        r"""Disk size.
        :rtype: str
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Volume(self):
        r"""Cloud disk size (bytes).
        :rtype: int
        """
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._Type = params.get("Type")
        self._Size = params.get("Size")
        self._Volume = params.get("Volume")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MultiZoneSetting(AbstractModel):
    r"""Parameter information of each AZ

    """

    def __init__(self):
        r"""
        :param _ZoneTag: "master", "standby" or "third-party".
        :type ZoneTag: str
        :param _VPCSettings: None
        :type VPCSettings: :class:`tencentcloud.emr.v20190103.models.VPCSettings`
        :param _Placement: None
        :type Placement: :class:`tencentcloud.emr.v20190103.models.Placement`
        :param _ResourceSpec: None
        :type ResourceSpec: :class:`tencentcloud.emr.v20190103.models.NewResourceSpec`
        """
        self._ZoneTag = None
        self._VPCSettings = None
        self._Placement = None
        self._ResourceSpec = None

    @property
    def ZoneTag(self):
        r""""master", "standby" or "third-party".
        :rtype: str
        """
        return self._ZoneTag

    @ZoneTag.setter
    def ZoneTag(self, ZoneTag):
        self._ZoneTag = ZoneTag

    @property
    def VPCSettings(self):
        r"""None
        :rtype: :class:`tencentcloud.emr.v20190103.models.VPCSettings`
        """
        return self._VPCSettings

    @VPCSettings.setter
    def VPCSettings(self, VPCSettings):
        self._VPCSettings = VPCSettings

    @property
    def Placement(self):
        r"""None
        :rtype: :class:`tencentcloud.emr.v20190103.models.Placement`
        """
        return self._Placement

    @Placement.setter
    def Placement(self, Placement):
        self._Placement = Placement

    @property
    def ResourceSpec(self):
        r"""None
        :rtype: :class:`tencentcloud.emr.v20190103.models.NewResourceSpec`
        """
        return self._ResourceSpec

    @ResourceSpec.setter
    def ResourceSpec(self, ResourceSpec):
        self._ResourceSpec = ResourceSpec


    def _deserialize(self, params):
        self._ZoneTag = params.get("ZoneTag")
        if params.get("VPCSettings") is not None:
            self._VPCSettings = VPCSettings()
            self._VPCSettings._deserialize(params.get("VPCSettings"))
        if params.get("Placement") is not None:
            self._Placement = Placement()
            self._Placement._deserialize(params.get("Placement"))
        if params.get("ResourceSpec") is not None:
            self._ResourceSpec = NewResourceSpec()
            self._ResourceSpec._deserialize(params.get("ResourceSpec"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NewResourceSpec(AbstractModel):
    r"""Resource description

    """

    def __init__(self):
        r"""
        :param _MasterResourceSpec: Describes master node resource
        :type MasterResourceSpec: :class:`tencentcloud.emr.v20190103.models.Resource`
        :param _CoreResourceSpec: Describes core node resource
        :type CoreResourceSpec: :class:`tencentcloud.emr.v20190103.models.Resource`
        :param _TaskResourceSpec: Describes task node resource
        :type TaskResourceSpec: :class:`tencentcloud.emr.v20190103.models.Resource`
        :param _MasterCount: Number of master nodes
        :type MasterCount: int
        :param _CoreCount: Number of core nodes
        :type CoreCount: int
        :param _TaskCount: Number of task nodes
        :type TaskCount: int
        :param _CommonResourceSpec: Describes common node resource
        :type CommonResourceSpec: :class:`tencentcloud.emr.v20190103.models.Resource`
        :param _CommonCount: Number of common nodes
        :type CommonCount: int
        """
        self._MasterResourceSpec = None
        self._CoreResourceSpec = None
        self._TaskResourceSpec = None
        self._MasterCount = None
        self._CoreCount = None
        self._TaskCount = None
        self._CommonResourceSpec = None
        self._CommonCount = None

    @property
    def MasterResourceSpec(self):
        r"""Describes master node resource
        :rtype: :class:`tencentcloud.emr.v20190103.models.Resource`
        """
        return self._MasterResourceSpec

    @MasterResourceSpec.setter
    def MasterResourceSpec(self, MasterResourceSpec):
        self._MasterResourceSpec = MasterResourceSpec

    @property
    def CoreResourceSpec(self):
        r"""Describes core node resource
        :rtype: :class:`tencentcloud.emr.v20190103.models.Resource`
        """
        return self._CoreResourceSpec

    @CoreResourceSpec.setter
    def CoreResourceSpec(self, CoreResourceSpec):
        self._CoreResourceSpec = CoreResourceSpec

    @property
    def TaskResourceSpec(self):
        r"""Describes task node resource
        :rtype: :class:`tencentcloud.emr.v20190103.models.Resource`
        """
        return self._TaskResourceSpec

    @TaskResourceSpec.setter
    def TaskResourceSpec(self, TaskResourceSpec):
        self._TaskResourceSpec = TaskResourceSpec

    @property
    def MasterCount(self):
        r"""Number of master nodes
        :rtype: int
        """
        return self._MasterCount

    @MasterCount.setter
    def MasterCount(self, MasterCount):
        self._MasterCount = MasterCount

    @property
    def CoreCount(self):
        r"""Number of core nodes
        :rtype: int
        """
        return self._CoreCount

    @CoreCount.setter
    def CoreCount(self, CoreCount):
        self._CoreCount = CoreCount

    @property
    def TaskCount(self):
        r"""Number of task nodes
        :rtype: int
        """
        return self._TaskCount

    @TaskCount.setter
    def TaskCount(self, TaskCount):
        self._TaskCount = TaskCount

    @property
    def CommonResourceSpec(self):
        r"""Describes common node resource
        :rtype: :class:`tencentcloud.emr.v20190103.models.Resource`
        """
        return self._CommonResourceSpec

    @CommonResourceSpec.setter
    def CommonResourceSpec(self, CommonResourceSpec):
        self._CommonResourceSpec = CommonResourceSpec

    @property
    def CommonCount(self):
        r"""Number of common nodes
        :rtype: int
        """
        return self._CommonCount

    @CommonCount.setter
    def CommonCount(self, CommonCount):
        self._CommonCount = CommonCount


    def _deserialize(self, params):
        if params.get("MasterResourceSpec") is not None:
            self._MasterResourceSpec = Resource()
            self._MasterResourceSpec._deserialize(params.get("MasterResourceSpec"))
        if params.get("CoreResourceSpec") is not None:
            self._CoreResourceSpec = Resource()
            self._CoreResourceSpec._deserialize(params.get("CoreResourceSpec"))
        if params.get("TaskResourceSpec") is not None:
            self._TaskResourceSpec = Resource()
            self._TaskResourceSpec._deserialize(params.get("TaskResourceSpec"))
        self._MasterCount = params.get("MasterCount")
        self._CoreCount = params.get("CoreCount")
        self._TaskCount = params.get("TaskCount")
        if params.get("CommonResourceSpec") is not None:
            self._CommonResourceSpec = Resource()
            self._CommonResourceSpec._deserialize(params.get("CommonResourceSpec"))
        self._CommonCount = params.get("CommonCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeDetailPriceResult(AbstractModel):
    r"""Price details by node, used for creating the cluster price list

    """

    def __init__(self):
        r"""
        :param _NodeType: Node type: Master, Core, Task, Common, Router, and MySQL.
        :type NodeType: str
        :param _PartDetailPrice: Price details by node part
        :type PartDetailPrice: list of PartDetailPriceItem
        """
        self._NodeType = None
        self._PartDetailPrice = None

    @property
    def NodeType(self):
        r"""Node type: Master, Core, Task, Common, Router, and MySQL.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def PartDetailPrice(self):
        r"""Price details by node part
        :rtype: list of PartDetailPriceItem
        """
        return self._PartDetailPrice

    @PartDetailPrice.setter
    def PartDetailPrice(self, PartDetailPrice):
        self._PartDetailPrice = PartDetailPrice


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        if params.get("PartDetailPrice") is not None:
            self._PartDetailPrice = []
            for item in params.get("PartDetailPrice"):
                obj = PartDetailPriceItem()
                obj._deserialize(item)
                self._PartDetailPrice.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeHardwareInfo(AbstractModel):
    r"""Node hardware information

    """

    def __init__(self):
        r"""
        :param _AppId: User AppID.
        :type AppId: int
        :param _SerialNo: Serial number.
        :type SerialNo: str
        :param _OrderNo: Machine instance ID.
        :type OrderNo: str
        :param _WanIp: Public network IP address bound for the Master node.
        :type WanIp: str
        :param _Flag: Node type. 0: Common node; 1: Master node.
 2: Core node; 3: Task node.
        :type Flag: int
        :param _Spec: Node specifications.
        :type Spec: str
        :param _CpuNum: Number of node cores.
        :type CpuNum: int
        :param _MemSize: Node memory (bytes).
        :type MemSize: int
        :param _MemDesc: Node memory (GB).
        :type MemDesc: str
        :param _RegionId: The region where the node is located.
        :type RegionId: int
        :param _ZoneId: The zone where the node is located.
        :type ZoneId: int
        :param _ApplyTime: Application time.
        :type ApplyTime: str
        :param _FreeTime: Release time.
        :type FreeTime: str
        :param _DiskSize: Hard disk size.
        :type DiskSize: str
        :param _NameTag: Node description.
        :type NameTag: str
        :param _Services: Node deployment service.
        :type Services: str
        :param _StorageType: Disk type. Valid values: 1 (Local Disk), 2 (Cloud Disk), 3 (Local SSD), 4 (Cloud SSD), 5 (Premium Cloud Disk), 6 (Enhanced SSD), 11 (Throughput SSD), 12 (Tremendous SSD), 13 (Balanced SSD), 14 (Big Data Cloud Disk), 15 (High IO Cloud Disk), and 16 (Remote SSD).

        :type StorageType: int
        :param _RootSize: System disk size (GB).
        :type RootSize: int
        :param _ChargeType: Payment type. Valid values: 0 (pay-as-you-go); 1 (yearly/monthly subscription).
        :type ChargeType: int
        :param _CdbIp: Database IP address.
        :type CdbIp: str
        :param _CdbPort: Database port.
        :type CdbPort: int
        :param _HwDiskSize: Hard disk capacity (bytes).
        :type HwDiskSize: int
        :param _HwDiskSizeDesc: Hard disk capacity description.
        :type HwDiskSizeDesc: str
        :param _HwMemSize: Memory capacity (bytes).
        :type HwMemSize: int
        :param _HwMemSizeDesc: Memory capacity description.
        :type HwMemSizeDesc: str
        :param _ExpireTime: Expiration time.
        :type ExpireTime: str
        :param _EmrResourceId: Node resource ID.
        :type EmrResourceId: str
        :param _IsAutoRenew: Renewal flag.
        :type IsAutoRenew: int
        :param _DeviceClass: Device identification.
        :type DeviceClass: str
        :param _Mutable: Supporting resizing.
        :type Mutable: int
        :param _MCMultiDisk: Multi-cloud disk
Note: this field may return null, indicating that no valid values can be obtained.
        :type MCMultiDisk: list of MultiDiskMC
        :param _CdbNodeInfo: Database information
Note: this field may return null, indicating that no valid values can be obtained.
        :type CdbNodeInfo: :class:`tencentcloud.emr.v20190103.models.CdbInfo`
        :param _Ip: Private network IP address.
        :type Ip: str
        :param _Destroyable: Whether this node can be terminated. 1: Yes, 0: No.
        :type Destroyable: int
        :param _Tags: Tags bound to node
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _AutoFlag: Whether it is an automatic scaling node. 0: common node, 1: automatic scaling node.
        :type AutoFlag: int
        :param _HardwareResourceType: Resource type, with the valid values of "host" and "pod".
        :type HardwareResourceType: str
        :param _IsDynamicSpec: Whether it is a floating specification. 1: Yes, 0: No.
        :type IsDynamicSpec: int
        :param _DynamicPodSpec: Floating specification value in the JSON string format.
        :type DynamicPodSpec: str
        :param _SupportModifyPayMode: Whether the billing type can be changed. 1: Yes, 0: No.
        :type SupportModifyPayMode: int
        :param _RootStorageType: System disk type. Valid values: 1 (Local Disk), 2 (Cloud Disk), 3 (Local SSD), 4 (Cloud SSD), 5 (Premium Cloud Disk), 6 (Enhanced SSD), 11 (Throughput HDD), 12 (Tremendous SSD), 13 (Balanced SSD), 14 (Big Data Cloud Disk), 15 (High IO Cloud Disk), and 16 (Remote SSD).
        :type RootStorageType: int
        :param _Zone: Availability information.
        :type Zone: str
        :param _SubnetInfo: Subnet
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type SubnetInfo: :class:`tencentcloud.emr.v20190103.models.SubnetInfo`
        :param _Clients: Client.
        :type Clients: str
        :param _CurrentTime: Current system time.
        :type CurrentTime: str
        :param _IsFederation: Indicates whether it is for federation. 1: Yes, 0: No.
        :type IsFederation: int
        :param _DeviceName: Device name.
        :type DeviceName: str
        :param _ServiceClient: Service.
        :type ServiceClient: str
        :param _DisableApiTermination: Whether instance protection is enabled. True: enabled, false: disabled.
        :type DisableApiTermination: bool
        :param _TradeVersion: 0: old billing, 1: new billing.
        :type TradeVersion: int
        :param _ServicesStatus: Component status. ZooKeeper: STARTED, ResourceManager: STARTED, STARTED: Component is running, STOPPED: Component is halted.
        :type ServicesStatus: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _SharedClusterId: Shared cluster ID.
        :type SharedClusterId: str
        :param _SharedClusterIdDesc: Shared cluster ID description.
        :type SharedClusterIdDesc: str
        :param _TimingResource: Whether the resource is set for scheduled termination.
        :type TimingResource: bool
        :param _TkeClusterId: Corresponding TKE cluster ID in the case that the resource type (HardwareResourceType) is pod.
        :type TkeClusterId: str
        :param _ConfigurableServices: Name list of services that can be configured when a new disk is mounted.
        :type ConfigurableServices: list of str
        :param _NodeMark: Node labeling information: currently used only in the Terraform.
        :type NodeMark: str
        :param _UnderwriteSetAutoRenew: Whether auto-renewal is available for committed use resources.
        :type UnderwriteSetAutoRenew: bool
        :param _GpuDesc: GPU information.
        :type GpuDesc: str
        """
        self._AppId = None
        self._SerialNo = None
        self._OrderNo = None
        self._WanIp = None
        self._Flag = None
        self._Spec = None
        self._CpuNum = None
        self._MemSize = None
        self._MemDesc = None
        self._RegionId = None
        self._ZoneId = None
        self._ApplyTime = None
        self._FreeTime = None
        self._DiskSize = None
        self._NameTag = None
        self._Services = None
        self._StorageType = None
        self._RootSize = None
        self._ChargeType = None
        self._CdbIp = None
        self._CdbPort = None
        self._HwDiskSize = None
        self._HwDiskSizeDesc = None
        self._HwMemSize = None
        self._HwMemSizeDesc = None
        self._ExpireTime = None
        self._EmrResourceId = None
        self._IsAutoRenew = None
        self._DeviceClass = None
        self._Mutable = None
        self._MCMultiDisk = None
        self._CdbNodeInfo = None
        self._Ip = None
        self._Destroyable = None
        self._Tags = None
        self._AutoFlag = None
        self._HardwareResourceType = None
        self._IsDynamicSpec = None
        self._DynamicPodSpec = None
        self._SupportModifyPayMode = None
        self._RootStorageType = None
        self._Zone = None
        self._SubnetInfo = None
        self._Clients = None
        self._CurrentTime = None
        self._IsFederation = None
        self._DeviceName = None
        self._ServiceClient = None
        self._DisableApiTermination = None
        self._TradeVersion = None
        self._ServicesStatus = None
        self._Remark = None
        self._SharedClusterId = None
        self._SharedClusterIdDesc = None
        self._TimingResource = None
        self._TkeClusterId = None
        self._ConfigurableServices = None
        self._NodeMark = None
        self._UnderwriteSetAutoRenew = None
        self._GpuDesc = None

    @property
    def AppId(self):
        r"""User AppID.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def SerialNo(self):
        r"""Serial number.
        :rtype: str
        """
        return self._SerialNo

    @SerialNo.setter
    def SerialNo(self, SerialNo):
        self._SerialNo = SerialNo

    @property
    def OrderNo(self):
        r"""Machine instance ID.
        :rtype: str
        """
        return self._OrderNo

    @OrderNo.setter
    def OrderNo(self, OrderNo):
        self._OrderNo = OrderNo

    @property
    def WanIp(self):
        r"""Public network IP address bound for the Master node.
        :rtype: str
        """
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def Flag(self):
        r"""Node type. 0: Common node; 1: Master node.
 2: Core node; 3: Task node.
        :rtype: int
        """
        return self._Flag

    @Flag.setter
    def Flag(self, Flag):
        self._Flag = Flag

    @property
    def Spec(self):
        r"""Node specifications.
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def CpuNum(self):
        r"""Number of node cores.
        :rtype: int
        """
        return self._CpuNum

    @CpuNum.setter
    def CpuNum(self, CpuNum):
        self._CpuNum = CpuNum

    @property
    def MemSize(self):
        r"""Node memory (bytes).
        :rtype: int
        """
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def MemDesc(self):
        r"""Node memory (GB).
        :rtype: str
        """
        return self._MemDesc

    @MemDesc.setter
    def MemDesc(self, MemDesc):
        self._MemDesc = MemDesc

    @property
    def RegionId(self):
        r"""The region where the node is located.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def ZoneId(self):
        r"""The zone where the node is located.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ApplyTime(self):
        r"""Application time.
        :rtype: str
        """
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def FreeTime(self):
        r"""Release time.
        :rtype: str
        """
        return self._FreeTime

    @FreeTime.setter
    def FreeTime(self, FreeTime):
        self._FreeTime = FreeTime

    @property
    def DiskSize(self):
        r"""Hard disk size.
        :rtype: str
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def NameTag(self):
        r"""Node description.
        :rtype: str
        """
        return self._NameTag

    @NameTag.setter
    def NameTag(self, NameTag):
        self._NameTag = NameTag

    @property
    def Services(self):
        r"""Node deployment service.
        :rtype: str
        """
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def StorageType(self):
        r"""Disk type. Valid values: 1 (Local Disk), 2 (Cloud Disk), 3 (Local SSD), 4 (Cloud SSD), 5 (Premium Cloud Disk), 6 (Enhanced SSD), 11 (Throughput SSD), 12 (Tremendous SSD), 13 (Balanced SSD), 14 (Big Data Cloud Disk), 15 (High IO Cloud Disk), and 16 (Remote SSD).

        :rtype: int
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def RootSize(self):
        r"""System disk size (GB).
        :rtype: int
        """
        return self._RootSize

    @RootSize.setter
    def RootSize(self, RootSize):
        self._RootSize = RootSize

    @property
    def ChargeType(self):
        r"""Payment type. Valid values: 0 (pay-as-you-go); 1 (yearly/monthly subscription).
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def CdbIp(self):
        r"""Database IP address.
        :rtype: str
        """
        return self._CdbIp

    @CdbIp.setter
    def CdbIp(self, CdbIp):
        self._CdbIp = CdbIp

    @property
    def CdbPort(self):
        r"""Database port.
        :rtype: int
        """
        return self._CdbPort

    @CdbPort.setter
    def CdbPort(self, CdbPort):
        self._CdbPort = CdbPort

    @property
    def HwDiskSize(self):
        r"""Hard disk capacity (bytes).
        :rtype: int
        """
        return self._HwDiskSize

    @HwDiskSize.setter
    def HwDiskSize(self, HwDiskSize):
        self._HwDiskSize = HwDiskSize

    @property
    def HwDiskSizeDesc(self):
        r"""Hard disk capacity description.
        :rtype: str
        """
        return self._HwDiskSizeDesc

    @HwDiskSizeDesc.setter
    def HwDiskSizeDesc(self, HwDiskSizeDesc):
        self._HwDiskSizeDesc = HwDiskSizeDesc

    @property
    def HwMemSize(self):
        r"""Memory capacity (bytes).
        :rtype: int
        """
        return self._HwMemSize

    @HwMemSize.setter
    def HwMemSize(self, HwMemSize):
        self._HwMemSize = HwMemSize

    @property
    def HwMemSizeDesc(self):
        r"""Memory capacity description.
        :rtype: str
        """
        return self._HwMemSizeDesc

    @HwMemSizeDesc.setter
    def HwMemSizeDesc(self, HwMemSizeDesc):
        self._HwMemSizeDesc = HwMemSizeDesc

    @property
    def ExpireTime(self):
        r"""Expiration time.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def EmrResourceId(self):
        r"""Node resource ID.
        :rtype: str
        """
        return self._EmrResourceId

    @EmrResourceId.setter
    def EmrResourceId(self, EmrResourceId):
        self._EmrResourceId = EmrResourceId

    @property
    def IsAutoRenew(self):
        r"""Renewal flag.
        :rtype: int
        """
        return self._IsAutoRenew

    @IsAutoRenew.setter
    def IsAutoRenew(self, IsAutoRenew):
        self._IsAutoRenew = IsAutoRenew

    @property
    def DeviceClass(self):
        r"""Device identification.
        :rtype: str
        """
        return self._DeviceClass

    @DeviceClass.setter
    def DeviceClass(self, DeviceClass):
        self._DeviceClass = DeviceClass

    @property
    def Mutable(self):
        r"""Supporting resizing.
        :rtype: int
        """
        return self._Mutable

    @Mutable.setter
    def Mutable(self, Mutable):
        self._Mutable = Mutable

    @property
    def MCMultiDisk(self):
        r"""Multi-cloud disk
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of MultiDiskMC
        """
        return self._MCMultiDisk

    @MCMultiDisk.setter
    def MCMultiDisk(self, MCMultiDisk):
        self._MCMultiDisk = MCMultiDisk

    @property
    def CdbNodeInfo(self):
        r"""Database information
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.CdbInfo`
        """
        return self._CdbNodeInfo

    @CdbNodeInfo.setter
    def CdbNodeInfo(self, CdbNodeInfo):
        self._CdbNodeInfo = CdbNodeInfo

    @property
    def Ip(self):
        r"""Private network IP address.
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Destroyable(self):
        r"""Whether this node can be terminated. 1: Yes, 0: No.
        :rtype: int
        """
        return self._Destroyable

    @Destroyable.setter
    def Destroyable(self, Destroyable):
        self._Destroyable = Destroyable

    @property
    def Tags(self):
        r"""Tags bound to node
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AutoFlag(self):
        r"""Whether it is an automatic scaling node. 0: common node, 1: automatic scaling node.
        :rtype: int
        """
        return self._AutoFlag

    @AutoFlag.setter
    def AutoFlag(self, AutoFlag):
        self._AutoFlag = AutoFlag

    @property
    def HardwareResourceType(self):
        r"""Resource type, with the valid values of "host" and "pod".
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType

    @property
    def IsDynamicSpec(self):
        r"""Whether it is a floating specification. 1: Yes, 0: No.
        :rtype: int
        """
        return self._IsDynamicSpec

    @IsDynamicSpec.setter
    def IsDynamicSpec(self, IsDynamicSpec):
        self._IsDynamicSpec = IsDynamicSpec

    @property
    def DynamicPodSpec(self):
        r"""Floating specification value in the JSON string format.
        :rtype: str
        """
        return self._DynamicPodSpec

    @DynamicPodSpec.setter
    def DynamicPodSpec(self, DynamicPodSpec):
        self._DynamicPodSpec = DynamicPodSpec

    @property
    def SupportModifyPayMode(self):
        r"""Whether the billing type can be changed. 1: Yes, 0: No.
        :rtype: int
        """
        return self._SupportModifyPayMode

    @SupportModifyPayMode.setter
    def SupportModifyPayMode(self, SupportModifyPayMode):
        self._SupportModifyPayMode = SupportModifyPayMode

    @property
    def RootStorageType(self):
        r"""System disk type. Valid values: 1 (Local Disk), 2 (Cloud Disk), 3 (Local SSD), 4 (Cloud SSD), 5 (Premium Cloud Disk), 6 (Enhanced SSD), 11 (Throughput HDD), 12 (Tremendous SSD), 13 (Balanced SSD), 14 (Big Data Cloud Disk), 15 (High IO Cloud Disk), and 16 (Remote SSD).
        :rtype: int
        """
        return self._RootStorageType

    @RootStorageType.setter
    def RootStorageType(self, RootStorageType):
        self._RootStorageType = RootStorageType

    @property
    def Zone(self):
        r"""Availability information.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def SubnetInfo(self):
        r"""Subnet
Note: This field may return `null`, indicating that no valid value can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.SubnetInfo`
        """
        return self._SubnetInfo

    @SubnetInfo.setter
    def SubnetInfo(self, SubnetInfo):
        self._SubnetInfo = SubnetInfo

    @property
    def Clients(self):
        r"""Client.
        :rtype: str
        """
        return self._Clients

    @Clients.setter
    def Clients(self, Clients):
        self._Clients = Clients

    @property
    def CurrentTime(self):
        r"""Current system time.
        :rtype: str
        """
        return self._CurrentTime

    @CurrentTime.setter
    def CurrentTime(self, CurrentTime):
        self._CurrentTime = CurrentTime

    @property
    def IsFederation(self):
        r"""Indicates whether it is for federation. 1: Yes, 0: No.
        :rtype: int
        """
        return self._IsFederation

    @IsFederation.setter
    def IsFederation(self, IsFederation):
        self._IsFederation = IsFederation

    @property
    def DeviceName(self):
        r"""Device name.
        :rtype: str
        """
        return self._DeviceName

    @DeviceName.setter
    def DeviceName(self, DeviceName):
        self._DeviceName = DeviceName

    @property
    def ServiceClient(self):
        r"""Service.
        :rtype: str
        """
        return self._ServiceClient

    @ServiceClient.setter
    def ServiceClient(self, ServiceClient):
        self._ServiceClient = ServiceClient

    @property
    def DisableApiTermination(self):
        r"""Whether instance protection is enabled. True: enabled, false: disabled.
        :rtype: bool
        """
        return self._DisableApiTermination

    @DisableApiTermination.setter
    def DisableApiTermination(self, DisableApiTermination):
        self._DisableApiTermination = DisableApiTermination

    @property
    def TradeVersion(self):
        r"""0: old billing, 1: new billing.
        :rtype: int
        """
        return self._TradeVersion

    @TradeVersion.setter
    def TradeVersion(self, TradeVersion):
        self._TradeVersion = TradeVersion

    @property
    def ServicesStatus(self):
        r"""Component status. ZooKeeper: STARTED, ResourceManager: STARTED, STARTED: Component is running, STOPPED: Component is halted.
        :rtype: str
        """
        return self._ServicesStatus

    @ServicesStatus.setter
    def ServicesStatus(self, ServicesStatus):
        self._ServicesStatus = ServicesStatus

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SharedClusterId(self):
        r"""Shared cluster ID.
        :rtype: str
        """
        return self._SharedClusterId

    @SharedClusterId.setter
    def SharedClusterId(self, SharedClusterId):
        self._SharedClusterId = SharedClusterId

    @property
    def SharedClusterIdDesc(self):
        r"""Shared cluster ID description.
        :rtype: str
        """
        return self._SharedClusterIdDesc

    @SharedClusterIdDesc.setter
    def SharedClusterIdDesc(self, SharedClusterIdDesc):
        self._SharedClusterIdDesc = SharedClusterIdDesc

    @property
    def TimingResource(self):
        r"""Whether the resource is set for scheduled termination.
        :rtype: bool
        """
        return self._TimingResource

    @TimingResource.setter
    def TimingResource(self, TimingResource):
        self._TimingResource = TimingResource

    @property
    def TkeClusterId(self):
        r"""Corresponding TKE cluster ID in the case that the resource type (HardwareResourceType) is pod.
        :rtype: str
        """
        return self._TkeClusterId

    @TkeClusterId.setter
    def TkeClusterId(self, TkeClusterId):
        self._TkeClusterId = TkeClusterId

    @property
    def ConfigurableServices(self):
        r"""Name list of services that can be configured when a new disk is mounted.
        :rtype: list of str
        """
        return self._ConfigurableServices

    @ConfigurableServices.setter
    def ConfigurableServices(self, ConfigurableServices):
        self._ConfigurableServices = ConfigurableServices

    @property
    def NodeMark(self):
        r"""Node labeling information: currently used only in the Terraform.
        :rtype: str
        """
        return self._NodeMark

    @NodeMark.setter
    def NodeMark(self, NodeMark):
        self._NodeMark = NodeMark

    @property
    def UnderwriteSetAutoRenew(self):
        r"""Whether auto-renewal is available for committed use resources.
        :rtype: bool
        """
        return self._UnderwriteSetAutoRenew

    @UnderwriteSetAutoRenew.setter
    def UnderwriteSetAutoRenew(self, UnderwriteSetAutoRenew):
        self._UnderwriteSetAutoRenew = UnderwriteSetAutoRenew

    @property
    def GpuDesc(self):
        r"""GPU information.
        :rtype: str
        """
        return self._GpuDesc

    @GpuDesc.setter
    def GpuDesc(self, GpuDesc):
        self._GpuDesc = GpuDesc


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._SerialNo = params.get("SerialNo")
        self._OrderNo = params.get("OrderNo")
        self._WanIp = params.get("WanIp")
        self._Flag = params.get("Flag")
        self._Spec = params.get("Spec")
        self._CpuNum = params.get("CpuNum")
        self._MemSize = params.get("MemSize")
        self._MemDesc = params.get("MemDesc")
        self._RegionId = params.get("RegionId")
        self._ZoneId = params.get("ZoneId")
        self._ApplyTime = params.get("ApplyTime")
        self._FreeTime = params.get("FreeTime")
        self._DiskSize = params.get("DiskSize")
        self._NameTag = params.get("NameTag")
        self._Services = params.get("Services")
        self._StorageType = params.get("StorageType")
        self._RootSize = params.get("RootSize")
        self._ChargeType = params.get("ChargeType")
        self._CdbIp = params.get("CdbIp")
        self._CdbPort = params.get("CdbPort")
        self._HwDiskSize = params.get("HwDiskSize")
        self._HwDiskSizeDesc = params.get("HwDiskSizeDesc")
        self._HwMemSize = params.get("HwMemSize")
        self._HwMemSizeDesc = params.get("HwMemSizeDesc")
        self._ExpireTime = params.get("ExpireTime")
        self._EmrResourceId = params.get("EmrResourceId")
        self._IsAutoRenew = params.get("IsAutoRenew")
        self._DeviceClass = params.get("DeviceClass")
        self._Mutable = params.get("Mutable")
        if params.get("MCMultiDisk") is not None:
            self._MCMultiDisk = []
            for item in params.get("MCMultiDisk"):
                obj = MultiDiskMC()
                obj._deserialize(item)
                self._MCMultiDisk.append(obj)
        if params.get("CdbNodeInfo") is not None:
            self._CdbNodeInfo = CdbInfo()
            self._CdbNodeInfo._deserialize(params.get("CdbNodeInfo"))
        self._Ip = params.get("Ip")
        self._Destroyable = params.get("Destroyable")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AutoFlag = params.get("AutoFlag")
        self._HardwareResourceType = params.get("HardwareResourceType")
        self._IsDynamicSpec = params.get("IsDynamicSpec")
        self._DynamicPodSpec = params.get("DynamicPodSpec")
        self._SupportModifyPayMode = params.get("SupportModifyPayMode")
        self._RootStorageType = params.get("RootStorageType")
        self._Zone = params.get("Zone")
        if params.get("SubnetInfo") is not None:
            self._SubnetInfo = SubnetInfo()
            self._SubnetInfo._deserialize(params.get("SubnetInfo"))
        self._Clients = params.get("Clients")
        self._CurrentTime = params.get("CurrentTime")
        self._IsFederation = params.get("IsFederation")
        self._DeviceName = params.get("DeviceName")
        self._ServiceClient = params.get("ServiceClient")
        self._DisableApiTermination = params.get("DisableApiTermination")
        self._TradeVersion = params.get("TradeVersion")
        self._ServicesStatus = params.get("ServicesStatus")
        self._Remark = params.get("Remark")
        self._SharedClusterId = params.get("SharedClusterId")
        self._SharedClusterIdDesc = params.get("SharedClusterIdDesc")
        self._TimingResource = params.get("TimingResource")
        self._TkeClusterId = params.get("TkeClusterId")
        self._ConfigurableServices = params.get("ConfigurableServices")
        self._NodeMark = params.get("NodeMark")
        self._UnderwriteSetAutoRenew = params.get("UnderwriteSetAutoRenew")
        self._GpuDesc = params.get("GpuDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeMark(AbstractModel):
    r"""Node tag information.

    """

    def __init__(self):
        r"""
        :param _NodeType: Node type: master, core, task, router.
        :type NodeType: str
        :param _NodeNames: Node tag information: currently used only in the Terraform. It serves as an input parameter to differentiate information of nodes with the same type.
        :type NodeNames: list of str
        :param _Zone: Availability zone name.
        :type Zone: str
        """
        self._NodeType = None
        self._NodeNames = None
        self._Zone = None

    @property
    def NodeType(self):
        r"""Node type: master, core, task, router.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeNames(self):
        r"""Node tag information: currently used only in the Terraform. It serves as an input parameter to differentiate information of nodes with the same type.
        :rtype: list of str
        """
        return self._NodeNames

    @NodeNames.setter
    def NodeNames(self, NodeNames):
        self._NodeNames = NodeNames

    @property
    def Zone(self):
        r"""Availability zone name.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeNames = params.get("NodeNames")
        self._Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeRenewPriceDetail(AbstractModel):
    r"""Node renewal pricing details.

    """

    def __init__(self):
        r"""
        :param _ChargeType: Billing type (1: monthly subscription, 3: committed use).
        :type ChargeType: int
        :param _EmrResourceId: EMR resource ID.
        :type EmrResourceId: str
        :param _NodeType: Node type.
        :type NodeType: str
        :param _Ip: Node private network IP.
        :type Ip: str
        :param _ExpireTime: Current expiration time.
        :type ExpireTime: str
        :param _OriginalCost: Original price.
        :type OriginalCost: float
        :param _DiscountCost: Discount price.
        :type DiscountCost: float
        :param _RenewPriceDetails: Node component renewal pricing list.
        :type RenewPriceDetails: list of RenewPriceDetail
        """
        self._ChargeType = None
        self._EmrResourceId = None
        self._NodeType = None
        self._Ip = None
        self._ExpireTime = None
        self._OriginalCost = None
        self._DiscountCost = None
        self._RenewPriceDetails = None

    @property
    def ChargeType(self):
        r"""Billing type (1: monthly subscription, 3: committed use).
        :rtype: int
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def EmrResourceId(self):
        r"""EMR resource ID.
        :rtype: str
        """
        return self._EmrResourceId

    @EmrResourceId.setter
    def EmrResourceId(self, EmrResourceId):
        self._EmrResourceId = EmrResourceId

    @property
    def NodeType(self):
        r"""Node type.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def Ip(self):
        r"""Node private network IP.
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ExpireTime(self):
        r"""Current expiration time.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discount price.
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost

    @property
    def RenewPriceDetails(self):
        r"""Node component renewal pricing list.
        :rtype: list of RenewPriceDetail
        """
        return self._RenewPriceDetails

    @RenewPriceDetails.setter
    def RenewPriceDetails(self, RenewPriceDetails):
        self._RenewPriceDetails = RenewPriceDetails


    def _deserialize(self, params):
        self._ChargeType = params.get("ChargeType")
        self._EmrResourceId = params.get("EmrResourceId")
        self._NodeType = params.get("NodeType")
        self._Ip = params.get("Ip")
        self._ExpireTime = params.get("ExpireTime")
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        if params.get("RenewPriceDetails") is not None:
            self._RenewPriceDetails = []
            for item in params.get("RenewPriceDetails"):
                obj = RenewPriceDetail()
                obj._deserialize(item)
                self._RenewPriceDetails.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeResource(AbstractModel):
    r"""Specifications management, which includes specifications type descriptions.

    """

    def __init__(self):
        r"""
        :param _ResourceConfigId: Configuration ID.
        :type ResourceConfigId: int
        :param _Resource: Resource
Note: This field may return null, indicating that no valid values can be obtained.
        :type Resource: :class:`tencentcloud.emr.v20190103.models.Resource`
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        :param _IsDefault: Whether default configuration applies, DEFAULT or BACKUP.
        :type IsDefault: str
        :param _MaxResourceNum: Remaining of this type.
        :type MaxResourceNum: int
        :param _PrepaidUnderwritePeriods: Supported committed use duration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PrepaidUnderwritePeriods: list of int
        """
        self._ResourceConfigId = None
        self._Resource = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsDefault = None
        self._MaxResourceNum = None
        self._PrepaidUnderwritePeriods = None

    @property
    def ResourceConfigId(self):
        r"""Configuration ID.
        :rtype: int
        """
        return self._ResourceConfigId

    @ResourceConfigId.setter
    def ResourceConfigId(self, ResourceConfigId):
        self._ResourceConfigId = ResourceConfigId

    @property
    def Resource(self):
        r"""Resource
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Resource`
        """
        return self._Resource

    @Resource.setter
    def Resource(self, Resource):
        self._Resource = Resource

    @property
    def CreateTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsDefault(self):
        r"""Whether default configuration applies, DEFAULT or BACKUP.
        :rtype: str
        """
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault

    @property
    def MaxResourceNum(self):
        r"""Remaining of this type.
        :rtype: int
        """
        return self._MaxResourceNum

    @MaxResourceNum.setter
    def MaxResourceNum(self, MaxResourceNum):
        self._MaxResourceNum = MaxResourceNum

    @property
    def PrepaidUnderwritePeriods(self):
        r"""Supported committed use duration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._PrepaidUnderwritePeriods

    @PrepaidUnderwritePeriods.setter
    def PrepaidUnderwritePeriods(self, PrepaidUnderwritePeriods):
        self._PrepaidUnderwritePeriods = PrepaidUnderwritePeriods


    def _deserialize(self, params):
        self._ResourceConfigId = params.get("ResourceConfigId")
        if params.get("Resource") is not None:
            self._Resource = Resource()
            self._Resource._deserialize(params.get("Resource"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsDefault = params.get("IsDefault")
        self._MaxResourceNum = params.get("MaxResourceNum")
        self._PrepaidUnderwritePeriods = params.get("PrepaidUnderwritePeriods")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeResourceSpec(AbstractModel):
    r"""Resource details

    """

    def __init__(self):
        r"""
        :param _InstanceType: specifications type, such as S2.MEDIUM8.
        :type InstanceType: str
        :param _SystemDisk: The system disk, which can be up to 1 PCS.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SystemDisk: list of DiskSpecInfo
        :param _Tags: The list of tags to be bound.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _DataDisk: The cloud data disk, which can be up to 15 PCS.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataDisk: list of DiskSpecInfo
        :param _LocalDataDisk: The local data disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LocalDataDisk: list of DiskSpecInfo
        """
        self._InstanceType = None
        self._SystemDisk = None
        self._Tags = None
        self._DataDisk = None
        self._LocalDataDisk = None

    @property
    def InstanceType(self):
        r"""specifications type, such as S2.MEDIUM8.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def SystemDisk(self):
        r"""The system disk, which can be up to 1 PCS.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DiskSpecInfo
        """
        return self._SystemDisk

    @SystemDisk.setter
    def SystemDisk(self, SystemDisk):
        self._SystemDisk = SystemDisk

    @property
    def Tags(self):
        r"""The list of tags to be bound.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DataDisk(self):
        r"""The cloud data disk, which can be up to 15 PCS.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DiskSpecInfo
        """
        return self._DataDisk

    @DataDisk.setter
    def DataDisk(self, DataDisk):
        self._DataDisk = DataDisk

    @property
    def LocalDataDisk(self):
        r"""The local data disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DiskSpecInfo
        """
        return self._LocalDataDisk

    @LocalDataDisk.setter
    def LocalDataDisk(self, LocalDataDisk):
        self._LocalDataDisk = LocalDataDisk


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        if params.get("SystemDisk") is not None:
            self._SystemDisk = []
            for item in params.get("SystemDisk"):
                obj = DiskSpecInfo()
                obj._deserialize(item)
                self._SystemDisk.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        if params.get("DataDisk") is not None:
            self._DataDisk = []
            for item in params.get("DataDisk"):
                obj = DiskSpecInfo()
                obj._deserialize(item)
                self._DataDisk.append(obj)
        if params.get("LocalDataDisk") is not None:
            self._LocalDataDisk = []
            for item in params.get("LocalDataDisk"):
                obj = DiskSpecInfo()
                obj._deserialize(item)
                self._LocalDataDisk.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeSpecDisk(AbstractModel):
    r"""Node disk type.

    """

    def __init__(self):
        r"""
        :param _Count: Quantity.
        :type Count: int
        :param _Name: Name.
        :type Name: str
        :param _DiskType: Disk type.
        :type DiskType: str
        :param _DefaultDiskSize: Specified disk size.
        :type DefaultDiskSize: int
        """
        self._Count = None
        self._Name = None
        self._DiskType = None
        self._DefaultDiskSize = None

    @property
    def Count(self):
        r"""Quantity.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Name(self):
        r"""Name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DiskType(self):
        r"""Disk type.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DefaultDiskSize(self):
        r"""Specified disk size.
        :rtype: int
        """
        return self._DefaultDiskSize

    @DefaultDiskSize.setter
    def DefaultDiskSize(self, DefaultDiskSize):
        self._DefaultDiskSize = DefaultDiskSize


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._Name = params.get("Name")
        self._DiskType = params.get("DiskType")
        self._DefaultDiskSize = params.get("DefaultDiskSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeSpecDiskV2(AbstractModel):
    r"""Node disk type.

    """

    def __init__(self):
        r"""
        :param _Count: Quantity.
        :type Count: int
        :param _Name: Name.
        :type Name: str
        :param _DiskType: Disk type.
        :type DiskType: str
        :param _DefaultDiskSize: Specified disk size.
        :type DefaultDiskSize: int
        """
        self._Count = None
        self._Name = None
        self._DiskType = None
        self._DefaultDiskSize = None

    @property
    def Count(self):
        r"""Quantity.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Name(self):
        r"""Name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DiskType(self):
        r"""Disk type.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DefaultDiskSize(self):
        r"""Specified disk size.
        :rtype: int
        """
        return self._DefaultDiskSize

    @DefaultDiskSize.setter
    def DefaultDiskSize(self, DefaultDiskSize):
        self._DefaultDiskSize = DefaultDiskSize


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._Name = params.get("Name")
        self._DiskType = params.get("DiskType")
        self._DefaultDiskSize = params.get("DefaultDiskSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeSpecFamily(AbstractModel):
    r"""Node model list.

    """

    def __init__(self):
        r"""
        :param _InstanceFamily: Model.
        :type InstanceFamily: str
        :param _FamilyName: Model name.
        :type FamilyName: str
        :param _Order: Order.
        :type Order: int
        :param _InstanceTypes: InstanceType List.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceTypes: list of NodeSpecInstanceType
        """
        self._InstanceFamily = None
        self._FamilyName = None
        self._Order = None
        self._InstanceTypes = None

    @property
    def InstanceFamily(self):
        r"""Model.
        :rtype: str
        """
        return self._InstanceFamily

    @InstanceFamily.setter
    def InstanceFamily(self, InstanceFamily):
        self._InstanceFamily = InstanceFamily

    @property
    def FamilyName(self):
        r"""Model name.
        :rtype: str
        """
        return self._FamilyName

    @FamilyName.setter
    def FamilyName(self, FamilyName):
        self._FamilyName = FamilyName

    @property
    def Order(self):
        r"""Order.
        :rtype: int
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def InstanceTypes(self):
        r"""InstanceType List.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecInstanceType
        """
        return self._InstanceTypes

    @InstanceTypes.setter
    def InstanceTypes(self, InstanceTypes):
        self._InstanceTypes = InstanceTypes


    def _deserialize(self, params):
        self._InstanceFamily = params.get("InstanceFamily")
        self._FamilyName = params.get("FamilyName")
        self._Order = params.get("Order")
        if params.get("InstanceTypes") is not None:
            self._InstanceTypes = []
            for item in params.get("InstanceTypes"):
                obj = NodeSpecInstanceType()
                obj._deserialize(item)
                self._InstanceTypes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeSpecInstanceType(AbstractModel):
    r"""Node specifications type.

    """

    def __init__(self):
        r"""
        :param _InstanceType: Specifications.
        :type InstanceType: str
        :param _Cpu: 4
        :type Cpu: int
        :param _Memory: 8, in GB.
        :type Memory: int
        :param _Order: Order, with the smaller coming first.
        :type Order: int
        :param _Num: Quantity.
        :type Num: int
        :param _SellOutReason: Reasons for running out of stock.
        :type SellOutReason: str
        :param _SystemDisk: System disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SystemDisk: list of NodeSpecDisk
        :param _DataDisk: Data disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataDisk: list of NodeSpecDisk
        :param _LocalDataDisk: Local data disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LocalDataDisk: list of NodeSpecDisk
        :param _SoldOutReason: Reasons for running out of stock.
        :type SoldOutReason: str
        :param _InstanceFamily: Model category.
        :type InstanceFamily: str
        :param _NodeName: Node name.
        :type NodeName: str
        :param _NodeType: Node type.
        :type NodeType: str
        :param _Type: Category.
        :type Type: str
        :param _TypeName: Category name.
        :type TypeName: str
        :param _FamilyName: Category classification.
        :type FamilyName: str
        :param _CpuType: CPU type.
        :type CpuType: str
        :param _Remark: RunOut (denoting running out of stock), Less (denoting low inventory), and Enough (denoting sufficient).
        :type Remark: str
        :param _OriginPrice: Original price.
        :type OriginPrice: float
        :param _PrepaidUnderwritePeriods: Supported purchase terms for committed use billing models.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PrepaidUnderwritePeriods: list of int
        :param _GpuDesc: GPU information.
        :type GpuDesc: str
        """
        self._InstanceType = None
        self._Cpu = None
        self._Memory = None
        self._Order = None
        self._Num = None
        self._SellOutReason = None
        self._SystemDisk = None
        self._DataDisk = None
        self._LocalDataDisk = None
        self._SoldOutReason = None
        self._InstanceFamily = None
        self._NodeName = None
        self._NodeType = None
        self._Type = None
        self._TypeName = None
        self._FamilyName = None
        self._CpuType = None
        self._Remark = None
        self._OriginPrice = None
        self._PrepaidUnderwritePeriods = None
        self._GpuDesc = None

    @property
    def InstanceType(self):
        r"""Specifications.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Cpu(self):
        r"""4
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""8, in GB.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Order(self):
        r"""Order, with the smaller coming first.
        :rtype: int
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Num(self):
        r"""Quantity.
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num

    @property
    def SellOutReason(self):
        r"""Reasons for running out of stock.
        :rtype: str
        """
        return self._SellOutReason

    @SellOutReason.setter
    def SellOutReason(self, SellOutReason):
        self._SellOutReason = SellOutReason

    @property
    def SystemDisk(self):
        r"""System disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecDisk
        """
        return self._SystemDisk

    @SystemDisk.setter
    def SystemDisk(self, SystemDisk):
        self._SystemDisk = SystemDisk

    @property
    def DataDisk(self):
        r"""Data disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecDisk
        """
        return self._DataDisk

    @DataDisk.setter
    def DataDisk(self, DataDisk):
        self._DataDisk = DataDisk

    @property
    def LocalDataDisk(self):
        r"""Local data disk.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecDisk
        """
        return self._LocalDataDisk

    @LocalDataDisk.setter
    def LocalDataDisk(self, LocalDataDisk):
        self._LocalDataDisk = LocalDataDisk

    @property
    def SoldOutReason(self):
        r"""Reasons for running out of stock.
        :rtype: str
        """
        return self._SoldOutReason

    @SoldOutReason.setter
    def SoldOutReason(self, SoldOutReason):
        self._SoldOutReason = SoldOutReason

    @property
    def InstanceFamily(self):
        r"""Model category.
        :rtype: str
        """
        return self._InstanceFamily

    @InstanceFamily.setter
    def InstanceFamily(self, InstanceFamily):
        self._InstanceFamily = InstanceFamily

    @property
    def NodeName(self):
        r"""Node name.
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeType(self):
        r"""Node type.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def Type(self):
        r"""Category.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TypeName(self):
        r"""Category name.
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def FamilyName(self):
        r"""Category classification.
        :rtype: str
        """
        return self._FamilyName

    @FamilyName.setter
    def FamilyName(self, FamilyName):
        self._FamilyName = FamilyName

    @property
    def CpuType(self):
        r"""CPU type.
        :rtype: str
        """
        return self._CpuType

    @CpuType.setter
    def CpuType(self, CpuType):
        self._CpuType = CpuType

    @property
    def Remark(self):
        r"""RunOut (denoting running out of stock), Less (denoting low inventory), and Enough (denoting sufficient).
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def OriginPrice(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginPrice

    @OriginPrice.setter
    def OriginPrice(self, OriginPrice):
        self._OriginPrice = OriginPrice

    @property
    def PrepaidUnderwritePeriods(self):
        r"""Supported purchase terms for committed use billing models.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of int
        """
        return self._PrepaidUnderwritePeriods

    @PrepaidUnderwritePeriods.setter
    def PrepaidUnderwritePeriods(self, PrepaidUnderwritePeriods):
        self._PrepaidUnderwritePeriods = PrepaidUnderwritePeriods

    @property
    def GpuDesc(self):
        r"""GPU information.
        :rtype: str
        """
        return self._GpuDesc

    @GpuDesc.setter
    def GpuDesc(self, GpuDesc):
        self._GpuDesc = GpuDesc


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._Order = params.get("Order")
        self._Num = params.get("Num")
        self._SellOutReason = params.get("SellOutReason")
        if params.get("SystemDisk") is not None:
            self._SystemDisk = []
            for item in params.get("SystemDisk"):
                obj = NodeSpecDisk()
                obj._deserialize(item)
                self._SystemDisk.append(obj)
        if params.get("DataDisk") is not None:
            self._DataDisk = []
            for item in params.get("DataDisk"):
                obj = NodeSpecDisk()
                obj._deserialize(item)
                self._DataDisk.append(obj)
        if params.get("LocalDataDisk") is not None:
            self._LocalDataDisk = []
            for item in params.get("LocalDataDisk"):
                obj = NodeSpecDisk()
                obj._deserialize(item)
                self._LocalDataDisk.append(obj)
        self._SoldOutReason = params.get("SoldOutReason")
        self._InstanceFamily = params.get("InstanceFamily")
        self._NodeName = params.get("NodeName")
        self._NodeType = params.get("NodeType")
        self._Type = params.get("Type")
        self._TypeName = params.get("TypeName")
        self._FamilyName = params.get("FamilyName")
        self._CpuType = params.get("CpuType")
        self._Remark = params.get("Remark")
        self._OriginPrice = params.get("OriginPrice")
        self._PrepaidUnderwritePeriods = params.get("PrepaidUnderwritePeriods")
        self._GpuDesc = params.get("GpuDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeSpecType(AbstractModel):
    r"""Node model type.

    """

    def __init__(self):
        r"""
        :param _Type: Model series.
        :type Type: str
        :param _TypeName: Model series name.
        :type TypeName: str
        :param _Order: Order.
        :type Order: int
        :param _InstanceFamilies: InstanceFamily array.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceFamilies: list of NodeSpecFamily
        """
        self._Type = None
        self._TypeName = None
        self._Order = None
        self._InstanceFamilies = None

    @property
    def Type(self):
        r"""Model series.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TypeName(self):
        r"""Model series name.
        :rtype: str
        """
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def Order(self):
        r"""Order.
        :rtype: int
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def InstanceFamilies(self):
        r"""InstanceFamily array.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NodeSpecFamily
        """
        return self._InstanceFamilies

    @InstanceFamilies.setter
    def InstanceFamilies(self, InstanceFamilies):
        self._InstanceFamilies = InstanceFamilies


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TypeName = params.get("TypeName")
        self._Order = params.get("Order")
        if params.get("InstanceFamilies") is not None:
            self._InstanceFamilies = []
            for item in params.get("InstanceFamilies"):
                obj = NodeSpecFamily()
                obj._deserialize(item)
                self._InstanceFamilies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotRepeatStrategy(AbstractModel):
    r"""Context of the rule for executing elastic scaling once

    """

    def __init__(self):
        r"""
        :param _ExecuteAt: The specific complete time when the task was executed, in the format of "2020-07-13 00:00:00".
        :type ExecuteAt: str
        """
        self._ExecuteAt = None

    @property
    def ExecuteAt(self):
        r"""The specific complete time when the task was executed, in the format of "2020-07-13 00:00:00".
        :rtype: str
        """
        return self._ExecuteAt

    @ExecuteAt.setter
    def ExecuteAt(self, ExecuteAt):
        self._ExecuteAt = ExecuteAt


    def _deserialize(self, params):
        self._ExecuteAt = params.get("ExecuteAt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpScope(AbstractModel):
    r"""Operation scope

    """

    def __init__(self):
        r"""
        :param _ServiceInfoList: The information of the services to operate on.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceInfoList: list of ServiceBasicRestartInfo
        """
        self._ServiceInfoList = None

    @property
    def ServiceInfoList(self):
        r"""The information of the services to operate on.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ServiceBasicRestartInfo
        """
        return self._ServiceInfoList

    @ServiceInfoList.setter
    def ServiceInfoList(self, ServiceInfoList):
        self._ServiceInfoList = ServiceInfoList


    def _deserialize(self, params):
        if params.get("ServiceInfoList") is not None:
            self._ServiceInfoList = []
            for item in params.get("ServiceInfoList"):
                obj = ServiceBasicRestartInfo()
                obj._deserialize(item)
                self._ServiceInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Order(AbstractModel):
    r"""Description order, which is used for sorting.

    """

    def __init__(self):
        r"""
        :param _Name: Order field.
        :type Name: str
        :param _Direction: Desc or Asc.
        :type Direction: str
        """
        self._Name = None
        self._Direction = None

    @property
    def Name(self):
        r"""Order field.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Direction(self):
        r"""Desc or Asc.
        :rtype: str
        """
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Direction = params.get("Direction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OutterResource(AbstractModel):
    r"""Resource details

    """

    def __init__(self):
        r"""
        :param _Spec: Specification
Note: this field may return null, indicating that no valid values can be obtained.
        :type Spec: str
        :param _SpecName: Specification name
Note: this field may return null, indicating that no valid values can be obtained.
        :type SpecName: str
        :param _StorageType: Disk type
Note: this field may return null, indicating that no valid values can be obtained.
        :type StorageType: int
        :param _DiskType: Disk type
Note: this field may return null, indicating that no valid values can be obtained.
        :type DiskType: str
        :param _RootSize: System disk size
Note: this field may return null, indicating that no valid values can be obtained.
        :type RootSize: int
        :param _MemSize: Memory size
Note: this field may return null, indicating that no valid values can be obtained.
        :type MemSize: int
        :param _Cpu: Number of CPUs
Note: this field may return null, indicating that no valid values can be obtained.
        :type Cpu: int
        :param _DiskSize: Disk size
Note: this field may return null, indicating that no valid values can be obtained.
        :type DiskSize: int
        :param _InstanceType: Specification
Note: this field may return null, indicating that no valid values can be obtained.
        :type InstanceType: str
        """
        self._Spec = None
        self._SpecName = None
        self._StorageType = None
        self._DiskType = None
        self._RootSize = None
        self._MemSize = None
        self._Cpu = None
        self._DiskSize = None
        self._InstanceType = None

    @property
    def Spec(self):
        r"""Specification
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def SpecName(self):
        r"""Specification name
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def StorageType(self):
        r"""Disk type
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def DiskType(self):
        r"""Disk type
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def RootSize(self):
        r"""System disk size
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RootSize

    @RootSize.setter
    def RootSize(self, RootSize):
        self._RootSize = RootSize

    @property
    def MemSize(self):
        r"""Memory size
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def Cpu(self):
        r"""Number of CPUs
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def DiskSize(self):
        r"""Disk size
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def InstanceType(self):
        r"""Specification
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType


    def _deserialize(self, params):
        self._Spec = params.get("Spec")
        self._SpecName = params.get("SpecName")
        self._StorageType = params.get("StorageType")
        self._DiskType = params.get("DiskType")
        self._RootSize = params.get("RootSize")
        self._MemSize = params.get("MemSize")
        self._Cpu = params.get("Cpu")
        self._DiskSize = params.get("DiskSize")
        self._InstanceType = params.get("InstanceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OverviewMetricData(AbstractModel):
    r"""Overview data.

    """

    def __init__(self):
        r"""
        :param _Metric: Metric name.
        :type Metric: str
        :param _First: First data timestamp.
        :type First: int
        :param _Last: Last data timestamp.
        :type Last: int
        :param _Interval: Sampling point time interval.
        :type Interval: int
        :param _DataPoints: Sampling point data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataPoints: list of str
        :param _Tags: Metric tags.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: :class:`tencentcloud.emr.v20190103.models.MetricTags`
        """
        self._Metric = None
        self._First = None
        self._Last = None
        self._Interval = None
        self._DataPoints = None
        self._Tags = None

    @property
    def Metric(self):
        r"""Metric name.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def First(self):
        r"""First data timestamp.
        :rtype: int
        """
        return self._First

    @First.setter
    def First(self, First):
        self._First = First

    @property
    def Last(self):
        r"""Last data timestamp.
        :rtype: int
        """
        return self._Last

    @Last.setter
    def Last(self, Last):
        self._Last = Last

    @property
    def Interval(self):
        r"""Sampling point time interval.
        :rtype: int
        """
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def DataPoints(self):
        r"""Sampling point data.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DataPoints

    @DataPoints.setter
    def DataPoints(self, DataPoints):
        self._DataPoints = DataPoints

    @property
    def Tags(self):
        r"""Metric tags.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.MetricTags`
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._First = params.get("First")
        self._Last = params.get("Last")
        self._Interval = params.get("Interval")
        self._DataPoints = params.get("DataPoints")
        if params.get("Tags") is not None:
            self._Tags = MetricTags()
            self._Tags._deserialize(params.get("Tags"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OverviewRow(AbstractModel):
    r"""Return of HBase TableMetric overview

    """

    def __init__(self):
        r"""
        :param _Table: Table name
        :type Table: str
        :param _ReadRequestCount: Number of read requests
        :type ReadRequestCount: float
        :param _WriteRequestCount: Number of write requests
        :type WriteRequestCount: float
        :param _MemstoreSize: Current memstore size
        :type MemstoreSize: float
        :param _StoreFileSize: Size of StoreFile in the current region
        :type StoreFileSize: float
        :param _Operation: Regions. Click to jump.
        :type Operation: str
        :param _StoreFileNum: StoreFile quantity. 
        :type StoreFileNum: float
        """
        self._Table = None
        self._ReadRequestCount = None
        self._WriteRequestCount = None
        self._MemstoreSize = None
        self._StoreFileSize = None
        self._Operation = None
        self._StoreFileNum = None

    @property
    def Table(self):
        r"""Table name
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def ReadRequestCount(self):
        r"""Number of read requests
        :rtype: float
        """
        return self._ReadRequestCount

    @ReadRequestCount.setter
    def ReadRequestCount(self, ReadRequestCount):
        self._ReadRequestCount = ReadRequestCount

    @property
    def WriteRequestCount(self):
        r"""Number of write requests
        :rtype: float
        """
        return self._WriteRequestCount

    @WriteRequestCount.setter
    def WriteRequestCount(self, WriteRequestCount):
        self._WriteRequestCount = WriteRequestCount

    @property
    def MemstoreSize(self):
        r"""Current memstore size
        :rtype: float
        """
        return self._MemstoreSize

    @MemstoreSize.setter
    def MemstoreSize(self, MemstoreSize):
        self._MemstoreSize = MemstoreSize

    @property
    def StoreFileSize(self):
        r"""Size of StoreFile in the current region
        :rtype: float
        """
        return self._StoreFileSize

    @StoreFileSize.setter
    def StoreFileSize(self, StoreFileSize):
        self._StoreFileSize = StoreFileSize

    @property
    def Operation(self):
        r"""Regions. Click to jump.
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def StoreFileNum(self):
        r"""StoreFile quantity. 
        :rtype: float
        """
        return self._StoreFileNum

    @StoreFileNum.setter
    def StoreFileNum(self, StoreFileNum):
        self._StoreFileNum = StoreFileNum


    def _deserialize(self, params):
        self._Table = params.get("Table")
        self._ReadRequestCount = params.get("ReadRequestCount")
        self._WriteRequestCount = params.get("WriteRequestCount")
        self._MemstoreSize = params.get("MemstoreSize")
        self._StoreFileSize = params.get("StoreFileSize")
        self._Operation = params.get("Operation")
        self._StoreFileNum = params.get("StoreFileNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PartDetailPriceItem(AbstractModel):
    r"""Price details by node part, used for creating the cluster price list

    """

    def __init__(self):
        r"""
        :param _InstanceType: Types, including node: node (denoting node), rootDisk (denoting system disk), dataDisk (denoting cloud data disk), and metaDB.
        :type InstanceType: str
        :param _Price: Unit price (original price).
        :type Price: float
        :param _RealCost: Unit price (discounted price).
        :type RealCost: float
        :param _RealTotalCost: Total price (discounted price).
        :type RealTotalCost: float
        :param _Policy: Discount.
        :type Policy: float
        :param _GoodsNum: Quantity.
        :type GoodsNum: int
        """
        self._InstanceType = None
        self._Price = None
        self._RealCost = None
        self._RealTotalCost = None
        self._Policy = None
        self._GoodsNum = None

    @property
    def InstanceType(self):
        r"""Types, including node: node (denoting node), rootDisk (denoting system disk), dataDisk (denoting cloud data disk), and metaDB.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Price(self):
        r"""Unit price (original price).
        :rtype: float
        """
        return self._Price

    @Price.setter
    def Price(self, Price):
        self._Price = Price

    @property
    def RealCost(self):
        r"""Unit price (discounted price).
        :rtype: float
        """
        return self._RealCost

    @RealCost.setter
    def RealCost(self, RealCost):
        self._RealCost = RealCost

    @property
    def RealTotalCost(self):
        r"""Total price (discounted price).
        :rtype: float
        """
        return self._RealTotalCost

    @RealTotalCost.setter
    def RealTotalCost(self, RealTotalCost):
        self._RealTotalCost = RealTotalCost

    @property
    def Policy(self):
        r"""Discount.
        :rtype: float
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def GoodsNum(self):
        r"""Quantity.
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._Price = params.get("Price")
        self._RealCost = params.get("RealCost")
        self._RealTotalCost = params.get("RealTotalCost")
        self._Policy = params.get("Policy")
        self._GoodsNum = params.get("GoodsNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Period(AbstractModel):
    r"""Serverless HBase monthly subscription duration

    """

    def __init__(self):
        r"""
        :param _TimeSpan: Time span.
        :type TimeSpan: int
        :param _TimeUnit: Time unit, "m" stands for month.
        :type TimeUnit: str
        """
        self._TimeSpan = None
        self._TimeUnit = None

    @property
    def TimeSpan(self):
        r"""Time span.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Time unit, "m" stands for month.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PersistentVolumeContext(AbstractModel):
    r"""Description of Pod `PVC` storage method

    """

    def __init__(self):
        r"""
        :param _DiskSize: Disk size in GB.
        :type DiskSize: int
        :param _DiskType: Disk type, CLOUD_PREMIUM or CLOUD_SSD.
        :type DiskType: str
        :param _DiskNum: Number of disks.
        :type DiskNum: int
        :param _ExtraPerformance: Additional performance of cloud disks.
        :type ExtraPerformance: int
        """
        self._DiskSize = None
        self._DiskType = None
        self._DiskNum = None
        self._ExtraPerformance = None

    @property
    def DiskSize(self):
        r"""Disk size in GB.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskType(self):
        r"""Disk type, CLOUD_PREMIUM or CLOUD_SSD.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DiskNum(self):
        r"""Number of disks.
        :rtype: int
        """
        return self._DiskNum

    @DiskNum.setter
    def DiskNum(self, DiskNum):
        self._DiskNum = DiskNum

    @property
    def ExtraPerformance(self):
        r"""Additional performance of cloud disks.
        :rtype: int
        """
        return self._ExtraPerformance

    @ExtraPerformance.setter
    def ExtraPerformance(self, ExtraPerformance):
        self._ExtraPerformance = ExtraPerformance


    def _deserialize(self, params):
        self._DiskSize = params.get("DiskSize")
        self._DiskType = params.get("DiskType")
        self._DiskNum = params.get("DiskNum")
        self._ExtraPerformance = params.get("ExtraPerformance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Placement(AbstractModel):
    r"""Location information of cluster instance

    """

    def __init__(self):
        r"""
        :param _Zone: The ID of the availability zone where the instance resides, such as `ap-guangzhou-1`. You can call the [DescribeZones](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1) API and obtain this ID from the `Zone` field in the response.
        :type Zone: str
        :param _ProjectId: Project ID of the instance. If no ID is passed in, the default project ID is used.
        :type ProjectId: int
        """
        self._Zone = None
        self._ProjectId = None

    @property
    def Zone(self):
        r"""The ID of the availability zone where the instance resides, such as `ap-guangzhou-1`. You can call the [DescribeZones](https://intl.cloud.tencent.com/document/product/213/15707?from_cn_redirect=1) API and obtain this ID from the `Zone` field in the response.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ProjectId(self):
        r"""Project ID of the instance. If no ID is passed in, the default project ID is used.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PodNewParameter(AbstractModel):
    r"""The custom pod permission and parameter.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The TKE or EKS cluster ID.
        :type InstanceId: str
        :param _Config: Custom permissions
Examples:
{
  "apiVersion": "v1",
  "clusters": [
    {
      "cluster": {
        "certificate-authority-data": "xxxxxx==",
        "server": "https://xxxxx.com"
      },
      "name": "cls-xxxxx"
    }
  ],
  "contexts": [
    {
      "context": {
        "cluster": "cls-xxxxx",
        "user": "100014xxxxx"
      },
      "name": "cls-a44yhcxxxxxxxxxx"
    }
  ],
  "current-context": "cls-a4xxxx-context-default",
  "kind": "Config",
  "preferences": {},
  "users": [
    {
      "name": "100014xxxxx",
      "user": {
        "client-certificate-data": "xxxxxx",
        "client-key-data": "xxxxxx"
      }
    }
  ]
}
        :type Config: str
        :param _Parameter: Custom parameters
Examples:
{
    "apiVersion": "apps/v1",
    "kind": "Deployment",
    "metadata": {
      "name": "test-deployment",
      "labels": {
        "app": "test"
      }
    },
    "spec": {
      "replicas": 3,
      "selector": {
        "matchLabels": {
          "app": "test-app"
        }
      },
      "template": {
        "metadata": {
          "annotations": {
            "your-organization.com/department-v1": "test-example-v1",
            "your-organization.com/department-v2": "test-example-v2"
          },
          "labels": {
            "app": "test-app",
            "environment": "production"
          }
        },
        "spec": {
          "nodeSelector": {
            "your-organization/node-test": "test-node"
          },
          "containers": [
            {
              "name": "nginx",
              "image": "nginx:1.14.2",
              "ports": [
                {
                  "containerPort": 80
                }
              ]
            }
          ],
          "affinity": {
            "nodeAffinity": {
              "requiredDuringSchedulingIgnoredDuringExecution": {
                "nodeSelectorTerms": [
                  {
                    "matchExpressions": [
                      {
                        "key": "disk-type",
                        "operator": "In",
                        "values": [
                          "ssd",
                          "sas"
                        ]
                      },
                      {
                        "key": "cpu-num",
                        "operator": "Gt",
                        "values": [
                          "6"
                        ]
                      }
                    ]
                  }
                ]
              }
            }
          }
        }
      }
    }
  }
        :type Parameter: str
        """
        self._InstanceId = None
        self._Config = None
        self._Parameter = None

    @property
    def InstanceId(self):
        r"""The TKE or EKS cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Config(self):
        r"""Custom permissions
Examples:
{
  "apiVersion": "v1",
  "clusters": [
    {
      "cluster": {
        "certificate-authority-data": "xxxxxx==",
        "server": "https://xxxxx.com"
      },
      "name": "cls-xxxxx"
    }
  ],
  "contexts": [
    {
      "context": {
        "cluster": "cls-xxxxx",
        "user": "100014xxxxx"
      },
      "name": "cls-a44yhcxxxxxxxxxx"
    }
  ],
  "current-context": "cls-a4xxxx-context-default",
  "kind": "Config",
  "preferences": {},
  "users": [
    {
      "name": "100014xxxxx",
      "user": {
        "client-certificate-data": "xxxxxx",
        "client-key-data": "xxxxxx"
      }
    }
  ]
}
        :rtype: str
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def Parameter(self):
        r"""Custom parameters
Examples:
{
    "apiVersion": "apps/v1",
    "kind": "Deployment",
    "metadata": {
      "name": "test-deployment",
      "labels": {
        "app": "test"
      }
    },
    "spec": {
      "replicas": 3,
      "selector": {
        "matchLabels": {
          "app": "test-app"
        }
      },
      "template": {
        "metadata": {
          "annotations": {
            "your-organization.com/department-v1": "test-example-v1",
            "your-organization.com/department-v2": "test-example-v2"
          },
          "labels": {
            "app": "test-app",
            "environment": "production"
          }
        },
        "spec": {
          "nodeSelector": {
            "your-organization/node-test": "test-node"
          },
          "containers": [
            {
              "name": "nginx",
              "image": "nginx:1.14.2",
              "ports": [
                {
                  "containerPort": 80
                }
              ]
            }
          ],
          "affinity": {
            "nodeAffinity": {
              "requiredDuringSchedulingIgnoredDuringExecution": {
                "nodeSelectorTerms": [
                  {
                    "matchExpressions": [
                      {
                        "key": "disk-type",
                        "operator": "In",
                        "values": [
                          "ssd",
                          "sas"
                        ]
                      },
                      {
                        "key": "cpu-num",
                        "operator": "Gt",
                        "values": [
                          "6"
                        ]
                      }
                    ]
                  }
                ]
              }
            }
          }
        }
      }
    }
  }
        :rtype: str
        """
        return self._Parameter

    @Parameter.setter
    def Parameter(self, Parameter):
        self._Parameter = Parameter


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Config = params.get("Config")
        self._Parameter = params.get("Parameter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PodNewSpec(AbstractModel):
    r"""Resource descriptions for container resource scale-out

    """

    def __init__(self):
        r"""
        :param _ResourceProviderIdentifier: The identifier of an external resource provider, such as "cls-a1cd23fa".
        :type ResourceProviderIdentifier: str
        :param _ResourceProviderType: The type of the external resource provider, such as "tke". Currently, only "tke" is supported.
        :type ResourceProviderType: str
        :param _NodeFlag: The purpose of the resource, which means the node type and can only be "TASK".
        :type NodeFlag: str
        :param _Cpu: The number of CPUs.
        :type Cpu: int
        :param _Memory: The memory size in GB.
        :type Memory: int
        :param _CpuType: The EKS cluster - CPU type. Valid values: `intel` and `amd`.
        :type CpuType: str
        :param _PodVolumes: The data directory mounting information of the pod node.
        :type PodVolumes: list of PodVolume
        :param _EnableDynamicSpecFlag: Whether the dynamic spec is used. Valid values:
<li>`true`: Yes</li>
<li>`false` (default): No</li>
        :type EnableDynamicSpecFlag: bool
        :param _DynamicPodSpec: The dynamic spec.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DynamicPodSpec: :class:`tencentcloud.emr.v20190103.models.DynamicPodSpec`
        :param _VpcId: Unique ID of VPC network.
        :type VpcId: str
        :param _SubnetId: Unique ID of a VPC subnet.
        :type SubnetId: str
        :param _PodName: pod name
        :type PodName: str
        """
        self._ResourceProviderIdentifier = None
        self._ResourceProviderType = None
        self._NodeFlag = None
        self._Cpu = None
        self._Memory = None
        self._CpuType = None
        self._PodVolumes = None
        self._EnableDynamicSpecFlag = None
        self._DynamicPodSpec = None
        self._VpcId = None
        self._SubnetId = None
        self._PodName = None

    @property
    def ResourceProviderIdentifier(self):
        r"""The identifier of an external resource provider, such as "cls-a1cd23fa".
        :rtype: str
        """
        return self._ResourceProviderIdentifier

    @ResourceProviderIdentifier.setter
    def ResourceProviderIdentifier(self, ResourceProviderIdentifier):
        self._ResourceProviderIdentifier = ResourceProviderIdentifier

    @property
    def ResourceProviderType(self):
        r"""The type of the external resource provider, such as "tke". Currently, only "tke" is supported.
        :rtype: str
        """
        return self._ResourceProviderType

    @ResourceProviderType.setter
    def ResourceProviderType(self, ResourceProviderType):
        self._ResourceProviderType = ResourceProviderType

    @property
    def NodeFlag(self):
        r"""The purpose of the resource, which means the node type and can only be "TASK".
        :rtype: str
        """
        return self._NodeFlag

    @NodeFlag.setter
    def NodeFlag(self, NodeFlag):
        self._NodeFlag = NodeFlag

    @property
    def Cpu(self):
        r"""The number of CPUs.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""The memory size in GB.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def CpuType(self):
        r"""The EKS cluster - CPU type. Valid values: `intel` and `amd`.
        :rtype: str
        """
        return self._CpuType

    @CpuType.setter
    def CpuType(self, CpuType):
        self._CpuType = CpuType

    @property
    def PodVolumes(self):
        r"""The data directory mounting information of the pod node.
        :rtype: list of PodVolume
        """
        return self._PodVolumes

    @PodVolumes.setter
    def PodVolumes(self, PodVolumes):
        self._PodVolumes = PodVolumes

    @property
    def EnableDynamicSpecFlag(self):
        r"""Whether the dynamic spec is used. Valid values:
<li>`true`: Yes</li>
<li>`false` (default): No</li>
        :rtype: bool
        """
        return self._EnableDynamicSpecFlag

    @EnableDynamicSpecFlag.setter
    def EnableDynamicSpecFlag(self, EnableDynamicSpecFlag):
        self._EnableDynamicSpecFlag = EnableDynamicSpecFlag

    @property
    def DynamicPodSpec(self):
        r"""The dynamic spec.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.DynamicPodSpec`
        """
        return self._DynamicPodSpec

    @DynamicPodSpec.setter
    def DynamicPodSpec(self, DynamicPodSpec):
        self._DynamicPodSpec = DynamicPodSpec

    @property
    def VpcId(self):
        r"""Unique ID of VPC network.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Unique ID of a VPC subnet.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def PodName(self):
        r"""pod name
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName


    def _deserialize(self, params):
        self._ResourceProviderIdentifier = params.get("ResourceProviderIdentifier")
        self._ResourceProviderType = params.get("ResourceProviderType")
        self._NodeFlag = params.get("NodeFlag")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._CpuType = params.get("CpuType")
        if params.get("PodVolumes") is not None:
            self._PodVolumes = []
            for item in params.get("PodVolumes"):
                obj = PodVolume()
                obj._deserialize(item)
                self._PodVolumes.append(obj)
        self._EnableDynamicSpecFlag = params.get("EnableDynamicSpecFlag")
        if params.get("DynamicPodSpec") is not None:
            self._DynamicPodSpec = DynamicPodSpec()
            self._DynamicPodSpec._deserialize(params.get("DynamicPodSpec"))
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._PodName = params.get("PodName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PodParameter(AbstractModel):
    r"""Custom pod permission and parameter

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of TKE or EKS cluster
        :type ClusterId: str
        :param _Config: Custom permissions
Example:
{
  "apiVersion": "v1",
  "Clusters": [
    {
      "cluster": {
        "certificate-authority-data": "xxxxxx==",
        "server": "https://xxxxx.com"
      },
      "name": "cls-xxxxx"
    }
  ],
  "contexts": [
    {
      "context": {
        "cluster": "cls-xxxxx",
        "user": "100014xxxxx"
      },
      "name": "cls-a44yhcxxxxxxxxxx"
    }
  ],
  "current-context": "cls-a4xxxx-context-default",
  "kind": "Config",
  "preferences": {},
  "users": [
    {
      "name": "100014xxxxx",
      "user": {
        "client-certificate-data": "xxxxxx",
        "client-key-data": "xxxxxx"
      }
    }
  ]
}
        :type Config: str
        :param _Parameter: Custom parameters
Example:
{
    "apiVersion": "apps/v1",
    "kind": "Deployment",
    "metadata": {
      "name": "test-deployment",
      "labels": {
        "app": "test"
      }
    },
    "spec": {
      "replicas": 3,
      "selector": {
        "matchLabels": {
          "app": "test-app"
        }
      },
      "template": {
        "metadata": {
          "annotations": {
            "your-organization.com/department-v1": "test-example-v1",
            "your-organization.com/department-v2": "test-example-v2"
          },
          "labels": {
            "app": "test-app",
            "environment": "production"
          }
        },
        "spec": {
          "nodeSelector": {
            "your-organization/node-test": "test-node"
          },
          "containers": [
            {
              "name": "nginx",
              "image": "nginx:1.14.2",
              "ports": [
                {
                  "containerPort": 80
                }
              ]
            }
          ],
          "affinity": {
            "nodeAffinity": {
              "requiredDuringSchedulingIgnoredDuringExecution": {
                "nodeSelectorTerms": [
                  {
                    "matchExpressions": [
                      {
                        "key": "disk-type",
                        "operator": "In",
                        "values": [
                          "ssd",
                          "sas"
                        ]
                      },
                      {
                        "key": "cpu-num",
                        "operator": "Gt",
                        "values": [
                          "6"
                        ]
                      }
                    ]
                  }
                ]
              }
            }
          }
        }
      }
    }
  }
        :type Parameter: str
        """
        self._ClusterId = None
        self._Config = None
        self._Parameter = None

    @property
    def ClusterId(self):
        r"""ID of TKE or EKS cluster
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Config(self):
        r"""Custom permissions
Example:
{
  "apiVersion": "v1",
  "Clusters": [
    {
      "cluster": {
        "certificate-authority-data": "xxxxxx==",
        "server": "https://xxxxx.com"
      },
      "name": "cls-xxxxx"
    }
  ],
  "contexts": [
    {
      "context": {
        "cluster": "cls-xxxxx",
        "user": "100014xxxxx"
      },
      "name": "cls-a44yhcxxxxxxxxxx"
    }
  ],
  "current-context": "cls-a4xxxx-context-default",
  "kind": "Config",
  "preferences": {},
  "users": [
    {
      "name": "100014xxxxx",
      "user": {
        "client-certificate-data": "xxxxxx",
        "client-key-data": "xxxxxx"
      }
    }
  ]
}
        :rtype: str
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def Parameter(self):
        r"""Custom parameters
Example:
{
    "apiVersion": "apps/v1",
    "kind": "Deployment",
    "metadata": {
      "name": "test-deployment",
      "labels": {
        "app": "test"
      }
    },
    "spec": {
      "replicas": 3,
      "selector": {
        "matchLabels": {
          "app": "test-app"
        }
      },
      "template": {
        "metadata": {
          "annotations": {
            "your-organization.com/department-v1": "test-example-v1",
            "your-organization.com/department-v2": "test-example-v2"
          },
          "labels": {
            "app": "test-app",
            "environment": "production"
          }
        },
        "spec": {
          "nodeSelector": {
            "your-organization/node-test": "test-node"
          },
          "containers": [
            {
              "name": "nginx",
              "image": "nginx:1.14.2",
              "ports": [
                {
                  "containerPort": 80
                }
              ]
            }
          ],
          "affinity": {
            "nodeAffinity": {
              "requiredDuringSchedulingIgnoredDuringExecution": {
                "nodeSelectorTerms": [
                  {
                    "matchExpressions": [
                      {
                        "key": "disk-type",
                        "operator": "In",
                        "values": [
                          "ssd",
                          "sas"
                        ]
                      },
                      {
                        "key": "cpu-num",
                        "operator": "Gt",
                        "values": [
                          "6"
                        ]
                      }
                    ]
                  }
                ]
              }
            }
          }
        }
      }
    }
  }
        :rtype: str
        """
        return self._Parameter

    @Parameter.setter
    def Parameter(self, Parameter):
        self._Parameter = Parameter


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Config = params.get("Config")
        self._Parameter = params.get("Parameter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PodSpec(AbstractModel):
    r"""Resource description for container resource scale-out

    """

    def __init__(self):
        r"""
        :param _ResourceProviderIdentifier: Identifier of external resource provider, such as "cls-a1cd23fa".
        :type ResourceProviderIdentifier: str
        :param _ResourceProviderType: Type of external resource provider, such as "tke". Currently, only "tke" is supported.
        :type ResourceProviderType: str
        :param _NodeType: Purpose of the resource, which means the node type and can only be "TASK".
        :type NodeType: str
        :param _Cpu: Number of CPUs
        :type Cpu: int
        :param _Memory: Memory size in GB.
        :type Memory: int
        :param _DataVolumes: Mount point of resources for the host. A specified mount point corresponds to the host path and is used as the data storage directory in the pod. (This parameter has been disused)
        :type DataVolumes: list of str
        :param _CpuType: EKS cluster - CPU type. Valid values: `intel` and `amd`.
        :type CpuType: str
        :param _PodVolumes: Data directory mounting information of the pod node.
        :type PodVolumes: list of PodVolume
        :param _IsDynamicSpec: Whether floating specification is used. `1`: Yes; `0`: No.
        :type IsDynamicSpec: int
        :param _DynamicPodSpec: Floating specification
Note: This field may return null, indicating that no valid values can be obtained.
        :type DynamicPodSpec: :class:`tencentcloud.emr.v20190103.models.DynamicPodSpec`
        :param _VpcId: Unique ID of VPC network.
        :type VpcId: str
        :param _SubnetId: Unique ID of a VPC subnet.
        :type SubnetId: str
        :param _PodName: pod name
        :type PodName: str
        """
        self._ResourceProviderIdentifier = None
        self._ResourceProviderType = None
        self._NodeType = None
        self._Cpu = None
        self._Memory = None
        self._DataVolumes = None
        self._CpuType = None
        self._PodVolumes = None
        self._IsDynamicSpec = None
        self._DynamicPodSpec = None
        self._VpcId = None
        self._SubnetId = None
        self._PodName = None

    @property
    def ResourceProviderIdentifier(self):
        r"""Identifier of external resource provider, such as "cls-a1cd23fa".
        :rtype: str
        """
        return self._ResourceProviderIdentifier

    @ResourceProviderIdentifier.setter
    def ResourceProviderIdentifier(self, ResourceProviderIdentifier):
        self._ResourceProviderIdentifier = ResourceProviderIdentifier

    @property
    def ResourceProviderType(self):
        r"""Type of external resource provider, such as "tke". Currently, only "tke" is supported.
        :rtype: str
        """
        return self._ResourceProviderType

    @ResourceProviderType.setter
    def ResourceProviderType(self, ResourceProviderType):
        self._ResourceProviderType = ResourceProviderType

    @property
    def NodeType(self):
        r"""Purpose of the resource, which means the node type and can only be "TASK".
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def Cpu(self):
        r"""Number of CPUs
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory size in GB.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def DataVolumes(self):
        r"""Mount point of resources for the host. A specified mount point corresponds to the host path and is used as the data storage directory in the pod. (This parameter has been disused)
        :rtype: list of str
        """
        return self._DataVolumes

    @DataVolumes.setter
    def DataVolumes(self, DataVolumes):
        self._DataVolumes = DataVolumes

    @property
    def CpuType(self):
        r"""EKS cluster - CPU type. Valid values: `intel` and `amd`.
        :rtype: str
        """
        return self._CpuType

    @CpuType.setter
    def CpuType(self, CpuType):
        self._CpuType = CpuType

    @property
    def PodVolumes(self):
        r"""Data directory mounting information of the pod node.
        :rtype: list of PodVolume
        """
        return self._PodVolumes

    @PodVolumes.setter
    def PodVolumes(self, PodVolumes):
        self._PodVolumes = PodVolumes

    @property
    def IsDynamicSpec(self):
        r"""Whether floating specification is used. `1`: Yes; `0`: No.
        :rtype: int
        """
        return self._IsDynamicSpec

    @IsDynamicSpec.setter
    def IsDynamicSpec(self, IsDynamicSpec):
        self._IsDynamicSpec = IsDynamicSpec

    @property
    def DynamicPodSpec(self):
        r"""Floating specification
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.DynamicPodSpec`
        """
        return self._DynamicPodSpec

    @DynamicPodSpec.setter
    def DynamicPodSpec(self, DynamicPodSpec):
        self._DynamicPodSpec = DynamicPodSpec

    @property
    def VpcId(self):
        r"""Unique ID of VPC network.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Unique ID of a VPC subnet.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def PodName(self):
        r"""pod name
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName


    def _deserialize(self, params):
        self._ResourceProviderIdentifier = params.get("ResourceProviderIdentifier")
        self._ResourceProviderType = params.get("ResourceProviderType")
        self._NodeType = params.get("NodeType")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._DataVolumes = params.get("DataVolumes")
        self._CpuType = params.get("CpuType")
        if params.get("PodVolumes") is not None:
            self._PodVolumes = []
            for item in params.get("PodVolumes"):
                obj = PodVolume()
                obj._deserialize(item)
                self._PodVolumes.append(obj)
        self._IsDynamicSpec = params.get("IsDynamicSpec")
        if params.get("DynamicPodSpec") is not None:
            self._DynamicPodSpec = DynamicPodSpec()
            self._DynamicPodSpec._deserialize(params.get("DynamicPodSpec"))
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._PodName = params.get("PodName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PodSpecInfo(AbstractModel):
    r"""Other pod information.

    """

    def __init__(self):
        r"""
        :param _PodSpec: The specified information such as pod spec and source for scale-out with pod resources.
        :type PodSpec: :class:`tencentcloud.emr.v20190103.models.PodNewSpec`
        :param _PodParameter: The custom pod permission and parameter.
        :type PodParameter: :class:`tencentcloud.emr.v20190103.models.PodNewParameter`
        """
        self._PodSpec = None
        self._PodParameter = None

    @property
    def PodSpec(self):
        r"""The specified information such as pod spec and source for scale-out with pod resources.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PodNewSpec`
        """
        return self._PodSpec

    @PodSpec.setter
    def PodSpec(self, PodSpec):
        self._PodSpec = PodSpec

    @property
    def PodParameter(self):
        r"""The custom pod permission and parameter.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PodNewParameter`
        """
        return self._PodParameter

    @PodParameter.setter
    def PodParameter(self, PodParameter):
        self._PodParameter = PodParameter


    def _deserialize(self, params):
        if params.get("PodSpec") is not None:
            self._PodSpec = PodNewSpec()
            self._PodSpec._deserialize(params.get("PodSpec"))
        if params.get("PodParameter") is not None:
            self._PodParameter = PodNewParameter()
            self._PodParameter._deserialize(params.get("PodParameter"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PodVolume(AbstractModel):
    r"""Description of Pod storage.

    """

    def __init__(self):
        r"""
        :param _VolumeType: Storage type, which can be "pvc" or "hostpath".
        :type VolumeType: str
        :param _PVCVolume: This field will take effect if `VolumeType` is `pvc`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PVCVolume: :class:`tencentcloud.emr.v20190103.models.PersistentVolumeContext`
        :param _HostVolume: This field will take effect if `VolumeType` is `hostpath`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostVolume: :class:`tencentcloud.emr.v20190103.models.HostVolumeContext`
        """
        self._VolumeType = None
        self._PVCVolume = None
        self._HostVolume = None

    @property
    def VolumeType(self):
        r"""Storage type, which can be "pvc" or "hostpath".
        :rtype: str
        """
        return self._VolumeType

    @VolumeType.setter
    def VolumeType(self, VolumeType):
        self._VolumeType = VolumeType

    @property
    def PVCVolume(self):
        r"""This field will take effect if `VolumeType` is `pvc`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PersistentVolumeContext`
        """
        return self._PVCVolume

    @PVCVolume.setter
    def PVCVolume(self, PVCVolume):
        self._PVCVolume = PVCVolume

    @property
    def HostVolume(self):
        r"""This field will take effect if `VolumeType` is `hostpath`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.HostVolumeContext`
        """
        return self._HostVolume

    @HostVolume.setter
    def HostVolume(self, HostVolume):
        self._HostVolume = HostVolume


    def _deserialize(self, params):
        self._VolumeType = params.get("VolumeType")
        if params.get("PVCVolume") is not None:
            self._PVCVolume = PersistentVolumeContext()
            self._PVCVolume._deserialize(params.get("PVCVolume"))
        if params.get("HostVolume") is not None:
            self._HostVolume = HostVolumeContext()
            self._HostVolume._deserialize(params.get("HostVolume"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PreExecuteFileSettings(AbstractModel):
    r"""Pre-execution script configuration

    """

    def __init__(self):
        r"""
        :param _Path: COS path to script, which has been disused
        :type Path: str
        :param _Args: Execution script parameter
        :type Args: list of str
        :param _Bucket: COS bucket name, which has been disused
        :type Bucket: str
        :param _Region: COS region name, which has been disused
        :type Region: str
        :param _Domain: COS domain data, which has been disused
        :type Domain: str
        :param _RunOrder: Execution sequence
        :type RunOrder: int
        :param _WhenRun: `resourceAfter` or `clusterAfter`
        :type WhenRun: str
        :param _CosFileName: Script name, which has been disused
        :type CosFileName: str
        :param _CosFileURI: COS address of script
        :type CosFileURI: str
        :param _CosSecretId: COS `SecretId`
        :type CosSecretId: str
        :param _CosSecretKey: COS `SecretKey`
        :type CosSecretKey: str
        :param _AppId: COS `appid`, which has been disused
        :type AppId: str
        :param _Remark: Remarks
        :type Remark: str
        """
        self._Path = None
        self._Args = None
        self._Bucket = None
        self._Region = None
        self._Domain = None
        self._RunOrder = None
        self._WhenRun = None
        self._CosFileName = None
        self._CosFileURI = None
        self._CosSecretId = None
        self._CosSecretKey = None
        self._AppId = None
        self._Remark = None

    @property
    def Path(self):
        r"""COS path to script, which has been disused
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Args(self):
        r"""Execution script parameter
        :rtype: list of str
        """
        return self._Args

    @Args.setter
    def Args(self, Args):
        self._Args = Args

    @property
    def Bucket(self):
        r"""COS bucket name, which has been disused
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        r"""COS region name, which has been disused
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Domain(self):
        r"""COS domain data, which has been disused
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RunOrder(self):
        r"""Execution sequence
        :rtype: int
        """
        return self._RunOrder

    @RunOrder.setter
    def RunOrder(self, RunOrder):
        self._RunOrder = RunOrder

    @property
    def WhenRun(self):
        r"""`resourceAfter` or `clusterAfter`
        :rtype: str
        """
        return self._WhenRun

    @WhenRun.setter
    def WhenRun(self, WhenRun):
        self._WhenRun = WhenRun

    @property
    def CosFileName(self):
        r"""Script name, which has been disused
        :rtype: str
        """
        return self._CosFileName

    @CosFileName.setter
    def CosFileName(self, CosFileName):
        self._CosFileName = CosFileName

    @property
    def CosFileURI(self):
        r"""COS address of script
        :rtype: str
        """
        return self._CosFileURI

    @CosFileURI.setter
    def CosFileURI(self, CosFileURI):
        self._CosFileURI = CosFileURI

    @property
    def CosSecretId(self):
        r"""COS `SecretId`
        :rtype: str
        """
        return self._CosSecretId

    @CosSecretId.setter
    def CosSecretId(self, CosSecretId):
        self._CosSecretId = CosSecretId

    @property
    def CosSecretKey(self):
        r"""COS `SecretKey`
        :rtype: str
        """
        return self._CosSecretKey

    @CosSecretKey.setter
    def CosSecretKey(self, CosSecretKey):
        self._CosSecretKey = CosSecretKey

    @property
    def AppId(self):
        r"""COS `appid`, which has been disused
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Remark(self):
        r"""Remarks
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Args = params.get("Args")
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Domain = params.get("Domain")
        self._RunOrder = params.get("RunOrder")
        self._WhenRun = params.get("WhenRun")
        self._CosFileName = params.get("CosFileName")
        self._CosFileURI = params.get("CosFileURI")
        self._CosSecretId = params.get("CosSecretId")
        self._CosSecretKey = params.get("CosSecretKey")
        self._AppId = params.get("AppId")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PrePaySetting(AbstractModel):
    r"""Serverless HBase prepaid settings

    """

    def __init__(self):
        r"""
        :param _Period: Time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Period: :class:`tencentcloud.emr.v20190103.models.Period`
        :param _AutoRenewFlag: Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew.
        :type AutoRenewFlag: int
        """
        self._Period = None
        self._AutoRenewFlag = None

    @property
    def Period(self):
        r"""Time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.Period`
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def AutoRenewFlag(self):
        r"""Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew.
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag


    def _deserialize(self, params):
        if params.get("Period") is not None:
            self._Period = Period()
            self._Period._deserialize(params.get("Period"))
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PriceDetail(AbstractModel):
    r"""Pricing details

    """

    def __init__(self):
        r"""
        :param _ResourceId: The node ID
        :type ResourceId: str
        :param _Formula: The price formula
        :type Formula: str
        :param _OriginalCost: The original price
        :type OriginalCost: float
        :param _DiscountCost: The discount price
        :type DiscountCost: float
        """
        self._ResourceId = None
        self._Formula = None
        self._OriginalCost = None
        self._DiscountCost = None

    @property
    def ResourceId(self):
        r"""The node ID
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Formula(self):
        r"""The price formula
        :rtype: str
        """
        return self._Formula

    @Formula.setter
    def Formula(self, Formula):
        self._Formula = Formula

    @property
    def OriginalCost(self):
        r"""The original price
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""The discount price
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._Formula = params.get("Formula")
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PriceResource(AbstractModel):
    r"""Resource queried for price

    """

    def __init__(self):
        r"""
        :param _Spec: Required specifications.
        :type Spec: str
        :param _StorageType: Hard disk type.
        :type StorageType: int
        :param _DiskType: Hard disk type.
        :type DiskType: str
        :param _RootSize: System disk size.
        :type RootSize: int
        :param _MemSize: Memory size.
        :type MemSize: int
        :param _Cpu: Number of cores.
        :type Cpu: int
        :param _DiskSize: Hard disk size.
        :type DiskSize: int
        :param _MultiDisks: List of cloud disks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MultiDisks: list of MultiDisk
        :param _DiskCnt: Number of disks.
        :type DiskCnt: int
        :param _InstanceType: Specifications.
        :type InstanceType: str
        :param _Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _DiskNum: Number of disks.
        :type DiskNum: int
        :param _LocalDiskNum: Number of local disks.
        :type LocalDiskNum: int
        :param _GpuDesc: GPU information.
        :type GpuDesc: str
        """
        self._Spec = None
        self._StorageType = None
        self._DiskType = None
        self._RootSize = None
        self._MemSize = None
        self._Cpu = None
        self._DiskSize = None
        self._MultiDisks = None
        self._DiskCnt = None
        self._InstanceType = None
        self._Tags = None
        self._DiskNum = None
        self._LocalDiskNum = None
        self._GpuDesc = None

    @property
    def Spec(self):
        r"""Required specifications.
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def StorageType(self):
        r"""Hard disk type.
        :rtype: int
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def DiskType(self):
        r"""Hard disk type.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def RootSize(self):
        r"""System disk size.
        :rtype: int
        """
        return self._RootSize

    @RootSize.setter
    def RootSize(self, RootSize):
        self._RootSize = RootSize

    @property
    def MemSize(self):
        r"""Memory size.
        :rtype: int
        """
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def Cpu(self):
        r"""Number of cores.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def DiskSize(self):
        r"""Hard disk size.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def MultiDisks(self):
        r"""List of cloud disks.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MultiDisk
        """
        return self._MultiDisks

    @MultiDisks.setter
    def MultiDisks(self, MultiDisks):
        self._MultiDisks = MultiDisks

    @property
    def DiskCnt(self):
        r"""Number of disks.
        :rtype: int
        """
        return self._DiskCnt

    @DiskCnt.setter
    def DiskCnt(self, DiskCnt):
        self._DiskCnt = DiskCnt

    @property
    def InstanceType(self):
        r"""Specifications.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Tags(self):
        r"""Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DiskNum(self):
        r"""Number of disks.
        :rtype: int
        """
        return self._DiskNum

    @DiskNum.setter
    def DiskNum(self, DiskNum):
        self._DiskNum = DiskNum

    @property
    def LocalDiskNum(self):
        r"""Number of local disks.
        :rtype: int
        """
        return self._LocalDiskNum

    @LocalDiskNum.setter
    def LocalDiskNum(self, LocalDiskNum):
        self._LocalDiskNum = LocalDiskNum

    @property
    def GpuDesc(self):
        r"""GPU information.
        :rtype: str
        """
        return self._GpuDesc

    @GpuDesc.setter
    def GpuDesc(self, GpuDesc):
        self._GpuDesc = GpuDesc


    def _deserialize(self, params):
        self._Spec = params.get("Spec")
        self._StorageType = params.get("StorageType")
        self._DiskType = params.get("DiskType")
        self._RootSize = params.get("RootSize")
        self._MemSize = params.get("MemSize")
        self._Cpu = params.get("Cpu")
        self._DiskSize = params.get("DiskSize")
        if params.get("MultiDisks") is not None:
            self._MultiDisks = []
            for item in params.get("MultiDisks"):
                obj = MultiDisk()
                obj._deserialize(item)
                self._MultiDisks.append(obj)
        self._DiskCnt = params.get("DiskCnt")
        self._InstanceType = params.get("InstanceType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._DiskNum = params.get("DiskNum")
        self._LocalDiskNum = params.get("LocalDiskNum")
        self._GpuDesc = params.get("GpuDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PriceResult(AbstractModel):
    r"""Inquiry results

    """

    def __init__(self):
        r"""
        :param _OriginalCost: Original price.
        :type OriginalCost: float
        :param _DiscountCost: Discount price.
        :type DiscountCost: float
        """
        self._OriginalCost = None
        self._DiscountCost = None

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discount price.
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost


    def _deserialize(self, params):
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RenewPriceDetail(AbstractModel):
    r"""Node component renewal pricing details.

    """

    def __init__(self):
        r"""
        :param _BillingName: Billing item name.
        :type BillingName: str
        :param _Policy: Discount.
        :type Policy: float
        :param _Quantity: Quantity.
        :type Quantity: int
        :param _OriginalCost: Original price.
        :type OriginalCost: float
        :param _DiscountCost: Discount price.
        :type DiscountCost: float
        """
        self._BillingName = None
        self._Policy = None
        self._Quantity = None
        self._OriginalCost = None
        self._DiscountCost = None

    @property
    def BillingName(self):
        r"""Billing item name.
        :rtype: str
        """
        return self._BillingName

    @BillingName.setter
    def BillingName(self, BillingName):
        self._BillingName = BillingName

    @property
    def Policy(self):
        r"""Discount.
        :rtype: float
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def Quantity(self):
        r"""Quantity.
        :rtype: int
        """
        return self._Quantity

    @Quantity.setter
    def Quantity(self, Quantity):
        self._Quantity = Quantity

    @property
    def OriginalCost(self):
        r"""Original price.
        :rtype: float
        """
        return self._OriginalCost

    @OriginalCost.setter
    def OriginalCost(self, OriginalCost):
        self._OriginalCost = OriginalCost

    @property
    def DiscountCost(self):
        r"""Discount price.
        :rtype: float
        """
        return self._DiscountCost

    @DiscountCost.setter
    def DiscountCost(self, DiscountCost):
        self._DiscountCost = DiscountCost


    def _deserialize(self, params):
        self._BillingName = params.get("BillingName")
        self._Policy = params.get("Policy")
        self._Quantity = params.get("Quantity")
        self._OriginalCost = params.get("OriginalCost")
        self._DiscountCost = params.get("DiscountCost")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RepeatStrategy(AbstractModel):
    r"""Scheduled scaling task policy

    """

    def __init__(self):
        r"""
        :param _RepeatType: The valid values DAY, DOW, DOM, and NONE respectively indicate repetition by day, repetition by week, repetition by month, and one-time execution. This parameter is required.
        :type RepeatType: str
        :param _DayRepeat: Daily repetition rule, which is effective when RepeatType is set to DAY

Note: This field may return null, indicating that no valid values can be obtained.
        :type DayRepeat: :class:`tencentcloud.emr.v20190103.models.DayRepeatStrategy`
        :param _WeekRepeat: Weekly repetition rule, effective when RepeatType is DOW

Note: This field may return null, indicating that no valid values can be obtained.
        :type WeekRepeat: :class:`tencentcloud.emr.v20190103.models.WeekRepeatStrategy`
        :param _MonthRepeat: Monthly repetition rule, valid when RepeatType is DOM

Note: This field may return null, indicating that no valid values can be obtained.
        :type MonthRepeat: :class:`tencentcloud.emr.v20190103.models.MonthRepeatStrategy`
        :param _NotRepeat: One-time execution rule, valid when RepeatType is NONE

Note: This field may return null, indicating that no valid values can be obtained.
        :type NotRepeat: :class:`tencentcloud.emr.v20190103.models.NotRepeatStrategy`
        :param _Expire: Rule expiration time. After this time is due, the rule will be automatically set to the status "suspended". The format is "2020-07-23 00:00:00". It is required.
        :type Expire: str
        :param _StartTime: Periodic rule start time.
        :type StartTime: str
        """
        self._RepeatType = None
        self._DayRepeat = None
        self._WeekRepeat = None
        self._MonthRepeat = None
        self._NotRepeat = None
        self._Expire = None
        self._StartTime = None

    @property
    def RepeatType(self):
        r"""The valid values DAY, DOW, DOM, and NONE respectively indicate repetition by day, repetition by week, repetition by month, and one-time execution. This parameter is required.
        :rtype: str
        """
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType

    @property
    def DayRepeat(self):
        r"""Daily repetition rule, which is effective when RepeatType is set to DAY

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.DayRepeatStrategy`
        """
        return self._DayRepeat

    @DayRepeat.setter
    def DayRepeat(self, DayRepeat):
        self._DayRepeat = DayRepeat

    @property
    def WeekRepeat(self):
        r"""Weekly repetition rule, effective when RepeatType is DOW

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.WeekRepeatStrategy`
        """
        return self._WeekRepeat

    @WeekRepeat.setter
    def WeekRepeat(self, WeekRepeat):
        self._WeekRepeat = WeekRepeat

    @property
    def MonthRepeat(self):
        r"""Monthly repetition rule, valid when RepeatType is DOM

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.MonthRepeatStrategy`
        """
        return self._MonthRepeat

    @MonthRepeat.setter
    def MonthRepeat(self, MonthRepeat):
        self._MonthRepeat = MonthRepeat

    @property
    def NotRepeat(self):
        r"""One-time execution rule, valid when RepeatType is NONE

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NotRepeatStrategy`
        """
        return self._NotRepeat

    @NotRepeat.setter
    def NotRepeat(self, NotRepeat):
        self._NotRepeat = NotRepeat

    @property
    def Expire(self):
        r"""Rule expiration time. After this time is due, the rule will be automatically set to the status "suspended". The format is "2020-07-23 00:00:00". It is required.
        :rtype: str
        """
        return self._Expire

    @Expire.setter
    def Expire(self, Expire):
        self._Expire = Expire

    @property
    def StartTime(self):
        r"""Periodic rule start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime


    def _deserialize(self, params):
        self._RepeatType = params.get("RepeatType")
        if params.get("DayRepeat") is not None:
            self._DayRepeat = DayRepeatStrategy()
            self._DayRepeat._deserialize(params.get("DayRepeat"))
        if params.get("WeekRepeat") is not None:
            self._WeekRepeat = WeekRepeatStrategy()
            self._WeekRepeat._deserialize(params.get("WeekRepeat"))
        if params.get("MonthRepeat") is not None:
            self._MonthRepeat = MonthRepeatStrategy()
            self._MonthRepeat._deserialize(params.get("MonthRepeat"))
        if params.get("NotRepeat") is not None:
            self._NotRepeat = NotRepeatStrategy()
            self._NotRepeat._deserialize(params.get("NotRepeat"))
        self._Expire = params.get("Expire")
        self._StartTime = params.get("StartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetYarnConfigRequest(AbstractModel):
    r"""ResetYarnConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: English ID of the EMR cluster.
        :type InstanceId: str
        :param _Key: Alias of the configuration to be reset. The options are as follows:

- capacityLabel: Reset the tag management configuration.
- fair: Reset the fair scheduling configuration.
- capacity: Reset the capacity scheduling configuration.
        :type Key: str
        """
        self._InstanceId = None
        self._Key = None

    @property
    def InstanceId(self):
        r"""English ID of the EMR cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Key(self):
        r"""Alias of the configuration to be reset. The options are as follows:

- capacityLabel: Reset the tag management configuration.
- fair: Reset the fair scheduling configuration.
- capacity: Reset the capacity scheduling configuration.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Key = params.get("Key")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetYarnConfigResponse(AbstractModel):
    r"""ResetYarnConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResizeDataDisksRequest(AbstractModel):
    r"""ResizeDataDisks request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of the EMR cluster instance.
        :type InstanceId: str
        :param _DiskSize: Scale-out value, which should be greater than the original capacity and a multiple of 10.
        :type DiskSize: int
        :param _CvmInstanceIds: ID list of nodes to be scaled out.
        :type CvmInstanceIds: list of str
        :param _DiskIds: ID of the cloud disk to be scaled out.
        :type DiskIds: list of str
        :param _ResizeAll: Whether to scale out all cloud disks.
        :type ResizeAll: bool
        """
        self._InstanceId = None
        self._DiskSize = None
        self._CvmInstanceIds = None
        self._DiskIds = None
        self._ResizeAll = None

    @property
    def InstanceId(self):
        r"""ID of the EMR cluster instance.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DiskSize(self):
        r"""Scale-out value, which should be greater than the original capacity and a multiple of 10.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def CvmInstanceIds(self):
        r"""ID list of nodes to be scaled out.
        :rtype: list of str
        """
        return self._CvmInstanceIds

    @CvmInstanceIds.setter
    def CvmInstanceIds(self, CvmInstanceIds):
        self._CvmInstanceIds = CvmInstanceIds

    @property
    def DiskIds(self):
        r"""ID of the cloud disk to be scaled out.
        :rtype: list of str
        """
        return self._DiskIds

    @DiskIds.setter
    def DiskIds(self, DiskIds):
        self._DiskIds = DiskIds

    @property
    def ResizeAll(self):
        r"""Whether to scale out all cloud disks.
        :rtype: bool
        """
        return self._ResizeAll

    @ResizeAll.setter
    def ResizeAll(self, ResizeAll):
        self._ResizeAll = ResizeAll


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DiskSize = params.get("DiskSize")
        self._CvmInstanceIds = params.get("CvmInstanceIds")
        self._DiskIds = params.get("DiskIds")
        self._ResizeAll = params.get("ResizeAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResizeDataDisksResponse(AbstractModel):
    r"""ResizeDataDisks response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Flow ID.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Flow ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class Resource(AbstractModel):
    r"""Resource details

    """

    def __init__(self):
        r"""
        :param _Spec: Node specifications description, such as CVM.SA2.
        :type Spec: str
        :param _StorageType: Storage type.
Valid values:
<li>4: Cloud SSD.</li>
<li>5: Premium Cloud Disk.</li>
<li>6: Enhanced SSD.</li>
<li>11: Throughput HDD.</li>
<li>12: Tremendous SSD.</li>: this type is invalid upon creation, and automatic judgment will be conducted based on data disk type and node type.
        :type StorageType: int
        :param _DiskType: Disk type.
Valid values.
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_BASIC: Cloud Disk.</li>
        :type DiskType: str
        :param _MemSize: Memory capacity, in MB.
        :type MemSize: int
        :param _Cpu: Number of CPU cores.
        :type Cpu: int
        :param _DiskSize: Data disk capacity.
        :type DiskSize: int
        :param _RootSize: System disk capacity.
        :type RootSize: int
        :param _MultiDisks: List of cloud disks. When the data disk is a cloud disk, `DiskType` and `DiskSize` are used directly; `MultiDisks` will be used for the excessive part
Note: this field may return null, indicating that no valid values can be obtained.
        :type MultiDisks: list of MultiDisk
        :param _Tags: List of tags to be bound
Note: this field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _InstanceType: Specifications type, such as S2.MEDIUM8.
        :type InstanceType: str
        :param _LocalDiskNum: Number of local disks. This field is deprecated.
        :type LocalDiskNum: int
        :param _DiskNum: Number of local disks, such as 2.
        :type DiskNum: int
        :param _GpuDesc: GPU information.
        :type GpuDesc: str
        """
        self._Spec = None
        self._StorageType = None
        self._DiskType = None
        self._MemSize = None
        self._Cpu = None
        self._DiskSize = None
        self._RootSize = None
        self._MultiDisks = None
        self._Tags = None
        self._InstanceType = None
        self._LocalDiskNum = None
        self._DiskNum = None
        self._GpuDesc = None

    @property
    def Spec(self):
        r"""Node specifications description, such as CVM.SA2.
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def StorageType(self):
        r"""Storage type.
Valid values:
<li>4: Cloud SSD.</li>
<li>5: Premium Cloud Disk.</li>
<li>6: Enhanced SSD.</li>
<li>11: Throughput HDD.</li>
<li>12: Tremendous SSD.</li>: this type is invalid upon creation, and automatic judgment will be conducted based on data disk type and node type.
        :rtype: int
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def DiskType(self):
        r"""Disk type.
Valid values.
<li>CLOUD_SSD: Cloud SSD.</li>
<li>CLOUD_PREMIUM: Premium Cloud Disk.</li>
<li>CLOUD_BASIC: Cloud Disk.</li>
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def MemSize(self):
        r"""Memory capacity, in MB.
        :rtype: int
        """
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def Cpu(self):
        r"""Number of CPU cores.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def DiskSize(self):
        r"""Data disk capacity.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def RootSize(self):
        r"""System disk capacity.
        :rtype: int
        """
        return self._RootSize

    @RootSize.setter
    def RootSize(self, RootSize):
        self._RootSize = RootSize

    @property
    def MultiDisks(self):
        r"""List of cloud disks. When the data disk is a cloud disk, `DiskType` and `DiskSize` are used directly; `MultiDisks` will be used for the excessive part
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of MultiDisk
        """
        return self._MultiDisks

    @MultiDisks.setter
    def MultiDisks(self, MultiDisks):
        self._MultiDisks = MultiDisks

    @property
    def Tags(self):
        r"""List of tags to be bound
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def InstanceType(self):
        r"""Specifications type, such as S2.MEDIUM8.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def LocalDiskNum(self):
        r"""Number of local disks. This field is deprecated.
        :rtype: int
        """
        return self._LocalDiskNum

    @LocalDiskNum.setter
    def LocalDiskNum(self, LocalDiskNum):
        self._LocalDiskNum = LocalDiskNum

    @property
    def DiskNum(self):
        r"""Number of local disks, such as 2.
        :rtype: int
        """
        return self._DiskNum

    @DiskNum.setter
    def DiskNum(self, DiskNum):
        self._DiskNum = DiskNum

    @property
    def GpuDesc(self):
        r"""GPU information.
        :rtype: str
        """
        return self._GpuDesc

    @GpuDesc.setter
    def GpuDesc(self, GpuDesc):
        self._GpuDesc = GpuDesc


    def _deserialize(self, params):
        self._Spec = params.get("Spec")
        self._StorageType = params.get("StorageType")
        self._DiskType = params.get("DiskType")
        self._MemSize = params.get("MemSize")
        self._Cpu = params.get("Cpu")
        self._DiskSize = params.get("DiskSize")
        self._RootSize = params.get("RootSize")
        if params.get("MultiDisks") is not None:
            self._MultiDisks = []
            for item in params.get("MultiDisks"):
                obj = MultiDisk()
                obj._deserialize(item)
                self._MultiDisks.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._InstanceType = params.get("InstanceType")
        self._LocalDiskNum = params.get("LocalDiskNum")
        self._DiskNum = params.get("DiskNum")
        self._GpuDesc = params.get("GpuDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceDetail(AbstractModel):
    r"""Resource details.

    """

    def __init__(self):
        r"""
        :param _Spec: Specifications.
        :type Spec: str
        :param _SpecName: Specifications name.
        :type SpecName: str
        :param _StorageType: Hard disk type.
        :type StorageType: int
        :param _DiskType: Hard disk type.
        :type DiskType: str
        :param _RootSize: System disk size.
        :type RootSize: int
        :param _MemSize: Memory size.
        :type MemSize: int
        :param _Cpu: Number of CPUs.
        :type Cpu: int
        :param _DiskSize: Hard disk size.
        :type DiskSize: int
        :param _InstanceType: Specifications.
        :type InstanceType: str
        """
        self._Spec = None
        self._SpecName = None
        self._StorageType = None
        self._DiskType = None
        self._RootSize = None
        self._MemSize = None
        self._Cpu = None
        self._DiskSize = None
        self._InstanceType = None

    @property
    def Spec(self):
        r"""Specifications.
        :rtype: str
        """
        return self._Spec

    @Spec.setter
    def Spec(self, Spec):
        self._Spec = Spec

    @property
    def SpecName(self):
        r"""Specifications name.
        :rtype: str
        """
        return self._SpecName

    @SpecName.setter
    def SpecName(self, SpecName):
        self._SpecName = SpecName

    @property
    def StorageType(self):
        r"""Hard disk type.
        :rtype: int
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def DiskType(self):
        r"""Hard disk type.
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def RootSize(self):
        r"""System disk size.
        :rtype: int
        """
        return self._RootSize

    @RootSize.setter
    def RootSize(self, RootSize):
        self._RootSize = RootSize

    @property
    def MemSize(self):
        r"""Memory size.
        :rtype: int
        """
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def Cpu(self):
        r"""Number of CPUs.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def DiskSize(self):
        r"""Hard disk size.
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def InstanceType(self):
        r"""Specifications.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType


    def _deserialize(self, params):
        self._Spec = params.get("Spec")
        self._SpecName = params.get("SpecName")
        self._StorageType = params.get("StorageType")
        self._DiskType = params.get("DiskType")
        self._RootSize = params.get("RootSize")
        self._MemSize = params.get("MemSize")
        self._Cpu = params.get("Cpu")
        self._DiskSize = params.get("DiskSize")
        self._InstanceType = params.get("InstanceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartPolicy(AbstractModel):
    r"""Component restart policy

    """

    def __init__(self):
        r"""
        :param _Name: Restart policy name
        :type Name: str
        :param _DisplayName: Policy display name
        :type DisplayName: str
        :param _Describe: Policy description
        :type Describe: str
        :param _BatchSizeRange: Optional range for the number of batch restarted nodes
        :type BatchSizeRange: list of int
        :param _IsDefault: Whether it is the default policy
        :type IsDefault: str
        """
        self._Name = None
        self._DisplayName = None
        self._Describe = None
        self._BatchSizeRange = None
        self._IsDefault = None

    @property
    def Name(self):
        r"""Restart policy name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisplayName(self):
        r"""Policy display name
        :rtype: str
        """
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Describe(self):
        r"""Policy description
        :rtype: str
        """
        return self._Describe

    @Describe.setter
    def Describe(self, Describe):
        self._Describe = Describe

    @property
    def BatchSizeRange(self):
        r"""Optional range for the number of batch restarted nodes
        :rtype: list of int
        """
        return self._BatchSizeRange

    @BatchSizeRange.setter
    def BatchSizeRange(self, BatchSizeRange):
        self._BatchSizeRange = BatchSizeRange

    @property
    def IsDefault(self):
        r"""Whether it is the default policy
        :rtype: str
        """
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DisplayName = params.get("DisplayName")
        self._Describe = params.get("Describe")
        self._BatchSizeRange = params.get("BatchSizeRange")
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResultItem(AbstractModel):
    r"""Output results of user groups.

    """

    def __init__(self):
        r"""
        :param _Item: User group name.
        :type Item: str
        :param _Result: Whether the user group is created successfully.
        :type Result: bool
        :param _Reason: Specify the reason for the failure in the case of creation failure.
        :type Reason: str
        """
        self._Item = None
        self._Result = None
        self._Reason = None

    @property
    def Item(self):
        r"""User group name.
        :rtype: str
        """
        return self._Item

    @Item.setter
    def Item(self, Item):
        self._Item = Item

    @property
    def Result(self):
        r"""Whether the user group is created successfully.
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Reason(self):
        r"""Specify the reason for the failure in the case of creation failure.
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason


    def _deserialize(self, params):
        self._Item = params.get("Item")
        self._Result = params.get("Result")
        self._Reason = params.get("Reason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SLInstance(AbstractModel):
    r"""Serverless Instance

    """

    def __init__(self):
        r"""
        :param _InstanceId: EMR Instance Id
        :type InstanceId: str
        :param _ClusterId: EMR Numeric Instance Id
        :type ClusterId: int
        :param _InstanceName: Instance Name
        :type InstanceName: str
        :param _RegionId: Region id
        :type RegionId: int
        :param _Zone: Zone Name
        :type Zone: str
        :param _PayMode: Pay Mode
        :type PayMode: int
        :param _DiskType: Disk Type
        :type DiskType: str
        :param _DiskSize: Disk Size
        :type DiskSize: int
        :param _NodeType: Node Type
        :type NodeType: str
        :param _NodeNum: Node Number
        :type NodeNum: int
        :param _ExpireTime: Expire Time
        :type ExpireTime: str
        :param _IsolateTime: Isolate Time
        :type IsolateTime: str
        :param _CreateTime: Create Time
        :type CreateTime: str
        :param _AutoRenewFlag: Auto Renew Flag
        :type AutoRenewFlag: int
        :param _Status: EMR Numeric Instance Status
        :type Status: int
        :param _ZoneSettings: Zone Setting
        :type ZoneSettings: list of ZoneSetting
        :param _Tags: Bound Tags
        :type Tags: list of Tag
        :param _DeployRole: Deploy Role
        :type DeployRole: str
        """
        self._InstanceId = None
        self._ClusterId = None
        self._InstanceName = None
        self._RegionId = None
        self._Zone = None
        self._PayMode = None
        self._DiskType = None
        self._DiskSize = None
        self._NodeType = None
        self._NodeNum = None
        self._ExpireTime = None
        self._IsolateTime = None
        self._CreateTime = None
        self._AutoRenewFlag = None
        self._Status = None
        self._ZoneSettings = None
        self._Tags = None
        self._DeployRole = None

    @property
    def InstanceId(self):
        r"""EMR Instance Id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterId(self):
        r"""EMR Numeric Instance Id
        :rtype: int
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceName(self):
        r"""Instance Name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def RegionId(self):
        r"""Region id
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def Zone(self):
        r"""Zone Name
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def PayMode(self):
        r"""Pay Mode
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def DiskType(self):
        r"""Disk Type
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def DiskSize(self):
        r"""Disk Size
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def NodeType(self):
        r"""Node Type
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeNum(self):
        r"""Node Number
        :rtype: int
        """
        return self._NodeNum

    @NodeNum.setter
    def NodeNum(self, NodeNum):
        self._NodeNum = NodeNum

    @property
    def ExpireTime(self):
        r"""Expire Time
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def IsolateTime(self):
        r"""Isolate Time
        :rtype: str
        """
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def CreateTime(self):
        r"""Create Time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def AutoRenewFlag(self):
        r"""Auto Renew Flag
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def Status(self):
        r"""EMR Numeric Instance Status
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ZoneSettings(self):
        r"""Zone Setting
        :rtype: list of ZoneSetting
        """
        return self._ZoneSettings

    @ZoneSettings.setter
    def ZoneSettings(self, ZoneSettings):
        self._ZoneSettings = ZoneSettings

    @property
    def Tags(self):
        r"""Bound Tags
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DeployRole(self):
        r"""Deploy Role
        :rtype: str
        """
        return self._DeployRole

    @DeployRole.setter
    def DeployRole(self, DeployRole):
        self._DeployRole = DeployRole


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterId = params.get("ClusterId")
        self._InstanceName = params.get("InstanceName")
        self._RegionId = params.get("RegionId")
        self._Zone = params.get("Zone")
        self._PayMode = params.get("PayMode")
        self._DiskType = params.get("DiskType")
        self._DiskSize = params.get("DiskSize")
        self._NodeType = params.get("NodeType")
        self._NodeNum = params.get("NodeNum")
        self._ExpireTime = params.get("ExpireTime")
        self._IsolateTime = params.get("IsolateTime")
        self._CreateTime = params.get("CreateTime")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._Status = params.get("Status")
        if params.get("ZoneSettings") is not None:
            self._ZoneSettings = []
            for item in params.get("ZoneSettings"):
                obj = ZoneSetting()
                obj._deserialize(item)
                self._ZoneSettings.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._DeployRole = params.get("DeployRole")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SLInstanceInfo(AbstractModel):
    r"""Serverless HBase instance information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Instance string ID.
        :type ClusterId: str
        :param _Id: Instance numeric ID
        :type Id: int
        :param _StatusDesc: Status description.
        :type StatusDesc: str
        :param _HealthStatus: Health status.
        :type HealthStatus: str
        :param _ClusterName: Instance name
        :type ClusterName: str
        :param _RegionId: Region ID
        :type RegionId: int
        :param _ZoneId: Primary AZ ID.
        :type ZoneId: int
        :param _Zone: Primary AZ.
        :type Zone: str
        :param _AppId: User APP ID.
        :type AppId: int
        :param _VpcId: Primary AZ VPC ID.
        :type VpcId: int
        :param _SubnetId: Primary AZ subnet ID.
        :type SubnetId: int
        :param _Status: Status code
        :type Status: int
        :param _AddTime: Creation time.
        :type AddTime: str
        :param _PayMode: Cluster billing type. 0 indicates pay-as-you-go. 1 indicates monthly subscription.
        :type PayMode: int
        :param _ZoneSettings: Multi-AZ information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ZoneSettings: list of ZoneSetting
        :param _Tags: Instance tag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        :param _AutoRenewFlag: Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is set to 0.
        :type AutoRenewFlag: int
        :param _IsolateTime: Isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
        :type IsolateTime: str
        :param _ExpireTime: Expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
        :type ExpireTime: str
        """
        self._ClusterId = None
        self._Id = None
        self._StatusDesc = None
        self._HealthStatus = None
        self._ClusterName = None
        self._RegionId = None
        self._ZoneId = None
        self._Zone = None
        self._AppId = None
        self._VpcId = None
        self._SubnetId = None
        self._Status = None
        self._AddTime = None
        self._PayMode = None
        self._ZoneSettings = None
        self._Tags = None
        self._AutoRenewFlag = None
        self._IsolateTime = None
        self._ExpireTime = None

    @property
    def ClusterId(self):
        r"""Instance string ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        r"""Instance numeric ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def StatusDesc(self):
        r"""Status description.
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def HealthStatus(self):
        r"""Health status.
        :rtype: str
        """
        return self._HealthStatus

    @HealthStatus.setter
    def HealthStatus(self, HealthStatus):
        self._HealthStatus = HealthStatus

    @property
    def ClusterName(self):
        r"""Instance name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def RegionId(self):
        r"""Region ID
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def ZoneId(self):
        r"""Primary AZ ID.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def Zone(self):
        r"""Primary AZ.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def AppId(self):
        r"""User APP ID.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def VpcId(self):
        r"""Primary AZ VPC ID.
        :rtype: int
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Primary AZ subnet ID.
        :rtype: int
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Status(self):
        r"""Status code
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AddTime(self):
        r"""Creation time.
        :rtype: str
        """
        return self._AddTime

    @AddTime.setter
    def AddTime(self, AddTime):
        self._AddTime = AddTime

    @property
    def PayMode(self):
        r"""Cluster billing type. 0 indicates pay-as-you-go. 1 indicates monthly subscription.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ZoneSettings(self):
        r"""Multi-AZ information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ZoneSetting
        """
        return self._ZoneSettings

    @ZoneSettings.setter
    def ZoneSettings(self, ZoneSettings):
        self._ZoneSettings = ZoneSettings

    @property
    def Tags(self):
        r"""Instance tag.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AutoRenewFlag(self):
        r"""Auto-renewal flag. 0: notify before expiration but do not auto-renew; 1: notify before expiration and auto-renew; and 2: do not notify before expiration and do not auto-renew. If the business does not support renewal, the value is set to 0.
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def IsolateTime(self):
        r"""Isolation time. For instances that are not isolated, the API returns 0000-00-00 00:00:00.
        :rtype: str
        """
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def ExpireTime(self):
        r"""Expiration time. For post-paid instances, the API returns 0000-00-00 00:00:00.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        self._StatusDesc = params.get("StatusDesc")
        self._HealthStatus = params.get("HealthStatus")
        self._ClusterName = params.get("ClusterName")
        self._RegionId = params.get("RegionId")
        self._ZoneId = params.get("ZoneId")
        self._Zone = params.get("Zone")
        self._AppId = params.get("AppId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Status = params.get("Status")
        self._AddTime = params.get("AddTime")
        self._PayMode = params.get("PayMode")
        if params.get("ZoneSettings") is not None:
            self._ZoneSettings = []
            for item in params.get("ZoneSettings"):
                obj = ZoneSetting()
                obj._deserialize(item)
                self._ZoneSettings.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._IsolateTime = params.get("IsolateTime")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScaleOutClusterRequest(AbstractModel):
    r"""ScaleOutCluster request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceChargeType: The node billing mode. Valid values:
<li>`POSTPAID_BY_HOUR`: The postpaid mode by hour.</li>
<li>`SPOTPAID`: The spot instance mode (for task nodes only).</li>
        :type InstanceChargeType: str
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ScaleOutNodeConfig: Scale-up node type and quantity.
        :type ScaleOutNodeConfig: :class:`tencentcloud.emr.v20190103.models.ScaleOutNodeConfig`
        :param _ClientToken: Unique random identifier with the time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources again, for example, a9a90aa6-****-****-****-fae36063280.
        :type ClientToken: str
        :param _InstanceChargePrepaid: Setting of parameters related to monthly subscription. Through this parameter, you can specify the duration of purchase for monthly subscription instances, whether to set auto-renewal, and other attributes. This parameter is required when the specified instance is subject to the payment mode of prepaid.
        :type InstanceChargePrepaid: :class:`tencentcloud.emr.v20190103.models.InstanceChargePrepaid`
        :param _ScriptBootstrapActionConfig: [Bootstrap Actions](https://www.tencentcloud.comom/document/product/589/35656?from_cn_redirect=1) script settings.
        :type ScriptBootstrapActionConfig: list of ScriptBootstrapActionConfig
        :param _SoftDeployInfo: Scale-out deployment service. New nodes inherit services deployed in the current node type by default, including default optional services. This parameter only supports optional service filling, for example: HDFS, YARN, and Impala have been deployed to existing task nodes. When API is used to scale out the task nodes without deploying Impala, only HDFS and YARN are filled for deployment services. For more details, see [Mapping Table of Component Names](https://www.tencentcloud.comom/document/product/589/98760?from_cn_redirect=1).
        :type SoftDeployInfo: list of int
        :param _ServiceNodeInfo: Deployment process. By default, all scale-out service processes are deployed. Deployment processes can be modified. For example, HDFS, YARN, or Impala has been deployed for the current Task node. The default deployment services include DataNode,NodeManager,ImpalaServer. If users need to modify deployment process information, the deployment process can be DataNode, NodeManager, ImpalaServerCoordinator or DataNode, NodeManager, ImpalaServerExecutor. For more details, see [Mapping Table of Process Names](https://www.tencentcloud.comom/document/product/589/98760?from_cn_redirect=1).
        :type ServiceNodeInfo: list of int
        :param _DisasterRecoverGroupIds: Spread placement group ID list. Only one can be specified currently.
This parameter can be obtained by calling the DisasterRecoverGroupId field in the return value of the [DescribeDisasterRecoverGroups](https://www.tencentcloud.comom/document/product/213/17810?from_cn_redirect=1) API.
        :type DisasterRecoverGroupIds: list of str
        :param _Tags: List of tags bound to scale-out nodes.
        :type Tags: list of Tag
        :param _HardwareSourceType: Resource type selected for scale-out with valid values "HOST","POD","MNode", where HOST indicates an ordinary CVM resource, POD indicates a resource provided by the TKE cluster or EKS cluster, and MNode indicates a fully managed resource type.
        :type HardwareSourceType: str
        :param _PodSpecInfo: Pod-related resource information.
        :type PodSpecInfo: :class:`tencentcloud.emr.v20190103.models.PodSpecInfo`
        :param _ClickHouseClusterName: Machine group name selected for ClickHouse cluster scale-out.
        :type ClickHouseClusterName: str
        :param _ClickHouseClusterType: Machine group type selected for ClickHouse cluster scale-out. "New" indicates creating a group type, and "old" indicates using an existing group type.
        :type ClickHouseClusterType: str
        :param _YarnNodeLabel: Specified Yarn Node Label for scale-out.
        :type YarnNodeLabel: str
        :param _EnableStartServiceFlag: Whether to start a service after scale-out (default: false).
<li>true: yes</li>.
<li>false: no</li>.
        :type EnableStartServiceFlag: bool
        :param _ResourceSpec: Specifications settings.
        :type ResourceSpec: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        :param _Zone: Availability zone of the instance, such as ap-guangzhou-1. This parameter can also be obtained from the Zone field in the return value of [DescribeZones](https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1).
        :type Zone: str
        :param _SubnetId: Subnet, which is the subnet at the time of cluster creation by default.
        :type SubnetId: str
        :param _ScaleOutServiceConfGroupsInfo: Configuration group specified for scale-out.
        :type ScaleOutServiceConfGroupsInfo: list of ScaleOutServiceConfGroupsInfo
        :param _NodeMarks: Node tag information: currently used only in Terraform.
        :type NodeMarks: :class:`tencentcloud.emr.v20190103.models.NodeMark`
        """
        self._InstanceChargeType = None
        self._InstanceId = None
        self._ScaleOutNodeConfig = None
        self._ClientToken = None
        self._InstanceChargePrepaid = None
        self._ScriptBootstrapActionConfig = None
        self._SoftDeployInfo = None
        self._ServiceNodeInfo = None
        self._DisasterRecoverGroupIds = None
        self._Tags = None
        self._HardwareSourceType = None
        self._PodSpecInfo = None
        self._ClickHouseClusterName = None
        self._ClickHouseClusterType = None
        self._YarnNodeLabel = None
        self._EnableStartServiceFlag = None
        self._ResourceSpec = None
        self._Zone = None
        self._SubnetId = None
        self._ScaleOutServiceConfGroupsInfo = None
        self._NodeMarks = None

    @property
    def InstanceChargeType(self):
        r"""The node billing mode. Valid values:
<li>`POSTPAID_BY_HOUR`: The postpaid mode by hour.</li>
<li>`SPOTPAID`: The spot instance mode (for task nodes only).</li>
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ScaleOutNodeConfig(self):
        r"""Scale-up node type and quantity.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ScaleOutNodeConfig`
        """
        return self._ScaleOutNodeConfig

    @ScaleOutNodeConfig.setter
    def ScaleOutNodeConfig(self, ScaleOutNodeConfig):
        self._ScaleOutNodeConfig = ScaleOutNodeConfig

    @property
    def ClientToken(self):
        r"""Unique random identifier with the time efficiency of 5 minutes, which needs to be specified by the caller to prevent the client from creating resources again, for example, a9a90aa6-****-****-****-fae36063280.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def InstanceChargePrepaid(self):
        r"""Setting of parameters related to monthly subscription. Through this parameter, you can specify the duration of purchase for monthly subscription instances, whether to set auto-renewal, and other attributes. This parameter is required when the specified instance is subject to the payment mode of prepaid.
        :rtype: :class:`tencentcloud.emr.v20190103.models.InstanceChargePrepaid`
        """
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid

    @property
    def ScriptBootstrapActionConfig(self):
        r"""[Bootstrap Actions](https://www.tencentcloud.comom/document/product/589/35656?from_cn_redirect=1) script settings.
        :rtype: list of ScriptBootstrapActionConfig
        """
        return self._ScriptBootstrapActionConfig

    @ScriptBootstrapActionConfig.setter
    def ScriptBootstrapActionConfig(self, ScriptBootstrapActionConfig):
        self._ScriptBootstrapActionConfig = ScriptBootstrapActionConfig

    @property
    def SoftDeployInfo(self):
        r"""Scale-out deployment service. New nodes inherit services deployed in the current node type by default, including default optional services. This parameter only supports optional service filling, for example: HDFS, YARN, and Impala have been deployed to existing task nodes. When API is used to scale out the task nodes without deploying Impala, only HDFS and YARN are filled for deployment services. For more details, see [Mapping Table of Component Names](https://www.tencentcloud.comom/document/product/589/98760?from_cn_redirect=1).
        :rtype: list of int
        """
        return self._SoftDeployInfo

    @SoftDeployInfo.setter
    def SoftDeployInfo(self, SoftDeployInfo):
        self._SoftDeployInfo = SoftDeployInfo

    @property
    def ServiceNodeInfo(self):
        r"""Deployment process. By default, all scale-out service processes are deployed. Deployment processes can be modified. For example, HDFS, YARN, or Impala has been deployed for the current Task node. The default deployment services include DataNode,NodeManager,ImpalaServer. If users need to modify deployment process information, the deployment process can be DataNode, NodeManager, ImpalaServerCoordinator or DataNode, NodeManager, ImpalaServerExecutor. For more details, see [Mapping Table of Process Names](https://www.tencentcloud.comom/document/product/589/98760?from_cn_redirect=1).
        :rtype: list of int
        """
        return self._ServiceNodeInfo

    @ServiceNodeInfo.setter
    def ServiceNodeInfo(self, ServiceNodeInfo):
        self._ServiceNodeInfo = ServiceNodeInfo

    @property
    def DisasterRecoverGroupIds(self):
        r"""Spread placement group ID list. Only one can be specified currently.
This parameter can be obtained by calling the DisasterRecoverGroupId field in the return value of the [DescribeDisasterRecoverGroups](https://www.tencentcloud.comom/document/product/213/17810?from_cn_redirect=1) API.
        :rtype: list of str
        """
        return self._DisasterRecoverGroupIds

    @DisasterRecoverGroupIds.setter
    def DisasterRecoverGroupIds(self, DisasterRecoverGroupIds):
        self._DisasterRecoverGroupIds = DisasterRecoverGroupIds

    @property
    def Tags(self):
        r"""List of tags bound to scale-out nodes.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def HardwareSourceType(self):
        r"""Resource type selected for scale-out with valid values "HOST","POD","MNode", where HOST indicates an ordinary CVM resource, POD indicates a resource provided by the TKE cluster or EKS cluster, and MNode indicates a fully managed resource type.
        :rtype: str
        """
        return self._HardwareSourceType

    @HardwareSourceType.setter
    def HardwareSourceType(self, HardwareSourceType):
        self._HardwareSourceType = HardwareSourceType

    @property
    def PodSpecInfo(self):
        r"""Pod-related resource information.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PodSpecInfo`
        """
        return self._PodSpecInfo

    @PodSpecInfo.setter
    def PodSpecInfo(self, PodSpecInfo):
        self._PodSpecInfo = PodSpecInfo

    @property
    def ClickHouseClusterName(self):
        r"""Machine group name selected for ClickHouse cluster scale-out.
        :rtype: str
        """
        return self._ClickHouseClusterName

    @ClickHouseClusterName.setter
    def ClickHouseClusterName(self, ClickHouseClusterName):
        self._ClickHouseClusterName = ClickHouseClusterName

    @property
    def ClickHouseClusterType(self):
        r"""Machine group type selected for ClickHouse cluster scale-out. "New" indicates creating a group type, and "old" indicates using an existing group type.
        :rtype: str
        """
        return self._ClickHouseClusterType

    @ClickHouseClusterType.setter
    def ClickHouseClusterType(self, ClickHouseClusterType):
        self._ClickHouseClusterType = ClickHouseClusterType

    @property
    def YarnNodeLabel(self):
        r"""Specified Yarn Node Label for scale-out.
        :rtype: str
        """
        return self._YarnNodeLabel

    @YarnNodeLabel.setter
    def YarnNodeLabel(self, YarnNodeLabel):
        self._YarnNodeLabel = YarnNodeLabel

    @property
    def EnableStartServiceFlag(self):
        r"""Whether to start a service after scale-out (default: false).
<li>true: yes</li>.
<li>false: no</li>.
        :rtype: bool
        """
        return self._EnableStartServiceFlag

    @EnableStartServiceFlag.setter
    def EnableStartServiceFlag(self, EnableStartServiceFlag):
        self._EnableStartServiceFlag = EnableStartServiceFlag

    @property
    def ResourceSpec(self):
        r"""Specifications settings.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeResourceSpec`
        """
        return self._ResourceSpec

    @ResourceSpec.setter
    def ResourceSpec(self, ResourceSpec):
        self._ResourceSpec = ResourceSpec

    @property
    def Zone(self):
        r"""Availability zone of the instance, such as ap-guangzhou-1. This parameter can also be obtained from the Zone field in the return value of [DescribeZones](https://www.tencentcloud.comom/document/product/213/15707?from_cn_redirect=1).
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def SubnetId(self):
        r"""Subnet, which is the subnet at the time of cluster creation by default.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ScaleOutServiceConfGroupsInfo(self):
        r"""Configuration group specified for scale-out.
        :rtype: list of ScaleOutServiceConfGroupsInfo
        """
        return self._ScaleOutServiceConfGroupsInfo

    @ScaleOutServiceConfGroupsInfo.setter
    def ScaleOutServiceConfGroupsInfo(self, ScaleOutServiceConfGroupsInfo):
        self._ScaleOutServiceConfGroupsInfo = ScaleOutServiceConfGroupsInfo

    @property
    def NodeMarks(self):
        r"""Node tag information: currently used only in Terraform.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeMark`
        """
        return self._NodeMarks

    @NodeMarks.setter
    def NodeMarks(self, NodeMarks):
        self._NodeMarks = NodeMarks


    def _deserialize(self, params):
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._InstanceId = params.get("InstanceId")
        if params.get("ScaleOutNodeConfig") is not None:
            self._ScaleOutNodeConfig = ScaleOutNodeConfig()
            self._ScaleOutNodeConfig._deserialize(params.get("ScaleOutNodeConfig"))
        self._ClientToken = params.get("ClientToken")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        if params.get("ScriptBootstrapActionConfig") is not None:
            self._ScriptBootstrapActionConfig = []
            for item in params.get("ScriptBootstrapActionConfig"):
                obj = ScriptBootstrapActionConfig()
                obj._deserialize(item)
                self._ScriptBootstrapActionConfig.append(obj)
        self._SoftDeployInfo = params.get("SoftDeployInfo")
        self._ServiceNodeInfo = params.get("ServiceNodeInfo")
        self._DisasterRecoverGroupIds = params.get("DisasterRecoverGroupIds")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._HardwareSourceType = params.get("HardwareSourceType")
        if params.get("PodSpecInfo") is not None:
            self._PodSpecInfo = PodSpecInfo()
            self._PodSpecInfo._deserialize(params.get("PodSpecInfo"))
        self._ClickHouseClusterName = params.get("ClickHouseClusterName")
        self._ClickHouseClusterType = params.get("ClickHouseClusterType")
        self._YarnNodeLabel = params.get("YarnNodeLabel")
        self._EnableStartServiceFlag = params.get("EnableStartServiceFlag")
        if params.get("ResourceSpec") is not None:
            self._ResourceSpec = NodeResourceSpec()
            self._ResourceSpec._deserialize(params.get("ResourceSpec"))
        self._Zone = params.get("Zone")
        self._SubnetId = params.get("SubnetId")
        if params.get("ScaleOutServiceConfGroupsInfo") is not None:
            self._ScaleOutServiceConfGroupsInfo = []
            for item in params.get("ScaleOutServiceConfGroupsInfo"):
                obj = ScaleOutServiceConfGroupsInfo()
                obj._deserialize(item)
                self._ScaleOutServiceConfGroupsInfo.append(obj)
        if params.get("NodeMarks") is not None:
            self._NodeMarks = NodeMark()
            self._NodeMarks._deserialize(params.get("NodeMarks"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScaleOutClusterResponse(AbstractModel):
    r"""ScaleOutCluster response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _ClientToken: Client token.
        :type ClientToken: str
        :param _FlowId: Scale-out process ID.
        :type FlowId: int
        :param _TraceId: Query process status and additional flow formation.
        :type TraceId: str
        :param _DealNames: Order number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DealNames: list of str
        :param _BillId: Large order number.
        :type BillId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._ClientToken = None
        self._FlowId = None
        self._TraceId = None
        self._DealNames = None
        self._BillId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClientToken(self):
        r"""Client token.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def FlowId(self):
        r"""Scale-out process ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TraceId(self):
        r"""Query process status and additional flow formation.
        :rtype: str
        """
        return self._TraceId

    @TraceId.setter
    def TraceId(self, TraceId):
        self._TraceId = TraceId

    @property
    def DealNames(self):
        r"""Order number.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def BillId(self):
        r"""Large order number.
        :rtype: str
        """
        return self._BillId

    @BillId.setter
    def BillId(self, BillId):
        self._BillId = BillId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClientToken = params.get("ClientToken")
        self._FlowId = params.get("FlowId")
        self._TraceId = params.get("TraceId")
        self._DealNames = params.get("DealNames")
        self._BillId = params.get("BillId")
        self._RequestId = params.get("RequestId")


class ScaleOutInstanceRequest(AbstractModel):
    r"""ScaleOutInstance request structure.

    """

    def __init__(self):
        r"""
        :param _TimeUnit: Time unit of scale-out. Valid values:
<li>s: Second. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
<li>m: Month. When `PayMode` is 1, `TimeUnit` can only be `m`.</li>
        :type TimeUnit: str
        :param _TimeSpan: Time span of scale-out, which needs to be used together with `TimeUnit`.
        :type TimeSpan: int
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _PayMode: Instance billing mode. Valid value:
<li>0: Pay-as-you-go.</li>
        :type PayMode: int
        :param _ClientToken: Client token.
        :type ClientToken: str
        :param _PreExecutedFileSettings: Bootstrap script settings.
        :type PreExecutedFileSettings: list of PreExecuteFileSettings
        :param _TaskCount: Number of task nodes to be added.
        :type TaskCount: int
        :param _CoreCount: Number of core nodes to be added.
        :type CoreCount: int
        :param _UnNecessaryNodeList: Processes unnecessary for scale-out.
        :type UnNecessaryNodeList: list of int non-negative
        :param _RouterCount: Number of router nodes to be added.
        :type RouterCount: int
        :param _SoftDeployInfo: Deployed service.
<li>`SoftDeployInfo` and `ServiceNodeInfo` are in the same group and mutually exclusive with `UnNecessaryNodeList`.</li>
<li>The combination of `SoftDeployInfo` and `ServiceNodeInfo` is recommended.</li>
        :type SoftDeployInfo: list of int non-negative
        :param _ServiceNodeInfo: Started process.
        :type ServiceNodeInfo: list of int non-negative
        :param _DisasterRecoverGroupIds: List of spread placement group IDs. Only one can be specified currently.
        :type DisasterRecoverGroupIds: list of str
        :param _Tags: List of tags bound to added nodes.
        :type Tags: list of Tag
        :param _HardwareResourceType: Resource type selected for scale-out. Valid values: "HOST","POD","MNode", where HOST indicates an ordinary CVM resource, POD indicates a resource provided by the TKE cluster or EKS cluster, and MNode indicates a fully managed resource type.
        :type HardwareResourceType: str
        :param _PodSpec: Specified information such as pod specification and source for scale-out with pod resources.
        :type PodSpec: :class:`tencentcloud.emr.v20190103.models.PodSpec`
        :param _ClickHouseClusterName: Server group name selected for ClickHouse cluster scale-out.
        :type ClickHouseClusterName: str
        :param _ClickHouseClusterType: Server group type selected for ClickHouse cluster scale-out. Valid values: `new` (create a group) and `old` (select an existing group).
        :type ClickHouseClusterType: str
        :param _YarnNodeLabel: Yarn node label specified for rule-based scale-out.
        :type YarnNodeLabel: str
        :param _PodParameter: Custom pod permission and parameter
        :type PodParameter: :class:`tencentcloud.emr.v20190103.models.PodParameter`
        :param _MasterCount: Number of master nodes to be added.
When a ClickHouse cluster is scaled, this parameter does not take effect.
When a Kafka cluster is scaled, this parameter does not take effect.
When `HardwareResourceType` is `pod`, this parameter does not take effect.
        :type MasterCount: int
        :param _StartServiceAfterScaleOut: Whether to start the service after scale-out. `true`: Yes; `false`: No.
        :type StartServiceAfterScaleOut: str
        :param _ZoneId: AZ, which defaults to the primary AZ of the cluster.
        :type ZoneId: int
        :param _SubnetId: Subnet, which defaults to the subnet used when the cluster is created.
        :type SubnetId: str
        :param _ScaleOutServiceConfAssign: Pre-defined configuration set
        :type ScaleOutServiceConfAssign: str
        :param _AutoRenew: Whether to enable auto-renewal. Valid values: `0` (no), `1` (yes).
        :type AutoRenew: int
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR. When the type is EMR, InstanceId is effective. When the type is ComputeResource, ComputeResourceId is used.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        :param _ComputeResourceAdvanceParams: Advanced settings of computing resources.
        :type ComputeResourceAdvanceParams: :class:`tencentcloud.emr.v20190103.models.ComputeResourceAdvanceParams`
        :param _NodeMarks: Node tag information: currently used only in Terraform.
        :type NodeMarks: :class:`tencentcloud.emr.v20190103.models.NodeMark`
        """
        self._TimeUnit = None
        self._TimeSpan = None
        self._InstanceId = None
        self._PayMode = None
        self._ClientToken = None
        self._PreExecutedFileSettings = None
        self._TaskCount = None
        self._CoreCount = None
        self._UnNecessaryNodeList = None
        self._RouterCount = None
        self._SoftDeployInfo = None
        self._ServiceNodeInfo = None
        self._DisasterRecoverGroupIds = None
        self._Tags = None
        self._HardwareResourceType = None
        self._PodSpec = None
        self._ClickHouseClusterName = None
        self._ClickHouseClusterType = None
        self._YarnNodeLabel = None
        self._PodParameter = None
        self._MasterCount = None
        self._StartServiceAfterScaleOut = None
        self._ZoneId = None
        self._SubnetId = None
        self._ScaleOutServiceConfAssign = None
        self._AutoRenew = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None
        self._ComputeResourceAdvanceParams = None
        self._NodeMarks = None

    @property
    def TimeUnit(self):
        r"""Time unit of scale-out. Valid values:
<li>s: Second. When `PayMode` is 0, `TimeUnit` can only be `s`.</li>
<li>m: Month. When `PayMode` is 1, `TimeUnit` can only be `m`.</li>
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def TimeSpan(self):
        r"""Time span of scale-out, which needs to be used together with `TimeUnit`.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PayMode(self):
        r"""Instance billing mode. Valid value:
<li>0: Pay-as-you-go.</li>
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def ClientToken(self):
        r"""Client token.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def PreExecutedFileSettings(self):
        r"""Bootstrap script settings.
        :rtype: list of PreExecuteFileSettings
        """
        return self._PreExecutedFileSettings

    @PreExecutedFileSettings.setter
    def PreExecutedFileSettings(self, PreExecutedFileSettings):
        self._PreExecutedFileSettings = PreExecutedFileSettings

    @property
    def TaskCount(self):
        r"""Number of task nodes to be added.
        :rtype: int
        """
        return self._TaskCount

    @TaskCount.setter
    def TaskCount(self, TaskCount):
        self._TaskCount = TaskCount

    @property
    def CoreCount(self):
        r"""Number of core nodes to be added.
        :rtype: int
        """
        return self._CoreCount

    @CoreCount.setter
    def CoreCount(self, CoreCount):
        self._CoreCount = CoreCount

    @property
    def UnNecessaryNodeList(self):
        r"""Processes unnecessary for scale-out.
        :rtype: list of int non-negative
        """
        return self._UnNecessaryNodeList

    @UnNecessaryNodeList.setter
    def UnNecessaryNodeList(self, UnNecessaryNodeList):
        self._UnNecessaryNodeList = UnNecessaryNodeList

    @property
    def RouterCount(self):
        r"""Number of router nodes to be added.
        :rtype: int
        """
        return self._RouterCount

    @RouterCount.setter
    def RouterCount(self, RouterCount):
        self._RouterCount = RouterCount

    @property
    def SoftDeployInfo(self):
        r"""Deployed service.
<li>`SoftDeployInfo` and `ServiceNodeInfo` are in the same group and mutually exclusive with `UnNecessaryNodeList`.</li>
<li>The combination of `SoftDeployInfo` and `ServiceNodeInfo` is recommended.</li>
        :rtype: list of int non-negative
        """
        return self._SoftDeployInfo

    @SoftDeployInfo.setter
    def SoftDeployInfo(self, SoftDeployInfo):
        self._SoftDeployInfo = SoftDeployInfo

    @property
    def ServiceNodeInfo(self):
        r"""Started process.
        :rtype: list of int non-negative
        """
        return self._ServiceNodeInfo

    @ServiceNodeInfo.setter
    def ServiceNodeInfo(self, ServiceNodeInfo):
        self._ServiceNodeInfo = ServiceNodeInfo

    @property
    def DisasterRecoverGroupIds(self):
        r"""List of spread placement group IDs. Only one can be specified currently.
        :rtype: list of str
        """
        return self._DisasterRecoverGroupIds

    @DisasterRecoverGroupIds.setter
    def DisasterRecoverGroupIds(self, DisasterRecoverGroupIds):
        self._DisasterRecoverGroupIds = DisasterRecoverGroupIds

    @property
    def Tags(self):
        r"""List of tags bound to added nodes.
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def HardwareResourceType(self):
        r"""Resource type selected for scale-out. Valid values: "HOST","POD","MNode", where HOST indicates an ordinary CVM resource, POD indicates a resource provided by the TKE cluster or EKS cluster, and MNode indicates a fully managed resource type.
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType

    @property
    def PodSpec(self):
        r"""Specified information such as pod specification and source for scale-out with pod resources.
        :rtype: :class:`tencentcloud.emr.v20190103.models.PodSpec`
        """
        return self._PodSpec

    @PodSpec.setter
    def PodSpec(self, PodSpec):
        self._PodSpec = PodSpec

    @property
    def ClickHouseClusterName(self):
        r"""Server group name selected for ClickHouse cluster scale-out.
        :rtype: str
        """
        return self._ClickHouseClusterName

    @ClickHouseClusterName.setter
    def ClickHouseClusterName(self, ClickHouseClusterName):
        self._ClickHouseClusterName = ClickHouseClusterName

    @property
    def ClickHouseClusterType(self):
        r"""Server group type selected for ClickHouse cluster scale-out. Valid values: `new` (create a group) and `old` (select an existing group).
        :rtype: str
        """
        return self._ClickHouseClusterType

    @ClickHouseClusterType.setter
    def ClickHouseClusterType(self, ClickHouseClusterType):
        self._ClickHouseClusterType = ClickHouseClusterType

    @property
    def YarnNodeLabel(self):
        r"""Yarn node label specified for rule-based scale-out.
        :rtype: str
        """
        return self._YarnNodeLabel

    @YarnNodeLabel.setter
    def YarnNodeLabel(self, YarnNodeLabel):
        self._YarnNodeLabel = YarnNodeLabel

    @property
    def PodParameter(self):
        r"""Custom pod permission and parameter
        :rtype: :class:`tencentcloud.emr.v20190103.models.PodParameter`
        """
        return self._PodParameter

    @PodParameter.setter
    def PodParameter(self, PodParameter):
        self._PodParameter = PodParameter

    @property
    def MasterCount(self):
        r"""Number of master nodes to be added.
When a ClickHouse cluster is scaled, this parameter does not take effect.
When a Kafka cluster is scaled, this parameter does not take effect.
When `HardwareResourceType` is `pod`, this parameter does not take effect.
        :rtype: int
        """
        return self._MasterCount

    @MasterCount.setter
    def MasterCount(self, MasterCount):
        self._MasterCount = MasterCount

    @property
    def StartServiceAfterScaleOut(self):
        r"""Whether to start the service after scale-out. `true`: Yes; `false`: No.
        :rtype: str
        """
        return self._StartServiceAfterScaleOut

    @StartServiceAfterScaleOut.setter
    def StartServiceAfterScaleOut(self, StartServiceAfterScaleOut):
        self._StartServiceAfterScaleOut = StartServiceAfterScaleOut

    @property
    def ZoneId(self):
        r"""AZ, which defaults to the primary AZ of the cluster.
        :rtype: int
        """
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def SubnetId(self):
        r"""Subnet, which defaults to the subnet used when the cluster is created.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ScaleOutServiceConfAssign(self):
        r"""Pre-defined configuration set
        :rtype: str
        """
        return self._ScaleOutServiceConfAssign

    @ScaleOutServiceConfAssign.setter
    def ScaleOutServiceConfAssign(self, ScaleOutServiceConfAssign):
        self._ScaleOutServiceConfAssign = ScaleOutServiceConfAssign

    @property
    def AutoRenew(self):
        r"""Whether to enable auto-renewal. Valid values: `0` (no), `1` (yes).
        :rtype: int
        """
        return self._AutoRenew

    @AutoRenew.setter
    def AutoRenew(self, AutoRenew):
        self._AutoRenew = AutoRenew

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR. When the type is EMR, InstanceId is effective. When the type is ComputeResource, ComputeResourceId is used.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId

    @property
    def ComputeResourceAdvanceParams(self):
        r"""Advanced settings of computing resources.
        :rtype: :class:`tencentcloud.emr.v20190103.models.ComputeResourceAdvanceParams`
        """
        return self._ComputeResourceAdvanceParams

    @ComputeResourceAdvanceParams.setter
    def ComputeResourceAdvanceParams(self, ComputeResourceAdvanceParams):
        self._ComputeResourceAdvanceParams = ComputeResourceAdvanceParams

    @property
    def NodeMarks(self):
        r"""Node tag information: currently used only in Terraform.
        :rtype: :class:`tencentcloud.emr.v20190103.models.NodeMark`
        """
        return self._NodeMarks

    @NodeMarks.setter
    def NodeMarks(self, NodeMarks):
        self._NodeMarks = NodeMarks


    def _deserialize(self, params):
        self._TimeUnit = params.get("TimeUnit")
        self._TimeSpan = params.get("TimeSpan")
        self._InstanceId = params.get("InstanceId")
        self._PayMode = params.get("PayMode")
        self._ClientToken = params.get("ClientToken")
        if params.get("PreExecutedFileSettings") is not None:
            self._PreExecutedFileSettings = []
            for item in params.get("PreExecutedFileSettings"):
                obj = PreExecuteFileSettings()
                obj._deserialize(item)
                self._PreExecutedFileSettings.append(obj)
        self._TaskCount = params.get("TaskCount")
        self._CoreCount = params.get("CoreCount")
        self._UnNecessaryNodeList = params.get("UnNecessaryNodeList")
        self._RouterCount = params.get("RouterCount")
        self._SoftDeployInfo = params.get("SoftDeployInfo")
        self._ServiceNodeInfo = params.get("ServiceNodeInfo")
        self._DisasterRecoverGroupIds = params.get("DisasterRecoverGroupIds")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._HardwareResourceType = params.get("HardwareResourceType")
        if params.get("PodSpec") is not None:
            self._PodSpec = PodSpec()
            self._PodSpec._deserialize(params.get("PodSpec"))
        self._ClickHouseClusterName = params.get("ClickHouseClusterName")
        self._ClickHouseClusterType = params.get("ClickHouseClusterType")
        self._YarnNodeLabel = params.get("YarnNodeLabel")
        if params.get("PodParameter") is not None:
            self._PodParameter = PodParameter()
            self._PodParameter._deserialize(params.get("PodParameter"))
        self._MasterCount = params.get("MasterCount")
        self._StartServiceAfterScaleOut = params.get("StartServiceAfterScaleOut")
        self._ZoneId = params.get("ZoneId")
        self._SubnetId = params.get("SubnetId")
        self._ScaleOutServiceConfAssign = params.get("ScaleOutServiceConfAssign")
        self._AutoRenew = params.get("AutoRenew")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        if params.get("ComputeResourceAdvanceParams") is not None:
            self._ComputeResourceAdvanceParams = ComputeResourceAdvanceParams()
            self._ComputeResourceAdvanceParams._deserialize(params.get("ComputeResourceAdvanceParams"))
        if params.get("NodeMarks") is not None:
            self._NodeMarks = NodeMark()
            self._NodeMarks._deserialize(params.get("NodeMarks"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScaleOutInstanceResponse(AbstractModel):
    r"""ScaleOutInstance response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _DealNames: Order number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DealNames: list of str
        :param _ClientToken: Client Token.
        :type ClientToken: str
        :param _FlowId: Scale-out process ID.
        :type FlowId: int
        :param _BillId: Large order number.
        :type BillId: str
        :param _TraceId: TraceId for scale-out.
        :type TraceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._DealNames = None
        self._ClientToken = None
        self._FlowId = None
        self._BillId = None
        self._TraceId = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DealNames(self):
        r"""Order number.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def ClientToken(self):
        r"""Client Token.
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken

    @property
    def FlowId(self):
        r"""Scale-out process ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def BillId(self):
        r"""Large order number.
        :rtype: str
        """
        return self._BillId

    @BillId.setter
    def BillId(self, BillId):
        self._BillId = BillId

    @property
    def TraceId(self):
        r"""TraceId for scale-out.
        :rtype: str
        """
        return self._TraceId

    @TraceId.setter
    def TraceId(self, TraceId):
        self._TraceId = TraceId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DealNames = params.get("DealNames")
        self._ClientToken = params.get("ClientToken")
        self._FlowId = params.get("FlowId")
        self._BillId = params.get("BillId")
        self._TraceId = params.get("TraceId")
        self._RequestId = params.get("RequestId")


class ScaleOutNodeConfig(AbstractModel):
    r"""The type and number of nodes to be added.

    """

    def __init__(self):
        r"""
        :param _NodeFlag: Valid values of node type:
  <li>MASTER</li>
  <li>TASK</li>
  <li>CORE</li>
  <li>ROUTER</li>
        :type NodeFlag: str
        :param _NodeCount: The number of nodes.
        :type NodeCount: int
        """
        self._NodeFlag = None
        self._NodeCount = None

    @property
    def NodeFlag(self):
        r"""Valid values of node type:
  <li>MASTER</li>
  <li>TASK</li>
  <li>CORE</li>
  <li>ROUTER</li>
        :rtype: str
        """
        return self._NodeFlag

    @NodeFlag.setter
    def NodeFlag(self, NodeFlag):
        self._NodeFlag = NodeFlag

    @property
    def NodeCount(self):
        r"""The number of nodes.
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount


    def _deserialize(self, params):
        self._NodeFlag = params.get("NodeFlag")
        self._NodeCount = params.get("NodeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScaleOutServiceConfGroupsInfo(AbstractModel):
    r"""Configuration group specified for scale-out.

    """

    def __init__(self):
        r"""
        :param _ServiceComponentName: Component version name, for example, HDFS-2.8.5.
        :type ServiceComponentName: str
        :param _ConfGroupName: Configuration group name, for example, hdfs-core-defaultGroup. If the ConfGroupName parameter is passed in, the configuration group dimension is used.
                                                             If the ConfGroupName parameter is not passed in, the cluster dimension is used.
        :type ConfGroupName: str
        """
        self._ServiceComponentName = None
        self._ConfGroupName = None

    @property
    def ServiceComponentName(self):
        r"""Component version name, for example, HDFS-2.8.5.
        :rtype: str
        """
        return self._ServiceComponentName

    @ServiceComponentName.setter
    def ServiceComponentName(self, ServiceComponentName):
        self._ServiceComponentName = ServiceComponentName

    @property
    def ConfGroupName(self):
        r"""Configuration group name, for example, hdfs-core-defaultGroup. If the ConfGroupName parameter is passed in, the configuration group dimension is used.
                                                             If the ConfGroupName parameter is not passed in, the cluster dimension is used.
        :rtype: str
        """
        return self._ConfGroupName

    @ConfGroupName.setter
    def ConfGroupName(self, ConfGroupName):
        self._ConfGroupName = ConfGroupName


    def _deserialize(self, params):
        self._ServiceComponentName = params.get("ServiceComponentName")
        self._ConfGroupName = params.get("ConfGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SceneSoftwareConfig(AbstractModel):
    r"""The configuration of cluster application scenario and supported components.

    """

    def __init__(self):
        r"""
        :param _Software: The list of deployed components. The list of component options varies by `ProductVersion` (EMR version). For more information, see [Component Version](https://intl.cloud.tencent.com/document/product/589/20279?from_cn_redirect=1).
The instance type, `hive` or `flink`.
        :type Software: list of str
        :param _SceneName: The scenario name, which defaults to `Hadoop-Default`. For more details, see [here](https://intl.cloud.tencent.com/document/product/589/14624?from_cn_redirect=1). Valid values:
Hadoop-Kudu
Hadoop-Zookeeper
Hadoop-Presto
Hadoop-Hbase
Hadoop-Default
        :type SceneName: str
        """
        self._Software = None
        self._SceneName = None

    @property
    def Software(self):
        r"""The list of deployed components. The list of component options varies by `ProductVersion` (EMR version). For more information, see [Component Version](https://intl.cloud.tencent.com/document/product/589/20279?from_cn_redirect=1).
The instance type, `hive` or `flink`.
        :rtype: list of str
        """
        return self._Software

    @Software.setter
    def Software(self, Software):
        self._Software = Software

    @property
    def SceneName(self):
        r"""The scenario name, which defaults to `Hadoop-Default`. For more details, see [here](https://intl.cloud.tencent.com/document/product/589/14624?from_cn_redirect=1). Valid values:
Hadoop-Kudu
Hadoop-Zookeeper
Hadoop-Presto
Hadoop-Hbase
Hadoop-Default
        :rtype: str
        """
        return self._SceneName

    @SceneName.setter
    def SceneName(self, SceneName):
        self._SceneName = SceneName


    def _deserialize(self, params):
        self._Software = params.get("Software")
        self._SceneName = params.get("SceneName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SchedulerTaskDetail(AbstractModel):
    r"""Scheduling task details

    """

    def __init__(self):
        r"""
        :param _Step: Steps.
        :type Step: str
        :param _Progress: Progress.
        :type Progress: str
        :param _FailReason: Failure information.
        :type FailReason: str
        :param _JobId: ID used to obtain details.
        :type JobId: int
        """
        self._Step = None
        self._Progress = None
        self._FailReason = None
        self._JobId = None

    @property
    def Step(self):
        r"""Steps.
        :rtype: str
        """
        return self._Step

    @Step.setter
    def Step(self, Step):
        self._Step = Step

    @property
    def Progress(self):
        r"""Progress.
        :rtype: str
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def FailReason(self):
        r"""Failure information.
        :rtype: str
        """
        return self._FailReason

    @FailReason.setter
    def FailReason(self, FailReason):
        self._FailReason = FailReason

    @property
    def JobId(self):
        r"""ID used to obtain details.
        :rtype: int
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._Step = params.get("Step")
        self._Progress = params.get("Progress")
        self._FailReason = params.get("FailReason")
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SchedulerTaskInfo(AbstractModel):
    r"""Yarn resource scheduling history

    """

    def __init__(self):
        r"""
        :param _SchedulerName: Scheduler type
        :type SchedulerName: str
        :param _OperatorName: Operation type
        :type OperatorName: str
        :param _CreateTime: Start time.
        :type CreateTime: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _State: Status.
        :type State: int
        :param _Details: Details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Details: list of SchedulerTaskDetail
        """
        self._SchedulerName = None
        self._OperatorName = None
        self._CreateTime = None
        self._EndTime = None
        self._State = None
        self._Details = None

    @property
    def SchedulerName(self):
        r"""Scheduler type
        :rtype: str
        """
        return self._SchedulerName

    @SchedulerName.setter
    def SchedulerName(self, SchedulerName):
        self._SchedulerName = SchedulerName

    @property
    def OperatorName(self):
        r"""Operation type
        :rtype: str
        """
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def CreateTime(self):
        r"""Start time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def State(self):
        r"""Status.
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Details(self):
        r"""Details.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SchedulerTaskDetail
        """
        return self._Details

    @Details.setter
    def Details(self, Details):
        self._Details = Details


    def _deserialize(self, params):
        self._SchedulerName = params.get("SchedulerName")
        self._OperatorName = params.get("OperatorName")
        self._CreateTime = params.get("CreateTime")
        self._EndTime = params.get("EndTime")
        self._State = params.get("State")
        if params.get("Details") is not None:
            self._Details = []
            for item in params.get("Details"):
                obj = SchedulerTaskDetail()
                obj._deserialize(item)
                self._Details.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScriptBootstrapActionConfig(AbstractModel):
    r"""The bootstrap action.

    """

    def __init__(self):
        r"""
        :param _CosFileURI: The COS URL of the script, in the format of `https://beijing-111111.cos.ap-beijing.myqcloud.com/data/test.sh`. For the COS bucket list, see [Bucket List](https://console.cloud.tencent.com/cos/bucket).
        :type CosFileURI: str
        :param _ExecutionMoment: The execution time of the bootstrap action script. Valid values:
<li>`resourceAfter`: After node initialization</li>
<li>`clusterAfter`: After cluster start</li>
<li>`clusterBefore`: Before cluster start</li>
        :type ExecutionMoment: str
        :param _Args: The execution script parameter. The parameter format must comply with standard shell specifications.
        :type Args: list of str
        :param _CosFileName: The script file name.
        :type CosFileName: str
        :param _Remark: Remarks.
        :type Remark: str
        """
        self._CosFileURI = None
        self._ExecutionMoment = None
        self._Args = None
        self._CosFileName = None
        self._Remark = None

    @property
    def CosFileURI(self):
        r"""The COS URL of the script, in the format of `https://beijing-111111.cos.ap-beijing.myqcloud.com/data/test.sh`. For the COS bucket list, see [Bucket List](https://console.cloud.tencent.com/cos/bucket).
        :rtype: str
        """
        return self._CosFileURI

    @CosFileURI.setter
    def CosFileURI(self, CosFileURI):
        self._CosFileURI = CosFileURI

    @property
    def ExecutionMoment(self):
        r"""The execution time of the bootstrap action script. Valid values:
<li>`resourceAfter`: After node initialization</li>
<li>`clusterAfter`: After cluster start</li>
<li>`clusterBefore`: Before cluster start</li>
        :rtype: str
        """
        return self._ExecutionMoment

    @ExecutionMoment.setter
    def ExecutionMoment(self, ExecutionMoment):
        self._ExecutionMoment = ExecutionMoment

    @property
    def Args(self):
        r"""The execution script parameter. The parameter format must comply with standard shell specifications.
        :rtype: list of str
        """
        return self._Args

    @Args.setter
    def Args(self, Args):
        self._Args = Args

    @property
    def CosFileName(self):
        r"""The script file name.
        :rtype: str
        """
        return self._CosFileName

    @CosFileName.setter
    def CosFileName(self, CosFileName):
        self._CosFileName = CosFileName

    @property
    def Remark(self):
        r"""Remarks.
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._CosFileURI = params.get("CosFileURI")
        self._ExecutionMoment = params.get("ExecutionMoment")
        self._Args = params.get("Args")
        self._CosFileName = params.get("CosFileName")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchItem(AbstractModel):
    r"""Search field

    """

    def __init__(self):
        r"""
        :param _SearchType: Searchable type.
        :type SearchType: str
        :param _SearchValue: Searchable value.
        :type SearchValue: str
        """
        self._SearchType = None
        self._SearchValue = None

    @property
    def SearchType(self):
        r"""Searchable type.
        :rtype: str
        """
        return self._SearchType

    @SearchType.setter
    def SearchType(self, SearchType):
        self._SearchType = SearchType

    @property
    def SearchValue(self):
        r"""Searchable value.
        :rtype: str
        """
        return self._SearchValue

    @SearchValue.setter
    def SearchValue(self, SearchValue):
        self._SearchValue = SearchValue


    def _deserialize(self, params):
        self._SearchType = params.get("SearchType")
        self._SearchValue = params.get("SearchValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ServiceBasicRestartInfo(AbstractModel):
    r"""The services to operate on

    """

    def __init__(self):
        r"""
        :param _ServiceName: The service name (required), such as HDFS.
        :type ServiceName: str
        :param _ComponentInfoList: If it is left empty, all processes will be operated on.
        :type ComponentInfoList: list of ComponentBasicRestartInfo
        """
        self._ServiceName = None
        self._ComponentInfoList = None

    @property
    def ServiceName(self):
        r"""The service name (required), such as HDFS.
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def ComponentInfoList(self):
        r"""If it is left empty, all processes will be operated on.
        :rtype: list of ComponentBasicRestartInfo
        """
        return self._ComponentInfoList

    @ComponentInfoList.setter
    def ComponentInfoList(self, ComponentInfoList):
        self._ComponentInfoList = ComponentInfoList


    def _deserialize(self, params):
        self._ServiceName = params.get("ServiceName")
        if params.get("ComponentInfoList") is not None:
            self._ComponentInfoList = []
            for item in params.get("ComponentInfoList"):
                obj = ComponentBasicRestartInfo()
                obj._deserialize(item)
                self._ComponentInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ServiceNodeDetailInfo(AbstractModel):
    r"""Service process information.

    """

    def __init__(self):
        r"""
        :param _Ip: Process node IP
        :type Ip: str
        :param _NodeType: Process type.
        :type NodeType: int
        :param _NodeName: Process name
        :type NodeName: str
        :param _ServiceStatus: Service component status
        :type ServiceStatus: int
        :param _MonitorStatus: Process monitoring status
        :type MonitorStatus: int
        :param _Status: Service component status
        :type Status: int
        :param _PortsInfo: Process port information
        :type PortsInfo: str
        :param _LastRestartTime: Last restart time.
        :type LastRestartTime: str
        :param _Flag: Node type.
        :type Flag: int
        :param _ConfGroupId: Configuration group ID.
        :type ConfGroupId: int
        :param _ConfGroupName: Configuration group name.
        :type ConfGroupName: str
        :param _ConfStatus: Whether the node needs to be restarted
        :type ConfStatus: int
        :param _ServiceDetectionInfo: Process detection information

Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceDetectionInfo: list of ServiceProcessFunctionInfo
        :param _NodeFlagFilter: Node type.
        :type NodeFlagFilter: str
        :param _HealthStatus: Process health status

Note: This field may return null, indicating that no valid values can be obtained.
        :type HealthStatus: :class:`tencentcloud.emr.v20190103.models.HealthStatus`
        :param _IsSupportRoleMonitor: Whether the role supports monitoring.
        :type IsSupportRoleMonitor: bool
        :param _StopPolicies: Suspension policy

Note: This field may return null, indicating that no valid values can be obtained.
        :type StopPolicies: list of RestartPolicy
        :param _HAState: Strong validation of the API in a test environment. This strong validation doesn't exist on the current network, but it does exist in the data returned by the emrcc interface. If it’s not applied, an error will be reported. Omitting it will result in an error.
        :type HAState: str
        :param _NameService: NameService name.
        :type NameService: str
        :param _IsFederation: Whether the federation is supported.
        :type IsFederation: bool
        :param _DataNodeMaintenanceState: Whether the DataNode is in maintenance status.
        :type DataNodeMaintenanceState: int
        """
        self._Ip = None
        self._NodeType = None
        self._NodeName = None
        self._ServiceStatus = None
        self._MonitorStatus = None
        self._Status = None
        self._PortsInfo = None
        self._LastRestartTime = None
        self._Flag = None
        self._ConfGroupId = None
        self._ConfGroupName = None
        self._ConfStatus = None
        self._ServiceDetectionInfo = None
        self._NodeFlagFilter = None
        self._HealthStatus = None
        self._IsSupportRoleMonitor = None
        self._StopPolicies = None
        self._HAState = None
        self._NameService = None
        self._IsFederation = None
        self._DataNodeMaintenanceState = None

    @property
    def Ip(self):
        r"""Process node IP
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def NodeType(self):
        r"""Process type.
        :rtype: int
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        r"""Process name
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def ServiceStatus(self):
        r"""Service component status
        :rtype: int
        """
        return self._ServiceStatus

    @ServiceStatus.setter
    def ServiceStatus(self, ServiceStatus):
        self._ServiceStatus = ServiceStatus

    @property
    def MonitorStatus(self):
        r"""Process monitoring status
        :rtype: int
        """
        return self._MonitorStatus

    @MonitorStatus.setter
    def MonitorStatus(self, MonitorStatus):
        self._MonitorStatus = MonitorStatus

    @property
    def Status(self):
        r"""Service component status
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PortsInfo(self):
        r"""Process port information
        :rtype: str
        """
        return self._PortsInfo

    @PortsInfo.setter
    def PortsInfo(self, PortsInfo):
        self._PortsInfo = PortsInfo

    @property
    def LastRestartTime(self):
        r"""Last restart time.
        :rtype: str
        """
        return self._LastRestartTime

    @LastRestartTime.setter
    def LastRestartTime(self, LastRestartTime):
        self._LastRestartTime = LastRestartTime

    @property
    def Flag(self):
        r"""Node type.
        :rtype: int
        """
        return self._Flag

    @Flag.setter
    def Flag(self, Flag):
        self._Flag = Flag

    @property
    def ConfGroupId(self):
        r"""Configuration group ID.
        :rtype: int
        """
        return self._ConfGroupId

    @ConfGroupId.setter
    def ConfGroupId(self, ConfGroupId):
        self._ConfGroupId = ConfGroupId

    @property
    def ConfGroupName(self):
        r"""Configuration group name.
        :rtype: str
        """
        return self._ConfGroupName

    @ConfGroupName.setter
    def ConfGroupName(self, ConfGroupName):
        self._ConfGroupName = ConfGroupName

    @property
    def ConfStatus(self):
        r"""Whether the node needs to be restarted
        :rtype: int
        """
        return self._ConfStatus

    @ConfStatus.setter
    def ConfStatus(self, ConfStatus):
        self._ConfStatus = ConfStatus

    @property
    def ServiceDetectionInfo(self):
        r"""Process detection information

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ServiceProcessFunctionInfo
        """
        return self._ServiceDetectionInfo

    @ServiceDetectionInfo.setter
    def ServiceDetectionInfo(self, ServiceDetectionInfo):
        self._ServiceDetectionInfo = ServiceDetectionInfo

    @property
    def NodeFlagFilter(self):
        r"""Node type.
        :rtype: str
        """
        return self._NodeFlagFilter

    @NodeFlagFilter.setter
    def NodeFlagFilter(self, NodeFlagFilter):
        self._NodeFlagFilter = NodeFlagFilter

    @property
    def HealthStatus(self):
        r"""Process health status

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.emr.v20190103.models.HealthStatus`
        """
        return self._HealthStatus

    @HealthStatus.setter
    def HealthStatus(self, HealthStatus):
        self._HealthStatus = HealthStatus

    @property
    def IsSupportRoleMonitor(self):
        r"""Whether the role supports monitoring.
        :rtype: bool
        """
        return self._IsSupportRoleMonitor

    @IsSupportRoleMonitor.setter
    def IsSupportRoleMonitor(self, IsSupportRoleMonitor):
        self._IsSupportRoleMonitor = IsSupportRoleMonitor

    @property
    def StopPolicies(self):
        r"""Suspension policy

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of RestartPolicy
        """
        return self._StopPolicies

    @StopPolicies.setter
    def StopPolicies(self, StopPolicies):
        self._StopPolicies = StopPolicies

    @property
    def HAState(self):
        r"""Strong validation of the API in a test environment. This strong validation doesn't exist on the current network, but it does exist in the data returned by the emrcc interface. If it’s not applied, an error will be reported. Omitting it will result in an error.
        :rtype: str
        """
        return self._HAState

    @HAState.setter
    def HAState(self, HAState):
        self._HAState = HAState

    @property
    def NameService(self):
        r"""NameService name.
        :rtype: str
        """
        return self._NameService

    @NameService.setter
    def NameService(self, NameService):
        self._NameService = NameService

    @property
    def IsFederation(self):
        r"""Whether the federation is supported.
        :rtype: bool
        """
        return self._IsFederation

    @IsFederation.setter
    def IsFederation(self, IsFederation):
        self._IsFederation = IsFederation

    @property
    def DataNodeMaintenanceState(self):
        r"""Whether the DataNode is in maintenance status.
        :rtype: int
        """
        return self._DataNodeMaintenanceState

    @DataNodeMaintenanceState.setter
    def DataNodeMaintenanceState(self, DataNodeMaintenanceState):
        self._DataNodeMaintenanceState = DataNodeMaintenanceState


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        self._ServiceStatus = params.get("ServiceStatus")
        self._MonitorStatus = params.get("MonitorStatus")
        self._Status = params.get("Status")
        self._PortsInfo = params.get("PortsInfo")
        self._LastRestartTime = params.get("LastRestartTime")
        self._Flag = params.get("Flag")
        self._ConfGroupId = params.get("ConfGroupId")
        self._ConfGroupName = params.get("ConfGroupName")
        self._ConfStatus = params.get("ConfStatus")
        if params.get("ServiceDetectionInfo") is not None:
            self._ServiceDetectionInfo = []
            for item in params.get("ServiceDetectionInfo"):
                obj = ServiceProcessFunctionInfo()
                obj._deserialize(item)
                self._ServiceDetectionInfo.append(obj)
        self._NodeFlagFilter = params.get("NodeFlagFilter")
        if params.get("HealthStatus") is not None:
            self._HealthStatus = HealthStatus()
            self._HealthStatus._deserialize(params.get("HealthStatus"))
        self._IsSupportRoleMonitor = params.get("IsSupportRoleMonitor")
        if params.get("StopPolicies") is not None:
            self._StopPolicies = []
            for item in params.get("StopPolicies"):
                obj = RestartPolicy()
                obj._deserialize(item)
                self._StopPolicies.append(obj)
        self._HAState = params.get("HAState")
        self._NameService = params.get("NameService")
        self._IsFederation = params.get("IsFederation")
        self._DataNodeMaintenanceState = params.get("DataNodeMaintenanceState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ServiceProcessFunctionInfo(AbstractModel):
    r"""Process detection information

    """

    def __init__(self):
        r"""
        :param _DetectAlert: Detection alarm level.
        :type DetectAlert: str
        :param _DetetcFunctionKey: Detection feature description

Note: This field may return null, indicating that no valid values can be obtained.
        :type DetetcFunctionKey: str
        :param _DetetcFunctionValue: Detection feature result

Note: This field may return null, indicating that no valid values can be obtained.
        :type DetetcFunctionValue: str
        :param _DetetcTime: Detection results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetetcTime: str
        :param _DetectFunctionKey: Detection feature description.
        :type DetectFunctionKey: str
        :param _DetectFunctionValue: Detection feature result.
        :type DetectFunctionValue: str
        :param _DetectTime: Detection result.
        :type DetectTime: str
        """
        self._DetectAlert = None
        self._DetetcFunctionKey = None
        self._DetetcFunctionValue = None
        self._DetetcTime = None
        self._DetectFunctionKey = None
        self._DetectFunctionValue = None
        self._DetectTime = None

    @property
    def DetectAlert(self):
        r"""Detection alarm level.
        :rtype: str
        """
        return self._DetectAlert

    @DetectAlert.setter
    def DetectAlert(self, DetectAlert):
        self._DetectAlert = DetectAlert

    @property
    def DetetcFunctionKey(self):
        warnings.warn("parameter `DetetcFunctionKey` is deprecated", DeprecationWarning) 

        r"""Detection feature description

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DetetcFunctionKey

    @DetetcFunctionKey.setter
    def DetetcFunctionKey(self, DetetcFunctionKey):
        warnings.warn("parameter `DetetcFunctionKey` is deprecated", DeprecationWarning) 

        self._DetetcFunctionKey = DetetcFunctionKey

    @property
    def DetetcFunctionValue(self):
        warnings.warn("parameter `DetetcFunctionValue` is deprecated", DeprecationWarning) 

        r"""Detection feature result

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DetetcFunctionValue

    @DetetcFunctionValue.setter
    def DetetcFunctionValue(self, DetetcFunctionValue):
        warnings.warn("parameter `DetetcFunctionValue` is deprecated", DeprecationWarning) 

        self._DetetcFunctionValue = DetetcFunctionValue

    @property
    def DetetcTime(self):
        warnings.warn("parameter `DetetcTime` is deprecated", DeprecationWarning) 

        r"""Detection results.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DetetcTime

    @DetetcTime.setter
    def DetetcTime(self, DetetcTime):
        warnings.warn("parameter `DetetcTime` is deprecated", DeprecationWarning) 

        self._DetetcTime = DetetcTime

    @property
    def DetectFunctionKey(self):
        r"""Detection feature description.
        :rtype: str
        """
        return self._DetectFunctionKey

    @DetectFunctionKey.setter
    def DetectFunctionKey(self, DetectFunctionKey):
        self._DetectFunctionKey = DetectFunctionKey

    @property
    def DetectFunctionValue(self):
        r"""Detection feature result.
        :rtype: str
        """
        return self._DetectFunctionValue

    @DetectFunctionValue.setter
    def DetectFunctionValue(self, DetectFunctionValue):
        self._DetectFunctionValue = DetectFunctionValue

    @property
    def DetectTime(self):
        r"""Detection result.
        :rtype: str
        """
        return self._DetectTime

    @DetectTime.setter
    def DetectTime(self, DetectTime):
        self._DetectTime = DetectTime


    def _deserialize(self, params):
        self._DetectAlert = params.get("DetectAlert")
        self._DetetcFunctionKey = params.get("DetetcFunctionKey")
        self._DetetcFunctionValue = params.get("DetetcFunctionValue")
        self._DetetcTime = params.get("DetetcTime")
        self._DetectFunctionKey = params.get("DetectFunctionKey")
        self._DetectFunctionValue = params.get("DetectFunctionValue")
        self._DetectTime = params.get("DetectTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetNodeResourceConfigDefaultRequest(AbstractModel):
    r"""SetNodeResourceConfigDefault request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster instance ID.
        :type InstanceId: str
        :param _ResourceConfigId: Configuration ID.
        :type ResourceConfigId: int
        :param _ResourceType: Specification node type, with the valid values of CORE, TASK, and ROUTER.
        :type ResourceType: str
        :param _ResourceBaseType: The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :type ResourceBaseType: str
        :param _ComputeResourceId: Computing resource ID.
        :type ComputeResourceId: str
        :param _HardwareResourceType: Hardware type.
        :type HardwareResourceType: str
        """
        self._InstanceId = None
        self._ResourceConfigId = None
        self._ResourceType = None
        self._ResourceBaseType = None
        self._ComputeResourceId = None
        self._HardwareResourceType = None

    @property
    def InstanceId(self):
        r"""Cluster instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceConfigId(self):
        r"""Configuration ID.
        :rtype: int
        """
        return self._ResourceConfigId

    @ResourceConfigId.setter
    def ResourceConfigId(self, ResourceConfigId):
        self._ResourceConfigId = ResourceConfigId

    @property
    def ResourceType(self):
        r"""Specification node type, with the valid values of CORE, TASK, and ROUTER.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceBaseType(self):
        r"""The type can be ComputeResource, EMR, or a default value. The default value is EMR.
        :rtype: str
        """
        return self._ResourceBaseType

    @ResourceBaseType.setter
    def ResourceBaseType(self, ResourceBaseType):
        self._ResourceBaseType = ResourceBaseType

    @property
    def ComputeResourceId(self):
        r"""Computing resource ID.
        :rtype: str
        """
        return self._ComputeResourceId

    @ComputeResourceId.setter
    def ComputeResourceId(self, ComputeResourceId):
        self._ComputeResourceId = ComputeResourceId

    @property
    def HardwareResourceType(self):
        r"""Hardware type.
        :rtype: str
        """
        return self._HardwareResourceType

    @HardwareResourceType.setter
    def HardwareResourceType(self, HardwareResourceType):
        self._HardwareResourceType = HardwareResourceType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ResourceConfigId = params.get("ResourceConfigId")
        self._ResourceType = params.get("ResourceType")
        self._ResourceBaseType = params.get("ResourceBaseType")
        self._ComputeResourceId = params.get("ComputeResourceId")
        self._HardwareResourceType = params.get("HardwareResourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetNodeResourceConfigDefaultResponse(AbstractModel):
    r"""SetNodeResourceConfigDefault response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ShortNodeInfo(AbstractModel):
    r"""Node information

    """

    def __init__(self):
        r"""
        :param _NodeType: Node type: Master/Core/Task/Router/Common.
        :type NodeType: str
        :param _NodeSize: Number of nodes.
        :type NodeSize: int
        """
        self._NodeType = None
        self._NodeSize = None

    @property
    def NodeType(self):
        r"""Node type: Master/Core/Task/Router/Common.
        :rtype: str
        """
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeSize(self):
        r"""Number of nodes.
        :rtype: int
        """
        return self._NodeSize

    @NodeSize.setter
    def NodeSize(self, NodeSize):
        self._NodeSize = NodeSize


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeSize = params.get("NodeSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SoftDependInfo(AbstractModel):
    r"""Client component dependencies

    """

    def __init__(self):
        r"""
        :param _SoftName: The component name.
        :type SoftName: str
        :param _Required: Whether the component is required.
        :type Required: bool
        """
        self._SoftName = None
        self._Required = None

    @property
    def SoftName(self):
        r"""The component name.
        :rtype: str
        """
        return self._SoftName

    @SoftName.setter
    def SoftName(self, SoftName):
        self._SoftName = SoftName

    @property
    def Required(self):
        r"""Whether the component is required.
        :rtype: bool
        """
        return self._Required

    @Required.setter
    def Required(self, Required):
        self._Required = Required


    def _deserialize(self, params):
        self._SoftName = params.get("SoftName")
        self._Required = params.get("Required")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SparkApplicationsList(AbstractModel):
    r"""Spark task list.

    """

    def __init__(self):
        r"""
        :param _ID: Application ID.
        :type ID: str
        :param _Name: Application name.
        :type Name: str
        :param _User: User.
        :type User: str
        :param _StartTime: Start time.
        :type StartTime: int
        :param _EndTime: End time.
        :type EndTime: int
        :param _Duration: Duration.
        :type Duration: int
        :param _State: Status.
        :type State: str
        :param _ApplicationType: Type.
        :type ApplicationType: str
        :param _CoreSeconds: Number of cores multiplied by seconds.
        :type CoreSeconds: int
        :param _MemorySeconds: Memory MB multiplied by seconds.
        :type MemorySeconds: str
        :param _Insight: Insight result.
        :type Insight: str
        """
        self._ID = None
        self._Name = None
        self._User = None
        self._StartTime = None
        self._EndTime = None
        self._Duration = None
        self._State = None
        self._ApplicationType = None
        self._CoreSeconds = None
        self._MemorySeconds = None
        self._Insight = None

    @property
    def ID(self):
        r"""Application ID.
        :rtype: str
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Name(self):
        r"""Application name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def User(self):
        r"""User.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Duration(self):
        r"""Duration.
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def State(self):
        r"""Status.
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def ApplicationType(self):
        r"""Type.
        :rtype: str
        """
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def CoreSeconds(self):
        r"""Number of cores multiplied by seconds.
        :rtype: int
        """
        return self._CoreSeconds

    @CoreSeconds.setter
    def CoreSeconds(self, CoreSeconds):
        self._CoreSeconds = CoreSeconds

    @property
    def MemorySeconds(self):
        r"""Memory MB multiplied by seconds.
        :rtype: str
        """
        return self._MemorySeconds

    @MemorySeconds.setter
    def MemorySeconds(self, MemorySeconds):
        self._MemorySeconds = MemorySeconds

    @property
    def Insight(self):
        r"""Insight result.
        :rtype: str
        """
        return self._Insight

    @Insight.setter
    def Insight(self, Insight):
        self._Insight = Insight


    def _deserialize(self, params):
        self._ID = params.get("ID")
        self._Name = params.get("Name")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Duration = params.get("Duration")
        self._State = params.get("State")
        self._ApplicationType = params.get("ApplicationType")
        self._CoreSeconds = params.get("CoreSeconds")
        self._MemorySeconds = params.get("MemorySeconds")
        self._Insight = params.get("Insight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SparkQuery(AbstractModel):
    r"""Spark query details.

    """

    def __init__(self):
        r"""
        :param _Statement: Execution statement.
        :type Statement: str
        :param _Duration: Execution duration (ms).
        :type Duration: int
        :param _Status: Execution status.
        :type Status: str
        :param _Id: Query ID.
        :type Id: str
        :param _ScanPartitionNum: Number of scanned partitions.
        :type ScanPartitionNum: int
        :param _ScanRowNum: Total number of scanned rows.
        :type ScanRowNum: int
        :param _ScanFileNum: Total number of scanned files.
        :type ScanFileNum: int
        :param _ScanTotalData: Total data volume scanned by query (bytes).
        :type ScanTotalData: int
        :param _ApplicationId: Application ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: list of str
        :param _OutputRowNum: Total number of output rows.
        :type OutputRowNum: int
        :param _OutputFileNum: Total number of output files.
        :type OutputFileNum: int
        :param _OutputPartitionNum: Number of output partitions.
        :type OutputPartitionNum: int
        :param _OutputTotalData: Total output data volume (bytes).
        :type OutputTotalData: int
        :param _BeginTime: Start time.
        :type BeginTime: int
        :param _EndTime: End time.
        :type EndTime: int
        """
        self._Statement = None
        self._Duration = None
        self._Status = None
        self._Id = None
        self._ScanPartitionNum = None
        self._ScanRowNum = None
        self._ScanFileNum = None
        self._ScanTotalData = None
        self._ApplicationId = None
        self._OutputRowNum = None
        self._OutputFileNum = None
        self._OutputPartitionNum = None
        self._OutputTotalData = None
        self._BeginTime = None
        self._EndTime = None

    @property
    def Statement(self):
        r"""Execution statement.
        :rtype: str
        """
        return self._Statement

    @Statement.setter
    def Statement(self, Statement):
        self._Statement = Statement

    @property
    def Duration(self):
        r"""Execution duration (ms).
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Status(self):
        r"""Execution status.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Id(self):
        r"""Query ID.
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScanPartitionNum(self):
        r"""Number of scanned partitions.
        :rtype: int
        """
        return self._ScanPartitionNum

    @ScanPartitionNum.setter
    def ScanPartitionNum(self, ScanPartitionNum):
        self._ScanPartitionNum = ScanPartitionNum

    @property
    def ScanRowNum(self):
        r"""Total number of scanned rows.
        :rtype: int
        """
        return self._ScanRowNum

    @ScanRowNum.setter
    def ScanRowNum(self, ScanRowNum):
        self._ScanRowNum = ScanRowNum

    @property
    def ScanFileNum(self):
        r"""Total number of scanned files.
        :rtype: int
        """
        return self._ScanFileNum

    @ScanFileNum.setter
    def ScanFileNum(self, ScanFileNum):
        self._ScanFileNum = ScanFileNum

    @property
    def ScanTotalData(self):
        r"""Total data volume scanned by query (bytes).
        :rtype: int
        """
        return self._ScanTotalData

    @ScanTotalData.setter
    def ScanTotalData(self, ScanTotalData):
        self._ScanTotalData = ScanTotalData

    @property
    def ApplicationId(self):
        r"""Application ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def OutputRowNum(self):
        r"""Total number of output rows.
        :rtype: int
        """
        return self._OutputRowNum

    @OutputRowNum.setter
    def OutputRowNum(self, OutputRowNum):
        self._OutputRowNum = OutputRowNum

    @property
    def OutputFileNum(self):
        r"""Total number of output files.
        :rtype: int
        """
        return self._OutputFileNum

    @OutputFileNum.setter
    def OutputFileNum(self, OutputFileNum):
        self._OutputFileNum = OutputFileNum

    @property
    def OutputPartitionNum(self):
        r"""Number of output partitions.
        :rtype: int
        """
        return self._OutputPartitionNum

    @OutputPartitionNum.setter
    def OutputPartitionNum(self, OutputPartitionNum):
        self._OutputPartitionNum = OutputPartitionNum

    @property
    def OutputTotalData(self):
        r"""Total output data volume (bytes).
        :rtype: int
        """
        return self._OutputTotalData

    @OutputTotalData.setter
    def OutputTotalData(self, OutputTotalData):
        self._OutputTotalData = OutputTotalData

    @property
    def BeginTime(self):
        r"""Start time.
        :rtype: int
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Statement = params.get("Statement")
        self._Duration = params.get("Duration")
        self._Status = params.get("Status")
        self._Id = params.get("Id")
        self._ScanPartitionNum = params.get("ScanPartitionNum")
        self._ScanRowNum = params.get("ScanRowNum")
        self._ScanFileNum = params.get("ScanFileNum")
        self._ScanTotalData = params.get("ScanTotalData")
        self._ApplicationId = params.get("ApplicationId")
        self._OutputRowNum = params.get("OutputRowNum")
        self._OutputFileNum = params.get("OutputFileNum")
        self._OutputPartitionNum = params.get("OutputPartitionNum")
        self._OutputTotalData = params.get("OutputTotalData")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StageInfoDetail(AbstractModel):
    r"""Task step details

    """

    def __init__(self):
        r"""
        :param _Stage: Steps.
        :type Stage: str
        :param _Name: Step name.
        :type Name: str
        :param _IsShow: Indicates whether to display
        :type IsShow: bool
        :param _IsSubFlow: Whether it is a subprocess
        :type IsSubFlow: bool
        :param _SubFlowFlag: Subprocess tag.
        :type SubFlowFlag: str
        :param _Status: Step execution status. 0: not started, 1: in progress, 2: completed, 3: partially completed, -1: failed
        :type Status: int
        :param _Desc: Step running status description.
        :type Desc: str
        :param _Progress: Running progress.
        :type Progress: float
        :param _Starttime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type Starttime: str
        :param _Endtime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type Endtime: str
        :param _HadWoodDetail: Whether details are included.
        :type HadWoodDetail: bool
        :param _WoodJobId: Wood subprocess ID.
        :type WoodJobId: int
        :param _LanguageKey: Multi-language version key.
        :type LanguageKey: str
        :param _FailedReason: Reason for stage failure.
        :type FailedReason: str
        :param _TimeConsuming: Step duration.
        :type TimeConsuming: str
        :param _Id: 
        :type Id: int
        """
        self._Stage = None
        self._Name = None
        self._IsShow = None
        self._IsSubFlow = None
        self._SubFlowFlag = None
        self._Status = None
        self._Desc = None
        self._Progress = None
        self._Starttime = None
        self._Endtime = None
        self._HadWoodDetail = None
        self._WoodJobId = None
        self._LanguageKey = None
        self._FailedReason = None
        self._TimeConsuming = None
        self._Id = None

    @property
    def Stage(self):
        r"""Steps.
        :rtype: str
        """
        return self._Stage

    @Stage.setter
    def Stage(self, Stage):
        self._Stage = Stage

    @property
    def Name(self):
        r"""Step name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def IsShow(self):
        r"""Indicates whether to display
        :rtype: bool
        """
        return self._IsShow

    @IsShow.setter
    def IsShow(self, IsShow):
        self._IsShow = IsShow

    @property
    def IsSubFlow(self):
        r"""Whether it is a subprocess
        :rtype: bool
        """
        return self._IsSubFlow

    @IsSubFlow.setter
    def IsSubFlow(self, IsSubFlow):
        self._IsSubFlow = IsSubFlow

    @property
    def SubFlowFlag(self):
        r"""Subprocess tag.
        :rtype: str
        """
        return self._SubFlowFlag

    @SubFlowFlag.setter
    def SubFlowFlag(self, SubFlowFlag):
        self._SubFlowFlag = SubFlowFlag

    @property
    def Status(self):
        r"""Step execution status. 0: not started, 1: in progress, 2: completed, 3: partially completed, -1: failed
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Desc(self):
        r"""Step running status description.
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Progress(self):
        r"""Running progress.
        :rtype: float
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Starttime(self):
        r"""Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Starttime

    @Starttime.setter
    def Starttime(self, Starttime):
        self._Starttime = Starttime

    @property
    def Endtime(self):
        r"""End time

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Endtime

    @Endtime.setter
    def Endtime(self, Endtime):
        self._Endtime = Endtime

    @property
    def HadWoodDetail(self):
        r"""Whether details are included.
        :rtype: bool
        """
        return self._HadWoodDetail

    @HadWoodDetail.setter
    def HadWoodDetail(self, HadWoodDetail):
        self._HadWoodDetail = HadWoodDetail

    @property
    def WoodJobId(self):
        r"""Wood subprocess ID.
        :rtype: int
        """
        return self._WoodJobId

    @WoodJobId.setter
    def WoodJobId(self, WoodJobId):
        self._WoodJobId = WoodJobId

    @property
    def LanguageKey(self):
        r"""Multi-language version key.
        :rtype: str
        """
        return self._LanguageKey

    @LanguageKey.setter
    def LanguageKey(self, LanguageKey):
        self._LanguageKey = LanguageKey

    @property
    def FailedReason(self):
        r"""Reason for stage failure.
        :rtype: str
        """
        return self._FailedReason

    @FailedReason.setter
    def FailedReason(self, FailedReason):
        self._FailedReason = FailedReason

    @property
    def TimeConsuming(self):
        r"""Step duration.
        :rtype: str
        """
        return self._TimeConsuming

    @TimeConsuming.setter
    def TimeConsuming(self, TimeConsuming):
        self._TimeConsuming = TimeConsuming

    @property
    def Id(self):
        r"""
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Stage = params.get("Stage")
        self._Name = params.get("Name")
        self._IsShow = params.get("IsShow")
        self._IsSubFlow = params.get("IsSubFlow")
        self._SubFlowFlag = params.get("SubFlowFlag")
        self._Status = params.get("Status")
        self._Desc = params.get("Desc")
        self._Progress = params.get("Progress")
        self._Starttime = params.get("Starttime")
        self._Endtime = params.get("Endtime")
        self._HadWoodDetail = params.get("HadWoodDetail")
        self._WoodJobId = params.get("WoodJobId")
        self._LanguageKey = params.get("LanguageKey")
        self._FailedReason = params.get("FailedReason")
        self._TimeConsuming = params.get("TimeConsuming")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StarRocksQueryInfo(AbstractModel):
    r"""StarRocks query information.

    """

    def __init__(self):
        r"""
        :param _ClientIP: Submission IP address.
        :type ClientIP: str
        :param _CPUCost: Total CPU time (ns).
        :type CPUCost: int
        :param _DefaultDB: Default DB.
        :type DefaultDB: str
        :param _EndTime: End time.
        :type EndTime: int
        :param _ExecutionIP: Execution IP address.
        :type ExecutionIP: str
        :param _QueryID: Query ID.
        :type QueryID: str
        :param _QueryType: Query type.
        :type QueryType: str
        :param _MemCost: Total memory consumed (bytes).
        :type MemCost: int
        :param _PlanCpuCosts: CPU usage (ns) at the plan stage.
        :type PlanCpuCosts: int
        :param _PlanMemCosts: Memory usage (bytes) at the plan stage.
        :type PlanMemCosts: int
        :param _QueryTime: Execution duration.
        :type QueryTime: int
        :param _ResourceGroup: Resource group.
        :type ResourceGroup: str
        :param _ReturnRows: Number of rows obtained.
        :type ReturnRows: int
        :param _ScanBytes: Scanned data volume (bytes).
        :type ScanBytes: int
        :param _ScanRows: Number of scanned rows.
        :type ScanRows: int
        :param _BeginTime: Start time.
        :type BeginTime: int
        :param _ExecutionState: Execution status.
        :type ExecutionState: str
        :param _ExecutionStatement: Execution statement.
        :type ExecutionStatement: str
        :param _User: User.
        :type User: str
        """
        self._ClientIP = None
        self._CPUCost = None
        self._DefaultDB = None
        self._EndTime = None
        self._ExecutionIP = None
        self._QueryID = None
        self._QueryType = None
        self._MemCost = None
        self._PlanCpuCosts = None
        self._PlanMemCosts = None
        self._QueryTime = None
        self._ResourceGroup = None
        self._ReturnRows = None
        self._ScanBytes = None
        self._ScanRows = None
        self._BeginTime = None
        self._ExecutionState = None
        self._ExecutionStatement = None
        self._User = None

    @property
    def ClientIP(self):
        r"""Submission IP address.
        :rtype: str
        """
        return self._ClientIP

    @ClientIP.setter
    def ClientIP(self, ClientIP):
        self._ClientIP = ClientIP

    @property
    def CPUCost(self):
        r"""Total CPU time (ns).
        :rtype: int
        """
        return self._CPUCost

    @CPUCost.setter
    def CPUCost(self, CPUCost):
        self._CPUCost = CPUCost

    @property
    def DefaultDB(self):
        r"""Default DB.
        :rtype: str
        """
        return self._DefaultDB

    @DefaultDB.setter
    def DefaultDB(self, DefaultDB):
        self._DefaultDB = DefaultDB

    @property
    def EndTime(self):
        r"""End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ExecutionIP(self):
        r"""Execution IP address.
        :rtype: str
        """
        return self._ExecutionIP

    @ExecutionIP.setter
    def ExecutionIP(self, ExecutionIP):
        self._ExecutionIP = ExecutionIP

    @property
    def QueryID(self):
        r"""Query ID.
        :rtype: str
        """
        return self._QueryID

    @QueryID.setter
    def QueryID(self, QueryID):
        self._QueryID = QueryID

    @property
    def QueryType(self):
        r"""Query type.
        :rtype: str
        """
        return self._QueryType

    @QueryType.setter
    def QueryType(self, QueryType):
        self._QueryType = QueryType

    @property
    def MemCost(self):
        r"""Total memory consumed (bytes).
        :rtype: int
        """
        return self._MemCost

    @MemCost.setter
    def MemCost(self, MemCost):
        self._MemCost = MemCost

    @property
    def PlanCpuCosts(self):
        r"""CPU usage (ns) at the plan stage.
        :rtype: int
        """
        return self._PlanCpuCosts

    @PlanCpuCosts.setter
    def PlanCpuCosts(self, PlanCpuCosts):
        self._PlanCpuCosts = PlanCpuCosts

    @property
    def PlanMemCosts(self):
        r"""Memory usage (bytes) at the plan stage.
        :rtype: int
        """
        return self._PlanMemCosts

    @PlanMemCosts.setter
    def PlanMemCosts(self, PlanMemCosts):
        self._PlanMemCosts = PlanMemCosts

    @property
    def QueryTime(self):
        r"""Execution duration.
        :rtype: int
        """
        return self._QueryTime

    @QueryTime.setter
    def QueryTime(self, QueryTime):
        self._QueryTime = QueryTime

    @property
    def ResourceGroup(self):
        r"""Resource group.
        :rtype: str
        """
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup

    @property
    def ReturnRows(self):
        r"""Number of rows obtained.
        :rtype: int
        """
        return self._ReturnRows

    @ReturnRows.setter
    def ReturnRows(self, ReturnRows):
        self._ReturnRows = ReturnRows

    @property
    def ScanBytes(self):
        r"""Scanned data volume (bytes).
        :rtype: int
        """
        return self._ScanBytes

    @ScanBytes.setter
    def ScanBytes(self, ScanBytes):
        self._ScanBytes = ScanBytes

    @property
    def ScanRows(self):
        r"""Number of scanned rows.
        :rtype: int
        """
        return self._ScanRows

    @ScanRows.setter
    def ScanRows(self, ScanRows):
        self._ScanRows = ScanRows

    @property
    def BeginTime(self):
        r"""Start time.
        :rtype: int
        """
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def ExecutionState(self):
        r"""Execution status.
        :rtype: str
        """
        return self._ExecutionState

    @ExecutionState.setter
    def ExecutionState(self, ExecutionState):
        self._ExecutionState = ExecutionState

    @property
    def ExecutionStatement(self):
        r"""Execution statement.
        :rtype: str
        """
        return self._ExecutionStatement

    @ExecutionStatement.setter
    def ExecutionStatement(self, ExecutionStatement):
        self._ExecutionStatement = ExecutionStatement

    @property
    def User(self):
        r"""User.
        :rtype: str
        """
        return self._User

    @User.setter
    def User(self, User):
        self._User = User


    def _deserialize(self, params):
        self._ClientIP = params.get("ClientIP")
        self._CPUCost = params.get("CPUCost")
        self._DefaultDB = params.get("DefaultDB")
        self._EndTime = params.get("EndTime")
        self._ExecutionIP = params.get("ExecutionIP")
        self._QueryID = params.get("QueryID")
        self._QueryType = params.get("QueryType")
        self._MemCost = params.get("MemCost")
        self._PlanCpuCosts = params.get("PlanCpuCosts")
        self._PlanMemCosts = params.get("PlanMemCosts")
        self._QueryTime = params.get("QueryTime")
        self._ResourceGroup = params.get("ResourceGroup")
        self._ReturnRows = params.get("ReturnRows")
        self._ScanBytes = params.get("ScanBytes")
        self._ScanRows = params.get("ScanRows")
        self._BeginTime = params.get("BeginTime")
        self._ExecutionState = params.get("ExecutionState")
        self._ExecutionStatement = params.get("ExecutionStatement")
        self._User = params.get("User")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartStopServiceOrMonitorRequest(AbstractModel):
    r"""StartStopServiceOrMonitor request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: The cluster ID.
        :type InstanceId: str
        :param _OpType: The operation type. Valid values:
<li>StartService: Start service</li>
<li>StopService: Stop service</li>
<li>StartMonitor: Start maintenance</li>
<li>StopMonitor: Stop maintenance</li>
<li>RestartService: Restart service. If this type is selected, "StrategyConfig" is required.</li>
        :type OpType: str
        :param _OpScope: The operation scope.
        :type OpScope: :class:`tencentcloud.emr.v20190103.models.OpScope`
        :param _StrategyConfig: The operation policy.
        :type StrategyConfig: :class:`tencentcloud.emr.v20190103.models.StrategyConfig`
        :param _StopParams: Parameters used for suspending services.
        :type StopParams: :class:`tencentcloud.emr.v20190103.models.StopParams`
        :param _KeepMonitorButNotRecoverProcess: This parameter is available only when OpType is <li>StopMonitor</li>. True indicates that the system enters the maintenance mode but still monitors processes without starting them.
        :type KeepMonitorButNotRecoverProcess: bool
        """
        self._InstanceId = None
        self._OpType = None
        self._OpScope = None
        self._StrategyConfig = None
        self._StopParams = None
        self._KeepMonitorButNotRecoverProcess = None

    @property
    def InstanceId(self):
        r"""The cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def OpType(self):
        r"""The operation type. Valid values:
<li>StartService: Start service</li>
<li>StopService: Stop service</li>
<li>StartMonitor: Start maintenance</li>
<li>StopMonitor: Stop maintenance</li>
<li>RestartService: Restart service. If this type is selected, "StrategyConfig" is required.</li>
        :rtype: str
        """
        return self._OpType

    @OpType.setter
    def OpType(self, OpType):
        self._OpType = OpType

    @property
    def OpScope(self):
        r"""The operation scope.
        :rtype: :class:`tencentcloud.emr.v20190103.models.OpScope`
        """
        return self._OpScope

    @OpScope.setter
    def OpScope(self, OpScope):
        self._OpScope = OpScope

    @property
    def StrategyConfig(self):
        r"""The operation policy.
        :rtype: :class:`tencentcloud.emr.v20190103.models.StrategyConfig`
        """
        return self._StrategyConfig

    @StrategyConfig.setter
    def StrategyConfig(self, StrategyConfig):
        self._StrategyConfig = StrategyConfig

    @property
    def StopParams(self):
        r"""Parameters used for suspending services.
        :rtype: :class:`tencentcloud.emr.v20190103.models.StopParams`
        """
        return self._StopParams

    @StopParams.setter
    def StopParams(self, StopParams):
        self._StopParams = StopParams

    @property
    def KeepMonitorButNotRecoverProcess(self):
        r"""This parameter is available only when OpType is <li>StopMonitor</li>. True indicates that the system enters the maintenance mode but still monitors processes without starting them.
        :rtype: bool
        """
        return self._KeepMonitorButNotRecoverProcess

    @KeepMonitorButNotRecoverProcess.setter
    def KeepMonitorButNotRecoverProcess(self, KeepMonitorButNotRecoverProcess):
        self._KeepMonitorButNotRecoverProcess = KeepMonitorButNotRecoverProcess


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._OpType = params.get("OpType")
        if params.get("OpScope") is not None:
            self._OpScope = OpScope()
            self._OpScope._deserialize(params.get("OpScope"))
        if params.get("StrategyConfig") is not None:
            self._StrategyConfig = StrategyConfig()
            self._StrategyConfig._deserialize(params.get("StrategyConfig"))
        if params.get("StopParams") is not None:
            self._StopParams = StopParams()
            self._StopParams._deserialize(params.get("StopParams"))
        self._KeepMonitorButNotRecoverProcess = params.get("KeepMonitorButNotRecoverProcess")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartStopServiceOrMonitorResponse(AbstractModel):
    r"""StartStopServiceOrMonitor response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopParams(AbstractModel):
    r"""Parameters used for stopping services.

    """

    def __init__(self):
        r"""
        :param _StopPolicy: Security mode: safe.
Default mode: default.
        :type StopPolicy: str
        :param _ThreadCount: Thread Count
        :type ThreadCount: int
        """
        self._StopPolicy = None
        self._ThreadCount = None

    @property
    def StopPolicy(self):
        r"""Security mode: safe.
Default mode: default.
        :rtype: str
        """
        return self._StopPolicy

    @StopPolicy.setter
    def StopPolicy(self, StopPolicy):
        self._StopPolicy = StopPolicy

    @property
    def ThreadCount(self):
        r"""Thread Count
        :rtype: int
        """
        return self._ThreadCount

    @ThreadCount.setter
    def ThreadCount(self, ThreadCount):
        self._ThreadCount = ThreadCount


    def _deserialize(self, params):
        self._StopPolicy = params.get("StopPolicy")
        self._ThreadCount = params.get("ThreadCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StorageSummaryDistribution(AbstractModel):
    r"""HDFS Cloud File Storage (CFS) details.

    """

    def __init__(self):
        r"""
        :param _MetricItem: Data item.
        :type MetricItem: str
        :param _MetricName: Data item description.
        :type MetricName: str
        :param _Dps: Sampling value.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Dps: list of Dps
        """
        self._MetricItem = None
        self._MetricName = None
        self._Dps = None

    @property
    def MetricItem(self):
        r"""Data item.
        :rtype: str
        """
        return self._MetricItem

    @MetricItem.setter
    def MetricItem(self, MetricItem):
        self._MetricItem = MetricItem

    @property
    def MetricName(self):
        r"""Data item description.
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def Dps(self):
        r"""Sampling value.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Dps
        """
        return self._Dps

    @Dps.setter
    def Dps(self, Dps):
        self._Dps = Dps


    def _deserialize(self, params):
        self._MetricItem = params.get("MetricItem")
        self._MetricName = params.get("MetricName")
        if params.get("Dps") is not None:
            self._Dps = []
            for item in params.get("Dps"):
                obj = Dps()
                obj._deserialize(item)
                self._Dps.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StrategyConfig(AbstractModel):
    r"""Restart, stop, or start of service/monitoring configurations

    """

    def __init__(self):
        r"""
        :param _RollingRestartSwitch: 0: disable rolling restart.
1: enable rolling start.
        :type RollingRestartSwitch: int
        :param _BatchSize: Rolling restart quantity per batch, which is up to 99999.
        :type BatchSize: int
        :param _TimeWait: Stop and wait time for rolling restart per batch, with the maximum interval of 5 minutes and the unit of seconds.
        :type TimeWait: int
        :param _DealOnFail: Operation failure processing policy. 0: Block upon failure, 1: Automatically skipping failure.
        :type DealOnFail: int
        :param _Args: Parameters required in the instruction.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Args: list of Arg
        """
        self._RollingRestartSwitch = None
        self._BatchSize = None
        self._TimeWait = None
        self._DealOnFail = None
        self._Args = None

    @property
    def RollingRestartSwitch(self):
        r"""0: disable rolling restart.
1: enable rolling start.
        :rtype: int
        """
        return self._RollingRestartSwitch

    @RollingRestartSwitch.setter
    def RollingRestartSwitch(self, RollingRestartSwitch):
        self._RollingRestartSwitch = RollingRestartSwitch

    @property
    def BatchSize(self):
        r"""Rolling restart quantity per batch, which is up to 99999.
        :rtype: int
        """
        return self._BatchSize

    @BatchSize.setter
    def BatchSize(self, BatchSize):
        self._BatchSize = BatchSize

    @property
    def TimeWait(self):
        r"""Stop and wait time for rolling restart per batch, with the maximum interval of 5 minutes and the unit of seconds.
        :rtype: int
        """
        return self._TimeWait

    @TimeWait.setter
    def TimeWait(self, TimeWait):
        self._TimeWait = TimeWait

    @property
    def DealOnFail(self):
        r"""Operation failure processing policy. 0: Block upon failure, 1: Automatically skipping failure.
        :rtype: int
        """
        return self._DealOnFail

    @DealOnFail.setter
    def DealOnFail(self, DealOnFail):
        self._DealOnFail = DealOnFail

    @property
    def Args(self):
        r"""Parameters required in the instruction.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Arg
        """
        return self._Args

    @Args.setter
    def Args(self, Args):
        self._Args = Args


    def _deserialize(self, params):
        self._RollingRestartSwitch = params.get("RollingRestartSwitch")
        self._BatchSize = params.get("BatchSize")
        self._TimeWait = params.get("TimeWait")
        self._DealOnFail = params.get("DealOnFail")
        if params.get("Args") is not None:
            self._Args = []
            for item in params.get("Args"):
                obj = Arg()
                obj._deserialize(item)
                self._Args.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubnetInfo(AbstractModel):
    r"""Subnet information

    """

    def __init__(self):
        r"""
        :param _SubnetName: Subnet information (name).
        :type SubnetName: str
        :param _SubnetId: Subnet information (ID).
        :type SubnetId: str
        """
        self._SubnetName = None
        self._SubnetId = None

    @property
    def SubnetName(self):
        r"""Subnet information (name).
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

   