# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# The account already exists in the account group.
FAILEDOPERATION_ACCOUNTALREADYEXISTEDINACCOUNTGROUP = 'FailedOperation.AccountAlreadyExistedInAccountGroup'

# The account group name already exists.
FAILEDOPERATION_ACCOUNTGROUPNAMEEXISTED = 'FailedOperation.AccountGroupNameExisted'

# The account group does not exist
FAILEDOPERATION_ACCOUNTGROUPNOTEXISTED = 'FailedOperation.AccountGroupNotExisted'

# The account ID list cannot be empty.
FAILEDOPERATION_ACCOUNTIDSISNULL = 'FailedOperation.AccountIdsIsNull'

# The account name already exists.
FAILEDOPERATION_ACCOUNTNAMEEXISTED = 'FailedOperation.AccountNameExisted'

# The account does not exist.
FAILEDOPERATION_ACCOUNTNOTEXISTED = 'FailedOperation.AccountNotExisted'

# An exception occurred while adding the user to the user group.
FAILEDOPERATION_ADDUSERSTOUSERGROUP = 'FailedOperation.AddUsersToUserGroup'

# The application ID cannot be empty.
FAILEDOPERATION_APPIDISNULL = 'FailedOperation.AppIdIsNull'

# The application ID does not exist.
FAILEDOPERATION_APPIDNOTFOUND = 'FailedOperation.AppIdNotFound'

# The application does not exist.
FAILEDOPERATION_APPNOTEXIST = 'FailedOperation.AppNotExist'

# A sub-organization with the same name already exists under the same organization.
FAILEDOPERATION_CHILDORGNODENAMEALREADYEXISTS = 'FailedOperation.ChildOrgNodeNameAlreadyExists'

# Organization nodes where sub-organizations have users cannot be deleted.
FAILEDOPERATION_CHILDORGNODEWITHUSERSCANNOTBEDELETED = 'FailedOperation.ChildOrgNodeWithUsersCanNotBeDeleted'

# Failed to create the organization node.
FAILEDOPERATION_CREATEORGNODEERROR = 'FailedOperation.CreateOrgNodeError'

# An exception occurred while creating the user.
FAILEDOPERATION_CREATEUSERFAILURE = 'FailedOperation.CreateUserFailure'

# An exception occurred while creating the user group.
FAILEDOPERATION_CREATEUSERGROUPFAILURE = 'FailedOperation.CreateUserGroupFailure'

# The external ID for the custom organization node already exists.
FAILEDOPERATION_CUSTOMIZEPARENTORGNODEIDALREADYEXISTS = 'FailedOperation.CustomizeParentOrgNodeIdAlreadyExists'

# The external ID for the custom organization node cannot be an empty string.
FAILEDOPERATION_CUSTOMIZEDORGNODEIDCANNOTBEEMPTY = 'FailedOperation.CustomizedOrgNodeIdCanNotBeEmpty'

# The default imported organization cannot be deleted.
FAILEDOPERATION_DEFAULTORGNODECANNOTBEDELETED = 'FailedOperation.DefaultOrgNodeCanNotBeDeleted'

# Failed to delete the organization node.
FAILEDOPERATION_DELETEORGNODEERROR = 'FailedOperation.DeleteOrgNodeError'

# The user is an admin and cannot be deleted.
FAILEDOPERATION_DELETEUSEREXISTSADMINISTRATOR = 'FailedOperation.DeleteUserExistsAdministrator'

# Failed to delete the user.
FAILEDOPERATION_DELETEUSERFAILURE = 'FailedOperation.DeleteUserFailure'

# An exception occurred while deleting the user group.
FAILEDOPERATION_DELETEUSERGROUPFAILURE = 'FailedOperation.DeleteUserGroupFailure'

# Failed to read the organization node information.
FAILEDOPERATION_DESCRIBEORGNODEERROR = 'FailedOperation.DescribeOrgNodeError'

# Failed to read the root organization node information.
FAILEDOPERATION_DESCRIBEORGNODEROOTERROR = 'FailedOperation.DescribeOrgNodeRootError'

# The value of `EntityType` is invalid.
FAILEDOPERATION_ENTITYTYPENOTEXISTED = 'FailedOperation.EntityTypeNotExisted'

# The user attribute type expected to be returned does not exist.
FAILEDOPERATION_EXPECTFIELDSNOTFOUND = 'FailedOperation.ExpectFieldsNotFound'

# The user group ID was not found.
FAILEDOPERATION_GROUPIDNOTFOUND = 'FailedOperation.GroupIdNotFound'

# Failed to convert the ID encoding.
FAILEDOPERATION_IDTOCODEERROR = 'FailedOperation.IdToCodeError'

# The number of data entries exceeds the upper limit.
FAILEDOPERATION_ITEMSEXCEEDMAXNUMBER = 'FailedOperation.ItemsExceedMaxNumber'

# You cannot add more than %s mappings for the same user in the same application.
FAILEDOPERATION_LIMITQUOTANOTENOUGH = 'FailedOperation.LimitQuotaNotEnough'

# Failed to retrieve the list of user groups that the user belongs to.
FAILEDOPERATION_LISTUSERGROUPSOFUSERERROR = 'FailedOperation.ListUserGroupsOfUserError'

# Failed to read users under the node.
FAILEDOPERATION_LISTUSERSINORGNODEERROR = 'FailedOperation.ListUsersInOrgNodeError'

# Failed to retrieve the list of users in the user group.
FAILEDOPERATION_LISTUSERSINUSERGROUPERROR = 'FailedOperation.ListUsersInUserGroupError'

# The primary organization does not exist.
FAILEDOPERATION_MAINORGNODENOTEXIST = 'FailedOperation.MainOrgNodeNotExist'

# The new password cannot be empty.
FAILEDOPERATION_NEWPASSWORDMUSTNOTBLANK = 'FailedOperation.NewPasswordMustNotBlank'

# Operation failed.
FAILEDOPERATION_OPERATIONERROR = 'FailedOperation.OperationError'

# The operation failed.
FAILEDOPERATION_OPERATIONFAILURE = 'FailedOperation.OperationFailure'

# The organization node ID does not exist.
FAILEDOPERATION_ORGNODEIDNOTEXIST = 'FailedOperation.OrgNodeIdNotExist'

# The organization node does not exist.
FAILEDOPERATION_ORGNODENOTEXIST = 'FailedOperation.OrgNodeNotExist'

# The root organization node cannot be deleted.
FAILEDOPERATION_ORGNODEROOTCANNOTBEDELETED = 'FailedOperation.OrgNodeRootCanNotBeDeleted'

# Failed to set up the organization. The organization cannot be selected as both the primary and secondary organization for the user.
FAILEDOPERATION_ORGNODESETTINGERROR = 'FailedOperation.OrgNodeSettingError'

# Organization nodes with users cannot be deleted.
FAILEDOPERATION_ORGNODEWITHUSERSCANNOTBEDELETED = 'FailedOperation.OrgNodeWithUsersCanNotBeDeleted'

# The parent organization node ID was not found.
FAILEDOPERATION_PARENTORGNODEIDNOTFOUND = 'FailedOperation.ParentOrgNodeIdNotFound'

# The identity entity was not found.
FAILEDOPERATION_PERSONNOTFOUND = 'FailedOperation.PersonNotFound'

# Failed to remove the user from the user group.
FAILEDOPERATION_REMOVEUSERSFROMUSERGROUPERROR = 'FailedOperation.RemoveUsersFromUserGroupError'

# Duplicate element in secondary organization.
FAILEDOPERATION_SECONDARYORGNODEDUPLICATES = 'FailedOperation.SecondaryOrgNodeDuplicates'

# You cannot move users imported from LDAP to an organization not in the directory.
FAILEDOPERATION_UPDATELDAPUSERORGEXCEEDSRANGE = 'FailedOperation.UpdateLDAPUserOrgExceedsRange'

# Cannot move LDAP-imported users to an enterprise organization under another directory.
FAILEDOPERATION_UPDATELDAPUSERORGNOTINSAMECROP = 'FailedOperation.UpdateLDAPUserOrgNotInSameCrop'

# You cannot move users created by the admin to an organization with the sync operation type.
FAILEDOPERATION_UPDATEUSEREXCEEDSRANGE = 'FailedOperation.UpdateUserExceedsRange'

# You cannot move WeCom users to an organization outside your enterprise.
FAILEDOPERATION_UPDATEWECOMUSERORGEXCEEDSRANGE = 'FailedOperation.UpdateWeComUserOrgExceedsRange'

# You cannot move WeCom users to a different enterprise organization.
FAILEDOPERATION_UPDATEWECOMUSERORGNOTINSAMECROP = 'FailedOperation.UpdateWeComUserOrgNotInSameCrop'

# The user already exists in the user group.
FAILEDOPERATION_USERALREADYEXISTEDINUSERGROUP = 'FailedOperation.UserAlreadyExistedInUserGroup'

# Failed to retrieve the list of applications the user is authorized to access.
FAILEDOPERATION_USERAUTHLISTERROR = 'FailedOperation.UserAuthListError'

# The user's email address already exists.
FAILEDOPERATION_USEREMAILEXISTED = 'FailedOperation.UserEmailExisted'

# The user group does not exist.
FAILEDOPERATION_USERGROUPNOTEXIST = 'FailedOperation.UserGroupNotExist'

# Username already exists.
FAILEDOPERATION_USERNAMEALREADYEXISTS = 'FailedOperation.UserNameAlreadyExists'

# The user is not a member of the user group.
FAILEDOPERATION_USERNOTEXISTINUSERGROUP = 'FailedOperation.UserNotExistInUserGroup'

# The user does not exist.
FAILEDOPERATION_USERNOTFOUND = 'FailedOperation.UserNotFound'

# The mobile phone number already exists.
FAILEDOPERATION_USERPHONEALREADYEXISTS = 'FailedOperation.UserPhoneAlreadyExists'

# The user's mobile number cannot be empty.
FAILEDOPERATION_USERPHONEISEMPTY = 'FailedOperation.UserPhoneIsEmpty'

# The application name already exists.
INVALIDPARAMETER_APPDISPLAYNAMEEXISTED = 'InvalidParameter.AppDisplayNameExisted'

# Attribute validation failed.
INVALIDPARAMETER_ATTRIBUTEVALUEVALIDERROR = 'InvalidParameter.AttributeValueValidError'

# Organization code is invalid.
INVALIDPARAMETER_ORGCODEILLEGAL = 'InvalidParameter.OrgCodeIllegal'

# The parameter is invalid.
INVALIDPARAMETER_PARAMETERILLEGAL = 'InvalidParameter.ParameterIllegal'

# The parameter is invalid.
INVALIDPARAMETER_PARAMETERLLLEGAL = 'InvalidParameter.Parameterlllegal'

# Invalid list search criteria.
INVALIDPARAMETER_SEARCHCRITERIAILLEGAL = 'InvalidParameter.SearchCriteriaIllegal'

# Invalid time format.
INVALIDPARAMETER_TIMEFORMATILLEGAL = 'InvalidParameter.TimeFormatIllegal'

# The specified user expiration time is invalid.
INVALIDPARAMETER_USEREXPIRATIONTIMEILLEGAL = 'InvalidParameter.UserExpirationTimeIllegal'

# The user ID parameter is empty.
INVALIDPARAMETER_USERIDISNULL = 'InvalidParameter.UserIDIsNull'

# Invalid sorting attribute for paginated user information display.
INVALIDPARAMETER_USERINFOSORTKEYISILLEGAL = 'InvalidParameter.UserInfoSortKeyIsIllegal'

# The username parameter is empty.
INVALIDPARAMETER_USERNAMEISNULL = 'InvalidParameter.UserNameIsNull'

# Invalid parameter.
INVALIDPARAMETERVALUE_PARAMETERILLEGAL = 'InvalidParameterValue.ParameterIllegal'

# User ID cannot be empty.
INVALIDPARAMETERVALUE_USERIDCANNOTBEEMPTY = 'InvalidParameterValue.UserIdCanNotBeEmpty'

# Username cannot be empty.
INVALIDPARAMETERVALUE_USERNAMECANNOTBEEMPTY = 'InvalidParameterValue.UserNameCanNotBeEmpty'

# Input parameter exceeds the length limit.
LIMITEXCEEDED_PARAMETERLENGTHLIMITEXCEEDED = 'LimitExceeded.ParameterLengthLimitExceeded'

# User secondary organizations exceed the maximum limit.
LIMITEXCEEDED_SECONDARYNODECOUNTLIMITEXCEEDED = 'LimitExceeded.SecondaryNodeCountLimitExceeded'
