# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AccessInfo(AbstractModel):
    r"""Information about visits to the engine

    """

    def __init__(self):
        r"""
        :param _AccessType: Methods to visit the engine
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessType: str
        :param _AccessConnectionInfos: URL that visits the engine and part of internal parameters should be taken place according to the actual situation.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessConnectionInfos: list of str
        """
        self._AccessType = None
        self._AccessConnectionInfos = None

    @property
    def AccessType(self):
        r"""Methods to visit the engine
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def AccessConnectionInfos(self):
        r"""URL that visits the engine and part of internal parameters should be taken place according to the actual situation.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._AccessConnectionInfos

    @AccessConnectionInfos.setter
    def AccessConnectionInfos(self, AccessConnectionInfos):
        self._AccessConnectionInfos = AccessConnectionInfos


    def _deserialize(self, params):
        self._AccessType = params.get("AccessType")
        self._AccessConnectionInfos = params.get("AccessConnectionInfos")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddUsersToWorkGroupRequest(AbstractModel):
    r"""AddUsersToWorkGroup request structure.

    """

    def __init__(self):
        r"""
        :param _AddInfo: Information about working groups and users to be operated
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""Information about working groups and users to be operated
        :rtype: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = UserIdSetOfWorkGroupId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddUsersToWorkGroupResponse(AbstractModel):
    r"""AddUsersToWorkGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AlterDMSDatabaseRequest(AbstractModel):
    r"""AlterDMSDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _CurrentName: Current name
        :type CurrentName: str
        :param _SchemaName: Schema name
        :type SchemaName: str
        :param _Location: Path
        :type Location: str
        :param _Asset: Basic object
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        self._CurrentName = None
        self._SchemaName = None
        self._Location = None
        self._Asset = None

    @property
    def CurrentName(self):
        r"""Current name
        :rtype: str
        """
        return self._CurrentName

    @CurrentName.setter
    def CurrentName(self, CurrentName):
        self._CurrentName = CurrentName

    @property
    def SchemaName(self):
        r"""Schema name
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""Path
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Asset(self):
        r"""Basic object
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset


    def _deserialize(self, params):
        self._CurrentName = params.get("CurrentName")
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlterDMSDatabaseResponse(AbstractModel):
    r"""AlterDMSDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Asset(AbstractModel):
    r"""Basic metadata object

    """

    def __init__(self):
        r"""
        :param _Id: Primary key
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: int
        :param _Name: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Guid: Object GUID value
Note: This field may return null, indicating that no valid values can be obtained.
        :type Guid: str
        :param _Catalog: Data directory
Note: This field may return null, indicating that no valid values can be obtained.
        :type Catalog: str
        :param _Description: Description information
        :type Description: str
        :param _Owner: Object owner
        :type Owner: str
        :param _OwnerAccount: Object owner account
        :type OwnerAccount: str
        :param _PermValues: Permission
        :type PermValues: list of KVPair
        :param _Params: Additional attributes
        :type Params: list of KVPair
        :param _BizParams: Additional business attributes
        :type BizParams: list of KVPair
        :param _DataVersion: Data version
        :type DataVersion: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ModifiedTime: Modification time
        :type ModifiedTime: str
        :param _DatasourceId: Data source primary key
        :type DatasourceId: int
        """
        self._Id = None
        self._Name = None
        self._Guid = None
        self._Catalog = None
        self._Description = None
        self._Owner = None
        self._OwnerAccount = None
        self._PermValues = None
        self._Params = None
        self._BizParams = None
        self._DataVersion = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._DatasourceId = None

    @property
    def Id(self):
        r"""Primary key
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        r"""Name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Guid(self):
        r"""Object GUID value
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Guid

    @Guid.setter
    def Guid(self, Guid):
        self._Guid = Guid

    @property
    def Catalog(self):
        r"""Data directory
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Description(self):
        r"""Description information
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Owner(self):
        r"""Object owner
        :rtype: str
        """
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def OwnerAccount(self):
        r"""Object owner account
        :rtype: str
        """
        return self._OwnerAccount

    @OwnerAccount.setter
    def OwnerAccount(self, OwnerAccount):
        self._OwnerAccount = OwnerAccount

    @property
    def PermValues(self):
        r"""Permission
        :rtype: list of KVPair
        """
        return self._PermValues

    @PermValues.setter
    def PermValues(self, PermValues):
        self._PermValues = PermValues

    @property
    def Params(self):
        r"""Additional attributes
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def BizParams(self):
        r"""Additional business attributes
        :rtype: list of KVPair
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def DataVersion(self):
        r"""Data version
        :rtype: int
        """
        return self._DataVersion

    @DataVersion.setter
    def DataVersion(self, DataVersion):
        self._DataVersion = DataVersion

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""Modification time
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def DatasourceId(self):
        r"""Data source primary key
        :rtype: int
        """
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Guid = params.get("Guid")
        self._Catalog = params.get("Catalog")
        self._Description = params.get("Description")
        self._Owner = params.get("Owner")
        self._OwnerAccount = params.get("OwnerAccount")
        if params.get("PermValues") is not None:
            self._PermValues = []
            for item in params.get("PermValues"):
                obj = KVPair()
                obj._deserialize(item)
                self._PermValues.append(obj)
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("BizParams") is not None:
            self._BizParams = []
            for item in params.get("BizParams"):
                obj = KVPair()
                obj._deserialize(item)
                self._BizParams.append(obj)
        self._DataVersion = params.get("DataVersion")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._DatasourceId = params.get("DatasourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachDataMaskPolicyRequest(AbstractModel):
    r"""AttachDataMaskPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _DataMaskStrategyPolicySet: Collection of DMask permission objects that should be bound.
        :type DataMaskStrategyPolicySet: list of DataMaskStrategyPolicy
        """
        self._DataMaskStrategyPolicySet = None

    @property
    def DataMaskStrategyPolicySet(self):
        r"""Collection of DMask permission objects that should be bound.
        :rtype: list of DataMaskStrategyPolicy
        """
        return self._DataMaskStrategyPolicySet

    @DataMaskStrategyPolicySet.setter
    def DataMaskStrategyPolicySet(self, DataMaskStrategyPolicySet):
        self._DataMaskStrategyPolicySet = DataMaskStrategyPolicySet


    def _deserialize(self, params):
        if params.get("DataMaskStrategyPolicySet") is not None:
            self._DataMaskStrategyPolicySet = []
            for item in params.get("DataMaskStrategyPolicySet"):
                obj = DataMaskStrategyPolicy()
                obj._deserialize(item)
                self._DataMaskStrategyPolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachDataMaskPolicyResponse(AbstractModel):
    r"""AttachDataMaskPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachUserPolicyRequest(AbstractModel):
    r"""AttachUserPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID, which is the same as the sub-user UIN. The CreateUser API is needed to create a user at first. The DescribeUsers API can be used for viewing.
        :type UserId: str
        :param _PolicySet: Collection of authentication policies
        :type PolicySet: list of Policy
        """
        self._UserId = None
        self._PolicySet = None

    @property
    def UserId(self):
        r"""User ID, which is the same as the sub-user UIN. The CreateUser API is needed to create a user at first. The DescribeUsers API can be used for viewing.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PolicySet(self):
        r"""Collection of authentication policies
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachUserPolicyResponse(AbstractModel):
    r"""AttachUserPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachWorkGroupPolicyRequest(AbstractModel):
    r"""AttachWorkGroupPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group IDs
        :type WorkGroupId: int
        :param _PolicySet: Collection of policies to be bound
        :type PolicySet: list of Policy
        """
        self._WorkGroupId = None
        self._PolicySet = None

    @property
    def WorkGroupId(self):
        r"""Working group IDs
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def PolicySet(self):
        r"""Collection of policies to be bound
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachWorkGroupPolicyResponse(AbstractModel):
    r"""AttachWorkGroupPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BindWorkGroupsToUserRequest(AbstractModel):
    r"""BindWorkGroupsToUser request structure.

    """

    def __init__(self):
        r"""
        :param _AddInfo: Information about bound working groups and users
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.WorkGroupIdSetOfUserId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""Information about bound working groups and users
        :rtype: :class:`tencentcloud.dlc.v20210125.models.WorkGroupIdSetOfUserId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = WorkGroupIdSetOfUserId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindWorkGroupsToUserResponse(AbstractModel):
    r"""BindWorkGroupsToUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CHDFSProductVpcInfo(AbstractModel):
    r"""VPC information of CHDFS products

    """

    def __init__(self):
        r"""
        :param _VpcId: vpc id

Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _VpcName: VPC name
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcName: str
        :param _VpcCidrBlock: VPC subnet information list
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcCidrBlock: list of VpcCidrBlock
        :param _RuleId: Rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _AccessGroupId: Permission group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessGroupId: str
        """
        self._VpcId = None
        self._VpcName = None
        self._VpcCidrBlock = None
        self._RuleId = None
        self._AccessGroupId = None

    @property
    def VpcId(self):
        r"""vpc id

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcName(self):
        r"""VPC name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def VpcCidrBlock(self):
        r"""VPC subnet information list
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of VpcCidrBlock
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def RuleId(self):
        r"""Rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def AccessGroupId(self):
        r"""Permission group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessGroupId

    @AccessGroupId.setter
    def AccessGroupId(self, AccessGroupId):
        self._AccessGroupId = AccessGroupId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpcName = params.get("VpcName")
        if params.get("VpcCidrBlock") is not None:
            self._VpcCidrBlock = []
            for item in params.get("VpcCidrBlock"):
                obj = VpcCidrBlock()
                obj._deserialize(item)
                self._VpcCidrBlock.append(obj)
        self._RuleId = params.get("RuleId")
        self._AccessGroupId = params.get("AccessGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelSparkSessionBatchSQLRequest(AbstractModel):
    r"""CancelSparkSessionBatchSQL request structure.

    """

    def __init__(self):
        r"""
        :param _BatchId: The unique identifier of a batch task.
        :type BatchId: str
        :param _CustomKey: User-defined primary key. If it is specified, the value should be used for querying.
        :type CustomKey: str
        """
        self._BatchId = None
        self._CustomKey = None

    @property
    def BatchId(self):
        r"""The unique identifier of a batch task.
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def CustomKey(self):
        r"""User-defined primary key. If it is specified, the value should be used for querying.
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._CustomKey = params.get("CustomKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelSparkSessionBatchSQLResponse(AbstractModel):
    r"""CancelSparkSessionBatchSQL response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelTaskRequest(AbstractModel):
    r"""CancelTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Globally unique task ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Globally unique task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelTaskResponse(AbstractModel):
    r"""CancelTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CheckDataEngineConfigPairsValidityRequest(AbstractModel):
    r"""CheckDataEngineConfigPairsValidity request structure.

    """

    def __init__(self):
        r"""
        :param _ChildImageVersionId: ID of the minor version of the engine
        :type ChildImageVersionId: str
        :param _DataEngineConfigPairs: User-defined parameters
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _ImageVersionId: ID of the major version of the engine. If there is the ID of the minor version, only the ID of the minor version needs to be input. If not, the latest ID of the minor version under the major version will be acquired.
        :type ImageVersionId: str
        """
        self._ChildImageVersionId = None
        self._DataEngineConfigPairs = None
        self._ImageVersionId = None

    @property
    def ChildImageVersionId(self):
        r"""ID of the minor version of the engine
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def DataEngineConfigPairs(self):
        r"""User-defined parameters
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def ImageVersionId(self):
        r"""ID of the major version of the engine. If there is the ID of the minor version, only the ID of the minor version needs to be input. If not, the latest ID of the minor version under the major version will be acquired.
        :rtype: str
        """
        return self._ImageVersionId

    @ImageVersionId.setter
    def ImageVersionId(self, ImageVersionId):
        self._ImageVersionId = ImageVersionId


    def _deserialize(self, params):
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        self._ImageVersionId = params.get("ImageVersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDataEngineConfigPairsValidityResponse(AbstractModel):
    r"""CheckDataEngineConfigPairsValidity response structure.

    """

    def __init__(self):
        r"""
        :param _IsAvailable: Validity of parameters. true: valid; false: There is at least one invalid parameter.
        :type IsAvailable: bool
        :param _UnavailableConfig: Collection of invalid parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type UnavailableConfig: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsAvailable = None
        self._UnavailableConfig = None
        self._RequestId = None

    @property
    def IsAvailable(self):
        r"""Validity of parameters. true: valid; false: There is at least one invalid parameter.
        :rtype: bool
        """
        return self._IsAvailable

    @IsAvailable.setter
    def IsAvailable(self, IsAvailable):
        self._IsAvailable = IsAvailable

    @property
    def UnavailableConfig(self):
        r"""Collection of invalid parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._UnavailableConfig

    @UnavailableConfig.setter
    def UnavailableConfig(self, UnavailableConfig):
        self._UnavailableConfig = UnavailableConfig

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsAvailable = params.get("IsAvailable")
        self._UnavailableConfig = params.get("UnavailableConfig")
        self._RequestId = params.get("RequestId")


class CheckDataEngineImageCanBeRollbackRequest(AbstractModel):
    r"""CheckDataEngineImageCanBeRollback request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Unique engine ID
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""Unique engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDataEngineImageCanBeRollbackResponse(AbstractModel):
    r"""CheckDataEngineImageCanBeRollback response structure.

    """

    def __init__(self):
        r"""
        :param _ToRecordId: Log record ID after rolling back
        :type ToRecordId: str
        :param _FromRecordId: Log record ID before rolling back
        :type FromRecordId: str
        :param _IsRollback: Whether it can be rolled back
        :type IsRollback: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ToRecordId = None
        self._FromRecordId = None
        self._IsRollback = None
        self._RequestId = None

    @property
    def ToRecordId(self):
        r"""Log record ID after rolling back
        :rtype: str
        """
        return self._ToRecordId

    @ToRecordId.setter
    def ToRecordId(self, ToRecordId):
        self._ToRecordId = ToRecordId

    @property
    def FromRecordId(self):
        r"""Log record ID before rolling back
        :rtype: str
        """
        return self._FromRecordId

    @FromRecordId.setter
    def FromRecordId(self, FromRecordId):
        self._FromRecordId = FromRecordId

    @property
    def IsRollback(self):
        r"""Whether it can be rolled back
        :rtype: bool
        """
        return self._IsRollback

    @IsRollback.setter
    def IsRollback(self, IsRollback):
        self._IsRollback = IsRollback

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ToRecordId = params.get("ToRecordId")
        self._FromRecordId = params.get("FromRecordId")
        self._IsRollback = params.get("IsRollback")
        self._RequestId = params.get("RequestId")


class CheckDataEngineImageCanBeUpgradeRequest(AbstractModel):
    r"""CheckDataEngineImageCanBeUpgrade request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Cluster ID
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDataEngineImageCanBeUpgradeResponse(AbstractModel):
    r"""CheckDataEngineImageCanBeUpgrade response structure.

    """

    def __init__(self):
        r"""
        :param _ChildImageVersionId: ID of the minor version of the cluster image that can be updated under the major version
        :type ChildImageVersionId: str
        :param _IsUpgrade: Whether it can be updated
        :type IsUpgrade: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ChildImageVersionId = None
        self._IsUpgrade = None
        self._RequestId = None

    @property
    def ChildImageVersionId(self):
        r"""ID of the minor version of the cluster image that can be updated under the major version
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def IsUpgrade(self):
        r"""Whether it can be updated
        :rtype: bool
        """
        return self._IsUpgrade

    @IsUpgrade.setter
    def IsUpgrade(self, IsUpgrade):
        self._IsUpgrade = IsUpgrade

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._IsUpgrade = params.get("IsUpgrade")
        self._RequestId = params.get("RequestId")


class CheckGrantedPermissionRequest(AbstractModel):
    r"""CheckGrantedPermission request structure.

    """

    def __init__(self):
        r"""
        :param _CheckPermission: Permission check
        :type CheckPermission: list of CheckPermission
        """
        self._CheckPermission = None

    @property
    def CheckPermission(self):
        r"""Permission check
        :rtype: list of CheckPermission
        """
        return self._CheckPermission

    @CheckPermission.setter
    def CheckPermission(self, CheckPermission):
        self._CheckPermission = CheckPermission


    def _deserialize(self, params):
        if params.get("CheckPermission") is not None:
            self._CheckPermission = []
            for item in params.get("CheckPermission"):
                obj = CheckPermission()
                obj._deserialize(item)
                self._CheckPermission.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckGrantedPermissionResponse(AbstractModel):
    r"""CheckGrantedPermission response structure.

    """

    def __init__(self):
        r"""
        :param _PermissionResponses: Permission status
        :type PermissionResponses: list of PermissionResponseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PermissionResponses = None
        self._RequestId = None

    @property
    def PermissionResponses(self):
        r"""Permission status
        :rtype: list of PermissionResponseInfo
        """
        return self._PermissionResponses

    @PermissionResponses.setter
    def PermissionResponses(self, PermissionResponses):
        self._PermissionResponses = PermissionResponses

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PermissionResponses") is not None:
            self._PermissionResponses = []
            for item in params.get("PermissionResponses"):
                obj = PermissionResponseInfo()
                obj._deserialize(item)
                self._PermissionResponses.append(obj)
        self._RequestId = params.get("RequestId")


class CheckPermission(AbstractModel):
    r"""Check permission information

    """

    def __init__(self):
        r"""
        :param _AccessType: Permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessType: str
        :param _ResourceBaseInfo: Resource information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceBaseInfo: :class:`tencentcloud.dlc.v20210125.models.ResourceBaseInfo`
        """
        self._AccessType = None
        self._ResourceBaseInfo = None

    @property
    def AccessType(self):
        r"""Permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def ResourceBaseInfo(self):
        r"""Resource information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ResourceBaseInfo`
        """
        return self._ResourceBaseInfo

    @ResourceBaseInfo.setter
    def ResourceBaseInfo(self, ResourceBaseInfo):
        self._ResourceBaseInfo = ResourceBaseInfo


    def _deserialize(self, params):
        self._AccessType = params.get("AccessType")
        if params.get("ResourceBaseInfo") is not None:
            self._ResourceBaseInfo = ResourceBaseInfo()
            self._ResourceBaseInfo._deserialize(params.get("ResourceBaseInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Column(AbstractModel):
    r"""Column information of the data table.

    """

    def __init__(self):
        r"""
        :param _Name: Column name, which is case-insensitive and can contain up to 25 characters.
        :type Name: str
        :param _Type: Column type. Valid values:
string|tinyint|smallint|int|bigint|boolean|float|double|decimal|timestamp|date|binary|array<data_type>|map<primitive_type, data_type>|struct<col_name : data_type [COMMENT col_comment], ...>|uniontype<data_type, data_type, ...>.
        :type Type: str
        :param _Comment: Class comment.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Comment: str
        :param _Precision: Length of the entire numeric value
Note: This field may return null, indicating that no valid values can be obtained.
        :type Precision: int
        :param _Scale: Length of the decimal part
Note: This field may return null, indicating that no valid values can be obtained.
        :type Scale: int
        :param _Nullable: Whether the column is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Nullable: str
        :param _Position: Field position
Note: This field may return null, indicating that no valid values can be obtained.
        :type Position: int
        :param _CreateTime: Field creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _ModifiedTime: Field modification time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifiedTime: str
        :param _IsPartition: Whether the column is the partition field.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsPartition: bool
        """
        self._Name = None
        self._Type = None
        self._Comment = None
        self._Precision = None
        self._Scale = None
        self._Nullable = None
        self._Position = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._IsPartition = None

    @property
    def Name(self):
        r"""Column name, which is case-insensitive and can contain up to 25 characters.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""Column type. Valid values:
string|tinyint|smallint|int|bigint|boolean|float|double|decimal|timestamp|date|binary|array<data_type>|map<primitive_type, data_type>|struct<col_name : data_type [COMMENT col_comment], ...>|uniontype<data_type, data_type, ...>.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        r"""Class comment.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Precision(self):
        r"""Length of the entire numeric value
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Precision

    @Precision.setter
    def Precision(self, Precision):
        self._Precision = Precision

    @property
    def Scale(self):
        r"""Length of the decimal part
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Scale

    @Scale.setter
    def Scale(self, Scale):
        self._Scale = Scale

    @property
    def Nullable(self):
        r"""Whether the column is null.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Nullable

    @Nullable.setter
    def Nullable(self, Nullable):
        self._Nullable = Nullable

    @property
    def Position(self):
        r"""Field position
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def CreateTime(self):
        r"""Field creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""Field modification time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def IsPartition(self):
        r"""Whether the column is the partition field.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._Precision = params.get("Precision")
        self._Scale = params.get("Scale")
        self._Nullable = params.get("Nullable")
        self._Position = params.get("Position")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._IsPartition = params.get("IsPartition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMetrics(AbstractModel):
    r"""Common task metrics

    """

    def __init__(self):
        r"""
        :param _CreateTaskTime: Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTaskTime: float
        :param _ProcessTime: Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessTime: float
        :param _QueueTime: Note: This field may return null, indicating that no valid values can be obtained.
        :type QueueTime: float
        :param _ExecutionTime: Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutionTime: float
        :param _IsResultCacheHit: Note: This field may return null, indicating that no valid values can be obtained.
        :type IsResultCacheHit: bool
        :param _MatchedMVBytes: Note: This field may return null, indicating that no valid values can be obtained.
        :type MatchedMVBytes: int
        :param _MatchedMVs: Note: This field may return null, indicating that no valid values can be obtained.
        :type MatchedMVs: str
        :param _AffectedBytes: Note: This field may return null, indicating that no valid values can be obtained.
        :type AffectedBytes: str
        :param _AffectedRows: Note: This field may return null, indicating that no valid values can be obtained.
        :type AffectedRows: int
        :param _ProcessedBytes: Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessedBytes: int
        :param _ProcessedRows: Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessedRows: int
        """
        self._CreateTaskTime = None
        self._ProcessTime = None
        self._QueueTime = None
        self._ExecutionTime = None
        self._IsResultCacheHit = None
        self._MatchedMVBytes = None
        self._MatchedMVs = None
        self._AffectedBytes = None
        self._AffectedRows = None
        self._ProcessedBytes = None
        self._ProcessedRows = None

    @property
    def CreateTaskTime(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._CreateTaskTime

    @CreateTaskTime.setter
    def CreateTaskTime(self, CreateTaskTime):
        self._CreateTaskTime = CreateTaskTime

    @property
    def ProcessTime(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._ProcessTime

    @ProcessTime.setter
    def ProcessTime(self, ProcessTime):
        self._ProcessTime = ProcessTime

    @property
    def QueueTime(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._QueueTime

    @QueueTime.setter
    def QueueTime(self, QueueTime):
        self._QueueTime = QueueTime

    @property
    def ExecutionTime(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._ExecutionTime

    @ExecutionTime.setter
    def ExecutionTime(self, ExecutionTime):
        self._ExecutionTime = ExecutionTime

    @property
    def IsResultCacheHit(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsResultCacheHit

    @IsResultCacheHit.setter
    def IsResultCacheHit(self, IsResultCacheHit):
        self._IsResultCacheHit = IsResultCacheHit

    @property
    def MatchedMVBytes(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._MatchedMVBytes

    @MatchedMVBytes.setter
    def MatchedMVBytes(self, MatchedMVBytes):
        self._MatchedMVBytes = MatchedMVBytes

    @property
    def MatchedMVs(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MatchedMVs

    @MatchedMVs.setter
    def MatchedMVs(self, MatchedMVs):
        self._MatchedMVs = MatchedMVs

    @property
    def AffectedBytes(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AffectedBytes

    @AffectedBytes.setter
    def AffectedBytes(self, AffectedBytes):
        self._AffectedBytes = AffectedBytes

    @property
    def AffectedRows(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AffectedRows

    @AffectedRows.setter
    def AffectedRows(self, AffectedRows):
        self._AffectedRows = AffectedRows

    @property
    def ProcessedBytes(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ProcessedBytes

    @ProcessedBytes.setter
    def ProcessedBytes(self, ProcessedBytes):
        self._ProcessedBytes = ProcessedBytes

    @property
    def ProcessedRows(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ProcessedRows

    @ProcessedRows.setter
    def ProcessedRows(self, ProcessedRows):
        self._ProcessedRows = ProcessedRows


    def _deserialize(self, params):
        self._CreateTaskTime = params.get("CreateTaskTime")
        self._ProcessTime = params.get("ProcessTime")
        self._QueueTime = params.get("QueueTime")
        self._ExecutionTime = params.get("ExecutionTime")
        self._IsResultCacheHit = params.get("IsResultCacheHit")
        self._MatchedMVBytes = params.get("MatchedMVBytes")
        self._MatchedMVs = params.get("MatchedMVs")
        self._AffectedBytes = params.get("AffectedBytes")
        self._AffectedRows = params.get("AffectedRows")
        self._ProcessedBytes = params.get("ProcessedBytes")
        self._ProcessedRows = params.get("ProcessedRows")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyDLCTableRequest(AbstractModel):
    r"""CopyDLCTable request structure.

    """

    def __init__(self):
        r"""
        :param _SourceData: Description of the source data table name
        :type SourceData: list of DMSSourceDatabaseInfo
        :param _DestinationDatabaseName: Target database name
        :type DestinationDatabaseName: str
        :param _DestinationTableName: Target data table name
        :type DestinationTableName: str
        :param _DataEngineName: Engine name
        :type DataEngineName: str
        :param _IsCreateTable: Whether to create a new table
        :type IsCreateTable: bool
        :param _Catalog: Catalog name
        :type Catalog: str
        :param _ResourceGroupName: Resource group name
        :type ResourceGroupName: str
        """
        self._SourceData = None
        self._DestinationDatabaseName = None
        self._DestinationTableName = None
        self._DataEngineName = None
        self._IsCreateTable = None
        self._Catalog = None
        self._ResourceGroupName = None

    @property
    def SourceData(self):
        r"""Description of the source data table name
        :rtype: list of DMSSourceDatabaseInfo
        """
        return self._SourceData

    @SourceData.setter
    def SourceData(self, SourceData):
        self._SourceData = SourceData

    @property
    def DestinationDatabaseName(self):
        r"""Target database name
        :rtype: str
        """
        return self._DestinationDatabaseName

    @DestinationDatabaseName.setter
    def DestinationDatabaseName(self, DestinationDatabaseName):
        self._DestinationDatabaseName = DestinationDatabaseName

    @property
    def DestinationTableName(self):
        r"""Target data table name
        :rtype: str
        """
        return self._DestinationTableName

    @DestinationTableName.setter
    def DestinationTableName(self, DestinationTableName):
        self._DestinationTableName = DestinationTableName

    @property
    def DataEngineName(self):
        r"""Engine name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def IsCreateTable(self):
        r"""Whether to create a new table
        :rtype: bool
        """
        return self._IsCreateTable

    @IsCreateTable.setter
    def IsCreateTable(self, IsCreateTable):
        self._IsCreateTable = IsCreateTable

    @property
    def Catalog(self):
        r"""Catalog name
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def ResourceGroupName(self):
        r"""Resource group name
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        if params.get("SourceData") is not None:
            self._SourceData = []
            for item in params.get("SourceData"):
                obj = DMSSourceDatabaseInfo()
                obj._deserialize(item)
                self._SourceData.append(obj)
        self._DestinationDatabaseName = params.get("DestinationDatabaseName")
        self._DestinationTableName = params.get("DestinationTableName")
        self._DataEngineName = params.get("DataEngineName")
        self._IsCreateTable = params.get("IsCreateTable")
        self._Catalog = params.get("Catalog")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyDLCTableResponse(AbstractModel):
    r"""CopyDLCTable response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CosPermission(AbstractModel):
    r"""COS permissions

    """

    def __init__(self):
        r"""
        :param _CosPath: Note: This field may return null, indicating that no valid values can be obtained.
        :type CosPath: str
        :param _Permissions: Note: This field may return null, indicating that no valid values can be obtained.
        :type Permissions: list of str
        """
        self._CosPath = None
        self._Permissions = None

    @property
    def CosPath(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CosPath

    @CosPath.setter
    def CosPath(self, CosPath):
        self._CosPath = CosPath

    @property
    def Permissions(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions


    def _deserialize(self, params):
        self._CosPath = params.get("CosPath")
        self._Permissions = params.get("Permissions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCHDFSBindingProductRequest(AbstractModel):
    r"""CreateCHDFSBindingProduct request structure.

    """

    def __init__(self):
        r"""
        :param _MountPoint: Names of metadata acceleration buckets to be bound
        :type MountPoint: str
        :param _BucketType: Types of buckets which are divided into cos and lakefs
        :type BucketType: str
        :param _ProductName: Product name
        :type ProductName: str
        :param _EngineName: Engine name. When ProductName selects DLC products, this parameter must be specified. When ProductName selects other products, it can be unspecified.
        :type EngineName: str
        :param _VpcInfo: VPC information. When the product name is other, this parameter must be specified.
        :type VpcInfo: list of VpcInfo
        """
        self._MountPoint = None
        self._BucketType = None
        self._ProductName = None
        self._EngineName = None
        self._VpcInfo = None

    @property
    def MountPoint(self):
        r"""Names of metadata acceleration buckets to be bound
        :rtype: str
        """
        return self._MountPoint

    @MountPoint.setter
    def MountPoint(self, MountPoint):
        self._MountPoint = MountPoint

    @property
    def BucketType(self):
        r"""Types of buckets which are divided into cos and lakefs
        :rtype: str
        """
        return self._BucketType

    @BucketType.setter
    def BucketType(self, BucketType):
        self._BucketType = BucketType

    @property
    def ProductName(self):
        r"""Product name
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def EngineName(self):
        r"""Engine name. When ProductName selects DLC products, this parameter must be specified. When ProductName selects other products, it can be unspecified.
        :rtype: str
        """
        return self._EngineName

    @EngineName.setter
    def EngineName(self, EngineName):
        self._EngineName = EngineName

    @property
    def VpcInfo(self):
        r"""VPC information. When the product name is other, this parameter must be specified.
        :rtype: list of VpcInfo
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo


    def _deserialize(self, params):
        self._MountPoint = params.get("MountPoint")
        self._BucketType = params.get("BucketType")
        self._ProductName = params.get("ProductName")
        self._EngineName = params.get("EngineName")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = []
            for item in params.get("VpcInfo"):
                obj = VpcInfo()
                obj._deserialize(item)
                self._VpcInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCHDFSBindingProductResponse(AbstractModel):
    r"""CreateCHDFSBindingProduct response structure.

    """

    def __init__(self):
        r"""
        :param _MountPointAssociates: Binding information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MountPointAssociates: list of MountPointAssociates
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MountPointAssociates = None
        self._RequestId = None

    @property
    def MountPointAssociates(self):
        r"""Binding information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of MountPointAssociates
        """
        return self._MountPointAssociates

    @MountPointAssociates.setter
    def MountPointAssociates(self, MountPointAssociates):
        self._MountPointAssociates = MountPointAssociates

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MountPointAssociates") is not None:
            self._MountPointAssociates = []
            for item in params.get("MountPointAssociates"):
                obj = MountPointAssociates()
                obj._deserialize(item)
                self._MountPointAssociates.append(obj)
        self._RequestId = params.get("RequestId")


class CreateDLCTableRequest(AbstractModel):
    r"""CreateDLCTable request structure.

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: Data table configuration information
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _TableType: Table type
        :type TableType: str
        :param _Columns: Data table column information
        :type Columns: list of TColumn
        :param _Partitions: Data table partition information
        :type Partitions: list of TPartition
        :param _Properties: Data table attribute information
        :type Properties: list of Property
        :param _ExternalDataConfiguration: External table configuration information
        :type ExternalDataConfiguration: :class:`tencentcloud.dlc.v20210125.models.ExternalDataConfiguration`
        :param _DataEngineName: Engine name
        :type DataEngineName: str
        :param _ResourceGroupname: Resource group name
        :type ResourceGroupname: str
        """
        self._TableBaseInfo = None
        self._TableType = None
        self._Columns = None
        self._Partitions = None
        self._Properties = None
        self._ExternalDataConfiguration = None
        self._DataEngineName = None
        self._ResourceGroupname = None

    @property
    def TableBaseInfo(self):
        r"""Data table configuration information
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def TableType(self):
        r"""Table type
        :rtype: str
        """
        return self._TableType

    @TableType.setter
    def TableType(self, TableType):
        self._TableType = TableType

    @property
    def Columns(self):
        r"""Data table column information
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""Data table partition information
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""Data table attribute information
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def ExternalDataConfiguration(self):
        r"""External table configuration information
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ExternalDataConfiguration`
        """
        return self._ExternalDataConfiguration

    @ExternalDataConfiguration.setter
    def ExternalDataConfiguration(self, ExternalDataConfiguration):
        self._ExternalDataConfiguration = ExternalDataConfiguration

    @property
    def DataEngineName(self):
        r"""Engine name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupname(self):
        r"""Resource group name
        :rtype: str
        """
        return self._ResourceGroupname

    @ResourceGroupname.setter
    def ResourceGroupname(self, ResourceGroupname):
        self._ResourceGroupname = ResourceGroupname


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        self._TableType = params.get("TableType")
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        if params.get("ExternalDataConfiguration") is not None:
            self._ExternalDataConfiguration = ExternalDataConfiguration()
            self._ExternalDataConfiguration._deserialize(params.get("ExternalDataConfiguration"))
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupname = params.get("ResourceGroupname")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDLCTableResponse(AbstractModel):
    r"""CreateDLCTable response structure.

    """

    def __init__(self):
        r"""
        :param _DLCTable: DLC table information object
Note: This field may return null, indicating that no valid values can be obtained.
        :type DLCTable: :class:`tencentcloud.dlc.v20210125.models.DLCTable`
        :param _Execution: The SQL statement for creating a managed storage internal table
        :type Execution: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DLCTable = None
        self._Execution = None
        self._RequestId = None

    @property
    def DLCTable(self):
        r"""DLC table information object
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DLCTable`
        """
        return self._DLCTable

    @DLCTable.setter
    def DLCTable(self, DLCTable):
        self._DLCTable = DLCTable

    @property
    def Execution(self):
        r"""The SQL statement for creating a managed storage internal table
        :rtype: str
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DLCTable") is not None:
            self._DLCTable = DLCTable()
            self._DLCTable._deserialize(params.get("DLCTable"))
        self._Execution = params.get("Execution")
        self._RequestId = params.get("RequestId")


class CreateDMSDatabaseRequest(AbstractModel):
    r"""CreateDMSDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _Asset: Basic metadata object
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _SchemaName: Schema directory
        :type SchemaName: str
        :param _Location: Db storage path
        :type Location: str
        :param _Name: Database name
        :type Name: str
        """
        self._Asset = None
        self._SchemaName = None
        self._Location = None
        self._Name = None

    @property
    def Asset(self):
        r"""Basic metadata object
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def SchemaName(self):
        r"""Schema directory
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""Db storage path
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Name(self):
        r"""Database name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDMSDatabaseResponse(AbstractModel):
    r"""CreateDMSDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDataEngineRequest(AbstractModel):
    r"""CreateDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _EngineType: The engine type. Valid values: `spark` and `presto`.
        :type EngineType: str
        :param _DataEngineName: The name of the virtual cluster.
        :type DataEngineName: str
        :param _ClusterType: The cluster type. Valid values: `spark_private`, `presto_private`, `presto_cu`, and `spark_cu`.
        :type ClusterType: str
        :param _Mode: The billing mode. Valid values: `0` (shared engine), `1` (pay-as-you-go), and `2` (monthly subscription).
        :type Mode: int
        :param _AutoResume: Whether to automatically start the clusters.
        :type AutoResume: bool
        :param _MinClusters: The minimum number of clusters.
        :type MinClusters: int
        :param _MaxClusters: The maximum number of clusters.
        :type MaxClusters: int
        :param _DefaultDataEngine: Whether the cluster is the default one.
        :type DefaultDataEngine: bool
        :param _CidrBlock: The VPC CIDR block.
        :type CidrBlock: str
        :param _Message: The description.
        :type Message: str
        :param _Size: The cluster size.
        :type Size: int
        :param _PayMode: The pay mode. Valid value: `0` (postpaid, default) and `1` (prepaid) (currently not available).
        :type PayMode: int
        :param _TimeSpan: The usage duration of the resource. Postpaid: Fill in 3,600 as a fixed figure; prepaid: fill in a figure equal to or bigger than 1 which means purchasing resources for one month. The maximum figure is not bigger than 120. The default value is 1.
        :type TimeSpan: int
        :param _TimeUnit: The unit of the resource period. Valid values: `s` (default) for the postpaid mode and `m` for the prepaid mode.
        :type TimeUnit: str
        :param _AutoRenew: The auto-renewal status of the resource. For the postpaid mode, no renewal is required, and the value is fixed to `0`. For the prepaid mode, valid values are `0` (manual), `1` (auto), and `2` (no renewal). If this parameter is set to `0` for a key account in the prepaid mode, auto-renewal applies. It defaults to `0`.
        :type AutoRenew: int
        :param _Tags: The tags to be set for the resource being created.
        :type Tags: list of TagInfo
        :param _AutoSuspend: Whether to automatically suspend clusters. Valid values: `false` (default, no) and `true` (yes).
        :type AutoSuspend: bool
        :param _CrontabResumeSuspend: Whether to enable scheduled start and suspension of clusters. Valid values: `0` (disable) and `1` (enable). Note: This policy and the auto-suspension policy are mutually exclusive.
        :type CrontabResumeSuspend: int
        :param _CrontabResumeSuspendStrategy: The complex policy for scheduled start and suspension, including the start/suspension time and suspension policy.
        :type CrontabResumeSuspendStrategy: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        :param _EngineExecType: The type of tasks to be executed by the engine, which defaults to SQL. Valid values: `SQL` and `BATCH`.
        :type EngineExecType: str
        :param _MaxConcurrency: The max task concurrency of a cluster, which defaults to 5.
        :type MaxConcurrency: int
        :param _TolerableQueueTime: The task queue time limit, which defaults to 0. When the actual queue time exceeds the value set here, scale-out may be triggered. Setting this parameter to 0 represents that scale-out may be triggered immediately after a task queues up.
        :type TolerableQueueTime: int
        :param _AutoSuspendTime: The cluster auto-suspension time, which defaults to 10 min.
        :type AutoSuspendTime: int
        :param _ResourceType: The resource type. Valid values: `Standard_CU` (standard) and `Memory_CU` (memory).
        :type ResourceType: str
        :param _DataEngineConfigPairs: The advanced configurations of clusters.
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _ImageVersionName: The version name of cluster image, such as SuperSQL-P 1.1 and SuperSQL-S 3.2. If no value is passed in, a cluster is created using the latest image version.
        :type ImageVersionName: str
        :param _MainClusterName: The primary cluster, which is specified when a failover cluster is created.
        :type MainClusterName: str
        :param _ElasticSwitch: Whether to enable the scaling feature for a monthly subscribed Spark job cluster.
        :type ElasticSwitch: bool
        :param _ElasticLimit: The upper limit (in CUs) for scaling of the monthly subscribed Spark job cluster.
        :type ElasticLimit: int
        :param _SessionResourceTemplate: The session resource configuration template for a Spark job cluster.
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        :param _AutoAuthorization: Automatically grant permissions
        :type AutoAuthorization: bool
        :param _EngineNetworkId: Engine network ID
        :type EngineNetworkId: str
        :param _EngineGeneration: Generation of the engine. SuperSQL means the supersql engine while Native means the standard engine. It is SuperSQL by default.
        :type EngineGeneration: str
        """
        self._EngineType = None
        self._DataEngineName = None
        self._ClusterType = None
        self._Mode = None
        self._AutoResume = None
        self._MinClusters = None
        self._MaxClusters = None
        self._DefaultDataEngine = None
        self._CidrBlock = None
        self._Message = None
        self._Size = None
        self._PayMode = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._AutoRenew = None
        self._Tags = None
        self._AutoSuspend = None
        self._CrontabResumeSuspend = None
        self._CrontabResumeSuspendStrategy = None
        self._EngineExecType = None
        self._MaxConcurrency = None
        self._TolerableQueueTime = None
        self._AutoSuspendTime = None
        self._ResourceType = None
        self._DataEngineConfigPairs = None
        self._ImageVersionName = None
        self._MainClusterName = None
        self._ElasticSwitch = None
        self._ElasticLimit = None
        self._SessionResourceTemplate = None
        self._AutoAuthorization = None
        self._EngineNetworkId = None
        self._EngineGeneration = None

    @property
    def EngineType(self):
        r"""The engine type. Valid values: `spark` and `presto`.
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def DataEngineName(self):
        r"""The name of the virtual cluster.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ClusterType(self):
        r"""The cluster type. Valid values: `spark_private`, `presto_private`, `presto_cu`, and `spark_cu`.
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def Mode(self):
        r"""The billing mode. Valid values: `0` (shared engine), `1` (pay-as-you-go), and `2` (monthly subscription).
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def AutoResume(self):
        r"""Whether to automatically start the clusters.
        :rtype: bool
        """
        return self._AutoResume

    @AutoResume.setter
    def AutoResume(self, AutoResume):
        self._AutoResume = AutoResume

    @property
    def MinClusters(self):
        r"""The minimum number of clusters.
        :rtype: int
        """
        return self._MinClusters

    @MinClusters.setter
    def MinClusters(self, MinClusters):
        self._MinClusters = MinClusters

    @property
    def MaxClusters(self):
        r"""The maximum number of clusters.
        :rtype: int
        """
        return self._MaxClusters

    @MaxClusters.setter
    def MaxClusters(self, MaxClusters):
        self._MaxClusters = MaxClusters

    @property
    def DefaultDataEngine(self):
        warnings.warn("parameter `DefaultDataEngine` is deprecated", DeprecationWarning) 

        r"""Whether the cluster is the default one.
        :rtype: bool
        """
        return self._DefaultDataEngine

    @DefaultDataEngine.setter
    def DefaultDataEngine(self, DefaultDataEngine):
        warnings.warn("parameter `DefaultDataEngine` is deprecated", DeprecationWarning) 

        self._DefaultDataEngine = DefaultDataEngine

    @property
    def CidrBlock(self):
        r"""The VPC CIDR block.
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def Message(self):
        r"""The description.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Size(self):
        r"""The cluster size.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def PayMode(self):
        r"""The pay mode. Valid value: `0` (postpaid, default) and `1` (prepaid) (currently not available).
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def TimeSpan(self):
        r"""The usage duration of the resource. Postpaid: Fill in 3,600 as a fixed figure; prepaid: fill in a figure equal to or bigger than 1 which means purchasing resources for one month. The maximum figure is not bigger than 120. The default value is 1.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""The unit of the resource period. Valid values: `s` (default) for the postpaid mode and `m` for the prepaid mode.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def AutoRenew(self):
        r"""The auto-renewal status of the resource. For the postpaid mode, no renewal is required, and the value is fixed to `0`. For the prepaid mode, valid values are `0` (manual), `1` (auto), and `2` (no renewal). If this parameter is set to `0` for a key account in the prepaid mode, auto-renewal applies. It defaults to `0`.
        :rtype: int
        """
        return self._AutoRenew

    @AutoRenew.setter
    def AutoRenew(self, AutoRenew):
        self._AutoRenew = AutoRenew

    @property
    def Tags(self):
        r"""The tags to be set for the resource being created.
        :rtype: list of TagInfo
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AutoSuspend(self):
        r"""Whether to automatically suspend clusters. Valid values: `false` (default, no) and `true` (yes).
        :rtype: bool
        """
        return self._AutoSuspend

    @AutoSuspend.setter
    def AutoSuspend(self, AutoSuspend):
        self._AutoSuspend = AutoSuspend

    @property
    def CrontabResumeSuspend(self):
        r"""Whether to enable scheduled start and suspension of clusters. Valid values: `0` (disable) and `1` (enable). Note: This policy and the auto-suspension policy are mutually exclusive.
        :rtype: int
        """
        return self._CrontabResumeSuspend

    @CrontabResumeSuspend.setter
    def CrontabResumeSuspend(self, CrontabResumeSuspend):
        self._CrontabResumeSuspend = CrontabResumeSuspend

    @property
    def CrontabResumeSuspendStrategy(self):
        r"""The complex policy for scheduled start and suspension, including the start/suspension time and suspension policy.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        """
        return self._CrontabResumeSuspendStrategy

    @CrontabResumeSuspendStrategy.setter
    def CrontabResumeSuspendStrategy(self, CrontabResumeSuspendStrategy):
        self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy

    @property
    def EngineExecType(self):
        r"""The type of tasks to be executed by the engine, which defaults to SQL. Valid values: `SQL` and `BATCH`.
        :rtype: str
        """
        return self._EngineExecType

    @EngineExecType.setter
    def EngineExecType(self, EngineExecType):
        self._EngineExecType = EngineExecType

    @property
    def MaxConcurrency(self):
        r"""The max task concurrency of a cluster, which defaults to 5.
        :rtype: int
        """
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def TolerableQueueTime(self):
        r"""The task queue time limit, which defaults to 0. When the actual queue time exceeds the value set here, scale-out may be triggered. Setting this parameter to 0 represents that scale-out may be triggered immediately after a task queues up.
        :rtype: int
        """
        return self._TolerableQueueTime

    @TolerableQueueTime.setter
    def TolerableQueueTime(self, TolerableQueueTime):
        self._TolerableQueueTime = TolerableQueueTime

    @property
    def AutoSuspendTime(self):
        r"""The cluster auto-suspension time, which defaults to 10 min.
        :rtype: int
        """
        return self._AutoSuspendTime

    @AutoSuspendTime.setter
    def AutoSuspendTime(self, AutoSuspendTime):
        self._AutoSuspendTime = AutoSuspendTime

    @property
    def ResourceType(self):
        r"""The resource type. Valid values: `Standard_CU` (standard) and `Memory_CU` (memory).
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def DataEngineConfigPairs(self):
        r"""The advanced configurations of clusters.
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def ImageVersionName(self):
        r"""The version name of cluster image, such as SuperSQL-P 1.1 and SuperSQL-S 3.2. If no value is passed in, a cluster is created using the latest image version.
        :rtype: str
        """
        return self._ImageVersionName

    @ImageVersionName.setter
    def ImageVersionName(self, ImageVersionName):
        self._ImageVersionName = ImageVersionName

    @property
    def MainClusterName(self):
        r"""The primary cluster, which is specified when a failover cluster is created.
        :rtype: str
        """
        return self._MainClusterName

    @MainClusterName.setter
    def MainClusterName(self, MainClusterName):
        self._MainClusterName = MainClusterName

    @property
    def ElasticSwitch(self):
        r"""Whether to enable the scaling feature for a monthly subscribed Spark job cluster.
        :rtype: bool
        """
        return self._ElasticSwitch

    @ElasticSwitch.setter
    def ElasticSwitch(self, ElasticSwitch):
        self._ElasticSwitch = ElasticSwitch

    @property
    def ElasticLimit(self):
        r"""The upper limit (in CUs) for scaling of the monthly subscribed Spark job cluster.
        :rtype: int
        """
        return self._ElasticLimit

    @ElasticLimit.setter
    def ElasticLimit(self, ElasticLimit):
        self._ElasticLimit = ElasticLimit

    @property
    def SessionResourceTemplate(self):
        r"""The session resource configuration template for a Spark job cluster.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate

    @property
    def AutoAuthorization(self):
        r"""Automatically grant permissions
        :rtype: bool
        """
        return self._AutoAuthorization

    @AutoAuthorization.setter
    def AutoAuthorization(self, AutoAuthorization):
        self._AutoAuthorization = AutoAuthorization

    @property
    def EngineNetworkId(self):
        r"""Engine network ID
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def EngineGeneration(self):
        r"""Generation of the engine. SuperSQL means the supersql engine while Native means the standard engine. It is SuperSQL by default.
        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration


    def _deserialize(self, params):
        self._EngineType = params.get("EngineType")
        self._DataEngineName = params.get("DataEngineName")
        self._ClusterType = params.get("ClusterType")
        self._Mode = params.get("Mode")
        self._AutoResume = params.get("AutoResume")
        self._MinClusters = params.get("MinClusters")
        self._MaxClusters = params.get("MaxClusters")
        self._DefaultDataEngine = params.get("DefaultDataEngine")
        self._CidrBlock = params.get("CidrBlock")
        self._Message = params.get("Message")
        self._Size = params.get("Size")
        self._PayMode = params.get("PayMode")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._AutoRenew = params.get("AutoRenew")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AutoSuspend = params.get("AutoSuspend")
        self._CrontabResumeSuspend = params.get("CrontabResumeSuspend")
        if params.get("CrontabResumeSuspendStrategy") is not None:
            self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy()
            self._CrontabResumeSuspendStrategy._deserialize(params.get("CrontabResumeSuspendStrategy"))
        self._EngineExecType = params.get("EngineExecType")
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._TolerableQueueTime = params.get("TolerableQueueTime")
        self._AutoSuspendTime = params.get("AutoSuspendTime")
        self._ResourceType = params.get("ResourceType")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        self._ImageVersionName = params.get("ImageVersionName")
        self._MainClusterName = params.get("MainClusterName")
        self._ElasticSwitch = params.get("ElasticSwitch")
        self._ElasticLimit = params.get("ElasticLimit")
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        self._AutoAuthorization = params.get("AutoAuthorization")
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._EngineGeneration = params.get("EngineGeneration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataEngineResponse(AbstractModel):
    r"""CreateDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: The ID of the virtual engine.
        :type DataEngineId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataEngineId = None
        self._RequestId = None

    @property
    def DataEngineId(self):
        r"""The ID of the virtual engine.
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._RequestId = params.get("RequestId")


class CreateDataMaskStrategyRequest(AbstractModel):
    r"""CreateDataMaskStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _Strategy: Masking policy description.
        :type Strategy: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        self._Strategy = None

    @property
    def Strategy(self):
        r"""Masking policy description.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        return self._Strategy

    @Strategy.setter
    def Strategy(self, Strategy):
        self._Strategy = Strategy


    def _deserialize(self, params):
        if params.get("Strategy") is not None:
            self._Strategy = DataMaskStrategyInfo()
            self._Strategy._deserialize(params.get("Strategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataMaskStrategyResponse(AbstractModel):
    r"""CreateDataMaskStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _StrategyId: Policy ID
        :type StrategyId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StrategyId = None
        self._RequestId = None

    @property
    def StrategyId(self):
        r"""Policy ID
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._RequestId = params.get("RequestId")


class CreateInternalTableRequest(AbstractModel):
    r"""CreateInternalTable request structure.

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: The basic table information.
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: The table fields.
        :type Columns: list of TColumn
        :param _Partitions: The table partitions.
        :type Partitions: list of TPartition
        :param _Properties: The table properties.
        :type Properties: list of Property
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._Partitions = None
        self._Properties = None

    @property
    def TableBaseInfo(self):
        r"""The basic table information.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""The table fields.
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""The table partitions.
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""The table properties.
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInternalTableResponse(AbstractModel):
    r"""CreateInternalTable response structure.

    """

    def __init__(self):
        r"""
        :param _Execution: The SQL statements for creating the managed internal table.
        :type Execution: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Execution = None
        self._RequestId = None

    @property
    def Execution(self):
        r"""The SQL statements for creating the managed internal table.
        :rtype: str
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Execution = params.get("Execution")
        self._RequestId = params.get("RequestId")


class CreateResultDownloadRequest(AbstractModel):
    r"""CreateResultDownload request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The result query task ID.
        :type TaskId: str
        :param _Format: The result format.
        :type Format: str
        :param _Force: Whether to re-generate a file to download. This parameter applies only when the last task is `timeout` or `error`.
        :type Force: bool
        """
        self._TaskId = None
        self._Format = None
        self._Force = None

    @property
    def TaskId(self):
        r"""The result query task ID.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Format(self):
        r"""The result format.
        :rtype: str
        """
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Force(self):
        r"""Whether to re-generate a file to download. This parameter applies only when the last task is `timeout` or `error`.
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Format = params.get("Format")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateResultDownloadResponse(AbstractModel):
    r"""CreateResultDownload response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadId: The download task ID.
        :type DownloadId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadId = None
        self._RequestId = None

    @property
    def DownloadId(self):
        r"""The download task ID.
        :rtype: str
        """
        return self._DownloadId

    @DownloadId.setter
    def DownloadId(self, DownloadId):
        self._DownloadId = DownloadId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadId = params.get("DownloadId")
        self._RequestId = params.get("RequestId")


class CreateSparkAppRequest(AbstractModel):
    r"""CreateSparkApp request structure.

    """

    def __init__(self):
        r"""
        :param _AppName: The Spark job name.
        :type AppName: str
        :param _AppType: The Spark job type. Valid values: `1` for Spark JAR job and `2` for Spark streaming job.
        :type AppType: int
        :param _DataEngine: The data engine executing the Spark job.
        :type DataEngine: str
        :param _AppFile: The path of the Spark job package.
        :type AppFile: str
        :param _RoleArn: Data visiting policy achieved through CAM Role arn; the console can obtain it through Data Job -> Job Configuration; SDK can obtain corresponding values through the DescribeUserRoles API.
        :type RoleArn: int
        :param _AppDriverSize: The driver size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :type AppDriverSize: str
        :param _AppExecutorSize: The executor size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :type AppExecutorSize: str
        :param _AppExecutorNums: Number of Spark job executors
        :type AppExecutorNums: int
        :param _Eni: This field has been disused. Use the `Datasource` field instead.
        :type Eni: str
        :param _IsLocal: The source of the Spark job package. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocal: str
        :param _MainClass: The main class of the Spark job.
        :type MainClass: str
        :param _AppConf: Spark configurations separated by line break
        :type AppConf: str
        :param _IsLocalJars: The source of the dependency JAR packages of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalJars: str
        :param _AppJars: The dependency JAR packages of the Spark JAR job (JAR packages), separated by comma.
        :type AppJars: str
        :param _IsLocalFiles: The source of the dependency files of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalFiles: str
        :param _AppFiles: The dependency files of the Spark job (files other than JAR and ZIP packages) separated by comma.
        :type AppFiles: str
        :param _CmdArgs: The input parameters of the Spark job, separated by comma.
        :type CmdArgs: str
        :param _MaxRetries: The maximum number of retries, valid for Spark streaming tasks only.
        :type MaxRetries: int
        :param _DataSource: The data source name.
        :type DataSource: str
        :param _IsLocalPythonFiles: The source of the PySpark dependencies. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalPythonFiles: str
        :param _AppPythonFiles: The PySpark dependencies (Python files), separated by comma, with .py, .zip, and .egg formats supported.
        :type AppPythonFiles: str
        :param _IsLocalArchives: The source of the dependency archives of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalArchives: str
        :param _AppArchives: The dependency archives of the Spark job, separated by comma, with tar.gz, .tgz, and .tar formats supported.
        :type AppArchives: str
        :param _SparkImage: The Spark image version.
        :type SparkImage: str
        :param _SparkImageVersion: The Spark image version name.
        :type SparkImageVersion: str
        :param _AppExecutorMaxNumbers: The specified executor count (max), which defaults to 1. This parameter applies if the "Dynamic" mode is selected. If the "Dynamic" mode is not selected, the executor count is equal to `AppExecutorNums`.
        :type AppExecutorMaxNumbers: int
        :param _SessionId: The ID of the associated Data Lake Compute query script.
        :type SessionId: str
        :param _IsInherit: Whether to inherit the task resource configuration from the cluster template. Valid values: `0` (default): No; `1`: Yes.
        :type IsInherit: int
        :param _IsSessionStarted: Whether to run the task with the session SQLs. Valid values: `false` for no and `true` for yes.
        :type IsSessionStarted: bool
        """
        self._AppName = None
        self._AppType = None
        self._DataEngine = None
        self._AppFile = None
        self._RoleArn = None
        self._AppDriverSize = None
        self._AppExecutorSize = None
        self._AppExecutorNums = None
        self._Eni = None
        self._IsLocal = None
        self._MainClass = None
        self._AppConf = None
        self._IsLocalJars = None
        self._AppJars = None
        self._IsLocalFiles = None
        self._AppFiles = None
        self._CmdArgs = None
        self._MaxRetries = None
        self._DataSource = None
        self._IsLocalPythonFiles = None
        self._AppPythonFiles = None
        self._IsLocalArchives = None
        self._AppArchives = None
        self._SparkImage = None
        self._SparkImageVersion = None
        self._AppExecutorMaxNumbers = None
        self._SessionId = None
        self._IsInherit = None
        self._IsSessionStarted = None

    @property
    def AppName(self):
        r"""The Spark job name.
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def AppType(self):
        r"""The Spark job type. Valid values: `1` for Spark JAR job and `2` for Spark streaming job.
        :rtype: int
        """
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def DataEngine(self):
        r"""The data engine executing the Spark job.
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def AppFile(self):
        r"""The path of the Spark job package.
        :rtype: str
        """
        return self._AppFile

    @AppFile.setter
    def AppFile(self, AppFile):
        self._AppFile = AppFile

    @property
    def RoleArn(self):
        r"""Data visiting policy achieved through CAM Role arn; the console can obtain it through Data Job -> Job Configuration; SDK can obtain corresponding values through the DescribeUserRoles API.
        :rtype: int
        """
        return self._RoleArn

    @RoleArn.setter
    def RoleArn(self, RoleArn):
        self._RoleArn = RoleArn

    @property
    def AppDriverSize(self):
        r"""The driver size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :rtype: str
        """
        return self._AppDriverSize

    @AppDriverSize.setter
    def AppDriverSize(self, AppDriverSize):
        self._AppDriverSize = AppDriverSize

    @property
    def AppExecutorSize(self):
        r"""The executor size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :rtype: str
        """
        return self._AppExecutorSize

    @AppExecutorSize.setter
    def AppExecutorSize(self, AppExecutorSize):
        self._AppExecutorSize = AppExecutorSize

    @property
    def AppExecutorNums(self):
        r"""Number of Spark job executors
        :rtype: int
        """
        return self._AppExecutorNums

    @AppExecutorNums.setter
    def AppExecutorNums(self, AppExecutorNums):
        self._AppExecutorNums = AppExecutorNums

    @property
    def Eni(self):
        r"""This field has been disused. Use the `Datasource` field instead.
        :rtype: str
        """
        return self._Eni

    @Eni.setter
    def Eni(self, Eni):
        self._Eni = Eni

    @property
    def IsLocal(self):
        r"""The source of the Spark job package. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocal

    @IsLocal.setter
    def IsLocal(self, IsLocal):
        self._IsLocal = IsLocal

    @property
    def MainClass(self):
        r"""The main class of the Spark job.
        :rtype: str
        """
        return self._MainClass

    @MainClass.setter
    def MainClass(self, MainClass):
        self._MainClass = MainClass

    @property
    def AppConf(self):
        r"""Spark configurations separated by line break
        :rtype: str
        """
        return self._AppConf

    @AppConf.setter
    def AppConf(self, AppConf):
        self._AppConf = AppConf

    @property
    def IsLocalJars(self):
        r"""The source of the dependency JAR packages of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalJars

    @IsLocalJars.setter
    def IsLocalJars(self, IsLocalJars):
        self._IsLocalJars = IsLocalJars

    @property
    def AppJars(self):
        r"""The dependency JAR packages of the Spark JAR job (JAR packages), separated by comma.
        :rtype: str
        """
        return self._AppJars

    @AppJars.setter
    def AppJars(self, AppJars):
        self._AppJars = AppJars

    @property
    def IsLocalFiles(self):
        r"""The source of the dependency files of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalFiles

    @IsLocalFiles.setter
    def IsLocalFiles(self, IsLocalFiles):
        self._IsLocalFiles = IsLocalFiles

    @property
    def AppFiles(self):
        r"""The dependency files of the Spark job (files other than JAR and ZIP packages) separated by comma.
        :rtype: str
        """
        return self._AppFiles

    @AppFiles.setter
    def AppFiles(self, AppFiles):
        self._AppFiles = AppFiles

    @property
    def CmdArgs(self):
        r"""The input parameters of the Spark job, separated by comma.
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def MaxRetries(self):
        r"""The maximum number of retries, valid for Spark streaming tasks only.
        :rtype: int
        """
        return self._MaxRetries

    @MaxRetries.setter
    def MaxRetries(self, MaxRetries):
        self._MaxRetries = MaxRetries

    @property
    def DataSource(self):
        r"""The data source name.
        :rtype: str
        """
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def IsLocalPythonFiles(self):
        r"""The source of the PySpark dependencies. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalPythonFiles

    @IsLocalPythonFiles.setter
    def IsLocalPythonFiles(self, IsLocalPythonFiles):
        self._IsLocalPythonFiles = IsLocalPythonFiles

    @property
    def AppPythonFiles(self):
        r"""The PySpark dependencies (Python files), separated by comma, with .py, .zip, and .egg formats supported.
        :rtype: str
        """
        return self._AppPythonFiles

    @AppPythonFiles.setter
    def AppPythonFiles(self, AppPythonFiles):
        self._AppPythonFiles = AppPythonFiles

    @property
    def IsLocalArchives(self):
        r"""The source of the dependency archives of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalArchives

    @IsLocalArchives.setter
    def IsLocalArchives(self, IsLocalArchives):
        self._IsLocalArchives = IsLocalArchives

    @property
    def AppArchives(self):
        r"""The dependency archives of the Spark job, separated by comma, with tar.gz, .tgz, and .tar formats supported.
        :rtype: str
        """
        return self._AppArchives

    @AppArchives.setter
    def AppArchives(self, AppArchives):
        self._AppArchives = AppArchives

    @property
    def SparkImage(self):
        r"""The Spark image version.
        :rtype: str
        """
        return self._SparkImage

    @SparkImage.setter
    def SparkImage(self, SparkImage):
        self._SparkImage = SparkImage

    @property
    def SparkImageVersion(self):
        r"""The Spark image version name.
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def AppExecutorMaxNumbers(self):
        r"""The specified executor count (max), which defaults to 1. This parameter applies if the "Dynamic" mode is selected. If the "Dynamic" mode is not selected, the executor count is equal to `AppExecutorNums`.
        :rtype: int
        """
        return self._AppExecutorMaxNumbers

    @AppExecutorMaxNumbers.setter
    def AppExecutorMaxNumbers(self, AppExecutorMaxNumbers):
        self._AppExecutorMaxNumbers = AppExecutorMaxNumbers

    @property
    def SessionId(self):
        r"""The ID of the associated Data Lake Compute query script.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def IsInherit(self):
        r"""Whether to inherit the task resource configuration from the cluster template. Valid values: `0` (default): No; `1`: Yes.
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def IsSessionStarted(self):
        r"""Whether to run the task with the session SQLs. Valid values: `false` for no and `true` for yes.
        :rtype: bool
        """
        return self._IsSessionStarted

    @IsSessionStarted.setter
    def IsSessionStarted(self, IsSessionStarted):
        self._IsSessionStarted = IsSessionStarted


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._AppType = params.get("AppType")
        self._DataEngine = params.get("DataEngine")
        self._AppFile = params.get("AppFile")
        self._RoleArn = params.get("RoleArn")
        self._AppDriverSize = params.get("AppDriverSize")
        self._AppExecutorSize = params.get("AppExecutorSize")
        self._AppExecutorNums = params.get("AppExecutorNums")
        self._Eni = params.get("Eni")
        self._IsLocal = params.get("IsLocal")
        self._MainClass = params.get("MainClass")
        self._AppConf = params.get("AppConf")
        self._IsLocalJars = params.get("IsLocalJars")
        self._AppJars = params.get("AppJars")
        self._IsLocalFiles = params.get("IsLocalFiles")
        self._AppFiles = params.get("AppFiles")
        self._CmdArgs = params.get("CmdArgs")
        self._MaxRetries = params.get("MaxRetries")
        self._DataSource = params.get("DataSource")
        self._IsLocalPythonFiles = params.get("IsLocalPythonFiles")
        self._AppPythonFiles = params.get("AppPythonFiles")
        self._IsLocalArchives = params.get("IsLocalArchives")
        self._AppArchives = params.get("AppArchives")
        self._SparkImage = params.get("SparkImage")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._AppExecutorMaxNumbers = params.get("AppExecutorMaxNumbers")
        self._SessionId = params.get("SessionId")
        self._IsInherit = params.get("IsInherit")
        self._IsSessionStarted = params.get("IsSessionStarted")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkAppResponse(AbstractModel):
    r"""CreateSparkApp response structure.

    """

    def __init__(self):
        r"""
        :param _SparkAppId: The unique ID of the application.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkAppId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SparkAppId = None
        self._RequestId = None

    @property
    def SparkAppId(self):
        r"""The unique ID of the application.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SparkAppId = params.get("SparkAppId")
        self._RequestId = params.get("RequestId")


class CreateSparkAppTaskRequest(AbstractModel):
    r"""CreateSparkAppTask request structure.

    """

    def __init__(self):
        r"""
        :param _JobName: Spark job name
        :type JobName: str
        :param _CmdArgs: The input parameters of the Spark job, separated by space. They are generally used for periodic calls.
        :type CmdArgs: str
        """
        self._JobName = None
        self._CmdArgs = None

    @property
    def JobName(self):
        r"""Spark job name
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName

    @property
    def CmdArgs(self):
        r"""The input parameters of the Spark job, separated by space. They are generally used for periodic calls.
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs


    def _deserialize(self, params):
        self._JobName = params.get("JobName")
        self._CmdArgs = params.get("CmdArgs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkAppTaskResponse(AbstractModel):
    r"""CreateSparkAppTask response structure.

    """

    def __init__(self):
        r"""
        :param _BatchId: Batch ID
        :type BatchId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BatchId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""Batch ID
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateSparkSessionBatchSQLRequest(AbstractModel):
    r"""CreateSparkSessionBatchSQL request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: The name of the engine for executing the Spark job.
        :type DataEngineName: str
        :param _ExecuteSQL: Run SQL. The base64 encoding is needed.
        :type ExecuteSQL: str
        :param _DriverSize: The driver size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :type DriverSize: str
        :param _ExecutorSize: The executor size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :type ExecutorSize: str
        :param _ExecutorNumbers: The executor count, which defaults to 1.
        :type ExecutorNumbers: int
        :param _ExecutorMaxNumbers: The maximum executor count, which defaults to 1. This parameter applies if the "Dynamic" mode is selected. If the "Dynamic" mode is not selected, the value of this parameter is the same as that of `ExecutorNumbers`.
        :type ExecutorMaxNumbers: int
        :param _TimeoutInSecond: The session timeout period in seconds. Default value: 3600
        :type TimeoutInSecond: int
        :param _SessionId: The unique ID of a session. If this parameter is specified, the task will be run using the specified session.
        :type SessionId: str
        :param _SessionName: The name of the session to create.
        :type SessionName: str
        :param _Arguments: The session configurations. Valid values: `1.dlc.eni` for user-defined ENI gateway information;
`2.dlc.role.arn` for user-defined roleArn configurations;
and `3.dlc.sql.set.config` for user-defined cluster configurations.
        :type Arguments: list of KVPair
        :param _IsInherit: Whether to inherit the resource configuration of clusters; 0: not inherit (by default); 1: inherit clusters.
        :type IsInherit: int
        :param _CustomKey: User-defined primary key, and it should be unique.
        :type CustomKey: str
        """
        self._DataEngineName = None
        self._ExecuteSQL = None
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNumbers = None
        self._ExecutorMaxNumbers = None
        self._TimeoutInSecond = None
        self._SessionId = None
        self._SessionName = None
        self._Arguments = None
        self._IsInherit = None
        self._CustomKey = None

    @property
    def DataEngineName(self):
        r"""The name of the engine for executing the Spark job.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ExecuteSQL(self):
        r"""Run SQL. The base64 encoding is needed.
        :rtype: str
        """
        return self._ExecuteSQL

    @ExecuteSQL.setter
    def ExecuteSQL(self, ExecuteSQL):
        self._ExecuteSQL = ExecuteSQL

    @property
    def DriverSize(self):
        r"""The driver size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""The executor size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNumbers(self):
        r"""The executor count, which defaults to 1.
        :rtype: int
        """
        return self._ExecutorNumbers

    @ExecutorNumbers.setter
    def ExecutorNumbers(self, ExecutorNumbers):
        self._ExecutorNumbers = ExecutorNumbers

    @property
    def ExecutorMaxNumbers(self):
        r"""The maximum executor count, which defaults to 1. This parameter applies if the "Dynamic" mode is selected. If the "Dynamic" mode is not selected, the value of this parameter is the same as that of `ExecutorNumbers`.
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers

    @property
    def TimeoutInSecond(self):
        r"""The session timeout period in seconds. Default value: 3600
        :rtype: int
        """
        return self._TimeoutInSecond

    @TimeoutInSecond.setter
    def TimeoutInSecond(self, TimeoutInSecond):
        self._TimeoutInSecond = TimeoutInSecond

    @property
    def SessionId(self):
        r"""The unique ID of a session. If this parameter is specified, the task will be run using the specified session.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionName(self):
        r"""The name of the session to create.
        :rtype: str
        """
        return self._SessionName

    @SessionName.setter
    def SessionName(self, SessionName):
        self._SessionName = SessionName

    @property
    def Arguments(self):
        r"""The session configurations. Valid values: `1.dlc.eni` for user-defined ENI gateway information;
`2.dlc.role.arn` for user-defined roleArn configurations;
and `3.dlc.sql.set.config` for user-defined cluster configurations.
        :rtype: list of KVPair
        """
        return self._Arguments

    @Arguments.setter
    def Arguments(self, Arguments):
        self._Arguments = Arguments

    @property
    def IsInherit(self):
        r"""Whether to inherit the resource configuration of clusters; 0: not inherit (by default); 1: inherit clusters.
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def CustomKey(self):
        r"""User-defined primary key, and it should be unique.
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._ExecuteSQL = params.get("ExecuteSQL")
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNumbers = params.get("ExecutorNumbers")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        self._TimeoutInSecond = params.get("TimeoutInSecond")
        self._SessionId = params.get("SessionId")
        self._SessionName = params.get("SessionName")
        if params.get("Arguments") is not None:
            self._Arguments = []
            for item in params.get("Arguments"):
                obj = KVPair()
                obj._deserialize(item)
                self._Arguments.append(obj)
        self._IsInherit = params.get("IsInherit")
        self._CustomKey = params.get("CustomKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSparkSessionBatchSQLResponse(AbstractModel):
    r"""CreateSparkSessionBatchSQL response structure.

    """

    def __init__(self):
        r"""
        :param _BatchId: The unique identifier of a batch task.
        :type BatchId: str
        :param _Statements: Statement task list information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Statements: list of StatementInformation
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BatchId = None
        self._Statements = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""The unique identifier of a batch task.
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def Statements(self):
        r"""Statement task list information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of StatementInformation
        """
        return self._Statements

    @Statements.setter
    def Statements(self, Statements):
        self._Statements = Statements

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        if params.get("Statements") is not None:
            self._Statements = []
            for item in params.get("Statements"):
                obj = StatementInformation()
                obj._deserialize(item)
                self._Statements.append(obj)
        self._RequestId = params.get("RequestId")


class CreateStoreLocationRequest(AbstractModel):
    r"""CreateStoreLocation request structure.

    """

    def __init__(self):
        r"""
        :param _StoreLocation: COS path for calculation results storage, such as cosn://bucketname/
        :type StoreLocation: str
        """
        self._StoreLocation = None

    @property
    def StoreLocation(self):
        r"""COS path for calculation results storage, such as cosn://bucketname/
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation


    def _deserialize(self, params):
        self._StoreLocation = params.get("StoreLocation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStoreLocationResponse(AbstractModel):
    r"""CreateStoreLocation response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    r"""CreateTask request structure.

    """

    def __init__(self):
        r"""
        :param _Task: Computing task. This parameter contains the task type and related configuration information.
        :type Task: :class:`tencentcloud.dlc.v20210125.models.Task`
        :param _DatabaseName: Database name. If there is a database name in the SQL statement, the database in the SQL statement will be used first; otherwise, the database specified by this parameter will be used (note: when submitting the database creation SQL statement, passed in an empty string for this field).
        :type DatabaseName: str
        :param _DatasourceConnectionName: Name of the default data source
        :type DatasourceConnectionName: str
        :param _DataEngineName: Data engine name. If this parameter is not specified, the task will be submitted to the default engine.
        :type DataEngineName: str
        :param _ResourceGroupName: Standard spark execution task resourceGroupName
        :type ResourceGroupName: str
        """
        self._Task = None
        self._DatabaseName = None
        self._DatasourceConnectionName = None
        self._DataEngineName = None
        self._ResourceGroupName = None

    @property
    def Task(self):
        r"""Computing task. This parameter contains the task type and related configuration information.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Task`
        """
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def DatabaseName(self):
        r"""Database name. If there is a database name in the SQL statement, the database in the SQL statement will be used first; otherwise, the database specified by this parameter will be used (note: when submitting the database creation SQL statement, passed in an empty string for this field).
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatasourceConnectionName(self):
        r"""Name of the default data source
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DataEngineName(self):
        r"""Data engine name. If this parameter is not specified, the task will be submitted to the default engine.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""Standard spark execution task resourceGroupName
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = Task()
            self._Task._deserialize(params.get("Task"))
        self._DatabaseName = params.get("DatabaseName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    r"""CreateTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateTasksRequest(AbstractModel):
    r"""CreateTasks request structure.

    """

    def __init__(self):
        r"""
        :param _DatabaseName: Database name. If there is a database name in the SQL statement, the database in the SQL statement will be used first; otherwise, the database specified by this parameter will be used (note: when submitting the database creation SQL statement, passed in an empty string for this field).
        :type DatabaseName: str
        :param _Tasks: SQL task information
        :type Tasks: :class:`tencentcloud.dlc.v20210125.models.TasksInfo`
        :param _DatasourceConnectionName: Data source name. Default value: DataLakeCatalog.
        :type DatasourceConnectionName: str
        :param _DataEngineName: Compute engine name. If this parameter is not specified, the task will be submitted to the default engine.
        :type DataEngineName: str
        :param _ResourceGroupName: Resource group name of the spark cluster
        :type ResourceGroupName: str
        """
        self._DatabaseName = None
        self._Tasks = None
        self._DatasourceConnectionName = None
        self._DataEngineName = None
        self._ResourceGroupName = None

    @property
    def DatabaseName(self):
        r"""Database name. If there is a database name in the SQL statement, the database in the SQL statement will be used first; otherwise, the database specified by this parameter will be used (note: when submitting the database creation SQL statement, passed in an empty string for this field).
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Tasks(self):
        r"""SQL task information
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TasksInfo`
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def DatasourceConnectionName(self):
        r"""Data source name. Default value: DataLakeCatalog.
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DataEngineName(self):
        r"""Compute engine name. If this parameter is not specified, the task will be submitted to the default engine.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""Resource group name of the spark cluster
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        if params.get("Tasks") is not None:
            self._Tasks = TasksInfo()
            self._Tasks._deserialize(params.get("Tasks"))
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTasksResponse(AbstractModel):
    r"""CreateTasks response structure.

    """

    def __init__(self):
        r"""
        :param _BatchId: ID of the current batch of submitted tasks
        :type BatchId: str
        :param _TaskIdSet: Collection of task IDs arranged in order of execution
        :type TaskIdSet: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BatchId = None
        self._TaskIdSet = None
        self._RequestId = None

    @property
    def BatchId(self):
        r"""ID of the current batch of submitted tasks
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def TaskIdSet(self):
        r"""Collection of task IDs arranged in order of execution
        :rtype: list of str
        """
        return self._TaskIdSet

    @TaskIdSet.setter
    def TaskIdSet(self, TaskIdSet):
        self._TaskIdSet = TaskIdSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._TaskIdSet = params.get("TaskIdSet")
        self._RequestId = params.get("RequestId")


class CreateUserRequest(AbstractModel):
    r"""CreateUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: Sub-user UIN that needs to be granted permissions. It can be checked through the upper right corner of Tencent Cloud Console → Account Information → Account ID.
        :type UserId: str
        :param _UserDescription: User description, which can make it easy to identify different users.
        :type UserDescription: str
        :param _PolicySet: Collections of permissions bound to users
        :type PolicySet: list of Policy
        :param _UserType: Types of users. ADMIN: administrators; COMMON: general users. When the type of user is administrator, the collections of permissions and bound working groups cannot be set. Administrators own all the permissions by default. If the parameter is not filled in, it will be COMMON by default.
        :type UserType: str
        :param _WorkGroupIds: Collection of IDs of working groups bound to users
        :type WorkGroupIds: list of int
        :param _UserAlias: User alias, and its characters are less than 50.
        :type UserAlias: str
        """
        self._UserId = None
        self._UserDescription = None
        self._PolicySet = None
        self._UserType = None
        self._WorkGroupIds = None
        self._UserAlias = None

    @property
    def UserId(self):
        r"""Sub-user UIN that needs to be granted permissions. It can be checked through the upper right corner of Tencent Cloud Console → Account Information → Account ID.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserDescription(self):
        r"""User description, which can make it easy to identify different users.
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription

    @property
    def PolicySet(self):
        r"""Collections of permissions bound to users
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def UserType(self):
        r"""Types of users. ADMIN: administrators; COMMON: general users. When the type of user is administrator, the collections of permissions and bound working groups cannot be set. Administrators own all the permissions by default. If the parameter is not filled in, it will be COMMON by default.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def WorkGroupIds(self):
        r"""Collection of IDs of working groups bound to users
        :rtype: list of int
        """
        return self._WorkGroupIds

    @WorkGroupIds.setter
    def WorkGroupIds(self, WorkGroupIds):
        self._WorkGroupIds = WorkGroupIds

    @property
    def UserAlias(self):
        r"""User alias, and its characters are less than 50.
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserDescription = params.get("UserDescription")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._UserType = params.get("UserType")
        self._WorkGroupIds = params.get("WorkGroupIds")
        self._UserAlias = params.get("UserAlias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserResponse(AbstractModel):
    r"""CreateUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWorkGroupRequest(AbstractModel):
    r"""CreateWorkGroup request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupName: Working group name
        :type WorkGroupName: str
        :param _WorkGroupDescription: Working group description
        :type WorkGroupDescription: str
        :param _PolicySet: Collections of authentication policies bound to working groups
        :type PolicySet: list of Policy
        :param _UserIds: Collection of IDs of users to be bound to working groups
        :type UserIds: list of str
        """
        self._WorkGroupName = None
        self._WorkGroupDescription = None
        self._PolicySet = None
        self._UserIds = None

    @property
    def WorkGroupName(self):
        r"""Working group name
        :rtype: str
        """
        return self._WorkGroupName

    @WorkGroupName.setter
    def WorkGroupName(self, WorkGroupName):
        self._WorkGroupName = WorkGroupName

    @property
    def WorkGroupDescription(self):
        r"""Working group description
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription

    @property
    def PolicySet(self):
        r"""Collections of authentication policies bound to working groups
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def UserIds(self):
        r"""Collection of IDs of users to be bound to working groups
        :rtype: list of str
        """
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds


    def _deserialize(self, params):
        self._WorkGroupName = params.get("WorkGroupName")
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._UserIds = params.get("UserIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkGroupResponse(AbstractModel):
    r"""CreateWorkGroup response structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group ID which is globally unique
        :type WorkGroupId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WorkGroupId = None
        self._RequestId = None

    @property
    def WorkGroupId(self):
        r"""Working group ID which is globally unique
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._RequestId = params.get("RequestId")


class CrontabResumeSuspendStrategy(AbstractModel):
    r"""Scheduled start and suspension information

    """

    def __init__(self):
        r"""
        :param _ResumeTime: Scheduled starting time, such as 8: 00 a.m. on Monday and Wednesday
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResumeTime: str
        :param _SuspendTime: Scheduled suspension time, such as 8: 00 p.m. on Monday and Wednesday
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuspendTime: str
        :param _SuspendStrategy: The suspension setting. Valid values: `0` (suspension after task end, default) and `1` (force suspension).
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuspendStrategy: int
        """
        self._ResumeTime = None
        self._SuspendTime = None
        self._SuspendStrategy = None

    @property
    def ResumeTime(self):
        r"""Scheduled starting time, such as 8: 00 a.m. on Monday and Wednesday
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ResumeTime

    @ResumeTime.setter
    def ResumeTime(self, ResumeTime):
        self._ResumeTime = ResumeTime

    @property
    def SuspendTime(self):
        r"""Scheduled suspension time, such as 8: 00 p.m. on Monday and Wednesday
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SuspendTime

    @SuspendTime.setter
    def SuspendTime(self, SuspendTime):
        self._SuspendTime = SuspendTime

    @property
    def SuspendStrategy(self):
        r"""The suspension setting. Valid values: `0` (suspension after task end, default) and `1` (force suspension).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SuspendStrategy

    @SuspendStrategy.setter
    def SuspendStrategy(self, SuspendStrategy):
        self._SuspendStrategy = SuspendStrategy


    def _deserialize(self, params):
        self._ResumeTime = params.get("ResumeTime")
        self._SuspendTime = params.get("SuspendTime")
        self._SuspendStrategy = params.get("SuspendStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DLCCatalogAccess(AbstractModel):
    r"""Permission to visit DLC data logs

    """

    def __init__(self):
        r"""
        :param _VpcId: VPCID
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _Product: Product type
Note: This field may return null, indicating that no valid values can be obtained.
        :type Product: str
        :param _Description: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._VpcId = None
        self._Product = None
        self._Description = None
        self._CreateTime = None

    @property
    def VpcId(self):
        r"""VPCID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Product(self):
        r"""Product type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Description(self):
        r"""Description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Product = params.get("Product")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DLCTable(AbstractModel):
    r"""Query table information object

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: Basic information of the data table
Note: This field may return null, indicating that no valid values can be obtained.
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: Data table column information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Columns: list of TColumn
        :param _Partitions: Data table partition information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Partitions: list of TPartition
        :param _Location: Data storage path
Note: This field may return null, indicating that no valid values can be obtained.
        :type Location: str
        :param _Properties: Data table attribute information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Properties: list of Property
        :param _ModifiedTime: Data table update information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifiedTime: str
        :param _CreateTime: Database creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _InputFormat: Data format
Note: This field may return null, indicating that no valid values can be obtained.
        :type InputFormat: str
        :param _StorageSize: Data storage size
Note: This field may return null, indicating that no valid values can be obtained.
        :type StorageSize: int
        :param _RecordCount: Number of rows in the data table
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecordCount: int
        :param _MapMaterializedViewName: Materialized view name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MapMaterializedViewName: str
        :param _HeatValue: Visit hot spots
Note: This field may return null, indicating that no valid values can be obtained.
        :type HeatValue: int
        :param _ExternalDataConfiguration: External table configuration information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExternalDataConfiguration: :class:`tencentcloud.dlc.v20210125.models.ExternalDataConfiguration`
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._Partitions = None
        self._Location = None
        self._Properties = None
        self._ModifiedTime = None
        self._CreateTime = None
        self._InputFormat = None
        self._StorageSize = None
        self._RecordCount = None
        self._MapMaterializedViewName = None
        self._HeatValue = None
        self._ExternalDataConfiguration = None

    @property
    def TableBaseInfo(self):
        r"""Basic information of the data table
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""Data table column information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""Data table partition information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Location(self):
        r"""Data storage path
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Properties(self):
        r"""Data table attribute information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def ModifiedTime(self):
        r"""Data table update information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def CreateTime(self):
        r"""Database creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def InputFormat(self):
        r"""Data format
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InputFormat

    @InputFormat.setter
    def InputFormat(self, InputFormat):
        self._InputFormat = InputFormat

    @property
    def StorageSize(self):
        r"""Data storage size
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""Number of rows in the data table
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def MapMaterializedViewName(self):
        r"""Materialized view name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._MapMaterializedViewName

    @MapMaterializedViewName.setter
    def MapMaterializedViewName(self, MapMaterializedViewName):
        self._MapMaterializedViewName = MapMaterializedViewName

    @property
    def HeatValue(self):
        r"""Visit hot spots
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._HeatValue

    @HeatValue.setter
    def HeatValue(self, HeatValue):
        self._HeatValue = HeatValue

    @property
    def ExternalDataConfiguration(self):
        r"""External table configuration information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ExternalDataConfiguration`
        """
        return self._ExternalDataConfiguration

    @ExternalDataConfiguration.setter
    def ExternalDataConfiguration(self, ExternalDataConfiguration):
        self._ExternalDataConfiguration = ExternalDataConfiguration


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        self._Location = params.get("Location")
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._ModifiedTime = params.get("ModifiedTime")
        self._CreateTime = params.get("CreateTime")
        self._InputFormat = params.get("InputFormat")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._MapMaterializedViewName = params.get("MapMaterializedViewName")
        self._HeatValue = params.get("HeatValue")
        if params.get("ExternalDataConfiguration") is not None:
            self._ExternalDataConfiguration = ExternalDataConfiguration()
            self._ExternalDataConfiguration._deserialize(params.get("ExternalDataConfiguration"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSColumn(AbstractModel):
    r"""Migrating column objects

    """

    def __init__(self):
        r"""
        :param _Name: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Description: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _Type: Type
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Position: Sort
Note: This field may return null, indicating that no valid values can be obtained.
        :type Position: int
        :param _Params: Additional Parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type Params: list of KVPair
        :param _BizParams: Business parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type BizParams: list of KVPair
        :param _IsPartition: Whether partitioned
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsPartition: bool
        """
        self._Name = None
        self._Description = None
        self._Type = None
        self._Position = None
        self._Params = None
        self._BizParams = None
        self._IsPartition = None

    @property
    def Name(self):
        r"""Name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        r"""Description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        r"""Type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Position(self):
        r"""Sort
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def Params(self):
        r"""Additional Parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def BizParams(self):
        r"""Business parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of KVPair
        """
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def IsPartition(self):
        r"""Whether partitioned
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        self._Position = params.get("Position")
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("BizParams") is not None:
            self._BizParams = []
            for item in params.get("BizParams"):
                obj = KVPair()
                obj._deserialize(item)
                self._BizParams.append(obj)
        self._IsPartition = params.get("IsPartition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSColumnOrder(AbstractModel):
    r"""Column sorting object

    """

    def __init__(self):
        r"""
        :param _Col: Column name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Col: str
        :param _Order: Sort
Note: This field may return null, indicating that no valid values can be obtained.
        :type Order: int
        """
        self._Col = None
        self._Order = None

    @property
    def Col(self):
        r"""Column name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Col

    @Col.setter
    def Col(self, Col):
        self._Col = Col

    @property
    def Order(self):
        r"""Sort
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Col = params.get("Col")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSDatabaseInfo(AbstractModel):
    r"""Metadata database objects

    """

    def __init__(self):
        r"""
        :param _Name: Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _SchemaName: Schema name
Note: This field may return null, indicating that no valid values can be obtained.
        :type SchemaName: str
        :param _Location: Storage address
Note: This field may return null, indicating that no valid values can be obtained.
        :type Location: str
        :param _Asset: Basic object information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        self._Name = None
        self._SchemaName = None
        self._Location = None
        self._Asset = None

    @property
    def Name(self):
        r"""Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SchemaName(self):
        r"""Schema name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""Storage address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Asset(self):
        r"""Basic object information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSPartition(AbstractModel):
    r"""Partition objects of the migrating metadata

    """

    def __init__(self):
        r"""
        :param _DatabaseName: Database name
        :type DatabaseName: str
        :param _SchemaName: Data directory name
        :type SchemaName: str
        :param _TableName: Table name
        :type TableName: str
        :param _DataVersion: Data version
        :type DataVersion: int
        :param _Name: Partition name
        :type Name: str
        :param _Values: Value List
        :type Values: list of str
        :param _StorageSize: Storage size
        :type StorageSize: int
        :param _RecordCount: Number of records
        :type RecordCount: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ModifiedTime: Modification time
        :type ModifiedTime: str
        :param _LastAccessTime: Last access time
        :type LastAccessTime: str
        :param _Params: Additional attribute
        :type Params: list of KVPair
        :param _Sds: Storage object
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        self._DatabaseName = None
        self._SchemaName = None
        self._TableName = None
        self._DataVersion = None
        self._Name = None
        self._Values = None
        self._StorageSize = None
        self._RecordCount = None
        self._CreateTime = None
        self._ModifiedTime = None
        self._LastAccessTime = None
        self._Params = None
        self._Sds = None

    @property
    def DatabaseName(self):
        r"""Database name
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SchemaName(self):
        r"""Data directory name
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def TableName(self):
        r"""Table name
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def DataVersion(self):
        r"""Data version
        :rtype: int
        """
        return self._DataVersion

    @DataVersion.setter
    def DataVersion(self, DataVersion):
        self._DataVersion = DataVersion

    @property
    def Name(self):
        r"""Partition name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Value List
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def StorageSize(self):
        r"""Storage size
        :rtype: int
        """
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def RecordCount(self):
        r"""Number of records
        :rtype: int
        """
        return self._RecordCount

    @RecordCount.setter
    def RecordCount(self, RecordCount):
        self._RecordCount = RecordCount

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifiedTime(self):
        r"""Modification time
        :rtype: str
        """
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def LastAccessTime(self):
        r"""Last access time
        :rtype: str
        """
        return self._LastAccessTime

    @LastAccessTime.setter
    def LastAccessTime(self, LastAccessTime):
        self._LastAccessTime = LastAccessTime

    @property
    def Params(self):
        r"""Additional attribute
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Sds(self):
        r"""Storage object
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._SchemaName = params.get("SchemaName")
        self._TableName = params.get("TableName")
        self._DataVersion = params.get("DataVersion")
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._StorageSize = params.get("StorageSize")
        self._RecordCount = params.get("RecordCount")
        self._CreateTime = params.get("CreateTime")
        self._ModifiedTime = params.get("ModifiedTime")
        self._LastAccessTime = params.get("LastAccessTime")
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSSds(AbstractModel):
    r"""Description of metadata storage attributes

    """

    def __init__(self):
        r"""
        :param _Location: Storage address
Note: This field may return null, indicating that no valid values can be obtained.
        :type Location: str
        :param _InputFormat: Input format
Note: This field may return null, indicating that no valid values can be obtained.
        :type InputFormat: str
        :param _OutputFormat: Output format
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputFormat: str
        :param _NumBuckets: Number of buckets
Note: This field may return null, indicating that no valid values can be obtained.
        :type NumBuckets: int
        :param _Compressed: Whether it is compressed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Compressed: bool
        :param _StoredAsSubDirectories: Whether it has a subdirectory
Note: This field may return null, indicating that no valid values can be obtained.
        :type StoredAsSubDirectories: bool
        :param _SerdeLib: Serialization lib
Note: This field may return null, indicating that no valid values can be obtained.
        :type SerdeLib: str
        :param _SerdeName: Serialization name
Note: This field may return null, indicating that no valid values can be obtained.
        :type SerdeName: str
        :param _BucketCols: Bucket name
Note: This field may return null, indicating that no valid values can be obtained.
        :type BucketCols: list of str
        :param _SerdeParams: Serialization parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type SerdeParams: list of KVPair
        :param _Params: Additional Parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type Params: list of KVPair
        :param _SortCols: Column sorting (Expired)
Note: This field may return null, indicating that no valid values can be obtained.
        :type SortCols: :class:`tencentcloud.dlc.v20210125.models.DMSColumnOrder`
        :param _Cols: Column
Note: This field may return null, indicating that no valid values can be obtained.
        :type Cols: list of DMSColumn
        :param _SortColumns: Column sorting field
Note: This field may return null, indicating that no valid values can be obtained.
        :type SortColumns: list of DMSColumnOrder
        """
        self._Location = None
        self._InputFormat = None
        self._OutputFormat = None
        self._NumBuckets = None
        self._Compressed = None
        self._StoredAsSubDirectories = None
        self._SerdeLib = None
        self._SerdeName = None
        self._BucketCols = None
        self._SerdeParams = None
        self._Params = None
        self._SortCols = None
        self._Cols = None
        self._SortColumns = None

    @property
    def Location(self):
        r"""Storage address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def InputFormat(self):
        r"""Input format
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InputFormat

    @InputFormat.setter
    def InputFormat(self, InputFormat):
        self._InputFormat = InputFormat

    @property
    def OutputFormat(self):
        r"""Output format
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OutputFormat

    @OutputFormat.setter
    def OutputFormat(self, OutputFormat):
        self._OutputFormat = OutputFormat

    @property
    def NumBuckets(self):
        r"""Number of buckets
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NumBuckets

    @NumBuckets.setter
    def NumBuckets(self, NumBuckets):
        self._NumBuckets = NumBuckets

    @property
    def Compressed(self):
        r"""Whether it is compressed
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Compressed

    @Compressed.setter
    def Compressed(self, Compressed):
        self._Compressed = Compressed

    @property
    def StoredAsSubDirectories(self):
        r"""Whether it has a subdirectory
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._StoredAsSubDirectories

    @StoredAsSubDirectories.setter
    def StoredAsSubDirectories(self, StoredAsSubDirectories):
        self._StoredAsSubDirectories = StoredAsSubDirectories

    @property
    def SerdeLib(self):
        r"""Serialization lib
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SerdeLib

    @SerdeLib.setter
    def SerdeLib(self, SerdeLib):
        self._SerdeLib = SerdeLib

    @property
    def SerdeName(self):
        r"""Serialization name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SerdeName

    @SerdeName.setter
    def SerdeName(self, SerdeName):
        self._SerdeName = SerdeName

    @property
    def BucketCols(self):
        r"""Bucket name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._BucketCols

    @BucketCols.setter
    def BucketCols(self, BucketCols):
        self._BucketCols = BucketCols

    @property
    def SerdeParams(self):
        r"""Serialization parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of KVPair
        """
        return self._SerdeParams

    @SerdeParams.setter
    def SerdeParams(self, SerdeParams):
        self._SerdeParams = SerdeParams

    @property
    def Params(self):
        r"""Additional Parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def SortCols(self):
        r"""Column sorting (Expired)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSColumnOrder`
        """
        return self._SortCols

    @SortCols.setter
    def SortCols(self, SortCols):
        self._SortCols = SortCols

    @property
    def Cols(self):
        r"""Column
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DMSColumn
        """
        return self._Cols

    @Cols.setter
    def Cols(self, Cols):
        self._Cols = Cols

    @property
    def SortColumns(self):
        r"""Column sorting field
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DMSColumnOrder
        """
        return self._SortColumns

    @SortColumns.setter
    def SortColumns(self, SortColumns):
        self._SortColumns = SortColumns


    def _deserialize(self, params):
        self._Location = params.get("Location")
        self._InputFormat = params.get("InputFormat")
        self._OutputFormat = params.get("OutputFormat")
        self._NumBuckets = params.get("NumBuckets")
        self._Compressed = params.get("Compressed")
        self._StoredAsSubDirectories = params.get("StoredAsSubDirectories")
        self._SerdeLib = params.get("SerdeLib")
        self._SerdeName = params.get("SerdeName")
        self._BucketCols = params.get("BucketCols")
        if params.get("SerdeParams") is not None:
            self._SerdeParams = []
            for item in params.get("SerdeParams"):
                obj = KVPair()
                obj._deserialize(item)
                self._SerdeParams.append(obj)
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        if params.get("SortCols") is not None:
            self._SortCols = DMSColumnOrder()
            self._SortCols._deserialize(params.get("SortCols"))
        if params.get("Cols") is not None:
            self._Cols = []
            for item in params.get("Cols"):
                obj = DMSColumn()
                obj._deserialize(item)
                self._Cols.append(obj)
        if params.get("SortColumns") is not None:
            self._SortColumns = []
            for item in params.get("SortColumns"):
                obj = DMSColumnOrder()
                obj._deserialize(item)
                self._SortColumns.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DMSSourceDatabaseInfo(AbstractModel):
    r"""Source database description

    """

    def __init__(self):
        r"""
        :param _SourceDatabaseName: Source database name
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceDatabaseName: str
        :param _SourceTableNameList: Array of table names in the source database
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceTableNameList: list of str
        """
        self._SourceDatabaseName = None
        self._SourceTableNameList = None

    @property
    def SourceDatabaseName(self):
        r"""Source database name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SourceDatabaseName

    @SourceDatabaseName.setter
    def SourceDatabaseName(self, SourceDatabaseName):
        self._SourceDatabaseName = SourceDatabaseName

    @property
    def SourceTableNameList(self):
        r"""Array of table names in the source database
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SourceTableNameList

    @SourceTableNameList.setter
    def SourceTableNameList(self, SourceTableNameList):
        self._SourceTableNameList = SourceTableNameList


    def _deserialize(self, params):
        self._SourceDatabaseName = params.get("SourceDatabaseName")
        self._SourceTableNameList = params.get("SourceTableNameList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineBasicInfo(AbstractModel):
    r"""Basic information of DataEngine

    """

    def __init__(self):
        r"""
        :param _DataEngineName: DataEngine name
        :type DataEngineName: str
        :param _State: Data engine status: -2: deleted; -1: failed; 0: initializing; 1: suspended; 2: running; 3: ready to delete; 4: deleting
        :type State: int
        :param _CreateTime: Creation time
        :type CreateTime: int
        :param _UpdateTime: Update time
        :type UpdateTime: int
        :param _Message: Returned information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        :param _DataEngineType: Engine types, and the valid values are PrestoSQL, SparkSQL, and SparkBatch.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineType: str
        :param _AppId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppId: int
        :param _UserUin: Account ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserUin: str
        """
        self._DataEngineName = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Message = None
        self._DataEngineId = None
        self._DataEngineType = None
        self._AppId = None
        self._UserUin = None

    @property
    def DataEngineName(self):
        r"""DataEngine name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def State(self):
        r"""Data engine status: -2: deleted; -1: failed; 0: initializing; 1: suspended; 2: running; 3: ready to delete; 4: deleting
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Message(self):
        r"""Returned information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineType(self):
        r"""Engine types, and the valid values are PrestoSQL, SparkSQL, and SparkBatch.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineType

    @DataEngineType.setter
    def DataEngineType(self, DataEngineType):
        self._DataEngineType = DataEngineType

    @property
    def AppId(self):
        r"""User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def UserUin(self):
        r"""Account ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Message = params.get("Message")
        self._DataEngineId = params.get("DataEngineId")
        self._DataEngineType = params.get("DataEngineType")
        self._AppId = params.get("AppId")
        self._UserUin = params.get("UserUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineConfigInstanceInfo(AbstractModel):
    r"""Engine configuration information

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineId: str
        :param _DataEngineConfigPairs: Collection of user-defined configuration items
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _SessionResourceTemplate: Template of the resource parameter configuration of the job cluster
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        self._DataEngineId = None
        self._DataEngineConfigPairs = None
        self._SessionResourceTemplate = None

    @property
    def DataEngineId(self):
        r"""Engine ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineConfigPairs(self):
        r"""Collection of user-defined configuration items
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def SessionResourceTemplate(self):
        r"""Template of the resource parameter configuration of the job cluster
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineConfigPair(AbstractModel):
    r"""Engine configurations

    """

    def __init__(self):
        r"""
        :param _ConfigItem: Configuration items
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConfigItem: str
        :param _ConfigValue: Configuration values
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConfigValue: str
        """
        self._ConfigItem = None
        self._ConfigValue = None

    @property
    def ConfigItem(self):
        r"""Configuration items
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConfigItem

    @ConfigItem.setter
    def ConfigItem(self, ConfigItem):
        self._ConfigItem = ConfigItem

    @property
    def ConfigValue(self):
        r"""Configuration values
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ConfigValue

    @ConfigValue.setter
    def ConfigValue(self, ConfigValue):
        self._ConfigValue = ConfigValue


    def _deserialize(self, params):
        self._ConfigItem = params.get("ConfigItem")
        self._ConfigValue = params.get("ConfigValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineImageVersion(AbstractModel):
    r"""Information about the major version of the cluster image

    """

    def __init__(self):
        r"""
        :param _ImageVersionId: ID of the major version of the image
        :type ImageVersionId: str
        :param _ImageVersion: Name of the major version of the image
        :type ImageVersion: str
        :param _Description: Description of the major version of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _IsPublic: Whether it is a public version: 1: public version; 2: private version
        :type IsPublic: int
        :param _EngineType: Cluster types: SparkSQL, PrestoSQL, and SparkBatch
        :type EngineType: str
        :param _IsSharedEngine: Version status. 1: initializing; 2: online; 3: offline
        :type IsSharedEngine: int
        :param _State: Version status. 1: initializing; 2: online; 3: offline
        :type State: int
        :param _InsertTime: Insert time
        :type InsertTime: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        """
        self._ImageVersionId = None
        self._ImageVersion = None
        self._Description = None
        self._IsPublic = None
        self._EngineType = None
        self._IsSharedEngine = None
        self._State = None
        self._InsertTime = None
        self._UpdateTime = None

    @property
    def ImageVersionId(self):
        r"""ID of the major version of the image
        :rtype: str
        """
        return self._ImageVersionId

    @ImageVersionId.setter
    def ImageVersionId(self, ImageVersionId):
        self._ImageVersionId = ImageVersionId

    @property
    def ImageVersion(self):
        r"""Name of the major version of the image
        :rtype: str
        """
        return self._ImageVersion

    @ImageVersion.setter
    def ImageVersion(self, ImageVersion):
        self._ImageVersion = ImageVersion

    @property
    def Description(self):
        r"""Description of the major version of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsPublic(self):
        r"""Whether it is a public version: 1: public version; 2: private version
        :rtype: int
        """
        return self._IsPublic

    @IsPublic.setter
    def IsPublic(self, IsPublic):
        self._IsPublic = IsPublic

    @property
    def EngineType(self):
        r"""Cluster types: SparkSQL, PrestoSQL, and SparkBatch
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def IsSharedEngine(self):
        r"""Version status. 1: initializing; 2: online; 3: offline
        :rtype: int
        """
        return self._IsSharedEngine

    @IsSharedEngine.setter
    def IsSharedEngine(self, IsSharedEngine):
        self._IsSharedEngine = IsSharedEngine

    @property
    def State(self):
        r"""Version status. 1: initializing; 2: online; 3: offline
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def InsertTime(self):
        r"""Insert time
        :rtype: str
        """
        return self._InsertTime

    @InsertTime.setter
    def InsertTime(self, InsertTime):
        self._InsertTime = InsertTime

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._ImageVersionId = params.get("ImageVersionId")
        self._ImageVersion = params.get("ImageVersion")
        self._Description = params.get("Description")
        self._IsPublic = params.get("IsPublic")
        self._EngineType = params.get("EngineType")
        self._IsSharedEngine = params.get("IsSharedEngine")
        self._State = params.get("State")
        self._InsertTime = params.get("InsertTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineInfo(AbstractModel):
    r"""DataEngine details

    """

    def __init__(self):
        r"""
        :param _DataEngineName: DataEngine name
        :type DataEngineName: str
        :param _EngineType: Engine type: spark/presto
        :type EngineType: str
        :param _ClusterType: Cluster resource type spark_private/presto_private/presto_cu/spark_cu
        :type ClusterType: str
        :param _QuotaId: Quota ID
        :type QuotaId: str
        :param _State: Data engine status -2 deleted, -1 failed, 0 initializing, 1 suspended, 2 running, 3 ready to delete, and 4 deleting
        :type State: int
        :param _CreateTime: Creation time
        :type CreateTime: int
        :param _UpdateTime: Update time
        :type UpdateTime: int
        :param _Size: Cluster specifications
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type Size: int
        :param _Mode: Billing mode: 0 shared mode, 1 pay-as-you-go, and 2 monthly subscription
        :type Mode: int
        :param _MinClusters: Minimum number of clusters
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type MinClusters: int
        :param _MaxClusters: Maximum number of clusters
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type MaxClusters: int
        :param _AutoResume: Whether to recover automatically
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type AutoResume: bool
        :param _SpendAfter: Automatic recovery time
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type SpendAfter: int
        :param _CidrBlock: Cluster IP range
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type CidrBlock: str
        :param _DefaultDataEngine: Whether it is the default engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type DefaultDataEngine: bool
        :param _Message: Returned Message
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type Message: str
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        :param _SubAccountUin: Operator
        :type SubAccountUin: str
        :param _ExpireTime: Expiration time
        :type ExpireTime: str
        :param _IsolatedTime: Isolation time
        :type IsolatedTime: str
        :param _ReversalTime: Rectification time
        :type ReversalTime: str
        :param _UserAlias: Username
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type UserAlias: str
        :param _TagList: Key-value pair collection
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type TagList: list of TagInfo
        :param _Permissions: Permissions owned by the engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type Permissions: list of str
        :param _AutoSuspend: Whether to automatically suspend the cluster: False (by default) means that the cluster is not automatically suspended; true means that the cluster is automatically suspended.
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type AutoSuspend: bool
        :param _CrontabResumeSuspend: Scheduling policy of starting and ending the cluster: 0 (by default) indicates turning off the scheduling policy; 1 indicates turning on the scheduling policy. (Note: The scheduling policy of starting and ending the cluster and the automatic suspension policy are mutually exclusive.)
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type CrontabResumeSuspend: int
        :param _CrontabResumeSuspendStrategy: Scheduled start and end policy. Complex type: Include start and end time and the cluster suspension strategy.
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type CrontabResumeSuspendStrategy: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        :param _EngineExecType: Type of the task executed by the engine. Valid value: SQL/BATCH
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineExecType: str
        :param _RenewFlag: Automatic renewal flag: 0 means the initial state and there is no automatic renewal by default. If the user has the privilege to retain services with advanced payment, there will be an automatic renewal. 1 means that there is an automatic renewal. 2 means that there is surely no automatic renewal.
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type RenewFlag: int
        :param _AutoSuspendTime: Cluster automatic suspension time
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type AutoSuspendTime: int
        :param _NetworkConnectionSet: Network connection configuration
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type NetworkConnectionSet: list of NetworkConnection
        :param _UiURL: Jump address of ui
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type UiURL: str
        :param _ResourceType: Type of the engine resource
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type ResourceType: str
        :param _ImageVersionId: Cluster image version ID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type ImageVersionId: str
        :param _ChildImageVersionId: Minor cluster image version ID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type ChildImageVersionId: str
        :param _ImageVersionName: Cluster image version name
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type ImageVersionName: str
        :param _StartStandbyCluster: Whether to enable the standby cluster
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type StartStandbyCluster: bool
        :param _ElasticSwitch: Whether the elastic scaling of the spark jar monthly subscription cluster is enabled
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type ElasticSwitch: bool
        :param _ElasticLimit: Upper limit of the spark jar's monthly subscribed cluster elasticity
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type ElasticLimit: int
        :param _DefaultHouse: Whether it is the default engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type DefaultHouse: bool
        :param _MaxConcurrency: Maximum concurrency number of a single cluster
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type MaxConcurrency: int
        :param _TolerableQueueTime: Maximum time for the task to queue
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type TolerableQueueTime: int
        :param _UserAppId: User AppID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type UserAppId: int
        :param _UserUin: User uin
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type UserUin: str
        :param _SessionResourceTemplate: SessionResourceTemplate
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        :param _AutoAuthorization: Automatic authorization switch
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type AutoAuthorization: bool
        :param _EngineGeneration: Engine version, supporting Native/SuperSQL
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineGeneration: str
        :param _EngineTypeDetail: Detailed engine type, supporting SparkSQL/SparkBatch/PrestoSQL/Kyuubi
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineTypeDetail: str
        :param _EngineNetworkId: Engine network ID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineNetworkId: str
        :param _EngineResourceGroupCount: Number of resource groups associated with the standard engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineResourceGroupCount: int
        :param _EngineResourceUsedCU: Current usage of the engine (Cu)
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineResourceUsedCU: int
        :param _AccessInfos: Access information of the engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type AccessInfos: list of AccessInfo
        :param _EngineNetworkName: Name of the network where the engine is located
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type EngineNetworkName: str
        """
        self._DataEngineName = None
        self._EngineType = None
        self._ClusterType = None
        self._QuotaId = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Size = None
        self._Mode = None
        self._MinClusters = None
        self._MaxClusters = None
        self._AutoResume = None
        self._SpendAfter = None
        self._CidrBlock = None
        self._DefaultDataEngine = None
        self._Message = None
        self._DataEngineId = None
        self._SubAccountUin = None
        self._ExpireTime = None
        self._IsolatedTime = None
        self._ReversalTime = None
        self._UserAlias = None
        self._TagList = None
        self._Permissions = None
        self._AutoSuspend = None
        self._CrontabResumeSuspend = None
        self._CrontabResumeSuspendStrategy = None
        self._EngineExecType = None
        self._RenewFlag = None
        self._AutoSuspendTime = None
        self._NetworkConnectionSet = None
        self._UiURL = None
        self._ResourceType = None
        self._ImageVersionId = None
        self._ChildImageVersionId = None
        self._ImageVersionName = None
        self._StartStandbyCluster = None
        self._ElasticSwitch = None
        self._ElasticLimit = None
        self._DefaultHouse = None
        self._MaxConcurrency = None
        self._TolerableQueueTime = None
        self._UserAppId = None
        self._UserUin = None
        self._SessionResourceTemplate = None
        self._AutoAuthorization = None
        self._EngineGeneration = None
        self._EngineTypeDetail = None
        self._EngineNetworkId = None
        self._EngineResourceGroupCount = None
        self._EngineResourceUsedCU = None
        self._AccessInfos = None
        self._EngineNetworkName = None

    @property
    def DataEngineName(self):
        r"""DataEngine name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def EngineType(self):
        r"""Engine type: spark/presto
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def ClusterType(self):
        r"""Cluster resource type spark_private/presto_private/presto_cu/spark_cu
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def QuotaId(self):
        r"""Quota ID
        :rtype: str
        """
        return self._QuotaId

    @QuotaId.setter
    def QuotaId(self, QuotaId):
        self._QuotaId = QuotaId

    @property
    def State(self):
        r"""Data engine status -2 deleted, -1 failed, 0 initializing, 1 suspended, 2 running, 3 ready to delete, and 4 deleting
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Size(self):
        r"""Cluster specifications
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Mode(self):
        r"""Billing mode: 0 shared mode, 1 pay-as-you-go, and 2 monthly subscription
        :rtype: int
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def MinClusters(self):
        r"""Minimum number of clusters
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._MinClusters

    @MinClusters.setter
    def MinClusters(self, MinClusters):
        self._MinClusters = MinClusters

    @property
    def MaxClusters(self):
        r"""Maximum number of clusters
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._MaxClusters

    @MaxClusters.setter
    def MaxClusters(self, MaxClusters):
        self._MaxClusters = MaxClusters

    @property
    def AutoResume(self):
        r"""Whether to recover automatically
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._AutoResume

    @AutoResume.setter
    def AutoResume(self, AutoResume):
        self._AutoResume = AutoResume

    @property
    def SpendAfter(self):
        r"""Automatic recovery time
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._SpendAfter

    @SpendAfter.setter
    def SpendAfter(self, SpendAfter):
        self._SpendAfter = SpendAfter

    @property
    def CidrBlock(self):
        r"""Cluster IP range
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def DefaultDataEngine(self):
        r"""Whether it is the default engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._DefaultDataEngine

    @DefaultDataEngine.setter
    def DefaultDataEngine(self, DefaultDataEngine):
        self._DefaultDataEngine = DefaultDataEngine

    @property
    def Message(self):
        r"""Returned Message
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def SubAccountUin(self):
        r"""Operator
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def ExpireTime(self):
        r"""Expiration time
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def IsolatedTime(self):
        r"""Isolation time
        :rtype: str
        """
        return self._IsolatedTime

    @IsolatedTime.setter
    def IsolatedTime(self, IsolatedTime):
        self._IsolatedTime = IsolatedTime

    @property
    def ReversalTime(self):
        r"""Rectification time
        :rtype: str
        """
        return self._ReversalTime

    @ReversalTime.setter
    def ReversalTime(self, ReversalTime):
        self._ReversalTime = ReversalTime

    @property
    def UserAlias(self):
        r"""Username
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def TagList(self):
        r"""Key-value pair collection
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: list of TagInfo
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList

    @property
    def Permissions(self):
        r"""Permissions owned by the engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: list of str
        """
        return self._Permissions

    @Permissions.setter
    def Permissions(self, Permissions):
        self._Permissions = Permissions

    @property
    def AutoSuspend(self):
        r"""Whether to automatically suspend the cluster: False (by default) means that the cluster is not automatically suspended; true means that the cluster is automatically suspended.
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._AutoSuspend

    @AutoSuspend.setter
    def AutoSuspend(self, AutoSuspend):
        self._AutoSuspend = AutoSuspend

    @property
    def CrontabResumeSuspend(self):
        r"""Scheduling policy of starting and ending the cluster: 0 (by default) indicates turning off the scheduling policy; 1 indicates turning on the scheduling policy. (Note: The scheduling policy of starting and ending the cluster and the automatic suspension policy are mutually exclusive.)
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._CrontabResumeSuspend

    @CrontabResumeSuspend.setter
    def CrontabResumeSuspend(self, CrontabResumeSuspend):
        self._CrontabResumeSuspend = CrontabResumeSuspend

    @property
    def CrontabResumeSuspendStrategy(self):
        r"""Scheduled start and end policy. Complex type: Include start and end time and the cluster suspension strategy.
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        """
        return self._CrontabResumeSuspendStrategy

    @CrontabResumeSuspendStrategy.setter
    def CrontabResumeSuspendStrategy(self, CrontabResumeSuspendStrategy):
        self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy

    @property
    def EngineExecType(self):
        r"""Type of the task executed by the engine. Valid value: SQL/BATCH
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._EngineExecType

    @EngineExecType.setter
    def EngineExecType(self, EngineExecType):
        self._EngineExecType = EngineExecType

    @property
    def RenewFlag(self):
        r"""Automatic renewal flag: 0 means the initial state and there is no automatic renewal by default. If the user has the privilege to retain services with advanced payment, there will be an automatic renewal. 1 means that there is an automatic renewal. 2 means that there is surely no automatic renewal.
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def AutoSuspendTime(self):
        r"""Cluster automatic suspension time
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._AutoSuspendTime

    @AutoSuspendTime.setter
    def AutoSuspendTime(self, AutoSuspendTime):
        self._AutoSuspendTime = AutoSuspendTime

    @property
    def NetworkConnectionSet(self):
        r"""Network connection configuration
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: list of NetworkConnection
        """
        return self._NetworkConnectionSet

    @NetworkConnectionSet.setter
    def NetworkConnectionSet(self, NetworkConnectionSet):
        self._NetworkConnectionSet = NetworkConnectionSet

    @property
    def UiURL(self):
        r"""Jump address of ui
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._UiURL

    @UiURL.setter
    def UiURL(self, UiURL):
        self._UiURL = UiURL

    @property
    def ResourceType(self):
        r"""Type of the engine resource
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ImageVersionId(self):
        r"""Cluster image version ID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._ImageVersionId

    @ImageVersionId.setter
    def ImageVersionId(self, ImageVersionId):
        self._ImageVersionId = ImageVersionId

    @property
    def ChildImageVersionId(self):
        r"""Minor cluster image version ID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def ImageVersionName(self):
        r"""Cluster image version name
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._ImageVersionName

    @ImageVersionName.setter
    def ImageVersionName(self, ImageVersionName):
        self._ImageVersionName = ImageVersionName

    @property
    def StartStandbyCluster(self):
        r"""Whether to enable the standby cluster
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._StartStandbyCluster

    @StartStandbyCluster.setter
    def StartStandbyCluster(self, StartStandbyCluster):
        self._StartStandbyCluster = StartStandbyCluster

    @property
    def ElasticSwitch(self):
        r"""Whether the elastic scaling of the spark jar monthly subscription cluster is enabled
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._ElasticSwitch

    @ElasticSwitch.setter
    def ElasticSwitch(self, ElasticSwitch):
        self._ElasticSwitch = ElasticSwitch

    @property
    def ElasticLimit(self):
        r"""Upper limit of the spark jar's monthly subscribed cluster elasticity
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._ElasticLimit

    @ElasticLimit.setter
    def ElasticLimit(self, ElasticLimit):
        self._ElasticLimit = ElasticLimit

    @property
    def DefaultHouse(self):
        r"""Whether it is the default engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._DefaultHouse

    @DefaultHouse.setter
    def DefaultHouse(self, DefaultHouse):
        self._DefaultHouse = DefaultHouse

    @property
    def MaxConcurrency(self):
        r"""Maximum concurrency number of a single cluster
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def TolerableQueueTime(self):
        r"""Maximum time for the task to queue
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._TolerableQueueTime

    @TolerableQueueTime.setter
    def TolerableQueueTime(self, TolerableQueueTime):
        self._TolerableQueueTime = TolerableQueueTime

    @property
    def UserAppId(self):
        r"""User AppID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._UserAppId

    @UserAppId.setter
    def UserAppId(self, UserAppId):
        self._UserAppId = UserAppId

    @property
    def UserUin(self):
        r"""User uin
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def SessionResourceTemplate(self):
        r"""SessionResourceTemplate
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate

    @property
    def AutoAuthorization(self):
        r"""Automatic authorization switch
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: bool
        """
        return self._AutoAuthorization

    @AutoAuthorization.setter
    def AutoAuthorization(self, AutoAuthorization):
        self._AutoAuthorization = AutoAuthorization

    @property
    def EngineGeneration(self):
        r"""Engine version, supporting Native/SuperSQL
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration

    @property
    def EngineTypeDetail(self):
        r"""Detailed engine type, supporting SparkSQL/SparkBatch/PrestoSQL/Kyuubi
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._EngineTypeDetail

    @EngineTypeDetail.setter
    def EngineTypeDetail(self, EngineTypeDetail):
        self._EngineTypeDetail = EngineTypeDetail

    @property
    def EngineNetworkId(self):
        r"""Engine network ID
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._EngineNetworkId

    @EngineNetworkId.setter
    def EngineNetworkId(self, EngineNetworkId):
        self._EngineNetworkId = EngineNetworkId

    @property
    def EngineResourceGroupCount(self):
        r"""Number of resource groups associated with the standard engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._EngineResourceGroupCount

    @EngineResourceGroupCount.setter
    def EngineResourceGroupCount(self, EngineResourceGroupCount):
        self._EngineResourceGroupCount = EngineResourceGroupCount

    @property
    def EngineResourceUsedCU(self):
        r"""Current usage of the engine (Cu)
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: int
        """
        return self._EngineResourceUsedCU

    @EngineResourceUsedCU.setter
    def EngineResourceUsedCU(self, EngineResourceUsedCU):
        self._EngineResourceUsedCU = EngineResourceUsedCU

    @property
    def AccessInfos(self):
        r"""Access information of the engine
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: list of AccessInfo
        """
        return self._AccessInfos

    @AccessInfos.setter
    def AccessInfos(self, AccessInfos):
        self._AccessInfos = AccessInfos

    @property
    def EngineNetworkName(self):
        r"""Name of the network where the engine is located
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._EngineNetworkName

    @EngineNetworkName.setter
    def EngineNetworkName(self, EngineNetworkName):
        self._EngineNetworkName = EngineNetworkName


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._EngineType = params.get("EngineType")
        self._ClusterType = params.get("ClusterType")
        self._QuotaId = params.get("QuotaId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Size = params.get("Size")
        self._Mode = params.get("Mode")
        self._MinClusters = params.get("MinClusters")
        self._MaxClusters = params.get("MaxClusters")
        self._AutoResume = params.get("AutoResume")
        self._SpendAfter = params.get("SpendAfter")
        self._CidrBlock = params.get("CidrBlock")
        self._DefaultDataEngine = params.get("DefaultDataEngine")
        self._Message = params.get("Message")
        self._DataEngineId = params.get("DataEngineId")
        self._SubAccountUin = params.get("SubAccountUin")
        self._ExpireTime = params.get("ExpireTime")
        self._IsolatedTime = params.get("IsolatedTime")
        self._ReversalTime = params.get("ReversalTime")
        self._UserAlias = params.get("UserAlias")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = TagInfo()
                obj._deserialize(item)
                self._TagList.append(obj)
        self._Permissions = params.get("Permissions")
        self._AutoSuspend = params.get("AutoSuspend")
        self._CrontabResumeSuspend = params.get("CrontabResumeSuspend")
        if params.get("CrontabResumeSuspendStrategy") is not None:
            self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy()
            self._CrontabResumeSuspendStrategy._deserialize(params.get("CrontabResumeSuspendStrategy"))
        self._EngineExecType = params.get("EngineExecType")
        self._RenewFlag = params.get("RenewFlag")
        self._AutoSuspendTime = params.get("AutoSuspendTime")
        if params.get("NetworkConnectionSet") is not None:
            self._NetworkConnectionSet = []
            for item in params.get("NetworkConnectionSet"):
                obj = NetworkConnection()
                obj._deserialize(item)
                self._NetworkConnectionSet.append(obj)
        self._UiURL = params.get("UiURL")
        self._ResourceType = params.get("ResourceType")
        self._ImageVersionId = params.get("ImageVersionId")
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._ImageVersionName = params.get("ImageVersionName")
        self._StartStandbyCluster = params.get("StartStandbyCluster")
        self._ElasticSwitch = params.get("ElasticSwitch")
        self._ElasticLimit = params.get("ElasticLimit")
        self._DefaultHouse = params.get("DefaultHouse")
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._TolerableQueueTime = params.get("TolerableQueueTime")
        self._UserAppId = params.get("UserAppId")
        self._UserUin = params.get("UserUin")
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        self._AutoAuthorization = params.get("AutoAuthorization")
        self._EngineGeneration = params.get("EngineGeneration")
        self._EngineTypeDetail = params.get("EngineTypeDetail")
        self._EngineNetworkId = params.get("EngineNetworkId")
        self._EngineResourceGroupCount = params.get("EngineResourceGroupCount")
        self._EngineResourceUsedCU = params.get("EngineResourceUsedCU")
        if params.get("AccessInfos") is not None:
            self._AccessInfos = []
            for item in params.get("AccessInfos"):
                obj = AccessInfo()
                obj._deserialize(item)
                self._AccessInfos.append(obj)
        self._EngineNetworkName = params.get("EngineNetworkName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineScaleInfo(AbstractModel):
    r"""Engine specification details

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineId: str
        :param _DataEngineName: Engine name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineName: str
        :param _ScaleDetail: Engine specification details
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScaleDetail: list of DataEngineScaleInfoDetail
        """
        self._DataEngineId = None
        self._DataEngineName = None
        self._ScaleDetail = None

    @property
    def DataEngineId(self):
        r"""Engine ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineName(self):
        r"""Engine name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ScaleDetail(self):
        r"""Engine specification details
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DataEngineScaleInfoDetail
        """
        return self._ScaleDetail

    @ScaleDetail.setter
    def ScaleDetail(self, ScaleDetail):
        self._ScaleDetail = ScaleDetail


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._DataEngineName = params.get("DataEngineName")
        if params.get("ScaleDetail") is not None:
            self._ScaleDetail = []
            for item in params.get("ScaleDetail"):
                obj = DataEngineScaleInfoDetail()
                obj._deserialize(item)
                self._ScaleDetail.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataEngineScaleInfoDetail(AbstractModel):
    r"""Engine specification details

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time of counting in the format of yyyy-MM-dd HH:mm:ss
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param _EndTime: End time of counting in the format of yyyy-MM-dd HH:mm:ss
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _CU: Current statistical time period and engine specifications
Note: This field may return null, indicating that no valid values can be obtained.
        :type CU: int
        """
        self._StartTime = None
        self._EndTime = None
        self._CU = None

    @property
    def StartTime(self):
        r"""Start time of counting in the format of yyyy-MM-dd HH:mm:ss
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time of counting in the format of yyyy-MM-dd HH:mm:ss
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CU(self):
        r"""Current statistical time period and engine specifications
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CU

    @CU.setter
    def CU(self, CU):
        self._CU = CU


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CU = params.get("CU")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataGovernPolicy(AbstractModel):
    r"""The data governance rules.

    """

    def __init__(self):
        r"""
        :param _RuleType: Governance rule type. Valid values: `Customize` (custom) and `Intelligence` (intelligent).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleType: str
        :param _GovernEngine: The governance engine.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GovernEngine: str
        """
        self._RuleType = None
        self._GovernEngine = None

    @property
    def RuleType(self):
        r"""Governance rule type. Valid values: `Customize` (custom) and `Intelligence` (intelligent).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def GovernEngine(self):
        r"""The governance engine.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._GovernEngine

    @GovernEngine.setter
    def GovernEngine(self, GovernEngine):
        self._GovernEngine = GovernEngine


    def _deserialize(self, params):
        self._RuleType = params.get("RuleType")
        self._GovernEngine = params.get("GovernEngine")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataMaskStrategy(AbstractModel):
    r"""DMask policy information.

    """

    def __init__(self):
        r"""
        :param _StrategyId: Policy ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyId: str
        :param _UserAppId: User AppId

Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAppId: str
        :param _Uin: User UIN

Note: This field may return null, indicating that no valid values can be obtained.
        :type Uin: str
        :param _SubAccountUin: Specifies the uin of the user sub-account to operate.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubAccountUin: str
        :param _StrategyName: Policy name

Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyName: str
        :param _StrategyType: MASK_SHOW_FIRST_4, MASK_SHOW_LAST_4, MASK_HASH, MASK_DATE_SHOW_YEAR, MASK_NULL, MASK_DEFAULT.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyType: str
        :param _StrategyDesc: Policy description

Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyDesc: str
        :param _Groups: User group policy list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Groups: list of GroupInfo
        :param _Users: User sub-account uin list, concatenated by ;.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Users: str
        :param _State: 1: in effect; 0: deleted.
Note: This field may return null, indicating that no valid values can be obtained.
        :type State: int
        :param _CreateTime: Policy creation time. timestamp in milliseconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _UpdateTime: Policy update time. timestamp in milliseconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: int
        """
        self._StrategyId = None
        self._UserAppId = None
        self._Uin = None
        self._SubAccountUin = None
        self._StrategyName = None
        self._StrategyType = None
        self._StrategyDesc = None
        self._Groups = None
        self._Users = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def StrategyId(self):
        r"""Policy ID

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def UserAppId(self):
        r"""User AppId

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAppId

    @UserAppId.setter
    def UserAppId(self, UserAppId):
        self._UserAppId = UserAppId

    @property
    def Uin(self):
        r"""User UIN

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        r"""Specifies the uin of the user sub-account to operate.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def StrategyName(self):
        r"""Policy name

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def StrategyType(self):
        r"""MASK_SHOW_FIRST_4, MASK_SHOW_LAST_4, MASK_HASH, MASK_DATE_SHOW_YEAR, MASK_NULL, MASK_DEFAULT.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def StrategyDesc(self):
        r"""Policy description

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StrategyDesc

    @StrategyDesc.setter
    def StrategyDesc(self, StrategyDesc):
        self._StrategyDesc = StrategyDesc

    @property
    def Groups(self):
        r"""User group policy list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def Users(self):
        r"""User sub-account uin list, concatenated by ;.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def State(self):
        r"""1: in effect; 0: deleted.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""Policy creation time. timestamp in milliseconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Policy update time. timestamp in milliseconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._UserAppId = params.get("UserAppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        self._StrategyName = params.get("StrategyName")
        self._StrategyType = params.get("StrategyType")
        self._StrategyDesc = params.get("StrategyDesc")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._Users = params.get("Users")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataMaskStrategyInfo(AbstractModel):
    r"""DMask policy information.

    """

    def __init__(self):
        r"""
        :param _StrategyName: Policy name
        :type StrategyName: str
        :param _StrategyType: MASK_SHOW_FIRST_4, MASK_SHOW_LAST_4, MASK_HASH, MASK_DATE_SHOW_YEAR, MASK_NULL, MASK_DEFAULT.
        :type StrategyType: str
        :param _StrategyDesc: Policy description
        :type StrategyDesc: str
        :param _Groups: User group policy list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Groups: list of GroupInfo
        :param _Users: User sub-account uin list, concatenated by ;.
        :type Users: str
        :param _StrategyId: Policy ID
        :type StrategyId: str
        """
        self._StrategyName = None
        self._StrategyType = None
        self._StrategyDesc = None
        self._Groups = None
        self._Users = None
        self._StrategyId = None

    @property
    def StrategyName(self):
        r"""Policy name
        :rtype: str
        """
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def StrategyType(self):
        r"""MASK_SHOW_FIRST_4, MASK_SHOW_LAST_4, MASK_HASH, MASK_DATE_SHOW_YEAR, MASK_NULL, MASK_DEFAULT.
        :rtype: str
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType

    @property
    def StrategyDesc(self):
        r"""Policy description
        :rtype: str
        """
        return self._StrategyDesc

    @StrategyDesc.setter
    def StrategyDesc(self, StrategyDesc):
        self._StrategyDesc = StrategyDesc

    @property
    def Groups(self):
        r"""User group policy list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of GroupInfo
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def Users(self):
        r"""User sub-account uin list, concatenated by ;.
        :rtype: str
        """
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def StrategyId(self):
        r"""Policy ID
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        self._StrategyType = params.get("StrategyType")
        self._StrategyDesc = params.get("StrategyDesc")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._Users = params.get("Users")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataMaskStrategyPolicy(AbstractModel):
    r"""Masking policy permission object.

    """

    def __init__(self):
        r"""
        :param _PolicyInfo: Masking permission object.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyInfo: :class:`tencentcloud.dlc.v20210125.models.Policy`
        :param _DataMaskStrategyId: Masking policy ID. specifies the ID of the data masking policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataMaskStrategyId: str
        :param _ColumnType: Bound field type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ColumnType: str
        """
        self._PolicyInfo = None
        self._DataMaskStrategyId = None
        self._ColumnType = None

    @property
    def PolicyInfo(self):
        r"""Masking permission object.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policy`
        """
        return self._PolicyInfo

    @PolicyInfo.setter
    def PolicyInfo(self, PolicyInfo):
        self._PolicyInfo = PolicyInfo

    @property
    def DataMaskStrategyId(self):
        r"""Masking policy ID. specifies the ID of the data masking policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataMaskStrategyId

    @DataMaskStrategyId.setter
    def DataMaskStrategyId(self, DataMaskStrategyId):
        self._DataMaskStrategyId = DataMaskStrategyId

    @property
    def ColumnType(self):
        r"""Bound field type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType


    def _deserialize(self, params):
        if params.get("PolicyInfo") is not None:
            self._PolicyInfo = Policy()
            self._PolicyInfo._deserialize(params.get("PolicyInfo"))
        self._DataMaskStrategyId = params.get("DataMaskStrategyId")
        self._ColumnType = params.get("ColumnType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCHDFSBindingProductRequest(AbstractModel):
    r"""DeleteCHDFSBindingProduct request structure.

    """

    def __init__(self):
        r"""
        :param _MountPoint: Names of metadata acceleration buckets to be unbound
        :type MountPoint: str
        :param _BucketType: Types of buckets which are divided into cos and lakefs
        :type BucketType: str
        :param _ProductName: Product name
        :type ProductName: str
        :param _EngineName: Engine name. When ProductName selects DLC products, this parameter must be specified. When ProductName selects other products, it can be unspecified.
        :type EngineName: str
        :param _VpcInfo: VPC information. When ProductName is other, this parameter must be specified.
        :type VpcInfo: list of VpcInfo
        """
        self._MountPoint = None
        self._BucketType = None
        self._ProductName = None
        self._EngineName = None
        self._VpcInfo = None

    @property
    def MountPoint(self):
        r"""Names of metadata acceleration buckets to be unbound
        :rtype: str
        """
        return self._MountPoint

    @MountPoint.setter
    def MountPoint(self, MountPoint):
        self._MountPoint = MountPoint

    @property
    def BucketType(self):
        r"""Types of buckets which are divided into cos and lakefs
        :rtype: str
        """
        return self._BucketType

    @BucketType.setter
    def BucketType(self, BucketType):
        self._BucketType = BucketType

    @property
    def ProductName(self):
        r"""Product name
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def EngineName(self):
        r"""Engine name. When ProductName selects DLC products, this parameter must be specified. When ProductName selects other products, it can be unspecified.
        :rtype: str
        """
        return self._EngineName

    @EngineName.setter
    def EngineName(self, EngineName):
        self._EngineName = EngineName

    @property
    def VpcInfo(self):
        r"""VPC information. When ProductName is other, this parameter must be specified.
        :rtype: list of VpcInfo
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo


    def _deserialize(self, params):
        self._MountPoint = params.get("MountPoint")
        self._BucketType = params.get("BucketType")
        self._ProductName = params.get("ProductName")
        self._EngineName = params.get("EngineName")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = []
            for item in params.get("VpcInfo"):
                obj = VpcInfo()
                obj._deserialize(item)
                self._VpcInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCHDFSBindingProductResponse(AbstractModel):
    r"""DeleteCHDFSBindingProduct response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDataEngineRequest(AbstractModel):
    r"""DeleteDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineNames: Delete the name array of virtual clusters.
        :type DataEngineNames: list of str
        """
        self._DataEngineNames = None

    @property
    def DataEngineNames(self):
        r"""Delete the name array of virtual clusters.
        :rtype: list of str
        """
        return self._DataEngineNames

    @DataEngineNames.setter
    def DataEngineNames(self, DataEngineNames):
        self._DataEngineNames = DataEngineNames


    def _deserialize(self, params):
        self._DataEngineNames = params.get("DataEngineNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataEngineResponse(AbstractModel):
    r"""DeleteDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDataMaskStrategyRequest(AbstractModel):
    r"""DeleteDataMaskStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _StrategyId: DMask policy Id. specifies the Id of the data masking policy.
        :type StrategyId: str
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        r"""DMask policy Id. specifies the Id of the data masking policy.
        :rtype: str
        """
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataMaskStrategyResponse(AbstractModel):
    r"""DeleteDataMaskStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSparkAppRequest(AbstractModel):
    r"""DeleteSparkApp request structure.

    """

    def __init__(self):
        r"""
        :param _AppName: The Spark job name.
        :type AppName: str
        """
        self._AppName = None

    @property
    def AppName(self):
        r"""The Spark job name.
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSparkAppResponse(AbstractModel):
    r"""DeleteSparkApp response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteThirdPartyAccessUserRequest(AbstractModel):
    r"""DeleteThirdPartyAccessUser request structure.

    """


class DeleteThirdPartyAccessUserResponse(AbstractModel):
    r"""DeleteThirdPartyAccessUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserRequest(AbstractModel):
    r"""DeleteUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserIds: ID of the user to be deleted
        :type UserIds: list of str
        """
        self._UserIds = None

    @property
    def UserIds(self):
        r"""ID of the user to be deleted
        :rtype: list of str
        """
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds


    def _deserialize(self, params):
        self._UserIds = params.get("UserIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserResponse(AbstractModel):
    r"""DeleteUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUsersFromWorkGroupRequest(AbstractModel):
    r"""DeleteUsersFromWorkGroup request structure.

    """

    def __init__(self):
        r"""
        :param _AddInfo: User information to be deleted
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""User information to be deleted
        :rtype: :class:`tencentcloud.dlc.v20210125.models.UserIdSetOfWorkGroupId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = UserIdSetOfWorkGroupId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUsersFromWorkGroupResponse(AbstractModel):
    r"""DeleteUsersFromWorkGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWorkGroupRequest(AbstractModel):
    r"""DeleteWorkGroup request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupIds: Collection of IDs of working groups to be deleted
        :type WorkGroupIds: list of int
        """
        self._WorkGroupIds = None

    @property
    def WorkGroupIds(self):
        r"""Collection of IDs of working groups to be deleted
        :rtype: list of int
        """
        return self._WorkGroupIds

    @WorkGroupIds.setter
    def WorkGroupIds(self, WorkGroupIds):
        self._WorkGroupIds = WorkGroupIds


    def _deserialize(self, params):
        self._WorkGroupIds = params.get("WorkGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkGroupResponse(AbstractModel):
    r"""DeleteWorkGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAdvancedStoreLocationRequest(AbstractModel):
    r"""DescribeAdvancedStoreLocation request structure.

    """


class DescribeAdvancedStoreLocationResponse(AbstractModel):
    r"""DescribeAdvancedStoreLocation response structure.

    """

    def __init__(self):
        r"""
        :param _Enable: Whether to enable advanced settings. 0 means no while 1 means yes.
        :type Enable: int
        :param _StoreLocation: COS path of saving querying results
        :type StoreLocation: str
        :param _HasLakeFs: Whether there is permission for managed storage
        :type HasLakeFs: bool
        :param _LakeFsStatus: Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LakeFsStatus: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Enable = None
        self._StoreLocation = None
        self._HasLakeFs = None
        self._LakeFsStatus = None
        self._RequestId = None

    @property
    def Enable(self):
        r"""Whether to enable advanced settings. 0 means no while 1 means yes.
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def StoreLocation(self):
        r"""COS path of saving querying results
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation

    @property
    def HasLakeFs(self):
        r"""Whether there is permission for managed storage
        :rtype: bool
        """
        return self._HasLakeFs

    @HasLakeFs.setter
    def HasLakeFs(self, HasLakeFs):
        self._HasLakeFs = HasLakeFs

    @property
    def LakeFsStatus(self):
        r"""Managed storage status. The value is meaningful only when HasLakeFs is equal to true.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LakeFsStatus

    @LakeFsStatus.setter
    def LakeFsStatus(self, LakeFsStatus):
        self._LakeFsStatus = LakeFsStatus

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._StoreLocation = params.get("StoreLocation")
        self._HasLakeFs = params.get("HasLakeFs")
        self._LakeFsStatus = params.get("LakeFsStatus")
        self._RequestId = params.get("RequestId")


class DescribeDLCCatalogAccessRequest(AbstractModel):
    r"""DescribeDLCCatalogAccess request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Displayed records
        :type Limit: int
        :param _Offset: Number of records
        :type Offset: int
        :param _Filter: Filter criteria
        :type Filter: :class:`tencentcloud.dlc.v20210125.models.Filter`
        """
        self._Limit = None
        self._Offset = None
        self._Filter = None

    @property
    def Limit(self):
        r"""Displayed records
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Number of records
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filter(self):
        r"""Filter criteria
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Filter`
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filter") is not None:
            self._Filter = Filter()
            self._Filter._deserialize(params.get("Filter"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDLCCatalogAccessResponse(AbstractModel):
    r"""DescribeDLCCatalogAccess response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total
        :type TotalCount: int
        :param _Rows: List of the permissions granted by DLCCatalog
        :type Rows: list of DLCCatalogAccess
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Rows = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Rows(self):
        r"""List of the permissions granted by DLCCatalog
        :rtype: list of DLCCatalogAccess
        """
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DLCCatalogAccess()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDLCTableListRequest(AbstractModel):
    r"""DescribeDLCTableList request structure.

    """

    def __init__(self):
        r"""
        :param _DbName: Database name
        :type DbName: str
        :param _Catalog: Catalog name
        :type Catalog: str
        :param _Filters: Query the list's filter criteria.
        :type Filters: :class:`tencentcloud.dlc.v20210125.models.Filter`
        :param _Type: Table type
        :type Type: str
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _Limit: Pagination parameters
        :type Limit: int
        :param _Offset: Pagination parameters
        :type Offset: int
        :param _Sort: Sorting fields
        :type Sort: str
        :param _Asc: Sorting rules: true for ascending order; false for descending order
        :type Asc: bool
        :param _TableFormat: Data format type: hive, iceberg, etc.
        :type TableFormat: str
        """
        self._DbName = None
        self._Catalog = None
        self._Filters = None
        self._Type = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._Sort = None
        self._Asc = None
        self._TableFormat = None

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def Catalog(self):
        r"""Catalog name
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Filters(self):
        r"""Query the list's filter criteria.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Filter`
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Type(self):
        r"""Table type
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartTime(self):
        r"""Start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""Pagination parameters
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Pagination parameters
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Sort(self):
        r"""Sorting fields
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""Sorting rules: true for ascending order; false for descending order
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def TableFormat(self):
        r"""Data format type: hive, iceberg, etc.
        :rtype: str
        """
        return self._TableFormat

    @TableFormat.setter
    def TableFormat(self, TableFormat):
        self._TableFormat = TableFormat


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._Catalog = params.get("Catalog")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        self._Type = params.get("Type")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._TableFormat = params.get("TableFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDLCTableListResponse(AbstractModel):
    r"""DescribeDLCTableList response structure.

    """

    def __init__(self):
        r"""
        :param _TableList: DLC metadata list information
Note: This field may return null, indicating that no valid values can be obtained.
        :type TableList: list of DLCTable
        :param _TotalCount: Statistical value
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableList(self):
        r"""DLC metadata list information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DLCTable
        """
        return self._TableList

    @TableList.setter
    def TableList(self, TableList):
        self._TableList = TableList

    @property
    def TotalCount(self):
        r"""Statistical value
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableList") is not None:
            self._TableList = []
            for item in params.get("TableList"):
                obj = DLCTable()
                obj._deserialize(item)
                self._TableList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDLCTableRequest(AbstractModel):
    r"""DescribeDLCTable request structure.

    """

    def __init__(self):
        r"""
        :param _DbName: Database name
        :type DbName: str
        :param _Name: Data table name
        :type Name: str
        :param _Catalog: Catalog name
        :type Catalog: str
        :param _Keyword: Keyword
        :type Keyword: str
        :param _Pattern: Match rules
        :type Pattern: str
        :param _Type: Table type
        :type Type: str
        """
        self._DbName = None
        self._Name = None
        self._Catalog = None
        self._Keyword = None
        self._Pattern = None
        self._Type = None

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def Name(self):
        r"""Data table name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Catalog(self):
        r"""Catalog name
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Keyword(self):
        r"""Keyword
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Pattern(self):
        r"""Match rules
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern

    @property
    def Type(self):
        r"""Table type
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._Name = params.get("Name")
        self._Catalog = params.get("Catalog")
        self._Keyword = params.get("Keyword")
        self._Pattern = params.get("Pattern")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDLCTableResponse(AbstractModel):
    r"""DescribeDLCTable response structure.

    """

    def __init__(self):
        r"""
        :param _DLCTable: Data table information object
Note: This field may return null, indicating that no valid values can be obtained.
        :type DLCTable: :class:`tencentcloud.dlc.v20210125.models.DLCTable`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DLCTable = None
        self._RequestId = None

    @property
    def DLCTable(self):
        r"""Data table information object
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DLCTable`
        """
        return self._DLCTable

    @DLCTable.setter
    def DLCTable(self, DLCTable):
        self._DLCTable = DLCTable

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DLCTable") is not None:
            self._DLCTable = DLCTable()
            self._DLCTable._deserialize(params.get("DLCTable"))
        self._RequestId = params.get("RequestId")


class DescribeDMSDatabaseListRequest(AbstractModel):
    r"""DescribeDMSDatabaseList request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Database name
        :type Name: str
        :param _SchemaName: Schema name
        :type SchemaName: str
        :param _Pattern: Match rules
        :type Pattern: str
        :param _Limit: Pagination parameters, indicating the size of a single page.
        :type Limit: int
        :param _Offset: Pagination parameters
        :type Offset: int
        :param _Sort: Sorting fields
        :type Sort: str
        :param _Asc: Sorting fields: true for ascending order; false for descending order
        :type Asc: bool
        """
        self._Name = None
        self._SchemaName = None
        self._Pattern = None
        self._Limit = None
        self._Offset = None
        self._Sort = None
        self._Asc = None

    @property
    def Name(self):
        r"""Database name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SchemaName(self):
        r"""Schema name
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Pattern(self):
        r"""Match rules
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern

    @property
    def Limit(self):
        r"""Pagination parameters, indicating the size of a single page.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Pagination parameters
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Sort(self):
        r"""Sorting fields
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""Sorting fields: true for ascending order; false for descending order
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SchemaName = params.get("SchemaName")
        self._Pattern = params.get("Pattern")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDMSDatabaseListResponse(AbstractModel):
    r"""DescribeDMSDatabaseList response structure.

    """

    def __init__(self):
        r"""
        :param _DatabaseList: List of database objects for the DMS
        :type DatabaseList: list of DMSDatabaseInfo
        :param _TotalCount: Total number of databases
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DatabaseList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DatabaseList(self):
        r"""List of database objects for the DMS
        :rtype: list of DMSDatabaseInfo
        """
        return self._DatabaseList

    @DatabaseList.setter
    def DatabaseList(self, DatabaseList):
        self._DatabaseList = DatabaseList

    @property
    def TotalCount(self):
        r"""Total number of databases
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseList") is not None:
            self._DatabaseList = []
            for item in params.get("DatabaseList"):
                obj = DMSDatabaseInfo()
                obj._deserialize(item)
                self._DatabaseList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDMSDatabaseRequest(AbstractModel):
    r"""DescribeDMSDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Database name
        :type Name: str
        :param _SchemaName: Schema name
        :type SchemaName: str
        :param _Pattern: Match rules
        :type Pattern: str
        """
        self._Name = None
        self._SchemaName = None
        self._Pattern = None

    @property
    def Name(self):
        r"""Database name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SchemaName(self):
        r"""Schema name
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Pattern(self):
        r"""Match rules
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SchemaName = params.get("SchemaName")
        self._Pattern = params.get("Pattern")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDMSDatabaseResponse(AbstractModel):
    r"""DescribeDMSDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _Name: Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _SchemaName: Schema name
Note: This field may return null, indicating that no valid values can be obtained.
        :type SchemaName: str
        :param _Location: Storage address
Note: This field may return null, indicating that no valid values can be obtained.
        :type Location: str
        :param _Asset: Data object
Note: This field may return null, indicating that no valid values can be obtained.
        :type Asset: :class:`tencentcloud.dlc.v20210125.models.Asset`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Name = None
        self._SchemaName = None
        self._Location = None
        self._Asset = None
        self._RequestId = None

    @property
    def Name(self):
        r"""Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SchemaName(self):
        r"""Schema name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def Location(self):
        r"""Storage address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def Asset(self):
        r"""Data object
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Asset`
        """
        return self._Asset

    @Asset.setter
    def Asset(self, Asset):
        self._Asset = Asset

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SchemaName = params.get("SchemaName")
        self._Location = params.get("Location")
        if params.get("Asset") is not None:
            self._Asset = Asset()
            self._Asset._deserialize(params.get("Asset"))
        self._RequestId = params.get("RequestId")


class DescribeDataEngineImageVersionsRequest(AbstractModel):
    r"""DescribeDataEngineImageVersions request structure.

    """

    def __init__(self):
        r"""
        :param _EngineType: Types of engines: SQL, SparkBatch, StandardSpark, and StandardPresto
        :type EngineType: str
        :param _Sort: 
        :type Sort: str
        :param _Asc: 
        :type Asc: bool
        """
        self._EngineType = None
        self._Sort = None
        self._Asc = None

    @property
    def EngineType(self):
        r"""Types of engines: SQL, SparkBatch, StandardSpark, and StandardPresto
        :rtype: str
        """
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def Sort(self):
        r"""
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._EngineType = params.get("EngineType")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEngineImageVersionsResponse(AbstractModel):
    r"""DescribeDataEngineImageVersions response structure.

    """

    def __init__(self):
        r"""
        :param _ImageParentVersions: Major version of the image information list of clusters
        :type ImageParentVersions: list of DataEngineImageVersion
        :param _Total: Total
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageParentVersions = None
        self._Total = None
        self._RequestId = None

    @property
    def ImageParentVersions(self):
        r"""Major version of the image information list of clusters
        :rtype: list of DataEngineImageVersion
        """
        return self._ImageParentVersions

    @ImageParentVersions.setter
    def ImageParentVersions(self, ImageParentVersions):
        self._ImageParentVersions = ImageParentVersions

    @property
    def Total(self):
        r"""Total
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageParentVersions") is not None:
            self._ImageParentVersions = []
            for item in params.get("ImageParentVersions"):
                obj = DataEngineImageVersion()
                obj._deserialize(item)
                self._ImageParentVersions.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeDataEnginePythonSparkImagesRequest(AbstractModel):
    r"""DescribeDataEnginePythonSparkImages request structure.

    """

    def __init__(self):
        r"""
        :param _ChildImageVersionId: ID of the minor version of the cluster image
        :type ChildImageVersionId: str
        """
        self._ChildImageVersionId = None

    @property
    def ChildImageVersionId(self):
        r"""ID of the minor version of the cluster image
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId


    def _deserialize(self, params):
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEnginePythonSparkImagesResponse(AbstractModel):
    r"""DescribeDataEnginePythonSparkImages response structure.

    """

    def __init__(self):
        r"""
        :param _PythonSparkImages: PYSPARK image information list
        :type PythonSparkImages: list of PythonSparkImage
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PythonSparkImages = None
        self._RequestId = None

    @property
    def PythonSparkImages(self):
        r"""PYSPARK image information list
        :rtype: list of PythonSparkImage
        """
        return self._PythonSparkImages

    @PythonSparkImages.setter
    def PythonSparkImages(self, PythonSparkImages):
        self._PythonSparkImages = PythonSparkImages

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PythonSparkImages") is not None:
            self._PythonSparkImages = []
            for item in params.get("PythonSparkImages"):
                obj = PythonSparkImage()
                obj._deserialize(item)
                self._PythonSparkImages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataEngineRequest(AbstractModel):
    r"""DescribeDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: House name
        :type DataEngineName: str
        """
        self._DataEngineName = None

    @property
    def DataEngineName(self):
        r"""House name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEngineResponse(AbstractModel):
    r"""DescribeDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _DataEngine: Data engine details
        :type DataEngine: :class:`tencentcloud.dlc.v20210125.models.DataEngineInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataEngine = None
        self._RequestId = None

    @property
    def DataEngine(self):
        r"""Data engine details
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataEngineInfo`
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngine") is not None:
            self._DataEngine = DataEngineInfo()
            self._DataEngine._deserialize(params.get("DataEngine"))
        self._RequestId = params.get("RequestId")


class DescribeDataEnginesScaleDetailRequest(AbstractModel):
    r"""DescribeDataEnginesScaleDetail request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineNames: Engine name list
        :type DataEngineNames: list of str
        :param _StartTime: Start time, and the format is yyyy-MM-dd HH:mm:ss. It can query the records within one month at most.
        :type StartTime: str
        :param _EndTime: End time, and the format is yyyy-MM-dd HH:mm:ss. It can query the records within one month at most.
        :type EndTime: str
        """
        self._DataEngineNames = None
        self._StartTime = None
        self._EndTime = None

    @property
    def DataEngineNames(self):
        r"""Engine name list
        :rtype: list of str
        """
        return self._DataEngineNames

    @DataEngineNames.setter
    def DataEngineNames(self, DataEngineNames):
        self._DataEngineNames = DataEngineNames

    @property
    def StartTime(self):
        r"""Start time, and the format is yyyy-MM-dd HH:mm:ss. It can query the records within one month at most.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time, and the format is yyyy-MM-dd HH:mm:ss. It can query the records within one month at most.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._DataEngineNames = params.get("DataEngineNames")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataEnginesScaleDetailResponse(AbstractModel):
    r"""DescribeDataEnginesScaleDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Scales: Details about the statistics of engine specifications
Note: This field may return null, indicating that no valid values can be obtained.
        :type Scales: list of DataEngineScaleInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Scales = None
        self._RequestId = None

    @property
    def Scales(self):
        r"""Details about the statistics of engine specifications
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DataEngineScaleInfo
        """
        return self._Scales

    @Scales.setter
    def Scales(self, Scales):
        self._Scales = Scales

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Scales") is not None:
            self._Scales = []
            for item in params.get("Scales"):
                obj = DataEngineScaleInfo()
                obj._deserialize(item)
                self._Scales.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataMaskStrategiesRequest(AbstractModel):
    r"""DescribeDataMaskStrategies request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: The pagination parameter, specifies the amount of data returned per page. it is 10 by default.
        :type Limit: int
        :param _Offset: Pagination parameters. data offset. default: 0.
        :type Offset: int
        :param _Filters: Filter field. strategy-name: search by policy name.
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        r"""The pagination parameter, specifies the amount of data returned per page. it is 10 by default.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Pagination parameters. data offset. default: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter field. strategy-name: search by policy name.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataMaskStrategiesResponse(AbstractModel):
    r"""DescribeDataMaskStrategies response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total DMask policies.
        :type TotalCount: int
        :param _Strategies: DMask policy list. specifies the list of data masking policies.
        :type Strategies: list of DataMaskStrategy
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Strategies = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total DMask policies.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Strategies(self):
        r"""DMask policy list. specifies the list of data masking policies.
        :rtype: list of DataMaskStrategy
        """
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = DataMaskStrategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEngineUsageInfoRequest(AbstractModel):
    r"""DescribeEngineUsageInfo request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: The data engine ID.
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""The data engine ID.
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEngineUsageInfoResponse(AbstractModel):
    r"""DescribeEngineUsageInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Total: The total cluster spec.
        :type Total: int
        :param _Used: The used cluster spec.
        :type Used: int
        :param _Available: The available cluster spec.
        :type Available: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Used = None
        self._Available = None
        self._RequestId = None

    @property
    def Total(self):
        r"""The total cluster spec.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Used(self):
        r"""The used cluster spec.
        :rtype: int
        """
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def Available(self):
        r"""The available cluster spec.
        :rtype: int
        """
        return self._Available

    @Available.setter
    def Available(self, Available):
        self._Available = Available

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        self._Used = params.get("Used")
        self._Available = params.get("Available")
        self._RequestId = params.get("RequestId")


class DescribeForbiddenTableProRequest(AbstractModel):
    r"""DescribeForbiddenTablePro request structure.

    """


class DescribeForbiddenTableProResponse(AbstractModel):
    r"""DescribeForbiddenTablePro response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeJobRequest(AbstractModel):
    r"""DescribeJob request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID
        :type JobId: str
        """
        self._JobId = None

    @property
    def JobId(self):
        r"""Job ID
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJobResponse(AbstractModel):
    r"""DescribeJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobName: Job name
        :type JobName: str
        :param _StatisticInfo: Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StatisticInfo: :class:`tencentcloud.dlc.v20210125.models.StatisticInfo`
        :param _JobConfiguration: Job configuration
        :type JobConfiguration: str
        :param _JobStatus: Job status:
        :type JobStatus: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobName = None
        self._StatisticInfo = None
        self._JobConfiguration = None
        self._JobStatus = None
        self._RequestId = None

    @property
    def JobName(self):
        r"""Job name
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName

    @property
    def StatisticInfo(self):
        r"""Task statistics information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.StatisticInfo`
        """
        return self._StatisticInfo

    @StatisticInfo.setter
    def StatisticInfo(self, StatisticInfo):
        self._StatisticInfo = StatisticInfo

    @property
    def JobConfiguration(self):
        r"""Job configuration
        :rtype: str
        """
        return self._JobConfiguration

    @JobConfiguration.setter
    def JobConfiguration(self, JobConfiguration):
        self._JobConfiguration = JobConfiguration

    @property
    def JobStatus(self):
        r"""Job status:
        :rtype: int
        """
        return self._JobStatus

    @JobStatus.setter
    def JobStatus(self, JobStatus):
        self._JobStatus = JobStatus

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobName = params.get("JobName")
        if params.get("StatisticInfo") is not None:
            self._StatisticInfo = StatisticInfo()
            self._StatisticInfo._deserialize(params.get("StatisticInfo"))
        self._JobConfiguration = params.get("JobConfiguration")
        self._JobStatus = params.get("JobStatus")
        self._RequestId = params.get("RequestId")


class DescribeJobsRequest(AbstractModel):
    r"""DescribeJobs request structure.

    """

    def __init__(self):
        r"""
        :param _Keyword: Query keywords
        :type Keyword: str
        :param _Pattern: Matching mode
        :type Pattern: str
        :param _Limit: Pagination parameters
        :type Limit: int
        :param _Offset: Pagination parameters
        :type Offset: int
        :param _Sort: Sorting fields
        :type Sort: str
        :param _Asc: Sorting fields, and true means the ascending order (by default) while false means the descending order.
        :type Asc: bool
        """
        self._Keyword = None
        self._Pattern = None
        self._Limit = None
        self._Offset = None
        self._Sort = None
        self._Asc = None

    @property
    def Keyword(self):
        r"""Query keywords
        :rtype: str
        """
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Pattern(self):
        r"""Matching mode
        :rtype: str
        """
        return self._Pattern

    @Pattern.setter
    def Pattern(self, Pattern):
        self._Pattern = Pattern

    @property
    def Limit(self):
        r"""Pagination parameters
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Pagination parameters
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Sort(self):
        r"""Sorting fields
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""Sorting fields, and true means the ascending order (by default) while false means the descending order.
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Pattern = params.get("Pattern")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJobsResponse(AbstractModel):
    r"""DescribeJobs response structure.

    """

    def __init__(self):
        r"""
        :param _JobList: List of job information
        :type JobList: list of JobResponseInfo
        :param _TotalCount: Statistics
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def JobList(self):
        r"""List of job information
        :rtype: list of JobResponseInfo
        """
        return self._JobList

    @JobList.setter
    def JobList(self, JobList):
        self._JobList = JobList

    @property
    def TotalCount(self):
        r"""Statistics
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("JobList") is not None:
            self._JobList = []
            for item in params.get("JobList"):
                obj = JobResponseInfo()
                obj._deserialize(item)
                self._JobList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLakeFsDirSummaryRequest(AbstractModel):
    r"""DescribeLakeFsDirSummary request structure.

    """


class DescribeLakeFsDirSummaryResponse(AbstractModel):
    r"""DescribeLakeFsDirSummary response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeLakeFsInfoRequest(AbstractModel):
    r"""DescribeLakeFsInfo request structure.

    """


class DescribeLakeFsInfoResponse(AbstractModel):
    r"""DescribeLakeFsInfo response structure.

    """

    def __init__(self):
        r"""
        :param _LakeFsInfos: Managed storage information
Note: This field may return null, indicating that no valid values can be obtained.
        :type LakeFsInfos: list of LakeFsInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LakeFsInfos = None
        self._RequestId = None

    @property
    def LakeFsInfos(self):
        r"""Managed storage information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of LakeFsInfo
        """
        return self._LakeFsInfos

    @LakeFsInfos.setter
    def LakeFsInfos(self, LakeFsInfos):
        self._LakeFsInfos = LakeFsInfos

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LakeFsInfos") is not None:
            self._LakeFsInfos = []
            for item in params.get("LakeFsInfos"):
                obj = LakeFsInfo()
                obj._deserialize(item)
                self._LakeFsInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOtherCHDFSBindingListRequest(AbstractModel):
    r"""DescribeOtherCHDFSBindingList request structure.

    """

    def __init__(self):
        r"""
        :param _BucketId: Bucket name
        :type BucketId: str
        """
        self._BucketId = None

    @property
    def BucketId(self):
        r"""Bucket name
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId


    def _deserialize(self, params):
        self._BucketId = params.get("BucketId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOtherCHDFSBindingListResponse(AbstractModel):
    r"""DescribeOtherCHDFSBindingList response structure.

    """

    def __init__(self):
        r"""
        :param _OtherCHDFSBindingList: List not bound to DLC products
        :type OtherCHDFSBindingList: list of OtherCHDFSBinding
        :param _Total: Total records
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OtherCHDFSBindingList = None
        self._Total = None
        self._RequestId = None

    @property
    def OtherCHDFSBindingList(self):
        r"""List not bound to DLC products
        :rtype: list of OtherCHDFSBinding
        """
        return self._OtherCHDFSBindingList

    @OtherCHDFSBindingList.setter
    def OtherCHDFSBindingList(self, OtherCHDFSBindingList):
        self._OtherCHDFSBindingList = OtherCHDFSBindingList

    @property
    def Total(self):
        r"""Total records
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OtherCHDFSBindingList") is not None:
            self._OtherCHDFSBindingList = []
            for item in params.get("OtherCHDFSBindingList"):
                obj = OtherCHDFSBinding()
                obj._deserialize(item)
                self._OtherCHDFSBindingList.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeQueryRequest(AbstractModel):
    r"""DescribeQuery request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQueryResponse(AbstractModel):
    r"""DescribeQuery response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _SQL: The SQL being executed currently. A task contains one SQL.
        :type SQL: str
        :param _SQLType: The currently executed task types are divided into DDL, DML, and DQL.
        :type SQLType: str
        :param _State: The current status of the task is 0: initializing; 1: running; 2: executed; 3: writing data; 4: queuing; -1: task execution failed; -3: manually terminated. The task execution result is returned only when the task is successfully executed.
        :type State: int
        :param _DataSet: Default data set of query results
        :type DataSet: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._SQL = None
        self._SQLType = None
        self._State = None
        self._DataSet = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SQL(self):
        r"""The SQL being executed currently. A task contains one SQL.
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def SQLType(self):
        r"""The currently executed task types are divided into DDL, DML, and DQL.
        :rtype: str
        """
        return self._SQLType

    @SQLType.setter
    def SQLType(self, SQLType):
        self._SQLType = SQLType

    @property
    def State(self):
        r"""The current status of the task is 0: initializing; 1: running; 2: executed; 3: writing data; 4: queuing; -1: task execution failed; -3: manually terminated. The task execution result is returned only when the task is successfully executed.
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def DataSet(self):
        r"""Default data set of query results
        :rtype: str
        """
        return self._DataSet

    @DataSet.setter
    def DataSet(self, DataSet):
        self._DataSet = DataSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SQL = params.get("SQL")
        self._SQLType = params.get("SQLType")
        self._State = params.get("State")
        self._DataSet = params.get("DataSet")
        self._RequestId = params.get("RequestId")


class DescribeResultDownloadRequest(AbstractModel):
    r"""DescribeResultDownload request structure.

    """

    def __init__(self):
        r"""
        :param _DownloadId: The query task ID.
        :type DownloadId: str
        """
        self._DownloadId = None

    @property
    def DownloadId(self):
        r"""The query task ID.
        :rtype: str
        """
        return self._DownloadId

    @DownloadId.setter
    def DownloadId(self, DownloadId):
        self._DownloadId = DownloadId


    def _deserialize(self, params):
        self._DownloadId = params.get("DownloadId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResultDownloadResponse(AbstractModel):
    r"""DescribeResultDownload response structure.

    """

    def __init__(self):
        r"""
        :param _Path: The file save path.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        :param _Status: The task status. Valid values: `init`, `queue`, `format`, `compress`, `success`, `timeout`, and `error`.
        :type Status: str
        :param _Reason: The task exception cause.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Reason: str
        :param _SecretId: The temporary secret ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecretId: str
        :param _SecretKey: The temporary secret key.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SecretKey: str
        :param _Token: The temporary token.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Token: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Path = None
        self._Status = None
        self._Reason = None
        self._SecretId = None
        self._SecretKey = None
        self._Token = None
        self._RequestId = None

    @property
    def Path(self):
        r"""The file save path.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Status(self):
        r"""The task status. Valid values: `init`, `queue`, `format`, `compress`, `success`, `timeout`, and `error`.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Reason(self):
        r"""The task exception cause.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def SecretId(self):
        r"""The temporary secret ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SecretId

    @SecretId.setter
    def SecretId(self, SecretId):
        self._SecretId = SecretId

    @property
    def SecretKey(self):
        r"""The temporary secret key.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Token(self):
        r"""The temporary token.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Status = params.get("Status")
        self._Reason = params.get("Reason")
        self._SecretId = params.get("SecretId")
        self._SecretKey = params.get("SecretKey")
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class DescribeSessionImageVersionRequest(AbstractModel):
    r"""DescribeSessionImageVersion request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine Id.
        :type DataEngineId: str
        :param _FrameworkType: Framework type: machine-learning, python, spark-ml.
        :type FrameworkType: str
        """
        self._DataEngineId = None
        self._FrameworkType = None

    @property
    def DataEngineId(self):
        r"""Engine Id.
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def FrameworkType(self):
        r"""Framework type: machine-learning, python, spark-ml.
        :rtype: str
        """
        return self._FrameworkType

    @FrameworkType.setter
    def FrameworkType(self, FrameworkType):
        self._FrameworkType = FrameworkType


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._FrameworkType = params.get("FrameworkType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSessionImageVersionResponse(AbstractModel):
    r"""DescribeSessionImageVersion response structure.

    """

    def __init__(self):
        r"""
        :param _EngineSessionImages: Expands the image list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EngineSessionImages: list of EngineSessionImage
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EngineSessionImages = None
        self._RequestId = None

    @property
    def EngineSessionImages(self):
        r"""Expands the image list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of EngineSessionImage
        """
        return self._EngineSessionImages

    @EngineSessionImages.setter
    def EngineSessionImages(self, EngineSessionImages):
        self._EngineSessionImages = EngineSessionImages

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EngineSessionImages") is not None:
            self._EngineSessionImages = []
            for item in params.get("EngineSessionImages"):
                obj = EngineSessionImage()
                obj._deserialize(item)
                self._EngineSessionImages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSparkAppJobRequest(AbstractModel):
    r"""DescribeSparkAppJob request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: The Spark job ID. If it co-exists with `JobName`, `JobName` is invalid. At least `JobId` or `JobName` must be used.
        :type JobId: str
        :param _JobName: Spark job name
        :type JobName: str
        """
        self._JobId = None
        self._JobName = None

    @property
    def JobId(self):
        r"""The Spark job ID. If it co-exists with `JobName`, `JobName` is invalid. At least `JobId` or `JobName` must be used.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def JobName(self):
        r"""Spark job name
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._JobName = params.get("JobName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkAppJobResponse(AbstractModel):
    r"""DescribeSparkAppJob response structure.

    """

    def __init__(self):
        r"""
        :param _Job: Spark job details
Note: This field may return null, indicating that no valid values can be obtained.
        :type Job: :class:`tencentcloud.dlc.v20210125.models.SparkJobInfo`
        :param _IsExists: Whether the queried Spark job exists
        :type IsExists: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Job = None
        self._IsExists = None
        self._RequestId = None

    @property
    def Job(self):
        r"""Spark job details
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SparkJobInfo`
        """
        return self._Job

    @Job.setter
    def Job(self, Job):
        self._Job = Job

    @property
    def IsExists(self):
        r"""Whether the queried Spark job exists
        :rtype: bool
        """
        return self._IsExists

    @IsExists.setter
    def IsExists(self, IsExists):
        self._IsExists = IsExists

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Job") is not None:
            self._Job = SparkJobInfo()
            self._Job._deserialize(params.get("Job"))
        self._IsExists = params.get("IsExists")
        self._RequestId = params.get("RequestId")


class DescribeSparkAppJobsRequest(AbstractModel):
    r"""DescribeSparkAppJobs request structure.

    """

    def __init__(self):
        r"""
        :param _SortBy: The returned results are sorted by this field.
        :type SortBy: str
        :param _Sorting: Descending or ascending order, such as `desc`.
        :type Sorting: str
        :param _Filters: The filters. The following types are supported, and `Name` of the parameter passed in must be one of them: `spark-job-name` (job name), `spark-job-id` (job ID), `spark-app-type` (job type: `1` for batch, `2` for streaming, and `4` for SQL), `user-name` (creator), and `key-word` (job name or ID keywords for fuzzy search).
        :type Filters: list of Filter
        :param _StartTime: The update start time in the format of yyyy-mm-dd HH:MM:SS.
        :type StartTime: str
        :param _EndTime: The update end time in the format of yyyy-mm-dd HH:MM:SS.
        :type EndTime: str
        :param _Offset: The query list offset, which defaults to 0.
        :type Offset: int
        :param _Limit: The maximum number of queries allowed in the list, which defaults to 100.
        :type Limit: int
        """
        self._SortBy = None
        self._Sorting = None
        self._Filters = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None

    @property
    def SortBy(self):
        r"""The returned results are sorted by this field.
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""Descending or ascending order, such as `desc`.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""The filters. The following types are supported, and `Name` of the parameter passed in must be one of them: `spark-job-name` (job name), `spark-job-id` (job ID), `spark-app-type` (job type: `1` for batch, `2` for streaming, and `4` for SQL), `user-name` (creator), and `key-word` (job name or ID keywords for fuzzy search).
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StartTime(self):
        r"""The update start time in the format of yyyy-mm-dd HH:MM:SS.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""The update end time in the format of yyyy-mm-dd HH:MM:SS.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""The query list offset, which defaults to 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""The maximum number of queries allowed in the list, which defaults to 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkAppJobsResponse(AbstractModel):
    r"""DescribeSparkAppJobs response structure.

    """

    def __init__(self):
        r"""
        :param _SparkAppJobs: Detailed list of Spark jobs
        :type SparkAppJobs: list of SparkJobInfo
        :param _TotalCount: Total number of Spark jobs
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SparkAppJobs = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SparkAppJobs(self):
        r"""Detailed list of Spark jobs
        :rtype: list of SparkJobInfo
        """
        return self._SparkAppJobs

    @SparkAppJobs.setter
    def SparkAppJobs(self, SparkAppJobs):
        self._SparkAppJobs = SparkAppJobs

    @property
    def TotalCount(self):
        r"""Total number of Spark jobs
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SparkAppJobs") is not None:
            self._SparkAppJobs = []
            for item in params.get("SparkAppJobs"):
                obj = SparkJobInfo()
                obj._deserialize(item)
                self._SparkAppJobs.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSparkAppTasksRequest(AbstractModel):
    r"""DescribeSparkAppTasks request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Spark job ID
        :type JobId: str
        :param _Offset: Paginated query offset
        :type Offset: int
        :param _Limit: Paginated query limit
        :type Limit: int
        :param _TaskId: Execution instance ID
        :type TaskId: str
        :param _StartTime: The update start time in the format of yyyy-MM-dd HH:mm:ss.
        :type StartTime: str
        :param _EndTime: The update end time in the format of yyyy-MM-dd HH:mm:ss.
        :type EndTime: str
        :param _Filters: Filter by this parameter, which can be `task-state`.
        :type Filters: list of Filter
        """
        self._JobId = None
        self._Offset = None
        self._Limit = None
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Filters = None

    @property
    def JobId(self):
        r"""Spark job ID
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def Offset(self):
        r"""Paginated query offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Paginated query limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TaskId(self):
        r"""Execution instance ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        r"""The update start time in the format of yyyy-MM-dd HH:mm:ss.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""The update end time in the format of yyyy-MM-dd HH:mm:ss.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Filters(self):
        r"""Filter by this parameter, which can be `task-state`.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkAppTasksResponse(AbstractModel):
    r"""DescribeSparkAppTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task result (this field has been disused)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tasks: :class:`tencentcloud.dlc.v20210125.models.TaskResponseInfo`
        :param _TotalCount: Total number of tasks
        :type TotalCount: int
        :param _SparkAppTasks: List of task results
Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkAppTasks: list of TaskResponseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._TotalCount = None
        self._SparkAppTasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        r"""Task result (this field has been disused)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TaskResponseInfo`
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def TotalCount(self):
        r"""Total number of tasks
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SparkAppTasks(self):
        r"""List of task results
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TaskResponseInfo
        """
        return self._SparkAppTasks

    @SparkAppTasks.setter
    def SparkAppTasks(self, SparkAppTasks):
        self._SparkAppTasks = SparkAppTasks

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = TaskResponseInfo()
            self._Tasks._deserialize(params.get("Tasks"))
        self._TotalCount = params.get("TotalCount")
        if params.get("SparkAppTasks") is not None:
            self._SparkAppTasks = []
            for item in params.get("SparkAppTasks"):
                obj = TaskResponseInfo()
                obj._deserialize(item)
                self._SparkAppTasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSparkSessionBatchSqlLogRequest(AbstractModel):
    r"""DescribeSparkSessionBatchSqlLog request structure.

    """

    def __init__(self):
        r"""
        :param _BatchId: The unique ID of a Spark SQL job.
        :type BatchId: str
        :param _CustomKey: User-defined primary key. If it is specified, the query should be based on the value.
        :type CustomKey: str
        """
        self._BatchId = None
        self._CustomKey = None

    @property
    def BatchId(self):
        r"""The unique ID of a Spark SQL job.
        :rtype: str
        """
        return self._BatchId

    @BatchId.setter
    def BatchId(self, BatchId):
        self._BatchId = BatchId

    @property
    def CustomKey(self):
        r"""User-defined primary key. If it is specified, the query should be based on the value.
        :rtype: str
        """
        return self._CustomKey

    @CustomKey.setter
    def CustomKey(self, CustomKey):
        self._CustomKey = CustomKey


    def _deserialize(self, params):
        self._BatchId = params.get("BatchId")
        self._CustomKey = params.get("CustomKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSparkSessionBatchSqlLogResponse(AbstractModel):
    r"""DescribeSparkSessionBatchSqlLog response structure.

    """

    def __init__(self):
        r"""
        :param _State: Status: 0: running; 1: successful; 2: failed; 3: cancellation; 4: timeout
        :type State: int
        :param _LogSet: The log information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogSet: list of SparkSessionBatchLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._State = None
        self._LogSet = None
        self._RequestId = None

    @property
    def State(self):
        r"""Status: 0: running; 1: successful; 2: failed; 3: cancellation; 4: timeout
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def LogSet(self):
        r"""The log information list.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SparkSessionBatchLog
        """
        return self._LogSet

    @LogSet.setter
    def LogSet(self, LogSet):
        self._LogSet = LogSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._State = params.get("State")
        if params.get("LogSet") is not None:
            self._LogSet = []
            for item in params.get("LogSet"):
                obj = SparkSessionBatchLog()
                obj._deserialize(item)
                self._LogSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStoreLocationRequest(AbstractModel):
    r"""DescribeStoreLocation request structure.

    """


class DescribeStoreLocationResponse(AbstractModel):
    r"""DescribeStoreLocation response structure.

    """

    def __init__(self):
        r"""
        :param _StoreLocation: Return the path of the location where results are stored and which was set by the user. If it is not set, the null character string, i.e. "", will be returned.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StoreLocation: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StoreLocation = None
        self._RequestId = None

    @property
    def StoreLocation(self):
        r"""Return the path of the location where results are stored and which was set by the user. If it is not set, the null character string, i.e. "", will be returned.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StoreLocation = params.get("StoreLocation")
        self._RequestId = params.get("RequestId")


class DescribeSubUserAccessPolicyRequest(AbstractModel):
    r"""DescribeSubUserAccessPolicy request structure.

    """


class DescribeSubUserAccessPolicyResponse(AbstractModel):
    r"""DescribeSubUserAccessPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _PolicyDocument: Sub-user's visiting policy
        :type PolicyDocument: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PolicyDocument = None
        self._RequestId = None

    @property
    def PolicyDocument(self):
        r"""Sub-user's visiting policy
        :rtype: str
        """
        return self._PolicyDocument

    @PolicyDocument.setter
    def PolicyDocument(self, PolicyDocument):
        self._PolicyDocument = PolicyDocument

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PolicyDocument = params.get("PolicyDocument")
        self._RequestId = params.get("RequestId")


class DescribeTablesNameRequest(AbstractModel):
    r"""DescribeTablesName request structure.

    """

    def __init__(self):
        r"""
        :param _DatabaseName: List all the data tables in the database.
        :type DatabaseName: str
        :param _Limit: Quantity of returns. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Data offset. It starts from 0 and is 0 by default.
        :type Offset: int
        :param _Filters: Filter criteria. The following filter types are supported. The Name should be one of them.
Table-name - String - (filter criteria) data table name, such as table-001.
table-id - String - (filter criteria) table id, such as 12342.
        :type Filters: list of Filter
        :param _DatasourceConnectionName: Specified data source name to be queried, and it is DataLakeCatalog by default.
        :type DatasourceConnectionName: str
        :param _StartTime: Start time: It is used to filter the update time, and the format is yyyy-mm-dd HH:MM:SS.
        :type StartTime: str
        :param _EndTime: End time: It is used to filter the update time, and the format is yyyy-mm-dd HH:MM:SS.
        :type EndTime: str
        :param _Sort: Sorting fields, and they support CreateTime (creation time), UpdateTime (update time), StorageSize (storage space), RecordCount (number of rows), and Name (table name) (The ascending order according to names will be adopted if it is not passed).
        :type Sort: str
        :param _Asc: Sorting fields, and false means the descending order (by default) while true means the ascending order.
        :type Asc: bool
        :param _TableType: Table type, query of the table type, and the available value is EXTERNAL_TABLE,INDEX_TABLE,MANAGED_TABLE,MATERIALIZED_VIEW,TABLE,VIEW,VIRTUAL_VIEW
        :type TableType: str
        :param _TableFormat: Filter fields - table format: If no criteria are specified, all the items will be checked; LAKEFS: managed table; ICEBERG: non-managed iceberg table; HIVE: non-managed hive table; OTHER: other non-managed tables.
        :type TableFormat: str
        """
        self._DatabaseName = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._DatasourceConnectionName = None
        self._StartTime = None
        self._EndTime = None
        self._Sort = None
        self._Asc = None
        self._TableType = None
        self._TableFormat = None

    @property
    def DatabaseName(self):
        r"""List all the data tables in the database.
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Limit(self):
        r"""Quantity of returns. It is 10 by default, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Data offset. It starts from 0 and is 0 by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter criteria. The following filter types are supported. The Name should be one of them.
Table-name - String - (filter criteria) data table name, such as table-001.
table-id - String - (filter criteria) table id, such as 12342.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DatasourceConnectionName(self):
        r"""Specified data source name to be queried, and it is DataLakeCatalog by default.
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def StartTime(self):
        r"""Start time: It is used to filter the update time, and the format is yyyy-mm-dd HH:MM:SS.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time: It is used to filter the update time, and the format is yyyy-mm-dd HH:MM:SS.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Sort(self):
        r"""Sorting fields, and they support CreateTime (creation time), UpdateTime (update time), StorageSize (storage space), RecordCount (number of rows), and Name (table name) (The ascending order according to names will be adopted if it is not passed).
        :rtype: str
        """
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Asc(self):
        r"""Sorting fields, and false means the descending order (by default) while true means the ascending order.
        :rtype: bool
        """
        return self._Asc

    @Asc.setter
    def Asc(self, Asc):
        self._Asc = Asc

    @property
    def TableType(self):
        r"""Table type, query of the table type, and the available value is EXTERNAL_TABLE,INDEX_TABLE,MANAGED_TABLE,MATERIALIZED_VIEW,TABLE,VIEW,VIRTUAL_VIEW
        :rtype: str
        """
        return self._TableType

    @TableType.setter
    def TableType(self, TableType):
        self._TableType = TableType

    @property
    def TableFormat(self):
        r"""Filter fields - table format: If no criteria are specified, all the items will be checked; LAKEFS: managed table; ICEBERG: non-managed iceberg table; HIVE: non-managed hive table; OTHER: other non-managed tables.
        :rtype: str
        """
        return self._TableFormat

    @TableFormat.setter
    def TableFormat(self, TableFormat):
        self._TableFormat = TableFormat


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Sort = params.get("Sort")
        self._Asc = params.get("Asc")
        self._TableType = params.get("TableType")
        self._TableFormat = params.get("TableFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTablesNameResponse(AbstractModel):
    r"""DescribeTablesName response structure.

    """

    def __init__(self):
        r"""
        :param _TableNameList: Object list of data table names
        :type TableNameList: list of str
        :param _TotalCount: Total instances
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableNameList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableNameList(self):
        r"""Object list of data table names
        :rtype: list of str
        """
        return self._TableNameList

    @TableNameList.setter
    def TableNameList(self, TableNameList):
        self._TableNameList = TableNameList

    @property
    def TotalCount(self):
        r"""Total instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TableNameList = params.get("TableNameList")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskResultRequest(AbstractModel):
    r"""DescribeTaskResult request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Unique task ID
        :type TaskId: str
        :param _NextToken: The pagination information returned by the last response. This parameter can be omitted for the first response, where the data will be returned from the beginning. The data with a volume set by the `MaxResults` field is returned each time.
        :type NextToken: str
        :param _MaxResults: Maximum number of returned rows. Value range: 0–1,000. Default value: 1,000.
        :type MaxResults: int
        :param _IsTransformDataType: Whether to convert the data type
        :type IsTransformDataType: bool
        """
        self._TaskId = None
        self._NextToken = None
        self._MaxResults = None
        self._IsTransformDataType = None

    @property
    def TaskId(self):
        r"""Unique task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def NextToken(self):
        r"""The pagination information returned by the last response. This parameter can be omitted for the first response, where the data will be returned from the beginning. The data with a volume set by the `MaxResults` field is returned each time.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        r"""Maximum number of returned rows. Value range: 0–1,000. Default value: 1,000.
        :rtype: int
        """
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTransformDataType(self):
        r"""Whether to convert the data type
        :rtype: bool
        """
        return self._IsTransformDataType

    @IsTransformDataType.setter
    def IsTransformDataType(self, IsTransformDataType):
        self._IsTransformDataType = IsTransformDataType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._IsTransformDataType = params.get("IsTransformDataType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskResultResponse(AbstractModel):
    r"""DescribeTaskResult response structure.

    """

    def __init__(self):
        r"""
        :param _TaskInfo: The queried task information. If the returned value is empty, the task with the entered task ID does not exist. The task result will be returned only if the task status is `2` (succeeded).
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskInfo: :class:`tencentcloud.dlc.v20210125.models.TaskResultInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskInfo = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        r"""The queried task information. If the returned value is empty, the task with the entered task ID does not exist. The task result will be returned only if the task status is `2` (succeeded).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TaskResultInfo`
        """
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = TaskResultInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTaskStatisticsRequest(AbstractModel):
    r"""DescribeTaskStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskStatisticsResponse(AbstractModel):
    r"""DescribeTaskStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _StatisticInfo: Task statistics information.
        :type StatisticInfo: :class:`tencentcloud.dlc.v20210125.models.StatisticInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StatisticInfo = None
        self._RequestId = None

    @property
    def StatisticInfo(self):
        r"""Task statistics information.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.StatisticInfo`
        """
        return self._StatisticInfo

    @StatisticInfo.setter
    def StatisticInfo(self, StatisticInfo):
        self._StatisticInfo = StatisticInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StatisticInfo") is not None:
            self._StatisticInfo = StatisticInfo()
            self._StatisticInfo._deserialize(params.get("StatisticInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    r"""DescribeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned results. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filter. The following filters are supported, and the `Name` input parameter must be one of them. Up to 50 `task-id` values can be filtered, while up to 5 other parameters can be filtered in total.
task-id - String - (filter by task ID). `task-id` format: e386471f-139a-4e59-877f-50ece8135b99.
task-state - String - (filter exactly by task status). Valid values: `0` (initial), `1` (running), `2` (succeeded), `-1` (failed).
task-sql-keyword - String - (filter fuzzily by SQL statement keyword, such as `DROP TABLE`).
task-operator- string (filter by sub-UIN)
task-kind - string (filter by task type)
        :type Filters: list of Filter
        :param _SortBy: Sorting field. Valid values: `create-time` (default value), `update-time`.
        :type SortBy: str
        :param _Sorting: Sorting order. Valid values: `asc` (ascending order), `desc` (descending order). Default value: `asc`.
        :type Sorting: str
        :param _StartTime: Start time in the format of `yyyy-mm-dd HH:MM:SS`, which is the current time seven days ago by default.
        :type StartTime: str
        :param _EndTime: End time in the format of `yyyy-mm-dd HH:MM:SS`, which is the current time by default. The time span is (0, 30] days. Data in the last 45 days can be queried.
        :type EndTime: str
        :param _DataEngineName: The data engine name for filtering.
        :type DataEngineName: str
        :param _ResourceGroupName: Resource group name of the spark engine
        :type ResourceGroupName: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._StartTime = None
        self._EndTime = None
        self._DataEngineName = None
        self._ResourceGroupName = None

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 10. Maximum value: 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset. Default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""Filter. The following filters are supported, and the `Name` input parameter must be one of them. Up to 50 `task-id` values can be filtered, while up to 5 other parameters can be filtered in total.
task-id - String - (filter by task ID). `task-id` format: e386471f-139a-4e59-877f-50ece8135b99.
task-state - String - (filter exactly by task status). Valid values: `0` (initial), `1` (running), `2` (succeeded), `-1` (failed).
task-sql-keyword - String - (filter fuzzily by SQL statement keyword, such as `DROP TABLE`).
task-operator- string (filter by sub-UIN)
task-kind - string (filter by task type)
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""Sorting field. Valid values: `create-time` (default value), `update-time`.
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""Sorting order. Valid values: `asc` (ascending order), `desc` (descending order). Default value: `asc`.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def StartTime(self):
        r"""Start time in the format of `yyyy-mm-dd HH:MM:SS`, which is the current time seven days ago by default.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time in the format of `yyyy-mm-dd HH:MM:SS`, which is the current time by default. The time span is (0, 30] days. Data in the last 45 days can be queried.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataEngineName(self):
        r"""The data engine name for filtering.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def ResourceGroupName(self):
        r"""Resource group name of the spark engine
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataEngineName = params.get("DataEngineName")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    r"""DescribeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TaskList: List of task objects.
        :type TaskList: list of TaskResponseInfo
        :param _TotalCount: Total number of instances
        :type TotalCount: int
        :param _TasksOverview: The task overview.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TasksOverview: :class:`tencentcloud.dlc.v20210125.models.TasksOverview`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskList = None
        self._TotalCount = None
        self._TasksOverview = None
        self._RequestId = None

    @property
    def TaskList(self):
        r"""List of task objects.
        :rtype: list of TaskResponseInfo
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def TotalCount(self):
        r"""Total number of instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TasksOverview(self):
        r"""The task overview.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TasksOverview`
        """
        return self._TasksOverview

    @TasksOverview.setter
    def TasksOverview(self, TasksOverview):
        self._TasksOverview = TasksOverview

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = TaskResponseInfo()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._TotalCount = params.get("TotalCount")
        if params.get("TasksOverview") is not None:
            self._TasksOverview = TasksOverview()
            self._TasksOverview._deserialize(params.get("TasksOverview"))
        self._RequestId = params.get("RequestId")


class DescribeThirdPartyAccessUserRequest(AbstractModel):
    r"""DescribeThirdPartyAccessUser request structure.

    """


class DescribeThirdPartyAccessUserResponse(AbstractModel):
    r"""DescribeThirdPartyAccessUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User information
        :type UserInfo: :class:`tencentcloud.dlc.v20210125.models.OpendThirdAccessUserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""User information
        :rtype: :class:`tencentcloud.dlc.v20210125.models.OpendThirdAccessUserInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = OpendThirdAccessUserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class DescribeUpdatableDataEnginesRequest(AbstractModel):
    r"""DescribeUpdatableDataEngines request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineConfigCommand: Operation commands of engine configuration. UpdateSparkSQLLakefsPath updates the path of managed tables, and UpdateSparkSQLResultPath updates the path of result buckets.
        :type DataEngineConfigCommand: str
        :param _UseLakeFs: 
        :type UseLakeFs: bool
        :param _CustomResultPath: 
        :type CustomResultPath: str
        """
        self._DataEngineConfigCommand = None
        self._UseLakeFs = None
        self._CustomResultPath = None

    @property
    def DataEngineConfigCommand(self):
        r"""Operation commands of engine configuration. UpdateSparkSQLLakefsPath updates the path of managed tables, and UpdateSparkSQLResultPath updates the path of result buckets.
        :rtype: str
        """
        return self._DataEngineConfigCommand

    @DataEngineConfigCommand.setter
    def DataEngineConfigCommand(self, DataEngineConfigCommand):
        self._DataEngineConfigCommand = DataEngineConfigCommand

    @property
    def UseLakeFs(self):
        r"""
        :rtype: bool
        """
        return self._UseLakeFs

    @UseLakeFs.setter
    def UseLakeFs(self, UseLakeFs):
        self._UseLakeFs = UseLakeFs

    @property
    def CustomResultPath(self):
        r"""
        :rtype: str
        """
        return self._CustomResultPath

    @CustomResultPath.setter
    def CustomResultPath(self, CustomResultPath):
        self._CustomResultPath = CustomResultPath


    def _deserialize(self, params):
        self._DataEngineConfigCommand = params.get("DataEngineConfigCommand")
        self._UseLakeFs = params.get("UseLakeFs")
        self._CustomResultPath = params.get("CustomResultPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUpdatableDataEnginesResponse(AbstractModel):
    r"""DescribeUpdatableDataEngines response structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineBasicInfos: Basic cluster information
        :type DataEngineBasicInfos: list of DataEngineBasicInfo
        :param _TotalCount: Number of clusters
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataEngineBasicInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DataEngineBasicInfos(self):
        r"""Basic cluster information
        :rtype: list of DataEngineBasicInfo
        """
        return self._DataEngineBasicInfos

    @DataEngineBasicInfos.setter
    def DataEngineBasicInfos(self, DataEngineBasicInfos):
        self._DataEngineBasicInfos = DataEngineBasicInfos

    @property
    def TotalCount(self):
        r"""Number of clusters
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngineBasicInfos") is not None:
            self._DataEngineBasicInfos = []
            for item in params.get("DataEngineBasicInfos"):
                obj = DataEngineBasicInfo()
                obj._deserialize(item)
                self._DataEngineBasicInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeUserDataEngineConfigRequest(AbstractModel):
    r"""DescribeUserDataEngineConfig request structure.

    """

    def __init__(self):
        r"""
        :param _Sorting: Sorting methods; desc means in reverse order; asc means in order.
        :type Sorting: str
        :param _Limit: Quantity of returns. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _SortBy: Sorting fields, which support the following type: create-time
        :type SortBy: str
        :param _Filters: Filter criteria. The following filter types are supported. The parameter Name should be one of them. The number of values that can be filtered by each type of parameter should not be bigger than 5.
app-id - String - (filtering appid)
engine-id - String - (filtering engine ID)
        :type Filters: list of Filter
        """
        self._Sorting = None
        self._Limit = None
        self._Offset = None
        self._SortBy = None
        self._Filters = None

    @property
    def Sorting(self):
        r"""Sorting methods; desc means in reverse order; asc means in order.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""Quantity of returns. It is 10 by default, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset, which is 0 by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SortBy(self):
        r"""Sorting fields, which support the following type: create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Filters(self):
        r"""Filter criteria. The following filter types are supported. The parameter Name should be one of them. The number of values that can be filtered by each type of parameter should not be bigger than 5.
app-id - String - (filtering appid)
engine-id - String - (filtering engine ID)
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SortBy = params.get("SortBy")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserDataEngineConfigResponse(AbstractModel):
    r"""DescribeUserDataEngineConfig response structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineConfigInstanceInfos: List of custom configuration items of the user's engine
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineConfigInstanceInfos: list of DataEngineConfigInstanceInfo
        :param _TotalCount: Total configuration items
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataEngineConfigInstanceInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DataEngineConfigInstanceInfos(self):
        r"""List of custom configuration items of the user's engine
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DataEngineConfigInstanceInfo
        """
        return self._DataEngineConfigInstanceInfos

    @DataEngineConfigInstanceInfos.setter
    def DataEngineConfigInstanceInfos(self, DataEngineConfigInstanceInfos):
        self._DataEngineConfigInstanceInfos = DataEngineConfigInstanceInfos

    @property
    def TotalCount(self):
        r"""Total configuration items
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataEngineConfigInstanceInfos") is not None:
            self._DataEngineConfigInstanceInfos = []
            for item in params.get("DataEngineConfigInstanceInfos"):
                obj = DataEngineConfigInstanceInfo()
                obj._deserialize(item)
                self._DataEngineConfigInstanceInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeUserInfoRequest(AbstractModel):
    r"""DescribeUserInfo request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _Type: Type of queried information. Group: working group; DataAuth: data permission; EngineAuth: engine permission
        :type Type: str
        :param _Filters: Filter criteria that are queried

When the type is Group, the fuzzy search is supported as the key is workgroup-name.

When the type is DataAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

data-name: fuzzy search of the database and table.

When the type is EngineAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

engine-name: fuzzy search of the database and table.
        :type Filters: list of Filter
        :param _SortBy: Sort fields.

When the type is Group, the create-time and group-name are supported.

When the type is DataAuth, create-time is supported.

When the type is EngineAuth, create-time is supported.
        :type SortBy: str
        :param _Sorting: Sorting methods: desc means in order; asc means in reverse order; it is asc by default.
        :type Sorting: str
        :param _Limit: Quantity of returns. It is 20 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        """
        self._UserId = None
        self._Type = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._Limit = None
        self._Offset = None

    @property
    def UserId(self):
        r"""User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Type(self):
        r"""Type of queried information. Group: working group; DataAuth: data permission; EngineAuth: engine permission
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        r"""Filter criteria that are queried

When the type is Group, the fuzzy search is supported as the key is workgroup-name.

When the type is DataAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

data-name: fuzzy search of the database and table.

When the type is EngineAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

engine-name: fuzzy search of the database and table.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""Sort fields.

When the type is Group, the create-time and group-name are supported.

When the type is DataAuth, create-time is supported.

When the type is EngineAuth, create-time is supported.
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""Sorting methods: desc means in order; asc means in reverse order; it is asc by default.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""Quantity of returns. It is 20 by default, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset, which is 0 by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserInfoResponse(AbstractModel):
    r"""DescribeUserInfo response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: Detailed user information
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserInfo: :class:`tencentcloud.dlc.v20210125.models.UserDetailInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        r"""Detailed user information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.UserDetailInfo`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserDetailInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class DescribeUserRolesRequest(AbstractModel):
    r"""DescribeUserRoles request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: The number limit of enumerated user roles.
        :type Limit: int
        :param _Offset: The offset for starting enumeration. 
        :type Offset: int
        :param _Fuzzy: Fuzzy enumeration by arn.
        :type Fuzzy: str
        :param _SortBy: The field for sorting the returned results.
        :type SortBy: str
        :param _Sorting: The sorting order, descending or ascending, such as `desc`.
        :type Sorting: str
        """
        self._Limit = None
        self._Offset = None
        self._Fuzzy = None
        self._SortBy = None
        self._Sorting = None

    @property
    def Limit(self):
        r"""The number limit of enumerated user roles.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""The offset for starting enumeration. 
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Fuzzy(self):
        r"""Fuzzy enumeration by arn.
        :rtype: str
        """
        return self._Fuzzy

    @Fuzzy.setter
    def Fuzzy(self, Fuzzy):
        self._Fuzzy = Fuzzy

    @property
    def SortBy(self):
        r"""The field for sorting the returned results.
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""The sorting order, descending or ascending, such as `desc`.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Fuzzy = params.get("Fuzzy")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserRolesResponse(AbstractModel):
    r"""DescribeUserRoles response structure.

    """

    def __init__(self):
        r"""
        :param _Total: The total number of user roles meeting the enumeration conditions.
        :type Total: int
        :param _UserRoles: The user roles.
        :type UserRoles: list of UserRole
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._UserRoles = None
        self._RequestId = None

    @property
    def Total(self):
        r"""The total number of user roles meeting the enumeration conditions.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def UserRoles(self):
        r"""The user roles.
        :rtype: list of UserRole
        """
        return self._UserRoles

    @UserRoles.setter
    def UserRoles(self, UserRoles):
        self._UserRoles = UserRoles

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("UserRoles") is not None:
            self._UserRoles = []
            for item in params.get("UserRoles"):
                obj = UserRole()
                obj._deserialize(item)
                self._UserRoles.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserTypeRequest(AbstractModel):
    r"""DescribeUserType request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID (UIN). If it is not specified, it will be the sub-UIN of the caller by default.
        :type UserId: str
        """
        self._UserId = None

    @property
    def UserId(self):
        r"""User ID (UIN). If it is not specified, it will be the sub-UIN of the caller by default.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserTypeResponse(AbstractModel):
    r"""DescribeUserType response structure.

    """

    def __init__(self):
        r"""
        :param _UserType: Types of users. ADMIN: administrators; COMMON: general users
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserType: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserType = None
        self._RequestId = None

    @property
    def UserType(self):
        r"""Types of users. ADMIN: administrators; COMMON: general users
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UserType = params.get("UserType")
        self._RequestId = params.get("RequestId")


class DescribeUsersRequest(AbstractModel):
    r"""DescribeUsers request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: Specify the UIN of the sub-user to be queried. Users need to create it through the CreateUser API.
        :type UserId: str
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Limit: Quantity of returns. It is 20 by default, and the maximum value is 100.
        :type Limit: int
        :param _SortBy: Sorting fields, which support the following type: create-time
        :type SortBy: str
        :param _Sorting: Sorting methods: desc means in order; asc means in reverse order; it is asc by default.
        :type Sorting: str
        :param _Filters: Filter criteria. The following filter types are supported. User-type means the filtering is based on the types of users, and user-keyword means the filtering is based on the names of users.
        :type Filters: list of Filter
        """
        self._UserId = None
        self._Offset = None
        self._Limit = None
        self._SortBy = None
        self._Sorting = None
        self._Filters = None

    @property
    def UserId(self):
        r"""Specify the UIN of the sub-user to be queried. Users need to create it through the CreateUser API.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Offset(self):
        r"""Offset, which is 0 by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Quantity of returns. It is 20 by default, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SortBy(self):
        r"""Sorting fields, which support the following type: create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""Sorting methods: desc means in order; asc means in reverse order; it is asc by default.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Filters(self):
        r"""Filter criteria. The following filter types are supported. User-type means the filtering is based on the types of users, and user-keyword means the filtering is based on the names of users.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsersResponse(AbstractModel):
    r"""DescribeUsers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total queried number of users queried
        :type TotalCount: int
        :param _UserSet: Collection of the queried information of the authorized user
        :type UserSet: list of UserInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._UserSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total queried number of users queried
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def UserSet(self):
        r"""Collection of the queried information of the authorized user
        :rtype: list of UserInfo
        """
        return self._UserSet

    @UserSet.setter
    def UserSet(self, UserSet):
        self._UserSet = UserSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("UserSet") is not None:
            self._UserSet = []
            for item in params.get("UserSet"):
                obj = UserInfo()
                obj._deserialize(item)
                self._UserSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWorkGroupInfoRequest(AbstractModel):
    r"""DescribeWorkGroupInfo request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group IDs
        :type WorkGroupId: int
        :param _Type: Types of queried information. User: user information; DataAuth: data permissions; EngineAuth: engine permissions
        :type Type: str
        :param _Filters: Filter criteria that are queried

When the type is User, the fuzzy search is supported as the key is user-name.

When the type is DataAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

data-name: fuzzy search of the database and table.

When the type is EngineAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

engine-name: fuzzy search of the database and table.
        :type Filters: list of Filter
        :param _SortBy: Sort fields.

When the type is User, create-time and user-name are supported.

When the type is DataAuth, create-time is supported.

When the type is EngineAuth, create-time is supported.
        :type SortBy: str
        :param _Sorting: Sorting methods: desc means in order; asc means in reverse order; it is asc by default.
        :type Sorting: str
        :param _Limit: Quantity of returns. It is 20 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        """
        self._WorkGroupId = None
        self._Type = None
        self._Filters = None
        self._SortBy = None
        self._Sorting = None
        self._Limit = None
        self._Offset = None

    @property
    def WorkGroupId(self):
        r"""Working group IDs
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def Type(self):
        r"""Types of queried information. User: user information; DataAuth: data permissions; EngineAuth: engine permissions
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        r"""Filter criteria that are queried

When the type is User, the fuzzy search is supported as the key is user-name.

When the type is DataAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

data-name: fuzzy search of the database and table.

When the type is EngineAuth, the keys supported are:

policy-type: types of permissions;

policy-source: data sources;

engine-name: fuzzy search of the database and table.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def SortBy(self):
        r"""Sort fields.

When the type is User, create-time and user-name are supported.

When the type is DataAuth, create-time is supported.

When the type is EngineAuth, create-time is supported.
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""Sorting methods: desc means in order; asc means in reverse order; it is asc by default.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting

    @property
    def Limit(self):
        r"""Quantity of returns. It is 20 by default, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset, which is 0 by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkGroupInfoResponse(AbstractModel):
    r"""DescribeWorkGroupInfo response structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupInfo: Details about working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupInfo: :class:`tencentcloud.dlc.v20210125.models.WorkGroupDetailInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WorkGroupInfo = None
        self._RequestId = None

    @property
    def WorkGroupInfo(self):
        r"""Details about working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.WorkGroupDetailInfo`
        """
        return self._WorkGroupInfo

    @WorkGroupInfo.setter
    def WorkGroupInfo(self, WorkGroupInfo):
        self._WorkGroupInfo = WorkGroupInfo

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WorkGroupInfo") is not None:
            self._WorkGroupInfo = WorkGroupDetailInfo()
            self._WorkGroupInfo._deserialize(params.get("WorkGroupInfo"))
        self._RequestId = params.get("RequestId")


class DescribeWorkGroupsRequest(AbstractModel):
    r"""DescribeWorkGroups request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: IDs of working groups that are queried. If it is not filled in or is 0, this means no need for filtering.
        :type WorkGroupId: int
        :param _Filters: Filter criteria. Only the fuzzy search according to working group names is supported. The key is workgroup-name.
        :type Filters: list of Filter
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Limit: Quantity of returns. It is 20 by default, and the maximum value is 100.
        :type Limit: int
        :param _SortBy: Sorting fields, which support the following type: create-time
        :type SortBy: str
        :param _Sorting: Sorting methods; desc means in order; asc means in reverse order; it is asc by default.
        :type Sorting: str
        """
        self._WorkGroupId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._SortBy = None
        self._Sorting = None

    @property
    def WorkGroupId(self):
        r"""IDs of working groups that are queried. If it is not filled in or is 0, this means no need for filtering.
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def Filters(self):
        r"""Filter criteria. Only the fuzzy search according to working group names is supported. The key is workgroup-name.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""Offset, which is 0 by default.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Quantity of returns. It is 20 by default, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SortBy(self):
        r"""Sorting fields, which support the following type: create-time
        :rtype: str
        """
        return self._SortBy

    @SortBy.setter
    def SortBy(self, SortBy):
        self._SortBy = SortBy

    @property
    def Sorting(self):
        r"""Sorting methods; desc means in order; asc means in reverse order; it is asc by default.
        :rtype: str
        """
        return self._Sorting

    @Sorting.setter
    def Sorting(self, Sorting):
        self._Sorting = Sorting


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SortBy = params.get("SortBy")
        self._Sorting = params.get("Sorting")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkGroupsResponse(AbstractModel):
    r"""DescribeWorkGroups response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of working groups
        :type TotalCount: int
        :param _WorkGroupSet: Collection of working group information
        :type WorkGroupSet: list of WorkGroupInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WorkGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""The total number of working groups
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WorkGroupSet(self):
        r"""Collection of working group information
        :rtype: list of WorkGroupInfo
        """
        return self._WorkGroupSet

    @WorkGroupSet.setter
    def WorkGroupSet(self, WorkGroupSet):
        self._WorkGroupSet = WorkGroupSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WorkGroupSet") is not None:
            self._WorkGroupSet = []
            for item in params.get("WorkGroupSet"):
                obj = WorkGroupInfo()
                obj._deserialize(item)
                self._WorkGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DetachUserPolicyRequest(AbstractModel):
    r"""DetachUserPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID, which matches Uin on the CAM side.
        :type UserId: str
        :param _PolicySet: Collection of unbound permissions
        :type PolicySet: list of Policy
        """
        self._UserId = None
        self._PolicySet = None

    @property
    def UserId(self):
        r"""User ID, which matches Uin on the CAM side.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PolicySet(self):
        r"""Collection of unbound permissions
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachUserPolicyResponse(AbstractModel):
    r"""DetachUserPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DetachWorkGroupPolicyRequest(AbstractModel):
    r"""DetachWorkGroupPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group ID
        :type WorkGroupId: int
        :param _PolicySet: Collection of unbound permissions
        :type PolicySet: list of Policy
        """
        self._WorkGroupId = None
        self._PolicySet = None

    @property
    def WorkGroupId(self):
        r"""Working group ID
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def PolicySet(self):
        r"""Collection of unbound permissions
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DetachWorkGroupPolicyResponse(AbstractModel):
    r"""DetachWorkGroupPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DropDLCTableRequest(AbstractModel):
    r"""DropDLCTable request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: Engine name
        :type DataEngineName: str
        :param _DbName: Database name
        :type DbName: str
        :param _Name: Data table name
        :type Name: str
        :param _DeleteData: Whether to delete the data
        :type DeleteData: bool
        :param _ResourceGroupName: Resource group name
        :type ResourceGroupName: str
        """
        self._DataEngineName = None
        self._DbName = None
        self._Name = None
        self._DeleteData = None
        self._ResourceGroupName = None

    @property
    def DataEngineName(self):
        r"""Engine name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def Name(self):
        r"""Data table name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DeleteData(self):
        r"""Whether to delete the data
        :rtype: bool
        """
        return self._DeleteData

    @DeleteData.setter
    def DeleteData(self, DeleteData):
        self._DeleteData = DeleteData

    @property
    def ResourceGroupName(self):
        r"""Resource group name
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._DbName = params.get("DbName")
        self._Name = params.get("Name")
        self._DeleteData = params.get("DeleteData")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropDLCTableResponse(AbstractModel):
    r"""DropDLCTable response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DropDMSDatabaseRequest(AbstractModel):
    r"""DropDMSDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Database name
        :type Name: str
        :param _DeleteData: Whether to delete the data.
        :type DeleteData: bool
        :param _Cascade: Whether to use cascade delete.
        :type Cascade: bool
        """
        self._Name = None
        self._DeleteData = None
        self._Cascade = None

    @property
    def Name(self):
        r"""Database name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DeleteData(self):
        r"""Whether to delete the data.
        :rtype: bool
        """
        return self._DeleteData

    @DeleteData.setter
    def DeleteData(self, DeleteData):
        self._DeleteData = DeleteData

    @property
    def Cascade(self):
        r"""Whether to use cascade delete.
        :rtype: bool
        """
        return self._Cascade

    @Cascade.setter
    def Cascade(self, Cascade):
        self._Cascade = Cascade


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DeleteData = params.get("DeleteData")
        self._Cascade = params.get("Cascade")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropDMSDatabaseResponse(AbstractModel):
    r"""DropDMSDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DropDMSTableRequest(AbstractModel):
    r"""DropDMSTable request structure.

    """

    def __init__(self):
        r"""
        :param _DbName: Database name
        :type DbName: str
        :param _Name: Table name
        :type Name: str
        :param _DeleteData: Whether to delete the data
        :type DeleteData: bool
        :param _EnvProps: Environment properties
        :type EnvProps: :class:`tencentcloud.dlc.v20210125.models.KVPair`
        """
        self._DbName = None
        self._Name = None
        self._DeleteData = None
        self._EnvProps = None

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def Name(self):
        r"""Table name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DeleteData(self):
        r"""Whether to delete the data
        :rtype: bool
        """
        return self._DeleteData

    @DeleteData.setter
    def DeleteData(self, DeleteData):
        self._DeleteData = DeleteData

    @property
    def EnvProps(self):
        r"""Environment properties
        :rtype: :class:`tencentcloud.dlc.v20210125.models.KVPair`
        """
        return self._EnvProps

    @EnvProps.setter
    def EnvProps(self, EnvProps):
        self._EnvProps = EnvProps


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._Name = params.get("Name")
        self._DeleteData = params.get("DeleteData")
        if params.get("EnvProps") is not None:
            self._EnvProps = KVPair()
            self._EnvProps._deserialize(params.get("EnvProps"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropDMSTableResponse(AbstractModel):
    r"""DropDMSTable response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EngineSessionImage(AbstractModel):
    r"""TensorFlow, Pytorch, SK-learn image information list.

    """

    def __init__(self):
        r"""
        :param _SparkImageId: Specifies the unique id of the Spark mirror.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkImageId: str
        :param _SparkImageVersion: Spark image version name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkImageVersion: str
        :param _SparkImageType: Minor version image type. 1: TensorFlow, 2: Pytorch, 3: SK-learn.

Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkImageType: int
        :param _SparkImageTag: Image address.

Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkImageTag: str
        """
        self._SparkImageId = None
        self._SparkImageVersion = None
        self._SparkImageType = None
        self._SparkImageTag = None

    @property
    def SparkImageId(self):
        r"""Specifies the unique id of the Spark mirror.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkImageId

    @SparkImageId.setter
    def SparkImageId(self, SparkImageId):
        self._SparkImageId = SparkImageId

    @property
    def SparkImageVersion(self):
        r"""Spark image version name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def SparkImageType(self):
        r"""Minor version image type. 1: TensorFlow, 2: Pytorch, 3: SK-learn.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SparkImageType

    @SparkImageType.setter
    def SparkImageType(self, SparkImageType):
        self._SparkImageType = SparkImageType

    @property
    def SparkImageTag(self):
        r"""Image address.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkImageTag

    @SparkImageTag.setter
    def SparkImageTag(self, SparkImageTag):
        self._SparkImageTag = SparkImageTag


    def _deserialize(self, params):
        self._SparkImageId = params.get("SparkImageId")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._SparkImageType = params.get("SparkImageType")
        self._SparkImageTag = params.get("SparkImageTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Execution(AbstractModel):
    r"""SQL statement objects

    """

    def __init__(self):
        r"""
        :param _SQL: The automatically generated SQL statements.
        :type SQL: str
        """
        self._SQL = None

    @property
    def SQL(self):
        r"""The automatically generated SQL statements.
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL


    def _deserialize(self, params):
        self._SQL = params.get("SQL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExternalDataConfiguration(AbstractModel):
    r"""External table configuration

    """

    def __init__(self):
        r"""
        :param _Sds: Metadata storage object
Note: This field may return null, indicating that no valid values can be obtained.
        :type Sds: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        :param _ViewOriginalText: View text
Note: This field may return null, indicating that no valid values can be obtained.
        :type ViewOriginalText: str
        :param _ViewExpandedText: View text
Note: This field may return null, indicating that no valid values can be obtained.
        :type ViewExpandedText: str
        :param _Retention: Hive maintenance version
Note: This field may return null, indicating that no valid values can be obtained.
        :type Retention: int
        :param _LifeTime: Lifecycle
Note: This field may return null, indicating that no valid values can be obtained.
        :type LifeTime: int
        :param _Partitions: Partition
Note: This field may return null, indicating that no valid values can be obtained.
        :type Partitions: list of DMSPartition
        """
        self._Sds = None
        self._ViewOriginalText = None
        self._ViewExpandedText = None
        self._Retention = None
        self._LifeTime = None
        self._Partitions = None

    @property
    def Sds(self):
        r"""Metadata storage object
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DMSSds`
        """
        return self._Sds

    @Sds.setter
    def Sds(self, Sds):
        self._Sds = Sds

    @property
    def ViewOriginalText(self):
        r"""View text
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ViewOriginalText

    @ViewOriginalText.setter
    def ViewOriginalText(self, ViewOriginalText):
        self._ViewOriginalText = ViewOriginalText

    @property
    def ViewExpandedText(self):
        r"""View text
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ViewExpandedText

    @ViewExpandedText.setter
    def ViewExpandedText(self, ViewExpandedText):
        self._ViewExpandedText = ViewExpandedText

    @property
    def Retention(self):
        r"""Hive maintenance version
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Retention

    @Retention.setter
    def Retention(self, Retention):
        self._Retention = Retention

    @property
    def LifeTime(self):
        r"""Lifecycle
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._LifeTime

    @LifeTime.setter
    def LifeTime(self, LifeTime):
        self._LifeTime = LifeTime

    @property
    def Partitions(self):
        r"""Partition
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of DMSPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions


    def _deserialize(self, params):
        if params.get("Sds") is not None:
            self._Sds = DMSSds()
            self._Sds._deserialize(params.get("Sds"))
        self._ViewOriginalText = params.get("ViewOriginalText")
        self._ViewExpandedText = params.get("ViewExpandedText")
        self._Retention = params.get("Retention")
        self._LifeTime = params.get("LifeTime")
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = DMSPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FavorInfo(AbstractModel):
    r"""FavorInfo

    """

    def __init__(self):
        r"""
        :param _Priority: Prioritized items
Note: This field may return null, indicating that no valid values can be obtained.
        :type Priority: int
        :param _Catalog: Catalog name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Catalog: str
        :param _DataBase: DataBase name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataBase: str
        :param _Table: Table name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Table: str
        """
        self._Priority = None
        self._Catalog = None
        self._DataBase = None
        self._Table = None

    @property
    def Priority(self):
        r"""Prioritized items
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Catalog(self):
        r"""Catalog name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def DataBase(self):
        r"""DataBase name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataBase

    @DataBase.setter
    def DataBase(self, DataBase):
        self._DataBase = DataBase

    @property
    def Table(self):
        r"""Table name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table


    def _deserialize(self, params):
        self._Priority = params.get("Priority")
        self._Catalog = params.get("Catalog")
        self._DataBase = params.get("DataBase")
        self._Table = params.get("Table")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    r"""Query list filter parameter

    """

    def __init__(self):
        r"""
        :param _Name: Attribute name. If more than one filter exists, the logical relationship between these filters is `OR`.
        :type Name: str
        :param _Values: Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`.
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""Attribute name. If more than one filter exists, the logical relationship between these filters is `OR`.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""Attribute value. If multiple values exist in one filter, the logical relationship between these values is `OR`.
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateCreateMangedTableSqlRequest(AbstractModel):
    r"""GenerateCreateMangedTableSql request structure.

    """

    def __init__(self):
        r"""
        :param _TableBaseInfo: The basic table information.
        :type TableBaseInfo: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        :param _Columns: The table fields.
        :type Columns: list of TColumn
        :param _Partitions: The table partitions.
        :type Partitions: list of TPartition
        :param _Properties: The table properties.
        :type Properties: list of Property
        :param _UpsertKeys: The Upsert key for a v2 table (in Upsert mode).
        :type UpsertKeys: list of str
        """
        self._TableBaseInfo = None
        self._Columns = None
        self._Partitions = None
        self._Properties = None
        self._UpsertKeys = None

    @property
    def TableBaseInfo(self):
        r"""The basic table information.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.TableBaseInfo`
        """
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def Columns(self):
        r"""The table fields.
        :rtype: list of TColumn
        """
        return self._Columns

    @Columns.setter
    def Columns(self, Columns):
        self._Columns = Columns

    @property
    def Partitions(self):
        r"""The table partitions.
        :rtype: list of TPartition
        """
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        r"""The table properties.
        :rtype: list of Property
        """
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def UpsertKeys(self):
        r"""The Upsert key for a v2 table (in Upsert mode).
        :rtype: list of str
        """
        return self._UpsertKeys

    @UpsertKeys.setter
    def UpsertKeys(self, UpsertKeys):
        self._UpsertKeys = UpsertKeys


    def _deserialize(self, params):
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        if params.get("Columns") is not None:
            self._Columns = []
            for item in params.get("Columns"):
                obj = TColumn()
                obj._deserialize(item)
                self._Columns.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = TPartition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._UpsertKeys = params.get("UpsertKeys")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateCreateMangedTableSqlResponse(AbstractModel):
    r"""GenerateCreateMangedTableSql response structure.

    """

    def __init__(self):
        r"""
        :param _Execution: The SQL statements for creating the managed internal table.
        :type Execution: :class:`tencentcloud.dlc.v20210125.models.Execution`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Execution = None
        self._RequestId = None

    @property
    def Execution(self):
        r"""The SQL statements for creating the managed internal table.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Execution`
        """
        return self._Execution

    @Execution.setter
    def Execution(self, Execution):
        self._Execution = Execution

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Execution") is not None:
            self._Execution = Execution()
            self._Execution._deserialize(params.get("Execution"))
        self._RequestId = params.get("RequestId")


class GetOptimizerPolicyRequest(AbstractModel):
    r"""GetOptimizerPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _SmartPolicy: Policy description
        :type SmartPolicy: :class:`tencentcloud.dlc.v20210125.models.SmartPolicy`
        """
        self._SmartPolicy = None

    @property
    def SmartPolicy(self):
        r"""Policy description
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartPolicy`
        """
        return self._SmartPolicy

    @SmartPolicy.setter
    def SmartPolicy(self, SmartPolicy):
        self._SmartPolicy = SmartPolicy


    def _deserialize(self, params):
        if params.get("SmartPolicy") is not None:
            self._SmartPolicy = SmartPolicy()
            self._SmartPolicy._deserialize(params.get("SmartPolicy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetOptimizerPolicyResponse(AbstractModel):
    r"""GetOptimizerPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _SmartOptimizerPolicy: Smart optimization policy
        :type SmartOptimizerPolicy: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerPolicy`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SmartOptimizerPolicy = None
        self._RequestId = None

    @property
    def SmartOptimizerPolicy(self):
        r"""Smart optimization policy
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerPolicy`
        """
        return self._SmartOptimizerPolicy

    @SmartOptimizerPolicy.setter
    def SmartOptimizerPolicy(self, SmartOptimizerPolicy):
        self._SmartOptimizerPolicy = SmartOptimizerPolicy

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SmartOptimizerPolicy") is not None:
            self._SmartOptimizerPolicy = SmartOptimizerPolicy()
            self._SmartOptimizerPolicy._deserialize(params.get("SmartOptimizerPolicy"))
        self._RequestId = params.get("RequestId")


class GrantDLCCatalogAccessRequest(AbstractModel):
    r"""GrantDLCCatalogAccess request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: Authorized VpcId
        :type VpcId: str
        :param _Product: Product (EMR|DLC|Doris|Inlong|Wedata)
        :type Product: str
        :param _Description: Description
        :type Description: str
        :param _VpcUin: UIN of the account to which VPC belongs
        :type VpcUin: str
        :param _VpcAppId: AppId of the account to which VPC belongs
        :type VpcAppId: int
        """
        self._VpcId = None
        self._Product = None
        self._Description = None
        self._VpcUin = None
        self._VpcAppId = None

    @property
    def VpcId(self):
        r"""Authorized VpcId
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Product(self):
        r"""Product (EMR|DLC|Doris|Inlong|Wedata)
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def VpcUin(self):
        r"""UIN of the account to which VPC belongs
        :rtype: str
        """
        return self._VpcUin

    @VpcUin.setter
    def VpcUin(self, VpcUin):
        self._VpcUin = VpcUin

    @property
    def VpcAppId(self):
        r"""AppId of the account to which VPC belongs
        :rtype: int
        """
        return self._VpcAppId

    @VpcAppId.setter
    def VpcAppId(self, VpcAppId):
        self._VpcAppId = VpcAppId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Product = params.get("Product")
        self._Description = params.get("Description")
        self._VpcUin = params.get("VpcUin")
        self._VpcAppId = params.get("VpcAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GrantDLCCatalogAccessResponse(AbstractModel):
    r"""GrantDLCCatalogAccess response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class GroupInfo(AbstractModel):
    r"""DMask user group information.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: User group ID.
        :type WorkGroupId: int
        :param _StrategyType: Policy type.
        :type StrategyType: str
        """
        self._WorkGroupId = None
        self._StrategyType = None

    @property
    def WorkGroupId(self):
        r"""User group ID.
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def StrategyType(self):
        r"""Policy type.
        :rtype: str
        """
        return self._StrategyType

    @StrategyType.setter
    def StrategyType(self, StrategyType):
        self._StrategyType = StrategyType


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._StrategyType = params.get("StrategyType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class JobResponseInfo(AbstractModel):
    r"""Job information

    """

    def __init__(self):
        r"""
        :param _JobName: Job name
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobName: str
        :param _StatisticInfo: Statistics
Note: This field may return null, indicating that no valid values can be obtained.
        :type StatisticInfo: :class:`tencentcloud.dlc.v20210125.models.StatisticInfo`
        :param _JobConfiguration: Job configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobConfiguration: str
        :param _JobStatus: The current status of the job: 0: initializing; 1: running; 2: executed; 3: writing data; 4: queuing; -1: execution failed; -3: manually terminated. The job execution result is returned only when the job is successfully executed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobStatus: int
        """
        self._JobName = None
        self._StatisticInfo = None
        self._JobConfiguration = None
        self._JobStatus = None

    @property
    def JobName(self):
        r"""Job name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName

    @property
    def StatisticInfo(self):
        r"""Statistics
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.StatisticInfo`
        """
        return self._StatisticInfo

    @StatisticInfo.setter
    def StatisticInfo(self, StatisticInfo):
        self._StatisticInfo = StatisticInfo

    @property
    def JobConfiguration(self):
        r"""Job configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._JobConfiguration

    @JobConfiguration.setter
    def JobConfiguration(self, JobConfiguration):
        self._JobConfiguration = JobConfiguration

    @property
    def JobStatus(self):
        r"""The current status of the job: 0: initializing; 1: running; 2: executed; 3: writing data; 4: queuing; -1: execution failed; -3: manually terminated. The job execution result is returned only when the job is successfully executed.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._JobStatus

    @JobStatus.setter
    def JobStatus(self, JobStatus):
        self._JobStatus = JobStatus


    def _deserialize(self, params):
        self._JobName = params.get("JobName")
        if params.get("StatisticInfo") is not None:
            self._StatisticInfo = StatisticInfo()
            self._StatisticInfo._deserialize(params.get("StatisticInfo"))
        self._JobConfiguration = params.get("JobConfiguration")
        self._JobStatus = params.get("JobStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KVPair(AbstractModel):
    r"""Configuration format

    """

    def __init__(self):
        r"""
        :param _Key: Configured key
Note: This field may return null, indicating that no valid values can be obtained.
        :type Key: str
        :param _Value: Configured value
Note: This field may return null, indicating that no valid values can be obtained.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""Configured key
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""Configured value
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LakeFsInfo(AbstractModel):
    r"""Describe basic information about DLC managed storage

    """

    def __init__(self):
        r"""
        :param _Name: Managed storage name
        :type Name: str
        :param _Type: Managed storage type
        :type Type: str
        :param _SpaceUsedSize: Capacity
        :type SpaceUsedSize: float
        :param _CreateTimeStamp: Timestamp of the creation time
        :type CreateTimeStamp: int
        :param _DefaultBucket: Whether it is the user's default bucket: 0: default bucket, 1: non-default bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :type DefaultBucket: int
        :param _ShortName: Managed storage short name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShortName: str
        :param _Description: Description information of the bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _Status: The status of the managed bucket. Current values: creating, bind, readOnly, and isolate
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        """
        self._Name = None
        self._Type = None
        self._SpaceUsedSize = None
        self._CreateTimeStamp = None
        self._DefaultBucket = None
        self._ShortName = None
        self._Description = None
        self._Status = None

    @property
    def Name(self):
        r"""Managed storage name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""Managed storage type
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SpaceUsedSize(self):
        r"""Capacity
        :rtype: float
        """
        return self._SpaceUsedSize

    @SpaceUsedSize.setter
    def SpaceUsedSize(self, SpaceUsedSize):
        self._SpaceUsedSize = SpaceUsedSize

    @property
    def CreateTimeStamp(self):
        r"""Timestamp of the creation time
        :rtype: int
        """
        return self._CreateTimeStamp

    @CreateTimeStamp.setter
    def CreateTimeStamp(self, CreateTimeStamp):
        self._CreateTimeStamp = CreateTimeStamp

    @property
    def DefaultBucket(self):
        r"""Whether it is the user's default bucket: 0: default bucket, 1: non-default bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DefaultBucket

    @DefaultBucket.setter
    def DefaultBucket(self, DefaultBucket):
        self._DefaultBucket = DefaultBucket

    @property
    def ShortName(self):
        r"""Managed storage short name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ShortName

    @ShortName.setter
    def ShortName(self, ShortName):
        self._ShortName = ShortName

    @property
    def Description(self):
        r"""Description information of the bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        r"""The status of the managed bucket. Current values: creating, bind, readOnly, and isolate
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._SpaceUsedSize = params.get("SpaceUsedSize")
        self._CreateTimeStamp = params.get("CreateTimeStamp")
        self._DefaultBucket = params.get("DefaultBucket")
        self._ShortName = params.get("ShortName")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAdvancedStoreLocationRequest(AbstractModel):
    r"""ModifyAdvancedStoreLocation request structure.

    """

    def __init__(self):
        r"""
        :param _StoreLocation: COS path for saving querying results
        :type StoreLocation: str
        :param _Enable: Whether to enable advanced settings. 0 means no while 1 means yes.
        :type Enable: int
        """
        self._StoreLocation = None
        self._Enable = None

    @property
    def StoreLocation(self):
        r"""COS path for saving querying results
        :rtype: str
        """
        return self._StoreLocation

    @StoreLocation.setter
    def StoreLocation(self, StoreLocation):
        self._StoreLocation = StoreLocation

    @property
    def Enable(self):
        r"""Whether to enable advanced settings. 0 means no while 1 means yes.
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable


    def _deserialize(self, params):
        self._StoreLocation = params.get("StoreLocation")
        self._Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAdvancedStoreLocationResponse(AbstractModel):
    r"""ModifyAdvancedStoreLocation response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDataEngineDescriptionRequest(AbstractModel):
    r"""ModifyDataEngineDescription request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: Name of the engine to be modified
        :type DataEngineName: str
        :param _Message: Engine description and its maximum length is 250 characters.
        :type Message: str
        """
        self._DataEngineName = None
        self._Message = None

    @property
    def DataEngineName(self):
        r"""Name of the engine to be modified
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Message(self):
        r"""Engine description and its maximum length is 250 characters.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDataEngineDescriptionResponse(AbstractModel):
    r"""ModifyDataEngineDescription response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyGovernEventRuleRequest(AbstractModel):
    r"""ModifyGovernEventRule request structure.

    """


class ModifyGovernEventRuleResponse(AbstractModel):
    r"""ModifyGovernEventRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySparkAppBatchRequest(AbstractModel):
    r"""ModifySparkAppBatch request structure.

    """

    def __init__(self):
        r"""
        :param _SparkAppId: The list of the IDs of the Spark job tasks to be modified in batches.
        :type SparkAppId: list of str
        :param _DataEngine: The engine ID.
        :type DataEngine: str
        :param _AppDriverSize: The driver size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
        :type AppDriverSize: str
        :param _AppExecutorSize: The executor size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
        :type AppExecutorSize: str
        :param _AppExecutorNums: The executor count. The minimum value is 1 and the maximum value is less than the cluster specification.
        :type AppExecutorNums: int
        :param _AppExecutorMaxNumbers: The maximum executor count (in dynamic configuration scenarios). The minimum value is 1 and the maximum value is less than the cluster specification. If you set `ExecutorMaxNumbers` to a value smaller than that of `ExecutorNums`, the value of `ExecutorMaxNumbers` is automatically changed to that of `ExecutorNums`.
        :type AppExecutorMaxNumbers: int
        :param _IsInherit: Whether to inherit the task resource configuration from the cluster template. Valid values: `0` (default): No; `1`: Yes.
        :type IsInherit: int
        """
        self._SparkAppId = None
        self._DataEngine = None
        self._AppDriverSize = None
        self._AppExecutorSize = None
        self._AppExecutorNums = None
        self._AppExecutorMaxNumbers = None
        self._IsInherit = None

    @property
    def SparkAppId(self):
        r"""The list of the IDs of the Spark job tasks to be modified in batches.
        :rtype: list of str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def DataEngine(self):
        r"""The engine ID.
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def AppDriverSize(self):
        r"""The driver size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
        :rtype: str
        """
        return self._AppDriverSize

    @AppDriverSize.setter
    def AppDriverSize(self, AppDriverSize):
        self._AppDriverSize = AppDriverSize

    @property
    def AppExecutorSize(self):
        r"""The executor size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
        :rtype: str
        """
        return self._AppExecutorSize

    @AppExecutorSize.setter
    def AppExecutorSize(self, AppExecutorSize):
        self._AppExecutorSize = AppExecutorSize

    @property
    def AppExecutorNums(self):
        r"""The executor count. The minimum value is 1 and the maximum value is less than the cluster specification.
        :rtype: int
        """
        return self._AppExecutorNums

    @AppExecutorNums.setter
    def AppExecutorNums(self, AppExecutorNums):
        self._AppExecutorNums = AppExecutorNums

    @property
    def AppExecutorMaxNumbers(self):
        r"""The maximum executor count (in dynamic configuration scenarios). The minimum value is 1 and the maximum value is less than the cluster specification. If you set `ExecutorMaxNumbers` to a value smaller than that of `ExecutorNums`, the value of `ExecutorMaxNumbers` is automatically changed to that of `ExecutorNums`.
        :rtype: int
        """
        return self._AppExecutorMaxNumbers

    @AppExecutorMaxNumbers.setter
    def AppExecutorMaxNumbers(self, AppExecutorMaxNumbers):
        self._AppExecutorMaxNumbers = AppExecutorMaxNumbers

    @property
    def IsInherit(self):
        r"""Whether to inherit the task resource configuration from the cluster template. Valid values: `0` (default): No; `1`: Yes.
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit


    def _deserialize(self, params):
        self._SparkAppId = params.get("SparkAppId")
        self._DataEngine = params.get("DataEngine")
        self._AppDriverSize = params.get("AppDriverSize")
        self._AppExecutorSize = params.get("AppExecutorSize")
        self._AppExecutorNums = params.get("AppExecutorNums")
        self._AppExecutorMaxNumbers = params.get("AppExecutorMaxNumbers")
        self._IsInherit = params.get("IsInherit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySparkAppBatchResponse(AbstractModel):
    r"""ModifySparkAppBatch response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySparkAppRequest(AbstractModel):
    r"""ModifySparkApp request structure.

    """

    def __init__(self):
        r"""
        :param _AppName: The Spark job name.
        :type AppName: str
        :param _AppType: The Spark job type. Valid values: `1` for Spark JAR job and `2` for Spark streaming job.
        :type AppType: int
        :param _DataEngine: The data engine executing the Spark job.
        :type DataEngine: str
        :param _AppFile: The path of the Spark job package.
        :type AppFile: str
        :param _RoleArn: The data access policy (CAM role arn).
        :type RoleArn: int
        :param _AppDriverSize: The driver size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :type AppDriverSize: str
        :param _AppExecutorSize: The executor size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :type AppExecutorSize: str
        :param _AppExecutorNums: Number of Spark job executors
        :type AppExecutorNums: int
        :param _SparkAppId: The Spark job ID.
        :type SparkAppId: str
        :param _Eni: This field has been disused. Use the `Datasource` field instead.
        :type Eni: str
        :param _IsLocal: The source of the Spark job package. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocal: str
        :param _MainClass: The main class of the Spark job.
        :type MainClass: str
        :param _AppConf: Spark configurations separated by line break
        :type AppConf: str
        :param _IsLocalJars: The source of the dependency JAR packages of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalJars: str
        :param _AppJars: The dependency JAR packages of the Spark JAR job (JAR packages), separated by comma.
        :type AppJars: str
        :param _IsLocalFiles: The source of the dependency files of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalFiles: str
        :param _AppFiles: The dependency files of the Spark job (files other than JAR and ZIP packages), separated by comma.
        :type AppFiles: str
        :param _IsLocalPythonFiles: The source of the PySpark dependencies. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalPythonFiles: str
        :param _AppPythonFiles: The PySpark dependencies (Python files), separated by comma, with .py, .zip, and .egg formats supported.
        :type AppPythonFiles: str
        :param _CmdArgs: The input parameters of the Spark job, separated by comma.
        :type CmdArgs: str
        :param _MaxRetries: The maximum number of retries, valid for Spark streaming tasks only.
        :type MaxRetries: int
        :param _DataSource: Data source name
        :type DataSource: str
        :param _IsLocalArchives: The source of the dependency archives of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :type IsLocalArchives: str
        :param _AppArchives: The dependency archives of the Spark job, separated by comma, with tar.gz, .tgz, and .tar formats supported.
        :type AppArchives: str
        :param _SparkImage: The Spark image version.
        :type SparkImage: str
        :param _SparkImageVersion: The Spark image version name.
        :type SparkImageVersion: str
        :param _AppExecutorMaxNumbers: The specified executor count (max), which defaults to 1. This parameter applies if the "Dynamic" mode is selected. If the "Dynamic" mode is not selected, the executor count is equal to `AppExecutorNums`.
        :type AppExecutorMaxNumbers: int
        :param _SessionId: The associated Data Lake Compute query script.
        :type SessionId: str
        :param _IsInherit: Whether to inherit the task resource configuration from the cluster configuration template. Valid values: `0` (default): No; `1`: Yes.
        :type IsInherit: int
        :param _IsSessionStarted: Whether to run the task with the session SQLs. Valid values: `false` for no and `true` for yes.
        :type IsSessionStarted: bool
        """
        self._AppName = None
        self._AppType = None
        self._DataEngine = None
        self._AppFile = None
        self._RoleArn = None
        self._AppDriverSize = None
        self._AppExecutorSize = None
        self._AppExecutorNums = None
        self._SparkAppId = None
        self._Eni = None
        self._IsLocal = None
        self._MainClass = None
        self._AppConf = None
        self._IsLocalJars = None
        self._AppJars = None
        self._IsLocalFiles = None
        self._AppFiles = None
        self._IsLocalPythonFiles = None
        self._AppPythonFiles = None
        self._CmdArgs = None
        self._MaxRetries = None
        self._DataSource = None
        self._IsLocalArchives = None
        self._AppArchives = None
        self._SparkImage = None
        self._SparkImageVersion = None
        self._AppExecutorMaxNumbers = None
        self._SessionId = None
        self._IsInherit = None
        self._IsSessionStarted = None

    @property
    def AppName(self):
        r"""The Spark job name.
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def AppType(self):
        r"""The Spark job type. Valid values: `1` for Spark JAR job and `2` for Spark streaming job.
        :rtype: int
        """
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def DataEngine(self):
        r"""The data engine executing the Spark job.
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def AppFile(self):
        r"""The path of the Spark job package.
        :rtype: str
        """
        return self._AppFile

    @AppFile.setter
    def AppFile(self, AppFile):
        self._AppFile = AppFile

    @property
    def RoleArn(self):
        r"""The data access policy (CAM role arn).
        :rtype: int
        """
        return self._RoleArn

    @RoleArn.setter
    def RoleArn(self, RoleArn):
        self._RoleArn = RoleArn

    @property
    def AppDriverSize(self):
        r"""The driver size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :rtype: str
        """
        return self._AppDriverSize

    @AppDriverSize.setter
    def AppDriverSize(self, AppDriverSize):
        self._AppDriverSize = AppDriverSize

    @property
    def AppExecutorSize(self):
        r"""The executor size. Valid values: `small` (default, 1 CU), `medium` (2 CUs), `large` (4 CUs), and `xlarge` (8 CUs).
        :rtype: str
        """
        return self._AppExecutorSize

    @AppExecutorSize.setter
    def AppExecutorSize(self, AppExecutorSize):
        self._AppExecutorSize = AppExecutorSize

    @property
    def AppExecutorNums(self):
        r"""Number of Spark job executors
        :rtype: int
        """
        return self._AppExecutorNums

    @AppExecutorNums.setter
    def AppExecutorNums(self, AppExecutorNums):
        self._AppExecutorNums = AppExecutorNums

    @property
    def SparkAppId(self):
        r"""The Spark job ID.
        :rtype: str
        """
        return self._SparkAppId

    @SparkAppId.setter
    def SparkAppId(self, SparkAppId):
        self._SparkAppId = SparkAppId

    @property
    def Eni(self):
        r"""This field has been disused. Use the `Datasource` field instead.
        :rtype: str
        """
        return self._Eni

    @Eni.setter
    def Eni(self, Eni):
        self._Eni = Eni

    @property
    def IsLocal(self):
        r"""The source of the Spark job package. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocal

    @IsLocal.setter
    def IsLocal(self, IsLocal):
        self._IsLocal = IsLocal

    @property
    def MainClass(self):
        r"""The main class of the Spark job.
        :rtype: str
        """
        return self._MainClass

    @MainClass.setter
    def MainClass(self, MainClass):
        self._MainClass = MainClass

    @property
    def AppConf(self):
        r"""Spark configurations separated by line break
        :rtype: str
        """
        return self._AppConf

    @AppConf.setter
    def AppConf(self, AppConf):
        self._AppConf = AppConf

    @property
    def IsLocalJars(self):
        r"""The source of the dependency JAR packages of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalJars

    @IsLocalJars.setter
    def IsLocalJars(self, IsLocalJars):
        self._IsLocalJars = IsLocalJars

    @property
    def AppJars(self):
        r"""The dependency JAR packages of the Spark JAR job (JAR packages), separated by comma.
        :rtype: str
        """
        return self._AppJars

    @AppJars.setter
    def AppJars(self, AppJars):
        self._AppJars = AppJars

    @property
    def IsLocalFiles(self):
        r"""The source of the dependency files of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalFiles

    @IsLocalFiles.setter
    def IsLocalFiles(self, IsLocalFiles):
        self._IsLocalFiles = IsLocalFiles

    @property
    def AppFiles(self):
        r"""The dependency files of the Spark job (files other than JAR and ZIP packages), separated by comma.
        :rtype: str
        """
        return self._AppFiles

    @AppFiles.setter
    def AppFiles(self, AppFiles):
        self._AppFiles = AppFiles

    @property
    def IsLocalPythonFiles(self):
        r"""The source of the PySpark dependencies. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalPythonFiles

    @IsLocalPythonFiles.setter
    def IsLocalPythonFiles(self, IsLocalPythonFiles):
        self._IsLocalPythonFiles = IsLocalPythonFiles

    @property
    def AppPythonFiles(self):
        r"""The PySpark dependencies (Python files), separated by comma, with .py, .zip, and .egg formats supported.
        :rtype: str
        """
        return self._AppPythonFiles

    @AppPythonFiles.setter
    def AppPythonFiles(self, AppPythonFiles):
        self._AppPythonFiles = AppPythonFiles

    @property
    def CmdArgs(self):
        r"""The input parameters of the Spark job, separated by comma.
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def MaxRetries(self):
        r"""The maximum number of retries, valid for Spark streaming tasks only.
        :rtype: int
        """
        return self._MaxRetries

    @MaxRetries.setter
    def MaxRetries(self, MaxRetries):
        self._MaxRetries = MaxRetries

    @property
    def DataSource(self):
        r"""Data source name
        :rtype: str
        """
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def IsLocalArchives(self):
        r"""The source of the dependency archives of the Spark job. Valid values: `cos` for COS and `lakefs` for the local system (for use in the console, but this method does not support direct API calls).
        :rtype: str
        """
        return self._IsLocalArchives

    @IsLocalArchives.setter
    def IsLocalArchives(self, IsLocalArchives):
        self._IsLocalArchives = IsLocalArchives

    @property
    def AppArchives(self):
        r"""The dependency archives of the Spark job, separated by comma, with tar.gz, .tgz, and .tar formats supported.
        :rtype: str
        """
        return self._AppArchives

    @AppArchives.setter
    def AppArchives(self, AppArchives):
        self._AppArchives = AppArchives

    @property
    def SparkImage(self):
        r"""The Spark image version.
        :rtype: str
        """
        return self._SparkImage

    @SparkImage.setter
    def SparkImage(self, SparkImage):
        self._SparkImage = SparkImage

    @property
    def SparkImageVersion(self):
        r"""The Spark image version name.
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def AppExecutorMaxNumbers(self):
        r"""The specified executor count (max), which defaults to 1. This parameter applies if the "Dynamic" mode is selected. If the "Dynamic" mode is not selected, the executor count is equal to `AppExecutorNums`.
        :rtype: int
        """
        return self._AppExecutorMaxNumbers

    @AppExecutorMaxNumbers.setter
    def AppExecutorMaxNumbers(self, AppExecutorMaxNumbers):
        self._AppExecutorMaxNumbers = AppExecutorMaxNumbers

    @property
    def SessionId(self):
        r"""The associated Data Lake Compute query script.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def IsInherit(self):
        r"""Whether to inherit the task resource configuration from the cluster configuration template. Valid values: `0` (default): No; `1`: Yes.
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def IsSessionStarted(self):
        r"""Whether to run the task with the session SQLs. Valid values: `false` for no and `true` for yes.
        :rtype: bool
        """
        return self._IsSessionStarted

    @IsSessionStarted.setter
    def IsSessionStarted(self, IsSessionStarted):
        self._IsSessionStarted = IsSessionStarted


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._AppType = params.get("AppType")
        self._DataEngine = params.get("DataEngine")
        self._AppFile = params.get("AppFile")
        self._RoleArn = params.get("RoleArn")
        self._AppDriverSize = params.get("AppDriverSize")
        self._AppExecutorSize = params.get("AppExecutorSize")
        self._AppExecutorNums = params.get("AppExecutorNums")
        self._SparkAppId = params.get("SparkAppId")
        self._Eni = params.get("Eni")
        self._IsLocal = params.get("IsLocal")
        self._MainClass = params.get("MainClass")
        self._AppConf = params.get("AppConf")
        self._IsLocalJars = params.get("IsLocalJars")
        self._AppJars = params.get("AppJars")
        self._IsLocalFiles = params.get("IsLocalFiles")
        self._AppFiles = params.get("AppFiles")
        self._IsLocalPythonFiles = params.get("IsLocalPythonFiles")
        self._AppPythonFiles = params.get("AppPythonFiles")
        self._CmdArgs = params.get("CmdArgs")
        self._MaxRetries = params.get("MaxRetries")
        self._DataSource = params.get("DataSource")
        self._IsLocalArchives = params.get("IsLocalArchives")
        self._AppArchives = params.get("AppArchives")
        self._SparkImage = params.get("SparkImage")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._AppExecutorMaxNumbers = params.get("AppExecutorMaxNumbers")
        self._SessionId = params.get("SessionId")
        self._IsInherit = params.get("IsInherit")
        self._IsSessionStarted = params.get("IsSessionStarted")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySparkAppResponse(AbstractModel):
    r"""ModifySparkApp response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserRequest(AbstractModel):
    r"""ModifyUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID which matches UIN on the CAM side
        :type UserId: str
        :param _UserDescription: User description
        :type UserDescription: str
        """
        self._UserId = None
        self._UserDescription = None

    @property
    def UserId(self):
        r"""User ID which matches UIN on the CAM side
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserDescription(self):
        r"""User description
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserDescription = params.get("UserDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserResponse(AbstractModel):
    r"""ModifyUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserTypeRequest(AbstractModel):
    r"""ModifyUserType request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _UserType: Types that users modify. ADMIN: administrators; COMMON: general users.
        :type UserType: str
        """
        self._UserId = None
        self._UserType = None

    @property
    def UserId(self):
        r"""User ID
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserType(self):
        r"""Types that users modify. ADMIN: administrators; COMMON: general users.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserType = params.get("UserType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserTypeResponse(AbstractModel):
    r"""ModifyUserType response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyWorkGroupRequest(AbstractModel):
    r"""ModifyWorkGroup request structure.

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group IDs
        :type WorkGroupId: int
        :param _WorkGroupDescription: Working group description, and the upper limit of the number of its characters is 50.
        :type WorkGroupDescription: str
        """
        self._WorkGroupId = None
        self._WorkGroupDescription = None

    @property
    def WorkGroupId(self):
        r"""Working group IDs
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def WorkGroupDescription(self):
        r"""Working group description, and the upper limit of the number of its characters is 50.
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWorkGroupResponse(AbstractModel):
    r"""ModifyWorkGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MountPointAssociates(AbstractModel):
    r"""Bind fusion bucket information

    """

    def __init__(self):
        r"""
        :param _BucketId: Bucket ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type BucketId: str
        :param _VpcId: vpcId
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _VpcCidrBlock: Subnet address
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcCidrBlock: str
        :param _AccessGroupId: Permission group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessGroupId: str
        :param _AccessRuleId: Permission rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessRuleId: int
        """
        self._BucketId = None
        self._VpcId = None
        self._VpcCidrBlock = None
        self._AccessGroupId = None
        self._AccessRuleId = None

    @property
    def BucketId(self):
        r"""Bucket ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._BucketId

    @BucketId.setter
    def BucketId(self, BucketId):
        self._BucketId = BucketId

    @property
    def VpcId(self):
        r"""vpcId
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcCidrBlock(self):
        r"""Subnet address
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def AccessGroupId(self):
        r"""Permission group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessGroupId

    @AccessGroupId.setter
    def AccessGroupId(self, AccessGroupId):
        self._AccessGroupId = AccessGroupId

    @property
    def AccessRuleId(self):
        r"""Permission rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._AccessRuleId

    @AccessRuleId.setter
    def AccessRuleId(self, AccessRuleId):
        self._AccessRuleId = AccessRuleId


    def _deserialize(self, params):
        self._BucketId = params.get("BucketId")
        self._VpcId = params.get("VpcId")
        self._VpcCidrBlock = params.get("VpcCidrBlock")
        self._AccessGroupId = params.get("AccessGroupId")
        self._AccessRuleId = params.get("AccessRuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetworkConnection(AbstractModel):
    r"""Network configuration

    """

    def __init__(self):
        r"""
        :param _Id: Network configuration ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: int
        :param _AssociateId: Unique identifier of network configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type AssociateId: str
        :param _HouseId: Computing engine ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type HouseId: str
        :param _DatasourceConnectionId: Data source ID (discarded)
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionId: str
        :param _State: Network configuration status (0 - initializing; 1 - normal)
Note: This field may return null, indicating that no valid values can be obtained.
        :type State: int
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _UpdateTime: Modification time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: int
        :param _Appid: Create user Appid.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Appid: int
        :param _HouseName: Computing engine name
Note: This field may return null, indicating that no valid values can be obtained.
        :type HouseName: str
        :param _DatasourceConnectionName: Network configuration name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionName: str
        :param _NetworkConnectionType: Network configuration type
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkConnectionType: int
        :param _Uin: Create user UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uin: str
        :param _SubAccountUin: Create user SubAccountUin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubAccountUin: str
        :param _NetworkConnectionDesc: Network configuration description
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkConnectionDesc: str
        :param _DatasourceConnectionVpcId: Data source vpcid
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionVpcId: str
        :param _DatasourceConnectionSubnetId: Data source SubnetId
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionSubnetId: str
        :param _DatasourceConnectionCidrBlock: Data source SubnetId
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionCidrBlock: str
        :param _DatasourceConnectionSubnetCidrBlock: Data source SubnetCidrBlock
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionSubnetCidrBlock: str
        """
        self._Id = None
        self._AssociateId = None
        self._HouseId = None
        self._DatasourceConnectionId = None
        self._State = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Appid = None
        self._HouseName = None
        self._DatasourceConnectionName = None
        self._NetworkConnectionType = None
        self._Uin = None
        self._SubAccountUin = None
        self._NetworkConnectionDesc = None
        self._DatasourceConnectionVpcId = None
        self._DatasourceConnectionSubnetId = None
        self._DatasourceConnectionCidrBlock = None
        self._DatasourceConnectionSubnetCidrBlock = None

    @property
    def Id(self):
        r"""Network configuration ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def AssociateId(self):
        r"""Unique identifier of network configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AssociateId

    @AssociateId.setter
    def AssociateId(self, AssociateId):
        self._AssociateId = AssociateId

    @property
    def HouseId(self):
        r"""Computing engine ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HouseId

    @HouseId.setter
    def HouseId(self, HouseId):
        self._HouseId = HouseId

    @property
    def DatasourceConnectionId(self):
        r"""Data source ID (discarded)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionId

    @DatasourceConnectionId.setter
    def DatasourceConnectionId(self, DatasourceConnectionId):
        self._DatasourceConnectionId = DatasourceConnectionId

    @property
    def State(self):
        r"""Network configuration status (0 - initializing; 1 - normal)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        r"""Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Modification time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Appid(self):
        r"""Create user Appid.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def HouseName(self):
        r"""Computing engine name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._HouseName

    @HouseName.setter
    def HouseName(self, HouseName):
        self._HouseName = HouseName

    @property
    def DatasourceConnectionName(self):
        r"""Network configuration name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def NetworkConnectionType(self):
        r"""Network configuration type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._NetworkConnectionType

    @NetworkConnectionType.setter
    def NetworkConnectionType(self, NetworkConnectionType):
        self._NetworkConnectionType = NetworkConnectionType

    @property
    def Uin(self):
        r"""Create user UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        r"""Create user SubAccountUin.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def NetworkConnectionDesc(self):
        r"""Network configuration description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NetworkConnectionDesc

    @NetworkConnectionDesc.setter
    def NetworkConnectionDesc(self, NetworkConnectionDesc):
        self._NetworkConnectionDesc = NetworkConnectionDesc

    @property
    def DatasourceConnectionVpcId(self):
        r"""Data source vpcid
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionVpcId

    @DatasourceConnectionVpcId.setter
    def DatasourceConnectionVpcId(self, DatasourceConnectionVpcId):
        self._DatasourceConnectionVpcId = DatasourceConnectionVpcId

    @property
    def DatasourceConnectionSubnetId(self):
        r"""Data source SubnetId
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionSubnetId

    @DatasourceConnectionSubnetId.setter
    def DatasourceConnectionSubnetId(self, DatasourceConnectionSubnetId):
        self._DatasourceConnectionSubnetId = DatasourceConnectionSubnetId

    @property
    def DatasourceConnectionCidrBlock(self):
        r"""Data source SubnetId
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionCidrBlock

    @DatasourceConnectionCidrBlock.setter
    def DatasourceConnectionCidrBlock(self, DatasourceConnectionCidrBlock):
        self._DatasourceConnectionCidrBlock = DatasourceConnectionCidrBlock

    @property
    def DatasourceConnectionSubnetCidrBlock(self):
        r"""Data source SubnetCidrBlock
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionSubnetCidrBlock

    @DatasourceConnectionSubnetCidrBlock.setter
    def DatasourceConnectionSubnetCidrBlock(self, DatasourceConnectionSubnetCidrBlock):
        self._DatasourceConnectionSubnetCidrBlock = DatasourceConnectionSubnetCidrBlock


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._AssociateId = params.get("AssociateId")
        self._HouseId = params.get("HouseId")
        self._DatasourceConnectionId = params.get("DatasourceConnectionId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Appid = params.get("Appid")
        self._HouseName = params.get("HouseName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._NetworkConnectionType = params.get("NetworkConnectionType")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        self._NetworkConnectionDesc = params.get("NetworkConnectionDesc")
        self._DatasourceConnectionVpcId = params.get("DatasourceConnectionVpcId")
        self._DatasourceConnectionSubnetId = params.get("DatasourceConnectionSubnetId")
        self._DatasourceConnectionCidrBlock = params.get("DatasourceConnectionCidrBlock")
        self._DatasourceConnectionSubnetCidrBlock = params.get("DatasourceConnectionSubnetCidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpendThirdAccessUserInfo(AbstractModel):
    r"""Information about the users accessing through the third-party

    """

    def __init__(self):
        r"""
        :param _Id: ID information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: int
        :param _Uin: User primary UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uin: str
        :param _AppId: User AppID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppId: str
        :param _CreateTime: Activation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._Id = None
        self._Uin = None
        self._AppId = None
        self._CreateTime = None

    @property
    def Id(self):
        r"""ID information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uin(self):
        r"""User primary UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def AppId(self):
        r"""User AppID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def CreateTime(self):
        r"""Activation time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uin = params.get("Uin")
        self._AppId = params.get("AppId")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OtherCHDFSBinding(AbstractModel):
    r"""Binding Self-purchased CHDFS to DLC

    """

    def __init__(self):
        r"""
        :param _ProductName: Product name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProductName: str
        :param _SuperUser: User name (a discarded field)
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuperUser: list of str
        :param _VpcInfo: VPC configuration information
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcInfo: list of CHDFSProductVpcInfo
        :param _IsBind: Whether to bind the bucket (a discarded field)
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsBind: bool
        """
        self._ProductName = None
        self._SuperUser = None
        self._VpcInfo = None
        self._IsBind = None

    @property
    def ProductName(self):
        r"""Product name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def SuperUser(self):
        r"""User name (a discarded field)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._SuperUser

    @SuperUser.setter
    def SuperUser(self, SuperUser):
        self._SuperUser = SuperUser

    @property
    def VpcInfo(self):
        r"""VPC configuration information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of CHDFSProductVpcInfo
        """
        return self._VpcInfo

    @VpcInfo.setter
    def VpcInfo(self, VpcInfo):
        self._VpcInfo = VpcInfo

    @property
    def IsBind(self):
        r"""Whether to bind the bucket (a discarded field)
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsBind

    @IsBind.setter
    def IsBind(self, IsBind):
        self._IsBind = IsBind


    def _deserialize(self, params):
        self._ProductName = params.get("ProductName")
        self._SuperUser = params.get("SuperUser")
        if params.get("VpcInfo") is not None:
            self._VpcInfo = []
            for item in params.get("VpcInfo"):
                obj = CHDFSProductVpcInfo()
                obj._deserialize(item)
                self._VpcInfo.append(obj)
        self._IsBind = params.get("IsBind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PermissionResponseInfo(AbstractModel):
    r"""Permission information

    """

    def __init__(self):
        r"""
        :param _AccessType: Permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessType: str
        :param _ResourceBaseInfo: Resource information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceBaseInfo: :class:`tencentcloud.dlc.v20210125.models.ResourceBaseInfo`
        :param _Allowed: Authentication result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Allowed: bool
        """
        self._AccessType = None
        self._ResourceBaseInfo = None
        self._Allowed = None

    @property
    def AccessType(self):
        r"""Permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def ResourceBaseInfo(self):
        r"""Resource information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.ResourceBaseInfo`
        """
        return self._ResourceBaseInfo

    @ResourceBaseInfo.setter
    def ResourceBaseInfo(self, ResourceBaseInfo):
        self._ResourceBaseInfo = ResourceBaseInfo

    @property
    def Allowed(self):
        r"""Authentication result
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._Allowed

    @Allowed.setter
    def Allowed(self, Allowed):
        self._Allowed = Allowed


    def _deserialize(self, params):
        self._AccessType = params.get("AccessType")
        if params.get("ResourceBaseInfo") is not None:
            self._ResourceBaseInfo = ResourceBaseInfo()
            self._ResourceBaseInfo._deserialize(params.get("ResourceBaseInfo"))
        self._Allowed = params.get("Allowed")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Policy(AbstractModel):
    r"""Permission objects

    """

    def __init__(self):
        r"""
        :param _Database: The database name requiring authorization. use * to represent all databases under the current Catalog. for administrator level authorization type, only * is allowed. for data connection level authorization type, leave it blank. for other types, any specified database is allowed.
        :type Database: str
        :param _Catalog: Specifies the name of the data source requiring authorization. at administrator level, only * is supported (representing all resources at this level). for database-level or data source-level authentication, only COSDataCatalog or * is supported. for table-level authentication, user-defined data sources can be filled. defaults to DataLakeCatalog if left blank. note: if authenticating a user-defined data source, the permissions DLC can manage are a subset of the account provided when the user accesses the data source.
        :type Catalog: str
        :param _Table: Specifies the table name requiring authorization. use * to represent all tables in the current Database. for administrator-level authorization type, only * is allowed. for data connection level or Database-level authorization type, leave it blank. for other types, any specific data table can be specified.
        :type Table: str
        :param _Operation: The target permissions, which vary by permission level. Admin: `ALL` (default); data connection: `CREATE`; database: `ALL`, `CREATE`, `ALTER`, and `DROP`; table: `ALL`, `SELECT`, `INSERT`, `ALTER`, `DELETE`, `DROP`, and `UPDATE`. Note: For table permissions, if a data source other than `COSDataCatalog` is specified, only the `SELECT` permission can be granted here.
        :type Operation: str
        :param _PolicyType: The permission type. Valid values: `ADMIN`, `DATASOURCE`, `DATABASE`, `TABLE`, `VIEW`, `FUNCTION`, `COLUMN`, and `ENGINE`. Note: If it is left empty, `ADMIN` is used.
        :type PolicyType: str
        :param _Function: Name of the function requiring authorization. use * to represent all functions in the current Catalog. for administrator-level authorization type, only * is allowed. for data connection-level authorization type, leave it blank. for other types, any function can be specified.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Function: str
        :param _View: Authorization is required for the view. fill in * to represent all views under the current Database. when the authorization type is administrator level, only * is allowed. when the authorization type is data connection level or Database level, only blank is allowed. for other types, any view can be specified.
Note: This field may return null, indicating that no valid values can be obtained.
        :type View: str
        :param _Column: Columns requiring authorization. use * to represent all current columns. when the authorization type is administrator level, only * is allowed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Column: str
        :param _DataEngine: The data engine requiring authorization. use * to represent all current engines. when the authorization type is administrator level, only * is allowed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngine: str
        :param _ReAuth: Whether the grantee is allowed to further grant the permissions. Valid values: `false` (default) and `true` (the grantee can grant permissions gained here to other sub-users).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReAuth: bool
        :param _Source: The permission source, which is not required when input parameters are passed in. Valid values: `USER` (from the user) and `WORKGROUP` (from one or more associated work groups).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Source: str
        :param _Mode: The grant mode, which is not required as an input parameter. Valid values: `COMMON` and `SENIOR`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Mode: str
        :param _Operator: The operator, which is not required as an input parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Operator: str
        :param _CreateTime: The permission policy creation time, which is not required as an input parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _SourceId: The ID of the work group, which applies only when the value of the `Source` field is `WORKGROUP`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceId: int
        :param _SourceName: The name of the work group, which applies only when the value of the `Source` field is `WORKGROUP`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SourceName: str
        :param _Id: The policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: int
        :param _EngineGeneration: Specifies the engine type.

        :type EngineGeneration: str
        """
        self._Database = None
        self._Catalog = None
        self._Table = None
        self._Operation = None
        self._PolicyType = None
        self._Function = None
        self._View = None
        self._Column = None
        self._DataEngine = None
        self._ReAuth = None
        self._Source = None
        self._Mode = None
        self._Operator = None
        self._CreateTime = None
        self._SourceId = None
        self._SourceName = None
        self._Id = None
        self._EngineGeneration = None

    @property
    def Database(self):
        r"""The database name requiring authorization. use * to represent all databases under the current Catalog. for administrator level authorization type, only * is allowed. for data connection level authorization type, leave it blank. for other types, any specified database is allowed.
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Catalog(self):
        r"""Specifies the name of the data source requiring authorization. at administrator level, only * is supported (representing all resources at this level). for database-level or data source-level authentication, only COSDataCatalog or * is supported. for table-level authentication, user-defined data sources can be filled. defaults to DataLakeCatalog if left blank. note: if authenticating a user-defined data source, the permissions DLC can manage are a subset of the account provided when the user accesses the data source.
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Table(self):
        r"""Specifies the table name requiring authorization. use * to represent all tables in the current Database. for administrator-level authorization type, only * is allowed. for data connection level or Database-level authorization type, leave it blank. for other types, any specific data table can be specified.
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def Operation(self):
        r"""The target permissions, which vary by permission level. Admin: `ALL` (default); data connection: `CREATE`; database: `ALL`, `CREATE`, `ALTER`, and `DROP`; table: `ALL`, `SELECT`, `INSERT`, `ALTER`, `DELETE`, `DROP`, and `UPDATE`. Note: For table permissions, if a data source other than `COSDataCatalog` is specified, only the `SELECT` permission can be granted here.
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def PolicyType(self):
        r"""The permission type. Valid values: `ADMIN`, `DATASOURCE`, `DATABASE`, `TABLE`, `VIEW`, `FUNCTION`, `COLUMN`, and `ENGINE`. Note: If it is left empty, `ADMIN` is used.
        :rtype: str
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def Function(self):
        r"""Name of the function requiring authorization. use * to represent all functions in the current Catalog. for administrator-level authorization type, only * is allowed. for data connection-level authorization type, leave it blank. for other types, any function can be specified.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Function

    @Function.setter
    def Function(self, Function):
        self._Function = Function

    @property
    def View(self):
        r"""Authorization is required for the view. fill in * to represent all views under the current Database. when the authorization type is administrator level, only * is allowed. when the authorization type is data connection level or Database level, only blank is allowed. for other types, any view can be specified.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._View

    @View.setter
    def View(self, View):
        self._View = View

    @property
    def Column(self):
        r"""Columns requiring authorization. use * to represent all current columns. when the authorization type is administrator level, only * is allowed.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Column

    @Column.setter
    def Column(self, Column):
        self._Column = Column

    @property
    def DataEngine(self):
        r"""The data engine requiring authorization. use * to represent all current engines. when the authorization type is administrator level, only * is allowed.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def ReAuth(self):
        r"""Whether the grantee is allowed to further grant the permissions. Valid values: `false` (default) and `true` (the grantee can grant permissions gained here to other sub-users).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._ReAuth

    @ReAuth.setter
    def ReAuth(self, ReAuth):
        self._ReAuth = ReAuth

    @property
    def Source(self):
        r"""The permission source, which is not required when input parameters are passed in. Valid values: `USER` (from the user) and `WORKGROUP` (from one or more associated work groups).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Mode(self):
        r"""The grant mode, which is not required as an input parameter. Valid values: `COMMON` and `SENIOR`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Operator(self):
        r"""The operator, which is not required as an input parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def CreateTime(self):
        r"""The permission policy creation time, which is not required as an input parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def SourceId(self):
        r"""The ID of the work group, which applies only when the value of the `Source` field is `WORKGROUP`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._SourceId

    @SourceId.setter
    def SourceId(self, SourceId):
        self._SourceId = SourceId

    @property
    def SourceName(self):
        r"""The name of the work group, which applies only when the value of the `Source` field is `WORKGROUP`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SourceName

    @SourceName.setter
    def SourceName(self, SourceName):
        self._SourceName = SourceName

    @property
    def Id(self):
        r"""The policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def EngineGeneration(self):
        r"""Specifies the engine type.

        :rtype: str
        """
        return self._EngineGeneration

    @EngineGeneration.setter
    def EngineGeneration(self, EngineGeneration):
        self._EngineGeneration = EngineGeneration


    def _deserialize(self, params):
        self._Database = params.get("Database")
        self._Catalog = params.get("Catalog")
        self._Table = params.get("Table")
        self._Operation = params.get("Operation")
        self._PolicyType = params.get("PolicyType")
        self._Function = params.get("Function")
        self._View = params.get("View")
        self._Column = params.get("Column")
        self._DataEngine = params.get("DataEngine")
        self._ReAuth = params.get("ReAuth")
        self._Source = params.get("Source")
        self._Mode = params.get("Mode")
        self._Operator = params.get("Operator")
        self._CreateTime = params.get("CreateTime")
        self._SourceId = params.get("SourceId")
        self._SourceName = params.get("SourceName")
        self._Id = params.get("Id")
        self._EngineGeneration = params.get("EngineGeneration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Policys(AbstractModel):
    r"""Collection of policies

    """

    def __init__(self):
        r"""
        :param _PolicySet: Collection of policies
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicySet: list of Policy
        :param _TotalCount: Total policies
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        """
        self._PolicySet = None
        self._TotalCount = None

    @property
    def PolicySet(self):
        r"""Collection of policies
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def TotalCount(self):
        r"""Total policies
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PrestoMonitorMetrics(AbstractModel):
    r"""Presto monitoring metrics

    """

    def __init__(self):
        r"""
        :param _LocalCacheHitRate: Note: This field may return null, indicating that no valid values can be obtained.
        :type LocalCacheHitRate: float
        :param _FragmentCacheHitRate: Note: This field may return null, indicating that no valid values can be obtained.
        :type FragmentCacheHitRate: float
        """
        self._LocalCacheHitRate = None
        self._FragmentCacheHitRate = None

    @property
    def LocalCacheHitRate(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._LocalCacheHitRate

    @LocalCacheHitRate.setter
    def LocalCacheHitRate(self, LocalCacheHitRate):
        self._LocalCacheHitRate = LocalCacheHitRate

    @property
    def FragmentCacheHitRate(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._FragmentCacheHitRate

    @FragmentCacheHitRate.setter
    def FragmentCacheHitRate(self, FragmentCacheHitRate):
        self._FragmentCacheHitRate = FragmentCacheHitRate


    def _deserialize(self, params):
        self._LocalCacheHitRate = params.get("LocalCacheHitRate")
        self._FragmentCacheHitRate = params.get("FragmentCacheHitRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Property(AbstractModel):
    r"""Properties of database and table

    """

    def __init__(self):
        r"""
        :param _Key: The property key name.
        :type Key: str
        :param _Value: The property value.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        r"""The property key name.
        :rtype: str
        """
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        r"""The property value.
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PythonSparkImage(AbstractModel):
    r"""Python-spark image information.

    """

    def __init__(self):
        r"""
        :param _SparkImageId: Unique ID of the spark image
        :type SparkImageId: str
        :param _ChildImageVersionId: ID of the cluster image of the minor version
        :type ChildImageVersionId: str
        :param _SparkImageVersion: Name of the spark image
        :type SparkImageVersion: str
        :param _Description: Description of the spark image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        """
        self._SparkImageId = None
        self._ChildImageVersionId = None
        self._SparkImageVersion = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def SparkImageId(self):
        r"""Unique ID of the spark image
        :rtype: str
        """
        return self._SparkImageId

    @SparkImageId.setter
    def SparkImageId(self, SparkImageId):
        self._SparkImageId = SparkImageId

    @property
    def ChildImageVersionId(self):
        r"""ID of the cluster image of the minor version
        :rtype: str
        """
        return self._ChildImageVersionId

    @ChildImageVersionId.setter
    def ChildImageVersionId(self, ChildImageVersionId):
        self._ChildImageVersionId = ChildImageVersionId

    @property
    def SparkImageVersion(self):
        r"""Name of the spark image
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def Description(self):
        r"""Description of the spark image
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._SparkImageId = params.get("SparkImageId")
        self._ChildImageVersionId = params.get("ChildImageVersionId")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryResultRequest(AbstractModel):
    r"""QueryResult request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _NextToken: lastReadFile is the file read last time. lastReadOffset is where the read stopped.
        :type NextToken: str
        """
        self._TaskId = None
        self._NextToken = None

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def NextToken(self):
        r"""lastReadFile is the file read last time. lastReadOffset is where the read stopped.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._NextToken = params.get("NextToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryResultResponse(AbstractModel):
    r"""QueryResult response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ResultSet: Result data
        :type ResultSet: str
        :param _ResultSchema: schema
        :type ResultSchema: list of Column
        :param _NextToken: Pagination information
Note: This field may return null, indicating that no valid values can be obtained.
        :type NextToken: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._ResultSet = None
        self._ResultSchema = None
        self._NextToken = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ResultSet(self):
        r"""Result data
        :rtype: str
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSchema(self):
        r"""schema
        :rtype: list of Column
        """
        return self._ResultSchema

    @ResultSchema.setter
    def ResultSchema(self, ResultSchema):
        self._ResultSchema = ResultSchema

    @property
    def NextToken(self):
        r"""Pagination information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ResultSet = params.get("ResultSet")
        if params.get("ResultSchema") is not None:
            self._ResultSchema = []
            for item in params.get("ResultSchema"):
                obj = Column()
                obj._deserialize(item)
                self._ResultSchema.append(obj)
        self._NextToken = params.get("NextToken")
        self._RequestId = params.get("RequestId")


class QueryTaskCostDetailRequest(AbstractModel):
    r"""QueryTaskCostDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria. The following filter types are supported. The parameter Name should be one of them. The maximum number of values that can be filtered by task-id is 50. The values that can be filtered by other parameter filters should not be more than 5.
task-id - String - (accurate filtering of task IDs). The example of the value of task-id is e386471f-139a-4e59-877f-50ece8135b99.
task-state - String - (filtering task status); valid values: 0 (initializing), 1 (running), 2 (successful), and -1 (failed).
task-sql-keyword - String - (fuzzy filtering of the keywords of SQL statements); the example of the value is DROP TABLE.
task-operator- string (filtering sub-UIN)
        :type Filters: list of Filter
        :param _StartTime: Start time, and the format is yyyy-mm-dd HH:MM:SS. It is the current moment 45 days ago by default.
        :type StartTime: str
        :param _EndTime: End time, and the format is yyyy-mm-dd HH:MM:SS. The time span is longer than 0 day but shorter than or equal to 30 days. Data within the recent 45 days can be queried. It is the current moment by default.
        :type EndTime: str
        :param _DataEngineName: Data engine name, used for selecting
        :type DataEngineName: str
        :param _SearchAfter: Identifier on the next page
        :type SearchAfter: str
        :param _PageSize: Size of each page
        :type PageSize: int
        """
        self._Filters = None
        self._StartTime = None
        self._EndTime = None
        self._DataEngineName = None
        self._SearchAfter = None
        self._PageSize = None

    @property
    def Filters(self):
        r"""Filter criteria. The following filter types are supported. The parameter Name should be one of them. The maximum number of values that can be filtered by task-id is 50. The values that can be filtered by other parameter filters should not be more than 5.
task-id - String - (accurate filtering of task IDs). The example of the value of task-id is e386471f-139a-4e59-877f-50ece8135b99.
task-state - String - (filtering task status); valid values: 0 (initializing), 1 (running), 2 (successful), and -1 (failed).
task-sql-keyword - String - (fuzzy filtering of the keywords of SQL statements); the example of the value is DROP TABLE.
task-operator- string (filtering sub-UIN)
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StartTime(self):
        r"""Start time, and the format is yyyy-mm-dd HH:MM:SS. It is the current moment 45 days ago by default.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time, and the format is yyyy-mm-dd HH:MM:SS. The time span is longer than 0 day but shorter than or equal to 30 days. Data within the recent 45 days can be queried. It is the current moment by default.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataEngineName(self):
        r"""Data engine name, used for selecting
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def SearchAfter(self):
        r"""Identifier on the next page
        :rtype: str
        """
        return self._SearchAfter

    @SearchAfter.setter
    def SearchAfter(self, SearchAfter):
        self._SearchAfter = SearchAfter

    @property
    def PageSize(self):
        r"""Size of each page
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataEngineName = params.get("DataEngineName")
        self._SearchAfter = params.get("SearchAfter")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryTaskCostDetailResponse(AbstractModel):
    r"""QueryTaskCostDetail response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RegisterThirdPartyAccessUserRequest(AbstractModel):
    r"""RegisterThirdPartyAccessUser request structure.

    """


class RegisterThirdPartyAccessUserResponse(AbstractModel):
    r"""RegisterThirdPartyAccessUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RenewDataEngineRequest(AbstractModel):
    r"""RenewDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: CU queue name
        :type DataEngineName: str
        :param _TimeSpan: Renewal period in months, which is at least one month.
        :type TimeSpan: int
        :param _PayMode: Payment type. It is 1 by default and is prepaid.
        :type PayMode: int
        :param _TimeUnit: Unit. It is m by default, and only m can be filled in.
        :type TimeUnit: str
        :param _RenewFlag: Auto-renewal flag: 0 means the initial status, and there is no automatic renewal by default. If the user has the privilege to retain services with prepayment, there will be an automatic renewal. 1 means that there is an automatic renewal. 2 means that there is surely no automatic renewal. If it is not specified, the parameter is 0 by default.
        :type RenewFlag: int
        """
        self._DataEngineName = None
        self._TimeSpan = None
        self._PayMode = None
        self._TimeUnit = None
        self._RenewFlag = None

    @property
    def DataEngineName(self):
        r"""CU queue name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def TimeSpan(self):
        r"""Renewal period in months, which is at least one month.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def PayMode(self):
        r"""Payment type. It is 1 by default and is prepaid.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def TimeUnit(self):
        r"""Unit. It is m by default, and only m can be filled in.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def RenewFlag(self):
        r"""Auto-renewal flag: 0 means the initial status, and there is no automatic renewal by default. If the user has the privilege to retain services with prepayment, there will be an automatic renewal. 1 means that there is an automatic renewal. 2 means that there is surely no automatic renewal. If it is not specified, the parameter is 0 by default.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._TimeSpan = params.get("TimeSpan")
        self._PayMode = params.get("PayMode")
        self._TimeUnit = params.get("TimeUnit")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RenewDataEngineResponse(AbstractModel):
    r"""RenewDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResourceBaseInfo(AbstractModel):
    r"""Resource basic information

    """

    def __init__(self):
        r"""
        :param _Catalog: Catalog name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Catalog: str
        :param _Schema: Schema name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Schema: str
        :param _Table: Table name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Table: str
        :param _View: View name
Note: This field may return null, indicating that no valid values can be obtained.
        :type View: str
        :param _Database: Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Database: str
        :param _Function: Function name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Function: str
        """
        self._Catalog = None
        self._Schema = None
        self._Table = None
        self._View = None
        self._Database = None
        self._Function = None

    @property
    def Catalog(self):
        r"""Catalog name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Schema(self):
        r"""Schema name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Schema

    @Schema.setter
    def Schema(self, Schema):
        self._Schema = Schema

    @property
    def Table(self):
        r"""Table name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def View(self):
        r"""View name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._View

    @View.setter
    def View(self, View):
        self._View = View

    @property
    def Database(self):
        r"""Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Function(self):
        r"""Function name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Function

    @Function.setter
    def Function(self, Function):
        self._Function = Function


    def _deserialize(self, params):
        self._Catalog = params.get("Catalog")
        self._Schema = params.get("Schema")
        self._Table = params.get("Table")
        self._View = params.get("View")
        self._Database = params.get("Database")
        self._Function = params.get("Function")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceInfo(AbstractModel):
    r"""ResourceInfo

    """

    def __init__(self):
        r"""
        :param _AttributionType: Affiliated type
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttributionType: str
        :param _ResourceType: Resource type
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceType: str
        :param _Name: Engine name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Instance: If the resource type is spark-sql, the value is Name; if the resource type is spark-batch, the value is session app_name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Instance: str
        :param _Favor: Affinity
Note: This field may return null, indicating that no valid values can be obtained.
        :type Favor: list of FavorInfo
        :param _Status: Status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._AttributionType = None
        self._ResourceType = None
        self._Name = None
        self._Instance = None
        self._Favor = None
        self._Status = None

    @property
    def AttributionType(self):
        r"""Affiliated type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AttributionType

    @AttributionType.setter
    def AttributionType(self, AttributionType):
        self._AttributionType = AttributionType

    @property
    def ResourceType(self):
        r"""Resource type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Name(self):
        r"""Engine name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Instance(self):
        r"""If the resource type is spark-sql, the value is Name; if the resource type is spark-batch, the value is session app_name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Favor(self):
        r"""Affinity
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of FavorInfo
        """
        return self._Favor

    @Favor.setter
    def Favor(self, Favor):
        self._Favor = Favor

    @property
    def Status(self):
        r"""Status
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._AttributionType = params.get("AttributionType")
        self._ResourceType = params.get("ResourceType")
        self._Name = params.get("Name")
        self._Instance = params.get("Instance")
        if params.get("Favor") is not None:
            self._Favor = []
            for item in params.get("Favor"):
                obj = FavorInfo()
                obj._deserialize(item)
                self._Favor.append(obj)
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartDataEngineRequest(AbstractModel):
    r"""RestartDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        :param _ForcedOperation: Whether to restart by force and ignore tasks
        :type ForcedOperation: bool
        """
        self._DataEngineId = None
        self._ForcedOperation = None

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def ForcedOperation(self):
        r"""Whether to restart by force and ignore tasks
        :rtype: bool
        """
        return self._ForcedOperation

    @ForcedOperation.setter
    def ForcedOperation(self, ForcedOperation):
        self._ForcedOperation = ForcedOperation


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._ForcedOperation = params.get("ForcedOperation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartDataEngineResponse(AbstractModel):
    r"""RestartDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RevokeDLCCatalogAccessRequest(AbstractModel):
    r"""RevokeDLCCatalogAccess request structure.

    """

    def __init__(self):
        r"""
        :param _VpcId: VpcID
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        r"""VpcID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RevokeDLCCatalogAccessResponse(AbstractModel):
    r"""RevokeDLCCatalogAccess response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RollbackDataEngineImageRequest(AbstractModel):
    r"""RollbackDataEngineImage request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        :param _FromRecordId: FromRecordId parameters returned by the API for checking the availability of rolling back
        :type FromRecordId: str
        :param _ToRecordId: ToRecordId parameters returned by the API for checking the availability of rolling back
        :type ToRecordId: str
        """
        self._DataEngineId = None
        self._FromRecordId = None
        self._ToRecordId = None

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def FromRecordId(self):
        r"""FromRecordId parameters returned by the API for checking the availability of rolling back
        :rtype: str
        """
        return self._FromRecordId

    @FromRecordId.setter
    def FromRecordId(self, FromRecordId):
        self._FromRecordId = FromRecordId

    @property
    def ToRecordId(self):
        r"""ToRecordId parameters returned by the API for checking the availability of rolling back
        :rtype: str
        """
        return self._ToRecordId

    @ToRecordId.setter
    def ToRecordId(self, ToRecordId):
        self._ToRecordId = ToRecordId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._FromRecordId = params.get("FromRecordId")
        self._ToRecordId = params.get("ToRecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackDataEngineImageResponse(AbstractModel):
    r"""RollbackDataEngineImage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SQLTask(AbstractModel):
    r"""SQL query task

    """

    def __init__(self):
        r"""
        :param _SQL: Base64-encrypted SQL statement
        :type SQL: str
        :param _Config: Task configuration information
        :type Config: list of KVPair
        """
        self._SQL = None
        self._Config = None

    @property
    def SQL(self):
        r"""Base64-encrypted SQL statement
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def Config(self):
        r"""Task configuration information
        :rtype: list of KVPair
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config


    def _deserialize(self, params):
        self._SQL = params.get("SQL")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = KVPair()
                obj._deserialize(item)
                self._Config.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SessionResourceTemplate(AbstractModel):
    r"""The session resource configuration template for a Spark cluster.

    """

    def __init__(self):
        r"""
        :param _DriverSize: The driver size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DriverSize: str
        :param _ExecutorSize: The executor size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutorSize: str
        :param _ExecutorNums: The executor count. The minimum value is 1 and the maximum value is less than the cluster specification.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutorNums: int
        :param _ExecutorMaxNumbers: The maximum executor count (in dynamic mode). The minimum value is 1 and the maximum value is less than the cluster specification. If you set `ExecutorMaxNumbers` to a value smaller than that of `ExecutorNums`, the value of `ExecutorMaxNumbers` is automatically changed to that of `ExecutorNums`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutorMaxNumbers: int
        """
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNums = None
        self._ExecutorMaxNumbers = None

    @property
    def DriverSize(self):
        r"""The driver size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""The executor size.
Valid values for the standard resource type: `small`, `medium`, `large`, and `xlarge`.
Valid values for the memory resource type: `m.small`, `m.medium`, `m.large`, and `m.xlarge`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNums(self):
        r"""The executor count. The minimum value is 1 and the maximum value is less than the cluster specification.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExecutorNums

    @ExecutorNums.setter
    def ExecutorNums(self, ExecutorNums):
        self._ExecutorNums = ExecutorNums

    @property
    def ExecutorMaxNumbers(self):
        r"""The maximum executor count (in dynamic mode). The minimum value is 1 and the maximum value is less than the cluster specification. If you set `ExecutorMaxNumbers` to a value smaller than that of `ExecutorNums`, the value of `ExecutorMaxNumbers` is automatically changed to that of `ExecutorNums`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers


    def _deserialize(self, params):
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNums = params.get("ExecutorNums")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SmartOptimizerIndexPolicy(AbstractModel):
    r"""SmartOptimizerIndexPolicy

    """

    def __init__(self):
        r"""
        :param _IndexEnable: Enable index.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IndexEnable: str
        """
        self._IndexEnable = None

    @property
    def IndexEnable(self):
        r"""Enable index.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IndexEnable

    @IndexEnable.setter
    def IndexEnable(self, IndexEnable):
        self._IndexEnable = IndexEnable


    def _deserialize(self, params):
        self._IndexEnable = params.get("IndexEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SmartOptimizerLifecyclePolicy(AbstractModel):
    r"""SmartOptimizerLifecyclePolicy

    """

    def __init__(self):
        r"""
        :param _LifecycleEnable: Enable the lifecycle
Note: This field may return null, indicating that no valid values can be obtained.
        :type LifecycleEnable: str
        :param _Expiration: Expiration time
Note: This field may return null, indicating that no valid values can be obtained.
        :type Expiration: int
        :param _DropTable: Whether to delete the table
Note: This field may return null, indicating that no valid values can be obtained.
        :type DropTable: bool
        :param _ExpiredField: Expired fields
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpiredField: str
        :param _ExpiredFieldFormat: Expired field format
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpiredFieldFormat: str
        """
        self._LifecycleEnable = None
        self._Expiration = None
        self._DropTable = None
        self._ExpiredField = None
        self._ExpiredFieldFormat = None

    @property
    def LifecycleEnable(self):
        r"""Enable the lifecycle
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._LifecycleEnable

    @LifecycleEnable.setter
    def LifecycleEnable(self, LifecycleEnable):
        self._LifecycleEnable = LifecycleEnable

    @property
    def Expiration(self):
        r"""Expiration time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Expiration

    @Expiration.setter
    def Expiration(self, Expiration):
        self._Expiration = Expiration

    @property
    def DropTable(self):
        r"""Whether to delete the table
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._DropTable

    @DropTable.setter
    def DropTable(self, DropTable):
        self._DropTable = DropTable

    @property
    def ExpiredField(self):
        r"""Expired fields
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpiredField

    @ExpiredField.setter
    def ExpiredField(self, ExpiredField):
        self._ExpiredField = ExpiredField

    @property
    def ExpiredFieldFormat(self):
        r"""Expired field format
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExpiredFieldFormat

    @ExpiredFieldFormat.setter
    def ExpiredFieldFormat(self, ExpiredFieldFormat):
        self._ExpiredFieldFormat = ExpiredFieldFormat


    def _deserialize(self, params):
        self._LifecycleEnable = params.get("LifecycleEnable")
        self._Expiration = params.get("Expiration")
        self._DropTable = params.get("DropTable")
        self._ExpiredField = params.get("ExpiredField")
        self._ExpiredFieldFormat = params.get("ExpiredFieldFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SmartOptimizerPolicy(AbstractModel):
    r"""SmartOptimizerPolicy

    """

    def __init__(self):
        r"""
        :param _Inherit: Whether to inherit it
Note: This field may return null, indicating that no valid values can be obtained.
        :type Inherit: str
        :param _Resources: ResourceInfo
Note: This field may return null, indicating that no valid values can be obtained.
        :type Resources: list of ResourceInfo
        :param _Written: SmartOptimizerWrittenPolicy
Note: This field may return null, indicating that no valid values can be obtained.
        :type Written: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerWrittenPolicy`
        :param _Lifecycle: SmartOptimizerLifecyclePolicy
Note: This field may return null, indicating that no valid values can be obtained.
        :type Lifecycle: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerLifecyclePolicy`
        :param _Index: SmartOptimizerIndexPolicy
Note: This field may return null, indicating that no valid values can be obtained.
        :type Index: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerIndexPolicy`
        """
        self._Inherit = None
        self._Resources = None
        self._Written = None
        self._Lifecycle = None
        self._Index = None

    @property
    def Inherit(self):
        r"""Whether to inherit it
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Inherit

    @Inherit.setter
    def Inherit(self, Inherit):
        self._Inherit = Inherit

    @property
    def Resources(self):
        r"""ResourceInfo
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ResourceInfo
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources

    @property
    def Written(self):
        r"""SmartOptimizerWrittenPolicy
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerWrittenPolicy`
        """
        return self._Written

    @Written.setter
    def Written(self, Written):
        self._Written = Written

    @property
    def Lifecycle(self):
        r"""SmartOptimizerLifecyclePolicy
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerLifecyclePolicy`
        """
        return self._Lifecycle

    @Lifecycle.setter
    def Lifecycle(self, Lifecycle):
        self._Lifecycle = Lifecycle

    @property
    def Index(self):
        r"""SmartOptimizerIndexPolicy
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerIndexPolicy`
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index


    def _deserialize(self, params):
        self._Inherit = params.get("Inherit")
        if params.get("Resources") is not None:
            self._Resources = []
            for item in params.get("Resources"):
                obj = ResourceInfo()
                obj._deserialize(item)
                self._Resources.append(obj)
        if params.get("Written") is not None:
            self._Written = SmartOptimizerWrittenPolicy()
            self._Written._deserialize(params.get("Written"))
        if params.get("Lifecycle") is not None:
            self._Lifecycle = SmartOptimizerLifecyclePolicy()
            self._Lifecycle._deserialize(params.get("Lifecycle"))
        if params.get("Index") is not None:
            self._Index = SmartOptimizerIndexPolicy()
            self._Index._deserialize(params.get("Index"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SmartOptimizerWrittenPolicy(AbstractModel):
    r"""SmartOptimizerWrittenPolicy

    """

    def __init__(self):
        r"""
        :param _WrittenEnable: none/enable/disable/default
Note: This field may return null, indicating that no valid values can be obtained.
        :type WrittenEnable: str
        """
        self._WrittenEnable = None

    @property
    def WrittenEnable(self):
        r"""none/enable/disable/default
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._WrittenEnable

    @WrittenEnable.setter
    def WrittenEnable(self, WrittenEnable):
        self._WrittenEnable = WrittenEnable


    def _deserialize(self, params):
        self._WrittenEnable = params.get("WrittenEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SmartPolicy(AbstractModel):
    r"""SmartPolicyRequest

    """

    def __init__(self):
        r"""
        :param _BaseInfo: Basic information
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaseInfo: :class:`tencentcloud.dlc.v20210125.models.SmartPolicyBaseInfo`
        :param _Policy: Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Policy: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerPolicy`
        """
        self._BaseInfo = None
        self._Policy = None

    @property
    def BaseInfo(self):
        r"""Basic information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartPolicyBaseInfo`
        """
        return self._BaseInfo

    @BaseInfo.setter
    def BaseInfo(self, BaseInfo):
        self._BaseInfo = BaseInfo

    @property
    def Policy(self):
        r"""Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartOptimizerPolicy`
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy


    def _deserialize(self, params):
        if params.get("BaseInfo") is not None:
            self._BaseInfo = SmartPolicyBaseInfo()
            self._BaseInfo._deserialize(params.get("BaseInfo"))
        if params.get("Policy") is not None:
            self._Policy = SmartOptimizerPolicy()
            self._Policy._deserialize(params.get("Policy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SmartPolicyBaseInfo(AbstractModel):
    r"""SmartPolicyBaseInfo

    """

    def __init__(self):
        r"""
        :param _Uin: User UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uin: str
        :param _PolicyType: Catalog/Database/Table
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyType: str
        :param _Catalog: Catalog name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Catalog: str
        :param _Database: Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Database: str
        :param _Table: Table name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Table: str
        :param _AppId: User AppID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppId: str
        """
        self._Uin = None
        self._PolicyType = None
        self._Catalog = None
        self._Database = None
        self._Table = None
        self._AppId = None

    @property
    def Uin(self):
        r"""User UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def PolicyType(self):
        r"""Catalog/Database/Table
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def Catalog(self):
        r"""Catalog name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def Database(self):
        r"""Database name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Table(self):
        r"""Table name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table

    @property
    def AppId(self):
        r"""User AppID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId


    def _deserialize(self, params):
        self._Uin = params.get("Uin")
        self._PolicyType = params.get("PolicyType")
        self._Catalog = params.get("Catalog")
        self._Database = params.get("Database")
        self._Table = params.get("Table")
        self._AppId = params.get("AppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SparkJobInfo(AbstractModel):
    r"""Spark job details

    """

    def __init__(self):
        r"""
        :param _JobId: Spark job ID
        :type JobId: str
        :param _JobName: Spark job name
        :type JobName: str
        :param _JobType: Spark job type. Valid values: `1` (batch job), `2` (streaming job).
        :type JobType: int
        :param _DataEngine: Engine name
        :type DataEngine: str
        :param _Eni: This field has been disused. Use the `Datasource` field instead.
        :type Eni: str
        :param _IsLocal: Whether the program package is uploaded locally. Valid values: `cos`, `lakefs`.
        :type IsLocal: str
        :param _JobFile: Program package path
        :type JobFile: str
        :param _RoleArn: Role ID
        :type RoleArn: int
        :param _MainClass: Main class of Spark job execution
        :type MainClass: str
        :param _CmdArgs: Command line parameters of the Spark job separated by space
        :type CmdArgs: str
        :param _JobConf: Native Spark configurations separated by line break
        :type JobConf: str
        :param _IsLocalJars: Whether the dependency JAR packages are uploaded locally. Valid values: `cos`, `lakefs`.
        :type IsLocalJars: str
        :param _JobJars: Dependency JAR packages of the Spark job separated by comma
        :type JobJars: str
        :param _IsLocalFiles: Whether the dependency file is uploaded locally. Valid values: `cos`, `lakefs`.
        :type IsLocalFiles: str
        :param _JobFiles: Dependency files of the Spark job separated by comma
        :type JobFiles: str
        :param _JobDriverSize: Driver resource size of the Spark job
        :type JobDriverSize: str
        :param _JobExecutorSize: Executor resource size of the Spark job
        :type JobExecutorSize: str
        :param _JobExecutorNums: Number of Spark job executors
        :type JobExecutorNums: int
        :param _JobMaxAttempts: Maximum number of retries of the Spark flow task
        :type JobMaxAttempts: int
        :param _JobCreator: Spark job creator
        :type JobCreator: str
        :param _JobCreateTime: Spark job creation time
        :type JobCreateTime: int
        :param _JobUpdateTime: Spark job update time
        :type JobUpdateTime: int
        :param _CurrentTaskId: Last task ID of the Spark job
        :type CurrentTaskId: str
        :param _JobStatus: Last status of the Spark job
        :type JobStatus: int
        :param _StreamingStat: Note: This field may return null, indicating that no valid values can be obtained.
        :type StreamingStat: :class:`tencentcloud.dlc.v20210125.models.StreamingStatistics`
        :param _DataSource: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataSource: str
        :param _IsLocalPythonFiles: Note: This field may return null, indicating that no valid values can be obtained.
        :type IsLocalPythonFiles: str
        :param _AppPythonFiles: Note: This field may return null, indicating that no valid values can be obtained.
        :type AppPythonFiles: str
        :param _IsLocalArchives: Note: This field may return null, indicating that no valid values can be obtained.
        :type IsLocalArchives: str
        :param _JobArchives: Note: This field may return null, indicating that no valid values can be obtained.
        :type JobArchives: str
        :param _SparkImage: Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkImage: str
        :param _JobPythonFiles: Note: This field may return null, indicating that no valid values can be obtained.
        :type JobPythonFiles: str
        :param _TaskNum: Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskNum: int
        :param _DataEngineStatus: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineStatus: int
        :param _JobExecutorMaxNumbers: Note: This field may return null, indicating that no valid values can be obtained.
        :type JobExecutorMaxNumbers: int
        :param _SparkImageVersion: Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkImageVersion: str
        :param _SessionId: Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionId: str
        :param _DataEngineClusterType: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineClusterType: str
        :param _DataEngineImageVersion: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineImageVersion: str
        :param _IsInherit: Note: This field may return null, indicating that no valid values can be obtained.
        :type IsInherit: int
        :param _IsSessionStarted: Note: This field may return null, indicating that no valid values can be obtained.
        :type IsSessionStarted: bool
        :param _EngineTypeDetail: Note: This field may return null, indicating that no valid values can be obtained.
        :type EngineTypeDetail: str
        """
        self._JobId = None
        self._JobName = None
        self._JobType = None
        self._DataEngine = None
        self._Eni = None
        self._IsLocal = None
        self._JobFile = None
        self._RoleArn = None
        self._MainClass = None
        self._CmdArgs = None
        self._JobConf = None
        self._IsLocalJars = None
        self._JobJars = None
        self._IsLocalFiles = None
        self._JobFiles = None
        self._JobDriverSize = None
        self._JobExecutorSize = None
        self._JobExecutorNums = None
        self._JobMaxAttempts = None
        self._JobCreator = None
        self._JobCreateTime = None
        self._JobUpdateTime = None
        self._CurrentTaskId = None
        self._JobStatus = None
        self._StreamingStat = None
        self._DataSource = None
        self._IsLocalPythonFiles = None
        self._AppPythonFiles = None
        self._IsLocalArchives = None
        self._JobArchives = None
        self._SparkImage = None
        self._JobPythonFiles = None
        self._TaskNum = None
        self._DataEngineStatus = None
        self._JobExecutorMaxNumbers = None
        self._SparkImageVersion = None
        self._SessionId = None
        self._DataEngineClusterType = None
        self._DataEngineImageVersion = None
        self._IsInherit = None
        self._IsSessionStarted = None
        self._EngineTypeDetail = None

    @property
    def JobId(self):
        r"""Spark job ID
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def JobName(self):
        r"""Spark job name
        :rtype: str
        """
        return self._JobName

    @JobName.setter
    def JobName(self, JobName):
        self._JobName = JobName

    @property
    def JobType(self):
        r"""Spark job type. Valid values: `1` (batch job), `2` (streaming job).
        :rtype: int
        """
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def DataEngine(self):
        r"""Engine name
        :rtype: str
        """
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def Eni(self):
        r"""This field has been disused. Use the `Datasource` field instead.
        :rtype: str
        """
        return self._Eni

    @Eni.setter
    def Eni(self, Eni):
        self._Eni = Eni

    @property
    def IsLocal(self):
        r"""Whether the program package is uploaded locally. Valid values: `cos`, `lakefs`.
        :rtype: str
        """
        return self._IsLocal

    @IsLocal.setter
    def IsLocal(self, IsLocal):
        self._IsLocal = IsLocal

    @property
    def JobFile(self):
        r"""Program package path
        :rtype: str
        """
        return self._JobFile

    @JobFile.setter
    def JobFile(self, JobFile):
        self._JobFile = JobFile

    @property
    def RoleArn(self):
        r"""Role ID
        :rtype: int
        """
        return self._RoleArn

    @RoleArn.setter
    def RoleArn(self, RoleArn):
        self._RoleArn = RoleArn

    @property
    def MainClass(self):
        r"""Main class of Spark job execution
        :rtype: str
        """
        return self._MainClass

    @MainClass.setter
    def MainClass(self, MainClass):
        self._MainClass = MainClass

    @property
    def CmdArgs(self):
        r"""Command line parameters of the Spark job separated by space
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def JobConf(self):
        r"""Native Spark configurations separated by line break
        :rtype: str
        """
        return self._JobConf

    @JobConf.setter
    def JobConf(self, JobConf):
        self._JobConf = JobConf

    @property
    def IsLocalJars(self):
        r"""Whether the dependency JAR packages are uploaded locally. Valid values: `cos`, `lakefs`.
        :rtype: str
        """
        return self._IsLocalJars

    @IsLocalJars.setter
    def IsLocalJars(self, IsLocalJars):
        self._IsLocalJars = IsLocalJars

    @property
    def JobJars(self):
        r"""Dependency JAR packages of the Spark job separated by comma
        :rtype: str
        """
        return self._JobJars

    @JobJars.setter
    def JobJars(self, JobJars):
        self._JobJars = JobJars

    @property
    def IsLocalFiles(self):
        r"""Whether the dependency file is uploaded locally. Valid values: `cos`, `lakefs`.
        :rtype: str
        """
        return self._IsLocalFiles

    @IsLocalFiles.setter
    def IsLocalFiles(self, IsLocalFiles):
        self._IsLocalFiles = IsLocalFiles

    @property
    def JobFiles(self):
        r"""Dependency files of the Spark job separated by comma
        :rtype: str
        """
        return self._JobFiles

    @JobFiles.setter
    def JobFiles(self, JobFiles):
        self._JobFiles = JobFiles

    @property
    def JobDriverSize(self):
        r"""Driver resource size of the Spark job
        :rtype: str
        """
        return self._JobDriverSize

    @JobDriverSize.setter
    def JobDriverSize(self, JobDriverSize):
        self._JobDriverSize = JobDriverSize

    @property
    def JobExecutorSize(self):
        r"""Executor resource size of the Spark job
        :rtype: str
        """
        return self._JobExecutorSize

    @JobExecutorSize.setter
    def JobExecutorSize(self, JobExecutorSize):
        self._JobExecutorSize = JobExecutorSize

    @property
    def JobExecutorNums(self):
        r"""Number of Spark job executors
        :rtype: int
        """
        return self._JobExecutorNums

    @JobExecutorNums.setter
    def JobExecutorNums(self, JobExecutorNums):
        self._JobExecutorNums = JobExecutorNums

    @property
    def JobMaxAttempts(self):
        r"""Maximum number of retries of the Spark flow task
        :rtype: int
        """
        return self._JobMaxAttempts

    @JobMaxAttempts.setter
    def JobMaxAttempts(self, JobMaxAttempts):
        self._JobMaxAttempts = JobMaxAttempts

    @property
    def JobCreator(self):
        r"""Spark job creator
        :rtype: str
        """
        return self._JobCreator

    @JobCreator.setter
    def JobCreator(self, JobCreator):
        self._JobCreator = JobCreator

    @property
    def JobCreateTime(self):
        r"""Spark job creation time
        :rtype: int
        """
        return self._JobCreateTime

    @JobCreateTime.setter
    def JobCreateTime(self, JobCreateTime):
        self._JobCreateTime = JobCreateTime

    @property
    def JobUpdateTime(self):
        r"""Spark job update time
        :rtype: int
        """
        return self._JobUpdateTime

    @JobUpdateTime.setter
    def JobUpdateTime(self, JobUpdateTime):
        self._JobUpdateTime = JobUpdateTime

    @property
    def CurrentTaskId(self):
        r"""Last task ID of the Spark job
        :rtype: str
        """
        return self._CurrentTaskId

    @CurrentTaskId.setter
    def CurrentTaskId(self, CurrentTaskId):
        self._CurrentTaskId = CurrentTaskId

    @property
    def JobStatus(self):
        r"""Last status of the Spark job
        :rtype: int
        """
        return self._JobStatus

    @JobStatus.setter
    def JobStatus(self, JobStatus):
        self._JobStatus = JobStatus

    @property
    def StreamingStat(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.StreamingStatistics`
        """
        return self._StreamingStat

    @StreamingStat.setter
    def StreamingStat(self, StreamingStat):
        self._StreamingStat = StreamingStat

    @property
    def DataSource(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataSource

    @DataSource.setter
    def DataSource(self, DataSource):
        self._DataSource = DataSource

    @property
    def IsLocalPythonFiles(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IsLocalPythonFiles

    @IsLocalPythonFiles.setter
    def IsLocalPythonFiles(self, IsLocalPythonFiles):
        self._IsLocalPythonFiles = IsLocalPythonFiles

    @property
    def AppPythonFiles(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AppPythonFiles

    @AppPythonFiles.setter
    def AppPythonFiles(self, AppPythonFiles):
        self._AppPythonFiles = AppPythonFiles

    @property
    def IsLocalArchives(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._IsLocalArchives

    @IsLocalArchives.setter
    def IsLocalArchives(self, IsLocalArchives):
        self._IsLocalArchives = IsLocalArchives

    @property
    def JobArchives(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._JobArchives

    @JobArchives.setter
    def JobArchives(self, JobArchives):
        self._JobArchives = JobArchives

    @property
    def SparkImage(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkImage

    @SparkImage.setter
    def SparkImage(self, SparkImage):
        self._SparkImage = SparkImage

    @property
    def JobPythonFiles(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._JobPythonFiles

    @JobPythonFiles.setter
    def JobPythonFiles(self, JobPythonFiles):
        self._JobPythonFiles = JobPythonFiles

    @property
    def TaskNum(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TaskNum

    @TaskNum.setter
    def TaskNum(self, TaskNum):
        self._TaskNum = TaskNum

    @property
    def DataEngineStatus(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DataEngineStatus

    @DataEngineStatus.setter
    def DataEngineStatus(self, DataEngineStatus):
        self._DataEngineStatus = DataEngineStatus

    @property
    def JobExecutorMaxNumbers(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._JobExecutorMaxNumbers

    @JobExecutorMaxNumbers.setter
    def JobExecutorMaxNumbers(self, JobExecutorMaxNumbers):
        self._JobExecutorMaxNumbers = JobExecutorMaxNumbers

    @property
    def SparkImageVersion(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkImageVersion

    @SparkImageVersion.setter
    def SparkImageVersion(self, SparkImageVersion):
        self._SparkImageVersion = SparkImageVersion

    @property
    def SessionId(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def DataEngineClusterType(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineClusterType

    @DataEngineClusterType.setter
    def DataEngineClusterType(self, DataEngineClusterType):
        self._DataEngineClusterType = DataEngineClusterType

    @property
    def DataEngineImageVersion(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineImageVersion

    @DataEngineImageVersion.setter
    def DataEngineImageVersion(self, DataEngineImageVersion):
        self._DataEngineImageVersion = DataEngineImageVersion

    @property
    def IsInherit(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._IsInherit

    @IsInherit.setter
    def IsInherit(self, IsInherit):
        self._IsInherit = IsInherit

    @property
    def IsSessionStarted(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsSessionStarted

    @IsSessionStarted.setter
    def IsSessionStarted(self, IsSessionStarted):
        self._IsSessionStarted = IsSessionStarted

    @property
    def EngineTypeDetail(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EngineTypeDetail

    @EngineTypeDetail.setter
    def EngineTypeDetail(self, EngineTypeDetail):
        self._EngineTypeDetail = EngineTypeDetail


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._JobName = params.get("JobName")
        self._JobType = params.get("JobType")
        self._DataEngine = params.get("DataEngine")
        self._Eni = params.get("Eni")
        self._IsLocal = params.get("IsLocal")
        self._JobFile = params.get("JobFile")
        self._RoleArn = params.get("RoleArn")
        self._MainClass = params.get("MainClass")
        self._CmdArgs = params.get("CmdArgs")
        self._JobConf = params.get("JobConf")
        self._IsLocalJars = params.get("IsLocalJars")
        self._JobJars = params.get("JobJars")
        self._IsLocalFiles = params.get("IsLocalFiles")
        self._JobFiles = params.get("JobFiles")
        self._JobDriverSize = params.get("JobDriverSize")
        self._JobExecutorSize = params.get("JobExecutorSize")
        self._JobExecutorNums = params.get("JobExecutorNums")
        self._JobMaxAttempts = params.get("JobMaxAttempts")
        self._JobCreator = params.get("JobCreator")
        self._JobCreateTime = params.get("JobCreateTime")
        self._JobUpdateTime = params.get("JobUpdateTime")
        self._CurrentTaskId = params.get("CurrentTaskId")
        self._JobStatus = params.get("JobStatus")
        if params.get("StreamingStat") is not None:
            self._StreamingStat = StreamingStatistics()
            self._StreamingStat._deserialize(params.get("StreamingStat"))
        self._DataSource = params.get("DataSource")
        self._IsLocalPythonFiles = params.get("IsLocalPythonFiles")
        self._AppPythonFiles = params.get("AppPythonFiles")
        self._IsLocalArchives = params.get("IsLocalArchives")
        self._JobArchives = params.get("JobArchives")
        self._SparkImage = params.get("SparkImage")
        self._JobPythonFiles = params.get("JobPythonFiles")
        self._TaskNum = params.get("TaskNum")
        self._DataEngineStatus = params.get("DataEngineStatus")
        self._JobExecutorMaxNumbers = params.get("JobExecutorMaxNumbers")
        self._SparkImageVersion = params.get("SparkImageVersion")
        self._SessionId = params.get("SessionId")
        self._DataEngineClusterType = params.get("DataEngineClusterType")
        self._DataEngineImageVersion = params.get("DataEngineImageVersion")
        self._IsInherit = params.get("IsInherit")
        self._IsSessionStarted = params.get("IsSessionStarted")
        self._EngineTypeDetail = params.get("EngineTypeDetail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SparkMonitorMetrics(AbstractModel):
    r"""Spark monitoring metrics

    """

    def __init__(self):
        r"""
        :param _ShuffleWriteBytesCos: Note: This field may return null, indicating that no valid values can be obtained.
        :type ShuffleWriteBytesCos: int
        :param _ShuffleWriteBytesTotal: Note: This field may return null, indicating that no valid values can be obtained.
        :type ShuffleWriteBytesTotal: int
        """
        self._ShuffleWriteBytesCos = None
        self._ShuffleWriteBytesTotal = None

    @property
    def ShuffleWriteBytesCos(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShuffleWriteBytesCos

    @ShuffleWriteBytesCos.setter
    def ShuffleWriteBytesCos(self, ShuffleWriteBytesCos):
        self._ShuffleWriteBytesCos = ShuffleWriteBytesCos

    @property
    def ShuffleWriteBytesTotal(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ShuffleWriteBytesTotal

    @ShuffleWriteBytesTotal.setter
    def ShuffleWriteBytesTotal(self, ShuffleWriteBytesTotal):
        self._ShuffleWriteBytesTotal = ShuffleWriteBytesTotal


    def _deserialize(self, params):
        self._ShuffleWriteBytesCos = params.get("ShuffleWriteBytesCos")
        self._ShuffleWriteBytesTotal = params.get("ShuffleWriteBytesTotal")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SparkSessionBatchLog(AbstractModel):
    r"""Running logs of a Spark SQL batch job

    """

    def __init__(self):
        r"""
        :param _Step: The log step. Valid values: `BEG`, `CS`, `DS`, `DSS`, `DSF`, `FINF`, `RTO`, `CANCEL`, `CT`, `DT`, `DTS`, `DTF`, `FINT`, and `EXCE`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Step: str
        :param _Time: Time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Time: str
        :param _Message: The log message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Operate: The operation.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Operate: list of SparkSessionBatchLogOperate
        """
        self._Step = None
        self._Time = None
        self._Message = None
        self._Operate = None

    @property
    def Step(self):
        r"""The log step. Valid values: `BEG`, `CS`, `DS`, `DSS`, `DSF`, `FINF`, `RTO`, `CANCEL`, `CT`, `DT`, `DTS`, `DTF`, `FINT`, and `EXCE`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Step

    @Step.setter
    def Step(self, Step):
        self._Step = Step

    @property
    def Time(self):
        r"""Time.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Message(self):
        r"""The log message.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Operate(self):
        r"""The operation.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of SparkSessionBatchLogOperate
        """
        return self._Operate

    @Operate.setter
    def Operate(self, Operate):
        self._Operate = Operate


    def _deserialize(self, params):
        self._Step = params.get("Step")
        self._Time = params.get("Time")
        self._Message = params.get("Message")
        if params.get("Operate") is not None:
            self._Operate = []
            for item in params.get("Operate"):
                obj = SparkSessionBatchLogOperate()
                obj._deserialize(item)
                self._Operate.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SparkSessionBatchLogOperate(AbstractModel):
    r"""Operation information in the logs of a Spark SQL batch job

    """

    def __init__(self):
        r"""
        :param _Text: The operation message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Text: str
        :param _Operate: The operation type. Valid values: `COPY`, `LOG`, `UI`, `RESULT`, `List`, and `TAB`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Operate: str
        :param _Supplement: Additional information, such as taskid, sessionid, and sparkui.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Supplement: list of KVPair
        """
        self._Text = None
        self._Operate = None
        self._Supplement = None

    @property
    def Text(self):
        r"""The operation message.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Operate(self):
        r"""The operation type. Valid values: `COPY`, `LOG`, `UI`, `RESULT`, `List`, and `TAB`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Operate

    @Operate.setter
    def Operate(self, Operate):
        self._Operate = Operate

    @property
    def Supplement(self):
        r"""Additional information, such as taskid, sessionid, and sparkui.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of KVPair
        """
        return self._Supplement

    @Supplement.setter
    def Supplement(self, Supplement):
        self._Supplement = Supplement


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._Operate = params.get("Operate")
        if params.get("Supplement") is not None:
            self._Supplement = []
            for item in params.get("Supplement"):
                obj = KVPair()
                obj._deserialize(item)
                self._Supplement.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StatementInformation(AbstractModel):
    r"""Statement information

    """

    def __init__(self):
        r"""
        :param _TaskId: Unique ID of the SQL task
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _SQL: SQL content
Note: This field may return null, indicating that no valid values can be obtained.
        :type SQL: str
        """
        self._TaskId = None
        self._SQL = None

    @property
    def TaskId(self):
        r"""Unique ID of the SQL task
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SQL(self):
        r"""SQL content
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SQL = params.get("SQL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StatisticInfo(AbstractModel):
    r"""Task statistics information.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _TotalProcessedBytes: Amount of data scanned
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalProcessedBytes: int
        :param _UsedTime: Calculation time: ms
Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedTime: int
        :param _CreateTime: Creation Time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _EndTime: Task end time
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: int
        :param _StartTime: Task start time
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: int
        :param _RowsAffect: Number of rows affected
Note: This field may return null, indicating that no valid values can be obtained.
        :type RowsAffect: int
        :param _TotalTime: Task duration
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalTime: int
        """
        self._TaskId = None
        self._TotalProcessedBytes = None
        self._UsedTime = None
        self._CreateTime = None
        self._EndTime = None
        self._StartTime = None
        self._RowsAffect = None
        self._TotalTime = None

    @property
    def TaskId(self):
        r"""Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TotalProcessedBytes(self):
        r"""Amount of data scanned
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalProcessedBytes

    @TotalProcessedBytes.setter
    def TotalProcessedBytes(self, TotalProcessedBytes):
        self._TotalProcessedBytes = TotalProcessedBytes

    @property
    def UsedTime(self):
        r"""Calculation time: ms
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._UsedTime

    @UsedTime.setter
    def UsedTime(self, UsedTime):
        self._UsedTime = UsedTime

    @property
    def CreateTime(self):
        r"""Creation Time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def EndTime(self):
        r"""Task end time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        r"""Task start time
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RowsAffect(self):
        r"""Number of rows affected
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RowsAffect

    @RowsAffect.setter
    def RowsAffect(self, RowsAffect):
        self._RowsAffect = RowsAffect

    @property
    def TotalTime(self):
        r"""Task duration
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalTime

    @TotalTime.setter
    def TotalTime(self, TotalTime):
        self._TotalTime = TotalTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TotalProcessedBytes = params.get("TotalProcessedBytes")
        self._UsedTime = params.get("UsedTime")
        self._CreateTime = params.get("CreateTime")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._RowsAffect = params.get("RowsAffect")
        self._TotalTime = params.get("TotalTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StreamingStatistics(AbstractModel):
    r"""Statistics of the Spark flow task

    """

    def __init__(self):
        r"""
        :param _StartTime: Task start time
        :type StartTime: str
        :param _Receivers: Number of data receivers
        :type Receivers: int
        :param _NumActiveReceivers: Number of receivers in service
        :type NumActiveReceivers: int
        :param _NumInactiveReceivers: Number of inactive receivers
        :type NumInactiveReceivers: int
        :param _NumActiveBatches: Number of running batches
        :type NumActiveBatches: int
        :param _NumRetainedCompletedBatches: Number of batches to be processed
        :type NumRetainedCompletedBatches: int
        :param _NumTotalCompletedBatches: Number of completed batches
        :type NumTotalCompletedBatches: int
        :param _AverageInputRate: Average input speed
        :type AverageInputRate: float
        :param _AverageSchedulingDelay: Average queue time
        :type AverageSchedulingDelay: float
        :param _AverageProcessingTime: Average processing time
        :type AverageProcessingTime: float
        :param _AverageTotalDelay: Average latency
        :type AverageTotalDelay: float
        """
        self._StartTime = None
        self._Receivers = None
        self._NumActiveReceivers = None
        self._NumInactiveReceivers = None
        self._NumActiveBatches = None
        self._NumRetainedCompletedBatches = None
        self._NumTotalCompletedBatches = None
        self._AverageInputRate = None
        self._AverageSchedulingDelay = None
        self._AverageProcessingTime = None
        self._AverageTotalDelay = None

    @property
    def StartTime(self):
        r"""Task start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Receivers(self):
        r"""Number of data receivers
        :rtype: int
        """
        return self._Receivers

    @Receivers.setter
    def Receivers(self, Receivers):
        self._Receivers = Receivers

    @property
    def NumActiveReceivers(self):
        r"""Number of receivers in service
        :rtype: int
        """
        return self._NumActiveReceivers

    @NumActiveReceivers.setter
    def NumActiveReceivers(self, NumActiveReceivers):
        self._NumActiveReceivers = NumActiveReceivers

    @property
    def NumInactiveReceivers(self):
        r"""Number of inactive receivers
        :rtype: int
        """
        return self._NumInactiveReceivers

    @NumInactiveReceivers.setter
    def NumInactiveReceivers(self, NumInactiveReceivers):
        self._NumInactiveReceivers = NumInactiveReceivers

    @property
    def NumActiveBatches(self):
        r"""Number of running batches
        :rtype: int
        """
        return self._NumActiveBatches

    @NumActiveBatches.setter
    def NumActiveBatches(self, NumActiveBatches):
        self._NumActiveBatches = NumActiveBatches

    @property
    def NumRetainedCompletedBatches(self):
        r"""Number of batches to be processed
        :rtype: int
        """
        return self._NumRetainedCompletedBatches

    @NumRetainedCompletedBatches.setter
    def NumRetainedCompletedBatches(self, NumRetainedCompletedBatches):
        self._NumRetainedCompletedBatches = NumRetainedCompletedBatches

    @property
    def NumTotalCompletedBatches(self):
        r"""Number of completed batches
        :rtype: int
        """
        return self._NumTotalCompletedBatches

    @NumTotalCompletedBatches.setter
    def NumTotalCompletedBatches(self, NumTotalCompletedBatches):
        self._NumTotalCompletedBatches = NumTotalCompletedBatches

    @property
    def AverageInputRate(self):
        r"""Average input speed
        :rtype: float
        """
        return self._AverageInputRate

    @AverageInputRate.setter
    def AverageInputRate(self, AverageInputRate):
        self._AverageInputRate = AverageInputRate

    @property
    def AverageSchedulingDelay(self):
        r"""Average queue time
        :rtype: float
        """
        return self._AverageSchedulingDelay

    @AverageSchedulingDelay.setter
    def AverageSchedulingDelay(self, AverageSchedulingDelay):
        self._AverageSchedulingDelay = AverageSchedulingDelay

    @property
    def AverageProcessingTime(self):
        r"""Average processing time
        :rtype: float
        """
        return self._AverageProcessingTime

    @AverageProcessingTime.setter
    def AverageProcessingTime(self, AverageProcessingTime):
        self._AverageProcessingTime = AverageProcessingTime

    @property
    def AverageTotalDelay(self):
        r"""Average latency
        :rtype: float
        """
        return self._AverageTotalDelay

    @AverageTotalDelay.setter
    def AverageTotalDelay(self, AverageTotalDelay):
        self._AverageTotalDelay = AverageTotalDelay


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._Receivers = params.get("Receivers")
        self._NumActiveReceivers = params.get("NumActiveReceivers")
        self._NumInactiveReceivers = params.get("NumInactiveReceivers")
        self._NumActiveBatches = params.get("NumActiveBatches")
        self._NumRetainedCompletedBatches = params.get("NumRetainedCompletedBatches")
        self._NumTotalCompletedBatches = params.get("NumTotalCompletedBatches")
        self._AverageInputRate = params.get("AverageInputRate")
        self._AverageSchedulingDelay = params.get("AverageSchedulingDelay")
        self._AverageProcessingTime = params.get("AverageProcessingTime")
        self._AverageTotalDelay = params.get("AverageTotalDelay")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SuspendResumeDataEngineRequest(AbstractModel):
    r"""SuspendResumeDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: The name of a virtual cluster.
        :type DataEngineName: str
        :param _Operate: The operation type: `suspend` or `resume`.
        :type Operate: str
        """
        self._DataEngineName = None
        self._Operate = None

    @property
    def DataEngineName(self):
        r"""The name of a virtual cluster.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Operate(self):
        r"""The operation type: `suspend` or `resume`.
        :rtype: str
        """
        return self._Operate

    @Operate.setter
    def Operate(self, Operate):
        self._Operate = Operate


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._Operate = params.get("Operate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SuspendResumeDataEngineResponse(AbstractModel):
    r"""SuspendResumeDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: The details of the virtual cluster.
        :type DataEngineName: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataEngineName = None
        self._RequestId = None

    @property
    def DataEngineName(self):
        r"""The details of the virtual cluster.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._RequestId = params.get("RequestId")


class SwitchDataEngineImageRequest(AbstractModel):
    r"""SwitchDataEngineImage request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        :param _NewImageVersionId: New image version ID
        :type NewImageVersionId: str
        """
        self._DataEngineId = None
        self._NewImageVersionId = None

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def NewImageVersionId(self):
        r"""New image version ID
        :rtype: str
        """
        return self._NewImageVersionId

    @NewImageVersionId.setter
    def NewImageVersionId(self, NewImageVersionId):
        self._NewImageVersionId = NewImageVersionId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        self._NewImageVersionId = params.get("NewImageVersionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchDataEngineImageResponse(AbstractModel):
    r"""SwitchDataEngineImage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SwitchDataEngineRequest(AbstractModel):
    r"""SwitchDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineName: The name of the primary cluster.
        :type DataEngineName: str
        :param _StartStandbyCluster: Whether to start the standby cluster.
        :type StartStandbyCluster: bool
        """
        self._DataEngineName = None
        self._StartStandbyCluster = None

    @property
    def DataEngineName(self):
        r"""The name of the primary cluster.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def StartStandbyCluster(self):
        r"""Whether to start the standby cluster.
        :rtype: bool
        """
        return self._StartStandbyCluster

    @StartStandbyCluster.setter
    def StartStandbyCluster(self, StartStandbyCluster):
        self._StartStandbyCluster = StartStandbyCluster


    def _deserialize(self, params):
        self._DataEngineName = params.get("DataEngineName")
        self._StartStandbyCluster = params.get("StartStandbyCluster")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchDataEngineResponse(AbstractModel):
    r"""SwitchDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class TColumn(AbstractModel):
    r"""Table field information

    """

    def __init__(self):
        r"""
        :param _Name: Field name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Type: Field type
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Comment: Field description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Comment: str
        :param _Default: Field default values
Note: This field may return null, indicating that no valid values can be obtained.
        :type Default: str
        :param _NotNull: Is the field non-empty?
Note: This field may return null, indicating that no valid values can be obtained.
        :type NotNull: bool
        :param _Precision: Indicate the length of the entire numeric with a value of 1-38
Note: This field may return null, indicating that no valid values can be obtained.
        :type Precision: int
        :param _Scale: Indicates the length of the decimal part.
Scale is smaller than Precision.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Scale: int
        :param _Position: Field position: Fields with smaller values need to be placed first.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Position: int
        :param _IsPartition: Whether it is a partition field
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsPartition: bool
        """
        self._Name = None
        self._Type = None
        self._Comment = None
        self._Default = None
        self._NotNull = None
        self._Precision = None
        self._Scale = None
        self._Position = None
        self._IsPartition = None

    @property
    def Name(self):
        r"""Field name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""Field type
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        r"""Field description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Default(self):
        r"""Field default values
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default

    @property
    def NotNull(self):
        r"""Is the field non-empty?
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._NotNull

    @NotNull.setter
    def NotNull(self, NotNull):
        self._NotNull = NotNull

    @property
    def Precision(self):
        r"""Indicate the length of the entire numeric with a value of 1-38
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Precision

    @Precision.setter
    def Precision(self, Precision):
        self._Precision = Precision

    @property
    def Scale(self):
        r"""Indicates the length of the decimal part.
Scale is smaller than Precision.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Scale

    @Scale.setter
    def Scale(self, Scale):
        self._Scale = Scale

    @property
    def Position(self):
        r"""Field position: Fields with smaller values need to be placed first.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def IsPartition(self):
        r"""Whether it is a partition field
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._Default = params.get("Default")
        self._NotNull = params.get("NotNull")
        self._Precision = params.get("Precision")
        self._Scale = params.get("Scale")
        self._Position = params.get("Position")
        self._IsPartition = params.get("IsPartition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TPartition(AbstractModel):
    r"""Table partition information

    """

    def __init__(self):
        r"""
        :param _Name: The field name.
        :type Name: str
        :param _Type: The field type.
        :type Type: str
        :param _Comment: The field description.
        :type Comment: str
        :param _PartitionType: The partition type.
        :type PartitionType: str
        :param _PartitionFormat: The partition format.
        :type PartitionFormat: str
        :param _PartitionDot: The separator count of the partition conversion policy.
        :type PartitionDot: int
        :param _Transform: The partition conversion policy.
        :type Transform: str
        :param _TransformArgs: The policy parameters.
        :type TransformArgs: list of str
        """
        self._Name = None
        self._Type = None
        self._Comment = None
        self._PartitionType = None
        self._PartitionFormat = None
        self._PartitionDot = None
        self._Transform = None
        self._TransformArgs = None

    @property
    def Name(self):
        r"""The field name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""The field type.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        r"""The field description.
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PartitionType(self):
        r"""The partition type.
        :rtype: str
        """
        return self._PartitionType

    @PartitionType.setter
    def PartitionType(self, PartitionType):
        self._PartitionType = PartitionType

    @property
    def PartitionFormat(self):
        r"""The partition format.
        :rtype: str
        """
        return self._PartitionFormat

    @PartitionFormat.setter
    def PartitionFormat(self, PartitionFormat):
        self._PartitionFormat = PartitionFormat

    @property
    def PartitionDot(self):
        r"""The separator count of the partition conversion policy.
        :rtype: int
        """
        return self._PartitionDot

    @PartitionDot.setter
    def PartitionDot(self, PartitionDot):
        self._PartitionDot = PartitionDot

    @property
    def Transform(self):
        r"""The partition conversion policy.
        :rtype: str
        """
        return self._Transform

    @Transform.setter
    def Transform(self, Transform):
        self._Transform = Transform

    @property
    def TransformArgs(self):
        r"""The policy parameters.
        :rtype: list of str
        """
        return self._TransformArgs

    @TransformArgs.setter
    def TransformArgs(self, TransformArgs):
        self._TransformArgs = TransformArgs


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._PartitionType = params.get("PartitionType")
        self._PartitionFormat = params.get("PartitionFormat")
        self._PartitionDot = params.get("PartitionDot")
        self._Transform = params.get("Transform")
        self._TransformArgs = params.get("TransformArgs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TableBaseInfo(AbstractModel):
    r"""Table configurations

    """

    def __init__(self):
        r"""
        :param _DatabaseName: The database name.
        :type DatabaseName: str
        :param _TableName: The table name.
        :type TableName: str
        :param _DatasourceConnectionName: The data source name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionName: str
        :param _TableComment: The table remarks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TableComment: str
        :param _Type: The specific type: `table` or `view`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _TableFormat: The data format type, such as `hive` and `iceberg`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TableFormat: str
        :param _UserAlias: The table creator name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAlias: str
        :param _UserSubUin: The table creator ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserSubUin: str
        :param _GovernPolicy: The data governance configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GovernPolicy: :class:`tencentcloud.dlc.v20210125.models.DataGovernPolicy`
        :param _DbGovernPolicyIsDisable: Whether database data governance is disabled. Valid values: `true` (disabled) and `false` (not disabled).
Note: This field may return null, indicating that no valid values can be obtained.
        :type DbGovernPolicyIsDisable: str
        :param _SmartPolicy: Smart data governance configuration items
Note: This field may return null, indicating that no valid values can be obtained.
        :type SmartPolicy: :class:`tencentcloud.dlc.v20210125.models.SmartPolicy`
        """
        self._DatabaseName = None
        self._TableName = None
        self._DatasourceConnectionName = None
        self._TableComment = None
        self._Type = None
        self._TableFormat = None
        self._UserAlias = None
        self._UserSubUin = None
        self._GovernPolicy = None
        self._DbGovernPolicyIsDisable = None
        self._SmartPolicy = None

    @property
    def DatabaseName(self):
        r"""The database name.
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def TableName(self):
        r"""The table name.
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def DatasourceConnectionName(self):
        r"""The data source name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def TableComment(self):
        r"""The table remarks.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TableComment

    @TableComment.setter
    def TableComment(self, TableComment):
        self._TableComment = TableComment

    @property
    def Type(self):
        r"""The specific type: `table` or `view`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TableFormat(self):
        r"""The data format type, such as `hive` and `iceberg`.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TableFormat

    @TableFormat.setter
    def TableFormat(self, TableFormat):
        self._TableFormat = TableFormat

    @property
    def UserAlias(self):
        r"""The table creator name.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def UserSubUin(self):
        r"""The table creator ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserSubUin

    @UserSubUin.setter
    def UserSubUin(self, UserSubUin):
        self._UserSubUin = UserSubUin

    @property
    def GovernPolicy(self):
        warnings.warn("parameter `GovernPolicy` is deprecated", DeprecationWarning) 

        r"""The data governance configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataGovernPolicy`
        """
        return self._GovernPolicy

    @GovernPolicy.setter
    def GovernPolicy(self, GovernPolicy):
        warnings.warn("parameter `GovernPolicy` is deprecated", DeprecationWarning) 

        self._GovernPolicy = GovernPolicy

    @property
    def DbGovernPolicyIsDisable(self):
        warnings.warn("parameter `DbGovernPolicyIsDisable` is deprecated", DeprecationWarning) 

        r"""Whether database data governance is disabled. Valid values: `true` (disabled) and `false` (not disabled).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DbGovernPolicyIsDisable

    @DbGovernPolicyIsDisable.setter
    def DbGovernPolicyIsDisable(self, DbGovernPolicyIsDisable):
        warnings.warn("parameter `DbGovernPolicyIsDisable` is deprecated", DeprecationWarning) 

        self._DbGovernPolicyIsDisable = DbGovernPolicyIsDisable

    @property
    def SmartPolicy(self):
        r"""Smart data governance configuration items
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SmartPolicy`
        """
        return self._SmartPolicy

    @SmartPolicy.setter
    def SmartPolicy(self, SmartPolicy):
        self._SmartPolicy = SmartPolicy


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._TableName = params.get("TableName")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._TableComment = params.get("TableComment")
        self._Type = params.get("Type")
        self._TableFormat = params.get("TableFormat")
        self._UserAlias = params.get("UserAlias")
        self._UserSubUin = params.get("UserSubUin")
        if params.get("GovernPolicy") is not None:
            self._GovernPolicy = DataGovernPolicy()
            self._GovernPolicy._deserialize(params.get("GovernPolicy"))
        self._DbGovernPolicyIsDisable = params.get("DbGovernPolicyIsDisable")
        if params.get("SmartPolicy") is not None:
            self._SmartPolicy = SmartPolicy()
            self._SmartPolicy._deserialize(params.get("SmartPolicy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TagInfo(AbstractModel):
    r"""Tag pair info

    """

    def __init__(self):
        r"""
        :param _TagKey: The tag key.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TagKey: str
        :param _TagValue: The tag value.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        r"""The tag key.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        r"""The tag value.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Task(AbstractModel):
    r"""Task type, such as SQL query.

    """

    def __init__(self):
        r"""
        :param _SQLTask: SQL query task
        :type SQLTask: :class:`tencentcloud.dlc.v20210125.models.SQLTask`
        :param _SparkSQLTask: Spark SQL query task
        :type SparkSQLTask: :class:`tencentcloud.dlc.v20210125.models.SQLTask`
        """
        self._SQLTask = None
        self._SparkSQLTask = None

    @property
    def SQLTask(self):
        r"""SQL query task
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SQLTask`
        """
        return self._SQLTask

    @SQLTask.setter
    def SQLTask(self, SQLTask):
        self._SQLTask = SQLTask

    @property
    def SparkSQLTask(self):
        r"""Spark SQL query task
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SQLTask`
        """
        return self._SparkSQLTask

    @SparkSQLTask.setter
    def SparkSQLTask(self, SparkSQLTask):
        self._SparkSQLTask = SparkSQLTask


    def _deserialize(self, params):
        if params.get("SQLTask") is not None:
            self._SQLTask = SQLTask()
            self._SQLTask._deserialize(params.get("SQLTask"))
        if params.get("SparkSQLTask") is not None:
            self._SparkSQLTask = SQLTask()
            self._SparkSQLTask._deserialize(params.get("SparkSQLTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskResponseInfo(AbstractModel):
    r"""The task instance.

    """

    def __init__(self):
        r"""
        :param _DatabaseName: Database name of the task
        :type DatabaseName: str
        :param _DataAmount: Data volume of the task
        :type DataAmount: int
        :param _Id: Task ID
        :type Id: str
        :param _UsedTime: The compute time in ms.
        :type UsedTime: int
        :param _OutputPath: Task output path
        :type OutputPath: str
        :param _CreateTime: Task creation time
        :type CreateTime: str
        :param _State: The task status. Valid values: `0` (initializing), `1` (executing), `2` (executed), `3` (writing data), `4` (queuing), `-1` (failed), and `-3` (canceled).
        :type State: int
        :param _SQLType: SQL statement type of the task, such as DDL and DML.
        :type SQLType: str
        :param _SQL: SQL statement of the task
        :type SQL: str
        :param _ResultExpired: Whether the result has expired
        :type ResultExpired: bool
        :param _RowAffectInfo: Number of affected data rows
        :type RowAffectInfo: str
        :param _DataSet: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataSet: str
        :param _Error: Failure information, such as `errorMessage`. This field has been disused.
        :type Error: str
        :param _Percentage: Task progress (%)
        :type Percentage: int
        :param _OutputMessage: Output information of task execution
        :type OutputMessage: str
        :param _TaskType: Type of the engine executing the SQL statement
        :type TaskType: str
        :param _ProgressDetail: Note: This field may return null, indicating that no valid values can be obtained.
        :type ProgressDetail: str
        :param _UpdateTime: Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _DataEngineId: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineId: str
        :param _OperateUin: Note: This field may return null, indicating that no valid values can be obtained.
        :type OperateUin: str
        :param _DataEngineName: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataEngineName: str
        :param _InputType: Note: This field may return null, indicating that no valid values can be obtained.
        :type InputType: str
        :param _InputConf: Note: This field may return null, indicating that no valid values can be obtained.
        :type InputConf: str
        :param _DataNumber: Note: This field may return null, indicating that no valid values can be obtained.
        :type DataNumber: int
        :param _CanDownload: Note: This field may return null, indicating that no valid values can be obtained.
        :type CanDownload: bool
        :param _UserAlias: Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAlias: str
        :param _SparkJobName: Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkJobName: str
        :param _SparkJobId: Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkJobId: str
        :param _SparkJobFile: Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkJobFile: str
        :param _UiUrl: Note: This field may return null, indicating that no valid values can be obtained.
        :type UiUrl: str
        :param _TotalTime: Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalTime: int
        :param _CmdArgs: Note: This field may return null, indicating that no valid values can be obtained.
        :type CmdArgs: str
        :param _ImageVersion: Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageVersion: str
        :param _DriverSize: Note: This field may return null, indicating that no valid values can be obtained.
        :type DriverSize: str
        :param _ExecutorSize: Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutorSize: str
        :param _ExecutorNums: Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutorNums: int
        :param _ExecutorMaxNumbers: Note: This field may return null, indicating that no valid values can be obtained.
        :type ExecutorMaxNumbers: int
        :param _CommonMetrics: Note: This field may return null, indicating that no valid values can be obtained.
        :type CommonMetrics: :class:`tencentcloud.dlc.v20210125.models.CommonMetrics`
        :param _SparkMonitorMetrics: Note: This field may return null, indicating that no valid values can be obtained.
        :type SparkMonitorMetrics: :class:`tencentcloud.dlc.v20210125.models.SparkMonitorMetrics`
        :param _PrestoMonitorMetrics: Note: This field may return null, indicating that no valid values can be obtained.
        :type PrestoMonitorMetrics: :class:`tencentcloud.dlc.v20210125.models.PrestoMonitorMetrics`
        :param _ResultFormat: Note: This field may return null, indicating that no valid values can be obtained.
        :type ResultFormat: str
        :param _EngineTypeDetail: Note: This field may return null, indicating that no valid values can be obtained.
        :type EngineTypeDetail: str
        :param _ResourceGroupName: Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceGroupName: str
        """
        self._DatabaseName = None
        self._DataAmount = None
        self._Id = None
        self._UsedTime = None
        self._OutputPath = None
        self._CreateTime = None
        self._State = None
        self._SQLType = None
        self._SQL = None
        self._ResultExpired = None
        self._RowAffectInfo = None
        self._DataSet = None
        self._Error = None
        self._Percentage = None
        self._OutputMessage = None
        self._TaskType = None
        self._ProgressDetail = None
        self._UpdateTime = None
        self._DataEngineId = None
        self._OperateUin = None
        self._DataEngineName = None
        self._InputType = None
        self._InputConf = None
        self._DataNumber = None
        self._CanDownload = None
        self._UserAlias = None
        self._SparkJobName = None
        self._SparkJobId = None
        self._SparkJobFile = None
        self._UiUrl = None
        self._TotalTime = None
        self._CmdArgs = None
        self._ImageVersion = None
        self._DriverSize = None
        self._ExecutorSize = None
        self._ExecutorNums = None
        self._ExecutorMaxNumbers = None
        self._CommonMetrics = None
        self._SparkMonitorMetrics = None
        self._PrestoMonitorMetrics = None
        self._ResultFormat = None
        self._EngineTypeDetail = None
        self._ResourceGroupName = None

    @property
    def DatabaseName(self):
        r"""Database name of the task
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DataAmount(self):
        r"""Data volume of the task
        :rtype: int
        """
        return self._DataAmount

    @DataAmount.setter
    def DataAmount(self, DataAmount):
        self._DataAmount = DataAmount

    @property
    def Id(self):
        r"""Task ID
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def UsedTime(self):
        r"""The compute time in ms.
        :rtype: int
        """
        return self._UsedTime

    @UsedTime.setter
    def UsedTime(self, UsedTime):
        self._UsedTime = UsedTime

    @property
    def OutputPath(self):
        r"""Task output path
        :rtype: str
        """
        return self._OutputPath

    @OutputPath.setter
    def OutputPath(self, OutputPath):
        self._OutputPath = OutputPath

    @property
    def CreateTime(self):
        r"""Task creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def State(self):
        r"""The task status. Valid values: `0` (initializing), `1` (executing), `2` (executed), `3` (writing data), `4` (queuing), `-1` (failed), and `-3` (canceled).
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def SQLType(self):
        r"""SQL statement type of the task, such as DDL and DML.
        :rtype: str
        """
        return self._SQLType

    @SQLType.setter
    def SQLType(self, SQLType):
        self._SQLType = SQLType

    @property
    def SQL(self):
        r"""SQL statement of the task
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def ResultExpired(self):
        r"""Whether the result has expired
        :rtype: bool
        """
        return self._ResultExpired

    @ResultExpired.setter
    def ResultExpired(self, ResultExpired):
        self._ResultExpired = ResultExpired

    @property
    def RowAffectInfo(self):
        r"""Number of affected data rows
        :rtype: str
        """
        return self._RowAffectInfo

    @RowAffectInfo.setter
    def RowAffectInfo(self, RowAffectInfo):
        self._RowAffectInfo = RowAffectInfo

    @property
    def DataSet(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataSet

    @DataSet.setter
    def DataSet(self, DataSet):
        self._DataSet = DataSet

    @property
    def Error(self):
        r"""Failure information, such as `errorMessage`. This field has been disused.
        :rtype: str
        """
        return self._Error

    @Error.setter
    def Error(self, Error):
        self._Error = Error

    @property
    def Percentage(self):
        r"""Task progress (%)
        :rtype: int
        """
        return self._Percentage

    @Percentage.setter
    def Percentage(self, Percentage):
        self._Percentage = Percentage

    @property
    def OutputMessage(self):
        r"""Output information of task execution
        :rtype: str
        """
        return self._OutputMessage

    @OutputMessage.setter
    def OutputMessage(self, OutputMessage):
        self._OutputMessage = OutputMessage

    @property
    def TaskType(self):
        r"""Type of the engine executing the SQL statement
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProgressDetail(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ProgressDetail

    @ProgressDetail.setter
    def ProgressDetail(self, ProgressDetail):
        self._ProgressDetail = ProgressDetail

    @property
    def UpdateTime(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def DataEngineId(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def OperateUin(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._OperateUin

    @OperateUin.setter
    def OperateUin(self, OperateUin):
        self._OperateUin = OperateUin

    @property
    def DataEngineName(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def InputType(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def InputConf(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._InputConf

    @InputConf.setter
    def InputConf(self, InputConf):
        self._InputConf = InputConf

    @property
    def DataNumber(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._DataNumber

    @DataNumber.setter
    def DataNumber(self, DataNumber):
        self._DataNumber = DataNumber

    @property
    def CanDownload(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._CanDownload

    @CanDownload.setter
    def CanDownload(self, CanDownload):
        self._CanDownload = CanDownload

    @property
    def UserAlias(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def SparkJobName(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkJobName

    @SparkJobName.setter
    def SparkJobName(self, SparkJobName):
        self._SparkJobName = SparkJobName

    @property
    def SparkJobId(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkJobId

    @SparkJobId.setter
    def SparkJobId(self, SparkJobId):
        self._SparkJobId = SparkJobId

    @property
    def SparkJobFile(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._SparkJobFile

    @SparkJobFile.setter
    def SparkJobFile(self, SparkJobFile):
        self._SparkJobFile = SparkJobFile

    @property
    def UiUrl(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UiUrl

    @UiUrl.setter
    def UiUrl(self, UiUrl):
        self._UiUrl = UiUrl

    @property
    def TotalTime(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalTime

    @TotalTime.setter
    def TotalTime(self, TotalTime):
        self._TotalTime = TotalTime

    @property
    def CmdArgs(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CmdArgs

    @CmdArgs.setter
    def CmdArgs(self, CmdArgs):
        self._CmdArgs = CmdArgs

    @property
    def ImageVersion(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ImageVersion

    @ImageVersion.setter
    def ImageVersion(self, ImageVersion):
        self._ImageVersion = ImageVersion

    @property
    def DriverSize(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DriverSize

    @DriverSize.setter
    def DriverSize(self, DriverSize):
        self._DriverSize = DriverSize

    @property
    def ExecutorSize(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ExecutorSize

    @ExecutorSize.setter
    def ExecutorSize(self, ExecutorSize):
        self._ExecutorSize = ExecutorSize

    @property
    def ExecutorNums(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExecutorNums

    @ExecutorNums.setter
    def ExecutorNums(self, ExecutorNums):
        self._ExecutorNums = ExecutorNums

    @property
    def ExecutorMaxNumbers(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._ExecutorMaxNumbers

    @ExecutorMaxNumbers.setter
    def ExecutorMaxNumbers(self, ExecutorMaxNumbers):
        self._ExecutorMaxNumbers = ExecutorMaxNumbers

    @property
    def CommonMetrics(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CommonMetrics`
        """
        return self._CommonMetrics

    @CommonMetrics.setter
    def CommonMetrics(self, CommonMetrics):
        self._CommonMetrics = CommonMetrics

    @property
    def SparkMonitorMetrics(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SparkMonitorMetrics`
        """
        return self._SparkMonitorMetrics

    @SparkMonitorMetrics.setter
    def SparkMonitorMetrics(self, SparkMonitorMetrics):
        self._SparkMonitorMetrics = SparkMonitorMetrics

    @property
    def PrestoMonitorMetrics(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.PrestoMonitorMetrics`
        """
        return self._PrestoMonitorMetrics

    @PrestoMonitorMetrics.setter
    def PrestoMonitorMetrics(self, PrestoMonitorMetrics):
        self._PrestoMonitorMetrics = PrestoMonitorMetrics

    @property
    def ResultFormat(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ResultFormat

    @ResultFormat.setter
    def ResultFormat(self, ResultFormat):
        self._ResultFormat = ResultFormat

    @property
    def EngineTypeDetail(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._EngineTypeDetail

    @EngineTypeDetail.setter
    def EngineTypeDetail(self, EngineTypeDetail):
        self._EngineTypeDetail = EngineTypeDetail

    @property
    def ResourceGroupName(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ResourceGroupName

    @ResourceGroupName.setter
    def ResourceGroupName(self, ResourceGroupName):
        self._ResourceGroupName = ResourceGroupName


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._DataAmount = params.get("DataAmount")
        self._Id = params.get("Id")
        self._UsedTime = params.get("UsedTime")
        self._OutputPath = params.get("OutputPath")
        self._CreateTime = params.get("CreateTime")
        self._State = params.get("State")
        self._SQLType = params.get("SQLType")
        self._SQL = params.get("SQL")
        self._ResultExpired = params.get("ResultExpired")
        self._RowAffectInfo = params.get("RowAffectInfo")
        self._DataSet = params.get("DataSet")
        self._Error = params.get("Error")
        self._Percentage = params.get("Percentage")
        self._OutputMessage = params.get("OutputMessage")
        self._TaskType = params.get("TaskType")
        self._ProgressDetail = params.get("ProgressDetail")
        self._UpdateTime = params.get("UpdateTime")
        self._DataEngineId = params.get("DataEngineId")
        self._OperateUin = params.get("OperateUin")
        self._DataEngineName = params.get("DataEngineName")
        self._InputType = params.get("InputType")
        self._InputConf = params.get("InputConf")
        self._DataNumber = params.get("DataNumber")
        self._CanDownload = params.get("CanDownload")
        self._UserAlias = params.get("UserAlias")
        self._SparkJobName = params.get("SparkJobName")
        self._SparkJobId = params.get("SparkJobId")
        self._SparkJobFile = params.get("SparkJobFile")
        self._UiUrl = params.get("UiUrl")
        self._TotalTime = params.get("TotalTime")
        self._CmdArgs = params.get("CmdArgs")
        self._ImageVersion = params.get("ImageVersion")
        self._DriverSize = params.get("DriverSize")
        self._ExecutorSize = params.get("ExecutorSize")
        self._ExecutorNums = params.get("ExecutorNums")
        self._ExecutorMaxNumbers = params.get("ExecutorMaxNumbers")
        if params.get("CommonMetrics") is not None:
            self._CommonMetrics = CommonMetrics()
            self._CommonMetrics._deserialize(params.get("CommonMetrics"))
        if params.get("SparkMonitorMetrics") is not None:
            self._SparkMonitorMetrics = SparkMonitorMetrics()
            self._SparkMonitorMetrics._deserialize(params.get("SparkMonitorMetrics"))
        if params.get("PrestoMonitorMetrics") is not None:
            self._PrestoMonitorMetrics = PrestoMonitorMetrics()
            self._PrestoMonitorMetrics._deserialize(params.get("PrestoMonitorMetrics"))
        self._ResultFormat = params.get("ResultFormat")
        self._EngineTypeDetail = params.get("EngineTypeDetail")
        self._ResourceGroupName = params.get("ResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskResultInfo(AbstractModel):
    r"""The task result information.

    """

    def __init__(self):
        r"""
        :param _TaskId: Unique task ID
        :type TaskId: str
        :param _DatasourceConnectionName: Name of the default selected data source when the current job is executed
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatasourceConnectionName: str
        :param _DatabaseName: Name of the default selected database when the current job is executed
Note: This field may return null, indicating that no valid values can be obtained.
        :type DatabaseName: str
        :param _SQL: The currently executed SQL statement. Each task contains one SQL statement.
        :type SQL: str
        :param _SQLType: Type of the executed task. Valid values: `DDL`, `DML`, `DQL`.
        :type SQLType: str
        :param _State: u200cThe current task status. Valid values: `0` (initializing), `1` (executing), `2` (executed), `3` (writing data), `4` (queuing), u200c`-1` (failed), and `-3` (canceled). Only when the task is successfully executed, a task execution result will be returned.
        :type State: int
        :param _DataAmount: Amount of the data scanned in bytes
        :type DataAmount: int
        :param _UsedTime: The compute time in ms.
        :type UsedTime: int
        :param _OutputPath: Address of the COS bucket for storing the task result
        :type OutputPath: str
        :param _CreateTime: Task creation timestamp
        :type CreateTime: str
        :param _OutputMessage: Task execution information. `success` will be returned if the task succeeds; otherwise, the failure cause will be returned.
        :type OutputMessage: str
        :param _RowAffectInfo: Number of affected rows
        :type RowAffectInfo: str
        :param _ResultSchema: Schema information of the result
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResultSchema: list of Column
        :param _ResultSet: Result information. After it is unescaped, each element of the outer array is a data row.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResultSet: str
        :param _NextToken: Pagination information. If there is no more result data, `nextToken` will be empty.
        :type NextToken: str
        :param _Percentage: Task progress (%)
        :type Percentage: int
        :param _ProgressDetail: Task progress details
        :type ProgressDetail: str
        :param _DisplayFormat: Console display format. Valid values: `table`, `text`.
        :type DisplayFormat: str
        :param _TotalTime: The task time in ms.
        :type TotalTime: int
        :param _QueryResultTime: Time consumed to get results
Note: This field may return null, indicating that no valid values can be obtained.
        :type QueryResultTime: float
        """
        self._TaskId = None
        self._DatasourceConnectionName = None
        self._DatabaseName = None
        self._SQL = None
        self._SQLType = None
        self._State = None
        self._DataAmount = None
        self._UsedTime = None
        self._OutputPath = None
        self._CreateTime = None
        self._OutputMessage = None
        self._RowAffectInfo = None
        self._ResultSchema = None
        self._ResultSet = None
        self._NextToken = None
        self._Percentage = None
        self._ProgressDetail = None
        self._DisplayFormat = None
        self._TotalTime = None
        self._QueryResultTime = None

    @property
    def TaskId(self):
        r"""Unique task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DatasourceConnectionName(self):
        r"""Name of the default selected data source when the current job is executed
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatasourceConnectionName

    @DatasourceConnectionName.setter
    def DatasourceConnectionName(self, DatasourceConnectionName):
        self._DatasourceConnectionName = DatasourceConnectionName

    @property
    def DatabaseName(self):
        r"""Name of the default selected database when the current job is executed
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SQL(self):
        r"""The currently executed SQL statement. Each task contains one SQL statement.
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def SQLType(self):
        r"""Type of the executed task. Valid values: `DDL`, `DML`, `DQL`.
        :rtype: str
        """
        return self._SQLType

    @SQLType.setter
    def SQLType(self, SQLType):
        self._SQLType = SQLType

    @property
    def State(self):
        r"""u200cThe current task status. Valid values: `0` (initializing), `1` (executing), `2` (executed), `3` (writing data), `4` (queuing), u200c`-1` (failed), and `-3` (canceled). Only when the task is successfully executed, a task execution result will be returned.
        :rtype: int
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def DataAmount(self):
        r"""Amount of the data scanned in bytes
        :rtype: int
        """
        return self._DataAmount

    @DataAmount.setter
    def DataAmount(self, DataAmount):
        self._DataAmount = DataAmount

    @property
    def UsedTime(self):
        r"""The compute time in ms.
        :rtype: int
        """
        return self._UsedTime

    @UsedTime.setter
    def UsedTime(self, UsedTime):
        self._UsedTime = UsedTime

    @property
    def OutputPath(self):
        r"""Address of the COS bucket for storing the task result
        :rtype: str
        """
        return self._OutputPath

    @OutputPath.setter
    def OutputPath(self, OutputPath):
        self._OutputPath = OutputPath

    @property
    def CreateTime(self):
        r"""Task creation timestamp
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def OutputMessage(self):
        r"""Task execution information. `success` will be returned if the task succeeds; otherwise, the failure cause will be returned.
        :rtype: str
        """
        return self._OutputMessage

    @OutputMessage.setter
    def OutputMessage(self, OutputMessage):
        self._OutputMessage = OutputMessage

    @property
    def RowAffectInfo(self):
        r"""Number of affected rows
        :rtype: str
        """
        return self._RowAffectInfo

    @RowAffectInfo.setter
    def RowAffectInfo(self, RowAffectInfo):
        self._RowAffectInfo = RowAffectInfo

    @property
    def ResultSchema(self):
        r"""Schema information of the result
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Column
        """
        return self._ResultSchema

    @ResultSchema.setter
    def ResultSchema(self, ResultSchema):
        self._ResultSchema = ResultSchema

    @property
    def ResultSet(self):
        r"""Result information. After it is unescaped, each element of the outer array is a data row.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def NextToken(self):
        r"""Pagination information. If there is no more result data, `nextToken` will be empty.
        :rtype: str
        """
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def Percentage(self):
        r"""Task progress (%)
        :rtype: int
        """
        return self._Percentage

    @Percentage.setter
    def Percentage(self, Percentage):
        self._Percentage = Percentage

    @property
    def ProgressDetail(self):
        r"""Task progress details
        :rtype: str
        """
        return self._ProgressDetail

    @ProgressDetail.setter
    def ProgressDetail(self, ProgressDetail):
        self._ProgressDetail = ProgressDetail

    @property
    def DisplayFormat(self):
        r"""Console display format. Valid values: `table`, `text`.
        :rtype: str
        """
        return self._DisplayFormat

    @DisplayFormat.setter
    def DisplayFormat(self, DisplayFormat):
        self._DisplayFormat = DisplayFormat

    @property
    def TotalTime(self):
        r"""The task time in ms.
        :rtype: int
        """
        return self._TotalTime

    @TotalTime.setter
    def TotalTime(self, TotalTime):
        self._TotalTime = TotalTime

    @property
    def QueryResultTime(self):
        r"""Time consumed to get results
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._QueryResultTime

    @QueryResultTime.setter
    def QueryResultTime(self, QueryResultTime):
        self._QueryResultTime = QueryResultTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DatasourceConnectionName = params.get("DatasourceConnectionName")
        self._DatabaseName = params.get("DatabaseName")
        self._SQL = params.get("SQL")
        self._SQLType = params.get("SQLType")
        self._State = params.get("State")
        self._DataAmount = params.get("DataAmount")
        self._UsedTime = params.get("UsedTime")
        self._OutputPath = params.get("OutputPath")
        self._CreateTime = params.get("CreateTime")
        self._OutputMessage = params.get("OutputMessage")
        self._RowAffectInfo = params.get("RowAffectInfo")
        if params.get("ResultSchema") is not None:
            self._ResultSchema = []
            for item in params.get("ResultSchema"):
                obj = Column()
                obj._deserialize(item)
                self._ResultSchema.append(obj)
        self._ResultSet = params.get("ResultSet")
        self._NextToken = params.get("NextToken")
        self._Percentage = params.get("Percentage")
        self._ProgressDetail = params.get("ProgressDetail")
        self._DisplayFormat = params.get("DisplayFormat")
        self._TotalTime = params.get("TotalTime")
        self._QueryResultTime = params.get("QueryResultTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TasksInfo(AbstractModel):
    r"""Collection of tasks executed sequentially in batches

    """

    def __init__(self):
        r"""
        :param _TaskType: Task type. Valid values: `SQLTask` (SQL query task), `SparkSQLTask` (Spark SQL query task).
        :type TaskType: str
        :param _FailureTolerance: Fault tolerance policy. `Proceed`: continues to execute subsequent tasks after the current task fails or is canceled. `Terminate`: terminates the execution of subsequent tasks after the current task fails or is canceled, and marks all subsequent tasks as canceled.
        :type FailureTolerance: str
        :param _SQL: Base64-encrypted SQL statements separated by ";". Up to 50 tasks can be submitted at a time, and they will be executed strictly in sequence.
        :type SQL: str
        :param _Config: Configuration information of the task. Currently, only `SparkSQLTask` tasks are supported.
        :type Config: list of KVPair
        :param _Params: User-defined parameters of the task
        :type Params: list of KVPair
        """
        self._TaskType = None
        self._FailureTolerance = None
        self._SQL = None
        self._Config = None
        self._Params = None

    @property
    def TaskType(self):
        r"""Task type. Valid values: `SQLTask` (SQL query task), `SparkSQLTask` (Spark SQL query task).
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def FailureTolerance(self):
        r"""Fault tolerance policy. `Proceed`: continues to execute subsequent tasks after the current task fails or is canceled. `Terminate`: terminates the execution of subsequent tasks after the current task fails or is canceled, and marks all subsequent tasks as canceled.
        :rtype: str
        """
        return self._FailureTolerance

    @FailureTolerance.setter
    def FailureTolerance(self, FailureTolerance):
        self._FailureTolerance = FailureTolerance

    @property
    def SQL(self):
        r"""Base64-encrypted SQL statements separated by ";". Up to 50 tasks can be submitted at a time, and they will be executed strictly in sequence.
        :rtype: str
        """
        return self._SQL

    @SQL.setter
    def SQL(self, SQL):
        self._SQL = SQL

    @property
    def Config(self):
        r"""Configuration information of the task. Currently, only `SparkSQLTask` tasks are supported.
        :rtype: list of KVPair
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def Params(self):
        r"""User-defined parameters of the task
        :rtype: list of KVPair
        """
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._FailureTolerance = params.get("FailureTolerance")
        self._SQL = params.get("SQL")
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = KVPair()
                obj._deserialize(item)
                self._Config.append(obj)
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = KVPair()
                obj._deserialize(item)
                self._Params.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TasksOverview(AbstractModel):
    r"""The task overview.

    """

    def __init__(self):
        r"""
        :param _TaskQueuedCount: The number of tasks in queue.
        :type TaskQueuedCount: int
        :param _TaskInitCount: The number of initialized tasks.
        :type TaskInitCount: int
        :param _TaskRunningCount: The number of tasks in progress.
        :type TaskRunningCount: int
        :param _TotalTaskCount: The total number of tasks in this time range.
        :type TotalTaskCount: int
        """
        self._TaskQueuedCount = None
        self._TaskInitCount = None
        self._TaskRunningCount = None
        self._TotalTaskCount = None

    @property
    def TaskQueuedCount(self):
        r"""The number of tasks in queue.
        :rtype: int
        """
        return self._TaskQueuedCount

    @TaskQueuedCount.setter
    def TaskQueuedCount(self, TaskQueuedCount):
        self._TaskQueuedCount = TaskQueuedCount

    @property
    def TaskInitCount(self):
        r"""The number of initialized tasks.
        :rtype: int
        """
        return self._TaskInitCount

    @TaskInitCount.setter
    def TaskInitCount(self, TaskInitCount):
        self._TaskInitCount = TaskInitCount

    @property
    def TaskRunningCount(self):
        r"""The number of tasks in progress.
        :rtype: int
        """
        return self._TaskRunningCount

    @TaskRunningCount.setter
    def TaskRunningCount(self, TaskRunningCount):
        self._TaskRunningCount = TaskRunningCount

    @property
    def TotalTaskCount(self):
        r"""The total number of tasks in this time range.
        :rtype: int
        """
        return self._TotalTaskCount

    @TotalTaskCount.setter
    def TotalTaskCount(self, TotalTaskCount):
        self._TotalTaskCount = TotalTaskCount


    def _deserialize(self, params):
        self._TaskQueuedCount = params.get("TaskQueuedCount")
        self._TaskInitCount = params.get("TaskInitCount")
        self._TaskRunningCount = params.get("TaskRunningCount")
        self._TotalTaskCount = params.get("TotalTaskCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindWorkGroupsFromUserRequest(AbstractModel):
    r"""UnbindWorkGroupsFromUser request structure.

    """

    def __init__(self):
        r"""
        :param _AddInfo: Association between the IDs of unbound working groups and user IDs
        :type AddInfo: :class:`tencentcloud.dlc.v20210125.models.WorkGroupIdSetOfUserId`
        """
        self._AddInfo = None

    @property
    def AddInfo(self):
        r"""Association between the IDs of unbound working groups and user IDs
        :rtype: :class:`tencentcloud.dlc.v20210125.models.WorkGroupIdSetOfUserId`
        """
        return self._AddInfo

    @AddInfo.setter
    def AddInfo(self, AddInfo):
        self._AddInfo = AddInfo


    def _deserialize(self, params):
        if params.get("AddInfo") is not None:
            self._AddInfo = WorkGroupIdSetOfUserId()
            self._AddInfo._deserialize(params.get("AddInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindWorkGroupsFromUserResponse(AbstractModel):
    r"""UnbindWorkGroupsFromUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateDataEngineConfigRequest(AbstractModel):
    r"""UpdateDataEngineConfig request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineIds: Engine ID
        :type DataEngineIds: list of str
        :param _DataEngineConfigCommand: Commands of engine configuration. UpdateSparkSQLLakefsPath (updates the configuration of the native table) and UpdateSparkSQLResultPath (updates the configuration of the result path) are supported.
        :type DataEngineConfigCommand: str
        :param _UseLakeFs: Whether to use lakeFS as result storage
        :type UseLakeFs: bool
        :param _CustomResultPath: User-defined result path
        :type CustomResultPath: str
        """
        self._DataEngineIds = None
        self._DataEngineConfigCommand = None
        self._UseLakeFs = None
        self._CustomResultPath = None

    @property
    def DataEngineIds(self):
        r"""Engine ID
        :rtype: list of str
        """
        return self._DataEngineIds

    @DataEngineIds.setter
    def DataEngineIds(self, DataEngineIds):
        self._DataEngineIds = DataEngineIds

    @property
    def DataEngineConfigCommand(self):
        r"""Commands of engine configuration. UpdateSparkSQLLakefsPath (updates the configuration of the native table) and UpdateSparkSQLResultPath (updates the configuration of the result path) are supported.
        :rtype: str
        """
        return self._DataEngineConfigCommand

    @DataEngineConfigCommand.setter
    def DataEngineConfigCommand(self, DataEngineConfigCommand):
        self._DataEngineConfigCommand = DataEngineConfigCommand

    @property
    def UseLakeFs(self):
        r"""Whether to use lakeFS as result storage
        :rtype: bool
        """
        return self._UseLakeFs

    @UseLakeFs.setter
    def UseLakeFs(self, UseLakeFs):
        self._UseLakeFs = UseLakeFs

    @property
    def CustomResultPath(self):
        r"""User-defined result path
        :rtype: str
        """
        return self._CustomResultPath

    @CustomResultPath.setter
    def CustomResultPath(self, CustomResultPath):
        self._CustomResultPath = CustomResultPath


    def _deserialize(self, params):
        self._DataEngineIds = params.get("DataEngineIds")
        self._DataEngineConfigCommand = params.get("DataEngineConfigCommand")
        self._UseLakeFs = params.get("UseLakeFs")
        self._CustomResultPath = params.get("CustomResultPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateDataEngineConfigResponse(AbstractModel):
    r"""UpdateDataEngineConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateDataEngineRequest(AbstractModel):
    r"""UpdateDataEngine request structure.

    """

    def __init__(self):
        r"""
        :param _Size: Resource size
        :type Size: int
        :param _MinClusters: Minimum CU resource
        :type MinClusters: int
        :param _MaxClusters: Maximum CU resource
        :type MaxClusters: int
        :param _AutoResume: Enable the auto-refresh. True means that it is enabled while false means that it is disabled (by default).
        :type AutoResume: bool
        :param _DataEngineName: Data engine name
        :type DataEngineName: str
        :param _Message: Related information
        :type Message: str
        :param _AutoSuspend: Whether to automatically suspend the cluster. False means no (by default) while true means yes.
        :type AutoSuspend: bool
        :param _CrontabResumeSuspend: Scheduling policy of starting and ending the cluster: 0 (by default) indicates disabling the scheduling policy; 1 indicates enabling the scheduling policy. (Note: The scheduling policy and the automatic suspension policy are mutually exclusive.)
        :type CrontabResumeSuspend: int
        :param _CrontabResumeSuspendStrategy: Scheduling policy for the start and end; the complex type includes start and end time and the cluster suspension policy.
        :type CrontabResumeSuspendStrategy: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        :param _MaxConcurrency: The maximum number of concurrent tasks for a single cluster, which is 5 by default.
        :type MaxConcurrency: int
        :param _TolerableQueueTime: Tolerable queuing time, and it is 0 by default. When the queuing time for tasks exceeds the tolerable time, it may trigger scale-out. If this parameter is 0, it means that scale-out may be triggered immediately once tasks start queuing.
        :type TolerableQueueTime: int
        :param _AutoSuspendTime: Cluster automatic suspension time
        :type AutoSuspendTime: int
        :param _ElasticSwitch: Whether the AS of the spark jar monthly subscription cluster is enabled
        :type ElasticSwitch: bool
        :param _ElasticLimit: Upper limit of the spark jar monthly subscription cluster elastic scaling
        :type ElasticLimit: int
        :param _SessionResourceTemplate: Session resource configuration template of Spark batch job clusters
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        self._Size = None
        self._MinClusters = None
        self._MaxClusters = None
        self._AutoResume = None
        self._DataEngineName = None
        self._Message = None
        self._AutoSuspend = None
        self._CrontabResumeSuspend = None
        self._CrontabResumeSuspendStrategy = None
        self._MaxConcurrency = None
        self._TolerableQueueTime = None
        self._AutoSuspendTime = None
        self._ElasticSwitch = None
        self._ElasticLimit = None
        self._SessionResourceTemplate = None

    @property
    def Size(self):
        r"""Resource size
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def MinClusters(self):
        r"""Minimum CU resource
        :rtype: int
        """
        return self._MinClusters

    @MinClusters.setter
    def MinClusters(self, MinClusters):
        self._MinClusters = MinClusters

    @property
    def MaxClusters(self):
        r"""Maximum CU resource
        :rtype: int
        """
        return self._MaxClusters

    @MaxClusters.setter
    def MaxClusters(self, MaxClusters):
        self._MaxClusters = MaxClusters

    @property
    def AutoResume(self):
        r"""Enable the auto-refresh. True means that it is enabled while false means that it is disabled (by default).
        :rtype: bool
        """
        return self._AutoResume

    @AutoResume.setter
    def AutoResume(self, AutoResume):
        self._AutoResume = AutoResume

    @property
    def DataEngineName(self):
        r"""Data engine name
        :rtype: str
        """
        return self._DataEngineName

    @DataEngineName.setter
    def DataEngineName(self, DataEngineName):
        self._DataEngineName = DataEngineName

    @property
    def Message(self):
        r"""Related information
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def AutoSuspend(self):
        r"""Whether to automatically suspend the cluster. False means no (by default) while true means yes.
        :rtype: bool
        """
        return self._AutoSuspend

    @AutoSuspend.setter
    def AutoSuspend(self, AutoSuspend):
        self._AutoSuspend = AutoSuspend

    @property
    def CrontabResumeSuspend(self):
        r"""Scheduling policy of starting and ending the cluster: 0 (by default) indicates disabling the scheduling policy; 1 indicates enabling the scheduling policy. (Note: The scheduling policy and the automatic suspension policy are mutually exclusive.)
        :rtype: int
        """
        return self._CrontabResumeSuspend

    @CrontabResumeSuspend.setter
    def CrontabResumeSuspend(self, CrontabResumeSuspend):
        self._CrontabResumeSuspend = CrontabResumeSuspend

    @property
    def CrontabResumeSuspendStrategy(self):
        r"""Scheduling policy for the start and end; the complex type includes start and end time and the cluster suspension policy.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.CrontabResumeSuspendStrategy`
        """
        return self._CrontabResumeSuspendStrategy

    @CrontabResumeSuspendStrategy.setter
    def CrontabResumeSuspendStrategy(self, CrontabResumeSuspendStrategy):
        self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy

    @property
    def MaxConcurrency(self):
        r"""The maximum number of concurrent tasks for a single cluster, which is 5 by default.
        :rtype: int
        """
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def TolerableQueueTime(self):
        r"""Tolerable queuing time, and it is 0 by default. When the queuing time for tasks exceeds the tolerable time, it may trigger scale-out. If this parameter is 0, it means that scale-out may be triggered immediately once tasks start queuing.
        :rtype: int
        """
        return self._TolerableQueueTime

    @TolerableQueueTime.setter
    def TolerableQueueTime(self, TolerableQueueTime):
        self._TolerableQueueTime = TolerableQueueTime

    @property
    def AutoSuspendTime(self):
        r"""Cluster automatic suspension time
        :rtype: int
        """
        return self._AutoSuspendTime

    @AutoSuspendTime.setter
    def AutoSuspendTime(self, AutoSuspendTime):
        self._AutoSuspendTime = AutoSuspendTime

    @property
    def ElasticSwitch(self):
        r"""Whether the AS of the spark jar monthly subscription cluster is enabled
        :rtype: bool
        """
        return self._ElasticSwitch

    @ElasticSwitch.setter
    def ElasticSwitch(self, ElasticSwitch):
        self._ElasticSwitch = ElasticSwitch

    @property
    def ElasticLimit(self):
        r"""Upper limit of the spark jar monthly subscription cluster elastic scaling
        :rtype: int
        """
        return self._ElasticLimit

    @ElasticLimit.setter
    def ElasticLimit(self, ElasticLimit):
        self._ElasticLimit = ElasticLimit

    @property
    def SessionResourceTemplate(self):
        r"""Session resource configuration template of Spark batch job clusters
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate


    def _deserialize(self, params):
        self._Size = params.get("Size")
        self._MinClusters = params.get("MinClusters")
        self._MaxClusters = params.get("MaxClusters")
        self._AutoResume = params.get("AutoResume")
        self._DataEngineName = params.get("DataEngineName")
        self._Message = params.get("Message")
        self._AutoSuspend = params.get("AutoSuspend")
        self._CrontabResumeSuspend = params.get("CrontabResumeSuspend")
        if params.get("CrontabResumeSuspendStrategy") is not None:
            self._CrontabResumeSuspendStrategy = CrontabResumeSuspendStrategy()
            self._CrontabResumeSuspendStrategy._deserialize(params.get("CrontabResumeSuspendStrategy"))
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._TolerableQueueTime = params.get("TolerableQueueTime")
        self._AutoSuspendTime = params.get("AutoSuspendTime")
        self._ElasticSwitch = params.get("ElasticSwitch")
        self._ElasticLimit = params.get("ElasticLimit")
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateDataEngineResponse(AbstractModel):
    r"""UpdateDataEngine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateDataMaskStrategyRequest(AbstractModel):
    r"""UpdateDataMaskStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _Strategy: Masking policy description.
        :type Strategy: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        self._Strategy = None

    @property
    def Strategy(self):
        r"""Masking policy description.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.DataMaskStrategyInfo`
        """
        return self._Strategy

    @Strategy.setter
    def Strategy(self, Strategy):
        self._Strategy = Strategy


    def _deserialize(self, params):
        if params.get("Strategy") is not None:
            self._Strategy = DataMaskStrategyInfo()
            self._Strategy._deserialize(params.get("Strategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateDataMaskStrategyResponse(AbstractModel):
    r"""UpdateDataMaskStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateRowFilterRequest(AbstractModel):
    r"""UpdateRowFilter request structure.

    """

    def __init__(self):
        r"""
        :param _PolicyId: The ID of the row filter policy, which can be obtained using the `DescribeUserInfo` or `DescribeWorkGroupInfo` API.
        :type PolicyId: int
        :param _Policy: The new filter policy.
        :type Policy: :class:`tencentcloud.dlc.v20210125.models.Policy`
        """
        self._PolicyId = None
        self._Policy = None

    @property
    def PolicyId(self):
        r"""The ID of the row filter policy, which can be obtained using the `DescribeUserInfo` or `DescribeWorkGroupInfo` API.
        :rtype: int
        """
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def Policy(self):
        r"""The new filter policy.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policy`
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        if params.get("Policy") is not None:
            self._Policy = Policy()
            self._Policy._deserialize(params.get("Policy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateRowFilterResponse(AbstractModel):
    r"""UpdateRowFilter response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateUserDataEngineConfigRequest(AbstractModel):
    r"""UpdateUserDataEngineConfig request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        :param _DataEngineConfigPairs: Collection of user-defined engine configuration items. This parameter needs to input all the configuration items users should add. For example, if there is a configuration item named k1:v1 while k2:v2 needs to be added, [k1:v1,k2:v2] should be passed.
        :type DataEngineConfigPairs: list of DataEngineConfigPair
        :param _SessionResourceTemplate: Template of the resource configuration of the job engine
        :type SessionResourceTemplate: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        self._DataEngineId = None
        self._DataEngineConfigPairs = None
        self._SessionResourceTemplate = None

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId

    @property
    def DataEngineConfigPairs(self):
        r"""Collection of user-defined engine configuration items. This parameter needs to input all the configuration items users should add. For example, if there is a configuration item named k1:v1 while k2:v2 needs to be added, [k1:v1,k2:v2] should be passed.
        :rtype: list of DataEngineConfigPair
        """
        return self._DataEngineConfigPairs

    @DataEngineConfigPairs.setter
    def DataEngineConfigPairs(self, DataEngineConfigPairs):
        self._DataEngineConfigPairs = DataEngineConfigPairs

    @property
    def SessionResourceTemplate(self):
        r"""Template of the resource configuration of the job engine
        :rtype: :class:`tencentcloud.dlc.v20210125.models.SessionResourceTemplate`
        """
        return self._SessionResourceTemplate

    @SessionResourceTemplate.setter
    def SessionResourceTemplate(self, SessionResourceTemplate):
        self._SessionResourceTemplate = SessionResourceTemplate


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        if params.get("DataEngineConfigPairs") is not None:
            self._DataEngineConfigPairs = []
            for item in params.get("DataEngineConfigPairs"):
                obj = DataEngineConfigPair()
                obj._deserialize(item)
                self._DataEngineConfigPairs.append(obj)
        if params.get("SessionResourceTemplate") is not None:
            self._SessionResourceTemplate = SessionResourceTemplate()
            self._SessionResourceTemplate._deserialize(params.get("SessionResourceTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserDataEngineConfigResponse(AbstractModel):
    r"""UpdateUserDataEngineConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpgradeDataEngineImageRequest(AbstractModel):
    r"""UpgradeDataEngineImage request structure.

    """

    def __init__(self):
        r"""
        :param _DataEngineId: Engine ID
        :type DataEngineId: str
        """
        self._DataEngineId = None

    @property
    def DataEngineId(self):
        r"""Engine ID
        :rtype: str
        """
        return self._DataEngineId

    @DataEngineId.setter
    def DataEngineId(self, DataEngineId):
        self._DataEngineId = DataEngineId


    def _deserialize(self, params):
        self._DataEngineId = params.get("DataEngineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpgradeDataEngineImageResponse(AbstractModel):
    r"""UpgradeDataEngineImage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UserDetailInfo(AbstractModel):
    r"""Detailed user information

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _Type: Types of returned information. Group: returned information about the working group where the current user is; DataAuth: returned information about the current user's data permission; EngineAuth: returned information about the current user's engine permission
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _UserType: Types of users. ADMIN: administrators; COMMON: general users
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserType: str
        :param _UserDescription: User description
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserDescription: str
        :param _DataPolicyInfo: Collection of data permission information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataPolicyInfo: :class:`tencentcloud.dlc.v20210125.models.Policys`
        :param _EnginePolicyInfo: Collection of engine permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :type EnginePolicyInfo: :class:`tencentcloud.dlc.v20210125.models.Policys`
        :param _WorkGroupInfo: Information about collections of working groups bound to the user
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupInfo: :class:`tencentcloud.dlc.v20210125.models.WorkGroups`
        :param _UserAlias: User alias
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAlias: str
        :param _RowFilterInfo: Collection of filtered rows
Note: This field may return null, indicating that no valid values can be obtained.
        :type RowFilterInfo: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        self._UserId = None
        self._Type = None
        self._UserType = None
        self._UserDescription = None
        self._DataPolicyInfo = None
        self._EnginePolicyInfo = None
        self._WorkGroupInfo = None
        self._UserAlias = None
        self._RowFilterInfo = None

    @property
    def UserId(self):
        r"""User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Type(self):
        r"""Types of returned information. Group: returned information about the working group where the current user is; DataAuth: returned information about the current user's data permission; EngineAuth: returned information about the current user's engine permission
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UserType(self):
        r"""Types of users. ADMIN: administrators; COMMON: general users
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserDescription(self):
        r"""User description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription

    @property
    def DataPolicyInfo(self):
        r"""Collection of data permission information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        return self._DataPolicyInfo

    @DataPolicyInfo.setter
    def DataPolicyInfo(self, DataPolicyInfo):
        self._DataPolicyInfo = DataPolicyInfo

    @property
    def EnginePolicyInfo(self):
        r"""Collection of engine permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        return self._EnginePolicyInfo

    @EnginePolicyInfo.setter
    def EnginePolicyInfo(self, EnginePolicyInfo):
        self._EnginePolicyInfo = EnginePolicyInfo

    @property
    def WorkGroupInfo(self):
        r"""Information about collections of working groups bound to the user
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.WorkGroups`
        """
        return self._WorkGroupInfo

    @WorkGroupInfo.setter
    def WorkGroupInfo(self, WorkGroupInfo):
        self._WorkGroupInfo = WorkGroupInfo

    @property
    def UserAlias(self):
        r"""User alias
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias

    @property
    def RowFilterInfo(self):
        r"""Collection of filtered rows
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        return self._RowFilterInfo

    @RowFilterInfo.setter
    def RowFilterInfo(self, RowFilterInfo):
        self._RowFilterInfo = RowFilterInfo


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._Type = params.get("Type")
        self._UserType = params.get("UserType")
        self._UserDescription = params.get("UserDescription")
        if params.get("DataPolicyInfo") is not None:
            self._DataPolicyInfo = Policys()
            self._DataPolicyInfo._deserialize(params.get("DataPolicyInfo"))
        if params.get("EnginePolicyInfo") is not None:
            self._EnginePolicyInfo = Policys()
            self._EnginePolicyInfo._deserialize(params.get("EnginePolicyInfo"))
        if params.get("WorkGroupInfo") is not None:
            self._WorkGroupInfo = WorkGroups()
            self._WorkGroupInfo._deserialize(params.get("WorkGroupInfo"))
        self._UserAlias = params.get("UserAlias")
        if params.get("RowFilterInfo") is not None:
            self._RowFilterInfo = Policys()
            self._RowFilterInfo._deserialize(params.get("RowFilterInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserIdSetOfWorkGroupId(AbstractModel):
    r"""Collection of IDs of users bound to the same working group

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group IDs
        :type WorkGroupId: int
        :param _UserIds: User ID which matches the Uin on the CAM side
        :type UserIds: list of str
        """
        self._WorkGroupId = None
        self._UserIds = None

    @property
    def WorkGroupId(self):
        r"""Working group IDs
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def UserIds(self):
        r"""User ID which matches the Uin on the CAM side
        :rtype: list of str
        """
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._UserIds = params.get("UserIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserInfo(AbstractModel):
    r"""Information about the authorized user

    """

    def __init__(self):
        r"""
        :param _UserId: User ID, which is the same as the sub-user UIN
        :type UserId: str
        :param _UserDescription: User description, which can make it easy to identify different users.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserDescription: str
        :param _PolicySet: Collection of permissions solely bound to users
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicySet: list of Policy
        :param _Creator: Creator of the current user
        :type Creator: str
        :param _CreateTime: Creation time, and the example of the format is at 16:19:32 on Jul 28, 2021.
        :type CreateTime: str
        :param _WorkGroupSet: Collection of associated working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupSet: list of WorkGroupMessage
        :param _IsOwner: Whether it is the root account
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsOwner: bool
        :param _UserType: Types of users. ADMIN: administrators; COMMON: general users
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserType: str
        :param _UserAlias: User alias
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAlias: str
        """
        self._UserId = None
        self._UserDescription = None
        self._PolicySet = None
        self._Creator = None
        self._CreateTime = None
        self._WorkGroupSet = None
        self._IsOwner = None
        self._UserType = None
        self._UserAlias = None

    @property
    def UserId(self):
        r"""User ID, which is the same as the sub-user UIN
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserDescription(self):
        r"""User description, which can make it easy to identify different users.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription

    @property
    def PolicySet(self):
        r"""Collection of permissions solely bound to users
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def Creator(self):
        r"""Creator of the current user
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CreateTime(self):
        r"""Creation time, and the example of the format is at 16:19:32 on Jul 28, 2021.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def WorkGroupSet(self):
        r"""Collection of associated working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of WorkGroupMessage
        """
        return self._WorkGroupSet

    @WorkGroupSet.setter
    def WorkGroupSet(self, WorkGroupSet):
        self._WorkGroupSet = WorkGroupSet

    @property
    def IsOwner(self):
        r"""Whether it is the root account
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: bool
        """
        return self._IsOwner

    @IsOwner.setter
    def IsOwner(self, IsOwner):
        self._IsOwner = IsOwner

    @property
    def UserType(self):
        r"""Types of users. ADMIN: administrators; COMMON: general users
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserAlias(self):
        r"""User alias
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserDescription = params.get("UserDescription")
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._Creator = params.get("Creator")
        self._CreateTime = params.get("CreateTime")
        if params.get("WorkGroupSet") is not None:
            self._WorkGroupSet = []
            for item in params.get("WorkGroupSet"):
                obj = WorkGroupMessage()
                obj._deserialize(item)
                self._WorkGroupSet.append(obj)
        self._IsOwner = params.get("IsOwner")
        self._UserType = params.get("UserType")
        self._UserAlias = params.get("UserAlias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserMessage(AbstractModel):
    r"""Partial information of the user

    """

    def __init__(self):
        r"""
        :param _UserId: User Id which matches the sub-user UIN on the CAM side
        :type UserId: str
        :param _UserDescription: User description
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :type UserDescription: str
        :param _Creator: The creator of the current user
        :type Creator: str
        :param _CreateTime: The creation time of the current user, e.g. 16:19:32, July 28, 2021
        :type CreateTime: str
        :param _UserAlias: User alias
        :type UserAlias: str
        """
        self._UserId = None
        self._UserDescription = None
        self._Creator = None
        self._CreateTime = None
        self._UserAlias = None

    @property
    def UserId(self):
        r"""User Id which matches the sub-user UIN on the CAM side
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserDescription(self):
        r"""User description
Note: The returned value of this field may be null, indicating that no valid value is obtained.
        :rtype: str
        """
        return self._UserDescription

    @UserDescription.setter
    def UserDescription(self, UserDescription):
        self._UserDescription = UserDescription

    @property
    def Creator(self):
        r"""The creator of the current user
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CreateTime(self):
        r"""The creation time of the current user, e.g. 16:19:32, July 28, 2021
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UserAlias(self):
        r"""User alias
        :rtype: str
        """
        return self._UserAlias

    @UserAlias.setter
    def UserAlias(self, UserAlias):
        self._UserAlias = UserAlias


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserDescription = params.get("UserDescription")
        self._Creator = params.get("Creator")
        self._CreateTime = params.get("CreateTime")
        self._UserAlias = params.get("UserAlias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserRole(AbstractModel):
    r"""User role

    """

    def __init__(self):
        r"""
        :param _RoleId: The role ID.
        :type RoleId: int
        :param _AppId: The user's app ID.
        :type AppId: str
        :param _Uin: The user ID.
        :type Uin: str
        :param _Arn: The role permission.
        :type Arn: str
        :param _ModifyTime: The last modified timestamp.
        :type ModifyTime: int
        :param _Desc: The role description.
        :type Desc: str
        :param _RoleName: Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleName: str
        :param _Creator: Note: This field may return null, indicating that no valid values can be obtained.
        :type Creator: str
        :param _CosPermissionList: Note: This field may return null, indicating that no valid values can be obtained.
        :type CosPermissionList: list of CosPermission
        :param _PermissionJson: Note: This field may return null, indicating that no valid values can be obtained.
        :type PermissionJson: str
        """
        self._RoleId = None
        self._AppId = None
        self._Uin = None
        self._Arn = None
        self._ModifyTime = None
        self._Desc = None
        self._RoleName = None
        self._Creator = None
        self._CosPermissionList = None
        self._PermissionJson = None

    @property
    def RoleId(self):
        r"""The role ID.
        :rtype: int
        """
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def AppId(self):
        r"""The user's app ID.
        :rtype: str
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        r"""The user ID.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def Arn(self):
        r"""The role permission.
        :rtype: str
        """
        return self._Arn

    @Arn.setter
    def Arn(self, Arn):
        self._Arn = Arn

    @property
    def ModifyTime(self):
        r"""The last modified timestamp.
        :rtype: int
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Desc(self):
        r"""The role description.
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def RoleName(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def Creator(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CosPermissionList(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of CosPermission
        """
        return self._CosPermissionList

    @CosPermissionList.setter
    def CosPermissionList(self, CosPermissionList):
        self._CosPermissionList = CosPermissionList

    @property
    def PermissionJson(self):
        r"""Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._PermissionJson

    @PermissionJson.setter
    def PermissionJson(self, PermissionJson):
        self._PermissionJson = PermissionJson


    def _deserialize(self, params):
        self._RoleId = params.get("RoleId")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._Arn = params.get("Arn")
        self._ModifyTime = params.get("ModifyTime")
        self._Desc = params.get("Desc")
        self._RoleName = params.get("RoleName")
        self._Creator = params.get("Creator")
        if params.get("CosPermissionList") is not None:
            self._CosPermissionList = []
            for item in params.get("CosPermissionList"):
                obj = CosPermission()
                obj._deserialize(item)
                self._CosPermissionList.append(obj)
        self._PermissionJson = params.get("PermissionJson")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Users(AbstractModel):
    r"""Collection of user information

    """

    def __init__(self):
        r"""
        :param _UserSet: Collection of user information
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserSet: list of UserMessage
        :param _TotalCount: Total users
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        """
        self._UserSet = None
        self._TotalCount = None

    @property
    def UserSet(self):
        r"""Collection of user information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of UserMessage
        """
        return self._UserSet

    @UserSet.setter
    def UserSet(self, UserSet):
        self._UserSet = UserSet

    @property
    def TotalCount(self):
        r"""Total users
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("UserSet") is not None:
            self._UserSet = []
            for item in params.get("UserSet"):
                obj = UserMessage()
                obj._deserialize(item)
                self._UserSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcCidrBlock(AbstractModel):
    r"""VPC subnet information

    """

    def __init__(self):
        r"""
        :param _CidrId: Subnet ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type CidrId: str
        :param _CidrAddr: Subnet IP range
Note: This field may return null, indicating that no valid values can be obtained.
        :type CidrAddr: str
        """
        self._CidrId = None
        self._CidrAddr = None

    @property
    def CidrId(self):
        r"""Subnet ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CidrId

    @CidrId.setter
    def CidrId(self, CidrId):
        self._CidrId = CidrId

    @property
    def CidrAddr(self):
        r"""Subnet IP range
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._CidrAddr

    @CidrAddr.setter
    def CidrAddr(self, CidrAddr):
        self._CidrAddr = CidrAddr


    def _deserialize(self, params):
        self._CidrId = params.get("CidrId")
        self._CidrAddr = params.get("CidrAddr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcInfo(AbstractModel):
    r"""VPC information

    """

    def __init__(self):
        r"""
        :param _VpcId: vpc Id
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcId: str
        :param _VpcCidrBlock: VPC subnet
Note: This field may return null, indicating that no valid values can be obtained.
        :type VpcCidrBlock: str
        :param _RuleId: Rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _AccessGroupId: Permission group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessGroupId: str
        """
        self._VpcId = None
        self._VpcCidrBlock = None
        self._RuleId = None
        self._AccessGroupId = None

    @property
    def VpcId(self):
        r"""vpc Id
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpcCidrBlock(self):
        r"""VPC subnet
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._VpcCidrBlock

    @VpcCidrBlock.setter
    def VpcCidrBlock(self, VpcCidrBlock):
        self._VpcCidrBlock = VpcCidrBlock

    @property
    def RuleId(self):
        r"""Rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def AccessGroupId(self):
        r"""Permission group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._AccessGroupId

    @AccessGroupId.setter
    def AccessGroupId(self, AccessGroupId):
        self._AccessGroupId = AccessGroupId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpcCidrBlock = params.get("VpcCidrBlock")
        self._RuleId = params.get("RuleId")
        self._AccessGroupId = params.get("AccessGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WorkGroupDetailInfo(AbstractModel):
    r"""Details about working groups

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Working group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupId: int
        :param _WorkGroupName: Working group name
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupName: str
        :param _Type: Types of information included. User: user information; DataAuth: data permissions; EngineAuth: engine permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _UserInfo: Collection of users bound to working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserInfo: :class:`tencentcloud.dlc.v20210125.models.Users`
        :param _DataPolicyInfo: Collection of data permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataPolicyInfo: :class:`tencentcloud.dlc.v20210125.models.Policys`
        :param _EnginePolicyInfo: Collection of engine permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :type EnginePolicyInfo: :class:`tencentcloud.dlc.v20210125.models.Policys`
        :param _WorkGroupDescription: Working group description
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupDescription: str
        :param _RowFilterInfo: Collection of information about filtered rows
Note: This field may return null, indicating that no valid values can be obtained.
        :type RowFilterInfo: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        self._WorkGroupId = None
        self._WorkGroupName = None
        self._Type = None
        self._UserInfo = None
        self._DataPolicyInfo = None
        self._EnginePolicyInfo = None
        self._WorkGroupDescription = None
        self._RowFilterInfo = None

    @property
    def WorkGroupId(self):
        r"""Working group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def WorkGroupName(self):
        r"""Working group name
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._WorkGroupName

    @WorkGroupName.setter
    def WorkGroupName(self, WorkGroupName):
        self._WorkGroupName = WorkGroupName

    @property
    def Type(self):
        r"""Types of information included. User: user information; DataAuth: data permissions; EngineAuth: engine permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UserInfo(self):
        r"""Collection of users bound to working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Users`
        """
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def DataPolicyInfo(self):
        r"""Collection of data permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        return self._DataPolicyInfo

    @DataPolicyInfo.setter
    def DataPolicyInfo(self, DataPolicyInfo):
        self._DataPolicyInfo = DataPolicyInfo

    @property
    def EnginePolicyInfo(self):
        r"""Collection of engine permissions
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        return self._EnginePolicyInfo

    @EnginePolicyInfo.setter
    def EnginePolicyInfo(self, EnginePolicyInfo):
        self._EnginePolicyInfo = EnginePolicyInfo

    @property
    def WorkGroupDescription(self):
        r"""Working group description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription

    @property
    def RowFilterInfo(self):
        r"""Collection of information about filtered rows
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.dlc.v20210125.models.Policys`
        """
        return self._RowFilterInfo

    @RowFilterInfo.setter
    def RowFilterInfo(self, RowFilterInfo):
        self._RowFilterInfo = RowFilterInfo


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._WorkGroupName = params.get("WorkGroupName")
        self._Type = params.get("Type")
        if params.get("UserInfo") is not None:
            self._UserInfo = Users()
            self._UserInfo._deserialize(params.get("UserInfo"))
        if params.get("DataPolicyInfo") is not None:
            self._DataPolicyInfo = Policys()
            self._DataPolicyInfo._deserialize(params.get("DataPolicyInfo"))
        if params.get("EnginePolicyInfo") is not None:
            self._EnginePolicyInfo = Policys()
            self._EnginePolicyInfo._deserialize(params.get("EnginePolicyInfo"))
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        if params.get("RowFilterInfo") is not None:
            self._RowFilterInfo = Policys()
            self._RowFilterInfo._deserialize(params.get("RowFilterInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WorkGroupIdSetOfUserId(AbstractModel):
    r"""Collections of the working groups bound to the same user

    """

    def __init__(self):
        r"""
        :param _UserId: User ID, which matches Uin on the CAM side.
        :type UserId: str
        :param _WorkGroupIds: Collections of IDs of working groups
        :type WorkGroupIds: list of int
        """
        self._UserId = None
        self._WorkGroupIds = None

    @property
    def UserId(self):
        r"""User ID, which matches Uin on the CAM side.
        :rtype: str
        """
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def WorkGroupIds(self):
        r"""Collections of IDs of working groups
        :rtype: list of int
        """
        return self._WorkGroupIds

    @WorkGroupIds.setter
    def WorkGroupIds(self, WorkGroupIds):
        self._WorkGroupIds = WorkGroupIds


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._WorkGroupIds = params.get("WorkGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WorkGroupInfo(AbstractModel):
    r"""Working group information

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Unique ID of the working group that have been queried
        :type WorkGroupId: int
        :param _WorkGroupName: Working group name
        :type WorkGroupName: str
        :param _WorkGroupDescription: Working group description
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupDescription: str
        :param _UserNum: Number of users associated with working groups
        :type UserNum: int
        :param _UserSet: Collection of users associated with working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserSet: list of UserMessage
        :param _PolicySet: Collections of permissions bound to working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicySet: list of Policy
        :param _Creator: Creators of working groups
        :type Creator: str
        :param _CreateTime: The creation time of the working group, e.g. at 16:19:32 on Jul 28, 2021
        :type CreateTime: str
        """
        self._WorkGroupId = None
        self._WorkGroupName = None
        self._WorkGroupDescription = None
        self._UserNum = None
        self._UserSet = None
        self._PolicySet = None
        self._Creator = None
        self._CreateTime = None

    @property
    def WorkGroupId(self):
        r"""Unique ID of the working group that have been queried
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def WorkGroupName(self):
        r"""Working group name
        :rtype: str
        """
        return self._WorkGroupName

    @WorkGroupName.setter
    def WorkGroupName(self, WorkGroupName):
        self._WorkGroupName = WorkGroupName

    @property
    def WorkGroupDescription(self):
        r"""Working group description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription

    @property
    def UserNum(self):
        r"""Number of users associated with working groups
        :rtype: int
        """
        return self._UserNum

    @UserNum.setter
    def UserNum(self, UserNum):
        self._UserNum = UserNum

    @property
    def UserSet(self):
        r"""Collection of users associated with working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of UserMessage
        """
        return self._UserSet

    @UserSet.setter
    def UserSet(self, UserSet):
        self._UserSet = UserSet

    @property
    def PolicySet(self):
        r"""Collections of permissions bound to working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Policy
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def Creator(self):
        r"""Creators of working groups
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CreateTime(self):
        r"""The creation time of the working group, e.g. at 16:19:32 on Jul 28, 2021
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._WorkGroupName = params.get("WorkGroupName")
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        self._UserNum = params.get("UserNum")
        if params.get("UserSet") is not None:
            self._UserSet = []
            for item in params.get("UserSet"):
                obj = UserMessage()
                obj._deserialize(item)
                self._UserSet.append(obj)
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = Policy()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._Creator = params.get("Creator")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WorkGroupMessage(AbstractModel):
    r"""Partial information about working groups

    """

    def __init__(self):
        r"""
        :param _WorkGroupId: Unique ID of the working group
        :type WorkGroupId: int
        :param _WorkGroupName: Working group name
        :type WorkGroupName: str
        :param _WorkGroupDescription: Working group description
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupDescription: str
        :param _Creator: Creator
        :type Creator: str
        :param _CreateTime: The creation time of the working group, e.g. at 16:19:32 on Jul 28, 2021
        :type CreateTime: str
        """
        self._WorkGroupId = None
        self._WorkGroupName = None
        self._WorkGroupDescription = None
        self._Creator = None
        self._CreateTime = None

    @property
    def WorkGroupId(self):
        r"""Unique ID of the working group
        :rtype: int
        """
        return self._WorkGroupId

    @WorkGroupId.setter
    def WorkGroupId(self, WorkGroupId):
        self._WorkGroupId = WorkGroupId

    @property
    def WorkGroupName(self):
        r"""Working group name
        :rtype: str
        """
        return self._WorkGroupName

    @WorkGroupName.setter
    def WorkGroupName(self, WorkGroupName):
        self._WorkGroupName = WorkGroupName

    @property
    def WorkGroupDescription(self):
        r"""Working group description
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._WorkGroupDescription

    @WorkGroupDescription.setter
    def WorkGroupDescription(self, WorkGroupDescription):
        self._WorkGroupDescription = WorkGroupDescription

    @property
    def Creator(self):
        r"""Creator
        :rtype: str
        """
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def CreateTime(self):
        r"""The creation time of the working group, e.g. at 16:19:32 on Jul 28, 2021
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._WorkGroupId = params.get("WorkGroupId")
        self._WorkGroupName = params.get("WorkGroupName")
        self._WorkGroupDescription = params.get("WorkGroupDescription")
        self._Creator = params.get("Creator")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WorkGroups(AbstractModel):
    r"""Collections of working groups

    """

    def __init__(self):
        r"""
        :param _WorkGroupSet: Collection of working group information
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkGroupSet: list of WorkGroupMessage
        :param _TotalCount: Total working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        """
        self._WorkGroupSet = None
        self._TotalCount = None

    @property
    def WorkGroupSet(self):
        r"""Collection of working group information
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of WorkGroupMessage
        """
        return self._WorkGroupSet

    @WorkGroupSet.setter
    def WorkGroupSet(self, WorkGroupSet):
        self._WorkGroupSet = WorkGroupSet

    @property
    def TotalCount(self):
        r"""Total working groups
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("WorkGroupSet") is not None:
            self._WorkGroupSet = []
            for item in params.get("WorkGroupSet"):
                obj = WorkGroupMessage()
                obj._deserialize(item)
                self._WorkGroupSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        