# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class Ability(AbstractModel):
    r"""Features supported by the cluster

    """

    def __init__(self):
        r"""
        :param _IsSupportSlaveZone: Whether secondary AZ is supported
        :type IsSupportSlaveZone: str
        :param _NonsupportSlaveZoneReason: The causes for no support from an availability zone.
        :type NonsupportSlaveZoneReason: str
        :param _IsSupportRo: Whether read-only instance is supported
        :type IsSupportRo: str
        :param _NonsupportRoReason: Reasons why RO instances are not supported.
        :type NonsupportRoReason: str
        :param _IsSupportManualSnapshot: Whether manual snapshot backup initiation is supported.
        :type IsSupportManualSnapshot: str
        :param _IsSupportTransparentDataEncryption: Whether transparent data encryption is supported.
        :type IsSupportTransparentDataEncryption: str
        :param _NoSupportTransparentDataEncryptionReason: Reasons for no support of transparent data encryption.
        :type NoSupportTransparentDataEncryptionReason: str
        :param _IsSupportManualLogic: Whether manual initiation of logical backup is supported.
        :type IsSupportManualLogic: str
        """
        self._IsSupportSlaveZone = None
        self._NonsupportSlaveZoneReason = None
        self._IsSupportRo = None
        self._NonsupportRoReason = None
        self._IsSupportManualSnapshot = None
        self._IsSupportTransparentDataEncryption = None
        self._NoSupportTransparentDataEncryptionReason = None
        self._IsSupportManualLogic = None

    @property
    def IsSupportSlaveZone(self):
        r"""Whether secondary AZ is supported
        :rtype: str
        """
        return self._IsSupportSlaveZone

    @IsSupportSlaveZone.setter
    def IsSupportSlaveZone(self, IsSupportSlaveZone):
        self._IsSupportSlaveZone = IsSupportSlaveZone

    @property
    def NonsupportSlaveZoneReason(self):
        r"""The causes for no support from an availability zone.
        :rtype: str
        """
        return self._NonsupportSlaveZoneReason

    @NonsupportSlaveZoneReason.setter
    def NonsupportSlaveZoneReason(self, NonsupportSlaveZoneReason):
        self._NonsupportSlaveZoneReason = NonsupportSlaveZoneReason

    @property
    def IsSupportRo(self):
        r"""Whether read-only instance is supported
        :rtype: str
        """
        return self._IsSupportRo

    @IsSupportRo.setter
    def IsSupportRo(self, IsSupportRo):
        self._IsSupportRo = IsSupportRo

    @property
    def NonsupportRoReason(self):
        r"""Reasons why RO instances are not supported.
        :rtype: str
        """
        return self._NonsupportRoReason

    @NonsupportRoReason.setter
    def NonsupportRoReason(self, NonsupportRoReason):
        self._NonsupportRoReason = NonsupportRoReason

    @property
    def IsSupportManualSnapshot(self):
        r"""Whether manual snapshot backup initiation is supported.
        :rtype: str
        """
        return self._IsSupportManualSnapshot

    @IsSupportManualSnapshot.setter
    def IsSupportManualSnapshot(self, IsSupportManualSnapshot):
        self._IsSupportManualSnapshot = IsSupportManualSnapshot

    @property
    def IsSupportTransparentDataEncryption(self):
        r"""Whether transparent data encryption is supported.
        :rtype: str
        """
        return self._IsSupportTransparentDataEncryption

    @IsSupportTransparentDataEncryption.setter
    def IsSupportTransparentDataEncryption(self, IsSupportTransparentDataEncryption):
        self._IsSupportTransparentDataEncryption = IsSupportTransparentDataEncryption

    @property
    def NoSupportTransparentDataEncryptionReason(self):
        r"""Reasons for no support of transparent data encryption.
        :rtype: str
        """
        return self._NoSupportTransparentDataEncryptionReason

    @NoSupportTransparentDataEncryptionReason.setter
    def NoSupportTransparentDataEncryptionReason(self, NoSupportTransparentDataEncryptionReason):
        self._NoSupportTransparentDataEncryptionReason = NoSupportTransparentDataEncryptionReason

    @property
    def IsSupportManualLogic(self):
        r"""Whether manual initiation of logical backup is supported.
        :rtype: str
        """
        return self._IsSupportManualLogic

    @IsSupportManualLogic.setter
    def IsSupportManualLogic(self, IsSupportManualLogic):
        self._IsSupportManualLogic = IsSupportManualLogic


    def _deserialize(self, params):
        self._IsSupportSlaveZone = params.get("IsSupportSlaveZone")
        self._NonsupportSlaveZoneReason = params.get("NonsupportSlaveZoneReason")
        self._IsSupportRo = params.get("IsSupportRo")
        self._NonsupportRoReason = params.get("NonsupportRoReason")
        self._IsSupportManualSnapshot = params.get("IsSupportManualSnapshot")
        self._IsSupportTransparentDataEncryption = params.get("IsSupportTransparentDataEncryption")
        self._NoSupportTransparentDataEncryptionReason = params.get("NoSupportTransparentDataEncryptionReason")
        self._IsSupportManualLogic = params.get("IsSupportManualLogic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Account(AbstractModel):
    r"""Database account information

    """

    def __init__(self):
        r"""
        :param _AccountName: Database account name
        :type AccountName: str
        :param _Description: Database account description
        :type Description: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _Host: Host
        :type Host: str
        :param _MaxUserConnections: The max connections
        :type MaxUserConnections: int
        """
        self._AccountName = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Host = None
        self._MaxUserConnections = None

    @property
    def AccountName(self):
        r"""Database account name
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def Description(self):
        r"""Database account description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Host(self):
        r"""Host
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def MaxUserConnections(self):
        r"""The max connections
        :rtype: int
        """
        return self._MaxUserConnections

    @MaxUserConnections.setter
    def MaxUserConnections(self, MaxUserConnections):
        self._MaxUserConnections = MaxUserConnections


    def _deserialize(self, params):
        self._AccountName = params.get("AccountName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Host = params.get("Host")
        self._MaxUserConnections = params.get("MaxUserConnections")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivateInstanceRequest(AbstractModel):
    r"""ActivateInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIdList: List of instance IDs in the format of `cynosdbmysql-ins-n7ocdslw` as displayed in the TDSQL-C for MySQL console. You can use the instance list querying API to query the ID, i.e., the `InstanceId` value in the output parameters.
        :type InstanceIdList: list of str
        """
        self._ClusterId = None
        self._InstanceIdList = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIdList(self):
        r"""List of instance IDs in the format of `cynosdbmysql-ins-n7ocdslw` as displayed in the TDSQL-C for MySQL console. You can use the instance list querying API to query the ID, i.e., the `InstanceId` value in the output parameters.
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIdList = params.get("InstanceIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivateInstanceResponse(AbstractModel):
    r"""ActivateInstance response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class AddClusterSlaveZoneRequest(AbstractModel):
    r"""AddClusterSlaveZone request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _SlaveZone: Replica AZ
        :type SlaveZone: str
        """
        self._ClusterId = None
        self._SlaveZone = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SlaveZone(self):
        r"""Replica AZ
        :rtype: str
        """
        return self._SlaveZone

    @SlaveZone.setter
    def SlaveZone(self, SlaveZone):
        self._SlaveZone = SlaveZone


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SlaveZone = params.get("SlaveZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddClusterSlaveZoneResponse(AbstractModel):
    r"""AddClusterSlaveZone response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async FlowId
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async FlowId
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class AddInstancesRequest(AbstractModel):
    r"""AddInstances request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Cpu: Number of CPU cores
        :type Cpu: int
        :param _Memory: Memory in GB
        :type Memory: int
        :param _ReadOnlyCount: Number of added read-only instances. Value range: (0,16].
        :type ReadOnlyCount: int
        :param _InstanceGrpId: Instance group ID, which will be used when you add an instance in an existing RO group. If this parameter is left empty, an RO group will be created. But it is not recommended to pass in this parameter for the current version, as this version has been disused.
        :type InstanceGrpId: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _SubnetId: Subnet ID. If `VpcId` is set, `SubnetId` is required.
        :type SubnetId: str
        :param _Port: The port used when adding an RO group. Value range: [0,65535).
        :type Port: int
        :param _InstanceName: Instance name. String length range: [0,64).
        :type InstanceName: str
        :param _AutoVoucher: Whether to automatically select a voucher. 1: yes; 0: no. Default value: 0
        :type AutoVoucher: int
        :param _DbType: Database type. Valid values: 
<li> MYSQL </li>
        :type DbType: str
        :param _OrderSource: Order source. String length range: [0,64).
        :type OrderSource: str
        :param _DealMode: Transaction mode. Valid values: `0` (place and pay for an order), `1` (place an order)
        :type DealMode: int
        :param _ParamTemplateId: Parameter template ID
        :type ParamTemplateId: int
        :param _InstanceParams: Parameter list, which is valid only if `InstanceParams` is passed in to `ParamTemplateId`.
        :type InstanceParams: list of ModifyParamItem
        :param _SecurityGroupIds: Security group ID. You can specify an security group when creating a read-only instance.
        :type SecurityGroupIds: list of str
        """
        self._ClusterId = None
        self._Cpu = None
        self._Memory = None
        self._ReadOnlyCount = None
        self._InstanceGrpId = None
        self._VpcId = None
        self._SubnetId = None
        self._Port = None
        self._InstanceName = None
        self._AutoVoucher = None
        self._DbType = None
        self._OrderSource = None
        self._DealMode = None
        self._ParamTemplateId = None
        self._InstanceParams = None
        self._SecurityGroupIds = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Cpu(self):
        r"""Number of CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory in GB
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def ReadOnlyCount(self):
        r"""Number of added read-only instances. Value range: (0,16].
        :rtype: int
        """
        return self._ReadOnlyCount

    @ReadOnlyCount.setter
    def ReadOnlyCount(self, ReadOnlyCount):
        self._ReadOnlyCount = ReadOnlyCount

    @property
    def InstanceGrpId(self):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        r"""Instance group ID, which will be used when you add an instance in an existing RO group. If this parameter is left empty, an RO group will be created. But it is not recommended to pass in this parameter for the current version, as this version has been disused.
        :rtype: str
        """
        return self._InstanceGrpId

    @InstanceGrpId.setter
    def InstanceGrpId(self, InstanceGrpId):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        self._InstanceGrpId = InstanceGrpId

    @property
    def VpcId(self):
        r"""VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID. If `VpcId` is set, `SubnetId` is required.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Port(self):
        r"""The port used when adding an RO group. Value range: [0,65535).
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def InstanceName(self):
        r"""Instance name. String length range: [0,64).
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def AutoVoucher(self):
        r"""Whether to automatically select a voucher. 1: yes; 0: no. Default value: 0
        :rtype: int
        """
        return self._AutoVoucher

    @AutoVoucher.setter
    def AutoVoucher(self, AutoVoucher):
        self._AutoVoucher = AutoVoucher

    @property
    def DbType(self):
        r"""Database type. Valid values: 
<li> MYSQL </li>
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def OrderSource(self):
        r"""Order source. String length range: [0,64).
        :rtype: str
        """
        return self._OrderSource

    @OrderSource.setter
    def OrderSource(self, OrderSource):
        self._OrderSource = OrderSource

    @property
    def DealMode(self):
        r"""Transaction mode. Valid values: `0` (place and pay for an order), `1` (place an order)
        :rtype: int
        """
        return self._DealMode

    @DealMode.setter
    def DealMode(self, DealMode):
        self._DealMode = DealMode

    @property
    def ParamTemplateId(self):
        r"""Parameter template ID
        :rtype: int
        """
        return self._ParamTemplateId

    @ParamTemplateId.setter
    def ParamTemplateId(self, ParamTemplateId):
        self._ParamTemplateId = ParamTemplateId

    @property
    def InstanceParams(self):
        r"""Parameter list, which is valid only if `InstanceParams` is passed in to `ParamTemplateId`.
        :rtype: list of ModifyParamItem
        """
        return self._InstanceParams

    @InstanceParams.setter
    def InstanceParams(self, InstanceParams):
        self._InstanceParams = InstanceParams

    @property
    def SecurityGroupIds(self):
        r"""Security group ID. You can specify an security group when creating a read-only instance.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._ReadOnlyCount = params.get("ReadOnlyCount")
        self._InstanceGrpId = params.get("InstanceGrpId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Port = params.get("Port")
        self._InstanceName = params.get("InstanceName")
        self._AutoVoucher = params.get("AutoVoucher")
        self._DbType = params.get("DbType")
        self._OrderSource = params.get("OrderSource")
        self._DealMode = params.get("DealMode")
        self._ParamTemplateId = params.get("ParamTemplateId")
        if params.get("InstanceParams") is not None:
            self._InstanceParams = []
            for item in params.get("InstanceParams"):
                obj = ModifyParamItem()
                obj._deserialize(item)
                self._InstanceParams.append(obj)
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddInstancesResponse(AbstractModel):
    r"""AddInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TranId: Freeze transaction. one frozen transaction is activated at a time.
        :type TranId: str
        :param _DealNames: Specifies the post-paid order number.
        :type DealNames: list of str
        :param _ResourceIds: Delivery resource id list.
        :type ResourceIds: list of str
        :param _BigDealIds: Large order number.
        :type BigDealIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TranId = None
        self._DealNames = None
        self._ResourceIds = None
        self._BigDealIds = None
        self._RequestId = None

    @property
    def TranId(self):
        r"""Freeze transaction. one frozen transaction is activated at a time.
        :rtype: str
        """
        return self._TranId

    @TranId.setter
    def TranId(self, TranId):
        self._TranId = TranId

    @property
    def DealNames(self):
        r"""Specifies the post-paid order number.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def ResourceIds(self):
        r"""Delivery resource id list.
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def BigDealIds(self):
        r"""Large order number.
        :rtype: list of str
        """
        return self._BigDealIds

    @BigDealIds.setter
    def BigDealIds(self, BigDealIds):
        self._BigDealIds = BigDealIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TranId = params.get("TranId")
        self._DealNames = params.get("DealNames")
        self._ResourceIds = params.get("ResourceIds")
        self._BigDealIds = params.get("BigDealIds")
        self._RequestId = params.get("RequestId")


class Addr(AbstractModel):
    r"""Database address

    """

    def __init__(self):
        r"""
        :param _IP: IP address
        :type IP: str
        :param _Port: Port
        :type Port: int
        """
        self._IP = None
        self._Port = None

    @property
    def IP(self):
        r"""IP address
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP

    @property
    def Port(self):
        r"""Port
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._IP = params.get("IP")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditInstanceFilters(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _Name: 
        :type Name: str
        :param _ExactMatch: 
        :type ExactMatch: bool
        :param _Values: 
        :type Values: list of str
        """
        self._Name = None
        self._ExactMatch = None
        self._Values = None

    @property
    def Name(self):
        r"""
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ExactMatch(self):
        r"""
        :rtype: bool
        """
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch

    @property
    def Values(self):
        r"""
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ExactMatch = params.get("ExactMatch")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditInstanceInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: int
        :param _TagList: Tag information
        :type TagList: list of Tag
        """
        self._ProjectId = None
        self._TagList = None

    @property
    def ProjectId(self):
        r"""Project ID.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TagList(self):
        r"""Tag information
        :rtype: list of Tag
        """
        return self._TagList

    @TagList.setter
    def TagList(self, TagList):
        self._TagList = TagList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("TagList") is not None:
            self._TagList = []
            for item in params.get("TagList"):
                obj = Tag()
                obj._deserialize(item)
                self._TagList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditRuleFilters(AbstractModel):
    r"""Filter of rule audit

    """

    def __init__(self):
        r"""
        :param _RuleFilters: A single audit rule.
        :type RuleFilters: list of RuleFilters
        """
        self._RuleFilters = None

    @property
    def RuleFilters(self):
        r"""A single audit rule.
        :rtype: list of RuleFilters
        """
        return self._RuleFilters

    @RuleFilters.setter
    def RuleFilters(self, RuleFilters):
        self._RuleFilters = RuleFilters


    def _deserialize(self, params):
        if params.get("RuleFilters") is not None:
            self._RuleFilters = []
            for item in params.get("RuleFilters"):
                obj = RuleFilters()
                obj._deserialize(item)
                self._RuleFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditRuleTemplateInfo(AbstractModel):
    r"""Details of an audit rule template

    """

    def __init__(self):
        r"""
        :param _RuleTemplateId: Rule template ID
        :type RuleTemplateId: str
        :param _RuleTemplateName: Rule template name
        :type RuleTemplateName: str
        :param _RuleFilters: Filter of the rule template
        :type RuleFilters: list of RuleFilters
        :param _Description: Rule template description.
        :type Description: str
        :param _CreateAt: Creation time of a rule template
        :type CreateAt: str
        :param _UpdateAt: Rule template modification time.
        :type UpdateAt: str
        :param _AlarmLevel: Alarm level. valid values: 1 (low risk), 2 (medium risk), 3 (high risk).
        :type AlarmLevel: int
        :param _AlarmPolicy: Alarm policy. 0 - no alert, 1 - alert.
        :type AlarmPolicy: int
        :param _Status: Template status. 0 - no task, 1 - modifying.
        :type Status: int
        :param _AffectedInstances: Template application is used in which instances.
        :type AffectedInstances: list of str
        """
        self._RuleTemplateId = None
        self._RuleTemplateName = None
        self._RuleFilters = None
        self._Description = None
        self._CreateAt = None
        self._UpdateAt = None
        self._AlarmLevel = None
        self._AlarmPolicy = None
        self._Status = None
        self._AffectedInstances = None

    @property
    def RuleTemplateId(self):
        r"""Rule template ID
        :rtype: str
        """
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def RuleTemplateName(self):
        r"""Rule template name
        :rtype: str
        """
        return self._RuleTemplateName

    @RuleTemplateName.setter
    def RuleTemplateName(self, RuleTemplateName):
        self._RuleTemplateName = RuleTemplateName

    @property
    def RuleFilters(self):
        r"""Filter of the rule template
        :rtype: list of RuleFilters
        """
        return self._RuleFilters

    @RuleFilters.setter
    def RuleFilters(self, RuleFilters):
        self._RuleFilters = RuleFilters

    @property
    def Description(self):
        r"""Rule template description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateAt(self):
        r"""Creation time of a rule template
        :rtype: str
        """
        return self._CreateAt

    @CreateAt.setter
    def CreateAt(self, CreateAt):
        self._CreateAt = CreateAt

    @property
    def UpdateAt(self):
        r"""Rule template modification time.
        :rtype: str
        """
        return self._UpdateAt

    @UpdateAt.setter
    def UpdateAt(self, UpdateAt):
        self._UpdateAt = UpdateAt

    @property
    def AlarmLevel(self):
        r"""Alarm level. valid values: 1 (low risk), 2 (medium risk), 3 (high risk).
        :rtype: int
        """
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def AlarmPolicy(self):
        r"""Alarm policy. 0 - no alert, 1 - alert.
        :rtype: int
        """
        return self._AlarmPolicy

    @AlarmPolicy.setter
    def AlarmPolicy(self, AlarmPolicy):
        self._AlarmPolicy = AlarmPolicy

    @property
    def Status(self):
        r"""Template status. 0 - no task, 1 - modifying.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AffectedInstances(self):
        r"""Template application is used in which instances.
        :rtype: list of str
        """
        return self._AffectedInstances

    @AffectedInstances.setter
    def AffectedInstances(self, AffectedInstances):
        self._AffectedInstances = AffectedInstances


    def _deserialize(self, params):
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._RuleTemplateName = params.get("RuleTemplateName")
        if params.get("RuleFilters") is not None:
            self._RuleFilters = []
            for item in params.get("RuleFilters"):
                obj = RuleFilters()
                obj._deserialize(item)
                self._RuleFilters.append(obj)
        self._Description = params.get("Description")
        self._CreateAt = params.get("CreateAt")
        self._UpdateAt = params.get("UpdateAt")
        self._AlarmLevel = params.get("AlarmLevel")
        self._AlarmPolicy = params.get("AlarmPolicy")
        self._Status = params.get("Status")
        self._AffectedInstances = params.get("AffectedInstances")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BackupFileInfo(AbstractModel):
    r"""Backup file information

    """

    def __init__(self):
        r"""
        :param _SnapshotId: Snapshot file ID, which is deprecated. You need to use `BackupId`.
        :type SnapshotId: int
        :param _FileName: Backup file name
        :type FileName: str
        :param _FileSize: Backup file size
        :type FileSize: int
        :param _StartTime: Backup start time
        :type StartTime: str
        :param _FinishTime: Backup end time
        :type FinishTime: str
        :param _BackupType: Backup type. Valid values: `snapshot` (snapshot backup), `logic` (logic backup).
        :type BackupType: str
        :param _BackupMethod: Back mode. auto: auto backup; manual: manual backup
        :type BackupMethod: str
        :param _BackupStatus: Backup file status. success: backup succeeded; fail: backup failed; creating: creating backup file; deleting: deleting backup file
        :type BackupStatus: str
        :param _SnapshotTime: Backup file time
        :type SnapshotTime: str
        :param _BackupId: Backup ID.
        :type BackupId: int
        :param _SnapShotType: Specifies the snapshot type. valid values: full (full snapshot); increment (incremental snapshot).
        :type SnapShotType: str
        :param _BackupName: Specifies the remark of the backup file.
        :type BackupName: str
        """
        self._SnapshotId = None
        self._FileName = None
        self._FileSize = None
        self._StartTime = None
        self._FinishTime = None
        self._BackupType = None
        self._BackupMethod = None
        self._BackupStatus = None
        self._SnapshotTime = None
        self._BackupId = None
        self._SnapShotType = None
        self._BackupName = None

    @property
    def SnapshotId(self):
        r"""Snapshot file ID, which is deprecated. You need to use `BackupId`.
        :rtype: int
        """
        return self._SnapshotId

    @SnapshotId.setter
    def SnapshotId(self, SnapshotId):
        self._SnapshotId = SnapshotId

    @property
    def FileName(self):
        r"""Backup file name
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileSize(self):
        r"""Backup file size
        :rtype: int
        """
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def StartTime(self):
        r"""Backup start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def FinishTime(self):
        r"""Backup end time
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def BackupType(self):
        r"""Backup type. Valid values: `snapshot` (snapshot backup), `logic` (logic backup).
        :rtype: str
        """
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def BackupMethod(self):
        r"""Back mode. auto: auto backup; manual: manual backup
        :rtype: str
        """
        return self._BackupMethod

    @BackupMethod.setter
    def BackupMethod(self, BackupMethod):
        self._BackupMethod = BackupMethod

    @property
    def BackupStatus(self):
        r"""Backup file status. success: backup succeeded; fail: backup failed; creating: creating backup file; deleting: deleting backup file
        :rtype: str
        """
        return self._BackupStatus

    @BackupStatus.setter
    def BackupStatus(self, BackupStatus):
        self._BackupStatus = BackupStatus

    @property
    def SnapshotTime(self):
        r"""Backup file time
        :rtype: str
        """
        return self._SnapshotTime

    @SnapshotTime.setter
    def SnapshotTime(self, SnapshotTime):
        self._SnapshotTime = SnapshotTime

    @property
    def BackupId(self):
        r"""Backup ID.
        :rtype: int
        """
        return self._BackupId

    @BackupId.setter
    def BackupId(self, BackupId):
        self._BackupId = BackupId

    @property
    def SnapShotType(self):
        r"""Specifies the snapshot type. valid values: full (full snapshot); increment (incremental snapshot).
        :rtype: str
        """
        return self._SnapShotType

    @SnapShotType.setter
    def SnapShotType(self, SnapShotType):
        self._SnapShotType = SnapShotType

    @property
    def BackupName(self):
        r"""Specifies the remark of the backup file.
        :rtype: str
        """
        return self._BackupName

    @BackupName.setter
    def BackupName(self, BackupName):
        self._BackupName = BackupName


    def _deserialize(self, params):
        self._SnapshotId = params.get("SnapshotId")
        self._FileName = params.get("FileName")
        self._FileSize = params.get("FileSize")
        self._StartTime = params.get("StartTime")
        self._FinishTime = params.get("FinishTime")
        self._BackupType = params.get("BackupType")
        self._BackupMethod = params.get("BackupMethod")
        self._BackupStatus = params.get("BackupStatus")
        self._SnapshotTime = params.get("SnapshotTime")
        self._BackupId = params.get("BackupId")
        self._SnapShotType = params.get("SnapShotType")
        self._BackupName = params.get("BackupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BackupLimitClusterRestriction(AbstractModel):
    r"""Specifies the backup download cluster restrictions parameter.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BackupLimitRestriction: Download limit configuration.
        :type BackupLimitRestriction: :class:`tencentcloud.cynosdb.v20190107.models.BackupLimitRestriction`
        """
        self._ClusterId = None
        self._BackupLimitRestriction = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BackupLimitRestriction(self):
        r"""Download limit configuration.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.BackupLimitRestriction`
        """
        return self._BackupLimitRestriction

    @BackupLimitRestriction.setter
    def BackupLimitRestriction(self, BackupLimitRestriction):
        self._BackupLimitRestriction = BackupLimitRestriction


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("BackupLimitRestriction") is not None:
            self._BackupLimitRestriction = BackupLimitRestriction()
            self._BackupLimitRestriction._deserialize(params.get("BackupLimitRestriction"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BackupLimitRestriction(AbstractModel):
    r"""Specifies the backup download limit parameter.

    """

    def __init__(self):
        r"""
        :param _LimitType: Restriction type.
        :type LimitType: str
        :param _VpcComparisonSymbol: This parameter only supports In, which indicates that the vpc specified by LimitVpc can be downloaded. the default is In.
        :type VpcComparisonSymbol: str
        :param _IpComparisonSymbol: Specified ips can download; specified ips are not allowed to download.
        :type IpComparisonSymbol: str
        :param _LimitVpcs: Specifies the vpc setting for download restrictions.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LimitVpcs: list of BackupLimitVpcItem
        :param _LimitIps: Specifies the ip settings for limiting downloads.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LimitIps: list of str
        """
        self._LimitType = None
        self._VpcComparisonSymbol = None
        self._IpComparisonSymbol = None
        self._LimitVpcs = None
        self._LimitIps = None

    @property
    def LimitType(self):
        r"""Restriction type.
        :rtype: str
        """
        return self._LimitType

    @LimitType.setter
    def LimitType(self, LimitType):
        self._LimitType = LimitType

    @property
    def VpcComparisonSymbol(self):
        r"""This parameter only supports In, which indicates that the vpc specified by LimitVpc can be downloaded. the default is In.
        :rtype: str
        """
        return self._VpcComparisonSymbol

    @VpcComparisonSymbol.setter
    def VpcComparisonSymbol(self, VpcComparisonSymbol):
        self._VpcComparisonSymbol = VpcComparisonSymbol

    @property
    def IpComparisonSymbol(self):
        r"""Specified ips can download; specified ips are not allowed to download.
        :rtype: str
        """
        return self._IpComparisonSymbol

    @IpComparisonSymbol.setter
    def IpComparisonSymbol(self, IpComparisonSymbol):
        self._IpComparisonSymbol = IpComparisonSymbol

    @property
    def LimitVpcs(self):
        r"""Specifies the vpc setting for download restrictions.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of BackupLimitVpcItem
        """
        return self._LimitVpcs

    @LimitVpcs.setter
    def LimitVpcs(self, LimitVpcs):
        self._LimitVpcs = LimitVpcs

    @property
    def LimitIps(self):
        r"""Specifies the ip settings for limiting downloads.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._LimitIps

    @LimitIps.setter
    def LimitIps(self, LimitIps):
        self._LimitIps = LimitIps


    def _deserialize(self, params):
        self._LimitType = params.get("LimitType")
        self._VpcComparisonSymbol = params.get("VpcComparisonSymbol")
        self._IpComparisonSymbol = params.get("IpComparisonSymbol")
        if params.get("LimitVpcs") is not None:
            self._LimitVpcs = []
            for item in params.get("LimitVpcs"):
                obj = BackupLimitVpcItem()
                obj._deserialize(item)
                self._LimitVpcs.append(obj)
        self._LimitIps = params.get("LimitIps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BackupLimitVpcItem(AbstractModel):
    r"""VPC settings for restricting backup download sources.

    """

    def __init__(self):
        r"""
        :param _Region: Specifies the region for limiting download sources. currently only supports the current region.
        :type Region: str
        :param _VpcList: Limit the vpc list for downloads.
        :type VpcList: list of str
        """
        self._Region = None
        self._VpcList = None

    @property
    def Region(self):
        r"""Specifies the region for limiting download sources. currently only supports the current region.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VpcList(self):
        r"""Limit the vpc list for downloads.
        :rtype: list of str
        """
        return self._VpcList

    @VpcList.setter
    def VpcList(self, VpcList):
        self._VpcList = VpcList


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._VpcList = params.get("VpcList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillingResourceInfo(AbstractModel):
    r"""Billable resource information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIds: Instance ID list
        :type InstanceIds: list of str
        :param _DealName: Order ID
        :type DealName: str
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._DealName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""Instance ID list
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def DealName(self):
        r"""Order ID
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        self._DealName = params.get("DealName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindClusterResourcePackagesRequest(AbstractModel):
    r"""BindClusterResourcePackages request structure.

    """

    def __init__(self):
        r"""
        :param _PackageIds: The unique ID of a resource pack
        :type PackageIds: list of str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._PackageIds = None
        self._ClusterId = None

    @property
    def PackageIds(self):
        r"""The unique ID of a resource pack
        :rtype: list of str
        """
        return self._PackageIds

    @PackageIds.setter
    def PackageIds(self, PackageIds):
        self._PackageIds = PackageIds

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._PackageIds = params.get("PackageIds")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindClusterResourcePackagesResponse(AbstractModel):
    r"""BindClusterResourcePackages response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BindInstanceInfo(AbstractModel):
    r"""Information of the instance bound to the resource pack

    """

    def __init__(self):
        r"""
        :param _InstanceId: ID of the bound cluster.
        :type InstanceId: str
        :param _InstanceRegion: The region where the bound instance is located.
        :type InstanceRegion: str
        :param _InstanceType: Type of the bound instance.
        :type InstanceType: str
        :param _ExtendIds: The instance ID under the bound cluster.
        :type ExtendIds: list of str
        """
        self._InstanceId = None
        self._InstanceRegion = None
        self._InstanceType = None
        self._ExtendIds = None

    @property
    def InstanceId(self):
        r"""ID of the bound cluster.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceRegion(self):
        r"""The region where the bound instance is located.
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def InstanceType(self):
        r"""Type of the bound instance.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def ExtendIds(self):
        r"""The instance ID under the bound cluster.
        :rtype: list of str
        """
        return self._ExtendIds

    @ExtendIds.setter
    def ExtendIds(self, ExtendIds):
        self._ExtendIds = ExtendIds


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceRegion = params.get("InstanceRegion")
        self._InstanceType = params.get("InstanceType")
        self._ExtendIds = params.get("ExtendIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BinlogConfigInfo(AbstractModel):
    r"""Specifies the binlog configuration message.

    """

    def __init__(self):
        r"""
        :param _BinlogSaveDays: Specifies the retention time of binlogs.
        :type BinlogSaveDays: int
        :param _BinlogCrossRegionsEnable: Whether binlog cross-region backup is enabled.
        :type BinlogCrossRegionsEnable: str
        :param _BinlogCrossRegions: binlog in a different region.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BinlogCrossRegions: list of str
        """
        self._BinlogSaveDays = None
        self._BinlogCrossRegionsEnable = None
        self._BinlogCrossRegions = None

    @property
    def BinlogSaveDays(self):
        r"""Specifies the retention time of binlogs.
        :rtype: int
        """
        return self._BinlogSaveDays

    @BinlogSaveDays.setter
    def BinlogSaveDays(self, BinlogSaveDays):
        self._BinlogSaveDays = BinlogSaveDays

    @property
    def BinlogCrossRegionsEnable(self):
        r"""Whether binlog cross-region backup is enabled.
        :rtype: str
        """
        return self._BinlogCrossRegionsEnable

    @BinlogCrossRegionsEnable.setter
    def BinlogCrossRegionsEnable(self, BinlogCrossRegionsEnable):
        self._BinlogCrossRegionsEnable = BinlogCrossRegionsEnable

    @property
    def BinlogCrossRegions(self):
        r"""binlog in a different region.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._BinlogCrossRegions

    @BinlogCrossRegions.setter
    def BinlogCrossRegions(self, BinlogCrossRegions):
        self._BinlogCrossRegions = BinlogCrossRegions


    def _deserialize(self, params):
        self._BinlogSaveDays = params.get("BinlogSaveDays")
        self._BinlogCrossRegionsEnable = params.get("BinlogCrossRegionsEnable")
        self._BinlogCrossRegions = params.get("BinlogCrossRegions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BinlogItem(AbstractModel):
    r"""Binlog description

    """

    def __init__(self):
        r"""
        :param _FileName: Binlog filename
        :type FileName: str
        :param _FileSize: File size in bytes
        :type FileSize: int
        :param _StartTime: Transaction start time
        :type StartTime: str
        :param _FinishTime: Transaction end time
        :type FinishTime: str
        :param _BinlogId: Binlog file ID
        :type BinlogId: int
        """
        self._FileName = None
        self._FileSize = None
        self._StartTime = None
        self._FinishTime = None
        self._BinlogId = None

    @property
    def FileName(self):
        r"""Binlog filename
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileSize(self):
        r"""File size in bytes
        :rtype: int
        """
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def StartTime(self):
        r"""Transaction start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def FinishTime(self):
        r"""Transaction end time
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def BinlogId(self):
        r"""Binlog file ID
        :rtype: int
        """
        return self._BinlogId

    @BinlogId.setter
    def BinlogId(self, BinlogId):
        self._BinlogId = BinlogId


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._FileSize = params.get("FileSize")
        self._StartTime = params.get("StartTime")
        self._FinishTime = params.get("FinishTime")
        self._BinlogId = params.get("BinlogId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BizTaskInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _ID: 
        :type ID: int
        :param _AppId: 
        :type AppId: int
        :param _ClusterId: 
        :type ClusterId: str
        :param _Region: Region
        :type Region: str
        :param _CreateTime: 
        :type CreateTime: str
        :param _DelayTime: Specifies the delayed execution time.
        :type DelayTime: str
        :param _ErrMsg: Task failure information.
        :type ErrMsg: str
        :param _FlowId: 
        :type FlowId: int
        :param _Input: 
        :type Input: str
        :param _InstanceGrpId: 
        :type InstanceGrpId: str
        :param _InstanceGroupId: 
        :type InstanceGroupId: str
        :param _InstanceId: 
        :type InstanceId: str
        :param _ObjectId: 
        :type ObjectId: str
        :param _ObjectType: 
        :type ObjectType: str
        :param _Operator: 
        :type Operator: str
        :param _Output: 
        :type Output: str
        :param _Status: 
        :type Status: str
        :param _TaskType: 
        :type TaskType: str
        :param _TriggerTaskId: 
        :type TriggerTaskId: int
        :param _UpdateTime: 
        :type UpdateTime: str
        :param _StartTime: 
        :type StartTime: str
        :param _EndTime: 
        :type EndTime: str
        :param _ClusterName: 
        :type ClusterName: str
        :param _InstanceName: 
        :type InstanceName: str
        :param _Process: 
        :type Process: int
        :param _ModifyParamsData: 
        :type ModifyParamsData: list of ModifyParamsData
        :param _CreateClustersData: Create cluster task information.
        :type CreateClustersData: :class:`tencentcloud.cynosdb.v20190107.models.CreateClustersData`
        :param _RollbackData: Cluster rollback task information.
        :type RollbackData: :class:`tencentcloud.cynosdb.v20190107.models.RollbackData`
        :param _ModifyInstanceData: Instance configuration change task information.
        :type ModifyInstanceData: :class:`tencentcloud.cynosdb.v20190107.models.ModifyInstanceData`
        :param _ManualBackupData: 
        :type ManualBackupData: :class:`tencentcloud.cynosdb.v20190107.models.ManualBackupData`
        :param _ModifyDbVersionData: Modify kernel version task information.
        :type ModifyDbVersionData: :class:`tencentcloud.cynosdb.v20190107.models.ModifyDbVersionData`
        :param _ClusterSlaveData: Cluster availability zone information.
        :type ClusterSlaveData: :class:`tencentcloud.cynosdb.v20190107.models.ClusterSlaveData`
        :param _SwitchClusterLogBin: 
        :type SwitchClusterLogBin: :class:`tencentcloud.cynosdb.v20190107.models.SwitchClusterLogBin`
        :param _ModifyInstanceParamsData: 
        :type ModifyInstanceParamsData: :class:`tencentcloud.cynosdb.v20190107.models.BizTaskModifyParamsData`
        :param _TaskMaintainInfo: Maintenance time.
        :type TaskMaintainInfo: :class:`tencentcloud.cynosdb.v20190107.models.TaskMaintainInfo`
        :param _InstanceCLSDeliveryInfos: Instance log delivery information.

        :type InstanceCLSDeliveryInfos: list of InstanceCLSDeliveryInfo
        :param _TaskProgressInfo: Task progress information.
        :type TaskProgressInfo: :class:`tencentcloud.cynosdb.v20190107.models.TaskProgressInfo`
        """
        self._ID = None
        self._AppId = None
        self._ClusterId = None
        self._Region = None
        self._CreateTime = None
        self._DelayTime = None
        self._ErrMsg = None
        self._FlowId = None
        self._Input = None
        self._InstanceGrpId = None
        self._InstanceGroupId = None
        self._InstanceId = None
        self._ObjectId = None
        self._ObjectType = None
        self._Operator = None
        self._Output = None
        self._Status = None
        self._TaskType = None
        self._TriggerTaskId = None
        self._UpdateTime = None
        self._StartTime = None
        self._EndTime = None
        self._ClusterName = None
        self._InstanceName = None
        self._Process = None
        self._ModifyParamsData = None
        self._CreateClustersData = None
        self._RollbackData = None
        self._ModifyInstanceData = None
        self._ManualBackupData = None
        self._ModifyDbVersionData = None
        self._ClusterSlaveData = None
        self._SwitchClusterLogBin = None
        self._ModifyInstanceParamsData = None
        self._TaskMaintainInfo = None
        self._InstanceCLSDeliveryInfos = None
        self._TaskProgressInfo = None

    @property
    def ID(self):
        r"""
        :rtype: int
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def AppId(self):
        r"""
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ClusterId(self):
        r"""
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def CreateTime(self):
        r"""
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DelayTime(self):
        r"""Specifies the delayed execution time.
        :rtype: str
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def ErrMsg(self):
        r"""Task failure information.
        :rtype: str
        """
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def FlowId(self):
        r"""
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Input(self):
        r"""
        :rtype: str
        """
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def InstanceGrpId(self):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        r"""
        :rtype: str
        """
        return self._InstanceGrpId

    @InstanceGrpId.setter
    def InstanceGrpId(self, InstanceGrpId):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        self._InstanceGrpId = InstanceGrpId

    @property
    def InstanceGroupId(self):
        r"""
        :rtype: str
        """
        return self._InstanceGroupId

    @InstanceGroupId.setter
    def InstanceGroupId(self, InstanceGroupId):
        self._InstanceGroupId = InstanceGroupId

    @property
    def InstanceId(self):
        r"""
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ObjectId(self):
        r"""
        :rtype: str
        """
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def ObjectType(self):
        r"""
        :rtype: str
        """
        return self._ObjectType

    @ObjectType.setter
    def ObjectType(self, ObjectType):
        self._ObjectType = ObjectType

    @property
    def Operator(self):
        r"""
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def Output(self):
        r"""
        :rtype: str
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Status(self):
        r"""
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskType(self):
        r"""
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TriggerTaskId(self):
        r"""
        :rtype: int
        """
        return self._TriggerTaskId

    @TriggerTaskId.setter
    def TriggerTaskId(self, TriggerTaskId):
        self._TriggerTaskId = TriggerTaskId

    @property
    def UpdateTime(self):
        r"""
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def StartTime(self):
        r"""
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ClusterName(self):
        r"""
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def InstanceName(self):
        r"""
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Process(self):
        r"""
        :rtype: int
        """
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def ModifyParamsData(self):
        warnings.warn("parameter `ModifyParamsData` is deprecated", DeprecationWarning) 

        r"""
        :rtype: list of ModifyParamsData
        """
        return self._ModifyParamsData

    @ModifyParamsData.setter
    def ModifyParamsData(self, ModifyParamsData):
        warnings.warn("parameter `ModifyParamsData` is deprecated", DeprecationWarning) 

        self._ModifyParamsData = ModifyParamsData

    @property
    def CreateClustersData(self):
        r"""Create cluster task information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.CreateClustersData`
        """
        return self._CreateClustersData

    @CreateClustersData.setter
    def CreateClustersData(self, CreateClustersData):
        self._CreateClustersData = CreateClustersData

    @property
    def RollbackData(self):
        r"""Cluster rollback task information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.RollbackData`
        """
        return self._RollbackData

    @RollbackData.setter
    def RollbackData(self, RollbackData):
        self._RollbackData = RollbackData

    @property
    def ModifyInstanceData(self):
        r"""Instance configuration change task information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ModifyInstanceData`
        """
        return self._ModifyInstanceData

    @ModifyInstanceData.setter
    def ModifyInstanceData(self, ModifyInstanceData):
        self._ModifyInstanceData = ModifyInstanceData

    @property
    def ManualBackupData(self):
        r"""
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ManualBackupData`
        """
        return self._ManualBackupData

    @ManualBackupData.setter
    def ManualBackupData(self, ManualBackupData):
        self._ManualBackupData = ManualBackupData

    @property
    def ModifyDbVersionData(self):
        r"""Modify kernel version task information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ModifyDbVersionData`
        """
        return self._ModifyDbVersionData

    @ModifyDbVersionData.setter
    def ModifyDbVersionData(self, ModifyDbVersionData):
        self._ModifyDbVersionData = ModifyDbVersionData

    @property
    def ClusterSlaveData(self):
        r"""Cluster availability zone information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ClusterSlaveData`
        """
        return self._ClusterSlaveData

    @ClusterSlaveData.setter
    def ClusterSlaveData(self, ClusterSlaveData):
        self._ClusterSlaveData = ClusterSlaveData

    @property
    def SwitchClusterLogBin(self):
        r"""
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.SwitchClusterLogBin`
        """
        return self._SwitchClusterLogBin

    @SwitchClusterLogBin.setter
    def SwitchClusterLogBin(self, SwitchClusterLogBin):
        self._SwitchClusterLogBin = SwitchClusterLogBin

    @property
    def ModifyInstanceParamsData(self):
        r"""
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.BizTaskModifyParamsData`
        """
        return self._ModifyInstanceParamsData

    @ModifyInstanceParamsData.setter
    def ModifyInstanceParamsData(self, ModifyInstanceParamsData):
        self._ModifyInstanceParamsData = ModifyInstanceParamsData

    @property
    def TaskMaintainInfo(self):
        r"""Maintenance time.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TaskMaintainInfo`
        """
        return self._TaskMaintainInfo

    @TaskMaintainInfo.setter
    def TaskMaintainInfo(self, TaskMaintainInfo):
        self._TaskMaintainInfo = TaskMaintainInfo

    @property
    def InstanceCLSDeliveryInfos(self):
        r"""Instance log delivery information.

        :rtype: list of InstanceCLSDeliveryInfo
        """
        return self._InstanceCLSDeliveryInfos

    @InstanceCLSDeliveryInfos.setter
    def InstanceCLSDeliveryInfos(self, InstanceCLSDeliveryInfos):
        self._InstanceCLSDeliveryInfos = InstanceCLSDeliveryInfos

    @property
    def TaskProgressInfo(self):
        r"""Task progress information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TaskProgressInfo`
        """
        return self._TaskProgressInfo

    @TaskProgressInfo.setter
    def TaskProgressInfo(self, TaskProgressInfo):
        self._TaskProgressInfo = TaskProgressInfo


    def _deserialize(self, params):
        self._ID = params.get("ID")
        self._AppId = params.get("AppId")
        self._ClusterId = params.get("ClusterId")
        self._Region = params.get("Region")
        self._CreateTime = params.get("CreateTime")
        self._DelayTime = params.get("DelayTime")
        self._ErrMsg = params.get("ErrMsg")
        self._FlowId = params.get("FlowId")
        self._Input = params.get("Input")
        self._InstanceGrpId = params.get("InstanceGrpId")
        self._InstanceGroupId = params.get("InstanceGroupId")
        self._InstanceId = params.get("InstanceId")
        self._ObjectId = params.get("ObjectId")
        self._ObjectType = params.get("ObjectType")
        self._Operator = params.get("Operator")
        self._Output = params.get("Output")
        self._Status = params.get("Status")
        self._TaskType = params.get("TaskType")
        self._TriggerTaskId = params.get("TriggerTaskId")
        self._UpdateTime = params.get("UpdateTime")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ClusterName = params.get("ClusterName")
        self._InstanceName = params.get("InstanceName")
        self._Process = params.get("Process")
        if params.get("ModifyParamsData") is not None:
            self._ModifyParamsData = []
            for item in params.get("ModifyParamsData"):
                obj = ModifyParamsData()
                obj._deserialize(item)
                self._ModifyParamsData.append(obj)
        if params.get("CreateClustersData") is not None:
            self._CreateClustersData = CreateClustersData()
            self._CreateClustersData._deserialize(params.get("CreateClustersData"))
        if params.get("RollbackData") is not None:
            self._RollbackData = RollbackData()
            self._RollbackData._deserialize(params.get("RollbackData"))
        if params.get("ModifyInstanceData") is not None:
            self._ModifyInstanceData = ModifyInstanceData()
            self._ModifyInstanceData._deserialize(params.get("ModifyInstanceData"))
        if params.get("ManualBackupData") is not None:
            self._ManualBackupData = ManualBackupData()
            self._ManualBackupData._deserialize(params.get("ManualBackupData"))
        if params.get("ModifyDbVersionData") is not None:
            self._ModifyDbVersionData = ModifyDbVersionData()
            self._ModifyDbVersionData._deserialize(params.get("ModifyDbVersionData"))
        if params.get("ClusterSlaveData") is not None:
            self._ClusterSlaveData = ClusterSlaveData()
            self._ClusterSlaveData._deserialize(params.get("ClusterSlaveData"))
        if params.get("SwitchClusterLogBin") is not None:
            self._SwitchClusterLogBin = SwitchClusterLogBin()
            self._SwitchClusterLogBin._deserialize(params.get("SwitchClusterLogBin"))
        if params.get("ModifyInstanceParamsData") is not None:
            self._ModifyInstanceParamsData = BizTaskModifyParamsData()
            self._ModifyInstanceParamsData._deserialize(params.get("ModifyInstanceParamsData"))
        if params.get("TaskMaintainInfo") is not None:
            self._TaskMaintainInfo = TaskMaintainInfo()
            self._TaskMaintainInfo._deserialize(params.get("TaskMaintainInfo"))
        if params.get("InstanceCLSDeliveryInfos") is not None:
            self._InstanceCLSDeliveryInfos = []
            for item in params.get("InstanceCLSDeliveryInfos"):
                obj = InstanceCLSDeliveryInfo()
                obj._deserialize(item)
                self._InstanceCLSDeliveryInfos.append(obj)
        if params.get("TaskProgressInfo") is not None:
            self._TaskProgressInfo = TaskProgressInfo()
            self._TaskProgressInfo._deserialize(params.get("TaskProgressInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BizTaskModifyInstanceParam(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _InstanceId: 
        :type InstanceId: str
        :param _ModifyInstanceParamList: Details of instance parameter modification task.
        :type ModifyInstanceParamList: list of ModifyParamItem
        """
        self._InstanceId = None
        self._ModifyInstanceParamList = None

    @property
    def InstanceId(self):
        r"""
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ModifyInstanceParamList(self):
        r"""Details of instance parameter modification task.
        :rtype: list of ModifyParamItem
        """
        return self._ModifyInstanceParamList

    @ModifyInstanceParamList.setter
    def ModifyInstanceParamList(self, ModifyInstanceParamList):
        self._ModifyInstanceParamList = ModifyInstanceParamList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("ModifyInstanceParamList") is not None:
            self._ModifyInstanceParamList = []
            for item in params.get("ModifyInstanceParamList"):
                obj = ModifyParamItem()
                obj._deserialize(item)
                self._ModifyInstanceParamList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BizTaskModifyParamsData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _ClusterId: 
        :type ClusterId: str
        :param _ClusterParamList: Cluster parameter modification data.
        :type ClusterParamList: list of ModifyParamItem
        :param _ModifyInstanceParams: Instance parameter modification data.
        :type ModifyInstanceParams: list of BizTaskModifyInstanceParam
        """
        self._ClusterId = None
        self._ClusterParamList = None
        self._ModifyInstanceParams = None

    @property
    def ClusterId(self):
        r"""
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterParamList(self):
        r"""Cluster parameter modification data.
        :rtype: list of ModifyParamItem
        """
        return self._ClusterParamList

    @ClusterParamList.setter
    def ClusterParamList(self, ClusterParamList):
        self._ClusterParamList = ClusterParamList

    @property
    def ModifyInstanceParams(self):
        r"""Instance parameter modification data.
        :rtype: list of BizTaskModifyInstanceParam
        """
        return self._ModifyInstanceParams

    @ModifyInstanceParams.setter
    def ModifyInstanceParams(self, ModifyInstanceParams):
        self._ModifyInstanceParams = ModifyInstanceParams


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("ClusterParamList") is not None:
            self._ClusterParamList = []
            for item in params.get("ClusterParamList"):
                obj = ModifyParamItem()
                obj._deserialize(item)
                self._ClusterParamList.append(obj)
        if params.get("ModifyInstanceParams") is not None:
            self._ModifyInstanceParams = []
            for item in params.get("ModifyInstanceParams"):
                obj = BizTaskModifyInstanceParam()
                obj._deserialize(item)
                self._ModifyInstanceParams.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CLSInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _TopicOperation: 
        :type TopicOperation: str
        :param _GroupOperation: 
        :type GroupOperation: str
        :param _Region: 
        :type Region: str
        :param _TopicId: 
        :type TopicId: str
        :param _TopicName: 
        :type TopicName: str
        :param _GroupId: 
        :type GroupId: str
        :param _GroupName: 
        :type GroupName: str
        """
        self._TopicOperation = None
        self._GroupOperation = None
        self._Region = None
        self._TopicId = None
        self._TopicName = None
        self._GroupId = None
        self._GroupName = None

    @property
    def TopicOperation(self):
        r"""
        :rtype: str
        """
        return self._TopicOperation

    @TopicOperation.setter
    def TopicOperation(self, TopicOperation):
        self._TopicOperation = TopicOperation

    @property
    def GroupOperation(self):
        r"""
        :rtype: str
        """
        return self._GroupOperation

    @GroupOperation.setter
    def GroupOperation(self, GroupOperation):
        self._GroupOperation = GroupOperation

    @property
    def Region(self):
        r"""
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def TopicId(self):
        r"""
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def GroupId(self):
        r"""
        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        r"""
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName


    def _deserialize(self, params):
        self._TopicOperation = params.get("TopicOperation")
        self._GroupOperation = params.get("GroupOperation")
        self._Region = params.get("Region")
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseAuditServiceRequest(AbstractModel):
    r"""CloseAuditService request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseAuditServiceResponse(AbstractModel):
    r"""CloseAuditService response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CloseClusterPasswordComplexityRequest(AbstractModel):
    r"""CloseClusterPasswordComplexity request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIds: Cluster IDs in array
        :type ClusterIds: list of str
        """
        self._ClusterIds = None

    @property
    def ClusterIds(self):
        r"""Cluster IDs in array
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseClusterPasswordComplexityResponse(AbstractModel):
    r"""CloseClusterPasswordComplexity response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class CloseProxyEndPointRequest(AbstractModel):
    r"""CloseProxyEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ProxyGroupId: Database proxy group ID.
        :type ProxyGroupId: str
        """
        self._ClusterId = None
        self._ProxyGroupId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID.
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseProxyEndPointResponse(AbstractModel):
    r"""CloseProxyEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async process ID.
        :type FlowId: int
        :param _TaskId: Asynchronous Task ID
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async process ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Asynchronous Task ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CloseProxyRequest(AbstractModel):
    r"""CloseProxy request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _OnlyCloseRW: Whether only to disable read/write separation. Valid values: `true`, `false`.
        :type OnlyCloseRW: bool
        """
        self._ClusterId = None
        self._ProxyGroupId = None
        self._OnlyCloseRW = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def OnlyCloseRW(self):
        r"""Whether only to disable read/write separation. Valid values: `true`, `false`.
        :rtype: bool
        """
        return self._OnlyCloseRW

    @OnlyCloseRW.setter
    def OnlyCloseRW(self, OnlyCloseRW):
        self._OnlyCloseRW = OnlyCloseRW


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._OnlyCloseRW = params.get("OnlyCloseRW")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseProxyResponse(AbstractModel):
    r"""CloseProxy response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async flow ID
        :type FlowId: int
        :param _TaskId: Async task ID
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CloseSSLRequest(AbstractModel):
    r"""CloseSSL request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._ClusterId = None
        self._InstanceId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseSSLResponse(AbstractModel):
    r"""CloseSSL response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Process ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type FlowId: int
        :param _TaskId: Task ID.

Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Process ID

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Task ID.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CloseWanRequest(AbstractModel):
    r"""CloseWan request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceGrpId: Instance group ID
        :type InstanceGrpId: str
        """
        self._InstanceGrpId = None

    @property
    def InstanceGrpId(self):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        r"""Instance group ID
        :rtype: str
        """
        return self._InstanceGrpId

    @InstanceGrpId.setter
    def InstanceGrpId(self, InstanceGrpId):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        self._InstanceGrpId = InstanceGrpId


    def _deserialize(self, params):
        self._InstanceGrpId = params.get("InstanceGrpId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloseWanResponse(AbstractModel):
    r"""CloseWan response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class ClusterInstanceDetail(AbstractModel):
    r"""Cluster instance information

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _InstanceType: Engine type
        :type InstanceType: str
        :param _InstanceStatus: Instance status
        :type InstanceStatus: str
        :param _InstanceStatusDesc: Instance status description
        :type InstanceStatusDesc: str
        :param _InstanceCpu: Number of CPU cores
        :type InstanceCpu: int
        :param _InstanceMemory: Memory
        :type InstanceMemory: int
        :param _InstanceStorage: Disk
        :type InstanceStorage: int
        :param _InstanceRole: Instance role
        :type InstanceRole: str
        :param _MaintainStartTime: Execution start time (seconds from 0 o'clock).	
        :type MaintainStartTime: int
        :param _MaintainDuration: Specifies the continuous time. the unit is second.	
        :type MaintainDuration: int
        :param _MaintainWeekDays: Specifies the time when it can be executed. valid values: ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"].
        :type MaintainWeekDays: list of str
        :param _ServerlessStatus: serverless instance substatus.
        :type ServerlessStatus: str
        :param _InstanceTasks: Instance task information.
        :type InstanceTasks: list of ObjectTask
        :param _InstanceDeviceType: Instance machine type.
        :type InstanceDeviceType: str
        :param _InstanceStorageType: Instance storage type.
        :type InstanceStorageType: str
        :param _DbMode: Database type.
        :type DbMode: str
        :param _NodeList: Node list
        :type NodeList: list of str
        """
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceType = None
        self._InstanceStatus = None
        self._InstanceStatusDesc = None
        self._InstanceCpu = None
        self._InstanceMemory = None
        self._InstanceStorage = None
        self._InstanceRole = None
        self._MaintainStartTime = None
        self._MaintainDuration = None
        self._MaintainWeekDays = None
        self._ServerlessStatus = None
        self._InstanceTasks = None
        self._InstanceDeviceType = None
        self._InstanceStorageType = None
        self._DbMode = None
        self._NodeList = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceType(self):
        r"""Engine type
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceStatus(self):
        r"""Instance status
        :rtype: str
        """
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def InstanceStatusDesc(self):
        r"""Instance status description
        :rtype: str
        """
        return self._InstanceStatusDesc

    @InstanceStatusDesc.setter
    def InstanceStatusDesc(self, InstanceStatusDesc):
        self._InstanceStatusDesc = InstanceStatusDesc

    @property
    def InstanceCpu(self):
        r"""Number of CPU cores
        :rtype: int
        """
        return self._InstanceCpu

    @InstanceCpu.setter
    def InstanceCpu(self, InstanceCpu):
        self._InstanceCpu = InstanceCpu

    @property
    def InstanceMemory(self):
        r"""Memory
        :rtype: int
        """
        return self._InstanceMemory

    @InstanceMemory.setter
    def InstanceMemory(self, InstanceMemory):
        self._InstanceMemory = InstanceMemory

    @property
    def InstanceStorage(self):
        r"""Disk
        :rtype: int
        """
        return self._InstanceStorage

    @InstanceStorage.setter
    def InstanceStorage(self, InstanceStorage):
        self._InstanceStorage = InstanceStorage

    @property
    def InstanceRole(self):
        r"""Instance role
        :rtype: str
        """
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def MaintainStartTime(self):
        r"""Execution start time (seconds from 0 o'clock).	
        :rtype: int
        """
        return self._MaintainStartTime

    @MaintainStartTime.setter
    def MaintainStartTime(self, MaintainStartTime):
        self._MaintainStartTime = MaintainStartTime

    @property
    def MaintainDuration(self):
        r"""Specifies the continuous time. the unit is second.	
        :rtype: int
        """
        return self._MaintainDuration

    @MaintainDuration.setter
    def MaintainDuration(self, MaintainDuration):
        self._MaintainDuration = MaintainDuration

    @property
    def MaintainWeekDays(self):
        r"""Specifies the time when it can be executed. valid values: ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"].
        :rtype: list of str
        """
        return self._MaintainWeekDays

    @MaintainWeekDays.setter
    def MaintainWeekDays(self, MaintainWeekDays):
        self._MaintainWeekDays = MaintainWeekDays

    @property
    def ServerlessStatus(self):
        r"""serverless instance substatus.
        :rtype: str
        """
        return self._ServerlessStatus

    @ServerlessStatus.setter
    def ServerlessStatus(self, ServerlessStatus):
        self._ServerlessStatus = ServerlessStatus

    @property
    def InstanceTasks(self):
        r"""Instance task information.
        :rtype: list of ObjectTask
        """
        return self._InstanceTasks

    @InstanceTasks.setter
    def InstanceTasks(self, InstanceTasks):
        self._InstanceTasks = InstanceTasks

    @property
    def InstanceDeviceType(self):
        r"""Instance machine type.
        :rtype: str
        """
        return self._InstanceDeviceType

    @InstanceDeviceType.setter
    def InstanceDeviceType(self, InstanceDeviceType):
        self._InstanceDeviceType = InstanceDeviceType

    @property
    def InstanceStorageType(self):
        r"""Instance storage type.
        :rtype: str
        """
        return self._InstanceStorageType

    @InstanceStorageType.setter
    def InstanceStorageType(self, InstanceStorageType):
        self._InstanceStorageType = InstanceStorageType

    @property
    def DbMode(self):
        r"""Database type.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def NodeList(self):
        r"""Node list
        :rtype: list of str
        """
        return self._NodeList

    @NodeList.setter
    def NodeList(self, NodeList):
        self._NodeList = NodeList


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceType = params.get("InstanceType")
        self._InstanceStatus = params.get("InstanceStatus")
        self._InstanceStatusDesc = params.get("InstanceStatusDesc")
        self._InstanceCpu = params.get("InstanceCpu")
        self._InstanceMemory = params.get("InstanceMemory")
        self._InstanceStorage = params.get("InstanceStorage")
        self._InstanceRole = params.get("InstanceRole")
        self._MaintainStartTime = params.get("MaintainStartTime")
        self._MaintainDuration = params.get("MaintainDuration")
        self._MaintainWeekDays = params.get("MaintainWeekDays")
        self._ServerlessStatus = params.get("ServerlessStatus")
        if params.get("InstanceTasks") is not None:
            self._InstanceTasks = []
            for item in params.get("InstanceTasks"):
                obj = ObjectTask()
                obj._deserialize(item)
                self._InstanceTasks.append(obj)
        self._InstanceDeviceType = params.get("InstanceDeviceType")
        self._InstanceStorageType = params.get("InstanceStorageType")
        self._DbMode = params.get("DbMode")
        self._NodeList = params.get("NodeList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterReadOnlyValue(AbstractModel):
    r"""Cluster read-only switch list.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ReadOnlyValue: Specifies the value of the read-only switch.
        :type ReadOnlyValue: str
        """
        self._ClusterId = None
        self._ReadOnlyValue = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ReadOnlyValue(self):
        r"""Specifies the value of the read-only switch.
        :rtype: str
        """
        return self._ReadOnlyValue

    @ReadOnlyValue.setter
    def ReadOnlyValue(self, ReadOnlyValue):
        self._ReadOnlyValue = ReadOnlyValue


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ReadOnlyValue = params.get("ReadOnlyValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterSlaveData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _OldMasterZone: Old primary availability zone.
        :type OldMasterZone: str
        :param _OldSlaveZone: 
        :type OldSlaveZone: list of str
        :param _NewMasterZone: New primary availability zone.
        :type NewMasterZone: str
        :param _NewSlaveZone: 
        :type NewSlaveZone: list of str
        :param _NewSlaveZoneAttr: New from availability zone attribute.
        :type NewSlaveZoneAttr: list of SlaveZoneAttrItem
        :param _OldSlaveZoneAttr: Old availability zone attributes.
        :type OldSlaveZoneAttr: list of SlaveZoneAttrItem
        """
        self._OldMasterZone = None
        self._OldSlaveZone = None
        self._NewMasterZone = None
        self._NewSlaveZone = None
        self._NewSlaveZoneAttr = None
        self._OldSlaveZoneAttr = None

    @property
    def OldMasterZone(self):
        r"""Old primary availability zone.
        :rtype: str
        """
        return self._OldMasterZone

    @OldMasterZone.setter
    def OldMasterZone(self, OldMasterZone):
        self._OldMasterZone = OldMasterZone

    @property
    def OldSlaveZone(self):
        r"""
        :rtype: list of str
        """
        return self._OldSlaveZone

    @OldSlaveZone.setter
    def OldSlaveZone(self, OldSlaveZone):
        self._OldSlaveZone = OldSlaveZone

    @property
    def NewMasterZone(self):
        r"""New primary availability zone.
        :rtype: str
        """
        return self._NewMasterZone

    @NewMasterZone.setter
    def NewMasterZone(self, NewMasterZone):
        self._NewMasterZone = NewMasterZone

    @property
    def NewSlaveZone(self):
        r"""
        :rtype: list of str
        """
        return self._NewSlaveZone

    @NewSlaveZone.setter
    def NewSlaveZone(self, NewSlaveZone):
        self._NewSlaveZone = NewSlaveZone

    @property
    def NewSlaveZoneAttr(self):
        r"""New from availability zone attribute.
        :rtype: list of SlaveZoneAttrItem
        """
        return self._NewSlaveZoneAttr

    @NewSlaveZoneAttr.setter
    def NewSlaveZoneAttr(self, NewSlaveZoneAttr):
        self._NewSlaveZoneAttr = NewSlaveZoneAttr

    @property
    def OldSlaveZoneAttr(self):
        r"""Old availability zone attributes.
        :rtype: list of SlaveZoneAttrItem
        """
        return self._OldSlaveZoneAttr

    @OldSlaveZoneAttr.setter
    def OldSlaveZoneAttr(self, OldSlaveZoneAttr):
        self._OldSlaveZoneAttr = OldSlaveZoneAttr


    def _deserialize(self, params):
        self._OldMasterZone = params.get("OldMasterZone")
        self._OldSlaveZone = params.get("OldSlaveZone")
        self._NewMasterZone = params.get("NewMasterZone")
        self._NewSlaveZone = params.get("NewSlaveZone")
        if params.get("NewSlaveZoneAttr") is not None:
            self._NewSlaveZoneAttr = []
            for item in params.get("NewSlaveZoneAttr"):
                obj = SlaveZoneAttrItem()
                obj._deserialize(item)
                self._NewSlaveZoneAttr.append(obj)
        if params.get("OldSlaveZoneAttr") is not None:
            self._OldSlaveZoneAttr = []
            for item in params.get("OldSlaveZoneAttr"):
                obj = SlaveZoneAttrItem()
                obj._deserialize(item)
                self._OldSlaveZoneAttr.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterTaskId(AbstractModel):
    r"""Cluster task ID.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _TaskId: Task ID
        :type TaskId: str
        """
        self._ClusterId = None
        self._TaskId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def TaskId(self):
        r"""Task ID
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyClusterPasswordComplexityRequest(AbstractModel):
    r"""CopyClusterPasswordComplexity request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIds: A parameter used to replicate the array of cluster IDs
        :type ClusterIds: list of str
        :param _SourceClusterId: Cluster ID
        :type SourceClusterId: str
        """
        self._ClusterIds = None
        self._SourceClusterId = None

    @property
    def ClusterIds(self):
        r"""A parameter used to replicate the array of cluster IDs
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def SourceClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._SourceClusterId

    @SourceClusterId.setter
    def SourceClusterId(self, SourceClusterId):
        self._SourceClusterId = SourceClusterId


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._SourceClusterId = params.get("SourceClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyClusterPasswordComplexityResponse(AbstractModel):
    r"""CopyClusterPasswordComplexity response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class CreateAccountsRequest(AbstractModel):
    r"""CreateAccounts request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Accounts: List of new accounts
        :type Accounts: list of NewAccount
        """
        self._ClusterId = None
        self._Accounts = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Accounts(self):
        r"""List of new accounts
        :rtype: list of NewAccount
        """
        return self._Accounts

    @Accounts.setter
    def Accounts(self, Accounts):
        self._Accounts = Accounts


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("Accounts") is not None:
            self._Accounts = []
            for item in params.get("Accounts"):
                obj = NewAccount()
                obj._deserialize(item)
                self._Accounts.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccountsResponse(AbstractModel):
    r"""CreateAccounts response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateAuditRuleTemplateRequest(AbstractModel):
    r"""CreateAuditRuleTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _RuleFilters: Audit rule
        :type RuleFilters: list of RuleFilters
        :param _RuleTemplateName: Rule template name
        :type RuleTemplateName: str
        :param _Description: Rule template description.
        :type Description: str
        """
        self._RuleFilters = None
        self._RuleTemplateName = None
        self._Description = None

    @property
    def RuleFilters(self):
        r"""Audit rule
        :rtype: list of RuleFilters
        """
        return self._RuleFilters

    @RuleFilters.setter
    def RuleFilters(self, RuleFilters):
        self._RuleFilters = RuleFilters

    @property
    def RuleTemplateName(self):
        r"""Rule template name
        :rtype: str
        """
        return self._RuleTemplateName

    @RuleTemplateName.setter
    def RuleTemplateName(self, RuleTemplateName):
        self._RuleTemplateName = RuleTemplateName

    @property
    def Description(self):
        r"""Rule template description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        if params.get("RuleFilters") is not None:
            self._RuleFilters = []
            for item in params.get("RuleFilters"):
                obj = RuleFilters()
                obj._deserialize(item)
                self._RuleFilters.append(obj)
        self._RuleTemplateName = params.get("RuleTemplateName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAuditRuleTemplateResponse(AbstractModel):
    r"""CreateAuditRuleTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RuleTemplateId: The generated rule template ID.
        :type RuleTemplateId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleTemplateId = None
        self._RequestId = None

    @property
    def RuleTemplateId(self):
        r"""The generated rule template ID.
        :rtype: str
        """
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._RequestId = params.get("RequestId")


class CreateBackupRequest(AbstractModel):
    r"""CreateBackup request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BackupType: Backup type. Valid values: `logic` (logic backup), `snapshot` (physical backup)
        :type BackupType: str
        :param _BackupDatabases: Backup database, which is valid when `BackupType` is `logic`.
        :type BackupDatabases: list of str
        :param _BackupTables: Backup table, which is valid when `BackupType` is `logic`.
        :type BackupTables: list of DatabaseTables
        :param _BackupName: Backup name
        :type BackupName: str
        """
        self._ClusterId = None
        self._BackupType = None
        self._BackupDatabases = None
        self._BackupTables = None
        self._BackupName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BackupType(self):
        r"""Backup type. Valid values: `logic` (logic backup), `snapshot` (physical backup)
        :rtype: str
        """
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def BackupDatabases(self):
        r"""Backup database, which is valid when `BackupType` is `logic`.
        :rtype: list of str
        """
        return self._BackupDatabases

    @BackupDatabases.setter
    def BackupDatabases(self, BackupDatabases):
        self._BackupDatabases = BackupDatabases

    @property
    def BackupTables(self):
        r"""Backup table, which is valid when `BackupType` is `logic`.
        :rtype: list of DatabaseTables
        """
        return self._BackupTables

    @BackupTables.setter
    def BackupTables(self, BackupTables):
        self._BackupTables = BackupTables

    @property
    def BackupName(self):
        r"""Backup name
        :rtype: str
        """
        return self._BackupName

    @BackupName.setter
    def BackupName(self, BackupName):
        self._BackupName = BackupName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._BackupType = params.get("BackupType")
        self._BackupDatabases = params.get("BackupDatabases")
        if params.get("BackupTables") is not None:
            self._BackupTables = []
            for item in params.get("BackupTables"):
                obj = DatabaseTables()
                obj._deserialize(item)
                self._BackupTables.append(obj)
        self._BackupName = params.get("BackupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBackupResponse(AbstractModel):
    r"""CreateBackup response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class CreateCLSDeliveryRequest(AbstractModel):
    r"""CreateCLSDelivery request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Intance ID.
        :type InstanceId: str
        :param _CLSInfoList: Log shipping configuration.
        :type CLSInfoList: list of CLSInfo
        :param _LogType: Log type.
        :type LogType: str
        :param _IsInMaintainPeriod: Whether the maintenance time is in operation.
        :type IsInMaintainPeriod: str
        """
        self._InstanceId = None
        self._CLSInfoList = None
        self._LogType = None
        self._IsInMaintainPeriod = None

    @property
    def InstanceId(self):
        r"""Intance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CLSInfoList(self):
        r"""Log shipping configuration.
        :rtype: list of CLSInfo
        """
        return self._CLSInfoList

    @CLSInfoList.setter
    def CLSInfoList(self, CLSInfoList):
        self._CLSInfoList = CLSInfoList

    @property
    def LogType(self):
        r"""Log type.
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def IsInMaintainPeriod(self):
        r"""Whether the maintenance time is in operation.
        :rtype: str
        """
        return self._IsInMaintainPeriod

    @IsInMaintainPeriod.setter
    def IsInMaintainPeriod(self, IsInMaintainPeriod):
        self._IsInMaintainPeriod = IsInMaintainPeriod


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("CLSInfoList") is not None:
            self._CLSInfoList = []
            for item in params.get("CLSInfoList"):
                obj = CLSInfo()
                obj._deserialize(item)
                self._CLSInfoList.append(obj)
        self._LogType = params.get("LogType")
        self._IsInMaintainPeriod = params.get("IsInMaintainPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSDeliveryResponse(AbstractModel):
    r"""CreateCLSDelivery response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Asynchronous task ID.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Asynchronous task ID.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateClusterDatabaseRequest(AbstractModel):
    r"""CreateClusterDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _DbName: Database name
        :type DbName: str
        :param _CharacterSet: Character set
        :type CharacterSet: str
        :param _CollateRule: Collation
        :type CollateRule: str
        :param _UserHostPrivileges: Host permissions of the authorized user
        :type UserHostPrivileges: list of UserHostPrivilege
        :param _Description: Remarks
        :type Description: str
        """
        self._ClusterId = None
        self._DbName = None
        self._CharacterSet = None
        self._CollateRule = None
        self._UserHostPrivileges = None
        self._Description = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def CharacterSet(self):
        r"""Character set
        :rtype: str
        """
        return self._CharacterSet

    @CharacterSet.setter
    def CharacterSet(self, CharacterSet):
        self._CharacterSet = CharacterSet

    @property
    def CollateRule(self):
        r"""Collation
        :rtype: str
        """
        return self._CollateRule

    @CollateRule.setter
    def CollateRule(self, CollateRule):
        self._CollateRule = CollateRule

    @property
    def UserHostPrivileges(self):
        r"""Host permissions of the authorized user
        :rtype: list of UserHostPrivilege
        """
        return self._UserHostPrivileges

    @UserHostPrivileges.setter
    def UserHostPrivileges(self, UserHostPrivileges):
        self._UserHostPrivileges = UserHostPrivileges

    @property
    def Description(self):
        r"""Remarks
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DbName = params.get("DbName")
        self._CharacterSet = params.get("CharacterSet")
        self._CollateRule = params.get("CollateRule")
        if params.get("UserHostPrivileges") is not None:
            self._UserHostPrivileges = []
            for item in params.get("UserHostPrivileges"):
                obj = UserHostPrivilege()
                obj._deserialize(item)
                self._UserHostPrivileges.append(obj)
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterDatabaseResponse(AbstractModel):
    r"""CreateClusterDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClustersData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _Cpu: 
        :type Cpu: int
        :param _Memory: 
        :type Memory: int
        :param _StorageLimit: 
        :type StorageLimit: int
        """
        self._Cpu = None
        self._Memory = None
        self._StorageLimit = None

    @property
    def Cpu(self):
        r"""
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def StorageLimit(self):
        r"""
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._StorageLimit = params.get("StorageLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClustersRequest(AbstractModel):
    r"""CreateClusters request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: AZ
        :type Zone: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _SubnetId: Subnet ID
        :type SubnetId: str
        :param _DbType: Database type. Valid values: 
<li> MYSQL </li>
        :type DbType: str
        :param _DbVersion: Database version. Valid values: 
<li> Valid values for `MYSQL`: 5.7 and 8.0 </li>
        :type DbVersion: str
        :param _ProjectId: Project ID.
        :type ProjectId: int
        :param _Cpu: It is required when `DbMode` is set to `NORMAL` or left empty.
Number of CPU cores of normal instance
        :type Cpu: int
        :param _Memory: It is required when `DbMode` is set to `NORMAL` or left empty.
Memory of a non-serverless instance in GB
        :type Memory: int
        :param _InstanceCount: Instance count. valid values: a quantity range from 0 to 16. the default value is 2 (that is, one rw instance + one ro instance). the transmitted n represents 1 rw instance + (n - 1) ro instances (with identical specifications). if a more precise cluster composition collocation is required, please use InstanceInitInfos.
        :type InstanceCount: int
        :param _Storage: This parameter has been deprecated.
Storage capacity in GB
        :type Storage: int
        :param _ClusterName: Cluster name, which can contain less than 64 letters, digits, or symbols (-_.).
        :type ClusterName: str
        :param _AdminPassword: Account password, which must contain 8-64 characters in at least three of the following four types: uppercase letters, lowercase letters, digits, and symbols (~!@#$%^&*_-+=`|\(){}[]:;'<>,.?/).
        :type AdminPassword: str
        :param _Port: Port. Valid range: [0, 65535). Default value: 3306
        :type Port: int
        :param _PayMode: Billing mode. `0`: pay-as-you-go; `1`: monthly subscription. Default value: `0`
        :type PayMode: int
        :param _Count: Number of purchased clusters. Valid range: [1,50]. Default value: 1
        :type Count: int
        :param _RollbackStrategy: Rollback type:
noneRollback: no rollback;
snapRollback: rollback by snapshot;
timeRollback: rollback by time point
        :type RollbackStrategy: str
        :param _RollbackId: `snapshotId` for snapshot rollback or `queryId` for time point rollback. 0 indicates to determine whether the time point is valid
        :type RollbackId: int
        :param _OriginalClusterId: The source cluster ID passed in during rollback to find the source `poolId`
        :type OriginalClusterId: str
        :param _ExpectTime: Specified time for time point rollback or snapshot time for snapshot rollback
        :type ExpectTime: str
        :param _ExpectTimeThresh: This parameter has been deprecated.
Specified allowed time range for time point rollback
        :type ExpectTimeThresh: int
        :param _StorageLimit: Storage upper limit of normal instance in GB
If `DbType` is `MYSQL` and the storage billing mode is monthly subscription, the parameter value can’t exceed the maximum storage corresponding to the CPU and memory specifications.
        :type StorageLimit: int
        :param _TimeSpan: Purchase duration of monthly subscription plan
        :type TimeSpan: int
        :param _TimeUnit: Duration unit of monthly subscription. Valid values: `s`, `d`, `m`, `y`
        :type TimeUnit: str
        :param _AutoRenewFlag: Specifies whether the annual/monthly subscription is auto-renewed. the default value is 0.
0 indicates the default renewal method. 1 means auto-renewal. 2 means no auto-renewal.
        :type AutoRenewFlag: int
        :param _AutoVoucher: Whether to automatically select a voucher. `1`: yes; `0`: no. Default value: `0`
        :type AutoVoucher: int
        :param _HaCount: Number of instances (this parameter has been disused and is retained only for compatibility with existing instances)
        :type HaCount: int
        :param _OrderSource: Order source
        :type OrderSource: str
        :param _ResourceTags: Array of tags to be bound to the created cluster
        :type ResourceTags: list of Tag
        :param _DbMode: Database type
Valid values when `DbType` is `MYSQL` (default value: `NORMAL`):
<li>NORMAL</li>
<li>SERVERLESS</li>
        :type DbMode: str
        :param _MinCpu: This parameter is required if `DbMode` is `SERVERLESS`.
Minimum number of CPU cores. For the value range, see the returned result of `DescribeServerlessInstanceSpecs`.
        :type MinCpu: float
        :param _MaxCpu: This parameter is required if `DbMode` is `SERVERLESS`.
Maximum number of CPU cores. For the value range, see the returned result of `DescribeServerlessInstanceSpecs`.
        :type MaxCpu: float
        :param _AutoPause: This parameter specifies whether the cluster will be automatically paused if `DbMode` is `SERVERLESS`. Valid values:
<li>yes</li>
<li>no</li>
Default value: yes
        :type AutoPause: str
        :param _AutoPauseDelay: This parameter specifies the delay for automatic cluster pause in seconds if `DbMode` is `SERVERLESS`. Value range: [600,691200]
Default value: `600`
        :type AutoPauseDelay: int
        :param _StoragePayMode: The billing mode of cluster storage. Valid values: `0` (pay-as-you-go), `1` (monthly subscription). Default value: `0`.
If `DbType` is `MYSQL` and the billing mode of cluster compute is pay-as-you-go (or the `DbMode` is `SERVERLESS`), the billing mode of cluster storage must be pay-as-you-go.
Clusters with storage billed in monthly subscription can’t be cloned or rolled back.
        :type StoragePayMode: int
        :param _SecurityGroupIds: Array of security group IDs
        :type SecurityGroupIds: list of str
        :param _AlarmPolicyIds: Array of alarm policy IDs
        :type AlarmPolicyIds: list of str
        :param _ClusterParams: Array of parameters. Valid values: `character_set_server` (utf8｜latin1｜gbk｜utf8mb4), `lower_case_table_names`. 0: case-sensitive; 1: case-insensitive).
        :type ClusterParams: list of ParamItem
        :param _DealMode: Transaction mode. Valid values: `0` (place and pay for an order), `1` (place an order)
        :type DealMode: int
        :param _ParamTemplateId: Parameter template ID, which can be obtained by querying parameter template information “DescribeParamTemplates”
        :type ParamTemplateId: int
        :param _SlaveZone: Multi-AZ address
        :type SlaveZone: str
        :param _InstanceInitInfos: Instance initialization configuration information, which is used to select instances with different specifications when purchasing a cluster.
        :type InstanceInitInfos: list of InstanceInitInfo
        """
        self._Zone = None
        self._VpcId = None
        self._SubnetId = None
        self._DbType = None
        self._DbVersion = None
        self._ProjectId = None
        self._Cpu = None
        self._Memory = None
        self._InstanceCount = None
        self._Storage = None
        self._ClusterName = None
        self._AdminPassword = None
        self._Port = None
        self._PayMode = None
        self._Count = None
        self._RollbackStrategy = None
        self._RollbackId = None
        self._OriginalClusterId = None
        self._ExpectTime = None
        self._ExpectTimeThresh = None
        self._StorageLimit = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._AutoRenewFlag = None
        self._AutoVoucher = None
        self._HaCount = None
        self._OrderSource = None
        self._ResourceTags = None
        self._DbMode = None
        self._MinCpu = None
        self._MaxCpu = None
        self._AutoPause = None
        self._AutoPauseDelay = None
        self._StoragePayMode = None
        self._SecurityGroupIds = None
        self._AlarmPolicyIds = None
        self._ClusterParams = None
        self._DealMode = None
        self._ParamTemplateId = None
        self._SlaveZone = None
        self._InstanceInitInfos = None

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def VpcId(self):
        r"""VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def DbType(self):
        r"""Database type. Valid values: 
<li> MYSQL </li>
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def DbVersion(self):
        r"""Database version. Valid values: 
<li> Valid values for `MYSQL`: 5.7 and 8.0 </li>
        :rtype: str
        """
        return self._DbVersion

    @DbVersion.setter
    def DbVersion(self, DbVersion):
        self._DbVersion = DbVersion

    @property
    def ProjectId(self):
        r"""Project ID.
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Cpu(self):
        r"""It is required when `DbMode` is set to `NORMAL` or left empty.
Number of CPU cores of normal instance
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""It is required when `DbMode` is set to `NORMAL` or left empty.
Memory of a non-serverless instance in GB
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def InstanceCount(self):
        r"""Instance count. valid values: a quantity range from 0 to 16. the default value is 2 (that is, one rw instance + one ro instance). the transmitted n represents 1 rw instance + (n - 1) ro instances (with identical specifications). if a more precise cluster composition collocation is required, please use InstanceInitInfos.
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def Storage(self):
        r"""This parameter has been deprecated.
Storage capacity in GB
        :rtype: int
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def ClusterName(self):
        r"""Cluster name, which can contain less than 64 letters, digits, or symbols (-_.).
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def AdminPassword(self):
        r"""Account password, which must contain 8-64 characters in at least three of the following four types: uppercase letters, lowercase letters, digits, and symbols (~!@#$%^&*_-+=`|\(){}[]:;'<>,.?/).
        :rtype: str
        """
        return self._AdminPassword

    @AdminPassword.setter
    def AdminPassword(self, AdminPassword):
        self._AdminPassword = AdminPassword

    @property
    def Port(self):
        r"""Port. Valid range: [0, 65535). Default value: 3306
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def PayMode(self):
        r"""Billing mode. `0`: pay-as-you-go; `1`: monthly subscription. Default value: `0`
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Count(self):
        r"""Number of purchased clusters. Valid range: [1,50]. Default value: 1
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RollbackStrategy(self):
        r"""Rollback type:
noneRollback: no rollback;
snapRollback: rollback by snapshot;
timeRollback: rollback by time point
        :rtype: str
        """
        return self._RollbackStrategy

    @RollbackStrategy.setter
    def RollbackStrategy(self, RollbackStrategy):
        self._RollbackStrategy = RollbackStrategy

    @property
    def RollbackId(self):
        r"""`snapshotId` for snapshot rollback or `queryId` for time point rollback. 0 indicates to determine whether the time point is valid
        :rtype: int
        """
        return self._RollbackId

    @RollbackId.setter
    def RollbackId(self, RollbackId):
        self._RollbackId = RollbackId

    @property
    def OriginalClusterId(self):
        r"""The source cluster ID passed in during rollback to find the source `poolId`
        :rtype: str
        """
        return self._OriginalClusterId

    @OriginalClusterId.setter
    def OriginalClusterId(self, OriginalClusterId):
        self._OriginalClusterId = OriginalClusterId

    @property
    def ExpectTime(self):
        r"""Specified time for time point rollback or snapshot time for snapshot rollback
        :rtype: str
        """
        return self._ExpectTime

    @ExpectTime.setter
    def ExpectTime(self, ExpectTime):
        self._ExpectTime = ExpectTime

    @property
    def ExpectTimeThresh(self):
        r"""This parameter has been deprecated.
Specified allowed time range for time point rollback
        :rtype: int
        """
        return self._ExpectTimeThresh

    @ExpectTimeThresh.setter
    def ExpectTimeThresh(self, ExpectTimeThresh):
        self._ExpectTimeThresh = ExpectTimeThresh

    @property
    def StorageLimit(self):
        r"""Storage upper limit of normal instance in GB
If `DbType` is `MYSQL` and the storage billing mode is monthly subscription, the parameter value can’t exceed the maximum storage corresponding to the CPU and memory specifications.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def TimeSpan(self):
        r"""Purchase duration of monthly subscription plan
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Duration unit of monthly subscription. Valid values: `s`, `d`, `m`, `y`
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def AutoRenewFlag(self):
        r"""Specifies whether the annual/monthly subscription is auto-renewed. the default value is 0.
0 indicates the default renewal method. 1 means auto-renewal. 2 means no auto-renewal.
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def AutoVoucher(self):
        r"""Whether to automatically select a voucher. `1`: yes; `0`: no. Default value: `0`
        :rtype: int
        """
        return self._AutoVoucher

    @AutoVoucher.setter
    def AutoVoucher(self, AutoVoucher):
        self._AutoVoucher = AutoVoucher

    @property
    def HaCount(self):
        r"""Number of instances (this parameter has been disused and is retained only for compatibility with existing instances)
        :rtype: int
        """
        return self._HaCount

    @HaCount.setter
    def HaCount(self, HaCount):
        self._HaCount = HaCount

    @property
    def OrderSource(self):
        r"""Order source
        :rtype: str
        """
        return self._OrderSource

    @OrderSource.setter
    def OrderSource(self, OrderSource):
        self._OrderSource = OrderSource

    @property
    def ResourceTags(self):
        r"""Array of tags to be bound to the created cluster
        :rtype: list of Tag
        """
        return self._ResourceTags

    @ResourceTags.setter
    def ResourceTags(self, ResourceTags):
        self._ResourceTags = ResourceTags

    @property
    def DbMode(self):
        r"""Database type
Valid values when `DbType` is `MYSQL` (default value: `NORMAL`):
<li>NORMAL</li>
<li>SERVERLESS</li>
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def MinCpu(self):
        r"""This parameter is required if `DbMode` is `SERVERLESS`.
Minimum number of CPU cores. For the value range, see the returned result of `DescribeServerlessInstanceSpecs`.
        :rtype: float
        """
        return self._MinCpu

    @MinCpu.setter
    def MinCpu(self, MinCpu):
        self._MinCpu = MinCpu

    @property
    def MaxCpu(self):
        r"""This parameter is required if `DbMode` is `SERVERLESS`.
Maximum number of CPU cores. For the value range, see the returned result of `DescribeServerlessInstanceSpecs`.
        :rtype: float
        """
        return self._MaxCpu

    @MaxCpu.setter
    def MaxCpu(self, MaxCpu):
        self._MaxCpu = MaxCpu

    @property
    def AutoPause(self):
        r"""This parameter specifies whether the cluster will be automatically paused if `DbMode` is `SERVERLESS`. Valid values:
<li>yes</li>
<li>no</li>
Default value: yes
        :rtype: str
        """
        return self._AutoPause

    @AutoPause.setter
    def AutoPause(self, AutoPause):
        self._AutoPause = AutoPause

    @property
    def AutoPauseDelay(self):
        r"""This parameter specifies the delay for automatic cluster pause in seconds if `DbMode` is `SERVERLESS`. Value range: [600,691200]
Default value: `600`
        :rtype: int
        """
        return self._AutoPauseDelay

    @AutoPauseDelay.setter
    def AutoPauseDelay(self, AutoPauseDelay):
        self._AutoPauseDelay = AutoPauseDelay

    @property
    def StoragePayMode(self):
        r"""The billing mode of cluster storage. Valid values: `0` (pay-as-you-go), `1` (monthly subscription). Default value: `0`.
If `DbType` is `MYSQL` and the billing mode of cluster compute is pay-as-you-go (or the `DbMode` is `SERVERLESS`), the billing mode of cluster storage must be pay-as-you-go.
Clusters with storage billed in monthly subscription can’t be cloned or rolled back.
        :rtype: int
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def SecurityGroupIds(self):
        r"""Array of security group IDs
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def AlarmPolicyIds(self):
        r"""Array of alarm policy IDs
        :rtype: list of str
        """
        return self._AlarmPolicyIds

    @AlarmPolicyIds.setter
    def AlarmPolicyIds(self, AlarmPolicyIds):
        self._AlarmPolicyIds = AlarmPolicyIds

    @property
    def ClusterParams(self):
        r"""Array of parameters. Valid values: `character_set_server` (utf8｜latin1｜gbk｜utf8mb4), `lower_case_table_names`. 0: case-sensitive; 1: case-insensitive).
        :rtype: list of ParamItem
        """
        return self._ClusterParams

    @ClusterParams.setter
    def ClusterParams(self, ClusterParams):
        self._ClusterParams = ClusterParams

    @property
    def DealMode(self):
        r"""Transaction mode. Valid values: `0` (place and pay for an order), `1` (place an order)
        :rtype: int
        """
        return self._DealMode

    @DealMode.setter
    def DealMode(self, DealMode):
        self._DealMode = DealMode

    @property
    def ParamTemplateId(self):
        r"""Parameter template ID, which can be obtained by querying parameter template information “DescribeParamTemplates”
        :rtype: int
        """
        return self._ParamTemplateId

    @ParamTemplateId.setter
    def ParamTemplateId(self, ParamTemplateId):
        self._ParamTemplateId = ParamTemplateId

    @property
    def SlaveZone(self):
        r"""Multi-AZ address
        :rtype: str
        """
        return self._SlaveZone

    @SlaveZone.setter
    def SlaveZone(self, SlaveZone):
        self._SlaveZone = SlaveZone

    @property
    def InstanceInitInfos(self):
        r"""Instance initialization configuration information, which is used to select instances with different specifications when purchasing a cluster.
        :rtype: list of InstanceInitInfo
        """
        return self._InstanceInitInfos

    @InstanceInitInfos.setter
    def InstanceInitInfos(self, InstanceInitInfos):
        self._InstanceInitInfos = InstanceInitInfos


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._DbType = params.get("DbType")
        self._DbVersion = params.get("DbVersion")
        self._ProjectId = params.get("ProjectId")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._InstanceCount = params.get("InstanceCount")
        self._Storage = params.get("Storage")
        self._ClusterName = params.get("ClusterName")
        self._AdminPassword = params.get("AdminPassword")
        self._Port = params.get("Port")
        self._PayMode = params.get("PayMode")
        self._Count = params.get("Count")
        self._RollbackStrategy = params.get("RollbackStrategy")
        self._RollbackId = params.get("RollbackId")
        self._OriginalClusterId = params.get("OriginalClusterId")
        self._ExpectTime = params.get("ExpectTime")
        self._ExpectTimeThresh = params.get("ExpectTimeThresh")
        self._StorageLimit = params.get("StorageLimit")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._AutoVoucher = params.get("AutoVoucher")
        self._HaCount = params.get("HaCount")
        self._OrderSource = params.get("OrderSource")
        if params.get("ResourceTags") is not None:
            self._ResourceTags = []
            for item in params.get("ResourceTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ResourceTags.append(obj)
        self._DbMode = params.get("DbMode")
        self._MinCpu = params.get("MinCpu")
        self._MaxCpu = params.get("MaxCpu")
        self._AutoPause = params.get("AutoPause")
        self._AutoPauseDelay = params.get("AutoPauseDelay")
        self._StoragePayMode = params.get("StoragePayMode")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._AlarmPolicyIds = params.get("AlarmPolicyIds")
        if params.get("ClusterParams") is not None:
            self._ClusterParams = []
            for item in params.get("ClusterParams"):
                obj = ParamItem()
                obj._deserialize(item)
                self._ClusterParams.append(obj)
        self._DealMode = params.get("DealMode")
        self._ParamTemplateId = params.get("ParamTemplateId")
        self._SlaveZone = params.get("SlaveZone")
        if params.get("InstanceInitInfos") is not None:
            self._InstanceInitInfos = []
            for item in params.get("InstanceInitInfos"):
                obj = InstanceInitInfo()
                obj._deserialize(item)
                self._InstanceInitInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClustersResponse(AbstractModel):
    r"""CreateClusters response structure.

    """

    def __init__(self):
        r"""
        :param _TranId: Frozen transaction ID.
        :type TranId: str
        :param _DealNames: Order ID
        :type DealNames: list of str
        :param _ResourceIds: Resource ID list (this field is no longer maintained. please use the dealNames field and the DescribeResourcesByDealName query API to obtain resource ids.).
        :type ResourceIds: list of str
        :param _ClusterIds: Cluster ID list. this field is no longer maintained. please use the dealNames field and the DescribeResourcesByDealName query API to get the cluster ID.
        :type ClusterIds: list of str
        :param _BigDealIds: Big order ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type BigDealIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TranId = None
        self._DealNames = None
        self._ResourceIds = None
        self._ClusterIds = None
        self._BigDealIds = None
        self._RequestId = None

    @property
    def TranId(self):
        r"""Frozen transaction ID.
        :rtype: str
        """
        return self._TranId

    @TranId.setter
    def TranId(self, TranId):
        self._TranId = TranId

    @property
    def DealNames(self):
        r"""Order ID
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def ResourceIds(self):
        r"""Resource ID list (this field is no longer maintained. please use the dealNames field and the DescribeResourcesByDealName query API to obtain resource ids.).
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ClusterIds(self):
        r"""Cluster ID list. this field is no longer maintained. please use the dealNames field and the DescribeResourcesByDealName query API to get the cluster ID.
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def BigDealIds(self):
        r"""Big order ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._BigDealIds

    @BigDealIds.setter
    def BigDealIds(self, BigDealIds):
        self._BigDealIds = BigDealIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TranId = params.get("TranId")
        self._DealNames = params.get("DealNames")
        self._ResourceIds = params.get("ResourceIds")
        self._ClusterIds = params.get("ClusterIds")
        self._BigDealIds = params.get("BigDealIds")
        self._RequestId = params.get("RequestId")


class CreateIntegrateClusterRequest(AbstractModel):
    r"""CreateIntegrateCluster request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: Availability zone
        :type Zone: str
        :param _VpcId: Specifies the ID of the VPC network it belongs to.
        :type VpcId: str
        :param _SubnetId: Subnet ID.
        :type SubnetId: str
        :param _DbVersion: Database version. valid values:. 
<li>Specifies the available values for MYSQL: 5.7, 8.0.</li>.
        :type DbVersion: str
        :param _ProjectId: Project ID
        :type ProjectId: int
        :param _ClusterName: Cluster name, length less than 64 characters. each character value ranges from uppercase/lowercase letters, digits, special symbols ('-','_','.').
        :type ClusterName: str
        :param _AdminPassword: Account password (8-64 characters, a combination of uppercase and lowercase letters, digits and symbols ~!@#$%^&*_-+=`|\(){}[]:;'<>,.?/ with any three types).
        :type AdminPassword: str
        :param _Port: Port, default 3306, in the range of [0, 65535).
        :type Port: int
        :param _PayMode: Billing mode. 0: pay-as-you-go; 1: monthly subscription. default is pay-as-you-go.
        :type PayMode: int
        :param _Count: Number of clusters to purchase. value range: [1,3]. default is 1.
        :type Count: int
        :param _StorageLimit: Maximum storage limit of a regular instance, in GB.
When DbType is MYSQL and the storage billing mode is prepaid, this parameter should not exceed the maximum storage specification corresponding to cpu and memory.
        :type StorageLimit: int
        :param _TimeSpan: Specifies the annual and monthly subscription duration.
        :type TimeSpan: int
        :param _TimeUnit: Specifies the measurement unit for annual and monthly subscription duration. valid values: 's', 'd', 'm', 'y'.
        :type TimeUnit: str
        :param _AutoRenewFlag: Whether annual/monthly subscription is auto-renewed. default value is 0.
0 identifies the default renewal method, 1 means auto-renew, 2 indicates no auto-renewal.
        :type AutoRenewFlag: int
        :param _AutoVoucher: Whether to automatically select a voucher. 1: yes; 0: no. default value: 0.
        :type AutoVoucher: int
        :param _ResourceTags: Specifies the tag array information that needs to be bound during cluster creation.
        :type ResourceTags: list of Tag
        :param _StoragePayMode: Specifies the cluster storage billing mode. 0: pay-as-you-go; 1: monthly subscription. default is pay-as-you-go.
When DbType is MYSQL and the cluster billing mode for computing is postpaid (including DbMode as SERVERLESS), the storage billing mode can only be pay-as-you-go.
Rollback and clone do not support monthly subscription storage.
        :type StoragePayMode: int
        :param _SecurityGroupIds: Security group id array.
        :type SecurityGroupIds: list of str
        :param _AlarmPolicyIds: Specifies the Alarm policy Id array.
        :type AlarmPolicyIds: list of str
        :param _ClusterParams: Parameter array, temporarily supports character_set_server (utf8|latin1|gbk|utf8mb4), lower_case_table_names. valid values: 1 (case-insensitive), 0 (case-sensitive).
        :type ClusterParams: list of ParamItem
        :param _DealMode: Transaction mode. valid values: 0 (place order and pay), 1 (place order).
        :type DealMode: int
        :param _ParamTemplateId: Parameter template ID. can be obtained through querying parameter template information DescribeParamTemplates.
        :type ParamTemplateId: int
        :param _SlaveZone: Multi-AZ address.
        :type SlaveZone: str
        :param _InstanceInitInfos: Initializes configuration information, mainly used to purchase clusters with different specification instances.
        :type InstanceInitInfos: list of IntegrateInstanceInfo
        :param _GdnId: Global database unique identifier.
        :type GdnId: str
        :param _ProxyConfig: Database proxy configuration.
        :type ProxyConfig: :class:`tencentcloud.cynosdb.v20190107.models.ProxyConfigInfo`
        :param _AutoArchive: Specifies whether to automatically archive.
        :type AutoArchive: str
        :param _AutoArchiveDelayHours: Processing time after pausing.
        :type AutoArchiveDelayHours: int
        :param _EncryptMethod: Encryption method (consists of encryption algorithm and key pair version).
        :type EncryptMethod: str
        :param _IntegrateCreateClusterConfig: Describes the cluster configuration information.
        :type IntegrateCreateClusterConfig: :class:`tencentcloud.cynosdb.v20190107.models.IntegrateCreateClusterConfig`
        :param _StorageVersion: Storage architecture type. valid values: 1.0/2.0. default value: 1.0.
        :type StorageVersion: str
        """
        self._Zone = None
        self._VpcId = None
        self._SubnetId = None
        self._DbVersion = None
        self._ProjectId = None
        self._ClusterName = None
        self._AdminPassword = None
        self._Port = None
        self._PayMode = None
        self._Count = None
        self._StorageLimit = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._AutoRenewFlag = None
        self._AutoVoucher = None
        self._ResourceTags = None
        self._StoragePayMode = None
        self._SecurityGroupIds = None
        self._AlarmPolicyIds = None
        self._ClusterParams = None
        self._DealMode = None
        self._ParamTemplateId = None
        self._SlaveZone = None
        self._InstanceInitInfos = None
        self._GdnId = None
        self._ProxyConfig = None
        self._AutoArchive = None
        self._AutoArchiveDelayHours = None
        self._EncryptMethod = None
        self._IntegrateCreateClusterConfig = None
        self._StorageVersion = None

    @property
    def Zone(self):
        r"""Availability zone
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def VpcId(self):
        r"""Specifies the ID of the VPC network it belongs to.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def DbVersion(self):
        r"""Database version. valid values:. 
<li>Specifies the available values for MYSQL: 5.7, 8.0.</li>.
        :rtype: str
        """
        return self._DbVersion

    @DbVersion.setter
    def DbVersion(self, DbVersion):
        self._DbVersion = DbVersion

    @property
    def ProjectId(self):
        r"""Project ID
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ClusterName(self):
        r"""Cluster name, length less than 64 characters. each character value ranges from uppercase/lowercase letters, digits, special symbols ('-','_','.').
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def AdminPassword(self):
        r"""Account password (8-64 characters, a combination of uppercase and lowercase letters, digits and symbols ~!@#$%^&*_-+=`|\(){}[]:;'<>,.?/ with any three types).
        :rtype: str
        """
        return self._AdminPassword

    @AdminPassword.setter
    def AdminPassword(self, AdminPassword):
        self._AdminPassword = AdminPassword

    @property
    def Port(self):
        r"""Port, default 3306, in the range of [0, 65535).
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def PayMode(self):
        r"""Billing mode. 0: pay-as-you-go; 1: monthly subscription. default is pay-as-you-go.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Count(self):
        r"""Number of clusters to purchase. value range: [1,3]. default is 1.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def StorageLimit(self):
        r"""Maximum storage limit of a regular instance, in GB.
When DbType is MYSQL and the storage billing mode is prepaid, this parameter should not exceed the maximum storage specification corresponding to cpu and memory.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def TimeSpan(self):
        r"""Specifies the annual and monthly subscription duration.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Specifies the measurement unit for annual and monthly subscription duration. valid values: 's', 'd', 'm', 'y'.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def AutoRenewFlag(self):
        r"""Whether annual/monthly subscription is auto-renewed. default value is 0.
0 identifies the default renewal method, 1 means auto-renew, 2 indicates no auto-renewal.
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def AutoVoucher(self):
        r"""Whether to automatically select a voucher. 1: yes; 0: no. default value: 0.
        :rtype: int
        """
        return self._AutoVoucher

    @AutoVoucher.setter
    def AutoVoucher(self, AutoVoucher):
        self._AutoVoucher = AutoVoucher

    @property
    def ResourceTags(self):
        r"""Specifies the tag array information that needs to be bound during cluster creation.
        :rtype: list of Tag
        """
        return self._ResourceTags

    @ResourceTags.setter
    def ResourceTags(self, ResourceTags):
        self._ResourceTags = ResourceTags

    @property
    def StoragePayMode(self):
        r"""Specifies the cluster storage billing mode. 0: pay-as-you-go; 1: monthly subscription. default is pay-as-you-go.
When DbType is MYSQL and the cluster billing mode for computing is postpaid (including DbMode as SERVERLESS), the storage billing mode can only be pay-as-you-go.
Rollback and clone do not support monthly subscription storage.
        :rtype: int
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def SecurityGroupIds(self):
        r"""Security group id array.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def AlarmPolicyIds(self):
        r"""Specifies the Alarm policy Id array.
        :rtype: list of str
        """
        return self._AlarmPolicyIds

    @AlarmPolicyIds.setter
    def AlarmPolicyIds(self, AlarmPolicyIds):
        self._AlarmPolicyIds = AlarmPolicyIds

    @property
    def ClusterParams(self):
        r"""Parameter array, temporarily supports character_set_server (utf8|latin1|gbk|utf8mb4), lower_case_table_names. valid values: 1 (case-insensitive), 0 (case-sensitive).
        :rtype: list of ParamItem
        """
        return self._ClusterParams

    @ClusterParams.setter
    def ClusterParams(self, ClusterParams):
        self._ClusterParams = ClusterParams

    @property
    def DealMode(self):
        r"""Transaction mode. valid values: 0 (place order and pay), 1 (place order).
        :rtype: int
        """
        return self._DealMode

    @DealMode.setter
    def DealMode(self, DealMode):
        self._DealMode = DealMode

    @property
    def ParamTemplateId(self):
        r"""Parameter template ID. can be obtained through querying parameter template information DescribeParamTemplates.
        :rtype: int
        """
        return self._ParamTemplateId

    @ParamTemplateId.setter
    def ParamTemplateId(self, ParamTemplateId):
        self._ParamTemplateId = ParamTemplateId

    @property
    def SlaveZone(self):
        r"""Multi-AZ address.
        :rtype: str
        """
        return self._SlaveZone

    @SlaveZone.setter
    def SlaveZone(self, SlaveZone):
        self._SlaveZone = SlaveZone

    @property
    def InstanceInitInfos(self):
        r"""Initializes configuration information, mainly used to purchase clusters with different specification instances.
        :rtype: list of IntegrateInstanceInfo
        """
        return self._InstanceInitInfos

    @InstanceInitInfos.setter
    def InstanceInitInfos(self, InstanceInitInfos):
        self._InstanceInitInfos = InstanceInitInfos

    @property
    def GdnId(self):
        r"""Global database unique identifier.
        :rtype: str
        """
        return self._GdnId

    @GdnId.setter
    def GdnId(self, GdnId):
        self._GdnId = GdnId

    @property
    def ProxyConfig(self):
        r"""Database proxy configuration.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ProxyConfigInfo`
        """
        return self._ProxyConfig

    @ProxyConfig.setter
    def ProxyConfig(self, ProxyConfig):
        self._ProxyConfig = ProxyConfig

    @property
    def AutoArchive(self):
        r"""Specifies whether to automatically archive.
        :rtype: str
        """
        return self._AutoArchive

    @AutoArchive.setter
    def AutoArchive(self, AutoArchive):
        self._AutoArchive = AutoArchive

    @property
    def AutoArchiveDelayHours(self):
        r"""Processing time after pausing.
        :rtype: int
        """
        return self._AutoArchiveDelayHours

    @AutoArchiveDelayHours.setter
    def AutoArchiveDelayHours(self, AutoArchiveDelayHours):
        self._AutoArchiveDelayHours = AutoArchiveDelayHours

    @property
    def EncryptMethod(self):
        r"""Encryption method (consists of encryption algorithm and key pair version).
        :rtype: str
        """
        return self._EncryptMethod

    @EncryptMethod.setter
    def EncryptMethod(self, EncryptMethod):
        self._EncryptMethod = EncryptMethod

    @property
    def IntegrateCreateClusterConfig(self):
        r"""Describes the cluster configuration information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.IntegrateCreateClusterConfig`
        """
        return self._IntegrateCreateClusterConfig

    @IntegrateCreateClusterConfig.setter
    def IntegrateCreateClusterConfig(self, IntegrateCreateClusterConfig):
        self._IntegrateCreateClusterConfig = IntegrateCreateClusterConfig

    @property
    def StorageVersion(self):
        r"""Storage architecture type. valid values: 1.0/2.0. default value: 1.0.
        :rtype: str
        """
        return self._StorageVersion

    @StorageVersion.setter
    def StorageVersion(self, StorageVersion):
        self._StorageVersion = StorageVersion


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._DbVersion = params.get("DbVersion")
        self._ProjectId = params.get("ProjectId")
        self._ClusterName = params.get("ClusterName")
        self._AdminPassword = params.get("AdminPassword")
        self._Port = params.get("Port")
        self._PayMode = params.get("PayMode")
        self._Count = params.get("Count")
        self._StorageLimit = params.get("StorageLimit")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._AutoVoucher = params.get("AutoVoucher")
        if params.get("ResourceTags") is not None:
            self._ResourceTags = []
            for item in params.get("ResourceTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ResourceTags.append(obj)
        self._StoragePayMode = params.get("StoragePayMode")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._AlarmPolicyIds = params.get("AlarmPolicyIds")
        if params.get("ClusterParams") is not None:
            self._ClusterParams = []
            for item in params.get("ClusterParams"):
                obj = ParamItem()
                obj._deserialize(item)
                self._ClusterParams.append(obj)
        self._DealMode = params.get("DealMode")
        self._ParamTemplateId = params.get("ParamTemplateId")
        self._SlaveZone = params.get("SlaveZone")
        if params.get("InstanceInitInfos") is not None:
            self._InstanceInitInfos = []
            for item in params.get("InstanceInitInfos"):
                obj = IntegrateInstanceInfo()
                obj._deserialize(item)
                self._InstanceInitInfos.append(obj)
        self._GdnId = params.get("GdnId")
        if params.get("ProxyConfig") is not None:
            self._ProxyConfig = ProxyConfigInfo()
            self._ProxyConfig._deserialize(params.get("ProxyConfig"))
        self._AutoArchive = params.get("AutoArchive")
        self._AutoArchiveDelayHours = params.get("AutoArchiveDelayHours")
        self._EncryptMethod = params.get("EncryptMethod")
        if params.get("IntegrateCreateClusterConfig") is not None:
            self._IntegrateCreateClusterConfig = IntegrateCreateClusterConfig()
            self._IntegrateCreateClusterConfig._deserialize(params.get("IntegrateCreateClusterConfig"))
        self._StorageVersion = params.get("StorageVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrateClusterResponse(AbstractModel):
    r"""CreateIntegrateCluster response structure.

    """

    def __init__(self):
        r"""
        :param _TranId: Frozen transaction ID.
        :type TranId: str
        :param _DealNames: Order ID
        :type DealNames: list of str
        :param _ResourceIds: Resource ID list (this field is no longer maintained. please use the dealNames field and the query API DescribeResourcesByDealName to obtain resource ids).
        :type ResourceIds: list of str
        :param _ClusterIds: Cluster ID list (this field is no longer maintained. please use the dealNames field to get cluster ids via the DescribeResourcesByDealName api.).
        :type ClusterIds: list of str
        :param _BigDealIds: Large order number.

Note: This field may return null, indicating that no valid values can be obtained.
        :type BigDealIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TranId = None
        self._DealNames = None
        self._ResourceIds = None
        self._ClusterIds = None
        self._BigDealIds = None
        self._RequestId = None

    @property
    def TranId(self):
        r"""Frozen transaction ID.
        :rtype: str
        """
        return self._TranId

    @TranId.setter
    def TranId(self, TranId):
        self._TranId = TranId

    @property
    def DealNames(self):
        r"""Order ID
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def ResourceIds(self):
        r"""Resource ID list (this field is no longer maintained. please use the dealNames field and the query API DescribeResourcesByDealName to obtain resource ids).
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ClusterIds(self):
        r"""Cluster ID list (this field is no longer maintained. please use the dealNames field to get cluster ids via the DescribeResourcesByDealName api.).
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def BigDealIds(self):
        r"""Large order number.

Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._BigDealIds

    @BigDealIds.setter
    def BigDealIds(self, BigDealIds):
        self._BigDealIds = BigDealIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TranId = params.get("TranId")
        self._DealNames = params.get("DealNames")
        self._ResourceIds = params.get("ResourceIds")
        self._ClusterIds = params.get("ClusterIds")
        self._BigDealIds = params.get("BigDealIds")
        self._RequestId = params.get("RequestId")


class CreateParamTemplateRequest(AbstractModel):
    r"""CreateParamTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _TemplateName: Template name
        :type TemplateName: str
        :param _EngineVersion: MySQL version number
        :type EngineVersion: str
        :param _TemplateDescription: Template description
        :type TemplateDescription: str
        :param _TemplateId: ID of the template to be copied
        :type TemplateId: int
        :param _DbMode: Database type. Valid values:  `NORMAL` (default), `SERVERLESS`.
        :type DbMode: str
        :param _ParamList: List of the parameters
        :type ParamList: list of ParamItem
        """
        self._TemplateName = None
        self._EngineVersion = None
        self._TemplateDescription = None
        self._TemplateId = None
        self._DbMode = None
        self._ParamList = None

    @property
    def TemplateName(self):
        r"""Template name
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def EngineVersion(self):
        r"""MySQL version number
        :rtype: str
        """
        return self._EngineVersion

    @EngineVersion.setter
    def EngineVersion(self, EngineVersion):
        self._EngineVersion = EngineVersion

    @property
    def TemplateDescription(self):
        r"""Template description
        :rtype: str
        """
        return self._TemplateDescription

    @TemplateDescription.setter
    def TemplateDescription(self, TemplateDescription):
        self._TemplateDescription = TemplateDescription

    @property
    def TemplateId(self):
        r"""ID of the template to be copied
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def DbMode(self):
        r"""Database type. Valid values:  `NORMAL` (default), `SERVERLESS`.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def ParamList(self):
        r"""List of the parameters
        :rtype: list of ParamItem
        """
        return self._ParamList

    @ParamList.setter
    def ParamList(self, ParamList):
        self._ParamList = ParamList


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._EngineVersion = params.get("EngineVersion")
        self._TemplateDescription = params.get("TemplateDescription")
        self._TemplateId = params.get("TemplateId")
        self._DbMode = params.get("DbMode")
        if params.get("ParamList") is not None:
            self._ParamList = []
            for item in params.get("ParamList"):
                obj = ParamItem()
                obj._deserialize(item)
                self._ParamList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateParamTemplateResponse(AbstractModel):
    r"""CreateParamTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Template ID
        :type TemplateId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        r"""Template ID
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateProxyEndPointRequest(AbstractModel):
    r"""CreateProxyEndPoint request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _UniqueVpcId: VPC ID, which is the same as that of the cluster by default.
        :type UniqueVpcId: str
        :param _UniqueSubnetId: VPCe subnet ID, which is the same as that of the cluster by default.
        :type UniqueSubnetId: str
        :param _ConnectionPoolType: Connection pool type. Valid value: `SessionConnectionPool` (session-level connection pool)
        :type ConnectionPoolType: str
        :param _OpenConnectionPool: Whether to enable connection pool. Valid value: `yes` (enable), `no` (disable).
        :type OpenConnectionPool: str
        :param _ConnectionPoolTimeOut: Connection pool threshold in seconds
        :type ConnectionPoolTimeOut: int
        :param _SecurityGroupIds: Array of security group IDs
        :type SecurityGroupIds: list of str
        :param _Description: Description
        :type Description: str
        :param _Vip: VIP information
        :type Vip: str
        :param _WeightMode: Weight mode. 
Valid values: `system` (system-assigned), `custom` (custom).
        :type WeightMode: str
        :param _AutoAddRo: Whether to automatically add read-only instance. Valid value: `yes`, `no`.
        :type AutoAddRo: str
        :param _FailOver: Whether to enable failover
        :type FailOver: str
        :param _ConsistencyType: Consistency type. Valid values: 
`eventual`, `global`, `session`.
        :type ConsistencyType: str
        :param _RwType: Read-write attribute. Valid values: 
`READWRITE`, `READONLY`.
        :type RwType: str
        :param _ConsistencyTimeOut: Consistency timeout period
        :type ConsistencyTimeOut: int
        :param _TransSplit: Transaction split
        :type TransSplit: bool
        :param _AccessMode: Connection mode. Valid values:
`nearby`, `balance`.
        :type AccessMode: str
        :param _InstanceWeights: Instance weight
        :type InstanceWeights: list of ProxyInstanceWeight
        """
        self._ClusterId = None
        self._UniqueVpcId = None
        self._UniqueSubnetId = None
        self._ConnectionPoolType = None
        self._OpenConnectionPool = None
        self._ConnectionPoolTimeOut = None
        self._SecurityGroupIds = None
        self._Description = None
        self._Vip = None
        self._WeightMode = None
        self._AutoAddRo = None
        self._FailOver = None
        self._ConsistencyType = None
        self._RwType = None
        self._ConsistencyTimeOut = None
        self._TransSplit = None
        self._AccessMode = None
        self._InstanceWeights = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def UniqueVpcId(self):
        r"""VPC ID, which is the same as that of the cluster by default.
        :rtype: str
        """
        return self._UniqueVpcId

    @UniqueVpcId.setter
    def UniqueVpcId(self, UniqueVpcId):
        self._UniqueVpcId = UniqueVpcId

    @property
    def UniqueSubnetId(self):
        r"""VPCe subnet ID, which is the same as that of the cluster by default.
        :rtype: str
        """
        return self._UniqueSubnetId

    @UniqueSubnetId.setter
    def UniqueSubnetId(self, UniqueSubnetId):
        self._UniqueSubnetId = UniqueSubnetId

    @property
    def ConnectionPoolType(self):
        r"""Connection pool type. Valid value: `SessionConnectionPool` (session-level connection pool)
        :rtype: str
        """
        return self._ConnectionPoolType

    @ConnectionPoolType.setter
    def ConnectionPoolType(self, ConnectionPoolType):
        self._ConnectionPoolType = ConnectionPoolType

    @property
    def OpenConnectionPool(self):
        r"""Whether to enable connection pool. Valid value: `yes` (enable), `no` (disable).
        :rtype: str
        """
        return self._OpenConnectionPool

    @OpenConnectionPool.setter
    def OpenConnectionPool(self, OpenConnectionPool):
        self._OpenConnectionPool = OpenConnectionPool

    @property
    def ConnectionPoolTimeOut(self):
        r"""Connection pool threshold in seconds
        :rtype: int
        """
        return self._ConnectionPoolTimeOut

    @ConnectionPoolTimeOut.setter
    def ConnectionPoolTimeOut(self, ConnectionPoolTimeOut):
        self._ConnectionPoolTimeOut = ConnectionPoolTimeOut

    @property
    def SecurityGroupIds(self):
        r"""Array of security group IDs
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Vip(self):
        r"""VIP information
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def WeightMode(self):
        r"""Weight mode. 
Valid values: `system` (system-assigned), `custom` (custom).
        :rtype: str
        """
        return self._WeightMode

    @WeightMode.setter
    def WeightMode(self, WeightMode):
        self._WeightMode = WeightMode

    @property
    def AutoAddRo(self):
        r"""Whether to automatically add read-only instance. Valid value: `yes`, `no`.
        :rtype: str
        """
        return self._AutoAddRo

    @AutoAddRo.setter
    def AutoAddRo(self, AutoAddRo):
        self._AutoAddRo = AutoAddRo

    @property
    def FailOver(self):
        r"""Whether to enable failover
        :rtype: str
        """
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def ConsistencyType(self):
        r"""Consistency type. Valid values: 
`eventual`, `global`, `session`.
        :rtype: str
        """
        return self._ConsistencyType

    @ConsistencyType.setter
    def ConsistencyType(self, ConsistencyType):
        self._ConsistencyType = ConsistencyType

    @property
    def RwType(self):
        r"""Read-write attribute. Valid values: 
`READWRITE`, `READONLY`.
        :rtype: str
        """
        return self._RwType

    @RwType.setter
    def RwType(self, RwType):
        self._RwType = RwType

    @property
    def ConsistencyTimeOut(self):
        r"""Consistency timeout period
        :rtype: int
        """
        return self._ConsistencyTimeOut

    @ConsistencyTimeOut.setter
    def ConsistencyTimeOut(self, ConsistencyTimeOut):
        self._ConsistencyTimeOut = ConsistencyTimeOut

    @property
    def TransSplit(self):
        r"""Transaction split
        :rtype: bool
        """
        return self._TransSplit

    @TransSplit.setter
    def TransSplit(self, TransSplit):
        self._TransSplit = TransSplit

    @property
    def AccessMode(self):
        r"""Connection mode. Valid values:
`nearby`, `balance`.
        :rtype: str
        """
        return self._AccessMode

    @AccessMode.setter
    def AccessMode(self, AccessMode):
        self._AccessMode = AccessMode

    @property
    def InstanceWeights(self):
        r"""Instance weight
        :rtype: list of ProxyInstanceWeight
        """
        return self._InstanceWeights

    @InstanceWeights.setter
    def InstanceWeights(self, InstanceWeights):
        self._InstanceWeights = InstanceWeights


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._UniqueVpcId = params.get("UniqueVpcId")
        self._UniqueSubnetId = params.get("UniqueSubnetId")
        self._ConnectionPoolType = params.get("ConnectionPoolType")
        self._OpenConnectionPool = params.get("OpenConnectionPool")
        self._ConnectionPoolTimeOut = params.get("ConnectionPoolTimeOut")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Description = params.get("Description")
        self._Vip = params.get("Vip")
        self._WeightMode = params.get("WeightMode")
        self._AutoAddRo = params.get("AutoAddRo")
        self._FailOver = params.get("FailOver")
        self._ConsistencyType = params.get("ConsistencyType")
        self._RwType = params.get("RwType")
        self._ConsistencyTimeOut = params.get("ConsistencyTimeOut")
        self._TransSplit = params.get("TransSplit")
        self._AccessMode = params.get("AccessMode")
        if params.get("InstanceWeights") is not None:
            self._InstanceWeights = []
            for item in params.get("InstanceWeights"):
                obj = ProxyInstanceWeight()
                obj._deserialize(item)
                self._InstanceWeights.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProxyEndPointResponse(AbstractModel):
    r"""CreateProxyEndPoint response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async flow ID
        :type FlowId: int
        :param _TaskId: Async task ID
        :type TaskId: int
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._ProxyGroupId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._RequestId = params.get("RequestId")


class CreateProxyRequest(AbstractModel):
    r"""CreateProxy request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Cpu: Number of CPU cores
        :type Cpu: int
        :param _Mem: Memory
        :type Mem: int
        :param _UniqueVpcId: VPC ID, which is the same as that of the cluster by default.
        :type UniqueVpcId: str
        :param _UniqueSubnetId: VPC subnet ID, which is the same as that of the cluster by default.
        :type UniqueSubnetId: str
        :param _ProxyCount: Number of nodes in the proxy group
        :type ProxyCount: int
        :param _ConnectionPoolType: Connection pool type. Valid value: `SessionConnectionPool` (session-level connection pool)
        :type ConnectionPoolType: str
        :param _OpenConnectionPool: Whether to enable connection pool. Valid value: `yes` (enable), `no` (disable).
        :type OpenConnectionPool: str
        :param _ConnectionPoolTimeOut: Connection pool threshold in seconds
        :type ConnectionPoolTimeOut: int
        :param _SecurityGroupIds: Array of security group IDs
        :type SecurityGroupIds: list of str
        :param _Description: Description
        :type Description: str
        :param _ProxyZones: Database node information
        :type ProxyZones: list of ProxyZone
        """
        self._ClusterId = None
        self._Cpu = None
        self._Mem = None
        self._UniqueVpcId = None
        self._UniqueSubnetId = None
        self._ProxyCount = None
        self._ConnectionPoolType = None
        self._OpenConnectionPool = None
        self._ConnectionPoolTimeOut = None
        self._SecurityGroupIds = None
        self._Description = None
        self._ProxyZones = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Cpu(self):
        r"""Number of CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Mem(self):
        r"""Memory
        :rtype: int
        """
        return self._Mem

    @Mem.setter
    def Mem(self, Mem):
        self._Mem = Mem

    @property
    def UniqueVpcId(self):
        r"""VPC ID, which is the same as that of the cluster by default.
        :rtype: str
        """
        return self._UniqueVpcId

    @UniqueVpcId.setter
    def UniqueVpcId(self, UniqueVpcId):
        self._UniqueVpcId = UniqueVpcId

    @property
    def UniqueSubnetId(self):
        r"""VPC subnet ID, which is the same as that of the cluster by default.
        :rtype: str
        """
        return self._UniqueSubnetId

    @UniqueSubnetId.setter
    def UniqueSubnetId(self, UniqueSubnetId):
        self._UniqueSubnetId = UniqueSubnetId

    @property
    def ProxyCount(self):
        r"""Number of nodes in the proxy group
        :rtype: int
        """
        return self._ProxyCount

    @ProxyCount.setter
    def ProxyCount(self, ProxyCount):
        self._ProxyCount = ProxyCount

    @property
    def ConnectionPoolType(self):
        r"""Connection pool type. Valid value: `SessionConnectionPool` (session-level connection pool)
        :rtype: str
        """
        return self._ConnectionPoolType

    @ConnectionPoolType.setter
    def ConnectionPoolType(self, ConnectionPoolType):
        self._ConnectionPoolType = ConnectionPoolType

    @property
    def OpenConnectionPool(self):
        r"""Whether to enable connection pool. Valid value: `yes` (enable), `no` (disable).
        :rtype: str
        """
        return self._OpenConnectionPool

    @OpenConnectionPool.setter
    def OpenConnectionPool(self, OpenConnectionPool):
        self._OpenConnectionPool = OpenConnectionPool

    @property
    def ConnectionPoolTimeOut(self):
        r"""Connection pool threshold in seconds
        :rtype: int
        """
        return self._ConnectionPoolTimeOut

    @ConnectionPoolTimeOut.setter
    def ConnectionPoolTimeOut(self, ConnectionPoolTimeOut):
        self._ConnectionPoolTimeOut = ConnectionPoolTimeOut

    @property
    def SecurityGroupIds(self):
        r"""Array of security group IDs
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ProxyZones(self):
        r"""Database node information
        :rtype: list of ProxyZone
        """
        return self._ProxyZones

    @ProxyZones.setter
    def ProxyZones(self, ProxyZones):
        self._ProxyZones = ProxyZones


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Cpu = params.get("Cpu")
        self._Mem = params.get("Mem")
        self._UniqueVpcId = params.get("UniqueVpcId")
        self._UniqueSubnetId = params.get("UniqueSubnetId")
        self._ProxyCount = params.get("ProxyCount")
        self._ConnectionPoolType = params.get("ConnectionPoolType")
        self._OpenConnectionPool = params.get("OpenConnectionPool")
        self._ConnectionPoolTimeOut = params.get("ConnectionPoolTimeOut")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Description = params.get("Description")
        if params.get("ProxyZones") is not None:
            self._ProxyZones = []
            for item in params.get("ProxyZones"):
                obj = ProxyZone()
                obj._deserialize(item)
                self._ProxyZones.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProxyResponse(AbstractModel):
    r"""CreateProxy response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async flow ID
        :type FlowId: int
        :param _TaskId: Async task ID
        :type TaskId: int
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._ProxyGroupId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._RequestId = params.get("RequestId")


class CreateResourcePackageRequest(AbstractModel):
    r"""CreateResourcePackage request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceType: Instance type. currently fixed to cynosdb-serverless.
        :type InstanceType: str
        :param _PackageRegion: Resource package region of use: chineseMainland - common in the chinese mainland. overseas - universally applicable in hong kong (china), macao (china), taiwan (china), and overseas.
        :type PackageRegion: str
        :param _PackageType: Resource pack type. Valid values: `CCU` (compute resource pack), `DISK` (storage resource pack).
        :type PackageType: str
        :param _PackageVersion: Resource pack edition. Valid values: `base` (basic edition), `common` (general edition), `enterprise` (enterprise edition).
        :type PackageVersion: str
        :param _PackageSpec: Resource pack size. Unit of the compute resource pack: Ten thousand.  Unit of the storage resource pack:  GB
        :type PackageSpec: float
        :param _ExpireDay: Validity period of a resource pack in days
        :type ExpireDay: int
        :param _PackageCount: Number of the resource packs to be purchased
        :type PackageCount: int
        :param _PackageName: Resource pack name
        :type PackageName: str
        """
        self._InstanceType = None
        self._PackageRegion = None
        self._PackageType = None
        self._PackageVersion = None
        self._PackageSpec = None
        self._ExpireDay = None
        self._PackageCount = None
        self._PackageName = None

    @property
    def InstanceType(self):
        r"""Instance type. currently fixed to cynosdb-serverless.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def PackageRegion(self):
        r"""Resource package region of use: chineseMainland - common in the chinese mainland. overseas - universally applicable in hong kong (china), macao (china), taiwan (china), and overseas.
        :rtype: str
        """
        return self._PackageRegion

    @PackageRegion.setter
    def PackageRegion(self, PackageRegion):
        self._PackageRegion = PackageRegion

    @property
    def PackageType(self):
        r"""Resource pack type. Valid values: `CCU` (compute resource pack), `DISK` (storage resource pack).
        :rtype: str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def PackageVersion(self):
        r"""Resource pack edition. Valid values: `base` (basic edition), `common` (general edition), `enterprise` (enterprise edition).
        :rtype: str
        """
        return self._PackageVersion

    @PackageVersion.setter
    def PackageVersion(self, PackageVersion):
        self._PackageVersion = PackageVersion

    @property
    def PackageSpec(self):
        r"""Resource pack size. Unit of the compute resource pack: Ten thousand.  Unit of the storage resource pack:  GB
        :rtype: float
        """
        return self._PackageSpec

    @PackageSpec.setter
    def PackageSpec(self, PackageSpec):
        self._PackageSpec = PackageSpec

    @property
    def ExpireDay(self):
        r"""Validity period of a resource pack in days
        :rtype: int
        """
        return self._ExpireDay

    @ExpireDay.setter
    def ExpireDay(self, ExpireDay):
        self._ExpireDay = ExpireDay

    @property
    def PackageCount(self):
        r"""Number of the resource packs to be purchased
        :rtype: int
        """
        return self._PackageCount

    @PackageCount.setter
    def PackageCount(self, PackageCount):
        self._PackageCount = PackageCount

    @property
    def PackageName(self):
        r"""Resource pack name
        :rtype: str
        """
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._PackageRegion = params.get("PackageRegion")
        self._PackageType = params.get("PackageType")
        self._PackageVersion = params.get("PackageVersion")
        self._PackageSpec = params.get("PackageSpec")
        self._ExpireDay = params.get("ExpireDay")
        self._PackageCount = params.get("PackageCount")
        self._PackageName = params.get("PackageName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateResourcePackageResponse(AbstractModel):
    r"""CreateResourcePackage response structure.

    """

    def __init__(self):
        r"""
        :param _BigDealIds: Big order number
        :type BigDealIds: list of str
        :param _DealNames: Each item has only one `dealName`, through which you need to ensure the idempotency of the delivery API.
        :type DealNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BigDealIds = None
        self._DealNames = None
        self._RequestId = None

    @property
    def BigDealIds(self):
        r"""Big order number
        :rtype: list of str
        """
        return self._BigDealIds

    @BigDealIds.setter
    def BigDealIds(self, BigDealIds):
        self._BigDealIds = BigDealIds

    @property
    def DealNames(self):
        r"""Each item has only one `dealName`, through which you need to ensure the idempotency of the delivery API.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BigDealIds = params.get("BigDealIds")
        self._DealNames = params.get("DealNames")
        self._RequestId = params.get("RequestId")


class CrossRegionBackupItem(AbstractModel):
    r"""Cross-Region backup describes the backup information in each region.

    """

    def __init__(self):
        r"""
        :param _CrossRegion: Target region for backup.
        :type CrossRegion: str
        :param _BackupId: Target region's backup task ID.
        :type BackupId: int
        :param _BackupStatus: Backup status in the target region.
        :type BackupStatus: str
        """
        self._CrossRegion = None
        self._BackupId = None
        self._BackupStatus = None

    @property
    def CrossRegion(self):
        r"""Target region for backup.
        :rtype: str
        """
        return self._CrossRegion

    @CrossRegion.setter
    def CrossRegion(self, CrossRegion):
        self._CrossRegion = CrossRegion

    @property
    def BackupId(self):
        r"""Target region's backup task ID.
        :rtype: int
        """
        return self._BackupId

    @BackupId.setter
    def BackupId(self, BackupId):
        self._BackupId = BackupId

    @property
    def BackupStatus(self):
        r"""Backup status in the target region.
        :rtype: str
        """
        return self._BackupStatus

    @BackupStatus.setter
    def BackupStatus(self, BackupStatus):
        self._BackupStatus = BackupStatus


    def _deserialize(self, params):
        self._CrossRegion = params.get("CrossRegion")
        self._BackupId = params.get("BackupId")
        self._BackupStatus = params.get("BackupStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CynosdbCluster(AbstractModel):
    r"""Cluster information

    """

    def __init__(self):
        r"""
        :param _Status: Cluster status. Valid values are as follows:
creating
running
isolating
isolated
activating (removing isolation)
offlining (deactivating)
offlined (deactivated)
deleting
deleted
        :type Status: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _Zone: AZ
        :type Zone: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _Region: Region
        :type Region: str
        :param _DbVersion: Database version
        :type DbVersion: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceNum: Number of instances
        :type InstanceNum: int
        :param _Uin: User UIN
        :type Uin: str
        :param _DbType: Engine type.
        :type DbType: str
        :param _AppId: User appid.
        :type AppId: int
        :param _StatusDesc: Cluster status description
        :type StatusDesc: str
        :param _CreateTime: Cluster Creation Time
        :type CreateTime: str
        :param _PayMode: Payment mode. 0: pay-as-you-go; 1: monthly subscription.
        :type PayMode: int
        :param _PeriodEndTime: Expiration time.
        :type PeriodEndTime: str
        :param _Vip: Cluster read/write vip.
        :type Vip: str
        :param _Vport: Cluster read/write vport.
        :type Vport: int
        :param _ProjectID: Project ID
        :type ProjectID: int
        :param _VpcId: Specifies the virtual private cloud ID.
        :type VpcId: str
        :param _SubnetId: Specifies the subnet ID.
        :type SubnetId: str
        :param _CynosVersion: Specifies the cynos kernel version.
        :type CynosVersion: str
        :param _StorageLimit: Specifies the storage capacity.
        :type StorageLimit: int
        :param _RenewFlag: Renewal Flag
        :type RenewFlag: int
        :param _ProcessingTask: Task being processed.
        :type ProcessingTask: str
        :param _Tasks: Task array of the cluster.
        :type Tasks: list of ObjectTask
        :param _ResourceTags: Array of tags bound to the cluster.
        :type ResourceTags: list of Tag
        :param _DbMode: Db type (NORMAL, SERVERLESS).
        :type DbMode: str
        :param _ServerlessStatus: Specifies the status of the SERVERLESS cluster when the Db type is SERVERLESS. valid values:.
resume
pause
        :type ServerlessStatus: str
        :param _Storage: Cluster prepaid storage size.
        :type Storage: int
        :param _StorageId: Cluster storage ID for prepaid storage, specifies the storage ID used for prepaid storage modification.
        :type StorageId: str
        :param _StoragePayMode: Cluster storage payment mode. 0: pay-as-you-go; 1: monthly subscription.
        :type StoragePayMode: int
        :param _MinStorageSize: Minimum storage value corresponding to cluster computing specifications.
        :type MinStorageSize: int
        :param _MaxStorageSize: The maximum storage value corresponding to the cluster computing specification.
        :type MaxStorageSize: int
        :param _NetAddrs: Specifies the cluster network information.
        :type NetAddrs: list of NetAddr
        :param _PhysicalZone: Physical availability zone.
        :type PhysicalZone: str
        :param _MasterZone: Primary AZ.
        :type MasterZone: str
        :param _HasSlaveZone: Whether there is an availability zone.
        :type HasSlaveZone: str
        :param _SlaveZones: Secondary AZ.
        :type SlaveZones: list of str
        :param _BusinessType: Business type.
        :type BusinessType: str
        :param _IsFreeze: Whether to freeze.
        :type IsFreeze: str
        :param _OrderSource: Order Source
        :type OrderSource: str
        :param _Ability: Capacity.
        :type Ability: :class:`tencentcloud.cynosdb.v20190107.models.Ability`
        :param _ResourcePackages: Specifies the information of the resource package bound to the instance (only the storage resource package is returned here, that is, packageType=DISK).	
        :type ResourcePackages: list of ResourcePackage
        """
        self._Status = None
        self._UpdateTime = None
        self._Zone = None
        self._ClusterName = None
        self._Region = None
        self._DbVersion = None
        self._ClusterId = None
        self._InstanceNum = None
        self._Uin = None
        self._DbType = None
        self._AppId = None
        self._StatusDesc = None
        self._CreateTime = None
        self._PayMode = None
        self._PeriodEndTime = None
        self._Vip = None
        self._Vport = None
        self._ProjectID = None
        self._VpcId = None
        self._SubnetId = None
        self._CynosVersion = None
        self._StorageLimit = None
        self._RenewFlag = None
        self._ProcessingTask = None
        self._Tasks = None
        self._ResourceTags = None
        self._DbMode = None
        self._ServerlessStatus = None
        self._Storage = None
        self._StorageId = None
        self._StoragePayMode = None
        self._MinStorageSize = None
        self._MaxStorageSize = None
        self._NetAddrs = None
        self._PhysicalZone = None
        self._MasterZone = None
        self._HasSlaveZone = None
        self._SlaveZones = None
        self._BusinessType = None
        self._IsFreeze = None
        self._OrderSource = None
        self._Ability = None
        self._ResourcePackages = None

    @property
    def Status(self):
        r"""Cluster status. Valid values are as follows:
creating
running
isolating
isolated
activating (removing isolation)
offlining (deactivating)
offlined (deactivated)
deleting
deleted
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def DbVersion(self):
        r"""Database version
        :rtype: str
        """
        return self._DbVersion

    @DbVersion.setter
    def DbVersion(self, DbVersion):
        self._DbVersion = DbVersion

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceNum(self):
        r"""Number of instances
        :rtype: int
        """
        return self._InstanceNum

    @InstanceNum.setter
    def InstanceNum(self, InstanceNum):
        self._InstanceNum = InstanceNum

    @property
    def Uin(self):
        r"""User UIN
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def DbType(self):
        r"""Engine type.
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def AppId(self):
        r"""User appid.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def StatusDesc(self):
        r"""Cluster status description
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def CreateTime(self):
        r"""Cluster Creation Time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def PayMode(self):
        r"""Payment mode. 0: pay-as-you-go; 1: monthly subscription.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def PeriodEndTime(self):
        r"""Expiration time.
        :rtype: str
        """
        return self._PeriodEndTime

    @PeriodEndTime.setter
    def PeriodEndTime(self, PeriodEndTime):
        self._PeriodEndTime = PeriodEndTime

    @property
    def Vip(self):
        r"""Cluster read/write vip.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Cluster read/write vport.
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def ProjectID(self):
        r"""Project ID
        :rtype: int
        """
        return self._ProjectID

    @ProjectID.setter
    def ProjectID(self, ProjectID):
        self._ProjectID = ProjectID

    @property
    def VpcId(self):
        r"""Specifies the virtual private cloud ID.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Specifies the subnet ID.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def CynosVersion(self):
        r"""Specifies the cynos kernel version.
        :rtype: str
        """
        return self._CynosVersion

    @CynosVersion.setter
    def CynosVersion(self, CynosVersion):
        self._CynosVersion = CynosVersion

    @property
    def StorageLimit(self):
        r"""Specifies the storage capacity.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def RenewFlag(self):
        r"""Renewal Flag
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def ProcessingTask(self):
        r"""Task being processed.
        :rtype: str
        """
        return self._ProcessingTask

    @ProcessingTask.setter
    def ProcessingTask(self, ProcessingTask):
        self._ProcessingTask = ProcessingTask

    @property
    def Tasks(self):
        r"""Task array of the cluster.
        :rtype: list of ObjectTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def ResourceTags(self):
        r"""Array of tags bound to the cluster.
        :rtype: list of Tag
        """
        return self._ResourceTags

    @ResourceTags.setter
    def ResourceTags(self, ResourceTags):
        self._ResourceTags = ResourceTags

    @property
    def DbMode(self):
        r"""Db type (NORMAL, SERVERLESS).
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def ServerlessStatus(self):
        r"""Specifies the status of the SERVERLESS cluster when the Db type is SERVERLESS. valid values:.
resume
pause
        :rtype: str
        """
        return self._ServerlessStatus

    @ServerlessStatus.setter
    def ServerlessStatus(self, ServerlessStatus):
        self._ServerlessStatus = ServerlessStatus

    @property
    def Storage(self):
        r"""Cluster prepaid storage size.
        :rtype: int
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def StorageId(self):
        r"""Cluster storage ID for prepaid storage, specifies the storage ID used for prepaid storage modification.
        :rtype: str
        """
        return self._StorageId

    @StorageId.setter
    def StorageId(self, StorageId):
        self._StorageId = StorageId

    @property
    def StoragePayMode(self):
        r"""Cluster storage payment mode. 0: pay-as-you-go; 1: monthly subscription.
        :rtype: int
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def MinStorageSize(self):
        r"""Minimum storage value corresponding to cluster computing specifications.
        :rtype: int
        """
        return self._MinStorageSize

    @MinStorageSize.setter
    def MinStorageSize(self, MinStorageSize):
        self._MinStorageSize = MinStorageSize

    @property
    def MaxStorageSize(self):
        r"""The maximum storage value corresponding to the cluster computing specification.
        :rtype: int
        """
        return self._MaxStorageSize

    @MaxStorageSize.setter
    def MaxStorageSize(self, MaxStorageSize):
        self._MaxStorageSize = MaxStorageSize

    @property
    def NetAddrs(self):
        r"""Specifies the cluster network information.
        :rtype: list of NetAddr
        """
        return self._NetAddrs

    @NetAddrs.setter
    def NetAddrs(self, NetAddrs):
        self._NetAddrs = NetAddrs

    @property
    def PhysicalZone(self):
        r"""Physical availability zone.
        :rtype: str
        """
        return self._PhysicalZone

    @PhysicalZone.setter
    def PhysicalZone(self, PhysicalZone):
        self._PhysicalZone = PhysicalZone

    @property
    def MasterZone(self):
        r"""Primary AZ.
        :rtype: str
        """
        return self._MasterZone

    @MasterZone.setter
    def MasterZone(self, MasterZone):
        self._MasterZone = MasterZone

    @property
    def HasSlaveZone(self):
        r"""Whether there is an availability zone.
        :rtype: str
        """
        return self._HasSlaveZone

    @HasSlaveZone.setter
    def HasSlaveZone(self, HasSlaveZone):
        self._HasSlaveZone = HasSlaveZone

    @property
    def SlaveZones(self):
        r"""Secondary AZ.
        :rtype: list of str
        """
        return self._SlaveZones

    @SlaveZones.setter
    def SlaveZones(self, SlaveZones):
        self._SlaveZones = SlaveZones

    @property
    def BusinessType(self):
        r"""Business type.
        :rtype: str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def IsFreeze(self):
        r"""Whether to freeze.
        :rtype: str
        """
        return self._IsFreeze

    @IsFreeze.setter
    def IsFreeze(self, IsFreeze):
        self._IsFreeze = IsFreeze

    @property
    def OrderSource(self):
        r"""Order Source
        :rtype: str
        """
        return self._OrderSource

    @OrderSource.setter
    def OrderSource(self, OrderSource):
        self._OrderSource = OrderSource

    @property
    def Ability(self):
        r"""Capacity.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.Ability`
        """
        return self._Ability

    @Ability.setter
    def Ability(self, Ability):
        self._Ability = Ability

    @property
    def ResourcePackages(self):
        r"""Specifies the information of the resource package bound to the instance (only the storage resource package is returned here, that is, packageType=DISK).	
        :rtype: list of ResourcePackage
        """
        return self._ResourcePackages

    @ResourcePackages.setter
    def ResourcePackages(self, ResourcePackages):
        self._ResourcePackages = ResourcePackages


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._UpdateTime = params.get("UpdateTime")
        self._Zone = params.get("Zone")
        self._ClusterName = params.get("ClusterName")
        self._Region = params.get("Region")
        self._DbVersion = params.get("DbVersion")
        self._ClusterId = params.get("ClusterId")
        self._InstanceNum = params.get("InstanceNum")
        self._Uin = params.get("Uin")
        self._DbType = params.get("DbType")
        self._AppId = params.get("AppId")
        self._StatusDesc = params.get("StatusDesc")
        self._CreateTime = params.get("CreateTime")
        self._PayMode = params.get("PayMode")
        self._PeriodEndTime = params.get("PeriodEndTime")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._ProjectID = params.get("ProjectID")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._CynosVersion = params.get("CynosVersion")
        self._StorageLimit = params.get("StorageLimit")
        self._RenewFlag = params.get("RenewFlag")
        self._ProcessingTask = params.get("ProcessingTask")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ObjectTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        if params.get("ResourceTags") is not None:
            self._ResourceTags = []
            for item in params.get("ResourceTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ResourceTags.append(obj)
        self._DbMode = params.get("DbMode")
        self._ServerlessStatus = params.get("ServerlessStatus")
        self._Storage = params.get("Storage")
        self._StorageId = params.get("StorageId")
        self._StoragePayMode = params.get("StoragePayMode")
        self._MinStorageSize = params.get("MinStorageSize")
        self._MaxStorageSize = params.get("MaxStorageSize")
        if params.get("NetAddrs") is not None:
            self._NetAddrs = []
            for item in params.get("NetAddrs"):
                obj = NetAddr()
                obj._deserialize(item)
                self._NetAddrs.append(obj)
        self._PhysicalZone = params.get("PhysicalZone")
        self._MasterZone = params.get("MasterZone")
        self._HasSlaveZone = params.get("HasSlaveZone")
        self._SlaveZones = params.get("SlaveZones")
        self._BusinessType = params.get("BusinessType")
        self._IsFreeze = params.get("IsFreeze")
        self._OrderSource = params.get("OrderSource")
        if params.get("Ability") is not None:
            self._Ability = Ability()
            self._Ability._deserialize(params.get("Ability"))
        if params.get("ResourcePackages") is not None:
            self._ResourcePackages = []
            for item in params.get("ResourcePackages"):
                obj = ResourcePackage()
                obj._deserialize(item)
                self._ResourcePackages.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CynosdbClusterDetail(AbstractModel):
    r"""Cluster details

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _Region: Region
        :type Region: str
        :param _Zone: AZ
        :type Zone: str
        :param _PhysicalZone: Physical availability zone.
        :type PhysicalZone: str
        :param _Status: Status
        :type Status: str
        :param _StatusDesc: Status description
        :type StatusDesc: str
        :param _ServerlessStatus: Serverless cluster status when the database type is `SERVERLESS`. Valid values:
resume
resuming
pause
pausing
        :type ServerlessStatus: str
        :param _StorageId: Storage Id.
        :type StorageId: str
        :param _Storage: Storage size in gb.
        :type Storage: int
        :param _MaxStorageSize: Maximum storage specification, in gb.
        :type MaxStorageSize: int
        :param _MinStorageSize: Specifies the minimum storage specification, in gb.
        :type MinStorageSize: int
        :param _StoragePayMode: Storage billing type. 1 indicates monthly subscription, and 0 indicates pay-as-you-go.
        :type StoragePayMode: int
        :param _VpcName: VPC name
        :type VpcName: str
        :param _VpcId: Unique VPC ID
        :type VpcId: str
        :param _SubnetName: Subnet name
        :type SubnetName: str
        :param _SubnetId: Subnet ID
        :type SubnetId: str
        :param _Charset: Character set
        :type Charset: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _DbType: Database type
        :type DbType: str
        :param _DbMode: Db type: <li>NORMAL</li> <li>SERVERLESS</li>.
        :type DbMode: str
        :param _DbVersion: Database version
        :type DbVersion: str
        :param _StorageLimit: Specifies the maximum storage space.
        :type StorageLimit: int
        :param _UsedStorage: Used capacity
        :type UsedStorage: int
        :param _Vip: VIP
        :type Vip: str
        :param _Vport: vport
        :type Vport: int
        :param _RoAddr: VIP and vport of the read-only instance in a cluster
        :type RoAddr: list of Addr
        :param _Ability: Functions supported by the cluster.
        :type Ability: :class:`tencentcloud.cynosdb.v20190107.models.Ability`
        :param _CynosVersion: Specifies the cynos version.
        :type CynosVersion: str
        :param _BusinessType: Business type.
        :type BusinessType: str
        :param _HasSlaveZone: Whether there is an availability zone.
        :type HasSlaveZone: str
        :param _IsFreeze: Whether to freeze.
        :type IsFreeze: str
        :param _Tasks: Task list.
        :type Tasks: list of ObjectTask
        :param _MasterZone: Primary AZ.
        :type MasterZone: str
        :param _SlaveZones: Availability zone list.
        :type SlaveZones: list of str
        :param _InstanceSet: Instance information
        :type InstanceSet: list of ClusterInstanceDetail
        :param _PayMode: Billing mode
        :type PayMode: int
        :param _PeriodEndTime: Expiration time
        :type PeriodEndTime: str
        :param _ProjectID: Project ID
        :type ProjectID: int
        :param _ResourceTags: Array of tags bound to instance
        :type ResourceTags: list of Tag
        :param _ProxyStatus: Proxy status.
        :type ProxyStatus: str
        :param _LogBin: binlog switch. valid values: ON, OFF.
        :type LogBin: str
        :param _IsSkipTrade: Specifies whether to skip the transaction.
        :type IsSkipTrade: str
        :param _PitrType: PITR type: valid values: normal, redo_pitr.
        :type PitrType: str
        :param _IsOpenPasswordComplexity: Whether to enable password complexity.
        :type IsOpenPasswordComplexity: str
        :param _NetworkStatus: Network type.
        :type NetworkStatus: str
        :param _ResourcePackages: The resource package information that is bound to the cluster.	
        :type ResourcePackages: list of ResourcePackage
        :param _RenewFlag: Auto-Renewal flag. 1 indicates auto-renewal. 0 indicates non-renewal upon expiration.
        :type RenewFlag: int
        :param _NetworkType: Specifies the node network type.
        :type NetworkType: str
        :param _SlaveZoneAttr: Secondary availability zone property.
        :type SlaveZoneAttr: list of SlaveZoneAttrItem
        :param _CynosVersionTag: Version Tag.
        :type CynosVersionTag: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._Region = None
        self._Zone = None
        self._PhysicalZone = None
        self._Status = None
        self._StatusDesc = None
        self._ServerlessStatus = None
        self._StorageId = None
        self._Storage = None
        self._MaxStorageSize = None
        self._MinStorageSize = None
        self._StoragePayMode = None
        self._VpcName = None
        self._VpcId = None
        self._SubnetName = None
        self._SubnetId = None
        self._Charset = None
        self._CreateTime = None
        self._DbType = None
        self._DbMode = None
        self._DbVersion = None
        self._StorageLimit = None
        self._UsedStorage = None
        self._Vip = None
        self._Vport = None
        self._RoAddr = None
        self._Ability = None
        self._CynosVersion = None
        self._BusinessType = None
        self._HasSlaveZone = None
        self._IsFreeze = None
        self._Tasks = None
        self._MasterZone = None
        self._SlaveZones = None
        self._InstanceSet = None
        self._PayMode = None
        self._PeriodEndTime = None
        self._ProjectID = None
        self._ResourceTags = None
        self._ProxyStatus = None
        self._LogBin = None
        self._IsSkipTrade = None
        self._PitrType = None
        self._IsOpenPasswordComplexity = None
        self._NetworkStatus = None
        self._ResourcePackages = None
        self._RenewFlag = None
        self._NetworkType = None
        self._SlaveZoneAttr = None
        self._CynosVersionTag = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def PhysicalZone(self):
        r"""Physical availability zone.
        :rtype: str
        """
        return self._PhysicalZone

    @PhysicalZone.setter
    def PhysicalZone(self, PhysicalZone):
        self._PhysicalZone = PhysicalZone

    @property
    def Status(self):
        r"""Status
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusDesc(self):
        r"""Status description
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def ServerlessStatus(self):
        r"""Serverless cluster status when the database type is `SERVERLESS`. Valid values:
resume
resuming
pause
pausing
        :rtype: str
        """
        return self._ServerlessStatus

    @ServerlessStatus.setter
    def ServerlessStatus(self, ServerlessStatus):
        self._ServerlessStatus = ServerlessStatus

    @property
    def StorageId(self):
        r"""Storage Id.
        :rtype: str
        """
        return self._StorageId

    @StorageId.setter
    def StorageId(self, StorageId):
        self._StorageId = StorageId

    @property
    def Storage(self):
        r"""Storage size in gb.
        :rtype: int
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def MaxStorageSize(self):
        r"""Maximum storage specification, in gb.
        :rtype: int
        """
        return self._MaxStorageSize

    @MaxStorageSize.setter
    def MaxStorageSize(self, MaxStorageSize):
        self._MaxStorageSize = MaxStorageSize

    @property
    def MinStorageSize(self):
        r"""Specifies the minimum storage specification, in gb.
        :rtype: int
        """
        return self._MinStorageSize

    @MinStorageSize.setter
    def MinStorageSize(self, MinStorageSize):
        self._MinStorageSize = MinStorageSize

    @property
    def StoragePayMode(self):
        r"""Storage billing type. 1 indicates monthly subscription, and 0 indicates pay-as-you-go.
        :rtype: int
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def VpcName(self):
        r"""VPC name
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def VpcId(self):
        r"""Unique VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetName(self):
        r"""Subnet name
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def SubnetId(self):
        r"""Subnet ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Charset(self):
        r"""Character set
        :rtype: str
        """
        return self._Charset

    @Charset.setter
    def Charset(self, Charset):
        self._Charset = Charset

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DbType(self):
        r"""Database type
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def DbMode(self):
        r"""Db type: <li>NORMAL</li> <li>SERVERLESS</li>.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def DbVersion(self):
        r"""Database version
        :rtype: str
        """
        return self._DbVersion

    @DbVersion.setter
    def DbVersion(self, DbVersion):
        self._DbVersion = DbVersion

    @property
    def StorageLimit(self):
        r"""Specifies the maximum storage space.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def UsedStorage(self):
        r"""Used capacity
        :rtype: int
        """
        return self._UsedStorage

    @UsedStorage.setter
    def UsedStorage(self, UsedStorage):
        self._UsedStorage = UsedStorage

    @property
    def Vip(self):
        r"""VIP
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""vport
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def RoAddr(self):
        r"""VIP and vport of the read-only instance in a cluster
        :rtype: list of Addr
        """
        return self._RoAddr

    @RoAddr.setter
    def RoAddr(self, RoAddr):
        self._RoAddr = RoAddr

    @property
    def Ability(self):
        r"""Functions supported by the cluster.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.Ability`
        """
        return self._Ability

    @Ability.setter
    def Ability(self, Ability):
        self._Ability = Ability

    @property
    def CynosVersion(self):
        r"""Specifies the cynos version.
        :rtype: str
        """
        return self._CynosVersion

    @CynosVersion.setter
    def CynosVersion(self, CynosVersion):
        self._CynosVersion = CynosVersion

    @property
    def BusinessType(self):
        r"""Business type.
        :rtype: str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def HasSlaveZone(self):
        r"""Whether there is an availability zone.
        :rtype: str
        """
        return self._HasSlaveZone

    @HasSlaveZone.setter
    def HasSlaveZone(self, HasSlaveZone):
        self._HasSlaveZone = HasSlaveZone

    @property
    def IsFreeze(self):
        r"""Whether to freeze.
        :rtype: str
        """
        return self._IsFreeze

    @IsFreeze.setter
    def IsFreeze(self, IsFreeze):
        self._IsFreeze = IsFreeze

    @property
    def Tasks(self):
        r"""Task list.
        :rtype: list of ObjectTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def MasterZone(self):
        r"""Primary AZ.
        :rtype: str
        """
        return self._MasterZone

    @MasterZone.setter
    def MasterZone(self, MasterZone):
        self._MasterZone = MasterZone

    @property
    def SlaveZones(self):
        r"""Availability zone list.
        :rtype: list of str
        """
        return self._SlaveZones

    @SlaveZones.setter
    def SlaveZones(self, SlaveZones):
        self._SlaveZones = SlaveZones

    @property
    def InstanceSet(self):
        r"""Instance information
        :rtype: list of ClusterInstanceDetail
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def PayMode(self):
        r"""Billing mode
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def PeriodEndTime(self):
        r"""Expiration time
        :rtype: str
        """
        return self._PeriodEndTime

    @PeriodEndTime.setter
    def PeriodEndTime(self, PeriodEndTime):
        self._PeriodEndTime = PeriodEndTime

    @property
    def ProjectID(self):
        r"""Project ID
        :rtype: int
        """
        return self._ProjectID

    @ProjectID.setter
    def ProjectID(self, ProjectID):
        self._ProjectID = ProjectID

    @property
    def ResourceTags(self):
        r"""Array of tags bound to instance
        :rtype: list of Tag
        """
        return self._ResourceTags

    @ResourceTags.setter
    def ResourceTags(self, ResourceTags):
        self._ResourceTags = ResourceTags

    @property
    def ProxyStatus(self):
        r"""Proxy status.
        :rtype: str
        """
        return self._ProxyStatus

    @ProxyStatus.setter
    def ProxyStatus(self, ProxyStatus):
        self._ProxyStatus = ProxyStatus

    @property
    def LogBin(self):
        r"""binlog switch. valid values: ON, OFF.
        :rtype: str
        """
        return self._LogBin

    @LogBin.setter
    def LogBin(self, LogBin):
        self._LogBin = LogBin

    @property
    def IsSkipTrade(self):
        r"""Specifies whether to skip the transaction.
        :rtype: str
        """
        return self._IsSkipTrade

    @IsSkipTrade.setter
    def IsSkipTrade(self, IsSkipTrade):
        self._IsSkipTrade = IsSkipTrade

    @property
    def PitrType(self):
        r"""PITR type: valid values: normal, redo_pitr.
        :rtype: str
        """
        return self._PitrType

    @PitrType.setter
    def PitrType(self, PitrType):
        self._PitrType = PitrType

    @property
    def IsOpenPasswordComplexity(self):
        r"""Whether to enable password complexity.
        :rtype: str
        """
        return self._IsOpenPasswordComplexity

    @IsOpenPasswordComplexity.setter
    def IsOpenPasswordComplexity(self, IsOpenPasswordComplexity):
        self._IsOpenPasswordComplexity = IsOpenPasswordComplexity

    @property
    def NetworkStatus(self):
        r"""Network type.
        :rtype: str
        """
        return self._NetworkStatus

    @NetworkStatus.setter
    def NetworkStatus(self, NetworkStatus):
        self._NetworkStatus = NetworkStatus

    @property
    def ResourcePackages(self):
        r"""The resource package information that is bound to the cluster.	
        :rtype: list of ResourcePackage
        """
        return self._ResourcePackages

    @ResourcePackages.setter
    def ResourcePackages(self, ResourcePackages):
        self._ResourcePackages = ResourcePackages

    @property
    def RenewFlag(self):
        r"""Auto-Renewal flag. 1 indicates auto-renewal. 0 indicates non-renewal upon expiration.
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def NetworkType(self):
        r"""Specifies the node network type.
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def SlaveZoneAttr(self):
        r"""Secondary availability zone property.
        :rtype: list of SlaveZoneAttrItem
        """
        return self._SlaveZoneAttr

    @SlaveZoneAttr.setter
    def SlaveZoneAttr(self, SlaveZoneAttr):
        self._SlaveZoneAttr = SlaveZoneAttr

    @property
    def CynosVersionTag(self):
        r"""Version Tag.
        :rtype: str
        """
        return self._CynosVersionTag

    @CynosVersionTag.setter
    def CynosVersionTag(self, CynosVersionTag):
        self._CynosVersionTag = CynosVersionTag


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._Region = params.get("Region")
        self._Zone = params.get("Zone")
        self._PhysicalZone = params.get("PhysicalZone")
        self._Status = params.get("Status")
        self._StatusDesc = params.get("StatusDesc")
        self._ServerlessStatus = params.get("ServerlessStatus")
        self._StorageId = params.get("StorageId")
        self._Storage = params.get("Storage")
        self._MaxStorageSize = params.get("MaxStorageSize")
        self._MinStorageSize = params.get("MinStorageSize")
        self._StoragePayMode = params.get("StoragePayMode")
        self._VpcName = params.get("VpcName")
        self._VpcId = params.get("VpcId")
        self._SubnetName = params.get("SubnetName")
        self._SubnetId = params.get("SubnetId")
        self._Charset = params.get("Charset")
        self._CreateTime = params.get("CreateTime")
        self._DbType = params.get("DbType")
        self._DbMode = params.get("DbMode")
        self._DbVersion = params.get("DbVersion")
        self._StorageLimit = params.get("StorageLimit")
        self._UsedStorage = params.get("UsedStorage")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        if params.get("RoAddr") is not None:
            self._RoAddr = []
            for item in params.get("RoAddr"):
                obj = Addr()
                obj._deserialize(item)
                self._RoAddr.append(obj)
        if params.get("Ability") is not None:
            self._Ability = Ability()
            self._Ability._deserialize(params.get("Ability"))
        self._CynosVersion = params.get("CynosVersion")
        self._BusinessType = params.get("BusinessType")
        self._HasSlaveZone = params.get("HasSlaveZone")
        self._IsFreeze = params.get("IsFreeze")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ObjectTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._MasterZone = params.get("MasterZone")
        self._SlaveZones = params.get("SlaveZones")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = ClusterInstanceDetail()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._PayMode = params.get("PayMode")
        self._PeriodEndTime = params.get("PeriodEndTime")
        self._ProjectID = params.get("ProjectID")
        if params.get("ResourceTags") is not None:
            self._ResourceTags = []
            for item in params.get("ResourceTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ResourceTags.append(obj)
        self._ProxyStatus = params.get("ProxyStatus")
        self._LogBin = params.get("LogBin")
        self._IsSkipTrade = params.get("IsSkipTrade")
        self._PitrType = params.get("PitrType")
        self._IsOpenPasswordComplexity = params.get("IsOpenPasswordComplexity")
        self._NetworkStatus = params.get("NetworkStatus")
        if params.get("ResourcePackages") is not None:
            self._ResourcePackages = []
            for item in params.get("ResourcePackages"):
                obj = ResourcePackage()
                obj._deserialize(item)
                self._ResourcePackages.append(obj)
        self._RenewFlag = params.get("RenewFlag")
        self._NetworkType = params.get("NetworkType")
        if params.get("SlaveZoneAttr") is not None:
            self._SlaveZoneAttr = []
            for item in params.get("SlaveZoneAttr"):
                obj = SlaveZoneAttrItem()
                obj._deserialize(item)
                self._SlaveZoneAttr.append(obj)
        self._CynosVersionTag = params.get("CynosVersionTag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CynosdbErrorLogItem(AbstractModel):
    r"""Types of the returned error logs for an instance

    """

    def __init__(self):
        r"""
        :param _Timestamp: Log timestamp.
        :type Timestamp: int
        :param _Level: Log level.
        :type Level: str
        :param _Content: Log content.
        :type Content: str
        """
        self._Timestamp = None
        self._Level = None
        self._Content = None

    @property
    def Timestamp(self):
        r"""Log timestamp.
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Level(self):
        r"""Log level.
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Content(self):
        r"""Log content.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._Level = params.get("Level")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CynosdbInstance(AbstractModel):
    r"""Instance information

    """

    def __init__(self):
        r"""
        :param _Uin: User `Uin`
        :type Uin: str
        :param _AppId: User `AppId`
        :type AppId: int
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _ProjectId: Project ID
        :type ProjectId: int
        :param _Region: Region
        :type Region: str
        :param _Zone: AZ
        :type Zone: str
        :param _Status: Instance status
        :type Status: str
        :param _StatusDesc: Instance status description
        :type StatusDesc: str
        :param _DbMode: Instance type, which is used to indicate whether it is a serverless instance.
        :type DbMode: str
        :param _DbType: Database type
        :type DbType: str
        :param _DbVersion: Database version
        :type DbVersion: str
        :param _Cpu: Number of CPU cores
        :type Cpu: int
        :param _Memory: Memory in GB
        :type Memory: int
        :param _Storage: Storage capacity in GB
        :type Storage: int
        :param _InstanceType: Instance type
        :type InstanceType: str
        :param _InstanceRole: Current instance role
        :type InstanceRole: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _SubnetId: Subnet ID
        :type SubnetId: str
        :param _Vip: Private IP of instance
        :type Vip: str
        :param _Vport: Private port of instance
        :type Vport: int
        :param _PayMode: Billing mode
        :type PayMode: int
        :param _PeriodEndTime: Instance expiration time
        :type PeriodEndTime: str
        :param _DestroyDeadlineText: Termination deadline
        :type DestroyDeadlineText: str
        :param _IsolateTime: Isolation time
        :type IsolateTime: str
        :param _NetType: Network type
        :type NetType: int
        :param _WanDomain: Public domain name
        :type WanDomain: str
        :param _WanIP: Public IP
        :type WanIP: str
        :param _WanPort: Public port
        :type WanPort: int
        :param _WanStatus: Public network status
        :type WanStatus: str
        :param _DestroyTime: Instance termination time
        :type DestroyTime: str
        :param _CynosVersion: TDSQL-C kernel version
        :type CynosVersion: str
        :param _ProcessingTask: Task in progress
        :type ProcessingTask: str
        :param _RenewFlag: Renewal flag
        :type RenewFlag: int
        :param _MinCpu: Minimum number of CPU cores for serverless instance
        :type MinCpu: float
        :param _MaxCpu: Maximum number of CPU cores for serverless instance
        :type MaxCpu: float
        :param _ServerlessStatus: Serverless instance status. Valid values:
resume
pause
        :type ServerlessStatus: str
        :param _StorageId: Prepayment storage Id.
        :type StorageId: str
        :param _StoragePayMode: Storage billing mode
        :type StoragePayMode: int
        :param _PhysicalZone: Physical zone
        :type PhysicalZone: str
        :param _BusinessType: Business type.
        :type BusinessType: str
        :param _Tasks: Task
        :type Tasks: list of ObjectTask
        :param _IsFreeze: Whether to freeze.
        :type IsFreeze: str
        :param _ResourceTags: The resource tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceTags: list of Tag
        :param _MasterZone: Primary AZ.
        :type MasterZone: str
        :param _SlaveZones: Replica AZ
Note: This field may return null, indicating that no valid value can be obtained.
        :type SlaveZones: list of str
        :param _InstanceNetInfo: Network information of the instance.
        :type InstanceNetInfo: list of InstanceNetInfo
        :param _ResourcePackages: Information of the resource pack bound to an instance when `packageType` is `CCU`. Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourcePackages: list of ResourcePackage
        :param _InstanceIndexMode: Specifies the instance index form. valid values include mixedRowColumn (row and column hybrid storage) and onlyRowIndex (row-only storage).
        :type InstanceIndexMode: str
        :param _InstanceAbility: Supported capabilities of the existing instance.
        :type InstanceAbility: :class:`tencentcloud.cynosdb.v20190107.models.InstanceAbility`
        :param _DeviceType: Instance machine type.
        :type DeviceType: str
        :param _InstanceStorageType: Specifies the instance storage type.
        :type InstanceStorageType: str
        :param _CynosVersionTag: Unknown field.
        :type CynosVersionTag: str
        :param _NodeList: Specifies the node information of libradb.
        :type NodeList: list of str
        """
        self._Uin = None
        self._AppId = None
        self._ClusterId = None
        self._ClusterName = None
        self._InstanceId = None
        self._InstanceName = None
        self._ProjectId = None
        self._Region = None
        self._Zone = None
        self._Status = None
        self._StatusDesc = None
        self._DbMode = None
        self._DbType = None
        self._DbVersion = None
        self._Cpu = None
        self._Memory = None
        self._Storage = None
        self._InstanceType = None
        self._InstanceRole = None
        self._UpdateTime = None
        self._CreateTime = None
        self._VpcId = None
        self._SubnetId = None
        self._Vip = None
        self._Vport = None
        self._PayMode = None
        self._PeriodEndTime = None
        self._DestroyDeadlineText = None
        self._IsolateTime = None
        self._NetType = None
        self._WanDomain = None
        self._WanIP = None
        self._WanPort = None
        self._WanStatus = None
        self._DestroyTime = None
        self._CynosVersion = None
        self._ProcessingTask = None
        self._RenewFlag = None
        self._MinCpu = None
        self._MaxCpu = None
        self._ServerlessStatus = None
        self._StorageId = None
        self._StoragePayMode = None
        self._PhysicalZone = None
        self._BusinessType = None
        self._Tasks = None
        self._IsFreeze = None
        self._ResourceTags = None
        self._MasterZone = None
        self._SlaveZones = None
        self._InstanceNetInfo = None
        self._ResourcePackages = None
        self._InstanceIndexMode = None
        self._InstanceAbility = None
        self._DeviceType = None
        self._InstanceStorageType = None
        self._CynosVersionTag = None
        self._NodeList = None

    @property
    def Uin(self):
        r"""User `Uin`
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def AppId(self):
        r"""User `AppId`
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ProjectId(self):
        r"""Project ID
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Status(self):
        r"""Instance status
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusDesc(self):
        r"""Instance status description
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def DbMode(self):
        r"""Instance type, which is used to indicate whether it is a serverless instance.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def DbType(self):
        r"""Database type
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def DbVersion(self):
        r"""Database version
        :rtype: str
        """
        return self._DbVersion

    @DbVersion.setter
    def DbVersion(self, DbVersion):
        self._DbVersion = DbVersion

    @property
    def Cpu(self):
        r"""Number of CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory in GB
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Storage(self):
        r"""Storage capacity in GB
        :rtype: int
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def InstanceType(self):
        r"""Instance type
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceRole(self):
        r"""Current instance role
        :rtype: str
        """
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def VpcId(self):
        r"""VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Vip(self):
        r"""Private IP of instance
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Private port of instance
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def PayMode(self):
        r"""Billing mode
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def PeriodEndTime(self):
        r"""Instance expiration time
        :rtype: str
        """
        return self._PeriodEndTime

    @PeriodEndTime.setter
    def PeriodEndTime(self, PeriodEndTime):
        self._PeriodEndTime = PeriodEndTime

    @property
    def DestroyDeadlineText(self):
        r"""Termination deadline
        :rtype: str
        """
        return self._DestroyDeadlineText

    @DestroyDeadlineText.setter
    def DestroyDeadlineText(self, DestroyDeadlineText):
        self._DestroyDeadlineText = DestroyDeadlineText

    @property
    def IsolateTime(self):
        r"""Isolation time
        :rtype: str
        """
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def NetType(self):
        r"""Network type
        :rtype: int
        """
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def WanDomain(self):
        r"""Public domain name
        :rtype: str
        """
        return self._WanDomain

    @WanDomain.setter
    def WanDomain(self, WanDomain):
        self._WanDomain = WanDomain

    @property
    def WanIP(self):
        r"""Public IP
        :rtype: str
        """
        return self._WanIP

    @WanIP.setter
    def WanIP(self, WanIP):
        self._WanIP = WanIP

    @property
    def WanPort(self):
        r"""Public port
        :rtype: int
        """
        return self._WanPort

    @WanPort.setter
    def WanPort(self, WanPort):
        self._WanPort = WanPort

    @property
    def WanStatus(self):
        r"""Public network status
        :rtype: str
        """
        return self._WanStatus

    @WanStatus.setter
    def WanStatus(self, WanStatus):
        self._WanStatus = WanStatus

    @property
    def DestroyTime(self):
        r"""Instance termination time
        :rtype: str
        """
        return self._DestroyTime

    @DestroyTime.setter
    def DestroyTime(self, DestroyTime):
        self._DestroyTime = DestroyTime

    @property
    def CynosVersion(self):
        r"""TDSQL-C kernel version
        :rtype: str
        """
        return self._CynosVersion

    @CynosVersion.setter
    def CynosVersion(self, CynosVersion):
        self._CynosVersion = CynosVersion

    @property
    def ProcessingTask(self):
        r"""Task in progress
        :rtype: str
        """
        return self._ProcessingTask

    @ProcessingTask.setter
    def ProcessingTask(self, ProcessingTask):
        self._ProcessingTask = ProcessingTask

    @property
    def RenewFlag(self):
        r"""Renewal flag
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def MinCpu(self):
        r"""Minimum number of CPU cores for serverless instance
        :rtype: float
        """
        return self._MinCpu

    @MinCpu.setter
    def MinCpu(self, MinCpu):
        self._MinCpu = MinCpu

    @property
    def MaxCpu(self):
        r"""Maximum number of CPU cores for serverless instance
        :rtype: float
        """
        return self._MaxCpu

    @MaxCpu.setter
    def MaxCpu(self, MaxCpu):
        self._MaxCpu = MaxCpu

    @property
    def ServerlessStatus(self):
        r"""Serverless instance status. Valid values:
resume
pause
        :rtype: str
        """
        return self._ServerlessStatus

    @ServerlessStatus.setter
    def ServerlessStatus(self, ServerlessStatus):
        self._ServerlessStatus = ServerlessStatus

    @property
    def StorageId(self):
        r"""Prepayment storage Id.
        :rtype: str
        """
        return self._StorageId

    @StorageId.setter
    def StorageId(self, StorageId):
        self._StorageId = StorageId

    @property
    def StoragePayMode(self):
        r"""Storage billing mode
        :rtype: int
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def PhysicalZone(self):
        r"""Physical zone
        :rtype: str
        """
        return self._PhysicalZone

    @PhysicalZone.setter
    def PhysicalZone(self, PhysicalZone):
        self._PhysicalZone = PhysicalZone

    @property
    def BusinessType(self):
        r"""Business type.
        :rtype: str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def Tasks(self):
        r"""Task
        :rtype: list of ObjectTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def IsFreeze(self):
        r"""Whether to freeze.
        :rtype: str
        """
        return self._IsFreeze

    @IsFreeze.setter
    def IsFreeze(self, IsFreeze):
        self._IsFreeze = IsFreeze

    @property
    def ResourceTags(self):
        r"""The resource tag
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of Tag
        """
        return self._ResourceTags

    @ResourceTags.setter
    def ResourceTags(self, ResourceTags):
        self._ResourceTags = ResourceTags

    @property
    def MasterZone(self):
        r"""Primary AZ.
        :rtype: str
        """
        return self._MasterZone

    @MasterZone.setter
    def MasterZone(self, MasterZone):
        self._MasterZone = MasterZone

    @property
    def SlaveZones(self):
        r"""Replica AZ
Note: This field may return null, indicating that no valid value can be obtained.
        :rtype: list of str
        """
        return self._SlaveZones

    @SlaveZones.setter
    def SlaveZones(self, SlaveZones):
        self._SlaveZones = SlaveZones

    @property
    def InstanceNetInfo(self):
        r"""Network information of the instance.
        :rtype: list of InstanceNetInfo
        """
        return self._InstanceNetInfo

    @InstanceNetInfo.setter
    def InstanceNetInfo(self, InstanceNetInfo):
        self._InstanceNetInfo = InstanceNetInfo

    @property
    def ResourcePackages(self):
        r"""Information of the resource pack bound to an instance when `packageType` is `CCU`. Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ResourcePackage
        """
        return self._ResourcePackages

    @ResourcePackages.setter
    def ResourcePackages(self, ResourcePackages):
        self._ResourcePackages = ResourcePackages

    @property
    def InstanceIndexMode(self):
        r"""Specifies the instance index form. valid values include mixedRowColumn (row and column hybrid storage) and onlyRowIndex (row-only storage).
        :rtype: str
        """
        return self._InstanceIndexMode

    @InstanceIndexMode.setter
    def InstanceIndexMode(self, InstanceIndexMode):
        self._InstanceIndexMode = InstanceIndexMode

    @property
    def InstanceAbility(self):
        r"""Supported capabilities of the existing instance.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.InstanceAbility`
        """
        return self._InstanceAbility

    @InstanceAbility.setter
    def InstanceAbility(self, InstanceAbility):
        self._InstanceAbility = InstanceAbility

    @property
    def DeviceType(self):
        r"""Instance machine type.
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType

    @property
    def InstanceStorageType(self):
        r"""Specifies the instance storage type.
        :rtype: str
        """
        return self._InstanceStorageType

    @InstanceStorageType.setter
    def InstanceStorageType(self, InstanceStorageType):
        self._InstanceStorageType = InstanceStorageType

    @property
    def CynosVersionTag(self):
        r"""Unknown field.
        :rtype: str
        """
        return self._CynosVersionTag

    @CynosVersionTag.setter
    def CynosVersionTag(self, CynosVersionTag):
        self._CynosVersionTag = CynosVersionTag

    @property
    def NodeList(self):
        r"""Specifies the node information of libradb.
        :rtype: list of str
        """
        return self._NodeList

    @NodeList.setter
    def NodeList(self, NodeList):
        self._NodeList = NodeList


    def _deserialize(self, params):
        self._Uin = params.get("Uin")
        self._AppId = params.get("AppId")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._ProjectId = params.get("ProjectId")
        self._Region = params.get("Region")
        self._Zone = params.get("Zone")
        self._Status = params.get("Status")
        self._StatusDesc = params.get("StatusDesc")
        self._DbMode = params.get("DbMode")
        self._DbType = params.get("DbType")
        self._DbVersion = params.get("DbVersion")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._Storage = params.get("Storage")
        self._InstanceType = params.get("InstanceType")
        self._InstanceRole = params.get("InstanceRole")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateTime = params.get("CreateTime")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._PayMode = params.get("PayMode")
        self._PeriodEndTime = params.get("PeriodEndTime")
        self._DestroyDeadlineText = params.get("DestroyDeadlineText")
        self._IsolateTime = params.get("IsolateTime")
        self._NetType = params.get("NetType")
        self._WanDomain = params.get("WanDomain")
        self._WanIP = params.get("WanIP")
        self._WanPort = params.get("WanPort")
        self._WanStatus = params.get("WanStatus")
        self._DestroyTime = params.get("DestroyTime")
        self._CynosVersion = params.get("CynosVersion")
        self._ProcessingTask = params.get("ProcessingTask")
        self._RenewFlag = params.get("RenewFlag")
        self._MinCpu = params.get("MinCpu")
        self._MaxCpu = params.get("MaxCpu")
        self._ServerlessStatus = params.get("ServerlessStatus")
        self._StorageId = params.get("StorageId")
        self._StoragePayMode = params.get("StoragePayMode")
        self._PhysicalZone = params.get("PhysicalZone")
        self._BusinessType = params.get("BusinessType")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ObjectTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._IsFreeze = params.get("IsFreeze")
        if params.get("ResourceTags") is not None:
            self._ResourceTags = []
            for item in params.get("ResourceTags"):
                obj = Tag()
                obj._deserialize(item)
                self._ResourceTags.append(obj)
        self._MasterZone = params.get("MasterZone")
        self._SlaveZones = params.get("SlaveZones")
        if params.get("InstanceNetInfo") is not None:
            self._InstanceNetInfo = []
            for item in params.get("InstanceNetInfo"):
                obj = InstanceNetInfo()
                obj._deserialize(item)
                self._InstanceNetInfo.append(obj)
        if params.get("ResourcePackages") is not None:
            self._ResourcePackages = []
            for item in params.get("ResourcePackages"):
                obj = ResourcePackage()
                obj._deserialize(item)
                self._ResourcePackages.append(obj)
        self._InstanceIndexMode = params.get("InstanceIndexMode")
        if params.get("InstanceAbility") is not None:
            self._InstanceAbility = InstanceAbility()
            self._InstanceAbility._deserialize(params.get("InstanceAbility"))
        self._DeviceType = params.get("DeviceType")
        self._InstanceStorageType = params.get("InstanceStorageType")
        self._CynosVersionTag = params.get("CynosVersionTag")
        self._NodeList = params.get("NodeList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CynosdbInstanceDetail(AbstractModel):
    r"""Instance details

    """

    def __init__(self):
        r"""
        :param _Uin: User `Uin`
        :type Uin: str
        :param _AppId: User `AppId`
        :type AppId: int
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _ProjectId: Project ID
        :type ProjectId: int
        :param _Region: Region
        :type Region: str
        :param _Zone: AZ
        :type Zone: str
        :param _Status: Instance status
        :type Status: str
        :param _StatusDesc: Instance status description
        :type StatusDesc: str
        :param _ServerlessStatus: Serverless instance status. Valid values:
resume
pause
        :type ServerlessStatus: str
        :param _DbType: Database type
        :type DbType: str
        :param _DbVersion: Database version
        :type DbVersion: str
        :param _Cpu: Number of CPU cores
        :type Cpu: int
        :param _Memory: Memory in GB
        :type Memory: int
        :param _Storage: Storage capacity in GB
        :type Storage: int
        :param _InstanceType: Instance type
        :type InstanceType: str
        :param _InstanceRole: Current instance role
        :type InstanceRole: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _PayMode: Billing mode
        :type PayMode: int
        :param _PeriodEndTime: Instance expiration time
        :type PeriodEndTime: str
        :param _NetType: Network type
        :type NetType: int
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _SubnetId: Subnet ID
        :type SubnetId: str
        :param _Vip: Private IP of instance
        :type Vip: str
        :param _Vport: Private port of instance
        :type Vport: int
        :param _WanDomain: Public domain name of instance
        :type WanDomain: str
        :param _Charset: Character set
        :type Charset: str
        :param _CynosVersion: TDSQL-C kernel version
        :type CynosVersion: str
        :param _RenewFlag: Renewal flag
        :type RenewFlag: int
        :param _MinCpu: The minimum number of CPU cores for a serverless instance
        :type MinCpu: float
        :param _MaxCpu: The maximum number of CPU cores for a serverless instance
        :type MaxCpu: float
        :param _DbMode: Db type: <li>NORMAL</li> <li>SERVERLESS</li>.
        :type DbMode: str
        """
        self._Uin = None
        self._AppId = None
        self._ClusterId = None
        self._ClusterName = None
        self._InstanceId = None
        self._InstanceName = None
        self._ProjectId = None
        self._Region = None
        self._Zone = None
        self._Status = None
        self._StatusDesc = None
        self._ServerlessStatus = None
        self._DbType = None
        self._DbVersion = None
        self._Cpu = None
        self._Memory = None
        self._Storage = None
        self._InstanceType = None
        self._InstanceRole = None
        self._UpdateTime = None
        self._CreateTime = None
        self._PayMode = None
        self._PeriodEndTime = None
        self._NetType = None
        self._VpcId = None
        self._SubnetId = None
        self._Vip = None
        self._Vport = None
        self._WanDomain = None
        self._Charset = None
        self._CynosVersion = None
        self._RenewFlag = None
        self._MinCpu = None
        self._MaxCpu = None
        self._DbMode = None

    @property
    def Uin(self):
        r"""User `Uin`
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def AppId(self):
        r"""User `AppId`
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ProjectId(self):
        r"""Project ID
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Status(self):
        r"""Instance status
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusDesc(self):
        r"""Instance status description
        :rtype: str
        """
        return self._StatusDesc

    @StatusDesc.setter
    def StatusDesc(self, StatusDesc):
        self._StatusDesc = StatusDesc

    @property
    def ServerlessStatus(self):
        r"""Serverless instance status. Valid values:
resume
pause
        :rtype: str
        """
        return self._ServerlessStatus

    @ServerlessStatus.setter
    def ServerlessStatus(self, ServerlessStatus):
        self._ServerlessStatus = ServerlessStatus

    @property
    def DbType(self):
        r"""Database type
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def DbVersion(self):
        r"""Database version
        :rtype: str
        """
        return self._DbVersion

    @DbVersion.setter
    def DbVersion(self, DbVersion):
        self._DbVersion = DbVersion

    @property
    def Cpu(self):
        r"""Number of CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory in GB
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Storage(self):
        r"""Storage capacity in GB
        :rtype: int
        """
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def InstanceType(self):
        r"""Instance type
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceRole(self):
        r"""Current instance role
        :rtype: str
        """
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def UpdateTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def PayMode(self):
        r"""Billing mode
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def PeriodEndTime(self):
        r"""Instance expiration time
        :rtype: str
        """
        return self._PeriodEndTime

    @PeriodEndTime.setter
    def PeriodEndTime(self, PeriodEndTime):
        self._PeriodEndTime = PeriodEndTime

    @property
    def NetType(self):
        r"""Network type
        :rtype: int
        """
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def VpcId(self):
        r"""VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Subnet ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Vip(self):
        r"""Private IP of instance
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Private port of instance
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def WanDomain(self):
        r"""Public domain name of instance
        :rtype: str
        """
        return self._WanDomain

    @WanDomain.setter
    def WanDomain(self, WanDomain):
        self._WanDomain = WanDomain

    @property
    def Charset(self):
        r"""Character set
        :rtype: str
        """
        return self._Charset

    @Charset.setter
    def Charset(self, Charset):
        self._Charset = Charset

    @property
    def CynosVersion(self):
        r"""TDSQL-C kernel version
        :rtype: str
        """
        return self._CynosVersion

    @CynosVersion.setter
    def CynosVersion(self, CynosVersion):
        self._CynosVersion = CynosVersion

    @property
    def RenewFlag(self):
        r"""Renewal flag
        :rtype: int
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def MinCpu(self):
        r"""The minimum number of CPU cores for a serverless instance
        :rtype: float
        """
        return self._MinCpu

    @MinCpu.setter
    def MinCpu(self, MinCpu):
        self._MinCpu = MinCpu

    @property
    def MaxCpu(self):
        r"""The maximum number of CPU cores for a serverless instance
        :rtype: float
        """
        return self._MaxCpu

    @MaxCpu.setter
    def MaxCpu(self, MaxCpu):
        self._MaxCpu = MaxCpu

    @property
    def DbMode(self):
        r"""Db type: <li>NORMAL</li> <li>SERVERLESS</li>.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode


    def _deserialize(self, params):
        self._Uin = params.get("Uin")
        self._AppId = params.get("AppId")
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._ProjectId = params.get("ProjectId")
        self._Region = params.get("Region")
        self._Zone = params.get("Zone")
        self._Status = params.get("Status")
        self._StatusDesc = params.get("StatusDesc")
        self._ServerlessStatus = params.get("ServerlessStatus")
        self._DbType = params.get("DbType")
        self._DbVersion = params.get("DbVersion")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._Storage = params.get("Storage")
        self._InstanceType = params.get("InstanceType")
        self._InstanceRole = params.get("InstanceRole")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateTime = params.get("CreateTime")
        self._PayMode = params.get("PayMode")
        self._PeriodEndTime = params.get("PeriodEndTime")
        self._NetType = params.get("NetType")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._WanDomain = params.get("WanDomain")
        self._Charset = params.get("Charset")
        self._CynosVersion = params.get("CynosVersion")
        self._RenewFlag = params.get("RenewFlag")
        self._MinCpu = params.get("MinCpu")
        self._MaxCpu = params.get("MaxCpu")
        self._DbMode = params.get("DbMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CynosdbInstanceGrp(AbstractModel):
    r"""Instance group information

    """

    def __init__(self):
        r"""
        :param _AppId: User `appId`
        :type AppId: int
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _CreatedTime: Creation time
        :type CreatedTime: str
        :param _DeletedTime: Deletion time
        :type DeletedTime: str
        :param _InstanceGrpId: Instance group ID
        :type InstanceGrpId: str
        :param _Status: Status
        :type Status: str
        :param _Type: Instance group type. ha: HA group; ro: RO group
        :type Type: str
        :param _UpdatedTime: Update time
        :type UpdatedTime: str
        :param _Vip: Private IP
        :type Vip: str
        :param _Vport: Private port
        :type Vport: int
        :param _WanDomain: Public domain name
        :type WanDomain: str
        :param _WanIP: Public IP
        :type WanIP: str
        :param _WanPort: Public port
        :type WanPort: int
        :param _WanStatus: Public network status
        :type WanStatus: str
        :param _InstanceSet: Information of instances contained in instance group
        :type InstanceSet: list of CynosdbInstance
        :param _UniqVpcId: VPC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UniqVpcId: str
        :param _UniqSubnetId: Subnet ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UniqSubnetId: str
        :param _OldAddrInfo: Information of the old IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type OldAddrInfo: :class:`tencentcloud.cynosdb.v20190107.models.OldAddrInfo`
        :param _ProcessingTasks: Task in progress
        :type ProcessingTasks: list of str
        :param _Tasks: Task list
        :type Tasks: list of ObjectTask
        :param _NetServiceId: biz_net_service table ID
        :type NetServiceId: int
        """
        self._AppId = None
        self._ClusterId = None
        self._CreatedTime = None
        self._DeletedTime = None
        self._InstanceGrpId = None
        self._Status = None
        self._Type = None
        self._UpdatedTime = None
        self._Vip = None
        self._Vport = None
        self._WanDomain = None
        self._WanIP = None
        self._WanPort = None
        self._WanStatus = None
        self._InstanceSet = None
        self._UniqVpcId = None
        self._UniqSubnetId = None
        self._OldAddrInfo = None
        self._ProcessingTasks = None
        self._Tasks = None
        self._NetServiceId = None

    @property
    def AppId(self):
        r"""User `appId`
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def CreatedTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def DeletedTime(self):
        r"""Deletion time
        :rtype: str
        """
        return self._DeletedTime

    @DeletedTime.setter
    def DeletedTime(self, DeletedTime):
        self._DeletedTime = DeletedTime

    @property
    def InstanceGrpId(self):
        r"""Instance group ID
        :rtype: str
        """
        return self._InstanceGrpId

    @InstanceGrpId.setter
    def InstanceGrpId(self, InstanceGrpId):
        self._InstanceGrpId = InstanceGrpId

    @property
    def Status(self):
        r"""Status
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Type(self):
        r"""Instance group type. ha: HA group; ro: RO group
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UpdatedTime(self):
        r"""Update time
        :rtype: str
        """
        return self._UpdatedTime

    @UpdatedTime.setter
    def UpdatedTime(self, UpdatedTime):
        self._UpdatedTime = UpdatedTime

    @property
    def Vip(self):
        r"""Private IP
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Private port
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def WanDomain(self):
        r"""Public domain name
        :rtype: str
        """
        return self._WanDomain

    @WanDomain.setter
    def WanDomain(self, WanDomain):
        self._WanDomain = WanDomain

    @property
    def WanIP(self):
        r"""Public IP
        :rtype: str
        """
        return self._WanIP

    @WanIP.setter
    def WanIP(self, WanIP):
        self._WanIP = WanIP

    @property
    def WanPort(self):
        r"""Public port
        :rtype: int
        """
        return self._WanPort

    @WanPort.setter
    def WanPort(self, WanPort):
        self._WanPort = WanPort

    @property
    def WanStatus(self):
        r"""Public network status
        :rtype: str
        """
        return self._WanStatus

    @WanStatus.setter
    def WanStatus(self, WanStatus):
        self._WanStatus = WanStatus

    @property
    def InstanceSet(self):
        r"""Information of instances contained in instance group
        :rtype: list of CynosdbInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def UniqVpcId(self):
        r"""VPC ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UniqVpcId

    @UniqVpcId.setter
    def UniqVpcId(self, UniqVpcId):
        self._UniqVpcId = UniqVpcId

    @property
    def UniqSubnetId(self):
        r"""Subnet ID
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._UniqSubnetId

    @UniqSubnetId.setter
    def UniqSubnetId(self, UniqSubnetId):
        self._UniqSubnetId = UniqSubnetId

    @property
    def OldAddrInfo(self):
        r"""Information of the old IP
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.OldAddrInfo`
        """
        return self._OldAddrInfo

    @OldAddrInfo.setter
    def OldAddrInfo(self, OldAddrInfo):
        self._OldAddrInfo = OldAddrInfo

    @property
    def ProcessingTasks(self):
        r"""Task in progress
        :rtype: list of str
        """
        return self._ProcessingTasks

    @ProcessingTasks.setter
    def ProcessingTasks(self, ProcessingTasks):
        self._ProcessingTasks = ProcessingTasks

    @property
    def Tasks(self):
        r"""Task list
        :rtype: list of ObjectTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def NetServiceId(self):
        r"""biz_net_service table ID
        :rtype: int
        """
        return self._NetServiceId

    @NetServiceId.setter
    def NetServiceId(self, NetServiceId):
        self._NetServiceId = NetServiceId


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._ClusterId = params.get("ClusterId")
        self._CreatedTime = params.get("CreatedTime")
        self._DeletedTime = params.get("DeletedTime")
        self._InstanceGrpId = params.get("InstanceGrpId")
        self._Status = params.get("Status")
        self._Type = params.get("Type")
        self._UpdatedTime = params.get("UpdatedTime")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._WanDomain = params.get("WanDomain")
        self._WanIP = params.get("WanIP")
        self._WanPort = params.get("WanPort")
        self._WanStatus = params.get("WanStatus")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CynosdbInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._UniqVpcId = params.get("UniqVpcId")
        self._UniqSubnetId = params.get("UniqSubnetId")
        if params.get("OldAddrInfo") is not None:
            self._OldAddrInfo = OldAddrInfo()
            self._OldAddrInfo._deserialize(params.get("OldAddrInfo"))
        self._ProcessingTasks = params.get("ProcessingTasks")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ObjectTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._NetServiceId = params.get("NetServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabasePrivileges(AbstractModel):
    r"""Database permission list

    """

    def __init__(self):
        r"""
        :param _Db: Database.
        :type Db: str
        :param _Privileges: Permission list
        :type Privileges: list of str
        """
        self._Db = None
        self._Privileges = None

    @property
    def Db(self):
        r"""Database.
        :rtype: str
        """
        return self._Db

    @Db.setter
    def Db(self, Db):
        self._Db = Db

    @property
    def Privileges(self):
        r"""Permission list
        :rtype: list of str
        """
        return self._Privileges

    @Privileges.setter
    def Privileges(self, Privileges):
        self._Privileges = Privileges


    def _deserialize(self, params):
        self._Db = params.get("Db")
        self._Privileges = params.get("Privileges")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseTables(AbstractModel):
    r"""Database table information

    """

    def __init__(self):
        r"""
        :param _Database: Database name
        :type Database: str
        :param _Tables: Table name list.
        :type Tables: list of str
        """
        self._Database = None
        self._Tables = None

    @property
    def Database(self):
        r"""Database name
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def Tables(self):
        r"""Table name list.
        :rtype: list of str
        """
        return self._Tables

    @Tables.setter
    def Tables(self, Tables):
        self._Tables = Tables


    def _deserialize(self, params):
        self._Database = params.get("Database")
        self._Tables = params.get("Tables")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DbInfo(AbstractModel):
    r"""Database details

    """

    def __init__(self):
        r"""
        :param _DbName: Database name
        :type DbName: str
        :param _CharacterSet: Character set
        :type CharacterSet: str
        :param _Status: Database status
        :type Status: str
        :param _CollateRule: Collation
        :type CollateRule: str
        :param _Description: Specifies the remark of the database.
        :type Description: str
        :param _UserHostPrivileges: User permission
        :type UserHostPrivileges: list of UserHostPrivilege
        :param _DbId: Database ID
        :type DbId: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        :param _AppId: User appid.
        :type AppId: int
        :param _Uin: User UIN
        :type Uin: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._DbName = None
        self._CharacterSet = None
        self._Status = None
        self._CollateRule = None
        self._Description = None
        self._UserHostPrivileges = None
        self._DbId = None
        self._CreateTime = None
        self._UpdateTime = None
        self._AppId = None
        self._Uin = None
        self._ClusterId = None

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def CharacterSet(self):
        r"""Character set
        :rtype: str
        """
        return self._CharacterSet

    @CharacterSet.setter
    def CharacterSet(self, CharacterSet):
        self._CharacterSet = CharacterSet

    @property
    def Status(self):
        r"""Database status
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CollateRule(self):
        r"""Collation
        :rtype: str
        """
        return self._CollateRule

    @CollateRule.setter
    def CollateRule(self, CollateRule):
        self._CollateRule = CollateRule

    @property
    def Description(self):
        r"""Specifies the remark of the database.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def UserHostPrivileges(self):
        r"""User permission
        :rtype: list of UserHostPrivilege
        """
        return self._UserHostPrivileges

    @UserHostPrivileges.setter
    def UserHostPrivileges(self, UserHostPrivileges):
        self._UserHostPrivileges = UserHostPrivileges

    @property
    def DbId(self):
        r"""Database ID
        :rtype: int
        """
        return self._DbId

    @DbId.setter
    def DbId(self, DbId):
        self._DbId = DbId

    @property
    def CreateTime(self):
        r"""Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        r"""Update time.
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def AppId(self):
        r"""User appid.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        r"""User UIN
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._DbName = params.get("DbName")
        self._CharacterSet = params.get("CharacterSet")
        self._Status = params.get("Status")
        self._CollateRule = params.get("CollateRule")
        self._Description = params.get("Description")
        if params.get("UserHostPrivileges") is not None:
            self._UserHostPrivileges = []
            for item in params.get("UserHostPrivileges"):
                obj = UserHostPrivilege()
                obj._deserialize(item)
                self._UserHostPrivileges.append(obj)
        self._DbId = params.get("DbId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccountsRequest(AbstractModel):
    r"""DeleteAccounts request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Accounts: Accounts in array, which contains `account` and `host`.
        :type Accounts: list of InputAccount
        """
        self._ClusterId = None
        self._Accounts = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Accounts(self):
        r"""Accounts in array, which contains `account` and `host`.
        :rtype: list of InputAccount
        """
        return self._Accounts

    @Accounts.setter
    def Accounts(self, Accounts):
        self._Accounts = Accounts


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("Accounts") is not None:
            self._Accounts = []
            for item in params.get("Accounts"):
                obj = InputAccount()
                obj._deserialize(item)
                self._Accounts.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccountsResponse(AbstractModel):
    r"""DeleteAccounts response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAuditRuleTemplatesRequest(AbstractModel):
    r"""DeleteAuditRuleTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _RuleTemplateIds: Audit rule template ID
        :type RuleTemplateIds: list of str
        """
        self._RuleTemplateIds = None

    @property
    def RuleTemplateIds(self):
        r"""Audit rule template ID
        :rtype: list of str
        """
        return self._RuleTemplateIds

    @RuleTemplateIds.setter
    def RuleTemplateIds(self, RuleTemplateIds):
        self._RuleTemplateIds = RuleTemplateIds


    def _deserialize(self, params):
        self._RuleTemplateIds = params.get("RuleTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAuditRuleTemplatesResponse(AbstractModel):
    r"""DeleteAuditRuleTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBackupRequest(AbstractModel):
    r"""DeleteBackup request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _SnapshotIdList: Backup file ID. This field is used by legacy versions and thus not recommended.
        :type SnapshotIdList: list of int
        :param _BackupIds: Backup file ID. This field is recommended.
        :type BackupIds: list of int
        """
        self._ClusterId = None
        self._SnapshotIdList = None
        self._BackupIds = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SnapshotIdList(self):
        r"""Backup file ID. This field is used by legacy versions and thus not recommended.
        :rtype: list of int
        """
        return self._SnapshotIdList

    @SnapshotIdList.setter
    def SnapshotIdList(self, SnapshotIdList):
        self._SnapshotIdList = SnapshotIdList

    @property
    def BackupIds(self):
        r"""Backup file ID. This field is recommended.
        :rtype: list of int
        """
        return self._BackupIds

    @BackupIds.setter
    def BackupIds(self, BackupIds):
        self._BackupIds = BackupIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SnapshotIdList = params.get("SnapshotIdList")
        self._BackupIds = params.get("BackupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBackupResponse(AbstractModel):
    r"""DeleteBackup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCLSDeliveryRequest(AbstractModel):
    r"""DeleteCLSDelivery request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _CLSTopicIds: Log topic ID.
        :type CLSTopicIds: list of str
        :param _LogType: Log type.
        :type LogType: str
        :param _IsInMaintainPeriod: Whether the maintenance time is in operation.
        :type IsInMaintainPeriod: str
        """
        self._InstanceId = None
        self._CLSTopicIds = None
        self._LogType = None
        self._IsInMaintainPeriod = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CLSTopicIds(self):
        r"""Log topic ID.
        :rtype: list of str
        """
        return self._CLSTopicIds

    @CLSTopicIds.setter
    def CLSTopicIds(self, CLSTopicIds):
        self._CLSTopicIds = CLSTopicIds

    @property
    def LogType(self):
        r"""Log type.
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def IsInMaintainPeriod(self):
        r"""Whether the maintenance time is in operation.
        :rtype: str
        """
        return self._IsInMaintainPeriod

    @IsInMaintainPeriod.setter
    def IsInMaintainPeriod(self, IsInMaintainPeriod):
        self._IsInMaintainPeriod = IsInMaintainPeriod


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._CLSTopicIds = params.get("CLSTopicIds")
        self._LogType = params.get("LogType")
        self._IsInMaintainPeriod = params.get("IsInMaintainPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCLSDeliveryResponse(AbstractModel):
    r"""DeleteCLSDelivery response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Asynchronous task ID.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Asynchronous task ID.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DeleteClusterDatabaseRequest(AbstractModel):
    r"""DeleteClusterDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _DbNames: 
        :type DbNames: list of str
        """
        self._ClusterId = None
        self._DbNames = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DbNames(self):
        r"""
        :rtype: list of str
        """
        return self._DbNames

    @DbNames.setter
    def DbNames(self, DbNames):
        self._DbNames = DbNames


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DbNames = params.get("DbNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterDatabaseResponse(AbstractModel):
    r"""DeleteClusterDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteParamTemplateRequest(AbstractModel):
    r"""DeleteParamTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Parameter template ID
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        r"""Parameter template ID
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteParamTemplateResponse(AbstractModel):
    r"""DeleteParamTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeliverSummary(AbstractModel):
    r"""Log shipping information.

    """

    def __init__(self):
        r"""
        :param _DeliverType: Select the delivery type, storage class, message channel.
        :type DeliverType: str
        :param _DeliverSubType: Specifies the delivery subtype: cls, ckafka.
        :type DeliverSubType: str
        :param _DeliverConsumer: Sender.
        :type DeliverConsumer: str
        :param _DeliverConsumerName: Specifies the name of the sender.
        :type DeliverConsumerName: str
        """
        self._DeliverType = None
        self._DeliverSubType = None
        self._DeliverConsumer = None
        self._DeliverConsumerName = None

    @property
    def DeliverType(self):
        r"""Select the delivery type, storage class, message channel.
        :rtype: str
        """
        return self._DeliverType

    @DeliverType.setter
    def DeliverType(self, DeliverType):
        self._DeliverType = DeliverType

    @property
    def DeliverSubType(self):
        r"""Specifies the delivery subtype: cls, ckafka.
        :rtype: str
        """
        return self._DeliverSubType

    @DeliverSubType.setter
    def DeliverSubType(self, DeliverSubType):
        self._DeliverSubType = DeliverSubType

    @property
    def DeliverConsumer(self):
        r"""Sender.
        :rtype: str
        """
        return self._DeliverConsumer

    @DeliverConsumer.setter
    def DeliverConsumer(self, DeliverConsumer):
        self._DeliverConsumer = DeliverConsumer

    @property
    def DeliverConsumerName(self):
        r"""Specifies the name of the sender.
        :rtype: str
        """
        return self._DeliverConsumerName

    @DeliverConsumerName.setter
    def DeliverConsumerName(self, DeliverConsumerName):
        self._DeliverConsumerName = DeliverConsumerName


    def _deserialize(self, params):
        self._DeliverType = params.get("DeliverType")
        self._DeliverSubType = params.get("DeliverSubType")
        self._DeliverConsumer = params.get("DeliverConsumer")
        self._DeliverConsumerName = params.get("DeliverConsumerName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccountPrivilegesRequest(AbstractModel):
    r"""DescribeAccountPrivileges request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _AccountName: Account name
        :type AccountName: str
        :param _Host: Host
        :type Host: str
        :param _Db: When the database name is “*”, the value specified in `Type` and `TableName` will be ignored, indicating that the user's global permissions are being modified.
        :type Db: str
        :param _Type: Object type in a specified database. Valid values: `table`, `*`.
        :type Type: str
        :param _TableName: The database name can be specified when `Type` is 'table'.
        :type TableName: str
        """
        self._ClusterId = None
        self._AccountName = None
        self._Host = None
        self._Db = None
        self._Type = None
        self._TableName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AccountName(self):
        r"""Account name
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def Host(self):
        r"""Host
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Db(self):
        r"""When the database name is “*”, the value specified in `Type` and `TableName` will be ignored, indicating that the user's global permissions are being modified.
        :rtype: str
        """
        return self._Db

    @Db.setter
    def Db(self, Db):
        self._Db = Db

    @property
    def Type(self):
        r"""Object type in a specified database. Valid values: `table`, `*`.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TableName(self):
        r"""The database name can be specified when `Type` is 'table'.
        :rtype: str
        """
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AccountName = params.get("AccountName")
        self._Host = params.get("Host")
        self._Db = params.get("Db")
        self._Type = params.get("Type")
        self._TableName = params.get("TableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccountPrivilegesResponse(AbstractModel):
    r"""DescribeAccountPrivileges response structure.

    """

    def __init__(self):
        r"""
        :param _Privileges: The list of permissions, such as  ["select","update","delete","create","drop","references","index","alter","show_db","create_tmp_table","lock_tables","execute","create_view","show_view","create_routine","alter_routine","event","trigger"]
        :type Privileges: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Privileges = None
        self._RequestId = None

    @property
    def Privileges(self):
        r"""The list of permissions, such as  ["select","update","delete","create","drop","references","index","alter","show_db","create_tmp_table","lock_tables","execute","create_view","show_view","create_routine","alter_routine","event","trigger"]
        :rtype: list of str
        """
        return self._Privileges

    @Privileges.setter
    def Privileges(self, Privileges):
        self._Privileges = Privileges

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Privileges = params.get("Privileges")
        self._RequestId = params.get("RequestId")


class DescribeAccountsRequest(AbstractModel):
    r"""DescribeAccounts request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _AccountNames: List of accounts to be filtered
        :type AccountNames: list of str
        :param _DbType: Database type. Valid values: 
<li> MYSQL </li>
This parameter has been disused.
        :type DbType: str
        :param _Hosts: List of accounts to be filtered
        :type Hosts: list of str
        :param _Limit: Maximum entries returned per page
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        :param _AccountRegular: Keywords for fuzzy search (match `AccountName` and `AccountHost` at the same time), which supports regex. The union results will be returned.
        :type AccountRegular: str
        """
        self._ClusterId = None
        self._AccountNames = None
        self._DbType = None
        self._Hosts = None
        self._Limit = None
        self._Offset = None
        self._AccountRegular = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AccountNames(self):
        r"""List of accounts to be filtered
        :rtype: list of str
        """
        return self._AccountNames

    @AccountNames.setter
    def AccountNames(self, AccountNames):
        self._AccountNames = AccountNames

    @property
    def DbType(self):
        r"""Database type. Valid values: 
<li> MYSQL </li>
This parameter has been disused.
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def Hosts(self):
        r"""List of accounts to be filtered
        :rtype: list of str
        """
        return self._Hosts

    @Hosts.setter
    def Hosts(self, Hosts):
        self._Hosts = Hosts

    @property
    def Limit(self):
        r"""Maximum entries returned per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def AccountRegular(self):
        r"""Keywords for fuzzy search (match `AccountName` and `AccountHost` at the same time), which supports regex. The union results will be returned.
        :rtype: str
        """
        return self._AccountRegular

    @AccountRegular.setter
    def AccountRegular(self, AccountRegular):
        self._AccountRegular = AccountRegular


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AccountNames = params.get("AccountNames")
        self._DbType = params.get("DbType")
        self._Hosts = params.get("Hosts")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._AccountRegular = params.get("AccountRegular")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccountsResponse(AbstractModel):
    r"""DescribeAccounts response structure.

    """

    def __init__(self):
        r"""
        :param _AccountSet: Database account list.
        :type AccountSet: list of Account
        :param _TotalCount: Total number of accounts
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AccountSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AccountSet(self):
        r"""Database account list.
        :rtype: list of Account
        """
        return self._AccountSet

    @AccountSet.setter
    def AccountSet(self, AccountSet):
        self._AccountSet = AccountSet

    @property
    def TotalCount(self):
        r"""Total number of accounts
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AccountSet") is not None:
            self._AccountSet = []
            for item in params.get("AccountSet"):
                obj = Account()
                obj._deserialize(item)
                self._AccountSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAuditInstanceListRequest(AbstractModel):
    r"""DescribeAuditInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _AuditSwitch: Enabling status of instance audit. 1 - enabled; 0 - not enabled.
        :type AuditSwitch: int
        :param _Filters: Filtering conditions for querying the instance list.
        :type Filters: list of AuditInstanceFilters
        :param _AuditMode: Instance audit rule mode. 1 - rule-based audit; 0 - full audit.
        :type AuditMode: int
        :param _Limit: Number of entries returned per request. The default value is 30, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. The default value is 0.
        :type Offset: int
        """
        self._AuditSwitch = None
        self._Filters = None
        self._AuditMode = None
        self._Limit = None
        self._Offset = None

    @property
    def AuditSwitch(self):
        r"""Enabling status of instance audit. 1 - enabled; 0 - not enabled.
        :rtype: int
        """
        return self._AuditSwitch

    @AuditSwitch.setter
    def AuditSwitch(self, AuditSwitch):
        self._AuditSwitch = AuditSwitch

    @property
    def Filters(self):
        r"""Filtering conditions for querying the instance list.
        :rtype: list of AuditInstanceFilters
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def AuditMode(self):
        r"""Instance audit rule mode. 1 - rule-based audit; 0 - full audit.
        :rtype: int
        """
        return self._AuditMode

    @AuditMode.setter
    def AuditMode(self, AuditMode):
        self._AuditMode = AuditMode

    @property
    def Limit(self):
        r"""Number of entries returned per request. The default value is 30, and the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset. The default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._AuditSwitch = params.get("AuditSwitch")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AuditInstanceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._AuditMode = params.get("AuditMode")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAuditInstanceListResponse(AbstractModel):
    r"""DescribeAuditInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of instances meeting the query conditions.
        :type TotalCount: int
        :param _Items: List of detailed information about the audit instance.
        :type Items: list of InstanceAuditStatus
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of instances meeting the query conditions.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""List of detailed information about the audit instance.
        :rtype: list of InstanceAuditStatus
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceAuditStatus()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAuditRuleTemplatesRequest(AbstractModel):
    r"""DescribeAuditRuleTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _RuleTemplateIds: Rule template ID
        :type RuleTemplateIds: list of str
        :param _RuleTemplateNames: Rule template name
        :type RuleTemplateNames: list of str
        :param _Limit: Number of results returned per request. Default value: `20`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self._RuleTemplateIds = None
        self._RuleTemplateNames = None
        self._Limit = None
        self._Offset = None

    @property
    def RuleTemplateIds(self):
        r"""Rule template ID
        :rtype: list of str
        """
        return self._RuleTemplateIds

    @RuleTemplateIds.setter
    def RuleTemplateIds(self, RuleTemplateIds):
        self._RuleTemplateIds = RuleTemplateIds

    @property
    def RuleTemplateNames(self):
        r"""Rule template name
        :rtype: list of str
        """
        return self._RuleTemplateNames

    @RuleTemplateNames.setter
    def RuleTemplateNames(self, RuleTemplateNames):
        self._RuleTemplateNames = RuleTemplateNames

    @property
    def Limit(self):
        r"""Number of results returned per request. Default value: `20`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._RuleTemplateIds = params.get("RuleTemplateIds")
        self._RuleTemplateNames = params.get("RuleTemplateNames")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAuditRuleTemplatesResponse(AbstractModel):
    r"""DescribeAuditRuleTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible instances
        :type TotalCount: int
        :param _Items: Rule template detail list.
        :type Items: list of AuditRuleTemplateInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of eligible instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""Rule template detail list.
        :rtype: list of AuditRuleTemplateInfo
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = AuditRuleTemplateInfo()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAuditRuleWithInstanceIdsRequest(AbstractModel):
    r"""DescribeAuditRuleWithInstanceIds request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceIds: Instance ID. Currently, only one single instance can be queried.
        :type InstanceIds: list of str
        """
        self._InstanceIds = None

    @property
    def InstanceIds(self):
        r"""Instance ID. Currently, only one single instance can be queried.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAuditRuleWithInstanceIdsResponse(AbstractModel):
    r"""DescribeAuditRuleWithInstanceIds response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: None
        :type TotalCount: int
        :param _Items: Audit rule information of the instance
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of InstanceAuditRule
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""None
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""Audit rule information of the instance
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of InstanceAuditRule
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceAuditRule()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBackupConfigRequest(AbstractModel):
    r"""DescribeBackupConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupConfigResponse(AbstractModel):
    r"""DescribeBackupConfig response structure.

    """

    def __init__(self):
        r"""
        :param _BackupTimeBeg: Full backup start time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively
        :type BackupTimeBeg: int
        :param _BackupTimeEnd: Full backup end time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively
        :type BackupTimeEnd: int
        :param _ReserveDuration: Backup retention period in seconds. Backups will be cleared after this period elapses. 7 days is represented by 3600*24*7 = 604800
        :type ReserveDuration: int
        :param _BackupFreq: Backup frequency. an array with a length of 7, indicating the backup methods corresponding to monday to sunday respectively. full represents full backup, and increment represents incremental backup.
        :type BackupFreq: list of str
        :param _BackupType: Backup method. specifies the method of backup. valid values: logic (indicates logical backup), snapshot (indicates snapshot backup).
        :type BackupType: str
        :param _LogicCrossRegionsConfigUpdateTime: Cross-Regional logical backup configuration modification time.
        :type LogicCrossRegionsConfigUpdateTime: str
        :param _LogicBackupConfig: Automatic logical backup configuration.
        :type LogicBackupConfig: :class:`tencentcloud.cynosdb.v20190107.models.LogicBackupConfigInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BackupTimeBeg = None
        self._BackupTimeEnd = None
        self._ReserveDuration = None
        self._BackupFreq = None
        self._BackupType = None
        self._LogicCrossRegionsConfigUpdateTime = None
        self._LogicBackupConfig = None
        self._RequestId = None

    @property
    def BackupTimeBeg(self):
        r"""Full backup start time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively
        :rtype: int
        """
        return self._BackupTimeBeg

    @BackupTimeBeg.setter
    def BackupTimeBeg(self, BackupTimeBeg):
        self._BackupTimeBeg = BackupTimeBeg

    @property
    def BackupTimeEnd(self):
        r"""Full backup end time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively
        :rtype: int
        """
        return self._BackupTimeEnd

    @BackupTimeEnd.setter
    def BackupTimeEnd(self, BackupTimeEnd):
        self._BackupTimeEnd = BackupTimeEnd

    @property
    def ReserveDuration(self):
        r"""Backup retention period in seconds. Backups will be cleared after this period elapses. 7 days is represented by 3600*24*7 = 604800
        :rtype: int
        """
        return self._ReserveDuration

    @ReserveDuration.setter
    def ReserveDuration(self, ReserveDuration):
        self._ReserveDuration = ReserveDuration

    @property
    def BackupFreq(self):
        r"""Backup frequency. an array with a length of 7, indicating the backup methods corresponding to monday to sunday respectively. full represents full backup, and increment represents incremental backup.
        :rtype: list of str
        """
        return self._BackupFreq

    @BackupFreq.setter
    def BackupFreq(self, BackupFreq):
        self._BackupFreq = BackupFreq

    @property
    def BackupType(self):
        r"""Backup method. specifies the method of backup. valid values: logic (indicates logical backup), snapshot (indicates snapshot backup).
        :rtype: str
        """
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def LogicCrossRegionsConfigUpdateTime(self):
        r"""Cross-Regional logical backup configuration modification time.
        :rtype: str
        """
        return self._LogicCrossRegionsConfigUpdateTime

    @LogicCrossRegionsConfigUpdateTime.setter
    def LogicCrossRegionsConfigUpdateTime(self, LogicCrossRegionsConfigUpdateTime):
        self._LogicCrossRegionsConfigUpdateTime = LogicCrossRegionsConfigUpdateTime

    @property
    def LogicBackupConfig(self):
        r"""Automatic logical backup configuration.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.LogicBackupConfigInfo`
        """
        return self._LogicBackupConfig

    @LogicBackupConfig.setter
    def LogicBackupConfig(self, LogicBackupConfig):
        self._LogicBackupConfig = LogicBackupConfig

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BackupTimeBeg = params.get("BackupTimeBeg")
        self._BackupTimeEnd = params.get("BackupTimeEnd")
        self._ReserveDuration = params.get("ReserveDuration")
        self._BackupFreq = params.get("BackupFreq")
        self._BackupType = params.get("BackupType")
        self._LogicCrossRegionsConfigUpdateTime = params.get("LogicCrossRegionsConfigUpdateTime")
        if params.get("LogicBackupConfig") is not None:
            self._LogicBackupConfig = LogicBackupConfigInfo()
            self._LogicBackupConfig._deserialize(params.get("LogicBackupConfig"))
        self._RequestId = params.get("RequestId")


class DescribeBackupDownloadRestrictionRequest(AbstractModel):
    r"""DescribeBackupDownloadRestriction request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIds: Cluster ID
        :type ClusterIds: list of str
        """
        self._ClusterIds = None

    @property
    def ClusterIds(self):
        r"""Cluster ID
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupDownloadRestrictionResponse(AbstractModel):
    r"""DescribeBackupDownloadRestriction response structure.

    """

    def __init__(self):
        r"""
        :param _BackupLimitClusterRestrictions: Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BackupLimitClusterRestrictions: list of BackupLimitClusterRestriction
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BackupLimitClusterRestrictions = None
        self._RequestId = None

    @property
    def BackupLimitClusterRestrictions(self):
        r"""Cluster backup download limit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of BackupLimitClusterRestriction
        """
        return self._BackupLimitClusterRestrictions

    @BackupLimitClusterRestrictions.setter
    def BackupLimitClusterRestrictions(self, BackupLimitClusterRestrictions):
        self._BackupLimitClusterRestrictions = BackupLimitClusterRestrictions

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BackupLimitClusterRestrictions") is not None:
            self._BackupLimitClusterRestrictions = []
            for item in params.get("BackupLimitClusterRestrictions"):
                obj = BackupLimitClusterRestriction()
                obj._deserialize(item)
                self._BackupLimitClusterRestrictions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBackupDownloadUrlRequest(AbstractModel):
    r"""DescribeBackupDownloadUrl request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BackupId: Backup ID
        :type BackupId: int
        :param _DownloadRestriction: Backup download source restriction condition.
        :type DownloadRestriction: :class:`tencentcloud.cynosdb.v20190107.models.BackupLimitRestriction`
        """
        self._ClusterId = None
        self._BackupId = None
        self._DownloadRestriction = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BackupId(self):
        r"""Backup ID
        :rtype: int
        """
        return self._BackupId

    @BackupId.setter
    def BackupId(self, BackupId):
        self._BackupId = BackupId

    @property
    def DownloadRestriction(self):
        r"""Backup download source restriction condition.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.BackupLimitRestriction`
        """
        return self._DownloadRestriction

    @DownloadRestriction.setter
    def DownloadRestriction(self, DownloadRestriction):
        self._DownloadRestriction = DownloadRestriction


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._BackupId = params.get("BackupId")
        if params.get("DownloadRestriction") is not None:
            self._DownloadRestriction = BackupLimitRestriction()
            self._DownloadRestriction._deserialize(params.get("DownloadRestriction"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupDownloadUrlResponse(AbstractModel):
    r"""DescribeBackupDownloadUrl response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Backup download address
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        r"""Backup download address
        :rtype: str
        """
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeBackupDownloadUserRestrictionRequest(AbstractModel):
    r"""DescribeBackupDownloadUserRestriction request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Pagination size
        :type Limit: int
        :param _Offset: Offset.
        :type Offset: int
        :param _OnlyUserRestriction: Specifies whether to query only user-level download limits. true - yes, false - no.
        :type OnlyUserRestriction: bool
        """
        self._Limit = None
        self._Offset = None
        self._OnlyUserRestriction = None

    @property
    def Limit(self):
        r"""Pagination size
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def OnlyUserRestriction(self):
        r"""Specifies whether to query only user-level download limits. true - yes, false - no.
        :rtype: bool
        """
        return self._OnlyUserRestriction

    @OnlyUserRestriction.setter
    def OnlyUserRestriction(self, OnlyUserRestriction):
        self._OnlyUserRestriction = OnlyUserRestriction


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._OnlyUserRestriction = params.get("OnlyUserRestriction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupDownloadUserRestrictionResponse(AbstractModel):
    r"""DescribeBackupDownloadUserRestriction response structure.

    """

    def __init__(self):
        r"""
        :param _BackupLimitClusterRestrictions: Cluster backup download limit information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BackupLimitClusterRestrictions: list of BackupLimitClusterRestriction
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BackupLimitClusterRestrictions = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def BackupLimitClusterRestrictions(self):
        r"""Cluster backup download limit information.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of BackupLimitClusterRestriction
        """
        return self._BackupLimitClusterRestrictions

    @BackupLimitClusterRestrictions.setter
    def BackupLimitClusterRestrictions(self, BackupLimitClusterRestrictions):
        self._BackupLimitClusterRestrictions = BackupLimitClusterRestrictions

    @property
    def TotalCount(self):
        r"""Total number of entries
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BackupLimitClusterRestrictions") is not None:
            self._BackupLimitClusterRestrictions = []
            for item in params.get("BackupLimitClusterRestrictions"):
                obj = BackupLimitClusterRestriction()
                obj._deserialize(item)
                self._BackupLimitClusterRestrictions.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBackupListRequest(AbstractModel):
    r"""DescribeBackupList request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Limit: The number of results to be returned. Value range: (0,100]
        :type Limit: int
        :param _Offset: Record offset. Value range: [0,INF)
        :type Offset: int
        :param _DbType: Database type. Valid values: 
<li> MYSQL </li>
        :type DbType: str
        :param _BackupIds: Backup ID
        :type BackupIds: list of int
        :param _BackupType: Backup type. Valid values: `snapshot` (snapshot backup), `logic` (logic backup).
        :type BackupType: str
        :param _BackupMethod: Back mode. Valid values: `auto` (automatic backup), `manual` (manual backup)
        :type BackupMethod: str
        :param _SnapShotType: 
        :type SnapShotType: str
        :param _StartTime: Backup start time
        :type StartTime: str
        :param _EndTime: Backup end time
        :type EndTime: str
        :param _FileNames: 
        :type FileNames: list of str
        :param _BackupNames: Backup alias, which supports fuzzy query.
        :type BackupNames: list of str
        :param _SnapshotIdList: ID list of the snapshot backup
        :type SnapshotIdList: list of int
        """
        self._ClusterId = None
        self._Limit = None
        self._Offset = None
        self._DbType = None
        self._BackupIds = None
        self._BackupType = None
        self._BackupMethod = None
        self._SnapShotType = None
        self._StartTime = None
        self._EndTime = None
        self._FileNames = None
        self._BackupNames = None
        self._SnapshotIdList = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        r"""The number of results to be returned. Value range: (0,100]
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Record offset. Value range: [0,INF)
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def DbType(self):
        r"""Database type. Valid values: 
<li> MYSQL </li>
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def BackupIds(self):
        r"""Backup ID
        :rtype: list of int
        """
        return self._BackupIds

    @BackupIds.setter
    def BackupIds(self, BackupIds):
        self._BackupIds = BackupIds

    @property
    def BackupType(self):
        r"""Backup type. Valid values: `snapshot` (snapshot backup), `logic` (logic backup).
        :rtype: str
        """
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def BackupMethod(self):
        r"""Back mode. Valid values: `auto` (automatic backup), `manual` (manual backup)
        :rtype: str
        """
        return self._BackupMethod

    @BackupMethod.setter
    def BackupMethod(self, BackupMethod):
        self._BackupMethod = BackupMethod

    @property
    def SnapShotType(self):
        r"""
        :rtype: str
        """
        return self._SnapShotType

    @SnapShotType.setter
    def SnapShotType(self, SnapShotType):
        self._SnapShotType = SnapShotType

    @property
    def StartTime(self):
        r"""Backup start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Backup end time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def FileNames(self):
        r"""
        :rtype: list of str
        """
        return self._FileNames

    @FileNames.setter
    def FileNames(self, FileNames):
        self._FileNames = FileNames

    @property
    def BackupNames(self):
        r"""Backup alias, which supports fuzzy query.
        :rtype: list of str
        """
        return self._BackupNames

    @BackupNames.setter
    def BackupNames(self, BackupNames):
        self._BackupNames = BackupNames

    @property
    def SnapshotIdList(self):
        r"""ID list of the snapshot backup
        :rtype: list of int
        """
        return self._SnapshotIdList

    @SnapshotIdList.setter
    def SnapshotIdList(self, SnapshotIdList):
        self._SnapshotIdList = SnapshotIdList


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._DbType = params.get("DbType")
        self._BackupIds = params.get("BackupIds")
        self._BackupType = params.get("BackupType")
        self._BackupMethod = params.get("BackupMethod")
        self._SnapShotType = params.get("SnapShotType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._FileNames = params.get("FileNames")
        self._BackupNames = params.get("BackupNames")
        self._SnapshotIdList = params.get("SnapshotIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupListResponse(AbstractModel):
    r"""DescribeBackupList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of backup files
        :type TotalCount: int
        :param _BackupList: Backup file list
        :type BackupList: list of BackupFileInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._BackupList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of backup files
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BackupList(self):
        r"""Backup file list
        :rtype: list of BackupFileInfo
        """
        return self._BackupList

    @BackupList.setter
    def BackupList(self, BackupList):
        self._BackupList = BackupList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BackupList") is not None:
            self._BackupList = []
            for item in params.get("BackupList"):
                obj = BackupFileInfo()
                obj._deserialize(item)
                self._BackupList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBinlogConfigRequest(AbstractModel):
    r"""DescribeBinlogConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBinlogConfigResponse(AbstractModel):
    r"""DescribeBinlogConfig response structure.

    """

    def __init__(self):
        r"""
        :param _BinlogCrossRegionsConfigUpdateTime: Configuration update time for cross-regional Binlog.
        :type BinlogCrossRegionsConfigUpdateTime: str
        :param _BinlogConfig: Specifies the Binlog configuration message.
        :type BinlogConfig: :class:`tencentcloud.cynosdb.v20190107.models.BinlogConfigInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BinlogCrossRegionsConfigUpdateTime = None
        self._BinlogConfig = None
        self._RequestId = None

    @property
    def BinlogCrossRegionsConfigUpdateTime(self):
        r"""Configuration update time for cross-regional Binlog.
        :rtype: str
        """
        return self._BinlogCrossRegionsConfigUpdateTime

    @BinlogCrossRegionsConfigUpdateTime.setter
    def BinlogCrossRegionsConfigUpdateTime(self, BinlogCrossRegionsConfigUpdateTime):
        self._BinlogCrossRegionsConfigUpdateTime = BinlogCrossRegionsConfigUpdateTime

    @property
    def BinlogConfig(self):
        r"""Specifies the Binlog configuration message.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.BinlogConfigInfo`
        """
        return self._BinlogConfig

    @BinlogConfig.setter
    def BinlogConfig(self, BinlogConfig):
        self._BinlogConfig = BinlogConfig

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BinlogCrossRegionsConfigUpdateTime = params.get("BinlogCrossRegionsConfigUpdateTime")
        if params.get("BinlogConfig") is not None:
            self._BinlogConfig = BinlogConfigInfo()
            self._BinlogConfig._deserialize(params.get("BinlogConfig"))
        self._RequestId = params.get("RequestId")


class DescribeBinlogDownloadUrlRequest(AbstractModel):
    r"""DescribeBinlogDownloadUrl request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BinlogId: Binlog file ID
        :type BinlogId: int
        :param _DownloadRestriction: Backup download source restriction condition.
        :type DownloadRestriction: :class:`tencentcloud.cynosdb.v20190107.models.BackupLimitRestriction`
        """
        self._ClusterId = None
        self._BinlogId = None
        self._DownloadRestriction = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BinlogId(self):
        r"""Binlog file ID
        :rtype: int
        """
        return self._BinlogId

    @BinlogId.setter
    def BinlogId(self, BinlogId):
        self._BinlogId = BinlogId

    @property
    def DownloadRestriction(self):
        r"""Backup download source restriction condition.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.BackupLimitRestriction`
        """
        return self._DownloadRestriction

    @DownloadRestriction.setter
    def DownloadRestriction(self, DownloadRestriction):
        self._DownloadRestriction = DownloadRestriction


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._BinlogId = params.get("BinlogId")
        if params.get("DownloadRestriction") is not None:
            self._DownloadRestriction = BackupLimitRestriction()
            self._DownloadRestriction._deserialize(params.get("DownloadRestriction"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBinlogDownloadUrlResponse(AbstractModel):
    r"""DescribeBinlogDownloadUrl response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Download address
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        r"""Download address
        :rtype: str
        """
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeBinlogSaveDaysRequest(AbstractModel):
    r"""DescribeBinlogSaveDays request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBinlogSaveDaysResponse(AbstractModel):
    r"""DescribeBinlogSaveDays response structure.

    """

    def __init__(self):
        r"""
        :param _BinlogSaveDays: Binlog retention period in days
        :type BinlogSaveDays: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BinlogSaveDays = None
        self._RequestId = None

    @property
    def BinlogSaveDays(self):
        r"""Binlog retention period in days
        :rtype: int
        """
        return self._BinlogSaveDays

    @BinlogSaveDays.setter
    def BinlogSaveDays(self, BinlogSaveDays):
        self._BinlogSaveDays = BinlogSaveDays

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BinlogSaveDays = params.get("BinlogSaveDays")
        self._RequestId = params.get("RequestId")


class DescribeBinlogsRequest(AbstractModel):
    r"""DescribeBinlogs request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number
        :type Limit: int
        """
        self._ClusterId = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def StartTime(self):
        r"""Start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Maximum number
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBinlogsResponse(AbstractModel):
    r"""DescribeBinlogs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records
        :type TotalCount: int
        :param _Binlogs: Binlog list.
        :type Binlogs: list of BinlogItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Binlogs = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of records
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Binlogs(self):
        r"""Binlog list.
        :rtype: list of BinlogItem
        """
        return self._Binlogs

    @Binlogs.setter
    def Binlogs(self, Binlogs):
        self._Binlogs = Binlogs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Binlogs") is not None:
            self._Binlogs = []
            for item in params.get("Binlogs"):
                obj = BinlogItem()
                obj._deserialize(item)
                self._Binlogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeChangedParamsAfterUpgradeRequest(AbstractModel):
    r"""DescribeChangedParamsAfterUpgrade request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Cluster ID.
        :type InstanceId: str
        :param _DstCpu: CPU after specification adjustment.
        :type DstCpu: int
        :param _DstMem: Memory after specification adjustment, in GB.
        :type DstMem: int
        """
        self._InstanceId = None
        self._DstCpu = None
        self._DstMem = None

    @property
    def InstanceId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DstCpu(self):
        r"""CPU after specification adjustment.
        :rtype: int
        """
        return self._DstCpu

    @DstCpu.setter
    def DstCpu(self, DstCpu):
        self._DstCpu = DstCpu

    @property
    def DstMem(self):
        r"""Memory after specification adjustment, in GB.
        :rtype: int
        """
        return self._DstMem

    @DstMem.setter
    def DstMem(self, DstMem):
        self._DstMem = DstMem


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DstCpu = params.get("DstCpu")
        self._DstMem = params.get("DstMem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeChangedParamsAfterUpgradeResponse(AbstractModel):
    r"""DescribeChangedParamsAfterUpgrade response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of parameters.
        :type TotalCount: int
        :param _Items: Instance parameter list.
        :type Items: list of ParamItemInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of parameters.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""Instance parameter list.
        :rtype: list of ParamItemInfo
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ParamItemInfo()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterDatabaseTablesRequest(AbstractModel):
    r"""DescribeClusterDatabaseTables request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Db: Database name
        :type Db: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Number
        :type Limit: int
        :param _TableType: Specifies the table type.
Specifies that "view" only returns the view, "base_table" only returns the basic table, and "all" returns both the view and the table. the default value is all.
        :type TableType: str
        """
        self._ClusterId = None
        self._Db = None
        self._Offset = None
        self._Limit = None
        self._TableType = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Db(self):
        r"""Database name
        :rtype: str
        """
        return self._Db

    @Db.setter
    def Db(self, Db):
        self._Db = Db

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TableType(self):
        r"""Specifies the table type.
Specifies that "view" only returns the view, "base_table" only returns the basic table, and "all" returns both the view and the table. the default value is all.
        :rtype: str
        """
        return self._TableType

    @TableType.setter
    def TableType(self, TableType):
        self._TableType = TableType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Db = params.get("Db")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TableType = params.get("TableType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDatabaseTablesResponse(AbstractModel):
    r"""DescribeClusterDatabaseTables response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _Offset: Pagination Offset
        :type Offset: int
        :param _Limit: Pagination limit.
        :type Limit: int
        :param _Tables: Database table list.
        :type Tables: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Offset = None
        self._Limit = None
        self._Tables = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of entries
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Offset(self):
        r"""Pagination Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination limit.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Tables(self):
        r"""Database table list.
        :rtype: list of str
        """
        return self._Tables

    @Tables.setter
    def Tables(self, Tables):
        self._Tables = Tables

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Tables = params.get("Tables")
        self._RequestId = params.get("RequestId")


class DescribeClusterDatabasesRequest(AbstractModel):
    r"""DescribeClusterDatabases request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _Offset: Pagination offset.
        :type Offset: int
        :param _Limit: Pagination number limit.
        :type Limit: int
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        r"""Pagination offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Pagination number limit.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDatabasesResponse(AbstractModel):
    r"""DescribeClusterDatabases response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries.
        :type TotalCount: int
        :param _Offset: Pagination offset.
        :type Offset: int
        :param _Databases: Database list.
        :type Databases: list of str
        :param _Limit: Pagination number limit.
        :type Limit: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Offset = None
        self._Databases = None
        self._Limit = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of entries.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Offset(self):
        r"""Pagination offset.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Databases(self):
        r"""Database list.
        :rtype: list of str
        """
        return self._Databases

    @Databases.setter
    def Databases(self, Databases):
        self._Databases = Databases

    @property
    def Limit(self):
        r"""Pagination number limit.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._Offset = params.get("Offset")
        self._Databases = params.get("Databases")
        self._Limit = params.get("Limit")
        self._RequestId = params.get("RequestId")


class DescribeClusterDetailDatabasesRequest(AbstractModel):
    r"""DescribeClusterDetailDatabases request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of returned results. Default value: `20`. Maximum value: `100`.
        :type Limit: int
        :param _DbName: Database name
        :type DbName: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._DbName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        r"""Offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Number of returned results. Default value: `20`. Maximum value: `100`.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._DbName = params.get("DbName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDetailDatabasesResponse(AbstractModel):
    r"""DescribeClusterDetailDatabases response structure.

    """

    def __init__(self):
        r"""
        :param _DbInfos: Database information
        :type DbInfos: list of DbInfo
        :param _TotalCount: The total count
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DbInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DbInfos(self):
        r"""Database information
        :rtype: list of DbInfo
        """
        return self._DbInfos

    @DbInfos.setter
    def DbInfos(self, DbInfos):
        self._DbInfos = DbInfos

    @property
    def TotalCount(self):
        r"""The total count
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DbInfos") is not None:
            self._DbInfos = []
            for item in params.get("DbInfos"):
                obj = DbInfo()
                obj._deserialize(item)
                self._DbInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeClusterDetailRequest(AbstractModel):
    r"""DescribeClusterDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDetailResponse(AbstractModel):
    r"""DescribeClusterDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Detail: Cluster details
        :type Detail: :class:`tencentcloud.cynosdb.v20190107.models.CynosdbClusterDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Detail = None
        self._RequestId = None

    @property
    def Detail(self):
        r"""Cluster details
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.CynosdbClusterDetail`
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Detail") is not None:
            self._Detail = CynosdbClusterDetail()
            self._Detail._deserialize(params.get("Detail"))
        self._RequestId = params.get("RequestId")


class DescribeClusterInstanceGrpsRequest(AbstractModel):
    r"""DescribeClusterInstanceGrps request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterInstanceGrpsResponse(AbstractModel):
    r"""DescribeClusterInstanceGrps response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of instance groups
        :type TotalCount: int
        :param _InstanceGrpInfoList: Instance group list
        :type InstanceGrpInfoList: list of CynosdbInstanceGrp
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceGrpInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of instance groups
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceGrpInfoList(self):
        warnings.warn("parameter `InstanceGrpInfoList` is deprecated", DeprecationWarning) 

        r"""Instance group list
        :rtype: list of CynosdbInstanceGrp
        """
        return self._InstanceGrpInfoList

    @InstanceGrpInfoList.setter
    def InstanceGrpInfoList(self, InstanceGrpInfoList):
        warnings.warn("parameter `InstanceGrpInfoList` is deprecated", DeprecationWarning) 

        self._InstanceGrpInfoList = InstanceGrpInfoList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceGrpInfoList") is not None:
            self._InstanceGrpInfoList = []
            for item in params.get("InstanceGrpInfoList"):
                obj = CynosdbInstanceGrp()
                obj._deserialize(item)
                self._InstanceGrpInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterParamsRequest(AbstractModel):
    r"""DescribeClusterParams request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ParamName: Parameter name
        :type ParamName: str
        """
        self._ClusterId = None
        self._ParamName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ParamName(self):
        r"""Parameter name
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ParamName = params.get("ParamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterParamsResponse(AbstractModel):
    r"""DescribeClusterParams response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of parameters
        :type TotalCount: int
        :param _Items: Instance parameter list.
        :type Items: list of ParamInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of parameters
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""Instance parameter list.
        :rtype: list of ParamInfo
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ParamInfo()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterPasswordComplexityRequest(AbstractModel):
    r"""DescribeClusterPasswordComplexity request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterPasswordComplexityResponse(AbstractModel):
    r"""DescribeClusterPasswordComplexity response structure.

    """

    def __init__(self):
        r"""
        :param _ValidatePasswordDictionary: Data dictionary parameter.
        :type ValidatePasswordDictionary: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        :param _ValidatePasswordLength: Specifies the password length.
        :type ValidatePasswordLength: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        :param _ValidatePasswordMixedCaseCount: Case-Sensitive character count.
        :type ValidatePasswordMixedCaseCount: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        :param _ValidatePasswordNumberCount: Number of digits.
        :type ValidatePasswordNumberCount: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        :param _ValidatePasswordPolicy: Password level.
        :type ValidatePasswordPolicy: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        :param _ValidatePasswordSpecialCharCount: Number of special characters.
        :type ValidatePasswordSpecialCharCount: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ValidatePasswordDictionary = None
        self._ValidatePasswordLength = None
        self._ValidatePasswordMixedCaseCount = None
        self._ValidatePasswordNumberCount = None
        self._ValidatePasswordPolicy = None
        self._ValidatePasswordSpecialCharCount = None
        self._RequestId = None

    @property
    def ValidatePasswordDictionary(self):
        r"""Data dictionary parameter.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        """
        return self._ValidatePasswordDictionary

    @ValidatePasswordDictionary.setter
    def ValidatePasswordDictionary(self, ValidatePasswordDictionary):
        self._ValidatePasswordDictionary = ValidatePasswordDictionary

    @property
    def ValidatePasswordLength(self):
        r"""Specifies the password length.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        """
        return self._ValidatePasswordLength

    @ValidatePasswordLength.setter
    def ValidatePasswordLength(self, ValidatePasswordLength):
        self._ValidatePasswordLength = ValidatePasswordLength

    @property
    def ValidatePasswordMixedCaseCount(self):
        r"""Case-Sensitive character count.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        """
        return self._ValidatePasswordMixedCaseCount

    @ValidatePasswordMixedCaseCount.setter
    def ValidatePasswordMixedCaseCount(self, ValidatePasswordMixedCaseCount):
        self._ValidatePasswordMixedCaseCount = ValidatePasswordMixedCaseCount

    @property
    def ValidatePasswordNumberCount(self):
        r"""Number of digits.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        """
        return self._ValidatePasswordNumberCount

    @ValidatePasswordNumberCount.setter
    def ValidatePasswordNumberCount(self, ValidatePasswordNumberCount):
        self._ValidatePasswordNumberCount = ValidatePasswordNumberCount

    @property
    def ValidatePasswordPolicy(self):
        r"""Password level.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        """
        return self._ValidatePasswordPolicy

    @ValidatePasswordPolicy.setter
    def ValidatePasswordPolicy(self, ValidatePasswordPolicy):
        self._ValidatePasswordPolicy = ValidatePasswordPolicy

    @property
    def ValidatePasswordSpecialCharCount(self):
        r"""Number of special characters.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ParamInfo`
        """
        return self._ValidatePasswordSpecialCharCount

    @ValidatePasswordSpecialCharCount.setter
    def ValidatePasswordSpecialCharCount(self, ValidatePasswordSpecialCharCount):
        self._ValidatePasswordSpecialCharCount = ValidatePasswordSpecialCharCount

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ValidatePasswordDictionary") is not None:
            self._ValidatePasswordDictionary = ParamInfo()
            self._ValidatePasswordDictionary._deserialize(params.get("ValidatePasswordDictionary"))
        if params.get("ValidatePasswordLength") is not None:
            self._ValidatePasswordLength = ParamInfo()
            self._ValidatePasswordLength._deserialize(params.get("ValidatePasswordLength"))
        if params.get("ValidatePasswordMixedCaseCount") is not None:
            self._ValidatePasswordMixedCaseCount = ParamInfo()
            self._ValidatePasswordMixedCaseCount._deserialize(params.get("ValidatePasswordMixedCaseCount"))
        if params.get("ValidatePasswordNumberCount") is not None:
            self._ValidatePasswordNumberCount = ParamInfo()
            self._ValidatePasswordNumberCount._deserialize(params.get("ValidatePasswordNumberCount"))
        if params.get("ValidatePasswordPolicy") is not None:
            self._ValidatePasswordPolicy = ParamInfo()
            self._ValidatePasswordPolicy._deserialize(params.get("ValidatePasswordPolicy"))
        if params.get("ValidatePasswordSpecialCharCount") is not None:
            self._ValidatePasswordSpecialCharCount = ParamInfo()
            self._ValidatePasswordSpecialCharCount._deserialize(params.get("ValidatePasswordSpecialCharCount"))
        self._RequestId = params.get("RequestId")


class DescribeClusterReadOnlyRequest(AbstractModel):
    r"""DescribeClusterReadOnly request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIds: List of cluster IDs
        :type ClusterIds: list of str
        """
        self._ClusterIds = None

    @property
    def ClusterIds(self):
        r"""List of cluster IDs
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterReadOnlyResponse(AbstractModel):
    r"""DescribeClusterReadOnly response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterReadOnlyValues: List of cluster read-only switches.
        :type ClusterReadOnlyValues: list of ClusterReadOnlyValue
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterReadOnlyValues = None
        self._RequestId = None

    @property
    def ClusterReadOnlyValues(self):
        r"""List of cluster read-only switches.
        :rtype: list of ClusterReadOnlyValue
        """
        return self._ClusterReadOnlyValues

    @ClusterReadOnlyValues.setter
    def ClusterReadOnlyValues(self, ClusterReadOnlyValues):
        self._ClusterReadOnlyValues = ClusterReadOnlyValues

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterReadOnlyValues") is not None:
            self._ClusterReadOnlyValues = []
            for item in params.get("ClusterReadOnlyValues"):
                obj = ClusterReadOnlyValue()
                obj._deserialize(item)
                self._ClusterReadOnlyValues.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterTransparentEncryptInfoRequest(AbstractModel):
    r"""DescribeClusterTransparentEncryptInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterTransparentEncryptInfoResponse(AbstractModel):
    r"""DescribeClusterTransparentEncryptInfo response structure.

    """

    def __init__(self):
        r"""
        :param _KeyId: Encryption key id.
        :type KeyId: str
        :param _KeyRegion: Encryption key region.

        :type KeyRegion: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._KeyId = None
        self._KeyRegion = None
        self._RequestId = None

    @property
    def KeyId(self):
        r"""Encryption key id.
        :rtype: str
        """
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def KeyRegion(self):
        r"""Encryption key region.

        :rtype: str
        """
        return self._KeyRegion

    @KeyRegion.setter
    def KeyRegion(self, KeyRegion):
        self._KeyRegion = KeyRegion

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._KeyId = params.get("KeyId")
        self._KeyRegion = params.get("KeyRegion")
        self._RequestId = params.get("RequestId")


class DescribeClustersRequest(AbstractModel):
    r"""DescribeClusters request structure.

    """

    def __init__(self):
        r"""
        :param _DbType: Engine type. Currently, `MYSQL` is supported.
        :type DbType: str
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100
        :type Limit: int
        :param _Offset: Record offset. Default value: 0
        :type Offset: int
        :param _OrderBy: Sort by field. Valid values:
<li> CREATETIME: creation time</li>
<li> PERIODENDTIME: expiration time</li>
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values:
<li> ASC: ascending</li>
<li> DESC: descending</li>
        :type OrderByType: str
        :param _Filters: Filter. If more than one filter exists, the logical relationship between these filters is `AND`.
        :type Filters: list of QueryFilter
        """
        self._DbType = None
        self._Limit = None
        self._Offset = None
        self._OrderBy = None
        self._OrderByType = None
        self._Filters = None

    @property
    def DbType(self):
        r"""Engine type. Currently, `MYSQL` is supported.
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Record offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def OrderBy(self):
        r"""Sort by field. Valid values:
<li> CREATETIME: creation time</li>
<li> PERIODENDTIME: expiration time</li>
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values:
<li> ASC: ascending</li>
<li> DESC: descending</li>
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def Filters(self):
        r"""Filter. If more than one filter exists, the logical relationship between these filters is `AND`.
        :rtype: list of QueryFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._DbType = params.get("DbType")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClustersResponse(AbstractModel):
    r"""DescribeClusters response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of clusters
        :type TotalCount: int
        :param _ClusterSet: Cluster list
        :type ClusterSet: list of CynosdbCluster
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of clusters
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterSet(self):
        r"""Cluster list
        :rtype: list of CynosdbCluster
        """
        return self._ClusterSet

    @ClusterSet.setter
    def ClusterSet(self, ClusterSet):
        self._ClusterSet = ClusterSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterSet") is not None:
            self._ClusterSet = []
            for item in params.get("ClusterSet"):
                obj = CynosdbCluster()
                obj._deserialize(item)
                self._ClusterSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDBSecurityGroupsRequest(AbstractModel):
    r"""DescribeDBSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Specifies that the instance ID must be provided by selecting either InstanceId or InstanceGroupId.
        :type InstanceId: str
        :param _InstanceGroupId: Specifies that the instance group ID must be provided by selecting either InstanceId or InstanceGroupId.
        :type InstanceGroupId: str
        """
        self._InstanceId = None
        self._InstanceGroupId = None

    @property
    def InstanceId(self):
        warnings.warn("parameter `InstanceId` is deprecated", DeprecationWarning) 

        r"""Specifies that the instance ID must be provided by selecting either InstanceId or InstanceGroupId.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        warnings.warn("parameter `InstanceId` is deprecated", DeprecationWarning) 

        self._InstanceId = InstanceId

    @property
    def InstanceGroupId(self):
        r"""Specifies that the instance group ID must be provided by selecting either InstanceId or InstanceGroupId.
        :rtype: str
        """
        return self._InstanceGroupId

    @InstanceGroupId.setter
    def InstanceGroupId(self, InstanceGroupId):
        self._InstanceGroupId = InstanceGroupId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceGroupId = params.get("InstanceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDBSecurityGroupsResponse(AbstractModel):
    r"""DescribeDBSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _Groups: Security group information
        :type Groups: list of SecurityGroup
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Groups = None
        self._RequestId = None

    @property
    def Groups(self):
        r"""Security group information
        :rtype: list of SecurityGroup
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = SecurityGroup()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowRequest(AbstractModel):
    r"""DescribeFlow request structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        """
        self._FlowId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowResponse(AbstractModel):
    r"""DescribeFlow response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Task flow status. Valid values: `0` (succeeded), `1` (failed), `2` (Processing).
        :type Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        r"""Task flow status. Valid values: `0` (succeeded), `1` (failed), `2` (Processing).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeInstanceCLSLogDeliveryRequest(AbstractModel):
    r"""DescribeInstanceCLSLogDelivery request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _LogType: Log type.
        :type LogType: str
        """
        self._InstanceId = None
        self._LogType = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def LogType(self):
        r"""Log type.
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceCLSLogDeliveryResponse(AbstractModel):
    r"""DescribeInstanceCLSLogDelivery response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number.
        :type TotalCount: int
        :param _InstanceCLSDeliveryInfos: Instance shipping information.
        :type InstanceCLSDeliveryInfos: list of InstanceCLSDeliveryInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceCLSDeliveryInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceCLSDeliveryInfos(self):
        r"""Instance shipping information.
        :rtype: list of InstanceCLSDeliveryInfo
        """
        return self._InstanceCLSDeliveryInfos

    @InstanceCLSDeliveryInfos.setter
    def InstanceCLSDeliveryInfos(self, InstanceCLSDeliveryInfos):
        self._InstanceCLSDeliveryInfos = InstanceCLSDeliveryInfos

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceCLSDeliveryInfos") is not None:
            self._InstanceCLSDeliveryInfos = []
            for item in params.get("InstanceCLSDeliveryInfos"):
                obj = InstanceCLSDeliveryInfo()
                obj._deserialize(item)
                self._InstanceCLSDeliveryInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceDetailRequest(AbstractModel):
    r"""DescribeInstanceDetail request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceDetailResponse(AbstractModel):
    r"""DescribeInstanceDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Detail: Instance details
        :type Detail: :class:`tencentcloud.cynosdb.v20190107.models.CynosdbInstanceDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Detail = None
        self._RequestId = None

    @property
    def Detail(self):
        r"""Instance details
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.CynosdbInstanceDetail`
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Detail") is not None:
            self._Detail = CynosdbInstanceDetail()
            self._Detail._deserialize(params.get("Detail"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceErrorLogsRequest(AbstractModel):
    r"""DescribeInstanceErrorLogs request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Limit: Limit on the number of logs
        :type Limit: int
        :param _Offset: Offset of the log number
        :type Offset: int
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _OrderBy: Sorting field. Valid value: 'Timestamp'.
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values: `ASC`, `DESC`.
        :type OrderByType: str
        :param _LogLevels: Log level, which supports combo search by multiple levels. Valid values: `error`, `warning`, `note`.
        :type LogLevels: list of str
        :param _KeyWords: 
        :type KeyWords: list of str
        """
        self._InstanceId = None
        self._Limit = None
        self._Offset = None
        self._StartTime = None
        self._EndTime = None
        self._OrderBy = None
        self._OrderByType = None
        self._LogLevels = None
        self._KeyWords = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Limit(self):
        r"""Limit on the number of logs
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset of the log number
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def StartTime(self):
        r"""Start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def OrderBy(self):
        r"""Sorting field. Valid value: 'Timestamp'.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values: `ASC`, `DESC`.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def LogLevels(self):
        r"""Log level, which supports combo search by multiple levels. Valid values: `error`, `warning`, `note`.
        :rtype: list of str
        """
        return self._LogLevels

    @LogLevels.setter
    def LogLevels(self, LogLevels):
        self._LogLevels = LogLevels

    @property
    def KeyWords(self):
        r"""
        :rtype: list of str
        """
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        self._LogLevels = params.get("LogLevels")
        self._KeyWords = params.get("KeyWords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceErrorLogsResponse(AbstractModel):
    r"""DescribeInstanceErrorLogs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of logs.
        :type TotalCount: int
        :param _ErrorLogs: Error log list.
        :type ErrorLogs: list of CynosdbErrorLogItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ErrorLogs = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of logs.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ErrorLogs(self):
        r"""Error log list.
        :rtype: list of CynosdbErrorLogItem
        """
        return self._ErrorLogs

    @ErrorLogs.setter
    def ErrorLogs(self, ErrorLogs):
        self._ErrorLogs = ErrorLogs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ErrorLogs") is not None:
            self._ErrorLogs = []
            for item in params.get("ErrorLogs"):
                obj = CynosdbErrorLogItem()
                obj._deserialize(item)
                self._ErrorLogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceParamsRequest(AbstractModel):
    r"""DescribeInstanceParams request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIds: Instance ID, which supports batch query.
        :type InstanceIds: list of str
        :param _ParamKeyword: Search condition for a parameter name, which supports fuzzy search.
        :type ParamKeyword: str
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._ParamKeyword = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""Instance ID, which supports batch query.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def ParamKeyword(self):
        r"""Search condition for a parameter name, which supports fuzzy search.
        :rtype: str
        """
        return self._ParamKeyword

    @ParamKeyword.setter
    def ParamKeyword(self, ParamKeyword):
        self._ParamKeyword = ParamKeyword


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        self._ParamKeyword = params.get("ParamKeyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceParamsResponse(AbstractModel):
    r"""DescribeInstanceParams response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List of instance parameters
        :type Items: list of InstanceParamItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._RequestId = None

    @property
    def Items(self):
        r"""List of instance parameters
        :rtype: list of InstanceParamItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceParamItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceSlowQueriesRequest(AbstractModel):
    r"""DescribeInstanceSlowQueries request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _StartTime: Transaction start time
        :type StartTime: str
        :param _EndTime: Transaction end time
        :type EndTime: str
        :param _Limit: Maximum number
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        :param _Username: Username
        :type Username: str
        :param _Host: Client host
        :type Host: str
        :param _Database: Database name
        :type Database: str
        :param _OrderBy: Sorting field. Valid values: QueryTime, LockTime, RowsExamined, RowsSent.
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values: asc, desc.
        :type OrderByType: str
        :param _SqlText: sql statement.
        :type SqlText: str
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._Username = None
        self._Host = None
        self._Database = None
        self._OrderBy = None
        self._OrderByType = None
        self._SqlText = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Transaction start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Transaction end time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""Maximum number
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Username(self):
        r"""Username
        :rtype: str
        """
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Host(self):
        r"""Client host
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Database(self):
        r"""Database name
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def OrderBy(self):
        r"""Sorting field. Valid values: QueryTime, LockTime, RowsExamined, RowsSent.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values: asc, desc.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def SqlText(self):
        r"""sql statement.
        :rtype: str
        """
        return self._SqlText

    @SqlText.setter
    def SqlText(self, SqlText):
        self._SqlText = SqlText


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Username = params.get("Username")
        self._Host = params.get("Host")
        self._Database = params.get("Database")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        self._SqlText = params.get("SqlText")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceSlowQueriesResponse(AbstractModel):
    r"""DescribeInstanceSlowQueries response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _SlowQueries: Slow query record
        :type SlowQueries: list of SlowQueriesItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SlowQueries = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SlowQueries(self):
        r"""Slow query record
        :rtype: list of SlowQueriesItem
        """
        return self._SlowQueries

    @SlowQueries.setter
    def SlowQueries(self, SlowQueries):
        self._SlowQueries = SlowQueries

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SlowQueries") is not None:
            self._SlowQueries = []
            for item in params.get("SlowQueries"):
                obj = SlowQueriesItem()
                obj._deserialize(item)
                self._SlowQueries.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceSpecsRequest(AbstractModel):
    r"""DescribeInstanceSpecs request structure.

    """

    def __init__(self):
        r"""
        :param _DbType: Database type. Valid values: 
<li> MYSQL </li>
        :type DbType: str
        :param _IncludeZoneStocks: Whether to return the AZ information.
        :type IncludeZoneStocks: bool
        """
        self._DbType = None
        self._IncludeZoneStocks = None

    @property
    def DbType(self):
        r"""Database type. Valid values: 
<li> MYSQL </li>
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def IncludeZoneStocks(self):
        r"""Whether to return the AZ information.
        :rtype: bool
        """
        return self._IncludeZoneStocks

    @IncludeZoneStocks.setter
    def IncludeZoneStocks(self, IncludeZoneStocks):
        self._IncludeZoneStocks = IncludeZoneStocks


    def _deserialize(self, params):
        self._DbType = params.get("DbType")
        self._IncludeZoneStocks = params.get("IncludeZoneStocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceSpecsResponse(AbstractModel):
    r"""DescribeInstanceSpecs response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceSpecSet: Specification information
        :type InstanceSpecSet: list of InstanceSpec
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceSpecSet = None
        self._RequestId = None

    @property
    def InstanceSpecSet(self):
        r"""Specification information
        :rtype: list of InstanceSpec
        """
        return self._InstanceSpecSet

    @InstanceSpecSet.setter
    def InstanceSpecSet(self, InstanceSpecSet):
        self._InstanceSpecSet = InstanceSpecSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSpecSet") is not None:
            self._InstanceSpecSet = []
            for item in params.get("InstanceSpecSet"):
                obj = InstanceSpec()
                obj._deserialize(item)
                self._InstanceSpecSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    r"""DescribeInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned results. Default value: 20. Maximum value: 100
        :type Limit: int
        :param _Offset: Record offset. Default value: 0
        :type Offset: int
        :param _OrderBy: Sort by field. Valid values:
<li> CREATETIME: creation time</li>
<li> PERIODENDTIME: expiration time</li>
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values:
<li> ASC: ascending</li>
<li> DESC: descending</li>
        :type OrderByType: str
        :param _Filters: Filter. If more than one filter exists, the logical relationship between these filters is `AND`.
        :type Filters: list of QueryFilter
        :param _DbType: Engine type. Currently, `MYSQL` is supported.
        :type DbType: str
        :param _Status: Instance status. Valid values:
creating
running
isolating
isolated
activating: Removing the instance from isolation
offlining: Eliminating the instance
offlined: Instance eliminated
        :type Status: str
        :param _InstanceIds: Instance ID list
        :type InstanceIds: list of str
        """
        self._Limit = None
        self._Offset = None
        self._OrderBy = None
        self._OrderByType = None
        self._Filters = None
        self._DbType = None
        self._Status = None
        self._InstanceIds = None

    @property
    def Limit(self):
        r"""Number of returned results. Default value: 20. Maximum value: 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Record offset. Default value: 0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def OrderBy(self):
        r"""Sort by field. Valid values:
<li> CREATETIME: creation time</li>
<li> PERIODENDTIME: expiration time</li>
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values:
<li> ASC: ascending</li>
<li> DESC: descending</li>
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def Filters(self):
        r"""Filter. If more than one filter exists, the logical relationship between these filters is `AND`.
        :rtype: list of QueryFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DbType(self):
        r"""Engine type. Currently, `MYSQL` is supported.
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def Status(self):
        r"""Instance status. Valid values:
creating
running
isolating
isolated
activating: Removing the instance from isolation
offlining: Eliminating the instance
offlined: Instance eliminated
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceIds(self):
        r"""Instance ID list
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DbType = params.get("DbType")
        self._Status = params.get("Status")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    r"""DescribeInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of instances
        :type TotalCount: int
        :param _InstanceSet: Instance list
        :type InstanceSet: list of CynosdbInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of instances
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        r"""Instance list
        :rtype: list of CynosdbInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CynosdbInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesWithinSameClusterRequest(AbstractModel):
    r"""DescribeInstancesWithinSameCluster request structure.

    """

    def __init__(self):
        r"""
        :param _UniqVpcId: vpcId
        :type UniqVpcId: str
        :param _Vip: vip
        :type Vip: str
        """
        self._UniqVpcId = None
        self._Vip = None

    @property
    def UniqVpcId(self):
        r"""vpcId
        :rtype: str
        """
        return self._UniqVpcId

    @UniqVpcId.setter
    def UniqVpcId(self, UniqVpcId):
        self._UniqVpcId = UniqVpcId

    @property
    def Vip(self):
        r"""vip
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip


    def _deserialize(self, params):
        self._UniqVpcId = params.get("UniqVpcId")
        self._Vip = params.get("Vip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesWithinSameClusterResponse(AbstractModel):
    r"""DescribeInstancesWithinSameCluster response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of instances.
        :type TotalCount: int
        :param _InstanceIds: Instance ID list.
        :type InstanceIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceIds = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceIds(self):
        r"""Instance ID list.
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._InstanceIds = params.get("InstanceIds")
        self._RequestId = params.get("RequestId")


class DescribeIntegrateTaskRequest(AbstractModel):
    r"""DescribeIntegrateTask request structure.

    """

    def __init__(self):
        r"""
        :param _BigDealId: Large order id. must choose between large order id and sub-order id.
        :type BigDealId: str
        :param _DealNames: Order list
        :type DealNames: list of str
        """
        self._BigDealId = None
        self._DealNames = None

    @property
    def BigDealId(self):
        r"""Large order id. must choose between large order id and sub-order id.
        :rtype: str
        """
        return self._BigDealId

    @BigDealId.setter
    def BigDealId(self, BigDealId):
        self._BigDealId = BigDealId

    @property
    def DealNames(self):
        r"""Order list
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames


    def _deserialize(self, params):
        self._BigDealId = params.get("BigDealId")
        self._DealNames = params.get("DealNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrateTaskResponse(AbstractModel):
    r"""DescribeIntegrateTask response structure.

    """

    def __init__(self):
        r"""
        :param _CurrentStep: Current step.
        :type CurrentStep: str
        :param _CurrentProgress: Current progress.
        :type CurrentProgress: str
        :param _TaskStatus: Indicates the task status.
        :type TaskStatus: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CurrentStep = None
        self._CurrentProgress = None
        self._TaskStatus = None
        self._RequestId = None

    @property
    def CurrentStep(self):
        r"""Current step.
        :rtype: str
        """
        return self._CurrentStep

    @CurrentStep.setter
    def CurrentStep(self, CurrentStep):
        self._CurrentStep = CurrentStep

    @property
    def CurrentProgress(self):
        r"""Current progress.
        :rtype: str
        """
        return self._CurrentProgress

    @CurrentProgress.setter
    def CurrentProgress(self, CurrentProgress):
        self._CurrentProgress = CurrentProgress

    @property
    def TaskStatus(self):
        r"""Indicates the task status.
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CurrentStep = params.get("CurrentStep")
        self._CurrentProgress = params.get("CurrentProgress")
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeIsolatedInstancesRequest(AbstractModel):
    r"""DescribeIsolatedInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned results. the default value is 20. the maximum value is 100.
        :type Limit: int
        :param _Offset: Record offset. default value: 0.
        :type Offset: int
        :param _OrderBy: Sorting field. valid values:.
<Li>CREATETIME: creation time</li>.
<li> PERIODENDTIME: expiration time</li>.
        :type OrderBy: str
        :param _OrderByType: Sorting type. value range:.
<Li>ASC: specifies ascending sort.</li>.
<li> DESC: sorts in descending order. </li>.
        :type OrderByType: str
        :param _Filters: Search criteria. when multiple filters exist, the relationship between filters is logical AND.
        :type Filters: list of QueryFilter
        :param _DbType: Engine type: currently supports "MYSQL", "POSTGRESQL".
        :type DbType: str
        """
        self._Limit = None
        self._Offset = None
        self._OrderBy = None
        self._OrderByType = None
        self._Filters = None
        self._DbType = None

    @property
    def Limit(self):
        r"""Number of returned results. the default value is 20. the maximum value is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Record offset. default value: 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def OrderBy(self):
        r"""Sorting field. valid values:.
<Li>CREATETIME: creation time</li>.
<li> PERIODENDTIME: expiration time</li>.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting type. value range:.
<Li>ASC: specifies ascending sort.</li>.
<li> DESC: sorts in descending order. </li>.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def Filters(self):
        r"""Search criteria. when multiple filters exist, the relationship between filters is logical AND.
        :rtype: list of QueryFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def DbType(self):
        r"""Engine type: currently supports "MYSQL", "POSTGRESQL".
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._DbType = params.get("DbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIsolatedInstancesResponse(AbstractModel):
    r"""DescribeIsolatedInstances response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of instances.
        :type TotalCount: int
        :param _InstanceSet: Instance list
        :type InstanceSet: list of CynosdbInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of instances.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        r"""Instance list
        :rtype: list of CynosdbInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CynosdbInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMaintainPeriodRequest(AbstractModel):
    r"""DescribeMaintainPeriod request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMaintainPeriodResponse(AbstractModel):
    r"""DescribeMaintainPeriod response structure.

    """

    def __init__(self):
        r"""
        :param _MaintainWeekDays: Maintenance days of the week
        :type MaintainWeekDays: list of str
        :param _MaintainStartTime: Maintenance start time in seconds
        :type MaintainStartTime: int
        :param _MaintainDuration: Maintenance duration in seconds
        :type MaintainDuration: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MaintainWeekDays = None
        self._MaintainStartTime = None
        self._MaintainDuration = None
        self._RequestId = None

    @property
    def MaintainWeekDays(self):
        r"""Maintenance days of the week
        :rtype: list of str
        """
        return self._MaintainWeekDays

    @MaintainWeekDays.setter
    def MaintainWeekDays(self, MaintainWeekDays):
        self._MaintainWeekDays = MaintainWeekDays

    @property
    def MaintainStartTime(self):
        r"""Maintenance start time in seconds
        :rtype: int
        """
        return self._MaintainStartTime

    @MaintainStartTime.setter
    def MaintainStartTime(self, MaintainStartTime):
        self._MaintainStartTime = MaintainStartTime

    @property
    def MaintainDuration(self):
        r"""Maintenance duration in seconds
        :rtype: int
        """
        return self._MaintainDuration

    @MaintainDuration.setter
    def MaintainDuration(self, MaintainDuration):
        self._MaintainDuration = MaintainDuration

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MaintainWeekDays = params.get("MaintainWeekDays")
        self._MaintainStartTime = params.get("MaintainStartTime")
        self._MaintainDuration = params.get("MaintainDuration")
        self._RequestId = params.get("RequestId")


class DescribeParamTemplateDetailRequest(AbstractModel):
    r"""DescribeParamTemplateDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Parameter template ID
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        r"""Parameter template ID
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeParamTemplateDetailResponse(AbstractModel):
    r"""DescribeParamTemplateDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Parameter template ID
        :type TemplateId: int
        :param _TemplateName: Parameter template name
        :type TemplateName: str
        :param _TemplateDescription: Parameter template description
        :type TemplateDescription: str
        :param _EngineVersion: Engine version
        :type EngineVersion: str
        :param _TotalCount: Total number of parameters
        :type TotalCount: int
        :param _Items: List of parameters
        :type Items: list of ParamDetail
        :param _DbMode: Database type. Valid values:  `NORMAL`, `SERVERLESS`.
        :type DbMode: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TemplateId = None
        self._TemplateName = None
        self._TemplateDescription = None
        self._EngineVersion = None
        self._TotalCount = None
        self._Items = None
        self._DbMode = None
        self._RequestId = None

    @property
    def TemplateId(self):
        r"""Parameter template ID
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        r"""Parameter template name
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def TemplateDescription(self):
        r"""Parameter template description
        :rtype: str
        """
        return self._TemplateDescription

    @TemplateDescription.setter
    def TemplateDescription(self, TemplateDescription):
        self._TemplateDescription = TemplateDescription

    @property
    def EngineVersion(self):
        r"""Engine version
        :rtype: str
        """
        return self._EngineVersion

    @EngineVersion.setter
    def EngineVersion(self, EngineVersion):
        self._EngineVersion = EngineVersion

    @property
    def TotalCount(self):
        r"""Total number of parameters
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""List of parameters
        :rtype: list of ParamDetail
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def DbMode(self):
        r"""Database type. Valid values:  `NORMAL`, `SERVERLESS`.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._TemplateDescription = params.get("TemplateDescription")
        self._EngineVersion = params.get("EngineVersion")
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ParamDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._DbMode = params.get("DbMode")
        self._RequestId = params.get("RequestId")


class DescribeParamTemplatesRequest(AbstractModel):
    r"""DescribeParamTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _EngineVersions: Database engine version number
        :type EngineVersions: list of str
        :param _TemplateNames: Template name
        :type TemplateNames: list of str
        :param _TemplateIds: Template ID
        :type TemplateIds: list of int
        :param _DbModes: Database Type. Valid values: `NORMAL`, `SERVERLESS`.
        :type DbModes: list of str
        :param _Offset: Offset for query
        :type Offset: int
        :param _Limit: Limit on queries
        :type Limit: int
        :param _Products: Product type of the queried template
        :type Products: list of str
        :param _TemplateTypes: Template type
        :type TemplateTypes: list of str
        :param _EngineTypes: Version type
        :type EngineTypes: list of str
        :param _OrderBy: The sorting order of the returned results
        :type OrderBy: str
        :param _OrderDirection: Sorting order. Valid values: `desc`, `asc `.
        :type OrderDirection: str
        """
        self._EngineVersions = None
        self._TemplateNames = None
        self._TemplateIds = None
        self._DbModes = None
        self._Offset = None
        self._Limit = None
        self._Products = None
        self._TemplateTypes = None
        self._EngineTypes = None
        self._OrderBy = None
        self._OrderDirection = None

    @property
    def EngineVersions(self):
        r"""Database engine version number
        :rtype: list of str
        """
        return self._EngineVersions

    @EngineVersions.setter
    def EngineVersions(self, EngineVersions):
        self._EngineVersions = EngineVersions

    @property
    def TemplateNames(self):
        r"""Template name
        :rtype: list of str
        """
        return self._TemplateNames

    @TemplateNames.setter
    def TemplateNames(self, TemplateNames):
        self._TemplateNames = TemplateNames

    @property
    def TemplateIds(self):
        r"""Template ID
        :rtype: list of int
        """
        return self._TemplateIds

    @TemplateIds.setter
    def TemplateIds(self, TemplateIds):
        self._TemplateIds = TemplateIds

    @property
    def DbModes(self):
        r"""Database Type. Valid values: `NORMAL`, `SERVERLESS`.
        :rtype: list of str
        """
        return self._DbModes

    @DbModes.setter
    def DbModes(self, DbModes):
        self._DbModes = DbModes

    @property
    def Offset(self):
        r"""Offset for query
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit on queries
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Products(self):
        r"""Product type of the queried template
        :rtype: list of str
        """
        return self._Products

    @Products.setter
    def Products(self, Products):
        self._Products = Products

    @property
    def TemplateTypes(self):
        r"""Template type
        :rtype: list of str
        """
        return self._TemplateTypes

    @TemplateTypes.setter
    def TemplateTypes(self, TemplateTypes):
        self._TemplateTypes = TemplateTypes

    @property
    def EngineTypes(self):
        r"""Version type
        :rtype: list of str
        """
        return self._EngineTypes

    @EngineTypes.setter
    def EngineTypes(self, EngineTypes):
        self._EngineTypes = EngineTypes

    @property
    def OrderBy(self):
        r"""The sorting order of the returned results
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderDirection(self):
        r"""Sorting order. Valid values: `desc`, `asc `.
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._EngineVersions = params.get("EngineVersions")
        self._TemplateNames = params.get("TemplateNames")
        self._TemplateIds = params.get("TemplateIds")
        self._DbModes = params.get("DbModes")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Products = params.get("Products")
        self._TemplateTypes = params.get("TemplateTypes")
        self._EngineTypes = params.get("EngineTypes")
        self._OrderBy = params.get("OrderBy")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeParamTemplatesResponse(AbstractModel):
    r"""DescribeParamTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of parameter templates
        :type TotalCount: int
        :param _Items: Parameter template information
        :type Items: list of ParamTemplateListInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of parameter templates
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""Parameter template information
        :rtype: list of ParamTemplateListInfo
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ParamTemplateListInfo()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProjectSecurityGroupsRequest(AbstractModel):
    r"""DescribeProjectSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: int
        :param _Limit: Maximum entries returned per page
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        :param _SearchKey: Search by keyword
        :type SearchKey: str
        """
        self._ProjectId = None
        self._Limit = None
        self._Offset = None
        self._SearchKey = None

    @property
    def ProjectId(self):
        r"""Project ID
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Limit(self):
        r"""Maximum entries returned per page
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SearchKey(self):
        r"""Search by keyword
        :rtype: str
        """
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectSecurityGroupsResponse(AbstractModel):
    r"""DescribeProjectSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _Groups: Security group details
        :type Groups: list of SecurityGroup
        :param _Total: The total number of groups
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Groups = None
        self._Total = None
        self._RequestId = None

    @property
    def Groups(self):
        r"""Security group details
        :rtype: list of SecurityGroup
        """
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def Total(self):
        r"""The total number of groups
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = SecurityGroup()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeProxiesRequest(AbstractModel):
    r"""DescribeProxies request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID (this parameter is required. for example, cynosdbmysql-2u2mh111).
        :type ClusterId: str
        :param _Limit: Number of returned results. Default value: `20`. Maximum value: `100`,
        :type Limit: int
        :param _Offset: Record offset. Default value: `0`.
        :type Offset: int
        :param _OrderBy: Sorting field. Valid values:
<li> CREATETIME: Creation time</li>
<li> PERIODENDTIME: Expiration time</li>
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values:
<li> `ASC`: Ascending.</li>
<li> `DESC`: Descending</li>
        :type OrderByType: str
        :param _Filters: Filter. If there are more than one filter, the logical relationship between these filters is `AND`.
        :type Filters: list of QueryParamFilter
        """
        self._ClusterId = None
        self._Limit = None
        self._Offset = None
        self._OrderBy = None
        self._OrderByType = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""Cluster ID (this parameter is required. for example, cynosdbmysql-2u2mh111).
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        r"""Number of returned results. Default value: `20`. Maximum value: `100`,
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Record offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def OrderBy(self):
        r"""Sorting field. Valid values:
<li> CREATETIME: Creation time</li>
<li> PERIODENDTIME: Expiration time</li>
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values:
<li> `ASC`: Ascending.</li>
<li> `DESC`: Descending</li>
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def Filters(self):
        r"""Filter. If there are more than one filter, the logical relationship between these filters is `AND`.
        :rtype: list of QueryParamFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryParamFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProxiesResponse(AbstractModel):
    r"""DescribeProxies response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of database proxy groups
        :type TotalCount: int
        :param _ProxyGroupInfos: List of database proxy groups.
        :type ProxyGroupInfos: list of ProxyGroupInfo
        :param _ProxyNodeInfos: Database proxy node
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProxyNodeInfos: list of ProxyNodeInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProxyGroupInfos = None
        self._ProxyNodeInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of database proxy groups
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProxyGroupInfos(self):
        r"""List of database proxy groups.
        :rtype: list of ProxyGroupInfo
        """
        return self._ProxyGroupInfos

    @ProxyGroupInfos.setter
    def ProxyGroupInfos(self, ProxyGroupInfos):
        self._ProxyGroupInfos = ProxyGroupInfos

    @property
    def ProxyNodeInfos(self):
        r"""Database proxy node
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ProxyNodeInfo
        """
        return self._ProxyNodeInfos

    @ProxyNodeInfos.setter
    def ProxyNodeInfos(self, ProxyNodeInfos):
        self._ProxyNodeInfos = ProxyNodeInfos

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProxyGroupInfos") is not None:
            self._ProxyGroupInfos = []
            for item in params.get("ProxyGroupInfos"):
                obj = ProxyGroupInfo()
                obj._deserialize(item)
                self._ProxyGroupInfos.append(obj)
        if params.get("ProxyNodeInfos") is not None:
            self._ProxyNodeInfos = []
            for item in params.get("ProxyNodeInfos"):
                obj = ProxyNodeInfo()
                obj._deserialize(item)
                self._ProxyNodeInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProxyNodesRequest(AbstractModel):
    r"""DescribeProxyNodes request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned results. Default value: `20`. Maximum value: `100`,
        :type Limit: int
        :param _Offset: Record offset. Default value: `0`.
        :type Offset: int
        :param _OrderBy: Sorting field. Valid values:
<li> CREATETIME: Creation time</li>
<li> PERIODENDTIME: Expiration time</li>
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values:
<li> `ASC`: Ascending.</li>
<li> `DESC`: Descending</li>
        :type OrderByType: str
        :param _Filters: Filter. If there are more than one filter, the logical relationship between these filters is `AND`.
        :type Filters: list of QueryFilter
        """
        self._Limit = None
        self._Offset = None
        self._OrderBy = None
        self._OrderByType = None
        self._Filters = None

    @property
    def Limit(self):
        r"""Number of returned results. Default value: `20`. Maximum value: `100`,
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Record offset. Default value: `0`.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def OrderBy(self):
        r"""Sorting field. Valid values:
<li> CREATETIME: Creation time</li>
<li> PERIODENDTIME: Expiration time</li>
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values:
<li> `ASC`: Ascending.</li>
<li> `DESC`: Descending</li>
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def Filters(self):
        r"""Filter. If there are more than one filter, the logical relationship between these filters is `AND`.
        :rtype: list of QueryFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProxyNodesResponse(AbstractModel):
    r"""DescribeProxyNodes response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of the database proxy nodes
        :type TotalCount: int
        :param _ProxyNodeInfos: List of the database proxy nodes
        :type ProxyNodeInfos: list of ProxyNodeInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProxyNodeInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Number of the database proxy nodes
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProxyNodeInfos(self):
        r"""List of the database proxy nodes
        :rtype: list of ProxyNodeInfo
        """
        return self._ProxyNodeInfos

    @ProxyNodeInfos.setter
    def ProxyNodeInfos(self, ProxyNodeInfos):
        self._ProxyNodeInfos = ProxyNodeInfos

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProxyNodeInfos") is not None:
            self._ProxyNodeInfos = []
            for item in params.get("ProxyNodeInfos"):
                obj = ProxyNodeInfo()
                obj._deserialize(item)
                self._ProxyNodeInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProxySpecsRequest(AbstractModel):
    r"""DescribeProxySpecs request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProxySpecsResponse(AbstractModel):
    r"""DescribeProxySpecs response structure.

    """

    def __init__(self):
        r"""
        :param _ProxySpecs: List of database proxyspecifications
        :type ProxySpecs: list of ProxySpec
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProxySpecs = None
        self._RequestId = None

    @property
    def ProxySpecs(self):
        r"""List of database proxyspecifications
        :rtype: list of ProxySpec
        """
        return self._ProxySpecs

    @ProxySpecs.setter
    def ProxySpecs(self, ProxySpecs):
        self._ProxySpecs = ProxySpecs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProxySpecs") is not None:
            self._ProxySpecs = []
            for item in params.get("ProxySpecs"):
                obj = ProxySpec()
                obj._deserialize(item)
                self._ProxySpecs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourcePackageDetailRequest(AbstractModel):
    r"""DescribeResourcePackageDetail request structure.

    """

    def __init__(self):
        r"""
        :param _PackageId: The unique ID of a resource pack
        :type PackageId: str
        :param _ClusterIds: Cluster ID
        :type ClusterIds: list of str
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _Offset: Offset
        :type Offset: str
        :param _Limit: Limit
        :type Limit: str
        :param _InstanceIds: Instance D
        :type InstanceIds: list of str
        """
        self._PackageId = None
        self._ClusterIds = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None
        self._InstanceIds = None

    @property
    def PackageId(self):
        r"""The unique ID of a resource pack
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def ClusterIds(self):
        r"""Cluster ID
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def StartTime(self):
        r"""Start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        r"""Offset
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def InstanceIds(self):
        r"""Instance D
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._ClusterIds = params.get("ClusterIds")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourcePackageDetailResponse(AbstractModel):
    r"""DescribeResourcePackageDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of deducted resource packs
        :type Total: int
        :param _Detail: Resource pack details
        :type Detail: list of PackageDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Detail = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number of deducted resource packs
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Detail(self):
        r"""Resource pack details
        :rtype: list of PackageDetail
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Detail") is not None:
            self._Detail = []
            for item in params.get("Detail"):
                obj = PackageDetail()
                obj._deserialize(item)
                self._Detail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourcePackageListRequest(AbstractModel):
    r"""DescribeResourcePackageList request structure.

    """

    def __init__(self):
        r"""
        :param _PackageId: The unique ID of a resource pack
        :type PackageId: list of str
        :param _PackageName: Resource pack name
        :type PackageName: list of str
        :param _PackageType: Resource pack type. Valid values: `CCU` (compute resource pack), `DISK` (storage resource pack).
        :type PackageType: list of str
        :param _PackageRegion: Region of the resource pack. Valid values: `China` (Chinese mainland), `overseas` (outside Chinese mainland).
        :type PackageRegion: list of str
        :param _Status: Resource pack status. Valid values: `using`, `expired`, `normal_finish` (used up), `apply_refund` (requesting a refund), `refund` (refunded).
        :type Status: list of str
        :param _OrderBy: Sorting conditions. Valid values: `startTime` (effective time), `expireTime` (expiration date), `packageUsedSpec` (used capacity), `packageTotalSpec` (total storage capacity). 
Sorting by array order
        :type OrderBy: list of str
        :param _OrderDirection: Sorting order. Valid values: `ASC` (ascending), `DESC` (descending).
        :type OrderDirection: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Limit
        :type Limit: int
        """
        self._PackageId = None
        self._PackageName = None
        self._PackageType = None
        self._PackageRegion = None
        self._Status = None
        self._OrderBy = None
        self._OrderDirection = None
        self._Offset = None
        self._Limit = None

    @property
    def PackageId(self):
        r"""The unique ID of a resource pack
        :rtype: list of str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def PackageName(self):
        r"""Resource pack name
        :rtype: list of str
        """
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def PackageType(self):
        r"""Resource pack type. Valid values: `CCU` (compute resource pack), `DISK` (storage resource pack).
        :rtype: list of str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def PackageRegion(self):
        r"""Region of the resource pack. Valid values: `China` (Chinese mainland), `overseas` (outside Chinese mainland).
        :rtype: list of str
        """
        return self._PackageRegion

    @PackageRegion.setter
    def PackageRegion(self, PackageRegion):
        self._PackageRegion = PackageRegion

    @property
    def Status(self):
        r"""Resource pack status. Valid values: `using`, `expired`, `normal_finish` (used up), `apply_refund` (requesting a refund), `refund` (refunded).
        :rtype: list of str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OrderBy(self):
        r"""Sorting conditions. Valid values: `startTime` (effective time), `expireTime` (expiration date), `packageUsedSpec` (used capacity), `packageTotalSpec` (total storage capacity). 
Sorting by array order
        :rtype: list of str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderDirection(self):
        r"""Sorting order. Valid values: `ASC` (ascending), `DESC` (descending).
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._PackageName = params.get("PackageName")
        self._PackageType = params.get("PackageType")
        self._PackageRegion = params.get("PackageRegion")
        self._Status = params.get("Status")
        self._OrderBy = params.get("OrderBy")
        self._OrderDirection = params.get("OrderDirection")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourcePackageListResponse(AbstractModel):
    r"""DescribeResourcePackageList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of resource packs
        :type Total: int
        :param _Detail: Resource pack details.
        :type Detail: list of Package
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Detail = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number of resource packs
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Detail(self):
        r"""Resource pack details.
        :rtype: list of Package
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Detail") is not None:
            self._Detail = []
            for item in params.get("Detail"):
                obj = Package()
                obj._deserialize(item)
                self._Detail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourcePackageSaleSpecRequest(AbstractModel):
    r"""DescribeResourcePackageSaleSpec request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceType: Instance type
        :type InstanceType: str
        :param _PackageRegion: Region of the resource pack. Valid values: `China` (Chinese mainland), `overseas` (outside Chinese mainland).
        :type PackageRegion: str
        :param _PackageType: Resource pack type. Valid values: `CCU` (compute resource pack, `DISK` (storage resource pack).
        :type PackageType: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Limit
        :type Limit: int
        """
        self._InstanceType = None
        self._PackageRegion = None
        self._PackageType = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceType(self):
        r"""Instance type
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def PackageRegion(self):
        r"""Region of the resource pack. Valid values: `China` (Chinese mainland), `overseas` (outside Chinese mainland).
        :rtype: str
        """
        return self._PackageRegion

    @PackageRegion.setter
    def PackageRegion(self, PackageRegion):
        self._PackageRegion = PackageRegion

    @property
    def PackageType(self):
        r"""Resource pack type. Valid values: `CCU` (compute resource pack, `DISK` (storage resource pack).
        :rtype: str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""Limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._PackageRegion = params.get("PackageRegion")
        self._PackageType = params.get("PackageType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourcePackageSaleSpecResponse(AbstractModel):
    r"""DescribeResourcePackageSaleSpec response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of available resource packs
        :type Total: int
        :param _Detail: Specifies the details of the resource pack.
        :type Detail: list of SalePackageSpec
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Detail = None
        self._RequestId = None

    @property
    def Total(self):
        r"""Total number of available resource packs
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Detail(self):
        r"""Specifies the details of the resource pack.
        :rtype: list of SalePackageSpec
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Detail") is not None:
            self._Detail = []
            for item in params.get("Detail"):
                obj = SalePackageSpec()
                obj._deserialize(item)
                self._Detail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourcesByDealNameRequest(AbstractModel):
    r"""DescribeResourcesByDealName request structure.

    """

    def __init__(self):
        r"""
        :param _DealName: Order ID. (If the cluster is not delivered yet, the `DescribeResourcesByDealName` API may return the `InvalidParameterValue.DealNameNotFound` error. Call the API again until it succeeds.)
        :type DealName: str
        :param _DealNames: Order ID, which can be used to query the resource information of multiple orders ID (If the cluster is not delivered yet, the `DescribeResourcesByDealName` API may return the `InvalidParameterValue.DealNameNotFound` error. Call the API again until it succeeds.)
        :type DealNames: list of str
        """
        self._DealName = None
        self._DealNames = None

    @property
    def DealName(self):
        r"""Order ID. (If the cluster is not delivered yet, the `DescribeResourcesByDealName` API may return the `InvalidParameterValue.DealNameNotFound` error. Call the API again until it succeeds.)
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def DealNames(self):
        r"""Order ID, which can be used to query the resource information of multiple orders ID (If the cluster is not delivered yet, the `DescribeResourcesByDealName` API may return the `InvalidParameterValue.DealNameNotFound` error. Call the API again until it succeeds.)
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames


    def _deserialize(self, params):
        self._DealName = params.get("DealName")
        self._DealNames = params.get("DealNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourcesByDealNameResponse(AbstractModel):
    r"""DescribeResourcesByDealName response structure.

    """

    def __init__(self):
        r"""
        :param _BillingResourceInfos: Billable resource ID information array
        :type BillingResourceInfos: list of BillingResourceInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BillingResourceInfos = None
        self._RequestId = None

    @property
    def BillingResourceInfos(self):
        r"""Billable resource ID information array
        :rtype: list of BillingResourceInfo
        """
        return self._BillingResourceInfos

    @BillingResourceInfos.setter
    def BillingResourceInfos(self, BillingResourceInfos):
        self._BillingResourceInfos = BillingResourceInfos

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BillingResourceInfos") is not None:
            self._BillingResourceInfos = []
            for item in params.get("BillingResourceInfos"):
                obj = BillingResourceInfo()
                obj._deserialize(item)
                self._BillingResourceInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRollbackTimeRangeRequest(AbstractModel):
    r"""DescribeRollbackTimeRange request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRollbackTimeRangeResponse(AbstractModel):
    r"""DescribeRollbackTimeRange response structure.

    """

    def __init__(self):
        r"""
        :param _TimeRangeStart: Valid regression time range start time point (abandoned).
        :type TimeRangeStart: str
        :param _TimeRangeEnd: Valid regression time range end time point (abandoned).
        :type TimeRangeEnd: str
        :param _RollbackTimeRanges: Time range available for rollback
        :type RollbackTimeRanges: list of RollbackTimeRange
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TimeRangeStart = None
        self._TimeRangeEnd = None
        self._RollbackTimeRanges = None
        self._RequestId = None

    @property
    def TimeRangeStart(self):
        r"""Valid regression time range start time point (abandoned).
        :rtype: str
        """
        return self._TimeRangeStart

    @TimeRangeStart.setter
    def TimeRangeStart(self, TimeRangeStart):
        self._TimeRangeStart = TimeRangeStart

    @property
    def TimeRangeEnd(self):
        r"""Valid regression time range end time point (abandoned).
        :rtype: str
        """
        return self._TimeRangeEnd

    @TimeRangeEnd.setter
    def TimeRangeEnd(self, TimeRangeEnd):
        self._TimeRangeEnd = TimeRangeEnd

    @property
    def RollbackTimeRanges(self):
        r"""Time range available for rollback
        :rtype: list of RollbackTimeRange
        """
        return self._RollbackTimeRanges

    @RollbackTimeRanges.setter
    def RollbackTimeRanges(self, RollbackTimeRanges):
        self._RollbackTimeRanges = RollbackTimeRanges

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TimeRangeStart = params.get("TimeRangeStart")
        self._TimeRangeEnd = params.get("TimeRangeEnd")
        if params.get("RollbackTimeRanges") is not None:
            self._RollbackTimeRanges = []
            for item in params.get("RollbackTimeRanges"):
                obj = RollbackTimeRange()
                obj._deserialize(item)
                self._RollbackTimeRanges.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServerlessInstanceSpecsRequest(AbstractModel):
    r"""DescribeServerlessInstanceSpecs request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: Availability zone
        :type Zone: str
        """
        self._Zone = None

    @property
    def Zone(self):
        r"""Availability zone
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServerlessInstanceSpecsResponse(AbstractModel):
    r"""DescribeServerlessInstanceSpecs response structure.

    """

    def __init__(self):
        r"""
        :param _Specs: Available specifications of Serverless instance.
        :type Specs: list of ServerlessSpec
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Specs = None
        self._RequestId = None

    @property
    def Specs(self):
        r"""Available specifications of Serverless instance.
        :rtype: list of ServerlessSpec
        """
        return self._Specs

    @Specs.setter
    def Specs(self, Specs):
        self._Specs = Specs

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Specs") is not None:
            self._Specs = []
            for item in params.get("Specs"):
                obj = ServerlessSpec()
                obj._deserialize(item)
                self._Specs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServerlessStrategyRequest(AbstractModel):
    r"""DescribeServerlessStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Specifies the serverless cluster id.
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Specifies the serverless cluster id.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServerlessStrategyResponse(AbstractModel):
    r"""DescribeServerlessStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _AutoPauseDelay: Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0.
        :type AutoPauseDelay: int
        :param _AutoScaleUpDelay: Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications.
        :type AutoScaleUpDelay: int
        :param _AutoScaleDownDelay: Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down.
        :type AutoScaleDownDelay: int
        :param _AutoPause: Whether to automatically pause. valid values:.
yes
no
        :type AutoPause: str
        :param _AutoScaleUp: Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>.
        :type AutoScaleUp: str
        :param _AutoScaleDown: Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>.
        :type AutoScaleDown: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AutoPauseDelay = None
        self._AutoScaleUpDelay = None
        self._AutoScaleDownDelay = None
        self._AutoPause = None
        self._AutoScaleUp = None
        self._AutoScaleDown = None
        self._RequestId = None

    @property
    def AutoPauseDelay(self):
        r"""Specifies how long (in seconds) the auto-pause is triggered when the cpu load is 0.
        :rtype: int
        """
        return self._AutoPauseDelay

    @AutoPauseDelay.setter
    def AutoPauseDelay(self, AutoPauseDelay):
        self._AutoPauseDelay = AutoPauseDelay

    @property
    def AutoScaleUpDelay(self):
        r"""Specifies how long (in seconds) the auto-scaling is triggered when the cpu load exceeds the number of cores in the current specifications.
        :rtype: int
        """
        return self._AutoScaleUpDelay

    @AutoScaleUpDelay.setter
    def AutoScaleUpDelay(self, AutoScaleUpDelay):
        self._AutoScaleUpDelay = AutoScaleUpDelay

    @property
    def AutoScaleDownDelay(self):
        r"""Specifies how long (in seconds) the system will wait for the cpu load to be lower than the number of cores in the lower specification before triggering automatic scaling down.
        :rtype: int
        """
        return self._AutoScaleDownDelay

    @AutoScaleDownDelay.setter
    def AutoScaleDownDelay(self, AutoScaleDownDelay):
        self._AutoScaleDownDelay = AutoScaleDownDelay

    @property
    def AutoPause(self):
        r"""Whether to automatically pause. valid values:.
yes
no
        :rtype: str
        """
        return self._AutoPause

    @AutoPause.setter
    def AutoPause(self, AutoPause):
        self._AutoPause = AutoPause

    @property
    def AutoScaleUp(self):
        r"""Specifies whether the cluster allows upward scaling. valid values: <li>yes</li><li>no</li>.
        :rtype: str
        """
        return self._AutoScaleUp

    @AutoScaleUp.setter
    def AutoScaleUp(self, AutoScaleUp):
        self._AutoScaleUp = AutoScaleUp

    @property
    def AutoScaleDown(self):
        r"""Whether the cluster is allowed to scale down. valid values: <li>yes</li><li>no</li>.
        :rtype: str
        """
        return self._AutoScaleDown

    @AutoScaleDown.setter
    def AutoScaleDown(self, AutoScaleDown):
        self._AutoScaleDown = AutoScaleDown

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AutoPauseDelay = params.get("AutoPauseDelay")
        self._AutoScaleUpDelay = params.get("AutoScaleUpDelay")
        self._AutoScaleDownDelay = params.get("AutoScaleDownDelay")
        self._AutoPause = params.get("AutoPause")
        self._AutoScaleUp = params.get("AutoScaleUp")
        self._AutoScaleDown = params.get("AutoScaleDown")
        self._RequestId = params.get("RequestId")


class DescribeSlaveZonesRequest(AbstractModel):
    r"""DescribeSlaveZones request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: Availability zone
        :type Zone: str
        :param _OssClusterId: Cloud frame cluster ID.
        :type OssClusterId: int
        """
        self._Zone = None
        self._OssClusterId = None

    @property
    def Zone(self):
        r"""Availability zone
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def OssClusterId(self):
        r"""Cloud frame cluster ID.
        :rtype: int
        """
        return self._OssClusterId

    @OssClusterId.setter
    def OssClusterId(self, OssClusterId):
        self._OssClusterId = OssClusterId


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._OssClusterId = params.get("OssClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSlaveZonesResponse(AbstractModel):
    r"""DescribeSlaveZones response structure.

    """

    def __init__(self):
        r"""
        :param _SlaveZones: Secondary AZ.
        :type SlaveZones: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SlaveZones = None
        self._RequestId = None

    @property
    def SlaveZones(self):
        r"""Secondary AZ.
        :rtype: list of str
        """
        return self._SlaveZones

    @SlaveZones.setter
    def SlaveZones(self, SlaveZones):
        self._SlaveZones = SlaveZones

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SlaveZones = params.get("SlaveZones")
        self._RequestId = params.get("RequestId")


class DescribeSupportProxyVersionRequest(AbstractModel):
    r"""DescribeSupportProxyVersion request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        """
        self._ClusterId = None
        self._ProxyGroupId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSupportProxyVersionResponse(AbstractModel):
    r"""DescribeSupportProxyVersion response structure.

    """

    def __init__(self):
        r"""
        :param _SupportProxyVersions: Supported database proxy version collections.
        :type SupportProxyVersions: list of str
        :param _CurrentProxyVersion: The current proxy version number.
        :type CurrentProxyVersion: str
        :param _SupportProxyVersionDetail: Specifies the proxy version details.
        :type SupportProxyVersionDetail: list of ProxyVersionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SupportProxyVersions = None
        self._CurrentProxyVersion = None
        self._SupportProxyVersionDetail = None
        self._RequestId = None

    @property
    def SupportProxyVersions(self):
        r"""Supported database proxy version collections.
        :rtype: list of str
        """
        return self._SupportProxyVersions

    @SupportProxyVersions.setter
    def SupportProxyVersions(self, SupportProxyVersions):
        self._SupportProxyVersions = SupportProxyVersions

    @property
    def CurrentProxyVersion(self):
        r"""The current proxy version number.
        :rtype: str
        """
        return self._CurrentProxyVersion

    @CurrentProxyVersion.setter
    def CurrentProxyVersion(self, CurrentProxyVersion):
        self._CurrentProxyVersion = CurrentProxyVersion

    @property
    def SupportProxyVersionDetail(self):
        r"""Specifies the proxy version details.
        :rtype: list of ProxyVersionInfo
        """
        return self._SupportProxyVersionDetail

    @SupportProxyVersionDetail.setter
    def SupportProxyVersionDetail(self, SupportProxyVersionDetail):
        self._SupportProxyVersionDetail = SupportProxyVersionDetail

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SupportProxyVersions = params.get("SupportProxyVersions")
        self._CurrentProxyVersion = params.get("CurrentProxyVersion")
        if params.get("SupportProxyVersionDetail") is not None:
            self._SupportProxyVersionDetail = []
            for item in params.get("SupportProxyVersionDetail"):
                obj = ProxyVersionInfo()
                obj._deserialize(item)
                self._SupportProxyVersionDetail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    r"""DescribeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _StartTimeBegin: Starting value of the task start time.
        :type StartTimeBegin: str
        :param _StartTimeEnd: End value of the task start time.
        :type StartTimeEnd: str
        :param _Filters: Filtering conditions. Supported fields for searching: "ClusterId", "ClusterName", "InstanceId", "InstanceName", "Status", "TaskId", and "TaskType".
        :type Filters: list of QueryFilter
        :param _Limit: Length of the list to be queried.
        :type Limit: int
        :param _Offset: Offset of the list to be queried.
        :type Offset: int
        """
        self._StartTimeBegin = None
        self._StartTimeEnd = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def StartTimeBegin(self):
        r"""Starting value of the task start time.
        :rtype: str
        """
        return self._StartTimeBegin

    @StartTimeBegin.setter
    def StartTimeBegin(self, StartTimeBegin):
        self._StartTimeBegin = StartTimeBegin

    @property
    def StartTimeEnd(self):
        r"""End value of the task start time.
        :rtype: str
        """
        return self._StartTimeEnd

    @StartTimeEnd.setter
    def StartTimeEnd(self, StartTimeEnd):
        self._StartTimeEnd = StartTimeEnd

    @property
    def Filters(self):
        r"""Filtering conditions. Supported fields for searching: "ClusterId", "ClusterName", "InstanceId", "InstanceName", "Status", "TaskId", and "TaskType".
        :rtype: list of QueryFilter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        r"""Length of the list to be queried.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset of the list to be queried.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._StartTimeBegin = params.get("StartTimeBegin")
        self._StartTimeEnd = params.get("StartTimeEnd")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = QueryFilter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    r"""DescribeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries in the task list.
        :type TotalCount: int
        :param _TaskList: Task list.
        :type TaskList: list of BizTaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TaskList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Total number of entries in the task list.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskList(self):
        r"""Task list.
        :rtype: list of BizTaskInfo
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = BizTaskInfo()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeZonesRequest(AbstractModel):
    r"""DescribeZones request structure.

    """

    def __init__(self):
        r"""
        :param _IncludeVirtualZones: Whether the virtual zone is included.
        :type IncludeVirtualZones: bool
        :param _ShowPermission: Whether to display all AZs in a region and the user's permissions in each AZ.
        :type ShowPermission: bool
        """
        self._IncludeVirtualZones = None
        self._ShowPermission = None

    @property
    def IncludeVirtualZones(self):
        r"""Whether the virtual zone is included.
        :rtype: bool
        """
        return self._IncludeVirtualZones

    @IncludeVirtualZones.setter
    def IncludeVirtualZones(self, IncludeVirtualZones):
        self._IncludeVirtualZones = IncludeVirtualZones

    @property
    def ShowPermission(self):
        r"""Whether to display all AZs in a region and the user's permissions in each AZ.
        :rtype: bool
        """
        return self._ShowPermission

    @ShowPermission.setter
    def ShowPermission(self, ShowPermission):
        self._ShowPermission = ShowPermission


    def _deserialize(self, params):
        self._IncludeVirtualZones = params.get("IncludeVirtualZones")
        self._ShowPermission = params.get("ShowPermission")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeZonesResponse(AbstractModel):
    r"""DescribeZones response structure.

    """

    def __init__(self):
        r"""
        :param _RegionSet: Region information
        :type RegionSet: list of SaleRegion
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RegionSet = None
        self._RequestId = None

    @property
    def RegionSet(self):
        r"""Region information
        :rtype: list of SaleRegion
        """
        return self._RegionSet

    @RegionSet.setter
    def RegionSet(self, RegionSet):
        self._RegionSet = RegionSet

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RegionSet") is not None:
            self._RegionSet = []
            for item in params.get("RegionSet"):
                obj = SaleRegion()
                obj._deserialize(item)
                self._RegionSet.append(obj)
        self._RequestId = params.get("RequestId")


class ErrorLogItemExport(AbstractModel):
    r"""The export format for an error log

    """

    def __init__(self):
        r"""
        :param _Timestamp: Time
        :type Timestamp: str
        :param _Level: Specifies the log level. valid values are note, warning, and error.
        :type Level: str
        :param _Content: Log content.
        :type Content: str
        """
        self._Timestamp = None
        self._Level = None
        self._Content = None

    @property
    def Timestamp(self):
        r"""Time
        :rtype: str
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Level(self):
        r"""Specifies the log level. valid values are note, warning, and error.
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Content(self):
        r"""Log content.
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._Level = params.get("Level")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExchangeInstanceInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _SrcInstanceInfo: Source instance information.
        :type SrcInstanceInfo: :class:`tencentcloud.cynosdb.v20190107.models.RollbackInstanceInfo`
        :param _DstInstanceInfo: Target instance information.
        :type DstInstanceInfo: :class:`tencentcloud.cynosdb.v20190107.models.RollbackInstanceInfo`
        """
        self._SrcInstanceInfo = None
        self._DstInstanceInfo = None

    @property
    def SrcInstanceInfo(self):
        r"""Source instance information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.RollbackInstanceInfo`
        """
        return self._SrcInstanceInfo

    @SrcInstanceInfo.setter
    def SrcInstanceInfo(self, SrcInstanceInfo):
        self._SrcInstanceInfo = SrcInstanceInfo

    @property
    def DstInstanceInfo(self):
        r"""Target instance information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.RollbackInstanceInfo`
        """
        return self._DstInstanceInfo

    @DstInstanceInfo.setter
    def DstInstanceInfo(self, DstInstanceInfo):
        self._DstInstanceInfo = DstInstanceInfo


    def _deserialize(self, params):
        if params.get("SrcInstanceInfo") is not None:
            self._SrcInstanceInfo = RollbackInstanceInfo()
            self._SrcInstanceInfo._deserialize(params.get("SrcInstanceInfo"))
        if params.get("DstInstanceInfo") is not None:
            self._DstInstanceInfo = RollbackInstanceInfo()
            self._DstInstanceInfo._deserialize(params.get("DstInstanceInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExchangeRoGroupInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _SrcRoGroupInfo: Source RO group information.
        :type SrcRoGroupInfo: :class:`tencentcloud.cynosdb.v20190107.models.RollbackRoGroupInfo`
        :param _DstRoGroupInfo: Target RO group information.
        :type DstRoGroupInfo: :class:`tencentcloud.cynosdb.v20190107.models.RollbackRoGroupInfo`
        """
        self._SrcRoGroupInfo = None
        self._DstRoGroupInfo = None

    @property
    def SrcRoGroupInfo(self):
        r"""Source RO group information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.RollbackRoGroupInfo`
        """
        return self._SrcRoGroupInfo

    @SrcRoGroupInfo.setter
    def SrcRoGroupInfo(self, SrcRoGroupInfo):
        self._SrcRoGroupInfo = SrcRoGroupInfo

    @property
    def DstRoGroupInfo(self):
        r"""Target RO group information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.RollbackRoGroupInfo`
        """
        return self._DstRoGroupInfo

    @DstRoGroupInfo.setter
    def DstRoGroupInfo(self, DstRoGroupInfo):
        self._DstRoGroupInfo = DstRoGroupInfo


    def _deserialize(self, params):
        if params.get("SrcRoGroupInfo") is not None:
            self._SrcRoGroupInfo = RollbackRoGroupInfo()
            self._SrcRoGroupInfo._deserialize(params.get("SrcRoGroupInfo"))
        if params.get("DstRoGroupInfo") is not None:
            self._DstRoGroupInfo = RollbackRoGroupInfo()
            self._DstRoGroupInfo._deserialize(params.get("DstRoGroupInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportInstanceErrorLogsRequest(AbstractModel):
    r"""ExportInstanceErrorLogs request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _StartTime: Log start time
        :type StartTime: str
        :param _EndTime: Log end time
        :type EndTime: str
        :param _Limit: The max number of returned results
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        :param _LogLevels: Log level
        :type LogLevels: list of str
        :param _KeyWords: 
        :type KeyWords: list of str
        :param _FileType: The template type. Valid values: `csv`, `original`.
        :type FileType: str
        :param _OrderBy: Valid value: `Timestamp`
        :type OrderBy: str
        :param _OrderByType: Sorting type. valid values: ASC or DESC.
        :type OrderByType: str
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._LogLevels = None
        self._KeyWords = None
        self._FileType = None
        self._OrderBy = None
        self._OrderByType = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Log start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Log end time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""The max number of returned results
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def LogLevels(self):
        r"""Log level
        :rtype: list of str
        """
        return self._LogLevels

    @LogLevels.setter
    def LogLevels(self, LogLevels):
        self._LogLevels = LogLevels

    @property
    def KeyWords(self):
        r"""
        :rtype: list of str
        """
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def FileType(self):
        r"""The template type. Valid values: `csv`, `original`.
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def OrderBy(self):
        r"""Valid value: `Timestamp`
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting type. valid values: ASC or DESC.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._LogLevels = params.get("LogLevels")
        self._KeyWords = params.get("KeyWords")
        self._FileType = params.get("FileType")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportInstanceErrorLogsResponse(AbstractModel):
    r"""ExportInstanceErrorLogs response structure.

    """

    def __init__(self):
        r"""
        :param _ErrorLogItems: Exported error log content.
        :type ErrorLogItems: list of ErrorLogItemExport
        :param _FileContent: Error log string.
        :type FileContent: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrorLogItems = None
        self._FileContent = None
        self._RequestId = None

    @property
    def ErrorLogItems(self):
        r"""Exported error log content.
        :rtype: list of ErrorLogItemExport
        """
        return self._ErrorLogItems

    @ErrorLogItems.setter
    def ErrorLogItems(self, ErrorLogItems):
        self._ErrorLogItems = ErrorLogItems

    @property
    def FileContent(self):
        r"""Error log string.
        :rtype: str
        """
        return self._FileContent

    @FileContent.setter
    def FileContent(self, FileContent):
        self._FileContent = FileContent

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ErrorLogItems") is not None:
            self._ErrorLogItems = []
            for item in params.get("ErrorLogItems"):
                obj = ErrorLogItemExport()
                obj._deserialize(item)
                self._ErrorLogItems.append(obj)
        self._FileContent = params.get("FileContent")
        self._RequestId = params.get("RequestId")


class ExportInstanceSlowQueriesRequest(AbstractModel):
    r"""ExportInstanceSlowQueries request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _StartTime: Transaction start time
        :type StartTime: str
        :param _EndTime: Transaction end time
        :type EndTime: str
        :param _Limit: Maximum number
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        :param _Username: Username
        :type Username: str
        :param _Host: Client host
        :type Host: str
        :param _Database: Database name
        :type Database: str
        :param _FileType: File type. Valid values: csv, original.
        :type FileType: str
        :param _OrderBy: Sorting field. Valid values: `QueryTime`, `LockTime`, `RowsExamined`, and `RowsSent`.
        :type OrderBy: str
        :param _OrderByType: Sorting order. Valid values: `asc`, `desc`.
        :type OrderByType: str
        """
        self._InstanceId = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._Username = None
        self._Host = None
        self._Database = None
        self._FileType = None
        self._OrderBy = None
        self._OrderByType = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartTime(self):
        r"""Transaction start time
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Transaction end time
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""Maximum number
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Username(self):
        r"""Username
        :rtype: str
        """
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Host(self):
        r"""Client host
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Database(self):
        r"""Database name
        :rtype: str
        """
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def FileType(self):
        r"""File type. Valid values: csv, original.
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def OrderBy(self):
        r"""Sorting field. Valid values: `QueryTime`, `LockTime`, `RowsExamined`, and `RowsSent`.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting order. Valid values: `asc`, `desc`.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Username = params.get("Username")
        self._Host = params.get("Host")
        self._Database = params.get("Database")
        self._FileType = params.get("FileType")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportInstanceSlowQueriesResponse(AbstractModel):
    r"""ExportInstanceSlowQueries response structure.

    """

    def __init__(self):
        r"""
        :param _FileContent: Slow query export content
        :type FileContent: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FileContent = None
        self._RequestId = None

    @property
    def FileContent(self):
        r"""Slow query export content
        :rtype: str
        """
        return self._FileContent

    @FileContent.setter
    def FileContent(self, FileContent):
        self._FileContent = FileContent

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileContent = params.get("FileContent")
        self._RequestId = params.get("RequestId")


class ExportResourcePackageDeductDetailsRequest(AbstractModel):
    r"""ExportResourcePackageDeductDetails request structure.

    """

    def __init__(self):
        r"""
        :param _PackageId: Resource package ID to be exported.
        :type PackageId: str
        :param _ClusterIds: Specifies the cluster ID of the cynos cluster that uses the resource package capacity.
        :type ClusterIds: list of str
        :param _OrderBy: Sorting field. currently supports: createTime (resource package deduction time), successDeductSpec (resource package deduction amount).
        :type OrderBy: str
        :param _OrderByType: Sorting type. supports ASC, DESC, ASC, DESC.
        :type OrderByType: str
        :param _StartTime: Start time.
        :type StartTime: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _Limit: A maximum of 2000 rows of data can be exported at a time. currently, a maximum of 2000 rows are supported.
        :type Limit: str
        :param _Offset: Offset and page number.
        :type Offset: str
        :param _FileType: Specifies the format for exporting data. currently only supports csv format, reserved for future expansion.
        :type FileType: str
        """
        self._PackageId = None
        self._ClusterIds = None
        self._OrderBy = None
        self._OrderByType = None
        self._StartTime = None
        self._EndTime = None
        self._Limit = None
        self._Offset = None
        self._FileType = None

    @property
    def PackageId(self):
        r"""Resource package ID to be exported.
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def ClusterIds(self):
        r"""Specifies the cluster ID of the cynos cluster that uses the resource package capacity.
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def OrderBy(self):
        r"""Sorting field. currently supports: createTime (resource package deduction time), successDeductSpec (resource package deduction amount).
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def OrderByType(self):
        r"""Sorting type. supports ASC, DESC, ASC, DESC.
        :rtype: str
        """
        return self._OrderByType

    @OrderByType.setter
    def OrderByType(self, OrderByType):
        self._OrderByType = OrderByType

    @property
    def StartTime(self):
        r"""Start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Limit(self):
        r"""A maximum of 2000 rows of data can be exported at a time. currently, a maximum of 2000 rows are supported.
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""Offset and page number.
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def FileType(self):
        r"""Specifies the format for exporting data. currently only supports csv format, reserved for future expansion.
        :rtype: str
        """
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._ClusterIds = params.get("ClusterIds")
        self._OrderBy = params.get("OrderBy")
        self._OrderByType = params.get("OrderByType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportResourcePackageDeductDetailsResponse(AbstractModel):
    r"""ExportResourcePackageDeductDetails response structure.

    """

    def __init__(self):
        r"""
        :param _FileContent: File detail.
        :type FileContent: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FileContent = None
        self._RequestId = None

    @property
    def FileContent(self):
        r"""File detail.
        :rtype: str
        """
        return self._FileContent

    @FileContent.setter
    def FileContent(self, FileContent):
        self._FileContent = FileContent

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileContent = params.get("FileContent")
        self._RequestId = params.get("RequestId")


class GoodsPrice(AbstractModel):
    r"""Item price.

    """

    def __init__(self):
        r"""
        :param _InstancePrice: Specifies the instance price.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstancePrice: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        :param _StoragePrice: Specifies the storage price.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StoragePrice: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        :param _GoodsSpec: Specifies the product specification.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GoodsSpec: :class:`tencentcloud.cynosdb.v20190107.models.GoodsSpec`
        """
        self._InstancePrice = None
        self._StoragePrice = None
        self._GoodsSpec = None

    @property
    def InstancePrice(self):
        r"""Specifies the instance price.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        """
        return self._InstancePrice

    @InstancePrice.setter
    def InstancePrice(self, InstancePrice):
        self._InstancePrice = InstancePrice

    @property
    def StoragePrice(self):
        r"""Specifies the storage price.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        """
        return self._StoragePrice

    @StoragePrice.setter
    def StoragePrice(self, StoragePrice):
        self._StoragePrice = StoragePrice

    @property
    def GoodsSpec(self):
        r"""Specifies the product specification.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.GoodsSpec`
        """
        return self._GoodsSpec

    @GoodsSpec.setter
    def GoodsSpec(self, GoodsSpec):
        self._GoodsSpec = GoodsSpec


    def _deserialize(self, params):
        if params.get("InstancePrice") is not None:
            self._InstancePrice = TradePrice()
            self._InstancePrice._deserialize(params.get("InstancePrice"))
        if params.get("StoragePrice") is not None:
            self._StoragePrice = TradePrice()
            self._StoragePrice._deserialize(params.get("StoragePrice"))
        if params.get("GoodsSpec") is not None:
            self._GoodsSpec = GoodsSpec()
            self._GoodsSpec._deserialize(params.get("GoodsSpec"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GoodsSpec(AbstractModel):
    r"""Product specification.

    """

    def __init__(self):
        r"""
        :param _GoodsNum: Number of products
Note: This field may return null, indicating that no valid values can be obtained.
        :type GoodsNum: int
        :param _Cpu: Number of CPU cores. required for PREPAID and POSTPAID instance types.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Cpu: int
        :param _Memory: Memory size in gb. required for PREPAID and POSTPAID instance types.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Memory: int
        :param _Ccu: Ccu size. required for serverless type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Ccu: float
        :param _StorageLimit: Storage size. required for PREPAID storage type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StorageLimit: int
        :param _TimeSpan: Purchase duration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeSpan: int
        :param _TimeUnit: Duration unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeUnit: str
        :param _DeviceType: Machine type.
        :type DeviceType: str
        """
        self._GoodsNum = None
        self._Cpu = None
        self._Memory = None
        self._Ccu = None
        self._StorageLimit = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._DeviceType = None

    @property
    def GoodsNum(self):
        r"""Number of products
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def Cpu(self):
        r"""Number of CPU cores. required for PREPAID and POSTPAID instance types.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory size in gb. required for PREPAID and POSTPAID instance types.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Ccu(self):
        r"""Ccu size. required for serverless type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: float
        """
        return self._Ccu

    @Ccu.setter
    def Ccu(self, Ccu):
        self._Ccu = Ccu

    @property
    def StorageLimit(self):
        r"""Storage size. required for PREPAID storage type.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def TimeSpan(self):
        r"""Purchase duration.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Duration unit.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def DeviceType(self):
        r"""Machine type.
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType


    def _deserialize(self, params):
        self._GoodsNum = params.get("GoodsNum")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._Ccu = params.get("Ccu")
        self._StorageLimit = params.get("StorageLimit")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._DeviceType = params.get("DeviceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InputAccount(AbstractModel):
    r"""Account. Valid values: `accountName`, `host`.

    """

    def __init__(self):
        r"""
        :param _AccountName: Account
        :type AccountName: str
        :param _Host: Host. Default value: `%`
        :type Host: str
        """
        self._AccountName = None
        self._Host = None

    @property
    def AccountName(self):
        r"""Account
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def Host(self):
        r"""Host. Default value: `%`
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host


    def _deserialize(self, params):
        self._AccountName = params.get("AccountName")
        self._Host = params.get("Host")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceCreateRequest(AbstractModel):
    r"""InquirePriceCreate request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: AZ
        :type Zone: str
        :param _GoodsNum: Number of compute node to purchase
        :type GoodsNum: int
        :param _InstancePayMode: Instance type for purchase. Valid values: `PREPAID`, `POSTPAID`, `SERVERLESS`.
        :type InstancePayMode: str
        :param _StoragePayMode: Storage type for purchase. Valid values: `PREPAID`, `POSTPAID`.
        :type StoragePayMode: str
        :param _DeviceType: device type:common, exclusive
        :type DeviceType: str
        :param _Cpu: Number of CPU cores, which is required when `InstancePayMode` is `PREPAID` or `POSTPAID`.
        :type Cpu: int
        :param _Memory: Memory size in GB, which is required when `InstancePayMode` is `PREPAID` or `POSTPAID`.
        :type Memory: int
        :param _Ccu: CCU size, which is required when `InstancePayMode` is `SERVERLESS`.
        :type Ccu: float
        :param _StorageLimit: Storage size, which is required when `StoragePayMode` is `PREPAID`.
        :type StorageLimit: int
        :param _TimeSpan: Validity period, which is required when `InstancePayMode` is `PREPAID`.
        :type TimeSpan: int
        :param _TimeUnit: Duration unit, which is required when `InstancePayMode` is `PREPAID`. Valid values: `m` (month), `d` (day).
        :type TimeUnit: str
        """
        self._Zone = None
        self._GoodsNum = None
        self._InstancePayMode = None
        self._StoragePayMode = None
        self._DeviceType = None
        self._Cpu = None
        self._Memory = None
        self._Ccu = None
        self._StorageLimit = None
        self._TimeSpan = None
        self._TimeUnit = None

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def GoodsNum(self):
        r"""Number of compute node to purchase
        :rtype: int
        """
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def InstancePayMode(self):
        r"""Instance type for purchase. Valid values: `PREPAID`, `POSTPAID`, `SERVERLESS`.
        :rtype: str
        """
        return self._InstancePayMode

    @InstancePayMode.setter
    def InstancePayMode(self, InstancePayMode):
        self._InstancePayMode = InstancePayMode

    @property
    def StoragePayMode(self):
        r"""Storage type for purchase. Valid values: `PREPAID`, `POSTPAID`.
        :rtype: str
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def DeviceType(self):
        r"""device type:common, exclusive
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType

    @property
    def Cpu(self):
        r"""Number of CPU cores, which is required when `InstancePayMode` is `PREPAID` or `POSTPAID`.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory size in GB, which is required when `InstancePayMode` is `PREPAID` or `POSTPAID`.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Ccu(self):
        r"""CCU size, which is required when `InstancePayMode` is `SERVERLESS`.
        :rtype: float
        """
        return self._Ccu

    @Ccu.setter
    def Ccu(self, Ccu):
        self._Ccu = Ccu

    @property
    def StorageLimit(self):
        r"""Storage size, which is required when `StoragePayMode` is `PREPAID`.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def TimeSpan(self):
        r"""Validity period, which is required when `InstancePayMode` is `PREPAID`.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Duration unit, which is required when `InstancePayMode` is `PREPAID`. Valid values: `m` (month), `d` (day).
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._GoodsNum = params.get("GoodsNum")
        self._InstancePayMode = params.get("InstancePayMode")
        self._StoragePayMode = params.get("StoragePayMode")
        self._DeviceType = params.get("DeviceType")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._Ccu = params.get("Ccu")
        self._StorageLimit = params.get("StorageLimit")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceCreateResponse(AbstractModel):
    r"""InquirePriceCreate response structure.

    """

    def __init__(self):
        r"""
        :param _InstancePrice: Instance price
        :type InstancePrice: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        :param _StoragePrice: Storage price
        :type StoragePrice: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstancePrice = None
        self._StoragePrice = None
        self._RequestId = None

    @property
    def InstancePrice(self):
        r"""Instance price
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        """
        return self._InstancePrice

    @InstancePrice.setter
    def InstancePrice(self, InstancePrice):
        self._InstancePrice = InstancePrice

    @property
    def StoragePrice(self):
        r"""Storage price
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        """
        return self._StoragePrice

    @StoragePrice.setter
    def StoragePrice(self, StoragePrice):
        self._StoragePrice = StoragePrice

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstancePrice") is not None:
            self._InstancePrice = TradePrice()
            self._InstancePrice._deserialize(params.get("InstancePrice"))
        if params.get("StoragePrice") is not None:
            self._StoragePrice = TradePrice()
            self._StoragePrice._deserialize(params.get("StoragePrice"))
        self._RequestId = params.get("RequestId")


class InquirePriceModifyRequest(AbstractModel):
    r"""InquirePriceModify request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Cpu: Specifies the number of CPU cores.
        :type Cpu: int
        :param _Memory: Memory Size
        :type Memory: int
        :param _StorageLimit: Storage size, storage resource adjustment: ClusterId, StorageLimit.
        :type StorageLimit: int
        :param _InstanceId: Instance ID. computational resource adjustment requires passing: ClusterId, instance ID, Cpu, Memory.
        :type InstanceId: str
        :param _DeviceType: Instance device type.
        :type DeviceType: str
        :param _Ccu: Specifies the ccu size of the serverless instance.
        :type Ccu: float
        """
        self._ClusterId = None
        self._Cpu = None
        self._Memory = None
        self._StorageLimit = None
        self._InstanceId = None
        self._DeviceType = None
        self._Ccu = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Cpu(self):
        r"""Specifies the number of CPU cores.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Memory Size
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def StorageLimit(self):
        r"""Storage size, storage resource adjustment: ClusterId, StorageLimit.
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def InstanceId(self):
        r"""Instance ID. computational resource adjustment requires passing: ClusterId, instance ID, Cpu, Memory.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DeviceType(self):
        r"""Instance device type.
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType

    @property
    def Ccu(self):
        r"""Specifies the ccu size of the serverless instance.
        :rtype: float
        """
        return self._Ccu

    @Ccu.setter
    def Ccu(self, Ccu):
        self._Ccu = Ccu


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._StorageLimit = params.get("StorageLimit")
        self._InstanceId = params.get("InstanceId")
        self._DeviceType = params.get("DeviceType")
        self._Ccu = params.get("Ccu")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceModifyResponse(AbstractModel):
    r"""InquirePriceModify response structure.

    """

    def __init__(self):
        r"""
        :param _InstancePrice: Instance price.
        :type InstancePrice: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        :param _StoragePrice: Specifies the storage price.
        :type StoragePrice: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstancePrice = None
        self._StoragePrice = None
        self._RequestId = None

    @property
    def InstancePrice(self):
        r"""Instance price.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        """
        return self._InstancePrice

    @InstancePrice.setter
    def InstancePrice(self, InstancePrice):
        self._InstancePrice = InstancePrice

    @property
    def StoragePrice(self):
        r"""Specifies the storage price.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.TradePrice`
        """
        return self._StoragePrice

    @StoragePrice.setter
    def StoragePrice(self, StoragePrice):
        self._StoragePrice = StoragePrice

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstancePrice") is not None:
            self._InstancePrice = TradePrice()
            self._InstancePrice._deserialize(params.get("InstancePrice"))
        if params.get("StoragePrice") is not None:
            self._StoragePrice = TradePrice()
            self._StoragePrice._deserialize(params.get("StoragePrice"))
        self._RequestId = params.get("RequestId")


class InquirePriceMultiSpecRequest(AbstractModel):
    r"""InquirePriceMultiSpec request structure.

    """

    def __init__(self):
        r"""
        :param _Zone: Availability zone. specifies the best practice for region provision.
        :type Zone: str
        :param _InstancePayMode: Instance purchase type. available values are: PREPAID, POSTPAID, SERVERLESS.
        :type InstancePayMode: str
        :param _StoragePayMode: Storage purchase type. available values are: PREPAID, POSTPAID.
        :type StoragePayMode: str
        :param _GoodsSpecs: Specifies the product specification.
        :type GoodsSpecs: list of GoodsSpec
        """
        self._Zone = None
        self._InstancePayMode = None
        self._StoragePayMode = None
        self._GoodsSpecs = None

    @property
    def Zone(self):
        r"""Availability zone. specifies the best practice for region provision.
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def InstancePayMode(self):
        r"""Instance purchase type. available values are: PREPAID, POSTPAID, SERVERLESS.
        :rtype: str
        """
        return self._InstancePayMode

    @InstancePayMode.setter
    def InstancePayMode(self, InstancePayMode):
        self._InstancePayMode = InstancePayMode

    @property
    def StoragePayMode(self):
        r"""Storage purchase type. available values are: PREPAID, POSTPAID.
        :rtype: str
        """
        return self._StoragePayMode

    @StoragePayMode.setter
    def StoragePayMode(self, StoragePayMode):
        self._StoragePayMode = StoragePayMode

    @property
    def GoodsSpecs(self):
        r"""Specifies the product specification.
        :rtype: list of GoodsSpec
        """
        return self._GoodsSpecs

    @GoodsSpecs.setter
    def GoodsSpecs(self, GoodsSpecs):
        self._GoodsSpecs = GoodsSpecs


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._InstancePayMode = params.get("InstancePayMode")
        self._StoragePayMode = params.get("StoragePayMode")
        if params.get("GoodsSpecs") is not None:
            self._GoodsSpecs = []
            for item in params.get("GoodsSpecs"):
                obj = GoodsSpec()
                obj._deserialize(item)
                self._GoodsSpecs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceMultiSpecResponse(AbstractModel):
    r"""InquirePriceMultiSpec response structure.

    """

    def __init__(self):
        r"""
        :param _GoodsPrice: Specifies the product price.
        :type GoodsPrice: list of GoodsPrice
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GoodsPrice = None
        self._RequestId = None

    @property
    def GoodsPrice(self):
        r"""Specifies the product price.
        :rtype: list of GoodsPrice
        """
        return self._GoodsPrice

    @GoodsPrice.setter
    def GoodsPrice(self, GoodsPrice):
        self._GoodsPrice = GoodsPrice

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GoodsPrice") is not None:
            self._GoodsPrice = []
            for item in params.get("GoodsPrice"):
                obj = GoodsPrice()
                obj._deserialize(item)
                self._GoodsPrice.append(obj)
        self._RequestId = params.get("RequestId")


class InquirePriceRenewRequest(AbstractModel):
    r"""InquirePriceRenew request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _TimeSpan: Validity period, which needs to be used together with `TimeUnit`.
        :type TimeSpan: int
        :param _TimeUnit: Unit of validity period, which needs to be used together with `TimeSpan`. Valid values: `d` (day), `m` (month).
        :type TimeUnit: str
        """
        self._ClusterId = None
        self._TimeSpan = None
        self._TimeUnit = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def TimeSpan(self):
        r"""Validity period, which needs to be used together with `TimeUnit`.
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Unit of validity period, which needs to be used together with `TimeSpan`. Valid values: `d` (day), `m` (month).
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InquirePriceRenewResponse(AbstractModel):
    r"""InquirePriceRenew response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIds: Instance ID list
        :type InstanceIds: list of str
        :param _Prices: Price of instance specification in array
        :type Prices: list of TradePrice
        :param _InstanceRealTotalPrice: Total renewal price of compute node
        :type InstanceRealTotalPrice: int
        :param _StorageRealTotalPrice: Total renewal price of storage node
        :type StorageRealTotalPrice: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._Prices = None
        self._InstanceRealTotalPrice = None
        self._StorageRealTotalPrice = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""Instance ID list
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def Prices(self):
        r"""Price of instance specification in array
        :rtype: list of TradePrice
        """
        return self._Prices

    @Prices.setter
    def Prices(self, Prices):
        self._Prices = Prices

    @property
    def InstanceRealTotalPrice(self):
        r"""Total renewal price of compute node
        :rtype: int
        """
        return self._InstanceRealTotalPrice

    @InstanceRealTotalPrice.setter
    def InstanceRealTotalPrice(self, InstanceRealTotalPrice):
        self._InstanceRealTotalPrice = InstanceRealTotalPrice

    @property
    def StorageRealTotalPrice(self):
        r"""Total renewal price of storage node
        :rtype: int
        """
        return self._StorageRealTotalPrice

    @StorageRealTotalPrice.setter
    def StorageRealTotalPrice(self, StorageRealTotalPrice):
        self._StorageRealTotalPrice = StorageRealTotalPrice

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        if params.get("Prices") is not None:
            self._Prices = []
            for item in params.get("Prices"):
                obj = TradePrice()
                obj._deserialize(item)
                self._Prices.append(obj)
        self._InstanceRealTotalPrice = params.get("InstanceRealTotalPrice")
        self._StorageRealTotalPrice = params.get("StorageRealTotalPrice")
        self._RequestId = params.get("RequestId")


class InstanceAbility(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _IsSupportForceRestart: Specifies whether the instance supports forced reboot. valid values: yes (supported), no (unsupported).
        :type IsSupportForceRestart: str
        :param _NonsupportForceRestartReason: Specifies the causes for not supporting forced reboot.
        :type NonsupportForceRestartReason: str
        """
        self._IsSupportForceRestart = None
        self._NonsupportForceRestartReason = None

    @property
    def IsSupportForceRestart(self):
        r"""Specifies whether the instance supports forced reboot. valid values: yes (supported), no (unsupported).
        :rtype: str
        """
        return self._IsSupportForceRestart

    @IsSupportForceRestart.setter
    def IsSupportForceRestart(self, IsSupportForceRestart):
        self._IsSupportForceRestart = IsSupportForceRestart

    @property
    def NonsupportForceRestartReason(self):
        r"""Specifies the causes for not supporting forced reboot.
        :rtype: str
        """
        return self._NonsupportForceRestartReason

    @NonsupportForceRestartReason.setter
    def NonsupportForceRestartReason(self, NonsupportForceRestartReason):
        self._NonsupportForceRestartReason = NonsupportForceRestartReason


    def _deserialize(self, params):
        self._IsSupportForceRestart = params.get("IsSupportForceRestart")
        self._NonsupportForceRestartReason = params.get("NonsupportForceRestartReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceAuditRule(AbstractModel):
    r"""Audit rule details of the instance, which is an output parameter of the `DescribeAuditRuleWithInstanceIds` API.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _AuditRule: Specifies whether it is a rule-based audit. true - rule-based audit; false - comprehensive audit.
        :type AuditRule: bool
        :param _AuditRuleFilters: Specifies the audit rule details. valid when AuditRule=true.
        :type AuditRuleFilters: list of AuditRuleFilters
        :param _OldRule: Whether it is an audit policy.
        :type OldRule: bool
        :param _RuleTemplates: The rule template details of the instance application.
        :type RuleTemplates: list of RuleTemplateInfo
        """
        self._InstanceId = None
        self._AuditRule = None
        self._AuditRuleFilters = None
        self._OldRule = None
        self._RuleTemplates = None

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AuditRule(self):
        r"""Specifies whether it is a rule-based audit. true - rule-based audit; false - comprehensive audit.
        :rtype: bool
        """
        return self._AuditRule

    @AuditRule.setter
    def AuditRule(self, AuditRule):
        self._AuditRule = AuditRule

    @property
    def AuditRuleFilters(self):
        r"""Specifies the audit rule details. valid when AuditRule=true.
        :rtype: list of AuditRuleFilters
        """
        return self._AuditRuleFilters

    @AuditRuleFilters.setter
    def AuditRuleFilters(self, AuditRuleFilters):
        self._AuditRuleFilters = AuditRuleFilters

    @property
    def OldRule(self):
        r"""Whether it is an audit policy.
        :rtype: bool
        """
        return self._OldRule

    @OldRule.setter
    def OldRule(self, OldRule):
        self._OldRule = OldRule

    @property
    def RuleTemplates(self):
        r"""The rule template details of the instance application.
        :rtype: list of RuleTemplateInfo
        """
        return self._RuleTemplates

    @RuleTemplates.setter
    def RuleTemplates(self, RuleTemplates):
        self._RuleTemplates = RuleTemplates


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AuditRule = params.get("AuditRule")
        if params.get("AuditRuleFilters") is not None:
            self._AuditRuleFilters = []
            for item in params.get("AuditRuleFilters"):
                obj = AuditRuleFilters()
                obj._deserialize(item)
                self._AuditRuleFilters.append(obj)
        self._OldRule = params.get("OldRule")
        if params.get("RuleTemplates") is not None:
            self._RuleTemplates = []
            for item in params.get("RuleTemplates"):
                obj = RuleTemplateInfo()
                obj._deserialize(item)
                self._RuleTemplates.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceAuditStatus(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _InstanceId: 
        :type InstanceId: str
        :param _AuditStatus: 
        :type AuditStatus: str
        :param _LogExpireDay: Specifies the log retention period.
        :type LogExpireDay: int
        :param _HighLogExpireDay: High-Frequency storage duration.
        :type HighLogExpireDay: int
        :param _LowLogExpireDay: Specifies the duration of low-frequency storage.
        :type LowLogExpireDay: int
        :param _BillingAmount: Specifies the log storage volume.
        :type BillingAmount: float
        :param _HighRealStorage: Specifies the high-frequency storage volume.
        :type HighRealStorage: float
        :param _LowRealStorage: Specifies the infrequent access storage size.
        :type LowRealStorage: float
        :param _AuditAll: Specifies whether it is a full audit. true - indicates a full audit.
        :type AuditAll: bool
        :param _CreateAt: Specifies the audit activation time.
        :type CreateAt: str
        :param _InstanceInfo: Instance-Related information.
        :type InstanceInfo: :class:`tencentcloud.cynosdb.v20190107.models.AuditInstanceInfo`
        :param _RealStorage: Specifies the total storage capacity.
        :type RealStorage: float
        :param _RuleTemplateIds: The rule template applied to the instance.
        :type RuleTemplateIds: list of str
        :param _Deliver: Specifies whether to enable log delivery: ON, OFF.
        :type Deliver: str
        :param _DeliverSummary: Log shipping type.
        :type DeliverSummary: list of DeliverSummary
        """
        self._InstanceId = None
        self._AuditStatus = None
        self._LogExpireDay = None
        self._HighLogExpireDay = None
        self._LowLogExpireDay = None
        self._BillingAmount = None
        self._HighRealStorage = None
        self._LowRealStorage = None
        self._AuditAll = None
        self._CreateAt = None
        self._InstanceInfo = None
        self._RealStorage = None
        self._RuleTemplateIds = None
        self._Deliver = None
        self._DeliverSummary = None

    @property
    def InstanceId(self):
        r"""
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AuditStatus(self):
        r"""
        :rtype: str
        """
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def LogExpireDay(self):
        r"""Specifies the log retention period.
        :rtype: int
        """
        return self._LogExpireDay

    @LogExpireDay.setter
    def LogExpireDay(self, LogExpireDay):
        self._LogExpireDay = LogExpireDay

    @property
    def HighLogExpireDay(self):
        r"""High-Frequency storage duration.
        :rtype: int
        """
        return self._HighLogExpireDay

    @HighLogExpireDay.setter
    def HighLogExpireDay(self, HighLogExpireDay):
        self._HighLogExpireDay = HighLogExpireDay

    @property
    def LowLogExpireDay(self):
        r"""Specifies the duration of low-frequency storage.
        :rtype: int
        """
        return self._LowLogExpireDay

    @LowLogExpireDay.setter
    def LowLogExpireDay(self, LowLogExpireDay):
        self._LowLogExpireDay = LowLogExpireDay

    @property
    def BillingAmount(self):
        r"""Specifies the log storage volume.
        :rtype: float
        """
        return self._BillingAmount

    @BillingAmount.setter
    def BillingAmount(self, BillingAmount):
        self._BillingAmount = BillingAmount

    @property
    def HighRealStorage(self):
        r"""Specifies the high-frequency storage volume.
        :rtype: float
        """
        return self._HighRealStorage

    @HighRealStorage.setter
    def HighRealStorage(self, HighRealStorage):
        self._HighRealStorage = HighRealStorage

    @property
    def LowRealStorage(self):
        r"""Specifies the infrequent access storage size.
        :rtype: float
        """
        return self._LowRealStorage

    @LowRealStorage.setter
    def LowRealStorage(self, LowRealStorage):
        self._LowRealStorage = LowRealStorage

    @property
    def AuditAll(self):
        r"""Specifies whether it is a full audit. true - indicates a full audit.
        :rtype: bool
        """
        return self._AuditAll

    @AuditAll.setter
    def AuditAll(self, AuditAll):
        self._AuditAll = AuditAll

    @property
    def CreateAt(self):
        r"""Specifies the audit activation time.
        :rtype: str
        """
        return self._CreateAt

    @CreateAt.setter
    def CreateAt(self, CreateAt):
        self._CreateAt = CreateAt

    @property
    def InstanceInfo(self):
        r"""Instance-Related information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.AuditInstanceInfo`
        """
        return self._InstanceInfo

    @InstanceInfo.setter
    def InstanceInfo(self, InstanceInfo):
        self._InstanceInfo = InstanceInfo

    @property
    def RealStorage(self):
        r"""Specifies the total storage capacity.
        :rtype: float
        """
        return self._RealStorage

    @RealStorage.setter
    def RealStorage(self, RealStorage):
        self._RealStorage = RealStorage

    @property
    def RuleTemplateIds(self):
        r"""The rule template applied to the instance.
        :rtype: list of str
        """
        return self._RuleTemplateIds

    @RuleTemplateIds.setter
    def RuleTemplateIds(self, RuleTemplateIds):
        self._RuleTemplateIds = RuleTemplateIds

    @property
    def Deliver(self):
        r"""Specifies whether to enable log delivery: ON, OFF.
        :rtype: str
        """
        return self._Deliver

    @Deliver.setter
    def Deliver(self, Deliver):
        self._Deliver = Deliver

    @property
    def DeliverSummary(self):
        r"""Log shipping type.
        :rtype: list of DeliverSummary
        """
        return self._DeliverSummary

    @DeliverSummary.setter
    def DeliverSummary(self, DeliverSummary):
        self._DeliverSummary = DeliverSummary


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AuditStatus = params.get("AuditStatus")
        self._LogExpireDay = params.get("LogExpireDay")
        self._HighLogExpireDay = params.get("HighLogExpireDay")
        self._LowLogExpireDay = params.get("LowLogExpireDay")
        self._BillingAmount = params.get("BillingAmount")
        self._HighRealStorage = params.get("HighRealStorage")
        self._LowRealStorage = params.get("LowRealStorage")
        self._AuditAll = params.get("AuditAll")
        self._CreateAt = params.get("CreateAt")
        if params.get("InstanceInfo") is not None:
            self._InstanceInfo = AuditInstanceInfo()
            self._InstanceInfo._deserialize(params.get("InstanceInfo"))
        self._RealStorage = params.get("RealStorage")
        self._RuleTemplateIds = params.get("RuleTemplateIds")
        self._Deliver = params.get("Deliver")
        if params.get("DeliverSummary") is not None:
            self._DeliverSummary = []
            for item in params.get("DeliverSummary"):
                obj = DeliverSummary()
                obj._deserialize(item)
                self._DeliverSummary.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceCLSDeliveryInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name


        :type InstanceName: str
        :param _TopicId: Log topic id.

        :type TopicId: str
        :param _TopicName: Log topic name
        :type TopicName: str
        :param _GroupId: Log set id.

        :type GroupId: str
        :param _GroupName: Log set name.


        :type GroupName: str
        :param _Region: Log delivery region.

        :type Region: str
        :param _Status: Delivery status: creating, running, offlining, offlined.

        :type Status: str
        :param _LogType: Log type.
        :type LogType: str
        """
        self._InstanceId = None
        self._InstanceName = None
        self._TopicId = None
        self._TopicName = None
        self._GroupId = None
        self._GroupName = None
        self._Region = None
        self._Status = None
        self._LogType = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name


        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def TopicId(self):
        r"""Log topic id.

        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        r"""Log topic name
        :rtype: str
        """
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def GroupId(self):
        r"""Log set id.

        :rtype: str
        """
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupName(self):
        r"""Log set name.


        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Region(self):
        r"""Log delivery region.

        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Status(self):
        r"""Delivery status: creating, running, offlining, offlined.

        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LogType(self):
        r"""Log type.
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._GroupId = params.get("GroupId")
        self._GroupName = params.get("GroupName")
        self._Region = params.get("Region")
        self._Status = params.get("Status")
        self._LogType = params.get("LogType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceInitInfo(AbstractModel):
    r"""Instance initialization configuration information

    """

    def __init__(self):
        r"""
        :param _Cpu: Instance CPU
        :type Cpu: int
        :param _Memory: Instance memory
        :type Memory: int
        :param _InstanceType: Instance type. Valid values:`rw`, `ro`.
        :type InstanceType: str
        :param _InstanceCount: Number of the instances. Value range: 1-15.
        :type InstanceCount: int
        :param _MinRoCount: Minimum number of serverless instances. Value range: 1-15.
        :type MinRoCount: int
        :param _MaxRoCount: Maximum number of serverless instances. Value range: 1-15.
        :type MaxRoCount: int
        :param _MinRoCpu: Minimum specifications for serverless instance
        :type MinRoCpu: float
        :param _MaxRoCpu: Maximum specifications for serverless instance
        :type MaxRoCpu: float
        """
        self._Cpu = None
        self._Memory = None
        self._InstanceType = None
        self._InstanceCount = None
        self._MinRoCount = None
        self._MaxRoCount = None
        self._MinRoCpu = None
        self._MaxRoCpu = None

    @property
    def Cpu(self):
        r"""Instance CPU
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Instance memory
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def InstanceType(self):
        r"""Instance type. Valid values:`rw`, `ro`.
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceCount(self):
        r"""Number of the instances. Value range: 1-15.
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def MinRoCount(self):
        r"""Minimum number of serverless instances. Value range: 1-15.
        :rtype: int
        """
        return self._MinRoCount

    @MinRoCount.setter
    def MinRoCount(self, MinRoCount):
        self._MinRoCount = MinRoCount

    @property
    def MaxRoCount(self):
        r"""Maximum number of serverless instances. Value range: 1-15.
        :rtype: int
        """
        return self._MaxRoCount

    @MaxRoCount.setter
    def MaxRoCount(self, MaxRoCount):
        self._MaxRoCount = MaxRoCount

    @property
    def MinRoCpu(self):
        r"""Minimum specifications for serverless instance
        :rtype: float
        """
        return self._MinRoCpu

    @MinRoCpu.setter
    def MinRoCpu(self, MinRoCpu):
        self._MinRoCpu = MinRoCpu

    @property
    def MaxRoCpu(self):
        r"""Maximum specifications for serverless instance
        :rtype: float
        """
        return self._MaxRoCpu

    @MaxRoCpu.setter
    def MaxRoCpu(self, MaxRoCpu):
        self._MaxRoCpu = MaxRoCpu


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._InstanceType = params.get("InstanceType")
        self._InstanceCount = params.get("InstanceCount")
        self._MinRoCount = params.get("MinRoCount")
        self._MaxRoCount = params.get("MaxRoCount")
        self._MinRoCpu = params.get("MinRoCpu")
        self._MaxRoCpu = params.get("MaxRoCpu")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceNameWeight(AbstractModel):
    r"""Instance weight.

    """

    def __init__(self):
        r"""
        :param _InstanceName: Instance name. specifies the name defined by InstanceInitInfo.InstanceName in cluster creation.
        :type InstanceName: str
        :param _Weight: Weight
        :type Weight: int
        """
        self._InstanceName = None
        self._Weight = None

    @property
    def InstanceName(self):
        r"""Instance name. specifies the name defined by InstanceInitInfo.InstanceName in cluster creation.
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Weight(self):
        r"""Weight
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._InstanceName = params.get("InstanceName")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceNetInfo(AbstractModel):
    r"""Instance network information

    """

    def __init__(self):
        r"""
        :param _InstanceGroupType: Network type.
        :type InstanceGroupType: str
        :param _InstanceGroupId: Instance group ID
        :type InstanceGroupId: str
        :param _VpcId: Specifies the virtual private cloud ID.
        :type VpcId: str
        :param _SubnetId: Specifies the subnet ID.
        :type SubnetId: str
        :param _NetType: Network type. valid values: 0 (basic network), 1 (vpc network), 2 (blackstone network).
        :type NetType: int
        :param _Vip: VPC IP.
        :type Vip: str
        :param _Vport: VPC port.
        :type Vport: int
        :param _WanDomain: Specifies the public network domain name.
        :type WanDomain: str
        :param _WanIP: Public IP address
        :type WanIP: str
        :param _WanPort: Public network port.
        :type WanPort: int
        :param _WanStatus: Public network enabled status.
        :type WanStatus: str
        """
        self._InstanceGroupType = None
        self._InstanceGroupId = None
        self._VpcId = None
        self._SubnetId = None
        self._NetType = None
        self._Vip = None
        self._Vport = None
        self._WanDomain = None
        self._WanIP = None
        self._WanPort = None
        self._WanStatus = None

    @property
    def InstanceGroupType(self):
        r"""Network type.
        :rtype: str
        """
        return self._InstanceGroupType

    @InstanceGroupType.setter
    def InstanceGroupType(self, InstanceGroupType):
        self._InstanceGroupType = InstanceGroupType

    @property
    def InstanceGroupId(self):
        r"""Instance group ID
        :rtype: str
        """
        return self._InstanceGroupId

    @InstanceGroupId.setter
    def InstanceGroupId(self, InstanceGroupId):
        self._InstanceGroupId = InstanceGroupId

    @property
    def VpcId(self):
        r"""Specifies the virtual private cloud ID.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Specifies the subnet ID.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetType(self):
        r"""Network type. valid values: 0 (basic network), 1 (vpc network), 2 (blackstone network).
        :rtype: int
        """
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def Vip(self):
        r"""VPC IP.
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""VPC port.
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def WanDomain(self):
        r"""Specifies the public network domain name.
        :rtype: str
        """
        return self._WanDomain

    @WanDomain.setter
    def WanDomain(self, WanDomain):
        self._WanDomain = WanDomain

    @property
    def WanIP(self):
        r"""Public IP address
        :rtype: str
        """
        return self._WanIP

    @WanIP.setter
    def WanIP(self, WanIP):
        self._WanIP = WanIP

    @property
    def WanPort(self):
        r"""Public network port.
        :rtype: int
        """
        return self._WanPort

    @WanPort.setter
    def WanPort(self, WanPort):
        self._WanPort = WanPort

    @property
    def WanStatus(self):
        r"""Public network enabled status.
        :rtype: str
        """
        return self._WanStatus

    @WanStatus.setter
    def WanStatus(self, WanStatus):
        self._WanStatus = WanStatus


    def _deserialize(self, params):
        self._InstanceGroupType = params.get("InstanceGroupType")
        self._InstanceGroupId = params.get("InstanceGroupId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetType = params.get("NetType")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._WanDomain = params.get("WanDomain")
        self._WanIP = params.get("WanIP")
        self._WanPort = params.get("WanPort")
        self._WanStatus = params.get("WanStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceParamItem(AbstractModel):
    r"""Instance parameter information

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _ParamsItems: List of instance parameters
        :type ParamsItems: list of ParamItemDetail
        """
        self._InstanceId = None
        self._ParamsItems = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ParamsItems(self):
        r"""List of instance parameters
        :rtype: list of ParamItemDetail
        """
        return self._ParamsItems

    @ParamsItems.setter
    def ParamsItems(self, ParamsItems):
        self._ParamsItems = ParamsItems


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("ParamsItems") is not None:
            self._ParamsItems = []
            for item in params.get("ParamsItems"):
                obj = ParamItemDetail()
                obj._deserialize(item)
                self._ParamsItems.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceSpec(AbstractModel):
    r"""Details of purchasable instance specifications. `Cpu` and `Memory` determine the instance specification during instance creation. The value range of the storage capacity is [MinStorageSize,MaxStorageSize]

    """

    def __init__(self):
        r"""
        :param _Cpu: Number of instance CPU cores
        :type Cpu: int
        :param _Memory: Instance memory in GB
        :type Memory: int
        :param _MaxStorageSize: Maximum instance storage capacity GB
        :type MaxStorageSize: int
        :param _MinStorageSize: Minimum instance storage capacity GB
        :type MinStorageSize: int
        :param _HasStock: Whether there is an inventory.
        :type HasStock: bool
        :param _MachineType: Machine type
        :type MachineType: str
        :param _MaxIops: Maximum IOPS
        :type MaxIops: int
        :param _MaxIoBandWidth: Maximum bandwidth
        :type MaxIoBandWidth: int
        :param _ZoneStockInfos: Regional inventory information.
        :type ZoneStockInfos: list of ZoneStockInfo
        :param _StockCount: Inventory quantity.
        :type StockCount: int
        """
        self._Cpu = None
        self._Memory = None
        self._MaxStorageSize = None
        self._MinStorageSize = None
        self._HasStock = None
        self._MachineType = None
        self._MaxIops = None
        self._MaxIoBandWidth = None
        self._ZoneStockInfos = None
        self._StockCount = None

    @property
    def Cpu(self):
        r"""Number of instance CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Instance memory in GB
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def MaxStorageSize(self):
        r"""Maximum instance storage capacity GB
        :rtype: int
        """
        return self._MaxStorageSize

    @MaxStorageSize.setter
    def MaxStorageSize(self, MaxStorageSize):
        self._MaxStorageSize = MaxStorageSize

    @property
    def MinStorageSize(self):
        r"""Minimum instance storage capacity GB
        :rtype: int
        """
        return self._MinStorageSize

    @MinStorageSize.setter
    def MinStorageSize(self, MinStorageSize):
        self._MinStorageSize = MinStorageSize

    @property
    def HasStock(self):
        r"""Whether there is an inventory.
        :rtype: bool
        """
        return self._HasStock

    @HasStock.setter
    def HasStock(self, HasStock):
        self._HasStock = HasStock

    @property
    def MachineType(self):
        r"""Machine type
        :rtype: str
        """
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MaxIops(self):
        r"""Maximum IOPS
        :rtype: int
        """
        return self._MaxIops

    @MaxIops.setter
    def MaxIops(self, MaxIops):
        self._MaxIops = MaxIops

    @property
    def MaxIoBandWidth(self):
        r"""Maximum bandwidth
        :rtype: int
        """
        return self._MaxIoBandWidth

    @MaxIoBandWidth.setter
    def MaxIoBandWidth(self, MaxIoBandWidth):
        self._MaxIoBandWidth = MaxIoBandWidth

    @property
    def ZoneStockInfos(self):
        r"""Regional inventory information.
        :rtype: list of ZoneStockInfo
        """
        return self._ZoneStockInfos

    @ZoneStockInfos.setter
    def ZoneStockInfos(self, ZoneStockInfos):
        self._ZoneStockInfos = ZoneStockInfos

    @property
    def StockCount(self):
        r"""Inventory quantity.
        :rtype: int
        """
        return self._StockCount

    @StockCount.setter
    def StockCount(self, StockCount):
        self._StockCount = StockCount


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._MaxStorageSize = params.get("MaxStorageSize")
        self._MinStorageSize = params.get("MinStorageSize")
        self._HasStock = params.get("HasStock")
        self._MachineType = params.get("MachineType")
        self._MaxIops = params.get("MaxIops")
        self._MaxIoBandWidth = params.get("MaxIoBandWidth")
        if params.get("ZoneStockInfos") is not None:
            self._ZoneStockInfos = []
            for item in params.get("ZoneStockInfos"):
                obj = ZoneStockInfo()
                obj._deserialize(item)
                self._ZoneStockInfos.append(obj)
        self._StockCount = params.get("StockCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrateCreateClusterConfig(AbstractModel):
    r"""Integrated cluster configuration.

    """

    def __init__(self):
        r"""
        :param _BinlogSaveDays: Retention days of binlog. value range: 7-1830.
        :type BinlogSaveDays: int
        :param _BackupSaveDays: Specifies the backup retention days. value range: 7-1830.
        :type BackupSaveDays: int
        :param _SemiSyncTimeout: Specifies the semi-sync timeout period. value range: [1000,4294967295].
        :type SemiSyncTimeout: int
        :param _ProxyEndPointConfigs: proxy connection address configuration message.
        :type ProxyEndPointConfigs: list of ProxyEndPointConfigInfo
        """
        self._BinlogSaveDays = None
        self._BackupSaveDays = None
        self._SemiSyncTimeout = None
        self._ProxyEndPointConfigs = None

    @property
    def BinlogSaveDays(self):
        r"""Retention days of binlog. value range: 7-1830.
        :rtype: int
        """
        return self._BinlogSaveDays

    @BinlogSaveDays.setter
    def BinlogSaveDays(self, BinlogSaveDays):
        self._BinlogSaveDays = BinlogSaveDays

    @property
    def BackupSaveDays(self):
        r"""Specifies the backup retention days. value range: 7-1830.
        :rtype: int
        """
        return self._BackupSaveDays

    @BackupSaveDays.setter
    def BackupSaveDays(self, BackupSaveDays):
        self._BackupSaveDays = BackupSaveDays

    @property
    def SemiSyncTimeout(self):
        r"""Specifies the semi-sync timeout period. value range: [1000,4294967295].
        :rtype: int
        """
        return self._SemiSyncTimeout

    @SemiSyncTimeout.setter
    def SemiSyncTimeout(self, SemiSyncTimeout):
        self._SemiSyncTimeout = SemiSyncTimeout

    @property
    def ProxyEndPointConfigs(self):
        r"""proxy connection address configuration message.
        :rtype: list of ProxyEndPointConfigInfo
        """
        return self._ProxyEndPointConfigs

    @ProxyEndPointConfigs.setter
    def ProxyEndPointConfigs(self, ProxyEndPointConfigs):
        self._ProxyEndPointConfigs = ProxyEndPointConfigs


    def _deserialize(self, params):
        self._BinlogSaveDays = params.get("BinlogSaveDays")
        self._BackupSaveDays = params.get("BackupSaveDays")
        self._SemiSyncTimeout = params.get("SemiSyncTimeout")
        if params.get("ProxyEndPointConfigs") is not None:
            self._ProxyEndPointConfigs = []
            for item in params.get("ProxyEndPointConfigs"):
                obj = ProxyEndPointConfigInfo()
                obj._deserialize(item)
                self._ProxyEndPointConfigs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IntegrateInstanceInfo(AbstractModel):
    r"""Initializes the configuration information of an instance.

    """

    def __init__(self):
        r"""
        :param _Cpu: Specifies the cpu of the instance.
        :type Cpu: int
        :param _Memory: Specifies the instance memory.
        :type Memory: int
        :param _InstanceType: Instance type (rw/ro).
        :type InstanceType: str
        :param _InstanceCount: Number of instances. value range: [1,15].
        :type InstanceCount: int
        :param _DeviceType: Instance machine type. valid values: universal type (common), exclusive type.
        :type DeviceType: str
        """
        self._Cpu = None
        self._Memory = None
        self._InstanceType = None
        self._InstanceCount = None
        self._DeviceType = None

    @property
    def Cpu(self):
        r"""Specifies the cpu of the instance.
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""Specifies the instance memory.
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def InstanceType(self):
        r"""Instance type (rw/ro).
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceCount(self):
        r"""Number of instances. value range: [1,15].
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def DeviceType(self):
        r"""Instance machine type. valid values: universal type (common), exclusive type.
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._InstanceType = params.get("InstanceType")
        self._InstanceCount = params.get("InstanceCount")
        self._DeviceType = params.get("DeviceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IsolateClusterRequest(AbstractModel):
    r"""IsolateCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _DbType: This parameter has been disused.
        :type DbType: str
        """
        self._ClusterId = None
        self._DbType = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DbType(self):
        r"""This parameter has been disused.
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DbType = params.get("DbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IsolateClusterResponse(AbstractModel):
    r"""IsolateCluster response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID (returned for pay-as-you-go or serverless resources. if necessary to sync task status, please use the DescribeFlow api).
        :type FlowId: int
        :param _DealNames: Refund order number (returned for prepaid resources. if necessary, synchronize the order status by using the billing product's DescribeDealsByCond to synchronize the order status).
Note: This field may return null, indicating that no valid values can be obtained.
        :type DealNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._DealNames = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID (returned for pay-as-you-go or serverless resources. if necessary to sync task status, please use the DescribeFlow api).
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def DealNames(self):
        r"""Refund order number (returned for prepaid resources. if necessary, synchronize the order status by using the billing product's DescribeDealsByCond to synchronize the order status).
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._DealNames = params.get("DealNames")
        self._RequestId = params.get("RequestId")


class IsolateInstanceRequest(AbstractModel):
    r"""IsolateInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIdList: Instance ID array
        :type InstanceIdList: list of str
        :param _DbType: This parameter has been disused.
        :type DbType: str
        """
        self._ClusterId = None
        self._InstanceIdList = None
        self._DbType = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIdList(self):
        r"""Instance ID array
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList

    @property
    def DbType(self):
        r"""This parameter has been disused.
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIdList = params.get("InstanceIdList")
        self._DbType = params.get("DbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IsolateInstanceResponse(AbstractModel):
    r"""IsolateInstance response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _DealNames: Order ID for isolated instance (prepaid instance)
Note: this field may return null, indicating that no valid values can be obtained.
        :type DealNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._DealNames = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def DealNames(self):
        r"""Order ID for isolated instance (prepaid instance)
Note: this field may return null, indicating that no valid values can be obtained.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._DealNames = params.get("DealNames")
        self._RequestId = params.get("RequestId")


class LogicBackupConfigInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _LogicBackupEnable: Whether automatic logical backup is enabled.
        :type LogicBackupEnable: str
        :param _LogicBackupTimeBeg: Specifies the automatic logic backup start time.
        :type LogicBackupTimeBeg: int
        :param _LogicBackupTimeEnd: Specifies the termination time of automatic logical backup.
        :type LogicBackupTimeEnd: int
        :param _LogicReserveDuration: Specifies the retention time for automatic logical backup.
        :type LogicReserveDuration: int
        :param _LogicCrossRegionsEnable: Whether cross-regional logical backup is enabled.
        :type LogicCrossRegionsEnable: str
        :param _LogicCrossRegions: 
        :type LogicCrossRegions: list of str
        """
        self._LogicBackupEnable = None
        self._LogicBackupTimeBeg = None
        self._LogicBackupTimeEnd = None
        self._LogicReserveDuration = None
        self._LogicCrossRegionsEnable = None
        self._LogicCrossRegions = None

    @property
    def LogicBackupEnable(self):
        r"""Whether automatic logical backup is enabled.
        :rtype: str
        """
        return self._LogicBackupEnable

    @LogicBackupEnable.setter
    def LogicBackupEnable(self, LogicBackupEnable):
        self._LogicBackupEnable = LogicBackupEnable

    @property
    def LogicBackupTimeBeg(self):
        r"""Specifies the automatic logic backup start time.
        :rtype: int
        """
        return self._LogicBackupTimeBeg

    @LogicBackupTimeBeg.setter
    def LogicBackupTimeBeg(self, LogicBackupTimeBeg):
        self._LogicBackupTimeBeg = LogicBackupTimeBeg

    @property
    def LogicBackupTimeEnd(self):
        r"""Specifies the termination time of automatic logical backup.
        :rtype: int
        """
        return self._LogicBackupTimeEnd

    @LogicBackupTimeEnd.setter
    def LogicBackupTimeEnd(self, LogicBackupTimeEnd):
        self._LogicBackupTimeEnd = LogicBackupTimeEnd

    @property
    def LogicReserveDuration(self):
        r"""Specifies the retention time for automatic logical backup.
        :rtype: int
        """
        return self._LogicReserveDuration

    @LogicReserveDuration.setter
    def LogicReserveDuration(self, LogicReserveDuration):
        self._LogicReserveDuration = LogicReserveDuration

    @property
    def LogicCrossRegionsEnable(self):
        r"""Whether cross-regional logical backup is enabled.
        :rtype: str
        """
        return self._LogicCrossRegionsEnable

    @LogicCrossRegionsEnable.setter
    def LogicCrossRegionsEnable(self, LogicCrossRegionsEnable):
        self._LogicCrossRegionsEnable = LogicCrossRegionsEnable

    @property
    def LogicCrossRegions(self):
        r"""
        :rtype: list of str
        """
        return self._LogicCrossRegions

    @LogicCrossRegions.setter
    def LogicCrossRegions(self, LogicCrossRegions):
        self._LogicCrossRegions = LogicCrossRegions


    def _deserialize(self, params):
        self._LogicBackupEnable = params.get("LogicBackupEnable")
        self._LogicBackupTimeBeg = params.get("LogicBackupTimeBeg")
        self._LogicBackupTimeEnd = params.get("LogicBackupTimeEnd")
        self._LogicReserveDuration = params.get("LogicReserveDuration")
        self._LogicCrossRegionsEnable = params.get("LogicCrossRegionsEnable")
        self._LogicCrossRegions = params.get("LogicCrossRegions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManualBackupData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _BackupType: 
        :type BackupType: str
        :param _BackupMethod: 
        :type BackupMethod: str
        :param _SnapshotTime: 
        :type SnapshotTime: str
        :param _CrossRegionBackupInfos: Detailed information of cross-region backup items.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CrossRegionBackupInfos: list of CrossRegionBackupItem
        """
        self._BackupType = None
        self._BackupMethod = None
        self._SnapshotTime = None
        self._CrossRegionBackupInfos = None

    @property
    def BackupType(self):
        r"""
        :rtype: str
        """
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def BackupMethod(self):
        r"""
        :rtype: str
        """
        return self._BackupMethod

    @BackupMethod.setter
    def BackupMethod(self, BackupMethod):
        self._BackupMethod = BackupMethod

    @property
    def SnapshotTime(self):
        r"""
        :rtype: str
        """
        return self._SnapshotTime

    @SnapshotTime.setter
    def SnapshotTime(self, SnapshotTime):
        self._SnapshotTime = SnapshotTime

    @property
    def CrossRegionBackupInfos(self):
        r"""Detailed information of cross-region backup items.
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of CrossRegionBackupItem
        """
        return self._CrossRegionBackupInfos

    @CrossRegionBackupInfos.setter
    def CrossRegionBackupInfos(self, CrossRegionBackupInfos):
        self._CrossRegionBackupInfos = CrossRegionBackupInfos


    def _deserialize(self, params):
        self._BackupType = params.get("BackupType")
        self._BackupMethod = params.get("BackupMethod")
        self._SnapshotTime = params.get("SnapshotTime")
        if params.get("CrossRegionBackupInfos") is not None:
            self._CrossRegionBackupInfos = []
            for item in params.get("CrossRegionBackupInfos"):
                obj = CrossRegionBackupItem()
                obj._deserialize(item)
                self._CrossRegionBackupInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifiableInfo(AbstractModel):
    r"""Details of whether the parameter can be modified

    """

    def __init__(self):
        r"""
        :param _IsModifiable: 
        :type IsModifiable: int
        """
        self._IsModifiable = None

    @property
    def IsModifiable(self):
        r"""
        :rtype: int
        """
        return self._IsModifiable

    @IsModifiable.setter
    def IsModifiable(self, IsModifiable):
        self._IsModifiable = IsModifiable


    def _deserialize(self, params):
        self._IsModifiable = params.get("IsModifiable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAccountDescriptionRequest(AbstractModel):
    r"""ModifyAccountDescription request structure.

    """

    def __init__(self):
        r"""
        :param _AccountName: Database account name
        :type AccountName: str
        :param _Description: Database account description
        :type Description: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Host: Host. Default value: `%`
        :type Host: str
        """
        self._AccountName = None
        self._Description = None
        self._ClusterId = None
        self._Host = None

    @property
    def AccountName(self):
        r"""Database account name
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def Description(self):
        r"""Database account description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Host(self):
        r"""Host. Default value: `%`
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host


    def _deserialize(self, params):
        self._AccountName = params.get("AccountName")
        self._Description = params.get("Description")
        self._ClusterId = params.get("ClusterId")
        self._Host = params.get("Host")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAccountDescriptionResponse(AbstractModel):
    r"""ModifyAccountDescription response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAccountHostRequest(AbstractModel):
    r"""ModifyAccountHost request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _NewHost: New host
        :type NewHost: str
        :param _Account: Account infomation
        :type Account: :class:`tencentcloud.cynosdb.v20190107.models.InputAccount`
        """
        self._ClusterId = None
        self._NewHost = None
        self._Account = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NewHost(self):
        r"""New host
        :rtype: str
        """
        return self._NewHost

    @NewHost.setter
    def NewHost(self, NewHost):
        self._NewHost = NewHost

    @property
    def Account(self):
        r"""Account infomation
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.InputAccount`
        """
        return self._Account

    @Account.setter
    def Account(self, Account):
        self._Account = Account


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NewHost = params.get("NewHost")
        if params.get("Account") is not None:
            self._Account = InputAccount()
            self._Account._deserialize(params.get("Account"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAccountHostResponse(AbstractModel):
    r"""ModifyAccountHost response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAccountPrivilegesRequest(AbstractModel):
    r"""ModifyAccountPrivileges request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Account: Account infomation
        :type Account: :class:`tencentcloud.cynosdb.v20190107.models.InputAccount`
        :param _GlobalPrivileges: Array of global permissions
        :type GlobalPrivileges: list of str
        :param _DatabasePrivileges: Array of database permissions
        :type DatabasePrivileges: list of DatabasePrivileges
        :param _TablePrivileges: Array of table permissions
        :type TablePrivileges: list of TablePrivileges
        """
        self._ClusterId = None
        self._Account = None
        self._GlobalPrivileges = None
        self._DatabasePrivileges = None
        self._TablePrivileges = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Account(self):
        r"""Account infomation
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.InputAccount`
        """
        return self._Account

    @Account.setter
    def Account(self, Account):
        self._Account = Account

    @property
    def GlobalPrivileges(self):
        r"""Array of global permissions
        :rtype: list of str
        """
        return self._GlobalPrivileges

    @GlobalPrivileges.setter
    def GlobalPrivileges(self, GlobalPrivileges):
        self._GlobalPrivileges = GlobalPrivileges

    @property
    def DatabasePrivileges(self):
        r"""Array of database permissions
        :rtype: list of DatabasePrivileges
        """
        return self._DatabasePrivileges

    @DatabasePrivileges.setter
    def DatabasePrivileges(self, DatabasePrivileges):
        self._DatabasePrivileges = DatabasePrivileges

    @property
    def TablePrivileges(self):
        r"""Array of table permissions
        :rtype: list of TablePrivileges
        """
        return self._TablePrivileges

    @TablePrivileges.setter
    def TablePrivileges(self, TablePrivileges):
        self._TablePrivileges = TablePrivileges


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("Account") is not None:
            self._Account = InputAccount()
            self._Account._deserialize(params.get("Account"))
        self._GlobalPrivileges = params.get("GlobalPrivileges")
        if params.get("DatabasePrivileges") is not None:
            self._DatabasePrivileges = []
            for item in params.get("DatabasePrivileges"):
                obj = DatabasePrivileges()
                obj._deserialize(item)
                self._DatabasePrivileges.append(obj)
        if params.get("TablePrivileges") is not None:
            self._TablePrivileges = []
            for item in params.get("TablePrivileges"):
                obj = TablePrivileges()
                obj._deserialize(item)
                self._TablePrivileges.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAccountPrivilegesResponse(AbstractModel):
    r"""ModifyAccountPrivileges response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAuditRuleTemplatesRequest(AbstractModel):
    r"""ModifyAuditRuleTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _RuleTemplateIds: Audit rule template ID
        :type RuleTemplateIds: list of str
        :param _RuleFilters: Audit rule after modification
        :type RuleFilters: list of RuleFilters
        :param _RuleTemplateName: New name of the rule template
        :type RuleTemplateName: str
        :param _Description: New description of the rule template
        :type Description: str
        """
        self._RuleTemplateIds = None
        self._RuleFilters = None
        self._RuleTemplateName = None
        self._Description = None

    @property
    def RuleTemplateIds(self):
        r"""Audit rule template ID
        :rtype: list of str
        """
        return self._RuleTemplateIds

    @RuleTemplateIds.setter
    def RuleTemplateIds(self, RuleTemplateIds):
        self._RuleTemplateIds = RuleTemplateIds

    @property
    def RuleFilters(self):
        r"""Audit rule after modification
        :rtype: list of RuleFilters
        """
        return self._RuleFilters

    @RuleFilters.setter
    def RuleFilters(self, RuleFilters):
        self._RuleFilters = RuleFilters

    @property
    def RuleTemplateName(self):
        r"""New name of the rule template
        :rtype: str
        """
        return self._RuleTemplateName

    @RuleTemplateName.setter
    def RuleTemplateName(self, RuleTemplateName):
        self._RuleTemplateName = RuleTemplateName

    @property
    def Description(self):
        r"""New description of the rule template
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._RuleTemplateIds = params.get("RuleTemplateIds")
        if params.get("RuleFilters") is not None:
            self._RuleFilters = []
            for item in params.get("RuleFilters"):
                obj = RuleFilters()
                obj._deserialize(item)
                self._RuleFilters.append(obj)
        self._RuleTemplateName = params.get("RuleTemplateName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAuditRuleTemplatesResponse(AbstractModel):
    r"""ModifyAuditRuleTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAuditServiceRequest(AbstractModel):
    r"""ModifyAuditService request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _LogExpireDay: Log retention period
        :type LogExpireDay: int
        :param _HighLogExpireDay: Frequent log retention period
        :type HighLogExpireDay: int
        :param _AuditAll: The parameter used to change the audit rule of the instance to full audit
        :type AuditAll: bool
        :param _AuditRuleFilters: Rule audit
        :type AuditRuleFilters: list of AuditRuleFilters
        :param _RuleTemplateIds: Rule template ID
        :type RuleTemplateIds: list of str
        """
        self._InstanceId = None
        self._LogExpireDay = None
        self._HighLogExpireDay = None
        self._AuditAll = None
        self._AuditRuleFilters = None
        self._RuleTemplateIds = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def LogExpireDay(self):
        r"""Log retention period
        :rtype: int
        """
        return self._LogExpireDay

    @LogExpireDay.setter
    def LogExpireDay(self, LogExpireDay):
        self._LogExpireDay = LogExpireDay

    @property
    def HighLogExpireDay(self):
        r"""Frequent log retention period
        :rtype: int
        """
        return self._HighLogExpireDay

    @HighLogExpireDay.setter
    def HighLogExpireDay(self, HighLogExpireDay):
        self._HighLogExpireDay = HighLogExpireDay

    @property
    def AuditAll(self):
        r"""The parameter used to change the audit rule of the instance to full audit
        :rtype: bool
        """
        return self._AuditAll

    @AuditAll.setter
    def AuditAll(self, AuditAll):
        self._AuditAll = AuditAll

    @property
    def AuditRuleFilters(self):
        r"""Rule audit
        :rtype: list of AuditRuleFilters
        """
        return self._AuditRuleFilters

    @AuditRuleFilters.setter
    def AuditRuleFilters(self, AuditRuleFilters):
        self._AuditRuleFilters = AuditRuleFilters

    @property
    def RuleTemplateIds(self):
        r"""Rule template ID
        :rtype: list of str
        """
        return self._RuleTemplateIds

    @RuleTemplateIds.setter
    def RuleTemplateIds(self, RuleTemplateIds):
        self._RuleTemplateIds = RuleTemplateIds


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._LogExpireDay = params.get("LogExpireDay")
        self._HighLogExpireDay = params.get("HighLogExpireDay")
        self._AuditAll = params.get("AuditAll")
        if params.get("AuditRuleFilters") is not None:
            self._AuditRuleFilters = []
            for item in params.get("AuditRuleFilters"):
                obj = AuditRuleFilters()
                obj._deserialize(item)
                self._AuditRuleFilters.append(obj)
        self._RuleTemplateIds = params.get("RuleTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAuditServiceResponse(AbstractModel):
    r"""ModifyAuditService response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBackupConfigRequest(AbstractModel):
    r"""ModifyBackupConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BackupTimeBeg: Full backup start time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively
        :type BackupTimeBeg: int
        :param _BackupTimeEnd: Full backup end time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively.
        :type BackupTimeEnd: int
        :param _ReserveDuration: Backup retention period in seconds. Backups will be cleared after this period elapses. 7 days is represented by 3600*24*7 = 604800. Maximum value: 158112000.
        :type ReserveDuration: int
        :param _BackupFreq: Backup frequency. It is an array of 7 elements corresponding to Monday through Sunday. full: full backup; increment: incremental backup. This parameter cannot be modified currently and doesn't need to be entered.
        :type BackupFreq: list of str
        :param _BackupType: Currently, this parameter does not support modification and is not required.
        :type BackupType: str
        :param _LogicBackupConfig: 
        :type LogicBackupConfig: :class:`tencentcloud.cynosdb.v20190107.models.LogicBackupConfigInfo`
        :param _DeleteAutoLogicBackup: 
        :type DeleteAutoLogicBackup: bool
        """
        self._ClusterId = None
        self._BackupTimeBeg = None
        self._BackupTimeEnd = None
        self._ReserveDuration = None
        self._BackupFreq = None
        self._BackupType = None
        self._LogicBackupConfig = None
        self._DeleteAutoLogicBackup = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BackupTimeBeg(self):
        r"""Full backup start time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively
        :rtype: int
        """
        return self._BackupTimeBeg

    @BackupTimeBeg.setter
    def BackupTimeBeg(self, BackupTimeBeg):
        self._BackupTimeBeg = BackupTimeBeg

    @property
    def BackupTimeEnd(self):
        r"""Full backup end time. Value range: [0-24*3600]. For example, 0:00 AM, 1:00 AM, and 2:00 AM are represented by 0, 3600, and 7200, respectively.
        :rtype: int
        """
        return self._BackupTimeEnd

    @BackupTimeEnd.setter
    def BackupTimeEnd(self, BackupTimeEnd):
        self._BackupTimeEnd = BackupTimeEnd

    @property
    def ReserveDuration(self):
        r"""Backup retention period in seconds. Backups will be cleared after this period elapses. 7 days is represented by 3600*24*7 = 604800. Maximum value: 158112000.
        :rtype: int
        """
        return self._ReserveDuration

    @ReserveDuration.setter
    def ReserveDuration(self, ReserveDuration):
        self._ReserveDuration = ReserveDuration

    @property
    def BackupFreq(self):
        r"""Backup frequency. It is an array of 7 elements corresponding to Monday through Sunday. full: full backup; increment: incremental backup. This parameter cannot be modified currently and doesn't need to be entered.
        :rtype: list of str
        """
        return self._BackupFreq

    @BackupFreq.setter
    def BackupFreq(self, BackupFreq):
        self._BackupFreq = BackupFreq

    @property
    def BackupType(self):
        r"""Currently, this parameter does not support modification and is not required.
        :rtype: str
        """
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def LogicBackupConfig(self):
        r"""
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.LogicBackupConfigInfo`
        """
        return self._LogicBackupConfig

    @LogicBackupConfig.setter
    def LogicBackupConfig(self, LogicBackupConfig):
        self._LogicBackupConfig = LogicBackupConfig

    @property
    def DeleteAutoLogicBackup(self):
        r"""
        :rtype: bool
        """
        return self._DeleteAutoLogicBackup

    @DeleteAutoLogicBackup.setter
    def DeleteAutoLogicBackup(self, DeleteAutoLogicBackup):
        self._DeleteAutoLogicBackup = DeleteAutoLogicBackup


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._BackupTimeBeg = params.get("BackupTimeBeg")
        self._BackupTimeEnd = params.get("BackupTimeEnd")
        self._ReserveDuration = params.get("ReserveDuration")
        self._BackupFreq = params.get("BackupFreq")
        self._BackupType = params.get("BackupType")
        if params.get("LogicBackupConfig") is not None:
            self._LogicBackupConfig = LogicBackupConfigInfo()
            self._LogicBackupConfig._deserialize(params.get("LogicBackupConfig"))
        self._DeleteAutoLogicBackup = params.get("DeleteAutoLogicBackup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBackupConfigResponse(AbstractModel):
    r"""ModifyBackupConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBackupDownloadRestrictionRequest(AbstractModel):
    r"""ModifyBackupDownloadRestriction request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIds: Cluster ID
        :type ClusterIds: list of str
        :param _LimitType: Download limit type. valid values: NoLimit (unlimited), LimitOnlyIntranet (limited to private network), Customize (custom).
        :type LimitType: str
        :param _VpcComparisonSymbol: This parameter only supports In, which indicates that the vpc specified by LimitVpc can be downloaded. the default is In.
        :type VpcComparisonSymbol: str
        :param _IpComparisonSymbol: Specified ips can download; specified ips are not allowed to download.
        :type IpComparisonSymbol: str
        :param _LimitVpcs: Limit the vpc settings for downloads.
        :type LimitVpcs: list of BackupLimitVpcItem
        :param _LimitIps: Specifies the ip settings for limiting downloads.
        :type LimitIps: list of str
        """
        self._ClusterIds = None
        self._LimitType = None
        self._VpcComparisonSymbol = None
        self._IpComparisonSymbol = None
        self._LimitVpcs = None
        self._LimitIps = None

    @property
    def ClusterIds(self):
        r"""Cluster ID
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def LimitType(self):
        r"""Download limit type. valid values: NoLimit (unlimited), LimitOnlyIntranet (limited to private network), Customize (custom).
        :rtype: str
        """
        return self._LimitType

    @LimitType.setter
    def LimitType(self, LimitType):
        self._LimitType = LimitType

    @property
    def VpcComparisonSymbol(self):
        r"""This parameter only supports In, which indicates that the vpc specified by LimitVpc can be downloaded. the default is In.
        :rtype: str
        """
        return self._VpcComparisonSymbol

    @VpcComparisonSymbol.setter
    def VpcComparisonSymbol(self, VpcComparisonSymbol):
        self._VpcComparisonSymbol = VpcComparisonSymbol

    @property
    def IpComparisonSymbol(self):
        r"""Specified ips can download; specified ips are not allowed to download.
        :rtype: str
        """
        return self._IpComparisonSymbol

    @IpComparisonSymbol.setter
    def IpComparisonSymbol(self, IpComparisonSymbol):
        self._IpComparisonSymbol = IpComparisonSymbol

    @property
    def LimitVpcs(self):
        r"""Limit the vpc settings for downloads.
        :rtype: list of BackupLimitVpcItem
        """
        return self._LimitVpcs

    @LimitVpcs.setter
    def LimitVpcs(self, LimitVpcs):
        self._LimitVpcs = LimitVpcs

    @property
    def LimitIps(self):
        r"""Specifies the ip settings for limiting downloads.
        :rtype: list of str
        """
        return self._LimitIps

    @LimitIps.setter
    def LimitIps(self, LimitIps):
        self._LimitIps = LimitIps


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._LimitType = params.get("LimitType")
        self._VpcComparisonSymbol = params.get("VpcComparisonSymbol")
        self._IpComparisonSymbol = params.get("IpComparisonSymbol")
        if params.get("LimitVpcs") is not None:
            self._LimitVpcs = []
            for item in params.get("LimitVpcs"):
                obj = BackupLimitVpcItem()
                obj._deserialize(item)
                self._LimitVpcs.append(obj)
        self._LimitIps = params.get("LimitIps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBackupDownloadRestrictionResponse(AbstractModel):
    r"""ModifyBackupDownloadRestriction response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBackupDownloadUserRestrictionRequest(AbstractModel):
    r"""ModifyBackupDownloadUserRestriction request structure.

    """

    def __init__(self):
        r"""
        :param _LimitType: Download limit type. valid values: NoLimit (unlimited), LimitOnlyIntranet (limited to private network), Customize (custom).
        :type LimitType: str
        :param _VpcComparisonSymbol: This parameter only supports In, which indicates that the vpc specified by LimitVpc can be downloaded. the default is In.
        :type VpcComparisonSymbol: str
        :param _IpComparisonSymbol: Specified ips can download; specified ips are not allowed to download.
        :type IpComparisonSymbol: str
        :param _LimitVpcs: Limit the vpc settings for downloads.
        :type LimitVpcs: list of BackupLimitVpcItem
        :param _LimitIps: Specifies the ip settings for limiting downloads.
        :type LimitIps: list of str
        """
        self._LimitType = None
        self._VpcComparisonSymbol = None
        self._IpComparisonSymbol = None
        self._LimitVpcs = None
        self._LimitIps = None

    @property
    def LimitType(self):
        r"""Download limit type. valid values: NoLimit (unlimited), LimitOnlyIntranet (limited to private network), Customize (custom).
        :rtype: str
        """
        return self._LimitType

    @LimitType.setter
    def LimitType(self, LimitType):
        self._LimitType = LimitType

    @property
    def VpcComparisonSymbol(self):
        r"""This parameter only supports In, which indicates that the vpc specified by LimitVpc can be downloaded. the default is In.
        :rtype: str
        """
        return self._VpcComparisonSymbol

    @VpcComparisonSymbol.setter
    def VpcComparisonSymbol(self, VpcComparisonSymbol):
        self._VpcComparisonSymbol = VpcComparisonSymbol

    @property
    def IpComparisonSymbol(self):
        r"""Specified ips can download; specified ips are not allowed to download.
        :rtype: str
        """
        return self._IpComparisonSymbol

    @IpComparisonSymbol.setter
    def IpComparisonSymbol(self, IpComparisonSymbol):
        self._IpComparisonSymbol = IpComparisonSymbol

    @property
    def LimitVpcs(self):
        r"""Limit the vpc settings for downloads.
        :rtype: list of BackupLimitVpcItem
        """
        return self._LimitVpcs

    @LimitVpcs.setter
    def LimitVpcs(self, LimitVpcs):
        self._LimitVpcs = LimitVpcs

    @property
    def LimitIps(self):
        r"""Specifies the ip settings for limiting downloads.
        :rtype: list of str
        """
        return self._LimitIps

    @LimitIps.setter
    def LimitIps(self, LimitIps):
        self._LimitIps = LimitIps


    def _deserialize(self, params):
        self._LimitType = params.get("LimitType")
        self._VpcComparisonSymbol = params.get("VpcComparisonSymbol")
        self._IpComparisonSymbol = params.get("IpComparisonSymbol")
        if params.get("LimitVpcs") is not None:
            self._LimitVpcs = []
            for item in params.get("LimitVpcs"):
                obj = BackupLimitVpcItem()
                obj._deserialize(item)
                self._LimitVpcs.append(obj)
        self._LimitIps = params.get("LimitIps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBackupDownloadUserRestrictionResponse(AbstractModel):
    r"""ModifyBackupDownloadUserRestriction response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBackupNameRequest(AbstractModel):
    r"""ModifyBackupName request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BackupId: Backup file ID
        :type BackupId: int
        :param _BackupName: Backup name, which can contain up to 60 characters.
        :type BackupName: str
        """
        self._ClusterId = None
        self._BackupId = None
        self._BackupName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BackupId(self):
        r"""Backup file ID
        :rtype: int
        """
        return self._BackupId

    @BackupId.setter
    def BackupId(self, BackupId):
        self._BackupId = BackupId

    @property
    def BackupName(self):
        r"""Backup name, which can contain up to 60 characters.
        :rtype: str
        """
        return self._BackupName

    @BackupName.setter
    def BackupName(self, BackupName):
        self._BackupName = BackupName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._BackupId = params.get("BackupId")
        self._BackupName = params.get("BackupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBackupNameResponse(AbstractModel):
    r"""ModifyBackupName response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBinlogConfigRequest(AbstractModel):
    r"""ModifyBinlogConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BinlogConfig: Specifies the Binlog configuration message.
        :type BinlogConfig: :class:`tencentcloud.cynosdb.v20190107.models.BinlogConfigInfo`
        """
        self._ClusterId = None
        self._BinlogConfig = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BinlogConfig(self):
        r"""Specifies the Binlog configuration message.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.BinlogConfigInfo`
        """
        return self._BinlogConfig

    @BinlogConfig.setter
    def BinlogConfig(self, BinlogConfig):
        self._BinlogConfig = BinlogConfig


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("BinlogConfig") is not None:
            self._BinlogConfig = BinlogConfigInfo()
            self._BinlogConfig._deserialize(params.get("BinlogConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBinlogConfigResponse(AbstractModel):
    r"""ModifyBinlogConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyBinlogSaveDaysRequest(AbstractModel):
    r"""ModifyBinlogSaveDays request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _BinlogSaveDays: Binlog retention period in days
        :type BinlogSaveDays: int
        """
        self._ClusterId = None
        self._BinlogSaveDays = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def BinlogSaveDays(self):
        r"""Binlog retention period in days
        :rtype: int
        """
        return self._BinlogSaveDays

    @BinlogSaveDays.setter
    def BinlogSaveDays(self, BinlogSaveDays):
        self._BinlogSaveDays = BinlogSaveDays


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._BinlogSaveDays = params.get("BinlogSaveDays")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBinlogSaveDaysResponse(AbstractModel):
    r"""ModifyBinlogSaveDays response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterDatabaseRequest(AbstractModel):
    r"""ModifyClusterDatabase request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _DbName: Database name
        :type DbName: str
        :param _NewUserHostPrivileges: Host permissions of the new authorized user
        :type NewUserHostPrivileges: list of UserHostPrivilege
        :param _Description: Remarks
        :type Description: str
        :param _OldUserHostPrivileges: Host permissions of previously authorized users
        :type OldUserHostPrivileges: list of UserHostPrivilege
        """
        self._ClusterId = None
        self._DbName = None
        self._NewUserHostPrivileges = None
        self._Description = None
        self._OldUserHostPrivileges = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DbName(self):
        r"""Database name
        :rtype: str
        """
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def NewUserHostPrivileges(self):
        r"""Host permissions of the new authorized user
        :rtype: list of UserHostPrivilege
        """
        return self._NewUserHostPrivileges

    @NewUserHostPrivileges.setter
    def NewUserHostPrivileges(self, NewUserHostPrivileges):
        self._NewUserHostPrivileges = NewUserHostPrivileges

    @property
    def Description(self):
        r"""Remarks
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OldUserHostPrivileges(self):
        r"""Host permissions of previously authorized users
        :rtype: list of UserHostPrivilege
        """
        return self._OldUserHostPrivileges

    @OldUserHostPrivileges.setter
    def OldUserHostPrivileges(self, OldUserHostPrivileges):
        self._OldUserHostPrivileges = OldUserHostPrivileges


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DbName = params.get("DbName")
        if params.get("NewUserHostPrivileges") is not None:
            self._NewUserHostPrivileges = []
            for item in params.get("NewUserHostPrivileges"):
                obj = UserHostPrivilege()
                obj._deserialize(item)
                self._NewUserHostPrivileges.append(obj)
        self._Description = params.get("Description")
        if params.get("OldUserHostPrivileges") is not None:
            self._OldUserHostPrivileges = []
            for item in params.get("OldUserHostPrivileges"):
                obj = UserHostPrivilege()
                obj._deserialize(item)
                self._OldUserHostPrivileges.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterDatabaseResponse(AbstractModel):
    r"""ModifyClusterDatabase response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterNameRequest(AbstractModel):
    r"""ModifyClusterName request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        """
        self._ClusterId = None
        self._ClusterName = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""Cluster name
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterNameResponse(AbstractModel):
    r"""ModifyClusterName response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterParamRequest(AbstractModel):
    r"""ModifyClusterParam request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ParamList: List of the parameters to be modified. Each element in the list is a combination of `ParamName`, `CurrentValue`, and `OldValue`. `ParamName` is the parameter name; `CurrentValue` is the current value; `OldValue` is the old value that doesn’t need to be verified.
        :type ParamList: list of ParamItem
        :param _IsInMaintainPeriod: Valid values: `yes` (execute during maintenance time), `no` (execute now)
        :type IsInMaintainPeriod: str
        """
        self._ClusterId = None
        self._ParamList = None
        self._IsInMaintainPeriod = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ParamList(self):
        r"""List of the parameters to be modified. Each element in the list is a combination of `ParamName`, `CurrentValue`, and `OldValue`. `ParamName` is the parameter name; `CurrentValue` is the current value; `OldValue` is the old value that doesn’t need to be verified.
        :rtype: list of ParamItem
        """
        return self._ParamList

    @ParamList.setter
    def ParamList(self, ParamList):
        self._ParamList = ParamList

    @property
    def IsInMaintainPeriod(self):
        r"""Valid values: `yes` (execute during maintenance time), `no` (execute now)
        :rtype: str
        """
        return self._IsInMaintainPeriod

    @IsInMaintainPeriod.setter
    def IsInMaintainPeriod(self, IsInMaintainPeriod):
        self._IsInMaintainPeriod = IsInMaintainPeriod


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("ParamList") is not None:
            self._ParamList = []
            for item in params.get("ParamList"):
                obj = ParamItem()
                obj._deserialize(item)
                self._ParamList.append(obj)
        self._IsInMaintainPeriod = params.get("IsInMaintainPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterParamResponse(AbstractModel):
    r"""ModifyClusterParam response structure.

    """

    def __init__(self):
        r"""
        :param _AsyncRequestId: Async request ID used to query the result
        :type AsyncRequestId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AsyncRequestId = None
        self._RequestId = None

    @property
    def AsyncRequestId(self):
        r"""Async request ID used to query the result
        :rtype: str
        """
        return self._AsyncRequestId

    @AsyncRequestId.setter
    def AsyncRequestId(self, AsyncRequestId):
        self._AsyncRequestId = AsyncRequestId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AsyncRequestId = params.get("AsyncRequestId")
        self._RequestId = params.get("RequestId")


class ModifyClusterPasswordComplexityRequest(AbstractModel):
    r"""ModifyClusterPasswordComplexity request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ValidatePasswordLength: Password length
        :type ValidatePasswordLength: int
        :param _ValidatePasswordMixedCaseCount: Number of letters
        :type ValidatePasswordMixedCaseCount: int
        :param _ValidatePasswordSpecialCharCount: Number of symbols
        :type ValidatePasswordSpecialCharCount: int
        :param _ValidatePasswordNumberCount: Number of digits
        :type ValidatePasswordNumberCount: int
        :param _ValidatePasswordPolicy: Password strength. Valid values: `MEDIUM`, `STRONG`.
        :type ValidatePasswordPolicy: str
        :param _ValidatePasswordDictionary: Data dictionary
        :type ValidatePasswordDictionary: list of str
        """
        self._ClusterId = None
        self._ValidatePasswordLength = None
        self._ValidatePasswordMixedCaseCount = None
        self._ValidatePasswordSpecialCharCount = None
        self._ValidatePasswordNumberCount = None
        self._ValidatePasswordPolicy = None
        self._ValidatePasswordDictionary = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ValidatePasswordLength(self):
        r"""Password length
        :rtype: int
        """
        return self._ValidatePasswordLength

    @ValidatePasswordLength.setter
    def ValidatePasswordLength(self, ValidatePasswordLength):
        self._ValidatePasswordLength = ValidatePasswordLength

    @property
    def ValidatePasswordMixedCaseCount(self):
        r"""Number of letters
        :rtype: int
        """
        return self._ValidatePasswordMixedCaseCount

    @ValidatePasswordMixedCaseCount.setter
    def ValidatePasswordMixedCaseCount(self, ValidatePasswordMixedCaseCount):
        self._ValidatePasswordMixedCaseCount = ValidatePasswordMixedCaseCount

    @property
    def ValidatePasswordSpecialCharCount(self):
        r"""Number of symbols
        :rtype: int
        """
        return self._ValidatePasswordSpecialCharCount

    @ValidatePasswordSpecialCharCount.setter
    def ValidatePasswordSpecialCharCount(self, ValidatePasswordSpecialCharCount):
        self._ValidatePasswordSpecialCharCount = ValidatePasswordSpecialCharCount

    @property
    def ValidatePasswordNumberCount(self):
        r"""Number of digits
        :rtype: int
        """
        return self._ValidatePasswordNumberCount

    @ValidatePasswordNumberCount.setter
    def ValidatePasswordNumberCount(self, ValidatePasswordNumberCount):
        self._ValidatePasswordNumberCount = ValidatePasswordNumberCount

    @property
    def ValidatePasswordPolicy(self):
        r"""Password strength. Valid values: `MEDIUM`, `STRONG`.
        :rtype: str
        """
        return self._ValidatePasswordPolicy

    @ValidatePasswordPolicy.setter
    def ValidatePasswordPolicy(self, ValidatePasswordPolicy):
        self._ValidatePasswordPolicy = ValidatePasswordPolicy

    @property
    def ValidatePasswordDictionary(self):
        r"""Data dictionary
        :rtype: list of str
        """
        return self._ValidatePasswordDictionary

    @ValidatePasswordDictionary.setter
    def ValidatePasswordDictionary(self, ValidatePasswordDictionary):
        self._ValidatePasswordDictionary = ValidatePasswordDictionary


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ValidatePasswordLength = params.get("ValidatePasswordLength")
        self._ValidatePasswordMixedCaseCount = params.get("ValidatePasswordMixedCaseCount")
        self._ValidatePasswordSpecialCharCount = params.get("ValidatePasswordSpecialCharCount")
        self._ValidatePasswordNumberCount = params.get("ValidatePasswordNumberCount")
        self._ValidatePasswordPolicy = params.get("ValidatePasswordPolicy")
        self._ValidatePasswordDictionary = params.get("ValidatePasswordDictionary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterPasswordComplexityResponse(AbstractModel):
    r"""ModifyClusterPasswordComplexity response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class ModifyClusterReadOnlyRequest(AbstractModel):
    r"""ModifyClusterReadOnly request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIds: List of cluster IDs
        :type ClusterIds: list of str
        :param _ReadOnlyOperation: Cluster read-only switch, valid values: ON, OFF.
        :type ReadOnlyOperation: str
        :param _IsInMaintainPeriod: Valid values: `yes` (modify in maintenance window), `no` (execute now by default).
        :type IsInMaintainPeriod: str
        """
        self._ClusterIds = None
        self._ReadOnlyOperation = None
        self._IsInMaintainPeriod = None

    @property
    def ClusterIds(self):
        r"""List of cluster IDs
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def ReadOnlyOperation(self):
        r"""Cluster read-only switch, valid values: ON, OFF.
        :rtype: str
        """
        return self._ReadOnlyOperation

    @ReadOnlyOperation.setter
    def ReadOnlyOperation(self, ReadOnlyOperation):
        self._ReadOnlyOperation = ReadOnlyOperation

    @property
    def IsInMaintainPeriod(self):
        r"""Valid values: `yes` (modify in maintenance window), `no` (execute now by default).
        :rtype: str
        """
        return self._IsInMaintainPeriod

    @IsInMaintainPeriod.setter
    def IsInMaintainPeriod(self, IsInMaintainPeriod):
        self._IsInMaintainPeriod = IsInMaintainPeriod


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._ReadOnlyOperation = params.get("ReadOnlyOperation")
        self._IsInMaintainPeriod = params.get("IsInMaintainPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterReadOnlyResponse(AbstractModel):
    r"""ModifyClusterReadOnly response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterTaskIds: List of cluster task ids.
        :type ClusterTaskIds: list of ClusterTaskId
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterTaskIds = None
        self._RequestId = None

    @property
    def ClusterTaskIds(self):
        r"""List of cluster task ids.
        :rtype: list of ClusterTaskId
        """
        return self._ClusterTaskIds

    @ClusterTaskIds.setter
    def ClusterTaskIds(self, ClusterTaskIds):
        self._ClusterTaskIds = ClusterTaskIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterTaskIds") is not None:
            self._ClusterTaskIds = []
            for item in params.get("ClusterTaskIds"):
                obj = ClusterTaskId()
                obj._deserialize(item)
                self._ClusterTaskIds.append(obj)
        self._RequestId = params.get("RequestId")


class ModifyClusterSlaveZoneRequest(AbstractModel):
    r"""ModifyClusterSlaveZone request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _OldSlaveZone: Old replica AZ
        :type OldSlaveZone: str
        :param _NewSlaveZone: New replica AZ
        :type NewSlaveZone: str
        :param _BinlogSyncWay: Specifies the binlog synchronization mode. the default value is async. valid values are sync, semisync, and async.
        :type BinlogSyncWay: str
        :param _SemiSyncTimeout: 
        :type SemiSyncTimeout: int
        """
        self._ClusterId = None
        self._OldSlaveZone = None
        self._NewSlaveZone = None
        self._BinlogSyncWay = None
        self._SemiSyncTimeout = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def OldSlaveZone(self):
        r"""Old replica AZ
        :rtype: str
        """
        return self._OldSlaveZone

    @OldSlaveZone.setter
    def OldSlaveZone(self, OldSlaveZone):
        self._OldSlaveZone = OldSlaveZone

    @property
    def NewSlaveZone(self):
        r"""New replica AZ
        :rtype: str
        """
        return self._NewSlaveZone

    @NewSlaveZone.setter
    def NewSlaveZone(self, NewSlaveZone):
        self._NewSlaveZone = NewSlaveZone

    @property
    def BinlogSyncWay(self):
        r"""Specifies the binlog synchronization mode. the default value is async. valid values are sync, semisync, and async.
        :rtype: str
        """
        return self._BinlogSyncWay

    @BinlogSyncWay.setter
    def BinlogSyncWay(self, BinlogSyncWay):
        self._BinlogSyncWay = BinlogSyncWay

    @property
    def SemiSyncTimeout(self):
        r"""
        :rtype: int
        """
        return self._SemiSyncTimeout

    @SemiSyncTimeout.setter
    def SemiSyncTimeout(self, SemiSyncTimeout):
        self._SemiSyncTimeout = SemiSyncTimeout


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._OldSlaveZone = params.get("OldSlaveZone")
        self._NewSlaveZone = params.get("NewSlaveZone")
        self._BinlogSyncWay = params.get("BinlogSyncWay")
        self._SemiSyncTimeout = params.get("SemiSyncTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterSlaveZoneResponse(AbstractModel):
    r"""ModifyClusterSlaveZone response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async FlowId
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async FlowId
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class ModifyDBInstanceSecurityGroupsRequest(AbstractModel):
    r"""ModifyDBInstanceSecurityGroups request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Network group id (starting with the cynosdbmysql-grp- prefix) or cluster id.
        :type InstanceId: str
        :param _SecurityGroupIds: List of IDs of security groups to be modified, which is an array of one or more security group IDs.
        :type SecurityGroupIds: list of str
        :param _Zone: AZ
        :type Zone: str
        """
        self._InstanceId = None
        self._SecurityGroupIds = None
        self._Zone = None

    @property
    def InstanceId(self):
        r"""Network group id (starting with the cynosdbmysql-grp- prefix) or cluster id.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SecurityGroupIds(self):
        r"""List of IDs of security groups to be modified, which is an array of one or more security group IDs.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDBInstanceSecurityGroupsResponse(AbstractModel):
    r"""ModifyDBInstanceSecurityGroups response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyDbVersionData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _OldVersion: 
        :type OldVersion: str
        :param _NewVersion: 
        :type NewVersion: str
        :param _UpgradeType: 
        :type UpgradeType: str
        """
        self._OldVersion = None
        self._NewVersion = None
        self._UpgradeType = None

    @property
    def OldVersion(self):
        r"""
        :rtype: str
        """
        return self._OldVersion

    @OldVersion.setter
    def OldVersion(self, OldVersion):
        self._OldVersion = OldVersion

    @property
    def NewVersion(self):
        r"""
        :rtype: str
        """
        return self._NewVersion

    @NewVersion.setter
    def NewVersion(self, NewVersion):
        self._NewVersion = NewVersion

    @property
    def UpgradeType(self):
        r"""
        :rtype: str
        """
        return self._UpgradeType

    @UpgradeType.setter
    def UpgradeType(self, UpgradeType):
        self._UpgradeType = UpgradeType


    def _deserialize(self, params):
        self._OldVersion = params.get("OldVersion")
        self._NewVersion = params.get("NewVersion")
        self._UpgradeType = params.get("UpgradeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _Cpu: 
        :type Cpu: int
        :param _Memory: 
        :type Memory: int
        :param _StorageLimit: 
        :type StorageLimit: int
        :param _OldCpu: 
        :type OldCpu: int
        :param _OldMemory: 
        :type OldMemory: int
        :param _OldStorageLimit: 
        :type OldStorageLimit: int
        :param _OldDeviceType: Instance machine type before scaling.
        :type OldDeviceType: str
        :param _DeviceType: Instance machine type after scaling.
        :type DeviceType: str
        :param _UpgradeType: 
        :type UpgradeType: str
        :param _LibraNodeCount: Specifies the quantity of libra nodes.
        :type LibraNodeCount: int
        :param _OldLibraNodeCount: Specifies the original quantity of libra nodes.
        :type OldLibraNodeCount: int
        """
        self._Cpu = None
        self._Memory = None
        self._StorageLimit = None
        self._OldCpu = None
        self._OldMemory = None
        self._OldStorageLimit = None
        self._OldDeviceType = None
        self._DeviceType = None
        self._UpgradeType = None
        self._LibraNodeCount = None
        self._OldLibraNodeCount = None

    @property
    def Cpu(self):
        r"""
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def StorageLimit(self):
        r"""
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def OldCpu(self):
        r"""
        :rtype: int
        """
        return self._OldCpu

    @OldCpu.setter
    def OldCpu(self, OldCpu):
        self._OldCpu = OldCpu

    @property
    def OldMemory(self):
        r"""
        :rtype: int
        """
        return self._OldMemory

    @OldMemory.setter
    def OldMemory(self, OldMemory):
        self._OldMemory = OldMemory

    @property
    def OldStorageLimit(self):
        r"""
        :rtype: int
        """
        return self._OldStorageLimit

    @OldStorageLimit.setter
    def OldStorageLimit(self, OldStorageLimit):
        self._OldStorageLimit = OldStorageLimit

    @property
    def OldDeviceType(self):
        r"""Instance machine type before scaling.
        :rtype: str
        """
        return self._OldDeviceType

    @OldDeviceType.setter
    def OldDeviceType(self, OldDeviceType):
        self._OldDeviceType = OldDeviceType

    @property
    def DeviceType(self):
        r"""Instance machine type after scaling.
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType

    @property
    def UpgradeType(self):
        r"""
        :rtype: str
        """
        return self._UpgradeType

    @UpgradeType.setter
    def UpgradeType(self, UpgradeType):
        self._UpgradeType = UpgradeType

    @property
    def LibraNodeCount(self):
        r"""Specifies the quantity of libra nodes.
        :rtype: int
        """
        return self._LibraNodeCount

    @LibraNodeCount.setter
    def LibraNodeCount(self, LibraNodeCount):
        self._LibraNodeCount = LibraNodeCount

    @property
    def OldLibraNodeCount(self):
        r"""Specifies the original quantity of libra nodes.
        :rtype: int
        """
        return self._OldLibraNodeCount

    @OldLibraNodeCount.setter
    def OldLibraNodeCount(self, OldLibraNodeCount):
        self._OldLibraNodeCount = OldLibraNodeCount


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._StorageLimit = params.get("StorageLimit")
        self._OldCpu = params.get("OldCpu")
        self._OldMemory = params.get("OldMemory")
        self._OldStorageLimit = params.get("OldStorageLimit")
        self._OldDeviceType = params.get("OldDeviceType")
        self._DeviceType = params.get("DeviceType")
        self._UpgradeType = params.get("UpgradeType")
        self._LibraNodeCount = params.get("LibraNodeCount")
        self._OldLibraNodeCount = params.get("OldLibraNodeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceNameRequest(AbstractModel):
    r"""ModifyInstanceName request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        """
        self._InstanceId = None
        self._InstanceName = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""Instance name
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceNameResponse(AbstractModel):
    r"""ModifyInstanceName response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceParamRequest(AbstractModel):
    r"""ModifyInstanceParam request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIds: Instance ID
        :type InstanceIds: list of str
        :param _ClusterParamList: List of cluster parameters
        :type ClusterParamList: list of ModifyParamItem
        :param _InstanceParamList: List of the instance parameters
        :type InstanceParamList: list of ModifyParamItem
        :param _IsInMaintainPeriod: Valid values: `yes` (modify in maintenance window),  `no`  (execute now by default).
        :type IsInMaintainPeriod: str
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._ClusterParamList = None
        self._InstanceParamList = None
        self._IsInMaintainPeriod = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""Instance ID
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def ClusterParamList(self):
        r"""List of cluster parameters
        :rtype: list of ModifyParamItem
        """
        return self._ClusterParamList

    @ClusterParamList.setter
    def ClusterParamList(self, ClusterParamList):
        self._ClusterParamList = ClusterParamList

    @property
    def InstanceParamList(self):
        r"""List of the instance parameters
        :rtype: list of ModifyParamItem
        """
        return self._InstanceParamList

    @InstanceParamList.setter
    def InstanceParamList(self, InstanceParamList):
        self._InstanceParamList = InstanceParamList

    @property
    def IsInMaintainPeriod(self):
        r"""Valid values: `yes` (modify in maintenance window),  `no`  (execute now by default).
        :rtype: str
        """
        return self._IsInMaintainPeriod

    @IsInMaintainPeriod.setter
    def IsInMaintainPeriod(self, IsInMaintainPeriod):
        self._IsInMaintainPeriod = IsInMaintainPeriod


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        if params.get("ClusterParamList") is not None:
            self._ClusterParamList = []
            for item in params.get("ClusterParamList"):
                obj = ModifyParamItem()
                obj._deserialize(item)
                self._ClusterParamList.append(obj)
        if params.get("InstanceParamList") is not None:
            self._InstanceParamList = []
            for item in params.get("InstanceParamList"):
                obj = ModifyParamItem()
                obj._deserialize(item)
                self._InstanceParamList.append(obj)
        self._IsInMaintainPeriod = params.get("IsInMaintainPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceParamResponse(AbstractModel):
    r"""ModifyInstanceParam response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class ModifyInstanceUpgradeLimitDaysRequest(AbstractModel):
    r"""ModifyInstanceUpgradeLimitDays request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _InstanceId: Instance ID.
        :type InstanceId: str
        :param _UpgradeLimitDays: Upgrade time limit.
        :type UpgradeLimitDays: int
        """
        self._ClusterId = None
        self._InstanceId = None
        self._UpgradeLimitDays = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceId(self):
        r"""Instance ID.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def UpgradeLimitDays(self):
        r"""Upgrade time limit.
        :rtype: int
        """
        return self._UpgradeLimitDays

    @UpgradeLimitDays.setter
    def UpgradeLimitDays(self, UpgradeLimitDays):
        self._UpgradeLimitDays = UpgradeLimitDays


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceId = params.get("InstanceId")
        self._UpgradeLimitDays = params.get("UpgradeLimitDays")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceUpgradeLimitDaysResponse(AbstractModel):
    r"""ModifyInstanceUpgradeLimitDays response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyMaintainPeriodConfigRequest(AbstractModel):
    r"""ModifyMaintainPeriodConfig request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _MaintainStartTime: Maintenance start time in seconds. For example, 03:00 AM is represented by 10800
        :type MaintainStartTime: int
        :param _MaintainDuration: Maintenance duration in seconds. For example, one hour is represented by 3600
        :type MaintainDuration: int
        :param _MaintainWeekDays: Maintenance days of the week. Valid values: [Mon, Tue, Wed, Thu, Fri, Sat, Sun].
        :type MaintainWeekDays: list of str
        """
        self._InstanceId = None
        self._MaintainStartTime = None
        self._MaintainDuration = None
        self._MaintainWeekDays = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def MaintainStartTime(self):
        r"""Maintenance start time in seconds. For example, 03:00 AM is represented by 10800
        :rtype: int
        """
        return self._MaintainStartTime

    @MaintainStartTime.setter
    def MaintainStartTime(self, MaintainStartTime):
        self._MaintainStartTime = MaintainStartTime

    @property
    def MaintainDuration(self):
        r"""Maintenance duration in seconds. For example, one hour is represented by 3600
        :rtype: int
        """
        return self._MaintainDuration

    @MaintainDuration.setter
    def MaintainDuration(self, MaintainDuration):
        self._MaintainDuration = MaintainDuration

    @property
    def MaintainWeekDays(self):
        r"""Maintenance days of the week. Valid values: [Mon, Tue, Wed, Thu, Fri, Sat, Sun].
        :rtype: list of str
        """
        return self._MaintainWeekDays

    @MaintainWeekDays.setter
    def MaintainWeekDays(self, MaintainWeekDays):
        self._MaintainWeekDays = MaintainWeekDays


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._MaintainStartTime = params.get("MaintainStartTime")
        self._MaintainDuration = params.get("MaintainDuration")
        self._MaintainWeekDays = params.get("MaintainWeekDays")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMaintainPeriodConfigResponse(AbstractModel):
    r"""ModifyMaintainPeriodConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyParamItem(AbstractModel):
    r"""Information of the modified instance parameter

    """

    def __init__(self):
        r"""
        :param _ParamName: Parameter name
        :type ParamName: str
        :param _CurrentValue: Current parameter value
        :type CurrentValue: str
        :param _OldValue: Old parameter value (useful only in output parameters).
        :type OldValue: str
        :param _Component: libra component type.
        :type Component: str
        """
        self._ParamName = None
        self._CurrentValue = None
        self._OldValue = None
        self._Component = None

    @property
    def ParamName(self):
        r"""Parameter name
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def CurrentValue(self):
        r"""Current parameter value
        :rtype: str
        """
        return self._CurrentValue

    @CurrentValue.setter
    def CurrentValue(self, CurrentValue):
        self._CurrentValue = CurrentValue

    @property
    def OldValue(self):
        r"""Old parameter value (useful only in output parameters).
        :rtype: str
        """
        return self._OldValue

    @OldValue.setter
    def OldValue(self, OldValue):
        self._OldValue = OldValue

    @property
    def Component(self):
        r"""libra component type.
        :rtype: str
        """
        return self._Component

    @Component.setter
    def Component(self, Component):
        self._Component = Component


    def _deserialize(self, params):
        self._ParamName = params.get("ParamName")
        self._CurrentValue = params.get("CurrentValue")
        self._OldValue = params.get("OldValue")
        self._Component = params.get("Component")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyParamTemplateRequest(AbstractModel):
    r"""ModifyParamTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _TemplateId: Template ID
        :type TemplateId: int
        :param _TemplateName: Template name
        :type TemplateName: str
        :param _TemplateDescription: Template description
        :type TemplateDescription: str
        :param _ParamList: Parameter list
        :type ParamList: list of ModifyParamItem
        """
        self._TemplateId = None
        self._TemplateName = None
        self._TemplateDescription = None
        self._ParamList = None

    @property
    def TemplateId(self):
        r"""Template ID
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        r"""Template name
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def TemplateDescription(self):
        r"""Template description
        :rtype: str
        """
        return self._TemplateDescription

    @TemplateDescription.setter
    def TemplateDescription(self, TemplateDescription):
        self._TemplateDescription = TemplateDescription

    @property
    def ParamList(self):
        r"""Parameter list
        :rtype: list of ModifyParamItem
        """
        return self._ParamList

    @ParamList.setter
    def ParamList(self, ParamList):
        self._ParamList = ParamList


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._TemplateDescription = params.get("TemplateDescription")
        if params.get("ParamList") is not None:
            self._ParamList = []
            for item in params.get("ParamList"):
                obj = ModifyParamItem()
                obj._deserialize(item)
                self._ParamList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyParamTemplateResponse(AbstractModel):
    r"""ModifyParamTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyParamsData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _Name: 
        :type Name: str
        :param _OldValue: 
        :type OldValue: str
        :param _CurValue: 
        :type CurValue: str
        """
        self._Name = None
        self._OldValue = None
        self._CurValue = None

    @property
    def Name(self):
        r"""
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def OldValue(self):
        r"""
        :rtype: str
        """
        return self._OldValue

    @OldValue.setter
    def OldValue(self, OldValue):
        self._OldValue = OldValue

    @property
    def CurValue(self):
        r"""
        :rtype: str
        """
        return self._CurValue

    @CurValue.setter
    def CurValue(self, CurValue):
        self._CurValue = CurValue


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._OldValue = params.get("OldValue")
        self._CurValue = params.get("CurValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProxyDescRequest(AbstractModel):
    r"""ModifyProxyDesc request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _Description: Database proxy description
        :type Description: str
        """
        self._ClusterId = None
        self._ProxyGroupId = None
        self._Description = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def Description(self):
        r"""Database proxy description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProxyDescResponse(AbstractModel):
    r"""ModifyProxyDesc response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyProxyRwSplitRequest(AbstractModel):
    r"""ModifyProxyRwSplit request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _ConsistencyType: Consistency type. Valid values: `eventual` (eventual consistency), `session` (session consistency), `global` (global consistency).
        :type ConsistencyType: str
        :param _ConsistencyTimeOut: Consistency timeout period
        :type ConsistencyTimeOut: str
        :param _WeightMode: Assignment mode of read/write weights. Valid values: `system` (auto-assigned), `custom`
        :type WeightMode: str
        :param _InstanceWeights: Read-Only weight of an instance
        :type InstanceWeights: list of ProxyInstanceWeight
        :param _FailOver: Whether to enable failover. If it is enabled, the connection address will route requests to the source instance in case of proxy failure. Valid values: `true`, `false`.
        :type FailOver: str
        :param _AutoAddRo: Whether to automatically add read-only instances. Valid values: `true`, `false`
        :type AutoAddRo: str
        :param _OpenRw: Whether to enable read/write separation
        :type OpenRw: str
        :param _RwType: Read/Write type. Valid values:
`READWRITE`, `READONLY`.
        :type RwType: str
        :param _TransSplit: Transaction split
        :type TransSplit: bool
        :param _AccessMode: Connection mode. Valid values:
`nearby`, `balance`.
        :type AccessMode: str
        :param _OpenConnectionPool: Whether to enable the connection pool. Valid values: 
`yes`, `no`.
        :type OpenConnectionPool: str
        :param _ConnectionPoolType: Connection pool type. Valid values:
`ConnectionPoolType`, `SessionConnectionPool`.
        :type ConnectionPoolType: str
        :param _ConnectionPoolTimeOut: Connection persistence timeout
        :type ConnectionPoolTimeOut: int
        """
        self._ClusterId = None
        self._ProxyGroupId = None
        self._ConsistencyType = None
        self._ConsistencyTimeOut = None
        self._WeightMode = None
        self._InstanceWeights = None
        self._FailOver = None
        self._AutoAddRo = None
        self._OpenRw = None
        self._RwType = None
        self._TransSplit = None
        self._AccessMode = None
        self._OpenConnectionPool = None
        self._ConnectionPoolType = None
        self._ConnectionPoolTimeOut = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def ConsistencyType(self):
        r"""Consistency type. Valid values: `eventual` (eventual consistency), `session` (session consistency), `global` (global consistency).
        :rtype: str
        """
        return self._ConsistencyType

    @ConsistencyType.setter
    def ConsistencyType(self, ConsistencyType):
        self._ConsistencyType = ConsistencyType

    @property
    def ConsistencyTimeOut(self):
        r"""Consistency timeout period
        :rtype: str
        """
        return self._ConsistencyTimeOut

    @ConsistencyTimeOut.setter
    def ConsistencyTimeOut(self, ConsistencyTimeOut):
        self._ConsistencyTimeOut = ConsistencyTimeOut

    @property
    def WeightMode(self):
        r"""Assignment mode of read/write weights. Valid values: `system` (auto-assigned), `custom`
        :rtype: str
        """
        return self._WeightMode

    @WeightMode.setter
    def WeightMode(self, WeightMode):
        self._WeightMode = WeightMode

    @property
    def InstanceWeights(self):
        r"""Read-Only weight of an instance
        :rtype: list of ProxyInstanceWeight
        """
        return self._InstanceWeights

    @InstanceWeights.setter
    def InstanceWeights(self, InstanceWeights):
        self._InstanceWeights = InstanceWeights

    @property
    def FailOver(self):
        r"""Whether to enable failover. If it is enabled, the connection address will route requests to the source instance in case of proxy failure. Valid values: `true`, `false`.
        :rtype: str
        """
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def AutoAddRo(self):
        r"""Whether to automatically add read-only instances. Valid values: `true`, `false`
        :rtype: str
        """
        return self._AutoAddRo

    @AutoAddRo.setter
    def AutoAddRo(self, AutoAddRo):
        self._AutoAddRo = AutoAddRo

    @property
    def OpenRw(self):
        r"""Whether to enable read/write separation
        :rtype: str
        """
        return self._OpenRw

    @OpenRw.setter
    def OpenRw(self, OpenRw):
        self._OpenRw = OpenRw

    @property
    def RwType(self):
        r"""Read/Write type. Valid values:
`READWRITE`, `READONLY`.
        :rtype: str
        """
        return self._RwType

    @RwType.setter
    def RwType(self, RwType):
        self._RwType = RwType

    @property
    def TransSplit(self):
        r"""Transaction split
        :rtype: bool
        """
        return self._TransSplit

    @TransSplit.setter
    def TransSplit(self, TransSplit):
        self._TransSplit = TransSplit

    @property
    def AccessMode(self):
        r"""Connection mode. Valid values:
`nearby`, `balance`.
        :rtype: str
        """
        return self._AccessMode

    @AccessMode.setter
    def AccessMode(self, AccessMode):
        self._AccessMode = AccessMode

    @property
    def OpenConnectionPool(self):
        r"""Whether to enable the connection pool. Valid values: 
`yes`, `no`.
        :rtype: str
        """
        return self._OpenConnectionPool

    @OpenConnectionPool.setter
    def OpenConnectionPool(self, OpenConnectionPool):
        self._OpenConnectionPool = OpenConnectionPool

    @property
    def ConnectionPoolType(self):
        r"""Connection pool type. Valid values:
`ConnectionPoolType`, `SessionConnectionPool`.
        :rtype: str
        """
        return self._ConnectionPoolType

    @ConnectionPoolType.setter
    def ConnectionPoolType(self, ConnectionPoolType):
        self._ConnectionPoolType = ConnectionPoolType

    @property
    def ConnectionPoolTimeOut(self):
        r"""Connection persistence timeout
        :rtype: int
        """
        return self._ConnectionPoolTimeOut

    @ConnectionPoolTimeOut.setter
    def ConnectionPoolTimeOut(self, ConnectionPoolTimeOut):
        self._ConnectionPoolTimeOut = ConnectionPoolTimeOut


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._ConsistencyType = params.get("ConsistencyType")
        self._ConsistencyTimeOut = params.get("ConsistencyTimeOut")
        self._WeightMode = params.get("WeightMode")
        if params.get("InstanceWeights") is not None:
            self._InstanceWeights = []
            for item in params.get("InstanceWeights"):
                obj = ProxyInstanceWeight()
                obj._deserialize(item)
                self._InstanceWeights.append(obj)
        self._FailOver = params.get("FailOver")
        self._AutoAddRo = params.get("AutoAddRo")
        self._OpenRw = params.get("OpenRw")
        self._RwType = params.get("RwType")
        self._TransSplit = params.get("TransSplit")
        self._AccessMode = params.get("AccessMode")
        self._OpenConnectionPool = params.get("OpenConnectionPool")
        self._ConnectionPoolType = params.get("ConnectionPoolType")
        self._ConnectionPoolTimeOut = params.get("ConnectionPoolTimeOut")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProxyRwSplitResponse(AbstractModel):
    r"""ModifyProxyRwSplit response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async FlowId
        :type FlowId: int
        :param _TaskId: Async task ID
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async FlowId
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ModifyResourcePackageClustersRequest(AbstractModel):
    r"""ModifyResourcePackageClusters request structure.

    """

    def __init__(self):
        r"""
        :param _PackageId: The unique ID of a resource pack
        :type PackageId: str
        :param _BindClusterIds: ID of the cluster to be bound
        :type BindClusterIds: list of str
        :param _UnbindClusterIds: ID of the cluster to be unbound
        :type UnbindClusterIds: list of str
        """
        self._PackageId = None
        self._BindClusterIds = None
        self._UnbindClusterIds = None

    @property
    def PackageId(self):
        r"""The unique ID of a resource pack
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def BindClusterIds(self):
        r"""ID of the cluster to be bound
        :rtype: list of str
        """
        return self._BindClusterIds

    @BindClusterIds.setter
    def BindClusterIds(self, BindClusterIds):
        self._BindClusterIds = BindClusterIds

    @property
    def UnbindClusterIds(self):
        r"""ID of the cluster to be unbound
        :rtype: list of str
        """
        return self._UnbindClusterIds

    @UnbindClusterIds.setter
    def UnbindClusterIds(self, UnbindClusterIds):
        self._UnbindClusterIds = UnbindClusterIds


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._BindClusterIds = params.get("BindClusterIds")
        self._UnbindClusterIds = params.get("UnbindClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourcePackageClustersResponse(AbstractModel):
    r"""ModifyResourcePackageClusters response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyResourcePackageNameRequest(AbstractModel):
    r"""ModifyResourcePackageName request structure.

    """

    def __init__(self):
        r"""
        :param _PackageId: The unique ID of a resource pack
        :type PackageId: str
        :param _PackageName: Custom resource pack name, which can contains up to 120 characters.
        :type PackageName: str
        """
        self._PackageId = None
        self._PackageName = None

    @property
    def PackageId(self):
        r"""The unique ID of a resource pack
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def PackageName(self):
        r"""Custom resource pack name, which can contains up to 120 characters.
        :rtype: str
        """
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._PackageName = params.get("PackageName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourcePackageNameResponse(AbstractModel):
    r"""ModifyResourcePackageName response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyResourcePackagesDeductionPriorityRequest(AbstractModel):
    r"""ModifyResourcePackagesDeductionPriority request structure.

    """

    def __init__(self):
        r"""
        :param _PackageType: Specifies the resource package type whose priority needs to be modified. CCU: compute resource package. DISK: storage resource package.
        :type PackageType: str
        :param _ClusterId: The modified deduction priority takes effect for which cynos resource.
        :type ClusterId: str
        :param _DeductionPriorities: Resource package deduction priority.
        :type DeductionPriorities: list of PackagePriority
        """
        self._PackageType = None
        self._ClusterId = None
        self._DeductionPriorities = None

    @property
    def PackageType(self):
        r"""Specifies the resource package type whose priority needs to be modified. CCU: compute resource package. DISK: storage resource package.
        :rtype: str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def ClusterId(self):
        r"""The modified deduction priority takes effect for which cynos resource.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DeductionPriorities(self):
        r"""Resource package deduction priority.
        :rtype: list of PackagePriority
        """
        return self._DeductionPriorities

    @DeductionPriorities.setter
    def DeductionPriorities(self, DeductionPriorities):
        self._DeductionPriorities = DeductionPriorities


    def _deserialize(self, params):
        self._PackageType = params.get("PackageType")
        self._ClusterId = params.get("ClusterId")
        if params.get("DeductionPriorities") is not None:
            self._DeductionPriorities = []
            for item in params.get("DeductionPriorities"):
                obj = PackagePriority()
                obj._deserialize(item)
                self._DeductionPriorities.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyResourcePackagesDeductionPriorityResponse(AbstractModel):
    r"""ModifyResourcePackagesDeductionPriority response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyServerlessStrategyRequest(AbstractModel):
    r"""ModifyServerlessStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Specifies the serverless cluster id.
        :type ClusterId: str
        :param _AutoPause: Specifies whether the cluster automatically pauses. valid values for the optional range.
<li>yes</li>
<li>no</li>
        :type AutoPause: str
        :param _AutoPauseDelay: Specifies the delay for cluster auto-pause in seconds. the value range is [600,691200]. the default value is 600.
        :type AutoPauseDelay: int
        :param _AutoScaleUpDelay: The parameter is temporarily unavailable.
        :type AutoScaleUpDelay: int
        :param _AutoScaleDownDelay: The parameter is temporarily unavailable.
        :type AutoScaleDownDelay: int
        :param _MinCpu: Minimum value of cpu. for the optional range, refer to the API response of DescribeServerlessInstanceSpecs.
        :type MinCpu: float
        :param _MaxCpu: Maximum value of cpu, optional range refers to the API response of DescribeServerlessInstanceSpecs.
        :type MaxCpu: float
        :param _MinRoCpu: Minimum cpu value of a read-only instance. for valid values, refer to the API response of DescribeServerlessInstanceSpecs.
        :type MinRoCpu: float
        :param _MaxRoCpu: Maximum value of read-only cpu, optional range refer to the API response of DescribeServerlessInstanceSpecs.
        :type MaxRoCpu: float
        :param _MinRoCount: Specifies the minimum count of read-only nodes.
        :type MinRoCount: int
        :param _MaxRoCount: Maximum number of read-only nodes.
        :type MaxRoCount: int
        """
        self._ClusterId = None
        self._AutoPause = None
        self._AutoPauseDelay = None
        self._AutoScaleUpDelay = None
        self._AutoScaleDownDelay = None
        self._MinCpu = None
        self._MaxCpu = None
        self._MinRoCpu = None
        self._MaxRoCpu = None
        self._MinRoCount = None
        self._MaxRoCount = None

    @property
    def ClusterId(self):
        r"""Specifies the serverless cluster id.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AutoPause(self):
        r"""Specifies whether the cluster automatically pauses. valid values for the optional range.
<li>yes</li>
<li>no</li>
        :rtype: str
        """
        return self._AutoPause

    @AutoPause.setter
    def AutoPause(self, AutoPause):
        self._AutoPause = AutoPause

    @property
    def AutoPauseDelay(self):
        r"""Specifies the delay for cluster auto-pause in seconds. the value range is [600,691200]. the default value is 600.
        :rtype: int
        """
        return self._AutoPauseDelay

    @AutoPauseDelay.setter
    def AutoPauseDelay(self, AutoPauseDelay):
        self._AutoPauseDelay = AutoPauseDelay

    @property
    def AutoScaleUpDelay(self):
        r"""The parameter is temporarily unavailable.
        :rtype: int
        """
        return self._AutoScaleUpDelay

    @AutoScaleUpDelay.setter
    def AutoScaleUpDelay(self, AutoScaleUpDelay):
        self._AutoScaleUpDelay = AutoScaleUpDelay

    @property
    def AutoScaleDownDelay(self):
        r"""The parameter is temporarily unavailable.
        :rtype: int
        """
        return self._AutoScaleDownDelay

    @AutoScaleDownDelay.setter
    def AutoScaleDownDelay(self, AutoScaleDownDelay):
        self._AutoScaleDownDelay = AutoScaleDownDelay

    @property
    def MinCpu(self):
        r"""Minimum value of cpu. for the optional range, refer to the API response of DescribeServerlessInstanceSpecs.
        :rtype: float
        """
        return self._MinCpu

    @MinCpu.setter
    def MinCpu(self, MinCpu):
        self._MinCpu = MinCpu

    @property
    def MaxCpu(self):
        r"""Maximum value of cpu, optional range refers to the API response of DescribeServerlessInstanceSpecs.
        :rtype: float
        """
        return self._MaxCpu

    @MaxCpu.setter
    def MaxCpu(self, MaxCpu):
        self._MaxCpu = MaxCpu

    @property
    def MinRoCpu(self):
        r"""Minimum cpu value of a read-only instance. for valid values, refer to the API response of DescribeServerlessInstanceSpecs.
        :rtype: float
        """
        return self._MinRoCpu

    @MinRoCpu.setter
    def MinRoCpu(self, MinRoCpu):
        self._MinRoCpu = MinRoCpu

    @property
    def MaxRoCpu(self):
        r"""Maximum value of read-only cpu, optional range refer to the API response of DescribeServerlessInstanceSpecs.
        :rtype: float
        """
        return self._MaxRoCpu

    @MaxRoCpu.setter
    def MaxRoCpu(self, MaxRoCpu):
        self._MaxRoCpu = MaxRoCpu

    @property
    def MinRoCount(self):
        r"""Specifies the minimum count of read-only nodes.
        :rtype: int
        """
        return self._MinRoCount

    @MinRoCount.setter
    def MinRoCount(self, MinRoCount):
        self._MinRoCount = MinRoCount

    @property
    def MaxRoCount(self):
        r"""Maximum number of read-only nodes.
        :rtype: int
        """
        return self._MaxRoCount

    @MaxRoCount.setter
    def MaxRoCount(self, MaxRoCount):
        self._MaxRoCount = MaxRoCount


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AutoPause = params.get("AutoPause")
        self._AutoPauseDelay = params.get("AutoPauseDelay")
        self._AutoScaleUpDelay = params.get("AutoScaleUpDelay")
        self._AutoScaleDownDelay = params.get("AutoScaleDownDelay")
        self._MinCpu = params.get("MinCpu")
        self._MaxCpu = params.get("MaxCpu")
        self._MinRoCpu = params.get("MinRoCpu")
        self._MaxRoCpu = params.get("MaxRoCpu")
        self._MinRoCount = params.get("MinRoCount")
        self._MaxRoCount = params.get("MaxRoCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyServerlessStrategyResponse(AbstractModel):
    r"""ModifyServerlessStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async process id.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async process id.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class ModifyVipVportRequest(AbstractModel):
    r"""ModifyVipVport request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceGrpId: Instance group ID
        :type InstanceGrpId: str
        :param _Vip: Target IP to be modified
        :type Vip: str
        :param _Vport: Target port to be modified
        :type Vport: int
        :param _DbType: Database type. Valid values: 
<li> MYSQL </li>
        :type DbType: str
        :param _OldIpReserveHours: Valid hours of old IPs. If it is set to `0` hours, the IPs will be released immediately.
        :type OldIpReserveHours: int
        """
        self._ClusterId = None
        self._InstanceGrpId = None
        self._Vip = None
        self._Vport = None
        self._DbType = None
        self._OldIpReserveHours = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceGrpId(self):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        r"""Instance group ID
        :rtype: str
        """
        return self._InstanceGrpId

    @InstanceGrpId.setter
    def InstanceGrpId(self, InstanceGrpId):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        self._InstanceGrpId = InstanceGrpId

    @property
    def Vip(self):
        r"""Target IP to be modified
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Target port to be modified
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def DbType(self):
        r"""Database type. Valid values: 
<li> MYSQL </li>
        :rtype: str
        """
        return self._DbType

    @DbType.setter
    def DbType(self, DbType):
        self._DbType = DbType

    @property
    def OldIpReserveHours(self):
        r"""Valid hours of old IPs. If it is set to `0` hours, the IPs will be released immediately.
        :rtype: int
        """
        return self._OldIpReserveHours

    @OldIpReserveHours.setter
    def OldIpReserveHours(self, OldIpReserveHours):
        self._OldIpReserveHours = OldIpReserveHours


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceGrpId = params.get("InstanceGrpId")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._DbType = params.get("DbType")
        self._OldIpReserveHours = params.get("OldIpReserveHours")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVipVportResponse(AbstractModel):
    r"""ModifyVipVport response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async task ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class Module(AbstractModel):
    r"""Modules supported by the system

    """

    def __init__(self):
        r"""
        :param _IsDisable: Whether it is supported. Valid values: `yes`, `no`.
        :type IsDisable: str
        :param _ModuleName: Module name
        :type ModuleName: str
        """
        self._IsDisable = None
        self._ModuleName = None

    @property
    def IsDisable(self):
        r"""Whether it is supported. Valid values: `yes`, `no`.
        :rtype: str
        """
        return self._IsDisable

    @IsDisable.setter
    def IsDisable(self, IsDisable):
        self._IsDisable = IsDisable

    @property
    def ModuleName(self):
        r"""Module name
        :rtype: str
        """
        return self._ModuleName

    @ModuleName.setter
    def ModuleName(self, ModuleName):
        self._ModuleName = ModuleName


    def _deserialize(self, params):
        self._IsDisable = params.get("IsDisable")
        self._ModuleName = params.get("ModuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NetAddr(AbstractModel):
    r"""Network information

    """

    def __init__(self):
        r"""
        :param _Vip: Private IP address
        :type Vip: str
        :param _Vport: Specifies the private network port number.
        :type Vport: int
        :param _WanDomain: Specifies the public network domain name.
        :type WanDomain: str
        :param _WanPort: Specifies the public network port number.
        :type WanPort: int
        :param _NetType: Network type (ro - read-only, rw/ha - read-write).
        :type NetType: str
        :param _UniqSubnetId: Specifies the subnet ID.
        :type UniqSubnetId: str
        :param _UniqVpcId: Specifies the virtual private cloud ID.
        :type UniqVpcId: str
        :param _Description: Description information
        :type Description: str
        :param _WanIP: Public IP address
        :type WanIP: str
        :param _WanStatus: Specifies the public network status.
        :type WanStatus: str
        :param _InstanceGroupId: Instance group ID
        :type InstanceGroupId: str
        """
        self._Vip = None
        self._Vport = None
        self._WanDomain = None
        self._WanPort = None
        self._NetType = None
        self._UniqSubnetId = None
        self._UniqVpcId = None
        self._Description = None
        self._WanIP = None
        self._WanStatus = None
        self._InstanceGroupId = None

    @property
    def Vip(self):
        r"""Private IP address
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Specifies the private network port number.
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def WanDomain(self):
        r"""Specifies the public network domain name.
        :rtype: str
        """
        return self._WanDomain

    @WanDomain.setter
    def WanDomain(self, WanDomain):
        self._WanDomain = WanDomain

    @property
    def WanPort(self):
        r"""Specifies the public network port number.
        :rtype: int
        """
        return self._WanPort

    @WanPort.setter
    def WanPort(self, WanPort):
        self._WanPort = WanPort

    @property
    def NetType(self):
        r"""Network type (ro - read-only, rw/ha - read-write).
        :rtype: str
        """
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def UniqSubnetId(self):
        r"""Specifies the subnet ID.
        :rtype: str
        """
        return self._UniqSubnetId

    @UniqSubnetId.setter
    def UniqSubnetId(self, UniqSubnetId):
        self._UniqSubnetId = UniqSubnetId

    @property
    def UniqVpcId(self):
        r"""Specifies the virtual private cloud ID.
        :rtype: str
        """
        return self._UniqVpcId

    @UniqVpcId.setter
    def UniqVpcId(self, UniqVpcId):
        self._UniqVpcId = UniqVpcId

    @property
    def Description(self):
        r"""Description information
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def WanIP(self):
        r"""Public IP address
        :rtype: str
        """
        return self._WanIP

    @WanIP.setter
    def WanIP(self, WanIP):
        self._WanIP = WanIP

    @property
    def WanStatus(self):
        r"""Specifies the public network status.
        :rtype: str
        """
        return self._WanStatus

    @WanStatus.setter
    def WanStatus(self, WanStatus):
        self._WanStatus = WanStatus

    @property
    def InstanceGroupId(self):
        r"""Instance group ID
        :rtype: str
        """
        return self._InstanceGroupId

    @InstanceGroupId.setter
    def InstanceGroupId(self, InstanceGroupId):
        self._InstanceGroupId = InstanceGroupId


    def _deserialize(self, params):
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._WanDomain = params.get("WanDomain")
        self._WanPort = params.get("WanPort")
        self._NetType = params.get("NetType")
        self._UniqSubnetId = params.get("UniqSubnetId")
        self._UniqVpcId = params.get("UniqVpcId")
        self._Description = params.get("Description")
        self._WanIP = params.get("WanIP")
        self._WanStatus = params.get("WanStatus")
        self._InstanceGroupId = params.get("InstanceGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NewAccount(AbstractModel):
    r"""The newly created x08 account

    """

    def __init__(self):
        r"""
        :param _AccountName: Account name, which can contain 1-16 letters, digits, and underscores. It must begin with a letter and end with a letter or digit.
        :type AccountName: str
        :param _AccountPassword: Password, which can contain 8-64 characters.
        :type AccountPassword: str
        :param _Host: Host
        :type Host: str
        :param _Description: Description
        :type Description: str
        :param _MaxUserConnections: Maximum number of user connections, which cannot be above 10,240.
        :type MaxUserConnections: int
        """
        self._AccountName = None
        self._AccountPassword = None
        self._Host = None
        self._Description = None
        self._MaxUserConnections = None

    @property
    def AccountName(self):
        r"""Account name, which can contain 1-16 letters, digits, and underscores. It must begin with a letter and end with a letter or digit.
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def AccountPassword(self):
        r"""Password, which can contain 8-64 characters.
        :rtype: str
        """
        return self._AccountPassword

    @AccountPassword.setter
    def AccountPassword(self, AccountPassword):
        self._AccountPassword = AccountPassword

    @property
    def Host(self):
        r"""Host
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Description(self):
        r"""Description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MaxUserConnections(self):
        r"""Maximum number of user connections, which cannot be above 10,240.
        :rtype: int
        """
        return self._MaxUserConnections

    @MaxUserConnections.setter
    def MaxUserConnections(self, MaxUserConnections):
        self._MaxUserConnections = MaxUserConnections


    def _deserialize(self, params):
        self._AccountName = params.get("AccountName")
        self._AccountPassword = params.get("AccountPassword")
        self._Host = params.get("Host")
        self._Description = params.get("Description")
        self._MaxUserConnections = params.get("MaxUserConnections")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ObjectTask(AbstractModel):
    r"""Task information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task auto-increment ID.
        :type TaskId: int
        :param _TaskType: Task type
        :type TaskType: str
        :param _TaskStatus: Status of tasks.
        :type TaskStatus: str
        :param _ObjectId: Task ID (cluster ID | instance group ID | instance ID).
        :type ObjectId: str
        :param _ObjectType: Task type
        :type ObjectType: str
        """
        self._TaskId = None
        self._TaskType = None
        self._TaskStatus = None
        self._ObjectId = None
        self._ObjectType = None

    @property
    def TaskId(self):
        r"""Task auto-increment ID.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        r"""Task type
        :rtype: str
        """
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskStatus(self):
        r"""Status of tasks.
        :rtype: str
        """
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def ObjectId(self):
        r"""Task ID (cluster ID | instance group ID | instance ID).
        :rtype: str
        """
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def ObjectType(self):
        r"""Task type
        :rtype: str
        """
        return self._ObjectType

    @ObjectType.setter
    def ObjectType(self, ObjectType):
        self._ObjectType = ObjectType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        self._TaskStatus = params.get("TaskStatus")
        self._ObjectId = params.get("ObjectId")
        self._ObjectType = params.get("ObjectType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OfflineClusterRequest(AbstractModel):
    r"""OfflineCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OfflineClusterResponse(AbstractModel):
    r"""OfflineCluster response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class OfflineInstanceRequest(AbstractModel):
    r"""OfflineInstance request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _InstanceIdList: Instance ID array
        :type InstanceIdList: list of str
        """
        self._ClusterId = None
        self._InstanceIdList = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIdList(self):
        r"""Instance ID array
        :rtype: list of str
        """
        return self._InstanceIdList

    @InstanceIdList.setter
    def InstanceIdList(self, InstanceIdList):
        self._InstanceIdList = InstanceIdList


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIdList = params.get("InstanceIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OfflineInstanceResponse(AbstractModel):
    r"""OfflineInstance response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class OldAddrInfo(AbstractModel):
    r"""Database address

    """

    def __init__(self):
        r"""
        :param _Vip: IP
        :type Vip: str
        :param _Vport: Port
        :type Vport: int
        :param _ReturnTime: Expect recycle time.
        :type ReturnTime: str
        """
        self._Vip = None
        self._Vport = None
        self._ReturnTime = None

    @property
    def Vip(self):
        r"""IP
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        r"""Port
        :rtype: int
        """
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def ReturnTime(self):
        r"""Expect recycle time.
        :rtype: str
        """
        return self._ReturnTime

    @ReturnTime.setter
    def ReturnTime(self, ReturnTime):
        self._ReturnTime = ReturnTime


    def _deserialize(self, params):
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._ReturnTime = params.get("ReturnTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenAuditServiceRequest(AbstractModel):
    r"""OpenAuditService request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _LogExpireDay: Log retention period
        :type LogExpireDay: int
        :param _HighLogExpireDay: Frequent log retention period
        :type HighLogExpireDay: int
        :param _AuditRuleFilters: Audit rule. If both this parameter and `RuleTemplateIds` are left empty, full audit will be applied.
        :type AuditRuleFilters: list of AuditRuleFilters
        :param _RuleTemplateIds: Rule template ID. If both this parameter and `AuditRuleFilters` are left empty, full audit will be applied.
        :type RuleTemplateIds: list of str
        """
        self._InstanceId = None
        self._LogExpireDay = None
        self._HighLogExpireDay = None
        self._AuditRuleFilters = None
        self._RuleTemplateIds = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def LogExpireDay(self):
        r"""Log retention period
        :rtype: int
        """
        return self._LogExpireDay

    @LogExpireDay.setter
    def LogExpireDay(self, LogExpireDay):
        self._LogExpireDay = LogExpireDay

    @property
    def HighLogExpireDay(self):
        r"""Frequent log retention period
        :rtype: int
        """
        return self._HighLogExpireDay

    @HighLogExpireDay.setter
    def HighLogExpireDay(self, HighLogExpireDay):
        self._HighLogExpireDay = HighLogExpireDay

    @property
    def AuditRuleFilters(self):
        warnings.warn("parameter `AuditRuleFilters` is deprecated", DeprecationWarning) 

        r"""Audit rule. If both this parameter and `RuleTemplateIds` are left empty, full audit will be applied.
        :rtype: list of AuditRuleFilters
        """
        return self._AuditRuleFilters

    @AuditRuleFilters.setter
    def AuditRuleFilters(self, AuditRuleFilters):
        warnings.warn("parameter `AuditRuleFilters` is deprecated", DeprecationWarning) 

        self._AuditRuleFilters = AuditRuleFilters

    @property
    def RuleTemplateIds(self):
        r"""Rule template ID. If both this parameter and `AuditRuleFilters` are left empty, full audit will be applied.
        :rtype: list of str
        """
        return self._RuleTemplateIds

    @RuleTemplateIds.setter
    def RuleTemplateIds(self, RuleTemplateIds):
        self._RuleTemplateIds = RuleTemplateIds


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._LogExpireDay = params.get("LogExpireDay")
        self._HighLogExpireDay = params.get("HighLogExpireDay")
        if params.get("AuditRuleFilters") is not None:
            self._AuditRuleFilters = []
            for item in params.get("AuditRuleFilters"):
                obj = AuditRuleFilters()
                obj._deserialize(item)
                self._AuditRuleFilters.append(obj)
        self._RuleTemplateIds = params.get("RuleTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenAuditServiceResponse(AbstractModel):
    r"""OpenAuditService response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class OpenClusterPasswordComplexityRequest(AbstractModel):
    r"""OpenClusterPasswordComplexity request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ValidatePasswordLength: Password length
        :type ValidatePasswordLength: int
        :param _ValidatePasswordMixedCaseCount: Number of letters
        :type ValidatePasswordMixedCaseCount: int
        :param _ValidatePasswordSpecialCharCount: Number of symbols
        :type ValidatePasswordSpecialCharCount: int
        :param _ValidatePasswordNumberCount: Number of digits
        :type ValidatePasswordNumberCount: int
        :param _ValidatePasswordPolicy: Password strength. Valid values: `MEDIUM`, `STRONG`.
        :type ValidatePasswordPolicy: str
        :param _ValidatePasswordDictionary: Data dictionary
        :type ValidatePasswordDictionary: list of str
        """
        self._ClusterId = None
        self._ValidatePasswordLength = None
        self._ValidatePasswordMixedCaseCount = None
        self._ValidatePasswordSpecialCharCount = None
        self._ValidatePasswordNumberCount = None
        self._ValidatePasswordPolicy = None
        self._ValidatePasswordDictionary = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ValidatePasswordLength(self):
        r"""Password length
        :rtype: int
        """
        return self._ValidatePasswordLength

    @ValidatePasswordLength.setter
    def ValidatePasswordLength(self, ValidatePasswordLength):
        self._ValidatePasswordLength = ValidatePasswordLength

    @property
    def ValidatePasswordMixedCaseCount(self):
        r"""Number of letters
        :rtype: int
        """
        return self._ValidatePasswordMixedCaseCount

    @ValidatePasswordMixedCaseCount.setter
    def ValidatePasswordMixedCaseCount(self, ValidatePasswordMixedCaseCount):
        self._ValidatePasswordMixedCaseCount = ValidatePasswordMixedCaseCount

    @property
    def ValidatePasswordSpecialCharCount(self):
        r"""Number of symbols
        :rtype: int
        """
        return self._ValidatePasswordSpecialCharCount

    @ValidatePasswordSpecialCharCount.setter
    def ValidatePasswordSpecialCharCount(self, ValidatePasswordSpecialCharCount):
        self._ValidatePasswordSpecialCharCount = ValidatePasswordSpecialCharCount

    @property
    def ValidatePasswordNumberCount(self):
        r"""Number of digits
        :rtype: int
        """
        return self._ValidatePasswordNumberCount

    @ValidatePasswordNumberCount.setter
    def ValidatePasswordNumberCount(self, ValidatePasswordNumberCount):
        self._ValidatePasswordNumberCount = ValidatePasswordNumberCount

    @property
    def ValidatePasswordPolicy(self):
        r"""Password strength. Valid values: `MEDIUM`, `STRONG`.
        :rtype: str
        """
        return self._ValidatePasswordPolicy

    @ValidatePasswordPolicy.setter
    def ValidatePasswordPolicy(self, ValidatePasswordPolicy):
        self._ValidatePasswordPolicy = ValidatePasswordPolicy

    @property
    def ValidatePasswordDictionary(self):
        r"""Data dictionary
        :rtype: list of str
        """
        return self._ValidatePasswordDictionary

    @ValidatePasswordDictionary.setter
    def ValidatePasswordDictionary(self, ValidatePasswordDictionary):
        self._ValidatePasswordDictionary = ValidatePasswordDictionary


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ValidatePasswordLength = params.get("ValidatePasswordLength")
        self._ValidatePasswordMixedCaseCount = params.get("ValidatePasswordMixedCaseCount")
        self._ValidatePasswordSpecialCharCount = params.get("ValidatePasswordSpecialCharCount")
        self._ValidatePasswordNumberCount = params.get("ValidatePasswordNumberCount")
        self._ValidatePasswordPolicy = params.get("ValidatePasswordPolicy")
        self._ValidatePasswordDictionary = params.get("ValidatePasswordDictionary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenClusterPasswordComplexityResponse(AbstractModel):
    r"""OpenClusterPasswordComplexity response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class OpenClusterReadOnlyInstanceGroupAccessRequest(AbstractModel):
    r"""OpenClusterReadOnlyInstanceGroupAccess request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Port: Port
        :type Port: str
        :param _SecurityGroupIds: Security group ID.
        :type SecurityGroupIds: list of str
        """
        self._ClusterId = None
        self._Port = None
        self._SecurityGroupIds = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Port(self):
        r"""Port
        :rtype: str
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def SecurityGroupIds(self):
        r"""Security group ID.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Port = params.get("Port")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenClusterReadOnlyInstanceGroupAccessResponse(AbstractModel):
    r"""OpenClusterReadOnlyInstanceGroupAccess response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Initiate process ID.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Initiate process ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class OpenClusterTransparentEncryptRequest(AbstractModel):
    r"""OpenClusterTransparentEncrypt request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _KeyType: Key type (cloud, custom).
        :type KeyType: str
        :param _KeyId: Key Id.
        :type KeyId: str
        :param _KeyRegion: Key region.
        :type KeyRegion: str
        """
        self._ClusterId = None
        self._KeyType = None
        self._KeyId = None
        self._KeyRegion = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def KeyType(self):
        r"""Key type (cloud, custom).
        :rtype: str
        """
        return self._KeyType

    @KeyType.setter
    def KeyType(self, KeyType):
        self._KeyType = KeyType

    @property
    def KeyId(self):
        r"""Key Id.
        :rtype: str
        """
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def KeyRegion(self):
        r"""Key region.
        :rtype: str
        """
        return self._KeyRegion

    @KeyRegion.setter
    def KeyRegion(self, KeyRegion):
        self._KeyRegion = KeyRegion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._KeyType = params.get("KeyType")
        self._KeyId = params.get("KeyId")
        self._KeyRegion = params.get("KeyRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenClusterTransparentEncryptResponse(AbstractModel):
    r"""OpenClusterTransparentEncrypt response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Asynchronous task ID.


        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Asynchronous task ID.


        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class OpenReadOnlyInstanceExclusiveAccessRequest(AbstractModel):
    r"""OpenReadOnlyInstanceExclusiveAccess request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Please use the cluster information description (https://intl.cloud.tencent.com/document/api/1003/48086?from_cn_redirect=1) to obtain the clusterId.
        :type ClusterId: str
        :param _InstanceId: Please use the cluster information description (https://intl.cloud.tencent.com/document/api/1003/48086?from_cn_redirect=1) to obtain the instanceId.
        :type InstanceId: str
        :param _VpcId: Specifies the designated vpc ID. please use the "query vpc list" to obtain the vpc ID.
        :type VpcId: str
        :param _SubnetId: Specified subnet ID. if vpc ID is set, SubnetId is required. please use query subnet list (https://intl.cloud.tencent.com/document/api/215/15784?from_cn_redirect=1) to get SubnetId.
        :type SubnetId: str
        :param _Port: User-Defined port.
        :type Port: int
        :param _SecurityGroupIds: Security group ID. use [view security group](https://intl.cloud.tencent.com/document/api/215/15808?from_cn_redirect=1) to obtain the SecurityGroupId.
        :type SecurityGroupIds: list of str
        """
        self._ClusterId = None
        self._InstanceId = None
        self._VpcId = None
        self._SubnetId = None
        self._Port = None
        self._SecurityGroupIds = None

    @property
    def ClusterId(self):
        r"""Please use the cluster information description (https://intl.cloud.tencent.com/document/api/1003/48086?from_cn_redirect=1) to obtain the clusterId.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceId(self):
        r"""Please use the cluster information description (https://intl.cloud.tencent.com/document/api/1003/48086?from_cn_redirect=1) to obtain the instanceId.
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def VpcId(self):
        r"""Specifies the designated vpc ID. please use the "query vpc list" to obtain the vpc ID.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""Specified subnet ID. if vpc ID is set, SubnetId is required. please use query subnet list (https://intl.cloud.tencent.com/document/api/215/15784?from_cn_redirect=1) to get SubnetId.
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Port(self):
        r"""User-Defined port.
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def SecurityGroupIds(self):
        r"""Security group ID. use [view security group](https://intl.cloud.tencent.com/document/api/215/15808?from_cn_redirect=1) to obtain the SecurityGroupId.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceId = params.get("InstanceId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Port = params.get("Port")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenReadOnlyInstanceExclusiveAccessResponse(AbstractModel):
    r"""OpenReadOnlyInstanceExclusiveAccess response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Activation process ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Activation process ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class OpenWanRequest(AbstractModel):
    r"""OpenWan request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceGrpId: Instance group ID
        :type InstanceGrpId: str
        """
        self._InstanceGrpId = None

    @property
    def InstanceGrpId(self):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        r"""Instance group ID
        :rtype: str
        """
        return self._InstanceGrpId

    @InstanceGrpId.setter
    def InstanceGrpId(self, InstanceGrpId):
        warnings.warn("parameter `InstanceGrpId` is deprecated", DeprecationWarning) 

        self._InstanceGrpId = InstanceGrpId


    def _deserialize(self, params):
        self._InstanceGrpId = params.get("InstanceGrpId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenWanResponse(AbstractModel):
    r"""OpenWan response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class Package(AbstractModel):
    r"""Resource pack

    """

    def __init__(self):
        r"""
        :param _AppId: AppID
        :type AppId: int
        :param _PackageId: The unique ID of the resource package.
        :type PackageId: str
        :param _PackageName: Resource package name.
        :type PackageName: str
        :param _PackageType: Specifies the resource package type.
CCU: compute resource package. DISK: storage resource package.
        :type PackageType: str
        :param _PackageRegion: Resource package region of use.
China - common in the chinese mainland. overseas - universally applicable in hong kong (china), macao (china), taiwan (china), and overseas.
        :type PackageRegion: str
        :param _Status: Specifies the status of the resource package.
creating - indicates that it is in the process of being created.
{using} specifies that it is in use.
expired-expired;.
normal_finish - specifies that it is used up.
`Apply_refund`: apply for a refund.
Specifies that the fee has been refunded.
        :type Status: str
        :param _PackageTotalSpec: Total resource package quantity.
        :type PackageTotalSpec: float
        :param _PackageUsedSpec: Used amount of resource package.
        :type PackageUsedSpec: float
        :param _HasQuota: Whether there is inventory surplus.
        :type HasQuota: bool
        :param _BindInstanceInfos: Specifies the bound instance information.
        :type BindInstanceInfos: list of BindInstanceInfo
        :param _StartTime: Specifies the effective time: 2022-07-01 00:00:00.
        :type StartTime: str
        :param _ExpireTime: Specifies the expiration time: 2022-08-01 00:00:00.
        :type ExpireTime: str
        :param _HistoryBindResourceInfos: Information of the instance historically bound (now unbound) to the resource pack.
        :type HistoryBindResourceInfos: list of BindInstanceInfo
        """
        self._AppId = None
        self._PackageId = None
        self._PackageName = None
        self._PackageType = None
        self._PackageRegion = None
        self._Status = None
        self._PackageTotalSpec = None
        self._PackageUsedSpec = None
        self._HasQuota = None
        self._BindInstanceInfos = None
        self._StartTime = None
        self._ExpireTime = None
        self._HistoryBindResourceInfos = None

    @property
    def AppId(self):
        r"""AppID
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def PackageId(self):
        r"""The unique ID of the resource package.
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def PackageName(self):
        r"""Resource package name.
        :rtype: str
        """
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def PackageType(self):
        r"""Specifies the resource package type.
CCU: compute resource package. DISK: storage resource package.
        :rtype: str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def PackageRegion(self):
        r"""Resource package region of use.
China - common in the chinese mainland. overseas - universally applicable in hong kong (china), macao (china), taiwan (china), and overseas.
        :rtype: str
        """
        return self._PackageRegion

    @PackageRegion.setter
    def PackageRegion(self, PackageRegion):
        self._PackageRegion = PackageRegion

    @property
    def Status(self):
        r"""Specifies the status of the resource package.
creating - indicates that it is in the process of being created.
{using} specifies that it is in use.
expired-expired;.
normal_finish - specifies that it is used up.
`Apply_refund`: apply for a refund.
Specifies that the fee has been refunded.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PackageTotalSpec(self):
        r"""Total resource package quantity.
        :rtype: float
        """
        return self._PackageTotalSpec

    @PackageTotalSpec.setter
    def PackageTotalSpec(self, PackageTotalSpec):
        self._PackageTotalSpec = PackageTotalSpec

    @property
    def PackageUsedSpec(self):
        r"""Used amount of resource package.
        :rtype: float
        """
        return self._PackageUsedSpec

    @PackageUsedSpec.setter
    def PackageUsedSpec(self, PackageUsedSpec):
        self._PackageUsedSpec = PackageUsedSpec

    @property
    def HasQuota(self):
        r"""Whether there is inventory surplus.
        :rtype: bool
        """
        return self._HasQuota

    @HasQuota.setter
    def HasQuota(self, HasQuota):
        self._HasQuota = HasQuota

    @property
    def BindInstanceInfos(self):
        r"""Specifies the bound instance information.
        :rtype: list of BindInstanceInfo
        """
        return self._BindInstanceInfos

    @BindInstanceInfos.setter
    def BindInstanceInfos(self, BindInstanceInfos):
        self._BindInstanceInfos = BindInstanceInfos

    @property
    def StartTime(self):
        r"""Specifies the effective time: 2022-07-01 00:00:00.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def ExpireTime(self):
        r"""Specifies the expiration time: 2022-08-01 00:00:00.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def HistoryBindResourceInfos(self):
        r"""Information of the instance historically bound (now unbound) to the resource pack.
        :rtype: list of BindInstanceInfo
        """
        return self._HistoryBindResourceInfos

    @HistoryBindResourceInfos.setter
    def HistoryBindResourceInfos(self, HistoryBindResourceInfos):
        self._HistoryBindResourceInfos = HistoryBindResourceInfos


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._PackageId = params.get("PackageId")
        self._PackageName = params.get("PackageName")
        self._PackageType = params.get("PackageType")
        self._PackageRegion = params.get("PackageRegion")
        self._Status = params.get("Status")
        self._PackageTotalSpec = params.get("PackageTotalSpec")
        self._PackageUsedSpec = params.get("PackageUsedSpec")
        self._HasQuota = params.get("HasQuota")
        if params.get("BindInstanceInfos") is not None:
            self._BindInstanceInfos = []
            for item in params.get("BindInstanceInfos"):
                obj = BindInstanceInfo()
                obj._deserialize(item)
                self._BindInstanceInfos.append(obj)
        self._StartTime = params.get("StartTime")
        self._ExpireTime = params.get("ExpireTime")
        if params.get("HistoryBindResourceInfos") is not None:
            self._HistoryBindResourceInfos = []
            for item in params.get("HistoryBindResourceInfos"):
                obj = BindInstanceInfo()
                obj._deserialize(item)
                self._HistoryBindResourceInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PackageDetail(AbstractModel):
    r"""Resource pack details

    """

    def __init__(self):
        r"""
        :param _AppId: AppId account ID.
        :type AppId: int
        :param _PackageId: The unique ID of the resource package.
        :type PackageId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _SuccessDeductSpec: Successfully deduct capacity.
        :type SuccessDeductSpec: float
        :param _PackageTotalUsedSpec: The used capacity of the resource package up to the present.
        :type PackageTotalUsedSpec: float
        :param _StartTime: Deduction start time.
        :type StartTime: str
        :param _EndTime: Deduction end time.
        :type EndTime: str
        :param _ExtendInfo: Extension Information
        :type ExtendInfo: str
        """
        self._AppId = None
        self._PackageId = None
        self._InstanceId = None
        self._SuccessDeductSpec = None
        self._PackageTotalUsedSpec = None
        self._StartTime = None
        self._EndTime = None
        self._ExtendInfo = None

    @property
    def AppId(self):
        r"""AppId account ID.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def PackageId(self):
        r"""The unique ID of the resource package.
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SuccessDeductSpec(self):
        r"""Successfully deduct capacity.
        :rtype: float
        """
        return self._SuccessDeductSpec

    @SuccessDeductSpec.setter
    def SuccessDeductSpec(self, SuccessDeductSpec):
        self._SuccessDeductSpec = SuccessDeductSpec

    @property
    def PackageTotalUsedSpec(self):
        r"""The used capacity of the resource package up to the present.
        :rtype: float
        """
        return self._PackageTotalUsedSpec

    @PackageTotalUsedSpec.setter
    def PackageTotalUsedSpec(self, PackageTotalUsedSpec):
        self._PackageTotalUsedSpec = PackageTotalUsedSpec

    @property
    def StartTime(self):
        r"""Deduction start time.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Deduction end time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ExtendInfo(self):
        r"""Extension Information
        :rtype: str
        """
        return self._ExtendInfo

    @ExtendInfo.setter
    def ExtendInfo(self, ExtendInfo):
        self._ExtendInfo = ExtendInfo


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._PackageId = params.get("PackageId")
        self._InstanceId = params.get("InstanceId")
        self._SuccessDeductSpec = params.get("SuccessDeductSpec")
        self._PackageTotalUsedSpec = params.get("PackageTotalUsedSpec")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ExtendInfo = params.get("ExtendInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PackagePriority(AbstractModel):
    r"""Resource package deduction priority.

    """

    def __init__(self):
        r"""
        :param _PackageId: The resource pack whose deduction priority needs to be customized.
        :type PackageId: str
        :param _DeductionPriority: Custom deduction priority.
        :type DeductionPriority: int
        """
        self._PackageId = None
        self._DeductionPriority = None

    @property
    def PackageId(self):
        r"""The resource pack whose deduction priority needs to be customized.
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def DeductionPriority(self):
        r"""Custom deduction priority.
        :rtype: int
        """
        return self._DeductionPriority

    @DeductionPriority.setter
    def DeductionPriority(self, DeductionPriority):
        self._DeductionPriority = DeductionPriority


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._DeductionPriority = params.get("DeductionPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamDetail(AbstractModel):
    r"""Instance parameter details

    """

    def __init__(self):
        r"""
        :param _ParamName: Parameter name
        :type ParamName: str
        :param _ParamType: Parameter type. Valid values:  `integer`, `enum`, `float`, `string`, `func`.
        :type ParamType: str
        :param _SupportFunc: Whether `func` is supported. Valid values: `true` (supported), `false` (not supported).
        :type SupportFunc: bool
        :param _Default: Default value
        :type Default: str
        :param _Description: Parameter description
        :type Description: str
        :param _CurrentValue: Current value of the parameter
        :type CurrentValue: str
        :param _NeedReboot: Whether to restart the database for the modified parameters to take effect. Valid values:  `0` (no), `1` (yes).
        :type NeedReboot: int
        :param _Max: Maximum value of the parameter
        :type Max: str
        :param _Min: Minimum value of the parameter
        :type Min: str
        :param _EnumValue: Optional enumerated values of the parameter. if it is a non-enumerated value, it is empty.
        :type EnumValue: list of str
        :param _IsGlobal: Valid values: `1` (global parameter),  `0`  (non-global parameter).
        :type IsGlobal: int
        :param _MatchType: The match type. Valid value: `multiVal`.
        :type MatchType: str
        :param _MatchValue: Match values, which will be separated by comma when `MatchType` is `multiVal`.
        :type MatchValue: str
        :param _IsFunc: true - indicates a formula. false - indicates it is not a formula.
        :type IsFunc: bool
        :param _Func: Specifies that when the parameter is set as a formula, Func returns the set formula content.
        :type Func: str
        :param _ModifiableInfo: Whether the parameter is modifiable.
        :type ModifiableInfo: :class:`tencentcloud.cynosdb.v20190107.models.ModifiableInfo`
        :param _FuncPattern: The default formula style of parameters that support formulas.
        :type FuncPattern: str
        """
        self._ParamName = None
        self._ParamType = None
        self._SupportFunc = None
        self._Default = None
        self._Description = None
        self._CurrentValue = None
        self._NeedReboot = None
        self._Max = None
        self._Min = None
        self._EnumValue = None
        self._IsGlobal = None
        self._MatchType = None
        self._MatchValue = None
        self._IsFunc = None
        self._Func = None
        self._ModifiableInfo = None
        self._FuncPattern = None

    @property
    def ParamName(self):
        r"""Parameter name
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def ParamType(self):
        r"""Parameter type. Valid values:  `integer`, `enum`, `float`, `string`, `func`.
        :rtype: str
        """
        return self._ParamType

    @ParamType.setter
    def ParamType(self, ParamType):
        self._ParamType = ParamType

    @property
    def SupportFunc(self):
        r"""Whether `func` is supported. Valid values: `true` (supported), `false` (not supported).
        :rtype: bool
        """
        return self._SupportFunc

    @SupportFunc.setter
    def SupportFunc(self, SupportFunc):
        self._SupportFunc = SupportFunc

    @property
    def Default(self):
        r"""Default value
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default

    @property
    def Description(self):
        r"""Parameter description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CurrentValue(self):
        r"""Current value of the parameter
        :rtype: str
        """
        return self._CurrentValue

    @CurrentValue.setter
    def CurrentValue(self, CurrentValue):
        self._CurrentValue = CurrentValue

    @property
    def NeedReboot(self):
        r"""Whether to restart the database for the modified parameters to take effect. Valid values:  `0` (no), `1` (yes).
        :rtype: int
        """
        return self._NeedReboot

    @NeedReboot.setter
    def NeedReboot(self, NeedReboot):
        self._NeedReboot = NeedReboot

    @property
    def Max(self):
        r"""Maximum value of the parameter
        :rtype: str
        """
        return self._Max

    @Max.setter
    def Max(self, Max):
        self._Max = Max

    @property
    def Min(self):
        r"""Minimum value of the parameter
        :rtype: str
        """
        return self._Min

    @Min.setter
    def Min(self, Min):
        self._Min = Min

    @property
    def EnumValue(self):
        r"""Optional enumerated values of the parameter. if it is a non-enumerated value, it is empty.
        :rtype: list of str
        """
        return self._EnumValue

    @EnumValue.setter
    def EnumValue(self, EnumValue):
        self._EnumValue = EnumValue

    @property
    def IsGlobal(self):
        r"""Valid values: `1` (global parameter),  `0`  (non-global parameter).
        :rtype: int
        """
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def MatchType(self):
        r"""The match type. Valid value: `multiVal`.
        :rtype: str
        """
        return self._MatchType

    @MatchType.setter
    def MatchType(self, MatchType):
        self._MatchType = MatchType

    @property
    def MatchValue(self):
        r"""Match values, which will be separated by comma when `MatchType` is `multiVal`.
        :rtype: str
        """
        return self._MatchValue

    @MatchValue.setter
    def MatchValue(self, MatchValue):
        self._MatchValue = MatchValue

    @property
    def IsFunc(self):
        r"""true - indicates a formula. false - indicates it is not a formula.
        :rtype: bool
        """
        return self._IsFunc

    @IsFunc.setter
    def IsFunc(self, IsFunc):
        self._IsFunc = IsFunc

    @property
    def Func(self):
        r"""Specifies that when the parameter is set as a formula, Func returns the set formula content.
        :rtype: str
        """
        return self._Func

    @Func.setter
    def Func(self, Func):
        self._Func = Func

    @property
    def ModifiableInfo(self):
        r"""Whether the parameter is modifiable.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ModifiableInfo`
        """
        return self._ModifiableInfo

    @ModifiableInfo.setter
    def ModifiableInfo(self, ModifiableInfo):
        self._ModifiableInfo = ModifiableInfo

    @property
    def FuncPattern(self):
        r"""The default formula style of parameters that support formulas.
        :rtype: str
        """
        return self._FuncPattern

    @FuncPattern.setter
    def FuncPattern(self, FuncPattern):
        self._FuncPattern = FuncPattern


    def _deserialize(self, params):
        self._ParamName = params.get("ParamName")
        self._ParamType = params.get("ParamType")
        self._SupportFunc = params.get("SupportFunc")
        self._Default = params.get("Default")
        self._Description = params.get("Description")
        self._CurrentValue = params.get("CurrentValue")
        self._NeedReboot = params.get("NeedReboot")
        self._Max = params.get("Max")
        self._Min = params.get("Min")
        self._EnumValue = params.get("EnumValue")
        self._IsGlobal = params.get("IsGlobal")
        self._MatchType = params.get("MatchType")
        self._MatchValue = params.get("MatchValue")
        self._IsFunc = params.get("IsFunc")
        self._Func = params.get("Func")
        if params.get("ModifiableInfo") is not None:
            self._ModifiableInfo = ModifiableInfo()
            self._ModifiableInfo._deserialize(params.get("ModifiableInfo"))
        self._FuncPattern = params.get("FuncPattern")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamInfo(AbstractModel):
    r"""Parameter information

    """

    def __init__(self):
        r"""
        :param _CurrentValue: Current value
        :type CurrentValue: str
        :param _Default: Default value
        :type Default: str
        :param _EnumValue: If the parameter is of type enum/string/bool, the available options list.
        :type EnumValue: list of str
        :param _Max: Maximum value when parameter type is `float` or `integer`.
        :type Max: str
        :param _Min: Minimum value when parameter type is `float` or `integer`.
        :type Min: str
        :param _ParamName: Parameter name
        :type ParamName: str
        :param _NeedReboot: Whether to restart the instance for the modified parameters to take effect.
        :type NeedReboot: int
        :param _ParamType: Parameter type: `integer`, `float`, `string`, `enum`, `bool`.
        :type ParamType: str
        :param _MatchType: Match type. Regex can be used when parameter type is `string`. Valid value: `multiVal`.
        :type MatchType: str
        :param _MatchValue: Match values, which will be separated by semicolon when match type is `multiVal`.
        :type MatchValue: str
        :param _Description: Parameter description
        :type Description: str
        :param _IsGlobal: Whether it is a global parameter.
        :type IsGlobal: int
        :param _ModifiableInfo: Whether the parameter is modifiable.
        :type ModifiableInfo: :class:`tencentcloud.cynosdb.v20190107.models.ModifiableInfo`
        :param _IsFunc: Whether it is a function.
        :type IsFunc: bool
        :param _Func: Function.
        :type Func: str
        :param _FuncPattern: The default formula style of parameters that support formulas.
        :type FuncPattern: str
        """
        self._CurrentValue = None
        self._Default = None
        self._EnumValue = None
        self._Max = None
        self._Min = None
        self._ParamName = None
        self._NeedReboot = None
        self._ParamType = None
        self._MatchType = None
        self._MatchValue = None
        self._Description = None
        self._IsGlobal = None
        self._ModifiableInfo = None
        self._IsFunc = None
        self._Func = None
        self._FuncPattern = None

    @property
    def CurrentValue(self):
        r"""Current value
        :rtype: str
        """
        return self._CurrentValue

    @CurrentValue.setter
    def CurrentValue(self, CurrentValue):
        self._CurrentValue = CurrentValue

    @property
    def Default(self):
        r"""Default value
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default

    @property
    def EnumValue(self):
        r"""If the parameter is of type enum/string/bool, the available options list.
        :rtype: list of str
        """
        return self._EnumValue

    @EnumValue.setter
    def EnumValue(self, EnumValue):
        self._EnumValue = EnumValue

    @property
    def Max(self):
        r"""Maximum value when parameter type is `float` or `integer`.
        :rtype: str
        """
        return self._Max

    @Max.setter
    def Max(self, Max):
        self._Max = Max

    @property
    def Min(self):
        r"""Minimum value when parameter type is `float` or `integer`.
        :rtype: str
        """
        return self._Min

    @Min.setter
    def Min(self, Min):
        self._Min = Min

    @property
    def ParamName(self):
        r"""Parameter name
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def NeedReboot(self):
        r"""Whether to restart the instance for the modified parameters to take effect.
        :rtype: int
        """
        return self._NeedReboot

    @NeedReboot.setter
    def NeedReboot(self, NeedReboot):
        self._NeedReboot = NeedReboot

    @property
    def ParamType(self):
        r"""Parameter type: `integer`, `float`, `string`, `enum`, `bool`.
        :rtype: str
        """
        return self._ParamType

    @ParamType.setter
    def ParamType(self, ParamType):
        self._ParamType = ParamType

    @property
    def MatchType(self):
        r"""Match type. Regex can be used when parameter type is `string`. Valid value: `multiVal`.
        :rtype: str
        """
        return self._MatchType

    @MatchType.setter
    def MatchType(self, MatchType):
        self._MatchType = MatchType

    @property
    def MatchValue(self):
        r"""Match values, which will be separated by semicolon when match type is `multiVal`.
        :rtype: str
        """
        return self._MatchValue

    @MatchValue.setter
    def MatchValue(self, MatchValue):
        self._MatchValue = MatchValue

    @property
    def Description(self):
        r"""Parameter description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsGlobal(self):
        r"""Whether it is a global parameter.
        :rtype: int
        """
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def ModifiableInfo(self):
        r"""Whether the parameter is modifiable.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ModifiableInfo`
        """
        return self._ModifiableInfo

    @ModifiableInfo.setter
    def ModifiableInfo(self, ModifiableInfo):
        self._ModifiableInfo = ModifiableInfo

    @property
    def IsFunc(self):
        r"""Whether it is a function.
        :rtype: bool
        """
        return self._IsFunc

    @IsFunc.setter
    def IsFunc(self, IsFunc):
        self._IsFunc = IsFunc

    @property
    def Func(self):
        r"""Function.
        :rtype: str
        """
        return self._Func

    @Func.setter
    def Func(self, Func):
        self._Func = Func

    @property
    def FuncPattern(self):
        r"""The default formula style of parameters that support formulas.
        :rtype: str
        """
        return self._FuncPattern

    @FuncPattern.setter
    def FuncPattern(self, FuncPattern):
        self._FuncPattern = FuncPattern


    def _deserialize(self, params):
        self._CurrentValue = params.get("CurrentValue")
        self._Default = params.get("Default")
        self._EnumValue = params.get("EnumValue")
        self._Max = params.get("Max")
        self._Min = params.get("Min")
        self._ParamName = params.get("ParamName")
        self._NeedReboot = params.get("NeedReboot")
        self._ParamType = params.get("ParamType")
        self._MatchType = params.get("MatchType")
        self._MatchValue = params.get("MatchValue")
        self._Description = params.get("Description")
        self._IsGlobal = params.get("IsGlobal")
        if params.get("ModifiableInfo") is not None:
            self._ModifiableInfo = ModifiableInfo()
            self._ModifiableInfo._deserialize(params.get("ModifiableInfo"))
        self._IsFunc = params.get("IsFunc")
        self._Func = params.get("Func")
        self._FuncPattern = params.get("FuncPattern")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamItem(AbstractModel):
    r"""Parameter to be modified

    """

    def __init__(self):
        r"""
        :param _ParamName: Parameter name
        :type ParamName: str
        :param _CurrentValue: New value
        :type CurrentValue: str
        :param _OldValue: Original value
        :type OldValue: str
        """
        self._ParamName = None
        self._CurrentValue = None
        self._OldValue = None

    @property
    def ParamName(self):
        r"""Parameter name
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def CurrentValue(self):
        r"""New value
        :rtype: str
        """
        return self._CurrentValue

    @CurrentValue.setter
    def CurrentValue(self, CurrentValue):
        self._CurrentValue = CurrentValue

    @property
    def OldValue(self):
        r"""Original value
        :rtype: str
        """
        return self._OldValue

    @OldValue.setter
    def OldValue(self, OldValue):
        self._OldValue = OldValue


    def _deserialize(self, params):
        self._ParamName = params.get("ParamName")
        self._CurrentValue = params.get("CurrentValue")
        self._OldValue = params.get("OldValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamItemDetail(AbstractModel):
    r"""Instance parameter information

    """

    def __init__(self):
        r"""
        :param _CurrentValue: Current value
        :type CurrentValue: str
        :param _Default: Default value
        :type Default: str
        :param _EnumValue: Enumerated values of the parameter It is null if the parameter is non-enumerated.
        :type EnumValue: list of str
        :param _IsGlobal: Valid values: `1` (global parameter),  `0`  (non-global parameter).
        :type IsGlobal: int
        :param _Max: Maximum value
        :type Max: str
        :param _Min: Minimum value
        :type Min: str
        :param _NeedReboot: Whether to restart the database for the modified parameters to take effect. Valid values:  `0` (no), `1` (yes)
        :type NeedReboot: int
        :param _ParamName: Parameter name
        :type ParamName: str
        :param _ParamType: Parameter type. Valid values:  `integer`, `enum`, `float`, `string`, `func`.
        :type ParamType: str
        :param _Description: Parameter description
        :type Description: str
        :param _IsFunc: Whether the type is a formula.
        :type IsFunc: bool
        :param _Func: Parameter configuration formula.
        :type Func: str
        :param _FuncPattern: The default formula style of parameters that support formulas.
        :type FuncPattern: str
        """
        self._CurrentValue = None
        self._Default = None
        self._EnumValue = None
        self._IsGlobal = None
        self._Max = None
        self._Min = None
        self._NeedReboot = None
        self._ParamName = None
        self._ParamType = None
        self._Description = None
        self._IsFunc = None
        self._Func = None
        self._FuncPattern = None

    @property
    def CurrentValue(self):
        r"""Current value
        :rtype: str
        """
        return self._CurrentValue

    @CurrentValue.setter
    def CurrentValue(self, CurrentValue):
        self._CurrentValue = CurrentValue

    @property
    def Default(self):
        r"""Default value
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default

    @property
    def EnumValue(self):
        r"""Enumerated values of the parameter It is null if the parameter is non-enumerated.
        :rtype: list of str
        """
        return self._EnumValue

    @EnumValue.setter
    def EnumValue(self, EnumValue):
        self._EnumValue = EnumValue

    @property
    def IsGlobal(self):
        r"""Valid values: `1` (global parameter),  `0`  (non-global parameter).
        :rtype: int
        """
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def Max(self):
        r"""Maximum value
        :rtype: str
        """
        return self._Max

    @Max.setter
    def Max(self, Max):
        self._Max = Max

    @property
    def Min(self):
        r"""Minimum value
        :rtype: str
        """
        return self._Min

    @Min.setter
    def Min(self, Min):
        self._Min = Min

    @property
    def NeedReboot(self):
        r"""Whether to restart the database for the modified parameters to take effect. Valid values:  `0` (no), `1` (yes)
        :rtype: int
        """
        return self._NeedReboot

    @NeedReboot.setter
    def NeedReboot(self, NeedReboot):
        self._NeedReboot = NeedReboot

    @property
    def ParamName(self):
        r"""Parameter name
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def ParamType(self):
        r"""Parameter type. Valid values:  `integer`, `enum`, `float`, `string`, `func`.
        :rtype: str
        """
        return self._ParamType

    @ParamType.setter
    def ParamType(self, ParamType):
        self._ParamType = ParamType

    @property
    def Description(self):
        r"""Parameter description
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsFunc(self):
        r"""Whether the type is a formula.
        :rtype: bool
        """
        return self._IsFunc

    @IsFunc.setter
    def IsFunc(self, IsFunc):
        self._IsFunc = IsFunc

    @property
    def Func(self):
        r"""Parameter configuration formula.
        :rtype: str
        """
        return self._Func

    @Func.setter
    def Func(self, Func):
        self._Func = Func

    @property
    def FuncPattern(self):
        r"""The default formula style of parameters that support formulas.
        :rtype: str
        """
        return self._FuncPattern

    @FuncPattern.setter
    def FuncPattern(self, FuncPattern):
        self._FuncPattern = FuncPattern


    def _deserialize(self, params):
        self._CurrentValue = params.get("CurrentValue")
        self._Default = params.get("Default")
        self._EnumValue = params.get("EnumValue")
        self._IsGlobal = params.get("IsGlobal")
        self._Max = params.get("Max")
        self._Min = params.get("Min")
        self._NeedReboot = params.get("NeedReboot")
        self._ParamName = params.get("ParamName")
        self._ParamType = params.get("ParamType")
        self._Description = params.get("Description")
        self._IsFunc = params.get("IsFunc")
        self._Func = params.get("Func")
        self._FuncPattern = params.get("FuncPattern")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamItemInfo(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _ParamName: Parameter name.
        :type ParamName: str
        :param _NewValue: New parameter value.

        :type NewValue: str
        :param _OldValue: Old parameter value.

        :type OldValue: str
        :param _ValueFunction: Parameter formula.

        :type ValueFunction: str
        """
        self._ParamName = None
        self._NewValue = None
        self._OldValue = None
        self._ValueFunction = None

    @property
    def ParamName(self):
        r"""Parameter name.
        :rtype: str
        """
        return self._ParamName

    @ParamName.setter
    def ParamName(self, ParamName):
        self._ParamName = ParamName

    @property
    def NewValue(self):
        r"""New parameter value.

        :rtype: str
        """
        return self._NewValue

    @NewValue.setter
    def NewValue(self, NewValue):
        self._NewValue = NewValue

    @property
    def OldValue(self):
        r"""Old parameter value.

        :rtype: str
        """
        return self._OldValue

    @OldValue.setter
    def OldValue(self, OldValue):
        self._OldValue = OldValue

    @property
    def ValueFunction(self):
        r"""Parameter formula.

        :rtype: str
        """
        return self._ValueFunction

    @ValueFunction.setter
    def ValueFunction(self, ValueFunction):
        self._ValueFunction = ValueFunction


    def _deserialize(self, params):
        self._ParamName = params.get("ParamName")
        self._NewValue = params.get("NewValue")
        self._OldValue = params.get("OldValue")
        self._ValueFunction = params.get("ValueFunction")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParamTemplateListInfo(AbstractModel):
    r"""Parameter template information

    """

    def __init__(self):
        r"""
        :param _Id: Parameter template ID
        :type Id: int
        :param _TemplateName: Parameter template name
        :type TemplateName: str
        :param _TemplateDescription: Parameter template description
        :type TemplateDescription: str
        :param _EngineVersion: Engine version
        :type EngineVersion: str
        :param _DbMode: Database Type. Valid values: `NORMAL`, `SERVERLESS`.
        :type DbMode: str
        :param _ParamInfoSet: Parameter template details
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParamInfoSet: list of TemplateParamInfo
        """
        self._Id = None
        self._TemplateName = None
        self._TemplateDescription = None
        self._EngineVersion = None
        self._DbMode = None
        self._ParamInfoSet = None

    @property
    def Id(self):
        r"""Parameter template ID
        :rtype: int
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TemplateName(self):
        r"""Parameter template name
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def TemplateDescription(self):
        r"""Parameter template description
        :rtype: str
        """
        return self._TemplateDescription

    @TemplateDescription.setter
    def TemplateDescription(self, TemplateDescription):
        self._TemplateDescription = TemplateDescription

    @property
    def EngineVersion(self):
        r"""Engine version
        :rtype: str
        """
        return self._EngineVersion

    @EngineVersion.setter
    def EngineVersion(self, EngineVersion):
        self._EngineVersion = EngineVersion

    @property
    def DbMode(self):
        r"""Database Type. Valid values: `NORMAL`, `SERVERLESS`.
        :rtype: str
        """
        return self._DbMode

    @DbMode.setter
    def DbMode(self, DbMode):
        self._DbMode = DbMode

    @property
    def ParamInfoSet(self):
        r"""Parameter template details
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of TemplateParamInfo
        """
        return self._ParamInfoSet

    @ParamInfoSet.setter
    def ParamInfoSet(self, ParamInfoSet):
        self._ParamInfoSet = ParamInfoSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TemplateName = params.get("TemplateName")
        self._TemplateDescription = params.get("TemplateDescription")
        self._EngineVersion = params.get("EngineVersion")
        self._DbMode = params.get("DbMode")
        if params.get("ParamInfoSet") is not None:
            self._ParamInfoSet = []
            for item in params.get("ParamInfoSet"):
                obj = TemplateParamInfo()
                obj._deserialize(item)
                self._ParamInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PauseServerlessRequest(AbstractModel):
    r"""PauseServerless request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ForcePause: Whether to pause forcibly and ignore the current user connections. Valid values: `0` (no), `1` (yes). Default value: `1`
        :type ForcePause: int
        """
        self._ClusterId = None
        self._ForcePause = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ForcePause(self):
        r"""Whether to pause forcibly and ignore the current user connections. Valid values: `0` (no), `1` (yes). Default value: `1`
        :rtype: int
        """
        return self._ForcePause

    @ForcePause.setter
    def ForcePause(self, ForcePause):
        self._ForcePause = ForcePause


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ForcePause = params.get("ForcePause")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PauseServerlessResponse(AbstractModel):
    r"""PauseServerless response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async task ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class PolicyRule(AbstractModel):
    r"""Security group rule

    """

    def __init__(self):
        r"""
        :param _Action: Policy, which can be `ACCEPT` or `DROP`
        :type Action: str
        :param _CidrIp: Source IP or source IP range, such as 192.168.0.0/16
        :type CidrIp: str
        :param _PortRange: Port
        :type PortRange: str
        :param _IpProtocol: Network protocol, such as UDP and TCP
        :type IpProtocol: str
        :param _ServiceModule: Protocol port ID or protocol port group ID.
        :type ServiceModule: str
        :param _AddressModule: IP address ID or IP address group ID.
        :type AddressModule: str
        :param _Id: id
        :type Id: str
        :param _Desc: Description
        :type Desc: str
        """
        self._Action = None
        self._CidrIp = None
        self._PortRange = None
        self._IpProtocol = None
        self._ServiceModule = None
        self._AddressModule = None
        self._Id = None
        self._Desc = None

    @property
    def Action(self):
        r"""Policy, which can be `ACCEPT` or `DROP`
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def CidrIp(self):
        r"""Source IP or source IP range, such as 192.168.0.0/16
        :rtype: str
        """
        return self._CidrIp

    @CidrIp.setter
    def CidrIp(self, CidrIp):
        self._CidrIp = CidrIp

    @property
    def PortRange(self):
        r"""Port
        :rtype: str
        """
        return self._PortRange

    @PortRange.setter
    def PortRange(self, PortRange):
        self._PortRange = PortRange

    @property
    def IpProtocol(self):
        r"""Network protocol, such as UDP and TCP
        :rtype: str
        """
        return self._IpProtocol

    @IpProtocol.setter
    def IpProtocol(self, IpProtocol):
        self._IpProtocol = IpProtocol

    @property
    def ServiceModule(self):
        r"""Protocol port ID or protocol port group ID.
        :rtype: str
        """
        return self._ServiceModule

    @ServiceModule.setter
    def ServiceModule(self, ServiceModule):
        self._ServiceModule = ServiceModule

    @property
    def AddressModule(self):
        r"""IP address ID or IP address group ID.
        :rtype: str
        """
        return self._AddressModule

    @AddressModule.setter
    def AddressModule(self, AddressModule):
        self._AddressModule = AddressModule

    @property
    def Id(self):
        r"""id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Desc(self):
        r"""Description
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc


    def _deserialize(self, params):
        self._Action = params.get("Action")
        self._CidrIp = params.get("CidrIp")
        self._PortRange = params.get("PortRange")
        self._IpProtocol = params.get("IpProtocol")
        self._ServiceModule = params.get("ServiceModule")
        self._AddressModule = params.get("AddressModule")
        self._Id = params.get("Id")
        self._Desc = params.get("Desc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyConfigInfo(AbstractModel):
    r"""Access proxy configuration.

    """

    def __init__(self):
        r"""
        :param _ProxyCount: Number of database proxy group nodes. this parameter is no longer recommended. recommend using ProxyZones.
        :type ProxyCount: int
        :param _Cpu: Number of CPU cores
        :type Cpu: int
        :param _Mem: Specifies the memory.
        :type Mem: int
        :param _Description: Description.
        :type Description: str
        :param _ProxyZones: Database node information (this parameter is used in combination with ProxyCount, either one must be manually input).
        :type ProxyZones: list of ProxyZone
        """
        self._ProxyCount = None
        self._Cpu = None
        self._Mem = None
        self._Description = None
        self._ProxyZones = None

    @property
    def ProxyCount(self):
        r"""Number of database proxy group nodes. this parameter is no longer recommended. recommend using ProxyZones.
        :rtype: int
        """
        return self._ProxyCount

    @ProxyCount.setter
    def ProxyCount(self, ProxyCount):
        self._ProxyCount = ProxyCount

    @property
    def Cpu(self):
        r"""Number of CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Mem(self):
        r"""Specifies the memory.
        :rtype: int
        """
        return self._Mem

    @Mem.setter
    def Mem(self, Mem):
        self._Mem = Mem

    @property
    def Description(self):
        r"""Description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ProxyZones(self):
        r"""Database node information (this parameter is used in combination with ProxyCount, either one must be manually input).
        :rtype: list of ProxyZone
        """
        return self._ProxyZones

    @ProxyZones.setter
    def ProxyZones(self, ProxyZones):
        self._ProxyZones = ProxyZones


    def _deserialize(self, params):
        self._ProxyCount = params.get("ProxyCount")
        self._Cpu = params.get("Cpu")
        self._Mem = params.get("Mem")
        self._Description = params.get("Description")
        if params.get("ProxyZones") is not None:
            self._ProxyZones = []
            for item in params.get("ProxyZones"):
                obj = ProxyZone()
                obj._deserialize(item)
                self._ProxyZones.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyConnectionPoolInfo(AbstractModel):
    r"""Connection pool information for the database proxy

    """

    def __init__(self):
        r"""
        :param _ConnectionPoolTimeOut: Specifies the persistence threshold of the connection pool. the unit is seconds.
        :type ConnectionPoolTimeOut: int
        :param _OpenConnectionPool: Whether the connection pool is enabled.
        :type OpenConnectionPool: str
        :param _ConnectionPoolType: Specifies the connection pool type. valid values: SessionConnectionPool (session-level connection pool).
        :type ConnectionPoolType: str
        """
        self._ConnectionPoolTimeOut = None
        self._OpenConnectionPool = None
        self._ConnectionPoolType = None

    @property
    def ConnectionPoolTimeOut(self):
        r"""Specifies the persistence threshold of the connection pool. the unit is seconds.
        :rtype: int
        """
        return self._ConnectionPoolTimeOut

    @ConnectionPoolTimeOut.setter
    def ConnectionPoolTimeOut(self, ConnectionPoolTimeOut):
        self._ConnectionPoolTimeOut = ConnectionPoolTimeOut

    @property
    def OpenConnectionPool(self):
        r"""Whether the connection pool is enabled.
        :rtype: str
        """
        return self._OpenConnectionPool

    @OpenConnectionPool.setter
    def OpenConnectionPool(self, OpenConnectionPool):
        self._OpenConnectionPool = OpenConnectionPool

    @property
    def ConnectionPoolType(self):
        r"""Specifies the connection pool type. valid values: SessionConnectionPool (session-level connection pool).
        :rtype: str
        """
        return self._ConnectionPoolType

    @ConnectionPoolType.setter
    def ConnectionPoolType(self, ConnectionPoolType):
        self._ConnectionPoolType = ConnectionPoolType


    def _deserialize(self, params):
        self._ConnectionPoolTimeOut = params.get("ConnectionPoolTimeOut")
        self._OpenConnectionPool = params.get("OpenConnectionPool")
        self._ConnectionPoolType = params.get("ConnectionPoolType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyEndPointConfigInfo(AbstractModel):
    r"""proxy address configuration of the integrated cluster.

    """

    def __init__(self):
        r"""
        :param _UniqueVpcId: Specifies the ID of the VPC network it belongs to.
        :type UniqueVpcId: str
        :param _UniqueSubnetId: Subnet ID.
        :type UniqueSubnetId: str
        :param _SecurityGroupIds: Security group id array.
        :type SecurityGroupIds: list of str
        :param _WeightMode: Weight mode: system-system allocation, custom-custom.
        :type WeightMode: str
        :param _AutoAddRo: Specifies whether to automatically add a read-only instance. valid values: yes, no.
        :type AutoAddRo: str
        :param _RwType: Read-Write attribute. valid values: READWRITE, READONLY.
        :type RwType: str
        :param _InstanceNameWeights: Weight information.
        :type InstanceNameWeights: list of InstanceNameWeight
        """
        self._UniqueVpcId = None
        self._UniqueSubnetId = None
        self._SecurityGroupIds = None
        self._WeightMode = None
        self._AutoAddRo = None
        self._RwType = None
        self._InstanceNameWeights = None

    @property
    def UniqueVpcId(self):
        r"""Specifies the ID of the VPC network it belongs to.
        :rtype: str
        """
        return self._UniqueVpcId

    @UniqueVpcId.setter
    def UniqueVpcId(self, UniqueVpcId):
        self._UniqueVpcId = UniqueVpcId

    @property
    def UniqueSubnetId(self):
        r"""Subnet ID.
        :rtype: str
        """
        return self._UniqueSubnetId

    @UniqueSubnetId.setter
    def UniqueSubnetId(self, UniqueSubnetId):
        self._UniqueSubnetId = UniqueSubnetId

    @property
    def SecurityGroupIds(self):
        r"""Security group id array.
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def WeightMode(self):
        r"""Weight mode: system-system allocation, custom-custom.
        :rtype: str
        """
        return self._WeightMode

    @WeightMode.setter
    def WeightMode(self, WeightMode):
        self._WeightMode = WeightMode

    @property
    def AutoAddRo(self):
        r"""Specifies whether to automatically add a read-only instance. valid values: yes, no.
        :rtype: str
        """
        return self._AutoAddRo

    @AutoAddRo.setter
    def AutoAddRo(self, AutoAddRo):
        self._AutoAddRo = AutoAddRo

    @property
    def RwType(self):
        r"""Read-Write attribute. valid values: READWRITE, READONLY.
        :rtype: str
        """
        return self._RwType

    @RwType.setter
    def RwType(self, RwType):
        self._RwType = RwType

    @property
    def InstanceNameWeights(self):
        r"""Weight information.
        :rtype: list of InstanceNameWeight
        """
        return self._InstanceNameWeights

    @InstanceNameWeights.setter
    def InstanceNameWeights(self, InstanceNameWeights):
        self._InstanceNameWeights = InstanceNameWeights


    def _deserialize(self, params):
        self._UniqueVpcId = params.get("UniqueVpcId")
        self._UniqueSubnetId = params.get("UniqueSubnetId")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._WeightMode = params.get("WeightMode")
        self._AutoAddRo = params.get("AutoAddRo")
        self._RwType = params.get("RwType")
        if params.get("InstanceNameWeights") is not None:
            self._InstanceNameWeights = []
            for item in params.get("InstanceNameWeights"):
                obj = InstanceNameWeight()
                obj._deserialize(item)
                self._InstanceNameWeights.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyGroup(AbstractModel):
    r"""Proxy group

    """

    def __init__(self):
        r"""
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _ProxyNodeCount: Number of nodes in the proxy group
        :type ProxyNodeCount: int
        :param _Status: Database proxy group status
        :type Status: str
        :param _Region: Region
        :type Region: str
        :param _Zone: AZ
        :type Zone: str
        :param _CurrentProxyVersion: Current proxy version
        :type CurrentProxyVersion: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _AppId: User AppId
        :type AppId: int
        :param _OpenRw: Specifies that a read-write node activates the database proxy.
        :type OpenRw: str
        """
        self._ProxyGroupId = None
        self._ProxyNodeCount = None
        self._Status = None
        self._Region = None
        self._Zone = None
        self._CurrentProxyVersion = None
        self._ClusterId = None
        self._AppId = None
        self._OpenRw = None

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def ProxyNodeCount(self):
        r"""Number of nodes in the proxy group
        :rtype: int
        """
        return self._ProxyNodeCount

    @ProxyNodeCount.setter
    def ProxyNodeCount(self, ProxyNodeCount):
        self._ProxyNodeCount = ProxyNodeCount

    @property
    def Status(self):
        r"""Database proxy group status
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def CurrentProxyVersion(self):
        r"""Current proxy version
        :rtype: str
        """
        return self._CurrentProxyVersion

    @CurrentProxyVersion.setter
    def CurrentProxyVersion(self, CurrentProxyVersion):
        self._CurrentProxyVersion = CurrentProxyVersion

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AppId(self):
        r"""User AppId
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def OpenRw(self):
        r"""Specifies that a read-write node activates the database proxy.
        :rtype: str
        """
        return self._OpenRw

    @OpenRw.setter
    def OpenRw(self, OpenRw):
        self._OpenRw = OpenRw


    def _deserialize(self, params):
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._ProxyNodeCount = params.get("ProxyNodeCount")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._Zone = params.get("Zone")
        self._CurrentProxyVersion = params.get("CurrentProxyVersion")
        self._ClusterId = params.get("ClusterId")
        self._AppId = params.get("AppId")
        self._OpenRw = params.get("OpenRw")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyGroupInfo(AbstractModel):
    r"""Database proxy group details

    """

    def __init__(self):
        r"""
        :param _ProxyGroup: Database proxy group.
        :type ProxyGroup: :class:`tencentcloud.cynosdb.v20190107.models.ProxyGroup`
        :param _ProxyGroupRwInfo: Database proxy group read-write separation information.
        :type ProxyGroupRwInfo: :class:`tencentcloud.cynosdb.v20190107.models.ProxyGroupRwInfo`
        :param _ProxyNodes: Node information of the database proxy
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProxyNodes: list of ProxyNodeInfo
        :param _ConnectionPool: Database proxy connection pool information.
        :type ConnectionPool: :class:`tencentcloud.cynosdb.v20190107.models.ProxyConnectionPoolInfo`
        :param _NetAddrInfos: Network information for database proxy
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetAddrInfos: list of NetAddr
        :param _Tasks: Database proxy task set.
        :type Tasks: list of ObjectTask
        """
        self._ProxyGroup = None
        self._ProxyGroupRwInfo = None
        self._ProxyNodes = None
        self._ConnectionPool = None
        self._NetAddrInfos = None
        self._Tasks = None

    @property
    def ProxyGroup(self):
        r"""Database proxy group.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ProxyGroup`
        """
        return self._ProxyGroup

    @ProxyGroup.setter
    def ProxyGroup(self, ProxyGroup):
        self._ProxyGroup = ProxyGroup

    @property
    def ProxyGroupRwInfo(self):
        r"""Database proxy group read-write separation information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ProxyGroupRwInfo`
        """
        return self._ProxyGroupRwInfo

    @ProxyGroupRwInfo.setter
    def ProxyGroupRwInfo(self, ProxyGroupRwInfo):
        self._ProxyGroupRwInfo = ProxyGroupRwInfo

    @property
    def ProxyNodes(self):
        r"""Node information of the database proxy
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of ProxyNodeInfo
        """
        return self._ProxyNodes

    @ProxyNodes.setter
    def ProxyNodes(self, ProxyNodes):
        self._ProxyNodes = ProxyNodes

    @property
    def ConnectionPool(self):
        r"""Database proxy connection pool information.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.ProxyConnectionPoolInfo`
        """
        return self._ConnectionPool

    @ConnectionPool.setter
    def ConnectionPool(self, ConnectionPool):
        self._ConnectionPool = ConnectionPool

    @property
    def NetAddrInfos(self):
        r"""Network information for database proxy
Note: This field may return null, indicating that no valid values can be obtained.
        :rtype: list of NetAddr
        """
        return self._NetAddrInfos

    @NetAddrInfos.setter
    def NetAddrInfos(self, NetAddrInfos):
        self._NetAddrInfos = NetAddrInfos

    @property
    def Tasks(self):
        r"""Database proxy task set.
        :rtype: list of ObjectTask
        """
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks


    def _deserialize(self, params):
        if params.get("ProxyGroup") is not None:
            self._ProxyGroup = ProxyGroup()
            self._ProxyGroup._deserialize(params.get("ProxyGroup"))
        if params.get("ProxyGroupRwInfo") is not None:
            self._ProxyGroupRwInfo = ProxyGroupRwInfo()
            self._ProxyGroupRwInfo._deserialize(params.get("ProxyGroupRwInfo"))
        if params.get("ProxyNodes") is not None:
            self._ProxyNodes = []
            for item in params.get("ProxyNodes"):
                obj = ProxyNodeInfo()
                obj._deserialize(item)
                self._ProxyNodes.append(obj)
        if params.get("ConnectionPool") is not None:
            self._ConnectionPool = ProxyConnectionPoolInfo()
            self._ConnectionPool._deserialize(params.get("ConnectionPool"))
        if params.get("NetAddrInfos") is not None:
            self._NetAddrInfos = []
            for item in params.get("NetAddrInfos"):
                obj = NetAddr()
                obj._deserialize(item)
                self._NetAddrInfos.append(obj)
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = ObjectTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyGroupRwInfo(AbstractModel):
    r"""Read/write separation information of the database proxy group

    """

    def __init__(self):
        r"""
        :param _ConsistencyType: Consistency type. Valid values: `eventual` (eventual consistency), `session` (session consistency), `global` (global consistency).
        :type ConsistencyType: str
        :param _ConsistencyTimeOut: Consistency timeout period
        :type ConsistencyTimeOut: int
        :param _WeightMode: Weight mode. Valid values: `system` (auto-assigned), `custom`.
        :type WeightMode: str
        :param _FailOver: Whether to enable failover
        :type FailOver: str
        :param _AutoAddRo: Whether to automatically add read-only instance. Valid value: `yes`, `no`.
        :type AutoAddRo: str
        :param _InstanceWeights: Instance weight array
        :type InstanceWeights: list of ProxyInstanceWeight
        :param _OpenRw: Whether to enable read-write nodes. valid values: yes, no.
        :type OpenRw: str
        :param _RwType: Read/write attribute. Valid values: `READWRITE`, `READONLY`.
        :type RwType: str
        :param _TransSplit: Transaction split
        :type TransSplit: bool
        :param _AccessMode: Connection mode. Valid values: `balance`, `nearby`.
        :type AccessMode: str
        """
        self._ConsistencyType = None
        self._ConsistencyTimeOut = None
        self._WeightMode = None
        self._FailOver = None
        self._AutoAddRo = None
        self._InstanceWeights = None
        self._OpenRw = None
        self._RwType = None
        self._TransSplit = None
        self._AccessMode = None

    @property
    def ConsistencyType(self):
        r"""Consistency type. Valid values: `eventual` (eventual consistency), `session` (session consistency), `global` (global consistency).
        :rtype: str
        """
        return self._ConsistencyType

    @ConsistencyType.setter
    def ConsistencyType(self, ConsistencyType):
        self._ConsistencyType = ConsistencyType

    @property
    def ConsistencyTimeOut(self):
        r"""Consistency timeout period
        :rtype: int
        """
        return self._ConsistencyTimeOut

    @ConsistencyTimeOut.setter
    def ConsistencyTimeOut(self, ConsistencyTimeOut):
        self._ConsistencyTimeOut = ConsistencyTimeOut

    @property
    def WeightMode(self):
        r"""Weight mode. Valid values: `system` (auto-assigned), `custom`.
        :rtype: str
        """
        return self._WeightMode

    @WeightMode.setter
    def WeightMode(self, WeightMode):
        self._WeightMode = WeightMode

    @property
    def FailOver(self):
        r"""Whether to enable failover
        :rtype: str
        """
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def AutoAddRo(self):
        r"""Whether to automatically add read-only instance. Valid value: `yes`, `no`.
        :rtype: str
        """
        return self._AutoAddRo

    @AutoAddRo.setter
    def AutoAddRo(self, AutoAddRo):
        self._AutoAddRo = AutoAddRo

    @property
    def InstanceWeights(self):
        r"""Instance weight array
        :rtype: list of ProxyInstanceWeight
        """
        return self._InstanceWeights

    @InstanceWeights.setter
    def InstanceWeights(self, InstanceWeights):
        self._InstanceWeights = InstanceWeights

    @property
    def OpenRw(self):
        r"""Whether to enable read-write nodes. valid values: yes, no.
        :rtype: str
        """
        return self._OpenRw

    @OpenRw.setter
    def OpenRw(self, OpenRw):
        self._OpenRw = OpenRw

    @property
    def RwType(self):
        r"""Read/write attribute. Valid values: `READWRITE`, `READONLY`.
        :rtype: str
        """
        return self._RwType

    @RwType.setter
    def RwType(self, RwType):
        self._RwType = RwType

    @property
    def TransSplit(self):
        r"""Transaction split
        :rtype: bool
        """
        return self._TransSplit

    @TransSplit.setter
    def TransSplit(self, TransSplit):
        self._TransSplit = TransSplit

    @property
    def AccessMode(self):
        r"""Connection mode. Valid values: `balance`, `nearby`.
        :rtype: str
        """
        return self._AccessMode

    @AccessMode.setter
    def AccessMode(self, AccessMode):
        self._AccessMode = AccessMode


    def _deserialize(self, params):
        self._ConsistencyType = params.get("ConsistencyType")
        self._ConsistencyTimeOut = params.get("ConsistencyTimeOut")
        self._WeightMode = params.get("WeightMode")
        self._FailOver = params.get("FailOver")
        self._AutoAddRo = params.get("AutoAddRo")
        if params.get("InstanceWeights") is not None:
            self._InstanceWeights = []
            for item in params.get("InstanceWeights"):
                obj = ProxyInstanceWeight()
                obj._deserialize(item)
                self._InstanceWeights.append(obj)
        self._OpenRw = params.get("OpenRw")
        self._RwType = params.get("RwType")
        self._TransSplit = params.get("TransSplit")
        self._AccessMode = params.get("AccessMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyInstanceWeight(AbstractModel):
    r"""Weight ratio between read-write instances and read-only instances

    """

    def __init__(self):
        r"""
        :param _InstanceId: InstanID
        :type InstanceId: str
        :param _Weight: Instance weight
        :type Weight: int
        """
        self._InstanceId = None
        self._Weight = None

    @property
    def InstanceId(self):
        r"""InstanID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Weight(self):
        r"""Instance weight
        :rtype: int
        """
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Weight = params.get("Weight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyNodeInfo(AbstractModel):
    r"""Node in the database proxy group

    """

    def __init__(self):
        r"""
        :param _ProxyNodeId: Database proxy node ID
        :type ProxyNodeId: str
        :param _ProxyNodeConnections: Current node connections, which is not returned by the `DescribeProxyNodes` API.
        :type ProxyNodeConnections: int
        :param _Cpu: CPU of the database proxy node
        :type Cpu: int
        :param _Mem: Memory of the database proxy node
        :type Mem: int
        :param _Status: Status of the database proxy node
        :type Status: str
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _AppId: User AppID
        :type AppId: int
        :param _Region: Region
        :type Region: str
        :param _Zone: AZ
        :type Zone: str
        :param _OssProxyNodeName: 
        :type OssProxyNodeName: str
        """
        self._ProxyNodeId = None
        self._ProxyNodeConnections = None
        self._Cpu = None
        self._Mem = None
        self._Status = None
        self._ProxyGroupId = None
        self._ClusterId = None
        self._AppId = None
        self._Region = None
        self._Zone = None
        self._OssProxyNodeName = None

    @property
    def ProxyNodeId(self):
        r"""Database proxy node ID
        :rtype: str
        """
        return self._ProxyNodeId

    @ProxyNodeId.setter
    def ProxyNodeId(self, ProxyNodeId):
        self._ProxyNodeId = ProxyNodeId

    @property
    def ProxyNodeConnections(self):
        r"""Current node connections, which is not returned by the `DescribeProxyNodes` API.
        :rtype: int
        """
        return self._ProxyNodeConnections

    @ProxyNodeConnections.setter
    def ProxyNodeConnections(self, ProxyNodeConnections):
        self._ProxyNodeConnections = ProxyNodeConnections

    @property
    def Cpu(self):
        r"""CPU of the database proxy node
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Mem(self):
        r"""Memory of the database proxy node
        :rtype: int
        """
        return self._Mem

    @Mem.setter
    def Mem(self, Mem):
        self._Mem = Mem

    @property
    def Status(self):
        r"""Status of the database proxy node
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AppId(self):
        r"""User AppID
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Region(self):
        r"""Region
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Zone(self):
        r"""AZ
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def OssProxyNodeName(self):
        r"""
        :rtype: str
        """
        return self._OssProxyNodeName

    @OssProxyNodeName.setter
    def OssProxyNodeName(self, OssProxyNodeName):
        self._OssProxyNodeName = OssProxyNodeName


    def _deserialize(self, params):
        self._ProxyNodeId = params.get("ProxyNodeId")
        self._ProxyNodeConnections = params.get("ProxyNodeConnections")
        self._Cpu = params.get("Cpu")
        self._Mem = params.get("Mem")
        self._Status = params.get("Status")
        self._ProxyGroupId = params.get("ProxyGroupId")
        self._ClusterId = params.get("ClusterId")
        self._AppId = params.get("AppId")
        self._Region = params.get("Region")
        self._Zone = params.get("Zone")
        self._OssProxyNodeName = params.get("OssProxyNodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxySpec(AbstractModel):
    r"""Database proxy specifications

    """

    def __init__(self):
        r"""
        :param _Cpu: Number of database proxy CPU cores
        :type Cpu: int
        :param _Mem: Database proxy memory
        :type Mem: int
        """
        self._Cpu = None
        self._Mem = None

    @property
    def Cpu(self):
        r"""Number of database proxy CPU cores
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Mem(self):
        r"""Database proxy memory
        :rtype: int
        """
        return self._Mem

    @Mem.setter
    def Mem(self, Mem):
        self._Mem = Mem


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Mem = params.get("Mem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyVersionInfo(AbstractModel):
    r"""The proxy version information supported by TDSQL-C for MySQL.

    """

    def __init__(self):
        r"""
        :param _ProxyVersion: proxy version number.
        :type ProxyVersion: str
        :param _ProxyVersionType: Version description: GA: stable version. BETA: BETA version. DEPRECATED: outdated.
        :type ProxyVersionType: str
        """
        self._ProxyVersion = None
        self._ProxyVersionType = None

    @property
    def ProxyVersion(self):
        r"""proxy version number.
        :rtype: str
        """
        return self._ProxyVersion

    @ProxyVersion.setter
    def ProxyVersion(self, ProxyVersion):
        self._ProxyVersion = ProxyVersion

    @property
    def ProxyVersionType(self):
        r"""Version description: GA: stable version. BETA: BETA version. DEPRECATED: outdated.
        :rtype: str
        """
        return self._ProxyVersionType

    @ProxyVersionType.setter
    def ProxyVersionType(self, ProxyVersionType):
        self._ProxyVersionType = ProxyVersionType


    def _deserialize(self, params):
        self._ProxyVersion = params.get("ProxyVersion")
        self._ProxyVersionType = params.get("ProxyVersionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProxyZone(AbstractModel):
    r"""Number of proxy nodes and their AZs

    """

    def __init__(self):
        r"""
        :param _ProxyNodeZone: AZ of the proxy node
        :type ProxyNodeZone: str
        :param _ProxyNodeCount: The number of proxy nodes
        :type ProxyNodeCount: int
        """
        self._ProxyNodeZone = None
        self._ProxyNodeCount = None

    @property
    def ProxyNodeZone(self):
        r"""AZ of the proxy node
        :rtype: str
        """
        return self._ProxyNodeZone

    @ProxyNodeZone.setter
    def ProxyNodeZone(self, ProxyNodeZone):
        self._ProxyNodeZone = ProxyNodeZone

    @property
    def ProxyNodeCount(self):
        r"""The number of proxy nodes
        :rtype: int
        """
        return self._ProxyNodeCount

    @ProxyNodeCount.setter
    def ProxyNodeCount(self, ProxyNodeCount):
        self._ProxyNodeCount = ProxyNodeCount


    def _deserialize(self, params):
        self._ProxyNodeZone = params.get("ProxyNodeZone")
        self._ProxyNodeCount = params.get("ProxyNodeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryFilter(AbstractModel):
    r"""Query filter

    """

    def __init__(self):
        r"""
        :param _Names: Search field. Valid values: "InstanceId", "ProjectId", "InstanceName", "Vip"
        :type Names: list of str
        :param _Values: Search string
        :type Values: list of str
        :param _ExactMatch: Whether to use exact match
        :type ExactMatch: bool
        :param _Name: Search field
        :type Name: str
        :param _Operator: Operator
        :type Operator: str
        """
        self._Names = None
        self._Values = None
        self._ExactMatch = None
        self._Name = None
        self._Operator = None

    @property
    def Names(self):
        r"""Search field. Valid values: "InstanceId", "ProjectId", "InstanceName", "Vip"
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Values(self):
        r"""Search string
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        r"""Whether to use exact match
        :rtype: bool
        """
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch

    @property
    def Name(self):
        r"""Search field
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Operator(self):
        r"""Operator
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._Names = params.get("Names")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        self._Name = params.get("Name")
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryParamFilter(AbstractModel):
    r"""Filters for query

    """

    def __init__(self):
        r"""
        :param _Names: Search field. Valid values: "InstanceId", "ProjectId", "InstanceName", "Vip"
        :type Names: list of str
        :param _Values: Search string
        :type Values: list of str
        :param _ExactMatch: Whether to use exact match
        :type ExactMatch: bool
        """
        self._Names = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Names(self):
        r"""Search field. Valid values: "InstanceId", "ProjectId", "InstanceName", "Vip"
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Values(self):
        r"""Search string
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        r"""Whether to use exact match
        :rtype: bool
        """
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Names = params.get("Names")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefundResourcePackageRequest(AbstractModel):
    r"""RefundResourcePackage request structure.

    """

    def __init__(self):
        r"""
        :param _PackageId: The unique ID of a resource pack
        :type PackageId: str
        """
        self._PackageId = None

    @property
    def PackageId(self):
        r"""The unique ID of a resource pack
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefundResourcePackageResponse(AbstractModel):
    r"""RefundResourcePackage response structure.

    """

    def __init__(self):
        r"""
        :param _DealNames: Each item has only one `dealName`, through which you can ensure the idempotency of the delivery API.
        :type DealNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DealNames = None
        self._RequestId = None

    @property
    def DealNames(self):
        r"""Each item has only one `dealName`, through which you can ensure the idempotency of the delivery API.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DealNames = params.get("DealNames")
        self._RequestId = params.get("RequestId")


class ReloadBalanceProxyNodeRequest(AbstractModel):
    r"""ReloadBalanceProxyNode request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ProxyGroupId: Database proxy group ID
        :type ProxyGroupId: str
        """
        self._ClusterId = None
        self._ProxyGroupId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProxyGroupId(self):
        r"""Database proxy group ID
        :rtype: str
        """
        return self._ProxyGroupId

    @ProxyGroupId.setter
    def ProxyGroupId(self, ProxyGroupId):
        self._ProxyGroupId = ProxyGroupId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProxyGroupId = params.get("ProxyGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReloadBalanceProxyNodeResponse(AbstractModel):
    r"""ReloadBalanceProxyNode response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async flow ID
        :type FlowId: int
        :param _TaskId: Async task ID
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._TaskId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async flow ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def TaskId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class RemoveClusterSlaveZoneRequest(AbstractModel):
    r"""RemoveClusterSlaveZone request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _SlaveZone: Replica AZ
        :type SlaveZone: str
        """
        self._ClusterId = None
        self._SlaveZone = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SlaveZone(self):
        r"""Replica AZ
        :rtype: str
        """
        return self._SlaveZone

    @SlaveZone.setter
    def SlaveZone(self, SlaveZone):
        self._SlaveZone = SlaveZone


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SlaveZone = params.get("SlaveZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveClusterSlaveZoneResponse(AbstractModel):
    r"""RemoveClusterSlaveZone response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async FlowId
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async FlowId
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class RenewClustersRequest(AbstractModel):
    r"""RenewClusters request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _TimeSpan: Renewal period.
        :type TimeSpan: float
        :param _TimeUnit: Time unit, such as y, m, d, h, i, and s.
        :type TimeUnit: str
        :param _DealMode: "Transaction mode. 	0 - place an order and pay; 1 - place an order."
        :type DealMode: int
        """
        self._ClusterId = None
        self._TimeSpan = None
        self._TimeUnit = None
        self._DealMode = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def TimeSpan(self):
        r"""Renewal period.
        :rtype: float
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        r"""Time unit, such as y, m, d, h, i, and s.
        :rtype: str
        """
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def DealMode(self):
        r""""Transaction mode. 	0 - place an order and pay; 1 - place an order."
        :rtype: int
        """
        return self._DealMode

    @DealMode.setter
    def DealMode(self, DealMode):
        self._DealMode = DealMode


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._DealMode = params.get("DealMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RenewClustersResponse(AbstractModel):
    r"""RenewClusters response structure.

    """

    def __init__(self):
        r"""
        :param _BigDealIds: Prepaid total order number.
        :type BigDealIds: list of str
        :param _DealNames: Refund order number.
        :type DealNames: list of str
        :param _TranId: Frozen flow. One frozen flow is activated at a time.
        :type TranId: str
        :param _ResourceIds: Delivery resource id list corresponding to each order number.
        :type ResourceIds: list of str
        :param _ClusterIds: List of Cluster IDs
        :type ClusterIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BigDealIds = None
        self._DealNames = None
        self._TranId = None
        self._ResourceIds = None
        self._ClusterIds = None
        self._RequestId = None

    @property
    def BigDealIds(self):
        r"""Prepaid total order number.
        :rtype: list of str
        """
        return self._BigDealIds

    @BigDealIds.setter
    def BigDealIds(self, BigDealIds):
        self._BigDealIds = BigDealIds

    @property
    def DealNames(self):
        r"""Refund order number.
        :rtype: list of str
        """
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def TranId(self):
        r"""Frozen flow. One frozen flow is activated at a time.
        :rtype: str
        """
        return self._TranId

    @TranId.setter
    def TranId(self, TranId):
        self._TranId = TranId

    @property
    def ResourceIds(self):
        r"""Delivery resource id list corresponding to each order number.
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ClusterIds(self):
        r"""List of Cluster IDs
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BigDealIds = params.get("BigDealIds")
        self._DealNames = params.get("DealNames")
        self._TranId = params.get("TranId")
        self._ResourceIds = params.get("ResourceIds")
        self._ClusterIds = params.get("ClusterIds")
        self._RequestId = params.get("RequestId")


class ReplayInstanceAuditLogRequest(AbstractModel):
    r"""ReplayInstanceAuditLog request structure.

    """

    def __init__(self):
        r"""
        :param _SourceClusterId: Source cluster id.
        :type SourceClusterId: str
        :param _SourceInstanceId: Source instance id.
        :type SourceInstanceId: str
        :param _TargetClusterId: Target cluster id.
Specifies the target cluster must be a cluster cloned from the original cluster within three days.
        :type TargetClusterId: str
        :param _TargetInstanceId: Target instance id.
        :type TargetInstanceId: str
        :param _TargetUserName: Username. host must be % username.
        :type TargetUserName: str
        :param _TargetPassword: Password.
        :type TargetPassword: str
        :param _StartTime: Start time. time format: yyyy-DD-mm hh:mm:ss.
        :type StartTime: str
        :param _EndTime: Specifies the end time in the time format yyyy-DD-mm hh:mm:ss.
        :type EndTime: str
        """
        self._SourceClusterId = None
        self._SourceInstanceId = None
        self._TargetClusterId = None
        self._TargetInstanceId = None
        self._TargetUserName = None
        self._TargetPassword = None
        self._StartTime = None
        self._EndTime = None

    @property
    def SourceClusterId(self):
        r"""Source cluster id.
        :rtype: str
        """
        return self._SourceClusterId

    @SourceClusterId.setter
    def SourceClusterId(self, SourceClusterId):
        self._SourceClusterId = SourceClusterId

    @property
    def SourceInstanceId(self):
        r"""Source instance id.
        :rtype: str
        """
        return self._SourceInstanceId

    @SourceInstanceId.setter
    def SourceInstanceId(self, SourceInstanceId):
        self._SourceInstanceId = SourceInstanceId

    @property
    def TargetClusterId(self):
        r"""Target cluster id.
Specifies the target cluster must be a cluster cloned from the original cluster within three days.
        :rtype: str
        """
        return self._TargetClusterId

    @TargetClusterId.setter
    def TargetClusterId(self, TargetClusterId):
        self._TargetClusterId = TargetClusterId

    @property
    def TargetInstanceId(self):
        r"""Target instance id.
        :rtype: str
        """
        return self._TargetInstanceId

    @TargetInstanceId.setter
    def TargetInstanceId(self, TargetInstanceId):
        self._TargetInstanceId = TargetInstanceId

    @property
    def TargetUserName(self):
        r"""Username. host must be % username.
        :rtype: str
        """
        return self._TargetUserName

    @TargetUserName.setter
    def TargetUserName(self, TargetUserName):
        self._TargetUserName = TargetUserName

    @property
    def TargetPassword(self):
        r"""Password.
        :rtype: str
        """
        return self._TargetPassword

    @TargetPassword.setter
    def TargetPassword(self, TargetPassword):
        self._TargetPassword = TargetPassword

    @property
    def StartTime(self):
        r"""Start time. time format: yyyy-DD-mm hh:mm:ss.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""Specifies the end time in the time format yyyy-DD-mm hh:mm:ss.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._SourceClusterId = params.get("SourceClusterId")
        self._SourceInstanceId = params.get("SourceInstanceId")
        self._TargetClusterId = params.get("TargetClusterId")
        self._TargetInstanceId = params.get("TargetInstanceId")
        self._TargetUserName = params.get("TargetUserName")
        self._TargetPassword = params.get("TargetPassword")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReplayInstanceAuditLogResponse(AbstractModel):
    r"""ReplayInstanceAuditLog response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        r"""Task ID.
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ResetAccountPasswordRequest(AbstractModel):
    r"""ResetAccountPassword request structure.

    """

    def __init__(self):
        r"""
        :param _AccountName: Database account name
        :type AccountName: str
        :param _AccountPassword: New password of the database account
        :type AccountPassword: str
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Host: Host. Default value: `%`
        :type Host: str
        """
        self._AccountName = None
        self._AccountPassword = None
        self._ClusterId = None
        self._Host = None

    @property
    def AccountName(self):
        r"""Database account name
        :rtype: str
        """
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def AccountPassword(self):
        r"""New password of the database account
        :rtype: str
        """
        return self._AccountPassword

    @AccountPassword.setter
    def AccountPassword(self, AccountPassword):
        self._AccountPassword = AccountPassword

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Host(self):
        r"""Host. Default value: `%`
        :rtype: str
        """
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host


    def _deserialize(self, params):
        self._AccountName = params.get("AccountName")
        self._AccountPassword = params.get("AccountPassword")
        self._ClusterId = params.get("ClusterId")
        self._Host = params.get("Host")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetAccountPasswordResponse(AbstractModel):
    r"""ResetAccountPassword response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResourcePackage(AbstractModel):
    r"""Information of a resource pack

    """

    def __init__(self):
        r"""
        :param _PackageId: The unique ID of the resource package.
        :type PackageId: str
        :param _PackageType: Resource package type: CCU: compute resource package.
DISK: storage resource package.
        :type PackageType: str
        :param _DeductionPriority: Deduction priority of the current resource package bound to the current instance.
        :type DeductionPriority: int
        """
        self._PackageId = None
        self._PackageType = None
        self._DeductionPriority = None

    @property
    def PackageId(self):
        r"""The unique ID of the resource package.
        :rtype: str
        """
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def PackageType(self):
        r"""Resource package type: CCU: compute resource package.
DISK: storage resource package.
        :rtype: str
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def DeductionPriority(self):
        r"""Deduction priority of the current resource package bound to the current instance.
        :rtype: int
        """
        return self._DeductionPriority

    @DeductionPriority.setter
    def DeductionPriority(self, DeductionPriority):
        self._DeductionPriority = DeductionPriority


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._PackageType = params.get("PackageType")
        self._DeductionPriority = params.get("DeductionPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartInstanceRequest(AbstractModel):
    r"""RestartInstance request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""Instance ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartInstanceResponse(AbstractModel):
    r"""RestartInstance response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async task ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class ResumeServerlessRequest(AbstractModel):
    r"""ResumeServerless request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""Cluster ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResumeServerlessResponse(AbstractModel):
    r"""ResumeServerless response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Async task ID
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Async task ID
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class RollBackClusterRequest(AbstractModel):
    r"""RollBackCluster request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID.
        :type ClusterId: str
        :param _RollbackStrategy: Rollback policy. timeRollback - roll back by time point; snapRollback - roll back by backup file.
        :type RollbackStrategy: str
        :param _RollbackId: Backup file ID. This parameter is required when the rollback policy is rolling back by backup file.
        :type RollbackId: int
        :param _ExpectTime: Expected rollback time. This parameter is required when the rollback policy is timeRollback (roll back by time point).
        :type ExpectTime: str
        :param _ExpectTimeThresh: Expected threshold (deprecated).
        :type ExpectTimeThresh: int
        :param _RollbackDatabases: List of rollback databases.
        :type RollbackDatabases: list of RollbackDatabase
        :param _RollbackTables: List of rollback databases and tables.
        :type RollbackTables: list of RollbackTable
        :param _RollbackMode: Mode of rolling back by time point. full: normal; db: fast; table: ultra-fast (the default value is normal).
        :type RollbackMode: str
        """
        self._ClusterId = None
        self._RollbackStrategy = None
        self._RollbackId = None
        self._ExpectTime = None
        self._ExpectTimeThresh = None
        self._RollbackDatabases = None
        self._RollbackTables = None
        self._RollbackMode = None

    @property
    def ClusterId(self):
        r"""Cluster ID.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RollbackStrategy(self):
        r"""Rollback policy. timeRollback - roll back by time point; snapRollback - roll back by backup file.
        :rtype: str
        """
        return self._RollbackStrategy

    @RollbackStrategy.setter
    def RollbackStrategy(self, RollbackStrategy):
        self._RollbackStrategy = RollbackStrategy

    @property
    def RollbackId(self):
        r"""Backup file ID. This parameter is required when the rollback policy is rolling back by backup file.
        :rtype: int
        """
        return self._RollbackId

    @RollbackId.setter
    def RollbackId(self, RollbackId):
        self._RollbackId = RollbackId

    @property
    def ExpectTime(self):
        r"""Expected rollback time. This parameter is required when the rollback policy is timeRollback (roll back by time point).
        :rtype: str
        """
        return self._ExpectTime

    @ExpectTime.setter
    def ExpectTime(self, ExpectTime):
        self._ExpectTime = ExpectTime

    @property
    def ExpectTimeThresh(self):
        r"""Expected threshold (deprecated).
        :rtype: int
        """
        return self._ExpectTimeThresh

    @ExpectTimeThresh.setter
    def ExpectTimeThresh(self, ExpectTimeThresh):
        self._ExpectTimeThresh = ExpectTimeThresh

    @property
    def RollbackDatabases(self):
        r"""List of rollback databases.
        :rtype: list of RollbackDatabase
        """
        return self._RollbackDatabases

    @RollbackDatabases.setter
    def RollbackDatabases(self, RollbackDatabases):
        self._RollbackDatabases = RollbackDatabases

    @property
    def RollbackTables(self):
        r"""List of rollback databases and tables.
        :rtype: list of RollbackTable
        """
        return self._RollbackTables

    @RollbackTables.setter
    def RollbackTables(self, RollbackTables):
        self._RollbackTables = RollbackTables

    @property
    def RollbackMode(self):
        r"""Mode of rolling back by time point. full: normal; db: fast; table: ultra-fast (the default value is normal).
        :rtype: str
        """
        return self._RollbackMode

    @RollbackMode.setter
    def RollbackMode(self, RollbackMode):
        self._RollbackMode = RollbackMode


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RollbackStrategy = params.get("RollbackStrategy")
        self._RollbackId = params.get("RollbackId")
        self._ExpectTime = params.get("ExpectTime")
        self._ExpectTimeThresh = params.get("ExpectTimeThresh")
        if params.get("RollbackDatabases") is not None:
            self._RollbackDatabases = []
            for item in params.get("RollbackDatabases"):
                obj = RollbackDatabase()
                obj._deserialize(item)
                self._RollbackDatabases.append(obj)
        if params.get("RollbackTables") is not None:
            self._RollbackTables = []
            for item in params.get("RollbackTables"):
                obj = RollbackTable()
                obj._deserialize(item)
                self._RollbackTables.append(obj)
        self._RollbackMode = params.get("RollbackMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollBackClusterResponse(AbstractModel):
    r"""RollBackCluster response structure.

    """

    def __init__(self):
        r"""
        :param _FlowId: Task flow ID.
        :type FlowId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlowId = None
        self._RequestId = None

    @property
    def FlowId(self):
        r"""Task flow ID.
        :rtype: int
        """
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def RequestId(self):
        r"""The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._RequestId = params.get("RequestId")


class RollbackData(AbstractModel):
    r"""

    """

    def __init__(self):
        r"""
        :param _Cpu: 
        :type Cpu: int
        :param _Memory: 
        :type Memory: int
        :param _StorageLimit: 
        :type StorageLimit: int
        :param _OriginalClusterId: 
        :type OriginalClusterId: str
        :param _OriginalClusterName: 
        :type OriginalClusterName: str
        :param _RollbackStrategy: 
        :type RollbackStrategy: str
        :param _SnapshotTime: 
        :type SnapshotTime: str
        :param _MinCpu: Minimum CPU when rolling back to a serverlessls cluster.
        :type MinCpu: int
        :param _MaxCpu: Maximum CPU when rolling back to a serverlessls cluster.
        :type MaxCpu: int
        :param _SnapShotId: Snapshot ID.
        :type SnapShotId: int
        :param _RollbackDatabases: 
        :type RollbackDatabases: list of RollbackDatabase
        :param _RollbackTables: 
        :type RollbackTables: list of RollbackTable
        :param _BackupFileName: Specifies the backup file name.
        :type BackupFileName: str
        :param _RollbackProcess: Rollback process.
        :type RollbackProcess: :class:`tencentcloud.cynosdb.v20190107.models.RollbackProcessInfo`
        """
        self._Cpu = None
        self._Memory = None
        self._StorageLimit = None
        self._OriginalClusterId = None
        self._OriginalClusterName = None
        self._RollbackStrategy = None
        self._SnapshotTime = None
        self._MinCpu = None
        self._MaxCpu = None
        self._SnapShotId = None
        self._RollbackDatabases = None
        self._RollbackTables = None
        self._BackupFileName = None
        self._RollbackProcess = None

    @property
    def Cpu(self):
        r"""
        :rtype: int
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def StorageLimit(self):
        r"""
        :rtype: int
        """
        return self._StorageLimit

    @StorageLimit.setter
    def StorageLimit(self, StorageLimit):
        self._StorageLimit = StorageLimit

    @property
    def OriginalClusterId(self):
        r"""
        :rtype: str
        """
        return self._OriginalClusterId

    @OriginalClusterId.setter
    def OriginalClusterId(self, OriginalClusterId):
        self._OriginalClusterId = OriginalClusterId

    @property
    def OriginalClusterName(self):
        r"""
        :rtype: str
        """
        return self._OriginalClusterName

    @OriginalClusterName.setter
    def OriginalClusterName(self, OriginalClusterName):
        self._OriginalClusterName = OriginalClusterName

    @property
    def RollbackStrategy(self):
        r"""
        :rtype: str
        """
        return self._RollbackStrategy

    @RollbackStrategy.setter
    def RollbackStrategy(self, RollbackStrategy):
        self._RollbackStrategy = RollbackStrategy

    @property
    def SnapshotTime(self):
        r"""
        :rtype: str
        """
        return self._SnapshotTime

    @SnapshotTime.setter
    def SnapshotTime(self, SnapshotTime):
        self._SnapshotTime = SnapshotTime

    @property
    def MinCpu(self):
        r"""Minimum CPU when rolling back to a serverlessls cluster.
        :rtype: int
        """
        return self._MinCpu

    @MinCpu.setter
    def MinCpu(self, MinCpu):
        self._MinCpu = MinCpu

    @property
    def MaxCpu(self):
        r"""Maximum CPU when rolling back to a serverlessls cluster.
        :rtype: int
        """
        return self._MaxCpu

    @MaxCpu.setter
    def MaxCpu(self, MaxCpu):
        self._MaxCpu = MaxCpu

    @property
    def SnapShotId(self):
        r"""Snapshot ID.
        :rtype: int
        """
        return self._SnapShotId

    @SnapShotId.setter
    def SnapShotId(self, SnapShotId):
        self._SnapShotId = SnapShotId

    @property
    def RollbackDatabases(self):
        r"""
        :rtype: list of RollbackDatabase
        """
        return self._RollbackDatabases

    @RollbackDatabases.setter
    def RollbackDatabases(self, RollbackDatabases):
        self._RollbackDatabases = RollbackDatabases

    @property
    def RollbackTables(self):
        r"""
        :rtype: list of RollbackTable
        """
        return self._RollbackTables

    @RollbackTables.setter
    def RollbackTables(self, RollbackTables):
        self._RollbackTables = RollbackTables

    @property
    def BackupFileName(self):
        r"""Specifies the backup file name.
        :rtype: str
        """
        return self._BackupFileName

    @BackupFileName.setter
    def BackupFileName(self, BackupFileName):
        self._BackupFileName = BackupFileName

    @property
    def RollbackProcess(self):
        r"""Rollback process.
        :rtype: :class:`tencentcloud.cynosdb.v20190107.models.RollbackProcessInfo`
        """
        return self._RollbackProcess

    @RollbackProcess.setter
    def RollbackProcess(self, RollbackProcess):
        self._RollbackProcess = RollbackProcess


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._StorageLimit = params.get("StorageLimit")
        self._OriginalClusterId = params.get("OriginalClusterId")
        self._OriginalClusterName = params.get("OriginalClusterName")
        self._RollbackStrategy = params.get("RollbackStrategy")
        self._SnapshotTime = params.get("SnapshotTime")
        self._MinCpu = params.get("MinCpu")
        self._MaxCpu = params.get("MaxCpu")
        self._SnapShotId = params.get("SnapShotId")
        if params.get("RollbackDatabases") is not None:
            self._RollbackDatabases = []
            for item in params.get("RollbackDatabases"):
                obj = RollbackDatabase()
                obj._deserialize(item)
                self._RollbackDatabases.append(obj)
        if params.get("RollbackTables") is not None:
            self._RollbackTables = []
            for item in params.get("RollbackTables"):
                obj = RollbackTable()
                obj._deserialize(item)
                self._RollbackTables.append(obj)
        self._BackupFileName = params.get("BackupFileName")
        if params.get("RollbackProcess") is not None:
            self._RollbackProcess = RollbackProcessInfo()
            self._RollbackProcess._deserialize(params.get("RollbackProcess"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
        